#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef MOST_PHONBK_FI_H
#define MOST_PHONBK_FI_H

#include "asf/cca/CcaTypes.h"
#include "asf/cca/CcaTypesConst.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "fi_basetypes_most.h"
#include "fi_basetypes_mostConst.h"
#include "most_FavPrv_fi_types.h"
#include "most_FavPrv_fi_typesConst.h"
#include "most_PhonBk_fi_types.h"
#include "most_PhonBk_fi_typesConst.h"
#include "most_PhonBk_fi_types_Extended.h"
#include "most_PhonBk_fi_types_ExtendedConst.h"
#include <cstring>
#include <vector>

/**
 * CCA Functional Interface 'MOST_PhonBk_FI'
 *
 * Fullname: Proprietary - PhoneBook
 *
 * Version: 3.0
 *
 * Author: Dave Pop, General Motors
 *
 * Date: 2012-04-04
 *
 * Department:
 *
 * Title:
 *             MOST_PhoneBook_FI
 *
 * <b>Description of 'MOST_PhonBk_FI':</b>
 *
 * <p>This FBlock was assembled from FBlockManifest file: PhoneBook.fblockman, Please consult individual interface files for interface-specific change history.</p>
 * The PhoneBook FBlock handles the contacts in customer portable devices, generally portable Bluetooth phones.  The PhoneBook contains functions for sorting, browsing, and retrieving contact information within the phone book of a portable device.
 * The PhoneBook FBlock implements the IPhoneBook and IFavoritesProvider interfaces.  IPhoneBook contains functions that are used by HMI controllers to control the PhoneBook and retrieve contact information.  IFavoritesProvider is implemented to support such favorites behaviors as speed dialing a particular contact or automatically routing to a contact address using the on-board navigation system.
 * See GIS-367 for detailed feature and dynamic requirements for the PhoneBook FBlock.
 */

namespace MOST_PhonBk_FI {

static const int SERVICE_ID = 569;

static const int FID_FavoritesChanged = 3076;

static const int FID_ListChange = 518;

static const int FID_MissedCallIndicator = 530;

static const int FID_DevicePhoneBookFeatureSupport = 545;

static const int FID_PreferredPhoneBookSortOrder = 547;

static const int FID_DownloadState = 549;

static const int FID_StoreFavorite = 3072;

static const int FID_ActivateFavorite = 3073;

static const int FID_DeleteFavorite = 3074;

static const int FID_GetFavoriteInfo = 3075;

static const int FID_ResetFavorites = 3077;

static const int FID_CreatePhoneBookList = 512;

static const int FID_SearchKeyboardPhoneBookList = 514;

static const int FID_ReleasePhoneBookList = 515;

static const int FID_GetContactDetails = 516;

static const int FID_GetContactPhoto = 517;

static const int FID_AddContact = 519;

static const int FID_DeleteContact = 520;

static const int FID_EditContact = 521;

static const int FID_CreateCallHistoryList = 528;

static const int FID_RequestSliceCallHistoryList = 529;

static const int FID_ClearMissedCallIndicator = 531;

static const int FID_SearchPhoneBook = 532;

static const int FID_ReleaseCallHistoryList = 534;

static const int FID_GetContactPhotoInfo = 535;

static const int FID_GetDeviceCallHistorySupport = 536;

static const int FID_AutocompletePhoneNumberEntry = 537;

static const int FID_ClearPhoneBookData = 538;

static const int FID_RequestPhoneBookListSlice = 546;

static const int FID_ClearVehiclePhoneBook = 548;

static const int FID_RequestSliceCallHistoryListExtended = 3872;

static const int FID_RequestPhoneBookListSliceExtended = 3873;

static const int FID_SearchContacts = 3875;

static const int FID_StartPbDownload = 3877;

static const int FID_SwitchDownloadOnOffState = 3880;

static const int FID_CreateContactList = 3881;

static const int FID_SetContactPhoto = 3888;

static const int FID_CancelPbDownload = 3889;

static const int FID_SetContactPosition = 3890;

static const int FID_AddContactExtended = 3891;

static const int FID_EditContactExtended = 3892;

static const int FID_GetContactDetailsExtended = 3893;

static const int FID_ClearVehiclePhonebookExtended = 3894;

static const int FID_SetAutomaticContactDownload = 3895;

static const int FID_GetPositionForContactHandle = 3897;

static const int FID_DownloadStateExtended = 3874;

static const int FID_DownloadProgress = 3876;

static const int FID_DownloadProgressList = 3905;

static const int FID_DownloadOnOffList = 3879;

static const int FID_AutomaticContactDownloadList = 3896;

static const int FID_DevicePhoneBookFeatureSupportExtended = 3878;

static const int FID_ProbablyLockedDevices = 3904;

static const int FID_MissedCallIndicatorList = 3906;

static const int FID_PreferredSortOrderList = 3907;

static const int FID_PhonebookLanguage = 3908;

static const int FID_MaxContactCount = 3909;


ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 3;

static const int VERSION_MINOR = 0;

static const int VERSION_PATCH = 0;

// forward declarations
class FavoritesChangedStatus;

class ListChangeStatus;

class MissedCallIndicatorStatus;

class DevicePhoneBookFeatureSupportStatus;

class DevicePhoneBookFeatureSupportErrorStructure;

class DevicePhoneBookFeatureSupportError;

class PreferredPhoneBookSortOrderStatus;

class PreferredPhoneBookSortOrderPureSet;

class PreferredPhoneBookSortOrderErrorStructure;

class PreferredPhoneBookSortOrderError;

class DownloadStateStatus;

class DownloadStateErrorStructure;

class DownloadStateError;

class StoreFavoriteStart;

class StoreFavoriteResult;

class StoreFavoriteErrorStructure;

class StoreFavoriteError;

class ActivateFavoriteStart;

class ActivateFavoriteResult;

class ActivateFavoriteErrorStructure;

class ActivateFavoriteError;

class DeleteFavoriteStart;

class DeleteFavoriteResult;

class DeleteFavoriteErrorStructure;

class DeleteFavoriteError;

class GetFavoriteInfoStart;

class GetFavoriteInfoResult;

class GetFavoriteInfoErrorStructure;

class GetFavoriteInfoError;

class ResetFavoritesErrorStructure;

class ResetFavoritesError;

class CreatePhoneBookListStart;

class CreatePhoneBookListResult;

class CreatePhoneBookListErrorStructure;

class CreatePhoneBookListError;

class SearchKeyboardPhoneBookListStart;

class SearchKeyboardPhoneBookListResult;

class SearchKeyboardPhoneBookListErrorStructure;

class SearchKeyboardPhoneBookListError;

class ReleasePhoneBookListStart;

class ReleasePhoneBookListResult;

class ReleasePhoneBookListErrorStructure;

class ReleasePhoneBookListError;

class GetContactDetailsStart;

class GetContactDetailsResult;

class GetContactDetailsErrorStructure;

class GetContactDetailsError;

class GetContactPhotoStart;

class GetContactPhotoResult;

class GetContactPhotoErrorStructure;

class GetContactPhotoError;

class AddContactStart;

class AddContactResult;

class AddContactErrorStructure;

class AddContactError;

class DeleteContactStart;

class DeleteContactResult;

class DeleteContactErrorStructure;

class DeleteContactError;

class EditContactStart;

class EditContactResult;

class EditContactErrorStructure;

class EditContactError;

class CreateCallHistoryListStart;

class CreateCallHistoryListResult;

class CreateCallHistoryListErrorStructure;

class CreateCallHistoryListError;

class RequestSliceCallHistoryListStart;

class RequestSliceCallHistoryListResult;

class RequestSliceCallHistoryListErrorStructure;

class RequestSliceCallHistoryListError;

class ClearMissedCallIndicatorStart;

class ClearMissedCallIndicatorResult;

class ClearMissedCallIndicatorErrorStructure;

class ClearMissedCallIndicatorError;

class SearchPhoneBookStart;

class SearchPhoneBookResult;

class SearchPhoneBookErrorStructure;

class SearchPhoneBookError;

class ReleaseCallHistoryListStart;

class ReleaseCallHistoryListResult;

class ReleaseCallHistoryListErrorStructure;

class ReleaseCallHistoryListError;

class GetContactPhotoInfoStart;

class GetContactPhotoInfoResult;

class GetContactPhotoInfoErrorStructure;

class GetContactPhotoInfoError;

class GetDeviceCallHistorySupportStart;

class GetDeviceCallHistorySupportResult;

class GetDeviceCallHistorySupportErrorStructure;

class GetDeviceCallHistorySupportError;

class AutocompletePhoneNumberEntryStart;

class AutocompletePhoneNumberEntryResult;

class AutocompletePhoneNumberEntryErrorStructure;

class AutocompletePhoneNumberEntryError;

class ClearPhoneBookDataResult;

class ClearPhoneBookDataErrorStructure;

class ClearPhoneBookDataError;

class RequestPhoneBookListSliceStart;

class RequestPhoneBookListSliceResult;

class RequestPhoneBookListSliceErrorStructure;

class RequestPhoneBookListSliceError;

class ClearVehiclePhoneBookResult;

class ClearVehiclePhoneBookErrorStructure;

class ClearVehiclePhoneBookError;

class RequestSliceCallHistoryListExtendedStart;

class RequestSliceCallHistoryListExtendedResult;

class RequestSliceCallHistoryListExtendedErrorStructure;

class RequestSliceCallHistoryListExtendedError;

class RequestPhoneBookListSliceExtendedStart;

class RequestPhoneBookListSliceExtendedResult;

class RequestPhoneBookListSliceExtendedErrorStructure;

class RequestPhoneBookListSliceExtendedError;

class SearchContactsStart;

class SearchContactsResult;

class SearchContactsErrorStructure;

class SearchContactsError;

class StartPbDownloadStart;

class StartPbDownloadResult;

class StartPbDownloadErrorStructure;

class StartPbDownloadError;

class SwitchDownloadOnOffStateStart;

class SwitchDownloadOnOffStateResult;

class SwitchDownloadOnOffStateErrorStructure;

class SwitchDownloadOnOffStateError;

class CreateContactListStart;

class CreateContactListResult;

class CreateContactListErrorStructure;

class CreateContactListError;

class SetContactPhotoStart;

class SetContactPhotoResult;

class SetContactPhotoErrorStructure;

class SetContactPhotoError;

class CancelPbDownloadStart;

class CancelPbDownloadResult;

class CancelPbDownloadErrorStructure;

class CancelPbDownloadError;

class SetContactPositionStart;

class SetContactPositionResult;

class SetContactPositionErrorStructure;

class SetContactPositionError;

class AddContactExtendedStart;

class AddContactExtendedResult;

class AddContactExtendedErrorStructure;

class AddContactExtendedError;

class EditContactExtendedStart;

class EditContactExtendedResult;

class EditContactExtendedErrorStructure;

class EditContactExtendedError;

class GetContactDetailsExtendedStart;

class GetContactDetailsExtendedResult;

class GetContactDetailsExtendedErrorStructure;

class GetContactDetailsExtendedError;

class ClearVehiclePhonebookExtendedStart;

class ClearVehiclePhonebookExtendedResult;

class ClearVehiclePhonebookExtendedErrorStructure;

class ClearVehiclePhonebookExtendedError;

class SetAutomaticContactDownloadStart;

class SetAutomaticContactDownloadResult;

class SetAutomaticContactDownloadErrorStructure;

class SetAutomaticContactDownloadError;

class GetPositionForContactHandleStart;

class GetPositionForContactHandleResult;

class GetPositionForContactHandleErrorStructure;

class GetPositionForContactHandleError;

class DownloadStateExtendedStatus;

class DownloadStateExtendedErrorStructure;

class DownloadStateExtendedError;

class DownloadProgressStatus;

class DownloadProgressErrorStructure;

class DownloadProgressError;

class DownloadProgressListStatus;

class DownloadProgressListErrorStructure;

class DownloadProgressListError;

class DownloadOnOffListStatus;

class DownloadOnOffListErrorStructure;

class DownloadOnOffListError;

class AutomaticContactDownloadListStatus;

class AutomaticContactDownloadListErrorStructure;

class AutomaticContactDownloadListError;

class DevicePhoneBookFeatureSupportExtendedStatus;

class DevicePhoneBookFeatureSupportExtendedErrorStructure;

class DevicePhoneBookFeatureSupportExtendedError;

class ProbablyLockedDevicesStatus;

class ProbablyLockedDevicesErrorStructure;

class ProbablyLockedDevicesError;

class MissedCallIndicatorListStatus;

class MissedCallIndicatorListErrorStructure;

class MissedCallIndicatorListError;

class PreferredSortOrderListStatus;

class PreferredSortOrderListPureSet;

class PreferredSortOrderListErrorStructure;

class PreferredSortOrderListError;

class PhonebookLanguageStatus;

class PhonebookLanguageSet;

class PhonebookLanguageErrorStructure;

class PhonebookLanguageError;

class MaxContactCountStatus;

class MaxContactCountErrorStructure;

class MaxContactCountError;

// type definitions
/**
 * The upreg message of the property "FavoritesChanged"
 * The FavoritesChanged property provides notification about changes that
 * occurred to the stored favorites. These changes include:
 *
 *
 * <item>
 * Addition of a new favorite
 * </item>
 * <item>
 * Deletion of a favorite
 * </item>
 * <item>
 * Change of any of the information in the FavoriteInfo record for a
 * favorite
 * </item>
 * <item>
 * Determination of all the FavoriteInfo for each stored favorite after
 * system initialization
 * </item>
 *
 * <p>
 * The ListChangeType = LCH_CONTENT_CHANGED when the FavoriteInfo record
 * elements have been determined for all stored favorites after system
 * initialization.
 * </p>
 * <p>
 * If the ListChangeType = LCH_CONTENT_CHANGED, i.e. the entire list
 * changed, then NumItems = 0 and the ChangedFavorites array is empty.
 * </p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FavoritesChangedUpReg;

/**
 * The relUpReg message of the property "FavoritesChanged"
 * The FavoritesChanged property provides notification about changes that
 * occurred to the stored favorites. These changes include:
 *
 *
 * <item>
 * Addition of a new favorite
 * </item>
 * <item>
 * Deletion of a favorite
 * </item>
 * <item>
 * Change of any of the information in the FavoriteInfo record for a
 * favorite
 * </item>
 * <item>
 * Determination of all the FavoriteInfo for each stored favorite after
 * system initialization
 * </item>
 *
 * <p>
 * The ListChangeType = LCH_CONTENT_CHANGED when the FavoriteInfo record
 * elements have been determined for all stored favorites after system
 * initialization.
 * </p>
 * <p>
 * If the ListChangeType = LCH_CONTENT_CHANGED, i.e. the entire list
 * changed, then NumItems = 0 and the ChangedFavorites array is empty.
 * </p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FavoritesChangedRelUpReg;

/**
 * The error message of 'FavoritesChanged'
 */
typedef ::asf::cca::CcaTypes::DefaultError FavoritesChangedError;

/**
 * The upreg message of the property "ListChange"
 * The ListChange property provides notifications about changes that occur in
 * a created list. These changes include:
 *
 *
 * <item>
 * Complete change in items
 * </item>
 * <item>
 * Items changed
 * </item>
 * <item>
 * Items added
 * </item>
 * <item>
 * Items deleted
 * </item>
 *
 * <p>
 * &#160;
 * </p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ListChangeUpReg;

/**
 * The relUpReg message of the property "ListChange"
 * The ListChange property provides notifications about changes that occur in
 * a created list. These changes include:
 *
 *
 * <item>
 * Complete change in items
 * </item>
 * <item>
 * Items changed
 * </item>
 * <item>
 * Items added
 * </item>
 * <item>
 * Items deleted
 * </item>
 *
 * <p>
 * &#160;
 * </p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ListChangeRelUpReg;

/**
 * The error message of 'ListChange'
 */
typedef ::asf::cca::CcaTypes::DefaultError ListChangeError;

/**
 * The upreg message of the property "MissedCallIndicator"
 * Provides the number of missed calls that occur while the current Outgoing Source Device is connected in the vehicle. The number of missed calls is always zero upon connection to the Outgoing Source Device. As missed calls occur while the Outgoing Source Device is connected in the vehicle the NumMissedCalls is incremented to reflect the number of calls that have been missed.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MissedCallIndicatorUpReg;

/**
 * The relUpReg message of the property "MissedCallIndicator"
 * Provides the number of missed calls that occur while the current Outgoing Source Device is connected in the vehicle. The number of missed calls is always zero upon connection to the Outgoing Source Device. As missed calls occur while the Outgoing Source Device is connected in the vehicle the NumMissedCalls is incremented to reflect the number of calls that have been missed.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MissedCallIndicatorRelUpReg;

/**
 * The error message of 'MissedCallIndicator'
 */
typedef ::asf::cca::CcaTypes::DefaultError MissedCallIndicatorError;

/**
 * The get message of the property "DevicePhoneBookFeatureSupport"
 * Identifies support for the phone book list and call history list types for the connected device.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DevicePhoneBookFeatureSupportGet;

/**
 * The upreg message of the property "DevicePhoneBookFeatureSupport"
 * Identifies support for the phone book list and call history list types for the connected device.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DevicePhoneBookFeatureSupportUpReg;

/**
 * The relUpReg message of the property "DevicePhoneBookFeatureSupport"
 * Identifies support for the phone book list and call history list types for the connected device.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DevicePhoneBookFeatureSupportRelUpReg;

/**
 * The get message of the property "PreferredPhoneBookSortOrder"
 * The PreferredPhoneBookSortOrder property is defined so that all HMI
 * controllers can use the same sort order for phone book lists according to
 * a single user selected as follows:
 *
 *
 * <item>
 * An HMI controller implementing a sort order menu, issues a Set optype
 * to change the preferred sort order in response to a user menu input.
 * </item>
 * <item>
 * Upon receipt of a Set optype that changes the current preferred sort
 * order, the FBlock issues corresponding Status update(s) to all
 * registered HMI controllers.
 * </item>
 * <item>
 * Note that the PhoneBook FBlock does NOT change the sort order of
 * existing lists upon a change in this property. HMI controllers are
 * responsible for creating new lists with the new sort order. This is
 * done by discarding the controller's current PhoneBook list(s) and
 * replacing the displayed list with a new list created by a call to
 * CreatePhoneBookList.StartResultAck where the PhoneBookSortType is
 * seleted based upon this property.
 * </item>
 * <item>
 * In order to avoid flicker at network initialization, HMI controllers
 * using this property in order to determine the sort order in the
 * CreatePhoneBookList.StartResultAck call shall wait until they receive
 * a PreferredPhoneBookSortOrder.Status response prior to the initial
 * CreatePhoneBookList.StartResultAck.  This is necessary to avoid
 * display flicker where the initial created list is immediately replaced
 * by a new one if the controller happens to create a list with the wrong
 * sort order first.
 * </item>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PreferredPhoneBookSortOrderGet;

/**
 * The upreg message of the property "PreferredPhoneBookSortOrder"
 * The PreferredPhoneBookSortOrder property is defined so that all HMI
 * controllers can use the same sort order for phone book lists according to
 * a single user selected as follows:
 *
 *
 * <item>
 * An HMI controller implementing a sort order menu, issues a Set optype
 * to change the preferred sort order in response to a user menu input.
 * </item>
 * <item>
 * Upon receipt of a Set optype that changes the current preferred sort
 * order, the FBlock issues corresponding Status update(s) to all
 * registered HMI controllers.
 * </item>
 * <item>
 * Note that the PhoneBook FBlock does NOT change the sort order of
 * existing lists upon a change in this property. HMI controllers are
 * responsible for creating new lists with the new sort order. This is
 * done by discarding the controller's current PhoneBook list(s) and
 * replacing the displayed list with a new list created by a call to
 * CreatePhoneBookList.StartResultAck where the PhoneBookSortType is
 * seleted based upon this property.
 * </item>
 * <item>
 * In order to avoid flicker at network initialization, HMI controllers
 * using this property in order to determine the sort order in the
 * CreatePhoneBookList.StartResultAck call shall wait until they receive
 * a PreferredPhoneBookSortOrder.Status response prior to the initial
 * CreatePhoneBookList.StartResultAck.  This is necessary to avoid
 * display flicker where the initial created list is immediately replaced
 * by a new one if the controller happens to create a list with the wrong
 * sort order first.
 * </item>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PreferredPhoneBookSortOrderUpReg;

/**
 * The relUpReg message of the property "PreferredPhoneBookSortOrder"
 * The PreferredPhoneBookSortOrder property is defined so that all HMI
 * controllers can use the same sort order for phone book lists according to
 * a single user selected as follows:
 *
 *
 * <item>
 * An HMI controller implementing a sort order menu, issues a Set optype
 * to change the preferred sort order in response to a user menu input.
 * </item>
 * <item>
 * Upon receipt of a Set optype that changes the current preferred sort
 * order, the FBlock issues corresponding Status update(s) to all
 * registered HMI controllers.
 * </item>
 * <item>
 * Note that the PhoneBook FBlock does NOT change the sort order of
 * existing lists upon a change in this property. HMI controllers are
 * responsible for creating new lists with the new sort order. This is
 * done by discarding the controller's current PhoneBook list(s) and
 * replacing the displayed list with a new list created by a call to
 * CreatePhoneBookList.StartResultAck where the PhoneBookSortType is
 * seleted based upon this property.
 * </item>
 * <item>
 * In order to avoid flicker at network initialization, HMI controllers
 * using this property in order to determine the sort order in the
 * CreatePhoneBookList.StartResultAck call shall wait until they receive
 * a PreferredPhoneBookSortOrder.Status response prior to the initial
 * CreatePhoneBookList.StartResultAck.  This is necessary to avoid
 * display flicker where the initial created list is immediately replaced
 * by a new one if the controller happens to create a list with the wrong
 * sort order first.
 * </item>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PreferredPhoneBookSortOrderRelUpReg;

/**
 * The upreg message of the property "DownloadState"
 * This is the state of the phone book and recent call list downloads from
 * each connected Bluetooth device as follows:
 *
 *
 * <item>
 * There is no Get optype. Controllers register for notification on this
 * function at intialization and receive updates as Bluetooth devices are
 * connected.
 * </item>
 * <item>
 * The stream contains a maximum of two repetitions corresponding to the
 * number of devices that may be simultaneously connected.
 * </item>
 * <item>
 * If no devices are currently connected, the FBlock shall respond to
 * status Notifications with a Null, zero-length stream as a default
 * response.
 * </item>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DownloadStateUpReg;

/**
 * The relUpReg message of the property "DownloadState"
 * This is the state of the phone book and recent call list downloads from
 * each connected Bluetooth device as follows:
 *
 *
 * <item>
 * There is no Get optype. Controllers register for notification on this
 * function at intialization and receive updates as Bluetooth devices are
 * connected.
 * </item>
 * <item>
 * The stream contains a maximum of two repetitions corresponding to the
 * number of devices that may be simultaneously connected.
 * </item>
 * <item>
 * If no devices are currently connected, the FBlock shall respond to
 * status Notifications with a Null, zero-length stream as a default
 * response.
 * </item>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DownloadStateRelUpReg;

/**
 * The abort error message of the method "StoreFavorite"
 * <p>
 * The StoreFavorite function stores in persistent memory recall
 * information for the object identified by the ObjectID. The recall
 * information stored enables the following actions to be performed at a
 * later time:
 * </p>
 *
 * <item>
 * Activate the favorite
 * </item>
 * <item>
 * Determine if the favorite is currently active
 * </item>
 * <item>
 * Determine if the favorite is currently available
 * </item>
 * <item>
 * Determine the current LabelText and DescriptorText strings
 * </item>
 *
 * <p>
 * The StoreFavorite function assigns a locally-unique FavoriteID to the
 * new favorite. This FavoriteID and recall information are bound and
 * stored in persistent memory.
 * </p>
 */
typedef ::asf::cca::CcaTypes::DefaultError StoreFavoriteAbortError;

/**
 * The abort error message of the method "ActivateFavorite"
 * <p>
 * The ActivateFavorite function activates the favorite identified by the
 * FavoriteID parameter if f the AudioChannel and VideoChannel are
 * appropriate for the favorite. If the AudioChannel or the VideoChannel
 * are not appropriate then an error is returned.
 * </p>
 */
typedef ::asf::cca::CcaTypes::DefaultError ActivateFavoriteAbortError;

/**
 * The abort error message of the method "DeleteFavorite"
 * <p>
 * The DeleteFavorite function deletes the favorite identified by the FavoriteID parameter.
 *
 * If FavoriteID=0 then all favorites are to be deleted.
 * </p>
 */
typedef ::asf::cca::CcaTypes::DefaultError DeleteFavoriteAbortError;

/**
 * The abort error message of the method "GetFavoriteInfo"
 * The GetFavoriteInfo function provides FavoriteInfo for 1 or all Favorites stored in the Favorite Provider.  If the FavoriteID parameter = 0 then FavoriteInfo constains data for all stored favorites.  Otherwise, only FavoriteInfo only contains data for FavoriteID.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetFavoriteInfoAbortError;

/**
 * The start message of the method "ResetFavorites"
 * The ResetFavorites function causes the Favorite Provider to remove all favorites from its Stored Favorites and then rebuild its Stored Favorites with its Default Favorites.   This function returns NumStoredFavorites which is the number of favorites in the Stored Favorites.
 *
 * Note:  Not all Favorites Providers will have Default Favorites to rebuild the Stored Favorites List with.  In this case, the Stored Favorites List will be empty as a result of this function and NumStoredFavorites will be 0.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ResetFavoritesStart;

/**
 * The result message of the method "ResetFavorites"
 * The ResetFavorites function causes the Favorite Provider to remove all favorites from its Stored Favorites and then rebuild its Stored Favorites with its Default Favorites.   This function returns NumStoredFavorites which is the number of favorites in the Stored Favorites.
 *
 * Note:  Not all Favorites Providers will have Default Favorites to rebuild the Stored Favorites List with.  In this case, the Stored Favorites List will be empty as a result of this function and NumStoredFavorites will be 0.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ResetFavoritesResult;

/**
 * The abort error message of the method "ResetFavorites"
 * The ResetFavorites function causes the Favorite Provider to remove all favorites from its Stored Favorites and then rebuild its Stored Favorites with its Default Favorites.   This function returns NumStoredFavorites which is the number of favorites in the Stored Favorites.
 *
 * Note:  Not all Favorites Providers will have Default Favorites to rebuild the Stored Favorites List with.  In this case, the Stored Favorites List will be empty as a result of this function and NumStoredFavorites will be 0.
 */
typedef ::asf::cca::CcaTypes::DefaultError ResetFavoritesAbortError;

/**
 * The abort error message of the method "CreatePhoneBookList"
 * Creates a Phone Book list of a particular type and returns a ListHandle to the caller.  Slices of the list can then be accessed via RequestPhoneBookListSlice.
 */
typedef ::asf::cca::CcaTypes::DefaultError CreatePhoneBookListAbortError;

/**
 * The abort error message of the method "SearchKeyboardPhoneBookList"
 * This function returns the search keyboard for a particular ListHandle. The
 * returned list identifies which letters of the Vertical Keyboard have at
 * least one Phone Book entry that starts with that letter. The index of the
 * first entry associated with the letter is also provided.If a
 * letter does not have an index then a Phone Book entry that starts with
 * that letter does not exist.Note that the returned search keyboard
 * list may no longer be valid if items in the underlying list have changed.
 * Thus, controllers shall re-request the search keyboard list upon a receipt
 * of MediaPlayerListChange for the ListHandle tied to the returned search
 * keyboard.
 */
typedef ::asf::cca::CcaTypes::DefaultError SearchKeyboardPhoneBookListAbortError;

/**
 * The abort error message of the method "ReleasePhoneBookList"
 * The ReleasePhoneBookList function releases a list which has been created by the CreatePhoneBookList function.  The list to release is specified by the ListHandle parameter. The ListHandle becomes invalid by this function.
 */
typedef ::asf::cca::CcaTypes::DefaultError ReleasePhoneBookListAbortError;

/**
 * The abort error message of the method "GetContactDetails"
 * Retrieves the detailed information for a particular contact based on filter type selected and identified by the supplied ContactHandle.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetContactDetailsAbortError;

/**
 * The abort error message of the method "GetContactPhoto"
 * Acquires the photo associated with a contact. This function returns the
 * image encoded as it has been received by the phone device, typically
 * this will be JPEG or GIF or PNG.
 * HMI controllers should call this method without prior calling the method GetContactPhotoInfo.
 * The method GetContactPhotoInfo has become deprecated.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetContactPhotoAbortError;

/**
 * The abort error message of the method "AddContact"
 * Adds new contact to the appropriate source phone book (i.e. Vehicle Contact List)
 */
typedef ::asf::cca::CcaTypes::DefaultError AddContactAbortError;

/**
 * The abort error message of the method "DeleteContact"
 * Deletes a contact based on its ContactHandle. The Result response includes the ContactDeleteStatus and the ContactHandle of the message requested for deletion.
 */
typedef ::asf::cca::CcaTypes::DefaultError DeleteContactAbortError;

/**
 * The abort error message of the method "EditContact"
 * Updates an existing contact with modifications and/or additions to the contact detail field(s) as entered by the user.
 *
 * The function is initiated upon the contact being saved.
 *
 * The Result response includes the ContactEditStatus and the ContactHandle of the contact requested for modification.
 */
typedef ::asf::cca::CcaTypes::DefaultError EditContactAbortError;

/**
 * The abort error message of the method "CreateCallHistoryList"
 * Creates a Call History list of a particular type and returns a ListHandle to the caller.  Slices of the list can then be accessed via RequestCallHistoryListSlice.
 */
typedef ::asf::cca::CcaTypes::DefaultError CreateCallHistoryListAbortError;

/**
 * The abort error message of the method "RequestSliceCallHistoryList"
 * The RequestSliceCallHistoryList method provides a slice of the sorted call history list type specified by the ListHandle parameter. The slice begins with the item at location WindowStart and includes in sequential order the number of items specified by the parameter WindowSize.  The RequestSliceCallHistoryList method returns the slice as a CallHistoryList stream.  If the number of items in the list starting at WindowStart is less than the WindowSize parameter then the number of items provided in the slice will be less than the WindowSize calling parameter.
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestSliceCallHistoryListAbortError;

/**
 * The abort error message of the method "ClearMissedCallIndicator"
 * This Method clears the missed called indicator on a particular device. It is initiated when the user selects to view Recent Calls. The FBlock shall also issue a Status notification update of the MissedCallIndicator property set to zero to registered controllers.
 */
typedef ::asf::cca::CcaTypes::DefaultError ClearMissedCallIndicatorAbortError;

/**
 * The abort error message of the method "SearchPhoneBook"
 * This is a request from the HMI to search the phone book for a contact name (first and last) and contact detail type that matches the phone number or email address received from the ITelephone or IMessaging FBlock.
 */
typedef ::asf::cca::CcaTypes::DefaultError SearchPhoneBookAbortError;

/**
 * The abort error message of the method "ReleaseCallHistoryList"
 * The ReleaseCallHistoryList function releases a list which has been created by the CreateCallHistoryList function.  The list to release is specified by the ListHandle parameter. The ListHandle becomes invalid by this function.
 */
typedef ::asf::cca::CcaTypes::DefaultError ReleaseCallHistoryListAbortError;

/**
 * The abort error message of the method "GetContactPhotoInfo"
 * This method GetContactPhotoInfo has become DEPRECATED. HMI Controllers are recommended to call
 * the method GetContactPhoto directly without a prior call of GetContactPhotoInfo.
 *
 * Acquires the photo MIME image subtype and the size of the image. If the MIMEImageSubtype = NULL then there is no photo associated with the ContactHandle.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetContactPhotoInfoAbortError;

/**
 * The abort error message of the method "GetDeviceCallHistorySupport"
 * This Method identifies the device call history support. Specifically, it identifies the call history list types supported by the device and whether the lists support date/time.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetDeviceCallHistorySupportAbortError;

/**
 * The abort error message of the method "AutocompletePhoneNumberEntry"
 * This method is used to acquire the phone number match to the recent call history list as the user enters phone number digits. In addition, the PhoneBook identifies if a match exists using the AutocompleteMatch parameter, and also returns the number of matches (NumberOfMatches), and the ID of the list of multiple matches for the phone number digits provided (AutocompleteMultipleMatchListID). The AutocompleteMultipleMatchListID is used to display the list of multiple matches for the phone number digits provided.
 */
typedef ::asf::cca::CcaTypes::DefaultError AutocompletePhoneNumberEntryAbortError;

/**
 * The start message of the method "ClearPhoneBookData"
 * This function is called to clear out all contact and personal information from within the Phone Book as well as the Vehicle Phone Book identified by DeviceHandle = 1.  Upon receipt of the StartAck optype,the PhoneBook FBlock shall permanently delete all contact information from both temporary (e.g. DRAM) and permanent (Flash) memory.
 *
 * This function is used, for example, to delete all the phone book contacts when a vehicle is turned-in at the end of lease.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ClearPhoneBookDataStart;

/**
 * The abort error message of the method "ClearPhoneBookData"
 * This function is called to clear out all contact and personal information from within the Phone Book as well as the Vehicle Phone Book identified by DeviceHandle = 1.  Upon receipt of the StartAck optype,the PhoneBook FBlock shall permanently delete all contact information from both temporary (e.g. DRAM) and permanent (Flash) memory.
 *
 * This function is used, for example, to delete all the phone book contacts when a vehicle is turned-in at the end of lease.
 */
typedef ::asf::cca::CcaTypes::DefaultError ClearPhoneBookDataAbortError;

/**
 * The abort error message of the method "RequestPhoneBookListSlice"
 * The RequestPhoneBookListSlice method provides a slice of the filtered list specified by the ListHandle parameter. The slice begins with the item at location WindowStart and includes in sequential order the number of items specified by the parameter WindowSize.
 *
 * The RequestPhoneBookListSlice method returns the slice as a PhoneBookList stream.  If the number of items in the list starting at WindowStart is less than the WindowSize parameter then the number of items provided in the slice will be less than the WindowSize calling parameter.
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestPhoneBookListSliceAbortError;

/**
 * The start message of the method "ClearVehiclePhoneBook"
 * This Method deletes all information from the vehicle phone book
 * (DeviceHandle=1). Upon receipt of the StartAck optype, the FBlock shall
 * delete all entries within the phone and notify all controllers that have
 * created lists on the vehicle phone book via the ListChange property.Note
 * that this function is different from the ClearPhoneBookData method in that
 * only the vehicle phone book is cleared. ClearPhoneBookData clears BOTH the
 * vehicle phone book and all of the customer device phone book information.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ClearVehiclePhoneBookStart;

/**
 * The abort error message of the method "ClearVehiclePhoneBook"
 * This Method deletes all information from the vehicle phone book
 * (DeviceHandle=1). Upon receipt of the StartAck optype, the FBlock shall
 * delete all entries within the phone and notify all controllers that have
 * created lists on the vehicle phone book via the ListChange property.Note
 * that this function is different from the ClearPhoneBookData method in that
 * only the vehicle phone book is cleared. ClearPhoneBookData clears BOTH the
 * vehicle phone book and all of the customer device phone book information.
 */
typedef ::asf::cca::CcaTypes::DefaultError ClearVehiclePhoneBookAbortError;

/**
 * The abort error message of the method "RequestSliceCallHistoryListExtended"
 * The RequestSliceCallHistoryList method provides a slice of the sorted call history list type specified by the ListHandle parameter. The slice begins with the item at location WindowStart and includes in sequential order the number of items specified by the parameter WindowSize.  The RequestSliceCallHistoryList method returns the slice as a CallHistoryList stream.  If the number of items in the list starting at WindowStart is less than the WindowSize parameter then the number of items provided in the slice will be less than the WindowSize calling parameter.
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestSliceCallHistoryListExtendedAbortError;

/**
 * The abort error message of the method "RequestPhoneBookListSliceExtended"
 * The RequestPhoneBookListSlice method provides a slice of the filtered list specified by the ListHandle parameter. The slice begins with the item at location WindowStart and includes in sequential order the number of items specified by the parameter WindowSize.
 * The RequestPhoneBookListSlice method returns the slice as a PhoneBookList stream.  If the number of items in the list starting at WindowStart is less than the WindowSize parameter then the number of items provided in the slice will be less than the WindowSize calling parameter.
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestPhoneBookListSliceExtendedAbortError;

/**
 * The abort error message of the method "SearchContacts"
 * This method searches the contacts containing the given SearchString. The search can be configured as:
 * a. The search can be executed in one or more device lists (For instance Vehicle Contacts and Contacts of a connected phone device)
 * b. The fields(e.g. FirstName, LastName, Phone Number) in which search is done are selectable via a bit field FieldSelector
 * c. The search will be stopped when a number, of already found matches, has reached the given value of MaximumReportedMatches
 */
typedef ::asf::cca::CcaTypes::DefaultError SearchContactsAbortError;

/**
 * The abort error message of the method "StartPbDownload"
 * This method will start the manual phonebook download for the given device
 * The given DeviceHandle shall correspond to the connected phone, which currently has the HFP connection (outgoing source device)
 */
typedef ::asf::cca::CcaTypes::DefaultError StartPbDownloadAbortError;

/**
 * The abort error message of the method "SwitchDownloadOnOffState"
 * This method will switch the  phonebook download status to on or off. Values should be 0x00 for PB_DL_ON 0x01 for PB_DL_OFF
 * Phonebook and call history download of each paired device depends on this method
 */
typedef ::asf::cca::CcaTypes::DefaultError SwitchDownloadOnOffStateAbortError;

/**
 * The abort error message of the method "CreateContactList"
 * Creates a contact list of a particular type and returns a ListHandle to the caller.
 * Slices of the list can then be accessed via RequestPhoneBookListSlice.
 */
typedef ::asf::cca::CcaTypes::DefaultError CreateContactListAbortError;

/**
 * The abort error message of the method "SetContactPhoto"
 * Sets photo for the given contact in vehicle phonebook. This function return with the requested values and confirms that job will be executed.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetContactPhotoAbortError;

/**
 * The abort error message of the method "CancelPbDownload"
 * The user shall have possibility to cancel the ongoing phone book download but not the call history download
 */
typedef ::asf::cca::CcaTypes::DefaultError CancelPbDownloadAbortError;

/**
 * The abort error message of the method "SetContactPosition"
 * Sets the contact postion for the given contacthandle and position in vehicle phonebook. This function return with the requested values and confirms that job will be executed.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetContactPositionAbortError;

/**
 * The abort error message of the method "AddContactExtended"
 * Adds new contact(Extended) to the vehicle phone book (i.e. Vehicle Contact List)
 */
typedef ::asf::cca::CcaTypes::DefaultError AddContactExtendedAbortError;

/**
 * The abort error message of the method "EditContactExtended"
 * Updates an existing vehicle phonebook
 * contact with modifications and/or additions to the contact detail field(s) as entered by the user.
 *
 * The function is initiated upon the contact being saved.
 * The Result response includes the
 * ContactEditStatus and the ContactHandle
 * of the contact requested
 * for modification.
 */
typedef ::asf::cca::CcaTypes::DefaultError EditContactExtendedAbortError;

/**
 * The abort error message of the method "GetContactDetailsExtended"
 * Retrieves the detailed information for a particular
 * vehicle contact (Extended) selected and identified by the
 * supplied ContactHandle.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetContactDetailsExtendedAbortError;

/**
 * The abort error message of the method "ClearVehiclePhonebookExtended"
 * This method clears all vehicle phonebook entries from a specific vehicle phonebook. [VPBx]
 * It can also clear all the entries from all the vehicle phonebooks at once [1-11] (For reset to factory default.)
 */
typedef ::asf::cca::CcaTypes::DefaultError ClearVehiclePhonebookExtendedAbortError;

/**
 * The abort error message of the method "SetAutomaticContactDownload"
 * This method allows to define individual for a paired phone device, if the phonebook contact data is synchronized or not synchronized, when a phone device gets re-connected.
 * This setting does not affect the call history download. The call history lists are still downloaded when a phone gets connected (or refreshed after a call has ended).
 * False: The automatic download is deactivated.
 * True : The automatic download is activated.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetAutomaticContactDownloadAbortError;

/**
 * The abort error message of the method "GetPositionForContactHandle"
 * This method can be called for a dedicated contact list (identified by the u16ListHandle) to find out at which position in this list a contact (identified via its u32ContactHandle) is located.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetPositionForContactHandleAbortError;

/**
 * The upreg message of the property "DownloadStateExtended"
 * This is the state of the phone book and recent call list downloads from
 * each connected Bluetooth device as follows:
 *
 * <item>
 * There is no Get optype. Controllers register for notification on this
 * function at intialization and receive updates as Bluetooth devices are
 * connected.
 * </item>
 * <item>
 * The stream contains a maximum of two repetitions corresponding to the
 * number of devices that may be simultaneously connected.
 * </item>
 * <item>
 * If no devices are currently connected, the FBlock shall respond to
 * status Notifications with a Null, zero-length stream as a default
 * response.
 * </item>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DownloadStateExtendedUpReg;

/**
 * The relUpReg message of the property "DownloadStateExtended"
 * This is the state of the phone book and recent call list downloads from
 * each connected Bluetooth device as follows:
 *
 * <item>
 * There is no Get optype. Controllers register for notification on this
 * function at intialization and receive updates as Bluetooth devices are
 * connected.
 * </item>
 * <item>
 * The stream contains a maximum of two repetitions corresponding to the
 * number of devices that may be simultaneously connected.
 * </item>
 * <item>
 * If no devices are currently connected, the FBlock shall respond to
 * status Notifications with a Null, zero-length stream as a default
 * response.
 * </item>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DownloadStateExtendedRelUpReg;

/**
 * The get message of the property "DownloadProgress"
 * The DownloadProgress is sent out while a phonebook download is running. It informs the HMI about the number of contacts,
 * which have already been downloaded and have contributed to the database (either new inserted contacts or verified ones.
 * The property is updated after the next e.g. 100 contacts have been verified or added to the database.
 * (Double contacts do not count to the number of currently downloaded contacts.)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DownloadProgressGet;

/**
 * The upreg message of the property "DownloadProgress"
 * The DownloadProgress is sent out while a phonebook download is running. It informs the HMI about the number of contacts,
 * which have already been downloaded and have contributed to the database (either new inserted contacts or verified ones.
 * The property is updated after the next e.g. 100 contacts have been verified or added to the database.
 * (Double contacts do not count to the number of currently downloaded contacts.)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DownloadProgressUpReg;

/**
 * The relUpReg message of the property "DownloadProgress"
 * The DownloadProgress is sent out while a phonebook download is running. It informs the HMI about the number of contacts,
 * which have already been downloaded and have contributed to the database (either new inserted contacts or verified ones.
 * The property is updated after the next e.g. 100 contacts have been verified or added to the database.
 * (Double contacts do not count to the number of currently downloaded contacts.)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DownloadProgressRelUpReg;

/**
 * The get message of the property "DownloadProgressList"
 * This property is an extension to the DownloadProgress property. It updates the download progress for the list of devices connected via PBAP with the percentage value and the number of contacts downloaded.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DownloadProgressListGet;

/**
 * The upreg message of the property "DownloadProgressList"
 * This property is an extension to the DownloadProgress property. It updates the download progress for the list of devices connected via PBAP with the percentage value and the number of contacts downloaded.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DownloadProgressListUpReg;

/**
 * The relUpReg message of the property "DownloadProgressList"
 * This property is an extension to the DownloadProgress property. It updates the download progress for the list of devices connected via PBAP with the percentage value and the number of contacts downloaded.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DownloadProgressListRelUpReg;

/**
 * The get message of the property "DownloadOnOffList"
 * The stream of list which reports the status of this download OnOff setting for all paired phone devices is updated whenever there is a change in download on-off state, device is connected, device deleted and on startup.
 * Values will be like
 * 0x00   PB_DL_ON
 * 0x01   PB_DL_OFF
 * 0x02   PB_DL_IN_TRANSITION_TO_ON
 * 0x03   PB_DL_IN_TRANSITION_TO_OFF
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DownloadOnOffListGet;

/**
 * The upreg message of the property "DownloadOnOffList"
 * The stream of list which reports the status of this download OnOff setting for all paired phone devices is updated whenever there is a change in download on-off state, device is connected, device deleted and on startup.
 * Values will be like
 * 0x00   PB_DL_ON
 * 0x01   PB_DL_OFF
 * 0x02   PB_DL_IN_TRANSITION_TO_ON
 * 0x03   PB_DL_IN_TRANSITION_TO_OFF
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DownloadOnOffListUpReg;

/**
 * The relUpReg message of the property "DownloadOnOffList"
 * The stream of list which reports the status of this download OnOff setting for all paired phone devices is updated whenever there is a change in download on-off state, device is connected, device deleted and on startup.
 * Values will be like
 * 0x00   PB_DL_ON
 * 0x01   PB_DL_OFF
 * 0x02   PB_DL_IN_TRANSITION_TO_ON
 * 0x03   PB_DL_IN_TRANSITION_TO_OFF
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DownloadOnOffListRelUpReg;

/**
 * The get message of the property "AutomaticContactDownloadList"
 * The stream of list which reports the status of this Automaticdownload state setting for all paired phone devices.
 * Values will be like
 * 0x00 The automatic download is deactivated.
 * 0x01 The automatic download is activated.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AutomaticContactDownloadListGet;

/**
 * The upreg message of the property "AutomaticContactDownloadList"
 * The stream of list which reports the status of this Automaticdownload state setting for all paired phone devices.
 * Values will be like
 * 0x00 The automatic download is deactivated.
 * 0x01 The automatic download is activated.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AutomaticContactDownloadListUpReg;

/**
 * The relUpReg message of the property "AutomaticContactDownloadList"
 * The stream of list which reports the status of this Automaticdownload state setting for all paired phone devices.
 * Values will be like
 * 0x00 The automatic download is deactivated.
 * 0x01 The automatic download is activated.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AutomaticContactDownloadListRelUpReg;

/**
 * The get message of the property "DevicePhoneBookFeatureSupportExtended"
 * Identifies support for the phone book list and call history list types for the connected devices.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DevicePhoneBookFeatureSupportExtendedGet;

/**
 * The upreg message of the property "DevicePhoneBookFeatureSupportExtended"
 * Identifies support for the phone book list and call history list types for the connected devices.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DevicePhoneBookFeatureSupportExtendedUpReg;

/**
 * The relUpReg message of the property "DevicePhoneBookFeatureSupportExtended"
 * Identifies support for the phone book list and call history list types for the connected devices.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DevicePhoneBookFeatureSupportExtendedRelUpReg;

/**
 * The get message of the property "ProbablyLockedDevices"
 * This property lists the connected phone devices (DeviceHandles) for which a phonebook has been started at some time in
 * the current connection cycle and the phone device has reported (and still reports) all phonebook repositories as empty,
 * but the phone device is already known by FC_Phonebook and a contact set is available in FC_Phonebook's database.
 *
 * Such a situation does not seem to be consistent and therefore HMI should be informed, so it could interact with the
 * user on this. We will denote such situation as "phone probably locked" for a dedicated phone device (DeviceHandle)
 * in the following.
 *
 * A situation of "phone probably locked" can e.g. appear as follows:
 * - A phone device had an empty battery, then is charged in the car (e.g. via USB) and becomes "alive". It might get
 * reconnected via BT then and a phonebook download might be started by FC_Phonebook, but this download would not really
 * succeed as expected with iPhones as they have a special security feature, which then after the phone device becomes
 * connected via BT, allows a PBAP connection, but reports all phonebook repositories as empty as long the user has not
 * entered the "security code", if the security lock is activated on the phone device.
 *
 * If a "phone probably locked" has been detected for a phone device by FC_Phonebook,
 * - FC_Phonebook will keep the related contacts in its database, but will not provide them to HMI, i.e. on a related
 * request by HMI, FC_Phonebook will answer as if the related list is empty.
 * - I.e. FC_Phonebook will answer dedicated requests by HMI - e.g. CreatePhonebookListExtended or similar - with
 * success, but will provide no contact details in related API requests, e.g. a SliceListRequest will be answered with
 * an empty list, a request for a manual phonebook download is returned with ERROR, ..
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ProbablyLockedDevicesGet;

/**
 * The upreg message of the property "ProbablyLockedDevices"
 * This property lists the connected phone devices (DeviceHandles) for which a phonebook has been started at some time in
 * the current connection cycle and the phone device has reported (and still reports) all phonebook repositories as empty,
 * but the phone device is already known by FC_Phonebook and a contact set is available in FC_Phonebook's database.
 *
 * Such a situation does not seem to be consistent and therefore HMI should be informed, so it could interact with the
 * user on this. We will denote such situation as "phone probably locked" for a dedicated phone device (DeviceHandle)
 * in the following.
 *
 * A situation of "phone probably locked" can e.g. appear as follows:
 * - A phone device had an empty battery, then is charged in the car (e.g. via USB) and becomes "alive". It might get
 * reconnected via BT then and a phonebook download might be started by FC_Phonebook, but this download would not really
 * succeed as expected with iPhones as they have a special security feature, which then after the phone device becomes
 * connected via BT, allows a PBAP connection, but reports all phonebook repositories as empty as long the user has not
 * entered the "security code", if the security lock is activated on the phone device.
 *
 * If a "phone probably locked" has been detected for a phone device by FC_Phonebook,
 * - FC_Phonebook will keep the related contacts in its database, but will not provide them to HMI, i.e. on a related
 * request by HMI, FC_Phonebook will answer as if the related list is empty.
 * - I.e. FC_Phonebook will answer dedicated requests by HMI - e.g. CreatePhonebookListExtended or similar - with
 * success, but will provide no contact details in related API requests, e.g. a SliceListRequest will be answered with
 * an empty list, a request for a manual phonebook download is returned with ERROR, ..
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ProbablyLockedDevicesUpReg;

/**
 * The relUpReg message of the property "ProbablyLockedDevices"
 * This property lists the connected phone devices (DeviceHandles) for which a phonebook has been started at some time in
 * the current connection cycle and the phone device has reported (and still reports) all phonebook repositories as empty,
 * but the phone device is already known by FC_Phonebook and a contact set is available in FC_Phonebook's database.
 *
 * Such a situation does not seem to be consistent and therefore HMI should be informed, so it could interact with the
 * user on this. We will denote such situation as "phone probably locked" for a dedicated phone device (DeviceHandle)
 * in the following.
 *
 * A situation of "phone probably locked" can e.g. appear as follows:
 * - A phone device had an empty battery, then is charged in the car (e.g. via USB) and becomes "alive". It might get
 * reconnected via BT then and a phonebook download might be started by FC_Phonebook, but this download would not really
 * succeed as expected with iPhones as they have a special security feature, which then after the phone device becomes
 * connected via BT, allows a PBAP connection, but reports all phonebook repositories as empty as long the user has not
 * entered the "security code", if the security lock is activated on the phone device.
 *
 * If a "phone probably locked" has been detected for a phone device by FC_Phonebook,
 * - FC_Phonebook will keep the related contacts in its database, but will not provide them to HMI, i.e. on a related
 * request by HMI, FC_Phonebook will answer as if the related list is empty.
 * - I.e. FC_Phonebook will answer dedicated requests by HMI - e.g. CreatePhonebookListExtended or similar - with
 * success, but will provide no contact details in related API requests, e.g. a SliceListRequest will be answered with
 * an empty list, a request for a manual phonebook download is returned with ERROR, ..
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ProbablyLockedDevicesRelUpReg;

/**
 * The get message of the property "MissedCallIndicatorList"
 * This property is an extension to the MissedCallIndicator property. It updates the MissedcallIndication for the list of devices connected via PBAP.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MissedCallIndicatorListGet;

/**
 * The upreg message of the property "MissedCallIndicatorList"
 * This property is an extension to the MissedCallIndicator property. It updates the MissedcallIndication for the list of devices connected via PBAP.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MissedCallIndicatorListUpReg;

/**
 * The relUpReg message of the property "MissedCallIndicatorList"
 * This property is an extension to the MissedCallIndicator property. It updates the MissedcallIndication for the list of devices connected via PBAP.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MissedCallIndicatorListRelUpReg;

/**
 * The get message of the property "PreferredSortOrderList"
 * This property is an extension to the PreferredPhoneBookSortOrder property. It updates the PreferredSortOrder for the list of devices connected.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PreferredSortOrderListGet;

/**
 * The upreg message of the property "PreferredSortOrderList"
 * This property is an extension to the PreferredPhoneBookSortOrder property. It updates the PreferredSortOrder for the list of devices connected.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PreferredSortOrderListUpReg;

/**
 * The relUpReg message of the property "PreferredSortOrderList"
 * This property is an extension to the PreferredPhoneBookSortOrder property. It updates the PreferredSortOrder for the list of devices connected.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PreferredSortOrderListRelUpReg;

/**
 * The get message of the property "PhonebookLanguage"
 * This property will set the language to the Phonebook F-Block and based on the set language the pre-defined message list will be provided to HMI.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PhonebookLanguageGet;

/**
 * The upreg message of the property "PhonebookLanguage"
 * This property will set the language to the Phonebook F-Block and based on the set language the pre-defined message list will be provided to HMI.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PhonebookLanguageUpReg;

/**
 * The relUpReg message of the property "PhonebookLanguage"
 * This property will set the language to the Phonebook F-Block and based on the set language the pre-defined message list will be provided to HMI.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PhonebookLanguageRelUpReg;

/**
 * The get message of the property "MaxContactCount"
 * This interface shall provide the ever highest number of phone book entries from all ever connected phones over lifetime.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MaxContactCountGet;

/**
 * The upreg message of the property "MaxContactCount"
 * This interface shall provide the ever highest number of phone book entries from all ever connected phones over lifetime.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MaxContactCountUpReg;

/**
 * The relUpReg message of the property "MaxContactCount"
 * This interface shall provide the ever highest number of phone book entries from all ever connected phones over lifetime.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MaxContactCountRelUpReg;


/**
 * The status message of the property "FavoritesChanged"
 * The FavoritesChanged property provides notification about changes that
 * occurred to the stored favorites. These changes include:
 *
 *
 * <item>
 * Addition of a new favorite
 * </item>
 * <item>
 * Deletion of a favorite
 * </item>
 * <item>
 * Change of any of the information in the FavoriteInfo record for a
 * favorite
 * </item>
 * <item>
 * Determination of all the FavoriteInfo for each stored favorite after
 * system initialization
 * </item>
 *
 * <p>
 * The ListChangeType = LCH_CONTENT_CHANGED when the FavoriteInfo record
 * elements have been determined for all stored favorites after system
 * initialization.
 * </p>
 * <p>
 * If the ListChangeType = LCH_CONTENT_CHANGED, i.e. the entire list
 * changed, then NumItems = 0 and the ChangedFavorites array is empty.
 * </p>
 */
class FavoritesChangedStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FavoritesChangedStatus ();

    /**
     * Copy constructor
     */
    inline  FavoritesChangedStatus (const FavoritesChangedStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FavoritesChangedStatus (::most_FavPrv_fi_types::T_e8_FavPrvListChangeType e8ListChangeType_, uint32 u32ListSize_, uint32 u32NumItems_, const ::most_FavPrv_fi_types::T_FavPrvChangedFavorites& oChangedFavorites_);

    /**
     * Destructor
     */
    inline virtual  ~FavoritesChangedStatus();

    /**
     * Assignment operator
     */
    inline FavoritesChangedStatus& operator = (const FavoritesChangedStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FavoritesChangedStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FavoritesChangedStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FavoritesChangedStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FavoritesChangedStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ListChangeType"

    static const int kE8ListChangeType = 0;

    /**
     * Clears the field "e8ListChangeType".
     *
     * The field will be set to its default value. The hasE8ListChangeType()
     * method will return false.
     */
    inline void clearE8ListChangeType();

    /**
     * Checks whether the field "e8ListChangeType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ListChangeType()). Otherwise it will return false.
     */
    inline bool hasE8ListChangeType () const;

    /**
     * Returns the value of the member "e8ListChangeType".
     *
     * The ListChangeType parameter indicates the kind of change that occurred to the stored favorites.
     *
     * @return The value of the field "e8ListChangeType"
     */
    inline ::most_FavPrv_fi_types::T_e8_FavPrvListChangeType getE8ListChangeType () const;

    /**
     * Sets the value of the member "e8ListChangeType".
     *
     * The ListChangeType parameter indicates the kind of change that occurred to the stored favorites.
     *
     * @param e8ListChangeType The value which will be set
     */
    inline void setE8ListChangeType (::most_FavPrv_fi_types::T_e8_FavPrvListChangeType e8ListChangeType_);

    // API of field "u32ListSize"

    static const int kU32ListSize = 1;

    /**
     * Clears the field "u32ListSize".
     *
     * The field will be set to its default value. The hasU32ListSize()
     * method will return false.
     */
    inline void clearU32ListSize();

    /**
     * Checks whether the field "u32ListSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ListSize()). Otherwise it will return false.
     */
    inline bool hasU32ListSize () const;

    /**
     * Returns the value of the member "u32ListSize".
     *
     * The ListSize parameter indicates how many favorites are currently stored within the favorites provider.
     *
     * @return The value of the field "u32ListSize"
     */
    inline uint32 getU32ListSize () const;

    /**
     * Sets the value of the member "u32ListSize".
     *
     * The ListSize parameter indicates how many favorites are currently stored within the favorites provider.
     *
     * @param u32ListSize The value which will be set
     */
    inline void setU32ListSize (uint32 u32ListSize_);

    // API of field "u32NumItems"

    static const int kU32NumItems = 2;

    /**
     * Clears the field "u32NumItems".
     *
     * The field will be set to its default value. The hasU32NumItems()
     * method will return false.
     */
    inline void clearU32NumItems();

    /**
     * Checks whether the field "u32NumItems" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32NumItems()). Otherwise it will return false.
     */
    inline bool hasU32NumItems () const;

    /**
     * Returns the value of the member "u32NumItems".
     *
     * The NumItems parameter specifies the number of items or groups of items in a stream.
     *
     * @return The value of the field "u32NumItems"
     */
    inline uint32 getU32NumItems () const;

    /**
     * Sets the value of the member "u32NumItems".
     *
     * The NumItems parameter specifies the number of items or groups of items in a stream.
     *
     * @param u32NumItems The value which will be set
     */
    inline void setU32NumItems (uint32 u32NumItems_);

    // API of field "oChangedFavorites"

    static const int kOChangedFavorites = 3;

    /**
     * Clears the field "oChangedFavorites".
     *
     * The field will be set to its default value. The hasOChangedFavorites()
     * method will return false.
     */
    inline void clearOChangedFavorites();

    /**
     * Checks whether the field "oChangedFavorites" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOChangedFavorites()). Otherwise it will return false.
     */
    inline bool hasOChangedFavorites () const;

    /**
     * Returns the value of the member "oChangedFavorites".
     *
     * The ChangedFavorites steam contains the FavoriteIDs of the stored favorites which have been added, removed or changed.  This steam is empty when the ListChangeType is LCH_CONTENT_CHANGED.
     *
     * @return The value of the field "oChangedFavorites"
     */
    inline const ::most_FavPrv_fi_types::T_FavPrvChangedFavorites& getOChangedFavorites () const;

    /**
     * Retrieves the value of the field "oChangedFavorites" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oChangedFavorites".
     */
    inline ::most_FavPrv_fi_types::T_FavPrvChangedFavorites& getOChangedFavoritesMutable ();

    /**
     * Sets the value of the member "oChangedFavorites".
     *
     * The ChangedFavorites steam contains the FavoriteIDs of the stored favorites which have been added, removed or changed.  This steam is empty when the ListChangeType is LCH_CONTENT_CHANGED.
     *
     * @param oChangedFavorites The value which will be set
     */
    inline void setOChangedFavorites (const ::most_FavPrv_fi_types::T_FavPrvChangedFavorites& oChangedFavorites_);

    static const FavoritesChangedStatus &getDefaultInstance();

private:

    static const ::std::vector< uint16 >& getUint16List_DefaultInstance ();

    inline void set_has_e8ListChangeType ();

    inline void clear_has_e8ListChangeType ();

    inline void set_has_u32ListSize ();

    inline void clear_has_u32ListSize ();

    inline void set_has_u32NumItems ();

    inline void clear_has_u32NumItems ();

    inline void set_has_oChangedFavorites ();

    inline void clear_has_oChangedFavorites ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::most_FavPrv_fi_types::T_e8_FavPrvListChangeType _e8ListChangeType;

    uint32 _u32ListSize;

    uint32 _u32NumItems;

    ::most_FavPrv_fi_types::T_FavPrvChangedFavorites _oChangedFavorites;

};

/**
 * The status message of the property "ListChange"
 * The ListChange property provides notifications about changes that occur in
 * a created list. These changes include:
 *
 *
 * <item>
 * Complete change in items
 * </item>
 * <item>
 * Items changed
 * </item>
 * <item>
 * Items added
 * </item>
 * <item>
 * Items deleted
 * </item>
 *
 * <p>
 * &#160;
 * </p>
 */
class ListChangeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ListChangeStatus ();

    /**
     * Copy constructor
     */
    inline  ListChangeStatus (const ListChangeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ListChangeStatus (uint16 u16ListHandle_, ::most_PhonBk_fi_types::T_e8_PhonBkListType e8ListType_, ::most_PhonBk_fi_types::T_e8_PhonBkListChangeType e8ListChangeType_, uint16 u16ListLength_, uint32 u32NumItems_, const ::most_PhonBk_fi_types::T_PhonBkChangeItems& oChangeItems_);

    /**
     * Destructor
     */
    inline virtual  ~ListChangeStatus();

    /**
     * Assignment operator
     */
    inline ListChangeStatus& operator = (const ListChangeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ListChangeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ListChangeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ListChangeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ListChangeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ListHandle"

    static const int kU16ListHandle = 0;

    /**
     * Clears the field "u16ListHandle".
     *
     * The field will be set to its default value. The hasU16ListHandle()
     * method will return false.
     */
    inline void clearU16ListHandle();

    /**
     * Checks whether the field "u16ListHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ListHandle()). Otherwise it will return false.
     */
    inline bool hasU16ListHandle () const;

    /**
     * Returns the value of the member "u16ListHandle".
     *
     * The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @return The value of the field "u16ListHandle"
     */
    inline uint16 getU16ListHandle () const;

    /**
     * Sets the value of the member "u16ListHandle".
     *
     * The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @param u16ListHandle The value which will be set
     */
    inline void setU16ListHandle (uint16 u16ListHandle_);

    // API of field "e8ListType"

    static const int kE8ListType = 1;

    /**
     * Clears the field "e8ListType".
     *
     * The field will be set to its default value. The hasE8ListType()
     * method will return false.
     */
    inline void clearE8ListType();

    /**
     * Checks whether the field "e8ListType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ListType()). Otherwise it will return false.
     */
    inline bool hasE8ListType () const;

    /**
     * Returns the value of the member "e8ListType".
     *
     * Type of list: Phone Book or Call History
     *
     * @return The value of the field "e8ListType"
     */
    inline ::most_PhonBk_fi_types::T_e8_PhonBkListType getE8ListType () const;

    /**
     * Sets the value of the member "e8ListType".
     *
     * Type of list: Phone Book or Call History
     *
     * @param e8ListType The value which will be set
     */
    inline void setE8ListType (::most_PhonBk_fi_types::T_e8_PhonBkListType e8ListType_);

    // API of field "e8ListChangeType"

    static const int kE8ListChangeType = 2;

    /**
     * Clears the field "e8ListChangeType".
     *
     * The field will be set to its default value. The hasE8ListChangeType()
     * method will return false.
     */
    inline void clearE8ListChangeType();

    /**
     * Checks whether the field "e8ListChangeType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ListChangeType()). Otherwise it will return false.
     */
    inline bool hasE8ListChangeType () const;

    /**
     * Returns the value of the member "e8ListChangeType".
     *
     *
     *
     * @return The value of the field "e8ListChangeType"
     */
    inline ::most_PhonBk_fi_types::T_e8_PhonBkListChangeType getE8ListChangeType () const;

    /**
     * Sets the value of the member "e8ListChangeType".
     *
     *
     *
     * @param e8ListChangeType The value which will be set
     */
    inline void setE8ListChangeType (::most_PhonBk_fi_types::T_e8_PhonBkListChangeType e8ListChangeType_);

    // API of field "u16ListLength"

    static const int kU16ListLength = 3;

    /**
     * Clears the field "u16ListLength".
     *
     * The field will be set to its default value. The hasU16ListLength()
     * method will return false.
     */
    inline void clearU16ListLength();

    /**
     * Checks whether the field "u16ListLength" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ListLength()). Otherwise it will return false.
     */
    inline bool hasU16ListLength () const;

    /**
     * Returns the value of the member "u16ListLength".
     *
     * The number of elements (i.e. contacts or recent calls) in the Phone Book or Call History list.  The length is valid until the list is modified or released.
     *
     * @return The value of the field "u16ListLength"
     */
    inline uint16 getU16ListLength () const;

    /**
     * Sets the value of the member "u16ListLength".
     *
     * The number of elements (i.e. contacts or recent calls) in the Phone Book or Call History list.  The length is valid until the list is modified or released.
     *
     * @param u16ListLength The value which will be set
     */
    inline void setU16ListLength (uint16 u16ListLength_);

    // API of field "u32NumItems"

    static const int kU32NumItems = 4;

    /**
     * Clears the field "u32NumItems".
     *
     * The field will be set to its default value. The hasU32NumItems()
     * method will return false.
     */
    inline void clearU32NumItems();

    /**
     * Checks whether the field "u32NumItems" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32NumItems()). Otherwise it will return false.
     */
    inline bool hasU32NumItems () const;

    /**
     * Returns the value of the member "u32NumItems".
     *
     * Contains the number of items that have been added, removed, or changed. If more than 10 items were affected, this value is 0 and the type of change is LCH_CONTENT_CHANGED.
     *
     * @return The value of the field "u32NumItems"
     */
    inline uint32 getU32NumItems () const;

    /**
     * Sets the value of the member "u32NumItems".
     *
     * Contains the number of items that have been added, removed, or changed. If more than 10 items were affected, this value is 0 and the type of change is LCH_CONTENT_CHANGED.
     *
     * @param u32NumItems The value which will be set
     */
    inline void setU32NumItems (uint32 u32NumItems_);

    // API of field "oChangeItems"

    static const int kOChangeItems = 5;

    /**
     * Clears the field "oChangeItems".
     *
     * The field will be set to its default value. The hasOChangeItems()
     * method will return false.
     */
    inline void clearOChangeItems();

    /**
     * Checks whether the field "oChangeItems" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOChangeItems()). Otherwise it will return false.
     */
    inline bool hasOChangeItems () const;

    /**
     * Returns the value of the member "oChangeItems".
     *
     * The ChangeItems parameter is a stream of the position of contacts or recent calls which changed.  This stream is empty when ListChangeType = LCH_CONTENT_CHANGED.
     *
     * @return The value of the field "oChangeItems"
     */
    inline const ::most_PhonBk_fi_types::T_PhonBkChangeItems& getOChangeItems () const;

    /**
     * Retrieves the value of the field "oChangeItems" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oChangeItems".
     */
    inline ::most_PhonBk_fi_types::T_PhonBkChangeItems& getOChangeItemsMutable ();

    /**
     * Sets the value of the member "oChangeItems".
     *
     * The ChangeItems parameter is a stream of the position of contacts or recent calls which changed.  This stream is empty when ListChangeType = LCH_CONTENT_CHANGED.
     *
     * @param oChangeItems The value which will be set
     */
    inline void setOChangeItems (const ::most_PhonBk_fi_types::T_PhonBkChangeItems& oChangeItems_);

    static const ListChangeStatus &getDefaultInstance();

private:

    static const ::std::vector< uint32 >& getUint32List_DefaultInstance ();

    inline void set_has_u16ListHandle ();

    inline void clear_has_u16ListHandle ();

    inline void set_has_e8ListType ();

    inline void clear_has_e8ListType ();

    inline void set_has_e8ListChangeType ();

    inline void clear_has_e8ListChangeType ();

    inline void set_has_u16ListLength ();

    inline void clear_has_u16ListLength ();

    inline void set_has_u32NumItems ();

    inline void clear_has_u32NumItems ();

    inline void set_has_oChangeItems ();

    inline void clear_has_oChangeItems ();

    uint32 _has_bits_[ (6 + 31) / 32];

    uint16 _u16ListHandle;

    ::most_PhonBk_fi_types::T_e8_PhonBkListType _e8ListType;

    ::most_PhonBk_fi_types::T_e8_PhonBkListChangeType _e8ListChangeType;

    uint16 _u16ListLength;

    uint32 _u32NumItems;

    ::most_PhonBk_fi_types::T_PhonBkChangeItems _oChangeItems;

};

/**
 * The status message of the property "MissedCallIndicator"
 * Provides the number of missed calls that occur while the current Outgoing Source Device is connected in the vehicle. The number of missed calls is always zero upon connection to the Outgoing Source Device. As missed calls occur while the Outgoing Source Device is connected in the vehicle the NumMissedCalls is incremented to reflect the number of calls that have been missed.
 */
class MissedCallIndicatorStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MissedCallIndicatorStatus ();

    /**
     * Copy constructor
     */
    inline  MissedCallIndicatorStatus (const MissedCallIndicatorStatus &rhs);

    /**
     * All fields constructor
     */
    inline  MissedCallIndicatorStatus (uint32 u32NumMissedCalls_);

    /**
     * Destructor
     */
    inline virtual  ~MissedCallIndicatorStatus();

    /**
     * Assignment operator
     */
    inline MissedCallIndicatorStatus& operator = (const MissedCallIndicatorStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MissedCallIndicatorStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MissedCallIndicatorStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MissedCallIndicatorStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MissedCallIndicatorStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32NumMissedCalls"

    static const int kU32NumMissedCalls = 0;

    /**
     * Clears the field "u32NumMissedCalls".
     *
     * The field will be set to its default value. The hasU32NumMissedCalls()
     * method will return false.
     */
    inline void clearU32NumMissedCalls();

    /**
     * Checks whether the field "u32NumMissedCalls" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32NumMissedCalls()). Otherwise it will return false.
     */
    inline bool hasU32NumMissedCalls () const;

    /**
     * Returns the value of the member "u32NumMissedCalls".
     *
     * Number of missed calls that occur while the current Outgoing Source Device is connected in the vehicle.
     *
     * Shall be set to zero when the ClearMissedCallIndicator is set.
     *
     * @return The value of the field "u32NumMissedCalls"
     */
    inline uint32 getU32NumMissedCalls () const;

    /**
     * Sets the value of the member "u32NumMissedCalls".
     *
     * Number of missed calls that occur while the current Outgoing Source Device is connected in the vehicle.
     *
     * Shall be set to zero when the ClearMissedCallIndicator is set.
     *
     * @param u32NumMissedCalls The value which will be set
     */
    inline void setU32NumMissedCalls (uint32 u32NumMissedCalls_);

    static const MissedCallIndicatorStatus &getDefaultInstance();

private:

    inline void set_has_u32NumMissedCalls ();

    inline void clear_has_u32NumMissedCalls ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _u32NumMissedCalls;

};

/**
 * The status message of the property "DevicePhoneBookFeatureSupport"
 * Identifies support for the phone book list and call history list types for the connected device.
 */
class DevicePhoneBookFeatureSupportStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DevicePhoneBookFeatureSupportStatus ();

    /**
     * Copy constructor
     */
    inline  DevicePhoneBookFeatureSupportStatus (const DevicePhoneBookFeatureSupportStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DevicePhoneBookFeatureSupportStatus (bool bPhoneBookSupport_, bool bCCHListSupport_, bool bICHListSupport_, bool bOCHListSupport_, bool bMCHListSupport_, bool bContactListSortView_, uint8 u8DeviceHandle_);

    /**
     * Destructor
     */
    inline virtual  ~DevicePhoneBookFeatureSupportStatus();

    /**
     * Assignment operator
     */
    inline DevicePhoneBookFeatureSupportStatus& operator = (const DevicePhoneBookFeatureSupportStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DevicePhoneBookFeatureSupportStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DevicePhoneBookFeatureSupportStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DevicePhoneBookFeatureSupportStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DevicePhoneBookFeatureSupportStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bPhoneBookSupport"

    static const int kBPhoneBookSupport = 0;

    /**
     * Clears the field "bPhoneBookSupport".
     *
     * The field will be set to its default value. The hasBPhoneBookSupport()
     * method will return false.
     */
    inline void clearBPhoneBookSupport();

    /**
     * Checks whether the field "bPhoneBookSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBPhoneBookSupport()). Otherwise it will return false.
     */
    inline bool hasBPhoneBookSupport () const;

    /**
     * Returns the value of the member "bPhoneBookSupport".
     *
     * Identifies if the device supports the phone book (contact) list.
     *
     * @return The value of the field "bPhoneBookSupport"
     */
    inline bool getBPhoneBookSupport () const;

    /**
     * Sets the value of the member "bPhoneBookSupport".
     *
     * Identifies if the device supports the phone book (contact) list.
     *
     * @param bPhoneBookSupport The value which will be set
     */
    inline void setBPhoneBookSupport (bool bPhoneBookSupport_);

    // API of field "bCCHListSupport"

    static const int kBCCHListSupport = 1;

    /**
     * Clears the field "bCCHListSupport".
     *
     * The field will be set to its default value. The hasBCCHListSupport()
     * method will return false.
     */
    inline void clearBCCHListSupport();

    /**
     * Checks whether the field "bCCHListSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBCCHListSupport()). Otherwise it will return false.
     */
    inline bool hasBCCHListSupport () const;

    /**
     * Returns the value of the member "bCCHListSupport".
     *
     * Identifies if the device supports the Combined Call History (CCH) list.
     *
     * @return The value of the field "bCCHListSupport"
     */
    inline bool getBCCHListSupport () const;

    /**
     * Sets the value of the member "bCCHListSupport".
     *
     * Identifies if the device supports the Combined Call History (CCH) list.
     *
     * @param bCCHListSupport The value which will be set
     */
    inline void setBCCHListSupport (bool bCCHListSupport_);

    // API of field "bICHListSupport"

    static const int kBICHListSupport = 2;

    /**
     * Clears the field "bICHListSupport".
     *
     * The field will be set to its default value. The hasBICHListSupport()
     * method will return false.
     */
    inline void clearBICHListSupport();

    /**
     * Checks whether the field "bICHListSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBICHListSupport()). Otherwise it will return false.
     */
    inline bool hasBICHListSupport () const;

    /**
     * Returns the value of the member "bICHListSupport".
     *
     * Identifies if the device supports the Incoming Call History (ICH) list.
     *
     * @return The value of the field "bICHListSupport"
     */
    inline bool getBICHListSupport () const;

    /**
     * Sets the value of the member "bICHListSupport".
     *
     * Identifies if the device supports the Incoming Call History (ICH) list.
     *
     * @param bICHListSupport The value which will be set
     */
    inline void setBICHListSupport (bool bICHListSupport_);

    // API of field "bOCHListSupport"

    static const int kBOCHListSupport = 3;

    /**
     * Clears the field "bOCHListSupport".
     *
     * The field will be set to its default value. The hasBOCHListSupport()
     * method will return false.
     */
    inline void clearBOCHListSupport();

    /**
     * Checks whether the field "bOCHListSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBOCHListSupport()). Otherwise it will return false.
     */
    inline bool hasBOCHListSupport () const;

    /**
     * Returns the value of the member "bOCHListSupport".
     *
     * Identifies if the device supports the Outgoing Call History (CCH) list.
     *
     * @return The value of the field "bOCHListSupport"
     */
    inline bool getBOCHListSupport () const;

    /**
     * Sets the value of the member "bOCHListSupport".
     *
     * Identifies if the device supports the Outgoing Call History (CCH) list.
     *
     * @param bOCHListSupport The value which will be set
     */
    inline void setBOCHListSupport (bool bOCHListSupport_);

    // API of field "bMCHListSupport"

    static const int kBMCHListSupport = 4;

    /**
     * Clears the field "bMCHListSupport".
     *
     * The field will be set to its default value. The hasBMCHListSupport()
     * method will return false.
     */
    inline void clearBMCHListSupport();

    /**
     * Checks whether the field "bMCHListSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBMCHListSupport()). Otherwise it will return false.
     */
    inline bool hasBMCHListSupport () const;

    /**
     * Returns the value of the member "bMCHListSupport".
     *
     * Identifies if the device supports the Missed Call History (MCH) list.
     *
     * @return The value of the field "bMCHListSupport"
     */
    inline bool getBMCHListSupport () const;

    /**
     * Sets the value of the member "bMCHListSupport".
     *
     * Identifies if the device supports the Missed Call History (MCH) list.
     *
     * @param bMCHListSupport The value which will be set
     */
    inline void setBMCHListSupport (bool bMCHListSupport_);

    // API of field "bContactListSortView"

    static const int kBContactListSortView = 5;

    /**
     * Clears the field "bContactListSortView".
     *
     * The field will be set to its default value. The hasBContactListSortView()
     * method will return false.
     */
    inline void clearBContactListSortView();

    /**
     * Checks whether the field "bContactListSortView" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBContactListSortView()). Otherwise it will return false.
     */
    inline bool hasBContactListSortView () const;

    /**
     * Returns the value of the member "bContactListSortView".
     *
     * Informs the HMI whether the Bluetooth device has contacts with separate
     * fields for first and last name.If the Bluetooth device supports
     * separate fields for the first and last name then the ContactListSortView =
     * True (SORT_VIEW_AVAILABLE) and the &#8220;View&#8221; button shall be enabled by the
     * HMI.If the Bluetooth device does not support separate fields for
     * the first and last name then the ContactListSortView = False
     * (SORT_VIEW_UNAVAILABLE) and the &#8220;View&#8221; button shall be disabled by the HMI.
     *
     * @return The value of the field "bContactListSortView"
     */
    inline bool getBContactListSortView () const;

    /**
     * Sets the value of the member "bContactListSortView".
     *
     * Informs the HMI whether the Bluetooth device has contacts with separate
     * fields for first and last name.If the Bluetooth device supports
     * separate fields for the first and last name then the ContactListSortView =
     * True (SORT_VIEW_AVAILABLE) and the &#8220;View&#8221; button shall be enabled by the
     * HMI.If the Bluetooth device does not support separate fields for
     * the first and last name then the ContactListSortView = False
     * (SORT_VIEW_UNAVAILABLE) and the &#8220;View&#8221; button shall be disabled by the HMI.
     *
     * @param bContactListSortView The value which will be set
     */
    inline void setBContactListSortView (bool bContactListSortView_);

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 6;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Handle of the device for the phone book source. The vehicle phone book has a DeviceHandle = 1.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Handle of the device for the phone book source. The vehicle phone book has a DeviceHandle = 1.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    static const DevicePhoneBookFeatureSupportStatus &getDefaultInstance();

private:

    inline void set_has_bPhoneBookSupport ();

    inline void clear_has_bPhoneBookSupport ();

    inline void set_has_bCCHListSupport ();

    inline void clear_has_bCCHListSupport ();

    inline void set_has_bICHListSupport ();

    inline void clear_has_bICHListSupport ();

    inline void set_has_bOCHListSupport ();

    inline void clear_has_bOCHListSupport ();

    inline void set_has_bMCHListSupport ();

    inline void clear_has_bMCHListSupport ();

    inline void set_has_bContactListSortView ();

    inline void clear_has_bContactListSortView ();

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    uint32 _has_bits_[ (7 + 31) / 32];

    bool _bPhoneBookSupport;

    bool _bCCHListSupport;

    bool _bICHListSupport;

    bool _bOCHListSupport;

    bool _bMCHListSupport;

    bool _bContactListSortView;

    uint8 _u8DeviceHandle;

};

/**
 * The error message of 'DevicePhoneBookFeatureSupport'
 */
class DevicePhoneBookFeatureSupportErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DevicePhoneBookFeatureSupportErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DevicePhoneBookFeatureSupportErrorStructure (const DevicePhoneBookFeatureSupportErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DevicePhoneBookFeatureSupportErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~DevicePhoneBookFeatureSupportErrorStructure();

    /**
     * Assignment operator
     */
    inline DevicePhoneBookFeatureSupportErrorStructure& operator = (const DevicePhoneBookFeatureSupportErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DevicePhoneBookFeatureSupportErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DevicePhoneBookFeatureSupportErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DevicePhoneBookFeatureSupportErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DevicePhoneBookFeatureSupportErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     *
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     *
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     *
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     *
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const DevicePhoneBookFeatureSupportErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'DevicePhoneBookFeatureSupport'
 */
class DevicePhoneBookFeatureSupportError  : public ::asf::core::Payload {
public:

    enum DevicePhoneBookFeatureSupportErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DevicePhoneBookFeatureSupportError ();

   /**
     * Copy constructor
     */
    inline  DevicePhoneBookFeatureSupportError (const DevicePhoneBookFeatureSupportError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DevicePhoneBookFeatureSupportError();

    /**
     * Assigns a new value to this object.
     */
    inline DevicePhoneBookFeatureSupportError& operator = (const DevicePhoneBookFeatureSupportError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DevicePhoneBookFeatureSupportError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DevicePhoneBookFeatureSupportError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DevicePhoneBookFeatureSupportError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DevicePhoneBookFeatureSupportError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DevicePhoneBookFeatureSupportError::DevicePhoneBookFeatureSupportErrorField getField () const;

    inline void setField(DevicePhoneBookFeatureSupportError::DevicePhoneBookFeatureSupportErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DevicePhoneBookFeatureSupportErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DevicePhoneBookFeatureSupportErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DevicePhoneBookFeatureSupportErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DevicePhoneBookFeatureSupportErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DevicePhoneBookFeatureSupportErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DevicePhoneBookFeatureSupportErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DevicePhoneBookFeatureSupportErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DevicePhoneBookFeatureSupportErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DevicePhoneBookFeatureSupportError &getDefaultInstance();

private:

    inline void cloneData (const DevicePhoneBookFeatureSupportError& rhs);

    inline void deleteData ();

    DevicePhoneBookFeatureSupportErrorField __field;

    union {
        DevicePhoneBookFeatureSupportErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "PreferredPhoneBookSortOrder"
 * The PreferredPhoneBookSortOrder property is defined so that all HMI
 * controllers can use the same sort order for phone book lists according to
 * a single user selected as follows:
 *
 *
 * <item>
 * An HMI controller implementing a sort order menu, issues a Set optype
 * to change the preferred sort order in response to a user menu input.
 * </item>
 * <item>
 * Upon receipt of a Set optype that changes the current preferred sort
 * order, the FBlock issues corresponding Status update(s) to all
 * registered HMI controllers.
 * </item>
 * <item>
 * Note that the PhoneBook FBlock does NOT change the sort order of
 * existing lists upon a change in this property. HMI controllers are
 * responsible for creating new lists with the new sort order. This is
 * done by discarding the controller's current PhoneBook list(s) and
 * replacing the displayed list with a new list created by a call to
 * CreatePhoneBookList.StartResultAck where the PhoneBookSortType is
 * seleted based upon this property.
 * </item>
 * <item>
 * In order to avoid flicker at network initialization, HMI controllers
 * using this property in order to determine the sort order in the
 * CreatePhoneBookList.StartResultAck call shall wait until they receive
 * a PreferredPhoneBookSortOrder.Status response prior to the initial
 * CreatePhoneBookList.StartResultAck.  This is necessary to avoid
 * display flicker where the initial created list is immediately replaced
 * by a new one if the controller happens to create a list with the wrong
 * sort order first.
 * </item>
 */
class PreferredPhoneBookSortOrderStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PreferredPhoneBookSortOrderStatus ();

    /**
     * Copy constructor
     */
    inline  PreferredPhoneBookSortOrderStatus (const PreferredPhoneBookSortOrderStatus &rhs);

    /**
     * All fields constructor
     */
    inline  PreferredPhoneBookSortOrderStatus (::most_PhonBk_fi_types::T_e8_PhonBkPreferredPhoneBookSortOrder e8PreferredPhoneBookSortOrder_);

    /**
     * Destructor
     */
    inline virtual  ~PreferredPhoneBookSortOrderStatus();

    /**
     * Assignment operator
     */
    inline PreferredPhoneBookSortOrderStatus& operator = (const PreferredPhoneBookSortOrderStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PreferredPhoneBookSortOrderStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PreferredPhoneBookSortOrderStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PreferredPhoneBookSortOrderStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PreferredPhoneBookSortOrderStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8PreferredPhoneBookSortOrder"

    static const int kE8PreferredPhoneBookSortOrder = 0;

    /**
     * Clears the field "e8PreferredPhoneBookSortOrder".
     *
     * The field will be set to its default value. The hasE8PreferredPhoneBookSortOrder()
     * method will return false.
     */
    inline void clearE8PreferredPhoneBookSortOrder();

    /**
     * Checks whether the field "e8PreferredPhoneBookSortOrder" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PreferredPhoneBookSortOrder()). Otherwise it will return false.
     */
    inline bool hasE8PreferredPhoneBookSortOrder () const;

    /**
     * Returns the value of the member "e8PreferredPhoneBookSortOrder".
     *
     * This is the enumeration of allowed phone book sort orders.  HMI controllers should use this information to request the appropriate list order in the PhoneBookSortType enumeration within the CreatePhoneBookList.StartResultAck optype.
     *
     * @return The value of the field "e8PreferredPhoneBookSortOrder"
     */
    inline ::most_PhonBk_fi_types::T_e8_PhonBkPreferredPhoneBookSortOrder getE8PreferredPhoneBookSortOrder () const;

    /**
     * Sets the value of the member "e8PreferredPhoneBookSortOrder".
     *
     * This is the enumeration of allowed phone book sort orders.  HMI controllers should use this information to request the appropriate list order in the PhoneBookSortType enumeration within the CreatePhoneBookList.StartResultAck optype.
     *
     * @param e8PreferredPhoneBookSortOrder The value which will be set
     */
    inline void setE8PreferredPhoneBookSortOrder (::most_PhonBk_fi_types::T_e8_PhonBkPreferredPhoneBookSortOrder e8PreferredPhoneBookSortOrder_);

    static const PreferredPhoneBookSortOrderStatus &getDefaultInstance();

private:

    inline void set_has_e8PreferredPhoneBookSortOrder ();

    inline void clear_has_e8PreferredPhoneBookSortOrder ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_PhonBk_fi_types::T_e8_PhonBkPreferredPhoneBookSortOrder _e8PreferredPhoneBookSortOrder;

};

/**
 * The pureSet message of the property "PreferredPhoneBookSortOrder"
 * The PreferredPhoneBookSortOrder property is defined so that all HMI
 * controllers can use the same sort order for phone book lists according to
 * a single user selected as follows:
 *
 *
 * <item>
 * An HMI controller implementing a sort order menu, issues a Set optype
 * to change the preferred sort order in response to a user menu input.
 * </item>
 * <item>
 * Upon receipt of a Set optype that changes the current preferred sort
 * order, the FBlock issues corresponding Status update(s) to all
 * registered HMI controllers.
 * </item>
 * <item>
 * Note that the PhoneBook FBlock does NOT change the sort order of
 * existing lists upon a change in this property. HMI controllers are
 * responsible for creating new lists with the new sort order. This is
 * done by discarding the controller's current PhoneBook list(s) and
 * replacing the displayed list with a new list created by a call to
 * CreatePhoneBookList.StartResultAck where the PhoneBookSortType is
 * seleted based upon this property.
 * </item>
 * <item>
 * In order to avoid flicker at network initialization, HMI controllers
 * using this property in order to determine the sort order in the
 * CreatePhoneBookList.StartResultAck call shall wait until they receive
 * a PreferredPhoneBookSortOrder.Status response prior to the initial
 * CreatePhoneBookList.StartResultAck.  This is necessary to avoid
 * display flicker where the initial created list is immediately replaced
 * by a new one if the controller happens to create a list with the wrong
 * sort order first.
 * </item>
 */
class PreferredPhoneBookSortOrderPureSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PreferredPhoneBookSortOrderPureSet ();

    /**
     * Copy constructor
     */
    inline  PreferredPhoneBookSortOrderPureSet (const PreferredPhoneBookSortOrderPureSet &rhs);

    /**
     * All fields constructor
     */
    inline  PreferredPhoneBookSortOrderPureSet (::most_PhonBk_fi_types::T_e8_PhonBkPreferredPhoneBookSortOrder e8PreferredPhoneBookSortOrder_);

    /**
     * Destructor
     */
    inline virtual  ~PreferredPhoneBookSortOrderPureSet();

    /**
     * Assignment operator
     */
    inline PreferredPhoneBookSortOrderPureSet& operator = (const PreferredPhoneBookSortOrderPureSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PreferredPhoneBookSortOrderPureSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PreferredPhoneBookSortOrderPureSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PreferredPhoneBookSortOrderPureSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PreferredPhoneBookSortOrderPureSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8PreferredPhoneBookSortOrder"

    static const int kE8PreferredPhoneBookSortOrder = 0;

    /**
     * Clears the field "e8PreferredPhoneBookSortOrder".
     *
     * The field will be set to its default value. The hasE8PreferredPhoneBookSortOrder()
     * method will return false.
     */
    inline void clearE8PreferredPhoneBookSortOrder();

    /**
     * Checks whether the field "e8PreferredPhoneBookSortOrder" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PreferredPhoneBookSortOrder()). Otherwise it will return false.
     */
    inline bool hasE8PreferredPhoneBookSortOrder () const;

    /**
     * Returns the value of the member "e8PreferredPhoneBookSortOrder".
     *
     * This is the enumeration of allowed phone book sort orders.  HMI controllers should use this information to request the appropriate list order in the PhoneBookSortType enumeration within the CreatePhoneBookList.StartResultAck optype.
     *
     * @return The value of the field "e8PreferredPhoneBookSortOrder"
     */
    inline ::most_PhonBk_fi_types::T_e8_PhonBkPreferredPhoneBookSortOrder getE8PreferredPhoneBookSortOrder () const;

    /**
     * Sets the value of the member "e8PreferredPhoneBookSortOrder".
     *
     * This is the enumeration of allowed phone book sort orders.  HMI controllers should use this information to request the appropriate list order in the PhoneBookSortType enumeration within the CreatePhoneBookList.StartResultAck optype.
     *
     * @param e8PreferredPhoneBookSortOrder The value which will be set
     */
    inline void setE8PreferredPhoneBookSortOrder (::most_PhonBk_fi_types::T_e8_PhonBkPreferredPhoneBookSortOrder e8PreferredPhoneBookSortOrder_);

    static const PreferredPhoneBookSortOrderPureSet &getDefaultInstance();

private:

    inline void set_has_e8PreferredPhoneBookSortOrder ();

    inline void clear_has_e8PreferredPhoneBookSortOrder ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_PhonBk_fi_types::T_e8_PhonBkPreferredPhoneBookSortOrder _e8PreferredPhoneBookSortOrder;

};

/**
 * The error message of 'PreferredPhoneBookSortOrder'
 */
class PreferredPhoneBookSortOrderErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  PreferredPhoneBookSortOrderErrorStructure ();

    /**
     * Copy constructor
     */
    inline  PreferredPhoneBookSortOrderErrorStructure (const PreferredPhoneBookSortOrderErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  PreferredPhoneBookSortOrderErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~PreferredPhoneBookSortOrderErrorStructure();

    /**
     * Assignment operator
     */
    inline PreferredPhoneBookSortOrderErrorStructure& operator = (const PreferredPhoneBookSortOrderErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PreferredPhoneBookSortOrderErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PreferredPhoneBookSortOrderErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PreferredPhoneBookSortOrderErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PreferredPhoneBookSortOrderErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     *
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     *
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     *
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     *
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const PreferredPhoneBookSortOrderErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'PreferredPhoneBookSortOrder'
 */
class PreferredPhoneBookSortOrderError  : public ::asf::core::Payload {
public:

    enum PreferredPhoneBookSortOrderErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  PreferredPhoneBookSortOrderError ();

   /**
     * Copy constructor
     */
    inline  PreferredPhoneBookSortOrderError (const PreferredPhoneBookSortOrderError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~PreferredPhoneBookSortOrderError();

    /**
     * Assigns a new value to this object.
     */
    inline PreferredPhoneBookSortOrderError& operator = (const PreferredPhoneBookSortOrderError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PreferredPhoneBookSortOrderError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PreferredPhoneBookSortOrderError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PreferredPhoneBookSortOrderError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PreferredPhoneBookSortOrderError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline PreferredPhoneBookSortOrderError::PreferredPhoneBookSortOrderErrorField getField () const;

    inline void setField(PreferredPhoneBookSortOrderError::PreferredPhoneBookSortOrderErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "PreferredPhoneBookSortOrderErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "PreferredPhoneBookSortOrderErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const PreferredPhoneBookSortOrderErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline PreferredPhoneBookSortOrderErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline PreferredPhoneBookSortOrderErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (PreferredPhoneBookSortOrderErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "PreferredPhoneBookSortOrderErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const PreferredPhoneBookSortOrderErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const PreferredPhoneBookSortOrderError &getDefaultInstance();

private:

    inline void cloneData (const PreferredPhoneBookSortOrderError& rhs);

    inline void deleteData ();

    PreferredPhoneBookSortOrderErrorField __field;

    union {
        PreferredPhoneBookSortOrderErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "DownloadState"
 * This is the state of the phone book and recent call list downloads from
 * each connected Bluetooth device as follows:
 *
 *
 * <item>
 * There is no Get optype. Controllers register for notification on this
 * function at intialization and receive updates as Bluetooth devices are
 * connected.
 * </item>
 * <item>
 * The stream contains a maximum of two repetitions corresponding to the
 * number of devices that may be simultaneously connected.
 * </item>
 * <item>
 * If no devices are currently connected, the FBlock shall respond to
 * status Notifications with a Null, zero-length stream as a default
 * response.
 * </item>
 */
class DownloadStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DownloadStateStatus ();

    /**
     * Copy constructor
     */
    inline  DownloadStateStatus (const DownloadStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DownloadStateStatus (const ::most_PhonBk_fi_types::T_PhonBkDownloadStateStream& oDownloadStateStream_);

    /**
     * Destructor
     */
    inline virtual  ~DownloadStateStatus();

    /**
     * Assignment operator
     */
    inline DownloadStateStatus& operator = (const DownloadStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DownloadStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DownloadStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DownloadStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DownloadStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oDownloadStateStream"

    static const int kODownloadStateStream = 0;

    /**
     * Clears the field "oDownloadStateStream".
     *
     * The field will be set to its default value. The hasODownloadStateStream()
     * method will return false.
     */
    inline void clearODownloadStateStream();

    /**
     * Checks whether the field "oDownloadStateStream" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setODownloadStateStream()). Otherwise it will return false.
     */
    inline bool hasODownloadStateStream () const;

    /**
     * Returns the value of the member "oDownloadStateStream".
     *
     * The stream of download state info for up to 2 simultaneously connected devices.
     *
     * @return The value of the field "oDownloadStateStream"
     */
    inline const ::most_PhonBk_fi_types::T_PhonBkDownloadStateStream& getODownloadStateStream () const;

    /**
     * Retrieves the value of the field "oDownloadStateStream" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oDownloadStateStream".
     */
    inline ::most_PhonBk_fi_types::T_PhonBkDownloadStateStream& getODownloadStateStreamMutable ();

    /**
     * Sets the value of the member "oDownloadStateStream".
     *
     * The stream of download state info for up to 2 simultaneously connected devices.
     *
     * @param oDownloadStateStream The value which will be set
     */
    inline void setODownloadStateStream (const ::most_PhonBk_fi_types::T_PhonBkDownloadStateStream& oDownloadStateStream_);

    static const DownloadStateStatus &getDefaultInstance();

private:

    static const ::std::vector< ::most_PhonBk_fi_types::T_PhonBkDownloadStateStreamItem >& getT_PhonBkDownloadStateStreamItemList_DefaultInstance ();

    inline void set_has_oDownloadStateStream ();

    inline void clear_has_oDownloadStateStream ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_PhonBk_fi_types::T_PhonBkDownloadStateStream _oDownloadStateStream;

};

/**
 * The error message of 'DownloadState'
 */
class DownloadStateErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DownloadStateErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DownloadStateErrorStructure (const DownloadStateErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DownloadStateErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~DownloadStateErrorStructure();

    /**
     * Assignment operator
     */
    inline DownloadStateErrorStructure& operator = (const DownloadStateErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DownloadStateErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DownloadStateErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DownloadStateErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DownloadStateErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     *
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     *
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     *
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     *
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const DownloadStateErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'DownloadState'
 */
class DownloadStateError  : public ::asf::core::Payload {
public:

    enum DownloadStateErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DownloadStateError ();

   /**
     * Copy constructor
     */
    inline  DownloadStateError (const DownloadStateError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DownloadStateError();

    /**
     * Assigns a new value to this object.
     */
    inline DownloadStateError& operator = (const DownloadStateError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DownloadStateError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DownloadStateError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DownloadStateError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DownloadStateError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DownloadStateError::DownloadStateErrorField getField () const;

    inline void setField(DownloadStateError::DownloadStateErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DownloadStateErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DownloadStateErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DownloadStateErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DownloadStateErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DownloadStateErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DownloadStateErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DownloadStateErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DownloadStateErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DownloadStateError &getDefaultInstance();

private:

    inline void cloneData (const DownloadStateError& rhs);

    inline void deleteData ();

    DownloadStateErrorField __field;

    union {
        DownloadStateErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "StoreFavorite"
 * <p>
 * The StoreFavorite function stores in persistent memory recall
 * information for the object identified by the ObjectID. The recall
 * information stored enables the following actions to be performed at a
 * later time:
 * </p>
 *
 * <item>
 * Activate the favorite
 * </item>
 * <item>
 * Determine if the favorite is currently active
 * </item>
 * <item>
 * Determine if the favorite is currently available
 * </item>
 * <item>
 * Determine the current LabelText and DescriptorText strings
 * </item>
 *
 * <p>
 * The StoreFavorite function assigns a locally-unique FavoriteID to the
 * new favorite. This FavoriteID and recall information are bound and
 * stored in persistent memory.
 * </p>
 */
class StoreFavoriteStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StoreFavoriteStart ();

    /**
     * Copy constructor
     */
    inline  StoreFavoriteStart (const StoreFavoriteStart &rhs);

    /**
     * All fields constructor
     */
    inline  StoreFavoriteStart (uint32 u32ObjectID_);

    /**
     * Destructor
     */
    inline virtual  ~StoreFavoriteStart();

    /**
     * Assignment operator
     */
    inline StoreFavoriteStart& operator = (const StoreFavoriteStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StoreFavoriteStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StoreFavoriteStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StoreFavoriteStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StoreFavoriteStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32ObjectID"

    static const int kU32ObjectID = 0;

    /**
     * Clears the field "u32ObjectID".
     *
     * The field will be set to its default value. The hasU32ObjectID()
     * method will return false.
     */
    inline void clearU32ObjectID();

    /**
     * Checks whether the field "u32ObjectID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ObjectID()). Otherwise it will return false.
     */
    inline bool hasU32ObjectID () const;

    /**
     * Returns the value of the member "u32ObjectID".
     *
     * <p>
     * The ObjectID parameter identifies the object, e.g. song, contact phone number or destination, to be added as a favorite.  The ObjectID is used by the Favorite Provider to determine what recall information to store.  The Favorite Provider is responsible for assigning an ObjectID to each object which can be stored as a favorite and passing this information to the HMI whenever the associated object is passed to the HMI.
     *
     * Note:  An ObjectID = 0 represents the currently playing object or current settings, e.g. the AM/FM frequency tuned to or the current HVAC settings.
     * </p>
     *
     * @return The value of the field "u32ObjectID"
     */
    inline uint32 getU32ObjectID () const;

    /**
     * Sets the value of the member "u32ObjectID".
     *
     * <p>
     * The ObjectID parameter identifies the object, e.g. song, contact phone number or destination, to be added as a favorite.  The ObjectID is used by the Favorite Provider to determine what recall information to store.  The Favorite Provider is responsible for assigning an ObjectID to each object which can be stored as a favorite and passing this information to the HMI whenever the associated object is passed to the HMI.
     *
     * Note:  An ObjectID = 0 represents the currently playing object or current settings, e.g. the AM/FM frequency tuned to or the current HVAC settings.
     * </p>
     *
     * @param u32ObjectID The value which will be set
     */
    inline void setU32ObjectID (uint32 u32ObjectID_);

    static const StoreFavoriteStart &getDefaultInstance();

private:

    inline void set_has_u32ObjectID ();

    inline void clear_has_u32ObjectID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _u32ObjectID;

};

/**
 * The result message of the method "StoreFavorite"
 * <p>
 * The StoreFavorite function stores in persistent memory recall
 * information for the object identified by the ObjectID. The recall
 * information stored enables the following actions to be performed at a
 * later time:
 * </p>
 *
 * <item>
 * Activate the favorite
 * </item>
 * <item>
 * Determine if the favorite is currently active
 * </item>
 * <item>
 * Determine if the favorite is currently available
 * </item>
 * <item>
 * Determine the current LabelText and DescriptorText strings
 * </item>
 *
 * <p>
 * The StoreFavorite function assigns a locally-unique FavoriteID to the
 * new favorite. This FavoriteID and recall information are bound and
 * stored in persistent memory.
 * </p>
 */
class StoreFavoriteResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StoreFavoriteResult ();

    /**
     * Copy constructor
     */
    inline  StoreFavoriteResult (const StoreFavoriteResult &rhs);

    /**
     * All fields constructor
     */
    inline  StoreFavoriteResult (uint16 u16FavoriteID_);

    /**
     * Destructor
     */
    inline virtual  ~StoreFavoriteResult();

    /**
     * Assignment operator
     */
    inline StoreFavoriteResult& operator = (const StoreFavoriteResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StoreFavoriteResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StoreFavoriteResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StoreFavoriteResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StoreFavoriteResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16FavoriteID"

    static const int kU16FavoriteID = 0;

    /**
     * Clears the field "u16FavoriteID".
     *
     * The field will be set to its default value. The hasU16FavoriteID()
     * method will return false.
     */
    inline void clearU16FavoriteID();

    /**
     * Checks whether the field "u16FavoriteID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16FavoriteID()). Otherwise it will return false.
     */
    inline bool hasU16FavoriteID () const;

    /**
     * Returns the value of the member "u16FavoriteID".
     *
     * <p>
     * The FavoriteID uniquely identifies a stored favorite. The value of
     * 0x0000 is reserved for a special case. A FavoriteID = 0x0000 refers to
     * all favorites stored.
     * </p>
     *
     * @return The value of the field "u16FavoriteID"
     */
    inline uint16 getU16FavoriteID () const;

    /**
     * Sets the value of the member "u16FavoriteID".
     *
     * <p>
     * The FavoriteID uniquely identifies a stored favorite. The value of
     * 0x0000 is reserved for a special case. A FavoriteID = 0x0000 refers to
     * all favorites stored.
     * </p>
     *
     * @param u16FavoriteID The value which will be set
     */
    inline void setU16FavoriteID (uint16 u16FavoriteID_);

    static const StoreFavoriteResult &getDefaultInstance();

private:

    inline void set_has_u16FavoriteID ();

    inline void clear_has_u16FavoriteID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16FavoriteID;

};

/**
 * The error message of 'StoreFavorite'
 */
class StoreFavoriteErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  StoreFavoriteErrorStructure ();

    /**
     * Copy constructor
     */
    inline  StoreFavoriteErrorStructure (const StoreFavoriteErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  StoreFavoriteErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~StoreFavoriteErrorStructure();

    /**
     * Assignment operator
     */
    inline StoreFavoriteErrorStructure& operator = (const StoreFavoriteErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StoreFavoriteErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StoreFavoriteErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StoreFavoriteErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StoreFavoriteErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * <p>
     * Refer to section &quot;Structure of MOST Messages - OPType - Error&quot; in the
     * MOST Specification for a description of ErrorCode.
     * </p>
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * <p>
     * Refer to section &quot;Structure of MOST Messages - OPType - Error&quot; in the
     * MOST Specification for a description of ErrorCode.
     * </p>
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     *
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     *
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const StoreFavoriteErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'StoreFavorite'
 */
class StoreFavoriteError  : public ::asf::core::Payload {
public:

    enum StoreFavoriteErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  StoreFavoriteError ();

   /**
     * Copy constructor
     */
    inline  StoreFavoriteError (const StoreFavoriteError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~StoreFavoriteError();

    /**
     * Assigns a new value to this object.
     */
    inline StoreFavoriteError& operator = (const StoreFavoriteError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StoreFavoriteError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StoreFavoriteError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StoreFavoriteError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StoreFavoriteError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline StoreFavoriteError::StoreFavoriteErrorField getField () const;

    inline void setField(StoreFavoriteError::StoreFavoriteErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "StoreFavoriteErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "StoreFavoriteErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const StoreFavoriteErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline StoreFavoriteErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline StoreFavoriteErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (StoreFavoriteErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "StoreFavoriteErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const StoreFavoriteErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const StoreFavoriteError &getDefaultInstance();

private:

    inline void cloneData (const StoreFavoriteError& rhs);

    inline void deleteData ();

    StoreFavoriteErrorField __field;

    union {
        StoreFavoriteErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "ActivateFavorite"
 * <p>
 * The ActivateFavorite function activates the favorite identified by the
 * FavoriteID parameter if f the AudioChannel and VideoChannel are
 * appropriate for the favorite. If the AudioChannel or the VideoChannel
 * are not appropriate then an error is returned.
 * </p>
 */
class ActivateFavoriteStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActivateFavoriteStart ();

    /**
     * Copy constructor
     */
    inline  ActivateFavoriteStart (const ActivateFavoriteStart &rhs);

    /**
     * All fields constructor
     */
    inline  ActivateFavoriteStart (uint16 u16FavoriteID_, ::most_FavPrv_fi_types::T_e8_FavPrvAudioChannel e8AudioChannel_, ::most_FavPrv_fi_types::T_e8_FavPrvVideoChannel e8VideoChannel_);

    /**
     * Destructor
     */
    inline virtual  ~ActivateFavoriteStart();

    /**
     * Assignment operator
     */
    inline ActivateFavoriteStart& operator = (const ActivateFavoriteStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActivateFavoriteStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActivateFavoriteStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActivateFavoriteStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActivateFavoriteStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16FavoriteID"

    static const int kU16FavoriteID = 0;

    /**
     * Clears the field "u16FavoriteID".
     *
     * The field will be set to its default value. The hasU16FavoriteID()
     * method will return false.
     */
    inline void clearU16FavoriteID();

    /**
     * Checks whether the field "u16FavoriteID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16FavoriteID()). Otherwise it will return false.
     */
    inline bool hasU16FavoriteID () const;

    /**
     * Returns the value of the member "u16FavoriteID".
     *
     * <p>
     * The FavoriteID uniquely identifies a stored favorite. The value of
     * 0x0000 is reserved for a special case. A FavoriteID = 0x0000 refers to
     * all favorites stored.
     * </p>
     *
     * @return The value of the field "u16FavoriteID"
     */
    inline uint16 getU16FavoriteID () const;

    /**
     * Sets the value of the member "u16FavoriteID".
     *
     * <p>
     * The FavoriteID uniquely identifies a stored favorite. The value of
     * 0x0000 is reserved for a special case. A FavoriteID = 0x0000 refers to
     * all favorites stored.
     * </p>
     *
     * @param u16FavoriteID The value which will be set
     */
    inline void setU16FavoriteID (uint16 u16FavoriteID_);

    // API of field "e8AudioChannel"

    static const int kE8AudioChannel = 1;

    /**
     * Clears the field "e8AudioChannel".
     *
     * The field will be set to its default value. The hasE8AudioChannel()
     * method will return false.
     */
    inline void clearE8AudioChannel();

    /**
     * Checks whether the field "e8AudioChannel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8AudioChannel()). Otherwise it will return false.
     */
    inline bool hasE8AudioChannel () const;

    /**
     * Returns the value of the member "e8AudioChannel".
     *
     * <p>
     * The AudioChannel parameter specifies the channel to route the favorite's
     * audio to.
     * </p>
     *
     * @return The value of the field "e8AudioChannel"
     */
    inline ::most_FavPrv_fi_types::T_e8_FavPrvAudioChannel getE8AudioChannel () const;

    /**
     * Sets the value of the member "e8AudioChannel".
     *
     * <p>
     * The AudioChannel parameter specifies the channel to route the favorite's
     * audio to.
     * </p>
     *
     * @param e8AudioChannel The value which will be set
     */
    inline void setE8AudioChannel (::most_FavPrv_fi_types::T_e8_FavPrvAudioChannel e8AudioChannel_);

    // API of field "e8VideoChannel"

    static const int kE8VideoChannel = 2;

    /**
     * Clears the field "e8VideoChannel".
     *
     * The field will be set to its default value. The hasE8VideoChannel()
     * method will return false.
     */
    inline void clearE8VideoChannel();

    /**
     * Checks whether the field "e8VideoChannel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8VideoChannel()). Otherwise it will return false.
     */
    inline bool hasE8VideoChannel () const;

    /**
     * Returns the value of the member "e8VideoChannel".
     *
     * <p>
     * The VideoChannel parameter specifies the channel to route the favorite's video to.
     * </p>
     *
     * @return The value of the field "e8VideoChannel"
     */
    inline ::most_FavPrv_fi_types::T_e8_FavPrvVideoChannel getE8VideoChannel () const;

    /**
     * Sets the value of the member "e8VideoChannel".
     *
     * <p>
     * The VideoChannel parameter specifies the channel to route the favorite's video to.
     * </p>
     *
     * @param e8VideoChannel The value which will be set
     */
    inline void setE8VideoChannel (::most_FavPrv_fi_types::T_e8_FavPrvVideoChannel e8VideoChannel_);

    static const ActivateFavoriteStart &getDefaultInstance();

private:

    inline void set_has_u16FavoriteID ();

    inline void clear_has_u16FavoriteID ();

    inline void set_has_e8AudioChannel ();

    inline void clear_has_e8AudioChannel ();

    inline void set_has_e8VideoChannel ();

    inline void clear_has_e8VideoChannel ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint16 _u16FavoriteID;

    ::most_FavPrv_fi_types::T_e8_FavPrvAudioChannel _e8AudioChannel;

    ::most_FavPrv_fi_types::T_e8_FavPrvVideoChannel _e8VideoChannel;

};

/**
 * The result message of the method "ActivateFavorite"
 * <p>
 * The ActivateFavorite function activates the favorite identified by the
 * FavoriteID parameter if f the AudioChannel and VideoChannel are
 * appropriate for the favorite. If the AudioChannel or the VideoChannel
 * are not appropriate then an error is returned.
 * </p>
 */
class ActivateFavoriteResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActivateFavoriteResult ();

    /**
     * Copy constructor
     */
    inline  ActivateFavoriteResult (const ActivateFavoriteResult &rhs);

    /**
     * All fields constructor
     */
    inline  ActivateFavoriteResult (uint16 u16FavoriteID_, uint32 u32ActivationHandle_);

    /**
     * Destructor
     */
    inline virtual  ~ActivateFavoriteResult();

    /**
     * Assignment operator
     */
    inline ActivateFavoriteResult& operator = (const ActivateFavoriteResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActivateFavoriteResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActivateFavoriteResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActivateFavoriteResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActivateFavoriteResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16FavoriteID"

    static const int kU16FavoriteID = 0;

    /**
     * Clears the field "u16FavoriteID".
     *
     * The field will be set to its default value. The hasU16FavoriteID()
     * method will return false.
     */
    inline void clearU16FavoriteID();

    /**
     * Checks whether the field "u16FavoriteID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16FavoriteID()). Otherwise it will return false.
     */
    inline bool hasU16FavoriteID () const;

    /**
     * Returns the value of the member "u16FavoriteID".
     *
     * <p>
     * The FavoriteID uniquely identifies a stored favorite. The value of
     * 0x0000 is reserved for a special case. A FavoriteID = 0x0000 refers to
     * all favorites stored.
     * </p>
     *
     * @return The value of the field "u16FavoriteID"
     */
    inline uint16 getU16FavoriteID () const;

    /**
     * Sets the value of the member "u16FavoriteID".
     *
     * <p>
     * The FavoriteID uniquely identifies a stored favorite. The value of
     * 0x0000 is reserved for a special case. A FavoriteID = 0x0000 refers to
     * all favorites stored.
     * </p>
     *
     * @param u16FavoriteID The value which will be set
     */
    inline void setU16FavoriteID (uint16 u16FavoriteID_);

    // API of field "u32ActivationHandle"

    static const int kU32ActivationHandle = 1;

    /**
     * Clears the field "u32ActivationHandle".
     *
     * The field will be set to its default value. The hasU32ActivationHandle()
     * method will return false.
     */
    inline void clearU32ActivationHandle();

    /**
     * Checks whether the field "u32ActivationHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ActivationHandle()). Otherwise it will return false.
     */
    inline bool hasU32ActivationHandle () const;

    /**
     * Returns the value of the member "u32ActivationHandle".
     *
     * The ActivationHandle parameter may be used by an HMI to obtain additional information regarding a Favorite activated, i.e. selected, by the user.  The contents of the ActivationHandle parameter will depend upon the FavoriteType of the Favorite selected.  For example, if FavoriteType = FT_PHONE_NUMBER, then ActivationHandle = CallInstance of the phone call initiated.  Reference the GIS document associated with each Favorite Provider for the value of the ActivationHandle.
     *
     * @return The value of the field "u32ActivationHandle"
     */
    inline uint32 getU32ActivationHandle () const;

    /**
     * Sets the value of the member "u32ActivationHandle".
     *
     * The ActivationHandle parameter may be used by an HMI to obtain additional information regarding a Favorite activated, i.e. selected, by the user.  The contents of the ActivationHandle parameter will depend upon the FavoriteType of the Favorite selected.  For example, if FavoriteType = FT_PHONE_NUMBER, then ActivationHandle = CallInstance of the phone call initiated.  Reference the GIS document associated with each Favorite Provider for the value of the ActivationHandle.
     *
     * @param u32ActivationHandle The value which will be set
     */
    inline void setU32ActivationHandle (uint32 u32ActivationHandle_);

    static const ActivateFavoriteResult &getDefaultInstance();

private:

    inline void set_has_u16FavoriteID ();

    inline void clear_has_u16FavoriteID ();

    inline void set_has_u32ActivationHandle ();

    inline void clear_has_u32ActivationHandle ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _u16FavoriteID;

    uint32 _u32ActivationHandle;

};

/**
 * The error message of 'ActivateFavorite'
 */
class ActivateFavoriteErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  ActivateFavoriteErrorStructure ();

    /**
     * Copy constructor
     */
    inline  ActivateFavoriteErrorStructure (const ActivateFavoriteErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  ActivateFavoriteErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~ActivateFavoriteErrorStructure();

    /**
     * Assignment operator
     */
    inline ActivateFavoriteErrorStructure& operator = (const ActivateFavoriteErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActivateFavoriteErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActivateFavoriteErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActivateFavoriteErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActivateFavoriteErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * <p>
     * Refer to section &quot;Structure of MOST Messages - OPType - Error&quot; in the
     * MOST Specification for a description of ErrorCode.
     * </p>
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * <p>
     * Refer to section &quot;Structure of MOST Messages - OPType - Error&quot; in the
     * MOST Specification for a description of ErrorCode.
     * </p>
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     *
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     *
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const ActivateFavoriteErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'ActivateFavorite'
 */
class ActivateFavoriteError  : public ::asf::core::Payload {
public:

    enum ActivateFavoriteErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  ActivateFavoriteError ();

   /**
     * Copy constructor
     */
    inline  ActivateFavoriteError (const ActivateFavoriteError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~ActivateFavoriteError();

    /**
     * Assigns a new value to this object.
     */
    inline ActivateFavoriteError& operator = (const ActivateFavoriteError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActivateFavoriteError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActivateFavoriteError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActivateFavoriteError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActivateFavoriteError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline ActivateFavoriteError::ActivateFavoriteErrorField getField () const;

    inline void setField(ActivateFavoriteError::ActivateFavoriteErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "ActivateFavoriteErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "ActivateFavoriteErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ActivateFavoriteErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ActivateFavoriteErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline ActivateFavoriteErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (ActivateFavoriteErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "ActivateFavoriteErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const ActivateFavoriteErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const ActivateFavoriteError &getDefaultInstance();

private:

    inline void cloneData (const ActivateFavoriteError& rhs);

    inline void deleteData ();

    ActivateFavoriteErrorField __field;

    union {
        ActivateFavoriteErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "DeleteFavorite"
 * <p>
 * The DeleteFavorite function deletes the favorite identified by the FavoriteID parameter.
 *
 * If FavoriteID=0 then all favorites are to be deleted.
 * </p>
 */
class DeleteFavoriteStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeleteFavoriteStart ();

    /**
     * Copy constructor
     */
    inline  DeleteFavoriteStart (const DeleteFavoriteStart &rhs);

    /**
     * All fields constructor
     */
    inline  DeleteFavoriteStart (uint16 u16FavoriteID_);

    /**
     * Destructor
     */
    inline virtual  ~DeleteFavoriteStart();

    /**
     * Assignment operator
     */
    inline DeleteFavoriteStart& operator = (const DeleteFavoriteStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeleteFavoriteStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeleteFavoriteStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeleteFavoriteStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeleteFavoriteStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16FavoriteID"

    static const int kU16FavoriteID = 0;

    /**
     * Clears the field "u16FavoriteID".
     *
     * The field will be set to its default value. The hasU16FavoriteID()
     * method will return false.
     */
    inline void clearU16FavoriteID();

    /**
     * Checks whether the field "u16FavoriteID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16FavoriteID()). Otherwise it will return false.
     */
    inline bool hasU16FavoriteID () const;

    /**
     * Returns the value of the member "u16FavoriteID".
     *
     * <p>
     * The FavoriteID uniquely identifies a stored favorite. The value of
     * 0x0000 is reserved for a special case. A FavoriteID = 0x0000 refers to
     * all favorites stored.
     * </p>
     *
     * @return The value of the field "u16FavoriteID"
     */
    inline uint16 getU16FavoriteID () const;

    /**
     * Sets the value of the member "u16FavoriteID".
     *
     * <p>
     * The FavoriteID uniquely identifies a stored favorite. The value of
     * 0x0000 is reserved for a special case. A FavoriteID = 0x0000 refers to
     * all favorites stored.
     * </p>
     *
     * @param u16FavoriteID The value which will be set
     */
    inline void setU16FavoriteID (uint16 u16FavoriteID_);

    static const DeleteFavoriteStart &getDefaultInstance();

private:

    inline void set_has_u16FavoriteID ();

    inline void clear_has_u16FavoriteID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16FavoriteID;

};

/**
 * The result message of the method "DeleteFavorite"
 * <p>
 * The DeleteFavorite function deletes the favorite identified by the FavoriteID parameter.
 *
 * If FavoriteID=0 then all favorites are to be deleted.
 * </p>
 */
class DeleteFavoriteResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeleteFavoriteResult ();

    /**
     * Copy constructor
     */
    inline  DeleteFavoriteResult (const DeleteFavoriteResult &rhs);

    /**
     * All fields constructor
     */
    inline  DeleteFavoriteResult (uint16 u16FavoriteID_);

    /**
     * Destructor
     */
    inline virtual  ~DeleteFavoriteResult();

    /**
     * Assignment operator
     */
    inline DeleteFavoriteResult& operator = (const DeleteFavoriteResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeleteFavoriteResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeleteFavoriteResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeleteFavoriteResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeleteFavoriteResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16FavoriteID"

    static const int kU16FavoriteID = 0;

    /**
     * Clears the field "u16FavoriteID".
     *
     * The field will be set to its default value. The hasU16FavoriteID()
     * method will return false.
     */
    inline void clearU16FavoriteID();

    /**
     * Checks whether the field "u16FavoriteID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16FavoriteID()). Otherwise it will return false.
     */
    inline bool hasU16FavoriteID () const;

    /**
     * Returns the value of the member "u16FavoriteID".
     *
     * <p>
     * The FavoriteID uniquely identifies a stored favorite. The value of
     * 0x0000 is reserved for a special case. A FavoriteID = 0x0000 refers to
     * all favorites stored.
     * </p>
     *
     * @return The value of the field "u16FavoriteID"
     */
    inline uint16 getU16FavoriteID () const;

    /**
     * Sets the value of the member "u16FavoriteID".
     *
     * <p>
     * The FavoriteID uniquely identifies a stored favorite. The value of
     * 0x0000 is reserved for a special case. A FavoriteID = 0x0000 refers to
     * all favorites stored.
     * </p>
     *
     * @param u16FavoriteID The value which will be set
     */
    inline void setU16FavoriteID (uint16 u16FavoriteID_);

    static const DeleteFavoriteResult &getDefaultInstance();

private:

    inline void set_has_u16FavoriteID ();

    inline void clear_has_u16FavoriteID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16FavoriteID;

};

/**
 * The error message of 'DeleteFavorite'
 */
class DeleteFavoriteErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DeleteFavoriteErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DeleteFavoriteErrorStructure (const DeleteFavoriteErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DeleteFavoriteErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~DeleteFavoriteErrorStructure();

    /**
     * Assignment operator
     */
    inline DeleteFavoriteErrorStructure& operator = (const DeleteFavoriteErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeleteFavoriteErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeleteFavoriteErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeleteFavoriteErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeleteFavoriteErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * <p>
     * Refer to section &quot;Structure of MOST Messages - OPType - Error&quot; in the
     * MOST Specification for a description of ErrorCode.
     * </p>
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * <p>
     * Refer to section &quot;Structure of MOST Messages - OPType - Error&quot; in the
     * MOST Specification for a description of ErrorCode.
     * </p>
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     *
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     *
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const DeleteFavoriteErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'DeleteFavorite'
 */
class DeleteFavoriteError  : public ::asf::core::Payload {
public:

    enum DeleteFavoriteErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DeleteFavoriteError ();

   /**
     * Copy constructor
     */
    inline  DeleteFavoriteError (const DeleteFavoriteError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DeleteFavoriteError();

    /**
     * Assigns a new value to this object.
     */
    inline DeleteFavoriteError& operator = (const DeleteFavoriteError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeleteFavoriteError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeleteFavoriteError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeleteFavoriteError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeleteFavoriteError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DeleteFavoriteError::DeleteFavoriteErrorField getField () const;

    inline void setField(DeleteFavoriteError::DeleteFavoriteErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DeleteFavoriteErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DeleteFavoriteErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DeleteFavoriteErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DeleteFavoriteErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DeleteFavoriteErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DeleteFavoriteErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DeleteFavoriteErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DeleteFavoriteErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DeleteFavoriteError &getDefaultInstance();

private:

    inline void cloneData (const DeleteFavoriteError& rhs);

    inline void deleteData ();

    DeleteFavoriteErrorField __field;

    union {
        DeleteFavoriteErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "GetFavoriteInfo"
 * The GetFavoriteInfo function provides FavoriteInfo for 1 or all Favorites stored in the Favorite Provider.  If the FavoriteID parameter = 0 then FavoriteInfo constains data for all stored favorites.  Otherwise, only FavoriteInfo only contains data for FavoriteID.
 */
class GetFavoriteInfoStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetFavoriteInfoStart ();

    /**
     * Copy constructor
     */
    inline  GetFavoriteInfoStart (const GetFavoriteInfoStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetFavoriteInfoStart (uint16 u16FavoriteID_);

    /**
     * Destructor
     */
    inline virtual  ~GetFavoriteInfoStart();

    /**
     * Assignment operator
     */
    inline GetFavoriteInfoStart& operator = (const GetFavoriteInfoStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetFavoriteInfoStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetFavoriteInfoStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetFavoriteInfoStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetFavoriteInfoStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16FavoriteID"

    static const int kU16FavoriteID = 0;

    /**
     * Clears the field "u16FavoriteID".
     *
     * The field will be set to its default value. The hasU16FavoriteID()
     * method will return false.
     */
    inline void clearU16FavoriteID();

    /**
     * Checks whether the field "u16FavoriteID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16FavoriteID()). Otherwise it will return false.
     */
    inline bool hasU16FavoriteID () const;

    /**
     * Returns the value of the member "u16FavoriteID".
     *
     * <p>
     * The FavoriteID uniquely identifies a stored favorite. The value of
     * 0x0000 is reserved for a special case. A FavoriteID = 0x0000 refers to
     * all favorites stored.
     * </p>
     *
     * @return The value of the field "u16FavoriteID"
     */
    inline uint16 getU16FavoriteID () const;

    /**
     * Sets the value of the member "u16FavoriteID".
     *
     * <p>
     * The FavoriteID uniquely identifies a stored favorite. The value of
     * 0x0000 is reserved for a special case. A FavoriteID = 0x0000 refers to
     * all favorites stored.
     * </p>
     *
     * @param u16FavoriteID The value which will be set
     */
    inline void setU16FavoriteID (uint16 u16FavoriteID_);

    static const GetFavoriteInfoStart &getDefaultInstance();

private:

    inline void set_has_u16FavoriteID ();

    inline void clear_has_u16FavoriteID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16FavoriteID;

};

/**
 * The result message of the method "GetFavoriteInfo"
 * The GetFavoriteInfo function provides FavoriteInfo for 1 or all Favorites stored in the Favorite Provider.  If the FavoriteID parameter = 0 then FavoriteInfo constains data for all stored favorites.  Otherwise, only FavoriteInfo only contains data for FavoriteID.
 */
class GetFavoriteInfoResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetFavoriteInfoResult ();

    /**
     * Copy constructor
     */
    inline  GetFavoriteInfoResult (const GetFavoriteInfoResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetFavoriteInfoResult (uint32 u32NumItems_, const ::most_FavPrv_fi_types::T_FavPrvFavoriteInfo& oFavoriteInfo_);

    /**
     * Destructor
     */
    inline virtual  ~GetFavoriteInfoResult();

    /**
     * Assignment operator
     */
    inline GetFavoriteInfoResult& operator = (const GetFavoriteInfoResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetFavoriteInfoResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetFavoriteInfoResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetFavoriteInfoResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetFavoriteInfoResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32NumItems"

    static const int kU32NumItems = 0;

    /**
     * Clears the field "u32NumItems".
     *
     * The field will be set to its default value. The hasU32NumItems()
     * method will return false.
     */
    inline void clearU32NumItems();

    /**
     * Checks whether the field "u32NumItems" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32NumItems()). Otherwise it will return false.
     */
    inline bool hasU32NumItems () const;

    /**
     * Returns the value of the member "u32NumItems".
     *
     * The NumItems parameter specifies the number of items or groups of items in a stream.
     *
     * @return The value of the field "u32NumItems"
     */
    inline uint32 getU32NumItems () const;

    /**
     * Sets the value of the member "u32NumItems".
     *
     * The NumItems parameter specifies the number of items or groups of items in a stream.
     *
     * @param u32NumItems The value which will be set
     */
    inline void setU32NumItems (uint32 u32NumItems_);

    // API of field "oFavoriteInfo"

    static const int kOFavoriteInfo = 1;

    /**
     * Clears the field "oFavoriteInfo".
     *
     * The field will be set to its default value. The hasOFavoriteInfo()
     * method will return false.
     */
    inline void clearOFavoriteInfo();

    /**
     * Checks whether the field "oFavoriteInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOFavoriteInfo()). Otherwise it will return false.
     */
    inline bool hasOFavoriteInfo () const;

    /**
     * Returns the value of the member "oFavoriteInfo".
     *
     * <p>
     * The FavoriteInfo is a steam which contains information for one or more
     * favorite.
     * </p>
     *
     * @return The value of the field "oFavoriteInfo"
     */
    inline const ::most_FavPrv_fi_types::T_FavPrvFavoriteInfo& getOFavoriteInfo () const;

    /**
     * Retrieves the value of the field "oFavoriteInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oFavoriteInfo".
     */
    inline ::most_FavPrv_fi_types::T_FavPrvFavoriteInfo& getOFavoriteInfoMutable ();

    /**
     * Sets the value of the member "oFavoriteInfo".
     *
     * <p>
     * The FavoriteInfo is a steam which contains information for one or more
     * favorite.
     * </p>
     *
     * @param oFavoriteInfo The value which will be set
     */
    inline void setOFavoriteInfo (const ::most_FavPrv_fi_types::T_FavPrvFavoriteInfo& oFavoriteInfo_);

    static const GetFavoriteInfoResult &getDefaultInstance();

private:

    static const ::std::vector< ::most_FavPrv_fi_types::T_FavPrvFavoriteInfoItem >& getT_FavPrvFavoriteInfoItemList_DefaultInstance ();

    inline void set_has_u32NumItems ();

    inline void clear_has_u32NumItems ();

    inline void set_has_oFavoriteInfo ();

    inline void clear_has_oFavoriteInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _u32NumItems;

    ::most_FavPrv_fi_types::T_FavPrvFavoriteInfo _oFavoriteInfo;

};

/**
 * The error message of 'GetFavoriteInfo'
 */
class GetFavoriteInfoErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetFavoriteInfoErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetFavoriteInfoErrorStructure (const GetFavoriteInfoErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetFavoriteInfoErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~GetFavoriteInfoErrorStructure();

    /**
     * Assignment operator
     */
    inline GetFavoriteInfoErrorStructure& operator = (const GetFavoriteInfoErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetFavoriteInfoErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetFavoriteInfoErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetFavoriteInfoErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetFavoriteInfoErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * <p>
     * Refer to section &quot;Structure of MOST Messages - OPType - Error&quot; in the
     * MOST Specification for a description of ErrorCode.
     * </p>
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * <p>
     * Refer to section &quot;Structure of MOST Messages - OPType - Error&quot; in the
     * MOST Specification for a description of ErrorCode.
     * </p>
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     *
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     *
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const GetFavoriteInfoErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'GetFavoriteInfo'
 */
class GetFavoriteInfoError  : public ::asf::core::Payload {
public:

    enum GetFavoriteInfoErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetFavoriteInfoError ();

   /**
     * Copy constructor
     */
    inline  GetFavoriteInfoError (const GetFavoriteInfoError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetFavoriteInfoError();

    /**
     * Assigns a new value to this object.
     */
    inline GetFavoriteInfoError& operator = (const GetFavoriteInfoError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetFavoriteInfoError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetFavoriteInfoError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetFavoriteInfoError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetFavoriteInfoError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetFavoriteInfoError::GetFavoriteInfoErrorField getField () const;

    inline void setField(GetFavoriteInfoError::GetFavoriteInfoErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetFavoriteInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetFavoriteInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetFavoriteInfoErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetFavoriteInfoErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetFavoriteInfoErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetFavoriteInfoErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetFavoriteInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetFavoriteInfoErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetFavoriteInfoError &getDefaultInstance();

private:

    inline void cloneData (const GetFavoriteInfoError& rhs);

    inline void deleteData ();

    GetFavoriteInfoErrorField __field;

    union {
        GetFavoriteInfoErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The error message of 'ResetFavorites'
 */
class ResetFavoritesErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  ResetFavoritesErrorStructure ();

    /**
     * Copy constructor
     */
    inline  ResetFavoritesErrorStructure (const ResetFavoritesErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  ResetFavoritesErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~ResetFavoritesErrorStructure();

    /**
     * Assignment operator
     */
    inline ResetFavoritesErrorStructure& operator = (const ResetFavoritesErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ResetFavoritesErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ResetFavoritesErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ResetFavoritesErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ResetFavoritesErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * <p>
     * Refer to section &quot;Structure of MOST Messages - OPType - Error&quot; in the
     * MOST Specification for a description of ErrorCode.
     * </p>
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * <p>
     * Refer to section &quot;Structure of MOST Messages - OPType - Error&quot; in the
     * MOST Specification for a description of ErrorCode.
     * </p>
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     *
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     *
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const ResetFavoritesErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'ResetFavorites'
 */
class ResetFavoritesError  : public ::asf::core::Payload {
public:

    enum ResetFavoritesErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  ResetFavoritesError ();

   /**
     * Copy constructor
     */
    inline  ResetFavoritesError (const ResetFavoritesError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~ResetFavoritesError();

    /**
     * Assigns a new value to this object.
     */
    inline ResetFavoritesError& operator = (const ResetFavoritesError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ResetFavoritesError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ResetFavoritesError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ResetFavoritesError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ResetFavoritesError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline ResetFavoritesError::ResetFavoritesErrorField getField () const;

    inline void setField(ResetFavoritesError::ResetFavoritesErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "ResetFavoritesErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "ResetFavoritesErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ResetFavoritesErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ResetFavoritesErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline ResetFavoritesErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (ResetFavoritesErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "ResetFavoritesErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const ResetFavoritesErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const ResetFavoritesError &getDefaultInstance();

private:

    inline void cloneData (const ResetFavoritesError& rhs);

    inline void deleteData ();

    ResetFavoritesErrorField __field;

    union {
        ResetFavoritesErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "CreatePhoneBookList"
 * Creates a Phone Book list of a particular type and returns a ListHandle to the caller.  Slices of the list can then be accessed via RequestPhoneBookListSlice.
 */
class CreatePhoneBookListStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CreatePhoneBookListStart ();

    /**
     * Copy constructor
     */
    inline  CreatePhoneBookListStart (const CreatePhoneBookListStart &rhs);

    /**
     * All fields constructor
     */
    inline  CreatePhoneBookListStart (uint8 u8DeviceHandle_, ::most_PhonBk_fi_types::T_e8_PhonBkPhoneBookSortType e8PhoneBookSortType_);

    /**
     * Destructor
     */
    inline virtual  ~CreatePhoneBookListStart();

    /**
     * Assignment operator
     */
    inline CreatePhoneBookListStart& operator = (const CreatePhoneBookListStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreatePhoneBookListStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreatePhoneBookListStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreatePhoneBookListStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreatePhoneBookListStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Handle of the device for the phone book source. The vehicle phone book has a DeviceHandle = 1.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Handle of the device for the phone book source. The vehicle phone book has a DeviceHandle = 1.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "e8PhoneBookSortType"

    static const int kE8PhoneBookSortType = 1;

    /**
     * Clears the field "e8PhoneBookSortType".
     *
     * The field will be set to its default value. The hasE8PhoneBookSortType()
     * method will return false.
     */
    inline void clearE8PhoneBookSortType();

    /**
     * Checks whether the field "e8PhoneBookSortType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PhoneBookSortType()). Otherwise it will return false.
     */
    inline bool hasE8PhoneBookSortType () const;

    /**
     * Returns the value of the member "e8PhoneBookSortType".
     *
     * Passed in CreatePhoneBookList to set the sort order of a created list.
     *
     * @return The value of the field "e8PhoneBookSortType"
     */
    inline ::most_PhonBk_fi_types::T_e8_PhonBkPhoneBookSortType getE8PhoneBookSortType () const;

    /**
     * Sets the value of the member "e8PhoneBookSortType".
     *
     * Passed in CreatePhoneBookList to set the sort order of a created list.
     *
     * @param e8PhoneBookSortType The value which will be set
     */
    inline void setE8PhoneBookSortType (::most_PhonBk_fi_types::T_e8_PhonBkPhoneBookSortType e8PhoneBookSortType_);

    static const CreatePhoneBookListStart &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_e8PhoneBookSortType ();

    inline void clear_has_e8PhoneBookSortType ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8DeviceHandle;

    ::most_PhonBk_fi_types::T_e8_PhonBkPhoneBookSortType _e8PhoneBookSortType;

};

/**
 * The result message of the method "CreatePhoneBookList"
 * Creates a Phone Book list of a particular type and returns a ListHandle to the caller.  Slices of the list can then be accessed via RequestPhoneBookListSlice.
 */
class CreatePhoneBookListResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CreatePhoneBookListResult ();

    /**
     * Copy constructor
     */
    inline  CreatePhoneBookListResult (const CreatePhoneBookListResult &rhs);

    /**
     * All fields constructor
     */
    inline  CreatePhoneBookListResult (uint16 u16ListHandle_, uint16 u16ListLength_);

    /**
     * Destructor
     */
    inline virtual  ~CreatePhoneBookListResult();

    /**
     * Assignment operator
     */
    inline CreatePhoneBookListResult& operator = (const CreatePhoneBookListResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreatePhoneBookListResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreatePhoneBookListResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreatePhoneBookListResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreatePhoneBookListResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ListHandle"

    static const int kU16ListHandle = 0;

    /**
     * Clears the field "u16ListHandle".
     *
     * The field will be set to its default value. The hasU16ListHandle()
     * method will return false.
     */
    inline void clearU16ListHandle();

    /**
     * Checks whether the field "u16ListHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ListHandle()). Otherwise it will return false.
     */
    inline bool hasU16ListHandle () const;

    /**
     * Returns the value of the member "u16ListHandle".
     *
     * The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @return The value of the field "u16ListHandle"
     */
    inline uint16 getU16ListHandle () const;

    /**
     * Sets the value of the member "u16ListHandle".
     *
     * The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @param u16ListHandle The value which will be set
     */
    inline void setU16ListHandle (uint16 u16ListHandle_);

    // API of field "u16ListLength"

    static const int kU16ListLength = 1;

    /**
     * Clears the field "u16ListLength".
     *
     * The field will be set to its default value. The hasU16ListLength()
     * method will return false.
     */
    inline void clearU16ListLength();

    /**
     * Checks whether the field "u16ListLength" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ListLength()). Otherwise it will return false.
     */
    inline bool hasU16ListLength () const;

    /**
     * Returns the value of the member "u16ListLength".
     *
     * The number of elements (i.e. contacts or recent calls) in the Phone Book or Call History list.  The length is valid until the list is modified or released.
     *
     * @return The value of the field "u16ListLength"
     */
    inline uint16 getU16ListLength () const;

    /**
     * Sets the value of the member "u16ListLength".
     *
     * The number of elements (i.e. contacts or recent calls) in the Phone Book or Call History list.  The length is valid until the list is modified or released.
     *
     * @param u16ListLength The value which will be set
     */
    inline void setU16ListLength (uint16 u16ListLength_);

    static const CreatePhoneBookListResult &getDefaultInstance();

private:

    inline void set_has_u16ListHandle ();

    inline void clear_has_u16ListHandle ();

    inline void set_has_u16ListLength ();

    inline void clear_has_u16ListLength ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _u16ListHandle;

    uint16 _u16ListLength;

};

/**
 * The error message of 'CreatePhoneBookList'
 */
class CreatePhoneBookListErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  CreatePhoneBookListErrorStructure ();

    /**
     * Copy constructor
     */
    inline  CreatePhoneBookListErrorStructure (const CreatePhoneBookListErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  CreatePhoneBookListErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~CreatePhoneBookListErrorStructure();

    /**
     * Assignment operator
     */
    inline CreatePhoneBookListErrorStructure& operator = (const CreatePhoneBookListErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreatePhoneBookListErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreatePhoneBookListErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreatePhoneBookListErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreatePhoneBookListErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     *
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     *
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     *
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     *
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const CreatePhoneBookListErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'CreatePhoneBookList'
 */
class CreatePhoneBookListError  : public ::asf::core::Payload {
public:

    enum CreatePhoneBookListErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  CreatePhoneBookListError ();

   /**
     * Copy constructor
     */
    inline  CreatePhoneBookListError (const CreatePhoneBookListError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~CreatePhoneBookListError();

    /**
     * Assigns a new value to this object.
     */
    inline CreatePhoneBookListError& operator = (const CreatePhoneBookListError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreatePhoneBookListError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreatePhoneBookListError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreatePhoneBookListError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreatePhoneBookListError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline CreatePhoneBookListError::CreatePhoneBookListErrorField getField () const;

    inline void setField(CreatePhoneBookListError::CreatePhoneBookListErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "CreatePhoneBookListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "CreatePhoneBookListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const CreatePhoneBookListErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline CreatePhoneBookListErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline CreatePhoneBookListErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (CreatePhoneBookListErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "CreatePhoneBookListErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const CreatePhoneBookListErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const CreatePhoneBookListError &getDefaultInstance();

private:

    inline void cloneData (const CreatePhoneBookListError& rhs);

    inline void deleteData ();

    CreatePhoneBookListErrorField __field;

    union {
        CreatePhoneBookListErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SearchKeyboardPhoneBookList"
 * This function returns the search keyboard for a particular ListHandle. The
 * returned list identifies which letters of the Vertical Keyboard have at
 * least one Phone Book entry that starts with that letter. The index of the
 * first entry associated with the letter is also provided.If a
 * letter does not have an index then a Phone Book entry that starts with
 * that letter does not exist.Note that the returned search keyboard
 * list may no longer be valid if items in the underlying list have changed.
 * Thus, controllers shall re-request the search keyboard list upon a receipt
 * of MediaPlayerListChange for the ListHandle tied to the returned search
 * keyboard.
 */
class SearchKeyboardPhoneBookListStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SearchKeyboardPhoneBookListStart ();

    /**
     * Copy constructor
     */
    inline  SearchKeyboardPhoneBookListStart (const SearchKeyboardPhoneBookListStart &rhs);

    /**
     * All fields constructor
     */
    inline  SearchKeyboardPhoneBookListStart (uint16 u16ListHandle_);

    /**
     * Destructor
     */
    inline virtual  ~SearchKeyboardPhoneBookListStart();

    /**
     * Assignment operator
     */
    inline SearchKeyboardPhoneBookListStart& operator = (const SearchKeyboardPhoneBookListStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SearchKeyboardPhoneBookListStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SearchKeyboardPhoneBookListStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SearchKeyboardPhoneBookListStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SearchKeyboardPhoneBookListStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ListHandle"

    static const int kU16ListHandle = 0;

    /**
     * Clears the field "u16ListHandle".
     *
     * The field will be set to its default value. The hasU16ListHandle()
     * method will return false.
     */
    inline void clearU16ListHandle();

    /**
     * Checks whether the field "u16ListHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ListHandle()). Otherwise it will return false.
     */
    inline bool hasU16ListHandle () const;

    /**
     * Returns the value of the member "u16ListHandle".
     *
     * The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @return The value of the field "u16ListHandle"
     */
    inline uint16 getU16ListHandle () const;

    /**
     * Sets the value of the member "u16ListHandle".
     *
     * The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @param u16ListHandle The value which will be set
     */
    inline void setU16ListHandle (uint16 u16ListHandle_);

    static const SearchKeyboardPhoneBookListStart &getDefaultInstance();

private:

    inline void set_has_u16ListHandle ();

    inline void clear_has_u16ListHandle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ListHandle;

};

/**
 * The result message of the method "SearchKeyboardPhoneBookList"
 * This function returns the search keyboard for a particular ListHandle. The
 * returned list identifies which letters of the Vertical Keyboard have at
 * least one Phone Book entry that starts with that letter. The index of the
 * first entry associated with the letter is also provided.If a
 * letter does not have an index then a Phone Book entry that starts with
 * that letter does not exist.Note that the returned search keyboard
 * list may no longer be valid if items in the underlying list have changed.
 * Thus, controllers shall re-request the search keyboard list upon a receipt
 * of MediaPlayerListChange for the ListHandle tied to the returned search
 * keyboard.
 */
class SearchKeyboardPhoneBookListResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SearchKeyboardPhoneBookListResult ();

    /**
     * Copy constructor
     */
    inline  SearchKeyboardPhoneBookListResult (const SearchKeyboardPhoneBookListResult &rhs);

    /**
     * All fields constructor
     */
    inline  SearchKeyboardPhoneBookListResult (uint16 u16ListHandle_, const ::most_PhonBk_fi_types::T_PhonBkSearchKeyboardList& oSearchKeyboardList_);

    /**
     * Destructor
     */
    inline virtual  ~SearchKeyboardPhoneBookListResult();

    /**
     * Assignment operator
     */
    inline SearchKeyboardPhoneBookListResult& operator = (const SearchKeyboardPhoneBookListResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SearchKeyboardPhoneBookListResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SearchKeyboardPhoneBookListResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SearchKeyboardPhoneBookListResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SearchKeyboardPhoneBookListResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ListHandle"

    static const int kU16ListHandle = 0;

    /**
     * Clears the field "u16ListHandle".
     *
     * The field will be set to its default value. The hasU16ListHandle()
     * method will return false.
     */
    inline void clearU16ListHandle();

    /**
     * Checks whether the field "u16ListHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ListHandle()). Otherwise it will return false.
     */
    inline bool hasU16ListHandle () const;

    /**
     * Returns the value of the member "u16ListHandle".
     *
     * The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @return The value of the field "u16ListHandle"
     */
    inline uint16 getU16ListHandle () const;

    /**
     * Sets the value of the member "u16ListHandle".
     *
     * The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @param u16ListHandle The value which will be set
     */
    inline void setU16ListHandle (uint16 u16ListHandle_);

    // API of field "oSearchKeyboardList"

    static const int kOSearchKeyboardList = 1;

    /**
     * Clears the field "oSearchKeyboardList".
     *
     * The field will be set to its default value. The hasOSearchKeyboardList()
     * method will return false.
     */
    inline void clearOSearchKeyboardList();

    /**
     * Checks whether the field "oSearchKeyboardList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOSearchKeyboardList()). Otherwise it will return false.
     */
    inline bool hasOSearchKeyboardList () const;

    /**
     * Returns the value of the member "oSearchKeyboardList".
     *
     * Provides a list of each letter of the alphabet and the start index within the phone book
     *
     * @return The value of the field "oSearchKeyboardList"
     */
    inline const ::most_PhonBk_fi_types::T_PhonBkSearchKeyboardList& getOSearchKeyboardList () const;

    /**
     * Retrieves the value of the field "oSearchKeyboardList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oSearchKeyboardList".
     */
    inline ::most_PhonBk_fi_types::T_PhonBkSearchKeyboardList& getOSearchKeyboardListMutable ();

    /**
     * Sets the value of the member "oSearchKeyboardList".
     *
     * Provides a list of each letter of the alphabet and the start index within the phone book
     *
     * @param oSearchKeyboardList The value which will be set
     */
    inline void setOSearchKeyboardList (const ::most_PhonBk_fi_types::T_PhonBkSearchKeyboardList& oSearchKeyboardList_);

    static const SearchKeyboardPhoneBookListResult &getDefaultInstance();

private:

    static const ::std::vector< ::most_PhonBk_fi_types::T_PhonBkSearchKeyboardListItem >& getT_PhonBkSearchKeyboardListItemList_DefaultInstance ();

    inline void set_has_u16ListHandle ();

    inline void clear_has_u16ListHandle ();

    inline void set_has_oSearchKeyboardList ();

    inline void clear_has_oSearchKeyboardList ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _u16ListHandle;

    ::most_PhonBk_fi_types::T_PhonBkSearchKeyboardList _oSearchKeyboardList;

};

/**
 * The error message of 'SearchKeyboardPhoneBookList'
 */
class SearchKeyboardPhoneBookListErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SearchKeyboardPhoneBookListErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SearchKeyboardPhoneBookListErrorStructure (const SearchKeyboardPhoneBookListErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SearchKeyboardPhoneBookListErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~SearchKeyboardPhoneBookListErrorStructure();

    /**
     * Assignment operator
     */
    inline SearchKeyboardPhoneBookListErrorStructure& operator = (const SearchKeyboardPhoneBookListErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SearchKeyboardPhoneBookListErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SearchKeyboardPhoneBookListErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SearchKeyboardPhoneBookListErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SearchKeyboardPhoneBookListErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     *
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     *
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     *
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     *
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const SearchKeyboardPhoneBookListErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'SearchKeyboardPhoneBookList'
 */
class SearchKeyboardPhoneBookListError  : public ::asf::core::Payload {
public:

    enum SearchKeyboardPhoneBookListErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SearchKeyboardPhoneBookListError ();

   /**
     * Copy constructor
     */
    inline  SearchKeyboardPhoneBookListError (const SearchKeyboardPhoneBookListError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SearchKeyboardPhoneBookListError();

    /**
     * Assigns a new value to this object.
     */
    inline SearchKeyboardPhoneBookListError& operator = (const SearchKeyboardPhoneBookListError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SearchKeyboardPhoneBookListError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SearchKeyboardPhoneBookListError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SearchKeyboardPhoneBookListError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SearchKeyboardPhoneBookListError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SearchKeyboardPhoneBookListError::SearchKeyboardPhoneBookListErrorField getField () const;

    inline void setField(SearchKeyboardPhoneBookListError::SearchKeyboardPhoneBookListErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SearchKeyboardPhoneBookListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SearchKeyboardPhoneBookListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SearchKeyboardPhoneBookListErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SearchKeyboardPhoneBookListErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SearchKeyboardPhoneBookListErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SearchKeyboardPhoneBookListErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SearchKeyboardPhoneBookListErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SearchKeyboardPhoneBookListErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SearchKeyboardPhoneBookListError &getDefaultInstance();

private:

    inline void cloneData (const SearchKeyboardPhoneBookListError& rhs);

    inline void deleteData ();

    SearchKeyboardPhoneBookListErrorField __field;

    union {
        SearchKeyboardPhoneBookListErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "ReleasePhoneBookList"
 * The ReleasePhoneBookList function releases a list which has been created by the CreatePhoneBookList function.  The list to release is specified by the ListHandle parameter. The ListHandle becomes invalid by this function.
 */
class ReleasePhoneBookListStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReleasePhoneBookListStart ();

    /**
     * Copy constructor
     */
    inline  ReleasePhoneBookListStart (const ReleasePhoneBookListStart &rhs);

    /**
     * All fields constructor
     */
    inline  ReleasePhoneBookListStart (uint16 u16ListHandle_);

    /**
     * Destructor
     */
    inline virtual  ~ReleasePhoneBookListStart();

    /**
     * Assignment operator
     */
    inline ReleasePhoneBookListStart& operator = (const ReleasePhoneBookListStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReleasePhoneBookListStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReleasePhoneBookListStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReleasePhoneBookListStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReleasePhoneBookListStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ListHandle"

    static const int kU16ListHandle = 0;

    /**
     * Clears the field "u16ListHandle".
     *
     * The field will be set to its default value. The hasU16ListHandle()
     * method will return false.
     */
    inline void clearU16ListHandle();

    /**
     * Checks whether the field "u16ListHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ListHandle()). Otherwise it will return false.
     */
    inline bool hasU16ListHandle () const;

    /**
     * Returns the value of the member "u16ListHandle".
     *
     * The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @return The value of the field "u16ListHandle"
     */
    inline uint16 getU16ListHandle () const;

    /**
     * Sets the value of the member "u16ListHandle".
     *
     * The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @param u16ListHandle The value which will be set
     */
    inline void setU16ListHandle (uint16 u16ListHandle_);

    static const ReleasePhoneBookListStart &getDefaultInstance();

private:

    inline void set_has_u16ListHandle ();

    inline void clear_has_u16ListHandle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ListHandle;

};

/**
 * The result message of the method "ReleasePhoneBookList"
 * The ReleasePhoneBookList function releases a list which has been created by the CreatePhoneBookList function.  The list to release is specified by the ListHandle parameter. The ListHandle becomes invalid by this function.
 */
class ReleasePhoneBookListResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReleasePhoneBookListResult ();

    /**
     * Copy constructor
     */
    inline  ReleasePhoneBookListResult (const ReleasePhoneBookListResult &rhs);

    /**
     * All fields constructor
     */
    inline  ReleasePhoneBookListResult (uint16 u16ListHandle_);

    /**
     * Destructor
     */
    inline virtual  ~ReleasePhoneBookListResult();

    /**
     * Assignment operator
     */
    inline ReleasePhoneBookListResult& operator = (const ReleasePhoneBookListResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReleasePhoneBookListResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReleasePhoneBookListResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReleasePhoneBookListResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReleasePhoneBookListResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ListHandle"

    static const int kU16ListHandle = 0;

    /**
     * Clears the field "u16ListHandle".
     *
     * The field will be set to its default value. The hasU16ListHandle()
     * method will return false.
     */
    inline void clearU16ListHandle();

    /**
     * Checks whether the field "u16ListHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ListHandle()). Otherwise it will return false.
     */
    inline bool hasU16ListHandle () const;

    /**
     * Returns the value of the member "u16ListHandle".
     *
     * The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @return The value of the field "u16ListHandle"
     */
    inline uint16 getU16ListHandle () const;

    /**
     * Sets the value of the member "u16ListHandle".
     *
     * The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @param u16ListHandle The value which will be set
     */
    inline void setU16ListHandle (uint16 u16ListHandle_);

    static const ReleasePhoneBookListResult &getDefaultInstance();

private:

    inline void set_has_u16ListHandle ();

    inline void clear_has_u16ListHandle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ListHandle;

};

/**
 * The error message of 'ReleasePhoneBookList'
 */
class ReleasePhoneBookListErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  ReleasePhoneBookListErrorStructure ();

    /**
     * Copy constructor
     */
    inline  ReleasePhoneBookListErrorStructure (const ReleasePhoneBookListErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  ReleasePhoneBookListErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~ReleasePhoneBookListErrorStructure();

    /**
     * Assignment operator
     */
    inline ReleasePhoneBookListErrorStructure& operator = (const ReleasePhoneBookListErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReleasePhoneBookListErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReleasePhoneBookListErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReleasePhoneBookListErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReleasePhoneBookListErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     *
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     *
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     *
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     *
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const ReleasePhoneBookListErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'ReleasePhoneBookList'
 */
class ReleasePhoneBookListError  : public ::asf::core::Payload {
public:

    enum ReleasePhoneBookListErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  ReleasePhoneBookListError ();

   /**
     * Copy constructor
     */
    inline  ReleasePhoneBookListError (const ReleasePhoneBookListError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~ReleasePhoneBookListError();

    /**
     * Assigns a new value to this object.
     */
    inline ReleasePhoneBookListError& operator = (const ReleasePhoneBookListError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReleasePhoneBookListError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReleasePhoneBookListError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReleasePhoneBookListError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReleasePhoneBookListError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline ReleasePhoneBookListError::ReleasePhoneBookListErrorField getField () const;

    inline void setField(ReleasePhoneBookListError::ReleasePhoneBookListErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "ReleasePhoneBookListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "ReleasePhoneBookListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ReleasePhoneBookListErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ReleasePhoneBookListErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline ReleasePhoneBookListErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (ReleasePhoneBookListErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "ReleasePhoneBookListErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const ReleasePhoneBookListErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const ReleasePhoneBookListError &getDefaultInstance();

private:

    inline void cloneData (const ReleasePhoneBookListError& rhs);

    inline void deleteData ();

    ReleasePhoneBookListErrorField __field;

    union {
        ReleasePhoneBookListErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "GetContactDetails"
 * Retrieves the detailed information for a particular contact based on filter type selected and identified by the supplied ContactHandle.
 */
class GetContactDetailsStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetContactDetailsStart ();

    /**
     * Copy constructor
     */
    inline  GetContactDetailsStart (const GetContactDetailsStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetContactDetailsStart (uint32 u32ContactHandle_, ::most_PhonBk_fi_types::T_e8_PhonBkContactDetailFilter e8ContactDetailFilter_);

    /**
     * Destructor
     */
    inline virtual  ~GetContactDetailsStart();

    /**
     * Assignment operator
     */
    inline GetContactDetailsStart& operator = (const GetContactDetailsStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetContactDetailsStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetContactDetailsStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetContactDetailsStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetContactDetailsStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32ContactHandle"

    static const int kU32ContactHandle = 0;

    /**
     * Clears the field "u32ContactHandle".
     *
     * The field will be set to its default value. The hasU32ContactHandle()
     * method will return false.
     */
    inline void clearU32ContactHandle();

    /**
     * Checks whether the field "u32ContactHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ContactHandle()). Otherwise it will return false.
     */
    inline bool hasU32ContactHandle () const;

    /**
     * Returns the value of the member "u32ContactHandle".
     *
     * This is the globally unique ID for a particular contact. The ID is unique across all currently connected devices.
     *
     * @return The value of the field "u32ContactHandle"
     */
    inline uint32 getU32ContactHandle () const;

    /**
     * Sets the value of the member "u32ContactHandle".
     *
     * This is the globally unique ID for a particular contact. The ID is unique across all currently connected devices.
     *
     * @param u32ContactHandle The value which will be set
     */
    inline void setU32ContactHandle (uint32 u32ContactHandle_);

    // API of field "e8ContactDetailFilter"

    static const int kE8ContactDetailFilter = 1;

    /**
     * Clears the field "e8ContactDetailFilter".
     *
     * The field will be set to its default value. The hasE8ContactDetailFilter()
     * method will return false.
     */
    inline void clearE8ContactDetailFilter();

    /**
     * Checks whether the field "e8ContactDetailFilter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ContactDetailFilter()). Otherwise it will return false.
     */
    inline bool hasE8ContactDetailFilter () const;

    /**
     * Returns the value of the member "e8ContactDetailFilter".
     *
     * Defines the filter types which can be applied when requesting contact details.  When a filter is applied only the types specified by the filter shall have data.
     *
     * @return The value of the field "e8ContactDetailFilter"
     */
    inline ::most_PhonBk_fi_types::T_e8_PhonBkContactDetailFilter getE8ContactDetailFilter () const;

    /**
     * Sets the value of the member "e8ContactDetailFilter".
     *
     * Defines the filter types which can be applied when requesting contact details.  When a filter is applied only the types specified by the filter shall have data.
     *
     * @param e8ContactDetailFilter The value which will be set
     */
    inline void setE8ContactDetailFilter (::most_PhonBk_fi_types::T_e8_PhonBkContactDetailFilter e8ContactDetailFilter_);

    static const GetContactDetailsStart &getDefaultInstance();

private:

    inline void set_has_u32ContactHandle ();

    inline void clear_has_u32ContactHandle ();

    inline void set_has_e8ContactDetailFilter ();

    inline void clear_has_e8ContactDetailFilter ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _u32ContactHandle;

    ::most_PhonBk_fi_types::T_e8_PhonBkContactDetailFilter _e8ContactDetailFilter;

};

/**
 * The result message of the method "GetContactDetails"
 * Retrieves the detailed information for a particular contact based on filter type selected and identified by the supplied ContactHandle.
 */
class GetContactDetailsResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetContactDetailsResult ();

    /**
     * Copy constructor
     */
    inline  GetContactDetailsResult (const GetContactDetailsResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetContactDetailsResult (const ::most_PhonBk_fi_types::T_PhonBkContactDetails& oContactDetails_);

    /**
     * Destructor
     */
    inline virtual  ~GetContactDetailsResult();

    /**
     * Assignment operator
     */
    inline GetContactDetailsResult& operator = (const GetContactDetailsResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetContactDetailsResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetContactDetailsResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetContactDetailsResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetContactDetailsResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oContactDetails"

    static const int kOContactDetails = 0;

    /**
     * Clears the field "oContactDetails".
     *
     * The field will be set to its default value. The hasOContactDetails()
     * method will return false.
     */
    inline void clearOContactDetails();

    /**
     * Checks whether the field "oContactDetails" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOContactDetails()). Otherwise it will return false.
     */
    inline bool hasOContactDetails () const;

    /**
     * Returns the value of the member "oContactDetails".
     *
     * If a type is empty then the type shall not be displayed
     *
     * @return The value of the field "oContactDetails"
     */
    inline const ::most_PhonBk_fi_types::T_PhonBkContactDetails& getOContactDetails () const;

    /**
     * Retrieves the value of the field "oContactDetails" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oContactDetails".
     */
    inline ::most_PhonBk_fi_types::T_PhonBkContactDetails& getOContactDetailsMutable ();

    /**
     * Sets the value of the member "oContactDetails".
     *
     * If a type is empty then the type shall not be displayed
     *
     * @param oContactDetails The value which will be set
     */
    inline void setOContactDetails (const ::most_PhonBk_fi_types::T_PhonBkContactDetails& oContactDetails_);

    static const GetContactDetailsResult &getDefaultInstance();

private:

    inline void set_has_oContactDetails ();

    inline void clear_has_oContactDetails ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_PhonBk_fi_types::T_PhonBkContactDetails _oContactDetails;

};

/**
 * The error message of 'GetContactDetails'
 */
class GetContactDetailsErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetContactDetailsErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetContactDetailsErrorStructure (const GetContactDetailsErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetContactDetailsErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~GetContactDetailsErrorStructure();

    /**
     * Assignment operator
     */
    inline GetContactDetailsErrorStructure& operator = (const GetContactDetailsErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetContactDetailsErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetContactDetailsErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetContactDetailsErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetContactDetailsErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     *
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     *
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     *
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     *
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const GetContactDetailsErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'GetContactDetails'
 */
class GetContactDetailsError  : public ::asf::core::Payload {
public:

    enum GetContactDetailsErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetContactDetailsError ();

   /**
     * Copy constructor
     */
    inline  GetContactDetailsError (const GetContactDetailsError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetContactDetailsError();

    /**
     * Assigns a new value to this object.
     */
    inline GetContactDetailsError& operator = (const GetContactDetailsError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetContactDetailsError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetContactDetailsError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetContactDetailsError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetContactDetailsError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetContactDetailsError::GetContactDetailsErrorField getField () const;

    inline void setField(GetContactDetailsError::GetContactDetailsErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetContactDetailsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetContactDetailsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetContactDetailsErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetContactDetailsErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetContactDetailsErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetContactDetailsErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetContactDetailsErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetContactDetailsErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetContactDetailsError &getDefaultInstance();

private:

    inline void cloneData (const GetContactDetailsError& rhs);

    inline void deleteData ();

    GetContactDetailsErrorField __field;

    union {
        GetContactDetailsErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "GetContactPhoto"
 * Acquires the photo associated with a contact. This function returns the
 * image encoded as it has been received by the phone device, typically
 * this will be JPEG or GIF or PNG.
 * HMI controllers should call this method without prior calling the method GetContactPhotoInfo.
 * The method GetContactPhotoInfo has become deprecated.
 */
class GetContactPhotoStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetContactPhotoStart ();

    /**
     * Copy constructor
     */
    inline  GetContactPhotoStart (const GetContactPhotoStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetContactPhotoStart (uint32 u32ContactHandle_);

    /**
     * Destructor
     */
    inline virtual  ~GetContactPhotoStart();

    /**
     * Assignment operator
     */
    inline GetContactPhotoStart& operator = (const GetContactPhotoStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetContactPhotoStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetContactPhotoStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetContactPhotoStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetContactPhotoStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32ContactHandle"

    static const int kU32ContactHandle = 0;

    /**
     * Clears the field "u32ContactHandle".
     *
     * The field will be set to its default value. The hasU32ContactHandle()
     * method will return false.
     */
    inline void clearU32ContactHandle();

    /**
     * Checks whether the field "u32ContactHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ContactHandle()). Otherwise it will return false.
     */
    inline bool hasU32ContactHandle () const;

    /**
     * Returns the value of the member "u32ContactHandle".
     *
     * This is the globally unique ID for a particular contact. The ID is unique across all currently connected devices.
     *
     * @return The value of the field "u32ContactHandle"
     */
    inline uint32 getU32ContactHandle () const;

    /**
     * Sets the value of the member "u32ContactHandle".
     *
     * This is the globally unique ID for a particular contact. The ID is unique across all currently connected devices.
     *
     * @param u32ContactHandle The value which will be set
     */
    inline void setU32ContactHandle (uint32 u32ContactHandle_);

    static const GetContactPhotoStart &getDefaultInstance();

private:

    inline void set_has_u32ContactHandle ();

    inline void clear_has_u32ContactHandle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _u32ContactHandle;

};

/**
 * The result message of the method "GetContactPhoto"
 * Acquires the photo associated with a contact. This function returns the
 * image encoded as it has been received by the phone device, typically
 * this will be JPEG or GIF or PNG.
 * HMI controllers should call this method without prior calling the method GetContactPhotoInfo.
 * The method GetContactPhotoInfo has become deprecated.
 */
class GetContactPhotoResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetContactPhotoResult ();

    /**
     * Copy constructor
     */
    inline  GetContactPhotoResult (const GetContactPhotoResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetContactPhotoResult (uint32 u32ContactHandle_, const ::most_PhonBk_fi_types::T_PhonBkContactPhoto& oContactPhoto_);

    /**
     * Destructor
     */
    inline virtual  ~GetContactPhotoResult();

    /**
     * Assignment operator
     */
    inline GetContactPhotoResult& operator = (const GetContactPhotoResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetContactPhotoResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetContactPhotoResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetContactPhotoResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetContactPhotoResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32ContactHandle"

    static const int kU32ContactHandle = 0;

    /**
     * Clears the field "u32ContactHandle".
     *
     * The field will be set to its default value. The hasU32ContactHandle()
     * method will return false.
     */
    inline void clearU32ContactHandle();

    /**
     * Checks whether the field "u32ContactHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ContactHandle()). Otherwise it will return false.
     */
    inline bool hasU32ContactHandle () const;

    /**
     * Returns the value of the member "u32ContactHandle".
     *
     * This is the globally unique ID for a particular contact. The ID is unique across all currently connected devices.
     *
     * @return The value of the field "u32ContactHandle"
     */
    inline uint32 getU32ContactHandle () const;

    /**
     * Sets the value of the member "u32ContactHandle".
     *
     * This is the globally unique ID for a particular contact. The ID is unique across all currently connected devices.
     *
     * @param u32ContactHandle The value which will be set
     */
    inline void setU32ContactHandle (uint32 u32ContactHandle_);

    // API of field "oContactPhoto"

    static const int kOContactPhoto = 1;

    /**
     * Clears the field "oContactPhoto".
     *
     * The field will be set to its default value. The hasOContactPhoto()
     * method will return false.
     */
    inline void clearOContactPhoto();

    /**
     * Checks whether the field "oContactPhoto" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOContactPhoto()). Otherwise it will return false.
     */
    inline bool hasOContactPhoto () const;

    /**
     * Returns the value of the member "oContactPhoto".
     *
     *
     *
     * @return The value of the field "oContactPhoto"
     */
    inline const ::most_PhonBk_fi_types::T_PhonBkContactPhoto& getOContactPhoto () const;

    /**
     * Retrieves the value of the field "oContactPhoto" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oContactPhoto".
     */
    inline ::most_PhonBk_fi_types::T_PhonBkContactPhoto& getOContactPhotoMutable ();

    /**
     * Sets the value of the member "oContactPhoto".
     *
     *
     *
     * @param oContactPhoto The value which will be set
     */
    inline void setOContactPhoto (const ::most_PhonBk_fi_types::T_PhonBkContactPhoto& oContactPhoto_);

    static const GetContactPhotoResult &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_u32ContactHandle ();

    inline void clear_has_u32ContactHandle ();

    inline void set_has_oContactPhoto ();

    inline void clear_has_oContactPhoto ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _u32ContactHandle;

    ::most_PhonBk_fi_types::T_PhonBkContactPhoto _oContactPhoto;

};

/**
 * The error message of 'GetContactPhoto'
 */
class GetContactPhotoErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetContactPhotoErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetContactPhotoErrorStructure (const GetContactPhotoErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetContactPhotoErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~GetContactPhotoErrorStructure();

    /**
     * Assignment operator
     */
    inline GetContactPhotoErrorStructure& operator = (const GetContactPhotoErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetContactPhotoErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetContactPhotoErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetContactPhotoErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetContactPhotoErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     *
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     *
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     *
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     *
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const GetContactPhotoErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'GetContactPhoto'
 */
class GetContactPhotoError  : public ::asf::core::Payload {
public:

    enum GetContactPhotoErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetContactPhotoError ();

   /**
     * Copy constructor
     */
    inline  GetContactPhotoError (const GetContactPhotoError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetContactPhotoError();

    /**
     * Assigns a new value to this object.
     */
    inline GetContactPhotoError& operator = (const GetContactPhotoError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetContactPhotoError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetContactPhotoError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetContactPhotoError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetContactPhotoError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetContactPhotoError::GetContactPhotoErrorField getField () const;

    inline void setField(GetContactPhotoError::GetContactPhotoErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetContactPhotoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetContactPhotoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetContactPhotoErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetContactPhotoErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetContactPhotoErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetContactPhotoErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetContactPhotoErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetContactPhotoErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetContactPhotoError &getDefaultInstance();

private:

    inline void cloneData (const GetContactPhotoError& rhs);

    inline void deleteData ();

    GetContactPhotoErrorField __field;

    union {
        GetContactPhotoErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "AddContact"
 * Adds new contact to the appropriate source phone book (i.e. Vehicle Contact List)
 */
class AddContactStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AddContactStart ();

    /**
     * Copy constructor
     */
    inline  AddContactStart (const AddContactStart &rhs);

    /**
     * All fields constructor
     */
    inline  AddContactStart (uint8 u8DeviceHandle_, const ::most_PhonBk_fi_types::T_PhonBkContactDetails& oContactDetails_);

    /**
     * Destructor
     */
    inline virtual  ~AddContactStart();

    /**
     * Assignment operator
     */
    inline AddContactStart& operator = (const AddContactStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddContactStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddContactStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddContactStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddContactStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Handle of the device for the phone book source. The vehicle phone book has a DeviceHandle = 1.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Handle of the device for the phone book source. The vehicle phone book has a DeviceHandle = 1.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "oContactDetails"

    static const int kOContactDetails = 1;

    /**
     * Clears the field "oContactDetails".
     *
     * The field will be set to its default value. The hasOContactDetails()
     * method will return false.
     */
    inline void clearOContactDetails();

    /**
     * Checks whether the field "oContactDetails" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOContactDetails()). Otherwise it will return false.
     */
    inline bool hasOContactDetails () const;

    /**
     * Returns the value of the member "oContactDetails".
     *
     * If a type is empty then the type shall not be displayed
     *
     * @return The value of the field "oContactDetails"
     */
    inline const ::most_PhonBk_fi_types::T_PhonBkContactDetails& getOContactDetails () const;

    /**
     * Retrieves the value of the field "oContactDetails" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oContactDetails".
     */
    inline ::most_PhonBk_fi_types::T_PhonBkContactDetails& getOContactDetailsMutable ();

    /**
     * Sets the value of the member "oContactDetails".
     *
     * If a type is empty then the type shall not be displayed
     *
     * @param oContactDetails The value which will be set
     */
    inline void setOContactDetails (const ::most_PhonBk_fi_types::T_PhonBkContactDetails& oContactDetails_);

    static const AddContactStart &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_oContactDetails ();

    inline void clear_has_oContactDetails ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8DeviceHandle;

    ::most_PhonBk_fi_types::T_PhonBkContactDetails _oContactDetails;

};

/**
 * The result message of the method "AddContact"
 * Adds new contact to the appropriate source phone book (i.e. Vehicle Contact List)
 */
class AddContactResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AddContactResult ();

    /**
     * Copy constructor
     */
    inline  AddContactResult (const AddContactResult &rhs);

    /**
     * All fields constructor
     */
    inline  AddContactResult (uint32 u32ContactHandle_, ::most_PhonBk_fi_types::T_e8_PhonBkContactAddStatus e8ContactAddStatus_);

    /**
     * Destructor
     */
    inline virtual  ~AddContactResult();

    /**
     * Assignment operator
     */
    inline AddContactResult& operator = (const AddContactResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddContactResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddContactResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddContactResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddContactResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32ContactHandle"

    static const int kU32ContactHandle = 0;

    /**
     * Clears the field "u32ContactHandle".
     *
     * The field will be set to its default value. The hasU32ContactHandle()
     * method will return false.
     */
    inline void clearU32ContactHandle();

    /**
     * Checks whether the field "u32ContactHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ContactHandle()). Otherwise it will return false.
     */
    inline bool hasU32ContactHandle () const;

    /**
     * Returns the value of the member "u32ContactHandle".
     *
     * This is the globally unique ID for a particular contact. The ID is unique across all currently connected devices.
     *
     * @return The value of the field "u32ContactHandle"
     */
    inline uint32 getU32ContactHandle () const;

    /**
     * Sets the value of the member "u32ContactHandle".
     *
     * This is the globally unique ID for a particular contact. The ID is unique across all currently connected devices.
     *
     * @param u32ContactHandle The value which will be set
     */
    inline void setU32ContactHandle (uint32 u32ContactHandle_);

    // API of field "e8ContactAddStatus"

    static const int kE8ContactAddStatus = 1;

    /**
     * Clears the field "e8ContactAddStatus".
     *
     * The field will be set to its default value. The hasE8ContactAddStatus()
     * method will return false.
     */
    inline void clearE8ContactAddStatus();

    /**
     * Checks whether the field "e8ContactAddStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ContactAddStatus()). Otherwise it will return false.
     */
    inline bool hasE8ContactAddStatus () const;

    /**
     * Returns the value of the member "e8ContactAddStatus".
     *
     *
     *
     * @return The value of the field "e8ContactAddStatus"
     */
    inline ::most_PhonBk_fi_types::T_e8_PhonBkContactAddStatus getE8ContactAddStatus () const;

    /**
     * Sets the value of the member "e8ContactAddStatus".
     *
     *
     *
     * @param e8ContactAddStatus The value which will be set
     */
    inline void setE8ContactAddStatus (::most_PhonBk_fi_types::T_e8_PhonBkContactAddStatus e8ContactAddStatus_);

    static const AddContactResult &getDefaultInstance();

private:

    inline void set_has_u32ContactHandle ();

    inline void clear_has_u32ContactHandle ();

    inline void set_has_e8ContactAddStatus ();

    inline void clear_has_e8ContactAddStatus ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _u32ContactHandle;

    ::most_PhonBk_fi_types::T_e8_PhonBkContactAddStatus _e8ContactAddStatus;

};

/**
 * The error message of 'AddContact'
 */
class AddContactErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  AddContactErrorStructure ();

    /**
     * Copy constructor
     */
    inline  AddContactErrorStructure (const AddContactErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  AddContactErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~AddContactErrorStructure();

    /**
     * Assignment operator
     */
    inline AddContactErrorStructure& operator = (const AddContactErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddContactErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddContactErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddContactErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddContactErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     *
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     *
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     *
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     *
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const AddContactErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'AddContact'
 */
class AddContactError  : public ::asf::core::Payload {
public:

    enum AddContactErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  AddContactError ();

   /**
     * Copy constructor
     */
    inline  AddContactError (const AddContactError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~AddContactError();

    /**
     * Assigns a new value to this object.
     */
    inline AddContactError& operator = (const AddContactError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddContactError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddContactError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddContactError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddContactError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline AddContactError::AddContactErrorField getField () const;

    inline void setField(AddContactError::AddContactErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "AddContactErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "AddContactErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const AddContactErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline AddContactErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline AddContactErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (AddContactErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "AddContactErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const AddContactErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const AddContactError &getDefaultInstance();

private:

    inline void cloneData (const AddContactError& rhs);

    inline void deleteData ();

    AddContactErrorField __field;

    union {
        AddContactErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "DeleteContact"
 * Deletes a contact based on its ContactHandle. The Result response includes the ContactDeleteStatus and the ContactHandle of the message requested for deletion.
 */
class DeleteContactStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeleteContactStart ();

    /**
     * Copy constructor
     */
    inline  DeleteContactStart (const DeleteContactStart &rhs);

    /**
     * All fields constructor
     */
    inline  DeleteContactStart (uint8 u8DeviceHandle_, uint32 u32ContactHandle_);

    /**
     * Destructor
     */
    inline virtual  ~DeleteContactStart();

    /**
     * Assignment operator
     */
    inline DeleteContactStart& operator = (const DeleteContactStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeleteContactStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeleteContactStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeleteContactStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeleteContactStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Handle of the device for the phone book source. The vehicle phone book has a DeviceHandle = 1.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Handle of the device for the phone book source. The vehicle phone book has a DeviceHandle = 1.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "u32ContactHandle"

    static const int kU32ContactHandle = 1;

    /**
     * Clears the field "u32ContactHandle".
     *
     * The field will be set to its default value. The hasU32ContactHandle()
     * method will return false.
     */
    inline void clearU32ContactHandle();

    /**
     * Checks whether the field "u32ContactHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ContactHandle()). Otherwise it will return false.
     */
    inline bool hasU32ContactHandle () const;

    /**
     * Returns the value of the member "u32ContactHandle".
     *
     * This is the globally unique ID for a particular contact. The ID is unique across all currently connected devices.
     *
     * @return The value of the field "u32ContactHandle"
     */
    inline uint32 getU32ContactHandle () const;

    /**
     * Sets the value of the member "u32ContactHandle".
     *
     * This is the globally unique ID for a particular contact. The ID is unique across all currently connected devices.
     *
     * @param u32ContactHandle The value which will be set
     */
    inline void setU32ContactHandle (uint32 u32ContactHandle_);

    static const DeleteContactStart &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_u32ContactHandle ();

    inline void clear_has_u32ContactHandle ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8DeviceHandle;

    uint32 _u32ContactHandle;

};

/**
 * The result message of the method "DeleteContact"
 * Deletes a contact based on its ContactHandle. The Result response includes the ContactDeleteStatus and the ContactHandle of the message requested for deletion.
 */
class DeleteContactResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeleteContactResult ();

    /**
     * Copy constructor
     */
    inline  DeleteContactResult (const DeleteContactResult &rhs);

    /**
     * All fields constructor
     */
    inline  DeleteContactResult (uint32 u32ContactHandle_, ::most_PhonBk_fi_types::T_e8_PhonBkContactDeleteStatus e8ContactDeleteStatus_);

    /**
     * Destructor
     */
    inline virtual  ~DeleteContactResult();

    /**
     * Assignment operator
     */
    inline DeleteContactResult& operator = (const DeleteContactResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeleteContactResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeleteContactResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeleteContactResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeleteContactResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32ContactHandle"

    static const int kU32ContactHandle = 0;

    /**
     * Clears the field "u32ContactHandle".
     *
     * The field will be set to its default value. The hasU32ContactHandle()
     * method will return false.
     */
    inline void clearU32ContactHandle();

    /**
     * Checks whether the field "u32ContactHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ContactHandle()). Otherwise it will return false.
     */
    inline bool hasU32ContactHandle () const;

    /**
     * Returns the value of the member "u32ContactHandle".
     *
     * This is the globally unique ID for a particular contact. The ID is unique across all currently connected devices.
     *
     * @return The value of the field "u32ContactHandle"
     */
    inline uint32 getU32ContactHandle () const;

    /**
     * Sets the value of the member "u32ContactHandle".
     *
     * This is the globally unique ID for a particular contact. The ID is unique across all currently connected devices.
     *
     * @param u32ContactHandle The value which will be set
     */
    inline void setU32ContactHandle (uint32 u32ContactHandle_);

    // API of field "e8ContactDeleteStatus"

    static const int kE8ContactDeleteStatus = 1;

    /**
     * Clears the field "e8ContactDeleteStatus".
     *
     * The field will be set to its default value. The hasE8ContactDeleteStatus()
     * method will return false.
     */
    inline void clearE8ContactDeleteStatus();

    /**
     * Checks whether the field "e8ContactDeleteStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ContactDeleteStatus()). Otherwise it will return false.
     */
    inline bool hasE8ContactDeleteStatus () const;

    /**
     * Returns the value of the member "e8ContactDeleteStatus".
     *
     * Contains the status in response to a DeleteContact call.
     *
     * @return The value of the field "e8ContactDeleteStatus"
     */
    inline ::most_PhonBk_fi_types::T_e8_PhonBkContactDeleteStatus getE8ContactDeleteStatus () const;

    /**
     * Sets the value of the member "e8ContactDeleteStatus".
     *
     * Contains the status in response to a DeleteContact call.
     *
     * @param e8ContactDeleteStatus The value which will be set
     */
    inline void setE8ContactDeleteStatus (::most_PhonBk_fi_types::T_e8_PhonBkContactDeleteStatus e8ContactDeleteStatus_);

    static const DeleteContactResult &getDefaultInstance();

private:

    inline void set_has_u32ContactHandle ();

    inline void clear_has_u32ContactHandle ();

    inline void set_has_e8ContactDeleteStatus ();

    inline void clear_has_e8ContactDeleteStatus ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _u32ContactHandle;

    ::most_PhonBk_fi_types::T_e8_PhonBkContactDeleteStatus _e8ContactDeleteStatus;

};

/**
 * The error message of 'DeleteContact'
 */
class DeleteContactErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DeleteContactErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DeleteContactErrorStructure (const DeleteContactErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DeleteContactErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~DeleteContactErrorStructure();

    /**
     * Assignment operator
     */
    inline DeleteContactErrorStructure& operator = (const DeleteContactErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeleteContactErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeleteContactErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeleteContactErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeleteContactErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     *
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     *
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     *
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     *
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const DeleteContactErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'DeleteContact'
 */
class DeleteContactError  : public ::asf::core::Payload {
public:

    enum DeleteContactErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DeleteContactError ();

   /**
     * Copy constructor
     */
    inline  DeleteContactError (const DeleteContactError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DeleteContactError();

    /**
     * Assigns a new value to this object.
     */
    inline DeleteContactError& operator = (const DeleteContactError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeleteContactError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeleteContactError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeleteContactError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeleteContactError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DeleteContactError::DeleteContactErrorField getField () const;

    inline void setField(DeleteContactError::DeleteContactErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DeleteContactErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DeleteContactErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DeleteContactErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DeleteContactErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DeleteContactErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DeleteContactErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DeleteContactErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DeleteContactErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DeleteContactError &getDefaultInstance();

private:

    inline void cloneData (const DeleteContactError& rhs);

    inline void deleteData ();

    DeleteContactErrorField __field;

    union {
        DeleteContactErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "EditContact"
 * Updates an existing contact with modifications and/or additions to the contact detail field(s) as entered by the user.
 *
 * The function is initiated upon the contact being saved.
 *
 * The Result response includes the ContactEditStatus and the ContactHandle of the contact requested for modification.
 */
class EditContactStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EditContactStart ();

    /**
     * Copy constructor
     */
    inline  EditContactStart (const EditContactStart &rhs);

    /**
     * All fields constructor
     */
    inline  EditContactStart (uint8 u8DeviceHandle_, uint32 u32ContactHandle_, const ::most_PhonBk_fi_types::T_PhonBkContactDetails& oContactDetails_);

    /**
     * Destructor
     */
    inline virtual  ~EditContactStart();

    /**
     * Assignment operator
     */
    inline EditContactStart& operator = (const EditContactStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EditContactStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EditContactStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EditContactStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EditContactStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Handle of the device for the phone book source. The vehicle phone book has a DeviceHandle = 1.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Handle of the device for the phone book source. The vehicle phone book has a DeviceHandle = 1.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "u32ContactHandle"

    static const int kU32ContactHandle = 1;

    /**
     * Clears the field "u32ContactHandle".
     *
     * The field will be set to its default value. The hasU32ContactHandle()
     * method will return false.
     */
    inline void clearU32ContactHandle();

    /**
     * Checks whether the field "u32ContactHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ContactHandle()). Otherwise it will return false.
     */
    inline bool hasU32ContactHandle () const;

    /**
     * Returns the value of the member "u32ContactHandle".
     *
     * This is the globally unique ID for a particular contact. The ID is unique across all currently connected devices.
     *
     * @return The value of the field "u32ContactHandle"
     */
    inline uint32 getU32ContactHandle () const;

    /**
     * Sets the value of the member "u32ContactHandle".
     *
     * This is the globally unique ID for a particular contact. The ID is unique across all currently connected devices.
     *
     * @param u32ContactHandle The value which will be set
     */
    inline void setU32ContactHandle (uint32 u32ContactHandle_);

    // API of field "oContactDetails"

    static const int kOContactDetails = 2;

    /**
     * Clears the field "oContactDetails".
     *
     * The field will be set to its default value. The hasOContactDetails()
     * method will return false.
     */
    inline void clearOContactDetails();

    /**
     * Checks whether the field "oContactDetails" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOContactDetails()). Otherwise it will return false.
     */
    inline bool hasOContactDetails () const;

    /**
     * Returns the value of the member "oContactDetails".
     *
     * If a type is empty then the type shall not be displayed
     *
     * @return The value of the field "oContactDetails"
     */
    inline const ::most_PhonBk_fi_types::T_PhonBkContactDetails& getOContactDetails () const;

    /**
     * Retrieves the value of the field "oContactDetails" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oContactDetails".
     */
    inline ::most_PhonBk_fi_types::T_PhonBkContactDetails& getOContactDetailsMutable ();

    /**
     * Sets the value of the member "oContactDetails".
     *
     * If a type is empty then the type shall not be displayed
     *
     * @param oContactDetails The value which will be set
     */
    inline void setOContactDetails (const ::most_PhonBk_fi_types::T_PhonBkContactDetails& oContactDetails_);

    static const EditContactStart &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_u32ContactHandle ();

    inline void clear_has_u32ContactHandle ();

    inline void set_has_oContactDetails ();

    inline void clear_has_oContactDetails ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _u8DeviceHandle;

    uint32 _u32ContactHandle;

    ::most_PhonBk_fi_types::T_PhonBkContactDetails _oContactDetails;

};

/**
 * The result message of the method "EditContact"
 * Updates an existing contact with modifications and/or additions to the contact detail field(s) as entered by the user.
 *
 * The function is initiated upon the contact being saved.
 *
 * The Result response includes the ContactEditStatus and the ContactHandle of the contact requested for modification.
 */
class EditContactResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EditContactResult ();

    /**
     * Copy constructor
     */
    inline  EditContactResult (const EditContactResult &rhs);

    /**
     * All fields constructor
     */
    inline  EditContactResult (uint32 u32ContactHandle_, ::most_PhonBk_fi_types::T_e8_PhonBkContactEditStatus e8ContactEditStatus_);

    /**
     * Destructor
     */
    inline virtual  ~EditContactResult();

    /**
     * Assignment operator
     */
    inline EditContactResult& operator = (const EditContactResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EditContactResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EditContactResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EditContactResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EditContactResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32ContactHandle"

    static const int kU32ContactHandle = 0;

    /**
     * Clears the field "u32ContactHandle".
     *
     * The field will be set to its default value. The hasU32ContactHandle()
     * method will return false.
     */
    inline void clearU32ContactHandle();

    /**
     * Checks whether the field "u32ContactHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ContactHandle()). Otherwise it will return false.
     */
    inline bool hasU32ContactHandle () const;

    /**
     * Returns the value of the member "u32ContactHandle".
     *
     * This is the globally unique ID for a particular contact. The ID is unique across all currently connected devices.
     *
     * @return The value of the field "u32ContactHandle"
     */
    inline uint32 getU32ContactHandle () const;

    /**
     * Sets the value of the member "u32ContactHandle".
     *
     * This is the globally unique ID for a particular contact. The ID is unique across all currently connected devices.
     *
     * @param u32ContactHandle The value which will be set
     */
    inline void setU32ContactHandle (uint32 u32ContactHandle_);

    // API of field "e8ContactEditStatus"

    static const int kE8ContactEditStatus = 1;

    /**
     * Clears the field "e8ContactEditStatus".
     *
     * The field will be set to its default value. The hasE8ContactEditStatus()
     * method will return false.
     */
    inline void clearE8ContactEditStatus();

    /**
     * Checks whether the field "e8ContactEditStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ContactEditStatus()). Otherwise it will return false.
     */
    inline bool hasE8ContactEditStatus () const;

    /**
     * Returns the value of the member "e8ContactEditStatus".
     *
     * Contains the status in response to a EditContact call.
     *
     * @return The value of the field "e8ContactEditStatus"
     */
    inline ::most_PhonBk_fi_types::T_e8_PhonBkContactEditStatus getE8ContactEditStatus () const;

    /**
     * Sets the value of the member "e8ContactEditStatus".
     *
     * Contains the status in response to a EditContact call.
     *
     * @param e8ContactEditStatus The value which will be set
     */
    inline void setE8ContactEditStatus (::most_PhonBk_fi_types::T_e8_PhonBkContactEditStatus e8ContactEditStatus_);

    static const EditContactResult &getDefaultInstance();

private:

    inline void set_has_u32ContactHandle ();

    inline void clear_has_u32ContactHandle ();

    inline void set_has_e8ContactEditStatus ();

    inline void clear_has_e8ContactEditStatus ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _u32ContactHandle;

    ::most_PhonBk_fi_types::T_e8_PhonBkContactEditStatus _e8ContactEditStatus;

};

/**
 * The error message of 'EditContact'
 */
class EditContactErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  EditContactErrorStructure ();

    /**
     * Copy constructor
     */
    inline  EditContactErrorStructure (const EditContactErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  EditContactErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~EditContactErrorStructure();

    /**
     * Assignment operator
     */
    inline EditContactErrorStructure& operator = (const EditContactErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EditContactErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EditContactErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EditContactErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EditContactErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     *
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     *
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     *
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     *
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const EditContactErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'EditContact'
 */
class EditContactError  : public ::asf::core::Payload {
public:

    enum EditContactErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  EditContactError ();

   /**
     * Copy constructor
     */
    inline  EditContactError (const EditContactError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~EditContactError();

    /**
     * Assigns a new value to this object.
     */
    inline EditContactError& operator = (const EditContactError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EditContactError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EditContactError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EditContactError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EditContactError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline EditContactError::EditContactErrorField getField () const;

    inline void setField(EditContactError::EditContactErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "EditContactErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "EditContactErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const EditContactErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline EditContactErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline EditContactErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (EditContactErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "EditContactErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const EditContactErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const EditContactError &getDefaultInstance();

private:

    inline void cloneData (const EditContactError& rhs);

    inline void deleteData ();

    EditContactErrorField __field;

    union {
        EditContactErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "CreateCallHistoryList"
 * Creates a Call History list of a particular type and returns a ListHandle to the caller.  Slices of the list can then be accessed via RequestCallHistoryListSlice.
 */
class CreateCallHistoryListStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CreateCallHistoryListStart ();

    /**
     * Copy constructor
     */
    inline  CreateCallHistoryListStart (const CreateCallHistoryListStart &rhs);

    /**
     * All fields constructor
     */
    inline  CreateCallHistoryListStart (uint8 u8DeviceHandle_, ::most_PhonBk_fi_types::T_e8_PhonBkCallHistoryType e8CallHistoryType_, ::most_PhonBk_fi_types::T_e8_PhonBkCallHistorySortType e8CallHistorySortType_);

    /**
     * Destructor
     */
    inline virtual  ~CreateCallHistoryListStart();

    /**
     * Assignment operator
     */
    inline CreateCallHistoryListStart& operator = (const CreateCallHistoryListStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreateCallHistoryListStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreateCallHistoryListStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreateCallHistoryListStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreateCallHistoryListStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Handle of the device for the phone book source. The vehicle phone book has a DeviceHandle = 1.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Handle of the device for the phone book source. The vehicle phone book has a DeviceHandle = 1.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "e8CallHistoryType"

    static const int kE8CallHistoryType = 1;

    /**
     * Clears the field "e8CallHistoryType".
     *
     * The field will be set to its default value. The hasE8CallHistoryType()
     * method will return false.
     */
    inline void clearE8CallHistoryType();

    /**
     * Checks whether the field "e8CallHistoryType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8CallHistoryType()). Otherwise it will return false.
     */
    inline bool hasE8CallHistoryType () const;

    /**
     * Returns the value of the member "e8CallHistoryType".
     *
     * Type of recent call or call history list.
     *
     * @return The value of the field "e8CallHistoryType"
     */
    inline ::most_PhonBk_fi_types::T_e8_PhonBkCallHistoryType getE8CallHistoryType () const;

    /**
     * Sets the value of the member "e8CallHistoryType".
     *
     * Type of recent call or call history list.
     *
     * @param e8CallHistoryType The value which will be set
     */
    inline void setE8CallHistoryType (::most_PhonBk_fi_types::T_e8_PhonBkCallHistoryType e8CallHistoryType_);

    // API of field "e8CallHistorySortType"

    static const int kE8CallHistorySortType = 2;

    /**
     * Clears the field "e8CallHistorySortType".
     *
     * The field will be set to its default value. The hasE8CallHistorySortType()
     * method will return false.
     */
    inline void clearE8CallHistorySortType();

    /**
     * Checks whether the field "e8CallHistorySortType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8CallHistorySortType()). Otherwise it will return false.
     */
    inline bool hasE8CallHistorySortType () const;

    /**
     * Returns the value of the member "e8CallHistorySortType".
     *
     * Passed in CreateCallHistoryList to set the sort order of a created list.
     *
     * @return The value of the field "e8CallHistorySortType"
     */
    inline ::most_PhonBk_fi_types::T_e8_PhonBkCallHistorySortType getE8CallHistorySortType () const;

    /**
     * Sets the value of the member "e8CallHistorySortType".
     *
     * Passed in CreateCallHistoryList to set the sort order of a created list.
     *
     * @param e8CallHistorySortType The value which will be set
     */
    inline void setE8CallHistorySortType (::most_PhonBk_fi_types::T_e8_PhonBkCallHistorySortType e8CallHistorySortType_);

    static const CreateCallHistoryListStart &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_e8CallHistoryType ();

    inline void clear_has_e8CallHistoryType ();

    inline void set_has_e8CallHistorySortType ();

    inline void clear_has_e8CallHistorySortType ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _u8DeviceHandle;

    ::most_PhonBk_fi_types::T_e8_PhonBkCallHistoryType _e8CallHistoryType;

    ::most_PhonBk_fi_types::T_e8_PhonBkCallHistorySortType _e8CallHistorySortType;

};

/**
 * The result message of the method "CreateCallHistoryList"
 * Creates a Call History list of a particular type and returns a ListHandle to the caller.  Slices of the list can then be accessed via RequestCallHistoryListSlice.
 */
class CreateCallHistoryListResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CreateCallHistoryListResult ();

    /**
     * Copy constructor
     */
    inline  CreateCallHistoryListResult (const CreateCallHistoryListResult &rhs);

    /**
     * All fields constructor
     */
    inline  CreateCallHistoryListResult (uint8 u8DeviceHandle_, uint16 u16ListHandle_, uint16 u16ListLength_);

    /**
     * Destructor
     */
    inline virtual  ~CreateCallHistoryListResult();

    /**
     * Assignment operator
     */
    inline CreateCallHistoryListResult& operator = (const CreateCallHistoryListResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreateCallHistoryListResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreateCallHistoryListResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreateCallHistoryListResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreateCallHistoryListResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Handle of the device for the phone book source. The vehicle phone book has a DeviceHandle = 1.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Handle of the device for the phone book source. The vehicle phone book has a DeviceHandle = 1.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "u16ListHandle"

    static const int kU16ListHandle = 1;

    /**
     * Clears the field "u16ListHandle".
     *
     * The field will be set to its default value. The hasU16ListHandle()
     * method will return false.
     */
    inline void clearU16ListHandle();

    /**
     * Checks whether the field "u16ListHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ListHandle()). Otherwise it will return false.
     */
    inline bool hasU16ListHandle () const;

    /**
     * Returns the value of the member "u16ListHandle".
     *
     * The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @return The value of the field "u16ListHandle"
     */
    inline uint16 getU16ListHandle () const;

    /**
     * Sets the value of the member "u16ListHandle".
     *
     * The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @param u16ListHandle The value which will be set
     */
    inline void setU16ListHandle (uint16 u16ListHandle_);

    // API of field "u16ListLength"

    static const int kU16ListLength = 2;

    /**
     * Clears the field "u16ListLength".
     *
     * The field will be set to its default value. The hasU16ListLength()
     * method will return false.
     */
    inline void clearU16ListLength();

    /**
     * Checks whether the field "u16ListLength" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ListLength()). Otherwise it will return false.
     */
    inline bool hasU16ListLength () const;

    /**
     * Returns the value of the member "u16ListLength".
     *
     * The number of elements (i.e. contacts or recent calls) in the Phone Book or Call History list.  The length is valid until the list is modified or released.
     *
     * @return The value of the field "u16ListLength"
     */
    inline uint16 getU16ListLength () const;

    /**
     * Sets the value of the member "u16ListLength".
     *
     * The number of elements (i.e. contacts or recent calls) in the Phone Book or Call History list.  The length is valid until the list is modified or released.
     *
     * @param u16ListLength The value which will be set
     */
    inline void setU16ListLength (uint16 u16ListLength_);

    static const CreateCallHistoryListResult &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_u16ListHandle ();

    inline void clear_has_u16ListHandle ();

    inline void set_has_u16ListLength ();

    inline void clear_has_u16ListLength ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _u8DeviceHandle;

    uint16 _u16ListHandle;

    uint16 _u16ListLength;

};

/**
 * The error message of 'CreateCallHistoryList'
 */
class CreateCallHistoryListErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  CreateCallHistoryListErrorStructure ();

    /**
     * Copy constructor
     */
    inline  CreateCallHistoryListErrorStructure (const CreateCallHistoryListErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  CreateCallHistoryListErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~CreateCallHistoryListErrorStructure();

    /**
     * Assignment operator
     */
    inline CreateCallHistoryListErrorStructure& operator = (const CreateCallHistoryListErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreateCallHistoryListErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreateCallHistoryListErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreateCallHistoryListErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreateCallHistoryListErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     *
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     *
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     *
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     *
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const CreateCallHistoryListErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'CreateCallHistoryList'
 */
class CreateCallHistoryListError  : public ::asf::core::Payload {
public:

    enum CreateCallHistoryListErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  CreateCallHistoryListError ();

   /**
     * Copy constructor
     */
    inline  CreateCallHistoryListError (const CreateCallHistoryListError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~CreateCallHistoryListError();

    /**
     * Assigns a new value to this object.
     */
    inline CreateCallHistoryListError& operator = (const CreateCallHistoryListError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreateCallHistoryListError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreateCallHistoryListError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreateCallHistoryListError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreateCallHistoryListError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline CreateCallHistoryListError::CreateCallHistoryListErrorField getField () const;

    inline void setField(CreateCallHistoryListError::CreateCallHistoryListErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "CreateCallHistoryListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "CreateCallHistoryListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const CreateCallHistoryListErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline CreateCallHistoryListErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline CreateCallHistoryListErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (CreateCallHistoryListErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "CreateCallHistoryListErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const CreateCallHistoryListErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const CreateCallHistoryListError &getDefaultInstance();

private:

    inline void cloneData (const CreateCallHistoryListError& rhs);

    inline void deleteData ();

    CreateCallHistoryListErrorField __field;

    union {
        CreateCallHistoryListErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "RequestSliceCallHistoryList"
 * The RequestSliceCallHistoryList method provides a slice of the sorted call history list type specified by the ListHandle parameter. The slice begins with the item at location WindowStart and includes in sequential order the number of items specified by the parameter WindowSize.  The RequestSliceCallHistoryList method returns the slice as a CallHistoryList stream.  If the number of items in the list starting at WindowStart is less than the WindowSize parameter then the number of items provided in the slice will be less than the WindowSize calling parameter.
 */
class RequestSliceCallHistoryListStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestSliceCallHistoryListStart ();

    /**
     * Copy constructor
     */
    inline  RequestSliceCallHistoryListStart (const RequestSliceCallHistoryListStart &rhs);

    /**
     * All fields constructor
     */
    inline  RequestSliceCallHistoryListStart (uint16 u16ListHandle_, uint32 u32WindowStart_, uint16 u16WindowSize_);

    /**
     * Destructor
     */
    inline virtual  ~RequestSliceCallHistoryListStart();

    /**
     * Assignment operator
     */
    inline RequestSliceCallHistoryListStart& operator = (const RequestSliceCallHistoryListStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestSliceCallHistoryListStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestSliceCallHistoryListStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestSliceCallHistoryListStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestSliceCallHistoryListStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ListHandle"

    static const int kU16ListHandle = 0;

    /**
     * Clears the field "u16ListHandle".
     *
     * The field will be set to its default value. The hasU16ListHandle()
     * method will return false.
     */
    inline void clearU16ListHandle();

    /**
     * Checks whether the field "u16ListHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ListHandle()). Otherwise it will return false.
     */
    inline bool hasU16ListHandle () const;

    /**
     * Returns the value of the member "u16ListHandle".
     *
     * The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @return The value of the field "u16ListHandle"
     */
    inline uint16 getU16ListHandle () const;

    /**
     * Sets the value of the member "u16ListHandle".
     *
     * The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @param u16ListHandle The value which will be set
     */
    inline void setU16ListHandle (uint16 u16ListHandle_);

    // API of field "u32WindowStart"

    static const int kU32WindowStart = 1;

    /**
     * Clears the field "u32WindowStart".
     *
     * The field will be set to its default value. The hasU32WindowStart()
     * method will return false.
     */
    inline void clearU32WindowStart();

    /**
     * Checks whether the field "u32WindowStart" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32WindowStart()). Otherwise it will return false.
     */
    inline bool hasU32WindowStart () const;

    /**
     * Returns the value of the member "u32WindowStart".
     *
     * Specifies the start index of the required section inside the total list.
     *
     * @return The value of the field "u32WindowStart"
     */
    inline uint32 getU32WindowStart () const;

    /**
     * Sets the value of the member "u32WindowStart".
     *
     * Specifies the start index of the required section inside the total list.
     *
     * @param u32WindowStart The value which will be set
     */
    inline void setU32WindowStart (uint32 u32WindowStart_);

    // API of field "u16WindowSize"

    static const int kU16WindowSize = 2;

    /**
     * Clears the field "u16WindowSize".
     *
     * The field will be set to its default value. The hasU16WindowSize()
     * method will return false.
     */
    inline void clearU16WindowSize();

    /**
     * Checks whether the field "u16WindowSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16WindowSize()). Otherwise it will return false.
     */
    inline bool hasU16WindowSize () const;

    /**
     * Returns the value of the member "u16WindowSize".
     *
     * Specifies the size of the required section inside the total list.
     *
     * @return The value of the field "u16WindowSize"
     */
    inline uint16 getU16WindowSize () const;

    /**
     * Sets the value of the member "u16WindowSize".
     *
     * Specifies the size of the required section inside the total list.
     *
     * @param u16WindowSize The value which will be set
     */
    inline void setU16WindowSize (uint16 u16WindowSize_);

    static const RequestSliceCallHistoryListStart &getDefaultInstance();

private:

    inline void set_has_u16ListHandle ();

    inline void clear_has_u16ListHandle ();

    inline void set_has_u32WindowStart ();

    inline void clear_has_u32WindowStart ();

    inline void set_has_u16WindowSize ();

    inline void clear_has_u16WindowSize ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint16 _u16ListHandle;

    uint32 _u32WindowStart;

    uint16 _u16WindowSize;

};

/**
 * The result message of the method "RequestSliceCallHistoryList"
 * The RequestSliceCallHistoryList method provides a slice of the sorted call history list type specified by the ListHandle parameter. The slice begins with the item at location WindowStart and includes in sequential order the number of items specified by the parameter WindowSize.  The RequestSliceCallHistoryList method returns the slice as a CallHistoryList stream.  If the number of items in the list starting at WindowStart is less than the WindowSize parameter then the number of items provided in the slice will be less than the WindowSize calling parameter.
 */
class RequestSliceCallHistoryListResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestSliceCallHistoryListResult ();

    /**
     * Copy constructor
     */
    inline  RequestSliceCallHistoryListResult (const RequestSliceCallHistoryListResult &rhs);

    /**
     * All fields constructor
     */
    inline  RequestSliceCallHistoryListResult (const ::most_PhonBk_fi_types::T_PhonBkCallHistoryListSliceResult& oCallHistoryListSliceResult_);

    /**
     * Destructor
     */
    inline virtual  ~RequestSliceCallHistoryListResult();

    /**
     * Assignment operator
     */
    inline RequestSliceCallHistoryListResult& operator = (const RequestSliceCallHistoryListResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestSliceCallHistoryListResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestSliceCallHistoryListResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestSliceCallHistoryListResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestSliceCallHistoryListResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oCallHistoryListSliceResult"

    static const int kOCallHistoryListSliceResult = 0;

    /**
     * Clears the field "oCallHistoryListSliceResult".
     *
     * The field will be set to its default value. The hasOCallHistoryListSliceResult()
     * method will return false.
     */
    inline void clearOCallHistoryListSliceResult();

    /**
     * Checks whether the field "oCallHistoryListSliceResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOCallHistoryListSliceResult()). Otherwise it will return false.
     */
    inline bool hasOCallHistoryListSliceResult () const;

    /**
     * Returns the value of the member "oCallHistoryListSliceResult".
     *
     *
     *
     * @return The value of the field "oCallHistoryListSliceResult"
     */
    inline const ::most_PhonBk_fi_types::T_PhonBkCallHistoryListSliceResult& getOCallHistoryListSliceResult () const;

    /**
     * Retrieves the value of the field "oCallHistoryListSliceResult" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oCallHistoryListSliceResult".
     */
    inline ::most_PhonBk_fi_types::T_PhonBkCallHistoryListSliceResult& getOCallHistoryListSliceResultMutable ();

    /**
     * Sets the value of the member "oCallHistoryListSliceResult".
     *
     *
     *
     * @param oCallHistoryListSliceResult The value which will be set
     */
    inline void setOCallHistoryListSliceResult (const ::most_PhonBk_fi_types::T_PhonBkCallHistoryListSliceResult& oCallHistoryListSliceResult_);

    static const RequestSliceCallHistoryListResult &getDefaultInstance();

private:

    static const ::std::vector< ::most_PhonBk_fi_types::T_PhonBkCallHistoryListSliceResultItem >& getT_PhonBkCallHistoryListSliceResultItemList_DefaultInstance ();

    inline void set_has_oCallHistoryListSliceResult ();

    inline void clear_has_oCallHistoryListSliceResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_PhonBk_fi_types::T_PhonBkCallHistoryListSliceResult _oCallHistoryListSliceResult;

};

/**
 * The error message of 'RequestSliceCallHistoryList'
 */
class RequestSliceCallHistoryListErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  RequestSliceCallHistoryListErrorStructure ();

    /**
     * Copy constructor
     */
    inline  RequestSliceCallHistoryListErrorStructure (const RequestSliceCallHistoryListErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  RequestSliceCallHistoryListErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~RequestSliceCallHistoryListErrorStructure();

    /**
     * Assignment operator
     */
    inline RequestSliceCallHistoryListErrorStructure& operator = (const RequestSliceCallHistoryListErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestSliceCallHistoryListErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestSliceCallHistoryListErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestSliceCallHistoryListErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestSliceCallHistoryListErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     *
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     *
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     *
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     *
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const RequestSliceCallHistoryListErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'RequestSliceCallHistoryList'
 */
class RequestSliceCallHistoryListError  : public ::asf::core::Payload {
public:

    enum RequestSliceCallHistoryListErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  RequestSliceCallHistoryListError ();

   /**
     * Copy constructor
     */
    inline  RequestSliceCallHistoryListError (const RequestSliceCallHistoryListError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~RequestSliceCallHistoryListError();

    /**
     * Assigns a new value to this object.
     */
    inline RequestSliceCallHistoryListError& operator = (const RequestSliceCallHistoryListError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestSliceCallHistoryListError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestSliceCallHistoryListError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestSliceCallHistoryListError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestSliceCallHistoryListError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline RequestSliceCallHistoryListError::RequestSliceCallHistoryListErrorField getField () const;

    inline void setField(RequestSliceCallHistoryListError::RequestSliceCallHistoryListErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "RequestSliceCallHistoryListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "RequestSliceCallHistoryListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const RequestSliceCallHistoryListErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline RequestSliceCallHistoryListErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline RequestSliceCallHistoryListErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (RequestSliceCallHistoryListErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "RequestSliceCallHistoryListErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const RequestSliceCallHistoryListErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const RequestSliceCallHistoryListError &getDefaultInstance();

private:

    inline void cloneData (const RequestSliceCallHistoryListError& rhs);

    inline void deleteData ();

    RequestSliceCallHistoryListErrorField __field;

    union {
        RequestSliceCallHistoryListErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "ClearMissedCallIndicator"
 * This Method clears the missed called indicator on a particular device. It is initiated when the user selects to view Recent Calls. The FBlock shall also issue a Status notification update of the MissedCallIndicator property set to zero to registered controllers.
 */
class ClearMissedCallIndicatorStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ClearMissedCallIndicatorStart ();

    /**
     * Copy constructor
     */
    inline  ClearMissedCallIndicatorStart (const ClearMissedCallIndicatorStart &rhs);

    /**
     * All fields constructor
     */
    inline  ClearMissedCallIndicatorStart (uint8 u8DeviceHandle_);

    /**
     * Destructor
     */
    inline virtual  ~ClearMissedCallIndicatorStart();

    /**
     * Assignment operator
     */
    inline ClearMissedCallIndicatorStart& operator = (const ClearMissedCallIndicatorStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ClearMissedCallIndicatorStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ClearMissedCallIndicatorStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ClearMissedCallIndicatorStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ClearMissedCallIndicatorStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Handle of the device for the phone book source. The vehicle phone book has a DeviceHandle = 1.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Handle of the device for the phone book source. The vehicle phone book has a DeviceHandle = 1.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    static const ClearMissedCallIndicatorStart &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8DeviceHandle;

};

/**
 * The result message of the method "ClearMissedCallIndicator"
 * This Method clears the missed called indicator on a particular device. It is initiated when the user selects to view Recent Calls. The FBlock shall also issue a Status notification update of the MissedCallIndicator property set to zero to registered controllers.
 */
class ClearMissedCallIndicatorResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ClearMissedCallIndicatorResult ();

    /**
     * Copy constructor
     */
    inline  ClearMissedCallIndicatorResult (const ClearMissedCallIndicatorResult &rhs);

    /**
     * All fields constructor
     */
    inline  ClearMissedCallIndicatorResult (uint8 u8DeviceHandle_);

    /**
     * Destructor
     */
    inline virtual  ~ClearMissedCallIndicatorResult();

    /**
     * Assignment operator
     */
    inline ClearMissedCallIndicatorResult& operator = (const ClearMissedCallIndicatorResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ClearMissedCallIndicatorResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ClearMissedCallIndicatorResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ClearMissedCallIndicatorResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ClearMissedCallIndicatorResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Handle of the device for the phone book source. The vehicle phone book has a DeviceHandle = 1.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Handle of the device for the phone book source. The vehicle phone book has a DeviceHandle = 1.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    static const ClearMissedCallIndicatorResult &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8DeviceHandle;

};

/**
 * The error message of 'ClearMissedCallIndicator'
 */
class ClearMissedCallIndicatorErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  ClearMissedCallIndicatorErrorStructure ();

    /**
     * Copy constructor
     */
    inline  ClearMissedCallIndicatorErrorStructure (const ClearMissedCallIndicatorErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  ClearMissedCallIndicatorErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~ClearMissedCallIndicatorErrorStructure();

    /**
     * Assignment operator
     */
    inline ClearMissedCallIndicatorErrorStructure& operator = (const ClearMissedCallIndicatorErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ClearMissedCallIndicatorErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ClearMissedCallIndicatorErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ClearMissedCallIndicatorErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ClearMissedCallIndicatorErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     *
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     *
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     *
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     *
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const ClearMissedCallIndicatorErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'ClearMissedCallIndicator'
 */
class ClearMissedCallIndicatorError  : public ::asf::core::Payload {
public:

    enum ClearMissedCallIndicatorErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  ClearMissedCallIndicatorError ();

   /**
     * Copy constructor
     */
    inline  ClearMissedCallIndicatorError (const ClearMissedCallIndicatorError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~ClearMissedCallIndicatorError();

    /**
     * Assigns a new value to this object.
     */
    inline ClearMissedCallIndicatorError& operator = (const ClearMissedCallIndicatorError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ClearMissedCallIndicatorError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ClearMissedCallIndicatorError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ClearMissedCallIndicatorError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ClearMissedCallIndicatorError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline ClearMissedCallIndicatorError::ClearMissedCallIndicatorErrorField getField () const;

    inline void setField(ClearMissedCallIndicatorError::ClearMissedCallIndicatorErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "ClearMissedCallIndicatorErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "ClearMissedCallIndicatorErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ClearMissedCallIndicatorErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ClearMissedCallIndicatorErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline ClearMissedCallIndicatorErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (ClearMissedCallIndicatorErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "ClearMissedCallIndicatorErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const ClearMissedCallIndicatorErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const ClearMissedCallIndicatorError &getDefaultInstance();

private:

    inline void cloneData (const ClearMissedCallIndicatorError& rhs);

    inline void deleteData ();

    ClearMissedCallIndicatorErrorField __field;

    union {
        ClearMissedCallIndicatorErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SearchPhoneBook"
 * This is a request from the HMI to search the phone book for a contact name (first and last) and contact detail type that matches the phone number or email address received from the ITelephone or IMessaging FBlock.
 */
class SearchPhoneBookStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SearchPhoneBookStart ();

    /**
     * Copy constructor
     */
    inline  SearchPhoneBookStart (const SearchPhoneBookStart &rhs);

    /**
     * All fields constructor
     */
    inline  SearchPhoneBookStart (uint8 u8DeviceHandle_, const ::fi_basetypes_most::T_String& sPhoneNumber_, const ::fi_basetypes_most::T_String& sEmailAddress_);

    /**
     * Destructor
     */
    inline virtual  ~SearchPhoneBookStart();

    /**
     * Assignment operator
     */
    inline SearchPhoneBookStart& operator = (const SearchPhoneBookStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SearchPhoneBookStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SearchPhoneBookStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SearchPhoneBookStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SearchPhoneBookStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Handle of the device for the phone book source. The vehicle phone book has a DeviceHandle = 1.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Handle of the device for the phone book source. The vehicle phone book has a DeviceHandle = 1.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "sPhoneNumber"

    static const int kSPhoneNumber = 1;

    /**
     * Clears the field "sPhoneNumber".
     *
     * The field will be set to its default value. The hasSPhoneNumber()
     * method will return false.
     */
    inline void clearSPhoneNumber();

    /**
     * Checks whether the field "sPhoneNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPhoneNumber()). Otherwise it will return false.
     */
    inline bool hasSPhoneNumber () const;

    /**
     * Returns the value of the member "sPhoneNumber".
     *
     *
     *
     * @return The value of the field "sPhoneNumber"
     */
    inline const ::fi_basetypes_most::T_String& getSPhoneNumber () const;

    /**
     * Retrieves the value of the field "sPhoneNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sPhoneNumber".
     */
    inline ::fi_basetypes_most::T_String& getSPhoneNumberMutable ();

    /**
     * Sets the value of the member "sPhoneNumber".
     *
     *
     *
     * @param sPhoneNumber The value which will be set
     */
    inline void setSPhoneNumber (const ::fi_basetypes_most::T_String& sPhoneNumber_);

    // API of field "sEmailAddress"

    static const int kSEmailAddress = 2;

    /**
     * Clears the field "sEmailAddress".
     *
     * The field will be set to its default value. The hasSEmailAddress()
     * method will return false.
     */
    inline void clearSEmailAddress();

    /**
     * Checks whether the field "sEmailAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSEmailAddress()). Otherwise it will return false.
     */
    inline bool hasSEmailAddress () const;

    /**
     * Returns the value of the member "sEmailAddress".
     *
     *
     *
     * @return The value of the field "sEmailAddress"
     */
    inline const ::fi_basetypes_most::T_String& getSEmailAddress () const;

    /**
     * Retrieves the value of the field "sEmailAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sEmailAddress".
     */
    inline ::fi_basetypes_most::T_String& getSEmailAddressMutable ();

    /**
     * Sets the value of the member "sEmailAddress".
     *
     *
     *
     * @param sEmailAddress The value which will be set
     */
    inline void setSEmailAddress (const ::fi_basetypes_most::T_String& sEmailAddress_);

    static const SearchPhoneBookStart &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_sPhoneNumber ();

    inline void clear_has_sPhoneNumber ();

    inline void set_has_sEmailAddress ();

    inline void clear_has_sEmailAddress ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _u8DeviceHandle;

    ::fi_basetypes_most::T_String _sPhoneNumber;

    ::fi_basetypes_most::T_String _sEmailAddress;

};

/**
 * The result message of the method "SearchPhoneBook"
 * This is a request from the HMI to search the phone book for a contact name (first and last) and contact detail type that matches the phone number or email address received from the ITelephone or IMessaging FBlock.
 */
class SearchPhoneBookResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SearchPhoneBookResult ();

    /**
     * Copy constructor
     */
    inline  SearchPhoneBookResult (const SearchPhoneBookResult &rhs);

    /**
     * All fields constructor
     */
    inline  SearchPhoneBookResult (uint32 u32ContactHandle_, uint8 u8DeviceHandle_, const ::fi_basetypes_most::T_String& sFirstName_, const ::fi_basetypes_most::T_String& sLastName_, ::most_PhonBk_fi_types::T_e8_PhonBkContactDetailType e8ContactDetailType_);

    /**
     * Destructor
     */
    inline virtual  ~SearchPhoneBookResult();

    /**
     * Assignment operator
     */
    inline SearchPhoneBookResult& operator = (const SearchPhoneBookResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SearchPhoneBookResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SearchPhoneBookResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SearchPhoneBookResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SearchPhoneBookResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32ContactHandle"

    static const int kU32ContactHandle = 0;

    /**
     * Clears the field "u32ContactHandle".
     *
     * The field will be set to its default value. The hasU32ContactHandle()
     * method will return false.
     */
    inline void clearU32ContactHandle();

    /**
     * Checks whether the field "u32ContactHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ContactHandle()). Otherwise it will return false.
     */
    inline bool hasU32ContactHandle () const;

    /**
     * Returns the value of the member "u32ContactHandle".
     *
     * This is the globally unique ID for a particular contact. The ID is unique across all currently connected devices.
     *
     * @return The value of the field "u32ContactHandle"
     */
    inline uint32 getU32ContactHandle () const;

    /**
     * Sets the value of the member "u32ContactHandle".
     *
     * This is the globally unique ID for a particular contact. The ID is unique across all currently connected devices.
     *
     * @param u32ContactHandle The value which will be set
     */
    inline void setU32ContactHandle (uint32 u32ContactHandle_);

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 1;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Handle of the device for the phone book source. The vehicle phone book has a DeviceHandle = 1.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Handle of the device for the phone book source. The vehicle phone book has a DeviceHandle = 1.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "sFirstName"

    static const int kSFirstName = 2;

    /**
     * Clears the field "sFirstName".
     *
     * The field will be set to its default value. The hasSFirstName()
     * method will return false.
     */
    inline void clearSFirstName();

    /**
     * Checks whether the field "sFirstName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSFirstName()). Otherwise it will return false.
     */
    inline bool hasSFirstName () const;

    /**
     * Returns the value of the member "sFirstName".
     *
     *
     *
     * @return The value of the field "sFirstName"
     */
    inline const ::fi_basetypes_most::T_String& getSFirstName () const;

    /**
     * Retrieves the value of the field "sFirstName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sFirstName".
     */
    inline ::fi_basetypes_most::T_String& getSFirstNameMutable ();

    /**
     * Sets the value of the member "sFirstName".
     *
     *
     *
     * @param sFirstName The value which will be set
     */
    inline void setSFirstName (const ::fi_basetypes_most::T_String& sFirstName_);

    // API of field "sLastName"

    static const int kSLastName = 3;

    /**
     * Clears the field "sLastName".
     *
     * The field will be set to its default value. The hasSLastName()
     * method will return false.
     */
    inline void clearSLastName();

    /**
     * Checks whether the field "sLastName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSLastName()). Otherwise it will return false.
     */
    inline bool hasSLastName () const;

    /**
     * Returns the value of the member "sLastName".
     *
     *
     *
     * @return The value of the field "sLastName"
     */
    inline const ::fi_basetypes_most::T_String& getSLastName () const;

    /**
     * Retrieves the value of the field "sLastName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sLastName".
     */
    inline ::fi_basetypes_most::T_String& getSLastNameMutable ();

    /**
     * Sets the value of the member "sLastName".
     *
     *
     *
     * @param sLastName The value which will be set
     */
    inline void setSLastName (const ::fi_basetypes_most::T_String& sLastName_);

    // API of field "e8ContactDetailType"

    static const int kE8ContactDetailType = 4;

    /**
     * Clears the field "e8ContactDetailType".
     *
     * The field will be set to its default value. The hasE8ContactDetailType()
     * method will return false.
     */
    inline void clearE8ContactDetailType();

    /**
     * Checks whether the field "e8ContactDetailType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ContactDetailType()). Otherwise it will return false.
     */
    inline bool hasE8ContactDetailType () const;

    /**
     * Returns the value of the member "e8ContactDetailType".
     *
     * Defines the contact detail type selected
     *
     * @return The value of the field "e8ContactDetailType"
     */
    inline ::most_PhonBk_fi_types::T_e8_PhonBkContactDetailType getE8ContactDetailType () const;

    /**
     * Sets the value of the member "e8ContactDetailType".
     *
     * Defines the contact detail type selected
     *
     * @param e8ContactDetailType The value which will be set
     */
    inline void setE8ContactDetailType (::most_PhonBk_fi_types::T_e8_PhonBkContactDetailType e8ContactDetailType_);

    static const SearchPhoneBookResult &getDefaultInstance();

private:

    inline void set_has_u32ContactHandle ();

    inline void clear_has_u32ContactHandle ();

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_sFirstName ();

    inline void clear_has_sFirstName ();

    inline void set_has_sLastName ();

    inline void clear_has_sLastName ();

    inline void set_has_e8ContactDetailType ();

    inline void clear_has_e8ContactDetailType ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint32 _u32ContactHandle;

    uint8 _u8DeviceHandle;

    ::fi_basetypes_most::T_String _sFirstName;

    ::fi_basetypes_most::T_String _sLastName;

    ::most_PhonBk_fi_types::T_e8_PhonBkContactDetailType _e8ContactDetailType;

};

/**
 * The error message of 'SearchPhoneBook'
 */
class SearchPhoneBookErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SearchPhoneBookErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SearchPhoneBookErrorStructure (const SearchPhoneBookErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SearchPhoneBookErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~SearchPhoneBookErrorStructure();

    /**
     * Assignment operator
     */
    inline SearchPhoneBookErrorStructure& operator = (const SearchPhoneBookErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SearchPhoneBookErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SearchPhoneBookErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SearchPhoneBookErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SearchPhoneBookErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     *
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     *
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     *
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     *
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const SearchPhoneBookErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'SearchPhoneBook'
 */
class SearchPhoneBookError  : public ::asf::core::Payload {
public:

    enum SearchPhoneBookErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SearchPhoneBookError ();

   /**
     * Copy constructor
     */
    inline  SearchPhoneBookError (const SearchPhoneBookError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SearchPhoneBookError();

    /**
     * Assigns a new value to this object.
     */
    inline SearchPhoneBookError& operator = (const SearchPhoneBookError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SearchPhoneBookError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SearchPhoneBookError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SearchPhoneBookError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SearchPhoneBookError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SearchPhoneBookError::SearchPhoneBookErrorField getField () const;

    inline void setField(SearchPhoneBookError::SearchPhoneBookErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SearchPhoneBookErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SearchPhoneBookErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SearchPhoneBookErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SearchPhoneBookErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SearchPhoneBookErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SearchPhoneBookErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SearchPhoneBookErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SearchPhoneBookErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SearchPhoneBookError &getDefaultInstance();

private:

    inline void cloneData (const SearchPhoneBookError& rhs);

    inline void deleteData ();

    SearchPhoneBookErrorField __field;

    union {
        SearchPhoneBookErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "ReleaseCallHistoryList"
 * The ReleaseCallHistoryList function releases a list which has been created by the CreateCallHistoryList function.  The list to release is specified by the ListHandle parameter. The ListHandle becomes invalid by this function.
 */
class ReleaseCallHistoryListStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReleaseCallHistoryListStart ();

    /**
     * Copy constructor
     */
    inline  ReleaseCallHistoryListStart (const ReleaseCallHistoryListStart &rhs);

    /**
     * All fields constructor
     */
    inline  ReleaseCallHistoryListStart (uint16 u16ListHandle_);

    /**
     * Destructor
     */
    inline virtual  ~ReleaseCallHistoryListStart();

    /**
     * Assignment operator
     */
    inline ReleaseCallHistoryListStart& operator = (const ReleaseCallHistoryListStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReleaseCallHistoryListStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReleaseCallHistoryListStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReleaseCallHistoryListStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReleaseCallHistoryListStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ListHandle"

    static const int kU16ListHandle = 0;

    /**
     * Clears the field "u16ListHandle".
     *
     * The field will be set to its default value. The hasU16ListHandle()
     * method will return false.
     */
    inline void clearU16ListHandle();

    /**
     * Checks whether the field "u16ListHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ListHandle()). Otherwise it will return false.
     */
    inline bool hasU16ListHandle () const;

    /**
     * Returns the value of the member "u16ListHandle".
     *
     * The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @return The value of the field "u16ListHandle"
     */
    inline uint16 getU16ListHandle () const;

    /**
     * Sets the value of the member "u16ListHandle".
     *
     * The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @param u16ListHandle The value which will be set
     */
    inline void setU16ListHandle (uint16 u16ListHandle_);

    static const ReleaseCallHistoryListStart &getDefaultInstance();

private:

    inline void set_has_u16ListHandle ();

    inline void clear_has_u16ListHandle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ListHandle;

};

/**
 * The result message of the method "ReleaseCallHistoryList"
 * The ReleaseCallHistoryList function releases a list which has been created by the CreateCallHistoryList function.  The list to release is specified by the ListHandle parameter. The ListHandle becomes invalid by this function.
 */
class ReleaseCallHistoryListResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReleaseCallHistoryListResult ();

    /**
     * Copy constructor
     */
    inline  ReleaseCallHistoryListResult (const ReleaseCallHistoryListResult &rhs);

    /**
     * All fields constructor
     */
    inline  ReleaseCallHistoryListResult (uint16 u16ListHandle_);

    /**
     * Destructor
     */
    inline virtual  ~ReleaseCallHistoryListResult();

    /**
     * Assignment operator
     */
    inline ReleaseCallHistoryListResult& operator = (const ReleaseCallHistoryListResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReleaseCallHistoryListResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReleaseCallHistoryListResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReleaseCallHistoryListResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReleaseCallHistoryListResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ListHandle"

    static const int kU16ListHandle = 0;

    /**
     * Clears the field "u16ListHandle".
     *
     * The field will be set to its default value. The hasU16ListHandle()
     * method will return false.
     */
    inline void clearU16ListHandle();

    /**
     * Checks whether the field "u16ListHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ListHandle()). Otherwise it will return false.
     */
    inline bool hasU16ListHandle () const;

    /**
     * Returns the value of the member "u16ListHandle".
     *
     * The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @return The value of the field "u16ListHandle"
     */
    inline uint16 getU16ListHandle () const;

    /**
     * Sets the value of the member "u16ListHandle".
     *
     * The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @param u16ListHandle The value which will be set
     */
    inline void setU16ListHandle (uint16 u16ListHandle_);

    static const ReleaseCallHistoryListResult &getDefaultInstance();

private:

    inline void set_has_u16ListHandle ();

    inline void clear_has_u16ListHandle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ListHandle;

};

/**
 * The error message of 'ReleaseCallHistoryList'
 */
class ReleaseCallHistoryListErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  ReleaseCallHistoryListErrorStructure ();

    /**
     * Copy constructor
     */
    inline  ReleaseCallHistoryListErrorStructure (const ReleaseCallHistoryListErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  ReleaseCallHistoryListErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~ReleaseCallHistoryListErrorStructure();

    /**
     * Assignment operator
     */
    inline ReleaseCallHistoryListErrorStructure& operator = (const ReleaseCallHistoryListErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReleaseCallHistoryListErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReleaseCallHistoryListErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReleaseCallHistoryListErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReleaseCallHistoryListErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     *
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     *
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     *
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     *
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const ReleaseCallHistoryListErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'ReleaseCallHistoryList'
 */
class ReleaseCallHistoryListError  : public ::asf::core::Payload {
public:

    enum ReleaseCallHistoryListErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  ReleaseCallHistoryListError ();

   /**
     * Copy constructor
     */
    inline  ReleaseCallHistoryListError (const ReleaseCallHistoryListError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~ReleaseCallHistoryListError();

    /**
     * Assigns a new value to this object.
     */
    inline ReleaseCallHistoryListError& operator = (const ReleaseCallHistoryListError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReleaseCallHistoryListError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReleaseCallHistoryListError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReleaseCallHistoryListError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReleaseCallHistoryListError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline ReleaseCallHistoryListError::ReleaseCallHistoryListErrorField getField () const;

    inline void setField(ReleaseCallHistoryListError::ReleaseCallHistoryListErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "ReleaseCallHistoryListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "ReleaseCallHistoryListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ReleaseCallHistoryListErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ReleaseCallHistoryListErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline ReleaseCallHistoryListErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (ReleaseCallHistoryListErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "ReleaseCallHistoryListErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const ReleaseCallHistoryListErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const ReleaseCallHistoryListError &getDefaultInstance();

private:

    inline void cloneData (const ReleaseCallHistoryListError& rhs);

    inline void deleteData ();

    ReleaseCallHistoryListErrorField __field;

    union {
        ReleaseCallHistoryListErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "GetContactPhotoInfo"
 * This method GetContactPhotoInfo has become DEPRECATED. HMI Controllers are recommended to call
 * the method GetContactPhoto directly without a prior call of GetContactPhotoInfo.
 *
 * Acquires the photo MIME image subtype and the size of the image. If the MIMEImageSubtype = NULL then there is no photo associated with the ContactHandle.
 */
class GetContactPhotoInfoStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetContactPhotoInfoStart ();

    /**
     * Copy constructor
     */
    inline  GetContactPhotoInfoStart (const GetContactPhotoInfoStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetContactPhotoInfoStart (uint32 u32ContactHandle_);

    /**
     * Destructor
     */
    inline virtual  ~GetContactPhotoInfoStart();

    /**
     * Assignment operator
     */
    inline GetContactPhotoInfoStart& operator = (const GetContactPhotoInfoStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetContactPhotoInfoStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetContactPhotoInfoStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetContactPhotoInfoStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetContactPhotoInfoStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32ContactHandle"

    static const int kU32ContactHandle = 0;

    /**
     * Clears the field "u32ContactHandle".
     *
     * The field will be set to its default value. The hasU32ContactHandle()
     * method will return false.
     */
    inline void clearU32ContactHandle();

    /**
     * Checks whether the field "u32ContactHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ContactHandle()). Otherwise it will return false.
     */
    inline bool hasU32ContactHandle () const;

    /**
     * Returns the value of the member "u32ContactHandle".
     *
     * This is the globally unique ID for a particular contact. The ID is unique across all currently connected devices.
     *
     * @return The value of the field "u32ContactHandle"
     */
    inline uint32 getU32ContactHandle () const;

    /**
     * Sets the value of the member "u32ContactHandle".
     *
     * This is the globally unique ID for a particular contact. The ID is unique across all currently connected devices.
     *
     * @param u32ContactHandle The value which will be set
     */
    inline void setU32ContactHandle (uint32 u32ContactHandle_);

    static const GetContactPhotoInfoStart &getDefaultInstance();

private:

    inline void set_has_u32ContactHandle ();

    inline void clear_has_u32ContactHandle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _u32ContactHandle;

};

/**
 * The result message of the method "GetContactPhotoInfo"
 * This method GetContactPhotoInfo has become DEPRECATED. HMI Controllers are recommended to call
 * the method GetContactPhoto directly without a prior call of GetContactPhotoInfo.
 *
 * Acquires the photo MIME image subtype and the size of the image. If the MIMEImageSubtype = NULL then there is no photo associated with the ContactHandle.
 */
class GetContactPhotoInfoResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetContactPhotoInfoResult ();

    /**
     * Copy constructor
     */
    inline  GetContactPhotoInfoResult (const GetContactPhotoInfoResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetContactPhotoInfoResult (uint32 u32ContactHandle_, const ::fi_basetypes_most::T_String& sMIMEImageSubtype_, uint32 u32PhotoImageSize_);

    /**
     * Destructor
     */
    inline virtual  ~GetContactPhotoInfoResult();

    /**
     * Assignment operator
     */
    inline GetContactPhotoInfoResult& operator = (const GetContactPhotoInfoResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetContactPhotoInfoResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetContactPhotoInfoResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetContactPhotoInfoResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetContactPhotoInfoResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32ContactHandle"

    static const int kU32ContactHandle = 0;

    /**
     * Clears the field "u32ContactHandle".
     *
     * The field will be set to its default value. The hasU32ContactHandle()
     * method will return false.
     */
    inline void clearU32ContactHandle();

    /**
     * Checks whether the field "u32ContactHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ContactHandle()). Otherwise it will return false.
     */
    inline bool hasU32ContactHandle () const;

    /**
     * Returns the value of the member "u32ContactHandle".
     *
     * This is the globally unique ID for a particular contact. The ID is unique across all currently connected devices.
     *
     * @return The value of the field "u32ContactHandle"
     */
    inline uint32 getU32ContactHandle () const;

    /**
     * Sets the value of the member "u32ContactHandle".
     *
     * This is the globally unique ID for a particular contact. The ID is unique across all currently connected devices.
     *
     * @param u32ContactHandle The value which will be set
     */
    inline void setU32ContactHandle (uint32 u32ContactHandle_);

    // API of field "sMIMEImageSubtype"

    static const int kSMIMEImageSubtype = 1;

    /**
     * Clears the field "sMIMEImageSubtype".
     *
     * The field will be set to its default value. The hasSMIMEImageSubtype()
     * method will return false.
     */
    inline void clearSMIMEImageSubtype();

    /**
     * Checks whether the field "sMIMEImageSubtype" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSMIMEImageSubtype()). Otherwise it will return false.
     */
    inline bool hasSMIMEImageSubtype () const;

    /**
     * Returns the value of the member "sMIMEImageSubtype".
     *
     * Identifies the MIME image subtype
     *
     * @return The value of the field "sMIMEImageSubtype"
     */
    inline const ::fi_basetypes_most::T_String& getSMIMEImageSubtype () const;

    /**
     * Retrieves the value of the field "sMIMEImageSubtype" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sMIMEImageSubtype".
     */
    inline ::fi_basetypes_most::T_String& getSMIMEImageSubtypeMutable ();

    /**
     * Sets the value of the member "sMIMEImageSubtype".
     *
     * Identifies the MIME image subtype
     *
     * @param sMIMEImageSubtype The value which will be set
     */
    inline void setSMIMEImageSubtype (const ::fi_basetypes_most::T_String& sMIMEImageSubtype_);

    // API of field "u32PhotoImageSize"

    static const int kU32PhotoImageSize = 2;

    /**
     * Clears the field "u32PhotoImageSize".
     *
     * The field will be set to its default value. The hasU32PhotoImageSize()
     * method will return false.
     */
    inline void clearU32PhotoImageSize();

    /**
     * Checks whether the field "u32PhotoImageSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32PhotoImageSize()). Otherwise it will return false.
     */
    inline bool hasU32PhotoImageSize () const;

    /**
     * Returns the value of the member "u32PhotoImageSize".
     *
     * The size of the image stream in bytes that will be returned from GetContactPhoto for this ContactHandle.
     *
     * @return The value of the field "u32PhotoImageSize"
     */
    inline uint32 getU32PhotoImageSize () const;

    /**
     * Sets the value of the member "u32PhotoImageSize".
     *
     * The size of the image stream in bytes that will be returned from GetContactPhoto for this ContactHandle.
     *
     * @param u32PhotoImageSize The value which will be set
     */
    inline void setU32PhotoImageSize (uint32 u32PhotoImageSize_);

    static const GetContactPhotoInfoResult &getDefaultInstance();

private:

    inline void set_has_u32ContactHandle ();

    inline void clear_has_u32ContactHandle ();

    inline void set_has_sMIMEImageSubtype ();

    inline void clear_has_sMIMEImageSubtype ();

    inline void set_has_u32PhotoImageSize ();

    inline void clear_has_u32PhotoImageSize ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _u32ContactHandle;

    ::fi_basetypes_most::T_String _sMIMEImageSubtype;

    uint32 _u32PhotoImageSize;

};

/**
 * The error message of 'GetContactPhotoInfo'
 */
class GetContactPhotoInfoErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetContactPhotoInfoErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetContactPhotoInfoErrorStructure (const GetContactPhotoInfoErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetContactPhotoInfoErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~GetContactPhotoInfoErrorStructure();

    /**
     * Assignment operator
     */
    inline GetContactPhotoInfoErrorStructure& operator = (const GetContactPhotoInfoErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetContactPhotoInfoErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetContactPhotoInfoErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetContactPhotoInfoErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetContactPhotoInfoErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     *
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     *
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     *
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     *
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const GetContactPhotoInfoErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'GetContactPhotoInfo'
 */
class GetContactPhotoInfoError  : public ::asf::core::Payload {
public:

    enum GetContactPhotoInfoErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetContactPhotoInfoError ();

   /**
     * Copy constructor
     */
    inline  GetContactPhotoInfoError (const GetContactPhotoInfoError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetContactPhotoInfoError();

    /**
     * Assigns a new value to this object.
     */
    inline GetContactPhotoInfoError& operator = (const GetContactPhotoInfoError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetContactPhotoInfoError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetContactPhotoInfoError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetContactPhotoInfoError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetContactPhotoInfoError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetContactPhotoInfoError::GetContactPhotoInfoErrorField getField () const;

    inline void setField(GetContactPhotoInfoError::GetContactPhotoInfoErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetContactPhotoInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetContactPhotoInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetContactPhotoInfoErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetContactPhotoInfoErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetContactPhotoInfoErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetContactPhotoInfoErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetContactPhotoInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetContactPhotoInfoErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetContactPhotoInfoError &getDefaultInstance();

private:

    inline void cloneData (const GetContactPhotoInfoError& rhs);

    inline void deleteData ();

    GetContactPhotoInfoErrorField __field;

    union {
        GetContactPhotoInfoErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "GetDeviceCallHistorySupport"
 * This Method identifies the device call history support. Specifically, it identifies the call history list types supported by the device and whether the lists support date/time.
 */
class GetDeviceCallHistorySupportStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetDeviceCallHistorySupportStart ();

    /**
     * Copy constructor
     */
    inline  GetDeviceCallHistorySupportStart (const GetDeviceCallHistorySupportStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetDeviceCallHistorySupportStart (uint8 u8DeviceHandle_);

    /**
     * Destructor
     */
    inline virtual  ~GetDeviceCallHistorySupportStart();

    /**
     * Assignment operator
     */
    inline GetDeviceCallHistorySupportStart& operator = (const GetDeviceCallHistorySupportStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetDeviceCallHistorySupportStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetDeviceCallHistorySupportStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetDeviceCallHistorySupportStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetDeviceCallHistorySupportStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Handle of the device for the phone book source. The vehicle phone book has a DeviceHandle = 1.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Handle of the device for the phone book source. The vehicle phone book has a DeviceHandle = 1.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    static const GetDeviceCallHistorySupportStart &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8DeviceHandle;

};

/**
 * The result message of the method "GetDeviceCallHistorySupport"
 * This Method identifies the device call history support. Specifically, it identifies the call history list types supported by the device and whether the lists support date/time.
 */
class GetDeviceCallHistorySupportResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetDeviceCallHistorySupportResult ();

    /**
     * Copy constructor
     */
    inline  GetDeviceCallHistorySupportResult (const GetDeviceCallHistorySupportResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetDeviceCallHistorySupportResult (uint8 u8DeviceHandle_, const ::most_PhonBk_fi_types::T_PhonBkCallHistoryTypeSupport& oCallHistoryTypeSupport_, bool bCallHistoryDateTimeSupport_);

    /**
     * Destructor
     */
    inline virtual  ~GetDeviceCallHistorySupportResult();

    /**
     * Assignment operator
     */
    inline GetDeviceCallHistorySupportResult& operator = (const GetDeviceCallHistorySupportResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetDeviceCallHistorySupportResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetDeviceCallHistorySupportResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetDeviceCallHistorySupportResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetDeviceCallHistorySupportResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Handle of the device for the phone book source. The vehicle phone book has a DeviceHandle = 1.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Handle of the device for the phone book source. The vehicle phone book has a DeviceHandle = 1.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "oCallHistoryTypeSupport"

    static const int kOCallHistoryTypeSupport = 1;

    /**
     * Clears the field "oCallHistoryTypeSupport".
     *
     * The field will be set to its default value. The hasOCallHistoryTypeSupport()
     * method will return false.
     */
    inline void clearOCallHistoryTypeSupport();

    /**
     * Checks whether the field "oCallHistoryTypeSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOCallHistoryTypeSupport()). Otherwise it will return false.
     */
    inline bool hasOCallHistoryTypeSupport () const;

    /**
     * Returns the value of the member "oCallHistoryTypeSupport".
     *
     * Identifies the call history types supported by the device.
     *
     * @return The value of the field "oCallHistoryTypeSupport"
     */
    inline const ::most_PhonBk_fi_types::T_PhonBkCallHistoryTypeSupport& getOCallHistoryTypeSupport () const;

    /**
     * Retrieves the value of the field "oCallHistoryTypeSupport" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oCallHistoryTypeSupport".
     */
    inline ::most_PhonBk_fi_types::T_PhonBkCallHistoryTypeSupport& getOCallHistoryTypeSupportMutable ();

    /**
     * Sets the value of the member "oCallHistoryTypeSupport".
     *
     * Identifies the call history types supported by the device.
     *
     * @param oCallHistoryTypeSupport The value which will be set
     */
    inline void setOCallHistoryTypeSupport (const ::most_PhonBk_fi_types::T_PhonBkCallHistoryTypeSupport& oCallHistoryTypeSupport_);

    // API of field "bCallHistoryDateTimeSupport"

    static const int kBCallHistoryDateTimeSupport = 2;

    /**
     * Clears the field "bCallHistoryDateTimeSupport".
     *
     * The field will be set to its default value. The hasBCallHistoryDateTimeSupport()
     * method will return false.
     */
    inline void clearBCallHistoryDateTimeSupport();

    /**
     * Checks whether the field "bCallHistoryDateTimeSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBCallHistoryDateTimeSupport()). Otherwise it will return false.
     */
    inline bool hasBCallHistoryDateTimeSupport () const;

    /**
     * Returns the value of the member "bCallHistoryDateTimeSupport".
     *
     * Identifies if the call history lists support date/time.
     *
     * @return The value of the field "bCallHistoryDateTimeSupport"
     */
    inline bool getBCallHistoryDateTimeSupport () const;

    /**
     * Sets the value of the member "bCallHistoryDateTimeSupport".
     *
     * Identifies if the call history lists support date/time.
     *
     * @param bCallHistoryDateTimeSupport The value which will be set
     */
    inline void setBCallHistoryDateTimeSupport (bool bCallHistoryDateTimeSupport_);

    static const GetDeviceCallHistorySupportResult &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_oCallHistoryTypeSupport ();

    inline void clear_has_oCallHistoryTypeSupport ();

    inline void set_has_bCallHistoryDateTimeSupport ();

    inline void clear_has_bCallHistoryDateTimeSupport ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _u8DeviceHandle;

    ::most_PhonBk_fi_types::T_PhonBkCallHistoryTypeSupport _oCallHistoryTypeSupport;

    bool _bCallHistoryDateTimeSupport;

};

/**
 * The error message of 'GetDeviceCallHistorySupport'
 */
class GetDeviceCallHistorySupportErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetDeviceCallHistorySupportErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetDeviceCallHistorySupportErrorStructure (const GetDeviceCallHistorySupportErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetDeviceCallHistorySupportErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~GetDeviceCallHistorySupportErrorStructure();

    /**
     * Assignment operator
     */
    inline GetDeviceCallHistorySupportErrorStructure& operator = (const GetDeviceCallHistorySupportErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetDeviceCallHistorySupportErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetDeviceCallHistorySupportErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetDeviceCallHistorySupportErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetDeviceCallHistorySupportErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     *
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     *
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     *
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     *
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const GetDeviceCallHistorySupportErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'GetDeviceCallHistorySupport'
 */
class GetDeviceCallHistorySupportError  : public ::asf::core::Payload {
public:

    enum GetDeviceCallHistorySupportErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetDeviceCallHistorySupportError ();

   /**
     * Copy constructor
     */
    inline  GetDeviceCallHistorySupportError (const GetDeviceCallHistorySupportError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetDeviceCallHistorySupportError();

    /**
     * Assigns a new value to this object.
     */
    inline GetDeviceCallHistorySupportError& operator = (const GetDeviceCallHistorySupportError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetDeviceCallHistorySupportError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetDeviceCallHistorySupportError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetDeviceCallHistorySupportError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetDeviceCallHistorySupportError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetDeviceCallHistorySupportError::GetDeviceCallHistorySupportErrorField getField () const;

    inline void setField(GetDeviceCallHistorySupportError::GetDeviceCallHistorySupportErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetDeviceCallHistorySupportErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetDeviceCallHistorySupportErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetDeviceCallHistorySupportErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetDeviceCallHistorySupportErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetDeviceCallHistorySupportErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetDeviceCallHistorySupportErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetDeviceCallHistorySupportErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetDeviceCallHistorySupportErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetDeviceCallHistorySupportError &getDefaultInstance();

private:

    inline void cloneData (const GetDeviceCallHistorySupportError& rhs);

    inline void deleteData ();

    GetDeviceCallHistorySupportErrorField __field;

    union {
        GetDeviceCallHistorySupportErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "AutocompletePhoneNumberEntry"
 * This method is used to acquire the phone number match to the recent call history list as the user enters phone number digits. In addition, the PhoneBook identifies if a match exists using the AutocompleteMatch parameter, and also returns the number of matches (NumberOfMatches), and the ID of the list of multiple matches for the phone number digits provided (AutocompleteMultipleMatchListID). The AutocompleteMultipleMatchListID is used to display the list of multiple matches for the phone number digits provided.
 */
class AutocompletePhoneNumberEntryStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AutocompletePhoneNumberEntryStart ();

    /**
     * Copy constructor
     */
    inline  AutocompletePhoneNumberEntryStart (const AutocompletePhoneNumberEntryStart &rhs);

    /**
     * All fields constructor
     */
    inline  AutocompletePhoneNumberEntryStart (const ::fi_basetypes_most::T_String& sPhoneNumberDigits_);

    /**
     * Destructor
     */
    inline virtual  ~AutocompletePhoneNumberEntryStart();

    /**
     * Assignment operator
     */
    inline AutocompletePhoneNumberEntryStart& operator = (const AutocompletePhoneNumberEntryStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AutocompletePhoneNumberEntryStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AutocompletePhoneNumberEntryStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AutocompletePhoneNumberEntryStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AutocompletePhoneNumberEntryStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sPhoneNumberDigits"

    static const int kSPhoneNumberDigits = 0;

    /**
     * Clears the field "sPhoneNumberDigits".
     *
     * The field will be set to its default value. The hasSPhoneNumberDigits()
     * method will return false.
     */
    inline void clearSPhoneNumberDigits();

    /**
     * Checks whether the field "sPhoneNumberDigits" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPhoneNumberDigits()). Otherwise it will return false.
     */
    inline bool hasSPhoneNumberDigits () const;

    /**
     * Returns the value of the member "sPhoneNumberDigits".
     *
     * The digits that make up the phone number as entered by the user.
     *
     * @return The value of the field "sPhoneNumberDigits"
     */
    inline const ::fi_basetypes_most::T_String& getSPhoneNumberDigits () const;

    /**
     * Retrieves the value of the field "sPhoneNumberDigits" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sPhoneNumberDigits".
     */
    inline ::fi_basetypes_most::T_String& getSPhoneNumberDigitsMutable ();

    /**
     * Sets the value of the member "sPhoneNumberDigits".
     *
     * The digits that make up the phone number as entered by the user.
     *
     * @param sPhoneNumberDigits The value which will be set
     */
    inline void setSPhoneNumberDigits (const ::fi_basetypes_most::T_String& sPhoneNumberDigits_);

    static const AutocompletePhoneNumberEntryStart &getDefaultInstance();

private:

    inline void set_has_sPhoneNumberDigits ();

    inline void clear_has_sPhoneNumberDigits ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::fi_basetypes_most::T_String _sPhoneNumberDigits;

};

/**
 * The result message of the method "AutocompletePhoneNumberEntry"
 * This method is used to acquire the phone number match to the recent call history list as the user enters phone number digits. In addition, the PhoneBook identifies if a match exists using the AutocompleteMatch parameter, and also returns the number of matches (NumberOfMatches), and the ID of the list of multiple matches for the phone number digits provided (AutocompleteMultipleMatchListID). The AutocompleteMultipleMatchListID is used to display the list of multiple matches for the phone number digits provided.
 */
class AutocompletePhoneNumberEntryResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AutocompletePhoneNumberEntryResult ();

    /**
     * Copy constructor
     */
    inline  AutocompletePhoneNumberEntryResult (const AutocompletePhoneNumberEntryResult &rhs);

    /**
     * All fields constructor
     */
    inline  AutocompletePhoneNumberEntryResult (bool bAutocompleteMatch_, const ::fi_basetypes_most::T_String& sAutocompleteMatchPhoneNumber_, uint8 u8NumberOfMatches_, const ::most_PhonBk_fi_types::T_PhonBkAutocompleteMultipleMatchList& oAutocompleteMultipleMatchList_);

    /**
     * Destructor
     */
    inline virtual  ~AutocompletePhoneNumberEntryResult();

    /**
     * Assignment operator
     */
    inline AutocompletePhoneNumberEntryResult& operator = (const AutocompletePhoneNumberEntryResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AutocompletePhoneNumberEntryResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AutocompletePhoneNumberEntryResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AutocompletePhoneNumberEntryResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AutocompletePhoneNumberEntryResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bAutocompleteMatch"

    static const int kBAutocompleteMatch = 0;

    /**
     * Clears the field "bAutocompleteMatch".
     *
     * The field will be set to its default value. The hasBAutocompleteMatch()
     * method will return false.
     */
    inline void clearBAutocompleteMatch();

    /**
     * Checks whether the field "bAutocompleteMatch" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBAutocompleteMatch()). Otherwise it will return false.
     */
    inline bool hasBAutocompleteMatch () const;

    /**
     * Returns the value of the member "bAutocompleteMatch".
     *
     * Identifies if an autocomplete match existed for the user phone number digits provided.
     *
     * @return The value of the field "bAutocompleteMatch"
     */
    inline bool getBAutocompleteMatch () const;

    /**
     * Sets the value of the member "bAutocompleteMatch".
     *
     * Identifies if an autocomplete match existed for the user phone number digits provided.
     *
     * @param bAutocompleteMatch The value which will be set
     */
    inline void setBAutocompleteMatch (bool bAutocompleteMatch_);

    // API of field "sAutocompleteMatchPhoneNumber"

    static const int kSAutocompleteMatchPhoneNumber = 1;

    /**
     * Clears the field "sAutocompleteMatchPhoneNumber".
     *
     * The field will be set to its default value. The hasSAutocompleteMatchPhoneNumber()
     * method will return false.
     */
    inline void clearSAutocompleteMatchPhoneNumber();

    /**
     * Checks whether the field "sAutocompleteMatchPhoneNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSAutocompleteMatchPhoneNumber()). Otherwise it will return false.
     */
    inline bool hasSAutocompleteMatchPhoneNumber () const;

    /**
     * Returns the value of the member "sAutocompleteMatchPhoneNumber".
     *
     * The recent call history phone number that matches the user phone number digits provided.If there are no matches the PhoneBook returns an empty string for the AutocompleteMatchPhoneNumber. If there are multiple matches the PhoneBook returns the AutocompleteMatchPhoneNumber with the most recent date and time.
     *
     * @return The value of the field "sAutocompleteMatchPhoneNumber"
     */
    inline const ::fi_basetypes_most::T_String& getSAutocompleteMatchPhoneNumber () const;

    /**
     * Retrieves the value of the field "sAutocompleteMatchPhoneNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sAutocompleteMatchPhoneNumber".
     */
    inline ::fi_basetypes_most::T_String& getSAutocompleteMatchPhoneNumberMutable ();

    /**
     * Sets the value of the member "sAutocompleteMatchPhoneNumber".
     *
     * The recent call history phone number that matches the user phone number digits provided.If there are no matches the PhoneBook returns an empty string for the AutocompleteMatchPhoneNumber. If there are multiple matches the PhoneBook returns the AutocompleteMatchPhoneNumber with the most recent date and time.
     *
     * @param sAutocompleteMatchPhoneNumber The value which will be set
     */
    inline void setSAutocompleteMatchPhoneNumber (const ::fi_basetypes_most::T_String& sAutocompleteMatchPhoneNumber_);

    // API of field "u8NumberOfMatches"

    static const int kU8NumberOfMatches = 2;

    /**
     * Clears the field "u8NumberOfMatches".
     *
     * The field will be set to its default value. The hasU8NumberOfMatches()
     * method will return false.
     */
    inline void clearU8NumberOfMatches();

    /**
     * Checks whether the field "u8NumberOfMatches" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8NumberOfMatches()). Otherwise it will return false.
     */
    inline bool hasU8NumberOfMatches () const;

    /**
     * Returns the value of the member "u8NumberOfMatches".
     *
     * Provides the number of matches that were identified based on the user phone number digits provided.
     *
     * @return The value of the field "u8NumberOfMatches"
     */
    inline uint8 getU8NumberOfMatches () const;

    /**
     * Sets the value of the member "u8NumberOfMatches".
     *
     * Provides the number of matches that were identified based on the user phone number digits provided.
     *
     * @param u8NumberOfMatches The value which will be set
     */
    inline void setU8NumberOfMatches (uint8 u8NumberOfMatches_);

    // API of field "oAutocompleteMultipleMatchList"

    static const int kOAutocompleteMultipleMatchList = 3;

    /**
     * Clears the field "oAutocompleteMultipleMatchList".
     *
     * The field will be set to its default value. The hasOAutocompleteMultipleMatchList()
     * method will return false.
     */
    inline void clearOAutocompleteMultipleMatchList();

    /**
     * Checks whether the field "oAutocompleteMultipleMatchList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOAutocompleteMultipleMatchList()). Otherwise it will return false.
     */
    inline bool hasOAutocompleteMultipleMatchList () const;

    /**
     * Returns the value of the member "oAutocompleteMultipleMatchList".
     *
     *
     *
     * @return The value of the field "oAutocompleteMultipleMatchList"
     */
    inline const ::most_PhonBk_fi_types::T_PhonBkAutocompleteMultipleMatchList& getOAutocompleteMultipleMatchList () const;

    /**
     * Retrieves the value of the field "oAutocompleteMultipleMatchList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oAutocompleteMultipleMatchList".
     */
    inline ::most_PhonBk_fi_types::T_PhonBkAutocompleteMultipleMatchList& getOAutocompleteMultipleMatchListMutable ();

    /**
     * Sets the value of the member "oAutocompleteMultipleMatchList".
     *
     *
     *
     * @param oAutocompleteMultipleMatchList The value which will be set
     */
    inline void setOAutocompleteMultipleMatchList (const ::most_PhonBk_fi_types::T_PhonBkAutocompleteMultipleMatchList& oAutocompleteMultipleMatchList_);

    static const AutocompletePhoneNumberEntryResult &getDefaultInstance();

private:

    static const ::std::vector< ::most_PhonBk_fi_types::T_PhonBkAutocompleteMultipleMatchListItem >& getT_PhonBkAutocompleteMultipleMatchListItemList_DefaultInstance ();

    inline void set_has_bAutocompleteMatch ();

    inline void clear_has_bAutocompleteMatch ();

    inline void set_has_sAutocompleteMatchPhoneNumber ();

    inline void clear_has_sAutocompleteMatchPhoneNumber ();

    inline void set_has_u8NumberOfMatches ();

    inline void clear_has_u8NumberOfMatches ();

    inline void set_has_oAutocompleteMultipleMatchList ();

    inline void clear_has_oAutocompleteMultipleMatchList ();

    uint32 _has_bits_[ (4 + 31) / 32];

    bool _bAutocompleteMatch;

    ::fi_basetypes_most::T_String _sAutocompleteMatchPhoneNumber;

    uint8 _u8NumberOfMatches;

    ::most_PhonBk_fi_types::T_PhonBkAutocompleteMultipleMatchList _oAutocompleteMultipleMatchList;

};

/**
 * The error message of 'AutocompletePhoneNumberEntry'
 */
class AutocompletePhoneNumberEntryErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  AutocompletePhoneNumberEntryErrorStructure ();

    /**
     * Copy constructor
     */
    inline  AutocompletePhoneNumberEntryErrorStructure (const AutocompletePhoneNumberEntryErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  AutocompletePhoneNumberEntryErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~AutocompletePhoneNumberEntryErrorStructure();

    /**
     * Assignment operator
     */
    inline AutocompletePhoneNumberEntryErrorStructure& operator = (const AutocompletePhoneNumberEntryErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AutocompletePhoneNumberEntryErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AutocompletePhoneNumberEntryErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AutocompletePhoneNumberEntryErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AutocompletePhoneNumberEntryErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     *
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     *
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     *
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     *
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const AutocompletePhoneNumberEntryErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'AutocompletePhoneNumberEntry'
 */
class AutocompletePhoneNumberEntryError  : public ::asf::core::Payload {
public:

    enum AutocompletePhoneNumberEntryErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  AutocompletePhoneNumberEntryError ();

   /**
     * Copy constructor
     */
    inline  AutocompletePhoneNumberEntryError (const AutocompletePhoneNumberEntryError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~AutocompletePhoneNumberEntryError();

    /**
     * Assigns a new value to this object.
     */
    inline AutocompletePhoneNumberEntryError& operator = (const AutocompletePhoneNumberEntryError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AutocompletePhoneNumberEntryError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AutocompletePhoneNumberEntryError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AutocompletePhoneNumberEntryError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AutocompletePhoneNumberEntryError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline AutocompletePhoneNumberEntryError::AutocompletePhoneNumberEntryErrorField getField () const;

    inline void setField(AutocompletePhoneNumberEntryError::AutocompletePhoneNumberEntryErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "AutocompletePhoneNumberEntryErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "AutocompletePhoneNumberEntryErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const AutocompletePhoneNumberEntryErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline AutocompletePhoneNumberEntryErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline AutocompletePhoneNumberEntryErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (AutocompletePhoneNumberEntryErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "AutocompletePhoneNumberEntryErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const AutocompletePhoneNumberEntryErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const AutocompletePhoneNumberEntryError &getDefaultInstance();

private:

    inline void cloneData (const AutocompletePhoneNumberEntryError& rhs);

    inline void deleteData ();

    AutocompletePhoneNumberEntryErrorField __field;

    union {
        AutocompletePhoneNumberEntryErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The result message of the method "ClearPhoneBookData"
 * This function is called to clear out all contact and personal information from within the Phone Book as well as the Vehicle Phone Book identified by DeviceHandle = 1.  Upon receipt of the StartAck optype,the PhoneBook FBlock shall permanently delete all contact information from both temporary (e.g. DRAM) and permanent (Flash) memory.
 *
 * This function is used, for example, to delete all the phone book contacts when a vehicle is turned-in at the end of lease.
 */
class ClearPhoneBookDataResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ClearPhoneBookDataResult ();

    /**
     * Copy constructor
     */
    inline  ClearPhoneBookDataResult (const ClearPhoneBookDataResult &rhs);

    /**
     * All fields constructor
     */
    inline  ClearPhoneBookDataResult (bool bDummyResult_);

    /**
     * Destructor
     */
    inline virtual  ~ClearPhoneBookDataResult();

    /**
     * Assignment operator
     */
    inline ClearPhoneBookDataResult& operator = (const ClearPhoneBookDataResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ClearPhoneBookDataResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ClearPhoneBookDataResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ClearPhoneBookDataResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ClearPhoneBookDataResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bDummyResult"

    static const int kBDummyResult = 0;

    /**
     * Clears the field "bDummyResult".
     *
     * The field will be set to its default value. The hasBDummyResult()
     * method will return false.
     */
    inline void clearBDummyResult();

    /**
     * Checks whether the field "bDummyResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDummyResult()). Otherwise it will return false.
     */
    inline bool hasBDummyResult () const;

    /**
     * Returns the value of the member "bDummyResult".
     *
     * Dummy Method Result for ClearPhoneBookData.
     *
     * @return The value of the field "bDummyResult"
     */
    inline bool getBDummyResult () const;

    /**
     * Sets the value of the member "bDummyResult".
     *
     * Dummy Method Result for ClearPhoneBookData.
     *
     * @param bDummyResult The value which will be set
     */
    inline void setBDummyResult (bool bDummyResult_);

    static const ClearPhoneBookDataResult &getDefaultInstance();

private:

    inline void set_has_bDummyResult ();

    inline void clear_has_bDummyResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bDummyResult;

};

/**
 * The error message of 'ClearPhoneBookData'
 */
class ClearPhoneBookDataErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  ClearPhoneBookDataErrorStructure ();

    /**
     * Copy constructor
     */
    inline  ClearPhoneBookDataErrorStructure (const ClearPhoneBookDataErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  ClearPhoneBookDataErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~ClearPhoneBookDataErrorStructure();

    /**
     * Assignment operator
     */
    inline ClearPhoneBookDataErrorStructure& operator = (const ClearPhoneBookDataErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ClearPhoneBookDataErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ClearPhoneBookDataErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ClearPhoneBookDataErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ClearPhoneBookDataErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     *
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     *
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     *
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     *
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const ClearPhoneBookDataErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'ClearPhoneBookData'
 */
class ClearPhoneBookDataError  : public ::asf::core::Payload {
public:

    enum ClearPhoneBookDataErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  ClearPhoneBookDataError ();

   /**
     * Copy constructor
     */
    inline  ClearPhoneBookDataError (const ClearPhoneBookDataError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~ClearPhoneBookDataError();

    /**
     * Assigns a new value to this object.
     */
    inline ClearPhoneBookDataError& operator = (const ClearPhoneBookDataError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ClearPhoneBookDataError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ClearPhoneBookDataError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ClearPhoneBookDataError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ClearPhoneBookDataError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline ClearPhoneBookDataError::ClearPhoneBookDataErrorField getField () const;

    inline void setField(ClearPhoneBookDataError::ClearPhoneBookDataErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "ClearPhoneBookDataErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "ClearPhoneBookDataErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ClearPhoneBookDataErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ClearPhoneBookDataErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline ClearPhoneBookDataErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (ClearPhoneBookDataErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "ClearPhoneBookDataErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const ClearPhoneBookDataErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const ClearPhoneBookDataError &getDefaultInstance();

private:

    inline void cloneData (const ClearPhoneBookDataError& rhs);

    inline void deleteData ();

    ClearPhoneBookDataErrorField __field;

    union {
        ClearPhoneBookDataErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "RequestPhoneBookListSlice"
 * The RequestPhoneBookListSlice method provides a slice of the filtered list specified by the ListHandle parameter. The slice begins with the item at location WindowStart and includes in sequential order the number of items specified by the parameter WindowSize.
 *
 * The RequestPhoneBookListSlice method returns the slice as a PhoneBookList stream.  If the number of items in the list starting at WindowStart is less than the WindowSize parameter then the number of items provided in the slice will be less than the WindowSize calling parameter.
 */
class RequestPhoneBookListSliceStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestPhoneBookListSliceStart ();

    /**
     * Copy constructor
     */
    inline  RequestPhoneBookListSliceStart (const RequestPhoneBookListSliceStart &rhs);

    /**
     * All fields constructor
     */
    inline  RequestPhoneBookListSliceStart (uint16 u16ListHandle_, uint32 u32WindowStart_, uint16 u16WindowSize_);

    /**
     * Destructor
     */
    inline virtual  ~RequestPhoneBookListSliceStart();

    /**
     * Assignment operator
     */
    inline RequestPhoneBookListSliceStart& operator = (const RequestPhoneBookListSliceStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestPhoneBookListSliceStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestPhoneBookListSliceStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestPhoneBookListSliceStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestPhoneBookListSliceStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ListHandle"

    static const int kU16ListHandle = 0;

    /**
     * Clears the field "u16ListHandle".
     *
     * The field will be set to its default value. The hasU16ListHandle()
     * method will return false.
     */
    inline void clearU16ListHandle();

    /**
     * Checks whether the field "u16ListHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ListHandle()). Otherwise it will return false.
     */
    inline bool hasU16ListHandle () const;

    /**
     * Returns the value of the member "u16ListHandle".
     *
     * The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @return The value of the field "u16ListHandle"
     */
    inline uint16 getU16ListHandle () const;

    /**
     * Sets the value of the member "u16ListHandle".
     *
     * The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @param u16ListHandle The value which will be set
     */
    inline void setU16ListHandle (uint16 u16ListHandle_);

    // API of field "u32WindowStart"

    static const int kU32WindowStart = 1;

    /**
     * Clears the field "u32WindowStart".
     *
     * The field will be set to its default value. The hasU32WindowStart()
     * method will return false.
     */
    inline void clearU32WindowStart();

    /**
     * Checks whether the field "u32WindowStart" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32WindowStart()). Otherwise it will return false.
     */
    inline bool hasU32WindowStart () const;

    /**
     * Returns the value of the member "u32WindowStart".
     *
     * Specifies the start index of the required section inside the total list.
     *
     * @return The value of the field "u32WindowStart"
     */
    inline uint32 getU32WindowStart () const;

    /**
     * Sets the value of the member "u32WindowStart".
     *
     * Specifies the start index of the required section inside the total list.
     *
     * @param u32WindowStart The value which will be set
     */
    inline void setU32WindowStart (uint32 u32WindowStart_);

    // API of field "u16WindowSize"

    static const int kU16WindowSize = 2;

    /**
     * Clears the field "u16WindowSize".
     *
     * The field will be set to its default value. The hasU16WindowSize()
     * method will return false.
     */
    inline void clearU16WindowSize();

    /**
     * Checks whether the field "u16WindowSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16WindowSize()). Otherwise it will return false.
     */
    inline bool hasU16WindowSize () const;

    /**
     * Returns the value of the member "u16WindowSize".
     *
     * Specifies the size of the required section inside the total list.
     *
     * @return The value of the field "u16WindowSize"
     */
    inline uint16 getU16WindowSize () const;

    /**
     * Sets the value of the member "u16WindowSize".
     *
     * Specifies the size of the required section inside the total list.
     *
     * @param u16WindowSize The value which will be set
     */
    inline void setU16WindowSize (uint16 u16WindowSize_);

    static const RequestPhoneBookListSliceStart &getDefaultInstance();

private:

    inline void set_has_u16ListHandle ();

    inline void clear_has_u16ListHandle ();

    inline void set_has_u32WindowStart ();

    inline void clear_has_u32WindowStart ();

    inline void set_has_u16WindowSize ();

    inline void clear_has_u16WindowSize ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint16 _u16ListHandle;

    uint32 _u32WindowStart;

    uint16 _u16WindowSize;

};

/**
 * The result message of the method "RequestPhoneBookListSlice"
 * The RequestPhoneBookListSlice method provides a slice of the filtered list specified by the ListHandle parameter. The slice begins with the item at location WindowStart and includes in sequential order the number of items specified by the parameter WindowSize.
 *
 * The RequestPhoneBookListSlice method returns the slice as a PhoneBookList stream.  If the number of items in the list starting at WindowStart is less than the WindowSize parameter then the number of items provided in the slice will be less than the WindowSize calling parameter.
 */
class RequestPhoneBookListSliceResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestPhoneBookListSliceResult ();

    /**
     * Copy constructor
     */
    inline  RequestPhoneBookListSliceResult (const RequestPhoneBookListSliceResult &rhs);

    /**
     * All fields constructor
     */
    inline  RequestPhoneBookListSliceResult (const ::most_PhonBk_fi_types::T_PhonBkPhoneBookListSliceResult& oPhoneBookListSliceResult_);

    /**
     * Destructor
     */
    inline virtual  ~RequestPhoneBookListSliceResult();

    /**
     * Assignment operator
     */
    inline RequestPhoneBookListSliceResult& operator = (const RequestPhoneBookListSliceResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestPhoneBookListSliceResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestPhoneBookListSliceResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestPhoneBookListSliceResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestPhoneBookListSliceResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oPhoneBookListSliceResult"

    static const int kOPhoneBookListSliceResult = 0;

    /**
     * Clears the field "oPhoneBookListSliceResult".
     *
     * The field will be set to its default value. The hasOPhoneBookListSliceResult()
     * method will return false.
     */
    inline void clearOPhoneBookListSliceResult();

    /**
     * Checks whether the field "oPhoneBookListSliceResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOPhoneBookListSliceResult()). Otherwise it will return false.
     */
    inline bool hasOPhoneBookListSliceResult () const;

    /**
     * Returns the value of the member "oPhoneBookListSliceResult".
     *
     * Provides the contact information required in the contact list view for each contact.
     *
     * @return The value of the field "oPhoneBookListSliceResult"
     */
    inline const ::most_PhonBk_fi_types::T_PhonBkPhoneBookListSliceResult& getOPhoneBookListSliceResult () const;

    /**
     * Retrieves the value of the field "oPhoneBookListSliceResult" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oPhoneBookListSliceResult".
     */
    inline ::most_PhonBk_fi_types::T_PhonBkPhoneBookListSliceResult& getOPhoneBookListSliceResultMutable ();

    /**
     * Sets the value of the member "oPhoneBookListSliceResult".
     *
     * Provides the contact information required in the contact list view for each contact.
     *
     * @param oPhoneBookListSliceResult The value which will be set
     */
    inline void setOPhoneBookListSliceResult (const ::most_PhonBk_fi_types::T_PhonBkPhoneBookListSliceResult& oPhoneBookListSliceResult_);

    static const RequestPhoneBookListSliceResult &getDefaultInstance();

private:

    static const ::std::vector< ::most_PhonBk_fi_types::T_PhonBkPhoneBookListSliceResultItem >& getT_PhonBkPhoneBookListSliceResultItemList_DefaultInstance ();

    inline void set_has_oPhoneBookListSliceResult ();

    inline void clear_has_oPhoneBookListSliceResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_PhonBk_fi_types::T_PhonBkPhoneBookListSliceResult _oPhoneBookListSliceResult;

};

/**
 * The error message of 'RequestPhoneBookListSlice'
 */
class RequestPhoneBookListSliceErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  RequestPhoneBookListSliceErrorStructure ();

    /**
     * Copy constructor
     */
    inline  RequestPhoneBookListSliceErrorStructure (const RequestPhoneBookListSliceErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  RequestPhoneBookListSliceErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~RequestPhoneBookListSliceErrorStructure();

    /**
     * Assignment operator
     */
    inline RequestPhoneBookListSliceErrorStructure& operator = (const RequestPhoneBookListSliceErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestPhoneBookListSliceErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestPhoneBookListSliceErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestPhoneBookListSliceErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestPhoneBookListSliceErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     *
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     *
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     *
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     *
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const RequestPhoneBookListSliceErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'RequestPhoneBookListSlice'
 */
class RequestPhoneBookListSliceError  : public ::asf::core::Payload {
public:

    enum RequestPhoneBookListSliceErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  RequestPhoneBookListSliceError ();

   /**
     * Copy constructor
     */
    inline  RequestPhoneBookListSliceError (const RequestPhoneBookListSliceError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~RequestPhoneBookListSliceError();

    /**
     * Assigns a new value to this object.
     */
    inline RequestPhoneBookListSliceError& operator = (const RequestPhoneBookListSliceError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestPhoneBookListSliceError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestPhoneBookListSliceError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestPhoneBookListSliceError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestPhoneBookListSliceError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline RequestPhoneBookListSliceError::RequestPhoneBookListSliceErrorField getField () const;

    inline void setField(RequestPhoneBookListSliceError::RequestPhoneBookListSliceErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "RequestPhoneBookListSliceErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "RequestPhoneBookListSliceErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const RequestPhoneBookListSliceErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline RequestPhoneBookListSliceErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline RequestPhoneBookListSliceErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (RequestPhoneBookListSliceErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "RequestPhoneBookListSliceErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const RequestPhoneBookListSliceErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const RequestPhoneBookListSliceError &getDefaultInstance();

private:

    inline void cloneData (const RequestPhoneBookListSliceError& rhs);

    inline void deleteData ();

    RequestPhoneBookListSliceErrorField __field;

    union {
        RequestPhoneBookListSliceErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The result message of the method "ClearVehiclePhoneBook"
 * This Method deletes all information from the vehicle phone book
 * (DeviceHandle=1). Upon receipt of the StartAck optype, the FBlock shall
 * delete all entries within the phone and notify all controllers that have
 * created lists on the vehicle phone book via the ListChange property.Note
 * that this function is different from the ClearPhoneBookData method in that
 * only the vehicle phone book is cleared. ClearPhoneBookData clears BOTH the
 * vehicle phone book and all of the customer device phone book information.
 */
class ClearVehiclePhoneBookResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ClearVehiclePhoneBookResult ();

    /**
     * Copy constructor
     */
    inline  ClearVehiclePhoneBookResult (const ClearVehiclePhoneBookResult &rhs);

    /**
     * All fields constructor
     */
    inline  ClearVehiclePhoneBookResult (bool bDummyResult_);

    /**
     * Destructor
     */
    inline virtual  ~ClearVehiclePhoneBookResult();

    /**
     * Assignment operator
     */
    inline ClearVehiclePhoneBookResult& operator = (const ClearVehiclePhoneBookResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ClearVehiclePhoneBookResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ClearVehiclePhoneBookResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ClearVehiclePhoneBookResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ClearVehiclePhoneBookResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bDummyResult"

    static const int kBDummyResult = 0;

    /**
     * Clears the field "bDummyResult".
     *
     * The field will be set to its default value. The hasBDummyResult()
     * method will return false.
     */
    inline void clearBDummyResult();

    /**
     * Checks whether the field "bDummyResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDummyResult()). Otherwise it will return false.
     */
    inline bool hasBDummyResult () const;

    /**
     * Returns the value of the member "bDummyResult".
     *
     * Dummy Method Result for ClearVehiclePhoneBook.
     *
     * @return The value of the field "bDummyResult"
     */
    inline bool getBDummyResult () const;

    /**
     * Sets the value of the member "bDummyResult".
     *
     * Dummy Method Result for ClearVehiclePhoneBook.
     *
     * @param bDummyResult The value which will be set
     */
    inline void setBDummyResult (bool bDummyResult_);

    static const ClearVehiclePhoneBookResult &getDefaultInstance();

private:

    inline void set_has_bDummyResult ();

    inline void clear_has_bDummyResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bDummyResult;

};

/**
 * The error message of 'ClearVehiclePhoneBook'
 */
class ClearVehiclePhoneBookErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  ClearVehiclePhoneBookErrorStructure ();

    /**
     * Copy constructor
     */
    inline  ClearVehiclePhoneBookErrorStructure (const ClearVehiclePhoneBookErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  ClearVehiclePhoneBookErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~ClearVehiclePhoneBookErrorStructure();

    /**
     * Assignment operator
     */
    inline ClearVehiclePhoneBookErrorStructure& operator = (const ClearVehiclePhoneBookErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ClearVehiclePhoneBookErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ClearVehiclePhoneBookErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ClearVehiclePhoneBookErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ClearVehiclePhoneBookErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     *
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     *
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     *
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     *
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const ClearVehiclePhoneBookErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'ClearVehiclePhoneBook'
 */
class ClearVehiclePhoneBookError  : public ::asf::core::Payload {
public:

    enum ClearVehiclePhoneBookErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  ClearVehiclePhoneBookError ();

   /**
     * Copy constructor
     */
    inline  ClearVehiclePhoneBookError (const ClearVehiclePhoneBookError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~ClearVehiclePhoneBookError();

    /**
     * Assigns a new value to this object.
     */
    inline ClearVehiclePhoneBookError& operator = (const ClearVehiclePhoneBookError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ClearVehiclePhoneBookError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ClearVehiclePhoneBookError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ClearVehiclePhoneBookError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ClearVehiclePhoneBookError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline ClearVehiclePhoneBookError::ClearVehiclePhoneBookErrorField getField () const;

    inline void setField(ClearVehiclePhoneBookError::ClearVehiclePhoneBookErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "ClearVehiclePhoneBookErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "ClearVehiclePhoneBookErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ClearVehiclePhoneBookErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ClearVehiclePhoneBookErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline ClearVehiclePhoneBookErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (ClearVehiclePhoneBookErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "ClearVehiclePhoneBookErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const ClearVehiclePhoneBookErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const ClearVehiclePhoneBookError &getDefaultInstance();

private:

    inline void cloneData (const ClearVehiclePhoneBookError& rhs);

    inline void deleteData ();

    ClearVehiclePhoneBookErrorField __field;

    union {
        ClearVehiclePhoneBookErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "RequestSliceCallHistoryListExtended"
 * The RequestSliceCallHistoryList method provides a slice of the sorted call history list type specified by the ListHandle parameter. The slice begins with the item at location WindowStart and includes in sequential order the number of items specified by the parameter WindowSize.  The RequestSliceCallHistoryList method returns the slice as a CallHistoryList stream.  If the number of items in the list starting at WindowStart is less than the WindowSize parameter then the number of items provided in the slice will be less than the WindowSize calling parameter.
 */
class RequestSliceCallHistoryListExtendedStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestSliceCallHistoryListExtendedStart ();

    /**
     * Copy constructor
     */
    inline  RequestSliceCallHistoryListExtendedStart (const RequestSliceCallHistoryListExtendedStart &rhs);

    /**
     * All fields constructor
     */
    inline  RequestSliceCallHistoryListExtendedStart (uint16 u16ListHandle_, uint32 u32WindowStart_, uint16 u16WindowSize_);

    /**
     * Destructor
     */
    inline virtual  ~RequestSliceCallHistoryListExtendedStart();

    /**
     * Assignment operator
     */
    inline RequestSliceCallHistoryListExtendedStart& operator = (const RequestSliceCallHistoryListExtendedStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestSliceCallHistoryListExtendedStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestSliceCallHistoryListExtendedStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestSliceCallHistoryListExtendedStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestSliceCallHistoryListExtendedStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ListHandle"

    static const int kU16ListHandle = 0;

    /**
     * Clears the field "u16ListHandle".
     *
     * The field will be set to its default value. The hasU16ListHandle()
     * method will return false.
     */
    inline void clearU16ListHandle();

    /**
     * Checks whether the field "u16ListHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ListHandle()). Otherwise it will return false.
     */
    inline bool hasU16ListHandle () const;

    /**
     * Returns the value of the member "u16ListHandle".
     *
     * The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @return The value of the field "u16ListHandle"
     */
    inline uint16 getU16ListHandle () const;

    /**
     * Sets the value of the member "u16ListHandle".
     *
     * The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @param u16ListHandle The value which will be set
     */
    inline void setU16ListHandle (uint16 u16ListHandle_);

    // API of field "u32WindowStart"

    static const int kU32WindowStart = 1;

    /**
     * Clears the field "u32WindowStart".
     *
     * The field will be set to its default value. The hasU32WindowStart()
     * method will return false.
     */
    inline void clearU32WindowStart();

    /**
     * Checks whether the field "u32WindowStart" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32WindowStart()). Otherwise it will return false.
     */
    inline bool hasU32WindowStart () const;

    /**
     * Returns the value of the member "u32WindowStart".
     *
     * Specifies the start index of the required section inside the total list.
     *
     * @return The value of the field "u32WindowStart"
     */
    inline uint32 getU32WindowStart () const;

    /**
     * Sets the value of the member "u32WindowStart".
     *
     * Specifies the start index of the required section inside the total list.
     *
     * @param u32WindowStart The value which will be set
     */
    inline void setU32WindowStart (uint32 u32WindowStart_);

    // API of field "u16WindowSize"

    static const int kU16WindowSize = 2;

    /**
     * Clears the field "u16WindowSize".
     *
     * The field will be set to its default value. The hasU16WindowSize()
     * method will return false.
     */
    inline void clearU16WindowSize();

    /**
     * Checks whether the field "u16WindowSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16WindowSize()). Otherwise it will return false.
     */
    inline bool hasU16WindowSize () const;

    /**
     * Returns the value of the member "u16WindowSize".
     *
     * Specifies the size of the required section inside the total list.
     *
     * @return The value of the field "u16WindowSize"
     */
    inline uint16 getU16WindowSize () const;

    /**
     * Sets the value of the member "u16WindowSize".
     *
     * Specifies the size of the required section inside the total list.
     *
     * @param u16WindowSize The value which will be set
     */
    inline void setU16WindowSize (uint16 u16WindowSize_);

    static const RequestSliceCallHistoryListExtendedStart &getDefaultInstance();

private:

    inline void set_has_u16ListHandle ();

    inline void clear_has_u16ListHandle ();

    inline void set_has_u32WindowStart ();

    inline void clear_has_u32WindowStart ();

    inline void set_has_u16WindowSize ();

    inline void clear_has_u16WindowSize ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint16 _u16ListHandle;

    uint32 _u32WindowStart;

    uint16 _u16WindowSize;

};

/**
 * The result message of the method "RequestSliceCallHistoryListExtended"
 * The RequestSliceCallHistoryList method provides a slice of the sorted call history list type specified by the ListHandle parameter. The slice begins with the item at location WindowStart and includes in sequential order the number of items specified by the parameter WindowSize.  The RequestSliceCallHistoryList method returns the slice as a CallHistoryList stream.  If the number of items in the list starting at WindowStart is less than the WindowSize parameter then the number of items provided in the slice will be less than the WindowSize calling parameter.
 */
class RequestSliceCallHistoryListExtendedResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestSliceCallHistoryListExtendedResult ();

    /**
     * Copy constructor
     */
    inline  RequestSliceCallHistoryListExtendedResult (const RequestSliceCallHistoryListExtendedResult &rhs);

    /**
     * All fields constructor
     */
    inline  RequestSliceCallHistoryListExtendedResult (const ::most_PhonBk_fi_types_Extended::T_PhonBkCallHistoryListSliceResultExtened& oCallHistoryListSliceResultExtended_);

    /**
     * Destructor
     */
    inline virtual  ~RequestSliceCallHistoryListExtendedResult();

    /**
     * Assignment operator
     */
    inline RequestSliceCallHistoryListExtendedResult& operator = (const RequestSliceCallHistoryListExtendedResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestSliceCallHistoryListExtendedResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestSliceCallHistoryListExtendedResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestSliceCallHistoryListExtendedResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestSliceCallHistoryListExtendedResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oCallHistoryListSliceResultExtended"

    static const int kOCallHistoryListSliceResultExtended = 0;

    /**
     * Clears the field "oCallHistoryListSliceResultExtended".
     *
     * The field will be set to its default value. The hasOCallHistoryListSliceResultExtended()
     * method will return false.
     */
    inline void clearOCallHistoryListSliceResultExtended();

    /**
     * Checks whether the field "oCallHistoryListSliceResultExtended" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOCallHistoryListSliceResultExtended()). Otherwise it will return false.
     */
    inline bool hasOCallHistoryListSliceResultExtended () const;

    /**
     * Returns the value of the member "oCallHistoryListSliceResultExtended".
     *
     *
     *
     * @return The value of the field "oCallHistoryListSliceResultExtended"
     */
    inline const ::most_PhonBk_fi_types_Extended::T_PhonBkCallHistoryListSliceResultExtened& getOCallHistoryListSliceResultExtended () const;

    /**
     * Retrieves the value of the field "oCallHistoryListSliceResultExtended" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oCallHistoryListSliceResultExtended".
     */
    inline ::most_PhonBk_fi_types_Extended::T_PhonBkCallHistoryListSliceResultExtened& getOCallHistoryListSliceResultExtendedMutable ();

    /**
     * Sets the value of the member "oCallHistoryListSliceResultExtended".
     *
     *
     *
     * @param oCallHistoryListSliceResultExtended The value which will be set
     */
    inline void setOCallHistoryListSliceResultExtended (const ::most_PhonBk_fi_types_Extended::T_PhonBkCallHistoryListSliceResultExtened& oCallHistoryListSliceResultExtended_);

    static const RequestSliceCallHistoryListExtendedResult &getDefaultInstance();

private:

    static const ::std::vector< ::most_PhonBk_fi_types_Extended::T_PhonBkCallHistoryListSliceResultExtenedItem >& getT_PhonBkCallHistoryListSliceResultExtenedItemList_DefaultInstance ();

    inline void set_has_oCallHistoryListSliceResultExtended ();

    inline void clear_has_oCallHistoryListSliceResultExtended ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_PhonBk_fi_types_Extended::T_PhonBkCallHistoryListSliceResultExtened _oCallHistoryListSliceResultExtended;

};

/**
 * The error message of 'RequestSliceCallHistoryListExtended'
 */
class RequestSliceCallHistoryListExtendedErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  RequestSliceCallHistoryListExtendedErrorStructure ();

    /**
     * Copy constructor
     */
    inline  RequestSliceCallHistoryListExtendedErrorStructure (const RequestSliceCallHistoryListExtendedErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  RequestSliceCallHistoryListExtendedErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~RequestSliceCallHistoryListExtendedErrorStructure();

    /**
     * Assignment operator
     */
    inline RequestSliceCallHistoryListExtendedErrorStructure& operator = (const RequestSliceCallHistoryListExtendedErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestSliceCallHistoryListExtendedErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestSliceCallHistoryListExtendedErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestSliceCallHistoryListExtendedErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestSliceCallHistoryListExtendedErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     *
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     *
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     *
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     *
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const RequestSliceCallHistoryListExtendedErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'RequestSliceCallHistoryListExtended'
 */
class RequestSliceCallHistoryListExtendedError  : public ::asf::core::Payload {
public:

    enum RequestSliceCallHistoryListExtendedErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  RequestSliceCallHistoryListExtendedError ();

   /**
     * Copy constructor
     */
    inline  RequestSliceCallHistoryListExtendedError (const RequestSliceCallHistoryListExtendedError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~RequestSliceCallHistoryListExtendedError();

    /**
     * Assigns a new value to this object.
     */
    inline RequestSliceCallHistoryListExtendedError& operator = (const RequestSliceCallHistoryListExtendedError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestSliceCallHistoryListExtendedError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestSliceCallHistoryListExtendedError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestSliceCallHistoryListExtendedError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestSliceCallHistoryListExtendedError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline RequestSliceCallHistoryListExtendedError::RequestSliceCallHistoryListExtendedErrorField getField () const;

    inline void setField(RequestSliceCallHistoryListExtendedError::RequestSliceCallHistoryListExtendedErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "RequestSliceCallHistoryListExtendedErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "RequestSliceCallHistoryListExtendedErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const RequestSliceCallHistoryListExtendedErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline RequestSliceCallHistoryListExtendedErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline RequestSliceCallHistoryListExtendedErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (RequestSliceCallHistoryListExtendedErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "RequestSliceCallHistoryListExtendedErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const RequestSliceCallHistoryListExtendedErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const RequestSliceCallHistoryListExtendedError &getDefaultInstance();

private:

    inline void cloneData (const RequestSliceCallHistoryListExtendedError& rhs);

    inline void deleteData ();

    RequestSliceCallHistoryListExtendedErrorField __field;

    union {
        RequestSliceCallHistoryListExtendedErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "RequestPhoneBookListSliceExtended"
 * The RequestPhoneBookListSlice method provides a slice of the filtered list specified by the ListHandle parameter. The slice begins with the item at location WindowStart and includes in sequential order the number of items specified by the parameter WindowSize.
 * The RequestPhoneBookListSlice method returns the slice as a PhoneBookList stream.  If the number of items in the list starting at WindowStart is less than the WindowSize parameter then the number of items provided in the slice will be less than the WindowSize calling parameter.
 */
class RequestPhoneBookListSliceExtendedStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestPhoneBookListSliceExtendedStart ();

    /**
     * Copy constructor
     */
    inline  RequestPhoneBookListSliceExtendedStart (const RequestPhoneBookListSliceExtendedStart &rhs);

    /**
     * All fields constructor
     */
    inline  RequestPhoneBookListSliceExtendedStart (uint16 u16ListHandle_, uint32 u32WindowStart_, uint16 u16WindowSize_);

    /**
     * Destructor
     */
    inline virtual  ~RequestPhoneBookListSliceExtendedStart();

    /**
     * Assignment operator
     */
    inline RequestPhoneBookListSliceExtendedStart& operator = (const RequestPhoneBookListSliceExtendedStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestPhoneBookListSliceExtendedStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestPhoneBookListSliceExtendedStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestPhoneBookListSliceExtendedStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestPhoneBookListSliceExtendedStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ListHandle"

    static const int kU16ListHandle = 0;

    /**
     * Clears the field "u16ListHandle".
     *
     * The field will be set to its default value. The hasU16ListHandle()
     * method will return false.
     */
    inline void clearU16ListHandle();

    /**
     * Checks whether the field "u16ListHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ListHandle()). Otherwise it will return false.
     */
    inline bool hasU16ListHandle () const;

    /**
     * Returns the value of the member "u16ListHandle".
     *
     * The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @return The value of the field "u16ListHandle"
     */
    inline uint16 getU16ListHandle () const;

    /**
     * Sets the value of the member "u16ListHandle".
     *
     * The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @param u16ListHandle The value which will be set
     */
    inline void setU16ListHandle (uint16 u16ListHandle_);

    // API of field "u32WindowStart"

    static const int kU32WindowStart = 1;

    /**
     * Clears the field "u32WindowStart".
     *
     * The field will be set to its default value. The hasU32WindowStart()
     * method will return false.
     */
    inline void clearU32WindowStart();

    /**
     * Checks whether the field "u32WindowStart" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32WindowStart()). Otherwise it will return false.
     */
    inline bool hasU32WindowStart () const;

    /**
     * Returns the value of the member "u32WindowStart".
     *
     * Specifies the start index of the required section inside the total list.
     *
     * @return The value of the field "u32WindowStart"
     */
    inline uint32 getU32WindowStart () const;

    /**
     * Sets the value of the member "u32WindowStart".
     *
     * Specifies the start index of the required section inside the total list.
     *
     * @param u32WindowStart The value which will be set
     */
    inline void setU32WindowStart (uint32 u32WindowStart_);

    // API of field "u16WindowSize"

    static const int kU16WindowSize = 2;

    /**
     * Clears the field "u16WindowSize".
     *
     * The field will be set to its default value. The hasU16WindowSize()
     * method will return false.
     */
    inline void clearU16WindowSize();

    /**
     * Checks whether the field "u16WindowSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16WindowSize()). Otherwise it will return false.
     */
    inline bool hasU16WindowSize () const;

    /**
     * Returns the value of the member "u16WindowSize".
     *
     * Specifies the size of the required section inside the total list.
     *
     * @return The value of the field "u16WindowSize"
     */
    inline uint16 getU16WindowSize () const;

    /**
     * Sets the value of the member "u16WindowSize".
     *
     * Specifies the size of the required section inside the total list.
     *
     * @param u16WindowSize The value which will be set
     */
    inline void setU16WindowSize (uint16 u16WindowSize_);

    static const RequestPhoneBookListSliceExtendedStart &getDefaultInstance();

private:

    inline void set_has_u16ListHandle ();

    inline void clear_has_u16ListHandle ();

    inline void set_has_u32WindowStart ();

    inline void clear_has_u32WindowStart ();

    inline void set_has_u16WindowSize ();

    inline void clear_has_u16WindowSize ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint16 _u16ListHandle;

    uint32 _u32WindowStart;

    uint16 _u16WindowSize;

};

/**
 * The result message of the method "RequestPhoneBookListSliceExtended"
 * The RequestPhoneBookListSlice method provides a slice of the filtered list specified by the ListHandle parameter. The slice begins with the item at location WindowStart and includes in sequential order the number of items specified by the parameter WindowSize.
 * The RequestPhoneBookListSlice method returns the slice as a PhoneBookList stream.  If the number of items in the list starting at WindowStart is less than the WindowSize parameter then the number of items provided in the slice will be less than the WindowSize calling parameter.
 */
class RequestPhoneBookListSliceExtendedResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestPhoneBookListSliceExtendedResult ();

    /**
     * Copy constructor
     */
    inline  RequestPhoneBookListSliceExtendedResult (const RequestPhoneBookListSliceExtendedResult &rhs);

    /**
     * All fields constructor
     */
    inline  RequestPhoneBookListSliceExtendedResult (uint16 u16ListHandle_, const ::most_PhonBk_fi_types_Extended::T_PhonBkPhoneBookListSliceResultExtended& oPhoneBookListSliceResultExtended_);

    /**
     * Destructor
     */
    inline virtual  ~RequestPhoneBookListSliceExtendedResult();

    /**
     * Assignment operator
     */
    inline RequestPhoneBookListSliceExtendedResult& operator = (const RequestPhoneBookListSliceExtendedResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestPhoneBookListSliceExtendedResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestPhoneBookListSliceExtendedResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestPhoneBookListSliceExtendedResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestPhoneBookListSliceExtendedResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ListHandle"

    static const int kU16ListHandle = 0;

    /**
     * Clears the field "u16ListHandle".
     *
     * The field will be set to its default value. The hasU16ListHandle()
     * method will return false.
     */
    inline void clearU16ListHandle();

    /**
     * Checks whether the field "u16ListHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ListHandle()). Otherwise it will return false.
     */
    inline bool hasU16ListHandle () const;

    /**
     * Returns the value of the member "u16ListHandle".
     *
     * The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @return The value of the field "u16ListHandle"
     */
    inline uint16 getU16ListHandle () const;

    /**
     * Sets the value of the member "u16ListHandle".
     *
     * The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @param u16ListHandle The value which will be set
     */
    inline void setU16ListHandle (uint16 u16ListHandle_);

    // API of field "oPhoneBookListSliceResultExtended"

    static const int kOPhoneBookListSliceResultExtended = 1;

    /**
     * Clears the field "oPhoneBookListSliceResultExtended".
     *
     * The field will be set to its default value. The hasOPhoneBookListSliceResultExtended()
     * method will return false.
     */
    inline void clearOPhoneBookListSliceResultExtended();

    /**
     * Checks whether the field "oPhoneBookListSliceResultExtended" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOPhoneBookListSliceResultExtended()). Otherwise it will return false.
     */
    inline bool hasOPhoneBookListSliceResultExtended () const;

    /**
     * Returns the value of the member "oPhoneBookListSliceResultExtended".
     *
     * Provides the contact information required in the contact list view for each contact.
     *
     * @return The value of the field "oPhoneBookListSliceResultExtended"
     */
    inline const ::most_PhonBk_fi_types_Extended::T_PhonBkPhoneBookListSliceResultExtended& getOPhoneBookListSliceResultExtended () const;

    /**
     * Retrieves the value of the field "oPhoneBookListSliceResultExtended" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oPhoneBookListSliceResultExtended".
     */
    inline ::most_PhonBk_fi_types_Extended::T_PhonBkPhoneBookListSliceResultExtended& getOPhoneBookListSliceResultExtendedMutable ();

    /**
     * Sets the value of the member "oPhoneBookListSliceResultExtended".
     *
     * Provides the contact information required in the contact list view for each contact.
     *
     * @param oPhoneBookListSliceResultExtended The value which will be set
     */
    inline void setOPhoneBookListSliceResultExtended (const ::most_PhonBk_fi_types_Extended::T_PhonBkPhoneBookListSliceResultExtended& oPhoneBookListSliceResultExtended_);

    static const RequestPhoneBookListSliceExtendedResult &getDefaultInstance();

private:

    static const ::std::vector< ::most_PhonBk_fi_types_Extended::T_PhonBkPhoneBookListSliceResultExtendedItem >& getT_PhonBkPhoneBookListSliceResultExtendedItemList_DefaultInstance ();

    inline void set_has_u16ListHandle ();

    inline void clear_has_u16ListHandle ();

    inline void set_has_oPhoneBookListSliceResultExtended ();

    inline void clear_has_oPhoneBookListSliceResultExtended ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _u16ListHandle;

    ::most_PhonBk_fi_types_Extended::T_PhonBkPhoneBookListSliceResultExtended _oPhoneBookListSliceResultExtended;

};

/**
 * The error message of 'RequestPhoneBookListSliceExtended'
 */
class RequestPhoneBookListSliceExtendedErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  RequestPhoneBookListSliceExtendedErrorStructure ();

    /**
     * Copy constructor
     */
    inline  RequestPhoneBookListSliceExtendedErrorStructure (const RequestPhoneBookListSliceExtendedErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  RequestPhoneBookListSliceExtendedErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~RequestPhoneBookListSliceExtendedErrorStructure();

    /**
     * Assignment operator
     */
    inline RequestPhoneBookListSliceExtendedErrorStructure& operator = (const RequestPhoneBookListSliceExtendedErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestPhoneBookListSliceExtendedErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestPhoneBookListSliceExtendedErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestPhoneBookListSliceExtendedErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestPhoneBookListSliceExtendedErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     *
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     *
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     *
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     *
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const RequestPhoneBookListSliceExtendedErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'RequestPhoneBookListSliceExtended'
 */
class RequestPhoneBookListSliceExtendedError  : public ::asf::core::Payload {
public:

    enum RequestPhoneBookListSliceExtendedErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  RequestPhoneBookListSliceExtendedError ();

   /**
     * Copy constructor
     */
    inline  RequestPhoneBookListSliceExtendedError (const RequestPhoneBookListSliceExtendedError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~RequestPhoneBookListSliceExtendedError();

    /**
     * Assigns a new value to this object.
     */
    inline RequestPhoneBookListSliceExtendedError& operator = (const RequestPhoneBookListSliceExtendedError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestPhoneBookListSliceExtendedError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestPhoneBookListSliceExtendedError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestPhoneBookListSliceExtendedError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestPhoneBookListSliceExtendedError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline RequestPhoneBookListSliceExtendedError::RequestPhoneBookListSliceExtendedErrorField getField () const;

    inline void setField(RequestPhoneBookListSliceExtendedError::RequestPhoneBookListSliceExtendedErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "RequestPhoneBookListSliceExtendedErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "RequestPhoneBookListSliceExtendedErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const RequestPhoneBookListSliceExtendedErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline RequestPhoneBookListSliceExtendedErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline RequestPhoneBookListSliceExtendedErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (RequestPhoneBookListSliceExtendedErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "RequestPhoneBookListSliceExtendedErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const RequestPhoneBookListSliceExtendedErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const RequestPhoneBookListSliceExtendedError &getDefaultInstance();

private:

    inline void cloneData (const RequestPhoneBookListSliceExtendedError& rhs);

    inline void deleteData ();

    RequestPhoneBookListSliceExtendedErrorField __field;

    union {
        RequestPhoneBookListSliceExtendedErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SearchContacts"
 * This method searches the contacts containing the given SearchString. The search can be configured as:
 * a. The search can be executed in one or more device lists (For instance Vehicle Contacts and Contacts of a connected phone device)
 * b. The fields(e.g. FirstName, LastName, Phone Number) in which search is done are selectable via a bit field FieldSelector
 * c. The search will be stopped when a number, of already found matches, has reached the given value of MaximumReportedMatches
 */
class SearchContactsStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SearchContactsStart ();

    /**
     * Copy constructor
     */
    inline  SearchContactsStart (const SearchContactsStart &rhs);

    /**
     * All fields constructor
     */
    inline  SearchContactsStart (const ::most_PhonBk_fi_types_Extended::T_PhonBkDeviceHandleList& oDeviceHandleList_, uint16 u16FieldSelector_, const ::fi_basetypes_most::T_String& sSearchString_, ::most_PhonBk_fi_types_Extended::T_e8_PhonBkSearchSortType e8SearchSortType_, uint16 u16MaxReportedMatches_);

    /**
     * Destructor
     */
    inline virtual  ~SearchContactsStart();

    /**
     * Assignment operator
     */
    inline SearchContactsStart& operator = (const SearchContactsStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SearchContactsStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SearchContactsStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SearchContactsStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SearchContactsStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oDeviceHandleList"

    static const int kODeviceHandleList = 0;

    /**
     * Clears the field "oDeviceHandleList".
     *
     * The field will be set to its default value. The hasODeviceHandleList()
     * method will return false.
     */
    inline void clearODeviceHandleList();

    /**
     * Checks whether the field "oDeviceHandleList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setODeviceHandleList()). Otherwise it will return false.
     */
    inline bool hasODeviceHandleList () const;

    /**
     * Returns the value of the member "oDeviceHandleList".
     *
     * The DeviceHandleList parameter contains 1 or more DeviceHandle. The list needs to contain 1 DeviceHandle at minimum, thereby allowing search across several device lists in parallel. The order of a DeviceHandle in this list defines the priority for searching, e.g. [1, 2] would define to search in Vehicle-Contacts (DeviceHandle= 1) with first priority and in the Contact data of the phone device with handle 2 with second priority.
     *
     * @return The value of the field "oDeviceHandleList"
     */
    inline const ::most_PhonBk_fi_types_Extended::T_PhonBkDeviceHandleList& getODeviceHandleList () const;

    /**
     * Retrieves the value of the field "oDeviceHandleList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oDeviceHandleList".
     */
    inline ::most_PhonBk_fi_types_Extended::T_PhonBkDeviceHandleList& getODeviceHandleListMutable ();

    /**
     * Sets the value of the member "oDeviceHandleList".
     *
     * The DeviceHandleList parameter contains 1 or more DeviceHandle. The list needs to contain 1 DeviceHandle at minimum, thereby allowing search across several device lists in parallel. The order of a DeviceHandle in this list defines the priority for searching, e.g. [1, 2] would define to search in Vehicle-Contacts (DeviceHandle= 1) with first priority and in the Contact data of the phone device with handle 2 with second priority.
     *
     * @param oDeviceHandleList The value which will be set
     */
    inline void setODeviceHandleList (const ::most_PhonBk_fi_types_Extended::T_PhonBkDeviceHandleList& oDeviceHandleList_);

    // API of field "u16FieldSelector"

    static const int kU16FieldSelector = 1;

    /**
     * Clears the field "u16FieldSelector".
     *
     * The field will be set to its default value. The hasU16FieldSelector()
     * method will return false.
     */
    inline void clearU16FieldSelector();

    /**
     * Checks whether the field "u16FieldSelector" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16FieldSelector()). Otherwise it will return false.
     */
    inline bool hasU16FieldSelector () const;

    /**
     * Returns the value of the member "u16FieldSelector".
     *
     * The field selector defines the fields where search has to be done. Based on the bit set search will be performed in the corresponding field.
     * PB_FieldSelector_FirstName  = 0x0001
     * PB_FieldSelector_LastName   = 0x0002
     * PB_FieldSelector_PoiName    = 0x0004
     * PB_FieldSelector_Address    = 0x0008 (any of the address columns)
     * PB_FieldSelector_Email      = 0x0010 (any of the E-Mail columns)
     * PB_FieldSelector_Number     = 0x0020 (any of phone number columns)
     *
     * @return The value of the field "u16FieldSelector"
     */
    inline uint16 getU16FieldSelector () const;

    /**
     * Sets the value of the member "u16FieldSelector".
     *
     * The field selector defines the fields where search has to be done. Based on the bit set search will be performed in the corresponding field.
     * PB_FieldSelector_FirstName  = 0x0001
     * PB_FieldSelector_LastName   = 0x0002
     * PB_FieldSelector_PoiName    = 0x0004
     * PB_FieldSelector_Address    = 0x0008 (any of the address columns)
     * PB_FieldSelector_Email      = 0x0010 (any of the E-Mail columns)
     * PB_FieldSelector_Number     = 0x0020 (any of phone number columns)
     *
     * @param u16FieldSelector The value which will be set
     */
    inline void setU16FieldSelector (uint16 u16FieldSelector_);

    // API of field "sSearchString"

    static const int kSSearchString = 2;

    /**
     * Clears the field "sSearchString".
     *
     * The field will be set to its default value. The hasSSearchString()
     * method will return false.
     */
    inline void clearSSearchString();

    /**
     * Checks whether the field "sSearchString" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSSearchString()). Otherwise it will return false.
     */
    inline bool hasSSearchString () const;

    /**
     * Returns the value of the member "sSearchString".
     *
     * The SearchString defines the search terms to be searched for. Maximum number of characters: 100.
     *
     * @return The value of the field "sSearchString"
     */
    inline const ::fi_basetypes_most::T_String& getSSearchString () const;

    /**
     * Retrieves the value of the field "sSearchString" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sSearchString".
     */
    inline ::fi_basetypes_most::T_String& getSSearchStringMutable ();

    /**
     * Sets the value of the member "sSearchString".
     *
     * The SearchString defines the search terms to be searched for. Maximum number of characters: 100.
     *
     * @param sSearchString The value which will be set
     */
    inline void setSSearchString (const ::fi_basetypes_most::T_String& sSearchString_);

    // API of field "e8SearchSortType"

    static const int kE8SearchSortType = 3;

    /**
     * Clears the field "e8SearchSortType".
     *
     * The field will be set to its default value. The hasE8SearchSortType()
     * method will return false.
     */
    inline void clearE8SearchSortType();

    /**
     * Checks whether the field "e8SearchSortType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8SearchSortType()). Otherwise it will return false.
     */
    inline bool hasE8SearchSortType () const;

    /**
     * Returns the value of the member "e8SearchSortType".
     *
     * The SearchSortType defines the sorting order in which the search result has to be sorted.
     *
     * @return The value of the field "e8SearchSortType"
     */
    inline ::most_PhonBk_fi_types_Extended::T_e8_PhonBkSearchSortType getE8SearchSortType () const;

    /**
     * Sets the value of the member "e8SearchSortType".
     *
     * The SearchSortType defines the sorting order in which the search result has to be sorted.
     *
     * @param e8SearchSortType The value which will be set
     */
    inline void setE8SearchSortType (::most_PhonBk_fi_types_Extended::T_e8_PhonBkSearchSortType e8SearchSortType_);

    // API of field "u16MaxReportedMatches"

    static const int kU16MaxReportedMatches = 4;

    /**
     * Clears the field "u16MaxReportedMatches".
     *
     * The field will be set to its default value. The hasU16MaxReportedMatches()
     * method will return false.
     */
    inline void clearU16MaxReportedMatches();

    /**
     * Checks whether the field "u16MaxReportedMatches" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16MaxReportedMatches()). Otherwise it will return false.
     */
    inline bool hasU16MaxReportedMatches () const;

    /**
     * Returns the value of the member "u16MaxReportedMatches".
     *
     * The search will be stopped when the number of already found matches is reaching this value.
     *
     * @return The value of the field "u16MaxReportedMatches"
     */
    inline uint16 getU16MaxReportedMatches () const;

    /**
     * Sets the value of the member "u16MaxReportedMatches".
     *
     * The search will be stopped when the number of already found matches is reaching this value.
     *
     * @param u16MaxReportedMatches The value which will be set
     */
    inline void setU16MaxReportedMatches (uint16 u16MaxReportedMatches_);

    static const SearchContactsStart &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_oDeviceHandleList ();

    inline void clear_has_oDeviceHandleList ();

    inline void set_has_u16FieldSelector ();

    inline void clear_has_u16FieldSelector ();

    inline void set_has_sSearchString ();

    inline void clear_has_sSearchString ();

    inline void set_has_e8SearchSortType ();

    inline void clear_has_e8SearchSortType ();

    inline void set_has_u16MaxReportedMatches ();

    inline void clear_has_u16MaxReportedMatches ();

    uint32 _has_bits_[ (5 + 31) / 32];

    ::most_PhonBk_fi_types_Extended::T_PhonBkDeviceHandleList _oDeviceHandleList;

    uint16 _u16FieldSelector;

    ::fi_basetypes_most::T_String _sSearchString;

    ::most_PhonBk_fi_types_Extended::T_e8_PhonBkSearchSortType _e8SearchSortType;

    uint16 _u16MaxReportedMatches;

};

/**
 * The result message of the method "SearchContacts"
 * This method searches the contacts containing the given SearchString. The search can be configured as:
 * a. The search can be executed in one or more device lists (For instance Vehicle Contacts and Contacts of a connected phone device)
 * b. The fields(e.g. FirstName, LastName, Phone Number) in which search is done are selectable via a bit field FieldSelector
 * c. The search will be stopped when a number, of already found matches, has reached the given value of MaximumReportedMatches
 */
class SearchContactsResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SearchContactsResult ();

    /**
     * Copy constructor
     */
    inline  SearchContactsResult (const SearchContactsResult &rhs);

    /**
     * All fields constructor
     */
    inline  SearchContactsResult (uint16 u16NumberOfMatches_, bool bMatchLimitExceeded_, const ::most_PhonBk_fi_types_Extended::T_PhonBkContactMatchList& oContactMatchList_);

    /**
     * Destructor
     */
    inline virtual  ~SearchContactsResult();

    /**
     * Assignment operator
     */
    inline SearchContactsResult& operator = (const SearchContactsResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SearchContactsResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SearchContactsResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SearchContactsResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SearchContactsResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16NumberOfMatches"

    static const int kU16NumberOfMatches = 0;

    /**
     * Clears the field "u16NumberOfMatches".
     *
     * The field will be set to its default value. The hasU16NumberOfMatches()
     * method will return false.
     */
    inline void clearU16NumberOfMatches();

    /**
     * Checks whether the field "u16NumberOfMatches" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16NumberOfMatches()). Otherwise it will return false.
     */
    inline bool hasU16NumberOfMatches () const;

    /**
     * Returns the value of the member "u16NumberOfMatches".
     *
     * The parameter provides the number of matching contacts after the search. It can have any value ranging from 0 to MaxReportedMatches.
     *
     * @return The value of the field "u16NumberOfMatches"
     */
    inline uint16 getU16NumberOfMatches () const;

    /**
     * Sets the value of the member "u16NumberOfMatches".
     *
     * The parameter provides the number of matching contacts after the search. It can have any value ranging from 0 to MaxReportedMatches.
     *
     * @param u16NumberOfMatches The value which will be set
     */
    inline void setU16NumberOfMatches (uint16 u16NumberOfMatches_);

    // API of field "bMatchLimitExceeded"

    static const int kBMatchLimitExceeded = 1;

    /**
     * Clears the field "bMatchLimitExceeded".
     *
     * The field will be set to its default value. The hasBMatchLimitExceeded()
     * method will return false.
     */
    inline void clearBMatchLimitExceeded();

    /**
     * Checks whether the field "bMatchLimitExceeded" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBMatchLimitExceeded()). Otherwise it will return false.
     */
    inline bool hasBMatchLimitExceeded () const;

    /**
     * Returns the value of the member "bMatchLimitExceeded".
     *
     * Identifies if the NumberOfMatches exceeds MaxReportedMatches or not.
     * Bit 0 - True  : The search has been stopped as the number of matches had reached the number MaxReportedMatches
     * Bit 0 - False : The search has been run completely.
     *
     * @return The value of the field "bMatchLimitExceeded"
     */
    inline bool getBMatchLimitExceeded () const;

    /**
     * Sets the value of the member "bMatchLimitExceeded".
     *
     * Identifies if the NumberOfMatches exceeds MaxReportedMatches or not.
     * Bit 0 - True  : The search has been stopped as the number of matches had reached the number MaxReportedMatches
     * Bit 0 - False : The search has been run completely.
     *
     * @param bMatchLimitExceeded The value which will be set
     */
    inline void setBMatchLimitExceeded (bool bMatchLimitExceeded_);

    // API of field "oContactMatchList"

    static const int kOContactMatchList = 2;

    /**
     * Clears the field "oContactMatchList".
     *
     * The field will be set to its default value. The hasOContactMatchList()
     * method will return false.
     */
    inline void clearOContactMatchList();

    /**
     * Checks whether the field "oContactMatchList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOContactMatchList()). Otherwise it will return false.
     */
    inline bool hasOContactMatchList () const;

    /**
     * Returns the value of the member "oContactMatchList".
     *
     * The ContactMatchList contains the details of the matching contacts.
     *
     * @return The value of the field "oContactMatchList"
     */
    inline const ::most_PhonBk_fi_types_Extended::T_PhonBkContactMatchList& getOContactMatchList () const;

    /**
     * Retrieves the value of the field "oContactMatchList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oContactMatchList".
     */
    inline ::most_PhonBk_fi_types_Extended::T_PhonBkContactMatchList& getOContactMatchListMutable ();

    /**
     * Sets the value of the member "oContactMatchList".
     *
     * The ContactMatchList contains the details of the matching contacts.
     *
     * @param oContactMatchList The value which will be set
     */
    inline void setOContactMatchList (const ::most_PhonBk_fi_types_Extended::T_PhonBkContactMatchList& oContactMatchList_);

    static const SearchContactsResult &getDefaultInstance();

private:

    static const ::std::vector< ::most_PhonBk_fi_types_Extended::T_PhonBkContactMatchListItem >& getT_PhonBkContactMatchListItemList_DefaultInstance ();

    inline void set_has_u16NumberOfMatches ();

    inline void clear_has_u16NumberOfMatches ();

    inline void set_has_bMatchLimitExceeded ();

    inline void clear_has_bMatchLimitExceeded ();

    inline void set_has_oContactMatchList ();

    inline void clear_has_oContactMatchList ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint16 _u16NumberOfMatches;

    bool _bMatchLimitExceeded;

    ::most_PhonBk_fi_types_Extended::T_PhonBkContactMatchList _oContactMatchList;

};

/**
 * The error message of 'SearchContacts'
 */
class SearchContactsErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SearchContactsErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SearchContactsErrorStructure (const SearchContactsErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SearchContactsErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~SearchContactsErrorStructure();

    /**
     * Assignment operator
     */
    inline SearchContactsErrorStructure& operator = (const SearchContactsErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SearchContactsErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SearchContactsErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SearchContactsErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SearchContactsErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     *
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     *
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     *
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     *
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const SearchContactsErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'SearchContacts'
 */
class SearchContactsError  : public ::asf::core::Payload {
public:

    enum SearchContactsErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SearchContactsError ();

   /**
     * Copy constructor
     */
    inline  SearchContactsError (const SearchContactsError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SearchContactsError();

    /**
     * Assigns a new value to this object.
     */
    inline SearchContactsError& operator = (const SearchContactsError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SearchContactsError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SearchContactsError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SearchContactsError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SearchContactsError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SearchContactsError::SearchContactsErrorField getField () const;

    inline void setField(SearchContactsError::SearchContactsErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SearchContactsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SearchContactsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SearchContactsErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SearchContactsErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SearchContactsErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SearchContactsErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SearchContactsErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SearchContactsErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SearchContactsError &getDefaultInstance();

private:

    inline void cloneData (const SearchContactsError& rhs);

    inline void deleteData ();

    SearchContactsErrorField __field;

    union {
        SearchContactsErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "StartPbDownload"
 * This method will start the manual phonebook download for the given device
 * The given DeviceHandle shall correspond to the connected phone, which currently has the HFP connection (outgoing source device)
 */
class StartPbDownloadStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartPbDownloadStart ();

    /**
     * Copy constructor
     */
    inline  StartPbDownloadStart (const StartPbDownloadStart &rhs);

    /**
     * All fields constructor
     */
    inline  StartPbDownloadStart (uint8 u8DeviceHandle_);

    /**
     * Destructor
     */
    inline virtual  ~StartPbDownloadStart();

    /**
     * Assignment operator
     */
    inline StartPbDownloadStart& operator = (const StartPbDownloadStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartPbDownloadStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartPbDownloadStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartPbDownloadStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartPbDownloadStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the devices(up to 10 external devices) that can be paired.  Handles are maintained by BluetoothSettings FBlock.  0 is reserved as Null. Valid handles are 1..11 inclusive. Where DeviceHandle 1 corresponds to VehiclePhoneBook
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the devices(up to 10 external devices) that can be paired.  Handles are maintained by BluetoothSettings FBlock.  0 is reserved as Null. Valid handles are 1..11 inclusive. Where DeviceHandle 1 corresponds to VehiclePhoneBook
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    static const StartPbDownloadStart &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8DeviceHandle;

};

/**
 * The result message of the method "StartPbDownload"
 * This method will start the manual phonebook download for the given device
 * The given DeviceHandle shall correspond to the connected phone, which currently has the HFP connection (outgoing source device)
 */
class StartPbDownloadResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartPbDownloadResult ();

    /**
     * Copy constructor
     */
    inline  StartPbDownloadResult (const StartPbDownloadResult &rhs);

    /**
     * All fields constructor
     */
    inline  StartPbDownloadResult (uint8 u8DeviceHandle_);

    /**
     * Destructor
     */
    inline virtual  ~StartPbDownloadResult();

    /**
     * Assignment operator
     */
    inline StartPbDownloadResult& operator = (const StartPbDownloadResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartPbDownloadResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartPbDownloadResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartPbDownloadResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartPbDownloadResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the devices(up to 10 external devices) that can be paired.  Handles are maintained by BluetoothSettings FBlock.  0 is reserved as Null. Valid handles are 1..11 inclusive. Where DeviceHandle 1 corresponds to VehiclePhoneBook
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the devices(up to 10 external devices) that can be paired.  Handles are maintained by BluetoothSettings FBlock.  0 is reserved as Null. Valid handles are 1..11 inclusive. Where DeviceHandle 1 corresponds to VehiclePhoneBook
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    static const StartPbDownloadResult &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8DeviceHandle;

};

/**
 * The error message of 'StartPbDownload'
 */
class StartPbDownloadErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  StartPbDownloadErrorStructure ();

    /**
     * Copy constructor
     */
    inline  StartPbDownloadErrorStructure (const StartPbDownloadErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  StartPbDownloadErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~StartPbDownloadErrorStructure();

    /**
     * Assignment operator
     */
    inline StartPbDownloadErrorStructure& operator = (const StartPbDownloadErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartPbDownloadErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartPbDownloadErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartPbDownloadErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartPbDownloadErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     *
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     *
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     *
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     *
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const StartPbDownloadErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'StartPbDownload'
 */
class StartPbDownloadError  : public ::asf::core::Payload {
public:

    enum StartPbDownloadErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  StartPbDownloadError ();

   /**
     * Copy constructor
     */
    inline  StartPbDownloadError (const StartPbDownloadError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~StartPbDownloadError();

    /**
     * Assigns a new value to this object.
     */
    inline StartPbDownloadError& operator = (const StartPbDownloadError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartPbDownloadError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartPbDownloadError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartPbDownloadError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartPbDownloadError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline StartPbDownloadError::StartPbDownloadErrorField getField () const;

    inline void setField(StartPbDownloadError::StartPbDownloadErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "StartPbDownloadErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "StartPbDownloadErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const StartPbDownloadErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline StartPbDownloadErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline StartPbDownloadErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (StartPbDownloadErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "StartPbDownloadErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const StartPbDownloadErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const StartPbDownloadError &getDefaultInstance();

private:

    inline void cloneData (const StartPbDownloadError& rhs);

    inline void deleteData ();

    StartPbDownloadErrorField __field;

    union {
        StartPbDownloadErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SwitchDownloadOnOffState"
 * This method will switch the  phonebook download status to on or off. Values should be 0x00 for PB_DL_ON 0x01 for PB_DL_OFF
 * Phonebook and call history download of each paired device depends on this method
 */
class SwitchDownloadOnOffStateStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SwitchDownloadOnOffStateStart ();

    /**
     * Copy constructor
     */
    inline  SwitchDownloadOnOffStateStart (const SwitchDownloadOnOffStateStart &rhs);

    /**
     * All fields constructor
     */
    inline  SwitchDownloadOnOffStateStart (uint8 u8DeviceHandle_, uint8 u8DownloadOnOffState_);

    /**
     * Destructor
     */
    inline virtual  ~SwitchDownloadOnOffStateStart();

    /**
     * Assignment operator
     */
    inline SwitchDownloadOnOffStateStart& operator = (const SwitchDownloadOnOffStateStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SwitchDownloadOnOffStateStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SwitchDownloadOnOffStateStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SwitchDownloadOnOffStateStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SwitchDownloadOnOffStateStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the devices(up to 10 external devices) that can be paired.  Handles are maintained by BluetoothSettings FBlock.  0 is reserved as Null. Valid handles are 1..11 inclusive. Where DeviceHandle 1 corresponds to VehiclePhoneBook
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the devices(up to 10 external devices) that can be paired.  Handles are maintained by BluetoothSettings FBlock.  0 is reserved as Null. Valid handles are 1..11 inclusive. Where DeviceHandle 1 corresponds to VehiclePhoneBook
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "u8DownloadOnOffState"

    static const int kU8DownloadOnOffState = 1;

    /**
     * Clears the field "u8DownloadOnOffState".
     *
     * The field will be set to its default value. The hasU8DownloadOnOffState()
     * method will return false.
     */
    inline void clearU8DownloadOnOffState();

    /**
     * Checks whether the field "u8DownloadOnOffState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DownloadOnOffState()). Otherwise it will return false.
     */
    inline bool hasU8DownloadOnOffState () const;

    /**
     * Returns the value of the member "u8DownloadOnOffState".
     *
     * DownloadOnOff state for the particular device handle selected
     *
     * @return The value of the field "u8DownloadOnOffState"
     */
    inline uint8 getU8DownloadOnOffState () const;

    /**
     * Sets the value of the member "u8DownloadOnOffState".
     *
     * DownloadOnOff state for the particular device handle selected
     *
     * @param u8DownloadOnOffState The value which will be set
     */
    inline void setU8DownloadOnOffState (uint8 u8DownloadOnOffState_);

    static const SwitchDownloadOnOffStateStart &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_u8DownloadOnOffState ();

    inline void clear_has_u8DownloadOnOffState ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8DeviceHandle;

    uint8 _u8DownloadOnOffState;

};

/**
 * The result message of the method "SwitchDownloadOnOffState"
 * This method will switch the  phonebook download status to on or off. Values should be 0x00 for PB_DL_ON 0x01 for PB_DL_OFF
 * Phonebook and call history download of each paired device depends on this method
 */
class SwitchDownloadOnOffStateResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SwitchDownloadOnOffStateResult ();

    /**
     * Copy constructor
     */
    inline  SwitchDownloadOnOffStateResult (const SwitchDownloadOnOffStateResult &rhs);

    /**
     * All fields constructor
     */
    inline  SwitchDownloadOnOffStateResult (uint8 u8DeviceHandle_, uint8 u8DownloadOnOffState_);

    /**
     * Destructor
     */
    inline virtual  ~SwitchDownloadOnOffStateResult();

    /**
     * Assignment operator
     */
    inline SwitchDownloadOnOffStateResult& operator = (const SwitchDownloadOnOffStateResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SwitchDownloadOnOffStateResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SwitchDownloadOnOffStateResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SwitchDownloadOnOffStateResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SwitchDownloadOnOffStateResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the devices(up to 10 external devices) that can be paired.  Handles are maintained by BluetoothSettings FBlock.  0 is reserved as Null. Valid handles are 1..11 inclusive. Where DeviceHandle 1 corresponds to VehiclePhoneBook
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the devices(up to 10 external devices) that can be paired.  Handles are maintained by BluetoothSettings FBlock.  0 is reserved as Null. Valid handles are 1..11 inclusive. Where DeviceHandle 1 corresponds to VehiclePhoneBook
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "u8DownloadOnOffState"

    static const int kU8DownloadOnOffState = 1;

    /**
     * Clears the field "u8DownloadOnOffState".
     *
     * The field will be set to its default value. The hasU8DownloadOnOffState()
     * method will return false.
     */
    inline void clearU8DownloadOnOffState();

    /**
     * Checks whether the field "u8DownloadOnOffState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DownloadOnOffState()). Otherwise it will return false.
     */
    inline bool hasU8DownloadOnOffState () const;

    /**
     * Returns the value of the member "u8DownloadOnOffState".
     *
     * DownloadOnOff state for the particular device handle selected
     *
     * @return The value of the field "u8DownloadOnOffState"
     */
    inline uint8 getU8DownloadOnOffState () const;

    /**
     * Sets the value of the member "u8DownloadOnOffState".
     *
     * DownloadOnOff state for the particular device handle selected
     *
     * @param u8DownloadOnOffState The value which will be set
     */
    inline void setU8DownloadOnOffState (uint8 u8DownloadOnOffState_);

    static const SwitchDownloadOnOffStateResult &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_u8DownloadOnOffState ();

    inline void clear_has_u8DownloadOnOffState ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8DeviceHandle;

    uint8 _u8DownloadOnOffState;

};

/**
 * The error message of 'SwitchDownloadOnOffState'
 */
class SwitchDownloadOnOffStateErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SwitchDownloadOnOffStateErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SwitchDownloadOnOffStateErrorStructure (const SwitchDownloadOnOffStateErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SwitchDownloadOnOffStateErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~SwitchDownloadOnOffStateErrorStructure();

    /**
     * Assignment operator
     */
    inline SwitchDownloadOnOffStateErrorStructure& operator = (const SwitchDownloadOnOffStateErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SwitchDownloadOnOffStateErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SwitchDownloadOnOffStateErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SwitchDownloadOnOffStateErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SwitchDownloadOnOffStateErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     *
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     *
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     *
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     *
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const SwitchDownloadOnOffStateErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'SwitchDownloadOnOffState'
 */
class SwitchDownloadOnOffStateError  : public ::asf::core::Payload {
public:

    enum SwitchDownloadOnOffStateErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SwitchDownloadOnOffStateError ();

   /**
     * Copy constructor
     */
    inline  SwitchDownloadOnOffStateError (const SwitchDownloadOnOffStateError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SwitchDownloadOnOffStateError();

    /**
     * Assigns a new value to this object.
     */
    inline SwitchDownloadOnOffStateError& operator = (const SwitchDownloadOnOffStateError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SwitchDownloadOnOffStateError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SwitchDownloadOnOffStateError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SwitchDownloadOnOffStateError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SwitchDownloadOnOffStateError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SwitchDownloadOnOffStateError::SwitchDownloadOnOffStateErrorField getField () const;

    inline void setField(SwitchDownloadOnOffStateError::SwitchDownloadOnOffStateErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SwitchDownloadOnOffStateErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SwitchDownloadOnOffStateErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SwitchDownloadOnOffStateErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SwitchDownloadOnOffStateErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SwitchDownloadOnOffStateErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SwitchDownloadOnOffStateErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SwitchDownloadOnOffStateErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SwitchDownloadOnOffStateErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SwitchDownloadOnOffStateError &getDefaultInstance();

private:

    inline void cloneData (const SwitchDownloadOnOffStateError& rhs);

    inline void deleteData ();

    SwitchDownloadOnOffStateErrorField __field;

    union {
        SwitchDownloadOnOffStateErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "CreateContactList"
 * Creates a contact list of a particular type and returns a ListHandle to the caller.
 * Slices of the list can then be accessed via RequestPhoneBookListSlice.
 */
class CreateContactListStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CreateContactListStart ();

    /**
     * Copy constructor
     */
    inline  CreateContactListStart (const CreateContactListStart &rhs);

    /**
     * All fields constructor
     */
    inline  CreateContactListStart (uint8 u8DeviceHandle_, ::most_PhonBk_fi_types_Extended::T_e8_PhonBkContactListType e8PhoneBkContactListType_, ::most_PhonBk_fi_types_Extended::T_e8_PhonBkContactSortType e8PhoneBkContactSortType_);

    /**
     * Destructor
     */
    inline virtual  ~CreateContactListStart();

    /**
     * Assignment operator
     */
    inline CreateContactListStart& operator = (const CreateContactListStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreateContactListStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreateContactListStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreateContactListStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreateContactListStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Handle of the device for the phone book source. The vehicle phone book has a DeviceHandle = 1.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Handle of the device for the phone book source. The vehicle phone book has a DeviceHandle = 1.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "e8PhoneBkContactListType"

    static const int kE8PhoneBkContactListType = 1;

    /**
     * Clears the field "e8PhoneBkContactListType".
     *
     * The field will be set to its default value. The hasE8PhoneBkContactListType()
     * method will return false.
     */
    inline void clearE8PhoneBkContactListType();

    /**
     * Checks whether the field "e8PhoneBkContactListType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PhoneBkContactListType()). Otherwise it will return false.
     */
    inline bool hasE8PhoneBkContactListType () const;

    /**
     * Returns the value of the member "e8PhoneBkContactListType".
     *
     * Passed in CreateContactList to set the sort order of a created list.
     *
     * @return The value of the field "e8PhoneBkContactListType"
     */
    inline ::most_PhonBk_fi_types_Extended::T_e8_PhonBkContactListType getE8PhoneBkContactListType () const;

    /**
     * Sets the value of the member "e8PhoneBkContactListType".
     *
     * Passed in CreateContactList to set the sort order of a created list.
     *
     * @param e8PhoneBkContactListType The value which will be set
     */
    inline void setE8PhoneBkContactListType (::most_PhonBk_fi_types_Extended::T_e8_PhonBkContactListType e8PhoneBkContactListType_);

    // API of field "e8PhoneBkContactSortType"

    static const int kE8PhoneBkContactSortType = 2;

    /**
     * Clears the field "e8PhoneBkContactSortType".
     *
     * The field will be set to its default value. The hasE8PhoneBkContactSortType()
     * method will return false.
     */
    inline void clearE8PhoneBkContactSortType();

    /**
     * Checks whether the field "e8PhoneBkContactSortType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PhoneBkContactSortType()). Otherwise it will return false.
     */
    inline bool hasE8PhoneBkContactSortType () const;

    /**
     * Returns the value of the member "e8PhoneBkContactSortType".
     *
     * Passed in CreateContactList to set the type of list(Phone book,Favourite,vehilcePB type).
     *
     * @return The value of the field "e8PhoneBkContactSortType"
     */
    inline ::most_PhonBk_fi_types_Extended::T_e8_PhonBkContactSortType getE8PhoneBkContactSortType () const;

    /**
     * Sets the value of the member "e8PhoneBkContactSortType".
     *
     * Passed in CreateContactList to set the type of list(Phone book,Favourite,vehilcePB type).
     *
     * @param e8PhoneBkContactSortType The value which will be set
     */
    inline void setE8PhoneBkContactSortType (::most_PhonBk_fi_types_Extended::T_e8_PhonBkContactSortType e8PhoneBkContactSortType_);

    static const CreateContactListStart &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_e8PhoneBkContactListType ();

    inline void clear_has_e8PhoneBkContactListType ();

    inline void set_has_e8PhoneBkContactSortType ();

    inline void clear_has_e8PhoneBkContactSortType ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _u8DeviceHandle;

    ::most_PhonBk_fi_types_Extended::T_e8_PhonBkContactListType _e8PhoneBkContactListType;

    ::most_PhonBk_fi_types_Extended::T_e8_PhonBkContactSortType _e8PhoneBkContactSortType;

};

/**
 * The result message of the method "CreateContactList"
 * Creates a contact list of a particular type and returns a ListHandle to the caller.
 * Slices of the list can then be accessed via RequestPhoneBookListSlice.
 */
class CreateContactListResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CreateContactListResult ();

    /**
     * Copy constructor
     */
    inline  CreateContactListResult (const CreateContactListResult &rhs);

    /**
     * All fields constructor
     */
    inline  CreateContactListResult (uint16 u16ListHandle_, uint16 u16ListLength_);

    /**
     * Destructor
     */
    inline virtual  ~CreateContactListResult();

    /**
     * Assignment operator
     */
    inline CreateContactListResult& operator = (const CreateContactListResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreateContactListResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreateContactListResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreateContactListResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreateContactListResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ListHandle"

    static const int kU16ListHandle = 0;

    /**
     * Clears the field "u16ListHandle".
     *
     * The field will be set to its default value. The hasU16ListHandle()
     * method will return false.
     */
    inline void clearU16ListHandle();

    /**
     * Checks whether the field "u16ListHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ListHandle()). Otherwise it will return false.
     */
    inline bool hasU16ListHandle () const;

    /**
     * Returns the value of the member "u16ListHandle".
     *
     * The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @return The value of the field "u16ListHandle"
     */
    inline uint16 getU16ListHandle () const;

    /**
     * Sets the value of the member "u16ListHandle".
     *
     * The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @param u16ListHandle The value which will be set
     */
    inline void setU16ListHandle (uint16 u16ListHandle_);

    // API of field "u16ListLength"

    static const int kU16ListLength = 1;

    /**
     * Clears the field "u16ListLength".
     *
     * The field will be set to its default value. The hasU16ListLength()
     * method will return false.
     */
    inline void clearU16ListLength();

    /**
     * Checks whether the field "u16ListLength" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ListLength()). Otherwise it will return false.
     */
    inline bool hasU16ListLength () const;

    /**
     * Returns the value of the member "u16ListLength".
     *
     * The number of elements (i.e. contacts or recent calls) in the Phone Book or Call History list.  The length is valid until the list is modified or released.
     *
     * @return The value of the field "u16ListLength"
     */
    inline uint16 getU16ListLength () const;

    /**
     * Sets the value of the member "u16ListLength".
     *
     * The number of elements (i.e. contacts or recent calls) in the Phone Book or Call History list.  The length is valid until the list is modified or released.
     *
     * @param u16ListLength The value which will be set
     */
    inline void setU16ListLength (uint16 u16ListLength_);

    static const CreateContactListResult &getDefaultInstance();

private:

    inline void set_has_u16ListHandle ();

    inline void clear_has_u16ListHandle ();

    inline void set_has_u16ListLength ();

    inline void clear_has_u16ListLength ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _u16ListHandle;

    uint16 _u16ListLength;

};

/**
 * The error message of 'CreateContactList'
 */
class CreateContactListErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  CreateContactListErrorStructure ();

    /**
     * Copy constructor
     */
    inline  CreateContactListErrorStructure (const CreateContactListErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  CreateContactListErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~CreateContactListErrorStructure();

    /**
     * Assignment operator
     */
    inline CreateContactListErrorStructure& operator = (const CreateContactListErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreateContactListErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreateContactListErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreateContactListErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreateContactListErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     *
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     *
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     *
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     *
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const CreateContactListErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'CreateContactList'
 */
class CreateContactListError  : public ::asf::core::Payload {
public:

    enum CreateContactListErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  CreateContactListError ();

   /**
     * Copy constructor
     */
    inline  CreateContactListError (const CreateContactListError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~CreateContactListError();

    /**
     * Assigns a new value to this object.
     */
    inline CreateContactListError& operator = (const CreateContactListError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreateContactListError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreateContactListError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreateContactListError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreateContactListError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline CreateContactListError::CreateContactListErrorField getField () const;

    inline void setField(CreateContactListError::CreateContactListErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "CreateContactListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "CreateContactListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const CreateContactListErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline CreateContactListErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline CreateContactListErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (CreateContactListErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "CreateContactListErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const CreateContactListErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const CreateContactListError &getDefaultInstance();

private:

    inline void cloneData (const CreateContactListError& rhs);

    inline void deleteData ();

    CreateContactListErrorField __field;

    union {
        CreateContactListErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SetContactPhoto"
 * Sets photo for the given contact in vehicle phonebook. This function return with the requested values and confirms that job will be executed.
 */
class SetContactPhotoStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetContactPhotoStart ();

    /**
     * Copy constructor
     */
    inline  SetContactPhotoStart (const SetContactPhotoStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetContactPhotoStart (uint32 u32ContactHandle_, const ::most_PhonBk_fi_types::T_PhonBkContactPhoto& oVehicleContactPhoto_);

    /**
     * Destructor
     */
    inline virtual  ~SetContactPhotoStart();

    /**
     * Assignment operator
     */
    inline SetContactPhotoStart& operator = (const SetContactPhotoStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetContactPhotoStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetContactPhotoStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetContactPhotoStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetContactPhotoStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32ContactHandle"

    static const int kU32ContactHandle = 0;

    /**
     * Clears the field "u32ContactHandle".
     *
     * The field will be set to its default value. The hasU32ContactHandle()
     * method will return false.
     */
    inline void clearU32ContactHandle();

    /**
     * Checks whether the field "u32ContactHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ContactHandle()). Otherwise it will return false.
     */
    inline bool hasU32ContactHandle () const;

    /**
     * Returns the value of the member "u32ContactHandle".
     *
     * This is the globally unique ID for a particular contact. The ID is unique across all currently connected devices.
     *
     * @return The value of the field "u32ContactHandle"
     */
    inline uint32 getU32ContactHandle () const;

    /**
     * Sets the value of the member "u32ContactHandle".
     *
     * This is the globally unique ID for a particular contact. The ID is unique across all currently connected devices.
     *
     * @param u32ContactHandle The value which will be set
     */
    inline void setU32ContactHandle (uint32 u32ContactHandle_);

    // API of field "oVehicleContactPhoto"

    static const int kOVehicleContactPhoto = 1;

    /**
     * Clears the field "oVehicleContactPhoto".
     *
     * The field will be set to its default value. The hasOVehicleContactPhoto()
     * method will return false.
     */
    inline void clearOVehicleContactPhoto();

    /**
     * Checks whether the field "oVehicleContactPhoto" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOVehicleContactPhoto()). Otherwise it will return false.
     */
    inline bool hasOVehicleContactPhoto () const;

    /**
     * Returns the value of the member "oVehicleContactPhoto".
     *
     *
     *
     * @return The value of the field "oVehicleContactPhoto"
     */
    inline const ::most_PhonBk_fi_types::T_PhonBkContactPhoto& getOVehicleContactPhoto () const;

    /**
     * Retrieves the value of the field "oVehicleContactPhoto" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oVehicleContactPhoto".
     */
    inline ::most_PhonBk_fi_types::T_PhonBkContactPhoto& getOVehicleContactPhotoMutable ();

    /**
     * Sets the value of the member "oVehicleContactPhoto".
     *
     *
     *
     * @param oVehicleContactPhoto The value which will be set
     */
    inline void setOVehicleContactPhoto (const ::most_PhonBk_fi_types::T_PhonBkContactPhoto& oVehicleContactPhoto_);

    static const SetContactPhotoStart &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_u32ContactHandle ();

    inline void clear_has_u32ContactHandle ();

    inline void set_has_oVehicleContactPhoto ();

    inline void clear_has_oVehicleContactPhoto ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _u32ContactHandle;

    ::most_PhonBk_fi_types::T_PhonBkContactPhoto _oVehicleContactPhoto;

};

/**
 * The result message of the method "SetContactPhoto"
 * Sets photo for the given contact in vehicle phonebook. This function return with the requested values and confirms that job will be executed.
 */
class SetContactPhotoResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetContactPhotoResult ();

    /**
     * Copy constructor
     */
    inline  SetContactPhotoResult (const SetContactPhotoResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetContactPhotoResult (uint32 u32ContactHandle_);

    /**
     * Destructor
     */
    inline virtual  ~SetContactPhotoResult();

    /**
     * Assignment operator
     */
    inline SetContactPhotoResult& operator = (const SetContactPhotoResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetContactPhotoResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetContactPhotoResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetContactPhotoResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetContactPhotoResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32ContactHandle"

    static const int kU32ContactHandle = 0;

    /**
     * Clears the field "u32ContactHandle".
     *
     * The field will be set to its default value. The hasU32ContactHandle()
     * method will return false.
     */
    inline void clearU32ContactHandle();

    /**
     * Checks whether the field "u32ContactHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ContactHandle()). Otherwise it will return false.
     */
    inline bool hasU32ContactHandle () const;

    /**
     * Returns the value of the member "u32ContactHandle".
     *
     * This is the globally unique ID for a particular contact. The ID is unique across all currently connected devices.
     *
     * @return The value of the field "u32ContactHandle"
     */
    inline uint32 getU32ContactHandle () const;

    /**
     * Sets the value of the member "u32ContactHandle".
     *
     * This is the globally unique ID for a particular contact. The ID is unique across all currently connected devices.
     *
     * @param u32ContactHandle The value which will be set
     */
    inline void setU32ContactHandle (uint32 u32ContactHandle_);

    static const SetContactPhotoResult &getDefaultInstance();

private:

    inline void set_has_u32ContactHandle ();

    inline void clear_has_u32ContactHandle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _u32ContactHandle;

};

/**
 * The error message of 'SetContactPhoto'
 */
class SetContactPhotoErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetContactPhotoErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetContactPhotoErrorStructure (const SetContactPhotoErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetContactPhotoErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~SetContactPhotoErrorStructure();

    /**
     * Assignment operator
     */
    inline SetContactPhotoErrorStructure& operator = (const SetContactPhotoErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetContactPhotoErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetContactPhotoErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetContactPhotoErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetContactPhotoErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     *
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     *
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     *
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     *
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const SetContactPhotoErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'SetContactPhoto'
 */
class SetContactPhotoError  : public ::asf::core::Payload {
public:

    enum SetContactPhotoErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetContactPhotoError ();

   /**
     * Copy constructor
     */
    inline  SetContactPhotoError (const SetContactPhotoError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetContactPhotoError();

    /**
     * Assigns a new value to this object.
     */
    inline SetContactPhotoError& operator = (const SetContactPhotoError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetContactPhotoError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetContactPhotoError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetContactPhotoError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetContactPhotoError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetContactPhotoError::SetContactPhotoErrorField getField () const;

    inline void setField(SetContactPhotoError::SetContactPhotoErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetContactPhotoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetContactPhotoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetContactPhotoErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetContactPhotoErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetContactPhotoErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetContactPhotoErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetContactPhotoErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetContactPhotoErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetContactPhotoError &getDefaultInstance();

private:

    inline void cloneData (const SetContactPhotoError& rhs);

    inline void deleteData ();

    SetContactPhotoErrorField __field;

    union {
        SetContactPhotoErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "CancelPbDownload"
 * The user shall have possibility to cancel the ongoing phone book download but not the call history download
 */
class CancelPbDownloadStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CancelPbDownloadStart ();

    /**
     * Copy constructor
     */
    inline  CancelPbDownloadStart (const CancelPbDownloadStart &rhs);

    /**
     * All fields constructor
     */
    inline  CancelPbDownloadStart (uint8 u8DeviceHandle_);

    /**
     * Destructor
     */
    inline virtual  ~CancelPbDownloadStart();

    /**
     * Assignment operator
     */
    inline CancelPbDownloadStart& operator = (const CancelPbDownloadStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CancelPbDownloadStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CancelPbDownloadStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CancelPbDownloadStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CancelPbDownloadStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the devices(up to 10 external devices) that can be paired.  Handles are maintained by BluetoothSettings FBlock.  0 is reserved as Null. Valid handles are 1..11 inclusive. Where DeviceHandle 1 corresponds to VehiclePhoneBook
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the devices(up to 10 external devices) that can be paired.  Handles are maintained by BluetoothSettings FBlock.  0 is reserved as Null. Valid handles are 1..11 inclusive. Where DeviceHandle 1 corresponds to VehiclePhoneBook
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    static const CancelPbDownloadStart &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8DeviceHandle;

};

/**
 * The result message of the method "CancelPbDownload"
 * The user shall have possibility to cancel the ongoing phone book download but not the call history download
 */
class CancelPbDownloadResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CancelPbDownloadResult ();

    /**
     * Copy constructor
     */
    inline  CancelPbDownloadResult (const CancelPbDownloadResult &rhs);

    /**
     * All fields constructor
     */
    inline  CancelPbDownloadResult (uint8 u8DeviceHandle_);

    /**
     * Destructor
     */
    inline virtual  ~CancelPbDownloadResult();

    /**
     * Assignment operator
     */
    inline CancelPbDownloadResult& operator = (const CancelPbDownloadResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CancelPbDownloadResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CancelPbDownloadResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CancelPbDownloadResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CancelPbDownloadResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the devices(up to 10 external devices) that can be paired.  Handles are maintained by BluetoothSettings FBlock.  0 is reserved as Null. Valid handles are 1..11 inclusive. Where DeviceHandle 1 corresponds to VehiclePhoneBook
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the devices(up to 10 external devices) that can be paired.  Handles are maintained by BluetoothSettings FBlock.  0 is reserved as Null. Valid handles are 1..11 inclusive. Where DeviceHandle 1 corresponds to VehiclePhoneBook
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    static const CancelPbDownloadResult &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8DeviceHandle;

};

/**
 * The error message of 'CancelPbDownload'
 */
class CancelPbDownloadErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  CancelPbDownloadErrorStructure ();

    /**
     * Copy constructor
     */
    inline  CancelPbDownloadErrorStructure (const CancelPbDownloadErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  CancelPbDownloadErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~CancelPbDownloadErrorStructure();

    /**
     * Assignment operator
     */
    inline CancelPbDownloadErrorStructure& operator = (const CancelPbDownloadErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CancelPbDownloadErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CancelPbDownloadErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CancelPbDownloadErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CancelPbDownloadErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     *
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     *
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     *
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     *
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const CancelPbDownloadErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'CancelPbDownload'
 */
class CancelPbDownloadError  : public ::asf::core::Payload {
public:

    enum CancelPbDownloadErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  CancelPbDownloadError ();

   /**
     * Copy constructor
     */
    inline  CancelPbDownloadError (const CancelPbDownloadError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~CancelPbDownloadError();

    /**
     * Assigns a new value to this object.
     */
    inline CancelPbDownloadError& operator = (const CancelPbDownloadError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CancelPbDownloadError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CancelPbDownloadError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CancelPbDownloadError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CancelPbDownloadError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline CancelPbDownloadError::CancelPbDownloadErrorField getField () const;

    inline void setField(CancelPbDownloadError::CancelPbDownloadErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "CancelPbDownloadErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "CancelPbDownloadErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const CancelPbDownloadErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline CancelPbDownloadErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline CancelPbDownloadErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (CancelPbDownloadErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "CancelPbDownloadErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const CancelPbDownloadErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const CancelPbDownloadError &getDefaultInstance();

private:

    inline void cloneData (const CancelPbDownloadError& rhs);

    inline void deleteData ();

    CancelPbDownloadErrorField __field;

    union {
        CancelPbDownloadErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SetContactPosition"
 * Sets the contact postion for the given contacthandle and position in vehicle phonebook. This function return with the requested values and confirms that job will be executed.
 */
class SetContactPositionStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetContactPositionStart ();

    /**
     * Copy constructor
     */
    inline  SetContactPositionStart (const SetContactPositionStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetContactPositionStart (uint32 u32ContactHandle_, uint32 u32ContactPosition_);

    /**
     * Destructor
     */
    inline virtual  ~SetContactPositionStart();

    /**
     * Assignment operator
     */
    inline SetContactPositionStart& operator = (const SetContactPositionStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetContactPositionStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetContactPositionStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetContactPositionStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetContactPositionStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32ContactHandle"

    static const int kU32ContactHandle = 0;

    /**
     * Clears the field "u32ContactHandle".
     *
     * The field will be set to its default value. The hasU32ContactHandle()
     * method will return false.
     */
    inline void clearU32ContactHandle();

    /**
     * Checks whether the field "u32ContactHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ContactHandle()). Otherwise it will return false.
     */
    inline bool hasU32ContactHandle () const;

    /**
     * Returns the value of the member "u32ContactHandle".
     *
     * This is the globally unique ID for a particular contact. The ID is unique across all currently connected devices.
     *
     * @return The value of the field "u32ContactHandle"
     */
    inline uint32 getU32ContactHandle () const;

    /**
     * Sets the value of the member "u32ContactHandle".
     *
     * This is the globally unique ID for a particular contact. The ID is unique across all currently connected devices.
     *
     * @param u32ContactHandle The value which will be set
     */
    inline void setU32ContactHandle (uint32 u32ContactHandle_);

    // API of field "u32ContactPosition"

    static const int kU32ContactPosition = 1;

    /**
     * Clears the field "u32ContactPosition".
     *
     * The field will be set to its default value. The hasU32ContactPosition()
     * method will return false.
     */
    inline void clearU32ContactPosition();

    /**
     * Checks whether the field "u32ContactPosition" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ContactPosition()). Otherwise it will return false.
     */
    inline bool hasU32ContactPosition () const;

    /**
     * Returns the value of the member "u32ContactPosition".
     *
     *
     *
     * @return The value of the field "u32ContactPosition"
     */
    inline uint32 getU32ContactPosition () const;

    /**
     * Sets the value of the member "u32ContactPosition".
     *
     *
     *
     * @param u32ContactPosition The value which will be set
     */
    inline void setU32ContactPosition (uint32 u32ContactPosition_);

    static const SetContactPositionStart &getDefaultInstance();

private:

    inline void set_has_u32ContactHandle ();

    inline void clear_has_u32ContactHandle ();

    inline void set_has_u32ContactPosition ();

    inline void clear_has_u32ContactPosition ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _u32ContactHandle;

    uint32 _u32ContactPosition;

};

/**
 * The result message of the method "SetContactPosition"
 * Sets the contact postion for the given contacthandle and position in vehicle phonebook. This function return with the requested values and confirms that job will be executed.
 */
class SetContactPositionResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetContactPositionResult ();

    /**
     * Copy constructor
     */
    inline  SetContactPositionResult (const SetContactPositionResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetContactPositionResult (uint32 u32ContactHandle_);

    /**
     * Destructor
     */
    inline virtual  ~SetContactPositionResult();

    /**
     * Assignment operator
     */
    inline SetContactPositionResult& operator = (const SetContactPositionResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetContactPositionResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetContactPositionResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetContactPositionResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetContactPositionResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32ContactHandle"

    static const int kU32ContactHandle = 0;

    /**
     * Clears the field "u32ContactHandle".
     *
     * The field will be set to its default value. The hasU32ContactHandle()
     * method will return false.
     */
    inline void clearU32ContactHandle();

    /**
     * Checks whether the field "u32ContactHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ContactHandle()). Otherwise it will return false.
     */
    inline bool hasU32ContactHandle () const;

    /**
     * Returns the value of the member "u32ContactHandle".
     *
     * This is the globally unique ID for a particular contact. The ID is unique across all currently connected devices.
     *
     * @return The value of the field "u32ContactHandle"
     */
    inline uint32 getU32ContactHandle () const;

    /**
     * Sets the value of the member "u32ContactHandle".
     *
     * This is the globally unique ID for a particular contact. The ID is unique across all currently connected devices.
     *
     * @param u32ContactHandle The value which will be set
     */
    inline void setU32ContactHandle (uint32 u32ContactHandle_);

    static const SetContactPositionResult &getDefaultInstance();

private:

    inline void set_has_u32ContactHandle ();

    inline void clear_has_u32ContactHandle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _u32ContactHandle;

};

/**
 * The error message of 'SetContactPosition'
 */
class SetContactPositionErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetContactPositionErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetContactPositionErrorStructure (const SetContactPositionErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetContactPositionErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~SetContactPositionErrorStructure();

    /**
     * Assignment operator
     */
    inline SetContactPositionErrorStructure& operator = (const SetContactPositionErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetContactPositionErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetContactPositionErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetContactPositionErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetContactPositionErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     *
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     *
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     *
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     *
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const SetContactPositionErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'SetContactPosition'
 */
class SetContactPositionError  : public ::asf::core::Payload {
public:

    enum SetContactPositionErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetContactPositionError ();

   /**
     * Copy constructor
     */
    inline  SetContactPositionError (const SetContactPositionError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetContactPositionError();

    /**
     * Assigns a new value to this object.
     */
    inline SetContactPositionError& operator = (const SetContactPositionError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetContactPositionError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetContactPositionError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetContactPositionError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetContactPositionError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetContactPositionError::SetContactPositionErrorField getField () const;

    inline void setField(SetContactPositionError::SetContactPositionErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetContactPositionErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetContactPositionErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetContactPositionErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetContactPositionErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetContactPositionErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetContactPositionErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetContactPositionErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetContactPositionErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetContactPositionError &getDefaultInstance();

private:

    inline void cloneData (const SetContactPositionError& rhs);

    inline void deleteData ();

    SetContactPositionErrorField __field;

    union {
        SetContactPositionErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "AddContactExtended"
 * Adds new contact(Extended) to the vehicle phone book (i.e. Vehicle Contact List)
 */
class AddContactExtendedStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AddContactExtendedStart ();

    /**
     * Copy constructor
     */
    inline  AddContactExtendedStart (const AddContactExtendedStart &rhs);

    /**
     * All fields constructor
     */
    inline  AddContactExtendedStart (uint8 u8DeviceHandle_, const ::most_PhonBk_fi_types_Extended::T_PhonBkContactDetailsExtended& oContactDetailsExtended_);

    /**
     * Destructor
     */
    inline virtual  ~AddContactExtendedStart();

    /**
     * Assignment operator
     */
    inline AddContactExtendedStart& operator = (const AddContactExtendedStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddContactExtendedStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddContactExtendedStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddContactExtendedStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddContactExtendedStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Handle of the device for the phone book source.
     * The vehicle phone book has a DeviceHandle = 1.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Handle of the device for the phone book source.
     * The vehicle phone book has a DeviceHandle = 1.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "oContactDetailsExtended"

    static const int kOContactDetailsExtended = 1;

    /**
     * Clears the field "oContactDetailsExtended".
     *
     * The field will be set to its default value. The hasOContactDetailsExtended()
     * method will return false.
     */
    inline void clearOContactDetailsExtended();

    /**
     * Checks whether the field "oContactDetailsExtended" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOContactDetailsExtended()). Otherwise it will return false.
     */
    inline bool hasOContactDetailsExtended () const;

    /**
     * Returns the value of the member "oContactDetailsExtended".
     *
     * This is the type for Contact details(extended) with
     * option to add a maximum of 8 different phone numbers and their types.
     *
     * @return The value of the field "oContactDetailsExtended"
     */
    inline const ::most_PhonBk_fi_types_Extended::T_PhonBkContactDetailsExtended& getOContactDetailsExtended () const;

    /**
     * Retrieves the value of the field "oContactDetailsExtended" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oContactDetailsExtended".
     */
    inline ::most_PhonBk_fi_types_Extended::T_PhonBkContactDetailsExtended& getOContactDetailsExtendedMutable ();

    /**
     * Sets the value of the member "oContactDetailsExtended".
     *
     * This is the type for Contact details(extended) with
     * option to add a maximum of 8 different phone numbers and their types.
     *
     * @param oContactDetailsExtended The value which will be set
     */
    inline void setOContactDetailsExtended (const ::most_PhonBk_fi_types_Extended::T_PhonBkContactDetailsExtended& oContactDetailsExtended_);

    static const AddContactExtendedStart &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_oContactDetailsExtended ();

    inline void clear_has_oContactDetailsExtended ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8DeviceHandle;

    ::most_PhonBk_fi_types_Extended::T_PhonBkContactDetailsExtended _oContactDetailsExtended;

};

/**
 * The result message of the method "AddContactExtended"
 * Adds new contact(Extended) to the vehicle phone book (i.e. Vehicle Contact List)
 */
class AddContactExtendedResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AddContactExtendedResult ();

    /**
     * Copy constructor
     */
    inline  AddContactExtendedResult (const AddContactExtendedResult &rhs);

    /**
     * All fields constructor
     */
    inline  AddContactExtendedResult (uint32 u32ContactHandle_, ::most_PhonBk_fi_types::T_e8_PhonBkContactAddStatus e8ContactAddStatusExtended_);

    /**
     * Destructor
     */
    inline virtual  ~AddContactExtendedResult();

    /**
     * Assignment operator
     */
    inline AddContactExtendedResult& operator = (const AddContactExtendedResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddContactExtendedResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddContactExtendedResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddContactExtendedResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddContactExtendedResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32ContactHandle"

    static const int kU32ContactHandle = 0;

    /**
     * Clears the field "u32ContactHandle".
     *
     * The field will be set to its default value. The hasU32ContactHandle()
     * method will return false.
     */
    inline void clearU32ContactHandle();

    /**
     * Checks whether the field "u32ContactHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ContactHandle()). Otherwise it will return false.
     */
    inline bool hasU32ContactHandle () const;

    /**
     * Returns the value of the member "u32ContactHandle".
     *
     * This is the globally unique ID for a particular
     * contact. The ID is unique across all currently connected
     * devices.
     *
     * @return The value of the field "u32ContactHandle"
     */
    inline uint32 getU32ContactHandle () const;

    /**
     * Sets the value of the member "u32ContactHandle".
     *
     * This is the globally unique ID for a particular
     * contact. The ID is unique across all currently connected
     * devices.
     *
     * @param u32ContactHandle The value which will be set
     */
    inline void setU32ContactHandle (uint32 u32ContactHandle_);

    // API of field "e8ContactAddStatusExtended"

    static const int kE8ContactAddStatusExtended = 1;

    /**
     * Clears the field "e8ContactAddStatusExtended".
     *
     * The field will be set to its default value. The hasE8ContactAddStatusExtended()
     * method will return false.
     */
    inline void clearE8ContactAddStatusExtended();

    /**
     * Checks whether the field "e8ContactAddStatusExtended" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ContactAddStatusExtended()). Otherwise it will return false.
     */
    inline bool hasE8ContactAddStatusExtended () const;

    /**
     * Returns the value of the member "e8ContactAddStatusExtended".
     *
     * Contains the status in response to a
     * AddContactExtended call.
     *
     * @return The value of the field "e8ContactAddStatusExtended"
     */
    inline ::most_PhonBk_fi_types::T_e8_PhonBkContactAddStatus getE8ContactAddStatusExtended () const;

    /**
     * Sets the value of the member "e8ContactAddStatusExtended".
     *
     * Contains the status in response to a
     * AddContactExtended call.
     *
     * @param e8ContactAddStatusExtended The value which will be set
     */
    inline void setE8ContactAddStatusExtended (::most_PhonBk_fi_types::T_e8_PhonBkContactAddStatus e8ContactAddStatusExtended_);

    static const AddContactExtendedResult &getDefaultInstance();

private:

    inline void set_has_u32ContactHandle ();

    inline void clear_has_u32ContactHandle ();

    inline void set_has_e8ContactAddStatusExtended ();

    inline void clear_has_e8ContactAddStatusExtended ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _u32ContactHandle;

    ::most_PhonBk_fi_types::T_e8_PhonBkContactAddStatus _e8ContactAddStatusExtended;

};

/**
 * The error message of 'AddContactExtended'
 */
class AddContactExtendedErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  AddContactExtendedErrorStructure ();

    /**
     * Copy constructor
     */
    inline  AddContactExtendedErrorStructure (const AddContactExtendedErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  AddContactExtendedErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~AddContactExtendedErrorStructure();

    /**
     * Assignment operator
     */
    inline AddContactExtendedErrorStructure& operator = (const AddContactExtendedErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddContactExtendedErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddContactExtendedErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddContactExtendedErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddContactExtendedErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     *
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     *
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     *
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     *
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const AddContactExtendedErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'AddContactExtended'
 */
class AddContactExtendedError  : public ::asf::core::Payload {
public:

    enum AddContactExtendedErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  AddContactExtendedError ();

   /**
     * Copy constructor
     */
    inline  AddContactExtendedError (const AddContactExtendedError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~AddContactExtendedError();

    /**
     * Assigns a new value to this object.
     */
    inline AddContactExtendedError& operator = (const AddContactExtendedError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddContactExtendedError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddContactExtendedError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddContactExtendedError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddContactExtendedError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline AddContactExtendedError::AddContactExtendedErrorField getField () const;

    inline void setField(AddContactExtendedError::AddContactExtendedErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "AddContactExtendedErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "AddContactExtendedErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const AddContactExtendedErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline AddContactExtendedErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline AddContactExtendedErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (AddContactExtendedErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "AddContactExtendedErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const AddContactExtendedErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const AddContactExtendedError &getDefaultInstance();

private:

    inline void cloneData (const AddContactExtendedError& rhs);

    inline void deleteData ();

    AddContactExtendedErrorField __field;

    union {
        AddContactExtendedErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "EditContactExtended"
 * Updates an existing vehicle phonebook
 * contact with modifications and/or additions to the contact detail field(s) as entered by the user.
 *
 * The function is initiated upon the contact being saved.
 * The Result response includes the
 * ContactEditStatus and the ContactHandle
 * of the contact requested
 * for modification.
 */
class EditContactExtendedStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EditContactExtendedStart ();

    /**
     * Copy constructor
     */
    inline  EditContactExtendedStart (const EditContactExtendedStart &rhs);

    /**
     * All fields constructor
     */
    inline  EditContactExtendedStart (uint8 u8DeviceHandle_, uint32 u32ContactHandle_, const ::most_PhonBk_fi_types_Extended::T_PhonBkContactDetailsExtended& oContactDetailsExtended_);

    /**
     * Destructor
     */
    inline virtual  ~EditContactExtendedStart();

    /**
     * Assignment operator
     */
    inline EditContactExtendedStart& operator = (const EditContactExtendedStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EditContactExtendedStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EditContactExtendedStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EditContactExtendedStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EditContactExtendedStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Handle of the device for the phone book source.
     * The vehicle phone book has a DeviceHandle = 1.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Handle of the device for the phone book source.
     * The vehicle phone book has a DeviceHandle = 1.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "u32ContactHandle"

    static const int kU32ContactHandle = 1;

    /**
     * Clears the field "u32ContactHandle".
     *
     * The field will be set to its default value. The hasU32ContactHandle()
     * method will return false.
     */
    inline void clearU32ContactHandle();

    /**
     * Checks whether the field "u32ContactHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ContactHandle()). Otherwise it will return false.
     */
    inline bool hasU32ContactHandle () const;

    /**
     * Returns the value of the member "u32ContactHandle".
     *
     * This is the globally unique ID for a particular
     * contact. The ID is unique across all currently connected
     * devices.
     *
     * @return The value of the field "u32ContactHandle"
     */
    inline uint32 getU32ContactHandle () const;

    /**
     * Sets the value of the member "u32ContactHandle".
     *
     * This is the globally unique ID for a particular
     * contact. The ID is unique across all currently connected
     * devices.
     *
     * @param u32ContactHandle The value which will be set
     */
    inline void setU32ContactHandle (uint32 u32ContactHandle_);

    // API of field "oContactDetailsExtended"

    static const int kOContactDetailsExtended = 2;

    /**
     * Clears the field "oContactDetailsExtended".
     *
     * The field will be set to its default value. The hasOContactDetailsExtended()
     * method will return false.
     */
    inline void clearOContactDetailsExtended();

    /**
     * Checks whether the field "oContactDetailsExtended" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOContactDetailsExtended()). Otherwise it will return false.
     */
    inline bool hasOContactDetailsExtended () const;

    /**
     * Returns the value of the member "oContactDetailsExtended".
     *
     * This is the type for Contact details(extended) with
     * option to add a maximum of 8 different phone numbers and their types.
     *
     * @return The value of the field "oContactDetailsExtended"
     */
    inline const ::most_PhonBk_fi_types_Extended::T_PhonBkContactDetailsExtended& getOContactDetailsExtended () const;

    /**
     * Retrieves the value of the field "oContactDetailsExtended" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oContactDetailsExtended".
     */
    inline ::most_PhonBk_fi_types_Extended::T_PhonBkContactDetailsExtended& getOContactDetailsExtendedMutable ();

    /**
     * Sets the value of the member "oContactDetailsExtended".
     *
     * This is the type for Contact details(extended) with
     * option to add a maximum of 8 different phone numbers and their types.
     *
     * @param oContactDetailsExtended The value which will be set
     */
    inline void setOContactDetailsExtended (const ::most_PhonBk_fi_types_Extended::T_PhonBkContactDetailsExtended& oContactDetailsExtended_);

    static const EditContactExtendedStart &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_u32ContactHandle ();

    inline void clear_has_u32ContactHandle ();

    inline void set_has_oContactDetailsExtended ();

    inline void clear_has_oContactDetailsExtended ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _u8DeviceHandle;

    uint32 _u32ContactHandle;

    ::most_PhonBk_fi_types_Extended::T_PhonBkContactDetailsExtended _oContactDetailsExtended;

};

/**
 * The result message of the method "EditContactExtended"
 * Updates an existing vehicle phonebook
 * contact with modifications and/or additions to the contact detail field(s) as entered by the user.
 *
 * The function is initiated upon the contact being saved.
 * The Result response includes the
 * ContactEditStatus and the ContactHandle
 * of the contact requested
 * for modification.
 */
class EditContactExtendedResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EditContactExtendedResult ();

    /**
     * Copy constructor
     */
    inline  EditContactExtendedResult (const EditContactExtendedResult &rhs);

    /**
     * All fields constructor
     */
    inline  EditContactExtendedResult (uint32 u32ContactHandle_, ::most_PhonBk_fi_types::T_e8_PhonBkContactEditStatus e8ContactEditStatusExtended_);

    /**
     * Destructor
     */
    inline virtual  ~EditContactExtendedResult();

    /**
     * Assignment operator
     */
    inline EditContactExtendedResult& operator = (const EditContactExtendedResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EditContactExtendedResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EditContactExtendedResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EditContactExtendedResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EditContactExtendedResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32ContactHandle"

    static const int kU32ContactHandle = 0;

    /**
     * Clears the field "u32ContactHandle".
     *
     * The field will be set to its default value. The hasU32ContactHandle()
     * method will return false.
     */
    inline void clearU32ContactHandle();

    /**
     * Checks whether the field "u32ContactHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ContactHandle()). Otherwise it will return false.
     */
    inline bool hasU32ContactHandle () const;

    /**
     * Returns the value of the member "u32ContactHandle".
     *
     * This is the globally unique ID for a particular
     * contact. The ID is unique across all currently connected
     * devices.
     *
     * @return The value of the field "u32ContactHandle"
     */
    inline uint32 getU32ContactHandle () const;

    /**
     * Sets the value of the member "u32ContactHandle".
     *
     * This is the globally unique ID for a particular
     * contact. The ID is unique across all currently connected
     * devices.
     *
     * @param u32ContactHandle The value which will be set
     */
    inline void setU32ContactHandle (uint32 u32ContactHandle_);

    // API of field "e8ContactEditStatusExtended"

    static const int kE8ContactEditStatusExtended = 1;

    /**
     * Clears the field "e8ContactEditStatusExtended".
     *
     * The field will be set to its default value. The hasE8ContactEditStatusExtended()
     * method will return false.
     */
    inline void clearE8ContactEditStatusExtended();

    /**
     * Checks whether the field "e8ContactEditStatusExtended" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ContactEditStatusExtended()). Otherwise it will return false.
     */
    inline bool hasE8ContactEditStatusExtended () const;

    /**
     * Returns the value of the member "e8ContactEditStatusExtended".
     *
     * Contains the status in response to a
     * EditContactExtended call.
     *
     * @return The value of the field "e8ContactEditStatusExtended"
     */
    inline ::most_PhonBk_fi_types::T_e8_PhonBkContactEditStatus getE8ContactEditStatusExtended () const;

    /**
     * Sets the value of the member "e8ContactEditStatusExtended".
     *
     * Contains the status in response to a
     * EditContactExtended call.
     *
     * @param e8ContactEditStatusExtended The value which will be set
     */
    inline void setE8ContactEditStatusExtended (::most_PhonBk_fi_types::T_e8_PhonBkContactEditStatus e8ContactEditStatusExtended_);

    static const EditContactExtendedResult &getDefaultInstance();

private:

    inline void set_has_u32ContactHandle ();

    inline void clear_has_u32ContactHandle ();

    inline void set_has_e8ContactEditStatusExtended ();

    inline void clear_has_e8ContactEditStatusExtended ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _u32ContactHandle;

    ::most_PhonBk_fi_types::T_e8_PhonBkContactEditStatus _e8ContactEditStatusExtended;

};

/**
 * The error message of 'EditContactExtended'
 */
class EditContactExtendedErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  EditContactExtendedErrorStructure ();

    /**
     * Copy constructor
     */
    inline  EditContactExtendedErrorStructure (const EditContactExtendedErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  EditContactExtendedErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~EditContactExtendedErrorStructure();

    /**
     * Assignment operator
     */
    inline EditContactExtendedErrorStructure& operator = (const EditContactExtendedErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EditContactExtendedErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EditContactExtendedErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EditContactExtendedErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EditContactExtendedErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     *
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     *
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     *
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     *
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const EditContactExtendedErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'EditContactExtended'
 */
class EditContactExtendedError  : public ::asf::core::Payload {
public:

    enum EditContactExtendedErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  EditContactExtendedError ();

   /**
     * Copy constructor
     */
    inline  EditContactExtendedError (const EditContactExtendedError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~EditContactExtendedError();

    /**
     * Assigns a new value to this object.
     */
    inline EditContactExtendedError& operator = (const EditContactExtendedError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EditContactExtendedError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EditContactExtendedError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EditContactExtendedError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EditContactExtendedError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline EditContactExtendedError::EditContactExtendedErrorField getField () const;

    inline void setField(EditContactExtendedError::EditContactExtendedErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "EditContactExtendedErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "EditContactExtendedErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const EditContactExtendedErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline EditContactExtendedErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline EditContactExtendedErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (EditContactExtendedErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "EditContactExtendedErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const EditContactExtendedErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const EditContactExtendedError &getDefaultInstance();

private:

    inline void cloneData (const EditContactExtendedError& rhs);

    inline void deleteData ();

    EditContactExtendedErrorField __field;

    union {
        EditContactExtendedErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "GetContactDetailsExtended"
 * Retrieves the detailed information for a particular
 * vehicle contact (Extended) selected and identified by the
 * supplied ContactHandle.
 */
class GetContactDetailsExtendedStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetContactDetailsExtendedStart ();

    /**
     * Copy constructor
     */
    inline  GetContactDetailsExtendedStart (const GetContactDetailsExtendedStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetContactDetailsExtendedStart (uint32 u32ContactHandle_);

    /**
     * Destructor
     */
    inline virtual  ~GetContactDetailsExtendedStart();

    /**
     * Assignment operator
     */
    inline GetContactDetailsExtendedStart& operator = (const GetContactDetailsExtendedStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetContactDetailsExtendedStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetContactDetailsExtendedStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetContactDetailsExtendedStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetContactDetailsExtendedStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32ContactHandle"

    static const int kU32ContactHandle = 0;

    /**
     * Clears the field "u32ContactHandle".
     *
     * The field will be set to its default value. The hasU32ContactHandle()
     * method will return false.
     */
    inline void clearU32ContactHandle();

    /**
     * Checks whether the field "u32ContactHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ContactHandle()). Otherwise it will return false.
     */
    inline bool hasU32ContactHandle () const;

    /**
     * Returns the value of the member "u32ContactHandle".
     *
     * This is the globally unique ID for a particular
     * device specific vehicle contact. The ID is unique across all
     * currently connected devices.
     *
     * @return The value of the field "u32ContactHandle"
     */
    inline uint32 getU32ContactHandle () const;

    /**
     * Sets the value of the member "u32ContactHandle".
     *
     * This is the globally unique ID for a particular
     * device specific vehicle contact. The ID is unique across all
     * currently connected devices.
     *
     * @param u32ContactHandle The value which will be set
     */
    inline void setU32ContactHandle (uint32 u32ContactHandle_);

    static const GetContactDetailsExtendedStart &getDefaultInstance();

private:

    inline void set_has_u32ContactHandle ();

    inline void clear_has_u32ContactHandle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _u32ContactHandle;

};

/**
 * The result message of the method "GetContactDetailsExtended"
 * Retrieves the detailed information for a particular
 * vehicle contact (Extended) selected and identified by the
 * supplied ContactHandle.
 */
class GetContactDetailsExtendedResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetContactDetailsExtendedResult ();

    /**
     * Copy constructor
     */
    inline  GetContactDetailsExtendedResult (const GetContactDetailsExtendedResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetContactDetailsExtendedResult (const ::most_PhonBk_fi_types_Extended::T_PhonBkContactDetailsExtended& oContactDetailsExtended_);

    /**
     * Destructor
     */
    inline virtual  ~GetContactDetailsExtendedResult();

    /**
     * Assignment operator
     */
    inline GetContactDetailsExtendedResult& operator = (const GetContactDetailsExtendedResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetContactDetailsExtendedResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetContactDetailsExtendedResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetContactDetailsExtendedResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetContactDetailsExtendedResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oContactDetailsExtended"

    static const int kOContactDetailsExtended = 0;

    /**
     * Clears the field "oContactDetailsExtended".
     *
     * The field will be set to its default value. The hasOContactDetailsExtended()
     * method will return false.
     */
    inline void clearOContactDetailsExtended();

    /**
     * Checks whether the field "oContactDetailsExtended" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOContactDetailsExtended()). Otherwise it will return false.
     */
    inline bool hasOContactDetailsExtended () const;

    /**
     * Returns the value of the member "oContactDetailsExtended".
     *
     * This is the type for Contact details(extended) with a maximum of 8    different phone numbers and their types.
     *
     * @return The value of the field "oContactDetailsExtended"
     */
    inline const ::most_PhonBk_fi_types_Extended::T_PhonBkContactDetailsExtended& getOContactDetailsExtended () const;

    /**
     * Retrieves the value of the field "oContactDetailsExtended" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oContactDetailsExtended".
     */
    inline ::most_PhonBk_fi_types_Extended::T_PhonBkContactDetailsExtended& getOContactDetailsExtendedMutable ();

    /**
     * Sets the value of the member "oContactDetailsExtended".
     *
     * This is the type for Contact details(extended) with a maximum of 8    different phone numbers and their types.
     *
     * @param oContactDetailsExtended The value which will be set
     */
    inline void setOContactDetailsExtended (const ::most_PhonBk_fi_types_Extended::T_PhonBkContactDetailsExtended& oContactDetailsExtended_);

    static const GetContactDetailsExtendedResult &getDefaultInstance();

private:

    inline void set_has_oContactDetailsExtended ();

    inline void clear_has_oContactDetailsExtended ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_PhonBk_fi_types_Extended::T_PhonBkContactDetailsExtended _oContactDetailsExtended;

};

/**
 * The error message of 'GetContactDetailsExtended'
 */
class GetContactDetailsExtendedErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetContactDetailsExtendedErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetContactDetailsExtendedErrorStructure (const GetContactDetailsExtendedErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetContactDetailsExtendedErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~GetContactDetailsExtendedErrorStructure();

    /**
     * Assignment operator
     */
    inline GetContactDetailsExtendedErrorStructure& operator = (const GetContactDetailsExtendedErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetContactDetailsExtendedErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetContactDetailsExtendedErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetContactDetailsExtendedErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetContactDetailsExtendedErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     *
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     *
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     *
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     *
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const GetContactDetailsExtendedErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'GetContactDetailsExtended'
 */
class GetContactDetailsExtendedError  : public ::asf::core::Payload {
public:

    enum GetContactDetailsExtendedErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetContactDetailsExtendedError ();

   /**
     * Copy constructor
     */
    inline  GetContactDetailsExtendedError (const GetContactDetailsExtendedError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetContactDetailsExtendedError();

    /**
     * Assigns a new value to this object.
     */
    inline GetContactDetailsExtendedError& operator = (const GetContactDetailsExtendedError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetContactDetailsExtendedError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetContactDetailsExtendedError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetContactDetailsExtendedError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetContactDetailsExtendedError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetContactDetailsExtendedError::GetContactDetailsExtendedErrorField getField () const;

    inline void setField(GetContactDetailsExtendedError::GetContactDetailsExtendedErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetContactDetailsExtendedErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetContactDetailsExtendedErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetContactDetailsExtendedErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetContactDetailsExtendedErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetContactDetailsExtendedErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetContactDetailsExtendedErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetContactDetailsExtendedErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetContactDetailsExtendedErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetContactDetailsExtendedError &getDefaultInstance();

private:

    inline void cloneData (const GetContactDetailsExtendedError& rhs);

    inline void deleteData ();

    GetContactDetailsExtendedErrorField __field;

    union {
        GetContactDetailsExtendedErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "ClearVehiclePhonebookExtended"
 * This method clears all vehicle phonebook entries from a specific vehicle phonebook. [VPBx]
 * It can also clear all the entries from all the vehicle phonebooks at once [1-11] (For reset to factory default.)
 */
class ClearVehiclePhonebookExtendedStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ClearVehiclePhonebookExtendedStart ();

    /**
     * Copy constructor
     */
    inline  ClearVehiclePhonebookExtendedStart (const ClearVehiclePhonebookExtendedStart &rhs);

    /**
     * All fields constructor
     */
    inline  ClearVehiclePhonebookExtendedStart (uint8 u8DeviceHandle_);

    /**
     * Destructor
     */
    inline virtual  ~ClearVehiclePhonebookExtendedStart();

    /**
     * Assignment operator
     */
    inline ClearVehiclePhonebookExtendedStart& operator = (const ClearVehiclePhonebookExtendedStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ClearVehiclePhonebookExtendedStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ClearVehiclePhonebookExtendedStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ClearVehiclePhonebookExtendedStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ClearVehiclePhonebookExtendedStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the devices(up to 10 external devices) that can be paired. Valid handles are 1..11 inclusive, where DeviceHandle 1 corresponds to VehiclePhoneBook.
     * When Device handle is set to ZERO, this interface clears all the entries from the all the vehicle phonebooks [VPB1 to VPB11].
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the devices(up to 10 external devices) that can be paired. Valid handles are 1..11 inclusive, where DeviceHandle 1 corresponds to VehiclePhoneBook.
     * When Device handle is set to ZERO, this interface clears all the entries from the all the vehicle phonebooks [VPB1 to VPB11].
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    static const ClearVehiclePhonebookExtendedStart &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8DeviceHandle;

};

/**
 * The result message of the method "ClearVehiclePhonebookExtended"
 * This method clears all vehicle phonebook entries from a specific vehicle phonebook. [VPBx]
 * It can also clear all the entries from all the vehicle phonebooks at once [1-11] (For reset to factory default.)
 */
class ClearVehiclePhonebookExtendedResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ClearVehiclePhonebookExtendedResult ();

    /**
     * Copy constructor
     */
    inline  ClearVehiclePhonebookExtendedResult (const ClearVehiclePhonebookExtendedResult &rhs);

    /**
     * All fields constructor
     */
    inline  ClearVehiclePhonebookExtendedResult (uint8 u8DeviceHandle_);

    /**
     * Destructor
     */
    inline virtual  ~ClearVehiclePhonebookExtendedResult();

    /**
     * Assignment operator
     */
    inline ClearVehiclePhonebookExtendedResult& operator = (const ClearVehiclePhonebookExtendedResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ClearVehiclePhonebookExtendedResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ClearVehiclePhonebookExtendedResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ClearVehiclePhonebookExtendedResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ClearVehiclePhonebookExtendedResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Device handle received in the method start.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Device handle received in the method start.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    static const ClearVehiclePhonebookExtendedResult &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8DeviceHandle;

};

/**
 * The error message of 'ClearVehiclePhonebookExtended'
 */
class ClearVehiclePhonebookExtendedErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  ClearVehiclePhonebookExtendedErrorStructure ();

    /**
     * Copy constructor
     */
    inline  ClearVehiclePhonebookExtendedErrorStructure (const ClearVehiclePhonebookExtendedErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  ClearVehiclePhonebookExtendedErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~ClearVehiclePhonebookExtendedErrorStructure();

    /**
     * Assignment operator
     */
    inline ClearVehiclePhonebookExtendedErrorStructure& operator = (const ClearVehiclePhonebookExtendedErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ClearVehiclePhonebookExtendedErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ClearVehiclePhonebookExtendedErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ClearVehiclePhonebookExtendedErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ClearVehiclePhonebookExtendedErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     *
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     *
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     *
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     *
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const ClearVehiclePhonebookExtendedErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'ClearVehiclePhonebookExtended'
 */
class ClearVehiclePhonebookExtendedError  : public ::asf::core::Payload {
public:

    enum ClearVehiclePhonebookExtendedErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  ClearVehiclePhonebookExtendedError ();

   /**
     * Copy constructor
     */
    inline  ClearVehiclePhonebookExtendedError (const ClearVehiclePhonebookExtendedError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~ClearVehiclePhonebookExtendedError();

    /**
     * Assigns a new value to this object.
     */
    inline ClearVehiclePhonebookExtendedError& operator = (const ClearVehiclePhonebookExtendedError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ClearVehiclePhonebookExtendedError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ClearVehiclePhonebookExtendedError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ClearVehiclePhonebookExtendedError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ClearVehiclePhonebookExtendedError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline ClearVehiclePhonebookExtendedError::ClearVehiclePhonebookExtendedErrorField getField () const;

    inline void setField(ClearVehiclePhonebookExtendedError::ClearVehiclePhonebookExtendedErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "ClearVehiclePhonebookExtendedErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "ClearVehiclePhonebookExtendedErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ClearVehiclePhonebookExtendedErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ClearVehiclePhonebookExtendedErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline ClearVehiclePhonebookExtendedErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (ClearVehiclePhonebookExtendedErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "ClearVehiclePhonebookExtendedErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const ClearVehiclePhonebookExtendedErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const ClearVehiclePhonebookExtendedError &getDefaultInstance();

private:

    inline void cloneData (const ClearVehiclePhonebookExtendedError& rhs);

    inline void deleteData ();

    ClearVehiclePhonebookExtendedErrorField __field;

    union {
        ClearVehiclePhonebookExtendedErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SetAutomaticContactDownload"
 * This method allows to define individual for a paired phone device, if the phonebook contact data is synchronized or not synchronized, when a phone device gets re-connected.
 * This setting does not affect the call history download. The call history lists are still downloaded when a phone gets connected (or refreshed after a call has ended).
 * False: The automatic download is deactivated.
 * True : The automatic download is activated.
 */
class SetAutomaticContactDownloadStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetAutomaticContactDownloadStart ();

    /**
     * Copy constructor
     */
    inline  SetAutomaticContactDownloadStart (const SetAutomaticContactDownloadStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetAutomaticContactDownloadStart (uint8 u8DeviceHandle_, bool bAutomaticDL_);

    /**
     * Destructor
     */
    inline virtual  ~SetAutomaticContactDownloadStart();

    /**
     * Assignment operator
     */
    inline SetAutomaticContactDownloadStart& operator = (const SetAutomaticContactDownloadStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetAutomaticContactDownloadStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetAutomaticContactDownloadStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetAutomaticContactDownloadStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetAutomaticContactDownloadStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Handle of the Device.
     * DeviceHandle 2, .. 11 means the setting is individual for the given device handle.
     * DeviceHandle 1 will result in a success (MethodResult), but no dedicated action is done, as the VehicleContact list is never downloaded.
     * Devicehandle 0 means that the given AutomatciDownload setting is applied to all paired phones.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Handle of the Device.
     * DeviceHandle 2, .. 11 means the setting is individual for the given device handle.
     * DeviceHandle 1 will result in a success (MethodResult), but no dedicated action is done, as the VehicleContact list is never downloaded.
     * Devicehandle 0 means that the given AutomatciDownload setting is applied to all paired phones.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "bAutomaticDL"

    static const int kBAutomaticDL = 1;

    /**
     * Clears the field "bAutomaticDL".
     *
     * The field will be set to its default value. The hasBAutomaticDL()
     * method will return false.
     */
    inline void clearBAutomaticDL();

    /**
     * Checks whether the field "bAutomaticDL" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBAutomaticDL()). Otherwise it will return false.
     */
    inline bool hasBAutomaticDL () const;

    /**
     * Returns the value of the member "bAutomaticDL".
     *
     * True : The automatic download is activated.
     * False: The automatic download is deactivated.
     *
     * @return The value of the field "bAutomaticDL"
     */
    inline bool getBAutomaticDL () const;

    /**
     * Sets the value of the member "bAutomaticDL".
     *
     * True : The automatic download is activated.
     * False: The automatic download is deactivated.
     *
     * @param bAutomaticDL The value which will be set
     */
    inline void setBAutomaticDL (bool bAutomaticDL_);

    static const SetAutomaticContactDownloadStart &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_bAutomaticDL ();

    inline void clear_has_bAutomaticDL ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8DeviceHandle;

    bool _bAutomaticDL;

};

/**
 * The result message of the method "SetAutomaticContactDownload"
 * This method allows to define individual for a paired phone device, if the phonebook contact data is synchronized or not synchronized, when a phone device gets re-connected.
 * This setting does not affect the call history download. The call history lists are still downloaded when a phone gets connected (or refreshed after a call has ended).
 * False: The automatic download is deactivated.
 * True : The automatic download is activated.
 */
class SetAutomaticContactDownloadResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetAutomaticContactDownloadResult ();

    /**
     * Copy constructor
     */
    inline  SetAutomaticContactDownloadResult (const SetAutomaticContactDownloadResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetAutomaticContactDownloadResult (uint8 u8DeviceHandle_, bool bAutomaticDL_);

    /**
     * Destructor
     */
    inline virtual  ~SetAutomaticContactDownloadResult();

    /**
     * Assignment operator
     */
    inline SetAutomaticContactDownloadResult& operator = (const SetAutomaticContactDownloadResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetAutomaticContactDownloadResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetAutomaticContactDownloadResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetAutomaticContactDownloadResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetAutomaticContactDownloadResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Device handle received in the method start.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Device handle received in the method start.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "bAutomaticDL"

    static const int kBAutomaticDL = 1;

    /**
     * Clears the field "bAutomaticDL".
     *
     * The field will be set to its default value. The hasBAutomaticDL()
     * method will return false.
     */
    inline void clearBAutomaticDL();

    /**
     * Checks whether the field "bAutomaticDL" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBAutomaticDL()). Otherwise it will return false.
     */
    inline bool hasBAutomaticDL () const;

    /**
     * Returns the value of the member "bAutomaticDL".
     *
     * AutomaticDL recevied in the method start.
     *
     * @return The value of the field "bAutomaticDL"
     */
    inline bool getBAutomaticDL () const;

    /**
     * Sets the value of the member "bAutomaticDL".
     *
     * AutomaticDL recevied in the method start.
     *
     * @param bAutomaticDL The value which will be set
     */
    inline void setBAutomaticDL (bool bAutomaticDL_);

    static const SetAutomaticContactDownloadResult &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_bAutomaticDL ();

    inline void clear_has_bAutomaticDL ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8DeviceHandle;

    bool _bAutomaticDL;

};

/**
 * The error message of 'SetAutomaticContactDownload'
 */
class SetAutomaticContactDownloadErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetAutomaticContactDownloadErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetAutomaticContactDownloadErrorStructure (const SetAutomaticContactDownloadErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetAutomaticContactDownloadErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~SetAutomaticContactDownloadErrorStructure();

    /**
     * Assignment operator
     */
    inline SetAutomaticContactDownloadErrorStructure& operator = (const SetAutomaticContactDownloadErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetAutomaticContactDownloadErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetAutomaticContactDownloadErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetAutomaticContactDownloadErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetAutomaticContactDownloadErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     *
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     *
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     *
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     *
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const SetAutomaticContactDownloadErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'SetAutomaticContactDownload'
 */
class SetAutomaticContactDownloadError  : public ::asf::core::Payload {
public:

    enum SetAutomaticContactDownloadErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetAutomaticContactDownloadError ();

   /**
     * Copy constructor
     */
    inline  SetAutomaticContactDownloadError (const SetAutomaticContactDownloadError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetAutomaticContactDownloadError();

    /**
     * Assigns a new value to this object.
     */
    inline SetAutomaticContactDownloadError& operator = (const SetAutomaticContactDownloadError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetAutomaticContactDownloadError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetAutomaticContactDownloadError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetAutomaticContactDownloadError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetAutomaticContactDownloadError& rhs) const;

    /**
     * R