/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/cca/CcaMostStream.h"
#include "asf/core/Types.h"
#include "asf/stream/MemoryStream.h"
#include "most_Src_fi_types.h"
#include "most_Src_fi_typesCcaMost.h"
#include "most_Src_fi_typesConst.h"
#include <vector>


// --------------------------------------------------------------------------
// MemoryStream functions
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// CcaMostStream functions
// --------------------------------------------------------------------------

// Serialize T_SrcContentDescription

void serializeCcaMost(const ::most_Src_fi_types::T_SrcContentDescription& in, ::asf::cca::CcaMostStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8* positionContentLength = out.getCurrentWritePos();
    uint8 contentLength = 0;
    out << contentLength;
    uint8* positionStartList = out.getCurrentWritePos();
    switch(in.getField()) {
    case ::most_Src_fi_types::T_SrcContentDescription::E_O_AUDIO_CHANNELS_RESOLUTION:
    {
        serializeCcaMost(in.getOAudioChannels_Resolution(), out, majorVersion);
        break;
    }
    case ::most_Src_fi_types::T_SrcContentDescription::E_O_AUDIO_CHANNELS_AUDIO_CHANNEL_LIST:
    {
        serializeCcaMost(in.getOAudioChannels_AudioChannelList(), out, majorVersion);
        break;
    }
    default:
        break;
    }
    uint8* positionEndList = out.getCurrentWritePos();
    contentLength = static_cast<uint8>(positionEndList - positionStartList);
    assert(contentLength <= 255);
    out.writeToPosUint8( positionContentLength, contentLength);

    {
        uint8 selectorValue = in.getField();
        out.writeToIndexPosUint8(out.popSelector(), selectorValue);
    }
}

void deserializeCcaMost(::asf::cca::CcaMostStream& in, ::most_Src_fi_types::T_SrcContentDescription& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 contentLength = 0;
    in >> contentLength;
    uint8* positionStreamEnd = in.getCurrentReadPos() + contentLength;
    switch (in.popSelector()) {
    case 0:
    {
        out.setField (::most_Src_fi_types::T_SrcContentDescription::E_O_AUDIO_CHANNELS_RESOLUTION);
        deserializeCcaMost(in, out.getOAudioChannels_ResolutionMutable(), majorVersion);
        break;
    }
    case 16:
    {
        out.setField (::most_Src_fi_types::T_SrcContentDescription::E_O_AUDIO_CHANNELS_AUDIO_CHANNEL_LIST);
        deserializeCcaMost(in, out.getOAudioChannels_AudioChannelListMutable(), majorVersion);
        break;
    }
    default:
        break;
    }
    assert(in.getCurrentReadPos() == positionStreamEnd);
    (void)positionStreamEnd; // make release build happy
}

// Serialize T_SrcAudioChannels_Resolution

void serializeCcaMost(const ::most_Src_fi_types::T_SrcAudioChannels_Resolution& in, ::asf::cca::CcaMostStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU8AudioChannels();
    out << in.getU8Resolution();
}

void deserializeCcaMost(::asf::cca::CcaMostStream& in, ::most_Src_fi_types::T_SrcAudioChannels_Resolution& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o0;
    in >> o0;
    out.setU8AudioChannels(o0);
    uint8 o1;
    in >> o1;
    out.setU8Resolution(o1);
}

// Serialize T_SrcAudioChannels_AudioChannelList

void serializeCcaMost(const ::most_Src_fi_types::T_SrcAudioChannels_AudioChannelList& in, ::asf::cca::CcaMostStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU8AudioChannels();
    {
        uint8* positionContentLength_o3 = out.getCurrentWritePos();
        uint8 contentLength_o4 = 0;
        out << contentLength_o4;
        uint8* positionStartList_o5 = out.getCurrentWritePos();
        ::std::vector< ::most_Src_fi_types::T_SrcAudioChannelListItem >::const_iterator o2;
        for ( o2 = in.getOAudioChannelList().begin();  o2 != in.getOAudioChannelList().end(); ++ o2){
            serializeCcaMost((*o2), out, majorVersion);
        }
        uint8* positionEndList_o6 = out.getCurrentWritePos();
        contentLength_o4 = static_cast<uint8>(positionEndList_o6 - positionStartList_o5);
        assert(contentLength_o4 <= 255);
        out.writeToPosUint8( positionContentLength_o3, contentLength_o4);
    }
}

void deserializeCcaMost(::asf::cca::CcaMostStream& in, ::most_Src_fi_types::T_SrcAudioChannels_AudioChannelList& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o7;
    in >> o7;
    out.setU8AudioChannels(o7);
    {
        uint8 contentLength_o8 = 0;
        in >> contentLength_o8;
        out.getOAudioChannelListMutable().clear ();
        uint8* positionStreamEnd_o9 = in.getCurrentReadPos() + contentLength_o8;
        while(in.getCurrentReadPos() < positionStreamEnd_o9) {
            ::most_Src_fi_types::T_SrcAudioChannelListItem o10;
            deserializeCcaMost(in, o10, majorVersion);
            out.getOAudioChannelListMutable().push_back (o10);
        }
    }
}

// Serialize T_SrcAudioChannelListItem

void serializeCcaMost(const ::most_Src_fi_types::T_SrcAudioChannelListItem& in, ::asf::cca::CcaMostStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8AudioChannelName();
    out << in.getU8BitsPerSample();
}

void deserializeCcaMost(::asf::cca::CcaMostStream& in, ::most_Src_fi_types::T_SrcAudioChannelListItem& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o11;
    in >> o11;
    out.setE8AudioChannelName((::most_Src_fi_types::T_e8_SrcAudioChannelName)o11);
    uint8 o12;
    in >> o12;
    out.setU8BitsPerSample(o12);
}

