/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/cca/CcaMostStream.h"
#include "asf/core/Types.h"
#include "asf/stream/MemoryStream.h"
#include "most_Msg_fi_types.h"
#include "most_Msg_fi_typesCcaMost.h"
#include "most_Msg_fi_typesConst.h"
#include <vector>


// --------------------------------------------------------------------------
// MemoryStream functions
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// CcaMostStream functions
// --------------------------------------------------------------------------

// Serialize T_MsgMessageListSliceResultItem

void serializeCcaMost(const ::most_Msg_fi_types::T_MsgMessageListSliceResultItem& in, ::asf::cca::CcaMostStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCcaMost(in.getOMessageHandle(), out, majorVersion);
    serializeCcaMost(in.getOMessageDateTime(), out, majorVersion);
    out.writeMostString(in.getSSubject());
    out.writeMostString(in.getSShortMessage());
    out << (uint8) in.getBAttachmentFlag();
    out << (uint8) in.getE8MessageType();
    out << (uint8) in.getE8SendMessageResultType();
    out << (uint8) in.getBReadStatusFlag();
    out.writeMostString(in.getSFirstName());
    out.writeMostString(in.getSLastName());
    out.writeMostString(in.getSEmailAddress());
    out.writeMostString(in.getSPhoneNumber());
    out << in.getU32ContactHandle();
    out << (uint8) in.getE8PlaybackState();
}

void deserializeCcaMost(::asf::cca::CcaMostStream& in, ::most_Msg_fi_types::T_MsgMessageListSliceResultItem& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCcaMost(in, out.getOMessageHandleMutable(), majorVersion);
    deserializeCcaMost(in, out.getOMessageDateTimeMutable(), majorVersion);
    in.readMostString(out.getSSubjectMutable());
    in.readMostString(out.getSShortMessageMutable());
    bool o0;
    in >> o0;
    out.setBAttachmentFlag(o0);
    uint8 o1;
    in >> o1;
    out.setE8MessageType((::most_Msg_fi_types::T_e8_MsgMessageType)o1);
    uint8 o2;
    in >> o2;
    out.setE8SendMessageResultType((::most_Msg_fi_types::T_e8_MsgSendMessageResultType)o2);
    bool o3;
    in >> o3;
    out.setBReadStatusFlag(o3);
    in.readMostString(out.getSFirstNameMutable());
    in.readMostString(out.getSLastNameMutable());
    in.readMostString(out.getSEmailAddressMutable());
    in.readMostString(out.getSPhoneNumberMutable());
    uint32 o4;
    in >> o4;
    out.setU32ContactHandle(o4);
    uint8 o5;
    in >> o5;
    out.setE8PlaybackState((::most_Msg_fi_types::T_e8_MsgPlaybackState)o5);
}

// Serialize T_MsgMessageHandle

void serializeCcaMost(const ::most_Msg_fi_types::T_MsgMessageHandle& in, ::asf::cca::CcaMostStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8* positionContentLength = out.getCurrentWritePos();
    uint8 contentLength = 0;
    out << contentLength;
    uint8* positionStartList = out.getCurrentWritePos();
    out << in.getU8DeviceHandle();
    out << in.getU32MsgHandleUpper();
    out << in.getU32MsgHandleLower();
    uint8* positionEndList = out.getCurrentWritePos();
    contentLength = static_cast<uint8>(positionEndList - positionStartList);
    assert(contentLength <= 255);
    out.writeToPosUint8( positionContentLength, contentLength);
}

void deserializeCcaMost(::asf::cca::CcaMostStream& in, ::most_Msg_fi_types::T_MsgMessageHandle& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 contentLength = 0;
    in >> contentLength;
    uint8* positionStreamEnd = in.getCurrentReadPos() + contentLength;
    uint8 o6;
    in >> o6;
    out.setU8DeviceHandle(o6);
    uint32 o7;
    in >> o7;
    out.setU32MsgHandleUpper(o7);
    uint32 o8;
    in >> o8;
    out.setU32MsgHandleLower(o8);
    assert(in.getCurrentReadPos() == positionStreamEnd);
    (void)positionStreamEnd; // make release build happy
}

// Serialize T_MsgMessageDateTime

void serializeCcaMost(const ::most_Msg_fi_types::T_MsgMessageDateTime& in, ::asf::cca::CcaMostStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8* positionContentLength = out.getCurrentWritePos();
    uint8 contentLength = 0;
    out << contentLength;
    uint8* positionStartList = out.getCurrentWritePos();
    serializeCcaMost(in.getOMessageDate(), out, majorVersion);
    serializeCcaMost(in.getOMessageTime(), out, majorVersion);
    uint8* positionEndList = out.getCurrentWritePos();
    contentLength = static_cast<uint8>(positionEndList - positionStartList);
    assert(contentLength <= 255);
    out.writeToPosUint8( positionContentLength, contentLength);
}

void deserializeCcaMost(::asf::cca::CcaMostStream& in, ::most_Msg_fi_types::T_MsgMessageDateTime& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 contentLength = 0;
    in >> contentLength;
    uint8* positionStreamEnd = in.getCurrentReadPos() + contentLength;
    deserializeCcaMost(in, out.getOMessageDateMutable(), majorVersion);
    deserializeCcaMost(in, out.getOMessageTimeMutable(), majorVersion);
    assert(in.getCurrentReadPos() == positionStreamEnd);
    (void)positionStreamEnd; // make release build happy
}

// Serialize T_MsgMessageDate

void serializeCcaMost(const ::most_Msg_fi_types::T_MsgMessageDate& in, ::asf::cca::CcaMostStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8* positionContentLength = out.getCurrentWritePos();
    uint8 contentLength = 0;
    out << contentLength;
    uint8* positionStartList = out.getCurrentWritePos();
    out.writeMostString(in.getSCldrYear());
    out.writeMostString(in.getSCldrMonth());
    out.writeMostString(in.getSCldrDay());
    uint8* positionEndList = out.getCurrentWritePos();
    contentLength = static_cast<uint8>(positionEndList - positionStartList);
    assert(contentLength <= 255);
    out.writeToPosUint8( positionContentLength, contentLength);
}

void deserializeCcaMost(::asf::cca::CcaMostStream& in, ::most_Msg_fi_types::T_MsgMessageDate& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 contentLength = 0;
    in >> contentLength;
    uint8* positionStreamEnd = in.getCurrentReadPos() + contentLength;
    in.readMostString(out.getSCldrYearMutable());
    in.readMostString(out.getSCldrMonthMutable());
    in.readMostString(out.getSCldrDayMutable());
    assert(in.getCurrentReadPos() == positionStreamEnd);
    (void)positionStreamEnd; // make release build happy
}

// Serialize T_MsgMessageTime

void serializeCcaMost(const ::most_Msg_fi_types::T_MsgMessageTime& in, ::asf::cca::CcaMostStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8* positionContentLength = out.getCurrentWritePos();
    uint8 contentLength = 0;
    out << contentLength;
    uint8* positionStartList = out.getCurrentWritePos();
    out.writeMostString(in.getSHours());
    out.writeMostString(in.getSMinutes());
    out.writeMostString(in.getSSeconds());
    uint8* positionEndList = out.getCurrentWritePos();
    contentLength = static_cast<uint8>(positionEndList - positionStartList);
    assert(contentLength <= 255);
    out.writeToPosUint8( positionContentLength, contentLength);
}

void deserializeCcaMost(::asf::cca::CcaMostStream& in, ::most_Msg_fi_types::T_MsgMessageTime& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 contentLength = 0;
    in >> contentLength;
    uint8* positionStreamEnd = in.getCurrentReadPos() + contentLength;
    in.readMostString(out.getSHoursMutable());
    in.readMostString(out.getSMinutesMutable());
    in.readMostString(out.getSSecondsMutable());
    assert(in.getCurrentReadPos() == positionStreamEnd);
    (void)positionStreamEnd; // make release build happy
}

// Serialize T_MsgFolderListResultItem

void serializeCcaMost(const ::most_Msg_fi_types::T_MsgFolderListResultItem& in, ::asf::cca::CcaMostStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU32FolderHandle();
    out.writeMostString(in.getSFolderName());
    out << (uint8) in.getE8FolderType();
    out << in.getU8NumSubfolders();
    out << in.getU16NumMessages();
    out << in.getU16NumUnreadMessages();
}

void deserializeCcaMost(::asf::cca::CcaMostStream& in, ::most_Msg_fi_types::T_MsgFolderListResultItem& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o9;
    in >> o9;
    out.setU32FolderHandle(o9);
    in.readMostString(out.getSFolderNameMutable());
    uint8 o10;
    in >> o10;
    out.setE8FolderType((::most_Msg_fi_types::T_e8_MsgFolderType)o10);
    uint8 o11;
    in >> o11;
    out.setU8NumSubfolders(o11);
    uint16 o12;
    in >> o12;
    out.setU16NumMessages(o12);
    uint16 o13;
    in >> o13;
    out.setU16NumUnreadMessages(o13);
}

// Serialize T_MsgAccountListResultItem

void serializeCcaMost(const ::most_Msg_fi_types::T_MsgAccountListResultItem& in, ::asf::cca::CcaMostStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU16AccountHandle();
    out.writeMostString(in.getSAccountName());
    out << (uint8) in.getBActiveAccountStatus();
}

void deserializeCcaMost(::asf::cca::CcaMostStream& in, ::most_Msg_fi_types::T_MsgAccountListResultItem& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o14;
    in >> o14;
    out.setU16AccountHandle(o14);
    in.readMostString(out.getSAccountNameMutable());
    bool o15;
    in >> o15;
    out.setBActiveAccountStatus(o15);
}

// Serialize T_MsgActiveAccount

void serializeCcaMost(const ::most_Msg_fi_types::T_MsgActiveAccount& in, ::asf::cca::CcaMostStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU16AccountHandle();
    out.writeMostString(in.getSAccountName());
}

void deserializeCcaMost(::asf::cca::CcaMostStream& in, ::most_Msg_fi_types::T_MsgActiveAccount& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o16;
    in >> o16;
    out.setU16AccountHandle(o16);
    in.readMostString(out.getSAccountNameMutable());
}

// Serialize T_MsgMessageDetailsResult

void serializeCcaMost(const ::most_Msg_fi_types::T_MsgMessageDetailsResult& in, ::asf::cca::CcaMostStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCcaMost(in.getOMessageDateTime(), out, majorVersion);
    out.writeMostString(in.getSSubject());
    out.writeMostString(in.getSShortMessage());
    out << in.getU8NumAttachments();
    out << in.getU8NumBodyParts();
    {
        uint8* positionContentLength_o18 = out.getCurrentWritePos();
        uint8 contentLength_o19 = 0;
        out << contentLength_o19;
        uint8* positionStartList_o20 = out.getCurrentWritePos();
        ::std::vector< uint8 >::const_iterator o17;
        for ( o17 = in.getOMsgBodyActionElementTags().begin();  o17 != in.getOMsgBodyActionElementTags().end(); ++ o17){
            out << (*o17);
        }
        uint8* positionEndList_o21 = out.getCurrentWritePos();
        contentLength_o19 = static_cast<uint8>(positionEndList_o21 - positionStartList_o20);
        assert(contentLength_o19 <= 255);
        out.writeToPosUint8( positionContentLength_o18, contentLength_o19);
    }
    {
        ::std::vector< ::most_Msg_fi_types::T_MsgAddressFieldItem >::const_iterator o22;
        for (o22 = in.getOAddressField().begin(); o22 != in.getOAddressField().end(); ++o22) {
            serializeCcaMost((*o22), out, majorVersion);
        }
    }
}

void deserializeCcaMost(::asf::cca::CcaMostStream& in, ::most_Msg_fi_types::T_MsgMessageDetailsResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCcaMost(in, out.getOMessageDateTimeMutable(), majorVersion);
    in.readMostString(out.getSSubjectMutable());
    in.readMostString(out.getSShortMessageMutable());
    uint8 o23;
    in >> o23;
    out.setU8NumAttachments(o23);
    uint8 o24;
    in >> o24;
    out.setU8NumBodyParts(o24);
    {
        uint8 contentLength_o25 = 0;
        in >> contentLength_o25;
        out.getOMsgBodyActionElementTagsMutable().clear ();
        uint8* positionStreamEnd_o26 = in.getCurrentReadPos() + contentLength_o25;
        while(in.getCurrentReadPos() < positionStreamEnd_o26) {
            uint8 o27;
            in >> o27;
            out.getOMsgBodyActionElementTagsMutable().push_back(o27);
        }
    }
    {
        out.getOAddressFieldMutable().clear ();
        while(in.getCurrentReadPos() < in.getEndPos()) {
            ::most_Msg_fi_types::T_MsgAddressFieldItem o28;
            deserializeCcaMost(in, o28, majorVersion);
            out.getOAddressFieldMutable().push_back (o28);
        }
    }
}

// Serialize T_MsgAddressFieldItem

void serializeCcaMost(const ::most_Msg_fi_types::T_MsgAddressFieldItem& in, ::asf::cca::CcaMostStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8AddressFieldType();
    out.writeMostString(in.getSFirstName());
    out.writeMostString(in.getSLastName());
    out.writeMostString(in.getSEmailAddress());
    out.writeMostString(in.getSPhoneNumber());
}

void deserializeCcaMost(::asf::cca::CcaMostStream& in, ::most_Msg_fi_types::T_MsgAddressFieldItem& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o29;
    in >> o29;
    out.setE8AddressFieldType((::most_Msg_fi_types::T_e8_MsgAddressFieldType)o29);
    in.readMostString(out.getSFirstNameMutable());
    in.readMostString(out.getSLastNameMutable());
    in.readMostString(out.getSEmailAddressMutable());
    in.readMostString(out.getSPhoneNumberMutable());
}

// Serialize T_MsgAttachmentListItem

void serializeCcaMost(const ::most_Msg_fi_types::T_MsgAttachmentListItem& in, ::asf::cca::CcaMostStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU16AttachmentHandle();
    out << (uint8) in.getE8AttachmentType();
    out.writeMostString(in.getSFilename());
}

void deserializeCcaMost(::asf::cca::CcaMostStream& in, ::most_Msg_fi_types::T_MsgAttachmentListItem& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o30;
    in >> o30;
    out.setU16AttachmentHandle(o30);
    uint8 o31;
    in >> o31;
    out.setE8AttachmentType((::most_Msg_fi_types::T_e8_MsgAttachmentType)o31);
    in.readMostString(out.getSFilenameMutable());
}

// Serialize T_MsgBodyPartListItem

void serializeCcaMost(const ::most_Msg_fi_types::T_MsgBodyPartListItem& in, ::asf::cca::CcaMostStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out.writeMostString(in.getSBodyTitle());
    out.writeMostString(in.getSBodyText());
}

void deserializeCcaMost(::asf::cca::CcaMostStream& in, ::most_Msg_fi_types::T_MsgBodyPartListItem& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    in.readMostString(out.getSBodyTitleMutable());
    in.readMostString(out.getSBodyTextMutable());
}

// Serialize T_MsgPredefinedMessageListResultItem

void serializeCcaMost(const ::most_Msg_fi_types::T_MsgPredefinedMessageListResultItem& in, ::asf::cca::CcaMostStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU16PredefinedMessageHandle();
    out << (uint8) in.getE8PredefinedMessageType();
    out.writeMostString(in.getSPredefinedMessageText());
}

void deserializeCcaMost(::asf::cca::CcaMostStream& in, ::most_Msg_fi_types::T_MsgPredefinedMessageListResultItem& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o32;
    in >> o32;
    out.setU16PredefinedMessageHandle(o32);
    uint8 o33;
    in >> o33;
    out.setE8PredefinedMessageType((::most_Msg_fi_types::T_e8_MsgPredefinedMessageType)o33);
    in.readMostString(out.getSPredefinedMessageTextMutable());
}

