/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef MOST_MSG_FIPROXY_H
#define MOST_MSG_FIPROXY_H

#include "MOST_Msg_FI.h"
#include "asf/cca/CcaProxy.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "fi_basetypes_most.h"
#include "most_Msg_fi_types.h"
#include "most_Msg_fi_typesConst.h"
#include "most_Msg_fi_types_Extended.h"
#include "most_Msg_fi_types_ExtendedConst.h"
#include "most_Src_fi_typesConst.h"

namespace MOST_Msg_FI {

class MOST_Msg_FIProxy;

class AddCustomMessageCallbackIF {
public:
    virtual ~AddCustomMessageCallbackIF() {}

    virtual void onAddCustomMessageError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< AddCustomMessageError >& error) = 0;

    virtual void onAddCustomMessageResult(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< AddCustomMessageResult >& result) = 0;
};

class AddPredefinedMessageCallbackIF {
public:
    virtual ~AddPredefinedMessageCallbackIF() {}

    virtual void onAddPredefinedMessageError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< AddPredefinedMessageError >& error) = 0;

    virtual void onAddPredefinedMessageResult(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< AddPredefinedMessageResult >& result) = 0;
};

class AddPredefinedMessageExtendedCallbackIF {
public:
    virtual ~AddPredefinedMessageExtendedCallbackIF() {}

    virtual void onAddPredefinedMessageExtendedError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< AddPredefinedMessageExtendedError >& error) = 0;

    virtual void onAddPredefinedMessageExtendedResult(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< AddPredefinedMessageExtendedResult >& result) = 0;
};

class AllocateCallbackIF {
public:
    virtual ~AllocateCallbackIF() {}

    virtual void onAllocateError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< AllocateError >& error) = 0;

    virtual void onAllocateResult(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< AllocateResult >& result) = 0;
};

class AudioAttachmentPlaybackCallbackIF {
public:
    virtual ~AudioAttachmentPlaybackCallbackIF() {}

    virtual void onAudioAttachmentPlaybackError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< AudioAttachmentPlaybackError >& error) = 0;

    virtual void onAudioAttachmentPlaybackResult(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< AudioAttachmentPlaybackResult >& result) = 0;
};

class AudioAttachmentPlaybackStateCallbackIF {
public:
    virtual ~AudioAttachmentPlaybackStateCallbackIF() {}

    virtual void onAudioAttachmentPlaybackStateError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< AudioAttachmentPlaybackStateError >& error) = 0;

    virtual void onAudioAttachmentPlaybackStateStatus(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< AudioAttachmentPlaybackStateStatus >& status) = 0;
};

class AudioMessageRecordingStateCallbackIF {
public:
    virtual ~AudioMessageRecordingStateCallbackIF() {}

    virtual void onAudioMessageRecordingStateError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< AudioMessageRecordingStateError >& error) = 0;

    virtual void onAudioMessageRecordingStateStatus(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< AudioMessageRecordingStateStatus >& status) = 0;
};

class AutoReplyOnOffListCallbackIF {
public:
    virtual ~AutoReplyOnOffListCallbackIF() {}

    virtual void onAutoReplyOnOffListError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< AutoReplyOnOffListError >& error) = 0;

    virtual void onAutoReplyOnOffListStatus(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< AutoReplyOnOffListStatus >& status) = 0;
};

class AutoReplyTextListCallbackIF {
public:
    virtual ~AutoReplyTextListCallbackIF() {}

    virtual void onAutoReplyTextListError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< AutoReplyTextListError >& error) = 0;

    virtual void onAutoReplyTextListStatus(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< AutoReplyTextListStatus >& status) = 0;
};

class ChangeAccountCallbackIF {
public:
    virtual ~ChangeAccountCallbackIF() {}

    virtual void onChangeAccountError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< ChangeAccountError >& error) = 0;

    virtual void onChangeAccountResult(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< ChangeAccountResult >& result) = 0;
};

class ClearUserMessagingInfoCallbackIF {
public:
    virtual ~ClearUserMessagingInfoCallbackIF() {}

    virtual void onClearUserMessagingInfoError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< ClearUserMessagingInfoError >& error) = 0;

    virtual void onClearUserMessagingInfoResult(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< ClearUserMessagingInfoResult >& result) = 0;
};

class ConnectMapProfileCallbackIF {
public:
    virtual ~ConnectMapProfileCallbackIF() {}

    virtual void onConnectMapProfileError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< ConnectMapProfileError >& error) = 0;

    virtual void onConnectMapProfileResult(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< ConnectMapProfileResult >& result) = 0;
};

class CreateMessageCallbackIF {
public:
    virtual ~CreateMessageCallbackIF() {}

    virtual void onCreateMessageError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< CreateMessageError >& error) = 0;

    virtual void onCreateMessageResult(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< CreateMessageResult >& result) = 0;
};

class CreateMessageListCallbackIF {
public:
    virtual ~CreateMessageListCallbackIF() {}

    virtual void onCreateMessageListError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< CreateMessageListError >& error) = 0;

    virtual void onCreateMessageListResult(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< CreateMessageListResult >& result) = 0;
};

class DeAllocateCallbackIF {
public:
    virtual ~DeAllocateCallbackIF() {}

    virtual void onDeAllocateError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< DeAllocateError >& error) = 0;

    virtual void onDeAllocateResult(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< DeAllocateResult >& result) = 0;
};

class DeleteMessageCallbackIF {
public:
    virtual ~DeleteMessageCallbackIF() {}

    virtual void onDeleteMessageError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< DeleteMessageError >& error) = 0;

    virtual void onDeleteMessageResult(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< DeleteMessageResult >& result) = 0;
};

class DeletePredefinedMessageCallbackIF {
public:
    virtual ~DeletePredefinedMessageCallbackIF() {}

    virtual void onDeletePredefinedMessageError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< DeletePredefinedMessageError >& error) = 0;

    virtual void onDeletePredefinedMessageResult(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< DeletePredefinedMessageResult >& result) = 0;
};

class EditPredefinedMessageCallbackIF {
public:
    virtual ~EditPredefinedMessageCallbackIF() {}

    virtual void onEditPredefinedMessageError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< EditPredefinedMessageError >& error) = 0;

    virtual void onEditPredefinedMessageResult(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< EditPredefinedMessageResult >& result) = 0;
};

class EmailAlertEnableCallbackIF {
public:
    virtual ~EmailAlertEnableCallbackIF() {}

    virtual void onEmailAlertEnableError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< EmailAlertEnableError >& error) = 0;

    virtual void onEmailAlertEnableStatus(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< EmailAlertEnableStatus >& status) = 0;
};

class FolderListChangeCallbackIF {
public:
    virtual ~FolderListChangeCallbackIF() {}

    virtual void onFolderListChangeError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< FolderListChangeError >& error) = 0;

    virtual void onFolderListChangeStatus(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< FolderListChangeStatus >& status) = 0;
};

class GetAttachmentListCallbackIF {
public:
    virtual ~GetAttachmentListCallbackIF() {}

    virtual void onGetAttachmentListError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< GetAttachmentListError >& error) = 0;

    virtual void onGetAttachmentListResult(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< GetAttachmentListResult >& result) = 0;
};

class GetBodyPartListCallbackIF {
public:
    virtual ~GetBodyPartListCallbackIF() {}

    virtual void onGetBodyPartListError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< GetBodyPartListError >& error) = 0;

    virtual void onGetBodyPartListResult(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< GetBodyPartListResult >& result) = 0;
};

class GetConversationMessagesCallbackIF {
public:
    virtual ~GetConversationMessagesCallbackIF() {}

    virtual void onGetConversationMessagesError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< GetConversationMessagesError >& error) = 0;

    virtual void onGetConversationMessagesResult(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< GetConversationMessagesResult >& result) = 0;
};

class GetImageAttachmentCallbackIF {
public:
    virtual ~GetImageAttachmentCallbackIF() {}

    virtual void onGetImageAttachmentError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< GetImageAttachmentError >& error) = 0;

    virtual void onGetImageAttachmentResult(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< GetImageAttachmentResult >& result) = 0;
};

class GetImageAttachmentInfoCallbackIF {
public:
    virtual ~GetImageAttachmentInfoCallbackIF() {}

    virtual void onGetImageAttachmentInfoError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< GetImageAttachmentInfoError >& error) = 0;

    virtual void onGetImageAttachmentInfoResult(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< GetImageAttachmentInfoResult >& result) = 0;
};

class GetMessageCallbackIF {
public:
    virtual ~GetMessageCallbackIF() {}

    virtual void onGetMessageError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< GetMessageError >& error) = 0;

    virtual void onGetMessageResult(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< GetMessageResult >& result) = 0;
};

class GetMsgBodyActionElementCallbackIF {
public:
    virtual ~GetMsgBodyActionElementCallbackIF() {}

    virtual void onGetMsgBodyActionElementError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< GetMsgBodyActionElementError >& error) = 0;

    virtual void onGetMsgBodyActionElementResult(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< GetMsgBodyActionElementResult >& result) = 0;
};

class GetSliceConversationDetailsCallbackIF {
public:
    virtual ~GetSliceConversationDetailsCallbackIF() {}

    virtual void onGetSliceConversationDetailsError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< GetSliceConversationDetailsError >& error) = 0;

    virtual void onGetSliceConversationDetailsResult(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< GetSliceConversationDetailsResult >& result) = 0;
};

class MapDeviceCapabilitiesCallbackIF {
public:
    virtual ~MapDeviceCapabilitiesCallbackIF() {}

    virtual void onMapDeviceCapabilitiesError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< MapDeviceCapabilitiesError >& error) = 0;

    virtual void onMapDeviceCapabilitiesStatus(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< MapDeviceCapabilitiesStatus >& status) = 0;
};

class MapDeviceCapabilitiesExtendedCallbackIF {
public:
    virtual ~MapDeviceCapabilitiesExtendedCallbackIF() {}

    virtual void onMapDeviceCapabilitiesExtendedError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< MapDeviceCapabilitiesExtendedError >& error) = 0;

    virtual void onMapDeviceCapabilitiesExtendedStatus(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< MapDeviceCapabilitiesExtendedStatus >& status) = 0;
};

class MessageListChangeCallbackIF {
public:
    virtual ~MessageListChangeCallbackIF() {}

    virtual void onMessageListChangeError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< MessageListChangeError >& error) = 0;

    virtual void onMessageListChangeStatus(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< MessageListChangeStatus >& status) = 0;
};

class MessageNotificationCallbackIF {
public:
    virtual ~MessageNotificationCallbackIF() {}

    virtual void onMessageNotificationError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< MessageNotificationError >& error) = 0;

    virtual void onMessageNotificationStatus(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< MessageNotificationStatus >& status) = 0;
};

class MessagingAudioPlaybackStateCallbackIF {
public:
    virtual ~MessagingAudioPlaybackStateCallbackIF() {}

    virtual void onMessagingAudioPlaybackStateError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< MessagingAudioPlaybackStateError >& error) = 0;

    virtual void onMessagingAudioPlaybackStateStatus(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< MessagingAudioPlaybackStateStatus >& status) = 0;
};

class MessagingDeviceConnectionCallbackIF {
public:
    virtual ~MessagingDeviceConnectionCallbackIF() {}

    virtual void onMessagingDeviceConnectionError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< MessagingDeviceConnectionError >& error) = 0;

    virtual void onMessagingDeviceConnectionStatus(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< MessagingDeviceConnectionStatus >& status) = 0;
};

class MessagingLanguageCallbackIF {
public:
    virtual ~MessagingLanguageCallbackIF() {}

    virtual void onMessagingLanguageError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< MessagingLanguageError >& error) = 0;

    virtual void onMessagingLanguageStatus(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< MessagingLanguageStatus >& status) = 0;
};

class MessagingOnOffCallbackIF {
public:
    virtual ~MessagingOnOffCallbackIF() {}

    virtual void onMessagingOnOffError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< MessagingOnOffError >& error) = 0;

    virtual void onMessagingOnOffStatus(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< MessagingOnOffStatus >& status) = 0;
};

class MessagingOnOffListCallbackIF {
public:
    virtual ~MessagingOnOffListCallbackIF() {}

    virtual void onMessagingOnOffListError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< MessagingOnOffListError >& error) = 0;

    virtual void onMessagingOnOffListStatus(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< MessagingOnOffListStatus >& status) = 0;
};

class PlaybackAudioMessageCallbackIF {
public:
    virtual ~PlaybackAudioMessageCallbackIF() {}

    virtual void onPlaybackAudioMessageError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< PlaybackAudioMessageError >& error) = 0;

    virtual void onPlaybackAudioMessageResult(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< PlaybackAudioMessageResult >& result) = 0;
};

class PredefinedMessageListCallbackIF {
public:
    virtual ~PredefinedMessageListCallbackIF() {}

    virtual void onPredefinedMessageListError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< PredefinedMessageListError >& error) = 0;

    virtual void onPredefinedMessageListStatus(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< PredefinedMessageListStatus >& status) = 0;
};

class PredefinedMessageListExtendedCallbackIF {
public:
    virtual ~PredefinedMessageListExtendedCallbackIF() {}

    virtual void onPredefinedMessageListExtendedError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< PredefinedMessageListExtendedError >& error) = 0;

    virtual void onPredefinedMessageListExtendedStatus(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< PredefinedMessageListExtendedStatus >& status) = 0;
};

class ProvideMessageBodyCallbackIF {
public:
    virtual ~ProvideMessageBodyCallbackIF() {}

    virtual void onProvideMessageBodyError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< ProvideMessageBodyError >& error) = 0;

    virtual void onProvideMessageBodyResult(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< ProvideMessageBodyResult >& result) = 0;
};

class ProvideMessageHeaderCallbackIF {
public:
    virtual ~ProvideMessageHeaderCallbackIF() {}

    virtual void onProvideMessageHeaderError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< ProvideMessageHeaderError >& error) = 0;

    virtual void onProvideMessageHeaderResult(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< ProvideMessageHeaderResult >& result) = 0;
};

class ReadMessageAloudCallbackIF {
public:
    virtual ~ReadMessageAloudCallbackIF() {}

    virtual void onReadMessageAloudError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< ReadMessageAloudError >& error) = 0;

    virtual void onReadMessageAloudResult(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< ReadMessageAloudResult >& result) = 0;
};

class ReadMessageAloudExtendedCallbackIF {
public:
    virtual ~ReadMessageAloudExtendedCallbackIF() {}

    virtual void onReadMessageAloudExtendedError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< ReadMessageAloudExtendedError >& error) = 0;

    virtual void onReadMessageAloudExtendedResult(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< ReadMessageAloudExtendedResult >& result) = 0;
};

class RecordAudioMessageCallbackIF {
public:
    virtual ~RecordAudioMessageCallbackIF() {}

    virtual void onRecordAudioMessageError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< RecordAudioMessageError >& error) = 0;

    virtual void onRecordAudioMessageResult(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< RecordAudioMessageResult >& result) = 0;
};

class RecordedAudioMessageInfoCallbackIF {
public:
    virtual ~RecordedAudioMessageInfoCallbackIF() {}

    virtual void onRecordedAudioMessageInfoError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< RecordedAudioMessageInfoError >& error) = 0;

    virtual void onRecordedAudioMessageInfoStatus(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< RecordedAudioMessageInfoStatus >& status) = 0;
};

class RecoverMessageCallbackIF {
public:
    virtual ~RecoverMessageCallbackIF() {}

    virtual void onRecoverMessageError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< RecoverMessageError >& error) = 0;

    virtual void onRecoverMessageResult(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< RecoverMessageResult >& result) = 0;
};

class ReleaseMessageListCallbackIF {
public:
    virtual ~ReleaseMessageListCallbackIF() {}

    virtual void onReleaseMessageListError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< ReleaseMessageListError >& error) = 0;

    virtual void onReleaseMessageListResult(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< ReleaseMessageListResult >& result) = 0;
};

class RequestAccountListCallbackIF {
public:
    virtual ~RequestAccountListCallbackIF() {}

    virtual void onRequestAccountListError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< RequestAccountListError >& error) = 0;

    virtual void onRequestAccountListResult(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< RequestAccountListResult >& result) = 0;
};

class RequestFolderListCallbackIF {
public:
    virtual ~RequestFolderListCallbackIF() {}

    virtual void onRequestFolderListError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< RequestFolderListError >& error) = 0;

    virtual void onRequestFolderListResult(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< RequestFolderListResult >& result) = 0;
};

class RequestSliceConversationListCallbackIF {
public:
    virtual ~RequestSliceConversationListCallbackIF() {}

    virtual void onRequestSliceConversationListError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< RequestSliceConversationListError >& error) = 0;

    virtual void onRequestSliceConversationListResult(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< RequestSliceConversationListResult >& result) = 0;
};

class RequestSliceMessageListCallbackIF {
public:
    virtual ~RequestSliceMessageListCallbackIF() {}

    virtual void onRequestSliceMessageListError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< RequestSliceMessageListError >& error) = 0;

    virtual void onRequestSliceMessageListResult(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< RequestSliceMessageListResult >& result) = 0;
};

class SaveSentEmailCallbackIF {
public:
    virtual ~SaveSentEmailCallbackIF() {}

    virtual void onSaveSentEmailError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< SaveSentEmailError >& error) = 0;

    virtual void onSaveSentEmailStatus(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< SaveSentEmailStatus >& status) = 0;
};

class SaveSentTextCallbackIF {
public:
    virtual ~SaveSentTextCallbackIF() {}

    virtual void onSaveSentTextError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< SaveSentTextError >& error) = 0;

    virtual void onSaveSentTextStatus(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< SaveSentTextStatus >& status) = 0;
};

class SendMessageCallbackIF {
public:
    virtual ~SendMessageCallbackIF() {}

    virtual void onSendMessageError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< SendMessageError >& error) = 0;

    virtual void onSendMessageResult(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< SendMessageResult >& result) = 0;
};

class SignatureSettingCallbackIF {
public:
    virtual ~SignatureSettingCallbackIF() {}

    virtual void onSignatureSettingError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< SignatureSettingError >& error) = 0;

    virtual void onSignatureSettingStatus(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< SignatureSettingStatus >& status) = 0;
};

class SignatureSettingExtendedCallbackIF {
public:
    virtual ~SignatureSettingExtendedCallbackIF() {}

    virtual void onSignatureSettingExtendedError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< SignatureSettingExtendedError >& error) = 0;

    virtual void onSignatureSettingExtendedStatus(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< SignatureSettingExtendedStatus >& status) = 0;
};

class SourceActivityCallbackIF {
public:
    virtual ~SourceActivityCallbackIF() {}

    virtual void onSourceActivityError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< SourceActivityError >& error) = 0;

    virtual void onSourceActivityResult(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< SourceActivityResult >& result) = 0;
};

class SourceAvailableCallbackIF {
public:
    virtual ~SourceAvailableCallbackIF() {}

    virtual void onSourceAvailableError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< SourceAvailableError >& error) = 0;

    virtual void onSourceAvailableStatus(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< SourceAvailableStatus >& status) = 0;
};

class SourceInfoCallbackIF {
public:
    virtual ~SourceInfoCallbackIF() {}

    virtual void onSourceInfoError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< SourceInfoError >& error) = 0;

    virtual void onSourceInfoStatus(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< SourceInfoStatus >& status) = 0;
};

class SwitchMapOnOffCallbackIF {
public:
    virtual ~SwitchMapOnOffCallbackIF() {}

    virtual void onSwitchMapOnOffError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< SwitchMapOnOffError >& error) = 0;

    virtual void onSwitchMapOnOffResult(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< SwitchMapOnOffResult >& result) = 0;
};

class TextAlertEnableCallbackIF {
public:
    virtual ~TextAlertEnableCallbackIF() {}

    virtual void onTextAlertEnableError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< TextAlertEnableError >& error) = 0;

    virtual void onTextAlertEnableStatus(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< TextAlertEnableStatus >& status) = 0;
};

class TextRingtoneOnOffListCallbackIF {
public:
    virtual ~TextRingtoneOnOffListCallbackIF() {}

    virtual void onTextRingtoneOnOffListError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< TextRingtoneOnOffListError >& error) = 0;

    virtual void onTextRingtoneOnOffListStatus(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< TextRingtoneOnOffListStatus >& status) = 0;
};

class UpdateInboxCallbackIF {
public:
    virtual ~UpdateInboxCallbackIF() {}

    virtual void onUpdateInboxError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< UpdateInboxError >& error) = 0;

    virtual void onUpdateInboxResult(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< UpdateInboxResult >& result) = 0;
};

class UpdateInboxSettingsCallbackIF {
public:
    virtual ~UpdateInboxSettingsCallbackIF() {}

    virtual void onUpdateInboxSettingsError(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< UpdateInboxSettingsError >& error) = 0;

    virtual void onUpdateInboxSettingsStatus(const ::boost::shared_ptr< MOST_Msg_FIProxy >& proxy, const ::boost::shared_ptr< UpdateInboxSettingsStatus >& status) = 0;
};

class MOST_Msg_FIProxyCallback;

/**
 * MOST_Msg_FIProxy is the client side representation of the CCA
 * Functional Interface 'MOST_Msg_FI' (specified in file most_Msg_fi.xml).
 *
 * CCA Functional Interface 'MOST_Msg_FI'
 *
 * Fullname: Proprietary - Messaging
 *
 * Version: 2.4.3
 *
 * Author: Dave Pop, General Motors
 *
 * Date: 2012-02-24
 *
 * Department:
 *
 * Title:
 *       MOST_Messaging_FI
 *
 * <b>Description of 'MOST_Msg_FI':</b>
 *
 * <p>This FBlock was assembled from FBlockManifest file: Messaging.fblockman, Please consult individual interface files for interface-specific change history.</p>
 * This Messaging FBlock is implemented within the HMIModule. The Messaging FBlock handles all of the email and text messaging functions within Next-Gen Architecture.
 * Messaging implements the IMessaging interface, ISink, and ISource interfaces.  IMessaging provides all of the control interactions with the HMI, ISink is used to
 * receive microphone audio for voice memo recording, and ISource is used to provide readback of text and email messages.
 * See GIS-327 Bluetooth Requirements Specification, and GIS-368 Messaging FBlock Specification for detailed requirements.
 */
class MOST_Msg_FIProxy : public ::asf::cca::CcaProxy
{
public:

    /**
     * Create a new instance of MOST_Msg_FIProxy. The caller has to pass the
     * port name and the service information. It is only possible to use this
     * function if the port is defined in the CMC model as "wired at
     * runtime"-port. The application id of the CCA Server will be determined
     * with help of the CCA SrvSupplier messages. It's guranteed that the
     * corresponding CCA server will have the specified major version and at
     * least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< MOST_Msg_FIProxy > createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of MOST_Msg_FIProxy. The caller has to pass the
     * port name and the service information. It is only possible to use this
     * function if the port is defined in the CMC model as "wired at
     * runtime"-port. The proxy will connect to the CCA application specified
     * by appId. The CCA SrvSupplier messages will be used to determine the
     * availability of this application and the service. It's guranteed that
     * the corresponding CCA server will have the specified major version and
     * at least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< MOST_Msg_FIProxy > createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of MOST_Msg_FIProxy. The caller has to pass the
     * port name. The port name is defined in the "Car Multimedia Component"
     * model. With the help of the port name it is possible to address the
     * concrete proxy, which is defined in the CMC model description.
     */
    static ::boost::shared_ptr< MOST_Msg_FIProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Destructor of MOST_Msg_FIProxy. The destructor will send RelUpReg
     * messages for all property notifications and call the error callback of
     * all pending method invocations.
     */
    ~MOST_Msg_FIProxy();

    // Method 'Allocate'

    /**
     * Call the method 'Allocate'. This method sends a MethodStart message to
     * the CCA server.
     *
     * <b>Documentation of 'Allocate'</b>:
     *
     * The Allocate method causes the source to occupy bandwidth for streaming data.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8SourceNr Number of a data source (within one FBlock there can be more than one), for example, 0x01 for the first source.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAllocateStart(AllocateCallbackIF& cb, uint8 u8SourceNr);

    // Method 'DeAllocate'

    /**
     * Call the method 'DeAllocate'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'DeAllocate'</b>:
     *
     * The method DeAllocate causes the source to free occupied Streaming bandwidth.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8SourceNr Number of a data source (within one FBlock there can be more than one), for example, 0x01 for the first source.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDeAllocateStart(DeAllocateCallbackIF& cb, uint8 u8SourceNr);

    // Method 'SourceActivity'

    /**
     * Call the method 'SourceActivity'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SourceActivity'</b>:
     *
     * This method controls the activity of a source.
     * Note that the PAUSE state is not allowed for the General Motors implementation and is thus not defined as an allowed state within the enumeration.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8SourceNr Number of a data source (within one FBlock there can be more than one), for example, 0x01 for the first source.
     *
     * @param e8Activity Through parameter Activity, streaming data transfer can be started or stopped. Note that the paused state is not allowed in the General Motors MOST implementation.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSourceActivityStart(SourceActivityCallbackIF& cb, uint8 u8SourceNr, ::most_Src_fi_types::T_e8_SrcActivity e8Activity);

    // Method 'CreateMessageList'

    /**
     * Call the method 'CreateMessageList'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'CreateMessageList'</b>:
     *
     * Creates a message list of a particular type and returns a ListHandle to the caller.  Slices of the list can then be accessed via RequestMessageListSlice.
     * When the folder type is Conversation, slices of the list could be accessed via RequestSliceConversationList. Changes to the list are notified via the MessageListChanged property.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8DeviceHandle Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @param e8FolderType Defines the type of folder: Inbox, Deleted, Drafts, Sent, User defined, and inaccessible.
     * The user defined folders require the FolderName to identify the name of the folder.
     * The inaccessible folders are cannot be accessed from the vehicle.
     *
     * @param u32FolderHandle This is the unique handle for a particular folder.
     *
     * @param e8MessageListType Identifies the type of message list: SMS/MMS or Email
     *
     * @param e8MessageListSortType Passed in CreateMessageList to set the sort order of a created list.
     * Notes:
     * <item>If the parent folder has FolderType=MSG_FOLDER_SENT, then the LastName and FirstName options refer to the first receipient in the 'To' list of the message.</item>
     * <item>The 'Sender Address' referenced in the description of the enum values refers to either an email address or SMS number, etc. depending upon the specific type of each message.</item>
     *
     * @param e8MessageListFilterType Passed in CreateMessageList to filter a subset of the messages in a particular folder.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCreateMessageListStart(CreateMessageListCallbackIF& cb, uint8 u8DeviceHandle, ::most_Msg_fi_types::T_e8_MsgFolderType e8FolderType, uint32 u32FolderHandle, ::most_Msg_fi_types::T_e8_MsgMessageListType e8MessageListType, ::most_Msg_fi_types::T_e8_MsgMessageListSortType e8MessageListSortType, ::most_Msg_fi_types::T_e8_MsgMessageListFilterType e8MessageListFilterType);

    // Method 'RequestSliceMessageList'

    /**
     * Call the method 'RequestSliceMessageList'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'RequestSliceMessageList'</b>:
     *
     * The RequestSliceMessageList method provides a slice of the specific list specified by the ListHandle parameter. The slice begins with the item at location WindowStart and includes in sequential order the number of items specified by the parameter WindowSize.
     * The RequestSliceMessageList method returns the slice as a MessageListSliceResult stream.  If the number of items in the list starting at WindowStart is less than the WindowSize parameter then the number of items provided in the slice will be less than the WindowSize calling parameter.
     * The PlaybackState is transmitted in the MessageListResult for each message in order to allow HMI controllers to annotate a currently playing message with a start/stopped/paused indicator in the list view.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u16ListHandle The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @param u32WindowStart Specifies the start index of the required section inside the total list.
     *
     * @param u32WindowSize Specifies the size of the required section inside the total list.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequestSliceMessageListStart(RequestSliceMessageListCallbackIF& cb, uint16 u16ListHandle, uint32 u32WindowStart, uint32 u32WindowSize);

    // Method 'ReleaseMessageList'

    /**
     * Call the method 'ReleaseMessageList'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'ReleaseMessageList'</b>:
     *
     * The ReleaseMessageList function releases a list which has been created by the CreateMessageList function.  The list to release is specified by the ListHandle parameter. The ListHandle becomes invalid by this function.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u16ListHandle The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReleaseMessageListStart(ReleaseMessageListCallbackIF& cb, uint16 u16ListHandle);

    // Method 'RequestFolderList'

    /**
     * Call the method 'RequestFolderList'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'RequestFolderList'</b>:
     *
     * Retrieves the folder list from a particular branch of the hierarchy.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u32FolderHandle This is the unique handle for a particular folder.
     *
     * @param bRootFlag This is the parameter in the GetFolderList call that identifies that the request is for the Root folder.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequestFolderListStart(RequestFolderListCallbackIF& cb, uint32 u32FolderHandle, bool bRootFlag);

    // Method 'DeleteMessage'

    /**
     * Call the method 'DeleteMessage'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'DeleteMessage'</b>:
     *
     * Deletes a message based on its MessageHandle. The FBlock deletes the message on both the device and in its local store. The Result response includes the DeletionStatus and the MessageHandle of the message requested for deletion.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param oDeleteMessageHandles Includes the message handles of all the messages to be deleted.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDeleteMessageStart(DeleteMessageCallbackIF& cb, const ::most_Msg_fi_types::T_MsgDeleteMessageHandles& oDeleteMessageHandles);

    // Method 'RecoverMessage'

    /**
     * Call the method 'RecoverMessage'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'RecoverMessage'</b>:
     *
     * Recovers a message based on its MessageHandle. The FBlock recovers the message on both the device and in its local store. The Result response includes the RecoveryStatus and the MessageHandle of the message requested for recovery. Only applies to messages in deleted folder.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param oMessageHandle This is the globally unique ID for a particular message. The ID is unique across all currently connected devices and accounts.It is made up of the DeviceHandle, MsgHandleUpper, and MsgHandleLower.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRecoverMessageStart(RecoverMessageCallbackIF& cb, const ::most_Msg_fi_types::T_MsgMessageHandle& oMessageHandle);

    // Method 'RequestAccountList'

    /**
     * Call the method 'RequestAccountList'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'RequestAccountList'</b>:
     *
     * Retrieves the account list for a particular device.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8DeviceHandle Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequestAccountListStart(RequestAccountListCallbackIF& cb, uint8 u8DeviceHandle);

    // Method 'ChangeAccount'

    /**
     * Call the method 'ChangeAccount'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'ChangeAccount'</b>:
     *
     * Sets the selected account as active account and returns the changed account list.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u16AccountHandle This is the globally unique ID for a particular account.  The ID is unique across all currently connected devices.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendChangeAccountStart(ChangeAccountCallbackIF& cb, uint16 u16AccountHandle);

    // Method 'UpdateInbox'

    /**
     * Call the method 'UpdateInbox'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'UpdateInbox'</b>:
     *
     * Initiates request to update inbox for the active account.The ProcessingAck shall always be sent.The ResultAck is sent only
     * after Messaging receives an new message notification or the Update Email Activity Indicator timer expires.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUpdateInboxStart(UpdateInboxCallbackIF& cb);

    // Method 'GetMessage'

    /**
     * Call the method 'GetMessage'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'GetMessage'</b>:
     *
     * Retrieves the detailed information for a particular message(s) identified by the supplied MessageHandle. If the ConversationModeFlag is set to true then, the MessageDetailsResult will include all the messages that make up the conversation of the requested MessageHandle.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param oMessageHandle This is the globally unique ID for a particular message. The ID is unique across all currently connected devices and accounts.It is made up of the DeviceHandle, MsgHandleUpper, and MsgHandleLower.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetMessageStart(GetMessageCallbackIF& cb, const ::most_Msg_fi_types::T_MsgMessageHandle& oMessageHandle);

    // Method 'GetAttachmentList'

    /**
     * Call the method 'GetAttachmentList'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'GetAttachmentList'</b>:
     *
     * This method is used to retrieve the AttachmentList for a specific message.  The returned list is constant and cannot change.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param oMessageHandle This is the globally unique ID for a particular message. The ID is unique across all currently connected devices and accounts.It is made up of the DeviceHandle, MsgHandleUpper, and MsgHandleLower.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetAttachmentListStart(GetAttachmentListCallbackIF& cb, const ::most_Msg_fi_types::T_MsgMessageHandle& oMessageHandle);

    // Method 'AudioAttachmentPlayback'

    /**
     * Call the method 'AudioAttachmentPlayback'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'AudioAttachmentPlayback'</b>:
     *
     * Requests the playback action for the audio attachment. Playback actions include:1. Play: plays or restarts a previously paused audio attachment2. Pause: pause the currently playing audio attachment3. Stop: stops a currently playing audio attachment.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u16AttachmentHandle This is the handle for a particular attachment.  The handle is locally unique only for a particular message and is not required to be globally unique.
     *
     * @param e8PlaybackAction
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAudioAttachmentPlaybackStart(AudioAttachmentPlaybackCallbackIF& cb, uint16 u16AttachmentHandle, ::most_Msg_fi_types::T_e8_MsgPlaybackAction e8PlaybackAction);

    // Method 'GetImageAttachment'

    /**
     * Call the method 'GetImageAttachment'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'GetImageAttachment'</b>:
     *
     * Retrieves the image associated with an attachment.  Controllers may call GetImageAttachmentInfo in advance to find the MIME type and size of the image in order to allocate buffers and/or decoding resources, then call this function to receive the actual image data.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u16AttachmentHandle This is the handle for a particular attachment.  The handle is locally unique only for a particular message and is not required to be globally unique.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetImageAttachmentStart(GetImageAttachmentCallbackIF& cb, uint16 u16AttachmentHandle);

    // Method 'GetBodyPartList'

    /**
     * Call the method 'GetBodyPartList'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'GetBodyPartList'</b>:
     *
     * This method is used to retrieve the BodyPart elements for a specific message.  The returned list is constant and cannot change.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param oMessageHandle This is the globally unique ID for a particular message. The ID is unique across all currently connected devices and accounts.It is made up of the DeviceHandle, MsgHandleUpper, and MsgHandleLower.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetBodyPartListStart(GetBodyPartListCallbackIF& cb, const ::most_Msg_fi_types::T_MsgMessageHandle& oMessageHandle);

    // Method 'ReadMessageAloud'

    /**
     * Call the method 'ReadMessageAloud'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'ReadMessageAloud'</b>:
     *
     * This method is used to begin or end the reading of the selected message aloud on the specified LogicalAVChannel.Messaging shall be responsible for requesting the TTS session.
     * Important note on TTSLanguage parameter:The TTSLanguage parameter was defined in MY13 with incorrect language enumerations that do not match the master system language enums in TextToSpeech.
     * TTSLanguage and GMLANGateway.LanguageSelection. The ReadMessageAloud feature is intended to always read the message in the system language (GMLANGateway.LanguageSelection).
     * Therefore, the TTSLanguage parameter shall be handled as follows:
     *
     * <item>
     * Controllers shall always set TTSLanguage to 0xFF = USE_SYSTEM_LANGUAGE_SELECTION.
     * </item>
     * <item>
     * The Messaging FBlock shall always read the TTSLanguage in the current system language according to the GMLANGateway.LanguageSelection
     * property and/or internal calibrations for the specific TTS language corresponding to the current LanguageSelection value.
     * </item>
     * <item>
     * If the TTSLanguage parameter is received with ANY vale other than 0xFF = USE_SYSTEM_LANGUAGE_SELECTION, then the Messaging FBlock shall
     * ignore the value and execute the read message aloud function in the system language (provided the system language is available in the
     * current system configuration).
     * </item>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param oMessageHandle This is the globally unique ID for a particular message. The ID is unique across all currently connected devices and accounts.It is made up of the DeviceHandle, MsgHandleUpper, and MsgHandleLower.
     *
     * @param e8PlaybackAction
     *
     * @param u8LogicalAVChannel Refer to IAVConnection for the enumeration of the Logical AV Channel parameter.
     *
     * @param e8TTSLanguage deprecatedThe TTSLanguage parameter was defined in MY13 with incorrect language enumerations that do not match the master system language enums in
     * TextToSpeech.TTSLanguage and GMLANGateway.LanguageSelection. The ReadMessageAloud feature is intended to always read the message in the system language
     * (GMLANGateway.LanguageSelection). Therefore, the TTSLanguage parameter is deprecated and shall be handled as follows:
     *
     * <item>
     * Controllers shall always set TTSLanguage to 0xFF = USE_SYSTEM_LANGUAGE_SELECTION.
     * </item>
     * <item>
     * The Messaging FBlock shall always read the TTSLanguage in the current system language according to the GMLANGateway.LanguageSelection
     * property and/or internal calibrations for the specific TTS language corresponding to the current LanguageSelection value.
     * </item>
     * <item>
     * If the TTSLanguage parameter is received with ANY vale other than 0xFF = USE_SYSTEM_LANGUAGE_SELECTION, then the Messaging FBlock shall
     * ignore the value and execute the read message aloud function in the system language (provided the system language is available in the
     * current system configuration).
     * </item>
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReadMessageAloudStart(ReadMessageAloudCallbackIF& cb, const ::most_Msg_fi_types::T_MsgMessageHandle& oMessageHandle, ::most_Msg_fi_types::T_e8_MsgPlaybackAction e8PlaybackAction, uint8 u8LogicalAVChannel, ::most_Msg_fi_types::T_e8_MsgTTSLanguage e8TTSLanguage);

    // Method 'RecordAudioMessage'

    /**
     * Call the method 'RecordAudioMessage'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'RecordAudioMessage'</b>:
     *
     * This method is used to record an audio message.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param e8RecordMessageAction Identifies the audio message voice recording actions: Start, Stop, Cancel
     *
     * @param u8LogicalAVChannel Refer to IAVConnection for the enumeration of the Logical AV Channel parameter.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRecordAudioMessageStart(RecordAudioMessageCallbackIF& cb, ::most_Msg_fi_types::T_e8_MsgRecordMessageAction e8RecordMessageAction, uint8 u8LogicalAVChannel);

    // Method 'PlaybackAudioMessage'

    /**
     * Call the method 'PlaybackAudioMessage'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'PlaybackAudioMessage'</b>:
     *
     * This method is used to playback a recorded audio message.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u16RecordedAudioMessageHandle RecordedAudioMessageHandle = 0 is reserved to identify a NULL handle.
     *
     * @param e8PlaybackAction
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPlaybackAudioMessageStart(PlaybackAudioMessageCallbackIF& cb, uint16 u16RecordedAudioMessageHandle, ::most_Msg_fi_types::T_e8_MsgPlaybackAction e8PlaybackAction);

    // Method 'AddPredefinedMessage'

    /**
     * Call the method 'AddPredefinedMessage'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'AddPredefinedMessage'</b>:
     *
     * This method adds a new predefined message per the text sent by the HMI. Messaging returns the handle of the new predefined message.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param sPredefinedMessageText The text of the predefined message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAddPredefinedMessageStart(AddPredefinedMessageCallbackIF& cb, const ::fi_basetypes_most::T_String& sPredefinedMessageText);

    // Method 'DeletePredefinedMessage'

    /**
     * Call the method 'DeletePredefinedMessage'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'DeletePredefinedMessage'</b>:
     *
     * This method deletes a predefined message from the predefined message list.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u16PredefinedMessageHandle This is the unique ID for a particular predefined message text.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDeletePredefinedMessageStart(DeletePredefinedMessageCallbackIF& cb, uint16 u16PredefinedMessageHandle);

    // Method 'GetConversationMessages'

    /**
     * Call the method 'GetConversationMessages'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'GetConversationMessages'</b>:
     *
     * This method acquires the MessageHandles of all the messages that make up the conversation for a particular message (MessageHandle). The HMI uses the GetMessage method to get all the detailed information for each message.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param oMessageHandle This is the globally unique ID for a particular message. The ID is unique across all currently connected devices and accounts.It is made up of the DeviceHandle, MsgHandleUpper, and MsgHandleLower.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetConversationMessagesStart(GetConversationMessagesCallbackIF& cb, const ::most_Msg_fi_types::T_MsgMessageHandle& oMessageHandle);

    // Method 'SendMessage'

    /**
     * Call the method 'SendMessage'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'SendMessage'</b>:
     *
     * This method informs Messaging that a message needs to be sent. It provides the type of message, the original MessageHandle (if applicable), the create message type (i.e. new message, reply, reply to all, or forward), and the MessageHeaderBodyHandle.
     * Note that if the message could not be sent to the Bluetooth device for transmission, the SentMessageStatus will return ERROR.  If sent successfully to the Bluetooth, but not necessarily sent successfully on the cellular network, the SUCCESS code is returned.
     * Note further that for both of these response codes, the Messaging FBlock will trigger the appropriate alert to the AlertManager FBlock for notification to the overall vehicle HMI.  See GIS-368 for details.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8CreateMessageHandle Represents the handle assigned to a message that is being created and has not been sent or saved. This handle is required to keep the CreateMessage in sync with the ProvideMessageHeader, ProvideMessageBody, and SendMessage methods needed for Messaging to send or save a message.The CreateMessageHandle is temporary and shall be cleared upon the HMI receiving the ResultAck from the SendMessage method.
     *
     * @param e8FolderType Defines the type of folder: Inbox, Deleted, Drafts, Sent, User defined, and inaccessible.
     * The user defined folders require the FolderName to identify the name of the folder.
     * The inaccessible folders are cannot be accessed from the vehicle.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSendMessageStart(SendMessageCallbackIF& cb, uint8 u8CreateMessageHandle, ::most_Msg_fi_types::T_e8_MsgFolderType e8FolderType);

    // Method 'ProvideMessageHeader'

    /**
     * Call the method 'ProvideMessageHeader'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'ProvideMessageHeader'</b>:
     *
     * This method provides the message header for the CreateMessageHandle message to be sent.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8CreateMessageHandle Represents the handle assigned to a message that is being created and has not been sent or saved. This handle is required to keep the CreateMessage in sync with the ProvideMessageHeader, ProvideMessageBody, and SendMessage methods needed for Messaging to send or save a message.The CreateMessageHandle is temporary and shall be cleared upon the HMI receiving the ResultAck from the SendMessage method.
     *
     * @param sSubject The subject of the email message.
     *
     * @param oAddressField Provides the field type (From, To, CC) and the sender or recipient contact information.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProvideMessageHeaderStart(ProvideMessageHeaderCallbackIF& cb, uint8 u8CreateMessageHandle, const ::fi_basetypes_most::T_String& sSubject, const ::most_Msg_fi_types::T_MsgAddressField& oAddressField);

    // Method 'ProvideMessageBody'

    /**
     * Call the method 'ProvideMessageBody'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'ProvideMessageBody'</b>:
     *
     * This method provides the message body for the CreateMessageHandle message to be sent.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8CreateMessageHandle Represents the handle assigned to a message that is being created and has not been sent or saved. This handle is required to keep the CreateMessage in sync with the ProvideMessageHeader, ProvideMessageBody, and SendMessage methods needed for Messaging to send or save a message.The CreateMessageHandle is temporary and shall be cleared upon the HMI receiving the ResultAck from the SendMessage method.
     *
     * @param u16RecordedAudioMessageHandle RecordedAudioMessageHandle = 0 is reserved to identify a NULL handle.
     *
     * @param oAttachmentHandleStream The list of attachment handles limited to a maximum of 10 attachments.
     *
     * @param u16NumMessageBodyTextElements The number of MessageBodyText segments within the stream.
     *
     * @param oMessageBodyText Includes a stream of MsgBodyText parameters that together make up the complete MessageBodyText.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProvideMessageBodyStart(ProvideMessageBodyCallbackIF& cb, uint8 u8CreateMessageHandle, uint16 u16RecordedAudioMessageHandle, const ::most_Msg_fi_types::T_MsgAttachmentHandleStream& oAttachmentHandleStream, uint16 u16NumMessageBodyTextElements, const ::most_Msg_fi_types::T_MsgMessageBodyText& oMessageBodyText);

    // Method 'GetMsgBodyActionElement'

    /**
     * Call the method 'GetMsgBodyActionElement'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'GetMsgBodyActionElement'</b>:
     *
     * This method allows the HMI to acquire information (element type and content) on a particular MsgBodyActionElementTag.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8MsgBodyActionElementTag Provide the tag for an action element (i.e. phone numbers, email addresses, and addresses).
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetMsgBodyActionElementStart(GetMsgBodyActionElementCallbackIF& cb, uint8 u8MsgBodyActionElementTag);

    // Method 'GetImageAttachmentInfo'

    /**
     * Call the method 'GetImageAttachmentInfo'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'GetImageAttachmentInfo'</b>:
     *
     * Acquires the MIME image subtype and the size of an attached image identified by its AttachmentHandle. If the MIMEImageSubtype = NULL then there is no photo associated with the AttachmentHandle.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u16AttachmentHandle This is the handle for a particular attachment.  The handle is locally unique only for a particular message and is not required to be globally unique.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetImageAttachmentInfoStart(GetImageAttachmentInfoCallbackIF& cb, uint16 u16AttachmentHandle);

    // Method 'CreateMessage'

    /**
     * Call the method 'CreateMessage'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'CreateMessage'</b>:
     *
     * This function is the first of four functions used in sending a message. The CreateMessage function identifies the type of message (SMS, MMS, or Email)
     * to be sent and whether the message is new, a reply, or a forward. If the message to be sent is a reply or a forward the original message handle is included.
     * Additionally, the CreateMessage function identifies the CreateMessageHandle which will allow the ProvideMessageHeader, ProvideMessageBody, and SendMessage
     * functions to stay in sync and ultimately send the created message.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8CreateMessageHandle Represents the handle assigned to a message that is being created and has not been sent or saved. This handle is required to keep the CreateMessage in sync with the ProvideMessageHeader, ProvideMessageBody, and SendMessage methods needed for Messaging to send or save a message.The CreateMessageHandle is temporary and shall be cleared upon the HMI receiving the ResultAck from the SendMessage method.
     *
     * @param oMessageHandle This is the globally unique ID for a particular message. The ID is unique across all currently connected devices and accounts.It is made up of the DeviceHandle, MsgHandleUpper, and MsgHandleLower.
     *
     * @param e8MessageType Identifies the type of message: SMS, MMS, or Email.
     *
     * @param e8CreateMessageType Identifies the create message type.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCreateMessageStart(CreateMessageCallbackIF& cb, uint8 u8CreateMessageHandle, const ::most_Msg_fi_types::T_MsgMessageHandle& oMessageHandle, ::most_Msg_fi_types::T_e8_MsgMessageType e8MessageType, ::most_Msg_fi_types::T_e8_MsgCreateMessageType e8CreateMessageType);

    // Method 'ClearUserMessagingInfo'

    /**
     * Call the method 'ClearUserMessagingInfo'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'ClearUserMessagingInfo'</b>:
     *
     * The ClearUserMessagingInfo Method is called by controllers to clear out all user messaging information such as predefined user messages.  Upon receipt of the StartAck, the FBlock shall remove all user messaging info such as predefined user messages.
     * This function is generally only called when a vehicle is turned-in at end of lease or sold.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendClearUserMessagingInfoStart(ClearUserMessagingInfoCallbackIF& cb);

    // Method 'ConnectMapProfile'

    /**
     * Call the method 'ConnectMapProfile'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'ConnectMapProfile'</b>:
     *
     * This method will try to establish MAP session for the requested device handle.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param DeviceHandle Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @param RetryCount If the MAP session fails to establish, retry to connect MAP for the count specified. Default value is 00, which indicates there will be no retry from Messaging F-Block to establish the MAP session if once failed.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConnectMapProfileStart(ConnectMapProfileCallbackIF& cb, uint8 deviceHandle, uint8 retryCount);

    // Method 'EditPredefinedMessage'

    /**
     * Call the method 'EditPredefinedMessage'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'EditPredefinedMessage'</b>:
     *
     * This method allows the user to edit the already existing predefined message.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u16PredefinedMessageHandle This is the unique ID for a particular predefined message text.
     *
     * @param sPredefinedMessageText The text of the predefined message. The already available text for the particular message handle will be replaced with the new text provided by HMI.
     *
     * @param e8PredefinedMessageSubCategory The subcategory of the predefined message to be edited.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEditPredefinedMessageStart(EditPredefinedMessageCallbackIF& cb, uint16 u16PredefinedMessageHandle, const ::fi_basetypes_most::T_String& sPredefinedMessageText, ::most_Msg_fi_types_Extended::T_e8_MsgPredefinedMessageSubCategory e8PredefinedMessageSubCategory);

    // Method 'AddPredefinedMessageExtended'

    /**
     * Call the method 'AddPredefinedMessageExtended'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'AddPredefinedMessageExtended'</b>:
     *
     * This method allows the user to add a predefined message to a particular sub-category.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param e8PredefinedMessageSubCategory The subcategory of the new predefined message to be added.
     *
     * @param sPredefinedMessageText The text of the predefined message to be added.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAddPredefinedMessageExtendedStart(AddPredefinedMessageExtendedCallbackIF& cb, ::most_Msg_fi_types_Extended::T_e8_MsgPredefinedMessageSubCategory e8PredefinedMessageSubCategory, const ::fi_basetypes_most::T_String& sPredefinedMessageText);

    // Method 'ReadMessageAloudExtended'

    /**
     * Call the method 'ReadMessageAloudExtended'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'ReadMessageAloudExtended'</b>:
     *
     * This method will begin (or) end the reading of a particular message content provided by the clients.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param e8PlaybackAction
     *
     * @param sReadAloudContent The content received from clients will be directly passed to the speech unit without any formatting.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReadMessageAloudExtendedStart(ReadMessageAloudExtendedCallbackIF& cb, ::most_Msg_fi_types::T_e8_MsgPlaybackAction e8PlaybackAction, const ::fi_basetypes_most::T_String& sReadAloudContent);

    // Method 'RequestSliceConversationList'

    /**
     * Call the method 'RequestSliceConversationList'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'RequestSliceConversationList'</b>:
     *
     * The RequestSliceConversationList method provides slices of the conversation list specified by the ListHandle parameter. The slice begins with the item at location WindowStart and includes
     * in sequential order the number of items specified by the parameter WindowSize. The RequestSliceConversationList method returns the slice as a ConversationListSliceResult stream.
     * If the number of items in the list starting at WindowStart is less than the WindowSize parameter then the number of items provided in the slice will be less than the WindowSize calling parameter.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u16ListHandle The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @param u32WindowStart Specifies the start index of the required section inside the total list.
     *
     * @param u32WindowSize Specifies the size of the required section inside the total list.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequestSliceConversationListStart(RequestSliceConversationListCallbackIF& cb, uint16 u16ListHandle, uint32 u32WindowStart, uint32 u32WindowSize);

    // Method 'GetSliceConversationDetails'

    /**
     * Call the method 'GetSliceConversationDetails'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'GetSliceConversationDetails'</b>:
     *
     * This method provides the details of messages that belongs to the particular conversation handle.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param oConversationHandle This is a unique ID for a conversation. It comprises of DeviceHandle and ConversationID.
     *
     * @param u32WindowStart Specifies the start index of the required section inside the conversation message list.
     *
     * @param u32WindowSize Specifies the size of the required section inside the conversation message list.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetSliceConversationDetailsStart(GetSliceConversationDetailsCallbackIF& cb, const ::most_Msg_fi_types_Extended::T_MsgConversationHandle& oConversationHandle, uint32 u32WindowStart, uint32 u32WindowSize);

    // Method 'SwitchMapOnOff'

    /**
     * Call the method 'SwitchMapOnOff'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SwitchMapOnOff'</b>:
     *
     * This method switches ON or OFF the MAP profile for the requested phone device (DeviceHandle).
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8DeviceHandle The DeviceHandle addresses the dedicated phone device for which the setting shall be used
     *
     * @param bOnOffState The MAP state can be requested to ON and OFF
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSwitchMapOnOffStart(SwitchMapOnOffCallbackIF& cb, uint8 u8DeviceHandle, bool bOnOffState);

    // Method 'AddCustomMessage'

    /**
     * Call the method 'AddCustomMessage'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'AddCustomMessage'</b>:
     *
     * This method allows the user to add a predefined message to a particular sub-category to a particular device handle
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8DeviceHandle
     *
     * @param e8PredefinedMessageSubCategory The subcategory of the new predefined message to be added.
     *
     * @param sPredefinedMessageText The text of the predefined message to be added.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAddCustomMessageStart(AddCustomMessageCallbackIF& cb, uint8 u8DeviceHandle, ::most_Msg_fi_types_Extended::T_e8_MsgPredefinedMessageSubCategory e8PredefinedMessageSubCategory, const ::fi_basetypes_most::T_String& sPredefinedMessageText);

    // Property 'SourceInfo'

    /**
     * Notify on the property 'SourceInfo'. This method sends a UpReg message
     * to the CCA server.
     *
     * <b>Documentation of 'SourceInfo'</b>:
     *
     * This property gives particulars about the type of streaming data a source can handle. If notification is used for an FBlock
     * with multiple sources, multiple notifications will be sent when the status changes for more than one source.
     * For further information please refer to the MOST Stream Transmission Specification Rev 3.0.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSourceInfoUpReg(SourceInfoCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SourceInfo'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SourceInfo'</b>:
     *
     * This property gives particulars about the type of streaming data a source can handle. If notification is used for an FBlock
     * with multiple sources, multiple notifications will be sent when the status changes for more than one source.
     * For further information please refer to the MOST Stream Transmission Specification Rev 3.0.
     *
     * @param act The act which was previously returned by the
     * sendSourceInfoUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSourceInfoRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SourceInfo'.
     */
    void sendSourceInfoRelUpRegAll ();

    /**
     * Returns the current value of the property 'SourceInfo' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when
     * hasSourceInfo() returns true.
     *
     * @return the previously received value of the property 'SourceInfo'.
     */
    const SourceInfoStatus& getSourceInfo() const;

    /**
     * Determines whether a status message for the property 'SourceInfo' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSourceInfo() const;

    /**
     * Request the value of the property 'SourceInfo' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'SourceInfo'</b>:
     *
     * This property gives particulars about the type of streaming data a source can handle. If notification is used for an FBlock
     * with multiple sources, multiple notifications will be sent when the status changes for more than one source.
     * For further information please refer to the MOST Stream Transmission Specification Rev 3.0.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     * @param u8SourceNr Number of a data source (within one FBlock there can be more than one), for example, 0x01 for the first source.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSourceInfoGet(SourceInfoCallbackIF& cb, uint8 u8SourceNr);

    // Property 'SourceAvailable'

    /**
     * Notify on the property 'SourceAvailable'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'SourceAvailable'</b>:
     *
     * The SourceAvailable property can be queried by a controller to determine whether a Source is initialized and ready to produce audio or video.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSourceAvailableUpReg(SourceAvailableCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SourceAvailable'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SourceAvailable'</b>:
     *
     * The SourceAvailable property can be queried by a controller to determine whether a Source is initialized and ready to produce audio or video.
     *
     * @param act The act which was previously returned by the
     * sendSourceAvailableUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSourceAvailableRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SourceAvailable'.
     */
    void sendSourceAvailableRelUpRegAll ();

    /**
     * Returns the current value of the property 'SourceAvailable' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasSourceAvailable() returns true.
     *
     * @return the previously received value of the property 'SourceAvailable'.
     */
    const SourceAvailableStatus& getSourceAvailable() const;

    /**
     * Determines whether a status message for the property 'SourceAvailable' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSourceAvailable() const;

    /**
     * Request the value of the property 'SourceAvailable' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'SourceAvailable'</b>:
     *
     * The SourceAvailable property can be queried by a controller to determine whether a Source is initialized and ready to produce audio or video.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSourceAvailableGet(SourceAvailableCallbackIF& cb);

    // Property 'MessageListChange'

    /**
     * Notify on the property 'MessageListChange'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'MessageListChange'</b>:
     *
     * The MessageListChange property provides notifications about changes that occur in a created message list.
     * These changes include:
     * <item>
     * Complete change in items
     * </item>
     * <item>
     * Items changed
     * </item>
     * <item>
     * Items added
     * </item>
     * <item>
     * Items deleted
     * </item>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMessageListChangeUpReg(MessageListChangeCallbackIF& cb);

    /**
     * Remove the notifcation on property 'MessageListChange'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'MessageListChange'</b>:
     *
     * The MessageListChange property provides notifications about changes that occur in a created message list.
     * These changes include:
     * <item>
     * Complete change in items
     * </item>
     * <item>
     * Items changed
     * </item>
     * <item>
     * Items added
     * </item>
     * <item>
     * Items deleted
     * </item>
     *
     * @param act The act which was previously returned by the
     * sendMessageListChangeUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendMessageListChangeRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'MessageListChange'.
     */
    void sendMessageListChangeRelUpRegAll ();

    /**
     * Returns the current value of the property 'MessageListChange' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasMessageListChange() returns true.
     *
     * @return the previously received value of the property 'MessageListChange'.
     */
    const MessageListChangeStatus& getMessageListChange() const;

    /**
     * Determines whether a status message for the property 'MessageListChange' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasMessageListChange() const;

    // Property 'FolderListChange'

    /**
     * Notify on the property 'FolderListChange'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'FolderListChange'</b>:
     *
     * Notifies the HMI that the FolderList has changed. The notification includes whether or not the folder list structure has changed or just the
     * message information on a particular folder.
     * The HMI must either:
     * <item>
     * Request the entire list if one or more folders have been added or removed (starting from the Root) or,
     * </item>
     * <item>
     * (Re)request the list information for the Folder corresponding to to the FolderHandle in the notification.
     * </item>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFolderListChangeUpReg(FolderListChangeCallbackIF& cb);

    /**
     * Remove the notifcation on property 'FolderListChange'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'FolderListChange'</b>:
     *
     * Notifies the HMI that the FolderList has changed. The notification includes whether or not the folder list structure has changed or just the
     * message information on a particular folder.
     * The HMI must either:
     * <item>
     * Request the entire list if one or more folders have been added or removed (starting from the Root) or,
     * </item>
     * <item>
     * (Re)request the list information for the Folder corresponding to to the FolderHandle in the notification.
     * </item>
     *
     * @param act The act which was previously returned by the
     * sendFolderListChangeUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendFolderListChangeRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'FolderListChange'.
     */
    void sendFolderListChangeRelUpRegAll ();

    /**
     * Returns the current value of the property 'FolderListChange' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasFolderListChange() returns true.
     *
     * @return the previously received value of the property 'FolderListChange'.
     */
    const FolderListChangeStatus& getFolderListChange() const;

    /**
     * Determines whether a status message for the property 'FolderListChange' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasFolderListChange() const;

    // Property 'MessagingDeviceConnection'

    /**
     * Notify on the property 'MessagingDeviceConnection'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'MessagingDeviceConnection'</b>:
     *
     * This property MessagingDeviceConnection has become DEPRECATED.
     * HMI Controllers are recommended to register for MapDeviceCapabilitiesExtended, since it already includes the functionalities of MessagingDeviceConnection.
     *
     * Identifies the supported message types and active email account (if applicable) for the connected device. This propery also reports the MessagingMemoryStatus of
     * the device that can be used to synchronize the HMI view with whether the device has more memory available for message or it if is full.  Note that the Messaging FBlock
     * triggers alerts to the AlertManager when the device becomes full and when it becomes available again.  The MessageMemoryStatus flag is used to synchronize persistent markers in the HMI view.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMessagingDeviceConnectionUpReg(MessagingDeviceConnectionCallbackIF& cb);

    /**
     * Remove the notifcation on property 'MessagingDeviceConnection'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'MessagingDeviceConnection'</b>:
     *
     * This property MessagingDeviceConnection has become DEPRECATED.
     * HMI Controllers are recommended to register for MapDeviceCapabilitiesExtended, since it already includes the functionalities of MessagingDeviceConnection.
     *
     * Identifies the supported message types and active email account (if applicable) for the connected device. This propery also reports the MessagingMemoryStatus of
     * the device that can be used to synchronize the HMI view with whether the device has more memory available for message or it if is full.  Note that the Messaging FBlock
     * triggers alerts to the AlertManager when the device becomes full and when it becomes available again.  The MessageMemoryStatus flag is used to synchronize persistent markers in the HMI view.
     *
     * @param act The act which was previously returned by the
     * sendMessagingDeviceConnectionUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendMessagingDeviceConnectionRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'MessagingDeviceConnection'.
     */
    void sendMessagingDeviceConnectionRelUpRegAll ();

    /**
     * Returns the current value of the property 'MessagingDeviceConnection'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasMessagingDeviceConnection() returns true.
     *
     * @return the previously received value of the property 'MessagingDeviceConnection'.
     */
    const MessagingDeviceConnectionStatus& getMessagingDeviceConnection() const;

    /**
     * Determines whether a status message for the property 'MessagingDeviceConnection' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasMessagingDeviceConnection() const;

    // Property 'UpdateInboxSettings'

    /**
     * Notify on the property 'UpdateInboxSettings'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'UpdateInboxSettings'</b>:
     *
     * The Set operation is used by the HMI to set the automatic update inbox feature ON or OFF. If the feature is set to ON, the UpdateInboxPeriod set by the user is also sent.The Get operation is used by the HMI to update the Email Settings view.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUpdateInboxSettingsUpReg(UpdateInboxSettingsCallbackIF& cb);

    /**
     * Remove the notifcation on property 'UpdateInboxSettings'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'UpdateInboxSettings'</b>:
     *
     * The Set operation is used by the HMI to set the automatic update inbox feature ON or OFF. If the feature is set to ON, the UpdateInboxPeriod set by the user is also sent.The Get operation is used by the HMI to update the Email Settings view.
     *
     * @param act The act which was previously returned by the
     * sendUpdateInboxSettingsUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendUpdateInboxSettingsRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'UpdateInboxSettings'.
     */
    void sendUpdateInboxSettingsRelUpRegAll ();

    /**
     * Returns the current value of the property 'UpdateInboxSettings' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasUpdateInboxSettings() returns true.
     *
     * @return the previously received value of the property 'UpdateInboxSettings'.
     */
    const UpdateInboxSettingsStatus& getUpdateInboxSettings() const;

    /**
     * Determines whether a status message for the property 'UpdateInboxSettings' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasUpdateInboxSettings() const;

    /**
     * Request the value of the property 'UpdateInboxSettings' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'UpdateInboxSettings'</b>:
     *
     * The Set operation is used by the HMI to set the automatic update inbox feature ON or OFF. If the feature is set to ON, the UpdateInboxPeriod set by the user is also sent.The Get operation is used by the HMI to update the Email Settings view.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUpdateInboxSettingsGet(UpdateInboxSettingsCallbackIF& cb);

    /**
     * Set the value of the property 'UpdateInboxSettings'. This method sends
     * a PureSet message to the CCA server.
     *
     * <b>Documentation of 'UpdateInboxSettings'</b>:
     *
     * The Set operation is used by the HMI to set the automatic update inbox feature ON or OFF. If the feature is set to ON, the UpdateInboxPeriod set by the user is also sent.The Get operation is used by the HMI to update the Email Settings view.
     *
     * @param bAutoUpdateInboxOnOff Identifies if the automatic update of the inbox is set to ON or OFF.
     *
     * @param u32UpdateInboxPeriod The polling period for the inbox for those email accounts that require polling. The period value is in seconds.
     */

    void sendUpdateInboxSettingsPureSet(bool bAutoUpdateInboxOnOff, uint32 u32UpdateInboxPeriod);

    // Property 'AudioAttachmentPlaybackState'

    /**
     * Notify on the property 'AudioAttachmentPlaybackState'. This method
     * sends a UpReg message to the CCA server.
     *
     * <b>Documentation of 'AudioAttachmentPlaybackState'</b>:
     *
     * Provides notification of the playback status the currently playing audio attachment.  The Status response is triggered to notified controllers to notify changes in the playback state of an audio attachment.
     * The Get operator returns the status of the currently playing audio attachment or the status of the last played attachment if attachment play has ended.  If no attachment play is defined, the return AttachmentHandle shall be set to the null value of 0x0000.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAudioAttachmentPlaybackStateUpReg(AudioAttachmentPlaybackStateCallbackIF& cb);

    /**
     * Remove the notifcation on property 'AudioAttachmentPlaybackState'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'AudioAttachmentPlaybackState'</b>:
     *
     * Provides notification of the playback status the currently playing audio attachment.  The Status response is triggered to notified controllers to notify changes in the playback state of an audio attachment.
     * The Get operator returns the status of the currently playing audio attachment or the status of the last played attachment if attachment play has ended.  If no attachment play is defined, the return AttachmentHandle shall be set to the null value of 0x0000.
     *
     * @param act The act which was previously returned by the
     * sendAudioAttachmentPlaybackStateUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendAudioAttachmentPlaybackStateRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'AudioAttachmentPlaybackState'.
     */
    void sendAudioAttachmentPlaybackStateRelUpRegAll ();

    /**
     * Returns the current value of the property
     * 'AudioAttachmentPlaybackState' (as known by the proxy). This method is
     * only allowed to be called when a status message for this property was
     * received before. Otherwise the behavior of this method is undefined. It
     * is safe to call this method when hasAudioAttachmentPlaybackState()
     * returns true.
     *
     * @return the previously received value of the property 'AudioAttachmentPlaybackState'.
     */
    const AudioAttachmentPlaybackStateStatus& getAudioAttachmentPlaybackState() const;

    /**
     * Determines whether a status message for the property 'AudioAttachmentPlaybackState' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAudioAttachmentPlaybackState() const;

    /**
     * Request the value of the property 'AudioAttachmentPlaybackState' from
     * the CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'AudioAttachmentPlaybackState'</b>:
     *
     * Provides notification of the playback status the currently playing audio attachment.  The Status response is triggered to notified controllers to notify changes in the playback state of an audio attachment.
     * The Get operator returns the status of the currently playing audio attachment or the status of the last played attachment if attachment play has ended.  If no attachment play is defined, the return AttachmentHandle shall be set to the null value of 0x0000.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAudioAttachmentPlaybackStateGet(AudioAttachmentPlaybackStateCallbackIF& cb);

    // Property 'SignatureSetting'

    /**
     * Notify on the property 'SignatureSetting'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'SignatureSetting'</b>:
     *
     * Used to set and acquire the signature text to be appended to the end of a message.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSignatureSettingUpReg(SignatureSettingCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SignatureSetting'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SignatureSetting'</b>:
     *
     * Used to set and acquire the signature text to be appended to the end of a message.
     *
     * @param act The act which was previously returned by the
     * sendSignatureSettingUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSignatureSettingRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SignatureSetting'.
     */
    void sendSignatureSettingRelUpRegAll ();

    /**
     * Returns the current value of the property 'SignatureSetting' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasSignatureSetting() returns true.
     *
     * @return the previously received value of the property 'SignatureSetting'.
     */
    const SignatureSettingStatus& getSignatureSetting() const;

    /**
     * Determines whether a status message for the property 'SignatureSetting' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSignatureSetting() const;

    /**
     * Request the value of the property 'SignatureSetting' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'SignatureSetting'</b>:
     *
     * Used to set and acquire the signature text to be appended to the end of a message.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSignatureSettingGet(SignatureSettingCallbackIF& cb);

    /**
     * Set the value of the property 'SignatureSetting'. This method sends a
     * PureSet message to the CCA server.
     *
     * <b>Documentation of 'SignatureSetting'</b>:
     *
     * Used to set and acquire the signature text to be appended to the end of a message.
     *
     * @param sSignatureText The text of the signature to be appended to messages sent from the vehicle.
     */

    void sendSignatureSettingPureSet(const ::fi_basetypes_most::T_String& sSignatureText);

    // Property 'AudioMessageRecordingState'

    /**
     * Notify on the property 'AudioMessageRecordingState'. This method sends
     * a UpReg message to the CCA server.
     *
     * <b>Documentation of 'AudioMessageRecordingState'</b>:
     *
     * Provides the audio message recording state.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAudioMessageRecordingStateUpReg(AudioMessageRecordingStateCallbackIF& cb);

    /**
     * Remove the notifcation on property 'AudioMessageRecordingState'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'AudioMessageRecordingState'</b>:
     *
     * Provides the audio message recording state.
     *
     * @param act The act which was previously returned by the
     * sendAudioMessageRecordingStateUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendAudioMessageRecordingStateRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'AudioMessageRecordingState'.
     */
    void sendAudioMessageRecordingStateRelUpRegAll ();

    /**
     * Returns the current value of the property 'AudioMessageRecordingState'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasAudioMessageRecordingState() returns true.
     *
     * @return the previously received value of the property 'AudioMessageRecordingState'.
     */
    const AudioMessageRecordingStateStatus& getAudioMessageRecordingState() const;

    /**
     * Determines whether a status message for the property 'AudioMessageRecordingState' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAudioMessageRecordingState() const;

    /**
     * Request the value of the property 'AudioMessageRecordingState' from the
     * CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'AudioMessageRecordingState'</b>:
     *
     * Provides the audio message recording state.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAudioMessageRecordingStateGet(AudioMessageRecordingStateCallbackIF& cb);

    // Property 'RecordedAudioMessageInfo'

    /**
     * Notify on the property 'RecordedAudioMessageInfo'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'RecordedAudioMessageInfo'</b>:
     *
     * Property provides the handle of the recorded audio message. It is sent by Messaging in the case where the recording limit has been reached.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRecordedAudioMessageInfoUpReg(RecordedAudioMessageInfoCallbackIF& cb);

    /**
     * Remove the notifcation on property 'RecordedAudioMessageInfo'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'RecordedAudioMessageInfo'</b>:
     *
     * Property provides the handle of the recorded audio message. It is sent by Messaging in the case where the recording limit has been reached.
     *
     * @param act The act which was previously returned by the
     * sendRecordedAudioMessageInfoUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendRecordedAudioMessageInfoRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'RecordedAudioMessageInfo'.
     */
    void sendRecordedAudioMessageInfoRelUpRegAll ();

    /**
     * Returns the current value of the property 'RecordedAudioMessageInfo'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasRecordedAudioMessageInfo() returns true.
     *
     * @return the previously received value of the property 'RecordedAudioMessageInfo'.
     */
    const RecordedAudioMessageInfoStatus& getRecordedAudioMessageInfo() const;

    /**
     * Determines whether a status message for the property 'RecordedAudioMessageInfo' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasRecordedAudioMessageInfo() const;

    /**
     * Request the value of the property 'RecordedAudioMessageInfo' from the
     * CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'RecordedAudioMessageInfo'</b>:
     *
     * Property provides the handle of the recorded audio message. It is sent by Messaging in the case where the recording limit has been reached.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRecordedAudioMessageInfoGet(RecordedAudioMessageInfoCallbackIF& cb);

    // Property 'PredefinedMessageList'

    /**
     * Notify on the property 'PredefinedMessageList'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'PredefinedMessageList'</b>:
     *
     * This property contains the predefined message list. The list is ordered per the requirements in the HMI Form and Behavior Specification.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPredefinedMessageListUpReg(PredefinedMessageListCallbackIF& cb);

    /**
     * Remove the notifcation on property 'PredefinedMessageList'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'PredefinedMessageList'</b>:
     *
     * This property contains the predefined message list. The list is ordered per the requirements in the HMI Form and Behavior Specification.
     *
     * @param act The act which was previously returned by the
     * sendPredefinedMessageListUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendPredefinedMessageListRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'PredefinedMessageList'.
     */
    void sendPredefinedMessageListRelUpRegAll ();

    /**
     * Returns the current value of the property 'PredefinedMessageList' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasPredefinedMessageList() returns true.
     *
     * @return the previously received value of the property 'PredefinedMessageList'.
     */
    const PredefinedMessageListStatus& getPredefinedMessageList() const;

    /**
     * Determines whether a status message for the property 'PredefinedMessageList' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasPredefinedMessageList() const;

    /**
     * Request the value of the property 'PredefinedMessageList' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'PredefinedMessageList'</b>:
     *
     * This property contains the predefined message list. The list is ordered per the requirements in the HMI Form and Behavior Specification.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPredefinedMessageListGet(PredefinedMessageListCallbackIF& cb);

    // Property 'MessagingAudioPlaybackState'

    /**
     * Notify on the property 'MessagingAudioPlaybackState'. This method sends
     * a UpReg message to the CCA server.
     *
     * <b>Documentation of 'MessagingAudioPlaybackState'</b>:
     *
     * Provides notification of the playback status for all audio related functions within Messaging: Text-to-Speech session, when reading a message aloud, and listening to a recorded audio message.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMessagingAudioPlaybackStateUpReg(MessagingAudioPlaybackStateCallbackIF& cb);

    /**
     * Remove the notifcation on property 'MessagingAudioPlaybackState'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'MessagingAudioPlaybackState'</b>:
     *
     * Provides notification of the playback status for all audio related functions within Messaging: Text-to-Speech session, when reading a message aloud, and listening to a recorded audio message.
     *
     * @param act The act which was previously returned by the
     * sendMessagingAudioPlaybackStateUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendMessagingAudioPlaybackStateRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'MessagingAudioPlaybackState'.
     */
    void sendMessagingAudioPlaybackStateRelUpRegAll ();

    /**
     * Returns the current value of the property 'MessagingAudioPlaybackState'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasMessagingAudioPlaybackState() returns true.
     *
     * @return the previously received value of the property 'MessagingAudioPlaybackState'.
     */
    const MessagingAudioPlaybackStateStatus& getMessagingAudioPlaybackState() const;

    /**
     * Determines whether a status message for the property 'MessagingAudioPlaybackState' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasMessagingAudioPlaybackState() const;

    /**
     * Request the value of the property 'MessagingAudioPlaybackState' from
     * the CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'MessagingAudioPlaybackState'</b>:
     *
     * Provides notification of the playback status for all audio related functions within Messaging: Text-to-Speech session, when reading a message aloud, and listening to a recorded audio message.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMessagingAudioPlaybackStateGet(MessagingAudioPlaybackStateCallbackIF& cb);

    // Property 'TextAlertEnable'

    /**
     * Notify on the property 'TextAlertEnable'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'TextAlertEnable'</b>:
     *
     * Provides the ability to turn the Text Alert On or Off.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTextAlertEnableUpReg(TextAlertEnableCallbackIF& cb);

    /**
     * Remove the notifcation on property 'TextAlertEnable'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'TextAlertEnable'</b>:
     *
     * Provides the ability to turn the Text Alert On or Off.
     *
     * @param act The act which was previously returned by the
     * sendTextAlertEnableUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendTextAlertEnableRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'TextAlertEnable'.
     */
    void sendTextAlertEnableRelUpRegAll ();

    /**
     * Returns the current value of the property 'TextAlertEnable' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasTextAlertEnable() returns true.
     *
     * @return the previously received value of the property 'TextAlertEnable'.
     */
    const TextAlertEnableStatus& getTextAlertEnable() const;

    /**
     * Determines whether a status message for the property 'TextAlertEnable' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasTextAlertEnable() const;

    /**
     * Request the value of the property 'TextAlertEnable' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'TextAlertEnable'</b>:
     *
     * Provides the ability to turn the Text Alert On or Off.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTextAlertEnableGet(TextAlertEnableCallbackIF& cb);

    /**
     * Set the value of the property 'TextAlertEnable'. This method sends a
     * PureSet message to the CCA server.
     *
     * <b>Documentation of 'TextAlertEnable'</b>:
     *
     * Provides the ability to turn the Text Alert On or Off.
     *
     * @param bTextAlertOnOff Identifies if the Text Alert is On or Off.
     */

    void sendTextAlertEnablePureSet(bool bTextAlertOnOff);

    // Property 'EmailAlertEnable'

    /**
     * Notify on the property 'EmailAlertEnable'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'EmailAlertEnable'</b>:
     *
     * Provides the ability to turn the Email Alert On or Off.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEmailAlertEnableUpReg(EmailAlertEnableCallbackIF& cb);

    /**
     * Remove the notifcation on property 'EmailAlertEnable'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'EmailAlertEnable'</b>:
     *
     * Provides the ability to turn the Email Alert On or Off.
     *
     * @param act The act which was previously returned by the
     * sendEmailAlertEnableUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendEmailAlertEnableRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'EmailAlertEnable'.
     */
    void sendEmailAlertEnableRelUpRegAll ();

    /**
     * Returns the current value of the property 'EmailAlertEnable' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasEmailAlertEnable() returns true.
     *
     * @return the previously received value of the property 'EmailAlertEnable'.
     */
    const EmailAlertEnableStatus& getEmailAlertEnable() const;

    /**
     * Determines whether a status message for the property 'EmailAlertEnable' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasEmailAlertEnable() const;

    /**
     * Request the value of the property 'EmailAlertEnable' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'EmailAlertEnable'</b>:
     *
     * Provides the ability to turn the Email Alert On or Off.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEmailAlertEnableGet(EmailAlertEnableCallbackIF& cb);

    /**
     * Set the value of the property 'EmailAlertEnable'. This method sends a
     * PureSet message to the CCA server.
     *
     * <b>Documentation of 'EmailAlertEnable'</b>:
     *
     * Provides the ability to turn the Email Alert On or Off.
     *
     * @param bEmailAlertOnOff Identifies if the Email Alert is On or Off.
     */

    void sendEmailAlertEnablePureSet(bool bEmailAlertOnOff);

    // Property 'SaveSentText'

    /**
     * Notify on the property 'SaveSentText'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'SaveSentText'</b>:
     *
     * Provides the ability to enable or disable the saving of a copy of a sent text message in the sent folder.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSaveSentTextUpReg(SaveSentTextCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SaveSentText'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SaveSentText'</b>:
     *
     * Provides the ability to enable or disable the saving of a copy of a sent text message in the sent folder.
     *
     * @param act The act which was previously returned by the
     * sendSaveSentTextUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSaveSentTextRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SaveSentText'.
     */
    void sendSaveSentTextRelUpRegAll ();

    /**
     * Returns the current value of the property 'SaveSentText' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasSaveSentText() returns true.
     *
     * @return the previously received value of the property 'SaveSentText'.
     */
    const SaveSentTextStatus& getSaveSentText() const;

    /**
     * Determines whether a status message for the property 'SaveSentText' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSaveSentText() const;

    /**
     * Request the value of the property 'SaveSentText' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'SaveSentText'</b>:
     *
     * Provides the ability to enable or disable the saving of a copy of a sent text message in the sent folder.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSaveSentTextGet(SaveSentTextCallbackIF& cb);

    /**
     * Set the value of the property 'SaveSentText'. This method sends a
     * PureSet message to the CCA server.
     *
     * <b>Documentation of 'SaveSentText'</b>:
     *
     * Provides the ability to enable or disable the saving of a copy of a sent text message in the sent folder.
     *
     * @param bSaveSentTextOnOff Identifies if the saving of sent text messages is On or Off.
     */

    void sendSaveSentTextPureSet(bool bSaveSentTextOnOff);

    // Property 'SaveSentEmail'

    /**
     * Notify on the property 'SaveSentEmail'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'SaveSentEmail'</b>:
     *
     * Provides the ability to enable or disable the saving of a copy of a sent email message in the sent folder.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSaveSentEmailUpReg(SaveSentEmailCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SaveSentEmail'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SaveSentEmail'</b>:
     *
     * Provides the ability to enable or disable the saving of a copy of a sent email message in the sent folder.
     *
     * @param act The act which was previously returned by the
     * sendSaveSentEmailUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSaveSentEmailRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SaveSentEmail'.
     */
    void sendSaveSentEmailRelUpRegAll ();

    /**
     * Returns the current value of the property 'SaveSentEmail' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasSaveSentEmail() returns true.
     *
     * @return the previously received value of the property 'SaveSentEmail'.
     */
    const SaveSentEmailStatus& getSaveSentEmail() const;

    /**
     * Determines whether a status message for the property 'SaveSentEmail' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSaveSentEmail() const;

    /**
     * Request the value of the property 'SaveSentEmail' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'SaveSentEmail'</b>:
     *
     * Provides the ability to enable or disable the saving of a copy of a sent email message in the sent folder.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSaveSentEmailGet(SaveSentEmailCallbackIF& cb);

    /**
     * Set the value of the property 'SaveSentEmail'. This method sends a
     * PureSet message to the CCA server.
     *
     * <b>Documentation of 'SaveSentEmail'</b>:
     *
     * Provides the ability to enable or disable the saving of a copy of a sent email message in the sent folder.
     *
     * @param bSaveSentEmailOnOff Identifies if the saving of sent email messages is On or Off.
     */

    void sendSaveSentEmailPureSet(bool bSaveSentEmailOnOff);

    // Property 'MapDeviceCapabilities'

    /**
     * Notify on the property 'MapDeviceCapabilities'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'MapDeviceCapabilities'</b>:
     *
     * This property MapDeviceCapabilities has become DEPRECATED.
     * HMI Controllers are recommended to register for MapDeviceCapabilitiesExtended, since it already includes the functionalities of MapDeviceCapabilities.
     *
     * This Property will update the MAP capabilities of the connected device like the supported message types of the MAP connected phone along with the MAP features supported.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMapDeviceCapabilitiesUpReg(MapDeviceCapabilitiesCallbackIF& cb);

    /**
     * Remove the notifcation on property 'MapDeviceCapabilities'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'MapDeviceCapabilities'</b>:
     *
     * This property MapDeviceCapabilities has become DEPRECATED.
     * HMI Controllers are recommended to register for MapDeviceCapabilitiesExtended, since it already includes the functionalities of MapDeviceCapabilities.
     *
     * This Property will update the MAP capabilities of the connected device like the supported message types of the MAP connected phone along with the MAP features supported.
     *
     * @param act The act which was previously returned by the
     * sendMapDeviceCapabilitiesUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendMapDeviceCapabilitiesRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'MapDeviceCapabilities'.
     */
    void sendMapDeviceCapabilitiesRelUpRegAll ();

    /**
     * Returns the current value of the property 'MapDeviceCapabilities' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasMapDeviceCapabilities() returns true.
     *
     * @return the previously received value of the property 'MapDeviceCapabilities'.
     */
    const MapDeviceCapabilitiesStatus& getMapDeviceCapabilities() const;

    /**
     * Determines whether a status message for the property 'MapDeviceCapabilities' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasMapDeviceCapabilities() const;

    /**
     * Request the value of the property 'MapDeviceCapabilities' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'MapDeviceCapabilities'</b>:
     *
     * This property MapDeviceCapabilities has become DEPRECATED.
     * HMI Controllers are recommended to register for MapDeviceCapabilitiesExtended, since it already includes the functionalities of MapDeviceCapabilities.
     *
     * This Property will update the MAP capabilities of the connected device like the supported message types of the MAP connected phone along with the MAP features supported.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMapDeviceCapabilitiesGet(MapDeviceCapabilitiesCallbackIF& cb);

    // Property 'MessagingOnOff'

    /**
     * Notify on the property 'MessagingOnOff'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'MessagingOnOff'</b>:
     *
     * This Property will switch ON / OFF the Message Access Profile (MAP). This is a general setting which will affect all the phones. When disabled no MAP will be connected.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMessagingOnOffUpReg(MessagingOnOffCallbackIF& cb);

    /**
     * Remove the notifcation on property 'MessagingOnOff'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'MessagingOnOff'</b>:
     *
     * This Property will switch ON / OFF the Message Access Profile (MAP). This is a general setting which will affect all the phones. When disabled no MAP will be connected.
     *
     * @param act The act which was previously returned by the
     * sendMessagingOnOffUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendMessagingOnOffRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'MessagingOnOff'.
     */
    void sendMessagingOnOffRelUpRegAll ();

    /**
     * Returns the current value of the property 'MessagingOnOff' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasMessagingOnOff() returns true.
     *
     * @return the previously received value of the property 'MessagingOnOff'.
     */
    const MessagingOnOffStatus& getMessagingOnOff() const;

    /**
     * Determines whether a status message for the property 'MessagingOnOff' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasMessagingOnOff() const;

    /**
     * Request the value of the property 'MessagingOnOff' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'MessagingOnOff'</b>:
     *
     * This Property will switch ON / OFF the Message Access Profile (MAP). This is a general setting which will affect all the phones. When disabled no MAP will be connected.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMessagingOnOffGet(MessagingOnOffCallbackIF& cb);

    /**
     * Set the value of the property 'MessagingOnOff'. This method sends a Set
     * message to the CCA server.
     *
     * <b>Documentation of 'MessagingOnOff'</b>:
     *
     * This Property will switch ON / OFF the Message Access Profile (MAP). This is a general setting which will affect all the phones. When disabled no MAP will be connected.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param MapOnOff MAP ON or OFF
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMessagingOnOffSet(MessagingOnOffCallbackIF& cb, bool mapOnOff);

    // Property 'MessageNotification'

    /**
     * Notify on the property 'MessageNotification'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'MessageNotification'</b>:
     *
     * This Property will update whenever
     * The connected device receives a new message,
     * A message is uploaded to the remote device,
     * Message is delivered to the network,
     * Message is deleted in the connected device.
     * Failure in uploading the message to the device or to the network.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMessageNotificationUpReg(MessageNotificationCallbackIF& cb);

    /**
     * Remove the notifcation on property 'MessageNotification'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'MessageNotification'</b>:
     *
     * This Property will update whenever
     * The connected device receives a new message,
     * A message is uploaded to the remote device,
     * Message is delivered to the network,
     * Message is deleted in the connected device.
     * Failure in uploading the message to the device or to the network.
     *
     * @param act The act which was previously returned by the
     * sendMessageNotificationUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendMessageNotificationRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'MessageNotification'.
     */
    void sendMessageNotificationRelUpRegAll ();

    /**
     * Returns the current value of the property 'MessageNotification' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasMessageNotification() returns true.
     *
     * @return the previously received value of the property 'MessageNotification'.
     */
    const MessageNotificationStatus& getMessageNotification() const;

    /**
     * Determines whether a status message for the property 'MessageNotification' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasMessageNotification() const;

    /**
     * Request the value of the property 'MessageNotification' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'MessageNotification'</b>:
     *
     * This Property will update whenever
     * The connected device receives a new message,
     * A message is uploaded to the remote device,
     * Message is delivered to the network,
     * Message is deleted in the connected device.
     * Failure in uploading the message to the device or to the network.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMessageNotificationGet(MessageNotificationCallbackIF& cb);

    // Property 'PredefinedMessageListExtended'

    /**
     * Notify on the property 'PredefinedMessageListExtended'. This method
     * sends a UpReg message to the CCA server.
     *
     * <b>Documentation of 'PredefinedMessageListExtended'</b>:
     *
     * This property contains the predefined message list. The list is ordered per the requirements in the HMI Form and Behavior Specification.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPredefinedMessageListExtendedUpReg(PredefinedMessageListExtendedCallbackIF& cb);

    /**
     * Remove the notifcation on property 'PredefinedMessageListExtended'.
     * This method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'PredefinedMessageListExtended'</b>:
     *
     * This property contains the predefined message list. The list is ordered per the requirements in the HMI Form and Behavior Specification.
     *
     * @param act The act which was previously returned by the
     * sendPredefinedMessageListExtendedUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendPredefinedMessageListExtendedRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'PredefinedMessageListExtended'.
     */
    void sendPredefinedMessageListExtendedRelUpRegAll ();

    /**
     * Returns the current value of the property
     * 'PredefinedMessageListExtended' (as known by the proxy). This method is
     * only allowed to be called when a status message for this property was
     * received before. Otherwise the behavior of this method is undefined. It
     * is safe to call this method when hasPredefinedMessageListExtended()
     * returns true.
     *
     * @return the previously received value of the property 'PredefinedMessageListExtended'.
     */
    const PredefinedMessageListExtendedStatus& getPredefinedMessageListExtended() const;

    /**
     * Determines whether a status message for the property 'PredefinedMessageListExtended' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasPredefinedMessageListExtended() const;

    /**
     * Request the value of the property 'PredefinedMessageListExtended' from
     * the CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'PredefinedMessageListExtended'</b>:
     *
     * This property contains the predefined message list. The list is ordered per the requirements in the HMI Form and Behavior Specification.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPredefinedMessageListExtendedGet(PredefinedMessageListExtendedCallbackIF& cb);

    // Property 'MessagingLanguage'

    /**
     * Notify on the property 'MessagingLanguage'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'MessagingLanguage'</b>:
     *
     * This property will set the language to the Messaging F-Block and based on the set language the pre-defined message list will be provided to HMI.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMessagingLanguageUpReg(MessagingLanguageCallbackIF& cb);

    /**
     * Remove the notifcation on property 'MessagingLanguage'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'MessagingLanguage'</b>:
     *
     * This property will set the language to the Messaging F-Block and based on the set language the pre-defined message list will be provided to HMI.
     *
     * @param act The act which was previously returned by the
     * sendMessagingLanguageUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendMessagingLanguageRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'MessagingLanguage'.
     */
    void sendMessagingLanguageRelUpRegAll ();

    /**
     * Returns the current value of the property 'MessagingLanguage' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasMessagingLanguage() returns true.
     *
     * @return the previously received value of the property 'MessagingLanguage'.
     */
    const MessagingLanguageStatus& getMessagingLanguage() const;

    /**
     * Determines whether a status message for the property 'MessagingLanguage' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasMessagingLanguage() const;

    /**
     * Request the value of the property 'MessagingLanguage' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'MessagingLanguage'</b>:
     *
     * This property will set the language to the Messaging F-Block and based on the set language the pre-defined message list will be provided to HMI.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMessagingLanguageGet(MessagingLanguageCallbackIF& cb);

    /**
     * Set the value of the property 'MessagingLanguage'. This method sends a
     * Set message to the CCA server.
     *
     * <b>Documentation of 'MessagingLanguage'</b>:
     *
     * This property will set the language to the Messaging F-Block and based on the set language the pre-defined message list will be provided to HMI.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param e8LanguageSet This will report the current vehicle language set.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMessagingLanguageSet(MessagingLanguageCallbackIF& cb, ::most_Msg_fi_types_Extended::T_e8_MsgLanguageSet e8LanguageSet);

    // Property 'SignatureSettingExtended'

    /**
     * Notify on the property 'SignatureSettingExtended'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'SignatureSettingExtended'</b>:
     *
     * Used to set and acquire the signature text to be appended to the end of a message.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSignatureSettingExtendedUpReg(SignatureSettingExtendedCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SignatureSettingExtended'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SignatureSettingExtended'</b>:
     *
     * Used to set and acquire the signature text to be appended to the end of a message.
     *
     * @param act The act which was previously returned by the
     * sendSignatureSettingExtendedUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSignatureSettingExtendedRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SignatureSettingExtended'.
     */
    void sendSignatureSettingExtendedRelUpRegAll ();

    /**
     * Returns the current value of the property 'SignatureSettingExtended'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasSignatureSettingExtended() returns true.
     *
     * @return the previously received value of the property 'SignatureSettingExtended'.
     */
    const SignatureSettingExtendedStatus& getSignatureSettingExtended() const;

    /**
     * Determines whether a status message for the property 'SignatureSettingExtended' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSignatureSettingExtended() const;

    /**
     * Request the value of the property 'SignatureSettingExtended' from the
     * CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'SignatureSettingExtended'</b>:
     *
     * Used to set and acquire the signature text to be appended to the end of a message.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSignatureSettingExtendedGet(SignatureSettingExtendedCallbackIF& cb);

    /**
     * Set the value of the property 'SignatureSettingExtended'. This method
     * sends a PureSet message to the CCA server.
     *
     * <b>Documentation of 'SignatureSettingExtended'</b>:
     *
     * Used to set and acquire the signature text to be appended to the end of a message.
     *
     * @param oSignatureTextStream This stream contains the list of SignatureText and on-off property for the paired DeviceHandles
     */

    void sendSignatureSettingExtendedPureSet(const ::most_Msg_fi_types_Extended::T_SignatureTextStream& oSignatureTextStream);

    // Property 'MessagingOnOffList'

    /**
     * Notify on the property 'MessagingOnOffList'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'MessagingOnOffList'</b>:
     *
     * This property allows the clients to set the MAP on/off and updates the OnOff status to clients for all paired devices
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMessagingOnOffListUpReg(MessagingOnOffListCallbackIF& cb);

    /**
     * Remove the notifcation on property 'MessagingOnOffList'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'MessagingOnOffList'</b>:
     *
     * This property allows the clients to set the MAP on/off and updates the OnOff status to clients for all paired devices
     *
     * @param act The act which was previously returned by the
     * sendMessagingOnOffListUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendMessagingOnOffListRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'MessagingOnOffList'.
     */
    void sendMessagingOnOffListRelUpRegAll ();

    /**
     * Returns the current value of the property 'MessagingOnOffList' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasMessagingOnOffList() returns true.
     *
     * @return the previously received value of the property 'MessagingOnOffList'.
     */
    const MessagingOnOffListStatus& getMessagingOnOffList() const;

    /**
     * Determines whether a status message for the property 'MessagingOnOffList' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasMessagingOnOffList() const;

    /**
     * Request the value of the property 'MessagingOnOffList' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'MessagingOnOffList'</b>:
     *
     * This property allows the clients to set the MAP on/off and updates the OnOff status to clients for all paired devices
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMessagingOnOffListGet(MessagingOnOffListCallbackIF& cb);

    // Property 'TextRingtoneOnOffList'

    /**
     * Notify on the property 'TextRingtoneOnOffList'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'TextRingtoneOnOffList'</b>:
     *
     * This property allows the clients to set the text ringtone on/off and updates the OnOff status to clients for all paired devices
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTextRingtoneOnOffListUpReg(TextRingtoneOnOffListCallbackIF& cb);

    /**
     * Remove the notifcation on property 'TextRingtoneOnOffList'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'TextRingtoneOnOffList'</b>:
     *
     * This property allows the clients to set the text ringtone on/off and updates the OnOff status to clients for all paired devices
     *
     * @param act The act which was previously returned by the
     * sendTextRingtoneOnOffListUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendTextRingtoneOnOffListRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'TextRingtoneOnOffList'.
     */
    void sendTextRingtoneOnOffListRelUpRegAll ();

    /**
     * Returns the current value of the property 'TextRingtoneOnOffList' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasTextRingtoneOnOffList() returns true.
     *
     * @return the previously received value of the property 'TextRingtoneOnOffList'.
     */
    const TextRingtoneOnOffListStatus& getTextRingtoneOnOffList() const;

    /**
     * Determines whether a status message for the property 'TextRingtoneOnOffList' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasTextRingtoneOnOffList() const;

    /**
     * Request the value of the property 'TextRingtoneOnOffList' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'TextRingtoneOnOffList'</b>:
     *
     * This property allows the clients to set the text ringtone on/off and updates the OnOff status to clients for all paired devices
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTextRingtoneOnOffListGet(TextRingtoneOnOffListCallbackIF& cb);

    /**
     * Set the value of the property 'TextRingtoneOnOffList'. This method
     * sends a PureSet message to the CCA server.
     *
     * <b>Documentation of 'TextRingtoneOnOffList'</b>:
     *
     * This property allows the clients to set the text ringtone on/off and updates the OnOff status to clients for all paired devices
     *
     * @param oTextRingtoneOnOffList This list contains the TextRingtoneOnOff setting by the client for the corresponding DeviceHandles.
     */

    void sendTextRingtoneOnOffListPureSet(const ::most_Msg_fi_types_Extended::T_OnOffList& oTextRingtoneOnOffList);

    // Property 'AutoReplyOnOffList'

    /**
     * Notify on the property 'AutoReplyOnOffList'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'AutoReplyOnOffList'</b>:
     *
     * This property allows the clients to set the Auto-reply on/off and updates the OnOff status to clients for all paired devices
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAutoReplyOnOffListUpReg(AutoReplyOnOffListCallbackIF& cb);

    /**
     * Remove the notifcation on property 'AutoReplyOnOffList'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'AutoReplyOnOffList'</b>:
     *
     * This property allows the clients to set the Auto-reply on/off and updates the OnOff status to clients for all paired devices
     *
     * @param act The act which was previously returned by the
     * sendAutoReplyOnOffListUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendAutoReplyOnOffListRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'AutoReplyOnOffList'.
     */
    void sendAutoReplyOnOffListRelUpRegAll ();

    /**
     * Returns the current value of the property 'AutoReplyOnOffList' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasAutoReplyOnOffList() returns true.
     *
     * @return the previously received value of the property 'AutoReplyOnOffList'.
     */
    const AutoReplyOnOffListStatus& getAutoReplyOnOffList() const;

    /**
     * Determines whether a status message for the property 'AutoReplyOnOffList' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAutoReplyOnOffList() const;

    /**
     * Request the value of the property 'AutoReplyOnOffList' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'AutoReplyOnOffList'</b>:
     *
     * This property allows the clients to set the Auto-reply on/off and updates the OnOff status to clients for all paired devices
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAutoReplyOnOffListGet(AutoReplyOnOffListCallbackIF& cb);

    /**
     * Set the value of the property 'AutoReplyOnOffList'. This method sends a
     * PureSet message to the CCA server.
     *
     * <b>Documentation of 'AutoReplyOnOffList'</b>:
     *
     * This property allows the clients to set the Auto-reply on/off and updates the OnOff status to clients for all paired devices
     *
     * @param oAutoReplyOnOffList This list contains the AutoReplyOnOff setting by the client for the corresponding DeviceHandles.
     */

    void sendAutoReplyOnOffListPureSet(const ::most_Msg_fi_types_Extended::T_OnOffList& oAutoReplyOnOffList);

    // Property 'AutoReplyTextList'

    /**
     * Notify on the property 'AutoReplyTextList'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'AutoReplyTextList'</b>:
     *
     * This property allows the clients to set the Auto-reply Message Handle and updates the Auto reply Msg Handles to the clients for all paired devices
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAutoReplyTextListUpReg(AutoReplyTextListCallbackIF& cb);

    /**
     * Remove the notifcation on property 'AutoReplyTextList'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'AutoReplyTextList'</b>:
     *
     * This property allows the clients to set the Auto-reply Message Handle and updates the Auto reply Msg Handles to the clients for all paired devices
     *
     * @param act The act which was previously returned by the
     * sendAutoReplyTextListUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendAutoReplyTextListRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'AutoReplyTextList'.
     */
    void sendAutoReplyTextListRelUpRegAll ();

    /**
     * Returns the current value of the property 'AutoReplyTextList' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasAutoReplyTextList() returns true.
     *
     * @return the previously received value of the property 'AutoReplyTextList'.
     */
    const AutoReplyTextListStatus& getAutoReplyTextList() const;

    /**
     * Determines whether a status message for the property 'AutoReplyTextList' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAutoReplyTextList() const;

    /**
     * Request the value of the property 'AutoReplyTextList' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'AutoReplyTextList'</b>:
     *
     * This property allows the clients to set the Auto-reply Message Handle and updates the Auto reply Msg Handles to the clients for all paired devices
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAutoReplyTextListGet(AutoReplyTextListCallbackIF& cb);

    /**
     * Set the value of the property 'AutoReplyTextList'. This method sends a
     * PureSet message to the CCA server.
     *
     * <b>Documentation of 'AutoReplyTextList'</b>:
     *
     * This property allows the clients to set the Auto-reply Message Handle and updates the Auto reply Msg Handles to the clients for all paired devices
     *
     * @param oAutoReplyTextList This list contains the Message Handle setting by the client for the corresponding DeviceHandles.
     */

    void sendAutoReplyTextListPureSet(const ::most_Msg_fi_types_Extended::T_AutoReplyTextList& oAutoReplyTextList);

    // Property 'MapDeviceCapabilitiesExtended'

    /**
     * Notify on the property 'MapDeviceCapabilitiesExtended'. This method
     * sends a UpReg message to the CCA server.
     *
     * <b>Documentation of 'MapDeviceCapabilitiesExtended'</b>:
     *
     * This Property will update the clients on the MAP Capabilities for all connected devices, like the supported message types of the MAP connected phone along with the MAP features supported.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMapDeviceCapabilitiesExtendedUpReg(MapDeviceCapabilitiesExtendedCallbackIF& cb);

    /**
     * Remove the notifcation on property 'MapDeviceCapabilitiesExtended'.
     * This method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'MapDeviceCapabilitiesExtended'</b>:
     *
     * This Property will update the clients on the MAP Capabilities for all connected devices, like the supported message types of the MAP connected phone along with the MAP features supported.
     *
     * @param act The act which was previously returned by the
     * sendMapDeviceCapabilitiesExtendedUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendMapDeviceCapabilitiesExtendedRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'MapDeviceCapabilitiesExtended'.
     */
    void sendMapDeviceCapabilitiesExtendedRelUpRegAll ();

    /**
     * Returns the current value of the property
     * 'MapDeviceCapabilitiesExtended' (as known by the proxy). This method is
     * only allowed to be called when a status message for this property was
     * received before. Otherwise the behavior of this method is undefined. It
     * is safe to call this method when hasMapDeviceCapabilitiesExtended()
     * returns true.
     *
     * @return the previously received value of the property 'MapDeviceCapabilitiesExtended'.
     */
    const MapDeviceCapabilitiesExtendedStatus& getMapDeviceCapabilitiesExtended() const;

    /**
     * Determines whether a status message for the property 'MapDeviceCapabilitiesExtended' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasMapDeviceCapabilitiesExtended() const;

    /**
     * Request the value of the property 'MapDeviceCapabilitiesExtended' from
     * the CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'MapDeviceCapabilitiesExtended'</b>:
     *
     * This Property will update the clients on the MAP Capabilities for all connected devices, like the supported message types of the MAP connected phone along with the MAP features supported.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMapDeviceCapabilitiesExtendedGet(MapDeviceCapabilitiesExtendedCallbackIF& cb);

    /**
     * Release all property notifications (on all properties).
     */
    void sendRelUpRegAll ();

private:

    MOST_Msg_FIProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags);

    virtual void clearAllProperties ();

    ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > createCallback (uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb);

    // Property 'SourceInfo'

    ::asf::core::nullable< SourceInfoStatus > _sourceInfo;

    // Property 'SourceAvailable'

    ::asf::core::nullable< SourceAvailableStatus > _sourceAvailable;

    // Property 'MessageListChange'

    ::asf::core::nullable< MessageListChangeStatus > _messageListChange;

    // Property 'FolderListChange'

    ::asf::core::nullable< FolderListChangeStatus > _folderListChange;

    // Property 'MessagingDeviceConnection'

    ::asf::core::nullable< MessagingDeviceConnectionStatus > _messagingDeviceConnection;

    // Property 'UpdateInboxSettings'

    ::asf::core::nullable< UpdateInboxSettingsStatus > _updateInboxSettings;

    // Property 'AudioAttachmentPlaybackState'

    ::asf::core::nullable< AudioAttachmentPlaybackStateStatus > _audioAttachmentPlaybackState;

    // Property 'SignatureSetting'

    ::asf::core::nullable< SignatureSettingStatus > _signatureSetting;

    // Property 'AudioMessageRecordingState'

    ::asf::core::nullable< AudioMessageRecordingStateStatus > _audioMessageRecordingState;

    // Property 'RecordedAudioMessageInfo'

    ::asf::core::nullable< RecordedAudioMessageInfoStatus > _recordedAudioMessageInfo;

    // Property 'PredefinedMessageList'

    ::asf::core::nullable< PredefinedMessageListStatus > _predefinedMessageList;

    // Property 'MessagingAudioPlaybackState'

    ::asf::core::nullable< MessagingAudioPlaybackStateStatus > _messagingAudioPlaybackState;

    // Property 'TextAlertEnable'

    ::asf::core::nullable< TextAlertEnableStatus > _textAlertEnable;

    // Property 'EmailAlertEnable'

    ::asf::core::nullable< EmailAlertEnableStatus > _emailAlertEnable;

    // Property 'SaveSentText'

    ::asf::core::nullable< SaveSentTextStatus > _saveSentText;

    // Property 'SaveSentEmail'

    ::asf::core::nullable< SaveSentEmailStatus > _saveSentEmail;

    // Property 'MapDeviceCapabilities'

    ::asf::core::nullable< MapDeviceCapabilitiesStatus > _mapDeviceCapabilities;

    // Property 'MessagingOnOff'

    ::asf::core::nullable< MessagingOnOffStatus > _messagingOnOff;

    // Property 'MessageNotification'

    ::asf::core::nullable< MessageNotificationStatus > _messageNotification;

    // Property 'PredefinedMessageListExtended'

    ::asf::core::nullable< PredefinedMessageListExtendedStatus > _predefinedMessageListExtended;

    // Property 'MessagingLanguage'

    ::asf::core::nullable< MessagingLanguageStatus > _messagingLanguage;

    // Property 'SignatureSettingExtended'

    ::asf::core::nullable< SignatureSettingExtendedStatus > _signatureSettingExtended;

    // Property 'MessagingOnOffList'

    ::asf::core::nullable< MessagingOnOffListStatus > _messagingOnOffList;

    // Property 'TextRingtoneOnOffList'

    ::asf::core::nullable< TextRingtoneOnOffListStatus > _textRingtoneOnOffList;

    // Property 'AutoReplyOnOffList'

    ::asf::core::nullable< AutoReplyOnOffListStatus > _autoReplyOnOffList;

    // Property 'AutoReplyTextList'

    ::asf::core::nullable< AutoReplyTextListStatus > _autoReplyTextList;

    // Property 'MapDeviceCapabilitiesExtended'

    ::asf::core::nullable< MapDeviceCapabilitiesExtendedStatus > _mapDeviceCapabilitiesExtended;

    DECLARE_CLASS_LOGGER();

    friend class MOST_Msg_FIProxyCallback;
};

} // namespace MOST_Msg_FI

#endif // MOST_MSG_FIPROXY_H
