#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef MOST_MSG_FI_H
#define MOST_MSG_FI_H

#include "asf/cca/CcaTypes.h"
#include "asf/cca/CcaTypesConst.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "fi_basetypes_most.h"
#include "fi_basetypes_mostConst.h"
#include "most_Msg_fi_types.h"
#include "most_Msg_fi_typesConst.h"
#include "most_Msg_fi_types_Extended.h"
#include "most_Msg_fi_types_ExtendedConst.h"
#include "most_Src_fi_types.h"
#include "most_Src_fi_typesConst.h"
#include <cstring>
#include <vector>

/**
 * CCA Functional Interface 'MOST_Msg_FI'
 *
 * Fullname: Proprietary - Messaging
 *
 * Version: 2.4.3
 *
 * Author: Dave Pop, General Motors
 *
 * Date: 2012-02-24
 *
 * Department:
 *
 * Title:
 *       MOST_Messaging_FI
 *
 * <b>Description of 'MOST_Msg_FI':</b>
 *
 * <p>This FBlock was assembled from FBlockManifest file: Messaging.fblockman, Please consult individual interface files for interface-specific change history.</p>
 * This Messaging FBlock is implemented within the HMIModule. The Messaging FBlock handles all of the email and text messaging functions within Next-Gen Architecture.
 * Messaging implements the IMessaging interface, ISink, and ISource interfaces.  IMessaging provides all of the control interactions with the HMI, ISink is used to
 * receive microphone audio for voice memo recording, and ISource is used to provide readback of text and email messages.
 * See GIS-327 Bluetooth Requirements Specification, and GIS-368 Messaging FBlock Specification for detailed requirements.
 */

namespace MOST_Msg_FI {

static const int SERVICE_ID = 559;

static const int FID_SourceInfo = 256;

static const int FID_SourceAvailable = 3120;

static const int FID_MessageListChange = 514;

static const int FID_FolderListChange = 517;

static const int FID_MessagingDeviceConnection = 528;

static const int FID_UpdateInboxSettings = 530;

static const int FID_AudioAttachmentPlaybackState = 535;

static const int FID_SignatureSetting = 545;

static const int FID_AudioMessageRecordingState = 549;

static const int FID_RecordedAudioMessageInfo = 550;

static const int FID_PredefinedMessageList = 552;

static const int FID_MessagingAudioPlaybackState = 562;

static const int FID_TextAlertEnable = 577;

static const int FID_EmailAlertEnable = 578;

static const int FID_SaveSentText = 579;

static const int FID_SaveSentEmail = 580;

static const int FID_Allocate = 257;

static const int FID_DeAllocate = 258;

static const int FID_SourceActivity = 259;

static const int FID_CreateMessageList = 512;

static const int FID_RequestSliceMessageList = 513;

static const int FID_ReleaseMessageList = 515;

static const int FID_RequestFolderList = 516;

static const int FID_DeleteMessage = 518;

static const int FID_RecoverMessage = 519;

static const int FID_RequestAccountList = 520;

static const int FID_ChangeAccount = 521;

static const int FID_UpdateInbox = 529;

static const int FID_GetMessage = 532;

static const int FID_GetAttachmentList = 533;

static const int FID_AudioAttachmentPlayback = 534;

static const int FID_GetImageAttachment = 536;

static const int FID_GetBodyPartList = 537;

static const int FID_ReadMessageAloud = 544;

static const int FID_RecordAudioMessage = 547;

static const int FID_PlaybackAudioMessage = 548;

static const int FID_AddPredefinedMessage = 553;

static const int FID_DeletePredefinedMessage = 560;

static const int FID_GetConversationMessages = 563;

static const int FID_SendMessage = 564;

static const int FID_ProvideMessageHeader = 566;

static const int FID_ProvideMessageBody = 567;

static const int FID_GetMsgBodyActionElement = 568;

static const int FID_GetImageAttachmentInfo = 576;

static const int FID_CreateMessage = 581;

static const int FID_ClearUserMessagingInfo = 582;

static const int FID_MapDeviceCapabilities = 3841;

static const int FID_MessagingOnOff = 3842;

static const int FID_MessageNotification = 3843;

static const int FID_PredefinedMessageListExtended = 3845;

static const int FID_MessagingLanguage = 3847;

static const int FID_SignatureSettingExtended = 3856;

static const int FID_MessagingOnOffList = 3861;

static const int FID_TextRingtoneOnOffList = 3862;

static const int FID_AutoReplyOnOffList = 3863;

static const int FID_AutoReplyTextList = 3864;

static const int FID_MapDeviceCapabilitiesExtended = 3865;

static const int FID_ConnectMapProfile = 3844;

static const int FID_EditPredefinedMessage = 3846;

static const int FID_AddPredefinedMessageExtended = 3848;

static const int FID_ReadMessageAloudExtended = 3849;

static const int FID_RequestSliceConversationList = 3857;

static const int FID_GetSliceConversationDetails = 3858;

static const int FID_SwitchMapOnOff = 3859;

static const int FID_AddCustomMessage = 3860;


ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 2;

static const int VERSION_MINOR = 4;

static const int VERSION_PATCH = 3;

// forward declarations
class SourceInfoStatus;

class SourceInfoGet;

class SourceInfoErrorStructure;

class SourceInfoError;

class SourceAvailableStatus;

class SourceAvailableErrorStructure;

class SourceAvailableError;

class MessageListChangeStatus;

class FolderListChangeStatus;

class MessagingDeviceConnectionStatus;

class UpdateInboxSettingsStatus;

class UpdateInboxSettingsPureSet;

class UpdateInboxSettingsErrorStructure;

class UpdateInboxSettingsError;

class AudioAttachmentPlaybackStateStatus;

class AudioAttachmentPlaybackStateErrorStructure;

class AudioAttachmentPlaybackStateError;

class SignatureSettingStatus;

class SignatureSettingPureSet;

class SignatureSettingErrorStructure;

class SignatureSettingError;

class AudioMessageRecordingStateStatus;

class AudioMessageRecordingStateErrorStructure;

class AudioMessageRecordingStateError;

class RecordedAudioMessageInfoStatus;

class RecordedAudioMessageInfoErrorStructure;

class RecordedAudioMessageInfoError;

class PredefinedMessageListStatus;

class PredefinedMessageListErrorStructure;

class PredefinedMessageListError;

class MessagingAudioPlaybackStateStatus;

class TextAlertEnableStatus;

class TextAlertEnablePureSet;

class TextAlertEnableErrorStructure;

class TextAlertEnableError;

class EmailAlertEnableStatus;

class EmailAlertEnablePureSet;

class EmailAlertEnableErrorStructure;

class EmailAlertEnableError;

class SaveSentTextStatus;

class SaveSentTextPureSet;

class SaveSentTextErrorStructure;

class SaveSentTextError;

class SaveSentEmailStatus;

class SaveSentEmailPureSet;

class SaveSentEmailErrorStructure;

class SaveSentEmailError;

class AllocateStart;

class AllocateResult;

class AllocateErrorStructure;

class AllocateError;

class DeAllocateStart;

class DeAllocateResult;

class DeAllocateErrorStructure;

class DeAllocateError;

class SourceActivityStart;

class SourceActivityResult;

class SourceActivityErrorStructure;

class SourceActivityError;

class CreateMessageListStart;

class CreateMessageListResult;

class CreateMessageListErrorStructure;

class CreateMessageListError;

class RequestSliceMessageListStart;

class RequestSliceMessageListResult;

class RequestSliceMessageListErrorStructure;

class RequestSliceMessageListError;

class ReleaseMessageListStart;

class ReleaseMessageListResult;

class ReleaseMessageListErrorStructure;

class ReleaseMessageListError;

class RequestFolderListStart;

class RequestFolderListResult;

class RequestFolderListErrorStructure;

class RequestFolderListError;

class DeleteMessageStart;

class DeleteMessageResult;

class DeleteMessageErrorStructure;

class DeleteMessageError;

class RecoverMessageStart;

class RecoverMessageResult;

class RecoverMessageErrorStructure;

class RecoverMessageError;

class RequestAccountListStart;

class RequestAccountListResult;

class RequestAccountListErrorStructure;

class RequestAccountListError;

class ChangeAccountStart;

class ChangeAccountResult;

class ChangeAccountErrorStructure;

class ChangeAccountError;

class UpdateInboxErrorStructure;

class UpdateInboxError;

class GetMessageStart;

class GetMessageResult;

class GetMessageErrorStructure;

class GetMessageError;

class GetAttachmentListStart;

class GetAttachmentListResult;

class GetAttachmentListErrorStructure;

class GetAttachmentListError;

class AudioAttachmentPlaybackStart;

class AudioAttachmentPlaybackResult;

class AudioAttachmentPlaybackErrorStructure;

class AudioAttachmentPlaybackError;

class GetImageAttachmentStart;

class GetImageAttachmentResult;

class GetImageAttachmentErrorStructure;

class GetImageAttachmentError;

class GetBodyPartListStart;

class GetBodyPartListResult;

class GetBodyPartListErrorStructure;

class GetBodyPartListError;

class ReadMessageAloudStart;

class ReadMessageAloudResult;

class ReadMessageAloudErrorStructure;

class ReadMessageAloudError;

class RecordAudioMessageStart;

class RecordAudioMessageResult;

class RecordAudioMessageErrorStructure;

class RecordAudioMessageError;

class PlaybackAudioMessageStart;

class PlaybackAudioMessageResult;

class PlaybackAudioMessageErrorStructure;

class PlaybackAudioMessageError;

class AddPredefinedMessageStart;

class AddPredefinedMessageResult;

class AddPredefinedMessageErrorStructure;

class AddPredefinedMessageError;

class DeletePredefinedMessageStart;

class DeletePredefinedMessageResult;

class DeletePredefinedMessageErrorStructure;

class DeletePredefinedMessageError;

class GetConversationMessagesStart;

class GetConversationMessagesResult;

class GetConversationMessagesErrorStructure;

class GetConversationMessagesError;

class SendMessageStart;

class SendMessageResult;

class SendMessageErrorStructure;

class SendMessageError;

class ProvideMessageHeaderStart;

class ProvideMessageHeaderResult;

class ProvideMessageHeaderErrorStructure;

class ProvideMessageHeaderError;

class ProvideMessageBodyStart;

class ProvideMessageBodyResult;

class ProvideMessageBodyErrorStructure;

class ProvideMessageBodyError;

class GetMsgBodyActionElementStart;

class GetMsgBodyActionElementResult;

class GetMsgBodyActionElementErrorStructure;

class GetMsgBodyActionElementError;

class GetImageAttachmentInfoStart;

class GetImageAttachmentInfoResult;

class GetImageAttachmentInfoErrorStructure;

class GetImageAttachmentInfoError;

class CreateMessageStart;

class CreateMessageResult;

class CreateMessageErrorStructure;

class CreateMessageError;

class ClearUserMessagingInfoErrorStructure;

class ClearUserMessagingInfoError;

class MapDeviceCapabilitiesStatus;

class MessagingOnOffStatus;

class MessagingOnOffSet;

class MessagingOnOffErrorStructure;

class MessagingOnOffError;

class MessageNotificationStatus;

class PredefinedMessageListExtendedStatus;

class PredefinedMessageListExtendedErrorStructure;

class PredefinedMessageListExtendedError;

class MessagingLanguageStatus;

class MessagingLanguageSet;

class MessagingLanguageErrorStructure;

class MessagingLanguageError;

class SignatureSettingExtendedStatus;

class SignatureSettingExtendedPureSet;

class SignatureSettingExtendedErrorStructure;

class SignatureSettingExtendedError;

class MessagingOnOffListStatus;

class MessagingOnOffListErrorStructure;

class MessagingOnOffListError;

class TextRingtoneOnOffListStatus;

class TextRingtoneOnOffListPureSet;

class TextRingtoneOnOffListErrorStructure;

class TextRingtoneOnOffListError;

class AutoReplyOnOffListStatus;

class AutoReplyOnOffListPureSet;

class AutoReplyOnOffListErrorStructure;

class AutoReplyOnOffListError;

class AutoReplyTextListStatus;

class AutoReplyTextListPureSet;

class AutoReplyTextListErrorStructure;

class AutoReplyTextListError;

class MapDeviceCapabilitiesExtendedStatus;

class MapDeviceCapabilitiesExtendedErrorStructure;

class MapDeviceCapabilitiesExtendedError;

class ConnectMapProfileStart;

class ConnectMapProfileResult;

class ConnectMapProfileErrorStructure;

class ConnectMapProfileError;

class EditPredefinedMessageStart;

class EditPredefinedMessageResult;

class EditPredefinedMessageErrorStructure;

class EditPredefinedMessageError;

class AddPredefinedMessageExtendedStart;

class AddPredefinedMessageExtendedResult;

class AddPredefinedMessageExtendedErrorStructure;

class AddPredefinedMessageExtendedError;

class ReadMessageAloudExtendedStart;

class ReadMessageAloudExtendedResult;

class ReadMessageAloudExtendedErrorStructure;

class ReadMessageAloudExtendedError;

class RequestSliceConversationListStart;

class RequestSliceConversationListResult;

class RequestSliceConversationListErrorStructure;

class RequestSliceConversationListError;

class GetSliceConversationDetailsStart;

class GetSliceConversationDetailsResult;

class GetSliceConversationDetailsErrorStructure;

class GetSliceConversationDetailsError;

class SwitchMapOnOffStart;

class SwitchMapOnOffResult;

class SwitchMapOnOffErrorStructure;

class SwitchMapOnOffError;

class AddCustomMessageStart;

class AddCustomMessageResult;

class AddCustomMessageErrorStructure;

class AddCustomMessageError;

// type definitions
/**
 * The upreg message of the property "SourceInfo"
 * This property gives particulars about the type of streaming data a source can handle. If notification is used for an FBlock
 * with multiple sources, multiple notifications will be sent when the status changes for more than one source.
 * For further information please refer to the MOST Stream Transmission Specification Rev 3.0.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SourceInfoUpReg;

/**
 * The relUpReg message of the property "SourceInfo"
 * This property gives particulars about the type of streaming data a source can handle. If notification is used for an FBlock
 * with multiple sources, multiple notifications will be sent when the status changes for more than one source.
 * For further information please refer to the MOST Stream Transmission Specification Rev 3.0.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SourceInfoRelUpReg;

/**
 * The get message of the property "SourceAvailable"
 * The SourceAvailable property can be queried by a controller to determine whether a Source is initialized and ready to produce audio or video.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SourceAvailableGet;

/**
 * The upreg message of the property "SourceAvailable"
 * The SourceAvailable property can be queried by a controller to determine whether a Source is initialized and ready to produce audio or video.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SourceAvailableUpReg;

/**
 * The relUpReg message of the property "SourceAvailable"
 * The SourceAvailable property can be queried by a controller to determine whether a Source is initialized and ready to produce audio or video.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SourceAvailableRelUpReg;

/**
 * The upreg message of the property "MessageListChange"
 * The MessageListChange property provides notifications about changes that occur in a created message list.
 * These changes include:
 * <item>
 * Complete change in items
 * </item>
 * <item>
 * Items changed
 * </item>
 * <item>
 * Items added
 * </item>
 * <item>
 * Items deleted
 * </item>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MessageListChangeUpReg;

/**
 * The relUpReg message of the property "MessageListChange"
 * The MessageListChange property provides notifications about changes that occur in a created message list.
 * These changes include:
 * <item>
 * Complete change in items
 * </item>
 * <item>
 * Items changed
 * </item>
 * <item>
 * Items added
 * </item>
 * <item>
 * Items deleted
 * </item>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MessageListChangeRelUpReg;

/**
 * The error message of 'MessageListChange'
 */
typedef ::asf::cca::CcaTypes::DefaultError MessageListChangeError;

/**
 * The upreg message of the property "FolderListChange"
 * Notifies the HMI that the FolderList has changed. The notification includes whether or not the folder list structure has changed or just the
 * message information on a particular folder.
 * The HMI must either:
 * <item>
 * Request the entire list if one or more folders have been added or removed (starting from the Root) or,
 * </item>
 * <item>
 * (Re)request the list information for the Folder corresponding to to the FolderHandle in the notification.
 * </item>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FolderListChangeUpReg;

/**
 * The relUpReg message of the property "FolderListChange"
 * Notifies the HMI that the FolderList has changed. The notification includes whether or not the folder list structure has changed or just the
 * message information on a particular folder.
 * The HMI must either:
 * <item>
 * Request the entire list if one or more folders have been added or removed (starting from the Root) or,
 * </item>
 * <item>
 * (Re)request the list information for the Folder corresponding to to the FolderHandle in the notification.
 * </item>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FolderListChangeRelUpReg;

/**
 * The error message of 'FolderListChange'
 */
typedef ::asf::cca::CcaTypes::DefaultError FolderListChangeError;

/**
 * The upreg message of the property "MessagingDeviceConnection"
 * This property MessagingDeviceConnection has become DEPRECATED.
 * HMI Controllers are recommended to register for MapDeviceCapabilitiesExtended, since it already includes the functionalities of MessagingDeviceConnection.
 *
 * Identifies the supported message types and active email account (if applicable) for the connected device. This propery also reports the MessagingMemoryStatus of
 * the device that can be used to synchronize the HMI view with whether the device has more memory available for message or it if is full.  Note that the Messaging FBlock
 * triggers alerts to the AlertManager when the device becomes full and when it becomes available again.  The MessageMemoryStatus flag is used to synchronize persistent markers in the HMI view.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MessagingDeviceConnectionUpReg;

/**
 * The relUpReg message of the property "MessagingDeviceConnection"
 * This property MessagingDeviceConnection has become DEPRECATED.
 * HMI Controllers are recommended to register for MapDeviceCapabilitiesExtended, since it already includes the functionalities of MessagingDeviceConnection.
 *
 * Identifies the supported message types and active email account (if applicable) for the connected device. This propery also reports the MessagingMemoryStatus of
 * the device that can be used to synchronize the HMI view with whether the device has more memory available for message or it if is full.  Note that the Messaging FBlock
 * triggers alerts to the AlertManager when the device becomes full and when it becomes available again.  The MessageMemoryStatus flag is used to synchronize persistent markers in the HMI view.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MessagingDeviceConnectionRelUpReg;

/**
 * The error message of 'MessagingDeviceConnection'
 */
typedef ::asf::cca::CcaTypes::DefaultError MessagingDeviceConnectionError;

/**
 * The get message of the property "UpdateInboxSettings"
 * The Set operation is used by the HMI to set the automatic update inbox feature ON or OFF. If the feature is set to ON, the UpdateInboxPeriod set by the user is also sent.The Get operation is used by the HMI to update the Email Settings view.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage UpdateInboxSettingsGet;

/**
 * The upreg message of the property "UpdateInboxSettings"
 * The Set operation is used by the HMI to set the automatic update inbox feature ON or OFF. If the feature is set to ON, the UpdateInboxPeriod set by the user is also sent.The Get operation is used by the HMI to update the Email Settings view.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage UpdateInboxSettingsUpReg;

/**
 * The relUpReg message of the property "UpdateInboxSettings"
 * The Set operation is used by the HMI to set the automatic update inbox feature ON or OFF. If the feature is set to ON, the UpdateInboxPeriod set by the user is also sent.The Get operation is used by the HMI to update the Email Settings view.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage UpdateInboxSettingsRelUpReg;

/**
 * The get message of the property "AudioAttachmentPlaybackState"
 * Provides notification of the playback status the currently playing audio attachment.  The Status response is triggered to notified controllers to notify changes in the playback state of an audio attachment.
 * The Get operator returns the status of the currently playing audio attachment or the status of the last played attachment if attachment play has ended.  If no attachment play is defined, the return AttachmentHandle shall be set to the null value of 0x0000.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AudioAttachmentPlaybackStateGet;

/**
 * The upreg message of the property "AudioAttachmentPlaybackState"
 * Provides notification of the playback status the currently playing audio attachment.  The Status response is triggered to notified controllers to notify changes in the playback state of an audio attachment.
 * The Get operator returns the status of the currently playing audio attachment or the status of the last played attachment if attachment play has ended.  If no attachment play is defined, the return AttachmentHandle shall be set to the null value of 0x0000.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AudioAttachmentPlaybackStateUpReg;

/**
 * The relUpReg message of the property "AudioAttachmentPlaybackState"
 * Provides notification of the playback status the currently playing audio attachment.  The Status response is triggered to notified controllers to notify changes in the playback state of an audio attachment.
 * The Get operator returns the status of the currently playing audio attachment or the status of the last played attachment if attachment play has ended.  If no attachment play is defined, the return AttachmentHandle shall be set to the null value of 0x0000.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AudioAttachmentPlaybackStateRelUpReg;

/**
 * The get message of the property "SignatureSetting"
 * Used to set and acquire the signature text to be appended to the end of a message.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SignatureSettingGet;

/**
 * The upreg message of the property "SignatureSetting"
 * Used to set and acquire the signature text to be appended to the end of a message.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SignatureSettingUpReg;

/**
 * The relUpReg message of the property "SignatureSetting"
 * Used to set and acquire the signature text to be appended to the end of a message.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SignatureSettingRelUpReg;

/**
 * The get message of the property "AudioMessageRecordingState"
 * Provides the audio message recording state.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AudioMessageRecordingStateGet;

/**
 * The upreg message of the property "AudioMessageRecordingState"
 * Provides the audio message recording state.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AudioMessageRecordingStateUpReg;

/**
 * The relUpReg message of the property "AudioMessageRecordingState"
 * Provides the audio message recording state.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AudioMessageRecordingStateRelUpReg;

/**
 * The get message of the property "RecordedAudioMessageInfo"
 * Property provides the handle of the recorded audio message. It is sent by Messaging in the case where the recording limit has been reached.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RecordedAudioMessageInfoGet;

/**
 * The upreg message of the property "RecordedAudioMessageInfo"
 * Property provides the handle of the recorded audio message. It is sent by Messaging in the case where the recording limit has been reached.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RecordedAudioMessageInfoUpReg;

/**
 * The relUpReg message of the property "RecordedAudioMessageInfo"
 * Property provides the handle of the recorded audio message. It is sent by Messaging in the case where the recording limit has been reached.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RecordedAudioMessageInfoRelUpReg;

/**
 * The get message of the property "PredefinedMessageList"
 * This property contains the predefined message list. The list is ordered per the requirements in the HMI Form and Behavior Specification.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PredefinedMessageListGet;

/**
 * The upreg message of the property "PredefinedMessageList"
 * This property contains the predefined message list. The list is ordered per the requirements in the HMI Form and Behavior Specification.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PredefinedMessageListUpReg;

/**
 * The relUpReg message of the property "PredefinedMessageList"
 * This property contains the predefined message list. The list is ordered per the requirements in the HMI Form and Behavior Specification.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PredefinedMessageListRelUpReg;

/**
 * The get message of the property "MessagingAudioPlaybackState"
 * Provides notification of the playback status for all audio related functions within Messaging: Text-to-Speech session, when reading a message aloud, and listening to a recorded audio message.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MessagingAudioPlaybackStateGet;

/**
 * The upreg message of the property "MessagingAudioPlaybackState"
 * Provides notification of the playback status for all audio related functions within Messaging: Text-to-Speech session, when reading a message aloud, and listening to a recorded audio message.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MessagingAudioPlaybackStateUpReg;

/**
 * The relUpReg message of the property "MessagingAudioPlaybackState"
 * Provides notification of the playback status for all audio related functions within Messaging: Text-to-Speech session, when reading a message aloud, and listening to a recorded audio message.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MessagingAudioPlaybackStateRelUpReg;

/**
 * The error message of 'MessagingAudioPlaybackState'
 */
typedef ::asf::cca::CcaTypes::DefaultError MessagingAudioPlaybackStateError;

/**
 * The get message of the property "TextAlertEnable"
 * Provides the ability to turn the Text Alert On or Off.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TextAlertEnableGet;

/**
 * The upreg message of the property "TextAlertEnable"
 * Provides the ability to turn the Text Alert On or Off.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TextAlertEnableUpReg;

/**
 * The relUpReg message of the property "TextAlertEnable"
 * Provides the ability to turn the Text Alert On or Off.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TextAlertEnableRelUpReg;

/**
 * The get message of the property "EmailAlertEnable"
 * Provides the ability to turn the Email Alert On or Off.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage EmailAlertEnableGet;

/**
 * The upreg message of the property "EmailAlertEnable"
 * Provides the ability to turn the Email Alert On or Off.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage EmailAlertEnableUpReg;

/**
 * The relUpReg message of the property "EmailAlertEnable"
 * Provides the ability to turn the Email Alert On or Off.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage EmailAlertEnableRelUpReg;

/**
 * The get message of the property "SaveSentText"
 * Provides the ability to enable or disable the saving of a copy of a sent text message in the sent folder.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SaveSentTextGet;

/**
 * The upreg message of the property "SaveSentText"
 * Provides the ability to enable or disable the saving of a copy of a sent text message in the sent folder.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SaveSentTextUpReg;

/**
 * The relUpReg message of the property "SaveSentText"
 * Provides the ability to enable or disable the saving of a copy of a sent text message in the sent folder.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SaveSentTextRelUpReg;

/**
 * The get message of the property "SaveSentEmail"
 * Provides the ability to enable or disable the saving of a copy of a sent email message in the sent folder.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SaveSentEmailGet;

/**
 * The upreg message of the property "SaveSentEmail"
 * Provides the ability to enable or disable the saving of a copy of a sent email message in the sent folder.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SaveSentEmailUpReg;

/**
 * The relUpReg message of the property "SaveSentEmail"
 * Provides the ability to enable or disable the saving of a copy of a sent email message in the sent folder.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SaveSentEmailRelUpReg;

/**
 * The abort error message of the method "Allocate"
 * The Allocate method causes the source to occupy bandwidth for streaming data.
 */
typedef ::asf::cca::CcaTypes::DefaultError AllocateAbortError;

/**
 * The abort error message of the method "DeAllocate"
 * The method DeAllocate causes the source to free occupied Streaming bandwidth.
 */
typedef ::asf::cca::CcaTypes::DefaultError DeAllocateAbortError;

/**
 * The abort error message of the method "SourceActivity"
 * This method controls the activity of a source.
 * Note that the PAUSE state is not allowed for the General Motors implementation and is thus not defined as an allowed state within the enumeration.
 */
typedef ::asf::cca::CcaTypes::DefaultError SourceActivityAbortError;

/**
 * The abort error message of the method "CreateMessageList"
 * Creates a message list of a particular type and returns a ListHandle to the caller.  Slices of the list can then be accessed via RequestMessageListSlice.
 * When the folder type is Conversation, slices of the list could be accessed via RequestSliceConversationList. Changes to the list are notified via the MessageListChanged property.
 */
typedef ::asf::cca::CcaTypes::DefaultError CreateMessageListAbortError;

/**
 * The abort error message of the method "RequestSliceMessageList"
 * The RequestSliceMessageList method provides a slice of the specific list specified by the ListHandle parameter. The slice begins with the item at location WindowStart and includes in sequential order the number of items specified by the parameter WindowSize.
 * The RequestSliceMessageList method returns the slice as a MessageListSliceResult stream.  If the number of items in the list starting at WindowStart is less than the WindowSize parameter then the number of items provided in the slice will be less than the WindowSize calling parameter.
 * The PlaybackState is transmitted in the MessageListResult for each message in order to allow HMI controllers to annotate a currently playing message with a start/stopped/paused indicator in the list view.
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestSliceMessageListAbortError;

/**
 * The abort error message of the method "ReleaseMessageList"
 * The ReleaseMessageList function releases a list which has been created by the CreateMessageList function.  The list to release is specified by the ListHandle parameter. The ListHandle becomes invalid by this function.
 */
typedef ::asf::cca::CcaTypes::DefaultError ReleaseMessageListAbortError;

/**
 * The abort error message of the method "RequestFolderList"
 * Retrieves the folder list from a particular branch of the hierarchy.
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestFolderListAbortError;

/**
 * The abort error message of the method "DeleteMessage"
 * Deletes a message based on its MessageHandle. The FBlock deletes the message on both the device and in its local store. The Result response includes the DeletionStatus and the MessageHandle of the message requested for deletion.
 */
typedef ::asf::cca::CcaTypes::DefaultError DeleteMessageAbortError;

/**
 * The abort error message of the method "RecoverMessage"
 * Recovers a message based on its MessageHandle. The FBlock recovers the message on both the device and in its local store. The Result response includes the RecoveryStatus and the MessageHandle of the message requested for recovery. Only applies to messages in deleted folder.
 */
typedef ::asf::cca::CcaTypes::DefaultError RecoverMessageAbortError;

/**
 * The abort error message of the method "RequestAccountList"
 * Retrieves the account list for a particular device.
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestAccountListAbortError;

/**
 * The abort error message of the method "ChangeAccount"
 * Sets the selected account as active account and returns the changed account list.
 */
typedef ::asf::cca::CcaTypes::DefaultError ChangeAccountAbortError;

/**
 * The start message of the method "UpdateInbox"
 * Initiates request to update inbox for the active account.The ProcessingAck shall always be sent.The ResultAck is sent only
 * after Messaging receives an new message notification or the Update Email Activity Indicator timer expires.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage UpdateInboxStart;

/**
 * The result message of the method "UpdateInbox"
 * Initiates request to update inbox for the active account.The ProcessingAck shall always be sent.The ResultAck is sent only
 * after Messaging receives an new message notification or the Update Email Activity Indicator timer expires.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage UpdateInboxResult;

/**
 * The abort error message of the method "UpdateInbox"
 * Initiates request to update inbox for the active account.The ProcessingAck shall always be sent.The ResultAck is sent only
 * after Messaging receives an new message notification or the Update Email Activity Indicator timer expires.
 */
typedef ::asf::cca::CcaTypes::DefaultError UpdateInboxAbortError;

/**
 * The abort error message of the method "GetMessage"
 * Retrieves the detailed information for a particular message(s) identified by the supplied MessageHandle. If the ConversationModeFlag is set to true then, the MessageDetailsResult will include all the messages that make up the conversation of the requested MessageHandle.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetMessageAbortError;

/**
 * The abort error message of the method "GetAttachmentList"
 * This method is used to retrieve the AttachmentList for a specific message.  The returned list is constant and cannot change.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetAttachmentListAbortError;

/**
 * The abort error message of the method "AudioAttachmentPlayback"
 * Requests the playback action for the audio attachment. Playback actions include:1. Play: plays or restarts a previously paused audio attachment2. Pause: pause the currently playing audio attachment3. Stop: stops a currently playing audio attachment.
 */
typedef ::asf::cca::CcaTypes::DefaultError AudioAttachmentPlaybackAbortError;

/**
 * The abort error message of the method "GetImageAttachment"
 * Retrieves the image associated with an attachment.  Controllers may call GetImageAttachmentInfo in advance to find the MIME type and size of the image in order to allocate buffers and/or decoding resources, then call this function to receive the actual image data.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetImageAttachmentAbortError;

/**
 * The abort error message of the method "GetBodyPartList"
 * This method is used to retrieve the BodyPart elements for a specific message.  The returned list is constant and cannot change.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetBodyPartListAbortError;

/**
 * The abort error message of the method "ReadMessageAloud"
 * This method is used to begin or end the reading of the selected message aloud on the specified LogicalAVChannel.Messaging shall be responsible for requesting the TTS session.
 * Important note on TTSLanguage parameter:The TTSLanguage parameter was defined in MY13 with incorrect language enumerations that do not match the master system language enums in TextToSpeech.
 * TTSLanguage and GMLANGateway.LanguageSelection. The ReadMessageAloud feature is intended to always read the message in the system language (GMLANGateway.LanguageSelection).
 * Therefore, the TTSLanguage parameter shall be handled as follows:
 *
 * <item>
 * Controllers shall always set TTSLanguage to 0xFF = USE_SYSTEM_LANGUAGE_SELECTION.
 * </item>
 * <item>
 * The Messaging FBlock shall always read the TTSLanguage in the current system language according to the GMLANGateway.LanguageSelection
 * property and/or internal calibrations for the specific TTS language corresponding to the current LanguageSelection value.
 * </item>
 * <item>
 * If the TTSLanguage parameter is received with ANY vale other than 0xFF = USE_SYSTEM_LANGUAGE_SELECTION, then the Messaging FBlock shall
 * ignore the value and execute the read message aloud function in the system language (provided the system language is available in the
 * current system configuration).
 * </item>
 */
typedef ::asf::cca::CcaTypes::DefaultError ReadMessageAloudAbortError;

/**
 * The abort error message of the method "RecordAudioMessage"
 * This method is used to record an audio message.
 */
typedef ::asf::cca::CcaTypes::DefaultError RecordAudioMessageAbortError;

/**
 * The abort error message of the method "PlaybackAudioMessage"
 * This method is used to playback a recorded audio message.
 */
typedef ::asf::cca::CcaTypes::DefaultError PlaybackAudioMessageAbortError;

/**
 * The abort error message of the method "AddPredefinedMessage"
 * This method adds a new predefined message per the text sent by the HMI. Messaging returns the handle of the new predefined message.
 */
typedef ::asf::cca::CcaTypes::DefaultError AddPredefinedMessageAbortError;

/**
 * The abort error message of the method "DeletePredefinedMessage"
 * This method deletes a predefined message from the predefined message list.
 */
typedef ::asf::cca::CcaTypes::DefaultError DeletePredefinedMessageAbortError;

/**
 * The abort error message of the method "GetConversationMessages"
 * This method acquires the MessageHandles of all the messages that make up the conversation for a particular message (MessageHandle). The HMI uses the GetMessage method to get all the detailed information for each message.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetConversationMessagesAbortError;

/**
 * The abort error message of the method "SendMessage"
 * This method informs Messaging that a message needs to be sent. It provides the type of message, the original MessageHandle (if applicable), the create message type (i.e. new message, reply, reply to all, or forward), and the MessageHeaderBodyHandle.
 * Note that if the message could not be sent to the Bluetooth device for transmission, the SentMessageStatus will return ERROR.  If sent successfully to the Bluetooth, but not necessarily sent successfully on the cellular network, the SUCCESS code is returned.
 * Note further that for both of these response codes, the Messaging FBlock will trigger the appropriate alert to the AlertManager FBlock for notification to the overall vehicle HMI.  See GIS-368 for details.
 */
typedef ::asf::cca::CcaTypes::DefaultError SendMessageAbortError;

/**
 * The abort error message of the method "ProvideMessageHeader"
 * This method provides the message header for the CreateMessageHandle message to be sent.
 */
typedef ::asf::cca::CcaTypes::DefaultError ProvideMessageHeaderAbortError;

/**
 * The abort error message of the method "ProvideMessageBody"
 * This method provides the message body for the CreateMessageHandle message to be sent.
 */
typedef ::asf::cca::CcaTypes::DefaultError ProvideMessageBodyAbortError;

/**
 * The abort error message of the method "GetMsgBodyActionElement"
 * This method allows the HMI to acquire information (element type and content) on a particular MsgBodyActionElementTag.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetMsgBodyActionElementAbortError;

/**
 * The abort error message of the method "GetImageAttachmentInfo"
 * Acquires the MIME image subtype and the size of an attached image identified by its AttachmentHandle. If the MIMEImageSubtype = NULL then there is no photo associated with the AttachmentHandle.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetImageAttachmentInfoAbortError;

/**
 * The abort error message of the method "CreateMessage"
 * This function is the first of four functions used in sending a message. The CreateMessage function identifies the type of message (SMS, MMS, or Email)
 * to be sent and whether the message is new, a reply, or a forward. If the message to be sent is a reply or a forward the original message handle is included.
 * Additionally, the CreateMessage function identifies the CreateMessageHandle which will allow the ProvideMessageHeader, ProvideMessageBody, and SendMessage
 * functions to stay in sync and ultimately send the created message.
 */
typedef ::asf::cca::CcaTypes::DefaultError CreateMessageAbortError;

/**
 * The start message of the method "ClearUserMessagingInfo"
 * The ClearUserMessagingInfo Method is called by controllers to clear out all user messaging information such as predefined user messages.  Upon receipt of the StartAck, the FBlock shall remove all user messaging info such as predefined user messages.
 * This function is generally only called when a vehicle is turned-in at end of lease or sold.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ClearUserMessagingInfoStart;

/**
 * The result message of the method "ClearUserMessagingInfo"
 * The ClearUserMessagingInfo Method is called by controllers to clear out all user messaging information such as predefined user messages.  Upon receipt of the StartAck, the FBlock shall remove all user messaging info such as predefined user messages.
 * This function is generally only called when a vehicle is turned-in at end of lease or sold.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ClearUserMessagingInfoResult;

/**
 * The abort error message of the method "ClearUserMessagingInfo"
 * The ClearUserMessagingInfo Method is called by controllers to clear out all user messaging information such as predefined user messages.  Upon receipt of the StartAck, the FBlock shall remove all user messaging info such as predefined user messages.
 * This function is generally only called when a vehicle is turned-in at end of lease or sold.
 */
typedef ::asf::cca::CcaTypes::DefaultError ClearUserMessagingInfoAbortError;

/**
 * The get message of the property "MapDeviceCapabilities"
 * This property MapDeviceCapabilities has become DEPRECATED.
 * HMI Controllers are recommended to register for MapDeviceCapabilitiesExtended, since it already includes the functionalities of MapDeviceCapabilities.
 *
 * This Property will update the MAP capabilities of the connected device like the supported message types of the MAP connected phone along with the MAP features supported.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MapDeviceCapabilitiesGet;

/**
 * The upreg message of the property "MapDeviceCapabilities"
 * This property MapDeviceCapabilities has become DEPRECATED.
 * HMI Controllers are recommended to register for MapDeviceCapabilitiesExtended, since it already includes the functionalities of MapDeviceCapabilities.
 *
 * This Property will update the MAP capabilities of the connected device like the supported message types of the MAP connected phone along with the MAP features supported.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MapDeviceCapabilitiesUpReg;

/**
 * The relUpReg message of the property "MapDeviceCapabilities"
 * This property MapDeviceCapabilities has become DEPRECATED.
 * HMI Controllers are recommended to register for MapDeviceCapabilitiesExtended, since it already includes the functionalities of MapDeviceCapabilities.
 *
 * This Property will update the MAP capabilities of the connected device like the supported message types of the MAP connected phone along with the MAP features supported.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MapDeviceCapabilitiesRelUpReg;

/**
 * The error message of 'MapDeviceCapabilities'
 */
typedef ::asf::cca::CcaTypes::DefaultError MapDeviceCapabilitiesError;

/**
 * The get message of the property "MessagingOnOff"
 * This Property will switch ON / OFF the Message Access Profile (MAP). This is a general setting which will affect all the phones. When disabled no MAP will be connected.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MessagingOnOffGet;

/**
 * The upreg message of the property "MessagingOnOff"
 * This Property will switch ON / OFF the Message Access Profile (MAP). This is a general setting which will affect all the phones. When disabled no MAP will be connected.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MessagingOnOffUpReg;

/**
 * The relUpReg message of the property "MessagingOnOff"
 * This Property will switch ON / OFF the Message Access Profile (MAP). This is a general setting which will affect all the phones. When disabled no MAP will be connected.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MessagingOnOffRelUpReg;

/**
 * The get message of the property "MessageNotification"
 * This Property will update whenever
 * The connected device receives a new message,
 * A message is uploaded to the remote device,
 * Message is delivered to the network,
 * Message is deleted in the connected device.
 * Failure in uploading the message to the device or to the network.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MessageNotificationGet;

/**
 * The upreg message of the property "MessageNotification"
 * This Property will update whenever
 * The connected device receives a new message,
 * A message is uploaded to the remote device,
 * Message is delivered to the network,
 * Message is deleted in the connected device.
 * Failure in uploading the message to the device or to the network.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MessageNotificationUpReg;

/**
 * The relUpReg message of the property "MessageNotification"
 * This Property will update whenever
 * The connected device receives a new message,
 * A message is uploaded to the remote device,
 * Message is delivered to the network,
 * Message is deleted in the connected device.
 * Failure in uploading the message to the device or to the network.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MessageNotificationRelUpReg;

/**
 * The error message of 'MessageNotification'
 */
typedef ::asf::cca::CcaTypes::DefaultError MessageNotificationError;

/**
 * The get message of the property "PredefinedMessageListExtended"
 * This property contains the predefined message list. The list is ordered per the requirements in the HMI Form and Behavior Specification.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PredefinedMessageListExtendedGet;

/**
 * The upreg message of the property "PredefinedMessageListExtended"
 * This property contains the predefined message list. The list is ordered per the requirements in the HMI Form and Behavior Specification.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PredefinedMessageListExtendedUpReg;

/**
 * The relUpReg message of the property "PredefinedMessageListExtended"
 * This property contains the predefined message list. The list is ordered per the requirements in the HMI Form and Behavior Specification.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PredefinedMessageListExtendedRelUpReg;

/**
 * The get message of the property "MessagingLanguage"
 * This property will set the language to the Messaging F-Block and based on the set language the pre-defined message list will be provided to HMI.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MessagingLanguageGet;

/**
 * The upreg message of the property "MessagingLanguage"
 * This property will set the language to the Messaging F-Block and based on the set language the pre-defined message list will be provided to HMI.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MessagingLanguageUpReg;

/**
 * The relUpReg message of the property "MessagingLanguage"
 * This property will set the language to the Messaging F-Block and based on the set language the pre-defined message list will be provided to HMI.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MessagingLanguageRelUpReg;

/**
 * The get message of the property "SignatureSettingExtended"
 * Used to set and acquire the signature text to be appended to the end of a message.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SignatureSettingExtendedGet;

/**
 * The upreg message of the property "SignatureSettingExtended"
 * Used to set and acquire the signature text to be appended to the end of a message.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SignatureSettingExtendedUpReg;

/**
 * The relUpReg message of the property "SignatureSettingExtended"
 * Used to set and acquire the signature text to be appended to the end of a message.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SignatureSettingExtendedRelUpReg;

/**
 * The get message of the property "MessagingOnOffList"
 * This property allows the clients to set the MAP on/off and updates the OnOff status to clients for all paired devices
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MessagingOnOffListGet;

/**
 * The upreg message of the property "MessagingOnOffList"
 * This property allows the clients to set the MAP on/off and updates the OnOff status to clients for all paired devices
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MessagingOnOffListUpReg;

/**
 * The relUpReg message of the property "MessagingOnOffList"
 * This property allows the clients to set the MAP on/off and updates the OnOff status to clients for all paired devices
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MessagingOnOffListRelUpReg;

/**
 * The get message of the property "TextRingtoneOnOffList"
 * This property allows the clients to set the text ringtone on/off and updates the OnOff status to clients for all paired devices
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TextRingtoneOnOffListGet;

/**
 * The upreg message of the property "TextRingtoneOnOffList"
 * This property allows the clients to set the text ringtone on/off and updates the OnOff status to clients for all paired devices
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TextRingtoneOnOffListUpReg;

/**
 * The relUpReg message of the property "TextRingtoneOnOffList"
 * This property allows the clients to set the text ringtone on/off and updates the OnOff status to clients for all paired devices
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TextRingtoneOnOffListRelUpReg;

/**
 * The get message of the property "AutoReplyOnOffList"
 * This property allows the clients to set the Auto-reply on/off and updates the OnOff status to clients for all paired devices
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AutoReplyOnOffListGet;

/**
 * The upreg message of the property "AutoReplyOnOffList"
 * This property allows the clients to set the Auto-reply on/off and updates the OnOff status to clients for all paired devices
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AutoReplyOnOffListUpReg;

/**
 * The relUpReg message of the property "AutoReplyOnOffList"
 * This property allows the clients to set the Auto-reply on/off and updates the OnOff status to clients for all paired devices
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AutoReplyOnOffListRelUpReg;

/**
 * The get message of the property "AutoReplyTextList"
 * This property allows the clients to set the Auto-reply Message Handle and updates the Auto reply Msg Handles to the clients for all paired devices
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AutoReplyTextListGet;

/**
 * The upreg message of the property "AutoReplyTextList"
 * This property allows the clients to set the Auto-reply Message Handle and updates the Auto reply Msg Handles to the clients for all paired devices
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AutoReplyTextListUpReg;

/**
 * The relUpReg message of the property "AutoReplyTextList"
 * This property allows the clients to set the Auto-reply Message Handle and updates the Auto reply Msg Handles to the clients for all paired devices
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AutoReplyTextListRelUpReg;

/**
 * The get message of the property "MapDeviceCapabilitiesExtended"
 * This Property will update the clients on the MAP Capabilities for all connected devices, like the supported message types of the MAP connected phone along with the MAP features supported.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MapDeviceCapabilitiesExtendedGet;

/**
 * The upreg message of the property "MapDeviceCapabilitiesExtended"
 * This Property will update the clients on the MAP Capabilities for all connected devices, like the supported message types of the MAP connected phone along with the MAP features supported.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MapDeviceCapabilitiesExtendedUpReg;

/**
 * The relUpReg message of the property "MapDeviceCapabilitiesExtended"
 * This Property will update the clients on the MAP Capabilities for all connected devices, like the supported message types of the MAP connected phone along with the MAP features supported.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MapDeviceCapabilitiesExtendedRelUpReg;

/**
 * The abort error message of the method "ConnectMapProfile"
 * This method will try to establish MAP session for the requested device handle.
 */
typedef ::asf::cca::CcaTypes::DefaultError ConnectMapProfileAbortError;

/**
 * The abort error message of the method "EditPredefinedMessage"
 * This method allows the user to edit the already existing predefined message.
 */
typedef ::asf::cca::CcaTypes::DefaultError EditPredefinedMessageAbortError;

/**
 * The abort error message of the method "AddPredefinedMessageExtended"
 * This method allows the user to add a predefined message to a particular sub-category.
 */
typedef ::asf::cca::CcaTypes::DefaultError AddPredefinedMessageExtendedAbortError;

/**
 * The abort error message of the method "ReadMessageAloudExtended"
 * This method will begin (or) end the reading of a particular message content provided by the clients.
 */
typedef ::asf::cca::CcaTypes::DefaultError ReadMessageAloudExtendedAbortError;

/**
 * The abort error message of the method "RequestSliceConversationList"
 * The RequestSliceConversationList method provides slices of the conversation list specified by the ListHandle parameter. The slice begins with the item at location WindowStart and includes
 * in sequential order the number of items specified by the parameter WindowSize. The RequestSliceConversationList method returns the slice as a ConversationListSliceResult stream.
 * If the number of items in the list starting at WindowStart is less than the WindowSize parameter then the number of items provided in the slice will be less than the WindowSize calling parameter.
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestSliceConversationListAbortError;

/**
 * The abort error message of the method "GetSliceConversationDetails"
 * This method provides the details of messages that belongs to the particular conversation handle.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetSliceConversationDetailsAbortError;

/**
 * The abort error message of the method "SwitchMapOnOff"
 * This method switches ON or OFF the MAP profile for the requested phone device (DeviceHandle).
 */
typedef ::asf::cca::CcaTypes::DefaultError SwitchMapOnOffAbortError;

/**
 * The abort error message of the method "AddCustomMessage"
 * This method allows the user to add a predefined message to a particular sub-category to a particular device handle
 */
typedef ::asf::cca::CcaTypes::DefaultError AddCustomMessageAbortError;


/**
 * The status message of the property "SourceInfo"
 * This property gives particulars about the type of streaming data a source can handle. If notification is used for an FBlock
 * with multiple sources, multiple notifications will be sent when the status changes for more than one source.
 * For further information please refer to the MOST Stream Transmission Specification Rev 3.0.
 */
class SourceInfoStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SourceInfoStatus ();

    /**
     * Copy constructor
     */
    inline  SourceInfoStatus (const SourceInfoStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SourceInfoStatus (uint8 u8SourceNr_, uint16 u16BlockWidth_, uint16 u16ConnectionLabel_, ::most_Src_fi_types::T_e8_SrcTransmissionClass e8TransmissionClass_, ::most_Src_fi_types::T_e8_SrcContentProtection e8ContentProtection_, const ::most_Src_fi_types::T_SrcContentDescription& oContentDescription_, const ::fi_basetypes_most::T_TrailingStream& oTransmissionParameter_);

    /**
     * Destructor
     */
    inline virtual  ~SourceInfoStatus();

    /**
     * Assignment operator
     */
    inline SourceInfoStatus& operator = (const SourceInfoStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SourceInfoStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SourceInfoStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SourceInfoStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SourceInfoStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8SourceNr"

    static const int kU8SourceNr = 0;

    /**
     * Clears the field "u8SourceNr".
     *
     * The field will be set to its default value. The hasU8SourceNr()
     * method will return false.
     */
    inline void clearU8SourceNr();

    /**
     * Checks whether the field "u8SourceNr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SourceNr()). Otherwise it will return false.
     */
    inline bool hasU8SourceNr () const;

    /**
     * Returns the value of the member "u8SourceNr".
     *
     * Number of a data source (within one FBlock there can be more than one), for example, 0x01 for the first source.
     *
     * @return The value of the field "u8SourceNr"
     */
    inline uint8 getU8SourceNr () const;

    /**
     * Sets the value of the member "u8SourceNr".
     *
     * Number of a data source (within one FBlock there can be more than one), for example, 0x01 for the first source.
     *
     * @param u8SourceNr The value which will be set
     */
    inline void setU8SourceNr (uint8 u8SourceNr_);

    // API of field "u16BlockWidth"

    static const int kU16BlockWidth = 1;

    /**
     * Clears the field "u16BlockWidth".
     *
     * The field will be set to its default value. The hasU16BlockWidth()
     * method will return false.
     */
    inline void clearU16BlockWidth();

    /**
     * Checks whether the field "u16BlockWidth" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16BlockWidth()). Otherwise it will return false.
     */
    inline bool hasU16BlockWidth () const;

    /**
     * Returns the value of the member "u16BlockWidth".
     *
     * Number of transferred bytes per MOST frame.  If no bandwidth was allocated yet, 0x0000 must be used.  Otherwise, 0x0001 - 0x0075 is used as specified by MOST50.
     *
     * @return The value of the field "u16BlockWidth"
     */
    inline uint16 getU16BlockWidth () const;

    /**
     * Sets the value of the member "u16BlockWidth".
     *
     * Number of transferred bytes per MOST frame.  If no bandwidth was allocated yet, 0x0000 must be used.  Otherwise, 0x0001 - 0x0075 is used as specified by MOST50.
     *
     * @param u16BlockWidth The value which will be set
     */
    inline void setU16BlockWidth (uint16 u16BlockWidth_);

    // API of field "u16ConnectionLabel"

    static const int kU16ConnectionLabel = 2;

    /**
     * Clears the field "u16ConnectionLabel".
     *
     * The field will be set to its default value. The hasU16ConnectionLabel()
     * method will return false.
     */
    inline void clearU16ConnectionLabel();

    /**
     * Checks whether the field "u16ConnectionLabel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ConnectionLabel()). Otherwise it will return false.
     */
    inline bool hasU16ConnectionLabel () const;

    /**
     * Returns the value of the member "u16ConnectionLabel".
     *
     * Connection identifier. If no bandwidth is allocated, 0x0000 must be used.  Otherwise, 0x000B - 0x007F is used as specified by MOST50.
     *
     * @return The value of the field "u16ConnectionLabel"
     */
    inline uint16 getU16ConnectionLabel () const;

    /**
     * Sets the value of the member "u16ConnectionLabel".
     *
     * Connection identifier. If no bandwidth is allocated, 0x0000 must be used.  Otherwise, 0x000B - 0x007F is used as specified by MOST50.
     *
     * @param u16ConnectionLabel The value which will be set
     */
    inline void setU16ConnectionLabel (uint16 u16ConnectionLabel_);

    // API of field "e8TransmissionClass"

    static const int kE8TransmissionClass = 3;

    /**
     * Clears the field "e8TransmissionClass".
     *
     * The field will be set to its default value. The hasE8TransmissionClass()
     * method will return false.
     */
    inline void clearE8TransmissionClass();

    /**
     * Checks whether the field "e8TransmissionClass" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8TransmissionClass()). Otherwise it will return false.
     */
    inline bool hasE8TransmissionClass () const;

    /**
     * Returns the value of the member "e8TransmissionClass".
     *
     * Describe the used MOST transmission type. Note:  Next Gen is only using the Synchronous transmission type for streaming audio and video.
     *
     * @return The value of the field "e8TransmissionClass"
     */
    inline ::most_Src_fi_types::T_e8_SrcTransmissionClass getE8TransmissionClass () const;

    /**
     * Sets the value of the member "e8TransmissionClass".
     *
     * Describe the used MOST transmission type. Note:  Next Gen is only using the Synchronous transmission type for streaming audio and video.
     *
     * @param e8TransmissionClass The value which will be set
     */
    inline void setE8TransmissionClass (::most_Src_fi_types::T_e8_SrcTransmissionClass e8TransmissionClass_);

    // API of field "e8ContentProtection"

    static const int kE8ContentProtection = 4;

    /**
     * Clears the field "e8ContentProtection".
     *
     * The field will be set to its default value. The hasE8ContentProtection()
     * method will return false.
     */
    inline void clearE8ContentProtection();

    /**
     * Checks whether the field "e8ContentProtection" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ContentProtection()). Otherwise it will return false.
     */
    inline bool hasE8ContentProtection () const;

    /**
     * Returns the value of the member "e8ContentProtection".
     *
     * Type of Content Protection used.
     *
     * @return The value of the field "e8ContentProtection"
     */
    inline ::most_Src_fi_types::T_e8_SrcContentProtection getE8ContentProtection () const;

    /**
     * Sets the value of the member "e8ContentProtection".
     *
     * Type of Content Protection used.
     *
     * @param e8ContentProtection The value which will be set
     */
    inline void setE8ContentProtection (::most_Src_fi_types::T_e8_SrcContentProtection e8ContentProtection_);

    // API of field "oContentDescription"

    static const int kOContentDescription = 5;

    /**
     * Clears the field "oContentDescription".
     *
     * The field will be set to its default value. The hasOContentDescription()
     * method will return false.
     */
    inline void clearOContentDescription();

    /**
     * Checks whether the field "oContentDescription" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOContentDescription()). Otherwise it will return false.
     */
    inline bool hasOContentDescription () const;

    /**
     * Returns the value of the member "oContentDescription".
     *
     * The parameter depends on the ContentType.
     *
     * @return The value of the field "oContentDescription"
     */
    inline const ::most_Src_fi_types::T_SrcContentDescription& getOContentDescription () const;

    /**
     * Retrieves the value of the field "oContentDescription" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oContentDescription".
     */
    inline ::most_Src_fi_types::T_SrcContentDescription& getOContentDescriptionMutable ();

    /**
     * Sets the value of the member "oContentDescription".
     *
     * The parameter depends on the ContentType.
     *
     * @param oContentDescription The value which will be set
     */
    inline void setOContentDescription (const ::most_Src_fi_types::T_SrcContentDescription& oContentDescription_);

    // API of field "oTransmissionParameter"

    static const int kOTransmissionParameter = 6;

    /**
     * Clears the field "oTransmissionParameter".
     *
     * The field will be set to its default value. The hasOTransmissionParameter()
     * method will return false.
     */
    inline void clearOTransmissionParameter();

    /**
     * Checks whether the field "oTransmissionParameter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOTransmissionParameter()). Otherwise it will return false.
     */
    inline bool hasOTransmissionParameter () const;

    /**
     * Returns the value of the member "oTransmissionParameter".
     *
     * The TransmiissionParameter contents depends on the TransmissionClass. Since only the synchronous transmission class is used in the Next GenerationArchitecture Infotainment Subsystem, the TransmissionParameter is an empty stream.
     *
     * @return The value of the field "oTransmissionParameter"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOTransmissionParameter () const;

    /**
     * Retrieves the value of the field "oTransmissionParameter" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oTransmissionParameter".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOTransmissionParameterMutable ();

    /**
     * Sets the value of the member "oTransmissionParameter".
     *
     * The TransmiissionParameter contents depends on the TransmissionClass. Since only the synchronous transmission class is used in the Next GenerationArchitecture Infotainment Subsystem, the TransmissionParameter is an empty stream.
     *
     * @param oTransmissionParameter The value which will be set
     */
    inline void setOTransmissionParameter (const ::fi_basetypes_most::T_TrailingStream& oTransmissionParameter_);

    static const SourceInfoStatus &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_u8SourceNr ();

    inline void clear_has_u8SourceNr ();

    inline void set_has_u16BlockWidth ();

    inline void clear_has_u16BlockWidth ();

    inline void set_has_u16ConnectionLabel ();

    inline void clear_has_u16ConnectionLabel ();

    inline void set_has_e8TransmissionClass ();

    inline void clear_has_e8TransmissionClass ();

    inline void set_has_e8ContentProtection ();

    inline void clear_has_e8ContentProtection ();

    inline void set_has_oContentDescription ();

    inline void clear_has_oContentDescription ();

    inline void set_has_oTransmissionParameter ();

    inline void clear_has_oTransmissionParameter ();

    uint32 _has_bits_[ (7 + 31) / 32];

    uint8 _u8SourceNr;

    uint16 _u16BlockWidth;

    uint16 _u16ConnectionLabel;

    ::most_Src_fi_types::T_e8_SrcTransmissionClass _e8TransmissionClass;

    ::most_Src_fi_types::T_e8_SrcContentProtection _e8ContentProtection;

    ::most_Src_fi_types::T_SrcContentDescription _oContentDescription;

    ::fi_basetypes_most::T_TrailingStream _oTransmissionParameter;

};

/**
 * The get message of the property "SourceInfo"
 * This property gives particulars about the type of streaming data a source can handle. If notification is used for an FBlock
 * with multiple sources, multiple notifications will be sent when the status changes for more than one source.
 * For further information please refer to the MOST Stream Transmission Specification Rev 3.0.
 */
class SourceInfoGet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SourceInfoGet ();

    /**
     * Copy constructor
     */
    inline  SourceInfoGet (const SourceInfoGet &rhs);

    /**
     * All fields constructor
     */
    inline  SourceInfoGet (uint8 u8SourceNr_);

    /**
     * Destructor
     */
    inline virtual  ~SourceInfoGet();

    /**
     * Assignment operator
     */
    inline SourceInfoGet& operator = (const SourceInfoGet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SourceInfoGet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SourceInfoGet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SourceInfoGet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SourceInfoGet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8SourceNr"

    static const int kU8SourceNr = 0;

    /**
     * Clears the field "u8SourceNr".
     *
     * The field will be set to its default value. The hasU8SourceNr()
     * method will return false.
     */
    inline void clearU8SourceNr();

    /**
     * Checks whether the field "u8SourceNr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SourceNr()). Otherwise it will return false.
     */
    inline bool hasU8SourceNr () const;

    /**
     * Returns the value of the member "u8SourceNr".
     *
     * Number of a data source (within one FBlock there can be more than one), for example, 0x01 for the first source.
     *
     * @return The value of the field "u8SourceNr"
     */
    inline uint8 getU8SourceNr () const;

    /**
     * Sets the value of the member "u8SourceNr".
     *
     * Number of a data source (within one FBlock there can be more than one), for example, 0x01 for the first source.
     *
     * @param u8SourceNr The value which will be set
     */
    inline void setU8SourceNr (uint8 u8SourceNr_);

    static const SourceInfoGet &getDefaultInstance();

private:

    inline void set_has_u8SourceNr ();

    inline void clear_has_u8SourceNr ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8SourceNr;

};

/**
 * The error message of 'SourceInfo'
 */
class SourceInfoErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SourceInfoErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SourceInfoErrorStructure (const SourceInfoErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SourceInfoErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~SourceInfoErrorStructure();

    /**
     * Assignment operator
     */
    inline SourceInfoErrorStructure& operator = (const SourceInfoErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SourceInfoErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SourceInfoErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SourceInfoErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SourceInfoErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * (Refer to the MOST Specification, section "Structure of MOST Messages: OPType")
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * (Refer to the MOST Specification, section "Structure of MOST Messages: OPType")
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * (Refer to the MOST Specification, section "Structure of MOST Messages: OPType")
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * (Refer to the MOST Specification, section "Structure of MOST Messages: OPType")
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const SourceInfoErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'SourceInfo'
 */
class SourceInfoError  : public ::asf::core::Payload {
public:

    enum SourceInfoErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SourceInfoError ();

   /**
     * Copy constructor
     */
    inline  SourceInfoError (const SourceInfoError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SourceInfoError();

    /**
     * Assigns a new value to this object.
     */
    inline SourceInfoError& operator = (const SourceInfoError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SourceInfoError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SourceInfoError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SourceInfoError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SourceInfoError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SourceInfoError::SourceInfoErrorField getField () const;

    inline void setField(SourceInfoError::SourceInfoErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SourceInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SourceInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SourceInfoErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SourceInfoErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SourceInfoErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SourceInfoErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SourceInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SourceInfoErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SourceInfoError &getDefaultInstance();

private:

    inline void cloneData (const SourceInfoError& rhs);

    inline void deleteData ();

    SourceInfoErrorField __field;

    union {
        SourceInfoErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "SourceAvailable"
 * The SourceAvailable property can be queried by a controller to determine whether a Source is initialized and ready to produce audio or video.
 */
class SourceAvailableStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SourceAvailableStatus ();

    /**
     * Copy constructor
     */
    inline  SourceAvailableStatus (const SourceAvailableStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SourceAvailableStatus (bool bSourceAvailable_);

    /**
     * Destructor
     */
    inline virtual  ~SourceAvailableStatus();

    /**
     * Assignment operator
     */
    inline SourceAvailableStatus& operator = (const SourceAvailableStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SourceAvailableStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SourceAvailableStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SourceAvailableStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SourceAvailableStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bSourceAvailable"

    static const int kBSourceAvailable = 0;

    /**
     * Clears the field "bSourceAvailable".
     *
     * The field will be set to its default value. The hasBSourceAvailable()
     * method will return false.
     */
    inline void clearBSourceAvailable();

    /**
     * Checks whether the field "bSourceAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBSourceAvailable()). Otherwise it will return false.
     */
    inline bool hasBSourceAvailable () const;

    /**
     * Returns the value of the member "bSourceAvailable".
     *
     * The SourceAvailable parameter indicates whether a Source is initialized and ready to produce audio.  Upon transition of SystemState out of SYS_SLEEP_STATE SourceAvailable is set to SOURCE_NOT_AVAILABLE.  After the Source is initialized and ready to produce audio or vidoe SoureceAvailable is set to SOURCE_AVAILABLE.
     *
     * @return The value of the field "bSourceAvailable"
     */
    inline bool getBSourceAvailable () const;

    /**
     * Sets the value of the member "bSourceAvailable".
     *
     * The SourceAvailable parameter indicates whether a Source is initialized and ready to produce audio.  Upon transition of SystemState out of SYS_SLEEP_STATE SourceAvailable is set to SOURCE_NOT_AVAILABLE.  After the Source is initialized and ready to produce audio or vidoe SoureceAvailable is set to SOURCE_AVAILABLE.
     *
     * @param bSourceAvailable The value which will be set
     */
    inline void setBSourceAvailable (bool bSourceAvailable_);

    static const SourceAvailableStatus &getDefaultInstance();

private:

    inline void set_has_bSourceAvailable ();

    inline void clear_has_bSourceAvailable ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bSourceAvailable;

};

/**
 * The error message of 'SourceAvailable'
 */
class SourceAvailableErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SourceAvailableErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SourceAvailableErrorStructure (const SourceAvailableErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SourceAvailableErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~SourceAvailableErrorStructure();

    /**
     * Assignment operator
     */
    inline SourceAvailableErrorStructure& operator = (const SourceAvailableErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SourceAvailableErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SourceAvailableErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SourceAvailableErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SourceAvailableErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * (Refer to the MOST Specification, section "Structure of MOST Messages: OPType")
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * (Refer to the MOST Specification, section "Structure of MOST Messages: OPType")
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * (Refer to the MOST Specification, section "Structure of MOST Messages: OPType")
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * (Refer to the MOST Specification, section "Structure of MOST Messages: OPType")
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const SourceAvailableErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'SourceAvailable'
 */
class SourceAvailableError  : public ::asf::core::Payload {
public:

    enum SourceAvailableErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SourceAvailableError ();

   /**
     * Copy constructor
     */
    inline  SourceAvailableError (const SourceAvailableError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SourceAvailableError();

    /**
     * Assigns a new value to this object.
     */
    inline SourceAvailableError& operator = (const SourceAvailableError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SourceAvailableError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SourceAvailableError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SourceAvailableError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SourceAvailableError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SourceAvailableError::SourceAvailableErrorField getField () const;

    inline void setField(SourceAvailableError::SourceAvailableErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SourceAvailableErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SourceAvailableErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SourceAvailableErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SourceAvailableErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SourceAvailableErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SourceAvailableErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SourceAvailableErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SourceAvailableErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SourceAvailableError &getDefaultInstance();

private:

    inline void cloneData (const SourceAvailableError& rhs);

    inline void deleteData ();

    SourceAvailableErrorField __field;

    union {
        SourceAvailableErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "MessageListChange"
 * The MessageListChange property provides notifications about changes that occur in a created message list.
 * These changes include:
 * <item>
 * Complete change in items
 * </item>
 * <item>
 * Items changed
 * </item>
 * <item>
 * Items added
 * </item>
 * <item>
 * Items deleted
 * </item>
 */
class MessageListChangeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MessageListChangeStatus ();

    /**
     * Copy constructor
     */
    inline  MessageListChangeStatus (const MessageListChangeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  MessageListChangeStatus (uint16 u16ListHandle_, ::most_Msg_fi_types::T_e8_MsgListChangeType e8ListChangeType_, uint16 u16ListLength_, uint32 u32NumItems_, const ::most_Msg_fi_types::T_MsgChangeItems& oChangeItems_);

    /**
     * Destructor
     */
    inline virtual  ~MessageListChangeStatus();

    /**
     * Assignment operator
     */
    inline MessageListChangeStatus& operator = (const MessageListChangeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MessageListChangeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MessageListChangeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MessageListChangeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MessageListChangeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ListHandle"

    static const int kU16ListHandle = 0;

    /**
     * Clears the field "u16ListHandle".
     *
     * The field will be set to its default value. The hasU16ListHandle()
     * method will return false.
     */
    inline void clearU16ListHandle();

    /**
     * Checks whether the field "u16ListHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ListHandle()). Otherwise it will return false.
     */
    inline bool hasU16ListHandle () const;

    /**
     * Returns the value of the member "u16ListHandle".
     *
     * The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @return The value of the field "u16ListHandle"
     */
    inline uint16 getU16ListHandle () const;

    /**
     * Sets the value of the member "u16ListHandle".
     *
     * The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @param u16ListHandle The value which will be set
     */
    inline void setU16ListHandle (uint16 u16ListHandle_);

    // API of field "e8ListChangeType"

    static const int kE8ListChangeType = 1;

    /**
     * Clears the field "e8ListChangeType".
     *
     * The field will be set to its default value. The hasE8ListChangeType()
     * method will return false.
     */
    inline void clearE8ListChangeType();

    /**
     * Checks whether the field "e8ListChangeType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ListChangeType()). Otherwise it will return false.
     */
    inline bool hasE8ListChangeType () const;

    /**
     * Returns the value of the member "e8ListChangeType".
     *
     *
     *
     * @return The value of the field "e8ListChangeType"
     */
    inline ::most_Msg_fi_types::T_e8_MsgListChangeType getE8ListChangeType () const;

    /**
     * Sets the value of the member "e8ListChangeType".
     *
     *
     *
     * @param e8ListChangeType The value which will be set
     */
    inline void setE8ListChangeType (::most_Msg_fi_types::T_e8_MsgListChangeType e8ListChangeType_);

    // API of field "u16ListLength"

    static const int kU16ListLength = 2;

    /**
     * Clears the field "u16ListLength".
     *
     * The field will be set to its default value. The hasU16ListLength()
     * method will return false.
     */
    inline void clearU16ListLength();

    /**
     * Checks whether the field "u16ListLength" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ListLength()). Otherwise it will return false.
     */
    inline bool hasU16ListLength () const;

    /**
     * Returns the value of the member "u16ListLength".
     *
     * The total length of a message or folder list.
     *
     * @return The value of the field "u16ListLength"
     */
    inline uint16 getU16ListLength () const;

    /**
     * Sets the value of the member "u16ListLength".
     *
     * The total length of a message or folder list.
     *
     * @param u16ListLength The value which will be set
     */
    inline void setU16ListLength (uint16 u16ListLength_);

    // API of field "u32NumItems"

    static const int kU32NumItems = 3;

    /**
     * Clears the field "u32NumItems".
     *
     * The field will be set to its default value. The hasU32NumItems()
     * method will return false.
     */
    inline void clearU32NumItems();

    /**
     * Checks whether the field "u32NumItems" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32NumItems()). Otherwise it will return false.
     */
    inline bool hasU32NumItems () const;

    /**
     * Returns the value of the member "u32NumItems".
     *
     * Contains the number of items that have been added, removed, or changed. If more than 10 items were affected, this value is 0 and the type of change is LCH_CONTENT_CHANGED.
     *
     * @return The value of the field "u32NumItems"
     */
    inline uint32 getU32NumItems () const;

    /**
     * Sets the value of the member "u32NumItems".
     *
     * Contains the number of items that have been added, removed, or changed. If more than 10 items were affected, this value is 0 and the type of change is LCH_CONTENT_CHANGED.
     *
     * @param u32NumItems The value which will be set
     */
    inline void setU32NumItems (uint32 u32NumItems_);

    // API of field "oChangeItems"

    static const int kOChangeItems = 4;

    /**
     * Clears the field "oChangeItems".
     *
     * The field will be set to its default value. The hasOChangeItems()
     * method will return false.
     */
    inline void clearOChangeItems();

    /**
     * Checks whether the field "oChangeItems" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOChangeItems()). Otherwise it will return false.
     */
    inline bool hasOChangeItems () const;

    /**
     * Returns the value of the member "oChangeItems".
     *
     * The ChangeItems parameter is a stream of the position of messages which changed.  This stream is empty when ListChangeType = LCH_CONTENT_CHANGED.
     *
     * @return The value of the field "oChangeItems"
     */
    inline const ::most_Msg_fi_types::T_MsgChangeItems& getOChangeItems () const;

    /**
     * Retrieves the value of the field "oChangeItems" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oChangeItems".
     */
    inline ::most_Msg_fi_types::T_MsgChangeItems& getOChangeItemsMutable ();

    /**
     * Sets the value of the member "oChangeItems".
     *
     * The ChangeItems parameter is a stream of the position of messages which changed.  This stream is empty when ListChangeType = LCH_CONTENT_CHANGED.
     *
     * @param oChangeItems The value which will be set
     */
    inline void setOChangeItems (const ::most_Msg_fi_types::T_MsgChangeItems& oChangeItems_);

    static const MessageListChangeStatus &getDefaultInstance();

private:

    static const ::std::vector< uint32 >& getUint32List_DefaultInstance ();

    inline void set_has_u16ListHandle ();

    inline void clear_has_u16ListHandle ();

    inline void set_has_e8ListChangeType ();

    inline void clear_has_e8ListChangeType ();

    inline void set_has_u16ListLength ();

    inline void clear_has_u16ListLength ();

    inline void set_has_u32NumItems ();

    inline void clear_has_u32NumItems ();

    inline void set_has_oChangeItems ();

    inline void clear_has_oChangeItems ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint16 _u16ListHandle;

    ::most_Msg_fi_types::T_e8_MsgListChangeType _e8ListChangeType;

    uint16 _u16ListLength;

    uint32 _u32NumItems;

    ::most_Msg_fi_types::T_MsgChangeItems _oChangeItems;

};

/**
 * The status message of the property "FolderListChange"
 * Notifies the HMI that the FolderList has changed. The notification includes whether or not the folder list structure has changed or just the
 * message information on a particular folder.
 * The HMI must either:
 * <item>
 * Request the entire list if one or more folders have been added or removed (starting from the Root) or,
 * </item>
 * <item>
 * (Re)request the list information for the Folder corresponding to to the FolderHandle in the notification.
 * </item>
 */
class FolderListChangeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FolderListChangeStatus ();

    /**
     * Copy constructor
     */
    inline  FolderListChangeStatus (const FolderListChangeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FolderListChangeStatus (uint32 u32FolderHandle_, bool bFolderStructureChangedFlag_);

    /**
     * Destructor
     */
    inline virtual  ~FolderListChangeStatus();

    /**
     * Assignment operator
     */
    inline FolderListChangeStatus& operator = (const FolderListChangeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FolderListChangeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FolderListChangeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FolderListChangeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FolderListChangeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32FolderHandle"

    static const int kU32FolderHandle = 0;

    /**
     * Clears the field "u32FolderHandle".
     *
     * The field will be set to its default value. The hasU32FolderHandle()
     * method will return false.
     */
    inline void clearU32FolderHandle();

    /**
     * Checks whether the field "u32FolderHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32FolderHandle()). Otherwise it will return false.
     */
    inline bool hasU32FolderHandle () const;

    /**
     * Returns the value of the member "u32FolderHandle".
     *
     * This is the unique handle for a particular folder.
     *
     * @return The value of the field "u32FolderHandle"
     */
    inline uint32 getU32FolderHandle () const;

    /**
     * Sets the value of the member "u32FolderHandle".
     *
     * This is the unique handle for a particular folder.
     *
     * @param u32FolderHandle The value which will be set
     */
    inline void setU32FolderHandle (uint32 u32FolderHandle_);

    // API of field "bFolderStructureChangedFlag"

    static const int kBFolderStructureChangedFlag = 1;

    /**
     * Clears the field "bFolderStructureChangedFlag".
     *
     * The field will be set to its default value. The hasBFolderStructureChangedFlag()
     * method will return false.
     */
    inline void clearBFolderStructureChangedFlag();

    /**
     * Checks whether the field "bFolderStructureChangedFlag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBFolderStructureChangedFlag()). Otherwise it will return false.
     */
    inline bool hasBFolderStructureChangedFlag () const;

    /**
     * Returns the value of the member "bFolderStructureChangedFlag".
     *
     * Indicates whether or not the folder structure was changed or not.
     *
     * @return The value of the field "bFolderStructureChangedFlag"
     */
    inline bool getBFolderStructureChangedFlag () const;

    /**
     * Sets the value of the member "bFolderStructureChangedFlag".
     *
     * Indicates whether or not the folder structure was changed or not.
     *
     * @param bFolderStructureChangedFlag The value which will be set
     */
    inline void setBFolderStructureChangedFlag (bool bFolderStructureChangedFlag_);

    static const FolderListChangeStatus &getDefaultInstance();

private:

    inline void set_has_u32FolderHandle ();

    inline void clear_has_u32FolderHandle ();

    inline void set_has_bFolderStructureChangedFlag ();

    inline void clear_has_bFolderStructureChangedFlag ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _u32FolderHandle;

    bool _bFolderStructureChangedFlag;

};

/**
 * The status message of the property "MessagingDeviceConnection"
 * This property MessagingDeviceConnection has become DEPRECATED.
 * HMI Controllers are recommended to register for MapDeviceCapabilitiesExtended, since it already includes the functionalities of MessagingDeviceConnection.
 *
 * Identifies the supported message types and active email account (if applicable) for the connected device. This propery also reports the MessagingMemoryStatus of
 * the device that can be used to synchronize the HMI view with whether the device has more memory available for message or it if is full.  Note that the Messaging FBlock
 * triggers alerts to the AlertManager when the device becomes full and when it becomes available again.  The MessageMemoryStatus flag is used to synchronize persistent markers in the HMI view.
 */
class MessagingDeviceConnectionStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MessagingDeviceConnectionStatus ();

    /**
     * Copy constructor
     */
    inline  MessagingDeviceConnectionStatus (const MessagingDeviceConnectionStatus &rhs);

    /**
     * All fields constructor
     */
    inline  MessagingDeviceConnectionStatus (uint8 u8DeviceHandle_, bool bEmailSupport_, bool bSMSSupport_, bool bMMSSupport_, bool bUpdateInboxSupport_, bool bMessagingMemoryStatus_, const ::most_Msg_fi_types::T_MsgActiveAccount& oActiveAccount_);

    /**
     * Destructor
     */
    inline virtual  ~MessagingDeviceConnectionStatus();

    /**
     * Assignment operator
     */
    inline MessagingDeviceConnectionStatus& operator = (const MessagingDeviceConnectionStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MessagingDeviceConnectionStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MessagingDeviceConnectionStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MessagingDeviceConnectionStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MessagingDeviceConnectionStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "bEmailSupport"

    static const int kBEmailSupport = 1;

    /**
     * Clears the field "bEmailSupport".
     *
     * The field will be set to its default value. The hasBEmailSupport()
     * method will return false.
     */
    inline void clearBEmailSupport();

    /**
     * Checks whether the field "bEmailSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBEmailSupport()). Otherwise it will return false.
     */
    inline bool hasBEmailSupport () const;

    /**
     * Returns the value of the member "bEmailSupport".
     *
     * Identifies if email is supported.
     *
     * @return The value of the field "bEmailSupport"
     */
    inline bool getBEmailSupport () const;

    /**
     * Sets the value of the member "bEmailSupport".
     *
     * Identifies if email is supported.
     *
     * @param bEmailSupport The value which will be set
     */
    inline void setBEmailSupport (bool bEmailSupport_);

    // API of field "bSMSSupport"

    static const int kBSMSSupport = 2;

    /**
     * Clears the field "bSMSSupport".
     *
     * The field will be set to its default value. The hasBSMSSupport()
     * method will return false.
     */
    inline void clearBSMSSupport();

    /**
     * Checks whether the field "bSMSSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBSMSSupport()). Otherwise it will return false.
     */
    inline bool hasBSMSSupport () const;

    /**
     * Returns the value of the member "bSMSSupport".
     *
     * Identifies if SMS is supported.
     *
     * @return The value of the field "bSMSSupport"
     */
    inline bool getBSMSSupport () const;

    /**
     * Sets the value of the member "bSMSSupport".
     *
     * Identifies if SMS is supported.
     *
     * @param bSMSSupport The value which will be set
     */
    inline void setBSMSSupport (bool bSMSSupport_);

    // API of field "bMMSSupport"

    static const int kBMMSSupport = 3;

    /**
     * Clears the field "bMMSSupport".
     *
     * The field will be set to its default value. The hasBMMSSupport()
     * method will return false.
     */
    inline void clearBMMSSupport();

    /**
     * Checks whether the field "bMMSSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBMMSSupport()). Otherwise it will return false.
     */
    inline bool hasBMMSSupport () const;

    /**
     * Returns the value of the member "bMMSSupport".
     *
     * Identifies if MMS is supported.
     *
     * @return The value of the field "bMMSSupport"
     */
    inline bool getBMMSSupport () const;

    /**
     * Sets the value of the member "bMMSSupport".
     *
     * Identifies if MMS is supported.
     *
     * @param bMMSSupport The value which will be set
     */
    inline void setBMMSSupport (bool bMMSSupport_);

    // API of field "bUpdateInboxSupport"

    static const int kBUpdateInboxSupport = 4;

    /**
     * Clears the field "bUpdateInboxSupport".
     *
     * The field will be set to its default value. The hasBUpdateInboxSupport()
     * method will return false.
     */
    inline void clearBUpdateInboxSupport();

    /**
     * Checks whether the field "bUpdateInboxSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBUpdateInboxSupport()). Otherwise it will return false.
     */
    inline bool hasBUpdateInboxSupport () const;

    /**
     * Returns the value of the member "bUpdateInboxSupport".
     *
     * Identifies if the update inbox feature is supported. Update inbox is not supported in cases where the Bluetooth device does not allow polling of its mailbox.
     *
     * @return The value of the field "bUpdateInboxSupport"
     */
    inline bool getBUpdateInboxSupport () const;

    /**
     * Sets the value of the member "bUpdateInboxSupport".
     *
     * Identifies if the update inbox feature is supported. Update inbox is not supported in cases where the Bluetooth device does not allow polling of its mailbox.
     *
     * @param bUpdateInboxSupport The value which will be set
     */
    inline void setBUpdateInboxSupport (bool bUpdateInboxSupport_);

    // API of field "bMessagingMemoryStatus"

    static const int kBMessagingMemoryStatus = 5;

    /**
     * Clears the field "bMessagingMemoryStatus".
     *
     * The field will be set to its default value. The hasBMessagingMemoryStatus()
     * method will return false.
     */
    inline void clearBMessagingMemoryStatus();

    /**
     * Checks whether the field "bMessagingMemoryStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBMessagingMemoryStatus()). Otherwise it will return false.
     */
    inline bool hasBMessagingMemoryStatus () const;

    /**
     * Returns the value of the member "bMessagingMemoryStatus".
     *
     * Flag indicating whether memory for messaging is either available or the device is full.
     *
     * @return The value of the field "bMessagingMemoryStatus"
     */
    inline bool getBMessagingMemoryStatus () const;

    /**
     * Sets the value of the member "bMessagingMemoryStatus".
     *
     * Flag indicating whether memory for messaging is either available or the device is full.
     *
     * @param bMessagingMemoryStatus The value which will be set
     */
    inline void setBMessagingMemoryStatus (bool bMessagingMemoryStatus_);

    // API of field "oActiveAccount"

    static const int kOActiveAccount = 6;

    /**
     * Clears the field "oActiveAccount".
     *
     * The field will be set to its default value. The hasOActiveAccount()
     * method will return false.
     */
    inline void clearOActiveAccount();

    /**
     * Checks whether the field "oActiveAccount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOActiveAccount()). Otherwise it will return false.
     */
    inline bool hasOActiveAccount () const;

    /**
     * Returns the value of the member "oActiveAccount".
     *
     * Identifies the active email account.
     *
     * @return The value of the field "oActiveAccount"
     */
    inline const ::most_Msg_fi_types::T_MsgActiveAccount& getOActiveAccount () const;

    /**
     * Retrieves the value of the field "oActiveAccount" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oActiveAccount".
     */
    inline ::most_Msg_fi_types::T_MsgActiveAccount& getOActiveAccountMutable ();

    /**
     * Sets the value of the member "oActiveAccount".
     *
     * Identifies the active email account.
     *
     * @param oActiveAccount The value which will be set
     */
    inline void setOActiveAccount (const ::most_Msg_fi_types::T_MsgActiveAccount& oActiveAccount_);

    static const MessagingDeviceConnectionStatus &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_bEmailSupport ();

    inline void clear_has_bEmailSupport ();

    inline void set_has_bSMSSupport ();

    inline void clear_has_bSMSSupport ();

    inline void set_has_bMMSSupport ();

    inline void clear_has_bMMSSupport ();

    inline void set_has_bUpdateInboxSupport ();

    inline void clear_has_bUpdateInboxSupport ();

    inline void set_has_bMessagingMemoryStatus ();

    inline void clear_has_bMessagingMemoryStatus ();

    inline void set_has_oActiveAccount ();

    inline void clear_has_oActiveAccount ();

    uint32 _has_bits_[ (7 + 31) / 32];

    uint8 _u8DeviceHandle;

    bool _bEmailSupport;

    bool _bSMSSupport;

    bool _bMMSSupport;

    bool _bUpdateInboxSupport;

    bool _bMessagingMemoryStatus;

    ::most_Msg_fi_types::T_MsgActiveAccount _oActiveAccount;

};

/**
 * The status message of the property "UpdateInboxSettings"
 * The Set operation is used by the HMI to set the automatic update inbox feature ON or OFF. If the feature is set to ON, the UpdateInboxPeriod set by the user is also sent.The Get operation is used by the HMI to update the Email Settings view.
 */
class UpdateInboxSettingsStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UpdateInboxSettingsStatus ();

    /**
     * Copy constructor
     */
    inline  UpdateInboxSettingsStatus (const UpdateInboxSettingsStatus &rhs);

    /**
     * All fields constructor
     */
    inline  UpdateInboxSettingsStatus (bool bAutoUpdateInboxOnOff_, uint32 u32UpdateInboxPeriod_);

    /**
     * Destructor
     */
    inline virtual  ~UpdateInboxSettingsStatus();

    /**
     * Assignment operator
     */
    inline UpdateInboxSettingsStatus& operator = (const UpdateInboxSettingsStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateInboxSettingsStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateInboxSettingsStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateInboxSettingsStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateInboxSettingsStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bAutoUpdateInboxOnOff"

    static const int kBAutoUpdateInboxOnOff = 0;

    /**
     * Clears the field "bAutoUpdateInboxOnOff".
     *
     * The field will be set to its default value. The hasBAutoUpdateInboxOnOff()
     * method will return false.
     */
    inline void clearBAutoUpdateInboxOnOff();

    /**
     * Checks whether the field "bAutoUpdateInboxOnOff" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBAutoUpdateInboxOnOff()). Otherwise it will return false.
     */
    inline bool hasBAutoUpdateInboxOnOff () const;

    /**
     * Returns the value of the member "bAutoUpdateInboxOnOff".
     *
     * Identifies if the automatic update of the inbox is set to ON or OFF.
     *
     * @return The value of the field "bAutoUpdateInboxOnOff"
     */
    inline bool getBAutoUpdateInboxOnOff () const;

    /**
     * Sets the value of the member "bAutoUpdateInboxOnOff".
     *
     * Identifies if the automatic update of the inbox is set to ON or OFF.
     *
     * @param bAutoUpdateInboxOnOff The value which will be set
     */
    inline void setBAutoUpdateInboxOnOff (bool bAutoUpdateInboxOnOff_);

    // API of field "u32UpdateInboxPeriod"

    static const int kU32UpdateInboxPeriod = 1;

    /**
     * Clears the field "u32UpdateInboxPeriod".
     *
     * The field will be set to its default value. The hasU32UpdateInboxPeriod()
     * method will return false.
     */
    inline void clearU32UpdateInboxPeriod();

    /**
     * Checks whether the field "u32UpdateInboxPeriod" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32UpdateInboxPeriod()). Otherwise it will return false.
     */
    inline bool hasU32UpdateInboxPeriod () const;

    /**
     * Returns the value of the member "u32UpdateInboxPeriod".
     *
     * The polling period for the inbox for those email accounts that require polling. The period value is in seconds.
     *
     * @return The value of the field "u32UpdateInboxPeriod"
     */
    inline uint32 getU32UpdateInboxPeriod () const;

    /**
     * Sets the value of the member "u32UpdateInboxPeriod".
     *
     * The polling period for the inbox for those email accounts that require polling. The period value is in seconds.
     *
     * @param u32UpdateInboxPeriod The value which will be set
     */
    inline void setU32UpdateInboxPeriod (uint32 u32UpdateInboxPeriod_);

    static const UpdateInboxSettingsStatus &getDefaultInstance();

private:

    inline void set_has_bAutoUpdateInboxOnOff ();

    inline void clear_has_bAutoUpdateInboxOnOff ();

    inline void set_has_u32UpdateInboxPeriod ();

    inline void clear_has_u32UpdateInboxPeriod ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bAutoUpdateInboxOnOff;

    uint32 _u32UpdateInboxPeriod;

};

/**
 * The pureSet message of the property "UpdateInboxSettings"
 * The Set operation is used by the HMI to set the automatic update inbox feature ON or OFF. If the feature is set to ON, the UpdateInboxPeriod set by the user is also sent.The Get operation is used by the HMI to update the Email Settings view.
 */
class UpdateInboxSettingsPureSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UpdateInboxSettingsPureSet ();

    /**
     * Copy constructor
     */
    inline  UpdateInboxSettingsPureSet (const UpdateInboxSettingsPureSet &rhs);

    /**
     * All fields constructor
     */
    inline  UpdateInboxSettingsPureSet (bool bAutoUpdateInboxOnOff_, uint32 u32UpdateInboxPeriod_);

    /**
     * Destructor
     */
    inline virtual  ~UpdateInboxSettingsPureSet();

    /**
     * Assignment operator
     */
    inline UpdateInboxSettingsPureSet& operator = (const UpdateInboxSettingsPureSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateInboxSettingsPureSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateInboxSettingsPureSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateInboxSettingsPureSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateInboxSettingsPureSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bAutoUpdateInboxOnOff"

    static const int kBAutoUpdateInboxOnOff = 0;

    /**
     * Clears the field "bAutoUpdateInboxOnOff".
     *
     * The field will be set to its default value. The hasBAutoUpdateInboxOnOff()
     * method will return false.
     */
    inline void clearBAutoUpdateInboxOnOff();

    /**
     * Checks whether the field "bAutoUpdateInboxOnOff" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBAutoUpdateInboxOnOff()). Otherwise it will return false.
     */
    inline bool hasBAutoUpdateInboxOnOff () const;

    /**
     * Returns the value of the member "bAutoUpdateInboxOnOff".
     *
     * Identifies if the automatic update of the inbox is set to ON or OFF.
     *
     * @return The value of the field "bAutoUpdateInboxOnOff"
     */
    inline bool getBAutoUpdateInboxOnOff () const;

    /**
     * Sets the value of the member "bAutoUpdateInboxOnOff".
     *
     * Identifies if the automatic update of the inbox is set to ON or OFF.
     *
     * @param bAutoUpdateInboxOnOff The value which will be set
     */
    inline void setBAutoUpdateInboxOnOff (bool bAutoUpdateInboxOnOff_);

    // API of field "u32UpdateInboxPeriod"

    static const int kU32UpdateInboxPeriod = 1;

    /**
     * Clears the field "u32UpdateInboxPeriod".
     *
     * The field will be set to its default value. The hasU32UpdateInboxPeriod()
     * method will return false.
     */
    inline void clearU32UpdateInboxPeriod();

    /**
     * Checks whether the field "u32UpdateInboxPeriod" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32UpdateInboxPeriod()). Otherwise it will return false.
     */
    inline bool hasU32UpdateInboxPeriod () const;

    /**
     * Returns the value of the member "u32UpdateInboxPeriod".
     *
     * The polling period for the inbox for those email accounts that require polling. The period value is in seconds.
     *
     * @return The value of the field "u32UpdateInboxPeriod"
     */
    inline uint32 getU32UpdateInboxPeriod () const;

    /**
     * Sets the value of the member "u32UpdateInboxPeriod".
     *
     * The polling period for the inbox for those email accounts that require polling. The period value is in seconds.
     *
     * @param u32UpdateInboxPeriod The value which will be set
     */
    inline void setU32UpdateInboxPeriod (uint32 u32UpdateInboxPeriod_);

    static const UpdateInboxSettingsPureSet &getDefaultInstance();

private:

    inline void set_has_bAutoUpdateInboxOnOff ();

    inline void clear_has_bAutoUpdateInboxOnOff ();

    inline void set_has_u32UpdateInboxPeriod ();

    inline void clear_has_u32UpdateInboxPeriod ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bAutoUpdateInboxOnOff;

    uint32 _u32UpdateInboxPeriod;

};

/**
 * The error message of 'UpdateInboxSettings'
 */
class UpdateInboxSettingsErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  UpdateInboxSettingsErrorStructure ();

    /**
     * Copy constructor
     */
    inline  UpdateInboxSettingsErrorStructure (const UpdateInboxSettingsErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  UpdateInboxSettingsErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~UpdateInboxSettingsErrorStructure();

    /**
     * Assignment operator
     */
    inline UpdateInboxSettingsErrorStructure& operator = (const UpdateInboxSettingsErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateInboxSettingsErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateInboxSettingsErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateInboxSettingsErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateInboxSettingsErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const UpdateInboxSettingsErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'UpdateInboxSettings'
 */
class UpdateInboxSettingsError  : public ::asf::core::Payload {
public:

    enum UpdateInboxSettingsErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  UpdateInboxSettingsError ();

   /**
     * Copy constructor
     */
    inline  UpdateInboxSettingsError (const UpdateInboxSettingsError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~UpdateInboxSettingsError();

    /**
     * Assigns a new value to this object.
     */
    inline UpdateInboxSettingsError& operator = (const UpdateInboxSettingsError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateInboxSettingsError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateInboxSettingsError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateInboxSettingsError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateInboxSettingsError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline UpdateInboxSettingsError::UpdateInboxSettingsErrorField getField () const;

    inline void setField(UpdateInboxSettingsError::UpdateInboxSettingsErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "UpdateInboxSettingsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "UpdateInboxSettingsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const UpdateInboxSettingsErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline UpdateInboxSettingsErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline UpdateInboxSettingsErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (UpdateInboxSettingsErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "UpdateInboxSettingsErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const UpdateInboxSettingsErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const UpdateInboxSettingsError &getDefaultInstance();

private:

    inline void cloneData (const UpdateInboxSettingsError& rhs);

    inline void deleteData ();

    UpdateInboxSettingsErrorField __field;

    union {
        UpdateInboxSettingsErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "AudioAttachmentPlaybackState"
 * Provides notification of the playback status the currently playing audio attachment.  The Status response is triggered to notified controllers to notify changes in the playback state of an audio attachment.
 * The Get operator returns the status of the currently playing audio attachment or the status of the last played attachment if attachment play has ended.  If no attachment play is defined, the return AttachmentHandle shall be set to the null value of 0x0000.
 */
class AudioAttachmentPlaybackStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AudioAttachmentPlaybackStateStatus ();

    /**
     * Copy constructor
     */
    inline  AudioAttachmentPlaybackStateStatus (const AudioAttachmentPlaybackStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AudioAttachmentPlaybackStateStatus (uint16 u16AttachmentHandle_, ::most_Msg_fi_types::T_e8_MsgPlaybackState e8PlaybackState_);

    /**
     * Destructor
     */
    inline virtual  ~AudioAttachmentPlaybackStateStatus();

    /**
     * Assignment operator
     */
    inline AudioAttachmentPlaybackStateStatus& operator = (const AudioAttachmentPlaybackStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudioAttachmentPlaybackStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudioAttachmentPlaybackStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudioAttachmentPlaybackStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudioAttachmentPlaybackStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16AttachmentHandle"

    static const int kU16AttachmentHandle = 0;

    /**
     * Clears the field "u16AttachmentHandle".
     *
     * The field will be set to its default value. The hasU16AttachmentHandle()
     * method will return false.
     */
    inline void clearU16AttachmentHandle();

    /**
     * Checks whether the field "u16AttachmentHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16AttachmentHandle()). Otherwise it will return false.
     */
    inline bool hasU16AttachmentHandle () const;

    /**
     * Returns the value of the member "u16AttachmentHandle".
     *
     * This is the handle for a particular attachment.  The handle is locally unique only for a particular message and is not required to be globally unique.
     *
     * @return The value of the field "u16AttachmentHandle"
     */
    inline uint16 getU16AttachmentHandle () const;

    /**
     * Sets the value of the member "u16AttachmentHandle".
     *
     * This is the handle for a particular attachment.  The handle is locally unique only for a particular message and is not required to be globally unique.
     *
     * @param u16AttachmentHandle The value which will be set
     */
    inline void setU16AttachmentHandle (uint16 u16AttachmentHandle_);

    // API of field "e8PlaybackState"

    static const int kE8PlaybackState = 1;

    /**
     * Clears the field "e8PlaybackState".
     *
     * The field will be set to its default value. The hasE8PlaybackState()
     * method will return false.
     */
    inline void clearE8PlaybackState();

    /**
     * Checks whether the field "e8PlaybackState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PlaybackState()). Otherwise it will return false.
     */
    inline bool hasE8PlaybackState () const;

    /**
     * Returns the value of the member "e8PlaybackState".
     *
     *
     *
     * @return The value of the field "e8PlaybackState"
     */
    inline ::most_Msg_fi_types::T_e8_MsgPlaybackState getE8PlaybackState () const;

    /**
     * Sets the value of the member "e8PlaybackState".
     *
     *
     *
     * @param e8PlaybackState The value which will be set
     */
    inline void setE8PlaybackState (::most_Msg_fi_types::T_e8_MsgPlaybackState e8PlaybackState_);

    static const AudioAttachmentPlaybackStateStatus &getDefaultInstance();

private:

    inline void set_has_u16AttachmentHandle ();

    inline void clear_has_u16AttachmentHandle ();

    inline void set_has_e8PlaybackState ();

    inline void clear_has_e8PlaybackState ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _u16AttachmentHandle;

    ::most_Msg_fi_types::T_e8_MsgPlaybackState _e8PlaybackState;

};

/**
 * The error message of 'AudioAttachmentPlaybackState'
 */
class AudioAttachmentPlaybackStateErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  AudioAttachmentPlaybackStateErrorStructure ();

    /**
     * Copy constructor
     */
    inline  AudioAttachmentPlaybackStateErrorStructure (const AudioAttachmentPlaybackStateErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  AudioAttachmentPlaybackStateErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~AudioAttachmentPlaybackStateErrorStructure();

    /**
     * Assignment operator
     */
    inline AudioAttachmentPlaybackStateErrorStructure& operator = (const AudioAttachmentPlaybackStateErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudioAttachmentPlaybackStateErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudioAttachmentPlaybackStateErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudioAttachmentPlaybackStateErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudioAttachmentPlaybackStateErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const AudioAttachmentPlaybackStateErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'AudioAttachmentPlaybackState'
 */
class AudioAttachmentPlaybackStateError  : public ::asf::core::Payload {
public:

    enum AudioAttachmentPlaybackStateErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  AudioAttachmentPlaybackStateError ();

   /**
     * Copy constructor
     */
    inline  AudioAttachmentPlaybackStateError (const AudioAttachmentPlaybackStateError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~AudioAttachmentPlaybackStateError();

    /**
     * Assigns a new value to this object.
     */
    inline AudioAttachmentPlaybackStateError& operator = (const AudioAttachmentPlaybackStateError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudioAttachmentPlaybackStateError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudioAttachmentPlaybackStateError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudioAttachmentPlaybackStateError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudioAttachmentPlaybackStateError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline AudioAttachmentPlaybackStateError::AudioAttachmentPlaybackStateErrorField getField () const;

    inline void setField(AudioAttachmentPlaybackStateError::AudioAttachmentPlaybackStateErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "AudioAttachmentPlaybackStateErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "AudioAttachmentPlaybackStateErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const AudioAttachmentPlaybackStateErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline AudioAttachmentPlaybackStateErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline AudioAttachmentPlaybackStateErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (AudioAttachmentPlaybackStateErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "AudioAttachmentPlaybackStateErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const AudioAttachmentPlaybackStateErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const AudioAttachmentPlaybackStateError &getDefaultInstance();

private:

    inline void cloneData (const AudioAttachmentPlaybackStateError& rhs);

    inline void deleteData ();

    AudioAttachmentPlaybackStateErrorField __field;

    union {
        AudioAttachmentPlaybackStateErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "SignatureSetting"
 * Used to set and acquire the signature text to be appended to the end of a message.
 */
class SignatureSettingStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SignatureSettingStatus ();

    /**
     * Copy constructor
     */
    inline  SignatureSettingStatus (const SignatureSettingStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SignatureSettingStatus (const ::fi_basetypes_most::T_String& sSignatureText_);

    /**
     * Destructor
     */
    inline virtual  ~SignatureSettingStatus();

    /**
     * Assignment operator
     */
    inline SignatureSettingStatus& operator = (const SignatureSettingStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SignatureSettingStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SignatureSettingStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SignatureSettingStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SignatureSettingStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sSignatureText"

    static const int kSSignatureText = 0;

    /**
     * Clears the field "sSignatureText".
     *
     * The field will be set to its default value. The hasSSignatureText()
     * method will return false.
     */
    inline void clearSSignatureText();

    /**
     * Checks whether the field "sSignatureText" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSSignatureText()). Otherwise it will return false.
     */
    inline bool hasSSignatureText () const;

    /**
     * Returns the value of the member "sSignatureText".
     *
     * The text of the signature to be appended to messages sent from the vehicle.
     *
     * @return The value of the field "sSignatureText"
     */
    inline const ::fi_basetypes_most::T_String& getSSignatureText () const;

    /**
     * Retrieves the value of the field "sSignatureText" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sSignatureText".
     */
    inline ::fi_basetypes_most::T_String& getSSignatureTextMutable ();

    /**
     * Sets the value of the member "sSignatureText".
     *
     * The text of the signature to be appended to messages sent from the vehicle.
     *
     * @param sSignatureText The value which will be set
     */
    inline void setSSignatureText (const ::fi_basetypes_most::T_String& sSignatureText_);

    static const SignatureSettingStatus &getDefaultInstance();

private:

    inline void set_has_sSignatureText ();

    inline void clear_has_sSignatureText ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::fi_basetypes_most::T_String _sSignatureText;

};

/**
 * The pureSet message of the property "SignatureSetting"
 * Used to set and acquire the signature text to be appended to the end of a message.
 */
class SignatureSettingPureSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SignatureSettingPureSet ();

    /**
     * Copy constructor
     */
    inline  SignatureSettingPureSet (const SignatureSettingPureSet &rhs);

    /**
     * All fields constructor
     */
    inline  SignatureSettingPureSet (const ::fi_basetypes_most::T_String& sSignatureText_);

    /**
     * Destructor
     */
    inline virtual  ~SignatureSettingPureSet();

    /**
     * Assignment operator
     */
    inline SignatureSettingPureSet& operator = (const SignatureSettingPureSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SignatureSettingPureSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SignatureSettingPureSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SignatureSettingPureSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SignatureSettingPureSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sSignatureText"

    static const int kSSignatureText = 0;

    /**
     * Clears the field "sSignatureText".
     *
     * The field will be set to its default value. The hasSSignatureText()
     * method will return false.
     */
    inline void clearSSignatureText();

    /**
     * Checks whether the field "sSignatureText" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSSignatureText()). Otherwise it will return false.
     */
    inline bool hasSSignatureText () const;

    /**
     * Returns the value of the member "sSignatureText".
     *
     * The text of the signature to be appended to messages sent from the vehicle.
     *
     * @return The value of the field "sSignatureText"
     */
    inline const ::fi_basetypes_most::T_String& getSSignatureText () const;

    /**
     * Retrieves the value of the field "sSignatureText" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sSignatureText".
     */
    inline ::fi_basetypes_most::T_String& getSSignatureTextMutable ();

    /**
     * Sets the value of the member "sSignatureText".
     *
     * The text of the signature to be appended to messages sent from the vehicle.
     *
     * @param sSignatureText The value which will be set
     */
    inline void setSSignatureText (const ::fi_basetypes_most::T_String& sSignatureText_);

    static const SignatureSettingPureSet &getDefaultInstance();

private:

    inline void set_has_sSignatureText ();

    inline void clear_has_sSignatureText ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::fi_basetypes_most::T_String _sSignatureText;

};

/**
 * The error message of 'SignatureSetting'
 */
class SignatureSettingErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SignatureSettingErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SignatureSettingErrorStructure (const SignatureSettingErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SignatureSettingErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~SignatureSettingErrorStructure();

    /**
     * Assignment operator
     */
    inline SignatureSettingErrorStructure& operator = (const SignatureSettingErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SignatureSettingErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SignatureSettingErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SignatureSettingErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SignatureSettingErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const SignatureSettingErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'SignatureSetting'
 */
class SignatureSettingError  : public ::asf::core::Payload {
public:

    enum SignatureSettingErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SignatureSettingError ();

   /**
     * Copy constructor
     */
    inline  SignatureSettingError (const SignatureSettingError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SignatureSettingError();

    /**
     * Assigns a new value to this object.
     */
    inline SignatureSettingError& operator = (const SignatureSettingError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SignatureSettingError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SignatureSettingError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SignatureSettingError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SignatureSettingError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SignatureSettingError::SignatureSettingErrorField getField () const;

    inline void setField(SignatureSettingError::SignatureSettingErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SignatureSettingErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SignatureSettingErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SignatureSettingErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SignatureSettingErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SignatureSettingErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SignatureSettingErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SignatureSettingErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SignatureSettingErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SignatureSettingError &getDefaultInstance();

private:

    inline void cloneData (const SignatureSettingError& rhs);

    inline void deleteData ();

    SignatureSettingErrorField __field;

    union {
        SignatureSettingErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "AudioMessageRecordingState"
 * Provides the audio message recording state.
 */
class AudioMessageRecordingStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AudioMessageRecordingStateStatus ();

    /**
     * Copy constructor
     */
    inline  AudioMessageRecordingStateStatus (const AudioMessageRecordingStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AudioMessageRecordingStateStatus (::most_Msg_fi_types::T_e8_MsgRecordMessageState e8RecordMessageState_);

    /**
     * Destructor
     */
    inline virtual  ~AudioMessageRecordingStateStatus();

    /**
     * Assignment operator
     */
    inline AudioMessageRecordingStateStatus& operator = (const AudioMessageRecordingStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudioMessageRecordingStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudioMessageRecordingStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudioMessageRecordingStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudioMessageRecordingStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8RecordMessageState"

    static const int kE8RecordMessageState = 0;

    /**
     * Clears the field "e8RecordMessageState".
     *
     * The field will be set to its default value. The hasE8RecordMessageState()
     * method will return false.
     */
    inline void clearE8RecordMessageState();

    /**
     * Checks whether the field "e8RecordMessageState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8RecordMessageState()). Otherwise it will return false.
     */
    inline bool hasE8RecordMessageState () const;

    /**
     * Returns the value of the member "e8RecordMessageState".
     *
     * Identifies the audiomessage voice recording states: Recording, Stopped, Cancelled
     *
     * @return The value of the field "e8RecordMessageState"
     */
    inline ::most_Msg_fi_types::T_e8_MsgRecordMessageState getE8RecordMessageState () const;

    /**
     * Sets the value of the member "e8RecordMessageState".
     *
     * Identifies the audiomessage voice recording states: Recording, Stopped, Cancelled
     *
     * @param e8RecordMessageState The value which will be set
     */
    inline void setE8RecordMessageState (::most_Msg_fi_types::T_e8_MsgRecordMessageState e8RecordMessageState_);

    static const AudioMessageRecordingStateStatus &getDefaultInstance();

private:

    inline void set_has_e8RecordMessageState ();

    inline void clear_has_e8RecordMessageState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_Msg_fi_types::T_e8_MsgRecordMessageState _e8RecordMessageState;

};

/**
 * The error message of 'AudioMessageRecordingState'
 */
class AudioMessageRecordingStateErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  AudioMessageRecordingStateErrorStructure ();

    /**
     * Copy constructor
     */
    inline  AudioMessageRecordingStateErrorStructure (const AudioMessageRecordingStateErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  AudioMessageRecordingStateErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~AudioMessageRecordingStateErrorStructure();

    /**
     * Assignment operator
     */
    inline AudioMessageRecordingStateErrorStructure& operator = (const AudioMessageRecordingStateErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudioMessageRecordingStateErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudioMessageRecordingStateErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudioMessageRecordingStateErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudioMessageRecordingStateErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const AudioMessageRecordingStateErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'AudioMessageRecordingState'
 */
class AudioMessageRecordingStateError  : public ::asf::core::Payload {
public:

    enum AudioMessageRecordingStateErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  AudioMessageRecordingStateError ();

   /**
     * Copy constructor
     */
    inline  AudioMessageRecordingStateError (const AudioMessageRecordingStateError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~AudioMessageRecordingStateError();

    /**
     * Assigns a new value to this object.
     */
    inline AudioMessageRecordingStateError& operator = (const AudioMessageRecordingStateError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudioMessageRecordingStateError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudioMessageRecordingStateError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudioMessageRecordingStateError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudioMessageRecordingStateError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline AudioMessageRecordingStateError::AudioMessageRecordingStateErrorField getField () const;

    inline void setField(AudioMessageRecordingStateError::AudioMessageRecordingStateErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "AudioMessageRecordingStateErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "AudioMessageRecordingStateErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const AudioMessageRecordingStateErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline AudioMessageRecordingStateErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline AudioMessageRecordingStateErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (AudioMessageRecordingStateErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "AudioMessageRecordingStateErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const AudioMessageRecordingStateErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const AudioMessageRecordingStateError &getDefaultInstance();

private:

    inline void cloneData (const AudioMessageRecordingStateError& rhs);

    inline void deleteData ();

    AudioMessageRecordingStateErrorField __field;

    union {
        AudioMessageRecordingStateErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "RecordedAudioMessageInfo"
 * Property provides the handle of the recorded audio message. It is sent by Messaging in the case where the recording limit has been reached.
 */
class RecordedAudioMessageInfoStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RecordedAudioMessageInfoStatus ();

    /**
     * Copy constructor
     */
    inline  RecordedAudioMessageInfoStatus (const RecordedAudioMessageInfoStatus &rhs);

    /**
     * All fields constructor
     */
    inline  RecordedAudioMessageInfoStatus (uint16 u16RecordedAudioMessageHandle_);

    /**
     * Destructor
     */
    inline virtual  ~RecordedAudioMessageInfoStatus();

    /**
     * Assignment operator
     */
    inline RecordedAudioMessageInfoStatus& operator = (const RecordedAudioMessageInfoStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RecordedAudioMessageInfoStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RecordedAudioMessageInfoStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RecordedAudioMessageInfoStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RecordedAudioMessageInfoStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16RecordedAudioMessageHandle"

    static const int kU16RecordedAudioMessageHandle = 0;

    /**
     * Clears the field "u16RecordedAudioMessageHandle".
     *
     * The field will be set to its default value. The hasU16RecordedAudioMessageHandle()
     * method will return false.
     */
    inline void clearU16RecordedAudioMessageHandle();

    /**
     * Checks whether the field "u16RecordedAudioMessageHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16RecordedAudioMessageHandle()). Otherwise it will return false.
     */
    inline bool hasU16RecordedAudioMessageHandle () const;

    /**
     * Returns the value of the member "u16RecordedAudioMessageHandle".
     *
     * RecordedAudioMessageHandle = 0 is reserved to identify a NULL handle.
     *
     * @return The value of the field "u16RecordedAudioMessageHandle"
     */
    inline uint16 getU16RecordedAudioMessageHandle () const;

    /**
     * Sets the value of the member "u16RecordedAudioMessageHandle".
     *
     * RecordedAudioMessageHandle = 0 is reserved to identify a NULL handle.
     *
     * @param u16RecordedAudioMessageHandle The value which will be set
     */
    inline void setU16RecordedAudioMessageHandle (uint16 u16RecordedAudioMessageHandle_);

    static const RecordedAudioMessageInfoStatus &getDefaultInstance();

private:

    inline void set_has_u16RecordedAudioMessageHandle ();

    inline void clear_has_u16RecordedAudioMessageHandle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16RecordedAudioMessageHandle;

};

/**
 * The error message of 'RecordedAudioMessageInfo'
 */
class RecordedAudioMessageInfoErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  RecordedAudioMessageInfoErrorStructure ();

    /**
     * Copy constructor
     */
    inline  RecordedAudioMessageInfoErrorStructure (const RecordedAudioMessageInfoErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  RecordedAudioMessageInfoErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~RecordedAudioMessageInfoErrorStructure();

    /**
     * Assignment operator
     */
    inline RecordedAudioMessageInfoErrorStructure& operator = (const RecordedAudioMessageInfoErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RecordedAudioMessageInfoErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RecordedAudioMessageInfoErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RecordedAudioMessageInfoErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RecordedAudioMessageInfoErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const RecordedAudioMessageInfoErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'RecordedAudioMessageInfo'
 */
class RecordedAudioMessageInfoError  : public ::asf::core::Payload {
public:

    enum RecordedAudioMessageInfoErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  RecordedAudioMessageInfoError ();

   /**
     * Copy constructor
     */
    inline  RecordedAudioMessageInfoError (const RecordedAudioMessageInfoError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~RecordedAudioMessageInfoError();

    /**
     * Assigns a new value to this object.
     */
    inline RecordedAudioMessageInfoError& operator = (const RecordedAudioMessageInfoError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RecordedAudioMessageInfoError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RecordedAudioMessageInfoError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RecordedAudioMessageInfoError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RecordedAudioMessageInfoError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline RecordedAudioMessageInfoError::RecordedAudioMessageInfoErrorField getField () const;

    inline void setField(RecordedAudioMessageInfoError::RecordedAudioMessageInfoErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "RecordedAudioMessageInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "RecordedAudioMessageInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const RecordedAudioMessageInfoErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline RecordedAudioMessageInfoErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline RecordedAudioMessageInfoErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (RecordedAudioMessageInfoErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "RecordedAudioMessageInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const RecordedAudioMessageInfoErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const RecordedAudioMessageInfoError &getDefaultInstance();

private:

    inline void cloneData (const RecordedAudioMessageInfoError& rhs);

    inline void deleteData ();

    RecordedAudioMessageInfoErrorField __field;

    union {
        RecordedAudioMessageInfoErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "PredefinedMessageList"
 * This property contains the predefined message list. The list is ordered per the requirements in the HMI Form and Behavior Specification.
 */
class PredefinedMessageListStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PredefinedMessageListStatus ();

    /**
     * Copy constructor
     */
    inline  PredefinedMessageListStatus (const PredefinedMessageListStatus &rhs);

    /**
     * All fields constructor
     */
    inline  PredefinedMessageListStatus (uint8 u8NumPredefinedMessages_, const ::most_Msg_fi_types::T_MsgPredefinedMessageListResult& oPredefinedMessageListResult_);

    /**
     * Destructor
     */
    inline virtual  ~PredefinedMessageListStatus();

    /**
     * Assignment operator
     */
    inline PredefinedMessageListStatus& operator = (const PredefinedMessageListStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PredefinedMessageListStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PredefinedMessageListStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PredefinedMessageListStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PredefinedMessageListStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8NumPredefinedMessages"

    static const int kU8NumPredefinedMessages = 0;

    /**
     * Clears the field "u8NumPredefinedMessages".
     *
     * The field will be set to its default value. The hasU8NumPredefinedMessages()
     * method will return false.
     */
    inline void clearU8NumPredefinedMessages();

    /**
     * Checks whether the field "u8NumPredefinedMessages" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8NumPredefinedMessages()). Otherwise it will return false.
     */
    inline bool hasU8NumPredefinedMessages () const;

    /**
     * Returns the value of the member "u8NumPredefinedMessages".
     *
     * The number of predefined messages in the ensuing list stream.
     *
     * @return The value of the field "u8NumPredefinedMessages"
     */
    inline uint8 getU8NumPredefinedMessages () const;

    /**
     * Sets the value of the member "u8NumPredefinedMessages".
     *
     * The number of predefined messages in the ensuing list stream.
     *
     * @param u8NumPredefinedMessages The value which will be set
     */
    inline void setU8NumPredefinedMessages (uint8 u8NumPredefinedMessages_);

    // API of field "oPredefinedMessageListResult"

    static const int kOPredefinedMessageListResult = 1;

    /**
     * Clears the field "oPredefinedMessageListResult".
     *
     * The field will be set to its default value. The hasOPredefinedMessageListResult()
     * method will return false.
     */
    inline void clearOPredefinedMessageListResult();

    /**
     * Checks whether the field "oPredefinedMessageListResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOPredefinedMessageListResult()). Otherwise it will return false.
     */
    inline bool hasOPredefinedMessageListResult () const;

    /**
     * Returns the value of the member "oPredefinedMessageListResult".
     *
     * Includes a stream of all predefined messages.
     *
     * @return The value of the field "oPredefinedMessageListResult"
     */
    inline const ::most_Msg_fi_types::T_MsgPredefinedMessageListResult& getOPredefinedMessageListResult () const;

    /**
     * Retrieves the value of the field "oPredefinedMessageListResult" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oPredefinedMessageListResult".
     */
    inline ::most_Msg_fi_types::T_MsgPredefinedMessageListResult& getOPredefinedMessageListResultMutable ();

    /**
     * Sets the value of the member "oPredefinedMessageListResult".
     *
     * Includes a stream of all predefined messages.
     *
     * @param oPredefinedMessageListResult The value which will be set
     */
    inline void setOPredefinedMessageListResult (const ::most_Msg_fi_types::T_MsgPredefinedMessageListResult& oPredefinedMessageListResult_);

    static const PredefinedMessageListStatus &getDefaultInstance();

private:

    static const ::std::vector< ::most_Msg_fi_types::T_MsgPredefinedMessageListResultItem >& getT_MsgPredefinedMessageListResultItemList_DefaultInstance ();

    inline void set_has_u8NumPredefinedMessages ();

    inline void clear_has_u8NumPredefinedMessages ();

    inline void set_has_oPredefinedMessageListResult ();

    inline void clear_has_oPredefinedMessageListResult ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8NumPredefinedMessages;

    ::most_Msg_fi_types::T_MsgPredefinedMessageListResult _oPredefinedMessageListResult;

};

/**
 * The error message of 'PredefinedMessageList'
 */
class PredefinedMessageListErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  PredefinedMessageListErrorStructure ();

    /**
     * Copy constructor
     */
    inline  PredefinedMessageListErrorStructure (const PredefinedMessageListErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  PredefinedMessageListErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~PredefinedMessageListErrorStructure();

    /**
     * Assignment operator
     */
    inline PredefinedMessageListErrorStructure& operator = (const PredefinedMessageListErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PredefinedMessageListErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PredefinedMessageListErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PredefinedMessageListErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PredefinedMessageListErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const PredefinedMessageListErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'PredefinedMessageList'
 */
class PredefinedMessageListError  : public ::asf::core::Payload {
public:

    enum PredefinedMessageListErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  PredefinedMessageListError ();

   /**
     * Copy constructor
     */
    inline  PredefinedMessageListError (const PredefinedMessageListError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~PredefinedMessageListError();

    /**
     * Assigns a new value to this object.
     */
    inline PredefinedMessageListError& operator = (const PredefinedMessageListError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PredefinedMessageListError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PredefinedMessageListError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PredefinedMessageListError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PredefinedMessageListError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline PredefinedMessageListError::PredefinedMessageListErrorField getField () const;

    inline void setField(PredefinedMessageListError::PredefinedMessageListErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "PredefinedMessageListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "PredefinedMessageListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const PredefinedMessageListErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline PredefinedMessageListErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline PredefinedMessageListErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (PredefinedMessageListErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "PredefinedMessageListErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const PredefinedMessageListErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const PredefinedMessageListError &getDefaultInstance();

private:

    inline void cloneData (const PredefinedMessageListError& rhs);

    inline void deleteData ();

    PredefinedMessageListErrorField __field;

    union {
        PredefinedMessageListErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "MessagingAudioPlaybackState"
 * Provides notification of the playback status for all audio related functions within Messaging: Text-to-Speech session, when reading a message aloud, and listening to a recorded audio message.
 */
class MessagingAudioPlaybackStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MessagingAudioPlaybackStateStatus ();

    /**
     * Copy constructor
     */
    inline  MessagingAudioPlaybackStateStatus (const MessagingAudioPlaybackStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  MessagingAudioPlaybackStateStatus (::most_Msg_fi_types::T_e8_MsgPlaybackState e8PlaybackState_);

    /**
     * Destructor
     */
    inline virtual  ~MessagingAudioPlaybackStateStatus();

    /**
     * Assignment operator
     */
    inline MessagingAudioPlaybackStateStatus& operator = (const MessagingAudioPlaybackStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MessagingAudioPlaybackStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MessagingAudioPlaybackStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MessagingAudioPlaybackStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MessagingAudioPlaybackStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8PlaybackState"

    static const int kE8PlaybackState = 0;

    /**
     * Clears the field "e8PlaybackState".
     *
     * The field will be set to its default value. The hasE8PlaybackState()
     * method will return false.
     */
    inline void clearE8PlaybackState();

    /**
     * Checks whether the field "e8PlaybackState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PlaybackState()). Otherwise it will return false.
     */
    inline bool hasE8PlaybackState () const;

    /**
     * Returns the value of the member "e8PlaybackState".
     *
     *
     *
     * @return The value of the field "e8PlaybackState"
     */
    inline ::most_Msg_fi_types::T_e8_MsgPlaybackState getE8PlaybackState () const;

    /**
     * Sets the value of the member "e8PlaybackState".
     *
     *
     *
     * @param e8PlaybackState The value which will be set
     */
    inline void setE8PlaybackState (::most_Msg_fi_types::T_e8_MsgPlaybackState e8PlaybackState_);

    static const MessagingAudioPlaybackStateStatus &getDefaultInstance();

private:

    inline void set_has_e8PlaybackState ();

    inline void clear_has_e8PlaybackState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_Msg_fi_types::T_e8_MsgPlaybackState _e8PlaybackState;

};

/**
 * The status message of the property "TextAlertEnable"
 * Provides the ability to turn the Text Alert On or Off.
 */
class TextAlertEnableStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TextAlertEnableStatus ();

    /**
     * Copy constructor
     */
    inline  TextAlertEnableStatus (const TextAlertEnableStatus &rhs);

    /**
     * All fields constructor
     */
    inline  TextAlertEnableStatus (bool bTextAlertOnOff_);

    /**
     * Destructor
     */
    inline virtual  ~TextAlertEnableStatus();

    /**
     * Assignment operator
     */
    inline TextAlertEnableStatus& operator = (const TextAlertEnableStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TextAlertEnableStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TextAlertEnableStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TextAlertEnableStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TextAlertEnableStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bTextAlertOnOff"

    static const int kBTextAlertOnOff = 0;

    /**
     * Clears the field "bTextAlertOnOff".
     *
     * The field will be set to its default value. The hasBTextAlertOnOff()
     * method will return false.
     */
    inline void clearBTextAlertOnOff();

    /**
     * Checks whether the field "bTextAlertOnOff" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBTextAlertOnOff()). Otherwise it will return false.
     */
    inline bool hasBTextAlertOnOff () const;

    /**
     * Returns the value of the member "bTextAlertOnOff".
     *
     * Identifies if the Text Alert is On or Off.
     *
     * @return The value of the field "bTextAlertOnOff"
     */
    inline bool getBTextAlertOnOff () const;

    /**
     * Sets the value of the member "bTextAlertOnOff".
     *
     * Identifies if the Text Alert is On or Off.
     *
     * @param bTextAlertOnOff The value which will be set
     */
    inline void setBTextAlertOnOff (bool bTextAlertOnOff_);

    static const TextAlertEnableStatus &getDefaultInstance();

private:

    inline void set_has_bTextAlertOnOff ();

    inline void clear_has_bTextAlertOnOff ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bTextAlertOnOff;

};

/**
 * The pureSet message of the property "TextAlertEnable"
 * Provides the ability to turn the Text Alert On or Off.
 */
class TextAlertEnablePureSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TextAlertEnablePureSet ();

    /**
     * Copy constructor
     */
    inline  TextAlertEnablePureSet (const TextAlertEnablePureSet &rhs);

    /**
     * All fields constructor
     */
    inline  TextAlertEnablePureSet (bool bTextAlertOnOff_);

    /**
     * Destructor
     */
    inline virtual  ~TextAlertEnablePureSet();

    /**
     * Assignment operator
     */
    inline TextAlertEnablePureSet& operator = (const TextAlertEnablePureSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TextAlertEnablePureSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TextAlertEnablePureSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TextAlertEnablePureSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TextAlertEnablePureSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bTextAlertOnOff"

    static const int kBTextAlertOnOff = 0;

    /**
     * Clears the field "bTextAlertOnOff".
     *
     * The field will be set to its default value. The hasBTextAlertOnOff()
     * method will return false.
     */
    inline void clearBTextAlertOnOff();

    /**
     * Checks whether the field "bTextAlertOnOff" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBTextAlertOnOff()). Otherwise it will return false.
     */
    inline bool hasBTextAlertOnOff () const;

    /**
     * Returns the value of the member "bTextAlertOnOff".
     *
     * Identifies if the Text Alert is On or Off.
     *
     * @return The value of the field "bTextAlertOnOff"
     */
    inline bool getBTextAlertOnOff () const;

    /**
     * Sets the value of the member "bTextAlertOnOff".
     *
     * Identifies if the Text Alert is On or Off.
     *
     * @param bTextAlertOnOff The value which will be set
     */
    inline void setBTextAlertOnOff (bool bTextAlertOnOff_);

    static const TextAlertEnablePureSet &getDefaultInstance();

private:

    inline void set_has_bTextAlertOnOff ();

    inline void clear_has_bTextAlertOnOff ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bTextAlertOnOff;

};

/**
 * The error message of 'TextAlertEnable'
 */
class TextAlertEnableErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  TextAlertEnableErrorStructure ();

    /**
     * Copy constructor
     */
    inline  TextAlertEnableErrorStructure (const TextAlertEnableErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  TextAlertEnableErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~TextAlertEnableErrorStructure();

    /**
     * Assignment operator
     */
    inline TextAlertEnableErrorStructure& operator = (const TextAlertEnableErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TextAlertEnableErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TextAlertEnableErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TextAlertEnableErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TextAlertEnableErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const TextAlertEnableErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'TextAlertEnable'
 */
class TextAlertEnableError  : public ::asf::core::Payload {
public:

    enum TextAlertEnableErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  TextAlertEnableError ();

   /**
     * Copy constructor
     */
    inline  TextAlertEnableError (const TextAlertEnableError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~TextAlertEnableError();

    /**
     * Assigns a new value to this object.
     */
    inline TextAlertEnableError& operator = (const TextAlertEnableError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TextAlertEnableError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TextAlertEnableError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TextAlertEnableError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TextAlertEnableError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline TextAlertEnableError::TextAlertEnableErrorField getField () const;

    inline void setField(TextAlertEnableError::TextAlertEnableErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "TextAlertEnableErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "TextAlertEnableErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const TextAlertEnableErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline TextAlertEnableErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline TextAlertEnableErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (TextAlertEnableErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "TextAlertEnableErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const TextAlertEnableErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const TextAlertEnableError &getDefaultInstance();

private:

    inline void cloneData (const TextAlertEnableError& rhs);

    inline void deleteData ();

    TextAlertEnableErrorField __field;

    union {
        TextAlertEnableErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "EmailAlertEnable"
 * Provides the ability to turn the Email Alert On or Off.
 */
class EmailAlertEnableStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EmailAlertEnableStatus ();

    /**
     * Copy constructor
     */
    inline  EmailAlertEnableStatus (const EmailAlertEnableStatus &rhs);

    /**
     * All fields constructor
     */
    inline  EmailAlertEnableStatus (bool bEmailAlertOnOff_);

    /**
     * Destructor
     */
    inline virtual  ~EmailAlertEnableStatus();

    /**
     * Assignment operator
     */
    inline EmailAlertEnableStatus& operator = (const EmailAlertEnableStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EmailAlertEnableStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EmailAlertEnableStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EmailAlertEnableStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EmailAlertEnableStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bEmailAlertOnOff"

    static const int kBEmailAlertOnOff = 0;

    /**
     * Clears the field "bEmailAlertOnOff".
     *
     * The field will be set to its default value. The hasBEmailAlertOnOff()
     * method will return false.
     */
    inline void clearBEmailAlertOnOff();

    /**
     * Checks whether the field "bEmailAlertOnOff" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBEmailAlertOnOff()). Otherwise it will return false.
     */
    inline bool hasBEmailAlertOnOff () const;

    /**
     * Returns the value of the member "bEmailAlertOnOff".
     *
     * Identifies if the Email Alert is On or Off.
     *
     * @return The value of the field "bEmailAlertOnOff"
     */
    inline bool getBEmailAlertOnOff () const;

    /**
     * Sets the value of the member "bEmailAlertOnOff".
     *
     * Identifies if the Email Alert is On or Off.
     *
     * @param bEmailAlertOnOff The value which will be set
     */
    inline void setBEmailAlertOnOff (bool bEmailAlertOnOff_);

    static const EmailAlertEnableStatus &getDefaultInstance();

private:

    inline void set_has_bEmailAlertOnOff ();

    inline void clear_has_bEmailAlertOnOff ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bEmailAlertOnOff;

};

/**
 * The pureSet message of the property "EmailAlertEnable"
 * Provides the ability to turn the Email Alert On or Off.
 */
class EmailAlertEnablePureSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EmailAlertEnablePureSet ();

    /**
     * Copy constructor
     */
    inline  EmailAlertEnablePureSet (const EmailAlertEnablePureSet &rhs);

    /**
     * All fields constructor
     */
    inline  EmailAlertEnablePureSet (bool bEmailAlertOnOff_);

    /**
     * Destructor
     */
    inline virtual  ~EmailAlertEnablePureSet();

    /**
     * Assignment operator
     */
    inline EmailAlertEnablePureSet& operator = (const EmailAlertEnablePureSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EmailAlertEnablePureSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EmailAlertEnablePureSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EmailAlertEnablePureSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EmailAlertEnablePureSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bEmailAlertOnOff"

    static const int kBEmailAlertOnOff = 0;

    /**
     * Clears the field "bEmailAlertOnOff".
     *
     * The field will be set to its default value. The hasBEmailAlertOnOff()
     * method will return false.
     */
    inline void clearBEmailAlertOnOff();

    /**
     * Checks whether the field "bEmailAlertOnOff" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBEmailAlertOnOff()). Otherwise it will return false.
     */
    inline bool hasBEmailAlertOnOff () const;

    /**
     * Returns the value of the member "bEmailAlertOnOff".
     *
     * Identifies if the Email Alert is On or Off.
     *
     * @return The value of the field "bEmailAlertOnOff"
     */
    inline bool getBEmailAlertOnOff () const;

    /**
     * Sets the value of the member "bEmailAlertOnOff".
     *
     * Identifies if the Email Alert is On or Off.
     *
     * @param bEmailAlertOnOff The value which will be set
     */
    inline void setBEmailAlertOnOff (bool bEmailAlertOnOff_);

    static const EmailAlertEnablePureSet &getDefaultInstance();

private:

    inline void set_has_bEmailAlertOnOff ();

    inline void clear_has_bEmailAlertOnOff ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bEmailAlertOnOff;

};

/**
 * The error message of 'EmailAlertEnable'
 */
class EmailAlertEnableErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  EmailAlertEnableErrorStructure ();

    /**
     * Copy constructor
     */
    inline  EmailAlertEnableErrorStructure (const EmailAlertEnableErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  EmailAlertEnableErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~EmailAlertEnableErrorStructure();

    /**
     * Assignment operator
     */
    inline EmailAlertEnableErrorStructure& operator = (const EmailAlertEnableErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EmailAlertEnableErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EmailAlertEnableErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EmailAlertEnableErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EmailAlertEnableErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const EmailAlertEnableErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'EmailAlertEnable'
 */
class EmailAlertEnableError  : public ::asf::core::Payload {
public:

    enum EmailAlertEnableErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  EmailAlertEnableError ();

   /**
     * Copy constructor
     */
    inline  EmailAlertEnableError (const EmailAlertEnableError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~EmailAlertEnableError();

    /**
     * Assigns a new value to this object.
     */
    inline EmailAlertEnableError& operator = (const EmailAlertEnableError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EmailAlertEnableError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EmailAlertEnableError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EmailAlertEnableError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EmailAlertEnableError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline EmailAlertEnableError::EmailAlertEnableErrorField getField () const;

    inline void setField(EmailAlertEnableError::EmailAlertEnableErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "EmailAlertEnableErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "EmailAlertEnableErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const EmailAlertEnableErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline EmailAlertEnableErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline EmailAlertEnableErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (EmailAlertEnableErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "EmailAlertEnableErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const EmailAlertEnableErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const EmailAlertEnableError &getDefaultInstance();

private:

    inline void cloneData (const EmailAlertEnableError& rhs);

    inline void deleteData ();

    EmailAlertEnableErrorField __field;

    union {
        EmailAlertEnableErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "SaveSentText"
 * Provides the ability to enable or disable the saving of a copy of a sent text message in the sent folder.
 */
class SaveSentTextStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SaveSentTextStatus ();

    /**
     * Copy constructor
     */
    inline  SaveSentTextStatus (const SaveSentTextStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SaveSentTextStatus (bool bSaveSentTextOnOff_);

    /**
     * Destructor
     */
    inline virtual  ~SaveSentTextStatus();

    /**
     * Assignment operator
     */
    inline SaveSentTextStatus& operator = (const SaveSentTextStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SaveSentTextStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SaveSentTextStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SaveSentTextStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SaveSentTextStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bSaveSentTextOnOff"

    static const int kBSaveSentTextOnOff = 0;

    /**
     * Clears the field "bSaveSentTextOnOff".
     *
     * The field will be set to its default value. The hasBSaveSentTextOnOff()
     * method will return false.
     */
    inline void clearBSaveSentTextOnOff();

    /**
     * Checks whether the field "bSaveSentTextOnOff" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBSaveSentTextOnOff()). Otherwise it will return false.
     */
    inline bool hasBSaveSentTextOnOff () const;

    /**
     * Returns the value of the member "bSaveSentTextOnOff".
     *
     * Identifies if the saving of sent text messages is On or Off.
     *
     * @return The value of the field "bSaveSentTextOnOff"
     */
    inline bool getBSaveSentTextOnOff () const;

    /**
     * Sets the value of the member "bSaveSentTextOnOff".
     *
     * Identifies if the saving of sent text messages is On or Off.
     *
     * @param bSaveSentTextOnOff The value which will be set
     */
    inline void setBSaveSentTextOnOff (bool bSaveSentTextOnOff_);

    static const SaveSentTextStatus &getDefaultInstance();

private:

    inline void set_has_bSaveSentTextOnOff ();

    inline void clear_has_bSaveSentTextOnOff ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bSaveSentTextOnOff;

};

/**
 * The pureSet message of the property "SaveSentText"
 * Provides the ability to enable or disable the saving of a copy of a sent text message in the sent folder.
 */
class SaveSentTextPureSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SaveSentTextPureSet ();

    /**
     * Copy constructor
     */
    inline  SaveSentTextPureSet (const SaveSentTextPureSet &rhs);

    /**
     * All fields constructor
     */
    inline  SaveSentTextPureSet (bool bSaveSentTextOnOff_);

    /**
     * Destructor
     */
    inline virtual  ~SaveSentTextPureSet();

    /**
     * Assignment operator
     */
    inline SaveSentTextPureSet& operator = (const SaveSentTextPureSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SaveSentTextPureSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SaveSentTextPureSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SaveSentTextPureSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SaveSentTextPureSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bSaveSentTextOnOff"

    static const int kBSaveSentTextOnOff = 0;

    /**
     * Clears the field "bSaveSentTextOnOff".
     *
     * The field will be set to its default value. The hasBSaveSentTextOnOff()
     * method will return false.
     */
    inline void clearBSaveSentTextOnOff();

    /**
     * Checks whether the field "bSaveSentTextOnOff" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBSaveSentTextOnOff()). Otherwise it will return false.
     */
    inline bool hasBSaveSentTextOnOff () const;

    /**
     * Returns the value of the member "bSaveSentTextOnOff".
     *
     * Identifies if the saving of sent text messages is On or Off.
     *
     * @return The value of the field "bSaveSentTextOnOff"
     */
    inline bool getBSaveSentTextOnOff () const;

    /**
     * Sets the value of the member "bSaveSentTextOnOff".
     *
     * Identifies if the saving of sent text messages is On or Off.
     *
     * @param bSaveSentTextOnOff The value which will be set
     */
    inline void setBSaveSentTextOnOff (bool bSaveSentTextOnOff_);

    static const SaveSentTextPureSet &getDefaultInstance();

private:

    inline void set_has_bSaveSentTextOnOff ();

    inline void clear_has_bSaveSentTextOnOff ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bSaveSentTextOnOff;

};

/**
 * The error message of 'SaveSentText'
 */
class SaveSentTextErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SaveSentTextErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SaveSentTextErrorStructure (const SaveSentTextErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SaveSentTextErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~SaveSentTextErrorStructure();

    /**
     * Assignment operator
     */
    inline SaveSentTextErrorStructure& operator = (const SaveSentTextErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SaveSentTextErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SaveSentTextErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SaveSentTextErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SaveSentTextErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const SaveSentTextErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'SaveSentText'
 */
class SaveSentTextError  : public ::asf::core::Payload {
public:

    enum SaveSentTextErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SaveSentTextError ();

   /**
     * Copy constructor
     */
    inline  SaveSentTextError (const SaveSentTextError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SaveSentTextError();

    /**
     * Assigns a new value to this object.
     */
    inline SaveSentTextError& operator = (const SaveSentTextError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SaveSentTextError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SaveSentTextError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SaveSentTextError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SaveSentTextError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SaveSentTextError::SaveSentTextErrorField getField () const;

    inline void setField(SaveSentTextError::SaveSentTextErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SaveSentTextErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SaveSentTextErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SaveSentTextErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SaveSentTextErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SaveSentTextErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SaveSentTextErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SaveSentTextErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SaveSentTextErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SaveSentTextError &getDefaultInstance();

private:

    inline void cloneData (const SaveSentTextError& rhs);

    inline void deleteData ();

    SaveSentTextErrorField __field;

    union {
        SaveSentTextErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "SaveSentEmail"
 * Provides the ability to enable or disable the saving of a copy of a sent email message in the sent folder.
 */
class SaveSentEmailStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SaveSentEmailStatus ();

    /**
     * Copy constructor
     */
    inline  SaveSentEmailStatus (const SaveSentEmailStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SaveSentEmailStatus (bool bSaveSentEmailOnOff_);

    /**
     * Destructor
     */
    inline virtual  ~SaveSentEmailStatus();

    /**
     * Assignment operator
     */
    inline SaveSentEmailStatus& operator = (const SaveSentEmailStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SaveSentEmailStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SaveSentEmailStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SaveSentEmailStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SaveSentEmailStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bSaveSentEmailOnOff"

    static const int kBSaveSentEmailOnOff = 0;

    /**
     * Clears the field "bSaveSentEmailOnOff".
     *
     * The field will be set to its default value. The hasBSaveSentEmailOnOff()
     * method will return false.
     */
    inline void clearBSaveSentEmailOnOff();

    /**
     * Checks whether the field "bSaveSentEmailOnOff" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBSaveSentEmailOnOff()). Otherwise it will return false.
     */
    inline bool hasBSaveSentEmailOnOff () const;

    /**
     * Returns the value of the member "bSaveSentEmailOnOff".
     *
     * Identifies if the saving of sent email messages is On or Off.
     *
     * @return The value of the field "bSaveSentEmailOnOff"
     */
    inline bool getBSaveSentEmailOnOff () const;

    /**
     * Sets the value of the member "bSaveSentEmailOnOff".
     *
     * Identifies if the saving of sent email messages is On or Off.
     *
     * @param bSaveSentEmailOnOff The value which will be set
     */
    inline void setBSaveSentEmailOnOff (bool bSaveSentEmailOnOff_);

    static const SaveSentEmailStatus &getDefaultInstance();

private:

    inline void set_has_bSaveSentEmailOnOff ();

    inline void clear_has_bSaveSentEmailOnOff ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bSaveSentEmailOnOff;

};

/**
 * The pureSet message of the property "SaveSentEmail"
 * Provides the ability to enable or disable the saving of a copy of a sent email message in the sent folder.
 */
class SaveSentEmailPureSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SaveSentEmailPureSet ();

    /**
     * Copy constructor
     */
    inline  SaveSentEmailPureSet (const SaveSentEmailPureSet &rhs);

    /**
     * All fields constructor
     */
    inline  SaveSentEmailPureSet (bool bSaveSentEmailOnOff_);

    /**
     * Destructor
     */
    inline virtual  ~SaveSentEmailPureSet();

    /**
     * Assignment operator
     */
    inline SaveSentEmailPureSet& operator = (const SaveSentEmailPureSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SaveSentEmailPureSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SaveSentEmailPureSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SaveSentEmailPureSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SaveSentEmailPureSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bSaveSentEmailOnOff"

    static const int kBSaveSentEmailOnOff = 0;

    /**
     * Clears the field "bSaveSentEmailOnOff".
     *
     * The field will be set to its default value. The hasBSaveSentEmailOnOff()
     * method will return false.
     */
    inline void clearBSaveSentEmailOnOff();

    /**
     * Checks whether the field "bSaveSentEmailOnOff" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBSaveSentEmailOnOff()). Otherwise it will return false.
     */
    inline bool hasBSaveSentEmailOnOff () const;

    /**
     * Returns the value of the member "bSaveSentEmailOnOff".
     *
     * Identifies if the saving of sent email messages is On or Off.
     *
     * @return The value of the field "bSaveSentEmailOnOff"
     */
    inline bool getBSaveSentEmailOnOff () const;

    /**
     * Sets the value of the member "bSaveSentEmailOnOff".
     *
     * Identifies if the saving of sent email messages is On or Off.
     *
     * @param bSaveSentEmailOnOff The value which will be set
     */
    inline void setBSaveSentEmailOnOff (bool bSaveSentEmailOnOff_);

    static const SaveSentEmailPureSet &getDefaultInstance();

private:

    inline void set_has_bSaveSentEmailOnOff ();

    inline void clear_has_bSaveSentEmailOnOff ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bSaveSentEmailOnOff;

};

/**
 * The error message of 'SaveSentEmail'
 */
class SaveSentEmailErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SaveSentEmailErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SaveSentEmailErrorStructure (const SaveSentEmailErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SaveSentEmailErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~SaveSentEmailErrorStructure();

    /**
     * Assignment operator
     */
    inline SaveSentEmailErrorStructure& operator = (const SaveSentEmailErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SaveSentEmailErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SaveSentEmailErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SaveSentEmailErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SaveSentEmailErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const SaveSentEmailErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'SaveSentEmail'
 */
class SaveSentEmailError  : public ::asf::core::Payload {
public:

    enum SaveSentEmailErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SaveSentEmailError ();

   /**
     * Copy constructor
     */
    inline  SaveSentEmailError (const SaveSentEmailError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SaveSentEmailError();

    /**
     * Assigns a new value to this object.
     */
    inline SaveSentEmailError& operator = (const SaveSentEmailError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SaveSentEmailError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SaveSentEmailError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SaveSentEmailError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SaveSentEmailError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SaveSentEmailError::SaveSentEmailErrorField getField () const;

    inline void setField(SaveSentEmailError::SaveSentEmailErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SaveSentEmailErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SaveSentEmailErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SaveSentEmailErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SaveSentEmailErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SaveSentEmailErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SaveSentEmailErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SaveSentEmailErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SaveSentEmailErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SaveSentEmailError &getDefaultInstance();

private:

    inline void cloneData (const SaveSentEmailError& rhs);

    inline void deleteData ();

    SaveSentEmailErrorField __field;

    union {
        SaveSentEmailErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "Allocate"
 * The Allocate method causes the source to occupy bandwidth for streaming data.
 */
class AllocateStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AllocateStart ();

    /**
     * Copy constructor
     */
    inline  AllocateStart (const AllocateStart &rhs);

    /**
     * All fields constructor
     */
    inline  AllocateStart (uint8 u8SourceNr_);

    /**
     * Destructor
     */
    inline virtual  ~AllocateStart();

    /**
     * Assignment operator
     */
    inline AllocateStart& operator = (const AllocateStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AllocateStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AllocateStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AllocateStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AllocateStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8SourceNr"

    static const int kU8SourceNr = 0;

    /**
     * Clears the field "u8SourceNr".
     *
     * The field will be set to its default value. The hasU8SourceNr()
     * method will return false.
     */
    inline void clearU8SourceNr();

    /**
     * Checks whether the field "u8SourceNr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SourceNr()). Otherwise it will return false.
     */
    inline bool hasU8SourceNr () const;

    /**
     * Returns the value of the member "u8SourceNr".
     *
     * Number of a data source (within one FBlock there can be more than one), for example, 0x01 for the first source.
     *
     * @return The value of the field "u8SourceNr"
     */
    inline uint8 getU8SourceNr () const;

    /**
     * Sets the value of the member "u8SourceNr".
     *
     * Number of a data source (within one FBlock there can be more than one), for example, 0x01 for the first source.
     *
     * @param u8SourceNr The value which will be set
     */
    inline void setU8SourceNr (uint8 u8SourceNr_);

    static const AllocateStart &getDefaultInstance();

private:

    inline void set_has_u8SourceNr ();

    inline void clear_has_u8SourceNr ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8SourceNr;

};

/**
 * The result message of the method "Allocate"
 * The Allocate method causes the source to occupy bandwidth for streaming data.
 */
class AllocateResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AllocateResult ();

    /**
     * Copy constructor
     */
    inline  AllocateResult (const AllocateResult &rhs);

    /**
     * All fields constructor
     */
    inline  AllocateResult (uint8 u8SourceNr_, uint16 u16BlockWidth_, uint16 u16ConnectionLabel_);

    /**
     * Destructor
     */
    inline virtual  ~AllocateResult();

    /**
     * Assignment operator
     */
    inline AllocateResult& operator = (const AllocateResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AllocateResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AllocateResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AllocateResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AllocateResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8SourceNr"

    static const int kU8SourceNr = 0;

    /**
     * Clears the field "u8SourceNr".
     *
     * The field will be set to its default value. The hasU8SourceNr()
     * method will return false.
     */
    inline void clearU8SourceNr();

    /**
     * Checks whether the field "u8SourceNr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SourceNr()). Otherwise it will return false.
     */
    inline bool hasU8SourceNr () const;

    /**
     * Returns the value of the member "u8SourceNr".
     *
     * Number of a data source (within one FBlock there can be more than one), for example, 0x01 for the first source.
     *
     * @return The value of the field "u8SourceNr"
     */
    inline uint8 getU8SourceNr () const;

    /**
     * Sets the value of the member "u8SourceNr".
     *
     * Number of a data source (within one FBlock there can be more than one), for example, 0x01 for the first source.
     *
     * @param u8SourceNr The value which will be set
     */
    inline void setU8SourceNr (uint8 u8SourceNr_);

    // API of field "u16BlockWidth"

    static const int kU16BlockWidth = 1;

    /**
     * Clears the field "u16BlockWidth".
     *
     * The field will be set to its default value. The hasU16BlockWidth()
     * method will return false.
     */
    inline void clearU16BlockWidth();

    /**
     * Checks whether the field "u16BlockWidth" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16BlockWidth()). Otherwise it will return false.
     */
    inline bool hasU16BlockWidth () const;

    /**
     * Returns the value of the member "u16BlockWidth".
     *
     * Number of transferred bytes per MOST frame.  If no bandwidth was allocated yet, 0x0000 must be used.  Otherwise, 0x0001 - 0x0075 is used as specified by MOST50.
     *
     * @return The value of the field "u16BlockWidth"
     */
    inline uint16 getU16BlockWidth () const;

    /**
     * Sets the value of the member "u16BlockWidth".
     *
     * Number of transferred bytes per MOST frame.  If no bandwidth was allocated yet, 0x0000 must be used.  Otherwise, 0x0001 - 0x0075 is used as specified by MOST50.
     *
     * @param u16BlockWidth The value which will be set
     */
    inline void setU16BlockWidth (uint16 u16BlockWidth_);

    // API of field "u16ConnectionLabel"

    static const int kU16ConnectionLabel = 2;

    /**
     * Clears the field "u16ConnectionLabel".
     *
     * The field will be set to its default value. The hasU16ConnectionLabel()
     * method will return false.
     */
    inline void clearU16ConnectionLabel();

    /**
     * Checks whether the field "u16ConnectionLabel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ConnectionLabel()). Otherwise it will return false.
     */
    inline bool hasU16ConnectionLabel () const;

    /**
     * Returns the value of the member "u16ConnectionLabel".
     *
     * Connection identifier. If no bandwidth is allocated, 0x0000 must be used.  Otherwise, 0x000B - 0x007F is used as specified by MOST50.
     *
     * @return The value of the field "u16ConnectionLabel"
     */
    inline uint16 getU16ConnectionLabel () const;

    /**
     * Sets the value of the member "u16ConnectionLabel".
     *
     * Connection identifier. If no bandwidth is allocated, 0x0000 must be used.  Otherwise, 0x000B - 0x007F is used as specified by MOST50.
     *
     * @param u16ConnectionLabel The value which will be set
     */
    inline void setU16ConnectionLabel (uint16 u16ConnectionLabel_);

    static const AllocateResult &getDefaultInstance();

private:

    inline void set_has_u8SourceNr ();

    inline void clear_has_u8SourceNr ();

    inline void set_has_u16BlockWidth ();

    inline void clear_has_u16BlockWidth ();

    inline void set_has_u16ConnectionLabel ();

    inline void clear_has_u16ConnectionLabel ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _u8SourceNr;

    uint16 _u16BlockWidth;

    uint16 _u16ConnectionLabel;

};

/**
 * The error message of 'Allocate'
 */
class AllocateErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  AllocateErrorStructure ();

    /**
     * Copy constructor
     */
    inline  AllocateErrorStructure (const AllocateErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  AllocateErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~AllocateErrorStructure();

    /**
     * Assignment operator
     */
    inline AllocateErrorStructure& operator = (const AllocateErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AllocateErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AllocateErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AllocateErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AllocateErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * (Refer to the MOST Specification, section "Structure of MOST Messages: OPType")
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * (Refer to the MOST Specification, section "Structure of MOST Messages: OPType")
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * (Refer to the MOST Specification, section "Structure of MOST Messages: OPType")
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * (Refer to the MOST Specification, section "Structure of MOST Messages: OPType")
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const AllocateErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'Allocate'
 */
class AllocateError  : public ::asf::core::Payload {
public:

    enum AllocateErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  AllocateError ();

   /**
     * Copy constructor
     */
    inline  AllocateError (const AllocateError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~AllocateError();

    /**
     * Assigns a new value to this object.
     */
    inline AllocateError& operator = (const AllocateError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AllocateError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AllocateError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AllocateError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AllocateError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline AllocateError::AllocateErrorField getField () const;

    inline void setField(AllocateError::AllocateErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "AllocateErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "AllocateErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const AllocateErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline AllocateErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline AllocateErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (AllocateErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "AllocateErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const AllocateErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const AllocateError &getDefaultInstance();

private:

    inline void cloneData (const AllocateError& rhs);

    inline void deleteData ();

    AllocateErrorField __field;

    union {
        AllocateErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "DeAllocate"
 * The method DeAllocate causes the source to free occupied Streaming bandwidth.
 */
class DeAllocateStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeAllocateStart ();

    /**
     * Copy constructor
     */
    inline  DeAllocateStart (const DeAllocateStart &rhs);

    /**
     * All fields constructor
     */
    inline  DeAllocateStart (uint8 u8SourceNr_);

    /**
     * Destructor
     */
    inline virtual  ~DeAllocateStart();

    /**
     * Assignment operator
     */
    inline DeAllocateStart& operator = (const DeAllocateStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeAllocateStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeAllocateStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeAllocateStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeAllocateStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8SourceNr"

    static const int kU8SourceNr = 0;

    /**
     * Clears the field "u8SourceNr".
     *
     * The field will be set to its default value. The hasU8SourceNr()
     * method will return false.
     */
    inline void clearU8SourceNr();

    /**
     * Checks whether the field "u8SourceNr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SourceNr()). Otherwise it will return false.
     */
    inline bool hasU8SourceNr () const;

    /**
     * Returns the value of the member "u8SourceNr".
     *
     * Number of a data source (within one FBlock there can be more than one), for example, 0x01 for the first source.
     *
     * @return The value of the field "u8SourceNr"
     */
    inline uint8 getU8SourceNr () const;

    /**
     * Sets the value of the member "u8SourceNr".
     *
     * Number of a data source (within one FBlock there can be more than one), for example, 0x01 for the first source.
     *
     * @param u8SourceNr The value which will be set
     */
    inline void setU8SourceNr (uint8 u8SourceNr_);

    static const DeAllocateStart &getDefaultInstance();

private:

    inline void set_has_u8SourceNr ();

    inline void clear_has_u8SourceNr ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8SourceNr;

};

/**
 * The result message of the method "DeAllocate"
 * The method DeAllocate causes the source to free occupied Streaming bandwidth.
 */
class DeAllocateResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeAllocateResult ();

    /**
     * Copy constructor
     */
    inline  DeAllocateResult (const DeAllocateResult &rhs);

    /**
     * All fields constructor
     */
    inline  DeAllocateResult (uint8 u8SourceNr_);

    /**
     * Destructor
     */
    inline virtual  ~DeAllocateResult();

    /**
     * Assignment operator
     */
    inline DeAllocateResult& operator = (const DeAllocateResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeAllocateResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeAllocateResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeAllocateResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeAllocateResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8SourceNr"

    static const int kU8SourceNr = 0;

    /**
     * Clears the field "u8SourceNr".
     *
     * The field will be set to its default value. The hasU8SourceNr()
     * method will return false.
     */
    inline void clearU8SourceNr();

    /**
     * Checks whether the field "u8SourceNr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SourceNr()). Otherwise it will return false.
     */
    inline bool hasU8SourceNr () const;

    /**
     * Returns the value of the member "u8SourceNr".
     *
     * Number of a data source (within one FBlock there can be more than one), for example, 0x01 for the first source.
     *
     * @return The value of the field "u8SourceNr"
     */
    inline uint8 getU8SourceNr () const;

    /**
     * Sets the value of the member "u8SourceNr".
     *
     * Number of a data source (within one FBlock there can be more than one), for example, 0x01 for the first source.
     *
     * @param u8SourceNr The value which will be set
     */
    inline void setU8SourceNr (uint8 u8SourceNr_);

    static const DeAllocateResult &getDefaultInstance();

private:

    inline void set_has_u8SourceNr ();

    inline void clear_has_u8SourceNr ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8SourceNr;

};

/**
 * The error message of 'DeAllocate'
 */
class DeAllocateErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DeAllocateErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DeAllocateErrorStructure (const DeAllocateErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DeAllocateErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~DeAllocateErrorStructure();

    /**
     * Assignment operator
     */
    inline DeAllocateErrorStructure& operator = (const DeAllocateErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeAllocateErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeAllocateErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeAllocateErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeAllocateErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * (Refer to the MOST Specification, section "Structure of MOST Messages: OPType")
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * (Refer to the MOST Specification, section "Structure of MOST Messages: OPType")
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * (Refer to the MOST Specification, section "Structure of MOST Messages: OPType")
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * (Refer to the MOST Specification, section "Structure of MOST Messages: OPType")
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const DeAllocateErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'DeAllocate'
 */
class DeAllocateError  : public ::asf::core::Payload {
public:

    enum DeAllocateErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DeAllocateError ();

   /**
     * Copy constructor
     */
    inline  DeAllocateError (const DeAllocateError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DeAllocateError();

    /**
     * Assigns a new value to this object.
     */
    inline DeAllocateError& operator = (const DeAllocateError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeAllocateError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeAllocateError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeAllocateError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeAllocateError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DeAllocateError::DeAllocateErrorField getField () const;

    inline void setField(DeAllocateError::DeAllocateErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DeAllocateErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DeAllocateErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DeAllocateErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DeAllocateErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DeAllocateErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DeAllocateErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DeAllocateErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DeAllocateErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DeAllocateError &getDefaultInstance();

private:

    inline void cloneData (const DeAllocateError& rhs);

    inline void deleteData ();

    DeAllocateErrorField __field;

    union {
        DeAllocateErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SourceActivity"
 * This method controls the activity of a source.
 * Note that the PAUSE state is not allowed for the General Motors implementation and is thus not defined as an allowed state within the enumeration.
 */
class SourceActivityStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SourceActivityStart ();

    /**
     * Copy constructor
     */
    inline  SourceActivityStart (const SourceActivityStart &rhs);

    /**
     * All fields constructor
     */
    inline  SourceActivityStart (uint8 u8SourceNr_, ::most_Src_fi_types::T_e8_SrcActivity e8Activity_);

    /**
     * Destructor
     */
    inline virtual  ~SourceActivityStart();

    /**
     * Assignment operator
     */
    inline SourceActivityStart& operator = (const SourceActivityStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SourceActivityStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SourceActivityStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SourceActivityStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SourceActivityStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8SourceNr"

    static const int kU8SourceNr = 0;

    /**
     * Clears the field "u8SourceNr".
     *
     * The field will be set to its default value. The hasU8SourceNr()
     * method will return false.
     */
    inline void clearU8SourceNr();

    /**
     * Checks whether the field "u8SourceNr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SourceNr()). Otherwise it will return false.
     */
    inline bool hasU8SourceNr () const;

    /**
     * Returns the value of the member "u8SourceNr".
     *
     * Number of a data source (within one FBlock there can be more than one), for example, 0x01 for the first source.
     *
     * @return The value of the field "u8SourceNr"
     */
    inline uint8 getU8SourceNr () const;

    /**
     * Sets the value of the member "u8SourceNr".
     *
     * Number of a data source (within one FBlock there can be more than one), for example, 0x01 for the first source.
     *
     * @param u8SourceNr The value which will be set
     */
    inline void setU8SourceNr (uint8 u8SourceNr_);

    // API of field "e8Activity"

    static const int kE8Activity = 1;

    /**
     * Clears the field "e8Activity".
     *
     * The field will be set to its default value. The hasE8Activity()
     * method will return false.
     */
    inline void clearE8Activity();

    /**
     * Checks whether the field "e8Activity" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Activity()). Otherwise it will return false.
     */
    inline bool hasE8Activity () const;

    /**
     * Returns the value of the member "e8Activity".
     *
     * Through parameter Activity, streaming data transfer can be started or stopped. Note that the paused state is not allowed in the General Motors MOST implementation.
     *
     * @return The value of the field "e8Activity"
     */
    inline ::most_Src_fi_types::T_e8_SrcActivity getE8Activity () const;

    /**
     * Sets the value of the member "e8Activity".
     *
     * Through parameter Activity, streaming data transfer can be started or stopped. Note that the paused state is not allowed in the General Motors MOST implementation.
     *
     * @param e8Activity The value which will be set
     */
    inline void setE8Activity (::most_Src_fi_types::T_e8_SrcActivity e8Activity_);

    static const SourceActivityStart &getDefaultInstance();

private:

    inline void set_has_u8SourceNr ();

    inline void clear_has_u8SourceNr ();

    inline void set_has_e8Activity ();

    inline void clear_has_e8Activity ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8SourceNr;

    ::most_Src_fi_types::T_e8_SrcActivity _e8Activity;

};

/**
 * The result message of the method "SourceActivity"
 * This method controls the activity of a source.
 * Note that the PAUSE state is not allowed for the General Motors implementation and is thus not defined as an allowed state within the enumeration.
 */
class SourceActivityResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SourceActivityResult ();

    /**
     * Copy constructor
     */
    inline  SourceActivityResult (const SourceActivityResult &rhs);

    /**
     * All fields constructor
     */
    inline  SourceActivityResult (uint8 u8SourceNr_, ::most_Src_fi_types::T_e8_SrcActivity e8Activity_);

    /**
     * Destructor
     */
    inline virtual  ~SourceActivityResult();

    /**
     * Assignment operator
     */
    inline SourceActivityResult& operator = (const SourceActivityResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SourceActivityResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SourceActivityResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SourceActivityResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SourceActivityResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8SourceNr"

    static const int kU8SourceNr = 0;

    /**
     * Clears the field "u8SourceNr".
     *
     * The field will be set to its default value. The hasU8SourceNr()
     * method will return false.
     */
    inline void clearU8SourceNr();

    /**
     * Checks whether the field "u8SourceNr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SourceNr()). Otherwise it will return false.
     */
    inline bool hasU8SourceNr () const;

    /**
     * Returns the value of the member "u8SourceNr".
     *
     * Number of a data source (within one FBlock there can be more than one), for example, 0x01 for the first source.
     *
     * @return The value of the field "u8SourceNr"
     */
    inline uint8 getU8SourceNr () const;

    /**
     * Sets the value of the member "u8SourceNr".
     *
     * Number of a data source (within one FBlock there can be more than one), for example, 0x01 for the first source.
     *
     * @param u8SourceNr The value which will be set
     */
    inline void setU8SourceNr (uint8 u8SourceNr_);

    // API of field "e8Activity"

    static const int kE8Activity = 1;

    /**
     * Clears the field "e8Activity".
     *
     * The field will be set to its default value. The hasE8Activity()
     * method will return false.
     */
    inline void clearE8Activity();

    /**
     * Checks whether the field "e8Activity" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Activity()). Otherwise it will return false.
     */
    inline bool hasE8Activity () const;

    /**
     * Returns the value of the member "e8Activity".
     *
     * Through parameter Activity, streaming data transfer can be started or stopped. Note that the paused state is not allowed in the General Motors MOST implementation.
     *
     * @return The value of the field "e8Activity"
     */
    inline ::most_Src_fi_types::T_e8_SrcActivity getE8Activity () const;

    /**
     * Sets the value of the member "e8Activity".
     *
     * Through parameter Activity, streaming data transfer can be started or stopped. Note that the paused state is not allowed in the General Motors MOST implementation.
     *
     * @param e8Activity The value which will be set
     */
    inline void setE8Activity (::most_Src_fi_types::T_e8_SrcActivity e8Activity_);

    static const SourceActivityResult &getDefaultInstance();

private:

    inline void set_has_u8SourceNr ();

    inline void clear_has_u8SourceNr ();

    inline void set_has_e8Activity ();

    inline void clear_has_e8Activity ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8SourceNr;

    ::most_Src_fi_types::T_e8_SrcActivity _e8Activity;

};

/**
 * The error message of 'SourceActivity'
 */
class SourceActivityErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SourceActivityErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SourceActivityErrorStructure (const SourceActivityErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SourceActivityErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~SourceActivityErrorStructure();

    /**
     * Assignment operator
     */
    inline SourceActivityErrorStructure& operator = (const SourceActivityErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SourceActivityErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SourceActivityErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SourceActivityErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SourceActivityErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * (Refer to the MOST Specification, section "Structure of MOST Messages: OPType")
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * (Refer to the MOST Specification, section "Structure of MOST Messages: OPType")
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * (Refer to the MOST Specification, section "Structure of MOST Messages: OPType")
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * (Refer to the MOST Specification, section "Structure of MOST Messages: OPType")
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const SourceActivityErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'SourceActivity'
 */
class SourceActivityError  : public ::asf::core::Payload {
public:

    enum SourceActivityErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SourceActivityError ();

   /**
     * Copy constructor
     */
    inline  SourceActivityError (const SourceActivityError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SourceActivityError();

    /**
     * Assigns a new value to this object.
     */
    inline SourceActivityError& operator = (const SourceActivityError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SourceActivityError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SourceActivityError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SourceActivityError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SourceActivityError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SourceActivityError::SourceActivityErrorField getField () const;

    inline void setField(SourceActivityError::SourceActivityErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SourceActivityErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SourceActivityErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SourceActivityErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SourceActivityErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SourceActivityErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SourceActivityErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SourceActivityErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SourceActivityErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SourceActivityError &getDefaultInstance();

private:

    inline void cloneData (const SourceActivityError& rhs);

    inline void deleteData ();

    SourceActivityErrorField __field;

    union {
        SourceActivityErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "CreateMessageList"
 * Creates a message list of a particular type and returns a ListHandle to the caller.  Slices of the list can then be accessed via RequestMessageListSlice.
 * When the folder type is Conversation, slices of the list could be accessed via RequestSliceConversationList. Changes to the list are notified via the MessageListChanged property.
 */
class CreateMessageListStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CreateMessageListStart ();

    /**
     * Copy constructor
     */
    inline  CreateMessageListStart (const CreateMessageListStart &rhs);

    /**
     * All fields constructor
     */
    inline  CreateMessageListStart (uint8 u8DeviceHandle_, ::most_Msg_fi_types::T_e8_MsgFolderType e8FolderType_, uint32 u32FolderHandle_, ::most_Msg_fi_types::T_e8_MsgMessageListType e8MessageListType_, ::most_Msg_fi_types::T_e8_MsgMessageListSortType e8MessageListSortType_, ::most_Msg_fi_types::T_e8_MsgMessageListFilterType e8MessageListFilterType_);

    /**
     * Destructor
     */
    inline virtual  ~CreateMessageListStart();

    /**
     * Assignment operator
     */
    inline CreateMessageListStart& operator = (const CreateMessageListStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreateMessageListStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreateMessageListStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreateMessageListStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreateMessageListStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "e8FolderType"

    static const int kE8FolderType = 1;

    /**
     * Clears the field "e8FolderType".
     *
     * The field will be set to its default value. The hasE8FolderType()
     * method will return false.
     */
    inline void clearE8FolderType();

    /**
     * Checks whether the field "e8FolderType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8FolderType()). Otherwise it will return false.
     */
    inline bool hasE8FolderType () const;

    /**
     * Returns the value of the member "e8FolderType".
     *
     * Defines the type of folder: Inbox, Deleted, Drafts, Sent, User defined, and inaccessible.
     * The user defined folders require the FolderName to identify the name of the folder.
     * The inaccessible folders are cannot be accessed from the vehicle.
     *
     * @return The value of the field "e8FolderType"
     */
    inline ::most_Msg_fi_types::T_e8_MsgFolderType getE8FolderType () const;

    /**
     * Sets the value of the member "e8FolderType".
     *
     * Defines the type of folder: Inbox, Deleted, Drafts, Sent, User defined, and inaccessible.
     * The user defined folders require the FolderName to identify the name of the folder.
     * The inaccessible folders are cannot be accessed from the vehicle.
     *
     * @param e8FolderType The value which will be set
     */
    inline void setE8FolderType (::most_Msg_fi_types::T_e8_MsgFolderType e8FolderType_);

    // API of field "u32FolderHandle"

    static const int kU32FolderHandle = 2;

    /**
     * Clears the field "u32FolderHandle".
     *
     * The field will be set to its default value. The hasU32FolderHandle()
     * method will return false.
     */
    inline void clearU32FolderHandle();

    /**
     * Checks whether the field "u32FolderHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32FolderHandle()). Otherwise it will return false.
     */
    inline bool hasU32FolderHandle () const;

    /**
     * Returns the value of the member "u32FolderHandle".
     *
     * This is the unique handle for a particular folder.
     *
     * @return The value of the field "u32FolderHandle"
     */
    inline uint32 getU32FolderHandle () const;

    /**
     * Sets the value of the member "u32FolderHandle".
     *
     * This is the unique handle for a particular folder.
     *
     * @param u32FolderHandle The value which will be set
     */
    inline void setU32FolderHandle (uint32 u32FolderHandle_);

    // API of field "e8MessageListType"

    static const int kE8MessageListType = 3;

    /**
     * Clears the field "e8MessageListType".
     *
     * The field will be set to its default value. The hasE8MessageListType()
     * method will return false.
     */
    inline void clearE8MessageListType();

    /**
     * Checks whether the field "e8MessageListType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MessageListType()). Otherwise it will return false.
     */
    inline bool hasE8MessageListType () const;

    /**
     * Returns the value of the member "e8MessageListType".
     *
     * Identifies the type of message list: SMS/MMS or Email
     *
     * @return The value of the field "e8MessageListType"
     */
    inline ::most_Msg_fi_types::T_e8_MsgMessageListType getE8MessageListType () const;

    /**
     * Sets the value of the member "e8MessageListType".
     *
     * Identifies the type of message list: SMS/MMS or Email
     *
     * @param e8MessageListType The value which will be set
     */
    inline void setE8MessageListType (::most_Msg_fi_types::T_e8_MsgMessageListType e8MessageListType_);

    // API of field "e8MessageListSortType"

    static const int kE8MessageListSortType = 4;

    /**
     * Clears the field "e8MessageListSortType".
     *
     * The field will be set to its default value. The hasE8MessageListSortType()
     * method will return false.
     */
    inline void clearE8MessageListSortType();

    /**
     * Checks whether the field "e8MessageListSortType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MessageListSortType()). Otherwise it will return false.
     */
    inline bool hasE8MessageListSortType () const;

    /**
     * Returns the value of the member "e8MessageListSortType".
     *
     * Passed in CreateMessageList to set the sort order of a created list.
     * Notes:
     * <item>If the parent folder has FolderType=MSG_FOLDER_SENT, then the LastName and FirstName options refer to the first receipient in the 'To' list of the message.</item>
     * <item>The 'Sender Address' referenced in the description of the enum values refers to either an email address or SMS number, etc. depending upon the specific type of each message.</item>
     *
     * @return The value of the field "e8MessageListSortType"
     */
    inline ::most_Msg_fi_types::T_e8_MsgMessageListSortType getE8MessageListSortType () const;

    /**
     * Sets the value of the member "e8MessageListSortType".
     *
     * Passed in CreateMessageList to set the sort order of a created list.
     * Notes:
     * <item>If the parent folder has FolderType=MSG_FOLDER_SENT, then the LastName and FirstName options refer to the first receipient in the 'To' list of the message.</item>
     * <item>The 'Sender Address' referenced in the description of the enum values refers to either an email address or SMS number, etc. depending upon the specific type of each message.</item>
     *
     * @param e8MessageListSortType The value which will be set
     */
    inline void setE8MessageListSortType (::most_Msg_fi_types::T_e8_MsgMessageListSortType e8MessageListSortType_);

    // API of field "e8MessageListFilterType"

    static const int kE8MessageListFilterType = 5;

    /**
     * Clears the field "e8MessageListFilterType".
     *
     * The field will be set to its default value. The hasE8MessageListFilterType()
     * method will return false.
     */
    inline void clearE8MessageListFilterType();

    /**
     * Checks whether the field "e8MessageListFilterType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MessageListFilterType()). Otherwise it will return false.
     */
    inline bool hasE8MessageListFilterType () const;

    /**
     * Returns the value of the member "e8MessageListFilterType".
     *
     * Passed in CreateMessageList to filter a subset of the messages in a particular folder.
     *
     * @return The value of the field "e8MessageListFilterType"
     */
    inline ::most_Msg_fi_types::T_e8_MsgMessageListFilterType getE8MessageListFilterType () const;

    /**
     * Sets the value of the member "e8MessageListFilterType".
     *
     * Passed in CreateMessageList to filter a subset of the messages in a particular folder.
     *
     * @param e8MessageListFilterType The value which will be set
     */
    inline void setE8MessageListFilterType (::most_Msg_fi_types::T_e8_MsgMessageListFilterType e8MessageListFilterType_);

    static const CreateMessageListStart &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_e8FolderType ();

    inline void clear_has_e8FolderType ();

    inline void set_has_u32FolderHandle ();

    inline void clear_has_u32FolderHandle ();

    inline void set_has_e8MessageListType ();

    inline void clear_has_e8MessageListType ();

    inline void set_has_e8MessageListSortType ();

    inline void clear_has_e8MessageListSortType ();

    inline void set_has_e8MessageListFilterType ();

    inline void clear_has_e8MessageListFilterType ();

    uint32 _has_bits_[ (6 + 31) / 32];

    uint8 _u8DeviceHandle;

    ::most_Msg_fi_types::T_e8_MsgFolderType _e8FolderType;

    uint32 _u32FolderHandle;

    ::most_Msg_fi_types::T_e8_MsgMessageListType _e8MessageListType;

    ::most_Msg_fi_types::T_e8_MsgMessageListSortType _e8MessageListSortType;

    ::most_Msg_fi_types::T_e8_MsgMessageListFilterType _e8MessageListFilterType;

};

/**
 * The result message of the method "CreateMessageList"
 * Creates a message list of a particular type and returns a ListHandle to the caller.  Slices of the list can then be accessed via RequestMessageListSlice.
 * When the folder type is Conversation, slices of the list could be accessed via RequestSliceConversationList. Changes to the list are notified via the MessageListChanged property.
 */
class CreateMessageListResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CreateMessageListResult ();

    /**
     * Copy constructor
     */
    inline  CreateMessageListResult (const CreateMessageListResult &rhs);

    /**
     * All fields constructor
     */
    inline  CreateMessageListResult (uint16 u16ListHandle_, uint16 u16ListLength_);

    /**
     * Destructor
     */
    inline virtual  ~CreateMessageListResult();

    /**
     * Assignment operator
     */
    inline CreateMessageListResult& operator = (const CreateMessageListResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreateMessageListResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreateMessageListResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreateMessageListResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreateMessageListResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ListHandle"

    static const int kU16ListHandle = 0;

    /**
     * Clears the field "u16ListHandle".
     *
     * The field will be set to its default value. The hasU16ListHandle()
     * method will return false.
     */
    inline void clearU16ListHandle();

    /**
     * Checks whether the field "u16ListHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ListHandle()). Otherwise it will return false.
     */
    inline bool hasU16ListHandle () const;

    /**
     * Returns the value of the member "u16ListHandle".
     *
     * The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @return The value of the field "u16ListHandle"
     */
    inline uint16 getU16ListHandle () const;

    /**
     * Sets the value of the member "u16ListHandle".
     *
     * The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @param u16ListHandle The value which will be set
     */
    inline void setU16ListHandle (uint16 u16ListHandle_);

    // API of field "u16ListLength"

    static const int kU16ListLength = 1;

    /**
     * Clears the field "u16ListLength".
     *
     * The field will be set to its default value. The hasU16ListLength()
     * method will return false.
     */
    inline void clearU16ListLength();

    /**
     * Checks whether the field "u16ListLength" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ListLength()). Otherwise it will return false.
     */
    inline bool hasU16ListLength () const;

    /**
     * Returns the value of the member "u16ListLength".
     *
     * The total number of messages or number of conversations in the created list.
     *
     * @return The value of the field "u16ListLength"
     */
    inline uint16 getU16ListLength () const;

    /**
     * Sets the value of the member "u16ListLength".
     *
     * The total number of messages or number of conversations in the created list.
     *
     * @param u16ListLength The value which will be set
     */
    inline void setU16ListLength (uint16 u16ListLength_);

    static const CreateMessageListResult &getDefaultInstance();

private:

    inline void set_has_u16ListHandle ();

    inline void clear_has_u16ListHandle ();

    inline void set_has_u16ListLength ();

    inline void clear_has_u16ListLength ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _u16ListHandle;

    uint16 _u16ListLength;

};

/**
 * The error message of 'CreateMessageList'
 */
class CreateMessageListErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  CreateMessageListErrorStructure ();

    /**
     * Copy constructor
     */
    inline  CreateMessageListErrorStructure (const CreateMessageListErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  CreateMessageListErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~CreateMessageListErrorStructure();

    /**
     * Assignment operator
     */
    inline CreateMessageListErrorStructure& operator = (const CreateMessageListErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreateMessageListErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreateMessageListErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreateMessageListErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreateMessageListErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const CreateMessageListErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'CreateMessageList'
 */
class CreateMessageListError  : public ::asf::core::Payload {
public:

    enum CreateMessageListErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  CreateMessageListError ();

   /**
     * Copy constructor
     */
    inline  CreateMessageListError (const CreateMessageListError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~CreateMessageListError();

    /**
     * Assigns a new value to this object.
     */
    inline CreateMessageListError& operator = (const CreateMessageListError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreateMessageListError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreateMessageListError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreateMessageListError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreateMessageListError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline CreateMessageListError::CreateMessageListErrorField getField () const;

    inline void setField(CreateMessageListError::CreateMessageListErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "CreateMessageListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "CreateMessageListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const CreateMessageListErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline CreateMessageListErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline CreateMessageListErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (CreateMessageListErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "CreateMessageListErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const CreateMessageListErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const CreateMessageListError &getDefaultInstance();

private:

    inline void cloneData (const CreateMessageListError& rhs);

    inline void deleteData ();

    CreateMessageListErrorField __field;

    union {
        CreateMessageListErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "RequestSliceMessageList"
 * The RequestSliceMessageList method provides a slice of the specific list specified by the ListHandle parameter. The slice begins with the item at location WindowStart and includes in sequential order the number of items specified by the parameter WindowSize.
 * The RequestSliceMessageList method returns the slice as a MessageListSliceResult stream.  If the number of items in the list starting at WindowStart is less than the WindowSize parameter then the number of items provided in the slice will be less than the WindowSize calling parameter.
 * The PlaybackState is transmitted in the MessageListResult for each message in order to allow HMI controllers to annotate a currently playing message with a start/stopped/paused indicator in the list view.
 */
class RequestSliceMessageListStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestSliceMessageListStart ();

    /**
     * Copy constructor
     */
    inline  RequestSliceMessageListStart (const RequestSliceMessageListStart &rhs);

    /**
     * All fields constructor
     */
    inline  RequestSliceMessageListStart (uint16 u16ListHandle_, uint32 u32WindowStart_, uint32 u32WindowSize_);

    /**
     * Destructor
     */
    inline virtual  ~RequestSliceMessageListStart();

    /**
     * Assignment operator
     */
    inline RequestSliceMessageListStart& operator = (const RequestSliceMessageListStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestSliceMessageListStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestSliceMessageListStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestSliceMessageListStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestSliceMessageListStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ListHandle"

    static const int kU16ListHandle = 0;

    /**
     * Clears the field "u16ListHandle".
     *
     * The field will be set to its default value. The hasU16ListHandle()
     * method will return false.
     */
    inline void clearU16ListHandle();

    /**
     * Checks whether the field "u16ListHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ListHandle()). Otherwise it will return false.
     */
    inline bool hasU16ListHandle () const;

    /**
     * Returns the value of the member "u16ListHandle".
     *
     * The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @return The value of the field "u16ListHandle"
     */
    inline uint16 getU16ListHandle () const;

    /**
     * Sets the value of the member "u16ListHandle".
     *
     * The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @param u16ListHandle The value which will be set
     */
    inline void setU16ListHandle (uint16 u16ListHandle_);

    // API of field "u32WindowStart"

    static const int kU32WindowStart = 1;

    /**
     * Clears the field "u32WindowStart".
     *
     * The field will be set to its default value. The hasU32WindowStart()
     * method will return false.
     */
    inline void clearU32WindowStart();

    /**
     * Checks whether the field "u32WindowStart" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32WindowStart()). Otherwise it will return false.
     */
    inline bool hasU32WindowStart () const;

    /**
     * Returns the value of the member "u32WindowStart".
     *
     * Specifies the start index of the required section inside the total list.
     *
     * @return The value of the field "u32WindowStart"
     */
    inline uint32 getU32WindowStart () const;

    /**
     * Sets the value of the member "u32WindowStart".
     *
     * Specifies the start index of the required section inside the total list.
     *
     * @param u32WindowStart The value which will be set
     */
    inline void setU32WindowStart (uint32 u32WindowStart_);

    // API of field "u32WindowSize"

    static const int kU32WindowSize = 2;

    /**
     * Clears the field "u32WindowSize".
     *
     * The field will be set to its default value. The hasU32WindowSize()
     * method will return false.
     */
    inline void clearU32WindowSize();

    /**
     * Checks whether the field "u32WindowSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32WindowSize()). Otherwise it will return false.
     */
    inline bool hasU32WindowSize () const;

    /**
     * Returns the value of the member "u32WindowSize".
     *
     * Specifies the size of the required section inside the total list.
     *
     * @return The value of the field "u32WindowSize"
     */
    inline uint32 getU32WindowSize () const;

    /**
     * Sets the value of the member "u32WindowSize".
     *
     * Specifies the size of the required section inside the total list.
     *
     * @param u32WindowSize The value which will be set
     */
    inline void setU32WindowSize (uint32 u32WindowSize_);

    static const RequestSliceMessageListStart &getDefaultInstance();

private:

    inline void set_has_u16ListHandle ();

    inline void clear_has_u16ListHandle ();

    inline void set_has_u32WindowStart ();

    inline void clear_has_u32WindowStart ();

    inline void set_has_u32WindowSize ();

    inline void clear_has_u32WindowSize ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint16 _u16ListHandle;

    uint32 _u32WindowStart;

    uint32 _u32WindowSize;

};

/**
 * The result message of the method "RequestSliceMessageList"
 * The RequestSliceMessageList method provides a slice of the specific list specified by the ListHandle parameter. The slice begins with the item at location WindowStart and includes in sequential order the number of items specified by the parameter WindowSize.
 * The RequestSliceMessageList method returns the slice as a MessageListSliceResult stream.  If the number of items in the list starting at WindowStart is less than the WindowSize parameter then the number of items provided in the slice will be less than the WindowSize calling parameter.
 * The PlaybackState is transmitted in the MessageListResult for each message in order to allow HMI controllers to annotate a currently playing message with a start/stopped/paused indicator in the list view.
 */
class RequestSliceMessageListResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestSliceMessageListResult ();

    /**
     * Copy constructor
     */
    inline  RequestSliceMessageListResult (const RequestSliceMessageListResult &rhs);

    /**
     * All fields constructor
     */
    inline  RequestSliceMessageListResult (const ::most_Msg_fi_types::T_MsgMessageListSliceResult& oMessageListSliceResult_);

    /**
     * Destructor
     */
    inline virtual  ~RequestSliceMessageListResult();

    /**
     * Assignment operator
     */
    inline RequestSliceMessageListResult& operator = (const RequestSliceMessageListResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestSliceMessageListResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestSliceMessageListResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestSliceMessageListResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestSliceMessageListResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oMessageListSliceResult"

    static const int kOMessageListSliceResult = 0;

    /**
     * Clears the field "oMessageListSliceResult".
     *
     * The field will be set to its default value. The hasOMessageListSliceResult()
     * method will return false.
     */
    inline void clearOMessageListSliceResult();

    /**
     * Checks whether the field "oMessageListSliceResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOMessageListSliceResult()). Otherwise it will return false.
     */
    inline bool hasOMessageListSliceResult () const;

    /**
     * Returns the value of the member "oMessageListSliceResult".
     *
     *
     *
     * @return The value of the field "oMessageListSliceResult"
     */
    inline const ::most_Msg_fi_types::T_MsgMessageListSliceResult& getOMessageListSliceResult () const;

    /**
     * Retrieves the value of the field "oMessageListSliceResult" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oMessageListSliceResult".
     */
    inline ::most_Msg_fi_types::T_MsgMessageListSliceResult& getOMessageListSliceResultMutable ();

    /**
     * Sets the value of the member "oMessageListSliceResult".
     *
     *
     *
     * @param oMessageListSliceResult The value which will be set
     */
    inline void setOMessageListSliceResult (const ::most_Msg_fi_types::T_MsgMessageListSliceResult& oMessageListSliceResult_);

    static const RequestSliceMessageListResult &getDefaultInstance();

private:

    static const ::std::vector< ::most_Msg_fi_types::T_MsgMessageListSliceResultItem >& getT_MsgMessageListSliceResultItemList_DefaultInstance ();

    inline void set_has_oMessageListSliceResult ();

    inline void clear_has_oMessageListSliceResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_Msg_fi_types::T_MsgMessageListSliceResult _oMessageListSliceResult;

};

/**
 * The error message of 'RequestSliceMessageList'
 */
class RequestSliceMessageListErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  RequestSliceMessageListErrorStructure ();

    /**
     * Copy constructor
     */
    inline  RequestSliceMessageListErrorStructure (const RequestSliceMessageListErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  RequestSliceMessageListErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~RequestSliceMessageListErrorStructure();

    /**
     * Assignment operator
     */
    inline RequestSliceMessageListErrorStructure& operator = (const RequestSliceMessageListErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestSliceMessageListErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestSliceMessageListErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestSliceMessageListErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestSliceMessageListErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const RequestSliceMessageListErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'RequestSliceMessageList'
 */
class RequestSliceMessageListError  : public ::asf::core::Payload {
public:

    enum RequestSliceMessageListErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  RequestSliceMessageListError ();

   /**
     * Copy constructor
     */
    inline  RequestSliceMessageListError (const RequestSliceMessageListError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~RequestSliceMessageListError();

    /**
     * Assigns a new value to this object.
     */
    inline RequestSliceMessageListError& operator = (const RequestSliceMessageListError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestSliceMessageListError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestSliceMessageListError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestSliceMessageListError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestSliceMessageListError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline RequestSliceMessageListError::RequestSliceMessageListErrorField getField () const;

    inline void setField(RequestSliceMessageListError::RequestSliceMessageListErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "RequestSliceMessageListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "RequestSliceMessageListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const RequestSliceMessageListErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline RequestSliceMessageListErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline RequestSliceMessageListErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (RequestSliceMessageListErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "RequestSliceMessageListErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const RequestSliceMessageListErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const RequestSliceMessageListError &getDefaultInstance();

private:

    inline void cloneData (const RequestSliceMessageListError& rhs);

    inline void deleteData ();

    RequestSliceMessageListErrorField __field;

    union {
        RequestSliceMessageListErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "ReleaseMessageList"
 * The ReleaseMessageList function releases a list which has been created by the CreateMessageList function.  The list to release is specified by the ListHandle parameter. The ListHandle becomes invalid by this function.
 */
class ReleaseMessageListStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReleaseMessageListStart ();

    /**
     * Copy constructor
     */
    inline  ReleaseMessageListStart (const ReleaseMessageListStart &rhs);

    /**
     * All fields constructor
     */
    inline  ReleaseMessageListStart (uint16 u16ListHandle_);

    /**
     * Destructor
     */
    inline virtual  ~ReleaseMessageListStart();

    /**
     * Assignment operator
     */
    inline ReleaseMessageListStart& operator = (const ReleaseMessageListStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReleaseMessageListStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReleaseMessageListStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReleaseMessageListStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReleaseMessageListStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ListHandle"

    static const int kU16ListHandle = 0;

    /**
     * Clears the field "u16ListHandle".
     *
     * The field will be set to its default value. The hasU16ListHandle()
     * method will return false.
     */
    inline void clearU16ListHandle();

    /**
     * Checks whether the field "u16ListHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ListHandle()). Otherwise it will return false.
     */
    inline bool hasU16ListHandle () const;

    /**
     * Returns the value of the member "u16ListHandle".
     *
     * The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @return The value of the field "u16ListHandle"
     */
    inline uint16 getU16ListHandle () const;

    /**
     * Sets the value of the member "u16ListHandle".
     *
     * The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @param u16ListHandle The value which will be set
     */
    inline void setU16ListHandle (uint16 u16ListHandle_);

    static const ReleaseMessageListStart &getDefaultInstance();

private:

    inline void set_has_u16ListHandle ();

    inline void clear_has_u16ListHandle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ListHandle;

};

/**
 * The result message of the method "ReleaseMessageList"
 * The ReleaseMessageList function releases a list which has been created by the CreateMessageList function.  The list to release is specified by the ListHandle parameter. The ListHandle becomes invalid by this function.
 */
class ReleaseMessageListResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReleaseMessageListResult ();

    /**
     * Copy constructor
     */
    inline  ReleaseMessageListResult (const ReleaseMessageListResult &rhs);

    /**
     * All fields constructor
     */
    inline  ReleaseMessageListResult (uint16 u16ListHandle_);

    /**
     * Destructor
     */
    inline virtual  ~ReleaseMessageListResult();

    /**
     * Assignment operator
     */
    inline ReleaseMessageListResult& operator = (const ReleaseMessageListResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReleaseMessageListResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReleaseMessageListResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReleaseMessageListResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReleaseMessageListResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ListHandle"

    static const int kU16ListHandle = 0;

    /**
     * Clears the field "u16ListHandle".
     *
     * The field will be set to its default value. The hasU16ListHandle()
     * method will return false.
     */
    inline void clearU16ListHandle();

    /**
     * Checks whether the field "u16ListHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ListHandle()). Otherwise it will return false.
     */
    inline bool hasU16ListHandle () const;

    /**
     * Returns the value of the member "u16ListHandle".
     *
     * The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @return The value of the field "u16ListHandle"
     */
    inline uint16 getU16ListHandle () const;

    /**
     * Sets the value of the member "u16ListHandle".
     *
     * The ListHandle parameter is a unique handle for a created list. The handle is valid until the ReleaseList function is called with this handle or the system is shut down.
     *
     * @param u16ListHandle The value which will be set
     */
    inline void setU16ListHandle (uint16 u16ListHandle_);

    static const ReleaseMessageListResult &getDefaultInstance();

private:

    inline void set_has_u16ListHandle ();

    inline void clear_has_u16ListHandle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ListHandle;

};

/**
 * The error message of 'ReleaseMessageList'
 */
class ReleaseMessageListErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  ReleaseMessageListErrorStructure ();

    /**
     * Copy constructor
     */
    inline  ReleaseMessageListErrorStructure (const ReleaseMessageListErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  ReleaseMessageListErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~ReleaseMessageListErrorStructure();

    /**
     * Assignment operator
     */
    inline ReleaseMessageListErrorStructure& operator = (const ReleaseMessageListErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReleaseMessageListErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReleaseMessageListErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReleaseMessageListErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReleaseMessageListErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const ReleaseMessageListErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'ReleaseMessageList'
 */
class ReleaseMessageListError  : public ::asf::core::Payload {
public:

    enum ReleaseMessageListErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  ReleaseMessageListError ();

   /**
     * Copy constructor
     */
    inline  ReleaseMessageListError (const ReleaseMessageListError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~ReleaseMessageListError();

    /**
     * Assigns a new value to this object.
     */
    inline ReleaseMessageListError& operator = (const ReleaseMessageListError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReleaseMessageListError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReleaseMessageListError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReleaseMessageListError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReleaseMessageListError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline ReleaseMessageListError::ReleaseMessageListErrorField getField () const;

    inline void setField(ReleaseMessageListError::ReleaseMessageListErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "ReleaseMessageListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "ReleaseMessageListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ReleaseMessageListErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ReleaseMessageListErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline ReleaseMessageListErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (ReleaseMessageListErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "ReleaseMessageListErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const ReleaseMessageListErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const ReleaseMessageListError &getDefaultInstance();

private:

    inline void cloneData (const ReleaseMessageListError& rhs);

    inline void deleteData ();

    ReleaseMessageListErrorField __field;

    union {
        ReleaseMessageListErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "RequestFolderList"
 * Retrieves the folder list from a particular branch of the hierarchy.
 */
class RequestFolderListStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestFolderListStart ();

    /**
     * Copy constructor
     */
    inline  RequestFolderListStart (const RequestFolderListStart &rhs);

    /**
     * All fields constructor
     */
    inline  RequestFolderListStart (uint32 u32FolderHandle_, bool bRootFlag_);

    /**
     * Destructor
     */
    inline virtual  ~RequestFolderListStart();

    /**
     * Assignment operator
     */
    inline RequestFolderListStart& operator = (const RequestFolderListStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestFolderListStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestFolderListStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestFolderListStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestFolderListStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32FolderHandle"

    static const int kU32FolderHandle = 0;

    /**
     * Clears the field "u32FolderHandle".
     *
     * The field will be set to its default value. The hasU32FolderHandle()
     * method will return false.
     */
    inline void clearU32FolderHandle();

    /**
     * Checks whether the field "u32FolderHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32FolderHandle()). Otherwise it will return false.
     */
    inline bool hasU32FolderHandle () const;

    /**
     * Returns the value of the member "u32FolderHandle".
     *
     * This is the unique handle for a particular folder.
     *
     * @return The value of the field "u32FolderHandle"
     */
    inline uint32 getU32FolderHandle () const;

    /**
     * Sets the value of the member "u32FolderHandle".
     *
     * This is the unique handle for a particular folder.
     *
     * @param u32FolderHandle The value which will be set
     */
    inline void setU32FolderHandle (uint32 u32FolderHandle_);

    // API of field "bRootFlag"

    static const int kBRootFlag = 1;

    /**
     * Clears the field "bRootFlag".
     *
     * The field will be set to its default value. The hasBRootFlag()
     * method will return false.
     */
    inline void clearBRootFlag();

    /**
     * Checks whether the field "bRootFlag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBRootFlag()). Otherwise it will return false.
     */
    inline bool hasBRootFlag () const;

    /**
     * Returns the value of the member "bRootFlag".
     *
     * This is the parameter in the GetFolderList call that identifies that the request is for the Root folder.
     *
     * @return The value of the field "bRootFlag"
     */
    inline bool getBRootFlag () const;

    /**
     * Sets the value of the member "bRootFlag".
     *
     * This is the parameter in the GetFolderList call that identifies that the request is for the Root folder.
     *
     * @param bRootFlag The value which will be set
     */
    inline void setBRootFlag (bool bRootFlag_);

    static const RequestFolderListStart &getDefaultInstance();

private:

    inline void set_has_u32FolderHandle ();

    inline void clear_has_u32FolderHandle ();

    inline void set_has_bRootFlag ();

    inline void clear_has_bRootFlag ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _u32FolderHandle;

    bool _bRootFlag;

};

/**
 * The result message of the method "RequestFolderList"
 * Retrieves the folder list from a particular branch of the hierarchy.
 */
class RequestFolderListResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestFolderListResult ();

    /**
     * Copy constructor
     */
    inline  RequestFolderListResult (const RequestFolderListResult &rhs);

    /**
     * All fields constructor
     */
    inline  RequestFolderListResult (const ::most_Msg_fi_types::T_MsgFolderListResult& oFolderListResult_);

    /**
     * Destructor
     */
    inline virtual  ~RequestFolderListResult();

    /**
     * Assignment operator
     */
    inline RequestFolderListResult& operator = (const RequestFolderListResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestFolderListResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestFolderListResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestFolderListResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestFolderListResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oFolderListResult"

    static const int kOFolderListResult = 0;

    /**
     * Clears the field "oFolderListResult".
     *
     * The field will be set to its default value. The hasOFolderListResult()
     * method will return false.
     */
    inline void clearOFolderListResult();

    /**
     * Checks whether the field "oFolderListResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOFolderListResult()). Otherwise it will return false.
     */
    inline bool hasOFolderListResult () const;

    /**
     * Returns the value of the member "oFolderListResult".
     *
     *
     *
     * @return The value of the field "oFolderListResult"
     */
    inline const ::most_Msg_fi_types::T_MsgFolderListResult& getOFolderListResult () const;

    /**
     * Retrieves the value of the field "oFolderListResult" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oFolderListResult".
     */
    inline ::most_Msg_fi_types::T_MsgFolderListResult& getOFolderListResultMutable ();

    /**
     * Sets the value of the member "oFolderListResult".
     *
     *
     *
     * @param oFolderListResult The value which will be set
     */
    inline void setOFolderListResult (const ::most_Msg_fi_types::T_MsgFolderListResult& oFolderListResult_);

    static const RequestFolderListResult &getDefaultInstance();

private:

    static const ::std::vector< ::most_Msg_fi_types::T_MsgFolderListResultItem >& getT_MsgFolderListResultItemList_DefaultInstance ();

    inline void set_has_oFolderListResult ();

    inline void clear_has_oFolderListResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_Msg_fi_types::T_MsgFolderListResult _oFolderListResult;

};

/**
 * The error message of 'RequestFolderList'
 */
class RequestFolderListErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  RequestFolderListErrorStructure ();

    /**
     * Copy constructor
     */
    inline  RequestFolderListErrorStructure (const RequestFolderListErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  RequestFolderListErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~RequestFolderListErrorStructure();

    /**
     * Assignment operator
     */
    inline RequestFolderListErrorStructure& operator = (const RequestFolderListErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestFolderListErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestFolderListErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestFolderListErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestFolderListErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const RequestFolderListErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'RequestFolderList'
 */
class RequestFolderListError  : public ::asf::core::Payload {
public:

    enum RequestFolderListErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  RequestFolderListError ();

   /**
     * Copy constructor
     */
    inline  RequestFolderListError (const RequestFolderListError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~RequestFolderListError();

    /**
     * Assigns a new value to this object.
     */
    inline RequestFolderListError& operator = (const RequestFolderListError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestFolderListError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestFolderListError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestFolderListError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestFolderListError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline RequestFolderListError::RequestFolderListErrorField getField () const;

    inline void setField(RequestFolderListError::RequestFolderListErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "RequestFolderListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "RequestFolderListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const RequestFolderListErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline RequestFolderListErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline RequestFolderListErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (RequestFolderListErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "RequestFolderListErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const RequestFolderListErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const RequestFolderListError &getDefaultInstance();

private:

    inline void cloneData (const RequestFolderListError& rhs);

    inline void deleteData ();

    RequestFolderListErrorField __field;

    union {
        RequestFolderListErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "DeleteMessage"
 * Deletes a message based on its MessageHandle. The FBlock deletes the message on both the device and in its local store. The Result response includes the DeletionStatus and the MessageHandle of the message requested for deletion.
 */
class DeleteMessageStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeleteMessageStart ();

    /**
     * Copy constructor
     */
    inline  DeleteMessageStart (const DeleteMessageStart &rhs);

    /**
     * All fields constructor
     */
    inline  DeleteMessageStart (const ::most_Msg_fi_types::T_MsgDeleteMessageHandles& oDeleteMessageHandles_);

    /**
     * Destructor
     */
    inline virtual  ~DeleteMessageStart();

    /**
     * Assignment operator
     */
    inline DeleteMessageStart& operator = (const DeleteMessageStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeleteMessageStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeleteMessageStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeleteMessageStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeleteMessageStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oDeleteMessageHandles"

    static const int kODeleteMessageHandles = 0;

    /**
     * Clears the field "oDeleteMessageHandles".
     *
     * The field will be set to its default value. The hasODeleteMessageHandles()
     * method will return false.
     */
    inline void clearODeleteMessageHandles();

    /**
     * Checks whether the field "oDeleteMessageHandles" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setODeleteMessageHandles()). Otherwise it will return false.
     */
    inline bool hasODeleteMessageHandles () const;

    /**
     * Returns the value of the member "oDeleteMessageHandles".
     *
     * Includes the message handles of all the messages to be deleted.
     *
     * @return The value of the field "oDeleteMessageHandles"
     */
    inline const ::most_Msg_fi_types::T_MsgDeleteMessageHandles& getODeleteMessageHandles () const;

    /**
     * Retrieves the value of the field "oDeleteMessageHandles" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oDeleteMessageHandles".
     */
    inline ::most_Msg_fi_types::T_MsgDeleteMessageHandles& getODeleteMessageHandlesMutable ();

    /**
     * Sets the value of the member "oDeleteMessageHandles".
     *
     * Includes the message handles of all the messages to be deleted.
     *
     * @param oDeleteMessageHandles The value which will be set
     */
    inline void setODeleteMessageHandles (const ::most_Msg_fi_types::T_MsgDeleteMessageHandles& oDeleteMessageHandles_);

    static const DeleteMessageStart &getDefaultInstance();

private:

    static const ::std::vector< ::fi_basetypes_most::T_ShortStream >& getT_ShortStreamList_DefaultInstance ();

    inline void set_has_oDeleteMessageHandles ();

    inline void clear_has_oDeleteMessageHandles ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_Msg_fi_types::T_MsgDeleteMessageHandles _oDeleteMessageHandles;

};

/**
 * The result message of the method "DeleteMessage"
 * Deletes a message based on its MessageHandle. The FBlock deletes the message on both the device and in its local store. The Result response includes the DeletionStatus and the MessageHandle of the message requested for deletion.
 */
class DeleteMessageResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeleteMessageResult ();

    /**
     * Copy constructor
     */
    inline  DeleteMessageResult (const DeleteMessageResult &rhs);

    /**
     * All fields constructor
     */
    inline  DeleteMessageResult (::most_Msg_fi_types::T_e8_MsgDeletionStatus e8DeletionStatus_, const ::most_Msg_fi_types::T_MsgDeleteMessageHandles& oDeleteMessageHandles_);

    /**
     * Destructor
     */
    inline virtual  ~DeleteMessageResult();

    /**
     * Assignment operator
     */
    inline DeleteMessageResult& operator = (const DeleteMessageResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeleteMessageResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeleteMessageResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeleteMessageResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeleteMessageResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8DeletionStatus"

    static const int kE8DeletionStatus = 0;

    /**
     * Clears the field "e8DeletionStatus".
     *
     * The field will be set to its default value. The hasE8DeletionStatus()
     * method will return false.
     */
    inline void clearE8DeletionStatus();

    /**
     * Checks whether the field "e8DeletionStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DeletionStatus()). Otherwise it will return false.
     */
    inline bool hasE8DeletionStatus () const;

    /**
     * Returns the value of the member "e8DeletionStatus".
     *
     * Contains the status in response to a DeleteMessage call.
     *
     * @return The value of the field "e8DeletionStatus"
     */
    inline ::most_Msg_fi_types::T_e8_MsgDeletionStatus getE8DeletionStatus () const;

    /**
     * Sets the value of the member "e8DeletionStatus".
     *
     * Contains the status in response to a DeleteMessage call.
     *
     * @param e8DeletionStatus The value which will be set
     */
    inline void setE8DeletionStatus (::most_Msg_fi_types::T_e8_MsgDeletionStatus e8DeletionStatus_);

    // API of field "oDeleteMessageHandles"

    static const int kODeleteMessageHandles = 1;

    /**
     * Clears the field "oDeleteMessageHandles".
     *
     * The field will be set to its default value. The hasODeleteMessageHandles()
     * method will return false.
     */
    inline void clearODeleteMessageHandles();

    /**
     * Checks whether the field "oDeleteMessageHandles" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setODeleteMessageHandles()). Otherwise it will return false.
     */
    inline bool hasODeleteMessageHandles () const;

    /**
     * Returns the value of the member "oDeleteMessageHandles".
     *
     * Includes the message handles of all the messages to be deleted.
     *
     * @return The value of the field "oDeleteMessageHandles"
     */
    inline const ::most_Msg_fi_types::T_MsgDeleteMessageHandles& getODeleteMessageHandles () const;

    /**
     * Retrieves the value of the field "oDeleteMessageHandles" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oDeleteMessageHandles".
     */
    inline ::most_Msg_fi_types::T_MsgDeleteMessageHandles& getODeleteMessageHandlesMutable ();

    /**
     * Sets the value of the member "oDeleteMessageHandles".
     *
     * Includes the message handles of all the messages to be deleted.
     *
     * @param oDeleteMessageHandles The value which will be set
     */
    inline void setODeleteMessageHandles (const ::most_Msg_fi_types::T_MsgDeleteMessageHandles& oDeleteMessageHandles_);

    static const DeleteMessageResult &getDefaultInstance();

private:

    static const ::std::vector< ::fi_basetypes_most::T_ShortStream >& getT_ShortStreamList_DefaultInstance ();

    inline void set_has_e8DeletionStatus ();

    inline void clear_has_e8DeletionStatus ();

    inline void set_has_oDeleteMessageHandles ();

    inline void clear_has_oDeleteMessageHandles ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::most_Msg_fi_types::T_e8_MsgDeletionStatus _e8DeletionStatus;

    ::most_Msg_fi_types::T_MsgDeleteMessageHandles _oDeleteMessageHandles;

};

/**
 * The error message of 'DeleteMessage'
 */
class DeleteMessageErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DeleteMessageErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DeleteMessageErrorStructure (const DeleteMessageErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DeleteMessageErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~DeleteMessageErrorStructure();

    /**
     * Assignment operator
     */
    inline DeleteMessageErrorStructure& operator = (const DeleteMessageErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeleteMessageErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeleteMessageErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeleteMessageErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeleteMessageErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const DeleteMessageErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'DeleteMessage'
 */
class DeleteMessageError  : public ::asf::core::Payload {
public:

    enum DeleteMessageErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DeleteMessageError ();

   /**
     * Copy constructor
     */
    inline  DeleteMessageError (const DeleteMessageError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DeleteMessageError();

    /**
     * Assigns a new value to this object.
     */
    inline DeleteMessageError& operator = (const DeleteMessageError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeleteMessageError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeleteMessageError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeleteMessageError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeleteMessageError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DeleteMessageError::DeleteMessageErrorField getField () const;

    inline void setField(DeleteMessageError::DeleteMessageErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DeleteMessageErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DeleteMessageErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DeleteMessageErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DeleteMessageErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DeleteMessageErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DeleteMessageErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DeleteMessageErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DeleteMessageErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DeleteMessageError &getDefaultInstance();

private:

    inline void cloneData (const DeleteMessageError& rhs);

    inline void deleteData ();

    DeleteMessageErrorField __field;

    union {
        DeleteMessageErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "RecoverMessage"
 * Recovers a message based on its MessageHandle. The FBlock recovers the message on both the device and in its local store. The Result response includes the RecoveryStatus and the MessageHandle of the message requested for recovery. Only applies to messages in deleted folder.
 */
class RecoverMessageStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RecoverMessageStart ();

    /**
     * Copy constructor
     */
    inline  RecoverMessageStart (const RecoverMessageStart &rhs);

    /**
     * All fields constructor
     */
    inline  RecoverMessageStart (const ::most_Msg_fi_types::T_MsgMessageHandle& oMessageHandle_);

    /**
     * Destructor
     */
    inline virtual  ~RecoverMessageStart();

    /**
     * Assignment operator
     */
    inline RecoverMessageStart& operator = (const RecoverMessageStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RecoverMessageStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RecoverMessageStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RecoverMessageStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RecoverMessageStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oMessageHandle"

    static const int kOMessageHandle = 0;

    /**
     * Clears the field "oMessageHandle".
     *
     * The field will be set to its default value. The hasOMessageHandle()
     * method will return false.
     */
    inline void clearOMessageHandle();

    /**
     * Checks whether the field "oMessageHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOMessageHandle()). Otherwise it will return false.
     */
    inline bool hasOMessageHandle () const;

    /**
     * Returns the value of the member "oMessageHandle".
     *
     * This is the globally unique ID for a particular message. The ID is unique across all currently connected devices and accounts.It is made up of the DeviceHandle, MsgHandleUpper, and MsgHandleLower.
     *
     * @return The value of the field "oMessageHandle"
     */
    inline const ::most_Msg_fi_types::T_MsgMessageHandle& getOMessageHandle () const;

    /**
     * Retrieves the value of the field "oMessageHandle" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oMessageHandle".
     */
    inline ::most_Msg_fi_types::T_MsgMessageHandle& getOMessageHandleMutable ();

    /**
     * Sets the value of the member "oMessageHandle".
     *
     * This is the globally unique ID for a particular message. The ID is unique across all currently connected devices and accounts.It is made up of the DeviceHandle, MsgHandleUpper, and MsgHandleLower.
     *
     * @param oMessageHandle The value which will be set
     */
    inline void setOMessageHandle (const ::most_Msg_fi_types::T_MsgMessageHandle& oMessageHandle_);

    static const RecoverMessageStart &getDefaultInstance();

private:

    inline void set_has_oMessageHandle ();

    inline void clear_has_oMessageHandle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_Msg_fi_types::T_MsgMessageHandle _oMessageHandle;

};

/**
 * The result message of the method "RecoverMessage"
 * Recovers a message based on its MessageHandle. The FBlock recovers the message on both the device and in its local store. The Result response includes the RecoveryStatus and the MessageHandle of the message requested for recovery. Only applies to messages in deleted folder.
 */
class RecoverMessageResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RecoverMessageResult ();

    /**
     * Copy constructor
     */
    inline  RecoverMessageResult (const RecoverMessageResult &rhs);

    /**
     * All fields constructor
     */
    inline  RecoverMessageResult (::most_Msg_fi_types::T_e8_MsgRecoveryStatus e8RecoveryStatus_, const ::most_Msg_fi_types::T_MsgMessageHandle& oMessageHandle_);

    /**
     * Destructor
     */
    inline virtual  ~RecoverMessageResult();

    /**
     * Assignment operator
     */
    inline RecoverMessageResult& operator = (const RecoverMessageResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RecoverMessageResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RecoverMessageResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RecoverMessageResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RecoverMessageResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8RecoveryStatus"

    static const int kE8RecoveryStatus = 0;

    /**
     * Clears the field "e8RecoveryStatus".
     *
     * The field will be set to its default value. The hasE8RecoveryStatus()
     * method will return false.
     */
    inline void clearE8RecoveryStatus();

    /**
     * Checks whether the field "e8RecoveryStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8RecoveryStatus()). Otherwise it will return false.
     */
    inline bool hasE8RecoveryStatus () const;

    /**
     * Returns the value of the member "e8RecoveryStatus".
     *
     * Contains the status in response to a RecoverMessage call.
     *
     * @return The value of the field "e8RecoveryStatus"
     */
    inline ::most_Msg_fi_types::T_e8_MsgRecoveryStatus getE8RecoveryStatus () const;

    /**
     * Sets the value of the member "e8RecoveryStatus".
     *
     * Contains the status in response to a RecoverMessage call.
     *
     * @param e8RecoveryStatus The value which will be set
     */
    inline void setE8RecoveryStatus (::most_Msg_fi_types::T_e8_MsgRecoveryStatus e8RecoveryStatus_);

    // API of field "oMessageHandle"

    static const int kOMessageHandle = 1;

    /**
     * Clears the field "oMessageHandle".
     *
     * The field will be set to its default value. The hasOMessageHandle()
     * method will return false.
     */
    inline void clearOMessageHandle();

    /**
     * Checks whether the field "oMessageHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOMessageHandle()). Otherwise it will return false.
     */
    inline bool hasOMessageHandle () const;

    /**
     * Returns the value of the member "oMessageHandle".
     *
     * This is the globally unique ID for a particular message. The ID is unique across all currently connected devices and accounts.It is made up of the DeviceHandle, MsgHandleUpper, and MsgHandleLower.
     *
     * @return The value of the field "oMessageHandle"
     */
    inline const ::most_Msg_fi_types::T_MsgMessageHandle& getOMessageHandle () const;

    /**
     * Retrieves the value of the field "oMessageHandle" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oMessageHandle".
     */
    inline ::most_Msg_fi_types::T_MsgMessageHandle& getOMessageHandleMutable ();

    /**
     * Sets the value of the member "oMessageHandle".
     *
     * This is the globally unique ID for a particular message. The ID is unique across all currently connected devices and accounts.It is made up of the DeviceHandle, MsgHandleUpper, and MsgHandleLower.
     *
     * @param oMessageHandle The value which will be set
     */
    inline void setOMessageHandle (const ::most_Msg_fi_types::T_MsgMessageHandle& oMessageHandle_);

    static const RecoverMessageResult &getDefaultInstance();

private:

    inline void set_has_e8RecoveryStatus ();

    inline void clear_has_e8RecoveryStatus ();

    inline void set_has_oMessageHandle ();

    inline void clear_has_oMessageHandle ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::most_Msg_fi_types::T_e8_MsgRecoveryStatus _e8RecoveryStatus;

    ::most_Msg_fi_types::T_MsgMessageHandle _oMessageHandle;

};

/**
 * The error message of 'RecoverMessage'
 */
class RecoverMessageErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  RecoverMessageErrorStructure ();

    /**
     * Copy constructor
     */
    inline  RecoverMessageErrorStructure (const RecoverMessageErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  RecoverMessageErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~RecoverMessageErrorStructure();

    /**
     * Assignment operator
     */
    inline RecoverMessageErrorStructure& operator = (const RecoverMessageErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RecoverMessageErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RecoverMessageErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RecoverMessageErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RecoverMessageErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const RecoverMessageErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'RecoverMessage'
 */
class RecoverMessageError  : public ::asf::core::Payload {
public:

    enum RecoverMessageErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  RecoverMessageError ();

   /**
     * Copy constructor
     */
    inline  RecoverMessageError (const RecoverMessageError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~RecoverMessageError();

    /**
     * Assigns a new value to this object.
     */
    inline RecoverMessageError& operator = (const RecoverMessageError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RecoverMessageError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RecoverMessageError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RecoverMessageError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RecoverMessageError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline RecoverMessageError::RecoverMessageErrorField getField () const;

    inline void setField(RecoverMessageError::RecoverMessageErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "RecoverMessageErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "RecoverMessageErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const RecoverMessageErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline RecoverMessageErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline RecoverMessageErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (RecoverMessageErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "RecoverMessageErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const RecoverMessageErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const RecoverMessageError &getDefaultInstance();

private:

    inline void cloneData (const RecoverMessageError& rhs);

    inline void deleteData ();

    RecoverMessageErrorField __field;

    union {
        RecoverMessageErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "RequestAccountList"
 * Retrieves the account list for a particular device.
 */
class RequestAccountListStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestAccountListStart ();

    /**
     * Copy constructor
     */
    inline  RequestAccountListStart (const RequestAccountListStart &rhs);

    /**
     * All fields constructor
     */
    inline  RequestAccountListStart (uint8 u8DeviceHandle_);

    /**
     * Destructor
     */
    inline virtual  ~RequestAccountListStart();

    /**
     * Assignment operator
     */
    inline RequestAccountListStart& operator = (const RequestAccountListStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestAccountListStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestAccountListStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestAccountListStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestAccountListStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    static const RequestAccountListStart &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8DeviceHandle;

};

/**
 * The result message of the method "RequestAccountList"
 * Retrieves the account list for a particular device.
 */
class RequestAccountListResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestAccountListResult ();

    /**
     * Copy constructor
     */
    inline  RequestAccountListResult (const RequestAccountListResult &rhs);

    /**
     * All fields constructor
     */
    inline  RequestAccountListResult (const ::most_Msg_fi_types::T_MsgAccountListResult& oAccountListResult_);

    /**
     * Destructor
     */
    inline virtual  ~RequestAccountListResult();

    /**
     * Assignment operator
     */
    inline RequestAccountListResult& operator = (const RequestAccountListResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestAccountListResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestAccountListResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestAccountListResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestAccountListResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oAccountListResult"

    static const int kOAccountListResult = 0;

    /**
     * Clears the field "oAccountListResult".
     *
     * The field will be set to its default value. The hasOAccountListResult()
     * method will return false.
     */
    inline void clearOAccountListResult();

    /**
     * Checks whether the field "oAccountListResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOAccountListResult()). Otherwise it will return false.
     */
    inline bool hasOAccountListResult () const;

    /**
     * Returns the value of the member "oAccountListResult".
     *
     * Provides the available accounts (handle and name) and which account is active for the particular device.
     *
     * @return The value of the field "oAccountListResult"
     */
    inline const ::most_Msg_fi_types::T_MsgAccountListResult& getOAccountListResult () const;

    /**
     * Retrieves the value of the field "oAccountListResult" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oAccountListResult".
     */
    inline ::most_Msg_fi_types::T_MsgAccountListResult& getOAccountListResultMutable ();

    /**
     * Sets the value of the member "oAccountListResult".
     *
     * Provides the available accounts (handle and name) and which account is active for the particular device.
     *
     * @param oAccountListResult The value which will be set
     */
    inline void setOAccountListResult (const ::most_Msg_fi_types::T_MsgAccountListResult& oAccountListResult_);

    static const RequestAccountListResult &getDefaultInstance();

private:

    static const ::std::vector< ::most_Msg_fi_types::T_MsgAccountListResultItem >& getT_MsgAccountListResultItemList_DefaultInstance ();

    inline void set_has_oAccountListResult ();

    inline void clear_has_oAccountListResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_Msg_fi_types::T_MsgAccountListResult _oAccountListResult;

};

/**
 * The error message of 'RequestAccountList'
 */
class RequestAccountListErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  RequestAccountListErrorStructure ();

    /**
     * Copy constructor
     */
    inline  RequestAccountListErrorStructure (const RequestAccountListErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  RequestAccountListErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~RequestAccountListErrorStructure();

    /**
     * Assignment operator
     */
    inline RequestAccountListErrorStructure& operator = (const RequestAccountListErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestAccountListErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestAccountListErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestAccountListErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestAccountListErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const RequestAccountListErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'RequestAccountList'
 */
class RequestAccountListError  : public ::asf::core::Payload {
public:

    enum RequestAccountListErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  RequestAccountListError ();

   /**
     * Copy constructor
     */
    inline  RequestAccountListError (const RequestAccountListError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~RequestAccountListError();

    /**
     * Assigns a new value to this object.
     */
    inline RequestAccountListError& operator = (const RequestAccountListError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestAccountListError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestAccountListError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestAccountListError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestAccountListError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline RequestAccountListError::RequestAccountListErrorField getField () const;

    inline void setField(RequestAccountListError::RequestAccountListErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "RequestAccountListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "RequestAccountListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const RequestAccountListErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline RequestAccountListErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline RequestAccountListErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (RequestAccountListErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "RequestAccountListErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const RequestAccountListErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const RequestAccountListError &getDefaultInstance();

private:

    inline void cloneData (const RequestAccountListError& rhs);

    inline void deleteData ();

    RequestAccountListErrorField __field;

    union {
        RequestAccountListErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "ChangeAccount"
 * Sets the selected account as active account and returns the changed account list.
 */
class ChangeAccountStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ChangeAccountStart ();

    /**
     * Copy constructor
     */
    inline  ChangeAccountStart (const ChangeAccountStart &rhs);

    /**
     * All fields constructor
     */
    inline  ChangeAccountStart (uint16 u16AccountHandle_);

    /**
     * Destructor
     */
    inline virtual  ~ChangeAccountStart();

    /**
     * Assignment operator
     */
    inline ChangeAccountStart& operator = (const ChangeAccountStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChangeAccountStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChangeAccountStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChangeAccountStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChangeAccountStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16AccountHandle"

    static const int kU16AccountHandle = 0;

    /**
     * Clears the field "u16AccountHandle".
     *
     * The field will be set to its default value. The hasU16AccountHandle()
     * method will return false.
     */
    inline void clearU16AccountHandle();

    /**
     * Checks whether the field "u16AccountHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16AccountHandle()). Otherwise it will return false.
     */
    inline bool hasU16AccountHandle () const;

    /**
     * Returns the value of the member "u16AccountHandle".
     *
     * This is the globally unique ID for a particular account.  The ID is unique across all currently connected devices.
     *
     * @return The value of the field "u16AccountHandle"
     */
    inline uint16 getU16AccountHandle () const;

    /**
     * Sets the value of the member "u16AccountHandle".
     *
     * This is the globally unique ID for a particular account.  The ID is unique across all currently connected devices.
     *
     * @param u16AccountHandle The value which will be set
     */
    inline void setU16AccountHandle (uint16 u16AccountHandle_);

    static const ChangeAccountStart &getDefaultInstance();

private:

    inline void set_has_u16AccountHandle ();

    inline void clear_has_u16AccountHandle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16AccountHandle;

};

/**
 * The result message of the method "ChangeAccount"
 * Sets the selected account as active account and returns the changed account list.
 */
class ChangeAccountResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ChangeAccountResult ();

    /**
     * Copy constructor
     */
    inline  ChangeAccountResult (const ChangeAccountResult &rhs);

    /**
     * All fields constructor
     */
    inline  ChangeAccountResult (bool bAccountConnectionResult_);

    /**
     * Destructor
     */
    inline virtual  ~ChangeAccountResult();

    /**
     * Assignment operator
     */
    inline ChangeAccountResult& operator = (const ChangeAccountResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChangeAccountResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChangeAccountResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChangeAccountResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChangeAccountResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bAccountConnectionResult"

    static const int kBAccountConnectionResult = 0;

    /**
     * Clears the field "bAccountConnectionResult".
     *
     * The field will be set to its default value. The hasBAccountConnectionResult()
     * method will return false.
     */
    inline void clearBAccountConnectionResult();

    /**
     * Checks whether the field "bAccountConnectionResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBAccountConnectionResult()). Otherwise it will return false.
     */
    inline bool hasBAccountConnectionResult () const;

    /**
     * Returns the value of the member "bAccountConnectionResult".
     *
     * Identifies if the connection to the email account has been established.
     *
     * @return The value of the field "bAccountConnectionResult"
     */
    inline bool getBAccountConnectionResult () const;

    /**
     * Sets the value of the member "bAccountConnectionResult".
     *
     * Identifies if the connection to the email account has been established.
     *
     * @param bAccountConnectionResult The value which will be set
     */
    inline void setBAccountConnectionResult (bool bAccountConnectionResult_);

    static const ChangeAccountResult &getDefaultInstance();

private:

    inline void set_has_bAccountConnectionResult ();

    inline void clear_has_bAccountConnectionResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bAccountConnectionResult;

};

/**
 * The error message of 'ChangeAccount'
 */
class ChangeAccountErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  ChangeAccountErrorStructure ();

    /**
     * Copy constructor
     */
    inline  ChangeAccountErrorStructure (const ChangeAccountErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  ChangeAccountErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~ChangeAccountErrorStructure();

    /**
     * Assignment operator
     */
    inline ChangeAccountErrorStructure& operator = (const ChangeAccountErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChangeAccountErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChangeAccountErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChangeAccountErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChangeAccountErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const ChangeAccountErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'ChangeAccount'
 */
class ChangeAccountError  : public ::asf::core::Payload {
public:

    enum ChangeAccountErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  ChangeAccountError ();

   /**
     * Copy constructor
     */
    inline  ChangeAccountError (const ChangeAccountError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~ChangeAccountError();

    /**
     * Assigns a new value to this object.
     */
    inline ChangeAccountError& operator = (const ChangeAccountError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChangeAccountError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChangeAccountError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChangeAccountError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChangeAccountError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline ChangeAccountError::ChangeAccountErrorField getField () const;

    inline void setField(ChangeAccountError::ChangeAccountErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "ChangeAccountErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "ChangeAccountErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ChangeAccountErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ChangeAccountErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline ChangeAccountErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (ChangeAccountErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "ChangeAccountErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const ChangeAccountErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const ChangeAccountError &getDefaultInstance();

private:

    inline void cloneData (const ChangeAccountError& rhs);

    inline void deleteData ();

    ChangeAccountErrorField __field;

    union {
        ChangeAccountErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The error message of 'UpdateInbox'
 */
class UpdateInboxErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  UpdateInboxErrorStructure ();

    /**
     * Copy constructor
     */
    inline  UpdateInboxErrorStructure (const UpdateInboxErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  UpdateInboxErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~UpdateInboxErrorStructure();

    /**
     * Assignment operator
     */
    inline UpdateInboxErrorStructure& operator = (const UpdateInboxErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateInboxErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateInboxErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateInboxErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateInboxErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const UpdateInboxErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'UpdateInbox'
 */
class UpdateInboxError  : public ::asf::core::Payload {
public:

    enum UpdateInboxErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  UpdateInboxError ();

   /**
     * Copy constructor
     */
    inline  UpdateInboxError (const UpdateInboxError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~UpdateInboxError();

    /**
     * Assigns a new value to this object.
     */
    inline UpdateInboxError& operator = (const UpdateInboxError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateInboxError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateInboxError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateInboxError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateInboxError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline UpdateInboxError::UpdateInboxErrorField getField () const;

    inline void setField(UpdateInboxError::UpdateInboxErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "UpdateInboxErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "UpdateInboxErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const UpdateInboxErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline UpdateInboxErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline UpdateInboxErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (UpdateInboxErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "UpdateInboxErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const UpdateInboxErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const UpdateInboxError &getDefaultInstance();

private:

    inline void cloneData (const UpdateInboxError& rhs);

    inline void deleteData ();

    UpdateInboxErrorField __field;

    union {
        UpdateInboxErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "GetMessage"
 * Retrieves the detailed information for a particular message(s) identified by the supplied MessageHandle. If the ConversationModeFlag is set to true then, the MessageDetailsResult will include all the messages that make up the conversation of the requested MessageHandle.
 */
class GetMessageStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetMessageStart ();

    /**
     * Copy constructor
     */
    inline  GetMessageStart (const GetMessageStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetMessageStart (const ::most_Msg_fi_types::T_MsgMessageHandle& oMessageHandle_);

    /**
     * Destructor
     */
    inline virtual  ~GetMessageStart();

    /**
     * Assignment operator
     */
    inline GetMessageStart& operator = (const GetMessageStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetMessageStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetMessageStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetMessageStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetMessageStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oMessageHandle"

    static const int kOMessageHandle = 0;

    /**
     * Clears the field "oMessageHandle".
     *
     * The field will be set to its default value. The hasOMessageHandle()
     * method will return false.
     */
    inline void clearOMessageHandle();

    /**
     * Checks whether the field "oMessageHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOMessageHandle()). Otherwise it will return false.
     */
    inline bool hasOMessageHandle () const;

    /**
     * Returns the value of the member "oMessageHandle".
     *
     * This is the globally unique ID for a particular message. The ID is unique across all currently connected devices and accounts.It is made up of the DeviceHandle, MsgHandleUpper, and MsgHandleLower.
     *
     * @return The value of the field "oMessageHandle"
     */
    inline const ::most_Msg_fi_types::T_MsgMessageHandle& getOMessageHandle () const;

    /**
     * Retrieves the value of the field "oMessageHandle" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oMessageHandle".
     */
    inline ::most_Msg_fi_types::T_MsgMessageHandle& getOMessageHandleMutable ();

    /**
     * Sets the value of the member "oMessageHandle".
     *
     * This is the globally unique ID for a particular message. The ID is unique across all currently connected devices and accounts.It is made up of the DeviceHandle, MsgHandleUpper, and MsgHandleLower.
     *
     * @param oMessageHandle The value which will be set
     */
    inline void setOMessageHandle (const ::most_Msg_fi_types::T_MsgMessageHandle& oMessageHandle_);

    static const GetMessageStart &getDefaultInstance();

private:

    inline void set_has_oMessageHandle ();

    inline void clear_has_oMessageHandle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_Msg_fi_types::T_MsgMessageHandle _oMessageHandle;

};

/**
 * The result message of the method "GetMessage"
 * Retrieves the detailed information for a particular message(s) identified by the supplied MessageHandle. If the ConversationModeFlag is set to true then, the MessageDetailsResult will include all the messages that make up the conversation of the requested MessageHandle.
 */
class GetMessageResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetMessageResult ();

    /**
     * Copy constructor
     */
    inline  GetMessageResult (const GetMessageResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetMessageResult (const ::most_Msg_fi_types::T_MsgMessageDetailsResult& oMessageDetailsResult_);

    /**
     * Destructor
     */
    inline virtual  ~GetMessageResult();

    /**
     * Assignment operator
     */
    inline GetMessageResult& operator = (const GetMessageResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetMessageResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetMessageResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetMessageResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetMessageResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oMessageDetailsResult"

    static const int kOMessageDetailsResult = 0;

    /**
     * Clears the field "oMessageDetailsResult".
     *
     * The field will be set to its default value. The hasOMessageDetailsResult()
     * method will return false.
     */
    inline void clearOMessageDetailsResult();

    /**
     * Checks whether the field "oMessageDetailsResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOMessageDetailsResult()). Otherwise it will return false.
     */
    inline bool hasOMessageDetailsResult () const;

    /**
     * Returns the value of the member "oMessageDetailsResult".
     *
     * Provides the message details results to a GetMessage request.Message texts less than or equal to 160 characters shall be sent as ShortMessage.Message texts greater than 160 characters shall be sent as BodyText (and retrieved using the GetBodyPartList).
     *
     * @return The value of the field "oMessageDetailsResult"
     */
    inline const ::most_Msg_fi_types::T_MsgMessageDetailsResult& getOMessageDetailsResult () const;

    /**
     * Retrieves the value of the field "oMessageDetailsResult" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oMessageDetailsResult".
     */
    inline ::most_Msg_fi_types::T_MsgMessageDetailsResult& getOMessageDetailsResultMutable ();

    /**
     * Sets the value of the member "oMessageDetailsResult".
     *
     * Provides the message details results to a GetMessage request.Message texts less than or equal to 160 characters shall be sent as ShortMessage.Message texts greater than 160 characters shall be sent as BodyText (and retrieved using the GetBodyPartList).
     *
     * @param oMessageDetailsResult The value which will be set
     */
    inline void setOMessageDetailsResult (const ::most_Msg_fi_types::T_MsgMessageDetailsResult& oMessageDetailsResult_);

    static const GetMessageResult &getDefaultInstance();

private:

    inline void set_has_oMessageDetailsResult ();

    inline void clear_has_oMessageDetailsResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_Msg_fi_types::T_MsgMessageDetailsResult _oMessageDetailsResult;

};

/**
 * The error message of 'GetMessage'
 */
class GetMessageErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetMessageErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetMessageErrorStructure (const GetMessageErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetMessageErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~GetMessageErrorStructure();

    /**
     * Assignment operator
     */
    inline GetMessageErrorStructure& operator = (const GetMessageErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetMessageErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetMessageErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetMessageErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetMessageErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const GetMessageErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'GetMessage'
 */
class GetMessageError  : public ::asf::core::Payload {
public:

    enum GetMessageErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetMessageError ();

   /**
     * Copy constructor
     */
    inline  GetMessageError (const GetMessageError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetMessageError();

    /**
     * Assigns a new value to this object.
     */
    inline GetMessageError& operator = (const GetMessageError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetMessageError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetMessageError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetMessageError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetMessageError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetMessageError::GetMessageErrorField getField () const;

    inline void setField(GetMessageError::GetMessageErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetMessageErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetMessageErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetMessageErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetMessageErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetMessageErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetMessageErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetMessageErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetMessageErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetMessageError &getDefaultInstance();

private:

    inline void cloneData (const GetMessageError& rhs);

    inline void deleteData ();

    GetMessageErrorField __field;

    union {
        GetMessageErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "GetAttachmentList"
 * This method is used to retrieve the AttachmentList for a specific message.  The returned list is constant and cannot change.
 */
class GetAttachmentListStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetAttachmentListStart ();

    /**
     * Copy constructor
     */
    inline  GetAttachmentListStart (const GetAttachmentListStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetAttachmentListStart (const ::most_Msg_fi_types::T_MsgMessageHandle& oMessageHandle_);

    /**
     * Destructor
     */
    inline virtual  ~GetAttachmentListStart();

    /**
     * Assignment operator
     */
    inline GetAttachmentListStart& operator = (const GetAttachmentListStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetAttachmentListStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetAttachmentListStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetAttachmentListStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetAttachmentListStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oMessageHandle"

    static const int kOMessageHandle = 0;

    /**
     * Clears the field "oMessageHandle".
     *
     * The field will be set to its default value. The hasOMessageHandle()
     * method will return false.
     */
    inline void clearOMessageHandle();

    /**
     * Checks whether the field "oMessageHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOMessageHandle()). Otherwise it will return false.
     */
    inline bool hasOMessageHandle () const;

    /**
     * Returns the value of the member "oMessageHandle".
     *
     * This is the globally unique ID for a particular message. The ID is unique across all currently connected devices and accounts.It is made up of the DeviceHandle, MsgHandleUpper, and MsgHandleLower.
     *
     * @return The value of the field "oMessageHandle"
     */
    inline const ::most_Msg_fi_types::T_MsgMessageHandle& getOMessageHandle () const;

    /**
     * Retrieves the value of the field "oMessageHandle" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oMessageHandle".
     */
    inline ::most_Msg_fi_types::T_MsgMessageHandle& getOMessageHandleMutable ();

    /**
     * Sets the value of the member "oMessageHandle".
     *
     * This is the globally unique ID for a particular message. The ID is unique across all currently connected devices and accounts.It is made up of the DeviceHandle, MsgHandleUpper, and MsgHandleLower.
     *
     * @param oMessageHandle The value which will be set
     */
    inline void setOMessageHandle (const ::most_Msg_fi_types::T_MsgMessageHandle& oMessageHandle_);

    static const GetAttachmentListStart &getDefaultInstance();

private:

    inline void set_has_oMessageHandle ();

    inline void clear_has_oMessageHandle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_Msg_fi_types::T_MsgMessageHandle _oMessageHandle;

};

/**
 * The result message of the method "GetAttachmentList"
 * This method is used to retrieve the AttachmentList for a specific message.  The returned list is constant and cannot change.
 */
class GetAttachmentListResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetAttachmentListResult ();

    /**
     * Copy constructor
     */
    inline  GetAttachmentListResult (const GetAttachmentListResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetAttachmentListResult (const ::most_Msg_fi_types::T_MsgAttachmentList& oAttachmentList_);

    /**
     * Destructor
     */
    inline virtual  ~GetAttachmentListResult();

    /**
     * Assignment operator
     */
    inline GetAttachmentListResult& operator = (const GetAttachmentListResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetAttachmentListResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetAttachmentListResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetAttachmentListResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetAttachmentListResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oAttachmentList"

    static const int kOAttachmentList = 0;

    /**
     * Clears the field "oAttachmentList".
     *
     * The field will be set to its default value. The hasOAttachmentList()
     * method will return false.
     */
    inline void clearOAttachmentList();

    /**
     * Checks whether the field "oAttachmentList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOAttachmentList()). Otherwise it will return false.
     */
    inline bool hasOAttachmentList () const;

    /**
     * Returns the value of the member "oAttachmentList".
     *
     * Provides the list of attachments.
     *
     * @return The value of the field "oAttachmentList"
     */
    inline const ::most_Msg_fi_types::T_MsgAttachmentList& getOAttachmentList () const;

    /**
     * Retrieves the value of the field "oAttachmentList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oAttachmentList".
     */
    inline ::most_Msg_fi_types::T_MsgAttachmentList& getOAttachmentListMutable ();

    /**
     * Sets the value of the member "oAttachmentList".
     *
     * Provides the list of attachments.
     *
     * @param oAttachmentList The value which will be set
     */
    inline void setOAttachmentList (const ::most_Msg_fi_types::T_MsgAttachmentList& oAttachmentList_);

    static const GetAttachmentListResult &getDefaultInstance();

private:

    static const ::std::vector< ::most_Msg_fi_types::T_MsgAttachmentListItem >& getT_MsgAttachmentListItemList_DefaultInstance ();

    inline void set_has_oAttachmentList ();

    inline void clear_has_oAttachmentList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_Msg_fi_types::T_MsgAttachmentList _oAttachmentList;

};

/**
 * The error message of 'GetAttachmentList'
 */
class GetAttachmentListErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetAttachmentListErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetAttachmentListErrorStructure (const GetAttachmentListErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetAttachmentListErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~GetAttachmentListErrorStructure();

    /**
     * Assignment operator
     */
    inline GetAttachmentListErrorStructure& operator = (const GetAttachmentListErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetAttachmentListErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetAttachmentListErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetAttachmentListErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetAttachmentListErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const GetAttachmentListErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'GetAttachmentList'
 */
class GetAttachmentListError  : public ::asf::core::Payload {
public:

    enum GetAttachmentListErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetAttachmentListError ();

   /**
     * Copy constructor
     */
    inline  GetAttachmentListError (const GetAttachmentListError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetAttachmentListError();

    /**
     * Assigns a new value to this object.
     */
    inline GetAttachmentListError& operator = (const GetAttachmentListError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetAttachmentListError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetAttachmentListError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetAttachmentListError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetAttachmentListError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetAttachmentListError::GetAttachmentListErrorField getField () const;

    inline void setField(GetAttachmentListError::GetAttachmentListErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetAttachmentListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetAttachmentListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetAttachmentListErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetAttachmentListErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetAttachmentListErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetAttachmentListErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetAttachmentListErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetAttachmentListErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetAttachmentListError &getDefaultInstance();

private:

    inline void cloneData (const GetAttachmentListError& rhs);

    inline void deleteData ();

    GetAttachmentListErrorField __field;

    union {
        GetAttachmentListErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "AudioAttachmentPlayback"
 * Requests the playback action for the audio attachment. Playback actions include:1. Play: plays or restarts a previously paused audio attachment2. Pause: pause the currently playing audio attachment3. Stop: stops a currently playing audio attachment.
 */
class AudioAttachmentPlaybackStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AudioAttachmentPlaybackStart ();

    /**
     * Copy constructor
     */
    inline  AudioAttachmentPlaybackStart (const AudioAttachmentPlaybackStart &rhs);

    /**
     * All fields constructor
     */
    inline  AudioAttachmentPlaybackStart (uint16 u16AttachmentHandle_, ::most_Msg_fi_types::T_e8_MsgPlaybackAction e8PlaybackAction_);

    /**
     * Destructor
     */
    inline virtual  ~AudioAttachmentPlaybackStart();

    /**
     * Assignment operator
     */
    inline AudioAttachmentPlaybackStart& operator = (const AudioAttachmentPlaybackStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudioAttachmentPlaybackStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudioAttachmentPlaybackStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudioAttachmentPlaybackStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudioAttachmentPlaybackStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16AttachmentHandle"

    static const int kU16AttachmentHandle = 0;

    /**
     * Clears the field "u16AttachmentHandle".
     *
     * The field will be set to its default value. The hasU16AttachmentHandle()
     * method will return false.
     */
    inline void clearU16AttachmentHandle();

    /**
     * Checks whether the field "u16AttachmentHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16AttachmentHandle()). Otherwise it will return false.
     */
    inline bool hasU16AttachmentHandle () const;

    /**
     * Returns the value of the member "u16AttachmentHandle".
     *
     * This is the handle for a particular attachment.  The handle is locally unique only for a particular message and is not required to be globally unique.
     *
     * @return The value of the field "u16AttachmentHandle"
     */
    inline uint16 getU16AttachmentHandle () const;

    /**
     * Sets the value of the member "u16AttachmentHandle".
     *
     * This is the handle for a particular attachment.  The handle is locally unique only for a particular message and is not required to be globally unique.
     *
     * @param u16AttachmentHandle The value which will be set
     */
    inline void setU16AttachmentHandle (uint16 u16AttachmentHandle_);

    // API of field "e8PlaybackAction"

    static const int kE8PlaybackAction = 1;

    /**
     * Clears the field "e8PlaybackAction".
     *
     * The field will be set to its default value. The hasE8PlaybackAction()
     * method will return false.
     */
    inline void clearE8PlaybackAction();

    /**
     * Checks whether the field "e8PlaybackAction" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PlaybackAction()). Otherwise it will return false.
     */
    inline bool hasE8PlaybackAction () const;

    /**
     * Returns the value of the member "e8PlaybackAction".
     *
     *
     *
     * @return The value of the field "e8PlaybackAction"
     */
    inline ::most_Msg_fi_types::T_e8_MsgPlaybackAction getE8PlaybackAction () const;

    /**
     * Sets the value of the member "e8PlaybackAction".
     *
     *
     *
     * @param e8PlaybackAction The value which will be set
     */
    inline void setE8PlaybackAction (::most_Msg_fi_types::T_e8_MsgPlaybackAction e8PlaybackAction_);

    static const AudioAttachmentPlaybackStart &getDefaultInstance();

private:

    inline void set_has_u16AttachmentHandle ();

    inline void clear_has_u16AttachmentHandle ();

    inline void set_has_e8PlaybackAction ();

    inline void clear_has_e8PlaybackAction ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _u16AttachmentHandle;

    ::most_Msg_fi_types::T_e8_MsgPlaybackAction _e8PlaybackAction;

};

/**
 * The result message of the method "AudioAttachmentPlayback"
 * Requests the playback action for the audio attachment. Playback actions include:1. Play: plays or restarts a previously paused audio attachment2. Pause: pause the currently playing audio attachment3. Stop: stops a currently playing audio attachment.
 */
class AudioAttachmentPlaybackResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AudioAttachmentPlaybackResult ();

    /**
     * Copy constructor
     */
    inline  AudioAttachmentPlaybackResult (const AudioAttachmentPlaybackResult &rhs);

    /**
     * All fields constructor
     */
    inline  AudioAttachmentPlaybackResult (::most_Msg_fi_types::T_e8_MsgPlaybackAction e8PlaybackAction_);

    /**
     * Destructor
     */
    inline virtual  ~AudioAttachmentPlaybackResult();

    /**
     * Assignment operator
     */
    inline AudioAttachmentPlaybackResult& operator = (const AudioAttachmentPlaybackResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudioAttachmentPlaybackResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudioAttachmentPlaybackResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudioAttachmentPlaybackResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudioAttachmentPlaybackResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8PlaybackAction"

    static const int kE8PlaybackAction = 0;

    /**
     * Clears the field "e8PlaybackAction".
     *
     * The field will be set to its default value. The hasE8PlaybackAction()
     * method will return false.
     */
    inline void clearE8PlaybackAction();

    /**
     * Checks whether the field "e8PlaybackAction" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PlaybackAction()). Otherwise it will return false.
     */
    inline bool hasE8PlaybackAction () const;

    /**
     * Returns the value of the member "e8PlaybackAction".
     *
     *
     *
     * @return The value of the field "e8PlaybackAction"
     */
    inline ::most_Msg_fi_types::T_e8_MsgPlaybackAction getE8PlaybackAction () const;

    /**
     * Sets the value of the member "e8PlaybackAction".
     *
     *
     *
     * @param e8PlaybackAction The value which will be set
     */
    inline void setE8PlaybackAction (::most_Msg_fi_types::T_e8_MsgPlaybackAction e8PlaybackAction_);

    static const AudioAttachmentPlaybackResult &getDefaultInstance();

private:

    inline void set_has_e8PlaybackAction ();

    inline void clear_has_e8PlaybackAction ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_Msg_fi_types::T_e8_MsgPlaybackAction _e8PlaybackAction;

};

/**
 * The error message of 'AudioAttachmentPlayback'
 */
class AudioAttachmentPlaybackErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  AudioAttachmentPlaybackErrorStructure ();

    /**
     * Copy constructor
     */
    inline  AudioAttachmentPlaybackErrorStructure (const AudioAttachmentPlaybackErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  AudioAttachmentPlaybackErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~AudioAttachmentPlaybackErrorStructure();

    /**
     * Assignment operator
     */
    inline AudioAttachmentPlaybackErrorStructure& operator = (const AudioAttachmentPlaybackErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudioAttachmentPlaybackErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudioAttachmentPlaybackErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudioAttachmentPlaybackErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudioAttachmentPlaybackErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const AudioAttachmentPlaybackErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'AudioAttachmentPlayback'
 */
class AudioAttachmentPlaybackError  : public ::asf::core::Payload {
public:

    enum AudioAttachmentPlaybackErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  AudioAttachmentPlaybackError ();

   /**
     * Copy constructor
     */
    inline  AudioAttachmentPlaybackError (const AudioAttachmentPlaybackError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~AudioAttachmentPlaybackError();

    /**
     * Assigns a new value to this object.
     */
    inline AudioAttachmentPlaybackError& operator = (const AudioAttachmentPlaybackError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudioAttachmentPlaybackError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudioAttachmentPlaybackError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudioAttachmentPlaybackError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudioAttachmentPlaybackError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline AudioAttachmentPlaybackError::AudioAttachmentPlaybackErrorField getField () const;

    inline void setField(AudioAttachmentPlaybackError::AudioAttachmentPlaybackErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "AudioAttachmentPlaybackErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "AudioAttachmentPlaybackErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const AudioAttachmentPlaybackErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline AudioAttachmentPlaybackErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline AudioAttachmentPlaybackErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (AudioAttachmentPlaybackErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "AudioAttachmentPlaybackErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const AudioAttachmentPlaybackErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const AudioAttachmentPlaybackError &getDefaultInstance();

private:

    inline void cloneData (const AudioAttachmentPlaybackError& rhs);

    inline void deleteData ();

    AudioAttachmentPlaybackErrorField __field;

    union {
        AudioAttachmentPlaybackErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "GetImageAttachment"
 * Retrieves the image associated with an attachment.  Controllers may call GetImageAttachmentInfo in advance to find the MIME type and size of the image in order to allocate buffers and/or decoding resources, then call this function to receive the actual image data.
 */
class GetImageAttachmentStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetImageAttachmentStart ();

    /**
     * Copy constructor
     */
    inline  GetImageAttachmentStart (const GetImageAttachmentStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetImageAttachmentStart (uint16 u16AttachmentHandle_);

    /**
     * Destructor
     */
    inline virtual  ~GetImageAttachmentStart();

    /**
     * Assignment operator
     */
    inline GetImageAttachmentStart& operator = (const GetImageAttachmentStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetImageAttachmentStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetImageAttachmentStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetImageAttachmentStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetImageAttachmentStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16AttachmentHandle"

    static const int kU16AttachmentHandle = 0;

    /**
     * Clears the field "u16AttachmentHandle".
     *
     * The field will be set to its default value. The hasU16AttachmentHandle()
     * method will return false.
     */
    inline void clearU16AttachmentHandle();

    /**
     * Checks whether the field "u16AttachmentHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16AttachmentHandle()). Otherwise it will return false.
     */
    inline bool hasU16AttachmentHandle () const;

    /**
     * Returns the value of the member "u16AttachmentHandle".
     *
     * This is the handle for a particular attachment.  The handle is locally unique only for a particular message and is not required to be globally unique.
     *
     * @return The value of the field "u16AttachmentHandle"
     */
    inline uint16 getU16AttachmentHandle () const;

    /**
     * Sets the value of the member "u16AttachmentHandle".
     *
     * This is the handle for a particular attachment.  The handle is locally unique only for a particular message and is not required to be globally unique.
     *
     * @param u16AttachmentHandle The value which will be set
     */
    inline void setU16AttachmentHandle (uint16 u16AttachmentHandle_);

    static const GetImageAttachmentStart &getDefaultInstance();

private:

    inline void set_has_u16AttachmentHandle ();

    inline void clear_has_u16AttachmentHandle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16AttachmentHandle;

};

/**
 * The result message of the method "GetImageAttachment"
 * Retrieves the image associated with an attachment.  Controllers may call GetImageAttachmentInfo in advance to find the MIME type and size of the image in order to allocate buffers and/or decoding resources, then call this function to receive the actual image data.
 */
class GetImageAttachmentResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetImageAttachmentResult ();

    /**
     * Copy constructor
     */
    inline  GetImageAttachmentResult (const GetImageAttachmentResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetImageAttachmentResult (uint8 u8DataByte_);

    /**
     * Destructor
     */
    inline virtual  ~GetImageAttachmentResult();

    /**
     * Assignment operator
     */
    inline GetImageAttachmentResult& operator = (const GetImageAttachmentResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetImageAttachmentResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetImageAttachmentResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetImageAttachmentResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetImageAttachmentResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DataByte"

    static const int kU8DataByte = 0;

    /**
     * Clears the field "u8DataByte".
     *
     * The field will be set to its default value. The hasU8DataByte()
     * method will return false.
     */
    inline void clearU8DataByte();

    /**
     * Checks whether the field "u8DataByte" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DataByte()). Otherwise it will return false.
     */
    inline bool hasU8DataByte () const;

    /**
     * Returns the value of the member "u8DataByte".
     *
     *
     *
     * @return The value of the field "u8DataByte"
     */
    inline uint8 getU8DataByte () const;

    /**
     * Sets the value of the member "u8DataByte".
     *
     *
     *
     * @param u8DataByte The value which will be set
     */
    inline void setU8DataByte (uint8 u8DataByte_);

    static const GetImageAttachmentResult &getDefaultInstance();

private:

    inline void set_has_u8DataByte ();

    inline void clear_has_u8DataByte ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8DataByte;

};

/**
 * The error message of 'GetImageAttachment'
 */
class GetImageAttachmentErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetImageAttachmentErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetImageAttachmentErrorStructure (const GetImageAttachmentErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetImageAttachmentErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~GetImageAttachmentErrorStructure();

    /**
     * Assignment operator
     */
    inline GetImageAttachmentErrorStructure& operator = (const GetImageAttachmentErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetImageAttachmentErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetImageAttachmentErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetImageAttachmentErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetImageAttachmentErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const GetImageAttachmentErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'GetImageAttachment'
 */
class GetImageAttachmentError  : public ::asf::core::Payload {
public:

    enum GetImageAttachmentErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetImageAttachmentError ();

   /**
     * Copy constructor
     */
    inline  GetImageAttachmentError (const GetImageAttachmentError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetImageAttachmentError();

    /**
     * Assigns a new value to this object.
     */
    inline GetImageAttachmentError& operator = (const GetImageAttachmentError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetImageAttachmentError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetImageAttachmentError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetImageAttachmentError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetImageAttachmentError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetImageAttachmentError::GetImageAttachmentErrorField getField () const;

    inline void setField(GetImageAttachmentError::GetImageAttachmentErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetImageAttachmentErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetImageAttachmentErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetImageAttachmentErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetImageAttachmentErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetImageAttachmentErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetImageAttachmentErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetImageAttachmentErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetImageAttachmentErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetImageAttachmentError &getDefaultInstance();

private:

    inline void cloneData (const GetImageAttachmentError& rhs);

    inline void deleteData ();

    GetImageAttachmentErrorField __field;

    union {
        GetImageAttachmentErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "GetBodyPartList"
 * This method is used to retrieve the BodyPart elements for a specific message.  The returned list is constant and cannot change.
 */
class GetBodyPartListStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetBodyPartListStart ();

    /**
     * Copy constructor
     */
    inline  GetBodyPartListStart (const GetBodyPartListStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetBodyPartListStart (const ::most_Msg_fi_types::T_MsgMessageHandle& oMessageHandle_);

    /**
     * Destructor
     */
    inline virtual  ~GetBodyPartListStart();

    /**
     * Assignment operator
     */
    inline GetBodyPartListStart& operator = (const GetBodyPartListStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetBodyPartListStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetBodyPartListStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetBodyPartListStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetBodyPartListStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oMessageHandle"

    static const int kOMessageHandle = 0;

    /**
     * Clears the field "oMessageHandle".
     *
     * The field will be set to its default value. The hasOMessageHandle()
     * method will return false.
     */
    inline void clearOMessageHandle();

    /**
     * Checks whether the field "oMessageHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOMessageHandle()). Otherwise it will return false.
     */
    inline bool hasOMessageHandle () const;

    /**
     * Returns the value of the member "oMessageHandle".
     *
     * This is the globally unique ID for a particular message. The ID is unique across all currently connected devices and accounts.It is made up of the DeviceHandle, MsgHandleUpper, and MsgHandleLower.
     *
     * @return The value of the field "oMessageHandle"
     */
    inline const ::most_Msg_fi_types::T_MsgMessageHandle& getOMessageHandle () const;

    /**
     * Retrieves the value of the field "oMessageHandle" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oMessageHandle".
     */
    inline ::most_Msg_fi_types::T_MsgMessageHandle& getOMessageHandleMutable ();

    /**
     * Sets the value of the member "oMessageHandle".
     *
     * This is the globally unique ID for a particular message. The ID is unique across all currently connected devices and accounts.It is made up of the DeviceHandle, MsgHandleUpper, and MsgHandleLower.
     *
     * @param oMessageHandle The value which will be set
     */
    inline void setOMessageHandle (const ::most_Msg_fi_types::T_MsgMessageHandle& oMessageHandle_);

    static const GetBodyPartListStart &getDefaultInstance();

private:

    inline void set_has_oMessageHandle ();

    inline void clear_has_oMessageHandle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_Msg_fi_types::T_MsgMessageHandle _oMessageHandle;

};

/**
 * The result message of the method "GetBodyPartList"
 * This method is used to retrieve the BodyPart elements for a specific message.  The returned list is constant and cannot change.
 */
class GetBodyPartListResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetBodyPartListResult ();

    /**
     * Copy constructor
     */
    inline  GetBodyPartListResult (const GetBodyPartListResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetBodyPartListResult (const ::most_Msg_fi_types::T_MsgBodyPartList& oBodyPartList_);

    /**
     * Destructor
     */
    inline virtual  ~GetBodyPartListResult();

    /**
     * Assignment operator
     */
    inline GetBodyPartListResult& operator = (const GetBodyPartListResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetBodyPartListResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetBodyPartListResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetBodyPartListResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetBodyPartListResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oBodyPartList"

    static const int kOBodyPartList = 0;

    /**
     * Clears the field "oBodyPartList".
     *
     * The field will be set to its default value. The hasOBodyPartList()
     * method will return false.
     */
    inline void clearOBodyPartList();

    /**
     * Checks whether the field "oBodyPartList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOBodyPartList()). Otherwise it will return false.
     */
    inline bool hasOBodyPartList () const;

    /**
     * Returns the value of the member "oBodyPartList".
     *
     * This is the list of message BodyParts for a specific message.
     *
     * @return The value of the field "oBodyPartList"
     */
    inline const ::most_Msg_fi_types::T_MsgBodyPartList& getOBodyPartList () const;

    /**
     * Retrieves the value of the field "oBodyPartList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oBodyPartList".
     */
    inline ::most_Msg_fi_types::T_MsgBodyPartList& getOBodyPartListMutable ();

    /**
     * Sets the value of the member "oBodyPartList".
     *
     * This is the list of message BodyParts for a specific message.
     *
     * @param oBodyPartList The value which will be set
     */
    inline void setOBodyPartList (const ::most_Msg_fi_types::T_MsgBodyPartList& oBodyPartList_);

    static const GetBodyPartListResult &getDefaultInstance();

private:

    static const ::std::vector< ::most_Msg_fi_types::T_MsgBodyPartListItem >& getT_MsgBodyPartListItemList_DefaultInstance ();

    inline void set_has_oBodyPartList ();

    inline void clear_has_oBodyPartList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_Msg_fi_types::T_MsgBodyPartList _oBodyPartList;

};

/**
 * The error message of 'GetBodyPartList'
 */
class GetBodyPartListErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetBodyPartListErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetBodyPartListErrorStructure (const GetBodyPartListErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetBodyPartListErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~GetBodyPartListErrorStructure();

    /**
     * Assignment operator
     */
    inline GetBodyPartListErrorStructure& operator = (const GetBodyPartListErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetBodyPartListErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetBodyPartListErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetBodyPartListErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetBodyPartListErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const GetBodyPartListErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'GetBodyPartList'
 */
class GetBodyPartListError  : public ::asf::core::Payload {
public:

    enum GetBodyPartListErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetBodyPartListError ();

   /**
     * Copy constructor
     */
    inline  GetBodyPartListError (const GetBodyPartListError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetBodyPartListError();

    /**
     * Assigns a new value to this object.
     */
    inline GetBodyPartListError& operator = (const GetBodyPartListError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetBodyPartListError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetBodyPartListError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetBodyPartListError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetBodyPartListError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetBodyPartListError::GetBodyPartListErrorField getField () const;

    inline void setField(GetBodyPartListError::GetBodyPartListErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetBodyPartListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetBodyPartListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetBodyPartListErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetBodyPartListErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetBodyPartListErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetBodyPartListErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetBodyPartListErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetBodyPartListErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetBodyPartListError &getDefaultInstance();

private:

    inline void cloneData (const GetBodyPartListError& rhs);

    inline void deleteData ();

    GetBodyPartListErrorField __field;

    union {
        GetBodyPartListErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "ReadMessageAloud"
 * This method is used to begin or end the reading of the selected message aloud on the specified LogicalAVChannel.Messaging shall be responsible for requesting the TTS session.
 * Important note on TTSLanguage parameter:The TTSLanguage parameter was defined in MY13 with incorrect language enumerations that do not match the master system language enums in TextToSpeech.
 * TTSLanguage and GMLANGateway.LanguageSelection. The ReadMessageAloud feature is intended to always read the message in the system language (GMLANGateway.LanguageSelection).
 * Therefore, the TTSLanguage parameter shall be handled as follows:
 *
 * <item>
 * Controllers shall always set TTSLanguage to 0xFF = USE_SYSTEM_LANGUAGE_SELECTION.
 * </item>
 * <item>
 * The Messaging FBlock shall always read the TTSLanguage in the current system language according to the GMLANGateway.LanguageSelection
 * property and/or internal calibrations for the specific TTS language corresponding to the current LanguageSelection value.
 * </item>
 * <item>
 * If the TTSLanguage parameter is received with ANY vale other than 0xFF = USE_SYSTEM_LANGUAGE_SELECTION, then the Messaging FBlock shall
 * ignore the value and execute the read message aloud function in the system language (provided the system language is available in the
 * current system configuration).
 * </item>
 */
class ReadMessageAloudStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReadMessageAloudStart ();

    /**
     * Copy constructor
     */
    inline  ReadMessageAloudStart (const ReadMessageAloudStart &rhs);

    /**
     * All fields constructor
     */
    inline  ReadMessageAloudStart (const ::most_Msg_fi_types::T_MsgMessageHandle& oMessageHandle_, ::most_Msg_fi_types::T_e8_MsgPlaybackAction e8PlaybackAction_, uint8 u8LogicalAVChannel_, ::most_Msg_fi_types::T_e8_MsgTTSLanguage e8TTSLanguage_);

    /**
     * Destructor
     */
    inline virtual  ~ReadMessageAloudStart();

    /**
     * Assignment operator
     */
    inline ReadMessageAloudStart& operator = (const ReadMessageAloudStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReadMessageAloudStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReadMessageAloudStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReadMessageAloudStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReadMessageAloudStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oMessageHandle"

    static const int kOMessageHandle = 0;

    /**
     * Clears the field "oMessageHandle".
     *
     * The field will be set to its default value. The hasOMessageHandle()
     * method will return false.
     */
    inline void clearOMessageHandle();

    /**
     * Checks whether the field "oMessageHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOMessageHandle()). Otherwise it will return false.
     */
    inline bool hasOMessageHandle () const;

    /**
     * Returns the value of the member "oMessageHandle".
     *
     * This is the globally unique ID for a particular message. The ID is unique across all currently connected devices and accounts.It is made up of the DeviceHandle, MsgHandleUpper, and MsgHandleLower.
     *
     * @return The value of the field "oMessageHandle"
     */
    inline const ::most_Msg_fi_types::T_MsgMessageHandle& getOMessageHandle () const;

    /**
     * Retrieves the value of the field "oMessageHandle" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oMessageHandle".
     */
    inline ::most_Msg_fi_types::T_MsgMessageHandle& getOMessageHandleMutable ();

    /**
     * Sets the value of the member "oMessageHandle".
     *
     * This is the globally unique ID for a particular message. The ID is unique across all currently connected devices and accounts.It is made up of the DeviceHandle, MsgHandleUpper, and MsgHandleLower.
     *
     * @param oMessageHandle The value which will be set
     */
    inline void setOMessageHandle (const ::most_Msg_fi_types::T_MsgMessageHandle& oMessageHandle_);

    // API of field "e8PlaybackAction"

    static const int kE8PlaybackAction = 1;

    /**
     * Clears the field "e8PlaybackAction".
     *
     * The field will be set to its default value. The hasE8PlaybackAction()
     * method will return false.
     */
    inline void clearE8PlaybackAction();

    /**
     * Checks whether the field "e8PlaybackAction" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PlaybackAction()). Otherwise it will return false.
     */
    inline bool hasE8PlaybackAction () const;

    /**
     * Returns the value of the member "e8PlaybackAction".
     *
     *
     *
     * @return The value of the field "e8PlaybackAction"
     */
    inline ::most_Msg_fi_types::T_e8_MsgPlaybackAction getE8PlaybackAction () const;

    /**
     * Sets the value of the member "e8PlaybackAction".
     *
     *
     *
     * @param e8PlaybackAction The value which will be set
     */
    inline void setE8PlaybackAction (::most_Msg_fi_types::T_e8_MsgPlaybackAction e8PlaybackAction_);

    // API of field "u8LogicalAVChannel"

    static const int kU8LogicalAVChannel = 2;

    /**
     * Clears the field "u8LogicalAVChannel".
     *
     * The field will be set to its default value. The hasU8LogicalAVChannel()
     * method will return false.
     */
    inline void clearU8LogicalAVChannel();

    /**
     * Checks whether the field "u8LogicalAVChannel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8LogicalAVChannel()). Otherwise it will return false.
     */
    inline bool hasU8LogicalAVChannel () const;

    /**
     * Returns the value of the member "u8LogicalAVChannel".
     *
     * Refer to IAVConnection for the enumeration of the Logical AV Channel parameter.
     *
     * @return The value of the field "u8LogicalAVChannel"
     */
    inline uint8 getU8LogicalAVChannel () const;

    /**
     * Sets the value of the member "u8LogicalAVChannel".
     *
     * Refer to IAVConnection for the enumeration of the Logical AV Channel parameter.
     *
     * @param u8LogicalAVChannel The value which will be set
     */
    inline void setU8LogicalAVChannel (uint8 u8LogicalAVChannel_);

    // API of field "e8TTSLanguage"

    static const int kE8TTSLanguage = 3;

    /**
     * Clears the field "e8TTSLanguage".
     *
     * The field will be set to its default value. The hasE8TTSLanguage()
     * method will return false.
     */
    inline void clearE8TTSLanguage();

    /**
     * Checks whether the field "e8TTSLanguage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8TTSLanguage()). Otherwise it will return false.
     */
    inline bool hasE8TTSLanguage () const;

    /**
     * Returns the value of the member "e8TTSLanguage".
     *
     * deprecatedThe TTSLanguage parameter was defined in MY13 with incorrect language enumerations that do not match the master system language enums in
     * TextToSpeech.TTSLanguage and GMLANGateway.LanguageSelection. The ReadMessageAloud feature is intended to always read the message in the system language
     * (GMLANGateway.LanguageSelection). Therefore, the TTSLanguage parameter is deprecated and shall be handled as follows:
     *
     * <item>
     * Controllers shall always set TTSLanguage to 0xFF = USE_SYSTEM_LANGUAGE_SELECTION.
     * </item>
     * <item>
     * The Messaging FBlock shall always read the TTSLanguage in the current system language according to the GMLANGateway.LanguageSelection
     * property and/or internal calibrations for the specific TTS language corresponding to the current LanguageSelection value.
     * </item>
     * <item>
     * If the TTSLanguage parameter is received with ANY vale other than 0xFF = USE_SYSTEM_LANGUAGE_SELECTION, then the Messaging FBlock shall
     * ignore the value and execute the read message aloud function in the system language (provided the system language is available in the
     * current system configuration).
     * </item>
     *
     * @return The value of the field "e8TTSLanguage"
     */
    inline ::most_Msg_fi_types::T_e8_MsgTTSLanguage getE8TTSLanguage () const;

    /**
     * Sets the value of the member "e8TTSLanguage".
     *
     * deprecatedThe TTSLanguage parameter was defined in MY13 with incorrect language enumerations that do not match the master system language enums in
     * TextToSpeech.TTSLanguage and GMLANGateway.LanguageSelection. The ReadMessageAloud feature is intended to always read the message in the system language
     * (GMLANGateway.LanguageSelection). Therefore, the TTSLanguage parameter is deprecated and shall be handled as follows:
     *
     * <item>
     * Controllers shall always set TTSLanguage to 0xFF = USE_SYSTEM_LANGUAGE_SELECTION.
     * </item>
     * <item>
     * The Messaging FBlock shall always read the TTSLanguage in the current system language according to the GMLANGateway.LanguageSelection
     * property and/or internal calibrations for the specific TTS language corresponding to the current LanguageSelection value.
     * </item>
     * <item>
     * If the TTSLanguage parameter is received with ANY vale other than 0xFF = USE_SYSTEM_LANGUAGE_SELECTION, then the Messaging FBlock shall
     * ignore the value and execute the read message aloud function in the system language (provided the system language is available in the
     * current system configuration).
     * </item>
     *
     * @param e8TTSLanguage The value which will be set
     */
    inline void setE8TTSLanguage (::most_Msg_fi_types::T_e8_MsgTTSLanguage e8TTSLanguage_);

    static const ReadMessageAloudStart &getDefaultInstance();

private:

    inline void set_has_oMessageHandle ();

    inline void clear_has_oMessageHandle ();

    inline void set_has_e8PlaybackAction ();

    inline void clear_has_e8PlaybackAction ();

    inline void set_has_u8LogicalAVChannel ();

    inline void clear_has_u8LogicalAVChannel ();

    inline void set_has_e8TTSLanguage ();

    inline void clear_has_e8TTSLanguage ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::most_Msg_fi_types::T_MsgMessageHandle _oMessageHandle;

    ::most_Msg_fi_types::T_e8_MsgPlaybackAction _e8PlaybackAction;

    uint8 _u8LogicalAVChannel;

    ::most_Msg_fi_types::T_e8_MsgTTSLanguage _e8TTSLanguage;

};

/**
 * The result message of the method "ReadMessageAloud"
 * This method is used to begin or end the reading of the selected message aloud on the specified LogicalAVChannel.Messaging shall be responsible for requesting the TTS session.
 * Important note on TTSLanguage parameter:The TTSLanguage parameter was defined in MY13 with incorrect language enumerations that do not match the master system language enums in TextToSpeech.
 * TTSLanguage and GMLANGateway.LanguageSelection. The ReadMessageAloud feature is intended to always read the message in the system language (GMLANGateway.LanguageSelection).
 * Therefore, the TTSLanguage parameter shall be handled as follows:
 *
 * <item>
 * Controllers shall always set TTSLanguage to 0xFF = USE_SYSTEM_LANGUAGE_SELECTION.
 * </item>
 * <item>
 * The Messaging FBlock shall always read the TTSLanguage in the current system language according to the GMLANGateway.LanguageSelection
 * property and/or internal calibrations for the specific TTS language corresponding to the current LanguageSelection value.
 * </item>
 * <item>
 * If the TTSLanguage parameter is received with ANY vale other than 0xFF = USE_SYSTEM_LANGUAGE_SELECTION, then the Messaging FBlock shall
 * ignore the value and execute the read message aloud function in the system language (provided the system language is available in the
 * current system configuration).
 * </item>
 */
class ReadMessageAloudResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReadMessageAloudResult ();

    /**
     * Copy constructor
     */
    inline  ReadMessageAloudResult (const ReadMessageAloudResult &rhs);

    /**
     * All fields constructor
     */
    inline  ReadMessageAloudResult (::most_Msg_fi_types::T_e8_MsgPlaybackAction e8PlaybackAction_);

    /**
     * Destructor
     */
    inline virtual  ~ReadMessageAloudResult();

    /**
     * Assignment operator
     */
    inline ReadMessageAloudResult& operator = (const ReadMessageAloudResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReadMessageAloudResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReadMessageAloudResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReadMessageAloudResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReadMessageAloudResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8PlaybackAction"

    static const int kE8PlaybackAction = 0;

    /**
     * Clears the field "e8PlaybackAction".
     *
     * The field will be set to its default value. The hasE8PlaybackAction()
     * method will return false.
     */
    inline void clearE8PlaybackAction();

    /**
     * Checks whether the field "e8PlaybackAction" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PlaybackAction()). Otherwise it will return false.
     */
    inline bool hasE8PlaybackAction () const;

    /**
     * Returns the value of the member "e8PlaybackAction".
     *
     *
     *
     * @return The value of the field "e8PlaybackAction"
     */
    inline ::most_Msg_fi_types::T_e8_MsgPlaybackAction getE8PlaybackAction () const;

    /**
     * Sets the value of the member "e8PlaybackAction".
     *
     *
     *
     * @param e8PlaybackAction The value which will be set
     */
    inline void setE8PlaybackAction (::most_Msg_fi_types::T_e8_MsgPlaybackAction e8PlaybackAction_);

    static const ReadMessageAloudResult &getDefaultInstance();

private:

    inline void set_has_e8PlaybackAction ();

    inline void clear_has_e8PlaybackAction ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_Msg_fi_types::T_e8_MsgPlaybackAction _e8PlaybackAction;

};

/**
 * The error message of 'ReadMessageAloud'
 */
class ReadMessageAloudErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  ReadMessageAloudErrorStructure ();

    /**
     * Copy constructor
     */
    inline  ReadMessageAloudErrorStructure (const ReadMessageAloudErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  ReadMessageAloudErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~ReadMessageAloudErrorStructure();

    /**
     * Assignment operator
     */
    inline ReadMessageAloudErrorStructure& operator = (const ReadMessageAloudErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReadMessageAloudErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReadMessageAloudErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReadMessageAloudErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReadMessageAloudErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const ReadMessageAloudErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'ReadMessageAloud'
 */
class ReadMessageAloudError  : public ::asf::core::Payload {
public:

    enum ReadMessageAloudErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  ReadMessageAloudError ();

   /**
     * Copy constructor
     */
    inline  ReadMessageAloudError (const ReadMessageAloudError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~ReadMessageAloudError();

    /**
     * Assigns a new value to this object.
     */
    inline ReadMessageAloudError& operator = (const ReadMessageAloudError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReadMessageAloudError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReadMessageAloudError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReadMessageAloudError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReadMessageAloudError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline ReadMessageAloudError::ReadMessageAloudErrorField getField () const;

    inline void setField(ReadMessageAloudError::ReadMessageAloudErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "ReadMessageAloudErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "ReadMessageAloudErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ReadMessageAloudErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ReadMessageAloudErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline ReadMessageAloudErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (ReadMessageAloudErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "ReadMessageAloudErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const ReadMessageAloudErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const ReadMessageAloudError &getDefaultInstance();

private:

    inline void cloneData (const ReadMessageAloudError& rhs);

    inline void deleteData ();

    ReadMessageAloudErrorField __field;

    union {
        ReadMessageAloudErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "RecordAudioMessage"
 * This method is used to record an audio message.
 */
class RecordAudioMessageStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RecordAudioMessageStart ();

    /**
     * Copy constructor
     */
    inline  RecordAudioMessageStart (const RecordAudioMessageStart &rhs);

    /**
     * All fields constructor
     */
    inline  RecordAudioMessageStart (::most_Msg_fi_types::T_e8_MsgRecordMessageAction e8RecordMessageAction_, uint8 u8LogicalAVChannel_);

    /**
     * Destructor
     */
    inline virtual  ~RecordAudioMessageStart();

    /**
     * Assignment operator
     */
    inline RecordAudioMessageStart& operator = (const RecordAudioMessageStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RecordAudioMessageStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RecordAudioMessageStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RecordAudioMessageStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RecordAudioMessageStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8RecordMessageAction"

    static const int kE8RecordMessageAction = 0;

    /**
     * Clears the field "e8RecordMessageAction".
     *
     * The field will be set to its default value. The hasE8RecordMessageAction()
     * method will return false.
     */
    inline void clearE8RecordMessageAction();

    /**
     * Checks whether the field "e8RecordMessageAction" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8RecordMessageAction()). Otherwise it will return false.
     */
    inline bool hasE8RecordMessageAction () const;

    /**
     * Returns the value of the member "e8RecordMessageAction".
     *
     * Identifies the audio message voice recording actions: Start, Stop, Cancel
     *
     * @return The value of the field "e8RecordMessageAction"
     */
    inline ::most_Msg_fi_types::T_e8_MsgRecordMessageAction getE8RecordMessageAction () const;

    /**
     * Sets the value of the member "e8RecordMessageAction".
     *
     * Identifies the audio message voice recording actions: Start, Stop, Cancel
     *
     * @param e8RecordMessageAction The value which will be set
     */
    inline void setE8RecordMessageAction (::most_Msg_fi_types::T_e8_MsgRecordMessageAction e8RecordMessageAction_);

    // API of field "u8LogicalAVChannel"

    static const int kU8LogicalAVChannel = 1;

    /**
     * Clears the field "u8LogicalAVChannel".
     *
     * The field will be set to its default value. The hasU8LogicalAVChannel()
     * method will return false.
     */
    inline void clearU8LogicalAVChannel();

    /**
     * Checks whether the field "u8LogicalAVChannel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8LogicalAVChannel()). Otherwise it will return false.
     */
    inline bool hasU8LogicalAVChannel () const;

    /**
     * Returns the value of the member "u8LogicalAVChannel".
     *
     * Refer to IAVConnection for the enumeration of the Logical AV Channel parameter.
     *
     * @return The value of the field "u8LogicalAVChannel"
     */
    inline uint8 getU8LogicalAVChannel () const;

    /**
     * Sets the value of the member "u8LogicalAVChannel".
     *
     * Refer to IAVConnection for the enumeration of the Logical AV Channel parameter.
     *
     * @param u8LogicalAVChannel The value which will be set
     */
    inline void setU8LogicalAVChannel (uint8 u8LogicalAVChannel_);

    static const RecordAudioMessageStart &getDefaultInstance();

private:

    inline void set_has_e8RecordMessageAction ();

    inline void clear_has_e8RecordMessageAction ();

    inline void set_has_u8LogicalAVChannel ();

    inline void clear_has_u8LogicalAVChannel ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::most_Msg_fi_types::T_e8_MsgRecordMessageAction _e8RecordMessageAction;

    uint8 _u8LogicalAVChannel;

};

/**
 * The result message of the method "RecordAudioMessage"
 * This method is used to record an audio message.
 */
class RecordAudioMessageResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RecordAudioMessageResult ();

    /**
     * Copy constructor
     */
    inline  RecordAudioMessageResult (const RecordAudioMessageResult &rhs);

    /**
     * All fields constructor
     */
    inline  RecordAudioMessageResult (uint16 u16RecordedAudioMessageHandle_);

    /**
     * Destructor
     */
    inline virtual  ~RecordAudioMessageResult();

    /**
     * Assignment operator
     */
    inline RecordAudioMessageResult& operator = (const RecordAudioMessageResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RecordAudioMessageResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RecordAudioMessageResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RecordAudioMessageResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RecordAudioMessageResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16RecordedAudioMessageHandle"

    static const int kU16RecordedAudioMessageHandle = 0;

    /**
     * Clears the field "u16RecordedAudioMessageHandle".
     *
     * The field will be set to its default value. The hasU16RecordedAudioMessageHandle()
     * method will return false.
     */
    inline void clearU16RecordedAudioMessageHandle();

    /**
     * Checks whether the field "u16RecordedAudioMessageHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16RecordedAudioMessageHandle()). Otherwise it will return false.
     */
    inline bool hasU16RecordedAudioMessageHandle () const;

    /**
     * Returns the value of the member "u16RecordedAudioMessageHandle".
     *
     * RecordedAudioMessageHandle = 0 is reserved to identify a NULL handle.
     *
     * @return The value of the field "u16RecordedAudioMessageHandle"
     */
    inline uint16 getU16RecordedAudioMessageHandle () const;

    /**
     * Sets the value of the member "u16RecordedAudioMessageHandle".
     *
     * RecordedAudioMessageHandle = 0 is reserved to identify a NULL handle.
     *
     * @param u16RecordedAudioMessageHandle The value which will be set
     */
    inline void setU16RecordedAudioMessageHandle (uint16 u16RecordedAudioMessageHandle_);

    static const RecordAudioMessageResult &getDefaultInstance();

private:

    inline void set_has_u16RecordedAudioMessageHandle ();

    inline void clear_has_u16RecordedAudioMessageHandle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16RecordedAudioMessageHandle;

};

/**
 * The error message of 'RecordAudioMessage'
 */
class RecordAudioMessageErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  RecordAudioMessageErrorStructure ();

    /**
     * Copy constructor
     */
    inline  RecordAudioMessageErrorStructure (const RecordAudioMessageErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  RecordAudioMessageErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~RecordAudioMessageErrorStructure();

    /**
     * Assignment operator
     */
    inline RecordAudioMessageErrorStructure& operator = (const RecordAudioMessageErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RecordAudioMessageErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RecordAudioMessageErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RecordAudioMessageErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RecordAudioMessageErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const RecordAudioMessageErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'RecordAudioMessage'
 */
class RecordAudioMessageError  : public ::asf::core::Payload {
public:

    enum RecordAudioMessageErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  RecordAudioMessageError ();

   /**
     * Copy constructor
     */
    inline  RecordAudioMessageError (const RecordAudioMessageError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~RecordAudioMessageError();

    /**
     * Assigns a new value to this object.
     */
    inline RecordAudioMessageError& operator = (const RecordAudioMessageError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RecordAudioMessageError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RecordAudioMessageError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RecordAudioMessageError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RecordAudioMessageError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline RecordAudioMessageError::RecordAudioMessageErrorField getField () const;

    inline void setField(RecordAudioMessageError::RecordAudioMessageErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "RecordAudioMessageErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "RecordAudioMessageErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const RecordAudioMessageErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline RecordAudioMessageErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline RecordAudioMessageErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (RecordAudioMessageErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "RecordAudioMessageErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const RecordAudioMessageErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const RecordAudioMessageError &getDefaultInstance();

private:

    inline void cloneData (const RecordAudioMessageError& rhs);

    inline void deleteData ();

    RecordAudioMessageErrorField __field;

    union {
        RecordAudioMessageErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "PlaybackAudioMessage"
 * This method is used to playback a recorded audio message.
 */
class PlaybackAudioMessageStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PlaybackAudioMessageStart ();

    /**
     * Copy constructor
     */
    inline  PlaybackAudioMessageStart (const PlaybackAudioMessageStart &rhs);

    /**
     * All fields constructor
     */
    inline  PlaybackAudioMessageStart (uint16 u16RecordedAudioMessageHandle_, ::most_Msg_fi_types::T_e8_MsgPlaybackAction e8PlaybackAction_);

    /**
     * Destructor
     */
    inline virtual  ~PlaybackAudioMessageStart();

    /**
     * Assignment operator
     */
    inline PlaybackAudioMessageStart& operator = (const PlaybackAudioMessageStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PlaybackAudioMessageStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PlaybackAudioMessageStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PlaybackAudioMessageStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PlaybackAudioMessageStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16RecordedAudioMessageHandle"

    static const int kU16RecordedAudioMessageHandle = 0;

    /**
     * Clears the field "u16RecordedAudioMessageHandle".
     *
     * The field will be set to its default value. The hasU16RecordedAudioMessageHandle()
     * method will return false.
     */
    inline void clearU16RecordedAudioMessageHandle();

    /**
     * Checks whether the field "u16RecordedAudioMessageHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16RecordedAudioMessageHandle()). Otherwise it will return false.
     */
    inline bool hasU16RecordedAudioMessageHandle () const;

    /**
     * Returns the value of the member "u16RecordedAudioMessageHandle".
     *
     * RecordedAudioMessageHandle = 0 is reserved to identify a NULL handle.
     *
     * @return The value of the field "u16RecordedAudioMessageHandle"
     */
    inline uint16 getU16RecordedAudioMessageHandle () const;

    /**
     * Sets the value of the member "u16RecordedAudioMessageHandle".
     *
     * RecordedAudioMessageHandle = 0 is reserved to identify a NULL handle.
     *
     * @param u16RecordedAudioMessageHandle The value which will be set
     */
    inline void setU16RecordedAudioMessageHandle (uint16 u16RecordedAudioMessageHandle_);

    // API of field "e8PlaybackAction"

    static const int kE8PlaybackAction = 1;

    /**
     * Clears the field "e8PlaybackAction".
     *
     * The field will be set to its default value. The hasE8PlaybackAction()
     * method will return false.
     */
    inline void clearE8PlaybackAction();

    /**
     * Checks whether the field "e8PlaybackAction" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PlaybackAction()). Otherwise it will return false.
     */
    inline bool hasE8PlaybackAction () const;

    /**
     * Returns the value of the member "e8PlaybackAction".
     *
     *
     *
     * @return The value of the field "e8PlaybackAction"
     */
    inline ::most_Msg_fi_types::T_e8_MsgPlaybackAction getE8PlaybackAction () const;

    /**
     * Sets the value of the member "e8PlaybackAction".
     *
     *
     *
     * @param e8PlaybackAction The value which will be set
     */
    inline void setE8PlaybackAction (::most_Msg_fi_types::T_e8_MsgPlaybackAction e8PlaybackAction_);

    static const PlaybackAudioMessageStart &getDefaultInstance();

private:

    inline void set_has_u16RecordedAudioMessageHandle ();

    inline void clear_has_u16RecordedAudioMessageHandle ();

    inline void set_has_e8PlaybackAction ();

    inline void clear_has_e8PlaybackAction ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _u16RecordedAudioMessageHandle;

    ::most_Msg_fi_types::T_e8_MsgPlaybackAction _e8PlaybackAction;

};

/**
 * The result message of the method "PlaybackAudioMessage"
 * This method is used to playback a recorded audio message.
 */
class PlaybackAudioMessageResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PlaybackAudioMessageResult ();

    /**
     * Copy constructor
     */
    inline  PlaybackAudioMessageResult (const PlaybackAudioMessageResult &rhs);

    /**
     * All fields constructor
     */
    inline  PlaybackAudioMessageResult (::most_Msg_fi_types::T_e8_MsgPlaybackState e8PlaybackState_);

    /**
     * Destructor
     */
    inline virtual  ~PlaybackAudioMessageResult();

    /**
     * Assignment operator
     */
    inline PlaybackAudioMessageResult& operator = (const PlaybackAudioMessageResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PlaybackAudioMessageResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PlaybackAudioMessageResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PlaybackAudioMessageResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PlaybackAudioMessageResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8PlaybackState"

    static const int kE8PlaybackState = 0;

    /**
     * Clears the field "e8PlaybackState".
     *
     * The field will be set to its default value. The hasE8PlaybackState()
     * method will return false.
     */
    inline void clearE8PlaybackState();

    /**
     * Checks whether the field "e8PlaybackState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PlaybackState()). Otherwise it will return false.
     */
    inline bool hasE8PlaybackState () const;

    /**
     * Returns the value of the member "e8PlaybackState".
     *
     *
     *
     * @return The value of the field "e8PlaybackState"
     */
    inline ::most_Msg_fi_types::T_e8_MsgPlaybackState getE8PlaybackState () const;

    /**
     * Sets the value of the member "e8PlaybackState".
     *
     *
     *
     * @param e8PlaybackState The value which will be set
     */
    inline void setE8PlaybackState (::most_Msg_fi_types::T_e8_MsgPlaybackState e8PlaybackState_);

    static const PlaybackAudioMessageResult &getDefaultInstance();

private:

    inline void set_has_e8PlaybackState ();

    inline void clear_has_e8PlaybackState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_Msg_fi_types::T_e8_MsgPlaybackState _e8PlaybackState;

};

/**
 * The error message of 'PlaybackAudioMessage'
 */
class PlaybackAudioMessageErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  PlaybackAudioMessageErrorStructure ();

    /**
     * Copy constructor
     */
    inline  PlaybackAudioMessageErrorStructure (const PlaybackAudioMessageErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  PlaybackAudioMessageErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~PlaybackAudioMessageErrorStructure();

    /**
     * Assignment operator
     */
    inline PlaybackAudioMessageErrorStructure& operator = (const PlaybackAudioMessageErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PlaybackAudioMessageErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PlaybackAudioMessageErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PlaybackAudioMessageErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PlaybackAudioMessageErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const PlaybackAudioMessageErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'PlaybackAudioMessage'
 */
class PlaybackAudioMessageError  : public ::asf::core::Payload {
public:

    enum PlaybackAudioMessageErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  PlaybackAudioMessageError ();

   /**
     * Copy constructor
     */
    inline  PlaybackAudioMessageError (const PlaybackAudioMessageError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~PlaybackAudioMessageError();

    /**
     * Assigns a new value to this object.
     */
    inline PlaybackAudioMessageError& operator = (const PlaybackAudioMessageError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PlaybackAudioMessageError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PlaybackAudioMessageError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PlaybackAudioMessageError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PlaybackAudioMessageError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline PlaybackAudioMessageError::PlaybackAudioMessageErrorField getField () const;

    inline void setField(PlaybackAudioMessageError::PlaybackAudioMessageErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "PlaybackAudioMessageErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "PlaybackAudioMessageErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const PlaybackAudioMessageErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline PlaybackAudioMessageErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline PlaybackAudioMessageErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (PlaybackAudioMessageErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "PlaybackAudioMessageErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const PlaybackAudioMessageErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const PlaybackAudioMessageError &getDefaultInstance();

private:

    inline void cloneData (const PlaybackAudioMessageError& rhs);

    inline void deleteData ();

    PlaybackAudioMessageErrorField __field;

    union {
        PlaybackAudioMessageErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "AddPredefinedMessage"
 * This method adds a new predefined message per the text sent by the HMI. Messaging returns the handle of the new predefined message.
 */
class AddPredefinedMessageStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AddPredefinedMessageStart ();

    /**
     * Copy constructor
     */
    inline  AddPredefinedMessageStart (const AddPredefinedMessageStart &rhs);

    /**
     * All fields constructor
     */
    inline  AddPredefinedMessageStart (const ::fi_basetypes_most::T_String& sPredefinedMessageText_);

    /**
     * Destructor
     */
    inline virtual  ~AddPredefinedMessageStart();

    /**
     * Assignment operator
     */
    inline AddPredefinedMessageStart& operator = (const AddPredefinedMessageStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddPredefinedMessageStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddPredefinedMessageStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddPredefinedMessageStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddPredefinedMessageStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sPredefinedMessageText"

    static const int kSPredefinedMessageText = 0;

    /**
     * Clears the field "sPredefinedMessageText".
     *
     * The field will be set to its default value. The hasSPredefinedMessageText()
     * method will return false.
     */
    inline void clearSPredefinedMessageText();

    /**
     * Checks whether the field "sPredefinedMessageText" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPredefinedMessageText()). Otherwise it will return false.
     */
    inline bool hasSPredefinedMessageText () const;

    /**
     * Returns the value of the member "sPredefinedMessageText".
     *
     * The text of the predefined message.
     *
     * @return The value of the field "sPredefinedMessageText"
     */
    inline const ::fi_basetypes_most::T_String& getSPredefinedMessageText () const;

    /**
     * Retrieves the value of the field "sPredefinedMessageText" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sPredefinedMessageText".
     */
    inline ::fi_basetypes_most::T_String& getSPredefinedMessageTextMutable ();

    /**
     * Sets the value of the member "sPredefinedMessageText".
     *
     * The text of the predefined message.
     *
     * @param sPredefinedMessageText The value which will be set
     */
    inline void setSPredefinedMessageText (const ::fi_basetypes_most::T_String& sPredefinedMessageText_);

    static const AddPredefinedMessageStart &getDefaultInstance();

private:

    inline void set_has_sPredefinedMessageText ();

    inline void clear_has_sPredefinedMessageText ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::fi_basetypes_most::T_String _sPredefinedMessageText;

};

/**
 * The result message of the method "AddPredefinedMessage"
 * This method adds a new predefined message per the text sent by the HMI. Messaging returns the handle of the new predefined message.
 */
class AddPredefinedMessageResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AddPredefinedMessageResult ();

    /**
     * Copy constructor
     */
    inline  AddPredefinedMessageResult (const AddPredefinedMessageResult &rhs);

    /**
     * All fields constructor
     */
    inline  AddPredefinedMessageResult (uint16 u16PredefinedMessageHandle_);

    /**
     * Destructor
     */
    inline virtual  ~AddPredefinedMessageResult();

    /**
     * Assignment operator
     */
    inline AddPredefinedMessageResult& operator = (const AddPredefinedMessageResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddPredefinedMessageResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddPredefinedMessageResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddPredefinedMessageResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddPredefinedMessageResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16PredefinedMessageHandle"

    static const int kU16PredefinedMessageHandle = 0;

    /**
     * Clears the field "u16PredefinedMessageHandle".
     *
     * The field will be set to its default value. The hasU16PredefinedMessageHandle()
     * method will return false.
     */
    inline void clearU16PredefinedMessageHandle();

    /**
     * Checks whether the field "u16PredefinedMessageHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16PredefinedMessageHandle()). Otherwise it will return false.
     */
    inline bool hasU16PredefinedMessageHandle () const;

    /**
     * Returns the value of the member "u16PredefinedMessageHandle".
     *
     * This is the unique ID for a particular predefined message text.
     *
     * @return The value of the field "u16PredefinedMessageHandle"
     */
    inline uint16 getU16PredefinedMessageHandle () const;

    /**
     * Sets the value of the member "u16PredefinedMessageHandle".
     *
     * This is the unique ID for a particular predefined message text.
     *
     * @param u16PredefinedMessageHandle The value which will be set
     */
    inline void setU16PredefinedMessageHandle (uint16 u16PredefinedMessageHandle_);

    static const AddPredefinedMessageResult &getDefaultInstance();

private:

    inline void set_has_u16PredefinedMessageHandle ();

    inline void clear_has_u16PredefinedMessageHandle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16PredefinedMessageHandle;

};

/**
 * The error message of 'AddPredefinedMessage'
 */
class AddPredefinedMessageErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  AddPredefinedMessageErrorStructure ();

    /**
     * Copy constructor
     */
    inline  AddPredefinedMessageErrorStructure (const AddPredefinedMessageErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  AddPredefinedMessageErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~AddPredefinedMessageErrorStructure();

    /**
     * Assignment operator
     */
    inline AddPredefinedMessageErrorStructure& operator = (const AddPredefinedMessageErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddPredefinedMessageErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddPredefinedMessageErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddPredefinedMessageErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddPredefinedMessageErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const AddPredefinedMessageErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'AddPredefinedMessage'
 */
class AddPredefinedMessageError  : public ::asf::core::Payload {
public:

    enum AddPredefinedMessageErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  AddPredefinedMessageError ();

   /**
     * Copy constructor
     */
    inline  AddPredefinedMessageError (const AddPredefinedMessageError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~AddPredefinedMessageError();

    /**
     * Assigns a new value to this object.
     */
    inline AddPredefinedMessageError& operator = (const AddPredefinedMessageError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddPredefinedMessageError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddPredefinedMessageError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddPredefinedMessageError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddPredefinedMessageError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline AddPredefinedMessageError::AddPredefinedMessageErrorField getField () const;

    inline void setField(AddPredefinedMessageError::AddPredefinedMessageErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "AddPredefinedMessageErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "AddPredefinedMessageErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const AddPredefinedMessageErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline AddPredefinedMessageErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline AddPredefinedMessageErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (AddPredefinedMessageErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "AddPredefinedMessageErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const AddPredefinedMessageErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const AddPredefinedMessageError &getDefaultInstance();

private:

    inline void cloneData (const AddPredefinedMessageError& rhs);

    inline void deleteData ();

    AddPredefinedMessageErrorField __field;

    union {
        AddPredefinedMessageErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "DeletePredefinedMessage"
 * This method deletes a predefined message from the predefined message list.
 */
class DeletePredefinedMessageStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeletePredefinedMessageStart ();

    /**
     * Copy constructor
     */
    inline  DeletePredefinedMessageStart (const DeletePredefinedMessageStart &rhs);

    /**
     * All fields constructor
     */
    inline  DeletePredefinedMessageStart (uint16 u16PredefinedMessageHandle_);

    /**
     * Destructor
     */
    inline virtual  ~DeletePredefinedMessageStart();

    /**
     * Assignment operator
     */
    inline DeletePredefinedMessageStart& operator = (const DeletePredefinedMessageStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeletePredefinedMessageStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeletePredefinedMessageStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeletePredefinedMessageStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeletePredefinedMessageStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16PredefinedMessageHandle"

    static const int kU16PredefinedMessageHandle = 0;

    /**
     * Clears the field "u16PredefinedMessageHandle".
     *
     * The field will be set to its default value. The hasU16PredefinedMessageHandle()
     * method will return false.
     */
    inline void clearU16PredefinedMessageHandle();

    /**
     * Checks whether the field "u16PredefinedMessageHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16PredefinedMessageHandle()). Otherwise it will return false.
     */
    inline bool hasU16PredefinedMessageHandle () const;

    /**
     * Returns the value of the member "u16PredefinedMessageHandle".
     *
     * This is the unique ID for a particular predefined message text.
     *
     * @return The value of the field "u16PredefinedMessageHandle"
     */
    inline uint16 getU16PredefinedMessageHandle () const;

    /**
     * Sets the value of the member "u16PredefinedMessageHandle".
     *
     * This is the unique ID for a particular predefined message text.
     *
     * @param u16PredefinedMessageHandle The value which will be set
     */
    inline void setU16PredefinedMessageHandle (uint16 u16PredefinedMessageHandle_);

    static const DeletePredefinedMessageStart &getDefaultInstance();

private:

    inline void set_has_u16PredefinedMessageHandle ();

    inline void clear_has_u16PredefinedMessageHandle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16PredefinedMessageHandle;

};

/**
 * The result message of the method "DeletePredefinedMessage"
 * This method deletes a predefined message from the predefined message list.
 */
class DeletePredefinedMessageResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeletePredefinedMessageResult ();

    /**
     * Copy constructor
     */
    inline  DeletePredefinedMessageResult (const DeletePredefinedMessageResult &rhs);

    /**
     * All fields constructor
     */
    inline  DeletePredefinedMessageResult (uint16 u16PredefinedMessageHandle_);

    /**
     * Destructor
     */
    inline virtual  ~DeletePredefinedMessageResult();

    /**
     * Assignment operator
     */
    inline DeletePredefinedMessageResult& operator = (const DeletePredefinedMessageResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeletePredefinedMessageResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeletePredefinedMessageResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeletePredefinedMessageResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeletePredefinedMessageResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16PredefinedMessageHandle"

    static const int kU16PredefinedMessageHandle = 0;

    /**
     * Clears the field "u16PredefinedMessageHandle".
     *
     * The field will be set to its default value. The hasU16PredefinedMessageHandle()
     * method will return false.
     */
    inline void clearU16PredefinedMessageHandle();

    /**
     * Checks whether the field "u16PredefinedMessageHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16PredefinedMessageHandle()). Otherwise it will return false.
     */
    inline bool hasU16PredefinedMessageHandle () const;

    /**
     * Returns the value of the member "u16PredefinedMessageHandle".
     *
     * This is the unique ID for a particular predefined message text.
     *
     * @return The value of the field "u16PredefinedMessageHandle"
     */
    inline uint16 getU16PredefinedMessageHandle () const;

    /**
     * Sets the value of the member "u16PredefinedMessageHandle".
     *
     * This is the unique ID for a particular predefined message text.
     *
     * @param u16PredefinedMessageHandle The value which will be set
     */
    inline void setU16PredefinedMessageHandle (uint16 u16PredefinedMessageHandle_);

    static const DeletePredefinedMessageResult &getDefaultInstance();

private:

    inline void set_has_u16PredefinedMessageHandle ();

    inline void clear_has_u16PredefinedMessageHandle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16PredefinedMessageHandle;

};

/**
 * The error message of 'DeletePredefinedMessage'
 */
class DeletePredefinedMessageErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DeletePredefinedMessageErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DeletePredefinedMessageErrorStructure (const DeletePredefinedMessageErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DeletePredefinedMessageErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~DeletePredefinedMessageErrorStructure();

    /**
     * Assignment operator
     */
    inline DeletePredefinedMessageErrorStructure& operator = (const DeletePredefinedMessageErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeletePredefinedMessageErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeletePredefinedMessageErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeletePredefinedMessageErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeletePredefinedMessageErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const DeletePredefinedMessageErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'DeletePredefinedMessage'
 */
class DeletePredefinedMessageError  : public ::asf::core::Payload {
public:

    enum DeletePredefinedMessageErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DeletePredefinedMessageError ();

   /**
     * Copy constructor
     */
    inline  DeletePredefinedMessageError (const DeletePredefinedMessageError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DeletePredefinedMessageError();

    /**
     * Assigns a new value to this object.
     */
    inline DeletePredefinedMessageError& operator = (const DeletePredefinedMessageError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeletePredefinedMessageError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeletePredefinedMessageError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeletePredefinedMessageError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeletePredefinedMessageError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DeletePredefinedMessageError::DeletePredefinedMessageErrorField getField () const;

    inline void setField(DeletePredefinedMessageError::DeletePredefinedMessageErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DeletePredefinedMessageErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DeletePredefinedMessageErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DeletePredefinedMessageErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DeletePredefinedMessageErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DeletePredefinedMessageErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DeletePredefinedMessageErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DeletePredefinedMessageErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DeletePredefinedMessageErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DeletePredefinedMessageError &getDefaultInstance();

private:

    inline void cloneData (const DeletePredefinedMessageError& rhs);

    inline void deleteData ();

    DeletePredefinedMessageErrorField __field;

    union {
        DeletePredefinedMessageErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "GetConversationMessages"
 * This method acquires the MessageHandles of all the messages that make up the conversation for a particular message (MessageHandle). The HMI uses the GetMessage method to get all the detailed information for each message.
 */
class GetConversationMessagesStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetConversationMessagesStart ();

    /**
     * Copy constructor
     */
    inline  GetConversationMessagesStart (const GetConversationMessagesStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetConversationMessagesStart (const ::most_Msg_fi_types::T_MsgMessageHandle& oMessageHandle_);

    /**
     * Destructor
     */
    inline virtual  ~GetConversationMessagesStart();

    /**
     * Assignment operator
     */
    inline GetConversationMessagesStart& operator = (const GetConversationMessagesStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetConversationMessagesStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetConversationMessagesStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetConversationMessagesStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetConversationMessagesStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oMessageHandle"

    static const int kOMessageHandle = 0;

    /**
     * Clears the field "oMessageHandle".
     *
     * The field will be set to its default value. The hasOMessageHandle()
     * method will return false.
     */
    inline void clearOMessageHandle();

    /**
     * Checks whether the field "oMessageHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOMessageHandle()). Otherwise it will return false.
     */
    inline bool hasOMessageHandle () const;

    /**
     * Returns the value of the member "oMessageHandle".
     *
     * This is the globally unique ID for a particular message. The ID is unique across all currently connected devices and accounts.It is made up of the DeviceHandle, MsgHandleUpper, and MsgHandleLower.
     *
     * @return The value of the field "oMessageHandle"
     */
    inline const ::most_Msg_fi_types::T_MsgMessageHandle& getOMessageHandle () const;

    /**
     * Retrieves the value of the field "oMessageHandle" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oMessageHandle".
     */
    inline ::most_Msg_fi_types::T_MsgMessageHandle& getOMessageHandleMutable ();

    /**
     * Sets the value of the member "oMessageHandle".
     *
     * This is the globally unique ID for a particular message. The ID is unique across all currently connected devices and accounts.It is made up of the DeviceHandle, MsgHandleUpper, and MsgHandleLower.
     *
     * @param oMessageHandle The value which will be set
     */
    inline void setOMessageHandle (const ::most_Msg_fi_types::T_MsgMessageHandle& oMessageHandle_);

    static const GetConversationMessagesStart &getDefaultInstance();

private:

    inline void set_has_oMessageHandle ();

    inline void clear_has_oMessageHandle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_Msg_fi_types::T_MsgMessageHandle _oMessageHandle;

};

/**
 * The result message of the method "GetConversationMessages"
 * This method acquires the MessageHandles of all the messages that make up the conversation for a particular message (MessageHandle). The HMI uses the GetMessage method to get all the detailed information for each message.
 */
class GetConversationMessagesResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetConversationMessagesResult ();

    /**
     * Copy constructor
     */
    inline  GetConversationMessagesResult (const GetConversationMessagesResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetConversationMessagesResult (const ::most_Msg_fi_types::T_MsgConversationMessages& oConversationMessages_);

    /**
     * Destructor
     */
    inline virtual  ~GetConversationMessagesResult();

    /**
     * Assignment operator
     */
    inline GetConversationMessagesResult& operator = (const GetConversationMessagesResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetConversationMessagesResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetConversationMessagesResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetConversationMessagesResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetConversationMessagesResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oConversationMessages"

    static const int kOConversationMessages = 0;

    /**
     * Clears the field "oConversationMessages".
     *
     * The field will be set to its default value. The hasOConversationMessages()
     * method will return false.
     */
    inline void clearOConversationMessages();

    /**
     * Checks whether the field "oConversationMessages" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOConversationMessages()). Otherwise it will return false.
     */
    inline bool hasOConversationMessages () const;

    /**
     * Returns the value of the member "oConversationMessages".
     *
     * Provides the list of MessageHandles that make up the conversation.
     *
     * @return The value of the field "oConversationMessages"
     */
    inline const ::most_Msg_fi_types::T_MsgConversationMessages& getOConversationMessages () const;

    /**
     * Retrieves the value of the field "oConversationMessages" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oConversationMessages".
     */
    inline ::most_Msg_fi_types::T_MsgConversationMessages& getOConversationMessagesMutable ();

    /**
     * Sets the value of the member "oConversationMessages".
     *
     * Provides the list of MessageHandles that make up the conversation.
     *
     * @param oConversationMessages The value which will be set
     */
    inline void setOConversationMessages (const ::most_Msg_fi_types::T_MsgConversationMessages& oConversationMessages_);

    static const GetConversationMessagesResult &getDefaultInstance();

private:

    static const ::std::vector< ::fi_basetypes_most::T_ShortStream >& getT_ShortStreamList_DefaultInstance ();

    inline void set_has_oConversationMessages ();

    inline void clear_has_oConversationMessages ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_Msg_fi_types::T_MsgConversationMessages _oConversationMessages;

};

/**
 * The error message of 'GetConversationMessages'
 */
class GetConversationMessagesErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetConversationMessagesErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetConversationMessagesErrorStructure (const GetConversationMessagesErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetConversationMessagesErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~GetConversationMessagesErrorStructure();

    /**
     * Assignment operator
     */
    inline GetConversationMessagesErrorStructure& operator = (const GetConversationMessagesErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetConversationMessagesErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetConversationMessagesErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetConversationMessagesErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetConversationMessagesErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const GetConversationMessagesErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'GetConversationMessages'
 */
class GetConversationMessagesError  : public ::asf::core::Payload {
public:

    enum GetConversationMessagesErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetConversationMessagesError ();

   /**
     * Copy constructor
     */
    inline  GetConversationMessagesError (const GetConversationMessagesError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetConversationMessagesError();

    /**
     * Assigns a new value to this object.
     */
    inline GetConversationMessagesError& operator = (const GetConversationMessagesError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetConversationMessagesError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetConversationMessagesError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetConversationMessagesError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetConversationMessagesError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetConversationMessagesError::GetConversationMessagesErrorField getField () const;

    inline void setField(GetConversationMessagesError::GetConversationMessagesErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetConversationMessagesErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetConversationMessagesErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetConversationMessagesErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetConversationMessagesErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetConversationMessagesErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetConversationMessagesErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetConversationMessagesErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetConversationMessagesErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetConversationMessagesError &getDefaultInstance();

private:

    inline void cloneData (const GetConversationMessagesError& rhs);

    inline void deleteData ();

    GetConversationMessagesErrorField __field;

    union {
        GetConversationMessagesErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SendMessage"
 * This method informs Messaging that a message needs to be sent. It provides the type of message, the original MessageHandle (if applicable), the create message type (i.e. new message, reply, reply to all, or forward), and the MessageHeaderBodyHandle.
 * Note that if the message could not be sent to the Bluetooth device for transmission, the SentMessageStatus will return ERROR.  If sent successfully to the Bluetooth, but not necessarily sent successfully on the cellular network, the SUCCESS code is returned.
 * Note further that for both of these response codes, the Messaging FBlock will trigger the appropriate alert to the AlertManager FBlock for notification to the overall vehicle HMI.  See GIS-368 for details.
 */
class SendMessageStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendMessageStart ();

    /**
     * Copy constructor
     */
    inline  SendMessageStart (const SendMessageStart &rhs);

    /**
     * All fields constructor
     */
    inline  SendMessageStart (uint8 u8CreateMessageHandle_, ::most_Msg_fi_types::T_e8_MsgFolderType e8FolderType_);

    /**
     * Destructor
     */
    inline virtual  ~SendMessageStart();

    /**
     * Assignment operator
     */
    inline SendMessageStart& operator = (const SendMessageStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendMessageStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendMessageStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendMessageStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendMessageStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8CreateMessageHandle"

    static const int kU8CreateMessageHandle = 0;

    /**
     * Clears the field "u8CreateMessageHandle".
     *
     * The field will be set to its default value. The hasU8CreateMessageHandle()
     * method will return false.
     */
    inline void clearU8CreateMessageHandle();

    /**
     * Checks whether the field "u8CreateMessageHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8CreateMessageHandle()). Otherwise it will return false.
     */
    inline bool hasU8CreateMessageHandle () const;

    /**
     * Returns the value of the member "u8CreateMessageHandle".
     *
     * Represents the handle assigned to a message that is being created and has not been sent or saved. This handle is required to keep the CreateMessage in sync with the ProvideMessageHeader, ProvideMessageBody, and SendMessage methods needed for Messaging to send or save a message.The CreateMessageHandle is temporary and shall be cleared upon the HMI receiving the ResultAck from the SendMessage method.
     *
     * @return The value of the field "u8CreateMessageHandle"
     */
    inline uint8 getU8CreateMessageHandle () const;

    /**
     * Sets the value of the member "u8CreateMessageHandle".
     *
     * Represents the handle assigned to a message that is being created and has not been sent or saved. This handle is required to keep the CreateMessage in sync with the ProvideMessageHeader, ProvideMessageBody, and SendMessage methods needed for Messaging to send or save a message.The CreateMessageHandle is temporary and shall be cleared upon the HMI receiving the ResultAck from the SendMessage method.
     *
     * @param u8CreateMessageHandle The value which will be set
     */
    inline void setU8CreateMessageHandle (uint8 u8CreateMessageHandle_);

    // API of field "e8FolderType"

    static const int kE8FolderType = 1;

    /**
     * Clears the field "e8FolderType".
     *
     * The field will be set to its default value. The hasE8FolderType()
     * method will return false.
     */
    inline void clearE8FolderType();

    /**
     * Checks whether the field "e8FolderType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8FolderType()). Otherwise it will return false.
     */
    inline bool hasE8FolderType () const;

    /**
     * Returns the value of the member "e8FolderType".
     *
     * Defines the type of folder: Inbox, Deleted, Drafts, Sent, User defined, and inaccessible.
     * The user defined folders require the FolderName to identify the name of the folder.
     * The inaccessible folders are cannot be accessed from the vehicle.
     *
     * @return The value of the field "e8FolderType"
     */
    inline ::most_Msg_fi_types::T_e8_MsgFolderType getE8FolderType () const;

    /**
     * Sets the value of the member "e8FolderType".
     *
     * Defines the type of folder: Inbox, Deleted, Drafts, Sent, User defined, and inaccessible.
     * The user defined folders require the FolderName to identify the name of the folder.
     * The inaccessible folders are cannot be accessed from the vehicle.
     *
     * @param e8FolderType The value which will be set
     */
    inline void setE8FolderType (::most_Msg_fi_types::T_e8_MsgFolderType e8FolderType_);

    static const SendMessageStart &getDefaultInstance();

private:

    inline void set_has_u8CreateMessageHandle ();

    inline void clear_has_u8CreateMessageHandle ();

    inline void set_has_e8FolderType ();

    inline void clear_has_e8FolderType ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8CreateMessageHandle;

    ::most_Msg_fi_types::T_e8_MsgFolderType _e8FolderType;

};

/**
 * The result message of the method "SendMessage"
 * This method informs Messaging that a message needs to be sent. It provides the type of message, the original MessageHandle (if applicable), the create message type (i.e. new message, reply, reply to all, or forward), and the MessageHeaderBodyHandle.
 * Note that if the message could not be sent to the Bluetooth device for transmission, the SentMessageStatus will return ERROR.  If sent successfully to the Bluetooth, but not necessarily sent successfully on the cellular network, the SUCCESS code is returned.
 * Note further that for both of these response codes, the Messaging FBlock will trigger the appropriate alert to the AlertManager FBlock for notification to the overall vehicle HMI.  See GIS-368 for details.
 */
class SendMessageResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendMessageResult ();

    /**
     * Copy constructor
     */
    inline  SendMessageResult (const SendMessageResult &rhs);

    /**
     * All fields constructor
     */
    inline  SendMessageResult (::most_Msg_fi_types::T_e8_MsgSentMessageStatus e8SentMessageStatus_, const ::most_Msg_fi_types::T_MsgMessageHandle& oMessageHandle_);

    /**
     * Destructor
     */
    inline virtual  ~SendMessageResult();

    /**
     * Assignment operator
     */
    inline SendMessageResult& operator = (const SendMessageResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendMessageResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendMessageResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendMessageResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendMessageResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8SentMessageStatus"

    static const int kE8SentMessageStatus = 0;

    /**
     * Clears the field "e8SentMessageStatus".
     *
     * The field will be set to its default value. The hasE8SentMessageStatus()
     * method will return false.
     */
    inline void clearE8SentMessageStatus();

    /**
     * Checks whether the field "e8SentMessageStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8SentMessageStatus()). Otherwise it will return false.
     */
    inline bool hasE8SentMessageStatus () const;

    /**
     * Returns the value of the member "e8SentMessageStatus".
     *
     * Identifies the status of the sent message.
     *
     * @return The value of the field "e8SentMessageStatus"
     */
    inline ::most_Msg_fi_types::T_e8_MsgSentMessageStatus getE8SentMessageStatus () const;

    /**
     * Sets the value of the member "e8SentMessageStatus".
     *
     * Identifies the status of the sent message.
     *
     * @param e8SentMessageStatus The value which will be set
     */
    inline void setE8SentMessageStatus (::most_Msg_fi_types::T_e8_MsgSentMessageStatus e8SentMessageStatus_);

    // API of field "oMessageHandle"

    static const int kOMessageHandle = 1;

    /**
     * Clears the field "oMessageHandle".
     *
     * The field will be set to its default value. The hasOMessageHandle()
     * method will return false.
     */
    inline void clearOMessageHandle();

    /**
     * Checks whether the field "oMessageHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOMessageHandle()). Otherwise it will return false.
     */
    inline bool hasOMessageHandle () const;

    /**
     * Returns the value of the member "oMessageHandle".
     *
     * This is the globally unique ID for a particular message. The ID is unique across all currently connected devices and accounts.It is made up of the DeviceHandle, MsgHandleUpper, and MsgHandleLower.
     *
     * @return The value of the field "oMessageHandle"
     */
    inline const ::most_Msg_fi_types::T_MsgMessageHandle& getOMessageHandle () const;

    /**
     * Retrieves the value of the field "oMessageHandle" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oMessageHandle".
     */
    inline ::most_Msg_fi_types::T_MsgMessageHandle& getOMessageHandleMutable ();

    /**
     * Sets the value of the member "oMessageHandle".
     *
     * This is the globally unique ID for a particular message. The ID is unique across all currently connected devices and accounts.It is made up of the DeviceHandle, MsgHandleUpper, and MsgHandleLower.
     *
     * @param oMessageHandle The value which will be set
     */
    inline void setOMessageHandle (const ::most_Msg_fi_types::T_MsgMessageHandle& oMessageHandle_);

    static const SendMessageResult &getDefaultInstance();

private:

    inline void set_has_e8SentMessageStatus ();

    inline void clear_has_e8SentMessageStatus ();

    inline void set_has_oMessageHandle ();

    inline void clear_has_oMessageHandle ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::most_Msg_fi_types::T_e8_MsgSentMessageStatus _e8SentMessageStatus;

    ::most_Msg_fi_types::T_MsgMessageHandle _oMessageHandle;

};

/**
 * The error message of 'SendMessage'
 */
class SendMessageErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SendMessageErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SendMessageErrorStructure (const SendMessageErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SendMessageErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~SendMessageErrorStructure();

    /**
     * Assignment operator
     */
    inline SendMessageErrorStructure& operator = (const SendMessageErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendMessageErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendMessageErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendMessageErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendMessageErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     *
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     *
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const SendMessageErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'SendMessage'
 */
class SendMessageError  : public ::asf::core::Payload {
public:

    enum SendMessageErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SendMessageError ();

   /**
     * Copy constructor
     */
    inline  SendMessageError (const SendMessageError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SendMessageError();

    /**
     * Assigns a new value to this object.
     */
    inline SendMessageError& operator = (const SendMessageError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendMessageError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendMessageError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendMessageError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendMessageError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SendMessageError::SendMessageErrorField getField () const;

    inline void setField(SendMessageError::SendMessageErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SendMessageErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SendMessageErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SendMessageErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SendMessageErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SendMessageErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SendMessageErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SendMessageErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SendMessageErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SendMessageError &getDefaultInstance();

private:

    inline void cloneData (const SendMessageError& rhs);

    inline void deleteData ();

    SendMessageErrorField __field;

    union {
        SendMessageErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "ProvideMessageHeader"
 * This method provides the message header for the CreateMessageHandle message to be sent.
 */
class ProvideMessageHeaderStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ProvideMessageHeaderStart ();

    /**
     * Copy constructor
     */
    inline  ProvideMessageHeaderStart (const ProvideMessageHeaderStart &rhs);

    /**
     * All fields constructor
     */
    inline  ProvideMessageHeaderStart (uint8 u8CreateMessageHandle_, const ::fi_basetypes_most::T_String& sSubject_, const ::most_Msg_fi_types::T_MsgAddressField& oAddressField_);

    /**
     * Destructor
     */
    inline virtual  ~ProvideMessageHeaderStart();

    /**
     * Assignment operator
     */
    inline ProvideMessageHeaderStart& operator = (const ProvideMessageHeaderStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ProvideMessageHeaderStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ProvideMessageHeaderStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ProvideMessageHeaderStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ProvideMessageHeaderStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8CreateMessageHandle"

    static const int kU8CreateMessageHandle = 0;

    /**
     * Clears the field "u8CreateMessageHandle".
     *
     * The field will be set to its default value. The hasU8CreateMessageHandle()
     * method will return false.
     */
    inline void clearU8CreateMessageHandle();

    /**
     * Checks whether the field "u8CreateMessageHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8CreateMessageHandle()). Otherwise it will return false.
     */
    inline bool hasU8CreateMessageHandle () const;

    /**
     * Returns the value of the member "u8CreateMessageHandle".
     *
     * Represents the handle assigned to a message that is being created and has not been sent or saved. This handle is required to keep the CreateMessage in sync with the ProvideMessageHeader, ProvideMessageBody, and SendMessage methods needed for Messaging to send or save a message.The CreateMessageHandle is temporary and shall be cleared upon the HMI receiving the ResultAck from the SendMessage method.
     *
     * @return The value of the field "u8CreateMessageHandle"
     */
    inline uint8 getU8CreateMessageHandle () const;

    /**
     * Sets the value of the member "u8CreateMessageHandle".
     *
     * Represents the handle assigned to a message that is being created and has not been sent or saved. This handle is required to keep the CreateMessage in sync with the ProvideMessageHeader, ProvideMessageBody, and SendMessage methods needed for Messaging to send or save a message.The CreateMessageHandle is temporary and shall be cleared upon the HMI receiving the ResultAck from the SendMessage method.
     *
     * @param u8CreateMessageHandle The value which will be set
     */
    inline void setU8CreateMessageHandle (uint8 u8CreateMessageHandle_);

    // API of field "sSubject"

    static const int kSSubject = 1;

    /**
     * Clears the field "sSubject".
     *
     * The field will be set to its default value. The hasSSubject()
     * method will return false.
     */
    inline void clearSSubject();

    /**
     * Checks whether the field "sSubject" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSSubject()). Otherwise it will return false.
     */
    inline bool hasSSubject () const;

    /**
     * Returns the value of the member "sSubject".
     *
     * The subject of the email message.
     *
     * @return The value of the field "sSubject"
     */
    inline const ::fi_basetypes_most::T_String& getSSubject () const;

    /**
     * Retrieves the value of the field "sSubject" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sSubject".
     */
    inline ::fi_basetypes_most::T_String& getSSubjectMutable ();

    /**
     * Sets the value of the member "sSubject".
     *
     * The subject of the email message.
     *
     * @param sSubject The value which will be set
     */
    inline void setSSubject (const ::fi_basetypes_most::T_String& sSubject_);

    // API of field "oAddressField"

    static const int kOAddressField = 2;

    /**
     * Clears the field "oAddressField".
     *
     * The field will be set to its default value. The hasOAddressField()
     * method will return false.
     */
    inline void clearOAddressField();

    /**
     * Checks whether the field "oAddressField" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOAddressField()). Otherwise it will return false.
     */
    inline bool hasOAddressField () const;

    /**
     * Returns the value of the member "oAddressField".
     *
     * Provides the field type (From, To, CC) and the sender or recipient contact information.
     *
     * @return The value of the field "oAddressField"
     */
    inline const ::most_Msg_fi_types::T_MsgAddressField& getOAddressField () const;

    /**
     * Retrieves the value of the field "oAddressField" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oAddressField".
     */
    inline ::most_Msg_fi_types::T_MsgAddressField& getOAddressFieldMutable ();

    /**
     * Sets the value of the member "oAddressField".
     *
     * Provides the field type (From, To, CC) and the sender or recipient contact information.
     *
     * @param oAddressField The value which will be set
     */
    inline void setOAddressField (const ::most_Msg_fi_types::T_MsgAddressField& oAddressField_);

    static const ProvideMessageHeaderStart &getDefaultInstance();

private:

    static const ::std::vector< ::most_Msg_fi_types::T_MsgAddressFieldItem >& getT_MsgAddressFieldItemList_DefaultInstance ();

    inline void set_has_u8CreateMessageHandle ();

    inline void clear_has_u8CreateMessageHandle ();

    inline void set_has_sSubject ();

    inline void clear_has_sSubject ();

    inline void set_has_oAddressField ();

    inline void clear_has_oAddressField ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _u8CreateMessageHandle;

    ::fi_basetypes_most::T_String _sSubject;

    ::most_Msg_fi_types::T_MsgAddressField _oAddressField;

};

/**
 * The result message of the method "ProvideMessageHeader"
 * This method provides the message header for the CreateMessageHandle message to be sent.
 */
class ProvideMessageHeaderResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ProvideMessageHeaderResult ();

    /**
     * Copy constructor
     */
    inline  ProvideMessageHeaderResult (const ProvideMessageHeaderResult &rhs);

    /**
     * All fields constructor
     */
    inline  ProvideMessageHeaderResult (uint8 u8CreateMessageHandle_);

    /**
     * Destructor
     */
    inline virtual  ~ProvideMessageHeaderResult();

    /**
     * Assignment operator
     */
    inline ProvideMessageHeaderResult& operator = (const ProvideMessageHeaderResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ProvideMessageHeaderResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ProvideMessageHeaderResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ProvideMessageHeaderResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ProvideMessageHeaderResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8CreateMessageHandle"

    static const int kU8CreateMessageHandle = 0;

    /**
     * Clears the field "u8CreateMessageHandle".
     *
     * The field will be set to its default value. The hasU8CreateMessageHandle()
     * method will return false.
     */
    inline void clearU8CreateMessageHandle();

    /**
     * Checks whether the field "u8CreateMessageHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8CreateMessageHandle()). Otherwise it will return false.
     */
    inline bool hasU8CreateMessageHandle () const;

    /**
     * Returns the value of the member "u8CreateMessageHandle".
     *
     * Represents the handle assigned to a message that is being created and has not been sent or saved. This handle is required to keep the CreateMessage in sync with the ProvideMessageHeader, ProvideMessageBody, and SendMessage methods needed for Messaging to send or save a message.The CreateMessageHandle is temporary and shall be cleared upon the HMI receiving the ResultAck from the SendMessage method.
     *
     * @return The value of the field "u8CreateMessageHandle"
     */
    inline uint8 getU8CreateMessageHandle () const;

    /**
     * Sets the value of the member "u8CreateMessageHandle".
     *
     * Represents the handle assigned to a message that is being created and has not been sent or saved. This handle is required to keep the CreateMessage in sync with the ProvideMessageHeader, ProvideMessageBody, and SendMessage methods needed for Messaging to send or save a message.The CreateMessageHandle is temporary and shall be cleared upon the HMI receiving the ResultAck from the SendMessage method.
     *
     * @param u8CreateMessageHandle The value which will be set
     */
    inline void setU8CreateMessageHandle (uint8 u8CreateMessageHandle_);

    static const ProvideMessageHeaderResult &getDefaultInstance();

private:

    inline void set_has_u8CreateMessageHandle ();

    inline void clear_has_u8CreateMessageHandle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8CreateMessageHandle;

};

/**
 * The error message of 'ProvideMessageHeader'
 */
class ProvideMessageHeaderErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  ProvideMessageHeaderErrorStructure ();

    /**
     * Copy constructor
     */
    inline  ProvideMessageHeaderErrorStructure (const ProvideMessageHeaderErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  ProvideMessageHeaderErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~ProvideMessageHeaderErrorStructure();

    /**
     * Assignment operator
     */
    inline ProvideMessageHeaderErrorStructure& operator = (const ProvideMessageHeaderErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ProvideMessageHeaderErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ProvideMessageHeaderErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ProvideMessageHeaderErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ProvideMessageHeaderErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const ProvideMessageHeaderErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'ProvideMessageHeader'
 */
class ProvideMessageHeaderError  : public ::asf::core::Payload {
public:

    enum ProvideMessageHeaderErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  ProvideMessageHeaderError ();

   /**
     * Copy constructor
     */
    inline  ProvideMessageHeaderError (const ProvideMessageHeaderError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~ProvideMessageHeaderError();

    /**
     * Assigns a new value to this object.
     */
    inline ProvideMessageHeaderError& operator = (const ProvideMessageHeaderError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ProvideMessageHeaderError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ProvideMessageHeaderError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ProvideMessageHeaderError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ProvideMessageHeaderError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline ProvideMessageHeaderError::ProvideMessageHeaderErrorField getField () const;

    inline void setField(ProvideMessageHeaderError::ProvideMessageHeaderErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "ProvideMessageHeaderErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "ProvideMessageHeaderErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ProvideMessageHeaderErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ProvideMessageHeaderErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline ProvideMessageHeaderErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (ProvideMessageHeaderErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "ProvideMessageHeaderErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const ProvideMessageHeaderErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const ProvideMessageHeaderError &getDefaultInstance();

private:

    inline void cloneData (const ProvideMessageHeaderError& rhs);

    inline void deleteData ();

    ProvideMessageHeaderErrorField __field;

    union {
        ProvideMessageHeaderErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "ProvideMessageBody"
 * This method provides the message body for the CreateMessageHandle message to be sent.
 */
class ProvideMessageBodyStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ProvideMessageBodyStart ();

    /**
     * Copy constructor
     */
    inline  ProvideMessageBodyStart (const ProvideMessageBodyStart &rhs);

    /**
     * All fields constructor
     */
    inline  ProvideMessageBodyStart (uint8 u8CreateMessageHandle_, uint16 u16RecordedAudioMessageHandle_, const ::most_Msg_fi_types::T_MsgAttachmentHandleStream& oAttachmentHandleStream_, uint16 u16NumMessageBodyTextElements_, const ::most_Msg_fi_types::T_MsgMessageBodyText& oMessageBodyText_);

    /**
     * Destructor
     */
    inline virtual  ~ProvideMessageBodyStart();

    /**
     * Assignment operator
     */
    inline ProvideMessageBodyStart& operator = (const ProvideMessageBodyStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ProvideMessageBodyStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ProvideMessageBodyStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ProvideMessageBodyStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ProvideMessageBodyStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8CreateMessageHandle"

    static const int kU8CreateMessageHandle = 0;

    /**
     * Clears the field "u8CreateMessageHandle".
     *
     * The field will be set to its default value. The hasU8CreateMessageHandle()
     * method will return false.
     */
    inline void clearU8CreateMessageHandle();

    /**
     * Checks whether the field "u8CreateMessageHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8CreateMessageHandle()). Otherwise it will return false.
     */
    inline bool hasU8CreateMessageHandle () const;

    /**
     * Returns the value of the member "u8CreateMessageHandle".
     *
     * Represents the handle assigned to a message that is being created and has not been sent or saved. This handle is required to keep the CreateMessage in sync with the ProvideMessageHeader, ProvideMessageBody, and SendMessage methods needed for Messaging to send or save a message.The CreateMessageHandle is temporary and shall be cleared upon the HMI receiving the ResultAck from the SendMessage method.
     *
     * @return The value of the field "u8CreateMessageHandle"
     */
    inline uint8 getU8CreateMessageHandle () const;

    /**
     * Sets the value of the member "u8CreateMessageHandle".
     *
     * Represents the handle assigned to a message that is being created and has not been sent or saved. This handle is required to keep the CreateMessage in sync with the ProvideMessageHeader, ProvideMessageBody, and SendMessage methods needed for Messaging to send or save a message.The CreateMessageHandle is temporary and shall be cleared upon the HMI receiving the ResultAck from the SendMessage method.
     *
     * @param u8CreateMessageHandle The value which will be set
     */
    inline void setU8CreateMessageHandle (uint8 u8CreateMessageHandle_);

    // API of field "u16RecordedAudioMessageHandle"

    static const int kU16RecordedAudioMessageHandle = 1;

    /**
     * Clears the field "u16RecordedAudioMessageHandle".
     *
     * The field will be set to its default value. The hasU16RecordedAudioMessageHandle()
     * method will return false.
     */
    inline void clearU16RecordedAudioMessageHandle();

    /**
     * Checks whether the field "u16RecordedAudioMessageHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16RecordedAudioMessageHandle()). Otherwise it will return false.
     */
    inline bool hasU16RecordedAudioMessageHandle () const;

    /**
     * Returns the value of the member "u16RecordedAudioMessageHandle".
     *
     * RecordedAudioMessageHandle = 0 is reserved to identify a NULL handle.
     *
     * @return The value of the field "u16RecordedAudioMessageHandle"
     */
    inline uint16 getU16RecordedAudioMessageHandle () const;

    /**
     * Sets the value of the member "u16RecordedAudioMessageHandle".
     *
     * RecordedAudioMessageHandle = 0 is reserved to identify a NULL handle.
     *
     * @param u16RecordedAudioMessageHandle The value which will be set
     */
    inline void setU16RecordedAudioMessageHandle (uint16 u16RecordedAudioMessageHandle_);

    // API of field "oAttachmentHandleStream"

    static const int kOAttachmentHandleStream = 2;

    /**
     * Clears the field "oAttachmentHandleStream".
     *
     * The field will be set to its default value. The hasOAttachmentHandleStream()
     * method will return false.
     */
    inline void clearOAttachmentHandleStream();

    /**
     * Checks whether the field "oAttachmentHandleStream" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOAttachmentHandleStream()). Otherwise it will return false.
     */
    inline bool hasOAttachmentHandleStream () const;

    /**
     * Returns the value of the member "oAttachmentHandleStream".
     *
     * The list of attachment handles limited to a maximum of 10 attachments.
     *
     * @return The value of the field "oAttachmentHandleStream"
     */
    inline const ::most_Msg_fi_types::T_MsgAttachmentHandleStream& getOAttachmentHandleStream () const;

    /**
     * Retrieves the value of the field "oAttachmentHandleStream" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oAttachmentHandleStream".
     */
    inline ::most_Msg_fi_types::T_MsgAttachmentHandleStream& getOAttachmentHandleStreamMutable ();

    /**
     * Sets the value of the member "oAttachmentHandleStream".
     *
     * The list of attachment handles limited to a maximum of 10 attachments.
     *
     * @param oAttachmentHandleStream The value which will be set
     */
    inline void setOAttachmentHandleStream (const ::most_Msg_fi_types::T_MsgAttachmentHandleStream& oAttachmentHandleStream_);

    // API of field "u16NumMessageBodyTextElements"

    static const int kU16NumMessageBodyTextElements = 3;

    /**
     * Clears the field "u16NumMessageBodyTextElements".
     *
     * The field will be set to its default value. The hasU16NumMessageBodyTextElements()
     * method will return false.
     */
    inline void clearU16NumMessageBodyTextElements();

    /**
     * Checks whether the field "u16NumMessageBodyTextElements" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16NumMessageBodyTextElements()). Otherwise it will return false.
     */
    inline bool hasU16NumMessageBodyTextElements () const;

    /**
     * Returns the value of the member "u16NumMessageBodyTextElements".
     *
     * The number of MessageBodyText segments within the stream.
     *
     * @return The value of the field "u16NumMessageBodyTextElements"
     */
    inline uint16 getU16NumMessageBodyTextElements () const;

    /**
     * Sets the value of the member "u16NumMessageBodyTextElements".
     *
     * The number of MessageBodyText segments within the stream.
     *
     * @param u16NumMessageBodyTextElements The value which will be set
     */
    inline void setU16NumMessageBodyTextElements (uint16 u16NumMessageBodyTextElements_);

    // API of field "oMessageBodyText"

    static const int kOMessageBodyText = 4;

    /**
     * Clears the field "oMessageBodyText".
     *
     * The field will be set to its default value. The hasOMessageBodyText()
     * method will return false.
     */
    inline void clearOMessageBodyText();

    /**
     * Checks whether the field "oMessageBodyText" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOMessageBodyText()). Otherwise it will return false.
     */
    inline bool hasOMessageBodyText () const;

    /**
     * Returns the value of the member "oMessageBodyText".
     *
     * Includes a stream of MsgBodyText parameters that together make up the complete MessageBodyText.
     *
     * @return The value of the field "oMessageBodyText"
     */
    inline const ::most_Msg_fi_types::T_MsgMessageBodyText& getOMessageBodyText () const;

    /**
     * Retrieves the value of the field "oMessageBodyText" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oMessageBodyText".
     */
    inline ::most_Msg_fi_types::T_MsgMessageBodyText& getOMessageBodyTextMutable ();

    /**
     * Sets the value of the member "oMessageBodyText".
     *
     * Includes a stream of MsgBodyText parameters that together make up the complete MessageBodyText.
     *
     * @param oMessageBodyText The value which will be set
     */
    inline void setOMessageBodyText (const ::most_Msg_fi_types::T_MsgMessageBodyText& oMessageBodyText_);

    static const ProvideMessageBodyStart &getDefaultInstance();

private:

    static const ::std::vector< uint16 >& getUint16List_DefaultInstance ();

    static const ::std::vector< ::fi_basetypes_most::T_String >& getT_StringList_DefaultInstance ();

    inline void set_has_u8CreateMessageHandle ();

    inline void clear_has_u8CreateMessageHandle ();

    inline void set_has_u16RecordedAudioMessageHandle ();

    inline void clear_has_u16RecordedAudioMessageHandle ();

    inline void set_has_oAttachmentHandleStream ();

    inline void clear_has_oAttachmentHandleStream ();

    inline void set_has_u16NumMessageBodyTextElements ();

    inline void clear_has_u16NumMessageBodyTextElements ();

    inline void set_has_oMessageBodyText ();

    inline void clear_has_oMessageBodyText ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint8 _u8CreateMessageHandle;

    uint16 _u16RecordedAudioMessageHandle;

    ::most_Msg_fi_types::T_MsgAttachmentHandleStream _oAttachmentHandleStream;

    uint16 _u16NumMessageBodyTextElements;

    ::most_Msg_fi_types::T_MsgMessageBodyText _oMessageBodyText;

};

/**
 * The result message of the method "ProvideMessageBody"
 * This method provides the message body for the CreateMessageHandle message to be sent.
 */
class ProvideMessageBodyResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ProvideMessageBodyResult ();

    /**
     * Copy constructor
     */
    inline  ProvideMessageBodyResult (const ProvideMessageBodyResult &rhs);

    /**
     * All fields constructor
     */
    inline  ProvideMessageBodyResult (uint8 u8CreateMessageHandle_);

    /**
     * Destructor
     */
    inline virtual  ~ProvideMessageBodyResult();

    /**
     * Assignment operator
     */
    inline ProvideMessageBodyResult& operator = (const ProvideMessageBodyResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ProvideMessageBodyResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ProvideMessageBodyResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ProvideMessageBodyResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ProvideMessageBodyResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8CreateMessageHandle"

    static const int kU8CreateMessageHandle = 0;

    /**
     * Clears the field "u8CreateMessageHandle".
     *
     * The field will be set to its default value. The hasU8CreateMessageHandle()
     * method will return false.
     */
    inline void clearU8CreateMessageHandle();

    /**
     * Checks whether the field "u8CreateMessageHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8CreateMessageHandle()). Otherwise it will return false.
     */
    inline bool hasU8CreateMessageHandle () const;

    /**
     * Returns the value of the member "u8CreateMessageHandle".
     *
     * Represents the handle assigned to a message that is being created and has not been sent or saved. This handle is required to keep the CreateMessage in sync with the ProvideMessageHeader, ProvideMessageBody, and SendMessage methods needed for Messaging to send or save a message.The CreateMessageHandle is temporary and shall be cleared upon the HMI receiving the ResultAck from the SendMessage method.
     *
     * @return The value of the field "u8CreateMessageHandle"
     */
    inline uint8 getU8CreateMessageHandle () const;

    /**
     * Sets the value of the member "u8CreateMessageHandle".
     *
     * Represents the handle assigned to a message that is being created and has not been sent or saved. This handle is required to keep the CreateMessage in sync with the ProvideMessageHeader, ProvideMessageBody, and SendMessage methods needed for Messaging to send or save a message.The CreateMessageHandle is temporary and shall be cleared upon the HMI receiving the ResultAck from the SendMessage method.
     *
     * @param u8CreateMessageHandle The value which will be set
     */
    inline void setU8CreateMessageHandle (uint8 u8CreateMessageHandle_);

    static const ProvideMessageBodyResult &getDefaultInstance();

private:

    inline void set_has_u8CreateMessageHandle ();

    inline void clear_has_u8CreateMessageHandle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8CreateMessageHandle;

};

/**
 * The error message of 'ProvideMessageBody'
 */
class ProvideMessageBodyErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  ProvideMessageBodyErrorStructure ();

    /**
     * Copy constructor
     */
    inline  ProvideMessageBodyErrorStructure (const ProvideMessageBodyErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  ProvideMessageBodyErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~ProvideMessageBodyErrorStructure();

    /**
     * Assignment operator
     */
    inline ProvideMessageBodyErrorStructure& operator = (const ProvideMessageBodyErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ProvideMessageBodyErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ProvideMessageBodyErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ProvideMessageBodyErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ProvideMessageBodyErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const ProvideMessageBodyErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'ProvideMessageBody'
 */
class ProvideMessageBodyError  : public ::asf::core::Payload {
public:

    enum ProvideMessageBodyErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  ProvideMessageBodyError ();

   /**
     * Copy constructor
     */
    inline  ProvideMessageBodyError (const ProvideMessageBodyError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~ProvideMessageBodyError();

    /**
     * Assigns a new value to this object.
     */
    inline ProvideMessageBodyError& operator = (const ProvideMessageBodyError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ProvideMessageBodyError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ProvideMessageBodyError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ProvideMessageBodyError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ProvideMessageBodyError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline ProvideMessageBodyError::ProvideMessageBodyErrorField getField () const;

    inline void setField(ProvideMessageBodyError::ProvideMessageBodyErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "ProvideMessageBodyErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "ProvideMessageBodyErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ProvideMessageBodyErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ProvideMessageBodyErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline ProvideMessageBodyErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (ProvideMessageBodyErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "ProvideMessageBodyErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const ProvideMessageBodyErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const ProvideMessageBodyError &getDefaultInstance();

private:

    inline void cloneData (const ProvideMessageBodyError& rhs);

    inline void deleteData ();

    ProvideMessageBodyErrorField __field;

    union {
        ProvideMessageBodyErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "GetMsgBodyActionElement"
 * This method allows the HMI to acquire information (element type and content) on a particular MsgBodyActionElementTag.
 */
class GetMsgBodyActionElementStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetMsgBodyActionElementStart ();

    /**
     * Copy constructor
     */
    inline  GetMsgBodyActionElementStart (const GetMsgBodyActionElementStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetMsgBodyActionElementStart (uint8 u8MsgBodyActionElementTag_);

    /**
     * Destructor
     */
    inline virtual  ~GetMsgBodyActionElementStart();

    /**
     * Assignment operator
     */
    inline GetMsgBodyActionElementStart& operator = (const GetMsgBodyActionElementStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetMsgBodyActionElementStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetMsgBodyActionElementStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetMsgBodyActionElementStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetMsgBodyActionElementStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8MsgBodyActionElementTag"

    static const int kU8MsgBodyActionElementTag = 0;

    /**
     * Clears the field "u8MsgBodyActionElementTag".
     *
     * The field will be set to its default value. The hasU8MsgBodyActionElementTag()
     * method will return false.
     */
    inline void clearU8MsgBodyActionElementTag();

    /**
     * Checks whether the field "u8MsgBodyActionElementTag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8MsgBodyActionElementTag()). Otherwise it will return false.
     */
    inline bool hasU8MsgBodyActionElementTag () const;

    /**
     * Returns the value of the member "u8MsgBodyActionElementTag".
     *
     * Provide the tag for an action element (i.e. phone numbers, email addresses, and addresses).
     *
     * @return The value of the field "u8MsgBodyActionElementTag"
     */
    inline uint8 getU8MsgBodyActionElementTag () const;

    /**
     * Sets the value of the member "u8MsgBodyActionElementTag".
     *
     * Provide the tag for an action element (i.e. phone numbers, email addresses, and addresses).
     *
     * @param u8MsgBodyActionElementTag The value which will be set
     */
    inline void setU8MsgBodyActionElementTag (uint8 u8MsgBodyActionElementTag_);

    static const GetMsgBodyActionElementStart &getDefaultInstance();

private:

    inline void set_has_u8MsgBodyActionElementTag ();

    inline void clear_has_u8MsgBodyActionElementTag ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8MsgBodyActionElementTag;

};

/**
 * The result message of the method "GetMsgBodyActionElement"
 * This method allows the HMI to acquire information (element type and content) on a particular MsgBodyActionElementTag.
 */
class GetMsgBodyActionElementResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetMsgBodyActionElementResult ();

    /**
     * Copy constructor
     */
    inline  GetMsgBodyActionElementResult (const GetMsgBodyActionElementResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetMsgBodyActionElementResult (::most_Msg_fi_types::T_e8_MsgActionElementType e8ActionElementType_, const ::fi_basetypes_most::T_String& sPhoneNumber_, const ::fi_basetypes_most::T_String& sEmailAddress_, const ::fi_basetypes_most::T_String& sAddress_);

    /**
     * Destructor
     */
    inline virtual  ~GetMsgBodyActionElementResult();

    /**
     * Assignment operator
     */
    inline GetMsgBodyActionElementResult& operator = (const GetMsgBodyActionElementResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetMsgBodyActionElementResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetMsgBodyActionElementResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetMsgBodyActionElementResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetMsgBodyActionElementResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ActionElementType"

    static const int kE8ActionElementType = 0;

    /**
     * Clears the field "e8ActionElementType".
     *
     * The field will be set to its default value. The hasE8ActionElementType()
     * method will return false.
     */
    inline void clearE8ActionElementType();

    /**
     * Checks whether the field "e8ActionElementType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ActionElementType()). Otherwise it will return false.
     */
    inline bool hasE8ActionElementType () const;

    /**
     * Returns the value of the member "e8ActionElementType".
     *
     *
     *
     * @return The value of the field "e8ActionElementType"
     */
    inline ::most_Msg_fi_types::T_e8_MsgActionElementType getE8ActionElementType () const;

    /**
     * Sets the value of the member "e8ActionElementType".
     *
     *
     *
     * @param e8ActionElementType The value which will be set
     */
    inline void setE8ActionElementType (::most_Msg_fi_types::T_e8_MsgActionElementType e8ActionElementType_);

    // API of field "sPhoneNumber"

    static const int kSPhoneNumber = 1;

    /**
     * Clears the field "sPhoneNumber".
     *
     * The field will be set to its default value. The hasSPhoneNumber()
     * method will return false.
     */
    inline void clearSPhoneNumber();

    /**
     * Checks whether the field "sPhoneNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPhoneNumber()). Otherwise it will return false.
     */
    inline bool hasSPhoneNumber () const;

    /**
     * Returns the value of the member "sPhoneNumber".
     *
     *
     *
     * @return The value of the field "sPhoneNumber"
     */
    inline const ::fi_basetypes_most::T_String& getSPhoneNumber () const;

    /**
     * Retrieves the value of the field "sPhoneNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sPhoneNumber".
     */
    inline ::fi_basetypes_most::T_String& getSPhoneNumberMutable ();

    /**
     * Sets the value of the member "sPhoneNumber".
     *
     *
     *
     * @param sPhoneNumber The value which will be set
     */
    inline void setSPhoneNumber (const ::fi_basetypes_most::T_String& sPhoneNumber_);

    // API of field "sEmailAddress"

    static const int kSEmailAddress = 2;

    /**
     * Clears the field "sEmailAddress".
     *
     * The field will be set to its default value. The hasSEmailAddress()
     * method will return false.
     */
    inline void clearSEmailAddress();

    /**
     * Checks whether the field "sEmailAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSEmailAddress()). Otherwise it will return false.
     */
    inline bool hasSEmailAddress () const;

    /**
     * Returns the value of the member "sEmailAddress".
     *
     *
     *
     * @return The value of the field "sEmailAddress"
     */
    inline const ::fi_basetypes_most::T_String& getSEmailAddress () const;

    /**
     * Retrieves the value of the field "sEmailAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sEmailAddress".
     */
    inline ::fi_basetypes_most::T_String& getSEmailAddressMutable ();

    /**
     * Sets the value of the member "sEmailAddress".
     *
     *
     *
     * @param sEmailAddress The value which will be set
     */
    inline void setSEmailAddress (const ::fi_basetypes_most::T_String& sEmailAddress_);

    // API of field "sAddress"

    static const int kSAddress = 3;

    /**
     * Clears the field "sAddress".
     *
     * The field will be set to its default value. The hasSAddress()
     * method will return false.
     */
    inline void clearSAddress();

    /**
     * Checks whether the field "sAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSAddress()). Otherwise it will return false.
     */
    inline bool hasSAddress () const;

    /**
     * Returns the value of the member "sAddress".
     *
     *
     *
     * @return The value of the field "sAddress"
     */
    inline const ::fi_basetypes_most::T_String& getSAddress () const;

    /**
     * Retrieves the value of the field "sAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sAddress".
     */
    inline ::fi_basetypes_most::T_String& getSAddressMutable ();

    /**
     * Sets the value of the member "sAddress".
     *
     *
     *
     * @param sAddress The value which will be set
     */
    inline void setSAddress (const ::fi_basetypes_most::T_String& sAddress_);

    static const GetMsgBodyActionElementResult &getDefaultInstance();

private:

    inline void set_has_e8ActionElementType ();

    inline void clear_has_e8ActionElementType ();

    inline void set_has_sPhoneNumber ();

    inline void clear_has_sPhoneNumber ();

    inline void set_has_sEmailAddress ();

    inline void clear_has_sEmailAddress ();

    inline void set_has_sAddress ();

    inline void clear_has_sAddress ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::most_Msg_fi_types::T_e8_MsgActionElementType _e8ActionElementType;

    ::fi_basetypes_most::T_String _sPhoneNumber;

    ::fi_basetypes_most::T_String _sEmailAddress;

    ::fi_basetypes_most::T_String _sAddress;

};

/**
 * The error message of 'GetMsgBodyActionElement'
 */
class GetMsgBodyActionElementErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetMsgBodyActionElementErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetMsgBodyActionElementErrorStructure (const GetMsgBodyActionElementErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetMsgBodyActionElementErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~GetMsgBodyActionElementErrorStructure();

    /**
     * Assignment operator
     */
    inline GetMsgBodyActionElementErrorStructure& operator = (const GetMsgBodyActionElementErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetMsgBodyActionElementErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetMsgBodyActionElementErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetMsgBodyActionElementErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetMsgBodyActionElementErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const GetMsgBodyActionElementErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'GetMsgBodyActionElement'
 */
class GetMsgBodyActionElementError  : public ::asf::core::Payload {
public:

    enum GetMsgBodyActionElementErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetMsgBodyActionElementError ();

   /**
     * Copy constructor
     */
    inline  GetMsgBodyActionElementError (const GetMsgBodyActionElementError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetMsgBodyActionElementError();

    /**
     * Assigns a new value to this object.
     */
    inline GetMsgBodyActionElementError& operator = (const GetMsgBodyActionElementError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetMsgBodyActionElementError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetMsgBodyActionElementError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetMsgBodyActionElementError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetMsgBodyActionElementError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetMsgBodyActionElementError::GetMsgBodyActionElementErrorField getField () const;

    inline void setField(GetMsgBodyActionElementError::GetMsgBodyActionElementErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetMsgBodyActionElementErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetMsgBodyActionElementErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetMsgBodyActionElementErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetMsgBodyActionElementErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetMsgBodyActionElementErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetMsgBodyActionElementErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetMsgBodyActionElementErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetMsgBodyActionElementErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetMsgBodyActionElementError &getDefaultInstance();

private:

    inline void cloneData (const GetMsgBodyActionElementError& rhs);

    inline void deleteData ();

    GetMsgBodyActionElementErrorField __field;

    union {
        GetMsgBodyActionElementErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "GetImageAttachmentInfo"
 * Acquires the MIME image subtype and the size of an attached image identified by its AttachmentHandle. If the MIMEImageSubtype = NULL then there is no photo associated with the AttachmentHandle.
 */
class GetImageAttachmentInfoStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetImageAttachmentInfoStart ();

    /**
     * Copy constructor
     */
    inline  GetImageAttachmentInfoStart (const GetImageAttachmentInfoStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetImageAttachmentInfoStart (uint16 u16AttachmentHandle_);

    /**
     * Destructor
     */
    inline virtual  ~GetImageAttachmentInfoStart();

    /**
     * Assignment operator
     */
    inline GetImageAttachmentInfoStart& operator = (const GetImageAttachmentInfoStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetImageAttachmentInfoStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetImageAttachmentInfoStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetImageAttachmentInfoStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetImageAttachmentInfoStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16AttachmentHandle"

    static const int kU16AttachmentHandle = 0;

    /**
     * Clears the field "u16AttachmentHandle".
     *
     * The field will be set to its default value. The hasU16AttachmentHandle()
     * method will return false.
     */
    inline void clearU16AttachmentHandle();

    /**
     * Checks whether the field "u16AttachmentHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16AttachmentHandle()). Otherwise it will return false.
     */
    inline bool hasU16AttachmentHandle () const;

    /**
     * Returns the value of the member "u16AttachmentHandle".
     *
     * This is the handle for a particular attachment.  The handle is locally unique only for a particular message and is not required to be globally unique.
     *
     * @return The value of the field "u16AttachmentHandle"
     */
    inline uint16 getU16AttachmentHandle () const;

    /**
     * Sets the value of the member "u16AttachmentHandle".
     *
     * This is the handle for a particular attachment.  The handle is locally unique only for a particular message and is not required to be globally unique.
     *
     * @param u16AttachmentHandle The value which will be set
     */
    inline void setU16AttachmentHandle (uint16 u16AttachmentHandle_);

    static const GetImageAttachmentInfoStart &getDefaultInstance();

private:

    inline void set_has_u16AttachmentHandle ();

    inline void clear_has_u16AttachmentHandle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16AttachmentHandle;

};

/**
 * The result message of the method "GetImageAttachmentInfo"
 * Acquires the MIME image subtype and the size of an attached image identified by its AttachmentHandle. If the MIMEImageSubtype = NULL then there is no photo associated with the AttachmentHandle.
 */
class GetImageAttachmentInfoResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetImageAttachmentInfoResult ();

    /**
     * Copy constructor
     */
    inline  GetImageAttachmentInfoResult (const GetImageAttachmentInfoResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetImageAttachmentInfoResult (const ::fi_basetypes_most::T_String& sMIMEImageSubtype_, uint32 u32ImageSize_);

    /**
     * Destructor
     */
    inline virtual  ~GetImageAttachmentInfoResult();

    /**
     * Assignment operator
     */
    inline GetImageAttachmentInfoResult& operator = (const GetImageAttachmentInfoResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetImageAttachmentInfoResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetImageAttachmentInfoResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetImageAttachmentInfoResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetImageAttachmentInfoResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sMIMEImageSubtype"

    static const int kSMIMEImageSubtype = 0;

    /**
     * Clears the field "sMIMEImageSubtype".
     *
     * The field will be set to its default value. The hasSMIMEImageSubtype()
     * method will return false.
     */
    inline void clearSMIMEImageSubtype();

    /**
     * Checks whether the field "sMIMEImageSubtype" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSMIMEImageSubtype()). Otherwise it will return false.
     */
    inline bool hasSMIMEImageSubtype () const;

    /**
     * Returns the value of the member "sMIMEImageSubtype".
     *
     * Identifies the MIME image subtype
     *
     * @return The value of the field "sMIMEImageSubtype"
     */
    inline const ::fi_basetypes_most::T_String& getSMIMEImageSubtype () const;

    /**
     * Retrieves the value of the field "sMIMEImageSubtype" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sMIMEImageSubtype".
     */
    inline ::fi_basetypes_most::T_String& getSMIMEImageSubtypeMutable ();

    /**
     * Sets the value of the member "sMIMEImageSubtype".
     *
     * Identifies the MIME image subtype
     *
     * @param sMIMEImageSubtype The value which will be set
     */
    inline void setSMIMEImageSubtype (const ::fi_basetypes_most::T_String& sMIMEImageSubtype_);

    // API of field "u32ImageSize"

    static const int kU32ImageSize = 1;

    /**
     * Clears the field "u32ImageSize".
     *
     * The field will be set to its default value. The hasU32ImageSize()
     * method will return false.
     */
    inline void clearU32ImageSize();

    /**
     * Checks whether the field "u32ImageSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ImageSize()). Otherwise it will return false.
     */
    inline bool hasU32ImageSize () const;

    /**
     * Returns the value of the member "u32ImageSize".
     *
     * The size of the image in Bytes
     *
     * @return The value of the field "u32ImageSize"
     */
    inline uint32 getU32ImageSize () const;

    /**
     * Sets the value of the member "u32ImageSize".
     *
     * The size of the image in Bytes
     *
     * @param u32ImageSize The value which will be set
     */
    inline void setU32ImageSize (uint32 u32ImageSize_);

    static const GetImageAttachmentInfoResult &getDefaultInstance();

private:

    inline void set_has_sMIMEImageSubtype ();

    inline void clear_has_sMIMEImageSubtype ();

    inline void set_has_u32ImageSize ();

    inline void clear_has_u32ImageSize ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_String _sMIMEImageSubtype;

    uint32 _u32ImageSize;

};

/**
 * The error message of 'GetImageAttachmentInfo'
 */
class GetImageAttachmentInfoErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetImageAttachmentInfoErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetImageAttachmentInfoErrorStructure (const GetImageAttachmentInfoErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetImageAttachmentInfoErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~GetImageAttachmentInfoErrorStructure();

    /**
     * Assignment operator
     */
    inline GetImageAttachmentInfoErrorStructure& operator = (const GetImageAttachmentInfoErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetImageAttachmentInfoErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetImageAttachmentInfoErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetImageAttachmentInfoErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetImageAttachmentInfoErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     *
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     *
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     *
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     *
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const GetImageAttachmentInfoErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'GetImageAttachmentInfo'
 */
class GetImageAttachmentInfoError  : public ::asf::core::Payload {
public:

    enum GetImageAttachmentInfoErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetImageAttachmentInfoError ();

   /**
     * Copy constructor
     */
    inline  GetImageAttachmentInfoError (const GetImageAttachmentInfoError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetImageAttachmentInfoError();

    /**
     * Assigns a new value to this object.
     */
    inline GetImageAttachmentInfoError& operator = (const GetImageAttachmentInfoError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetImageAttachmentInfoError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetImageAttachmentInfoError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetImageAttachmentInfoError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetImageAttachmentInfoError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetImageAttachmentInfoError::GetImageAttachmentInfoErrorField getField () const;

    inline void setField(GetImageAttachmentInfoError::GetImageAttachmentInfoErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetImageAttachmentInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetImageAttachmentInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetImageAttachmentInfoErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetImageAttachmentInfoErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetImageAttachmentInfoErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetImageAttachmentInfoErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetImageAttachmentInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetImageAttachmentInfoErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetImageAttachmentInfoError &getDefaultInstance();

private:

    inline void cloneData (const GetImageAttachmentInfoError& rhs);

    inline void deleteData ();

    GetImageAttachmentInfoErrorField __field;

    union {
        GetImageAttachmentInfoErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "CreateMessage"
 * This function is the first of four functions used in sending a message. The CreateMessage function identifies the type of message (SMS, MMS, or Email)
 * to be sent and whether the message is new, a reply, or a forward. If the message to be sent is a reply or a forward the original message handle is included.
 * Additionally, the CreateMessage function identifies the CreateMessageHandle which will allow the ProvideMessageHeader, ProvideMessageBody, and SendMessage
 * functions to stay in sync and ultimately send the created message.
 */
class CreateMessageStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CreateMessageStart ();

    /**
     * Copy constructor
     */
    inline  CreateMessageStart (const CreateMessageStart &rhs);

    /**
     * All fields constructor
     */
    inline  CreateMessageStart (uint8 u8CreateMessageHandle_, const ::most_Msg_fi_types::T_MsgMessageHandle& oMessageHandle_, ::most_Msg_fi_types::T_e8_MsgMessageType e8MessageType_, ::most_Msg_fi_types::T_e8_MsgCreateMessageType e8CreateMessageType_);

    /**
     * Destructor
     */
    inline virtual  ~CreateMessageStart();

    /**
     * Assignment operator
     */
    inline CreateMessageStart& operator = (const CreateMessageStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreateMessageStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreateMessageStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreateMessageStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreateMessageStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8CreateMessageHandle"

    static const int kU8CreateMessageHandle = 0;

    /**
     * Clears the field "u8CreateMessageHandle".
     *
     * The field will be set to its default value. The hasU8CreateMessageHandle()
     * method will return false.
     */
    inline void clearU8CreateMessageHandle();

    /**
     * Checks whether the field "u8CreateMessageHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8CreateMessageHandle()). Otherwise it will return false.
     */
    inline bool hasU8CreateMessageHandle () const;

    /**
     * Returns the value of the member "u8CreateMessageHandle".
     *
     * Represents the handle assigned to a message that is being created and has not been sent or saved. This handle is required to keep the CreateMessage in sync with the ProvideMessageHeader, ProvideMessageBody, and SendMessage methods needed for Messaging to send or save a message.The CreateMessageHandle is temporary and shall be cleared upon the HMI receiving the ResultAck from the SendMessage method.
     *
     * @return The value of the field "u8CreateMessageHandle"
     */
    inline uint8 getU8CreateMessageHandle () const;

    /**
     * Sets the value of the member "u8CreateMessageHandle".
     *
     * Represents the handle assigned to a message that is being created and has not been sent or saved. This handle is required to keep the CreateMessage in sync with the ProvideMessageHeader, ProvideMessageBody, and SendMessage methods needed for Messaging to send or save a message.The CreateMessageHandle is temporary and shall be cleared upon the HMI receiving the ResultAck from the SendMessage method.
     *
     * @param u8CreateMessageHandle The value which will be set
     */
    inline void setU8CreateMessageHandle (uint8 u8CreateMessageHandle_);

    // API of field "oMessageHandle"

    static const int kOMessageHandle = 1;

    /**
     * Clears the field "oMessageHandle".
     *
     * The field will be set to its default value. The hasOMessageHandle()
     * method will return false.
     */
    inline void clearOMessageHandle();

    /**
     * Checks whether the field "oMessageHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOMessageHandle()). Otherwise it will return false.
     */
    inline bool hasOMessageHandle () const;

    /**
     * Returns the value of the member "oMessageHandle".
     *
     * This is the globally unique ID for a particular message. The ID is unique across all currently connected devices and accounts.It is made up of the DeviceHandle, MsgHandleUpper, and MsgHandleLower.
     *
     * @return The value of the field "oMessageHandle"
     */
    inline const ::most_Msg_fi_types::T_MsgMessageHandle& getOMessageHandle () const;

    /**
     * Retrieves the value of the field "oMessageHandle" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oMessageHandle".
     */
    inline ::most_Msg_fi_types::T_MsgMessageHandle& getOMessageHandleMutable ();

    /**
     * Sets the value of the member "oMessageHandle".
     *
     * This is the globally unique ID for a particular message. The ID is unique across all currently connected devices and accounts.It is made up of the DeviceHandle, MsgHandleUpper, and MsgHandleLower.
     *
     * @param oMessageHandle The value which will be set
     */
    inline void setOMessageHandle (const ::most_Msg_fi_types::T_MsgMessageHandle& oMessageHandle_);

    // API of field "e8MessageType"

    static const int kE8MessageType = 2;

    /**
     * Clears the field "e8MessageType".
     *
     * The field will be set to its default value. The hasE8MessageType()
     * method will return false.
     */
    inline void clearE8MessageType();

    /**
     * Checks whether the field "e8MessageType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MessageType()). Otherwise it will return false.
     */
    inline bool hasE8MessageType () const;

    /**
     * Returns the value of the member "e8MessageType".
     *
     * Identifies the type of message: SMS, MMS, or Email.
     *
     * @return The value of the field "e8MessageType"
     */
    inline ::most_Msg_fi_types::T_e8_MsgMessageType getE8MessageType () const;

    /**
     * Sets the value of the member "e8MessageType".
     *
     * Identifies the type of message: SMS, MMS, or Email.
     *
     * @param e8MessageType The value which will be set
     */
    inline void setE8MessageType (::most_Msg_fi_types::T_e8_MsgMessageType e8MessageType_);

    // API of field "e8CreateMessageType"

    static const int kE8CreateMessageType = 3;

    /**
     * Clears the field "e8CreateMessageType".
     *
     * The field will be set to its default value. The hasE8CreateMessageType()
     * method will return false.
     */
    inline void clearE8CreateMessageType();

    /**
     * Checks whether the field "e8CreateMessageType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8CreateMessageType()). Otherwise it will return false.
     */
    inline bool hasE8CreateMessageType () const;

    /**
     * Returns the value of the member "e8CreateMessageType".
     *
     * Identifies the create message type.
     *
     * @return The value of the field "e8CreateMessageType"
     */
    inline ::most_Msg_fi_types::T_e8_MsgCreateMessageType getE8CreateMessageType () const;

    /**
     * Sets the value of the member "e8CreateMessageType".
     *
     * Identifies the create message type.
     *
     * @param e8CreateMessageType The value which will be set
     */
    inline void setE8CreateMessageType (::most_Msg_fi_types::T_e8_MsgCreateMessageType e8CreateMessageType_);

    static const CreateMessageStart &getDefaultInstance();

private:

    inline void set_has_u8CreateMessageHandle ();

    inline void clear_has_u8CreateMessageHandle ();

    inline void set_has_oMessageHandle ();

    inline void clear_has_oMessageHandle ();

    inline void set_has_e8MessageType ();

    inline void clear_has_e8MessageType ();

    inline void set_has_e8CreateMessageType ();

    inline void clear_has_e8CreateMessageType ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint8 _u8CreateMessageHandle;

    ::most_Msg_fi_types::T_MsgMessageHandle _oMessageHandle;

    ::most_Msg_fi_types::T_e8_MsgMessageType _e8MessageType;

    ::most_Msg_fi_types::T_e8_MsgCreateMessageType _e8CreateMessageType;

};

/**
 * The result message of the method "CreateMessage"
 * This function is the first of four functions used in sending a message. The CreateMessage function identifies the type of message (SMS, MMS, or Email)
 * to be sent and whether the message is new, a reply, or a forward. If the message to be sent is a reply or a forward the original message handle is included.
 * Additionally, the CreateMessage function identifies the CreateMessageHandle which will allow the ProvideMessageHeader, ProvideMessageBody, and SendMessage
 * functions to stay in sync and ultimately send the created message.
 */
class CreateMessageResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CreateMessageResult ();

    /**
     * Copy constructor
     */
    inline  CreateMessageResult (const CreateMessageResult &rhs);

    /**
     * All fields constructor
     */
    inline  CreateMessageResult (uint8 u8CreateMessageHandle_);

    /**
     * Destructor
     */
    inline virtual  ~CreateMessageResult();

    /**
     * Assignment operator
     */
    inline CreateMessageResult& operator = (const CreateMessageResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreateMessageResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreateMessageResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreateMessageResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreateMessageResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8CreateMessageHandle"

    static const int kU8CreateMessageHandle = 0;

    /**
     * Clears the field "u8CreateMessageHandle".
     *
     * The field will be set to its default value. The hasU8CreateMessageHandle()
     * method will return false.
     */
    inline void clearU8CreateMessageHandle();

    /**
     * Checks whether the field "u8CreateMessageHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8CreateMessageHandle()). Otherwise it will return false.
     */
    inline bool hasU8CreateMessageHandle () const;

    /**
     * Returns the value of the member "u8CreateMessageHandle".
     *
     * Represents the handle assigned to a message that is being created and has not been sent or saved. This handle is required to keep the CreateMessage in sync with the ProvideMessageHeader, ProvideMessageBody, and SendMessage methods needed for Messaging to send or save a message.The CreateMessageHandle is temporary and shall be cleared upon the HMI receiving the ResultAck from the SendMessage method.
     *
     * @return The value of the field "u8CreateMessageHandle"
     */
    inline uint8 getU8CreateMessageHandle () const;

    /**
     * Sets the value of the member "u8CreateMessageHandle".
     *
     * Represents the handle assigned to a message that is being created and has not been sent or saved. This handle is required to keep the CreateMessage in sync with the ProvideMessageHeader, ProvideMessageBody, and SendMessage methods needed for Messaging to send or save a message.The CreateMessageHandle is temporary and shall be cleared upon the HMI receiving the ResultAck from the SendMessage method.
     *
     * @param u8CreateMessageHandle The value which will be set
     */
    inline void setU8CreateMessageHandle (uint8 u8CreateMessageHandle_);

    static const CreateMessageResult &getDefaultInstance();

private:

    inline void set_has_u8CreateMessageHandle ();

    inline void clear_has_u8CreateMessageHandle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8CreateMessageHandle;

};

/**
 * The error message of 'CreateMessage'
 */
class CreateMessageErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  CreateMessageErrorStructure ();

    /**
     * Copy constructor
     */
    inline  CreateMessageErrorStructure (const CreateMessageErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  CreateMessageErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~CreateMessageErrorStructure();

    /**
     * Assignment operator
     */
    inline CreateMessageErrorStructure& operator = (const CreateMessageErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreateMessageErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreateMessageErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreateMessageErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreateMessageErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Default MOST ErrorCode parameter for functions that do not have IMessaging-specific error codes.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const CreateMessageErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'CreateMessage'
 */
class CreateMessageError  : public ::asf::core::Payload {
public:

    enum CreateMessageErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  CreateMessageError ();

   /**
     * Copy constructor
     */
    inline  CreateMessageError (const CreateMessageError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~CreateMessageError();

    /**
     * Assigns a new value to this object.
     */
    inline CreateMessageError& operator = (const CreateMessageError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreateMessageError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreateMessageError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreateMessageError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreateMessageError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline CreateMessageError::CreateMessageErrorField getField () const;

    inline void setField(CreateMessageError::CreateMessageErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "CreateMessageErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "CreateMessageErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const CreateMessageErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline CreateMessageErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline CreateMessageErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (CreateMessageErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "CreateMessageErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const CreateMessageErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const CreateMessageError &getDefaultInstance();

private:

    inline void cloneData (const CreateMessageError& rhs);

    inline void deleteData ();

    CreateMessageErrorField __field;

    union {
        CreateMessageErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The error message of 'ClearUserMessagingInfo'
 */
class ClearUserMessagingInfoErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  ClearUserMessagingInfoErrorStructure ();

    /**
     * Copy constructor
     */
    inline  ClearUserMessagingInfoErrorStructure (const ClearUserMessagingInfoErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  ClearUserMessagingInfoErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~ClearUserMessagingInfoErrorStructure();

    /**
     * Assignment operator
     */
    inline ClearUserMessagingInfoErrorStructure& operator = (const ClearUserMessagingInfoErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ClearUserMessagingInfoErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ClearUserMessagingInfoErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ClearUserMessagingInfoErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ClearUserMessagingInfoErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     *
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     *
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * See definition of ErrorInfo for specific ErrorCodes in the FBlock description.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const ClearUserMessagingInfoErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'ClearUserMessagingInfo'
 */
class ClearUserMessagingInfoError  : public ::asf::core::Payload {
public:

    enum ClearUserMessagingInfoErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  ClearUserMessagingInfoError ();

   /**
     * Copy constructor
     */
    inline  ClearUserMessagingInfoError (const ClearUserMessagingInfoError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~ClearUserMessagingInfoError();

    /**
     * Assigns a new value to this object.
     */
    inline ClearUserMessagingInfoError& operator = (const ClearUserMessagingInfoError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ClearUserMessagingInfoError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ClearUserMessagingInfoError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ClearUserMessagingInfoError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ClearUserMessagingInfoError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline ClearUserMessagingInfoError::ClearUserMessagingInfoErrorField getField () const;

    inline void setField(ClearUserMessagingInfoError::ClearUserMessagingInfoErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "ClearUserMessagingInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "ClearUserMessagingInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ClearUserMessagingInfoErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ClearUserMessagingInfoErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline ClearUserMessagingInfoErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (ClearUserMessagingInfoErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "ClearUserMessagingInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const ClearUserMessagingInfoErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const ClearUserMessagingInfoError &getDefaultInstance();

private:

    inline void cloneData (const ClearUserMessagingInfoError& rhs);

    inline void deleteData ();

    ClearUserMessagingInfoErrorField __field;

    union {
        ClearUserMessagingInfoErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "MapDeviceCapabilities"
 * This property MapDeviceCapabilities has become DEPRECATED.
 * HMI Controllers are recommended to register for MapDeviceCapabilitiesExtended, since it already includes the functionalities of MapDeviceCapabilities.
 *
 * This Property will update the MAP capabilities of the connected device like the supported message types of the MAP connected phone along with the MAP features supported.
 */
class MapDeviceCapabilitiesStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MapDeviceCapabilitiesStatus ();

    /**
     * Copy constructor
     */
    inline  MapDeviceCapabilitiesStatus (const MapDeviceCapabilitiesStatus &rhs);

    /**
     * All fields constructor
     */
    inline  MapDeviceCapabilitiesStatus (uint8 u8DeviceHandle_, uint16 u16SupportedMessageTypes_, uint16 u16SupportedMapFeatures_, ::most_Msg_fi_types_Extended::T_e8_MapConnectionStatus e8MapConnectionState_, const ::most_Msg_fi_types::T_MsgActiveAccount& oActiveAccount_);

    /**
     * Destructor
     */
    inline virtual  ~MapDeviceCapabilitiesStatus();

    /**
     * Assignment operator
     */
    inline MapDeviceCapabilitiesStatus& operator = (const MapDeviceCapabilitiesStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MapDeviceCapabilitiesStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MapDeviceCapabilitiesStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MapDeviceCapabilitiesStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MapDeviceCapabilitiesStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Handle of the device for the MAP connected phone.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Handle of the device for the MAP connected phone.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "u16SupportedMessageTypes"

    static const int kU16SupportedMessageTypes = 1;

    /**
     * Clears the field "u16SupportedMessageTypes".
     *
     * The field will be set to its default value. The hasU16SupportedMessageTypes()
     * method will return false.
     */
    inline void clearU16SupportedMessageTypes();

    /**
     * Checks whether the field "u16SupportedMessageTypes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16SupportedMessageTypes()). Otherwise it will return false.
     */
    inline bool hasU16SupportedMessageTypes () const;

    /**
     * Returns the value of the member "u16SupportedMessageTypes".
     *
     * The Supported Message types indicate what all message types are supported like SMS, MMS, etc.
     *
     * @return The value of the field "u16SupportedMessageTypes"
     */
    inline uint16 getU16SupportedMessageTypes () const;

    /**
     * Sets the value of the member "u16SupportedMessageTypes".
     *
     * The Supported Message types indicate what all message types are supported like SMS, MMS, etc.
     *
     * @param u16SupportedMessageTypes The value which will be set
     */
    inline void setU16SupportedMessageTypes (uint16 u16SupportedMessageTypes_);

    // API of field "u16SupportedMapFeatures"

    static const int kU16SupportedMapFeatures = 2;

    /**
     * Clears the field "u16SupportedMapFeatures".
     *
     * The field will be set to its default value. The hasU16SupportedMapFeatures()
     * method will return false.
     */
    inline void clearU16SupportedMapFeatures();

    /**
     * Checks whether the field "u16SupportedMapFeatures" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16SupportedMapFeatures()). Otherwise it will return false.
     */
    inline bool hasU16SupportedMapFeatures () const;

    /**
     * Returns the value of the member "u16SupportedMapFeatures".
     *
     * The Supported MAP features indicate the MAP supported features in the connected device.
     *
     * @return The value of the field "u16SupportedMapFeatures"
     */
    inline uint16 getU16SupportedMapFeatures () const;

    /**
     * Sets the value of the member "u16SupportedMapFeatures".
     *
     * The Supported MAP features indicate the MAP supported features in the connected device.
     *
     * @param u16SupportedMapFeatures The value which will be set
     */
    inline void setU16SupportedMapFeatures (uint16 u16SupportedMapFeatures_);

    // API of field "e8MapConnectionState"

    static const int kE8MapConnectionState = 3;

    /**
     * Clears the field "e8MapConnectionState".
     *
     * The field will be set to its default value. The hasE8MapConnectionState()
     * method will return false.
     */
    inline void clearE8MapConnectionState();

    /**
     * Checks whether the field "e8MapConnectionState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MapConnectionState()). Otherwise it will return false.
     */
    inline bool hasE8MapConnectionState () const;

    /**
     * Returns the value of the member "e8MapConnectionState".
     *
     * Indicates the MAP connection status in the connection device.
     *
     * @return The value of the field "e8MapConnectionState"
     */
    inline ::most_Msg_fi_types_Extended::T_e8_MapConnectionStatus getE8MapConnectionState () const;

    /**
     * Sets the value of the member "e8MapConnectionState".
     *
     * Indicates the MAP connection status in the connection device.
     *
     * @param e8MapConnectionState The value which will be set
     */
    inline void setE8MapConnectionState (::most_Msg_fi_types_Extended::T_e8_MapConnectionStatus e8MapConnectionState_);

    // API of field "oActiveAccount"

    static const int kOActiveAccount = 4;

    /**
     * Clears the field "oActiveAccount".
     *
     * The field will be set to its default value. The hasOActiveAccount()
     * method will return false.
     */
    inline void clearOActiveAccount();

    /**
     * Checks whether the field "oActiveAccount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOActiveAccount()). Otherwise it will return false.
     */
    inline bool hasOActiveAccount () const;

    /**
     * Returns the value of the member "oActiveAccount".
     *
     * Identifies the active email account.
     *
     * @return The value of the field "oActiveAccount"
     */
    inline const ::most_Msg_fi_types::T_MsgActiveAccount& getOActiveAccount () const;

    /**
     * Retrieves the value of the field "oActiveAccount" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oActiveAccount".
     */
    inline ::most_Msg_fi_types::T_MsgActiveAccount& getOActiveAccountMutable ();

    /**
     * Sets the value of the member "oActiveAccount".
     *
     * Identifies the active email account.
     *
     * @param oActiveAccount The value which will be set
     */
    inline void setOActiveAccount (const ::most_Msg_fi_types::T_MsgActiveAccount& oActiveAccount_);

    static const MapDeviceCapabilitiesStatus &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_u16SupportedMessageTypes ();

    inline void clear_has_u16SupportedMessageTypes ();

    inline void set_has_u16SupportedMapFeatures ();

    inline void clear_has_u16SupportedMapFeatures ();

    inline void set_has_e8MapConnectionState ();

    inline void clear_has_e8MapConnectionState ();

    inline void set_has_oActiveAccount ();

    inline void clear_has_oActiveAccount ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint8 _u8DeviceHandle;

    uint16 _u16SupportedMessageTypes;

    uint16 _u16SupportedMapFeatures;

    ::most_Msg_fi_types_Extended::T_e8_MapConnectionStatus _e8MapConnectionState;

    ::most_Msg_fi_types::T_MsgActiveAccount _oActiveAccount;

};

/**
 * The status message of the property "MessagingOnOff"
 * This Property will switch ON / OFF the Message Access Profile (MAP). This is a general setting which will affect all the phones. When disabled no MAP will be connected.
 */
class MessagingOnOffStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MessagingOnOffStatus ();

    /**
     * Copy constructor
     */
    inline  MessagingOnOffStatus (const MessagingOnOffStatus &rhs);

    /**
     * All fields constructor
     */
    inline  MessagingOnOffStatus (bool MapOnOff_);

    /**
     * Destructor
     */
    inline virtual  ~MessagingOnOffStatus();

    /**
     * Assignment operator
     */
    inline MessagingOnOffStatus& operator = (const MessagingOnOffStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MessagingOnOffStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MessagingOnOffStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MessagingOnOffStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MessagingOnOffStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MapOnOff"

    static const int kMapOnOff = 0;

    /**
     * Clears the field "MapOnOff".
     *
     * The field will be set to its default value. The hasMapOnOff()
     * method will return false.
     */
    inline void clearMapOnOff();

    /**
     * Checks whether the field "MapOnOff" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMapOnOff()). Otherwise it will return false.
     */
    inline bool hasMapOnOff () const;

    /**
     * Returns the value of the member "MapOnOff".
     *
     * MAP ON or OFF
     *
     * @return The value of the field "MapOnOff"
     */
    inline bool getMapOnOff () const;

    /**
     * Sets the value of the member "MapOnOff".
     *
     * MAP ON or OFF
     *
     * @param MapOnOff The value which will be set
     */
    inline void setMapOnOff (bool MapOnOff_);

    static const MessagingOnOffStatus &getDefaultInstance();

private:

    inline void set_has_MapOnOff ();

    inline void clear_has_MapOnOff ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _MapOnOff;

};

/**
 * The set message of the property "MessagingOnOff"
 * This Property will switch ON / OFF the Message Access Profile (MAP). This is a general setting which will affect all the phones. When disabled no MAP will be connected.
 */
class MessagingOnOffSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MessagingOnOffSet ();

    /**
     * Copy constructor
     */
    inline  MessagingOnOffSet (const MessagingOnOffSet &rhs);

    /**
     * All fields constructor
     */
    inline  MessagingOnOffSet (bool MapOnOff_);

    /**
     * Destructor
     */
    inline virtual  ~MessagingOnOffSet();

    /**
     * Assignment operator
     */
    inline MessagingOnOffSet& operator = (const MessagingOnOffSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MessagingOnOffSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MessagingOnOffSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MessagingOnOffSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MessagingOnOffSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MapOnOff"

    static const int kMapOnOff = 0;

    /**
     * Clears the field "MapOnOff".
     *
     * The field will be set to its default value. The hasMapOnOff()
     * method will return false.
     */
    inline void clearMapOnOff();

    /**
     * Checks whether the field "MapOnOff" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMapOnOff()). Otherwise it will return false.
     */
    inline bool hasMapOnOff () const;

    /**
     * Returns the value of the member "MapOnOff".
     *
     * MAP ON or OFF
     *
     * @return The value of the field "MapOnOff"
     */
    inline bool getMapOnOff () const;

    /**
     * Sets the value of the member "MapOnOff".
     *
     * MAP ON or OFF
     *
     * @param MapOnOff The value which will be set
     */
    inline void setMapOnOff (bool MapOnOff_);

    static const MessagingOnOffSet &getDefaultInstance();

private:

    inline void set_has_MapOnOff ();

    inline void clear_has_MapOnOff ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _MapOnOff;

};

/**
 * The error message of 'MessagingOnOff'
 */
class MessagingOnOffErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  MessagingOnOffErrorStructure ();

    /**
     * Copy constructor
     */
    inline  MessagingOnOffErrorStructure (const MessagingOnOffErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  MessagingOnOffErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~MessagingOnOffErrorStructure();

    /**
     * Assignment operator
     */
    inline MessagingOnOffErrorStructure& operator = (const MessagingOnOffErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MessagingOnOffErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MessagingOnOffErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MessagingOnOffErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MessagingOnOffErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Ret