/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/cca/CcaMostStream.h"
#include "asf/core/Types.h"
#include "asf/stream/MemoryStream.h"
#include "most_BTSet_fi_typesCcaMost.h"
#include "most_BTSet_fi_typesConst.h"
#include "most_BTSet_fi_types_Extended.h"
#include "most_BTSet_fi_types_ExtendedCcaMost.h"
#include "most_BTSet_fi_types_ExtendedConst.h"


// --------------------------------------------------------------------------
// MemoryStream functions
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// CcaMostStream functions
// --------------------------------------------------------------------------

// Serialize T_BTSetSupportedProfiles

void serializeCcaMost(const ::most_BTSet_fi_types_Extended::T_BTSetSupportedProfiles& in, ::asf::cca::CcaMostStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8* positionContentLength = out.getCurrentWritePos();
    uint8 contentLength = 0;
    out << contentLength;
    uint8* positionStartList = out.getCurrentWritePos();
    out << (uint8) in.getBSPPSupport();
    out << (uint8) in.getBHFPSupport();
    out << (uint8) in.getBA2DPSupport();
    out << (uint8) in.getBAVRCPSupport();
    out << (uint8) in.getBMAPSupport();
    out << (uint8) in.getBDUNSupport();
    out << (uint8) in.getBPANSupport();
    out << (uint8) in.getBPBAPSuport();
    out << (uint8) in.getBOPPSupport();
    out << (uint8) in.getBDIPSupport();
    uint8* positionEndList = out.getCurrentWritePos();
    contentLength = static_cast<uint8>(positionEndList - positionStartList);
    assert(contentLength <= 255);
    out.writeToPosUint8( positionContentLength, contentLength);
}

void deserializeCcaMost(::asf::cca::CcaMostStream& in, ::most_BTSet_fi_types_Extended::T_BTSetSupportedProfiles& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 contentLength = 0;
    in >> contentLength;
    uint8* positionStreamEnd = in.getCurrentReadPos() + contentLength;
    bool o0;
    in >> o0;
    out.setBSPPSupport(o0);
    bool o1;
    in >> o1;
    out.setBHFPSupport(o1);
    bool o2;
    in >> o2;
    out.setBA2DPSupport(o2);
    bool o3;
    in >> o3;
    out.setBAVRCPSupport(o3);
    bool o4;
    in >> o4;
    out.setBMAPSupport(o4);
    bool o5;
    in >> o5;
    out.setBDUNSupport(o5);
    bool o6;
    in >> o6;
    out.setBPANSupport(o6);
    bool o7;
    in >> o7;
    out.setBPBAPSuport(o7);
    bool o8;
    in >> o8;
    out.setBOPPSupport(o8);
    bool o9;
    in >> o9;
    out.setBDIPSupport(o9);
    assert(in.getCurrentReadPos() == positionStreamEnd);
    (void)positionStreamEnd; // make release build happy
}

// Serialize T_BTSetDeviceIdentification

void serializeCcaMost(const ::most_BTSet_fi_types_Extended::T_BTSetDeviceIdentification& in, ::asf::cca::CcaMostStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8* positionContentLength = out.getCurrentWritePos();
    uint8 contentLength = 0;
    out << contentLength;
    uint8* positionStartList = out.getCurrentWritePos();
    out << in.getU16VendorIDSource();
    out << in.getU16VendorID();
    out << in.getU16ProductID();
    out << in.getU16ProductVersion();
    uint8* positionEndList = out.getCurrentWritePos();
    contentLength = static_cast<uint8>(positionEndList - positionStartList);
    assert(contentLength <= 255);
    out.writeToPosUint8( positionContentLength, contentLength);
}

void deserializeCcaMost(::asf::cca::CcaMostStream& in, ::most_BTSet_fi_types_Extended::T_BTSetDeviceIdentification& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 contentLength = 0;
    in >> contentLength;
    uint8* positionStreamEnd = in.getCurrentReadPos() + contentLength;
    uint16 o10;
    in >> o10;
    out.setU16VendorIDSource(o10);
    uint16 o11;
    in >> o11;
    out.setU16VendorID(o11);
    uint16 o12;
    in >> o12;
    out.setU16ProductID(o12);
    uint16 o13;
    in >> o13;
    out.setU16ProductVersion(o13);
    assert(in.getCurrentReadPos() == positionStreamEnd);
    (void)positionStreamEnd; // make release build happy
}

// Serialize T_BTServiceType

void serializeCcaMost(const ::most_BTSet_fi_types_Extended::T_BTServiceType& in, ::asf::cca::CcaMostStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8* positionContentLength = out.getCurrentWritePos();
    uint8 contentLength = 0;
    out << contentLength;
    uint8* positionStartList = out.getCurrentWritePos();
    out << (uint8) in.getBHFP();
    out << (uint8) in.getBAVP();
    out << (uint8) in.getBPAN();
    out << (uint8) in.getBPBAP();
    out << (uint8) in.getBMAP();
    uint8* positionEndList = out.getCurrentWritePos();
    contentLength = static_cast<uint8>(positionEndList - positionStartList);
    assert(contentLength <= 255);
    out.writeToPosUint8( positionContentLength, contentLength);
}

void deserializeCcaMost(::asf::cca::CcaMostStream& in, ::most_BTSet_fi_types_Extended::T_BTServiceType& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 contentLength = 0;
    in >> contentLength;
    uint8* positionStreamEnd = in.getCurrentReadPos() + contentLength;
    bool o14;
    in >> o14;
    out.setBHFP(o14);
    bool o15;
    in >> o15;
    out.setBAVP(o15);
    bool o16;
    in >> o16;
    out.setBPAN(o16);
    bool o17;
    in >> o17;
    out.setBPBAP(o17);
    bool o18;
    in >> o18;
    out.setBMAP(o18);
    assert(in.getCurrentReadPos() == positionStreamEnd);
    (void)positionStreamEnd; // make release build happy
}

// Serialize T_BTProfileConnectionStatus

void serializeCcaMost(const ::most_BTSet_fi_types_Extended::T_BTProfileConnectionStatus& in, ::asf::cca::CcaMostStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8* positionContentLength = out.getCurrentWritePos();
    uint8 contentLength = 0;
    out << contentLength;
    uint8* positionStartList = out.getCurrentWritePos();
    out << (uint8) in.getE8HFP();
    out << (uint8) in.getE8AVP();
    out << (uint8) in.getE8PAN();
    out << (uint8) in.getE8PBAP();
    out << (uint8) in.getE8MAP();
    uint8* positionEndList = out.getCurrentWritePos();
    contentLength = static_cast<uint8>(positionEndList - positionStartList);
    assert(contentLength <= 255);
    out.writeToPosUint8( positionContentLength, contentLength);
}

void deserializeCcaMost(::asf::cca::CcaMostStream& in, ::most_BTSet_fi_types_Extended::T_BTProfileConnectionStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 contentLength = 0;
    in >> contentLength;
    uint8* positionStreamEnd = in.getCurrentReadPos() + contentLength;
    uint8 o19;
    in >> o19;
    out.setE8HFP((::most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus)o19);
    uint8 o20;
    in >> o20;
    out.setE8AVP((::most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus)o20);
    uint8 o21;
    in >> o21;
    out.setE8PAN((::most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus)o21);
    uint8 o22;
    in >> o22;
    out.setE8PBAP((::most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus)o22);
    uint8 o23;
    in >> o23;
    out.setE8MAP((::most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus)o23);
    assert(in.getCurrentReadPos() == positionStreamEnd);
    (void)positionStreamEnd; // make release build happy
}

// Serialize T_BTProfileDisconnectedReason

void serializeCcaMost(const ::most_BTSet_fi_types_Extended::T_BTProfileDisconnectedReason& in, ::asf::cca::CcaMostStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8* positionContentLength = out.getCurrentWritePos();
    uint8 contentLength = 0;
    out << contentLength;
    uint8* positionStartList = out.getCurrentWritePos();
    out << (uint8) in.getE8HFP();
    out << (uint8) in.getE8AVP();
    out << (uint8) in.getE8PAN();
    out << (uint8) in.getE8PBAP();
    out << (uint8) in.getE8MAP();
    uint8* positionEndList = out.getCurrentWritePos();
    contentLength = static_cast<uint8>(positionEndList - positionStartList);
    assert(contentLength <= 255);
    out.writeToPosUint8( positionContentLength, contentLength);
}

void deserializeCcaMost(::asf::cca::CcaMostStream& in, ::most_BTSet_fi_types_Extended::T_BTProfileDisconnectedReason& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 contentLength = 0;
    in >> contentLength;
    uint8* positionStreamEnd = in.getCurrentReadPos() + contentLength;
    uint8 o24;
    in >> o24;
    out.setE8HFP((::most_BTSet_fi_types_Extended::T_e8_BTSetDeviceDisconnectedReason)o24);
    uint8 o25;
    in >> o25;
    out.setE8AVP((::most_BTSet_fi_types_Extended::T_e8_BTSetDeviceDisconnectedReason)o25);
    uint8 o26;
    in >> o26;
    out.setE8PAN((::most_BTSet_fi_types_Extended::T_e8_BTSetDeviceDisconnectedReason)o26);
    uint8 o27;
    in >> o27;
    out.setE8PBAP((::most_BTSet_fi_types_Extended::T_e8_BTSetDeviceDisconnectedReason)o27);
    uint8 o28;
    in >> o28;
    out.setE8MAP((::most_BTSet_fi_types_Extended::T_e8_BTSetDeviceDisconnectedReason)o28);
    assert(in.getCurrentReadPos() == positionStreamEnd);
    (void)positionStreamEnd; // make release build happy
}

// Serialize T_BTSPPServiceConnectionStatusListItem

void serializeCcaMost(const ::most_BTSet_fi_types_Extended::T_BTSPPServiceConnectionStatusListItem& in, ::asf::cca::CcaMostStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU8DeviceHandle();
    out.writeMostString(in.getSUUID());
    out << (uint8) in.getE8SPPConnectionStatus();
    out << (uint8) in.getE8SPPDisconnectionReason();
    out.writeMostString(in.getSRFCommID());
}

void deserializeCcaMost(::asf::cca::CcaMostStream& in, ::most_BTSet_fi_types_Extended::T_BTSPPServiceConnectionStatusListItem& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o29;
    in >> o29;
    out.setU8DeviceHandle(o29);
    in.readMostString(out.getSUUIDMutable());
    uint8 o30;
    in >> o30;
    out.setE8SPPConnectionStatus((::most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus)o30);
    uint8 o31;
    in >> o31;
    out.setE8SPPDisconnectionReason((::most_BTSet_fi_types_Extended::T_e8_BTDisconnectionReason)o31);
    in.readMostString(out.getSRFCommIDMutable());
}

// Serialize T_BTSetDeviceListExtendedResultItem

void serializeCcaMost(const ::most_BTSet_fi_types_Extended::T_BTSetDeviceListExtendedResultItem& in, ::asf::cca::CcaMostStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out.writeMostString(in.getSDeviceAddress());
    out << in.getU8DeviceHandle();
    out.writeMostString(in.getSDeviceName());
    out << (uint8) in.getBDeviceConnectedStatus();
    out << (uint8) in.getE8DeviceDisconnectedReason();
    serializeCcaMost(in.getODeviceProfileStatus(), out, majorVersion);
    serializeCcaMost(in.getODeviceProfileDisconnectedReason(), out, majorVersion);
    serializeCcaMost(in.getODeviceSupportedProfiles(), out, majorVersion);
    out << (uint8) in.getBOutgoingSourceDeviceStatus();
    serializeCcaMost(in.getODateTimeStamp(), out, majorVersion);
    serializeCcaMost(in.getODeviceInfo(), out, majorVersion);
    out << (uint8) in.getE8DeviceConnectionStatus();
    serializeCcaMost(in.getODeviceProfileConnectionStatus(), out, majorVersion);
    out << in.getU8DeviceFavoriteIndex();
    serializeCcaMost(in.getODeviceProfileFavoriteIndex(), out, majorVersion);
    out << (uint8) in.getE8DeviceUsagePreference();
    serializeCcaMost(in.getODevicePairedDateTimeStamp(), out, majorVersion);
    out << (uint8) in.getBiAPoverBTSupport();
}

void deserializeCcaMost(::asf::cca::CcaMostStream& in, ::most_BTSet_fi_types_Extended::T_BTSetDeviceListExtendedResultItem& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    in.readMostString(out.getSDeviceAddressMutable());
    uint8 o32;
    in >> o32;
    out.setU8DeviceHandle(o32);
    in.readMostString(out.getSDeviceNameMutable());
    bool o33;
    in >> o33;
    out.setBDeviceConnectedStatus(o33);
    uint8 o34;
    in >> o34;
    out.setE8DeviceDisconnectedReason((::most_BTSet_fi_types_Extended::T_e8_BTSetDeviceDisconnectedReason)o34);
    deserializeCcaMost(in, out.getODeviceProfileStatusMutable(), majorVersion);
    deserializeCcaMost(in, out.getODeviceProfileDisconnectedReasonMutable(), majorVersion);
    deserializeCcaMost(in, out.getODeviceSupportedProfilesMutable(), majorVersion);
    bool o35;
    in >> o35;
    out.setBOutgoingSourceDeviceStatus(o35);
    deserializeCcaMost(in, out.getODateTimeStampMutable(), majorVersion);
    deserializeCcaMost(in, out.getODeviceInfoMutable(), majorVersion);
    uint8 o36;
    in >> o36;
    out.setE8DeviceConnectionStatus((::most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus)o36);
    deserializeCcaMost(in, out.getODeviceProfileConnectionStatusMutable(), majorVersion);
    uint8 o37;
    in >> o37;
    out.setU8DeviceFavoriteIndex(o37);
    deserializeCcaMost(in, out.getODeviceProfileFavoriteIndexMutable(), majorVersion);
    uint8 o38;
    in >> o38;
    out.setE8DeviceUsagePreference((::most_BTSet_fi_types_Extended::T_e8_BTUsagePreference)o38);
    deserializeCcaMost(in, out.getODevicePairedDateTimeStampMutable(), majorVersion);
    bool o39;
    in >> o39;
    out.setBiAPoverBTSupport(o39);
}

// Serialize T_BTSetVisibleDeviceItem

void serializeCcaMost(const ::most_BTSet_fi_types_Extended::T_BTSetVisibleDeviceItem& in, ::asf::cca::CcaMostStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out.writeMostString(in.getSBluetoothDeviceAddress());
    out.writeMostString(in.getSDeviceName());
    serializeCcaMost(in.getOSupportedProfiles(), out, majorVersion);
    out << (uint8) in.getE8VisibleDeviceConnectionStatus();
}

void deserializeCcaMost(::asf::cca::CcaMostStream& in, ::most_BTSet_fi_types_Extended::T_BTSetVisibleDeviceItem& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    in.readMostString(out.getSBluetoothDeviceAddressMutable());
    in.readMostString(out.getSDeviceNameMutable());
    deserializeCcaMost(in, out.getOSupportedProfilesMutable(), majorVersion);
    uint8 o40;
    in >> o40;
    out.setE8VisibleDeviceConnectionStatus((::most_BTSet_fi_types_Extended::T_e8_BTSetVisibleDeviceConnectionStatus)o40);
}

// Serialize T_BTSetSignalStrengthItem

void serializeCcaMost(const ::most_BTSet_fi_types_Extended::T_BTSetSignalStrengthItem& in, ::asf::cca::CcaMostStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU8DeviceHandle();
    out << in.getS8SignalStrength();
}

void deserializeCcaMost(::asf::cca::CcaMostStream& in, ::most_BTSet_fi_types_Extended::T_BTSetSignalStrengthItem& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o41;
    in >> o41;
    out.setU8DeviceHandle(o41);
    int8 o42;
    in >> o42;
    out.setS8SignalStrength(o42);
}

// Serialize T_BTSetDeviceListChangeExtended

void serializeCcaMost(const ::most_BTSet_fi_types_Extended::T_BTSetDeviceListChangeExtended& in, ::asf::cca::CcaMostStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8* positionContentLength = out.getCurrentWritePos();
    uint8 contentLength = 0;
    out << contentLength;
    uint8* positionStartList = out.getCurrentWritePos();
    out << in.getU8DeviceHandle();
    out << (uint8) in.getE8DeviceStatus();
    out << (uint8) in.getE8DeviceDisconnectedReason();
    uint8* positionEndList = out.getCurrentWritePos();
    contentLength = static_cast<uint8>(positionEndList - positionStartList);
    assert(contentLength <= 255);
    out.writeToPosUint8( positionContentLength, contentLength);
}

void deserializeCcaMost(::asf::cca::CcaMostStream& in, ::most_BTSet_fi_types_Extended::T_BTSetDeviceListChangeExtended& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 contentLength = 0;
    in >> contentLength;
    uint8* positionStreamEnd = in.getCurrentReadPos() + contentLength;
    uint8 o43;
    in >> o43;
    out.setU8DeviceHandle(o43);
    uint8 o44;
    in >> o44;
    out.setE8DeviceStatus((::most_BTSet_fi_types::T_e8_BTSetDeviceStatus)o44);
    uint8 o45;
    in >> o45;
    out.setE8DeviceDisconnectedReason((::most_BTSet_fi_types_Extended::T_e8_BTSetDeviceDisconnectedReason)o45);
    assert(in.getCurrentReadPos() == positionStreamEnd);
    (void)positionStreamEnd; // make release build happy
}

// Serialize T_BTLimitationModeListItem

void serializeCcaMost(const ::most_BTSet_fi_types_Extended::T_BTLimitationModeListItem& in, ::asf::cca::CcaMostStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out.writeMostString(in.getSBdAddress());
    out.writeMostString(in.getSBdDeviceName());
    out << (uint8) in.getE8Technology();
    out << (uint8) in.getE8CommunicationChannel();
    out << (uint8) in.getE8ActionState();
}

void deserializeCcaMost(::asf::cca::CcaMostStream& in, ::most_BTSet_fi_types_Extended::T_BTLimitationModeListItem& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    in.readMostString(out.getSBdAddressMutable());
    in.readMostString(out.getSBdDeviceNameMutable());
    uint8 o46;
    in >> o46;
    out.setE8Technology((::most_BTSet_fi_types_Extended::T_e8_BTTechnology)o46);
    uint8 o47;
    in >> o47;
    out.setE8CommunicationChannel((::most_BTSet_fi_types_Extended::T_e8_BTCommunicationChannel)o47);
    uint8 o48;
    in >> o48;
    out.setE8ActionState((::most_BTSet_fi_types_Extended::T_e8_BTLimitationActionState)o48);
}

// Serialize T_BTLimitationMode

void serializeCcaMost(const ::most_BTSet_fi_types_Extended::T_BTLimitationMode& in, ::asf::cca::CcaMostStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8* positionContentLength = out.getCurrentWritePos();
    uint8 contentLength = 0;
    out << contentLength;
    uint8* positionStartList = out.getCurrentWritePos();
    out.writeMostString(in.getSBdAddress());
    out.writeMostString(in.getSBdDeviceName());
    out << (uint8) in.getE8Technology();
    out << (uint8) in.getE8CommunicationChannel();
    out << (uint8) in.getE8Action();
    uint8* positionEndList = out.getCurrentWritePos();
    contentLength = static_cast<uint8>(positionEndList - positionStartList);
    assert(contentLength <= 255);
    out.writeToPosUint8( positionContentLength, contentLength);
}

void deserializeCcaMost(::asf::cca::CcaMostStream& in, ::most_BTSet_fi_types_Extended::T_BTLimitationMode& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 contentLength = 0;
    in >> contentLength;
    uint8* positionStreamEnd = in.getCurrentReadPos() + contentLength;
    in.readMostString(out.getSBdAddressMutable());
    in.readMostString(out.getSBdDeviceNameMutable());
    uint8 o49;
    in >> o49;
    out.setE8Technology((::most_BTSet_fi_types_Extended::T_e8_BTTechnology)o49);
    uint8 o50;
    in >> o50;
    out.setE8CommunicationChannel((::most_BTSet_fi_types_Extended::T_e8_BTCommunicationChannel)o50);
    uint8 o51;
    in >> o51;
    out.setE8Action((::most_BTSet_fi_types_Extended::T_e8_BTLimitationAction)o51);
    assert(in.getCurrentReadPos() == positionStreamEnd);
    (void)positionStreamEnd; // make release build happy
}

// Serialize T_BTProfileFavoriteIndex

void serializeCcaMost(const ::most_BTSet_fi_types_Extended::T_BTProfileFavoriteIndex& in, ::asf::cca::CcaMostStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8* positionContentLength = out.getCurrentWritePos();
    uint8 contentLength = 0;
    out << contentLength;
    uint8* positionStartList = out.getCurrentWritePos();
    out << in.getU8HFP();
    out << in.getU8AVP();
    uint8* positionEndList = out.getCurrentWritePos();
    contentLength = static_cast<uint8>(positionEndList - positionStartList);
    assert(contentLength <= 255);
    out.writeToPosUint8( positionContentLength, contentLength);
}

void deserializeCcaMost(::asf::cca::CcaMostStream& in, ::most_BTSet_fi_types_Extended::T_BTProfileFavoriteIndex& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 contentLength = 0;
    in >> contentLength;
    uint8* positionStreamEnd = in.getCurrentReadPos() + contentLength;
    uint8 o52;
    in >> o52;
    out.setU8HFP(o52);
    uint8 o53;
    in >> o53;
    out.setU8AVP(o53);
    assert(in.getCurrentReadPos() == positionStreamEnd);
    (void)positionStreamEnd; // make release build happy
}

// Serialize T_BTProfilesUsageInfoList

void serializeCcaMost(const ::most_BTSet_fi_types_Extended::T_BTProfilesUsageInfoList& in, ::asf::cca::CcaMostStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8* positionContentLength = out.getCurrentWritePos();
    uint8 contentLength = 0;
    out << contentLength;
    uint8* positionStartList = out.getCurrentWritePos();
    out << in.getU8DeviceHandle();
    serializeCcaMost(in.getOBTProfilesUsageInfo(), out, majorVersion);
    uint8* positionEndList = out.getCurrentWritePos();
    contentLength = static_cast<uint8>(positionEndList - positionStartList);
    assert(contentLength <= 255);
    out.writeToPosUint8( positionContentLength, contentLength);
}

void deserializeCcaMost(::asf::cca::CcaMostStream& in, ::most_BTSet_fi_types_Extended::T_BTProfilesUsageInfoList& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 contentLength = 0;
    in >> contentLength;
    uint8* positionStreamEnd = in.getCurrentReadPos() + contentLength;
    uint8 o54;
    in >> o54;
    out.setU8DeviceHandle(o54);
    deserializeCcaMost(in, out.getOBTProfilesUsageInfoMutable(), majorVersion);
    assert(in.getCurrentReadPos() == positionStreamEnd);
    (void)positionStreamEnd; // make release build happy
}

// Serialize T_BTProfilesUsageInfo

void serializeCcaMost(const ::most_BTSet_fi_types_Extended::T_BTProfilesUsageInfo& in, ::asf::cca::CcaMostStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8* positionContentLength = out.getCurrentWritePos();
    uint8 contentLength = 0;
    out << contentLength;
    uint8* positionStartList = out.getCurrentWritePos();
    out << (uint8) in.getE8BTProfile();
    out.writeMostString(in.getSUUID());
    out << (uint8) in.getE8BTProfileUsageType();
    out << (uint8) in.getBInUse();
    uint8* positionEndList = out.getCurrentWritePos();
    contentLength = static_cast<uint8>(positionEndList - positionStartList);
    assert(contentLength <= 255);
    out.writeToPosUint8( positionContentLength, contentLength);
}

void deserializeCcaMost(::asf::cca::CcaMostStream& in, ::most_BTSet_fi_types_Extended::T_BTProfilesUsageInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 contentLength = 0;
    in >> contentLength;
    uint8* positionStreamEnd = in.getCurrentReadPos() + contentLength;
    uint8 o55;
    in >> o55;
    out.setE8BTProfile((::most_BTSet_fi_types_Extended::T_e8_BTProfile)o55);
    in.readMostString(out.getSUUIDMutable());
    uint8 o56;
    in >> o56;
    out.setE8BTProfileUsageType((::most_BTSet_fi_types_Extended::T_e8_BTProfileUsageType)o56);
    bool o57;
    in >> o57;
    out.setBInUse(o57);
    assert(in.getCurrentReadPos() == positionStreamEnd);
    (void)positionStreamEnd; // make release build happy
}

// Serialize T_BTConflictInfo

void serializeCcaMost(const ::most_BTSet_fi_types_Extended::T_BTConflictInfo& in, ::asf::cca::CcaMostStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8* positionContentLength = out.getCurrentWritePos();
    uint8 contentLength = 0;
    out << contentLength;
    uint8* positionStartList = out.getCurrentWritePos();
    out << (uint8) in.getE8ConflictType();
    out << in.getU8DeviceHandle();
    out << (uint8) in.getE8BTProfile();
    out.writeMostString(in.getSUUID());
    out << (uint8) in.getE8BTProfileUsageType();
    out << (uint8) in.getE8ConflictState();
    uint8* positionEndList = out.getCurrentWritePos();
    contentLength = static_cast<uint8>(positionEndList - positionStartList);
    assert(contentLength <= 255);
    out.writeToPosUint8( positionContentLength, contentLength);
}

void deserializeCcaMost(::asf::cca::CcaMostStream& in, ::most_BTSet_fi_types_Extended::T_BTConflictInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 contentLength = 0;
    in >> contentLength;
    uint8* positionStreamEnd = in.getCurrentReadPos() + contentLength;
    uint8 o58;
    in >> o58;
    out.setE8ConflictType((::most_BTSet_fi_types_Extended::T_e8_BTConflictType)o58);
    uint8 o59;
    in >> o59;
    out.setU8DeviceHandle(o59);
    uint8 o60;
    in >> o60;
    out.setE8BTProfile((::most_BTSet_fi_types_Extended::T_e8_BTProfile)o60);
    in.readMostString(out.getSUUIDMutable());
    uint8 o61;
    in >> o61;
    out.setE8BTProfileUsageType((::most_BTSet_fi_types_Extended::T_e8_BTProfileUsageType)o61);
    uint8 o62;
    in >> o62;
    out.setE8ConflictState((::most_BTSet_fi_types_Extended::T_e8_BTConflictState)o62);
    assert(in.getCurrentReadPos() == positionStreamEnd);
    (void)positionStreamEnd; // make release build happy
}

