#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef MOST_BTSET_FI_TYPES_H
#define MOST_BTSET_FI_TYPES_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "fi_basetypes_most.h"
#include "most_BTSet_fi_typesConst.h"
#include <cstring>
#include <vector>

/**
 * Types most_BTSet_fi_types
 */

namespace most_BTSet_fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_BTSetDateStamp;

class T_BTSetTimeStamp;

class T_BTSetDateTimeStamp;

class T_BTSetDeviceRingtoneListResultItem;

class T_BTSetRingtoneListItem;

class T_BTSetDeviceControlSupport;

class T_BTSetBluetoothFeatureSupport;

// type definitions
/**
 * If the meaning of "T_BTSetDeviceRingtoneListResult" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_BTSetDeviceRingtoneListResultItem > T_BTSetDeviceRingtoneListResult;

/**
 * If the meaning of "T_BTSetRingtoneList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_BTSetRingtoneListItem > T_BTSetRingtoneList;


class T_BTSetDateStamp {
public:

    /**
     * Default constructor
     */
    inline  T_BTSetDateStamp ();

    /**
     * Copy constructor
     */
    inline  T_BTSetDateStamp (const T_BTSetDateStamp &rhs);

    /**
     * All fields constructor
     */
    inline  T_BTSetDateStamp (const ::fi_basetypes_most::T_String& sCldrYear_, const ::fi_basetypes_most::T_String& sCldrMonth_, const ::fi_basetypes_most::T_String& sCldrDay_);

    /**
     * Destructor
     */
    inline  ~T_BTSetDateStamp();

    /**
     * Assignment operator
     */
    inline T_BTSetDateStamp& operator = (const T_BTSetDateStamp& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_BTSetDateStamp& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_BTSetDateStamp& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_BTSetDateStamp& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_BTSetDateStamp& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sCldrYear"

    static const int kSCldrYear = 0;

    /**
     * Clears the field "sCldrYear".
     *
     * The field will be set to its default value. The hasSCldrYear()
     * method will return false.
     */
    inline void clearSCldrYear();

    /**
     * Checks whether the field "sCldrYear" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSCldrYear()). Otherwise it will return false.
     */
    inline bool hasSCldrYear () const;

    /**
     * Returns the value of the member "sCldrYear".
     *
     * Identifies the calendar year; 0000 = unknown calendar year.
     *
     * @return The value of the field "sCldrYear"
     */
    inline const ::fi_basetypes_most::T_String& getSCldrYear () const;

    /**
     * Retrieves the value of the field "sCldrYear" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sCldrYear".
     */
    inline ::fi_basetypes_most::T_String& getSCldrYearMutable ();

    /**
     * Sets the value of the member "sCldrYear".
     *
     * Identifies the calendar year; 0000 = unknown calendar year.
     *
     * @param sCldrYear The value which will be set
     */
    inline void setSCldrYear (const ::fi_basetypes_most::T_String& sCldrYear_);

    // API of field "sCldrMonth"

    static const int kSCldrMonth = 1;

    /**
     * Clears the field "sCldrMonth".
     *
     * The field will be set to its default value. The hasSCldrMonth()
     * method will return false.
     */
    inline void clearSCldrMonth();

    /**
     * Checks whether the field "sCldrMonth" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSCldrMonth()). Otherwise it will return false.
     */
    inline bool hasSCldrMonth () const;

    /**
     * Returns the value of the member "sCldrMonth".
     *
     * Identifies the calendar month.00 = Unknown01 = January02 = February03 = March04 = April05 = May06 = June07 = July08 = August09 = September10 = October11 = November12 = December
     *
     * @return The value of the field "sCldrMonth"
     */
    inline const ::fi_basetypes_most::T_String& getSCldrMonth () const;

    /**
     * Retrieves the value of the field "sCldrMonth" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sCldrMonth".
     */
    inline ::fi_basetypes_most::T_String& getSCldrMonthMutable ();

    /**
     * Sets the value of the member "sCldrMonth".
     *
     * Identifies the calendar month.00 = Unknown01 = January02 = February03 = March04 = April05 = May06 = June07 = July08 = August09 = September10 = October11 = November12 = December
     *
     * @param sCldrMonth The value which will be set
     */
    inline void setSCldrMonth (const ::fi_basetypes_most::T_String& sCldrMonth_);

    // API of field "sCldrDay"

    static const int kSCldrDay = 2;

    /**
     * Clears the field "sCldrDay".
     *
     * The field will be set to its default value. The hasSCldrDay()
     * method will return false.
     */
    inline void clearSCldrDay();

    /**
     * Checks whether the field "sCldrDay" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSCldrDay()). Otherwise it will return false.
     */
    inline bool hasSCldrDay () const;

    /**
     * Returns the value of the member "sCldrDay".
     *
     * Identifies the calendar day; 00 = unknown calendar day.
     *
     * @return The value of the field "sCldrDay"
     */
    inline const ::fi_basetypes_most::T_String& getSCldrDay () const;

    /**
     * Retrieves the value of the field "sCldrDay" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sCldrDay".
     */
    inline ::fi_basetypes_most::T_String& getSCldrDayMutable ();

    /**
     * Sets the value of the member "sCldrDay".
     *
     * Identifies the calendar day; 00 = unknown calendar day.
     *
     * @param sCldrDay The value which will be set
     */
    inline void setSCldrDay (const ::fi_basetypes_most::T_String& sCldrDay_);

    static const T_BTSetDateStamp &getDefaultInstance();

private:

    inline void set_has_sCldrYear ();

    inline void clear_has_sCldrYear ();

    inline void set_has_sCldrMonth ();

    inline void clear_has_sCldrMonth ();

    inline void set_has_sCldrDay ();

    inline void clear_has_sCldrDay ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::fi_basetypes_most::T_String _sCldrYear;

    ::fi_basetypes_most::T_String _sCldrMonth;

    ::fi_basetypes_most::T_String _sCldrDay;

};

class T_BTSetTimeStamp {
public:

    /**
     * Default constructor
     */
    inline  T_BTSetTimeStamp ();

    /**
     * Copy constructor
     */
    inline  T_BTSetTimeStamp (const T_BTSetTimeStamp &rhs);

    /**
     * All fields constructor
     */
    inline  T_BTSetTimeStamp (const ::fi_basetypes_most::T_String& sHours_, const ::fi_basetypes_most::T_String& sMinutes_, const ::fi_basetypes_most::T_String& sSeconds_);

    /**
     * Destructor
     */
    inline  ~T_BTSetTimeStamp();

    /**
     * Assignment operator
     */
    inline T_BTSetTimeStamp& operator = (const T_BTSetTimeStamp& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_BTSetTimeStamp& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_BTSetTimeStamp& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_BTSetTimeStamp& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_BTSetTimeStamp& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sHours"

    static const int kSHours = 0;

    /**
     * Clears the field "sHours".
     *
     * The field will be set to its default value. The hasSHours()
     * method will return false.
     */
    inline void clearSHours();

    /**
     * Checks whether the field "sHours" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSHours()). Otherwise it will return false.
     */
    inline bool hasSHours () const;

    /**
     * Returns the value of the member "sHours".
     *
     * Identifies the hour. Formated as 24 hour mode; 99 = unknown.
     *
     * @return The value of the field "sHours"
     */
    inline const ::fi_basetypes_most::T_String& getSHours () const;

    /**
     * Retrieves the value of the field "sHours" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sHours".
     */
    inline ::fi_basetypes_most::T_String& getSHoursMutable ();

    /**
     * Sets the value of the member "sHours".
     *
     * Identifies the hour. Formated as 24 hour mode; 99 = unknown.
     *
     * @param sHours The value which will be set
     */
    inline void setSHours (const ::fi_basetypes_most::T_String& sHours_);

    // API of field "sMinutes"

    static const int kSMinutes = 1;

    /**
     * Clears the field "sMinutes".
     *
     * The field will be set to its default value. The hasSMinutes()
     * method will return false.
     */
    inline void clearSMinutes();

    /**
     * Checks whether the field "sMinutes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSMinutes()). Otherwise it will return false.
     */
    inline bool hasSMinutes () const;

    /**
     * Returns the value of the member "sMinutes".
     *
     * Identifies the minutes; 99 = unknown.
     *
     * @return The value of the field "sMinutes"
     */
    inline const ::fi_basetypes_most::T_String& getSMinutes () const;

    /**
     * Retrieves the value of the field "sMinutes" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sMinutes".
     */
    inline ::fi_basetypes_most::T_String& getSMinutesMutable ();

    /**
     * Sets the value of the member "sMinutes".
     *
     * Identifies the minutes; 99 = unknown.
     *
     * @param sMinutes The value which will be set
     */
    inline void setSMinutes (const ::fi_basetypes_most::T_String& sMinutes_);

    // API of field "sSeconds"

    static const int kSSeconds = 2;

    /**
     * Clears the field "sSeconds".
     *
     * The field will be set to its default value. The hasSSeconds()
     * method will return false.
     */
    inline void clearSSeconds();

    /**
     * Checks whether the field "sSeconds" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSSeconds()). Otherwise it will return false.
     */
    inline bool hasSSeconds () const;

    /**
     * Returns the value of the member "sSeconds".
     *
     * Identifies the seconds; 99 = unknown.
     *
     * @return The value of the field "sSeconds"
     */
    inline const ::fi_basetypes_most::T_String& getSSeconds () const;

    /**
     * Retrieves the value of the field "sSeconds" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sSeconds".
     */
    inline ::fi_basetypes_most::T_String& getSSecondsMutable ();

    /**
     * Sets the value of the member "sSeconds".
     *
     * Identifies the seconds; 99 = unknown.
     *
     * @param sSeconds The value which will be set
     */
    inline void setSSeconds (const ::fi_basetypes_most::T_String& sSeconds_);

    static const T_BTSetTimeStamp &getDefaultInstance();

private:

    inline void set_has_sHours ();

    inline void clear_has_sHours ();

    inline void set_has_sMinutes ();

    inline void clear_has_sMinutes ();

    inline void set_has_sSeconds ();

    inline void clear_has_sSeconds ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::fi_basetypes_most::T_String _sHours;

    ::fi_basetypes_most::T_String _sMinutes;

    ::fi_basetypes_most::T_String _sSeconds;

};

class T_BTSetDateTimeStamp {
public:

    /**
     * Default constructor
     */
    inline  T_BTSetDateTimeStamp ();

    /**
     * Copy constructor
     */
    inline  T_BTSetDateTimeStamp (const T_BTSetDateTimeStamp &rhs);

    /**
     * All fields constructor
     */
    inline  T_BTSetDateTimeStamp (const T_BTSetDateStamp& oDateStamp_, const T_BTSetTimeStamp& oTimeStamp_);

    /**
     * Destructor
     */
    inline  ~T_BTSetDateTimeStamp();

    /**
     * Assignment operator
     */
    inline T_BTSetDateTimeStamp& operator = (const T_BTSetDateTimeStamp& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_BTSetDateTimeStamp& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_BTSetDateTimeStamp& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_BTSetDateTimeStamp& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_BTSetDateTimeStamp& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oDateStamp"

    static const int kODateStamp = 0;

    /**
     * Clears the field "oDateStamp".
     *
     * The field will be set to its default value. The hasODateStamp()
     * method will return false.
     */
    inline void clearODateStamp();

    /**
     * Checks whether the field "oDateStamp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setODateStamp()). Otherwise it will return false.
     */
    inline bool hasODateStamp () const;

    /**
     * Returns the value of the member "oDateStamp".
     *
     * Date of the message.Formatted as YYYYMMDD where YYYY = CldrYear; MM = CldrMonth; DD = CldrDay
     *
     * @return The value of the field "oDateStamp"
     */
    inline const T_BTSetDateStamp& getODateStamp () const;

    /**
     * Retrieves the value of the field "oDateStamp" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oDateStamp".
     */
    inline T_BTSetDateStamp& getODateStampMutable ();

    /**
     * Sets the value of the member "oDateStamp".
     *
     * Date of the message.Formatted as YYYYMMDD where YYYY = CldrYear; MM = CldrMonth; DD = CldrDay
     *
     * @param oDateStamp The value which will be set
     */
    inline void setODateStamp (const T_BTSetDateStamp& oDateStamp_);

    // API of field "oTimeStamp"

    static const int kOTimeStamp = 1;

    /**
     * Clears the field "oTimeStamp".
     *
     * The field will be set to its default value. The hasOTimeStamp()
     * method will return false.
     */
    inline void clearOTimeStamp();

    /**
     * Checks whether the field "oTimeStamp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOTimeStamp()). Otherwise it will return false.
     */
    inline bool hasOTimeStamp () const;

    /**
     * Returns the value of the member "oTimeStamp".
     *
     * Time of the message.Formated as 24 hour mode.Formatted as HHMMSS where HH = Hours; MM = Minutes; SS = Seconds.
     *
     * @return The value of the field "oTimeStamp"
     */
    inline const T_BTSetTimeStamp& getOTimeStamp () const;

    /**
     * Retrieves the value of the field "oTimeStamp" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oTimeStamp".
     */
    inline T_BTSetTimeStamp& getOTimeStampMutable ();

    /**
     * Sets the value of the member "oTimeStamp".
     *
     * Time of the message.Formated as 24 hour mode.Formatted as HHMMSS where HH = Hours; MM = Minutes; SS = Seconds.
     *
     * @param oTimeStamp The value which will be set
     */
    inline void setOTimeStamp (const T_BTSetTimeStamp& oTimeStamp_);

    static const T_BTSetDateTimeStamp &getDefaultInstance();

private:

    inline void set_has_oDateStamp ();

    inline void clear_has_oDateStamp ();

    inline void set_has_oTimeStamp ();

    inline void clear_has_oTimeStamp ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_BTSetDateStamp _oDateStamp;

    T_BTSetTimeStamp _oTimeStamp;

};

class T_BTSetDeviceRingtoneListResultItem {
public:

    /**
     * Default constructor
     */
    inline  T_BTSetDeviceRingtoneListResultItem ();

    /**
     * Copy constructor
     */
    inline  T_BTSetDeviceRingtoneListResultItem (const T_BTSetDeviceRingtoneListResultItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_BTSetDeviceRingtoneListResultItem (uint8 u8DeviceHandle_, const ::fi_basetypes_most::T_String& sDeviceName_, uint16 u16RingtoneID_, const ::fi_basetypes_most::T_String& sRingtoneName_);

    /**
     * Destructor
     */
    inline  ~T_BTSetDeviceRingtoneListResultItem();

    /**
     * Assignment operator
     */
    inline T_BTSetDeviceRingtoneListResultItem& operator = (const T_BTSetDeviceRingtoneListResultItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_BTSetDeviceRingtoneListResultItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_BTSetDeviceRingtoneListResultItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_BTSetDeviceRingtoneListResultItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_BTSetDeviceRingtoneListResultItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "sDeviceName"

    static const int kSDeviceName = 1;

    /**
     * Clears the field "sDeviceName".
     *
     * The field will be set to its default value. The hasSDeviceName()
     * method will return false.
     */
    inline void clearSDeviceName();

    /**
     * Checks whether the field "sDeviceName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDeviceName()). Otherwise it will return false.
     */
    inline bool hasSDeviceName () const;

    /**
     * Returns the value of the member "sDeviceName".
     *
     * Name of the device (the Bluetooth friendly name).
     *
     * @return The value of the field "sDeviceName"
     */
    inline const ::fi_basetypes_most::T_String& getSDeviceName () const;

    /**
     * Retrieves the value of the field "sDeviceName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDeviceName".
     */
    inline ::fi_basetypes_most::T_String& getSDeviceNameMutable ();

    /**
     * Sets the value of the member "sDeviceName".
     *
     * Name of the device (the Bluetooth friendly name).
     *
     * @param sDeviceName The value which will be set
     */
    inline void setSDeviceName (const ::fi_basetypes_most::T_String& sDeviceName_);

    // API of field "u16RingtoneID"

    static const int kU16RingtoneID = 2;

    /**
     * Clears the field "u16RingtoneID".
     *
     * The field will be set to its default value. The hasU16RingtoneID()
     * method will return false.
     */
    inline void clearU16RingtoneID();

    /**
     * Checks whether the field "u16RingtoneID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16RingtoneID()). Otherwise it will return false.
     */
    inline bool hasU16RingtoneID () const;

    /**
     * Returns the value of the member "u16RingtoneID".
     *
     * The unique ID for each ringtone available.
     *
     * @return The value of the field "u16RingtoneID"
     */
    inline uint16 getU16RingtoneID () const;

    /**
     * Sets the value of the member "u16RingtoneID".
     *
     * The unique ID for each ringtone available.
     *
     * @param u16RingtoneID The value which will be set
     */
    inline void setU16RingtoneID (uint16 u16RingtoneID_);

    // API of field "sRingtoneName"

    static const int kSRingtoneName = 3;

    /**
     * Clears the field "sRingtoneName".
     *
     * The field will be set to its default value. The hasSRingtoneName()
     * method will return false.
     */
    inline void clearSRingtoneName();

    /**
     * Checks whether the field "sRingtoneName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSRingtoneName()). Otherwise it will return false.
     */
    inline bool hasSRingtoneName () const;

    /**
     * Returns the value of the member "sRingtoneName".
     *
     * The text of the name associated with each ringtone available.
     *
     * @return The value of the field "sRingtoneName"
     */
    inline const ::fi_basetypes_most::T_String& getSRingtoneName () const;

    /**
     * Retrieves the value of the field "sRingtoneName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sRingtoneName".
     */
    inline ::fi_basetypes_most::T_String& getSRingtoneNameMutable ();

    /**
     * Sets the value of the member "sRingtoneName".
     *
     * The text of the name associated with each ringtone available.
     *
     * @param sRingtoneName The value which will be set
     */
    inline void setSRingtoneName (const ::fi_basetypes_most::T_String& sRingtoneName_);

    static const T_BTSetDeviceRingtoneListResultItem &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_sDeviceName ();

    inline void clear_has_sDeviceName ();

    inline void set_has_u16RingtoneID ();

    inline void clear_has_u16RingtoneID ();

    inline void set_has_sRingtoneName ();

    inline void clear_has_sRingtoneName ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint8 _u8DeviceHandle;

    ::fi_basetypes_most::T_String _sDeviceName;

    uint16 _u16RingtoneID;

    ::fi_basetypes_most::T_String _sRingtoneName;

};

class T_BTSetRingtoneListItem {
public:

    /**
     * Default constructor
     */
    inline  T_BTSetRingtoneListItem ();

    /**
     * Copy constructor
     */
    inline  T_BTSetRingtoneListItem (const T_BTSetRingtoneListItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_BTSetRingtoneListItem (uint16 u16RingtoneID_, const ::fi_basetypes_most::T_String& sRingtoneName_, bool bRingtoneAvailable_, bool bPlayRingtoneAvailable_, bool bActiveRingtone_);

    /**
     * Destructor
     */
    inline  ~T_BTSetRingtoneListItem();

    /**
     * Assignment operator
     */
    inline T_BTSetRingtoneListItem& operator = (const T_BTSetRingtoneListItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_BTSetRingtoneListItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_BTSetRingtoneListItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_BTSetRingtoneListItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_BTSetRingtoneListItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16RingtoneID"

    static const int kU16RingtoneID = 0;

    /**
     * Clears the field "u16RingtoneID".
     *
     * The field will be set to its default value. The hasU16RingtoneID()
     * method will return false.
     */
    inline void clearU16RingtoneID();

    /**
     * Checks whether the field "u16RingtoneID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16RingtoneID()). Otherwise it will return false.
     */
    inline bool hasU16RingtoneID () const;

    /**
     * Returns the value of the member "u16RingtoneID".
     *
     * The unique ID for each ringtone available.
     *
     * @return The value of the field "u16RingtoneID"
     */
    inline uint16 getU16RingtoneID () const;

    /**
     * Sets the value of the member "u16RingtoneID".
     *
     * The unique ID for each ringtone available.
     *
     * @param u16RingtoneID The value which will be set
     */
    inline void setU16RingtoneID (uint16 u16RingtoneID_);

    // API of field "sRingtoneName"

    static const int kSRingtoneName = 1;

    /**
     * Clears the field "sRingtoneName".
     *
     * The field will be set to its default value. The hasSRingtoneName()
     * method will return false.
     */
    inline void clearSRingtoneName();

    /**
     * Checks whether the field "sRingtoneName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSRingtoneName()). Otherwise it will return false.
     */
    inline bool hasSRingtoneName () const;

    /**
     * Returns the value of the member "sRingtoneName".
     *
     * The text of the name associated with each ringtone available.
     *
     * @return The value of the field "sRingtoneName"
     */
    inline const ::fi_basetypes_most::T_String& getSRingtoneName () const;

    /**
     * Retrieves the value of the field "sRingtoneName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sRingtoneName".
     */
    inline ::fi_basetypes_most::T_String& getSRingtoneNameMutable ();

    /**
     * Sets the value of the member "sRingtoneName".
     *
     * The text of the name associated with each ringtone available.
     *
     * @param sRingtoneName The value which will be set
     */
    inline void setSRingtoneName (const ::fi_basetypes_most::T_String& sRingtoneName_);

    // API of field "bRingtoneAvailable"

    static const int kBRingtoneAvailable = 2;

    /**
     * Clears the field "bRingtoneAvailable".
     *
     * The field will be set to its default value. The hasBRingtoneAvailable()
     * method will return false.
     */
    inline void clearBRingtoneAvailable();

    /**
     * Checks whether the field "bRingtoneAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBRingtoneAvailable()). Otherwise it will return false.
     */
    inline bool hasBRingtoneAvailable () const;

    /**
     * Returns the value of the member "bRingtoneAvailable".
     *
     * Identifies if the ringtone is available for that device or not.
     *
     * @return The value of the field "bRingtoneAvailable"
     */
    inline bool getBRingtoneAvailable () const;

    /**
     * Sets the value of the member "bRingtoneAvailable".
     *
     * Identifies if the ringtone is available for that device or not.
     *
     * @param bRingtoneAvailable The value which will be set
     */
    inline void setBRingtoneAvailable (bool bRingtoneAvailable_);

    // API of field "bPlayRingtoneAvailable"

    static const int kBPlayRingtoneAvailable = 3;

    /**
     * Clears the field "bPlayRingtoneAvailable".
     *
     * The field will be set to its default value. The hasBPlayRingtoneAvailable()
     * method will return false.
     */
    inline void clearBPlayRingtoneAvailable();

    /**
     * Checks whether the field "bPlayRingtoneAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBPlayRingtoneAvailable()). Otherwise it will return false.
     */
    inline bool hasBPlayRingtoneAvailable () const;

    /**
     * Returns the value of the member "bPlayRingtoneAvailable".
     *
     * Identifies if the ringtone can be played or not.
     *
     * @return The value of the field "bPlayRingtoneAvailable"
     */
    inline bool getBPlayRingtoneAvailable () const;

    /**
     * Sets the value of the member "bPlayRingtoneAvailable".
     *
     * Identifies if the ringtone can be played or not.
     *
     * @param bPlayRingtoneAvailable The value which will be set
     */
    inline void setBPlayRingtoneAvailable (bool bPlayRingtoneAvailable_);

    // API of field "bActiveRingtone"

    static const int kBActiveRingtone = 4;

    /**
     * Clears the field "bActiveRingtone".
     *
     * The field will be set to its default value. The hasBActiveRingtone()
     * method will return false.
     */
    inline void clearBActiveRingtone();

    /**
     * Checks whether the field "bActiveRingtone" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBActiveRingtone()). Otherwise it will return false.
     */
    inline bool hasBActiveRingtone () const;

    /**
     * Returns the value of the member "bActiveRingtone".
     *
     * Identifies if the ringtone is the active ringtone for the selected device.
     *
     * @return The value of the field "bActiveRingtone"
     */
    inline bool getBActiveRingtone () const;

    /**
     * Sets the value of the member "bActiveRingtone".
     *
     * Identifies if the ringtone is the active ringtone for the selected device.
     *
     * @param bActiveRingtone The value which will be set
     */
    inline void setBActiveRingtone (bool bActiveRingtone_);

    static const T_BTSetRingtoneListItem &getDefaultInstance();

private:

    inline void set_has_u16RingtoneID ();

    inline void clear_has_u16RingtoneID ();

    inline void set_has_sRingtoneName ();

    inline void clear_has_sRingtoneName ();

    inline void set_has_bRingtoneAvailable ();

    inline void clear_has_bRingtoneAvailable ();

    inline void set_has_bPlayRingtoneAvailable ();

    inline void clear_has_bPlayRingtoneAvailable ();

    inline void set_has_bActiveRingtone ();

    inline void clear_has_bActiveRingtone ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint16 _u16RingtoneID;

    ::fi_basetypes_most::T_String _sRingtoneName;

    bool _bRingtoneAvailable;

    bool _bPlayRingtoneAvailable;

    bool _bActiveRingtone;

};

class T_BTSetDeviceControlSupport {
public:

    /**
     * Default constructor
     */
    inline  T_BTSetDeviceControlSupport ();

    /**
     * Copy constructor
     */
    inline  T_BTSetDeviceControlSupport (const T_BTSetDeviceControlSupport &rhs);

    /**
     * All fields constructor
     */
    inline  T_BTSetDeviceControlSupport (bool bPlaySupport_, bool bPauseSupport_, bool bNextTrackSupport_, bool bPreviousTrackSupport_, bool bShuffleSupport_, bool bRepeatSupport_, bool bPlaytimeSupport_, bool bMetadataSupport_, bool bFolderBrowseSupport_, bool bMediaAggregrationSupport_, bool bFastForwardSupport_, bool bRewindSupport_);

    /**
     * Destructor
     */
    inline  ~T_BTSetDeviceControlSupport();

    /**
     * Assignment operator
     */
    inline T_BTSetDeviceControlSupport& operator = (const T_BTSetDeviceControlSupport& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_BTSetDeviceControlSupport& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_BTSetDeviceControlSupport& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_BTSetDeviceControlSupport& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_BTSetDeviceControlSupport& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bPlaySupport"

    static const int kBPlaySupport = 0;

    /**
     * Clears the field "bPlaySupport".
     *
     * The field will be set to its default value. The hasBPlaySupport()
     * method will return false.
     */
    inline void clearBPlaySupport();

    /**
     * Checks whether the field "bPlaySupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBPlaySupport()). Otherwise it will return false.
     */
    inline bool hasBPlaySupport () const;

    /**
     * Returns the value of the member "bPlaySupport".
     *
     * Identifies if the device supports Play.
     *
     * @return The value of the field "bPlaySupport"
     */
    inline bool getBPlaySupport () const;

    /**
     * Sets the value of the member "bPlaySupport".
     *
     * Identifies if the device supports Play.
     *
     * @param bPlaySupport The value which will be set
     */
    inline void setBPlaySupport (bool bPlaySupport_);

    // API of field "bPauseSupport"

    static const int kBPauseSupport = 1;

    /**
     * Clears the field "bPauseSupport".
     *
     * The field will be set to its default value. The hasBPauseSupport()
     * method will return false.
     */
    inline void clearBPauseSupport();

    /**
     * Checks whether the field "bPauseSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBPauseSupport()). Otherwise it will return false.
     */
    inline bool hasBPauseSupport () const;

    /**
     * Returns the value of the member "bPauseSupport".
     *
     * Identifies if the device supports Pause.
     *
     * @return The value of the field "bPauseSupport"
     */
    inline bool getBPauseSupport () const;

    /**
     * Sets the value of the member "bPauseSupport".
     *
     * Identifies if the device supports Pause.
     *
     * @param bPauseSupport The value which will be set
     */
    inline void setBPauseSupport (bool bPauseSupport_);

    // API of field "bNextTrackSupport"

    static const int kBNextTrackSupport = 2;

    /**
     * Clears the field "bNextTrackSupport".
     *
     * The field will be set to its default value. The hasBNextTrackSupport()
     * method will return false.
     */
    inline void clearBNextTrackSupport();

    /**
     * Checks whether the field "bNextTrackSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBNextTrackSupport()). Otherwise it will return false.
     */
    inline bool hasBNextTrackSupport () const;

    /**
     * Returns the value of the member "bNextTrackSupport".
     *
     * Identifies if the device supports Next Track.
     *
     * @return The value of the field "bNextTrackSupport"
     */
    inline bool getBNextTrackSupport () const;

    /**
     * Sets the value of the member "bNextTrackSupport".
     *
     * Identifies if the device supports Next Track.
     *
     * @param bNextTrackSupport The value which will be set
     */
    inline void setBNextTrackSupport (bool bNextTrackSupport_);

    // API of field "bPreviousTrackSupport"

    static const int kBPreviousTrackSupport = 3;

    /**
     * Clears the field "bPreviousTrackSupport".
     *
     * The field will be set to its default value. The hasBPreviousTrackSupport()
     * method will return false.
     */
    inline void clearBPreviousTrackSupport();

    /**
     * Checks whether the field "bPreviousTrackSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBPreviousTrackSupport()). Otherwise it will return false.
     */
    inline bool hasBPreviousTrackSupport () const;

    /**
     * Returns the value of the member "bPreviousTrackSupport".
     *
     * Identifies if the device supports Previous Track.
     *
     * @return The value of the field "bPreviousTrackSupport"
     */
    inline bool getBPreviousTrackSupport () const;

    /**
     * Sets the value of the member "bPreviousTrackSupport".
     *
     * Identifies if the device supports Previous Track.
     *
     * @param bPreviousTrackSupport The value which will be set
     */
    inline void setBPreviousTrackSupport (bool bPreviousTrackSupport_);

    // API of field "bShuffleSupport"

    static const int kBShuffleSupport = 4;

    /**
     * Clears the field "bShuffleSupport".
     *
     * The field will be set to its default value. The hasBShuffleSupport()
     * method will return false.
     */
    inline void clearBShuffleSupport();

    /**
     * Checks whether the field "bShuffleSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBShuffleSupport()). Otherwise it will return false.
     */
    inline bool hasBShuffleSupport () const;

    /**
     * Returns the value of the member "bShuffleSupport".
     *
     * Identifies if the device supports Shuffle
     *
     * @return The value of the field "bShuffleSupport"
     */
    inline bool getBShuffleSupport () const;

    /**
     * Sets the value of the member "bShuffleSupport".
     *
     * Identifies if the device supports Shuffle
     *
     * @param bShuffleSupport The value which will be set
     */
    inline void setBShuffleSupport (bool bShuffleSupport_);

    // API of field "bRepeatSupport"

    static const int kBRepeatSupport = 5;

    /**
     * Clears the field "bRepeatSupport".
     *
     * The field will be set to its default value. The hasBRepeatSupport()
     * method will return false.
     */
    inline void clearBRepeatSupport();

    /**
     * Checks whether the field "bRepeatSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBRepeatSupport()). Otherwise it will return false.
     */
    inline bool hasBRepeatSupport () const;

    /**
     * Returns the value of the member "bRepeatSupport".
     *
     * Identifies if the device supports Repeat.
     *
     * @return The value of the field "bRepeatSupport"
     */
    inline bool getBRepeatSupport () const;

    /**
     * Sets the value of the member "bRepeatSupport".
     *
     * Identifies if the device supports Repeat.
     *
     * @param bRepeatSupport The value which will be set
     */
    inline void setBRepeatSupport (bool bRepeatSupport_);

    // API of field "bPlaytimeSupport"

    static const int kBPlaytimeSupport = 6;

    /**
     * Clears the field "bPlaytimeSupport".
     *
     * The field will be set to its default value. The hasBPlaytimeSupport()
     * method will return false.
     */
    inline void clearBPlaytimeSupport();

    /**
     * Checks whether the field "bPlaytimeSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBPlaytimeSupport()). Otherwise it will return false.
     */
    inline bool hasBPlaytimeSupport () const;

    /**
     * Returns the value of the member "bPlaytimeSupport".
     *
     * Identifies if the device supports Playtime
     *
     * @return The value of the field "bPlaytimeSupport"
     */
    inline bool getBPlaytimeSupport () const;

    /**
     * Sets the value of the member "bPlaytimeSupport".
     *
     * Identifies if the device supports Playtime
     *
     * @param bPlaytimeSupport The value which will be set
     */
    inline void setBPlaytimeSupport (bool bPlaytimeSupport_);

    // API of field "bMetadataSupport"

    static const int kBMetadataSupport = 7;

    /**
     * Clears the field "bMetadataSupport".
     *
     * The field will be set to its default value. The hasBMetadataSupport()
     * method will return false.
     */
    inline void clearBMetadataSupport();

    /**
     * Checks whether the field "bMetadataSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBMetadataSupport()). Otherwise it will return false.
     */
    inline bool hasBMetadataSupport () const;

    /**
     * Returns the value of the member "bMetadataSupport".
     *
     * Identifies if the device supports metadata.
     *
     * @return The value of the field "bMetadataSupport"
     */
    inline bool getBMetadataSupport () const;

    /**
     * Sets the value of the member "bMetadataSupport".
     *
     * Identifies if the device supports metadata.
     *
     * @param bMetadataSupport The value which will be set
     */
    inline void setBMetadataSupport (bool bMetadataSupport_);

    // API of field "bFolderBrowseSupport"

    static const int kBFolderBrowseSupport = 8;

    /**
     * Clears the field "bFolderBrowseSupport".
     *
     * The field will be set to its default value. The hasBFolderBrowseSupport()
     * method will return false.
     */
    inline void clearBFolderBrowseSupport();

    /**
     * Checks whether the field "bFolderBrowseSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBFolderBrowseSupport()). Otherwise it will return false.
     */
    inline bool hasBFolderBrowseSupport () const;

    /**
     * Returns the value of the member "bFolderBrowseSupport".
     *
     * Identifies if the device supports Folder Browse
     *
     * @return The value of the field "bFolderBrowseSupport"
     */
    inline bool getBFolderBrowseSupport () const;

    /**
     * Sets the value of the member "bFolderBrowseSupport".
     *
     * Identifies if the device supports Folder Browse
     *
     * @param bFolderBrowseSupport The value which will be set
     */
    inline void setBFolderBrowseSupport (bool bFolderBrowseSupport_);

    // API of field "bMediaAggregrationSupport"

    static const int kBMediaAggregrationSupport = 9;

    /**
     * Clears the field "bMediaAggregrationSupport".
     *
     * The field will be set to its default value. The hasBMediaAggregrationSupport()
     * method will return false.
     */
    inline void clearBMediaAggregrationSupport();

    /**
     * Checks whether the field "bMediaAggregrationSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBMediaAggregrationSupport()). Otherwise it will return false.
     */
    inline bool hasBMediaAggregrationSupport () const;

    /**
     * Returns the value of the member "bMediaAggregrationSupport".
     *
     * Identifies if the device supports Media Aggregration.
     *
     * @return The value of the field "bMediaAggregrationSupport"
     */
    inline bool getBMediaAggregrationSupport () const;

    /**
     * Sets the value of the member "bMediaAggregrationSupport".
     *
     * Identifies if the device supports Media Aggregration.
     *
     * @param bMediaAggregrationSupport The value which will be set
     */
    inline void setBMediaAggregrationSupport (bool bMediaAggregrationSupport_);

    // API of field "bFastForwardSupport"

    static const int kBFastForwardSupport = 10;

    /**
     * Clears the field "bFastForwardSupport".
     *
     * The field will be set to its default value. The hasBFastForwardSupport()
     * method will return false.
     */
    inline void clearBFastForwardSupport();

    /**
     * Checks whether the field "bFastForwardSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBFastForwardSupport()). Otherwise it will return false.
     */
    inline bool hasBFastForwardSupport () const;

    /**
     * Returns the value of the member "bFastForwardSupport".
     *
     * Identifies if the device supports Fast Forward.
     *
     * @return The value of the field "bFastForwardSupport"
     */
    inline bool getBFastForwardSupport () const;

    /**
     * Sets the value of the member "bFastForwardSupport".
     *
     * Identifies if the device supports Fast Forward.
     *
     * @param bFastForwardSupport The value which will be set
     */
    inline void setBFastForwardSupport (bool bFastForwardSupport_);

    // API of field "bRewindSupport"

    static const int kBRewindSupport = 11;

    /**
     * Clears the field "bRewindSupport".
     *
     * The field will be set to its default value. The hasBRewindSupport()
     * method will return false.
     */
    inline void clearBRewindSupport();

    /**
     * Checks whether the field "bRewindSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBRewindSupport()). Otherwise it will return false.
     */
    inline bool hasBRewindSupport () const;

    /**
     * Returns the value of the member "bRewindSupport".
     *
     * Identifies if the device supports Rewind.
     *
     * @return The value of the field "bRewindSupport"
     */
    inline bool getBRewindSupport () const;

    /**
     * Sets the value of the member "bRewindSupport".
     *
     * Identifies if the device supports Rewind.
     *
     * @param bRewindSupport The value which will be set
     */
    inline void setBRewindSupport (bool bRewindSupport_);

    static const T_BTSetDeviceControlSupport &getDefaultInstance();

private:

    inline void set_has_bPlaySupport ();

    inline void clear_has_bPlaySupport ();

    inline void set_has_bPauseSupport ();

    inline void clear_has_bPauseSupport ();

    inline void set_has_bNextTrackSupport ();

    inline void clear_has_bNextTrackSupport ();

    inline void set_has_bPreviousTrackSupport ();

    inline void clear_has_bPreviousTrackSupport ();

    inline void set_has_bShuffleSupport ();

    inline void clear_has_bShuffleSupport ();

    inline void set_has_bRepeatSupport ();

    inline void clear_has_bRepeatSupport ();

    inline void set_has_bPlaytimeSupport ();

    inline void clear_has_bPlaytimeSupport ();

    inline void set_has_bMetadataSupport ();

    inline void clear_has_bMetadataSupport ();

    inline void set_has_bFolderBrowseSupport ();

    inline void clear_has_bFolderBrowseSupport ();

    inline void set_has_bMediaAggregrationSupport ();

    inline void clear_has_bMediaAggregrationSupport ();

    inline void set_has_bFastForwardSupport ();

    inline void clear_has_bFastForwardSupport ();

    inline void set_has_bRewindSupport ();

    inline void clear_has_bRewindSupport ();

    uint32 _has_bits_[ (12 + 31) / 32];

    bool _bPlaySupport;

    bool _bPauseSupport;

    bool _bNextTrackSupport;

    bool _bPreviousTrackSupport;

    bool _bShuffleSupport;

    bool _bRepeatSupport;

    bool _bPlaytimeSupport;

    bool _bMetadataSupport;

    bool _bFolderBrowseSupport;

    bool _bMediaAggregrationSupport;

    bool _bFastForwardSupport;

    bool _bRewindSupport;

};

class T_BTSetBluetoothFeatureSupport {
public:

    /**
     * Default constructor
     */
    inline  T_BTSetBluetoothFeatureSupport ();

    /**
     * Copy constructor
     */
    inline  T_BTSetBluetoothFeatureSupport (const T_BTSetBluetoothFeatureSupport &rhs);

    /**
     * All fields constructor
     */
    inline  T_BTSetBluetoothFeatureSupport (bool bHandsFreeSupport_, bool bPhoneBookSupport_, bool bAudioStreamingSupport_, T_e8_BTSetAudioStreamingSupportType e8AudioStreamingSupportType_, bool bMessagingSupport_, bool bInternetAccessSupport_, T_e8_BTSetInternetAccessSupportType e8InternetAccessSupportType_, bool bPortableNavigationSupport_, bool bSerialPortSupport_);

    /**
     * Destructor
     */
    inline  ~T_BTSetBluetoothFeatureSupport();

    /**
     * Assignment operator
     */
    inline T_BTSetBluetoothFeatureSupport& operator = (const T_BTSetBluetoothFeatureSupport& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_BTSetBluetoothFeatureSupport& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_BTSetBluetoothFeatureSupport& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_BTSetBluetoothFeatureSupport& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_BTSetBluetoothFeatureSupport& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bHandsFreeSupport"

    static const int kBHandsFreeSupport = 0;

    /**
     * Clears the field "bHandsFreeSupport".
     *
     * The field will be set to its default value. The hasBHandsFreeSupport()
     * method will return false.
     */
    inline void clearBHandsFreeSupport();

    /**
     * Checks whether the field "bHandsFreeSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBHandsFreeSupport()). Otherwise it will return false.
     */
    inline bool hasBHandsFreeSupport () const;

    /**
     * Returns the value of the member "bHandsFreeSupport".
     *
     * Identifies if the device supports the Hands-Free feature.
     *
     * @return The value of the field "bHandsFreeSupport"
     */
    inline bool getBHandsFreeSupport () const;

    /**
     * Sets the value of the member "bHandsFreeSupport".
     *
     * Identifies if the device supports the Hands-Free feature.
     *
     * @param bHandsFreeSupport The value which will be set
     */
    inline void setBHandsFreeSupport (bool bHandsFreeSupport_);

    // API of field "bPhoneBookSupport"

    static const int kBPhoneBookSupport = 1;

    /**
     * Clears the field "bPhoneBookSupport".
     *
     * The field will be set to its default value. The hasBPhoneBookSupport()
     * method will return false.
     */
    inline void clearBPhoneBookSupport();

    /**
     * Checks whether the field "bPhoneBookSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBPhoneBookSupport()). Otherwise it will return false.
     */
    inline bool hasBPhoneBookSupport () const;

    /**
     * Returns the value of the member "bPhoneBookSupport".
     *
     * Identifies if the device supports the Phone Book feature.
     *
     * @return The value of the field "bPhoneBookSupport"
     */
    inline bool getBPhoneBookSupport () const;

    /**
     * Sets the value of the member "bPhoneBookSupport".
     *
     * Identifies if the device supports the Phone Book feature.
     *
     * @param bPhoneBookSupport The value which will be set
     */
    inline void setBPhoneBookSupport (bool bPhoneBookSupport_);

    // API of field "bAudioStreamingSupport"

    static const int kBAudioStreamingSupport = 2;

    /**
     * Clears the field "bAudioStreamingSupport".
     *
     * The field will be set to its default value. The hasBAudioStreamingSupport()
     * method will return false.
     */
    inline void clearBAudioStreamingSupport();

    /**
     * Checks whether the field "bAudioStreamingSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBAudioStreamingSupport()). Otherwise it will return false.
     */
    inline bool hasBAudioStreamingSupport () const;

    /**
     * Returns the value of the member "bAudioStreamingSupport".
     *
     * Identifies if the device supports the Audio Streaming feature.
     *
     * @return The value of the field "bAudioStreamingSupport"
     */
    inline bool getBAudioStreamingSupport () const;

    /**
     * Sets the value of the member "bAudioStreamingSupport".
     *
     * Identifies if the device supports the Audio Streaming feature.
     *
     * @param bAudioStreamingSupport The value which will be set
     */
    inline void setBAudioStreamingSupport (bool bAudioStreamingSupport_);

    // API of field "e8AudioStreamingSupportType"

    static const int kE8AudioStreamingSupportType = 3;

    /**
     * Clears the field "e8AudioStreamingSupportType".
     *
     * The field will be set to its default value. The hasE8AudioStreamingSupportType()
     * method will return false.
     */
    inline void clearE8AudioStreamingSupportType();

    /**
     * Checks whether the field "e8AudioStreamingSupportType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8AudioStreamingSupportType()). Otherwise it will return false.
     */
    inline bool hasE8AudioStreamingSupportType () const;

    /**
     * Returns the value of the member "e8AudioStreamingSupportType".
     *
     * Identifies if the level of feature support of the device.
     *
     * @return The value of the field "e8AudioStreamingSupportType"
     */
    inline T_e8_BTSetAudioStreamingSupportType getE8AudioStreamingSupportType () const;

    /**
     * Sets the value of the member "e8AudioStreamingSupportType".
     *
     * Identifies if the level of feature support of the device.
     *
     * @param e8AudioStreamingSupportType The value which will be set
     */
    inline void setE8AudioStreamingSupportType (T_e8_BTSetAudioStreamingSupportType e8AudioStreamingSupportType_);

    // API of field "bMessagingSupport"

    static const int kBMessagingSupport = 4;

    /**
     * Clears the field "bMessagingSupport".
     *
     * The field will be set to its default value. The hasBMessagingSupport()
     * method will return false.
     */
    inline void clearBMessagingSupport();

    /**
     * Checks whether the field "bMessagingSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBMessagingSupport()). Otherwise it will return false.
     */
    inline bool hasBMessagingSupport () const;

    /**
     * Returns the value of the member "bMessagingSupport".
     *
     * Identifies if the device supports the Messaging feature.
     *
     * @return The value of the field "bMessagingSupport"
     */
    inline bool getBMessagingSupport () const;

    /**
     * Sets the value of the member "bMessagingSupport".
     *
     * Identifies if the device supports the Messaging feature.
     *
     * @param bMessagingSupport The value which will be set
     */
    inline void setBMessagingSupport (bool bMessagingSupport_);

    // API of field "bInternetAccessSupport"

    static const int kBInternetAccessSupport = 5;

    /**
     * Clears the field "bInternetAccessSupport".
     *
     * The field will be set to its default value. The hasBInternetAccessSupport()
     * method will return false.
     */
    inline void clearBInternetAccessSupport();

    /**
     * Checks whether the field "bInternetAccessSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBInternetAccessSupport()). Otherwise it will return false.
     */
    inline bool hasBInternetAccessSupport () const;

    /**
     * Returns the value of the member "bInternetAccessSupport".
     *
     * Identifies if the device supports the Internet Access feature
     *
     * @return The value of the field "bInternetAccessSupport"
     */
    inline bool getBInternetAccessSupport () const;

    /**
     * Sets the value of the member "bInternetAccessSupport".
     *
     * Identifies if the device supports the Internet Access feature
     *
     * @param bInternetAccessSupport The value which will be set
     */
    inline void setBInternetAccessSupport (bool bInternetAccessSupport_);

    // API of field "e8InternetAccessSupportType"

    static const int kE8InternetAccessSupportType = 6;

    /**
     * Clears the field "e8InternetAccessSupportType".
     *
     * The field will be set to its default value. The hasE8InternetAccessSupportType()
     * method will return false.
     */
    inline void clearE8InternetAccessSupportType();

    /**
     * Checks whether the field "e8InternetAccessSupportType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8InternetAccessSupportType()). Otherwise it will return false.
     */
    inline bool hasE8InternetAccessSupportType () const;

    /**
     * Returns the value of the member "e8InternetAccessSupportType".
     *
     * Identifies which of the two profiles (DUN or PAN) are supported by the device.
     *
     * @return The value of the field "e8InternetAccessSupportType"
     */
    inline T_e8_BTSetInternetAccessSupportType getE8InternetAccessSupportType () const;

    /**
     * Sets the value of the member "e8InternetAccessSupportType".
     *
     * Identifies which of the two profiles (DUN or PAN) are supported by the device.
     *
     * @param e8InternetAccessSupportType The value which will be set
     */
    inline void setE8InternetAccessSupportType (T_e8_BTSetInternetAccessSupportType e8InternetAccessSupportType_);

    // API of field "bPortableNavigationSupport"

    static const int kBPortableNavigationSupport = 7;

    /**
     * Clears the field "bPortableNavigationSupport".
     *
     * The field will be set to its default value. The hasBPortableNavigationSupport()
     * method will return false.
     */
    inline void clearBPortableNavigationSupport();

    /**
     * Checks whether the field "bPortableNavigationSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBPortableNavigationSupport()). Otherwise it will return false.
     */
    inline bool hasBPortableNavigationSupport () const;

    /**
     * Returns the value of the member "bPortableNavigationSupport".
     *
     * Identifies if the device supports the Portable Navigation feature.
     *
     * @return The value of the field "bPortableNavigationSupport"
     */
    inline bool getBPortableNavigationSupport () const;

    /**
     * Sets the value of the member "bPortableNavigationSupport".
     *
     * Identifies if the device supports the Portable Navigation feature.
     *
     * @param bPortableNavigationSupport The value which will be set
     */
    inline void setBPortableNavigationSupport (bool bPortableNavigationSupport_);

    // API of field "bSerialPortSupport"

    static const int kBSerialPortSupport = 8;

    /**
     * Clears the field "bSerialPortSupport".
     *
     * The field will be set to its default value. The hasBSerialPortSupport()
     * method will return false.
     */
    inline void clearBSerialPortSupport();

    /**
     * Checks whether the field "bSerialPortSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBSerialPortSupport()). Otherwise it will return false.
     */
    inline bool hasBSerialPortSupport () const;

    /**
     * Returns the value of the member "bSerialPortSupport".
     *
     * Identifies if the device supports the Serial Port feature.
     *
     * @return The value of the field "bSerialPortSupport"
     */
    inline bool getBSerialPortSupport () const;

    /**
     * Sets the value of the member "bSerialPortSupport".
     *
     * Identifies if the device supports the Serial Port feature.
     *
     * @param bSerialPortSupport The value which will be set
     */
    inline void setBSerialPortSupport (bool bSerialPortSupport_);

    static const T_BTSetBluetoothFeatureSupport &getDefaultInstance();

private:

    inline void set_has_bHandsFreeSupport ();

    inline void clear_has_bHandsFreeSupport ();

    inline void set_has_bPhoneBookSupport ();

    inline void clear_has_bPhoneBookSupport ();

    inline void set_has_bAudioStreamingSupport ();

    inline void clear_has_bAudioStreamingSupport ();

    inline void set_has_e8AudioStreamingSupportType ();

    inline void clear_has_e8AudioStreamingSupportType ();

    inline void set_has_bMessagingSupport ();

    inline void clear_has_bMessagingSupport ();

    inline void set_has_bInternetAccessSupport ();

    inline void clear_has_bInternetAccessSupport ();

    inline void set_has_e8InternetAccessSupportType ();

    inline void clear_has_e8InternetAccessSupportType ();

    inline void set_has_bPortableNavigationSupport ();

    inline void clear_has_bPortableNavigationSupport ();

    inline void set_has_bSerialPortSupport ();

    inline void clear_has_bSerialPortSupport ();

    uint32 _has_bits_[ (9 + 31) / 32];

    bool _bHandsFreeSupport;

    bool _bPhoneBookSupport;

    bool _bAudioStreamingSupport;

    T_e8_BTSetAudioStreamingSupportType _e8AudioStreamingSupportType;

    bool _bMessagingSupport;

    bool _bInternetAccessSupport;

    T_e8_BTSetInternetAccessSupportType _e8InternetAccessSupportType;

    bool _bPortableNavigationSupport;

    bool _bSerialPortSupport;

};

inline  T_BTSetDateStamp::T_BTSetDateStamp ()  :
    _sCldrYear (),
    _sCldrMonth (),
    _sCldrDay ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_BTSetDateStamp::T_BTSetDateStamp (const T_BTSetDateStamp &rhs)  :
    _sCldrYear (),
    _sCldrMonth (),
    _sCldrDay ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_BTSetDateStamp::T_BTSetDateStamp (const ::fi_basetypes_most::T_String& sCldrYear_, const ::fi_basetypes_most::T_String& sCldrMonth_, const ::fi_basetypes_most::T_String& sCldrDay_)  :
    _sCldrYear (sCldrYear_),
    _sCldrMonth (sCldrMonth_),
    _sCldrDay (sCldrDay_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sCldrYear_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sCldrMonth_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sCldrDay_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_BTSetDateStamp::~T_BTSetDateStamp() {
}

inline T_BTSetDateStamp& T_BTSetDateStamp::operator = (const T_BTSetDateStamp& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSCldrYear()) {
            setSCldrYear(rhs.getSCldrYear());
        } else {
            clearSCldrYear();
        }
        if (rhs.hasSCldrMonth()) {
            setSCldrMonth(rhs.getSCldrMonth());
        } else {
            clearSCldrMonth();
        }
        if (rhs.hasSCldrDay()) {
            setSCldrDay(rhs.getSCldrDay());
        } else {
            clearSCldrDay();
        }
    }
    return *this;
}

inline bool T_BTSetDateStamp::operator == (const T_BTSetDateStamp& rhs) const {
    return (((!hasSCldrYear() && !rhs.hasSCldrYear()) || getSCldrYear() == rhs.getSCldrYear()) &&
        ((!hasSCldrMonth() && !rhs.hasSCldrMonth()) || getSCldrMonth() == rhs.getSCldrMonth()) &&
        ((!hasSCldrDay() && !rhs.hasSCldrDay()) || getSCldrDay() == rhs.getSCldrDay()));
}

inline bool T_BTSetDateStamp::operator != (const T_BTSetDateStamp& rhs) const {
    return ! (*this == rhs);
}

inline bool T_BTSetDateStamp::operator < (const T_BTSetDateStamp& rhs) const {
    if (hasSCldrYear() || rhs.hasSCldrYear()) {
        if (getSCldrYear() < rhs.getSCldrYear()) return true;
        if (getSCldrYear() > rhs.getSCldrYear()) return false;
    }
    if (hasSCldrMonth() || rhs.hasSCldrMonth()) {
        if (getSCldrMonth() < rhs.getSCldrMonth()) return true;
        if (getSCldrMonth() > rhs.getSCldrMonth()) return false;
    }
    if (hasSCldrDay() || rhs.hasSCldrDay()) {
        if (getSCldrDay() < rhs.getSCldrDay()) return true;
        if (getSCldrDay() > rhs.getSCldrDay()) return false;
    }
    return false;
}

inline bool T_BTSetDateStamp::operator > (const T_BTSetDateStamp& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_BTSetDateStamp::clear() {
    clearSCldrYear();
    clearSCldrMonth();
    clearSCldrDay();
}

inline void T_BTSetDateStamp::clearSCldrYear() {
    if (hasSCldrYear()) {
         clear_has_sCldrYear();
        _sCldrYear.clear();
     }
}

inline bool T_BTSetDateStamp::hasSCldrYear () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_BTSetDateStamp::getSCldrYear () const {
    return _sCldrYear;
}

inline ::fi_basetypes_most::T_String& T_BTSetDateStamp::getSCldrYearMutable () {
    set_has_sCldrYear();
    return _sCldrYear;
}

inline void T_BTSetDateStamp::setSCldrYear (const ::fi_basetypes_most::T_String& sCldrYear_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sCldrYear_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sCldrYear();
    this->_sCldrYear = sCldrYear_;
}

inline void T_BTSetDateStamp::clearSCldrMonth() {
    if (hasSCldrMonth()) {
         clear_has_sCldrMonth();
        _sCldrMonth.clear();
     }
}

inline bool T_BTSetDateStamp::hasSCldrMonth () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_BTSetDateStamp::getSCldrMonth () const {
    return _sCldrMonth;
}

inline ::fi_basetypes_most::T_String& T_BTSetDateStamp::getSCldrMonthMutable () {
    set_has_sCldrMonth();
    return _sCldrMonth;
}

inline void T_BTSetDateStamp::setSCldrMonth (const ::fi_basetypes_most::T_String& sCldrMonth_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sCldrMonth_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sCldrMonth();
    this->_sCldrMonth = sCldrMonth_;
}

inline void T_BTSetDateStamp::clearSCldrDay() {
    if (hasSCldrDay()) {
         clear_has_sCldrDay();
        _sCldrDay.clear();
     }
}

inline bool T_BTSetDateStamp::hasSCldrDay () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_BTSetDateStamp::getSCldrDay () const {
    return _sCldrDay;
}

inline ::fi_basetypes_most::T_String& T_BTSetDateStamp::getSCldrDayMutable () {
    set_has_sCldrDay();
    return _sCldrDay;
}

inline void T_BTSetDateStamp::setSCldrDay (const ::fi_basetypes_most::T_String& sCldrDay_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sCldrDay_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sCldrDay();
    this->_sCldrDay = sCldrDay_;
}

inline void T_BTSetDateStamp::set_has_sCldrYear () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_BTSetDateStamp::clear_has_sCldrYear () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_BTSetDateStamp::set_has_sCldrMonth () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_BTSetDateStamp::clear_has_sCldrMonth () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_BTSetDateStamp::set_has_sCldrDay () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_BTSetDateStamp::clear_has_sCldrDay () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_BTSetTimeStamp::T_BTSetTimeStamp ()  :
    _sHours (),
    _sMinutes (),
    _sSeconds ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_BTSetTimeStamp::T_BTSetTimeStamp (const T_BTSetTimeStamp &rhs)  :
    _sHours (),
    _sMinutes (),
    _sSeconds ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_BTSetTimeStamp::T_BTSetTimeStamp (const ::fi_basetypes_most::T_String& sHours_, const ::fi_basetypes_most::T_String& sMinutes_, const ::fi_basetypes_most::T_String& sSeconds_)  :
    _sHours (sHours_),
    _sMinutes (sMinutes_),
    _sSeconds (sSeconds_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sHours_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sMinutes_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sSeconds_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_BTSetTimeStamp::~T_BTSetTimeStamp() {
}

inline T_BTSetTimeStamp& T_BTSetTimeStamp::operator = (const T_BTSetTimeStamp& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSHours()) {
            setSHours(rhs.getSHours());
        } else {
            clearSHours();
        }
        if (rhs.hasSMinutes()) {
            setSMinutes(rhs.getSMinutes());
        } else {
            clearSMinutes();
        }
        if (rhs.hasSSeconds()) {
            setSSeconds(rhs.getSSeconds());
        } else {
            clearSSeconds();
        }
    }
    return *this;
}

inline bool T_BTSetTimeStamp::operator == (const T_BTSetTimeStamp& rhs) const {
    return (((!hasSHours() && !rhs.hasSHours()) || getSHours() == rhs.getSHours()) &&
        ((!hasSMinutes() && !rhs.hasSMinutes()) || getSMinutes() == rhs.getSMinutes()) &&
        ((!hasSSeconds() && !rhs.hasSSeconds()) || getSSeconds() == rhs.getSSeconds()));
}

inline bool T_BTSetTimeStamp::operator != (const T_BTSetTimeStamp& rhs) const {
    return ! (*this == rhs);
}

inline bool T_BTSetTimeStamp::operator < (const T_BTSetTimeStamp& rhs) const {
    if (hasSHours() || rhs.hasSHours()) {
        if (getSHours() < rhs.getSHours()) return true;
        if (getSHours() > rhs.getSHours()) return false;
    }
    if (hasSMinutes() || rhs.hasSMinutes()) {
        if (getSMinutes() < rhs.getSMinutes()) return true;
        if (getSMinutes() > rhs.getSMinutes()) return false;
    }
    if (hasSSeconds() || rhs.hasSSeconds()) {
        if (getSSeconds() < rhs.getSSeconds()) return true;
        if (getSSeconds() > rhs.getSSeconds()) return false;
    }
    return false;
}

inline bool T_BTSetTimeStamp::operator > (const T_BTSetTimeStamp& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_BTSetTimeStamp::clear() {
    clearSHours();
    clearSMinutes();
    clearSSeconds();
}

inline void T_BTSetTimeStamp::clearSHours() {
    if (hasSHours()) {
         clear_has_sHours();
        _sHours.clear();
     }
}

inline bool T_BTSetTimeStamp::hasSHours () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_BTSetTimeStamp::getSHours () const {
    return _sHours;
}

inline ::fi_basetypes_most::T_String& T_BTSetTimeStamp::getSHoursMutable () {
    set_has_sHours();
    return _sHours;
}

inline void T_BTSetTimeStamp::setSHours (const ::fi_basetypes_most::T_String& sHours_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sHours_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sHours();
    this->_sHours = sHours_;
}

inline void T_BTSetTimeStamp::clearSMinutes() {
    if (hasSMinutes()) {
         clear_has_sMinutes();
        _sMinutes.clear();
     }
}

inline bool T_BTSetTimeStamp::hasSMinutes () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_BTSetTimeStamp::getSMinutes () const {
    return _sMinutes;
}

inline ::fi_basetypes_most::T_String& T_BTSetTimeStamp::getSMinutesMutable () {
    set_has_sMinutes();
    return _sMinutes;
}

inline void T_BTSetTimeStamp::setSMinutes (const ::fi_basetypes_most::T_String& sMinutes_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sMinutes_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sMinutes();
    this->_sMinutes = sMinutes_;
}

inline void T_BTSetTimeStamp::clearSSeconds() {
    if (hasSSeconds()) {
         clear_has_sSeconds();
        _sSeconds.clear();
     }
}

inline bool T_BTSetTimeStamp::hasSSeconds () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_BTSetTimeStamp::getSSeconds () const {
    return _sSeconds;
}

inline ::fi_basetypes_most::T_String& T_BTSetTimeStamp::getSSecondsMutable () {
    set_has_sSeconds();
    return _sSeconds;
}

inline void T_BTSetTimeStamp::setSSeconds (const ::fi_basetypes_most::T_String& sSeconds_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sSeconds_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sSeconds();
    this->_sSeconds = sSeconds_;
}

inline void T_BTSetTimeStamp::set_has_sHours () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_BTSetTimeStamp::clear_has_sHours () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_BTSetTimeStamp::set_has_sMinutes () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_BTSetTimeStamp::clear_has_sMinutes () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_BTSetTimeStamp::set_has_sSeconds () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_BTSetTimeStamp::clear_has_sSeconds () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_BTSetDateTimeStamp::T_BTSetDateTimeStamp ()  :
    _oDateStamp (),
    _oTimeStamp ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_BTSetDateTimeStamp::T_BTSetDateTimeStamp (const T_BTSetDateTimeStamp &rhs)  :
    _oDateStamp (),
    _oTimeStamp ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_BTSetDateTimeStamp::T_BTSetDateTimeStamp (const T_BTSetDateStamp& oDateStamp_, const T_BTSetTimeStamp& oTimeStamp_)  :
    _oDateStamp (oDateStamp_),
    _oTimeStamp (oTimeStamp_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_BTSetDateTimeStamp::~T_BTSetDateTimeStamp() {
}

inline T_BTSetDateTimeStamp& T_BTSetDateTimeStamp::operator = (const T_BTSetDateTimeStamp& rhs) {
    if( this != &rhs ) {
        if (rhs.hasODateStamp()) {
            setODateStamp(rhs.getODateStamp());
        } else {
            clearODateStamp();
        }
        if (rhs.hasOTimeStamp()) {
            setOTimeStamp(rhs.getOTimeStamp());
        } else {
            clearOTimeStamp();
        }
    }
    return *this;
}

inline bool T_BTSetDateTimeStamp::operator == (const T_BTSetDateTimeStamp& rhs) const {
    return (((!hasODateStamp() && !rhs.hasODateStamp()) || getODateStamp() == rhs.getODateStamp()) &&
        ((!hasOTimeStamp() && !rhs.hasOTimeStamp()) || getOTimeStamp() == rhs.getOTimeStamp()));
}

inline bool T_BTSetDateTimeStamp::operator != (const T_BTSetDateTimeStamp& rhs) const {
    return ! (*this == rhs);
}

inline bool T_BTSetDateTimeStamp::operator < (const T_BTSetDateTimeStamp& rhs) const {
    if (hasODateStamp() || rhs.hasODateStamp()) {
        if (getODateStamp() < rhs.getODateStamp()) return true;
        if (getODateStamp() > rhs.getODateStamp()) return false;
    }
    if (hasOTimeStamp() || rhs.hasOTimeStamp()) {
        if (getOTimeStamp() < rhs.getOTimeStamp()) return true;
        if (getOTimeStamp() > rhs.getOTimeStamp()) return false;
    }
    return false;
}

inline bool T_BTSetDateTimeStamp::operator > (const T_BTSetDateTimeStamp& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_BTSetDateTimeStamp::clear() {
    clearODateStamp();
    clearOTimeStamp();
}

inline void T_BTSetDateTimeStamp::clearODateStamp() {
    if (hasODateStamp()) {
         clear_has_oDateStamp();
        _oDateStamp.clear();
     }
}

inline bool T_BTSetDateTimeStamp::hasODateStamp () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const T_BTSetDateStamp& T_BTSetDateTimeStamp::getODateStamp () const {
    return _oDateStamp;
}

inline T_BTSetDateStamp& T_BTSetDateTimeStamp::getODateStampMutable () {
    set_has_oDateStamp();
    return _oDateStamp;
}

inline void T_BTSetDateTimeStamp::setODateStamp (const T_BTSetDateStamp& oDateStamp_) {
    set_has_oDateStamp();
    this->_oDateStamp = oDateStamp_;
}

inline void T_BTSetDateTimeStamp::clearOTimeStamp() {
    if (hasOTimeStamp()) {
         clear_has_oTimeStamp();
        _oTimeStamp.clear();
     }
}

inline bool T_BTSetDateTimeStamp::hasOTimeStamp () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const T_BTSetTimeStamp& T_BTSetDateTimeStamp::getOTimeStamp () const {
    return _oTimeStamp;
}

inline T_BTSetTimeStamp& T_BTSetDateTimeStamp::getOTimeStampMutable () {
    set_has_oTimeStamp();
    return _oTimeStamp;
}

inline void T_BTSetDateTimeStamp::setOTimeStamp (const T_BTSetTimeStamp& oTimeStamp_) {
    set_has_oTimeStamp();
    this->_oTimeStamp = oTimeStamp_;
}

inline void T_BTSetDateTimeStamp::set_has_oDateStamp () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_BTSetDateTimeStamp::clear_has_oDateStamp () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_BTSetDateTimeStamp::set_has_oTimeStamp () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_BTSetDateTimeStamp::clear_has_oTimeStamp () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_BTSetDeviceRingtoneListResultItem::T_BTSetDeviceRingtoneListResultItem ()  :
    _u8DeviceHandle (0u),
    _sDeviceName (),
    _u16RingtoneID (0u),
    _sRingtoneName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_BTSetDeviceRingtoneListResultItem::T_BTSetDeviceRingtoneListResultItem (const T_BTSetDeviceRingtoneListResultItem &rhs)  :
    _u8DeviceHandle (0u),
    _sDeviceName (),
    _u16RingtoneID (0u),
    _sRingtoneName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_BTSetDeviceRingtoneListResultItem::T_BTSetDeviceRingtoneListResultItem (uint8 u8DeviceHandle_, const ::fi_basetypes_most::T_String& sDeviceName_, uint16 u16RingtoneID_, const ::fi_basetypes_most::T_String& sRingtoneName_)  :
    _u8DeviceHandle (u8DeviceHandle_),
    _sDeviceName (sDeviceName_),
    _u16RingtoneID (u16RingtoneID_),
    _sRingtoneName (sRingtoneName_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sRingtoneName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_BTSetDeviceRingtoneListResultItem::~T_BTSetDeviceRingtoneListResultItem() {
}

inline T_BTSetDeviceRingtoneListResultItem& T_BTSetDeviceRingtoneListResultItem::operator = (const T_BTSetDeviceRingtoneListResultItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8DeviceHandle()) {
            setU8DeviceHandle(rhs.getU8DeviceHandle());
        } else {
            clearU8DeviceHandle();
        }
        if (rhs.hasSDeviceName()) {
            setSDeviceName(rhs.getSDeviceName());
        } else {
            clearSDeviceName();
        }
        if (rhs.hasU16RingtoneID()) {
            setU16RingtoneID(rhs.getU16RingtoneID());
        } else {
            clearU16RingtoneID();
        }
        if (rhs.hasSRingtoneName()) {
            setSRingtoneName(rhs.getSRingtoneName());
        } else {
            clearSRingtoneName();
        }
    }
    return *this;
}

inline bool T_BTSetDeviceRingtoneListResultItem::operator == (const T_BTSetDeviceRingtoneListResultItem& rhs) const {
    return (((!hasU8DeviceHandle() && !rhs.hasU8DeviceHandle()) || getU8DeviceHandle() == rhs.getU8DeviceHandle()) &&
        ((!hasSDeviceName() && !rhs.hasSDeviceName()) || getSDeviceName() == rhs.getSDeviceName()) &&
        ((!hasU16RingtoneID() && !rhs.hasU16RingtoneID()) || getU16RingtoneID() == rhs.getU16RingtoneID()) &&
        ((!hasSRingtoneName() && !rhs.hasSRingtoneName()) || getSRingtoneName() == rhs.getSRingtoneName()));
}

inline bool T_BTSetDeviceRingtoneListResultItem::operator != (const T_BTSetDeviceRingtoneListResultItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_BTSetDeviceRingtoneListResultItem::operator < (const T_BTSetDeviceRingtoneListResultItem& rhs) const {
    if (hasU8DeviceHandle() || rhs.hasU8DeviceHandle()) {
        if (getU8DeviceHandle() < rhs.getU8DeviceHandle()) return true;
        if (getU8DeviceHandle() > rhs.getU8DeviceHandle()) return false;
    }
    if (hasSDeviceName() || rhs.hasSDeviceName()) {
        if (getSDeviceName() < rhs.getSDeviceName()) return true;
        if (getSDeviceName() > rhs.getSDeviceName()) return false;
    }
    if (hasU16RingtoneID() || rhs.hasU16RingtoneID()) {
        if (getU16RingtoneID() < rhs.getU16RingtoneID()) return true;
        if (getU16RingtoneID() > rhs.getU16RingtoneID()) return false;
    }
    if (hasSRingtoneName() || rhs.hasSRingtoneName()) {
        if (getSRingtoneName() < rhs.getSRingtoneName()) return true;
        if (getSRingtoneName() > rhs.getSRingtoneName()) return false;
    }
    return false;
}

inline bool T_BTSetDeviceRingtoneListResultItem::operator > (const T_BTSetDeviceRingtoneListResultItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_BTSetDeviceRingtoneListResultItem::clear() {
    clearU8DeviceHandle();
    clearSDeviceName();
    clearU16RingtoneID();
    clearSRingtoneName();
}

inline void T_BTSetDeviceRingtoneListResultItem::clearU8DeviceHandle() {
    if (hasU8DeviceHandle()) {
         clear_has_u8DeviceHandle();
        _u8DeviceHandle = 0u;
     }
}

inline bool T_BTSetDeviceRingtoneListResultItem::hasU8DeviceHandle () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_BTSetDeviceRingtoneListResultItem::getU8DeviceHandle () const {
    return _u8DeviceHandle;
}

inline void T_BTSetDeviceRingtoneListResultItem::setU8DeviceHandle (uint8 u8DeviceHandle_) {
    set_has_u8DeviceHandle();
    this->_u8DeviceHandle = u8DeviceHandle_;
}

inline void T_BTSetDeviceRingtoneListResultItem::clearSDeviceName() {
    if (hasSDeviceName()) {
         clear_has_sDeviceName();
        _sDeviceName.clear();
     }
}

inline bool T_BTSetDeviceRingtoneListResultItem::hasSDeviceName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_BTSetDeviceRingtoneListResultItem::getSDeviceName () const {
    return _sDeviceName;
}

inline ::fi_basetypes_most::T_String& T_BTSetDeviceRingtoneListResultItem::getSDeviceNameMutable () {
    set_has_sDeviceName();
    return _sDeviceName;
}

inline void T_BTSetDeviceRingtoneListResultItem::setSDeviceName (const ::fi_basetypes_most::T_String& sDeviceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDeviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDeviceName();
    this->_sDeviceName = sDeviceName_;
}

inline void T_BTSetDeviceRingtoneListResultItem::clearU16RingtoneID() {
    if (hasU16RingtoneID()) {
         clear_has_u16RingtoneID();
        _u16RingtoneID = 0u;
     }
}

inline bool T_BTSetDeviceRingtoneListResultItem::hasU16RingtoneID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 T_BTSetDeviceRingtoneListResultItem::getU16RingtoneID () const {
    return _u16RingtoneID;
}

inline void T_BTSetDeviceRingtoneListResultItem::setU16RingtoneID (uint16 u16RingtoneID_) {
    set_has_u16RingtoneID();
    this->_u16RingtoneID = u16RingtoneID_;
}

inline void T_BTSetDeviceRingtoneListResultItem::clearSRingtoneName() {
    if (hasSRingtoneName()) {
         clear_has_sRingtoneName();
        _sRingtoneName.clear();
     }
}

inline bool T_BTSetDeviceRingtoneListResultItem::hasSRingtoneName () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_BTSetDeviceRingtoneListResultItem::getSRingtoneName () const {
    return _sRingtoneName;
}

inline ::fi_basetypes_most::T_String& T_BTSetDeviceRingtoneListResultItem::getSRingtoneNameMutable () {
    set_has_sRingtoneName();
    return _sRingtoneName;
}

inline void T_BTSetDeviceRingtoneListResultItem::setSRingtoneName (const ::fi_basetypes_most::T_String& sRingtoneName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sRingtoneName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sRingtoneName();
    this->_sRingtoneName = sRingtoneName_;
}

inline void T_BTSetDeviceRingtoneListResultItem::set_has_u8DeviceHandle () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_BTSetDeviceRingtoneListResultItem::clear_has_u8DeviceHandle () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_BTSetDeviceRingtoneListResultItem::set_has_sDeviceName () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_BTSetDeviceRingtoneListResultItem::clear_has_sDeviceName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_BTSetDeviceRingtoneListResultItem::set_has_u16RingtoneID () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_BTSetDeviceRingtoneListResultItem::clear_has_u16RingtoneID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_BTSetDeviceRingtoneListResultItem::set_has_sRingtoneName () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_BTSetDeviceRingtoneListResultItem::clear_has_sRingtoneName () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  T_BTSetRingtoneListItem::T_BTSetRingtoneListItem ()  :
    _u16RingtoneID (0u),
    _sRingtoneName (),
    _bRingtoneAvailable (false),
    _bPlayRingtoneAvailable (false),
    _bActiveRingtone (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_BTSetRingtoneListItem::T_BTSetRingtoneListItem (const T_BTSetRingtoneListItem &rhs)  :
    _u16RingtoneID (0u),
    _sRingtoneName (),
    _bRingtoneAvailable (false),
    _bPlayRingtoneAvailable (false),
    _bActiveRingtone (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_BTSetRingtoneListItem::T_BTSetRingtoneListItem (uint16 u16RingtoneID_, const ::fi_basetypes_most::T_String& sRingtoneName_, bool bRingtoneAvailable_, bool bPlayRingtoneAvailable_, bool bActiveRingtone_)  :
    _u16RingtoneID (u16RingtoneID_),
    _sRingtoneName (sRingtoneName_),
    _bRingtoneAvailable (bRingtoneAvailable_),
    _bPlayRingtoneAvailable (bPlayRingtoneAvailable_),
    _bActiveRingtone (bActiveRingtone_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sRingtoneName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_BTSetRingtoneListItem::~T_BTSetRingtoneListItem() {
}

inline T_BTSetRingtoneListItem& T_BTSetRingtoneListItem::operator = (const T_BTSetRingtoneListItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU16RingtoneID()) {
            setU16RingtoneID(rhs.getU16RingtoneID());
        } else {
            clearU16RingtoneID();
        }
        if (rhs.hasSRingtoneName()) {
            setSRingtoneName(rhs.getSRingtoneName());
        } else {
            clearSRingtoneName();
        }
        if (rhs.hasBRingtoneAvailable()) {
            setBRingtoneAvailable(rhs.getBRingtoneAvailable());
        } else {
            clearBRingtoneAvailable();
        }
        if (rhs.hasBPlayRingtoneAvailable()) {
            setBPlayRingtoneAvailable(rhs.getBPlayRingtoneAvailable());
        } else {
            clearBPlayRingtoneAvailable();
        }
        if (rhs.hasBActiveRingtone()) {
            setBActiveRingtone(rhs.getBActiveRingtone());
        } else {
            clearBActiveRingtone();
        }
    }
    return *this;
}

inline bool T_BTSetRingtoneListItem::operator == (const T_BTSetRingtoneListItem& rhs) const {
    return (((!hasU16RingtoneID() && !rhs.hasU16RingtoneID()) || getU16RingtoneID() == rhs.getU16RingtoneID()) &&
        ((!hasSRingtoneName() && !rhs.hasSRingtoneName()) || getSRingtoneName() == rhs.getSRingtoneName()) &&
        ((!hasBRingtoneAvailable() && !rhs.hasBRingtoneAvailable()) || getBRingtoneAvailable() == rhs.getBRingtoneAvailable()) &&
        ((!hasBPlayRingtoneAvailable() && !rhs.hasBPlayRingtoneAvailable()) || getBPlayRingtoneAvailable() == rhs.getBPlayRingtoneAvailable()) &&
        ((!hasBActiveRingtone() && !rhs.hasBActiveRingtone()) || getBActiveRingtone() == rhs.getBActiveRingtone()));
}

inline bool T_BTSetRingtoneListItem::operator != (const T_BTSetRingtoneListItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_BTSetRingtoneListItem::operator < (const T_BTSetRingtoneListItem& rhs) const {
    if (hasU16RingtoneID() || rhs.hasU16RingtoneID()) {
        if (getU16RingtoneID() < rhs.getU16RingtoneID()) return true;
        if (getU16RingtoneID() > rhs.getU16RingtoneID()) return false;
    }
    if (hasSRingtoneName() || rhs.hasSRingtoneName()) {
        if (getSRingtoneName() < rhs.getSRingtoneName()) return true;
        if (getSRingtoneName() > rhs.getSRingtoneName()) return false;
    }
    if (hasBRingtoneAvailable() || rhs.hasBRingtoneAvailable()) {
        if (getBRingtoneAvailable() < rhs.getBRingtoneAvailable()) return true;
        if (getBRingtoneAvailable() > rhs.getBRingtoneAvailable()) return false;
    }
    if (hasBPlayRingtoneAvailable() || rhs.hasBPlayRingtoneAvailable()) {
        if (getBPlayRingtoneAvailable() < rhs.getBPlayRingtoneAvailable()) return true;
        if (getBPlayRingtoneAvailable() > rhs.getBPlayRingtoneAvailable()) return false;
    }
    if (hasBActiveRingtone() || rhs.hasBActiveRingtone()) {
        if (getBActiveRingtone() < rhs.getBActiveRingtone()) return true;
        if (getBActiveRingtone() > rhs.getBActiveRingtone()) return false;
    }
    return false;
}

inline bool T_BTSetRingtoneListItem::operator > (const T_BTSetRingtoneListItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_BTSetRingtoneListItem::clear() {
    clearU16RingtoneID();
    clearSRingtoneName();
    clearBRingtoneAvailable();
    clearBPlayRingtoneAvailable();
    clearBActiveRingtone();
}

inline void T_BTSetRingtoneListItem::clearU16RingtoneID() {
    if (hasU16RingtoneID()) {
         clear_has_u16RingtoneID();
        _u16RingtoneID = 0u;
     }
}

inline bool T_BTSetRingtoneListItem::hasU16RingtoneID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_BTSetRingtoneListItem::getU16RingtoneID () const {
    return _u16RingtoneID;
}

inline void T_BTSetRingtoneListItem::setU16RingtoneID (uint16 u16RingtoneID_) {
    set_has_u16RingtoneID();
    this->_u16RingtoneID = u16RingtoneID_;
}

inline void T_BTSetRingtoneListItem::clearSRingtoneName() {
    if (hasSRingtoneName()) {
         clear_has_sRingtoneName();
        _sRingtoneName.clear();
     }
}

inline bool T_BTSetRingtoneListItem::hasSRingtoneName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::fi_basetypes_most::T_String& T_BTSetRingtoneListItem::getSRingtoneName () const {
    return _sRingtoneName;
}

inline ::fi_basetypes_most::T_String& T_BTSetRingtoneListItem::getSRingtoneNameMutable () {
    set_has_sRingtoneName();
    return _sRingtoneName;
}

inline void T_BTSetRingtoneListItem::setSRingtoneName (const ::fi_basetypes_most::T_String& sRingtoneName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sRingtoneName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sRingtoneName();
    this->_sRingtoneName = sRingtoneName_;
}

inline void T_BTSetRingtoneListItem::clearBRingtoneAvailable() {
    if (hasBRingtoneAvailable()) {
         clear_has_bRingtoneAvailable();
        _bRingtoneAvailable = false;
     }
}

inline bool T_BTSetRingtoneListItem::hasBRingtoneAvailable () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool T_BTSetRingtoneListItem::getBRingtoneAvailable () const {
    return _bRingtoneAvailable;
}

inline void T_BTSetRingtoneListItem::setBRingtoneAvailable (bool bRingtoneAvailable_) {
    set_has_bRingtoneAvailable();
    this->_bRingtoneAvailable = bRingtoneAvailable_;
}

inline void T_BTSetRingtoneListItem::clearBPlayRingtoneAvailable() {
    if (hasBPlayRingtoneAvailable()) {
         clear_has_bPlayRingtoneAvailable();
        _bPlayRingtoneAvailable = false;
     }
}

inline bool T_BTSetRingtoneListItem::hasBPlayRingtoneAvailable () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline bool T_BTSetRingtoneListItem::getBPlayRingtoneAvailable () const {
    return _bPlayRingtoneAvailable;
}

inline void T_BTSetRingtoneListItem::setBPlayRingtoneAvailable (bool bPlayRingtoneAvailable_) {
    set_has_bPlayRingtoneAvailable();
    this->_bPlayRingtoneAvailable = bPlayRingtoneAvailable_;
}

inline void T_BTSetRingtoneListItem::clearBActiveRingtone() {
    if (hasBActiveRingtone()) {
         clear_has_bActiveRingtone();
        _bActiveRingtone = false;
     }
}

inline bool T_BTSetRingtoneListItem::hasBActiveRingtone () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline bool T_BTSetRingtoneListItem::getBActiveRingtone () const {
    return _bActiveRingtone;
}

inline void T_BTSetRingtoneListItem::setBActiveRingtone (bool bActiveRingtone_) {
    set_has_bActiveRingtone();
    this->_bActiveRingtone = bActiveRingtone_;
}

inline void T_BTSetRingtoneListItem::set_has_u16RingtoneID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_BTSetRingtoneListItem::clear_has_u16RingtoneID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_BTSetRingtoneListItem::set_has_sRingtoneName () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_BTSetRingtoneListItem::clear_has_sRingtoneName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_BTSetRingtoneListItem::set_has_bRingtoneAvailable () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_BTSetRingtoneListItem::clear_has_bRingtoneAvailable () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_BTSetRingtoneListItem::set_has_bPlayRingtoneAvailable () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_BTSetRingtoneListItem::clear_has_bPlayRingtoneAvailable () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_BTSetRingtoneListItem::set_has_bActiveRingtone () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_BTSetRingtoneListItem::clear_has_bActiveRingtone () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  T_BTSetDeviceControlSupport::T_BTSetDeviceControlSupport ()  :
    _bPlaySupport (false),
    _bPauseSupport (false),
    _bNextTrackSupport (false),
    _bPreviousTrackSupport (false),
    _bShuffleSupport (false),
    _bRepeatSupport (false),
    _bPlaytimeSupport (false),
    _bMetadataSupport (false),
    _bFolderBrowseSupport (false),
    _bMediaAggregrationSupport (false),
    _bFastForwardSupport (false),
    _bRewindSupport (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_BTSetDeviceControlSupport::T_BTSetDeviceControlSupport (const T_BTSetDeviceControlSupport &rhs)  :
    _bPlaySupport (false),
    _bPauseSupport (false),
    _bNextTrackSupport (false),
    _bPreviousTrackSupport (false),
    _bShuffleSupport (false),
    _bRepeatSupport (false),
    _bPlaytimeSupport (false),
    _bMetadataSupport (false),
    _bFolderBrowseSupport (false),
    _bMediaAggregrationSupport (false),
    _bFastForwardSupport (false),
    _bRewindSupport (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_BTSetDeviceControlSupport::T_BTSetDeviceControlSupport (bool bPlaySupport_, bool bPauseSupport_, bool bNextTrackSupport_, bool bPreviousTrackSupport_, bool bShuffleSupport_, bool bRepeatSupport_, bool bPlaytimeSupport_, bool bMetadataSupport_, bool bFolderBrowseSupport_, bool bMediaAggregrationSupport_, bool bFastForwardSupport_, bool bRewindSupport_)  :
    _bPlaySupport (bPlaySupport_),
    _bPauseSupport (bPauseSupport_),
    _bNextTrackSupport (bNextTrackSupport_),
    _bPreviousTrackSupport (bPreviousTrackSupport_),
    _bShuffleSupport (bShuffleSupport_),
    _bRepeatSupport (bRepeatSupport_),
    _bPlaytimeSupport (bPlaytimeSupport_),
    _bMetadataSupport (bMetadataSupport_),
    _bFolderBrowseSupport (bFolderBrowseSupport_),
    _bMediaAggregrationSupport (bMediaAggregrationSupport_),
    _bFastForwardSupport (bFastForwardSupport_),
    _bRewindSupport (bRewindSupport_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_BTSetDeviceControlSupport::~T_BTSetDeviceControlSupport() {
}

inline T_BTSetDeviceControlSupport& T_BTSetDeviceControlSupport::operator = (const T_BTSetDeviceControlSupport& rhs) {
    if( this != &rhs ) {
        if (rhs.hasBPlaySupport()) {
            setBPlaySupport(rhs.getBPlaySupport());
        } else {
            clearBPlaySupport();
        }
        if (rhs.hasBPauseSupport()) {
            setBPauseSupport(rhs.getBPauseSupport());
        } else {
            clearBPauseSupport();
        }
        if (rhs.hasBNextTrackSupport()) {
            setBNextTrackSupport(rhs.getBNextTrackSupport());
        } else {
            clearBNextTrackSupport();
        }
        if (rhs.hasBPreviousTrackSupport()) {
            setBPreviousTrackSupport(rhs.getBPreviousTrackSupport());
        } else {
            clearBPreviousTrackSupport();
        }
        if (rhs.hasBShuffleSupport()) {
            setBShuffleSupport(rhs.getBShuffleSupport());
        } else {
            clearBShuffleSupport();
        }
        if (rhs.hasBRepeatSupport()) {
            setBRepeatSupport(rhs.getBRepeatSupport());
        } else {
            clearBRepeatSupport();
        }
        if (rhs.hasBPlaytimeSupport()) {
            setBPlaytimeSupport(rhs.getBPlaytimeSupport());
        } else {
            clearBPlaytimeSupport();
        }
        if (rhs.hasBMetadataSupport()) {
            setBMetadataSupport(rhs.getBMetadataSupport());
        } else {
            clearBMetadataSupport();
        }
        if (rhs.hasBFolderBrowseSupport()) {
            setBFolderBrowseSupport(rhs.getBFolderBrowseSupport());
        } else {
            clearBFolderBrowseSupport();
        }
        if (rhs.hasBMediaAggregrationSupport()) {
            setBMediaAggregrationSupport(rhs.getBMediaAggregrationSupport());
        } else {
            clearBMediaAggregrationSupport();
        }
        if (rhs.hasBFastForwardSupport()) {
            setBFastForwardSupport(rhs.getBFastForwardSupport());
        } else {
            clearBFastForwardSupport();
        }
        if (rhs.hasBRewindSupport()) {
            setBRewindSupport(rhs.getBRewindSupport());
        } else {
            clearBRewindSupport();
        }
    }
    return *this;
}

inline bool T_BTSetDeviceControlSupport::operator == (const T_BTSetDeviceControlSupport& rhs) const {
    return (((!hasBPlaySupport() && !rhs.hasBPlaySupport()) || getBPlaySupport() == rhs.getBPlaySupport()) &&
        ((!hasBPauseSupport() && !rhs.hasBPauseSupport()) || getBPauseSupport() == rhs.getBPauseSupport()) &&
        ((!hasBNextTrackSupport() && !rhs.hasBNextTrackSupport()) || getBNextTrackSupport() == rhs.getBNextTrackSupport()) &&
        ((!hasBPreviousTrackSupport() && !rhs.hasBPreviousTrackSupport()) || getBPreviousTrackSupport() == rhs.getBPreviousTrackSupport()) &&
        ((!hasBShuffleSupport() && !rhs.hasBShuffleSupport()) || getBShuffleSupport() == rhs.getBShuffleSupport()) &&
        ((!hasBRepeatSupport() && !rhs.hasBRepeatSupport()) || getBRepeatSupport() == rhs.getBRepeatSupport()) &&
        ((!hasBPlaytimeSupport() && !rhs.hasBPlaytimeSupport()) || getBPlaytimeSupport() == rhs.getBPlaytimeSupport()) &&
        ((!hasBMetadataSupport() && !rhs.hasBMetadataSupport()) || getBMetadataSupport() == rhs.getBMetadataSupport()) &&
        ((!hasBFolderBrowseSupport() && !rhs.hasBFolderBrowseSupport()) || getBFolderBrowseSupport() == rhs.getBFolderBrowseSupport()) &&
        ((!hasBMediaAggregrationSupport() && !rhs.hasBMediaAggregrationSupport()) || getBMediaAggregrationSupport() == rhs.getBMediaAggregrationSupport()) &&
        ((!hasBFastForwardSupport() && !rhs.hasBFastForwardSupport()) || getBFastForwardSupport() == rhs.getBFastForwardSupport()) &&
        ((!hasBRewindSupport() && !rhs.hasBRewindSupport()) || getBRewindSupport() == rhs.getBRewindSupport()));
}

inline bool T_BTSetDeviceControlSupport::operator != (const T_BTSetDeviceControlSupport& rhs) const {
    return ! (*this == rhs);
}

inline bool T_BTSetDeviceControlSupport::operator < (const T_BTSetDeviceControlSupport& rhs) const {
    if (hasBPlaySupport() || rhs.hasBPlaySupport()) {
        if (getBPlaySupport() < rhs.getBPlaySupport()) return true;
        if (getBPlaySupport() > rhs.getBPlaySupport()) return false;
    }
    if (hasBPauseSupport() || rhs.hasBPauseSupport()) {
        if (getBPauseSupport() < rhs.getBPauseSupport()) return true;
        if (getBPauseSupport() > rhs.getBPauseSupport()) return false;
    }
    if (hasBNextTrackSupport() || rhs.hasBNextTrackSupport()) {
        if (getBNextTrackSupport() < rhs.getBNextTrackSupport()) return true;
        if (getBNextTrackSupport() > rhs.getBNextTrackSupport()) return false;
    }
    if (hasBPreviousTrackSupport() || rhs.hasBPreviousTrackSupport()) {
        if (getBPreviousTrackSupport() < rhs.getBPreviousTrackSupport()) return true;
        if (getBPreviousTrackSupport() > rhs.getBPreviousTrackSupport()) return false;
    }
    if (hasBShuffleSupport() || rhs.hasBShuffleSupport()) {
        if (getBShuffleSupport() < rhs.getBShuffleSupport()) return true;
        if (getBShuffleSupport() > rhs.getBShuffleSupport()) return false;
    }
    if (hasBRepeatSupport() || rhs.hasBRepeatSupport()) {
        if (getBRepeatSupport() < rhs.getBRepeatSupport()) return true;
        if (getBRepeatSupport() > rhs.getBRepeatSupport()) return false;
    }
    if (hasBPlaytimeSupport() || rhs.hasBPlaytimeSupport()) {
        if (getBPlaytimeSupport() < rhs.getBPlaytimeSupport()) return true;
        if (getBPlaytimeSupport() > rhs.getBPlaytimeSupport()) return false;
    }
    if (hasBMetadataSupport() || rhs.hasBMetadataSupport()) {
        if (getBMetadataSupport() < rhs.getBMetadataSupport()) return true;
        if (getBMetadataSupport() > rhs.getBMetadataSupport()) return false;
    }
    if (hasBFolderBrowseSupport() || rhs.hasBFolderBrowseSupport()) {
        if (getBFolderBrowseSupport() < rhs.getBFolderBrowseSupport()) return true;
        if (getBFolderBrowseSupport() > rhs.getBFolderBrowseSupport()) return false;
    }
    if (hasBMediaAggregrationSupport() || rhs.hasBMediaAggregrationSupport()) {
        if (getBMediaAggregrationSupport() < rhs.getBMediaAggregrationSupport()) return true;
        if (getBMediaAggregrationSupport() > rhs.getBMediaAggregrationSupport()) return false;
    }
    if (hasBFastForwardSupport() || rhs.hasBFastForwardSupport()) {
        if (getBFastForwardSupport() < rhs.getBFastForwardSupport()) return true;
        if (getBFastForwardSupport() > rhs.getBFastForwardSupport()) return false;
    }
    if (hasBRewindSupport() || rhs.hasBRewindSupport()) {
        if (getBRewindSupport() < rhs.getBRewindSupport()) return true;
        if (getBRewindSupport() > rhs.getBRewindSupport()) return false;
    }
    return false;
}

inline bool T_BTSetDeviceControlSupport::operator > (const T_BTSetDeviceControlSupport& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_BTSetDeviceControlSupport::clear() {
    clearBPlaySupport();
    clearBPauseSupport();
    clearBNextTrackSupport();
    clearBPreviousTrackSupport();
    clearBShuffleSupport();
    clearBRepeatSupport();
    clearBPlaytimeSupport();
    clearBMetadataSupport();
    clearBFolderBrowseSupport();
    clearBMediaAggregrationSupport();
    clearBFastForwardSupport();
    clearBRewindSupport();
}

inline void T_BTSetDeviceControlSupport::clearBPlaySupport() {
    if (hasBPlaySupport()) {
         clear_has_bPlaySupport();
        _bPlaySupport = false;
     }
}

inline bool T_BTSetDeviceControlSupport::hasBPlaySupport () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool T_BTSetDeviceControlSupport::getBPlaySupport () const {
    return _bPlaySupport;
}

inline void T_BTSetDeviceControlSupport::setBPlaySupport (bool bPlaySupport_) {
    set_has_bPlaySupport();
    this->_bPlaySupport = bPlaySupport_;
}

inline void T_BTSetDeviceControlSupport::clearBPauseSupport() {
    if (hasBPauseSupport()) {
         clear_has_bPauseSupport();
        _bPauseSupport = false;
     }
}

inline bool T_BTSetDeviceControlSupport::hasBPauseSupport () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool T_BTSetDeviceControlSupport::getBPauseSupport () const {
    return _bPauseSupport;
}

inline void T_BTSetDeviceControlSupport::setBPauseSupport (bool bPauseSupport_) {
    set_has_bPauseSupport();
    this->_bPauseSupport = bPauseSupport_;
}

inline void T_BTSetDeviceControlSupport::clearBNextTrackSupport() {
    if (hasBNextTrackSupport()) {
         clear_has_bNextTrackSupport();
        _bNextTrackSupport = false;
     }
}

inline bool T_BTSetDeviceControlSupport::hasBNextTrackSupport () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool T_BTSetDeviceControlSupport::getBNextTrackSupport () const {
    return _bNextTrackSupport;
}

inline void T_BTSetDeviceControlSupport::setBNextTrackSupport (bool bNextTrackSupport_) {
    set_has_bNextTrackSupport();
    this->_bNextTrackSupport = bNextTrackSupport_;
}

inline void T_BTSetDeviceControlSupport::clearBPreviousTrackSupport() {
    if (hasBPreviousTrackSupport()) {
         clear_has_bPreviousTrackSupport();
        _bPreviousTrackSupport = false;
     }
}

inline bool T_BTSetDeviceControlSupport::hasBPreviousTrackSupport () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline bool T_BTSetDeviceControlSupport::getBPreviousTrackSupport () const {
    return _bPreviousTrackSupport;
}

inline void T_BTSetDeviceControlSupport::setBPreviousTrackSupport (bool bPreviousTrackSupport_) {
    set_has_bPreviousTrackSupport();
    this->_bPreviousTrackSupport = bPreviousTrackSupport_;
}

inline void T_BTSetDeviceControlSupport::clearBShuffleSupport() {
    if (hasBShuffleSupport()) {
         clear_has_bShuffleSupport();
        _bShuffleSupport = false;
     }
}

inline bool T_BTSetDeviceControlSupport::hasBShuffleSupport () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline bool T_BTSetDeviceControlSupport::getBShuffleSupport () const {
    return _bShuffleSupport;
}

inline void T_BTSetDeviceControlSupport::setBShuffleSupport (bool bShuffleSupport_) {
    set_has_bShuffleSupport();
    this->_bShuffleSupport = bShuffleSupport_;
}

inline void T_BTSetDeviceControlSupport::clearBRepeatSupport() {
    if (hasBRepeatSupport()) {
         clear_has_bRepeatSupport();
        _bRepeatSupport = false;
     }
}

inline bool T_BTSetDeviceControlSupport::hasBRepeatSupport () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline bool T_BTSetDeviceControlSupport::getBRepeatSupport () const {
    return _bRepeatSupport;
}

inline void T_BTSetDeviceControlSupport::setBRepeatSupport (bool bRepeatSupport_) {
    set_has_bRepeatSupport();
    this->_bRepeatSupport = bRepeatSupport_;
}

inline void T_BTSetDeviceControlSupport::clearBPlaytimeSupport() {
    if (hasBPlaytimeSupport()) {
         clear_has_bPlaytimeSupport();
        _bPlaytimeSupport = false;
     }
}

inline bool T_BTSetDeviceControlSupport::hasBPlaytimeSupport () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline bool T_BTSetDeviceControlSupport::getBPlaytimeSupport () const {
    return _bPlaytimeSupport;
}

inline void T_BTSetDeviceControlSupport::setBPlaytimeSupport (bool bPlaytimeSupport_) {
    set_has_bPlaytimeSupport();
    this->_bPlaytimeSupport = bPlaytimeSupport_;
}

inline void T_BTSetDeviceControlSupport::clearBMetadataSupport() {
    if (hasBMetadataSupport()) {
         clear_has_bMetadataSupport();
        _bMetadataSupport = false;
     }
}

inline bool T_BTSetDeviceControlSupport::hasBMetadataSupport () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline bool T_BTSetDeviceControlSupport::getBMetadataSupport () const {
    return _bMetadataSupport;
}

inline void T_BTSetDeviceControlSupport::setBMetadataSupport (bool bMetadataSupport_) {
    set_has_bMetadataSupport();
    this->_bMetadataSupport = bMetadataSupport_;
}

inline void T_BTSetDeviceControlSupport::clearBFolderBrowseSupport() {
    if (hasBFolderBrowseSupport()) {
         clear_has_bFolderBrowseSupport();
        _bFolderBrowseSupport = false;
     }
}

inline bool T_BTSetDeviceControlSupport::hasBFolderBrowseSupport () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline bool T_BTSetDeviceControlSupport::getBFolderBrowseSupport () const {
    return _bFolderBrowseSupport;
}

inline void T_BTSetDeviceControlSupport::setBFolderBrowseSupport (bool bFolderBrowseSupport_) {
    set_has_bFolderBrowseSupport();
    this->_bFolderBrowseSupport = bFolderBrowseSupport_;
}

inline void T_BTSetDeviceControlSupport::clearBMediaAggregrationSupport() {
    if (hasBMediaAggregrationSupport()) {
         clear_has_bMediaAggregrationSupport();
        _bMediaAggregrationSupport = false;
     }
}

inline bool T_BTSetDeviceControlSupport::hasBMediaAggregrationSupport () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline bool T_BTSetDeviceControlSupport::getBMediaAggregrationSupport () const {
    return _bMediaAggregrationSupport;
}

inline void T_BTSetDeviceControlSupport::setBMediaAggregrationSupport (bool bMediaAggregrationSupport_) {
    set_has_bMediaAggregrationSupport();
    this->_bMediaAggregrationSupport = bMediaAggregrationSupport_;
}

inline void T_BTSetDeviceControlSupport::clearBFastForwardSupport() {
    if (hasBFastForwardSupport()) {
         clear_has_bFastForwardSupport();
        _bFastForwardSupport = false;
     }
}

inline bool T_BTSetDeviceControlSupport::hasBFastForwardSupport () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline bool T_BTSetDeviceControlSupport::getBFastForwardSupport () const {
    return _bFastForwardSupport;
}

inline void T_BTSetDeviceControlSupport::setBFastForwardSupport (bool bFastForwardSupport_) {
    set_has_bFastForwardSupport();
    this->_bFastForwardSupport = bFastForwardSupport_;
}

inline void T_BTSetDeviceControlSupport::clearBRewindSupport() {
    if (hasBRewindSupport()) {
         clear_has_bRewindSupport();
        _bRewindSupport = false;
     }
}

inline bool T_BTSetDeviceControlSupport::hasBRewindSupport () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline bool T_BTSetDeviceControlSupport::getBRewindSupport () const {
    return _bRewindSupport;
}

inline void T_BTSetDeviceControlSupport::setBRewindSupport (bool bRewindSupport_) {
    set_has_bRewindSupport();
    this->_bRewindSupport = bRewindSupport_;
}

inline void T_BTSetDeviceControlSupport::set_has_bPlaySupport () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_BTSetDeviceControlSupport::clear_has_bPlaySupport () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_BTSetDeviceControlSupport::set_has_bPauseSupport () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_BTSetDeviceControlSupport::clear_has_bPauseSupport () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_BTSetDeviceControlSupport::set_has_bNextTrackSupport () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_BTSetDeviceControlSupport::clear_has_bNextTrackSupport () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_BTSetDeviceControlSupport::set_has_bPreviousTrackSupport () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_BTSetDeviceControlSupport::clear_has_bPreviousTrackSupport () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_BTSetDeviceControlSupport::set_has_bShuffleSupport () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_BTSetDeviceControlSupport::clear_has_bShuffleSupport () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_BTSetDeviceControlSupport::set_has_bRepeatSupport () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_BTSetDeviceControlSupport::clear_has_bRepeatSupport () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_BTSetDeviceControlSupport::set_has_bPlaytimeSupport () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_BTSetDeviceControlSupport::clear_has_bPlaytimeSupport () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_BTSetDeviceControlSupport::set_has_bMetadataSupport () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_BTSetDeviceControlSupport::clear_has_bMetadataSupport () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_BTSetDeviceControlSupport::set_has_bFolderBrowseSupport () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_BTSetDeviceControlSupport::clear_has_bFolderBrowseSupport () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_BTSetDeviceControlSupport::set_has_bMediaAggregrationSupport () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_BTSetDeviceControlSupport::clear_has_bMediaAggregrationSupport () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_BTSetDeviceControlSupport::set_has_bFastForwardSupport () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_BTSetDeviceControlSupport::clear_has_bFastForwardSupport () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_BTSetDeviceControlSupport::set_has_bRewindSupport () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_BTSetDeviceControlSupport::clear_has_bRewindSupport () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline  T_BTSetBluetoothFeatureSupport::T_BTSetBluetoothFeatureSupport ()  :
    _bHandsFreeSupport (false),
    _bPhoneBookSupport (false),
    _bAudioStreamingSupport (false),
    _e8AudioStreamingSupportType (::most_BTSet_fi_types::T_e8_BTSetAudioStreamingSupportType__e8AVRCP_NO_METADATA),
    _bMessagingSupport (false),
    _bInternetAccessSupport (false),
    _e8InternetAccessSupportType (::most_BTSet_fi_types::T_e8_BTSetInternetAccessSupportType__e8DUN_SUPPORTED),
    _bPortableNavigationSupport (false),
    _bSerialPortSupport (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_BTSetBluetoothFeatureSupport::T_BTSetBluetoothFeatureSupport (const T_BTSetBluetoothFeatureSupport &rhs)  :
    _bHandsFreeSupport (false),
    _bPhoneBookSupport (false),
    _bAudioStreamingSupport (false),
    _e8AudioStreamingSupportType (::most_BTSet_fi_types::T_e8_BTSetAudioStreamingSupportType__e8AVRCP_NO_METADATA),
    _bMessagingSupport (false),
    _bInternetAccessSupport (false),
    _e8InternetAccessSupportType (::most_BTSet_fi_types::T_e8_BTSetInternetAccessSupportType__e8DUN_SUPPORTED),
    _bPortableNavigationSupport (false),
    _bSerialPortSupport (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_BTSetBluetoothFeatureSupport::T_BTSetBluetoothFeatureSupport (bool bHandsFreeSupport_, bool bPhoneBookSupport_, bool bAudioStreamingSupport_, T_e8_BTSetAudioStreamingSupportType e8AudioStreamingSupportType_, bool bMessagingSupport_, bool bInternetAccessSupport_, T_e8_BTSetInternetAccessSupportType e8InternetAccessSupportType_, bool bPortableNavigationSupport_, bool bSerialPortSupport_)  :
    _bHandsFreeSupport (bHandsFreeSupport_),
    _bPhoneBookSupport (bPhoneBookSupport_),
    _bAudioStreamingSupport (bAudioStreamingSupport_),
    _e8AudioStreamingSupportType (e8AudioStreamingSupportType_),
    _bMessagingSupport (bMessagingSupport_),
    _bInternetAccessSupport (bInternetAccessSupport_),
    _e8InternetAccessSupportType (e8InternetAccessSupportType_),
    _bPortableNavigationSupport (bPortableNavigationSupport_),
    _bSerialPortSupport (bSerialPortSupport_)
{
    #ifndef NDEBUG
    if (!(T_e8_BTSetAudioStreamingSupportType_IsValid(e8AudioStreamingSupportType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8AudioStreamingSupportType_, "T_e8_BTSetAudioStreamingSupportType", "e8AudioStreamingSupportType", "T_BTSetBluetoothFeatureSupport");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_BTSetInternetAccessSupportType_IsValid(e8InternetAccessSupportType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8InternetAccessSupportType_, "T_e8_BTSetInternetAccessSupportType", "e8InternetAccessSupportType", "T_BTSetBluetoothFeatureSupport");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_BTSetBluetoothFeatureSupport::~T_BTSetBluetoothFeatureSupport() {
}

inline T_BTSetBluetoothFeatureSupport& T_BTSetBluetoothFeatureSupport::operator = (const T_BTSetBluetoothFeatureSupport& rhs) {
    if( this != &rhs ) {
        if (rhs.hasBHandsFreeSupport()) {
            setBHandsFreeSupport(rhs.getBHandsFreeSupport());
        } else {
            clearBHandsFreeSupport();
        }
        if (rhs.hasBPhoneBookSupport()) {
            setBPhoneBookSupport(rhs.getBPhoneBookSupport());
        } else {
            clearBPhoneBookSupport();
        }
        if (rhs.hasBAudioStreamingSupport()) {
            setBAudioStreamingSupport(rhs.getBAudioStreamingSupport());
        } else {
            clearBAudioStreamingSupport();
        }
        if (rhs.hasE8AudioStreamingSupportType()) {
            setE8AudioStreamingSupportType(rhs.getE8AudioStreamingSupportType());
        } else {
            clearE8AudioStreamingSupportType();
        }
        if (rhs.hasBMessagingSupport()) {
            setBMessagingSupport(rhs.getBMessagingSupport());
        } else {
            clearBMessagingSupport();
        }
        if (rhs.hasBInternetAccessSupport()) {
            setBInternetAccessSupport(rhs.getBInternetAccessSupport());
        } else {
            clearBInternetAccessSupport();
        }
        if (rhs.hasE8InternetAccessSupportType()) {
            setE8InternetAccessSupportType(rhs.getE8InternetAccessSupportType());
        } else {
            clearE8InternetAccessSupportType();
        }
        if (rhs.hasBPortableNavigationSupport()) {
            setBPortableNavigationSupport(rhs.getBPortableNavigationSupport());
        } else {
            clearBPortableNavigationSupport();
        }
        if (rhs.hasBSerialPortSupport()) {
            setBSerialPortSupport(rhs.getBSerialPortSupport());
        } else {
            clearBSerialPortSupport();
        }
    }
    return *this;
}

inline bool T_BTSetBluetoothFeatureSupport::operator == (const T_BTSetBluetoothFeatureSupport& rhs) const {
    return (((!hasBHandsFreeSupport() && !rhs.hasBHandsFreeSupport()) || getBHandsFreeSupport() == rhs.getBHandsFreeSupport()) &&
        ((!hasBPhoneBookSupport() && !rhs.hasBPhoneBookSupport()) || getBPhoneBookSupport() == rhs.getBPhoneBookSupport()) &&
        ((!hasBAudioStreamingSupport() && !rhs.hasBAudioStreamingSupport()) || getBAudioStreamingSupport() == rhs.getBAudioStreamingSupport()) &&
        ((!hasE8AudioStreamingSupportType() && !rhs.hasE8AudioStreamingSupportType()) || getE8AudioStreamingSupportType() == rhs.getE8AudioStreamingSupportType()) &&
        ((!hasBMessagingSupport() && !rhs.hasBMessagingSupport()) || getBMessagingSupport() == rhs.getBMessagingSupport()) &&
        ((!hasBInternetAccessSupport() && !rhs.hasBInternetAccessSupport()) || getBInternetAccessSupport() == rhs.getBInternetAccessSupport()) &&
        ((!hasE8InternetAccessSupportType() && !rhs.hasE8InternetAccessSupportType()) || getE8InternetAccessSupportType() == rhs.getE8InternetAccessSupportType()) &&
        ((!hasBPortableNavigationSupport() && !rhs.hasBPortableNavigationSupport()) || getBPortableNavigationSupport() == rhs.getBPortableNavigationSupport()) &&
        ((!hasBSerialPortSupport() && !rhs.hasBSerialPortSupport()) || getBSerialPortSupport() == rhs.getBSerialPortSupport()));
}

inline bool T_BTSetBluetoothFeatureSupport::operator != (const T_BTSetBluetoothFeatureSupport& rhs) const {
    return ! (*this == rhs);
}

inline bool T_BTSetBluetoothFeatureSupport::operator < (const T_BTSetBluetoothFeatureSupport& rhs) const {
    if (hasBHandsFreeSupport() || rhs.hasBHandsFreeSupport()) {
        if (getBHandsFreeSupport() < rhs.getBHandsFreeSupport()) return true;
        if (getBHandsFreeSupport() > rhs.getBHandsFreeSupport()) return false;
    }
    if (hasBPhoneBookSupport() || rhs.hasBPhoneBookSupport()) {
        if (getBPhoneBookSupport() < rhs.getBPhoneBookSupport()) return true;
        if (getBPhoneBookSupport() > rhs.getBPhoneBookSupport()) return false;
    }
    if (hasBAudioStreamingSupport() || rhs.hasBAudioStreamingSupport()) {
        if (getBAudioStreamingSupport() < rhs.getBAudioStreamingSupport()) return true;
        if (getBAudioStreamingSupport() > rhs.getBAudioStreamingSupport()) return false;
    }
    if (hasE8AudioStreamingSupportType() || rhs.hasE8AudioStreamingSupportType()) {
        if ((uint32)getE8AudioStreamingSupportType() < (uint32)rhs.getE8AudioStreamingSupportType()) return true;
        if ((uint32)getE8AudioStreamingSupportType() > (uint32)rhs.getE8AudioStreamingSupportType()) return false;
    }
    if (hasBMessagingSupport() || rhs.hasBMessagingSupport()) {
        if (getBMessagingSupport() < rhs.getBMessagingSupport()) return true;
        if (getBMessagingSupport() > rhs.getBMessagingSupport()) return false;
    }
    if (hasBInternetAccessSupport() || rhs.hasBInternetAccessSupport()) {
        if (getBInternetAccessSupport() < rhs.getBInternetAccessSupport()) return true;
        if (getBInternetAccessSupport() > rhs.getBInternetAccessSupport()) return false;
    }
    if (hasE8InternetAccessSupportType() || rhs.hasE8InternetAccessSupportType()) {
        if ((uint32)getE8InternetAccessSupportType() < (uint32)rhs.getE8InternetAccessSupportType()) return true;
        if ((uint32)getE8InternetAccessSupportType() > (uint32)rhs.getE8InternetAccessSupportType()) return false;
    }
    if (hasBPortableNavigationSupport() || rhs.hasBPortableNavigationSupport()) {
        if (getBPortableNavigationSupport() < rhs.getBPortableNavigationSupport()) return true;
        if (getBPortableNavigationSupport() > rhs.getBPortableNavigationSupport()) return false;
    }
    if (hasBSerialPortSupport() || rhs.hasBSerialPortSupport()) {
        if (getBSerialPortSupport() < rhs.getBSerialPortSupport()) return true;
        if (getBSerialPortSupport() > rhs.getBSerialPortSupport()) return false;
    }
    return false;
}

inline bool T_BTSetBluetoothFeatureSupport::operator > (const T_BTSetBluetoothFeatureSupport& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_BTSetBluetoothFeatureSupport::clear() {
    clearBHandsFreeSupport();
    clearBPhoneBookSupport();
    clearBAudioStreamingSupport();
    clearE8AudioStreamingSupportType();
    clearBMessagingSupport();
    clearBInternetAccessSupport();
    clearE8InternetAccessSupportType();
    clearBPortableNavigationSupport();
    clearBSerialPortSupport();
}

inline void T_BTSetBluetoothFeatureSupport::clearBHandsFreeSupport() {
    if (hasBHandsFreeSupport()) {
         clear_has_bHandsFreeSupport();
        _bHandsFreeSupport = false;
     }
}

inline bool T_BTSetBluetoothFeatureSupport::hasBHandsFreeSupport () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool T_BTSetBluetoothFeatureSupport::getBHandsFreeSupport () const {
    return _bHandsFreeSupport;
}

inline void T_BTSetBluetoothFeatureSupport::setBHandsFreeSupport (bool bHandsFreeSupport_) {
    set_has_bHandsFreeSupport();
    this->_bHandsFreeSupport = bHandsFreeSupport_;
}

inline void T_BTSetBluetoothFeatureSupport::clearBPhoneBookSupport() {
    if (hasBPhoneBookSupport()) {
         clear_has_bPhoneBookSupport();
        _bPhoneBookSupport = false;
     }
}

inline bool T_BTSetBluetoothFeatureSupport::hasBPhoneBookSupport () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool T_BTSetBluetoothFeatureSupport::getBPhoneBookSupport () const {
    return _bPhoneBookSupport;
}

inline void T_BTSetBluetoothFeatureSupport::setBPhoneBookSupport (bool bPhoneBookSupport_) {
    set_has_bPhoneBookSupport();
    this->_bPhoneBookSupport = bPhoneBookSupport_;
}

inline void T_BTSetBluetoothFeatureSupport::clearBAudioStreamingSupport() {
    if (hasBAudioStreamingSupport()) {
         clear_has_bAudioStreamingSupport();
        _bAudioStreamingSupport = false;
     }
}

inline bool T_BTSetBluetoothFeatureSupport::hasBAudioStreamingSupport () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool T_BTSetBluetoothFeatureSupport::getBAudioStreamingSupport () const {
    return _bAudioStreamingSupport;
}

inline void T_BTSetBluetoothFeatureSupport::setBAudioStreamingSupport (bool bAudioStreamingSupport_) {
    set_has_bAudioStreamingSupport();
    this->_bAudioStreamingSupport = bAudioStreamingSupport_;
}

inline void T_BTSetBluetoothFeatureSupport::clearE8AudioStreamingSupportType() {
    if (hasE8AudioStreamingSupportType()) {
         clear_has_e8AudioStreamingSupportType();
        _e8AudioStreamingSupportType = ::most_BTSet_fi_types::T_e8_BTSetAudioStreamingSupportType__e8AVRCP_NO_METADATA;
     }
}

inline bool T_BTSetBluetoothFeatureSupport::hasE8AudioStreamingSupportType () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline T_e8_BTSetAudioStreamingSupportType T_BTSetBluetoothFeatureSupport::getE8AudioStreamingSupportType () const {
    return _e8AudioStreamingSupportType;
}

inline void T_BTSetBluetoothFeatureSupport::setE8AudioStreamingSupportType (T_e8_BTSetAudioStreamingSupportType e8AudioStreamingSupportType_) {
    #ifndef NDEBUG
    if (!(T_e8_BTSetAudioStreamingSupportType_IsValid(e8AudioStreamingSupportType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8AudioStreamingSupportType_, "T_e8_BTSetAudioStreamingSupportType", "e8AudioStreamingSupportType", "T_BTSetBluetoothFeatureSupport");
    }
    #endif
    set_has_e8AudioStreamingSupportType();
    this->_e8AudioStreamingSupportType = e8AudioStreamingSupportType_;
}

inline void T_BTSetBluetoothFeatureSupport::clearBMessagingSupport() {
    if (hasBMessagingSupport()) {
         clear_has_bMessagingSupport();
        _bMessagingSupport = false;
     }
}

inline bool T_BTSetBluetoothFeatureSupport::hasBMessagingSupport () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline bool T_BTSetBluetoothFeatureSupport::getBMessagingSupport () const {
    return _bMessagingSupport;
}

inline void T_BTSetBluetoothFeatureSupport::setBMessagingSupport (bool bMessagingSupport_) {
    set_has_bMessagingSupport();
    this->_bMessagingSupport = bMessagingSupport_;
}

inline void T_BTSetBluetoothFeatureSupport::clearBInternetAccessSupport() {
    if (hasBInternetAccessSupport()) {
         clear_has_bInternetAccessSupport();
        _bInternetAccessSupport = false;
     }
}

inline bool T_BTSetBluetoothFeatureSupport::hasBInternetAccessSupport () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline bool T_BTSetBluetoothFeatureSupport::getBInternetAccessSupport () const {
    return _bInternetAccessSupport;
}

inline void T_BTSetBluetoothFeatureSupport::setBInternetAccessSupport (bool bInternetAccessSupport_) {
    set_has_bInternetAccessSupport();
    this->_bInternetAccessSupport = bInternetAccessSupport_;
}

inline void T_BTSetBluetoothFeatureSupport::clearE8InternetAccessSupportType() {
    if (hasE8InternetAccessSupportType()) {
         clear_has_e8InternetAccessSupportType();
        _e8InternetAccessSupportType = ::most_BTSet_fi_types::T_e8_BTSetInternetAccessSupportType__e8DUN_SUPPORTED;
     }
}

inline bool T_BTSetBluetoothFeatureSupport::hasE8InternetAccessSupportType () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline T_e8_BTSetInternetAccessSupportType T_BTSetBluetoothFeatureSupport::getE8InternetAccessSupportType () const {
    return _e8InternetAccessSupportType;
}

inline void T_BTSetBluetoothFeatureSupport::setE8InternetAccessSupportType (T_e8_BTSetInternetAccessSupportType e8InternetAccessSupportType_) {
    #ifndef NDEBUG
    if (!(T_e8_BTSetInternetAccessSupportType_IsValid(e8InternetAccessSupportType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8InternetAccessSupportType_, "T_e8_BTSetInternetAccessSupportType", "e8InternetAccessSupportType", "T_BTSetBluetoothFeatureSupport");
    }
    #endif
    set_has_e8InternetAccessSupportType();
    this->_e8InternetAccessSupportType = e8InternetAccessSupportType_;
}

inline void T_BTSetBluetoothFeatureSupport::clearBPortableNavigationSupport() {
    if (hasBPortableNavigationSupport()) {
         clear_has_bPortableNavigationSupport();
        _bPortableNavigationSupport = false;
     }
}

inline bool T_BTSetBluetoothFeatureSupport::hasBPortableNavigationSupport () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline bool T_BTSetBluetoothFeatureSupport::getBPortableNavigationSupport () const {
    return _bPortableNavigationSupport;
}

inline void T_BTSetBluetoothFeatureSupport::setBPortableNavigationSupport (bool bPortableNavigationSupport_) {
    set_has_bPortableNavigationSupport();
    this->_bPortableNavigationSupport = bPortableNavigationSupport_;
}

inline void T_BTSetBluetoothFeatureSupport::clearBSerialPortSupport() {
    if (hasBSerialPortSupport()) {
         clear_has_bSerialPortSupport();
        _bSerialPortSupport = false;
     }
}

inline bool T_BTSetBluetoothFeatureSupport::hasBSerialPortSupport () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline bool T_BTSetBluetoothFeatureSupport::getBSerialPortSupport () const {
    return _bSerialPortSupport;
}

inline void T_BTSetBluetoothFeatureSupport::setBSerialPortSupport (bool bSerialPortSupport_) {
    set_has_bSerialPortSupport();
    this->_bSerialPortSupport = bSerialPortSupport_;
}

inline void T_BTSetBluetoothFeatureSupport::set_has_bHandsFreeSupport () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_BTSetBluetoothFeatureSupport::clear_has_bHandsFreeSupport () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_BTSetBluetoothFeatureSupport::set_has_bPhoneBookSupport () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_BTSetBluetoothFeatureSupport::clear_has_bPhoneBookSupport () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_BTSetBluetoothFeatureSupport::set_has_bAudioStreamingSupport () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_BTSetBluetoothFeatureSupport::clear_has_bAudioStreamingSupport () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_BTSetBluetoothFeatureSupport::set_has_e8AudioStreamingSupportType () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_BTSetBluetoothFeatureSupport::clear_has_e8AudioStreamingSupportType () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_BTSetBluetoothFeatureSupport::set_has_bMessagingSupport () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_BTSetBluetoothFeatureSupport::clear_has_bMessagingSupport () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_BTSetBluetoothFeatureSupport::set_has_bInternetAccessSupport () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_BTSetBluetoothFeatureSupport::clear_has_bInternetAccessSupport () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_BTSetBluetoothFeatureSupport::set_has_e8InternetAccessSupportType () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_BTSetBluetoothFeatureSupport::clear_has_e8InternetAccessSupportType () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_BTSetBluetoothFeatureSupport::set_has_bPortableNavigationSupport () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_BTSetBluetoothFeatureSupport::clear_has_bPortableNavigationSupport () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_BTSetBluetoothFeatureSupport::set_has_bSerialPortSupport () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_BTSetBluetoothFeatureSupport::clear_has_bSerialPortSupport () {
    _has_bits_[0] &= ~ (1u << 8);
}

} // namespace most_BTSet_fi_types

#endif // MOST_BTSET_FI_TYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
