/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef MOST_BTSET_FIPROXY_H
#define MOST_BTSET_FIPROXY_H

#include "MOST_BTSet_FI.h"
#include "asf/cca/CcaProxy.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "fi_basetypes_most.h"
#include "most_BTSet_fi_typesConst.h"
#include "most_BTSet_fi_types_Extended.h"
#include "most_BTSet_fi_types_ExtendedConst.h"

namespace MOST_BTSet_FI {

class MOST_BTSet_FIProxy;

class AddNewDeviceCallbackIF {
public:
    virtual ~AddNewDeviceCallbackIF() {}

    virtual void onAddNewDeviceError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< AddNewDeviceError >& error) = 0;

    virtual void onAddNewDeviceResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< AddNewDeviceResult >& result) = 0;
};

class AddOobPairedDeviceCallbackIF {
public:
    virtual ~AddOobPairedDeviceCallbackIF() {}

    virtual void onAddOobPairedDeviceError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< AddOobPairedDeviceError >& error) = 0;

    virtual void onAddOobPairedDeviceResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< AddOobPairedDeviceResult >& result) = 0;
};

class AutoConnectOnOffCallbackIF {
public:
    virtual ~AutoConnectOnOffCallbackIF() {}

    virtual void onAutoConnectOnOffError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< AutoConnectOnOffError >& error) = 0;

    virtual void onAutoConnectOnOffStatus(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< AutoConnectOnOffStatus >& status) = 0;
};

class AutoConnectionStatusCallbackIF {
public:
    virtual ~AutoConnectionStatusCallbackIF() {}

    virtual void onAutoConnectionStatusError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< AutoConnectionStatusError >& error) = 0;

    virtual void onAutoConnectionStatusStatus(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< AutoConnectionStatusStatus >& status) = 0;
};

class BTProfilesUsageInfoCallbackIF {
public:
    virtual ~BTProfilesUsageInfoCallbackIF() {}

    virtual void onBTProfilesUsageInfoError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< BTProfilesUsageInfoError >& error) = 0;

    virtual void onBTProfilesUsageInfoStatus(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< BTProfilesUsageInfoStatus >& status) = 0;
};

class BluetoothAudioSourceCallbackIF {
public:
    virtual ~BluetoothAudioSourceCallbackIF() {}

    virtual void onBluetoothAudioSourceError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< BluetoothAudioSourceError >& error) = 0;

    virtual void onBluetoothAudioSourceStatus(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< BluetoothAudioSourceStatus >& status) = 0;
};

class BluetoothLimitationModeCallbackIF {
public:
    virtual ~BluetoothLimitationModeCallbackIF() {}

    virtual void onBluetoothLimitationModeError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< BluetoothLimitationModeError >& error) = 0;

    virtual void onBluetoothLimitationModeStatus(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< BluetoothLimitationModeStatus >& status) = 0;
};

class BluetoothOnOffCallbackIF {
public:
    virtual ~BluetoothOnOffCallbackIF() {}

    virtual void onBluetoothOnOffError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< BluetoothOnOffError >& error) = 0;

    virtual void onBluetoothOnOffStatus(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< BluetoothOnOffStatus >& status) = 0;
};

class ChangeDeviceStateCallbackIF {
public:
    virtual ~ChangeDeviceStateCallbackIF() {}

    virtual void onChangeDeviceStateError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< ChangeDeviceStateError >& error) = 0;

    virtual void onChangeDeviceStateResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< ChangeDeviceStateResult >& result) = 0;
};

class ChangePinCallbackIF {
public:
    virtual ~ChangePinCallbackIF() {}

    virtual void onChangePinError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< ChangePinError >& error) = 0;

    virtual void onChangePinResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< ChangePinResult >& result) = 0;
};

class ChangeRingtoneCallbackIF {
public:
    virtual ~ChangeRingtoneCallbackIF() {}

    virtual void onChangeRingtoneError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< ChangeRingtoneError >& error) = 0;

    virtual void onChangeRingtoneStatus(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< ChangeRingtoneStatus >& status) = 0;
};

class ChangeWifiTransmitPowerCallbackIF {
public:
    virtual ~ChangeWifiTransmitPowerCallbackIF() {}

    virtual void onChangeWifiTransmitPowerError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< ChangeWifiTransmitPowerError >& error) = 0;

    virtual void onChangeWifiTransmitPowerResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< ChangeWifiTransmitPowerResult >& result) = 0;
};

class ClearDeviceInfoCallbackIF {
public:
    virtual ~ClearDeviceInfoCallbackIF() {}

    virtual void onClearDeviceInfoError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< ClearDeviceInfoError >& error) = 0;

    virtual void onClearDeviceInfoResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< ClearDeviceInfoResult >& result) = 0;
};

class ClearFavoriteCallbackIF {
public:
    virtual ~ClearFavoriteCallbackIF() {}

    virtual void onClearFavoriteError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< ClearFavoriteError >& error) = 0;

    virtual void onClearFavoriteResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< ClearFavoriteResult >& result) = 0;
};

class ConflictsDetectedCallbackIF {
public:
    virtual ~ConflictsDetectedCallbackIF() {}

    virtual void onConflictsDetectedError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< ConflictsDetectedError >& error) = 0;

    virtual void onConflictsDetectedStatus(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< ConflictsDetectedStatus >& status) = 0;
};

class ConnectBluetoothProfileCallbackIF {
public:
    virtual ~ConnectBluetoothProfileCallbackIF() {}

    virtual void onConnectBluetoothProfileError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< ConnectBluetoothProfileError >& error) = 0;

    virtual void onConnectBluetoothProfileResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< ConnectBluetoothProfileResult >& result) = 0;
};

class ConnectSPPServiceCallbackIF {
public:
    virtual ~ConnectSPPServiceCallbackIF() {}

    virtual void onConnectSPPServiceError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< ConnectSPPServiceError >& error) = 0;

    virtual void onConnectSPPServiceResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< ConnectSPPServiceResult >& result) = 0;
};

class DeviceListExtendedCallbackIF {
public:
    virtual ~DeviceListExtendedCallbackIF() {}

    virtual void onDeviceListExtendedError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< DeviceListExtendedError >& error) = 0;

    virtual void onDeviceListExtendedStatus(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< DeviceListExtendedStatus >& status) = 0;
};

class DisconnectBluetoothProfileCallbackIF {
public:
    virtual ~DisconnectBluetoothProfileCallbackIF() {}

    virtual void onDisconnectBluetoothProfileError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< DisconnectBluetoothProfileError >& error) = 0;

    virtual void onDisconnectBluetoothProfileResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< DisconnectBluetoothProfileResult >& result) = 0;
};

class DisconnectSPPServiceCallbackIF {
public:
    virtual ~DisconnectSPPServiceCallbackIF() {}

    virtual void onDisconnectSPPServiceError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< DisconnectSPPServiceError >& error) = 0;

    virtual void onDisconnectSPPServiceResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< DisconnectSPPServiceResult >& result) = 0;
};

class GetDeviceInfoExtendedCallbackIF {
public:
    virtual ~GetDeviceInfoExtendedCallbackIF() {}

    virtual void onGetDeviceInfoExtendedError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< GetDeviceInfoExtendedError >& error) = 0;

    virtual void onGetDeviceInfoExtendedResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< GetDeviceInfoExtendedResult >& result) = 0;
};

class MaxDevicesPairedCallbackIF {
public:
    virtual ~MaxDevicesPairedCallbackIF() {}

    virtual void onMaxDevicesPairedError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< MaxDevicesPairedError >& error) = 0;

    virtual void onMaxDevicesPairedStatus(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< MaxDevicesPairedStatus >& status) = 0;
};

class MultiHFPSupportCallbackIF {
public:
    virtual ~MultiHFPSupportCallbackIF() {}

    virtual void onMultiHFPSupportError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< MultiHFPSupportError >& error) = 0;

    virtual void onMultiHFPSupportStatus(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< MultiHFPSupportStatus >& status) = 0;
};

class PairableModeCallbackIF {
public:
    virtual ~PairableModeCallbackIF() {}

    virtual void onPairableModeError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< PairableModeError >& error) = 0;

    virtual void onPairableModeStatus(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< PairableModeStatus >& status) = 0;
};

class PairingPinCallbackIF {
public:
    virtual ~PairingPinCallbackIF() {}

    virtual void onPairingPinError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< PairingPinError >& error) = 0;

    virtual void onPairingPinStatus(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< PairingPinStatus >& status) = 0;
};

class PairingRequestCallbackIF {
public:
    virtual ~PairingRequestCallbackIF() {}

    virtual void onPairingRequestError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< PairingRequestError >& error) = 0;

    virtual void onPairingRequestStatus(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< PairingRequestStatus >& status) = 0;
};

class PairingResponseCallbackIF {
public:
    virtual ~PairingResponseCallbackIF() {}

    virtual void onPairingResponseError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< PairingResponseError >& error) = 0;

    virtual void onPairingResponseResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< PairingResponseResult >& result) = 0;
};

class PairingStatusCallbackIF {
public:
    virtual ~PairingStatusCallbackIF() {}

    virtual void onPairingStatusError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< PairingStatusError >& error) = 0;

    virtual void onPairingStatusStatus(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< PairingStatusStatus >& status) = 0;
};

class PlayRingtoneCallbackIF {
public:
    virtual ~PlayRingtoneCallbackIF() {}

    virtual void onPlayRingtoneError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< PlayRingtoneError >& error) = 0;

    virtual void onPlayRingtoneResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< PlayRingtoneResult >& result) = 0;
};

class ReplaceBluetoothLimitationModeCallbackIF {
public:
    virtual ~ReplaceBluetoothLimitationModeCallbackIF() {}

    virtual void onReplaceBluetoothLimitationModeError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< ReplaceBluetoothLimitationModeError >& error) = 0;

    virtual void onReplaceBluetoothLimitationModeResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< ReplaceBluetoothLimitationModeResult >& result) = 0;
};

class ReplaceDeviceCallbackIF {
public:
    virtual ~ReplaceDeviceCallbackIF() {}

    virtual void onReplaceDeviceError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< ReplaceDeviceError >& error) = 0;

    virtual void onReplaceDeviceResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< ReplaceDeviceResult >& result) = 0;
};

class RequestAvailableRingtonesListCallbackIF {
public:
    virtual ~RequestAvailableRingtonesListCallbackIF() {}

    virtual void onRequestAvailableRingtonesListError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< RequestAvailableRingtonesListError >& error) = 0;

    virtual void onRequestAvailableRingtonesListResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< RequestAvailableRingtonesListResult >& result) = 0;
};

class RequestDeviceRingtoneListCallbackIF {
public:
    virtual ~RequestDeviceRingtoneListCallbackIF() {}

    virtual void onRequestDeviceRingtoneListError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< RequestDeviceRingtoneListError >& error) = 0;

    virtual void onRequestDeviceRingtoneListResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< RequestDeviceRingtoneListResult >& result) = 0;
};

class ResolveConflictsCallbackIF {
public:
    virtual ~ResolveConflictsCallbackIF() {}

    virtual void onResolveConflictsError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< ResolveConflictsError >& error) = 0;

    virtual void onResolveConflictsResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< ResolveConflictsResult >& result) = 0;
};

class SPPServiceConnectionCallbackIF {
public:
    virtual ~SPPServiceConnectionCallbackIF() {}

    virtual void onSPPServiceConnectionError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< SPPServiceConnectionError >& error) = 0;

    virtual void onSPPServiceConnectionStatus(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< SPPServiceConnectionStatus >& status) = 0;
};

class ScanBluetoothDevicesCallbackIF {
public:
    virtual ~ScanBluetoothDevicesCallbackIF() {}

    virtual void onScanBluetoothDevicesError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< ScanBluetoothDevicesError >& error) = 0;

    virtual void onScanBluetoothDevicesResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< ScanBluetoothDevicesResult >& result) = 0;
};

class SendPairingRequestCallbackIF {
public:
    virtual ~SendPairingRequestCallbackIF() {}

    virtual void onSendPairingRequestError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< SendPairingRequestError >& error) = 0;

    virtual void onSendPairingRequestResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< SendPairingRequestResult >& result) = 0;
};

class ServiceAvailableCallbackIF {
public:
    virtual ~ServiceAvailableCallbackIF() {}

    virtual void onServiceAvailableError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< ServiceAvailableError >& error) = 0;

    virtual void onServiceAvailableStatus(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< ServiceAvailableStatus >& status) = 0;
};

class SetBTProfilesUsageCallbackIF {
public:
    virtual ~SetBTProfilesUsageCallbackIF() {}

    virtual void onSetBTProfilesUsageError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< SetBTProfilesUsageError >& error) = 0;

    virtual void onSetBTProfilesUsageResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< SetBTProfilesUsageResult >& result) = 0;
};

class SetBluetoothLimitationModeCallbackIF {
public:
    virtual ~SetBluetoothLimitationModeCallbackIF() {}

    virtual void onSetBluetoothLimitationModeError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< SetBluetoothLimitationModeError >& error) = 0;

    virtual void onSetBluetoothLimitationModeResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< SetBluetoothLimitationModeResult >& result) = 0;
};

class SetDeviceUsagePreferenceCallbackIF {
public:
    virtual ~SetDeviceUsagePreferenceCallbackIF() {}

    virtual void onSetDeviceUsagePreferenceError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< SetDeviceUsagePreferenceError >& error) = 0;

    virtual void onSetDeviceUsagePreferenceResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< SetDeviceUsagePreferenceResult >& result) = 0;
};

class SetFavoriteCallbackIF {
public:
    virtual ~SetFavoriteCallbackIF() {}

    virtual void onSetFavoriteError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< SetFavoriteError >& error) = 0;

    virtual void onSetFavoriteResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< SetFavoriteResult >& result) = 0;
};

class SetPrimaryCallbackIF {
public:
    virtual ~SetPrimaryCallbackIF() {}

    virtual void onSetPrimaryError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< SetPrimaryError >& error) = 0;

    virtual void onSetPrimaryResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< SetPrimaryResult >& result) = 0;
};

class SetProfileUserAvailabilityCallbackIF {
public:
    virtual ~SetProfileUserAvailabilityCallbackIF() {}

    virtual void onSetProfileUserAvailabilityError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< SetProfileUserAvailabilityError >& error) = 0;

    virtual void onSetProfileUserAvailabilityResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< SetProfileUserAvailabilityResult >& result) = 0;
};

class SignalStrengthCallbackIF {
public:
    virtual ~SignalStrengthCallbackIF() {}

    virtual void onSignalStrengthError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< SignalStrengthError >& error) = 0;

    virtual void onSignalStrengthStatus(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< SignalStrengthStatus >& status) = 0;
};

class StartAutoConnectSequenceCallbackIF {
public:
    virtual ~StartAutoConnectSequenceCallbackIF() {}

    virtual void onStartAutoConnectSequenceError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< StartAutoConnectSequenceError >& error) = 0;

    virtual void onStartAutoConnectSequenceResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< StartAutoConnectSequenceResult >& result) = 0;
};

class StartSearchSPPServicesCallbackIF {
public:
    virtual ~StartSearchSPPServicesCallbackIF() {}

    virtual void onStartSearchSPPServicesError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< StartSearchSPPServicesError >& error) = 0;

    virtual void onStartSearchSPPServicesResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< StartSearchSPPServicesResult >& result) = 0;
};

class StopRingtoneCallbackIF {
public:
    virtual ~StopRingtoneCallbackIF() {}

    virtual void onStopRingtoneError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< StopRingtoneError >& error) = 0;

    virtual void onStopRingtoneResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< StopRingtoneResult >& result) = 0;
};

class StopSearchSPPServicesCallbackIF {
public:
    virtual ~StopSearchSPPServicesCallbackIF() {}

    virtual void onStopSearchSPPServicesError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< StopSearchSPPServicesError >& error) = 0;

    virtual void onStopSearchSPPServicesResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< StopSearchSPPServicesResult >& result) = 0;
};

class SwitchBTLocalModeCallbackIF {
public:
    virtual ~SwitchBTLocalModeCallbackIF() {}

    virtual void onSwitchBTLocalModeError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< SwitchBTLocalModeError >& error) = 0;

    virtual void onSwitchBTLocalModeResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< SwitchBTLocalModeResult >& result) = 0;
};

class SwitchBluetoothOnOffExtendedCallbackIF {
public:
    virtual ~SwitchBluetoothOnOffExtendedCallbackIF() {}

    virtual void onSwitchBluetoothOnOffExtendedError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< SwitchBluetoothOnOffExtendedError >& error) = 0;

    virtual void onSwitchBluetoothOnOffExtendedResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< SwitchBluetoothOnOffExtendedResult >& result) = 0;
};

class SwitchMultiHFPSupportCallbackIF {
public:
    virtual ~SwitchMultiHFPSupportCallbackIF() {}

    virtual void onSwitchMultiHFPSupportError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< SwitchMultiHFPSupportError >& error) = 0;

    virtual void onSwitchMultiHFPSupportResult(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< SwitchMultiHFPSupportResult >& result) = 0;
};

class VehicleBTAddressCallbackIF {
public:
    virtual ~VehicleBTAddressCallbackIF() {}

    virtual void onVehicleBTAddressError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< VehicleBTAddressError >& error) = 0;

    virtual void onVehicleBTAddressStatus(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< VehicleBTAddressStatus >& status) = 0;
};

class VehicleBTFriendlyNameCallbackIF {
public:
    virtual ~VehicleBTFriendlyNameCallbackIF() {}

    virtual void onVehicleBTFriendlyNameError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< VehicleBTFriendlyNameError >& error) = 0;

    virtual void onVehicleBTFriendlyNameStatus(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< VehicleBTFriendlyNameStatus >& status) = 0;
};

class VehicleBTFriendlyNamesetCallbackIF {
public:
    virtual ~VehicleBTFriendlyNamesetCallbackIF() {}

    virtual void onVehicleBTFriendlyNamesetError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< VehicleBTFriendlyNamesetError >& error) = 0;

    virtual void onVehicleBTFriendlyNamesetStatus(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< VehicleBTFriendlyNamesetStatus >& status) = 0;
};

class VehicleConfigurationCallbackIF {
public:
    virtual ~VehicleConfigurationCallbackIF() {}

    virtual void onVehicleConfigurationError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< VehicleConfigurationError >& error) = 0;

    virtual void onVehicleConfigurationStatus(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< VehicleConfigurationStatus >& status) = 0;
};

class VehicleSupportedBTProfilesCallbackIF {
public:
    virtual ~VehicleSupportedBTProfilesCallbackIF() {}

    virtual void onVehicleSupportedBTProfilesError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< VehicleSupportedBTProfilesError >& error) = 0;

    virtual void onVehicleSupportedBTProfilesStatus(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< VehicleSupportedBTProfilesStatus >& status) = 0;
};

class VisibleDevicesCallbackIF {
public:
    virtual ~VisibleDevicesCallbackIF() {}

    virtual void onVisibleDevicesError(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< VisibleDevicesError >& error) = 0;

    virtual void onVisibleDevicesStatus(const ::boost::shared_ptr< MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< VisibleDevicesStatus >& status) = 0;
};

class MOST_BTSet_FIProxyCallback;

/**
 * MOST_BTSet_FIProxy is the client side representation of the CCA
 * Functional Interface 'MOST_BTSet_FI' (specified in file
 * most_BTSet_fi.xml).
 *
 * CCA Functional Interface 'MOST_BTSet_FI'
 *
 * Fullname: Proprietary - BluetoothSettings
 *
 * Version: 5.7
 *
 * Author: Dominic Colella, General Motors
 *
 * Date: 2015-01-14
 *
 * Department:
 *
 * Title:
 *             MOST_BluetoothSettings_FI
 *
 * <b>Description of 'MOST_BTSet_FI':</b>
 *
 * <p>This FBlock was assembled from FBlockManifest file: BluetoothSettings.fblockman, Please consult individual interface files for interface-specific change history.</p>
 * The BluetoothSettings FBlock implements functions that allow HMI controllers to manage connected Bluetooth devices.  BluetoothSettings also acts as a control point for Audio Streaming devices that do not support the V1.4 or later AVRCP specification and that consequently cannot be meta-data indexed for integration within the MediaPlayer FBlock.  Such devices only support basic transport controls which is insufficient to integrate with the MediaPlayer's database-driven operation so these limited function devices are handled within BluetoothSettings instead.
 *
 * BluetoothSettings implements the IBluetoothSettings and ISource interfaces.  IBluetoothSettings is the main control interface used by HMI controllers.  The ISource interface is implemented to support the reduced-functionality Audio Streaming profile devices mentioned above.
 *
 * Please see GIS-327 Bluetooth Requirements Specification and GIS-379 Bluetooth Settings FBlock Specification for detailed feature/performance and dynamic/behavioral requirements.
 */
class MOST_BTSet_FIProxy : public ::asf::cca::CcaProxy
{
public:

    /**
     * Create a new instance of MOST_BTSet_FIProxy. The caller has to pass the
     * port name and the service information. It is only possible to use this
     * function if the port is defined in the CMC model as "wired at
     * runtime"-port. The application id of the CCA Server will be determined
     * with help of the CCA SrvSupplier messages. It's guranteed that the
     * corresponding CCA server will have the specified major version and at
     * least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< MOST_BTSet_FIProxy > createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of MOST_BTSet_FIProxy. The caller has to pass the
     * port name and the service information. It is only possible to use this
     * function if the port is defined in the CMC model as "wired at
     * runtime"-port. The proxy will connect to the CCA application specified
     * by appId. The CCA SrvSupplier messages will be used to determine the
     * availability of this application and the service. It's guranteed that
     * the corresponding CCA server will have the specified major version and
     * at least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< MOST_BTSet_FIProxy > createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of MOST_BTSet_FIProxy. The caller has to pass the
     * port name. The port name is defined in the "Car Multimedia Component"
     * model. With the help of the port name it is possible to address the
     * concrete proxy, which is defined in the CMC model description.
     */
    static ::boost::shared_ptr< MOST_BTSet_FIProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Destructor of MOST_BTSet_FIProxy. The destructor will send RelUpReg
     * messages for all property notifications and call the error callback of
     * all pending method invocations.
     */
    ~MOST_BTSet_FIProxy();

    // Method 'AddNewDevice'

    /**
     * Call the method 'AddNewDevice'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'AddNewDevice'</b>:
     *
     * Function initiates the pairing process from the vehicle. The PairingType
     * result leads to the correct pairing information being displayed by the HMI.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param bDummyFlag DummyFlag used to satisfy SequenceMethod requirement for a single parameter in the StartAck or StartResultAck.   This value shall always be set to False.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAddNewDeviceStart(AddNewDeviceCallbackIF& cb, bool bDummyFlag);

    // Method 'PairingResponse'

    /**
     * Call the method 'PairingResponse'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'PairingResponse'</b>:
     *
     * Identifies the user response to a pairing request (i.e. for Secure Simple Pairing Numeric Comparison) and when the pairing process has been cancelled or retried by the user.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param e8PairingResponseType Defines the possible pairing response types.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPairingResponseStart(PairingResponseCallbackIF& cb, ::most_BTSet_fi_types::T_e8_BTSetPairingResponseType e8PairingResponseType);

    // Method 'ChangePin'

    /**
     * Call the method 'ChangePin'. This method sends a MethodStart message to
     * the CCA server.
     *
     * <b>Documentation of 'ChangePin'</b>:
     *
     * Changes the current pin to one set by the user. Used in order to pair with devices that support Legacy pairing and have a fixed PIN and no interface for entering a PIN. Possible errors that may be encountered include: ERR_BS_INCORRECT_PIN_FORMAT
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param sPinNumber The PIN number to be used for the current pairing process.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendChangePinStart(ChangePinCallbackIF& cb, const ::fi_basetypes_most::T_String& sPinNumber);

    // Method 'ChangeDeviceState'

    /**
     * Call the method 'ChangeDeviceState'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'ChangeDeviceState'</b>:
     *
     * Identifies the action that the user has initiated that will change the
     * device list: Select, Disconnect, Delete, and Delete AllThe result
     * of this method will be the ConnectionResult(which identifies if the
     * requested device was connected or not) and the ReplaceDeviceRequired
     * result which indicates whether the HMI will need to provide the user with
     * a&#160;pop-up that will request the user to select which device to replace.If
     * the action is select, there are 3 options that could take place: change in
     * &#160;the outgoing source device, connect selected device, or a replace pop-up
     * that allows the user to select which device they want to replace (if this
     * &#160;is true, then the ReplaceDevice result of the ChangeDeviceState will be
     * &#160;true).If the action is disconnect, the device with the&#160;
     * DeviceHandle sent will be connected.If the action is delete, the
     * device with the DeviceHandle sent will be deleted. If the action is delete
     * all, all the devices shall be deleted and the DeviceHandle is not
     * &#160;required. talk about if action is select three options OSD, connect or
     * pop-up talk about all actions.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param e8ChangeDeviceStateAction Provides the action selected by the user to be executed on the device list.
     *
     * @param u8DeviceHandle Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendChangeDeviceStateStart(ChangeDeviceStateCallbackIF& cb, ::most_BTSet_fi_types::T_e8_BTSetChangeDeviceStateAction e8ChangeDeviceStateAction, uint8 u8DeviceHandle);

    // Method 'ReplaceDevice'

    /**
     * Call the method 'ReplaceDevice'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'ReplaceDevice'</b>:
     *
     * Replaces a currently connected device with another device based on user
     * selection. The currently connected device is disconnected and the selected
     * device is connected.The handle of the device to be connected and
     * disconnected are provided.The result is the ConnectionResult which
     * identifies if the requested device was connected or not.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8ConnectDeviceHandle The handle of the device to be connected.
     *
     * @param u8DisconnectDeviceHandle The handle of the device to be disconnected.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReplaceDeviceStart(ReplaceDeviceCallbackIF& cb, uint8 u8ConnectDeviceHandle, uint8 u8DisconnectDeviceHandle);

    // Method 'RequestDeviceRingtoneList'

    /**
     * Call the method 'RequestDeviceRingtoneList'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'RequestDeviceRingtoneList'</b>:
     *
     * Provides a list of each paired phone Bluetooth device with its currently selected ringtone.  The list is sorted in order of the most recently connected device first.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param bDummyFlag DummyFlag used to satisfy SequenceMethod requirement for a single parameter in the StartAck or StartResultAck.   This value shall always be set to False.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequestDeviceRingtoneListStart(RequestDeviceRingtoneListCallbackIF& cb, bool bDummyFlag);

    // Method 'RequestAvailableRingtonesList'

    /**
     * Call the method 'RequestAvailableRingtonesList'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'RequestAvailableRingtonesList'</b>:
     *
     * Provides the list of ringtones available for selection for the particular device.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8DeviceHandle Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequestAvailableRingtonesListStart(RequestAvailableRingtonesListCallbackIF& cb, uint8 u8DeviceHandle);

    // Method 'PlayRingtone'

    /**
     * Call the method 'PlayRingtone'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'PlayRingtone'</b>:
     *
     * When the method is called with u16RingtoneID set to any value between 0x02 - 0x0B, the identified
     * ringtone will play once, irrespective of the previously configured ringtone using the 'ChangeRingtone' interface.
     * If it is called with 0xFFFF or 0xFE, the configured ringtone is played continously.
     * In case the configured ringtone is not available or is set to 0x01 or 0xFF, default ringtone will be played continously.
     * MethodError would be reported if this method is called with any other RingtoneIDs.
     * Ringtone can be configured using the 'ChangeRingtone' interface.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u16RingtoneID The unique ID for each ringtone available.
     *
     * @param u8LogicalAVChannel Refer to IAVConnection for the enumeration of the Logical AV Channel parameter.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPlayRingtoneStart(PlayRingtoneCallbackIF& cb, uint16 u16RingtoneID, uint8 u8LogicalAVChannel);

    // Method 'ClearDeviceInfo'

    /**
     * Call the method 'ClearDeviceInfo'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'ClearDeviceInfo'</b>:
     *
     * This function is called to clear out all Bluetooth devices from the FBlock including all pairing
     * information, phone book information, if any, etc..Upon receipt of the StartAck optype,the BluetoothSettings
     * FBlock shall permanently delete all information associated with all devices from persistent memory.
     * This function is generally only used to clear out customer device / information when a vehicle is turned-in at
     * the end of lease or is sold.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendClearDeviceInfoStart(ClearDeviceInfoCallbackIF& cb);

    // Method 'GetDeviceInfoExtended'

    /**
     * Call the method 'GetDeviceInfoExtended'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'GetDeviceInfoExtended'</b>:
     *
     * Retrieves specific information about the device such as its Bluetooth address and supported features and profiles.  This function is defined as a Method instead of a Property because HMI controllers are expected to provide the device handle for a specific device when querying for this information.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8DeviceHandle Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetDeviceInfoExtendedStart(GetDeviceInfoExtendedCallbackIF& cb, uint8 u8DeviceHandle);

    // Method 'StopRingtone'

    /**
     * Call the method 'StopRingtone'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'StopRingtone'</b>:
     *
     * Stops the ringtone that is currently being played.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStopRingtoneStart(StopRingtoneCallbackIF& cb);

    // Method 'ScanBluetoothDevices'

    /**
     * Call the method 'ScanBluetoothDevices'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'ScanBluetoothDevices'</b>:
     *
     * Start or Stop Inquiry Scanning for Bluetooth Devices.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param bScan Start Inquiry Scan if bScan is 0x01. Stop Inquiry Scan if bScan is 0x00.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendScanBluetoothDevicesStart(ScanBluetoothDevicesCallbackIF& cb, bool bScan);

    // Method 'ConnectBluetoothProfile'

    /**
     * Call the method 'ConnectBluetoothProfile'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'ConnectBluetoothProfile'</b>:
     *
     * Provides profile based connection for the paired device.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8DeviceHandle Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @param oServiceType Provides a stream of parameters that identifies which are all the profiles needs to be connected for the paired device.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConnectBluetoothProfileStart(ConnectBluetoothProfileCallbackIF& cb, uint8 u8DeviceHandle, const ::most_BTSet_fi_types_Extended::T_BTServiceType& oServiceType);

    // Method 'DisconnectBluetoothProfile'

    /**
     * Call the method 'DisconnectBluetoothProfile'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'DisconnectBluetoothProfile'</b>:
     *
     * Provides profile based disconnection for the connected device.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8DeviceHandle Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @param oServiceType Provides a stream of parameters that identifies which are all the profiles needs to be disconnected for the connected device.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDisconnectBluetoothProfileStart(DisconnectBluetoothProfileCallbackIF& cb, uint8 u8DeviceHandle, const ::most_BTSet_fi_types_Extended::T_BTServiceType& oServiceType);

    // Method 'SendPairingRequest'

    /**
     * Call the method 'SendPairingRequest'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SendPairingRequest'</b>:
     *
     * Start or Cancel Pairing Request to a particular remote device
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param bPairingRequest Start Pairing to the remote device if bPairingRequest is 0x01. Cancel Pairing to the remote device if bPairingRequest is 0x00.
     *
     * @param sRemoteDeviceAddress Identifies the remote bluetooth device address to which Start/Cancel pairing is to be issued. It is represented as 12 hexidecimal characters.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSendPairingRequestStart(SendPairingRequestCallbackIF& cb, bool bPairingRequest, const ::fi_basetypes_most::T_String& sRemoteDeviceAddress);

    // Method 'SwitchBTLocalMode'

    /**
     * Call the method 'SwitchBTLocalMode'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SwitchBTLocalMode'</b>:
     *
     * This is a method to change property BtLocalMode. Each mode (pairable, connectable, discoverable) can be switched ON or OFF separately.
     * If no change should be done for a mode that parameter should be set to AUTO.
     * It is not sufficient to look at the response to this method, check the PairableMode property.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param Pairable This is used to enable or disable the Pairable request. Inputs may be On/Off/Auto
     *
     * @param Connectable This is used to enable or disable the Connatable request.Inputs may be On/Off/Auto
     *
     * @param sBTAddress Device address of the requested device
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSwitchBTLocalModeStart(SwitchBTLocalModeCallbackIF& cb, ::most_BTSet_fi_types_Extended::T_BTLocalModeType pairable, ::most_BTSet_fi_types_Extended::T_BTLocalModeType connectable, const ::fi_basetypes_most::T_String& sBTAddress);

    // Method 'StartAutoConnectSequence'

    /**
     * Call the method 'StartAutoConnectSequence'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'StartAutoConnectSequence'</b>:
     *
     * This is a method to start/stop AutoConnect strategy based on user request.
     * If any device is currently connected , it shall be disconnected and AutoConnect strategy shall be started.
     * Device Connection is notified via the DeviceList/DeviceListExtended property.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param bStartAutoConnect This is used to start/stop AutoConnect strategy. This Parameter may take values On/Off
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStartAutoConnectSequenceStart(StartAutoConnectSequenceCallbackIF& cb, bool bStartAutoConnect);

    // Method 'ConnectSPPService'

    /**
     * Call the method 'ConnectSPPService'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'ConnectSPPService'</b>:
     *
     * This is a method to get a RFComm for a device when requested.For this to happen, the device for which the RFComm is requested should be in connected state and
     * should have a valid device handle.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8DeviceHandle Unique handle for each one of the device, up to 10 devices that can be paired.
     *
     * @param szUUID The UUID for the Device handle, for which the RFCommID is been requested.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConnectSPPServiceStart(ConnectSPPServiceCallbackIF& cb, uint8 u8DeviceHandle, const ::fi_basetypes_most::T_String& szUUID);

    // Method 'SetBluetoothLimitationMode'

    /**
     * Call the method 'SetBluetoothLimitationMode'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'SetBluetoothLimitationMode'</b>:
     *
     * This method shall be used to change a limitation/restriction setting w.r.t. Bluetooth behaviour.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param sBdAddress Bluetooth device address. In special cases (address not known) this parameter can be an empty string.
     *
     * @param sBdDeviceName Bluetooth device name is an optional parameter and should be used when BT address is not available.
     * In cases (name not known, BT address is available) this parameter should be an empty string.
     *
     * @param e8Technology Technology that specifies the limitation/restriction.
     *
     * @param e8CommunicationChannel Communication channel that is used by the technology.
     *
     * @param e8Action Requested limitation action.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetBluetoothLimitationModeStart(SetBluetoothLimitationModeCallbackIF& cb, const ::fi_basetypes_most::T_String& sBdAddress, const ::fi_basetypes_most::T_String& sBdDeviceName, ::most_BTSet_fi_types_Extended::T_e8_BTTechnology e8Technology, ::most_BTSet_fi_types_Extended::T_e8_BTCommunicationChannel e8CommunicationChannel, ::most_BTSet_fi_types_Extended::T_e8_BTLimitationAction e8Action);

    // Method 'SwitchBluetoothOnOffExtended'

    /**
     * Call the method 'SwitchBluetoothOnOffExtended'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'SwitchBluetoothOnOffExtended'</b>:
     *
     * This function is Extended method of SwitchBluetoothOnOff which has an additional parameter bSuppressAutoConnection
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param bBTOnOff Switch Bluetooth ON or Switch Bluetooth OFF .
     *
     * @param bSuppressAutoConnection Enable or Disable Autoconnection of the Paired device after BT ON.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSwitchBluetoothOnOffExtendedStart(SwitchBluetoothOnOffExtendedCallbackIF& cb, bool bBTOnOff, bool bSuppressAutoConnection);

    // Method 'ChangeWifiTransmitPower'

    /**
     * Call the method 'ChangeWifiTransmitPower'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'ChangeWifiTransmitPower'</b>:
     *
     * This method is used to change the transmission power of Wi-Fi chip. It is possible to attenuate the Wi-Fi RF power.
     * The range depends on modulation and Wi-Fi chip calibration settings. Rough rule of thumb for maximum range would be 10dB range with 11b modulation.
     * Other modulations have smaller ranges. If the requested operation on power adjustment is success then method result will report SUCCESS, otherwise ERROR.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8WiFiPowerAttenuation This is used for attenuate the Wi-Fi RF power.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendChangeWifiTransmitPowerStart(ChangeWifiTransmitPowerCallbackIF& cb, uint8 u8WiFiPowerAttenuation);

    // Method 'DisconnectSPPService'

    /**
     * Call the method 'DisconnectSPPService'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'DisconnectSPPService'</b>:
     *
     * This is a method to disconnect a SPP connection of a device when requested.For this to happen, the device for which the Disconnection is requested should have a valid SPP connection and RFCommID.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8DeviceHandle Unique handle for each one of the device, up to 10 devices that can be paired.
     *
     * @param szUUID The UUID for the Device handle, for which disconnection is been requested.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDisconnectSPPServiceStart(DisconnectSPPServiceCallbackIF& cb, uint8 u8DeviceHandle, const ::fi_basetypes_most::T_String& szUUID);

    // Method 'StartSearchSPPServices'

    /**
     * Call the method 'StartSearchSPPServices'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'StartSearchSPPServices'</b>:
     *
     * This API is used to retrieve the services on the specified device. This method can be used to get the SPP capabilities. As a result of this SPPServiceConnectionStatus Property will be updated only if there are changes in the property.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8DeviceHandle Unique handle for each one of the device, up to 10 devices that can be paired.
     *
     * @param bPeriodicSearch Based on this value, service search will be carried out in a periodic manner.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStartSearchSPPServicesStart(StartSearchSPPServicesCallbackIF& cb, uint8 u8DeviceHandle, bool bPeriodicSearch);

    // Method 'StopSearchSPPServices'

    /**
     * Call the method 'StopSearchSPPServices'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'StopSearchSPPServices'</b>:
     *
     * This API is used to stop the service search for the specific device with valid SearchHandle.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8DeviceHandle Unique handle for each one of the device, up to 10 devices that can be paired.
     *
     * @param u8SearchHandle Unique SearchHandle from StartSearchSPPServices is used to Stop the periodic service search.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStopSearchSPPServicesStart(StopSearchSPPServicesCallbackIF& cb, uint8 u8DeviceHandle, uint8 u8SearchHandle);

    // Method 'AddOobPairedDevice'

    /**
     * Call the method 'AddOobPairedDevice'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'AddOobPairedDevice'</b>:
     *
     * This API is used to support out-of-band (OOB) pairing.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param sBdAddress Bluetooth device address
     *
     * @param sBdName Bluetooth device name
     *
     * @param sLinkKey LinkKey
     *
     * @param e8OobType Protocol support for the given remote device
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAddOobPairedDeviceStart(AddOobPairedDeviceCallbackIF& cb, const ::fi_basetypes_most::T_String& sBdAddress, const ::fi_basetypes_most::T_String& sBdName, const ::fi_basetypes_most::T_String& sLinkKey, ::most_BTSet_fi_types_Extended::T_e8_BTOobType e8OobType);

    // Method 'SetFavorite'

    /**
     * Call the method 'SetFavorite'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'SetFavorite'</b>:
     *
     * This API is used to set favorite index to each device or to the profiles(HFP and AVP) supported by a device. The favorite index is an unambiguous positive integer representing the favorite's ranking
     * (favorite index - 0 means no favorite, favorite index == 1 represents the most favorite, etc.,). If a user wants to set favorite index for a device or profile which is as same as that of an another device or profile,
     * the favorite index for the previous device or profile will be cleared and the favorite index will be set for the requested device or profile. And also if a user wants to clear an already set favorite device or profile
     * then call set favorite method for corresponding device or profile with favorite index(zero) so that favorite value for the requested device is cleared as like clearFavorite method.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8DeviceHandle Unique handle for each one of the device
     *
     * @param e8FavoriteType Specifies the type of favorite
     *
     * @param u8FavoriteIndex Unambiguous positive integer representing the favorite's ranking
     * (favorite index - 1 represents the device/protocol is set as most favorite, etc.,)
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetFavoriteStart(SetFavoriteCallbackIF& cb, uint8 u8DeviceHandle, ::most_BTSet_fi_types_Extended::T_e8_BTFavoriteType e8FavoriteType, uint8 u8FavoriteIndex);

    // Method 'ClearFavorite'

    /**
     * Call the method 'ClearFavorite'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'ClearFavorite'</b>:
     *
     * To clear an already set favorite device or profile then user has to call this API for corresponding device or profile so that favorite index for the requested device is cleared.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8DeviceHandle Unique handle for each one of the device
     *
     * @param e8FavoriteType Specifies the type of favorite
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendClearFavoriteStart(ClearFavoriteCallbackIF& cb, uint8 u8DeviceHandle, ::most_BTSet_fi_types_Extended::T_e8_BTFavoriteType e8FavoriteType);

    // Method 'SwitchMultiHFPSupport'

    /**
     * Call the method 'SwitchMultiHFPSupport'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'SwitchMultiHFPSupport'</b>:
     *
     * This API is used to allow Switch On or Off Multiple HFP Support. Switching status will be updated in the property - MultiHFPSupport.
     * The default value of MultiHFPSupport should be switched On or Off in the initial start up can be configured project specific. For subsequent startups
     * the value will be stored persistently. If switchMultiHFPSupport(OFF) is called then during switching off more than one HFP profile is connected
     * then the secondary/slave HFP profile(s) will be disconnected internally or In case that HMI has to implement project-specific priority order then
     * HMI has to called disconnect the specific HFP profile(s) before the "SwitchMultiHFPSupport(OFF)" is being called.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param bMultiHFPSupport Switch MultiHFPSupport ON or OFF.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSwitchMultiHFPSupportStart(SwitchMultiHFPSupportCallbackIF& cb, bool bMultiHFPSupport);

    // Method 'SetPrimary'

    /**
     * Call the method 'SetPrimary'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'SetPrimary'</b>:
     *
     * This API is used to set the device as Primary. If a user wants to set the primary for a device which is as same as
     * that of an another device, the primary status for the previous device will be cleared and the primary will be set for the requested device.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8DeviceHandle Unique handle for each one of the device
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetPrimaryStart(SetPrimaryCallbackIF& cb, uint8 u8DeviceHandle);

    // Method 'SetBTProfilesUsage'

    /**
     * Call the method 'SetBTProfilesUsage'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SetBTProfilesUsage'</b>:
     *
     * This API is used by the clients to update usage of different BT profiles when used for specific or generic purpose.
     * Client can update multiple BT profiles usage for multiple BT devices using this interface.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param oBTProfilesUsageInfoList List of profile usage
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetBTProfilesUsageStart(SetBTProfilesUsageCallbackIF& cb, const ::most_BTSet_fi_types_Extended::T_BTProfilesUsageList& oBTProfilesUsageInfoList);

    // Method 'ResolveConflicts'

    /**
     * Call the method 'ResolveConflicts'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'ResolveConflicts'</b>:
     *
     * This API is used by the clients to resolve the conflicts. Resolution can be based on user decision or default project configuration.
     * Client has to respond with this interface whenever conflicts are updated via ConflictsDetected () property. When client responds with
     * ResolutionType RESOLUTION_TYPE_PROCEED, server will resolve the conflicts (if not yet resolved) with default action. Therefore clients should resolve the
     * conflicts before responding with ResolutionType RESOLUTION_TYPE_PROCEED. And also If client does not respond within specified timeout period (project
     * configuration) then server will resolve the conflicts (if not yet resolved) with default action.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param e8ConflictTrigger Trigger for the conflicts
     *
     * @param e8ResolutionType Resolution Type
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendResolveConflictsStart(ResolveConflictsCallbackIF& cb, ::most_BTSet_fi_types_Extended::T_e8_BTConflictTrigger e8ConflictTrigger, ::most_BTSet_fi_types_Extended::T_e8_BTResolutionType e8ResolutionType);

    // Method 'SetDeviceUsagePreference'

    /**
     * Call the method 'SetDeviceUsagePreference'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'SetDeviceUsagePreference'</b>:
     *
     * This API is used by the clients to set the usage preference for the device. Usage preference will be updated in the property - DeviceListExtended.
     * During autoconnection, the Connection will be trigged for the device based on the usage preference.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8DeviceHandle Unique handle for each one of the device
     *
     * @param e8DeviceUsagePreference Provides the device usage preference
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetDeviceUsagePreferenceStart(SetDeviceUsagePreferenceCallbackIF& cb, uint8 u8DeviceHandle, ::most_BTSet_fi_types_Extended::T_e8_BTSetUsagePreference e8DeviceUsagePreference);

    // Method 'SetProfileUserAvailability'

    /**
     * Call the method 'SetProfileUserAvailability'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'SetProfileUserAvailability'</b>:
     *
     * This API is used by the clients to set the user availability for the profile.
     * During autoconnection, the Connection will be trigged once the user available for the profiles(HFP/AVP).
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param e8Profile Profile that specifies the user availablity
     *
     * @param e8UserAvailable Provides the user availablity.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetProfileUserAvailabilityStart(SetProfileUserAvailabilityCallbackIF& cb, ::most_BTSet_fi_types_Extended::T_e8_BTProfile e8Profile, ::most_BTSet_fi_types_Extended::T_e8_BTUserAvailable e8UserAvailable);

    // Method 'ReplaceBluetoothLimitationMode'

    /**
     * Call the method 'ReplaceBluetoothLimitationMode'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'ReplaceBluetoothLimitationMode'</b>:
     *
     * This method shall be used to replace any current limitation/restriction setting w.r.t. Bluetooth behaviour
     * with a new limitation/restriction. This will end the current limitation/restriction which is already applied.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param oLimitationModeToBeReplaced Current limitation/restriction which has to be replaced
     *
     * @param oNewLimitationMode New Limitation mode which will replace oLimitationModeToBeReplaced
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReplaceBluetoothLimitationModeStart(ReplaceBluetoothLimitationModeCallbackIF& cb, const ::most_BTSet_fi_types_Extended::T_BTLimitationModeListItem& oLimitationModeToBeReplaced, const ::most_BTSet_fi_types_Extended::T_BTLimitationMode& oNewLimitationMode);

    // Property 'BluetoothOnOff'

    /**
     * Notify on the property 'BluetoothOnOff'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'BluetoothOnOff'</b>:
     *
     * Activate/De-activate Bluetooth
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBluetoothOnOffUpReg(BluetoothOnOffCallbackIF& cb);

    /**
     * Remove the notifcation on property 'BluetoothOnOff'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'BluetoothOnOff'</b>:
     *
     * Activate/De-activate Bluetooth
     *
     * @param act The act which was previously returned by the
     * sendBluetoothOnOffUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendBluetoothOnOffRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'BluetoothOnOff'.
     */
    void sendBluetoothOnOffRelUpRegAll ();

    /**
     * Returns the current value of the property 'BluetoothOnOff' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasBluetoothOnOff() returns true.
     *
     * @return the previously received value of the property 'BluetoothOnOff'.
     */
    const BluetoothOnOffStatus& getBluetoothOnOff() const;

    /**
     * Determines whether a status message for the property 'BluetoothOnOff' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasBluetoothOnOff() const;

    /**
     * Request the value of the property 'BluetoothOnOff' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'BluetoothOnOff'</b>:
     *
     * Activate/De-activate Bluetooth
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBluetoothOnOffGet(BluetoothOnOffCallbackIF& cb);

    /**
     * Set the value of the property 'BluetoothOnOff'. This method sends a Set
     * message to the CCA server.
     *
     * <b>Documentation of 'BluetoothOnOff'</b>:
     *
     * Activate/De-activate Bluetooth
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param bBTOnOff Bluetooth ON or OFF
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBluetoothOnOffSet(BluetoothOnOffCallbackIF& cb, bool bBTOnOff);

    // Property 'PairingStatus'

    /**
     * Notify on the property 'PairingStatus'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'PairingStatus'</b>:
     *
     * Identifies when the pairing process was completed successfully or informs the HMI when the pairing process was unsuccessful and for what reason. In addition, if notifies the HMI when the pairing process was canceled. If the pairing process was retried the pairing status provides notification of what type of retry was completed.  DeviceName only returned if PAIRING_STATUS_SUCCESSFUL
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPairingStatusUpReg(PairingStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'PairingStatus'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'PairingStatus'</b>:
     *
     * Identifies when the pairing process was completed successfully or informs the HMI when the pairing process was unsuccessful and for what reason. In addition, if notifies the HMI when the pairing process was canceled. If the pairing process was retried the pairing status provides notification of what type of retry was completed.  DeviceName only returned if PAIRING_STATUS_SUCCESSFUL
     *
     * @param act The act which was previously returned by the
     * sendPairingStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendPairingStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'PairingStatus'.
     */
    void sendPairingStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'PairingStatus' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasPairingStatus() returns true.
     *
     * @return the previously received value of the property 'PairingStatus'.
     */
    const PairingStatusStatus& getPairingStatus() const;

    /**
     * Determines whether a status message for the property 'PairingStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasPairingStatus() const;

    /**
     * Request the value of the property 'PairingStatus' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'PairingStatus'</b>:
     *
     * Identifies when the pairing process was completed successfully or informs the HMI when the pairing process was unsuccessful and for what reason. In addition, if notifies the HMI when the pairing process was canceled. If the pairing process was retried the pairing status provides notification of what type of retry was completed.  DeviceName only returned if PAIRING_STATUS_SUCCESSFUL
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPairingStatusGet(PairingStatusCallbackIF& cb);

    // Property 'ChangeRingtone'

    /**
     * Notify on the property 'ChangeRingtone'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'ChangeRingtone'</b>:
     *
     * Changes the active ringtone for the respective device to the selected ringtone.  This function is defined as a settable Property instead of a Method so that all HMI controllers can receive notifications that a ringtone for a device has been changed.  Note that the Get operation is not defined because the Status can only be generated in response to the Set optype on a particular device.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendChangeRingtoneUpReg(ChangeRingtoneCallbackIF& cb);

    /**
     * Remove the notifcation on property 'ChangeRingtone'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'ChangeRingtone'</b>:
     *
     * Changes the active ringtone for the respective device to the selected ringtone.  This function is defined as a settable Property instead of a Method so that all HMI controllers can receive notifications that a ringtone for a device has been changed.  Note that the Get operation is not defined because the Status can only be generated in response to the Set optype on a particular device.
     *
     * @param act The act which was previously returned by the
     * sendChangeRingtoneUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendChangeRingtoneRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'ChangeRingtone'.
     */
    void sendChangeRingtoneRelUpRegAll ();

    /**
     * Returns the current value of the property 'ChangeRingtone' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasChangeRingtone() returns true.
     *
     * @return the previously received value of the property 'ChangeRingtone'.
     */
    const ChangeRingtoneStatus& getChangeRingtone() const;

    /**
     * Determines whether a status message for the property 'ChangeRingtone' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasChangeRingtone() const;

    /**
     * Set the value of the property 'ChangeRingtone'. This method sends a
     * PureSet message to the CCA server.
     *
     * <b>Documentation of 'ChangeRingtone'</b>:
     *
     * Changes the active ringtone for the respective device to the selected ringtone.  This function is defined as a settable Property instead of a Method so that all HMI controllers can receive notifications that a ringtone for a device has been changed.  Note that the Get operation is not defined because the Status can only be generated in response to the Set optype on a particular device.
     *
     * @param u8DeviceHandle Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @param u16RingtoneID The unique ID for each ringtone available.
     */

    void sendChangeRingtonePureSet(uint8 u8DeviceHandle, uint16 u16RingtoneID);

    // Property 'VehicleBTFriendlyName'

    /**
     * Notify on the property 'VehicleBTFriendlyName'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'VehicleBTFriendlyName'</b>:
     *
     * This is the VehicleBTFriendlyName.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVehicleBTFriendlyNameUpReg(VehicleBTFriendlyNameCallbackIF& cb);

    /**
     * Remove the notifcation on property 'VehicleBTFriendlyName'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'VehicleBTFriendlyName'</b>:
     *
     * This is the VehicleBTFriendlyName.
     *
     * @param act The act which was previously returned by the
     * sendVehicleBTFriendlyNameUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendVehicleBTFriendlyNameRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'VehicleBTFriendlyName'.
     */
    void sendVehicleBTFriendlyNameRelUpRegAll ();

    /**
     * Returns the current value of the property 'VehicleBTFriendlyName' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasVehicleBTFriendlyName() returns true.
     *
     * @return the previously received value of the property 'VehicleBTFriendlyName'.
     */
    const VehicleBTFriendlyNameStatus& getVehicleBTFriendlyName() const;

    /**
     * Determines whether a status message for the property 'VehicleBTFriendlyName' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasVehicleBTFriendlyName() const;

    /**
     * Request the value of the property 'VehicleBTFriendlyName' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'VehicleBTFriendlyName'</b>:
     *
     * This is the VehicleBTFriendlyName.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVehicleBTFriendlyNameGet(VehicleBTFriendlyNameCallbackIF& cb);

    // Property 'BluetoothAudioSource'

    /**
     * Notify on the property 'BluetoothAudioSource'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'BluetoothAudioSource'</b>:
     *
     * Identifies the Bluetooth source device and provides the HMI with the supported transport control and features of the device such that the appropriate screen can be displayed.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBluetoothAudioSourceUpReg(BluetoothAudioSourceCallbackIF& cb);

    /**
     * Remove the notifcation on property 'BluetoothAudioSource'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'BluetoothAudioSource'</b>:
     *
     * Identifies the Bluetooth source device and provides the HMI with the supported transport control and features of the device such that the appropriate screen can be displayed.
     *
     * @param act The act which was previously returned by the
     * sendBluetoothAudioSourceUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendBluetoothAudioSourceRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'BluetoothAudioSource'.
     */
    void sendBluetoothAudioSourceRelUpRegAll ();

    /**
     * Returns the current value of the property 'BluetoothAudioSource' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasBluetoothAudioSource() returns true.
     *
     * @return the previously received value of the property 'BluetoothAudioSource'.
     */
    const BluetoothAudioSourceStatus& getBluetoothAudioSource() const;

    /**
     * Determines whether a status message for the property 'BluetoothAudioSource' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasBluetoothAudioSource() const;

    /**
     * Request the value of the property 'BluetoothAudioSource' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'BluetoothAudioSource'</b>:
     *
     * Identifies the Bluetooth source device and provides the HMI with the supported transport control and features of the device such that the appropriate screen can be displayed.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBluetoothAudioSourceGet(BluetoothAudioSourceCallbackIF& cb);

    /**
     * Set the value of the property 'BluetoothAudioSource'. This method sends
     * a PureSet message to the CCA server.
     *
     * <b>Documentation of 'BluetoothAudioSource'</b>:
     *
     * Identifies the Bluetooth source device and provides the HMI with the supported transport control and features of the device such that the appropriate screen can be displayed.
     *
     * @param u8DeviceHandle Unique handle for each one of the up to 10 devices that can be paired.
     */

    void sendBluetoothAudioSourcePureSet(uint8 u8DeviceHandle);

    // Property 'PairingPin'

    /**
     * Notify on the property 'PairingPin'. This method sends a UpReg message
     * to the CCA server.
     *
     * <b>Documentation of 'PairingPin'</b>:
     *
     * Used to acquire the pairing PIN for the current pairing process.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPairingPinUpReg(PairingPinCallbackIF& cb);

    /**
     * Remove the notifcation on property 'PairingPin'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'PairingPin'</b>:
     *
     * Used to acquire the pairing PIN for the current pairing process.
     *
     * @param act The act which was previously returned by the
     * sendPairingPinUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendPairingPinRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'PairingPin'.
     */
    void sendPairingPinRelUpRegAll ();

    /**
     * Returns the current value of the property 'PairingPin' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when
     * hasPairingPin() returns true.
     *
     * @return the previously received value of the property 'PairingPin'.
     */
    const PairingPinStatus& getPairingPin() const;

    /**
     * Determines whether a status message for the property 'PairingPin' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasPairingPin() const;

    /**
     * Request the value of the property 'PairingPin' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'PairingPin'</b>:
     *
     * Used to acquire the pairing PIN for the current pairing process.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPairingPinGet(PairingPinCallbackIF& cb);

    // Property 'MaxDevicesPaired'

    /**
     * Notify on the property 'MaxDevicesPaired'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'MaxDevicesPaired'</b>:
     *
     * Notification that informs the HMI controller that the maximum number of
     * Bluetooth devices (10) have been paired. It provides the DeviceHandle and
     * DeviceName of the device which has not been connected for the longest time
     * (i.e. least recent DateTimeStamp).Notification shall be sent when
     * the 10th Bluetooth device is paired or when the device which has not been
     * connected for the longest time changes.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMaxDevicesPairedUpReg(MaxDevicesPairedCallbackIF& cb);

    /**
     * Remove the notifcation on property 'MaxDevicesPaired'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'MaxDevicesPaired'</b>:
     *
     * Notification that informs the HMI controller that the maximum number of
     * Bluetooth devices (10) have been paired. It provides the DeviceHandle and
     * DeviceName of the device which has not been connected for the longest time
     * (i.e. least recent DateTimeStamp).Notification shall be sent when
     * the 10th Bluetooth device is paired or when the device which has not been
     * connected for the longest time changes.
     *
     * @param act The act which was previously returned by the
     * sendMaxDevicesPairedUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendMaxDevicesPairedRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'MaxDevicesPaired'.
     */
    void sendMaxDevicesPairedRelUpRegAll ();

    /**
     * Returns the current value of the property 'MaxDevicesPaired' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasMaxDevicesPaired() returns true.
     *
     * @return the previously received value of the property 'MaxDevicesPaired'.
     */
    const MaxDevicesPairedStatus& getMaxDevicesPaired() const;

    /**
     * Determines whether a status message for the property 'MaxDevicesPaired' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasMaxDevicesPaired() const;

    /**
     * Request the value of the property 'MaxDevicesPaired' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'MaxDevicesPaired'</b>:
     *
     * Notification that informs the HMI controller that the maximum number of
     * Bluetooth devices (10) have been paired. It provides the DeviceHandle and
     * DeviceName of the device which has not been connected for the longest time
     * (i.e. least recent DateTimeStamp).Notification shall be sent when
     * the 10th Bluetooth device is paired or when the device which has not been
     * connected for the longest time changes.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMaxDevicesPairedGet(MaxDevicesPairedCallbackIF& cb);

    // Property 'AutoConnectOnOff'

    /**
     * Notify on the property 'AutoConnectOnOff'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'AutoConnectOnOff'</b>:
     *
     * Activate/De-activate AutoConnectOff
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAutoConnectOnOffUpReg(AutoConnectOnOffCallbackIF& cb);

    /**
     * Remove the notifcation on property 'AutoConnectOnOff'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'AutoConnectOnOff'</b>:
     *
     * Activate/De-activate AutoConnectOff
     *
     * @param act The act which was previously returned by the
     * sendAutoConnectOnOffUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendAutoConnectOnOffRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'AutoConnectOnOff'.
     */
    void sendAutoConnectOnOffRelUpRegAll ();

    /**
     * Returns the current value of the property 'AutoConnectOnOff' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasAutoConnectOnOff() returns true.
     *
     * @return the previously received value of the property 'AutoConnectOnOff'.
     */
    const AutoConnectOnOffStatus& getAutoConnectOnOff() const;

    /**
     * Determines whether a status message for the property 'AutoConnectOnOff' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAutoConnectOnOff() const;

    /**
     * Request the value of the property 'AutoConnectOnOff' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'AutoConnectOnOff'</b>:
     *
     * Activate/De-activate AutoConnectOff
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     * @param bAutoConnectOnOff Get AutoconnectOnOff
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAutoConnectOnOffGet(AutoConnectOnOffCallbackIF& cb, bool bAutoConnectOnOff);

    /**
     * Set the value of the property 'AutoConnectOnOff'. This method sends a
     * Set message to the CCA server.
     *
     * <b>Documentation of 'AutoConnectOnOff'</b>:
     *
     * Activate/De-activate AutoConnectOff
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param bAutoConnectOnOff Set AutoconnectOnOff
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAutoConnectOnOffSet(AutoConnectOnOffCallbackIF& cb, bool bAutoConnectOnOff);

    // Property 'VehicleBTAddress'

    /**
     * Notify on the property 'VehicleBTAddress'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'VehicleBTAddress'</b>:
     *
     * Vehicle BT Address
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVehicleBTAddressUpReg(VehicleBTAddressCallbackIF& cb);

    /**
     * Remove the notifcation on property 'VehicleBTAddress'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'VehicleBTAddress'</b>:
     *
     * Vehicle BT Address
     *
     * @param act The act which was previously returned by the
     * sendVehicleBTAddressUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendVehicleBTAddressRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'VehicleBTAddress'.
     */
    void sendVehicleBTAddressRelUpRegAll ();

    /**
     * Returns the current value of the property 'VehicleBTAddress' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasVehicleBTAddress() returns true.
     *
     * @return the previously received value of the property 'VehicleBTAddress'.
     */
    const VehicleBTAddressStatus& getVehicleBTAddress() const;

    /**
     * Determines whether a status message for the property 'VehicleBTAddress' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasVehicleBTAddress() const;

    /**
     * Request the value of the property 'VehicleBTAddress' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'VehicleBTAddress'</b>:
     *
     * Vehicle BT Address
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVehicleBTAddressGet(VehicleBTAddressCallbackIF& cb);

    // Property 'VehicleSupportedBTProfiles'

    /**
     * Notify on the property 'VehicleSupportedBTProfiles'. This method sends
     * a UpReg message to the CCA server.
     *
     * <b>Documentation of 'VehicleSupportedBTProfiles'</b>:
     *
     * Vehicle Supported BT Profiles
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVehicleSupportedBTProfilesUpReg(VehicleSupportedBTProfilesCallbackIF& cb);

    /**
     * Remove the notifcation on property 'VehicleSupportedBTProfiles'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'VehicleSupportedBTProfiles'</b>:
     *
     * Vehicle Supported BT Profiles
     *
     * @param act The act which was previously returned by the
     * sendVehicleSupportedBTProfilesUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendVehicleSupportedBTProfilesRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'VehicleSupportedBTProfiles'.
     */
    void sendVehicleSupportedBTProfilesRelUpRegAll ();

    /**
     * Returns the current value of the property 'VehicleSupportedBTProfiles'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasVehicleSupportedBTProfiles() returns true.
     *
     * @return the previously received value of the property 'VehicleSupportedBTProfiles'.
     */
    const VehicleSupportedBTProfilesStatus& getVehicleSupportedBTProfiles() const;

    /**
     * Determines whether a status message for the property 'VehicleSupportedBTProfiles' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasVehicleSupportedBTProfiles() const;

    /**
     * Request the value of the property 'VehicleSupportedBTProfiles' from the
     * CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'VehicleSupportedBTProfiles'</b>:
     *
     * Vehicle Supported BT Profiles
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVehicleSupportedBTProfilesGet(VehicleSupportedBTProfilesCallbackIF& cb);

    // Property 'VehicleBTFriendlyNameset'

    /**
     * Notify on the property 'VehicleBTFriendlyNameset'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'VehicleBTFriendlyNameset'</b>:
     *
     * This is the new VehicleBTFriendlyName Which has set opcode included. And it also contains opcodes of(0x227)
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVehicleBTFriendlyNamesetUpReg(VehicleBTFriendlyNamesetCallbackIF& cb);

    /**
     * Remove the notifcation on property 'VehicleBTFriendlyNameset'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'VehicleBTFriendlyNameset'</b>:
     *
     * This is the new VehicleBTFriendlyName Which has set opcode included. And it also contains opcodes of(0x227)
     *
     * @param act The act which was previously returned by the
     * sendVehicleBTFriendlyNamesetUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendVehicleBTFriendlyNamesetRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'VehicleBTFriendlyNameset'.
     */
    void sendVehicleBTFriendlyNamesetRelUpRegAll ();

    /**
     * Returns the current value of the property 'VehicleBTFriendlyNameset'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasVehicleBTFriendlyNameset() returns true.
     *
     * @return the previously received value of the property 'VehicleBTFriendlyNameset'.
     */
    const VehicleBTFriendlyNamesetStatus& getVehicleBTFriendlyNameset() const;

    /**
     * Determines whether a status message for the property 'VehicleBTFriendlyNameset' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasVehicleBTFriendlyNameset() const;

    /**
     * Request the value of the property 'VehicleBTFriendlyNameset' from the
     * CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'VehicleBTFriendlyNameset'</b>:
     *
     * This is the new VehicleBTFriendlyName Which has set opcode included. And it also contains opcodes of(0x227)
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVehicleBTFriendlyNamesetGet(VehicleBTFriendlyNamesetCallbackIF& cb);

    /**
     * Set the value of the property 'VehicleBTFriendlyNameset'. This method
     * sends a Set message to the CCA server.
     *
     * <b>Documentation of 'VehicleBTFriendlyNameset'</b>:
     *
     * This is the new VehicleBTFriendlyName Which has set opcode included. And it also contains opcodes of(0x227)
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param sVehicleBTFriendlyName Set Vehicle BT friendly name
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVehicleBTFriendlyNamesetSet(VehicleBTFriendlyNamesetCallbackIF& cb, const ::fi_basetypes_most::T_String& sVehicleBTFriendlyName);

    // Property 'PairingRequest'

    /**
     * Notify on the property 'PairingRequest'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'PairingRequest'</b>:
     *
     * Provides info about where the pairing has been initiated (System/Device) and also the type of pairing (Legacy/SSP Numeric) for particular deivce.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPairingRequestUpReg(PairingRequestCallbackIF& cb);

    /**
     * Remove the notifcation on property 'PairingRequest'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'PairingRequest'</b>:
     *
     * Provides info about where the pairing has been initiated (System/Device) and also the type of pairing (Legacy/SSP Numeric) for particular deivce.
     *
     * @param act The act which was previously returned by the
     * sendPairingRequestUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendPairingRequestRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'PairingRequest'.
     */
    void sendPairingRequestRelUpRegAll ();

    /**
     * Returns the current value of the property 'PairingRequest' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasPairingRequest() returns true.
     *
     * @return the previously received value of the property 'PairingRequest'.
     */
    const PairingRequestStatus& getPairingRequest() const;

    /**
     * Determines whether a status message for the property 'PairingRequest' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasPairingRequest() const;

    /**
     * Request the value of the property 'PairingRequest' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'PairingRequest'</b>:
     *
     * Provides info about where the pairing has been initiated (System/Device) and also the type of pairing (Legacy/SSP Numeric) for particular deivce.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPairingRequestGet(PairingRequestCallbackIF& cb);

    // Property 'DeviceListExtended'

    /**
     * Notify on the property 'DeviceListExtended'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'DeviceListExtended'</b>:
     *
     * Device List Extended.
     * Provides a list of each paired Bluetooth device and its current status and
     * specifically informs the HMI controller of the device and the change in
     * device status that has triggered the notification.The
     * DeviceListResult stream provides a list of each paired Bluetooth device
     * identifying which of the profiles of the devices are connected and which
     * are all the supported profiles and which device is the outgoing
     * source device. The connected devices are sorted with the outgoing source
     * device first. If an outgoing source device does not exist the devices are
     * sorted in order of the most recently to least recently connected device.
     * The not connected devices are sorted in order of the most recently to
     * least recently connected device.The NumPairedDevices provides the
     * number of paired devices such that the parsing of the DeviceListResult is
     * simplified.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDeviceListExtendedUpReg(DeviceListExtendedCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DeviceListExtended'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DeviceListExtended'</b>:
     *
     * Device List Extended.
     * Provides a list of each paired Bluetooth device and its current status and
     * specifically informs the HMI controller of the device and the change in
     * device status that has triggered the notification.The
     * DeviceListResult stream provides a list of each paired Bluetooth device
     * identifying which of the profiles of the devices are connected and which
     * are all the supported profiles and which device is the outgoing
     * source device. The connected devices are sorted with the outgoing source
     * device first. If an outgoing source device does not exist the devices are
     * sorted in order of the most recently to least recently connected device.
     * The not connected devices are sorted in order of the most recently to
     * least recently connected device.The NumPairedDevices provides the
     * number of paired devices such that the parsing of the DeviceListResult is
     * simplified.
     *
     * @param act The act which was previously returned by the
     * sendDeviceListExtendedUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDeviceListExtendedRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DeviceListExtended'.
     */
    void sendDeviceListExtendedRelUpRegAll ();

    /**
     * Returns the current value of the property 'DeviceListExtended' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasDeviceListExtended() returns true.
     *
     * @return the previously received value of the property 'DeviceListExtended'.
     */
    const DeviceListExtendedStatus& getDeviceListExtended() const;

    /**
     * Determines whether a status message for the property 'DeviceListExtended' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDeviceListExtended() const;

    /**
     * Request the value of the property 'DeviceListExtended' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'DeviceListExtended'</b>:
     *
     * Device List Extended.
     * Provides a list of each paired Bluetooth device and its current status and
     * specifically informs the HMI controller of the device and the change in
     * device status that has triggered the notification.The
     * DeviceListResult stream provides a list of each paired Bluetooth device
     * identifying which of the profiles of the devices are connected and which
     * are all the supported profiles and which device is the outgoing
     * source device. The connected devices are sorted with the outgoing source
     * device first. If an outgoing source device does not exist the devices are
     * sorted in order of the most recently to least recently connected device.
     * The not connected devices are sorted in order of the most recently to
     * least recently connected device.The NumPairedDevices provides the
     * number of paired devices such that the parsing of the DeviceListResult is
     * simplified.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDeviceListExtendedGet(DeviceListExtendedCallbackIF& cb);

    // Property 'VisibleDevices'

    /**
     * Notify on the property 'VisibleDevices'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'VisibleDevices'</b>:
     *
     * VisibleDevices property provides a list of visible devices found during the Inquiry scan procedure initiated via ScanBluetoothDevices MethodStart.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVisibleDevicesUpReg(VisibleDevicesCallbackIF& cb);

    /**
     * Remove the notifcation on property 'VisibleDevices'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'VisibleDevices'</b>:
     *
     * VisibleDevices property provides a list of visible devices found during the Inquiry scan procedure initiated via ScanBluetoothDevices MethodStart.
     *
     * @param act The act which was previously returned by the
     * sendVisibleDevicesUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendVisibleDevicesRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'VisibleDevices'.
     */
    void sendVisibleDevicesRelUpRegAll ();

    /**
     * Returns the current value of the property 'VisibleDevices' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasVisibleDevices() returns true.
     *
     * @return the previously received value of the property 'VisibleDevices'.
     */
    const VisibleDevicesStatus& getVisibleDevices() const;

    /**
     * Determines whether a status message for the property 'VisibleDevices' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasVisibleDevices() const;

    /**
     * Request the value of the property 'VisibleDevices' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'VisibleDevices'</b>:
     *
     * VisibleDevices property provides a list of visible devices found during the Inquiry scan procedure initiated via ScanBluetoothDevices MethodStart.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVisibleDevicesGet(VisibleDevicesCallbackIF& cb);

    // Property 'PairableMode'

    /**
     * Notify on the property 'PairableMode'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'PairableMode'</b>:
     *
     * This property informs to the client whether the Bluetooth module is in discoverable and ready to be paired.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPairableModeUpReg(PairableModeCallbackIF& cb);

    /**
     * Remove the notifcation on property 'PairableMode'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'PairableMode'</b>:
     *
     * This property informs to the client whether the Bluetooth module is in discoverable and ready to be paired.
     *
     * @param act The act which was previously returned by the
     * sendPairableModeUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendPairableModeRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'PairableMode'.
     */
    void sendPairableModeRelUpRegAll ();

    /**
     * Returns the current value of the property 'PairableMode' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasPairableMode() returns true.
     *
     * @return the previously received value of the property 'PairableMode'.
     */
    const PairableModeStatus& getPairableMode() const;

    /**
     * Determines whether a status message for the property 'PairableMode' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasPairableMode() const;

    /**
     * Request the value of the property 'PairableMode' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'PairableMode'</b>:
     *
     * This property informs to the client whether the Bluetooth module is in discoverable and ready to be paired.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPairableModeGet(PairableModeCallbackIF& cb);

    // Property 'SignalStrength'

    /**
     * Notify on the property 'SignalStrength'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'SignalStrength'</b>:
     *
     * This property is used to indicate the signal strength for connected devices to the registered clients.
     * The property returns a list of connected device handles and the corresponding signal strengths.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSignalStrengthUpReg(SignalStrengthCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SignalStrength'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SignalStrength'</b>:
     *
     * This property is used to indicate the signal strength for connected devices to the registered clients.
     * The property returns a list of connected device handles and the corresponding signal strengths.
     *
     * @param act The act which was previously returned by the
     * sendSignalStrengthUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSignalStrengthRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SignalStrength'.
     */
    void sendSignalStrengthRelUpRegAll ();

    /**
     * Returns the current value of the property 'SignalStrength' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasSignalStrength() returns true.
     *
     * @return the previously received value of the property 'SignalStrength'.
     */
    const SignalStrengthStatus& getSignalStrength() const;

    /**
     * Determines whether a status message for the property 'SignalStrength' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSignalStrength() const;

    /**
     * Request the value of the property 'SignalStrength' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'SignalStrength'</b>:
     *
     * This property is used to indicate the signal strength for connected devices to the registered clients.
     * The property returns a list of connected device handles and the corresponding signal strengths.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSignalStrengthGet(SignalStrengthCallbackIF& cb);

    // Property 'SPPServiceConnection'

    /**
     * Notify on the property 'SPPServiceConnection'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'SPPServiceConnection'</b>:
     *
     * This property will contain the RFComm device name.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSPPServiceConnectionUpReg(SPPServiceConnectionCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SPPServiceConnection'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SPPServiceConnection'</b>:
     *
     * This property will contain the RFComm device name.
     *
     * @param act The act which was previously returned by the
     * sendSPPServiceConnectionUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSPPServiceConnectionRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SPPServiceConnection'.
     */
    void sendSPPServiceConnectionRelUpRegAll ();

    /**
     * Returns the current value of the property 'SPPServiceConnection' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasSPPServiceConnection() returns true.
     *
     * @return the previously received value of the property 'SPPServiceConnection'.
     */
    const SPPServiceConnectionStatus& getSPPServiceConnection() const;

    /**
     * Determines whether a status message for the property 'SPPServiceConnection' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSPPServiceConnection() const;

    /**
     * Request the value of the property 'SPPServiceConnection' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'SPPServiceConnection'</b>:
     *
     * This property will contain the RFComm device name.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSPPServiceConnectionGet(SPPServiceConnectionCallbackIF& cb);

    // Property 'BluetoothLimitationMode'

    /**
     * Notify on the property 'BluetoothLimitationMode'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'BluetoothLimitationMode'</b>:
     *
     * <p>This property provides a list of limitation/restriction settings w.r.t. Bluetooth behaviour which are currently handled by BluetoothSettings (BM application).</p>
     * <p>Normally there is only one entry in the list with same Bluetooth device address. But it can happen there are multiple entries with same Bluetooth device address. In this case the other parameters technology or communication channel have to be checked to find the matching entry.</p>
     * <p>Therefore following rule can be applied: Each list entry is identified by a tuple of Bluetooth device address, technology and communication channel.</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBluetoothLimitationModeUpReg(BluetoothLimitationModeCallbackIF& cb);

    /**
     * Remove the notifcation on property 'BluetoothLimitationMode'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'BluetoothLimitationMode'</b>:
     *
     * <p>This property provides a list of limitation/restriction settings w.r.t. Bluetooth behaviour which are currently handled by BluetoothSettings (BM application).</p>
     * <p>Normally there is only one entry in the list with same Bluetooth device address. But it can happen there are multiple entries with same Bluetooth device address. In this case the other parameters technology or communication channel have to be checked to find the matching entry.</p>
     * <p>Therefore following rule can be applied: Each list entry is identified by a tuple of Bluetooth device address, technology and communication channel.</p>
     *
     * @param act The act which was previously returned by the
     * sendBluetoothLimitationModeUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendBluetoothLimitationModeRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'BluetoothLimitationMode'.
     */
    void sendBluetoothLimitationModeRelUpRegAll ();

    /**
     * Returns the current value of the property 'BluetoothLimitationMode' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasBluetoothLimitationMode() returns true.
     *
     * @return the previously received value of the property 'BluetoothLimitationMode'.
     */
    const BluetoothLimitationModeStatus& getBluetoothLimitationMode() const;

    /**
     * Determines whether a status message for the property 'BluetoothLimitationMode' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasBluetoothLimitationMode() const;

    /**
     * Request the value of the property 'BluetoothLimitationMode' from the
     * CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'BluetoothLimitationMode'</b>:
     *
     * <p>This property provides a list of limitation/restriction settings w.r.t. Bluetooth behaviour which are currently handled by BluetoothSettings (BM application).</p>
     * <p>Normally there is only one entry in the list with same Bluetooth device address. But it can happen there are multiple entries with same Bluetooth device address. In this case the other parameters technology or communication channel have to be checked to find the matching entry.</p>
     * <p>Therefore following rule can be applied: Each list entry is identified by a tuple of Bluetooth device address, technology and communication channel.</p>
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBluetoothLimitationModeGet(BluetoothLimitationModeCallbackIF& cb);

    // Property 'MultiHFPSupport'

    /**
     * Notify on the property 'MultiHFPSupport'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'MultiHFPSupport'</b>:
     *
     * This property is used to indicate the Status of MultiHFPSupport to the registered clients.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMultiHFPSupportUpReg(MultiHFPSupportCallbackIF& cb);

    /**
     * Remove the notifcation on property 'MultiHFPSupport'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'MultiHFPSupport'</b>:
     *
     * This property is used to indicate the Status of MultiHFPSupport to the registered clients.
     *
     * @param act The act which was previously returned by the
     * sendMultiHFPSupportUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendMultiHFPSupportRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'MultiHFPSupport'.
     */
    void sendMultiHFPSupportRelUpRegAll ();

    /**
     * Returns the current value of the property 'MultiHFPSupport' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasMultiHFPSupport() returns true.
     *
     * @return the previously received value of the property 'MultiHFPSupport'.
     */
    const MultiHFPSupportStatus& getMultiHFPSupport() const;

    /**
     * Determines whether a status message for the property 'MultiHFPSupport' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasMultiHFPSupport() const;

    /**
     * Request the value of the property 'MultiHFPSupport' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'MultiHFPSupport'</b>:
     *
     * This property is used to indicate the Status of MultiHFPSupport to the registered clients.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMultiHFPSupportGet(MultiHFPSupportCallbackIF& cb);

    // Property 'BTProfilesUsageInfo'

    /**
     * Notify on the property 'BTProfilesUsageInfo'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'BTProfilesUsageInfo'</b>:
     *
     * This property is used to update the usage of various BT profiles to registered clients.
     * If the BT profiles are only connected but not in use, this list will be empty.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBTProfilesUsageInfoUpReg(BTProfilesUsageInfoCallbackIF& cb);

    /**
     * Remove the notifcation on property 'BTProfilesUsageInfo'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'BTProfilesUsageInfo'</b>:
     *
     * This property is used to update the usage of various BT profiles to registered clients.
     * If the BT profiles are only connected but not in use, this list will be empty.
     *
     * @param act The act which was previously returned by the
     * sendBTProfilesUsageInfoUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendBTProfilesUsageInfoRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'BTProfilesUsageInfo'.
     */
    void sendBTProfilesUsageInfoRelUpRegAll ();

    /**
     * Returns the current value of the property 'BTProfilesUsageInfo' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasBTProfilesUsageInfo() returns true.
     *
     * @return the previously received value of the property 'BTProfilesUsageInfo'.
     */
    const BTProfilesUsageInfoStatus& getBTProfilesUsageInfo() const;

    /**
     * Determines whether a status message for the property 'BTProfilesUsageInfo' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasBTProfilesUsageInfo() const;

    /**
     * Request the value of the property 'BTProfilesUsageInfo' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'BTProfilesUsageInfo'</b>:
     *
     * This property is used to update the usage of various BT profiles to registered clients.
     * If the BT profiles are only connected but not in use, this list will be empty.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBTProfilesUsageInfoGet(BTProfilesUsageInfoCallbackIF& cb);

    // Property 'ConflictsDetected'

    /**
     * Notify on the property 'ConflictsDetected'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'ConflictsDetected'</b>:
     *
     * This property is used to update the update the conflicts which arise during a conflict trigger.
     * Client has to resolve the conflicts and inform using interface ResolveConflicts().
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConflictsDetectedUpReg(ConflictsDetectedCallbackIF& cb);

    /**
     * Remove the notifcation on property 'ConflictsDetected'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'ConflictsDetected'</b>:
     *
     * This property is used to update the update the conflicts which arise during a conflict trigger.
     * Client has to resolve the conflicts and inform using interface ResolveConflicts().
     *
     * @param act The act which was previously returned by the
     * sendConflictsDetectedUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendConflictsDetectedRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'ConflictsDetected'.
     */
    void sendConflictsDetectedRelUpRegAll ();

    /**
     * Returns the current value of the property 'ConflictsDetected' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasConflictsDetected() returns true.
     *
     * @return the previously received value of the property 'ConflictsDetected'.
     */
    const ConflictsDetectedStatus& getConflictsDetected() const;

    /**
     * Determines whether a status message for the property 'ConflictsDetected' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasConflictsDetected() const;

    /**
     * Request the value of the property 'ConflictsDetected' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'ConflictsDetected'</b>:
     *
     * This property is used to update the update the conflicts which arise during a conflict trigger.
     * Client has to resolve the conflicts and inform using interface ResolveConflicts().
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConflictsDetectedGet(ConflictsDetectedCallbackIF& cb);

    // Property 'AutoConnectionStatus'

    /**
     * Notify on the property 'AutoConnectionStatus'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'AutoConnectionStatus'</b>:
     *
     * This property is used to update the status of the auto connection.
     * DeviceHandle is vaild only if e8AutoConnectionStatus is IN_PROGRESS
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAutoConnectionStatusUpReg(AutoConnectionStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'AutoConnectionStatus'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'AutoConnectionStatus'</b>:
     *
     * This property is used to update the status of the auto connection.
     * DeviceHandle is vaild only if e8AutoConnectionStatus is IN_PROGRESS
     *
     * @param act The act which was previously returned by the
     * sendAutoConnectionStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendAutoConnectionStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'AutoConnectionStatus'.
     */
    void sendAutoConnectionStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'AutoConnectionStatus' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasAutoConnectionStatus() returns true.
     *
     * @return the previously received value of the property 'AutoConnectionStatus'.
     */
    const AutoConnectionStatusStatus& getAutoConnectionStatus() const;

    /**
     * Determines whether a status message for the property 'AutoConnectionStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAutoConnectionStatus() const;

    /**
     * Request the value of the property 'AutoConnectionStatus' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'AutoConnectionStatus'</b>:
     *
     * This property is used to update the status of the auto connection.
     * DeviceHandle is vaild only if e8AutoConnectionStatus is IN_PROGRESS
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAutoConnectionStatusGet(AutoConnectionStatusCallbackIF& cb);

    // Property 'ServiceAvailable'

    /**
     * Notify on the property 'ServiceAvailable'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'ServiceAvailable'</b>:
     *
     * This property is used to update the service availability of BMApp based on the BT SPM State.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendServiceAvailableUpReg(ServiceAvailableCallbackIF& cb);

    /**
     * Remove the notifcation on property 'ServiceAvailable'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'ServiceAvailable'</b>:
     *
     * This property is used to update the service availability of BMApp based on the BT SPM State.
     *
     * @param act The act which was previously returned by the
     * sendServiceAvailableUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendServiceAvailableRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'ServiceAvailable'.
     */
    void sendServiceAvailableRelUpRegAll ();

    /**
     * Returns the current value of the property 'ServiceAvailable' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasServiceAvailable() returns true.
     *
     * @return the previously received value of the property 'ServiceAvailable'.
     */
    const ServiceAvailableStatus& getServiceAvailable() const;

    /**
     * Determines whether a status message for the property 'ServiceAvailable' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasServiceAvailable() const;

    /**
     * Request the value of the property 'ServiceAvailable' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'ServiceAvailable'</b>:
     *
     * This property is used to update the service availability of BMApp based on the BT SPM State.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendServiceAvailableGet(ServiceAvailableCallbackIF& cb);

    // Property 'VehicleConfiguration'

    /**
     * Notify on the property 'VehicleConfiguration'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'VehicleConfiguration'</b>:
     *
     * This contains information regarding the vehicle configuration.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVehicleConfigurationUpReg(VehicleConfigurationCallbackIF& cb);

    /**
     * Remove the notifcation on property 'VehicleConfiguration'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'VehicleConfiguration'</b>:
     *
     * This contains information regarding the vehicle configuration.
     *
     * @param act The act which was previously returned by the
     * sendVehicleConfigurationUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendVehicleConfigurationRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'VehicleConfiguration'.
     */
    void sendVehicleConfigurationRelUpRegAll ();

    /**
     * Returns the current value of the property 'VehicleConfiguration' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasVehicleConfiguration() returns true.
     *
     * @return the previously received value of the property 'VehicleConfiguration'.
     */
    const VehicleConfigurationStatus& getVehicleConfiguration() const;

    /**
     * Determines whether a status message for the property 'VehicleConfiguration' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasVehicleConfiguration() const;

    /**
     * Request the value of the property 'VehicleConfiguration' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'VehicleConfiguration'</b>:
     *
     * This contains information regarding the vehicle configuration.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVehicleConfigurationGet(VehicleConfigurationCallbackIF& cb);

    /**
     * Release all property notifications (on all properties).
     */
    void sendRelUpRegAll ();

private:

    MOST_BTSet_FIProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags);

    virtual void clearAllProperties ();

    ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > createCallback (uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb);

    // Property 'BluetoothOnOff'

    ::asf::core::nullable< BluetoothOnOffStatus > _bluetoothOnOff;

    // Property 'PairingStatus'

    ::asf::core::nullable< PairingStatusStatus > _pairingStatus;

    // Property 'ChangeRingtone'

    ::asf::core::nullable< ChangeRingtoneStatus > _changeRingtone;

    // Property 'VehicleBTFriendlyName'

    ::asf::core::nullable< VehicleBTFriendlyNameStatus > _vehicleBTFriendlyName;

    // Property 'BluetoothAudioSource'

    ::asf::core::nullable< BluetoothAudioSourceStatus > _bluetoothAudioSource;

    // Property 'PairingPin'

    ::asf::core::nullable< PairingPinStatus > _pairingPin;

    // Property 'MaxDevicesPaired'

    ::asf::core::nullable< MaxDevicesPairedStatus > _maxDevicesPaired;

    // Property 'AutoConnectOnOff'

    ::asf::core::nullable< AutoConnectOnOffStatus > _autoConnectOnOff;

    // Property 'VehicleBTAddress'

    ::asf::core::nullable< VehicleBTAddressStatus > _vehicleBTAddress;

    // Property 'VehicleSupportedBTProfiles'

    ::asf::core::nullable< VehicleSupportedBTProfilesStatus > _vehicleSupportedBTProfiles;

    // Property 'VehicleBTFriendlyNameset'

    ::asf::core::nullable< VehicleBTFriendlyNamesetStatus > _vehicleBTFriendlyNameset;

    // Property 'PairingRequest'

    ::asf::core::nullable< PairingRequestStatus > _pairingRequest;

    // Property 'DeviceListExtended'

    ::asf::core::nullable< DeviceListExtendedStatus > _deviceListExtended;

    // Property 'VisibleDevices'

    ::asf::core::nullable< VisibleDevicesStatus > _visibleDevices;

    // Property 'PairableMode'

    ::asf::core::nullable< PairableModeStatus > _pairableMode;

    // Property 'SignalStrength'

    ::asf::core::nullable< SignalStrengthStatus > _signalStrength;

    // Property 'SPPServiceConnection'

    ::asf::core::nullable< SPPServiceConnectionStatus > _sPPServiceConnection;

    // Property 'BluetoothLimitationMode'

    ::asf::core::nullable< BluetoothLimitationModeStatus > _bluetoothLimitationMode;

    // Property 'MultiHFPSupport'

    ::asf::core::nullable< MultiHFPSupportStatus > _multiHFPSupport;

    // Property 'BTProfilesUsageInfo'

    ::asf::core::nullable< BTProfilesUsageInfoStatus > _bTProfilesUsageInfo;

    // Property 'ConflictsDetected'

    ::asf::core::nullable< ConflictsDetectedStatus > _conflictsDetected;

    // Property 'AutoConnectionStatus'

    ::asf::core::nullable< AutoConnectionStatusStatus > _autoConnectionStatus;

    // Property 'ServiceAvailable'

    ::asf::core::nullable< ServiceAvailableStatus > _serviceAvailable;

    // Property 'VehicleConfiguration'

    ::asf::core::nullable< VehicleConfigurationStatus > _vehicleConfiguration;

    DECLARE_CLASS_LOGGER();

    friend class MOST_BTSet_FIProxyCallback;
};

} // namespace MOST_BTSet_FI

#endif // MOST_BTSET_FIPROXY_H
