#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef MOST_BTSET_FI_H
#define MOST_BTSET_FI_H

#include "asf/cca/CcaTypes.h"
#include "asf/cca/CcaTypesConst.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "fi_basetypes_most.h"
#include "fi_basetypes_mostConst.h"
#include "most_BTSet_fi_types.h"
#include "most_BTSet_fi_typesConst.h"
#include "most_BTSet_fi_types_Extended.h"
#include "most_BTSet_fi_types_ExtendedConst.h"
#include <cstring>
#include <vector>

/**
 * CCA Functional Interface 'MOST_BTSet_FI'
 *
 * Fullname: Proprietary - BluetoothSettings
 *
 * Version: 5.7
 *
 * Author: Dominic Colella, General Motors
 *
 * Date: 2015-01-14
 *
 * Department:
 *
 * Title:
 *             MOST_BluetoothSettings_FI
 *
 * <b>Description of 'MOST_BTSet_FI':</b>
 *
 * <p>This FBlock was assembled from FBlockManifest file: BluetoothSettings.fblockman, Please consult individual interface files for interface-specific change history.</p>
 * The BluetoothSettings FBlock implements functions that allow HMI controllers to manage connected Bluetooth devices.  BluetoothSettings also acts as a control point for Audio Streaming devices that do not support the V1.4 or later AVRCP specification and that consequently cannot be meta-data indexed for integration within the MediaPlayer FBlock.  Such devices only support basic transport controls which is insufficient to integrate with the MediaPlayer's database-driven operation so these limited function devices are handled within BluetoothSettings instead.
 *
 * BluetoothSettings implements the IBluetoothSettings and ISource interfaces.  IBluetoothSettings is the main control interface used by HMI controllers.  The ISource interface is implemented to support the reduced-functionality Audio Streaming profile devices mentioned above.
 *
 * Please see GIS-327 Bluetooth Requirements Specification and GIS-379 Bluetooth Settings FBlock Specification for detailed feature/performance and dynamic/behavioral requirements.
 */

namespace MOST_BTSet_FI {

static const int SERVICE_ID = 535;

static const int FID_BluetoothOnOff = 512;

static const int FID_PairingStatus = 515;

static const int FID_ChangeRingtone = 530;

static const int FID_VehicleBTFriendlyName = 551;

static const int FID_BluetoothAudioSource = 552;

static const int FID_PairingPin = 553;

static const int FID_MaxDevicesPaired = 556;

static const int FID_AddNewDevice = 513;

static const int FID_PairingResponse = 514;

static const int FID_ChangePin = 516;

static const int FID_ChangeDeviceState = 519;

static const int FID_ReplaceDevice = 520;

static const int FID_RequestDeviceRingtoneList = 521;

static const int FID_RequestAvailableRingtonesList = 528;

static const int FID_PlayRingtone = 529;

static const int FID_ClearDeviceInfo = 554;

static const int FID_AutoConnectOnOff = 3841;

static const int FID_VehicleBTAddress = 3842;

static const int FID_VehicleSupportedBTProfiles = 3843;

static const int FID_VehicleBTFriendlyNameset = 3844;

static const int FID_PairingRequest = 3845;

static const int FID_DeviceListExtended = 3846;

static const int FID_VisibleDevices = 3847;

static const int FID_PairableMode = 3848;

static const int FID_SignalStrength = 3850;

static const int FID_SPPServiceConnection = 3851;

static const int FID_BluetoothLimitationMode = 3852;

static const int FID_MultiHFPSupport = 3853;

static const int FID_BTProfilesUsageInfo = 3854;

static const int FID_ConflictsDetected = 3855;

static const int FID_AutoConnectionStatus = 3856;

static const int FID_ServiceAvailable = 3857;

static const int FID_VehicleConfiguration = 3858;

static const int FID_GetDeviceInfoExtended = 3891;

static const int FID_StopRingtone = 3893;

static const int FID_ScanBluetoothDevices = 3894;

static const int FID_ConnectBluetoothProfile = 3895;

static const int FID_DisconnectBluetoothProfile = 3896;

static const int FID_SendPairingRequest = 3897;

static const int FID_SwitchBTLocalMode = 3898;

static const int FID_StartAutoConnectSequence = 3899;

static const int FID_ConnectSPPService = 3900;

static const int FID_SetBluetoothLimitationMode = 3901;

static const int FID_SwitchBluetoothOnOffExtended = 3902;

static const int FID_ChangeWifiTransmitPower = 3903;

static const int FID_DisconnectSPPService = 3904;

static const int FID_StartSearchSPPServices = 3905;

static const int FID_StopSearchSPPServices = 3906;

static const int FID_AddOobPairedDevice = 3907;

static const int FID_SetFavorite = 3908;

static const int FID_ClearFavorite = 3909;

static const int FID_SwitchMultiHFPSupport = 3910;

static const int FID_SetPrimary = 3911;

static const int FID_SetBTProfilesUsage = 3912;

static const int FID_ResolveConflicts = 3913;

static const int FID_SetDeviceUsagePreference = 3914;

static const int FID_SetProfileUserAvailability = 3915;

static const int FID_ReplaceBluetoothLimitationMode = 3916;


ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 5;

static const int VERSION_MINOR = 7;

static const int VERSION_PATCH = 0;

// forward declarations
class BluetoothOnOffStatus;

class BluetoothOnOffSet;

class BluetoothOnOffErrorStructure;

class BluetoothOnOffError;

class PairingStatusStatus;

class PairingStatusErrorStructure;

class PairingStatusError;

class ChangeRingtoneStatus;

class ChangeRingtonePureSet;

class ChangeRingtoneErrorStructure;

class ChangeRingtoneError;

class VehicleBTFriendlyNameStatus;

class VehicleBTFriendlyNameErrorStructure;

class VehicleBTFriendlyNameError;

class BluetoothAudioSourceStatus;

class BluetoothAudioSourcePureSet;

class PairingPinStatus;

class MaxDevicesPairedStatus;

class MaxDevicesPairedErrorStructure;

class MaxDevicesPairedError;

class AddNewDeviceStart;

class AddNewDeviceResult;

class AddNewDeviceErrorStructure;

class AddNewDeviceError;

class PairingResponseStart;

class PairingResponseResult;

class PairingResponseErrorStructure;

class PairingResponseError;

class ChangePinStart;

class ChangePinResult;

class ChangePinErrorStructure;

class ChangePinError;

class ChangeDeviceStateStart;

class ChangeDeviceStateResult;

class ChangeDeviceStateErrorStructure;

class ChangeDeviceStateError;

class ReplaceDeviceStart;

class ReplaceDeviceResult;

class ReplaceDeviceErrorStructure;

class ReplaceDeviceError;

class RequestDeviceRingtoneListStart;

class RequestDeviceRingtoneListResult;

class RequestDeviceRingtoneListErrorStructure;

class RequestDeviceRingtoneListError;

class RequestAvailableRingtonesListStart;

class RequestAvailableRingtonesListResult;

class RequestAvailableRingtonesListErrorStructure;

class RequestAvailableRingtonesListError;

class PlayRingtoneStart;

class PlayRingtoneResult;

class PlayRingtoneErrorStructure;

class PlayRingtoneError;

class ClearDeviceInfoResult;

class ClearDeviceInfoErrorStructure;

class ClearDeviceInfoError;

class AutoConnectOnOffStatus;

class AutoConnectOnOffSet;

class AutoConnectOnOffGet;

class AutoConnectOnOffErrorStructure;

class AutoConnectOnOffError;

class VehicleBTAddressStatus;

class VehicleBTAddressErrorStructure;

class VehicleBTAddressError;

class VehicleSupportedBTProfilesStatus;

class VehicleSupportedBTProfilesErrorStructure;

class VehicleSupportedBTProfilesError;

class VehicleBTFriendlyNamesetStatus;

class VehicleBTFriendlyNamesetSet;

class VehicleBTFriendlyNamesetErrorStructure;

class VehicleBTFriendlyNamesetError;

class PairingRequestStatus;

class PairingRequestErrorStructure;

class PairingRequestError;

class DeviceListExtendedStatus;

class DeviceListExtendedErrorStructure;

class DeviceListExtendedError;

class VisibleDevicesStatus;

class VisibleDevicesErrorStructure;

class VisibleDevicesError;

class PairableModeStatus;

class PairableModeErrorStructure;

class PairableModeError;

class SignalStrengthStatus;

class SignalStrengthErrorStructure;

class SignalStrengthError;

class SPPServiceConnectionStatus;

class SPPServiceConnectionErrorStructure;

class SPPServiceConnectionError;

class BluetoothLimitationModeStatus;

class BluetoothLimitationModeErrorStructure;

class BluetoothLimitationModeError;

class MultiHFPSupportStatus;

class MultiHFPSupportErrorStructure;

class MultiHFPSupportError;

class BTProfilesUsageInfoStatus;

class BTProfilesUsageInfoErrorStructure;

class BTProfilesUsageInfoError;

class ConflictsDetectedStatus;

class ConflictsDetectedErrorStructure;

class ConflictsDetectedError;

class AutoConnectionStatusStatus;

class AutoConnectionStatusErrorStructure;

class AutoConnectionStatusError;

class ServiceAvailableStatus;

class ServiceAvailableErrorStructure;

class ServiceAvailableError;

class VehicleConfigurationStatus;

class VehicleConfigurationErrorStructure;

class VehicleConfigurationError;

class GetDeviceInfoExtendedStart;

class GetDeviceInfoExtendedResult;

class GetDeviceInfoExtendedErrorStructure;

class GetDeviceInfoExtendedError;

class StopRingtoneResult;

class StopRingtoneErrorStructure;

class StopRingtoneError;

class ScanBluetoothDevicesStart;

class ScanBluetoothDevicesResult;

class ScanBluetoothDevicesErrorStructure;

class ScanBluetoothDevicesError;

class ConnectBluetoothProfileStart;

class ConnectBluetoothProfileResult;

class ConnectBluetoothProfileErrorStructure;

class ConnectBluetoothProfileError;

class DisconnectBluetoothProfileStart;

class DisconnectBluetoothProfileResult;

class DisconnectBluetoothProfileErrorStructure;

class DisconnectBluetoothProfileError;

class SendPairingRequestStart;

class SendPairingRequestResult;

class SendPairingRequestErrorStructure;

class SendPairingRequestError;

class SwitchBTLocalModeStart;

class SwitchBTLocalModeResult;

class SwitchBTLocalModeErrorStructure;

class SwitchBTLocalModeError;

class StartAutoConnectSequenceStart;

class StartAutoConnectSequenceResult;

class StartAutoConnectSequenceErrorStructure;

class StartAutoConnectSequenceError;

class ConnectSPPServiceStart;

class ConnectSPPServiceResult;

class ConnectSPPServiceErrorStructure;

class ConnectSPPServiceError;

class SetBluetoothLimitationModeStart;

class SetBluetoothLimitationModeResult;

class SetBluetoothLimitationModeErrorStructure;

class SetBluetoothLimitationModeError;

class SwitchBluetoothOnOffExtendedStart;

class SwitchBluetoothOnOffExtendedResult;

class SwitchBluetoothOnOffExtendedErrorStructure;

class SwitchBluetoothOnOffExtendedError;

class ChangeWifiTransmitPowerStart;

class ChangeWifiTransmitPowerResult;

class ChangeWifiTransmitPowerErrorStructure;

class ChangeWifiTransmitPowerError;

class DisconnectSPPServiceStart;

class DisconnectSPPServiceResult;

class DisconnectSPPServiceErrorStructure;

class DisconnectSPPServiceError;

class StartSearchSPPServicesStart;

class StartSearchSPPServicesResult;

class StartSearchSPPServicesErrorStructure;

class StartSearchSPPServicesError;

class StopSearchSPPServicesStart;

class StopSearchSPPServicesResult;

class StopSearchSPPServicesErrorStructure;

class StopSearchSPPServicesError;

class AddOobPairedDeviceStart;

class AddOobPairedDeviceResult;

class AddOobPairedDeviceErrorStructure;

class AddOobPairedDeviceError;

class SetFavoriteStart;

class SetFavoriteResult;

class SetFavoriteErrorStructure;

class SetFavoriteError;

class ClearFavoriteStart;

class ClearFavoriteResult;

class ClearFavoriteErrorStructure;

class ClearFavoriteError;

class SwitchMultiHFPSupportStart;

class SwitchMultiHFPSupportResult;

class SwitchMultiHFPSupportErrorStructure;

class SwitchMultiHFPSupportError;

class SetPrimaryStart;

class SetPrimaryResult;

class SetPrimaryErrorStructure;

class SetPrimaryError;

class SetBTProfilesUsageStart;

class SetBTProfilesUsageResult;

class SetBTProfilesUsageErrorStructure;

class SetBTProfilesUsageError;

class ResolveConflictsStart;

class ResolveConflictsResult;

class ResolveConflictsErrorStructure;

class ResolveConflictsError;

class SetDeviceUsagePreferenceStart;

class SetDeviceUsagePreferenceResult;

class SetDeviceUsagePreferenceErrorStructure;

class SetDeviceUsagePreferenceError;

class SetProfileUserAvailabilityStart;

class SetProfileUserAvailabilityResult;

class SetProfileUserAvailabilityErrorStructure;

class SetProfileUserAvailabilityError;

class ReplaceBluetoothLimitationModeStart;

class ReplaceBluetoothLimitationModeResult;

class ReplaceBluetoothLimitationModeErrorStructure;

class ReplaceBluetoothLimitationModeError;

// type definitions
/**
 * The get message of the property "BluetoothOnOff"
 * Activate/De-activate Bluetooth
 */
typedef ::asf::cca::CcaTypes::DefaultMessage BluetoothOnOffGet;

/**
 * The upreg message of the property "BluetoothOnOff"
 * Activate/De-activate Bluetooth
 */
typedef ::asf::cca::CcaTypes::DefaultMessage BluetoothOnOffUpReg;

/**
 * The relUpReg message of the property "BluetoothOnOff"
 * Activate/De-activate Bluetooth
 */
typedef ::asf::cca::CcaTypes::DefaultMessage BluetoothOnOffRelUpReg;

/**
 * The get message of the property "PairingStatus"
 * Identifies when the pairing process was completed successfully or informs the HMI when the pairing process was unsuccessful and for what reason. In addition, if notifies the HMI when the pairing process was canceled. If the pairing process was retried the pairing status provides notification of what type of retry was completed.  DeviceName only returned if PAIRING_STATUS_SUCCESSFUL
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PairingStatusGet;

/**
 * The upreg message of the property "PairingStatus"
 * Identifies when the pairing process was completed successfully or informs the HMI when the pairing process was unsuccessful and for what reason. In addition, if notifies the HMI when the pairing process was canceled. If the pairing process was retried the pairing status provides notification of what type of retry was completed.  DeviceName only returned if PAIRING_STATUS_SUCCESSFUL
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PairingStatusUpReg;

/**
 * The relUpReg message of the property "PairingStatus"
 * Identifies when the pairing process was completed successfully or informs the HMI when the pairing process was unsuccessful and for what reason. In addition, if notifies the HMI when the pairing process was canceled. If the pairing process was retried the pairing status provides notification of what type of retry was completed.  DeviceName only returned if PAIRING_STATUS_SUCCESSFUL
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PairingStatusRelUpReg;

/**
 * The upreg message of the property "ChangeRingtone"
 * Changes the active ringtone for the respective device to the selected ringtone.  This function is defined as a settable Property instead of a Method so that all HMI controllers can receive notifications that a ringtone for a device has been changed.  Note that the Get operation is not defined because the Status can only be generated in response to the Set optype on a particular device.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ChangeRingtoneUpReg;

/**
 * The relUpReg message of the property "ChangeRingtone"
 * Changes the active ringtone for the respective device to the selected ringtone.  This function is defined as a settable Property instead of a Method so that all HMI controllers can receive notifications that a ringtone for a device has been changed.  Note that the Get operation is not defined because the Status can only be generated in response to the Set optype on a particular device.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ChangeRingtoneRelUpReg;

/**
 * The get message of the property "VehicleBTFriendlyName"
 * This is the VehicleBTFriendlyName.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VehicleBTFriendlyNameGet;

/**
 * The upreg message of the property "VehicleBTFriendlyName"
 * This is the VehicleBTFriendlyName.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VehicleBTFriendlyNameUpReg;

/**
 * The relUpReg message of the property "VehicleBTFriendlyName"
 * This is the VehicleBTFriendlyName.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VehicleBTFriendlyNameRelUpReg;

/**
 * The get message of the property "BluetoothAudioSource"
 * Identifies the Bluetooth source device and provides the HMI with the supported transport control and features of the device such that the appropriate screen can be displayed.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage BluetoothAudioSourceGet;

/**
 * The upreg message of the property "BluetoothAudioSource"
 * Identifies the Bluetooth source device and provides the HMI with the supported transport control and features of the device such that the appropriate screen can be displayed.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage BluetoothAudioSourceUpReg;

/**
 * The relUpReg message of the property "BluetoothAudioSource"
 * Identifies the Bluetooth source device and provides the HMI with the supported transport control and features of the device such that the appropriate screen can be displayed.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage BluetoothAudioSourceRelUpReg;

/**
 * The error message of 'BluetoothAudioSource'
 */
typedef ::asf::cca::CcaTypes::DefaultError BluetoothAudioSourceError;

/**
 * The get message of the property "PairingPin"
 * Used to acquire the pairing PIN for the current pairing process.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PairingPinGet;

/**
 * The upreg message of the property "PairingPin"
 * Used to acquire the pairing PIN for the current pairing process.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PairingPinUpReg;

/**
 * The relUpReg message of the property "PairingPin"
 * Used to acquire the pairing PIN for the current pairing process.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PairingPinRelUpReg;

/**
 * The error message of 'PairingPin'
 */
typedef ::asf::cca::CcaTypes::DefaultError PairingPinError;

/**
 * The get message of the property "MaxDevicesPaired"
 * Notification that informs the HMI controller that the maximum number of
 * Bluetooth devices (10) have been paired. It provides the DeviceHandle and
 * DeviceName of the device which has not been connected for the longest time
 * (i.e. least recent DateTimeStamp).Notification shall be sent when
 * the 10th Bluetooth device is paired or when the device which has not been
 * connected for the longest time changes.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MaxDevicesPairedGet;

/**
 * The upreg message of the property "MaxDevicesPaired"
 * Notification that informs the HMI controller that the maximum number of
 * Bluetooth devices (10) have been paired. It provides the DeviceHandle and
 * DeviceName of the device which has not been connected for the longest time
 * (i.e. least recent DateTimeStamp).Notification shall be sent when
 * the 10th Bluetooth device is paired or when the device which has not been
 * connected for the longest time changes.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MaxDevicesPairedUpReg;

/**
 * The relUpReg message of the property "MaxDevicesPaired"
 * Notification that informs the HMI controller that the maximum number of
 * Bluetooth devices (10) have been paired. It provides the DeviceHandle and
 * DeviceName of the device which has not been connected for the longest time
 * (i.e. least recent DateTimeStamp).Notification shall be sent when
 * the 10th Bluetooth device is paired or when the device which has not been
 * connected for the longest time changes.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MaxDevicesPairedRelUpReg;

/**
 * The abort error message of the method "AddNewDevice"
 * Function initiates the pairing process from the vehicle. The PairingType
 * result leads to the correct pairing information being displayed by the HMI.
 */
typedef ::asf::cca::CcaTypes::DefaultError AddNewDeviceAbortError;

/**
 * The abort error message of the method "PairingResponse"
 * Identifies the user response to a pairing request (i.e. for Secure Simple Pairing Numeric Comparison) and when the pairing process has been cancelled or retried by the user.
 */
typedef ::asf::cca::CcaTypes::DefaultError PairingResponseAbortError;

/**
 * The abort error message of the method "ChangePin"
 * Changes the current pin to one set by the user. Used in order to pair with devices that support Legacy pairing and have a fixed PIN and no interface for entering a PIN. Possible errors that may be encountered include: ERR_BS_INCORRECT_PIN_FORMAT
 */
typedef ::asf::cca::CcaTypes::DefaultError ChangePinAbortError;

/**
 * The abort error message of the method "ChangeDeviceState"
 * Identifies the action that the user has initiated that will change the
 * device list: Select, Disconnect, Delete, and Delete AllThe result
 * of this method will be the ConnectionResult(which identifies if the
 * requested device was connected or not) and the ReplaceDeviceRequired
 * result which indicates whether the HMI will need to provide the user with
 * a&#160;pop-up that will request the user to select which device to replace.If
 * the action is select, there are 3 options that could take place: change in
 * &#160;the outgoing source device, connect selected device, or a replace pop-up
 * that allows the user to select which device they want to replace (if this
 * &#160;is true, then the ReplaceDevice result of the ChangeDeviceState will be
 * &#160;true).If the action is disconnect, the device with the&#160;
 * DeviceHandle sent will be connected.If the action is delete, the
 * device with the DeviceHandle sent will be deleted. If the action is delete
 * all, all the devices shall be deleted and the DeviceHandle is not
 * &#160;required. talk about if action is select three options OSD, connect or
 * pop-up talk about all actions.
 */
typedef ::asf::cca::CcaTypes::DefaultError ChangeDeviceStateAbortError;

/**
 * The abort error message of the method "ReplaceDevice"
 * Replaces a currently connected device with another device based on user
 * selection. The currently connected device is disconnected and the selected
 * device is connected.The handle of the device to be connected and
 * disconnected are provided.The result is the ConnectionResult which
 * identifies if the requested device was connected or not.
 */
typedef ::asf::cca::CcaTypes::DefaultError ReplaceDeviceAbortError;

/**
 * The abort error message of the method "RequestDeviceRingtoneList"
 * Provides a list of each paired phone Bluetooth device with its currently selected ringtone.  The list is sorted in order of the most recently connected device first.
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestDeviceRingtoneListAbortError;

/**
 * The abort error message of the method "RequestAvailableRingtonesList"
 * Provides the list of ringtones available for selection for the particular device.
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestAvailableRingtonesListAbortError;

/**
 * The abort error message of the method "PlayRingtone"
 * When the method is called with u16RingtoneID set to any value between 0x02 - 0x0B, the identified
 * ringtone will play once, irrespective of the previously configured ringtone using the 'ChangeRingtone' interface.
 * If it is called with 0xFFFF or 0xFE, the configured ringtone is played continously.
 * In case the configured ringtone is not available or is set to 0x01 or 0xFF, default ringtone will be played continously.
 * MethodError would be reported if this method is called with any other RingtoneIDs.
 * Ringtone can be configured using the 'ChangeRingtone' interface.
 */
typedef ::asf::cca::CcaTypes::DefaultError PlayRingtoneAbortError;

/**
 * The start message of the method "ClearDeviceInfo"
 * This function is called to clear out all Bluetooth devices from the FBlock including all pairing
 * information, phone book information, if any, etc..Upon receipt of the StartAck optype,the BluetoothSettings
 * FBlock shall permanently delete all information associated with all devices from persistent memory.
 * This function is generally only used to clear out customer device / information when a vehicle is turned-in at
 * the end of lease or is sold.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ClearDeviceInfoStart;

/**
 * The abort error message of the method "ClearDeviceInfo"
 * This function is called to clear out all Bluetooth devices from the FBlock including all pairing
 * information, phone book information, if any, etc..Upon receipt of the StartAck optype,the BluetoothSettings
 * FBlock shall permanently delete all information associated with all devices from persistent memory.
 * This function is generally only used to clear out customer device / information when a vehicle is turned-in at
 * the end of lease or is sold.
 */
typedef ::asf::cca::CcaTypes::DefaultError ClearDeviceInfoAbortError;

/**
 * The upreg message of the property "AutoConnectOnOff"
 * Activate/De-activate AutoConnectOff
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AutoConnectOnOffUpReg;

/**
 * The relUpReg message of the property "AutoConnectOnOff"
 * Activate/De-activate AutoConnectOff
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AutoConnectOnOffRelUpReg;

/**
 * The get message of the property "VehicleBTAddress"
 * Vehicle BT Address
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VehicleBTAddressGet;

/**
 * The upreg message of the property "VehicleBTAddress"
 * Vehicle BT Address
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VehicleBTAddressUpReg;

/**
 * The relUpReg message of the property "VehicleBTAddress"
 * Vehicle BT Address
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VehicleBTAddressRelUpReg;

/**
 * The get message of the property "VehicleSupportedBTProfiles"
 * Vehicle Supported BT Profiles
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VehicleSupportedBTProfilesGet;

/**
 * The upreg message of the property "VehicleSupportedBTProfiles"
 * Vehicle Supported BT Profiles
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VehicleSupportedBTProfilesUpReg;

/**
 * The relUpReg message of the property "VehicleSupportedBTProfiles"
 * Vehicle Supported BT Profiles
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VehicleSupportedBTProfilesRelUpReg;

/**
 * The get message of the property "VehicleBTFriendlyNameset"
 * This is the new VehicleBTFriendlyName Which has set opcode included. And it also contains opcodes of(0x227)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VehicleBTFriendlyNamesetGet;

/**
 * The upreg message of the property "VehicleBTFriendlyNameset"
 * This is the new VehicleBTFriendlyName Which has set opcode included. And it also contains opcodes of(0x227)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VehicleBTFriendlyNamesetUpReg;

/**
 * The relUpReg message of the property "VehicleBTFriendlyNameset"
 * This is the new VehicleBTFriendlyName Which has set opcode included. And it also contains opcodes of(0x227)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VehicleBTFriendlyNamesetRelUpReg;

/**
 * The get message of the property "PairingRequest"
 * Provides info about where the pairing has been initiated (System/Device) and also the type of pairing (Legacy/SSP Numeric) for particular deivce.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PairingRequestGet;

/**
 * The upreg message of the property "PairingRequest"
 * Provides info about where the pairing has been initiated (System/Device) and also the type of pairing (Legacy/SSP Numeric) for particular deivce.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PairingRequestUpReg;

/**
 * The relUpReg message of the property "PairingRequest"
 * Provides info about where the pairing has been initiated (System/Device) and also the type of pairing (Legacy/SSP Numeric) for particular deivce.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PairingRequestRelUpReg;

/**
 * The get message of the property "DeviceListExtended"
 * Device List Extended.
 * Provides a list of each paired Bluetooth device and its current status and
 * specifically informs the HMI controller of the device and the change in
 * device status that has triggered the notification.The
 * DeviceListResult stream provides a list of each paired Bluetooth device
 * identifying which of the profiles of the devices are connected and which
 * are all the supported profiles and which device is the outgoing
 * source device. The connected devices are sorted with the outgoing source
 * device first. If an outgoing source device does not exist the devices are
 * sorted in order of the most recently to least recently connected device.
 * The not connected devices are sorted in order of the most recently to
 * least recently connected device.The NumPairedDevices provides the
 * number of paired devices such that the parsing of the DeviceListResult is
 * simplified.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DeviceListExtendedGet;

/**
 * The upreg message of the property "DeviceListExtended"
 * Device List Extended.
 * Provides a list of each paired Bluetooth device and its current status and
 * specifically informs the HMI controller of the device and the change in
 * device status that has triggered the notification.The
 * DeviceListResult stream provides a list of each paired Bluetooth device
 * identifying which of the profiles of the devices are connected and which
 * are all the supported profiles and which device is the outgoing
 * source device. The connected devices are sorted with the outgoing source
 * device first. If an outgoing source device does not exist the devices are
 * sorted in order of the most recently to least recently connected device.
 * The not connected devices are sorted in order of the most recently to
 * least recently connected device.The NumPairedDevices provides the
 * number of paired devices such that the parsing of the DeviceListResult is
 * simplified.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DeviceListExtendedUpReg;

/**
 * The relUpReg message of the property "DeviceListExtended"
 * Device List Extended.
 * Provides a list of each paired Bluetooth device and its current status and
 * specifically informs the HMI controller of the device and the change in
 * device status that has triggered the notification.The
 * DeviceListResult stream provides a list of each paired Bluetooth device
 * identifying which of the profiles of the devices are connected and which
 * are all the supported profiles and which device is the outgoing
 * source device. The connected devices are sorted with the outgoing source
 * device first. If an outgoing source device does not exist the devices are
 * sorted in order of the most recently to least recently connected device.
 * The not connected devices are sorted in order of the most recently to
 * least recently connected device.The NumPairedDevices provides the
 * number of paired devices such that the parsing of the DeviceListResult is
 * simplified.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DeviceListExtendedRelUpReg;

/**
 * The get message of the property "VisibleDevices"
 * VisibleDevices property provides a list of visible devices found during the Inquiry scan procedure initiated via ScanBluetoothDevices MethodStart.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VisibleDevicesGet;

/**
 * The upreg message of the property "VisibleDevices"
 * VisibleDevices property provides a list of visible devices found during the Inquiry scan procedure initiated via ScanBluetoothDevices MethodStart.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VisibleDevicesUpReg;

/**
 * The relUpReg message of the property "VisibleDevices"
 * VisibleDevices property provides a list of visible devices found during the Inquiry scan procedure initiated via ScanBluetoothDevices MethodStart.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VisibleDevicesRelUpReg;

/**
 * The get message of the property "PairableMode"
 * This property informs to the client whether the Bluetooth module is in discoverable and ready to be paired.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PairableModeGet;

/**
 * The upreg message of the property "PairableMode"
 * This property informs to the client whether the Bluetooth module is in discoverable and ready to be paired.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PairableModeUpReg;

/**
 * The relUpReg message of the property "PairableMode"
 * This property informs to the client whether the Bluetooth module is in discoverable and ready to be paired.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PairableModeRelUpReg;

/**
 * The get message of the property "SignalStrength"
 * This property is used to indicate the signal strength for connected devices to the registered clients.
 * The property returns a list of connected device handles and the corresponding signal strengths.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SignalStrengthGet;

/**
 * The upreg message of the property "SignalStrength"
 * This property is used to indicate the signal strength for connected devices to the registered clients.
 * The property returns a list of connected device handles and the corresponding signal strengths.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SignalStrengthUpReg;

/**
 * The relUpReg message of the property "SignalStrength"
 * This property is used to indicate the signal strength for connected devices to the registered clients.
 * The property returns a list of connected device handles and the corresponding signal strengths.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SignalStrengthRelUpReg;

/**
 * The get message of the property "SPPServiceConnection"
 * This property will contain the RFComm device name.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SPPServiceConnectionGet;

/**
 * The upreg message of the property "SPPServiceConnection"
 * This property will contain the RFComm device name.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SPPServiceConnectionUpReg;

/**
 * The relUpReg message of the property "SPPServiceConnection"
 * This property will contain the RFComm device name.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SPPServiceConnectionRelUpReg;

/**
 * The get message of the property "BluetoothLimitationMode"
 * <p>This property provides a list of limitation/restriction settings w.r.t. Bluetooth behaviour which are currently handled by BluetoothSettings (BM application).</p>
 * <p>Normally there is only one entry in the list with same Bluetooth device address. But it can happen there are multiple entries with same Bluetooth device address. In this case the other parameters technology or communication channel have to be checked to find the matching entry.</p>
 * <p>Therefore following rule can be applied: Each list entry is identified by a tuple of Bluetooth device address, technology and communication channel.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage BluetoothLimitationModeGet;

/**
 * The upreg message of the property "BluetoothLimitationMode"
 * <p>This property provides a list of limitation/restriction settings w.r.t. Bluetooth behaviour which are currently handled by BluetoothSettings (BM application).</p>
 * <p>Normally there is only one entry in the list with same Bluetooth device address. But it can happen there are multiple entries with same Bluetooth device address. In this case the other parameters technology or communication channel have to be checked to find the matching entry.</p>
 * <p>Therefore following rule can be applied: Each list entry is identified by a tuple of Bluetooth device address, technology and communication channel.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage BluetoothLimitationModeUpReg;

/**
 * The relUpReg message of the property "BluetoothLimitationMode"
 * <p>This property provides a list of limitation/restriction settings w.r.t. Bluetooth behaviour which are currently handled by BluetoothSettings (BM application).</p>
 * <p>Normally there is only one entry in the list with same Bluetooth device address. But it can happen there are multiple entries with same Bluetooth device address. In this case the other parameters technology or communication channel have to be checked to find the matching entry.</p>
 * <p>Therefore following rule can be applied: Each list entry is identified by a tuple of Bluetooth device address, technology and communication channel.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage BluetoothLimitationModeRelUpReg;

/**
 * The get message of the property "MultiHFPSupport"
 * This property is used to indicate the Status of MultiHFPSupport to the registered clients.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MultiHFPSupportGet;

/**
 * The upreg message of the property "MultiHFPSupport"
 * This property is used to indicate the Status of MultiHFPSupport to the registered clients.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MultiHFPSupportUpReg;

/**
 * The relUpReg message of the property "MultiHFPSupport"
 * This property is used to indicate the Status of MultiHFPSupport to the registered clients.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MultiHFPSupportRelUpReg;

/**
 * The get message of the property "BTProfilesUsageInfo"
 * This property is used to update the usage of various BT profiles to registered clients.
 * If the BT profiles are only connected but not in use, this list will be empty.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage BTProfilesUsageInfoGet;

/**
 * The upreg message of the property "BTProfilesUsageInfo"
 * This property is used to update the usage of various BT profiles to registered clients.
 * If the BT profiles are only connected but not in use, this list will be empty.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage BTProfilesUsageInfoUpReg;

/**
 * The relUpReg message of the property "BTProfilesUsageInfo"
 * This property is used to update the usage of various BT profiles to registered clients.
 * If the BT profiles are only connected but not in use, this list will be empty.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage BTProfilesUsageInfoRelUpReg;

/**
 * The get message of the property "ConflictsDetected"
 * This property is used to update the update the conflicts which arise during a conflict trigger.
 * Client has to resolve the conflicts and inform using interface ResolveConflicts().
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ConflictsDetectedGet;

/**
 * The upreg message of the property "ConflictsDetected"
 * This property is used to update the update the conflicts which arise during a conflict trigger.
 * Client has to resolve the conflicts and inform using interface ResolveConflicts().
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ConflictsDetectedUpReg;

/**
 * The relUpReg message of the property "ConflictsDetected"
 * This property is used to update the update the conflicts which arise during a conflict trigger.
 * Client has to resolve the conflicts and inform using interface ResolveConflicts().
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ConflictsDetectedRelUpReg;

/**
 * The get message of the property "AutoConnectionStatus"
 * This property is used to update the status of the auto connection.
 * DeviceHandle is vaild only if e8AutoConnectionStatus is IN_PROGRESS
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AutoConnectionStatusGet;

/**
 * The upreg message of the property "AutoConnectionStatus"
 * This property is used to update the status of the auto connection.
 * DeviceHandle is vaild only if e8AutoConnectionStatus is IN_PROGRESS
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AutoConnectionStatusUpReg;

/**
 * The relUpReg message of the property "AutoConnectionStatus"
 * This property is used to update the status of the auto connection.
 * DeviceHandle is vaild only if e8AutoConnectionStatus is IN_PROGRESS
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AutoConnectionStatusRelUpReg;

/**
 * The get message of the property "ServiceAvailable"
 * This property is used to update the service availability of BMApp based on the BT SPM State.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ServiceAvailableGet;

/**
 * The upreg message of the property "ServiceAvailable"
 * This property is used to update the service availability of BMApp based on the BT SPM State.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ServiceAvailableUpReg;

/**
 * The relUpReg message of the property "ServiceAvailable"
 * This property is used to update the service availability of BMApp based on the BT SPM State.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ServiceAvailableRelUpReg;

/**
 * The get message of the property "VehicleConfiguration"
 * This contains information regarding the vehicle configuration.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VehicleConfigurationGet;

/**
 * The upreg message of the property "VehicleConfiguration"
 * This contains information regarding the vehicle configuration.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VehicleConfigurationUpReg;

/**
 * The relUpReg message of the property "VehicleConfiguration"
 * This contains information regarding the vehicle configuration.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VehicleConfigurationRelUpReg;

/**
 * The abort error message of the method "GetDeviceInfoExtended"
 * Retrieves specific information about the device such as its Bluetooth address and supported features and profiles.  This function is defined as a Method instead of a Property because HMI controllers are expected to provide the device handle for a specific device when querying for this information.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetDeviceInfoExtendedAbortError;

/**
 * The start message of the method "StopRingtone"
 * Stops the ringtone that is currently being played.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StopRingtoneStart;

/**
 * The abort error message of the method "StopRingtone"
 * Stops the ringtone that is currently being played.
 */
typedef ::asf::cca::CcaTypes::DefaultError StopRingtoneAbortError;

/**
 * The abort error message of the method "ScanBluetoothDevices"
 * Start or Stop Inquiry Scanning for Bluetooth Devices.
 */
typedef ::asf::cca::CcaTypes::DefaultError ScanBluetoothDevicesAbortError;

/**
 * The abort error message of the method "ConnectBluetoothProfile"
 * Provides profile based connection for the paired device.
 */
typedef ::asf::cca::CcaTypes::DefaultError ConnectBluetoothProfileAbortError;

/**
 * The abort error message of the method "DisconnectBluetoothProfile"
 * Provides profile based disconnection for the connected device.
 */
typedef ::asf::cca::CcaTypes::DefaultError DisconnectBluetoothProfileAbortError;

/**
 * The abort error message of the method "SendPairingRequest"
 * Start or Cancel Pairing Request to a particular remote device
 */
typedef ::asf::cca::CcaTypes::DefaultError SendPairingRequestAbortError;

/**
 * The abort error message of the method "SwitchBTLocalMode"
 * This is a method to change property BtLocalMode. Each mode (pairable, connectable, discoverable) can be switched ON or OFF separately.
 * If no change should be done for a mode that parameter should be set to AUTO.
 * It is not sufficient to look at the response to this method, check the PairableMode property.
 */
typedef ::asf::cca::CcaTypes::DefaultError SwitchBTLocalModeAbortError;

/**
 * The abort error message of the method "StartAutoConnectSequence"
 * This is a method to start/stop AutoConnect strategy based on user request.
 * If any device is currently connected , it shall be disconnected and AutoConnect strategy shall be started.
 * Device Connection is notified via the DeviceList/DeviceListExtended property.
 */
typedef ::asf::cca::CcaTypes::DefaultError StartAutoConnectSequenceAbortError;

/**
 * The abort error message of the method "ConnectSPPService"
 * This is a method to get a RFComm for a device when requested.For this to happen, the device for which the RFComm is requested should be in connected state and
 * should have a valid device handle.
 */
typedef ::asf::cca::CcaTypes::DefaultError ConnectSPPServiceAbortError;

/**
 * The abort error message of the method "SetBluetoothLimitationMode"
 * This method shall be used to change a limitation/restriction setting w.r.t. Bluetooth behaviour.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetBluetoothLimitationModeAbortError;

/**
 * The abort error message of the method "SwitchBluetoothOnOffExtended"
 * This function is Extended method of SwitchBluetoothOnOff which has an additional parameter bSuppressAutoConnection
 */
typedef ::asf::cca::CcaTypes::DefaultError SwitchBluetoothOnOffExtendedAbortError;

/**
 * The abort error message of the method "ChangeWifiTransmitPower"
 * This method is used to change the transmission power of Wi-Fi chip. It is possible to attenuate the Wi-Fi RF power.
 * The range depends on modulation and Wi-Fi chip calibration settings. Rough rule of thumb for maximum range would be 10dB range with 11b modulation.
 * Other modulations have smaller ranges. If the requested operation on power adjustment is success then method result will report SUCCESS, otherwise ERROR.
 */
typedef ::asf::cca::CcaTypes::DefaultError ChangeWifiTransmitPowerAbortError;

/**
 * The abort error message of the method "DisconnectSPPService"
 * This is a method to disconnect a SPP connection of a device when requested.For this to happen, the device for which the Disconnection is requested should have a valid SPP connection and RFCommID.
 */
typedef ::asf::cca::CcaTypes::DefaultError DisconnectSPPServiceAbortError;

/**
 * The abort error message of the method "StartSearchSPPServices"
 * This API is used to retrieve the services on the specified device. This method can be used to get the SPP capabilities. As a result of this SPPServiceConnectionStatus Property will be updated only if there are changes in the property.
 */
typedef ::asf::cca::CcaTypes::DefaultError StartSearchSPPServicesAbortError;

/**
 * The abort error message of the method "StopSearchSPPServices"
 * This API is used to stop the service search for the specific device with valid SearchHandle.
 */
typedef ::asf::cca::CcaTypes::DefaultError StopSearchSPPServicesAbortError;

/**
 * The abort error message of the method "AddOobPairedDevice"
 * This API is used to support out-of-band (OOB) pairing.
 */
typedef ::asf::cca::CcaTypes::DefaultError AddOobPairedDeviceAbortError;

/**
 * The abort error message of the method "SetFavorite"
 * This API is used to set favorite index to each device or to the profiles(HFP and AVP) supported by a device. The favorite index is an unambiguous positive integer representing the favorite's ranking
 * (favorite index - 0 means no favorite, favorite index == 1 represents the most favorite, etc.,). If a user wants to set favorite index for a device or profile which is as same as that of an another device or profile,
 * the favorite index for the previous device or profile will be cleared and the favorite index will be set for the requested device or profile. And also if a user wants to clear an already set favorite device or profile
 * then call set favorite method for corresponding device or profile with favorite index(zero) so that favorite value for the requested device is cleared as like clearFavorite method.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetFavoriteAbortError;

/**
 * The abort error message of the method "ClearFavorite"
 * To clear an already set favorite device or profile then user has to call this API for corresponding device or profile so that favorite index for the requested device is cleared.
 */
typedef ::asf::cca::CcaTypes::DefaultError ClearFavoriteAbortError;

/**
 * The abort error message of the method "SwitchMultiHFPSupport"
 * This API is used to allow Switch On or Off Multiple HFP Support. Switching status will be updated in the property - MultiHFPSupport.
 * The default value of MultiHFPSupport should be switched On or Off in the initial start up can be configured project specific. For subsequent startups
 * the value will be stored persistently. If switchMultiHFPSupport(OFF) is called then during switching off more than one HFP profile is connected
 * then the secondary/slave HFP profile(s) will be disconnected internally or In case that HMI has to implement project-specific priority order then
 * HMI has to called disconnect the specific HFP profile(s) before the "SwitchMultiHFPSupport(OFF)" is being called.
 */
typedef ::asf::cca::CcaTypes::DefaultError SwitchMultiHFPSupportAbortError;

/**
 * The abort error message of the method "SetPrimary"
 * This API is used to set the device as Primary. If a user wants to set the primary for a device which is as same as
 * that of an another device, the primary status for the previous device will be cleared and the primary will be set for the requested device.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetPrimaryAbortError;

/**
 * The abort error message of the method "SetBTProfilesUsage"
 * This API is used by the clients to update usage of different BT profiles when used for specific or generic purpose.
 * Client can update multiple BT profiles usage for multiple BT devices using this interface.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetBTProfilesUsageAbortError;

/**
 * The abort error message of the method "ResolveConflicts"
 * This API is used by the clients to resolve the conflicts. Resolution can be based on user decision or default project configuration.
 * Client has to respond with this interface whenever conflicts are updated via ConflictsDetected () property. When client responds with
 * ResolutionType RESOLUTION_TYPE_PROCEED, server will resolve the conflicts (if not yet resolved) with default action. Therefore clients should resolve the
 * conflicts before responding with ResolutionType RESOLUTION_TYPE_PROCEED. And also If client does not respond within specified timeout period (project
 * configuration) then server will resolve the conflicts (if not yet resolved) with default action.
 */
typedef ::asf::cca::CcaTypes::DefaultError ResolveConflictsAbortError;

/**
 * The abort error message of the method "SetDeviceUsagePreference"
 * This API is used by the clients to set the usage preference for the device. Usage preference will be updated in the property - DeviceListExtended.
 * During autoconnection, the Connection will be trigged for the device based on the usage preference.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetDeviceUsagePreferenceAbortError;

/**
 * The abort error message of the method "SetProfileUserAvailability"
 * This API is used by the clients to set the user availability for the profile.
 * During autoconnection, the Connection will be trigged once the user available for the profiles(HFP/AVP).
 */
typedef ::asf::cca::CcaTypes::DefaultError SetProfileUserAvailabilityAbortError;

/**
 * The abort error message of the method "ReplaceBluetoothLimitationMode"
 * This method shall be used to replace any current limitation/restriction setting w.r.t. Bluetooth behaviour
 * with a new limitation/restriction. This will end the current limitation/restriction which is already applied.
 */
typedef ::asf::cca::CcaTypes::DefaultError ReplaceBluetoothLimitationModeAbortError;


/**
 * The status message of the property "BluetoothOnOff"
 * Activate/De-activate Bluetooth
 */
class BluetoothOnOffStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BluetoothOnOffStatus ();

    /**
     * Copy constructor
     */
    inline  BluetoothOnOffStatus (const BluetoothOnOffStatus &rhs);

    /**
     * All fields constructor
     */
    inline  BluetoothOnOffStatus (bool bBTOnOff_);

    /**
     * Destructor
     */
    inline virtual  ~BluetoothOnOffStatus();

    /**
     * Assignment operator
     */
    inline BluetoothOnOffStatus& operator = (const BluetoothOnOffStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BluetoothOnOffStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BluetoothOnOffStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BluetoothOnOffStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BluetoothOnOffStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bBTOnOff"

    static const int kBBTOnOff = 0;

    /**
     * Clears the field "bBTOnOff".
     *
     * The field will be set to its default value. The hasBBTOnOff()
     * method will return false.
     */
    inline void clearBBTOnOff();

    /**
     * Checks whether the field "bBTOnOff" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBBTOnOff()). Otherwise it will return false.
     */
    inline bool hasBBTOnOff () const;

    /**
     * Returns the value of the member "bBTOnOff".
     *
     * Bluetooth ON or OFF
     *
     * @return The value of the field "bBTOnOff"
     */
    inline bool getBBTOnOff () const;

    /**
     * Sets the value of the member "bBTOnOff".
     *
     * Bluetooth ON or OFF
     *
     * @param bBTOnOff The value which will be set
     */
    inline void setBBTOnOff (bool bBTOnOff_);

    static const BluetoothOnOffStatus &getDefaultInstance();

private:

    inline void set_has_bBTOnOff ();

    inline void clear_has_bBTOnOff ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bBTOnOff;

};

/**
 * The set message of the property "BluetoothOnOff"
 * Activate/De-activate Bluetooth
 */
class BluetoothOnOffSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BluetoothOnOffSet ();

    /**
     * Copy constructor
     */
    inline  BluetoothOnOffSet (const BluetoothOnOffSet &rhs);

    /**
     * All fields constructor
     */
    inline  BluetoothOnOffSet (bool bBTOnOff_);

    /**
     * Destructor
     */
    inline virtual  ~BluetoothOnOffSet();

    /**
     * Assignment operator
     */
    inline BluetoothOnOffSet& operator = (const BluetoothOnOffSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BluetoothOnOffSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BluetoothOnOffSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BluetoothOnOffSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BluetoothOnOffSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bBTOnOff"

    static const int kBBTOnOff = 0;

    /**
     * Clears the field "bBTOnOff".
     *
     * The field will be set to its default value. The hasBBTOnOff()
     * method will return false.
     */
    inline void clearBBTOnOff();

    /**
     * Checks whether the field "bBTOnOff" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBBTOnOff()). Otherwise it will return false.
     */
    inline bool hasBBTOnOff () const;

    /**
     * Returns the value of the member "bBTOnOff".
     *
     * Bluetooth ON or OFF
     *
     * @return The value of the field "bBTOnOff"
     */
    inline bool getBBTOnOff () const;

    /**
     * Sets the value of the member "bBTOnOff".
     *
     * Bluetooth ON or OFF
     *
     * @param bBTOnOff The value which will be set
     */
    inline void setBBTOnOff (bool bBTOnOff_);

    static const BluetoothOnOffSet &getDefaultInstance();

private:

    inline void set_has_bBTOnOff ();

    inline void clear_has_bBTOnOff ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bBTOnOff;

};

/**
 * The error message of 'BluetoothOnOff'
 */
class BluetoothOnOffErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  BluetoothOnOffErrorStructure ();

    /**
     * Copy constructor
     */
    inline  BluetoothOnOffErrorStructure (const BluetoothOnOffErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  BluetoothOnOffErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~BluetoothOnOffErrorStructure();

    /**
     * Assignment operator
     */
    inline BluetoothOnOffErrorStructure& operator = (const BluetoothOnOffErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BluetoothOnOffErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BluetoothOnOffErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BluetoothOnOffErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BluetoothOnOffErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const BluetoothOnOffErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'BluetoothOnOff'
 */
class BluetoothOnOffError  : public ::asf::core::Payload {
public:

    enum BluetoothOnOffErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  BluetoothOnOffError ();

   /**
     * Copy constructor
     */
    inline  BluetoothOnOffError (const BluetoothOnOffError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~BluetoothOnOffError();

    /**
     * Assigns a new value to this object.
     */
    inline BluetoothOnOffError& operator = (const BluetoothOnOffError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BluetoothOnOffError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BluetoothOnOffError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BluetoothOnOffError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BluetoothOnOffError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline BluetoothOnOffError::BluetoothOnOffErrorField getField () const;

    inline void setField(BluetoothOnOffError::BluetoothOnOffErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "BluetoothOnOffErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "BluetoothOnOffErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const BluetoothOnOffErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline BluetoothOnOffErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline BluetoothOnOffErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (BluetoothOnOffErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "BluetoothOnOffErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const BluetoothOnOffErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const BluetoothOnOffError &getDefaultInstance();

private:

    inline void cloneData (const BluetoothOnOffError& rhs);

    inline void deleteData ();

    BluetoothOnOffErrorField __field;

    union {
        BluetoothOnOffErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "PairingStatus"
 * Identifies when the pairing process was completed successfully or informs the HMI when the pairing process was unsuccessful and for what reason. In addition, if notifies the HMI when the pairing process was canceled. If the pairing process was retried the pairing status provides notification of what type of retry was completed.  DeviceName only returned if PAIRING_STATUS_SUCCESSFUL
 */
class PairingStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PairingStatusStatus ();

    /**
     * Copy constructor
     */
    inline  PairingStatusStatus (const PairingStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  PairingStatusStatus (::most_BTSet_fi_types::T_e8_BTSetPairingStatusType e8PairingStatusType_, uint8 u8DeviceHandle_, const ::fi_basetypes_most::T_String& sDeviceName_);

    /**
     * Destructor
     */
    inline virtual  ~PairingStatusStatus();

    /**
     * Assignment operator
     */
    inline PairingStatusStatus& operator = (const PairingStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PairingStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PairingStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PairingStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PairingStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8PairingStatusType"

    static const int kE8PairingStatusType = 0;

    /**
     * Clears the field "e8PairingStatusType".
     *
     * The field will be set to its default value. The hasE8PairingStatusType()
     * method will return false.
     */
    inline void clearE8PairingStatusType();

    /**
     * Checks whether the field "e8PairingStatusType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PairingStatusType()). Otherwise it will return false.
     */
    inline bool hasE8PairingStatusType () const;

    /**
     * Returns the value of the member "e8PairingStatusType".
     *
     * Defines the possible pairing status types.
     *
     * @return The value of the field "e8PairingStatusType"
     */
    inline ::most_BTSet_fi_types::T_e8_BTSetPairingStatusType getE8PairingStatusType () const;

    /**
     * Sets the value of the member "e8PairingStatusType".
     *
     * Defines the possible pairing status types.
     *
     * @param e8PairingStatusType The value which will be set
     */
    inline void setE8PairingStatusType (::most_BTSet_fi_types::T_e8_BTSetPairingStatusType e8PairingStatusType_);

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 1;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "sDeviceName"

    static const int kSDeviceName = 2;

    /**
     * Clears the field "sDeviceName".
     *
     * The field will be set to its default value. The hasSDeviceName()
     * method will return false.
     */
    inline void clearSDeviceName();

    /**
     * Checks whether the field "sDeviceName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDeviceName()). Otherwise it will return false.
     */
    inline bool hasSDeviceName () const;

    /**
     * Returns the value of the member "sDeviceName".
     *
     * Name of the device (the Bluetooth friendly name).
     *
     * @return The value of the field "sDeviceName"
     */
    inline const ::fi_basetypes_most::T_String& getSDeviceName () const;

    /**
     * Retrieves the value of the field "sDeviceName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDeviceName".
     */
    inline ::fi_basetypes_most::T_String& getSDeviceNameMutable ();

    /**
     * Sets the value of the member "sDeviceName".
     *
     * Name of the device (the Bluetooth friendly name).
     *
     * @param sDeviceName The value which will be set
     */
    inline void setSDeviceName (const ::fi_basetypes_most::T_String& sDeviceName_);

    static const PairingStatusStatus &getDefaultInstance();

private:

    inline void set_has_e8PairingStatusType ();

    inline void clear_has_e8PairingStatusType ();

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_sDeviceName ();

    inline void clear_has_sDeviceName ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::most_BTSet_fi_types::T_e8_BTSetPairingStatusType _e8PairingStatusType;

    uint8 _u8DeviceHandle;

    ::fi_basetypes_most::T_String _sDeviceName;

};

/**
 * The error message of 'PairingStatus'
 */
class PairingStatusErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  PairingStatusErrorStructure ();

    /**
     * Copy constructor
     */
    inline  PairingStatusErrorStructure (const PairingStatusErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  PairingStatusErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~PairingStatusErrorStructure();

    /**
     * Assignment operator
     */
    inline PairingStatusErrorStructure& operator = (const PairingStatusErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PairingStatusErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PairingStatusErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PairingStatusErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PairingStatusErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const PairingStatusErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'PairingStatus'
 */
class PairingStatusError  : public ::asf::core::Payload {
public:

    enum PairingStatusErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  PairingStatusError ();

   /**
     * Copy constructor
     */
    inline  PairingStatusError (const PairingStatusError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~PairingStatusError();

    /**
     * Assigns a new value to this object.
     */
    inline PairingStatusError& operator = (const PairingStatusError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PairingStatusError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PairingStatusError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PairingStatusError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PairingStatusError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline PairingStatusError::PairingStatusErrorField getField () const;

    inline void setField(PairingStatusError::PairingStatusErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "PairingStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "PairingStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const PairingStatusErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline PairingStatusErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline PairingStatusErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (PairingStatusErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "PairingStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const PairingStatusErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const PairingStatusError &getDefaultInstance();

private:

    inline void cloneData (const PairingStatusError& rhs);

    inline void deleteData ();

    PairingStatusErrorField __field;

    union {
        PairingStatusErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "ChangeRingtone"
 * Changes the active ringtone for the respective device to the selected ringtone.  This function is defined as a settable Property instead of a Method so that all HMI controllers can receive notifications that a ringtone for a device has been changed.  Note that the Get operation is not defined because the Status can only be generated in response to the Set optype on a particular device.
 */
class ChangeRingtoneStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ChangeRingtoneStatus ();

    /**
     * Copy constructor
     */
    inline  ChangeRingtoneStatus (const ChangeRingtoneStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ChangeRingtoneStatus (uint8 u8DeviceHandle_, uint16 u16RingtoneID_, const ::fi_basetypes_most::T_String& sRingtoneName_);

    /**
     * Destructor
     */
    inline virtual  ~ChangeRingtoneStatus();

    /**
     * Assignment operator
     */
    inline ChangeRingtoneStatus& operator = (const ChangeRingtoneStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChangeRingtoneStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChangeRingtoneStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChangeRingtoneStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChangeRingtoneStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "u16RingtoneID"

    static const int kU16RingtoneID = 1;

    /**
     * Clears the field "u16RingtoneID".
     *
     * The field will be set to its default value. The hasU16RingtoneID()
     * method will return false.
     */
    inline void clearU16RingtoneID();

    /**
     * Checks whether the field "u16RingtoneID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16RingtoneID()). Otherwise it will return false.
     */
    inline bool hasU16RingtoneID () const;

    /**
     * Returns the value of the member "u16RingtoneID".
     *
     * The unique ID for each ringtone available.
     *
     * @return The value of the field "u16RingtoneID"
     */
    inline uint16 getU16RingtoneID () const;

    /**
     * Sets the value of the member "u16RingtoneID".
     *
     * The unique ID for each ringtone available.
     *
     * @param u16RingtoneID The value which will be set
     */
    inline void setU16RingtoneID (uint16 u16RingtoneID_);

    // API of field "sRingtoneName"

    static const int kSRingtoneName = 2;

    /**
     * Clears the field "sRingtoneName".
     *
     * The field will be set to its default value. The hasSRingtoneName()
     * method will return false.
     */
    inline void clearSRingtoneName();

    /**
     * Checks whether the field "sRingtoneName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSRingtoneName()). Otherwise it will return false.
     */
    inline bool hasSRingtoneName () const;

    /**
     * Returns the value of the member "sRingtoneName".
     *
     * The text of the name associated with each ringtone available.
     *
     * @return The value of the field "sRingtoneName"
     */
    inline const ::fi_basetypes_most::T_String& getSRingtoneName () const;

    /**
     * Retrieves the value of the field "sRingtoneName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sRingtoneName".
     */
    inline ::fi_basetypes_most::T_String& getSRingtoneNameMutable ();

    /**
     * Sets the value of the member "sRingtoneName".
     *
     * The text of the name associated with each ringtone available.
     *
     * @param sRingtoneName The value which will be set
     */
    inline void setSRingtoneName (const ::fi_basetypes_most::T_String& sRingtoneName_);

    static const ChangeRingtoneStatus &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_u16RingtoneID ();

    inline void clear_has_u16RingtoneID ();

    inline void set_has_sRingtoneName ();

    inline void clear_has_sRingtoneName ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _u8DeviceHandle;

    uint16 _u16RingtoneID;

    ::fi_basetypes_most::T_String _sRingtoneName;

};

/**
 * The pureSet message of the property "ChangeRingtone"
 * Changes the active ringtone for the respective device to the selected ringtone.  This function is defined as a settable Property instead of a Method so that all HMI controllers can receive notifications that a ringtone for a device has been changed.  Note that the Get operation is not defined because the Status can only be generated in response to the Set optype on a particular device.
 */
class ChangeRingtonePureSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ChangeRingtonePureSet ();

    /**
     * Copy constructor
     */
    inline  ChangeRingtonePureSet (const ChangeRingtonePureSet &rhs);

    /**
     * All fields constructor
     */
    inline  ChangeRingtonePureSet (uint8 u8DeviceHandle_, uint16 u16RingtoneID_);

    /**
     * Destructor
     */
    inline virtual  ~ChangeRingtonePureSet();

    /**
     * Assignment operator
     */
    inline ChangeRingtonePureSet& operator = (const ChangeRingtonePureSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChangeRingtonePureSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChangeRingtonePureSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChangeRingtonePureSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChangeRingtonePureSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "u16RingtoneID"

    static const int kU16RingtoneID = 1;

    /**
     * Clears the field "u16RingtoneID".
     *
     * The field will be set to its default value. The hasU16RingtoneID()
     * method will return false.
     */
    inline void clearU16RingtoneID();

    /**
     * Checks whether the field "u16RingtoneID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16RingtoneID()). Otherwise it will return false.
     */
    inline bool hasU16RingtoneID () const;

    /**
     * Returns the value of the member "u16RingtoneID".
     *
     * The unique ID for each ringtone available.
     *
     * @return The value of the field "u16RingtoneID"
     */
    inline uint16 getU16RingtoneID () const;

    /**
     * Sets the value of the member "u16RingtoneID".
     *
     * The unique ID for each ringtone available.
     *
     * @param u16RingtoneID The value which will be set
     */
    inline void setU16RingtoneID (uint16 u16RingtoneID_);

    static const ChangeRingtonePureSet &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_u16RingtoneID ();

    inline void clear_has_u16RingtoneID ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8DeviceHandle;

    uint16 _u16RingtoneID;

};

/**
 * The error message of 'ChangeRingtone'
 */
class ChangeRingtoneErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  ChangeRingtoneErrorStructure ();

    /**
     * Copy constructor
     */
    inline  ChangeRingtoneErrorStructure (const ChangeRingtoneErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  ChangeRingtoneErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~ChangeRingtoneErrorStructure();

    /**
     * Assignment operator
     */
    inline ChangeRingtoneErrorStructure& operator = (const ChangeRingtoneErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChangeRingtoneErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChangeRingtoneErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChangeRingtoneErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChangeRingtoneErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const ChangeRingtoneErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'ChangeRingtone'
 */
class ChangeRingtoneError  : public ::asf::core::Payload {
public:

    enum ChangeRingtoneErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  ChangeRingtoneError ();

   /**
     * Copy constructor
     */
    inline  ChangeRingtoneError (const ChangeRingtoneError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~ChangeRingtoneError();

    /**
     * Assigns a new value to this object.
     */
    inline ChangeRingtoneError& operator = (const ChangeRingtoneError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChangeRingtoneError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChangeRingtoneError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChangeRingtoneError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChangeRingtoneError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline ChangeRingtoneError::ChangeRingtoneErrorField getField () const;

    inline void setField(ChangeRingtoneError::ChangeRingtoneErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "ChangeRingtoneErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "ChangeRingtoneErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ChangeRingtoneErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ChangeRingtoneErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline ChangeRingtoneErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (ChangeRingtoneErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "ChangeRingtoneErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const ChangeRingtoneErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const ChangeRingtoneError &getDefaultInstance();

private:

    inline void cloneData (const ChangeRingtoneError& rhs);

    inline void deleteData ();

    ChangeRingtoneErrorField __field;

    union {
        ChangeRingtoneErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "VehicleBTFriendlyName"
 * This is the VehicleBTFriendlyName.
 */
class VehicleBTFriendlyNameStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VehicleBTFriendlyNameStatus ();

    /**
     * Copy constructor
     */
    inline  VehicleBTFriendlyNameStatus (const VehicleBTFriendlyNameStatus &rhs);

    /**
     * All fields constructor
     */
    inline  VehicleBTFriendlyNameStatus (const ::fi_basetypes_most::T_String& sVehicleBTFriendlyName_);

    /**
     * Destructor
     */
    inline virtual  ~VehicleBTFriendlyNameStatus();

    /**
     * Assignment operator
     */
    inline VehicleBTFriendlyNameStatus& operator = (const VehicleBTFriendlyNameStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VehicleBTFriendlyNameStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VehicleBTFriendlyNameStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VehicleBTFriendlyNameStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VehicleBTFriendlyNameStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sVehicleBTFriendlyName"

    static const int kSVehicleBTFriendlyName = 0;

    /**
     * Clears the field "sVehicleBTFriendlyName".
     *
     * The field will be set to its default value. The hasSVehicleBTFriendlyName()
     * method will return false.
     */
    inline void clearSVehicleBTFriendlyName();

    /**
     * Checks whether the field "sVehicleBTFriendlyName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSVehicleBTFriendlyName()). Otherwise it will return false.
     */
    inline bool hasSVehicleBTFriendlyName () const;

    /**
     * Returns the value of the member "sVehicleBTFriendlyName".
     *
     * The Bluetooth friendly name of the vehicle.
     *
     * @return The value of the field "sVehicleBTFriendlyName"
     */
    inline const ::fi_basetypes_most::T_String& getSVehicleBTFriendlyName () const;

    /**
     * Retrieves the value of the field "sVehicleBTFriendlyName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sVehicleBTFriendlyName".
     */
    inline ::fi_basetypes_most::T_String& getSVehicleBTFriendlyNameMutable ();

    /**
     * Sets the value of the member "sVehicleBTFriendlyName".
     *
     * The Bluetooth friendly name of the vehicle.
     *
     * @param sVehicleBTFriendlyName The value which will be set
     */
    inline void setSVehicleBTFriendlyName (const ::fi_basetypes_most::T_String& sVehicleBTFriendlyName_);

    static const VehicleBTFriendlyNameStatus &getDefaultInstance();

private:

    inline void set_has_sVehicleBTFriendlyName ();

    inline void clear_has_sVehicleBTFriendlyName ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::fi_basetypes_most::T_String _sVehicleBTFriendlyName;

};

/**
 * The error message of 'VehicleBTFriendlyName'
 */
class VehicleBTFriendlyNameErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  VehicleBTFriendlyNameErrorStructure ();

    /**
     * Copy constructor
     */
    inline  VehicleBTFriendlyNameErrorStructure (const VehicleBTFriendlyNameErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  VehicleBTFriendlyNameErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~VehicleBTFriendlyNameErrorStructure();

    /**
     * Assignment operator
     */
    inline VehicleBTFriendlyNameErrorStructure& operator = (const VehicleBTFriendlyNameErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VehicleBTFriendlyNameErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VehicleBTFriendlyNameErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VehicleBTFriendlyNameErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VehicleBTFriendlyNameErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const VehicleBTFriendlyNameErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'VehicleBTFriendlyName'
 */
class VehicleBTFriendlyNameError  : public ::asf::core::Payload {
public:

    enum VehicleBTFriendlyNameErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  VehicleBTFriendlyNameError ();

   /**
     * Copy constructor
     */
    inline  VehicleBTFriendlyNameError (const VehicleBTFriendlyNameError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~VehicleBTFriendlyNameError();

    /**
     * Assigns a new value to this object.
     */
    inline VehicleBTFriendlyNameError& operator = (const VehicleBTFriendlyNameError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VehicleBTFriendlyNameError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VehicleBTFriendlyNameError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VehicleBTFriendlyNameError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VehicleBTFriendlyNameError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline VehicleBTFriendlyNameError::VehicleBTFriendlyNameErrorField getField () const;

    inline void setField(VehicleBTFriendlyNameError::VehicleBTFriendlyNameErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "VehicleBTFriendlyNameErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "VehicleBTFriendlyNameErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const VehicleBTFriendlyNameErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline VehicleBTFriendlyNameErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline VehicleBTFriendlyNameErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (VehicleBTFriendlyNameErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "VehicleBTFriendlyNameErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const VehicleBTFriendlyNameErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const VehicleBTFriendlyNameError &getDefaultInstance();

private:

    inline void cloneData (const VehicleBTFriendlyNameError& rhs);

    inline void deleteData ();

    VehicleBTFriendlyNameErrorField __field;

    union {
        VehicleBTFriendlyNameErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "BluetoothAudioSource"
 * Identifies the Bluetooth source device and provides the HMI with the supported transport control and features of the device such that the appropriate screen can be displayed.
 */
class BluetoothAudioSourceStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BluetoothAudioSourceStatus ();

    /**
     * Copy constructor
     */
    inline  BluetoothAudioSourceStatus (const BluetoothAudioSourceStatus &rhs);

    /**
     * All fields constructor
     */
    inline  BluetoothAudioSourceStatus (uint8 u8DeviceHandle_, const ::most_BTSet_fi_types::T_BTSetDeviceControlSupport& oDeviceControlSupport_);

    /**
     * Destructor
     */
    inline virtual  ~BluetoothAudioSourceStatus();

    /**
     * Assignment operator
     */
    inline BluetoothAudioSourceStatus& operator = (const BluetoothAudioSourceStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BluetoothAudioSourceStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BluetoothAudioSourceStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BluetoothAudioSourceStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BluetoothAudioSourceStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "oDeviceControlSupport"

    static const int kODeviceControlSupport = 1;

    /**
     * Clears the field "oDeviceControlSupport".
     *
     * The field will be set to its default value. The hasODeviceControlSupport()
     * method will return false.
     */
    inline void clearODeviceControlSupport();

    /**
     * Checks whether the field "oDeviceControlSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setODeviceControlSupport()). Otherwise it will return false.
     */
    inline bool hasODeviceControlSupport () const;

    /**
     * Returns the value of the member "oDeviceControlSupport".
     *
     * Identifies the supported transport controls and features of the device.
     *
     * @return The value of the field "oDeviceControlSupport"
     */
    inline const ::most_BTSet_fi_types::T_BTSetDeviceControlSupport& getODeviceControlSupport () const;

    /**
     * Retrieves the value of the field "oDeviceControlSupport" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oDeviceControlSupport".
     */
    inline ::most_BTSet_fi_types::T_BTSetDeviceControlSupport& getODeviceControlSupportMutable ();

    /**
     * Sets the value of the member "oDeviceControlSupport".
     *
     * Identifies the supported transport controls and features of the device.
     *
     * @param oDeviceControlSupport The value which will be set
     */
    inline void setODeviceControlSupport (const ::most_BTSet_fi_types::T_BTSetDeviceControlSupport& oDeviceControlSupport_);

    static const BluetoothAudioSourceStatus &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_oDeviceControlSupport ();

    inline void clear_has_oDeviceControlSupport ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8DeviceHandle;

    ::most_BTSet_fi_types::T_BTSetDeviceControlSupport _oDeviceControlSupport;

};

/**
 * The pureSet message of the property "BluetoothAudioSource"
 * Identifies the Bluetooth source device and provides the HMI with the supported transport control and features of the device such that the appropriate screen can be displayed.
 */
class BluetoothAudioSourcePureSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BluetoothAudioSourcePureSet ();

    /**
     * Copy constructor
     */
    inline  BluetoothAudioSourcePureSet (const BluetoothAudioSourcePureSet &rhs);

    /**
     * All fields constructor
     */
    inline  BluetoothAudioSourcePureSet (uint8 u8DeviceHandle_);

    /**
     * Destructor
     */
    inline virtual  ~BluetoothAudioSourcePureSet();

    /**
     * Assignment operator
     */
    inline BluetoothAudioSourcePureSet& operator = (const BluetoothAudioSourcePureSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BluetoothAudioSourcePureSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BluetoothAudioSourcePureSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BluetoothAudioSourcePureSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BluetoothAudioSourcePureSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    static const BluetoothAudioSourcePureSet &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8DeviceHandle;

};

/**
 * The status message of the property "PairingPin"
 * Used to acquire the pairing PIN for the current pairing process.
 */
class PairingPinStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PairingPinStatus ();

    /**
     * Copy constructor
     */
    inline  PairingPinStatus (const PairingPinStatus &rhs);

    /**
     * All fields constructor
     */
    inline  PairingPinStatus (const ::fi_basetypes_most::T_String& sPinNumber_);

    /**
     * Destructor
     */
    inline virtual  ~PairingPinStatus();

    /**
     * Assignment operator
     */
    inline PairingPinStatus& operator = (const PairingPinStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PairingPinStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PairingPinStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PairingPinStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PairingPinStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sPinNumber"

    static const int kSPinNumber = 0;

    /**
     * Clears the field "sPinNumber".
     *
     * The field will be set to its default value. The hasSPinNumber()
     * method will return false.
     */
    inline void clearSPinNumber();

    /**
     * Checks whether the field "sPinNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPinNumber()). Otherwise it will return false.
     */
    inline bool hasSPinNumber () const;

    /**
     * Returns the value of the member "sPinNumber".
     *
     * The PIN number to be used for the current pairing process.
     *
     * @return The value of the field "sPinNumber"
     */
    inline const ::fi_basetypes_most::T_String& getSPinNumber () const;

    /**
     * Retrieves the value of the field "sPinNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sPinNumber".
     */
    inline ::fi_basetypes_most::T_String& getSPinNumberMutable ();

    /**
     * Sets the value of the member "sPinNumber".
     *
     * The PIN number to be used for the current pairing process.
     *
     * @param sPinNumber The value which will be set
     */
    inline void setSPinNumber (const ::fi_basetypes_most::T_String& sPinNumber_);

    static const PairingPinStatus &getDefaultInstance();

private:

    inline void set_has_sPinNumber ();

    inline void clear_has_sPinNumber ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::fi_basetypes_most::T_String _sPinNumber;

};

/**
 * The status message of the property "MaxDevicesPaired"
 * Notification that informs the HMI controller that the maximum number of
 * Bluetooth devices (10) have been paired. It provides the DeviceHandle and
 * DeviceName of the device which has not been connected for the longest time
 * (i.e. least recent DateTimeStamp).Notification shall be sent when
 * the 10th Bluetooth device is paired or when the device which has not been
 * connected for the longest time changes.
 */
class MaxDevicesPairedStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MaxDevicesPairedStatus ();

    /**
     * Copy constructor
     */
    inline  MaxDevicesPairedStatus (const MaxDevicesPairedStatus &rhs);

    /**
     * All fields constructor
     */
    inline  MaxDevicesPairedStatus (uint8 u8DeviceHandle_, const ::fi_basetypes_most::T_String& sDeviceName_);

    /**
     * Destructor
     */
    inline virtual  ~MaxDevicesPairedStatus();

    /**
     * Assignment operator
     */
    inline MaxDevicesPairedStatus& operator = (const MaxDevicesPairedStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MaxDevicesPairedStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MaxDevicesPairedStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MaxDevicesPairedStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MaxDevicesPairedStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "sDeviceName"

    static const int kSDeviceName = 1;

    /**
     * Clears the field "sDeviceName".
     *
     * The field will be set to its default value. The hasSDeviceName()
     * method will return false.
     */
    inline void clearSDeviceName();

    /**
     * Checks whether the field "sDeviceName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDeviceName()). Otherwise it will return false.
     */
    inline bool hasSDeviceName () const;

    /**
     * Returns the value of the member "sDeviceName".
     *
     * Name of the device (the Bluetooth friendly name).
     *
     * @return The value of the field "sDeviceName"
     */
    inline const ::fi_basetypes_most::T_String& getSDeviceName () const;

    /**
     * Retrieves the value of the field "sDeviceName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDeviceName".
     */
    inline ::fi_basetypes_most::T_String& getSDeviceNameMutable ();

    /**
     * Sets the value of the member "sDeviceName".
     *
     * Name of the device (the Bluetooth friendly name).
     *
     * @param sDeviceName The value which will be set
     */
    inline void setSDeviceName (const ::fi_basetypes_most::T_String& sDeviceName_);

    static const MaxDevicesPairedStatus &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_sDeviceName ();

    inline void clear_has_sDeviceName ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8DeviceHandle;

    ::fi_basetypes_most::T_String _sDeviceName;

};

/**
 * The error message of 'MaxDevicesPaired'
 */
class MaxDevicesPairedErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  MaxDevicesPairedErrorStructure ();

    /**
     * Copy constructor
     */
    inline  MaxDevicesPairedErrorStructure (const MaxDevicesPairedErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  MaxDevicesPairedErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~MaxDevicesPairedErrorStructure();

    /**
     * Assignment operator
     */
    inline MaxDevicesPairedErrorStructure& operator = (const MaxDevicesPairedErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MaxDevicesPairedErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MaxDevicesPairedErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MaxDevicesPairedErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MaxDevicesPairedErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     *
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     *
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const MaxDevicesPairedErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'MaxDevicesPaired'
 */
class MaxDevicesPairedError  : public ::asf::core::Payload {
public:

    enum MaxDevicesPairedErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  MaxDevicesPairedError ();

   /**
     * Copy constructor
     */
    inline  MaxDevicesPairedError (const MaxDevicesPairedError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~MaxDevicesPairedError();

    /**
     * Assigns a new value to this object.
     */
    inline MaxDevicesPairedError& operator = (const MaxDevicesPairedError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MaxDevicesPairedError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MaxDevicesPairedError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MaxDevicesPairedError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MaxDevicesPairedError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline MaxDevicesPairedError::MaxDevicesPairedErrorField getField () const;

    inline void setField(MaxDevicesPairedError::MaxDevicesPairedErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "MaxDevicesPairedErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "MaxDevicesPairedErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const MaxDevicesPairedErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline MaxDevicesPairedErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline MaxDevicesPairedErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (MaxDevicesPairedErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "MaxDevicesPairedErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const MaxDevicesPairedErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const MaxDevicesPairedError &getDefaultInstance();

private:

    inline void cloneData (const MaxDevicesPairedError& rhs);

    inline void deleteData ();

    MaxDevicesPairedErrorField __field;

    union {
        MaxDevicesPairedErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "AddNewDevice"
 * Function initiates the pairing process from the vehicle. The PairingType
 * result leads to the correct pairing information being displayed by the HMI.
 */
class AddNewDeviceStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AddNewDeviceStart ();

    /**
     * Copy constructor
     */
    inline  AddNewDeviceStart (const AddNewDeviceStart &rhs);

    /**
     * All fields constructor
     */
    inline  AddNewDeviceStart (bool bDummyFlag_);

    /**
     * Destructor
     */
    inline virtual  ~AddNewDeviceStart();

    /**
     * Assignment operator
     */
    inline AddNewDeviceStart& operator = (const AddNewDeviceStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddNewDeviceStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddNewDeviceStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddNewDeviceStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddNewDeviceStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bDummyFlag"

    static const int kBDummyFlag = 0;

    /**
     * Clears the field "bDummyFlag".
     *
     * The field will be set to its default value. The hasBDummyFlag()
     * method will return false.
     */
    inline void clearBDummyFlag();

    /**
     * Checks whether the field "bDummyFlag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDummyFlag()). Otherwise it will return false.
     */
    inline bool hasBDummyFlag () const;

    /**
     * Returns the value of the member "bDummyFlag".
     *
     * DummyFlag used to satisfy SequenceMethod requirement for a single parameter in the StartAck or StartResultAck.   This value shall always be set to False.
     *
     * @return The value of the field "bDummyFlag"
     */
    inline bool getBDummyFlag () const;

    /**
     * Sets the value of the member "bDummyFlag".
     *
     * DummyFlag used to satisfy SequenceMethod requirement for a single parameter in the StartAck or StartResultAck.   This value shall always be set to False.
     *
     * @param bDummyFlag The value which will be set
     */
    inline void setBDummyFlag (bool bDummyFlag_);

    static const AddNewDeviceStart &getDefaultInstance();

private:

    inline void set_has_bDummyFlag ();

    inline void clear_has_bDummyFlag ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bDummyFlag;

};

/**
 * The result message of the method "AddNewDevice"
 * Function initiates the pairing process from the vehicle. The PairingType
 * result leads to the correct pairing information being displayed by the HMI.
 */
class AddNewDeviceResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AddNewDeviceResult ();

    /**
     * Copy constructor
     */
    inline  AddNewDeviceResult (const AddNewDeviceResult &rhs);

    /**
     * All fields constructor
     */
    inline  AddNewDeviceResult (::most_BTSet_fi_types::T_e8_BTSetPairingType e8PairingType_, const ::fi_basetypes_most::T_String& sDeviceName_, const ::fi_basetypes_most::T_String& sPinNumber_);

    /**
     * Destructor
     */
    inline virtual  ~AddNewDeviceResult();

    /**
     * Assignment operator
     */
    inline AddNewDeviceResult& operator = (const AddNewDeviceResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddNewDeviceResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddNewDeviceResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddNewDeviceResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddNewDeviceResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8PairingType"

    static const int kE8PairingType = 0;

    /**
     * Clears the field "e8PairingType".
     *
     * The field will be set to its default value. The hasE8PairingType()
     * method will return false.
     */
    inline void clearE8PairingType();

    /**
     * Checks whether the field "e8PairingType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PairingType()). Otherwise it will return false.
     */
    inline bool hasE8PairingType () const;

    /**
     * Returns the value of the member "e8PairingType".
     *
     * Indentifies the pairing type: Legacy or Secure Simple Pairing (Numeric Comparison or Just Works)
     *
     * @return The value of the field "e8PairingType"
     */
    inline ::most_BTSet_fi_types::T_e8_BTSetPairingType getE8PairingType () const;

    /**
     * Sets the value of the member "e8PairingType".
     *
     * Indentifies the pairing type: Legacy or Secure Simple Pairing (Numeric Comparison or Just Works)
     *
     * @param e8PairingType The value which will be set
     */
    inline void setE8PairingType (::most_BTSet_fi_types::T_e8_BTSetPairingType e8PairingType_);

    // API of field "sDeviceName"

    static const int kSDeviceName = 1;

    /**
     * Clears the field "sDeviceName".
     *
     * The field will be set to its default value. The hasSDeviceName()
     * method will return false.
     */
    inline void clearSDeviceName();

    /**
     * Checks whether the field "sDeviceName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDeviceName()). Otherwise it will return false.
     */
    inline bool hasSDeviceName () const;

    /**
     * Returns the value of the member "sDeviceName".
     *
     * Name of the device (the Bluetooth friendly name).
     *
     * @return The value of the field "sDeviceName"
     */
    inline const ::fi_basetypes_most::T_String& getSDeviceName () const;

    /**
     * Retrieves the value of the field "sDeviceName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDeviceName".
     */
    inline ::fi_basetypes_most::T_String& getSDeviceNameMutable ();

    /**
     * Sets the value of the member "sDeviceName".
     *
     * Name of the device (the Bluetooth friendly name).
     *
     * @param sDeviceName The value which will be set
     */
    inline void setSDeviceName (const ::fi_basetypes_most::T_String& sDeviceName_);

    // API of field "sPinNumber"

    static const int kSPinNumber = 2;

    /**
     * Clears the field "sPinNumber".
     *
     * The field will be set to its default value. The hasSPinNumber()
     * method will return false.
     */
    inline void clearSPinNumber();

    /**
     * Checks whether the field "sPinNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPinNumber()). Otherwise it will return false.
     */
    inline bool hasSPinNumber () const;

    /**
     * Returns the value of the member "sPinNumber".
     *
     * The PIN number to be used for the current pairing process.
     *
     * @return The value of the field "sPinNumber"
     */
    inline const ::fi_basetypes_most::T_String& getSPinNumber () const;

    /**
     * Retrieves the value of the field "sPinNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sPinNumber".
     */
    inline ::fi_basetypes_most::T_String& getSPinNumberMutable ();

    /**
     * Sets the value of the member "sPinNumber".
     *
     * The PIN number to be used for the current pairing process.
     *
     * @param sPinNumber The value which will be set
     */
    inline void setSPinNumber (const ::fi_basetypes_most::T_String& sPinNumber_);

    static const AddNewDeviceResult &getDefaultInstance();

private:

    inline void set_has_e8PairingType ();

    inline void clear_has_e8PairingType ();

    inline void set_has_sDeviceName ();

    inline void clear_has_sDeviceName ();

    inline void set_has_sPinNumber ();

    inline void clear_has_sPinNumber ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::most_BTSet_fi_types::T_e8_BTSetPairingType _e8PairingType;

    ::fi_basetypes_most::T_String _sDeviceName;

    ::fi_basetypes_most::T_String _sPinNumber;

};

/**
 * The error message of 'AddNewDevice'
 */
class AddNewDeviceErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  AddNewDeviceErrorStructure ();

    /**
     * Copy constructor
     */
    inline  AddNewDeviceErrorStructure (const AddNewDeviceErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  AddNewDeviceErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~AddNewDeviceErrorStructure();

    /**
     * Assignment operator
     */
    inline AddNewDeviceErrorStructure& operator = (const AddNewDeviceErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddNewDeviceErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddNewDeviceErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddNewDeviceErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddNewDeviceErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const AddNewDeviceErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'AddNewDevice'
 */
class AddNewDeviceError  : public ::asf::core::Payload {
public:

    enum AddNewDeviceErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  AddNewDeviceError ();

   /**
     * Copy constructor
     */
    inline  AddNewDeviceError (const AddNewDeviceError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~AddNewDeviceError();

    /**
     * Assigns a new value to this object.
     */
    inline AddNewDeviceError& operator = (const AddNewDeviceError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddNewDeviceError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddNewDeviceError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddNewDeviceError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddNewDeviceError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline AddNewDeviceError::AddNewDeviceErrorField getField () const;

    inline void setField(AddNewDeviceError::AddNewDeviceErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "AddNewDeviceErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "AddNewDeviceErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const AddNewDeviceErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline AddNewDeviceErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline AddNewDeviceErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (AddNewDeviceErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "AddNewDeviceErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const AddNewDeviceErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const AddNewDeviceError &getDefaultInstance();

private:

    inline void cloneData (const AddNewDeviceError& rhs);

    inline void deleteData ();

    AddNewDeviceErrorField __field;

    union {
        AddNewDeviceErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "PairingResponse"
 * Identifies the user response to a pairing request (i.e. for Secure Simple Pairing Numeric Comparison) and when the pairing process has been cancelled or retried by the user.
 */
class PairingResponseStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PairingResponseStart ();

    /**
     * Copy constructor
     */
    inline  PairingResponseStart (const PairingResponseStart &rhs);

    /**
     * All fields constructor
     */
    inline  PairingResponseStart (::most_BTSet_fi_types::T_e8_BTSetPairingResponseType e8PairingResponseType_);

    /**
     * Destructor
     */
    inline virtual  ~PairingResponseStart();

    /**
     * Assignment operator
     */
    inline PairingResponseStart& operator = (const PairingResponseStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PairingResponseStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PairingResponseStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PairingResponseStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PairingResponseStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8PairingResponseType"

    static const int kE8PairingResponseType = 0;

    /**
     * Clears the field "e8PairingResponseType".
     *
     * The field will be set to its default value. The hasE8PairingResponseType()
     * method will return false.
     */
    inline void clearE8PairingResponseType();

    /**
     * Checks whether the field "e8PairingResponseType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PairingResponseType()). Otherwise it will return false.
     */
    inline bool hasE8PairingResponseType () const;

    /**
     * Returns the value of the member "e8PairingResponseType".
     *
     * Defines the possible pairing response types.
     *
     * @return The value of the field "e8PairingResponseType"
     */
    inline ::most_BTSet_fi_types::T_e8_BTSetPairingResponseType getE8PairingResponseType () const;

    /**
     * Sets the value of the member "e8PairingResponseType".
     *
     * Defines the possible pairing response types.
     *
     * @param e8PairingResponseType The value which will be set
     */
    inline void setE8PairingResponseType (::most_BTSet_fi_types::T_e8_BTSetPairingResponseType e8PairingResponseType_);

    static const PairingResponseStart &getDefaultInstance();

private:

    inline void set_has_e8PairingResponseType ();

    inline void clear_has_e8PairingResponseType ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_BTSet_fi_types::T_e8_BTSetPairingResponseType _e8PairingResponseType;

};

/**
 * The result message of the method "PairingResponse"
 * Identifies the user response to a pairing request (i.e. for Secure Simple Pairing Numeric Comparison) and when the pairing process has been cancelled or retried by the user.
 */
class PairingResponseResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PairingResponseResult ();

    /**
     * Copy constructor
     */
    inline  PairingResponseResult (const PairingResponseResult &rhs);

    /**
     * All fields constructor
     */
    inline  PairingResponseResult (::most_BTSet_fi_types::T_e8_BTSetPairingStatusType e8PairingStatusType_);

    /**
     * Destructor
     */
    inline virtual  ~PairingResponseResult();

    /**
     * Assignment operator
     */
    inline PairingResponseResult& operator = (const PairingResponseResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PairingResponseResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PairingResponseResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PairingResponseResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PairingResponseResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8PairingStatusType"

    static const int kE8PairingStatusType = 0;

    /**
     * Clears the field "e8PairingStatusType".
     *
     * The field will be set to its default value. The hasE8PairingStatusType()
     * method will return false.
     */
    inline void clearE8PairingStatusType();

    /**
     * Checks whether the field "e8PairingStatusType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PairingStatusType()). Otherwise it will return false.
     */
    inline bool hasE8PairingStatusType () const;

    /**
     * Returns the value of the member "e8PairingStatusType".
     *
     * Defines the possible pairing status types.
     *
     * @return The value of the field "e8PairingStatusType"
     */
    inline ::most_BTSet_fi_types::T_e8_BTSetPairingStatusType getE8PairingStatusType () const;

    /**
     * Sets the value of the member "e8PairingStatusType".
     *
     * Defines the possible pairing status types.
     *
     * @param e8PairingStatusType The value which will be set
     */
    inline void setE8PairingStatusType (::most_BTSet_fi_types::T_e8_BTSetPairingStatusType e8PairingStatusType_);

    static const PairingResponseResult &getDefaultInstance();

private:

    inline void set_has_e8PairingStatusType ();

    inline void clear_has_e8PairingStatusType ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_BTSet_fi_types::T_e8_BTSetPairingStatusType _e8PairingStatusType;

};

/**
 * The error message of 'PairingResponse'
 */
class PairingResponseErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  PairingResponseErrorStructure ();

    /**
     * Copy constructor
     */
    inline  PairingResponseErrorStructure (const PairingResponseErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  PairingResponseErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~PairingResponseErrorStructure();

    /**
     * Assignment operator
     */
    inline PairingResponseErrorStructure& operator = (const PairingResponseErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PairingResponseErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PairingResponseErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PairingResponseErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PairingResponseErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const PairingResponseErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'PairingResponse'
 */
class PairingResponseError  : public ::asf::core::Payload {
public:

    enum PairingResponseErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  PairingResponseError ();

   /**
     * Copy constructor
     */
    inline  PairingResponseError (const PairingResponseError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~PairingResponseError();

    /**
     * Assigns a new value to this object.
     */
    inline PairingResponseError& operator = (const PairingResponseError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PairingResponseError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PairingResponseError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PairingResponseError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PairingResponseError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline PairingResponseError::PairingResponseErrorField getField () const;

    inline void setField(PairingResponseError::PairingResponseErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "PairingResponseErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "PairingResponseErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const PairingResponseErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline PairingResponseErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline PairingResponseErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (PairingResponseErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "PairingResponseErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const PairingResponseErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const PairingResponseError &getDefaultInstance();

private:

    inline void cloneData (const PairingResponseError& rhs);

    inline void deleteData ();

    PairingResponseErrorField __field;

    union {
        PairingResponseErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "ChangePin"
 * Changes the current pin to one set by the user. Used in order to pair with devices that support Legacy pairing and have a fixed PIN and no interface for entering a PIN. Possible errors that may be encountered include: ERR_BS_INCORRECT_PIN_FORMAT
 */
class ChangePinStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ChangePinStart ();

    /**
     * Copy constructor
     */
    inline  ChangePinStart (const ChangePinStart &rhs);

    /**
     * All fields constructor
     */
    inline  ChangePinStart (const ::fi_basetypes_most::T_String& sPinNumber_);

    /**
     * Destructor
     */
    inline virtual  ~ChangePinStart();

    /**
     * Assignment operator
     */
    inline ChangePinStart& operator = (const ChangePinStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChangePinStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChangePinStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChangePinStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChangePinStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sPinNumber"

    static const int kSPinNumber = 0;

    /**
     * Clears the field "sPinNumber".
     *
     * The field will be set to its default value. The hasSPinNumber()
     * method will return false.
     */
    inline void clearSPinNumber();

    /**
     * Checks whether the field "sPinNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPinNumber()). Otherwise it will return false.
     */
    inline bool hasSPinNumber () const;

    /**
     * Returns the value of the member "sPinNumber".
     *
     * The PIN number to be used for the current pairing process.
     *
     * @return The value of the field "sPinNumber"
     */
    inline const ::fi_basetypes_most::T_String& getSPinNumber () const;

    /**
     * Retrieves the value of the field "sPinNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sPinNumber".
     */
    inline ::fi_basetypes_most::T_String& getSPinNumberMutable ();

    /**
     * Sets the value of the member "sPinNumber".
     *
     * The PIN number to be used for the current pairing process.
     *
     * @param sPinNumber The value which will be set
     */
    inline void setSPinNumber (const ::fi_basetypes_most::T_String& sPinNumber_);

    static const ChangePinStart &getDefaultInstance();

private:

    inline void set_has_sPinNumber ();

    inline void clear_has_sPinNumber ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::fi_basetypes_most::T_String _sPinNumber;

};

/**
 * The result message of the method "ChangePin"
 * Changes the current pin to one set by the user. Used in order to pair with devices that support Legacy pairing and have a fixed PIN and no interface for entering a PIN. Possible errors that may be encountered include: ERR_BS_INCORRECT_PIN_FORMAT
 */
class ChangePinResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ChangePinResult ();

    /**
     * Copy constructor
     */
    inline  ChangePinResult (const ChangePinResult &rhs);

    /**
     * All fields constructor
     */
    inline  ChangePinResult (::most_BTSet_fi_types::T_e8_BTSetPairingType e8PairingType_, const ::fi_basetypes_most::T_String& sDeviceName_, const ::fi_basetypes_most::T_String& sPinNumber_);

    /**
     * Destructor
     */
    inline virtual  ~ChangePinResult();

    /**
     * Assignment operator
     */
    inline ChangePinResult& operator = (const ChangePinResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChangePinResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChangePinResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChangePinResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChangePinResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8PairingType"

    static const int kE8PairingType = 0;

    /**
     * Clears the field "e8PairingType".
     *
     * The field will be set to its default value. The hasE8PairingType()
     * method will return false.
     */
    inline void clearE8PairingType();

    /**
     * Checks whether the field "e8PairingType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PairingType()). Otherwise it will return false.
     */
    inline bool hasE8PairingType () const;

    /**
     * Returns the value of the member "e8PairingType".
     *
     * Indentifies the pairing type: Legacy or Secure Simple Pairing (Numeric Comparison or Just Works)
     *
     * @return The value of the field "e8PairingType"
     */
    inline ::most_BTSet_fi_types::T_e8_BTSetPairingType getE8PairingType () const;

    /**
     * Sets the value of the member "e8PairingType".
     *
     * Indentifies the pairing type: Legacy or Secure Simple Pairing (Numeric Comparison or Just Works)
     *
     * @param e8PairingType The value which will be set
     */
    inline void setE8PairingType (::most_BTSet_fi_types::T_e8_BTSetPairingType e8PairingType_);

    // API of field "sDeviceName"

    static const int kSDeviceName = 1;

    /**
     * Clears the field "sDeviceName".
     *
     * The field will be set to its default value. The hasSDeviceName()
     * method will return false.
     */
    inline void clearSDeviceName();

    /**
     * Checks whether the field "sDeviceName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDeviceName()). Otherwise it will return false.
     */
    inline bool hasSDeviceName () const;

    /**
     * Returns the value of the member "sDeviceName".
     *
     * Name of the device (the Bluetooth friendly name).
     *
     * @return The value of the field "sDeviceName"
     */
    inline const ::fi_basetypes_most::T_String& getSDeviceName () const;

    /**
     * Retrieves the value of the field "sDeviceName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDeviceName".
     */
    inline ::fi_basetypes_most::T_String& getSDeviceNameMutable ();

    /**
     * Sets the value of the member "sDeviceName".
     *
     * Name of the device (the Bluetooth friendly name).
     *
     * @param sDeviceName The value which will be set
     */
    inline void setSDeviceName (const ::fi_basetypes_most::T_String& sDeviceName_);

    // API of field "sPinNumber"

    static const int kSPinNumber = 2;

    /**
     * Clears the field "sPinNumber".
     *
     * The field will be set to its default value. The hasSPinNumber()
     * method will return false.
     */
    inline void clearSPinNumber();

    /**
     * Checks whether the field "sPinNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPinNumber()). Otherwise it will return false.
     */
    inline bool hasSPinNumber () const;

    /**
     * Returns the value of the member "sPinNumber".
     *
     * The PIN number to be used for the current pairing process.
     *
     * @return The value of the field "sPinNumber"
     */
    inline const ::fi_basetypes_most::T_String& getSPinNumber () const;

    /**
     * Retrieves the value of the field "sPinNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sPinNumber".
     */
    inline ::fi_basetypes_most::T_String& getSPinNumberMutable ();

    /**
     * Sets the value of the member "sPinNumber".
     *
     * The PIN number to be used for the current pairing process.
     *
     * @param sPinNumber The value which will be set
     */
    inline void setSPinNumber (const ::fi_basetypes_most::T_String& sPinNumber_);

    static const ChangePinResult &getDefaultInstance();

private:

    inline void set_has_e8PairingType ();

    inline void clear_has_e8PairingType ();

    inline void set_has_sDeviceName ();

    inline void clear_has_sDeviceName ();

    inline void set_has_sPinNumber ();

    inline void clear_has_sPinNumber ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::most_BTSet_fi_types::T_e8_BTSetPairingType _e8PairingType;

    ::fi_basetypes_most::T_String _sDeviceName;

    ::fi_basetypes_most::T_String _sPinNumber;

};

/**
 * The error message of 'ChangePin'
 */
class ChangePinErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  ChangePinErrorStructure ();

    /**
     * Copy constructor
     */
    inline  ChangePinErrorStructure (const ChangePinErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  ChangePinErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~ChangePinErrorStructure();

    /**
     * Assignment operator
     */
    inline ChangePinErrorStructure& operator = (const ChangePinErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChangePinErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChangePinErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChangePinErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChangePinErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const ChangePinErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'ChangePin'
 */
class ChangePinError  : public ::asf::core::Payload {
public:

    enum ChangePinErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  ChangePinError ();

   /**
     * Copy constructor
     */
    inline  ChangePinError (const ChangePinError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~ChangePinError();

    /**
     * Assigns a new value to this object.
     */
    inline ChangePinError& operator = (const ChangePinError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChangePinError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChangePinError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChangePinError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChangePinError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline ChangePinError::ChangePinErrorField getField () const;

    inline void setField(ChangePinError::ChangePinErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "ChangePinErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "ChangePinErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ChangePinErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ChangePinErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline ChangePinErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (ChangePinErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "ChangePinErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const ChangePinErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const ChangePinError &getDefaultInstance();

private:

    inline void cloneData (const ChangePinError& rhs);

    inline void deleteData ();

    ChangePinErrorField __field;

    union {
        ChangePinErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "ChangeDeviceState"
 * Identifies the action that the user has initiated that will change the
 * device list: Select, Disconnect, Delete, and Delete AllThe result
 * of this method will be the ConnectionResult(which identifies if the
 * requested device was connected or not) and the ReplaceDeviceRequired
 * result which indicates whether the HMI will need to provide the user with
 * a&#160;pop-up that will request the user to select which device to replace.If
 * the action is select, there are 3 options that could take place: change in
 * &#160;the outgoing source device, connect selected device, or a replace pop-up
 * that allows the user to select which device they want to replace (if this
 * &#160;is true, then the ReplaceDevice result of the ChangeDeviceState will be
 * &#160;true).If the action is disconnect, the device with the&#160;
 * DeviceHandle sent will be connected.If the action is delete, the
 * device with the DeviceHandle sent will be deleted. If the action is delete
 * all, all the devices shall be deleted and the DeviceHandle is not
 * &#160;required. talk about if action is select three options OSD, connect or
 * pop-up talk about all actions.
 */
class ChangeDeviceStateStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ChangeDeviceStateStart ();

    /**
     * Copy constructor
     */
    inline  ChangeDeviceStateStart (const ChangeDeviceStateStart &rhs);

    /**
     * All fields constructor
     */
    inline  ChangeDeviceStateStart (::most_BTSet_fi_types::T_e8_BTSetChangeDeviceStateAction e8ChangeDeviceStateAction_, uint8 u8DeviceHandle_);

    /**
     * Destructor
     */
    inline virtual  ~ChangeDeviceStateStart();

    /**
     * Assignment operator
     */
    inline ChangeDeviceStateStart& operator = (const ChangeDeviceStateStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChangeDeviceStateStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChangeDeviceStateStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChangeDeviceStateStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChangeDeviceStateStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ChangeDeviceStateAction"

    static const int kE8ChangeDeviceStateAction = 0;

    /**
     * Clears the field "e8ChangeDeviceStateAction".
     *
     * The field will be set to its default value. The hasE8ChangeDeviceStateAction()
     * method will return false.
     */
    inline void clearE8ChangeDeviceStateAction();

    /**
     * Checks whether the field "e8ChangeDeviceStateAction" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ChangeDeviceStateAction()). Otherwise it will return false.
     */
    inline bool hasE8ChangeDeviceStateAction () const;

    /**
     * Returns the value of the member "e8ChangeDeviceStateAction".
     *
     * Provides the action selected by the user to be executed on the device list.
     *
     * @return The value of the field "e8ChangeDeviceStateAction"
     */
    inline ::most_BTSet_fi_types::T_e8_BTSetChangeDeviceStateAction getE8ChangeDeviceStateAction () const;

    /**
     * Sets the value of the member "e8ChangeDeviceStateAction".
     *
     * Provides the action selected by the user to be executed on the device list.
     *
     * @param e8ChangeDeviceStateAction The value which will be set
     */
    inline void setE8ChangeDeviceStateAction (::most_BTSet_fi_types::T_e8_BTSetChangeDeviceStateAction e8ChangeDeviceStateAction_);

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 1;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    static const ChangeDeviceStateStart &getDefaultInstance();

private:

    inline void set_has_e8ChangeDeviceStateAction ();

    inline void clear_has_e8ChangeDeviceStateAction ();

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::most_BTSet_fi_types::T_e8_BTSetChangeDeviceStateAction _e8ChangeDeviceStateAction;

    uint8 _u8DeviceHandle;

};

/**
 * The result message of the method "ChangeDeviceState"
 * Identifies the action that the user has initiated that will change the
 * device list: Select, Disconnect, Delete, and Delete AllThe result
 * of this method will be the ConnectionResult(which identifies if the
 * requested device was connected or not) and the ReplaceDeviceRequired
 * result which indicates whether the HMI will need to provide the user with
 * a&#160;pop-up that will request the user to select which device to replace.If
 * the action is select, there are 3 options that could take place: change in
 * &#160;the outgoing source device, connect selected device, or a replace pop-up
 * that allows the user to select which device they want to replace (if this
 * &#160;is true, then the ReplaceDevice result of the ChangeDeviceState will be
 * &#160;true).If the action is disconnect, the device with the&#160;
 * DeviceHandle sent will be connected.If the action is delete, the
 * device with the DeviceHandle sent will be deleted. If the action is delete
 * all, all the devices shall be deleted and the DeviceHandle is not
 * &#160;required. talk about if action is select three options OSD, connect or
 * pop-up talk about all actions.
 */
class ChangeDeviceStateResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ChangeDeviceStateResult ();

    /**
     * Copy constructor
     */
    inline  ChangeDeviceStateResult (const ChangeDeviceStateResult &rhs);

    /**
     * All fields constructor
     */
    inline  ChangeDeviceStateResult (bool bReplaceDeviceRequired_, ::most_BTSet_fi_types::T_e8_BTSetConnectionResult e8ConnectionResult_);

    /**
     * Destructor
     */
    inline virtual  ~ChangeDeviceStateResult();

    /**
     * Assignment operator
     */
    inline ChangeDeviceStateResult& operator = (const ChangeDeviceStateResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChangeDeviceStateResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChangeDeviceStateResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChangeDeviceStateResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChangeDeviceStateResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bReplaceDeviceRequired"

    static const int kBReplaceDeviceRequired = 0;

    /**
     * Clears the field "bReplaceDeviceRequired".
     *
     * The field will be set to its default value. The hasBReplaceDeviceRequired()
     * method will return false.
     */
    inline void clearBReplaceDeviceRequired();

    /**
     * Checks whether the field "bReplaceDeviceRequired" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBReplaceDeviceRequired()). Otherwise it will return false.
     */
    inline bool hasBReplaceDeviceRequired () const;

    /**
     * Returns the value of the member "bReplaceDeviceRequired".
     *
     * Identifies if the replace device pop-up (for the user to select which device they want to replace) is required.
     *
     * @return The value of the field "bReplaceDeviceRequired"
     */
    inline bool getBReplaceDeviceRequired () const;

    /**
     * Sets the value of the member "bReplaceDeviceRequired".
     *
     * Identifies if the replace device pop-up (for the user to select which device they want to replace) is required.
     *
     * @param bReplaceDeviceRequired The value which will be set
     */
    inline void setBReplaceDeviceRequired (bool bReplaceDeviceRequired_);

    // API of field "e8ConnectionResult"

    static const int kE8ConnectionResult = 1;

    /**
     * Clears the field "e8ConnectionResult".
     *
     * The field will be set to its default value. The hasE8ConnectionResult()
     * method will return false.
     */
    inline void clearE8ConnectionResult();

    /**
     * Checks whether the field "e8ConnectionResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ConnectionResult()). Otherwise it will return false.
     */
    inline bool hasE8ConnectionResult () const;

    /**
     * Returns the value of the member "e8ConnectionResult".
     *
     * Identifies if the requested device was connected/disconnected or not.
     *
     * @return The value of the field "e8ConnectionResult"
     */
    inline ::most_BTSet_fi_types::T_e8_BTSetConnectionResult getE8ConnectionResult () const;

    /**
     * Sets the value of the member "e8ConnectionResult".
     *
     * Identifies if the requested device was connected/disconnected or not.
     *
     * @param e8ConnectionResult The value which will be set
     */
    inline void setE8ConnectionResult (::most_BTSet_fi_types::T_e8_BTSetConnectionResult e8ConnectionResult_);

    static const ChangeDeviceStateResult &getDefaultInstance();

private:

    inline void set_has_bReplaceDeviceRequired ();

    inline void clear_has_bReplaceDeviceRequired ();

    inline void set_has_e8ConnectionResult ();

    inline void clear_has_e8ConnectionResult ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bReplaceDeviceRequired;

    ::most_BTSet_fi_types::T_e8_BTSetConnectionResult _e8ConnectionResult;

};

/**
 * The error message of 'ChangeDeviceState'
 */
class ChangeDeviceStateErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  ChangeDeviceStateErrorStructure ();

    /**
     * Copy constructor
     */
    inline  ChangeDeviceStateErrorStructure (const ChangeDeviceStateErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  ChangeDeviceStateErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~ChangeDeviceStateErrorStructure();

    /**
     * Assignment operator
     */
    inline ChangeDeviceStateErrorStructure& operator = (const ChangeDeviceStateErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChangeDeviceStateErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChangeDeviceStateErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChangeDeviceStateErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChangeDeviceStateErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const ChangeDeviceStateErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'ChangeDeviceState'
 */
class ChangeDeviceStateError  : public ::asf::core::Payload {
public:

    enum ChangeDeviceStateErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  ChangeDeviceStateError ();

   /**
     * Copy constructor
     */
    inline  ChangeDeviceStateError (const ChangeDeviceStateError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~ChangeDeviceStateError();

    /**
     * Assigns a new value to this object.
     */
    inline ChangeDeviceStateError& operator = (const ChangeDeviceStateError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChangeDeviceStateError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChangeDeviceStateError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChangeDeviceStateError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChangeDeviceStateError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline ChangeDeviceStateError::ChangeDeviceStateErrorField getField () const;

    inline void setField(ChangeDeviceStateError::ChangeDeviceStateErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "ChangeDeviceStateErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "ChangeDeviceStateErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ChangeDeviceStateErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ChangeDeviceStateErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline ChangeDeviceStateErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (ChangeDeviceStateErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "ChangeDeviceStateErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const ChangeDeviceStateErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const ChangeDeviceStateError &getDefaultInstance();

private:

    inline void cloneData (const ChangeDeviceStateError& rhs);

    inline void deleteData ();

    ChangeDeviceStateErrorField __field;

    union {
        ChangeDeviceStateErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "ReplaceDevice"
 * Replaces a currently connected device with another device based on user
 * selection. The currently connected device is disconnected and the selected
 * device is connected.The handle of the device to be connected and
 * disconnected are provided.The result is the ConnectionResult which
 * identifies if the requested device was connected or not.
 */
class ReplaceDeviceStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReplaceDeviceStart ();

    /**
     * Copy constructor
     */
    inline  ReplaceDeviceStart (const ReplaceDeviceStart &rhs);

    /**
     * All fields constructor
     */
    inline  ReplaceDeviceStart (uint8 u8ConnectDeviceHandle_, uint8 u8DisconnectDeviceHandle_);

    /**
     * Destructor
     */
    inline virtual  ~ReplaceDeviceStart();

    /**
     * Assignment operator
     */
    inline ReplaceDeviceStart& operator = (const ReplaceDeviceStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReplaceDeviceStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReplaceDeviceStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReplaceDeviceStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReplaceDeviceStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8ConnectDeviceHandle"

    static const int kU8ConnectDeviceHandle = 0;

    /**
     * Clears the field "u8ConnectDeviceHandle".
     *
     * The field will be set to its default value. The hasU8ConnectDeviceHandle()
     * method will return false.
     */
    inline void clearU8ConnectDeviceHandle();

    /**
     * Checks whether the field "u8ConnectDeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8ConnectDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8ConnectDeviceHandle () const;

    /**
     * Returns the value of the member "u8ConnectDeviceHandle".
     *
     * The handle of the device to be connected.
     *
     * @return The value of the field "u8ConnectDeviceHandle"
     */
    inline uint8 getU8ConnectDeviceHandle () const;

    /**
     * Sets the value of the member "u8ConnectDeviceHandle".
     *
     * The handle of the device to be connected.
     *
     * @param u8ConnectDeviceHandle The value which will be set
     */
    inline void setU8ConnectDeviceHandle (uint8 u8ConnectDeviceHandle_);

    // API of field "u8DisconnectDeviceHandle"

    static const int kU8DisconnectDeviceHandle = 1;

    /**
     * Clears the field "u8DisconnectDeviceHandle".
     *
     * The field will be set to its default value. The hasU8DisconnectDeviceHandle()
     * method will return false.
     */
    inline void clearU8DisconnectDeviceHandle();

    /**
     * Checks whether the field "u8DisconnectDeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DisconnectDeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DisconnectDeviceHandle () const;

    /**
     * Returns the value of the member "u8DisconnectDeviceHandle".
     *
     * The handle of the device to be disconnected.
     *
     * @return The value of the field "u8DisconnectDeviceHandle"
     */
    inline uint8 getU8DisconnectDeviceHandle () const;

    /**
     * Sets the value of the member "u8DisconnectDeviceHandle".
     *
     * The handle of the device to be disconnected.
     *
     * @param u8DisconnectDeviceHandle The value which will be set
     */
    inline void setU8DisconnectDeviceHandle (uint8 u8DisconnectDeviceHandle_);

    static const ReplaceDeviceStart &getDefaultInstance();

private:

    inline void set_has_u8ConnectDeviceHandle ();

    inline void clear_has_u8ConnectDeviceHandle ();

    inline void set_has_u8DisconnectDeviceHandle ();

    inline void clear_has_u8DisconnectDeviceHandle ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8ConnectDeviceHandle;

    uint8 _u8DisconnectDeviceHandle;

};

/**
 * The result message of the method "ReplaceDevice"
 * Replaces a currently connected device with another device based on user
 * selection. The currently connected device is disconnected and the selected
 * device is connected.The handle of the device to be connected and
 * disconnected are provided.The result is the ConnectionResult which
 * identifies if the requested device was connected or not.
 */
class ReplaceDeviceResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReplaceDeviceResult ();

    /**
     * Copy constructor
     */
    inline  ReplaceDeviceResult (const ReplaceDeviceResult &rhs);

    /**
     * All fields constructor
     */
    inline  ReplaceDeviceResult (::most_BTSet_fi_types::T_e8_BTSetConnectionResult e8ConnectionResult_);

    /**
     * Destructor
     */
    inline virtual  ~ReplaceDeviceResult();

    /**
     * Assignment operator
     */
    inline ReplaceDeviceResult& operator = (const ReplaceDeviceResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReplaceDeviceResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReplaceDeviceResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReplaceDeviceResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReplaceDeviceResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ConnectionResult"

    static const int kE8ConnectionResult = 0;

    /**
     * Clears the field "e8ConnectionResult".
     *
     * The field will be set to its default value. The hasE8ConnectionResult()
     * method will return false.
     */
    inline void clearE8ConnectionResult();

    /**
     * Checks whether the field "e8ConnectionResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ConnectionResult()). Otherwise it will return false.
     */
    inline bool hasE8ConnectionResult () const;

    /**
     * Returns the value of the member "e8ConnectionResult".
     *
     * Identifies if the requested device was connected/disconnected or not.
     *
     * @return The value of the field "e8ConnectionResult"
     */
    inline ::most_BTSet_fi_types::T_e8_BTSetConnectionResult getE8ConnectionResult () const;

    /**
     * Sets the value of the member "e8ConnectionResult".
     *
     * Identifies if the requested device was connected/disconnected or not.
     *
     * @param e8ConnectionResult The value which will be set
     */
    inline void setE8ConnectionResult (::most_BTSet_fi_types::T_e8_BTSetConnectionResult e8ConnectionResult_);

    static const ReplaceDeviceResult &getDefaultInstance();

private:

    inline void set_has_e8ConnectionResult ();

    inline void clear_has_e8ConnectionResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_BTSet_fi_types::T_e8_BTSetConnectionResult _e8ConnectionResult;

};

/**
 * The error message of 'ReplaceDevice'
 */
class ReplaceDeviceErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  ReplaceDeviceErrorStructure ();

    /**
     * Copy constructor
     */
    inline  ReplaceDeviceErrorStructure (const ReplaceDeviceErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  ReplaceDeviceErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~ReplaceDeviceErrorStructure();

    /**
     * Assignment operator
     */
    inline ReplaceDeviceErrorStructure& operator = (const ReplaceDeviceErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReplaceDeviceErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReplaceDeviceErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReplaceDeviceErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReplaceDeviceErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const ReplaceDeviceErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'ReplaceDevice'
 */
class ReplaceDeviceError  : public ::asf::core::Payload {
public:

    enum ReplaceDeviceErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  ReplaceDeviceError ();

   /**
     * Copy constructor
     */
    inline  ReplaceDeviceError (const ReplaceDeviceError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~ReplaceDeviceError();

    /**
     * Assigns a new value to this object.
     */
    inline ReplaceDeviceError& operator = (const ReplaceDeviceError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReplaceDeviceError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReplaceDeviceError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReplaceDeviceError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReplaceDeviceError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline ReplaceDeviceError::ReplaceDeviceErrorField getField () const;

    inline void setField(ReplaceDeviceError::ReplaceDeviceErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "ReplaceDeviceErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "ReplaceDeviceErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ReplaceDeviceErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ReplaceDeviceErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline ReplaceDeviceErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (ReplaceDeviceErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "ReplaceDeviceErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const ReplaceDeviceErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const ReplaceDeviceError &getDefaultInstance();

private:

    inline void cloneData (const ReplaceDeviceError& rhs);

    inline void deleteData ();

    ReplaceDeviceErrorField __field;

    union {
        ReplaceDeviceErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "RequestDeviceRingtoneList"
 * Provides a list of each paired phone Bluetooth device with its currently selected ringtone.  The list is sorted in order of the most recently connected device first.
 */
class RequestDeviceRingtoneListStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestDeviceRingtoneListStart ();

    /**
     * Copy constructor
     */
    inline  RequestDeviceRingtoneListStart (const RequestDeviceRingtoneListStart &rhs);

    /**
     * All fields constructor
     */
    inline  RequestDeviceRingtoneListStart (bool bDummyFlag_);

    /**
     * Destructor
     */
    inline virtual  ~RequestDeviceRingtoneListStart();

    /**
     * Assignment operator
     */
    inline RequestDeviceRingtoneListStart& operator = (const RequestDeviceRingtoneListStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestDeviceRingtoneListStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestDeviceRingtoneListStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestDeviceRingtoneListStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestDeviceRingtoneListStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bDummyFlag"

    static const int kBDummyFlag = 0;

    /**
     * Clears the field "bDummyFlag".
     *
     * The field will be set to its default value. The hasBDummyFlag()
     * method will return false.
     */
    inline void clearBDummyFlag();

    /**
     * Checks whether the field "bDummyFlag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDummyFlag()). Otherwise it will return false.
     */
    inline bool hasBDummyFlag () const;

    /**
     * Returns the value of the member "bDummyFlag".
     *
     * DummyFlag used to satisfy SequenceMethod requirement for a single parameter in the StartAck or StartResultAck.   This value shall always be set to False.
     *
     * @return The value of the field "bDummyFlag"
     */
    inline bool getBDummyFlag () const;

    /**
     * Sets the value of the member "bDummyFlag".
     *
     * DummyFlag used to satisfy SequenceMethod requirement for a single parameter in the StartAck or StartResultAck.   This value shall always be set to False.
     *
     * @param bDummyFlag The value which will be set
     */
    inline void setBDummyFlag (bool bDummyFlag_);

    static const RequestDeviceRingtoneListStart &getDefaultInstance();

private:

    inline void set_has_bDummyFlag ();

    inline void clear_has_bDummyFlag ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bDummyFlag;

};

/**
 * The result message of the method "RequestDeviceRingtoneList"
 * Provides a list of each paired phone Bluetooth device with its currently selected ringtone.  The list is sorted in order of the most recently connected device first.
 */
class RequestDeviceRingtoneListResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestDeviceRingtoneListResult ();

    /**
     * Copy constructor
     */
    inline  RequestDeviceRingtoneListResult (const RequestDeviceRingtoneListResult &rhs);

    /**
     * All fields constructor
     */
    inline  RequestDeviceRingtoneListResult (const ::most_BTSet_fi_types::T_BTSetDeviceRingtoneListResult& oDeviceRingtoneListResult_);

    /**
     * Destructor
     */
    inline virtual  ~RequestDeviceRingtoneListResult();

    /**
     * Assignment operator
     */
    inline RequestDeviceRingtoneListResult& operator = (const RequestDeviceRingtoneListResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestDeviceRingtoneListResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestDeviceRingtoneListResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestDeviceRingtoneListResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestDeviceRingtoneListResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oDeviceRingtoneListResult"

    static const int kODeviceRingtoneListResult = 0;

    /**
     * Clears the field "oDeviceRingtoneListResult".
     *
     * The field will be set to its default value. The hasODeviceRingtoneListResult()
     * method will return false.
     */
    inline void clearODeviceRingtoneListResult();

    /**
     * Checks whether the field "oDeviceRingtoneListResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setODeviceRingtoneListResult()). Otherwise it will return false.
     */
    inline bool hasODeviceRingtoneListResult () const;

    /**
     * Returns the value of the member "oDeviceRingtoneListResult".
     *
     * List of devices and their respective ringtones.
     *
     * @return The value of the field "oDeviceRingtoneListResult"
     */
    inline const ::most_BTSet_fi_types::T_BTSetDeviceRingtoneListResult& getODeviceRingtoneListResult () const;

    /**
     * Retrieves the value of the field "oDeviceRingtoneListResult" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oDeviceRingtoneListResult".
     */
    inline ::most_BTSet_fi_types::T_BTSetDeviceRingtoneListResult& getODeviceRingtoneListResultMutable ();

    /**
     * Sets the value of the member "oDeviceRingtoneListResult".
     *
     * List of devices and their respective ringtones.
     *
     * @param oDeviceRingtoneListResult The value which will be set
     */
    inline void setODeviceRingtoneListResult (const ::most_BTSet_fi_types::T_BTSetDeviceRingtoneListResult& oDeviceRingtoneListResult_);

    static const RequestDeviceRingtoneListResult &getDefaultInstance();

private:

    static const ::std::vector< ::most_BTSet_fi_types::T_BTSetDeviceRingtoneListResultItem >& getT_BTSetDeviceRingtoneListResultItemList_DefaultInstance ();

    inline void set_has_oDeviceRingtoneListResult ();

    inline void clear_has_oDeviceRingtoneListResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_BTSet_fi_types::T_BTSetDeviceRingtoneListResult _oDeviceRingtoneListResult;

};

/**
 * The error message of 'RequestDeviceRingtoneList'
 */
class RequestDeviceRingtoneListErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  RequestDeviceRingtoneListErrorStructure ();

    /**
     * Copy constructor
     */
    inline  RequestDeviceRingtoneListErrorStructure (const RequestDeviceRingtoneListErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  RequestDeviceRingtoneListErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~RequestDeviceRingtoneListErrorStructure();

    /**
     * Assignment operator
     */
    inline RequestDeviceRingtoneListErrorStructure& operator = (const RequestDeviceRingtoneListErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestDeviceRingtoneListErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestDeviceRingtoneListErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestDeviceRingtoneListErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestDeviceRingtoneListErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const RequestDeviceRingtoneListErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'RequestDeviceRingtoneList'
 */
class RequestDeviceRingtoneListError  : public ::asf::core::Payload {
public:

    enum RequestDeviceRingtoneListErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  RequestDeviceRingtoneListError ();

   /**
     * Copy constructor
     */
    inline  RequestDeviceRingtoneListError (const RequestDeviceRingtoneListError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~RequestDeviceRingtoneListError();

    /**
     * Assigns a new value to this object.
     */
    inline RequestDeviceRingtoneListError& operator = (const RequestDeviceRingtoneListError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestDeviceRingtoneListError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestDeviceRingtoneListError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestDeviceRingtoneListError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestDeviceRingtoneListError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline RequestDeviceRingtoneListError::RequestDeviceRingtoneListErrorField getField () const;

    inline void setField(RequestDeviceRingtoneListError::RequestDeviceRingtoneListErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "RequestDeviceRingtoneListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "RequestDeviceRingtoneListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const RequestDeviceRingtoneListErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline RequestDeviceRingtoneListErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline RequestDeviceRingtoneListErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (RequestDeviceRingtoneListErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "RequestDeviceRingtoneListErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const RequestDeviceRingtoneListErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const RequestDeviceRingtoneListError &getDefaultInstance();

private:

    inline void cloneData (const RequestDeviceRingtoneListError& rhs);

    inline void deleteData ();

    RequestDeviceRingtoneListErrorField __field;

    union {
        RequestDeviceRingtoneListErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "RequestAvailableRingtonesList"
 * Provides the list of ringtones available for selection for the particular device.
 */
class RequestAvailableRingtonesListStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestAvailableRingtonesListStart ();

    /**
     * Copy constructor
     */
    inline  RequestAvailableRingtonesListStart (const RequestAvailableRingtonesListStart &rhs);

    /**
     * All fields constructor
     */
    inline  RequestAvailableRingtonesListStart (uint8 u8DeviceHandle_);

    /**
     * Destructor
     */
    inline virtual  ~RequestAvailableRingtonesListStart();

    /**
     * Assignment operator
     */
    inline RequestAvailableRingtonesListStart& operator = (const RequestAvailableRingtonesListStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestAvailableRingtonesListStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestAvailableRingtonesListStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestAvailableRingtonesListStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestAvailableRingtonesListStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    static const RequestAvailableRingtonesListStart &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8DeviceHandle;

};

/**
 * The result message of the method "RequestAvailableRingtonesList"
 * Provides the list of ringtones available for selection for the particular device.
 */
class RequestAvailableRingtonesListResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestAvailableRingtonesListResult ();

    /**
     * Copy constructor
     */
    inline  RequestAvailableRingtonesListResult (const RequestAvailableRingtonesListResult &rhs);

    /**
     * All fields constructor
     */
    inline  RequestAvailableRingtonesListResult (const ::most_BTSet_fi_types::T_BTSetRingtoneList& oRingtoneList_);

    /**
     * Destructor
     */
    inline virtual  ~RequestAvailableRingtonesListResult();

    /**
     * Assignment operator
     */
    inline RequestAvailableRingtonesListResult& operator = (const RequestAvailableRingtonesListResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestAvailableRingtonesListResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestAvailableRingtonesListResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestAvailableRingtonesListResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestAvailableRingtonesListResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oRingtoneList"

    static const int kORingtoneList = 0;

    /**
     * Clears the field "oRingtoneList".
     *
     * The field will be set to its default value. The hasORingtoneList()
     * method will return false.
     */
    inline void clearORingtoneList();

    /**
     * Checks whether the field "oRingtoneList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setORingtoneList()). Otherwise it will return false.
     */
    inline bool hasORingtoneList () const;

    /**
     * Returns the value of the member "oRingtoneList".
     *
     * The list of available ringtones.
     *
     * @return The value of the field "oRingtoneList"
     */
    inline const ::most_BTSet_fi_types::T_BTSetRingtoneList& getORingtoneList () const;

    /**
     * Retrieves the value of the field "oRingtoneList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oRingtoneList".
     */
    inline ::most_BTSet_fi_types::T_BTSetRingtoneList& getORingtoneListMutable ();

    /**
     * Sets the value of the member "oRingtoneList".
     *
     * The list of available ringtones.
     *
     * @param oRingtoneList The value which will be set
     */
    inline void setORingtoneList (const ::most_BTSet_fi_types::T_BTSetRingtoneList& oRingtoneList_);

    static const RequestAvailableRingtonesListResult &getDefaultInstance();

private:

    static const ::std::vector< ::most_BTSet_fi_types::T_BTSetRingtoneListItem >& getT_BTSetRingtoneListItemList_DefaultInstance ();

    inline void set_has_oRingtoneList ();

    inline void clear_has_oRingtoneList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_BTSet_fi_types::T_BTSetRingtoneList _oRingtoneList;

};

/**
 * The error message of 'RequestAvailableRingtonesList'
 */
class RequestAvailableRingtonesListErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  RequestAvailableRingtonesListErrorStructure ();

    /**
     * Copy constructor
     */
    inline  RequestAvailableRingtonesListErrorStructure (const RequestAvailableRingtonesListErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  RequestAvailableRingtonesListErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~RequestAvailableRingtonesListErrorStructure();

    /**
     * Assignment operator
     */
    inline RequestAvailableRingtonesListErrorStructure& operator = (const RequestAvailableRingtonesListErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestAvailableRingtonesListErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestAvailableRingtonesListErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestAvailableRingtonesListErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestAvailableRingtonesListErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const RequestAvailableRingtonesListErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'RequestAvailableRingtonesList'
 */
class RequestAvailableRingtonesListError  : public ::asf::core::Payload {
public:

    enum RequestAvailableRingtonesListErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  RequestAvailableRingtonesListError ();

   /**
     * Copy constructor
     */
    inline  RequestAvailableRingtonesListError (const RequestAvailableRingtonesListError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~RequestAvailableRingtonesListError();

    /**
     * Assigns a new value to this object.
     */
    inline RequestAvailableRingtonesListError& operator = (const RequestAvailableRingtonesListError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestAvailableRingtonesListError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestAvailableRingtonesListError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestAvailableRingtonesListError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestAvailableRingtonesListError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline RequestAvailableRingtonesListError::RequestAvailableRingtonesListErrorField getField () const;

    inline void setField(RequestAvailableRingtonesListError::RequestAvailableRingtonesListErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "RequestAvailableRingtonesListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "RequestAvailableRingtonesListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const RequestAvailableRingtonesListErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline RequestAvailableRingtonesListErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline RequestAvailableRingtonesListErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (RequestAvailableRingtonesListErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "RequestAvailableRingtonesListErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const RequestAvailableRingtonesListErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const RequestAvailableRingtonesListError &getDefaultInstance();

private:

    inline void cloneData (const RequestAvailableRingtonesListError& rhs);

    inline void deleteData ();

    RequestAvailableRingtonesListErrorField __field;

    union {
        RequestAvailableRingtonesListErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "PlayRingtone"
 * When the method is called with u16RingtoneID set to any value between 0x02 - 0x0B, the identified
 * ringtone will play once, irrespective of the previously configured ringtone using the 'ChangeRingtone' interface.
 * If it is called with 0xFFFF or 0xFE, the configured ringtone is played continously.
 * In case the configured ringtone is not available or is set to 0x01 or 0xFF, default ringtone will be played continously.
 * MethodError would be reported if this method is called with any other RingtoneIDs.
 * Ringtone can be configured using the 'ChangeRingtone' interface.
 */
class PlayRingtoneStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PlayRingtoneStart ();

    /**
     * Copy constructor
     */
    inline  PlayRingtoneStart (const PlayRingtoneStart &rhs);

    /**
     * All fields constructor
     */
    inline  PlayRingtoneStart (uint16 u16RingtoneID_, uint8 u8LogicalAVChannel_);

    /**
     * Destructor
     */
    inline virtual  ~PlayRingtoneStart();

    /**
     * Assignment operator
     */
    inline PlayRingtoneStart& operator = (const PlayRingtoneStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PlayRingtoneStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PlayRingtoneStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PlayRingtoneStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PlayRingtoneStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16RingtoneID"

    static const int kU16RingtoneID = 0;

    /**
     * Clears the field "u16RingtoneID".
     *
     * The field will be set to its default value. The hasU16RingtoneID()
     * method will return false.
     */
    inline void clearU16RingtoneID();

    /**
     * Checks whether the field "u16RingtoneID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16RingtoneID()). Otherwise it will return false.
     */
    inline bool hasU16RingtoneID () const;

    /**
     * Returns the value of the member "u16RingtoneID".
     *
     * The unique ID for each ringtone available.
     *
     * @return The value of the field "u16RingtoneID"
     */
    inline uint16 getU16RingtoneID () const;

    /**
     * Sets the value of the member "u16RingtoneID".
     *
     * The unique ID for each ringtone available.
     *
     * @param u16RingtoneID The value which will be set
     */
    inline void setU16RingtoneID (uint16 u16RingtoneID_);

    // API of field "u8LogicalAVChannel"

    static const int kU8LogicalAVChannel = 1;

    /**
     * Clears the field "u8LogicalAVChannel".
     *
     * The field will be set to its default value. The hasU8LogicalAVChannel()
     * method will return false.
     */
    inline void clearU8LogicalAVChannel();

    /**
     * Checks whether the field "u8LogicalAVChannel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8LogicalAVChannel()). Otherwise it will return false.
     */
    inline bool hasU8LogicalAVChannel () const;

    /**
     * Returns the value of the member "u8LogicalAVChannel".
     *
     * Refer to IAVConnection for the enumeration of the Logical AV Channel parameter.
     *
     * @return The value of the field "u8LogicalAVChannel"
     */
    inline uint8 getU8LogicalAVChannel () const;

    /**
     * Sets the value of the member "u8LogicalAVChannel".
     *
     * Refer to IAVConnection for the enumeration of the Logical AV Channel parameter.
     *
     * @param u8LogicalAVChannel The value which will be set
     */
    inline void setU8LogicalAVChannel (uint8 u8LogicalAVChannel_);

    static const PlayRingtoneStart &getDefaultInstance();

private:

    inline void set_has_u16RingtoneID ();

    inline void clear_has_u16RingtoneID ();

    inline void set_has_u8LogicalAVChannel ();

    inline void clear_has_u8LogicalAVChannel ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _u16RingtoneID;

    uint8 _u8LogicalAVChannel;

};

/**
 * The result message of the method "PlayRingtone"
 * When the method is called with u16RingtoneID set to any value between 0x02 - 0x0B, the identified
 * ringtone will play once, irrespective of the previously configured ringtone using the 'ChangeRingtone' interface.
 * If it is called with 0xFFFF or 0xFE, the configured ringtone is played continously.
 * In case the configured ringtone is not available or is set to 0x01 or 0xFF, default ringtone will be played continously.
 * MethodError would be reported if this method is called with any other RingtoneIDs.
 * Ringtone can be configured using the 'ChangeRingtone' interface.
 */
class PlayRingtoneResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PlayRingtoneResult ();

    /**
     * Copy constructor
     */
    inline  PlayRingtoneResult (const PlayRingtoneResult &rhs);

    /**
     * All fields constructor
     */
    inline  PlayRingtoneResult (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline virtual  ~PlayRingtoneResult();

    /**
     * Assignment operator
     */
    inline PlayRingtoneResult& operator = (const PlayRingtoneResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PlayRingtoneResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PlayRingtoneResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PlayRingtoneResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PlayRingtoneResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const PlayRingtoneResult &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'PlayRingtone'
 */
class PlayRingtoneErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  PlayRingtoneErrorStructure ();

    /**
     * Copy constructor
     */
    inline  PlayRingtoneErrorStructure (const PlayRingtoneErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  PlayRingtoneErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~PlayRingtoneErrorStructure();

    /**
     * Assignment operator
     */
    inline PlayRingtoneErrorStructure& operator = (const PlayRingtoneErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PlayRingtoneErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PlayRingtoneErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PlayRingtoneErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PlayRingtoneErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const PlayRingtoneErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'PlayRingtone'
 */
class PlayRingtoneError  : public ::asf::core::Payload {
public:

    enum PlayRingtoneErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  PlayRingtoneError ();

   /**
     * Copy constructor
     */
    inline  PlayRingtoneError (const PlayRingtoneError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~PlayRingtoneError();

    /**
     * Assigns a new value to this object.
     */
    inline PlayRingtoneError& operator = (const PlayRingtoneError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PlayRingtoneError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PlayRingtoneError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PlayRingtoneError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PlayRingtoneError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline PlayRingtoneError::PlayRingtoneErrorField getField () const;

    inline void setField(PlayRingtoneError::PlayRingtoneErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "PlayRingtoneErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "PlayRingtoneErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const PlayRingtoneErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline PlayRingtoneErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline PlayRingtoneErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (PlayRingtoneErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "PlayRingtoneErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const PlayRingtoneErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const PlayRingtoneError &getDefaultInstance();

private:

    inline void cloneData (const PlayRingtoneError& rhs);

    inline void deleteData ();

    PlayRingtoneErrorField __field;

    union {
        PlayRingtoneErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The result message of the method "ClearDeviceInfo"
 * This function is called to clear out all Bluetooth devices from the FBlock including all pairing
 * information, phone book information, if any, etc..Upon receipt of the StartAck optype,the BluetoothSettings
 * FBlock shall permanently delete all information associated with all devices from persistent memory.
 * This function is generally only used to clear out customer device / information when a vehicle is turned-in at
 * the end of lease or is sold.
 */
class ClearDeviceInfoResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ClearDeviceInfoResult ();

    /**
     * Copy constructor
     */
    inline  ClearDeviceInfoResult (const ClearDeviceInfoResult &rhs);

    /**
     * All fields constructor
     */
    inline  ClearDeviceInfoResult (bool bResult_);

    /**
     * Destructor
     */
    inline virtual  ~ClearDeviceInfoResult();

    /**
     * Assignment operator
     */
    inline ClearDeviceInfoResult& operator = (const ClearDeviceInfoResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ClearDeviceInfoResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ClearDeviceInfoResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ClearDeviceInfoResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ClearDeviceInfoResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bResult"

    static const int kBResult = 0;

    /**
     * Clears the field "bResult".
     *
     * The field will be set to its default value. The hasBResult()
     * method will return false.
     */
    inline void clearBResult();

    /**
     * Checks whether the field "bResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBResult()). Otherwise it will return false.
     */
    inline bool hasBResult () const;

    /**
     * Returns the value of the member "bResult".
     *
     * SUCCESS : The Local mode switch request is received and the action will be taken on this request and the result will be notified through PairableMode Property. ERROR :The request will not be processed right now.
     *
     * @return The value of the field "bResult"
     */
    inline bool getBResult () const;

    /**
     * Sets the value of the member "bResult".
     *
     * SUCCESS : The Local mode switch request is received and the action will be taken on this request and the result will be notified through PairableMode Property. ERROR :The request will not be processed right now.
     *
     * @param bResult The value which will be set
     */
    inline void setBResult (bool bResult_);

    static const ClearDeviceInfoResult &getDefaultInstance();

private:

    inline void set_has_bResult ();

    inline void clear_has_bResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bResult;

};

/**
 * The error message of 'ClearDeviceInfo'
 */
class ClearDeviceInfoErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  ClearDeviceInfoErrorStructure ();

    /**
     * Copy constructor
     */
    inline  ClearDeviceInfoErrorStructure (const ClearDeviceInfoErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  ClearDeviceInfoErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~ClearDeviceInfoErrorStructure();

    /**
     * Assignment operator
     */
    inline ClearDeviceInfoErrorStructure& operator = (const ClearDeviceInfoErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ClearDeviceInfoErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ClearDeviceInfoErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ClearDeviceInfoErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ClearDeviceInfoErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     *
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     *
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     *
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     *
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const ClearDeviceInfoErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'ClearDeviceInfo'
 */
class ClearDeviceInfoError  : public ::asf::core::Payload {
public:

    enum ClearDeviceInfoErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  ClearDeviceInfoError ();

   /**
     * Copy constructor
     */
    inline  ClearDeviceInfoError (const ClearDeviceInfoError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~ClearDeviceInfoError();

    /**
     * Assigns a new value to this object.
     */
    inline ClearDeviceInfoError& operator = (const ClearDeviceInfoError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ClearDeviceInfoError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ClearDeviceInfoError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ClearDeviceInfoError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ClearDeviceInfoError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline ClearDeviceInfoError::ClearDeviceInfoErrorField getField () const;

    inline void setField(ClearDeviceInfoError::ClearDeviceInfoErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "ClearDeviceInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "ClearDeviceInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ClearDeviceInfoErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ClearDeviceInfoErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline ClearDeviceInfoErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (ClearDeviceInfoErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "ClearDeviceInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const ClearDeviceInfoErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const ClearDeviceInfoError &getDefaultInstance();

private:

    inline void cloneData (const ClearDeviceInfoError& rhs);

    inline void deleteData ();

    ClearDeviceInfoErrorField __field;

    union {
        ClearDeviceInfoErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "AutoConnectOnOff"
 * Activate/De-activate AutoConnectOff
 */
class AutoConnectOnOffStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AutoConnectOnOffStatus ();

    /**
     * Copy constructor
     */
    inline  AutoConnectOnOffStatus (const AutoConnectOnOffStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AutoConnectOnOffStatus (bool bAutoConnectOnOff_);

    /**
     * Destructor
     */
    inline virtual  ~AutoConnectOnOffStatus();

    /**
     * Assignment operator
     */
    inline AutoConnectOnOffStatus& operator = (const AutoConnectOnOffStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AutoConnectOnOffStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AutoConnectOnOffStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AutoConnectOnOffStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AutoConnectOnOffStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bAutoConnectOnOff"

    static const int kBAutoConnectOnOff = 0;

    /**
     * Clears the field "bAutoConnectOnOff".
     *
     * The field will be set to its default value. The hasBAutoConnectOnOff()
     * method will return false.
     */
    inline void clearBAutoConnectOnOff();

    /**
     * Checks whether the field "bAutoConnectOnOff" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBAutoConnectOnOff()). Otherwise it will return false.
     */
    inline bool hasBAutoConnectOnOff () const;

    /**
     * Returns the value of the member "bAutoConnectOnOff".
     *
     * Autoconnect ON or OFF
     *
     * @return The value of the field "bAutoConnectOnOff"
     */
    inline bool getBAutoConnectOnOff () const;

    /**
     * Sets the value of the member "bAutoConnectOnOff".
     *
     * Autoconnect ON or OFF
     *
     * @param bAutoConnectOnOff The value which will be set
     */
    inline void setBAutoConnectOnOff (bool bAutoConnectOnOff_);

    static const AutoConnectOnOffStatus &getDefaultInstance();

private:

    inline void set_has_bAutoConnectOnOff ();

    inline void clear_has_bAutoConnectOnOff ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bAutoConnectOnOff;

};

/**
 * The set message of the property "AutoConnectOnOff"
 * Activate/De-activate AutoConnectOff
 */
class AutoConnectOnOffSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AutoConnectOnOffSet ();

    /**
     * Copy constructor
     */
    inline  AutoConnectOnOffSet (const AutoConnectOnOffSet &rhs);

    /**
     * All fields constructor
     */
    inline  AutoConnectOnOffSet (bool bAutoConnectOnOff_);

    /**
     * Destructor
     */
    inline virtual  ~AutoConnectOnOffSet();

    /**
     * Assignment operator
     */
    inline AutoConnectOnOffSet& operator = (const AutoConnectOnOffSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AutoConnectOnOffSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AutoConnectOnOffSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AutoConnectOnOffSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AutoConnectOnOffSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bAutoConnectOnOff"

    static const int kBAutoConnectOnOff = 0;

    /**
     * Clears the field "bAutoConnectOnOff".
     *
     * The field will be set to its default value. The hasBAutoConnectOnOff()
     * method will return false.
     */
    inline void clearBAutoConnectOnOff();

    /**
     * Checks whether the field "bAutoConnectOnOff" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBAutoConnectOnOff()). Otherwise it will return false.
     */
    inline bool hasBAutoConnectOnOff () const;

    /**
     * Returns the value of the member "bAutoConnectOnOff".
     *
     * Set AutoconnectOnOff
     *
     * @return The value of the field "bAutoConnectOnOff"
     */
    inline bool getBAutoConnectOnOff () const;

    /**
     * Sets the value of the member "bAutoConnectOnOff".
     *
     * Set AutoconnectOnOff
     *
     * @param bAutoConnectOnOff The value which will be set
     */
    inline void setBAutoConnectOnOff (bool bAutoConnectOnOff_);

    static const AutoConnectOnOffSet &getDefaultInstance();

private:

    inline void set_has_bAutoConnectOnOff ();

    inline void clear_has_bAutoConnectOnOff ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bAutoConnectOnOff;

};

/**
 * The get message of the property "AutoConnectOnOff"
 * Activate/De-activate AutoConnectOff
 */
class AutoConnectOnOffGet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AutoConnectOnOffGet ();

    /**
     * Copy constructor
     */
    inline  AutoConnectOnOffGet (const AutoConnectOnOffGet &rhs);

    /**
     * All fields constructor
     */
    inline  AutoConnectOnOffGet (bool bAutoConnectOnOff_);

    /**
     * Destructor
     */
    inline virtual  ~AutoConnectOnOffGet();

    /**
     * Assignment operator
     */
    inline AutoConnectOnOffGet& operator = (const AutoConnectOnOffGet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AutoConnectOnOffGet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AutoConnectOnOffGet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AutoConnectOnOffGet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AutoConnectOnOffGet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bAutoConnectOnOff"

    static const int kBAutoConnectOnOff = 0;

    /**
     * Clears the field "bAutoConnectOnOff".
     *
     * The field will be set to its default value. The hasBAutoConnectOnOff()
     * method will return false.
     */
    inline void clearBAutoConnectOnOff();

    /**
     * Checks whether the field "bAutoConnectOnOff" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBAutoConnectOnOff()). Otherwise it will return false.
     */
    inline bool hasBAutoConnectOnOff () const;

    /**
     * Returns the value of the member "bAutoConnectOnOff".
     *
     * Get AutoconnectOnOff
     *
     * @return The value of the field "bAutoConnectOnOff"
     */
    inline bool getBAutoConnectOnOff () const;

    /**
     * Sets the value of the member "bAutoConnectOnOff".
     *
     * Get AutoconnectOnOff
     *
     * @param bAutoConnectOnOff The value which will be set
     */
    inline void setBAutoConnectOnOff (bool bAutoConnectOnOff_);

    static const AutoConnectOnOffGet &getDefaultInstance();

private:

    inline void set_has_bAutoConnectOnOff ();

    inline void clear_has_bAutoConnectOnOff ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bAutoConnectOnOff;

};

/**
 * The error message of 'AutoConnectOnOff'
 */
class AutoConnectOnOffErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  AutoConnectOnOffErrorStructure ();

    /**
     * Copy constructor
     */
    inline  AutoConnectOnOffErrorStructure (const AutoConnectOnOffErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  AutoConnectOnOffErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~AutoConnectOnOffErrorStructure();

    /**
     * Assignment operator
     */
    inline AutoConnectOnOffErrorStructure& operator = (const AutoConnectOnOffErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AutoConnectOnOffErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AutoConnectOnOffErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AutoConnectOnOffErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AutoConnectOnOffErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const AutoConnectOnOffErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'AutoConnectOnOff'
 */
class AutoConnectOnOffError  : public ::asf::core::Payload {
public:

    enum AutoConnectOnOffErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  AutoConnectOnOffError ();

   /**
     * Copy constructor
     */
    inline  AutoConnectOnOffError (const AutoConnectOnOffError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~AutoConnectOnOffError();

    /**
     * Assigns a new value to this object.
     */
    inline AutoConnectOnOffError& operator = (const AutoConnectOnOffError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AutoConnectOnOffError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AutoConnectOnOffError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AutoConnectOnOffError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AutoConnectOnOffError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline AutoConnectOnOffError::AutoConnectOnOffErrorField getField () const;

    inline void setField(AutoConnectOnOffError::AutoConnectOnOffErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "AutoConnectOnOffErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "AutoConnectOnOffErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const AutoConnectOnOffErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline AutoConnectOnOffErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline AutoConnectOnOffErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (AutoConnectOnOffErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "AutoConnectOnOffErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const AutoConnectOnOffErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const AutoConnectOnOffError &getDefaultInstance();

private:

    inline void cloneData (const AutoConnectOnOffError& rhs);

    inline void deleteData ();

    AutoConnectOnOffErrorField __field;

    union {
        AutoConnectOnOffErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "VehicleBTAddress"
 * Vehicle BT Address
 */
class VehicleBTAddressStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VehicleBTAddressStatus ();

    /**
     * Copy constructor
     */
    inline  VehicleBTAddressStatus (const VehicleBTAddressStatus &rhs);

    /**
     * All fields constructor
     */
    inline  VehicleBTAddressStatus (const ::fi_basetypes_most::T_String& sVehicleBTAddress_);

    /**
     * Destructor
     */
    inline virtual  ~VehicleBTAddressStatus();

    /**
     * Assignment operator
     */
    inline VehicleBTAddressStatus& operator = (const VehicleBTAddressStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VehicleBTAddressStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VehicleBTAddressStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VehicleBTAddressStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VehicleBTAddressStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sVehicleBTAddress"

    static const int kSVehicleBTAddress = 0;

    /**
     * Clears the field "sVehicleBTAddress".
     *
     * The field will be set to its default value. The hasSVehicleBTAddress()
     * method will return false.
     */
    inline void clearSVehicleBTAddress();

    /**
     * Checks whether the field "sVehicleBTAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSVehicleBTAddress()). Otherwise it will return false.
     */
    inline bool hasSVehicleBTAddress () const;

    /**
     * Returns the value of the member "sVehicleBTAddress".
     *
     * Bluetooth address of the vehicle.
     *
     * @return The value of the field "sVehicleBTAddress"
     */
    inline const ::fi_basetypes_most::T_String& getSVehicleBTAddress () const;

    /**
     * Retrieves the value of the field "sVehicleBTAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sVehicleBTAddress".
     */
    inline ::fi_basetypes_most::T_String& getSVehicleBTAddressMutable ();

    /**
     * Sets the value of the member "sVehicleBTAddress".
     *
     * Bluetooth address of the vehicle.
     *
     * @param sVehicleBTAddress The value which will be set
     */
    inline void setSVehicleBTAddress (const ::fi_basetypes_most::T_String& sVehicleBTAddress_);

    static const VehicleBTAddressStatus &getDefaultInstance();

private:

    inline void set_has_sVehicleBTAddress ();

    inline void clear_has_sVehicleBTAddress ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::fi_basetypes_most::T_String _sVehicleBTAddress;

};

/**
 * The error message of 'VehicleBTAddress'
 */
class VehicleBTAddressErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  VehicleBTAddressErrorStructure ();

    /**
     * Copy constructor
     */
    inline  VehicleBTAddressErrorStructure (const VehicleBTAddressErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  VehicleBTAddressErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~VehicleBTAddressErrorStructure();

    /**
     * Assignment operator
     */
    inline VehicleBTAddressErrorStructure& operator = (const VehicleBTAddressErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VehicleBTAddressErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VehicleBTAddressErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VehicleBTAddressErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VehicleBTAddressErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const VehicleBTAddressErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'VehicleBTAddress'
 */
class VehicleBTAddressError  : public ::asf::core::Payload {
public:

    enum VehicleBTAddressErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  VehicleBTAddressError ();

   /**
     * Copy constructor
     */
    inline  VehicleBTAddressError (const VehicleBTAddressError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~VehicleBTAddressError();

    /**
     * Assigns a new value to this object.
     */
    inline VehicleBTAddressError& operator = (const VehicleBTAddressError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VehicleBTAddressError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VehicleBTAddressError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VehicleBTAddressError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VehicleBTAddressError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline VehicleBTAddressError::VehicleBTAddressErrorField getField () const;

    inline void setField(VehicleBTAddressError::VehicleBTAddressErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "VehicleBTAddressErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "VehicleBTAddressErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const VehicleBTAddressErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline VehicleBTAddressErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline VehicleBTAddressErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (VehicleBTAddressErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "VehicleBTAddressErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const VehicleBTAddressErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const VehicleBTAddressError &getDefaultInstance();

private:

    inline void cloneData (const VehicleBTAddressError& rhs);

    inline void deleteData ();

    VehicleBTAddressErrorField __field;

    union {
        VehicleBTAddressErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "VehicleSupportedBTProfiles"
 * Vehicle Supported BT Profiles
 */
class VehicleSupportedBTProfilesStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VehicleSupportedBTProfilesStatus ();

    /**
     * Copy constructor
     */
    inline  VehicleSupportedBTProfilesStatus (const VehicleSupportedBTProfilesStatus &rhs);

    /**
     * All fields constructor
     */
    inline  VehicleSupportedBTProfilesStatus (const ::most_BTSet_fi_types_Extended::T_BTSetSupportedProfiles& oSupportedProfiles_);

    /**
     * Destructor
     */
    inline virtual  ~VehicleSupportedBTProfilesStatus();

    /**
     * Assignment operator
     */
    inline VehicleSupportedBTProfilesStatus& operator = (const VehicleSupportedBTProfilesStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VehicleSupportedBTProfilesStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VehicleSupportedBTProfilesStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VehicleSupportedBTProfilesStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VehicleSupportedBTProfilesStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oSupportedProfiles"

    static const int kOSupportedProfiles = 0;

    /**
     * Clears the field "oSupportedProfiles".
     *
     * The field will be set to its default value. The hasOSupportedProfiles()
     * method will return false.
     */
    inline void clearOSupportedProfiles();

    /**
     * Checks whether the field "oSupportedProfiles" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOSupportedProfiles()). Otherwise it will return false.
     */
    inline bool hasOSupportedProfiles () const;

    /**
     * Returns the value of the member "oSupportedProfiles".
     *
     * Bluetooth supported profiles.
     *
     * @return The value of the field "oSupportedProfiles"
     */
    inline const ::most_BTSet_fi_types_Extended::T_BTSetSupportedProfiles& getOSupportedProfiles () const;

    /**
     * Retrieves the value of the field "oSupportedProfiles" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oSupportedProfiles".
     */
    inline ::most_BTSet_fi_types_Extended::T_BTSetSupportedProfiles& getOSupportedProfilesMutable ();

    /**
     * Sets the value of the member "oSupportedProfiles".
     *
     * Bluetooth supported profiles.
     *
     * @param oSupportedProfiles The value which will be set
     */
    inline void setOSupportedProfiles (const ::most_BTSet_fi_types_Extended::T_BTSetSupportedProfiles& oSupportedProfiles_);

    static const VehicleSupportedBTProfilesStatus &getDefaultInstance();

private:

    inline void set_has_oSupportedProfiles ();

    inline void clear_has_oSupportedProfiles ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_BTSet_fi_types_Extended::T_BTSetSupportedProfiles _oSupportedProfiles;

};

/**
 * The error message of 'VehicleSupportedBTProfiles'
 */
class VehicleSupportedBTProfilesErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  VehicleSupportedBTProfilesErrorStructure ();

    /**
     * Copy constructor
     */
    inline  VehicleSupportedBTProfilesErrorStructure (const VehicleSupportedBTProfilesErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  VehicleSupportedBTProfilesErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~VehicleSupportedBTProfilesErrorStructure();

    /**
     * Assignment operator
     */
    inline VehicleSupportedBTProfilesErrorStructure& operator = (const VehicleSupportedBTProfilesErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VehicleSupportedBTProfilesErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VehicleSupportedBTProfilesErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VehicleSupportedBTProfilesErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VehicleSupportedBTProfilesErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const VehicleSupportedBTProfilesErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'VehicleSupportedBTProfiles'
 */
class VehicleSupportedBTProfilesError  : public ::asf::core::Payload {
public:

    enum VehicleSupportedBTProfilesErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  VehicleSupportedBTProfilesError ();

   /**
     * Copy constructor
     */
    inline  VehicleSupportedBTProfilesError (const VehicleSupportedBTProfilesError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~VehicleSupportedBTProfilesError();

    /**
     * Assigns a new value to this object.
     */
    inline VehicleSupportedBTProfilesError& operator = (const VehicleSupportedBTProfilesError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VehicleSupportedBTProfilesError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VehicleSupportedBTProfilesError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VehicleSupportedBTProfilesError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VehicleSupportedBTProfilesError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline VehicleSupportedBTProfilesError::VehicleSupportedBTProfilesErrorField getField () const;

    inline void setField(VehicleSupportedBTProfilesError::VehicleSupportedBTProfilesErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "VehicleSupportedBTProfilesErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "VehicleSupportedBTProfilesErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const VehicleSupportedBTProfilesErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline VehicleSupportedBTProfilesErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline VehicleSupportedBTProfilesErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (VehicleSupportedBTProfilesErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "VehicleSupportedBTProfilesErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const VehicleSupportedBTProfilesErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const VehicleSupportedBTProfilesError &getDefaultInstance();

private:

    inline void cloneData (const VehicleSupportedBTProfilesError& rhs);

    inline void deleteData ();

    VehicleSupportedBTProfilesErrorField __field;

    union {
        VehicleSupportedBTProfilesErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "VehicleBTFriendlyNameset"
 * This is the new VehicleBTFriendlyName Which has set opcode included. And it also contains opcodes of(0x227)
 */
class VehicleBTFriendlyNamesetStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VehicleBTFriendlyNamesetStatus ();

    /**
     * Copy constructor
     */
    inline  VehicleBTFriendlyNamesetStatus (const VehicleBTFriendlyNamesetStatus &rhs);

    /**
     * All fields constructor
     */
    inline  VehicleBTFriendlyNamesetStatus (const ::fi_basetypes_most::T_String& sVehicleBTFriendlyName_);

    /**
     * Destructor
     */
    inline virtual  ~VehicleBTFriendlyNamesetStatus();

    /**
     * Assignment operator
     */
    inline VehicleBTFriendlyNamesetStatus& operator = (const VehicleBTFriendlyNamesetStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VehicleBTFriendlyNamesetStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VehicleBTFriendlyNamesetStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VehicleBTFriendlyNamesetStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VehicleBTFriendlyNamesetStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sVehicleBTFriendlyName"

    static const int kSVehicleBTFriendlyName = 0;

    /**
     * Clears the field "sVehicleBTFriendlyName".
     *
     * The field will be set to its default value. The hasSVehicleBTFriendlyName()
     * method will return false.
     */
    inline void clearSVehicleBTFriendlyName();

    /**
     * Checks whether the field "sVehicleBTFriendlyName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSVehicleBTFriendlyName()). Otherwise it will return false.
     */
    inline bool hasSVehicleBTFriendlyName () const;

    /**
     * Returns the value of the member "sVehicleBTFriendlyName".
     *
     * The Bluetooth friendly name of the vehicle.
     *
     * @return The value of the field "sVehicleBTFriendlyName"
     */
    inline const ::fi_basetypes_most::T_String& getSVehicleBTFriendlyName () const;

    /**
     * Retrieves the value of the field "sVehicleBTFriendlyName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sVehicleBTFriendlyName".
     */
    inline ::fi_basetypes_most::T_String& getSVehicleBTFriendlyNameMutable ();

    /**
     * Sets the value of the member "sVehicleBTFriendlyName".
     *
     * The Bluetooth friendly name of the vehicle.
     *
     * @param sVehicleBTFriendlyName The value which will be set
     */
    inline void setSVehicleBTFriendlyName (const ::fi_basetypes_most::T_String& sVehicleBTFriendlyName_);

    static const VehicleBTFriendlyNamesetStatus &getDefaultInstance();

private:

    inline void set_has_sVehicleBTFriendlyName ();

    inline void clear_has_sVehicleBTFriendlyName ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::fi_basetypes_most::T_String _sVehicleBTFriendlyName;

};

/**
 * The set message of the property "VehicleBTFriendlyNameset"
 * This is the new VehicleBTFriendlyName Which has set opcode included. And it also contains opcodes of(0x227)
 */
class VehicleBTFriendlyNamesetSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VehicleBTFriendlyNamesetSet ();

    /**
     * Copy constructor
     */
    inline  VehicleBTFriendlyNamesetSet (const VehicleBTFriendlyNamesetSet &rhs);

    /**
     * All fields constructor
     */
    inline  VehicleBTFriendlyNamesetSet (const ::fi_basetypes_most::T_String& sVehicleBTFriendlyName_);

    /**
     * Destructor
     */
    inline virtual  ~VehicleBTFriendlyNamesetSet();

    /**
     * Assignment operator
     */
    inline VehicleBTFriendlyNamesetSet& operator = (const VehicleBTFriendlyNamesetSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VehicleBTFriendlyNamesetSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VehicleBTFriendlyNamesetSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VehicleBTFriendlyNamesetSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VehicleBTFriendlyNamesetSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sVehicleBTFriendlyName"

    static const int kSVehicleBTFriendlyName = 0;

    /**
     * Clears the field "sVehicleBTFriendlyName".
     *
     * The field will be set to its default value. The hasSVehicleBTFriendlyName()
     * method will return false.
     */
    inline void clearSVehicleBTFriendlyName();

    /**
     * Checks whether the field "sVehicleBTFriendlyName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSVehicleBTFriendlyName()). Otherwise it will return false.
     */
    inline bool hasSVehicleBTFriendlyName () const;

    /**
     * Returns the value of the member "sVehicleBTFriendlyName".
     *
     * Set Vehicle BT friendly name
     *
     * @return The value of the field "sVehicleBTFriendlyName"
     */
    inline const ::fi_basetypes_most::T_String& getSVehicleBTFriendlyName () const;

    /**
     * Retrieves the value of the field "sVehicleBTFriendlyName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sVehicleBTFriendlyName".
     */
    inline ::fi_basetypes_most::T_String& getSVehicleBTFriendlyNameMutable ();

    /**
     * Sets the value of the member "sVehicleBTFriendlyName".
     *
     * Set Vehicle BT friendly name
     *
     * @param sVehicleBTFriendlyName The value which will be set
     */
    inline void setSVehicleBTFriendlyName (const ::fi_basetypes_most::T_String& sVehicleBTFriendlyName_);

    static const VehicleBTFriendlyNamesetSet &getDefaultInstance();

private:

    inline void set_has_sVehicleBTFriendlyName ();

    inline void clear_has_sVehicleBTFriendlyName ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::fi_basetypes_most::T_String _sVehicleBTFriendlyName;

};

/**
 * The error message of 'VehicleBTFriendlyNameset'
 */
class VehicleBTFriendlyNamesetErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  VehicleBTFriendlyNamesetErrorStructure ();

    /**
     * Copy constructor
     */
    inline  VehicleBTFriendlyNamesetErrorStructure (const VehicleBTFriendlyNamesetErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  VehicleBTFriendlyNamesetErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~VehicleBTFriendlyNamesetErrorStructure();

    /**
     * Assignment operator
     */
    inline VehicleBTFriendlyNamesetErrorStructure& operator = (const VehicleBTFriendlyNamesetErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VehicleBTFriendlyNamesetErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VehicleBTFriendlyNamesetErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VehicleBTFriendlyNamesetErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VehicleBTFriendlyNamesetErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const VehicleBTFriendlyNamesetErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'VehicleBTFriendlyNameset'
 */
class VehicleBTFriendlyNamesetError  : public ::asf::core::Payload {
public:

    enum VehicleBTFriendlyNamesetErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  VehicleBTFriendlyNamesetError ();

   /**
     * Copy constructor
     */
    inline  VehicleBTFriendlyNamesetError (const VehicleBTFriendlyNamesetError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~VehicleBTFriendlyNamesetError();

    /**
     * Assigns a new value to this object.
     */
    inline VehicleBTFriendlyNamesetError& operator = (const VehicleBTFriendlyNamesetError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VehicleBTFriendlyNamesetError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VehicleBTFriendlyNamesetError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VehicleBTFriendlyNamesetError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VehicleBTFriendlyNamesetError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline VehicleBTFriendlyNamesetError::VehicleBTFriendlyNamesetErrorField getField () const;

    inline void setField(VehicleBTFriendlyNamesetError::VehicleBTFriendlyNamesetErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "VehicleBTFriendlyNamesetErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "VehicleBTFriendlyNamesetErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const VehicleBTFriendlyNamesetErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline VehicleBTFriendlyNamesetErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline VehicleBTFriendlyNamesetErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (VehicleBTFriendlyNamesetErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "VehicleBTFriendlyNamesetErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const VehicleBTFriendlyNamesetErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const VehicleBTFriendlyNamesetError &getDefaultInstance();

private:

    inline void cloneData (const VehicleBTFriendlyNamesetError& rhs);

    inline void deleteData ();

    VehicleBTFriendlyNamesetErrorField __field;

    union {
        VehicleBTFriendlyNamesetErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "PairingRequest"
 * Provides info about where the pairing has been initiated (System/Device) and also the type of pairing (Legacy/SSP Numeric) for particular deivce.
 */
class PairingRequestStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PairingRequestStatus ();

    /**
     * Copy constructor
     */
    inline  PairingRequestStatus (const PairingRequestStatus &rhs);

    /**
     * All fields constructor
     */
    inline  PairingRequestStatus (const ::fi_basetypes_most::T_String& sDeviceName_, const ::fi_basetypes_most::T_String& sRemoteDeviceAddress_, const ::fi_basetypes_most::T_String& sPinNumber_, ::most_BTSet_fi_types::T_e8_BTSetPairingType e8PairingType_, ::most_BTSet_fi_types_Extended::T_e8_BTSetOrigin e8Origin_);

    /**
     * Destructor
     */
    inline virtual  ~PairingRequestStatus();

    /**
     * Assignment operator
     */
    inline PairingRequestStatus& operator = (const PairingRequestStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PairingRequestStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PairingRequestStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PairingRequestStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PairingRequestStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sDeviceName"

    static const int kSDeviceName = 0;

    /**
     * Clears the field "sDeviceName".
     *
     * The field will be set to its default value. The hasSDeviceName()
     * method will return false.
     */
    inline void clearSDeviceName();

    /**
     * Checks whether the field "sDeviceName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDeviceName()). Otherwise it will return false.
     */
    inline bool hasSDeviceName () const;

    /**
     * Returns the value of the member "sDeviceName".
     *
     * Name of the external Phone Device(Bluetooth friendly name)
     *
     * @return The value of the field "sDeviceName"
     */
    inline const ::fi_basetypes_most::T_String& getSDeviceName () const;

    /**
     * Retrieves the value of the field "sDeviceName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDeviceName".
     */
    inline ::fi_basetypes_most::T_String& getSDeviceNameMutable ();

    /**
     * Sets the value of the member "sDeviceName".
     *
     * Name of the external Phone Device(Bluetooth friendly name)
     *
     * @param sDeviceName The value which will be set
     */
    inline void setSDeviceName (const ::fi_basetypes_most::T_String& sDeviceName_);

    // API of field "sRemoteDeviceAddress"

    static const int kSRemoteDeviceAddress = 1;

    /**
     * Clears the field "sRemoteDeviceAddress".
     *
     * The field will be set to its default value. The hasSRemoteDeviceAddress()
     * method will return false.
     */
    inline void clearSRemoteDeviceAddress();

    /**
     * Checks whether the field "sRemoteDeviceAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSRemoteDeviceAddress()). Otherwise it will return false.
     */
    inline bool hasSRemoteDeviceAddress () const;

    /**
     * Returns the value of the member "sRemoteDeviceAddress".
     *
     * Identifies the Bluetooth device address. It is represented as 12 hexidecimal characters.
     *
     * @return The value of the field "sRemoteDeviceAddress"
     */
    inline const ::fi_basetypes_most::T_String& getSRemoteDeviceAddress () const;

    /**
     * Retrieves the value of the field "sRemoteDeviceAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sRemoteDeviceAddress".
     */
    inline ::fi_basetypes_most::T_String& getSRemoteDeviceAddressMutable ();

    /**
     * Sets the value of the member "sRemoteDeviceAddress".
     *
     * Identifies the Bluetooth device address. It is represented as 12 hexidecimal characters.
     *
     * @param sRemoteDeviceAddress The value which will be set
     */
    inline void setSRemoteDeviceAddress (const ::fi_basetypes_most::T_String& sRemoteDeviceAddress_);

    // API of field "sPinNumber"

    static const int kSPinNumber = 2;

    /**
     * Clears the field "sPinNumber".
     *
     * The field will be set to its default value. The hasSPinNumber()
     * method will return false.
     */
    inline void clearSPinNumber();

    /**
     * Checks whether the field "sPinNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPinNumber()). Otherwise it will return false.
     */
    inline bool hasSPinNumber () const;

    /**
     * Returns the value of the member "sPinNumber".
     *
     * The PIN number to be used for the current pairing process.
     *
     * @return The value of the field "sPinNumber"
     */
    inline const ::fi_basetypes_most::T_String& getSPinNumber () const;

    /**
     * Retrieves the value of the field "sPinNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sPinNumber".
     */
    inline ::fi_basetypes_most::T_String& getSPinNumberMutable ();

    /**
     * Sets the value of the member "sPinNumber".
     *
     * The PIN number to be used for the current pairing process.
     *
     * @param sPinNumber The value which will be set
     */
    inline void setSPinNumber (const ::fi_basetypes_most::T_String& sPinNumber_);

    // API of field "e8PairingType"

    static const int kE8PairingType = 3;

    /**
     * Clears the field "e8PairingType".
     *
     * The field will be set to its default value. The hasE8PairingType()
     * method will return false.
     */
    inline void clearE8PairingType();

    /**
     * Checks whether the field "e8PairingType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PairingType()). Otherwise it will return false.
     */
    inline bool hasE8PairingType () const;

    /**
     * Returns the value of the member "e8PairingType".
     *
     * Identifies the type of pairing.(Legacy/SSPNumeric/SSPJustWorks/ChangePin)
     *
     * @return The value of the field "e8PairingType"
     */
    inline ::most_BTSet_fi_types::T_e8_BTSetPairingType getE8PairingType () const;

    /**
     * Sets the value of the member "e8PairingType".
     *
     * Identifies the type of pairing.(Legacy/SSPNumeric/SSPJustWorks/ChangePin)
     *
     * @param e8PairingType The value which will be set
     */
    inline void setE8PairingType (::most_BTSet_fi_types::T_e8_BTSetPairingType e8PairingType_);

    // API of field "e8Origin"

    static const int kE8Origin = 4;

    /**
     * Clears the field "e8Origin".
     *
     * The field will be set to its default value. The hasE8Origin()
     * method will return false.
     */
    inline void clearE8Origin();

    /**
     * Checks whether the field "e8Origin" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Origin()). Otherwise it will return false.
     */
    inline bool hasE8Origin () const;

    /**
     * Returns the value of the member "e8Origin".
     *
     * Identifies where the pairing has been initiated.(Device/System)
     *
     * @return The value of the field "e8Origin"
     */
    inline ::most_BTSet_fi_types_Extended::T_e8_BTSetOrigin getE8Origin () const;

    /**
     * Sets the value of the member "e8Origin".
     *
     * Identifies where the pairing has been initiated.(Device/System)
     *
     * @param e8Origin The value which will be set
     */
    inline void setE8Origin (::most_BTSet_fi_types_Extended::T_e8_BTSetOrigin e8Origin_);

    static const PairingRequestStatus &getDefaultInstance();

private:

    inline void set_has_sDeviceName ();

    inline void clear_has_sDeviceName ();

    inline void set_has_sRemoteDeviceAddress ();

    inline void clear_has_sRemoteDeviceAddress ();

    inline void set_has_sPinNumber ();

    inline void clear_has_sPinNumber ();

    inline void set_has_e8PairingType ();

    inline void clear_has_e8PairingType ();

    inline void set_has_e8Origin ();

    inline void clear_has_e8Origin ();

    uint32 _has_bits_[ (5 + 31) / 32];

    ::fi_basetypes_most::T_String _sDeviceName;

    ::fi_basetypes_most::T_String _sRemoteDeviceAddress;

    ::fi_basetypes_most::T_String _sPinNumber;

    ::most_BTSet_fi_types::T_e8_BTSetPairingType _e8PairingType;

    ::most_BTSet_fi_types_Extended::T_e8_BTSetOrigin _e8Origin;

};

/**
 * The error message of 'PairingRequest'
 */
class PairingRequestErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  PairingRequestErrorStructure ();

    /**
     * Copy constructor
     */
    inline  PairingRequestErrorStructure (const PairingRequestErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  PairingRequestErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~PairingRequestErrorStructure();

    /**
     * Assignment operator
     */
    inline PairingRequestErrorStructure& operator = (const PairingRequestErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PairingRequestErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PairingRequestErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PairingRequestErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PairingRequestErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const PairingRequestErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'PairingRequest'
 */
class PairingRequestError  : public ::asf::core::Payload {
public:

    enum PairingRequestErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  PairingRequestError ();

   /**
     * Copy constructor
     */
    inline  PairingRequestError (const PairingRequestError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~PairingRequestError();

    /**
     * Assigns a new value to this object.
     */
    inline PairingRequestError& operator = (const PairingRequestError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PairingRequestError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PairingRequestError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PairingRequestError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PairingRequestError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline PairingRequestError::PairingRequestErrorField getField () const;

    inline void setField(PairingRequestError::PairingRequestErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "PairingRequestErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "PairingRequestErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const PairingRequestErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline PairingRequestErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline PairingRequestErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (PairingRequestErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "PairingRequestErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const PairingRequestErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const PairingRequestError &getDefaultInstance();

private:

    inline void cloneData (const PairingRequestError& rhs);

    inline void deleteData ();

    PairingRequestErrorField __field;

    union {
        PairingRequestErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "DeviceListExtended"
 * Device List Extended.
 * Provides a list of each paired Bluetooth device and its current status and
 * specifically informs the HMI controller of the device and the change in
 * device status that has triggered the notification.The
 * DeviceListResult stream provides a list of each paired Bluetooth device
 * identifying which of the profiles of the devices are connected and which
 * are all the supported profiles and which device is the outgoing
 * source device. The connected devices are sorted with the outgoing source
 * device first. If an outgoing source device does not exist the devices are
 * sorted in order of the most recently to least recently connected device.
 * The not connected devices are sorted in order of the most recently to
 * least recently connected device.The NumPairedDevices provides the
 * number of paired devices such that the parsing of the DeviceListResult is
 * simplified.
 */
class DeviceListExtendedStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeviceListExtendedStatus ();

    /**
     * Copy constructor
     */
    inline  DeviceListExtendedStatus (const DeviceListExtendedStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DeviceListExtendedStatus (const ::most_BTSet_fi_types_Extended::T_BTSetDeviceListChangeExtended& oDeviceListChange_, uint8 u8NumPairedDevices_, const ::most_BTSet_fi_types_Extended::T_BTSetDeviceListExtendedResult& oDeviceListExtendedResult_);

    /**
     * Destructor
     */
    inline virtual  ~DeviceListExtendedStatus();

    /**
     * Assignment operator
     */
    inline DeviceListExtendedStatus& operator = (const DeviceListExtendedStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceListExtendedStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceListExtendedStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceListExtendedStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceListExtendedStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oDeviceListChange"

    static const int kODeviceListChange = 0;

    /**
     * Clears the field "oDeviceListChange".
     *
     * The field will be set to its default value. The hasODeviceListChange()
     * method will return false.
     */
    inline void clearODeviceListChange();

    /**
     * Checks whether the field "oDeviceListChange" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setODeviceListChange()). Otherwise it will return false.
     */
    inline bool hasODeviceListChange () const;

    /**
     * Returns the value of the member "oDeviceListChange".
     *
     *
     *
     * @return The value of the field "oDeviceListChange"
     */
    inline const ::most_BTSet_fi_types_Extended::T_BTSetDeviceListChangeExtended& getODeviceListChange () const;

    /**
     * Retrieves the value of the field "oDeviceListChange" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oDeviceListChange".
     */
    inline ::most_BTSet_fi_types_Extended::T_BTSetDeviceListChangeExtended& getODeviceListChangeMutable ();

    /**
     * Sets the value of the member "oDeviceListChange".
     *
     *
     *
     * @param oDeviceListChange The value which will be set
     */
    inline void setODeviceListChange (const ::most_BTSet_fi_types_Extended::T_BTSetDeviceListChangeExtended& oDeviceListChange_);

    // API of field "u8NumPairedDevices"

    static const int kU8NumPairedDevices = 1;

    /**
     * Clears the field "u8NumPairedDevices".
     *
     * The field will be set to its default value. The hasU8NumPairedDevices()
     * method will return false.
     */
    inline void clearU8NumPairedDevices();

    /**
     * Checks whether the field "u8NumPairedDevices" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8NumPairedDevices()). Otherwise it will return false.
     */
    inline bool hasU8NumPairedDevices () const;

    /**
     * Returns the value of the member "u8NumPairedDevices".
     *
     * Identifies the number of paired devices.Used to parse the
     * DeviceListResult stream.
     *
     * @return The value of the field "u8NumPairedDevices"
     */
    inline uint8 getU8NumPairedDevices () const;

    /**
     * Sets the value of the member "u8NumPairedDevices".
     *
     * Identifies the number of paired devices.Used to parse the
     * DeviceListResult stream.
     *
     * @param u8NumPairedDevices The value which will be set
     */
    inline void setU8NumPairedDevices (uint8 u8NumPairedDevices_);

    // API of field "oDeviceListExtendedResult"

    static const int kODeviceListExtendedResult = 2;

    /**
     * Clears the field "oDeviceListExtendedResult".
     *
     * The field will be set to its default value. The hasODeviceListExtendedResult()
     * method will return false.
     */
    inline void clearODeviceListExtendedResult();

    /**
     * Checks whether the field "oDeviceListExtendedResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setODeviceListExtendedResult()). Otherwise it will return false.
     */
    inline bool hasODeviceListExtendedResult () const;

    /**
     * Returns the value of the member "oDeviceListExtendedResult".
     *
     * List of paired devices.
     *
     * @return The value of the field "oDeviceListExtendedResult"
     */
    inline const ::most_BTSet_fi_types_Extended::T_BTSetDeviceListExtendedResult& getODeviceListExtendedResult () const;

    /**
     * Retrieves the value of the field "oDeviceListExtendedResult" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oDeviceListExtendedResult".
     */
    inline ::most_BTSet_fi_types_Extended::T_BTSetDeviceListExtendedResult& getODeviceListExtendedResultMutable ();

    /**
     * Sets the value of the member "oDeviceListExtendedResult".
     *
     * List of paired devices.
     *
     * @param oDeviceListExtendedResult The value which will be set
     */
    inline void setODeviceListExtendedResult (const ::most_BTSet_fi_types_Extended::T_BTSetDeviceListExtendedResult& oDeviceListExtendedResult_);

    static const DeviceListExtendedStatus &getDefaultInstance();

private:

    static const ::std::vector< ::most_BTSet_fi_types_Extended::T_BTSetDeviceListExtendedResultItem >& getT_BTSetDeviceListExtendedResultItemList_DefaultInstance ();

    inline void set_has_oDeviceListChange ();

    inline void clear_has_oDeviceListChange ();

    inline void set_has_u8NumPairedDevices ();

    inline void clear_has_u8NumPairedDevices ();

    inline void set_has_oDeviceListExtendedResult ();

    inline void clear_has_oDeviceListExtendedResult ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::most_BTSet_fi_types_Extended::T_BTSetDeviceListChangeExtended _oDeviceListChange;

    uint8 _u8NumPairedDevices;

    ::most_BTSet_fi_types_Extended::T_BTSetDeviceListExtendedResult _oDeviceListExtendedResult;

};

/**
 * The error message of 'DeviceListExtended'
 */
class DeviceListExtendedErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DeviceListExtendedErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DeviceListExtendedErrorStructure (const DeviceListExtendedErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DeviceListExtendedErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~DeviceListExtendedErrorStructure();

    /**
     * Assignment operator
     */
    inline DeviceListExtendedErrorStructure& operator = (const DeviceListExtendedErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceListExtendedErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceListExtendedErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceListExtendedErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceListExtendedErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const DeviceListExtendedErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'DeviceListExtended'
 */
class DeviceListExtendedError  : public ::asf::core::Payload {
public:

    enum DeviceListExtendedErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DeviceListExtendedError ();

   /**
     * Copy constructor
     */
    inline  DeviceListExtendedError (const DeviceListExtendedError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DeviceListExtendedError();

    /**
     * Assigns a new value to this object.
     */
    inline DeviceListExtendedError& operator = (const DeviceListExtendedError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceListExtendedError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceListExtendedError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceListExtendedError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceListExtendedError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DeviceListExtendedError::DeviceListExtendedErrorField getField () const;

    inline void setField(DeviceListExtendedError::DeviceListExtendedErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DeviceListExtendedErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DeviceListExtendedErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DeviceListExtendedErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DeviceListExtendedErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DeviceListExtendedErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DeviceListExtendedErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DeviceListExtendedErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DeviceListExtendedErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DeviceListExtendedError &getDefaultInstance();

private:

    inline void cloneData (const DeviceListExtendedError& rhs);

    inline void deleteData ();

    DeviceListExtendedErrorField __field;

    union {
        DeviceListExtendedErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "VisibleDevices"
 * VisibleDevices property provides a list of visible devices found during the Inquiry scan procedure initiated via ScanBluetoothDevices MethodStart.
 */
class VisibleDevicesStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VisibleDevicesStatus ();

    /**
     * Copy constructor
     */
    inline  VisibleDevicesStatus (const VisibleDevicesStatus &rhs);

    /**
     * All fields constructor
     */
    inline  VisibleDevicesStatus (uint8 u8NumVisibleDevices_, const ::most_BTSet_fi_types_Extended::T_BTSetVisibleDevicesList& oVisibleDevicesList_);

    /**
     * Destructor
     */
    inline virtual  ~VisibleDevicesStatus();

    /**
     * Assignment operator
     */
    inline VisibleDevicesStatus& operator = (const VisibleDevicesStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VisibleDevicesStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VisibleDevicesStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VisibleDevicesStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VisibleDevicesStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8NumVisibleDevices"

    static const int kU8NumVisibleDevices = 0;

    /**
     * Clears the field "u8NumVisibleDevices".
     *
     * The field will be set to its default value. The hasU8NumVisibleDevices()
     * method will return false.
     */
    inline void clearU8NumVisibleDevices();

    /**
     * Checks whether the field "u8NumVisibleDevices" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8NumVisibleDevices()). Otherwise it will return false.
     */
    inline bool hasU8NumVisibleDevices () const;

    /**
     * Returns the value of the member "u8NumVisibleDevices".
     *
     * Identifies the number of visible devices.
     *
     * @return The value of the field "u8NumVisibleDevices"
     */
    inline uint8 getU8NumVisibleDevices () const;

    /**
     * Sets the value of the member "u8NumVisibleDevices".
     *
     * Identifies the number of visible devices.
     *
     * @param u8NumVisibleDevices The value which will be set
     */
    inline void setU8NumVisibleDevices (uint8 u8NumVisibleDevices_);

    // API of field "oVisibleDevicesList"

    static const int kOVisibleDevicesList = 1;

    /**
     * Clears the field "oVisibleDevicesList".
     *
     * The field will be set to its default value. The hasOVisibleDevicesList()
     * method will return false.
     */
    inline void clearOVisibleDevicesList();

    /**
     * Checks whether the field "oVisibleDevicesList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOVisibleDevicesList()). Otherwise it will return false.
     */
    inline bool hasOVisibleDevicesList () const;

    /**
     * Returns the value of the member "oVisibleDevicesList".
     *
     * List of visible devices along with their attributes.
     *
     * @return The value of the field "oVisibleDevicesList"
     */
    inline const ::most_BTSet_fi_types_Extended::T_BTSetVisibleDevicesList& getOVisibleDevicesList () const;

    /**
     * Retrieves the value of the field "oVisibleDevicesList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oVisibleDevicesList".
     */
    inline ::most_BTSet_fi_types_Extended::T_BTSetVisibleDevicesList& getOVisibleDevicesListMutable ();

    /**
     * Sets the value of the member "oVisibleDevicesList".
     *
     * List of visible devices along with their attributes.
     *
     * @param oVisibleDevicesList The value which will be set
     */
    inline void setOVisibleDevicesList (const ::most_BTSet_fi_types_Extended::T_BTSetVisibleDevicesList& oVisibleDevicesList_);

    static const VisibleDevicesStatus &getDefaultInstance();

private:

    static const ::std::vector< ::most_BTSet_fi_types_Extended::T_BTSetVisibleDeviceItem >& getT_BTSetVisibleDeviceItemList_DefaultInstance ();

    inline void set_has_u8NumVisibleDevices ();

    inline void clear_has_u8NumVisibleDevices ();

    inline void set_has_oVisibleDevicesList ();

    inline void clear_has_oVisibleDevicesList ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8NumVisibleDevices;

    ::most_BTSet_fi_types_Extended::T_BTSetVisibleDevicesList _oVisibleDevicesList;

};

/**
 * The error message of 'VisibleDevices'
 */
class VisibleDevicesErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  VisibleDevicesErrorStructure ();

    /**
     * Copy constructor
     */
    inline  VisibleDevicesErrorStructure (const VisibleDevicesErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  VisibleDevicesErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~VisibleDevicesErrorStructure();

    /**
     * Assignment operator
     */
    inline VisibleDevicesErrorStructure& operator = (const VisibleDevicesErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VisibleDevicesErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VisibleDevicesErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VisibleDevicesErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VisibleDevicesErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const VisibleDevicesErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'VisibleDevices'
 */
class VisibleDevicesError  : public ::asf::core::Payload {
public:

    enum VisibleDevicesErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  VisibleDevicesError ();

   /**
     * Copy constructor
     */
    inline  VisibleDevicesError (const VisibleDevicesError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~VisibleDevicesError();

    /**
     * Assigns a new value to this object.
     */
    inline VisibleDevicesError& operator = (const VisibleDevicesError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VisibleDevicesError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VisibleDevicesError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VisibleDevicesError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VisibleDevicesError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline VisibleDevicesError::VisibleDevicesErrorField getField () const;

    inline void setField(VisibleDevicesError::VisibleDevicesErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "VisibleDevicesErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "VisibleDevicesErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const VisibleDevicesErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline VisibleDevicesErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline VisibleDevicesErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (VisibleDevicesErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "VisibleDevicesErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const VisibleDevicesErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const VisibleDevicesError &getDefaultInstance();

private:

    inline void cloneData (const VisibleDevicesError& rhs);

    inline void deleteData ();

    VisibleDevicesErrorField __field;

    union {
        VisibleDevicesErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "PairableMode"
 * This property informs to the client whether the Bluetooth module is in discoverable and ready to be paired.
 */
class PairableModeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PairableModeStatus ();

    /**
     * Copy constructor
     */
    inline  PairableModeStatus (const PairableModeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  PairableModeStatus (bool Pairable_, bool Connectable_, bool PairingInProgress_, const ::fi_basetypes_most::T_String& sBTAddress_);

    /**
     * Destructor
     */
    inline virtual  ~PairableModeStatus();

    /**
     * Assignment operator
     */
    inline PairableModeStatus& operator = (const PairableModeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PairableModeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PairableModeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PairableModeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PairableModeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Pairable"

    static const int kPairable = 0;

    /**
     * Clears the field "Pairable".
     *
     * The field will be set to its default value. The hasPairable()
     * method will return false.
     */
    inline void clearPairable();

    /**
     * Checks whether the field "Pairable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPairable()). Otherwise it will return false.
     */
    inline bool hasPairable () const;

    /**
     * Returns the value of the member "Pairable".
     *
     * This is to update the current status of the Pairable state. On = 1 Off = 0
     *
     * @return The value of the field "Pairable"
     */
    inline bool getPairable () const;

    /**
     * Sets the value of the member "Pairable".
     *
     * This is to update the current status of the Pairable state. On = 1 Off = 0
     *
     * @param Pairable The value which will be set
     */
    inline void setPairable (bool Pairable_);

    // API of field "Connectable"

    static const int kConnectable = 1;

    /**
     * Clears the field "Connectable".
     *
     * The field will be set to its default value. The hasConnectable()
     * method will return false.
     */
    inline void clearConnectable();

    /**
     * Checks whether the field "Connectable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConnectable()). Otherwise it will return false.
     */
    inline bool hasConnectable () const;

    /**
     * Returns the value of the member "Connectable".
     *
     * This is to update the current status of the Connectable state. On = 1 Off = 0
     *
     * @return The value of the field "Connectable"
     */
    inline bool getConnectable () const;

    /**
     * Sets the value of the member "Connectable".
     *
     * This is to update the current status of the Connectable state. On = 1 Off = 0
     *
     * @param Connectable The value which will be set
     */
    inline void setConnectable (bool Connectable_);

    // API of field "PairingInProgress"

    static const int kPairingInProgress = 2;

    /**
     * Clears the field "PairingInProgress".
     *
     * The field will be set to its default value. The hasPairingInProgress()
     * method will return false.
     */
    inline void clearPairingInProgress();

    /**
     * Checks whether the field "PairingInProgress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPairingInProgress()). Otherwise it will return false.
     */
    inline bool hasPairingInProgress () const;

    /**
     * Returns the value of the member "PairingInProgress".
     *
     * This is to update the current status of the PairingInProgress state. Ongoing = 1 Idle = 0
     *
     * @return The value of the field "PairingInProgress"
     */
    inline bool getPairingInProgress () const;

    /**
     * Sets the value of the member "PairingInProgress".
     *
     * This is to update the current status of the PairingInProgress state. Ongoing = 1 Idle = 0
     *
     * @param PairingInProgress The value which will be set
     */
    inline void setPairingInProgress (bool PairingInProgress_);

    // API of field "sBTAddress"

    static const int kSBTAddress = 3;

    /**
     * Clears the field "sBTAddress".
     *
     * The field will be set to its default value. The hasSBTAddress()
     * method will return false.
     */
    inline void clearSBTAddress();

    /**
     * Checks whether the field "sBTAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSBTAddress()). Otherwise it will return false.
     */
    inline bool hasSBTAddress () const;

    /**
     * Returns the value of the member "sBTAddress".
     *
     * Device address of the requested device
     *
     * @return The value of the field "sBTAddress"
     */
    inline const ::fi_basetypes_most::T_String& getSBTAddress () const;

    /**
     * Retrieves the value of the field "sBTAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sBTAddress".
     */
    inline ::fi_basetypes_most::T_String& getSBTAddressMutable ();

    /**
     * Sets the value of the member "sBTAddress".
     *
     * Device address of the requested device
     *
     * @param sBTAddress The value which will be set
     */
    inline void setSBTAddress (const ::fi_basetypes_most::T_String& sBTAddress_);

    static const PairableModeStatus &getDefaultInstance();

private:

    inline void set_has_Pairable ();

    inline void clear_has_Pairable ();

    inline void set_has_Connectable ();

    inline void clear_has_Connectable ();

    inline void set_has_PairingInProgress ();

    inline void clear_has_PairingInProgress ();

    inline void set_has_sBTAddress ();

    inline void clear_has_sBTAddress ();

    uint32 _has_bits_[ (4 + 31) / 32];

    bool _Pairable;

    bool _Connectable;

    bool _PairingInProgress;

    ::fi_basetypes_most::T_String _sBTAddress;

};

/**
 * The error message of 'PairableMode'
 */
class PairableModeErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  PairableModeErrorStructure ();

    /**
     * Copy constructor
     */
    inline  PairableModeErrorStructure (const PairableModeErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  PairableModeErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~PairableModeErrorStructure();

    /**
     * Assignment operator
     */
    inline PairableModeErrorStructure& operator = (const PairableModeErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PairableModeErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PairableModeErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PairableModeErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PairableModeErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const PairableModeErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'PairableMode'
 */
class PairableModeError  : public ::asf::core::Payload {
public:

    enum PairableModeErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  PairableModeError ();

   /**
     * Copy constructor
     */
    inline  PairableModeError (const PairableModeError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~PairableModeError();

    /**
     * Assigns a new value to this object.
     */
    inline PairableModeError& operator = (const PairableModeError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PairableModeError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PairableModeError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PairableModeError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PairableModeError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline PairableModeError::PairableModeErrorField getField () const;

    inline void setField(PairableModeError::PairableModeErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "PairableModeErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "PairableModeErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const PairableModeErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline PairableModeErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline PairableModeErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (PairableModeErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "PairableModeErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const PairableModeErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const PairableModeError &getDefaultInstance();

private:

    inline void cloneData (const PairableModeError& rhs);

    inline void deleteData ();

    PairableModeErrorField __field;

    union {
        PairableModeErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "SignalStrength"
 * This property is used to indicate the signal strength for connected devices to the registered clients.
 * The property returns a list of connected device handles and the corresponding signal strengths.
 */
class SignalStrengthStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SignalStrengthStatus ();

    /**
     * Copy constructor
     */
    inline  SignalStrengthStatus (const SignalStrengthStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SignalStrengthStatus (const ::most_BTSet_fi_types_Extended::T_BTSetSignalStrengthList& oSignalStrengthList_);

    /**
     * Destructor
     */
    inline virtual  ~SignalStrengthStatus();

    /**
     * Assignment operator
     */
    inline SignalStrengthStatus& operator = (const SignalStrengthStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SignalStrengthStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SignalStrengthStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SignalStrengthStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SignalStrengthStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oSignalStrengthList"

    static const int kOSignalStrengthList = 0;

    /**
     * Clears the field "oSignalStrengthList".
     *
     * The field will be set to its default value. The hasOSignalStrengthList()
     * method will return false.
     */
    inline void clearOSignalStrengthList();

    /**
     * Checks whether the field "oSignalStrengthList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOSignalStrengthList()). Otherwise it will return false.
     */
    inline bool hasOSignalStrengthList () const;

    /**
     * Returns the value of the member "oSignalStrengthList".
     *
     * List of connected devices and their signal strength
     *
     * @return The value of the field "oSignalStrengthList"
     */
    inline const ::most_BTSet_fi_types_Extended::T_BTSetSignalStrengthList& getOSignalStrengthList () const;

    /**
     * Retrieves the value of the field "oSignalStrengthList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oSignalStrengthList".
     */
    inline ::most_BTSet_fi_types_Extended::T_BTSetSignalStrengthList& getOSignalStrengthListMutable ();

    /**
     * Sets the value of the member "oSignalStrengthList".
     *
     * List of connected devices and their signal strength
     *
     * @param oSignalStrengthList The value which will be set
     */
    inline void setOSignalStrengthList (const ::most_BTSet_fi_types_Extended::T_BTSetSignalStrengthList& oSignalStrengthList_);

    static const SignalStrengthStatus &getDefaultInstance();

private:

    static const ::std::vector< ::most_BTSet_fi_types_Extended::T_BTSetSignalStrengthItem >& getT_BTSetSignalStrengthItemList_DefaultInstance ();

    inline void set_has_oSignalStrengthList ();

    inline void clear_has_oSignalStrengthList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_BTSet_fi_types_Extended::T_BTSetSignalStrengthList _oSignalStrengthList;

};

/**
 * The error message of 'SignalStrength'
 */
class SignalStrengthErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SignalStrengthErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SignalStrengthErrorStructure (const SignalStrengthErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SignalStrengthErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~SignalStrengthErrorStructure();

    /**
     * Assignment operator
     */
    inline SignalStrengthErrorStructure& operator = (const SignalStrengthErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SignalStrengthErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SignalStrengthErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SignalStrengthErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SignalStrengthErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const SignalStrengthErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'SignalStrength'
 */
class SignalStrengthError  : public ::asf::core::Payload {
public:

    enum SignalStrengthErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SignalStrengthError ();

   /**
     * Copy constructor
     */
    inline  SignalStrengthError (const SignalStrengthError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SignalStrengthError();

    /**
     * Assigns a new value to this object.
     */
    inline SignalStrengthError& operator = (const SignalStrengthError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SignalStrengthError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SignalStrengthError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SignalStrengthError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SignalStrengthError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SignalStrengthError::SignalStrengthErrorField getField () const;

    inline void setField(SignalStrengthError::SignalStrengthErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SignalStrengthErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SignalStrengthErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SignalStrengthErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SignalStrengthErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SignalStrengthErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SignalStrengthErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SignalStrengthErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SignalStrengthErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SignalStrengthError &getDefaultInstance();

private:

    inline void cloneData (const SignalStrengthError& rhs);

    inline void deleteData ();

    SignalStrengthErrorField __field;

    union {
        SignalStrengthErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "SPPServiceConnection"
 * This property will contain the RFComm device name.
 */
class SPPServiceConnectionStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SPPServiceConnectionStatus ();

    /**
     * Copy constructor
     */
    inline  SPPServiceConnectionStatus (const SPPServiceConnectionStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SPPServiceConnectionStatus (const ::most_BTSet_fi_types_Extended::T_BTSPPServiceConnectionStatusList& oSPPServiceConnectionStatusList_);

    /**
     * Destructor
     */
    inline virtual  ~SPPServiceConnectionStatus();

    /**
     * Assignment operator
     */
    inline SPPServiceConnectionStatus& operator = (const SPPServiceConnectionStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SPPServiceConnectionStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SPPServiceConnectionStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SPPServiceConnectionStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SPPServiceConnectionStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oSPPServiceConnectionStatusList"

    static const int kOSPPServiceConnectionStatusList = 0;

    /**
     * Clears the field "oSPPServiceConnectionStatusList".
     *
     * The field will be set to its default value. The hasOSPPServiceConnectionStatusList()
     * method will return false.
     */
    inline void clearOSPPServiceConnectionStatusList();

    /**
     * Checks whether the field "oSPPServiceConnectionStatusList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOSPPServiceConnectionStatusList()). Otherwise it will return false.
     */
    inline bool hasOSPPServiceConnectionStatusList () const;

    /**
     * Returns the value of the member "oSPPServiceConnectionStatusList".
     *
     * It consists list of SPP service's data such as device handle, UUID, RFCommID, disconnection reason and connection status.
     *
     * @return The value of the field "oSPPServiceConnectionStatusList"
     */
    inline const ::most_BTSet_fi_types_Extended::T_BTSPPServiceConnectionStatusList& getOSPPServiceConnectionStatusList () const;

    /**
     * Retrieves the value of the field "oSPPServiceConnectionStatusList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oSPPServiceConnectionStatusList".
     */
    inline ::most_BTSet_fi_types_Extended::T_BTSPPServiceConnectionStatusList& getOSPPServiceConnectionStatusListMutable ();

    /**
     * Sets the value of the member "oSPPServiceConnectionStatusList".
     *
     * It consists list of SPP service's data such as device handle, UUID, RFCommID, disconnection reason and connection status.
     *
     * @param oSPPServiceConnectionStatusList The value which will be set
     */
    inline void setOSPPServiceConnectionStatusList (const ::most_BTSet_fi_types_Extended::T_BTSPPServiceConnectionStatusList& oSPPServiceConnectionStatusList_);

    static const SPPServiceConnectionStatus &getDefaultInstance();

private:

    static const ::std::vector< ::most_BTSet_fi_types_Extended::T_BTSPPServiceConnectionStatusListItem >& getT_BTSPPServiceConnectionStatusListItemList_DefaultInstance ();

    inline void set_has_oSPPServiceConnectionStatusList ();

    inline void clear_has_oSPPServiceConnectionStatusList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_BTSet_fi_types_Extended::T_BTSPPServiceConnectionStatusList _oSPPServiceConnectionStatusList;

};

/**
 * The error message of 'SPPServiceConnection'
 */
class SPPServiceConnectionErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SPPServiceConnectionErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SPPServiceConnectionErrorStructure (const SPPServiceConnectionErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SPPServiceConnectionErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~SPPServiceConnectionErrorStructure();

    /**
     * Assignment operator
     */
    inline SPPServiceConnectionErrorStructure& operator = (const SPPServiceConnectionErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SPPServiceConnectionErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SPPServiceConnectionErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SPPServiceConnectionErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SPPServiceConnectionErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const SPPServiceConnectionErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'SPPServiceConnection'
 */
class SPPServiceConnectionError  : public ::asf::core::Payload {
public:

    enum SPPServiceConnectionErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SPPServiceConnectionError ();

   /**
     * Copy constructor
     */
    inline  SPPServiceConnectionError (const SPPServiceConnectionError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SPPServiceConnectionError();

    /**
     * Assigns a new value to this object.
     */
    inline SPPServiceConnectionError& operator = (const SPPServiceConnectionError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SPPServiceConnectionError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SPPServiceConnectionError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SPPServiceConnectionError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SPPServiceConnectionError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SPPServiceConnectionError::SPPServiceConnectionErrorField getField () const;

    inline void setField(SPPServiceConnectionError::SPPServiceConnectionErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SPPServiceConnectionErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SPPServiceConnectionErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SPPServiceConnectionErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SPPServiceConnectionErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SPPServiceConnectionErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SPPServiceConnectionErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SPPServiceConnectionErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SPPServiceConnectionErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SPPServiceConnectionError &getDefaultInstance();

private:

    inline void cloneData (const SPPServiceConnectionError& rhs);

    inline void deleteData ();

    SPPServiceConnectionErrorField __field;

    union {
        SPPServiceConnectionErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "BluetoothLimitationMode"
 * <p>This property provides a list of limitation/restriction settings w.r.t. Bluetooth behaviour which are currently handled by BluetoothSettings (BM application).</p>
 * <p>Normally there is only one entry in the list with same Bluetooth device address. But it can happen there are multiple entries with same Bluetooth device address. In this case the other parameters technology or communication channel have to be checked to find the matching entry.</p>
 * <p>Therefore following rule can be applied: Each list entry is identified by a tuple of Bluetooth device address, technology and communication channel.</p>
 */
class BluetoothLimitationModeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BluetoothLimitationModeStatus ();

    /**
     * Copy constructor
     */
    inline  BluetoothLimitationModeStatus (const BluetoothLimitationModeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  BluetoothLimitationModeStatus (const ::most_BTSet_fi_types_Extended::T_BTLimitationModeList& oList_);

    /**
     * Destructor
     */
    inline virtual  ~BluetoothLimitationModeStatus();

    /**
     * Assignment operator
     */
    inline BluetoothLimitationModeStatus& operator = (const BluetoothLimitationModeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BluetoothLimitationModeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BluetoothLimitationModeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BluetoothLimitationModeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BluetoothLimitationModeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oList"

    static const int kOList = 0;

    /**
     * Clears the field "oList".
     *
     * The field will be set to its default value. The hasOList()
     * method will return false.
     */
    inline void clearOList();

    /**
     * Checks whether the field "oList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOList()). Otherwise it will return false.
     */
    inline bool hasOList () const;

    /**
     * Returns the value of the member "oList".
     *
     * List of limitation/restriction settings w.r.t. Bluetooth behaviour which are currently handled by BluetoothSettings (BM application).
     *
     * @return The value of the field "oList"
     */
    inline const ::most_BTSet_fi_types_Extended::T_BTLimitationModeList& getOList () const;

    /**
     * Retrieves the value of the field "oList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oList".
     */
    inline ::most_BTSet_fi_types_Extended::T_BTLimitationModeList& getOListMutable ();

    /**
     * Sets the value of the member "oList".
     *
     * List of limitation/restriction settings w.r.t. Bluetooth behaviour which are currently handled by BluetoothSettings (BM application).
     *
     * @param oList The value which will be set
     */
    inline void setOList (const ::most_BTSet_fi_types_Extended::T_BTLimitationModeList& oList_);

    static const BluetoothLimitationModeStatus &getDefaultInstance();

private:

    static const ::std::vector< ::most_BTSet_fi_types_Extended::T_BTLimitationModeListItem >& getT_BTLimitationModeListItemList_DefaultInstance ();

    inline void set_has_oList ();

    inline void clear_has_oList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_BTSet_fi_types_Extended::T_BTLimitationModeList _oList;

};

/**
 * The error message of 'BluetoothLimitationMode'
 */
class BluetoothLimitationModeErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  BluetoothLimitationModeErrorStructure ();

    /**
     * Copy constructor
     */
    inline  BluetoothLimitationModeErrorStructure (const BluetoothLimitationModeErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  BluetoothLimitationModeErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~BluetoothLimitationModeErrorStructure();

    /**
     * Assignment operator
     */
    inline BluetoothLimitationModeErrorStructure& operator = (const BluetoothLimitationModeErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BluetoothLimitationModeErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BluetoothLimitationModeErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BluetoothLimitationModeErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BluetoothLimitationModeErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const BluetoothLimitationModeErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'BluetoothLimitationMode'
 */
class BluetoothLimitationModeError  : public ::asf::core::Payload {
public:

    enum BluetoothLimitationModeErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  BluetoothLimitationModeError ();

   /**
     * Copy constructor
     */
    inline  BluetoothLimitationModeError (const BluetoothLimitationModeError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~BluetoothLimitationModeError();

    /**
     * Assigns a new value to this object.
     */
    inline BluetoothLimitationModeError& operator = (const BluetoothLimitationModeError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BluetoothLimitationModeError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BluetoothLimitationModeError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BluetoothLimitationModeError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BluetoothLimitationModeError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline BluetoothLimitationModeError::BluetoothLimitationModeErrorField getField () const;

    inline void setField(BluetoothLimitationModeError::BluetoothLimitationModeErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "BluetoothLimitationModeErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "BluetoothLimitationModeErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const BluetoothLimitationModeErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline BluetoothLimitationModeErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline BluetoothLimitationModeErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (BluetoothLimitationModeErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "BluetoothLimitationModeErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const BluetoothLimitationModeErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const BluetoothLimitationModeError &getDefaultInstance();

private:

    inline void cloneData (const BluetoothLimitationModeError& rhs);

    inline void deleteData ();

    BluetoothLimitationModeErrorField __field;

    union {
        BluetoothLimitationModeErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "MultiHFPSupport"
 * This property is used to indicate the Status of MultiHFPSupport to the registered clients.
 */
class MultiHFPSupportStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MultiHFPSupportStatus ();

    /**
     * Copy constructor
     */
    inline  MultiHFPSupportStatus (const MultiHFPSupportStatus &rhs);

    /**
     * All fields constructor
     */
    inline  MultiHFPSupportStatus (::most_BTSet_fi_types_Extended::T_e8_BTSwitchStatus e8MultiHFPSupport_);

    /**
     * Destructor
     */
    inline virtual  ~MultiHFPSupportStatus();

    /**
     * Assignment operator
     */
    inline MultiHFPSupportStatus& operator = (const MultiHFPSupportStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MultiHFPSupportStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MultiHFPSupportStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MultiHFPSupportStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MultiHFPSupportStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8MultiHFPSupport"

    static const int kE8MultiHFPSupport = 0;

    /**
     * Clears the field "e8MultiHFPSupport".
     *
     * The field will be set to its default value. The hasE8MultiHFPSupport()
     * method will return false.
     */
    inline void clearE8MultiHFPSupport();

    /**
     * Checks whether the field "e8MultiHFPSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MultiHFPSupport()). Otherwise it will return false.
     */
    inline bool hasE8MultiHFPSupport () const;

    /**
     * Returns the value of the member "e8MultiHFPSupport".
     *
     * Status of MultiHFPSupport.
     *
     * @return The value of the field "e8MultiHFPSupport"
     */
    inline ::most_BTSet_fi_types_Extended::T_e8_BTSwitchStatus getE8MultiHFPSupport () const;

    /**
     * Sets the value of the member "e8MultiHFPSupport".
     *
     * Status of MultiHFPSupport.
     *
     * @param e8MultiHFPSupport The value which will be set
     */
    inline void setE8MultiHFPSupport (::most_BTSet_fi_types_Extended::T_e8_BTSwitchStatus e8MultiHFPSupport_);

    static const MultiHFPSupportStatus &getDefaultInstance();

private:

    inline void set_has_e8MultiHFPSupport ();

    inline void clear_has_e8MultiHFPSupport ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_BTSet_fi_types_Extended::T_e8_BTSwitchStatus _e8MultiHFPSupport;

};

/**
 * The error message of 'MultiHFPSupport'
 */
class MultiHFPSupportErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  MultiHFPSupportErrorStructure ();

    /**
     * Copy constructor
     */
    inline  MultiHFPSupportErrorStructure (const MultiHFPSupportErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  MultiHFPSupportErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~MultiHFPSupportErrorStructure();

    /**
     * Assignment operator
     */
    inline MultiHFPSupportErrorStructure& operator = (const MultiHFPSupportErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MultiHFPSupportErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MultiHFPSupportErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MultiHFPSupportErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MultiHFPSupportErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const MultiHFPSupportErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'MultiHFPSupport'
 */
class MultiHFPSupportError  : public ::asf::core::Payload {
public:

    enum MultiHFPSupportErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  MultiHFPSupportError ();

   /**
     * Copy constructor
     */
    inline  MultiHFPSupportError (const MultiHFPSupportError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~MultiHFPSupportError();

    /**
     * Assigns a new value to this object.
     */
    inline MultiHFPSupportError& operator = (const MultiHFPSupportError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MultiHFPSupportError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MultiHFPSupportError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MultiHFPSupportError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MultiHFPSupportError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline MultiHFPSupportError::MultiHFPSupportErrorField getField () const;

    inline void setField(MultiHFPSupportError::MultiHFPSupportErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "MultiHFPSupportErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "MultiHFPSupportErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const MultiHFPSupportErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline MultiHFPSupportErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline MultiHFPSupportErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (MultiHFPSupportErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "MultiHFPSupportErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const MultiHFPSupportErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const MultiHFPSupportError &getDefaultInstance();

private:

    inline void cloneData (const MultiHFPSupportError& rhs);

    inline void deleteData ();

    MultiHFPSupportErrorField __field;

    union {
        MultiHFPSupportErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "BTProfilesUsageInfo"
 * This property is used to update the usage of various BT profiles to registered clients.
 * If the BT profiles are only connected but not in use, this list will be empty.
 */
class BTProfilesUsageInfoStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BTProfilesUsageInfoStatus ();

    /**
     * Copy constructor
     */
    inline  BTProfilesUsageInfoStatus (const BTProfilesUsageInfoStatus &rhs);

    /**
     * All fields constructor
     */
    inline  BTProfilesUsageInfoStatus (const ::most_BTSet_fi_types_Extended::T_BTProfilesUsageList& oBTProfilesUsageInfoList_);

    /**
     * Destructor
     */
    inline virtual  ~BTProfilesUsageInfoStatus();

    /**
     * Assignment operator
     */
    inline BTProfilesUsageInfoStatus& operator = (const BTProfilesUsageInfoStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BTProfilesUsageInfoStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BTProfilesUsageInfoStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BTProfilesUsageInfoStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BTProfilesUsageInfoStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "oBTProfilesUsageInfoList"

    static const int kOBTProfilesUsageInfoList = 0;

    /**
     * Clears the field "oBTProfilesUsageInfoList".
     *
     * The field will be set to its default value. The hasOBTProfilesUsageInfoList()
     * method will return false.
     */
    inline void clearOBTProfilesUsageInfoList();

    /**
     * Checks whether the field "oBTProfilesUsageInfoList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOBTProfilesUsageInfoList()). Otherwise it will return false.
     */
    inline bool hasOBTProfilesUsageInfoList () const;

    /**
     * Returns the value of the member "oBTProfilesUsageInfoList".
     *
     * List of Profile usage.
     *
     * @return The value of the field "oBTProfilesUsageInfoList"
     */
    inline const ::most_BTSet_fi_types_Extended::T_BTProfilesUsageList& getOBTProfilesUsageInfoList () const;

    /**
     * Retrieves the value of the field "oBTProfilesUsageInfoList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oBTProfilesUsageInfoList".
     */
    inline ::most_BTSet_fi_types_Extended::T_BTProfilesUsageList& getOBTProfilesUsageInfoListMutable ();

    /**
     * Sets the value of the member "oBTProfilesUsageInfoList".
     *
     * List of Profile usage.
     *
     * @param oBTProfilesUsageInfoList The value which will be set
     */
    inline void setOBTProfilesUsageInfoList (const ::most_BTSet_fi_types_Extended::T_BTProfilesUsageList& oBTProfilesUsageInfoList_);

    static const BTProfilesUsageInfoStatus &getDefaultInstance();

private:

    static const ::std::vector< ::most_BTSet_fi_types_Extended::T_BTProfilesUsageInfoList >& getT_BTProfilesUsageInfoListList_DefaultInstance ();

    inline void set_has_oBTProfilesUsageInfoList ();

    inline void clear_has_oBTProfilesUsageInfoList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_BTSet_fi_types_Extended::T_BTProfilesUsageList _oBTProfilesUsageInfoList;

};

/**
 * The error message of 'BTProfilesUsageInfo'
 */
class BTProfilesUsageInfoErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  BTProfilesUsageInfoErrorStructure ();

    /**
     * Copy constructor
     */
    inline  BTProfilesUsageInfoErrorStructure (const BTProfilesUsageInfoErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  BTProfilesUsageInfoErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~BTProfilesUsageInfoErrorStructure();

    /**
     * Assignment operator
     */
    inline BTProfilesUsageInfoErrorStructure& operator = (const BTProfilesUsageInfoErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BTProfilesUsageInfoErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BTProfilesUsageInfoErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BTProfilesUsageInfoErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BTProfilesUsageInfoErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const BTProfilesUsageInfoErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'BTProfilesUsageInfo'
 */
class BTProfilesUsageInfoError  : public ::asf::core::Payload {
public:

    enum BTProfilesUsageInfoErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  BTProfilesUsageInfoError ();

   /**
     * Copy constructor
     */
    inline  BTProfilesUsageInfoError (const BTProfilesUsageInfoError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~BTProfilesUsageInfoError();

    /**
     * Assigns a new value to this object.
     */
    inline BTProfilesUsageInfoError& operator = (const BTProfilesUsageInfoError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BTProfilesUsageInfoError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BTProfilesUsageInfoError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BTProfilesUsageInfoError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BTProfilesUsageInfoError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline BTProfilesUsageInfoError::BTProfilesUsageInfoErrorField getField () const;

    inline void setField(BTProfilesUsageInfoError::BTProfilesUsageInfoErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "BTProfilesUsageInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "BTProfilesUsageInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const BTProfilesUsageInfoErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline BTProfilesUsageInfoErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline BTProfilesUsageInfoErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (BTProfilesUsageInfoErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "BTProfilesUsageInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const BTProfilesUsageInfoErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const BTProfilesUsageInfoError &getDefaultInstance();

private:

    inline void cloneData (const BTProfilesUsageInfoError& rhs);

    inline void deleteData ();

    BTProfilesUsageInfoErrorField __field;

    union {
        BTProfilesUsageInfoErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "ConflictsDetected"
 * This property is used to update the update the conflicts which arise during a conflict trigger.
 * Client has to resolve the conflicts and inform using interface ResolveConflicts().
 */
class ConflictsDetectedStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConflictsDetectedStatus ();

    /**
     * Copy constructor
     */
    inline  ConflictsDetectedStatus (const ConflictsDetectedStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ConflictsDetectedStatus (::most_BTSet_fi_types_Extended::T_e8_BTConflictTrigger e8ConflictTrigger_, const ::most_BTSet_fi_types_Extended::T_BTConflictInfoList& oBTConflictInfoList_);

    /**
     * Destructor
     */
    inline virtual  ~ConflictsDetectedStatus();

    /**
     * Assignment operator
     */
    inline ConflictsDetectedStatus& operator = (const ConflictsDetectedStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConflictsDetectedStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConflictsDetectedStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConflictsDetectedStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConflictsDetectedStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ConflictTrigger"

    static const int kE8ConflictTrigger = 0;

    /**
     * Clears the field "e8ConflictTrigger".
     *
     * The field will be set to its default value. The hasE8ConflictTrigger()
     * method will return false.
     */
    inline void clearE8ConflictTrigger();

    /**
     * Checks whether the field "e8ConflictTrigger" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ConflictTrigger()). Otherwise it will return false.
     */
    inline bool hasE8ConflictTrigger () const;

    /**
     * Returns the value of the member "e8ConflictTrigger".
     *
     * Provides the trigger for the conflicts.
     *
     * @return The value of the field "e8ConflictTrigger"
     */
    inline ::most_BTSet_fi_types_Extended::T_e8_BTConflictTrigger getE8ConflictTrigger () const;

    /**
     * Sets the value of the member "e8ConflictTrigger".
     *
     * Provides the trigger for the conflicts.
     *
     * @param e8ConflictTrigger The value which will be set
     */
    inline void setE8ConflictTrigger (::most_BTSet_fi_types_Extended::T_e8_BTConflictTrigger e8ConflictTrigger_);

    // API of field "oBTConflictInfoList"

    static const int kOBTConflictInfoList = 1;

    /**
     * Clears the field "oBTConflictInfoList".
     *
     * The field will be set to its default value. The hasOBTConflictInfoList()
     * method will return false.
     */
    inline void clearOBTConflictInfoList();

    /**
     * Checks whether the field "oBTConflictInfoList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOBTConflictInfoList()). Otherwise it will return false.
     */
    inline bool hasOBTConflictInfoList () const;

    /**
     * Returns the value of the member "oBTConflictInfoList".
     *
     * List of Conflicts Info.
     *
     * @return The value of the field "oBTConflictInfoList"
     */
    inline const ::most_BTSet_fi_types_Extended::T_BTConflictInfoList& getOBTConflictInfoList () const;

    /**
     * Retrieves the value of the field "oBTConflictInfoList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oBTConflictInfoList".
     */
    inline ::most_BTSet_fi_types_Extended::T_BTConflictInfoList& getOBTConflictInfoListMutable ();

    /**
     * Sets the value of the member "oBTConflictInfoList".
     *
     * List of Conflicts Info.
     *
     * @param oBTConflictInfoList The value which will be set
     */
    inline void setOBTConflictInfoList (const ::most_BTSet_fi_types_Extended::T_BTConflictInfoList& oBTConflictInfoList_);

    static const ConflictsDetectedStatus &getDefaultInstance();

private:

    static const ::std::vector< ::most_BTSet_fi_types_Extended::T_BTConflictInfo >& getT_BTConflictInfoList_DefaultInstance ();

    inline void set_has_e8ConflictTrigger ();

    inline void clear_has_e8ConflictTrigger ();

    inline void set_has_oBTConflictInfoList ();

    inline void clear_has_oBTConflictInfoList ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::most_BTSet_fi_types_Extended::T_e8_BTConflictTrigger _e8ConflictTrigger;

    ::most_BTSet_fi_types_Extended::T_BTConflictInfoList _oBTConflictInfoList;

};

/**
 * The error message of 'ConflictsDetected'
 */
class ConflictsDetectedErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  ConflictsDetectedErrorStructure ();

    /**
     * Copy constructor
     */
    inline  ConflictsDetectedErrorStructure (const ConflictsDetectedErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  ConflictsDetectedErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~ConflictsDetectedErrorStructure();

    /**
     * Assignment operator
     */
    inline ConflictsDetectedErrorStructure& operator = (const ConflictsDetectedErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConflictsDetectedErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConflictsDetectedErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConflictsDetectedErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConflictsDetectedErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const ConflictsDetectedErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'ConflictsDetected'
 */
class ConflictsDetectedError  : public ::asf::core::Payload {
public:

    enum ConflictsDetectedErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  ConflictsDetectedError ();

   /**
     * Copy constructor
     */
    inline  ConflictsDetectedError (const ConflictsDetectedError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~ConflictsDetectedError();

    /**
     * Assigns a new value to this object.
     */
    inline ConflictsDetectedError& operator = (const ConflictsDetectedError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConflictsDetectedError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConflictsDetectedError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConflictsDetectedError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConflictsDetectedError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline ConflictsDetectedError::ConflictsDetectedErrorField getField () const;

    inline void setField(ConflictsDetectedError::ConflictsDetectedErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "ConflictsDetectedErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "ConflictsDetectedErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ConflictsDetectedErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ConflictsDetectedErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline ConflictsDetectedErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (ConflictsDetectedErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "ConflictsDetectedErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const ConflictsDetectedErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const ConflictsDetectedError &getDefaultInstance();

private:

    inline void cloneData (const ConflictsDetectedError& rhs);

    inline void deleteData ();

    ConflictsDetectedErrorField __field;

    union {
        ConflictsDetectedErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "AutoConnectionStatus"
 * This property is used to update the status of the auto connection.
 * DeviceHandle is vaild only if e8AutoConnectionStatus is IN_PROGRESS
 */
class AutoConnectionStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AutoConnectionStatusStatus ();

    /**
     * Copy constructor
     */
    inline  AutoConnectionStatusStatus (const AutoConnectionStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AutoConnectionStatusStatus (::most_BTSet_fi_types_Extended::T_e8_BTAutoconnectionStatus e8AutoConnectionStatus_, uint8 u8DeviceHandle_);

    /**
     * Destructor
     */
    inline virtual  ~AutoConnectionStatusStatus();

    /**
     * Assignment operator
     */
    inline AutoConnectionStatusStatus& operator = (const AutoConnectionStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AutoConnectionStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AutoConnectionStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AutoConnectionStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AutoConnectionStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8AutoConnectionStatus"

    static const int kE8AutoConnectionStatus = 0;

    /**
     * Clears the field "e8AutoConnectionStatus".
     *
     * The field will be set to its default value. The hasE8AutoConnectionStatus()
     * method will return false.
     */
    inline void clearE8AutoConnectionStatus();

    /**
     * Checks whether the field "e8AutoConnectionStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8AutoConnectionStatus()). Otherwise it will return false.
     */
    inline bool hasE8AutoConnectionStatus () const;

    /**
     * Returns the value of the member "e8AutoConnectionStatus".
     *
     * Provides the status of the autoconnection.
     *
     * @return The value of the field "e8AutoConnectionStatus"
     */
    inline ::most_BTSet_fi_types_Extended::T_e8_BTAutoconnectionStatus getE8AutoConnectionStatus () const;

    /**
     * Sets the value of the member "e8AutoConnectionStatus".
     *
     * Provides the status of the autoconnection.
     *
     * @param e8AutoConnectionStatus The value which will be set
     */
    inline void setE8AutoConnectionStatus (::most_BTSet_fi_types_Extended::T_e8_BTAutoconnectionStatus e8AutoConnectionStatus_);

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 1;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    static const AutoConnectionStatusStatus &getDefaultInstance();

private:

    inline void set_has_e8AutoConnectionStatus ();

    inline void clear_has_e8AutoConnectionStatus ();

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::most_BTSet_fi_types_Extended::T_e8_BTAutoconnectionStatus _e8AutoConnectionStatus;

    uint8 _u8DeviceHandle;

};

/**
 * The error message of 'AutoConnectionStatus'
 */
class AutoConnectionStatusErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  AutoConnectionStatusErrorStructure ();

    /**
     * Copy constructor
     */
    inline  AutoConnectionStatusErrorStructure (const AutoConnectionStatusErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  AutoConnectionStatusErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~AutoConnectionStatusErrorStructure();

    /**
     * Assignment operator
     */
    inline AutoConnectionStatusErrorStructure& operator = (const AutoConnectionStatusErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AutoConnectionStatusErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AutoConnectionStatusErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AutoConnectionStatusErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AutoConnectionStatusErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const AutoConnectionStatusErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'AutoConnectionStatus'
 */
class AutoConnectionStatusError  : public ::asf::core::Payload {
public:

    enum AutoConnectionStatusErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  AutoConnectionStatusError ();

   /**
     * Copy constructor
     */
    inline  AutoConnectionStatusError (const AutoConnectionStatusError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~AutoConnectionStatusError();

    /**
     * Assigns a new value to this object.
     */
    inline AutoConnectionStatusError& operator = (const AutoConnectionStatusError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AutoConnectionStatusError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AutoConnectionStatusError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AutoConnectionStatusError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AutoConnectionStatusError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline AutoConnectionStatusError::AutoConnectionStatusErrorField getField () const;

    inline void setField(AutoConnectionStatusError::AutoConnectionStatusErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "AutoConnectionStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "AutoConnectionStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const AutoConnectionStatusErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline AutoConnectionStatusErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline AutoConnectionStatusErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (AutoConnectionStatusErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "AutoConnectionStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const AutoConnectionStatusErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const AutoConnectionStatusError &getDefaultInstance();

private:

    inline void cloneData (const AutoConnectionStatusError& rhs);

    inline void deleteData ();

    AutoConnectionStatusErrorField __field;

    union {
        AutoConnectionStatusErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "ServiceAvailable"
 * This property is used to update the service availability of BMApp based on the BT SPM State.
 */
class ServiceAvailableStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ServiceAvailableStatus ();

    /**
     * Copy constructor
     */
    inline  ServiceAvailableStatus (const ServiceAvailableStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ServiceAvailableStatus (::most_BTSet_fi_types_Extended::T_e8_BTServiceAvailable e8ServiceAvailable_);

    /**
     * Destructor
     */
    inline virtual  ~ServiceAvailableStatus();

    /**
     * Assignment operator
     */
    inline ServiceAvailableStatus& operator = (const ServiceAvailableStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ServiceAvailableStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ServiceAvailableStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ServiceAvailableStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ServiceAvailableStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ServiceAvailable"

    static const int kE8ServiceAvailable = 0;

    /**
     * Clears the field "e8ServiceAvailable".
     *
     * The field will be set to its default value. The hasE8ServiceAvailable()
     * method will return false.
     */
    inline void clearE8ServiceAvailable();

    /**
     * Checks whether the field "e8ServiceAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ServiceAvailable()). Otherwise it will return false.
     */
    inline bool hasE8ServiceAvailable () const;

    /**
     * Returns the value of the member "e8ServiceAvailable".
     *
     * Provides the status of the BMApp Service.
     * AVAILABLE - BtSystemState is NORMAL/NORMAL_SWITCH_OFF_BT/DISCONNECT and CCA service state is NORMAL.
     * AVAILABLE_RESTRICTED - BtSystemState is BLOCK/OFF and CCA service state is NORMAL.
     * UNAVAILABLE - BtSystemState is BLOCK/OFF and CCA service state is OFF.
     *
     * @return The value of the field "e8ServiceAvailable"
     */
    inline ::most_BTSet_fi_types_Extended::T_e8_BTServiceAvailable getE8ServiceAvailable () const;

    /**
     * Sets the value of the member "e8ServiceAvailable".
     *
     * Provides the status of the BMApp Service.
     * AVAILABLE - BtSystemState is NORMAL/NORMAL_SWITCH_OFF_BT/DISCONNECT and CCA service state is NORMAL.
     * AVAILABLE_RESTRICTED - BtSystemState is BLOCK/OFF and CCA service state is NORMAL.
     * UNAVAILABLE - BtSystemState is BLOCK/OFF and CCA service state is OFF.
     *
     * @param e8ServiceAvailable The value which will be set
     */
    inline void setE8ServiceAvailable (::most_BTSet_fi_types_Extended::T_e8_BTServiceAvailable e8ServiceAvailable_);

    static const ServiceAvailableStatus &getDefaultInstance();

private:

    inline void set_has_e8ServiceAvailable ();

    inline void clear_has_e8ServiceAvailable ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_BTSet_fi_types_Extended::T_e8_BTServiceAvailable _e8ServiceAvailable;

};

/**
 * The error message of 'ServiceAvailable'
 */
class ServiceAvailableErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  ServiceAvailableErrorStructure ();

    /**
     * Copy constructor
     */
    inline  ServiceAvailableErrorStructure (const ServiceAvailableErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  ServiceAvailableErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~ServiceAvailableErrorStructure();

    /**
     * Assignment operator
     */
    inline ServiceAvailableErrorStructure& operator = (const ServiceAvailableErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ServiceAvailableErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ServiceAvailableErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ServiceAvailableErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ServiceAvailableErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const ServiceAvailableErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'ServiceAvailable'
 */
class ServiceAvailableError  : public ::asf::core::Payload {
public:

    enum ServiceAvailableErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  ServiceAvailableError ();

   /**
     * Copy constructor
     */
    inline  ServiceAvailableError (const ServiceAvailableError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~ServiceAvailableError();

    /**
     * Assigns a new value to this object.
     */
    inline ServiceAvailableError& operator = (const ServiceAvailableError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ServiceAvailableError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ServiceAvailableError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ServiceAvailableError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ServiceAvailableError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline ServiceAvailableError::ServiceAvailableErrorField getField () const;

    inline void setField(ServiceAvailableError::ServiceAvailableErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "ServiceAvailableErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "ServiceAvailableErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ServiceAvailableErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ServiceAvailableErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline ServiceAvailableErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (ServiceAvailableErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "ServiceAvailableErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const ServiceAvailableErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const ServiceAvailableError &getDefaultInstance();

private:

    inline void cloneData (const ServiceAvailableError& rhs);

    inline void deleteData ();

    ServiceAvailableErrorField __field;

    union {
        ServiceAvailableErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "VehicleConfiguration"
 * This contains information regarding the vehicle configuration.
 */
class VehicleConfigurationStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VehicleConfigurationStatus ();

    /**
     * Copy constructor
     */
    inline  VehicleConfigurationStatus (const VehicleConfigurationStatus &rhs);

    /**
     * All fields constructor
     */
    inline  VehicleConfigurationStatus (const ::fi_basetypes_most::T_String& sVehicleBTFriendlyName_, const ::fi_basetypes_most::T_String& sVehicleBTAddress_, const ::most_BTSet_fi_types_Extended::T_BTSetSupportedProfiles& oVehicleSupportedProfiles_, const ::most_BTSet_fi_types_Extended::T_BTSetDeviceIdentification& oVehicleIdentification_);

    /**
     * Destructor
     */
    inline virtual  ~VehicleConfigurationStatus();

    /**
     * Assignment operator
     */
    inline VehicleConfigurationStatus& operator = (const VehicleConfigurationStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VehicleConfigurationStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VehicleConfigurationStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VehicleConfigurationStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VehicleConfigurationStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sVehicleBTFriendlyName"

    static const int kSVehicleBTFriendlyName = 0;

    /**
     * Clears the field "sVehicleBTFriendlyName".
     *
     * The field will be set to its default value. The hasSVehicleBTFriendlyName()
     * method will return false.
     */
    inline void clearSVehicleBTFriendlyName();

    /**
     * Checks whether the field "sVehicleBTFriendlyName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSVehicleBTFriendlyName()). Otherwise it will return false.
     */
    inline bool hasSVehicleBTFriendlyName () const;

    /**
     * Returns the value of the member "sVehicleBTFriendlyName".
     *
     * Vechicle Bluetooth Name
     *
     * @return The value of the field "sVehicleBTFriendlyName"
     */
    inline const ::fi_basetypes_most::T_String& getSVehicleBTFriendlyName () const;

    /**
     * Retrieves the value of the field "sVehicleBTFriendlyName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sVehicleBTFriendlyName".
     */
    inline ::fi_basetypes_most::T_String& getSVehicleBTFriendlyNameMutable ();

    /**
     * Sets the value of the member "sVehicleBTFriendlyName".
     *
     * Vechicle Bluetooth Name
     *
     * @param sVehicleBTFriendlyName The value which will be set
     */
    inline void setSVehicleBTFriendlyName (const ::fi_basetypes_most::T_String& sVehicleBTFriendlyName_);

    // API of field "sVehicleBTAddress"

    static const int kSVehicleBTAddress = 1;

    /**
     * Clears the field "sVehicleBTAddress".
     *
     * The field will be set to its default value. The hasSVehicleBTAddress()
     * method will return false.
     */
    inline void clearSVehicleBTAddress();

    /**
     * Checks whether the field "sVehicleBTAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSVehicleBTAddress()). Otherwise it will return false.
     */
    inline bool hasSVehicleBTAddress () const;

    /**
     * Returns the value of the member "sVehicleBTAddress".
     *
     * Bluetooth address of the vehicle.
     *
     * @return The value of the field "sVehicleBTAddress"
     */
    inline const ::fi_basetypes_most::T_String& getSVehicleBTAddress () const;

    /**
     * Retrieves the value of the field "sVehicleBTAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sVehicleBTAddress".
     */
    inline ::fi_basetypes_most::T_String& getSVehicleBTAddressMutable ();

    /**
     * Sets the value of the member "sVehicleBTAddress".
     *
     * Bluetooth address of the vehicle.
     *
     * @param sVehicleBTAddress The value which will be set
     */
    inline void setSVehicleBTAddress (const ::fi_basetypes_most::T_String& sVehicleBTAddress_);

    // API of field "oVehicleSupportedProfiles"

    static const int kOVehicleSupportedProfiles = 2;

    /**
     * Clears the field "oVehicleSupportedProfiles".
     *
     * The field will be set to its default value. The hasOVehicleSupportedProfiles()
     * method will return false.
     */
    inline void clearOVehicleSupportedProfiles();

    /**
     * Checks whether the field "oVehicleSupportedProfiles" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOVehicleSupportedProfiles()). Otherwise it will return false.
     */
    inline bool hasOVehicleSupportedProfiles () const;

    /**
     * Returns the value of the member "oVehicleSupportedProfiles".
     *
     * Bluetooth supported profiles.
     *
     * @return The value of the field "oVehicleSupportedProfiles"
     */
    inline const ::most_BTSet_fi_types_Extended::T_BTSetSupportedProfiles& getOVehicleSupportedProfiles () const;

    /**
     * Retrieves the value of the field "oVehicleSupportedProfiles" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oVehicleSupportedProfiles".
     */
    inline ::most_BTSet_fi_types_Extended::T_BTSetSupportedProfiles& getOVehicleSupportedProfilesMutable ();

    /**
     * Sets the value of the member "oVehicleSupportedProfiles".
     *
     * Bluetooth supported profiles.
     *
     * @param oVehicleSupportedProfiles The value which will be set
     */
    inline void setOVehicleSupportedProfiles (const ::most_BTSet_fi_types_Extended::T_BTSetSupportedProfiles& oVehicleSupportedProfiles_);

    // API of field "oVehicleIdentification"

    static const int kOVehicleIdentification = 3;

    /**
     * Clears the field "oVehicleIdentification".
     *
     * The field will be set to its default value. The hasOVehicleIdentification()
     * method will return false.
     */
    inline void clearOVehicleIdentification();

    /**
     * Checks whether the field "oVehicleIdentification" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOVehicleIdentification()). Otherwise it will return false.
     */
    inline bool hasOVehicleIdentification () const;

    /**
     * Returns the value of the member "oVehicleIdentification".
     *
     * Vehicle Identification Information.
     *
     * @return The value of the field "oVehicleIdentification"
     */
    inline const ::most_BTSet_fi_types_Extended::T_BTSetDeviceIdentification& getOVehicleIdentification () const;

    /**
     * Retrieves the value of the field "oVehicleIdentification" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oVehicleIdentification".
     */
    inline ::most_BTSet_fi_types_Extended::T_BTSetDeviceIdentification& getOVehicleIdentificationMutable ();

    /**
     * Sets the value of the member "oVehicleIdentification".
     *
     * Vehicle Identification Information.
     *
     * @param oVehicleIdentification The value which will be set
     */
    inline void setOVehicleIdentification (const ::most_BTSet_fi_types_Extended::T_BTSetDeviceIdentification& oVehicleIdentification_);

    static const VehicleConfigurationStatus &getDefaultInstance();

private:

    inline void set_has_sVehicleBTFriendlyName ();

    inline void clear_has_sVehicleBTFriendlyName ();

    inline void set_has_sVehicleBTAddress ();

    inline void clear_has_sVehicleBTAddress ();

    inline void set_has_oVehicleSupportedProfiles ();

    inline void clear_has_oVehicleSupportedProfiles ();

    inline void set_has_oVehicleIdentification ();

    inline void clear_has_oVehicleIdentification ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::fi_basetypes_most::T_String _sVehicleBTFriendlyName;

    ::fi_basetypes_most::T_String _sVehicleBTAddress;

    ::most_BTSet_fi_types_Extended::T_BTSetSupportedProfiles _oVehicleSupportedProfiles;

    ::most_BTSet_fi_types_Extended::T_BTSetDeviceIdentification _oVehicleIdentification;

};

/**
 * The error message of 'VehicleConfiguration'
 */
class VehicleConfigurationErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  VehicleConfigurationErrorStructure ();

    /**
     * Copy constructor
     */
    inline  VehicleConfigurationErrorStructure (const VehicleConfigurationErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  VehicleConfigurationErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~VehicleConfigurationErrorStructure();

    /**
     * Assignment operator
     */
    inline VehicleConfigurationErrorStructure& operator = (const VehicleConfigurationErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VehicleConfigurationErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VehicleConfigurationErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VehicleConfigurationErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VehicleConfigurationErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const VehicleConfigurationErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'VehicleConfiguration'
 */
class VehicleConfigurationError  : public ::asf::core::Payload {
public:

    enum VehicleConfigurationErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  VehicleConfigurationError ();

   /**
     * Copy constructor
     */
    inline  VehicleConfigurationError (const VehicleConfigurationError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~VehicleConfigurationError();

    /**
     * Assigns a new value to this object.
     */
    inline VehicleConfigurationError& operator = (const VehicleConfigurationError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VehicleConfigurationError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VehicleConfigurationError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VehicleConfigurationError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VehicleConfigurationError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline VehicleConfigurationError::VehicleConfigurationErrorField getField () const;

    inline void setField(VehicleConfigurationError::VehicleConfigurationErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "VehicleConfigurationErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "VehicleConfigurationErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const VehicleConfigurationErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline VehicleConfigurationErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline VehicleConfigurationErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (VehicleConfigurationErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "VehicleConfigurationErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const VehicleConfigurationErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const VehicleConfigurationError &getDefaultInstance();

private:

    inline void cloneData (const VehicleConfigurationError& rhs);

    inline void deleteData ();

    VehicleConfigurationErrorField __field;

    union {
        VehicleConfigurationErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "GetDeviceInfoExtended"
 * Retrieves specific information about the device such as its Bluetooth address and supported features and profiles.  This function is defined as a Method instead of a Property because HMI controllers are expected to provide the device handle for a specific device when querying for this information.
 */
class GetDeviceInfoExtendedStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetDeviceInfoExtendedStart ();

    /**
     * Copy constructor
     */
    inline  GetDeviceInfoExtendedStart (const GetDeviceInfoExtendedStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetDeviceInfoExtendedStart (uint8 u8DeviceHandle_);

    /**
     * Destructor
     */
    inline virtual  ~GetDeviceInfoExtendedStart();

    /**
     * Assignment operator
     */
    inline GetDeviceInfoExtendedStart& operator = (const GetDeviceInfoExtendedStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetDeviceInfoExtendedStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetDeviceInfoExtendedStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetDeviceInfoExtendedStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetDeviceInfoExtendedStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    static const GetDeviceInfoExtendedStart &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8DeviceHandle;

};

/**
 * The result message of the method "GetDeviceInfoExtended"
 * Retrieves specific information about the device such as its Bluetooth address and supported features and profiles.  This function is defined as a Method instead of a Property because HMI controllers are expected to provide the device handle for a specific device when querying for this information.
 */
class GetDeviceInfoExtendedResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetDeviceInfoExtendedResult ();

    /**
     * Copy constructor
     */
    inline  GetDeviceInfoExtendedResult (const GetDeviceInfoExtendedResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetDeviceInfoExtendedResult (uint8 u8DeviceHandle_, ::most_BTSet_fi_types::T_e8_BTSetMajorDeviceClass e8MajorDeviceClass_, const ::fi_basetypes_most::T_String& sBluetoothDeviceAddress_, const ::most_BTSet_fi_types::T_BTSetBluetoothFeatureSupport& oBluetoothFeatureSupport_, const ::fi_basetypes_most::T_String& sLinkKey_, const ::most_BTSet_fi_types_Extended::T_BTSetSupportedProfiles& oSupportedProfiles_, const ::most_BTSet_fi_types_Extended::T_BTSetDeviceIdentification& oDeviceIdentification_);

    /**
     * Destructor
     */
    inline virtual  ~GetDeviceInfoExtendedResult();

    /**
     * Assignment operator
     */
    inline GetDeviceInfoExtendedResult& operator = (const GetDeviceInfoExtendedResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetDeviceInfoExtendedResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetDeviceInfoExtendedResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetDeviceInfoExtendedResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetDeviceInfoExtendedResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "e8MajorDeviceClass"

    static const int kE8MajorDeviceClass = 1;

    /**
     * Clears the field "e8MajorDeviceClass".
     *
     * The field will be set to its default value. The hasE8MajorDeviceClass()
     * method will return false.
     */
    inline void clearE8MajorDeviceClass();

    /**
     * Checks whether the field "e8MajorDeviceClass" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MajorDeviceClass()). Otherwise it will return false.
     */
    inline bool hasE8MajorDeviceClass () const;

    /**
     * Returns the value of the member "e8MajorDeviceClass".
     *
     * The Bluetooth Class of Device (CoD) obtained from the Bluetooth device during discovery phase of the pairing process.
     *
     * @return The value of the field "e8MajorDeviceClass"
     */
    inline ::most_BTSet_fi_types::T_e8_BTSetMajorDeviceClass getE8MajorDeviceClass () const;

    /**
     * Sets the value of the member "e8MajorDeviceClass".
     *
     * The Bluetooth Class of Device (CoD) obtained from the Bluetooth device during discovery phase of the pairing process.
     *
     * @param e8MajorDeviceClass The value which will be set
     */
    inline void setE8MajorDeviceClass (::most_BTSet_fi_types::T_e8_BTSetMajorDeviceClass e8MajorDeviceClass_);

    // API of field "sBluetoothDeviceAddress"

    static const int kSBluetoothDeviceAddress = 2;

    /**
     * Clears the field "sBluetoothDeviceAddress".
     *
     * The field will be set to its default value. The hasSBluetoothDeviceAddress()
     * method will return false.
     */
    inline void clearSBluetoothDeviceAddress();

    /**
     * Checks whether the field "sBluetoothDeviceAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSBluetoothDeviceAddress()). Otherwise it will return false.
     */
    inline bool hasSBluetoothDeviceAddress () const;

    /**
     * Returns the value of the member "sBluetoothDeviceAddress".
     *
     * Identifies the Bluetooth device address. It is represented as 12 hexidecimal characters.
     *
     * @return The value of the field "sBluetoothDeviceAddress"
     */
    inline const ::fi_basetypes_most::T_String& getSBluetoothDeviceAddress () const;

    /**
     * Retrieves the value of the field "sBluetoothDeviceAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sBluetoothDeviceAddress".
     */
    inline ::fi_basetypes_most::T_String& getSBluetoothDeviceAddressMutable ();

    /**
     * Sets the value of the member "sBluetoothDeviceAddress".
     *
     * Identifies the Bluetooth device address. It is represented as 12 hexidecimal characters.
     *
     * @param sBluetoothDeviceAddress The value which will be set
     */
    inline void setSBluetoothDeviceAddress (const ::fi_basetypes_most::T_String& sBluetoothDeviceAddress_);

    // API of field "oBluetoothFeatureSupport"

    static const int kOBluetoothFeatureSupport = 3;

    /**
     * Clears the field "oBluetoothFeatureSupport".
     *
     * The field will be set to its default value. The hasOBluetoothFeatureSupport()
     * method will return false.
     */
    inline void clearOBluetoothFeatureSupport();

    /**
     * Checks whether the field "oBluetoothFeatureSupport" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOBluetoothFeatureSupport()). Otherwise it will return false.
     */
    inline bool hasOBluetoothFeatureSupport () const;

    /**
     * Returns the value of the member "oBluetoothFeatureSupport".
     *
     * Provides a stream of parameters that identify the features supported by the device.
     *
     * @return The value of the field "oBluetoothFeatureSupport"
     */
    inline const ::most_BTSet_fi_types::T_BTSetBluetoothFeatureSupport& getOBluetoothFeatureSupport () const;

    /**
     * Retrieves the value of the field "oBluetoothFeatureSupport" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oBluetoothFeatureSupport".
     */
    inline ::most_BTSet_fi_types::T_BTSetBluetoothFeatureSupport& getOBluetoothFeatureSupportMutable ();

    /**
     * Sets the value of the member "oBluetoothFeatureSupport".
     *
     * Provides a stream of parameters that identify the features supported by the device.
     *
     * @param oBluetoothFeatureSupport The value which will be set
     */
    inline void setOBluetoothFeatureSupport (const ::most_BTSet_fi_types::T_BTSetBluetoothFeatureSupport& oBluetoothFeatureSupport_);

    // API of field "sLinkKey"

    static const int kSLinkKey = 4;

    /**
     * Clears the field "sLinkKey".
     *
     * The field will be set to its default value. The hasSLinkKey()
     * method will return false.
     */
    inline void clearSLinkKey();

    /**
     * Checks whether the field "sLinkKey" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSLinkKey()). Otherwise it will return false.
     */
    inline bool hasSLinkKey () const;

    /**
     * Returns the value of the member "sLinkKey".
     *
     * Identifies the Bluetooth device Linkkey. It is represented as 32 hexidecimal characters.
     *
     * @return The value of the field "sLinkKey"
     */
    inline const ::fi_basetypes_most::T_String& getSLinkKey () const;

    /**
     * Retrieves the value of the field "sLinkKey" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sLinkKey".
     */
    inline ::fi_basetypes_most::T_String& getSLinkKeyMutable ();

    /**
     * Sets the value of the member "sLinkKey".
     *
     * Identifies the Bluetooth device Linkkey. It is represented as 32 hexidecimal characters.
     *
     * @param sLinkKey The value which will be set
     */
    inline void setSLinkKey (const ::fi_basetypes_most::T_String& sLinkKey_);

    // API of field "oSupportedProfiles"

    static const int kOSupportedProfiles = 5;

    /**
     * Clears the field "oSupportedProfiles".
     *
     * The field will be set to its default value. The hasOSupportedProfiles()
     * method will return false.
     */
    inline void clearOSupportedProfiles();

    /**
     * Checks whether the field "oSupportedProfiles" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOSupportedProfiles()). Otherwise it will return false.
     */
    inline bool hasOSupportedProfiles () const;

    /**
     * Returns the value of the member "oSupportedProfiles".
     *
     * Identifies the Connected Bluetooth device supported profiles.
     *
     * @return The value of the field "oSupportedProfiles"
     */
    inline const ::most_BTSet_fi_types_Extended::T_BTSetSupportedProfiles& getOSupportedProfiles () const;

    /**
     * Retrieves the value of the field "oSupportedProfiles" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oSupportedProfiles".
     */
    inline ::most_BTSet_fi_types_Extended::T_BTSetSupportedProfiles& getOSupportedProfilesMutable ();

    /**
     * Sets the value of the member "oSupportedProfiles".
     *
     * Identifies the Connected Bluetooth device supported profiles.
     *
     * @param oSupportedProfiles The value which will be set
     */
    inline void setOSupportedProfiles (const ::most_BTSet_fi_types_Extended::T_BTSetSupportedProfiles& oSupportedProfiles_);

    // API of field "oDeviceIdentification"

    static const int kODeviceIdentification = 6;

    /**
     * Clears the field "oDeviceIdentification".
     *
     * The field will be set to its default value. The hasODeviceIdentification()
     * method will return false.
     */
    inline void clearODeviceIdentification();

    /**
     * Checks whether the field "oDeviceIdentification" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setODeviceIdentification()). Otherwise it will return false.
     */
    inline bool hasODeviceIdentification () const;

    /**
     * Returns the value of the member "oDeviceIdentification".
     *
     * Identifies the Device specification.
     *
     * @return The value of the field "oDeviceIdentification"
     */
    inline const ::most_BTSet_fi_types_Extended::T_BTSetDeviceIdentification& getODeviceIdentification () const;

    /**
     * Retrieves the value of the field "oDeviceIdentification" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oDeviceIdentification".
     */
    inline ::most_BTSet_fi_types_Extended::T_BTSetDeviceIdentification& getODeviceIdentificationMutable ();

    /**
     * Sets the value of the member "oDeviceIdentification".
     *
     * Identifies the Device specification.
     *
     * @param oDeviceIdentification The value which will be set
     */
    inline void setODeviceIdentification (const ::most_BTSet_fi_types_Extended::T_BTSetDeviceIdentification& oDeviceIdentification_);

    static const GetDeviceInfoExtendedResult &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_e8MajorDeviceClass ();

    inline void clear_has_e8MajorDeviceClass ();

    inline void set_has_sBluetoothDeviceAddress ();

    inline void clear_has_sBluetoothDeviceAddress ();

    inline void set_has_oBluetoothFeatureSupport ();

    inline void clear_has_oBluetoothFeatureSupport ();

    inline void set_has_sLinkKey ();

    inline void clear_has_sLinkKey ();

    inline void set_has_oSupportedProfiles ();

    inline void clear_has_oSupportedProfiles ();

    inline void set_has_oDeviceIdentification ();

    inline void clear_has_oDeviceIdentification ();

    uint32 _has_bits_[ (7 + 31) / 32];

    uint8 _u8DeviceHandle;

    ::most_BTSet_fi_types::T_e8_BTSetMajorDeviceClass _e8MajorDeviceClass;

    ::fi_basetypes_most::T_String _sBluetoothDeviceAddress;

    ::most_BTSet_fi_types::T_BTSetBluetoothFeatureSupport _oBluetoothFeatureSupport;

    ::fi_basetypes_most::T_String _sLinkKey;

    ::most_BTSet_fi_types_Extended::T_BTSetSupportedProfiles _oSupportedProfiles;

    ::most_BTSet_fi_types_Extended::T_BTSetDeviceIdentification _oDeviceIdentification;

};

/**
 * The error message of 'GetDeviceInfoExtended'
 */
class GetDeviceInfoExtendedErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetDeviceInfoExtendedErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetDeviceInfoExtendedErrorStructure (const GetDeviceInfoExtendedErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetDeviceInfoExtendedErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~GetDeviceInfoExtendedErrorStructure();

    /**
     * Assignment operator
     */
    inline GetDeviceInfoExtendedErrorStructure& operator = (const GetDeviceInfoExtendedErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetDeviceInfoExtendedErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetDeviceInfoExtendedErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetDeviceInfoExtendedErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetDeviceInfoExtendedErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const GetDeviceInfoExtendedErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'GetDeviceInfoExtended'
 */
class GetDeviceInfoExtendedError  : public ::asf::core::Payload {
public:

    enum GetDeviceInfoExtendedErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetDeviceInfoExtendedError ();

   /**
     * Copy constructor
     */
    inline  GetDeviceInfoExtendedError (const GetDeviceInfoExtendedError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetDeviceInfoExtendedError();

    /**
     * Assigns a new value to this object.
     */
    inline GetDeviceInfoExtendedError& operator = (const GetDeviceInfoExtendedError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetDeviceInfoExtendedError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetDeviceInfoExtendedError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetDeviceInfoExtendedError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetDeviceInfoExtendedError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetDeviceInfoExtendedError::GetDeviceInfoExtendedErrorField getField () const;

    inline void setField(GetDeviceInfoExtendedError::GetDeviceInfoExtendedErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetDeviceInfoExtendedErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetDeviceInfoExtendedErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetDeviceInfoExtendedErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetDeviceInfoExtendedErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetDeviceInfoExtendedErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetDeviceInfoExtendedErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetDeviceInfoExtendedErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetDeviceInfoExtendedErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetDeviceInfoExtendedError &getDefaultInstance();

private:

    inline void cloneData (const GetDeviceInfoExtendedError& rhs);

    inline void deleteData ();

    GetDeviceInfoExtendedErrorField __field;

    union {
        GetDeviceInfoExtendedErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The result message of the method "StopRingtone"
 * Stops the ringtone that is currently being played.
 */
class StopRingtoneResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StopRingtoneResult ();

    /**
     * Copy constructor
     */
    inline  StopRingtoneResult (const StopRingtoneResult &rhs);

    /**
     * All fields constructor
     */
    inline  StopRingtoneResult (bool bStopPlayRingtoneResult_);

    /**
     * Destructor
     */
    inline virtual  ~StopRingtoneResult();

    /**
     * Assignment operator
     */
    inline StopRingtoneResult& operator = (const StopRingtoneResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StopRingtoneResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StopRingtoneResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StopRingtoneResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StopRingtoneResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bStopPlayRingtoneResult"

    static const int kBStopPlayRingtoneResult = 0;

    /**
     * Clears the field "bStopPlayRingtoneResult".
     *
     * The field will be set to its default value. The hasBStopPlayRingtoneResult()
     * method will return false.
     */
    inline void clearBStopPlayRingtoneResult();

    /**
     * Checks whether the field "bStopPlayRingtoneResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBStopPlayRingtoneResult()). Otherwise it will return false.
     */
    inline bool hasBStopPlayRingtoneResult () const;

    /**
     * Returns the value of the member "bStopPlayRingtoneResult".
     *
     * The StopPlayRingtoneResult indicates the result of the StopPlayRingtone. If StopPlayRingtoneResult is true then the ringtone played is successfully stopped. If StopPlayRingtoneResult is false then the attempt made to stop ringtone failed.
     *
     * @return The value of the field "bStopPlayRingtoneResult"
     */
    inline bool getBStopPlayRingtoneResult () const;

    /**
     * Sets the value of the member "bStopPlayRingtoneResult".
     *
     * The StopPlayRingtoneResult indicates the result of the StopPlayRingtone. If StopPlayRingtoneResult is true then the ringtone played is successfully stopped. If StopPlayRingtoneResult is false then the attempt made to stop ringtone failed.
     *
     * @param bStopPlayRingtoneResult The value which will be set
     */
    inline void setBStopPlayRingtoneResult (bool bStopPlayRingtoneResult_);

    static const StopRingtoneResult &getDefaultInstance();

private:

    inline void set_has_bStopPlayRingtoneResult ();

    inline void clear_has_bStopPlayRingtoneResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bStopPlayRingtoneResult;

};

/**
 * The error message of 'StopRingtone'
 */
class StopRingtoneErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  StopRingtoneErrorStructure ();

    /**
     * Copy constructor
     */
    inline  StopRingtoneErrorStructure (const StopRingtoneErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  StopRingtoneErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~StopRingtoneErrorStructure();

    /**
     * Assignment operator
     */
    inline StopRingtoneErrorStructure& operator = (const StopRingtoneErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StopRingtoneErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StopRingtoneErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StopRingtoneErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StopRingtoneErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const StopRingtoneErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'StopRingtone'
 */
class StopRingtoneError  : public ::asf::core::Payload {
public:

    enum StopRingtoneErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  StopRingtoneError ();

   /**
     * Copy constructor
     */
    inline  StopRingtoneError (const StopRingtoneError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~StopRingtoneError();

    /**
     * Assigns a new value to this object.
     */
    inline StopRingtoneError& operator = (const StopRingtoneError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StopRingtoneError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StopRingtoneError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StopRingtoneError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StopRingtoneError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline StopRingtoneError::StopRingtoneErrorField getField () const;

    inline void setField(StopRingtoneError::StopRingtoneErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "StopRingtoneErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "StopRingtoneErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const StopRingtoneErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline StopRingtoneErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline StopRingtoneErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (StopRingtoneErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "StopRingtoneErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const StopRingtoneErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const StopRingtoneError &getDefaultInstance();

private:

    inline void cloneData (const StopRingtoneError& rhs);

    inline void deleteData ();

    StopRingtoneErrorField __field;

    union {
        StopRingtoneErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "ScanBluetoothDevices"
 * Start or Stop Inquiry Scanning for Bluetooth Devices.
 */
class ScanBluetoothDevicesStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ScanBluetoothDevicesStart ();

    /**
     * Copy constructor
     */
    inline  ScanBluetoothDevicesStart (const ScanBluetoothDevicesStart &rhs);

    /**
     * All fields constructor
     */
    inline  ScanBluetoothDevicesStart (bool bScan_);

    /**
     * Destructor
     */
    inline virtual  ~ScanBluetoothDevicesStart();

    /**
     * Assignment operator
     */
    inline ScanBluetoothDevicesStart& operator = (const ScanBluetoothDevicesStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ScanBluetoothDevicesStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ScanBluetoothDevicesStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ScanBluetoothDevicesStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ScanBluetoothDevicesStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bScan"

    static const int kBScan = 0;

    /**
     * Clears the field "bScan".
     *
     * The field will be set to its default value. The hasBScan()
     * method will return false.
     */
    inline void clearBScan();

    /**
     * Checks whether the field "bScan" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBScan()). Otherwise it will return false.
     */
    inline bool hasBScan () const;

    /**
     * Returns the value of the member "bScan".
     *
     * Start Inquiry Scan if bScan is 0x01. Stop Inquiry Scan if bScan is 0x00.
     *
     * @return The value of the field "bScan"
     */
    inline bool getBScan () const;

    /**
     * Sets the value of the member "bScan".
     *
     * Start Inquiry Scan if bScan is 0x01. Stop Inquiry Scan if bScan is 0x00.
     *
     * @param bScan The value which will be set
     */
    inline void setBScan (bool bScan_);

    static const ScanBluetoothDevicesStart &getDefaultInstance();

private:

    inline void set_has_bScan ();

    inline void clear_has_bScan ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bScan;

};

/**
 * The result message of the method "ScanBluetoothDevices"
 * Start or Stop Inquiry Scanning for Bluetooth Devices.
 */
class ScanBluetoothDevicesResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ScanBluetoothDevicesResult ();

    /**
     * Copy constructor
     */
    inline  ScanBluetoothDevicesResult (const ScanBluetoothDevicesResult &rhs);

    /**
     * All fields constructor
     */
    inline  ScanBluetoothDevicesResult (::most_BTSet_fi_types_Extended::T_e8_BTSetScanningState e8ScanningState_);

    /**
     * Destructor
     */
    inline virtual  ~ScanBluetoothDevicesResult();

    /**
     * Assignment operator
     */
    inline ScanBluetoothDevicesResult& operator = (const ScanBluetoothDevicesResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ScanBluetoothDevicesResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ScanBluetoothDevicesResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ScanBluetoothDevicesResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ScanBluetoothDevicesResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ScanningState"

    static const int kE8ScanningState = 0;

    /**
     * Clears the field "e8ScanningState".
     *
     * The field will be set to its default value. The hasE8ScanningState()
     * method will return false.
     */
    inline void clearE8ScanningState();

    /**
     * Checks whether the field "e8ScanningState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ScanningState()). Otherwise it will return false.
     */
    inline bool hasE8ScanningState () const;

    /**
     * Returns the value of the member "e8ScanningState".
     *
     * Provides the current scanning state of the Inquiry procedure.
     *
     * @return The value of the field "e8ScanningState"
     */
    inline ::most_BTSet_fi_types_Extended::T_e8_BTSetScanningState getE8ScanningState () const;

    /**
     * Sets the value of the member "e8ScanningState".
     *
     * Provides the current scanning state of the Inquiry procedure.
     *
     * @param e8ScanningState The value which will be set
     */
    inline void setE8ScanningState (::most_BTSet_fi_types_Extended::T_e8_BTSetScanningState e8ScanningState_);

    static const ScanBluetoothDevicesResult &getDefaultInstance();

private:

    inline void set_has_e8ScanningState ();

    inline void clear_has_e8ScanningState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_BTSet_fi_types_Extended::T_e8_BTSetScanningState _e8ScanningState;

};

/**
 * The error message of 'ScanBluetoothDevices'
 */
class ScanBluetoothDevicesErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  ScanBluetoothDevicesErrorStructure ();

    /**
     * Copy constructor
     */
    inline  ScanBluetoothDevicesErrorStructure (const ScanBluetoothDevicesErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  ScanBluetoothDevicesErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~ScanBluetoothDevicesErrorStructure();

    /**
     * Assignment operator
     */
    inline ScanBluetoothDevicesErrorStructure& operator = (const ScanBluetoothDevicesErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ScanBluetoothDevicesErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ScanBluetoothDevicesErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ScanBluetoothDevicesErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ScanBluetoothDevicesErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const ScanBluetoothDevicesErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'ScanBluetoothDevices'
 */
class ScanBluetoothDevicesError  : public ::asf::core::Payload {
public:

    enum ScanBluetoothDevicesErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  ScanBluetoothDevicesError ();

   /**
     * Copy constructor
     */
    inline  ScanBluetoothDevicesError (const ScanBluetoothDevicesError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~ScanBluetoothDevicesError();

    /**
     * Assigns a new value to this object.
     */
    inline ScanBluetoothDevicesError& operator = (const ScanBluetoothDevicesError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ScanBluetoothDevicesError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ScanBluetoothDevicesError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ScanBluetoothDevicesError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ScanBluetoothDevicesError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline ScanBluetoothDevicesError::ScanBluetoothDevicesErrorField getField () const;

    inline void setField(ScanBluetoothDevicesError::ScanBluetoothDevicesErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "ScanBluetoothDevicesErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "ScanBluetoothDevicesErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ScanBluetoothDevicesErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ScanBluetoothDevicesErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline ScanBluetoothDevicesErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (ScanBluetoothDevicesErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "ScanBluetoothDevicesErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const ScanBluetoothDevicesErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const ScanBluetoothDevicesError &getDefaultInstance();

private:

    inline void cloneData (const ScanBluetoothDevicesError& rhs);

    inline void deleteData ();

    ScanBluetoothDevicesErrorField __field;

    union {
        ScanBluetoothDevicesErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "ConnectBluetoothProfile"
 * Provides profile based connection for the paired device.
 */
class ConnectBluetoothProfileStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConnectBluetoothProfileStart ();

    /**
     * Copy constructor
     */
    inline  ConnectBluetoothProfileStart (const ConnectBluetoothProfileStart &rhs);

    /**
     * All fields constructor
     */
    inline  ConnectBluetoothProfileStart (uint8 u8DeviceHandle_, const ::most_BTSet_fi_types_Extended::T_BTServiceType& oServiceType_);

    /**
     * Destructor
     */
    inline virtual  ~ConnectBluetoothProfileStart();

    /**
     * Assignment operator
     */
    inline ConnectBluetoothProfileStart& operator = (const ConnectBluetoothProfileStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConnectBluetoothProfileStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConnectBluetoothProfileStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConnectBluetoothProfileStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConnectBluetoothProfileStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "oServiceType"

    static const int kOServiceType = 1;

    /**
     * Clears the field "oServiceType".
     *
     * The field will be set to its default value. The hasOServiceType()
     * method will return false.
     */
    inline void clearOServiceType();

    /**
     * Checks whether the field "oServiceType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOServiceType()). Otherwise it will return false.
     */
    inline bool hasOServiceType () const;

    /**
     * Returns the value of the member "oServiceType".
     *
     * Provides a stream of parameters that identifies which are all the profiles needs to be connected for the paired device.
     *
     * @return The value of the field "oServiceType"
     */
    inline const ::most_BTSet_fi_types_Extended::T_BTServiceType& getOServiceType () const;

    /**
     * Retrieves the value of the field "oServiceType" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oServiceType".
     */
    inline ::most_BTSet_fi_types_Extended::T_BTServiceType& getOServiceTypeMutable ();

    /**
     * Sets the value of the member "oServiceType".
     *
     * Provides a stream of parameters that identifies which are all the profiles needs to be connected for the paired device.
     *
     * @param oServiceType The value which will be set
     */
    inline void setOServiceType (const ::most_BTSet_fi_types_Extended::T_BTServiceType& oServiceType_);

    static const ConnectBluetoothProfileStart &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_oServiceType ();

    inline void clear_has_oServiceType ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8DeviceHandle;

    ::most_BTSet_fi_types_Extended::T_BTServiceType _oServiceType;

};

/**
 * The result message of the method "ConnectBluetoothProfile"
 * Provides profile based connection for the paired device.
 */
class ConnectBluetoothProfileResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConnectBluetoothProfileResult ();

    /**
     * Copy constructor
     */
    inline  ConnectBluetoothProfileResult (const ConnectBluetoothProfileResult &rhs);

    /**
     * All fields constructor
     */
    inline  ConnectBluetoothProfileResult (uint8 u8DeviceHandle_, const ::most_BTSet_fi_types_Extended::T_BTServiceType& oProfileConnectionStatus_);

    /**
     * Destructor
     */
    inline virtual  ~ConnectBluetoothProfileResult();

    /**
     * Assignment operator
     */
    inline ConnectBluetoothProfileResult& operator = (const ConnectBluetoothProfileResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConnectBluetoothProfileResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConnectBluetoothProfileResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConnectBluetoothProfileResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConnectBluetoothProfileResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "oProfileConnectionStatus"

    static const int kOProfileConnectionStatus = 1;

    /**
     * Clears the field "oProfileConnectionStatus".
     *
     * The field will be set to its default value. The hasOProfileConnectionStatus()
     * method will return false.
     */
    inline void clearOProfileConnectionStatus();

    /**
     * Checks whether the field "oProfileConnectionStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOProfileConnectionStatus()). Otherwise it will return false.
     */
    inline bool hasOProfileConnectionStatus () const;

    /**
     * Returns the value of the member "oProfileConnectionStatus".
     *
     * Provides a stream of parameters that identifies which are all the profiles are connected for the particular device.
     *
     * @return The value of the field "oProfileConnectionStatus"
     */
    inline const ::most_BTSet_fi_types_Extended::T_BTServiceType& getOProfileConnectionStatus () const;

    /**
     * Retrieves the value of the field "oProfileConnectionStatus" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oProfileConnectionStatus".
     */
    inline ::most_BTSet_fi_types_Extended::T_BTServiceType& getOProfileConnectionStatusMutable ();

    /**
     * Sets the value of the member "oProfileConnectionStatus".
     *
     * Provides a stream of parameters that identifies which are all the profiles are connected for the particular device.
     *
     * @param oProfileConnectionStatus The value which will be set
     */
    inline void setOProfileConnectionStatus (const ::most_BTSet_fi_types_Extended::T_BTServiceType& oProfileConnectionStatus_);

    static const ConnectBluetoothProfileResult &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_oProfileConnectionStatus ();

    inline void clear_has_oProfileConnectionStatus ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8DeviceHandle;

    ::most_BTSet_fi_types_Extended::T_BTServiceType _oProfileConnectionStatus;

};

/**
 * The error message of 'ConnectBluetoothProfile'
 */
class ConnectBluetoothProfileErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  ConnectBluetoothProfileErrorStructure ();

    /**
     * Copy constructor
     */
    inline  ConnectBluetoothProfileErrorStructure (const ConnectBluetoothProfileErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  ConnectBluetoothProfileErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~ConnectBluetoothProfileErrorStructure();

    /**
     * Assignment operator
     */
    inline ConnectBluetoothProfileErrorStructure& operator = (const ConnectBluetoothProfileErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConnectBluetoothProfileErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConnectBluetoothProfileErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConnectBluetoothProfileErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConnectBluetoothProfileErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const ConnectBluetoothProfileErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'ConnectBluetoothProfile'
 */
class ConnectBluetoothProfileError  : public ::asf::core::Payload {
public:

    enum ConnectBluetoothProfileErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  ConnectBluetoothProfileError ();

   /**
     * Copy constructor
     */
    inline  ConnectBluetoothProfileError (const ConnectBluetoothProfileError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~ConnectBluetoothProfileError();

    /**
     * Assigns a new value to this object.
     */
    inline ConnectBluetoothProfileError& operator = (const ConnectBluetoothProfileError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConnectBluetoothProfileError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConnectBluetoothProfileError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConnectBluetoothProfileError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConnectBluetoothProfileError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline ConnectBluetoothProfileError::ConnectBluetoothProfileErrorField getField () const;

    inline void setField(ConnectBluetoothProfileError::ConnectBluetoothProfileErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "ConnectBluetoothProfileErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "ConnectBluetoothProfileErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ConnectBluetoothProfileErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ConnectBluetoothProfileErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline ConnectBluetoothProfileErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (ConnectBluetoothProfileErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "ConnectBluetoothProfileErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const ConnectBluetoothProfileErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const ConnectBluetoothProfileError &getDefaultInstance();

private:

    inline void cloneData (const ConnectBluetoothProfileError& rhs);

    inline void deleteData ();

    ConnectBluetoothProfileErrorField __field;

    union {
        ConnectBluetoothProfileErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "DisconnectBluetoothProfile"
 * Provides profile based disconnection for the connected device.
 */
class DisconnectBluetoothProfileStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DisconnectBluetoothProfileStart ();

    /**
     * Copy constructor
     */
    inline  DisconnectBluetoothProfileStart (const DisconnectBluetoothProfileStart &rhs);

    /**
     * All fields constructor
     */
    inline  DisconnectBluetoothProfileStart (uint8 u8DeviceHandle_, const ::most_BTSet_fi_types_Extended::T_BTServiceType& oServiceType_);

    /**
     * Destructor
     */
    inline virtual  ~DisconnectBluetoothProfileStart();

    /**
     * Assignment operator
     */
    inline DisconnectBluetoothProfileStart& operator = (const DisconnectBluetoothProfileStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DisconnectBluetoothProfileStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DisconnectBluetoothProfileStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DisconnectBluetoothProfileStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DisconnectBluetoothProfileStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "oServiceType"

    static const int kOServiceType = 1;

    /**
     * Clears the field "oServiceType".
     *
     * The field will be set to its default value. The hasOServiceType()
     * method will return false.
     */
    inline void clearOServiceType();

    /**
     * Checks whether the field "oServiceType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOServiceType()). Otherwise it will return false.
     */
    inline bool hasOServiceType () const;

    /**
     * Returns the value of the member "oServiceType".
     *
     * Provides a stream of parameters that identifies which are all the profiles needs to be disconnected for the connected device.
     *
     * @return The value of the field "oServiceType"
     */
    inline const ::most_BTSet_fi_types_Extended::T_BTServiceType& getOServiceType () const;

    /**
     * Retrieves the value of the field "oServiceType" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oServiceType".
     */
    inline ::most_BTSet_fi_types_Extended::T_BTServiceType& getOServiceTypeMutable ();

    /**
     * Sets the value of the member "oServiceType".
     *
     * Provides a stream of parameters that identifies which are all the profiles needs to be disconnected for the connected device.
     *
     * @param oServiceType The value which will be set
     */
    inline void setOServiceType (const ::most_BTSet_fi_types_Extended::T_BTServiceType& oServiceType_);

    static const DisconnectBluetoothProfileStart &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_oServiceType ();

    inline void clear_has_oServiceType ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8DeviceHandle;

    ::most_BTSet_fi_types_Extended::T_BTServiceType _oServiceType;

};

/**
 * The result message of the method "DisconnectBluetoothProfile"
 * Provides profile based disconnection for the connected device.
 */
class DisconnectBluetoothProfileResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DisconnectBluetoothProfileResult ();

    /**
     * Copy constructor
     */
    inline  DisconnectBluetoothProfileResult (const DisconnectBluetoothProfileResult &rhs);

    /**
     * All fields constructor
     */
    inline  DisconnectBluetoothProfileResult (uint8 u8DeviceHandle_, const ::most_BTSet_fi_types_Extended::T_BTServiceType& oProfileDisconnectionStatus_);

    /**
     * Destructor
     */
    inline virtual  ~DisconnectBluetoothProfileResult();

    /**
     * Assignment operator
     */
    inline DisconnectBluetoothProfileResult& operator = (const DisconnectBluetoothProfileResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DisconnectBluetoothProfileResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DisconnectBluetoothProfileResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DisconnectBluetoothProfileResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DisconnectBluetoothProfileResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the up to 10 devices that can be paired.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "oProfileDisconnectionStatus"

    static const int kOProfileDisconnectionStatus = 1;

    /**
     * Clears the field "oProfileDisconnectionStatus".
     *
     * The field will be set to its default value. The hasOProfileDisconnectionStatus()
     * method will return false.
     */
    inline void clearOProfileDisconnectionStatus();

    /**
     * Checks whether the field "oProfileDisconnectionStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOProfileDisconnectionStatus()). Otherwise it will return false.
     */
    inline bool hasOProfileDisconnectionStatus () const;

    /**
     * Returns the value of the member "oProfileDisconnectionStatus".
     *
     * Provides a stream of parameters that identifies which are all the profiles are disconnected for the particular device.
     *
     * @return The value of the field "oProfileDisconnectionStatus"
     */
    inline const ::most_BTSet_fi_types_Extended::T_BTServiceType& getOProfileDisconnectionStatus () const;

    /**
     * Retrieves the value of the field "oProfileDisconnectionStatus" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oProfileDisconnectionStatus".
     */
    inline ::most_BTSet_fi_types_Extended::T_BTServiceType& getOProfileDisconnectionStatusMutable ();

    /**
     * Sets the value of the member "oProfileDisconnectionStatus".
     *
     * Provides a stream of parameters that identifies which are all the profiles are disconnected for the particular device.
     *
     * @param oProfileDisconnectionStatus The value which will be set
     */
    inline void setOProfileDisconnectionStatus (const ::most_BTSet_fi_types_Extended::T_BTServiceType& oProfileDisconnectionStatus_);

    static const DisconnectBluetoothProfileResult &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_oProfileDisconnectionStatus ();

    inline void clear_has_oProfileDisconnectionStatus ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8DeviceHandle;

    ::most_BTSet_fi_types_Extended::T_BTServiceType _oProfileDisconnectionStatus;

};

/**
 * The error message of 'DisconnectBluetoothProfile'
 */
class DisconnectBluetoothProfileErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DisconnectBluetoothProfileErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DisconnectBluetoothProfileErrorStructure (const DisconnectBluetoothProfileErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DisconnectBluetoothProfileErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~DisconnectBluetoothProfileErrorStructure();

    /**
     * Assignment operator
     */
    inline DisconnectBluetoothProfileErrorStructure& operator = (const DisconnectBluetoothProfileErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DisconnectBluetoothProfileErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DisconnectBluetoothProfileErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DisconnectBluetoothProfileErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DisconnectBluetoothProfileErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const DisconnectBluetoothProfileErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'DisconnectBluetoothProfile'
 */
class DisconnectBluetoothProfileError  : public ::asf::core::Payload {
public:

    enum DisconnectBluetoothProfileErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DisconnectBluetoothProfileError ();

   /**
     * Copy constructor
     */
    inline  DisconnectBluetoothProfileError (const DisconnectBluetoothProfileError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DisconnectBluetoothProfileError();

    /**
     * Assigns a new value to this object.
     */
    inline DisconnectBluetoothProfileError& operator = (const DisconnectBluetoothProfileError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DisconnectBluetoothProfileError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DisconnectBluetoothProfileError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DisconnectBluetoothProfileError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DisconnectBluetoothProfileError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DisconnectBluetoothProfileError::DisconnectBluetoothProfileErrorField getField () const;

    inline void setField(DisconnectBluetoothProfileError::DisconnectBluetoothProfileErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DisconnectBluetoothProfileErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DisconnectBluetoothProfileErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DisconnectBluetoothProfileErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DisconnectBluetoothProfileErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DisconnectBluetoothProfileErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DisconnectBluetoothProfileErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DisconnectBluetoothProfileErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DisconnectBluetoothProfileErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DisconnectBluetoothProfileError &getDefaultInstance();

private:

    inline void cloneData (const DisconnectBluetoothProfileError& rhs);

    inline void deleteData ();

    DisconnectBluetoothProfileErrorField __field;

    union {
        DisconnectBluetoothProfileErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SendPairingRequest"
 * Start or Cancel Pairing Request to a particular remote device
 */
class SendPairingRequestStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendPairingRequestStart ();

    /**
     * Copy constructor
     */
    inline  SendPairingRequestStart (const SendPairingRequestStart &rhs);

    /**
     * All fields constructor
     */
    inline  SendPairingRequestStart (bool bPairingRequest_, const ::fi_basetypes_most::T_String& sRemoteDeviceAddress_);

    /**
     * Destructor
     */
    inline virtual  ~SendPairingRequestStart();

    /**
     * Assignment operator
     */
    inline SendPairingRequestStart& operator = (const SendPairingRequestStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendPairingRequestStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendPairingRequestStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendPairingRequestStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendPairingRequestStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bPairingRequest"

    static const int kBPairingRequest = 0;

    /**
     * Clears the field "bPairingRequest".
     *
     * The field will be set to its default value. The hasBPairingRequest()
     * method will return false.
     */
    inline void clearBPairingRequest();

    /**
     * Checks whether the field "bPairingRequest" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBPairingRequest()). Otherwise it will return false.
     */
    inline bool hasBPairingRequest () const;

    /**
     * Returns the value of the member "bPairingRequest".
     *
     * Start Pairing to the remote device if bPairingRequest is 0x01. Cancel Pairing to the remote device if bPairingRequest is 0x00.
     *
     * @return The value of the field "bPairingRequest"
     */
    inline bool getBPairingRequest () const;

    /**
     * Sets the value of the member "bPairingRequest".
     *
     * Start Pairing to the remote device if bPairingRequest is 0x01. Cancel Pairing to the remote device if bPairingRequest is 0x00.
     *
     * @param bPairingRequest The value which will be set
     */
    inline void setBPairingRequest (bool bPairingRequest_);

    // API of field "sRemoteDeviceAddress"

    static const int kSRemoteDeviceAddress = 1;

    /**
     * Clears the field "sRemoteDeviceAddress".
     *
     * The field will be set to its default value. The hasSRemoteDeviceAddress()
     * method will return false.
     */
    inline void clearSRemoteDeviceAddress();

    /**
     * Checks whether the field "sRemoteDeviceAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSRemoteDeviceAddress()). Otherwise it will return false.
     */
    inline bool hasSRemoteDeviceAddress () const;

    /**
     * Returns the value of the member "sRemoteDeviceAddress".
     *
     * Identifies the remote bluetooth device address to which Start/Cancel pairing is to be issued. It is represented as 12 hexidecimal characters.
     *
     * @return The value of the field "sRemoteDeviceAddress"
     */
    inline const ::fi_basetypes_most::T_String& getSRemoteDeviceAddress () const;

    /**
     * Retrieves the value of the field "sRemoteDeviceAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sRemoteDeviceAddress".
     */
    inline ::fi_basetypes_most::T_String& getSRemoteDeviceAddressMutable ();

    /**
     * Sets the value of the member "sRemoteDeviceAddress".
     *
     * Identifies the remote bluetooth device address to which Start/Cancel pairing is to be issued. It is represented as 12 hexidecimal characters.
     *
     * @param sRemoteDeviceAddress The value which will be set
     */
    inline void setSRemoteDeviceAddress (const ::fi_basetypes_most::T_String& sRemoteDeviceAddress_);

    static const SendPairingRequestStart &getDefaultInstance();

private:

    inline void set_has_bPairingRequest ();

    inline void clear_has_bPairingRequest ();

    inline void set_has_sRemoteDeviceAddress ();

    inline void clear_has_sRemoteDeviceAddress ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bPairingRequest;

    ::fi_basetypes_most::T_String _sRemoteDeviceAddress;

};

/**
 * The result message of the method "SendPairingRequest"
 * Start or Cancel Pairing Request to a particular remote device
 */
class SendPairingRequestResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendPairingRequestResult ();

    /**
     * Copy constructor
     */
    inline  SendPairingRequestResult (const SendPairingRequestResult &rhs);

    /**
     * All fields constructor
     */
    inline  SendPairingRequestResult (::most_BTSet_fi_types_Extended::T_e8_BTSetPairingResult e8PairingResult_);

    /**
     * Destructor
     */
    inline virtual  ~SendPairingRequestResult();

    /**
     * Assignment operator
     */
    inline SendPairingRequestResult& operator = (const SendPairingRequestResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendPairingRequestResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendPairingRequestResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendPairingRequestResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendPairingRequestResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8PairingResult"

    static const int kE8PairingResult = 0;

    /**
     * Clears the field "e8PairingResult".
     *
     * The field will be set to its default value. The hasE8PairingResult()
     * method will return false.
     */
    inline void clearE8PairingResult();

    /**
     * Checks whether the field "e8PairingResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PairingResult()). Otherwise it will return false.
     */
    inline bool hasE8PairingResult () const;

    /**
     * Returns the value of the member "e8PairingResult".
     *
     * Provides the current scanning state of the Inquiry procedure.
     *
     * @return The value of the field "e8PairingResult"
     */
    inline ::most_BTSet_fi_types_Extended::T_e8_BTSetPairingResult getE8PairingResult () const;

    /**
     * Sets the value of the member "e8PairingResult".
     *
     * Provides the current scanning state of the Inquiry procedure.
     *
     * @param e8PairingResult The value which will be set
     */
    inline void setE8PairingResult (::most_BTSet_fi_types_Extended::T_e8_BTSetPairingResult e8PairingResult_);

    static const SendPairingRequestResult &getDefaultInstance();

private:

    inline void set_has_e8PairingResult ();

    inline void clear_has_e8PairingResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::most_BTSet_fi_types_Extended::T_e8_BTSetPairingResult _e8PairingResult;

};

/**
 * The error message of 'SendPairingRequest'
 */
class SendPairingRequestErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SendPairingRequestErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SendPairingRequestErrorStructure (const SendPairingRequestErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SendPairingRequestErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~SendPairingRequestErrorStructure();

    /**
     * Assignment operator
     */
    inline SendPairingRequestErrorStructure& operator = (const SendPairingRequestErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendPairingRequestErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendPairingRequestErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendPairingRequestErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendPairingRequestErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const SendPairingRequestErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'SendPairingRequest'
 */
class SendPairingRequestError  : public ::asf::core::Payload {
public:

    enum SendPairingRequestErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SendPairingRequestError ();

   /**
     * Copy constructor
     */
    inline  SendPairingRequestError (const SendPairingRequestError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SendPairingRequestError();

    /**
     * Assigns a new value to this object.
     */
    inline SendPairingRequestError& operator = (const SendPairingRequestError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendPairingRequestError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendPairingRequestError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendPairingRequestError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendPairingRequestError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SendPairingRequestError::SendPairingRequestErrorField getField () const;

    inline void setField(SendPairingRequestError::SendPairingRequestErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SendPairingRequestErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SendPairingRequestErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SendPairingRequestErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SendPairingRequestErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SendPairingRequestErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SendPairingRequestErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SendPairingRequestErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SendPairingRequestErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SendPairingRequestError &getDefaultInstance();

private:

    inline void cloneData (const SendPairingRequestError& rhs);

    inline void deleteData ();

    SendPairingRequestErrorField __field;

    union {
        SendPairingRequestErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SwitchBTLocalMode"
 * This is a method to change property BtLocalMode. Each mode (pairable, connectable, discoverable) can be switched ON or OFF separately.
 * If no change should be done for a mode that parameter should be set to AUTO.
 * It is not sufficient to look at the response to this method, check the PairableMode property.
 */
class SwitchBTLocalModeStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SwitchBTLocalModeStart ();

    /**
     * Copy constructor
     */
    inline  SwitchBTLocalModeStart (const SwitchBTLocalModeStart &rhs);

    /**
     * All fields constructor
     */
    inline  SwitchBTLocalModeStart (::most_BTSet_fi_types_Extended::T_BTLocalModeType Pairable_, ::most_BTSet_fi_types_Extended::T_BTLocalModeType Connectable_, const ::fi_basetypes_most::T_String& sBTAddress_);

    /**
     * Destructor
     */
    inline virtual  ~SwitchBTLocalModeStart();

    /**
     * Assignment operator
     */
    inline SwitchBTLocalModeStart& operator = (const SwitchBTLocalModeStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SwitchBTLocalModeStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SwitchBTLocalModeStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SwitchBTLocalModeStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SwitchBTLocalModeStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Pairable"

    static const int kPairable = 0;

    /**
     * Clears the field "Pairable".
     *
     * The field will be set to its default value. The hasPairable()
     * method will return false.
     */
    inline void clearPairable();

    /**
     * Checks whether the field "Pairable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPairable()). Otherwise it will return false.
     */
    inline bool hasPairable () const;

    /**
     * Returns the value of the member "Pairable".
     *
     * This is used to enable or disable the Pairable request. Inputs may be On/Off/Auto
     *
     * @return The value of the field "Pairable"
     */
    inline ::most_BTSet_fi_types_Extended::T_BTLocalModeType getPairable () const;

    /**
     * Sets the value of the member "Pairable".
     *
     * This is used to enable or disable the Pairable request. Inputs may be On/Off/Auto
     *
     * @param Pairable The value which will be set
     */
    inline void setPairable (::most_BTSet_fi_types_Extended::T_BTLocalModeType Pairable_);

    // API of field "Connectable"

    static const int kConnectable = 1;

    /**
     * Clears the field "Connectable".
     *
     * The field will be set to its default value. The hasConnectable()
     * method will return false.
     */
    inline void clearConnectable();

    /**
     * Checks whether the field "Connectable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConnectable()). Otherwise it will return false.
     */
    inline bool hasConnectable () const;

    /**
     * Returns the value of the member "Connectable".
     *
     * This is used to enable or disable the Connatable request.Inputs may be On/Off/Auto
     *
     * @return The value of the field "Connectable"
     */
    inline ::most_BTSet_fi_types_Extended::T_BTLocalModeType getConnectable () const;

    /**
     * Sets the value of the member "Connectable".
     *
     * This is used to enable or disable the Connatable request.Inputs may be On/Off/Auto
     *
     * @param Connectable The value which will be set
     */
    inline void setConnectable (::most_BTSet_fi_types_Extended::T_BTLocalModeType Connectable_);

    // API of field "sBTAddress"

    static const int kSBTAddress = 2;

    /**
     * Clears the field "sBTAddress".
     *
     * The field will be set to its default value. The hasSBTAddress()
     * method will return false.
     */
    inline void clearSBTAddress();

    /**
     * Checks whether the field "sBTAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSBTAddress()). Otherwise it will return false.
     */
    inline bool hasSBTAddress () const;

    /**
     * Returns the value of the member "sBTAddress".
     *
     * Device address of the requested device
     *
     * @return The value of the field "sBTAddress"
     */
    inline const ::fi_basetypes_most::T_String& getSBTAddress () const;

    /**
     * Retrieves the value of the field "sBTAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sBTAddress".
     */
    inline ::fi_basetypes_most::T_String& getSBTAddressMutable ();

    /**
     * Sets the value of the member "sBTAddress".
     *
     * Device address of the requested device
     *
     * @param sBTAddress The value which will be set
     */
    inline void setSBTAddress (const ::fi_basetypes_most::T_String& sBTAddress_);

    static const SwitchBTLocalModeStart &getDefaultInstance();

private:

    inline void set_has_Pairable ();

    inline void clear_has_Pairable ();

    inline void set_has_Connectable ();

    inline void clear_has_Connectable ();

    inline void set_has_sBTAddress ();

    inline void clear_has_sBTAddress ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::most_BTSet_fi_types_Extended::T_BTLocalModeType _Pairable;

    ::most_BTSet_fi_types_Extended::T_BTLocalModeType _Connectable;

    ::fi_basetypes_most::T_String _sBTAddress;

};

/**
 * The result message of the method "SwitchBTLocalMode"
 * This is a method to change property BtLocalMode. Each mode (pairable, connectable, discoverable) can be switched ON or OFF separately.
 * If no change should be done for a mode that parameter should be set to AUTO.
 * It is not sufficient to look at the response to this method, check the PairableMode property.
 */
class SwitchBTLocalModeResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SwitchBTLocalModeResult ();

    /**
     * Copy constructor
     */
    inline  SwitchBTLocalModeResult (const SwitchBTLocalModeResult &rhs);

    /**
     * All fields constructor
     */
    inline  SwitchBTLocalModeResult (bool bResult_);

    /**
     * Destructor
     */
    inline virtual  ~SwitchBTLocalModeResult();

    /**
     * Assignment operator
     */
    inline SwitchBTLocalModeResult& operator = (const SwitchBTLocalModeResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SwitchBTLocalModeResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SwitchBTLocalModeResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SwitchBTLocalModeResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SwitchBTLocalModeResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bResult"

    static const int kBResult = 0;

    /**
     * Clears the field "bResult".
     *
     * The field will be set to its default value. The hasBResult()
     * method will return false.
     */
    inline void clearBResult();

    /**
     * Checks whether the field "bResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBResult()). Otherwise it will return false.
     */
    inline bool hasBResult () const;

    /**
     * Returns the value of the member "bResult".
     *
     * SUCCESS : The Local mode switch request is received and the action will be taken on this request and the result will be notified through PairableMode Property.
     * ERROR :The request will not be processed right now.
     *
     * @return The value of the field "bResult"
     */
    inline bool getBResult () const;

    /**
     * Sets the value of the member "bResult".
     *
     * SUCCESS : The Local mode switch request is received and the action will be taken on this request and the result will be notified through PairableMode Property.
     * ERROR :The request will not be processed right now.
     *
     * @param bResult The value which will be set
     */
    inline void setBResult (bool bResult_);

    static const SwitchBTLocalModeResult &getDefaultInstance();

private:

    inline void set_has_bResult ();

    inline void clear_has_bResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bResult;

};

/**
 * The error message of 'SwitchBTLocalMode'
 */
class SwitchBTLocalModeErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SwitchBTLocalModeErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SwitchBTLocalModeErrorStructure (const SwitchBTLocalModeErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SwitchBTLocalModeErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~SwitchBTLocalModeErrorStructure();

    /**
     * Assignment operator
     */
    inline SwitchBTLocalModeErrorStructure& operator = (const SwitchBTLocalModeErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SwitchBTLocalModeErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SwitchBTLocalModeErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SwitchBTLocalModeErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SwitchBTLocalModeErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const SwitchBTLocalModeErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'SwitchBTLocalMode'
 */
class SwitchBTLocalModeError  : public ::asf::core::Payload {
public:

    enum SwitchBTLocalModeErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SwitchBTLocalModeError ();

   /**
     * Copy constructor
     */
    inline  SwitchBTLocalModeError (const SwitchBTLocalModeError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SwitchBTLocalModeError();

    /**
     * Assigns a new value to this object.
     */
    inline SwitchBTLocalModeError& operator = (const SwitchBTLocalModeError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SwitchBTLocalModeError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SwitchBTLocalModeError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SwitchBTLocalModeError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SwitchBTLocalModeError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SwitchBTLocalModeError::SwitchBTLocalModeErrorField getField () const;

    inline void setField(SwitchBTLocalModeError::SwitchBTLocalModeErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SwitchBTLocalModeErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SwitchBTLocalModeErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SwitchBTLocalModeErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SwitchBTLocalModeErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SwitchBTLocalModeErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SwitchBTLocalModeErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SwitchBTLocalModeErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SwitchBTLocalModeErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SwitchBTLocalModeError &getDefaultInstance();

private:

    inline void cloneData (const SwitchBTLocalModeError& rhs);

    inline void deleteData ();

    SwitchBTLocalModeErrorField __field;

    union {
        SwitchBTLocalModeErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "StartAutoConnectSequence"
 * This is a method to start/stop AutoConnect strategy based on user request.
 * If any device is currently connected , it shall be disconnected and AutoConnect strategy shall be started.
 * Device Connection is notified via the DeviceList/DeviceListExtended property.
 */
class StartAutoConnectSequenceStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartAutoConnectSequenceStart ();

    /**
     * Copy constructor
     */
    inline  StartAutoConnectSequenceStart (const StartAutoConnectSequenceStart &rhs);

    /**
     * All fields constructor
     */
    inline  StartAutoConnectSequenceStart (bool bStartAutoConnect_);

    /**
     * Destructor
     */
    inline virtual  ~StartAutoConnectSequenceStart();

    /**
     * Assignment operator
     */
    inline StartAutoConnectSequenceStart& operator = (const StartAutoConnectSequenceStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartAutoConnectSequenceStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartAutoConnectSequenceStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartAutoConnectSequenceStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartAutoConnectSequenceStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bStartAutoConnect"

    static const int kBStartAutoConnect = 0;

    /**
     * Clears the field "bStartAutoConnect".
     *
     * The field will be set to its default value. The hasBStartAutoConnect()
     * method will return false.
     */
    inline void clearBStartAutoConnect();

    /**
     * Checks whether the field "bStartAutoConnect" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBStartAutoConnect()). Otherwise it will return false.
     */
    inline bool hasBStartAutoConnect () const;

    /**
     * Returns the value of the member "bStartAutoConnect".
     *
     * This is used to start/stop AutoConnect strategy. This Parameter may take values On/Off
     *
     * @return The value of the field "bStartAutoConnect"
     */
    inline bool getBStartAutoConnect () const;

    /**
     * Sets the value of the member "bStartAutoConnect".
     *
     * This is used to start/stop AutoConnect strategy. This Parameter may take values On/Off
     *
     * @param bStartAutoConnect The value which will be set
     */
    inline void setBStartAutoConnect (bool bStartAutoConnect_);

    static const StartAutoConnectSequenceStart &getDefaultInstance();

private:

    inline void set_has_bStartAutoConnect ();

    inline void clear_has_bStartAutoConnect ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bStartAutoConnect;

};

/**
 * The result message of the method "StartAutoConnectSequence"
 * This is a method to start/stop AutoConnect strategy based on user request.
 * If any device is currently connected , it shall be disconnected and AutoConnect strategy shall be started.
 * Device Connection is notified via the DeviceList/DeviceListExtended property.
 */
class StartAutoConnectSequenceResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartAutoConnectSequenceResult ();

    /**
     * Copy constructor
     */
    inline  StartAutoConnectSequenceResult (const StartAutoConnectSequenceResult &rhs);

    /**
     * All fields constructor
     */
    inline  StartAutoConnectSequenceResult (bool bResult_);

    /**
     * Destructor
     */
    inline virtual  ~StartAutoConnectSequenceResult();

    /**
     * Assignment operator
     */
    inline StartAutoConnectSequenceResult& operator = (const StartAutoConnectSequenceResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartAutoConnectSequenceResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartAutoConnectSequenceResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartAutoConnectSequenceResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartAutoConnectSequenceResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bResult"

    static const int kBResult = 0;

    /**
     * Clears the field "bResult".
     *
     * The field will be set to its default value. The hasBResult()
     * method will return false.
     */
    inline void clearBResult();

    /**
     * Checks whether the field "bResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBResult()). Otherwise it will return false.
     */
    inline bool hasBResult () const;

    /**
     * Returns the value of the member "bResult".
     *
     * SUCCESS : The request for StartAutoConnectSequence shall be processed by FBlock
     * ERROR :   The request shall not be processed right now.
     *
     * @return The value of the field "bResult"
     */
    inline bool getBResult () const;

    /**
     * Sets the value of the member "bResult".
     *
     * SUCCESS : The request for StartAutoConnectSequence shall be processed by FBlock
     * ERROR :   The request shall not be processed right now.
     *
     * @param bResult The value which will be set
     */
    inline void setBResult (bool bResult_);

    static const StartAutoConnectSequenceResult &getDefaultInstance();

private:

    inline void set_has_bResult ();

    inline void clear_has_bResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bResult;

};

/**
 * The error message of 'StartAutoConnectSequence'
 */
class StartAutoConnectSequenceErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  StartAutoConnectSequenceErrorStructure ();

    /**
     * Copy constructor
     */
    inline  StartAutoConnectSequenceErrorStructure (const StartAutoConnectSequenceErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  StartAutoConnectSequenceErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~StartAutoConnectSequenceErrorStructure();

    /**
     * Assignment operator
     */
    inline StartAutoConnectSequenceErrorStructure& operator = (const StartAutoConnectSequenceErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartAutoConnectSequenceErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartAutoConnectSequenceErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartAutoConnectSequenceErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartAutoConnectSequenceErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const StartAutoConnectSequenceErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'StartAutoConnectSequence'
 */
class StartAutoConnectSequenceError  : public ::asf::core::Payload {
public:

    enum StartAutoConnectSequenceErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  StartAutoConnectSequenceError ();

   /**
     * Copy constructor
     */
    inline  StartAutoConnectSequenceError (const StartAutoConnectSequenceError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~StartAutoConnectSequenceError();

    /**
     * Assigns a new value to this object.
     */
    inline StartAutoConnectSequenceError& operator = (const StartAutoConnectSequenceError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartAutoConnectSequenceError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartAutoConnectSequenceError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartAutoConnectSequenceError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartAutoConnectSequenceError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline StartAutoConnectSequenceError::StartAutoConnectSequenceErrorField getField () const;

    inline void setField(StartAutoConnectSequenceError::StartAutoConnectSequenceErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "StartAutoConnectSequenceErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "StartAutoConnectSequenceErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const StartAutoConnectSequenceErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline StartAutoConnectSequenceErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline StartAutoConnectSequenceErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (StartAutoConnectSequenceErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "StartAutoConnectSequenceErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const StartAutoConnectSequenceErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const StartAutoConnectSequenceError &getDefaultInstance();

private:

    inline void cloneData (const StartAutoConnectSequenceError& rhs);

    inline void deleteData ();

    StartAutoConnectSequenceErrorField __field;

    union {
        StartAutoConnectSequenceErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "ConnectSPPService"
 * This is a method to get a RFComm for a device when requested.For this to happen, the device for which the RFComm is requested should be in connected state and
 * should have a valid device handle.
 */
class ConnectSPPServiceStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConnectSPPServiceStart ();

    /**
     * Copy constructor
     */
    inline  ConnectSPPServiceStart (const ConnectSPPServiceStart &rhs);

    /**
     * All fields constructor
     */
    inline  ConnectSPPServiceStart (uint8 u8DeviceHandle_, const ::fi_basetypes_most::T_String& szUUID_);

    /**
     * Destructor
     */
    inline virtual  ~ConnectSPPServiceStart();

    /**
     * Assignment operator
     */
    inline ConnectSPPServiceStart& operator = (const ConnectSPPServiceStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConnectSPPServiceStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConnectSPPServiceStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConnectSPPServiceStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConnectSPPServiceStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the device, up to 10 devices that can be paired.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the device, up to 10 devices that can be paired.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "szUUID"

    static const int kSzUUID = 1;

    /**
     * Clears the field "szUUID".
     *
     * The field will be set to its default value. The hasSzUUID()
     * method will return false.
     */
    inline void clearSzUUID();

    /**
     * Checks whether the field "szUUID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzUUID()). Otherwise it will return false.
     */
    inline bool hasSzUUID () const;

    /**
     * Returns the value of the member "szUUID".
     *
     * The UUID for the Device handle, for which the RFCommID is been requested.
     *
     * @return The value of the field "szUUID"
     */
    inline const ::fi_basetypes_most::T_String& getSzUUID () const;

    /**
     * Retrieves the value of the field "szUUID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szUUID".
     */
    inline ::fi_basetypes_most::T_String& getSzUUIDMutable ();

    /**
     * Sets the value of the member "szUUID".
     *
     * The UUID for the Device handle, for which the RFCommID is been requested.
     *
     * @param szUUID The value which will be set
     */
    inline void setSzUUID (const ::fi_basetypes_most::T_String& szUUID_);

    static const ConnectSPPServiceStart &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_szUUID ();

    inline void clear_has_szUUID ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8DeviceHandle;

    ::fi_basetypes_most::T_String _szUUID;

};

/**
 * The result message of the method "ConnectSPPService"
 * This is a method to get a RFComm for a device when requested.For this to happen, the device for which the RFComm is requested should be in connected state and
 * should have a valid device handle.
 */
class ConnectSPPServiceResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConnectSPPServiceResult ();

    /**
     * Copy constructor
     */
    inline  ConnectSPPServiceResult (const ConnectSPPServiceResult &rhs);

    /**
     * All fields constructor
     */
    inline  ConnectSPPServiceResult (bool bConnectSPPService_);

    /**
     * Destructor
     */
    inline virtual  ~ConnectSPPServiceResult();

    /**
     * Assignment operator
     */
    inline ConnectSPPServiceResult& operator = (const ConnectSPPServiceResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConnectSPPServiceResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConnectSPPServiceResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConnectSPPServiceResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConnectSPPServiceResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bConnectSPPService"

    static const int kBConnectSPPService = 0;

    /**
     * Clears the field "bConnectSPPService".
     *
     * The field will be set to its default value. The hasBConnectSPPService()
     * method will return false.
     */
    inline void clearBConnectSPPService();

    /**
     * Checks whether the field "bConnectSPPService" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBConnectSPPService()). Otherwise it will return false.
     */
    inline bool hasBConnectSPPService () const;

    /**
     * Returns the value of the member "bConnectSPPService".
     *
     * Tells whether the request for RFcommID can be processed or not
     *
     * @return The value of the field "bConnectSPPService"
     */
    inline bool getBConnectSPPService () const;

    /**
     * Sets the value of the member "bConnectSPPService".
     *
     * Tells whether the request for RFcommID can be processed or not
     *
     * @param bConnectSPPService The value which will be set
     */
    inline void setBConnectSPPService (bool bConnectSPPService_);

    static const ConnectSPPServiceResult &getDefaultInstance();

private:

    inline void set_has_bConnectSPPService ();

    inline void clear_has_bConnectSPPService ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bConnectSPPService;

};

/**
 * The error message of 'ConnectSPPService'
 */
class ConnectSPPServiceErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  ConnectSPPServiceErrorStructure ();

    /**
     * Copy constructor
     */
    inline  ConnectSPPServiceErrorStructure (const ConnectSPPServiceErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  ConnectSPPServiceErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~ConnectSPPServiceErrorStructure();

    /**
     * Assignment operator
     */
    inline ConnectSPPServiceErrorStructure& operator = (const ConnectSPPServiceErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConnectSPPServiceErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConnectSPPServiceErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConnectSPPServiceErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConnectSPPServiceErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const ConnectSPPServiceErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'ConnectSPPService'
 */
class ConnectSPPServiceError  : public ::asf::core::Payload {
public:

    enum ConnectSPPServiceErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  ConnectSPPServiceError ();

   /**
     * Copy constructor
     */
    inline  ConnectSPPServiceError (const ConnectSPPServiceError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~ConnectSPPServiceError();

    /**
     * Assigns a new value to this object.
     */
    inline ConnectSPPServiceError& operator = (const ConnectSPPServiceError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConnectSPPServiceError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConnectSPPServiceError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConnectSPPServiceError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConnectSPPServiceError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline ConnectSPPServiceError::ConnectSPPServiceErrorField getField () const;

    inline void setField(ConnectSPPServiceError::ConnectSPPServiceErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "ConnectSPPServiceErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "ConnectSPPServiceErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ConnectSPPServiceErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ConnectSPPServiceErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline ConnectSPPServiceErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (ConnectSPPServiceErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "ConnectSPPServiceErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const ConnectSPPServiceErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const ConnectSPPServiceError &getDefaultInstance();

private:

    inline void cloneData (const ConnectSPPServiceError& rhs);

    inline void deleteData ();

    ConnectSPPServiceErrorField __field;

    union {
        ConnectSPPServiceErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SetBluetoothLimitationMode"
 * This method shall be used to change a limitation/restriction setting w.r.t. Bluetooth behaviour.
 */
class SetBluetoothLimitationModeStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetBluetoothLimitationModeStart ();

    /**
     * Copy constructor
     */
    inline  SetBluetoothLimitationModeStart (const SetBluetoothLimitationModeStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetBluetoothLimitationModeStart (const ::fi_basetypes_most::T_String& sBdAddress_, const ::fi_basetypes_most::T_String& sBdDeviceName_, ::most_BTSet_fi_types_Extended::T_e8_BTTechnology e8Technology_, ::most_BTSet_fi_types_Extended::T_e8_BTCommunicationChannel e8CommunicationChannel_, ::most_BTSet_fi_types_Extended::T_e8_BTLimitationAction e8Action_);

    /**
     * Destructor
     */
    inline virtual  ~SetBluetoothLimitationModeStart();

    /**
     * Assignment operator
     */
    inline SetBluetoothLimitationModeStart& operator = (const SetBluetoothLimitationModeStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetBluetoothLimitationModeStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetBluetoothLimitationModeStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetBluetoothLimitationModeStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetBluetoothLimitationModeStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sBdAddress"

    static const int kSBdAddress = 0;

    /**
     * Clears the field "sBdAddress".
     *
     * The field will be set to its default value. The hasSBdAddress()
     * method will return false.
     */
    inline void clearSBdAddress();

    /**
     * Checks whether the field "sBdAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSBdAddress()). Otherwise it will return false.
     */
    inline bool hasSBdAddress () const;

    /**
     * Returns the value of the member "sBdAddress".
     *
     * Bluetooth device address. In special cases (address not known) this parameter can be an empty string.
     *
     * @return The value of the field "sBdAddress"
     */
    inline const ::fi_basetypes_most::T_String& getSBdAddress () const;

    /**
     * Retrieves the value of the field "sBdAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sBdAddress".
     */
    inline ::fi_basetypes_most::T_String& getSBdAddressMutable ();

    /**
     * Sets the value of the member "sBdAddress".
     *
     * Bluetooth device address. In special cases (address not known) this parameter can be an empty string.
     *
     * @param sBdAddress The value which will be set
     */
    inline void setSBdAddress (const ::fi_basetypes_most::T_String& sBdAddress_);

    // API of field "sBdDeviceName"

    static const int kSBdDeviceName = 1;

    /**
     * Clears the field "sBdDeviceName".
     *
     * The field will be set to its default value. The hasSBdDeviceName()
     * method will return false.
     */
    inline void clearSBdDeviceName();

    /**
     * Checks whether the field "sBdDeviceName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSBdDeviceName()). Otherwise it will return false.
     */
    inline bool hasSBdDeviceName () const;

    /**
     * Returns the value of the member "sBdDeviceName".
     *
     * Bluetooth device name is an optional parameter and should be used when BT address is not available.
     * In cases (name not known, BT address is available) this parameter should be an empty string.
     *
     * @return The value of the field "sBdDeviceName"
     */
    inline const ::fi_basetypes_most::T_String& getSBdDeviceName () const;

    /**
     * Retrieves the value of the field "sBdDeviceName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sBdDeviceName".
     */
    inline ::fi_basetypes_most::T_String& getSBdDeviceNameMutable ();

    /**
     * Sets the value of the member "sBdDeviceName".
     *
     * Bluetooth device name is an optional parameter and should be used when BT address is not available.
     * In cases (name not known, BT address is available) this parameter should be an empty string.
     *
     * @param sBdDeviceName The value which will be set
     */
    inline void setSBdDeviceName (const ::fi_basetypes_most::T_String& sBdDeviceName_);

    // API of field "e8Technology"

    static const int kE8Technology = 2;

    /**
     * Clears the field "e8Technology".
     *
     * The field will be set to its default value. The hasE8Technology()
     * method will return false.
     */
    inline void clearE8Technology();

    /**
     * Checks whether the field "e8Technology" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Technology()). Otherwise it will return false.
     */
    inline bool hasE8Technology () const;

    /**
     * Returns the value of the member "e8Technology".
     *
     * Technology that specifies the limitation/restriction.
     *
     * @return The value of the field "e8Technology"
     */
    inline ::most_BTSet_fi_types_Extended::T_e8_BTTechnology getE8Technology () const;

    /**
     * Sets the value of the member "e8Technology".
     *
     * Technology that specifies the limitation/restriction.
     *
     * @param e8Technology The value which will be set
     */
    inline void setE8Technology (::most_BTSet_fi_types_Extended::T_e8_BTTechnology e8Technology_);

    // API of field "e8CommunicationChannel"

    static const int kE8CommunicationChannel = 3;

    /**
     * Clears the field "e8CommunicationChannel".
     *
     * The field will be set to its default value. The hasE8CommunicationChannel()
     * method will return false.
     */
    inline void clearE8CommunicationChannel();

    /**
     * Checks whether the field "e8CommunicationChannel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8CommunicationChannel()). Otherwise it will return false.
     */
    inline bool hasE8CommunicationChannel () const;

    /**
     * Returns the value of the member "e8CommunicationChannel".
     *
     * Communication channel that is used by the technology.
     *
     * @return The value of the field "e8CommunicationChannel"
     */
    inline ::most_BTSet_fi_types_Extended::T_e8_BTCommunicationChannel getE8CommunicationChannel () const;

    /**
     * Sets the value of the member "e8CommunicationChannel".
     *
     * Communication channel that is used by the technology.
     *
     * @param e8CommunicationChannel The value which will be set
     */
    inline void setE8CommunicationChannel (::most_BTSet_fi_types_Extended::T_e8_BTCommunicationChannel e8CommunicationChannel_);

    // API of field "e8Action"

    static const int kE8Action = 4;

    /**
     * Clears the field "e8Action".
     *
     * The field will be set to its default value. The hasE8Action()
     * method will return false.
     */
    inline void clearE8Action();

    /**
     * Checks whether the field "e8Action" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Action()). Otherwise it will return false.
     */
    inline bool hasE8Action () const;

    /**
     * Returns the value of the member "e8Action".
     *
     * Requested limitation action.
     *
     * @return The value of the field "e8Action"
     */
    inline ::most_BTSet_fi_types_Extended::T_e8_BTLimitationAction getE8Action () const;

    /**
     * Sets the value of the member "e8Action".
     *
     * Requested limitation action.
     *
     * @param e8Action The value which will be set
     */
    inline void setE8Action (::most_BTSet_fi_types_Extended::T_e8_BTLimitationAction e8Action_);

    static const SetBluetoothLimitationModeStart &getDefaultInstance();

private:

    inline void set_has_sBdAddress ();

    inline void clear_has_sBdAddress ();

    inline void set_has_sBdDeviceName ();

    inline void clear_has_sBdDeviceName ();

    inline void set_has_e8Technology ();

    inline void clear_has_e8Technology ();

    inline void set_has_e8CommunicationChannel ();

    inline void clear_has_e8CommunicationChannel ();

    inline void set_has_e8Action ();

    inline void clear_has_e8Action ();

    uint32 _has_bits_[ (5 + 31) / 32];

    ::fi_basetypes_most::T_String _sBdAddress;

    ::fi_basetypes_most::T_String _sBdDeviceName;

    ::most_BTSet_fi_types_Extended::T_e8_BTTechnology _e8Technology;

    ::most_BTSet_fi_types_Extended::T_e8_BTCommunicationChannel _e8CommunicationChannel;

    ::most_BTSet_fi_types_Extended::T_e8_BTLimitationAction _e8Action;

};

/**
 * The result message of the method "SetBluetoothLimitationMode"
 * This method shall be used to change a limitation/restriction setting w.r.t. Bluetooth behaviour.
 */
class SetBluetoothLimitationModeResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetBluetoothLimitationModeResult ();

    /**
     * Copy constructor
     */
    inline  SetBluetoothLimitationModeResult (const SetBluetoothLimitationModeResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetBluetoothLimitationModeResult (bool bResult_);

    /**
     * Destructor
     */
    inline virtual  ~SetBluetoothLimitationModeResult();

    /**
     * Assignment operator
     */
    inline SetBluetoothLimitationModeResult& operator = (const SetBluetoothLimitationModeResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetBluetoothLimitationModeResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetBluetoothLimitationModeResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetBluetoothLimitationModeResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetBluetoothLimitationModeResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bResult"

    static const int kBResult = 0;

    /**
     * Clears the field "bResult".
     *
     * The field will be set to its default value. The hasBResult()
     * method will return false.
     */
    inline void clearBResult();

    /**
     * Checks whether the field "bResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBResult()). Otherwise it will return false.
     */
    inline bool hasBResult () const;

    /**
     * Returns the value of the member "bResult".
     *
     * <p>True: Requested limitation action was accepted and will be processed. End of the sequence shall be derived from update of property BluetoothLimitationMode.</p>
     * <p>False: Requested limitation action was not accepted. No update of property BluetoothLimitationMode will happen for requested action.</p>
     *
     * @return The value of the field "bResult"
     */
    inline bool getBResult () const;

    /**
     * Sets the value of the member "bResult".
     *
     * <p>True: Requested limitation action was accepted and will be processed. End of the sequence shall be derived from update of property BluetoothLimitationMode.</p>
     * <p>False: Requested limitation action was not accepted. No update of property BluetoothLimitationMode will happen for requested action.</p>
     *
     * @param bResult The value which will be set
     */
    inline void setBResult (bool bResult_);

    static const SetBluetoothLimitationModeResult &getDefaultInstance();

private:

    inline void set_has_bResult ();

    inline void clear_has_bResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bResult;

};

/**
 * The error message of 'SetBluetoothLimitationMode'
 */
class SetBluetoothLimitationModeErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetBluetoothLimitationModeErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetBluetoothLimitationModeErrorStructure (const SetBluetoothLimitationModeErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetBluetoothLimitationModeErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~SetBluetoothLimitationModeErrorStructure();

    /**
     * Assignment operator
     */
    inline SetBluetoothLimitationModeErrorStructure& operator = (const SetBluetoothLimitationModeErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetBluetoothLimitationModeErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetBluetoothLimitationModeErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetBluetoothLimitationModeErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetBluetoothLimitationModeErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo.
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo.
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const SetBluetoothLimitationModeErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'SetBluetoothLimitationMode'
 */
class SetBluetoothLimitationModeError  : public ::asf::core::Payload {
public:

    enum SetBluetoothLimitationModeErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetBluetoothLimitationModeError ();

   /**
     * Copy constructor
     */
    inline  SetBluetoothLimitationModeError (const SetBluetoothLimitationModeError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetBluetoothLimitationModeError();

    /**
     * Assigns a new value to this object.
     */
    inline SetBluetoothLimitationModeError& operator = (const SetBluetoothLimitationModeError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetBluetoothLimitationModeError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetBluetoothLimitationModeError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetBluetoothLimitationModeError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetBluetoothLimitationModeError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetBluetoothLimitationModeError::SetBluetoothLimitationModeErrorField getField () const;

    inline void setField(SetBluetoothLimitationModeError::SetBluetoothLimitationModeErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetBluetoothLimitationModeErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetBluetoothLimitationModeErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetBluetoothLimitationModeErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetBluetoothLimitationModeErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetBluetoothLimitationModeErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetBluetoothLimitationModeErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetBluetoothLimitationModeErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetBluetoothLimitationModeErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetBluetoothLimitationModeError &getDefaultInstance();

private:

    inline void cloneData (const SetBluetoothLimitationModeError& rhs);

    inline void deleteData ();

    SetBluetoothLimitationModeErrorField __field;

    union {
        SetBluetoothLimitationModeErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SwitchBluetoothOnOffExtended"
 * This function is Extended method of SwitchBluetoothOnOff which has an additional parameter bSuppressAutoConnection
 */
class SwitchBluetoothOnOffExtendedStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SwitchBluetoothOnOffExtendedStart ();

    /**
     * Copy constructor
     */
    inline  SwitchBluetoothOnOffExtendedStart (const SwitchBluetoothOnOffExtendedStart &rhs);

    /**
     * All fields constructor
     */
    inline  SwitchBluetoothOnOffExtendedStart (bool bBTOnOff_, bool bSuppressAutoConnection_);

    /**
     * Destructor
     */
    inline virtual  ~SwitchBluetoothOnOffExtendedStart();

    /**
     * Assignment operator
     */
    inline SwitchBluetoothOnOffExtendedStart& operator = (const SwitchBluetoothOnOffExtendedStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SwitchBluetoothOnOffExtendedStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SwitchBluetoothOnOffExtendedStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SwitchBluetoothOnOffExtendedStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SwitchBluetoothOnOffExtendedStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bBTOnOff"

    static const int kBBTOnOff = 0;

    /**
     * Clears the field "bBTOnOff".
     *
     * The field will be set to its default value. The hasBBTOnOff()
     * method will return false.
     */
    inline void clearBBTOnOff();

    /**
     * Checks whether the field "bBTOnOff" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBBTOnOff()). Otherwise it will return false.
     */
    inline bool hasBBTOnOff () const;

    /**
     * Returns the value of the member "bBTOnOff".
     *
     * Switch Bluetooth ON or Switch Bluetooth OFF .
     *
     * @return The value of the field "bBTOnOff"
     */
    inline bool getBBTOnOff () const;

    /**
     * Sets the value of the member "bBTOnOff".
     *
     * Switch Bluetooth ON or Switch Bluetooth OFF .
     *
     * @param bBTOnOff The value which will be set
     */
    inline void setBBTOnOff (bool bBTOnOff_);

    // API of field "bSuppressAutoConnection"

    static const int kBSuppressAutoConnection = 1;

    /**
     * Clears the field "bSuppressAutoConnection".
     *
     * The field will be set to its default value. The hasBSuppressAutoConnection()
     * method will return false.
     */
    inline void clearBSuppressAutoConnection();

    /**
     * Checks whether the field "bSuppressAutoConnection" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBSuppressAutoConnection()). Otherwise it will return false.
     */
    inline bool hasBSuppressAutoConnection () const;

    /**
     * Returns the value of the member "bSuppressAutoConnection".
     *
     * Enable or Disable Autoconnection of the Paired device after BT ON.
     *
     * @return The value of the field "bSuppressAutoConnection"
     */
    inline bool getBSuppressAutoConnection () const;

    /**
     * Sets the value of the member "bSuppressAutoConnection".
     *
     * Enable or Disable Autoconnection of the Paired device after BT ON.
     *
     * @param bSuppressAutoConnection The value which will be set
     */
    inline void setBSuppressAutoConnection (bool bSuppressAutoConnection_);

    static const SwitchBluetoothOnOffExtendedStart &getDefaultInstance();

private:

    inline void set_has_bBTOnOff ();

    inline void clear_has_bBTOnOff ();

    inline void set_has_bSuppressAutoConnection ();

    inline void clear_has_bSuppressAutoConnection ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bBTOnOff;

    bool _bSuppressAutoConnection;

};

/**
 * The result message of the method "SwitchBluetoothOnOffExtended"
 * This function is Extended method of SwitchBluetoothOnOff which has an additional parameter bSuppressAutoConnection
 */
class SwitchBluetoothOnOffExtendedResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SwitchBluetoothOnOffExtendedResult ();

    /**
     * Copy constructor
     */
    inline  SwitchBluetoothOnOffExtendedResult (const SwitchBluetoothOnOffExtendedResult &rhs);

    /**
     * All fields constructor
     */
    inline  SwitchBluetoothOnOffExtendedResult (bool bBTOnOffResult_);

    /**
     * Destructor
     */
    inline virtual  ~SwitchBluetoothOnOffExtendedResult();

    /**
     * Assignment operator
     */
    inline SwitchBluetoothOnOffExtendedResult& operator = (const SwitchBluetoothOnOffExtendedResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SwitchBluetoothOnOffExtendedResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SwitchBluetoothOnOffExtendedResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SwitchBluetoothOnOffExtendedResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SwitchBluetoothOnOffExtendedResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bBTOnOffResult"

    static const int kBBTOnOffResult = 0;

    /**
     * Clears the field "bBTOnOffResult".
     *
     * The field will be set to its default value. The hasBBTOnOffResult()
     * method will return false.
     */
    inline void clearBBTOnOffResult();

    /**
     * Checks whether the field "bBTOnOffResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBBTOnOffResult()). Otherwise it will return false.
     */
    inline bool hasBBTOnOffResult () const;

    /**
     * Returns the value of the member "bBTOnOffResult".
     *
     * Current state of BluetoothONOFF after successful switching.
     *
     * @return The value of the field "bBTOnOffResult"
     */
    inline bool getBBTOnOffResult () const;

    /**
     * Sets the value of the member "bBTOnOffResult".
     *
     * Current state of BluetoothONOFF after successful switching.
     *
     * @param bBTOnOffResult The value which will be set
     */
    inline void setBBTOnOffResult (bool bBTOnOffResult_);

    static const SwitchBluetoothOnOffExtendedResult &getDefaultInstance();

private:

    inline void set_has_bBTOnOffResult ();

    inline void clear_has_bBTOnOffResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bBTOnOffResult;

};

/**
 * The error message of 'SwitchBluetoothOnOffExtended'
 */
class SwitchBluetoothOnOffExtendedErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SwitchBluetoothOnOffExtendedErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SwitchBluetoothOnOffExtendedErrorStructure (const SwitchBluetoothOnOffExtendedErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SwitchBluetoothOnOffExtendedErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~SwitchBluetoothOnOffExtendedErrorStructure();

    /**
     * Assignment operator
     */
    inline SwitchBluetoothOnOffExtendedErrorStructure& operator = (const SwitchBluetoothOnOffExtendedErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SwitchBluetoothOnOffExtendedErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SwitchBluetoothOnOffExtendedErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SwitchBluetoothOnOffExtendedErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SwitchBluetoothOnOffExtendedErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const SwitchBluetoothOnOffExtendedErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'SwitchBluetoothOnOffExtended'
 */
class SwitchBluetoothOnOffExtendedError  : public ::asf::core::Payload {
public:

    enum SwitchBluetoothOnOffExtendedErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SwitchBluetoothOnOffExtendedError ();

   /**
     * Copy constructor
     */
    inline  SwitchBluetoothOnOffExtendedError (const SwitchBluetoothOnOffExtendedError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SwitchBluetoothOnOffExtendedError();

    /**
     * Assigns a new value to this object.
     */
    inline SwitchBluetoothOnOffExtendedError& operator = (const SwitchBluetoothOnOffExtendedError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SwitchBluetoothOnOffExtendedError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SwitchBluetoothOnOffExtendedError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SwitchBluetoothOnOffExtendedError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SwitchBluetoothOnOffExtendedError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SwitchBluetoothOnOffExtendedError::SwitchBluetoothOnOffExtendedErrorField getField () const;

    inline void setField(SwitchBluetoothOnOffExtendedError::SwitchBluetoothOnOffExtendedErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SwitchBluetoothOnOffExtendedErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SwitchBluetoothOnOffExtendedErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SwitchBluetoothOnOffExtendedErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SwitchBluetoothOnOffExtendedErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SwitchBluetoothOnOffExtendedErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SwitchBluetoothOnOffExtendedErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SwitchBluetoothOnOffExtendedErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SwitchBluetoothOnOffExtendedErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SwitchBluetoothOnOffExtendedError &getDefaultInstance();

private:

    inline void cloneData (const SwitchBluetoothOnOffExtendedError& rhs);

    inline void deleteData ();

    SwitchBluetoothOnOffExtendedErrorField __field;

    union {
        SwitchBluetoothOnOffExtendedErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "ChangeWifiTransmitPower"
 * This method is used to change the transmission power of Wi-Fi chip. It is possible to attenuate the Wi-Fi RF power.
 * The range depends on modulation and Wi-Fi chip calibration settings. Rough rule of thumb for maximum range would be 10dB range with 11b modulation.
 * Other modulations have smaller ranges. If the requested operation on power adjustment is success then method result will report SUCCESS, otherwise ERROR.
 */
class ChangeWifiTransmitPowerStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ChangeWifiTransmitPowerStart ();

    /**
     * Copy constructor
     */
    inline  ChangeWifiTransmitPowerStart (const ChangeWifiTransmitPowerStart &rhs);

    /**
     * All fields constructor
     */
    inline  ChangeWifiTransmitPowerStart (uint8 u8WiFiPowerAttenuation_);

    /**
     * Destructor
     */
    inline virtual  ~ChangeWifiTransmitPowerStart();

    /**
     * Assignment operator
     */
    inline ChangeWifiTransmitPowerStart& operator = (const ChangeWifiTransmitPowerStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChangeWifiTransmitPowerStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChangeWifiTransmitPowerStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChangeWifiTransmitPowerStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChangeWifiTransmitPowerStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8WiFiPowerAttenuation"

    static const int kU8WiFiPowerAttenuation = 0;

    /**
     * Clears the field "u8WiFiPowerAttenuation".
     *
     * The field will be set to its default value. The hasU8WiFiPowerAttenuation()
     * method will return false.
     */
    inline void clearU8WiFiPowerAttenuation();

    /**
     * Checks whether the field "u8WiFiPowerAttenuation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8WiFiPowerAttenuation()). Otherwise it will return false.
     */
    inline bool hasU8WiFiPowerAttenuation () const;

    /**
     * Returns the value of the member "u8WiFiPowerAttenuation".
     *
     * This is used for attenuate the Wi-Fi RF power.
     *
     * @return The value of the field "u8WiFiPowerAttenuation"
     */
    inline uint8 getU8WiFiPowerAttenuation () const;

    /**
     * Sets the value of the member "u8WiFiPowerAttenuation".
     *
     * This is used for attenuate the Wi-Fi RF power.
     *
     * @param u8WiFiPowerAttenuation The value which will be set
     */
    inline void setU8WiFiPowerAttenuation (uint8 u8WiFiPowerAttenuation_);

    static const ChangeWifiTransmitPowerStart &getDefaultInstance();

private:

    inline void set_has_u8WiFiPowerAttenuation ();

    inline void clear_has_u8WiFiPowerAttenuation ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8WiFiPowerAttenuation;

};

/**
 * The result message of the method "ChangeWifiTransmitPower"
 * This method is used to change the transmission power of Wi-Fi chip. It is possible to attenuate the Wi-Fi RF power.
 * The range depends on modulation and Wi-Fi chip calibration settings. Rough rule of thumb for maximum range would be 10dB range with 11b modulation.
 * Other modulations have smaller ranges. If the requested operation on power adjustment is success then method result will report SUCCESS, otherwise ERROR.
 */
class ChangeWifiTransmitPowerResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ChangeWifiTransmitPowerResult ();

    /**
     * Copy constructor
     */
    inline  ChangeWifiTransmitPowerResult (const ChangeWifiTransmitPowerResult &rhs);

    /**
     * All fields constructor
     */
    inline  ChangeWifiTransmitPowerResult (bool bResult_);

    /**
     * Destructor
     */
    inline virtual  ~ChangeWifiTransmitPowerResult();

    /**
     * Assignment operator
     */
    inline ChangeWifiTransmitPowerResult& operator = (const ChangeWifiTransmitPowerResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChangeWifiTransmitPowerResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChangeWifiTransmitPowerResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChangeWifiTransmitPowerResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChangeWifiTransmitPowerResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bResult"

    static const int kBResult = 0;

    /**
     * Clears the field "bResult".
     *
     * The field will be set to its default value. The hasBResult()
     * method will return false.
     */
    inline void clearBResult();

    /**
     * Checks whether the field "bResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBResult()). Otherwise it will return false.
     */
    inline bool hasBResult () const;

    /**
     * Returns the value of the member "bResult".
     *
     * Tells whether the request for ChangeWifiTransmitPower can be processed or not.
     *
     * @return The value of the field "bResult"
     */
    inline bool getBResult () const;

    /**
     * Sets the value of the member "bResult".
     *
     * Tells whether the request for ChangeWifiTransmitPower can be processed or not.
     *
     * @param bResult The value which will be set
     */
    inline void setBResult (bool bResult_);

    static const ChangeWifiTransmitPowerResult &getDefaultInstance();

private:

    inline void set_has_bResult ();

    inline void clear_has_bResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bResult;

};

/**
 * The error message of 'ChangeWifiTransmitPower'
 */
class ChangeWifiTransmitPowerErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  ChangeWifiTransmitPowerErrorStructure ();

    /**
     * Copy constructor
     */
    inline  ChangeWifiTransmitPowerErrorStructure (const ChangeWifiTransmitPowerErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  ChangeWifiTransmitPowerErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~ChangeWifiTransmitPowerErrorStructure();

    /**
     * Assignment operator
     */
    inline ChangeWifiTransmitPowerErrorStructure& operator = (const ChangeWifiTransmitPowerErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChangeWifiTransmitPowerErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChangeWifiTransmitPowerErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChangeWifiTransmitPowerErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChangeWifiTransmitPowerErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const ChangeWifiTransmitPowerErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'ChangeWifiTransmitPower'
 */
class ChangeWifiTransmitPowerError  : public ::asf::core::Payload {
public:

    enum ChangeWifiTransmitPowerErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  ChangeWifiTransmitPowerError ();

   /**
     * Copy constructor
     */
    inline  ChangeWifiTransmitPowerError (const ChangeWifiTransmitPowerError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~ChangeWifiTransmitPowerError();

    /**
     * Assigns a new value to this object.
     */
    inline ChangeWifiTransmitPowerError& operator = (const ChangeWifiTransmitPowerError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChangeWifiTransmitPowerError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChangeWifiTransmitPowerError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChangeWifiTransmitPowerError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChangeWifiTransmitPowerError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline ChangeWifiTransmitPowerError::ChangeWifiTransmitPowerErrorField getField () const;

    inline void setField(ChangeWifiTransmitPowerError::ChangeWifiTransmitPowerErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "ChangeWifiTransmitPowerErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "ChangeWifiTransmitPowerErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ChangeWifiTransmitPowerErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ChangeWifiTransmitPowerErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline ChangeWifiTransmitPowerErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (ChangeWifiTransmitPowerErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "ChangeWifiTransmitPowerErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const ChangeWifiTransmitPowerErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const ChangeWifiTransmitPowerError &getDefaultInstance();

private:

    inline void cloneData (const ChangeWifiTransmitPowerError& rhs);

    inline void deleteData ();

    ChangeWifiTransmitPowerErrorField __field;

    union {
        ChangeWifiTransmitPowerErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "DisconnectSPPService"
 * This is a method to disconnect a SPP connection of a device when requested.For this to happen, the device for which the Disconnection is requested should have a valid SPP connection and RFCommID.
 */
class DisconnectSPPServiceStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DisconnectSPPServiceStart ();

    /**
     * Copy constructor
     */
    inline  DisconnectSPPServiceStart (const DisconnectSPPServiceStart &rhs);

    /**
     * All fields constructor
     */
    inline  DisconnectSPPServiceStart (uint8 u8DeviceHandle_, const ::fi_basetypes_most::T_String& szUUID_);

    /**
     * Destructor
     */
    inline virtual  ~DisconnectSPPServiceStart();

    /**
     * Assignment operator
     */
    inline DisconnectSPPServiceStart& operator = (const DisconnectSPPServiceStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DisconnectSPPServiceStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DisconnectSPPServiceStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DisconnectSPPServiceStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DisconnectSPPServiceStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the device, up to 10 devices that can be paired.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the device, up to 10 devices that can be paired.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "szUUID"

    static const int kSzUUID = 1;

    /**
     * Clears the field "szUUID".
     *
     * The field will be set to its default value. The hasSzUUID()
     * method will return false.
     */
    inline void clearSzUUID();

    /**
     * Checks whether the field "szUUID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzUUID()). Otherwise it will return false.
     */
    inline bool hasSzUUID () const;

    /**
     * Returns the value of the member "szUUID".
     *
     * The UUID for the Device handle, for which disconnection is been requested.
     *
     * @return The value of the field "szUUID"
     */
    inline const ::fi_basetypes_most::T_String& getSzUUID () const;

    /**
     * Retrieves the value of the field "szUUID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szUUID".
     */
    inline ::fi_basetypes_most::T_String& getSzUUIDMutable ();

    /**
     * Sets the value of the member "szUUID".
     *
     * The UUID for the Device handle, for which disconnection is been requested.
     *
     * @param szUUID The value which will be set
     */
    inline void setSzUUID (const ::fi_basetypes_most::T_String& szUUID_);

    static const DisconnectSPPServiceStart &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_szUUID ();

    inline void clear_has_szUUID ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8DeviceHandle;

    ::fi_basetypes_most::T_String _szUUID;

};

/**
 * The result message of the method "DisconnectSPPService"
 * This is a method to disconnect a SPP connection of a device when requested.For this to happen, the device for which the Disconnection is requested should have a valid SPP connection and RFCommID.
 */
class DisconnectSPPServiceResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DisconnectSPPServiceResult ();

    /**
     * Copy constructor
     */
    inline  DisconnectSPPServiceResult (const DisconnectSPPServiceResult &rhs);

    /**
     * All fields constructor
     */
    inline  DisconnectSPPServiceResult (bool bDisconnectSPPService_);

    /**
     * Destructor
     */
    inline virtual  ~DisconnectSPPServiceResult();

    /**
     * Assignment operator
     */
    inline DisconnectSPPServiceResult& operator = (const DisconnectSPPServiceResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DisconnectSPPServiceResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DisconnectSPPServiceResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DisconnectSPPServiceResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DisconnectSPPServiceResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bDisconnectSPPService"

    static const int kBDisconnectSPPService = 0;

    /**
     * Clears the field "bDisconnectSPPService".
     *
     * The field will be set to its default value. The hasBDisconnectSPPService()
     * method will return false.
     */
    inline void clearBDisconnectSPPService();

    /**
     * Checks whether the field "bDisconnectSPPService" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDisconnectSPPService()). Otherwise it will return false.
     */
    inline bool hasBDisconnectSPPService () const;

    /**
     * Returns the value of the member "bDisconnectSPPService".
     *
     * Tells whether the request for disconnection can be processed or not.
     *
     * @return The value of the field "bDisconnectSPPService"
     */
    inline bool getBDisconnectSPPService () const;

    /**
     * Sets the value of the member "bDisconnectSPPService".
     *
     * Tells whether the request for disconnection can be processed or not.
     *
     * @param bDisconnectSPPService The value which will be set
     */
    inline void setBDisconnectSPPService (bool bDisconnectSPPService_);

    static const DisconnectSPPServiceResult &getDefaultInstance();

private:

    inline void set_has_bDisconnectSPPService ();

    inline void clear_has_bDisconnectSPPService ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bDisconnectSPPService;

};

/**
 * The error message of 'DisconnectSPPService'
 */
class DisconnectSPPServiceErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DisconnectSPPServiceErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DisconnectSPPServiceErrorStructure (const DisconnectSPPServiceErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DisconnectSPPServiceErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~DisconnectSPPServiceErrorStructure();

    /**
     * Assignment operator
     */
    inline DisconnectSPPServiceErrorStructure& operator = (const DisconnectSPPServiceErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DisconnectSPPServiceErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DisconnectSPPServiceErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DisconnectSPPServiceErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DisconnectSPPServiceErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const DisconnectSPPServiceErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'DisconnectSPPService'
 */
class DisconnectSPPServiceError  : public ::asf::core::Payload {
public:

    enum DisconnectSPPServiceErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DisconnectSPPServiceError ();

   /**
     * Copy constructor
     */
    inline  DisconnectSPPServiceError (const DisconnectSPPServiceError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DisconnectSPPServiceError();

    /**
     * Assigns a new value to this object.
     */
    inline DisconnectSPPServiceError& operator = (const DisconnectSPPServiceError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DisconnectSPPServiceError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DisconnectSPPServiceError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DisconnectSPPServiceError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DisconnectSPPServiceError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DisconnectSPPServiceError::DisconnectSPPServiceErrorField getField () const;

    inline void setField(DisconnectSPPServiceError::DisconnectSPPServiceErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DisconnectSPPServiceErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DisconnectSPPServiceErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DisconnectSPPServiceErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DisconnectSPPServiceErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DisconnectSPPServiceErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DisconnectSPPServiceErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DisconnectSPPServiceErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DisconnectSPPServiceErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DisconnectSPPServiceError &getDefaultInstance();

private:

    inline void cloneData (const DisconnectSPPServiceError& rhs);

    inline void deleteData ();

    DisconnectSPPServiceErrorField __field;

    union {
        DisconnectSPPServiceErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "StartSearchSPPServices"
 * This API is used to retrieve the services on the specified device. This method can be used to get the SPP capabilities. As a result of this SPPServiceConnectionStatus Property will be updated only if there are changes in the property.
 */
class StartSearchSPPServicesStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartSearchSPPServicesStart ();

    /**
     * Copy constructor
     */
    inline  StartSearchSPPServicesStart (const StartSearchSPPServicesStart &rhs);

    /**
     * All fields constructor
     */
    inline  StartSearchSPPServicesStart (uint8 u8DeviceHandle_, bool bPeriodicSearch_);

    /**
     * Destructor
     */
    inline virtual  ~StartSearchSPPServicesStart();

    /**
     * Assignment operator
     */
    inline StartSearchSPPServicesStart& operator = (const StartSearchSPPServicesStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartSearchSPPServicesStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartSearchSPPServicesStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartSearchSPPServicesStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartSearchSPPServicesStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the device, up to 10 devices that can be paired.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the device, up to 10 devices that can be paired.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "bPeriodicSearch"

    static const int kBPeriodicSearch = 1;

    /**
     * Clears the field "bPeriodicSearch".
     *
     * The field will be set to its default value. The hasBPeriodicSearch()
     * method will return false.
     */
    inline void clearBPeriodicSearch();

    /**
     * Checks whether the field "bPeriodicSearch" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBPeriodicSearch()). Otherwise it will return false.
     */
    inline bool hasBPeriodicSearch () const;

    /**
     * Returns the value of the member "bPeriodicSearch".
     *
     * Based on this value, service search will be carried out in a periodic manner.
     *
     * @return The value of the field "bPeriodicSearch"
     */
    inline bool getBPeriodicSearch () const;

    /**
     * Sets the value of the member "bPeriodicSearch".
     *
     * Based on this value, service search will be carried out in a periodic manner.
     *
     * @param bPeriodicSearch The value which will be set
     */
    inline void setBPeriodicSearch (bool bPeriodicSearch_);

    static const StartSearchSPPServicesStart &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_bPeriodicSearch ();

    inline void clear_has_bPeriodicSearch ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8DeviceHandle;

    bool _bPeriodicSearch;

};

/**
 * The result message of the method "StartSearchSPPServices"
 * This API is used to retrieve the services on the specified device. This method can be used to get the SPP capabilities. As a result of this SPPServiceConnectionStatus Property will be updated only if there are changes in the property.
 */
class StartSearchSPPServicesResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartSearchSPPServicesResult ();

    /**
     * Copy constructor
     */
    inline  StartSearchSPPServicesResult (const StartSearchSPPServicesResult &rhs);

    /**
     * All fields constructor
     */
    inline  StartSearchSPPServicesResult (bool bResult_, uint8 u8SearchHandle_);

    /**
     * Destructor
     */
    inline virtual  ~StartSearchSPPServicesResult();

    /**
     * Assignment operator
     */
    inline StartSearchSPPServicesResult& operator = (const StartSearchSPPServicesResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartSearchSPPServicesResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartSearchSPPServicesResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartSearchSPPServicesResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartSearchSPPServicesResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bResult"

    static const int kBResult = 0;

    /**
     * Clears the field "bResult".
     *
     * The field will be set to its default value. The hasBResult()
     * method will return false.
     */
    inline void clearBResult();

    /**
     * Checks whether the field "bResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBResult()). Otherwise it will return false.
     */
    inline bool hasBResult () const;

    /**
     * Returns the value of the member "bResult".
     *
     * Informs whether the Request can be processed or not. The result will be notified through SPPServiceConnectionStatus only if there is change or new SPP services found in the property.
     *
     * @return The value of the field "bResult"
     */
    inline bool getBResult () const;

    /**
     * Sets the value of the member "bResult".
     *
     * Informs whether the Request can be processed or not. The result will be notified through SPPServiceConnectionStatus only if there is change or new SPP services found in the property.
     *
     * @param bResult The value which will be set
     */
    inline void setBResult (bool bResult_);

    // API of field "u8SearchHandle"

    static const int kU8SearchHandle = 1;

    /**
     * Clears the field "u8SearchHandle".
     *
     * The field will be set to its default value. The hasU8SearchHandle()
     * method will return false.
     */
    inline void clearU8SearchHandle();

    /**
     * Checks whether the field "u8SearchHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SearchHandle()). Otherwise it will return false.
     */
    inline bool hasU8SearchHandle () const;

    /**
     * Returns the value of the member "u8SearchHandle".
     *
     * Individual unique reference to this search request.It is needed to execute StopSearchSPPServices when started with option bPeriodicSearch is TRUE.If started with option bPeriodicSearch FALSE, the SearchHandle has no meaning and will be 0.
     *
     * @return The value of the field "u8SearchHandle"
     */
    inline uint8 getU8SearchHandle () const;

    /**
     * Sets the value of the member "u8SearchHandle".
     *
     * Individual unique reference to this search request.It is needed to execute StopSearchSPPServices when started with option bPeriodicSearch is TRUE.If started with option bPeriodicSearch FALSE, the SearchHandle has no meaning and will be 0.
     *
     * @param u8SearchHandle The value which will be set
     */
    inline void setU8SearchHandle (uint8 u8SearchHandle_);

    static const StartSearchSPPServicesResult &getDefaultInstance();

private:

    inline void set_has_bResult ();

    inline void clear_has_bResult ();

    inline void set_has_u8SearchHandle ();

    inline void clear_has_u8SearchHandle ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bResult;

    uint8 _u8SearchHandle;

};

/**
 * The error message of 'StartSearchSPPServices'
 */
class StartSearchSPPServicesErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  StartSearchSPPServicesErrorStructure ();

    /**
     * Copy constructor
     */
    inline  StartSearchSPPServicesErrorStructure (const StartSearchSPPServicesErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  StartSearchSPPServicesErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~StartSearchSPPServicesErrorStructure();

    /**
     * Assignment operator
     */
    inline StartSearchSPPServicesErrorStructure& operator = (const StartSearchSPPServicesErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartSearchSPPServicesErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartSearchSPPServicesErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartSearchSPPServicesErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartSearchSPPServicesErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const StartSearchSPPServicesErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'StartSearchSPPServices'
 */
class StartSearchSPPServicesError  : public ::asf::core::Payload {
public:

    enum StartSearchSPPServicesErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  StartSearchSPPServicesError ();

   /**
     * Copy constructor
     */
    inline  StartSearchSPPServicesError (const StartSearchSPPServicesError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~StartSearchSPPServicesError();

    /**
     * Assigns a new value to this object.
     */
    inline StartSearchSPPServicesError& operator = (const StartSearchSPPServicesError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartSearchSPPServicesError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartSearchSPPServicesError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartSearchSPPServicesError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartSearchSPPServicesError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline StartSearchSPPServicesError::StartSearchSPPServicesErrorField getField () const;

    inline void setField(StartSearchSPPServicesError::StartSearchSPPServicesErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "StartSearchSPPServicesErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "StartSearchSPPServicesErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const StartSearchSPPServicesErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline StartSearchSPPServicesErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline StartSearchSPPServicesErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (StartSearchSPPServicesErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "StartSearchSPPServicesErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const StartSearchSPPServicesErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const StartSearchSPPServicesError &getDefaultInstance();

private:

    inline void cloneData (const StartSearchSPPServicesError& rhs);

    inline void deleteData ();

    StartSearchSPPServicesErrorField __field;

    union {
        StartSearchSPPServicesErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "StopSearchSPPServices"
 * This API is used to stop the service search for the specific device with valid SearchHandle.
 */
class StopSearchSPPServicesStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StopSearchSPPServicesStart ();

    /**
     * Copy constructor
     */
    inline  StopSearchSPPServicesStart (const StopSearchSPPServicesStart &rhs);

    /**
     * All fields constructor
     */
    inline  StopSearchSPPServicesStart (uint8 u8DeviceHandle_, uint8 u8SearchHandle_);

    /**
     * Destructor
     */
    inline virtual  ~StopSearchSPPServicesStart();

    /**
     * Assignment operator
     */
    inline StopSearchSPPServicesStart& operator = (const StopSearchSPPServicesStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StopSearchSPPServicesStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StopSearchSPPServicesStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StopSearchSPPServicesStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StopSearchSPPServicesStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DeviceHandle"

    static const int kU8DeviceHandle = 0;

    /**
     * Clears the field "u8DeviceHandle".
     *
     * The field will be set to its default value. The hasU8DeviceHandle()
     * method will return false.
     */
    inline void clearU8DeviceHandle();

    /**
     * Checks whether the field "u8DeviceHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DeviceHandle()). Otherwise it will return false.
     */
    inline bool hasU8DeviceHandle () const;

    /**
     * Returns the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the device, up to 10 devices that can be paired.
     *
     * @return The value of the field "u8DeviceHandle"
     */
    inline uint8 getU8DeviceHandle () const;

    /**
     * Sets the value of the member "u8DeviceHandle".
     *
     * Unique handle for each one of the device, up to 10 devices that can be paired.
     *
     * @param u8DeviceHandle The value which will be set
     */
    inline void setU8DeviceHandle (uint8 u8DeviceHandle_);

    // API of field "u8SearchHandle"

    static const int kU8SearchHandle = 1;

    /**
     * Clears the field "u8SearchHandle".
     *
     * The field will be set to its default value. The hasU8SearchHandle()
     * method will return false.
     */
    inline void clearU8SearchHandle();

    /**
     * Checks whether the field "u8SearchHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SearchHandle()). Otherwise it will return false.
     */
    inline bool hasU8SearchHandle () const;

    /**
     * Returns the value of the member "u8SearchHandle".
     *
     * Unique SearchHandle from StartSearchSPPServices is used to Stop the periodic service search.
     *
     * @return The value of the field "u8SearchHandle"
     */
    inline uint8 getU8SearchHandle () const;

    /**
     * Sets the value of the member "u8SearchHandle".
     *
     * Unique SearchHandle from StartSearchSPPServices is used to Stop the periodic service search.
     *
     * @param u8SearchHandle The value which will be set
     */
    inline void setU8SearchHandle (uint8 u8SearchHandle_);

    static const StopSearchSPPServicesStart &getDefaultInstance();

private:

    inline void set_has_u8DeviceHandle ();

    inline void clear_has_u8DeviceHandle ();

    inline void set_has_u8SearchHandle ();

    inline void clear_has_u8SearchHandle ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8DeviceHandle;

    uint8 _u8SearchHandle;

};

/**
 * The result message of the method "StopSearchSPPServices"
 * This API is used to stop the service search for the specific device with valid SearchHandle.
 */
class StopSearchSPPServicesResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StopSearchSPPServicesResult ();

    /**
     * Copy constructor
     */
    inline  StopSearchSPPServicesResult (const StopSearchSPPServicesResult &rhs);

    /**
     * All fields constructor
     */
    inline  StopSearchSPPServicesResult (bool bResult_);

    /**
     * Destructor
     */
    inline virtual  ~StopSearchSPPServicesResult();

    /**
     * Assignment operator
     */
    inline StopSearchSPPServicesResult& operator = (const StopSearchSPPServicesResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StopSearchSPPServicesResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StopSearchSPPServicesResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StopSearchSPPServicesResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StopSearchSPPServicesResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bResult"

    static const int kBResult = 0;

    /**
     * Clears the field "bResult".
     *
     * The field will be set to its default value. The hasBResult()
     * method will return false.
     */
    inline void clearBResult();

    /**
     * Checks whether the field "bResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBResult()). Otherwise it will return false.
     */
    inline bool hasBResult () const;

    /**
     * Returns the value of the member "bResult".
     *
     * Informs whether the Stop Request is processed successfully or not.
     *
     * @return The value of the field "bResult"
     */
    inline bool getBResult () const;

    /**
     * Sets the value of the member "bResult".
     *
     * Informs whether the Stop Request is processed successfully or not.
     *
     * @param bResult The value which will be set
     */
    inline void setBResult (bool bResult_);

    static const StopSearchSPPServicesResult &getDefaultInstance();

private:

    inline void set_has_bResult ();

    inline void clear_has_bResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bResult;

};

/**
 * The error message of 'StopSearchSPPServices'
 */
class StopSearchSPPServicesErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  StopSearchSPPServicesErrorStructure ();

    /**
     * Copy constructor
     */
    inline  StopSearchSPPServicesErrorStructure (const StopSearchSPPServicesErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  StopSearchSPPServicesErrorStructure (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_, const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    /**
     * Destructor
     */
    inline  ~StopSearchSPPServicesErrorStructure();

    /**
     * Assignment operator
     */
    inline StopSearchSPPServicesErrorStructure& operator = (const StopSearchSPPServicesErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StopSearchSPPServicesErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StopSearchSPPServicesErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StopSearchSPPServicesErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StopSearchSPPServicesErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::fi_basetypes_most::T_e8_ErrorCode getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * MOST Default ErrorCode.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::fi_basetypes_most::T_e8_ErrorCode e8ErrorCode_);

    // API of field "oErrorInfo"

    static const int kOErrorInfo = 1;

    /**
     * Clears the field "oErrorInfo".
     *
     * The field will be set to its default value. The hasOErrorInfo()
     * method will return false.
     */
    inline void clearOErrorInfo();

    /**
     * Checks whether the field "oErrorInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOErrorInfo()). Otherwise it will return false.
     */
    inline bool hasOErrorInfo () const;

    /**
     * Returns the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @return The value of the field "oErrorInfo"
     */
    inline const ::fi_basetypes_most::T_TrailingStream& getOErrorInfo () const;

    /**
     * Retrieves the value of the field "oErrorInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oErrorInfo".
     */
    inline ::fi_basetypes_most::T_TrailingStream& getOErrorInfoMutable ();

    /**
     * Sets the value of the member "oErrorInfo".
     *
     * MOST Default ErrorInfo
     *
     * @param oErrorInfo The value which will be set
     */
    inline void setOErrorInfo (const ::fi_basetypes_most::T_TrailingStream& oErrorInfo_);

    static const StopSearchSPPServicesErrorStructure &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    inline void set_has_oErrorInfo ();

    inline void clear_has_oErrorInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::fi_basetypes_most::T_e8_ErrorCode _e8ErrorCode;

    ::fi_basetypes_most::T_TrailingStream _oErrorInfo;

};

/**
 * The error message of 'StopSearchSPPServices'
 */
class StopSearchSPPServicesError  : public ::asf::core::Payload {
public:

    enum StopSearchSPPServicesErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  StopSearchSPPServicesError ();

   /**
     * Copy constructor
     */
    inline  StopSearchSPPServicesError (const StopSearchSPPServicesError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~StopSearchSPPServicesError();

    /**
     * Assigns a new value to this object.
     */
    inline StopSearchSPPServicesError& operator = (const StopSearchSPPServicesError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StopSearchSPPServicesError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StopSearchSPPServicesError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StopSearchSPPServicesError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StopSearchSPPServicesError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline StopSearchSPPServicesError::StopSearchSPPServicesErrorField getField () const;

    inline void setField(StopSearchSPPServicesError::StopSearchSPPServicesErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "StopSearchSPPServicesErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "StopSearchSPPServicesErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const StopSearchSPPServicesErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline StopSearchSPPServicesErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline StopSearchSPPServicesErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (StopSearchSPPServicesErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "StopSearchSPPServicesErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const StopSearchSPPServicesErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const StopSearchSPPServicesError &getDefaultInstance();

private:

    inline void cloneData (const StopSearchSPPServicesError& rhs);

    inline void deleteData ();

    StopSearchSPPServicesErrorField __field;

    union {
        StopSearchSPPServicesErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "AddOobPairedDevice"
 * This API is used to support out-of-band (OOB) pairing.
 */
class AddOobPairedDeviceStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AddOobPairedDeviceStart ();

    /**
     * Copy constructor
     */
    inline  AddOobPairedDeviceStart (const AddOobPairedDeviceStart &rhs);

    /**
     * All fields constructor
     */
    inline  AddOobPairedDeviceStart (const ::fi_basetypes_most::T_String& sBdAddress_, const ::fi_basetypes_most::T_String& sBdName_, const ::fi_basetypes_most::T_String& sLinkKey_, ::most_BTSet_fi_types_Extended::T_e8_BTOobType e8OobType_);

    /**
     * Destructor
     */
    inline virtual  ~AddOobPairedDeviceStart();

    /**
     * Assignment operator
     */
    inline AddOobPairedDeviceStart& operator = (const AddOobPairedDeviceStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddOobPairedDeviceStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddOobPairedDeviceStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddOobPairedDeviceStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddOobPairedDeviceStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sBdAddress"

    static const int kSBdAddress = 0;

    /**
     * Clears the field "sBdAddress".
     *
     * The field will be set to its default value. The hasSBdAddress()
     * method will return false.
     */
    inline void clearSBdAddress();

    /**
     * Checks whether the field "sBdAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSBdAddress()). Otherwise it will return false.
     */
    inline bool hasSBdAddress () const;

    /**
     * Returns the value of the member "sBdAddress".
     *
     * Bluetooth device address
     *
     * @return The value of the field "sBdAddress"
     */
    inline const ::fi_basetypes_most::T_String& getSBdAddress () const;

    /**
     * Retrieves the value of the field "sBdAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sBdAddress".
     */
    inline ::fi_basetypes_most::T_String& getSBdAddressMutable ();

    /**
     * Sets the value of the member "sBdAddress".
     *
     * Bluetooth device address
     *
     * @param sBdAddress The value which will be set
     */
    inline void setSBdAddress (const ::fi_basetypes_most::T_String& sBdAddress_);

    // API of field "sBdName"

    static const int kSBdName = 1;

    /**
     * Clears the field "sBdName".
     *
     * The field will be set to its default value. The hasSBdName()
     * method will return false.
     */
    inline void clearSBdName();

    /**
     * Checks whether the field "sBdName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSBdName()). Otherwise it will return false.
     */
    inline bool hasSBdName () const;

    /**
     * Returns the value of the member "sBdName".
     *
     * Bluetooth device name
     *
     * @return The value of the field "sBdName"
     */
    inline const ::fi_basetypes_most::T_String& getSBdName () const;

    /**
     * Retrieves the value of the field "sBdName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sBdName".
     */
    inline ::fi_basetypes_most::T_String& getSBdNameMutable ();

    /**
     * Sets the value of the member "sBdName".
     *
     * Bluetooth device name
     *
     * @param sBdName The value which will be set
     */
    inline void setSBdName (const ::fi_basetypes_most::T_String& sBdName_);

    // API of field "sLinkKey"

    static const int kSLinkKey = 2;

    /**
     * Clears the field "sLinkKey".
     *
     * The field will be set to its default value. The hasSLinkKey()
     * method will return false.
     */
    inline void clearSLinkKey();

    /**
     * Checks whether the field "sLinkKey" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSLinkKey()). Otherwise it will return false.
     */
    inline bool hasSLinkKey () const;

    /**
     * Returns the value of the member "sLinkKey".
     *
     * LinkKey
     *
     * @return The value of the field "sLinkKey"
     */
    inline const ::fi_basetypes_most::T_String& getSLinkKey () const;

    /**
     * Retrieves the value of the field "sLinkKey" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sLinkKey".
     */
    inline ::fi_basetypes_most::T_String& getSLinkKeyMutable ();

    /**
     * Sets the value of the member "sLinkKey".
     *
     * LinkKey
     *
     * @param sLinkKey The value which will be set
     */
    inline void setSLinkKey (const ::fi_basetypes_most::T_String& sLinkKey_);

    // API of field "e8OobType"

    static const int kE8OobType = 3;

    /**
     * Clears the field "e8OobType".
     *
     * The field will be set to its default value. The hasE8OobType()
     * method will return false.
     */
    inline void clearE8OobType();

    /**
     * Checks whether the field "e8OobType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8OobType()). Otherwise it will return false.
     */
    inline bool hasE8OobType () const;

    /**
     * Returns the value of the member "e8OobType".
     *
     * Protocol support for the given remote device
     *
     * @return The value of the field "e8OobType"
     */
    inline ::most_BTSet_fi_types_Extended::T_e8_BTOobType getE8OobType () const;

    /**
     * Sets the value of the member "e8OobType".
     *
     * Protocol support for the given remote device
     *
     * @param e8OobType The value which will be set
     */
    inline void setE8OobType (::most_BTSet_fi_types_Extended::T_e8_BTOobType e8OobType_);

    static const AddOobPairedDeviceStart &getDefaultInstance();

private:

    inline void set_has_sBdAddress ();

    inline void clear_has_sBdAddress ();

    inline void set_has_sBdName ();

    inline void clear_has_sBdName ();

    inline void set_has_sLinkKey ();

    inline void clear_has_sLinkKey ();

    inline void set_has_e8OobType ();

    inline void clear_has_e8OobType ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::fi_basetypes_most::T_String _sBdAddress;

    ::fi_basetypes_most::T_String _sBdName;

    ::fi_basetypes_most::T_String _sLinkKey;

    ::most_BTSet_fi_types_Extended::T_e8_BTOobType _e8OobType;

};

/**
 * The result message of the method "AddOobPairedDevice"
 * This API is used to support out-of-band (OOB) pairing.
 */
class AddOobPairedDeviceResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AddOobPairedDeviceResult ();

    /**
     * Copy constructor
     */
    inline  AddOobPairedDeviceResult (const AddOobPairedDeviceResult &rhs);

    /**
     * All fields constructor
     */
    inline  AddOobPairedDeviceResult (bool bResult_);

    /**
     * Destructor
     */
    inline virtual  ~AddOobPairedDeviceResult();

    /**
     * Assignment operator
     */
    inline AddOobPairedDeviceResult& operator = (const AddOobPairedDeviceResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AddOobPairedDeviceResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AddOobPairedDeviceResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AddOobPairedDeviceResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AddO