/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef CMB_ACR_FIPROXY_H
#define CMB_ACR_FIPROXY_H

#include "CMB_ACR_FI.h"
#include "acr_fi_types.h"
#include "asf/cca/CcaProxy.h"
#include "asf/core/Logger.h"
#include "asf/core/nullable.h"

namespace CMB_ACR_FI {

class CMB_ACR_FIProxy;

class ChannelRequestCallbackIF {
public:
    virtual ~ChannelRequestCallbackIF() {}

    virtual void onChannelRequestError(const ::boost::shared_ptr< CMB_ACR_FIProxy >& proxy, const ::boost::shared_ptr< ChannelRequestError >& error) = 0;

    virtual void onChannelRequestStatus(const ::boost::shared_ptr< CMB_ACR_FIProxy >& proxy, const ::boost::shared_ptr< ChannelRequestStatus >& status) = 0;
};

class InstancesPerCategoryCallbackIF {
public:
    virtual ~InstancesPerCategoryCallbackIF() {}

    virtual void onInstancesPerCategoryError(const ::boost::shared_ptr< CMB_ACR_FIProxy >& proxy, const ::boost::shared_ptr< InstancesPerCategoryError >& error) = 0;

    virtual void onInstancesPerCategoryStatus(const ::boost::shared_ptr< CMB_ACR_FIProxy >& proxy, const ::boost::shared_ptr< InstancesPerCategoryStatus >& status) = 0;
};

class VoiceAdviceCallbackIF {
public:
    virtual ~VoiceAdviceCallbackIF() {}

    virtual void onVoiceAdviceError(const ::boost::shared_ptr< CMB_ACR_FIProxy >& proxy, const ::boost::shared_ptr< VoiceAdviceError >& error) = 0;

    virtual void onVoiceAdviceResult(const ::boost::shared_ptr< CMB_ACR_FIProxy >& proxy, const ::boost::shared_ptr< VoiceAdviceResult >& result) = 0;
};

class CMB_ACR_FIProxyCallback;

/**
 * CMB_ACR_FIProxy is the client side representation of the CCA Functional
 * Interface 'CMB_ACR_FI' (specified in file cmb_acr_fi.xml).
 *
 * CCA Functional Interface 'CMB_ACR_FI'
 *
 * Fullname: Acoustic Channel Request Functional Interface
 *
 * Version: $Revision: 2.0$
 *
 * Author:
 *          Marc Rï¿½ber, TMS Joachim Schneider
 *
 * Date: $Date: 17.04.2009$
 *
 * Department: CM-AI / PJ-CF14
 *
 * Title: CMB_ACR_FI
 *
 * <b>Description of 'CMB_ACR_FI':</b>
 */
class CMB_ACR_FIProxy : public ::asf::cca::CcaProxy
{
public:

    /**
     * Create a new instance of CMB_ACR_FIProxy. The caller has to pass the
     * port name and the service information. It is only possible to use this
     * function if the port is defined in the CMC model as "wired at
     * runtime"-port. The application id of the CCA Server will be determined
     * with help of the CCA SrvSupplier messages. It's guranteed that the
     * corresponding CCA server will have the specified major version and at
     * least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< CMB_ACR_FIProxy > createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of CMB_ACR_FIProxy. The caller has to pass the
     * port name and the service information. It is only possible to use this
     * function if the port is defined in the CMC model as "wired at
     * runtime"-port. The proxy will connect to the CCA application specified
     * by appId. The CCA SrvSupplier messages will be used to determine the
     * availability of this application and the service. It's guranteed that
     * the corresponding CCA server will have the specified major version and
     * at least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< CMB_ACR_FIProxy > createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of CMB_ACR_FIProxy. The caller has to pass the
     * port name. The port name is defined in the "Car Multimedia Component"
     * model. With the help of the port name it is possible to address the
     * concrete proxy, which is defined in the CMC model description.
     */
    static ::boost::shared_ptr< CMB_ACR_FIProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Destructor of CMB_ACR_FIProxy. The destructor will send RelUpReg
     * messages for all property notifications and call the error callback of
     * all pending method invocations.
     */
    ~CMB_ACR_FIProxy();

    // Method 'VoiceAdvice'

    /**
     * Call the method 'VoiceAdvice'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'VoiceAdvice'</b>:
     *
     * With this method, the AudioManagement is able to start/stop an audio advice,
     * if the audio channel is free/engaged. Further information can be found in the last chapter "MSCs".
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param AudioChannelAdvice
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVoiceAdviceStart(VoiceAdviceCallbackIF& cb, const ::acr_fi_types::T_AudioChannelAdvice& audioChannelAdvice);

    // Property 'ChannelRequest'

    /**
     * Notify on the property 'ChannelRequest'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'ChannelRequest'</b>:
     *
     * With this property, the component using this service is able to request
     * a voice advice from the AudioManagement. Additionally, the AudioManagement is informed, if
     * a job is being played. Further information can be found in the MSCs below.
     * The property contains only the current change of this status, not the complete status.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendChannelRequestUpReg(ChannelRequestCallbackIF& cb);

    /**
     * Remove the notifcation on property 'ChannelRequest'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'ChannelRequest'</b>:
     *
     * With this property, the component using this service is able to request
     * a voice advice from the AudioManagement. Additionally, the AudioManagement is informed, if
     * a job is being played. Further information can be found in the MSCs below.
     * The property contains only the current change of this status, not the complete status.
     *
     * @param act The act which was previously returned by the
     * sendChannelRequestUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendChannelRequestRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'ChannelRequest'.
     */
    void sendChannelRequestRelUpRegAll ();

    /**
     * Returns the current value of the property 'ChannelRequest' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasChannelRequest() returns true.
     *
     * @return the previously received value of the property 'ChannelRequest'.
     */
    const ChannelRequestStatus& getChannelRequest() const;

    /**
     * Determines whether a status message for the property 'ChannelRequest' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasChannelRequest() const;

    /**
     * Request the value of the property 'ChannelRequest' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'ChannelRequest'</b>:
     *
     * With this property, the component using this service is able to request
     * a voice advice from the AudioManagement. Additionally, the AudioManagement is informed, if
     * a job is being played. Further information can be found in the MSCs below.
     * The property contains only the current change of this status, not the complete status.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendChannelRequestGet(ChannelRequestCallbackIF& cb);

    // Property 'InstancesPerCategory'

    /**
     * Notify on the property 'InstancesPerCategory'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'InstancesPerCategory'</b>:
     *
     * This property informs the client (particularly the AudioManegement)
     * about the maximum amount of instances that can run simultaneously for
     * each category. Additionally the maximum amount of instances overall is
     * given. Further information can be found in the MSCs below.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendInstancesPerCategoryUpReg(InstancesPerCategoryCallbackIF& cb);

    /**
     * Remove the notifcation on property 'InstancesPerCategory'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'InstancesPerCategory'</b>:
     *
     * This property informs the client (particularly the AudioManegement)
     * about the maximum amount of instances that can run simultaneously for
     * each category. Additionally the maximum amount of instances overall is
     * given. Further information can be found in the MSCs below.
     *
     * @param act The act which was previously returned by the
     * sendInstancesPerCategoryUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendInstancesPerCategoryRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'InstancesPerCategory'.
     */
    void sendInstancesPerCategoryRelUpRegAll ();

    /**
     * Returns the current value of the property 'InstancesPerCategory' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasInstancesPerCategory() returns true.
     *
     * @return the previously received value of the property 'InstancesPerCategory'.
     */
    const InstancesPerCategoryStatus& getInstancesPerCategory() const;

    /**
     * Determines whether a status message for the property 'InstancesPerCategory' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasInstancesPerCategory() const;

    /**
     * Request the value of the property 'InstancesPerCategory' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'InstancesPerCategory'</b>:
     *
     * This property informs the client (particularly the AudioManegement)
     * about the maximum amount of instances that can run simultaneously for
     * each category. Additionally the maximum amount of instances overall is
     * given. Further information can be found in the MSCs below.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendInstancesPerCategoryGet(InstancesPerCategoryCallbackIF& cb);

    /**
     * Release all property notifications (on all properties).
     */
    void sendRelUpRegAll ();

private:

    CMB_ACR_FIProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags);

    virtual void clearAllProperties ();

    ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > createCallback (uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb);

    // Property 'ChannelRequest'

    ::asf::core::nullable< ChannelRequestStatus > _channelRequest;

    // Property 'InstancesPerCategory'

    ::asf::core::nullable< InstancesPerCategoryStatus > _instancesPerCategory;

    DECLARE_CLASS_LOGGER();

    friend class CMB_ACR_FIProxyCallback;
};

} // namespace CMB_ACR_FI

#endif // CMB_ACR_FIPROXY_H
