/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "CMB_ACR_FICca.h"
#include "CMB_ACR_FIJson.h"
#include "CMB_ACR_FIProxy.h"
#include "acr_fi_types.h"
#include "asf/cca/DefaultTypesCca.h"
#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/stream/MemoryStream.h"
#include "asf/threading/Guard.h"

#include "asf/cca/CcaMessage.h"
#include "asf/cca/CcaProxyDelegate.h"
#include "asf/cca/CcaProxyRegistry.h"

namespace CMB_ACR_FI {

/*static*/ ::asf::core::Logger CMB_ACR_FIProxy::_logger ("/CMB_ACR_FI/CMB_ACR_FIProxy");


class CMB_ACR_FIProxyCallback : public ::asf::cca::CcaProxyCallback {
public:

    CMB_ACR_FIProxyCallback(uint16 functionId, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, void* callback) :
        ::asf::cca::CcaProxyCallback (functionId, opCode, (reinterpret_cast<act_t>(this)), callback)
    {}

    bool processMessage (::asf::cca::CcaMessage &message) {
        if (message.getHeader().getExtension().getField() == ::asf::cca::CcaTypes::CcaMessageExtension::E_SERVICE_DATA) {
            if (message.getHeader().getExtension().getServiceData().getFunctionId() == _functionId) {
                ::boost::shared_ptr<CMB_ACR_FIProxy> proxy = ::boost::static_pointer_cast<CMB_ACR_FIProxy>(message.getProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                switch (_functionId) {
                    case FID_VoiceAdvice: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::CMB_ACR_FI::VoiceAdviceResult);
                                setActAndLogResult(message, "VoiceAdvice", reinterpret_cast<act_t>(this), _logger);
                                ((VoiceAdviceCallbackIF*) _callback)->onVoiceAdviceResult (proxy, ::boost::static_pointer_cast<VoiceAdviceResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::CMB_ACR_FI::VoiceAdviceError);
                                setActAndLogError(message, "VoiceAdvice", reinterpret_cast<act_t>(this), _logger);
                                ((VoiceAdviceCallbackIF*) _callback)->onVoiceAdviceError (proxy, ::boost::static_pointer_cast<VoiceAdviceError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ChannelRequest: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::CMB_ACR_FI::ChannelRequestStatus);
                                setActAndLogStatus(message, "ChannelRequest", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<ChannelRequestStatus> payload = ::boost::static_pointer_cast<ChannelRequestStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< ChannelRequestStatus >& refNullableStatus = proxy->_channelRequest;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((ChannelRequestCallbackIF*) _callback)->onChannelRequestStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((ChannelRequestCallbackIF*) _callback)->onChannelRequestStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::CMB_ACR_FI::ChannelRequestError);
                                setActAndLogError(message, "ChannelRequest", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((ChannelRequestCallbackIF*) _callback)->onChannelRequestError(proxy, ::boost::static_pointer_cast<ChannelRequestError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_InstancesPerCategory: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::CMB_ACR_FI::InstancesPerCategoryStatus);
                                setActAndLogStatus(message, "InstancesPerCategory", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<InstancesPerCategoryStatus> payload = ::boost::static_pointer_cast<InstancesPerCategoryStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< InstancesPerCategoryStatus >& refNullableStatus = proxy->_instancesPerCategory;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((InstancesPerCategoryCallbackIF*) _callback)->onInstancesPerCategoryStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((InstancesPerCategoryCallbackIF*) _callback)->onInstancesPerCategoryStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::CMB_ACR_FI::InstancesPerCategoryError);
                                setActAndLogError(message, "InstancesPerCategory", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((InstancesPerCategoryCallbackIF*) _callback)->onInstancesPerCategoryError(proxy, ::boost::static_pointer_cast<InstancesPerCategoryError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    default:
                        break;
                }
            }
            LOG_FATAL ("Can't process service data message, commandCounter %u belongs to functionId %u, but message has functionId %u (opcode '%s')",
                message.getHeader().getExtension().getServiceData().getCommandCounter(),
                _functionId,
                message.getHeader().getExtension().getServiceData().getFunctionId(),
                ServiceData_OpCode_Name(message.getHeader().getExtension().getServiceData().getOpCode()));
            return false;
        }
        LOG_FATAL("Can't process message of type: %d", message.getHeader().getExtension().getField());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy>& baseProxy) {
        ::boost::shared_ptr<CMB_ACR_FIProxy> proxy = ::boost::static_pointer_cast<CMB_ACR_FIProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case FID_VoiceAdvice: {
                ::boost::shared_ptr< VoiceAdviceError > payload (new VoiceAdviceError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "VoiceAdvice", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((VoiceAdviceCallbackIF*) _callback)->onVoiceAdviceError (proxy, payload);
                return true;
            }
            case FID_ChannelRequest: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< ChannelRequestError > payload (new ChannelRequestError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ChannelRequest", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((ChannelRequestCallbackIF*) _callback)->onChannelRequestError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_InstancesPerCategory: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< InstancesPerCategoryError > payload (new InstancesPerCategoryError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "InstancesPerCategory", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((InstancesPerCategoryCallbackIF*) _callback)->onInstancesPerCategoryError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& CMB_ACR_FIProxyCallback::_logger (CMB_ACR_FIProxy::_logger);

/*static*/ ::boost::shared_ptr< CMB_ACR_FIProxy > CMB_ACR_FIProxy::createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< CMB_ACR_FIProxy >  proxyNew(new CMB_ACR_FIProxy(portName, 0, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, 0, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< CMB_ACR_FIProxy > CMB_ACR_FIProxy::createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< CMB_ACR_FIProxy >  proxyNew(new CMB_ACR_FIProxy(portName, appId, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, appId, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< CMB_ACR_FIProxy > CMB_ACR_FIProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::boost::shared_ptr< Proxy > proxyReuse = ::asf::cca::CcaProxyRegistry::getInstance().getProxy(portName, serviceAvailable);
        if(proxyReuse) {
            LOG_INFO_STATIC ("createProxy, reuse existing proxy");
            return ::boost::static_pointer_cast<CMB_ACR_FIProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        }
        // create new proxy object
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< CMB_ACR_FIProxy >  proxyNew(new CMB_ACR_FIProxy(portName, 0, 0, 0, serviceAvailable, 0));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew);
        return proxyNew;
    }

CMB_ACR_FIProxy::CMB_ACR_FIProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) :
    ::asf::cca::CcaProxy(portName, appId, SERVICE_ID, majorVersion, minorVersion, serviceAvailable, _logger, flags) {
}

CMB_ACR_FIProxy::~CMB_ACR_FIProxy()
{
    LOG_INFO ("Entering ~CMB_ACR_FIProxy");
    sendRelUpRegAll ();
}

act_t CMB_ACR_FIProxy::sendVoiceAdviceStart(VoiceAdviceCallbackIF& cb, const ::acr_fi_types::T_AudioChannelAdvice& audioChannelAdvice) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_VoiceAdvice);
        ::boost::shared_ptr< VoiceAdviceStart > payload (new VoiceAdviceStart());
        payload->setAudioChannelAdvice(audioChannelAdvice);
        CCA_MESSAGE(ccaMessage,header,VoiceAdviceStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "VoiceAdvice", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_VoiceAdvice);
        ::boost::shared_ptr< VoiceAdviceError > payload (new VoiceAdviceError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,VoiceAdviceError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "VoiceAdvice", &cb);
    }
}

act_t CMB_ACR_FIProxy::sendChannelRequestUpReg(ChannelRequestCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_ChannelRequest);
        ::boost::shared_ptr< ChannelRequestUpReg > payload (new ChannelRequestUpReg());
        CCA_MESSAGE(ccaMessage,header,ChannelRequestUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< ChannelRequestRelUpReg > payloadRelUpRegHeap (new ChannelRequestRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_ChannelRequest, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::CMB_ACR_FI::ChannelRequestRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_ChannelRequest, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "ChannelRequest", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "ChannelRequest", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasChannelRequest()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_ChannelRequest, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< ChannelRequestStatus > payloadLoopback (new ChannelRequestStatus(getChannelRequest()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,ChannelRequestStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ChannelRequest);
        ::boost::shared_ptr< ChannelRequestError > payload (new ChannelRequestError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ChannelRequestError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "ChannelRequest", &cb);
    }
}

bool CMB_ACR_FIProxy::sendChannelRequestRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_ChannelRequest,"ChannelRequest");
}

void CMB_ACR_FIProxy::sendChannelRequestRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_ChannelRequest);
}

const ChannelRequestStatus& CMB_ACR_FIProxy::getChannelRequest() const {
    return _channelRequest.get();
}

bool CMB_ACR_FIProxy::hasChannelRequest() const {
    return _channelRequest.hasValue();
}

act_t CMB_ACR_FIProxy::sendChannelRequestGet(ChannelRequestCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_ChannelRequest);
        ::boost::shared_ptr< ChannelRequestGet > payload (new ChannelRequestGet());
        CCA_MESSAGE(ccaMessage,header,ChannelRequestGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "ChannelRequest", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ChannelRequest);
        ::boost::shared_ptr< ChannelRequestError > payload (new ChannelRequestError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ChannelRequestError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "ChannelRequest", &cb);
    }
}

act_t CMB_ACR_FIProxy::sendInstancesPerCategoryUpReg(InstancesPerCategoryCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_InstancesPerCategory);
        ::boost::shared_ptr< InstancesPerCategoryUpReg > payload (new InstancesPerCategoryUpReg());
        CCA_MESSAGE(ccaMessage,header,InstancesPerCategoryUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< InstancesPerCategoryRelUpReg > payloadRelUpRegHeap (new InstancesPerCategoryRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_InstancesPerCategory, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::CMB_ACR_FI::InstancesPerCategoryRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_InstancesPerCategory, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "InstancesPerCategory", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "InstancesPerCategory", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasInstancesPerCategory()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_InstancesPerCategory, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< InstancesPerCategoryStatus > payloadLoopback (new InstancesPerCategoryStatus(getInstancesPerCategory()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,InstancesPerCategoryStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_InstancesPerCategory);
        ::boost::shared_ptr< InstancesPerCategoryError > payload (new InstancesPerCategoryError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,InstancesPerCategoryError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "InstancesPerCategory", &cb);
    }
}

bool CMB_ACR_FIProxy::sendInstancesPerCategoryRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_InstancesPerCategory,"InstancesPerCategory");
}

void CMB_ACR_FIProxy::sendInstancesPerCategoryRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_InstancesPerCategory);
}

const InstancesPerCategoryStatus& CMB_ACR_FIProxy::getInstancesPerCategory() const {
    return _instancesPerCategory.get();
}

bool CMB_ACR_FIProxy::hasInstancesPerCategory() const {
    return _instancesPerCategory.hasValue();
}

act_t CMB_ACR_FIProxy::sendInstancesPerCategoryGet(InstancesPerCategoryCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_InstancesPerCategory);
        ::boost::shared_ptr< InstancesPerCategoryGet > payload (new InstancesPerCategoryGet());
        CCA_MESSAGE(ccaMessage,header,InstancesPerCategoryGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "InstancesPerCategory", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_InstancesPerCategory);
        ::boost::shared_ptr< InstancesPerCategoryError > payload (new InstancesPerCategoryError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,InstancesPerCategoryError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "InstancesPerCategory", &cb);
    }
}


void CMB_ACR_FIProxy::clearAllProperties ()
{
    _channelRequest = ::asf::core::nullable<ChannelRequestStatus>();
    _instancesPerCategory = ::asf::core::nullable<InstancesPerCategoryStatus>();
}

void CMB_ACR_FIProxy::sendRelUpRegAll()
{
    sendChannelRequestRelUpRegAll();
    sendInstancesPerCategoryRelUpRegAll();
}

::boost::shared_ptr< ::asf::cca::CcaProxyCallback > CMB_ACR_FIProxy::createCallback(uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb)
{
     ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback(new CMB_ACR_FIProxyCallback(fid, opCode, cb));
     _ccaProxyDelegate->addCallback (commandCounter, callback);
    return callback;
}

} // namespace CMB_ACR_FI
