/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/cca/DefaultTypesCca.h"
#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/stream/MemoryStream.h"
#include "asf/threading/Guard.h"
#include "midw_streamrouter_fiCca.h"
#include "midw_streamrouter_fiJson.h"
#include "midw_streamrouter_fiProxy.h"
#include "midw_streamrouter_fi_typesConst.h"

#include "asf/cca/CcaMessage.h"
#include "asf/cca/CcaProxyDelegate.h"
#include "asf/cca/CcaProxyRegistry.h"

namespace midw_streamrouter_fi {

/*static*/ ::asf::core::Logger Midw_streamrouter_fiProxy::_logger ("/midw_streamrouter_fi/Midw_streamrouter_fiProxy");


class Midw_streamrouter_fiProxyCallback : public ::asf::cca::CcaProxyCallback {
public:

    Midw_streamrouter_fiProxyCallback(uint16 functionId, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, void* callback) :
        ::asf::cca::CcaProxyCallback (functionId, opCode, (reinterpret_cast<act_t>(this)), callback)
    {}

    bool processMessage (::asf::cca::CcaMessage &message) {
        if (message.getHeader().getExtension().getField() == ::asf::cca::CcaTypes::CcaMessageExtension::E_SERVICE_DATA) {
            if (message.getHeader().getExtension().getServiceData().getFunctionId() == _functionId) {
                ::boost::shared_ptr<Midw_streamrouter_fiProxy> proxy = ::boost::static_pointer_cast<Midw_streamrouter_fiProxy>(message.getProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                switch (_functionId) {
                    case FID_AllocateRoute: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::midw_streamrouter_fi::AllocateRouteResult);
                                setActAndLogResult(message, "AllocateRoute", reinterpret_cast<act_t>(this), _logger);
                                ((AllocateRouteCallbackIF*) _callback)->onAllocateRouteResult (proxy, ::boost::static_pointer_cast<AllocateRouteResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::midw_streamrouter_fi::AllocateRouteError);
                                setActAndLogError(message, "AllocateRoute", reinterpret_cast<act_t>(this), _logger);
                                ((AllocateRouteCallbackIF*) _callback)->onAllocateRouteError (proxy, ::boost::static_pointer_cast<AllocateRouteError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DeAllocateRoute: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::midw_streamrouter_fi::DeAllocateRouteResult);
                                setActAndLogResult(message, "DeAllocateRoute", reinterpret_cast<act_t>(this), _logger);
                                ((DeAllocateRouteCallbackIF*) _callback)->onDeAllocateRouteResult (proxy, ::boost::static_pointer_cast<DeAllocateRouteResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::midw_streamrouter_fi::DeAllocateRouteError);
                                setActAndLogError(message, "DeAllocateRoute", reinterpret_cast<act_t>(this), _logger);
                                ((DeAllocateRouteCallbackIF*) _callback)->onDeAllocateRouteError (proxy, ::boost::static_pointer_cast<DeAllocateRouteError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SetPlay: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::midw_streamrouter_fi::SetPlayResult);
                                setActAndLogResult(message, "SetPlay", reinterpret_cast<act_t>(this), _logger);
                                ((SetPlayCallbackIF*) _callback)->onSetPlayResult (proxy, ::boost::static_pointer_cast<SetPlayResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::midw_streamrouter_fi::SetPlayError);
                                setActAndLogError(message, "SetPlay", reinterpret_cast<act_t>(this), _logger);
                                ((SetPlayCallbackIF*) _callback)->onSetPlayError (proxy, ::boost::static_pointer_cast<SetPlayError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SetStop: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::midw_streamrouter_fi::SetStopResult);
                                setActAndLogResult(message, "SetStop", reinterpret_cast<act_t>(this), _logger);
                                ((SetStopCallbackIF*) _callback)->onSetStopResult (proxy, ::boost::static_pointer_cast<SetStopResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::midw_streamrouter_fi::SetStopError);
                                setActAndLogError(message, "SetStop", reinterpret_cast<act_t>(this), _logger);
                                ((SetStopCallbackIF*) _callback)->onSetStopError (proxy, ::boost::static_pointer_cast<SetStopError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SendFGCommand: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::midw_streamrouter_fi::SendFGCommandResult);
                                setActAndLogResult(message, "SendFGCommand", reinterpret_cast<act_t>(this), _logger);
                                ((SendFGCommandCallbackIF*) _callback)->onSendFGCommandResult (proxy, ::boost::static_pointer_cast<SendFGCommandResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::midw_streamrouter_fi::SendFGCommandError);
                                setActAndLogError(message, "SendFGCommand", reinterpret_cast<act_t>(this), _logger);
                                ((SendFGCommandCallbackIF*) _callback)->onSendFGCommandError (proxy, ::boost::static_pointer_cast<SendFGCommandError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_RoutingState: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::midw_streamrouter_fi::RoutingStateStatus);
                                setActAndLogStatus(message, "RoutingState", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<RoutingStateStatus> payload = ::boost::static_pointer_cast<RoutingStateStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< RoutingStateStatus >& refNullableStatus = proxy->_routingState;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((RoutingStateCallbackIF*) _callback)->onRoutingStateStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((RoutingStateCallbackIF*) _callback)->onRoutingStateStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::midw_streamrouter_fi::RoutingStateError);
                                setActAndLogError(message, "RoutingState", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((RoutingStateCallbackIF*) _callback)->onRoutingStateError(proxy, ::boost::static_pointer_cast<RoutingStateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    default:
                        break;
                }
            }
            LOG_FATAL ("Can't process service data message, commandCounter %u belongs to functionId %u, but message has functionId %u (opcode '%s')",
                message.getHeader().getExtension().getServiceData().getCommandCounter(),
                _functionId,
                message.getHeader().getExtension().getServiceData().getFunctionId(),
                ServiceData_OpCode_Name(message.getHeader().getExtension().getServiceData().getOpCode()));
            return false;
        }
        LOG_FATAL("Can't process message of type: %d", message.getHeader().getExtension().getField());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy>& baseProxy) {
        ::boost::shared_ptr<Midw_streamrouter_fiProxy> proxy = ::boost::static_pointer_cast<Midw_streamrouter_fiProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case FID_AllocateRoute: {
                ::boost::shared_ptr< AllocateRouteError > payload (new AllocateRouteError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AllocateRoute", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((AllocateRouteCallbackIF*) _callback)->onAllocateRouteError (proxy, payload);
                return true;
            }
            case FID_DeAllocateRoute: {
                ::boost::shared_ptr< DeAllocateRouteError > payload (new DeAllocateRouteError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DeAllocateRoute", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((DeAllocateRouteCallbackIF*) _callback)->onDeAllocateRouteError (proxy, payload);
                return true;
            }
            case FID_SetPlay: {
                ::boost::shared_ptr< SetPlayError > payload (new SetPlayError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetPlay", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SetPlayCallbackIF*) _callback)->onSetPlayError (proxy, payload);
                return true;
            }
            case FID_SetStop: {
                ::boost::shared_ptr< SetStopError > payload (new SetStopError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetStop", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SetStopCallbackIF*) _callback)->onSetStopError (proxy, payload);
                return true;
            }
            case FID_SendFGCommand: {
                ::boost::shared_ptr< SendFGCommandError > payload (new SendFGCommandError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SendFGCommand", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SendFGCommandCallbackIF*) _callback)->onSendFGCommandError (proxy, payload);
                return true;
            }
            case FID_RoutingState: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< RoutingStateError > payload (new RoutingStateError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RoutingState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((RoutingStateCallbackIF*) _callback)->onRoutingStateError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& Midw_streamrouter_fiProxyCallback::_logger (Midw_streamrouter_fiProxy::_logger);

/*static*/ ::boost::shared_ptr< Midw_streamrouter_fiProxy > Midw_streamrouter_fiProxy::createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Midw_streamrouter_fiProxy >  proxyNew(new Midw_streamrouter_fiProxy(portName, 0, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, 0, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Midw_streamrouter_fiProxy > Midw_streamrouter_fiProxy::createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Midw_streamrouter_fiProxy >  proxyNew(new Midw_streamrouter_fiProxy(portName, appId, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, appId, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Midw_streamrouter_fiProxy > Midw_streamrouter_fiProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::boost::shared_ptr< Proxy > proxyReuse = ::asf::cca::CcaProxyRegistry::getInstance().getProxy(portName, serviceAvailable);
        if(proxyReuse) {
            LOG_INFO_STATIC ("createProxy, reuse existing proxy");
            return ::boost::static_pointer_cast<Midw_streamrouter_fiProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        }
        // create new proxy object
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< Midw_streamrouter_fiProxy >  proxyNew(new Midw_streamrouter_fiProxy(portName, 0, 0, 0, serviceAvailable, 0));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew);
        return proxyNew;
    }

Midw_streamrouter_fiProxy::Midw_streamrouter_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) :
    ::asf::cca::CcaProxy(portName, appId, SERVICE_ID, majorVersion, minorVersion, serviceAvailable, _logger, flags) {
}

Midw_streamrouter_fiProxy::~Midw_streamrouter_fiProxy()
{
    LOG_INFO ("Entering ~Midw_streamrouter_fiProxy");
    sendRelUpRegAll ();
}

act_t Midw_streamrouter_fiProxy::sendAllocateRouteStart(AllocateRouteCallbackIF& cb, uint16 u16UCID, int32 s32STM_MsgBufID, uint16 u16Sink) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_AllocateRoute);
        ::boost::shared_ptr< AllocateRouteStart > payload (new AllocateRouteStart());
        payload->setU16UCID(u16UCID);
        payload->setS32STM_MsgBufID(s32STM_MsgBufID);
        payload->setU16Sink(u16Sink);
        CCA_MESSAGE(ccaMessage,header,AllocateRouteStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "AllocateRoute", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AllocateRoute);
        ::boost::shared_ptr< AllocateRouteError > payload (new AllocateRouteError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AllocateRouteError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "AllocateRoute", &cb);
    }
}

act_t Midw_streamrouter_fiProxy::sendDeAllocateRouteStart(DeAllocateRouteCallbackIF& cb, uint16 u16UCID) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_DeAllocateRoute);
        ::boost::shared_ptr< DeAllocateRouteStart > payload (new DeAllocateRouteStart());
        payload->setU16UCID(u16UCID);
        CCA_MESSAGE(ccaMessage,header,DeAllocateRouteStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "DeAllocateRoute", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DeAllocateRoute);
        ::boost::shared_ptr< DeAllocateRouteError > payload (new DeAllocateRouteError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DeAllocateRouteError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "DeAllocateRoute", &cb);
    }
}

act_t Midw_streamrouter_fiProxy::sendSetPlayStart(SetPlayCallbackIF& cb, uint16 u16UCID, ::midw_streamrouter_fi_types::T_e8_streamrouter_ramptype eRampType) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_SetPlay);
        ::boost::shared_ptr< SetPlayStart > payload (new SetPlayStart());
        payload->setU16UCID(u16UCID);
        payload->setERampType(eRampType);
        CCA_MESSAGE(ccaMessage,header,SetPlayStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SetPlay", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SetPlay);
        ::boost::shared_ptr< SetPlayError > payload (new SetPlayError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SetPlayError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SetPlay", &cb);
    }
}

act_t Midw_streamrouter_fiProxy::sendSetStopStart(SetStopCallbackIF& cb, uint16 u16UCID, ::midw_streamrouter_fi_types::T_e8_streamrouter_ramptype eRampType) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_SetStop);
        ::boost::shared_ptr< SetStopStart > payload (new SetStopStart());
        payload->setU16UCID(u16UCID);
        payload->setERampType(eRampType);
        CCA_MESSAGE(ccaMessage,header,SetStopStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SetStop", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SetStop);
        ::boost::shared_ptr< SetStopError > payload (new SetStopError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SetStopError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SetStop", &cb);
    }
}

act_t Midw_streamrouter_fiProxy::sendSendFGCommandStart(SendFGCommandCallbackIF& cb, uint16 u16UCID, uint16 u16FGRouteID, ::midw_streamrouter_fi_types::T_e8_streamrouter_fgcommand eCmd) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_SendFGCommand);
        ::boost::shared_ptr< SendFGCommandStart > payload (new SendFGCommandStart());
        payload->setU16UCID(u16UCID);
        payload->setU16FGRouteID(u16FGRouteID);
        payload->setECmd(eCmd);
        CCA_MESSAGE(ccaMessage,header,SendFGCommandStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SendFGCommand", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SendFGCommand);
        ::boost::shared_ptr< SendFGCommandError > payload (new SendFGCommandError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SendFGCommandError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SendFGCommand", &cb);
    }
}

act_t Midw_streamrouter_fiProxy::sendRoutingStateUpReg(RoutingStateCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_RoutingState);
        ::boost::shared_ptr< RoutingStateUpReg > payload (new RoutingStateUpReg());
        CCA_MESSAGE(ccaMessage,header,RoutingStateUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< RoutingStateRelUpReg > payloadRelUpRegHeap (new RoutingStateRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_RoutingState, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::midw_streamrouter_fi::RoutingStateRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_RoutingState, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "RoutingState", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "RoutingState", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasRoutingState()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_RoutingState, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< RoutingStateStatus > payloadLoopback (new RoutingStateStatus(getRoutingState()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,RoutingStateStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RoutingState);
        ::boost::shared_ptr< RoutingStateError > payload (new RoutingStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RoutingStateError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "RoutingState", &cb);
    }
}

bool Midw_streamrouter_fiProxy::sendRoutingStateRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_RoutingState,"RoutingState");
}

void Midw_streamrouter_fiProxy::sendRoutingStateRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_RoutingState);
}

const RoutingStateStatus& Midw_streamrouter_fiProxy::getRoutingState() const {
    return _routingState.get();
}

bool Midw_streamrouter_fiProxy::hasRoutingState() const {
    return _routingState.hasValue();
}

act_t Midw_streamrouter_fiProxy::sendRoutingStateGet(RoutingStateCallbackIF& cb, int32 s32UCID) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_RoutingState);
        ::boost::shared_ptr< RoutingStateGet > payload (new RoutingStateGet());
        payload->setS32UCID(s32UCID);
        CCA_MESSAGE(ccaMessage,header,RoutingStateGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "RoutingState", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RoutingState);
        ::boost::shared_ptr< RoutingStateError > payload (new RoutingStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RoutingStateError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "RoutingState", &cb);
    }
}


void Midw_streamrouter_fiProxy::clearAllProperties ()
{
    _routingState = ::asf::core::nullable<RoutingStateStatus>();
}

void Midw_streamrouter_fiProxy::sendRelUpRegAll()
{
    sendRoutingStateRelUpRegAll();
}

::boost::shared_ptr< ::asf::cca::CcaProxyCallback > Midw_streamrouter_fiProxy::createCallback(uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb)
{
     ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback(new Midw_streamrouter_fiProxyCallback(fid, opCode, cb));
     _ccaProxyDelegate->addCallback (commandCounter, callback);
    return callback;
}

} // namespace midw_streamrouter_fi
