/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/ai/IntercomAudioService.h"
#include "bosch/cm/ai/IntercomAudioServiceDBus.h"
#include "bosch/cm/ai/IntercomAudioServiceJson.h"
#include "bosch/cm/ai/IntercomAudioServiceProxy.h"

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace bosch {
namespace cm {
namespace ai {
namespace IntercomAudioService {

DEFINE_CLASS_LOGGER("/bosch/cm/ai/IntercomAudioService", IntercomAudioServiceProxy);

class IntercomAudioServiceProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    IntercomAudioServiceProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< IntercomAudioServiceProxy >& proxyShared = ::boost::static_pointer_cast< IntercomAudioServiceProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_incomingCall:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), IncomingCallSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "IncomingCall", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<IncomingCallSignal> payload = ::boost::static_pointer_cast<IncomingCallSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((IncomingCallCallbackIF*) _callback)->onIncomingCallSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_cancelCall:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CancelCallSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CancelCall", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<CancelCallSignal> payload = ::boost::static_pointer_cast<CancelCallSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((CancelCallCallbackIF*) _callback)->onCancelCallSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_activeCallStatus:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ActiveCallStatusSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ActiveCallStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<ActiveCallStatusSignal> payload = ::boost::static_pointer_cast<ActiveCallStatusSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((ActiveCallStatusCallbackIF*) _callback)->onActiveCallStatusSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_IntercomServiceAvailability:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), IntercomServiceAvailabilitySignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "IntercomServiceAvailability", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<IntercomServiceAvailabilitySignal> payload = ::boost::static_pointer_cast<IntercomServiceAvailabilitySignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((IntercomServiceAvailabilityCallbackIF*) _callback)->onIntercomServiceAvailabilitySignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_RspPhoneStatus:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RspPhoneStatusSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RspPhoneStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<RspPhoneStatusSignal> payload = ::boost::static_pointer_cast<RspPhoneStatusSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((RspPhoneStatusCallbackIF*) _callback)->onRspPhoneStatusSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_EventPhoneStatusChanged:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EventPhoneStatusChangedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "EventPhoneStatusChanged", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<EventPhoneStatusChangedSignal> payload = ::boost::static_pointer_cast<EventPhoneStatusChangedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((EventPhoneStatusChangedCallbackIF*) _callback)->onEventPhoneStatusChangedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_EventNanoMessageErrorStatus:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EventNanoMessageErrorStatusSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "EventNanoMessageErrorStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<EventNanoMessageErrorStatusSignal> payload = ::boost::static_pointer_cast<EventNanoMessageErrorStatusSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((EventNanoMessageErrorStatusCallbackIF*) _callback)->onEventNanoMessageErrorStatusSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_EventRTPErrorStatus:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EventRTPErrorStatusSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "EventRTPErrorStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<EventRTPErrorStatusSignal> payload = ::boost::static_pointer_cast<EventRTPErrorStatusSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((EventRTPErrorStatusCallbackIF*) _callback)->onEventRTPErrorStatusSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_EventInterComConfigError:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EventInterComConfigErrorSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "EventInterComConfigError", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<EventInterComConfigErrorSignal> payload = ::boost::static_pointer_cast<EventInterComConfigErrorSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((EventInterComConfigErrorCallbackIF*) _callback)->onEventInterComConfigErrorSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_EventAudioAllocationStatus:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EventAudioAllocationStatusSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "EventAudioAllocationStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<EventAudioAllocationStatusSignal> payload = ::boost::static_pointer_cast<EventAudioAllocationStatusSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((EventAudioAllocationStatusCallbackIF*) _callback)->onEventAudioAllocationStatusSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_EventIntercomAvailable:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EventIntercomAvailableSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "EventIntercomAvailable", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<EventIntercomAvailableSignal> payload = ::boost::static_pointer_cast<EventIntercomAvailableSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((EventIntercomAvailableCallbackIF*) _callback)->onEventIntercomAvailableSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_RspIntercomAvailable:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RspIntercomAvailableSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RspIntercomAvailable", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<RspIntercomAvailableSignal> payload = ::boost::static_pointer_cast<RspIntercomAvailableSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((RspIntercomAvailableCallbackIF*) _callback)->onRspIntercomAvailableSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_outgoingCall:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), OutgoingCallError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "OutgoingCall", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<OutgoingCallError> payload = ::boost::static_pointer_cast<OutgoingCallError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((OutgoingCallCallbackIF*) _callback)->onOutgoingCallError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), OutgoingCallResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "OutgoingCall", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<OutgoingCallResponse> payload = ::boost::static_pointer_cast<OutgoingCallResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((OutgoingCallCallbackIF*) _callback)->onOutgoingCallResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_getPhoneStatus:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetPhoneStatusError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetPhoneStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetPhoneStatusError> payload = ::boost::static_pointer_cast<GetPhoneStatusError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetPhoneStatusCallbackIF*) _callback)->onGetPhoneStatusError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetPhoneStatusResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetPhoneStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetPhoneStatusResponse> payload = ::boost::static_pointer_cast<GetPhoneStatusResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetPhoneStatusCallbackIF*) _callback)->onGetPhoneStatusResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_CallAction:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), CallActionError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "CallAction", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CallActionError> payload = ::boost::static_pointer_cast<CallActionError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CallActionCallbackIF*) _callback)->onCallActionError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CallActionResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "CallAction", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CallActionResponse> payload = ::boost::static_pointer_cast<CallActionResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CallActionCallbackIF*) _callback)->onCallActionResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_getAvailability:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetAvailabilityError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetAvailability", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetAvailabilityError> payload = ::boost::static_pointer_cast<GetAvailabilityError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetAvailabilityCallbackIF*) _callback)->onGetAvailabilityError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetAvailabilityResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetAvailability", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetAvailabilityResponse> payload = ::boost::static_pointer_cast<GetAvailabilityResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetAvailabilityCallbackIF*) _callback)->onGetAvailabilityResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_incomingCall: {
                ::boost::shared_ptr< IncomingCallError > payload = ::boost::shared_ptr< IncomingCallError >
                (new IncomingCallError(DBUS_ERROR_NO_SERVER, "The DBus service IntercomAudioService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "IncomingCall", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<IntercomAudioServiceProxy> proxyShared = ::boost::static_pointer_cast<IntercomAudioServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((IncomingCallCallbackIF*) _callback)->onIncomingCallError (proxyShared,payload);
                return true;
            }
            break;
            case ID_cancelCall: {
                ::boost::shared_ptr< CancelCallError > payload = ::boost::shared_ptr< CancelCallError >
                (new CancelCallError(DBUS_ERROR_NO_SERVER, "The DBus service IntercomAudioService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CancelCall", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<IntercomAudioServiceProxy> proxyShared = ::boost::static_pointer_cast<IntercomAudioServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CancelCallCallbackIF*) _callback)->onCancelCallError (proxyShared,payload);
                return true;
            }
            break;
            case ID_activeCallStatus: {
                ::boost::shared_ptr< ActiveCallStatusError > payload = ::boost::shared_ptr< ActiveCallStatusError >
                (new ActiveCallStatusError(DBUS_ERROR_NO_SERVER, "The DBus service IntercomAudioService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ActiveCallStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<IntercomAudioServiceProxy> proxyShared = ::boost::static_pointer_cast<IntercomAudioServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ActiveCallStatusCallbackIF*) _callback)->onActiveCallStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_IntercomServiceAvailability: {
                ::boost::shared_ptr< IntercomServiceAvailabilityError > payload = ::boost::shared_ptr< IntercomServiceAvailabilityError >
                (new IntercomServiceAvailabilityError(DBUS_ERROR_NO_SERVER, "The DBus service IntercomAudioService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "IntercomServiceAvailability", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<IntercomAudioServiceProxy> proxyShared = ::boost::static_pointer_cast<IntercomAudioServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((IntercomServiceAvailabilityCallbackIF*) _callback)->onIntercomServiceAvailabilityError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RspPhoneStatus: {
                ::boost::shared_ptr< RspPhoneStatusError > payload = ::boost::shared_ptr< RspPhoneStatusError >
                (new RspPhoneStatusError(DBUS_ERROR_NO_SERVER, "The DBus service IntercomAudioService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RspPhoneStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<IntercomAudioServiceProxy> proxyShared = ::boost::static_pointer_cast<IntercomAudioServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RspPhoneStatusCallbackIF*) _callback)->onRspPhoneStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_EventPhoneStatusChanged: {
                ::boost::shared_ptr< EventPhoneStatusChangedError > payload = ::boost::shared_ptr< EventPhoneStatusChangedError >
                (new EventPhoneStatusChangedError(DBUS_ERROR_NO_SERVER, "The DBus service IntercomAudioService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EventPhoneStatusChanged", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<IntercomAudioServiceProxy> proxyShared = ::boost::static_pointer_cast<IntercomAudioServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EventPhoneStatusChangedCallbackIF*) _callback)->onEventPhoneStatusChangedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_EventNanoMessageErrorStatus: {
                ::boost::shared_ptr< EventNanoMessageErrorStatusError > payload = ::boost::shared_ptr< EventNanoMessageErrorStatusError >
                (new EventNanoMessageErrorStatusError(DBUS_ERROR_NO_SERVER, "The DBus service IntercomAudioService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EventNanoMessageErrorStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<IntercomAudioServiceProxy> proxyShared = ::boost::static_pointer_cast<IntercomAudioServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EventNanoMessageErrorStatusCallbackIF*) _callback)->onEventNanoMessageErrorStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_EventRTPErrorStatus: {
                ::boost::shared_ptr< EventRTPErrorStatusError > payload = ::boost::shared_ptr< EventRTPErrorStatusError >
                (new EventRTPErrorStatusError(DBUS_ERROR_NO_SERVER, "The DBus service IntercomAudioService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EventRTPErrorStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<IntercomAudioServiceProxy> proxyShared = ::boost::static_pointer_cast<IntercomAudioServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EventRTPErrorStatusCallbackIF*) _callback)->onEventRTPErrorStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_EventInterComConfigError: {
                ::boost::shared_ptr< EventInterComConfigErrorError > payload = ::boost::shared_ptr< EventInterComConfigErrorError >
                (new EventInterComConfigErrorError(DBUS_ERROR_NO_SERVER, "The DBus service IntercomAudioService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EventInterComConfigError", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<IntercomAudioServiceProxy> proxyShared = ::boost::static_pointer_cast<IntercomAudioServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EventInterComConfigErrorCallbackIF*) _callback)->onEventInterComConfigErrorError (proxyShared,payload);
                return true;
            }
            break;
            case ID_EventAudioAllocationStatus: {
                ::boost::shared_ptr< EventAudioAllocationStatusError > payload = ::boost::shared_ptr< EventAudioAllocationStatusError >
                (new EventAudioAllocationStatusError(DBUS_ERROR_NO_SERVER, "The DBus service IntercomAudioService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EventAudioAllocationStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<IntercomAudioServiceProxy> proxyShared = ::boost::static_pointer_cast<IntercomAudioServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EventAudioAllocationStatusCallbackIF*) _callback)->onEventAudioAllocationStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_EventIntercomAvailable: {
                ::boost::shared_ptr< EventIntercomAvailableError > payload = ::boost::shared_ptr< EventIntercomAvailableError >
                (new EventIntercomAvailableError(DBUS_ERROR_NO_SERVER, "The DBus service IntercomAudioService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EventIntercomAvailable", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<IntercomAudioServiceProxy> proxyShared = ::boost::static_pointer_cast<IntercomAudioServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EventIntercomAvailableCallbackIF*) _callback)->onEventIntercomAvailableError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RspIntercomAvailable: {
                ::boost::shared_ptr< RspIntercomAvailableError > payload = ::boost::shared_ptr< RspIntercomAvailableError >
                (new RspIntercomAvailableError(DBUS_ERROR_NO_SERVER, "The DBus service IntercomAudioService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RspIntercomAvailable", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<IntercomAudioServiceProxy> proxyShared = ::boost::static_pointer_cast<IntercomAudioServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RspIntercomAvailableCallbackIF*) _callback)->onRspIntercomAvailableError (proxyShared,payload);
                return true;
            }
            break;
            case ID_outgoingCall: {
                ::boost::shared_ptr< OutgoingCallError > payload = ::boost::shared_ptr< OutgoingCallError >
                (new OutgoingCallError(DBUS_ERROR_NO_SERVER, "The DBus service IntercomAudioService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "OutgoingCall", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<IntercomAudioServiceProxy> proxyShared = ::boost::static_pointer_cast<IntercomAudioServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((OutgoingCallCallbackIF*) _callback)->onOutgoingCallError (proxyShared,payload);
                return true;
            }
            break;
            case ID_getPhoneStatus: {
                ::boost::shared_ptr< GetPhoneStatusError > payload = ::boost::shared_ptr< GetPhoneStatusError >
                (new GetPhoneStatusError(DBUS_ERROR_NO_SERVER, "The DBus service IntercomAudioService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetPhoneStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<IntercomAudioServiceProxy> proxyShared = ::boost::static_pointer_cast<IntercomAudioServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetPhoneStatusCallbackIF*) _callback)->onGetPhoneStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_CallAction: {
                ::boost::shared_ptr< CallActionError > payload = ::boost::shared_ptr< CallActionError >
                (new CallActionError(DBUS_ERROR_NO_SERVER, "The DBus service IntercomAudioService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CallAction", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<IntercomAudioServiceProxy> proxyShared = ::boost::static_pointer_cast<IntercomAudioServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CallActionCallbackIF*) _callback)->onCallActionError (proxyShared,payload);
                return true;
            }
            break;
            case ID_getAvailability: {
                ::boost::shared_ptr< GetAvailabilityError > payload = ::boost::shared_ptr< GetAvailabilityError >
                (new GetAvailabilityError(DBUS_ERROR_NO_SERVER, "The DBus service IntercomAudioService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetAvailability", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<IntercomAudioServiceProxy> proxyShared = ::boost::static_pointer_cast<IntercomAudioServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetAvailabilityCallbackIF*) _callback)->onGetAvailabilityError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& IntercomAudioServiceProxyCallback::_logger (IntercomAudioServiceProxy::_logger);

IntercomAudioServiceProxy::IntercomAudioServiceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "bosch.cm.ai.IntercomAudioService", serviceAvailable, _logger) {
}

IntercomAudioServiceProxy::~IntercomAudioServiceProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< IntercomAudioServiceProxy > IntercomAudioServiceProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<IntercomAudioServiceProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< IntercomAudioServiceProxy > proxyNew(new IntercomAudioServiceProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t IntercomAudioServiceProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    IntercomAudioServiceProxyCallback* callback = new IntercomAudioServiceProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t IntercomAudioServiceProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    IntercomAudioServiceProxyCallback* callback = new IntercomAudioServiceProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


void IntercomAudioServiceProxy::sendDeregisterAll () const
{
    sendIncomingCallDeregisterAll();
    sendCancelCallDeregisterAll();
    sendActiveCallStatusDeregisterAll();
    sendIntercomServiceAvailabilityDeregisterAll();
    sendRspPhoneStatusDeregisterAll();
    sendEventPhoneStatusChangedDeregisterAll();
    sendEventNanoMessageErrorStatusDeregisterAll();
    sendEventRTPErrorStatusDeregisterAll();
    sendEventInterComConfigErrorDeregisterAll();
    sendEventAudioAllocationStatusDeregisterAll();
    sendEventIntercomAvailableDeregisterAll();
    sendRspIntercomAvailableDeregisterAll();
}

act_t IntercomAudioServiceProxy::sendIncomingCallRegister(IncomingCallCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "incomingCall");
    act_t act = addSignalCallback(ID_incomingCall, "incomingCall", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "IncomingCall", &cb, act);
    return act;
}

bool IntercomAudioServiceProxy::sendIncomingCallDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("incomingCall", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "IncomingCall", act, static_cast<int>(rv));
    return rv;
}

void IntercomAudioServiceProxy::sendIncomingCallDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "IncomingCall");
    _dbusProxyDelegate->deregisterSignalCallback("incomingCall", 0, _dbusDaemonProxy.get(), false);
}

act_t IntercomAudioServiceProxy::sendCancelCallRegister(CancelCallCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "cancelCall");
    act_t act = addSignalCallback(ID_cancelCall, "cancelCall", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "CancelCall", &cb, act);
    return act;
}

bool IntercomAudioServiceProxy::sendCancelCallDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("cancelCall", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "CancelCall", act, static_cast<int>(rv));
    return rv;
}

void IntercomAudioServiceProxy::sendCancelCallDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "CancelCall");
    _dbusProxyDelegate->deregisterSignalCallback("cancelCall", 0, _dbusDaemonProxy.get(), false);
}

act_t IntercomAudioServiceProxy::sendActiveCallStatusRegister(ActiveCallStatusCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "activeCallStatus");
    act_t act = addSignalCallback(ID_activeCallStatus, "activeCallStatus", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ActiveCallStatus", &cb, act);
    return act;
}

bool IntercomAudioServiceProxy::sendActiveCallStatusDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("activeCallStatus", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ActiveCallStatus", act, static_cast<int>(rv));
    return rv;
}

void IntercomAudioServiceProxy::sendActiveCallStatusDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ActiveCallStatus");
    _dbusProxyDelegate->deregisterSignalCallback("activeCallStatus", 0, _dbusDaemonProxy.get(), false);
}

act_t IntercomAudioServiceProxy::sendIntercomServiceAvailabilityRegister(IntercomServiceAvailabilityCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "IntercomServiceAvailability");
    act_t act = addSignalCallback(ID_IntercomServiceAvailability, "IntercomServiceAvailability", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "IntercomServiceAvailability", &cb, act);
    return act;
}

bool IntercomAudioServiceProxy::sendIntercomServiceAvailabilityDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("IntercomServiceAvailability", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "IntercomServiceAvailability", act, static_cast<int>(rv));
    return rv;
}

void IntercomAudioServiceProxy::sendIntercomServiceAvailabilityDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "IntercomServiceAvailability");
    _dbusProxyDelegate->deregisterSignalCallback("IntercomServiceAvailability", 0, _dbusDaemonProxy.get(), false);
}

act_t IntercomAudioServiceProxy::sendRspPhoneStatusRegister(RspPhoneStatusCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "RspPhoneStatus");
    act_t act = addSignalCallback(ID_RspPhoneStatus, "RspPhoneStatus", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "RspPhoneStatus", &cb, act);
    return act;
}

bool IntercomAudioServiceProxy::sendRspPhoneStatusDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("RspPhoneStatus", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "RspPhoneStatus", act, static_cast<int>(rv));
    return rv;
}

void IntercomAudioServiceProxy::sendRspPhoneStatusDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "RspPhoneStatus");
    _dbusProxyDelegate->deregisterSignalCallback("RspPhoneStatus", 0, _dbusDaemonProxy.get(), false);
}

act_t IntercomAudioServiceProxy::sendEventPhoneStatusChangedRegister(EventPhoneStatusChangedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "EventPhoneStatusChanged");
    act_t act = addSignalCallback(ID_EventPhoneStatusChanged, "EventPhoneStatusChanged", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "EventPhoneStatusChanged", &cb, act);
    return act;
}

bool IntercomAudioServiceProxy::sendEventPhoneStatusChangedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("EventPhoneStatusChanged", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "EventPhoneStatusChanged", act, static_cast<int>(rv));
    return rv;
}

void IntercomAudioServiceProxy::sendEventPhoneStatusChangedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "EventPhoneStatusChanged");
    _dbusProxyDelegate->deregisterSignalCallback("EventPhoneStatusChanged", 0, _dbusDaemonProxy.get(), false);
}

act_t IntercomAudioServiceProxy::sendEventNanoMessageErrorStatusRegister(EventNanoMessageErrorStatusCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "EventNanoMessageErrorStatus");
    act_t act = addSignalCallback(ID_EventNanoMessageErrorStatus, "EventNanoMessageErrorStatus", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "EventNanoMessageErrorStatus", &cb, act);
    return act;
}

bool IntercomAudioServiceProxy::sendEventNanoMessageErrorStatusDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("EventNanoMessageErrorStatus", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "EventNanoMessageErrorStatus", act, static_cast<int>(rv));
    return rv;
}

void IntercomAudioServiceProxy::sendEventNanoMessageErrorStatusDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "EventNanoMessageErrorStatus");
    _dbusProxyDelegate->deregisterSignalCallback("EventNanoMessageErrorStatus", 0, _dbusDaemonProxy.get(), false);
}

act_t IntercomAudioServiceProxy::sendEventRTPErrorStatusRegister(EventRTPErrorStatusCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "EventRTPErrorStatus");
    act_t act = addSignalCallback(ID_EventRTPErrorStatus, "EventRTPErrorStatus", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "EventRTPErrorStatus", &cb, act);
    return act;
}

bool IntercomAudioServiceProxy::sendEventRTPErrorStatusDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("EventRTPErrorStatus", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "EventRTPErrorStatus", act, static_cast<int>(rv));
    return rv;
}

void IntercomAudioServiceProxy::sendEventRTPErrorStatusDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "EventRTPErrorStatus");
    _dbusProxyDelegate->deregisterSignalCallback("EventRTPErrorStatus", 0, _dbusDaemonProxy.get(), false);
}

act_t IntercomAudioServiceProxy::sendEventInterComConfigErrorRegister(EventInterComConfigErrorCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "EventInterComConfigError");
    act_t act = addSignalCallback(ID_EventInterComConfigError, "EventInterComConfigError", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "EventInterComConfigError", &cb, act);
    return act;
}

bool IntercomAudioServiceProxy::sendEventInterComConfigErrorDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("EventInterComConfigError", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "EventInterComConfigError", act, static_cast<int>(rv));
    return rv;
}

void IntercomAudioServiceProxy::sendEventInterComConfigErrorDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "EventInterComConfigError");
    _dbusProxyDelegate->deregisterSignalCallback("EventInterComConfigError", 0, _dbusDaemonProxy.get(), false);
}

act_t IntercomAudioServiceProxy::sendEventAudioAllocationStatusRegister(EventAudioAllocationStatusCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "EventAudioAllocationStatus");
    act_t act = addSignalCallback(ID_EventAudioAllocationStatus, "EventAudioAllocationStatus", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "EventAudioAllocationStatus", &cb, act);
    return act;
}

bool IntercomAudioServiceProxy::sendEventAudioAllocationStatusDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("EventAudioAllocationStatus", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "EventAudioAllocationStatus", act, static_cast<int>(rv));
    return rv;
}

void IntercomAudioServiceProxy::sendEventAudioAllocationStatusDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "EventAudioAllocationStatus");
    _dbusProxyDelegate->deregisterSignalCallback("EventAudioAllocationStatus", 0, _dbusDaemonProxy.get(), false);
}

act_t IntercomAudioServiceProxy::sendEventIntercomAvailableRegister(EventIntercomAvailableCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "EventIntercomAvailable");
    act_t act = addSignalCallback(ID_EventIntercomAvailable, "EventIntercomAvailable", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "EventIntercomAvailable", &cb, act);
    return act;
}

bool IntercomAudioServiceProxy::sendEventIntercomAvailableDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("EventIntercomAvailable", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "EventIntercomAvailable", act, static_cast<int>(rv));
    return rv;
}

void IntercomAudioServiceProxy::sendEventIntercomAvailableDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "EventIntercomAvailable");
    _dbusProxyDelegate->deregisterSignalCallback("EventIntercomAvailable", 0, _dbusDaemonProxy.get(), false);
}

act_t IntercomAudioServiceProxy::sendRspIntercomAvailableRegister(RspIntercomAvailableCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "RspIntercomAvailable");
    act_t act = addSignalCallback(ID_RspIntercomAvailable, "RspIntercomAvailable", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "RspIntercomAvailable", &cb, act);
    return act;
}

bool IntercomAudioServiceProxy::sendRspIntercomAvailableDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("RspIntercomAvailable", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "RspIntercomAvailable", act, static_cast<int>(rv));
    return rv;
}

void IntercomAudioServiceProxy::sendRspIntercomAvailableDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "RspIntercomAvailable");
    _dbusProxyDelegate->deregisterSignalCallback("RspIntercomAvailable", 0, _dbusDaemonProxy.get(), false);
}

act_t IntercomAudioServiceProxy::sendOutgoingCallRequest(OutgoingCallCallbackIF& cb, int32 phoneNo) const {
    OutgoingCallRequest* payload = new OutgoingCallRequest();
    CHECK_ALLOCATION(payload);
    payload->setPhoneNo(phoneNo);
    DBUS_MESSAGE_CALL(dbusMessage, "outgoingCall", OutgoingCallRequest, payload, true)
    act_t act = addMethodCallback(ID_outgoingCall, dbusMessage.getUniqueSerial(), "outgoingCall", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "OutgoingCall", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t IntercomAudioServiceProxy::sendGetPhoneStatusRequest(GetPhoneStatusCallbackIF& cb) const {
    GetPhoneStatusRequest* payload = new GetPhoneStatusRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "getPhoneStatus", GetPhoneStatusRequest, payload, true)
    act_t act = addMethodCallback(ID_getPhoneStatus, dbusMessage.getUniqueSerial(), "getPhoneStatus", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetPhoneStatus", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t IntercomAudioServiceProxy::sendCallActionRequest(CallActionCallbackIF& cb, int32 action) const {
    CallActionRequest* payload = new CallActionRequest();
    CHECK_ALLOCATION(payload);
    payload->setAction(action);
    DBUS_MESSAGE_CALL(dbusMessage, "CallAction", CallActionRequest, payload, true)
    act_t act = addMethodCallback(ID_CallAction, dbusMessage.getUniqueSerial(), "CallAction", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "CallAction", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t IntercomAudioServiceProxy::sendGetAvailabilityRequest(GetAvailabilityCallbackIF& cb) const {
    GetAvailabilityRequest* payload = new GetAvailabilityRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "getAvailability", GetAvailabilityRequest, payload, true)
    act_t act = addMethodCallback(ID_getAvailability, dbusMessage.getUniqueSerial(), "getAvailability", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetAvailability", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace IntercomAudioService
} // namespace ai
} // namespace cm
} // namespace bosch
