#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_AI_INTERCOMAUDIOSERVICE_H
#define BOSCH_CM_AI_INTERCOMAUDIOSERVICE_H

#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include <cstring>

/**
 * If the meaning of "IntercomAudioService" isn't clear, then there should be a description here.
 */

namespace bosch {
namespace cm {
namespace ai {
namespace IntercomAudioService {

// method IDs
static const uint16 ID_outgoingCall = 0;
static const uint16 ID_getPhoneStatus = 1;
static const uint16 ID_CallAction = 2;
static const uint16 ID_getAvailability = 3;

// signal IDs
static const uint16 ID_incomingCall = 4;
static const uint16 ID_cancelCall = 5;
static const uint16 ID_activeCallStatus = 6;
static const uint16 ID_IntercomServiceAvailability = 7;
static const uint16 ID_RspPhoneStatus = 8;
static const uint16 ID_EventPhoneStatusChanged = 9;
static const uint16 ID_EventNanoMessageErrorStatus = 10;
static const uint16 ID_EventRTPErrorStatus = 11;
static const uint16 ID_EventInterComConfigError = 12;
static const uint16 ID_EventAudioAllocationStatus = 13;
static const uint16 ID_EventIntercomAvailable = 14;
static const uint16 ID_RspIntercomAvailable = 15;

// property IDs

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class OutgoingCallRequest;

class CallActionRequest;

class IncomingCallSignal;

class RspPhoneStatusSignal;

class EventPhoneStatusChangedSignal;

class EventNanoMessageErrorStatusSignal;

class EventRTPErrorStatusSignal;

class EventInterComConfigErrorSignal;

class EventAudioAllocationStatusSignal;

class EventIntercomAvailableSignal;

class RspIntercomAvailableSignal;

// type definitions
/**
 * If the meaning of "OutgoingCallResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage OutgoingCallResponse;

/**
 * If the meaning of "OutgoingCallError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError OutgoingCallError;

/**
 * If the meaning of "GetPhoneStatusRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetPhoneStatusRequest;

/**
 * If the meaning of "GetPhoneStatusResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetPhoneStatusResponse;

/**
 * If the meaning of "GetPhoneStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetPhoneStatusError;

/**
 * If the meaning of "CallActionResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage CallActionResponse;

/**
 * If the meaning of "CallActionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CallActionError;

/**
 * If the meaning of "GetAvailabilityRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetAvailabilityRequest;

/**
 * If the meaning of "GetAvailabilityResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetAvailabilityResponse;

/**
 * If the meaning of "GetAvailabilityError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetAvailabilityError;

/**
 * If the meaning of "IncomingCallError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError IncomingCallError;

/**
 * If the meaning of "CancelCallSignal" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage CancelCallSignal;

/**
 * If the meaning of "CancelCallError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CancelCallError;

/**
 * If the meaning of "ActiveCallStatusSignal" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ActiveCallStatusSignal;

/**
 * If the meaning of "ActiveCallStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ActiveCallStatusError;

/**
 * If the meaning of "IntercomServiceAvailabilitySignal" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage IntercomServiceAvailabilitySignal;

/**
 * If the meaning of "IntercomServiceAvailabilityError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError IntercomServiceAvailabilityError;

/**
 * If the meaning of "RspPhoneStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RspPhoneStatusError;

/**
 * If the meaning of "EventPhoneStatusChangedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EventPhoneStatusChangedError;

/**
 * If the meaning of "EventNanoMessageErrorStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EventNanoMessageErrorStatusError;

/**
 * If the meaning of "EventRTPErrorStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EventRTPErrorStatusError;

/**
 * If the meaning of "EventInterComConfigErrorError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EventInterComConfigErrorError;

/**
 * If the meaning of "EventAudioAllocationStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EventAudioAllocationStatusError;

/**
 * If the meaning of "EventIntercomAvailableError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EventIntercomAvailableError;

/**
 * If the meaning of "RspIntercomAvailableError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RspIntercomAvailableError;


/**
 * If the meaning of "OutgoingCallRequest" isn't clear, then there should be a description here.
 */
class OutgoingCallRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  OutgoingCallRequest ();

    /**
     * Copy constructor
     */
    inline  OutgoingCallRequest (const OutgoingCallRequest &rhs);

    /**
     * All fields constructor
     */
    inline  OutgoingCallRequest (int32 phoneNo_);

    /**
     * Destructor
     */
    inline virtual  ~OutgoingCallRequest();

    /**
     * Assignment operator
     */
    inline OutgoingCallRequest& operator = (const OutgoingCallRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const OutgoingCallRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const OutgoingCallRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const OutgoingCallRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const OutgoingCallRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "phoneNo"

    static const int kPhoneNo = 0;

    /**
     * Clears the field "phoneNo".
     *
     * The field will be set to its default value. The hasPhoneNo()
     * method will return false.
     */
    inline void clearPhoneNo();

    /**
     * Checks whether the field "phoneNo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneNo()). Otherwise it will return false.
     */
    inline bool hasPhoneNo () const;

    /**
     * Returns the value of the member "phoneNo".
     *
     * If the meaning of "phoneNo" isn't clear, then there should be a description here.
     *
     * @return The value of the field "phoneNo"
     */
    inline int32 getPhoneNo () const;

    /**
     * Sets the value of the member "phoneNo".
     *
     * If the meaning of "phoneNo" isn't clear, then there should be a description here.
     *
     * @param phoneNo The value which will be set
     */
    inline void setPhoneNo (int32 phoneNo_);

    static const OutgoingCallRequest &getDefaultInstance();

private:

    inline void set_has_phoneNo ();

    inline void clear_has_phoneNo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _phoneNo;

};

/**
 * If the meaning of "CallActionRequest" isn't clear, then there should be a description here.
 */
class CallActionRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CallActionRequest ();

    /**
     * Copy constructor
     */
    inline  CallActionRequest (const CallActionRequest &rhs);

    /**
     * All fields constructor
     */
    inline  CallActionRequest (int32 Action_);

    /**
     * Destructor
     */
    inline virtual  ~CallActionRequest();

    /**
     * Assignment operator
     */
    inline CallActionRequest& operator = (const CallActionRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CallActionRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CallActionRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CallActionRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CallActionRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Action"

    static const int kAction = 0;

    /**
     * Clears the field "Action".
     *
     * The field will be set to its default value. The hasAction()
     * method will return false.
     */
    inline void clearAction();

    /**
     * Checks whether the field "Action" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAction()). Otherwise it will return false.
     */
    inline bool hasAction () const;

    /**
     * Returns the value of the member "Action".
     *
     * If the meaning of "Action" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Action"
     */
    inline int32 getAction () const;

    /**
     * Sets the value of the member "Action".
     *
     * If the meaning of "Action" isn't clear, then there should be a description here.
     *
     * @param Action The value which will be set
     */
    inline void setAction (int32 Action_);

    static const CallActionRequest &getDefaultInstance();

private:

    inline void set_has_Action ();

    inline void clear_has_Action ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _Action;

};

/**
 * If the meaning of "IncomingCallSignal" isn't clear, then there should be a description here.
 */
class IncomingCallSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IncomingCallSignal ();

    /**
     * Copy constructor
     */
    inline  IncomingCallSignal (const IncomingCallSignal &rhs);

    /**
     * All fields constructor
     */
    inline  IncomingCallSignal (int32 phoneNo_);

    /**
     * Destructor
     */
    inline virtual  ~IncomingCallSignal();

    /**
     * Assignment operator
     */
    inline IncomingCallSignal& operator = (const IncomingCallSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IncomingCallSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IncomingCallSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IncomingCallSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IncomingCallSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "phoneNo"

    static const int kPhoneNo = 0;

    /**
     * Clears the field "phoneNo".
     *
     * The field will be set to its default value. The hasPhoneNo()
     * method will return false.
     */
    inline void clearPhoneNo();

    /**
     * Checks whether the field "phoneNo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneNo()). Otherwise it will return false.
     */
    inline bool hasPhoneNo () const;

    /**
     * Returns the value of the member "phoneNo".
     *
     * If the meaning of "phoneNo" isn't clear, then there should be a description here.
     *
     * @return The value of the field "phoneNo"
     */
    inline int32 getPhoneNo () const;

    /**
     * Sets the value of the member "phoneNo".
     *
     * If the meaning of "phoneNo" isn't clear, then there should be a description here.
     *
     * @param phoneNo The value which will be set
     */
    inline void setPhoneNo (int32 phoneNo_);

    static const IncomingCallSignal &getDefaultInstance();

private:

    inline void set_has_phoneNo ();

    inline void clear_has_phoneNo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _phoneNo;

};

/**
 * If the meaning of "RspPhoneStatusSignal" isn't clear, then there should be a description here.
 */
class RspPhoneStatusSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RspPhoneStatusSignal ();

    /**
     * Copy constructor
     */
    inline  RspPhoneStatusSignal (const RspPhoneStatusSignal &rhs);

    /**
     * All fields constructor
     */
    inline  RspPhoneStatusSignal (uint8 RestRoomPhoneStatus_, uint8 KitchenPhoneStatus_, uint8 UpperDeckPhoneStatus_);

    /**
     * Destructor
     */
    inline virtual  ~RspPhoneStatusSignal();

    /**
     * Assignment operator
     */
    inline RspPhoneStatusSignal& operator = (const RspPhoneStatusSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RspPhoneStatusSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RspPhoneStatusSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RspPhoneStatusSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RspPhoneStatusSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RestRoomPhoneStatus"

    static const int kRestRoomPhoneStatus = 0;

    /**
     * Clears the field "RestRoomPhoneStatus".
     *
     * The field will be set to its default value. The hasRestRoomPhoneStatus()
     * method will return false.
     */
    inline void clearRestRoomPhoneStatus();

    /**
     * Checks whether the field "RestRoomPhoneStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRestRoomPhoneStatus()). Otherwise it will return false.
     */
    inline bool hasRestRoomPhoneStatus () const;

    /**
     * Returns the value of the member "RestRoomPhoneStatus".
     *
     * If the meaning of "RestRoomPhoneStatus" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RestRoomPhoneStatus"
     */
    inline uint8 getRestRoomPhoneStatus () const;

    /**
     * Sets the value of the member "RestRoomPhoneStatus".
     *
     * If the meaning of "RestRoomPhoneStatus" isn't clear, then there should be a description here.
     *
     * @param RestRoomPhoneStatus The value which will be set
     */
    inline void setRestRoomPhoneStatus (uint8 RestRoomPhoneStatus_);

    // API of field "KitchenPhoneStatus"

    static const int kKitchenPhoneStatus = 1;

    /**
     * Clears the field "KitchenPhoneStatus".
     *
     * The field will be set to its default value. The hasKitchenPhoneStatus()
     * method will return false.
     */
    inline void clearKitchenPhoneStatus();

    /**
     * Checks whether the field "KitchenPhoneStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setKitchenPhoneStatus()). Otherwise it will return false.
     */
    inline bool hasKitchenPhoneStatus () const;

    /**
     * Returns the value of the member "KitchenPhoneStatus".
     *
     * If the meaning of "KitchenPhoneStatus" isn't clear, then there should be a description here.
     *
     * @return The value of the field "KitchenPhoneStatus"
     */
    inline uint8 getKitchenPhoneStatus () const;

    /**
     * Sets the value of the member "KitchenPhoneStatus".
     *
     * If the meaning of "KitchenPhoneStatus" isn't clear, then there should be a description here.
     *
     * @param KitchenPhoneStatus The value which will be set
     */
    inline void setKitchenPhoneStatus (uint8 KitchenPhoneStatus_);

    // API of field "UpperDeckPhoneStatus"

    static const int kUpperDeckPhoneStatus = 2;

    /**
     * Clears the field "UpperDeckPhoneStatus".
     *
     * The field will be set to its default value. The hasUpperDeckPhoneStatus()
     * method will return false.
     */
    inline void clearUpperDeckPhoneStatus();

    /**
     * Checks whether the field "UpperDeckPhoneStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpperDeckPhoneStatus()). Otherwise it will return false.
     */
    inline bool hasUpperDeckPhoneStatus () const;

    /**
     * Returns the value of the member "UpperDeckPhoneStatus".
     *
     * If the meaning of "UpperDeckPhoneStatus" isn't clear, then there should be a description here.
     *
     * @return The value of the field "UpperDeckPhoneStatus"
     */
    inline uint8 getUpperDeckPhoneStatus () const;

    /**
     * Sets the value of the member "UpperDeckPhoneStatus".
     *
     * If the meaning of "UpperDeckPhoneStatus" isn't clear, then there should be a description here.
     *
     * @param UpperDeckPhoneStatus The value which will be set
     */
    inline void setUpperDeckPhoneStatus (uint8 UpperDeckPhoneStatus_);

    static const RspPhoneStatusSignal &getDefaultInstance();

private:

    inline void set_has_RestRoomPhoneStatus ();

    inline void clear_has_RestRoomPhoneStatus ();

    inline void set_has_KitchenPhoneStatus ();

    inline void clear_has_KitchenPhoneStatus ();

    inline void set_has_UpperDeckPhoneStatus ();

    inline void clear_has_UpperDeckPhoneStatus ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _RestRoomPhoneStatus;

    uint8 _KitchenPhoneStatus;

    uint8 _UpperDeckPhoneStatus;

};

/**
 * If the meaning of "EventPhoneStatusChangedSignal" isn't clear, then there should be a description here.
 */
class EventPhoneStatusChangedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EventPhoneStatusChangedSignal ();

    /**
     * Copy constructor
     */
    inline  EventPhoneStatusChangedSignal (const EventPhoneStatusChangedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  EventPhoneStatusChangedSignal (uint8 PhoneStatus_, uint8 PhoneNumber_);

    /**
     * Destructor
     */
    inline virtual  ~EventPhoneStatusChangedSignal();

    /**
     * Assignment operator
     */
    inline EventPhoneStatusChangedSignal& operator = (const EventPhoneStatusChangedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EventPhoneStatusChangedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EventPhoneStatusChangedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EventPhoneStatusChangedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EventPhoneStatusChangedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PhoneStatus"

    static const int kPhoneStatus = 0;

    /**
     * Clears the field "PhoneStatus".
     *
     * The field will be set to its default value. The hasPhoneStatus()
     * method will return false.
     */
    inline void clearPhoneStatus();

    /**
     * Checks whether the field "PhoneStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneStatus()). Otherwise it will return false.
     */
    inline bool hasPhoneStatus () const;

    /**
     * Returns the value of the member "PhoneStatus".
     *
     * If the meaning of "PhoneStatus" isn't clear, then there should be a description here.
     *
     * @return The value of the field "PhoneStatus"
     */
    inline uint8 getPhoneStatus () const;

    /**
     * Sets the value of the member "PhoneStatus".
     *
     * If the meaning of "PhoneStatus" isn't clear, then there should be a description here.
     *
     * @param PhoneStatus The value which will be set
     */
    inline void setPhoneStatus (uint8 PhoneStatus_);

    // API of field "PhoneNumber"

    static const int kPhoneNumber = 1;

    /**
     * Clears the field "PhoneNumber".
     *
     * The field will be set to its default value. The hasPhoneNumber()
     * method will return false.
     */
    inline void clearPhoneNumber();

    /**
     * Checks whether the field "PhoneNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneNumber()). Otherwise it will return false.
     */
    inline bool hasPhoneNumber () const;

    /**
     * Returns the value of the member "PhoneNumber".
     *
     * If the meaning of "PhoneNumber" isn't clear, then there should be a description here.
     *
     * @return The value of the field "PhoneNumber"
     */
    inline uint8 getPhoneNumber () const;

    /**
     * Sets the value of the member "PhoneNumber".
     *
     * If the meaning of "PhoneNumber" isn't clear, then there should be a description here.
     *
     * @param PhoneNumber The value which will be set
     */
    inline void setPhoneNumber (uint8 PhoneNumber_);

    static const EventPhoneStatusChangedSignal &getDefaultInstance();

private:

    inline void set_has_PhoneStatus ();

    inline void clear_has_PhoneStatus ();

    inline void set_has_PhoneNumber ();

    inline void clear_has_PhoneNumber ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _PhoneStatus;

    uint8 _PhoneNumber;

};

/**
 * If the meaning of "EventNanoMessageErrorStatusSignal" isn't clear, then there should be a description here.
 */
class EventNanoMessageErrorStatusSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EventNanoMessageErrorStatusSignal ();

    /**
     * Copy constructor
     */
    inline  EventNanoMessageErrorStatusSignal (const EventNanoMessageErrorStatusSignal &rhs);

    /**
     * All fields constructor
     */
    inline  EventNanoMessageErrorStatusSignal (uint8 ErrorCodes_);

    /**
     * Destructor
     */
    inline virtual  ~EventNanoMessageErrorStatusSignal();

    /**
     * Assignment operator
     */
    inline EventNanoMessageErrorStatusSignal& operator = (const EventNanoMessageErrorStatusSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EventNanoMessageErrorStatusSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EventNanoMessageErrorStatusSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EventNanoMessageErrorStatusSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EventNanoMessageErrorStatusSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCodes"

    static const int kErrorCodes = 0;

    /**
     * Clears the field "ErrorCodes".
     *
     * The field will be set to its default value. The hasErrorCodes()
     * method will return false.
     */
    inline void clearErrorCodes();

    /**
     * Checks whether the field "ErrorCodes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCodes()). Otherwise it will return false.
     */
    inline bool hasErrorCodes () const;

    /**
     * Returns the value of the member "ErrorCodes".
     *
     * If the meaning of "ErrorCodes" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ErrorCodes"
     */
    inline uint8 getErrorCodes () const;

    /**
     * Sets the value of the member "ErrorCodes".
     *
     * If the meaning of "ErrorCodes" isn't clear, then there should be a description here.
     *
     * @param ErrorCodes The value which will be set
     */
    inline void setErrorCodes (uint8 ErrorCodes_);

    static const EventNanoMessageErrorStatusSignal &getDefaultInstance();

private:

    inline void set_has_ErrorCodes ();

    inline void clear_has_ErrorCodes ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCodes;

};

/**
 * If the meaning of "EventRTPErrorStatusSignal" isn't clear, then there should be a description here.
 */
class EventRTPErrorStatusSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EventRTPErrorStatusSignal ();

    /**
     * Copy constructor
     */
    inline  EventRTPErrorStatusSignal (const EventRTPErrorStatusSignal &rhs);

    /**
     * All fields constructor
     */
    inline  EventRTPErrorStatusSignal (uint8 ErrorCodes_);

    /**
     * Destructor
     */
    inline virtual  ~EventRTPErrorStatusSignal();

    /**
     * Assignment operator
     */
    inline EventRTPErrorStatusSignal& operator = (const EventRTPErrorStatusSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EventRTPErrorStatusSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EventRTPErrorStatusSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EventRTPErrorStatusSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EventRTPErrorStatusSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCodes"

    static const int kErrorCodes = 0;

    /**
     * Clears the field "ErrorCodes".
     *
     * The field will be set to its default value. The hasErrorCodes()
     * method will return false.
     */
    inline void clearErrorCodes();

    /**
     * Checks whether the field "ErrorCodes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCodes()). Otherwise it will return false.
     */
    inline bool hasErrorCodes () const;

    /**
     * Returns the value of the member "ErrorCodes".
     *
     * If the meaning of "ErrorCodes" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ErrorCodes"
     */
    inline uint8 getErrorCodes () const;

    /**
     * Sets the value of the member "ErrorCodes".
     *
     * If the meaning of "ErrorCodes" isn't clear, then there should be a description here.
     *
     * @param ErrorCodes The value which will be set
     */
    inline void setErrorCodes (uint8 ErrorCodes_);

    static const EventRTPErrorStatusSignal &getDefaultInstance();

private:

    inline void set_has_ErrorCodes ();

    inline void clear_has_ErrorCodes ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCodes;

};

/**
 * If the meaning of "EventInterComConfigErrorSignal" isn't clear, then there should be a description here.
 */
class EventInterComConfigErrorSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EventInterComConfigErrorSignal ();

    /**
     * Copy constructor
     */
    inline  EventInterComConfigErrorSignal (const EventInterComConfigErrorSignal &rhs);

    /**
     * All fields constructor
     */
    inline  EventInterComConfigErrorSignal (uint8 ErrorCodes_);

    /**
     * Destructor
     */
    inline virtual  ~EventInterComConfigErrorSignal();

    /**
     * Assignment operator
     */
    inline EventInterComConfigErrorSignal& operator = (const EventInterComConfigErrorSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EventInterComConfigErrorSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EventInterComConfigErrorSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EventInterComConfigErrorSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EventInterComConfigErrorSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCodes"

    static const int kErrorCodes = 0;

    /**
     * Clears the field "ErrorCodes".
     *
     * The field will be set to its default value. The hasErrorCodes()
     * method will return false.
     */
    inline void clearErrorCodes();

    /**
     * Checks whether the field "ErrorCodes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCodes()). Otherwise it will return false.
     */
    inline bool hasErrorCodes () const;

    /**
     * Returns the value of the member "ErrorCodes".
     *
     * If the meaning of "ErrorCodes" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ErrorCodes"
     */
    inline uint8 getErrorCodes () const;

    /**
     * Sets the value of the member "ErrorCodes".
     *
     * If the meaning of "ErrorCodes" isn't clear, then there should be a description here.
     *
     * @param ErrorCodes The value which will be set
     */
    inline void setErrorCodes (uint8 ErrorCodes_);

    static const EventInterComConfigErrorSignal &getDefaultInstance();

private:

    inline void set_has_ErrorCodes ();

    inline void clear_has_ErrorCodes ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCodes;

};

/**
 * If the meaning of "EventAudioAllocationStatusSignal" isn't clear, then there should be a description here.
 */
class EventAudioAllocationStatusSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EventAudioAllocationStatusSignal ();

    /**
     * Copy constructor
     */
    inline  EventAudioAllocationStatusSignal (const EventAudioAllocationStatusSignal &rhs);

    /**
     * All fields constructor
     */
    inline  EventAudioAllocationStatusSignal (uint8 AllocationStatus_);

    /**
     * Destructor
     */
    inline virtual  ~EventAudioAllocationStatusSignal();

    /**
     * Assignment operator
     */
    inline EventAudioAllocationStatusSignal& operator = (const EventAudioAllocationStatusSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EventAudioAllocationStatusSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EventAudioAllocationStatusSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EventAudioAllocationStatusSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EventAudioAllocationStatusSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AllocationStatus"

    static const int kAllocationStatus = 0;

    /**
     * Clears the field "AllocationStatus".
     *
     * The field will be set to its default value. The hasAllocationStatus()
     * method will return false.
     */
    inline void clearAllocationStatus();

    /**
     * Checks whether the field "AllocationStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAllocationStatus()). Otherwise it will return false.
     */
    inline bool hasAllocationStatus () const;

    /**
     * Returns the value of the member "AllocationStatus".
     *
     * If the meaning of "AllocationStatus" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AllocationStatus"
     */
    inline uint8 getAllocationStatus () const;

    /**
     * Sets the value of the member "AllocationStatus".
     *
     * If the meaning of "AllocationStatus" isn't clear, then there should be a description here.
     *
     * @param AllocationStatus The value which will be set
     */
    inline void setAllocationStatus (uint8 AllocationStatus_);

    static const EventAudioAllocationStatusSignal &getDefaultInstance();

private:

    inline void set_has_AllocationStatus ();

    inline void clear_has_AllocationStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _AllocationStatus;

};

/**
 * If the meaning of "EventIntercomAvailableSignal" isn't clear, then there should be a description here.
 */
class EventIntercomAvailableSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EventIntercomAvailableSignal ();

    /**
     * Copy constructor
     */
    inline  EventIntercomAvailableSignal (const EventIntercomAvailableSignal &rhs);

    /**
     * All fields constructor
     */
    inline  EventIntercomAvailableSignal (uint8 Available_);

    /**
     * Destructor
     */
    inline virtual  ~EventIntercomAvailableSignal();

    /**
     * Assignment operator
     */
    inline EventIntercomAvailableSignal& operator = (const EventIntercomAvailableSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EventIntercomAvailableSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EventIntercomAvailableSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EventIntercomAvailableSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EventIntercomAvailableSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Available"

    static const int kAvailable = 0;

    /**
     * Clears the field "Available".
     *
     * The field will be set to its default value. The hasAvailable()
     * method will return false.
     */
    inline void clearAvailable();

    /**
     * Checks whether the field "Available" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAvailable()). Otherwise it will return false.
     */
    inline bool hasAvailable () const;

    /**
     * Returns the value of the member "Available".
     *
     * If the meaning of "Available" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Available"
     */
    inline uint8 getAvailable () const;

    /**
     * Sets the value of the member "Available".
     *
     * If the meaning of "Available" isn't clear, then there should be a description here.
     *
     * @param Available The value which will be set
     */
    inline void setAvailable (uint8 Available_);

    static const EventIntercomAvailableSignal &getDefaultInstance();

private:

    inline void set_has_Available ();

    inline void clear_has_Available ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Available;

};

/**
 * If the meaning of "RspIntercomAvailableSignal" isn't clear, then there should be a description here.
 */
class RspIntercomAvailableSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RspIntercomAvailableSignal ();

    /**
     * Copy constructor
     */
    inline  RspIntercomAvailableSignal (const RspIntercomAvailableSignal &rhs);

    /**
     * All fields constructor
     */
    inline  RspIntercomAvailableSignal (uint8 Available_);

    /**
     * Destructor
     */
    inline virtual  ~RspIntercomAvailableSignal();

    /**
     * Assignment operator
     */
    inline RspIntercomAvailableSignal& operator = (const RspIntercomAvailableSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RspIntercomAvailableSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RspIntercomAvailableSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RspIntercomAvailableSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RspIntercomAvailableSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Available"

    static const int kAvailable = 0;

    /**
     * Clears the field "Available".
     *
     * The field will be set to its default value. The hasAvailable()
     * method will return false.
     */
    inline void clearAvailable();

    /**
     * Checks whether the field "Available" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAvailable()). Otherwise it will return false.
     */
    inline bool hasAvailable () const;

    /**
     * Returns the value of the member "Available".
     *
     * If the meaning of "Available" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Available"
     */
    inline uint8 getAvailable () const;

    /**
     * Sets the value of the member "Available".
     *
     * If the meaning of "Available" isn't clear, then there should be a description here.
     *
     * @param Available The value which will be set
     */
    inline void setAvailable (uint8 Available_);

    static const RspIntercomAvailableSignal &getDefaultInstance();

private:

    inline void set_has_Available ();

    inline void clear_has_Available ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Available;

};

inline  OutgoingCallRequest::OutgoingCallRequest ()  :
    _phoneNo (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  OutgoingCallRequest::OutgoingCallRequest (const OutgoingCallRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _phoneNo (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  OutgoingCallRequest::OutgoingCallRequest (int32 phoneNo_)  :
    _phoneNo (phoneNo_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  OutgoingCallRequest::~OutgoingCallRequest() {
}

inline OutgoingCallRequest& OutgoingCallRequest::operator = (const OutgoingCallRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPhoneNo()) {
            setPhoneNo(rhs.getPhoneNo());
        } else {
            clearPhoneNo();
        }
    }
    return *this;
}

inline bool OutgoingCallRequest::operator == (const OutgoingCallRequest& rhs) const {
    return (((!hasPhoneNo() && !rhs.hasPhoneNo()) || getPhoneNo() == rhs.getPhoneNo()));
}

inline bool OutgoingCallRequest::operator != (const OutgoingCallRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool OutgoingCallRequest::operator < (const OutgoingCallRequest& rhs) const {
    if (hasPhoneNo() || rhs.hasPhoneNo()) {
        if (getPhoneNo() < rhs.getPhoneNo()) return true;
        if (getPhoneNo() > rhs.getPhoneNo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* OutgoingCallRequest::clone() {
    return new OutgoingCallRequest(*this);
}

inline bool OutgoingCallRequest::operator > (const OutgoingCallRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void OutgoingCallRequest::clear() {
    clearPhoneNo();
}

inline void OutgoingCallRequest::clearPhoneNo() {
    if (hasPhoneNo()) {
         clear_has_phoneNo();
        _phoneNo = 0;
     }
}

inline bool OutgoingCallRequest::hasPhoneNo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 OutgoingCallRequest::getPhoneNo () const {
    return _phoneNo;
}

inline void OutgoingCallRequest::setPhoneNo (int32 phoneNo_) {
    set_has_phoneNo();
    this->_phoneNo = phoneNo_;
}

inline void OutgoingCallRequest::set_has_phoneNo () {
    _has_bits_[0] |= 1u << 0;
}

inline void OutgoingCallRequest::clear_has_phoneNo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CallActionRequest::CallActionRequest ()  :
    _Action (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CallActionRequest::CallActionRequest (const CallActionRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _Action (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CallActionRequest::CallActionRequest (int32 Action_)  :
    _Action (Action_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CallActionRequest::~CallActionRequest() {
}

inline CallActionRequest& CallActionRequest::operator = (const CallActionRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAction()) {
            setAction(rhs.getAction());
        } else {
            clearAction();
        }
    }
    return *this;
}

inline bool CallActionRequest::operator == (const CallActionRequest& rhs) const {
    return (((!hasAction() && !rhs.hasAction()) || getAction() == rhs.getAction()));
}

inline bool CallActionRequest::operator != (const CallActionRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool CallActionRequest::operator < (const CallActionRequest& rhs) const {
    if (hasAction() || rhs.hasAction()) {
        if (getAction() < rhs.getAction()) return true;
        if (getAction() > rhs.getAction()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CallActionRequest::clone() {
    return new CallActionRequest(*this);
}

inline bool CallActionRequest::operator > (const CallActionRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CallActionRequest::clear() {
    clearAction();
}

inline void CallActionRequest::clearAction() {
    if (hasAction()) {
         clear_has_Action();
        _Action = 0;
     }
}

inline bool CallActionRequest::hasAction () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 CallActionRequest::getAction () const {
    return _Action;
}

inline void CallActionRequest::setAction (int32 Action_) {
    set_has_Action();
    this->_Action = Action_;
}

inline void CallActionRequest::set_has_Action () {
    _has_bits_[0] |= 1u << 0;
}

inline void CallActionRequest::clear_has_Action () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  IncomingCallSignal::IncomingCallSignal ()  :
    _phoneNo (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  IncomingCallSignal::IncomingCallSignal (const IncomingCallSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _phoneNo (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  IncomingCallSignal::IncomingCallSignal (int32 phoneNo_)  :
    _phoneNo (phoneNo_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  IncomingCallSignal::~IncomingCallSignal() {
}

inline IncomingCallSignal& IncomingCallSignal::operator = (const IncomingCallSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPhoneNo()) {
            setPhoneNo(rhs.getPhoneNo());
        } else {
            clearPhoneNo();
        }
    }
    return *this;
}

inline bool IncomingCallSignal::operator == (const IncomingCallSignal& rhs) const {
    return (((!hasPhoneNo() && !rhs.hasPhoneNo()) || getPhoneNo() == rhs.getPhoneNo()));
}

inline bool IncomingCallSignal::operator != (const IncomingCallSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool IncomingCallSignal::operator < (const IncomingCallSignal& rhs) const {
    if (hasPhoneNo() || rhs.hasPhoneNo()) {
        if (getPhoneNo() < rhs.getPhoneNo()) return true;
        if (getPhoneNo() > rhs.getPhoneNo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* IncomingCallSignal::clone() {
    return new IncomingCallSignal(*this);
}

inline bool IncomingCallSignal::operator > (const IncomingCallSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void IncomingCallSignal::clear() {
    clearPhoneNo();
}

inline void IncomingCallSignal::clearPhoneNo() {
    if (hasPhoneNo()) {
         clear_has_phoneNo();
        _phoneNo = 0;
     }
}

inline bool IncomingCallSignal::hasPhoneNo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 IncomingCallSignal::getPhoneNo () const {
    return _phoneNo;
}

inline void IncomingCallSignal::setPhoneNo (int32 phoneNo_) {
    set_has_phoneNo();
    this->_phoneNo = phoneNo_;
}

inline void IncomingCallSignal::set_has_phoneNo () {
    _has_bits_[0] |= 1u << 0;
}

inline void IncomingCallSignal::clear_has_phoneNo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RspPhoneStatusSignal::RspPhoneStatusSignal ()  :
    _RestRoomPhoneStatus (0u),
    _KitchenPhoneStatus (0u),
    _UpperDeckPhoneStatus (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RspPhoneStatusSignal::RspPhoneStatusSignal (const RspPhoneStatusSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _RestRoomPhoneStatus (0u),
    _KitchenPhoneStatus (0u),
    _UpperDeckPhoneStatus (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RspPhoneStatusSignal::RspPhoneStatusSignal (uint8 RestRoomPhoneStatus_, uint8 KitchenPhoneStatus_, uint8 UpperDeckPhoneStatus_)  :
    _RestRoomPhoneStatus (RestRoomPhoneStatus_),
    _KitchenPhoneStatus (KitchenPhoneStatus_),
    _UpperDeckPhoneStatus (UpperDeckPhoneStatus_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RspPhoneStatusSignal::~RspPhoneStatusSignal() {
}

inline RspPhoneStatusSignal& RspPhoneStatusSignal::operator = (const RspPhoneStatusSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRestRoomPhoneStatus()) {
            setRestRoomPhoneStatus(rhs.getRestRoomPhoneStatus());
        } else {
            clearRestRoomPhoneStatus();
        }
        if (rhs.hasKitchenPhoneStatus()) {
            setKitchenPhoneStatus(rhs.getKitchenPhoneStatus());
        } else {
            clearKitchenPhoneStatus();
        }
        if (rhs.hasUpperDeckPhoneStatus()) {
            setUpperDeckPhoneStatus(rhs.getUpperDeckPhoneStatus());
        } else {
            clearUpperDeckPhoneStatus();
        }
    }
    return *this;
}

inline bool RspPhoneStatusSignal::operator == (const RspPhoneStatusSignal& rhs) const {
    return (((!hasRestRoomPhoneStatus() && !rhs.hasRestRoomPhoneStatus()) || getRestRoomPhoneStatus() == rhs.getRestRoomPhoneStatus()) &&
        ((!hasKitchenPhoneStatus() && !rhs.hasKitchenPhoneStatus()) || getKitchenPhoneStatus() == rhs.getKitchenPhoneStatus()) &&
        ((!hasUpperDeckPhoneStatus() && !rhs.hasUpperDeckPhoneStatus()) || getUpperDeckPhoneStatus() == rhs.getUpperDeckPhoneStatus()));
}

inline bool RspPhoneStatusSignal::operator != (const RspPhoneStatusSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool RspPhoneStatusSignal::operator < (const RspPhoneStatusSignal& rhs) const {
    if (hasRestRoomPhoneStatus() || rhs.hasRestRoomPhoneStatus()) {
        if (getRestRoomPhoneStatus() < rhs.getRestRoomPhoneStatus()) return true;
        if (getRestRoomPhoneStatus() > rhs.getRestRoomPhoneStatus()) return false;
    }
    if (hasKitchenPhoneStatus() || rhs.hasKitchenPhoneStatus()) {
        if (getKitchenPhoneStatus() < rhs.getKitchenPhoneStatus()) return true;
        if (getKitchenPhoneStatus() > rhs.getKitchenPhoneStatus()) return false;
    }
    if (hasUpperDeckPhoneStatus() || rhs.hasUpperDeckPhoneStatus()) {
        if (getUpperDeckPhoneStatus() < rhs.getUpperDeckPhoneStatus()) return true;
        if (getUpperDeckPhoneStatus() > rhs.getUpperDeckPhoneStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RspPhoneStatusSignal::clone() {
    return new RspPhoneStatusSignal(*this);
}

inline bool RspPhoneStatusSignal::operator > (const RspPhoneStatusSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RspPhoneStatusSignal::clear() {
    clearRestRoomPhoneStatus();
    clearKitchenPhoneStatus();
    clearUpperDeckPhoneStatus();
}

inline void RspPhoneStatusSignal::clearRestRoomPhoneStatus() {
    if (hasRestRoomPhoneStatus()) {
         clear_has_RestRoomPhoneStatus();
        _RestRoomPhoneStatus = 0u;
     }
}

inline bool RspPhoneStatusSignal::hasRestRoomPhoneStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 RspPhoneStatusSignal::getRestRoomPhoneStatus () const {
    return _RestRoomPhoneStatus;
}

inline void RspPhoneStatusSignal::setRestRoomPhoneStatus (uint8 RestRoomPhoneStatus_) {
    set_has_RestRoomPhoneStatus();
    this->_RestRoomPhoneStatus = RestRoomPhoneStatus_;
}

inline void RspPhoneStatusSignal::clearKitchenPhoneStatus() {
    if (hasKitchenPhoneStatus()) {
         clear_has_KitchenPhoneStatus();
        _KitchenPhoneStatus = 0u;
     }
}

inline bool RspPhoneStatusSignal::hasKitchenPhoneStatus () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 RspPhoneStatusSignal::getKitchenPhoneStatus () const {
    return _KitchenPhoneStatus;
}

inline void RspPhoneStatusSignal::setKitchenPhoneStatus (uint8 KitchenPhoneStatus_) {
    set_has_KitchenPhoneStatus();
    this->_KitchenPhoneStatus = KitchenPhoneStatus_;
}

inline void RspPhoneStatusSignal::clearUpperDeckPhoneStatus() {
    if (hasUpperDeckPhoneStatus()) {
         clear_has_UpperDeckPhoneStatus();
        _UpperDeckPhoneStatus = 0u;
     }
}

inline bool RspPhoneStatusSignal::hasUpperDeckPhoneStatus () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 RspPhoneStatusSignal::getUpperDeckPhoneStatus () const {
    return _UpperDeckPhoneStatus;
}

inline void RspPhoneStatusSignal::setUpperDeckPhoneStatus (uint8 UpperDeckPhoneStatus_) {
    set_has_UpperDeckPhoneStatus();
    this->_UpperDeckPhoneStatus = UpperDeckPhoneStatus_;
}

inline void RspPhoneStatusSignal::set_has_RestRoomPhoneStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void RspPhoneStatusSignal::clear_has_RestRoomPhoneStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RspPhoneStatusSignal::set_has_KitchenPhoneStatus () {
    _has_bits_[0] |= 1u << 1;
}

inline void RspPhoneStatusSignal::clear_has_KitchenPhoneStatus () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void RspPhoneStatusSignal::set_has_UpperDeckPhoneStatus () {
    _has_bits_[0] |= 1u << 2;
}

inline void RspPhoneStatusSignal::clear_has_UpperDeckPhoneStatus () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  EventPhoneStatusChangedSignal::EventPhoneStatusChangedSignal ()  :
    _PhoneStatus (0u),
    _PhoneNumber (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EventPhoneStatusChangedSignal::EventPhoneStatusChangedSignal (const EventPhoneStatusChangedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _PhoneStatus (0u),
    _PhoneNumber (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EventPhoneStatusChangedSignal::EventPhoneStatusChangedSignal (uint8 PhoneStatus_, uint8 PhoneNumber_)  :
    _PhoneStatus (PhoneStatus_),
    _PhoneNumber (PhoneNumber_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EventPhoneStatusChangedSignal::~EventPhoneStatusChangedSignal() {
}

inline EventPhoneStatusChangedSignal& EventPhoneStatusChangedSignal::operator = (const EventPhoneStatusChangedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPhoneStatus()) {
            setPhoneStatus(rhs.getPhoneStatus());
        } else {
            clearPhoneStatus();
        }
        if (rhs.hasPhoneNumber()) {
            setPhoneNumber(rhs.getPhoneNumber());
        } else {
            clearPhoneNumber();
        }
    }
    return *this;
}

inline bool EventPhoneStatusChangedSignal::operator == (const EventPhoneStatusChangedSignal& rhs) const {
    return (((!hasPhoneStatus() && !rhs.hasPhoneStatus()) || getPhoneStatus() == rhs.getPhoneStatus()) &&
        ((!hasPhoneNumber() && !rhs.hasPhoneNumber()) || getPhoneNumber() == rhs.getPhoneNumber()));
}

inline bool EventPhoneStatusChangedSignal::operator != (const EventPhoneStatusChangedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool EventPhoneStatusChangedSignal::operator < (const EventPhoneStatusChangedSignal& rhs) const {
    if (hasPhoneStatus() || rhs.hasPhoneStatus()) {
        if (getPhoneStatus() < rhs.getPhoneStatus()) return true;
        if (getPhoneStatus() > rhs.getPhoneStatus()) return false;
    }
    if (hasPhoneNumber() || rhs.hasPhoneNumber()) {
        if (getPhoneNumber() < rhs.getPhoneNumber()) return true;
        if (getPhoneNumber() > rhs.getPhoneNumber()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EventPhoneStatusChangedSignal::clone() {
    return new EventPhoneStatusChangedSignal(*this);
}

inline bool EventPhoneStatusChangedSignal::operator > (const EventPhoneStatusChangedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EventPhoneStatusChangedSignal::clear() {
    clearPhoneStatus();
    clearPhoneNumber();
}

inline void EventPhoneStatusChangedSignal::clearPhoneStatus() {
    if (hasPhoneStatus()) {
         clear_has_PhoneStatus();
        _PhoneStatus = 0u;
     }
}

inline bool EventPhoneStatusChangedSignal::hasPhoneStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 EventPhoneStatusChangedSignal::getPhoneStatus () const {
    return _PhoneStatus;
}

inline void EventPhoneStatusChangedSignal::setPhoneStatus (uint8 PhoneStatus_) {
    set_has_PhoneStatus();
    this->_PhoneStatus = PhoneStatus_;
}

inline void EventPhoneStatusChangedSignal::clearPhoneNumber() {
    if (hasPhoneNumber()) {
         clear_has_PhoneNumber();
        _PhoneNumber = 0u;
     }
}

inline bool EventPhoneStatusChangedSignal::hasPhoneNumber () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 EventPhoneStatusChangedSignal::getPhoneNumber () const {
    return _PhoneNumber;
}

inline void EventPhoneStatusChangedSignal::setPhoneNumber (uint8 PhoneNumber_) {
    set_has_PhoneNumber();
    this->_PhoneNumber = PhoneNumber_;
}

inline void EventPhoneStatusChangedSignal::set_has_PhoneStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void EventPhoneStatusChangedSignal::clear_has_PhoneStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void EventPhoneStatusChangedSignal::set_has_PhoneNumber () {
    _has_bits_[0] |= 1u << 1;
}

inline void EventPhoneStatusChangedSignal::clear_has_PhoneNumber () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  EventNanoMessageErrorStatusSignal::EventNanoMessageErrorStatusSignal ()  :
    _ErrorCodes (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EventNanoMessageErrorStatusSignal::EventNanoMessageErrorStatusSignal (const EventNanoMessageErrorStatusSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _ErrorCodes (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EventNanoMessageErrorStatusSignal::EventNanoMessageErrorStatusSignal (uint8 ErrorCodes_)  :
    _ErrorCodes (ErrorCodes_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EventNanoMessageErrorStatusSignal::~EventNanoMessageErrorStatusSignal() {
}

inline EventNanoMessageErrorStatusSignal& EventNanoMessageErrorStatusSignal::operator = (const EventNanoMessageErrorStatusSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasErrorCodes()) {
            setErrorCodes(rhs.getErrorCodes());
        } else {
            clearErrorCodes();
        }
    }
    return *this;
}

inline bool EventNanoMessageErrorStatusSignal::operator == (const EventNanoMessageErrorStatusSignal& rhs) const {
    return (((!hasErrorCodes() && !rhs.hasErrorCodes()) || getErrorCodes() == rhs.getErrorCodes()));
}

inline bool EventNanoMessageErrorStatusSignal::operator != (const EventNanoMessageErrorStatusSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool EventNanoMessageErrorStatusSignal::operator < (const EventNanoMessageErrorStatusSignal& rhs) const {
    if (hasErrorCodes() || rhs.hasErrorCodes()) {
        if (getErrorCodes() < rhs.getErrorCodes()) return true;
        if (getErrorCodes() > rhs.getErrorCodes()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EventNanoMessageErrorStatusSignal::clone() {
    return new EventNanoMessageErrorStatusSignal(*this);
}

inline bool EventNanoMessageErrorStatusSignal::operator > (const EventNanoMessageErrorStatusSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EventNanoMessageErrorStatusSignal::clear() {
    clearErrorCodes();
}

inline void EventNanoMessageErrorStatusSignal::clearErrorCodes() {
    if (hasErrorCodes()) {
         clear_has_ErrorCodes();
        _ErrorCodes = 0u;
     }
}

inline bool EventNanoMessageErrorStatusSignal::hasErrorCodes () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 EventNanoMessageErrorStatusSignal::getErrorCodes () const {
    return _ErrorCodes;
}

inline void EventNanoMessageErrorStatusSignal::setErrorCodes (uint8 ErrorCodes_) {
    set_has_ErrorCodes();
    this->_ErrorCodes = ErrorCodes_;
}

inline void EventNanoMessageErrorStatusSignal::set_has_ErrorCodes () {
    _has_bits_[0] |= 1u << 0;
}

inline void EventNanoMessageErrorStatusSignal::clear_has_ErrorCodes () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  EventRTPErrorStatusSignal::EventRTPErrorStatusSignal ()  :
    _ErrorCodes (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EventRTPErrorStatusSignal::EventRTPErrorStatusSignal (const EventRTPErrorStatusSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _ErrorCodes (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EventRTPErrorStatusSignal::EventRTPErrorStatusSignal (uint8 ErrorCodes_)  :
    _ErrorCodes (ErrorCodes_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EventRTPErrorStatusSignal::~EventRTPErrorStatusSignal() {
}

inline EventRTPErrorStatusSignal& EventRTPErrorStatusSignal::operator = (const EventRTPErrorStatusSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasErrorCodes()) {
            setErrorCodes(rhs.getErrorCodes());
        } else {
            clearErrorCodes();
        }
    }
    return *this;
}

inline bool EventRTPErrorStatusSignal::operator == (const EventRTPErrorStatusSignal& rhs) const {
    return (((!hasErrorCodes() && !rhs.hasErrorCodes()) || getErrorCodes() == rhs.getErrorCodes()));
}

inline bool EventRTPErrorStatusSignal::operator != (const EventRTPErrorStatusSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool EventRTPErrorStatusSignal::operator < (const EventRTPErrorStatusSignal& rhs) const {
    if (hasErrorCodes() || rhs.hasErrorCodes()) {
        if (getErrorCodes() < rhs.getErrorCodes()) return true;
        if (getErrorCodes() > rhs.getErrorCodes()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EventRTPErrorStatusSignal::clone() {
    return new EventRTPErrorStatusSignal(*this);
}

inline bool EventRTPErrorStatusSignal::operator > (const EventRTPErrorStatusSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EventRTPErrorStatusSignal::clear() {
    clearErrorCodes();
}

inline void EventRTPErrorStatusSignal::clearErrorCodes() {
    if (hasErrorCodes()) {
         clear_has_ErrorCodes();
        _ErrorCodes = 0u;
     }
}

inline bool EventRTPErrorStatusSignal::hasErrorCodes () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 EventRTPErrorStatusSignal::getErrorCodes () const {
    return _ErrorCodes;
}

inline void EventRTPErrorStatusSignal::setErrorCodes (uint8 ErrorCodes_) {
    set_has_ErrorCodes();
    this->_ErrorCodes = ErrorCodes_;
}

inline void EventRTPErrorStatusSignal::set_has_ErrorCodes () {
    _has_bits_[0] |= 1u << 0;
}

inline void EventRTPErrorStatusSignal::clear_has_ErrorCodes () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  EventInterComConfigErrorSignal::EventInterComConfigErrorSignal ()  :
    _ErrorCodes (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EventInterComConfigErrorSignal::EventInterComConfigErrorSignal (const EventInterComConfigErrorSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _ErrorCodes (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EventInterComConfigErrorSignal::EventInterComConfigErrorSignal (uint8 ErrorCodes_)  :
    _ErrorCodes (ErrorCodes_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EventInterComConfigErrorSignal::~EventInterComConfigErrorSignal() {
}

inline EventInterComConfigErrorSignal& EventInterComConfigErrorSignal::operator = (const EventInterComConfigErrorSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasErrorCodes()) {
            setErrorCodes(rhs.getErrorCodes());
        } else {
            clearErrorCodes();
        }
    }
    return *this;
}

inline bool EventInterComConfigErrorSignal::operator == (const EventInterComConfigErrorSignal& rhs) const {
    return (((!hasErrorCodes() && !rhs.hasErrorCodes()) || getErrorCodes() == rhs.getErrorCodes()));
}

inline bool EventInterComConfigErrorSignal::operator != (const EventInterComConfigErrorSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool EventInterComConfigErrorSignal::operator < (const EventInterComConfigErrorSignal& rhs) const {
    if (hasErrorCodes() || rhs.hasErrorCodes()) {
        if (getErrorCodes() < rhs.getErrorCodes()) return true;
        if (getErrorCodes() > rhs.getErrorCodes()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EventInterComConfigErrorSignal::clone() {
    return new EventInterComConfigErrorSignal(*this);
}

inline bool EventInterComConfigErrorSignal::operator > (const EventInterComConfigErrorSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EventInterComConfigErrorSignal::clear() {
    clearErrorCodes();
}

inline void EventInterComConfigErrorSignal::clearErrorCodes() {
    if (hasErrorCodes()) {
         clear_has_ErrorCodes();
        _ErrorCodes = 0u;
     }
}

inline bool EventInterComConfigErrorSignal::hasErrorCodes () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 EventInterComConfigErrorSignal::getErrorCodes () const {
    return _ErrorCodes;
}

inline void EventInterComConfigErrorSignal::setErrorCodes (uint8 ErrorCodes_) {
    set_has_ErrorCodes();
    this->_ErrorCodes = ErrorCodes_;
}

inline void EventInterComConfigErrorSignal::set_has_ErrorCodes () {
    _has_bits_[0] |= 1u << 0;
}

inline void EventInterComConfigErrorSignal::clear_has_ErrorCodes () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  EventAudioAllocationStatusSignal::EventAudioAllocationStatusSignal ()  :
    _AllocationStatus (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EventAudioAllocationStatusSignal::EventAudioAllocationStatusSignal (const EventAudioAllocationStatusSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _AllocationStatus (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EventAudioAllocationStatusSignal::EventAudioAllocationStatusSignal (uint8 AllocationStatus_)  :
    _AllocationStatus (AllocationStatus_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EventAudioAllocationStatusSignal::~EventAudioAllocationStatusSignal() {
}

inline EventAudioAllocationStatusSignal& EventAudioAllocationStatusSignal::operator = (const EventAudioAllocationStatusSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAllocationStatus()) {
            setAllocationStatus(rhs.getAllocationStatus());
        } else {
            clearAllocationStatus();
        }
    }
    return *this;
}

inline bool EventAudioAllocationStatusSignal::operator == (const EventAudioAllocationStatusSignal& rhs) const {
    return (((!hasAllocationStatus() && !rhs.hasAllocationStatus()) || getAllocationStatus() == rhs.getAllocationStatus()));
}

inline bool EventAudioAllocationStatusSignal::operator != (const EventAudioAllocationStatusSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool EventAudioAllocationStatusSignal::operator < (const EventAudioAllocationStatusSignal& rhs) const {
    if (hasAllocationStatus() || rhs.hasAllocationStatus()) {
        if (getAllocationStatus() < rhs.getAllocationStatus()) return true;
        if (getAllocationStatus() > rhs.getAllocationStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EventAudioAllocationStatusSignal::clone() {
    return new EventAudioAllocationStatusSignal(*this);
}

inline bool EventAudioAllocationStatusSignal::operator > (const EventAudioAllocationStatusSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EventAudioAllocationStatusSignal::clear() {
    clearAllocationStatus();
}

inline void EventAudioAllocationStatusSignal::clearAllocationStatus() {
    if (hasAllocationStatus()) {
         clear_has_AllocationStatus();
        _AllocationStatus = 0u;
     }
}

inline bool EventAudioAllocationStatusSignal::hasAllocationStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 EventAudioAllocationStatusSignal::getAllocationStatus () const {
    return _AllocationStatus;
}

inline void EventAudioAllocationStatusSignal::setAllocationStatus (uint8 AllocationStatus_) {
    set_has_AllocationStatus();
    this->_AllocationStatus = AllocationStatus_;
}

inline void EventAudioAllocationStatusSignal::set_has_AllocationStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void EventAudioAllocationStatusSignal::clear_has_AllocationStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  EventIntercomAvailableSignal::EventIntercomAvailableSignal ()  :
    _Available (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EventIntercomAvailableSignal::EventIntercomAvailableSignal (const EventIntercomAvailableSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _Available (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EventIntercomAvailableSignal::EventIntercomAvailableSignal (uint8 Available_)  :
    _Available (Available_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EventIntercomAvailableSignal::~EventIntercomAvailableSignal() {
}

inline EventIntercomAvailableSignal& EventIntercomAvailableSignal::operator = (const EventIntercomAvailableSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAvailable()) {
            setAvailable(rhs.getAvailable());
        } else {
            clearAvailable();
        }
    }
    return *this;
}

inline bool EventIntercomAvailableSignal::operator == (const EventIntercomAvailableSignal& rhs) const {
    return (((!hasAvailable() && !rhs.hasAvailable()) || getAvailable() == rhs.getAvailable()));
}

inline bool EventIntercomAvailableSignal::operator != (const EventIntercomAvailableSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool EventIntercomAvailableSignal::operator < (const EventIntercomAvailableSignal& rhs) const {
    if (hasAvailable() || rhs.hasAvailable()) {
        if (getAvailable() < rhs.getAvailable()) return true;
        if (getAvailable() > rhs.getAvailable()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EventIntercomAvailableSignal::clone() {
    return new EventIntercomAvailableSignal(*this);
}

inline bool EventIntercomAvailableSignal::operator > (const EventIntercomAvailableSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EventIntercomAvailableSignal::clear() {
    clearAvailable();
}

inline void EventIntercomAvailableSignal::clearAvailable() {
    if (hasAvailable()) {
         clear_has_Available();
        _Available = 0u;
     }
}

inline bool EventIntercomAvailableSignal::hasAvailable () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 EventIntercomAvailableSignal::getAvailable () const {
    return _Available;
}

inline void EventIntercomAvailableSignal::setAvailable (uint8 Available_) {
    set_has_Available();
    this->_Available = Available_;
}

inline void EventIntercomAvailableSignal::set_has_Available () {
    _has_bits_[0] |= 1u << 0;
}

inline void EventIntercomAvailableSignal::clear_has_Available () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RspIntercomAvailableSignal::RspIntercomAvailableSignal ()  :
    _Available (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RspIntercomAvailableSignal::RspIntercomAvailableSignal (const RspIntercomAvailableSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _Available (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RspIntercomAvailableSignal::RspIntercomAvailableSignal (uint8 Available_)  :
    _Available (Available_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RspIntercomAvailableSignal::~RspIntercomAvailableSignal() {
}

inline RspIntercomAvailableSignal& RspIntercomAvailableSignal::operator = (const RspIntercomAvailableSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAvailable()) {
            setAvailable(rhs.getAvailable());
        } else {
            clearAvailable();
        }
    }
    return *this;
}

inline bool RspIntercomAvailableSignal::operator == (const RspIntercomAvailableSignal& rhs) const {
    return (((!hasAvailable() && !rhs.hasAvailable()) || getAvailable() == rhs.getAvailable()));
}

inline bool RspIntercomAvailableSignal::operator != (const RspIntercomAvailableSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool RspIntercomAvailableSignal::operator < (const RspIntercomAvailableSignal& rhs) const {
    if (hasAvailable() || rhs.hasAvailable()) {
        if (getAvailable() < rhs.getAvailable()) return true;
        if (getAvailable() > rhs.getAvailable()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RspIntercomAvailableSignal::clone() {
    return new RspIntercomAvailableSignal(*this);
}

inline bool RspIntercomAvailableSignal::operator > (const RspIntercomAvailableSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RspIntercomAvailableSignal::clear() {
    clearAvailable();
}

inline void RspIntercomAvailableSignal::clearAvailable() {
    if (hasAvailable()) {
         clear_has_Available();
        _Available = 0u;
     }
}

inline bool RspIntercomAvailableSignal::hasAvailable () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 RspIntercomAvailableSignal::getAvailable () const {
    return _Available;
}

inline void RspIntercomAvailableSignal::setAvailable (uint8 Available_) {
    set_has_Available();
    this->_Available = Available_;
}

inline void RspIntercomAvailableSignal::set_has_Available () {
    _has_bits_[0] |= 1u << 0;
}

inline void RspIntercomAvailableSignal::clear_has_Available () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace IntercomAudioService
} // namespace ai
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_AI_INTERCOMAUDIOSERVICE_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
