/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_AI_HEALTHCAREMONSERVICESTUB_H
#define BOSCH_CM_AI_HEALTHCAREMONSERVICESTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/ai/HealthcareMonService.h"
#include "bosch/cm/ai/HealthcareMonServiceConst.h"
#include <string>

namespace bosch {
namespace cm {
namespace ai {
namespace HealthcareMonService {

class HealthcareMonServiceStubDelegate;

class HealthcareMonServiceStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the HealthcareMonServiceStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    HealthcareMonServiceStub (const std::string& portName);

    /**
     * Create an instance of the HealthcareMonServiceStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    HealthcareMonServiceStub (const std::string& portName, const std::string& objectPath);

    virtual ~HealthcareMonServiceStub();

    // signal 'sig_ShowDTCPopup'

    /**
     * Raise the signal 'sig_ShowDTCPopup' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'sig_ShowDTCPopup'</b>:
     *
     * ReqShowDTCPopup = Method to request for Showing the Pop-Up
     *
     * @param Dev_ID If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param DtcCode If the meaning of "DtcCode" isn't clear, then there should be a description here.
     *
     * @param Text_ID If the meaning of "Text_ID" isn't clear, then there should be a description here.
     *
     * @param Default_Text If the meaning of "Default_Text" isn't clear, then there should be a description here.
     */
    void sendSig_ShowDTCPopupSignal(enDevID dev_ID, uint8 dev_Nr, uint32 dtcCode, uint16 text_ID, const ::std::string& default_Text);

    // method 'SendAcknowldgement'

    /**
     * The method onSendAcknowldgement() is called by ASF when a client
     * invokes the method 'SendAcknowldgement'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendSendAcknowldgement() or sendSendAcknowldgementError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'SendAcknowldgement'</b>:
     *
     * SendAck from HMI
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSendAcknowldgementRequest (const ::boost::shared_ptr< SendAcknowldgementRequest >& request) = 0;

    /**
     * The method sendSendAcknowldgementResponse() sends a response of a
     * previous method invocation of 'SendAcknowldgement' back to the client.
     *
     * <b>Documentation of 'SendAcknowldgement'</b>:
     *
     * SendAck from HMI
     *
     * @param response If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSendAcknowldgement(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSendAcknowldgementResponse (bool response, act_t act = 0);

    /**
     * The method sendSendAcknowldgementError() sends an error response of a
     * previous method invocation of 'SendAcknowldgement' back to the client.
     *
     * <b>Documentation of 'SendAcknowldgement'</b>:
     *
     * SendAck from HMI
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSendAcknowldgement().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSendAcknowldgementError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    friend class HealthcareMonServiceStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace HealthcareMonService
} // namespace ai
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_AI_HEALTHCAREMONSERVICESTUB_H
