/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/ai/HealthcareMonService.h"
#include "bosch/cm/ai/HealthcareMonServiceConst.h"
#include "bosch/cm/ai/HealthcareMonServiceDBus.h"
#include "bosch/cm/ai/HealthcareMonServiceJson.h"
#include "bosch/cm/ai/HealthcareMonServiceProxy.h"

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace bosch {
namespace cm {
namespace ai {
namespace HealthcareMonService {

DEFINE_CLASS_LOGGER("/bosch/cm/ai/bosch/cm/ai/HealthcareMonService", HealthcareMonServiceProxy);

class HealthcareMonServiceProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    HealthcareMonServiceProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< HealthcareMonServiceProxy >& proxyShared = ::boost::static_pointer_cast< HealthcareMonServiceProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_sig_ShowDTCPopup:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Sig_ShowDTCPopupSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Sig_ShowDTCPopup", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<Sig_ShowDTCPopupSignal> payload = ::boost::static_pointer_cast<Sig_ShowDTCPopupSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((Sig_ShowDTCPopupCallbackIF*) _callback)->onSig_ShowDTCPopupSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_SendAcknowldgement:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SendAcknowldgementError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SendAcknowldgement", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SendAcknowldgementError> payload = ::boost::static_pointer_cast<SendAcknowldgementError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SendAcknowldgementCallbackIF*) _callback)->onSendAcknowldgementError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SendAcknowldgementResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SendAcknowldgement", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SendAcknowldgementResponse> payload = ::boost::static_pointer_cast<SendAcknowldgementResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SendAcknowldgementCallbackIF*) _callback)->onSendAcknowldgementResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_sig_ShowDTCPopup: {
                ::boost::shared_ptr< Sig_ShowDTCPopupError > payload = ::boost::shared_ptr< Sig_ShowDTCPopupError >
                (new Sig_ShowDTCPopupError(DBUS_ERROR_NO_SERVER, "The DBus service HealthcareMonService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Sig_ShowDTCPopup", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HealthcareMonServiceProxy> proxyShared = ::boost::static_pointer_cast<HealthcareMonServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((Sig_ShowDTCPopupCallbackIF*) _callback)->onSig_ShowDTCPopupError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SendAcknowldgement: {
                ::boost::shared_ptr< SendAcknowldgementError > payload = ::boost::shared_ptr< SendAcknowldgementError >
                (new SendAcknowldgementError(DBUS_ERROR_NO_SERVER, "The DBus service HealthcareMonService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SendAcknowldgement", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HealthcareMonServiceProxy> proxyShared = ::boost::static_pointer_cast<HealthcareMonServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SendAcknowldgementCallbackIF*) _callback)->onSendAcknowldgementError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& HealthcareMonServiceProxyCallback::_logger (HealthcareMonServiceProxy::_logger);

HealthcareMonServiceProxy::HealthcareMonServiceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "bosch.cm.ai.HealthcareMonService", serviceAvailable, _logger) {
}

HealthcareMonServiceProxy::~HealthcareMonServiceProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< HealthcareMonServiceProxy > HealthcareMonServiceProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<HealthcareMonServiceProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< HealthcareMonServiceProxy > proxyNew(new HealthcareMonServiceProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t HealthcareMonServiceProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    HealthcareMonServiceProxyCallback* callback = new HealthcareMonServiceProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t HealthcareMonServiceProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    HealthcareMonServiceProxyCallback* callback = new HealthcareMonServiceProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


void HealthcareMonServiceProxy::sendDeregisterAll () const
{
    sendSig_ShowDTCPopupDeregisterAll();
}

act_t HealthcareMonServiceProxy::sendSig_ShowDTCPopupRegister(Sig_ShowDTCPopupCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "sig_ShowDTCPopup");
    act_t act = addSignalCallback(ID_sig_ShowDTCPopup, "sig_ShowDTCPopup", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Sig_ShowDTCPopup", &cb, act);
    return act;
}

bool HealthcareMonServiceProxy::sendSig_ShowDTCPopupDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sig_ShowDTCPopup", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Sig_ShowDTCPopup", act, static_cast<int>(rv));
    return rv;
}

void HealthcareMonServiceProxy::sendSig_ShowDTCPopupDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Sig_ShowDTCPopup");
    _dbusProxyDelegate->deregisterSignalCallback("sig_ShowDTCPopup", 0, _dbusDaemonProxy.get(), false);
}

act_t HealthcareMonServiceProxy::sendSendAcknowldgementRequest(SendAcknowldgementCallbackIF& cb, enDevID dev_ID, uint8 dev_Nr, uint32 dtcCode, uint8 ack) const {
    SendAcknowldgementRequest* payload = new SendAcknowldgementRequest();
    CHECK_ALLOCATION(payload);
    payload->setDev_ID(dev_ID);
    payload->setDev_Nr(dev_Nr);
    payload->setDtcCode(dtcCode);
    payload->setAck(ack);
    DBUS_MESSAGE_CALL(dbusMessage, "SendAcknowldgement", SendAcknowldgementRequest, payload, true)
    act_t act = addMethodCallback(ID_SendAcknowldgement, dbusMessage.getUniqueSerial(), "SendAcknowldgement", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SendAcknowldgement", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace HealthcareMonService
} // namespace ai
} // namespace cm
} // namespace bosch
