#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_AI_HEALTHCAREMONSERVICE_H
#define BOSCH_CM_AI_HEALTHCAREMONSERVICE_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "bosch/cm/ai/HealthcareMonServiceConst.h"
#include <cstddef>
#include <cstring>
#include <string>

/**
 * If the meaning of "bosch.cm.ai.HealthcareMonService" isn't clear, then there should be a description here.
 */

namespace bosch {
namespace cm {
namespace ai {
namespace HealthcareMonService {

// method IDs
static const uint16 ID_SendAcknowldgement = 0;

// signal IDs
static const uint16 ID_sig_ShowDTCPopup = 1;

// property IDs

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class SendAcknowldgementRequest;

class SendAcknowldgementResponse;

class Sig_ShowDTCPopupSignal;

// type definitions
/**
 * If the meaning of "SendAcknowldgementError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SendAcknowldgementError;

/**
 * If the meaning of "Sig_ShowDTCPopupError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError Sig_ShowDTCPopupError;


/**
 * SendAck from HMI
 */
class SendAcknowldgementRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendAcknowldgementRequest ();

    /**
     * Copy constructor
     */
    inline  SendAcknowldgementRequest (const SendAcknowldgementRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SendAcknowldgementRequest (enDevID Dev_ID_, uint8 Dev_Nr_, uint32 DtcCode_, uint8 Ack_);

    /**
     * Destructor
     */
    inline virtual  ~SendAcknowldgementRequest();

    /**
     * Assignment operator
     */
    inline SendAcknowldgementRequest& operator = (const SendAcknowldgementRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendAcknowldgementRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendAcknowldgementRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendAcknowldgementRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendAcknowldgementRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Dev_ID"

    static const int kDev_ID = 0;

    /**
     * Clears the field "Dev_ID".
     *
     * The field will be set to its default value. The hasDev_ID()
     * method will return false.
     */
    inline void clearDev_ID();

    /**
     * Checks whether the field "Dev_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_ID()). Otherwise it will return false.
     */
    inline bool hasDev_ID () const;

    /**
     * Returns the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_ID"
     */
    inline enDevID getDev_ID () const;

    /**
     * Sets the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_ID The value which will be set
     */
    inline void setDev_ID (enDevID Dev_ID_);

    // API of field "Dev_Nr"

    static const int kDev_Nr = 1;

    /**
     * Clears the field "Dev_Nr".
     *
     * The field will be set to its default value. The hasDev_Nr()
     * method will return false.
     */
    inline void clearDev_Nr();

    /**
     * Checks whether the field "Dev_Nr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_Nr()). Otherwise it will return false.
     */
    inline bool hasDev_Nr () const;

    /**
     * Returns the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_Nr"
     */
    inline uint8 getDev_Nr () const;

    /**
     * Sets the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr The value which will be set
     */
    inline void setDev_Nr (uint8 Dev_Nr_);

    // API of field "DtcCode"

    static const int kDtcCode = 2;

    /**
     * Clears the field "DtcCode".
     *
     * The field will be set to its default value. The hasDtcCode()
     * method will return false.
     */
    inline void clearDtcCode();

    /**
     * Checks whether the field "DtcCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDtcCode()). Otherwise it will return false.
     */
    inline bool hasDtcCode () const;

    /**
     * Returns the value of the member "DtcCode".
     *
     * If the meaning of "DtcCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DtcCode"
     */
    inline uint32 getDtcCode () const;

    /**
     * Sets the value of the member "DtcCode".
     *
     * If the meaning of "DtcCode" isn't clear, then there should be a description here.
     *
     * @param DtcCode The value which will be set
     */
    inline void setDtcCode (uint32 DtcCode_);

    // API of field "Ack"

    static const int kAck = 3;

    /**
     * Clears the field "Ack".
     *
     * The field will be set to its default value. The hasAck()
     * method will return false.
     */
    inline void clearAck();

    /**
     * Checks whether the field "Ack" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAck()). Otherwise it will return false.
     */
    inline bool hasAck () const;

    /**
     * Returns the value of the member "Ack".
     *
     * If the meaning of "Ack" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Ack"
     */
    inline uint8 getAck () const;

    /**
     * Sets the value of the member "Ack".
     *
     * If the meaning of "Ack" isn't clear, then there should be a description here.
     *
     * @param Ack The value which will be set
     */
    inline void setAck (uint8 Ack_);

    static const SendAcknowldgementRequest &getDefaultInstance();

private:

    inline void set_has_Dev_ID ();

    inline void clear_has_Dev_ID ();

    inline void set_has_Dev_Nr ();

    inline void clear_has_Dev_Nr ();

    inline void set_has_DtcCode ();

    inline void clear_has_DtcCode ();

    inline void set_has_Ack ();

    inline void clear_has_Ack ();

    uint32 _has_bits_[ (4 + 31) / 32];

    enDevID _Dev_ID;

    uint8 _Dev_Nr;

    uint32 _DtcCode;

    uint8 _Ack;

};

/**
 * SendAck from HMI
 */
class SendAcknowldgementResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendAcknowldgementResponse ();

    /**
     * Copy constructor
     */
    inline  SendAcknowldgementResponse (const SendAcknowldgementResponse &rhs);

    /**
     * All fields constructor
     */
    inline  SendAcknowldgementResponse (bool response_);

    /**
     * Destructor
     */
    inline virtual  ~SendAcknowldgementResponse();

    /**
     * Assignment operator
     */
    inline SendAcknowldgementResponse& operator = (const SendAcknowldgementResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendAcknowldgementResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendAcknowldgementResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendAcknowldgementResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendAcknowldgementResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "response"

    static const int kResponse = 0;

    /**
     * Clears the field "response".
     *
     * The field will be set to its default value. The hasResponse()
     * method will return false.
     */
    inline void clearResponse();

    /**
     * Checks whether the field "response" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponse()). Otherwise it will return false.
     */
    inline bool hasResponse () const;

    /**
     * Returns the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @return The value of the field "response"
     */
    inline bool getResponse () const;

    /**
     * Sets the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param response The value which will be set
     */
    inline void setResponse (bool response_);

    static const SendAcknowldgementResponse &getDefaultInstance();

private:

    inline void set_has_response ();

    inline void clear_has_response ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _response;

};

/**
 * ReqShowDTCPopup = Method to request for Showing the Pop-Up
 */
class Sig_ShowDTCPopupSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Sig_ShowDTCPopupSignal ();

    /**
     * Copy constructor
     */
    inline  Sig_ShowDTCPopupSignal (const Sig_ShowDTCPopupSignal &rhs);

    /**
     * All fields constructor
     */
    inline  Sig_ShowDTCPopupSignal (enDevID Dev_ID_, uint8 Dev_Nr_, uint32 DtcCode_, uint16 Text_ID_, const ::std::string& Default_Text_);

    /**
     * Destructor
     */
    inline virtual  ~Sig_ShowDTCPopupSignal();

    /**
     * Assignment operator
     */
    inline Sig_ShowDTCPopupSignal& operator = (const Sig_ShowDTCPopupSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Sig_ShowDTCPopupSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Sig_ShowDTCPopupSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Sig_ShowDTCPopupSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Sig_ShowDTCPopupSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Dev_ID"

    static const int kDev_ID = 0;

    /**
     * Clears the field "Dev_ID".
     *
     * The field will be set to its default value. The hasDev_ID()
     * method will return false.
     */
    inline void clearDev_ID();

    /**
     * Checks whether the field "Dev_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_ID()). Otherwise it will return false.
     */
    inline bool hasDev_ID () const;

    /**
     * Returns the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_ID"
     */
    inline enDevID getDev_ID () const;

    /**
     * Sets the value of the member "Dev_ID".
     *
     * If the meaning of "Dev_ID" isn't clear, then there should be a description here.
     *
     * @param Dev_ID The value which will be set
     */
    inline void setDev_ID (enDevID Dev_ID_);

    // API of field "Dev_Nr"

    static const int kDev_Nr = 1;

    /**
     * Clears the field "Dev_Nr".
     *
     * The field will be set to its default value. The hasDev_Nr()
     * method will return false.
     */
    inline void clearDev_Nr();

    /**
     * Checks whether the field "Dev_Nr" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDev_Nr()). Otherwise it will return false.
     */
    inline bool hasDev_Nr () const;

    /**
     * Returns the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Dev_Nr"
     */
    inline uint8 getDev_Nr () const;

    /**
     * Sets the value of the member "Dev_Nr".
     *
     * If the meaning of "Dev_Nr" isn't clear, then there should be a description here.
     *
     * @param Dev_Nr The value which will be set
     */
    inline void setDev_Nr (uint8 Dev_Nr_);

    // API of field "DtcCode"

    static const int kDtcCode = 2;

    /**
     * Clears the field "DtcCode".
     *
     * The field will be set to its default value. The hasDtcCode()
     * method will return false.
     */
    inline void clearDtcCode();

    /**
     * Checks whether the field "DtcCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDtcCode()). Otherwise it will return false.
     */
    inline bool hasDtcCode () const;

    /**
     * Returns the value of the member "DtcCode".
     *
     * If the meaning of "DtcCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DtcCode"
     */
    inline uint32 getDtcCode () const;

    /**
     * Sets the value of the member "DtcCode".
     *
     * If the meaning of "DtcCode" isn't clear, then there should be a description here.
     *
     * @param DtcCode The value which will be set
     */
    inline void setDtcCode (uint32 DtcCode_);

    // API of field "Text_ID"

    static const int kText_ID = 3;

    /**
     * Clears the field "Text_ID".
     *
     * The field will be set to its default value. The hasText_ID()
     * method will return false.
     */
    inline void clearText_ID();

    /**
     * Checks whether the field "Text_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setText_ID()). Otherwise it will return false.
     */
    inline bool hasText_ID () const;

    /**
     * Returns the value of the member "Text_ID".
     *
     * If the meaning of "Text_ID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Text_ID"
     */
    inline uint16 getText_ID () const;

    /**
     * Sets the value of the member "Text_ID".
     *
     * If the meaning of "Text_ID" isn't clear, then there should be a description here.
     *
     * @param Text_ID The value which will be set
     */
    inline void setText_ID (uint16 Text_ID_);

    // API of field "Default_Text"

    static const int kDefault_Text = 4;

    /**
     * Clears the field "Default_Text".
     *
     * The field will be set to its default value. The hasDefault_Text()
     * method will return false.
     */
    inline void clearDefault_Text();

    /**
     * Checks whether the field "Default_Text" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefault_Text()). Otherwise it will return false.
     */
    inline bool hasDefault_Text () const;

    /**
     * Returns the value of the member "Default_Text".
     *
     * If the meaning of "Default_Text" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Default_Text"
     */
    inline const ::std::string& getDefault_Text () const;

    /**
     * Retrieves the value of the field "Default_Text" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Default_Text".
     */
    inline ::std::string& getDefault_TextMutable ();

    /**
     * Sets the value of the member "Default_Text".
     *
     * If the meaning of "Default_Text" isn't clear, then there should be a description here.
     *
     * @param Default_Text The value which will be set
     */
    inline void setDefault_Text (const ::std::string& Default_Text_);

    /**
     * Sets the value of the member "Default_Text".
     *
     * If the meaning of "Default_Text" isn't clear, then there should be a description here.
     *
     * @param Default_Text The value which will be set
     */
    inline void setDefault_Text (const char* Default_Text_);

    /**
     * Sets the value of the member "Default_Text".
     *
     * If the meaning of "Default_Text" isn't clear, then there should be a description here.
     *
     * @param Default_Text The value which will be set
     */
    inline void setDefault_Text (const char* value, size_t size);

    static const Sig_ShowDTCPopupSignal &getDefaultInstance();

private:

    inline void set_has_Dev_ID ();

    inline void clear_has_Dev_ID ();

    inline void set_has_Dev_Nr ();

    inline void clear_has_Dev_Nr ();

    inline void set_has_DtcCode ();

    inline void clear_has_DtcCode ();

    inline void set_has_Text_ID ();

    inline void clear_has_Text_ID ();

    inline void set_has_Default_Text ();

    inline void clear_has_Default_Text ();

    uint32 _has_bits_[ (5 + 31) / 32];

    enDevID _Dev_ID;

    uint8 _Dev_Nr;

    uint32 _DtcCode;

    uint16 _Text_ID;

    ::std::string _Default_Text;

};

inline  SendAcknowldgementRequest::SendAcknowldgementRequest ()  :
    _Dev_ID (::bosch::cm::ai::HealthcareMonService::enDevID__enDevID_Media_Center),
    _Dev_Nr (0u),
    _DtcCode (0u),
    _Ack (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SendAcknowldgementRequest::SendAcknowldgementRequest (const SendAcknowldgementRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _Dev_ID (::bosch::cm::ai::HealthcareMonService::enDevID__enDevID_Media_Center),
    _Dev_Nr (0u),
    _DtcCode (0u),
    _Ack (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SendAcknowldgementRequest::SendAcknowldgementRequest (enDevID Dev_ID_, uint8 Dev_Nr_, uint32 DtcCode_, uint8 Ack_)  :
    _Dev_ID (Dev_ID_),
    _Dev_Nr (Dev_Nr_),
    _DtcCode (DtcCode_),
    _Ack (Ack_)
{
    #ifndef NDEBUG
    if (!(enDevID_IsValid(Dev_ID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Dev_ID_, "enDevID", "Dev_ID", "SendAcknowldgementRequest");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SendAcknowldgementRequest::~SendAcknowldgementRequest() {
}

inline SendAcknowldgementRequest& SendAcknowldgementRequest::operator = (const SendAcknowldgementRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDev_ID()) {
            setDev_ID(rhs.getDev_ID());
        } else {
            clearDev_ID();
        }
        if (rhs.hasDev_Nr()) {
            setDev_Nr(rhs.getDev_Nr());
        } else {
            clearDev_Nr();
        }
        if (rhs.hasDtcCode()) {
            setDtcCode(rhs.getDtcCode());
        } else {
            clearDtcCode();
        }
        if (rhs.hasAck()) {
            setAck(rhs.getAck());
        } else {
            clearAck();
        }
    }
    return *this;
}

inline bool SendAcknowldgementRequest::operator == (const SendAcknowldgementRequest& rhs) const {
    return (((!hasDev_ID() && !rhs.hasDev_ID()) || getDev_ID() == rhs.getDev_ID()) &&
        ((!hasDev_Nr() && !rhs.hasDev_Nr()) || getDev_Nr() == rhs.getDev_Nr()) &&
        ((!hasDtcCode() && !rhs.hasDtcCode()) || getDtcCode() == rhs.getDtcCode()) &&
        ((!hasAck() && !rhs.hasAck()) || getAck() == rhs.getAck()));
}

inline bool SendAcknowldgementRequest::operator != (const SendAcknowldgementRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SendAcknowldgementRequest::operator < (const SendAcknowldgementRequest& rhs) const {
    if (hasDev_ID() || rhs.hasDev_ID()) {
        if ((uint32)getDev_ID() < (uint32)rhs.getDev_ID()) return true;
        if ((uint32)getDev_ID() > (uint32)rhs.getDev_ID()) return false;
    }
    if (hasDev_Nr() || rhs.hasDev_Nr()) {
        if (getDev_Nr() < rhs.getDev_Nr()) return true;
        if (getDev_Nr() > rhs.getDev_Nr()) return false;
    }
    if (hasDtcCode() || rhs.hasDtcCode()) {
        if (getDtcCode() < rhs.getDtcCode()) return true;
        if (getDtcCode() > rhs.getDtcCode()) return false;
    }
    if (hasAck() || rhs.hasAck()) {
        if (getAck() < rhs.getAck()) return true;
        if (getAck() > rhs.getAck()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SendAcknowldgementRequest::clone() {
    return new SendAcknowldgementRequest(*this);
}

inline bool SendAcknowldgementRequest::operator > (const SendAcknowldgementRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SendAcknowldgementRequest::clear() {
    clearDev_ID();
    clearDev_Nr();
    clearDtcCode();
    clearAck();
}

inline void SendAcknowldgementRequest::clearDev_ID() {
    if (hasDev_ID()) {
         clear_has_Dev_ID();
        _Dev_ID = ::bosch::cm::ai::HealthcareMonService::enDevID__enDevID_Media_Center;
     }
}

inline bool SendAcknowldgementRequest::hasDev_ID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline enDevID SendAcknowldgementRequest::getDev_ID () const {
    return _Dev_ID;
}

inline void SendAcknowldgementRequest::setDev_ID (enDevID Dev_ID_) {
    #ifndef NDEBUG
    if (!(enDevID_IsValid(Dev_ID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Dev_ID_, "enDevID", "Dev_ID", "SendAcknowldgementRequest");
    }
    #endif
    set_has_Dev_ID();
    this->_Dev_ID = Dev_ID_;
}

inline void SendAcknowldgementRequest::clearDev_Nr() {
    if (hasDev_Nr()) {
         clear_has_Dev_Nr();
        _Dev_Nr = 0u;
     }
}

inline bool SendAcknowldgementRequest::hasDev_Nr () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 SendAcknowldgementRequest::getDev_Nr () const {
    return _Dev_Nr;
}

inline void SendAcknowldgementRequest::setDev_Nr (uint8 Dev_Nr_) {
    set_has_Dev_Nr();
    this->_Dev_Nr = Dev_Nr_;
}

inline void SendAcknowldgementRequest::clearDtcCode() {
    if (hasDtcCode()) {
         clear_has_DtcCode();
        _DtcCode = 0u;
     }
}

inline bool SendAcknowldgementRequest::hasDtcCode () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 SendAcknowldgementRequest::getDtcCode () const {
    return _DtcCode;
}

inline void SendAcknowldgementRequest::setDtcCode (uint32 DtcCode_) {
    set_has_DtcCode();
    this->_DtcCode = DtcCode_;
}

inline void SendAcknowldgementRequest::clearAck() {
    if (hasAck()) {
         clear_has_Ack();
        _Ack = 0u;
     }
}

inline bool SendAcknowldgementRequest::hasAck () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 SendAcknowldgementRequest::getAck () const {
    return _Ack;
}

inline void SendAcknowldgementRequest::setAck (uint8 Ack_) {
    set_has_Ack();
    this->_Ack = Ack_;
}

inline void SendAcknowldgementRequest::set_has_Dev_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void SendAcknowldgementRequest::clear_has_Dev_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SendAcknowldgementRequest::set_has_Dev_Nr () {
    _has_bits_[0] |= 1u << 1;
}

inline void SendAcknowldgementRequest::clear_has_Dev_Nr () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SendAcknowldgementRequest::set_has_DtcCode () {
    _has_bits_[0] |= 1u << 2;
}

inline void SendAcknowldgementRequest::clear_has_DtcCode () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void SendAcknowldgementRequest::set_has_Ack () {
    _has_bits_[0] |= 1u << 3;
}

inline void SendAcknowldgementRequest::clear_has_Ack () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  SendAcknowldgementResponse::SendAcknowldgementResponse ()  :
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SendAcknowldgementResponse::SendAcknowldgementResponse (const SendAcknowldgementResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SendAcknowldgementResponse::SendAcknowldgementResponse (bool response_)  :
    _response (response_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SendAcknowldgementResponse::~SendAcknowldgementResponse() {
}

inline SendAcknowldgementResponse& SendAcknowldgementResponse::operator = (const SendAcknowldgementResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResponse()) {
            setResponse(rhs.getResponse());
        } else {
            clearResponse();
        }
    }
    return *this;
}

inline bool SendAcknowldgementResponse::operator == (const SendAcknowldgementResponse& rhs) const {
    return (((!hasResponse() && !rhs.hasResponse()) || getResponse() == rhs.getResponse()));
}

inline bool SendAcknowldgementResponse::operator != (const SendAcknowldgementResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool SendAcknowldgementResponse::operator < (const SendAcknowldgementResponse& rhs) const {
    if (hasResponse() || rhs.hasResponse()) {
        if (getResponse() < rhs.getResponse()) return true;
        if (getResponse() > rhs.getResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SendAcknowldgementResponse::clone() {
    return new SendAcknowldgementResponse(*this);
}

inline bool SendAcknowldgementResponse::operator > (const SendAcknowldgementResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SendAcknowldgementResponse::clear() {
    clearResponse();
}

inline void SendAcknowldgementResponse::clearResponse() {
    if (hasResponse()) {
         clear_has_response();
        _response = false;
     }
}

inline bool SendAcknowldgementResponse::hasResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SendAcknowldgementResponse::getResponse () const {
    return _response;
}

inline void SendAcknowldgementResponse::setResponse (bool response_) {
    set_has_response();
    this->_response = response_;
}

inline void SendAcknowldgementResponse::set_has_response () {
    _has_bits_[0] |= 1u << 0;
}

inline void SendAcknowldgementResponse::clear_has_response () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  Sig_ShowDTCPopupSignal::Sig_ShowDTCPopupSignal ()  :
    _Dev_ID (::bosch::cm::ai::HealthcareMonService::enDevID__enDevID_Media_Center),
    _Dev_Nr (0u),
    _DtcCode (0u),
    _Text_ID (0u),
    _Default_Text ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Sig_ShowDTCPopupSignal::Sig_ShowDTCPopupSignal (const Sig_ShowDTCPopupSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _Dev_ID (::bosch::cm::ai::HealthcareMonService::enDevID__enDevID_Media_Center),
    _Dev_Nr (0u),
    _DtcCode (0u),
    _Text_ID (0u),
    _Default_Text ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Sig_ShowDTCPopupSignal::Sig_ShowDTCPopupSignal (enDevID Dev_ID_, uint8 Dev_Nr_, uint32 DtcCode_, uint16 Text_ID_, const ::std::string& Default_Text_)  :
    _Dev_ID (Dev_ID_),
    _Dev_Nr (Dev_Nr_),
    _DtcCode (DtcCode_),
    _Text_ID (Text_ID_),
    _Default_Text (Default_Text_)
{
    #ifndef NDEBUG
    if (!(enDevID_IsValid(Dev_ID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Dev_ID_, "enDevID", "Dev_ID", "Sig_ShowDTCPopupSignal");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Default_Text_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Sig_ShowDTCPopupSignal::~Sig_ShowDTCPopupSignal() {
}

inline Sig_ShowDTCPopupSignal& Sig_ShowDTCPopupSignal::operator = (const Sig_ShowDTCPopupSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDev_ID()) {
            setDev_ID(rhs.getDev_ID());
        } else {
            clearDev_ID();
        }
        if (rhs.hasDev_Nr()) {
            setDev_Nr(rhs.getDev_Nr());
        } else {
            clearDev_Nr();
        }
        if (rhs.hasDtcCode()) {
            setDtcCode(rhs.getDtcCode());
        } else {
            clearDtcCode();
        }
        if (rhs.hasText_ID()) {
            setText_ID(rhs.getText_ID());
        } else {
            clearText_ID();
        }
        if (rhs.hasDefault_Text()) {
            setDefault_Text(rhs.getDefault_Text());
        } else {
            clearDefault_Text();
        }
    }
    return *this;
}

inline bool Sig_ShowDTCPopupSignal::operator == (const Sig_ShowDTCPopupSignal& rhs) const {
    return (((!hasDev_ID() && !rhs.hasDev_ID()) || getDev_ID() == rhs.getDev_ID()) &&
        ((!hasDev_Nr() && !rhs.hasDev_Nr()) || getDev_Nr() == rhs.getDev_Nr()) &&
        ((!hasDtcCode() && !rhs.hasDtcCode()) || getDtcCode() == rhs.getDtcCode()) &&
        ((!hasText_ID() && !rhs.hasText_ID()) || getText_ID() == rhs.getText_ID()) &&
        ((!hasDefault_Text() && !rhs.hasDefault_Text()) || getDefault_Text() == rhs.getDefault_Text()));
}

inline bool Sig_ShowDTCPopupSignal::operator != (const Sig_ShowDTCPopupSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool Sig_ShowDTCPopupSignal::operator < (const Sig_ShowDTCPopupSignal& rhs) const {
    if (hasDev_ID() || rhs.hasDev_ID()) {
        if ((uint32)getDev_ID() < (uint32)rhs.getDev_ID()) return true;
        if ((uint32)getDev_ID() > (uint32)rhs.getDev_ID()) return false;
    }
    if (hasDev_Nr() || rhs.hasDev_Nr()) {
        if (getDev_Nr() < rhs.getDev_Nr()) return true;
        if (getDev_Nr() > rhs.getDev_Nr()) return false;
    }
    if (hasDtcCode() || rhs.hasDtcCode()) {
        if (getDtcCode() < rhs.getDtcCode()) return true;
        if (getDtcCode() > rhs.getDtcCode()) return false;
    }
    if (hasText_ID() || rhs.hasText_ID()) {
        if (getText_ID() < rhs.getText_ID()) return true;
        if (getText_ID() > rhs.getText_ID()) return false;
    }
    if (hasDefault_Text() || rhs.hasDefault_Text()) {
        if (getDefault_Text() < rhs.getDefault_Text()) return true;
        if (getDefault_Text() > rhs.getDefault_Text()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Sig_ShowDTCPopupSignal::clone() {
    return new Sig_ShowDTCPopupSignal(*this);
}

inline bool Sig_ShowDTCPopupSignal::operator > (const Sig_ShowDTCPopupSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Sig_ShowDTCPopupSignal::clear() {
    clearDev_ID();
    clearDev_Nr();
    clearDtcCode();
    clearText_ID();
    clearDefault_Text();
}

inline void Sig_ShowDTCPopupSignal::clearDev_ID() {
    if (hasDev_ID()) {
         clear_has_Dev_ID();
        _Dev_ID = ::bosch::cm::ai::HealthcareMonService::enDevID__enDevID_Media_Center;
     }
}

inline bool Sig_ShowDTCPopupSignal::hasDev_ID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline enDevID Sig_ShowDTCPopupSignal::getDev_ID () const {
    return _Dev_ID;
}

inline void Sig_ShowDTCPopupSignal::setDev_ID (enDevID Dev_ID_) {
    #ifndef NDEBUG
    if (!(enDevID_IsValid(Dev_ID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Dev_ID_, "enDevID", "Dev_ID", "Sig_ShowDTCPopupSignal");
    }
    #endif
    set_has_Dev_ID();
    this->_Dev_ID = Dev_ID_;
}

inline void Sig_ShowDTCPopupSignal::clearDev_Nr() {
    if (hasDev_Nr()) {
         clear_has_Dev_Nr();
        _Dev_Nr = 0u;
     }
}

inline bool Sig_ShowDTCPopupSignal::hasDev_Nr () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 Sig_ShowDTCPopupSignal::getDev_Nr () const {
    return _Dev_Nr;
}

inline void Sig_ShowDTCPopupSignal::setDev_Nr (uint8 Dev_Nr_) {
    set_has_Dev_Nr();
    this->_Dev_Nr = Dev_Nr_;
}

inline void Sig_ShowDTCPopupSignal::clearDtcCode() {
    if (hasDtcCode()) {
         clear_has_DtcCode();
        _DtcCode = 0u;
     }
}

inline bool Sig_ShowDTCPopupSignal::hasDtcCode () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 Sig_ShowDTCPopupSignal::getDtcCode () const {
    return _DtcCode;
}

inline void Sig_ShowDTCPopupSignal::setDtcCode (uint32 DtcCode_) {
    set_has_DtcCode();
    this->_DtcCode = DtcCode_;
}

inline void Sig_ShowDTCPopupSignal::clearText_ID() {
    if (hasText_ID()) {
         clear_has_Text_ID();
        _Text_ID = 0u;
     }
}

inline bool Sig_ShowDTCPopupSignal::hasText_ID () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 Sig_ShowDTCPopupSignal::getText_ID () const {
    return _Text_ID;
}

inline void Sig_ShowDTCPopupSignal::setText_ID (uint16 Text_ID_) {
    set_has_Text_ID();
    this->_Text_ID = Text_ID_;
}

inline void Sig_ShowDTCPopupSignal::clearDefault_Text() {
    if (hasDefault_Text()) {
         clear_has_Default_Text();
        _Default_Text.clear();
     }
}

inline bool Sig_ShowDTCPopupSignal::hasDefault_Text () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& Sig_ShowDTCPopupSignal::getDefault_Text () const {
    return _Default_Text;
}

inline ::std::string& Sig_ShowDTCPopupSignal::getDefault_TextMutable () {
    set_has_Default_Text();
    return _Default_Text;
}

inline void Sig_ShowDTCPopupSignal::setDefault_Text (const ::std::string& Default_Text_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Default_Text_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Default_Text();
    this->_Default_Text = Default_Text_;
}

inline void Sig_ShowDTCPopupSignal::setDefault_Text (const char* Default_Text_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Default_Text_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Default_Text();
    this->_Default_Text.assign(Default_Text_);
}

inline void Sig_ShowDTCPopupSignal::setDefault_Text (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Default_Text();
    this->_Default_Text.assign(value, size);
}

inline void Sig_ShowDTCPopupSignal::set_has_Dev_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void Sig_ShowDTCPopupSignal::clear_has_Dev_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Sig_ShowDTCPopupSignal::set_has_Dev_Nr () {
    _has_bits_[0] |= 1u << 1;
}

inline void Sig_ShowDTCPopupSignal::clear_has_Dev_Nr () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void Sig_ShowDTCPopupSignal::set_has_DtcCode () {
    _has_bits_[0] |= 1u << 2;
}

inline void Sig_ShowDTCPopupSignal::clear_has_DtcCode () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void Sig_ShowDTCPopupSignal::set_has_Text_ID () {
    _has_bits_[0] |= 1u << 3;
}

inline void Sig_ShowDTCPopupSignal::clear_has_Text_ID () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void Sig_ShowDTCPopupSignal::set_has_Default_Text () {
    _has_bits_[0] |= 1u << 4;
}

inline void Sig_ShowDTCPopupSignal::clear_has_Default_Text () {
    _has_bits_[0] &= ~ (1u << 4);
}

} // namespace HealthcareMonService
} // namespace ai
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_AI_HEALTHCAREMONSERVICE_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
