/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_CM_DIAGNOSIS_DBUS_SUBSYSTEMDIAGNOSISPROXY_H
#define ORG_BOSCH_CM_DIAGNOSIS_DBUS_SUBSYSTEMDIAGNOSISPROXY_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "org/bosch/cm/diagnosis/dbus/SubsystemDiagnosis.h"
#include <dbus/dbus.h>

namespace org {
namespace bosch {
namespace cm {
namespace diagnosis {
namespace dbus {
namespace SubsystemDiagnosis {

class SubsystemDiagnosisProxy;

class AvdeccFilesDeleteCallbackIF {
public:
    virtual ~AvdeccFilesDeleteCallbackIF() {}

    virtual void onAvdeccFilesDeleteError(const ::boost::shared_ptr< SubsystemDiagnosisProxy >& proxy, const ::boost::shared_ptr< AvdeccFilesDeleteError >& error) = 0;

    virtual void onAvdeccFilesDeleteResponse(const ::boost::shared_ptr< SubsystemDiagnosisProxy >& proxy, const ::boost::shared_ptr< AvdeccFilesDeleteResponse >& response) = 0;
};

class DiscoverEntitiesCallbackIF {
public:
    virtual ~DiscoverEntitiesCallbackIF() {}

    virtual void onDiscoverEntitiesError(const ::boost::shared_ptr< SubsystemDiagnosisProxy >& proxy, const ::boost::shared_ptr< DiscoverEntitiesError >& error) = 0;

    virtual void onDiscoverEntitiesResponse(const ::boost::shared_ptr< SubsystemDiagnosisProxy >& proxy, const ::boost::shared_ptr< DiscoverEntitiesResponse >& response) = 0;
};

class DiscoverEntitiesResultsCallbackIF {
public:
    virtual ~DiscoverEntitiesResultsCallbackIF() {}

    virtual void onDiscoverEntitiesResultsError(const ::boost::shared_ptr< SubsystemDiagnosisProxy >& proxy, const ::boost::shared_ptr< DiscoverEntitiesResultsError >& error) = 0;

    virtual void onDiscoverEntitiesResultsResponse(const ::boost::shared_ptr< SubsystemDiagnosisProxy >& proxy, const ::boost::shared_ptr< DiscoverEntitiesResultsResponse >& response) = 0;
};

class StartUDPBroadcastClientCallbackIF {
public:
    virtual ~StartUDPBroadcastClientCallbackIF() {}

    virtual void onStartUDPBroadcastClientError(const ::boost::shared_ptr< SubsystemDiagnosisProxy >& proxy, const ::boost::shared_ptr< StartUDPBroadcastClientError >& error) = 0;

    virtual void onStartUDPBroadcastClientResponse(const ::boost::shared_ptr< SubsystemDiagnosisProxy >& proxy, const ::boost::shared_ptr< StartUDPBroadcastClientResponse >& response) = 0;
};


/**
 * SubsystemDiagnosisProxy is the client side representation of the D-Bus
 * service interface 'org.bosch.cm.diagnosis.dbus.SubsystemDiagnosis'
 * (specified in file SubsystemDiagnosis.xml).
 *
 * interfaces exposed internally by the diagnosis slave for subsystem diagnosis.
 */
class SubsystemDiagnosisProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of SubsystemDiagnosisProxy.
     */
    static ::boost::shared_ptr< SubsystemDiagnosisProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of SubsystemDiagnosisProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< SubsystemDiagnosisProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of SubsystemDiagnosisProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< SubsystemDiagnosisProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< SubsystemDiagnosisProxy > proxyNew(new SubsystemDiagnosisProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(false);
        return proxyNew;
    }

    virtual ~SubsystemDiagnosisProxy ();




    // Method 'StartUDPBroadcastClient'

    /**
     * Call the method 'StartUDPBroadcastClient'. This method sends a message
     * to the D-Bus server.
     *
     * <b>Documentation of 'StartUDPBroadcastClient'</b>:
     *
     * If the meaning of "StartUDPBroadcastClient" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStartUDPBroadcastClientRequest(StartUDPBroadcastClientCallbackIF& cb) const;

    // Method 'DiscoverEntities'

    /**
     * Call the method 'DiscoverEntities'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'DiscoverEntities'</b>:
     *
     * If the meaning of "DiscoverEntities" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiscoverEntitiesRequest(DiscoverEntitiesCallbackIF& cb) const;

    // Method 'DiscoverEntitiesResults'

    /**
     * Call the method 'DiscoverEntitiesResults'. This method sends a message
     * to the D-Bus server.
     *
     * <b>Documentation of 'DiscoverEntitiesResults'</b>:
     *
     * If the meaning of "DiscoverEntitiesResults" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiscoverEntitiesResultsRequest(DiscoverEntitiesResultsCallbackIF& cb) const;

    // Method 'AvdeccFilesDelete'

    /**
     * Call the method 'AvdeccFilesDelete'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'AvdeccFilesDelete'</b>:
     *
     * If the meaning of "AvdeccFilesDelete" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAvdeccFilesDeleteRequest(AvdeccFilesDeleteCallbackIF& cb) const;


private:

    SubsystemDiagnosisProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;


    DECLARE_CLASS_LOGGER();

    friend class SubsystemDiagnosisProxyCallback;
};

} // namespace SubsystemDiagnosis
} // namespace dbus
} // namespace diagnosis
} // namespace cm
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_CM_DIAGNOSIS_DBUS_SUBSYSTEMDIAGNOSISPROXY_H
