/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/wbl/wifisetup.h"
#include "org/bosch/wbl/wifisetupDBus.h"
#include "org/bosch/wbl/wifisetupJson.h"
#include "org/bosch/wbl/wifisetupStub.h"
#include <map>
#include <string>
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bosch {
namespace wbl {
namespace wifisetup {

DEFINE_CLASS_LOGGER("//org/bosch/wbl/wifisetup/org/bosch/wbl/wifisetup", WifisetupStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 15, "ManageBandwidth", 1 },
    { 15, "SetRestrictions", 2 },
    { 21, "DeAuthenticateStation", 0 },
    { 22, "RestoreFactorySettings", 3 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 4, "Mode", 0 },
    { 8, "APConfig", 7 },
    { 9, "Frequency", 5 },
    { 9, "Interface", 1 },
    { 10, "MacAddress", 2 },
    { 10, "PowerState", 3 },
    { 12, "Restrictions", 8 },
    { 16, "ConnectionStatus", 11 },
    { 17, "IPv4Configuration", 10 },
    { 18, "PowerFailureReason", 4 },
    { 20, "SupportedFrequencies", 9 },
    { 23, "CurrentOperatingChannel", 6 },
};

class WifisetupStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    WifisetupStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    WifisetupStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    WifisetupStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.bosch.wbl.wifisetup"),
          _logger(logger) {}

    virtual ~WifisetupStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void WifisetupStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 4, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'DeAuthenticateStation'

            LOG_DEBUG_STUB("process method '%s'", "DeAuthenticateStation");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DeAuthenticateStationRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "DeAuthenticateStation", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< DeAuthenticateStationRequest > payload = ::boost::static_pointer_cast<DeAuthenticateStationRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<WifisetupStub*>(getStub())->onDeAuthenticateStationRequest(payload);
            return;
        }
        case 1: {

            // method 'ManageBandwidth'

            LOG_DEBUG_STUB("process method '%s'", "ManageBandwidth");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ManageBandwidthRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ManageBandwidth", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ManageBandwidthRequest > payload = ::boost::static_pointer_cast<ManageBandwidthRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<WifisetupStub*>(getStub())->onManageBandwidthRequest(payload);
            return;
        }
        case 2: {

            // method 'SetRestrictions'

            LOG_DEBUG_STUB("process method '%s'", "SetRestrictions");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetRestrictionsRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetRestrictions", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetRestrictionsRequest > payload = ::boost::static_pointer_cast<SetRestrictionsRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<WifisetupStub*>(getStub())->onSetRestrictionsRequest(payload);
            return;
        }
        case 3: {

            // method 'RestoreFactorySettings'

            LOG_DEBUG_STUB("process method '%s'", "RestoreFactorySettings");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RestoreFactorySettingsRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RestoreFactorySettings", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RestoreFactorySettingsRequest > payload = ::boost::static_pointer_cast<RestoreFactorySettingsRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<WifisetupStub*>(getStub())->onRestoreFactorySettingsRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* WifisetupStubDelegate::introspect() const {
    return     "<interface name=\"org.bosch.wbl.wifisetup\">\n"
            "      <method name=\"DeAuthenticateStation\">\n"
            "        <arg direction=\"in\" name=\"station\" type=\"a{sv}\"/>\n"
            "      </method>\n"
            "      <method name=\"ManageBandwidth\">\n"
            "        <arg direction=\"in\" name=\"allocate\" type=\"b\"/>\n"
            "        <arg direction=\"in\" name=\"station\" type=\"a{sv}\"/>\n"
            "      </method>\n"
            "      <method name=\"SetRestrictions\">\n"
            "        <arg direction=\"in\" name=\"technology\" type=\"a{sv}\"/>\n"
            "        <arg direction=\"in\" name=\"restrict\" type=\"s\"/>\n"
            "      </method>\n"
            "      <method name=\"RestoreFactorySettings\"/>\n"
            "      <property access=\"read\" name=\"Mode\" type=\"s\"/>\n"
            "      <property access=\"read\" name=\"Interface\" type=\"s\"/>\n"
            "      <property access=\"read\" name=\"MacAddress\" type=\"s\"/>\n"
            "      <property access=\"read\" name=\"PowerState\" type=\"s\"/>\n"
            "      <property access=\"read\" name=\"PowerFailureReason\" type=\"s\"/>\n"
            "      <property access=\"read\" name=\"Frequency\" type=\"s\"/>\n"
            "      <property access=\"read\" name=\"CurrentOperatingChannel\" type=\"i\"/>\n"
            "      <property access=\"read\" name=\"APConfig\" type=\"a{sv}\"/>\n"
            "      <property access=\"read\" name=\"Restrictions\" type=\"aa{sv}\"/>\n"
            "      <property access=\"read\" name=\"SupportedFrequencies\" type=\"aa{sv}\"/>\n"
            "      <property access=\"read\" name=\"IPv4Configuration\" type=\"aa{sv}\"/>\n"
            "      <property access=\"read\" name=\"ConnectionStatus\" type=\"a{sv}\"/>\n"
            "</interface>\n";
}

void WifisetupStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<WifisetupStub*>(getStub()))->onGetAll (properties);
}

void WifisetupStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 12, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "Mode");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "Interface");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "MacAddress");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "PowerState");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "PowerFailureReason");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 5: {
            LOG_DEBUG_STUB("process property '%s'", "Frequency");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 6: {
            LOG_DEBUG_STUB("process property '%s'", "CurrentOperatingChannel");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 7: {
            LOG_DEBUG_STUB("process property '%s'", "APConfig");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 8: {
            LOG_DEBUG_STUB("process property '%s'", "Restrictions");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 9: {
            LOG_DEBUG_STUB("process property '%s'", "SupportedFrequencies");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 10: {
            LOG_DEBUG_STUB("process property '%s'", "IPv4Configuration");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 11: {
            LOG_DEBUG_STUB("process property '%s'", "ConnectionStatus");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void WifisetupStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 12, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "Mode");
            ::boost::shared_ptr< ModeGet > payload(new ModeGet());
            payload->setAct(act);
            static_cast<WifisetupStub*>(getStub())->onModeGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "Interface");
            ::boost::shared_ptr< InterfaceGet > payload(new InterfaceGet());
            payload->setAct(act);
            static_cast<WifisetupStub*>(getStub())->onInterfaceGet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "MacAddress");
            ::boost::shared_ptr< MacAddressGet > payload(new MacAddressGet());
            payload->setAct(act);
            static_cast<WifisetupStub*>(getStub())->onMacAddressGet (payload);
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "PowerState");
            ::boost::shared_ptr< PowerStateGet > payload(new PowerStateGet());
            payload->setAct(act);
            static_cast<WifisetupStub*>(getStub())->onPowerStateGet (payload);
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "PowerFailureReason");
            ::boost::shared_ptr< PowerFailureReasonGet > payload(new PowerFailureReasonGet());
            payload->setAct(act);
            static_cast<WifisetupStub*>(getStub())->onPowerFailureReasonGet (payload);
            return;
        }
        case 5: {
            LOG_DEBUG_STUB("process property '%s'", "Frequency");
            ::boost::shared_ptr< FrequencyGet > payload(new FrequencyGet());
            payload->setAct(act);
            static_cast<WifisetupStub*>(getStub())->onFrequencyGet (payload);
            return;
        }
        case 6: {
            LOG_DEBUG_STUB("process property '%s'", "CurrentOperatingChannel");
            ::boost::shared_ptr< CurrentOperatingChannelGet > payload(new CurrentOperatingChannelGet());
            payload->setAct(act);
            static_cast<WifisetupStub*>(getStub())->onCurrentOperatingChannelGet (payload);
            return;
        }
        case 7: {
            LOG_DEBUG_STUB("process property '%s'", "APConfig");
            ::boost::shared_ptr< APConfigGet > payload(new APConfigGet());
            payload->setAct(act);
            static_cast<WifisetupStub*>(getStub())->onAPConfigGet (payload);
            return;
        }
        case 8: {
            LOG_DEBUG_STUB("process property '%s'", "Restrictions");
            ::boost::shared_ptr< RestrictionsGet > payload(new RestrictionsGet());
            payload->setAct(act);
            static_cast<WifisetupStub*>(getStub())->onRestrictionsGet (payload);
            return;
        }
        case 9: {
            LOG_DEBUG_STUB("process property '%s'", "SupportedFrequencies");
            ::boost::shared_ptr< SupportedFrequenciesGet > payload(new SupportedFrequenciesGet());
            payload->setAct(act);
            static_cast<WifisetupStub*>(getStub())->onSupportedFrequenciesGet (payload);
            return;
        }
        case 10: {
            LOG_DEBUG_STUB("process property '%s'", "IPv4Configuration");
            ::boost::shared_ptr< IPv4ConfigurationGet > payload(new IPv4ConfigurationGet());
            payload->setAct(act);
            static_cast<WifisetupStub*>(getStub())->onIPv4ConfigurationGet (payload);
            return;
        }
        case 11: {
            LOG_DEBUG_STUB("process property '%s'", "ConnectionStatus");
            ::boost::shared_ptr< ConnectionStatusGet > payload(new ConnectionStatusGet());
            payload->setAct(act);
            static_cast<WifisetupStub*>(getStub())->onConnectionStatusGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

WifisetupStub::WifisetupStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new WifisetupStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

WifisetupStub::WifisetupStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new WifisetupStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

WifisetupStub::~WifisetupStub() {
    delete _stubDelegate;
}

void WifisetupStub::sendModeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ModeUpdate payload(_ModeProperty);

        LOG_INFO ("-> send%s", "ModeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Mode", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.wbl.wifisetup", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ModeUpdate");
    }
}

void WifisetupStub::onModeGet(const ::boost::shared_ptr< ModeGet >& mode) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ModeGet", mode->getAct());
    sendModeGetUpdate(_ModeProperty.getMode(), mode->getAct());
}

void WifisetupStub::sendModeGetUpdate(const ::std::string& mode, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ModeGet payload(mode);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ModeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void WifisetupStub::setMode(const ::std::string& mode) {
    if(mode!=_ModeProperty.getMode()) {
        _ModeProperty.setMode(mode);
        sendModeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& WifisetupStub::getMode() const {
    return _ModeProperty.getMode();
}

::std::string& WifisetupStub::getModeMutable() {
    return _ModeProperty.getModeMutable();
}

void WifisetupStub::sendInterfaceUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        InterfaceUpdate payload(_InterfaceProperty);

        LOG_INFO ("-> send%s", "InterfaceUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Interface", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.wbl.wifisetup", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "InterfaceUpdate");
    }
}

void WifisetupStub::onInterfaceGet(const ::boost::shared_ptr< InterfaceGet >& interface) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "InterfaceGet", interface->getAct());
    sendInterfaceGetUpdate(_InterfaceProperty.getInterface(), interface->getAct());
}

void WifisetupStub::sendInterfaceGetUpdate(const ::std::string& interface, act_t act) {
    ::asf::dbus::DBusVariant variant;
    InterfaceGet payload(interface);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "InterfaceGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void WifisetupStub::setInterface(const ::std::string& interface) {
    if(interface!=_InterfaceProperty.getInterface()) {
        _InterfaceProperty.setInterface(interface);
        sendInterfaceUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& WifisetupStub::getInterface() const {
    return _InterfaceProperty.getInterface();
}

::std::string& WifisetupStub::getInterfaceMutable() {
    return _InterfaceProperty.getInterfaceMutable();
}

void WifisetupStub::sendMacAddressUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        MacAddressUpdate payload(_MacAddressProperty);

        LOG_INFO ("-> send%s", "MacAddressUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("MacAddress", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.wbl.wifisetup", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "MacAddressUpdate");
    }
}

void WifisetupStub::onMacAddressGet(const ::boost::shared_ptr< MacAddressGet >& macAddress) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "MacAddressGet", macAddress->getAct());
    sendMacAddressGetUpdate(_MacAddressProperty.getMacAddress(), macAddress->getAct());
}

void WifisetupStub::sendMacAddressGetUpdate(const ::std::string& macAddress, act_t act) {
    ::asf::dbus::DBusVariant variant;
    MacAddressGet payload(macAddress);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "MacAddressGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void WifisetupStub::setMacAddress(const ::std::string& macAddress) {
    if(macAddress!=_MacAddressProperty.getMacAddress()) {
        _MacAddressProperty.setMacAddress(macAddress);
        sendMacAddressUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& WifisetupStub::getMacAddress() const {
    return _MacAddressProperty.getMacAddress();
}

::std::string& WifisetupStub::getMacAddressMutable() {
    return _MacAddressProperty.getMacAddressMutable();
}

void WifisetupStub::sendPowerStateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        PowerStateUpdate payload(_PowerStateProperty);

        LOG_INFO ("-> send%s", "PowerStateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("PowerState", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.wbl.wifisetup", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "PowerStateUpdate");
    }
}

void WifisetupStub::onPowerStateGet(const ::boost::shared_ptr< PowerStateGet >& powerState) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "PowerStateGet", powerState->getAct());
    sendPowerStateGetUpdate(_PowerStateProperty.getPowerState(), powerState->getAct());
}

void WifisetupStub::sendPowerStateGetUpdate(const ::std::string& powerState, act_t act) {
    ::asf::dbus::DBusVariant variant;
    PowerStateGet payload(powerState);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "PowerStateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void WifisetupStub::setPowerState(const ::std::string& powerState) {
    if(powerState!=_PowerStateProperty.getPowerState()) {
        _PowerStateProperty.setPowerState(powerState);
        sendPowerStateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& WifisetupStub::getPowerState() const {
    return _PowerStateProperty.getPowerState();
}

::std::string& WifisetupStub::getPowerStateMutable() {
    return _PowerStateProperty.getPowerStateMutable();
}

void WifisetupStub::sendPowerFailureReasonUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        PowerFailureReasonUpdate payload(_PowerFailureReasonProperty);

        LOG_INFO ("-> send%s", "PowerFailureReasonUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("PowerFailureReason", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.wbl.wifisetup", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "PowerFailureReasonUpdate");
    }
}

void WifisetupStub::onPowerFailureReasonGet(const ::boost::shared_ptr< PowerFailureReasonGet >& powerFailureReason) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "PowerFailureReasonGet", powerFailureReason->getAct());
    sendPowerFailureReasonGetUpdate(_PowerFailureReasonProperty.getPowerFailureReason(), powerFailureReason->getAct());
}

void WifisetupStub::sendPowerFailureReasonGetUpdate(const ::std::string& powerFailureReason, act_t act) {
    ::asf::dbus::DBusVariant variant;
    PowerFailureReasonGet payload(powerFailureReason);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "PowerFailureReasonGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void WifisetupStub::setPowerFailureReason(const ::std::string& powerFailureReason) {
    if(powerFailureReason!=_PowerFailureReasonProperty.getPowerFailureReason()) {
        _PowerFailureReasonProperty.setPowerFailureReason(powerFailureReason);
        sendPowerFailureReasonUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& WifisetupStub::getPowerFailureReason() const {
    return _PowerFailureReasonProperty.getPowerFailureReason();
}

::std::string& WifisetupStub::getPowerFailureReasonMutable() {
    return _PowerFailureReasonProperty.getPowerFailureReasonMutable();
}

void WifisetupStub::sendFrequencyUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        FrequencyUpdate payload(_FrequencyProperty);

        LOG_INFO ("-> send%s", "FrequencyUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Frequency", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.wbl.wifisetup", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "FrequencyUpdate");
    }
}

void WifisetupStub::onFrequencyGet(const ::boost::shared_ptr< FrequencyGet >& frequency) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "FrequencyGet", frequency->getAct());
    sendFrequencyGetUpdate(_FrequencyProperty.getFrequency(), frequency->getAct());
}

void WifisetupStub::sendFrequencyGetUpdate(const ::std::string& frequency, act_t act) {
    ::asf::dbus::DBusVariant variant;
    FrequencyGet payload(frequency);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "FrequencyGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void WifisetupStub::setFrequency(const ::std::string& frequency) {
    if(frequency!=_FrequencyProperty.getFrequency()) {
        _FrequencyProperty.setFrequency(frequency);
        sendFrequencyUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& WifisetupStub::getFrequency() const {
    return _FrequencyProperty.getFrequency();
}

::std::string& WifisetupStub::getFrequencyMutable() {
    return _FrequencyProperty.getFrequencyMutable();
}

void WifisetupStub::sendCurrentOperatingChannelUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        CurrentOperatingChannelUpdate payload(_CurrentOperatingChannelProperty);

        LOG_INFO ("-> send%s", "CurrentOperatingChannelUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("CurrentOperatingChannel", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.wbl.wifisetup", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "CurrentOperatingChannelUpdate");
    }
}

void WifisetupStub::onCurrentOperatingChannelGet(const ::boost::shared_ptr< CurrentOperatingChannelGet >& currentOperatingChannel) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "CurrentOperatingChannelGet", currentOperatingChannel->getAct());
    sendCurrentOperatingChannelGetUpdate(_CurrentOperatingChannelProperty.getCurrentOperatingChannel(), currentOperatingChannel->getAct());
}

void WifisetupStub::sendCurrentOperatingChannelGetUpdate(int32 currentOperatingChannel, act_t act) {
    ::asf::dbus::DBusVariant variant;
    CurrentOperatingChannelGet payload(currentOperatingChannel);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "CurrentOperatingChannelGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void WifisetupStub::setCurrentOperatingChannel(int32 currentOperatingChannel) {
    if(currentOperatingChannel!=_CurrentOperatingChannelProperty.getCurrentOperatingChannel()) {
        _CurrentOperatingChannelProperty.setCurrentOperatingChannel(currentOperatingChannel);
        sendCurrentOperatingChannelUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

int32 WifisetupStub::getCurrentOperatingChannel() const {
    return _CurrentOperatingChannelProperty.getCurrentOperatingChannel();
}

void WifisetupStub::sendAPConfigUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        APConfigUpdate payload(_APConfigProperty);

        LOG_INFO ("-> send%s", "APConfigUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("APConfig", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.wbl.wifisetup", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "APConfigUpdate");
    }
}

void WifisetupStub::onAPConfigGet(const ::boost::shared_ptr< APConfigGet >& aPConfig) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "APConfigGet", aPConfig->getAct());
    sendAPConfigGetUpdate(_APConfigProperty.getAPConfig(), aPConfig->getAct());
}

void WifisetupStub::sendAPConfigGetUpdate(const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& aPConfig, act_t act) {
    ::asf::dbus::DBusVariant variant;
    APConfigGet payload(aPConfig);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "APConfigGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void WifisetupStub::setAPConfig(const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& aPConfig) {
    if(aPConfig!=_APConfigProperty.getAPConfig()) {
        _APConfigProperty.setAPConfig(aPConfig);
        sendAPConfigUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& WifisetupStub::getAPConfig() const {
    return _APConfigProperty.getAPConfig();
}

::std::map< ::std::string, ::asf::dbus::DBusVariant >& WifisetupStub::getAPConfigMutable() {
    return _APConfigProperty.getAPConfigMutable();
}

void WifisetupStub::sendRestrictionsUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        RestrictionsUpdate payload(_RestrictionsProperty);

        LOG_INFO ("-> send%s", "RestrictionsUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Restrictions", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.wbl.wifisetup", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "RestrictionsUpdate");
    }
}

void WifisetupStub::onRestrictionsGet(const ::boost::shared_ptr< RestrictionsGet >& restrictions) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "RestrictionsGet", restrictions->getAct());
    sendRestrictionsGetUpdate(_RestrictionsProperty.getRestrictions(), restrictions->getAct());
}

void WifisetupStub::sendRestrictionsGetUpdate(const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& restrictions, act_t act) {
    ::asf::dbus::DBusVariant variant;
    RestrictionsGet payload(restrictions);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "RestrictionsGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void WifisetupStub::setRestrictions(const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& restrictions) {
    if(restrictions!=_RestrictionsProperty.getRestrictions()) {
        _RestrictionsProperty.setRestrictions(restrictions);
        sendRestrictionsUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& WifisetupStub::getRestrictions() const {
    return _RestrictionsProperty.getRestrictions();
}

::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& WifisetupStub::getRestrictionsMutable() {
    return _RestrictionsProperty.getRestrictionsMutable();
}

void WifisetupStub::sendSupportedFrequenciesUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SupportedFrequenciesUpdate payload(_SupportedFrequenciesProperty);

        LOG_INFO ("-> send%s", "SupportedFrequenciesUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("SupportedFrequencies", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.wbl.wifisetup", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SupportedFrequenciesUpdate");
    }
}

void WifisetupStub::onSupportedFrequenciesGet(const ::boost::shared_ptr< SupportedFrequenciesGet >& supportedFrequencies) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SupportedFrequenciesGet", supportedFrequencies->getAct());
    sendSupportedFrequenciesGetUpdate(_SupportedFrequenciesProperty.getSupportedFrequencies(), supportedFrequencies->getAct());
}

void WifisetupStub::sendSupportedFrequenciesGetUpdate(const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& supportedFrequencies, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SupportedFrequenciesGet payload(supportedFrequencies);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SupportedFrequenciesGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void WifisetupStub::setSupportedFrequencies(const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& supportedFrequencies) {
    if(supportedFrequencies!=_SupportedFrequenciesProperty.getSupportedFrequencies()) {
        _SupportedFrequenciesProperty.setSupportedFrequencies(supportedFrequencies);
        sendSupportedFrequenciesUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& WifisetupStub::getSupportedFrequencies() const {
    return _SupportedFrequenciesProperty.getSupportedFrequencies();
}

::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& WifisetupStub::getSupportedFrequenciesMutable() {
    return _SupportedFrequenciesProperty.getSupportedFrequenciesMutable();
}

void WifisetupStub::sendIPv4ConfigurationUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        IPv4ConfigurationUpdate payload(_IPv4ConfigurationProperty);

        LOG_INFO ("-> send%s", "IPv4ConfigurationUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("IPv4Configuration", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.wbl.wifisetup", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "IPv4ConfigurationUpdate");
    }
}

void WifisetupStub::onIPv4ConfigurationGet(const ::boost::shared_ptr< IPv4ConfigurationGet >& iPv4Configuration) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "IPv4ConfigurationGet", iPv4Configuration->getAct());
    sendIPv4ConfigurationGetUpdate(_IPv4ConfigurationProperty.getIPv4Configuration(), iPv4Configuration->getAct());
}

void WifisetupStub::sendIPv4ConfigurationGetUpdate(const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& iPv4Configuration, act_t act) {
    ::asf::dbus::DBusVariant variant;
    IPv4ConfigurationGet payload(iPv4Configuration);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "IPv4ConfigurationGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void WifisetupStub::setIPv4Configuration(const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& iPv4Configuration) {
    if(iPv4Configuration!=_IPv4ConfigurationProperty.getIPv4Configuration()) {
        _IPv4ConfigurationProperty.setIPv4Configuration(iPv4Configuration);
        sendIPv4ConfigurationUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& WifisetupStub::getIPv4Configuration() const {
    return _IPv4ConfigurationProperty.getIPv4Configuration();
}

::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& WifisetupStub::getIPv4ConfigurationMutable() {
    return _IPv4ConfigurationProperty.getIPv4ConfigurationMutable();
}

void WifisetupStub::sendConnectionStatusUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ConnectionStatusUpdate payload(_ConnectionStatusProperty);

        LOG_INFO ("-> send%s", "ConnectionStatusUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ConnectionStatus", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.wbl.wifisetup", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ConnectionStatusUpdate");
    }
}

void WifisetupStub::onConnectionStatusGet(const ::boost::shared_ptr< ConnectionStatusGet >& connectionStatus) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ConnectionStatusGet", connectionStatus->getAct());
    sendConnectionStatusGetUpdate(_ConnectionStatusProperty.getConnectionStatus(), connectionStatus->getAct());
}

void WifisetupStub::sendConnectionStatusGetUpdate(const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& connectionStatus, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ConnectionStatusGet payload(connectionStatus);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ConnectionStatusGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void WifisetupStub::setConnectionStatus(const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& connectionStatus) {
    if(connectionStatus!=_ConnectionStatusProperty.getConnectionStatus()) {
        _ConnectionStatusProperty.setConnectionStatus(connectionStatus);
        sendConnectionStatusUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& WifisetupStub::getConnectionStatus() const {
    return _ConnectionStatusProperty.getConnectionStatus();
}

::std::map< ::std::string, ::asf::dbus::DBusVariant >& WifisetupStub::getConnectionStatusMutable() {
    return _ConnectionStatusProperty.getConnectionStatusMutable();
}

void  WifisetupStub::sendDeAuthenticateStationResponse (act_t act) {
    DeAuthenticateStationResponse* payload = new DeAuthenticateStationResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "DeAuthenticateStation", DeAuthenticateStationResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "DeAuthenticateStation", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  WifisetupStub::sendDeAuthenticateStationError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    DeAuthenticateStationError* payload = new DeAuthenticateStationError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "DeAuthenticateStation", DeAuthenticateStationError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "DeAuthenticateStation", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  WifisetupStub::sendManageBandwidthResponse (act_t act) {
    ManageBandwidthResponse* payload = new ManageBandwidthResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "ManageBandwidth", ManageBandwidthResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ManageBandwidth", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  WifisetupStub::sendManageBandwidthError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ManageBandwidthError* payload = new ManageBandwidthError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ManageBandwidth", ManageBandwidthError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ManageBandwidth", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  WifisetupStub::sendSetRestrictionsResponse (act_t act) {
    SetRestrictionsResponse* payload = new SetRestrictionsResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "SetRestrictions", SetRestrictionsResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetRestrictions", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  WifisetupStub::sendSetRestrictionsError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetRestrictionsError* payload = new SetRestrictionsError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SetRestrictions", SetRestrictionsError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetRestrictions", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  WifisetupStub::sendRestoreFactorySettingsResponse (act_t act) {
    RestoreFactorySettingsResponse* payload = new RestoreFactorySettingsResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "RestoreFactorySettings", RestoreFactorySettingsResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RestoreFactorySettings", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  WifisetupStub::sendRestoreFactorySettingsError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RestoreFactorySettingsError* payload = new RestoreFactorySettingsError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "RestoreFactorySettings", RestoreFactorySettingsError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RestoreFactorySettings", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void WifisetupStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'Mode'
    {
        ::asf::dbus::DBusVariant variant;
        ModeGet payload(_ModeProperty.getMode());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Mode", variant));
    }

    //property 'Interface'
    {
        ::asf::dbus::DBusVariant variant;
        InterfaceGet payload(_InterfaceProperty.getInterface());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Interface", variant));
    }

    //property 'MacAddress'
    {
        ::asf::dbus::DBusVariant variant;
        MacAddressGet payload(_MacAddressProperty.getMacAddress());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("MacAddress", variant));
    }

    //property 'PowerState'
    {
        ::asf::dbus::DBusVariant variant;
        PowerStateGet payload(_PowerStateProperty.getPowerState());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("PowerState", variant));
    }

    //property 'PowerFailureReason'
    {
        ::asf::dbus::DBusVariant variant;
        PowerFailureReasonGet payload(_PowerFailureReasonProperty.getPowerFailureReason());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("PowerFailureReason", variant));
    }

    //property 'Frequency'
    {
        ::asf::dbus::DBusVariant variant;
        FrequencyGet payload(_FrequencyProperty.getFrequency());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Frequency", variant));
    }

    //property 'CurrentOperatingChannel'
    {
        ::asf::dbus::DBusVariant variant;
        CurrentOperatingChannelGet payload(_CurrentOperatingChannelProperty.getCurrentOperatingChannel());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("CurrentOperatingChannel", variant));
    }

    //property 'APConfig'
    {
        ::asf::dbus::DBusVariant variant;
        APConfigGet payload(_APConfigProperty.getAPConfig());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("APConfig", variant));
    }

    //property 'Restrictions'
    {
        ::asf::dbus::DBusVariant variant;
        RestrictionsGet payload(_RestrictionsProperty.getRestrictions());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Restrictions", variant));
    }

    //property 'SupportedFrequencies'
    {
        ::asf::dbus::DBusVariant variant;
        SupportedFrequenciesGet payload(_SupportedFrequenciesProperty.getSupportedFrequencies());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("SupportedFrequencies", variant));
    }

    //property 'IPv4Configuration'
    {
        ::asf::dbus::DBusVariant variant;
        IPv4ConfigurationGet payload(_IPv4ConfigurationProperty.getIPv4Configuration());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("IPv4Configuration", variant));
    }

    //property 'ConnectionStatus'
    {
        ::asf::dbus::DBusVariant variant;
        ConnectionStatusGet payload(_ConnectionStatusProperty.getConnectionStatus());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ConnectionStatus", variant));
    }
}

} // namespace wifisetup
} // namespace wbl
} // namespace bosch
} // namespace org
