/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_WBL_WIFISETUPPROXY_H
#define ORG_BOSCH_WBL_WIFISETUPPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "org/bosch/wbl/wifisetup.h"
#include <dbus/dbus.h>
#include <map>
#include <string>
#include <vector>

namespace org {
namespace bosch {
namespace wbl {
namespace wifisetup {

class WifisetupProxy;

class APConfigCallbackIF {
public:
    virtual ~APConfigCallbackIF() {}

    virtual void onAPConfigError(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< APConfigError >& error) = 0;

    virtual void onAPConfigUpdate(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< APConfigUpdate >& update) = 0;
};

class ConnectionStatusCallbackIF {
public:
    virtual ~ConnectionStatusCallbackIF() {}

    virtual void onConnectionStatusError(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< ConnectionStatusError >& error) = 0;

    virtual void onConnectionStatusUpdate(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< ConnectionStatusUpdate >& update) = 0;
};

class CurrentOperatingChannelCallbackIF {
public:
    virtual ~CurrentOperatingChannelCallbackIF() {}

    virtual void onCurrentOperatingChannelError(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< CurrentOperatingChannelError >& error) = 0;

    virtual void onCurrentOperatingChannelUpdate(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< CurrentOperatingChannelUpdate >& update) = 0;
};

class DeAuthenticateStationCallbackIF {
public:
    virtual ~DeAuthenticateStationCallbackIF() {}

    virtual void onDeAuthenticateStationError(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< DeAuthenticateStationError >& error) = 0;

    virtual void onDeAuthenticateStationResponse(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< DeAuthenticateStationResponse >& response) = 0;
};

class FrequencyCallbackIF {
public:
    virtual ~FrequencyCallbackIF() {}

    virtual void onFrequencyError(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< FrequencyError >& error) = 0;

    virtual void onFrequencyUpdate(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< FrequencyUpdate >& update) = 0;
};

class IPv4ConfigurationCallbackIF {
public:
    virtual ~IPv4ConfigurationCallbackIF() {}

    virtual void onIPv4ConfigurationError(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< IPv4ConfigurationError >& error) = 0;

    virtual void onIPv4ConfigurationUpdate(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< IPv4ConfigurationUpdate >& update) = 0;
};

class InterfaceCallbackIF {
public:
    virtual ~InterfaceCallbackIF() {}

    virtual void onInterfaceError(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< InterfaceError >& error) = 0;

    virtual void onInterfaceUpdate(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< InterfaceUpdate >& update) = 0;
};

class MacAddressCallbackIF {
public:
    virtual ~MacAddressCallbackIF() {}

    virtual void onMacAddressError(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< MacAddressError >& error) = 0;

    virtual void onMacAddressUpdate(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< MacAddressUpdate >& update) = 0;
};

class ManageBandwidthCallbackIF {
public:
    virtual ~ManageBandwidthCallbackIF() {}

    virtual void onManageBandwidthError(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< ManageBandwidthError >& error) = 0;

    virtual void onManageBandwidthResponse(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< ManageBandwidthResponse >& response) = 0;
};

class ModeCallbackIF {
public:
    virtual ~ModeCallbackIF() {}

    virtual void onModeError(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< ModeError >& error) = 0;

    virtual void onModeUpdate(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< ModeUpdate >& update) = 0;
};

class PowerFailureReasonCallbackIF {
public:
    virtual ~PowerFailureReasonCallbackIF() {}

    virtual void onPowerFailureReasonError(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< PowerFailureReasonError >& error) = 0;

    virtual void onPowerFailureReasonUpdate(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< PowerFailureReasonUpdate >& update) = 0;
};

class PowerStateCallbackIF {
public:
    virtual ~PowerStateCallbackIF() {}

    virtual void onPowerStateError(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< PowerStateError >& error) = 0;

    virtual void onPowerStateUpdate(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< PowerStateUpdate >& update) = 0;
};

class RestoreFactorySettingsCallbackIF {
public:
    virtual ~RestoreFactorySettingsCallbackIF() {}

    virtual void onRestoreFactorySettingsError(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< RestoreFactorySettingsError >& error) = 0;

    virtual void onRestoreFactorySettingsResponse(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< RestoreFactorySettingsResponse >& response) = 0;
};

class RestrictionsCallbackIF {
public:
    virtual ~RestrictionsCallbackIF() {}

    virtual void onRestrictionsError(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< RestrictionsError >& error) = 0;

    virtual void onRestrictionsUpdate(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< RestrictionsUpdate >& update) = 0;
};

class SetRestrictionsCallbackIF {
public:
    virtual ~SetRestrictionsCallbackIF() {}

    virtual void onSetRestrictionsError(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< SetRestrictionsError >& error) = 0;

    virtual void onSetRestrictionsResponse(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< SetRestrictionsResponse >& response) = 0;
};

class SupportedFrequenciesCallbackIF {
public:
    virtual ~SupportedFrequenciesCallbackIF() {}

    virtual void onSupportedFrequenciesError(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< SupportedFrequenciesError >& error) = 0;

    virtual void onSupportedFrequenciesUpdate(const ::boost::shared_ptr< WifisetupProxy >& proxy, const ::boost::shared_ptr< SupportedFrequenciesUpdate >& update) = 0;
};


/**
 * WifisetupProxy is the client side representation of the D-Bus service
 * interface 'org.bosch.wbl.wifisetup' (specified in file
 * org-bosch-wbl-wifisetup.xml).
 *
 * If the meaning of "org.bosch.wbl.wifisetup" isn't clear, then there should be a description here.
 */
class WifisetupProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of WifisetupProxy.
     */
    static ::boost::shared_ptr< WifisetupProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of WifisetupProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< WifisetupProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of WifisetupProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< WifisetupProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< WifisetupProxy > proxyNew(new WifisetupProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(true);
        return proxyNew;
    }

    virtual ~WifisetupProxy ();



    // Property 'Mode'

    /**
     * Notify on the property 'Mode'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Mode'</b>:
     *
     * If the meaning of "Mode" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendModeRegister(ModeCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Mode'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Mode'</b>:
     *
     * If the meaning of "Mode" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendModeRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendModeDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Mode'.
     */
    void sendModeDeregisterAll() const;

    /**
     * Request the value of the property 'Mode' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Mode'</b>:
     *
     * If the meaning of "Mode" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendModeGet(ModeCallbackIF& cb);


    /**
     * Returns the current value of the property 'Mode' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasMode()
     * returns true.
     *
     * @return the previously received value of the property 'Mode'.
     */
    const ::std::string& getMode() const;

    /**
     * Determines whether a status message for the property 'Mode' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasMode() const;

    // Property 'Interface'

    /**
     * Notify on the property 'Interface'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Interface'</b>:
     *
     * If the meaning of "Interface" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendInterfaceRegister(InterfaceCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Interface'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Interface'</b>:
     *
     * If the meaning of "Interface" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendInterfaceRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendInterfaceDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Interface'.
     */
    void sendInterfaceDeregisterAll() const;

    /**
     * Request the value of the property 'Interface' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Interface'</b>:
     *
     * If the meaning of "Interface" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendInterfaceGet(InterfaceCallbackIF& cb);


    /**
     * Returns the current value of the property 'Interface' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasInterface()
     * returns true.
     *
     * @return the previously received value of the property 'Interface'.
     */
    const ::std::string& getInterface() const;

    /**
     * Determines whether a status message for the property 'Interface' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasInterface() const;

    // Property 'MacAddress'

    /**
     * Notify on the property 'MacAddress'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'MacAddress'</b>:
     *
     * If the meaning of "MacAddress" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMacAddressRegister(MacAddressCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'MacAddress'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'MacAddress'</b>:
     *
     * If the meaning of "MacAddress" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendMacAddressRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendMacAddressDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'MacAddress'.
     */
    void sendMacAddressDeregisterAll() const;

    /**
     * Request the value of the property 'MacAddress' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'MacAddress'</b>:
     *
     * If the meaning of "MacAddress" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMacAddressGet(MacAddressCallbackIF& cb);


    /**
     * Returns the current value of the property 'MacAddress' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when
     * hasMacAddress() returns true.
     *
     * @return the previously received value of the property 'MacAddress'.
     */
    const ::std::string& getMacAddress() const;

    /**
     * Determines whether a status message for the property 'MacAddress' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasMacAddress() const;

    // Property 'PowerState'

    /**
     * Notify on the property 'PowerState'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'PowerState'</b>:
     *
     * If the meaning of "PowerState" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPowerStateRegister(PowerStateCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'PowerState'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'PowerState'</b>:
     *
     * If the meaning of "PowerState" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendPowerStateRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendPowerStateDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'PowerState'.
     */
    void sendPowerStateDeregisterAll() const;

    /**
     * Request the value of the property 'PowerState' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'PowerState'</b>:
     *
     * If the meaning of "PowerState" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPowerStateGet(PowerStateCallbackIF& cb);


    /**
     * Returns the current value of the property 'PowerState' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when
     * hasPowerState() returns true.
     *
     * @return the previously received value of the property 'PowerState'.
     */
    const ::std::string& getPowerState() const;

    /**
     * Determines whether a status message for the property 'PowerState' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasPowerState() const;

    // Property 'PowerFailureReason'

    /**
     * Notify on the property 'PowerFailureReason'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'PowerFailureReason'</b>:
     *
     * If the meaning of "PowerFailureReason" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPowerFailureReasonRegister(PowerFailureReasonCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'PowerFailureReason'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'PowerFailureReason'</b>:
     *
     * If the meaning of "PowerFailureReason" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendPowerFailureReasonRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendPowerFailureReasonDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'PowerFailureReason'.
     */
    void sendPowerFailureReasonDeregisterAll() const;

    /**
     * Request the value of the property 'PowerFailureReason' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'PowerFailureReason'</b>:
     *
     * If the meaning of "PowerFailureReason" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPowerFailureReasonGet(PowerFailureReasonCallbackIF& cb);


    /**
     * Returns the current value of the property 'PowerFailureReason' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasPowerFailureReason() returns true.
     *
     * @return the previously received value of the property 'PowerFailureReason'.
     */
    const ::std::string& getPowerFailureReason() const;

    /**
     * Determines whether a status message for the property
     * 'PowerFailureReason' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasPowerFailureReason() const;

    // Property 'Frequency'

    /**
     * Notify on the property 'Frequency'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Frequency'</b>:
     *
     * If the meaning of "Frequency" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFrequencyRegister(FrequencyCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Frequency'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Frequency'</b>:
     *
     * If the meaning of "Frequency" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendFrequencyRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendFrequencyDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Frequency'.
     */
    void sendFrequencyDeregisterAll() const;

    /**
     * Request the value of the property 'Frequency' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Frequency'</b>:
     *
     * If the meaning of "Frequency" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFrequencyGet(FrequencyCallbackIF& cb);


    /**
     * Returns the current value of the property 'Frequency' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasFrequency()
     * returns true.
     *
     * @return the previously received value of the property 'Frequency'.
     */
    const ::std::string& getFrequency() const;

    /**
     * Determines whether a status message for the property 'Frequency' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasFrequency() const;

    // Property 'CurrentOperatingChannel'

    /**
     * Notify on the property 'CurrentOperatingChannel'. This method registers
     * for property changes by D-Bus service.
     *
     * <b>Documentation of 'CurrentOperatingChannel'</b>:
     *
     * If the meaning of "CurrentOperatingChannel" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCurrentOperatingChannelRegister(CurrentOperatingChannelCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'CurrentOperatingChannel'. This
     * method deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'CurrentOperatingChannel'</b>:
     *
     * If the meaning of "CurrentOperatingChannel" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendCurrentOperatingChannelRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendCurrentOperatingChannelDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property
     * 'CurrentOperatingChannel'.
     */
    void sendCurrentOperatingChannelDeregisterAll() const;

    /**
     * Request the value of the property 'CurrentOperatingChannel' from the
     * D-Bus server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'CurrentOperatingChannel'</b>:
     *
     * If the meaning of "CurrentOperatingChannel" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCurrentOperatingChannelGet(CurrentOperatingChannelCallbackIF& cb);


    /**
     * Returns the current value of the property 'CurrentOperatingChannel' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasCurrentOperatingChannel() returns true.
     *
     * @return the previously received value of the property 'CurrentOperatingChannel'.
     */
    int32 getCurrentOperatingChannel() const;

    /**
     * Determines whether a status message for the property
     * 'CurrentOperatingChannel' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasCurrentOperatingChannel() const;

    // Property 'APConfig'

    /**
     * Notify on the property 'APConfig'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'APConfig'</b>:
     *
     * If the meaning of "APConfig" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAPConfigRegister(APConfigCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'APConfig'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'APConfig'</b>:
     *
     * If the meaning of "APConfig" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendAPConfigRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendAPConfigDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'APConfig'.
     */
    void sendAPConfigDeregisterAll() const;

    /**
     * Request the value of the property 'APConfig' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'APConfig'</b>:
     *
     * If the meaning of "APConfig" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAPConfigGet(APConfigCallbackIF& cb);


    /**
     * Returns the current value of the property 'APConfig' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasAPConfig()
     * returns true.
     *
     * @return the previously received value of the property 'APConfig'.
     */
    const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getAPConfig() const;

    /**
     * Determines whether a status message for the property 'APConfig' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAPConfig() const;

    // Property 'Restrictions'

    /**
     * Notify on the property 'Restrictions'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'Restrictions'</b>:
     *
     * If the meaning of "Restrictions" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRestrictionsRegister(RestrictionsCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Restrictions'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'Restrictions'</b>:
     *
     * If the meaning of "Restrictions" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendRestrictionsRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendRestrictionsDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Restrictions'.
     */
    void sendRestrictionsDeregisterAll() const;

    /**
     * Request the value of the property 'Restrictions' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Restrictions'</b>:
     *
     * If the meaning of "Restrictions" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRestrictionsGet(RestrictionsCallbackIF& cb);


    /**
     * Returns the current value of the property 'Restrictions' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasRestrictions() returns true.
     *
     * @return the previously received value of the property 'Restrictions'.
     */
    const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& getRestrictions() const;

    /**
     * Determines whether a status message for the property 'Restrictions' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasRestrictions() const;

    // Property 'SupportedFrequencies'

    /**
     * Notify on the property 'SupportedFrequencies'. This method registers
     * for property changes by D-Bus service.
     *
     * <b>Documentation of 'SupportedFrequencies'</b>:
     *
     * If the meaning of "SupportedFrequencies" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSupportedFrequenciesRegister(SupportedFrequenciesCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'SupportedFrequencies'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'SupportedFrequencies'</b>:
     *
     * If the meaning of "SupportedFrequencies" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendSupportedFrequenciesRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSupportedFrequenciesDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'SupportedFrequencies'.
     */
    void sendSupportedFrequenciesDeregisterAll() const;

    /**
     * Request the value of the property 'SupportedFrequencies' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'SupportedFrequencies'</b>:
     *
     * If the meaning of "SupportedFrequencies" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSupportedFrequenciesGet(SupportedFrequenciesCallbackIF& cb);


    /**
     * Returns the current value of the property 'SupportedFrequencies' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasSupportedFrequencies() returns true.
     *
     * @return the previously received value of the property 'SupportedFrequencies'.
     */
    const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& getSupportedFrequencies() const;

    /**
     * Determines whether a status message for the property
     * 'SupportedFrequencies' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSupportedFrequencies() const;

    // Property 'IPv4Configuration'

    /**
     * Notify on the property 'IPv4Configuration'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'IPv4Configuration'</b>:
     *
     * If the meaning of "IPv4Configuration" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendIPv4ConfigurationRegister(IPv4ConfigurationCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'IPv4Configuration'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'IPv4Configuration'</b>:
     *
     * If the meaning of "IPv4Configuration" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendIPv4ConfigurationRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendIPv4ConfigurationDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'IPv4Configuration'.
     */
    void sendIPv4ConfigurationDeregisterAll() const;

    /**
     * Request the value of the property 'IPv4Configuration' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'IPv4Configuration'</b>:
     *
     * If the meaning of "IPv4Configuration" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendIPv4ConfigurationGet(IPv4ConfigurationCallbackIF& cb);


    /**
     * Returns the current value of the property 'IPv4Configuration' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasIPv4Configuration() returns true.
     *
     * @return the previously received value of the property 'IPv4Configuration'.
     */
    const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& getIPv4Configuration() const;

    /**
     * Determines whether a status message for the property
     * 'IPv4Configuration' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasIPv4Configuration() const;

    // Property 'ConnectionStatus'

    /**
     * Notify on the property 'ConnectionStatus'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'ConnectionStatus'</b>:
     *
     * If the meaning of "ConnectionStatus" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConnectionStatusRegister(ConnectionStatusCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'ConnectionStatus'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'ConnectionStatus'</b>:
     *
     * If the meaning of "ConnectionStatus" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendConnectionStatusRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendConnectionStatusDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'ConnectionStatus'.
     */
    void sendConnectionStatusDeregisterAll() const;

    /**
     * Request the value of the property 'ConnectionStatus' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'ConnectionStatus'</b>:
     *
     * If the meaning of "ConnectionStatus" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConnectionStatusGet(ConnectionStatusCallbackIF& cb);


    /**
     * Returns the current value of the property 'ConnectionStatus' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasConnectionStatus() returns true.
     *
     * @return the previously received value of the property 'ConnectionStatus'.
     */
    const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getConnectionStatus() const;

    /**
     * Determines whether a status message for the property 'ConnectionStatus'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasConnectionStatus() const;


    // Method 'DeAuthenticateStation'

    /**
     * Call the method 'DeAuthenticateStation'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'DeAuthenticateStation'</b>:
     *
     * If the meaning of "DeAuthenticateStation" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param station If the meaning of "station" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDeAuthenticateStationRequest(DeAuthenticateStationCallbackIF& cb, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& station) const;

    // Method 'ManageBandwidth'

    /**
     * Call the method 'ManageBandwidth'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'ManageBandwidth'</b>:
     *
     * If the meaning of "ManageBandwidth" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param allocate If the meaning of "allocate" isn't clear, then there should be a description here.
     *
     * @param station If the meaning of "station" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendManageBandwidthRequest(ManageBandwidthCallbackIF& cb, bool allocate, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& station) const;

    // Method 'SetRestrictions'

    /**
     * Call the method 'SetRestrictions'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'SetRestrictions'</b>:
     *
     * If the meaning of "SetRestrictions" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param technology If the meaning of "technology" isn't clear, then there should be a description here.
     *
     * @param restrict If the meaning of "restrict" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetRestrictionsRequest(SetRestrictionsCallbackIF& cb, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& technology, const ::std::string& restrict) const;

    // Method 'RestoreFactorySettings'

    /**
     * Call the method 'RestoreFactorySettings'. This method sends a message
     * to the D-Bus server.
     *
     * <b>Documentation of 'RestoreFactorySettings'</b>:
     *
     * If the meaning of "RestoreFactorySettings" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRestoreFactorySettingsRequest(RestoreFactorySettingsCallbackIF& cb) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    WifisetupProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;

    virtual void clearAllProperties ();

    // Property 'Mode'

    ::asf::core::nullable< ModeUpdate > _mode;

    // Property 'Interface'

    ::asf::core::nullable< InterfaceUpdate > _interface;

    // Property 'MacAddress'

    ::asf::core::nullable< MacAddressUpdate > _macAddress;

    // Property 'PowerState'

    ::asf::core::nullable< PowerStateUpdate > _powerState;

    // Property 'PowerFailureReason'

    ::asf::core::nullable< PowerFailureReasonUpdate > _powerFailureReason;

    // Property 'Frequency'

    ::asf::core::nullable< FrequencyUpdate > _frequency;

    // Property 'CurrentOperatingChannel'

    ::asf::core::nullable< CurrentOperatingChannelUpdate > _currentOperatingChannel;

    // Property 'APConfig'

    ::asf::core::nullable< APConfigUpdate > _aPConfig;

    // Property 'Restrictions'

    ::asf::core::nullable< RestrictionsUpdate > _restrictions;

    // Property 'SupportedFrequencies'

    ::asf::core::nullable< SupportedFrequenciesUpdate > _supportedFrequencies;

    // Property 'IPv4Configuration'

    ::asf::core::nullable< IPv4ConfigurationUpdate > _iPv4Configuration;

    // Property 'ConnectionStatus'

    ::asf::core::nullable< ConnectionStatusUpdate > _connectionStatus;

    DECLARE_CLASS_LOGGER();

    friend class WifisetupProxyCallback;
};

} // namespace wifisetup
} // namespace wbl
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_WBL_WIFISETUPPROXY_H
