#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_WBL_WIFISETUP_H
#define ORG_BOSCH_WBL_WIFISETUP_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "asf/dbus/DBusVariant.h"
#include <cstddef>
#include <cstring>
#include <map>
#include <string>
#include <vector>

/**
 * If the meaning of "wifisetup" isn't clear, then there should be a description here.
 */

namespace org {
namespace bosch {
namespace wbl {
namespace wifisetup {

// method IDs
static const uint16 ID_DeAuthenticateStation = 0;
static const uint16 ID_ManageBandwidth = 1;
static const uint16 ID_SetRestrictions = 2;
static const uint16 ID_RestoreFactorySettings = 3;

// signal IDs

// property IDs
static const uint16 ID_Mode = 4;
static const uint16 ID_Interface = 5;
static const uint16 ID_MacAddress = 6;
static const uint16 ID_PowerState = 7;
static const uint16 ID_PowerFailureReason = 8;
static const uint16 ID_Frequency = 9;
static const uint16 ID_CurrentOperatingChannel = 10;
static const uint16 ID_APConfig = 11;
static const uint16 ID_Restrictions = 12;
static const uint16 ID_SupportedFrequencies = 13;
static const uint16 ID_IPv4Configuration = 14;
static const uint16 ID_ConnectionStatus = 15;

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class DeAuthenticateStationRequest;

class ManageBandwidthRequest;

class SetRestrictionsRequest;

class ModeUpdate;

class ModeRegister;

class InterfaceUpdate;

class InterfaceRegister;

class MacAddressUpdate;

class MacAddressRegister;

class PowerStateUpdate;

class PowerStateRegister;

class PowerFailureReasonUpdate;

class PowerFailureReasonRegister;

class FrequencyUpdate;

class FrequencyRegister;

class CurrentOperatingChannelUpdate;

class CurrentOperatingChannelRegister;

class APConfigUpdate;

class APConfigRegister;

class RestrictionsUpdate;

class RestrictionsRegister;

class SupportedFrequenciesUpdate;

class SupportedFrequenciesRegister;

class IPv4ConfigurationUpdate;

class IPv4ConfigurationRegister;

class ConnectionStatusUpdate;

class ConnectionStatusRegister;

// type definitions
/**
 * If the meaning of "DeAuthenticateStationResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage DeAuthenticateStationResponse;

/**
 * If the meaning of "DeAuthenticateStationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DeAuthenticateStationError;

/**
 * If the meaning of "ManageBandwidthResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ManageBandwidthResponse;

/**
 * If the meaning of "ManageBandwidthError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ManageBandwidthError;

/**
 * If the meaning of "SetRestrictionsResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SetRestrictionsResponse;

/**
 * If the meaning of "SetRestrictionsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetRestrictionsError;

/**
 * If the meaning of "RestoreFactorySettingsRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage RestoreFactorySettingsRequest;

/**
 * If the meaning of "RestoreFactorySettingsResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage RestoreFactorySettingsResponse;

/**
 * If the meaning of "RestoreFactorySettingsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RestoreFactorySettingsError;

/**
 * If the meaning of "ModeSet" isn't clear, then there should be a description here.
 */
typedef ModeUpdate ModeSet;

/**
 * If the meaning of "ModeGet" isn't clear, then there should be a description here.
 */
typedef ModeUpdate ModeGet;

/**
 * If the meaning of "ModeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ModeError;

/**
 * If the meaning of "InterfaceSet" isn't clear, then there should be a description here.
 */
typedef InterfaceUpdate InterfaceSet;

/**
 * If the meaning of "InterfaceGet" isn't clear, then there should be a description here.
 */
typedef InterfaceUpdate InterfaceGet;

/**
 * If the meaning of "InterfaceError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError InterfaceError;

/**
 * If the meaning of "MacAddressSet" isn't clear, then there should be a description here.
 */
typedef MacAddressUpdate MacAddressSet;

/**
 * If the meaning of "MacAddressGet" isn't clear, then there should be a description here.
 */
typedef MacAddressUpdate MacAddressGet;

/**
 * If the meaning of "MacAddressError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError MacAddressError;

/**
 * If the meaning of "PowerStateSet" isn't clear, then there should be a description here.
 */
typedef PowerStateUpdate PowerStateSet;

/**
 * If the meaning of "PowerStateGet" isn't clear, then there should be a description here.
 */
typedef PowerStateUpdate PowerStateGet;

/**
 * If the meaning of "PowerStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PowerStateError;

/**
 * If the meaning of "PowerFailureReasonSet" isn't clear, then there should be a description here.
 */
typedef PowerFailureReasonUpdate PowerFailureReasonSet;

/**
 * If the meaning of "PowerFailureReasonGet" isn't clear, then there should be a description here.
 */
typedef PowerFailureReasonUpdate PowerFailureReasonGet;

/**
 * If the meaning of "PowerFailureReasonError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PowerFailureReasonError;

/**
 * If the meaning of "FrequencySet" isn't clear, then there should be a description here.
 */
typedef FrequencyUpdate FrequencySet;

/**
 * If the meaning of "FrequencyGet" isn't clear, then there should be a description here.
 */
typedef FrequencyUpdate FrequencyGet;

/**
 * If the meaning of "FrequencyError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError FrequencyError;

/**
 * If the meaning of "CurrentOperatingChannelSet" isn't clear, then there should be a description here.
 */
typedef CurrentOperatingChannelUpdate CurrentOperatingChannelSet;

/**
 * If the meaning of "CurrentOperatingChannelGet" isn't clear, then there should be a description here.
 */
typedef CurrentOperatingChannelUpdate CurrentOperatingChannelGet;

/**
 * If the meaning of "CurrentOperatingChannelError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CurrentOperatingChannelError;

/**
 * If the meaning of "APConfigSet" isn't clear, then there should be a description here.
 */
typedef APConfigUpdate APConfigSet;

/**
 * If the meaning of "APConfigGet" isn't clear, then there should be a description here.
 */
typedef APConfigUpdate APConfigGet;

/**
 * If the meaning of "APConfigError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError APConfigError;

/**
 * If the meaning of "RestrictionsSet" isn't clear, then there should be a description here.
 */
typedef RestrictionsUpdate RestrictionsSet;

/**
 * If the meaning of "RestrictionsGet" isn't clear, then there should be a description here.
 */
typedef RestrictionsUpdate RestrictionsGet;

/**
 * If the meaning of "RestrictionsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RestrictionsError;

/**
 * If the meaning of "SupportedFrequenciesSet" isn't clear, then there should be a description here.
 */
typedef SupportedFrequenciesUpdate SupportedFrequenciesSet;

/**
 * If the meaning of "SupportedFrequenciesGet" isn't clear, then there should be a description here.
 */
typedef SupportedFrequenciesUpdate SupportedFrequenciesGet;

/**
 * If the meaning of "SupportedFrequenciesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SupportedFrequenciesError;

/**
 * If the meaning of "IPv4ConfigurationSet" isn't clear, then there should be a description here.
 */
typedef IPv4ConfigurationUpdate IPv4ConfigurationSet;

/**
 * If the meaning of "IPv4ConfigurationGet" isn't clear, then there should be a description here.
 */
typedef IPv4ConfigurationUpdate IPv4ConfigurationGet;

/**
 * If the meaning of "IPv4ConfigurationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError IPv4ConfigurationError;

/**
 * If the meaning of "ConnectionStatusSet" isn't clear, then there should be a description here.
 */
typedef ConnectionStatusUpdate ConnectionStatusSet;

/**
 * If the meaning of "ConnectionStatusGet" isn't clear, then there should be a description here.
 */
typedef ConnectionStatusUpdate ConnectionStatusGet;

/**
 * If the meaning of "ConnectionStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ConnectionStatusError;


/**
 * If the meaning of "DeAuthenticateStationRequest" isn't clear, then there should be a description here.
 */
class DeAuthenticateStationRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeAuthenticateStationRequest ();

    /**
     * Copy constructor
     */
    inline  DeAuthenticateStationRequest (const DeAuthenticateStationRequest &rhs);

    /**
     * All fields constructor
     */
    inline  DeAuthenticateStationRequest (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& station_);

    /**
     * Destructor
     */
    inline virtual  ~DeAuthenticateStationRequest();

    /**
     * Assignment operator
     */
    inline DeAuthenticateStationRequest& operator = (const DeAuthenticateStationRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeAuthenticateStationRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeAuthenticateStationRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeAuthenticateStationRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeAuthenticateStationRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "station"

    static const int kStation = 0;

    /**
     * Clears the field "station".
     *
     * The field will be set to its default value. The hasStation()
     * method will return false.
     */
    inline void clearStation();

    /**
     * Checks whether the field "station" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStation()). Otherwise it will return false.
     */
    inline bool hasStation () const;

    /**
     * Returns the value of the member "station".
     *
     * If the meaning of "station" isn't clear, then there should be a description here.
     *
     * @return The value of the field "station"
     */
    inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStation () const;

    /**
     * Retrieves the value of the field "station" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "station".
     */
    inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStationMutable ();

    /**
     * Sets the value of the member "station".
     *
     * If the meaning of "station" isn't clear, then there should be a description here.
     *
     * @param station The value which will be set
     */
    inline void setStation (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& station_);

    static const DeAuthenticateStationRequest &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStringTo__asf__dbus__DBusVariantMap_DefaultInstance ();

    inline void set_has_station ();

    inline void clear_has_station ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::map< ::std::string, ::asf::dbus::DBusVariant > _station;

};

/**
 * If the meaning of "ManageBandwidthRequest" isn't clear, then there should be a description here.
 */
class ManageBandwidthRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ManageBandwidthRequest ();

    /**
     * Copy constructor
     */
    inline  ManageBandwidthRequest (const ManageBandwidthRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ManageBandwidthRequest (bool allocate_, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& station_);

    /**
     * Destructor
     */
    inline virtual  ~ManageBandwidthRequest();

    /**
     * Assignment operator
     */
    inline ManageBandwidthRequest& operator = (const ManageBandwidthRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ManageBandwidthRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ManageBandwidthRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ManageBandwidthRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ManageBandwidthRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "allocate"

    static const int kAllocate = 0;

    /**
     * Clears the field "allocate".
     *
     * The field will be set to its default value. The hasAllocate()
     * method will return false.
     */
    inline void clearAllocate();

    /**
     * Checks whether the field "allocate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAllocate()). Otherwise it will return false.
     */
    inline bool hasAllocate () const;

    /**
     * Returns the value of the member "allocate".
     *
     * If the meaning of "allocate" isn't clear, then there should be a description here.
     *
     * @return The value of the field "allocate"
     */
    inline bool getAllocate () const;

    /**
     * Sets the value of the member "allocate".
     *
     * If the meaning of "allocate" isn't clear, then there should be a description here.
     *
     * @param allocate The value which will be set
     */
    inline void setAllocate (bool allocate_);

    // API of field "station"

    static const int kStation = 1;

    /**
     * Clears the field "station".
     *
     * The field will be set to its default value. The hasStation()
     * method will return false.
     */
    inline void clearStation();

    /**
     * Checks whether the field "station" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStation()). Otherwise it will return false.
     */
    inline bool hasStation () const;

    /**
     * Returns the value of the member "station".
     *
     * If the meaning of "station" isn't clear, then there should be a description here.
     *
     * @return The value of the field "station"
     */
    inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStation () const;

    /**
     * Retrieves the value of the field "station" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "station".
     */
    inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStationMutable ();

    /**
     * Sets the value of the member "station".
     *
     * If the meaning of "station" isn't clear, then there should be a description here.
     *
     * @param station The value which will be set
     */
    inline void setStation (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& station_);

    static const ManageBandwidthRequest &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStringTo__asf__dbus__DBusVariantMap_DefaultInstance ();

    inline void set_has_allocate ();

    inline void clear_has_allocate ();

    inline void set_has_station ();

    inline void clear_has_station ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _allocate;

    ::std::map< ::std::string, ::asf::dbus::DBusVariant > _station;

};

/**
 * If the meaning of "SetRestrictionsRequest" isn't clear, then there should be a description here.
 */
class SetRestrictionsRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetRestrictionsRequest ();

    /**
     * Copy constructor
     */
    inline  SetRestrictionsRequest (const SetRestrictionsRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetRestrictionsRequest (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& technology_, const ::std::string& restrict_);

    /**
     * Destructor
     */
    inline virtual  ~SetRestrictionsRequest();

    /**
     * Assignment operator
     */
    inline SetRestrictionsRequest& operator = (const SetRestrictionsRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetRestrictionsRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetRestrictionsRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetRestrictionsRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetRestrictionsRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "technology"

    static const int kTechnology = 0;

    /**
     * Clears the field "technology".
     *
     * The field will be set to its default value. The hasTechnology()
     * method will return false.
     */
    inline void clearTechnology();

    /**
     * Checks whether the field "technology" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTechnology()). Otherwise it will return false.
     */
    inline bool hasTechnology () const;

    /**
     * Returns the value of the member "technology".
     *
     * If the meaning of "technology" isn't clear, then there should be a description here.
     *
     * @return The value of the field "technology"
     */
    inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getTechnology () const;

    /**
     * Retrieves the value of the field "technology" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "technology".
     */
    inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getTechnologyMutable ();

    /**
     * Sets the value of the member "technology".
     *
     * If the meaning of "technology" isn't clear, then there should be a description here.
     *
     * @param technology The value which will be set
     */
    inline void setTechnology (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& technology_);

    // API of field "restrict"

    static const int kRestrict = 1;

    /**
     * Clears the field "restrict".
     *
     * The field will be set to its default value. The hasRestrict()
     * method will return false.
     */
    inline void clearRestrict();

    /**
     * Checks whether the field "restrict" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRestrict()). Otherwise it will return false.
     */
    inline bool hasRestrict () const;

    /**
     * Returns the value of the member "restrict".
     *
     * If the meaning of "restrict" isn't clear, then there should be a description here.
     *
     * @return The value of the field "restrict"
     */
    inline const ::std::string& getRestrict () const;

    /**
     * Retrieves the value of the field "restrict" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "restrict".
     */
    inline ::std::string& getRestrictMutable ();

    /**
     * Sets the value of the member "restrict".
     *
     * If the meaning of "restrict" isn't clear, then there should be a description here.
     *
     * @param restrict The value which will be set
     */
    inline void setRestrict (const ::std::string& restrict_);

    /**
     * Sets the value of the member "restrict".
     *
     * If the meaning of "restrict" isn't clear, then there should be a description here.
     *
     * @param restrict The value which will be set
     */
    inline void setRestrict (const char* restrict_);

    /**
     * Sets the value of the member "restrict".
     *
     * If the meaning of "restrict" isn't clear, then there should be a description here.
     *
     * @param restrict The value which will be set
     */
    inline void setRestrict (const char* value, size_t size);

    static const SetRestrictionsRequest &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStringTo__asf__dbus__DBusVariantMap_DefaultInstance ();

    inline void set_has_technology ();

    inline void clear_has_technology ();

    inline void set_has_restrict ();

    inline void clear_has_restrict ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::map< ::std::string, ::asf::dbus::DBusVariant > _technology;

    ::std::string _restrict;

};

/**
 * If the meaning of "ModeUpdate" isn't clear, then there should be a description here.
 */
class ModeUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ModeUpdate ();

    /**
     * Copy constructor
     */
    inline  ModeUpdate (const ModeUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ModeUpdate (const ::std::string& Mode_);

    /**
     * Destructor
     */
    inline virtual  ~ModeUpdate();

    /**
     * Assignment operator
     */
    inline ModeUpdate& operator = (const ModeUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ModeUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ModeUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ModeUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ModeUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Mode"

    static const int kMode = 0;

    /**
     * Clears the field "Mode".
     *
     * The field will be set to its default value. The hasMode()
     * method will return false.
     */
    inline void clearMode();

    /**
     * Checks whether the field "Mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMode()). Otherwise it will return false.
     */
    inline bool hasMode () const;

    /**
     * Returns the value of the member "Mode".
     *
     * If the meaning of "Mode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Mode"
     */
    inline const ::std::string& getMode () const;

    /**
     * Retrieves the value of the field "Mode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Mode".
     */
    inline ::std::string& getModeMutable ();

    /**
     * Sets the value of the member "Mode".
     *
     * If the meaning of "Mode" isn't clear, then there should be a description here.
     *
     * @param Mode The value which will be set
     */
    inline void setMode (const ::std::string& Mode_);

    /**
     * Sets the value of the member "Mode".
     *
     * If the meaning of "Mode" isn't clear, then there should be a description here.
     *
     * @param Mode The value which will be set
     */
    inline void setMode (const char* Mode_);

    /**
     * Sets the value of the member "Mode".
     *
     * If the meaning of "Mode" isn't clear, then there should be a description here.
     *
     * @param Mode The value which will be set
     */
    inline void setMode (const char* value, size_t size);

    static const ModeUpdate &getDefaultInstance();

private:

    inline void set_has_Mode ();

    inline void clear_has_Mode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _Mode;

};

/**
 * If the meaning of "ModeRegister" isn't clear, then there should be a description here.
 */
class ModeRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ModeRegister ();

    /**
     * Copy constructor
     */
    inline  ModeRegister (const ModeRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ModeRegister();

    /**
     * Assignment operator
     */
    inline ModeRegister& operator = (const ModeRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ModeRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ModeRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ModeRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ModeRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ModeRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "InterfaceUpdate" isn't clear, then there should be a description here.
 */
class InterfaceUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  InterfaceUpdate ();

    /**
     * Copy constructor
     */
    inline  InterfaceUpdate (const InterfaceUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  InterfaceUpdate (const ::std::string& Interface_);

    /**
     * Destructor
     */
    inline virtual  ~InterfaceUpdate();

    /**
     * Assignment operator
     */
    inline InterfaceUpdate& operator = (const InterfaceUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const InterfaceUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const InterfaceUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const InterfaceUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const InterfaceUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Interface"

    static const int kInterface = 0;

    /**
     * Clears the field "Interface".
     *
     * The field will be set to its default value. The hasInterface()
     * method will return false.
     */
    inline void clearInterface();

    /**
     * Checks whether the field "Interface" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInterface()). Otherwise it will return false.
     */
    inline bool hasInterface () const;

    /**
     * Returns the value of the member "Interface".
     *
     * If the meaning of "Interface" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Interface"
     */
    inline const ::std::string& getInterface () const;

    /**
     * Retrieves the value of the field "Interface" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Interface".
     */
    inline ::std::string& getInterfaceMutable ();

    /**
     * Sets the value of the member "Interface".
     *
     * If the meaning of "Interface" isn't clear, then there should be a description here.
     *
     * @param Interface The value which will be set
     */
    inline void setInterface (const ::std::string& Interface_);

    /**
     * Sets the value of the member "Interface".
     *
     * If the meaning of "Interface" isn't clear, then there should be a description here.
     *
     * @param Interface The value which will be set
     */
    inline void setInterface (const char* Interface_);

    /**
     * Sets the value of the member "Interface".
     *
     * If the meaning of "Interface" isn't clear, then there should be a description here.
     *
     * @param Interface The value which will be set
     */
    inline void setInterface (const char* value, size_t size);

    static const InterfaceUpdate &getDefaultInstance();

private:

    inline void set_has_Interface ();

    inline void clear_has_Interface ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _Interface;

};

/**
 * If the meaning of "InterfaceRegister" isn't clear, then there should be a description here.
 */
class InterfaceRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  InterfaceRegister ();

    /**
     * Copy constructor
     */
    inline  InterfaceRegister (const InterfaceRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~InterfaceRegister();

    /**
     * Assignment operator
     */
    inline InterfaceRegister& operator = (const InterfaceRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const InterfaceRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const InterfaceRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const InterfaceRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const InterfaceRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const InterfaceRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "MacAddressUpdate" isn't clear, then there should be a description here.
 */
class MacAddressUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MacAddressUpdate ();

    /**
     * Copy constructor
     */
    inline  MacAddressUpdate (const MacAddressUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  MacAddressUpdate (const ::std::string& MacAddress_);

    /**
     * Destructor
     */
    inline virtual  ~MacAddressUpdate();

    /**
     * Assignment operator
     */
    inline MacAddressUpdate& operator = (const MacAddressUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MacAddressUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MacAddressUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MacAddressUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MacAddressUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MacAddress"

    static const int kMacAddress = 0;

    /**
     * Clears the field "MacAddress".
     *
     * The field will be set to its default value. The hasMacAddress()
     * method will return false.
     */
    inline void clearMacAddress();

    /**
     * Checks whether the field "MacAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMacAddress()). Otherwise it will return false.
     */
    inline bool hasMacAddress () const;

    /**
     * Returns the value of the member "MacAddress".
     *
     * If the meaning of "MacAddress" isn't clear, then there should be a description here.
     *
     * @return The value of the field "MacAddress"
     */
    inline const ::std::string& getMacAddress () const;

    /**
     * Retrieves the value of the field "MacAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "MacAddress".
     */
    inline ::std::string& getMacAddressMutable ();

    /**
     * Sets the value of the member "MacAddress".
     *
     * If the meaning of "MacAddress" isn't clear, then there should be a description here.
     *
     * @param MacAddress The value which will be set
     */
    inline void setMacAddress (const ::std::string& MacAddress_);

    /**
     * Sets the value of the member "MacAddress".
     *
     * If the meaning of "MacAddress" isn't clear, then there should be a description here.
     *
     * @param MacAddress The value which will be set
     */
    inline void setMacAddress (const char* MacAddress_);

    /**
     * Sets the value of the member "MacAddress".
     *
     * If the meaning of "MacAddress" isn't clear, then there should be a description here.
     *
     * @param MacAddress The value which will be set
     */
    inline void setMacAddress (const char* value, size_t size);

    static const MacAddressUpdate &getDefaultInstance();

private:

    inline void set_has_MacAddress ();

    inline void clear_has_MacAddress ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _MacAddress;

};

/**
 * If the meaning of "MacAddressRegister" isn't clear, then there should be a description here.
 */
class MacAddressRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MacAddressRegister ();

    /**
     * Copy constructor
     */
    inline  MacAddressRegister (const MacAddressRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~MacAddressRegister();

    /**
     * Assignment operator
     */
    inline MacAddressRegister& operator = (const MacAddressRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MacAddressRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MacAddressRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MacAddressRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MacAddressRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const MacAddressRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "PowerStateUpdate" isn't clear, then there should be a description here.
 */
class PowerStateUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PowerStateUpdate ();

    /**
     * Copy constructor
     */
    inline  PowerStateUpdate (const PowerStateUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  PowerStateUpdate (const ::std::string& PowerState_);

    /**
     * Destructor
     */
    inline virtual  ~PowerStateUpdate();

    /**
     * Assignment operator
     */
    inline PowerStateUpdate& operator = (const PowerStateUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PowerStateUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PowerStateUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PowerStateUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PowerStateUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PowerState"

    static const int kPowerState = 0;

    /**
     * Clears the field "PowerState".
     *
     * The field will be set to its default value. The hasPowerState()
     * method will return false.
     */
    inline void clearPowerState();

    /**
     * Checks whether the field "PowerState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPowerState()). Otherwise it will return false.
     */
    inline bool hasPowerState () const;

    /**
     * Returns the value of the member "PowerState".
     *
     * If the meaning of "PowerState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "PowerState"
     */
    inline const ::std::string& getPowerState () const;

    /**
     * Retrieves the value of the field "PowerState" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PowerState".
     */
    inline ::std::string& getPowerStateMutable ();

    /**
     * Sets the value of the member "PowerState".
     *
     * If the meaning of "PowerState" isn't clear, then there should be a description here.
     *
     * @param PowerState The value which will be set
     */
    inline void setPowerState (const ::std::string& PowerState_);

    /**
     * Sets the value of the member "PowerState".
     *
     * If the meaning of "PowerState" isn't clear, then there should be a description here.
     *
     * @param PowerState The value which will be set
     */
    inline void setPowerState (const char* PowerState_);

    /**
     * Sets the value of the member "PowerState".
     *
     * If the meaning of "PowerState" isn't clear, then there should be a description here.
     *
     * @param PowerState The value which will be set
     */
    inline void setPowerState (const char* value, size_t size);

    static const PowerStateUpdate &getDefaultInstance();

private:

    inline void set_has_PowerState ();

    inline void clear_has_PowerState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _PowerState;

};

/**
 * If the meaning of "PowerStateRegister" isn't clear, then there should be a description here.
 */
class PowerStateRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PowerStateRegister ();

    /**
     * Copy constructor
     */
    inline  PowerStateRegister (const PowerStateRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~PowerStateRegister();

    /**
     * Assignment operator
     */
    inline PowerStateRegister& operator = (const PowerStateRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PowerStateRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PowerStateRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PowerStateRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PowerStateRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const PowerStateRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "PowerFailureReasonUpdate" isn't clear, then there should be a description here.
 */
class PowerFailureReasonUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PowerFailureReasonUpdate ();

    /**
     * Copy constructor
     */
    inline  PowerFailureReasonUpdate (const PowerFailureReasonUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  PowerFailureReasonUpdate (const ::std::string& PowerFailureReason_);

    /**
     * Destructor
     */
    inline virtual  ~PowerFailureReasonUpdate();

    /**
     * Assignment operator
     */
    inline PowerFailureReasonUpdate& operator = (const PowerFailureReasonUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PowerFailureReasonUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PowerFailureReasonUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PowerFailureReasonUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PowerFailureReasonUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PowerFailureReason"

    static const int kPowerFailureReason = 0;

    /**
     * Clears the field "PowerFailureReason".
     *
     * The field will be set to its default value. The hasPowerFailureReason()
     * method will return false.
     */
    inline void clearPowerFailureReason();

    /**
     * Checks whether the field "PowerFailureReason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPowerFailureReason()). Otherwise it will return false.
     */
    inline bool hasPowerFailureReason () const;

    /**
     * Returns the value of the member "PowerFailureReason".
     *
     * If the meaning of "PowerFailureReason" isn't clear, then there should be a description here.
     *
     * @return The value of the field "PowerFailureReason"
     */
    inline const ::std::string& getPowerFailureReason () const;

    /**
     * Retrieves the value of the field "PowerFailureReason" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PowerFailureReason".
     */
    inline ::std::string& getPowerFailureReasonMutable ();

    /**
     * Sets the value of the member "PowerFailureReason".
     *
     * If the meaning of "PowerFailureReason" isn't clear, then there should be a description here.
     *
     * @param PowerFailureReason The value which will be set
     */
    inline void setPowerFailureReason (const ::std::string& PowerFailureReason_);

    /**
     * Sets the value of the member "PowerFailureReason".
     *
     * If the meaning of "PowerFailureReason" isn't clear, then there should be a description here.
     *
     * @param PowerFailureReason The value which will be set
     */
    inline void setPowerFailureReason (const char* PowerFailureReason_);

    /**
     * Sets the value of the member "PowerFailureReason".
     *
     * If the meaning of "PowerFailureReason" isn't clear, then there should be a description here.
     *
     * @param PowerFailureReason The value which will be set
     */
    inline void setPowerFailureReason (const char* value, size_t size);

    static const PowerFailureReasonUpdate &getDefaultInstance();

private:

    inline void set_has_PowerFailureReason ();

    inline void clear_has_PowerFailureReason ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _PowerFailureReason;

};

/**
 * If the meaning of "PowerFailureReasonRegister" isn't clear, then there should be a description here.
 */
class PowerFailureReasonRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PowerFailureReasonRegister ();

    /**
     * Copy constructor
     */
    inline  PowerFailureReasonRegister (const PowerFailureReasonRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~PowerFailureReasonRegister();

    /**
     * Assignment operator
     */
    inline PowerFailureReasonRegister& operator = (const PowerFailureReasonRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PowerFailureReasonRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PowerFailureReasonRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PowerFailureReasonRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PowerFailureReasonRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const PowerFailureReasonRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "FrequencyUpdate" isn't clear, then there should be a description here.
 */
class FrequencyUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FrequencyUpdate ();

    /**
     * Copy constructor
     */
    inline  FrequencyUpdate (const FrequencyUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  FrequencyUpdate (const ::std::string& Frequency_);

    /**
     * Destructor
     */
    inline virtual  ~FrequencyUpdate();

    /**
     * Assignment operator
     */
    inline FrequencyUpdate& operator = (const FrequencyUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FrequencyUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FrequencyUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FrequencyUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FrequencyUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Frequency"

    static const int kFrequency = 0;

    /**
     * Clears the field "Frequency".
     *
     * The field will be set to its default value. The hasFrequency()
     * method will return false.
     */
    inline void clearFrequency();

    /**
     * Checks whether the field "Frequency" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFrequency()). Otherwise it will return false.
     */
    inline bool hasFrequency () const;

    /**
     * Returns the value of the member "Frequency".
     *
     * If the meaning of "Frequency" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Frequency"
     */
    inline const ::std::string& getFrequency () const;

    /**
     * Retrieves the value of the field "Frequency" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Frequency".
     */
    inline ::std::string& getFrequencyMutable ();

    /**
     * Sets the value of the member "Frequency".
     *
     * If the meaning of "Frequency" isn't clear, then there should be a description here.
     *
     * @param Frequency The value which will be set
     */
    inline void setFrequency (const ::std::string& Frequency_);

    /**
     * Sets the value of the member "Frequency".
     *
     * If the meaning of "Frequency" isn't clear, then there should be a description here.
     *
     * @param Frequency The value which will be set
     */
    inline void setFrequency (const char* Frequency_);

    /**
     * Sets the value of the member "Frequency".
     *
     * If the meaning of "Frequency" isn't clear, then there should be a description here.
     *
     * @param Frequency The value which will be set
     */
    inline void setFrequency (const char* value, size_t size);

    static const FrequencyUpdate &getDefaultInstance();

private:

    inline void set_has_Frequency ();

    inline void clear_has_Frequency ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _Frequency;

};

/**
 * If the meaning of "FrequencyRegister" isn't clear, then there should be a description here.
 */
class FrequencyRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FrequencyRegister ();

    /**
     * Copy constructor
     */
    inline  FrequencyRegister (const FrequencyRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~FrequencyRegister();

    /**
     * Assignment operator
     */
    inline FrequencyRegister& operator = (const FrequencyRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FrequencyRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FrequencyRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FrequencyRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FrequencyRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const FrequencyRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "CurrentOperatingChannelUpdate" isn't clear, then there should be a description here.
 */
class CurrentOperatingChannelUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CurrentOperatingChannelUpdate ();

    /**
     * Copy constructor
     */
    inline  CurrentOperatingChannelUpdate (const CurrentOperatingChannelUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  CurrentOperatingChannelUpdate (int32 CurrentOperatingChannel_);

    /**
     * Destructor
     */
    inline virtual  ~CurrentOperatingChannelUpdate();

    /**
     * Assignment operator
     */
    inline CurrentOperatingChannelUpdate& operator = (const CurrentOperatingChannelUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CurrentOperatingChannelUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CurrentOperatingChannelUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CurrentOperatingChannelUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CurrentOperatingChannelUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CurrentOperatingChannel"

    static const int kCurrentOperatingChannel = 0;

    /**
     * Clears the field "CurrentOperatingChannel".
     *
     * The field will be set to its default value. The hasCurrentOperatingChannel()
     * method will return false.
     */
    inline void clearCurrentOperatingChannel();

    /**
     * Checks whether the field "CurrentOperatingChannel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCurrentOperatingChannel()). Otherwise it will return false.
     */
    inline bool hasCurrentOperatingChannel () const;

    /**
     * Returns the value of the member "CurrentOperatingChannel".
     *
     * If the meaning of "CurrentOperatingChannel" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CurrentOperatingChannel"
     */
    inline int32 getCurrentOperatingChannel () const;

    /**
     * Sets the value of the member "CurrentOperatingChannel".
     *
     * If the meaning of "CurrentOperatingChannel" isn't clear, then there should be a description here.
     *
     * @param CurrentOperatingChannel The value which will be set
     */
    inline void setCurrentOperatingChannel (int32 CurrentOperatingChannel_);

    static const CurrentOperatingChannelUpdate &getDefaultInstance();

private:

    inline void set_has_CurrentOperatingChannel ();

    inline void clear_has_CurrentOperatingChannel ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _CurrentOperatingChannel;

};

/**
 * If the meaning of "CurrentOperatingChannelRegister" isn't clear, then there should be a description here.
 */
class CurrentOperatingChannelRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CurrentOperatingChannelRegister ();

    /**
     * Copy constructor
     */
    inline  CurrentOperatingChannelRegister (const CurrentOperatingChannelRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~CurrentOperatingChannelRegister();

    /**
     * Assignment operator
     */
    inline CurrentOperatingChannelRegister& operator = (const CurrentOperatingChannelRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CurrentOperatingChannelRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CurrentOperatingChannelRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CurrentOperatingChannelRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CurrentOperatingChannelRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const CurrentOperatingChannelRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "APConfigUpdate" isn't clear, then there should be a description here.
 */
class APConfigUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  APConfigUpdate ();

    /**
     * Copy constructor
     */
    inline  APConfigUpdate (const APConfigUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  APConfigUpdate (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& APConfig_);

    /**
     * Destructor
     */
    inline virtual  ~APConfigUpdate();

    /**
     * Assignment operator
     */
    inline APConfigUpdate& operator = (const APConfigUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const APConfigUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const APConfigUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const APConfigUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const APConfigUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "APConfig"

    static const int kAPConfig = 0;

    /**
     * Clears the field "APConfig".
     *
     * The field will be set to its default value. The hasAPConfig()
     * method will return false.
     */
    inline void clearAPConfig();

    /**
     * Checks whether the field "APConfig" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAPConfig()). Otherwise it will return false.
     */
    inline bool hasAPConfig () const;

    /**
     * Returns the value of the member "APConfig".
     *
     * If the meaning of "APConfig" isn't clear, then there should be a description here.
     *
     * @return The value of the field "APConfig"
     */
    inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getAPConfig () const;

    /**
     * Retrieves the value of the field "APConfig" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "APConfig".
     */
    inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getAPConfigMutable ();

    /**
     * Sets the value of the member "APConfig".
     *
     * If the meaning of "APConfig" isn't clear, then there should be a description here.
     *
     * @param APConfig The value which will be set
     */
    inline void setAPConfig (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& APConfig_);

    static const APConfigUpdate &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStringTo__asf__dbus__DBusVariantMap_DefaultInstance ();

    inline void set_has_APConfig ();

    inline void clear_has_APConfig ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::map< ::std::string, ::asf::dbus::DBusVariant > _APConfig;

};

/**
 * If the meaning of "APConfigRegister" isn't clear, then there should be a description here.
 */
class APConfigRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  APConfigRegister ();

    /**
     * Copy constructor
     */
    inline  APConfigRegister (const APConfigRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~APConfigRegister();

    /**
     * Assignment operator
     */
    inline APConfigRegister& operator = (const APConfigRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const APConfigRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const APConfigRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const APConfigRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const APConfigRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const APConfigRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "RestrictionsUpdate" isn't clear, then there should be a description here.
 */
class RestrictionsUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RestrictionsUpdate ();

    /**
     * Copy constructor
     */
    inline  RestrictionsUpdate (const RestrictionsUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  RestrictionsUpdate (const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& Restrictions_);

    /**
     * Destructor
     */
    inline virtual  ~RestrictionsUpdate();

    /**
     * Assignment operator
     */
    inline RestrictionsUpdate& operator = (const RestrictionsUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RestrictionsUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RestrictionsUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RestrictionsUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RestrictionsUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Restrictions"

    static const int kRestrictions = 0;

    /**
     * Clears the field "Restrictions".
     *
     * The field will be set to its default value. The hasRestrictions()
     * method will return false.
     */
    inline void clearRestrictions();

    /**
     * Checks whether the field "Restrictions" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRestrictions()). Otherwise it will return false.
     */
    inline bool hasRestrictions () const;

    /**
     * Returns the value of the member "Restrictions".
     *
     * If the meaning of "Restrictions" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Restrictions"
     */
    inline const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& getRestrictions () const;

    /**
     * Retrieves the value of the field "Restrictions" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Restrictions".
     */
    inline ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& getRestrictionsMutable ();

    /**
     * Sets the value of the member "Restrictions".
     *
     * If the meaning of "Restrictions" isn't clear, then there should be a description here.
     *
     * @param Restrictions The value which will be set
     */
    inline void setRestrictions (const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& Restrictions_);

    static const RestrictionsUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& getStringTo__asf__dbus__DBusVariantMap_List_DefaultInstance ();

    inline void set_has_Restrictions ();

    inline void clear_has_Restrictions ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > > _Restrictions;

};

/**
 * If the meaning of "RestrictionsRegister" isn't clear, then there should be a description here.
 */
class RestrictionsRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RestrictionsRegister ();

    /**
     * Copy constructor
     */
    inline  RestrictionsRegister (const RestrictionsRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~RestrictionsRegister();

    /**
     * Assignment operator
     */
    inline RestrictionsRegister& operator = (const RestrictionsRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RestrictionsRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RestrictionsRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RestrictionsRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RestrictionsRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const RestrictionsRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "SupportedFrequenciesUpdate" isn't clear, then there should be a description here.
 */
class SupportedFrequenciesUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SupportedFrequenciesUpdate ();

    /**
     * Copy constructor
     */
    inline  SupportedFrequenciesUpdate (const SupportedFrequenciesUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  SupportedFrequenciesUpdate (const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& SupportedFrequencies_);

    /**
     * Destructor
     */
    inline virtual  ~SupportedFrequenciesUpdate();

    /**
     * Assignment operator
     */
    inline SupportedFrequenciesUpdate& operator = (const SupportedFrequenciesUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SupportedFrequenciesUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SupportedFrequenciesUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SupportedFrequenciesUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SupportedFrequenciesUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SupportedFrequencies"

    static const int kSupportedFrequencies = 0;

    /**
     * Clears the field "SupportedFrequencies".
     *
     * The field will be set to its default value. The hasSupportedFrequencies()
     * method will return false.
     */
    inline void clearSupportedFrequencies();

    /**
     * Checks whether the field "SupportedFrequencies" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSupportedFrequencies()). Otherwise it will return false.
     */
    inline bool hasSupportedFrequencies () const;

    /**
     * Returns the value of the member "SupportedFrequencies".
     *
     * If the meaning of "SupportedFrequencies" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SupportedFrequencies"
     */
    inline const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& getSupportedFrequencies () const;

    /**
     * Retrieves the value of the field "SupportedFrequencies" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SupportedFrequencies".
     */
    inline ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& getSupportedFrequenciesMutable ();

    /**
     * Sets the value of the member "SupportedFrequencies".
     *
     * If the meaning of "SupportedFrequencies" isn't clear, then there should be a description here.
     *
     * @param SupportedFrequencies The value which will be set
     */
    inline void setSupportedFrequencies (const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& SupportedFrequencies_);

    static const SupportedFrequenciesUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& getStringTo__asf__dbus__DBusVariantMap_List_DefaultInstance ();

    inline void set_has_SupportedFrequencies ();

    inline void clear_has_SupportedFrequencies ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > > _SupportedFrequencies;

};

/**
 * If the meaning of "SupportedFrequenciesRegister" isn't clear, then there should be a description here.
 */
class SupportedFrequenciesRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SupportedFrequenciesRegister ();

    /**
     * Copy constructor
     */
    inline  SupportedFrequenciesRegister (const SupportedFrequenciesRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~SupportedFrequenciesRegister();

    /**
     * Assignment operator
     */
    inline SupportedFrequenciesRegister& operator = (const SupportedFrequenciesRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SupportedFrequenciesRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SupportedFrequenciesRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SupportedFrequenciesRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SupportedFrequenciesRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const SupportedFrequenciesRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "IPv4ConfigurationUpdate" isn't clear, then there should be a description here.
 */
class IPv4ConfigurationUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IPv4ConfigurationUpdate ();

    /**
     * Copy constructor
     */
    inline  IPv4ConfigurationUpdate (const IPv4ConfigurationUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  IPv4ConfigurationUpdate (const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& IPv4Configuration_);

    /**
     * Destructor
     */
    inline virtual  ~IPv4ConfigurationUpdate();

    /**
     * Assignment operator
     */
    inline IPv4ConfigurationUpdate& operator = (const IPv4ConfigurationUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IPv4ConfigurationUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IPv4ConfigurationUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IPv4ConfigurationUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IPv4ConfigurationUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "IPv4Configuration"

    static const int kIPv4Configuration = 0;

    /**
     * Clears the field "IPv4Configuration".
     *
     * The field will be set to its default value. The hasIPv4Configuration()
     * method will return false.
     */
    inline void clearIPv4Configuration();

    /**
     * Checks whether the field "IPv4Configuration" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIPv4Configuration()). Otherwise it will return false.
     */
    inline bool hasIPv4Configuration () const;

    /**
     * Returns the value of the member "IPv4Configuration".
     *
     * If the meaning of "IPv4Configuration" isn't clear, then there should be a description here.
     *
     * @return The value of the field "IPv4Configuration"
     */
    inline const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& getIPv4Configuration () const;

    /**
     * Retrieves the value of the field "IPv4Configuration" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "IPv4Configuration".
     */
    inline ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& getIPv4ConfigurationMutable ();

    /**
     * Sets the value of the member "IPv4Configuration".
     *
     * If the meaning of "IPv4Configuration" isn't clear, then there should be a description here.
     *
     * @param IPv4Configuration The value which will be set
     */
    inline void setIPv4Configuration (const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& IPv4Configuration_);

    static const IPv4ConfigurationUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& getStringTo__asf__dbus__DBusVariantMap_List_DefaultInstance ();

    inline void set_has_IPv4Configuration ();

    inline void clear_has_IPv4Configuration ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > > _IPv4Configuration;

};

/**
 * If the meaning of "IPv4ConfigurationRegister" isn't clear, then there should be a description here.
 */
class IPv4ConfigurationRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IPv4ConfigurationRegister ();

    /**
     * Copy constructor
     */
    inline  IPv4ConfigurationRegister (const IPv4ConfigurationRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~IPv4ConfigurationRegister();

    /**
     * Assignment operator
     */
    inline IPv4ConfigurationRegister& operator = (const IPv4ConfigurationRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IPv4ConfigurationRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IPv4ConfigurationRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IPv4ConfigurationRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IPv4ConfigurationRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const IPv4ConfigurationRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "ConnectionStatusUpdate" isn't clear, then there should be a description here.
 */
class ConnectionStatusUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConnectionStatusUpdate ();

    /**
     * Copy constructor
     */
    inline  ConnectionStatusUpdate (const ConnectionStatusUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ConnectionStatusUpdate (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& ConnectionStatus_);

    /**
     * Destructor
     */
    inline virtual  ~ConnectionStatusUpdate();

    /**
     * Assignment operator
     */
    inline ConnectionStatusUpdate& operator = (const ConnectionStatusUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConnectionStatusUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConnectionStatusUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConnectionStatusUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConnectionStatusUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ConnectionStatus"

    static const int kConnectionStatus = 0;

    /**
     * Clears the field "ConnectionStatus".
     *
     * The field will be set to its default value. The hasConnectionStatus()
     * method will return false.
     */
    inline void clearConnectionStatus();

    /**
     * Checks whether the field "ConnectionStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConnectionStatus()). Otherwise it will return false.
     */
    inline bool hasConnectionStatus () const;

    /**
     * Returns the value of the member "ConnectionStatus".
     *
     * If the meaning of "ConnectionStatus" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ConnectionStatus"
     */
    inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getConnectionStatus () const;

    /**
     * Retrieves the value of the field "ConnectionStatus" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ConnectionStatus".
     */
    inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getConnectionStatusMutable ();

    /**
     * Sets the value of the member "ConnectionStatus".
     *
     * If the meaning of "ConnectionStatus" isn't clear, then there should be a description here.
     *
     * @param ConnectionStatus The value which will be set
     */
    inline void setConnectionStatus (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& ConnectionStatus_);

    static const ConnectionStatusUpdate &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStringTo__asf__dbus__DBusVariantMap_DefaultInstance ();

    inline void set_has_ConnectionStatus ();

    inline void clear_has_ConnectionStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::map< ::std::string, ::asf::dbus::DBusVariant > _ConnectionStatus;

};

/**
 * If the meaning of "ConnectionStatusRegister" isn't clear, then there should be a description here.
 */
class ConnectionStatusRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConnectionStatusRegister ();

    /**
     * Copy constructor
     */
    inline  ConnectionStatusRegister (const ConnectionStatusRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ConnectionStatusRegister();

    /**
     * Assignment operator
     */
    inline ConnectionStatusRegister& operator = (const ConnectionStatusRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConnectionStatusRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConnectionStatusRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConnectionStatusRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConnectionStatusRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ConnectionStatusRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

inline  DeAuthenticateStationRequest::DeAuthenticateStationRequest ()  :
    _station ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DeAuthenticateStationRequest::DeAuthenticateStationRequest (const DeAuthenticateStationRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _station ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DeAuthenticateStationRequest::DeAuthenticateStationRequest (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& station_)  :
    _station (station_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DeAuthenticateStationRequest::~DeAuthenticateStationRequest() {
}

inline DeAuthenticateStationRequest& DeAuthenticateStationRequest::operator = (const DeAuthenticateStationRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStation()) {
            setStation(rhs.getStation());
        } else {
            clearStation();
        }
    }
    return *this;
}

inline bool DeAuthenticateStationRequest::operator == (const DeAuthenticateStationRequest& rhs) const {
    return (((!hasStation() && !rhs.hasStation()) || getStation() == rhs.getStation()));
}

inline bool DeAuthenticateStationRequest::operator != (const DeAuthenticateStationRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool DeAuthenticateStationRequest::operator < (const DeAuthenticateStationRequest& rhs) const {
    if (hasStation() || rhs.hasStation()) {
        if (getStation() < rhs.getStation()) return true;
        if (getStation() > rhs.getStation()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DeAuthenticateStationRequest::clone() {
    return new DeAuthenticateStationRequest(*this);
}

inline bool DeAuthenticateStationRequest::operator > (const DeAuthenticateStationRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DeAuthenticateStationRequest::clear() {
    clearStation();
}

inline void DeAuthenticateStationRequest::clearStation() {
    if (hasStation()) {
         clear_has_station();
        _station.clear();
     }
}

inline bool DeAuthenticateStationRequest::hasStation () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& DeAuthenticateStationRequest::getStation () const {
    return _station;
}

inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& DeAuthenticateStationRequest::getStationMutable () {
    set_has_station();
    return _station;
}

inline void DeAuthenticateStationRequest::setStation (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& station_) {
    set_has_station();
    this->_station = station_;
}

inline void DeAuthenticateStationRequest::set_has_station () {
    _has_bits_[0] |= 1u << 0;
}

inline void DeAuthenticateStationRequest::clear_has_station () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ManageBandwidthRequest::ManageBandwidthRequest ()  :
    _allocate (false),
    _station ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ManageBandwidthRequest::ManageBandwidthRequest (const ManageBandwidthRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _allocate (false),
    _station ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ManageBandwidthRequest::ManageBandwidthRequest (bool allocate_, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& station_)  :
    _allocate (allocate_),
    _station (station_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ManageBandwidthRequest::~ManageBandwidthRequest() {
}

inline ManageBandwidthRequest& ManageBandwidthRequest::operator = (const ManageBandwidthRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAllocate()) {
            setAllocate(rhs.getAllocate());
        } else {
            clearAllocate();
        }
        if (rhs.hasStation()) {
            setStation(rhs.getStation());
        } else {
            clearStation();
        }
    }
    return *this;
}

inline bool ManageBandwidthRequest::operator == (const ManageBandwidthRequest& rhs) const {
    return (((!hasAllocate() && !rhs.hasAllocate()) || getAllocate() == rhs.getAllocate()) &&
        ((!hasStation() && !rhs.hasStation()) || getStation() == rhs.getStation()));
}

inline bool ManageBandwidthRequest::operator != (const ManageBandwidthRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ManageBandwidthRequest::operator < (const ManageBandwidthRequest& rhs) const {
    if (hasAllocate() || rhs.hasAllocate()) {
        if (getAllocate() < rhs.getAllocate()) return true;
        if (getAllocate() > rhs.getAllocate()) return false;
    }
    if (hasStation() || rhs.hasStation()) {
        if (getStation() < rhs.getStation()) return true;
        if (getStation() > rhs.getStation()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ManageBandwidthRequest::clone() {
    return new ManageBandwidthRequest(*this);
}

inline bool ManageBandwidthRequest::operator > (const ManageBandwidthRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ManageBandwidthRequest::clear() {
    clearAllocate();
    clearStation();
}

inline void ManageBandwidthRequest::clearAllocate() {
    if (hasAllocate()) {
         clear_has_allocate();
        _allocate = false;
     }
}

inline bool ManageBandwidthRequest::hasAllocate () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool ManageBandwidthRequest::getAllocate () const {
    return _allocate;
}

inline void ManageBandwidthRequest::setAllocate (bool allocate_) {
    set_has_allocate();
    this->_allocate = allocate_;
}

inline void ManageBandwidthRequest::clearStation() {
    if (hasStation()) {
         clear_has_station();
        _station.clear();
     }
}

inline bool ManageBandwidthRequest::hasStation () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& ManageBandwidthRequest::getStation () const {
    return _station;
}

inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& ManageBandwidthRequest::getStationMutable () {
    set_has_station();
    return _station;
}

inline void ManageBandwidthRequest::setStation (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& station_) {
    set_has_station();
    this->_station = station_;
}

inline void ManageBandwidthRequest::set_has_allocate () {
    _has_bits_[0] |= 1u << 0;
}

inline void ManageBandwidthRequest::clear_has_allocate () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ManageBandwidthRequest::set_has_station () {
    _has_bits_[0] |= 1u << 1;
}

inline void ManageBandwidthRequest::clear_has_station () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SetRestrictionsRequest::SetRestrictionsRequest ()  :
    _technology (),
    _restrict ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetRestrictionsRequest::SetRestrictionsRequest (const SetRestrictionsRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _technology (),
    _restrict ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetRestrictionsRequest::SetRestrictionsRequest (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& technology_, const ::std::string& restrict_)  :
    _technology (technology_),
    _restrict (restrict_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (restrict_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetRestrictionsRequest::~SetRestrictionsRequest() {
}

inline SetRestrictionsRequest& SetRestrictionsRequest::operator = (const SetRestrictionsRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTechnology()) {
            setTechnology(rhs.getTechnology());
        } else {
            clearTechnology();
        }
        if (rhs.hasRestrict()) {
            setRestrict(rhs.getRestrict());
        } else {
            clearRestrict();
        }
    }
    return *this;
}

inline bool SetRestrictionsRequest::operator == (const SetRestrictionsRequest& rhs) const {
    return (((!hasTechnology() && !rhs.hasTechnology()) || getTechnology() == rhs.getTechnology()) &&
        ((!hasRestrict() && !rhs.hasRestrict()) || getRestrict() == rhs.getRestrict()));
}

inline bool SetRestrictionsRequest::operator != (const SetRestrictionsRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SetRestrictionsRequest::operator < (const SetRestrictionsRequest& rhs) const {
    if (hasTechnology() || rhs.hasTechnology()) {
        if (getTechnology() < rhs.getTechnology()) return true;
        if (getTechnology() > rhs.getTechnology()) return false;
    }
    if (hasRestrict() || rhs.hasRestrict()) {
        if (getRestrict() < rhs.getRestrict()) return true;
        if (getRestrict() > rhs.getRestrict()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetRestrictionsRequest::clone() {
    return new SetRestrictionsRequest(*this);
}

inline bool SetRestrictionsRequest::operator > (const SetRestrictionsRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetRestrictionsRequest::clear() {
    clearTechnology();
    clearRestrict();
}

inline void SetRestrictionsRequest::clearTechnology() {
    if (hasTechnology()) {
         clear_has_technology();
        _technology.clear();
     }
}

inline bool SetRestrictionsRequest::hasTechnology () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& SetRestrictionsRequest::getTechnology () const {
    return _technology;
}

inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& SetRestrictionsRequest::getTechnologyMutable () {
    set_has_technology();
    return _technology;
}

inline void SetRestrictionsRequest::setTechnology (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& technology_) {
    set_has_technology();
    this->_technology = technology_;
}

inline void SetRestrictionsRequest::clearRestrict() {
    if (hasRestrict()) {
         clear_has_restrict();
        _restrict.clear();
     }
}

inline bool SetRestrictionsRequest::hasRestrict () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& SetRestrictionsRequest::getRestrict () const {
    return _restrict;
}

inline ::std::string& SetRestrictionsRequest::getRestrictMutable () {
    set_has_restrict();
    return _restrict;
}

inline void SetRestrictionsRequest::setRestrict (const ::std::string& restrict_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (restrict_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_restrict();
    this->_restrict = restrict_;
}

inline void SetRestrictionsRequest::setRestrict (const char* restrict_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (restrict_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_restrict();
    this->_restrict.assign(restrict_);
}

inline void SetRestrictionsRequest::setRestrict (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_restrict();
    this->_restrict.assign(value, size);
}

inline void SetRestrictionsRequest::set_has_technology () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetRestrictionsRequest::clear_has_technology () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetRestrictionsRequest::set_has_restrict () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetRestrictionsRequest::clear_has_restrict () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  ModeUpdate::ModeUpdate ()  :
    _Mode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ModeUpdate::ModeUpdate (const ModeUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Mode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ModeUpdate::ModeUpdate (const ::std::string& Mode_)  :
    _Mode (Mode_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Mode_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ModeUpdate::~ModeUpdate() {
}

inline ModeUpdate& ModeUpdate::operator = (const ModeUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMode()) {
            setMode(rhs.getMode());
        } else {
            clearMode();
        }
    }
    return *this;
}

inline bool ModeUpdate::operator == (const ModeUpdate& rhs) const {
    return (((!hasMode() && !rhs.hasMode()) || getMode() == rhs.getMode()));
}

inline bool ModeUpdate::operator != (const ModeUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool ModeUpdate::operator < (const ModeUpdate& rhs) const {
    if (hasMode() || rhs.hasMode()) {
        if (getMode() < rhs.getMode()) return true;
        if (getMode() > rhs.getMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ModeUpdate::clone() {
    return new ModeUpdate(*this);
}

inline bool ModeUpdate::operator > (const ModeUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ModeUpdate::clear() {
    clearMode();
}

inline void ModeUpdate::clearMode() {
    if (hasMode()) {
         clear_has_Mode();
        _Mode.clear();
     }
}

inline bool ModeUpdate::hasMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ModeUpdate::getMode () const {
    return _Mode;
}

inline ::std::string& ModeUpdate::getModeMutable () {
    set_has_Mode();
    return _Mode;
}

inline void ModeUpdate::setMode (const ::std::string& Mode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Mode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Mode();
    this->_Mode = Mode_;
}

inline void ModeUpdate::setMode (const char* Mode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Mode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Mode();
    this->_Mode.assign(Mode_);
}

inline void ModeUpdate::setMode (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Mode();
    this->_Mode.assign(value, size);
}

inline void ModeUpdate::set_has_Mode () {
    _has_bits_[0] |= 1u << 0;
}

inline void ModeUpdate::clear_has_Mode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ModeRegister::ModeRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ModeRegister::ModeRegister (const ModeRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ModeRegister::~ModeRegister() {
}

inline ModeRegister& ModeRegister::operator = (const ModeRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool ModeRegister::operator == (const ModeRegister& ) const {
    return true;
}

inline bool ModeRegister::operator != (const ModeRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool ModeRegister::operator < (const ModeRegister& ) const {
    return false;
}

inline ::asf::core::Payload* ModeRegister::clone() {
    return new ModeRegister(*this);
}

inline bool ModeRegister::operator > (const ModeRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ModeRegister::clear() {
}

inline  InterfaceUpdate::InterfaceUpdate ()  :
    _Interface ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  InterfaceUpdate::InterfaceUpdate (const InterfaceUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Interface ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  InterfaceUpdate::InterfaceUpdate (const ::std::string& Interface_)  :
    _Interface (Interface_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Interface_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  InterfaceUpdate::~InterfaceUpdate() {
}

inline InterfaceUpdate& InterfaceUpdate::operator = (const InterfaceUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasInterface()) {
            setInterface(rhs.getInterface());
        } else {
            clearInterface();
        }
    }
    return *this;
}

inline bool InterfaceUpdate::operator == (const InterfaceUpdate& rhs) const {
    return (((!hasInterface() && !rhs.hasInterface()) || getInterface() == rhs.getInterface()));
}

inline bool InterfaceUpdate::operator != (const InterfaceUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool InterfaceUpdate::operator < (const InterfaceUpdate& rhs) const {
    if (hasInterface() || rhs.hasInterface()) {
        if (getInterface() < rhs.getInterface()) return true;
        if (getInterface() > rhs.getInterface()) return false;
    }
    return false;
}

inline ::asf::core::Payload* InterfaceUpdate::clone() {
    return new InterfaceUpdate(*this);
}

inline bool InterfaceUpdate::operator > (const InterfaceUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void InterfaceUpdate::clear() {
    clearInterface();
}

inline void InterfaceUpdate::clearInterface() {
    if (hasInterface()) {
         clear_has_Interface();
        _Interface.clear();
     }
}

inline bool InterfaceUpdate::hasInterface () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& InterfaceUpdate::getInterface () const {
    return _Interface;
}

inline ::std::string& InterfaceUpdate::getInterfaceMutable () {
    set_has_Interface();
    return _Interface;
}

inline void InterfaceUpdate::setInterface (const ::std::string& Interface_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Interface_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Interface();
    this->_Interface = Interface_;
}

inline void InterfaceUpdate::setInterface (const char* Interface_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Interface_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Interface();
    this->_Interface.assign(Interface_);
}

inline void InterfaceUpdate::setInterface (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Interface();
    this->_Interface.assign(value, size);
}

inline void InterfaceUpdate::set_has_Interface () {
    _has_bits_[0] |= 1u << 0;
}

inline void InterfaceUpdate::clear_has_Interface () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  InterfaceRegister::InterfaceRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  InterfaceRegister::InterfaceRegister (const InterfaceRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  InterfaceRegister::~InterfaceRegister() {
}

inline InterfaceRegister& InterfaceRegister::operator = (const InterfaceRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool InterfaceRegister::operator == (const InterfaceRegister& ) const {
    return true;
}

inline bool InterfaceRegister::operator != (const InterfaceRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool InterfaceRegister::operator < (const InterfaceRegister& ) const {
    return false;
}

inline ::asf::core::Payload* InterfaceRegister::clone() {
    return new InterfaceRegister(*this);
}

inline bool InterfaceRegister::operator > (const InterfaceRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void InterfaceRegister::clear() {
}

inline  MacAddressUpdate::MacAddressUpdate ()  :
    _MacAddress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MacAddressUpdate::MacAddressUpdate (const MacAddressUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _MacAddress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MacAddressUpdate::MacAddressUpdate (const ::std::string& MacAddress_)  :
    _MacAddress (MacAddress_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (MacAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  MacAddressUpdate::~MacAddressUpdate() {
}

inline MacAddressUpdate& MacAddressUpdate::operator = (const MacAddressUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMacAddress()) {
            setMacAddress(rhs.getMacAddress());
        } else {
            clearMacAddress();
        }
    }
    return *this;
}

inline bool MacAddressUpdate::operator == (const MacAddressUpdate& rhs) const {
    return (((!hasMacAddress() && !rhs.hasMacAddress()) || getMacAddress() == rhs.getMacAddress()));
}

inline bool MacAddressUpdate::operator != (const MacAddressUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool MacAddressUpdate::operator < (const MacAddressUpdate& rhs) const {
    if (hasMacAddress() || rhs.hasMacAddress()) {
        if (getMacAddress() < rhs.getMacAddress()) return true;
        if (getMacAddress() > rhs.getMacAddress()) return false;
    }
    return false;
}

inline ::asf::core::Payload* MacAddressUpdate::clone() {
    return new MacAddressUpdate(*this);
}

inline bool MacAddressUpdate::operator > (const MacAddressUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MacAddressUpdate::clear() {
    clearMacAddress();
}

inline void MacAddressUpdate::clearMacAddress() {
    if (hasMacAddress()) {
         clear_has_MacAddress();
        _MacAddress.clear();
     }
}

inline bool MacAddressUpdate::hasMacAddress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& MacAddressUpdate::getMacAddress () const {
    return _MacAddress;
}

inline ::std::string& MacAddressUpdate::getMacAddressMutable () {
    set_has_MacAddress();
    return _MacAddress;
}

inline void MacAddressUpdate::setMacAddress (const ::std::string& MacAddress_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (MacAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_MacAddress();
    this->_MacAddress = MacAddress_;
}

inline void MacAddressUpdate::setMacAddress (const char* MacAddress_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (MacAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_MacAddress();
    this->_MacAddress.assign(MacAddress_);
}

inline void MacAddressUpdate::setMacAddress (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_MacAddress();
    this->_MacAddress.assign(value, size);
}

inline void MacAddressUpdate::set_has_MacAddress () {
    _has_bits_[0] |= 1u << 0;
}

inline void MacAddressUpdate::clear_has_MacAddress () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  MacAddressRegister::MacAddressRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MacAddressRegister::MacAddressRegister (const MacAddressRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MacAddressRegister::~MacAddressRegister() {
}

inline MacAddressRegister& MacAddressRegister::operator = (const MacAddressRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool MacAddressRegister::operator == (const MacAddressRegister& ) const {
    return true;
}

inline bool MacAddressRegister::operator != (const MacAddressRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool MacAddressRegister::operator < (const MacAddressRegister& ) const {
    return false;
}

inline ::asf::core::Payload* MacAddressRegister::clone() {
    return new MacAddressRegister(*this);
}

inline bool MacAddressRegister::operator > (const MacAddressRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MacAddressRegister::clear() {
}

inline  PowerStateUpdate::PowerStateUpdate ()  :
    _PowerState ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PowerStateUpdate::PowerStateUpdate (const PowerStateUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _PowerState ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PowerStateUpdate::PowerStateUpdate (const ::std::string& PowerState_)  :
    _PowerState (PowerState_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (PowerState_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PowerStateUpdate::~PowerStateUpdate() {
}

inline PowerStateUpdate& PowerStateUpdate::operator = (const PowerStateUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPowerState()) {
            setPowerState(rhs.getPowerState());
        } else {
            clearPowerState();
        }
    }
    return *this;
}

inline bool PowerStateUpdate::operator == (const PowerStateUpdate& rhs) const {
    return (((!hasPowerState() && !rhs.hasPowerState()) || getPowerState() == rhs.getPowerState()));
}

inline bool PowerStateUpdate::operator != (const PowerStateUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool PowerStateUpdate::operator < (const PowerStateUpdate& rhs) const {
    if (hasPowerState() || rhs.hasPowerState()) {
        if (getPowerState() < rhs.getPowerState()) return true;
        if (getPowerState() > rhs.getPowerState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PowerStateUpdate::clone() {
    return new PowerStateUpdate(*this);
}

inline bool PowerStateUpdate::operator > (const PowerStateUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PowerStateUpdate::clear() {
    clearPowerState();
}

inline void PowerStateUpdate::clearPowerState() {
    if (hasPowerState()) {
         clear_has_PowerState();
        _PowerState.clear();
     }
}

inline bool PowerStateUpdate::hasPowerState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& PowerStateUpdate::getPowerState () const {
    return _PowerState;
}

inline ::std::string& PowerStateUpdate::getPowerStateMutable () {
    set_has_PowerState();
    return _PowerState;
}

inline void PowerStateUpdate::setPowerState (const ::std::string& PowerState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (PowerState_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_PowerState();
    this->_PowerState = PowerState_;
}

inline void PowerStateUpdate::setPowerState (const char* PowerState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (PowerState_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_PowerState();
    this->_PowerState.assign(PowerState_);
}

inline void PowerStateUpdate::setPowerState (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_PowerState();
    this->_PowerState.assign(value, size);
}

inline void PowerStateUpdate::set_has_PowerState () {
    _has_bits_[0] |= 1u << 0;
}

inline void PowerStateUpdate::clear_has_PowerState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  PowerStateRegister::PowerStateRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PowerStateRegister::PowerStateRegister (const PowerStateRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PowerStateRegister::~PowerStateRegister() {
}

inline PowerStateRegister& PowerStateRegister::operator = (const PowerStateRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool PowerStateRegister::operator == (const PowerStateRegister& ) const {
    return true;
}

inline bool PowerStateRegister::operator != (const PowerStateRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool PowerStateRegister::operator < (const PowerStateRegister& ) const {
    return false;
}

inline ::asf::core::Payload* PowerStateRegister::clone() {
    return new PowerStateRegister(*this);
}

inline bool PowerStateRegister::operator > (const PowerStateRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PowerStateRegister::clear() {
}

inline  PowerFailureReasonUpdate::PowerFailureReasonUpdate ()  :
    _PowerFailureReason ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PowerFailureReasonUpdate::PowerFailureReasonUpdate (const PowerFailureReasonUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _PowerFailureReason ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PowerFailureReasonUpdate::PowerFailureReasonUpdate (const ::std::string& PowerFailureReason_)  :
    _PowerFailureReason (PowerFailureReason_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (PowerFailureReason_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PowerFailureReasonUpdate::~PowerFailureReasonUpdate() {
}

inline PowerFailureReasonUpdate& PowerFailureReasonUpdate::operator = (const PowerFailureReasonUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPowerFailureReason()) {
            setPowerFailureReason(rhs.getPowerFailureReason());
        } else {
            clearPowerFailureReason();
        }
    }
    return *this;
}

inline bool PowerFailureReasonUpdate::operator == (const PowerFailureReasonUpdate& rhs) const {
    return (((!hasPowerFailureReason() && !rhs.hasPowerFailureReason()) || getPowerFailureReason() == rhs.getPowerFailureReason()));
}

inline bool PowerFailureReasonUpdate::operator != (const PowerFailureReasonUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool PowerFailureReasonUpdate::operator < (const PowerFailureReasonUpdate& rhs) const {
    if (hasPowerFailureReason() || rhs.hasPowerFailureReason()) {
        if (getPowerFailureReason() < rhs.getPowerFailureReason()) return true;
        if (getPowerFailureReason() > rhs.getPowerFailureReason()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PowerFailureReasonUpdate::clone() {
    return new PowerFailureReasonUpdate(*this);
}

inline bool PowerFailureReasonUpdate::operator > (const PowerFailureReasonUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PowerFailureReasonUpdate::clear() {
    clearPowerFailureReason();
}

inline void PowerFailureReasonUpdate::clearPowerFailureReason() {
    if (hasPowerFailureReason()) {
         clear_has_PowerFailureReason();
        _PowerFailureReason.clear();
     }
}

inline bool PowerFailureReasonUpdate::hasPowerFailureReason () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& PowerFailureReasonUpdate::getPowerFailureReason () const {
    return _PowerFailureReason;
}

inline ::std::string& PowerFailureReasonUpdate::getPowerFailureReasonMutable () {
    set_has_PowerFailureReason();
    return _PowerFailureReason;
}

inline void PowerFailureReasonUpdate::setPowerFailureReason (const ::std::string& PowerFailureReason_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (PowerFailureReason_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_PowerFailureReason();
    this->_PowerFailureReason = PowerFailureReason_;
}

inline void PowerFailureReasonUpdate::setPowerFailureReason (const char* PowerFailureReason_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (PowerFailureReason_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_PowerFailureReason();
    this->_PowerFailureReason.assign(PowerFailureReason_);
}

inline void PowerFailureReasonUpdate::setPowerFailureReason (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_PowerFailureReason();
    this->_PowerFailureReason.assign(value, size);
}

inline void PowerFailureReasonUpdate::set_has_PowerFailureReason () {
    _has_bits_[0] |= 1u << 0;
}

inline void PowerFailureReasonUpdate::clear_has_PowerFailureReason () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  PowerFailureReasonRegister::PowerFailureReasonRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PowerFailureReasonRegister::PowerFailureReasonRegister (const PowerFailureReasonRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PowerFailureReasonRegister::~PowerFailureReasonRegister() {
}

inline PowerFailureReasonRegister& PowerFailureReasonRegister::operator = (const PowerFailureReasonRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool PowerFailureReasonRegister::operator == (const PowerFailureReasonRegister& ) const {
    return true;
}

inline bool PowerFailureReasonRegister::operator != (const PowerFailureReasonRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool PowerFailureReasonRegister::operator < (const PowerFailureReasonRegister& ) const {
    return false;
}

inline ::asf::core::Payload* PowerFailureReasonRegister::clone() {
    return new PowerFailureReasonRegister(*this);
}

inline bool PowerFailureReasonRegister::operator > (const PowerFailureReasonRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PowerFailureReasonRegister::clear() {
}

inline  FrequencyUpdate::FrequencyUpdate ()  :
    _Frequency ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FrequencyUpdate::FrequencyUpdate (const FrequencyUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Frequency ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FrequencyUpdate::FrequencyUpdate (const ::std::string& Frequency_)  :
    _Frequency (Frequency_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Frequency_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FrequencyUpdate::~FrequencyUpdate() {
}

inline FrequencyUpdate& FrequencyUpdate::operator = (const FrequencyUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasFrequency()) {
            setFrequency(rhs.getFrequency());
        } else {
            clearFrequency();
        }
    }
    return *this;
}

inline bool FrequencyUpdate::operator == (const FrequencyUpdate& rhs) const {
    return (((!hasFrequency() && !rhs.hasFrequency()) || getFrequency() == rhs.getFrequency()));
}

inline bool FrequencyUpdate::operator != (const FrequencyUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool FrequencyUpdate::operator < (const FrequencyUpdate& rhs) const {
    if (hasFrequency() || rhs.hasFrequency()) {
        if (getFrequency() < rhs.getFrequency()) return true;
        if (getFrequency() > rhs.getFrequency()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FrequencyUpdate::clone() {
    return new FrequencyUpdate(*this);
}

inline bool FrequencyUpdate::operator > (const FrequencyUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FrequencyUpdate::clear() {
    clearFrequency();
}

inline void FrequencyUpdate::clearFrequency() {
    if (hasFrequency()) {
         clear_has_Frequency();
        _Frequency.clear();
     }
}

inline bool FrequencyUpdate::hasFrequency () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& FrequencyUpdate::getFrequency () const {
    return _Frequency;
}

inline ::std::string& FrequencyUpdate::getFrequencyMutable () {
    set_has_Frequency();
    return _Frequency;
}

inline void FrequencyUpdate::setFrequency (const ::std::string& Frequency_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Frequency_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Frequency();
    this->_Frequency = Frequency_;
}

inline void FrequencyUpdate::setFrequency (const char* Frequency_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Frequency_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Frequency();
    this->_Frequency.assign(Frequency_);
}

inline void FrequencyUpdate::setFrequency (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Frequency();
    this->_Frequency.assign(value, size);
}

inline void FrequencyUpdate::set_has_Frequency () {
    _has_bits_[0] |= 1u << 0;
}

inline void FrequencyUpdate::clear_has_Frequency () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FrequencyRegister::FrequencyRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FrequencyRegister::FrequencyRegister (const FrequencyRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FrequencyRegister::~FrequencyRegister() {
}

inline FrequencyRegister& FrequencyRegister::operator = (const FrequencyRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool FrequencyRegister::operator == (const FrequencyRegister& ) const {
    return true;
}

inline bool FrequencyRegister::operator != (const FrequencyRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool FrequencyRegister::operator < (const FrequencyRegister& ) const {
    return false;
}

inline ::asf::core::Payload* FrequencyRegister::clone() {
    return new FrequencyRegister(*this);
}

inline bool FrequencyRegister::operator > (const FrequencyRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FrequencyRegister::clear() {
}

inline  CurrentOperatingChannelUpdate::CurrentOperatingChannelUpdate ()  :
    _CurrentOperatingChannel (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CurrentOperatingChannelUpdate::CurrentOperatingChannelUpdate (const CurrentOperatingChannelUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _CurrentOperatingChannel (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CurrentOperatingChannelUpdate::CurrentOperatingChannelUpdate (int32 CurrentOperatingChannel_)  :
    _CurrentOperatingChannel (CurrentOperatingChannel_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CurrentOperatingChannelUpdate::~CurrentOperatingChannelUpdate() {
}

inline CurrentOperatingChannelUpdate& CurrentOperatingChannelUpdate::operator = (const CurrentOperatingChannelUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCurrentOperatingChannel()) {
            setCurrentOperatingChannel(rhs.getCurrentOperatingChannel());
        } else {
            clearCurrentOperatingChannel();
        }
    }
    return *this;
}

inline bool CurrentOperatingChannelUpdate::operator == (const CurrentOperatingChannelUpdate& rhs) const {
    return (((!hasCurrentOperatingChannel() && !rhs.hasCurrentOperatingChannel()) || getCurrentOperatingChannel() == rhs.getCurrentOperatingChannel()));
}

inline bool CurrentOperatingChannelUpdate::operator != (const CurrentOperatingChannelUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool CurrentOperatingChannelUpdate::operator < (const CurrentOperatingChannelUpdate& rhs) const {
    if (hasCurrentOperatingChannel() || rhs.hasCurrentOperatingChannel()) {
        if (getCurrentOperatingChannel() < rhs.getCurrentOperatingChannel()) return true;
        if (getCurrentOperatingChannel() > rhs.getCurrentOperatingChannel()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CurrentOperatingChannelUpdate::clone() {
    return new CurrentOperatingChannelUpdate(*this);
}

inline bool CurrentOperatingChannelUpdate::operator > (const CurrentOperatingChannelUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CurrentOperatingChannelUpdate::clear() {
    clearCurrentOperatingChannel();
}

inline void CurrentOperatingChannelUpdate::clearCurrentOperatingChannel() {
    if (hasCurrentOperatingChannel()) {
         clear_has_CurrentOperatingChannel();
        _CurrentOperatingChannel = 0;
     }
}

inline bool CurrentOperatingChannelUpdate::hasCurrentOperatingChannel () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 CurrentOperatingChannelUpdate::getCurrentOperatingChannel () const {
    return _CurrentOperatingChannel;
}

inline void CurrentOperatingChannelUpdate::setCurrentOperatingChannel (int32 CurrentOperatingChannel_) {
    set_has_CurrentOperatingChannel();
    this->_CurrentOperatingChannel = CurrentOperatingChannel_;
}

inline void CurrentOperatingChannelUpdate::set_has_CurrentOperatingChannel () {
    _has_bits_[0] |= 1u << 0;
}

inline void CurrentOperatingChannelUpdate::clear_has_CurrentOperatingChannel () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CurrentOperatingChannelRegister::CurrentOperatingChannelRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CurrentOperatingChannelRegister::CurrentOperatingChannelRegister (const CurrentOperatingChannelRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CurrentOperatingChannelRegister::~CurrentOperatingChannelRegister() {
}

inline CurrentOperatingChannelRegister& CurrentOperatingChannelRegister::operator = (const CurrentOperatingChannelRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool CurrentOperatingChannelRegister::operator == (const CurrentOperatingChannelRegister& ) const {
    return true;
}

inline bool CurrentOperatingChannelRegister::operator != (const CurrentOperatingChannelRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool CurrentOperatingChannelRegister::operator < (const CurrentOperatingChannelRegister& ) const {
    return false;
}

inline ::asf::core::Payload* CurrentOperatingChannelRegister::clone() {
    return new CurrentOperatingChannelRegister(*this);
}

inline bool CurrentOperatingChannelRegister::operator > (const CurrentOperatingChannelRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CurrentOperatingChannelRegister::clear() {
}

inline  APConfigUpdate::APConfigUpdate ()  :
    _APConfig ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  APConfigUpdate::APConfigUpdate (const APConfigUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _APConfig ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  APConfigUpdate::APConfigUpdate (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& APConfig_)  :
    _APConfig (APConfig_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  APConfigUpdate::~APConfigUpdate() {
}

inline APConfigUpdate& APConfigUpdate::operator = (const APConfigUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAPConfig()) {
            setAPConfig(rhs.getAPConfig());
        } else {
            clearAPConfig();
        }
    }
    return *this;
}

inline bool APConfigUpdate::operator == (const APConfigUpdate& rhs) const {
    return (((!hasAPConfig() && !rhs.hasAPConfig()) || getAPConfig() == rhs.getAPConfig()));
}

inline bool APConfigUpdate::operator != (const APConfigUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool APConfigUpdate::operator < (const APConfigUpdate& rhs) const {
    if (hasAPConfig() || rhs.hasAPConfig()) {
        if (getAPConfig() < rhs.getAPConfig()) return true;
        if (getAPConfig() > rhs.getAPConfig()) return false;
    }
    return false;
}

inline ::asf::core::Payload* APConfigUpdate::clone() {
    return new APConfigUpdate(*this);
}

inline bool APConfigUpdate::operator > (const APConfigUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void APConfigUpdate::clear() {
    clearAPConfig();
}

inline void APConfigUpdate::clearAPConfig() {
    if (hasAPConfig()) {
         clear_has_APConfig();
        _APConfig.clear();
     }
}

inline bool APConfigUpdate::hasAPConfig () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& APConfigUpdate::getAPConfig () const {
    return _APConfig;
}

inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& APConfigUpdate::getAPConfigMutable () {
    set_has_APConfig();
    return _APConfig;
}

inline void APConfigUpdate::setAPConfig (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& APConfig_) {
    set_has_APConfig();
    this->_APConfig = APConfig_;
}

inline void APConfigUpdate::set_has_APConfig () {
    _has_bits_[0] |= 1u << 0;
}

inline void APConfigUpdate::clear_has_APConfig () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  APConfigRegister::APConfigRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  APConfigRegister::APConfigRegister (const APConfigRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  APConfigRegister::~APConfigRegister() {
}

inline APConfigRegister& APConfigRegister::operator = (const APConfigRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool APConfigRegister::operator == (const APConfigRegister& ) const {
    return true;
}

inline bool APConfigRegister::operator != (const APConfigRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool APConfigRegister::operator < (const APConfigRegister& ) const {
    return false;
}

inline ::asf::core::Payload* APConfigRegister::clone() {
    return new APConfigRegister(*this);
}

inline bool APConfigRegister::operator > (const APConfigRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void APConfigRegister::clear() {
}

inline  RestrictionsUpdate::RestrictionsUpdate ()  :
    _Restrictions ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RestrictionsUpdate::RestrictionsUpdate (const RestrictionsUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Restrictions ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RestrictionsUpdate::RestrictionsUpdate (const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& Restrictions_)  :
    _Restrictions (Restrictions_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RestrictionsUpdate::~RestrictionsUpdate() {
}

inline RestrictionsUpdate& RestrictionsUpdate::operator = (const RestrictionsUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRestrictions()) {
            setRestrictions(rhs.getRestrictions());
        } else {
            clearRestrictions();
        }
    }
    return *this;
}

inline bool RestrictionsUpdate::operator == (const RestrictionsUpdate& rhs) const {
    return (((!hasRestrictions() && !rhs.hasRestrictions()) || getRestrictions() == rhs.getRestrictions()));
}

inline bool RestrictionsUpdate::operator != (const RestrictionsUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool RestrictionsUpdate::operator < (const RestrictionsUpdate& rhs) const {
    if (hasRestrictions() || rhs.hasRestrictions()) {
        if (getRestrictions() < rhs.getRestrictions()) return true;
        if (getRestrictions() > rhs.getRestrictions()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RestrictionsUpdate::clone() {
    return new RestrictionsUpdate(*this);
}

inline bool RestrictionsUpdate::operator > (const RestrictionsUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RestrictionsUpdate::clear() {
    clearRestrictions();
}

inline void RestrictionsUpdate::clearRestrictions() {
    if (hasRestrictions()) {
         clear_has_Restrictions();
        _Restrictions.clear();
     }
}

inline bool RestrictionsUpdate::hasRestrictions () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& RestrictionsUpdate::getRestrictions () const {
    return _Restrictions;
}

inline ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& RestrictionsUpdate::getRestrictionsMutable () {
    set_has_Restrictions();
    return _Restrictions;
}

inline void RestrictionsUpdate::setRestrictions (const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& Restrictions_) {
    set_has_Restrictions();
    this->_Restrictions = Restrictions_;
}

inline void RestrictionsUpdate::set_has_Restrictions () {
    _has_bits_[0] |= 1u << 0;
}

inline void RestrictionsUpdate::clear_has_Restrictions () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RestrictionsRegister::RestrictionsRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RestrictionsRegister::RestrictionsRegister (const RestrictionsRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RestrictionsRegister::~RestrictionsRegister() {
}

inline RestrictionsRegister& RestrictionsRegister::operator = (const RestrictionsRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool RestrictionsRegister::operator == (const RestrictionsRegister& ) const {
    return true;
}

inline bool RestrictionsRegister::operator != (const RestrictionsRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool RestrictionsRegister::operator < (const RestrictionsRegister& ) const {
    return false;
}

inline ::asf::core::Payload* RestrictionsRegister::clone() {
    return new RestrictionsRegister(*this);
}

inline bool RestrictionsRegister::operator > (const RestrictionsRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RestrictionsRegister::clear() {
}

inline  SupportedFrequenciesUpdate::SupportedFrequenciesUpdate ()  :
    _SupportedFrequencies ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SupportedFrequenciesUpdate::SupportedFrequenciesUpdate (const SupportedFrequenciesUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _SupportedFrequencies ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SupportedFrequenciesUpdate::SupportedFrequenciesUpdate (const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& SupportedFrequencies_)  :
    _SupportedFrequencies (SupportedFrequencies_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SupportedFrequenciesUpdate::~SupportedFrequenciesUpdate() {
}

inline SupportedFrequenciesUpdate& SupportedFrequenciesUpdate::operator = (const SupportedFrequenciesUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSupportedFrequencies()) {
            setSupportedFrequencies(rhs.getSupportedFrequencies());
        } else {
            clearSupportedFrequencies();
        }
    }
    return *this;
}

inline bool SupportedFrequenciesUpdate::operator == (const SupportedFrequenciesUpdate& rhs) const {
    return (((!hasSupportedFrequencies() && !rhs.hasSupportedFrequencies()) || getSupportedFrequencies() == rhs.getSupportedFrequencies()));
}

inline bool SupportedFrequenciesUpdate::operator != (const SupportedFrequenciesUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool SupportedFrequenciesUpdate::operator < (const SupportedFrequenciesUpdate& rhs) const {
    if (hasSupportedFrequencies() || rhs.hasSupportedFrequencies()) {
        if (getSupportedFrequencies() < rhs.getSupportedFrequencies()) return true;
        if (getSupportedFrequencies() > rhs.getSupportedFrequencies()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SupportedFrequenciesUpdate::clone() {
    return new SupportedFrequenciesUpdate(*this);
}

inline bool SupportedFrequenciesUpdate::operator > (const SupportedFrequenciesUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SupportedFrequenciesUpdate::clear() {
    clearSupportedFrequencies();
}

inline void SupportedFrequenciesUpdate::clearSupportedFrequencies() {
    if (hasSupportedFrequencies()) {
         clear_has_SupportedFrequencies();
        _SupportedFrequencies.clear();
     }
}

inline bool SupportedFrequenciesUpdate::hasSupportedFrequencies () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& SupportedFrequenciesUpdate::getSupportedFrequencies () const {
    return _SupportedFrequencies;
}

inline ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& SupportedFrequenciesUpdate::getSupportedFrequenciesMutable () {
    set_has_SupportedFrequencies();
    return _SupportedFrequencies;
}

inline void SupportedFrequenciesUpdate::setSupportedFrequencies (const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& SupportedFrequencies_) {
    set_has_SupportedFrequencies();
    this->_SupportedFrequencies = SupportedFrequencies_;
}

inline void SupportedFrequenciesUpdate::set_has_SupportedFrequencies () {
    _has_bits_[0] |= 1u << 0;
}

inline void SupportedFrequenciesUpdate::clear_has_SupportedFrequencies () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SupportedFrequenciesRegister::SupportedFrequenciesRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SupportedFrequenciesRegister::SupportedFrequenciesRegister (const SupportedFrequenciesRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SupportedFrequenciesRegister::~SupportedFrequenciesRegister() {
}

inline SupportedFrequenciesRegister& SupportedFrequenciesRegister::operator = (const SupportedFrequenciesRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool SupportedFrequenciesRegister::operator == (const SupportedFrequenciesRegister& ) const {
    return true;
}

inline bool SupportedFrequenciesRegister::operator != (const SupportedFrequenciesRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool SupportedFrequenciesRegister::operator < (const SupportedFrequenciesRegister& ) const {
    return false;
}

inline ::asf::core::Payload* SupportedFrequenciesRegister::clone() {
    return new SupportedFrequenciesRegister(*this);
}

inline bool SupportedFrequenciesRegister::operator > (const SupportedFrequenciesRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SupportedFrequenciesRegister::clear() {
}

inline  IPv4ConfigurationUpdate::IPv4ConfigurationUpdate ()  :
    _IPv4Configuration ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  IPv4ConfigurationUpdate::IPv4ConfigurationUpdate (const IPv4ConfigurationUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _IPv4Configuration ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  IPv4ConfigurationUpdate::IPv4ConfigurationUpdate (const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& IPv4Configuration_)  :
    _IPv4Configuration (IPv4Configuration_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  IPv4ConfigurationUpdate::~IPv4ConfigurationUpdate() {
}

inline IPv4ConfigurationUpdate& IPv4ConfigurationUpdate::operator = (const IPv4ConfigurationUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasIPv4Configuration()) {
            setIPv4Configuration(rhs.getIPv4Configuration());
        } else {
            clearIPv4Configuration();
        }
    }
    return *this;
}

inline bool IPv4ConfigurationUpdate::operator == (const IPv4ConfigurationUpdate& rhs) const {
    return (((!hasIPv4Configuration() && !rhs.hasIPv4Configuration()) || getIPv4Configuration() == rhs.getIPv4Configuration()));
}

inline bool IPv4ConfigurationUpdate::operator != (const IPv4ConfigurationUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool IPv4ConfigurationUpdate::operator < (const IPv4ConfigurationUpdate& rhs) const {
    if (hasIPv4Configuration() || rhs.hasIPv4Configuration()) {
        if (getIPv4Configuration() < rhs.getIPv4Configuration()) return true;
        if (getIPv4Configuration() > rhs.getIPv4Configuration()) return false;
    }
    return false;
}

inline ::asf::core::Payload* IPv4ConfigurationUpdate::clone() {
    return new IPv4ConfigurationUpdate(*this);
}

inline bool IPv4ConfigurationUpdate::operator > (const IPv4ConfigurationUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void IPv4ConfigurationUpdate::clear() {
    clearIPv4Configuration();
}

inline void IPv4ConfigurationUpdate::clearIPv4Configuration() {
    if (hasIPv4Configuration()) {
         clear_has_IPv4Configuration();
        _IPv4Configuration.clear();
     }
}

inline bool IPv4ConfigurationUpdate::hasIPv4Configuration () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& IPv4ConfigurationUpdate::getIPv4Configuration () const {
    return _IPv4Configuration;
}

inline ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& IPv4ConfigurationUpdate::getIPv4ConfigurationMutable () {
    set_has_IPv4Configuration();
    return _IPv4Configuration;
}

inline void IPv4ConfigurationUpdate::setIPv4Configuration (const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& IPv4Configuration_) {
    set_has_IPv4Configuration();
    this->_IPv4Configuration = IPv4Configuration_;
}

inline void IPv4ConfigurationUpdate::set_has_IPv4Configuration () {
    _has_bits_[0] |= 1u << 0;
}

inline void IPv4ConfigurationUpdate::clear_has_IPv4Configuration () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  IPv4ConfigurationRegister::IPv4ConfigurationRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  IPv4ConfigurationRegister::IPv4ConfigurationRegister (const IPv4ConfigurationRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  IPv4ConfigurationRegister::~IPv4ConfigurationRegister() {
}

inline IPv4ConfigurationRegister& IPv4ConfigurationRegister::operator = (const IPv4ConfigurationRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool IPv4ConfigurationRegister::operator == (const IPv4ConfigurationRegister& ) const {
    return true;
}

inline bool IPv4ConfigurationRegister::operator != (const IPv4ConfigurationRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool IPv4ConfigurationRegister::operator < (const IPv4ConfigurationRegister& ) const {
    return false;
}

inline ::asf::core::Payload* IPv4ConfigurationRegister::clone() {
    return new IPv4ConfigurationRegister(*this);
}

inline bool IPv4ConfigurationRegister::operator > (const IPv4ConfigurationRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void IPv4ConfigurationRegister::clear() {
}

inline  ConnectionStatusUpdate::ConnectionStatusUpdate ()  :
    _ConnectionStatus ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ConnectionStatusUpdate::ConnectionStatusUpdate (const ConnectionStatusUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _ConnectionStatus ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ConnectionStatusUpdate::ConnectionStatusUpdate (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& ConnectionStatus_)  :
    _ConnectionStatus (ConnectionStatus_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ConnectionStatusUpdate::~ConnectionStatusUpdate() {
}

inline ConnectionStatusUpdate& ConnectionStatusUpdate::operator = (const ConnectionStatusUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasConnectionStatus()) {
            setConnectionStatus(rhs.getConnectionStatus());
        } else {
            clearConnectionStatus();
        }
    }
    return *this;
}

inline bool ConnectionStatusUpdate::operator == (const ConnectionStatusUpdate& rhs) const {
    return (((!hasConnectionStatus() && !rhs.hasConnectionStatus()) || getConnectionStatus() == rhs.getConnectionStatus()));
}

inline bool ConnectionStatusUpdate::operator != (const ConnectionStatusUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool ConnectionStatusUpdate::operator < (const ConnectionStatusUpdate& rhs) const {
    if (hasConnectionStatus() || rhs.hasConnectionStatus()) {
        if (getConnectionStatus() < rhs.getConnectionStatus()) return true;
        if (getConnectionStatus() > rhs.getConnectionStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ConnectionStatusUpdate::clone() {
    return new ConnectionStatusUpdate(*this);
}

inline bool ConnectionStatusUpdate::operator > (const ConnectionStatusUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ConnectionStatusUpdate::clear() {
    clearConnectionStatus();
}

inline void ConnectionStatusUpdate::clearConnectionStatus() {
    if (hasConnectionStatus()) {
         clear_has_ConnectionStatus();
        _ConnectionStatus.clear();
     }
}

inline bool ConnectionStatusUpdate::hasConnectionStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& ConnectionStatusUpdate::getConnectionStatus () const {
    return _ConnectionStatus;
}

inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& ConnectionStatusUpdate::getConnectionStatusMutable () {
    set_has_ConnectionStatus();
    return _ConnectionStatus;
}

inline void ConnectionStatusUpdate::setConnectionStatus (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& ConnectionStatus_) {
    set_has_ConnectionStatus();
    this->_ConnectionStatus = ConnectionStatus_;
}

inline void ConnectionStatusUpdate::set_has_ConnectionStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void ConnectionStatusUpdate::clear_has_ConnectionStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ConnectionStatusRegister::ConnectionStatusRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ConnectionStatusRegister::ConnectionStatusRegister (const ConnectionStatusRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ConnectionStatusRegister::~ConnectionStatusRegister() {
}

inline ConnectionStatusRegister& ConnectionStatusRegister::operator = (const ConnectionStatusRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool ConnectionStatusRegister::operator == (const ConnectionStatusRegister& ) const {
    return true;
}

inline bool ConnectionStatusRegister::operator != (const ConnectionStatusRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool ConnectionStatusRegister::operator < (const ConnectionStatusRegister& ) const {
    return false;
}

inline ::asf::core::Payload* ConnectionStatusRegister::clone() {
    return new ConnectionStatusRegister(*this);
}

inline bool ConnectionStatusRegister::operator > (const ConnectionStatusRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ConnectionStatusRegister::clear() {
}

} // namespace wifisetup
} // namespace wbl
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_WBL_WIFISETUP_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
