/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/wbl/conflictmanagement.h"
#include "org/bosch/wbl/conflictmanagementDBus.h"
#include "org/bosch/wbl/conflictmanagementJson.h"
#include "org/bosch/wbl/conflictmanagementStub.h"
#include <map>
#include <string>
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bosch {
namespace wbl {
namespace conflictmanagement {

DEFINE_CLASS_LOGGER("//org/bosch/wbl/conflictmanagement/org/bosch/wbl/conflictmanagement", ConflictmanagementStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 12, "PrepareSetup", 0 },
    { 15, "DeActivateSetup", 1 },
    { 15, "ResolveConflict", 3 },
    { 20, "WiFiStationModeUsage", 2 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 16, "ActiveWiFiSetups", 0 },
    { 16, "WiFiPriorityList", 1 },
    { 18, "ConfigurationTimer", 2 },
};

class ConflictmanagementStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    ConflictmanagementStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    ConflictmanagementStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    ConflictmanagementStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.bosch.wbl.conflictmanagement"),
          _logger(logger) {}

    virtual ~ConflictmanagementStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void ConflictmanagementStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 4, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'PrepareSetup'

            LOG_DEBUG_STUB("process method '%s'", "PrepareSetup");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PrepareSetupRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "PrepareSetup", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< PrepareSetupRequest > payload = ::boost::static_pointer_cast<PrepareSetupRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ConflictmanagementStub*>(getStub())->onPrepareSetupRequest(payload);
            return;
        }
        case 1: {

            // method 'DeActivateSetup'

            LOG_DEBUG_STUB("process method '%s'", "DeActivateSetup");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DeActivateSetupRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "DeActivateSetup", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< DeActivateSetupRequest > payload = ::boost::static_pointer_cast<DeActivateSetupRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ConflictmanagementStub*>(getStub())->onDeActivateSetupRequest(payload);
            return;
        }
        case 2: {

            // method 'WiFiStationModeUsage'

            LOG_DEBUG_STUB("process method '%s'", "WiFiStationModeUsage");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), WiFiStationModeUsageRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "WiFiStationModeUsage", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< WiFiStationModeUsageRequest > payload = ::boost::static_pointer_cast<WiFiStationModeUsageRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ConflictmanagementStub*>(getStub())->onWiFiStationModeUsageRequest(payload);
            return;
        }
        case 3: {

            // method 'ResolveConflict'

            LOG_DEBUG_STUB("process method '%s'", "ResolveConflict");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ResolveConflictRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ResolveConflict", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ResolveConflictRequest > payload = ::boost::static_pointer_cast<ResolveConflictRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ConflictmanagementStub*>(getStub())->onResolveConflictRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* ConflictmanagementStubDelegate::introspect() const {
    return     "<interface name=\"org.bosch.wbl.conflictmanagement\">\n"
            "      <method name=\"PrepareSetup\">\n"
            "        <arg direction=\"in\" name=\"configuration\" type=\"a{sv}\"/>\n"
            "      </method>\n"
            "      <method name=\"DeActivateSetup\">\n"
            "        <arg direction=\"in\" name=\"WiFiMode\" type=\"s\"/>\n"
            "      </method>\n"
            "      <method name=\"WiFiStationModeUsage\">\n"
            "        <arg direction=\"in\" name=\"application\" type=\"s\"/>\n"
            "        <arg direction=\"in\" name=\"usage\" type=\"s\"/>\n"
            "        <arg direction=\"in\" name=\"holding\" type=\"b\"/>\n"
            "      </method>\n"
            "      <method name=\"ResolveConflict\">\n"
            "        <arg direction=\"in\" name=\"conflictid\" type=\"i\"/>\n"
            "        <arg direction=\"in\" name=\"action\" type=\"i\"/>\n"
            "      </method>\n"
            "      <signal name=\"ConflictDetected\">\n"
            "        <arg name=\"conflictdetected\" type=\"a{sv}\"/>\n"
            "      </signal>\n"
            "      <signal name=\"ConflictResolved\">\n"
            "        <arg name=\"conflictresolved\" type=\"a{sv}\"/>\n"
            "      </signal>\n"
            "      <property access=\"read\" name=\"ActiveWiFiSetups\" type=\"a(oa{sv})\"/>\n"
            "      <property access=\"readwrite\" name=\"WiFiPriorityList\" type=\"as\"/>\n"
            "      <property access=\"readwrite\" name=\"ConfigurationTimer\" type=\"i\"/>\n"
            "</interface>\n";
}

void ConflictmanagementStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<ConflictmanagementStub*>(getStub()))->onGetAll (properties);
}

void ConflictmanagementStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 3, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "ActiveWiFiSetups");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "WiFiPriorityList");
            ::boost::shared_ptr< WiFiPriorityListSet > payload(new WiFiPriorityListSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<ConflictmanagementStub*>(getStub())->onWiFiPriorityListSet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "ConfigurationTimer");
            ::boost::shared_ptr< ConfigurationTimerSet > payload(new ConfigurationTimerSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<ConflictmanagementStub*>(getStub())->onConfigurationTimerSet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void ConflictmanagementStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 3, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "ActiveWiFiSetups");
            ::boost::shared_ptr< ActiveWiFiSetupsGet > payload(new ActiveWiFiSetupsGet());
            payload->setAct(act);
            static_cast<ConflictmanagementStub*>(getStub())->onActiveWiFiSetupsGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "WiFiPriorityList");
            ::boost::shared_ptr< WiFiPriorityListGet > payload(new WiFiPriorityListGet());
            payload->setAct(act);
            static_cast<ConflictmanagementStub*>(getStub())->onWiFiPriorityListGet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "ConfigurationTimer");
            ::boost::shared_ptr< ConfigurationTimerGet > payload(new ConfigurationTimerGet());
            payload->setAct(act);
            static_cast<ConflictmanagementStub*>(getStub())->onConfigurationTimerGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

ConflictmanagementStub::ConflictmanagementStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new ConflictmanagementStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

ConflictmanagementStub::ConflictmanagementStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new ConflictmanagementStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

ConflictmanagementStub::~ConflictmanagementStub() {
    delete _stubDelegate;
}

void ConflictmanagementStub::sendConflictDetectedSignal(const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& conflictdetected) {
    if (_stubDelegate->isConnected()) {
        ConflictDetectedSignal* payload = new ConflictDetectedSignal(conflictdetected);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "ConflictDetected", ConflictDetectedSignal, payload)
        LOG_INFO ("-> send%sSignal", "ConflictDetected");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "ConflictDetected");
    }
}

void ConflictmanagementStub::sendConflictResolvedSignal(const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& conflictresolved) {
    if (_stubDelegate->isConnected()) {
        ConflictResolvedSignal* payload = new ConflictResolvedSignal(conflictresolved);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "ConflictResolved", ConflictResolvedSignal, payload)
        LOG_INFO ("-> send%sSignal", "ConflictResolved");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "ConflictResolved");
    }
}

void ConflictmanagementStub::sendActiveWiFiSetupsUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ActiveWiFiSetupsUpdate payload(_ActiveWiFiSetupsProperty);

        LOG_INFO ("-> send%s", "ActiveWiFiSetupsUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ActiveWiFiSetups", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.wbl.conflictmanagement", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ActiveWiFiSetupsUpdate");
    }
}

void ConflictmanagementStub::onActiveWiFiSetupsGet(const ::boost::shared_ptr< ActiveWiFiSetupsGet >& activeWiFiSetups) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ActiveWiFiSetupsGet", activeWiFiSetups->getAct());
    sendActiveWiFiSetupsGetUpdate(_ActiveWiFiSetupsProperty.getActiveWiFiSetups(), activeWiFiSetups->getAct());
}

void ConflictmanagementStub::sendActiveWiFiSetupsGetUpdate(const ::std::vector< ActiveWiFiSetupsStruct >& activeWiFiSetups, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ActiveWiFiSetupsGet payload(activeWiFiSetups);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ActiveWiFiSetupsGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ConflictmanagementStub::setActiveWiFiSetups(const ::std::vector< ActiveWiFiSetupsStruct >& activeWiFiSetups) {
    if(activeWiFiSetups!=_ActiveWiFiSetupsProperty.getActiveWiFiSetups()) {
        _ActiveWiFiSetupsProperty.setActiveWiFiSetups(activeWiFiSetups);
        sendActiveWiFiSetupsUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ActiveWiFiSetupsStruct >& ConflictmanagementStub::getActiveWiFiSetups() const {
    return _ActiveWiFiSetupsProperty.getActiveWiFiSetups();
}

::std::vector< ActiveWiFiSetupsStruct >& ConflictmanagementStub::getActiveWiFiSetupsMutable() {
    return _ActiveWiFiSetupsProperty.getActiveWiFiSetupsMutable();
}

void ConflictmanagementStub::sendWiFiPriorityListUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        WiFiPriorityListUpdate payload(_WiFiPriorityListProperty);

        LOG_INFO ("-> send%s", "WiFiPriorityListUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("WiFiPriorityList", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.wbl.conflictmanagement", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "WiFiPriorityListUpdate");
    }
}

void ConflictmanagementStub::onWiFiPriorityListGet(const ::boost::shared_ptr< WiFiPriorityListGet >& wiFiPriorityList) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "WiFiPriorityListGet", wiFiPriorityList->getAct());
    sendWiFiPriorityListGetUpdate(_WiFiPriorityListProperty.getWiFiPriorityList(), wiFiPriorityList->getAct());
}

void ConflictmanagementStub::sendWiFiPriorityListGetUpdate(const ::std::vector< ::std::string >& wiFiPriorityList, act_t act) {
    ::asf::dbus::DBusVariant variant;
    WiFiPriorityListGet payload(wiFiPriorityList);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "WiFiPriorityListGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ConflictmanagementStub::onWiFiPriorityListSet(const ::boost::shared_ptr< WiFiPriorityListSet >& wiFiPriorityList) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "WiFiPriorityListSet", wiFiPriorityList->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*wiFiPriorityList, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setWiFiPriorityList (wiFiPriorityList->getWiFiPriorityList());
    sendWiFiPriorityListSetUpdate(wiFiPriorityList->getAct());
}

void ConflictmanagementStub::sendWiFiPriorityListSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "WiFiPriorityListSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void ConflictmanagementStub::setWiFiPriorityList(const ::std::vector< ::std::string >& wiFiPriorityList) {
    if(wiFiPriorityList!=_WiFiPriorityListProperty.getWiFiPriorityList()) {
        _WiFiPriorityListProperty.setWiFiPriorityList(wiFiPriorityList);
        sendWiFiPriorityListUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::string >& ConflictmanagementStub::getWiFiPriorityList() const {
    return _WiFiPriorityListProperty.getWiFiPriorityList();
}

::std::vector< ::std::string >& ConflictmanagementStub::getWiFiPriorityListMutable() {
    return _WiFiPriorityListProperty.getWiFiPriorityListMutable();
}

void ConflictmanagementStub::sendConfigurationTimerUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ConfigurationTimerUpdate payload(_ConfigurationTimerProperty);

        LOG_INFO ("-> send%s", "ConfigurationTimerUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ConfigurationTimer", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.wbl.conflictmanagement", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ConfigurationTimerUpdate");
    }
}

void ConflictmanagementStub::onConfigurationTimerGet(const ::boost::shared_ptr< ConfigurationTimerGet >& configurationTimer) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ConfigurationTimerGet", configurationTimer->getAct());
    sendConfigurationTimerGetUpdate(_ConfigurationTimerProperty.getConfigurationTimer(), configurationTimer->getAct());
}

void ConflictmanagementStub::sendConfigurationTimerGetUpdate(int32 configurationTimer, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ConfigurationTimerGet payload(configurationTimer);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ConfigurationTimerGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ConflictmanagementStub::onConfigurationTimerSet(const ::boost::shared_ptr< ConfigurationTimerSet >& configurationTimer) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ConfigurationTimerSet", configurationTimer->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*configurationTimer, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setConfigurationTimer (configurationTimer->getConfigurationTimer());
    sendConfigurationTimerSetUpdate(configurationTimer->getAct());
}

void ConflictmanagementStub::sendConfigurationTimerSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ConfigurationTimerSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void ConflictmanagementStub::setConfigurationTimer(int32 configurationTimer) {
    if(configurationTimer!=_ConfigurationTimerProperty.getConfigurationTimer()) {
        _ConfigurationTimerProperty.setConfigurationTimer(configurationTimer);
        sendConfigurationTimerUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

int32 ConflictmanagementStub::getConfigurationTimer() const {
    return _ConfigurationTimerProperty.getConfigurationTimer();
}

void  ConflictmanagementStub::sendPrepareSetupResponse (act_t act) {
    PrepareSetupResponse* payload = new PrepareSetupResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "PrepareSetup", PrepareSetupResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "PrepareSetup", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ConflictmanagementStub::sendPrepareSetupError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    PrepareSetupError* payload = new PrepareSetupError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "PrepareSetup", PrepareSetupError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "PrepareSetup", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ConflictmanagementStub::sendDeActivateSetupResponse (act_t act) {
    DeActivateSetupResponse* payload = new DeActivateSetupResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "DeActivateSetup", DeActivateSetupResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "DeActivateSetup", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ConflictmanagementStub::sendDeActivateSetupError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    DeActivateSetupError* payload = new DeActivateSetupError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "DeActivateSetup", DeActivateSetupError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "DeActivateSetup", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ConflictmanagementStub::sendWiFiStationModeUsageResponse (act_t act) {
    WiFiStationModeUsageResponse* payload = new WiFiStationModeUsageResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "WiFiStationModeUsage", WiFiStationModeUsageResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "WiFiStationModeUsage", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ConflictmanagementStub::sendWiFiStationModeUsageError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    WiFiStationModeUsageError* payload = new WiFiStationModeUsageError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "WiFiStationModeUsage", WiFiStationModeUsageError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "WiFiStationModeUsage", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ConflictmanagementStub::sendResolveConflictResponse (act_t act) {
    ResolveConflictResponse* payload = new ResolveConflictResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "ResolveConflict", ResolveConflictResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ResolveConflict", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ConflictmanagementStub::sendResolveConflictError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ResolveConflictError* payload = new ResolveConflictError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ResolveConflict", ResolveConflictError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ResolveConflict", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void ConflictmanagementStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'ActiveWiFiSetups'
    {
        ::asf::dbus::DBusVariant variant;
        ActiveWiFiSetupsGet payload(_ActiveWiFiSetupsProperty.getActiveWiFiSetups());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ActiveWiFiSetups", variant));
    }

    //property 'WiFiPriorityList'
    {
        ::asf::dbus::DBusVariant variant;
        WiFiPriorityListGet payload(_WiFiPriorityListProperty.getWiFiPriorityList());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("WiFiPriorityList", variant));
    }

    //property 'ConfigurationTimer'
    {
        ::asf::dbus::DBusVariant variant;
        ConfigurationTimerGet payload(_ConfigurationTimerProperty.getConfigurationTimer());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ConfigurationTimer", variant));
    }
}

} // namespace conflictmanagement
} // namespace wbl
} // namespace bosch
} // namespace org
