/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/dbus/DBusAssert.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DBusVariantDBus.h"
#include "org/bosch/wbl/conflictmanagement.h"
#include "org/bosch/wbl/conflictmanagementDBus.h"
#include <dbus/dbus.h>
#include <map>
#include <string>
#include <vector>

static ::asf::core::Logger& _logger =  ::asf::core::Logger::_systemLogger;


// D-Bus serialize and deserialize functions of PrepareSetupRequest

void serializeDBus (const ::org::bosch::wbl::conflictmanagement::PrepareSetupRequest& in, DBusMessageIter* out) {
    DBusMessageIter o0ArrayIter;
    DBusMessageIter o1DictIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "{sv}", &o0ArrayIter));
    const ::std::map< ::std::string, ::asf::dbus::DBusVariant >* o2 = &in.getConfiguration();
    ::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o3 = o2->end();
    for (::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o4 = o2->begin(); o4 != o3; ++o4) {
        DBUS_ASSERT(dbus_message_iter_open_container(&o0ArrayIter, DBUS_TYPE_DICT_ENTRY, 0, &o1DictIter));
        const char* o5 = o4->first.c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o1DictIter, DBUS_TYPE_STRING, &o5));
        serializeDBus(o4->second, &o1DictIter);
        DBUS_ASSERT(dbus_message_iter_close_container(&o0ArrayIter, &o1DictIter)); // close dict container
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o0ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wbl::conflictmanagement::PrepareSetupRequest& out) {
    {
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > configurationValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o6ArrayIter;
            DBusMessageIter o7DictIter;
            dbus_message_iter_recurse (in, &o6ArrayIter);

            if (dbus_message_iter_get_arg_type(&o6ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o8Key;
                    ::asf::dbus::DBusVariant o8Value;
                    dbus_message_iter_recurse (&o6ArrayIter, &o7DictIter);
                    {
                        char* o9 = 0;
                        dbus_message_iter_get_basic(&o7DictIter, &o9);
                        o8Key.assign (o9);
                    }
                    dbus_message_iter_next(&o7DictIter);
                    {
                        DBusMessageIter o10;
                        char* signature = dbus_message_iter_get_signature(&o7DictIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o7DictIter)) {
                                dbus_message_iter_recurse (&o7DictIter, &o10);

                                if (!deserializeDBus(&o10, o8Value)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    configurationValue.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant >(o8Key, o8Value));
                } while (dbus_message_iter_next(&o6ArrayIter));
            }
        }
        out.setConfiguration(configurationValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DeActivateSetupRequest

void serializeDBus (const ::org::bosch::wbl::conflictmanagement::DeActivateSetupRequest& in, DBusMessageIter* out) {
    const char* o11 = in.getWiFiMode().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o11));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wbl::conflictmanagement::DeActivateSetupRequest& out) {
    {
        ::std::string WiFiModeValue;
        ::std::string &WiFiModeTmpValue = WiFiModeValue;
        {
            char* o12 = 0;
            dbus_message_iter_get_basic(in, &o12);
            WiFiModeTmpValue.assign (o12);
        }
        out.setWiFiMode(WiFiModeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of WiFiStationModeUsageRequest

void serializeDBus (const ::org::bosch::wbl::conflictmanagement::WiFiStationModeUsageRequest& in, DBusMessageIter* out) {
    const char* o13 = in.getApplication().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o13));
    const char* o14 = in.getUsage().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o14));
    dbus_bool_t o15 = in.getHolding() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o15));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wbl::conflictmanagement::WiFiStationModeUsageRequest& out) {
    {
        ::std::string applicationValue;
        ::std::string &applicationTmpValue = applicationValue;
        {
            char* o16 = 0;
            dbus_message_iter_get_basic(in, &o16);
            applicationTmpValue.assign (o16);
        }
        out.setApplication(applicationValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string usageValue;
        ::std::string &usageTmpValue = usageValue;
        {
            char* o17 = 0;
            dbus_message_iter_get_basic(in, &o17);
            usageTmpValue.assign (o17);
        }
        out.setUsage(usageValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        bool holdingValue;
        bool &holdingTmpValue = holdingValue;
        {
            dbus_bool_t o18;
            dbus_message_iter_get_basic(in, &o18);
            holdingTmpValue = o18 ? true : false;
        }
        out.setHolding(holdingValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ResolveConflictRequest

void serializeDBus (const ::org::bosch::wbl::conflictmanagement::ResolveConflictRequest& in, DBusMessageIter* out) {
    int32 o19 = in.getConflictid();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o19));
    int32 o20 = in.getAction();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o20));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wbl::conflictmanagement::ResolveConflictRequest& out) {
    {
        int32 conflictidValue;
        int32 &conflictidTmpValue = conflictidValue;
        dbus_message_iter_get_basic(in, &conflictidTmpValue);
        out.setConflictid(conflictidValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int32 actionValue;
        int32 &actionTmpValue = actionValue;
        dbus_message_iter_get_basic(in, &actionTmpValue);
        out.setAction(actionValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ActiveWiFiSetupsUpdate

void serializeDBus (const ::org::bosch::wbl::conflictmanagement::ActiveWiFiSetupsUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o21ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(oa{sv})", &o21ArrayIter));
    const ::std::vector< ::org::bosch::wbl::conflictmanagement::ActiveWiFiSetupsStruct >* o22 = &in.getActiveWiFiSetups();
    ::std::vector< ::org::bosch::wbl::conflictmanagement::ActiveWiFiSetupsStruct >::const_iterator o23 = o22->end();
    for (::std::vector< ::org::bosch::wbl::conflictmanagement::ActiveWiFiSetupsStruct >::const_iterator o24 = o22->begin(); o24 != o23; ++o24) {
        {
            DBusMessageIter o25Struct;
            DBUS_ASSERT(dbus_message_iter_open_container(&o21ArrayIter, DBUS_TYPE_STRUCT, 0, &o25Struct));
            serializeDBus((*o24), &o25Struct);
            DBUS_ASSERT(dbus_message_iter_close_container(&o21ArrayIter, &o25Struct));
        }
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o21ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wbl::conflictmanagement::ActiveWiFiSetupsUpdate& out) {
    {
        ::std::vector< ::org::bosch::wbl::conflictmanagement::ActiveWiFiSetupsStruct > ActiveWiFiSetupsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o26ArrayIter;
            dbus_message_iter_recurse (in, &o26ArrayIter);

            if(dbus_message_iter_get_arg_type(&o26ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::bosch::wbl::conflictmanagement::ActiveWiFiSetupsStruct o27;
                    {
                        DBusMessageIter o28;
                        char* signature = dbus_message_iter_get_signature(&o26ArrayIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o26ArrayIter)) {
                                dbus_message_iter_recurse (&o26ArrayIter, &o28);

                                if (!deserializeDBus(&o28, o27)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    ActiveWiFiSetupsValue.push_back(o27);
                } while (dbus_message_iter_next(&o26ArrayIter));
            }
        }
        out.setActiveWiFiSetups(ActiveWiFiSetupsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ActiveWiFiSetupsRegister

void serializeDBus (const ::org::bosch::wbl::conflictmanagement::ActiveWiFiSetupsRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::wbl::conflictmanagement::ActiveWiFiSetupsRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of WiFiPriorityListUpdate

void serializeDBus (const ::org::bosch::wbl::conflictmanagement::WiFiPriorityListUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o29ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o29ArrayIter));
    const ::std::vector< ::std::string >* o30 = &in.getWiFiPriorityList();
    ::std::vector< ::std::string >::const_iterator o31 = o30->end();
    for (::std::vector< ::std::string >::const_iterator o32 = o30->begin(); o32 != o31; ++o32) {
        const char* o33 = (*o32).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o29ArrayIter, DBUS_TYPE_STRING, &o33));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o29ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wbl::conflictmanagement::WiFiPriorityListUpdate& out) {
    {
        ::std::vector< ::std::string > WiFiPriorityListValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o34ArrayIter;
            dbus_message_iter_recurse (in, &o34ArrayIter);

            if(dbus_message_iter_get_arg_type(&o34ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o35;
                    {
                        char* o36 = 0;
                        dbus_message_iter_get_basic(&o34ArrayIter, &o36);
                        o35.assign (o36);
                    }
                    WiFiPriorityListValue.push_back(o35);
                } while (dbus_message_iter_next(&o34ArrayIter));
            }
        }
        out.setWiFiPriorityList(WiFiPriorityListValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of WiFiPriorityListRegister

void serializeDBus (const ::org::bosch::wbl::conflictmanagement::WiFiPriorityListRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::wbl::conflictmanagement::WiFiPriorityListRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ConfigurationTimerUpdate

void serializeDBus (const ::org::bosch::wbl::conflictmanagement::ConfigurationTimerUpdate& in, DBusMessageIter* out) {
    int32 o37 = in.getConfigurationTimer();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o37));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wbl::conflictmanagement::ConfigurationTimerUpdate& out) {
    {
        int32 ConfigurationTimerValue;
        int32 &ConfigurationTimerTmpValue = ConfigurationTimerValue;
        dbus_message_iter_get_basic(in, &ConfigurationTimerTmpValue);
        out.setConfigurationTimer(ConfigurationTimerValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ConfigurationTimerRegister

void serializeDBus (const ::org::bosch::wbl::conflictmanagement::ConfigurationTimerRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::wbl::conflictmanagement::ConfigurationTimerRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ConflictDetectedSignal

void serializeDBus (const ::org::bosch::wbl::conflictmanagement::ConflictDetectedSignal& in, DBusMessageIter* out) {
    DBusMessageIter o38ArrayIter;
    DBusMessageIter o39DictIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "{sv}", &o38ArrayIter));
    const ::std::map< ::std::string, ::asf::dbus::DBusVariant >* o40 = &in.getConflictdetected();
    ::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o41 = o40->end();
    for (::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o42 = o40->begin(); o42 != o41; ++o42) {
        DBUS_ASSERT(dbus_message_iter_open_container(&o38ArrayIter, DBUS_TYPE_DICT_ENTRY, 0, &o39DictIter));
        const char* o43 = o42->first.c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o39DictIter, DBUS_TYPE_STRING, &o43));
        serializeDBus(o42->second, &o39DictIter);
        DBUS_ASSERT(dbus_message_iter_close_container(&o38ArrayIter, &o39DictIter)); // close dict container
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o38ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wbl::conflictmanagement::ConflictDetectedSignal& out) {
    {
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > conflictdetectedValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o44ArrayIter;
            DBusMessageIter o45DictIter;
            dbus_message_iter_recurse (in, &o44ArrayIter);

            if (dbus_message_iter_get_arg_type(&o44ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o46Key;
                    ::asf::dbus::DBusVariant o46Value;
                    dbus_message_iter_recurse (&o44ArrayIter, &o45DictIter);
                    {
                        char* o47 = 0;
                        dbus_message_iter_get_basic(&o45DictIter, &o47);
                        o46Key.assign (o47);
                    }
                    dbus_message_iter_next(&o45DictIter);
                    {
                        DBusMessageIter o48;
                        char* signature = dbus_message_iter_get_signature(&o45DictIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o45DictIter)) {
                                dbus_message_iter_recurse (&o45DictIter, &o48);

                                if (!deserializeDBus(&o48, o46Value)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    conflictdetectedValue.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant >(o46Key, o46Value));
                } while (dbus_message_iter_next(&o44ArrayIter));
            }
        }
        out.setConflictdetected(conflictdetectedValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ConflictResolvedSignal

void serializeDBus (const ::org::bosch::wbl::conflictmanagement::ConflictResolvedSignal& in, DBusMessageIter* out) {
    DBusMessageIter o49ArrayIter;
    DBusMessageIter o50DictIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "{sv}", &o49ArrayIter));
    const ::std::map< ::std::string, ::asf::dbus::DBusVariant >* o51 = &in.getConflictresolved();
    ::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o52 = o51->end();
    for (::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o53 = o51->begin(); o53 != o52; ++o53) {
        DBUS_ASSERT(dbus_message_iter_open_container(&o49ArrayIter, DBUS_TYPE_DICT_ENTRY, 0, &o50DictIter));
        const char* o54 = o53->first.c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o50DictIter, DBUS_TYPE_STRING, &o54));
        serializeDBus(o53->second, &o50DictIter);
        DBUS_ASSERT(dbus_message_iter_close_container(&o49ArrayIter, &o50DictIter)); // close dict container
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o49ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wbl::conflictmanagement::ConflictResolvedSignal& out) {
    {
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > conflictresolvedValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o55ArrayIter;
            DBusMessageIter o56DictIter;
            dbus_message_iter_recurse (in, &o55ArrayIter);

            if (dbus_message_iter_get_arg_type(&o55ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o57Key;
                    ::asf::dbus::DBusVariant o57Value;
                    dbus_message_iter_recurse (&o55ArrayIter, &o56DictIter);
                    {
                        char* o58 = 0;
                        dbus_message_iter_get_basic(&o56DictIter, &o58);
                        o57Key.assign (o58);
                    }
                    dbus_message_iter_next(&o56DictIter);
                    {
                        DBusMessageIter o59;
                        char* signature = dbus_message_iter_get_signature(&o56DictIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o56DictIter)) {
                                dbus_message_iter_recurse (&o56DictIter, &o59);

                                if (!deserializeDBus(&o59, o57Value)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    conflictresolvedValue.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant >(o57Key, o57Value));
                } while (dbus_message_iter_next(&o55ArrayIter));
            }
        }
        out.setConflictresolved(conflictresolvedValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ActiveWiFiSetupsStruct

void serializeDBus (const ::org::bosch::wbl::conflictmanagement::ActiveWiFiSetupsStruct& in, DBusMessageIter* out) {
    DBUS_ASSERT(::asf::dbus::DBusUtils::isObjectPathValid(std::string(in.getElem1())));
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_OBJECT_PATH, &in.getElem1()));
    DBusMessageIter o60ArrayIter;
    DBusMessageIter o61DictIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "{sv}", &o60ArrayIter));
    const ::std::map< ::std::string, ::asf::dbus::DBusVariant >* o62 = &in.getElem2();
    ::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o63 = o62->end();
    for (::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o64 = o62->begin(); o64 != o63; ++o64) {
        DBUS_ASSERT(dbus_message_iter_open_container(&o60ArrayIter, DBUS_TYPE_DICT_ENTRY, 0, &o61DictIter));
        const char* o65 = o64->first.c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o61DictIter, DBUS_TYPE_STRING, &o65));
        serializeDBus(o64->second, &o61DictIter);
        DBUS_ASSERT(dbus_message_iter_close_container(&o60ArrayIter, &o61DictIter)); // close dict container
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o60ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::wbl::conflictmanagement::ActiveWiFiSetupsStruct& out) {
    {
        ::std::string elem1Value;
        ::std::string &elem1TmpValue = elem1Value;
        {
            char* o66 = 0;
            dbus_message_iter_get_basic(in, &o66);
            elem1TmpValue.assign (o66);
        }
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > elem2Value;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o67ArrayIter;
            DBusMessageIter o68DictIter;
            dbus_message_iter_recurse (in, &o67ArrayIter);

            if (dbus_message_iter_get_arg_type(&o67ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o69Key;
                    ::asf::dbus::DBusVariant o69Value;
                    dbus_message_iter_recurse (&o67ArrayIter, &o68DictIter);
                    {
                        char* o70 = 0;
                        dbus_message_iter_get_basic(&o68DictIter, &o70);
                        o69Key.assign (o70);
                    }
                    dbus_message_iter_next(&o68DictIter);
                    {
                        DBusMessageIter o71;
                        char* signature = dbus_message_iter_get_signature(&o68DictIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o68DictIter)) {
                                dbus_message_iter_recurse (&o68DictIter, &o71);

                                if (!deserializeDBus(&o71, o69Value)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    elem2Value.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant >(o69Key, o69Value));
                } while (dbus_message_iter_next(&o67ArrayIter));
            }
        }
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

