#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_WBL_CONFLICTMANAGEMENT_H
#define ORG_BOSCH_WBL_CONFLICTMANAGEMENT_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "asf/dbus/DBusVariant.h"
#include <cstddef>
#include <cstring>
#include <map>
#include <string>
#include <vector>

/**
 * If the meaning of "conflictmanagement" isn't clear, then there should be a description here.
 */

namespace org {
namespace bosch {
namespace wbl {
namespace conflictmanagement {

// method IDs
static const uint16 ID_PrepareSetup = 0;
static const uint16 ID_DeActivateSetup = 1;
static const uint16 ID_WiFiStationModeUsage = 2;
static const uint16 ID_ResolveConflict = 3;

// signal IDs
static const uint16 ID_ConflictDetected = 4;
static const uint16 ID_ConflictResolved = 5;

// property IDs
static const uint16 ID_ActiveWiFiSetups = 6;
static const uint16 ID_WiFiPriorityList = 7;
static const uint16 ID_ConfigurationTimer = 8;

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class PrepareSetupRequest;

class DeActivateSetupRequest;

class WiFiStationModeUsageRequest;

class ResolveConflictRequest;

class ActiveWiFiSetupsStruct;

class ActiveWiFiSetupsUpdate;

class ActiveWiFiSetupsRegister;

class WiFiPriorityListUpdate;

class WiFiPriorityListRegister;

class ConfigurationTimerUpdate;

class ConfigurationTimerRegister;

class ConflictDetectedSignal;

class ConflictResolvedSignal;

// type definitions
/**
 * If the meaning of "PrepareSetupResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage PrepareSetupResponse;

/**
 * If the meaning of "PrepareSetupError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PrepareSetupError;

/**
 * If the meaning of "DeActivateSetupResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage DeActivateSetupResponse;

/**
 * If the meaning of "DeActivateSetupError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DeActivateSetupError;

/**
 * If the meaning of "WiFiStationModeUsageResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage WiFiStationModeUsageResponse;

/**
 * If the meaning of "WiFiStationModeUsageError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError WiFiStationModeUsageError;

/**
 * If the meaning of "ResolveConflictResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ResolveConflictResponse;

/**
 * If the meaning of "ResolveConflictError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ResolveConflictError;

/**
 * If the meaning of "ActiveWiFiSetupsSet" isn't clear, then there should be a description here.
 */
typedef ActiveWiFiSetupsUpdate ActiveWiFiSetupsSet;

/**
 * If the meaning of "ActiveWiFiSetupsGet" isn't clear, then there should be a description here.
 */
typedef ActiveWiFiSetupsUpdate ActiveWiFiSetupsGet;

/**
 * If the meaning of "ActiveWiFiSetupsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ActiveWiFiSetupsError;

/**
 * If the meaning of "WiFiPriorityListSet" isn't clear, then there should be a description here.
 */
typedef WiFiPriorityListUpdate WiFiPriorityListSet;

/**
 * If the meaning of "WiFiPriorityListGet" isn't clear, then there should be a description here.
 */
typedef WiFiPriorityListUpdate WiFiPriorityListGet;

/**
 * If the meaning of "WiFiPriorityListError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError WiFiPriorityListError;

/**
 * If the meaning of "ConfigurationTimerSet" isn't clear, then there should be a description here.
 */
typedef ConfigurationTimerUpdate ConfigurationTimerSet;

/**
 * If the meaning of "ConfigurationTimerGet" isn't clear, then there should be a description here.
 */
typedef ConfigurationTimerUpdate ConfigurationTimerGet;

/**
 * If the meaning of "ConfigurationTimerError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ConfigurationTimerError;

/**
 * If the meaning of "ConflictDetectedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ConflictDetectedError;

/**
 * If the meaning of "ConflictResolvedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ConflictResolvedError;


/**
 * If the meaning of "PrepareSetupRequest" isn't clear, then there should be a description here.
 */
class PrepareSetupRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PrepareSetupRequest ();

    /**
     * Copy constructor
     */
    inline  PrepareSetupRequest (const PrepareSetupRequest &rhs);

    /**
     * All fields constructor
     */
    inline  PrepareSetupRequest (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& configuration_);

    /**
     * Destructor
     */
    inline virtual  ~PrepareSetupRequest();

    /**
     * Assignment operator
     */
    inline PrepareSetupRequest& operator = (const PrepareSetupRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PrepareSetupRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PrepareSetupRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PrepareSetupRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PrepareSetupRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "configuration"

    static const int kConfiguration = 0;

    /**
     * Clears the field "configuration".
     *
     * The field will be set to its default value. The hasConfiguration()
     * method will return false.
     */
    inline void clearConfiguration();

    /**
     * Checks whether the field "configuration" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConfiguration()). Otherwise it will return false.
     */
    inline bool hasConfiguration () const;

    /**
     * Returns the value of the member "configuration".
     *
     * If the meaning of "configuration" isn't clear, then there should be a description here.
     *
     * @return The value of the field "configuration"
     */
    inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getConfiguration () const;

    /**
     * Retrieves the value of the field "configuration" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "configuration".
     */
    inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getConfigurationMutable ();

    /**
     * Sets the value of the member "configuration".
     *
     * If the meaning of "configuration" isn't clear, then there should be a description here.
     *
     * @param configuration The value which will be set
     */
    inline void setConfiguration (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& configuration_);

    static const PrepareSetupRequest &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStringTo__asf__dbus__DBusVariantMap_DefaultInstance ();

    inline void set_has_configuration ();

    inline void clear_has_configuration ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::map< ::std::string, ::asf::dbus::DBusVariant > _configuration;

};

/**
 * If the meaning of "DeActivateSetupRequest" isn't clear, then there should be a description here.
 */
class DeActivateSetupRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeActivateSetupRequest ();

    /**
     * Copy constructor
     */
    inline  DeActivateSetupRequest (const DeActivateSetupRequest &rhs);

    /**
     * All fields constructor
     */
    inline  DeActivateSetupRequest (const ::std::string& WiFiMode_);

    /**
     * Destructor
     */
    inline virtual  ~DeActivateSetupRequest();

    /**
     * Assignment operator
     */
    inline DeActivateSetupRequest& operator = (const DeActivateSetupRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeActivateSetupRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeActivateSetupRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeActivateSetupRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeActivateSetupRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "WiFiMode"

    static const int kWiFiMode = 0;

    /**
     * Clears the field "WiFiMode".
     *
     * The field will be set to its default value. The hasWiFiMode()
     * method will return false.
     */
    inline void clearWiFiMode();

    /**
     * Checks whether the field "WiFiMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWiFiMode()). Otherwise it will return false.
     */
    inline bool hasWiFiMode () const;

    /**
     * Returns the value of the member "WiFiMode".
     *
     * If the meaning of "WiFiMode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "WiFiMode"
     */
    inline const ::std::string& getWiFiMode () const;

    /**
     * Retrieves the value of the field "WiFiMode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "WiFiMode".
     */
    inline ::std::string& getWiFiModeMutable ();

    /**
     * Sets the value of the member "WiFiMode".
     *
     * If the meaning of "WiFiMode" isn't clear, then there should be a description here.
     *
     * @param WiFiMode The value which will be set
     */
    inline void setWiFiMode (const ::std::string& WiFiMode_);

    /**
     * Sets the value of the member "WiFiMode".
     *
     * If the meaning of "WiFiMode" isn't clear, then there should be a description here.
     *
     * @param WiFiMode The value which will be set
     */
    inline void setWiFiMode (const char* WiFiMode_);

    /**
     * Sets the value of the member "WiFiMode".
     *
     * If the meaning of "WiFiMode" isn't clear, then there should be a description here.
     *
     * @param WiFiMode The value which will be set
     */
    inline void setWiFiMode (const char* value, size_t size);

    static const DeActivateSetupRequest &getDefaultInstance();

private:

    inline void set_has_WiFiMode ();

    inline void clear_has_WiFiMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _WiFiMode;

};

/**
 * If the meaning of "WiFiStationModeUsageRequest" isn't clear, then there should be a description here.
 */
class WiFiStationModeUsageRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WiFiStationModeUsageRequest ();

    /**
     * Copy constructor
     */
    inline  WiFiStationModeUsageRequest (const WiFiStationModeUsageRequest &rhs);

    /**
     * All fields constructor
     */
    inline  WiFiStationModeUsageRequest (const ::std::string& application_, const ::std::string& usage_, bool holding_);

    /**
     * Destructor
     */
    inline virtual  ~WiFiStationModeUsageRequest();

    /**
     * Assignment operator
     */
    inline WiFiStationModeUsageRequest& operator = (const WiFiStationModeUsageRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WiFiStationModeUsageRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WiFiStationModeUsageRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WiFiStationModeUsageRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WiFiStationModeUsageRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "application"

    static const int kApplication = 0;

    /**
     * Clears the field "application".
     *
     * The field will be set to its default value. The hasApplication()
     * method will return false.
     */
    inline void clearApplication();

    /**
     * Checks whether the field "application" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setApplication()). Otherwise it will return false.
     */
    inline bool hasApplication () const;

    /**
     * Returns the value of the member "application".
     *
     * If the meaning of "application" isn't clear, then there should be a description here.
     *
     * @return The value of the field "application"
     */
    inline const ::std::string& getApplication () const;

    /**
     * Retrieves the value of the field "application" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "application".
     */
    inline ::std::string& getApplicationMutable ();

    /**
     * Sets the value of the member "application".
     *
     * If the meaning of "application" isn't clear, then there should be a description here.
     *
     * @param application The value which will be set
     */
    inline void setApplication (const ::std::string& application_);

    /**
     * Sets the value of the member "application".
     *
     * If the meaning of "application" isn't clear, then there should be a description here.
     *
     * @param application The value which will be set
     */
    inline void setApplication (const char* application_);

    /**
     * Sets the value of the member "application".
     *
     * If the meaning of "application" isn't clear, then there should be a description here.
     *
     * @param application The value which will be set
     */
    inline void setApplication (const char* value, size_t size);

    // API of field "usage"

    static const int kUsage = 1;

    /**
     * Clears the field "usage".
     *
     * The field will be set to its default value. The hasUsage()
     * method will return false.
     */
    inline void clearUsage();

    /**
     * Checks whether the field "usage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUsage()). Otherwise it will return false.
     */
    inline bool hasUsage () const;

    /**
     * Returns the value of the member "usage".
     *
     * If the meaning of "usage" isn't clear, then there should be a description here.
     *
     * @return The value of the field "usage"
     */
    inline const ::std::string& getUsage () const;

    /**
     * Retrieves the value of the field "usage" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "usage".
     */
    inline ::std::string& getUsageMutable ();

    /**
     * Sets the value of the member "usage".
     *
     * If the meaning of "usage" isn't clear, then there should be a description here.
     *
     * @param usage The value which will be set
     */
    inline void setUsage (const ::std::string& usage_);

    /**
     * Sets the value of the member "usage".
     *
     * If the meaning of "usage" isn't clear, then there should be a description here.
     *
     * @param usage The value which will be set
     */
    inline void setUsage (const char* usage_);

    /**
     * Sets the value of the member "usage".
     *
     * If the meaning of "usage" isn't clear, then there should be a description here.
     *
     * @param usage The value which will be set
     */
    inline void setUsage (const char* value, size_t size);

    // API of field "holding"

    static const int kHolding = 2;

    /**
     * Clears the field "holding".
     *
     * The field will be set to its default value. The hasHolding()
     * method will return false.
     */
    inline void clearHolding();

    /**
     * Checks whether the field "holding" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHolding()). Otherwise it will return false.
     */
    inline bool hasHolding () const;

    /**
     * Returns the value of the member "holding".
     *
     * If the meaning of "holding" isn't clear, then there should be a description here.
     *
     * @return The value of the field "holding"
     */
    inline bool getHolding () const;

    /**
     * Sets the value of the member "holding".
     *
     * If the meaning of "holding" isn't clear, then there should be a description here.
     *
     * @param holding The value which will be set
     */
    inline void setHolding (bool holding_);

    static const WiFiStationModeUsageRequest &getDefaultInstance();

private:

    inline void set_has_application ();

    inline void clear_has_application ();

    inline void set_has_usage ();

    inline void clear_has_usage ();

    inline void set_has_holding ();

    inline void clear_has_holding ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _application;

    ::std::string _usage;

    bool _holding;

};

/**
 * If the meaning of "ResolveConflictRequest" isn't clear, then there should be a description here.
 */
class ResolveConflictRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ResolveConflictRequest ();

    /**
     * Copy constructor
     */
    inline  ResolveConflictRequest (const ResolveConflictRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ResolveConflictRequest (int32 conflictid_, int32 action_);

    /**
     * Destructor
     */
    inline virtual  ~ResolveConflictRequest();

    /**
     * Assignment operator
     */
    inline ResolveConflictRequest& operator = (const ResolveConflictRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ResolveConflictRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ResolveConflictRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ResolveConflictRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ResolveConflictRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "conflictid"

    static const int kConflictid = 0;

    /**
     * Clears the field "conflictid".
     *
     * The field will be set to its default value. The hasConflictid()
     * method will return false.
     */
    inline void clearConflictid();

    /**
     * Checks whether the field "conflictid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConflictid()). Otherwise it will return false.
     */
    inline bool hasConflictid () const;

    /**
     * Returns the value of the member "conflictid".
     *
     * If the meaning of "conflictid" isn't clear, then there should be a description here.
     *
     * @return The value of the field "conflictid"
     */
    inline int32 getConflictid () const;

    /**
     * Sets the value of the member "conflictid".
     *
     * If the meaning of "conflictid" isn't clear, then there should be a description here.
     *
     * @param conflictid The value which will be set
     */
    inline void setConflictid (int32 conflictid_);

    // API of field "action"

    static const int kAction = 1;

    /**
     * Clears the field "action".
     *
     * The field will be set to its default value. The hasAction()
     * method will return false.
     */
    inline void clearAction();

    /**
     * Checks whether the field "action" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAction()). Otherwise it will return false.
     */
    inline bool hasAction () const;

    /**
     * Returns the value of the member "action".
     *
     * If the meaning of "action" isn't clear, then there should be a description here.
     *
     * @return The value of the field "action"
     */
    inline int32 getAction () const;

    /**
     * Sets the value of the member "action".
     *
     * If the meaning of "action" isn't clear, then there should be a description here.
     *
     * @param action The value which will be set
     */
    inline void setAction (int32 action_);

    static const ResolveConflictRequest &getDefaultInstance();

private:

    inline void set_has_conflictid ();

    inline void clear_has_conflictid ();

    inline void set_has_action ();

    inline void clear_has_action ();

    uint32 _has_bits_[ (2 + 31) / 32];

    int32 _conflictid;

    int32 _action;

};

/**
 * If the meaning of "ActiveWiFiSetupsStruct" isn't clear, then there should be a description here.
 */
class ActiveWiFiSetupsStruct {
public:

    /**
     * Default constructor
     */
    inline  ActiveWiFiSetupsStruct ();

    /**
     * Copy constructor
     */
    inline  ActiveWiFiSetupsStruct (const ActiveWiFiSetupsStruct &rhs);

    /**
     * All fields constructor
     */
    inline  ActiveWiFiSetupsStruct (const ::std::string& elem1_, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& elem2_);

    /**
     * Destructor
     */
    inline  ~ActiveWiFiSetupsStruct();

    /**
     * Assignment operator
     */
    inline ActiveWiFiSetupsStruct& operator = (const ActiveWiFiSetupsStruct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActiveWiFiSetupsStruct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActiveWiFiSetupsStruct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActiveWiFiSetupsStruct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActiveWiFiSetupsStruct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline const ::std::string& getElem1 () const;

    /**
     * Retrieves the value of the field "elem1" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "elem1".
     */
    inline ::std::string& getElem1Mutable ();

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (const ::std::string& elem1_);

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (const char* elem1_);

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (const char* value, size_t size);

    // API of field "elem2"

    static const int kElem2 = 1;

    /**
     * Clears the field "elem2".
     *
     * The field will be set to its default value. The hasElem2()
     * method will return false.
     */
    inline void clearElem2();

    /**
     * Checks whether the field "elem2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem2()). Otherwise it will return false.
     */
    inline bool hasElem2 () const;

    /**
     * Returns the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem2"
     */
    inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getElem2 () const;

    /**
     * Retrieves the value of the field "elem2" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "elem2".
     */
    inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getElem2Mutable ();

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& elem2_);

    static const ActiveWiFiSetupsStruct &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStringTo__asf__dbus__DBusVariantMap_DefaultInstance ();

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    inline void set_has_elem2 ();

    inline void clear_has_elem2 ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _elem1;

    ::std::map< ::std::string, ::asf::dbus::DBusVariant > _elem2;

};

/**
 * If the meaning of "ActiveWiFiSetupsUpdate" isn't clear, then there should be a description here.
 */
class ActiveWiFiSetupsUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActiveWiFiSetupsUpdate ();

    /**
     * Copy constructor
     */
    inline  ActiveWiFiSetupsUpdate (const ActiveWiFiSetupsUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ActiveWiFiSetupsUpdate (const ::std::vector< ActiveWiFiSetupsStruct >& ActiveWiFiSetups_);

    /**
     * Destructor
     */
    inline virtual  ~ActiveWiFiSetupsUpdate();

    /**
     * Assignment operator
     */
    inline ActiveWiFiSetupsUpdate& operator = (const ActiveWiFiSetupsUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActiveWiFiSetupsUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActiveWiFiSetupsUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActiveWiFiSetupsUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActiveWiFiSetupsUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ActiveWiFiSetups"

    static const int kActiveWiFiSetups = 0;

    /**
     * Clears the field "ActiveWiFiSetups".
     *
     * The field will be set to its default value. The hasActiveWiFiSetups()
     * method will return false.
     */
    inline void clearActiveWiFiSetups();

    /**
     * Checks whether the field "ActiveWiFiSetups" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActiveWiFiSetups()). Otherwise it will return false.
     */
    inline bool hasActiveWiFiSetups () const;

    /**
     * Returns the value of the member "ActiveWiFiSetups".
     *
     * If the meaning of "ActiveWiFiSetups" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ActiveWiFiSetups"
     */
    inline const ::std::vector< ActiveWiFiSetupsStruct >& getActiveWiFiSetups () const;

    /**
     * Retrieves the value of the field "ActiveWiFiSetups" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ActiveWiFiSetups".
     */
    inline ::std::vector< ActiveWiFiSetupsStruct >& getActiveWiFiSetupsMutable ();

    /**
     * Sets the value of the member "ActiveWiFiSetups".
     *
     * If the meaning of "ActiveWiFiSetups" isn't clear, then there should be a description here.
     *
     * @param ActiveWiFiSetups The value which will be set
     */
    inline void setActiveWiFiSetups (const ::std::vector< ActiveWiFiSetupsStruct >& ActiveWiFiSetups_);

    static const ActiveWiFiSetupsUpdate &getDefaultInstance();

private:

    static const ::std::vector< ActiveWiFiSetupsStruct >& getActiveWiFiSetupsStructList_DefaultInstance ();

    inline void set_has_ActiveWiFiSetups ();

    inline void clear_has_ActiveWiFiSetups ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ActiveWiFiSetupsStruct > _ActiveWiFiSetups;

};

/**
 * If the meaning of "ActiveWiFiSetupsRegister" isn't clear, then there should be a description here.
 */
class ActiveWiFiSetupsRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActiveWiFiSetupsRegister ();

    /**
     * Copy constructor
     */
    inline  ActiveWiFiSetupsRegister (const ActiveWiFiSetupsRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ActiveWiFiSetupsRegister();

    /**
     * Assignment operator
     */
    inline ActiveWiFiSetupsRegister& operator = (const ActiveWiFiSetupsRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActiveWiFiSetupsRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActiveWiFiSetupsRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActiveWiFiSetupsRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActiveWiFiSetupsRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ActiveWiFiSetupsRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "WiFiPriorityListUpdate" isn't clear, then there should be a description here.
 */
class WiFiPriorityListUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WiFiPriorityListUpdate ();

    /**
     * Copy constructor
     */
    inline  WiFiPriorityListUpdate (const WiFiPriorityListUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  WiFiPriorityListUpdate (const ::std::vector< ::std::string >& WiFiPriorityList_);

    /**
     * Destructor
     */
    inline virtual  ~WiFiPriorityListUpdate();

    /**
     * Assignment operator
     */
    inline WiFiPriorityListUpdate& operator = (const WiFiPriorityListUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WiFiPriorityListUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WiFiPriorityListUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WiFiPriorityListUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WiFiPriorityListUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "WiFiPriorityList"

    static const int kWiFiPriorityList = 0;

    /**
     * Clears the field "WiFiPriorityList".
     *
     * The field will be set to its default value. The hasWiFiPriorityList()
     * method will return false.
     */
    inline void clearWiFiPriorityList();

    /**
     * Checks whether the field "WiFiPriorityList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWiFiPriorityList()). Otherwise it will return false.
     */
    inline bool hasWiFiPriorityList () const;

    /**
     * Returns the value of the member "WiFiPriorityList".
     *
     * If the meaning of "WiFiPriorityList" isn't clear, then there should be a description here.
     *
     * @return The value of the field "WiFiPriorityList"
     */
    inline const ::std::vector< ::std::string >& getWiFiPriorityList () const;

    /**
     * Retrieves the value of the field "WiFiPriorityList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "WiFiPriorityList".
     */
    inline ::std::vector< ::std::string >& getWiFiPriorityListMutable ();

    /**
     * Sets the value of the member "WiFiPriorityList".
     *
     * If the meaning of "WiFiPriorityList" isn't clear, then there should be a description here.
     *
     * @param WiFiPriorityList The value which will be set
     */
    inline void setWiFiPriorityList (const ::std::vector< ::std::string >& WiFiPriorityList_);

    static const WiFiPriorityListUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_WiFiPriorityList ();

    inline void clear_has_WiFiPriorityList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _WiFiPriorityList;

};

/**
 * If the meaning of "WiFiPriorityListRegister" isn't clear, then there should be a description here.
 */
class WiFiPriorityListRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WiFiPriorityListRegister ();

    /**
     * Copy constructor
     */
    inline  WiFiPriorityListRegister (const WiFiPriorityListRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~WiFiPriorityListRegister();

    /**
     * Assignment operator
     */
    inline WiFiPriorityListRegister& operator = (const WiFiPriorityListRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WiFiPriorityListRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WiFiPriorityListRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WiFiPriorityListRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WiFiPriorityListRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const WiFiPriorityListRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "ConfigurationTimerUpdate" isn't clear, then there should be a description here.
 */
class ConfigurationTimerUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConfigurationTimerUpdate ();

    /**
     * Copy constructor
     */
    inline  ConfigurationTimerUpdate (const ConfigurationTimerUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ConfigurationTimerUpdate (int32 ConfigurationTimer_);

    /**
     * Destructor
     */
    inline virtual  ~ConfigurationTimerUpdate();

    /**
     * Assignment operator
     */
    inline ConfigurationTimerUpdate& operator = (const ConfigurationTimerUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConfigurationTimerUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConfigurationTimerUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConfigurationTimerUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConfigurationTimerUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ConfigurationTimer"

    static const int kConfigurationTimer = 0;

    /**
     * Clears the field "ConfigurationTimer".
     *
     * The field will be set to its default value. The hasConfigurationTimer()
     * method will return false.
     */
    inline void clearConfigurationTimer();

    /**
     * Checks whether the field "ConfigurationTimer" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConfigurationTimer()). Otherwise it will return false.
     */
    inline bool hasConfigurationTimer () const;

    /**
     * Returns the value of the member "ConfigurationTimer".
     *
     * If the meaning of "ConfigurationTimer" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ConfigurationTimer"
     */
    inline int32 getConfigurationTimer () const;

    /**
     * Sets the value of the member "ConfigurationTimer".
     *
     * If the meaning of "ConfigurationTimer" isn't clear, then there should be a description here.
     *
     * @param ConfigurationTimer The value which will be set
     */
    inline void setConfigurationTimer (int32 ConfigurationTimer_);

    static const ConfigurationTimerUpdate &getDefaultInstance();

private:

    inline void set_has_ConfigurationTimer ();

    inline void clear_has_ConfigurationTimer ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _ConfigurationTimer;

};

/**
 * If the meaning of "ConfigurationTimerRegister" isn't clear, then there should be a description here.
 */
class ConfigurationTimerRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConfigurationTimerRegister ();

    /**
     * Copy constructor
     */
    inline  ConfigurationTimerRegister (const ConfigurationTimerRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ConfigurationTimerRegister();

    /**
     * Assignment operator
     */
    inline ConfigurationTimerRegister& operator = (const ConfigurationTimerRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConfigurationTimerRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConfigurationTimerRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConfigurationTimerRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConfigurationTimerRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ConfigurationTimerRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "ConflictDetectedSignal" isn't clear, then there should be a description here.
 */
class ConflictDetectedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConflictDetectedSignal ();

    /**
     * Copy constructor
     */
    inline  ConflictDetectedSignal (const ConflictDetectedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  ConflictDetectedSignal (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& conflictdetected_);

    /**
     * Destructor
     */
    inline virtual  ~ConflictDetectedSignal();

    /**
     * Assignment operator
     */
    inline ConflictDetectedSignal& operator = (const ConflictDetectedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConflictDetectedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConflictDetectedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConflictDetectedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConflictDetectedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "conflictdetected"

    static const int kConflictdetected = 0;

    /**
     * Clears the field "conflictdetected".
     *
     * The field will be set to its default value. The hasConflictdetected()
     * method will return false.
     */
    inline void clearConflictdetected();

    /**
     * Checks whether the field "conflictdetected" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConflictdetected()). Otherwise it will return false.
     */
    inline bool hasConflictdetected () const;

    /**
     * Returns the value of the member "conflictdetected".
     *
     * If the meaning of "conflictdetected" isn't clear, then there should be a description here.
     *
     * @return The value of the field "conflictdetected"
     */
    inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getConflictdetected () const;

    /**
     * Retrieves the value of the field "conflictdetected" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "conflictdetected".
     */
    inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getConflictdetectedMutable ();

    /**
     * Sets the value of the member "conflictdetected".
     *
     * If the meaning of "conflictdetected" isn't clear, then there should be a description here.
     *
     * @param conflictdetected The value which will be set
     */
    inline void setConflictdetected (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& conflictdetected_);

    static const ConflictDetectedSignal &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStringTo__asf__dbus__DBusVariantMap_DefaultInstance ();

    inline void set_has_conflictdetected ();

    inline void clear_has_conflictdetected ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::map< ::std::string, ::asf::dbus::DBusVariant > _conflictdetected;

};

/**
 * If the meaning of "ConflictResolvedSignal" isn't clear, then there should be a description here.
 */
class ConflictResolvedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConflictResolvedSignal ();

    /**
     * Copy constructor
     */
    inline  ConflictResolvedSignal (const ConflictResolvedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  ConflictResolvedSignal (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& conflictresolved_);

    /**
     * Destructor
     */
    inline virtual  ~ConflictResolvedSignal();

    /**
     * Assignment operator
     */
    inline ConflictResolvedSignal& operator = (const ConflictResolvedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConflictResolvedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConflictResolvedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConflictResolvedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConflictResolvedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "conflictresolved"

    static const int kConflictresolved = 0;

    /**
     * Clears the field "conflictresolved".
     *
     * The field will be set to its default value. The hasConflictresolved()
     * method will return false.
     */
    inline void clearConflictresolved();

    /**
     * Checks whether the field "conflictresolved" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConflictresolved()). Otherwise it will return false.
     */
    inline bool hasConflictresolved () const;

    /**
     * Returns the value of the member "conflictresolved".
     *
     * If the meaning of "conflictresolved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "conflictresolved"
     */
    inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getConflictresolved () const;

    /**
     * Retrieves the value of the field "conflictresolved" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "conflictresolved".
     */
    inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getConflictresolvedMutable ();

    /**
     * Sets the value of the member "conflictresolved".
     *
     * If the meaning of "conflictresolved" isn't clear, then there should be a description here.
     *
     * @param conflictresolved The value which will be set
     */
    inline void setConflictresolved (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& conflictresolved_);

    static const ConflictResolvedSignal &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStringTo__asf__dbus__DBusVariantMap_DefaultInstance ();

    inline void set_has_conflictresolved ();

    inline void clear_has_conflictresolved ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::map< ::std::string, ::asf::dbus::DBusVariant > _conflictresolved;

};

inline  PrepareSetupRequest::PrepareSetupRequest ()  :
    _configuration ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PrepareSetupRequest::PrepareSetupRequest (const PrepareSetupRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _configuration ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PrepareSetupRequest::PrepareSetupRequest (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& configuration_)  :
    _configuration (configuration_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PrepareSetupRequest::~PrepareSetupRequest() {
}

inline PrepareSetupRequest& PrepareSetupRequest::operator = (const PrepareSetupRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasConfiguration()) {
            setConfiguration(rhs.getConfiguration());
        } else {
            clearConfiguration();
        }
    }
    return *this;
}

inline bool PrepareSetupRequest::operator == (const PrepareSetupRequest& rhs) const {
    return (((!hasConfiguration() && !rhs.hasConfiguration()) || getConfiguration() == rhs.getConfiguration()));
}

inline bool PrepareSetupRequest::operator != (const PrepareSetupRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool PrepareSetupRequest::operator < (const PrepareSetupRequest& rhs) const {
    if (hasConfiguration() || rhs.hasConfiguration()) {
        if (getConfiguration() < rhs.getConfiguration()) return true;
        if (getConfiguration() > rhs.getConfiguration()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PrepareSetupRequest::clone() {
    return new PrepareSetupRequest(*this);
}

inline bool PrepareSetupRequest::operator > (const PrepareSetupRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PrepareSetupRequest::clear() {
    clearConfiguration();
}

inline void PrepareSetupRequest::clearConfiguration() {
    if (hasConfiguration()) {
         clear_has_configuration();
        _configuration.clear();
     }
}

inline bool PrepareSetupRequest::hasConfiguration () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& PrepareSetupRequest::getConfiguration () const {
    return _configuration;
}

inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& PrepareSetupRequest::getConfigurationMutable () {
    set_has_configuration();
    return _configuration;
}

inline void PrepareSetupRequest::setConfiguration (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& configuration_) {
    set_has_configuration();
    this->_configuration = configuration_;
}

inline void PrepareSetupRequest::set_has_configuration () {
    _has_bits_[0] |= 1u << 0;
}

inline void PrepareSetupRequest::clear_has_configuration () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DeActivateSetupRequest::DeActivateSetupRequest ()  :
    _WiFiMode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DeActivateSetupRequest::DeActivateSetupRequest (const DeActivateSetupRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _WiFiMode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DeActivateSetupRequest::DeActivateSetupRequest (const ::std::string& WiFiMode_)  :
    _WiFiMode (WiFiMode_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (WiFiMode_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DeActivateSetupRequest::~DeActivateSetupRequest() {
}

inline DeActivateSetupRequest& DeActivateSetupRequest::operator = (const DeActivateSetupRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasWiFiMode()) {
            setWiFiMode(rhs.getWiFiMode());
        } else {
            clearWiFiMode();
        }
    }
    return *this;
}

inline bool DeActivateSetupRequest::operator == (const DeActivateSetupRequest& rhs) const {
    return (((!hasWiFiMode() && !rhs.hasWiFiMode()) || getWiFiMode() == rhs.getWiFiMode()));
}

inline bool DeActivateSetupRequest::operator != (const DeActivateSetupRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool DeActivateSetupRequest::operator < (const DeActivateSetupRequest& rhs) const {
    if (hasWiFiMode() || rhs.hasWiFiMode()) {
        if (getWiFiMode() < rhs.getWiFiMode()) return true;
        if (getWiFiMode() > rhs.getWiFiMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DeActivateSetupRequest::clone() {
    return new DeActivateSetupRequest(*this);
}

inline bool DeActivateSetupRequest::operator > (const DeActivateSetupRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DeActivateSetupRequest::clear() {
    clearWiFiMode();
}

inline void DeActivateSetupRequest::clearWiFiMode() {
    if (hasWiFiMode()) {
         clear_has_WiFiMode();
        _WiFiMode.clear();
     }
}

inline bool DeActivateSetupRequest::hasWiFiMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& DeActivateSetupRequest::getWiFiMode () const {
    return _WiFiMode;
}

inline ::std::string& DeActivateSetupRequest::getWiFiModeMutable () {
    set_has_WiFiMode();
    return _WiFiMode;
}

inline void DeActivateSetupRequest::setWiFiMode (const ::std::string& WiFiMode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (WiFiMode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_WiFiMode();
    this->_WiFiMode = WiFiMode_;
}

inline void DeActivateSetupRequest::setWiFiMode (const char* WiFiMode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (WiFiMode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_WiFiMode();
    this->_WiFiMode.assign(WiFiMode_);
}

inline void DeActivateSetupRequest::setWiFiMode (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_WiFiMode();
    this->_WiFiMode.assign(value, size);
}

inline void DeActivateSetupRequest::set_has_WiFiMode () {
    _has_bits_[0] |= 1u << 0;
}

inline void DeActivateSetupRequest::clear_has_WiFiMode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  WiFiStationModeUsageRequest::WiFiStationModeUsageRequest ()  :
    _application (),
    _usage (),
    _holding (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  WiFiStationModeUsageRequest::WiFiStationModeUsageRequest (const WiFiStationModeUsageRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _application (),
    _usage (),
    _holding (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  WiFiStationModeUsageRequest::WiFiStationModeUsageRequest (const ::std::string& application_, const ::std::string& usage_, bool holding_)  :
    _application (application_),
    _usage (usage_),
    _holding (holding_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (application_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (usage_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  WiFiStationModeUsageRequest::~WiFiStationModeUsageRequest() {
}

inline WiFiStationModeUsageRequest& WiFiStationModeUsageRequest::operator = (const WiFiStationModeUsageRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasApplication()) {
            setApplication(rhs.getApplication());
        } else {
            clearApplication();
        }
        if (rhs.hasUsage()) {
            setUsage(rhs.getUsage());
        } else {
            clearUsage();
        }
        if (rhs.hasHolding()) {
            setHolding(rhs.getHolding());
        } else {
            clearHolding();
        }
    }
    return *this;
}

inline bool WiFiStationModeUsageRequest::operator == (const WiFiStationModeUsageRequest& rhs) const {
    return (((!hasApplication() && !rhs.hasApplication()) || getApplication() == rhs.getApplication()) &&
        ((!hasUsage() && !rhs.hasUsage()) || getUsage() == rhs.getUsage()) &&
        ((!hasHolding() && !rhs.hasHolding()) || getHolding() == rhs.getHolding()));
}

inline bool WiFiStationModeUsageRequest::operator != (const WiFiStationModeUsageRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool WiFiStationModeUsageRequest::operator < (const WiFiStationModeUsageRequest& rhs) const {
    if (hasApplication() || rhs.hasApplication()) {
        if (getApplication() < rhs.getApplication()) return true;
        if (getApplication() > rhs.getApplication()) return false;
    }
    if (hasUsage() || rhs.hasUsage()) {
        if (getUsage() < rhs.getUsage()) return true;
        if (getUsage() > rhs.getUsage()) return false;
    }
    if (hasHolding() || rhs.hasHolding()) {
        if (getHolding() < rhs.getHolding()) return true;
        if (getHolding() > rhs.getHolding()) return false;
    }
    return false;
}

inline ::asf::core::Payload* WiFiStationModeUsageRequest::clone() {
    return new WiFiStationModeUsageRequest(*this);
}

inline bool WiFiStationModeUsageRequest::operator > (const WiFiStationModeUsageRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void WiFiStationModeUsageRequest::clear() {
    clearApplication();
    clearUsage();
    clearHolding();
}

inline void WiFiStationModeUsageRequest::clearApplication() {
    if (hasApplication()) {
         clear_has_application();
        _application.clear();
     }
}

inline bool WiFiStationModeUsageRequest::hasApplication () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& WiFiStationModeUsageRequest::getApplication () const {
    return _application;
}

inline ::std::string& WiFiStationModeUsageRequest::getApplicationMutable () {
    set_has_application();
    return _application;
}

inline void WiFiStationModeUsageRequest::setApplication (const ::std::string& application_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (application_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_application();
    this->_application = application_;
}

inline void WiFiStationModeUsageRequest::setApplication (const char* application_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (application_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_application();
    this->_application.assign(application_);
}

inline void WiFiStationModeUsageRequest::setApplication (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_application();
    this->_application.assign(value, size);
}

inline void WiFiStationModeUsageRequest::clearUsage() {
    if (hasUsage()) {
         clear_has_usage();
        _usage.clear();
     }
}

inline bool WiFiStationModeUsageRequest::hasUsage () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& WiFiStationModeUsageRequest::getUsage () const {
    return _usage;
}

inline ::std::string& WiFiStationModeUsageRequest::getUsageMutable () {
    set_has_usage();
    return _usage;
}

inline void WiFiStationModeUsageRequest::setUsage (const ::std::string& usage_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (usage_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_usage();
    this->_usage = usage_;
}

inline void WiFiStationModeUsageRequest::setUsage (const char* usage_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (usage_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_usage();
    this->_usage.assign(usage_);
}

inline void WiFiStationModeUsageRequest::setUsage (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_usage();
    this->_usage.assign(value, size);
}

inline void WiFiStationModeUsageRequest::clearHolding() {
    if (hasHolding()) {
         clear_has_holding();
        _holding = false;
     }
}

inline bool WiFiStationModeUsageRequest::hasHolding () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool WiFiStationModeUsageRequest::getHolding () const {
    return _holding;
}

inline void WiFiStationModeUsageRequest::setHolding (bool holding_) {
    set_has_holding();
    this->_holding = holding_;
}

inline void WiFiStationModeUsageRequest::set_has_application () {
    _has_bits_[0] |= 1u << 0;
}

inline void WiFiStationModeUsageRequest::clear_has_application () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void WiFiStationModeUsageRequest::set_has_usage () {
    _has_bits_[0] |= 1u << 1;
}

inline void WiFiStationModeUsageRequest::clear_has_usage () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void WiFiStationModeUsageRequest::set_has_holding () {
    _has_bits_[0] |= 1u << 2;
}

inline void WiFiStationModeUsageRequest::clear_has_holding () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  ResolveConflictRequest::ResolveConflictRequest ()  :
    _conflictid (0),
    _action (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ResolveConflictRequest::ResolveConflictRequest (const ResolveConflictRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _conflictid (0),
    _action (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ResolveConflictRequest::ResolveConflictRequest (int32 conflictid_, int32 action_)  :
    _conflictid (conflictid_),
    _action (action_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ResolveConflictRequest::~ResolveConflictRequest() {
}

inline ResolveConflictRequest& ResolveConflictRequest::operator = (const ResolveConflictRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasConflictid()) {
            setConflictid(rhs.getConflictid());
        } else {
            clearConflictid();
        }
        if (rhs.hasAction()) {
            setAction(rhs.getAction());
        } else {
            clearAction();
        }
    }
    return *this;
}

inline bool ResolveConflictRequest::operator == (const ResolveConflictRequest& rhs) const {
    return (((!hasConflictid() && !rhs.hasConflictid()) || getConflictid() == rhs.getConflictid()) &&
        ((!hasAction() && !rhs.hasAction()) || getAction() == rhs.getAction()));
}

inline bool ResolveConflictRequest::operator != (const ResolveConflictRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ResolveConflictRequest::operator < (const ResolveConflictRequest& rhs) const {
    if (hasConflictid() || rhs.hasConflictid()) {
        if (getConflictid() < rhs.getConflictid()) return true;
        if (getConflictid() > rhs.getConflictid()) return false;
    }
    if (hasAction() || rhs.hasAction()) {
        if (getAction() < rhs.getAction()) return true;
        if (getAction() > rhs.getAction()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ResolveConflictRequest::clone() {
    return new ResolveConflictRequest(*this);
}

inline bool ResolveConflictRequest::operator > (const ResolveConflictRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ResolveConflictRequest::clear() {
    clearConflictid();
    clearAction();
}

inline void ResolveConflictRequest::clearConflictid() {
    if (hasConflictid()) {
         clear_has_conflictid();
        _conflictid = 0;
     }
}

inline bool ResolveConflictRequest::hasConflictid () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 ResolveConflictRequest::getConflictid () const {
    return _conflictid;
}

inline void ResolveConflictRequest::setConflictid (int32 conflictid_) {
    set_has_conflictid();
    this->_conflictid = conflictid_;
}

inline void ResolveConflictRequest::clearAction() {
    if (hasAction()) {
         clear_has_action();
        _action = 0;
     }
}

inline bool ResolveConflictRequest::hasAction () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int32 ResolveConflictRequest::getAction () const {
    return _action;
}

inline void ResolveConflictRequest::setAction (int32 action_) {
    set_has_action();
    this->_action = action_;
}

inline void ResolveConflictRequest::set_has_conflictid () {
    _has_bits_[0] |= 1u << 0;
}

inline void ResolveConflictRequest::clear_has_conflictid () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ResolveConflictRequest::set_has_action () {
    _has_bits_[0] |= 1u << 1;
}

inline void ResolveConflictRequest::clear_has_action () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  ActiveWiFiSetupsStruct::ActiveWiFiSetupsStruct ()  :
    _elem1 (),
    _elem2 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ActiveWiFiSetupsStruct::ActiveWiFiSetupsStruct (const ActiveWiFiSetupsStruct &rhs)  :
    _elem1 (),
    _elem2 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ActiveWiFiSetupsStruct::ActiveWiFiSetupsStruct (const ::std::string& elem1_, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& elem2_)  :
    _elem1 (elem1_),
    _elem2 (elem2_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem1_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ActiveWiFiSetupsStruct::~ActiveWiFiSetupsStruct() {
}

inline ActiveWiFiSetupsStruct& ActiveWiFiSetupsStruct::operator = (const ActiveWiFiSetupsStruct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
        if (rhs.hasElem2()) {
            setElem2(rhs.getElem2());
        } else {
            clearElem2();
        }
    }
    return *this;
}

inline bool ActiveWiFiSetupsStruct::operator == (const ActiveWiFiSetupsStruct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()) &&
        ((!hasElem2() && !rhs.hasElem2()) || getElem2() == rhs.getElem2()));
}

inline bool ActiveWiFiSetupsStruct::operator != (const ActiveWiFiSetupsStruct& rhs) const {
    return ! (*this == rhs);
}

inline bool ActiveWiFiSetupsStruct::operator < (const ActiveWiFiSetupsStruct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    if (hasElem2() || rhs.hasElem2()) {
        if (getElem2() < rhs.getElem2()) return true;
        if (getElem2() > rhs.getElem2()) return false;
    }
    return false;
}

inline bool ActiveWiFiSetupsStruct::operator > (const ActiveWiFiSetupsStruct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ActiveWiFiSetupsStruct::clear() {
    clearElem1();
    clearElem2();
}

inline void ActiveWiFiSetupsStruct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1.clear();
     }
}

inline bool ActiveWiFiSetupsStruct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ActiveWiFiSetupsStruct::getElem1 () const {
    return _elem1;
}

inline ::std::string& ActiveWiFiSetupsStruct::getElem1Mutable () {
    set_has_elem1();
    return _elem1;
}

inline void ActiveWiFiSetupsStruct::setElem1 (const ::std::string& elem1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void ActiveWiFiSetupsStruct::setElem1 (const char* elem1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem1();
    this->_elem1.assign(elem1_);
}

inline void ActiveWiFiSetupsStruct::setElem1 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem1();
    this->_elem1.assign(value, size);
}

inline void ActiveWiFiSetupsStruct::clearElem2() {
    if (hasElem2()) {
         clear_has_elem2();
        _elem2.clear();
     }
}

inline bool ActiveWiFiSetupsStruct::hasElem2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& ActiveWiFiSetupsStruct::getElem2 () const {
    return _elem2;
}

inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& ActiveWiFiSetupsStruct::getElem2Mutable () {
    set_has_elem2();
    return _elem2;
}

inline void ActiveWiFiSetupsStruct::setElem2 (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& elem2_) {
    set_has_elem2();
    this->_elem2 = elem2_;
}

inline void ActiveWiFiSetupsStruct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void ActiveWiFiSetupsStruct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ActiveWiFiSetupsStruct::set_has_elem2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void ActiveWiFiSetupsStruct::clear_has_elem2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  ActiveWiFiSetupsUpdate::ActiveWiFiSetupsUpdate ()  :
    _ActiveWiFiSetups ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ActiveWiFiSetupsUpdate::ActiveWiFiSetupsUpdate (const ActiveWiFiSetupsUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _ActiveWiFiSetups ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ActiveWiFiSetupsUpdate::ActiveWiFiSetupsUpdate (const ::std::vector< ActiveWiFiSetupsStruct >& ActiveWiFiSetups_)  :
    _ActiveWiFiSetups (ActiveWiFiSetups_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ActiveWiFiSetupsUpdate::~ActiveWiFiSetupsUpdate() {
}

inline ActiveWiFiSetupsUpdate& ActiveWiFiSetupsUpdate::operator = (const ActiveWiFiSetupsUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasActiveWiFiSetups()) {
            setActiveWiFiSetups(rhs.getActiveWiFiSetups());
        } else {
            clearActiveWiFiSetups();
        }
    }
    return *this;
}

inline bool ActiveWiFiSetupsUpdate::operator == (const ActiveWiFiSetupsUpdate& rhs) const {
    return (((!hasActiveWiFiSetups() && !rhs.hasActiveWiFiSetups()) || getActiveWiFiSetups() == rhs.getActiveWiFiSetups()));
}

inline bool ActiveWiFiSetupsUpdate::operator != (const ActiveWiFiSetupsUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool ActiveWiFiSetupsUpdate::operator < (const ActiveWiFiSetupsUpdate& rhs) const {
    if (hasActiveWiFiSetups() || rhs.hasActiveWiFiSetups()) {
        if (getActiveWiFiSetups() < rhs.getActiveWiFiSetups()) return true;
        if (getActiveWiFiSetups() > rhs.getActiveWiFiSetups()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ActiveWiFiSetupsUpdate::clone() {
    return new ActiveWiFiSetupsUpdate(*this);
}

inline bool ActiveWiFiSetupsUpdate::operator > (const ActiveWiFiSetupsUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ActiveWiFiSetupsUpdate::clear() {
    clearActiveWiFiSetups();
}

inline void ActiveWiFiSetupsUpdate::clearActiveWiFiSetups() {
    if (hasActiveWiFiSetups()) {
         clear_has_ActiveWiFiSetups();
        _ActiveWiFiSetups.clear();
     }
}

inline bool ActiveWiFiSetupsUpdate::hasActiveWiFiSetups () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ActiveWiFiSetupsStruct >& ActiveWiFiSetupsUpdate::getActiveWiFiSetups () const {
    return _ActiveWiFiSetups;
}

inline ::std::vector< ActiveWiFiSetupsStruct >& ActiveWiFiSetupsUpdate::getActiveWiFiSetupsMutable () {
    set_has_ActiveWiFiSetups();
    return _ActiveWiFiSetups;
}

inline void ActiveWiFiSetupsUpdate::setActiveWiFiSetups (const ::std::vector< ActiveWiFiSetupsStruct >& ActiveWiFiSetups_) {
    set_has_ActiveWiFiSetups();
    this->_ActiveWiFiSetups = ActiveWiFiSetups_;
}

inline void ActiveWiFiSetupsUpdate::set_has_ActiveWiFiSetups () {
    _has_bits_[0] |= 1u << 0;
}

inline void ActiveWiFiSetupsUpdate::clear_has_ActiveWiFiSetups () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ActiveWiFiSetupsRegister::ActiveWiFiSetupsRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ActiveWiFiSetupsRegister::ActiveWiFiSetupsRegister (const ActiveWiFiSetupsRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ActiveWiFiSetupsRegister::~ActiveWiFiSetupsRegister() {
}

inline ActiveWiFiSetupsRegister& ActiveWiFiSetupsRegister::operator = (const ActiveWiFiSetupsRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool ActiveWiFiSetupsRegister::operator == (const ActiveWiFiSetupsRegister& ) const {
    return true;
}

inline bool ActiveWiFiSetupsRegister::operator != (const ActiveWiFiSetupsRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool ActiveWiFiSetupsRegister::operator < (const ActiveWiFiSetupsRegister& ) const {
    return false;
}

inline ::asf::core::Payload* ActiveWiFiSetupsRegister::clone() {
    return new ActiveWiFiSetupsRegister(*this);
}

inline bool ActiveWiFiSetupsRegister::operator > (const ActiveWiFiSetupsRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ActiveWiFiSetupsRegister::clear() {
}

inline  WiFiPriorityListUpdate::WiFiPriorityListUpdate ()  :
    _WiFiPriorityList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  WiFiPriorityListUpdate::WiFiPriorityListUpdate (const WiFiPriorityListUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _WiFiPriorityList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  WiFiPriorityListUpdate::WiFiPriorityListUpdate (const ::std::vector< ::std::string >& WiFiPriorityList_)  :
    _WiFiPriorityList (WiFiPriorityList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  WiFiPriorityListUpdate::~WiFiPriorityListUpdate() {
}

inline WiFiPriorityListUpdate& WiFiPriorityListUpdate::operator = (const WiFiPriorityListUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasWiFiPriorityList()) {
            setWiFiPriorityList(rhs.getWiFiPriorityList());
        } else {
            clearWiFiPriorityList();
        }
    }
    return *this;
}

inline bool WiFiPriorityListUpdate::operator == (const WiFiPriorityListUpdate& rhs) const {
    return (((!hasWiFiPriorityList() && !rhs.hasWiFiPriorityList()) || getWiFiPriorityList() == rhs.getWiFiPriorityList()));
}

inline bool WiFiPriorityListUpdate::operator != (const WiFiPriorityListUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool WiFiPriorityListUpdate::operator < (const WiFiPriorityListUpdate& rhs) const {
    if (hasWiFiPriorityList() || rhs.hasWiFiPriorityList()) {
        if (getWiFiPriorityList() < rhs.getWiFiPriorityList()) return true;
        if (getWiFiPriorityList() > rhs.getWiFiPriorityList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* WiFiPriorityListUpdate::clone() {
    return new WiFiPriorityListUpdate(*this);
}

inline bool WiFiPriorityListUpdate::operator > (const WiFiPriorityListUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void WiFiPriorityListUpdate::clear() {
    clearWiFiPriorityList();
}

inline void WiFiPriorityListUpdate::clearWiFiPriorityList() {
    if (hasWiFiPriorityList()) {
         clear_has_WiFiPriorityList();
        _WiFiPriorityList.clear();
     }
}

inline bool WiFiPriorityListUpdate::hasWiFiPriorityList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& WiFiPriorityListUpdate::getWiFiPriorityList () const {
    return _WiFiPriorityList;
}

inline ::std::vector< ::std::string >& WiFiPriorityListUpdate::getWiFiPriorityListMutable () {
    set_has_WiFiPriorityList();
    return _WiFiPriorityList;
}

inline void WiFiPriorityListUpdate::setWiFiPriorityList (const ::std::vector< ::std::string >& WiFiPriorityList_) {
    set_has_WiFiPriorityList();
    this->_WiFiPriorityList = WiFiPriorityList_;
}

inline void WiFiPriorityListUpdate::set_has_WiFiPriorityList () {
    _has_bits_[0] |= 1u << 0;
}

inline void WiFiPriorityListUpdate::clear_has_WiFiPriorityList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  WiFiPriorityListRegister::WiFiPriorityListRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  WiFiPriorityListRegister::WiFiPriorityListRegister (const WiFiPriorityListRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  WiFiPriorityListRegister::~WiFiPriorityListRegister() {
}

inline WiFiPriorityListRegister& WiFiPriorityListRegister::operator = (const WiFiPriorityListRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool WiFiPriorityListRegister::operator == (const WiFiPriorityListRegister& ) const {
    return true;
}

inline bool WiFiPriorityListRegister::operator != (const WiFiPriorityListRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool WiFiPriorityListRegister::operator < (const WiFiPriorityListRegister& ) const {
    return false;
}

inline ::asf::core::Payload* WiFiPriorityListRegister::clone() {
    return new WiFiPriorityListRegister(*this);
}

inline bool WiFiPriorityListRegister::operator > (const WiFiPriorityListRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void WiFiPriorityListRegister::clear() {
}

inline  ConfigurationTimerUpdate::ConfigurationTimerUpdate ()  :
    _ConfigurationTimer (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ConfigurationTimerUpdate::ConfigurationTimerUpdate (const ConfigurationTimerUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _ConfigurationTimer (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ConfigurationTimerUpdate::ConfigurationTimerUpdate (int32 ConfigurationTimer_)  :
    _ConfigurationTimer (ConfigurationTimer_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ConfigurationTimerUpdate::~ConfigurationTimerUpdate() {
}

inline ConfigurationTimerUpdate& ConfigurationTimerUpdate::operator = (const ConfigurationTimerUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasConfigurationTimer()) {
            setConfigurationTimer(rhs.getConfigurationTimer());
        } else {
            clearConfigurationTimer();
        }
    }
    return *this;
}

inline bool ConfigurationTimerUpdate::operator == (const ConfigurationTimerUpdate& rhs) const {
    return (((!hasConfigurationTimer() && !rhs.hasConfigurationTimer()) || getConfigurationTimer() == rhs.getConfigurationTimer()));
}

inline bool ConfigurationTimerUpdate::operator != (const ConfigurationTimerUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool ConfigurationTimerUpdate::operator < (const ConfigurationTimerUpdate& rhs) const {
    if (hasConfigurationTimer() || rhs.hasConfigurationTimer()) {
        if (getConfigurationTimer() < rhs.getConfigurationTimer()) return true;
        if (getConfigurationTimer() > rhs.getConfigurationTimer()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ConfigurationTimerUpdate::clone() {
    return new ConfigurationTimerUpdate(*this);
}

inline bool ConfigurationTimerUpdate::operator > (const ConfigurationTimerUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ConfigurationTimerUpdate::clear() {
    clearConfigurationTimer();
}

inline void ConfigurationTimerUpdate::clearConfigurationTimer() {
    if (hasConfigurationTimer()) {
         clear_has_ConfigurationTimer();
        _ConfigurationTimer = 0;
     }
}

inline bool ConfigurationTimerUpdate::hasConfigurationTimer () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 ConfigurationTimerUpdate::getConfigurationTimer () const {
    return _ConfigurationTimer;
}

inline void ConfigurationTimerUpdate::setConfigurationTimer (int32 ConfigurationTimer_) {
    set_has_ConfigurationTimer();
    this->_ConfigurationTimer = ConfigurationTimer_;
}

inline void ConfigurationTimerUpdate::set_has_ConfigurationTimer () {
    _has_bits_[0] |= 1u << 0;
}

inline void ConfigurationTimerUpdate::clear_has_ConfigurationTimer () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ConfigurationTimerRegister::ConfigurationTimerRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ConfigurationTimerRegister::ConfigurationTimerRegister (const ConfigurationTimerRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ConfigurationTimerRegister::~ConfigurationTimerRegister() {
}

inline ConfigurationTimerRegister& ConfigurationTimerRegister::operator = (const ConfigurationTimerRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool ConfigurationTimerRegister::operator == (const ConfigurationTimerRegister& ) const {
    return true;
}

inline bool ConfigurationTimerRegister::operator != (const ConfigurationTimerRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool ConfigurationTimerRegister::operator < (const ConfigurationTimerRegister& ) const {
    return false;
}

inline ::asf::core::Payload* ConfigurationTimerRegister::clone() {
    return new ConfigurationTimerRegister(*this);
}

inline bool ConfigurationTimerRegister::operator > (const ConfigurationTimerRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ConfigurationTimerRegister::clear() {
}

inline  ConflictDetectedSignal::ConflictDetectedSignal ()  :
    _conflictdetected ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ConflictDetectedSignal::ConflictDetectedSignal (const ConflictDetectedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _conflictdetected ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ConflictDetectedSignal::ConflictDetectedSignal (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& conflictdetected_)  :
    _conflictdetected (conflictdetected_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ConflictDetectedSignal::~ConflictDetectedSignal() {
}

inline ConflictDetectedSignal& ConflictDetectedSignal::operator = (const ConflictDetectedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasConflictdetected()) {
            setConflictdetected(rhs.getConflictdetected());
        } else {
            clearConflictdetected();
        }
    }
    return *this;
}

inline bool ConflictDetectedSignal::operator == (const ConflictDetectedSignal& rhs) const {
    return (((!hasConflictdetected() && !rhs.hasConflictdetected()) || getConflictdetected() == rhs.getConflictdetected()));
}

inline bool ConflictDetectedSignal::operator != (const ConflictDetectedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool ConflictDetectedSignal::operator < (const ConflictDetectedSignal& rhs) const {
    if (hasConflictdetected() || rhs.hasConflictdetected()) {
        if (getConflictdetected() < rhs.getConflictdetected()) return true;
        if (getConflictdetected() > rhs.getConflictdetected()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ConflictDetectedSignal::clone() {
    return new ConflictDetectedSignal(*this);
}

inline bool ConflictDetectedSignal::operator > (const ConflictDetectedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ConflictDetectedSignal::clear() {
    clearConflictdetected();
}

inline void ConflictDetectedSignal::clearConflictdetected() {
    if (hasConflictdetected()) {
         clear_has_conflictdetected();
        _conflictdetected.clear();
     }
}

inline bool ConflictDetectedSignal::hasConflictdetected () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& ConflictDetectedSignal::getConflictdetected () const {
    return _conflictdetected;
}

inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& ConflictDetectedSignal::getConflictdetectedMutable () {
    set_has_conflictdetected();
    return _conflictdetected;
}

inline void ConflictDetectedSignal::setConflictdetected (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& conflictdetected_) {
    set_has_conflictdetected();
    this->_conflictdetected = conflictdetected_;
}

inline void ConflictDetectedSignal::set_has_conflictdetected () {
    _has_bits_[0] |= 1u << 0;
}

inline void ConflictDetectedSignal::clear_has_conflictdetected () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ConflictResolvedSignal::ConflictResolvedSignal ()  :
    _conflictresolved ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ConflictResolvedSignal::ConflictResolvedSignal (const ConflictResolvedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _conflictresolved ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ConflictResolvedSignal::ConflictResolvedSignal (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& conflictresolved_)  :
    _conflictresolved (conflictresolved_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ConflictResolvedSignal::~ConflictResolvedSignal() {
}

inline ConflictResolvedSignal& ConflictResolvedSignal::operator = (const ConflictResolvedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasConflictresolved()) {
            setConflictresolved(rhs.getConflictresolved());
        } else {
            clearConflictresolved();
        }
    }
    return *this;
}

inline bool ConflictResolvedSignal::operator == (const ConflictResolvedSignal& rhs) const {
    return (((!hasConflictresolved() && !rhs.hasConflictresolved()) || getConflictresolved() == rhs.getConflictresolved()));
}

inline bool ConflictResolvedSignal::operator != (const ConflictResolvedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool ConflictResolvedSignal::operator < (const ConflictResolvedSignal& rhs) const {
    if (hasConflictresolved() || rhs.hasConflictresolved()) {
        if (getConflictresolved() < rhs.getConflictresolved()) return true;
        if (getConflictresolved() > rhs.getConflictresolved()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ConflictResolvedSignal::clone() {
    return new ConflictResolvedSignal(*this);
}

inline bool ConflictResolvedSignal::operator > (const ConflictResolvedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ConflictResolvedSignal::clear() {
    clearConflictresolved();
}

inline void ConflictResolvedSignal::clearConflictresolved() {
    if (hasConflictresolved()) {
         clear_has_conflictresolved();
        _conflictresolved.clear();
     }
}

inline bool ConflictResolvedSignal::hasConflictresolved () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& ConflictResolvedSignal::getConflictresolved () const {
    return _conflictresolved;
}

inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& ConflictResolvedSignal::getConflictresolvedMutable () {
    set_has_conflictresolved();
    return _conflictresolved;
}

inline void ConflictResolvedSignal::setConflictresolved (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& conflictresolved_) {
    set_has_conflictresolved();
    this->_conflictresolved = conflictresolved_;
}

inline void ConflictResolvedSignal::set_has_conflictresolved () {
    _has_bits_[0] |= 1u << 0;
}

inline void ConflictResolvedSignal::clear_has_conflictresolved () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace conflictmanagement
} // namespace wbl
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_WBL_CONFLICTMANAGEMENT_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
