/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/wbl/LastIntendedMode.h"
#include "org/bosch/wbl/LastIntendedModeDBus.h"
#include "org/bosch/wbl/LastIntendedModeJson.h"
#include "org/bosch/wbl/LastIntendedModeStub.h"
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bosch {
namespace wbl {
namespace LastIntendedMode {

DEFINE_CLASS_LOGGER("//org/bosch/wbl/LastIntendedMode/org/bosch/wbl/LastIntendedMode", LastIntendedModeStub);


static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 16, "LastIntendedMode", 0 },
};

class LastIntendedModeStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    LastIntendedModeStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    LastIntendedModeStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    LastIntendedModeStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.bosch.wbl.LastIntendedMode"),
          _logger(logger) {}

    virtual ~LastIntendedModeStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void LastIntendedModeStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* LastIntendedModeStubDelegate::introspect() const {
    return     "<interface name=\"org.bosch.wbl.LastIntendedMode\">\n"
            "      <property access=\"read\" name=\"LastIntendedMode\" type=\"a(oa{sv})\"/>\n"
            "</interface>\n";
}

void LastIntendedModeStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<LastIntendedModeStub*>(getStub()))->onGetAll (properties);
}

void LastIntendedModeStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 1, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "LastIntendedMode");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void LastIntendedModeStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 1, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "LastIntendedMode");
            ::boost::shared_ptr< LastIntendedModeGet > payload(new LastIntendedModeGet());
            payload->setAct(act);
            static_cast<LastIntendedModeStub*>(getStub())->onLastIntendedModeGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

LastIntendedModeStub::LastIntendedModeStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new LastIntendedModeStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

LastIntendedModeStub::LastIntendedModeStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new LastIntendedModeStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

LastIntendedModeStub::~LastIntendedModeStub() {
    delete _stubDelegate;
}

void LastIntendedModeStub::sendLastIntendedModeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        LastIntendedModeUpdate payload(_LastIntendedModeProperty);

        LOG_INFO ("-> send%s", "LastIntendedModeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("LastIntendedMode", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.wbl.LastIntendedMode", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "LastIntendedModeUpdate");
    }
}

void LastIntendedModeStub::onLastIntendedModeGet(const ::boost::shared_ptr< LastIntendedModeGet >& lastIntendedMode) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "LastIntendedModeGet", lastIntendedMode->getAct());
    sendLastIntendedModeGetUpdate(_LastIntendedModeProperty.getLastIntendedMode(), lastIntendedMode->getAct());
}

void LastIntendedModeStub::sendLastIntendedModeGetUpdate(const ::std::vector< LastIntendedModeStruct >& lastIntendedMode, act_t act) {
    ::asf::dbus::DBusVariant variant;
    LastIntendedModeGet payload(lastIntendedMode);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "LastIntendedModeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void LastIntendedModeStub::setLastIntendedMode(const ::std::vector< LastIntendedModeStruct >& lastIntendedMode) {
    if(lastIntendedMode!=_LastIntendedModeProperty.getLastIntendedMode()) {
        _LastIntendedModeProperty.setLastIntendedMode(lastIntendedMode);
        sendLastIntendedModeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< LastIntendedModeStruct >& LastIntendedModeStub::getLastIntendedMode() const {
    return _LastIntendedModeProperty.getLastIntendedMode();
}

::std::vector< LastIntendedModeStruct >& LastIntendedModeStub::getLastIntendedModeMutable() {
    return _LastIntendedModeProperty.getLastIntendedModeMutable();
}

void LastIntendedModeStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'LastIntendedMode'
    {
        ::asf::dbus::DBusVariant variant;
        LastIntendedModeGet payload(_LastIntendedModeProperty.getLastIntendedMode());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("LastIntendedMode", variant));
    }
}

} // namespace LastIntendedMode
} // namespace wbl
} // namespace bosch
} // namespace org
