/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_WBL_LASTINTENDEDMODEPROXY_H
#define ORG_BOSCH_WBL_LASTINTENDEDMODEPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/nullable.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "org/bosch/wbl/LastIntendedMode.h"
#include <dbus/dbus.h>
#include <vector>

namespace org {
namespace bosch {
namespace wbl {
namespace LastIntendedMode {

class LastIntendedModeProxy;

class LastIntendedModeCallbackIF {
public:
    virtual ~LastIntendedModeCallbackIF() {}

    virtual void onLastIntendedModeError(const ::boost::shared_ptr< LastIntendedModeProxy >& proxy, const ::boost::shared_ptr< LastIntendedModeError >& error) = 0;

    virtual void onLastIntendedModeUpdate(const ::boost::shared_ptr< LastIntendedModeProxy >& proxy, const ::boost::shared_ptr< LastIntendedModeUpdate >& update) = 0;
};


/**
 * LastIntendedModeProxy is the client side representation of the D-Bus
 * service interface 'org.bosch.wbl.LastIntendedMode' (specified in file
 * org-bosch-wbl-lastintendedmode.xml).
 *
 * If the meaning of "org.bosch.wbl.LastIntendedMode" isn't clear, then there should be a description here.
 */
class LastIntendedModeProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of LastIntendedModeProxy.
     */
    static ::boost::shared_ptr< LastIntendedModeProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of LastIntendedModeProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< LastIntendedModeProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of LastIntendedModeProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< LastIntendedModeProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< LastIntendedModeProxy > proxyNew(new LastIntendedModeProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(true);
        return proxyNew;
    }

    virtual ~LastIntendedModeProxy ();



    // Property 'LastIntendedMode'

    /**
     * Notify on the property 'LastIntendedMode'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'LastIntendedMode'</b>:
     *
     * If the meaning of "LastIntendedMode" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendLastIntendedModeRegister(LastIntendedModeCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'LastIntendedMode'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'LastIntendedMode'</b>:
     *
     * If the meaning of "LastIntendedMode" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendLastIntendedModeRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendLastIntendedModeDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'LastIntendedMode'.
     */
    void sendLastIntendedModeDeregisterAll() const;

    /**
     * Request the value of the property 'LastIntendedMode' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'LastIntendedMode'</b>:
     *
     * If the meaning of "LastIntendedMode" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendLastIntendedModeGet(LastIntendedModeCallbackIF& cb);


    /**
     * Returns the current value of the property 'LastIntendedMode' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasLastIntendedMode() returns true.
     *
     * @return the previously received value of the property 'LastIntendedMode'.
     */
    const ::std::vector< LastIntendedModeStruct >& getLastIntendedMode() const;

    /**
     * Determines whether a status message for the property 'LastIntendedMode'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasLastIntendedMode() const;


    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    LastIntendedModeProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;

    virtual void clearAllProperties ();

    // Property 'LastIntendedMode'

    ::asf::core::nullable< LastIntendedModeUpdate > _lastIntendedMode;

    DECLARE_CLASS_LOGGER();

    friend class LastIntendedModeProxyCallback;
};

} // namespace LastIntendedMode
} // namespace wbl
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_WBL_LASTINTENDEDMODEPROXY_H
