/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/wapdman/Manager.h"
#include "org/bosch/wapdman/ManagerDBus.h"
#include "org/bosch/wapdman/ManagerJson.h"
#include "org/bosch/wapdman/ManagerStub.h"
#include <string>
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bosch {
namespace wapdman {
namespace Manager {

DEFINE_CLASS_LOGGER("//org/bosch/wapdman/Manager/org/bosch/wapdman/Manager", ManagerStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 13, "RegisterAgent", 1 },
    { 15, "FindAccessPoint", 0 },
    { 15, "GetAccessPoints", 3 },
    { 15, "UnregisterAgent", 2 },
};


class ManagerStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    ManagerStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    ManagerStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    ManagerStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.bosch.wapdman.Manager"),
          _logger(logger) {}

    virtual ~ManagerStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void ManagerStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 4, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'FindAccessPoint'

            LOG_DEBUG_STUB("process method '%s'", "FindAccessPoint");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FindAccessPointRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "FindAccessPoint", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< FindAccessPointRequest > payload = ::boost::static_pointer_cast<FindAccessPointRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onFindAccessPointRequest(payload);
            return;
        }
        case 1: {

            // method 'RegisterAgent'

            LOG_DEBUG_STUB("process method '%s'", "RegisterAgent");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RegisterAgentRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RegisterAgent", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RegisterAgentRequest > payload = ::boost::static_pointer_cast<RegisterAgentRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onRegisterAgentRequest(payload);
            return;
        }
        case 2: {

            // method 'UnregisterAgent'

            LOG_DEBUG_STUB("process method '%s'", "UnregisterAgent");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UnregisterAgentRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "UnregisterAgent", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< UnregisterAgentRequest > payload = ::boost::static_pointer_cast<UnregisterAgentRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onUnregisterAgentRequest(payload);
            return;
        }
        case 3: {

            // method 'GetAccessPoints'

            LOG_DEBUG_STUB("process method '%s'", "GetAccessPoints");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetAccessPointsRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetAccessPoints", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetAccessPointsRequest > payload = ::boost::static_pointer_cast<GetAccessPointsRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onGetAccessPointsRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* ManagerStubDelegate::introspect() const {
    return     "<interface name=\"org.bosch.wapdman.Manager\">\n"
            "      <method name=\"FindAccessPoint\">\n"
            "        <arg direction=\"in\" name=\"pattern\" type=\"s\"/>\n"
            "        <arg direction=\"out\" name=\"accesspoint\" type=\"o\"/>\n"
            "      </method>\n"
            "      <method name=\"RegisterAgent\">\n"
            "        <arg direction=\"in\" name=\"path\" type=\"o\"/>\n"
            "      </method>\n"
            "      <method name=\"UnregisterAgent\">\n"
            "        <arg direction=\"in\" name=\"path\" type=\"o\"/>\n"
            "      </method>\n"
            "      <method name=\"GetAccessPoints\">\n"
            "        <arg direction=\"out\" name=\"accesspoints\" type=\"a(oa{sv})\"/>\n"
            "      </method>\n"
            "      <signal name=\"AccessPointAdded\">\n"
            "        <arg name=\"accesspoint\" type=\"o\"/>\n"
            "      </signal>\n"
            "      <signal name=\"AccessPointRemoved\">\n"
            "        <arg name=\"accesspoint\" type=\"o\"/>\n"
            "      </signal>\n"
            "</interface>\n";
}

void ManagerStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<ManagerStub*>(getStub()))->onGetAll (properties);
}

void ManagerStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void ManagerStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

ManagerStub::ManagerStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new ManagerStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

ManagerStub::ManagerStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new ManagerStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

ManagerStub::~ManagerStub() {
    delete _stubDelegate;
}

void ManagerStub::sendAccessPointAddedSignal(const ::std::string& accesspoint) {
    if (_stubDelegate->isConnected()) {
        AccessPointAddedSignal* payload = new AccessPointAddedSignal(accesspoint);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "AccessPointAdded", AccessPointAddedSignal, payload)
        LOG_INFO ("-> send%sSignal", "AccessPointAdded");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "AccessPointAdded");
    }
}

void ManagerStub::sendAccessPointRemovedSignal(const ::std::string& accesspoint) {
    if (_stubDelegate->isConnected()) {
        AccessPointRemovedSignal* payload = new AccessPointRemovedSignal(accesspoint);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "AccessPointRemoved", AccessPointRemovedSignal, payload)
        LOG_INFO ("-> send%sSignal", "AccessPointRemoved");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "AccessPointRemoved");
    }
}

void  ManagerStub::sendFindAccessPointResponse (const ::std::string& accesspoint, act_t act) {
    FindAccessPointResponse* payload = new FindAccessPointResponse(accesspoint);
    DBUS_MESSAGE_REPLY(dbusMessage, "FindAccessPoint", FindAccessPointResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "FindAccessPoint", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendFindAccessPointError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    FindAccessPointError* payload = new FindAccessPointError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "FindAccessPoint", FindAccessPointError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "FindAccessPoint", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendRegisterAgentResponse (act_t act) {
    RegisterAgentResponse* payload = new RegisterAgentResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "RegisterAgent", RegisterAgentResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RegisterAgent", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendRegisterAgentError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RegisterAgentError* payload = new RegisterAgentError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "RegisterAgent", RegisterAgentError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RegisterAgent", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendUnregisterAgentResponse (act_t act) {
    UnregisterAgentResponse* payload = new UnregisterAgentResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "UnregisterAgent", UnregisterAgentResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "UnregisterAgent", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendUnregisterAgentError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    UnregisterAgentError* payload = new UnregisterAgentError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "UnregisterAgent", UnregisterAgentError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "UnregisterAgent", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendGetAccessPointsResponse (const ::std::vector< GetAccessPointsResponseAccesspointsStruct >& accesspoints, act_t act) {
    GetAccessPointsResponse* payload = new GetAccessPointsResponse(accesspoints);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetAccessPoints", GetAccessPointsResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetAccessPoints", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendGetAccessPointsError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetAccessPointsError* payload = new GetAccessPointsError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetAccessPoints", GetAccessPointsError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetAccessPoints", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void ManagerStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace Manager
} // namespace wapdman
} // namespace bosch
} // namespace org
