/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/wapdman/AssociatedStation.h"
#include "org/bosch/wapdman/AssociatedStationDBus.h"
#include "org/bosch/wapdman/AssociatedStationJson.h"
#include "org/bosch/wapdman/AssociatedStationProxy.h"
#include <string>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bosch {
namespace wapdman {
namespace AssociatedStation {

DEFINE_CLASS_LOGGER("//org/bosch/wapdman/accesspoint_XX_XX_XX_XX_XX_XX/AssociatedStation_XX_XX_XX_XX_XX_XX/org/bosch/wapdman/AssociatedStation", AssociatedStationProxy);

class AssociatedStationProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    AssociatedStationProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< AssociatedStationProxy >& proxyShared = ::boost::static_pointer_cast< AssociatedStationProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_MacAddress:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MacAddressError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "MacAddress", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MacAddressError> payload = ::boost::static_pointer_cast<MacAddressError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((MacAddressCallbackIF*) _callback)->onMacAddressError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MacAddressUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "MacAddress", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MacAddressUpdate> payload = ::boost::static_pointer_cast<MacAddressUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((MacAddressCallbackIF*) _callback)->onMacAddressUpdate(proxyShared, payload);
                        proxyShared->_macAddress = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Accesspoint:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AccesspointError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Accesspoint", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AccesspointError> payload = ::boost::static_pointer_cast<AccesspointError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((AccesspointCallbackIF*) _callback)->onAccesspointError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AccesspointUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Accesspoint", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AccesspointUpdate> payload = ::boost::static_pointer_cast<AccesspointUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((AccesspointCallbackIF*) _callback)->onAccesspointUpdate(proxyShared, payload);
                        proxyShared->_accesspoint = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Interface:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), InterfaceError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Interface", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<InterfaceError> payload = ::boost::static_pointer_cast<InterfaceError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((InterfaceCallbackIF*) _callback)->onInterfaceError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), InterfaceUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Interface", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<InterfaceUpdate> payload = ::boost::static_pointer_cast<InterfaceUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((InterfaceCallbackIF*) _callback)->onInterfaceUpdate(proxyShared, payload);
                        proxyShared->_interface = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_IPAddress:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), IPAddressError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "IPAddress", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<IPAddressError> payload = ::boost::static_pointer_cast<IPAddressError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((IPAddressCallbackIF*) _callback)->onIPAddressError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), IPAddressUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "IPAddress", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<IPAddressUpdate> payload = ::boost::static_pointer_cast<IPAddressUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((IPAddressCallbackIF*) _callback)->onIPAddressUpdate(proxyShared, payload);
                        proxyShared->_iPAddress = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Hostname:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), HostnameError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Hostname", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<HostnameError> payload = ::boost::static_pointer_cast<HostnameError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((HostnameCallbackIF*) _callback)->onHostnameError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), HostnameUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Hostname", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<HostnameUpdate> payload = ::boost::static_pointer_cast<HostnameUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((HostnameCallbackIF*) _callback)->onHostnameUpdate(proxyShared, payload);
                        proxyShared->_hostname = *payload.get();
                        return true;
                    }
                }
                break;
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_MacAddress: {
                ::boost::shared_ptr< MacAddressError > payload = ::boost::shared_ptr< MacAddressError >
                (new MacAddressError(DBUS_ERROR_NO_SERVER, "The DBus service AssociatedStation is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "MacAddress", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AssociatedStationProxy> proxyShared = ::boost::static_pointer_cast<AssociatedStationProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((MacAddressCallbackIF*) _callback)->onMacAddressError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Accesspoint: {
                ::boost::shared_ptr< AccesspointError > payload = ::boost::shared_ptr< AccesspointError >
                (new AccesspointError(DBUS_ERROR_NO_SERVER, "The DBus service AssociatedStation is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Accesspoint", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AssociatedStationProxy> proxyShared = ::boost::static_pointer_cast<AssociatedStationProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AccesspointCallbackIF*) _callback)->onAccesspointError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Interface: {
                ::boost::shared_ptr< InterfaceError > payload = ::boost::shared_ptr< InterfaceError >
                (new InterfaceError(DBUS_ERROR_NO_SERVER, "The DBus service AssociatedStation is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Interface", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AssociatedStationProxy> proxyShared = ::boost::static_pointer_cast<AssociatedStationProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((InterfaceCallbackIF*) _callback)->onInterfaceError (proxyShared,payload);
                return true;
            }
            break;
            case ID_IPAddress: {
                ::boost::shared_ptr< IPAddressError > payload = ::boost::shared_ptr< IPAddressError >
                (new IPAddressError(DBUS_ERROR_NO_SERVER, "The DBus service AssociatedStation is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "IPAddress", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AssociatedStationProxy> proxyShared = ::boost::static_pointer_cast<AssociatedStationProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((IPAddressCallbackIF*) _callback)->onIPAddressError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Hostname: {
                ::boost::shared_ptr< HostnameError > payload = ::boost::shared_ptr< HostnameError >
                (new HostnameError(DBUS_ERROR_NO_SERVER, "The DBus service AssociatedStation is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Hostname", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AssociatedStationProxy> proxyShared = ::boost::static_pointer_cast<AssociatedStationProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((HostnameCallbackIF*) _callback)->onHostnameError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& AssociatedStationProxyCallback::_logger (AssociatedStationProxy::_logger);

AssociatedStationProxy::AssociatedStationProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.bosch.wapdman.AssociatedStation", serviceAvailable, _logger) {
}

AssociatedStationProxy::~AssociatedStationProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< AssociatedStationProxy > AssociatedStationProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<AssociatedStationProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< AssociatedStationProxy > proxyNew(new AssociatedStationProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t AssociatedStationProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    AssociatedStationProxyCallback* callback = new AssociatedStationProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t AssociatedStationProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    AssociatedStationProxyCallback* callback = new AssociatedStationProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void AssociatedStationProxy::clearAllProperties ()
{
    _macAddress = ::asf::core::nullable< MacAddressUpdate >();
    _accesspoint = ::asf::core::nullable< AccesspointUpdate >();
    _interface = ::asf::core::nullable< InterfaceUpdate >();
    _iPAddress = ::asf::core::nullable< IPAddressUpdate >();
    _hostname = ::asf::core::nullable< HostnameUpdate >();
}

void AssociatedStationProxy::sendDeregisterAll () const
{
    sendMacAddressDeregisterAll();
    sendAccesspointDeregisterAll();
    sendInterfaceDeregisterAll();
    sendIPAddressDeregisterAll();
    sendHostnameDeregisterAll();
}

act_t AssociatedStationProxy::sendMacAddressRegister(MacAddressCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_MacAddress, "MacAddress", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "MacAddress", &cb, act);
    return act;
}

bool AssociatedStationProxy::sendMacAddressDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("MacAddress", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "MacAddress", act, static_cast<int>(rv));
    return rv;
}

act_t AssociatedStationProxy::sendMacAddressGet(MacAddressCallbackIF& cb) {
    AssociatedStationProxyCallback* callback = new AssociatedStationProxyCallback(ID_MacAddress, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "MacAddress", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("MacAddress", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& AssociatedStationProxy::getMacAddress() const {
    return _macAddress.get().getMacAddress();
}

bool AssociatedStationProxy::hasMacAddress() const {
    return _macAddress.hasValue();
}

void AssociatedStationProxy::sendMacAddressDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "MacAddress");
    _dbusProxyDelegate->deregisterSignalCallback("MacAddress", 0, _dbusDaemonProxy.get(), true);
}

act_t AssociatedStationProxy::sendAccesspointRegister(AccesspointCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Accesspoint, "Accesspoint", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Accesspoint", &cb, act);
    return act;
}

bool AssociatedStationProxy::sendAccesspointDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Accesspoint", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Accesspoint", act, static_cast<int>(rv));
    return rv;
}

act_t AssociatedStationProxy::sendAccesspointGet(AccesspointCallbackIF& cb) {
    AssociatedStationProxyCallback* callback = new AssociatedStationProxyCallback(ID_Accesspoint, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Accesspoint", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Accesspoint", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& AssociatedStationProxy::getAccesspoint() const {
    return _accesspoint.get().getAccesspoint();
}

bool AssociatedStationProxy::hasAccesspoint() const {
    return _accesspoint.hasValue();
}

void AssociatedStationProxy::sendAccesspointDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Accesspoint");
    _dbusProxyDelegate->deregisterSignalCallback("Accesspoint", 0, _dbusDaemonProxy.get(), true);
}

act_t AssociatedStationProxy::sendInterfaceRegister(InterfaceCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Interface, "Interface", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Interface", &cb, act);
    return act;
}

bool AssociatedStationProxy::sendInterfaceDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Interface", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Interface", act, static_cast<int>(rv));
    return rv;
}

act_t AssociatedStationProxy::sendInterfaceGet(InterfaceCallbackIF& cb) {
    AssociatedStationProxyCallback* callback = new AssociatedStationProxyCallback(ID_Interface, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Interface", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Interface", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& AssociatedStationProxy::getInterface() const {
    return _interface.get().getInterface();
}

bool AssociatedStationProxy::hasInterface() const {
    return _interface.hasValue();
}

void AssociatedStationProxy::sendInterfaceDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Interface");
    _dbusProxyDelegate->deregisterSignalCallback("Interface", 0, _dbusDaemonProxy.get(), true);
}

act_t AssociatedStationProxy::sendIPAddressRegister(IPAddressCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_IPAddress, "IPAddress", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "IPAddress", &cb, act);
    return act;
}

bool AssociatedStationProxy::sendIPAddressDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("IPAddress", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "IPAddress", act, static_cast<int>(rv));
    return rv;
}

act_t AssociatedStationProxy::sendIPAddressGet(IPAddressCallbackIF& cb) {
    AssociatedStationProxyCallback* callback = new AssociatedStationProxyCallback(ID_IPAddress, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "IPAddress", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("IPAddress", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& AssociatedStationProxy::getIPAddress() const {
    return _iPAddress.get().getIPAddress();
}

bool AssociatedStationProxy::hasIPAddress() const {
    return _iPAddress.hasValue();
}

void AssociatedStationProxy::sendIPAddressDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "IPAddress");
    _dbusProxyDelegate->deregisterSignalCallback("IPAddress", 0, _dbusDaemonProxy.get(), true);
}

act_t AssociatedStationProxy::sendHostnameRegister(HostnameCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Hostname, "Hostname", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Hostname", &cb, act);
    return act;
}

bool AssociatedStationProxy::sendHostnameDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Hostname", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Hostname", act, static_cast<int>(rv));
    return rv;
}

act_t AssociatedStationProxy::sendHostnameGet(HostnameCallbackIF& cb) {
    AssociatedStationProxyCallback* callback = new AssociatedStationProxyCallback(ID_Hostname, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Hostname", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Hostname", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& AssociatedStationProxy::getHostname() const {
    return _hostname.get().getHostname();
}

bool AssociatedStationProxy::hasHostname() const {
    return _hostname.hasValue();
}

void AssociatedStationProxy::sendHostnameDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Hostname");
    _dbusProxyDelegate->deregisterSignalCallback("Hostname", 0, _dbusDaemonProxy.get(), true);
}

} // namespace AssociatedStation
} // namespace wapdman
} // namespace bosch
} // namespace org
