/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/stream/json.h"
#include "org/bosch/wapdman/Accesspoint.h"
#include "org/bosch/wapdman/AccesspointJson.h"
#include "org/bosch/wapdman/AccesspointJsonPrivate.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstring>
#include <map>
#include <string>
#include <vector>

using namespace ::asf::stream::json;


// Json serialization of "SetSSIDRequest"

void serializeJson (const ::org::bosch::wapdman::Accesspoint::SetSSIDRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSsid()) {
        yajl_gen_string(g, (const unsigned char*)  "ssid" , 4);
        yajl_gen_array_open(g);
        const ::std::vector< uint8 >& o1 = value.getSsid();
        {
            ::std::vector< uint8 >::const_iterator o0;
            for (o0 = o1.begin(); o0 != o1.end(); ++o0) {
                yajl_gen_integer(g, (long long)(*o0));
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasUtf_ssid()) {
        yajl_gen_string(g, (const unsigned char*)  "utf_ssid" , 8);
        yajl_gen_bool(g, (bool)value.getUtf_ssid());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::wapdman::Accesspoint::SetSSIDRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeAuthenticateStationRequest"

void serializeJson (const ::org::bosch::wapdman::Accesspoint::DeAuthenticateStationRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAddress()) {
        yajl_gen_string(g, (const unsigned char*)  "address" , 7);
        const char *s = value.getAddress().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::wapdman::Accesspoint::DeAuthenticateStationRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "BlacklistStationRequest"

void serializeJson (const ::org::bosch::wapdman::Accesspoint::BlacklistStationRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAddress()) {
        yajl_gen_string(g, (const unsigned char*)  "address" , 7);
        const char *s = value.getAddress().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasAllow()) {
        yajl_gen_string(g, (const unsigned char*)  "allow" , 5);
        yajl_gen_bool(g, (bool)value.getAllow());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::wapdman::Accesspoint::BlacklistStationRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetOperatingChannelsRequest"

void serializeJson (const ::org::bosch::wapdman::Accesspoint::SetOperatingChannelsRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasChannels()) {
        yajl_gen_string(g, (const unsigned char*)  "channels" , 8);
        yajl_gen_array_open(g);
        const ::std::vector< uint16 >& o3 = value.getChannels();
        {
            ::std::vector< uint16 >::const_iterator o2;
            for (o2 = o3.begin(); o2 != o3.end(); ++o2) {
                yajl_gen_integer(g, (long long)(*o2));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::wapdman::Accesspoint::SetOperatingChannelsRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetAssociatedStationsResponse"

void serializeJson (const ::org::bosch::wapdman::Accesspoint::GetAssociatedStationsResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAssociatedstations()) {
        yajl_gen_string(g, (const unsigned char*)  "associatedstations" , 18);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::bosch::wapdman::Accesspoint::GetAssociatedStationsResponseAssociatedstationsStruct >& o5 = value.getAssociatedstations();
        {
            ::std::vector< ::org::bosch::wapdman::Accesspoint::GetAssociatedStationsResponseAssociatedstationsStruct >::const_iterator o4;
            for (o4 = o5.begin(); o4 != o5.end(); ++o4) {
                serializeJson((*o4), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::wapdman::Accesspoint::GetAssociatedStationsResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RegisterVendorServiceRequest"

void serializeJson (const ::org::bosch::wapdman::Accesspoint::RegisterVendorServiceRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasIEs()) {
        yajl_gen_string(g, (const unsigned char*)  "IEs" , 3);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::vector< uint8 > >& o7 = value.getIEs();
        {
            ::std::vector< ::std::vector< uint8 > >::const_iterator o6;
            for (o6 = o7.begin(); o6 != o7.end(); ++o6) {
                yajl_gen_array_open(g);
                const ::std::vector< uint8 >& o9 = (*o6);
                {
                    ::std::vector< uint8 >::const_iterator o8;
                    for (o8 = o9.begin(); o8 != o9.end(); ++o8) {
                        yajl_gen_integer(g, (long long)(*o8));
                    }
                }
                yajl_gen_array_close(g);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::wapdman::Accesspoint::RegisterVendorServiceRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UnregisterVendorServiceRequest"

void serializeJson (const ::org::bosch::wapdman::Accesspoint::UnregisterVendorServiceRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasIEs()) {
        yajl_gen_string(g, (const unsigned char*)  "IEs" , 3);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::vector< uint8 > >& o11 = value.getIEs();
        {
            ::std::vector< ::std::vector< uint8 > >::const_iterator o10;
            for (o10 = o11.begin(); o10 != o11.end(); ++o10) {
                yajl_gen_array_open(g);
                const ::std::vector< uint8 >& o13 = (*o10);
                {
                    ::std::vector< uint8 >::const_iterator o12;
                    for (o12 = o13.begin(); o12 != o13.end(); ++o12) {
                        yajl_gen_integer(g, (long long)(*o12));
                    }
                }
                yajl_gen_array_close(g);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::wapdman::Accesspoint::UnregisterVendorServiceRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetDnsDhcpConfResponse"

void serializeJson (const ::org::bosch::wapdman::Accesspoint::GetDnsDhcpConfResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDnsdhcpserverconf()) {
        yajl_gen_string(g, (const unsigned char*)  "dnsdhcpserverconf" , 17);
        serializeJson(value.getDnsdhcpserverconf(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::wapdman::Accesspoint::GetDnsDhcpConfResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MacAddressUpdate"

void serializeJson (const ::org::bosch::wapdman::Accesspoint::MacAddressUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasMacAddress()) {
        yajl_gen_string(g, (const unsigned char*)  "MacAddress" , 10);
        const char *s = value.getMacAddress().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::wapdman::Accesspoint::MacAddressUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MacAddressRegister"

void serializeJson (const ::org::bosch::wapdman::Accesspoint::MacAddressRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::wapdman::Accesspoint::MacAddressRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SSIDUpdate"

void serializeJson (const ::org::bosch::wapdman::Accesspoint::SSIDUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSSID()) {
        yajl_gen_string(g, (const unsigned char*)  "SSID" , 4);
        yajl_gen_array_open(g);
        const ::std::vector< uint8 >& o15 = value.getSSID();
        {
            ::std::vector< uint8 >::const_iterator o14;
            for (o14 = o15.begin(); o14 != o15.end(); ++o14) {
                yajl_gen_integer(g, (long long)(*o14));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::wapdman::Accesspoint::SSIDUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SSIDRegister"

void serializeJson (const ::org::bosch::wapdman::Accesspoint::SSIDRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::wapdman::Accesspoint::SSIDRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "InterfaceUpdate"

void serializeJson (const ::org::bosch::wapdman::Accesspoint::InterfaceUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasInterface()) {
        yajl_gen_string(g, (const unsigned char*)  "Interface" , 9);
        const char *s = value.getInterface().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::wapdman::Accesspoint::InterfaceUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "InterfaceRegister"

void serializeJson (const ::org::bosch::wapdman::Accesspoint::InterfaceRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::wapdman::Accesspoint::InterfaceRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "BlackListedStationsUpdate"

void serializeJson (const ::org::bosch::wapdman::Accesspoint::BlackListedStationsUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBlackListedStations()) {
        yajl_gen_string(g, (const unsigned char*)  "BlackListedStations" , 19);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o17 = value.getBlackListedStations();
        {
            ::std::vector< ::std::string >::const_iterator o16;
            for (o16 = o17.begin(); o16 != o17.end(); ++o16) {
                const char *s = (*o16).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::wapdman::Accesspoint::BlackListedStationsUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "BlackListedStationsRegister"

void serializeJson (const ::org::bosch::wapdman::Accesspoint::BlackListedStationsRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::wapdman::Accesspoint::BlackListedStationsRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PowerStateUpdate"

void serializeJson (const ::org::bosch::wapdman::Accesspoint::PowerStateUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPowerState()) {
        yajl_gen_string(g, (const unsigned char*)  "PowerState" , 10);
        const char *s = value.getPowerState().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::wapdman::Accesspoint::PowerStateUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PowerStateRegister"

void serializeJson (const ::org::bosch::wapdman::Accesspoint::PowerStateRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::wapdman::Accesspoint::PowerStateRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PowerFailureReasonUpdate"

void serializeJson (const ::org::bosch::wapdman::Accesspoint::PowerFailureReasonUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPowerFailureReason()) {
        yajl_gen_string(g, (const unsigned char*)  "PowerFailureReason" , 18);
        const char *s = value.getPowerFailureReason().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::wapdman::Accesspoint::PowerFailureReasonUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PowerFailureReasonRegister"

void serializeJson (const ::org::bosch::wapdman::Accesspoint::PowerFailureReasonRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::wapdman::Accesspoint::PowerFailureReasonRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PoweredUpdate"

void serializeJson (const ::org::bosch::wapdman::Accesspoint::PoweredUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPowered()) {
        yajl_gen_string(g, (const unsigned char*)  "Powered" , 7);
        yajl_gen_bool(g, (bool)value.getPowered());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::wapdman::Accesspoint::PoweredUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PoweredRegister"

void serializeJson (const ::org::bosch::wapdman::Accesspoint::PoweredRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::wapdman::Accesspoint::PoweredRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "HiddenUpdate"

void serializeJson (const ::org::bosch::wapdman::Accesspoint::HiddenUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasHidden()) {
        yajl_gen_string(g, (const unsigned char*)  "Hidden" , 6);
        yajl_gen_bool(g, (bool)value.getHidden());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::wapdman::Accesspoint::HiddenUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "HiddenRegister"

void serializeJson (const ::org::bosch::wapdman::Accesspoint::HiddenRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::wapdman::Accesspoint::HiddenRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SecurityUpdate"

void serializeJson (const ::org::bosch::wapdman::Accesspoint::SecurityUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSecurity()) {
        yajl_gen_string(g, (const unsigned char*)  "Security" , 8);
        const char *s = value.getSecurity().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::wapdman::Accesspoint::SecurityUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SecurityRegister"

void serializeJson (const ::org::bosch::wapdman::Accesspoint::SecurityRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::wapdman::Accesspoint::SecurityRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PassphraseUpdate"

void serializeJson (const ::org::bosch::wapdman::Accesspoint::PassphraseUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPassphrase()) {
        yajl_gen_string(g, (const unsigned char*)  "Passphrase" , 10);
        const char *s = value.getPassphrase().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::wapdman::Accesspoint::PassphraseUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PassphraseRegister"

void serializeJson (const ::org::bosch::wapdman::Accesspoint::PassphraseRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::wapdman::Accesspoint::PassphraseRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CurrentOperatingChannelUpdate"

void serializeJson (const ::org::bosch::wapdman::Accesspoint::CurrentOperatingChannelUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCurrentOperatingChannel()) {
        yajl_gen_string(g, (const unsigned char*)  "CurrentOperatingChannel" , 23);
        yajl_gen_integer(g, (long long)value.getCurrentOperatingChannel());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::wapdman::Accesspoint::CurrentOperatingChannelUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CurrentOperatingChannelRegister"

void serializeJson (const ::org::bosch::wapdman::Accesspoint::CurrentOperatingChannelRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::wapdman::Accesspoint::CurrentOperatingChannelRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "HWFeaturesUpdate"

void serializeJson (const ::org::bosch::wapdman::Accesspoint::HWFeaturesUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasHWFeatures()) {
        yajl_gen_string(g, (const unsigned char*)  "HWFeatures" , 10);
        yajl_gen_map_open(g);
        const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& o19 = value.getHWFeatures();
        {
            ::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o18;
            for (o18 = o19.begin(); o18 != o19.end(); ++o18) {
                {
                    const char *s = o18->first.c_str();
                    genStringAndCheck(g, (const unsigned char*) s , strlen(s));
                }
                {
                    yajl_gen_null(g);
                }
            }
        }
        yajl_gen_map_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::wapdman::Accesspoint::HWFeaturesUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "HWFeaturesRegister"

void serializeJson (const ::org::bosch::wapdman::Accesspoint::HWFeaturesRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::wapdman::Accesspoint::HWFeaturesRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MaximumStationsAllowedUpdate"

void serializeJson (const ::org::bosch::wapdman::Accesspoint::MaximumStationsAllowedUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasMaximumStationsAllowed()) {
        yajl_gen_string(g, (const unsigned char*)  "MaximumStationsAllowed" , 22);
        yajl_gen_integer(g, (long long)value.getMaximumStationsAllowed());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::wapdman::Accesspoint::MaximumStationsAllowedUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MaximumStationsAllowedRegister"

void serializeJson (const ::org::bosch::wapdman::Accesspoint::MaximumStationsAllowedRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::wapdman::Accesspoint::MaximumStationsAllowedRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CountryCodeUpdate"

void serializeJson (const ::org::bosch::wapdman::Accesspoint::CountryCodeUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCountryCode()) {
        yajl_gen_string(g, (const unsigned char*)  "CountryCode" , 11);
        const char *s = value.getCountryCode().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::wapdman::Accesspoint::CountryCodeUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CountryCodeRegister"

void serializeJson (const ::org::bosch::wapdman::Accesspoint::CountryCodeRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::wapdman::Accesspoint::CountryCodeRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SupportedChannelsUpdate"

void serializeJson (const ::org::bosch::wapdman::Accesspoint::SupportedChannelsUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSupportedChannels()) {
        yajl_gen_string(g, (const unsigned char*)  "SupportedChannels" , 17);
        yajl_gen_map_open(g);
        const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& o21 = value.getSupportedChannels();
        {
            ::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o20;
            for (o20 = o21.begin(); o20 != o21.end(); ++o20) {
                {
                    const char *s = o20->first.c_str();
                    genStringAndCheck(g, (const unsigned char*) s , strlen(s));
                }
                {
                    yajl_gen_null(g);
                }
            }
        }
        yajl_gen_map_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::wapdman::Accesspoint::SupportedChannelsUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SupportedChannelsRegister"

void serializeJson (const ::org::bosch::wapdman::Accesspoint::SupportedChannelsRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::wapdman::Accesspoint::SupportedChannelsRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AccessNetworkTypeUpdate"

void serializeJson (const ::org::bosch::wapdman::Accesspoint::AccessNetworkTypeUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAccessNetworkType()) {
        yajl_gen_string(g, (const unsigned char*)  "AccessNetworkType" , 17);
        yajl_gen_integer(g, (long long)value.getAccessNetworkType());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::wapdman::Accesspoint::AccessNetworkTypeUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AccessNetworkTypeRegister"

void serializeJson (const ::org::bosch::wapdman::Accesspoint::AccessNetworkTypeRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::wapdman::Accesspoint::AccessNetworkTypeRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AssociatedStationsChangedSignal"

void serializeJson (const ::org::bosch::wapdman::Accesspoint::AssociatedStationsChangedSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasChangedstations()) {
        yajl_gen_string(g, (const unsigned char*)  "changedstations" , 15);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::bosch::wapdman::Accesspoint::AssociatedStationsChangedSignalChangedstationsStruct >& o23 = value.getChangedstations();
        {
            ::std::vector< ::org::bosch::wapdman::Accesspoint::AssociatedStationsChangedSignalChangedstationsStruct >::const_iterator o22;
            for (o22 = o23.begin(); o22 != o23.end(); ++o22) {
                serializeJson((*o22), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasRemovedstations()) {
        yajl_gen_string(g, (const unsigned char*)  "removedstations" , 15);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o25 = value.getRemovedstations();
        {
            ::std::vector< ::std::string >::const_iterator o24;
            for (o24 = o25.begin(); o24 != o25.end(); ++o24) {
                const char *s = (*o24).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::wapdman::Accesspoint::AssociatedStationsChangedSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AssociationRequestRejectedSignal"

void serializeJson (const ::org::bosch::wapdman::Accesspoint::AssociationRequestRejectedSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStation()) {
        yajl_gen_string(g, (const unsigned char*)  "station" , 7);
        yajl_gen_map_open(g);
        const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& o27 = value.getStation();
        {
            ::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o26;
            for (o26 = o27.begin(); o26 != o27.end(); ++o26) {
                {
                    const char *s = o26->first.c_str();
                    genStringAndCheck(g, (const unsigned char*) s , strlen(s));
                }
                {
                    yajl_gen_null(g);
                }
            }
        }
        yajl_gen_map_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::wapdman::Accesspoint::AssociationRequestRejectedSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetAssociatedStationsResponseAssociatedstationsStruct"

void serializeJson (const ::org::bosch::wapdman::Accesspoint::GetAssociatedStationsResponseAssociatedstationsStruct& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasElem1()) {
        yajl_gen_string(g, (const unsigned char*)  "elem1" , 5);
        const char *s = value.getElem1().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasElem2()) {
        yajl_gen_string(g, (const unsigned char*)  "elem2" , 5);
        yajl_gen_map_open(g);
        const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& o29 = value.getElem2();
        {
            ::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o28;
            for (o28 = o29.begin(); o28 != o29.end(); ++o28) {
                {
                    const char *s = o28->first.c_str();
                    genStringAndCheck(g, (const unsigned char*) s , strlen(s));
                }
                {
                    yajl_gen_null(g);
                }
            }
        }
        yajl_gen_map_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::wapdman::Accesspoint::GetAssociatedStationsResponseAssociatedstationsStruct& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetDnsDhcpConfResponseDnsdhcpserverconfStruct"

void serializeJson (const ::org::bosch::wapdman::Accesspoint::GetDnsDhcpConfResponseDnsdhcpserverconfStruct& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasElem1()) {
        yajl_gen_string(g, (const unsigned char*)  "elem1" , 5);
        const char *s = value.getElem1().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasElem2()) {
        yajl_gen_string(g, (const unsigned char*)  "elem2" , 5);
        yajl_gen_map_open(g);
        const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& o31 = value.getElem2();
        {
            ::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o30;
            for (o30 = o31.begin(); o30 != o31.end(); ++o30) {
                {
                    const char *s = o30->first.c_str();
                    genStringAndCheck(g, (const unsigned char*) s , strlen(s));
                }
                {
                    yajl_gen_null(g);
                }
            }
        }
        yajl_gen_map_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::wapdman::Accesspoint::GetDnsDhcpConfResponseDnsdhcpserverconfStruct& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AssociatedStationsChangedSignalChangedstationsStruct"

void serializeJson (const ::org::bosch::wapdman::Accesspoint::AssociatedStationsChangedSignalChangedstationsStruct& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasElem1()) {
        yajl_gen_string(g, (const unsigned char*)  "elem1" , 5);
        const char *s = value.getElem1().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasElem2()) {
        yajl_gen_string(g, (const unsigned char*)  "elem2" , 5);
        yajl_gen_map_open(g);
        const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& o33 = value.getElem2();
        {
            ::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o32;
            for (o32 = o33.begin(); o32 != o33.end(); ++o32) {
                {
                    const char *s = o32->first.c_str();
                    genStringAndCheck(g, (const unsigned char*) s , strlen(s));
                }
                {
                    yajl_gen_null(g);
                }
            }
        }
        yajl_gen_map_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::wapdman::Accesspoint::AssociatedStationsChangedSignalChangedstationsStruct& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::wapdman::Accesspoint::SetSSIDRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::wapdman::Accesspoint::DeAuthenticateStationRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::wapdman::Accesspoint::BlacklistStationRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::wapdman::Accesspoint::SetOperatingChannelsRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::wapdman::Accesspoint::GetAssociatedStationsResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::wapdman::Accesspoint::RegisterVendorServiceRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::wapdman::Accesspoint::UnregisterVendorServiceRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::wapdman::Accesspoint::GetDnsDhcpConfResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::wapdman::Accesspoint::MacAddressUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::wapdman::Accesspoint::MacAddressRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::wapdman::Accesspoint::SSIDUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::wapdman::Accesspoint::SSIDRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::wapdman::Accesspoint::InterfaceUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::wapdman::Accesspoint::InterfaceRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::wapdman::Accesspoint::BlackListedStationsUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::wapdman::Accesspoint::BlackListedStationsRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::wapdman::Accesspoint::PowerStateUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::wapdman::Accesspoint::PowerStateRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::wapdman::Accesspoint::PowerFailureReasonUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::wapdman::Accesspoint::PowerFailureReasonRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::wapdman::Accesspoint::PoweredUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::wapdman::Accesspoint::PoweredRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::wapdman::Accesspoint::HiddenUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::wapdman::Accesspoint::HiddenRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::wapdman::Accesspoint::SecurityUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::wapdman::Accesspoint::SecurityRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::wapdman::Accesspoint::PassphraseUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::wapdman::Accesspoint::PassphraseRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::wapdman::Accesspoint::CurrentOperatingChannelUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::wapdman::Accesspoint::CurrentOperatingChannelRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::wapdman::Accesspoint::HWFeaturesUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::wapdman::Accesspoint::HWFeaturesRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::wapdman::Accesspoint::MaximumStationsAllowedUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::wapdman::Accesspoint::MaximumStationsAllowedRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::wapdman::Accesspoint::CountryCodeUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::wapdman::Accesspoint::CountryCodeRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::wapdman::Accesspoint::SupportedChannelsUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::wapdman::Accesspoint::SupportedChannelsRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::wapdman::Accesspoint::AccessNetworkTypeUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::wapdman::Accesspoint::AccessNetworkTypeRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::wapdman::Accesspoint::AssociatedStationsChangedSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::wapdman::Accesspoint::AssociationRequestRejectedSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::wapdman::Accesspoint::GetAssociatedStationsResponseAssociatedstationsStruct& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::wapdman::Accesspoint::GetDnsDhcpConfResponseDnsdhcpserverconfStruct& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::wapdman::Accesspoint::AssociatedStationsChangedSignalChangedstationsStruct& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org

