/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/wapdman/Accesspoint/TetheringSettings.h"
#include "org/bosch/wapdman/Accesspoint/TetheringSettingsDBus.h"
#include "org/bosch/wapdman/Accesspoint/TetheringSettingsJson.h"
#include "org/bosch/wapdman/Accesspoint/TetheringSettingsStub.h"

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bosch {
namespace wapdman {
namespace Accesspoint {
namespace TetheringSettings {

DEFINE_CLASS_LOGGER("//org/bosch/wapdman/accesspoint_XX_XX_XX_XX_XX_XX/org/bosch/wapdman/Accesspoint/TetheringSettings", TetheringSettingsStub);


static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 9, "Tethering", 0 },
};

class TetheringSettingsStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    TetheringSettingsStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    TetheringSettingsStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    TetheringSettingsStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.bosch.wapdman.Accesspoint.TetheringSettings"),
          _logger(logger) {}

    virtual ~TetheringSettingsStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void TetheringSettingsStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* TetheringSettingsStubDelegate::introspect() const {
    return     "<interface name=\"org.bosch.wapdman.Accesspoint.TetheringSettings\">\n"
            "      <property access=\"readwrite\" name=\"Tethering\" type=\"b\"/>\n"
            "</interface>\n";
}

void TetheringSettingsStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<TetheringSettingsStub*>(getStub()))->onGetAll (properties);
}

void TetheringSettingsStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 1, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "Tethering");
            ::boost::shared_ptr< TetheringSet > payload(new TetheringSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<TetheringSettingsStub*>(getStub())->onTetheringSet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void TetheringSettingsStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 1, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "Tethering");
            ::boost::shared_ptr< TetheringGet > payload(new TetheringGet());
            payload->setAct(act);
            static_cast<TetheringSettingsStub*>(getStub())->onTetheringGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

TetheringSettingsStub::TetheringSettingsStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new TetheringSettingsStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

TetheringSettingsStub::TetheringSettingsStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new TetheringSettingsStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

TetheringSettingsStub::~TetheringSettingsStub() {
    delete _stubDelegate;
}

void TetheringSettingsStub::sendTetheringUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        TetheringUpdate payload(_TetheringProperty);

        LOG_INFO ("-> send%s", "TetheringUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Tethering", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.wapdman.Accesspoint.TetheringSettings", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "TetheringUpdate");
    }
}

void TetheringSettingsStub::onTetheringGet(const ::boost::shared_ptr< TetheringGet >& tethering) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "TetheringGet", tethering->getAct());
    sendTetheringGetUpdate(_TetheringProperty.getTethering(), tethering->getAct());
}

void TetheringSettingsStub::sendTetheringGetUpdate(bool tethering, act_t act) {
    ::asf::dbus::DBusVariant variant;
    TetheringGet payload(tethering);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "TetheringGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void TetheringSettingsStub::onTetheringSet(const ::boost::shared_ptr< TetheringSet >& tethering) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "TetheringSet", tethering->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*tethering, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setTethering (tethering->getTethering());
    sendTetheringSetUpdate(tethering->getAct());
}

void TetheringSettingsStub::sendTetheringSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "TetheringSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void TetheringSettingsStub::setTethering(bool tethering) {
    if(tethering!=_TetheringProperty.getTethering()) {
        _TetheringProperty.setTethering(tethering);
        sendTetheringUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool TetheringSettingsStub::getTethering() const {
    return _TetheringProperty.getTethering();
}

void TetheringSettingsStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'Tethering'
    {
        ::asf::dbus::DBusVariant variant;
        TetheringGet payload(_TetheringProperty.getTethering());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Tethering", variant));
    }
}

} // namespace TetheringSettings
} // namespace Accesspoint
} // namespace wapdman
} // namespace bosch
} // namespace org
