#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef VIDEOMANAGER_MAIN_FI_H
#define VIDEOMANAGER_MAIN_FI_H

#include "asf/cca/CcaTypes.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include "videomanager_main_fi_typesConst.h"
#include <cstring>

/**
 * CCA Functional Interface 'videomanager_main_fi'
 *
 * Fullname: Video manager component functional interface
 *
 * Version: $Revision:   1.1.0   $
 *
 * Author: CM-CI1/ERN4-E Schurig
 *
 * Date: $Date: 2017-13-01   $
 *
 * Department:
 *
 * Title: Video Manager FI
 *
 * <b>Description of 'videomanager_main_fi':</b>
 *
 * This functional interface is designed for the videomanager.
 */

namespace videomanager_main_fi {

static const int SERVICE_ID = 229;

static const int FID_RVCA = 1;

static const int FID_RVCD = 2;

static const int FID_DTV = 3;

static const int FID_SPCX = 4;

static const int FID_DVD = 5;

static const int FID_USB = 6;

static const int FID_DeserializerUsedBy = 7;

static const int FID_RequestVideoSourceState = 4097;

static const int FID_RequestAccessToDeserializer = 4098;

static const int FID_AcknowledgeState = 4099;


ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 1;

static const int VERSION_PATCH = 0;

// forward declarations
class RVCAStatus;

class RVCDStatus;

class DTVStatus;

class SPCXStatus;

class DVDStatus;

class USBStatus;

class DeserializerUsedByStatus;

class RequestVideoSourceStateStart;

class RequestVideoSourceStateResult;

class RequestAccessToDeserializerStart;

class RequestAccessToDeserializerResult;

class AcknowledgeStateStart;

// type definitions
/**
 * The set message of the property "RVCA"
 * This property represents the current state of the rear view camera (analogue).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RVCASet;

/**
 * The get message of the property "RVCA"
 * This property represents the current state of the rear view camera (analogue).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RVCAGet;

/**
 * The upreg message of the property "RVCA"
 * This property represents the current state of the rear view camera (analogue).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RVCAUpReg;

/**
 * The relUpReg message of the property "RVCA"
 * This property represents the current state of the rear view camera (analogue).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RVCARelUpReg;

/**
 * The error message of 'RVCA'
 */
typedef ::asf::cca::CcaTypes::DefaultError RVCAError;

/**
 * The set message of the property "RVCD"
 * This property represents the current state of the rear view camera (digital).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RVCDSet;

/**
 * The get message of the property "RVCD"
 * This property represents the current state of the rear view camera (digital).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RVCDGet;

/**
 * The upreg message of the property "RVCD"
 * This property represents the current state of the rear view camera (digital).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RVCDUpReg;

/**
 * The relUpReg message of the property "RVCD"
 * This property represents the current state of the rear view camera (digital).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RVCDRelUpReg;

/**
 * The error message of 'RVCD'
 */
typedef ::asf::cca::CcaTypes::DefaultError RVCDError;

/**
 * The set message of the property "DTV"
 * This property represents the current state of DTV source.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DTVSet;

/**
 * The get message of the property "DTV"
 * This property represents the current state of DTV source.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DTVGet;

/**
 * The upreg message of the property "DTV"
 * This property represents the current state of DTV source.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DTVUpReg;

/**
 * The relUpReg message of the property "DTV"
 * This property represents the current state of DTV source.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DTVRelUpReg;

/**
 * The error message of 'DTV'
 */
typedef ::asf::cca::CcaTypes::DefaultError DTVError;

/**
 * The set message of the property "SPCX"
 * This property represents the current state of the smart phone video.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SPCXSet;

/**
 * The get message of the property "SPCX"
 * This property represents the current state of the smart phone video.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SPCXGet;

/**
 * The upreg message of the property "SPCX"
 * This property represents the current state of the smart phone video.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SPCXUpReg;

/**
 * The relUpReg message of the property "SPCX"
 * This property represents the current state of the smart phone video.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SPCXRelUpReg;

/**
 * The error message of 'SPCX'
 */
typedef ::asf::cca::CcaTypes::DefaultError SPCXError;

/**
 * The set message of the property "DVD"
 * This property represents the current state of the DVD device.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DVDSet;

/**
 * The get message of the property "DVD"
 * This property represents the current state of the DVD device.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DVDGet;

/**
 * The upreg message of the property "DVD"
 * This property represents the current state of the DVD device.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DVDUpReg;

/**
 * The relUpReg message of the property "DVD"
 * This property represents the current state of the DVD device.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DVDRelUpReg;

/**
 * The error message of 'DVD'
 */
typedef ::asf::cca::CcaTypes::DefaultError DVDError;

/**
 * The set message of the property "USB"
 * This property represents the current state of the USB video.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage USBSet;

/**
 * The get message of the property "USB"
 * This property represents the current state of the USB video.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage USBGet;

/**
 * The upreg message of the property "USB"
 * This property represents the current state of the USB video.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage USBUpReg;

/**
 * The relUpReg message of the property "USB"
 * This property represents the current state of the USB video.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage USBRelUpReg;

/**
 * The error message of 'USB'
 */
typedef ::asf::cca::CcaTypes::DefaultError USBError;

/**
 * The set message of the property "DeserializerUsedBy"
 * This property represents the current source who is using the deserializer.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DeserializerUsedBySet;

/**
 * The get message of the property "DeserializerUsedBy"
 * This property represents the current source who is using the deserializer.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DeserializerUsedByGet;

/**
 * The upreg message of the property "DeserializerUsedBy"
 * This property represents the current source who is using the deserializer.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DeserializerUsedByUpReg;

/**
 * The relUpReg message of the property "DeserializerUsedBy"
 * This property represents the current source who is using the deserializer.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DeserializerUsedByRelUpReg;

/**
 * The error message of 'DeserializerUsedBy'
 */
typedef ::asf::cca::CcaTypes::DefaultError DeserializerUsedByError;

/**
 * The abort message of the method "RequestVideoSourceState"
 * This method is to allow the components to request a state they want to enter with a certain video source.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RequestVideoSourceStateAbort;

/**
 * The abort result message of the method "RequestVideoSourceState"
 * This method is to allow the components to request a state they want to enter with a certain video source.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RequestVideoSourceStateAbortResult;

/**
 * The abort error message of the method "RequestVideoSourceState"
 * This method is to allow the components to request a state they want to enter with a certain video source.
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestVideoSourceStateAbortError;

/**
 * The error message of 'RequestVideoSourceState'
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestVideoSourceStateError;

/**
 * The abort message of the method "RequestAccessToDeserializer"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RequestAccessToDeserializerAbort;

/**
 * The abort result message of the method "RequestAccessToDeserializer"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RequestAccessToDeserializerAbortResult;

/**
 * The abort error message of the method "RequestAccessToDeserializer"
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestAccessToDeserializerAbortError;

/**
 * The error message of 'RequestAccessToDeserializer'
 */
typedef ::asf::cca::CcaTypes::DefaultError RequestAccessToDeserializerError;

/**
 * The result message of the method "AcknowledgeState"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AcknowledgeStateResult;

/**
 * The abort message of the method "AcknowledgeState"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AcknowledgeStateAbort;

/**
 * The abort result message of the method "AcknowledgeState"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AcknowledgeStateAbortResult;

/**
 * The abort error message of the method "AcknowledgeState"
 */
typedef ::asf::cca::CcaTypes::DefaultError AcknowledgeStateAbortError;

/**
 * The error message of 'AcknowledgeState'
 */
typedef ::asf::cca::CcaTypes::DefaultError AcknowledgeStateError;


/**
 * The status message of the property "RVCA"
 * This property represents the current state of the rear view camera (analogue).
 */
class RVCAStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RVCAStatus ();

    /**
     * Copy constructor
     */
    inline  RVCAStatus (const RVCAStatus &rhs);

    /**
     * All fields constructor
     */
    inline  RVCAStatus (::videomanager_main_fi_types::T_e8_vdmSourceState RVCA_StateInfo_);

    /**
     * Destructor
     */
    inline virtual  ~RVCAStatus();

    /**
     * Assignment operator
     */
    inline RVCAStatus& operator = (const RVCAStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RVCAStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RVCAStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RVCAStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RVCAStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RVCA_StateInfo"

    static const int kRVCA_StateInfo = 0;

    /**
     * Clears the field "RVCA_StateInfo".
     *
     * The field will be set to its default value. The hasRVCA_StateInfo()
     * method will return false.
     */
    inline void clearRVCA_StateInfo();

    /**
     * Checks whether the field "RVCA_StateInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRVCA_StateInfo()). Otherwise it will return false.
     */
    inline bool hasRVCA_StateInfo () const;

    /**
     * Returns the value of the member "RVCA_StateInfo".
     *
     * 0=unknown, 1=inactive, 2=activating, 3=active, 4=blocked, 5=restricted (audio only)
     *
     * @return The value of the field "RVCA_StateInfo"
     */
    inline ::videomanager_main_fi_types::T_e8_vdmSourceState getRVCA_StateInfo () const;

    /**
     * Sets the value of the member "RVCA_StateInfo".
     *
     * 0=unknown, 1=inactive, 2=activating, 3=active, 4=blocked, 5=restricted (audio only)
     *
     * @param RVCA_StateInfo The value which will be set
     */
    inline void setRVCA_StateInfo (::videomanager_main_fi_types::T_e8_vdmSourceState RVCA_StateInfo_);

    static const RVCAStatus &getDefaultInstance();

private:

    inline void set_has_RVCA_StateInfo ();

    inline void clear_has_RVCA_StateInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::videomanager_main_fi_types::T_e8_vdmSourceState _RVCA_StateInfo;

};

/**
 * The status message of the property "RVCD"
 * This property represents the current state of the rear view camera (digital).
 */
class RVCDStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RVCDStatus ();

    /**
     * Copy constructor
     */
    inline  RVCDStatus (const RVCDStatus &rhs);

    /**
     * All fields constructor
     */
    inline  RVCDStatus (::videomanager_main_fi_types::T_e8_vdmSourceState RVCD_StateInfo_);

    /**
     * Destructor
     */
    inline virtual  ~RVCDStatus();

    /**
     * Assignment operator
     */
    inline RVCDStatus& operator = (const RVCDStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RVCDStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RVCDStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RVCDStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RVCDStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RVCD_StateInfo"

    static const int kRVCD_StateInfo = 0;

    /**
     * Clears the field "RVCD_StateInfo".
     *
     * The field will be set to its default value. The hasRVCD_StateInfo()
     * method will return false.
     */
    inline void clearRVCD_StateInfo();

    /**
     * Checks whether the field "RVCD_StateInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRVCD_StateInfo()). Otherwise it will return false.
     */
    inline bool hasRVCD_StateInfo () const;

    /**
     * Returns the value of the member "RVCD_StateInfo".
     *
     * 0=unknown, 1=inactive, 2=activating, 3=active, 4=blocked, 5=restricted (audio only)
     *
     * @return The value of the field "RVCD_StateInfo"
     */
    inline ::videomanager_main_fi_types::T_e8_vdmSourceState getRVCD_StateInfo () const;

    /**
     * Sets the value of the member "RVCD_StateInfo".
     *
     * 0=unknown, 1=inactive, 2=activating, 3=active, 4=blocked, 5=restricted (audio only)
     *
     * @param RVCD_StateInfo The value which will be set
     */
    inline void setRVCD_StateInfo (::videomanager_main_fi_types::T_e8_vdmSourceState RVCD_StateInfo_);

    static const RVCDStatus &getDefaultInstance();

private:

    inline void set_has_RVCD_StateInfo ();

    inline void clear_has_RVCD_StateInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::videomanager_main_fi_types::T_e8_vdmSourceState _RVCD_StateInfo;

};

/**
 * The status message of the property "DTV"
 * This property represents the current state of DTV source.
 */
class DTVStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DTVStatus ();

    /**
     * Copy constructor
     */
    inline  DTVStatus (const DTVStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DTVStatus (::videomanager_main_fi_types::T_e8_vdmSourceState DTV_StateInfo_);

    /**
     * Destructor
     */
    inline virtual  ~DTVStatus();

    /**
     * Assignment operator
     */
    inline DTVStatus& operator = (const DTVStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DTVStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DTVStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DTVStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DTVStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DTV_StateInfo"

    static const int kDTV_StateInfo = 0;

    /**
     * Clears the field "DTV_StateInfo".
     *
     * The field will be set to its default value. The hasDTV_StateInfo()
     * method will return false.
     */
    inline void clearDTV_StateInfo();

    /**
     * Checks whether the field "DTV_StateInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDTV_StateInfo()). Otherwise it will return false.
     */
    inline bool hasDTV_StateInfo () const;

    /**
     * Returns the value of the member "DTV_StateInfo".
     *
     * 0=unknown, 1=inactive, 2=activating, 3=active, 4=blocked, 5=restricted (audio only)
     *
     * @return The value of the field "DTV_StateInfo"
     */
    inline ::videomanager_main_fi_types::T_e8_vdmSourceState getDTV_StateInfo () const;

    /**
     * Sets the value of the member "DTV_StateInfo".
     *
     * 0=unknown, 1=inactive, 2=activating, 3=active, 4=blocked, 5=restricted (audio only)
     *
     * @param DTV_StateInfo The value which will be set
     */
    inline void setDTV_StateInfo (::videomanager_main_fi_types::T_e8_vdmSourceState DTV_StateInfo_);

    static const DTVStatus &getDefaultInstance();

private:

    inline void set_has_DTV_StateInfo ();

    inline void clear_has_DTV_StateInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::videomanager_main_fi_types::T_e8_vdmSourceState _DTV_StateInfo;

};

/**
 * The status message of the property "SPCX"
 * This property represents the current state of the smart phone video.
 */
class SPCXStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SPCXStatus ();

    /**
     * Copy constructor
     */
    inline  SPCXStatus (const SPCXStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SPCXStatus (::videomanager_main_fi_types::T_e8_vdmSourceState SPCX_StateInfo_);

    /**
     * Destructor
     */
    inline virtual  ~SPCXStatus();

    /**
     * Assignment operator
     */
    inline SPCXStatus& operator = (const SPCXStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SPCXStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SPCXStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SPCXStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SPCXStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SPCX_StateInfo"

    static const int kSPCX_StateInfo = 0;

    /**
     * Clears the field "SPCX_StateInfo".
     *
     * The field will be set to its default value. The hasSPCX_StateInfo()
     * method will return false.
     */
    inline void clearSPCX_StateInfo();

    /**
     * Checks whether the field "SPCX_StateInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPCX_StateInfo()). Otherwise it will return false.
     */
    inline bool hasSPCX_StateInfo () const;

    /**
     * Returns the value of the member "SPCX_StateInfo".
     *
     * 0=unknown, 1=inactive, 2=activating, 3=active, 4=blocked, 5=restricted (audio only)
     *
     * @return The value of the field "SPCX_StateInfo"
     */
    inline ::videomanager_main_fi_types::T_e8_vdmSourceState getSPCX_StateInfo () const;

    /**
     * Sets the value of the member "SPCX_StateInfo".
     *
     * 0=unknown, 1=inactive, 2=activating, 3=active, 4=blocked, 5=restricted (audio only)
     *
     * @param SPCX_StateInfo The value which will be set
     */
    inline void setSPCX_StateInfo (::videomanager_main_fi_types::T_e8_vdmSourceState SPCX_StateInfo_);

    static const SPCXStatus &getDefaultInstance();

private:

    inline void set_has_SPCX_StateInfo ();

    inline void clear_has_SPCX_StateInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::videomanager_main_fi_types::T_e8_vdmSourceState _SPCX_StateInfo;

};

/**
 * The status message of the property "DVD"
 * This property represents the current state of the DVD device.
 */
class DVDStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DVDStatus ();

    /**
     * Copy constructor
     */
    inline  DVDStatus (const DVDStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DVDStatus (::videomanager_main_fi_types::T_e8_vdmSourceState DVD_StateInfo_);

    /**
     * Destructor
     */
    inline virtual  ~DVDStatus();

    /**
     * Assignment operator
     */
    inline DVDStatus& operator = (const DVDStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DVDStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DVDStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DVDStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DVDStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DVD_StateInfo"

    static const int kDVD_StateInfo = 0;

    /**
     * Clears the field "DVD_StateInfo".
     *
     * The field will be set to its default value. The hasDVD_StateInfo()
     * method will return false.
     */
    inline void clearDVD_StateInfo();

    /**
     * Checks whether the field "DVD_StateInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDVD_StateInfo()). Otherwise it will return false.
     */
    inline bool hasDVD_StateInfo () const;

    /**
     * Returns the value of the member "DVD_StateInfo".
     *
     * 0=unknown, 1=inactive, 2=activating, 3=active, 4=blocked, 5=restricted (audio only)
     *
     * @return The value of the field "DVD_StateInfo"
     */
    inline ::videomanager_main_fi_types::T_e8_vdmSourceState getDVD_StateInfo () const;

    /**
     * Sets the value of the member "DVD_StateInfo".
     *
     * 0=unknown, 1=inactive, 2=activating, 3=active, 4=blocked, 5=restricted (audio only)
     *
     * @param DVD_StateInfo The value which will be set
     */
    inline void setDVD_StateInfo (::videomanager_main_fi_types::T_e8_vdmSourceState DVD_StateInfo_);

    static const DVDStatus &getDefaultInstance();

private:

    inline void set_has_DVD_StateInfo ();

    inline void clear_has_DVD_StateInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::videomanager_main_fi_types::T_e8_vdmSourceState _DVD_StateInfo;

};

/**
 * The status message of the property "USB"
 * This property represents the current state of the USB video.
 */
class USBStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  USBStatus ();

    /**
     * Copy constructor
     */
    inline  USBStatus (const USBStatus &rhs);

    /**
     * All fields constructor
     */
    inline  USBStatus (::videomanager_main_fi_types::T_e8_vdmSourceState USB_StateInfo_);

    /**
     * Destructor
     */
    inline virtual  ~USBStatus();

    /**
     * Assignment operator
     */
    inline USBStatus& operator = (const USBStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const USBStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const USBStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const USBStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const USBStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "USB_StateInfo"

    static const int kUSB_StateInfo = 0;

    /**
     * Clears the field "USB_StateInfo".
     *
     * The field will be set to its default value. The hasUSB_StateInfo()
     * method will return false.
     */
    inline void clearUSB_StateInfo();

    /**
     * Checks whether the field "USB_StateInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUSB_StateInfo()). Otherwise it will return false.
     */
    inline bool hasUSB_StateInfo () const;

    /**
     * Returns the value of the member "USB_StateInfo".
     *
     * 0=unknown, 1=inactive, 2=activating, 3=active, 4=blocked, 5=restricted (audio only)
     *
     * @return The value of the field "USB_StateInfo"
     */
    inline ::videomanager_main_fi_types::T_e8_vdmSourceState getUSB_StateInfo () const;

    /**
     * Sets the value of the member "USB_StateInfo".
     *
     * 0=unknown, 1=inactive, 2=activating, 3=active, 4=blocked, 5=restricted (audio only)
     *
     * @param USB_StateInfo The value which will be set
     */
    inline void setUSB_StateInfo (::videomanager_main_fi_types::T_e8_vdmSourceState USB_StateInfo_);

    static const USBStatus &getDefaultInstance();

private:

    inline void set_has_USB_StateInfo ();

    inline void clear_has_USB_StateInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::videomanager_main_fi_types::T_e8_vdmSourceState _USB_StateInfo;

};

/**
 * The status message of the property "DeserializerUsedBy"
 * This property represents the current source who is using the deserializer.
 */
class DeserializerUsedByStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeserializerUsedByStatus ();

    /**
     * Copy constructor
     */
    inline  DeserializerUsedByStatus (const DeserializerUsedByStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DeserializerUsedByStatus (::videomanager_main_fi_types::T_e8_vdmVideoSource Deserializer_SourceInfo_);

    /**
     * Destructor
     */
    inline virtual  ~DeserializerUsedByStatus();

    /**
     * Assignment operator
     */
    inline DeserializerUsedByStatus& operator = (const DeserializerUsedByStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeserializerUsedByStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeserializerUsedByStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeserializerUsedByStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeserializerUsedByStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Deserializer_SourceInfo"

    static const int kDeserializer_SourceInfo = 0;

    /**
     * Clears the field "Deserializer_SourceInfo".
     *
     * The field will be set to its default value. The hasDeserializer_SourceInfo()
     * method will return false.
     */
    inline void clearDeserializer_SourceInfo();

    /**
     * Checks whether the field "Deserializer_SourceInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeserializer_SourceInfo()). Otherwise it will return false.
     */
    inline bool hasDeserializer_SourceInfo () const;

    /**
     * Returns the value of the member "Deserializer_SourceInfo".
     *
     * 0=NONE, 1=RVCA, 2=RVCD, 3=DTV, 4=SPCX, 5=DVD, 6=USB
     *
     * @return The value of the field "Deserializer_SourceInfo"
     */
    inline ::videomanager_main_fi_types::T_e8_vdmVideoSource getDeserializer_SourceInfo () const;

    /**
     * Sets the value of the member "Deserializer_SourceInfo".
     *
     * 0=NONE, 1=RVCA, 2=RVCD, 3=DTV, 4=SPCX, 5=DVD, 6=USB
     *
     * @param Deserializer_SourceInfo The value which will be set
     */
    inline void setDeserializer_SourceInfo (::videomanager_main_fi_types::T_e8_vdmVideoSource Deserializer_SourceInfo_);

    static const DeserializerUsedByStatus &getDefaultInstance();

private:

    inline void set_has_Deserializer_SourceInfo ();

    inline void clear_has_Deserializer_SourceInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::videomanager_main_fi_types::T_e8_vdmVideoSource _Deserializer_SourceInfo;

};

/**
 * The start message of the method "RequestVideoSourceState"
 * This method is to allow the components to request a state they want to enter with a certain video source.
 */
class RequestVideoSourceStateStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestVideoSourceStateStart ();

    /**
     * Copy constructor
     */
    inline  RequestVideoSourceStateStart (const RequestVideoSourceStateStart &rhs);

    /**
     * All fields constructor
     */
    inline  RequestVideoSourceStateStart (::videomanager_main_fi_types::T_e8_vdmVideoSource tVideoSource_, ::videomanager_main_fi_types::T_e8_vdmRequestedSourceState tRequestedState_);

    /**
     * Destructor
     */
    inline virtual  ~RequestVideoSourceStateStart();

    /**
     * Assignment operator
     */
    inline RequestVideoSourceStateStart& operator = (const RequestVideoSourceStateStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestVideoSourceStateStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestVideoSourceStateStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestVideoSourceStateStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestVideoSourceStateStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tVideoSource"

    static const int kTVideoSource = 0;

    /**
     * Clears the field "tVideoSource".
     *
     * The field will be set to its default value. The hasTVideoSource()
     * method will return false.
     */
    inline void clearTVideoSource();

    /**
     * Checks whether the field "tVideoSource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTVideoSource()). Otherwise it will return false.
     */
    inline bool hasTVideoSource () const;

    /**
     * Returns the value of the member "tVideoSource".
     *
     * 0=NONE, 1=RVCA, 2=RVCD, 3=DTV, 4=SPCX, 5=DVD, 6=USB
     *
     * @return The value of the field "tVideoSource"
     */
    inline ::videomanager_main_fi_types::T_e8_vdmVideoSource getTVideoSource () const;

    /**
     * Sets the value of the member "tVideoSource".
     *
     * 0=NONE, 1=RVCA, 2=RVCD, 3=DTV, 4=SPCX, 5=DVD, 6=USB
     *
     * @param tVideoSource The value which will be set
     */
    inline void setTVideoSource (::videomanager_main_fi_types::T_e8_vdmVideoSource tVideoSource_);

    // API of field "tRequestedState"

    static const int kTRequestedState = 1;

    /**
     * Clears the field "tRequestedState".
     *
     * The field will be set to its default value. The hasTRequestedState()
     * method will return false.
     */
    inline void clearTRequestedState();

    /**
     * Checks whether the field "tRequestedState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTRequestedState()). Otherwise it will return false.
     */
    inline bool hasTRequestedState () const;

    /**
     * Returns the value of the member "tRequestedState".
     *
     * 0=inactive, 1=active
     *
     * @return The value of the field "tRequestedState"
     */
    inline ::videomanager_main_fi_types::T_e8_vdmRequestedSourceState getTRequestedState () const;

    /**
     * Sets the value of the member "tRequestedState".
     *
     * 0=inactive, 1=active
     *
     * @param tRequestedState The value which will be set
     */
    inline void setTRequestedState (::videomanager_main_fi_types::T_e8_vdmRequestedSourceState tRequestedState_);

    static const RequestVideoSourceStateStart &getDefaultInstance();

private:

    inline void set_has_tVideoSource ();

    inline void clear_has_tVideoSource ();

    inline void set_has_tRequestedState ();

    inline void clear_has_tRequestedState ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::videomanager_main_fi_types::T_e8_vdmVideoSource _tVideoSource;

    ::videomanager_main_fi_types::T_e8_vdmRequestedSourceState _tRequestedState;

};

/**
 * The result message of the method "RequestVideoSourceState"
 * This method is to allow the components to request a state they want to enter with a certain video source.
 * The method result reflects the decision if a source change has been granted.
 */
class RequestVideoSourceStateResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestVideoSourceStateResult ();

    /**
     * Copy constructor
     */
    inline  RequestVideoSourceStateResult (const RequestVideoSourceStateResult &rhs);

    /**
     * All fields constructor
     */
    inline  RequestVideoSourceStateResult (bool bSourceChangeGranted_);

    /**
     * Destructor
     */
    inline virtual  ~RequestVideoSourceStateResult();

    /**
     * Assignment operator
     */
    inline RequestVideoSourceStateResult& operator = (const RequestVideoSourceStateResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestVideoSourceStateResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestVideoSourceStateResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestVideoSourceStateResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestVideoSourceStateResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bSourceChangeGranted"

    static const int kBSourceChangeGranted = 0;

    /**
     * Clears the field "bSourceChangeGranted".
     *
     * The field will be set to its default value. The hasBSourceChangeGranted()
     * method will return false.
     */
    inline void clearBSourceChangeGranted();

    /**
     * Checks whether the field "bSourceChangeGranted" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBSourceChangeGranted()). Otherwise it will return false.
     */
    inline bool hasBSourceChangeGranted () const;

    /**
     * Returns the value of the member "bSourceChangeGranted".
     *
     * FALSE=source change NOT granted, TRUE=source change granted
     *
     * @return The value of the field "bSourceChangeGranted"
     */
    inline bool getBSourceChangeGranted () const;

    /**
     * Sets the value of the member "bSourceChangeGranted".
     *
     * FALSE=source change NOT granted, TRUE=source change granted
     *
     * @param bSourceChangeGranted The value which will be set
     */
    inline void setBSourceChangeGranted (bool bSourceChangeGranted_);

    static const RequestVideoSourceStateResult &getDefaultInstance();

private:

    inline void set_has_bSourceChangeGranted ();

    inline void clear_has_bSourceChangeGranted ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bSourceChangeGranted;

};

/**
 * The start message of the method "RequestAccessToDeserializer"
 * This method can be called by components to get informed if access to deserializer can be granted or not.
 */
class RequestAccessToDeserializerStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestAccessToDeserializerStart ();

    /**
     * Copy constructor
     */
    inline  RequestAccessToDeserializerStart (const RequestAccessToDeserializerStart &rhs);

    /**
     * All fields constructor
     */
    inline  RequestAccessToDeserializerStart (::videomanager_main_fi_types::T_e8_vdmVideoSource tVideoSource_);

    /**
     * Destructor
     */
    inline virtual  ~RequestAccessToDeserializerStart();

    /**
     * Assignment operator
     */
    inline RequestAccessToDeserializerStart& operator = (const RequestAccessToDeserializerStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestAccessToDeserializerStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestAccessToDeserializerStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestAccessToDeserializerStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestAccessToDeserializerStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tVideoSource"

    static const int kTVideoSource = 0;

    /**
     * Clears the field "tVideoSource".
     *
     * The field will be set to its default value. The hasTVideoSource()
     * method will return false.
     */
    inline void clearTVideoSource();

    /**
     * Checks whether the field "tVideoSource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTVideoSource()). Otherwise it will return false.
     */
    inline bool hasTVideoSource () const;

    /**
     * Returns the value of the member "tVideoSource".
     *
     * 0=NONE, 1=RVCA, 2=RVCD, 3=DTV, 4=SPCX, 5=DVD, 6=USB
     *
     * @return The value of the field "tVideoSource"
     */
    inline ::videomanager_main_fi_types::T_e8_vdmVideoSource getTVideoSource () const;

    /**
     * Sets the value of the member "tVideoSource".
     *
     * 0=NONE, 1=RVCA, 2=RVCD, 3=DTV, 4=SPCX, 5=DVD, 6=USB
     *
     * @param tVideoSource The value which will be set
     */
    inline void setTVideoSource (::videomanager_main_fi_types::T_e8_vdmVideoSource tVideoSource_);

    static const RequestAccessToDeserializerStart &getDefaultInstance();

private:

    inline void set_has_tVideoSource ();

    inline void clear_has_tVideoSource ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::videomanager_main_fi_types::T_e8_vdmVideoSource _tVideoSource;

};

/**
 * The result message of the method "RequestAccessToDeserializer"
 */
class RequestAccessToDeserializerResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestAccessToDeserializerResult ();

    /**
     * Copy constructor
     */
    inline  RequestAccessToDeserializerResult (const RequestAccessToDeserializerResult &rhs);

    /**
     * All fields constructor
     */
    inline  RequestAccessToDeserializerResult (bool bAccessIsGranted_);

    /**
     * Destructor
     */
    inline virtual  ~RequestAccessToDeserializerResult();

    /**
     * Assignment operator
     */
    inline RequestAccessToDeserializerResult& operator = (const RequestAccessToDeserializerResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestAccessToDeserializerResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestAccessToDeserializerResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestAccessToDeserializerResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestAccessToDeserializerResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bAccessIsGranted"

    static const int kBAccessIsGranted = 0;

    /**
     * Clears the field "bAccessIsGranted".
     *
     * The field will be set to its default value. The hasBAccessIsGranted()
     * method will return false.
     */
    inline void clearBAccessIsGranted();

    /**
     * Checks whether the field "bAccessIsGranted" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBAccessIsGranted()). Otherwise it will return false.
     */
    inline bool hasBAccessIsGranted () const;

    /**
     * Returns the value of the member "bAccessIsGranted".
     *
     * FALSE=source change NOT granted, TRUE=source change granted
     *
     * @return The value of the field "bAccessIsGranted"
     */
    inline bool getBAccessIsGranted () const;

    /**
     * Sets the value of the member "bAccessIsGranted".
     *
     * FALSE=source change NOT granted, TRUE=source change granted
     *
     * @param bAccessIsGranted The value which will be set
     */
    inline void setBAccessIsGranted (bool bAccessIsGranted_);

    static const RequestAccessToDeserializerResult &getDefaultInstance();

private:

    inline void set_has_bAccessIsGranted ();

    inline void clear_has_bAccessIsGranted ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bAccessIsGranted;

};

/**
 * The start message of the method "AcknowledgeState"
 * This method should be called if the ordered state is about to be changed
 */
class AcknowledgeStateStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AcknowledgeStateStart ();

    /**
     * Copy constructor
     */
    inline  AcknowledgeStateStart (const AcknowledgeStateStart &rhs);

    /**
     * All fields constructor
     */
    inline  AcknowledgeStateStart (::videomanager_main_fi_types::T_e8_vdmVideoSource tVideoSource_, ::videomanager_main_fi_types::T_e8_vdmSourceState tVideoState_);

    /**
     * Destructor
     */
    inline virtual  ~AcknowledgeStateStart();

    /**
     * Assignment operator
     */
    inline AcknowledgeStateStart& operator = (const AcknowledgeStateStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AcknowledgeStateStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AcknowledgeStateStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AcknowledgeStateStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AcknowledgeStateStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tVideoSource"

    static const int kTVideoSource = 0;

    /**
     * Clears the field "tVideoSource".
     *
     * The field will be set to its default value. The hasTVideoSource()
     * method will return false.
     */
    inline void clearTVideoSource();

    /**
     * Checks whether the field "tVideoSource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTVideoSource()). Otherwise it will return false.
     */
    inline bool hasTVideoSource () const;

    /**
     * Returns the value of the member "tVideoSource".
     *
     * 0=NONE, 1=RVCA, 2=RVCD, 3=DTV, 4=SPCX, 5=DVD, 6=USB
     *
     * @return The value of the field "tVideoSource"
     */
    inline ::videomanager_main_fi_types::T_e8_vdmVideoSource getTVideoSource () const;

    /**
     * Sets the value of the member "tVideoSource".
     *
     * 0=NONE, 1=RVCA, 2=RVCD, 3=DTV, 4=SPCX, 5=DVD, 6=USB
     *
     * @param tVideoSource The value which will be set
     */
    inline void setTVideoSource (::videomanager_main_fi_types::T_e8_vdmVideoSource tVideoSource_);

    // API of field "tVideoState"

    static const int kTVideoState = 1;

    /**
     * Clears the field "tVideoState".
     *
     * The field will be set to its default value. The hasTVideoState()
     * method will return false.
     */
    inline void clearTVideoState();

    /**
     * Checks whether the field "tVideoState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTVideoState()). Otherwise it will return false.
     */
    inline bool hasTVideoState () const;

    /**
     * Returns the value of the member "tVideoState".
     *
     * 0=unknown, 1=inactive, 2=prepare, 3=active, 4=blocked, 5=restricted (audio only), 6=error
     *
     * @return The value of the field "tVideoState"
     */
    inline ::videomanager_main_fi_types::T_e8_vdmSourceState getTVideoState () const;

    /**
     * Sets the value of the member "tVideoState".
     *
     * 0=unknown, 1=inactive, 2=prepare, 3=active, 4=blocked, 5=restricted (audio only), 6=error
     *
     * @param tVideoState The value which will be set
     */
    inline void setTVideoState (::videomanager_main_fi_types::T_e8_vdmSourceState tVideoState_);

    static const AcknowledgeStateStart &getDefaultInstance();

private:

    inline void set_has_tVideoSource ();

    inline void clear_has_tVideoSource ();

    inline void set_has_tVideoState ();

    inline void clear_has_tVideoState ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::videomanager_main_fi_types::T_e8_vdmVideoSource _tVideoSource;

    ::videomanager_main_fi_types::T_e8_vdmSourceState _tVideoState;

};

inline  RVCAStatus::RVCAStatus ()  :
    _RVCA_StateInfo (::videomanager_main_fi_types::T_e8_vdmSourceState__unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RVCAStatus::RVCAStatus (const RVCAStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _RVCA_StateInfo (::videomanager_main_fi_types::T_e8_vdmSourceState__unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RVCAStatus::RVCAStatus (::videomanager_main_fi_types::T_e8_vdmSourceState RVCA_StateInfo_)  :
    _RVCA_StateInfo (RVCA_StateInfo_)
{
    #ifndef NDEBUG
    if (!(::videomanager_main_fi_types::T_e8_vdmSourceState_IsValid(RVCA_StateInfo_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", RVCA_StateInfo_, "T_e8_vdmSourceState", "RVCA_StateInfo", "RVCAStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RVCAStatus::~RVCAStatus() {
}

inline RVCAStatus& RVCAStatus::operator = (const RVCAStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRVCA_StateInfo()) {
            setRVCA_StateInfo(rhs.getRVCA_StateInfo());
        } else {
            clearRVCA_StateInfo();
        }
    }
    return *this;
}

inline bool RVCAStatus::operator == (const RVCAStatus& rhs) const {
    return (((!hasRVCA_StateInfo() && !rhs.hasRVCA_StateInfo()) || getRVCA_StateInfo() == rhs.getRVCA_StateInfo()));
}

inline bool RVCAStatus::operator != (const RVCAStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool RVCAStatus::operator < (const RVCAStatus& rhs) const {
    if (hasRVCA_StateInfo() || rhs.hasRVCA_StateInfo()) {
        if ((uint32)getRVCA_StateInfo() < (uint32)rhs.getRVCA_StateInfo()) return true;
        if ((uint32)getRVCA_StateInfo() > (uint32)rhs.getRVCA_StateInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RVCAStatus::clone() {
    return new RVCAStatus(*this);
}

inline bool RVCAStatus::operator > (const RVCAStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RVCAStatus::clear() {
    clearRVCA_StateInfo();
}

inline void RVCAStatus::clearRVCA_StateInfo() {
    if (hasRVCA_StateInfo()) {
         clear_has_RVCA_StateInfo();
        _RVCA_StateInfo = ::videomanager_main_fi_types::T_e8_vdmSourceState__unknown;
     }
}

inline bool RVCAStatus::hasRVCA_StateInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::videomanager_main_fi_types::T_e8_vdmSourceState RVCAStatus::getRVCA_StateInfo () const {
    return _RVCA_StateInfo;
}

inline void RVCAStatus::setRVCA_StateInfo (::videomanager_main_fi_types::T_e8_vdmSourceState RVCA_StateInfo_) {
    #ifndef NDEBUG
    if (!(::videomanager_main_fi_types::T_e8_vdmSourceState_IsValid(RVCA_StateInfo_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", RVCA_StateInfo_, "T_e8_vdmSourceState", "RVCA_StateInfo", "RVCAStatus");
    }
    #endif
    set_has_RVCA_StateInfo();
    this->_RVCA_StateInfo = RVCA_StateInfo_;
}

inline void RVCAStatus::set_has_RVCA_StateInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void RVCAStatus::clear_has_RVCA_StateInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RVCDStatus::RVCDStatus ()  :
    _RVCD_StateInfo (::videomanager_main_fi_types::T_e8_vdmSourceState__unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RVCDStatus::RVCDStatus (const RVCDStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _RVCD_StateInfo (::videomanager_main_fi_types::T_e8_vdmSourceState__unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RVCDStatus::RVCDStatus (::videomanager_main_fi_types::T_e8_vdmSourceState RVCD_StateInfo_)  :
    _RVCD_StateInfo (RVCD_StateInfo_)
{
    #ifndef NDEBUG
    if (!(::videomanager_main_fi_types::T_e8_vdmSourceState_IsValid(RVCD_StateInfo_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", RVCD_StateInfo_, "T_e8_vdmSourceState", "RVCD_StateInfo", "RVCDStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RVCDStatus::~RVCDStatus() {
}

inline RVCDStatus& RVCDStatus::operator = (const RVCDStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRVCD_StateInfo()) {
            setRVCD_StateInfo(rhs.getRVCD_StateInfo());
        } else {
            clearRVCD_StateInfo();
        }
    }
    return *this;
}

inline bool RVCDStatus::operator == (const RVCDStatus& rhs) const {
    return (((!hasRVCD_StateInfo() && !rhs.hasRVCD_StateInfo()) || getRVCD_StateInfo() == rhs.getRVCD_StateInfo()));
}

inline bool RVCDStatus::operator != (const RVCDStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool RVCDStatus::operator < (const RVCDStatus& rhs) const {
    if (hasRVCD_StateInfo() || rhs.hasRVCD_StateInfo()) {
        if ((uint32)getRVCD_StateInfo() < (uint32)rhs.getRVCD_StateInfo()) return true;
        if ((uint32)getRVCD_StateInfo() > (uint32)rhs.getRVCD_StateInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RVCDStatus::clone() {
    return new RVCDStatus(*this);
}

inline bool RVCDStatus::operator > (const RVCDStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RVCDStatus::clear() {
    clearRVCD_StateInfo();
}

inline void RVCDStatus::clearRVCD_StateInfo() {
    if (hasRVCD_StateInfo()) {
         clear_has_RVCD_StateInfo();
        _RVCD_StateInfo = ::videomanager_main_fi_types::T_e8_vdmSourceState__unknown;
     }
}

inline bool RVCDStatus::hasRVCD_StateInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::videomanager_main_fi_types::T_e8_vdmSourceState RVCDStatus::getRVCD_StateInfo () const {
    return _RVCD_StateInfo;
}

inline void RVCDStatus::setRVCD_StateInfo (::videomanager_main_fi_types::T_e8_vdmSourceState RVCD_StateInfo_) {
    #ifndef NDEBUG
    if (!(::videomanager_main_fi_types::T_e8_vdmSourceState_IsValid(RVCD_StateInfo_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", RVCD_StateInfo_, "T_e8_vdmSourceState", "RVCD_StateInfo", "RVCDStatus");
    }
    #endif
    set_has_RVCD_StateInfo();
    this->_RVCD_StateInfo = RVCD_StateInfo_;
}

inline void RVCDStatus::set_has_RVCD_StateInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void RVCDStatus::clear_has_RVCD_StateInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DTVStatus::DTVStatus ()  :
    _DTV_StateInfo (::videomanager_main_fi_types::T_e8_vdmSourceState__unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DTVStatus::DTVStatus (const DTVStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _DTV_StateInfo (::videomanager_main_fi_types::T_e8_vdmSourceState__unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DTVStatus::DTVStatus (::videomanager_main_fi_types::T_e8_vdmSourceState DTV_StateInfo_)  :
    _DTV_StateInfo (DTV_StateInfo_)
{
    #ifndef NDEBUG
    if (!(::videomanager_main_fi_types::T_e8_vdmSourceState_IsValid(DTV_StateInfo_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DTV_StateInfo_, "T_e8_vdmSourceState", "DTV_StateInfo", "DTVStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DTVStatus::~DTVStatus() {
}

inline DTVStatus& DTVStatus::operator = (const DTVStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDTV_StateInfo()) {
            setDTV_StateInfo(rhs.getDTV_StateInfo());
        } else {
            clearDTV_StateInfo();
        }
    }
    return *this;
}

inline bool DTVStatus::operator == (const DTVStatus& rhs) const {
    return (((!hasDTV_StateInfo() && !rhs.hasDTV_StateInfo()) || getDTV_StateInfo() == rhs.getDTV_StateInfo()));
}

inline bool DTVStatus::operator != (const DTVStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool DTVStatus::operator < (const DTVStatus& rhs) const {
    if (hasDTV_StateInfo() || rhs.hasDTV_StateInfo()) {
        if ((uint32)getDTV_StateInfo() < (uint32)rhs.getDTV_StateInfo()) return true;
        if ((uint32)getDTV_StateInfo() > (uint32)rhs.getDTV_StateInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DTVStatus::clone() {
    return new DTVStatus(*this);
}

inline bool DTVStatus::operator > (const DTVStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DTVStatus::clear() {
    clearDTV_StateInfo();
}

inline void DTVStatus::clearDTV_StateInfo() {
    if (hasDTV_StateInfo()) {
         clear_has_DTV_StateInfo();
        _DTV_StateInfo = ::videomanager_main_fi_types::T_e8_vdmSourceState__unknown;
     }
}

inline bool DTVStatus::hasDTV_StateInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::videomanager_main_fi_types::T_e8_vdmSourceState DTVStatus::getDTV_StateInfo () const {
    return _DTV_StateInfo;
}

inline void DTVStatus::setDTV_StateInfo (::videomanager_main_fi_types::T_e8_vdmSourceState DTV_StateInfo_) {
    #ifndef NDEBUG
    if (!(::videomanager_main_fi_types::T_e8_vdmSourceState_IsValid(DTV_StateInfo_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DTV_StateInfo_, "T_e8_vdmSourceState", "DTV_StateInfo", "DTVStatus");
    }
    #endif
    set_has_DTV_StateInfo();
    this->_DTV_StateInfo = DTV_StateInfo_;
}

inline void DTVStatus::set_has_DTV_StateInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void DTVStatus::clear_has_DTV_StateInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SPCXStatus::SPCXStatus ()  :
    _SPCX_StateInfo (::videomanager_main_fi_types::T_e8_vdmSourceState__unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SPCXStatus::SPCXStatus (const SPCXStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _SPCX_StateInfo (::videomanager_main_fi_types::T_e8_vdmSourceState__unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SPCXStatus::SPCXStatus (::videomanager_main_fi_types::T_e8_vdmSourceState SPCX_StateInfo_)  :
    _SPCX_StateInfo (SPCX_StateInfo_)
{
    #ifndef NDEBUG
    if (!(::videomanager_main_fi_types::T_e8_vdmSourceState_IsValid(SPCX_StateInfo_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SPCX_StateInfo_, "T_e8_vdmSourceState", "SPCX_StateInfo", "SPCXStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SPCXStatus::~SPCXStatus() {
}

inline SPCXStatus& SPCXStatus::operator = (const SPCXStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSPCX_StateInfo()) {
            setSPCX_StateInfo(rhs.getSPCX_StateInfo());
        } else {
            clearSPCX_StateInfo();
        }
    }
    return *this;
}

inline bool SPCXStatus::operator == (const SPCXStatus& rhs) const {
    return (((!hasSPCX_StateInfo() && !rhs.hasSPCX_StateInfo()) || getSPCX_StateInfo() == rhs.getSPCX_StateInfo()));
}

inline bool SPCXStatus::operator != (const SPCXStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool SPCXStatus::operator < (const SPCXStatus& rhs) const {
    if (hasSPCX_StateInfo() || rhs.hasSPCX_StateInfo()) {
        if ((uint32)getSPCX_StateInfo() < (uint32)rhs.getSPCX_StateInfo()) return true;
        if ((uint32)getSPCX_StateInfo() > (uint32)rhs.getSPCX_StateInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SPCXStatus::clone() {
    return new SPCXStatus(*this);
}

inline bool SPCXStatus::operator > (const SPCXStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SPCXStatus::clear() {
    clearSPCX_StateInfo();
}

inline void SPCXStatus::clearSPCX_StateInfo() {
    if (hasSPCX_StateInfo()) {
         clear_has_SPCX_StateInfo();
        _SPCX_StateInfo = ::videomanager_main_fi_types::T_e8_vdmSourceState__unknown;
     }
}

inline bool SPCXStatus::hasSPCX_StateInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::videomanager_main_fi_types::T_e8_vdmSourceState SPCXStatus::getSPCX_StateInfo () const {
    return _SPCX_StateInfo;
}

inline void SPCXStatus::setSPCX_StateInfo (::videomanager_main_fi_types::T_e8_vdmSourceState SPCX_StateInfo_) {
    #ifndef NDEBUG
    if (!(::videomanager_main_fi_types::T_e8_vdmSourceState_IsValid(SPCX_StateInfo_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SPCX_StateInfo_, "T_e8_vdmSourceState", "SPCX_StateInfo", "SPCXStatus");
    }
    #endif
    set_has_SPCX_StateInfo();
    this->_SPCX_StateInfo = SPCX_StateInfo_;
}

inline void SPCXStatus::set_has_SPCX_StateInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void SPCXStatus::clear_has_SPCX_StateInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DVDStatus::DVDStatus ()  :
    _DVD_StateInfo (::videomanager_main_fi_types::T_e8_vdmSourceState__unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DVDStatus::DVDStatus (const DVDStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _DVD_StateInfo (::videomanager_main_fi_types::T_e8_vdmSourceState__unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DVDStatus::DVDStatus (::videomanager_main_fi_types::T_e8_vdmSourceState DVD_StateInfo_)  :
    _DVD_StateInfo (DVD_StateInfo_)
{
    #ifndef NDEBUG
    if (!(::videomanager_main_fi_types::T_e8_vdmSourceState_IsValid(DVD_StateInfo_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DVD_StateInfo_, "T_e8_vdmSourceState", "DVD_StateInfo", "DVDStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DVDStatus::~DVDStatus() {
}

inline DVDStatus& DVDStatus::operator = (const DVDStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDVD_StateInfo()) {
            setDVD_StateInfo(rhs.getDVD_StateInfo());
        } else {
            clearDVD_StateInfo();
        }
    }
    return *this;
}

inline bool DVDStatus::operator == (const DVDStatus& rhs) const {
    return (((!hasDVD_StateInfo() && !rhs.hasDVD_StateInfo()) || getDVD_StateInfo() == rhs.getDVD_StateInfo()));
}

inline bool DVDStatus::operator != (const DVDStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool DVDStatus::operator < (const DVDStatus& rhs) const {
    if (hasDVD_StateInfo() || rhs.hasDVD_StateInfo()) {
        if ((uint32)getDVD_StateInfo() < (uint32)rhs.getDVD_StateInfo()) return true;
        if ((uint32)getDVD_StateInfo() > (uint32)rhs.getDVD_StateInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DVDStatus::clone() {
    return new DVDStatus(*this);
}

inline bool DVDStatus::operator > (const DVDStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DVDStatus::clear() {
    clearDVD_StateInfo();
}

inline void DVDStatus::clearDVD_StateInfo() {
    if (hasDVD_StateInfo()) {
         clear_has_DVD_StateInfo();
        _DVD_StateInfo = ::videomanager_main_fi_types::T_e8_vdmSourceState__unknown;
     }
}

inline bool DVDStatus::hasDVD_StateInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::videomanager_main_fi_types::T_e8_vdmSourceState DVDStatus::getDVD_StateInfo () const {
    return _DVD_StateInfo;
}

inline void DVDStatus::setDVD_StateInfo (::videomanager_main_fi_types::T_e8_vdmSourceState DVD_StateInfo_) {
    #ifndef NDEBUG
    if (!(::videomanager_main_fi_types::T_e8_vdmSourceState_IsValid(DVD_StateInfo_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DVD_StateInfo_, "T_e8_vdmSourceState", "DVD_StateInfo", "DVDStatus");
    }
    #endif
    set_has_DVD_StateInfo();
    this->_DVD_StateInfo = DVD_StateInfo_;
}

inline void DVDStatus::set_has_DVD_StateInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void DVDStatus::clear_has_DVD_StateInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  USBStatus::USBStatus ()  :
    _USB_StateInfo (::videomanager_main_fi_types::T_e8_vdmSourceState__unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  USBStatus::USBStatus (const USBStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _USB_StateInfo (::videomanager_main_fi_types::T_e8_vdmSourceState__unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  USBStatus::USBStatus (::videomanager_main_fi_types::T_e8_vdmSourceState USB_StateInfo_)  :
    _USB_StateInfo (USB_StateInfo_)
{
    #ifndef NDEBUG
    if (!(::videomanager_main_fi_types::T_e8_vdmSourceState_IsValid(USB_StateInfo_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", USB_StateInfo_, "T_e8_vdmSourceState", "USB_StateInfo", "USBStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  USBStatus::~USBStatus() {
}

inline USBStatus& USBStatus::operator = (const USBStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasUSB_StateInfo()) {
            setUSB_StateInfo(rhs.getUSB_StateInfo());
        } else {
            clearUSB_StateInfo();
        }
    }
    return *this;
}

inline bool USBStatus::operator == (const USBStatus& rhs) const {
    return (((!hasUSB_StateInfo() && !rhs.hasUSB_StateInfo()) || getUSB_StateInfo() == rhs.getUSB_StateInfo()));
}

inline bool USBStatus::operator != (const USBStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool USBStatus::operator < (const USBStatus& rhs) const {
    if (hasUSB_StateInfo() || rhs.hasUSB_StateInfo()) {
        if ((uint32)getUSB_StateInfo() < (uint32)rhs.getUSB_StateInfo()) return true;
        if ((uint32)getUSB_StateInfo() > (uint32)rhs.getUSB_StateInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* USBStatus::clone() {
    return new USBStatus(*this);
}

inline bool USBStatus::operator > (const USBStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void USBStatus::clear() {
    clearUSB_StateInfo();
}

inline void USBStatus::clearUSB_StateInfo() {
    if (hasUSB_StateInfo()) {
         clear_has_USB_StateInfo();
        _USB_StateInfo = ::videomanager_main_fi_types::T_e8_vdmSourceState__unknown;
     }
}

inline bool USBStatus::hasUSB_StateInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::videomanager_main_fi_types::T_e8_vdmSourceState USBStatus::getUSB_StateInfo () const {
    return _USB_StateInfo;
}

inline void USBStatus::setUSB_StateInfo (::videomanager_main_fi_types::T_e8_vdmSourceState USB_StateInfo_) {
    #ifndef NDEBUG
    if (!(::videomanager_main_fi_types::T_e8_vdmSourceState_IsValid(USB_StateInfo_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", USB_StateInfo_, "T_e8_vdmSourceState", "USB_StateInfo", "USBStatus");
    }
    #endif
    set_has_USB_StateInfo();
    this->_USB_StateInfo = USB_StateInfo_;
}

inline void USBStatus::set_has_USB_StateInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void USBStatus::clear_has_USB_StateInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DeserializerUsedByStatus::DeserializerUsedByStatus ()  :
    _Deserializer_SourceInfo (::videomanager_main_fi_types::T_e8_vdmVideoSource__NONE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DeserializerUsedByStatus::DeserializerUsedByStatus (const DeserializerUsedByStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _Deserializer_SourceInfo (::videomanager_main_fi_types::T_e8_vdmVideoSource__NONE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DeserializerUsedByStatus::DeserializerUsedByStatus (::videomanager_main_fi_types::T_e8_vdmVideoSource Deserializer_SourceInfo_)  :
    _Deserializer_SourceInfo (Deserializer_SourceInfo_)
{
    #ifndef NDEBUG
    if (!(::videomanager_main_fi_types::T_e8_vdmVideoSource_IsValid(Deserializer_SourceInfo_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Deserializer_SourceInfo_, "T_e8_vdmVideoSource", "Deserializer_SourceInfo", "DeserializerUsedByStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DeserializerUsedByStatus::~DeserializerUsedByStatus() {
}

inline DeserializerUsedByStatus& DeserializerUsedByStatus::operator = (const DeserializerUsedByStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDeserializer_SourceInfo()) {
            setDeserializer_SourceInfo(rhs.getDeserializer_SourceInfo());
        } else {
            clearDeserializer_SourceInfo();
        }
    }
    return *this;
}

inline bool DeserializerUsedByStatus::operator == (const DeserializerUsedByStatus& rhs) const {
    return (((!hasDeserializer_SourceInfo() && !rhs.hasDeserializer_SourceInfo()) || getDeserializer_SourceInfo() == rhs.getDeserializer_SourceInfo()));
}

inline bool DeserializerUsedByStatus::operator != (const DeserializerUsedByStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool DeserializerUsedByStatus::operator < (const DeserializerUsedByStatus& rhs) const {
    if (hasDeserializer_SourceInfo() || rhs.hasDeserializer_SourceInfo()) {
        if ((uint32)getDeserializer_SourceInfo() < (uint32)rhs.getDeserializer_SourceInfo()) return true;
        if ((uint32)getDeserializer_SourceInfo() > (uint32)rhs.getDeserializer_SourceInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DeserializerUsedByStatus::clone() {
    return new DeserializerUsedByStatus(*this);
}

inline bool DeserializerUsedByStatus::operator > (const DeserializerUsedByStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DeserializerUsedByStatus::clear() {
    clearDeserializer_SourceInfo();
}

inline void DeserializerUsedByStatus::clearDeserializer_SourceInfo() {
    if (hasDeserializer_SourceInfo()) {
         clear_has_Deserializer_SourceInfo();
        _Deserializer_SourceInfo = ::videomanager_main_fi_types::T_e8_vdmVideoSource__NONE;
     }
}

inline bool DeserializerUsedByStatus::hasDeserializer_SourceInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::videomanager_main_fi_types::T_e8_vdmVideoSource DeserializerUsedByStatus::getDeserializer_SourceInfo () const {
    return _Deserializer_SourceInfo;
}

inline void DeserializerUsedByStatus::setDeserializer_SourceInfo (::videomanager_main_fi_types::T_e8_vdmVideoSource Deserializer_SourceInfo_) {
    #ifndef NDEBUG
    if (!(::videomanager_main_fi_types::T_e8_vdmVideoSource_IsValid(Deserializer_SourceInfo_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Deserializer_SourceInfo_, "T_e8_vdmVideoSource", "Deserializer_SourceInfo", "DeserializerUsedByStatus");
    }
    #endif
    set_has_Deserializer_SourceInfo();
    this->_Deserializer_SourceInfo = Deserializer_SourceInfo_;
}

inline void DeserializerUsedByStatus::set_has_Deserializer_SourceInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void DeserializerUsedByStatus::clear_has_Deserializer_SourceInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RequestVideoSourceStateStart::RequestVideoSourceStateStart ()  :
    _tVideoSource (::videomanager_main_fi_types::T_e8_vdmVideoSource__NONE),
    _tRequestedState (::videomanager_main_fi_types::T_e8_vdmRequestedSourceState__inactive)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequestVideoSourceStateStart::RequestVideoSourceStateStart (const RequestVideoSourceStateStart &rhs)  :
    ::asf::core::Payload(rhs),
    _tVideoSource (::videomanager_main_fi_types::T_e8_vdmVideoSource__NONE),
    _tRequestedState (::videomanager_main_fi_types::T_e8_vdmRequestedSourceState__inactive)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequestVideoSourceStateStart::RequestVideoSourceStateStart (::videomanager_main_fi_types::T_e8_vdmVideoSource tVideoSource_, ::videomanager_main_fi_types::T_e8_vdmRequestedSourceState tRequestedState_)  :
    _tVideoSource (tVideoSource_),
    _tRequestedState (tRequestedState_)
{
    #ifndef NDEBUG
    if (!(::videomanager_main_fi_types::T_e8_vdmVideoSource_IsValid(tVideoSource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", tVideoSource_, "T_e8_vdmVideoSource", "tVideoSource", "RequestVideoSourceStateStart");
    }
    #endif
    #ifndef NDEBUG
    if (!(::videomanager_main_fi_types::T_e8_vdmRequestedSourceState_IsValid(tRequestedState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", tRequestedState_, "T_e8_vdmRequestedSourceState", "tRequestedState", "RequestVideoSourceStateStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequestVideoSourceStateStart::~RequestVideoSourceStateStart() {
}

inline RequestVideoSourceStateStart& RequestVideoSourceStateStart::operator = (const RequestVideoSourceStateStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTVideoSource()) {
            setTVideoSource(rhs.getTVideoSource());
        } else {
            clearTVideoSource();
        }
        if (rhs.hasTRequestedState()) {
            setTRequestedState(rhs.getTRequestedState());
        } else {
            clearTRequestedState();
        }
    }
    return *this;
}

inline bool RequestVideoSourceStateStart::operator == (const RequestVideoSourceStateStart& rhs) const {
    return (((!hasTVideoSource() && !rhs.hasTVideoSource()) || getTVideoSource() == rhs.getTVideoSource()) &&
        ((!hasTRequestedState() && !rhs.hasTRequestedState()) || getTRequestedState() == rhs.getTRequestedState()));
}

inline bool RequestVideoSourceStateStart::operator != (const RequestVideoSourceStateStart& rhs) const {
    return ! (*this == rhs);
}

inline bool RequestVideoSourceStateStart::operator < (const RequestVideoSourceStateStart& rhs) const {
    if (hasTVideoSource() || rhs.hasTVideoSource()) {
        if ((uint32)getTVideoSource() < (uint32)rhs.getTVideoSource()) return true;
        if ((uint32)getTVideoSource() > (uint32)rhs.getTVideoSource()) return false;
    }
    if (hasTRequestedState() || rhs.hasTRequestedState()) {
        if ((uint32)getTRequestedState() < (uint32)rhs.getTRequestedState()) return true;
        if ((uint32)getTRequestedState() > (uint32)rhs.getTRequestedState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RequestVideoSourceStateStart::clone() {
    return new RequestVideoSourceStateStart(*this);
}

inline bool RequestVideoSourceStateStart::operator > (const RequestVideoSourceStateStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequestVideoSourceStateStart::clear() {
    clearTVideoSource();
    clearTRequestedState();
}

inline void RequestVideoSourceStateStart::clearTVideoSource() {
    if (hasTVideoSource()) {
         clear_has_tVideoSource();
        _tVideoSource = ::videomanager_main_fi_types::T_e8_vdmVideoSource__NONE;
     }
}

inline bool RequestVideoSourceStateStart::hasTVideoSource () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::videomanager_main_fi_types::T_e8_vdmVideoSource RequestVideoSourceStateStart::getTVideoSource () const {
    return _tVideoSource;
}

inline void RequestVideoSourceStateStart::setTVideoSource (::videomanager_main_fi_types::T_e8_vdmVideoSource tVideoSource_) {
    #ifndef NDEBUG
    if (!(::videomanager_main_fi_types::T_e8_vdmVideoSource_IsValid(tVideoSource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", tVideoSource_, "T_e8_vdmVideoSource", "tVideoSource", "RequestVideoSourceStateStart");
    }
    #endif
    set_has_tVideoSource();
    this->_tVideoSource = tVideoSource_;
}

inline void RequestVideoSourceStateStart::clearTRequestedState() {
    if (hasTRequestedState()) {
         clear_has_tRequestedState();
        _tRequestedState = ::videomanager_main_fi_types::T_e8_vdmRequestedSourceState__inactive;
     }
}

inline bool RequestVideoSourceStateStart::hasTRequestedState () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::videomanager_main_fi_types::T_e8_vdmRequestedSourceState RequestVideoSourceStateStart::getTRequestedState () const {
    return _tRequestedState;
}

inline void RequestVideoSourceStateStart::setTRequestedState (::videomanager_main_fi_types::T_e8_vdmRequestedSourceState tRequestedState_) {
    #ifndef NDEBUG
    if (!(::videomanager_main_fi_types::T_e8_vdmRequestedSourceState_IsValid(tRequestedState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", tRequestedState_, "T_e8_vdmRequestedSourceState", "tRequestedState", "RequestVideoSourceStateStart");
    }
    #endif
    set_has_tRequestedState();
    this->_tRequestedState = tRequestedState_;
}

inline void RequestVideoSourceStateStart::set_has_tVideoSource () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequestVideoSourceStateStart::clear_has_tVideoSource () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RequestVideoSourceStateStart::set_has_tRequestedState () {
    _has_bits_[0] |= 1u << 1;
}

inline void RequestVideoSourceStateStart::clear_has_tRequestedState () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  RequestVideoSourceStateResult::RequestVideoSourceStateResult ()  :
    _bSourceChangeGranted (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequestVideoSourceStateResult::RequestVideoSourceStateResult (const RequestVideoSourceStateResult &rhs)  :
    ::asf::core::Payload(rhs),
    _bSourceChangeGranted (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequestVideoSourceStateResult::RequestVideoSourceStateResult (bool bSourceChangeGranted_)  :
    _bSourceChangeGranted (bSourceChangeGranted_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequestVideoSourceStateResult::~RequestVideoSourceStateResult() {
}

inline RequestVideoSourceStateResult& RequestVideoSourceStateResult::operator = (const RequestVideoSourceStateResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBSourceChangeGranted()) {
            setBSourceChangeGranted(rhs.getBSourceChangeGranted());
        } else {
            clearBSourceChangeGranted();
        }
    }
    return *this;
}

inline bool RequestVideoSourceStateResult::operator == (const RequestVideoSourceStateResult& rhs) const {
    return (((!hasBSourceChangeGranted() && !rhs.hasBSourceChangeGranted()) || getBSourceChangeGranted() == rhs.getBSourceChangeGranted()));
}

inline bool RequestVideoSourceStateResult::operator != (const RequestVideoSourceStateResult& rhs) const {
    return ! (*this == rhs);
}

inline bool RequestVideoSourceStateResult::operator < (const RequestVideoSourceStateResult& rhs) const {
    if (hasBSourceChangeGranted() || rhs.hasBSourceChangeGranted()) {
        if (getBSourceChangeGranted() < rhs.getBSourceChangeGranted()) return true;
        if (getBSourceChangeGranted() > rhs.getBSourceChangeGranted()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RequestVideoSourceStateResult::clone() {
    return new RequestVideoSourceStateResult(*this);
}

inline bool RequestVideoSourceStateResult::operator > (const RequestVideoSourceStateResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequestVideoSourceStateResult::clear() {
    clearBSourceChangeGranted();
}

inline void RequestVideoSourceStateResult::clearBSourceChangeGranted() {
    if (hasBSourceChangeGranted()) {
         clear_has_bSourceChangeGranted();
        _bSourceChangeGranted = false;
     }
}

inline bool RequestVideoSourceStateResult::hasBSourceChangeGranted () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool RequestVideoSourceStateResult::getBSourceChangeGranted () const {
    return _bSourceChangeGranted;
}

inline void RequestVideoSourceStateResult::setBSourceChangeGranted (bool bSourceChangeGranted_) {
    set_has_bSourceChangeGranted();
    this->_bSourceChangeGranted = bSourceChangeGranted_;
}

inline void RequestVideoSourceStateResult::set_has_bSourceChangeGranted () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequestVideoSourceStateResult::clear_has_bSourceChangeGranted () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RequestAccessToDeserializerStart::RequestAccessToDeserializerStart ()  :
    _tVideoSource (::videomanager_main_fi_types::T_e8_vdmVideoSource__NONE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequestAccessToDeserializerStart::RequestAccessToDeserializerStart (const RequestAccessToDeserializerStart &rhs)  :
    ::asf::core::Payload(rhs),
    _tVideoSource (::videomanager_main_fi_types::T_e8_vdmVideoSource__NONE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequestAccessToDeserializerStart::RequestAccessToDeserializerStart (::videomanager_main_fi_types::T_e8_vdmVideoSource tVideoSource_)  :
    _tVideoSource (tVideoSource_)
{
    #ifndef NDEBUG
    if (!(::videomanager_main_fi_types::T_e8_vdmVideoSource_IsValid(tVideoSource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", tVideoSource_, "T_e8_vdmVideoSource", "tVideoSource", "RequestAccessToDeserializerStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequestAccessToDeserializerStart::~RequestAccessToDeserializerStart() {
}

inline RequestAccessToDeserializerStart& RequestAccessToDeserializerStart::operator = (const RequestAccessToDeserializerStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTVideoSource()) {
            setTVideoSource(rhs.getTVideoSource());
        } else {
            clearTVideoSource();
        }
    }
    return *this;
}

inline bool RequestAccessToDeserializerStart::operator == (const RequestAccessToDeserializerStart& rhs) const {
    return (((!hasTVideoSource() && !rhs.hasTVideoSource()) || getTVideoSource() == rhs.getTVideoSource()));
}

inline bool RequestAccessToDeserializerStart::operator != (const RequestAccessToDeserializerStart& rhs) const {
    return ! (*this == rhs);
}

inline bool RequestAccessToDeserializerStart::operator < (const RequestAccessToDeserializerStart& rhs) const {
    if (hasTVideoSource() || rhs.hasTVideoSource()) {
        if ((uint32)getTVideoSource() < (uint32)rhs.getTVideoSource()) return true;
        if ((uint32)getTVideoSource() > (uint32)rhs.getTVideoSource()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RequestAccessToDeserializerStart::clone() {
    return new RequestAccessToDeserializerStart(*this);
}

inline bool RequestAccessToDeserializerStart::operator > (const RequestAccessToDeserializerStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequestAccessToDeserializerStart::clear() {
    clearTVideoSource();
}

inline void RequestAccessToDeserializerStart::clearTVideoSource() {
    if (hasTVideoSource()) {
         clear_has_tVideoSource();
        _tVideoSource = ::videomanager_main_fi_types::T_e8_vdmVideoSource__NONE;
     }
}

inline bool RequestAccessToDeserializerStart::hasTVideoSource () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::videomanager_main_fi_types::T_e8_vdmVideoSource RequestAccessToDeserializerStart::getTVideoSource () const {
    return _tVideoSource;
}

inline void RequestAccessToDeserializerStart::setTVideoSource (::videomanager_main_fi_types::T_e8_vdmVideoSource tVideoSource_) {
    #ifndef NDEBUG
    if (!(::videomanager_main_fi_types::T_e8_vdmVideoSource_IsValid(tVideoSource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", tVideoSource_, "T_e8_vdmVideoSource", "tVideoSource", "RequestAccessToDeserializerStart");
    }
    #endif
    set_has_tVideoSource();
    this->_tVideoSource = tVideoSource_;
}

inline void RequestAccessToDeserializerStart::set_has_tVideoSource () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequestAccessToDeserializerStart::clear_has_tVideoSource () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RequestAccessToDeserializerResult::RequestAccessToDeserializerResult ()  :
    _bAccessIsGranted (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequestAccessToDeserializerResult::RequestAccessToDeserializerResult (const RequestAccessToDeserializerResult &rhs)  :
    ::asf::core::Payload(rhs),
    _bAccessIsGranted (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequestAccessToDeserializerResult::RequestAccessToDeserializerResult (bool bAccessIsGranted_)  :
    _bAccessIsGranted (bAccessIsGranted_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequestAccessToDeserializerResult::~RequestAccessToDeserializerResult() {
}

inline RequestAccessToDeserializerResult& RequestAccessToDeserializerResult::operator = (const RequestAccessToDeserializerResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBAccessIsGranted()) {
            setBAccessIsGranted(rhs.getBAccessIsGranted());
        } else {
            clearBAccessIsGranted();
        }
    }
    return *this;
}

inline bool RequestAccessToDeserializerResult::operator == (const RequestAccessToDeserializerResult& rhs) const {
    return (((!hasBAccessIsGranted() && !rhs.hasBAccessIsGranted()) || getBAccessIsGranted() == rhs.getBAccessIsGranted()));
}

inline bool RequestAccessToDeserializerResult::operator != (const RequestAccessToDeserializerResult& rhs) const {
    return ! (*this == rhs);
}

inline bool RequestAccessToDeserializerResult::operator < (const RequestAccessToDeserializerResult& rhs) const {
    if (hasBAccessIsGranted() || rhs.hasBAccessIsGranted()) {
        if (getBAccessIsGranted() < rhs.getBAccessIsGranted()) return true;
        if (getBAccessIsGranted() > rhs.getBAccessIsGranted()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RequestAccessToDeserializerResult::clone() {
    return new RequestAccessToDeserializerResult(*this);
}

inline bool RequestAccessToDeserializerResult::operator > (const RequestAccessToDeserializerResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequestAccessToDeserializerResult::clear() {
    clearBAccessIsGranted();
}

inline void RequestAccessToDeserializerResult::clearBAccessIsGranted() {
    if (hasBAccessIsGranted()) {
         clear_has_bAccessIsGranted();
        _bAccessIsGranted = false;
     }
}

inline bool RequestAccessToDeserializerResult::hasBAccessIsGranted () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool RequestAccessToDeserializerResult::getBAccessIsGranted () const {
    return _bAccessIsGranted;
}

inline void RequestAccessToDeserializerResult::setBAccessIsGranted (bool bAccessIsGranted_) {
    set_has_bAccessIsGranted();
    this->_bAccessIsGranted = bAccessIsGranted_;
}

inline void RequestAccessToDeserializerResult::set_has_bAccessIsGranted () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequestAccessToDeserializerResult::clear_has_bAccessIsGranted () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AcknowledgeStateStart::AcknowledgeStateStart ()  :
    _tVideoSource (::videomanager_main_fi_types::T_e8_vdmVideoSource__NONE),
    _tVideoState (::videomanager_main_fi_types::T_e8_vdmSourceState__unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AcknowledgeStateStart::AcknowledgeStateStart (const AcknowledgeStateStart &rhs)  :
    ::asf::core::Payload(rhs),
    _tVideoSource (::videomanager_main_fi_types::T_e8_vdmVideoSource__NONE),
    _tVideoState (::videomanager_main_fi_types::T_e8_vdmSourceState__unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AcknowledgeStateStart::AcknowledgeStateStart (::videomanager_main_fi_types::T_e8_vdmVideoSource tVideoSource_, ::videomanager_main_fi_types::T_e8_vdmSourceState tVideoState_)  :
    _tVideoSource (tVideoSource_),
    _tVideoState (tVideoState_)
{
    #ifndef NDEBUG
    if (!(::videomanager_main_fi_types::T_e8_vdmVideoSource_IsValid(tVideoSource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", tVideoSource_, "T_e8_vdmVideoSource", "tVideoSource", "AcknowledgeStateStart");
    }
    #endif
    #ifndef NDEBUG
    if (!(::videomanager_main_fi_types::T_e8_vdmSourceState_IsValid(tVideoState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", tVideoState_, "T_e8_vdmSourceState", "tVideoState", "AcknowledgeStateStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AcknowledgeStateStart::~AcknowledgeStateStart() {
}

inline AcknowledgeStateStart& AcknowledgeStateStart::operator = (const AcknowledgeStateStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTVideoSource()) {
            setTVideoSource(rhs.getTVideoSource());
        } else {
            clearTVideoSource();
        }
        if (rhs.hasTVideoState()) {
            setTVideoState(rhs.getTVideoState());
        } else {
            clearTVideoState();
        }
    }
    return *this;
}

inline bool AcknowledgeStateStart::operator == (const AcknowledgeStateStart& rhs) const {
    return (((!hasTVideoSource() && !rhs.hasTVideoSource()) || getTVideoSource() == rhs.getTVideoSource()) &&
        ((!hasTVideoState() && !rhs.hasTVideoState()) || getTVideoState() == rhs.getTVideoState()));
}

inline bool AcknowledgeStateStart::operator != (const AcknowledgeStateStart& rhs) const {
    return ! (*this == rhs);
}

inline bool AcknowledgeStateStart::operator < (const AcknowledgeStateStart& rhs) const {
    if (hasTVideoSource() || rhs.hasTVideoSource()) {
        if ((uint32)getTVideoSource() < (uint32)rhs.getTVideoSource()) return true;
        if ((uint32)getTVideoSource() > (uint32)rhs.getTVideoSource()) return false;
    }
    if (hasTVideoState() || rhs.hasTVideoState()) {
        if ((uint32)getTVideoState() < (uint32)rhs.getTVideoState()) return true;
        if ((uint32)getTVideoState() > (uint32)rhs.getTVideoState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AcknowledgeStateStart::clone() {
    return new AcknowledgeStateStart(*this);
}

inline bool AcknowledgeStateStart::operator > (const AcknowledgeStateStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AcknowledgeStateStart::clear() {
    clearTVideoSource();
    clearTVideoState();
}

inline void AcknowledgeStateStart::clearTVideoSource() {
    if (hasTVideoSource()) {
         clear_has_tVideoSource();
        _tVideoSource = ::videomanager_main_fi_types::T_e8_vdmVideoSource__NONE;
     }
}

inline bool AcknowledgeStateStart::hasTVideoSource () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::videomanager_main_fi_types::T_e8_vdmVideoSource AcknowledgeStateStart::getTVideoSource () const {
    return _tVideoSource;
}

inline void AcknowledgeStateStart::setTVideoSource (::videomanager_main_fi_types::T_e8_vdmVideoSource tVideoSource_) {
    #ifndef NDEBUG
    if (!(::videomanager_main_fi_types::T_e8_vdmVideoSource_IsValid(tVideoSource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", tVideoSource_, "T_e8_vdmVideoSource", "tVideoSource", "AcknowledgeStateStart");
    }
    #endif
    set_has_tVideoSource();
    this->_tVideoSource = tVideoSource_;
}

inline void AcknowledgeStateStart::clearTVideoState() {
    if (hasTVideoState()) {
         clear_has_tVideoState();
        _tVideoState = ::videomanager_main_fi_types::T_e8_vdmSourceState__unknown;
     }
}

inline bool AcknowledgeStateStart::hasTVideoState () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::videomanager_main_fi_types::T_e8_vdmSourceState AcknowledgeStateStart::getTVideoState () const {
    return _tVideoState;
}

inline void AcknowledgeStateStart::setTVideoState (::videomanager_main_fi_types::T_e8_vdmSourceState tVideoState_) {
    #ifndef NDEBUG
    if (!(::videomanager_main_fi_types::T_e8_vdmSourceState_IsValid(tVideoState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", tVideoState_, "T_e8_vdmSourceState", "tVideoState", "AcknowledgeStateStart");
    }
    #endif
    set_has_tVideoState();
    this->_tVideoState = tVideoState_;
}

inline void AcknowledgeStateStart::set_has_tVideoSource () {
    _has_bits_[0] |= 1u << 0;
}

inline void AcknowledgeStateStart::clear_has_tVideoSource () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void AcknowledgeStateStart::set_has_tVideoState () {
    _has_bits_[0] |= 1u << 1;
}

inline void AcknowledgeStateStart::clear_has_tVideoState () {
    _has_bits_[0] &= ~ (1u << 1);
}

} // namespace videomanager_main_fi

#endif // VIDEOMANAGER_MAIN_FI_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
