#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef TUNERMASTER_MAIN_FI_H
#define TUNERMASTER_MAIN_FI_H

#include "asf/cca/CcaTypes.h"
#include "asf/cca/CcaTypesConst.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "tunermaster_main_fi_types.h"
#include "tunermaster_main_fi_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * CCA Functional Interface 'tunermaster_main_fi'
 *
 * Fullname: Middleware Tuner Master Server Functional Interface
 *
 * Version: $Revision:   2.0  $
 *
 * Author: Pallavi HN
 *
 * Date: $Date:   April 4 2011 11:55:14  $
 *
 * Department: CM-AI/PJ-VW36
 *
 * Title: tunermaster_main_fi
 *
 * <b>Description of 'tunermaster_main_fi':</b>
 *
 * This interface file of TunerMaster . HMI interface document must be taken from Docu share.
 */

namespace tunermaster_main_fi {

static const int SERVICE_ID = 286;

static const int FID_FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENT = 35;

static const int FID_FID_TUNMSTR_S_STOP_ANNOUNCEMENT = 4;

static const int FID_FID_TUNMSTR_S_BAND_CHANGE = 5;

static const int FID_FID_TUNMSTR_S_RF_ANTENNA_TEST = 7;

static const int FID_FID_TUNMSTR_S_TEST_MODE = 8;

static const int FID_FID_TUNMSTR_S_SRCCHG_TESTMODE = 9;

static const int FID_FID_TUNMSTR_S_GET_ACTIVETUNER_INFO = 16;

static const int FID_FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUT = 32;

static const int FID_FID_TUNMSTR_S_PRESET_HANDLING = 33;

static const int FID_FID_TUNMSTR_S_AUTOSTORE = 34;

static const int FID_FID_TUNMSTR_S_MTC_SETMODE = 36;

static const int FID_FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCY = 37;

static const int FID_FID_TUNMSTR_S_STATION_SELECTION = 38;

static const int FID_FID_TUNMSTR_S_SOURCE_SETUP_OPTION = 10;

static const int FID_FID_TUNMSTR_S_RADIOPROFILE_SETTING = 39;

static const int FID_FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUEST = 11;

static const int FID_FID_TUNMSTR_G_SET_DTVAntennaRegister = 17;

static const int FID_FID_TUNMSTR_G_TA_STATUS = 18;

static const int FID_FID_TUNMSTR_G_TP_STATUS = 19;

static const int FID_FID_TUNMSTR_G_SOURCE_CHANGE = 20;

static const int FID_FID_TUNMSTR_G_BAND_INFO = 21;

static const int FID_FID_TUNMSTR_G_RF_ANTENNA_TEST = 22;

static const int FID_FID_TUNMSTR_G_PRESET_LIST = 23;

static const int FID_FID_TUNMSTR_G_ANNO_BUTTON_STATUS = 24;

static const int FID_FID_TUNMSTR_G_ANNOUNCEMENT_STATUS = 25;

static const int FID_FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITY = 49;

static const int FID_FID_TUNMSTR_G_GET_AUTOSTORE_STATUS = 50;

static const int FID_FID_TUNMSTR_G_MTC_SETMODE_STATUS = 51;

static const int FID_FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUS = 52;

static const int FID_FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITY = 53;

static const int FID_FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATION = 54;

static const int FID_FID_TUNMSTR_G_PRESET_CHANNEL_UPDATE = 55;


ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 3;

static const int VERSION_MINOR = 1;

static const int VERSION_PATCH = 0;

// forward declarations
class FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart;

class FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult;

class FID_TUNMSTR_S_STOP_ANNOUNCEMENTStart;

class FID_TUNMSTR_S_STOP_ANNOUNCEMENTResult;

class FID_TUNMSTR_S_BAND_CHANGEStart;

class FID_TUNMSTR_S_BAND_CHANGEResult;

class FID_TUNMSTR_S_RF_ANTENNA_TESTStart;

class FID_TUNMSTR_S_RF_ANTENNA_TESTResult;

class FID_TUNMSTR_S_TEST_MODEStart;

class FID_TUNMSTR_S_TEST_MODEResult;

class FID_TUNMSTR_S_SRCCHG_TESTMODEStart;

class FID_TUNMSTR_S_SRCCHG_TESTMODEResult;

class FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult;

class FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart;

class FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTResult;

class FID_TUNMSTR_S_PRESET_HANDLINGStart;

class FID_TUNMSTR_S_PRESET_HANDLINGResult;

class FID_TUNMSTR_S_AUTOSTOREStart;

class FID_TUNMSTR_S_AUTOSTOREResult;

class FID_TUNMSTR_S_MTC_SETMODEStart;

class FID_TUNMSTR_S_MTC_SETMODEResult;

class FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYStart;

class FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYResult;

class FID_TUNMSTR_S_STATION_SELECTIONStart;

class FID_TUNMSTR_S_STATION_SELECTIONResult;

class FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart;

class FID_TUNMSTR_S_SOURCE_SETUP_OPTIONResult;

class FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart;

class FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult;

class FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart;

class FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult;

class FID_TUNMSTR_G_SET_DTVAntennaRegisterStatus;

class FID_TUNMSTR_G_TA_STATUSStatus;

class FID_TUNMSTR_G_TP_STATUSStatus;

class FID_TUNMSTR_G_SOURCE_CHANGEStatus;

class FID_TUNMSTR_G_BAND_INFOStatus;

class FID_TUNMSTR_G_RF_ANTENNA_TESTStatus;

class FID_TUNMSTR_G_PRESET_LISTStatus;

class FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus;

class FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus;

class FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus;

class FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus;

class FID_TUNMSTR_G_MTC_SETMODE_STATUSStatus;

class FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus;

class FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus;

class FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus;

class FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure;

class FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError;

class FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus;

// type definitions
/**
 * The abort error message of the method "FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENT"
 * This message can be used to set status of different Announcement type softkeys like, TA , PTY31 and Other Announcement.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTAbortError;

/**
 * The error message of 'FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENT'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTError;

/**
 * The abort error message of the method "FID_TUNMSTR_S_STOP_ANNOUNCEMENT"
 * This method is used to send stop announcement infomation from HMI.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUNMSTR_S_STOP_ANNOUNCEMENTAbortError;

/**
 * The error message of 'FID_TUNMSTR_S_STOP_ANNOUNCEMENT'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUNMSTR_S_STOP_ANNOUNCEMENTError;

/**
 * The abort error message of the method "FID_TUNMSTR_S_BAND_CHANGE"
 * This method is used to send Band Change Infomation from HMI.
 * In G3g since in most of the project band change info goes to Audio directly from HMI, this message is not used extensively.
 * If none of the project require this method, it will be removed in CW 01.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUNMSTR_S_BAND_CHANGEAbortError;

/**
 * The error message of 'FID_TUNMSTR_S_BAND_CHANGE'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUNMSTR_S_BAND_CHANGEError;

/**
 * The abort error message of the method "FID_TUNMSTR_S_RF_ANTENNA_TEST"
 * Through this method, tuner tells HMI if he detected
 * an error in any of the supervised supplies
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUNMSTR_S_RF_ANTENNA_TESTAbortError;

/**
 * The error message of 'FID_TUNMSTR_S_RF_ANTENNA_TEST'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUNMSTR_S_RF_ANTENNA_TESTError;

/**
 * The abort error message of the method "FID_TUNMSTR_S_TEST_MODE"
 * This method indicates if Tuner Test mode is enable or not.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUNMSTR_S_TEST_MODEAbortError;

/**
 * The error message of 'FID_TUNMSTR_S_TEST_MODE'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUNMSTR_S_TEST_MODEError;

/**
 * The abort error message of the method "FID_TUNMSTR_S_SRCCHG_TESTMODE"
 * This method is used to trigger soucre change b/w different tuners in test mode
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUNMSTR_S_SRCCHG_TESTMODEAbortError;

/**
 * The error message of 'FID_TUNMSTR_S_SRCCHG_TESTMODE'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUNMSTR_S_SRCCHG_TESTMODEError;

/**
 * The start message of the method "FID_TUNMSTR_S_GET_ACTIVETUNER_INFO"
 * This method will give infomation about current active tuner in test mode.
 * --.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUNMSTR_S_GET_ACTIVETUNER_INFOStart;

/**
 * The abort error message of the method "FID_TUNMSTR_S_GET_ACTIVETUNER_INFO"
 * This method will give infomation about current active tuner in test mode.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUNMSTR_S_GET_ACTIVETUNER_INFOAbortError;

/**
 * The error message of 'FID_TUNMSTR_S_GET_ACTIVETUNER_INFO'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUNMSTR_S_GET_ACTIVETUNER_INFOError;

/**
 * The abort error message of the method "FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUT"
 * This method will set frequency value only in case of SDS session. for other use cases please use fc_tmctuner message
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTAbortError;

/**
 * The error message of 'FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUT'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTError;

/**
 * The abort error message of the method "FID_TUNMSTR_S_PRESET_HANDLING"
 * This message is used to handle multiple functionalities of preset list like Preset Recall, save, Delete one element and delete all elelemet from the list.
 * Which functionality to be performed will be decided based on Value specified in Preset_Action parameter.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUNMSTR_S_PRESET_HANDLINGAbortError;

/**
 * The error message of 'FID_TUNMSTR_S_PRESET_HANDLING'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUNMSTR_S_PRESET_HANDLINGError;

/**
 * The abort error message of the method "FID_TUNMSTR_S_AUTOSTORE"
 * This command is used to initiate Auto store
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUNMSTR_S_AUTOSTOREAbortError;

/**
 * The error message of 'FID_TUNMSTR_S_AUTOSTORE'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUNMSTR_S_AUTOSTOREError;

/**
 * The abort error message of the method "FID_TUNMSTR_S_MTC_SETMODE"
 * Sets the mode for the service switch request. It can be OFF, DAB to FM switching or FM to DAB switching.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUNMSTR_S_MTC_SETMODEAbortError;

/**
 * The error message of 'FID_TUNMSTR_S_MTC_SETMODE'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUNMSTR_S_MTC_SETMODEError;

/**
 * The abort error message of the method "FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCY"
 * This method is used to set the DRM frequency directly  by SDS
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYAbortError;

/**
 * The error message of 'FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCY'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYError;

/**
 * The abort error message of the method "FID_TUNMSTR_S_STATION_SELECTION"
 * This method is used by SDS to select station through frequency input , preset number , station name
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUNMSTR_S_STATION_SELECTIONAbortError;

/**
 * The error message of 'FID_TUNMSTR_S_STATION_SELECTION'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUNMSTR_S_STATION_SELECTIONError;

/**
 * The abort error message of the method "FID_TUNMSTR_S_SOURCE_SETUP_OPTION"
 * This method is used by clients to Enable/Disable the Tuner dynamic source.
 * <p>Currently only AM source is supported. Please contact reception team for other source</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUNMSTR_S_SOURCE_SETUP_OPTIONAbortError;

/**
 * The error message of 'FID_TUNMSTR_S_SOURCE_SETUP_OPTION'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUNMSTR_S_SOURCE_SETUP_OPTIONError;

/**
 * The abort error message of the method "FID_TUNMSTR_S_RADIOPROFILE_SETTING"
 * Message will contain tuner parameters required for radio profile setting for current user.
 * Currently, Presets and AM Switch are supported.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUNMSTR_S_RADIOPROFILE_SETTINGAbortError;

/**
 * The error message of 'FID_TUNMSTR_S_RADIOPROFILE_SETTING'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUNMSTR_S_RADIOPROFILE_SETTINGError;

/**
 * The abort error message of the method "FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUEST"
 * Method used to request Presets or/and AM switch for profile radio settings synchronization . To get the complete preset List , list size should be Zero
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTAbortError;

/**
 * The error message of 'FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUEST'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTError;

/**
 * The set message of the property "FID_TUNMSTR_G_SET_DTVAntennaRegister"
 * This property will set the DTV Antenna Power supply(example ELMOS IC) current register(Open/Over Current register) based on the KDS configuration in "CM_VariantCoding" and AntennaParameterSet"
 * For IVI, the request needs to be send when LVDS link is active
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUNMSTR_G_SET_DTVAntennaRegisterSet;

/**
 * The upreg message of the property "FID_TUNMSTR_G_SET_DTVAntennaRegister"
 * This property will set the DTV Antenna Power supply(example ELMOS IC) current register(Open/Over Current register) based on the KDS configuration in "CM_VariantCoding" and AntennaParameterSet"
 * For IVI, the request needs to be send when LVDS link is active
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUNMSTR_G_SET_DTVAntennaRegisterUpReg;

/**
 * The relUpReg message of the property "FID_TUNMSTR_G_SET_DTVAntennaRegister"
 * This property will set the DTV Antenna Power supply(example ELMOS IC) current register(Open/Over Current register) based on the KDS configuration in "CM_VariantCoding" and AntennaParameterSet"
 * For IVI, the request needs to be send when LVDS link is active
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUNMSTR_G_SET_DTVAntennaRegisterRelUpReg;

/**
 * The error message of 'FID_TUNMSTR_G_SET_DTVAntennaRegister'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUNMSTR_G_SET_DTVAntennaRegisterError;

/**
 * The get message of the property "FID_TUNMSTR_G_TA_STATUS"
 * This property informs about TA button status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUNMSTR_G_TA_STATUSGet;

/**
 * The upreg message of the property "FID_TUNMSTR_G_TA_STATUS"
 * This property informs about TA button status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUNMSTR_G_TA_STATUSUpReg;

/**
 * The relUpReg message of the property "FID_TUNMSTR_G_TA_STATUS"
 * This property informs about TA button status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUNMSTR_G_TA_STATUSRelUpReg;

/**
 * The error message of 'FID_TUNMSTR_G_TA_STATUS'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUNMSTR_G_TA_STATUSError;

/**
 * The get message of the property "FID_TUNMSTR_G_TP_STATUS"
 * With this property fc_tunermaster will inform to HMI about TP status.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUNMSTR_G_TP_STATUSGet;

/**
 * The upreg message of the property "FID_TUNMSTR_G_TP_STATUS"
 * With this property fc_tunermaster will inform to HMI about TP status.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUNMSTR_G_TP_STATUSUpReg;

/**
 * The relUpReg message of the property "FID_TUNMSTR_G_TP_STATUS"
 * With this property fc_tunermaster will inform to HMI about TP status.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUNMSTR_G_TP_STATUSRelUpReg;

/**
 * The error message of 'FID_TUNMSTR_G_TP_STATUS'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUNMSTR_G_TP_STATUSError;

/**
 * The get message of the property "FID_TUNMSTR_G_SOURCE_CHANGE"
 * With this property fc_tunermaster will request HMI for soucre change, this inteface is not used as of now in G3g,
 * as source change request goes to Audio directly from HMI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUNMSTR_G_SOURCE_CHANGEGet;

/**
 * The upreg message of the property "FID_TUNMSTR_G_SOURCE_CHANGE"
 * With this property fc_tunermaster will request HMI for soucre change, this inteface is not used as of now in G3g,
 * as source change request goes to Audio directly from HMI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUNMSTR_G_SOURCE_CHANGEUpReg;

/**
 * The relUpReg message of the property "FID_TUNMSTR_G_SOURCE_CHANGE"
 * With this property fc_tunermaster will request HMI for soucre change, this inteface is not used as of now in G3g,
 * as source change request goes to Audio directly from HMI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUNMSTR_G_SOURCE_CHANGERelUpReg;

/**
 * The error message of 'FID_TUNMSTR_G_SOURCE_CHANGE'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUNMSTR_G_SOURCE_CHANGEError;

/**
 * The get message of the property "FID_TUNMSTR_G_BAND_INFO"
 * With this property fc_tunermaster will inform to HMI about currrent active band
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUNMSTR_G_BAND_INFOGet;

/**
 * The upreg message of the property "FID_TUNMSTR_G_BAND_INFO"
 * With this property fc_tunermaster will inform to HMI about currrent active band
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUNMSTR_G_BAND_INFOUpReg;

/**
 * The relUpReg message of the property "FID_TUNMSTR_G_BAND_INFO"
 * With this property fc_tunermaster will inform to HMI about currrent active band
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUNMSTR_G_BAND_INFORelUpReg;

/**
 * The error message of 'FID_TUNMSTR_G_BAND_INFO'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUNMSTR_G_BAND_INFOError;

/**
 * The upreg message of the property "FID_TUNMSTR_G_RF_ANTENNA_TEST"
 * Status response to MethodStart FID_TUNMSTR_S_RF_ANTENNA_TEST.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUNMSTR_G_RF_ANTENNA_TESTUpReg;

/**
 * The relUpReg message of the property "FID_TUNMSTR_G_RF_ANTENNA_TEST"
 * Status response to MethodStart FID_TUNMSTR_S_RF_ANTENNA_TEST.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUNMSTR_G_RF_ANTENNA_TESTRelUpReg;

/**
 * The error message of 'FID_TUNMSTR_G_RF_ANTENNA_TEST'
 * Possible errors of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUNMSTR_G_RF_ANTENNA_TESTError;

/**
 * The upreg message of the property "FID_TUNMSTR_G_PRESET_LIST"
 * Gives Preset list details .
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUNMSTR_G_PRESET_LISTUpReg;

/**
 * The relUpReg message of the property "FID_TUNMSTR_G_PRESET_LIST"
 * Gives Preset list details .
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUNMSTR_G_PRESET_LISTRelUpReg;

/**
 * The error message of 'FID_TUNMSTR_G_PRESET_LIST'
 * Possible errors of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUNMSTR_G_PRESET_LISTError;

/**
 * The get message of the property "FID_TUNMSTR_G_ANNO_BUTTON_STATUS"
 * This property informs about Announcement button status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUNMSTR_G_ANNO_BUTTON_STATUSGet;

/**
 * The upreg message of the property "FID_TUNMSTR_G_ANNO_BUTTON_STATUS"
 * This property informs about Announcement button status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUNMSTR_G_ANNO_BUTTON_STATUSUpReg;

/**
 * The relUpReg message of the property "FID_TUNMSTR_G_ANNO_BUTTON_STATUS"
 * This property informs about Announcement button status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUNMSTR_G_ANNO_BUTTON_STATUSRelUpReg;

/**
 * The error message of 'FID_TUNMSTR_G_ANNO_BUTTON_STATUS'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUNMSTR_G_ANNO_BUTTON_STATUSError;

/**
 * The get message of the property "FID_TUNMSTR_G_ANNOUNCEMENT_STATUS"
 * This property will udpate HMI about current active announcemnt source. HMI can use this infomation to display Announcement pop up
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUNMSTR_G_ANNOUNCEMENT_STATUSGet;

/**
 * The upreg message of the property "FID_TUNMSTR_G_ANNOUNCEMENT_STATUS"
 * This property will udpate HMI about current active announcemnt source. HMI can use this infomation to display Announcement pop up
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUNMSTR_G_ANNOUNCEMENT_STATUSUpReg;

/**
 * The relUpReg message of the property "FID_TUNMSTR_G_ANNOUNCEMENT_STATUS"
 * This property will udpate HMI about current active announcemnt source. HMI can use this infomation to display Announcement pop up
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUNMSTR_G_ANNOUNCEMENT_STATUSRelUpReg;

/**
 * The error message of 'FID_TUNMSTR_G_ANNOUNCEMENT_STATUS'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUNMSTR_G_ANNOUNCEMENT_STATUSError;

/**
 * The get message of the property "FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITY"
 * With this property fc_tunermaster will inform to HMI about tuner domain availability.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYGet;

/**
 * The upreg message of the property "FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITY"
 * With this property fc_tunermaster will inform to HMI about tuner domain availability.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYUpReg;

/**
 * The relUpReg message of the property "FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITY"
 * With this property fc_tunermaster will inform to HMI about tuner domain availability.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYRelUpReg;

/**
 * The error message of 'FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITY'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYError;

/**
 * The get message of the property "FID_TUNMSTR_G_GET_AUTOSTORE_STATUS"
 * With this property, fc_tunermaster will inform autostore status.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUNMSTR_G_GET_AUTOSTORE_STATUSGet;

/**
 * The upreg message of the property "FID_TUNMSTR_G_GET_AUTOSTORE_STATUS"
 * With this property, fc_tunermaster will inform autostore status.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUNMSTR_G_GET_AUTOSTORE_STATUSUpReg;

/**
 * The relUpReg message of the property "FID_TUNMSTR_G_GET_AUTOSTORE_STATUS"
 * With this property, fc_tunermaster will inform autostore status.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUNMSTR_G_GET_AUTOSTORE_STATUSRelUpReg;

/**
 * The error message of 'FID_TUNMSTR_G_GET_AUTOSTORE_STATUS'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUNMSTR_G_GET_AUTOSTORE_STATUSError;

/**
 * The get message of the property "FID_TUNMSTR_G_MTC_SETMODE_STATUS"
 * This property sets the service linking in the mode set by FID_DAB_S_SERVICE_LINKING_SETMODE.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUNMSTR_G_MTC_SETMODE_STATUSGet;

/**
 * The upreg message of the property "FID_TUNMSTR_G_MTC_SETMODE_STATUS"
 * This property sets the service linking in the mode set by FID_DAB_S_SERVICE_LINKING_SETMODE.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUNMSTR_G_MTC_SETMODE_STATUSUpReg;

/**
 * The relUpReg message of the property "FID_TUNMSTR_G_MTC_SETMODE_STATUS"
 * This property sets the service linking in the mode set by FID_DAB_S_SERVICE_LINKING_SETMODE.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUNMSTR_G_MTC_SETMODE_STATUSRelUpReg;

/**
 * The error message of 'FID_TUNMSTR_G_MTC_SETMODE_STATUS'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUNMSTR_G_MTC_SETMODE_STATUSError;

/**
 * The get message of the property "FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUS"
 * This property gives infomation of survellance active station
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSGet;

/**
 * The upreg message of the property "FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUS"
 * This property gives infomation of survellance active station
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSUpReg;

/**
 * The relUpReg message of the property "FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUS"
 * This property gives infomation of survellance active station
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSRelUpReg;

/**
 * The error message of 'FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUS'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSError;

/**
 * The upreg message of the property "FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITY"
 * This property gives infomation about the Tuner source availability, currently supports only for AM source in A-IVI project
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYUpReg;

/**
 * The relUpReg message of the property "FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITY"
 * This property gives infomation about the Tuner source availability, currently supports only for AM source in A-IVI project
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYRelUpReg;

/**
 * The error message of 'FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITY'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYError;

/**
 * The upreg message of the property "FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATION"
 * This property informs about a change in radio profile settings data for current user
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONUpReg;

/**
 * The relUpReg message of the property "FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATION"
 * This property informs about a change in radio profile settings data for current user
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONRelUpReg;

/**
 * The get message of the property "FID_TUNMSTR_G_PRESET_CHANNEL_UPDATE"
 * Notify change in one of the Preset channels. To be used only by SXM client
 * Request Preset channel change data
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEGet;

/**
 * The upreg message of the property "FID_TUNMSTR_G_PRESET_CHANNEL_UPDATE"
 * Notify change in one of the Preset channels. To be used only by SXM client
 * Registers for Preset channel change updates
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEUpReg;

/**
 * The relUpReg message of the property "FID_TUNMSTR_G_PRESET_CHANNEL_UPDATE"
 * Notify change in one of the Preset channels. To be used only by SXM client
 * De-register from Preset channel change updates
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_TUNMSTR_G_PRESET_CHANNEL_UPDATERelUpReg;

/**
 * The error message of 'FID_TUNMSTR_G_PRESET_CHANNEL_UPDATE'
 * Possible errors of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEError;


/**
 * The start message of the method "FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENT"
 * This message can be used to set status of different Announcement type softkeys like, TA , PTY31 and Other Announcement.
 */
class FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart (const FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart (const ::tunermaster_main_fi_types::T_b32_AnnoType& b32Anno_Types_, const ::tunermaster_main_fi_types::T_b8_SourceAnno& Source_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart();

    /**
     * Assignment operator
     */
    inline FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart& operator = (const FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "b32Anno_Types"

    static const int kB32Anno_Types = 0;

    /**
     * Clears the field "b32Anno_Types".
     *
     * The field will be set to its default value. The hasB32Anno_Types()
     * method will return false.
     */
    inline void clearB32Anno_Types();

    /**
     * Checks whether the field "b32Anno_Types" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setB32Anno_Types()). Otherwise it will return false.
     */
    inline bool hasB32Anno_Types () const;

    /**
     * Returns the value of the member "b32Anno_Types".
     *
     * This parameter will tell for which Anno type we need to monitor.
     *
     * @return The value of the field "b32Anno_Types"
     */
    inline const ::tunermaster_main_fi_types::T_b32_AnnoType& getB32Anno_Types () const;

    /**
     * Retrieves the value of the field "b32Anno_Types" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "b32Anno_Types".
     */
    inline ::tunermaster_main_fi_types::T_b32_AnnoType& getB32Anno_TypesMutable ();

    /**
     * Sets the value of the member "b32Anno_Types".
     *
     * This parameter will tell for which Anno type we need to monitor.
     *
     * @param b32Anno_Types The value which will be set
     */
    inline void setB32Anno_Types (const ::tunermaster_main_fi_types::T_b32_AnnoType& b32Anno_Types_);

    // API of field "Source"

    static const int kSource = 1;

    /**
     * Clears the field "Source".
     *
     * The field will be set to its default value. The hasSource()
     * method will return false.
     */
    inline void clearSource();

    /**
     * Checks whether the field "Source" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSource()). Otherwise it will return false.
     */
    inline bool hasSource () const;

    /**
     * Returns the value of the member "Source".
     *
     * This parameter will indicate for which source, Anno button status is changed
     *
     * @return The value of the field "Source"
     */
    inline const ::tunermaster_main_fi_types::T_b8_SourceAnno& getSource () const;

    /**
     * Retrieves the value of the field "Source" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Source".
     */
    inline ::tunermaster_main_fi_types::T_b8_SourceAnno& getSourceMutable ();

    /**
     * Sets the value of the member "Source".
     *
     * This parameter will indicate for which source, Anno button status is changed
     *
     * @param Source The value which will be set
     */
    inline void setSource (const ::tunermaster_main_fi_types::T_b8_SourceAnno& Source_);

    static const FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart &getDefaultInstance();

private:

    inline void set_has_b32Anno_Types ();

    inline void clear_has_b32Anno_Types ();

    inline void set_has_Source ();

    inline void clear_has_Source ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::tunermaster_main_fi_types::T_b32_AnnoType _b32Anno_Types;

    ::tunermaster_main_fi_types::T_b8_SourceAnno _Source;

};

/**
 * The result message of the method "FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENT"
 * This message can be used to set status of different Announcement type softkeys like, TA , PTY31 and Other Announcement.
 * .
 */
class FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult (const FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult();

    /**
     * Assignment operator
     */
    inline FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult& operator = (const FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerMaster_StatusResponse"

    static const int kTunerMaster_StatusResponse = 0;

    /**
     * Clears the field "TunerMaster_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerMaster_StatusResponse()
     * method will return false.
     */
    inline void clearTunerMaster_StatusResponse();

    /**
     * Checks whether the field "TunerMaster_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerMaster_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerMaster_StatusResponse () const;

    /**
     * Returns the value of the member "TunerMaster_StatusResponse".
     *
     * .
     *
     * @return The value of the field "TunerMaster_StatusResponse"
     */
    inline const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& getTunerMaster_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerMaster_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerMaster_StatusResponse".
     */
    inline ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& getTunerMaster_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerMaster_StatusResponse".
     *
     * .
     *
     * @param TunerMaster_StatusResponse The value which will be set
     */
    inline void setTunerMaster_StatusResponse (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_);

    static const FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult &getDefaultInstance();

private:

    inline void set_has_TunerMaster_StatusResponse ();

    inline void clear_has_TunerMaster_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse _TunerMaster_StatusResponse;

};

/**
 * The start message of the method "FID_TUNMSTR_S_STOP_ANNOUNCEMENT"
 * This method is used to send stop announcement infomation from HMI.
 */
class FID_TUNMSTR_S_STOP_ANNOUNCEMENTStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUNMSTR_S_STOP_ANNOUNCEMENTStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUNMSTR_S_STOP_ANNOUNCEMENTStart (const FID_TUNMSTR_S_STOP_ANNOUNCEMENTStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUNMSTR_S_STOP_ANNOUNCEMENTStart (::tunermaster_main_fi_types::T_StopAnnouncements StopAnnouncements_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUNMSTR_S_STOP_ANNOUNCEMENTStart();

    /**
     * Assignment operator
     */
    inline FID_TUNMSTR_S_STOP_ANNOUNCEMENTStart& operator = (const FID_TUNMSTR_S_STOP_ANNOUNCEMENTStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUNMSTR_S_STOP_ANNOUNCEMENTStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUNMSTR_S_STOP_ANNOUNCEMENTStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUNMSTR_S_STOP_ANNOUNCEMENTStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUNMSTR_S_STOP_ANNOUNCEMENTStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "StopAnnouncements"

    static const int kStopAnnouncements = 0;

    /**
     * Clears the field "StopAnnouncements".
     *
     * The field will be set to its default value. The hasStopAnnouncements()
     * method will return false.
     */
    inline void clearStopAnnouncements();

    /**
     * Checks whether the field "StopAnnouncements" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStopAnnouncements()). Otherwise it will return false.
     */
    inline bool hasStopAnnouncements () const;

    /**
     * Returns the value of the member "StopAnnouncements".
     *
     * Used to break running announcements.
     *
     * @return The value of the field "StopAnnouncements"
     */
    inline ::tunermaster_main_fi_types::T_StopAnnouncements getStopAnnouncements () const;

    /**
     * Sets the value of the member "StopAnnouncements".
     *
     * Used to break running announcements.
     *
     * @param StopAnnouncements The value which will be set
     */
    inline void setStopAnnouncements (::tunermaster_main_fi_types::T_StopAnnouncements StopAnnouncements_);

    static const FID_TUNMSTR_S_STOP_ANNOUNCEMENTStart &getDefaultInstance();

private:

    inline void set_has_StopAnnouncements ();

    inline void clear_has_StopAnnouncements ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tunermaster_main_fi_types::T_StopAnnouncements _StopAnnouncements;

};

/**
 * The result message of the method "FID_TUNMSTR_S_STOP_ANNOUNCEMENT"
 * This method is used to send stop announcement infomation from HMI.
 * .
 */
class FID_TUNMSTR_S_STOP_ANNOUNCEMENTResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUNMSTR_S_STOP_ANNOUNCEMENTResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUNMSTR_S_STOP_ANNOUNCEMENTResult (const FID_TUNMSTR_S_STOP_ANNOUNCEMENTResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUNMSTR_S_STOP_ANNOUNCEMENTResult (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUNMSTR_S_STOP_ANNOUNCEMENTResult();

    /**
     * Assignment operator
     */
    inline FID_TUNMSTR_S_STOP_ANNOUNCEMENTResult& operator = (const FID_TUNMSTR_S_STOP_ANNOUNCEMENTResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUNMSTR_S_STOP_ANNOUNCEMENTResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUNMSTR_S_STOP_ANNOUNCEMENTResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUNMSTR_S_STOP_ANNOUNCEMENTResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUNMSTR_S_STOP_ANNOUNCEMENTResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerMaster_StatusResponse"

    static const int kTunerMaster_StatusResponse = 0;

    /**
     * Clears the field "TunerMaster_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerMaster_StatusResponse()
     * method will return false.
     */
    inline void clearTunerMaster_StatusResponse();

    /**
     * Checks whether the field "TunerMaster_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerMaster_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerMaster_StatusResponse () const;

    /**
     * Returns the value of the member "TunerMaster_StatusResponse".
     *
     * .
     *
     * @return The value of the field "TunerMaster_StatusResponse"
     */
    inline const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& getTunerMaster_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerMaster_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerMaster_StatusResponse".
     */
    inline ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& getTunerMaster_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerMaster_StatusResponse".
     *
     * .
     *
     * @param TunerMaster_StatusResponse The value which will be set
     */
    inline void setTunerMaster_StatusResponse (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_);

    static const FID_TUNMSTR_S_STOP_ANNOUNCEMENTResult &getDefaultInstance();

private:

    inline void set_has_TunerMaster_StatusResponse ();

    inline void clear_has_TunerMaster_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse _TunerMaster_StatusResponse;

};

/**
 * The start message of the method "FID_TUNMSTR_S_BAND_CHANGE"
 * This method is used to send Band Change Infomation from HMI.
 * In G3g since in most of the project band change info goes to Audio directly from HMI, this message is not used extensively.
 * If none of the project require this method, it will be removed in CW 01.
 */
class FID_TUNMSTR_S_BAND_CHANGEStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUNMSTR_S_BAND_CHANGEStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUNMSTR_S_BAND_CHANGEStart (const FID_TUNMSTR_S_BAND_CHANGEStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUNMSTR_S_BAND_CHANGEStart (::tunermaster_main_fi_types::T_e8_Band Band_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUNMSTR_S_BAND_CHANGEStart();

    /**
     * Assignment operator
     */
    inline FID_TUNMSTR_S_BAND_CHANGEStart& operator = (const FID_TUNMSTR_S_BAND_CHANGEStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUNMSTR_S_BAND_CHANGEStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUNMSTR_S_BAND_CHANGEStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUNMSTR_S_BAND_CHANGEStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUNMSTR_S_BAND_CHANGEStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Band"

    static const int kBand = 0;

    /**
     * Clears the field "Band".
     *
     * The field will be set to its default value. The hasBand()
     * method will return false.
     */
    inline void clearBand();

    /**
     * Checks whether the field "Band" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBand()). Otherwise it will return false.
     */
    inline bool hasBand () const;

    /**
     * Returns the value of the member "Band".
     *
     * Indicated Band to be changed.
     *
     * @return The value of the field "Band"
     */
    inline ::tunermaster_main_fi_types::T_e8_Band getBand () const;

    /**
     * Sets the value of the member "Band".
     *
     * Indicated Band to be changed.
     *
     * @param Band The value which will be set
     */
    inline void setBand (::tunermaster_main_fi_types::T_e8_Band Band_);

    static const FID_TUNMSTR_S_BAND_CHANGEStart &getDefaultInstance();

private:

    inline void set_has_Band ();

    inline void clear_has_Band ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tunermaster_main_fi_types::T_e8_Band _Band;

};

/**
 * The result message of the method "FID_TUNMSTR_S_BAND_CHANGE"
 * This method is used to send Band Change Infomation from HMI.
 * In G3g since in most of the project band change info goes to Audio directly from HMI, this message is not used extensively.
 * If none of the project require this method, it will be removed in CW 01.
 * .
 */
class FID_TUNMSTR_S_BAND_CHANGEResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUNMSTR_S_BAND_CHANGEResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUNMSTR_S_BAND_CHANGEResult (const FID_TUNMSTR_S_BAND_CHANGEResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUNMSTR_S_BAND_CHANGEResult (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUNMSTR_S_BAND_CHANGEResult();

    /**
     * Assignment operator
     */
    inline FID_TUNMSTR_S_BAND_CHANGEResult& operator = (const FID_TUNMSTR_S_BAND_CHANGEResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUNMSTR_S_BAND_CHANGEResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUNMSTR_S_BAND_CHANGEResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUNMSTR_S_BAND_CHANGEResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUNMSTR_S_BAND_CHANGEResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerMaster_StatusResponse"

    static const int kTunerMaster_StatusResponse = 0;

    /**
     * Clears the field "TunerMaster_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerMaster_StatusResponse()
     * method will return false.
     */
    inline void clearTunerMaster_StatusResponse();

    /**
     * Checks whether the field "TunerMaster_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerMaster_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerMaster_StatusResponse () const;

    /**
     * Returns the value of the member "TunerMaster_StatusResponse".
     *
     * .
     *
     * @return The value of the field "TunerMaster_StatusResponse"
     */
    inline const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& getTunerMaster_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerMaster_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerMaster_StatusResponse".
     */
    inline ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& getTunerMaster_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerMaster_StatusResponse".
     *
     * .
     *
     * @param TunerMaster_StatusResponse The value which will be set
     */
    inline void setTunerMaster_StatusResponse (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_);

    static const FID_TUNMSTR_S_BAND_CHANGEResult &getDefaultInstance();

private:

    inline void set_has_TunerMaster_StatusResponse ();

    inline void clear_has_TunerMaster_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse _TunerMaster_StatusResponse;

};

/**
 * The start message of the method "FID_TUNMSTR_S_RF_ANTENNA_TEST"
 * Through this method, tuner tells HMI if he detected
 * an error in any of the supervised supplies
 */
class FID_TUNMSTR_S_RF_ANTENNA_TESTStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUNMSTR_S_RF_ANTENNA_TESTStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUNMSTR_S_RF_ANTENNA_TESTStart (const FID_TUNMSTR_S_RF_ANTENNA_TESTStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUNMSTR_S_RF_ANTENNA_TESTStart (::tunermaster_main_fi_types::T_e8_AntennaTest Antenna_Test_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUNMSTR_S_RF_ANTENNA_TESTStart();

    /**
     * Assignment operator
     */
    inline FID_TUNMSTR_S_RF_ANTENNA_TESTStart& operator = (const FID_TUNMSTR_S_RF_ANTENNA_TESTStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUNMSTR_S_RF_ANTENNA_TESTStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUNMSTR_S_RF_ANTENNA_TESTStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUNMSTR_S_RF_ANTENNA_TESTStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUNMSTR_S_RF_ANTENNA_TESTStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Antenna_Test"

    static const int kAntenna_Test = 0;

    /**
     * Clears the field "Antenna_Test".
     *
     * The field will be set to its default value. The hasAntenna_Test()
     * method will return false.
     */
    inline void clearAntenna_Test();

    /**
     * Checks whether the field "Antenna_Test" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAntenna_Test()). Otherwise it will return false.
     */
    inline bool hasAntenna_Test () const;

    /**
     * Returns the value of the member "Antenna_Test".
     *
     * This method start is used to check the RF Antenna
     *
     * @return The value of the field "Antenna_Test"
     */
    inline ::tunermaster_main_fi_types::T_e8_AntennaTest getAntenna_Test () const;

    /**
     * Sets the value of the member "Antenna_Test".
     *
     * This method start is used to check the RF Antenna
     *
     * @param Antenna_Test The value which will be set
     */
    inline void setAntenna_Test (::tunermaster_main_fi_types::T_e8_AntennaTest Antenna_Test_);

    static const FID_TUNMSTR_S_RF_ANTENNA_TESTStart &getDefaultInstance();

private:

    inline void set_has_Antenna_Test ();

    inline void clear_has_Antenna_Test ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tunermaster_main_fi_types::T_e8_AntennaTest _Antenna_Test;

};

/**
 * The result message of the method "FID_TUNMSTR_S_RF_ANTENNA_TEST"
 * Through this method, tuner tells HMI if he detected
 * an error in any of the supervised supplies
 * This indicates whether method start was accepted or rejected.
 */
class FID_TUNMSTR_S_RF_ANTENNA_TESTResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUNMSTR_S_RF_ANTENNA_TESTResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUNMSTR_S_RF_ANTENNA_TESTResult (const FID_TUNMSTR_S_RF_ANTENNA_TESTResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUNMSTR_S_RF_ANTENNA_TESTResult (const ::tunermaster_main_fi_types::Tunmstr_RFAntenna& Tunmstr_RF_Antenna_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUNMSTR_S_RF_ANTENNA_TESTResult();

    /**
     * Assignment operator
     */
    inline FID_TUNMSTR_S_RF_ANTENNA_TESTResult& operator = (const FID_TUNMSTR_S_RF_ANTENNA_TESTResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUNMSTR_S_RF_ANTENNA_TESTResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUNMSTR_S_RF_ANTENNA_TESTResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUNMSTR_S_RF_ANTENNA_TESTResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUNMSTR_S_RF_ANTENNA_TESTResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Tunmstr_RF_Antenna"

    static const int kTunmstr_RF_Antenna = 0;

    /**
     * Clears the field "Tunmstr_RF_Antenna".
     *
     * The field will be set to its default value. The hasTunmstr_RF_Antenna()
     * method will return false.
     */
    inline void clearTunmstr_RF_Antenna();

    /**
     * Checks whether the field "Tunmstr_RF_Antenna" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunmstr_RF_Antenna()). Otherwise it will return false.
     */
    inline bool hasTunmstr_RF_Antenna () const;

    /**
     * Returns the value of the member "Tunmstr_RF_Antenna".
     *
     * Status response will contain the RF Antenna test result.
     *
     * @return The value of the field "Tunmstr_RF_Antenna"
     */
    inline const ::tunermaster_main_fi_types::Tunmstr_RFAntenna& getTunmstr_RF_Antenna () const;

    /**
     * Retrieves the value of the field "Tunmstr_RF_Antenna" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Tunmstr_RF_Antenna".
     */
    inline ::tunermaster_main_fi_types::Tunmstr_RFAntenna& getTunmstr_RF_AntennaMutable ();

    /**
     * Sets the value of the member "Tunmstr_RF_Antenna".
     *
     * Status response will contain the RF Antenna test result.
     *
     * @param Tunmstr_RF_Antenna The value which will be set
     */
    inline void setTunmstr_RF_Antenna (const ::tunermaster_main_fi_types::Tunmstr_RFAntenna& Tunmstr_RF_Antenna_);

    static const FID_TUNMSTR_S_RF_ANTENNA_TESTResult &getDefaultInstance();

private:

    inline void set_has_Tunmstr_RF_Antenna ();

    inline void clear_has_Tunmstr_RF_Antenna ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tunermaster_main_fi_types::Tunmstr_RFAntenna _Tunmstr_RF_Antenna;

};

/**
 * The start message of the method "FID_TUNMSTR_S_TEST_MODE"
 * This method indicates if Tuner Test mode is enable or not.
 */
class FID_TUNMSTR_S_TEST_MODEStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUNMSTR_S_TEST_MODEStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUNMSTR_S_TEST_MODEStart (const FID_TUNMSTR_S_TEST_MODEStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUNMSTR_S_TEST_MODEStart (bool TestModeActive_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUNMSTR_S_TEST_MODEStart();

    /**
     * Assignment operator
     */
    inline FID_TUNMSTR_S_TEST_MODEStart& operator = (const FID_TUNMSTR_S_TEST_MODEStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUNMSTR_S_TEST_MODEStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUNMSTR_S_TEST_MODEStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUNMSTR_S_TEST_MODEStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUNMSTR_S_TEST_MODEStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TestModeActive"

    static const int kTestModeActive = 0;

    /**
     * Clears the field "TestModeActive".
     *
     * The field will be set to its default value. The hasTestModeActive()
     * method will return false.
     */
    inline void clearTestModeActive();

    /**
     * Checks whether the field "TestModeActive" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTestModeActive()). Otherwise it will return false.
     */
    inline bool hasTestModeActive () const;

    /**
     * Returns the value of the member "TestModeActive".
     *
     * Indicates if the Test mode is enable or not
     * 01: Test Mode is enable.
     * 00: Test Mode is Disable.
     *
     * @return The value of the field "TestModeActive"
     */
    inline bool getTestModeActive () const;

    /**
     * Sets the value of the member "TestModeActive".
     *
     * Indicates if the Test mode is enable or not
     * 01: Test Mode is enable.
     * 00: Test Mode is Disable.
     *
     * @param TestModeActive The value which will be set
     */
    inline void setTestModeActive (bool TestModeActive_);

    static const FID_TUNMSTR_S_TEST_MODEStart &getDefaultInstance();

private:

    inline void set_has_TestModeActive ();

    inline void clear_has_TestModeActive ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _TestModeActive;

};

/**
 * The result message of the method "FID_TUNMSTR_S_TEST_MODE"
 * This method indicates if Tuner Test mode is enable or not.
 * .
 */
class FID_TUNMSTR_S_TEST_MODEResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUNMSTR_S_TEST_MODEResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUNMSTR_S_TEST_MODEResult (const FID_TUNMSTR_S_TEST_MODEResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUNMSTR_S_TEST_MODEResult (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUNMSTR_S_TEST_MODEResult();

    /**
     * Assignment operator
     */
    inline FID_TUNMSTR_S_TEST_MODEResult& operator = (const FID_TUNMSTR_S_TEST_MODEResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUNMSTR_S_TEST_MODEResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUNMSTR_S_TEST_MODEResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUNMSTR_S_TEST_MODEResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUNMSTR_S_TEST_MODEResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerMaster_StatusResponse"

    static const int kTunerMaster_StatusResponse = 0;

    /**
     * Clears the field "TunerMaster_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerMaster_StatusResponse()
     * method will return false.
     */
    inline void clearTunerMaster_StatusResponse();

    /**
     * Checks whether the field "TunerMaster_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerMaster_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerMaster_StatusResponse () const;

    /**
     * Returns the value of the member "TunerMaster_StatusResponse".
     *
     * .
     *
     * @return The value of the field "TunerMaster_StatusResponse"
     */
    inline const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& getTunerMaster_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerMaster_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerMaster_StatusResponse".
     */
    inline ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& getTunerMaster_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerMaster_StatusResponse".
     *
     * .
     *
     * @param TunerMaster_StatusResponse The value which will be set
     */
    inline void setTunerMaster_StatusResponse (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_);

    static const FID_TUNMSTR_S_TEST_MODEResult &getDefaultInstance();

private:

    inline void set_has_TunerMaster_StatusResponse ();

    inline void clear_has_TunerMaster_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse _TunerMaster_StatusResponse;

};

/**
 * The start message of the method "FID_TUNMSTR_S_SRCCHG_TESTMODE"
 * This method is used to trigger soucre change b/w different tuners in test mode
 */
class FID_TUNMSTR_S_SRCCHG_TESTMODEStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUNMSTR_S_SRCCHG_TESTMODEStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUNMSTR_S_SRCCHG_TESTMODEStart (const FID_TUNMSTR_S_SRCCHG_TESTMODEStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUNMSTR_S_SRCCHG_TESTMODEStart (::tunermaster_main_fi_types::T_e8_WhichTuner WhichTuner_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUNMSTR_S_SRCCHG_TESTMODEStart();

    /**
     * Assignment operator
     */
    inline FID_TUNMSTR_S_SRCCHG_TESTMODEStart& operator = (const FID_TUNMSTR_S_SRCCHG_TESTMODEStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUNMSTR_S_SRCCHG_TESTMODEStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUNMSTR_S_SRCCHG_TESTMODEStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUNMSTR_S_SRCCHG_TESTMODEStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUNMSTR_S_SRCCHG_TESTMODEStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "WhichTuner"

    static const int kWhichTuner = 0;

    /**
     * Clears the field "WhichTuner".
     *
     * The field will be set to its default value. The hasWhichTuner()
     * method will return false.
     */
    inline void clearWhichTuner();

    /**
     * Checks whether the field "WhichTuner" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWhichTuner()). Otherwise it will return false.
     */
    inline bool hasWhichTuner () const;

    /**
     * Returns the value of the member "WhichTuner".
     *
     * Indicates which tuner to be made active in test mode
     *
     * @return The value of the field "WhichTuner"
     */
    inline ::tunermaster_main_fi_types::T_e8_WhichTuner getWhichTuner () const;

    /**
     * Sets the value of the member "WhichTuner".
     *
     * Indicates which tuner to be made active in test mode
     *
     * @param WhichTuner The value which will be set
     */
    inline void setWhichTuner (::tunermaster_main_fi_types::T_e8_WhichTuner WhichTuner_);

    static const FID_TUNMSTR_S_SRCCHG_TESTMODEStart &getDefaultInstance();

private:

    inline void set_has_WhichTuner ();

    inline void clear_has_WhichTuner ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tunermaster_main_fi_types::T_e8_WhichTuner _WhichTuner;

};

/**
 * The result message of the method "FID_TUNMSTR_S_SRCCHG_TESTMODE"
 * This method is used to trigger soucre change b/w different tuners in test mode
 * .
 */
class FID_TUNMSTR_S_SRCCHG_TESTMODEResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUNMSTR_S_SRCCHG_TESTMODEResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUNMSTR_S_SRCCHG_TESTMODEResult (const FID_TUNMSTR_S_SRCCHG_TESTMODEResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUNMSTR_S_SRCCHG_TESTMODEResult (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUNMSTR_S_SRCCHG_TESTMODEResult();

    /**
     * Assignment operator
     */
    inline FID_TUNMSTR_S_SRCCHG_TESTMODEResult& operator = (const FID_TUNMSTR_S_SRCCHG_TESTMODEResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUNMSTR_S_SRCCHG_TESTMODEResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUNMSTR_S_SRCCHG_TESTMODEResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUNMSTR_S_SRCCHG_TESTMODEResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUNMSTR_S_SRCCHG_TESTMODEResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerMaster_StatusResponse"

    static const int kTunerMaster_StatusResponse = 0;

    /**
     * Clears the field "TunerMaster_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerMaster_StatusResponse()
     * method will return false.
     */
    inline void clearTunerMaster_StatusResponse();

    /**
     * Checks whether the field "TunerMaster_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerMaster_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerMaster_StatusResponse () const;

    /**
     * Returns the value of the member "TunerMaster_StatusResponse".
     *
     * .
     *
     * @return The value of the field "TunerMaster_StatusResponse"
     */
    inline const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& getTunerMaster_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerMaster_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerMaster_StatusResponse".
     */
    inline ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& getTunerMaster_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerMaster_StatusResponse".
     *
     * .
     *
     * @param TunerMaster_StatusResponse The value which will be set
     */
    inline void setTunerMaster_StatusResponse (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_);

    static const FID_TUNMSTR_S_SRCCHG_TESTMODEResult &getDefaultInstance();

private:

    inline void set_has_TunerMaster_StatusResponse ();

    inline void clear_has_TunerMaster_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse _TunerMaster_StatusResponse;

};

/**
 * The result message of the method "FID_TUNMSTR_S_GET_ACTIVETUNER_INFO"
 * This method will give infomation about current active tuner in test mode.
 * .
 */
class FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult (const FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult (::tunermaster_main_fi_types::T_e8_WhichTuner WhichTuner_, const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult();

    /**
     * Assignment operator
     */
    inline FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult& operator = (const FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "WhichTuner"

    static const int kWhichTuner = 0;

    /**
     * Clears the field "WhichTuner".
     *
     * The field will be set to its default value. The hasWhichTuner()
     * method will return false.
     */
    inline void clearWhichTuner();

    /**
     * Checks whether the field "WhichTuner" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWhichTuner()). Otherwise it will return false.
     */
    inline bool hasWhichTuner () const;

    /**
     * Returns the value of the member "WhichTuner".
     *
     * Indicates which tuner is active
     *
     * @return The value of the field "WhichTuner"
     */
    inline ::tunermaster_main_fi_types::T_e8_WhichTuner getWhichTuner () const;

    /**
     * Sets the value of the member "WhichTuner".
     *
     * Indicates which tuner is active
     *
     * @param WhichTuner The value which will be set
     */
    inline void setWhichTuner (::tunermaster_main_fi_types::T_e8_WhichTuner WhichTuner_);

    // API of field "TunerMaster_StatusResponse"

    static const int kTunerMaster_StatusResponse = 1;

    /**
     * Clears the field "TunerMaster_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerMaster_StatusResponse()
     * method will return false.
     */
    inline void clearTunerMaster_StatusResponse();

    /**
     * Checks whether the field "TunerMaster_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerMaster_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerMaster_StatusResponse () const;

    /**
     * Returns the value of the member "TunerMaster_StatusResponse".
     *
     * .
     *
     * @return The value of the field "TunerMaster_StatusResponse"
     */
    inline const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& getTunerMaster_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerMaster_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerMaster_StatusResponse".
     */
    inline ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& getTunerMaster_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerMaster_StatusResponse".
     *
     * .
     *
     * @param TunerMaster_StatusResponse The value which will be set
     */
    inline void setTunerMaster_StatusResponse (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_);

    static const FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult &getDefaultInstance();

private:

    inline void set_has_WhichTuner ();

    inline void clear_has_WhichTuner ();

    inline void set_has_TunerMaster_StatusResponse ();

    inline void clear_has_TunerMaster_StatusResponse ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::tunermaster_main_fi_types::T_e8_WhichTuner _WhichTuner;

    ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse _TunerMaster_StatusResponse;

};

/**
 * The start message of the method "FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUT"
 * This method will set frequency value only in case of SDS session. for other use cases please use fc_tmctuner message
 */
class FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart (const FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart (::tunermaster_main_fi_types::T_e8_Band Band_, uint32 Frequency_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart();

    /**
     * Assignment operator
     */
    inline FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart& operator = (const FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Band"

    static const int kBand = 0;

    /**
     * Clears the field "Band".
     *
     * The field will be set to its default value. The hasBand()
     * method will return false.
     */
    inline void clearBand();

    /**
     * Checks whether the field "Band" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBand()). Otherwise it will return false.
     */
    inline bool hasBand () const;

    /**
     * Returns the value of the member "Band".
     *
     * Which Band Frequency belongs to
     *
     * @return The value of the field "Band"
     */
    inline ::tunermaster_main_fi_types::T_e8_Band getBand () const;

    /**
     * Sets the value of the member "Band".
     *
     * Which Band Frequency belongs to
     *
     * @param Band The value which will be set
     */
    inline void setBand (::tunermaster_main_fi_types::T_e8_Band Band_);

    // API of field "Frequency"

    static const int kFrequency = 1;

    /**
     * Clears the field "Frequency".
     *
     * The field will be set to its default value. The hasFrequency()
     * method will return false.
     */
    inline void clearFrequency();

    /**
     * Checks whether the field "Frequency" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFrequency()). Otherwise it will return false.
     */
    inline bool hasFrequency () const;

    /**
     * Returns the value of the member "Frequency".
     *
     * Frequency Value
     *
     * @return The value of the field "Frequency"
     */
    inline uint32 getFrequency () const;

    /**
     * Sets the value of the member "Frequency".
     *
     * Frequency Value
     *
     * @param Frequency The value which will be set
     */
    inline void setFrequency (uint32 Frequency_);

    static const FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart &getDefaultInstance();

private:

    inline void set_has_Band ();

    inline void clear_has_Band ();

    inline void set_has_Frequency ();

    inline void clear_has_Frequency ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::tunermaster_main_fi_types::T_e8_Band _Band;

    uint32 _Frequency;

};

/**
 * The result message of the method "FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUT"
 * This method will set frequency value only in case of SDS session. for other use cases please use fc_tmctuner message
 * .
 */
class FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTResult (const FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTResult (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTResult();

    /**
     * Assignment operator
     */
    inline FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTResult& operator = (const FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerMaster_StatusResponse"

    static const int kTunerMaster_StatusResponse = 0;

    /**
     * Clears the field "TunerMaster_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerMaster_StatusResponse()
     * method will return false.
     */
    inline void clearTunerMaster_StatusResponse();

    /**
     * Checks whether the field "TunerMaster_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerMaster_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerMaster_StatusResponse () const;

    /**
     * Returns the value of the member "TunerMaster_StatusResponse".
     *
     * .
     *
     * @return The value of the field "TunerMaster_StatusResponse"
     */
    inline const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& getTunerMaster_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerMaster_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerMaster_StatusResponse".
     */
    inline ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& getTunerMaster_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerMaster_StatusResponse".
     *
     * .
     *
     * @param TunerMaster_StatusResponse The value which will be set
     */
    inline void setTunerMaster_StatusResponse (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_);

    static const FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTResult &getDefaultInstance();

private:

    inline void set_has_TunerMaster_StatusResponse ();

    inline void clear_has_TunerMaster_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse _TunerMaster_StatusResponse;

};

/**
 * The start message of the method "FID_TUNMSTR_S_PRESET_HANDLING"
 * This message is used to handle multiple functionalities of preset list like Preset Recall, save, Delete one element and delete all elelemet from the list.
 * Which functionality to be performed will be decided based on Value specified in Preset_Action parameter.
 */
class FID_TUNMSTR_S_PRESET_HANDLINGStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUNMSTR_S_PRESET_HANDLINGStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUNMSTR_S_PRESET_HANDLINGStart (const FID_TUNMSTR_S_PRESET_HANDLINGStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUNMSTR_S_PRESET_HANDLINGStart (::tunermaster_main_fi_types::T_e8_Preset_Action Preset_Action_, uint8 u8Element_ID_, ::tunermaster_main_fi_types::T_e8_List List_, ::tunermaster_main_fi_types::T_e8_Band Band_, uint32 Frequency_, uint32 PI_, uint16 SecondaryPI_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUNMSTR_S_PRESET_HANDLINGStart();

    /**
     * Assignment operator
     */
    inline FID_TUNMSTR_S_PRESET_HANDLINGStart& operator = (const FID_TUNMSTR_S_PRESET_HANDLINGStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUNMSTR_S_PRESET_HANDLINGStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUNMSTR_S_PRESET_HANDLINGStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUNMSTR_S_PRESET_HANDLINGStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUNMSTR_S_PRESET_HANDLINGStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Preset_Action"

    static const int kPreset_Action = 0;

    /**
     * Clears the field "Preset_Action".
     *
     * The field will be set to its default value. The hasPreset_Action()
     * method will return false.
     */
    inline void clearPreset_Action();

    /**
     * Checks whether the field "Preset_Action" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPreset_Action()). Otherwise it will return false.
     */
    inline bool hasPreset_Action () const;

    /**
     * Returns the value of the member "Preset_Action".
     *
     * This parameter indicates what actions needs to be performed on preset list
     *
     * @return The value of the field "Preset_Action"
     */
    inline ::tunermaster_main_fi_types::T_e8_Preset_Action getPreset_Action () const;

    /**
     * Sets the value of the member "Preset_Action".
     *
     * This parameter indicates what actions needs to be performed on preset list
     *
     * @param Preset_Action The value which will be set
     */
    inline void setPreset_Action (::tunermaster_main_fi_types::T_e8_Preset_Action Preset_Action_);

    // API of field "u8Element_ID"

    static const int kU8Element_ID = 1;

    /**
     * Clears the field "u8Element_ID".
     *
     * The field will be set to its default value. The hasU8Element_ID()
     * method will return false.
     */
    inline void clearU8Element_ID();

    /**
     * Checks whether the field "u8Element_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Element_ID()). Otherwise it will return false.
     */
    inline bool hasU8Element_ID () const;

    /**
     * Returns the value of the member "u8Element_ID".
     *
     * This parameter indicates to which element, requested action has to be performed
     *
     * @return The value of the field "u8Element_ID"
     */
    inline uint8 getU8Element_ID () const;

    /**
     * Sets the value of the member "u8Element_ID".
     *
     * This parameter indicates to which element, requested action has to be performed
     *
     * @param u8Element_ID The value which will be set
     */
    inline void setU8Element_ID (uint8 u8Element_ID_);

    // API of field "List"

    static const int kList = 2;

    /**
     * Clears the field "List".
     *
     * The field will be set to its default value. The hasList()
     * method will return false.
     */
    inline void clearList();

    /**
     * Checks whether the field "List" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setList()). Otherwise it will return false.
     */
    inline bool hasList () const;

    /**
     * Returns the value of the member "List".
     *
     * This parameter indicates to which list,requested action has to be performed
     *
     * @return The value of the field "List"
     */
    inline ::tunermaster_main_fi_types::T_e8_List getList () const;

    /**
     * Sets the value of the member "List".
     *
     * This parameter indicates to which list,requested action has to be performed
     *
     * @param List The value which will be set
     */
    inline void setList (::tunermaster_main_fi_types::T_e8_List List_);

    // API of field "Band"

    static const int kBand = 3;

    /**
     * Clears the field "Band".
     *
     * The field will be set to its default value. The hasBand()
     * method will return false.
     */
    inline void clearBand();

    /**
     * Checks whether the field "Band" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBand()). Otherwise it will return false.
     */
    inline bool hasBand () const;

    /**
     * Returns the value of the member "Band".
     *
     * This parameter indicates to which Band,requested action has to be performed
     *
     * @return The value of the field "Band"
     */
    inline ::tunermaster_main_fi_types::T_e8_Band getBand () const;

    /**
     * Sets the value of the member "Band".
     *
     * This parameter indicates to which Band,requested action has to be performed
     *
     * @param Band The value which will be set
     */
    inline void setBand (::tunermaster_main_fi_types::T_e8_Band Band_);

    // API of field "Frequency"

    static const int kFrequency = 4;

    /**
     * Clears the field "Frequency".
     *
     * The field will be set to its default value. The hasFrequency()
     * method will return false.
     */
    inline void clearFrequency();

    /**
     * Checks whether the field "Frequency" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFrequency()). Otherwise it will return false.
     */
    inline bool hasFrequency () const;

    /**
     * Returns the value of the member "Frequency".
     *
     * This parameter indicates the frequency to be stored, used only in case of special preset save action.
     *
     * @return The value of the field "Frequency"
     */
    inline uint32 getFrequency () const;

    /**
     * Sets the value of the member "Frequency".
     *
     * This parameter indicates the frequency to be stored, used only in case of special preset save action.
     *
     * @param Frequency The value which will be set
     */
    inline void setFrequency (uint32 Frequency_);

    // API of field "PI"

    static const int kPI = 5;

    /**
     * Clears the field "PI".
     *
     * The field will be set to its default value. The hasPI()
     * method will return false.
     */
    inline void clearPI();

    /**
     * Checks whether the field "PI" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPI()). Otherwise it will return false.
     */
    inline bool hasPI () const;

    /**
     * Returns the value of the member "PI".
     *
     * This parameter indicates the PI of the respective selected station, used only in case of special preset save action.
     *
     * @return The value of the field "PI"
     */
    inline uint32 getPI () const;

    /**
     * Sets the value of the member "PI".
     *
     * This parameter indicates the PI of the respective selected station, used only in case of special preset save action.
     *
     * @param PI The value which will be set
     */
    inline void setPI (uint32 PI_);

    // API of field "SecondaryPI"

    static const int kSecondaryPI = 6;

    /**
     * Clears the field "SecondaryPI".
     *
     * The field will be set to its default value. The hasSecondaryPI()
     * method will return false.
     */
    inline void clearSecondaryPI();

    /**
     * Checks whether the field "SecondaryPI" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSecondaryPI()). Otherwise it will return false.
     */
    inline bool hasSecondaryPI () const;

    /**
     * Returns the value of the member "SecondaryPI".
     *
     * LSB is for SecondaryID, MSB can be used for ECC for DAB.
     *
     * @return The value of the field "SecondaryPI"
     */
    inline uint16 getSecondaryPI () const;

    /**
     * Sets the value of the member "SecondaryPI".
     *
     * LSB is for SecondaryID, MSB can be used for ECC for DAB.
     *
     * @param SecondaryPI The value which will be set
     */
    inline void setSecondaryPI (uint16 SecondaryPI_);

    static const FID_TUNMSTR_S_PRESET_HANDLINGStart &getDefaultInstance();

private:

    inline void set_has_Preset_Action ();

    inline void clear_has_Preset_Action ();

    inline void set_has_u8Element_ID ();

    inline void clear_has_u8Element_ID ();

    inline void set_has_List ();

    inline void clear_has_List ();

    inline void set_has_Band ();

    inline void clear_has_Band ();

    inline void set_has_Frequency ();

    inline void clear_has_Frequency ();

    inline void set_has_PI ();

    inline void clear_has_PI ();

    inline void set_has_SecondaryPI ();

    inline void clear_has_SecondaryPI ();

    uint32 _has_bits_[ (7 + 31) / 32];

    ::tunermaster_main_fi_types::T_e8_Preset_Action _Preset_Action;

    uint8 _u8Element_ID;

    ::tunermaster_main_fi_types::T_e8_List _List;

    ::tunermaster_main_fi_types::T_e8_Band _Band;

    uint32 _Frequency;

    uint32 _PI;

    uint16 _SecondaryPI;

};

/**
 * The result message of the method "FID_TUNMSTR_S_PRESET_HANDLING"
 * This message is used to handle multiple functionalities of preset list like Preset Recall, save, Delete one element and delete all elelemet from the list.
 * Which functionality to be performed will be decided based on Value specified in Preset_Action parameter.
 * .
 */
class FID_TUNMSTR_S_PRESET_HANDLINGResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUNMSTR_S_PRESET_HANDLINGResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUNMSTR_S_PRESET_HANDLINGResult (const FID_TUNMSTR_S_PRESET_HANDLINGResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUNMSTR_S_PRESET_HANDLINGResult (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_, ::tunermaster_main_fi_types::T_e8_Source Source_, ::tunermaster_main_fi_types::T_e8_Action Action_, ::tunermaster_main_fi_types::T_e8_Preset_Action Preset_Action_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUNMSTR_S_PRESET_HANDLINGResult();

    /**
     * Assignment operator
     */
    inline FID_TUNMSTR_S_PRESET_HANDLINGResult& operator = (const FID_TUNMSTR_S_PRESET_HANDLINGResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUNMSTR_S_PRESET_HANDLINGResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUNMSTR_S_PRESET_HANDLINGResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUNMSTR_S_PRESET_HANDLINGResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUNMSTR_S_PRESET_HANDLINGResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerMaster_StatusResponse"

    static const int kTunerMaster_StatusResponse = 0;

    /**
     * Clears the field "TunerMaster_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerMaster_StatusResponse()
     * method will return false.
     */
    inline void clearTunerMaster_StatusResponse();

    /**
     * Checks whether the field "TunerMaster_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerMaster_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerMaster_StatusResponse () const;

    /**
     * Returns the value of the member "TunerMaster_StatusResponse".
     *
     * .
     *
     * @return The value of the field "TunerMaster_StatusResponse"
     */
    inline const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& getTunerMaster_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerMaster_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerMaster_StatusResponse".
     */
    inline ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& getTunerMaster_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerMaster_StatusResponse".
     *
     * .
     *
     * @param TunerMaster_StatusResponse The value which will be set
     */
    inline void setTunerMaster_StatusResponse (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_);

    // API of field "Source"

    static const int kSource = 1;

    /**
     * Clears the field "Source".
     *
     * The field will be set to its default value. The hasSource()
     * method will return false.
     */
    inline void clearSource();

    /**
     * Checks whether the field "Source" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSource()). Otherwise it will return false.
     */
    inline bool hasSource () const;

    /**
     * Returns the value of the member "Source".
     *
     * This parameter is used to indicate if Source/Band change is required to complete Preset handling functionality
     *
     * @return The value of the field "Source"
     */
    inline ::tunermaster_main_fi_types::T_e8_Source getSource () const;

    /**
     * Sets the value of the member "Source".
     *
     * This parameter is used to indicate if Source/Band change is required to complete Preset handling functionality
     *
     * @param Source The value which will be set
     */
    inline void setSource (::tunermaster_main_fi_types::T_e8_Source Source_);

    // API of field "Action"

    static const int kAction = 2;

    /**
     * Clears the field "Action".
     *
     * The field will be set to its default value. The hasAction()
     * method will return false.
     */
    inline void clearAction();

    /**
     * Checks whether the field "Action" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAction()). Otherwise it will return false.
     */
    inline bool hasAction () const;

    /**
     * Returns the value of the member "Action".
     *
     * This parameter is used to indicate if Source/Band change is required to complete Preset handling functionality
     *
     * @return The value of the field "Action"
     */
    inline ::tunermaster_main_fi_types::T_e8_Action getAction () const;

    /**
     * Sets the value of the member "Action".
     *
     * This parameter is used to indicate if Source/Band change is required to complete Preset handling functionality
     *
     * @param Action The value which will be set
     */
    inline void setAction (::tunermaster_main_fi_types::T_e8_Action Action_);

    // API of field "Preset_Action"

    static const int kPreset_Action = 3;

    /**
     * Clears the field "Preset_Action".
     *
     * The field will be set to its default value. The hasPreset_Action()
     * method will return false.
     */
    inline void clearPreset_Action();

    /**
     * Checks whether the field "Preset_Action" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPreset_Action()). Otherwise it will return false.
     */
    inline bool hasPreset_Action () const;

    /**
     * Returns the value of the member "Preset_Action".
     *
     * This parameter indicates which preset action is performed.
     *
     * @return The value of the field "Preset_Action"
     */
    inline ::tunermaster_main_fi_types::T_e8_Preset_Action getPreset_Action () const;

    /**
     * Sets the value of the member "Preset_Action".
     *
     * This parameter indicates which preset action is performed.
     *
     * @param Preset_Action The value which will be set
     */
    inline void setPreset_Action (::tunermaster_main_fi_types::T_e8_Preset_Action Preset_Action_);

    static const FID_TUNMSTR_S_PRESET_HANDLINGResult &getDefaultInstance();

private:

    inline void set_has_TunerMaster_StatusResponse ();

    inline void clear_has_TunerMaster_StatusResponse ();

    inline void set_has_Source ();

    inline void clear_has_Source ();

    inline void set_has_Action ();

    inline void clear_has_Action ();

    inline void set_has_Preset_Action ();

    inline void clear_has_Preset_Action ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse _TunerMaster_StatusResponse;

    ::tunermaster_main_fi_types::T_e8_Source _Source;

    ::tunermaster_main_fi_types::T_e8_Action _Action;

    ::tunermaster_main_fi_types::T_e8_Preset_Action _Preset_Action;

};

/**
 * The start message of the method "FID_TUNMSTR_S_AUTOSTORE"
 * This command is used to initiate Auto store
 */
class FID_TUNMSTR_S_AUTOSTOREStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUNMSTR_S_AUTOSTOREStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUNMSTR_S_AUTOSTOREStart (const FID_TUNMSTR_S_AUTOSTOREStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUNMSTR_S_AUTOSTOREStart (bool AutoStore_Start_, ::tunermaster_main_fi_types::T_e8_List List_, ::tunermaster_main_fi_types::T_e8_AST_Types AST_Type_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUNMSTR_S_AUTOSTOREStart();

    /**
     * Assignment operator
     */
    inline FID_TUNMSTR_S_AUTOSTOREStart& operator = (const FID_TUNMSTR_S_AUTOSTOREStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUNMSTR_S_AUTOSTOREStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUNMSTR_S_AUTOSTOREStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUNMSTR_S_AUTOSTOREStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUNMSTR_S_AUTOSTOREStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AutoStore_Start"

    static const int kAutoStore_Start = 0;

    /**
     * Clears the field "AutoStore_Start".
     *
     * The field will be set to its default value. The hasAutoStore_Start()
     * method will return false.
     */
    inline void clearAutoStore_Start();

    /**
     * Checks whether the field "AutoStore_Start" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAutoStore_Start()). Otherwise it will return false.
     */
    inline bool hasAutoStore_Start () const;

    /**
     * Returns the value of the member "AutoStore_Start".
     *
     * 1: Start Auto store
     * 0: Stop Auto Store
     *
     * @return The value of the field "AutoStore_Start"
     */
    inline bool getAutoStore_Start () const;

    /**
     * Sets the value of the member "AutoStore_Start".
     *
     * 1: Start Auto store
     * 0: Stop Auto Store
     *
     * @param AutoStore_Start The value which will be set
     */
    inline void setAutoStore_Start (bool AutoStore_Start_);

    // API of field "List"

    static const int kList = 1;

    /**
     * Clears the field "List".
     *
     * The field will be set to its default value. The hasList()
     * method will return false.
     */
    inline void clearList();

    /**
     * Checks whether the field "List" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setList()). Otherwise it will return false.
     */
    inline bool hasList () const;

    /**
     * Returns the value of the member "List".
     *
     * This parameter indicates to which list,station found during Normal AST should be updated.
     * In case of Initial AutoStore this value is ignored, and List ID values read from KDS will be used as reference.
     * List Value BANK_AM_AST, should be used if user needs a combined AST list with both MW and LW stations. Else respective List ID should be used
     *
     * @return The value of the field "List"
     */
    inline ::tunermaster_main_fi_types::T_e8_List getList () const;

    /**
     * Sets the value of the member "List".
     *
     * This parameter indicates to which list,station found during Normal AST should be updated.
     * In case of Initial AutoStore this value is ignored, and List ID values read from KDS will be used as reference.
     * List Value BANK_AM_AST, should be used if user needs a combined AST list with both MW and LW stations. Else respective List ID should be used
     *
     * @param List The value which will be set
     */
    inline void setList (::tunermaster_main_fi_types::T_e8_List List_);

    // API of field "AST_Type"

    static const int kAST_Type = 2;

    /**
     * Clears the field "AST_Type".
     *
     * The field will be set to its default value. The hasAST_Type()
     * method will return false.
     */
    inline void clearAST_Type();

    /**
     * Checks whether the field "AST_Type" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAST_Type()). Otherwise it will return false.
     */
    inline bool hasAST_Type () const;

    /**
     * Returns the value of the member "AST_Type".
     *
     *
     *
     * @return The value of the field "AST_Type"
     */
    inline ::tunermaster_main_fi_types::T_e8_AST_Types getAST_Type () const;

    /**
     * Sets the value of the member "AST_Type".
     *
     *
     *
     * @param AST_Type The value which will be set
     */
    inline void setAST_Type (::tunermaster_main_fi_types::T_e8_AST_Types AST_Type_);

    static const FID_TUNMSTR_S_AUTOSTOREStart &getDefaultInstance();

private:

    inline void set_has_AutoStore_Start ();

    inline void clear_has_AutoStore_Start ();

    inline void set_has_List ();

    inline void clear_has_List ();

    inline void set_has_AST_Type ();

    inline void clear_has_AST_Type ();

    uint32 _has_bits_[ (3 + 31) / 32];

    bool _AutoStore_Start;

    ::tunermaster_main_fi_types::T_e8_List _List;

    ::tunermaster_main_fi_types::T_e8_AST_Types _AST_Type;

};

/**
 * The result message of the method "FID_TUNMSTR_S_AUTOSTORE"
 * This command is used to initiate Auto store
 * .
 */
class FID_TUNMSTR_S_AUTOSTOREResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUNMSTR_S_AUTOSTOREResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUNMSTR_S_AUTOSTOREResult (const FID_TUNMSTR_S_AUTOSTOREResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUNMSTR_S_AUTOSTOREResult (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_, ::tunermaster_main_fi_types::T_e8_Source Source_, ::tunermaster_main_fi_types::T_e8_Action Action_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUNMSTR_S_AUTOSTOREResult();

    /**
     * Assignment operator
     */
    inline FID_TUNMSTR_S_AUTOSTOREResult& operator = (const FID_TUNMSTR_S_AUTOSTOREResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUNMSTR_S_AUTOSTOREResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUNMSTR_S_AUTOSTOREResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUNMSTR_S_AUTOSTOREResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUNMSTR_S_AUTOSTOREResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerMaster_StatusResponse"

    static const int kTunerMaster_StatusResponse = 0;

    /**
     * Clears the field "TunerMaster_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerMaster_StatusResponse()
     * method will return false.
     */
    inline void clearTunerMaster_StatusResponse();

    /**
     * Checks whether the field "TunerMaster_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerMaster_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerMaster_StatusResponse () const;

    /**
     * Returns the value of the member "TunerMaster_StatusResponse".
     *
     * .
     *
     * @return The value of the field "TunerMaster_StatusResponse"
     */
    inline const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& getTunerMaster_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerMaster_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerMaster_StatusResponse".
     */
    inline ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& getTunerMaster_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerMaster_StatusResponse".
     *
     * .
     *
     * @param TunerMaster_StatusResponse The value which will be set
     */
    inline void setTunerMaster_StatusResponse (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_);

    // API of field "Source"

    static const int kSource = 1;

    /**
     * Clears the field "Source".
     *
     * The field will be set to its default value. The hasSource()
     * method will return false.
     */
    inline void clearSource();

    /**
     * Checks whether the field "Source" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSource()). Otherwise it will return false.
     */
    inline bool hasSource () const;

    /**
     * Returns the value of the member "Source".
     *
     * This parameter is used to indicate if Source/Band change is required to complete AST
     *
     * @return The value of the field "Source"
     */
    inline ::tunermaster_main_fi_types::T_e8_Source getSource () const;

    /**
     * Sets the value of the member "Source".
     *
     * This parameter is used to indicate if Source/Band change is required to complete AST
     *
     * @param Source The value which will be set
     */
    inline void setSource (::tunermaster_main_fi_types::T_e8_Source Source_);

    // API of field "Action"

    static const int kAction = 2;

    /**
     * Clears the field "Action".
     *
     * The field will be set to its default value. The hasAction()
     * method will return false.
     */
    inline void clearAction();

    /**
     * Checks whether the field "Action" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAction()). Otherwise it will return false.
     */
    inline bool hasAction () const;

    /**
     * Returns the value of the member "Action".
     *
     * This parameter will inform what action to be performed with the source parameter to complete AST functionality.
     *
     * @return The value of the field "Action"
     */
    inline ::tunermaster_main_fi_types::T_e8_Action getAction () const;

    /**
     * Sets the value of the member "Action".
     *
     * This parameter will inform what action to be performed with the source parameter to complete AST functionality.
     *
     * @param Action The value which will be set
     */
    inline void setAction (::tunermaster_main_fi_types::T_e8_Action Action_);

    static const FID_TUNMSTR_S_AUTOSTOREResult &getDefaultInstance();

private:

    inline void set_has_TunerMaster_StatusResponse ();

    inline void clear_has_TunerMaster_StatusResponse ();

    inline void set_has_Source ();

    inline void clear_has_Source ();

    inline void set_has_Action ();

    inline void clear_has_Action ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse _TunerMaster_StatusResponse;

    ::tunermaster_main_fi_types::T_e8_Source _Source;

    ::tunermaster_main_fi_types::T_e8_Action _Action;

};

/**
 * The start message of the method "FID_TUNMSTR_S_MTC_SETMODE"
 * Sets the mode for the service switch request. It can be OFF, DAB to FM switching or FM to DAB switching.
 */
class FID_TUNMSTR_S_MTC_SETMODEStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUNMSTR_S_MTC_SETMODEStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUNMSTR_S_MTC_SETMODEStart (const FID_TUNMSTR_S_MTC_SETMODEStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUNMSTR_S_MTC_SETMODEStart (const ::tunermaster_main_fi_types::T_b8_ModeType& Mode_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUNMSTR_S_MTC_SETMODEStart();

    /**
     * Assignment operator
     */
    inline FID_TUNMSTR_S_MTC_SETMODEStart& operator = (const FID_TUNMSTR_S_MTC_SETMODEStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUNMSTR_S_MTC_SETMODEStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUNMSTR_S_MTC_SETMODEStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUNMSTR_S_MTC_SETMODEStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUNMSTR_S_MTC_SETMODEStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Mode"

    static const int kMode = 0;

    /**
     * Clears the field "Mode".
     *
     * The field will be set to its default value. The hasMode()
     * method will return false.
     */
    inline void clearMode();

    /**
     * Checks whether the field "Mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMode()). Otherwise it will return false.
     */
    inline bool hasMode () const;

    /**
     * Returns the value of the member "Mode".
     *
     * Tells which service linking mode is requested to be set
     * by the HMI, BIT0 not to be used.
     *
     * @return The value of the field "Mode"
     */
    inline const ::tunermaster_main_fi_types::T_b8_ModeType& getMode () const;

    /**
     * Retrieves the value of the field "Mode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Mode".
     */
    inline ::tunermaster_main_fi_types::T_b8_ModeType& getModeMutable ();

    /**
     * Sets the value of the member "Mode".
     *
     * Tells which service linking mode is requested to be set
     * by the HMI, BIT0 not to be used.
     *
     * @param Mode The value which will be set
     */
    inline void setMode (const ::tunermaster_main_fi_types::T_b8_ModeType& Mode_);

    static const FID_TUNMSTR_S_MTC_SETMODEStart &getDefaultInstance();

private:

    inline void set_has_Mode ();

    inline void clear_has_Mode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tunermaster_main_fi_types::T_b8_ModeType _Mode;

};

/**
 * The result message of the method "FID_TUNMSTR_S_MTC_SETMODE"
 * Sets the mode for the service switch request. It can be OFF, DAB to FM switching or FM to DAB switching.
 * .
 */
class FID_TUNMSTR_S_MTC_SETMODEResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUNMSTR_S_MTC_SETMODEResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUNMSTR_S_MTC_SETMODEResult (const FID_TUNMSTR_S_MTC_SETMODEResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUNMSTR_S_MTC_SETMODEResult (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUNMSTR_S_MTC_SETMODEResult();

    /**
     * Assignment operator
     */
    inline FID_TUNMSTR_S_MTC_SETMODEResult& operator = (const FID_TUNMSTR_S_MTC_SETMODEResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUNMSTR_S_MTC_SETMODEResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUNMSTR_S_MTC_SETMODEResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUNMSTR_S_MTC_SETMODEResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUNMSTR_S_MTC_SETMODEResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerMaster_StatusResponse"

    static const int kTunerMaster_StatusResponse = 0;

    /**
     * Clears the field "TunerMaster_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerMaster_StatusResponse()
     * method will return false.
     */
    inline void clearTunerMaster_StatusResponse();

    /**
     * Checks whether the field "TunerMaster_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerMaster_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerMaster_StatusResponse () const;

    /**
     * Returns the value of the member "TunerMaster_StatusResponse".
     *
     * .
     *
     * @return The value of the field "TunerMaster_StatusResponse"
     */
    inline const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& getTunerMaster_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerMaster_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerMaster_StatusResponse".
     */
    inline ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& getTunerMaster_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerMaster_StatusResponse".
     *
     * .
     *
     * @param TunerMaster_StatusResponse The value which will be set
     */
    inline void setTunerMaster_StatusResponse (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_);

    static const FID_TUNMSTR_S_MTC_SETMODEResult &getDefaultInstance();

private:

    inline void set_has_TunerMaster_StatusResponse ();

    inline void clear_has_TunerMaster_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse _TunerMaster_StatusResponse;

};

/**
 * The start message of the method "FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCY"
 * This method is used to set the DRM frequency directly  by SDS
 */
class FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYStart (const FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYStart (uint32 u32Frequency_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYStart();

    /**
     * Assignment operator
     */
    inline FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYStart& operator = (const FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32Frequency"

    static const int kU32Frequency = 0;

    /**
     * Clears the field "u32Frequency".
     *
     * The field will be set to its default value. The hasU32Frequency()
     * method will return false.
     */
    inline void clearU32Frequency();

    /**
     * Checks whether the field "u32Frequency" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Frequency()). Otherwise it will return false.
     */
    inline bool hasU32Frequency () const;

    /**
     * Returns the value of the member "u32Frequency".
     *
     * If the meaning of "u32Frequency" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32Frequency"
     */
    inline uint32 getU32Frequency () const;

    /**
     * Sets the value of the member "u32Frequency".
     *
     * If the meaning of "u32Frequency" isn't clear, then there should be a description here.
     *
     * @param u32Frequency The value which will be set
     */
    inline void setU32Frequency (uint32 u32Frequency_);

    static const FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYStart &getDefaultInstance();

private:

    inline void set_has_u32Frequency ();

    inline void clear_has_u32Frequency ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _u32Frequency;

};

/**
 * The result message of the method "FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCY"
 * This method is used to set the DRM frequency directly  by SDS
 */
class FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYResult (const FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYResult (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYResult();

    /**
     * Assignment operator
     */
    inline FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYResult& operator = (const FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerMaster_StatusResponse"

    static const int kTunerMaster_StatusResponse = 0;

    /**
     * Clears the field "TunerMaster_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerMaster_StatusResponse()
     * method will return false.
     */
    inline void clearTunerMaster_StatusResponse();

    /**
     * Checks whether the field "TunerMaster_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerMaster_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerMaster_StatusResponse () const;

    /**
     * Returns the value of the member "TunerMaster_StatusResponse".
     *
     * If the meaning of "TunerMaster_StatusResponse" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TunerMaster_StatusResponse"
     */
    inline const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& getTunerMaster_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerMaster_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerMaster_StatusResponse".
     */
    inline ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& getTunerMaster_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerMaster_StatusResponse".
     *
     * If the meaning of "TunerMaster_StatusResponse" isn't clear, then there should be a description here.
     *
     * @param TunerMaster_StatusResponse The value which will be set
     */
    inline void setTunerMaster_StatusResponse (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_);

    static const FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYResult &getDefaultInstance();

private:

    inline void set_has_TunerMaster_StatusResponse ();

    inline void clear_has_TunerMaster_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse _TunerMaster_StatusResponse;

};

/**
 * The start message of the method "FID_TUNMSTR_S_STATION_SELECTION"
 * This method is used by SDS to select station through frequency input , preset number , station name
 */
class FID_TUNMSTR_S_STATION_SELECTIONStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUNMSTR_S_STATION_SELECTIONStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUNMSTR_S_STATION_SELECTIONStart (const FID_TUNMSTR_S_STATION_SELECTIONStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUNMSTR_S_STATION_SELECTIONStart (::tunermaster_main_fi_types::T_e8_StationSelection_Option Option_, ::tunermaster_main_fi_types::T_e8_Band Band_, uint32 Frequency_, uint8 u8Element_ID_, ::tunermaster_main_fi_types::T_e8_List List_, uint32 PI_, uint16 SecondaryPI_, ::tunermaster_main_fi_types::T_e8_ModulationType ModulationType_, uint8 HDProgramNumber_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUNMSTR_S_STATION_SELECTIONStart();

    /**
     * Assignment operator
     */
    inline FID_TUNMSTR_S_STATION_SELECTIONStart& operator = (const FID_TUNMSTR_S_STATION_SELECTIONStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUNMSTR_S_STATION_SELECTIONStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUNMSTR_S_STATION_SELECTIONStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUNMSTR_S_STATION_SELECTIONStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUNMSTR_S_STATION_SELECTIONStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Option"

    static const int kOption = 0;

    /**
     * Clears the field "Option".
     *
     * The field will be set to its default value. The hasOption()
     * method will return false.
     */
    inline void clearOption();

    /**
     * Checks whether the field "Option" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOption()). Otherwise it will return false.
     */
    inline bool hasOption () const;

    /**
     * Returns the value of the member "Option".
     *
     * This parameter will inform the options available for SDS input.
     *
     * @return The value of the field "Option"
     */
    inline ::tunermaster_main_fi_types::T_e8_StationSelection_Option getOption () const;

    /**
     * Sets the value of the member "Option".
     *
     * This parameter will inform the options available for SDS input.
     *
     * @param Option The value which will be set
     */
    inline void setOption (::tunermaster_main_fi_types::T_e8_StationSelection_Option Option_);

    // API of field "Band"

    static const int kBand = 1;

    /**
     * Clears the field "Band".
     *
     * The field will be set to its default value. The hasBand()
     * method will return false.
     */
    inline void clearBand();

    /**
     * Checks whether the field "Band" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBand()). Otherwise it will return false.
     */
    inline bool hasBand () const;

    /**
     * Returns the value of the member "Band".
     *
     * Which Band Frequency belongs to
     *
     * @return The value of the field "Band"
     */
    inline ::tunermaster_main_fi_types::T_e8_Band getBand () const;

    /**
     * Sets the value of the member "Band".
     *
     * Which Band Frequency belongs to
     *
     * @param Band The value which will be set
     */
    inline void setBand (::tunermaster_main_fi_types::T_e8_Band Band_);

    // API of field "Frequency"

    static const int kFrequency = 2;

    /**
     * Clears the field "Frequency".
     *
     * The field will be set to its default value. The hasFrequency()
     * method will return false.
     */
    inline void clearFrequency();

    /**
     * Checks whether the field "Frequency" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFrequency()). Otherwise it will return false.
     */
    inline bool hasFrequency () const;

    /**
     * Returns the value of the member "Frequency".
     *
     * Frequency Value
     *
     * @return The value of the field "Frequency"
     */
    inline uint32 getFrequency () const;

    /**
     * Sets the value of the member "Frequency".
     *
     * Frequency Value
     *
     * @param Frequency The value which will be set
     */
    inline void setFrequency (uint32 Frequency_);

    // API of field "u8Element_ID"

    static const int kU8Element_ID = 3;

    /**
     * Clears the field "u8Element_ID".
     *
     * The field will be set to its default value. The hasU8Element_ID()
     * method will return false.
     */
    inline void clearU8Element_ID();

    /**
     * Checks whether the field "u8Element_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Element_ID()). Otherwise it will return false.
     */
    inline bool hasU8Element_ID () const;

    /**
     * Returns the value of the member "u8Element_ID".
     *
     * This parameter indicates to which element, requested action has to be performed
     *
     * @return The value of the field "u8Element_ID"
     */
    inline uint8 getU8Element_ID () const;

    /**
     * Sets the value of the member "u8Element_ID".
     *
     * This parameter indicates to which element, requested action has to be performed
     *
     * @param u8Element_ID The value which will be set
     */
    inline void setU8Element_ID (uint8 u8Element_ID_);

    // API of field "List"

    static const int kList = 4;

    /**
     * Clears the field "List".
     *
     * The field will be set to its default value. The hasList()
     * method will return false.
     */
    inline void clearList();

    /**
     * Checks whether the field "List" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setList()). Otherwise it will return false.
     */
    inline bool hasList () const;

    /**
     * Returns the value of the member "List".
     *
     * This parameter indicates to which list,requested action has to be performed
     *
     * @return The value of the field "List"
     */
    inline ::tunermaster_main_fi_types::T_e8_List getList () const;

    /**
     * Sets the value of the member "List".
     *
     * This parameter indicates to which list,requested action has to be performed
     *
     * @param List The value which will be set
     */
    inline void setList (::tunermaster_main_fi_types::T_e8_List List_);

    // API of field "PI"

    static const int kPI = 5;

    /**
     * Clears the field "PI".
     *
     * The field will be set to its default value. The hasPI()
     * method will return false.
     */
    inline void clearPI();

    /**
     * Checks whether the field "PI" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPI()). Otherwise it will return false.
     */
    inline bool hasPI () const;

    /**
     * Returns the value of the member "PI".
     *
     * This parameter indicates the PI, HD StationID and DRM Service ID
     *
     * @return The value of the field "PI"
     */
    inline uint32 getPI () const;

    /**
     * Sets the value of the member "PI".
     *
     * This parameter indicates the PI, HD StationID and DRM Service ID
     *
     * @param PI The value which will be set
     */
    inline void setPI (uint32 PI_);

    // API of field "SecondaryPI"

    static const int kSecondaryPI = 6;

    /**
     * Clears the field "SecondaryPI".
     *
     * The field will be set to its default value. The hasSecondaryPI()
     * method will return false.
     */
    inline void clearSecondaryPI();

    /**
     * Checks whether the field "SecondaryPI" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSecondaryPI()). Otherwise it will return false.
     */
    inline bool hasSecondaryPI () const;

    /**
     * Returns the value of the member "SecondaryPI".
     *
     * LSB is for SecondaryID
     *
     * @return The value of the field "SecondaryPI"
     */
    inline uint16 getSecondaryPI () const;

    /**
     * Sets the value of the member "SecondaryPI".
     *
     * LSB is for SecondaryID
     *
     * @param SecondaryPI The value which will be set
     */
    inline void setSecondaryPI (uint16 SecondaryPI_);

    // API of field "ModulationType"

    static const int kModulationType = 7;

    /**
     * Clears the field "ModulationType".
     *
     * The field will be set to its default value. The hasModulationType()
     * method will return false.
     */
    inline void clearModulationType();

    /**
     * Checks whether the field "ModulationType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setModulationType()). Otherwise it will return false.
     */
    inline bool hasModulationType () const;

    /**
     * Returns the value of the member "ModulationType".
     *
     * Type of Modulation - Analog, HD , DRM.
     *
     * @return The value of the field "ModulationType"
     */
    inline ::tunermaster_main_fi_types::T_e8_ModulationType getModulationType () const;

    /**
     * Sets the value of the member "ModulationType".
     *
     * Type of Modulation - Analog, HD , DRM.
     *
     * @param ModulationType The value which will be set
     */
    inline void setModulationType (::tunermaster_main_fi_types::T_e8_ModulationType ModulationType_);

    // API of field "HDProgramNumber"

    static const int kHDProgramNumber = 8;

    /**
     * Clears the field "HDProgramNumber".
     *
     * The field will be set to its default value. The hasHDProgramNumber()
     * method will return false.
     */
    inline void clearHDProgramNumber();

    /**
     * Checks whether the field "HDProgramNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHDProgramNumber()). Otherwise it will return false.
     */
    inline bool hasHDProgramNumber () const;

    /**
     * Returns the value of the member "HDProgramNumber".
     *
     * This parameter indicates the HDProgramNumber of the respective station.
     *
     * @return The value of the field "HDProgramNumber"
     */
    inline uint8 getHDProgramNumber () const;

    /**
     * Sets the value of the member "HDProgramNumber".
     *
     * This parameter indicates the HDProgramNumber of the respective station.
     *
     * @param HDProgramNumber The value which will be set
     */
    inline void setHDProgramNumber (uint8 HDProgramNumber_);

    static const FID_TUNMSTR_S_STATION_SELECTIONStart &getDefaultInstance();

private:

    inline void set_has_Option ();

    inline void clear_has_Option ();

    inline void set_has_Band ();

    inline void clear_has_Band ();

    inline void set_has_Frequency ();

    inline void clear_has_Frequency ();

    inline void set_has_u8Element_ID ();

    inline void clear_has_u8Element_ID ();

    inline void set_has_List ();

    inline void clear_has_List ();

    inline void set_has_PI ();

    inline void clear_has_PI ();

    inline void set_has_SecondaryPI ();

    inline void clear_has_SecondaryPI ();

    inline void set_has_ModulationType ();

    inline void clear_has_ModulationType ();

    inline void set_has_HDProgramNumber ();

    inline void clear_has_HDProgramNumber ();

    uint32 _has_bits_[ (9 + 31) / 32];

    ::tunermaster_main_fi_types::T_e8_StationSelection_Option _Option;

    ::tunermaster_main_fi_types::T_e8_Band _Band;

    uint32 _Frequency;

    uint8 _u8Element_ID;

    ::tunermaster_main_fi_types::T_e8_List _List;

    uint32 _PI;

    uint16 _SecondaryPI;

    ::tunermaster_main_fi_types::T_e8_ModulationType _ModulationType;

    uint8 _HDProgramNumber;

};

/**
 * The result message of the method "FID_TUNMSTR_S_STATION_SELECTION"
 * This method is used by SDS to select station through frequency input , preset number , station name
 */
class FID_TUNMSTR_S_STATION_SELECTIONResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUNMSTR_S_STATION_SELECTIONResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUNMSTR_S_STATION_SELECTIONResult (const FID_TUNMSTR_S_STATION_SELECTIONResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUNMSTR_S_STATION_SELECTIONResult (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUNMSTR_S_STATION_SELECTIONResult();

    /**
     * Assignment operator
     */
    inline FID_TUNMSTR_S_STATION_SELECTIONResult& operator = (const FID_TUNMSTR_S_STATION_SELECTIONResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUNMSTR_S_STATION_SELECTIONResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUNMSTR_S_STATION_SELECTIONResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUNMSTR_S_STATION_SELECTIONResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUNMSTR_S_STATION_SELECTIONResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerMaster_StatusResponse"

    static const int kTunerMaster_StatusResponse = 0;

    /**
     * Clears the field "TunerMaster_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerMaster_StatusResponse()
     * method will return false.
     */
    inline void clearTunerMaster_StatusResponse();

    /**
     * Checks whether the field "TunerMaster_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerMaster_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerMaster_StatusResponse () const;

    /**
     * Returns the value of the member "TunerMaster_StatusResponse".
     *
     * If the meaning of "TunerMaster_StatusResponse" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TunerMaster_StatusResponse"
     */
    inline const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& getTunerMaster_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerMaster_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerMaster_StatusResponse".
     */
    inline ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& getTunerMaster_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerMaster_StatusResponse".
     *
     * If the meaning of "TunerMaster_StatusResponse" isn't clear, then there should be a description here.
     *
     * @param TunerMaster_StatusResponse The value which will be set
     */
    inline void setTunerMaster_StatusResponse (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_);

    static const FID_TUNMSTR_S_STATION_SELECTIONResult &getDefaultInstance();

private:

    inline void set_has_TunerMaster_StatusResponse ();

    inline void clear_has_TunerMaster_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse _TunerMaster_StatusResponse;

};

/**
 * The start message of the method "FID_TUNMSTR_S_SOURCE_SETUP_OPTION"
 * This method is used by clients to Enable/Disable the Tuner dynamic source.
 * <p>Currently only AM source is supported. Please contact reception team for other source</p>
 */
class FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart (const FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart (bool Enable_, ::tunermaster_main_fi_types::T_e8_Source Source_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart();

    /**
     * Assignment operator
     */
    inline FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart& operator = (const FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Enable"

    static const int kEnable = 0;

    /**
     * Clears the field "Enable".
     *
     * The field will be set to its default value. The hasEnable()
     * method will return false.
     */
    inline void clearEnable();

    /**
     * Checks whether the field "Enable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnable()). Otherwise it will return false.
     */
    inline bool hasEnable () const;

    /**
     * Returns the value of the member "Enable".
     *
     * Indicates if the Source need to be Enable or Disable
     * <p>01: Enable Source</p>
     * <p>00: Disable Source</p>
     *
     * @return The value of the field "Enable"
     */
    inline bool getEnable () const;

    /**
     * Sets the value of the member "Enable".
     *
     * Indicates if the Source need to be Enable or Disable
     * <p>01: Enable Source</p>
     * <p>00: Disable Source</p>
     *
     * @param Enable The value which will be set
     */
    inline void setEnable (bool Enable_);

    // API of field "Source"

    static const int kSource = 1;

    /**
     * Clears the field "Source".
     *
     * The field will be set to its default value. The hasSource()
     * method will return false.
     */
    inline void clearSource();

    /**
     * Checks whether the field "Source" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSource()). Otherwise it will return false.
     */
    inline bool hasSource () const;

    /**
     * Returns the value of the member "Source".
     *
     * This parameter is used to indicate Source which needs to be Enable/Disable
     *
     * @return The value of the field "Source"
     */
    inline ::tunermaster_main_fi_types::T_e8_Source getSource () const;

    /**
     * Sets the value of the member "Source".
     *
     * This parameter is used to indicate Source which needs to be Enable/Disable
     *
     * @param Source The value which will be set
     */
    inline void setSource (::tunermaster_main_fi_types::T_e8_Source Source_);

    static const FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart &getDefaultInstance();

private:

    inline void set_has_Enable ();

    inline void clear_has_Enable ();

    inline void set_has_Source ();

    inline void clear_has_Source ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _Enable;

    ::tunermaster_main_fi_types::T_e8_Source _Source;

};

/**
 * The result message of the method "FID_TUNMSTR_S_SOURCE_SETUP_OPTION"
 * This method is used by clients to Enable/Disable the Tuner dynamic source.
 * <p>Currently only AM source is supported. Please contact reception team for other source</p>
 */
class FID_TUNMSTR_S_SOURCE_SETUP_OPTIONResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUNMSTR_S_SOURCE_SETUP_OPTIONResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUNMSTR_S_SOURCE_SETUP_OPTIONResult (const FID_TUNMSTR_S_SOURCE_SETUP_OPTIONResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUNMSTR_S_SOURCE_SETUP_OPTIONResult (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUNMSTR_S_SOURCE_SETUP_OPTIONResult();

    /**
     * Assignment operator
     */
    inline FID_TUNMSTR_S_SOURCE_SETUP_OPTIONResult& operator = (const FID_TUNMSTR_S_SOURCE_SETUP_OPTIONResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUNMSTR_S_SOURCE_SETUP_OPTIONResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUNMSTR_S_SOURCE_SETUP_OPTIONResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUNMSTR_S_SOURCE_SETUP_OPTIONResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUNMSTR_S_SOURCE_SETUP_OPTIONResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerMaster_StatusResponse"

    static const int kTunerMaster_StatusResponse = 0;

    /**
     * Clears the field "TunerMaster_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerMaster_StatusResponse()
     * method will return false.
     */
    inline void clearTunerMaster_StatusResponse();

    /**
     * Checks whether the field "TunerMaster_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerMaster_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerMaster_StatusResponse () const;

    /**
     * Returns the value of the member "TunerMaster_StatusResponse".
     *
     * If the meaning of "TunerMaster_StatusResponse" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TunerMaster_StatusResponse"
     */
    inline const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& getTunerMaster_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerMaster_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerMaster_StatusResponse".
     */
    inline ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& getTunerMaster_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerMaster_StatusResponse".
     *
     * If the meaning of "TunerMaster_StatusResponse" isn't clear, then there should be a description here.
     *
     * @param TunerMaster_StatusResponse The value which will be set
     */
    inline void setTunerMaster_StatusResponse (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_);

    static const FID_TUNMSTR_S_SOURCE_SETUP_OPTIONResult &getDefaultInstance();

private:

    inline void set_has_TunerMaster_StatusResponse ();

    inline void clear_has_TunerMaster_StatusResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse _TunerMaster_StatusResponse;

};

/**
 * The start message of the method "FID_TUNMSTR_S_RADIOPROFILE_SETTING"
 * Message will contain tuner parameters required for radio profile setting for current user.
 * Currently, Presets and AM Switch are supported.
 */
class FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart (const FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart (const ::std::vector< ::tunermaster_main_fi_types::T_TunMst_PresetListElement >& RadioProfile_PresetList_, bool RadioProfile_AMSwitch_, ::tunermaster_main_fi_types::T_e8_Preset_Option RadioProfile_Option_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart();

    /**
     * Assignment operator
     */
    inline FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart& operator = (const FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RadioProfile_PresetList"

    static const int kRadioProfile_PresetList = 0;

    /**
     * Clears the field "RadioProfile_PresetList".
     *
     * The field will be set to its default value. The hasRadioProfile_PresetList()
     * method will return false.
     */
    inline void clearRadioProfile_PresetList();

    /**
     * Checks whether the field "RadioProfile_PresetList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRadioProfile_PresetList()). Otherwise it will return false.
     */
    inline bool hasRadioProfile_PresetList () const;

    /**
     * Returns the value of the member "RadioProfile_PresetList".
     *
     * list of preset elements
     *
     * @return The value of the field "RadioProfile_PresetList"
     */
    inline const ::std::vector< ::tunermaster_main_fi_types::T_TunMst_PresetListElement >& getRadioProfile_PresetList () const;

    /**
     * Retrieves the value of the field "RadioProfile_PresetList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RadioProfile_PresetList".
     */
    inline ::std::vector< ::tunermaster_main_fi_types::T_TunMst_PresetListElement >& getRadioProfile_PresetListMutable ();

    /**
     * Sets the value of the member "RadioProfile_PresetList".
     *
     * list of preset elements
     *
     * @param RadioProfile_PresetList The value which will be set
     */
    inline void setRadioProfile_PresetList (const ::std::vector< ::tunermaster_main_fi_types::T_TunMst_PresetListElement >& RadioProfile_PresetList_);

    // API of field "RadioProfile_AMSwitch"

    static const int kRadioProfile_AMSwitch = 1;

    /**
     * Clears the field "RadioProfile_AMSwitch".
     *
     * The field will be set to its default value. The hasRadioProfile_AMSwitch()
     * method will return false.
     */
    inline void clearRadioProfile_AMSwitch();

    /**
     * Checks whether the field "RadioProfile_AMSwitch" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRadioProfile_AMSwitch()). Otherwise it will return false.
     */
    inline bool hasRadioProfile_AMSwitch () const;

    /**
     * Returns the value of the member "RadioProfile_AMSwitch".
     *
     * AM Switch ON and OFF status
     *
     * @return The value of the field "RadioProfile_AMSwitch"
     */
    inline bool getRadioProfile_AMSwitch () const;

    /**
     * Sets the value of the member "RadioProfile_AMSwitch".
     *
     * AM Switch ON and OFF status
     *
     * @param RadioProfile_AMSwitch The value which will be set
     */
    inline void setRadioProfile_AMSwitch (bool RadioProfile_AMSwitch_);

    // API of field "RadioProfile_Option"

    static const int kRadioProfile_Option = 2;

    /**
     * Clears the field "RadioProfile_Option".
     *
     * The field will be set to its default value. The hasRadioProfile_Option()
     * method will return false.
     */
    inline void clearRadioProfile_Option();

    /**
     * Checks whether the field "RadioProfile_Option" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRadioProfile_Option()). Otherwise it will return false.
     */
    inline bool hasRadioProfile_Option () const;

    /**
     * Returns the value of the member "RadioProfile_Option".
     *
     * Operation to be performed on other presets.
     *
     * @return The value of the field "RadioProfile_Option"
     */
    inline ::tunermaster_main_fi_types::T_e8_Preset_Option getRadioProfile_Option () const;

    /**
     * Sets the value of the member "RadioProfile_Option".
     *
     * Operation to be performed on other presets.
     *
     * @param RadioProfile_Option The value which will be set
     */
    inline void setRadioProfile_Option (::tunermaster_main_fi_types::T_e8_Preset_Option RadioProfile_Option_);

    static const FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart &getDefaultInstance();

private:

    static const ::std::vector< ::tunermaster_main_fi_types::T_TunMst_PresetListElement >& getT_TunMst_PresetListElementList_DefaultInstance ();

    inline void set_has_RadioProfile_PresetList ();

    inline void clear_has_RadioProfile_PresetList ();

    inline void set_has_RadioProfile_AMSwitch ();

    inline void clear_has_RadioProfile_AMSwitch ();

    inline void set_has_RadioProfile_Option ();

    inline void clear_has_RadioProfile_Option ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::vector< ::tunermaster_main_fi_types::T_TunMst_PresetListElement > _RadioProfile_PresetList;

    bool _RadioProfile_AMSwitch;

    ::tunermaster_main_fi_types::T_e8_Preset_Option _RadioProfile_Option;

};

/**
 * The result message of the method "FID_TUNMSTR_S_RADIOPROFILE_SETTING"
 * Message will contain tuner parameters required for radio profile setting for current user.
 * Currently, Presets and AM Switch are supported.
 * .
 */
class FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult (const FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult (const ::tunermaster_main_fi_types::T_TunMstr_RadioSetting_StatusResponse& RadioProfileSetting_Response_, uint8 u8FailedPresetID_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult();

    /**
     * Assignment operator
     */
    inline FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult& operator = (const FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RadioProfileSetting_Response"

    static const int kRadioProfileSetting_Response = 0;

    /**
     * Clears the field "RadioProfileSetting_Response".
     *
     * The field will be set to its default value. The hasRadioProfileSetting_Response()
     * method will return false.
     */
    inline void clearRadioProfileSetting_Response();

    /**
     * Checks whether the field "RadioProfileSetting_Response" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRadioProfileSetting_Response()). Otherwise it will return false.
     */
    inline bool hasRadioProfileSetting_Response () const;

    /**
     * Returns the value of the member "RadioProfileSetting_Response".
     *
     * Radio profile setting success/failure repsonse along with Error code . Only Success and Failure will be sent Ongoing error will not be returned in MethodResult
     *
     * @return The value of the field "RadioProfileSetting_Response"
     */
    inline const ::tunermaster_main_fi_types::T_TunMstr_RadioSetting_StatusResponse& getRadioProfileSetting_Response () const;

    /**
     * Retrieves the value of the field "RadioProfileSetting_Response" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RadioProfileSetting_Response".
     */
    inline ::tunermaster_main_fi_types::T_TunMstr_RadioSetting_StatusResponse& getRadioProfileSetting_ResponseMutable ();

    /**
     * Sets the value of the member "RadioProfileSetting_Response".
     *
     * Radio profile setting success/failure repsonse along with Error code . Only Success and Failure will be sent Ongoing error will not be returned in MethodResult
     *
     * @param RadioProfileSetting_Response The value which will be set
     */
    inline void setRadioProfileSetting_Response (const ::tunermaster_main_fi_types::T_TunMstr_RadioSetting_StatusResponse& RadioProfileSetting_Response_);

    // API of field "u8FailedPresetID"

    static const int kU8FailedPresetID = 1;

    /**
     * Clears the field "u8FailedPresetID".
     *
     * The field will be set to its default value. The hasU8FailedPresetID()
     * method will return false.
     */
    inline void clearU8FailedPresetID();

    /**
     * Checks whether the field "u8FailedPresetID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8FailedPresetID()). Otherwise it will return false.
     */
    inline bool hasU8FailedPresetID () const;

    /**
     * Returns the value of the member "u8FailedPresetID".
     *
     * Set to first failed Preset ID of the requested Preset List.
     * Set to zero when preset configuration is SUCCESS and other settings(AM Switch) FAILURE.
     * Set to zero in case of SUCCESS.
     *
     * @return The value of the field "u8FailedPresetID"
     */
    inline uint8 getU8FailedPresetID () const;

    /**
     * Sets the value of the member "u8FailedPresetID".
     *
     * Set to first failed Preset ID of the requested Preset List.
     * Set to zero when preset configuration is SUCCESS and other settings(AM Switch) FAILURE.
     * Set to zero in case of SUCCESS.
     *
     * @param u8FailedPresetID The value which will be set
     */
    inline void setU8FailedPresetID (uint8 u8FailedPresetID_);

    static const FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult &getDefaultInstance();

private:

    inline void set_has_RadioProfileSetting_Response ();

    inline void clear_has_RadioProfileSetting_Response ();

    inline void set_has_u8FailedPresetID ();

    inline void clear_has_u8FailedPresetID ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::tunermaster_main_fi_types::T_TunMstr_RadioSetting_StatusResponse _RadioProfileSetting_Response;

    uint8 _u8FailedPresetID;

};

/**
 * The start message of the method "FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUEST"
 * Method used to request Presets or/and AM switch for profile radio settings synchronization . To get the complete preset List , list size should be Zero
 */
class FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart ();

    /**
     * Copy constructor
     */
    inline  FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart (const FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart (const ::tunermaster_main_fi_types::T_b8_RadioProfileSettingAction& RadioProfileSettingAction_, const ::std::vector< uint8 >& PresetID_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart();

    /**
     * Assignment operator
     */
    inline FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart& operator = (const FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RadioProfileSettingAction"

    static const int kRadioProfileSettingAction = 0;

    /**
     * Clears the field "RadioProfileSettingAction".
     *
     * The field will be set to its default value. The hasRadioProfileSettingAction()
     * method will return false.
     */
    inline void clearRadioProfileSettingAction();

    /**
     * Checks whether the field "RadioProfileSettingAction" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRadioProfileSettingAction()). Otherwise it will return false.
     */
    inline bool hasRadioProfileSettingAction () const;

    /**
     * Returns the value of the member "RadioProfileSettingAction".
     *
     * Parameters to be required 01-Only Presets 02-Only AM switch 03- Both Presets and AM Switch.
     *
     * @return The value of the field "RadioProfileSettingAction"
     */
    inline const ::tunermaster_main_fi_types::T_b8_RadioProfileSettingAction& getRadioProfileSettingAction () const;

    /**
     * Retrieves the value of the field "RadioProfileSettingAction" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RadioProfileSettingAction".
     */
    inline ::tunermaster_main_fi_types::T_b8_RadioProfileSettingAction& getRadioProfileSettingActionMutable ();

    /**
     * Sets the value of the member "RadioProfileSettingAction".
     *
     * Parameters to be required 01-Only Presets 02-Only AM switch 03- Both Presets and AM Switch.
     *
     * @param RadioProfileSettingAction The value which will be set
     */
    inline void setRadioProfileSettingAction (const ::tunermaster_main_fi_types::T_b8_RadioProfileSettingAction& RadioProfileSettingAction_);

    // API of field "PresetID"

    static const int kPresetID = 1;

    /**
     * Clears the field "PresetID".
     *
     * The field will be set to its default value. The hasPresetID()
     * method will return false.
     */
    inline void clearPresetID();

    /**
     * Checks whether the field "PresetID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPresetID()). Otherwise it will return false.
     */
    inline bool hasPresetID () const;

    /**
     * Returns the value of the member "PresetID".
     *
     * List of preset elements that which required to be notified, To get the complete preset List , list size should be Zero
     *
     * @return The value of the field "PresetID"
     */
    inline const ::std::vector< uint8 >& getPresetID () const;

    /**
     * Retrieves the value of the field "PresetID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PresetID".
     */
    inline ::std::vector< uint8 >& getPresetIDMutable ();

    /**
     * Sets the value of the member "PresetID".
     *
     * List of preset elements that which required to be notified, To get the complete preset List , list size should be Zero
     *
     * @param PresetID The value which will be set
     */
    inline void setPresetID (const ::std::vector< uint8 >& PresetID_);

    static const FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_RadioProfileSettingAction ();

    inline void clear_has_RadioProfileSettingAction ();

    inline void set_has_PresetID ();

    inline void clear_has_PresetID ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::tunermaster_main_fi_types::T_b8_RadioProfileSettingAction _RadioProfileSettingAction;

    ::std::vector< uint8 > _PresetID;

};

/**
 * The result message of the method "FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUEST"
 * Method used to request Presets or/and AM switch for profile radio settings synchronization . To get the complete preset List , list size should be Zero
 */
class FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult ();

    /**
     * Copy constructor
     */
    inline  FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult (const FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_, const ::std::vector< ::tunermaster_main_fi_types::T_TunMst_PresetListElement >& PresetList_, bool AMSwitch_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult();

    /**
     * Assignment operator
     */
    inline FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult& operator = (const FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerMaster_StatusResponse"

    static const int kTunerMaster_StatusResponse = 0;

    /**
     * Clears the field "TunerMaster_StatusResponse".
     *
     * The field will be set to its default value. The hasTunerMaster_StatusResponse()
     * method will return false.
     */
    inline void clearTunerMaster_StatusResponse();

    /**
     * Checks whether the field "TunerMaster_StatusResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerMaster_StatusResponse()). Otherwise it will return false.
     */
    inline bool hasTunerMaster_StatusResponse () const;

    /**
     * Returns the value of the member "TunerMaster_StatusResponse".
     *
     * If the meaning of "TunerMaster_StatusResponse" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TunerMaster_StatusResponse"
     */
    inline const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& getTunerMaster_StatusResponse () const;

    /**
     * Retrieves the value of the field "TunerMaster_StatusResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerMaster_StatusResponse".
     */
    inline ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& getTunerMaster_StatusResponseMutable ();

    /**
     * Sets the value of the member "TunerMaster_StatusResponse".
     *
     * If the meaning of "TunerMaster_StatusResponse" isn't clear, then there should be a description here.
     *
     * @param TunerMaster_StatusResponse The value which will be set
     */
    inline void setTunerMaster_StatusResponse (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_);

    // API of field "PresetList"

    static const int kPresetList = 1;

    /**
     * Clears the field "PresetList".
     *
     * The field will be set to its default value. The hasPresetList()
     * method will return false.
     */
    inline void clearPresetList();

    /**
     * Checks whether the field "PresetList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPresetList()). Otherwise it will return false.
     */
    inline bool hasPresetList () const;

    /**
     * Returns the value of the member "PresetList".
     *
     * List of Preset details
     *
     * @return The value of the field "PresetList"
     */
    inline const ::std::vector< ::tunermaster_main_fi_types::T_TunMst_PresetListElement >& getPresetList () const;

    /**
     * Retrieves the value of the field "PresetList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PresetList".
     */
    inline ::std::vector< ::tunermaster_main_fi_types::T_TunMst_PresetListElement >& getPresetListMutable ();

    /**
     * Sets the value of the member "PresetList".
     *
     * List of Preset details
     *
     * @param PresetList The value which will be set
     */
    inline void setPresetList (const ::std::vector< ::tunermaster_main_fi_types::T_TunMst_PresetListElement >& PresetList_);

    // API of field "AMSwitch"

    static const int kAMSwitch = 2;

    /**
     * Clears the field "AMSwitch".
     *
     * The field will be set to its default value. The hasAMSwitch()
     * method will return false.
     */
    inline void clearAMSwitch();

    /**
     * Checks whether the field "AMSwitch" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAMSwitch()). Otherwise it will return false.
     */
    inline bool hasAMSwitch () const;

    /**
     * Returns the value of the member "AMSwitch".
     *
     * Indicates AM Switch status ON or OFF
     *
     * @return The value of the field "AMSwitch"
     */
    inline bool getAMSwitch () const;

    /**
     * Sets the value of the member "AMSwitch".
     *
     * Indicates AM Switch status ON or OFF
     *
     * @param AMSwitch The value which will be set
     */
    inline void setAMSwitch (bool AMSwitch_);

    static const FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult &getDefaultInstance();

private:

    static const ::std::vector< ::tunermaster_main_fi_types::T_TunMst_PresetListElement >& getT_TunMst_PresetListElementList_DefaultInstance ();

    inline void set_has_TunerMaster_StatusResponse ();

    inline void clear_has_TunerMaster_StatusResponse ();

    inline void set_has_PresetList ();

    inline void clear_has_PresetList ();

    inline void set_has_AMSwitch ();

    inline void clear_has_AMSwitch ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse _TunerMaster_StatusResponse;

    ::std::vector< ::tunermaster_main_fi_types::T_TunMst_PresetListElement > _PresetList;

    bool _AMSwitch;

};

/**
 * The status message of the property "FID_TUNMSTR_G_SET_DTVAntennaRegister"
 * This property will set the DTV Antenna Power supply(example ELMOS IC) current register(Open/Over Current register) based on the KDS configuration in "CM_VariantCoding" and AntennaParameterSet"
 * For IVI, the request needs to be send when LVDS link is active
 */
class FID_TUNMSTR_G_SET_DTVAntennaRegisterStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUNMSTR_G_SET_DTVAntennaRegisterStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUNMSTR_G_SET_DTVAntennaRegisterStatus (const FID_TUNMSTR_G_SET_DTVAntennaRegisterStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUNMSTR_G_SET_DTVAntennaRegisterStatus (bool RequestAccepted_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUNMSTR_G_SET_DTVAntennaRegisterStatus();

    /**
     * Assignment operator
     */
    inline FID_TUNMSTR_G_SET_DTVAntennaRegisterStatus& operator = (const FID_TUNMSTR_G_SET_DTVAntennaRegisterStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUNMSTR_G_SET_DTVAntennaRegisterStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUNMSTR_G_SET_DTVAntennaRegisterStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUNMSTR_G_SET_DTVAntennaRegisterStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUNMSTR_G_SET_DTVAntennaRegisterStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RequestAccepted"

    static const int kRequestAccepted = 0;

    /**
     * Clears the field "RequestAccepted".
     *
     * The field will be set to its default value. The hasRequestAccepted()
     * method will return false.
     */
    inline void clearRequestAccepted();

    /**
     * Checks whether the field "RequestAccepted" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequestAccepted()). Otherwise it will return false.
     */
    inline bool hasRequestAccepted () const;

    /**
     * Returns the value of the member "RequestAccepted".
     *
     * 01: Request is accepted
     * 00: Request is not accepted
     *
     * @return The value of the field "RequestAccepted"
     */
    inline bool getRequestAccepted () const;

    /**
     * Sets the value of the member "RequestAccepted".
     *
     * 01: Request is accepted
     * 00: Request is not accepted
     *
     * @param RequestAccepted The value which will be set
     */
    inline void setRequestAccepted (bool RequestAccepted_);

    static const FID_TUNMSTR_G_SET_DTVAntennaRegisterStatus &getDefaultInstance();

private:

    inline void set_has_RequestAccepted ();

    inline void clear_has_RequestAccepted ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _RequestAccepted;

};

/**
 * The status message of the property "FID_TUNMSTR_G_TA_STATUS"
 * This property informs about TA button status
 */
class FID_TUNMSTR_G_TA_STATUSStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUNMSTR_G_TA_STATUSStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUNMSTR_G_TA_STATUSStatus (const FID_TUNMSTR_G_TA_STATUSStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUNMSTR_G_TA_STATUSStatus (bool TA_ButtonStatus_, ::tunermaster_main_fi_types::T_e8_Source Source_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUNMSTR_G_TA_STATUSStatus();

    /**
     * Assignment operator
     */
    inline FID_TUNMSTR_G_TA_STATUSStatus& operator = (const FID_TUNMSTR_G_TA_STATUSStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUNMSTR_G_TA_STATUSStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUNMSTR_G_TA_STATUSStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUNMSTR_G_TA_STATUSStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUNMSTR_G_TA_STATUSStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TA_ButtonStatus"

    static const int kTA_ButtonStatus = 0;

    /**
     * Clears the field "TA_ButtonStatus".
     *
     * The field will be set to its default value. The hasTA_ButtonStatus()
     * method will return false.
     */
    inline void clearTA_ButtonStatus();

    /**
     * Checks whether the field "TA_ButtonStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTA_ButtonStatus()). Otherwise it will return false.
     */
    inline bool hasTA_ButtonStatus () const;

    /**
     * Returns the value of the member "TA_ButtonStatus".
     *
     * 01: TA Button ACTIVE
     * 00: TA Button INACTIVE
     *
     * @return The value of the field "TA_ButtonStatus"
     */
    inline bool getTA_ButtonStatus () const;

    /**
     * Sets the value of the member "TA_ButtonStatus".
     *
     * 01: TA Button ACTIVE
     * 00: TA Button INACTIVE
     *
     * @param TA_ButtonStatus The value which will be set
     */
    inline void setTA_ButtonStatus (bool TA_ButtonStatus_);

    // API of field "Source"

    static const int kSource = 1;

    /**
     * Clears the field "Source".
     *
     * The field will be set to its default value. The hasSource()
     * method will return false.
     */
    inline void clearSource();

    /**
     * Checks whether the field "Source" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSource()). Otherwise it will return false.
     */
    inline bool hasSource () const;

    /**
     * Returns the value of the member "Source".
     *
     * This parameter will be removed in CW-01
     *
     * @return The value of the field "Source"
     */
    inline ::tunermaster_main_fi_types::T_e8_Source getSource () const;

    /**
     * Sets the value of the member "Source".
     *
     * This parameter will be removed in CW-01
     *
     * @param Source The value which will be set
     */
    inline void setSource (::tunermaster_main_fi_types::T_e8_Source Source_);

    static const FID_TUNMSTR_G_TA_STATUSStatus &getDefaultInstance();

private:

    inline void set_has_TA_ButtonStatus ();

    inline void clear_has_TA_ButtonStatus ();

    inline void set_has_Source ();

    inline void clear_has_Source ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _TA_ButtonStatus;

    ::tunermaster_main_fi_types::T_e8_Source _Source;

};

/**
 * The status message of the property "FID_TUNMSTR_G_TP_STATUS"
 * With this property fc_tunermaster will inform to HMI about TP status.
 */
class FID_TUNMSTR_G_TP_STATUSStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUNMSTR_G_TP_STATUSStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUNMSTR_G_TP_STATUSStatus (const FID_TUNMSTR_G_TP_STATUSStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUNMSTR_G_TP_STATUSStatus (bool TP_STATE_, ::tunermaster_main_fi_types::T_e8_Source TP_Source_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUNMSTR_G_TP_STATUSStatus();

    /**
     * Assignment operator
     */
    inline FID_TUNMSTR_G_TP_STATUSStatus& operator = (const FID_TUNMSTR_G_TP_STATUSStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUNMSTR_G_TP_STATUSStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUNMSTR_G_TP_STATUSStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUNMSTR_G_TP_STATUSStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUNMSTR_G_TP_STATUSStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TP_STATE"

    static const int kTP_STATE = 0;

    /**
     * Clears the field "TP_STATE".
     *
     * The field will be set to its default value. The hasTP_STATE()
     * method will return false.
     */
    inline void clearTP_STATE();

    /**
     * Checks whether the field "TP_STATE" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTP_STATE()). Otherwise it will return false.
     */
    inline bool hasTP_STATE () const;

    /**
     * Returns the value of the member "TP_STATE".
     *
     * 01: TP Station
     * 00: Non-Tp Station
     *
     * @return The value of the field "TP_STATE"
     */
    inline bool getTP_STATE () const;

    /**
     * Sets the value of the member "TP_STATE".
     *
     * 01: TP Station
     * 00: Non-Tp Station
     *
     * @param TP_STATE The value which will be set
     */
    inline void setTP_STATE (bool TP_STATE_);

    // API of field "TP_Source"

    static const int kTP_Source = 1;

    /**
     * Clears the field "TP_Source".
     *
     * The field will be set to its default value. The hasTP_Source()
     * method will return false.
     */
    inline void clearTP_Source();

    /**
     * Checks whether the field "TP_Source" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTP_Source()). Otherwise it will return false.
     */
    inline bool hasTP_Source () const;

    /**
     * Returns the value of the member "TP_Source".
     *
     * This parameter will tell, for which source given TP state belongs to.
     *
     * @return The value of the field "TP_Source"
     */
    inline ::tunermaster_main_fi_types::T_e8_Source getTP_Source () const;

    /**
     * Sets the value of the member "TP_Source".
     *
     * This parameter will tell, for which source given TP state belongs to.
     *
     * @param TP_Source The value which will be set
     */
    inline void setTP_Source (::tunermaster_main_fi_types::T_e8_Source TP_Source_);

    static const FID_TUNMSTR_G_TP_STATUSStatus &getDefaultInstance();

private:

    inline void set_has_TP_STATE ();

    inline void clear_has_TP_STATE ();

    inline void set_has_TP_Source ();

    inline void clear_has_TP_Source ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _TP_STATE;

    ::tunermaster_main_fi_types::T_e8_Source _TP_Source;

};

/**
 * The status message of the property "FID_TUNMSTR_G_SOURCE_CHANGE"
 * With this property fc_tunermaster will request HMI for soucre change, this inteface is not used as of now in G3g,
 * as source change request goes to Audio directly from HMI
 */
class FID_TUNMSTR_G_SOURCE_CHANGEStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUNMSTR_G_SOURCE_CHANGEStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUNMSTR_G_SOURCE_CHANGEStatus (const FID_TUNMSTR_G_SOURCE_CHANGEStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUNMSTR_G_SOURCE_CHANGEStatus (::tunermaster_main_fi_types::T_e8_Source Source_, ::tunermaster_main_fi_types::T_e8_Action Action_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUNMSTR_G_SOURCE_CHANGEStatus();

    /**
     * Assignment operator
     */
    inline FID_TUNMSTR_G_SOURCE_CHANGEStatus& operator = (const FID_TUNMSTR_G_SOURCE_CHANGEStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUNMSTR_G_SOURCE_CHANGEStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUNMSTR_G_SOURCE_CHANGEStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUNMSTR_G_SOURCE_CHANGEStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUNMSTR_G_SOURCE_CHANGEStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Source"

    static const int kSource = 0;

    /**
     * Clears the field "Source".
     *
     * The field will be set to its default value. The hasSource()
     * method will return false.
     */
    inline void clearSource();

    /**
     * Checks whether the field "Source" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSource()). Otherwise it will return false.
     */
    inline bool hasSource () const;

    /**
     * Returns the value of the member "Source".
     *
     * This parameter indicates on which source action indicated by "Action" parameter has been performed
     *
     * @return The value of the field "Source"
     */
    inline ::tunermaster_main_fi_types::T_e8_Source getSource () const;

    /**
     * Sets the value of the member "Source".
     *
     * This parameter indicates on which source action indicated by "Action" parameter has been performed
     *
     * @param Source The value which will be set
     */
    inline void setSource (::tunermaster_main_fi_types::T_e8_Source Source_);

    // API of field "Action"

    static const int kAction = 1;

    /**
     * Clears the field "Action".
     *
     * The field will be set to its default value. The hasAction()
     * method will return false.
     */
    inline void clearAction();

    /**
     * Checks whether the field "Action" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAction()). Otherwise it will return false.
     */
    inline bool hasAction () const;

    /**
     * Returns the value of the member "Action".
     *
     * This parameter indicates what action has been taken for the source mentioned under "Source" parameter
     *
     * @return The value of the field "Action"
     */
    inline ::tunermaster_main_fi_types::T_e8_Action getAction () const;

    /**
     * Sets the value of the member "Action".
     *
     * This parameter indicates what action has been taken for the source mentioned under "Source" parameter
     *
     * @param Action The value which will be set
     */
    inline void setAction (::tunermaster_main_fi_types::T_e8_Action Action_);

    static const FID_TUNMSTR_G_SOURCE_CHANGEStatus &getDefaultInstance();

private:

    inline void set_has_Source ();

    inline void clear_has_Source ();

    inline void set_has_Action ();

    inline void clear_has_Action ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::tunermaster_main_fi_types::T_e8_Source _Source;

    ::tunermaster_main_fi_types::T_e8_Action _Action;

};

/**
 * The status message of the property "FID_TUNMSTR_G_BAND_INFO"
 * With this property fc_tunermaster will inform to HMI about currrent active band
 */
class FID_TUNMSTR_G_BAND_INFOStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUNMSTR_G_BAND_INFOStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUNMSTR_G_BAND_INFOStatus (const FID_TUNMSTR_G_BAND_INFOStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUNMSTR_G_BAND_INFOStatus (::tunermaster_main_fi_types::T_e8_Band Band_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUNMSTR_G_BAND_INFOStatus();

    /**
     * Assignment operator
     */
    inline FID_TUNMSTR_G_BAND_INFOStatus& operator = (const FID_TUNMSTR_G_BAND_INFOStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUNMSTR_G_BAND_INFOStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUNMSTR_G_BAND_INFOStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUNMSTR_G_BAND_INFOStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUNMSTR_G_BAND_INFOStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Band"

    static const int kBand = 0;

    /**
     * Clears the field "Band".
     *
     * The field will be set to its default value. The hasBand()
     * method will return false.
     */
    inline void clearBand();

    /**
     * Checks whether the field "Band" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBand()). Otherwise it will return false.
     */
    inline bool hasBand () const;

    /**
     * Returns the value of the member "Band".
     *
     * Indicates current active band
     *
     * @return The value of the field "Band"
     */
    inline ::tunermaster_main_fi_types::T_e8_Band getBand () const;

    /**
     * Sets the value of the member "Band".
     *
     * Indicates current active band
     *
     * @param Band The value which will be set
     */
    inline void setBand (::tunermaster_main_fi_types::T_e8_Band Band_);

    static const FID_TUNMSTR_G_BAND_INFOStatus &getDefaultInstance();

private:

    inline void set_has_Band ();

    inline void clear_has_Band ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tunermaster_main_fi_types::T_e8_Band _Band;

};

/**
 * The status message of the property "FID_TUNMSTR_G_RF_ANTENNA_TEST"
 * Status response to MethodStart FID_TUNMSTR_S_RF_ANTENNA_TEST.
 */
class FID_TUNMSTR_G_RF_ANTENNA_TESTStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUNMSTR_G_RF_ANTENNA_TESTStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUNMSTR_G_RF_ANTENNA_TESTStatus (const FID_TUNMSTR_G_RF_ANTENNA_TESTStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUNMSTR_G_RF_ANTENNA_TESTStatus (const ::tunermaster_main_fi_types::Tunmstr_RFAntenna& Tunmstr_RF_Antenna_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUNMSTR_G_RF_ANTENNA_TESTStatus();

    /**
     * Assignment operator
     */
    inline FID_TUNMSTR_G_RF_ANTENNA_TESTStatus& operator = (const FID_TUNMSTR_G_RF_ANTENNA_TESTStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUNMSTR_G_RF_ANTENNA_TESTStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUNMSTR_G_RF_ANTENNA_TESTStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUNMSTR_G_RF_ANTENNA_TESTStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUNMSTR_G_RF_ANTENNA_TESTStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Tunmstr_RF_Antenna"

    static const int kTunmstr_RF_Antenna = 0;

    /**
     * Clears the field "Tunmstr_RF_Antenna".
     *
     * The field will be set to its default value. The hasTunmstr_RF_Antenna()
     * method will return false.
     */
    inline void clearTunmstr_RF_Antenna();

    /**
     * Checks whether the field "Tunmstr_RF_Antenna" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunmstr_RF_Antenna()). Otherwise it will return false.
     */
    inline bool hasTunmstr_RF_Antenna () const;

    /**
     * Returns the value of the member "Tunmstr_RF_Antenna".
     *
     * Status response will contain the RF Antenna test result.
     *
     * @return The value of the field "Tunmstr_RF_Antenna"
     */
    inline const ::tunermaster_main_fi_types::Tunmstr_RFAntenna& getTunmstr_RF_Antenna () const;

    /**
     * Retrieves the value of the field "Tunmstr_RF_Antenna" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Tunmstr_RF_Antenna".
     */
    inline ::tunermaster_main_fi_types::Tunmstr_RFAntenna& getTunmstr_RF_AntennaMutable ();

    /**
     * Sets the value of the member "Tunmstr_RF_Antenna".
     *
     * Status response will contain the RF Antenna test result.
     *
     * @param Tunmstr_RF_Antenna The value which will be set
     */
    inline void setTunmstr_RF_Antenna (const ::tunermaster_main_fi_types::Tunmstr_RFAntenna& Tunmstr_RF_Antenna_);

    static const FID_TUNMSTR_G_RF_ANTENNA_TESTStatus &getDefaultInstance();

private:

    inline void set_has_Tunmstr_RF_Antenna ();

    inline void clear_has_Tunmstr_RF_Antenna ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tunermaster_main_fi_types::Tunmstr_RFAntenna _Tunmstr_RF_Antenna;

};

/**
 * The status message of the property "FID_TUNMSTR_G_PRESET_LIST"
 * Gives Preset list details .
 */
class FID_TUNMSTR_G_PRESET_LISTStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUNMSTR_G_PRESET_LISTStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUNMSTR_G_PRESET_LISTStatus (const FID_TUNMSTR_G_PRESET_LISTStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUNMSTR_G_PRESET_LISTStatus (const ::std::vector< ::tunermaster_main_fi_types::T_PresetList >& ListOfStations_, ::tunermaster_main_fi_types::T_e8_List List_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUNMSTR_G_PRESET_LISTStatus();

    /**
     * Assignment operator
     */
    inline FID_TUNMSTR_G_PRESET_LISTStatus& operator = (const FID_TUNMSTR_G_PRESET_LISTStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUNMSTR_G_PRESET_LISTStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUNMSTR_G_PRESET_LISTStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUNMSTR_G_PRESET_LISTStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUNMSTR_G_PRESET_LISTStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ListOfStations"

    static const int kListOfStations = 0;

    /**
     * Clears the field "ListOfStations".
     *
     * The field will be set to its default value. The hasListOfStations()
     * method will return false.
     */
    inline void clearListOfStations();

    /**
     * Checks whether the field "ListOfStations" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListOfStations()). Otherwise it will return false.
     */
    inline bool hasListOfStations () const;

    /**
     * Returns the value of the member "ListOfStations".
     *
     * List of presets .
     *
     * @return The value of the field "ListOfStations"
     */
    inline const ::std::vector< ::tunermaster_main_fi_types::T_PresetList >& getListOfStations () const;

    /**
     * Retrieves the value of the field "ListOfStations" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ListOfStations".
     */
    inline ::std::vector< ::tunermaster_main_fi_types::T_PresetList >& getListOfStationsMutable ();

    /**
     * Sets the value of the member "ListOfStations".
     *
     * List of presets .
     *
     * @param ListOfStations The value which will be set
     */
    inline void setListOfStations (const ::std::vector< ::tunermaster_main_fi_types::T_PresetList >& ListOfStations_);

    // API of field "List"

    static const int kList = 1;

    /**
     * Clears the field "List".
     *
     * The field will be set to its default value. The hasList()
     * method will return false.
     */
    inline void clearList();

    /**
     * Checks whether the field "List" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setList()). Otherwise it will return false.
     */
    inline bool hasList () const;

    /**
     * Returns the value of the member "List".
     *
     * This parameter indicates to which list, Preset element belong to
     *
     * @return The value of the field "List"
     */
    inline ::tunermaster_main_fi_types::T_e8_List getList () const;

    /**
     * Sets the value of the member "List".
     *
     * This parameter indicates to which list, Preset element belong to
     *
     * @param List The value which will be set
     */
    inline void setList (::tunermaster_main_fi_types::T_e8_List List_);

    static const FID_TUNMSTR_G_PRESET_LISTStatus &getDefaultInstance();

private:

    static const ::std::vector< ::tunermaster_main_fi_types::T_PresetList >& getT_PresetListList_DefaultInstance ();

    inline void set_has_ListOfStations ();

    inline void clear_has_ListOfStations ();

    inline void set_has_List ();

    inline void clear_has_List ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::vector< ::tunermaster_main_fi_types::T_PresetList > _ListOfStations;

    ::tunermaster_main_fi_types::T_e8_List _List;

};

/**
 * The status message of the property "FID_TUNMSTR_G_ANNO_BUTTON_STATUS"
 * This property informs about Announcement button status
 */
class FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus (const FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus (const ::tunermaster_main_fi_types::T_b32_AnnoType& b32AnnouncementType_, ::tunermaster_main_fi_types::T_e8_Source Source_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus();

    /**
     * Assignment operator
     */
    inline FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus& operator = (const FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "b32AnnouncementType"

    static const int kB32AnnouncementType = 0;

    /**
     * Clears the field "b32AnnouncementType".
     *
     * The field will be set to its default value. The hasB32AnnouncementType()
     * method will return false.
     */
    inline void clearB32AnnouncementType();

    /**
     * Checks whether the field "b32AnnouncementType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setB32AnnouncementType()). Otherwise it will return false.
     */
    inline bool hasB32AnnouncementType () const;

    /**
     * Returns the value of the member "b32AnnouncementType".
     *
     * This parameter indicates the types of Announcements enabled.
     *
     * @return The value of the field "b32AnnouncementType"
     */
    inline const ::tunermaster_main_fi_types::T_b32_AnnoType& getB32AnnouncementType () const;

    /**
     * Retrieves the value of the field "b32AnnouncementType" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "b32AnnouncementType".
     */
    inline ::tunermaster_main_fi_types::T_b32_AnnoType& getB32AnnouncementTypeMutable ();

    /**
     * Sets the value of the member "b32AnnouncementType".
     *
     * This parameter indicates the types of Announcements enabled.
     *
     * @param b32AnnouncementType The value which will be set
     */
    inline void setB32AnnouncementType (const ::tunermaster_main_fi_types::T_b32_AnnoType& b32AnnouncementType_);

    // API of field "Source"

    static const int kSource = 1;

    /**
     * Clears the field "Source".
     *
     * The field will be set to its default value. The hasSource()
     * method will return false.
     */
    inline void clearSource();

    /**
     * Checks whether the field "Source" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSource()). Otherwise it will return false.
     */
    inline bool hasSource () const;

    /**
     * Returns the value of the member "Source".
     *
     * This parameter will tells for which source given Announcement type belongs to.
     *
     * @return The value of the field "Source"
     */
    inline ::tunermaster_main_fi_types::T_e8_Source getSource () const;

    /**
     * Sets the value of the member "Source".
     *
     * This parameter will tells for which source given Announcement type belongs to.
     *
     * @param Source The value which will be set
     */
    inline void setSource (::tunermaster_main_fi_types::T_e8_Source Source_);

    static const FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus &getDefaultInstance();

private:

    inline void set_has_b32AnnouncementType ();

    inline void clear_has_b32AnnouncementType ();

    inline void set_has_Source ();

    inline void clear_has_Source ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::tunermaster_main_fi_types::T_b32_AnnoType _b32AnnouncementType;

    ::tunermaster_main_fi_types::T_e8_Source _Source;

};

/**
 * The status message of the property "FID_TUNMSTR_G_ANNOUNCEMENT_STATUS"
 * This property will udpate HMI about current active announcemnt source. HMI can use this infomation to display Announcement pop up
 */
class FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus (const FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus (bool Anno_Status_, ::tunermaster_main_fi_types::T_e8_Source Source_, ::tunermaster_main_fi_types::T_e8_AnnoTypes Anno_Types_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus();

    /**
     * Assignment operator
     */
    inline FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus& operator = (const FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Anno_Status"

    static const int kAnno_Status = 0;

    /**
     * Clears the field "Anno_Status".
     *
     * The field will be set to its default value. The hasAnno_Status()
     * method will return false.
     */
    inline void clearAnno_Status();

    /**
     * Checks whether the field "Anno_Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAnno_Status()). Otherwise it will return false.
     */
    inline bool hasAnno_Status () const;

    /**
     * Returns the value of the member "Anno_Status".
     *
     * 01: Announcement is Active
     * 00: Announcement is not active
     *
     * @return The value of the field "Anno_Status"
     */
    inline bool getAnno_Status () const;

    /**
     * Sets the value of the member "Anno_Status".
     *
     * 01: Announcement is Active
     * 00: Announcement is not active
     *
     * @param Anno_Status The value which will be set
     */
    inline void setAnno_Status (bool Anno_Status_);

    // API of field "Source"

    static const int kSource = 1;

    /**
     * Clears the field "Source".
     *
     * The field will be set to its default value. The hasSource()
     * method will return false.
     */
    inline void clearSource();

    /**
     * Checks whether the field "Source" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSource()). Otherwise it will return false.
     */
    inline bool hasSource () const;

    /**
     * Returns the value of the member "Source".
     *
     * This parameter indicates for which source Announcement is active
     *
     * @return The value of the field "Source"
     */
    inline ::tunermaster_main_fi_types::T_e8_Source getSource () const;

    /**
     * Sets the value of the member "Source".
     *
     * This parameter indicates for which source Announcement is active
     *
     * @param Source The value which will be set
     */
    inline void setSource (::tunermaster_main_fi_types::T_e8_Source Source_);

    // API of field "Anno_Types"

    static const int kAnno_Types = 2;

    /**
     * Clears the field "Anno_Types".
     *
     * The field will be set to its default value. The hasAnno_Types()
     * method will return false.
     */
    inline void clearAnno_Types();

    /**
     * Checks whether the field "Anno_Types" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAnno_Types()). Otherwise it will return false.
     */
    inline bool hasAnno_Types () const;

    /**
     * Returns the value of the member "Anno_Types".
     *
     * This parameter will indicate for which Announcement type status is being sent.
     *
     * @return The value of the field "Anno_Types"
     */
    inline ::tunermaster_main_fi_types::T_e8_AnnoTypes getAnno_Types () const;

    /**
     * Sets the value of the member "Anno_Types".
     *
     * This parameter will indicate for which Announcement type status is being sent.
     *
     * @param Anno_Types The value which will be set
     */
    inline void setAnno_Types (::tunermaster_main_fi_types::T_e8_AnnoTypes Anno_Types_);

    static const FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus &getDefaultInstance();

private:

    inline void set_has_Anno_Status ();

    inline void clear_has_Anno_Status ();

    inline void set_has_Source ();

    inline void clear_has_Source ();

    inline void set_has_Anno_Types ();

    inline void clear_has_Anno_Types ();

    uint32 _has_bits_[ (3 + 31) / 32];

    bool _Anno_Status;

    ::tunermaster_main_fi_types::T_e8_Source _Source;

    ::tunermaster_main_fi_types::T_e8_AnnoTypes _Anno_Types;

};

/**
 * The status message of the property "FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITY"
 * With this property fc_tunermaster will inform to HMI about tuner domain availability.
 */
class FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus (const FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus (::tunermaster_main_fi_types::T_e8_TunerAvailability TunerAvailability_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus();

    /**
     * Assignment operator
     */
    inline FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus& operator = (const FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerAvailability"

    static const int kTunerAvailability = 0;

    /**
     * Clears the field "TunerAvailability".
     *
     * The field will be set to its default value. The hasTunerAvailability()
     * method will return false.
     */
    inline void clearTunerAvailability();

    /**
     * Checks whether the field "TunerAvailability" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerAvailability()). Otherwise it will return false.
     */
    inline bool hasTunerAvailability () const;

    /**
     * Returns the value of the member "TunerAvailability".
     *
     * Gives the information about the tuner domain availability status.
     *
     * @return The value of the field "TunerAvailability"
     */
    inline ::tunermaster_main_fi_types::T_e8_TunerAvailability getTunerAvailability () const;

    /**
     * Sets the value of the member "TunerAvailability".
     *
     * Gives the information about the tuner domain availability status.
     *
     * @param TunerAvailability The value which will be set
     */
    inline void setTunerAvailability (::tunermaster_main_fi_types::T_e8_TunerAvailability TunerAvailability_);

    static const FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus &getDefaultInstance();

private:

    inline void set_has_TunerAvailability ();

    inline void clear_has_TunerAvailability ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tunermaster_main_fi_types::T_e8_TunerAvailability _TunerAvailability;

};

/**
 * The status message of the property "FID_TUNMSTR_G_GET_AUTOSTORE_STATUS"
 * With this property, fc_tunermaster will inform autostore status.
 */
class FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus (const FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus (bool Autostore_State_, ::tunermaster_main_fi_types::T_e8_AST_Types AST_Type_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus();

    /**
     * Assignment operator
     */
    inline FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus& operator = (const FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Autostore_State"

    static const int kAutostore_State = 0;

    /**
     * Clears the field "Autostore_State".
     *
     * The field will be set to its default value. The hasAutostore_State()
     * method will return false.
     */
    inline void clearAutostore_State();

    /**
     * Checks whether the field "Autostore_State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAutostore_State()). Otherwise it will return false.
     */
    inline bool hasAutostore_State () const;

    /**
     * Returns the value of the member "Autostore_State".
     *
     * indicates whether autostore is currently active(1) or not active (0)
     *
     * @return The value of the field "Autostore_State"
     */
    inline bool getAutostore_State () const;

    /**
     * Sets the value of the member "Autostore_State".
     *
     * indicates whether autostore is currently active(1) or not active (0)
     *
     * @param Autostore_State The value which will be set
     */
    inline void setAutostore_State (bool Autostore_State_);

    // API of field "AST_Type"

    static const int kAST_Type = 1;

    /**
     * Clears the field "AST_Type".
     *
     * The field will be set to its default value. The hasAST_Type()
     * method will return false.
     */
    inline void clearAST_Type();

    /**
     * Checks whether the field "AST_Type" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAST_Type()). Otherwise it will return false.
     */
    inline bool hasAST_Type () const;

    /**
     * Returns the value of the member "AST_Type".
     *
     * indicates which type of autostore it is (Normal/Initial)
     *
     * @return The value of the field "AST_Type"
     */
    inline ::tunermaster_main_fi_types::T_e8_AST_Types getAST_Type () const;

    /**
     * Sets the value of the member "AST_Type".
     *
     * indicates which type of autostore it is (Normal/Initial)
     *
     * @param AST_Type The value which will be set
     */
    inline void setAST_Type (::tunermaster_main_fi_types::T_e8_AST_Types AST_Type_);

    static const FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus &getDefaultInstance();

private:

    inline void set_has_Autostore_State ();

    inline void clear_has_Autostore_State ();

    inline void set_has_AST_Type ();

    inline void clear_has_AST_Type ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _Autostore_State;

    ::tunermaster_main_fi_types::T_e8_AST_Types _AST_Type;

};

/**
 * The status message of the property "FID_TUNMSTR_G_MTC_SETMODE_STATUS"
 * This property sets the service linking in the mode set by FID_DAB_S_SERVICE_LINKING_SETMODE.
 */
class FID_TUNMSTR_G_MTC_SETMODE_STATUSStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUNMSTR_G_MTC_SETMODE_STATUSStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUNMSTR_G_MTC_SETMODE_STATUSStatus (const FID_TUNMSTR_G_MTC_SETMODE_STATUSStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUNMSTR_G_MTC_SETMODE_STATUSStatus (const ::tunermaster_main_fi_types::T_b8_ModeType& Mode_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUNMSTR_G_MTC_SETMODE_STATUSStatus();

    /**
     * Assignment operator
     */
    inline FID_TUNMSTR_G_MTC_SETMODE_STATUSStatus& operator = (const FID_TUNMSTR_G_MTC_SETMODE_STATUSStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUNMSTR_G_MTC_SETMODE_STATUSStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUNMSTR_G_MTC_SETMODE_STATUSStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUNMSTR_G_MTC_SETMODE_STATUSStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUNMSTR_G_MTC_SETMODE_STATUSStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Mode"

    static const int kMode = 0;

    /**
     * Clears the field "Mode".
     *
     * The field will be set to its default value. The hasMode()
     * method will return false.
     */
    inline void clearMode();

    /**
     * Checks whether the field "Mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMode()). Otherwise it will return false.
     */
    inline bool hasMode () const;

    /**
     * Returns the value of the member "Mode".
     *
     * Mode for service linking.
     *
     * @return The value of the field "Mode"
     */
    inline const ::tunermaster_main_fi_types::T_b8_ModeType& getMode () const;

    /**
     * Retrieves the value of the field "Mode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Mode".
     */
    inline ::tunermaster_main_fi_types::T_b8_ModeType& getModeMutable ();

    /**
     * Sets the value of the member "Mode".
     *
     * Mode for service linking.
     *
     * @param Mode The value which will be set
     */
    inline void setMode (const ::tunermaster_main_fi_types::T_b8_ModeType& Mode_);

    static const FID_TUNMSTR_G_MTC_SETMODE_STATUSStatus &getDefaultInstance();

private:

    inline void set_has_Mode ();

    inline void clear_has_Mode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tunermaster_main_fi_types::T_b8_ModeType _Mode;

};

/**
 * The status message of the property "FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUS"
 * This property gives infomation of survellance active station
 */
class FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus (const FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus (::tunermaster_main_fi_types::T_e8_StationType StationType_, uint32 Frequency_, uint32 Station_ID_, const ::std::string& StationNameFM_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus();

    /**
     * Assignment operator
     */
    inline FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus& operator = (const FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "StationType"

    static const int kStationType = 0;

    /**
     * Clears the field "StationType".
     *
     * The field will be set to its default value. The hasStationType()
     * method will return false.
     */
    inline void clearStationType();

    /**
     * Checks whether the field "StationType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStationType()). Otherwise it will return false.
     */
    inline bool hasStationType () const;

    /**
     * Returns the value of the member "StationType".
     *
     * Gives hint of type of station being played.
     *
     * @return The value of the field "StationType"
     */
    inline ::tunermaster_main_fi_types::T_e8_StationType getStationType () const;

    /**
     * Sets the value of the member "StationType".
     *
     * Gives hint of type of station being played.
     *
     * @param StationType The value which will be set
     */
    inline void setStationType (::tunermaster_main_fi_types::T_e8_StationType StationType_);

    // API of field "Frequency"

    static const int kFrequency = 1;

    /**
     * Clears the field "Frequency".
     *
     * The field will be set to its default value. The hasFrequency()
     * method will return false.
     */
    inline void clearFrequency();

    /**
     * Checks whether the field "Frequency" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFrequency()). Otherwise it will return false.
     */
    inline bool hasFrequency () const;

    /**
     * Returns the value of the member "Frequency".
     *
     * Frequency value of active station
     *
     * @return The value of the field "Frequency"
     */
    inline uint32 getFrequency () const;

    /**
     * Sets the value of the member "Frequency".
     *
     * Frequency value of active station
     *
     * @param Frequency The value which will be set
     */
    inline void setFrequency (uint32 Frequency_);

    // API of field "Station_ID"

    static const int kStation_ID = 2;

    /**
     * Clears the field "Station_ID".
     *
     * The field will be set to its default value. The hasStation_ID()
     * method will return false.
     */
    inline void clearStation_ID();

    /**
     * Checks whether the field "Station_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStation_ID()). Otherwise it will return false.
     */
    inline bool hasStation_ID () const;

    /**
     * Returns the value of the member "Station_ID".
     *
     * Station ID of active station
     *
     * @return The value of the field "Station_ID"
     */
    inline uint32 getStation_ID () const;

    /**
     * Sets the value of the member "Station_ID".
     *
     * Station ID of active station
     *
     * @param Station_ID The value which will be set
     */
    inline void setStation_ID (uint32 Station_ID_);

    // API of field "StationNameFM"

    static const int kStationNameFM = 3;

    /**
     * Clears the field "StationNameFM".
     *
     * The field will be set to its default value. The hasStationNameFM()
     * method will return false.
     */
    inline void clearStationNameFM();

    /**
     * Checks whether the field "StationNameFM" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStationNameFM()). Otherwise it will return false.
     */
    inline bool hasStationNameFM () const;

    /**
     * Returns the value of the member "StationNameFM".
     *
     * Station ID of active station
     *
     * @return The value of the field "StationNameFM"
     */
    inline const ::std::string& getStationNameFM () const;

    /**
     * Retrieves the value of the field "StationNameFM" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "StationNameFM".
     */
    inline ::std::string& getStationNameFMMutable ();

    /**
     * Sets the value of the member "StationNameFM".
     *
     * Station ID of active station
     *
     * @param StationNameFM The value which will be set
     */
    inline void setStationNameFM (const ::std::string& StationNameFM_);

    /**
     * Sets the value of the member "StationNameFM".
     *
     * Station ID of active station
     *
     * @param StationNameFM The value which will be set
     */
    inline void setStationNameFM (const char* StationNameFM_);

    /**
     * Sets the value of the member "StationNameFM".
     *
     * Station ID of active station
     *
     * @param StationNameFM The value which will be set
     */
    inline void setStationNameFM (const char* value, size_t size);

    static const FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus &getDefaultInstance();

private:

    inline void set_has_StationType ();

    inline void clear_has_StationType ();

    inline void set_has_Frequency ();

    inline void clear_has_Frequency ();

    inline void set_has_Station_ID ();

    inline void clear_has_Station_ID ();

    inline void set_has_StationNameFM ();

    inline void clear_has_StationNameFM ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::tunermaster_main_fi_types::T_e8_StationType _StationType;

    uint32 _Frequency;

    uint32 _Station_ID;

    ::std::string _StationNameFM;

};

/**
 * The status message of the property "FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITY"
 * This property gives infomation about the Tuner source availability, currently supports only for AM source in A-IVI project
 */
class FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus (const FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus (::tunermaster_main_fi_types::T_e8_Source Source_, bool Available_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus();

    /**
     * Assignment operator
     */
    inline FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus& operator = (const FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Source"

    static const int kSource = 0;

    /**
     * Clears the field "Source".
     *
     * The field will be set to its default value. The hasSource()
     * method will return false.
     */
    inline void clearSource();

    /**
     * Checks whether the field "Source" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSource()). Otherwise it will return false.
     */
    inline bool hasSource () const;

    /**
     * Returns the value of the member "Source".
     *
     * If the meaning of "Source" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Source"
     */
    inline ::tunermaster_main_fi_types::T_e8_Source getSource () const;

    /**
     * Sets the value of the member "Source".
     *
     * If the meaning of "Source" isn't clear, then there should be a description here.
     *
     * @param Source The value which will be set
     */
    inline void setSource (::tunermaster_main_fi_types::T_e8_Source Source_);

    // API of field "Available"

    static const int kAvailable = 1;

    /**
     * Clears the field "Available".
     *
     * The field will be set to its default value. The hasAvailable()
     * method will return false.
     */
    inline void clearAvailable();

    /**
     * Checks whether the field "Available" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAvailable()). Otherwise it will return false.
     */
    inline bool hasAvailable () const;

    /**
     * Returns the value of the member "Available".
     *
     * If the meaning of "Available" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Available"
     */
    inline bool getAvailable () const;

    /**
     * Sets the value of the member "Available".
     *
     * If the meaning of "Available" isn't clear, then there should be a description here.
     *
     * @param Available The value which will be set
     */
    inline void setAvailable (bool Available_);

    static const FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus &getDefaultInstance();

private:

    inline void set_has_Source ();

    inline void clear_has_Source ();

    inline void set_has_Available ();

    inline void clear_has_Available ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::tunermaster_main_fi_types::T_e8_Source _Source;

    bool _Available;

};

/**
 * The status message of the property "FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATION"
 * This property informs about a change in radio profile settings data for current user
 */
class FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus (const FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus (const ::tunermaster_main_fi_types::T_b8_RadioProfileSettingAction& RadioProfileSettingAction_, const ::std::vector< uint8 >& PresetIndexList_, bool AMSwitch_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus();

    /**
     * Assignment operator
     */
    inline FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus& operator = (const FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RadioProfileSettingAction"

    static const int kRadioProfileSettingAction = 0;

    /**
     * Clears the field "RadioProfileSettingAction".
     *
     * The field will be set to its default value. The hasRadioProfileSettingAction()
     * method will return false.
     */
    inline void clearRadioProfileSettingAction();

    /**
     * Checks whether the field "RadioProfileSettingAction" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRadioProfileSettingAction()). Otherwise it will return false.
     */
    inline bool hasRadioProfileSettingAction () const;

    /**
     * Returns the value of the member "RadioProfileSettingAction".
     *
     * Parameters that are notified 01-Only Presets 02-Only AM switch 03- Both Presets and AM Switch.
     *
     * @return The value of the field "RadioProfileSettingAction"
     */
    inline const ::tunermaster_main_fi_types::T_b8_RadioProfileSettingAction& getRadioProfileSettingAction () const;

    /**
     * Retrieves the value of the field "RadioProfileSettingAction" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RadioProfileSettingAction".
     */
    inline ::tunermaster_main_fi_types::T_b8_RadioProfileSettingAction& getRadioProfileSettingActionMutable ();

    /**
     * Sets the value of the member "RadioProfileSettingAction".
     *
     * Parameters that are notified 01-Only Presets 02-Only AM switch 03- Both Presets and AM Switch.
     *
     * @param RadioProfileSettingAction The value which will be set
     */
    inline void setRadioProfileSettingAction (const ::tunermaster_main_fi_types::T_b8_RadioProfileSettingAction& RadioProfileSettingAction_);

    // API of field "PresetIndexList"

    static const int kPresetIndexList = 1;

    /**
     * Clears the field "PresetIndexList".
     *
     * The field will be set to its default value. The hasPresetIndexList()
     * method will return false.
     */
    inline void clearPresetIndexList();

    /**
     * Checks whether the field "PresetIndexList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPresetIndexList()). Otherwise it will return false.
     */
    inline bool hasPresetIndexList () const;

    /**
     * Returns the value of the member "PresetIndexList".
     *
     * List of preset elements that are to be notified
     *
     * @return The value of the field "PresetIndexList"
     */
    inline const ::std::vector< uint8 >& getPresetIndexList () const;

    /**
     * Retrieves the value of the field "PresetIndexList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PresetIndexList".
     */
    inline ::std::vector< uint8 >& getPresetIndexListMutable ();

    /**
     * Sets the value of the member "PresetIndexList".
     *
     * List of preset elements that are to be notified
     *
     * @param PresetIndexList The value which will be set
     */
    inline void setPresetIndexList (const ::std::vector< uint8 >& PresetIndexList_);

    // API of field "AMSwitch"

    static const int kAMSwitch = 2;

    /**
     * Clears the field "AMSwitch".
     *
     * The field will be set to its default value. The hasAMSwitch()
     * method will return false.
     */
    inline void clearAMSwitch();

    /**
     * Checks whether the field "AMSwitch" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAMSwitch()). Otherwise it will return false.
     */
    inline bool hasAMSwitch () const;

    /**
     * Returns the value of the member "AMSwitch".
     *
     * Indicates AM Switch status ON or OFF
     *
     * @return The value of the field "AMSwitch"
     */
    inline bool getAMSwitch () const;

    /**
     * Sets the value of the member "AMSwitch".
     *
     * Indicates AM Switch status ON or OFF
     *
     * @param AMSwitch The value which will be set
     */
    inline void setAMSwitch (bool AMSwitch_);

    static const FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_RadioProfileSettingAction ();

    inline void clear_has_RadioProfileSettingAction ();

    inline void set_has_PresetIndexList ();

    inline void clear_has_PresetIndexList ();

    inline void set_has_AMSwitch ();

    inline void clear_has_AMSwitch ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::tunermaster_main_fi_types::T_b8_RadioProfileSettingAction _RadioProfileSettingAction;

    ::std::vector< uint8 > _PresetIndexList;

    bool _AMSwitch;

};

/**
 * The error message of 'FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATION'
 */
class FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure ();

    /**
     * Copy constructor
     */
    inline  FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure (const FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure (::tunermaster_main_fi_types::T_e8_TunerErrorType ErrorType_);

    /**
     * Destructor
     */
    inline  ~FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure();

    /**
     * Assignment operator
     */
    inline FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure& operator = (const FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorType"

    static const int kErrorType = 0;

    /**
     * Clears the field "ErrorType".
     *
     * The field will be set to its default value. The hasErrorType()
     * method will return false.
     */
    inline void clearErrorType();

    /**
     * Checks whether the field "ErrorType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorType()). Otherwise it will return false.
     */
    inline bool hasErrorType () const;

    /**
     * Returns the value of the member "ErrorType".
     *
     *
     *
     * @return The value of the field "ErrorType"
     */
    inline ::tunermaster_main_fi_types::T_e8_TunerErrorType getErrorType () const;

    /**
     * Sets the value of the member "ErrorType".
     *
     *
     *
     * @param ErrorType The value which will be set
     */
    inline void setErrorType (::tunermaster_main_fi_types::T_e8_TunerErrorType ErrorType_);

    static const FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorType ();

    inline void clear_has_ErrorType ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tunermaster_main_fi_types::T_e8_TunerErrorType _ErrorType;

};

/**
 * The error message of 'FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATION'
 */
class FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError  : public ::asf::core::Payload {
public:

    enum FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError ();

   /**
     * Copy constructor
     */
    inline  FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError (const FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError();

    /**
     * Assigns a new value to this object.
     */
    inline FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError& operator = (const FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError::FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorField getField () const;

    inline void setField(FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError::FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError &getDefaultInstance();

private:

    inline void cloneData (const FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError& rhs);

    inline void deleteData ();

    FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorField __field;

    union {
        FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "FID_TUNMSTR_G_PRESET_CHANNEL_UPDATE"
 * Notify change in one of the Preset channels. To be used only by SXM client
 * Response message:Return Preset channel change data
 */
class FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus ();

    /**
     * Copy constructor
     */
    inline  FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus (const FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus (uint32 PresetIndex_, uint32 PresetBand_, const ::tunermaster_main_fi_types::T_PresetListEntry& ChannelInfo_, uint32 LinearPresetIndex_);

    /**
     * Destructor
     */
    inline virtual  ~FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus();

    /**
     * Assignment operator
     */
    inline FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus& operator = (const FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PresetIndex"

    static const int kPresetIndex = 0;

    /**
     * Clears the field "PresetIndex".
     *
     * The field will be set to its default value. The hasPresetIndex()
     * method will return false.
     */
    inline void clearPresetIndex();

    /**
     * Checks whether the field "PresetIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPresetIndex()). Otherwise it will return false.
     */
    inline bool hasPresetIndex () const;

    /**
     * Returns the value of the member "PresetIndex".
     *
     * The Preset index to which the changed channel belongs to.
     *
     * @return The value of the field "PresetIndex"
     */
    inline uint32 getPresetIndex () const;

    /**
     * Sets the value of the member "PresetIndex".
     *
     * The Preset index to which the changed channel belongs to.
     *
     * @param PresetIndex The value which will be set
     */
    inline void setPresetIndex (uint32 PresetIndex_);

    // API of field "PresetBand"

    static const int kPresetBand = 1;

    /**
     * Clears the field "PresetBand".
     *
     * The field will be set to its default value. The hasPresetBand()
     * method will return false.
     */
    inline void clearPresetBand();

    /**
     * Checks whether the field "PresetBand" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPresetBand()). Otherwise it will return false.
     */
    inline bool hasPresetBand () const;

    /**
     * Returns the value of the member "PresetBand".
     *
     * The Preset Band Number of the channel for which change is reported.
     *
     * @return The value of the field "PresetBand"
     */
    inline uint32 getPresetBand () const;

    /**
     * Sets the value of the member "PresetBand".
     *
     * The Preset Band Number of the channel for which change is reported.
     *
     * @param PresetBand The value which will be set
     */
    inline void setPresetBand (uint32 PresetBand_);

    // API of field "ChannelInfo"

    static const int kChannelInfo = 2;

    /**
     * Clears the field "ChannelInfo".
     *
     * The field will be set to its default value. The hasChannelInfo()
     * method will return false.
     */
    inline void clearChannelInfo();

    /**
     * Checks whether the field "ChannelInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelInfo()). Otherwise it will return false.
     */
    inline bool hasChannelInfo () const;

    /**
     * Returns the value of the member "ChannelInfo".
     *
     * Information of preset channel that's changed
     *
     * @return The value of the field "ChannelInfo"
     */
    inline const ::tunermaster_main_fi_types::T_PresetListEntry& getChannelInfo () const;

    /**
     * Retrieves the value of the field "ChannelInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ChannelInfo".
     */
    inline ::tunermaster_main_fi_types::T_PresetListEntry& getChannelInfoMutable ();

    /**
     * Sets the value of the member "ChannelInfo".
     *
     * Information of preset channel that's changed
     *
     * @param ChannelInfo The value which will be set
     */
    inline void setChannelInfo (const ::tunermaster_main_fi_types::T_PresetListEntry& ChannelInfo_);

    // API of field "LinearPresetIndex"

    static const int kLinearPresetIndex = 3;

    /**
     * Clears the field "LinearPresetIndex".
     *
     * The field will be set to its default value. The hasLinearPresetIndex()
     * method will return false.
     */
    inline void clearLinearPresetIndex();

    /**
     * Checks whether the field "LinearPresetIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLinearPresetIndex()). Otherwise it will return false.
     */
    inline bool hasLinearPresetIndex () const;

    /**
     * Returns the value of the member "LinearPresetIndex".
     *
     * Linear index of preset channel.
     * <p>(PresetBand * Max No of channels in Band) + PresetIndex</p>
     *
     * @return The value of the field "LinearPresetIndex"
     */
    inline uint32 getLinearPresetIndex () const;

    /**
     * Sets the value of the member "LinearPresetIndex".
     *
     * Linear index of preset channel.
     * <p>(PresetBand * Max No of channels in Band) + PresetIndex</p>
     *
     * @param LinearPresetIndex The value which will be set
     */
    inline void setLinearPresetIndex (uint32 LinearPresetIndex_);

    static const FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus &getDefaultInstance();

private:

    inline void set_has_PresetIndex ();

    inline void clear_has_PresetIndex ();

    inline void set_has_PresetBand ();

    inline void clear_has_PresetBand ();

    inline void set_has_ChannelInfo ();

    inline void clear_has_ChannelInfo ();

    inline void set_has_LinearPresetIndex ();

    inline void clear_has_LinearPresetIndex ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _PresetIndex;

    uint32 _PresetBand;

    ::tunermaster_main_fi_types::T_PresetListEntry _ChannelInfo;

    uint32 _LinearPresetIndex;

};

inline  FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart::FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart ()  :
    _b32Anno_Types (),
    _Source ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart::FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart (const FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart &rhs)  :
    ::asf::core::Payload(rhs),
    _b32Anno_Types (),
    _Source ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart::FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart (const ::tunermaster_main_fi_types::T_b32_AnnoType& b32Anno_Types_, const ::tunermaster_main_fi_types::T_b8_SourceAnno& Source_)  :
    _b32Anno_Types (b32Anno_Types_),
    _Source (Source_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart::~FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart() {
}

inline FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart& FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart::operator = (const FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasB32Anno_Types()) {
            setB32Anno_Types(rhs.getB32Anno_Types());
        } else {
            clearB32Anno_Types();
        }
        if (rhs.hasSource()) {
            setSource(rhs.getSource());
        } else {
            clearSource();
        }
    }
    return *this;
}

inline bool FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart::operator == (const FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart& rhs) const {
    return (((!hasB32Anno_Types() && !rhs.hasB32Anno_Types()) || getB32Anno_Types() == rhs.getB32Anno_Types()) &&
        ((!hasSource() && !rhs.hasSource()) || getSource() == rhs.getSource()));
}

inline bool FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart::operator != (const FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart::operator < (const FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart& rhs) const {
    if (hasB32Anno_Types() || rhs.hasB32Anno_Types()) {
        if (getB32Anno_Types() < rhs.getB32Anno_Types()) return true;
        if (getB32Anno_Types() > rhs.getB32Anno_Types()) return false;
    }
    if (hasSource() || rhs.hasSource()) {
        if (getSource() < rhs.getSource()) return true;
        if (getSource() > rhs.getSource()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart::clone() {
    return new FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart(*this);
}

inline bool FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart::operator > (const FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart::clear() {
    clearB32Anno_Types();
    clearSource();
}

inline void FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart::clearB32Anno_Types() {
    if (hasB32Anno_Types()) {
         clear_has_b32Anno_Types();
        _b32Anno_Types = ::tunermaster_main_fi_types::T_b32_AnnoType ();
     }
}

inline bool FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart::hasB32Anno_Types () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::tunermaster_main_fi_types::T_b32_AnnoType& FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart::getB32Anno_Types () const {
    return _b32Anno_Types;
}

inline ::tunermaster_main_fi_types::T_b32_AnnoType& FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart::getB32Anno_TypesMutable () {
    set_has_b32Anno_Types();
    return _b32Anno_Types;
}

inline void FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart::setB32Anno_Types (const ::tunermaster_main_fi_types::T_b32_AnnoType& b32Anno_Types_) {
    set_has_b32Anno_Types();
    this->_b32Anno_Types = b32Anno_Types_;
}

inline void FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart::clearSource() {
    if (hasSource()) {
         clear_has_Source();
        _Source = ::tunermaster_main_fi_types::T_b8_SourceAnno ();
     }
}

inline bool FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart::hasSource () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::tunermaster_main_fi_types::T_b8_SourceAnno& FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart::getSource () const {
    return _Source;
}

inline ::tunermaster_main_fi_types::T_b8_SourceAnno& FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart::getSourceMutable () {
    set_has_Source();
    return _Source;
}

inline void FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart::setSource (const ::tunermaster_main_fi_types::T_b8_SourceAnno& Source_) {
    set_has_Source();
    this->_Source = Source_;
}

inline void FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart::set_has_b32Anno_Types () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart::clear_has_b32Anno_Types () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart::set_has_Source () {
    _has_bits_[0] |= 1u << 1;
}

inline void FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart::clear_has_Source () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult::FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult ()  :
    _TunerMaster_StatusResponse ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult::FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult (const FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult &rhs)  :
    ::asf::core::Payload(rhs),
    _TunerMaster_StatusResponse ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult::FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_)  :
    _TunerMaster_StatusResponse (TunerMaster_StatusResponse_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult::~FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult() {
}

inline FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult& FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult::operator = (const FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTunerMaster_StatusResponse()) {
            setTunerMaster_StatusResponse(rhs.getTunerMaster_StatusResponse());
        } else {
            clearTunerMaster_StatusResponse();
        }
    }
    return *this;
}

inline bool FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult::operator == (const FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult& rhs) const {
    return (((!hasTunerMaster_StatusResponse() && !rhs.hasTunerMaster_StatusResponse()) || getTunerMaster_StatusResponse() == rhs.getTunerMaster_StatusResponse()));
}

inline bool FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult::operator != (const FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult::operator < (const FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult& rhs) const {
    if (hasTunerMaster_StatusResponse() || rhs.hasTunerMaster_StatusResponse()) {
        if (getTunerMaster_StatusResponse() < rhs.getTunerMaster_StatusResponse()) return true;
        if (getTunerMaster_StatusResponse() > rhs.getTunerMaster_StatusResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult::clone() {
    return new FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult(*this);
}

inline bool FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult::operator > (const FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult::clear() {
    clearTunerMaster_StatusResponse();
}

inline void FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult::clearTunerMaster_StatusResponse() {
    if (hasTunerMaster_StatusResponse()) {
         clear_has_TunerMaster_StatusResponse();
        _TunerMaster_StatusResponse.clear();
     }
}

inline bool FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult::hasTunerMaster_StatusResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult::getTunerMaster_StatusResponse () const {
    return _TunerMaster_StatusResponse;
}

inline ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult::getTunerMaster_StatusResponseMutable () {
    set_has_TunerMaster_StatusResponse();
    return _TunerMaster_StatusResponse;
}

inline void FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult::setTunerMaster_StatusResponse (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_) {
    set_has_TunerMaster_StatusResponse();
    this->_TunerMaster_StatusResponse = TunerMaster_StatusResponse_;
}

inline void FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult::set_has_TunerMaster_StatusResponse () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult::clear_has_TunerMaster_StatusResponse () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FID_TUNMSTR_S_STOP_ANNOUNCEMENTStart::FID_TUNMSTR_S_STOP_ANNOUNCEMENTStart ()  :
    _StopAnnouncements (::tunermaster_main_fi_types::T_StopAnnouncements__TUN_MSTR_STOP_CURRENT)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_STOP_ANNOUNCEMENTStart::FID_TUNMSTR_S_STOP_ANNOUNCEMENTStart (const FID_TUNMSTR_S_STOP_ANNOUNCEMENTStart &rhs)  :
    ::asf::core::Payload(rhs),
    _StopAnnouncements (::tunermaster_main_fi_types::T_StopAnnouncements__TUN_MSTR_STOP_CURRENT)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUNMSTR_S_STOP_ANNOUNCEMENTStart::FID_TUNMSTR_S_STOP_ANNOUNCEMENTStart (::tunermaster_main_fi_types::T_StopAnnouncements StopAnnouncements_)  :
    _StopAnnouncements (StopAnnouncements_)
{
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_StopAnnouncements_IsValid(StopAnnouncements_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", StopAnnouncements_, "T_StopAnnouncements", "StopAnnouncements", "FID_TUNMSTR_S_STOP_ANNOUNCEMENTStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_STOP_ANNOUNCEMENTStart::~FID_TUNMSTR_S_STOP_ANNOUNCEMENTStart() {
}

inline FID_TUNMSTR_S_STOP_ANNOUNCEMENTStart& FID_TUNMSTR_S_STOP_ANNOUNCEMENTStart::operator = (const FID_TUNMSTR_S_STOP_ANNOUNCEMENTStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStopAnnouncements()) {
            setStopAnnouncements(rhs.getStopAnnouncements());
        } else {
            clearStopAnnouncements();
        }
    }
    return *this;
}

inline bool FID_TUNMSTR_S_STOP_ANNOUNCEMENTStart::operator == (const FID_TUNMSTR_S_STOP_ANNOUNCEMENTStart& rhs) const {
    return (((!hasStopAnnouncements() && !rhs.hasStopAnnouncements()) || getStopAnnouncements() == rhs.getStopAnnouncements()));
}

inline bool FID_TUNMSTR_S_STOP_ANNOUNCEMENTStart::operator != (const FID_TUNMSTR_S_STOP_ANNOUNCEMENTStart& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUNMSTR_S_STOP_ANNOUNCEMENTStart::operator < (const FID_TUNMSTR_S_STOP_ANNOUNCEMENTStart& rhs) const {
    if (hasStopAnnouncements() || rhs.hasStopAnnouncements()) {
        if ((uint32)getStopAnnouncements() < (uint32)rhs.getStopAnnouncements()) return true;
        if ((uint32)getStopAnnouncements() > (uint32)rhs.getStopAnnouncements()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUNMSTR_S_STOP_ANNOUNCEMENTStart::clone() {
    return new FID_TUNMSTR_S_STOP_ANNOUNCEMENTStart(*this);
}

inline bool FID_TUNMSTR_S_STOP_ANNOUNCEMENTStart::operator > (const FID_TUNMSTR_S_STOP_ANNOUNCEMENTStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUNMSTR_S_STOP_ANNOUNCEMENTStart::clear() {
    clearStopAnnouncements();
}

inline void FID_TUNMSTR_S_STOP_ANNOUNCEMENTStart::clearStopAnnouncements() {
    if (hasStopAnnouncements()) {
         clear_has_StopAnnouncements();
        _StopAnnouncements = ::tunermaster_main_fi_types::T_StopAnnouncements__TUN_MSTR_STOP_CURRENT;
     }
}

inline bool FID_TUNMSTR_S_STOP_ANNOUNCEMENTStart::hasStopAnnouncements () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::tunermaster_main_fi_types::T_StopAnnouncements FID_TUNMSTR_S_STOP_ANNOUNCEMENTStart::getStopAnnouncements () const {
    return _StopAnnouncements;
}

inline void FID_TUNMSTR_S_STOP_ANNOUNCEMENTStart::setStopAnnouncements (::tunermaster_main_fi_types::T_StopAnnouncements StopAnnouncements_) {
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_StopAnnouncements_IsValid(StopAnnouncements_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", StopAnnouncements_, "T_StopAnnouncements", "StopAnnouncements", "FID_TUNMSTR_S_STOP_ANNOUNCEMENTStart");
    }
    #endif
    set_has_StopAnnouncements();
    this->_StopAnnouncements = StopAnnouncements_;
}

inline void FID_TUNMSTR_S_STOP_ANNOUNCEMENTStart::set_has_StopAnnouncements () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUNMSTR_S_STOP_ANNOUNCEMENTStart::clear_has_StopAnnouncements () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FID_TUNMSTR_S_STOP_ANNOUNCEMENTResult::FID_TUNMSTR_S_STOP_ANNOUNCEMENTResult ()  :
    _TunerMaster_StatusResponse ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_STOP_ANNOUNCEMENTResult::FID_TUNMSTR_S_STOP_ANNOUNCEMENTResult (const FID_TUNMSTR_S_STOP_ANNOUNCEMENTResult &rhs)  :
    ::asf::core::Payload(rhs),
    _TunerMaster_StatusResponse ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUNMSTR_S_STOP_ANNOUNCEMENTResult::FID_TUNMSTR_S_STOP_ANNOUNCEMENTResult (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_)  :
    _TunerMaster_StatusResponse (TunerMaster_StatusResponse_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_STOP_ANNOUNCEMENTResult::~FID_TUNMSTR_S_STOP_ANNOUNCEMENTResult() {
}

inline FID_TUNMSTR_S_STOP_ANNOUNCEMENTResult& FID_TUNMSTR_S_STOP_ANNOUNCEMENTResult::operator = (const FID_TUNMSTR_S_STOP_ANNOUNCEMENTResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTunerMaster_StatusResponse()) {
            setTunerMaster_StatusResponse(rhs.getTunerMaster_StatusResponse());
        } else {
            clearTunerMaster_StatusResponse();
        }
    }
    return *this;
}

inline bool FID_TUNMSTR_S_STOP_ANNOUNCEMENTResult::operator == (const FID_TUNMSTR_S_STOP_ANNOUNCEMENTResult& rhs) const {
    return (((!hasTunerMaster_StatusResponse() && !rhs.hasTunerMaster_StatusResponse()) || getTunerMaster_StatusResponse() == rhs.getTunerMaster_StatusResponse()));
}

inline bool FID_TUNMSTR_S_STOP_ANNOUNCEMENTResult::operator != (const FID_TUNMSTR_S_STOP_ANNOUNCEMENTResult& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUNMSTR_S_STOP_ANNOUNCEMENTResult::operator < (const FID_TUNMSTR_S_STOP_ANNOUNCEMENTResult& rhs) const {
    if (hasTunerMaster_StatusResponse() || rhs.hasTunerMaster_StatusResponse()) {
        if (getTunerMaster_StatusResponse() < rhs.getTunerMaster_StatusResponse()) return true;
        if (getTunerMaster_StatusResponse() > rhs.getTunerMaster_StatusResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUNMSTR_S_STOP_ANNOUNCEMENTResult::clone() {
    return new FID_TUNMSTR_S_STOP_ANNOUNCEMENTResult(*this);
}

inline bool FID_TUNMSTR_S_STOP_ANNOUNCEMENTResult::operator > (const FID_TUNMSTR_S_STOP_ANNOUNCEMENTResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUNMSTR_S_STOP_ANNOUNCEMENTResult::clear() {
    clearTunerMaster_StatusResponse();
}

inline void FID_TUNMSTR_S_STOP_ANNOUNCEMENTResult::clearTunerMaster_StatusResponse() {
    if (hasTunerMaster_StatusResponse()) {
         clear_has_TunerMaster_StatusResponse();
        _TunerMaster_StatusResponse.clear();
     }
}

inline bool FID_TUNMSTR_S_STOP_ANNOUNCEMENTResult::hasTunerMaster_StatusResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& FID_TUNMSTR_S_STOP_ANNOUNCEMENTResult::getTunerMaster_StatusResponse () const {
    return _TunerMaster_StatusResponse;
}

inline ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& FID_TUNMSTR_S_STOP_ANNOUNCEMENTResult::getTunerMaster_StatusResponseMutable () {
    set_has_TunerMaster_StatusResponse();
    return _TunerMaster_StatusResponse;
}

inline void FID_TUNMSTR_S_STOP_ANNOUNCEMENTResult::setTunerMaster_StatusResponse (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_) {
    set_has_TunerMaster_StatusResponse();
    this->_TunerMaster_StatusResponse = TunerMaster_StatusResponse_;
}

inline void FID_TUNMSTR_S_STOP_ANNOUNCEMENTResult::set_has_TunerMaster_StatusResponse () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUNMSTR_S_STOP_ANNOUNCEMENTResult::clear_has_TunerMaster_StatusResponse () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FID_TUNMSTR_S_BAND_CHANGEStart::FID_TUNMSTR_S_BAND_CHANGEStart ()  :
    _Band (::tunermaster_main_fi_types::T_e8_Band__TUN_MSTR_BAND_FM)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_BAND_CHANGEStart::FID_TUNMSTR_S_BAND_CHANGEStart (const FID_TUNMSTR_S_BAND_CHANGEStart &rhs)  :
    ::asf::core::Payload(rhs),
    _Band (::tunermaster_main_fi_types::T_e8_Band__TUN_MSTR_BAND_FM)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUNMSTR_S_BAND_CHANGEStart::FID_TUNMSTR_S_BAND_CHANGEStart (::tunermaster_main_fi_types::T_e8_Band Band_)  :
    _Band (Band_)
{
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_Band_IsValid(Band_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Band_, "T_e8_Band", "Band", "FID_TUNMSTR_S_BAND_CHANGEStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_BAND_CHANGEStart::~FID_TUNMSTR_S_BAND_CHANGEStart() {
}

inline FID_TUNMSTR_S_BAND_CHANGEStart& FID_TUNMSTR_S_BAND_CHANGEStart::operator = (const FID_TUNMSTR_S_BAND_CHANGEStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBand()) {
            setBand(rhs.getBand());
        } else {
            clearBand();
        }
    }
    return *this;
}

inline bool FID_TUNMSTR_S_BAND_CHANGEStart::operator == (const FID_TUNMSTR_S_BAND_CHANGEStart& rhs) const {
    return (((!hasBand() && !rhs.hasBand()) || getBand() == rhs.getBand()));
}

inline bool FID_TUNMSTR_S_BAND_CHANGEStart::operator != (const FID_TUNMSTR_S_BAND_CHANGEStart& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUNMSTR_S_BAND_CHANGEStart::operator < (const FID_TUNMSTR_S_BAND_CHANGEStart& rhs) const {
    if (hasBand() || rhs.hasBand()) {
        if ((uint32)getBand() < (uint32)rhs.getBand()) return true;
        if ((uint32)getBand() > (uint32)rhs.getBand()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUNMSTR_S_BAND_CHANGEStart::clone() {
    return new FID_TUNMSTR_S_BAND_CHANGEStart(*this);
}

inline bool FID_TUNMSTR_S_BAND_CHANGEStart::operator > (const FID_TUNMSTR_S_BAND_CHANGEStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUNMSTR_S_BAND_CHANGEStart::clear() {
    clearBand();
}

inline void FID_TUNMSTR_S_BAND_CHANGEStart::clearBand() {
    if (hasBand()) {
         clear_has_Band();
        _Band = ::tunermaster_main_fi_types::T_e8_Band__TUN_MSTR_BAND_FM;
     }
}

inline bool FID_TUNMSTR_S_BAND_CHANGEStart::hasBand () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::tunermaster_main_fi_types::T_e8_Band FID_TUNMSTR_S_BAND_CHANGEStart::getBand () const {
    return _Band;
}

inline void FID_TUNMSTR_S_BAND_CHANGEStart::setBand (::tunermaster_main_fi_types::T_e8_Band Band_) {
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_Band_IsValid(Band_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Band_, "T_e8_Band", "Band", "FID_TUNMSTR_S_BAND_CHANGEStart");
    }
    #endif
    set_has_Band();
    this->_Band = Band_;
}

inline void FID_TUNMSTR_S_BAND_CHANGEStart::set_has_Band () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUNMSTR_S_BAND_CHANGEStart::clear_has_Band () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FID_TUNMSTR_S_BAND_CHANGEResult::FID_TUNMSTR_S_BAND_CHANGEResult ()  :
    _TunerMaster_StatusResponse ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_BAND_CHANGEResult::FID_TUNMSTR_S_BAND_CHANGEResult (const FID_TUNMSTR_S_BAND_CHANGEResult &rhs)  :
    ::asf::core::Payload(rhs),
    _TunerMaster_StatusResponse ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUNMSTR_S_BAND_CHANGEResult::FID_TUNMSTR_S_BAND_CHANGEResult (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_)  :
    _TunerMaster_StatusResponse (TunerMaster_StatusResponse_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_BAND_CHANGEResult::~FID_TUNMSTR_S_BAND_CHANGEResult() {
}

inline FID_TUNMSTR_S_BAND_CHANGEResult& FID_TUNMSTR_S_BAND_CHANGEResult::operator = (const FID_TUNMSTR_S_BAND_CHANGEResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTunerMaster_StatusResponse()) {
            setTunerMaster_StatusResponse(rhs.getTunerMaster_StatusResponse());
        } else {
            clearTunerMaster_StatusResponse();
        }
    }
    return *this;
}

inline bool FID_TUNMSTR_S_BAND_CHANGEResult::operator == (const FID_TUNMSTR_S_BAND_CHANGEResult& rhs) const {
    return (((!hasTunerMaster_StatusResponse() && !rhs.hasTunerMaster_StatusResponse()) || getTunerMaster_StatusResponse() == rhs.getTunerMaster_StatusResponse()));
}

inline bool FID_TUNMSTR_S_BAND_CHANGEResult::operator != (const FID_TUNMSTR_S_BAND_CHANGEResult& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUNMSTR_S_BAND_CHANGEResult::operator < (const FID_TUNMSTR_S_BAND_CHANGEResult& rhs) const {
    if (hasTunerMaster_StatusResponse() || rhs.hasTunerMaster_StatusResponse()) {
        if (getTunerMaster_StatusResponse() < rhs.getTunerMaster_StatusResponse()) return true;
        if (getTunerMaster_StatusResponse() > rhs.getTunerMaster_StatusResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUNMSTR_S_BAND_CHANGEResult::clone() {
    return new FID_TUNMSTR_S_BAND_CHANGEResult(*this);
}

inline bool FID_TUNMSTR_S_BAND_CHANGEResult::operator > (const FID_TUNMSTR_S_BAND_CHANGEResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUNMSTR_S_BAND_CHANGEResult::clear() {
    clearTunerMaster_StatusResponse();
}

inline void FID_TUNMSTR_S_BAND_CHANGEResult::clearTunerMaster_StatusResponse() {
    if (hasTunerMaster_StatusResponse()) {
         clear_has_TunerMaster_StatusResponse();
        _TunerMaster_StatusResponse.clear();
     }
}

inline bool FID_TUNMSTR_S_BAND_CHANGEResult::hasTunerMaster_StatusResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& FID_TUNMSTR_S_BAND_CHANGEResult::getTunerMaster_StatusResponse () const {
    return _TunerMaster_StatusResponse;
}

inline ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& FID_TUNMSTR_S_BAND_CHANGEResult::getTunerMaster_StatusResponseMutable () {
    set_has_TunerMaster_StatusResponse();
    return _TunerMaster_StatusResponse;
}

inline void FID_TUNMSTR_S_BAND_CHANGEResult::setTunerMaster_StatusResponse (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_) {
    set_has_TunerMaster_StatusResponse();
    this->_TunerMaster_StatusResponse = TunerMaster_StatusResponse_;
}

inline void FID_TUNMSTR_S_BAND_CHANGEResult::set_has_TunerMaster_StatusResponse () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUNMSTR_S_BAND_CHANGEResult::clear_has_TunerMaster_StatusResponse () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FID_TUNMSTR_S_RF_ANTENNA_TESTStart::FID_TUNMSTR_S_RF_ANTENNA_TESTStart ()  :
    _Antenna_Test (::tunermaster_main_fi_types::T_e8_AntennaTest__AMFM_Antenna1)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_RF_ANTENNA_TESTStart::FID_TUNMSTR_S_RF_ANTENNA_TESTStart (const FID_TUNMSTR_S_RF_ANTENNA_TESTStart &rhs)  :
    ::asf::core::Payload(rhs),
    _Antenna_Test (::tunermaster_main_fi_types::T_e8_AntennaTest__AMFM_Antenna1)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUNMSTR_S_RF_ANTENNA_TESTStart::FID_TUNMSTR_S_RF_ANTENNA_TESTStart (::tunermaster_main_fi_types::T_e8_AntennaTest Antenna_Test_)  :
    _Antenna_Test (Antenna_Test_)
{
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_AntennaTest_IsValid(Antenna_Test_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Antenna_Test_, "T_e8_AntennaTest", "Antenna_Test", "FID_TUNMSTR_S_RF_ANTENNA_TESTStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_RF_ANTENNA_TESTStart::~FID_TUNMSTR_S_RF_ANTENNA_TESTStart() {
}

inline FID_TUNMSTR_S_RF_ANTENNA_TESTStart& FID_TUNMSTR_S_RF_ANTENNA_TESTStart::operator = (const FID_TUNMSTR_S_RF_ANTENNA_TESTStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAntenna_Test()) {
            setAntenna_Test(rhs.getAntenna_Test());
        } else {
            clearAntenna_Test();
        }
    }
    return *this;
}

inline bool FID_TUNMSTR_S_RF_ANTENNA_TESTStart::operator == (const FID_TUNMSTR_S_RF_ANTENNA_TESTStart& rhs) const {
    return (((!hasAntenna_Test() && !rhs.hasAntenna_Test()) || getAntenna_Test() == rhs.getAntenna_Test()));
}

inline bool FID_TUNMSTR_S_RF_ANTENNA_TESTStart::operator != (const FID_TUNMSTR_S_RF_ANTENNA_TESTStart& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUNMSTR_S_RF_ANTENNA_TESTStart::operator < (const FID_TUNMSTR_S_RF_ANTENNA_TESTStart& rhs) const {
    if (hasAntenna_Test() || rhs.hasAntenna_Test()) {
        if ((uint32)getAntenna_Test() < (uint32)rhs.getAntenna_Test()) return true;
        if ((uint32)getAntenna_Test() > (uint32)rhs.getAntenna_Test()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUNMSTR_S_RF_ANTENNA_TESTStart::clone() {
    return new FID_TUNMSTR_S_RF_ANTENNA_TESTStart(*this);
}

inline bool FID_TUNMSTR_S_RF_ANTENNA_TESTStart::operator > (const FID_TUNMSTR_S_RF_ANTENNA_TESTStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUNMSTR_S_RF_ANTENNA_TESTStart::clear() {
    clearAntenna_Test();
}

inline void FID_TUNMSTR_S_RF_ANTENNA_TESTStart::clearAntenna_Test() {
    if (hasAntenna_Test()) {
         clear_has_Antenna_Test();
        _Antenna_Test = ::tunermaster_main_fi_types::T_e8_AntennaTest__AMFM_Antenna1;
     }
}

inline bool FID_TUNMSTR_S_RF_ANTENNA_TESTStart::hasAntenna_Test () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::tunermaster_main_fi_types::T_e8_AntennaTest FID_TUNMSTR_S_RF_ANTENNA_TESTStart::getAntenna_Test () const {
    return _Antenna_Test;
}

inline void FID_TUNMSTR_S_RF_ANTENNA_TESTStart::setAntenna_Test (::tunermaster_main_fi_types::T_e8_AntennaTest Antenna_Test_) {
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_AntennaTest_IsValid(Antenna_Test_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Antenna_Test_, "T_e8_AntennaTest", "Antenna_Test", "FID_TUNMSTR_S_RF_ANTENNA_TESTStart");
    }
    #endif
    set_has_Antenna_Test();
    this->_Antenna_Test = Antenna_Test_;
}

inline void FID_TUNMSTR_S_RF_ANTENNA_TESTStart::set_has_Antenna_Test () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUNMSTR_S_RF_ANTENNA_TESTStart::clear_has_Antenna_Test () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FID_TUNMSTR_S_RF_ANTENNA_TESTResult::FID_TUNMSTR_S_RF_ANTENNA_TESTResult ()  :
    _Tunmstr_RF_Antenna ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_RF_ANTENNA_TESTResult::FID_TUNMSTR_S_RF_ANTENNA_TESTResult (const FID_TUNMSTR_S_RF_ANTENNA_TESTResult &rhs)  :
    ::asf::core::Payload(rhs),
    _Tunmstr_RF_Antenna ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUNMSTR_S_RF_ANTENNA_TESTResult::FID_TUNMSTR_S_RF_ANTENNA_TESTResult (const ::tunermaster_main_fi_types::Tunmstr_RFAntenna& Tunmstr_RF_Antenna_)  :
    _Tunmstr_RF_Antenna (Tunmstr_RF_Antenna_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_RF_ANTENNA_TESTResult::~FID_TUNMSTR_S_RF_ANTENNA_TESTResult() {
}

inline FID_TUNMSTR_S_RF_ANTENNA_TESTResult& FID_TUNMSTR_S_RF_ANTENNA_TESTResult::operator = (const FID_TUNMSTR_S_RF_ANTENNA_TESTResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTunmstr_RF_Antenna()) {
            setTunmstr_RF_Antenna(rhs.getTunmstr_RF_Antenna());
        } else {
            clearTunmstr_RF_Antenna();
        }
    }
    return *this;
}

inline bool FID_TUNMSTR_S_RF_ANTENNA_TESTResult::operator == (const FID_TUNMSTR_S_RF_ANTENNA_TESTResult& rhs) const {
    return (((!hasTunmstr_RF_Antenna() && !rhs.hasTunmstr_RF_Antenna()) || getTunmstr_RF_Antenna() == rhs.getTunmstr_RF_Antenna()));
}

inline bool FID_TUNMSTR_S_RF_ANTENNA_TESTResult::operator != (const FID_TUNMSTR_S_RF_ANTENNA_TESTResult& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUNMSTR_S_RF_ANTENNA_TESTResult::operator < (const FID_TUNMSTR_S_RF_ANTENNA_TESTResult& rhs) const {
    if (hasTunmstr_RF_Antenna() || rhs.hasTunmstr_RF_Antenna()) {
        if (getTunmstr_RF_Antenna() < rhs.getTunmstr_RF_Antenna()) return true;
        if (getTunmstr_RF_Antenna() > rhs.getTunmstr_RF_Antenna()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUNMSTR_S_RF_ANTENNA_TESTResult::clone() {
    return new FID_TUNMSTR_S_RF_ANTENNA_TESTResult(*this);
}

inline bool FID_TUNMSTR_S_RF_ANTENNA_TESTResult::operator > (const FID_TUNMSTR_S_RF_ANTENNA_TESTResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUNMSTR_S_RF_ANTENNA_TESTResult::clear() {
    clearTunmstr_RF_Antenna();
}

inline void FID_TUNMSTR_S_RF_ANTENNA_TESTResult::clearTunmstr_RF_Antenna() {
    if (hasTunmstr_RF_Antenna()) {
         clear_has_Tunmstr_RF_Antenna();
        _Tunmstr_RF_Antenna.clear();
     }
}

inline bool FID_TUNMSTR_S_RF_ANTENNA_TESTResult::hasTunmstr_RF_Antenna () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::tunermaster_main_fi_types::Tunmstr_RFAntenna& FID_TUNMSTR_S_RF_ANTENNA_TESTResult::getTunmstr_RF_Antenna () const {
    return _Tunmstr_RF_Antenna;
}

inline ::tunermaster_main_fi_types::Tunmstr_RFAntenna& FID_TUNMSTR_S_RF_ANTENNA_TESTResult::getTunmstr_RF_AntennaMutable () {
    set_has_Tunmstr_RF_Antenna();
    return _Tunmstr_RF_Antenna;
}

inline void FID_TUNMSTR_S_RF_ANTENNA_TESTResult::setTunmstr_RF_Antenna (const ::tunermaster_main_fi_types::Tunmstr_RFAntenna& Tunmstr_RF_Antenna_) {
    set_has_Tunmstr_RF_Antenna();
    this->_Tunmstr_RF_Antenna = Tunmstr_RF_Antenna_;
}

inline void FID_TUNMSTR_S_RF_ANTENNA_TESTResult::set_has_Tunmstr_RF_Antenna () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUNMSTR_S_RF_ANTENNA_TESTResult::clear_has_Tunmstr_RF_Antenna () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FID_TUNMSTR_S_TEST_MODEStart::FID_TUNMSTR_S_TEST_MODEStart ()  :
    _TestModeActive (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_TEST_MODEStart::FID_TUNMSTR_S_TEST_MODEStart (const FID_TUNMSTR_S_TEST_MODEStart &rhs)  :
    ::asf::core::Payload(rhs),
    _TestModeActive (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUNMSTR_S_TEST_MODEStart::FID_TUNMSTR_S_TEST_MODEStart (bool TestModeActive_)  :
    _TestModeActive (TestModeActive_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_TEST_MODEStart::~FID_TUNMSTR_S_TEST_MODEStart() {
}

inline FID_TUNMSTR_S_TEST_MODEStart& FID_TUNMSTR_S_TEST_MODEStart::operator = (const FID_TUNMSTR_S_TEST_MODEStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTestModeActive()) {
            setTestModeActive(rhs.getTestModeActive());
        } else {
            clearTestModeActive();
        }
    }
    return *this;
}

inline bool FID_TUNMSTR_S_TEST_MODEStart::operator == (const FID_TUNMSTR_S_TEST_MODEStart& rhs) const {
    return (((!hasTestModeActive() && !rhs.hasTestModeActive()) || getTestModeActive() == rhs.getTestModeActive()));
}

inline bool FID_TUNMSTR_S_TEST_MODEStart::operator != (const FID_TUNMSTR_S_TEST_MODEStart& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUNMSTR_S_TEST_MODEStart::operator < (const FID_TUNMSTR_S_TEST_MODEStart& rhs) const {
    if (hasTestModeActive() || rhs.hasTestModeActive()) {
        if (getTestModeActive() < rhs.getTestModeActive()) return true;
        if (getTestModeActive() > rhs.getTestModeActive()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUNMSTR_S_TEST_MODEStart::clone() {
    return new FID_TUNMSTR_S_TEST_MODEStart(*this);
}

inline bool FID_TUNMSTR_S_TEST_MODEStart::operator > (const FID_TUNMSTR_S_TEST_MODEStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUNMSTR_S_TEST_MODEStart::clear() {
    clearTestModeActive();
}

inline void FID_TUNMSTR_S_TEST_MODEStart::clearTestModeActive() {
    if (hasTestModeActive()) {
         clear_has_TestModeActive();
        _TestModeActive = false;
     }
}

inline bool FID_TUNMSTR_S_TEST_MODEStart::hasTestModeActive () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool FID_TUNMSTR_S_TEST_MODEStart::getTestModeActive () const {
    return _TestModeActive;
}

inline void FID_TUNMSTR_S_TEST_MODEStart::setTestModeActive (bool TestModeActive_) {
    set_has_TestModeActive();
    this->_TestModeActive = TestModeActive_;
}

inline void FID_TUNMSTR_S_TEST_MODEStart::set_has_TestModeActive () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUNMSTR_S_TEST_MODEStart::clear_has_TestModeActive () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FID_TUNMSTR_S_TEST_MODEResult::FID_TUNMSTR_S_TEST_MODEResult ()  :
    _TunerMaster_StatusResponse ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_TEST_MODEResult::FID_TUNMSTR_S_TEST_MODEResult (const FID_TUNMSTR_S_TEST_MODEResult &rhs)  :
    ::asf::core::Payload(rhs),
    _TunerMaster_StatusResponse ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUNMSTR_S_TEST_MODEResult::FID_TUNMSTR_S_TEST_MODEResult (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_)  :
    _TunerMaster_StatusResponse (TunerMaster_StatusResponse_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_TEST_MODEResult::~FID_TUNMSTR_S_TEST_MODEResult() {
}

inline FID_TUNMSTR_S_TEST_MODEResult& FID_TUNMSTR_S_TEST_MODEResult::operator = (const FID_TUNMSTR_S_TEST_MODEResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTunerMaster_StatusResponse()) {
            setTunerMaster_StatusResponse(rhs.getTunerMaster_StatusResponse());
        } else {
            clearTunerMaster_StatusResponse();
        }
    }
    return *this;
}

inline bool FID_TUNMSTR_S_TEST_MODEResult::operator == (const FID_TUNMSTR_S_TEST_MODEResult& rhs) const {
    return (((!hasTunerMaster_StatusResponse() && !rhs.hasTunerMaster_StatusResponse()) || getTunerMaster_StatusResponse() == rhs.getTunerMaster_StatusResponse()));
}

inline bool FID_TUNMSTR_S_TEST_MODEResult::operator != (const FID_TUNMSTR_S_TEST_MODEResult& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUNMSTR_S_TEST_MODEResult::operator < (const FID_TUNMSTR_S_TEST_MODEResult& rhs) const {
    if (hasTunerMaster_StatusResponse() || rhs.hasTunerMaster_StatusResponse()) {
        if (getTunerMaster_StatusResponse() < rhs.getTunerMaster_StatusResponse()) return true;
        if (getTunerMaster_StatusResponse() > rhs.getTunerMaster_StatusResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUNMSTR_S_TEST_MODEResult::clone() {
    return new FID_TUNMSTR_S_TEST_MODEResult(*this);
}

inline bool FID_TUNMSTR_S_TEST_MODEResult::operator > (const FID_TUNMSTR_S_TEST_MODEResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUNMSTR_S_TEST_MODEResult::clear() {
    clearTunerMaster_StatusResponse();
}

inline void FID_TUNMSTR_S_TEST_MODEResult::clearTunerMaster_StatusResponse() {
    if (hasTunerMaster_StatusResponse()) {
         clear_has_TunerMaster_StatusResponse();
        _TunerMaster_StatusResponse.clear();
     }
}

inline bool FID_TUNMSTR_S_TEST_MODEResult::hasTunerMaster_StatusResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& FID_TUNMSTR_S_TEST_MODEResult::getTunerMaster_StatusResponse () const {
    return _TunerMaster_StatusResponse;
}

inline ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& FID_TUNMSTR_S_TEST_MODEResult::getTunerMaster_StatusResponseMutable () {
    set_has_TunerMaster_StatusResponse();
    return _TunerMaster_StatusResponse;
}

inline void FID_TUNMSTR_S_TEST_MODEResult::setTunerMaster_StatusResponse (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_) {
    set_has_TunerMaster_StatusResponse();
    this->_TunerMaster_StatusResponse = TunerMaster_StatusResponse_;
}

inline void FID_TUNMSTR_S_TEST_MODEResult::set_has_TunerMaster_StatusResponse () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUNMSTR_S_TEST_MODEResult::clear_has_TunerMaster_StatusResponse () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FID_TUNMSTR_S_SRCCHG_TESTMODEStart::FID_TUNMSTR_S_SRCCHG_TESTMODEStart ()  :
    _WhichTuner (::tunermaster_main_fi_types::T_e8_WhichTuner__TUN_MSTR_TUNER_0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_SRCCHG_TESTMODEStart::FID_TUNMSTR_S_SRCCHG_TESTMODEStart (const FID_TUNMSTR_S_SRCCHG_TESTMODEStart &rhs)  :
    ::asf::core::Payload(rhs),
    _WhichTuner (::tunermaster_main_fi_types::T_e8_WhichTuner__TUN_MSTR_TUNER_0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUNMSTR_S_SRCCHG_TESTMODEStart::FID_TUNMSTR_S_SRCCHG_TESTMODEStart (::tunermaster_main_fi_types::T_e8_WhichTuner WhichTuner_)  :
    _WhichTuner (WhichTuner_)
{
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_WhichTuner_IsValid(WhichTuner_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", WhichTuner_, "T_e8_WhichTuner", "WhichTuner", "FID_TUNMSTR_S_SRCCHG_TESTMODEStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_SRCCHG_TESTMODEStart::~FID_TUNMSTR_S_SRCCHG_TESTMODEStart() {
}

inline FID_TUNMSTR_S_SRCCHG_TESTMODEStart& FID_TUNMSTR_S_SRCCHG_TESTMODEStart::operator = (const FID_TUNMSTR_S_SRCCHG_TESTMODEStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasWhichTuner()) {
            setWhichTuner(rhs.getWhichTuner());
        } else {
            clearWhichTuner();
        }
    }
    return *this;
}

inline bool FID_TUNMSTR_S_SRCCHG_TESTMODEStart::operator == (const FID_TUNMSTR_S_SRCCHG_TESTMODEStart& rhs) const {
    return (((!hasWhichTuner() && !rhs.hasWhichTuner()) || getWhichTuner() == rhs.getWhichTuner()));
}

inline bool FID_TUNMSTR_S_SRCCHG_TESTMODEStart::operator != (const FID_TUNMSTR_S_SRCCHG_TESTMODEStart& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUNMSTR_S_SRCCHG_TESTMODEStart::operator < (const FID_TUNMSTR_S_SRCCHG_TESTMODEStart& rhs) const {
    if (hasWhichTuner() || rhs.hasWhichTuner()) {
        if ((uint32)getWhichTuner() < (uint32)rhs.getWhichTuner()) return true;
        if ((uint32)getWhichTuner() > (uint32)rhs.getWhichTuner()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUNMSTR_S_SRCCHG_TESTMODEStart::clone() {
    return new FID_TUNMSTR_S_SRCCHG_TESTMODEStart(*this);
}

inline bool FID_TUNMSTR_S_SRCCHG_TESTMODEStart::operator > (const FID_TUNMSTR_S_SRCCHG_TESTMODEStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUNMSTR_S_SRCCHG_TESTMODEStart::clear() {
    clearWhichTuner();
}

inline void FID_TUNMSTR_S_SRCCHG_TESTMODEStart::clearWhichTuner() {
    if (hasWhichTuner()) {
         clear_has_WhichTuner();
        _WhichTuner = ::tunermaster_main_fi_types::T_e8_WhichTuner__TUN_MSTR_TUNER_0;
     }
}

inline bool FID_TUNMSTR_S_SRCCHG_TESTMODEStart::hasWhichTuner () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::tunermaster_main_fi_types::T_e8_WhichTuner FID_TUNMSTR_S_SRCCHG_TESTMODEStart::getWhichTuner () const {
    return _WhichTuner;
}

inline void FID_TUNMSTR_S_SRCCHG_TESTMODEStart::setWhichTuner (::tunermaster_main_fi_types::T_e8_WhichTuner WhichTuner_) {
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_WhichTuner_IsValid(WhichTuner_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", WhichTuner_, "T_e8_WhichTuner", "WhichTuner", "FID_TUNMSTR_S_SRCCHG_TESTMODEStart");
    }
    #endif
    set_has_WhichTuner();
    this->_WhichTuner = WhichTuner_;
}

inline void FID_TUNMSTR_S_SRCCHG_TESTMODEStart::set_has_WhichTuner () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUNMSTR_S_SRCCHG_TESTMODEStart::clear_has_WhichTuner () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FID_TUNMSTR_S_SRCCHG_TESTMODEResult::FID_TUNMSTR_S_SRCCHG_TESTMODEResult ()  :
    _TunerMaster_StatusResponse ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_SRCCHG_TESTMODEResult::FID_TUNMSTR_S_SRCCHG_TESTMODEResult (const FID_TUNMSTR_S_SRCCHG_TESTMODEResult &rhs)  :
    ::asf::core::Payload(rhs),
    _TunerMaster_StatusResponse ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUNMSTR_S_SRCCHG_TESTMODEResult::FID_TUNMSTR_S_SRCCHG_TESTMODEResult (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_)  :
    _TunerMaster_StatusResponse (TunerMaster_StatusResponse_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_SRCCHG_TESTMODEResult::~FID_TUNMSTR_S_SRCCHG_TESTMODEResult() {
}

inline FID_TUNMSTR_S_SRCCHG_TESTMODEResult& FID_TUNMSTR_S_SRCCHG_TESTMODEResult::operator = (const FID_TUNMSTR_S_SRCCHG_TESTMODEResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTunerMaster_StatusResponse()) {
            setTunerMaster_StatusResponse(rhs.getTunerMaster_StatusResponse());
        } else {
            clearTunerMaster_StatusResponse();
        }
    }
    return *this;
}

inline bool FID_TUNMSTR_S_SRCCHG_TESTMODEResult::operator == (const FID_TUNMSTR_S_SRCCHG_TESTMODEResult& rhs) const {
    return (((!hasTunerMaster_StatusResponse() && !rhs.hasTunerMaster_StatusResponse()) || getTunerMaster_StatusResponse() == rhs.getTunerMaster_StatusResponse()));
}

inline bool FID_TUNMSTR_S_SRCCHG_TESTMODEResult::operator != (const FID_TUNMSTR_S_SRCCHG_TESTMODEResult& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUNMSTR_S_SRCCHG_TESTMODEResult::operator < (const FID_TUNMSTR_S_SRCCHG_TESTMODEResult& rhs) const {
    if (hasTunerMaster_StatusResponse() || rhs.hasTunerMaster_StatusResponse()) {
        if (getTunerMaster_StatusResponse() < rhs.getTunerMaster_StatusResponse()) return true;
        if (getTunerMaster_StatusResponse() > rhs.getTunerMaster_StatusResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUNMSTR_S_SRCCHG_TESTMODEResult::clone() {
    return new FID_TUNMSTR_S_SRCCHG_TESTMODEResult(*this);
}

inline bool FID_TUNMSTR_S_SRCCHG_TESTMODEResult::operator > (const FID_TUNMSTR_S_SRCCHG_TESTMODEResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUNMSTR_S_SRCCHG_TESTMODEResult::clear() {
    clearTunerMaster_StatusResponse();
}

inline void FID_TUNMSTR_S_SRCCHG_TESTMODEResult::clearTunerMaster_StatusResponse() {
    if (hasTunerMaster_StatusResponse()) {
         clear_has_TunerMaster_StatusResponse();
        _TunerMaster_StatusResponse.clear();
     }
}

inline bool FID_TUNMSTR_S_SRCCHG_TESTMODEResult::hasTunerMaster_StatusResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& FID_TUNMSTR_S_SRCCHG_TESTMODEResult::getTunerMaster_StatusResponse () const {
    return _TunerMaster_StatusResponse;
}

inline ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& FID_TUNMSTR_S_SRCCHG_TESTMODEResult::getTunerMaster_StatusResponseMutable () {
    set_has_TunerMaster_StatusResponse();
    return _TunerMaster_StatusResponse;
}

inline void FID_TUNMSTR_S_SRCCHG_TESTMODEResult::setTunerMaster_StatusResponse (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_) {
    set_has_TunerMaster_StatusResponse();
    this->_TunerMaster_StatusResponse = TunerMaster_StatusResponse_;
}

inline void FID_TUNMSTR_S_SRCCHG_TESTMODEResult::set_has_TunerMaster_StatusResponse () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUNMSTR_S_SRCCHG_TESTMODEResult::clear_has_TunerMaster_StatusResponse () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult::FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult ()  :
    _WhichTuner (::tunermaster_main_fi_types::T_e8_WhichTuner__TUN_MSTR_TUNER_0),
    _TunerMaster_StatusResponse ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult::FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult (const FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult &rhs)  :
    ::asf::core::Payload(rhs),
    _WhichTuner (::tunermaster_main_fi_types::T_e8_WhichTuner__TUN_MSTR_TUNER_0),
    _TunerMaster_StatusResponse ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult::FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult (::tunermaster_main_fi_types::T_e8_WhichTuner WhichTuner_, const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_)  :
    _WhichTuner (WhichTuner_),
    _TunerMaster_StatusResponse (TunerMaster_StatusResponse_)
{
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_WhichTuner_IsValid(WhichTuner_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", WhichTuner_, "T_e8_WhichTuner", "WhichTuner", "FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult::~FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult() {
}

inline FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult& FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult::operator = (const FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasWhichTuner()) {
            setWhichTuner(rhs.getWhichTuner());
        } else {
            clearWhichTuner();
        }
        if (rhs.hasTunerMaster_StatusResponse()) {
            setTunerMaster_StatusResponse(rhs.getTunerMaster_StatusResponse());
        } else {
            clearTunerMaster_StatusResponse();
        }
    }
    return *this;
}

inline bool FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult::operator == (const FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult& rhs) const {
    return (((!hasWhichTuner() && !rhs.hasWhichTuner()) || getWhichTuner() == rhs.getWhichTuner()) &&
        ((!hasTunerMaster_StatusResponse() && !rhs.hasTunerMaster_StatusResponse()) || getTunerMaster_StatusResponse() == rhs.getTunerMaster_StatusResponse()));
}

inline bool FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult::operator != (const FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult::operator < (const FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult& rhs) const {
    if (hasWhichTuner() || rhs.hasWhichTuner()) {
        if ((uint32)getWhichTuner() < (uint32)rhs.getWhichTuner()) return true;
        if ((uint32)getWhichTuner() > (uint32)rhs.getWhichTuner()) return false;
    }
    if (hasTunerMaster_StatusResponse() || rhs.hasTunerMaster_StatusResponse()) {
        if (getTunerMaster_StatusResponse() < rhs.getTunerMaster_StatusResponse()) return true;
        if (getTunerMaster_StatusResponse() > rhs.getTunerMaster_StatusResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult::clone() {
    return new FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult(*this);
}

inline bool FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult::operator > (const FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult::clear() {
    clearWhichTuner();
    clearTunerMaster_StatusResponse();
}

inline void FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult::clearWhichTuner() {
    if (hasWhichTuner()) {
         clear_has_WhichTuner();
        _WhichTuner = ::tunermaster_main_fi_types::T_e8_WhichTuner__TUN_MSTR_TUNER_0;
     }
}

inline bool FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult::hasWhichTuner () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::tunermaster_main_fi_types::T_e8_WhichTuner FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult::getWhichTuner () const {
    return _WhichTuner;
}

inline void FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult::setWhichTuner (::tunermaster_main_fi_types::T_e8_WhichTuner WhichTuner_) {
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_WhichTuner_IsValid(WhichTuner_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", WhichTuner_, "T_e8_WhichTuner", "WhichTuner", "FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult");
    }
    #endif
    set_has_WhichTuner();
    this->_WhichTuner = WhichTuner_;
}

inline void FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult::clearTunerMaster_StatusResponse() {
    if (hasTunerMaster_StatusResponse()) {
         clear_has_TunerMaster_StatusResponse();
        _TunerMaster_StatusResponse.clear();
     }
}

inline bool FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult::hasTunerMaster_StatusResponse () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult::getTunerMaster_StatusResponse () const {
    return _TunerMaster_StatusResponse;
}

inline ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult::getTunerMaster_StatusResponseMutable () {
    set_has_TunerMaster_StatusResponse();
    return _TunerMaster_StatusResponse;
}

inline void FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult::setTunerMaster_StatusResponse (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_) {
    set_has_TunerMaster_StatusResponse();
    this->_TunerMaster_StatusResponse = TunerMaster_StatusResponse_;
}

inline void FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult::set_has_WhichTuner () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult::clear_has_WhichTuner () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult::set_has_TunerMaster_StatusResponse () {
    _has_bits_[0] |= 1u << 1;
}

inline void FID_TUNMSTR_S_GET_ACTIVETUNER_INFOResult::clear_has_TunerMaster_StatusResponse () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart::FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart ()  :
    _Band (::tunermaster_main_fi_types::T_e8_Band__TUN_MSTR_BAND_FM),
    _Frequency (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart::FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart (const FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart &rhs)  :
    ::asf::core::Payload(rhs),
    _Band (::tunermaster_main_fi_types::T_e8_Band__TUN_MSTR_BAND_FM),
    _Frequency (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart::FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart (::tunermaster_main_fi_types::T_e8_Band Band_, uint32 Frequency_)  :
    _Band (Band_),
    _Frequency (Frequency_)
{
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_Band_IsValid(Band_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Band_, "T_e8_Band", "Band", "FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart::~FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart() {
}

inline FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart& FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart::operator = (const FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBand()) {
            setBand(rhs.getBand());
        } else {
            clearBand();
        }
        if (rhs.hasFrequency()) {
            setFrequency(rhs.getFrequency());
        } else {
            clearFrequency();
        }
    }
    return *this;
}

inline bool FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart::operator == (const FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart& rhs) const {
    return (((!hasBand() && !rhs.hasBand()) || getBand() == rhs.getBand()) &&
        ((!hasFrequency() && !rhs.hasFrequency()) || getFrequency() == rhs.getFrequency()));
}

inline bool FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart::operator != (const FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart::operator < (const FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart& rhs) const {
    if (hasBand() || rhs.hasBand()) {
        if ((uint32)getBand() < (uint32)rhs.getBand()) return true;
        if ((uint32)getBand() > (uint32)rhs.getBand()) return false;
    }
    if (hasFrequency() || rhs.hasFrequency()) {
        if (getFrequency() < rhs.getFrequency()) return true;
        if (getFrequency() > rhs.getFrequency()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart::clone() {
    return new FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart(*this);
}

inline bool FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart::operator > (const FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart::clear() {
    clearBand();
    clearFrequency();
}

inline void FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart::clearBand() {
    if (hasBand()) {
         clear_has_Band();
        _Band = ::tunermaster_main_fi_types::T_e8_Band__TUN_MSTR_BAND_FM;
     }
}

inline bool FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart::hasBand () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::tunermaster_main_fi_types::T_e8_Band FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart::getBand () const {
    return _Band;
}

inline void FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart::setBand (::tunermaster_main_fi_types::T_e8_Band Band_) {
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_Band_IsValid(Band_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Band_, "T_e8_Band", "Band", "FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart");
    }
    #endif
    set_has_Band();
    this->_Band = Band_;
}

inline void FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart::clearFrequency() {
    if (hasFrequency()) {
         clear_has_Frequency();
        _Frequency = 0u;
     }
}

inline bool FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart::hasFrequency () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart::getFrequency () const {
    return _Frequency;
}

inline void FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart::setFrequency (uint32 Frequency_) {
    set_has_Frequency();
    this->_Frequency = Frequency_;
}

inline void FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart::set_has_Band () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart::clear_has_Band () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart::set_has_Frequency () {
    _has_bits_[0] |= 1u << 1;
}

inline void FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTStart::clear_has_Frequency () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTResult::FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTResult ()  :
    _TunerMaster_StatusResponse ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTResult::FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTResult (const FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTResult &rhs)  :
    ::asf::core::Payload(rhs),
    _TunerMaster_StatusResponse ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTResult::FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTResult (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_)  :
    _TunerMaster_StatusResponse (TunerMaster_StatusResponse_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTResult::~FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTResult() {
}

inline FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTResult& FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTResult::operator = (const FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTunerMaster_StatusResponse()) {
            setTunerMaster_StatusResponse(rhs.getTunerMaster_StatusResponse());
        } else {
            clearTunerMaster_StatusResponse();
        }
    }
    return *this;
}

inline bool FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTResult::operator == (const FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTResult& rhs) const {
    return (((!hasTunerMaster_StatusResponse() && !rhs.hasTunerMaster_StatusResponse()) || getTunerMaster_StatusResponse() == rhs.getTunerMaster_StatusResponse()));
}

inline bool FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTResult::operator != (const FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTResult& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTResult::operator < (const FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTResult& rhs) const {
    if (hasTunerMaster_StatusResponse() || rhs.hasTunerMaster_StatusResponse()) {
        if (getTunerMaster_StatusResponse() < rhs.getTunerMaster_StatusResponse()) return true;
        if (getTunerMaster_StatusResponse() > rhs.getTunerMaster_StatusResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTResult::clone() {
    return new FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTResult(*this);
}

inline bool FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTResult::operator > (const FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTResult::clear() {
    clearTunerMaster_StatusResponse();
}

inline void FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTResult::clearTunerMaster_StatusResponse() {
    if (hasTunerMaster_StatusResponse()) {
         clear_has_TunerMaster_StatusResponse();
        _TunerMaster_StatusResponse.clear();
     }
}

inline bool FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTResult::hasTunerMaster_StatusResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTResult::getTunerMaster_StatusResponse () const {
    return _TunerMaster_StatusResponse;
}

inline ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTResult::getTunerMaster_StatusResponseMutable () {
    set_has_TunerMaster_StatusResponse();
    return _TunerMaster_StatusResponse;
}

inline void FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTResult::setTunerMaster_StatusResponse (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_) {
    set_has_TunerMaster_StatusResponse();
    this->_TunerMaster_StatusResponse = TunerMaster_StatusResponse_;
}

inline void FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTResult::set_has_TunerMaster_StatusResponse () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTResult::clear_has_TunerMaster_StatusResponse () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FID_TUNMSTR_S_PRESET_HANDLINGStart::FID_TUNMSTR_S_PRESET_HANDLINGStart ()  :
    _Preset_Action (::tunermaster_main_fi_types::T_e8_Preset_Action__TUNMSTR_PresetRecall),
    _u8Element_ID (0u),
    _List (::tunermaster_main_fi_types::T_e8_List__BANK_FM1),
    _Band (::tunermaster_main_fi_types::T_e8_Band__TUN_MSTR_BAND_FM),
    _Frequency (0u),
    _PI (0u),
    _SecondaryPI (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_PRESET_HANDLINGStart::FID_TUNMSTR_S_PRESET_HANDLINGStart (const FID_TUNMSTR_S_PRESET_HANDLINGStart &rhs)  :
    ::asf::core::Payload(rhs),
    _Preset_Action (::tunermaster_main_fi_types::T_e8_Preset_Action__TUNMSTR_PresetRecall),
    _u8Element_ID (0u),
    _List (::tunermaster_main_fi_types::T_e8_List__BANK_FM1),
    _Band (::tunermaster_main_fi_types::T_e8_Band__TUN_MSTR_BAND_FM),
    _Frequency (0u),
    _PI (0u),
    _SecondaryPI (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUNMSTR_S_PRESET_HANDLINGStart::FID_TUNMSTR_S_PRESET_HANDLINGStart (::tunermaster_main_fi_types::T_e8_Preset_Action Preset_Action_, uint8 u8Element_ID_, ::tunermaster_main_fi_types::T_e8_List List_, ::tunermaster_main_fi_types::T_e8_Band Band_, uint32 Frequency_, uint32 PI_, uint16 SecondaryPI_)  :
    _Preset_Action (Preset_Action_),
    _u8Element_ID (u8Element_ID_),
    _List (List_),
    _Band (Band_),
    _Frequency (Frequency_),
    _PI (PI_),
    _SecondaryPI (SecondaryPI_)
{
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_Preset_Action_IsValid(Preset_Action_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Preset_Action_, "T_e8_Preset_Action", "Preset_Action", "FID_TUNMSTR_S_PRESET_HANDLINGStart");
    }
    #endif
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_List_IsValid(List_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", List_, "T_e8_List", "List", "FID_TUNMSTR_S_PRESET_HANDLINGStart");
    }
    #endif
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_Band_IsValid(Band_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Band_, "T_e8_Band", "Band", "FID_TUNMSTR_S_PRESET_HANDLINGStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_PRESET_HANDLINGStart::~FID_TUNMSTR_S_PRESET_HANDLINGStart() {
}

inline FID_TUNMSTR_S_PRESET_HANDLINGStart& FID_TUNMSTR_S_PRESET_HANDLINGStart::operator = (const FID_TUNMSTR_S_PRESET_HANDLINGStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPreset_Action()) {
            setPreset_Action(rhs.getPreset_Action());
        } else {
            clearPreset_Action();
        }
        if (rhs.hasU8Element_ID()) {
            setU8Element_ID(rhs.getU8Element_ID());
        } else {
            clearU8Element_ID();
        }
        if (rhs.hasList()) {
            setList(rhs.getList());
        } else {
            clearList();
        }
        if (rhs.hasBand()) {
            setBand(rhs.getBand());
        } else {
            clearBand();
        }
        if (rhs.hasFrequency()) {
            setFrequency(rhs.getFrequency());
        } else {
            clearFrequency();
        }
        if (rhs.hasPI()) {
            setPI(rhs.getPI());
        } else {
            clearPI();
        }
        if (rhs.hasSecondaryPI()) {
            setSecondaryPI(rhs.getSecondaryPI());
        } else {
            clearSecondaryPI();
        }
    }
    return *this;
}

inline bool FID_TUNMSTR_S_PRESET_HANDLINGStart::operator == (const FID_TUNMSTR_S_PRESET_HANDLINGStart& rhs) const {
    return (((!hasPreset_Action() && !rhs.hasPreset_Action()) || getPreset_Action() == rhs.getPreset_Action()) &&
        ((!hasU8Element_ID() && !rhs.hasU8Element_ID()) || getU8Element_ID() == rhs.getU8Element_ID()) &&
        ((!hasList() && !rhs.hasList()) || getList() == rhs.getList()) &&
        ((!hasBand() && !rhs.hasBand()) || getBand() == rhs.getBand()) &&
        ((!hasFrequency() && !rhs.hasFrequency()) || getFrequency() == rhs.getFrequency()) &&
        ((!hasPI() && !rhs.hasPI()) || getPI() == rhs.getPI()) &&
        ((!hasSecondaryPI() && !rhs.hasSecondaryPI()) || getSecondaryPI() == rhs.getSecondaryPI()));
}

inline bool FID_TUNMSTR_S_PRESET_HANDLINGStart::operator != (const FID_TUNMSTR_S_PRESET_HANDLINGStart& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUNMSTR_S_PRESET_HANDLINGStart::operator < (const FID_TUNMSTR_S_PRESET_HANDLINGStart& rhs) const {
    if (hasPreset_Action() || rhs.hasPreset_Action()) {
        if ((uint32)getPreset_Action() < (uint32)rhs.getPreset_Action()) return true;
        if ((uint32)getPreset_Action() > (uint32)rhs.getPreset_Action()) return false;
    }
    if (hasU8Element_ID() || rhs.hasU8Element_ID()) {
        if (getU8Element_ID() < rhs.getU8Element_ID()) return true;
        if (getU8Element_ID() > rhs.getU8Element_ID()) return false;
    }
    if (hasList() || rhs.hasList()) {
        if ((uint32)getList() < (uint32)rhs.getList()) return true;
        if ((uint32)getList() > (uint32)rhs.getList()) return false;
    }
    if (hasBand() || rhs.hasBand()) {
        if ((uint32)getBand() < (uint32)rhs.getBand()) return true;
        if ((uint32)getBand() > (uint32)rhs.getBand()) return false;
    }
    if (hasFrequency() || rhs.hasFrequency()) {
        if (getFrequency() < rhs.getFrequency()) return true;
        if (getFrequency() > rhs.getFrequency()) return false;
    }
    if (hasPI() || rhs.hasPI()) {
        if (getPI() < rhs.getPI()) return true;
        if (getPI() > rhs.getPI()) return false;
    }
    if (hasSecondaryPI() || rhs.hasSecondaryPI()) {
        if (getSecondaryPI() < rhs.getSecondaryPI()) return true;
        if (getSecondaryPI() > rhs.getSecondaryPI()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUNMSTR_S_PRESET_HANDLINGStart::clone() {
    return new FID_TUNMSTR_S_PRESET_HANDLINGStart(*this);
}

inline bool FID_TUNMSTR_S_PRESET_HANDLINGStart::operator > (const FID_TUNMSTR_S_PRESET_HANDLINGStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUNMSTR_S_PRESET_HANDLINGStart::clear() {
    clearPreset_Action();
    clearU8Element_ID();
    clearList();
    clearBand();
    clearFrequency();
    clearPI();
    clearSecondaryPI();
}

inline void FID_TUNMSTR_S_PRESET_HANDLINGStart::clearPreset_Action() {
    if (hasPreset_Action()) {
         clear_has_Preset_Action();
        _Preset_Action = ::tunermaster_main_fi_types::T_e8_Preset_Action__TUNMSTR_PresetRecall;
     }
}

inline bool FID_TUNMSTR_S_PRESET_HANDLINGStart::hasPreset_Action () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::tunermaster_main_fi_types::T_e8_Preset_Action FID_TUNMSTR_S_PRESET_HANDLINGStart::getPreset_Action () const {
    return _Preset_Action;
}

inline void FID_TUNMSTR_S_PRESET_HANDLINGStart::setPreset_Action (::tunermaster_main_fi_types::T_e8_Preset_Action Preset_Action_) {
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_Preset_Action_IsValid(Preset_Action_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Preset_Action_, "T_e8_Preset_Action", "Preset_Action", "FID_TUNMSTR_S_PRESET_HANDLINGStart");
    }
    #endif
    set_has_Preset_Action();
    this->_Preset_Action = Preset_Action_;
}

inline void FID_TUNMSTR_S_PRESET_HANDLINGStart::clearU8Element_ID() {
    if (hasU8Element_ID()) {
         clear_has_u8Element_ID();
        _u8Element_ID = 0u;
     }
}

inline bool FID_TUNMSTR_S_PRESET_HANDLINGStart::hasU8Element_ID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 FID_TUNMSTR_S_PRESET_HANDLINGStart::getU8Element_ID () const {
    return _u8Element_ID;
}

inline void FID_TUNMSTR_S_PRESET_HANDLINGStart::setU8Element_ID (uint8 u8Element_ID_) {
    set_has_u8Element_ID();
    this->_u8Element_ID = u8Element_ID_;
}

inline void FID_TUNMSTR_S_PRESET_HANDLINGStart::clearList() {
    if (hasList()) {
         clear_has_List();
        _List = ::tunermaster_main_fi_types::T_e8_List__BANK_FM1;
     }
}

inline bool FID_TUNMSTR_S_PRESET_HANDLINGStart::hasList () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline ::tunermaster_main_fi_types::T_e8_List FID_TUNMSTR_S_PRESET_HANDLINGStart::getList () const {
    return _List;
}

inline void FID_TUNMSTR_S_PRESET_HANDLINGStart::setList (::tunermaster_main_fi_types::T_e8_List List_) {
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_List_IsValid(List_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", List_, "T_e8_List", "List", "FID_TUNMSTR_S_PRESET_HANDLINGStart");
    }
    #endif
    set_has_List();
    this->_List = List_;
}

inline void FID_TUNMSTR_S_PRESET_HANDLINGStart::clearBand() {
    if (hasBand()) {
         clear_has_Band();
        _Band = ::tunermaster_main_fi_types::T_e8_Band__TUN_MSTR_BAND_FM;
     }
}

inline bool FID_TUNMSTR_S_PRESET_HANDLINGStart::hasBand () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline ::tunermaster_main_fi_types::T_e8_Band FID_TUNMSTR_S_PRESET_HANDLINGStart::getBand () const {
    return _Band;
}

inline void FID_TUNMSTR_S_PRESET_HANDLINGStart::setBand (::tunermaster_main_fi_types::T_e8_Band Band_) {
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_Band_IsValid(Band_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Band_, "T_e8_Band", "Band", "FID_TUNMSTR_S_PRESET_HANDLINGStart");
    }
    #endif
    set_has_Band();
    this->_Band = Band_;
}

inline void FID_TUNMSTR_S_PRESET_HANDLINGStart::clearFrequency() {
    if (hasFrequency()) {
         clear_has_Frequency();
        _Frequency = 0u;
     }
}

inline bool FID_TUNMSTR_S_PRESET_HANDLINGStart::hasFrequency () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint32 FID_TUNMSTR_S_PRESET_HANDLINGStart::getFrequency () const {
    return _Frequency;
}

inline void FID_TUNMSTR_S_PRESET_HANDLINGStart::setFrequency (uint32 Frequency_) {
    set_has_Frequency();
    this->_Frequency = Frequency_;
}

inline void FID_TUNMSTR_S_PRESET_HANDLINGStart::clearPI() {
    if (hasPI()) {
         clear_has_PI();
        _PI = 0u;
     }
}

inline bool FID_TUNMSTR_S_PRESET_HANDLINGStart::hasPI () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint32 FID_TUNMSTR_S_PRESET_HANDLINGStart::getPI () const {
    return _PI;
}

inline void FID_TUNMSTR_S_PRESET_HANDLINGStart::setPI (uint32 PI_) {
    set_has_PI();
    this->_PI = PI_;
}

inline void FID_TUNMSTR_S_PRESET_HANDLINGStart::clearSecondaryPI() {
    if (hasSecondaryPI()) {
         clear_has_SecondaryPI();
        _SecondaryPI = 0u;
     }
}

inline bool FID_TUNMSTR_S_PRESET_HANDLINGStart::hasSecondaryPI () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint16 FID_TUNMSTR_S_PRESET_HANDLINGStart::getSecondaryPI () const {
    return _SecondaryPI;
}

inline void FID_TUNMSTR_S_PRESET_HANDLINGStart::setSecondaryPI (uint16 SecondaryPI_) {
    set_has_SecondaryPI();
    this->_SecondaryPI = SecondaryPI_;
}

inline void FID_TUNMSTR_S_PRESET_HANDLINGStart::set_has_Preset_Action () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUNMSTR_S_PRESET_HANDLINGStart::clear_has_Preset_Action () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void FID_TUNMSTR_S_PRESET_HANDLINGStart::set_has_u8Element_ID () {
    _has_bits_[0] |= 1u << 1;
}

inline void FID_TUNMSTR_S_PRESET_HANDLINGStart::clear_has_u8Element_ID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void FID_TUNMSTR_S_PRESET_HANDLINGStart::set_has_List () {
    _has_bits_[0] |= 1u << 2;
}

inline void FID_TUNMSTR_S_PRESET_HANDLINGStart::clear_has_List () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void FID_TUNMSTR_S_PRESET_HANDLINGStart::set_has_Band () {
    _has_bits_[0] |= 1u << 3;
}

inline void FID_TUNMSTR_S_PRESET_HANDLINGStart::clear_has_Band () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void FID_TUNMSTR_S_PRESET_HANDLINGStart::set_has_Frequency () {
    _has_bits_[0] |= 1u << 4;
}

inline void FID_TUNMSTR_S_PRESET_HANDLINGStart::clear_has_Frequency () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void FID_TUNMSTR_S_PRESET_HANDLINGStart::set_has_PI () {
    _has_bits_[0] |= 1u << 5;
}

inline void FID_TUNMSTR_S_PRESET_HANDLINGStart::clear_has_PI () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void FID_TUNMSTR_S_PRESET_HANDLINGStart::set_has_SecondaryPI () {
    _has_bits_[0] |= 1u << 6;
}

inline void FID_TUNMSTR_S_PRESET_HANDLINGStart::clear_has_SecondaryPI () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline  FID_TUNMSTR_S_PRESET_HANDLINGResult::FID_TUNMSTR_S_PRESET_HANDLINGResult ()  :
    _TunerMaster_StatusResponse (),
    _Source (::tunermaster_main_fi_types::T_e8_Source__TUN_MSTR_SOURCE_FM1),
    _Action (::tunermaster_main_fi_types::T_e8_Action__TUN_MSTR_PLAY),
    _Preset_Action (::tunermaster_main_fi_types::T_e8_Preset_Action__TUNMSTR_PresetRecall)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_PRESET_HANDLINGResult::FID_TUNMSTR_S_PRESET_HANDLINGResult (const FID_TUNMSTR_S_PRESET_HANDLINGResult &rhs)  :
    ::asf::core::Payload(rhs),
    _TunerMaster_StatusResponse (),
    _Source (::tunermaster_main_fi_types::T_e8_Source__TUN_MSTR_SOURCE_FM1),
    _Action (::tunermaster_main_fi_types::T_e8_Action__TUN_MSTR_PLAY),
    _Preset_Action (::tunermaster_main_fi_types::T_e8_Preset_Action__TUNMSTR_PresetRecall)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUNMSTR_S_PRESET_HANDLINGResult::FID_TUNMSTR_S_PRESET_HANDLINGResult (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_, ::tunermaster_main_fi_types::T_e8_Source Source_, ::tunermaster_main_fi_types::T_e8_Action Action_, ::tunermaster_main_fi_types::T_e8_Preset_Action Preset_Action_)  :
    _TunerMaster_StatusResponse (TunerMaster_StatusResponse_),
    _Source (Source_),
    _Action (Action_),
    _Preset_Action (Preset_Action_)
{
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_Source_IsValid(Source_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Source_, "T_e8_Source", "Source", "FID_TUNMSTR_S_PRESET_HANDLINGResult");
    }
    #endif
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_Action_IsValid(Action_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Action_, "T_e8_Action", "Action", "FID_TUNMSTR_S_PRESET_HANDLINGResult");
    }
    #endif
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_Preset_Action_IsValid(Preset_Action_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Preset_Action_, "T_e8_Preset_Action", "Preset_Action", "FID_TUNMSTR_S_PRESET_HANDLINGResult");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_PRESET_HANDLINGResult::~FID_TUNMSTR_S_PRESET_HANDLINGResult() {
}

inline FID_TUNMSTR_S_PRESET_HANDLINGResult& FID_TUNMSTR_S_PRESET_HANDLINGResult::operator = (const FID_TUNMSTR_S_PRESET_HANDLINGResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTunerMaster_StatusResponse()) {
            setTunerMaster_StatusResponse(rhs.getTunerMaster_StatusResponse());
        } else {
            clearTunerMaster_StatusResponse();
        }
        if (rhs.hasSource()) {
            setSource(rhs.getSource());
        } else {
            clearSource();
        }
        if (rhs.hasAction()) {
            setAction(rhs.getAction());
        } else {
            clearAction();
        }
        if (rhs.hasPreset_Action()) {
            setPreset_Action(rhs.getPreset_Action());
        } else {
            clearPreset_Action();
        }
    }
    return *this;
}

inline bool FID_TUNMSTR_S_PRESET_HANDLINGResult::operator == (const FID_TUNMSTR_S_PRESET_HANDLINGResult& rhs) const {
    return (((!hasTunerMaster_StatusResponse() && !rhs.hasTunerMaster_StatusResponse()) || getTunerMaster_StatusResponse() == rhs.getTunerMaster_StatusResponse()) &&
        ((!hasSource() && !rhs.hasSource()) || getSource() == rhs.getSource()) &&
        ((!hasAction() && !rhs.hasAction()) || getAction() == rhs.getAction()) &&
        ((!hasPreset_Action() && !rhs.hasPreset_Action()) || getPreset_Action() == rhs.getPreset_Action()));
}

inline bool FID_TUNMSTR_S_PRESET_HANDLINGResult::operator != (const FID_TUNMSTR_S_PRESET_HANDLINGResult& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUNMSTR_S_PRESET_HANDLINGResult::operator < (const FID_TUNMSTR_S_PRESET_HANDLINGResult& rhs) const {
    if (hasTunerMaster_StatusResponse() || rhs.hasTunerMaster_StatusResponse()) {
        if (getTunerMaster_StatusResponse() < rhs.getTunerMaster_StatusResponse()) return true;
        if (getTunerMaster_StatusResponse() > rhs.getTunerMaster_StatusResponse()) return false;
    }
    if (hasSource() || rhs.hasSource()) {
        if ((uint32)getSource() < (uint32)rhs.getSource()) return true;
        if ((uint32)getSource() > (uint32)rhs.getSource()) return false;
    }
    if (hasAction() || rhs.hasAction()) {
        if ((uint32)getAction() < (uint32)rhs.getAction()) return true;
        if ((uint32)getAction() > (uint32)rhs.getAction()) return false;
    }
    if (hasPreset_Action() || rhs.hasPreset_Action()) {
        if ((uint32)getPreset_Action() < (uint32)rhs.getPreset_Action()) return true;
        if ((uint32)getPreset_Action() > (uint32)rhs.getPreset_Action()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUNMSTR_S_PRESET_HANDLINGResult::clone() {
    return new FID_TUNMSTR_S_PRESET_HANDLINGResult(*this);
}

inline bool FID_TUNMSTR_S_PRESET_HANDLINGResult::operator > (const FID_TUNMSTR_S_PRESET_HANDLINGResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUNMSTR_S_PRESET_HANDLINGResult::clear() {
    clearTunerMaster_StatusResponse();
    clearSource();
    clearAction();
    clearPreset_Action();
}

inline void FID_TUNMSTR_S_PRESET_HANDLINGResult::clearTunerMaster_StatusResponse() {
    if (hasTunerMaster_StatusResponse()) {
         clear_has_TunerMaster_StatusResponse();
        _TunerMaster_StatusResponse.clear();
     }
}

inline bool FID_TUNMSTR_S_PRESET_HANDLINGResult::hasTunerMaster_StatusResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& FID_TUNMSTR_S_PRESET_HANDLINGResult::getTunerMaster_StatusResponse () const {
    return _TunerMaster_StatusResponse;
}

inline ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& FID_TUNMSTR_S_PRESET_HANDLINGResult::getTunerMaster_StatusResponseMutable () {
    set_has_TunerMaster_StatusResponse();
    return _TunerMaster_StatusResponse;
}

inline void FID_TUNMSTR_S_PRESET_HANDLINGResult::setTunerMaster_StatusResponse (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_) {
    set_has_TunerMaster_StatusResponse();
    this->_TunerMaster_StatusResponse = TunerMaster_StatusResponse_;
}

inline void FID_TUNMSTR_S_PRESET_HANDLINGResult::clearSource() {
    if (hasSource()) {
         clear_has_Source();
        _Source = ::tunermaster_main_fi_types::T_e8_Source__TUN_MSTR_SOURCE_FM1;
     }
}

inline bool FID_TUNMSTR_S_PRESET_HANDLINGResult::hasSource () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::tunermaster_main_fi_types::T_e8_Source FID_TUNMSTR_S_PRESET_HANDLINGResult::getSource () const {
    return _Source;
}

inline void FID_TUNMSTR_S_PRESET_HANDLINGResult::setSource (::tunermaster_main_fi_types::T_e8_Source Source_) {
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_Source_IsValid(Source_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Source_, "T_e8_Source", "Source", "FID_TUNMSTR_S_PRESET_HANDLINGResult");
    }
    #endif
    set_has_Source();
    this->_Source = Source_;
}

inline void FID_TUNMSTR_S_PRESET_HANDLINGResult::clearAction() {
    if (hasAction()) {
         clear_has_Action();
        _Action = ::tunermaster_main_fi_types::T_e8_Action__TUN_MSTR_PLAY;
     }
}

inline bool FID_TUNMSTR_S_PRESET_HANDLINGResult::hasAction () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline ::tunermaster_main_fi_types::T_e8_Action FID_TUNMSTR_S_PRESET_HANDLINGResult::getAction () const {
    return _Action;
}

inline void FID_TUNMSTR_S_PRESET_HANDLINGResult::setAction (::tunermaster_main_fi_types::T_e8_Action Action_) {
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_Action_IsValid(Action_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Action_, "T_e8_Action", "Action", "FID_TUNMSTR_S_PRESET_HANDLINGResult");
    }
    #endif
    set_has_Action();
    this->_Action = Action_;
}

inline void FID_TUNMSTR_S_PRESET_HANDLINGResult::clearPreset_Action() {
    if (hasPreset_Action()) {
         clear_has_Preset_Action();
        _Preset_Action = ::tunermaster_main_fi_types::T_e8_Preset_Action__TUNMSTR_PresetRecall;
     }
}

inline bool FID_TUNMSTR_S_PRESET_HANDLINGResult::hasPreset_Action () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline ::tunermaster_main_fi_types::T_e8_Preset_Action FID_TUNMSTR_S_PRESET_HANDLINGResult::getPreset_Action () const {
    return _Preset_Action;
}

inline void FID_TUNMSTR_S_PRESET_HANDLINGResult::setPreset_Action (::tunermaster_main_fi_types::T_e8_Preset_Action Preset_Action_) {
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_Preset_Action_IsValid(Preset_Action_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Preset_Action_, "T_e8_Preset_Action", "Preset_Action", "FID_TUNMSTR_S_PRESET_HANDLINGResult");
    }
    #endif
    set_has_Preset_Action();
    this->_Preset_Action = Preset_Action_;
}

inline void FID_TUNMSTR_S_PRESET_HANDLINGResult::set_has_TunerMaster_StatusResponse () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUNMSTR_S_PRESET_HANDLINGResult::clear_has_TunerMaster_StatusResponse () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void FID_TUNMSTR_S_PRESET_HANDLINGResult::set_has_Source () {
    _has_bits_[0] |= 1u << 1;
}

inline void FID_TUNMSTR_S_PRESET_HANDLINGResult::clear_has_Source () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void FID_TUNMSTR_S_PRESET_HANDLINGResult::set_has_Action () {
    _has_bits_[0] |= 1u << 2;
}

inline void FID_TUNMSTR_S_PRESET_HANDLINGResult::clear_has_Action () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void FID_TUNMSTR_S_PRESET_HANDLINGResult::set_has_Preset_Action () {
    _has_bits_[0] |= 1u << 3;
}

inline void FID_TUNMSTR_S_PRESET_HANDLINGResult::clear_has_Preset_Action () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  FID_TUNMSTR_S_AUTOSTOREStart::FID_TUNMSTR_S_AUTOSTOREStart ()  :
    _AutoStore_Start (false),
    _List (::tunermaster_main_fi_types::T_e8_List__BANK_FM1),
    _AST_Type (::tunermaster_main_fi_types::T_e8_AST_Types__NORMAL_AST)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_AUTOSTOREStart::FID_TUNMSTR_S_AUTOSTOREStart (const FID_TUNMSTR_S_AUTOSTOREStart &rhs)  :
    ::asf::core::Payload(rhs),
    _AutoStore_Start (false),
    _List (::tunermaster_main_fi_types::T_e8_List__BANK_FM1),
    _AST_Type (::tunermaster_main_fi_types::T_e8_AST_Types__NORMAL_AST)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUNMSTR_S_AUTOSTOREStart::FID_TUNMSTR_S_AUTOSTOREStart (bool AutoStore_Start_, ::tunermaster_main_fi_types::T_e8_List List_, ::tunermaster_main_fi_types::T_e8_AST_Types AST_Type_)  :
    _AutoStore_Start (AutoStore_Start_),
    _List (List_),
    _AST_Type (AST_Type_)
{
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_List_IsValid(List_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", List_, "T_e8_List", "List", "FID_TUNMSTR_S_AUTOSTOREStart");
    }
    #endif
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_AST_Types_IsValid(AST_Type_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", AST_Type_, "T_e8_AST_Types", "AST_Type", "FID_TUNMSTR_S_AUTOSTOREStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_AUTOSTOREStart::~FID_TUNMSTR_S_AUTOSTOREStart() {
}

inline FID_TUNMSTR_S_AUTOSTOREStart& FID_TUNMSTR_S_AUTOSTOREStart::operator = (const FID_TUNMSTR_S_AUTOSTOREStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAutoStore_Start()) {
            setAutoStore_Start(rhs.getAutoStore_Start());
        } else {
            clearAutoStore_Start();
        }
        if (rhs.hasList()) {
            setList(rhs.getList());
        } else {
            clearList();
        }
        if (rhs.hasAST_Type()) {
            setAST_Type(rhs.getAST_Type());
        } else {
            clearAST_Type();
        }
    }
    return *this;
}

inline bool FID_TUNMSTR_S_AUTOSTOREStart::operator == (const FID_TUNMSTR_S_AUTOSTOREStart& rhs) const {
    return (((!hasAutoStore_Start() && !rhs.hasAutoStore_Start()) || getAutoStore_Start() == rhs.getAutoStore_Start()) &&
        ((!hasList() && !rhs.hasList()) || getList() == rhs.getList()) &&
        ((!hasAST_Type() && !rhs.hasAST_Type()) || getAST_Type() == rhs.getAST_Type()));
}

inline bool FID_TUNMSTR_S_AUTOSTOREStart::operator != (const FID_TUNMSTR_S_AUTOSTOREStart& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUNMSTR_S_AUTOSTOREStart::operator < (const FID_TUNMSTR_S_AUTOSTOREStart& rhs) const {
    if (hasAutoStore_Start() || rhs.hasAutoStore_Start()) {
        if (getAutoStore_Start() < rhs.getAutoStore_Start()) return true;
        if (getAutoStore_Start() > rhs.getAutoStore_Start()) return false;
    }
    if (hasList() || rhs.hasList()) {
        if ((uint32)getList() < (uint32)rhs.getList()) return true;
        if ((uint32)getList() > (uint32)rhs.getList()) return false;
    }
    if (hasAST_Type() || rhs.hasAST_Type()) {
        if ((uint32)getAST_Type() < (uint32)rhs.getAST_Type()) return true;
        if ((uint32)getAST_Type() > (uint32)rhs.getAST_Type()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUNMSTR_S_AUTOSTOREStart::clone() {
    return new FID_TUNMSTR_S_AUTOSTOREStart(*this);
}

inline bool FID_TUNMSTR_S_AUTOSTOREStart::operator > (const FID_TUNMSTR_S_AUTOSTOREStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUNMSTR_S_AUTOSTOREStart::clear() {
    clearAutoStore_Start();
    clearList();
    clearAST_Type();
}

inline void FID_TUNMSTR_S_AUTOSTOREStart::clearAutoStore_Start() {
    if (hasAutoStore_Start()) {
         clear_has_AutoStore_Start();
        _AutoStore_Start = false;
     }
}

inline bool FID_TUNMSTR_S_AUTOSTOREStart::hasAutoStore_Start () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool FID_TUNMSTR_S_AUTOSTOREStart::getAutoStore_Start () const {
    return _AutoStore_Start;
}

inline void FID_TUNMSTR_S_AUTOSTOREStart::setAutoStore_Start (bool AutoStore_Start_) {
    set_has_AutoStore_Start();
    this->_AutoStore_Start = AutoStore_Start_;
}

inline void FID_TUNMSTR_S_AUTOSTOREStart::clearList() {
    if (hasList()) {
         clear_has_List();
        _List = ::tunermaster_main_fi_types::T_e8_List__BANK_FM1;
     }
}

inline bool FID_TUNMSTR_S_AUTOSTOREStart::hasList () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::tunermaster_main_fi_types::T_e8_List FID_TUNMSTR_S_AUTOSTOREStart::getList () const {
    return _List;
}

inline void FID_TUNMSTR_S_AUTOSTOREStart::setList (::tunermaster_main_fi_types::T_e8_List List_) {
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_List_IsValid(List_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", List_, "T_e8_List", "List", "FID_TUNMSTR_S_AUTOSTOREStart");
    }
    #endif
    set_has_List();
    this->_List = List_;
}

inline void FID_TUNMSTR_S_AUTOSTOREStart::clearAST_Type() {
    if (hasAST_Type()) {
         clear_has_AST_Type();
        _AST_Type = ::tunermaster_main_fi_types::T_e8_AST_Types__NORMAL_AST;
     }
}

inline bool FID_TUNMSTR_S_AUTOSTOREStart::hasAST_Type () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline ::tunermaster_main_fi_types::T_e8_AST_Types FID_TUNMSTR_S_AUTOSTOREStart::getAST_Type () const {
    return _AST_Type;
}

inline void FID_TUNMSTR_S_AUTOSTOREStart::setAST_Type (::tunermaster_main_fi_types::T_e8_AST_Types AST_Type_) {
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_AST_Types_IsValid(AST_Type_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", AST_Type_, "T_e8_AST_Types", "AST_Type", "FID_TUNMSTR_S_AUTOSTOREStart");
    }
    #endif
    set_has_AST_Type();
    this->_AST_Type = AST_Type_;
}

inline void FID_TUNMSTR_S_AUTOSTOREStart::set_has_AutoStore_Start () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUNMSTR_S_AUTOSTOREStart::clear_has_AutoStore_Start () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void FID_TUNMSTR_S_AUTOSTOREStart::set_has_List () {
    _has_bits_[0] |= 1u << 1;
}

inline void FID_TUNMSTR_S_AUTOSTOREStart::clear_has_List () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void FID_TUNMSTR_S_AUTOSTOREStart::set_has_AST_Type () {
    _has_bits_[0] |= 1u << 2;
}

inline void FID_TUNMSTR_S_AUTOSTOREStart::clear_has_AST_Type () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  FID_TUNMSTR_S_AUTOSTOREResult::FID_TUNMSTR_S_AUTOSTOREResult ()  :
    _TunerMaster_StatusResponse (),
    _Source (::tunermaster_main_fi_types::T_e8_Source__TUN_MSTR_SOURCE_FM1),
    _Action (::tunermaster_main_fi_types::T_e8_Action__TUN_MSTR_PLAY)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_AUTOSTOREResult::FID_TUNMSTR_S_AUTOSTOREResult (const FID_TUNMSTR_S_AUTOSTOREResult &rhs)  :
    ::asf::core::Payload(rhs),
    _TunerMaster_StatusResponse (),
    _Source (::tunermaster_main_fi_types::T_e8_Source__TUN_MSTR_SOURCE_FM1),
    _Action (::tunermaster_main_fi_types::T_e8_Action__TUN_MSTR_PLAY)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUNMSTR_S_AUTOSTOREResult::FID_TUNMSTR_S_AUTOSTOREResult (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_, ::tunermaster_main_fi_types::T_e8_Source Source_, ::tunermaster_main_fi_types::T_e8_Action Action_)  :
    _TunerMaster_StatusResponse (TunerMaster_StatusResponse_),
    _Source (Source_),
    _Action (Action_)
{
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_Source_IsValid(Source_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Source_, "T_e8_Source", "Source", "FID_TUNMSTR_S_AUTOSTOREResult");
    }
    #endif
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_Action_IsValid(Action_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Action_, "T_e8_Action", "Action", "FID_TUNMSTR_S_AUTOSTOREResult");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_AUTOSTOREResult::~FID_TUNMSTR_S_AUTOSTOREResult() {
}

inline FID_TUNMSTR_S_AUTOSTOREResult& FID_TUNMSTR_S_AUTOSTOREResult::operator = (const FID_TUNMSTR_S_AUTOSTOREResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTunerMaster_StatusResponse()) {
            setTunerMaster_StatusResponse(rhs.getTunerMaster_StatusResponse());
        } else {
            clearTunerMaster_StatusResponse();
        }
        if (rhs.hasSource()) {
            setSource(rhs.getSource());
        } else {
            clearSource();
        }
        if (rhs.hasAction()) {
            setAction(rhs.getAction());
        } else {
            clearAction();
        }
    }
    return *this;
}

inline bool FID_TUNMSTR_S_AUTOSTOREResult::operator == (const FID_TUNMSTR_S_AUTOSTOREResult& rhs) const {
    return (((!hasTunerMaster_StatusResponse() && !rhs.hasTunerMaster_StatusResponse()) || getTunerMaster_StatusResponse() == rhs.getTunerMaster_StatusResponse()) &&
        ((!hasSource() && !rhs.hasSource()) || getSource() == rhs.getSource()) &&
        ((!hasAction() && !rhs.hasAction()) || getAction() == rhs.getAction()));
}

inline bool FID_TUNMSTR_S_AUTOSTOREResult::operator != (const FID_TUNMSTR_S_AUTOSTOREResult& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUNMSTR_S_AUTOSTOREResult::operator < (const FID_TUNMSTR_S_AUTOSTOREResult& rhs) const {
    if (hasTunerMaster_StatusResponse() || rhs.hasTunerMaster_StatusResponse()) {
        if (getTunerMaster_StatusResponse() < rhs.getTunerMaster_StatusResponse()) return true;
        if (getTunerMaster_StatusResponse() > rhs.getTunerMaster_StatusResponse()) return false;
    }
    if (hasSource() || rhs.hasSource()) {
        if ((uint32)getSource() < (uint32)rhs.getSource()) return true;
        if ((uint32)getSource() > (uint32)rhs.getSource()) return false;
    }
    if (hasAction() || rhs.hasAction()) {
        if ((uint32)getAction() < (uint32)rhs.getAction()) return true;
        if ((uint32)getAction() > (uint32)rhs.getAction()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUNMSTR_S_AUTOSTOREResult::clone() {
    return new FID_TUNMSTR_S_AUTOSTOREResult(*this);
}

inline bool FID_TUNMSTR_S_AUTOSTOREResult::operator > (const FID_TUNMSTR_S_AUTOSTOREResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUNMSTR_S_AUTOSTOREResult::clear() {
    clearTunerMaster_StatusResponse();
    clearSource();
    clearAction();
}

inline void FID_TUNMSTR_S_AUTOSTOREResult::clearTunerMaster_StatusResponse() {
    if (hasTunerMaster_StatusResponse()) {
         clear_has_TunerMaster_StatusResponse();
        _TunerMaster_StatusResponse.clear();
     }
}

inline bool FID_TUNMSTR_S_AUTOSTOREResult::hasTunerMaster_StatusResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& FID_TUNMSTR_S_AUTOSTOREResult::getTunerMaster_StatusResponse () const {
    return _TunerMaster_StatusResponse;
}

inline ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& FID_TUNMSTR_S_AUTOSTOREResult::getTunerMaster_StatusResponseMutable () {
    set_has_TunerMaster_StatusResponse();
    return _TunerMaster_StatusResponse;
}

inline void FID_TUNMSTR_S_AUTOSTOREResult::setTunerMaster_StatusResponse (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_) {
    set_has_TunerMaster_StatusResponse();
    this->_TunerMaster_StatusResponse = TunerMaster_StatusResponse_;
}

inline void FID_TUNMSTR_S_AUTOSTOREResult::clearSource() {
    if (hasSource()) {
         clear_has_Source();
        _Source = ::tunermaster_main_fi_types::T_e8_Source__TUN_MSTR_SOURCE_FM1;
     }
}

inline bool FID_TUNMSTR_S_AUTOSTOREResult::hasSource () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::tunermaster_main_fi_types::T_e8_Source FID_TUNMSTR_S_AUTOSTOREResult::getSource () const {
    return _Source;
}

inline void FID_TUNMSTR_S_AUTOSTOREResult::setSource (::tunermaster_main_fi_types::T_e8_Source Source_) {
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_Source_IsValid(Source_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Source_, "T_e8_Source", "Source", "FID_TUNMSTR_S_AUTOSTOREResult");
    }
    #endif
    set_has_Source();
    this->_Source = Source_;
}

inline void FID_TUNMSTR_S_AUTOSTOREResult::clearAction() {
    if (hasAction()) {
         clear_has_Action();
        _Action = ::tunermaster_main_fi_types::T_e8_Action__TUN_MSTR_PLAY;
     }
}

inline bool FID_TUNMSTR_S_AUTOSTOREResult::hasAction () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline ::tunermaster_main_fi_types::T_e8_Action FID_TUNMSTR_S_AUTOSTOREResult::getAction () const {
    return _Action;
}

inline void FID_TUNMSTR_S_AUTOSTOREResult::setAction (::tunermaster_main_fi_types::T_e8_Action Action_) {
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_Action_IsValid(Action_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Action_, "T_e8_Action", "Action", "FID_TUNMSTR_S_AUTOSTOREResult");
    }
    #endif
    set_has_Action();
    this->_Action = Action_;
}

inline void FID_TUNMSTR_S_AUTOSTOREResult::set_has_TunerMaster_StatusResponse () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUNMSTR_S_AUTOSTOREResult::clear_has_TunerMaster_StatusResponse () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void FID_TUNMSTR_S_AUTOSTOREResult::set_has_Source () {
    _has_bits_[0] |= 1u << 1;
}

inline void FID_TUNMSTR_S_AUTOSTOREResult::clear_has_Source () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void FID_TUNMSTR_S_AUTOSTOREResult::set_has_Action () {
    _has_bits_[0] |= 1u << 2;
}

inline void FID_TUNMSTR_S_AUTOSTOREResult::clear_has_Action () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  FID_TUNMSTR_S_MTC_SETMODEStart::FID_TUNMSTR_S_MTC_SETMODEStart ()  :
    _Mode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_MTC_SETMODEStart::FID_TUNMSTR_S_MTC_SETMODEStart (const FID_TUNMSTR_S_MTC_SETMODEStart &rhs)  :
    ::asf::core::Payload(rhs),
    _Mode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUNMSTR_S_MTC_SETMODEStart::FID_TUNMSTR_S_MTC_SETMODEStart (const ::tunermaster_main_fi_types::T_b8_ModeType& Mode_)  :
    _Mode (Mode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_MTC_SETMODEStart::~FID_TUNMSTR_S_MTC_SETMODEStart() {
}

inline FID_TUNMSTR_S_MTC_SETMODEStart& FID_TUNMSTR_S_MTC_SETMODEStart::operator = (const FID_TUNMSTR_S_MTC_SETMODEStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMode()) {
            setMode(rhs.getMode());
        } else {
            clearMode();
        }
    }
    return *this;
}

inline bool FID_TUNMSTR_S_MTC_SETMODEStart::operator == (const FID_TUNMSTR_S_MTC_SETMODEStart& rhs) const {
    return (((!hasMode() && !rhs.hasMode()) || getMode() == rhs.getMode()));
}

inline bool FID_TUNMSTR_S_MTC_SETMODEStart::operator != (const FID_TUNMSTR_S_MTC_SETMODEStart& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUNMSTR_S_MTC_SETMODEStart::operator < (const FID_TUNMSTR_S_MTC_SETMODEStart& rhs) const {
    if (hasMode() || rhs.hasMode()) {
        if (getMode() < rhs.getMode()) return true;
        if (getMode() > rhs.getMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUNMSTR_S_MTC_SETMODEStart::clone() {
    return new FID_TUNMSTR_S_MTC_SETMODEStart(*this);
}

inline bool FID_TUNMSTR_S_MTC_SETMODEStart::operator > (const FID_TUNMSTR_S_MTC_SETMODEStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUNMSTR_S_MTC_SETMODEStart::clear() {
    clearMode();
}

inline void FID_TUNMSTR_S_MTC_SETMODEStart::clearMode() {
    if (hasMode()) {
         clear_has_Mode();
        _Mode = ::tunermaster_main_fi_types::T_b8_ModeType ();
     }
}

inline bool FID_TUNMSTR_S_MTC_SETMODEStart::hasMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::tunermaster_main_fi_types::T_b8_ModeType& FID_TUNMSTR_S_MTC_SETMODEStart::getMode () const {
    return _Mode;
}

inline ::tunermaster_main_fi_types::T_b8_ModeType& FID_TUNMSTR_S_MTC_SETMODEStart::getModeMutable () {
    set_has_Mode();
    return _Mode;
}

inline void FID_TUNMSTR_S_MTC_SETMODEStart::setMode (const ::tunermaster_main_fi_types::T_b8_ModeType& Mode_) {
    set_has_Mode();
    this->_Mode = Mode_;
}

inline void FID_TUNMSTR_S_MTC_SETMODEStart::set_has_Mode () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUNMSTR_S_MTC_SETMODEStart::clear_has_Mode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FID_TUNMSTR_S_MTC_SETMODEResult::FID_TUNMSTR_S_MTC_SETMODEResult ()  :
    _TunerMaster_StatusResponse ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_MTC_SETMODEResult::FID_TUNMSTR_S_MTC_SETMODEResult (const FID_TUNMSTR_S_MTC_SETMODEResult &rhs)  :
    ::asf::core::Payload(rhs),
    _TunerMaster_StatusResponse ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUNMSTR_S_MTC_SETMODEResult::FID_TUNMSTR_S_MTC_SETMODEResult (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_)  :
    _TunerMaster_StatusResponse (TunerMaster_StatusResponse_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_MTC_SETMODEResult::~FID_TUNMSTR_S_MTC_SETMODEResult() {
}

inline FID_TUNMSTR_S_MTC_SETMODEResult& FID_TUNMSTR_S_MTC_SETMODEResult::operator = (const FID_TUNMSTR_S_MTC_SETMODEResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTunerMaster_StatusResponse()) {
            setTunerMaster_StatusResponse(rhs.getTunerMaster_StatusResponse());
        } else {
            clearTunerMaster_StatusResponse();
        }
    }
    return *this;
}

inline bool FID_TUNMSTR_S_MTC_SETMODEResult::operator == (const FID_TUNMSTR_S_MTC_SETMODEResult& rhs) const {
    return (((!hasTunerMaster_StatusResponse() && !rhs.hasTunerMaster_StatusResponse()) || getTunerMaster_StatusResponse() == rhs.getTunerMaster_StatusResponse()));
}

inline bool FID_TUNMSTR_S_MTC_SETMODEResult::operator != (const FID_TUNMSTR_S_MTC_SETMODEResult& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUNMSTR_S_MTC_SETMODEResult::operator < (const FID_TUNMSTR_S_MTC_SETMODEResult& rhs) const {
    if (hasTunerMaster_StatusResponse() || rhs.hasTunerMaster_StatusResponse()) {
        if (getTunerMaster_StatusResponse() < rhs.getTunerMaster_StatusResponse()) return true;
        if (getTunerMaster_StatusResponse() > rhs.getTunerMaster_StatusResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUNMSTR_S_MTC_SETMODEResult::clone() {
    return new FID_TUNMSTR_S_MTC_SETMODEResult(*this);
}

inline bool FID_TUNMSTR_S_MTC_SETMODEResult::operator > (const FID_TUNMSTR_S_MTC_SETMODEResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUNMSTR_S_MTC_SETMODEResult::clear() {
    clearTunerMaster_StatusResponse();
}

inline void FID_TUNMSTR_S_MTC_SETMODEResult::clearTunerMaster_StatusResponse() {
    if (hasTunerMaster_StatusResponse()) {
         clear_has_TunerMaster_StatusResponse();
        _TunerMaster_StatusResponse.clear();
     }
}

inline bool FID_TUNMSTR_S_MTC_SETMODEResult::hasTunerMaster_StatusResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& FID_TUNMSTR_S_MTC_SETMODEResult::getTunerMaster_StatusResponse () const {
    return _TunerMaster_StatusResponse;
}

inline ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& FID_TUNMSTR_S_MTC_SETMODEResult::getTunerMaster_StatusResponseMutable () {
    set_has_TunerMaster_StatusResponse();
    return _TunerMaster_StatusResponse;
}

inline void FID_TUNMSTR_S_MTC_SETMODEResult::setTunerMaster_StatusResponse (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_) {
    set_has_TunerMaster_StatusResponse();
    this->_TunerMaster_StatusResponse = TunerMaster_StatusResponse_;
}

inline void FID_TUNMSTR_S_MTC_SETMODEResult::set_has_TunerMaster_StatusResponse () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUNMSTR_S_MTC_SETMODEResult::clear_has_TunerMaster_StatusResponse () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYStart::FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYStart ()  :
    _u32Frequency (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYStart::FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYStart (const FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYStart &rhs)  :
    ::asf::core::Payload(rhs),
    _u32Frequency (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYStart::FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYStart (uint32 u32Frequency_)  :
    _u32Frequency (u32Frequency_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYStart::~FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYStart() {
}

inline FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYStart& FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYStart::operator = (const FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasU32Frequency()) {
            setU32Frequency(rhs.getU32Frequency());
        } else {
            clearU32Frequency();
        }
    }
    return *this;
}

inline bool FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYStart::operator == (const FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYStart& rhs) const {
    return (((!hasU32Frequency() && !rhs.hasU32Frequency()) || getU32Frequency() == rhs.getU32Frequency()));
}

inline bool FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYStart::operator != (const FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYStart& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYStart::operator < (const FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYStart& rhs) const {
    if (hasU32Frequency() || rhs.hasU32Frequency()) {
        if (getU32Frequency() < rhs.getU32Frequency()) return true;
        if (getU32Frequency() > rhs.getU32Frequency()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYStart::clone() {
    return new FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYStart(*this);
}

inline bool FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYStart::operator > (const FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYStart::clear() {
    clearU32Frequency();
}

inline void FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYStart::clearU32Frequency() {
    if (hasU32Frequency()) {
         clear_has_u32Frequency();
        _u32Frequency = 0u;
     }
}

inline bool FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYStart::hasU32Frequency () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYStart::getU32Frequency () const {
    return _u32Frequency;
}

inline void FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYStart::setU32Frequency (uint32 u32Frequency_) {
    set_has_u32Frequency();
    this->_u32Frequency = u32Frequency_;
}

inline void FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYStart::set_has_u32Frequency () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYStart::clear_has_u32Frequency () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYResult::FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYResult ()  :
    _TunerMaster_StatusResponse ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYResult::FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYResult (const FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYResult &rhs)  :
    ::asf::core::Payload(rhs),
    _TunerMaster_StatusResponse ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYResult::FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYResult (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_)  :
    _TunerMaster_StatusResponse (TunerMaster_StatusResponse_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYResult::~FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYResult() {
}

inline FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYResult& FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYResult::operator = (const FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTunerMaster_StatusResponse()) {
            setTunerMaster_StatusResponse(rhs.getTunerMaster_StatusResponse());
        } else {
            clearTunerMaster_StatusResponse();
        }
    }
    return *this;
}

inline bool FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYResult::operator == (const FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYResult& rhs) const {
    return (((!hasTunerMaster_StatusResponse() && !rhs.hasTunerMaster_StatusResponse()) || getTunerMaster_StatusResponse() == rhs.getTunerMaster_StatusResponse()));
}

inline bool FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYResult::operator != (const FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYResult& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYResult::operator < (const FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYResult& rhs) const {
    if (hasTunerMaster_StatusResponse() || rhs.hasTunerMaster_StatusResponse()) {
        if (getTunerMaster_StatusResponse() < rhs.getTunerMaster_StatusResponse()) return true;
        if (getTunerMaster_StatusResponse() > rhs.getTunerMaster_StatusResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYResult::clone() {
    return new FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYResult(*this);
}

inline bool FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYResult::operator > (const FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYResult::clear() {
    clearTunerMaster_StatusResponse();
}

inline void FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYResult::clearTunerMaster_StatusResponse() {
    if (hasTunerMaster_StatusResponse()) {
         clear_has_TunerMaster_StatusResponse();
        _TunerMaster_StatusResponse.clear();
     }
}

inline bool FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYResult::hasTunerMaster_StatusResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYResult::getTunerMaster_StatusResponse () const {
    return _TunerMaster_StatusResponse;
}

inline ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYResult::getTunerMaster_StatusResponseMutable () {
    set_has_TunerMaster_StatusResponse();
    return _TunerMaster_StatusResponse;
}

inline void FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYResult::setTunerMaster_StatusResponse (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_) {
    set_has_TunerMaster_StatusResponse();
    this->_TunerMaster_StatusResponse = TunerMaster_StatusResponse_;
}

inline void FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYResult::set_has_TunerMaster_StatusResponse () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUNMSTR_S_DRM_SDS_DIRECT_FREQUENCYResult::clear_has_TunerMaster_StatusResponse () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FID_TUNMSTR_S_STATION_SELECTIONStart::FID_TUNMSTR_S_STATION_SELECTIONStart ()  :
    _Option (::tunermaster_main_fi_types::T_e8_StationSelection_Option__Frequency_Input),
    _Band (::tunermaster_main_fi_types::T_e8_Band__TUN_MSTR_BAND_FM),
    _Frequency (0u),
    _u8Element_ID (0u),
    _List (::tunermaster_main_fi_types::T_e8_List__BANK_FM1),
    _PI (0u),
    _SecondaryPI (0u),
    _ModulationType (::tunermaster_main_fi_types::T_e8_ModulationType__TUN_MSTR_MODULATION_ANALOG),
    _HDProgramNumber (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_STATION_SELECTIONStart::FID_TUNMSTR_S_STATION_SELECTIONStart (const FID_TUNMSTR_S_STATION_SELECTIONStart &rhs)  :
    ::asf::core::Payload(rhs),
    _Option (::tunermaster_main_fi_types::T_e8_StationSelection_Option__Frequency_Input),
    _Band (::tunermaster_main_fi_types::T_e8_Band__TUN_MSTR_BAND_FM),
    _Frequency (0u),
    _u8Element_ID (0u),
    _List (::tunermaster_main_fi_types::T_e8_List__BANK_FM1),
    _PI (0u),
    _SecondaryPI (0u),
    _ModulationType (::tunermaster_main_fi_types::T_e8_ModulationType__TUN_MSTR_MODULATION_ANALOG),
    _HDProgramNumber (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUNMSTR_S_STATION_SELECTIONStart::FID_TUNMSTR_S_STATION_SELECTIONStart (::tunermaster_main_fi_types::T_e8_StationSelection_Option Option_, ::tunermaster_main_fi_types::T_e8_Band Band_, uint32 Frequency_, uint8 u8Element_ID_, ::tunermaster_main_fi_types::T_e8_List List_, uint32 PI_, uint16 SecondaryPI_, ::tunermaster_main_fi_types::T_e8_ModulationType ModulationType_, uint8 HDProgramNumber_)  :
    _Option (Option_),
    _Band (Band_),
    _Frequency (Frequency_),
    _u8Element_ID (u8Element_ID_),
    _List (List_),
    _PI (PI_),
    _SecondaryPI (SecondaryPI_),
    _ModulationType (ModulationType_),
    _HDProgramNumber (HDProgramNumber_)
{
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_StationSelection_Option_IsValid(Option_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Option_, "T_e8_StationSelection_Option", "Option", "FID_TUNMSTR_S_STATION_SELECTIONStart");
    }
    #endif
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_Band_IsValid(Band_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Band_, "T_e8_Band", "Band", "FID_TUNMSTR_S_STATION_SELECTIONStart");
    }
    #endif
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_List_IsValid(List_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", List_, "T_e8_List", "List", "FID_TUNMSTR_S_STATION_SELECTIONStart");
    }
    #endif
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_ModulationType_IsValid(ModulationType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ModulationType_, "T_e8_ModulationType", "ModulationType", "FID_TUNMSTR_S_STATION_SELECTIONStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_STATION_SELECTIONStart::~FID_TUNMSTR_S_STATION_SELECTIONStart() {
}

inline FID_TUNMSTR_S_STATION_SELECTIONStart& FID_TUNMSTR_S_STATION_SELECTIONStart::operator = (const FID_TUNMSTR_S_STATION_SELECTIONStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasOption()) {
            setOption(rhs.getOption());
        } else {
            clearOption();
        }
        if (rhs.hasBand()) {
            setBand(rhs.getBand());
        } else {
            clearBand();
        }
        if (rhs.hasFrequency()) {
            setFrequency(rhs.getFrequency());
        } else {
            clearFrequency();
        }
        if (rhs.hasU8Element_ID()) {
            setU8Element_ID(rhs.getU8Element_ID());
        } else {
            clearU8Element_ID();
        }
        if (rhs.hasList()) {
            setList(rhs.getList());
        } else {
            clearList();
        }
        if (rhs.hasPI()) {
            setPI(rhs.getPI());
        } else {
            clearPI();
        }
        if (rhs.hasSecondaryPI()) {
            setSecondaryPI(rhs.getSecondaryPI());
        } else {
            clearSecondaryPI();
        }
        if (rhs.hasModulationType()) {
            setModulationType(rhs.getModulationType());
        } else {
            clearModulationType();
        }
        if (rhs.hasHDProgramNumber()) {
            setHDProgramNumber(rhs.getHDProgramNumber());
        } else {
            clearHDProgramNumber();
        }
    }
    return *this;
}

inline bool FID_TUNMSTR_S_STATION_SELECTIONStart::operator == (const FID_TUNMSTR_S_STATION_SELECTIONStart& rhs) const {
    return (((!hasOption() && !rhs.hasOption()) || getOption() == rhs.getOption()) &&
        ((!hasBand() && !rhs.hasBand()) || getBand() == rhs.getBand()) &&
        ((!hasFrequency() && !rhs.hasFrequency()) || getFrequency() == rhs.getFrequency()) &&
        ((!hasU8Element_ID() && !rhs.hasU8Element_ID()) || getU8Element_ID() == rhs.getU8Element_ID()) &&
        ((!hasList() && !rhs.hasList()) || getList() == rhs.getList()) &&
        ((!hasPI() && !rhs.hasPI()) || getPI() == rhs.getPI()) &&
        ((!hasSecondaryPI() && !rhs.hasSecondaryPI()) || getSecondaryPI() == rhs.getSecondaryPI()) &&
        ((!hasModulationType() && !rhs.hasModulationType()) || getModulationType() == rhs.getModulationType()) &&
        ((!hasHDProgramNumber() && !rhs.hasHDProgramNumber()) || getHDProgramNumber() == rhs.getHDProgramNumber()));
}

inline bool FID_TUNMSTR_S_STATION_SELECTIONStart::operator != (const FID_TUNMSTR_S_STATION_SELECTIONStart& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUNMSTR_S_STATION_SELECTIONStart::operator < (const FID_TUNMSTR_S_STATION_SELECTIONStart& rhs) const {
    if (hasOption() || rhs.hasOption()) {
        if ((uint32)getOption() < (uint32)rhs.getOption()) return true;
        if ((uint32)getOption() > (uint32)rhs.getOption()) return false;
    }
    if (hasBand() || rhs.hasBand()) {
        if ((uint32)getBand() < (uint32)rhs.getBand()) return true;
        if ((uint32)getBand() > (uint32)rhs.getBand()) return false;
    }
    if (hasFrequency() || rhs.hasFrequency()) {
        if (getFrequency() < rhs.getFrequency()) return true;
        if (getFrequency() > rhs.getFrequency()) return false;
    }
    if (hasU8Element_ID() || rhs.hasU8Element_ID()) {
        if (getU8Element_ID() < rhs.getU8Element_ID()) return true;
        if (getU8Element_ID() > rhs.getU8Element_ID()) return false;
    }
    if (hasList() || rhs.hasList()) {
        if ((uint32)getList() < (uint32)rhs.getList()) return true;
        if ((uint32)getList() > (uint32)rhs.getList()) return false;
    }
    if (hasPI() || rhs.hasPI()) {
        if (getPI() < rhs.getPI()) return true;
        if (getPI() > rhs.getPI()) return false;
    }
    if (hasSecondaryPI() || rhs.hasSecondaryPI()) {
        if (getSecondaryPI() < rhs.getSecondaryPI()) return true;
        if (getSecondaryPI() > rhs.getSecondaryPI()) return false;
    }
    if (hasModulationType() || rhs.hasModulationType()) {
        if ((uint32)getModulationType() < (uint32)rhs.getModulationType()) return true;
        if ((uint32)getModulationType() > (uint32)rhs.getModulationType()) return false;
    }
    if (hasHDProgramNumber() || rhs.hasHDProgramNumber()) {
        if (getHDProgramNumber() < rhs.getHDProgramNumber()) return true;
        if (getHDProgramNumber() > rhs.getHDProgramNumber()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUNMSTR_S_STATION_SELECTIONStart::clone() {
    return new FID_TUNMSTR_S_STATION_SELECTIONStart(*this);
}

inline bool FID_TUNMSTR_S_STATION_SELECTIONStart::operator > (const FID_TUNMSTR_S_STATION_SELECTIONStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUNMSTR_S_STATION_SELECTIONStart::clear() {
    clearOption();
    clearBand();
    clearFrequency();
    clearU8Element_ID();
    clearList();
    clearPI();
    clearSecondaryPI();
    clearModulationType();
    clearHDProgramNumber();
}

inline void FID_TUNMSTR_S_STATION_SELECTIONStart::clearOption() {
    if (hasOption()) {
         clear_has_Option();
        _Option = ::tunermaster_main_fi_types::T_e8_StationSelection_Option__Frequency_Input;
     }
}

inline bool FID_TUNMSTR_S_STATION_SELECTIONStart::hasOption () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::tunermaster_main_fi_types::T_e8_StationSelection_Option FID_TUNMSTR_S_STATION_SELECTIONStart::getOption () const {
    return _Option;
}

inline void FID_TUNMSTR_S_STATION_SELECTIONStart::setOption (::tunermaster_main_fi_types::T_e8_StationSelection_Option Option_) {
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_StationSelection_Option_IsValid(Option_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Option_, "T_e8_StationSelection_Option", "Option", "FID_TUNMSTR_S_STATION_SELECTIONStart");
    }
    #endif
    set_has_Option();
    this->_Option = Option_;
}

inline void FID_TUNMSTR_S_STATION_SELECTIONStart::clearBand() {
    if (hasBand()) {
         clear_has_Band();
        _Band = ::tunermaster_main_fi_types::T_e8_Band__TUN_MSTR_BAND_FM;
     }
}

inline bool FID_TUNMSTR_S_STATION_SELECTIONStart::hasBand () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::tunermaster_main_fi_types::T_e8_Band FID_TUNMSTR_S_STATION_SELECTIONStart::getBand () const {
    return _Band;
}

inline void FID_TUNMSTR_S_STATION_SELECTIONStart::setBand (::tunermaster_main_fi_types::T_e8_Band Band_) {
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_Band_IsValid(Band_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Band_, "T_e8_Band", "Band", "FID_TUNMSTR_S_STATION_SELECTIONStart");
    }
    #endif
    set_has_Band();
    this->_Band = Band_;
}

inline void FID_TUNMSTR_S_STATION_SELECTIONStart::clearFrequency() {
    if (hasFrequency()) {
         clear_has_Frequency();
        _Frequency = 0u;
     }
}

inline bool FID_TUNMSTR_S_STATION_SELECTIONStart::hasFrequency () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 FID_TUNMSTR_S_STATION_SELECTIONStart::getFrequency () const {
    return _Frequency;
}

inline void FID_TUNMSTR_S_STATION_SELECTIONStart::setFrequency (uint32 Frequency_) {
    set_has_Frequency();
    this->_Frequency = Frequency_;
}

inline void FID_TUNMSTR_S_STATION_SELECTIONStart::clearU8Element_ID() {
    if (hasU8Element_ID()) {
         clear_has_u8Element_ID();
        _u8Element_ID = 0u;
     }
}

inline bool FID_TUNMSTR_S_STATION_SELECTIONStart::hasU8Element_ID () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 FID_TUNMSTR_S_STATION_SELECTIONStart::getU8Element_ID () const {
    return _u8Element_ID;
}

inline void FID_TUNMSTR_S_STATION_SELECTIONStart::setU8Element_ID (uint8 u8Element_ID_) {
    set_has_u8Element_ID();
    this->_u8Element_ID = u8Element_ID_;
}

inline void FID_TUNMSTR_S_STATION_SELECTIONStart::clearList() {
    if (hasList()) {
         clear_has_List();
        _List = ::tunermaster_main_fi_types::T_e8_List__BANK_FM1;
     }
}

inline bool FID_TUNMSTR_S_STATION_SELECTIONStart::hasList () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline ::tunermaster_main_fi_types::T_e8_List FID_TUNMSTR_S_STATION_SELECTIONStart::getList () const {
    return _List;
}

inline void FID_TUNMSTR_S_STATION_SELECTIONStart::setList (::tunermaster_main_fi_types::T_e8_List List_) {
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_List_IsValid(List_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", List_, "T_e8_List", "List", "FID_TUNMSTR_S_STATION_SELECTIONStart");
    }
    #endif
    set_has_List();
    this->_List = List_;
}

inline void FID_TUNMSTR_S_STATION_SELECTIONStart::clearPI() {
    if (hasPI()) {
         clear_has_PI();
        _PI = 0u;
     }
}

inline bool FID_TUNMSTR_S_STATION_SELECTIONStart::hasPI () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint32 FID_TUNMSTR_S_STATION_SELECTIONStart::getPI () const {
    return _PI;
}

inline void FID_TUNMSTR_S_STATION_SELECTIONStart::setPI (uint32 PI_) {
    set_has_PI();
    this->_PI = PI_;
}

inline void FID_TUNMSTR_S_STATION_SELECTIONStart::clearSecondaryPI() {
    if (hasSecondaryPI()) {
         clear_has_SecondaryPI();
        _SecondaryPI = 0u;
     }
}

inline bool FID_TUNMSTR_S_STATION_SELECTIONStart::hasSecondaryPI () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint16 FID_TUNMSTR_S_STATION_SELECTIONStart::getSecondaryPI () const {
    return _SecondaryPI;
}

inline void FID_TUNMSTR_S_STATION_SELECTIONStart::setSecondaryPI (uint16 SecondaryPI_) {
    set_has_SecondaryPI();
    this->_SecondaryPI = SecondaryPI_;
}

inline void FID_TUNMSTR_S_STATION_SELECTIONStart::clearModulationType() {
    if (hasModulationType()) {
         clear_has_ModulationType();
        _ModulationType = ::tunermaster_main_fi_types::T_e8_ModulationType__TUN_MSTR_MODULATION_ANALOG;
     }
}

inline bool FID_TUNMSTR_S_STATION_SELECTIONStart::hasModulationType () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline ::tunermaster_main_fi_types::T_e8_ModulationType FID_TUNMSTR_S_STATION_SELECTIONStart::getModulationType () const {
    return _ModulationType;
}

inline void FID_TUNMSTR_S_STATION_SELECTIONStart::setModulationType (::tunermaster_main_fi_types::T_e8_ModulationType ModulationType_) {
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_ModulationType_IsValid(ModulationType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ModulationType_, "T_e8_ModulationType", "ModulationType", "FID_TUNMSTR_S_STATION_SELECTIONStart");
    }
    #endif
    set_has_ModulationType();
    this->_ModulationType = ModulationType_;
}

inline void FID_TUNMSTR_S_STATION_SELECTIONStart::clearHDProgramNumber() {
    if (hasHDProgramNumber()) {
         clear_has_HDProgramNumber();
        _HDProgramNumber = 0u;
     }
}

inline bool FID_TUNMSTR_S_STATION_SELECTIONStart::hasHDProgramNumber () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline uint8 FID_TUNMSTR_S_STATION_SELECTIONStart::getHDProgramNumber () const {
    return _HDProgramNumber;
}

inline void FID_TUNMSTR_S_STATION_SELECTIONStart::setHDProgramNumber (uint8 HDProgramNumber_) {
    set_has_HDProgramNumber();
    this->_HDProgramNumber = HDProgramNumber_;
}

inline void FID_TUNMSTR_S_STATION_SELECTIONStart::set_has_Option () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUNMSTR_S_STATION_SELECTIONStart::clear_has_Option () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void FID_TUNMSTR_S_STATION_SELECTIONStart::set_has_Band () {
    _has_bits_[0] |= 1u << 1;
}

inline void FID_TUNMSTR_S_STATION_SELECTIONStart::clear_has_Band () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void FID_TUNMSTR_S_STATION_SELECTIONStart::set_has_Frequency () {
    _has_bits_[0] |= 1u << 2;
}

inline void FID_TUNMSTR_S_STATION_SELECTIONStart::clear_has_Frequency () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void FID_TUNMSTR_S_STATION_SELECTIONStart::set_has_u8Element_ID () {
    _has_bits_[0] |= 1u << 3;
}

inline void FID_TUNMSTR_S_STATION_SELECTIONStart::clear_has_u8Element_ID () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void FID_TUNMSTR_S_STATION_SELECTIONStart::set_has_List () {
    _has_bits_[0] |= 1u << 4;
}

inline void FID_TUNMSTR_S_STATION_SELECTIONStart::clear_has_List () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void FID_TUNMSTR_S_STATION_SELECTIONStart::set_has_PI () {
    _has_bits_[0] |= 1u << 5;
}

inline void FID_TUNMSTR_S_STATION_SELECTIONStart::clear_has_PI () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void FID_TUNMSTR_S_STATION_SELECTIONStart::set_has_SecondaryPI () {
    _has_bits_[0] |= 1u << 6;
}

inline void FID_TUNMSTR_S_STATION_SELECTIONStart::clear_has_SecondaryPI () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void FID_TUNMSTR_S_STATION_SELECTIONStart::set_has_ModulationType () {
    _has_bits_[0] |= 1u << 7;
}

inline void FID_TUNMSTR_S_STATION_SELECTIONStart::clear_has_ModulationType () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void FID_TUNMSTR_S_STATION_SELECTIONStart::set_has_HDProgramNumber () {
    _has_bits_[0] |= 1u << 8;
}

inline void FID_TUNMSTR_S_STATION_SELECTIONStart::clear_has_HDProgramNumber () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline  FID_TUNMSTR_S_STATION_SELECTIONResult::FID_TUNMSTR_S_STATION_SELECTIONResult ()  :
    _TunerMaster_StatusResponse ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_STATION_SELECTIONResult::FID_TUNMSTR_S_STATION_SELECTIONResult (const FID_TUNMSTR_S_STATION_SELECTIONResult &rhs)  :
    ::asf::core::Payload(rhs),
    _TunerMaster_StatusResponse ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUNMSTR_S_STATION_SELECTIONResult::FID_TUNMSTR_S_STATION_SELECTIONResult (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_)  :
    _TunerMaster_StatusResponse (TunerMaster_StatusResponse_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_STATION_SELECTIONResult::~FID_TUNMSTR_S_STATION_SELECTIONResult() {
}

inline FID_TUNMSTR_S_STATION_SELECTIONResult& FID_TUNMSTR_S_STATION_SELECTIONResult::operator = (const FID_TUNMSTR_S_STATION_SELECTIONResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTunerMaster_StatusResponse()) {
            setTunerMaster_StatusResponse(rhs.getTunerMaster_StatusResponse());
        } else {
            clearTunerMaster_StatusResponse();
        }
    }
    return *this;
}

inline bool FID_TUNMSTR_S_STATION_SELECTIONResult::operator == (const FID_TUNMSTR_S_STATION_SELECTIONResult& rhs) const {
    return (((!hasTunerMaster_StatusResponse() && !rhs.hasTunerMaster_StatusResponse()) || getTunerMaster_StatusResponse() == rhs.getTunerMaster_StatusResponse()));
}

inline bool FID_TUNMSTR_S_STATION_SELECTIONResult::operator != (const FID_TUNMSTR_S_STATION_SELECTIONResult& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUNMSTR_S_STATION_SELECTIONResult::operator < (const FID_TUNMSTR_S_STATION_SELECTIONResult& rhs) const {
    if (hasTunerMaster_StatusResponse() || rhs.hasTunerMaster_StatusResponse()) {
        if (getTunerMaster_StatusResponse() < rhs.getTunerMaster_StatusResponse()) return true;
        if (getTunerMaster_StatusResponse() > rhs.getTunerMaster_StatusResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUNMSTR_S_STATION_SELECTIONResult::clone() {
    return new FID_TUNMSTR_S_STATION_SELECTIONResult(*this);
}

inline bool FID_TUNMSTR_S_STATION_SELECTIONResult::operator > (const FID_TUNMSTR_S_STATION_SELECTIONResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUNMSTR_S_STATION_SELECTIONResult::clear() {
    clearTunerMaster_StatusResponse();
}

inline void FID_TUNMSTR_S_STATION_SELECTIONResult::clearTunerMaster_StatusResponse() {
    if (hasTunerMaster_StatusResponse()) {
         clear_has_TunerMaster_StatusResponse();
        _TunerMaster_StatusResponse.clear();
     }
}

inline bool FID_TUNMSTR_S_STATION_SELECTIONResult::hasTunerMaster_StatusResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& FID_TUNMSTR_S_STATION_SELECTIONResult::getTunerMaster_StatusResponse () const {
    return _TunerMaster_StatusResponse;
}

inline ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& FID_TUNMSTR_S_STATION_SELECTIONResult::getTunerMaster_StatusResponseMutable () {
    set_has_TunerMaster_StatusResponse();
    return _TunerMaster_StatusResponse;
}

inline void FID_TUNMSTR_S_STATION_SELECTIONResult::setTunerMaster_StatusResponse (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_) {
    set_has_TunerMaster_StatusResponse();
    this->_TunerMaster_StatusResponse = TunerMaster_StatusResponse_;
}

inline void FID_TUNMSTR_S_STATION_SELECTIONResult::set_has_TunerMaster_StatusResponse () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUNMSTR_S_STATION_SELECTIONResult::clear_has_TunerMaster_StatusResponse () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart::FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart ()  :
    _Enable (false),
    _Source (::tunermaster_main_fi_types::T_e8_Source__TUN_MSTR_SOURCE_FM1)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart::FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart (const FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart &rhs)  :
    ::asf::core::Payload(rhs),
    _Enable (false),
    _Source (::tunermaster_main_fi_types::T_e8_Source__TUN_MSTR_SOURCE_FM1)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart::FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart (bool Enable_, ::tunermaster_main_fi_types::T_e8_Source Source_)  :
    _Enable (Enable_),
    _Source (Source_)
{
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_Source_IsValid(Source_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Source_, "T_e8_Source", "Source", "FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart::~FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart() {
}

inline FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart& FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart::operator = (const FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEnable()) {
            setEnable(rhs.getEnable());
        } else {
            clearEnable();
        }
        if (rhs.hasSource()) {
            setSource(rhs.getSource());
        } else {
            clearSource();
        }
    }
    return *this;
}

inline bool FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart::operator == (const FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart& rhs) const {
    return (((!hasEnable() && !rhs.hasEnable()) || getEnable() == rhs.getEnable()) &&
        ((!hasSource() && !rhs.hasSource()) || getSource() == rhs.getSource()));
}

inline bool FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart::operator != (const FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart::operator < (const FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart& rhs) const {
    if (hasEnable() || rhs.hasEnable()) {
        if (getEnable() < rhs.getEnable()) return true;
        if (getEnable() > rhs.getEnable()) return false;
    }
    if (hasSource() || rhs.hasSource()) {
        if ((uint32)getSource() < (uint32)rhs.getSource()) return true;
        if ((uint32)getSource() > (uint32)rhs.getSource()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart::clone() {
    return new FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart(*this);
}

inline bool FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart::operator > (const FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart::clear() {
    clearEnable();
    clearSource();
}

inline void FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart::clearEnable() {
    if (hasEnable()) {
         clear_has_Enable();
        _Enable = false;
     }
}

inline bool FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart::hasEnable () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart::getEnable () const {
    return _Enable;
}

inline void FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart::setEnable (bool Enable_) {
    set_has_Enable();
    this->_Enable = Enable_;
}

inline void FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart::clearSource() {
    if (hasSource()) {
         clear_has_Source();
        _Source = ::tunermaster_main_fi_types::T_e8_Source__TUN_MSTR_SOURCE_FM1;
     }
}

inline bool FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart::hasSource () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::tunermaster_main_fi_types::T_e8_Source FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart::getSource () const {
    return _Source;
}

inline void FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart::setSource (::tunermaster_main_fi_types::T_e8_Source Source_) {
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_Source_IsValid(Source_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Source_, "T_e8_Source", "Source", "FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart");
    }
    #endif
    set_has_Source();
    this->_Source = Source_;
}

inline void FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart::set_has_Enable () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart::clear_has_Enable () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart::set_has_Source () {
    _has_bits_[0] |= 1u << 1;
}

inline void FID_TUNMSTR_S_SOURCE_SETUP_OPTIONStart::clear_has_Source () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  FID_TUNMSTR_S_SOURCE_SETUP_OPTIONResult::FID_TUNMSTR_S_SOURCE_SETUP_OPTIONResult ()  :
    _TunerMaster_StatusResponse ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_SOURCE_SETUP_OPTIONResult::FID_TUNMSTR_S_SOURCE_SETUP_OPTIONResult (const FID_TUNMSTR_S_SOURCE_SETUP_OPTIONResult &rhs)  :
    ::asf::core::Payload(rhs),
    _TunerMaster_StatusResponse ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUNMSTR_S_SOURCE_SETUP_OPTIONResult::FID_TUNMSTR_S_SOURCE_SETUP_OPTIONResult (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_)  :
    _TunerMaster_StatusResponse (TunerMaster_StatusResponse_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_SOURCE_SETUP_OPTIONResult::~FID_TUNMSTR_S_SOURCE_SETUP_OPTIONResult() {
}

inline FID_TUNMSTR_S_SOURCE_SETUP_OPTIONResult& FID_TUNMSTR_S_SOURCE_SETUP_OPTIONResult::operator = (const FID_TUNMSTR_S_SOURCE_SETUP_OPTIONResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTunerMaster_StatusResponse()) {
            setTunerMaster_StatusResponse(rhs.getTunerMaster_StatusResponse());
        } else {
            clearTunerMaster_StatusResponse();
        }
    }
    return *this;
}

inline bool FID_TUNMSTR_S_SOURCE_SETUP_OPTIONResult::operator == (const FID_TUNMSTR_S_SOURCE_SETUP_OPTIONResult& rhs) const {
    return (((!hasTunerMaster_StatusResponse() && !rhs.hasTunerMaster_StatusResponse()) || getTunerMaster_StatusResponse() == rhs.getTunerMaster_StatusResponse()));
}

inline bool FID_TUNMSTR_S_SOURCE_SETUP_OPTIONResult::operator != (const FID_TUNMSTR_S_SOURCE_SETUP_OPTIONResult& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUNMSTR_S_SOURCE_SETUP_OPTIONResult::operator < (const FID_TUNMSTR_S_SOURCE_SETUP_OPTIONResult& rhs) const {
    if (hasTunerMaster_StatusResponse() || rhs.hasTunerMaster_StatusResponse()) {
        if (getTunerMaster_StatusResponse() < rhs.getTunerMaster_StatusResponse()) return true;
        if (getTunerMaster_StatusResponse() > rhs.getTunerMaster_StatusResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUNMSTR_S_SOURCE_SETUP_OPTIONResult::clone() {
    return new FID_TUNMSTR_S_SOURCE_SETUP_OPTIONResult(*this);
}

inline bool FID_TUNMSTR_S_SOURCE_SETUP_OPTIONResult::operator > (const FID_TUNMSTR_S_SOURCE_SETUP_OPTIONResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUNMSTR_S_SOURCE_SETUP_OPTIONResult::clear() {
    clearTunerMaster_StatusResponse();
}

inline void FID_TUNMSTR_S_SOURCE_SETUP_OPTIONResult::clearTunerMaster_StatusResponse() {
    if (hasTunerMaster_StatusResponse()) {
         clear_has_TunerMaster_StatusResponse();
        _TunerMaster_StatusResponse.clear();
     }
}

inline bool FID_TUNMSTR_S_SOURCE_SETUP_OPTIONResult::hasTunerMaster_StatusResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& FID_TUNMSTR_S_SOURCE_SETUP_OPTIONResult::getTunerMaster_StatusResponse () const {
    return _TunerMaster_StatusResponse;
}

inline ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& FID_TUNMSTR_S_SOURCE_SETUP_OPTIONResult::getTunerMaster_StatusResponseMutable () {
    set_has_TunerMaster_StatusResponse();
    return _TunerMaster_StatusResponse;
}

inline void FID_TUNMSTR_S_SOURCE_SETUP_OPTIONResult::setTunerMaster_StatusResponse (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_) {
    set_has_TunerMaster_StatusResponse();
    this->_TunerMaster_StatusResponse = TunerMaster_StatusResponse_;
}

inline void FID_TUNMSTR_S_SOURCE_SETUP_OPTIONResult::set_has_TunerMaster_StatusResponse () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUNMSTR_S_SOURCE_SETUP_OPTIONResult::clear_has_TunerMaster_StatusResponse () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart::FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart ()  :
    _RadioProfile_PresetList (),
    _RadioProfile_AMSwitch (false),
    _RadioProfile_Option (::tunermaster_main_fi_types::T_e8_Preset_Option__TUN_MSTR_Preset_Option_Keep_Others)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart::FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart (const FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart &rhs)  :
    ::asf::core::Payload(rhs),
    _RadioProfile_PresetList (),
    _RadioProfile_AMSwitch (false),
    _RadioProfile_Option (::tunermaster_main_fi_types::T_e8_Preset_Option__TUN_MSTR_Preset_Option_Keep_Others)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart::FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart (const ::std::vector< ::tunermaster_main_fi_types::T_TunMst_PresetListElement >& RadioProfile_PresetList_, bool RadioProfile_AMSwitch_, ::tunermaster_main_fi_types::T_e8_Preset_Option RadioProfile_Option_)  :
    _RadioProfile_PresetList (RadioProfile_PresetList_),
    _RadioProfile_AMSwitch (RadioProfile_AMSwitch_),
    _RadioProfile_Option (RadioProfile_Option_)
{
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_Preset_Option_IsValid(RadioProfile_Option_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", RadioProfile_Option_, "T_e8_Preset_Option", "RadioProfile_Option", "FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart::~FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart() {
}

inline FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart& FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart::operator = (const FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRadioProfile_PresetList()) {
            setRadioProfile_PresetList(rhs.getRadioProfile_PresetList());
        } else {
            clearRadioProfile_PresetList();
        }
        if (rhs.hasRadioProfile_AMSwitch()) {
            setRadioProfile_AMSwitch(rhs.getRadioProfile_AMSwitch());
        } else {
            clearRadioProfile_AMSwitch();
        }
        if (rhs.hasRadioProfile_Option()) {
            setRadioProfile_Option(rhs.getRadioProfile_Option());
        } else {
            clearRadioProfile_Option();
        }
    }
    return *this;
}

inline bool FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart::operator == (const FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart& rhs) const {
    return (((!hasRadioProfile_PresetList() && !rhs.hasRadioProfile_PresetList()) || getRadioProfile_PresetList() == rhs.getRadioProfile_PresetList()) &&
        ((!hasRadioProfile_AMSwitch() && !rhs.hasRadioProfile_AMSwitch()) || getRadioProfile_AMSwitch() == rhs.getRadioProfile_AMSwitch()) &&
        ((!hasRadioProfile_Option() && !rhs.hasRadioProfile_Option()) || getRadioProfile_Option() == rhs.getRadioProfile_Option()));
}

inline bool FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart::operator != (const FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart::operator < (const FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart& rhs) const {
    if (hasRadioProfile_PresetList() || rhs.hasRadioProfile_PresetList()) {
        if (getRadioProfile_PresetList() < rhs.getRadioProfile_PresetList()) return true;
        if (getRadioProfile_PresetList() > rhs.getRadioProfile_PresetList()) return false;
    }
    if (hasRadioProfile_AMSwitch() || rhs.hasRadioProfile_AMSwitch()) {
        if (getRadioProfile_AMSwitch() < rhs.getRadioProfile_AMSwitch()) return true;
        if (getRadioProfile_AMSwitch() > rhs.getRadioProfile_AMSwitch()) return false;
    }
    if (hasRadioProfile_Option() || rhs.hasRadioProfile_Option()) {
        if ((uint32)getRadioProfile_Option() < (uint32)rhs.getRadioProfile_Option()) return true;
        if ((uint32)getRadioProfile_Option() > (uint32)rhs.getRadioProfile_Option()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart::clone() {
    return new FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart(*this);
}

inline bool FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart::operator > (const FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart::clear() {
    clearRadioProfile_PresetList();
    clearRadioProfile_AMSwitch();
    clearRadioProfile_Option();
}

inline void FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart::clearRadioProfile_PresetList() {
    if (hasRadioProfile_PresetList()) {
         clear_has_RadioProfile_PresetList();
        _RadioProfile_PresetList.clear();
     }
}

inline bool FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart::hasRadioProfile_PresetList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::tunermaster_main_fi_types::T_TunMst_PresetListElement >& FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart::getRadioProfile_PresetList () const {
    return _RadioProfile_PresetList;
}

inline ::std::vector< ::tunermaster_main_fi_types::T_TunMst_PresetListElement >& FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart::getRadioProfile_PresetListMutable () {
    set_has_RadioProfile_PresetList();
    return _RadioProfile_PresetList;
}

inline void FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart::setRadioProfile_PresetList (const ::std::vector< ::tunermaster_main_fi_types::T_TunMst_PresetListElement >& RadioProfile_PresetList_) {
    set_has_RadioProfile_PresetList();
    this->_RadioProfile_PresetList = RadioProfile_PresetList_;
}

inline void FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart::clearRadioProfile_AMSwitch() {
    if (hasRadioProfile_AMSwitch()) {
         clear_has_RadioProfile_AMSwitch();
        _RadioProfile_AMSwitch = false;
     }
}

inline bool FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart::hasRadioProfile_AMSwitch () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart::getRadioProfile_AMSwitch () const {
    return _RadioProfile_AMSwitch;
}

inline void FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart::setRadioProfile_AMSwitch (bool RadioProfile_AMSwitch_) {
    set_has_RadioProfile_AMSwitch();
    this->_RadioProfile_AMSwitch = RadioProfile_AMSwitch_;
}

inline void FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart::clearRadioProfile_Option() {
    if (hasRadioProfile_Option()) {
         clear_has_RadioProfile_Option();
        _RadioProfile_Option = ::tunermaster_main_fi_types::T_e8_Preset_Option__TUN_MSTR_Preset_Option_Keep_Others;
     }
}

inline bool FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart::hasRadioProfile_Option () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline ::tunermaster_main_fi_types::T_e8_Preset_Option FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart::getRadioProfile_Option () const {
    return _RadioProfile_Option;
}

inline void FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart::setRadioProfile_Option (::tunermaster_main_fi_types::T_e8_Preset_Option RadioProfile_Option_) {
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_Preset_Option_IsValid(RadioProfile_Option_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", RadioProfile_Option_, "T_e8_Preset_Option", "RadioProfile_Option", "FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart");
    }
    #endif
    set_has_RadioProfile_Option();
    this->_RadioProfile_Option = RadioProfile_Option_;
}

inline void FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart::set_has_RadioProfile_PresetList () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart::clear_has_RadioProfile_PresetList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart::set_has_RadioProfile_AMSwitch () {
    _has_bits_[0] |= 1u << 1;
}

inline void FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart::clear_has_RadioProfile_AMSwitch () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart::set_has_RadioProfile_Option () {
    _has_bits_[0] |= 1u << 2;
}

inline void FID_TUNMSTR_S_RADIOPROFILE_SETTINGStart::clear_has_RadioProfile_Option () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult::FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult ()  :
    _RadioProfileSetting_Response (),
    _u8FailedPresetID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult::FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult (const FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult &rhs)  :
    ::asf::core::Payload(rhs),
    _RadioProfileSetting_Response (),
    _u8FailedPresetID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult::FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult (const ::tunermaster_main_fi_types::T_TunMstr_RadioSetting_StatusResponse& RadioProfileSetting_Response_, uint8 u8FailedPresetID_)  :
    _RadioProfileSetting_Response (RadioProfileSetting_Response_),
    _u8FailedPresetID (u8FailedPresetID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult::~FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult() {
}

inline FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult& FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult::operator = (const FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRadioProfileSetting_Response()) {
            setRadioProfileSetting_Response(rhs.getRadioProfileSetting_Response());
        } else {
            clearRadioProfileSetting_Response();
        }
        if (rhs.hasU8FailedPresetID()) {
            setU8FailedPresetID(rhs.getU8FailedPresetID());
        } else {
            clearU8FailedPresetID();
        }
    }
    return *this;
}

inline bool FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult::operator == (const FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult& rhs) const {
    return (((!hasRadioProfileSetting_Response() && !rhs.hasRadioProfileSetting_Response()) || getRadioProfileSetting_Response() == rhs.getRadioProfileSetting_Response()) &&
        ((!hasU8FailedPresetID() && !rhs.hasU8FailedPresetID()) || getU8FailedPresetID() == rhs.getU8FailedPresetID()));
}

inline bool FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult::operator != (const FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult::operator < (const FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult& rhs) const {
    if (hasRadioProfileSetting_Response() || rhs.hasRadioProfileSetting_Response()) {
        if (getRadioProfileSetting_Response() < rhs.getRadioProfileSetting_Response()) return true;
        if (getRadioProfileSetting_Response() > rhs.getRadioProfileSetting_Response()) return false;
    }
    if (hasU8FailedPresetID() || rhs.hasU8FailedPresetID()) {
        if (getU8FailedPresetID() < rhs.getU8FailedPresetID()) return true;
        if (getU8FailedPresetID() > rhs.getU8FailedPresetID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult::clone() {
    return new FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult(*this);
}

inline bool FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult::operator > (const FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult::clear() {
    clearRadioProfileSetting_Response();
    clearU8FailedPresetID();
}

inline void FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult::clearRadioProfileSetting_Response() {
    if (hasRadioProfileSetting_Response()) {
         clear_has_RadioProfileSetting_Response();
        _RadioProfileSetting_Response.clear();
     }
}

inline bool FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult::hasRadioProfileSetting_Response () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::tunermaster_main_fi_types::T_TunMstr_RadioSetting_StatusResponse& FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult::getRadioProfileSetting_Response () const {
    return _RadioProfileSetting_Response;
}

inline ::tunermaster_main_fi_types::T_TunMstr_RadioSetting_StatusResponse& FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult::getRadioProfileSetting_ResponseMutable () {
    set_has_RadioProfileSetting_Response();
    return _RadioProfileSetting_Response;
}

inline void FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult::setRadioProfileSetting_Response (const ::tunermaster_main_fi_types::T_TunMstr_RadioSetting_StatusResponse& RadioProfileSetting_Response_) {
    set_has_RadioProfileSetting_Response();
    this->_RadioProfileSetting_Response = RadioProfileSetting_Response_;
}

inline void FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult::clearU8FailedPresetID() {
    if (hasU8FailedPresetID()) {
         clear_has_u8FailedPresetID();
        _u8FailedPresetID = 0u;
     }
}

inline bool FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult::hasU8FailedPresetID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult::getU8FailedPresetID () const {
    return _u8FailedPresetID;
}

inline void FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult::setU8FailedPresetID (uint8 u8FailedPresetID_) {
    set_has_u8FailedPresetID();
    this->_u8FailedPresetID = u8FailedPresetID_;
}

inline void FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult::set_has_RadioProfileSetting_Response () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult::clear_has_RadioProfileSetting_Response () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult::set_has_u8FailedPresetID () {
    _has_bits_[0] |= 1u << 1;
}

inline void FID_TUNMSTR_S_RADIOPROFILE_SETTINGResult::clear_has_u8FailedPresetID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart::FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart ()  :
    _RadioProfileSettingAction (),
    _PresetID ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart::FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart (const FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart &rhs)  :
    ::asf::core::Payload(rhs),
    _RadioProfileSettingAction (),
    _PresetID ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart::FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart (const ::tunermaster_main_fi_types::T_b8_RadioProfileSettingAction& RadioProfileSettingAction_, const ::std::vector< uint8 >& PresetID_)  :
    _RadioProfileSettingAction (RadioProfileSettingAction_),
    _PresetID (PresetID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart::~FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart() {
}

inline FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart& FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart::operator = (const FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRadioProfileSettingAction()) {
            setRadioProfileSettingAction(rhs.getRadioProfileSettingAction());
        } else {
            clearRadioProfileSettingAction();
        }
        if (rhs.hasPresetID()) {
            setPresetID(rhs.getPresetID());
        } else {
            clearPresetID();
        }
    }
    return *this;
}

inline bool FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart::operator == (const FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart& rhs) const {
    return (((!hasRadioProfileSettingAction() && !rhs.hasRadioProfileSettingAction()) || getRadioProfileSettingAction() == rhs.getRadioProfileSettingAction()) &&
        ((!hasPresetID() && !rhs.hasPresetID()) || getPresetID() == rhs.getPresetID()));
}

inline bool FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart::operator != (const FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart::operator < (const FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart& rhs) const {
    if (hasRadioProfileSettingAction() || rhs.hasRadioProfileSettingAction()) {
        if (getRadioProfileSettingAction() < rhs.getRadioProfileSettingAction()) return true;
        if (getRadioProfileSettingAction() > rhs.getRadioProfileSettingAction()) return false;
    }
    if (hasPresetID() || rhs.hasPresetID()) {
        if (getPresetID() < rhs.getPresetID()) return true;
        if (getPresetID() > rhs.getPresetID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart::clone() {
    return new FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart(*this);
}

inline bool FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart::operator > (const FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart::clear() {
    clearRadioProfileSettingAction();
    clearPresetID();
}

inline void FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart::clearRadioProfileSettingAction() {
    if (hasRadioProfileSettingAction()) {
         clear_has_RadioProfileSettingAction();
        _RadioProfileSettingAction = ::tunermaster_main_fi_types::T_b8_RadioProfileSettingAction ();
     }
}

inline bool FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart::hasRadioProfileSettingAction () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::tunermaster_main_fi_types::T_b8_RadioProfileSettingAction& FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart::getRadioProfileSettingAction () const {
    return _RadioProfileSettingAction;
}

inline ::tunermaster_main_fi_types::T_b8_RadioProfileSettingAction& FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart::getRadioProfileSettingActionMutable () {
    set_has_RadioProfileSettingAction();
    return _RadioProfileSettingAction;
}

inline void FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart::setRadioProfileSettingAction (const ::tunermaster_main_fi_types::T_b8_RadioProfileSettingAction& RadioProfileSettingAction_) {
    set_has_RadioProfileSettingAction();
    this->_RadioProfileSettingAction = RadioProfileSettingAction_;
}

inline void FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart::clearPresetID() {
    if (hasPresetID()) {
         clear_has_PresetID();
        _PresetID.clear();
     }
}

inline bool FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart::hasPresetID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< uint8 >& FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart::getPresetID () const {
    return _PresetID;
}

inline ::std::vector< uint8 >& FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart::getPresetIDMutable () {
    set_has_PresetID();
    return _PresetID;
}

inline void FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart::setPresetID (const ::std::vector< uint8 >& PresetID_) {
    set_has_PresetID();
    this->_PresetID = PresetID_;
}

inline void FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart::set_has_RadioProfileSettingAction () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart::clear_has_RadioProfileSettingAction () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart::set_has_PresetID () {
    _has_bits_[0] |= 1u << 1;
}

inline void FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTStart::clear_has_PresetID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult::FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult ()  :
    _TunerMaster_StatusResponse (),
    _PresetList (),
    _AMSwitch (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult::FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult (const FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult &rhs)  :
    ::asf::core::Payload(rhs),
    _TunerMaster_StatusResponse (),
    _PresetList (),
    _AMSwitch (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult::FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_, const ::std::vector< ::tunermaster_main_fi_types::T_TunMst_PresetListElement >& PresetList_, bool AMSwitch_)  :
    _TunerMaster_StatusResponse (TunerMaster_StatusResponse_),
    _PresetList (PresetList_),
    _AMSwitch (AMSwitch_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult::~FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult() {
}

inline FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult& FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult::operator = (const FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTunerMaster_StatusResponse()) {
            setTunerMaster_StatusResponse(rhs.getTunerMaster_StatusResponse());
        } else {
            clearTunerMaster_StatusResponse();
        }
        if (rhs.hasPresetList()) {
            setPresetList(rhs.getPresetList());
        } else {
            clearPresetList();
        }
        if (rhs.hasAMSwitch()) {
            setAMSwitch(rhs.getAMSwitch());
        } else {
            clearAMSwitch();
        }
    }
    return *this;
}

inline bool FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult::operator == (const FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult& rhs) const {
    return (((!hasTunerMaster_StatusResponse() && !rhs.hasTunerMaster_StatusResponse()) || getTunerMaster_StatusResponse() == rhs.getTunerMaster_StatusResponse()) &&
        ((!hasPresetList() && !rhs.hasPresetList()) || getPresetList() == rhs.getPresetList()) &&
        ((!hasAMSwitch() && !rhs.hasAMSwitch()) || getAMSwitch() == rhs.getAMSwitch()));
}

inline bool FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult::operator != (const FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult::operator < (const FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult& rhs) const {
    if (hasTunerMaster_StatusResponse() || rhs.hasTunerMaster_StatusResponse()) {
        if (getTunerMaster_StatusResponse() < rhs.getTunerMaster_StatusResponse()) return true;
        if (getTunerMaster_StatusResponse() > rhs.getTunerMaster_StatusResponse()) return false;
    }
    if (hasPresetList() || rhs.hasPresetList()) {
        if (getPresetList() < rhs.getPresetList()) return true;
        if (getPresetList() > rhs.getPresetList()) return false;
    }
    if (hasAMSwitch() || rhs.hasAMSwitch()) {
        if (getAMSwitch() < rhs.getAMSwitch()) return true;
        if (getAMSwitch() > rhs.getAMSwitch()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult::clone() {
    return new FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult(*this);
}

inline bool FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult::operator > (const FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult::clear() {
    clearTunerMaster_StatusResponse();
    clearPresetList();
    clearAMSwitch();
}

inline void FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult::clearTunerMaster_StatusResponse() {
    if (hasTunerMaster_StatusResponse()) {
         clear_has_TunerMaster_StatusResponse();
        _TunerMaster_StatusResponse.clear();
     }
}

inline bool FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult::hasTunerMaster_StatusResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult::getTunerMaster_StatusResponse () const {
    return _TunerMaster_StatusResponse;
}

inline ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult::getTunerMaster_StatusResponseMutable () {
    set_has_TunerMaster_StatusResponse();
    return _TunerMaster_StatusResponse;
}

inline void FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult::setTunerMaster_StatusResponse (const ::tunermaster_main_fi_types::T_TunerMaster_StatusResponse& TunerMaster_StatusResponse_) {
    set_has_TunerMaster_StatusResponse();
    this->_TunerMaster_StatusResponse = TunerMaster_StatusResponse_;
}

inline void FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult::clearPresetList() {
    if (hasPresetList()) {
         clear_has_PresetList();
        _PresetList.clear();
     }
}

inline bool FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult::hasPresetList () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< ::tunermaster_main_fi_types::T_TunMst_PresetListElement >& FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult::getPresetList () const {
    return _PresetList;
}

inline ::std::vector< ::tunermaster_main_fi_types::T_TunMst_PresetListElement >& FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult::getPresetListMutable () {
    set_has_PresetList();
    return _PresetList;
}

inline void FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult::setPresetList (const ::std::vector< ::tunermaster_main_fi_types::T_TunMst_PresetListElement >& PresetList_) {
    set_has_PresetList();
    this->_PresetList = PresetList_;
}

inline void FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult::clearAMSwitch() {
    if (hasAMSwitch()) {
         clear_has_AMSwitch();
        _AMSwitch = false;
     }
}

inline bool FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult::hasAMSwitch () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult::getAMSwitch () const {
    return _AMSwitch;
}

inline void FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult::setAMSwitch (bool AMSwitch_) {
    set_has_AMSwitch();
    this->_AMSwitch = AMSwitch_;
}

inline void FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult::set_has_TunerMaster_StatusResponse () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult::clear_has_TunerMaster_StatusResponse () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult::set_has_PresetList () {
    _has_bits_[0] |= 1u << 1;
}

inline void FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult::clear_has_PresetList () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult::set_has_AMSwitch () {
    _has_bits_[0] |= 1u << 2;
}

inline void FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTResult::clear_has_AMSwitch () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  FID_TUNMSTR_G_SET_DTVAntennaRegisterStatus::FID_TUNMSTR_G_SET_DTVAntennaRegisterStatus ()  :
    _RequestAccepted (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_G_SET_DTVAntennaRegisterStatus::FID_TUNMSTR_G_SET_DTVAntennaRegisterStatus (const FID_TUNMSTR_G_SET_DTVAntennaRegisterStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _RequestAccepted (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUNMSTR_G_SET_DTVAntennaRegisterStatus::FID_TUNMSTR_G_SET_DTVAntennaRegisterStatus (bool RequestAccepted_)  :
    _RequestAccepted (RequestAccepted_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_G_SET_DTVAntennaRegisterStatus::~FID_TUNMSTR_G_SET_DTVAntennaRegisterStatus() {
}

inline FID_TUNMSTR_G_SET_DTVAntennaRegisterStatus& FID_TUNMSTR_G_SET_DTVAntennaRegisterStatus::operator = (const FID_TUNMSTR_G_SET_DTVAntennaRegisterStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRequestAccepted()) {
            setRequestAccepted(rhs.getRequestAccepted());
        } else {
            clearRequestAccepted();
        }
    }
    return *this;
}

inline bool FID_TUNMSTR_G_SET_DTVAntennaRegisterStatus::operator == (const FID_TUNMSTR_G_SET_DTVAntennaRegisterStatus& rhs) const {
    return (((!hasRequestAccepted() && !rhs.hasRequestAccepted()) || getRequestAccepted() == rhs.getRequestAccepted()));
}

inline bool FID_TUNMSTR_G_SET_DTVAntennaRegisterStatus::operator != (const FID_TUNMSTR_G_SET_DTVAntennaRegisterStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUNMSTR_G_SET_DTVAntennaRegisterStatus::operator < (const FID_TUNMSTR_G_SET_DTVAntennaRegisterStatus& rhs) const {
    if (hasRequestAccepted() || rhs.hasRequestAccepted()) {
        if (getRequestAccepted() < rhs.getRequestAccepted()) return true;
        if (getRequestAccepted() > rhs.getRequestAccepted()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUNMSTR_G_SET_DTVAntennaRegisterStatus::clone() {
    return new FID_TUNMSTR_G_SET_DTVAntennaRegisterStatus(*this);
}

inline bool FID_TUNMSTR_G_SET_DTVAntennaRegisterStatus::operator > (const FID_TUNMSTR_G_SET_DTVAntennaRegisterStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUNMSTR_G_SET_DTVAntennaRegisterStatus::clear() {
    clearRequestAccepted();
}

inline void FID_TUNMSTR_G_SET_DTVAntennaRegisterStatus::clearRequestAccepted() {
    if (hasRequestAccepted()) {
         clear_has_RequestAccepted();
        _RequestAccepted = false;
     }
}

inline bool FID_TUNMSTR_G_SET_DTVAntennaRegisterStatus::hasRequestAccepted () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool FID_TUNMSTR_G_SET_DTVAntennaRegisterStatus::getRequestAccepted () const {
    return _RequestAccepted;
}

inline void FID_TUNMSTR_G_SET_DTVAntennaRegisterStatus::setRequestAccepted (bool RequestAccepted_) {
    set_has_RequestAccepted();
    this->_RequestAccepted = RequestAccepted_;
}

inline void FID_TUNMSTR_G_SET_DTVAntennaRegisterStatus::set_has_RequestAccepted () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUNMSTR_G_SET_DTVAntennaRegisterStatus::clear_has_RequestAccepted () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FID_TUNMSTR_G_TA_STATUSStatus::FID_TUNMSTR_G_TA_STATUSStatus ()  :
    _TA_ButtonStatus (false),
    _Source (::tunermaster_main_fi_types::T_e8_Source__TUN_MSTR_SOURCE_FM1)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_G_TA_STATUSStatus::FID_TUNMSTR_G_TA_STATUSStatus (const FID_TUNMSTR_G_TA_STATUSStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _TA_ButtonStatus (false),
    _Source (::tunermaster_main_fi_types::T_e8_Source__TUN_MSTR_SOURCE_FM1)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUNMSTR_G_TA_STATUSStatus::FID_TUNMSTR_G_TA_STATUSStatus (bool TA_ButtonStatus_, ::tunermaster_main_fi_types::T_e8_Source Source_)  :
    _TA_ButtonStatus (TA_ButtonStatus_),
    _Source (Source_)
{
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_Source_IsValid(Source_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Source_, "T_e8_Source", "Source", "FID_TUNMSTR_G_TA_STATUSStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_G_TA_STATUSStatus::~FID_TUNMSTR_G_TA_STATUSStatus() {
}

inline FID_TUNMSTR_G_TA_STATUSStatus& FID_TUNMSTR_G_TA_STATUSStatus::operator = (const FID_TUNMSTR_G_TA_STATUSStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTA_ButtonStatus()) {
            setTA_ButtonStatus(rhs.getTA_ButtonStatus());
        } else {
            clearTA_ButtonStatus();
        }
        if (rhs.hasSource()) {
            setSource(rhs.getSource());
        } else {
            clearSource();
        }
    }
    return *this;
}

inline bool FID_TUNMSTR_G_TA_STATUSStatus::operator == (const FID_TUNMSTR_G_TA_STATUSStatus& rhs) const {
    return (((!hasTA_ButtonStatus() && !rhs.hasTA_ButtonStatus()) || getTA_ButtonStatus() == rhs.getTA_ButtonStatus()) &&
        ((!hasSource() && !rhs.hasSource()) || getSource() == rhs.getSource()));
}

inline bool FID_TUNMSTR_G_TA_STATUSStatus::operator != (const FID_TUNMSTR_G_TA_STATUSStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUNMSTR_G_TA_STATUSStatus::operator < (const FID_TUNMSTR_G_TA_STATUSStatus& rhs) const {
    if (hasTA_ButtonStatus() || rhs.hasTA_ButtonStatus()) {
        if (getTA_ButtonStatus() < rhs.getTA_ButtonStatus()) return true;
        if (getTA_ButtonStatus() > rhs.getTA_ButtonStatus()) return false;
    }
    if (hasSource() || rhs.hasSource()) {
        if ((uint32)getSource() < (uint32)rhs.getSource()) return true;
        if ((uint32)getSource() > (uint32)rhs.getSource()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUNMSTR_G_TA_STATUSStatus::clone() {
    return new FID_TUNMSTR_G_TA_STATUSStatus(*this);
}

inline bool FID_TUNMSTR_G_TA_STATUSStatus::operator > (const FID_TUNMSTR_G_TA_STATUSStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUNMSTR_G_TA_STATUSStatus::clear() {
    clearTA_ButtonStatus();
    clearSource();
}

inline void FID_TUNMSTR_G_TA_STATUSStatus::clearTA_ButtonStatus() {
    if (hasTA_ButtonStatus()) {
         clear_has_TA_ButtonStatus();
        _TA_ButtonStatus = false;
     }
}

inline bool FID_TUNMSTR_G_TA_STATUSStatus::hasTA_ButtonStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool FID_TUNMSTR_G_TA_STATUSStatus::getTA_ButtonStatus () const {
    return _TA_ButtonStatus;
}

inline void FID_TUNMSTR_G_TA_STATUSStatus::setTA_ButtonStatus (bool TA_ButtonStatus_) {
    set_has_TA_ButtonStatus();
    this->_TA_ButtonStatus = TA_ButtonStatus_;
}

inline void FID_TUNMSTR_G_TA_STATUSStatus::clearSource() {
    if (hasSource()) {
         clear_has_Source();
        _Source = ::tunermaster_main_fi_types::T_e8_Source__TUN_MSTR_SOURCE_FM1;
     }
}

inline bool FID_TUNMSTR_G_TA_STATUSStatus::hasSource () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::tunermaster_main_fi_types::T_e8_Source FID_TUNMSTR_G_TA_STATUSStatus::getSource () const {
    return _Source;
}

inline void FID_TUNMSTR_G_TA_STATUSStatus::setSource (::tunermaster_main_fi_types::T_e8_Source Source_) {
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_Source_IsValid(Source_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Source_, "T_e8_Source", "Source", "FID_TUNMSTR_G_TA_STATUSStatus");
    }
    #endif
    set_has_Source();
    this->_Source = Source_;
}

inline void FID_TUNMSTR_G_TA_STATUSStatus::set_has_TA_ButtonStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUNMSTR_G_TA_STATUSStatus::clear_has_TA_ButtonStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void FID_TUNMSTR_G_TA_STATUSStatus::set_has_Source () {
    _has_bits_[0] |= 1u << 1;
}

inline void FID_TUNMSTR_G_TA_STATUSStatus::clear_has_Source () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  FID_TUNMSTR_G_TP_STATUSStatus::FID_TUNMSTR_G_TP_STATUSStatus ()  :
    _TP_STATE (false),
    _TP_Source (::tunermaster_main_fi_types::T_e8_Source__TUN_MSTR_SOURCE_FM1)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_G_TP_STATUSStatus::FID_TUNMSTR_G_TP_STATUSStatus (const FID_TUNMSTR_G_TP_STATUSStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _TP_STATE (false),
    _TP_Source (::tunermaster_main_fi_types::T_e8_Source__TUN_MSTR_SOURCE_FM1)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUNMSTR_G_TP_STATUSStatus::FID_TUNMSTR_G_TP_STATUSStatus (bool TP_STATE_, ::tunermaster_main_fi_types::T_e8_Source TP_Source_)  :
    _TP_STATE (TP_STATE_),
    _TP_Source (TP_Source_)
{
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_Source_IsValid(TP_Source_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TP_Source_, "T_e8_Source", "TP_Source", "FID_TUNMSTR_G_TP_STATUSStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_G_TP_STATUSStatus::~FID_TUNMSTR_G_TP_STATUSStatus() {
}

inline FID_TUNMSTR_G_TP_STATUSStatus& FID_TUNMSTR_G_TP_STATUSStatus::operator = (const FID_TUNMSTR_G_TP_STATUSStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTP_STATE()) {
            setTP_STATE(rhs.getTP_STATE());
        } else {
            clearTP_STATE();
        }
        if (rhs.hasTP_Source()) {
            setTP_Source(rhs.getTP_Source());
        } else {
            clearTP_Source();
        }
    }
    return *this;
}

inline bool FID_TUNMSTR_G_TP_STATUSStatus::operator == (const FID_TUNMSTR_G_TP_STATUSStatus& rhs) const {
    return (((!hasTP_STATE() && !rhs.hasTP_STATE()) || getTP_STATE() == rhs.getTP_STATE()) &&
        ((!hasTP_Source() && !rhs.hasTP_Source()) || getTP_Source() == rhs.getTP_Source()));
}

inline bool FID_TUNMSTR_G_TP_STATUSStatus::operator != (const FID_TUNMSTR_G_TP_STATUSStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUNMSTR_G_TP_STATUSStatus::operator < (const FID_TUNMSTR_G_TP_STATUSStatus& rhs) const {
    if (hasTP_STATE() || rhs.hasTP_STATE()) {
        if (getTP_STATE() < rhs.getTP_STATE()) return true;
        if (getTP_STATE() > rhs.getTP_STATE()) return false;
    }
    if (hasTP_Source() || rhs.hasTP_Source()) {
        if ((uint32)getTP_Source() < (uint32)rhs.getTP_Source()) return true;
        if ((uint32)getTP_Source() > (uint32)rhs.getTP_Source()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUNMSTR_G_TP_STATUSStatus::clone() {
    return new FID_TUNMSTR_G_TP_STATUSStatus(*this);
}

inline bool FID_TUNMSTR_G_TP_STATUSStatus::operator > (const FID_TUNMSTR_G_TP_STATUSStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUNMSTR_G_TP_STATUSStatus::clear() {
    clearTP_STATE();
    clearTP_Source();
}

inline void FID_TUNMSTR_G_TP_STATUSStatus::clearTP_STATE() {
    if (hasTP_STATE()) {
         clear_has_TP_STATE();
        _TP_STATE = false;
     }
}

inline bool FID_TUNMSTR_G_TP_STATUSStatus::hasTP_STATE () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool FID_TUNMSTR_G_TP_STATUSStatus::getTP_STATE () const {
    return _TP_STATE;
}

inline void FID_TUNMSTR_G_TP_STATUSStatus::setTP_STATE (bool TP_STATE_) {
    set_has_TP_STATE();
    this->_TP_STATE = TP_STATE_;
}

inline void FID_TUNMSTR_G_TP_STATUSStatus::clearTP_Source() {
    if (hasTP_Source()) {
         clear_has_TP_Source();
        _TP_Source = ::tunermaster_main_fi_types::T_e8_Source__TUN_MSTR_SOURCE_FM1;
     }
}

inline bool FID_TUNMSTR_G_TP_STATUSStatus::hasTP_Source () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::tunermaster_main_fi_types::T_e8_Source FID_TUNMSTR_G_TP_STATUSStatus::getTP_Source () const {
    return _TP_Source;
}

inline void FID_TUNMSTR_G_TP_STATUSStatus::setTP_Source (::tunermaster_main_fi_types::T_e8_Source TP_Source_) {
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_Source_IsValid(TP_Source_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TP_Source_, "T_e8_Source", "TP_Source", "FID_TUNMSTR_G_TP_STATUSStatus");
    }
    #endif
    set_has_TP_Source();
    this->_TP_Source = TP_Source_;
}

inline void FID_TUNMSTR_G_TP_STATUSStatus::set_has_TP_STATE () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUNMSTR_G_TP_STATUSStatus::clear_has_TP_STATE () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void FID_TUNMSTR_G_TP_STATUSStatus::set_has_TP_Source () {
    _has_bits_[0] |= 1u << 1;
}

inline void FID_TUNMSTR_G_TP_STATUSStatus::clear_has_TP_Source () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  FID_TUNMSTR_G_SOURCE_CHANGEStatus::FID_TUNMSTR_G_SOURCE_CHANGEStatus ()  :
    _Source (::tunermaster_main_fi_types::T_e8_Source__TUN_MSTR_SOURCE_FM1),
    _Action (::tunermaster_main_fi_types::T_e8_Action__TUN_MSTR_PLAY)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_G_SOURCE_CHANGEStatus::FID_TUNMSTR_G_SOURCE_CHANGEStatus (const FID_TUNMSTR_G_SOURCE_CHANGEStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _Source (::tunermaster_main_fi_types::T_e8_Source__TUN_MSTR_SOURCE_FM1),
    _Action (::tunermaster_main_fi_types::T_e8_Action__TUN_MSTR_PLAY)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUNMSTR_G_SOURCE_CHANGEStatus::FID_TUNMSTR_G_SOURCE_CHANGEStatus (::tunermaster_main_fi_types::T_e8_Source Source_, ::tunermaster_main_fi_types::T_e8_Action Action_)  :
    _Source (Source_),
    _Action (Action_)
{
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_Source_IsValid(Source_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Source_, "T_e8_Source", "Source", "FID_TUNMSTR_G_SOURCE_CHANGEStatus");
    }
    #endif
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_Action_IsValid(Action_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Action_, "T_e8_Action", "Action", "FID_TUNMSTR_G_SOURCE_CHANGEStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_G_SOURCE_CHANGEStatus::~FID_TUNMSTR_G_SOURCE_CHANGEStatus() {
}

inline FID_TUNMSTR_G_SOURCE_CHANGEStatus& FID_TUNMSTR_G_SOURCE_CHANGEStatus::operator = (const FID_TUNMSTR_G_SOURCE_CHANGEStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSource()) {
            setSource(rhs.getSource());
        } else {
            clearSource();
        }
        if (rhs.hasAction()) {
            setAction(rhs.getAction());
        } else {
            clearAction();
        }
    }
    return *this;
}

inline bool FID_TUNMSTR_G_SOURCE_CHANGEStatus::operator == (const FID_TUNMSTR_G_SOURCE_CHANGEStatus& rhs) const {
    return (((!hasSource() && !rhs.hasSource()) || getSource() == rhs.getSource()) &&
        ((!hasAction() && !rhs.hasAction()) || getAction() == rhs.getAction()));
}

inline bool FID_TUNMSTR_G_SOURCE_CHANGEStatus::operator != (const FID_TUNMSTR_G_SOURCE_CHANGEStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUNMSTR_G_SOURCE_CHANGEStatus::operator < (const FID_TUNMSTR_G_SOURCE_CHANGEStatus& rhs) const {
    if (hasSource() || rhs.hasSource()) {
        if ((uint32)getSource() < (uint32)rhs.getSource()) return true;
        if ((uint32)getSource() > (uint32)rhs.getSource()) return false;
    }
    if (hasAction() || rhs.hasAction()) {
        if ((uint32)getAction() < (uint32)rhs.getAction()) return true;
        if ((uint32)getAction() > (uint32)rhs.getAction()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUNMSTR_G_SOURCE_CHANGEStatus::clone() {
    return new FID_TUNMSTR_G_SOURCE_CHANGEStatus(*this);
}

inline bool FID_TUNMSTR_G_SOURCE_CHANGEStatus::operator > (const FID_TUNMSTR_G_SOURCE_CHANGEStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUNMSTR_G_SOURCE_CHANGEStatus::clear() {
    clearSource();
    clearAction();
}

inline void FID_TUNMSTR_G_SOURCE_CHANGEStatus::clearSource() {
    if (hasSource()) {
         clear_has_Source();
        _Source = ::tunermaster_main_fi_types::T_e8_Source__TUN_MSTR_SOURCE_FM1;
     }
}

inline bool FID_TUNMSTR_G_SOURCE_CHANGEStatus::hasSource () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::tunermaster_main_fi_types::T_e8_Source FID_TUNMSTR_G_SOURCE_CHANGEStatus::getSource () const {
    return _Source;
}

inline void FID_TUNMSTR_G_SOURCE_CHANGEStatus::setSource (::tunermaster_main_fi_types::T_e8_Source Source_) {
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_Source_IsValid(Source_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Source_, "T_e8_Source", "Source", "FID_TUNMSTR_G_SOURCE_CHANGEStatus");
    }
    #endif
    set_has_Source();
    this->_Source = Source_;
}

inline void FID_TUNMSTR_G_SOURCE_CHANGEStatus::clearAction() {
    if (hasAction()) {
         clear_has_Action();
        _Action = ::tunermaster_main_fi_types::T_e8_Action__TUN_MSTR_PLAY;
     }
}

inline bool FID_TUNMSTR_G_SOURCE_CHANGEStatus::hasAction () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::tunermaster_main_fi_types::T_e8_Action FID_TUNMSTR_G_SOURCE_CHANGEStatus::getAction () const {
    return _Action;
}

inline void FID_TUNMSTR_G_SOURCE_CHANGEStatus::setAction (::tunermaster_main_fi_types::T_e8_Action Action_) {
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_Action_IsValid(Action_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Action_, "T_e8_Action", "Action", "FID_TUNMSTR_G_SOURCE_CHANGEStatus");
    }
    #endif
    set_has_Action();
    this->_Action = Action_;
}

inline void FID_TUNMSTR_G_SOURCE_CHANGEStatus::set_has_Source () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUNMSTR_G_SOURCE_CHANGEStatus::clear_has_Source () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void FID_TUNMSTR_G_SOURCE_CHANGEStatus::set_has_Action () {
    _has_bits_[0] |= 1u << 1;
}

inline void FID_TUNMSTR_G_SOURCE_CHANGEStatus::clear_has_Action () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  FID_TUNMSTR_G_BAND_INFOStatus::FID_TUNMSTR_G_BAND_INFOStatus ()  :
    _Band (::tunermaster_main_fi_types::T_e8_Band__TUN_MSTR_BAND_FM)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_G_BAND_INFOStatus::FID_TUNMSTR_G_BAND_INFOStatus (const FID_TUNMSTR_G_BAND_INFOStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _Band (::tunermaster_main_fi_types::T_e8_Band__TUN_MSTR_BAND_FM)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUNMSTR_G_BAND_INFOStatus::FID_TUNMSTR_G_BAND_INFOStatus (::tunermaster_main_fi_types::T_e8_Band Band_)  :
    _Band (Band_)
{
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_Band_IsValid(Band_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Band_, "T_e8_Band", "Band", "FID_TUNMSTR_G_BAND_INFOStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_G_BAND_INFOStatus::~FID_TUNMSTR_G_BAND_INFOStatus() {
}

inline FID_TUNMSTR_G_BAND_INFOStatus& FID_TUNMSTR_G_BAND_INFOStatus::operator = (const FID_TUNMSTR_G_BAND_INFOStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBand()) {
            setBand(rhs.getBand());
        } else {
            clearBand();
        }
    }
    return *this;
}

inline bool FID_TUNMSTR_G_BAND_INFOStatus::operator == (const FID_TUNMSTR_G_BAND_INFOStatus& rhs) const {
    return (((!hasBand() && !rhs.hasBand()) || getBand() == rhs.getBand()));
}

inline bool FID_TUNMSTR_G_BAND_INFOStatus::operator != (const FID_TUNMSTR_G_BAND_INFOStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUNMSTR_G_BAND_INFOStatus::operator < (const FID_TUNMSTR_G_BAND_INFOStatus& rhs) const {
    if (hasBand() || rhs.hasBand()) {
        if ((uint32)getBand() < (uint32)rhs.getBand()) return true;
        if ((uint32)getBand() > (uint32)rhs.getBand()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUNMSTR_G_BAND_INFOStatus::clone() {
    return new FID_TUNMSTR_G_BAND_INFOStatus(*this);
}

inline bool FID_TUNMSTR_G_BAND_INFOStatus::operator > (const FID_TUNMSTR_G_BAND_INFOStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUNMSTR_G_BAND_INFOStatus::clear() {
    clearBand();
}

inline void FID_TUNMSTR_G_BAND_INFOStatus::clearBand() {
    if (hasBand()) {
         clear_has_Band();
        _Band = ::tunermaster_main_fi_types::T_e8_Band__TUN_MSTR_BAND_FM;
     }
}

inline bool FID_TUNMSTR_G_BAND_INFOStatus::hasBand () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::tunermaster_main_fi_types::T_e8_Band FID_TUNMSTR_G_BAND_INFOStatus::getBand () const {
    return _Band;
}

inline void FID_TUNMSTR_G_BAND_INFOStatus::setBand (::tunermaster_main_fi_types::T_e8_Band Band_) {
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_Band_IsValid(Band_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Band_, "T_e8_Band", "Band", "FID_TUNMSTR_G_BAND_INFOStatus");
    }
    #endif
    set_has_Band();
    this->_Band = Band_;
}

inline void FID_TUNMSTR_G_BAND_INFOStatus::set_has_Band () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUNMSTR_G_BAND_INFOStatus::clear_has_Band () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FID_TUNMSTR_G_RF_ANTENNA_TESTStatus::FID_TUNMSTR_G_RF_ANTENNA_TESTStatus ()  :
    _Tunmstr_RF_Antenna ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_G_RF_ANTENNA_TESTStatus::FID_TUNMSTR_G_RF_ANTENNA_TESTStatus (const FID_TUNMSTR_G_RF_ANTENNA_TESTStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _Tunmstr_RF_Antenna ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUNMSTR_G_RF_ANTENNA_TESTStatus::FID_TUNMSTR_G_RF_ANTENNA_TESTStatus (const ::tunermaster_main_fi_types::Tunmstr_RFAntenna& Tunmstr_RF_Antenna_)  :
    _Tunmstr_RF_Antenna (Tunmstr_RF_Antenna_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_G_RF_ANTENNA_TESTStatus::~FID_TUNMSTR_G_RF_ANTENNA_TESTStatus() {
}

inline FID_TUNMSTR_G_RF_ANTENNA_TESTStatus& FID_TUNMSTR_G_RF_ANTENNA_TESTStatus::operator = (const FID_TUNMSTR_G_RF_ANTENNA_TESTStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTunmstr_RF_Antenna()) {
            setTunmstr_RF_Antenna(rhs.getTunmstr_RF_Antenna());
        } else {
            clearTunmstr_RF_Antenna();
        }
    }
    return *this;
}

inline bool FID_TUNMSTR_G_RF_ANTENNA_TESTStatus::operator == (const FID_TUNMSTR_G_RF_ANTENNA_TESTStatus& rhs) const {
    return (((!hasTunmstr_RF_Antenna() && !rhs.hasTunmstr_RF_Antenna()) || getTunmstr_RF_Antenna() == rhs.getTunmstr_RF_Antenna()));
}

inline bool FID_TUNMSTR_G_RF_ANTENNA_TESTStatus::operator != (const FID_TUNMSTR_G_RF_ANTENNA_TESTStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUNMSTR_G_RF_ANTENNA_TESTStatus::operator < (const FID_TUNMSTR_G_RF_ANTENNA_TESTStatus& rhs) const {
    if (hasTunmstr_RF_Antenna() || rhs.hasTunmstr_RF_Antenna()) {
        if (getTunmstr_RF_Antenna() < rhs.getTunmstr_RF_Antenna()) return true;
        if (getTunmstr_RF_Antenna() > rhs.getTunmstr_RF_Antenna()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUNMSTR_G_RF_ANTENNA_TESTStatus::clone() {
    return new FID_TUNMSTR_G_RF_ANTENNA_TESTStatus(*this);
}

inline bool FID_TUNMSTR_G_RF_ANTENNA_TESTStatus::operator > (const FID_TUNMSTR_G_RF_ANTENNA_TESTStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUNMSTR_G_RF_ANTENNA_TESTStatus::clear() {
    clearTunmstr_RF_Antenna();
}

inline void FID_TUNMSTR_G_RF_ANTENNA_TESTStatus::clearTunmstr_RF_Antenna() {
    if (hasTunmstr_RF_Antenna()) {
         clear_has_Tunmstr_RF_Antenna();
        _Tunmstr_RF_Antenna.clear();
     }
}

inline bool FID_TUNMSTR_G_RF_ANTENNA_TESTStatus::hasTunmstr_RF_Antenna () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::tunermaster_main_fi_types::Tunmstr_RFAntenna& FID_TUNMSTR_G_RF_ANTENNA_TESTStatus::getTunmstr_RF_Antenna () const {
    return _Tunmstr_RF_Antenna;
}

inline ::tunermaster_main_fi_types::Tunmstr_RFAntenna& FID_TUNMSTR_G_RF_ANTENNA_TESTStatus::getTunmstr_RF_AntennaMutable () {
    set_has_Tunmstr_RF_Antenna();
    return _Tunmstr_RF_Antenna;
}

inline void FID_TUNMSTR_G_RF_ANTENNA_TESTStatus::setTunmstr_RF_Antenna (const ::tunermaster_main_fi_types::Tunmstr_RFAntenna& Tunmstr_RF_Antenna_) {
    set_has_Tunmstr_RF_Antenna();
    this->_Tunmstr_RF_Antenna = Tunmstr_RF_Antenna_;
}

inline void FID_TUNMSTR_G_RF_ANTENNA_TESTStatus::set_has_Tunmstr_RF_Antenna () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUNMSTR_G_RF_ANTENNA_TESTStatus::clear_has_Tunmstr_RF_Antenna () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FID_TUNMSTR_G_PRESET_LISTStatus::FID_TUNMSTR_G_PRESET_LISTStatus ()  :
    _ListOfStations (),
    _List (::tunermaster_main_fi_types::T_e8_List__BANK_FM1)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_G_PRESET_LISTStatus::FID_TUNMSTR_G_PRESET_LISTStatus (const FID_TUNMSTR_G_PRESET_LISTStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _ListOfStations (),
    _List (::tunermaster_main_fi_types::T_e8_List__BANK_FM1)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUNMSTR_G_PRESET_LISTStatus::FID_TUNMSTR_G_PRESET_LISTStatus (const ::std::vector< ::tunermaster_main_fi_types::T_PresetList >& ListOfStations_, ::tunermaster_main_fi_types::T_e8_List List_)  :
    _ListOfStations (ListOfStations_),
    _List (List_)
{
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_List_IsValid(List_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", List_, "T_e8_List", "List", "FID_TUNMSTR_G_PRESET_LISTStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_G_PRESET_LISTStatus::~FID_TUNMSTR_G_PRESET_LISTStatus() {
}

inline FID_TUNMSTR_G_PRESET_LISTStatus& FID_TUNMSTR_G_PRESET_LISTStatus::operator = (const FID_TUNMSTR_G_PRESET_LISTStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasListOfStations()) {
            setListOfStations(rhs.getListOfStations());
        } else {
            clearListOfStations();
        }
        if (rhs.hasList()) {
            setList(rhs.getList());
        } else {
            clearList();
        }
    }
    return *this;
}

inline bool FID_TUNMSTR_G_PRESET_LISTStatus::operator == (const FID_TUNMSTR_G_PRESET_LISTStatus& rhs) const {
    return (((!hasListOfStations() && !rhs.hasListOfStations()) || getListOfStations() == rhs.getListOfStations()) &&
        ((!hasList() && !rhs.hasList()) || getList() == rhs.getList()));
}

inline bool FID_TUNMSTR_G_PRESET_LISTStatus::operator != (const FID_TUNMSTR_G_PRESET_LISTStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUNMSTR_G_PRESET_LISTStatus::operator < (const FID_TUNMSTR_G_PRESET_LISTStatus& rhs) const {
    if (hasListOfStations() || rhs.hasListOfStations()) {
        if (getListOfStations() < rhs.getListOfStations()) return true;
        if (getListOfStations() > rhs.getListOfStations()) return false;
    }
    if (hasList() || rhs.hasList()) {
        if ((uint32)getList() < (uint32)rhs.getList()) return true;
        if ((uint32)getList() > (uint32)rhs.getList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUNMSTR_G_PRESET_LISTStatus::clone() {
    return new FID_TUNMSTR_G_PRESET_LISTStatus(*this);
}

inline bool FID_TUNMSTR_G_PRESET_LISTStatus::operator > (const FID_TUNMSTR_G_PRESET_LISTStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUNMSTR_G_PRESET_LISTStatus::clear() {
    clearListOfStations();
    clearList();
}

inline void FID_TUNMSTR_G_PRESET_LISTStatus::clearListOfStations() {
    if (hasListOfStations()) {
         clear_has_ListOfStations();
        _ListOfStations.clear();
     }
}

inline bool FID_TUNMSTR_G_PRESET_LISTStatus::hasListOfStations () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::tunermaster_main_fi_types::T_PresetList >& FID_TUNMSTR_G_PRESET_LISTStatus::getListOfStations () const {
    return _ListOfStations;
}

inline ::std::vector< ::tunermaster_main_fi_types::T_PresetList >& FID_TUNMSTR_G_PRESET_LISTStatus::getListOfStationsMutable () {
    set_has_ListOfStations();
    return _ListOfStations;
}

inline void FID_TUNMSTR_G_PRESET_LISTStatus::setListOfStations (const ::std::vector< ::tunermaster_main_fi_types::T_PresetList >& ListOfStations_) {
    set_has_ListOfStations();
    this->_ListOfStations = ListOfStations_;
}

inline void FID_TUNMSTR_G_PRESET_LISTStatus::clearList() {
    if (hasList()) {
         clear_has_List();
        _List = ::tunermaster_main_fi_types::T_e8_List__BANK_FM1;
     }
}

inline bool FID_TUNMSTR_G_PRESET_LISTStatus::hasList () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::tunermaster_main_fi_types::T_e8_List FID_TUNMSTR_G_PRESET_LISTStatus::getList () const {
    return _List;
}

inline void FID_TUNMSTR_G_PRESET_LISTStatus::setList (::tunermaster_main_fi_types::T_e8_List List_) {
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_List_IsValid(List_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", List_, "T_e8_List", "List", "FID_TUNMSTR_G_PRESET_LISTStatus");
    }
    #endif
    set_has_List();
    this->_List = List_;
}

inline void FID_TUNMSTR_G_PRESET_LISTStatus::set_has_ListOfStations () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUNMSTR_G_PRESET_LISTStatus::clear_has_ListOfStations () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void FID_TUNMSTR_G_PRESET_LISTStatus::set_has_List () {
    _has_bits_[0] |= 1u << 1;
}

inline void FID_TUNMSTR_G_PRESET_LISTStatus::clear_has_List () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus::FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus ()  :
    _b32AnnouncementType (),
    _Source (::tunermaster_main_fi_types::T_e8_Source__TUN_MSTR_SOURCE_FM1)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus::FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus (const FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _b32AnnouncementType (),
    _Source (::tunermaster_main_fi_types::T_e8_Source__TUN_MSTR_SOURCE_FM1)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus::FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus (const ::tunermaster_main_fi_types::T_b32_AnnoType& b32AnnouncementType_, ::tunermaster_main_fi_types::T_e8_Source Source_)  :
    _b32AnnouncementType (b32AnnouncementType_),
    _Source (Source_)
{
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_Source_IsValid(Source_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Source_, "T_e8_Source", "Source", "FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus::~FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus() {
}

inline FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus& FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus::operator = (const FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasB32AnnouncementType()) {
            setB32AnnouncementType(rhs.getB32AnnouncementType());
        } else {
            clearB32AnnouncementType();
        }
        if (rhs.hasSource()) {
            setSource(rhs.getSource());
        } else {
            clearSource();
        }
    }
    return *this;
}

inline bool FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus::operator == (const FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus& rhs) const {
    return (((!hasB32AnnouncementType() && !rhs.hasB32AnnouncementType()) || getB32AnnouncementType() == rhs.getB32AnnouncementType()) &&
        ((!hasSource() && !rhs.hasSource()) || getSource() == rhs.getSource()));
}

inline bool FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus::operator != (const FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus::operator < (const FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus& rhs) const {
    if (hasB32AnnouncementType() || rhs.hasB32AnnouncementType()) {
        if (getB32AnnouncementType() < rhs.getB32AnnouncementType()) return true;
        if (getB32AnnouncementType() > rhs.getB32AnnouncementType()) return false;
    }
    if (hasSource() || rhs.hasSource()) {
        if ((uint32)getSource() < (uint32)rhs.getSource()) return true;
        if ((uint32)getSource() > (uint32)rhs.getSource()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus::clone() {
    return new FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus(*this);
}

inline bool FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus::operator > (const FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus::clear() {
    clearB32AnnouncementType();
    clearSource();
}

inline void FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus::clearB32AnnouncementType() {
    if (hasB32AnnouncementType()) {
         clear_has_b32AnnouncementType();
        _b32AnnouncementType = ::tunermaster_main_fi_types::T_b32_AnnoType ();
     }
}

inline bool FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus::hasB32AnnouncementType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::tunermaster_main_fi_types::T_b32_AnnoType& FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus::getB32AnnouncementType () const {
    return _b32AnnouncementType;
}

inline ::tunermaster_main_fi_types::T_b32_AnnoType& FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus::getB32AnnouncementTypeMutable () {
    set_has_b32AnnouncementType();
    return _b32AnnouncementType;
}

inline void FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus::setB32AnnouncementType (const ::tunermaster_main_fi_types::T_b32_AnnoType& b32AnnouncementType_) {
    set_has_b32AnnouncementType();
    this->_b32AnnouncementType = b32AnnouncementType_;
}

inline void FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus::clearSource() {
    if (hasSource()) {
         clear_has_Source();
        _Source = ::tunermaster_main_fi_types::T_e8_Source__TUN_MSTR_SOURCE_FM1;
     }
}

inline bool FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus::hasSource () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::tunermaster_main_fi_types::T_e8_Source FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus::getSource () const {
    return _Source;
}

inline void FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus::setSource (::tunermaster_main_fi_types::T_e8_Source Source_) {
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_Source_IsValid(Source_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Source_, "T_e8_Source", "Source", "FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus");
    }
    #endif
    set_has_Source();
    this->_Source = Source_;
}

inline void FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus::set_has_b32AnnouncementType () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus::clear_has_b32AnnouncementType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus::set_has_Source () {
    _has_bits_[0] |= 1u << 1;
}

inline void FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus::clear_has_Source () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus::FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus ()  :
    _Anno_Status (false),
    _Source (::tunermaster_main_fi_types::T_e8_Source__TUN_MSTR_SOURCE_FM1),
    _Anno_Types (::tunermaster_main_fi_types::T_e8_AnnoTypes__TUNMSTR_ANNOTYPE_PTY31)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus::FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus (const FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _Anno_Status (false),
    _Source (::tunermaster_main_fi_types::T_e8_Source__TUN_MSTR_SOURCE_FM1),
    _Anno_Types (::tunermaster_main_fi_types::T_e8_AnnoTypes__TUNMSTR_ANNOTYPE_PTY31)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus::FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus (bool Anno_Status_, ::tunermaster_main_fi_types::T_e8_Source Source_, ::tunermaster_main_fi_types::T_e8_AnnoTypes Anno_Types_)  :
    _Anno_Status (Anno_Status_),
    _Source (Source_),
    _Anno_Types (Anno_Types_)
{
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_Source_IsValid(Source_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Source_, "T_e8_Source", "Source", "FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus");
    }
    #endif
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_AnnoTypes_IsValid(Anno_Types_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Anno_Types_, "T_e8_AnnoTypes", "Anno_Types", "FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus::~FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus() {
}

inline FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus& FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus::operator = (const FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAnno_Status()) {
            setAnno_Status(rhs.getAnno_Status());
        } else {
            clearAnno_Status();
        }
        if (rhs.hasSource()) {
            setSource(rhs.getSource());
        } else {
            clearSource();
        }
        if (rhs.hasAnno_Types()) {
            setAnno_Types(rhs.getAnno_Types());
        } else {
            clearAnno_Types();
        }
    }
    return *this;
}

inline bool FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus::operator == (const FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus& rhs) const {
    return (((!hasAnno_Status() && !rhs.hasAnno_Status()) || getAnno_Status() == rhs.getAnno_Status()) &&
        ((!hasSource() && !rhs.hasSource()) || getSource() == rhs.getSource()) &&
        ((!hasAnno_Types() && !rhs.hasAnno_Types()) || getAnno_Types() == rhs.getAnno_Types()));
}

inline bool FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus::operator != (const FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus::operator < (const FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus& rhs) const {
    if (hasAnno_Status() || rhs.hasAnno_Status()) {
        if (getAnno_Status() < rhs.getAnno_Status()) return true;
        if (getAnno_Status() > rhs.getAnno_Status()) return false;
    }
    if (hasSource() || rhs.hasSource()) {
        if ((uint32)getSource() < (uint32)rhs.getSource()) return true;
        if ((uint32)getSource() > (uint32)rhs.getSource()) return false;
    }
    if (hasAnno_Types() || rhs.hasAnno_Types()) {
        if ((uint32)getAnno_Types() < (uint32)rhs.getAnno_Types()) return true;
        if ((uint32)getAnno_Types() > (uint32)rhs.getAnno_Types()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus::clone() {
    return new FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus(*this);
}

inline bool FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus::operator > (const FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus::clear() {
    clearAnno_Status();
    clearSource();
    clearAnno_Types();
}

inline void FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus::clearAnno_Status() {
    if (hasAnno_Status()) {
         clear_has_Anno_Status();
        _Anno_Status = false;
     }
}

inline bool FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus::hasAnno_Status () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus::getAnno_Status () const {
    return _Anno_Status;
}

inline void FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus::setAnno_Status (bool Anno_Status_) {
    set_has_Anno_Status();
    this->_Anno_Status = Anno_Status_;
}

inline void FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus::clearSource() {
    if (hasSource()) {
         clear_has_Source();
        _Source = ::tunermaster_main_fi_types::T_e8_Source__TUN_MSTR_SOURCE_FM1;
     }
}

inline bool FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus::hasSource () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::tunermaster_main_fi_types::T_e8_Source FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus::getSource () const {
    return _Source;
}

inline void FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus::setSource (::tunermaster_main_fi_types::T_e8_Source Source_) {
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_Source_IsValid(Source_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Source_, "T_e8_Source", "Source", "FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus");
    }
    #endif
    set_has_Source();
    this->_Source = Source_;
}

inline void FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus::clearAnno_Types() {
    if (hasAnno_Types()) {
         clear_has_Anno_Types();
        _Anno_Types = ::tunermaster_main_fi_types::T_e8_AnnoTypes__TUNMSTR_ANNOTYPE_PTY31;
     }
}

inline bool FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus::hasAnno_Types () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline ::tunermaster_main_fi_types::T_e8_AnnoTypes FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus::getAnno_Types () const {
    return _Anno_Types;
}

inline void FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus::setAnno_Types (::tunermaster_main_fi_types::T_e8_AnnoTypes Anno_Types_) {
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_AnnoTypes_IsValid(Anno_Types_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Anno_Types_, "T_e8_AnnoTypes", "Anno_Types", "FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus");
    }
    #endif
    set_has_Anno_Types();
    this->_Anno_Types = Anno_Types_;
}

inline void FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus::set_has_Anno_Status () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus::clear_has_Anno_Status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus::set_has_Source () {
    _has_bits_[0] |= 1u << 1;
}

inline void FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus::clear_has_Source () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus::set_has_Anno_Types () {
    _has_bits_[0] |= 1u << 2;
}

inline void FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus::clear_has_Anno_Types () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus::FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus ()  :
    _TunerAvailability (::tunermaster_main_fi_types::T_e8_TunerAvailability__TUNMSTR_FM_TUNER_NOW_AVAILABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus::FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus (const FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _TunerAvailability (::tunermaster_main_fi_types::T_e8_TunerAvailability__TUNMSTR_FM_TUNER_NOW_AVAILABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus::FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus (::tunermaster_main_fi_types::T_e8_TunerAvailability TunerAvailability_)  :
    _TunerAvailability (TunerAvailability_)
{
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_TunerAvailability_IsValid(TunerAvailability_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TunerAvailability_, "T_e8_TunerAvailability", "TunerAvailability", "FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus::~FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus() {
}

inline FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus& FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus::operator = (const FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTunerAvailability()) {
            setTunerAvailability(rhs.getTunerAvailability());
        } else {
            clearTunerAvailability();
        }
    }
    return *this;
}

inline bool FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus::operator == (const FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus& rhs) const {
    return (((!hasTunerAvailability() && !rhs.hasTunerAvailability()) || getTunerAvailability() == rhs.getTunerAvailability()));
}

inline bool FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus::operator != (const FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus::operator < (const FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus& rhs) const {
    if (hasTunerAvailability() || rhs.hasTunerAvailability()) {
        if ((uint32)getTunerAvailability() < (uint32)rhs.getTunerAvailability()) return true;
        if ((uint32)getTunerAvailability() > (uint32)rhs.getTunerAvailability()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus::clone() {
    return new FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus(*this);
}

inline bool FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus::operator > (const FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus::clear() {
    clearTunerAvailability();
}

inline void FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus::clearTunerAvailability() {
    if (hasTunerAvailability()) {
         clear_has_TunerAvailability();
        _TunerAvailability = ::tunermaster_main_fi_types::T_e8_TunerAvailability__TUNMSTR_FM_TUNER_NOW_AVAILABLE;
     }
}

inline bool FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus::hasTunerAvailability () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::tunermaster_main_fi_types::T_e8_TunerAvailability FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus::getTunerAvailability () const {
    return _TunerAvailability;
}

inline void FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus::setTunerAvailability (::tunermaster_main_fi_types::T_e8_TunerAvailability TunerAvailability_) {
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_TunerAvailability_IsValid(TunerAvailability_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TunerAvailability_, "T_e8_TunerAvailability", "TunerAvailability", "FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus");
    }
    #endif
    set_has_TunerAvailability();
    this->_TunerAvailability = TunerAvailability_;
}

inline void FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus::set_has_TunerAvailability () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus::clear_has_TunerAvailability () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus::FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus ()  :
    _Autostore_State (false),
    _AST_Type (::tunermaster_main_fi_types::T_e8_AST_Types__NORMAL_AST)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus::FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus (const FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _Autostore_State (false),
    _AST_Type (::tunermaster_main_fi_types::T_e8_AST_Types__NORMAL_AST)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus::FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus (bool Autostore_State_, ::tunermaster_main_fi_types::T_e8_AST_Types AST_Type_)  :
    _Autostore_State (Autostore_State_),
    _AST_Type (AST_Type_)
{
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_AST_Types_IsValid(AST_Type_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", AST_Type_, "T_e8_AST_Types", "AST_Type", "FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus::~FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus() {
}

inline FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus& FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus::operator = (const FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAutostore_State()) {
            setAutostore_State(rhs.getAutostore_State());
        } else {
            clearAutostore_State();
        }
        if (rhs.hasAST_Type()) {
            setAST_Type(rhs.getAST_Type());
        } else {
            clearAST_Type();
        }
    }
    return *this;
}

inline bool FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus::operator == (const FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus& rhs) const {
    return (((!hasAutostore_State() && !rhs.hasAutostore_State()) || getAutostore_State() == rhs.getAutostore_State()) &&
        ((!hasAST_Type() && !rhs.hasAST_Type()) || getAST_Type() == rhs.getAST_Type()));
}

inline bool FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus::operator != (const FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus::operator < (const FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus& rhs) const {
    if (hasAutostore_State() || rhs.hasAutostore_State()) {
        if (getAutostore_State() < rhs.getAutostore_State()) return true;
        if (getAutostore_State() > rhs.getAutostore_State()) return false;
    }
    if (hasAST_Type() || rhs.hasAST_Type()) {
        if ((uint32)getAST_Type() < (uint32)rhs.getAST_Type()) return true;
        if ((uint32)getAST_Type() > (uint32)rhs.getAST_Type()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus::clone() {
    return new FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus(*this);
}

inline bool FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus::operator > (const FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus::clear() {
    clearAutostore_State();
    clearAST_Type();
}

inline void FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus::clearAutostore_State() {
    if (hasAutostore_State()) {
         clear_has_Autostore_State();
        _Autostore_State = false;
     }
}

inline bool FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus::hasAutostore_State () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus::getAutostore_State () const {
    return _Autostore_State;
}

inline void FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus::setAutostore_State (bool Autostore_State_) {
    set_has_Autostore_State();
    this->_Autostore_State = Autostore_State_;
}

inline void FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus::clearAST_Type() {
    if (hasAST_Type()) {
         clear_has_AST_Type();
        _AST_Type = ::tunermaster_main_fi_types::T_e8_AST_Types__NORMAL_AST;
     }
}

inline bool FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus::hasAST_Type () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::tunermaster_main_fi_types::T_e8_AST_Types FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus::getAST_Type () const {
    return _AST_Type;
}

inline void FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus::setAST_Type (::tunermaster_main_fi_types::T_e8_AST_Types AST_Type_) {
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_AST_Types_IsValid(AST_Type_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", AST_Type_, "T_e8_AST_Types", "AST_Type", "FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus");
    }
    #endif
    set_has_AST_Type();
    this->_AST_Type = AST_Type_;
}

inline void FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus::set_has_Autostore_State () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus::clear_has_Autostore_State () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus::set_has_AST_Type () {
    _has_bits_[0] |= 1u << 1;
}

inline void FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus::clear_has_AST_Type () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  FID_TUNMSTR_G_MTC_SETMODE_STATUSStatus::FID_TUNMSTR_G_MTC_SETMODE_STATUSStatus ()  :
    _Mode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_G_MTC_SETMODE_STATUSStatus::FID_TUNMSTR_G_MTC_SETMODE_STATUSStatus (const FID_TUNMSTR_G_MTC_SETMODE_STATUSStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _Mode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUNMSTR_G_MTC_SETMODE_STATUSStatus::FID_TUNMSTR_G_MTC_SETMODE_STATUSStatus (const ::tunermaster_main_fi_types::T_b8_ModeType& Mode_)  :
    _Mode (Mode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_G_MTC_SETMODE_STATUSStatus::~FID_TUNMSTR_G_MTC_SETMODE_STATUSStatus() {
}

inline FID_TUNMSTR_G_MTC_SETMODE_STATUSStatus& FID_TUNMSTR_G_MTC_SETMODE_STATUSStatus::operator = (const FID_TUNMSTR_G_MTC_SETMODE_STATUSStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMode()) {
            setMode(rhs.getMode());
        } else {
            clearMode();
        }
    }
    return *this;
}

inline bool FID_TUNMSTR_G_MTC_SETMODE_STATUSStatus::operator == (const FID_TUNMSTR_G_MTC_SETMODE_STATUSStatus& rhs) const {
    return (((!hasMode() && !rhs.hasMode()) || getMode() == rhs.getMode()));
}

inline bool FID_TUNMSTR_G_MTC_SETMODE_STATUSStatus::operator != (const FID_TUNMSTR_G_MTC_SETMODE_STATUSStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUNMSTR_G_MTC_SETMODE_STATUSStatus::operator < (const FID_TUNMSTR_G_MTC_SETMODE_STATUSStatus& rhs) const {
    if (hasMode() || rhs.hasMode()) {
        if (getMode() < rhs.getMode()) return true;
        if (getMode() > rhs.getMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUNMSTR_G_MTC_SETMODE_STATUSStatus::clone() {
    return new FID_TUNMSTR_G_MTC_SETMODE_STATUSStatus(*this);
}

inline bool FID_TUNMSTR_G_MTC_SETMODE_STATUSStatus::operator > (const FID_TUNMSTR_G_MTC_SETMODE_STATUSStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUNMSTR_G_MTC_SETMODE_STATUSStatus::clear() {
    clearMode();
}

inline void FID_TUNMSTR_G_MTC_SETMODE_STATUSStatus::clearMode() {
    if (hasMode()) {
         clear_has_Mode();
        _Mode = ::tunermaster_main_fi_types::T_b8_ModeType ();
     }
}

inline bool FID_TUNMSTR_G_MTC_SETMODE_STATUSStatus::hasMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::tunermaster_main_fi_types::T_b8_ModeType& FID_TUNMSTR_G_MTC_SETMODE_STATUSStatus::getMode () const {
    return _Mode;
}

inline ::tunermaster_main_fi_types::T_b8_ModeType& FID_TUNMSTR_G_MTC_SETMODE_STATUSStatus::getModeMutable () {
    set_has_Mode();
    return _Mode;
}

inline void FID_TUNMSTR_G_MTC_SETMODE_STATUSStatus::setMode (const ::tunermaster_main_fi_types::T_b8_ModeType& Mode_) {
    set_has_Mode();
    this->_Mode = Mode_;
}

inline void FID_TUNMSTR_G_MTC_SETMODE_STATUSStatus::set_has_Mode () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUNMSTR_G_MTC_SETMODE_STATUSStatus::clear_has_Mode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus::FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus ()  :
    _StationType (::tunermaster_main_fi_types::T_e8_StationType__TUNMSTR_StationType_DAB),
    _Frequency (0u),
    _Station_ID (0u),
    _StationNameFM ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus::FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus (const FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _StationType (::tunermaster_main_fi_types::T_e8_StationType__TUNMSTR_StationType_DAB),
    _Frequency (0u),
    _Station_ID (0u),
    _StationNameFM ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus::FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus (::tunermaster_main_fi_types::T_e8_StationType StationType_, uint32 Frequency_, uint32 Station_ID_, const ::std::string& StationNameFM_)  :
    _StationType (StationType_),
    _Frequency (Frequency_),
    _Station_ID (Station_ID_),
    _StationNameFM (StationNameFM_)
{
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_StationType_IsValid(StationType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", StationType_, "T_e8_StationType", "StationType", "FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StationNameFM_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus::~FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus() {
}

inline FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus& FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus::operator = (const FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStationType()) {
            setStationType(rhs.getStationType());
        } else {
            clearStationType();
        }
        if (rhs.hasFrequency()) {
            setFrequency(rhs.getFrequency());
        } else {
            clearFrequency();
        }
        if (rhs.hasStation_ID()) {
            setStation_ID(rhs.getStation_ID());
        } else {
            clearStation_ID();
        }
        if (rhs.hasStationNameFM()) {
            setStationNameFM(rhs.getStationNameFM());
        } else {
            clearStationNameFM();
        }
    }
    return *this;
}

inline bool FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus::operator == (const FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus& rhs) const {
    return (((!hasStationType() && !rhs.hasStationType()) || getStationType() == rhs.getStationType()) &&
        ((!hasFrequency() && !rhs.hasFrequency()) || getFrequency() == rhs.getFrequency()) &&
        ((!hasStation_ID() && !rhs.hasStation_ID()) || getStation_ID() == rhs.getStation_ID()) &&
        ((!hasStationNameFM() && !rhs.hasStationNameFM()) || getStationNameFM() == rhs.getStationNameFM()));
}

inline bool FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus::operator != (const FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus::operator < (const FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus& rhs) const {
    if (hasStationType() || rhs.hasStationType()) {
        if ((uint32)getStationType() < (uint32)rhs.getStationType()) return true;
        if ((uint32)getStationType() > (uint32)rhs.getStationType()) return false;
    }
    if (hasFrequency() || rhs.hasFrequency()) {
        if (getFrequency() < rhs.getFrequency()) return true;
        if (getFrequency() > rhs.getFrequency()) return false;
    }
    if (hasStation_ID() || rhs.hasStation_ID()) {
        if (getStation_ID() < rhs.getStation_ID()) return true;
        if (getStation_ID() > rhs.getStation_ID()) return false;
    }
    if (hasStationNameFM() || rhs.hasStationNameFM()) {
        if (getStationNameFM() < rhs.getStationNameFM()) return true;
        if (getStationNameFM() > rhs.getStationNameFM()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus::clone() {
    return new FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus(*this);
}

inline bool FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus::operator > (const FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus::clear() {
    clearStationType();
    clearFrequency();
    clearStation_ID();
    clearStationNameFM();
}

inline void FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus::clearStationType() {
    if (hasStationType()) {
         clear_has_StationType();
        _StationType = ::tunermaster_main_fi_types::T_e8_StationType__TUNMSTR_StationType_DAB;
     }
}

inline bool FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus::hasStationType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::tunermaster_main_fi_types::T_e8_StationType FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus::getStationType () const {
    return _StationType;
}

inline void FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus::setStationType (::tunermaster_main_fi_types::T_e8_StationType StationType_) {
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_StationType_IsValid(StationType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", StationType_, "T_e8_StationType", "StationType", "FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus");
    }
    #endif
    set_has_StationType();
    this->_StationType = StationType_;
}

inline void FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus::clearFrequency() {
    if (hasFrequency()) {
         clear_has_Frequency();
        _Frequency = 0u;
     }
}

inline bool FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus::hasFrequency () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus::getFrequency () const {
    return _Frequency;
}

inline void FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus::setFrequency (uint32 Frequency_) {
    set_has_Frequency();
    this->_Frequency = Frequency_;
}

inline void FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus::clearStation_ID() {
    if (hasStation_ID()) {
         clear_has_Station_ID();
        _Station_ID = 0u;
     }
}

inline bool FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus::hasStation_ID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus::getStation_ID () const {
    return _Station_ID;
}

inline void FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus::setStation_ID (uint32 Station_ID_) {
    set_has_Station_ID();
    this->_Station_ID = Station_ID_;
}

inline void FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus::clearStationNameFM() {
    if (hasStationNameFM()) {
         clear_has_StationNameFM();
        _StationNameFM.clear();
     }
}

inline bool FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus::hasStationNameFM () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus::getStationNameFM () const {
    return _StationNameFM;
}

inline ::std::string& FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus::getStationNameFMMutable () {
    set_has_StationNameFM();
    return _StationNameFM;
}

inline void FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus::setStationNameFM (const ::std::string& StationNameFM_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StationNameFM_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StationNameFM();
    this->_StationNameFM = StationNameFM_;
}

inline void FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus::setStationNameFM (const char* StationNameFM_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StationNameFM_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StationNameFM();
    this->_StationNameFM.assign(StationNameFM_);
}

inline void FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus::setStationNameFM (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StationNameFM();
    this->_StationNameFM.assign(value, size);
}

inline void FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus::set_has_StationType () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus::clear_has_StationType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus::set_has_Frequency () {
    _has_bits_[0] |= 1u << 1;
}

inline void FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus::clear_has_Frequency () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus::set_has_Station_ID () {
    _has_bits_[0] |= 1u << 2;
}

inline void FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus::clear_has_Station_ID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus::set_has_StationNameFM () {
    _has_bits_[0] |= 1u << 3;
}

inline void FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus::clear_has_StationNameFM () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus::FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus ()  :
    _Source (::tunermaster_main_fi_types::T_e8_Source__TUN_MSTR_SOURCE_FM1),
    _Available (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus::FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus (const FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _Source (::tunermaster_main_fi_types::T_e8_Source__TUN_MSTR_SOURCE_FM1),
    _Available (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus::FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus (::tunermaster_main_fi_types::T_e8_Source Source_, bool Available_)  :
    _Source (Source_),
    _Available (Available_)
{
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_Source_IsValid(Source_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Source_, "T_e8_Source", "Source", "FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus::~FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus() {
}

inline FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus& FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus::operator = (const FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSource()) {
            setSource(rhs.getSource());
        } else {
            clearSource();
        }
        if (rhs.hasAvailable()) {
            setAvailable(rhs.getAvailable());
        } else {
            clearAvailable();
        }
    }
    return *this;
}

inline bool FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus::operator == (const FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus& rhs) const {
    return (((!hasSource() && !rhs.hasSource()) || getSource() == rhs.getSource()) &&
        ((!hasAvailable() && !rhs.hasAvailable()) || getAvailable() == rhs.getAvailable()));
}

inline bool FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus::operator != (const FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus::operator < (const FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus& rhs) const {
    if (hasSource() || rhs.hasSource()) {
        if ((uint32)getSource() < (uint32)rhs.getSource()) return true;
        if ((uint32)getSource() > (uint32)rhs.getSource()) return false;
    }
    if (hasAvailable() || rhs.hasAvailable()) {
        if (getAvailable() < rhs.getAvailable()) return true;
        if (getAvailable() > rhs.getAvailable()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus::clone() {
    return new FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus(*this);
}

inline bool FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus::operator > (const FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus::clear() {
    clearSource();
    clearAvailable();
}

inline void FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus::clearSource() {
    if (hasSource()) {
         clear_has_Source();
        _Source = ::tunermaster_main_fi_types::T_e8_Source__TUN_MSTR_SOURCE_FM1;
     }
}

inline bool FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus::hasSource () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::tunermaster_main_fi_types::T_e8_Source FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus::getSource () const {
    return _Source;
}

inline void FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus::setSource (::tunermaster_main_fi_types::T_e8_Source Source_) {
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_Source_IsValid(Source_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Source_, "T_e8_Source", "Source", "FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus");
    }
    #endif
    set_has_Source();
    this->_Source = Source_;
}

inline void FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus::clearAvailable() {
    if (hasAvailable()) {
         clear_has_Available();
        _Available = false;
     }
}

inline bool FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus::hasAvailable () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus::getAvailable () const {
    return _Available;
}

inline void FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus::setAvailable (bool Available_) {
    set_has_Available();
    this->_Available = Available_;
}

inline void FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus::set_has_Source () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus::clear_has_Source () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus::set_has_Available () {
    _has_bits_[0] |= 1u << 1;
}

inline void FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus::clear_has_Available () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus::FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus ()  :
    _RadioProfileSettingAction (),
    _PresetIndexList (),
    _AMSwitch (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus::FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus (const FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _RadioProfileSettingAction (),
    _PresetIndexList (),
    _AMSwitch (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus::FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus (const ::tunermaster_main_fi_types::T_b8_RadioProfileSettingAction& RadioProfileSettingAction_, const ::std::vector< uint8 >& PresetIndexList_, bool AMSwitch_)  :
    _RadioProfileSettingAction (RadioProfileSettingAction_),
    _PresetIndexList (PresetIndexList_),
    _AMSwitch (AMSwitch_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus::~FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus() {
}

inline FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus& FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus::operator = (const FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRadioProfileSettingAction()) {
            setRadioProfileSettingAction(rhs.getRadioProfileSettingAction());
        } else {
            clearRadioProfileSettingAction();
        }
        if (rhs.hasPresetIndexList()) {
            setPresetIndexList(rhs.getPresetIndexList());
        } else {
            clearPresetIndexList();
        }
        if (rhs.hasAMSwitch()) {
            setAMSwitch(rhs.getAMSwitch());
        } else {
            clearAMSwitch();
        }
    }
    return *this;
}

inline bool FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus::operator == (const FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus& rhs) const {
    return (((!hasRadioProfileSettingAction() && !rhs.hasRadioProfileSettingAction()) || getRadioProfileSettingAction() == rhs.getRadioProfileSettingAction()) &&
        ((!hasPresetIndexList() && !rhs.hasPresetIndexList()) || getPresetIndexList() == rhs.getPresetIndexList()) &&
        ((!hasAMSwitch() && !rhs.hasAMSwitch()) || getAMSwitch() == rhs.getAMSwitch()));
}

inline bool FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus::operator != (const FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus::operator < (const FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus& rhs) const {
    if (hasRadioProfileSettingAction() || rhs.hasRadioProfileSettingAction()) {
        if (getRadioProfileSettingAction() < rhs.getRadioProfileSettingAction()) return true;
        if (getRadioProfileSettingAction() > rhs.getRadioProfileSettingAction()) return false;
    }
    if (hasPresetIndexList() || rhs.hasPresetIndexList()) {
        if (getPresetIndexList() < rhs.getPresetIndexList()) return true;
        if (getPresetIndexList() > rhs.getPresetIndexList()) return false;
    }
    if (hasAMSwitch() || rhs.hasAMSwitch()) {
        if (getAMSwitch() < rhs.getAMSwitch()) return true;
        if (getAMSwitch() > rhs.getAMSwitch()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus::clone() {
    return new FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus(*this);
}

inline bool FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus::operator > (const FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus::clear() {
    clearRadioProfileSettingAction();
    clearPresetIndexList();
    clearAMSwitch();
}

inline void FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus::clearRadioProfileSettingAction() {
    if (hasRadioProfileSettingAction()) {
         clear_has_RadioProfileSettingAction();
        _RadioProfileSettingAction = ::tunermaster_main_fi_types::T_b8_RadioProfileSettingAction ();
     }
}

inline bool FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus::hasRadioProfileSettingAction () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::tunermaster_main_fi_types::T_b8_RadioProfileSettingAction& FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus::getRadioProfileSettingAction () const {
    return _RadioProfileSettingAction;
}

inline ::tunermaster_main_fi_types::T_b8_RadioProfileSettingAction& FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus::getRadioProfileSettingActionMutable () {
    set_has_RadioProfileSettingAction();
    return _RadioProfileSettingAction;
}

inline void FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus::setRadioProfileSettingAction (const ::tunermaster_main_fi_types::T_b8_RadioProfileSettingAction& RadioProfileSettingAction_) {
    set_has_RadioProfileSettingAction();
    this->_RadioProfileSettingAction = RadioProfileSettingAction_;
}

inline void FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus::clearPresetIndexList() {
    if (hasPresetIndexList()) {
         clear_has_PresetIndexList();
        _PresetIndexList.clear();
     }
}

inline bool FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus::hasPresetIndexList () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< uint8 >& FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus::getPresetIndexList () const {
    return _PresetIndexList;
}

inline ::std::vector< uint8 >& FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus::getPresetIndexListMutable () {
    set_has_PresetIndexList();
    return _PresetIndexList;
}

inline void FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus::setPresetIndexList (const ::std::vector< uint8 >& PresetIndexList_) {
    set_has_PresetIndexList();
    this->_PresetIndexList = PresetIndexList_;
}

inline void FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus::clearAMSwitch() {
    if (hasAMSwitch()) {
         clear_has_AMSwitch();
        _AMSwitch = false;
     }
}

inline bool FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus::hasAMSwitch () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus::getAMSwitch () const {
    return _AMSwitch;
}

inline void FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus::setAMSwitch (bool AMSwitch_) {
    set_has_AMSwitch();
    this->_AMSwitch = AMSwitch_;
}

inline void FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus::set_has_RadioProfileSettingAction () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus::clear_has_RadioProfileSettingAction () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus::set_has_PresetIndexList () {
    _has_bits_[0] |= 1u << 1;
}

inline void FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus::clear_has_PresetIndexList () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus::set_has_AMSwitch () {
    _has_bits_[0] |= 1u << 2;
}

inline void FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus::clear_has_AMSwitch () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure::FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure ()  :
    _ErrorType (::tunermaster_main_fi_types::T_e8_TunerErrorType__Messagenotsupported)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure::FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure (const FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure &rhs)  :
    _ErrorType (::tunermaster_main_fi_types::T_e8_TunerErrorType__Messagenotsupported)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure::FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure (::tunermaster_main_fi_types::T_e8_TunerErrorType ErrorType_)  :
    _ErrorType (ErrorType_)
{
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_TunerErrorType_IsValid(ErrorType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorType_, "T_e8_TunerErrorType", "ErrorType", "FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure::~FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure() {
}

inline FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure& FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure::operator = (const FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorType()) {
            setErrorType(rhs.getErrorType());
        } else {
            clearErrorType();
        }
    }
    return *this;
}

inline bool FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure::operator == (const FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure& rhs) const {
    return (((!hasErrorType() && !rhs.hasErrorType()) || getErrorType() == rhs.getErrorType()));
}

inline bool FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure::operator != (const FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure::operator < (const FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure& rhs) const {
    if (hasErrorType() || rhs.hasErrorType()) {
        if ((uint32)getErrorType() < (uint32)rhs.getErrorType()) return true;
        if ((uint32)getErrorType() > (uint32)rhs.getErrorType()) return false;
    }
    return false;
}

inline bool FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure::operator > (const FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure::clear() {
    clearErrorType();
}

inline void FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure::clearErrorType() {
    if (hasErrorType()) {
         clear_has_ErrorType();
        _ErrorType = ::tunermaster_main_fi_types::T_e8_TunerErrorType__Messagenotsupported;
     }
}

inline bool FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure::hasErrorType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::tunermaster_main_fi_types::T_e8_TunerErrorType FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure::getErrorType () const {
    return _ErrorType;
}

inline void FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure::setErrorType (::tunermaster_main_fi_types::T_e8_TunerErrorType ErrorType_) {
    #ifndef NDEBUG
    if (!(::tunermaster_main_fi_types::T_e8_TunerErrorType_IsValid(ErrorType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorType_, "T_e8_TunerErrorType", "ErrorType", "FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure");
    }
    #endif
    set_has_ErrorType();
    this->_ErrorType = ErrorType_;
}

inline void FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure::set_has_ErrorType () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure::clear_has_ErrorType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError::FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError::FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError (const FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError::~FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError() {
    deleteData ();
}

inline FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError& FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError::operator = (const FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError::operator == (const FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError::operator != (const FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError::operator < (const FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError::operator > (const FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError::FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorField FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError::getField () const {
    return __field;
}

inline void FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError::setField(FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError::FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError::clone() {
    return new FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError(*this);
}

inline bool FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure& FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure& FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure* FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError::replaceCcaErrorCode (FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError::setCcaErrorCode (const FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure(value);
    }
}

inline bool FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError::cloneData (const FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus::FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus ()  :
    _PresetIndex (0u),
    _PresetBand (0u),
    _ChannelInfo (),
    _LinearPresetIndex (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus::FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus (const FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _PresetIndex (0u),
    _PresetBand (0u),
    _ChannelInfo (),
    _LinearPresetIndex (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus::FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus (uint32 PresetIndex_, uint32 PresetBand_, const ::tunermaster_main_fi_types::T_PresetListEntry& ChannelInfo_, uint32 LinearPresetIndex_)  :
    _PresetIndex (PresetIndex_),
    _PresetBand (PresetBand_),
    _ChannelInfo (ChannelInfo_),
    _LinearPresetIndex (LinearPresetIndex_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus::~FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus() {
}

inline FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus& FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus::operator = (const FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPresetIndex()) {
            setPresetIndex(rhs.getPresetIndex());
        } else {
            clearPresetIndex();
        }
        if (rhs.hasPresetBand()) {
            setPresetBand(rhs.getPresetBand());
        } else {
            clearPresetBand();
        }
        if (rhs.hasChannelInfo()) {
            setChannelInfo(rhs.getChannelInfo());
        } else {
            clearChannelInfo();
        }
        if (rhs.hasLinearPresetIndex()) {
            setLinearPresetIndex(rhs.getLinearPresetIndex());
        } else {
            clearLinearPresetIndex();
        }
    }
    return *this;
}

inline bool FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus::operator == (const FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus& rhs) const {
    return (((!hasPresetIndex() && !rhs.hasPresetIndex()) || getPresetIndex() == rhs.getPresetIndex()) &&
        ((!hasPresetBand() && !rhs.hasPresetBand()) || getPresetBand() == rhs.getPresetBand()) &&
        ((!hasChannelInfo() && !rhs.hasChannelInfo()) || getChannelInfo() == rhs.getChannelInfo()) &&
        ((!hasLinearPresetIndex() && !rhs.hasLinearPresetIndex()) || getLinearPresetIndex() == rhs.getLinearPresetIndex()));
}

inline bool FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus::operator != (const FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus::operator < (const FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus& rhs) const {
    if (hasPresetIndex() || rhs.hasPresetIndex()) {
        if (getPresetIndex() < rhs.getPresetIndex()) return true;
        if (getPresetIndex() > rhs.getPresetIndex()) return false;
    }
    if (hasPresetBand() || rhs.hasPresetBand()) {
        if (getPresetBand() < rhs.getPresetBand()) return true;
        if (getPresetBand() > rhs.getPresetBand()) return false;
    }
    if (hasChannelInfo() || rhs.hasChannelInfo()) {
        if (getChannelInfo() < rhs.getChannelInfo()) return true;
        if (getChannelInfo() > rhs.getChannelInfo()) return false;
    }
    if (hasLinearPresetIndex() || rhs.hasLinearPresetIndex()) {
        if (getLinearPresetIndex() < rhs.getLinearPresetIndex()) return true;
        if (getLinearPresetIndex() > rhs.getLinearPresetIndex()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus::clone() {
    return new FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus(*this);
}

inline bool FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus::operator > (const FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus::clear() {
    clearPresetIndex();
    clearPresetBand();
    clearChannelInfo();
    clearLinearPresetIndex();
}

inline void FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus::clearPresetIndex() {
    if (hasPresetIndex()) {
         clear_has_PresetIndex();
        _PresetIndex = 0u;
     }
}

inline bool FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus::hasPresetIndex () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus::getPresetIndex () const {
    return _PresetIndex;
}

inline void FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus::setPresetIndex (uint32 PresetIndex_) {
    set_has_PresetIndex();
    this->_PresetIndex = PresetIndex_;
}

inline void FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus::clearPresetBand() {
    if (hasPresetBand()) {
         clear_has_PresetBand();
        _PresetBand = 0u;
     }
}

inline bool FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus::hasPresetBand () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus::getPresetBand () const {
    return _PresetBand;
}

inline void FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus::setPresetBand (uint32 PresetBand_) {
    set_has_PresetBand();
    this->_PresetBand = PresetBand_;
}

inline void FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus::clearChannelInfo() {
    if (hasChannelInfo()) {
         clear_has_ChannelInfo();
        _ChannelInfo.clear();
     }
}

inline bool FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus::hasChannelInfo () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::tunermaster_main_fi_types::T_PresetListEntry& FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus::getChannelInfo () const {
    return _ChannelInfo;
}

inline ::tunermaster_main_fi_types::T_PresetListEntry& FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus::getChannelInfoMutable () {
    set_has_ChannelInfo();
    return _ChannelInfo;
}

inline void FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus::setChannelInfo (const ::tunermaster_main_fi_types::T_PresetListEntry& ChannelInfo_) {
    set_has_ChannelInfo();
    this->_ChannelInfo = ChannelInfo_;
}

inline void FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus::clearLinearPresetIndex() {
    if (hasLinearPresetIndex()) {
         clear_has_LinearPresetIndex();
        _LinearPresetIndex = 0u;
     }
}

inline bool FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus::hasLinearPresetIndex () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus::getLinearPresetIndex () const {
    return _LinearPresetIndex;
}

inline void FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus::setLinearPresetIndex (uint32 LinearPresetIndex_) {
    set_has_LinearPresetIndex();
    this->_LinearPresetIndex = LinearPresetIndex_;
}

inline void FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus::set_has_PresetIndex () {
    _has_bits_[0] |= 1u << 0;
}

inline void FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus::clear_has_PresetIndex () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus::set_has_PresetBand () {
    _has_bits_[0] |= 1u << 1;
}

inline void FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus::clear_has_PresetBand () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus::set_has_ChannelInfo () {
    _has_bits_[0] |= 1u << 2;
}

inline void FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus::clear_has_ChannelInfo () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus::set_has_LinearPresetIndex () {
    _has_bits_[0] |= 1u << 3;
}

inline void FID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus::clear_has_LinearPresetIndex () {
    _has_bits_[0] &= ~ (1u << 3);
}

} // namespace tunermaster_main_fi

#endif // TUNERMASTER_MAIN_FI_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
