/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/cm/incTimeSync/IncTimeSync.h"
#include "org/bosch/cm/incTimeSync/IncTimeSyncDBus.h"
#include "org/bosch/cm/incTimeSync/IncTimeSyncJson.h"
#include "org/bosch/cm/incTimeSync/IncTimeSyncStub.h"

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bosch {
namespace cm {
namespace incTimeSync {
namespace IncTimeSync {

DEFINE_CLASS_LOGGER("/org/bosch/cm/incTimeSync/org/bosch/cm/incTimeSync/IncTimeSync", IncTimeSyncStub);


static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 10, "configData", 2 },
    { 12, "timesyncData", 0 },
    { 20, "incSendStartDelaySec", 1 },
};

class IncTimeSyncStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    IncTimeSyncStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    IncTimeSyncStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    IncTimeSyncStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.bosch.cm.incTimeSync.IncTimeSync"),
          _logger(logger) {}

    virtual ~IncTimeSyncStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void IncTimeSyncStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* IncTimeSyncStubDelegate::introspect() const {
    return     "<interface name=\"org.bosch.cm.incTimeSync.IncTimeSync\">\n"
            "    <property access=\"readwrite\" name=\"timesyncData\" type=\"(iii)\"/>\n"
            "    <property access=\"readwrite\" name=\"incSendStartDelaySec\" type=\"i\"/>\n"
            "    <property access=\"readwrite\" name=\"configData\" type=\"(ib)\"/>\n"
            "</interface>\n";
}

void IncTimeSyncStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<IncTimeSyncStub*>(getStub()))->onGetAll (properties);
}

void IncTimeSyncStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 3, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "timesyncData");
            ::boost::shared_ptr< TimesyncDataSet > payload(new TimesyncDataSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<IncTimeSyncStub*>(getStub())->onTimesyncDataSet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "incSendStartDelaySec");
            ::boost::shared_ptr< IncSendStartDelaySecSet > payload(new IncSendStartDelaySecSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<IncTimeSyncStub*>(getStub())->onIncSendStartDelaySecSet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "configData");
            ::boost::shared_ptr< ConfigDataSet > payload(new ConfigDataSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<IncTimeSyncStub*>(getStub())->onConfigDataSet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void IncTimeSyncStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 3, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "timesyncData");
            ::boost::shared_ptr< TimesyncDataGet > payload(new TimesyncDataGet());
            payload->setAct(act);
            static_cast<IncTimeSyncStub*>(getStub())->onTimesyncDataGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "incSendStartDelaySec");
            ::boost::shared_ptr< IncSendStartDelaySecGet > payload(new IncSendStartDelaySecGet());
            payload->setAct(act);
            static_cast<IncTimeSyncStub*>(getStub())->onIncSendStartDelaySecGet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "configData");
            ::boost::shared_ptr< ConfigDataGet > payload(new ConfigDataGet());
            payload->setAct(act);
            static_cast<IncTimeSyncStub*>(getStub())->onConfigDataGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

IncTimeSyncStub::IncTimeSyncStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new IncTimeSyncStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

IncTimeSyncStub::IncTimeSyncStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new IncTimeSyncStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

IncTimeSyncStub::~IncTimeSyncStub() {
    delete _stubDelegate;
}

void IncTimeSyncStub::sendTimesyncDataUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        TimesyncDataUpdate payload(_timesyncDataProperty);

        LOG_INFO ("-> send%s", "TimesyncDataUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("timesyncData", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.incTimeSync.IncTimeSync", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "TimesyncDataUpdate");
    }
}

void IncTimeSyncStub::onTimesyncDataGet(const ::boost::shared_ptr< TimesyncDataGet >& timesyncData) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "TimesyncDataGet", timesyncData->getAct());
    sendTimesyncDataGetUpdate(_timesyncDataProperty.getTimesyncData(), timesyncData->getAct());
}

void IncTimeSyncStub::sendTimesyncDataGetUpdate(const IncTimeStampSyncStruct& timesyncData, act_t act) {
    ::asf::dbus::DBusVariant variant;
    TimesyncDataGet payload(timesyncData);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "TimesyncDataGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void IncTimeSyncStub::onTimesyncDataSet(const ::boost::shared_ptr< TimesyncDataSet >& timesyncData) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "TimesyncDataSet", timesyncData->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*timesyncData, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setTimesyncData (timesyncData->getTimesyncData());
    sendTimesyncDataSetUpdate(timesyncData->getAct());
}

void IncTimeSyncStub::sendTimesyncDataSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "TimesyncDataSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void IncTimeSyncStub::setTimesyncData(const IncTimeStampSyncStruct& timesyncData) {
    if(timesyncData!=_timesyncDataProperty.getTimesyncData()) {
        _timesyncDataProperty.setTimesyncData(timesyncData);
        sendTimesyncDataUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const IncTimeStampSyncStruct& IncTimeSyncStub::getTimesyncData() const {
    return _timesyncDataProperty.getTimesyncData();
}

IncTimeStampSyncStruct& IncTimeSyncStub::getTimesyncDataMutable() {
    return _timesyncDataProperty.getTimesyncDataMutable();
}

void IncTimeSyncStub::sendIncSendStartDelaySecUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        IncSendStartDelaySecUpdate payload(_incSendStartDelaySecProperty);

        LOG_INFO ("-> send%s", "IncSendStartDelaySecUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("incSendStartDelaySec", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.incTimeSync.IncTimeSync", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "IncSendStartDelaySecUpdate");
    }
}

void IncTimeSyncStub::onIncSendStartDelaySecGet(const ::boost::shared_ptr< IncSendStartDelaySecGet >& incSendStartDelaySec) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "IncSendStartDelaySecGet", incSendStartDelaySec->getAct());
    sendIncSendStartDelaySecGetUpdate(_incSendStartDelaySecProperty.getIncSendStartDelaySec(), incSendStartDelaySec->getAct());
}

void IncTimeSyncStub::sendIncSendStartDelaySecGetUpdate(int32 incSendStartDelaySec, act_t act) {
    ::asf::dbus::DBusVariant variant;
    IncSendStartDelaySecGet payload(incSendStartDelaySec);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "IncSendStartDelaySecGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void IncTimeSyncStub::onIncSendStartDelaySecSet(const ::boost::shared_ptr< IncSendStartDelaySecSet >& incSendStartDelaySec) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "IncSendStartDelaySecSet", incSendStartDelaySec->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*incSendStartDelaySec, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setIncSendStartDelaySec (incSendStartDelaySec->getIncSendStartDelaySec());
    sendIncSendStartDelaySecSetUpdate(incSendStartDelaySec->getAct());
}

void IncTimeSyncStub::sendIncSendStartDelaySecSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "IncSendStartDelaySecSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void IncTimeSyncStub::setIncSendStartDelaySec(int32 incSendStartDelaySec) {
    if(incSendStartDelaySec!=_incSendStartDelaySecProperty.getIncSendStartDelaySec()) {
        _incSendStartDelaySecProperty.setIncSendStartDelaySec(incSendStartDelaySec);
        sendIncSendStartDelaySecUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

int32 IncTimeSyncStub::getIncSendStartDelaySec() const {
    return _incSendStartDelaySecProperty.getIncSendStartDelaySec();
}

void IncTimeSyncStub::sendConfigDataUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ConfigDataUpdate payload(_configDataProperty);

        LOG_INFO ("-> send%s", "ConfigDataUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("configData", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.incTimeSync.IncTimeSync", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ConfigDataUpdate");
    }
}

void IncTimeSyncStub::onConfigDataGet(const ::boost::shared_ptr< ConfigDataGet >& configData) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ConfigDataGet", configData->getAct());
    sendConfigDataGetUpdate(_configDataProperty.getConfigData(), configData->getAct());
}

void IncTimeSyncStub::sendConfigDataGetUpdate(const IncTimeStampSyncConfig& configData, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ConfigDataGet payload(configData);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ConfigDataGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void IncTimeSyncStub::onConfigDataSet(const ::boost::shared_ptr< ConfigDataSet >& configData) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ConfigDataSet", configData->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*configData, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setConfigData (configData->getConfigData());
    sendConfigDataSetUpdate(configData->getAct());
}

void IncTimeSyncStub::sendConfigDataSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ConfigDataSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void IncTimeSyncStub::setConfigData(const IncTimeStampSyncConfig& configData) {
    if(configData!=_configDataProperty.getConfigData()) {
        _configDataProperty.setConfigData(configData);
        sendConfigDataUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const IncTimeStampSyncConfig& IncTimeSyncStub::getConfigData() const {
    return _configDataProperty.getConfigData();
}

IncTimeStampSyncConfig& IncTimeSyncStub::getConfigDataMutable() {
    return _configDataProperty.getConfigDataMutable();
}

void IncTimeSyncStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'timesyncData'
    {
        ::asf::dbus::DBusVariant variant;
        TimesyncDataGet payload(_timesyncDataProperty.getTimesyncData());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("timesyncData", variant));
    }

    //property 'incSendStartDelaySec'
    {
        ::asf::dbus::DBusVariant variant;
        IncSendStartDelaySecGet payload(_incSendStartDelaySecProperty.getIncSendStartDelaySec());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("incSendStartDelaySec", variant));
    }

    //property 'configData'
    {
        ::asf::dbus::DBusVariant variant;
        ConfigDataGet payload(_configDataProperty.getConfigData());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("configData", variant));
    }
}

} // namespace IncTimeSync
} // namespace incTimeSync
} // namespace cm
} // namespace bosch
} // namespace org
