/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/cca/CcaTypesConst.h"
#include "asf/core/Types.h"
#include "asf/stream/json.h"
#include "tcu_usb_main_fi.h"
#include "tcu_usb_main_fiJson.h"
#include "tcu_usb_main_fiJsonPrivate.h"
#include "tcu_usb_main_fi_types.h"
#include "tcu_usb_main_fi_typesConst.h"
#include "tcu_usb_main_fi_typesJsonPrivate.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

using namespace ::asf::stream::json;


// Json serialization of "FolderData"

void serializeJson (const ::tcu_usb_main_fi::FolderData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasFolderID()) {
        yajl_gen_string(g, (const unsigned char*)  "FolderID" , 8);
        yajl_gen_integer(g, (long long)value.getFolderID());
    }
    if (!isSparse || value.hasFolderName()) {
        yajl_gen_string(g, (const unsigned char*)  "FolderName" , 10);
        const char *s = value.getFolderName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::FolderData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ChannelData"

void serializeJson (const ::tcu_usb_main_fi::ChannelData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasChannelID()) {
        yajl_gen_string(g, (const unsigned char*)  "ChannelID" , 9);
        const char *s = value.getChannelID().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasChannelName()) {
        yajl_gen_string(g, (const unsigned char*)  "ChannelName" , 11);
        const char *s = value.getChannelName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasChannelIconID()) {
        yajl_gen_string(g, (const unsigned char*)  "ChannelIconID" , 13);
        yajl_gen_integer(g, (long long)value.getChannelIconID());
    }
    if (!isSparse || value.hasFlagOfChannelInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "FlagOfChannelInfo" , 17);
        yajl_gen_integer(g, (long long)value.getFlagOfChannelInfo());
    }
    if (!isSparse || value.hasStoredNumOfChannelContents()) {
        yajl_gen_string(g, (const unsigned char*)  "StoredNumOfChannelContents" , 26);
        yajl_gen_integer(g, (long long)value.getStoredNumOfChannelContents());
    }
    if (!isSparse || value.hasTotalNumOfChannelContents()) {
        yajl_gen_string(g, (const unsigned char*)  "TotalNumOfChannelContents" , 25);
        yajl_gen_integer(g, (long long)value.getTotalNumOfChannelContents());
    }
    if (!isSparse || value.hasServiceType()) {
        yajl_gen_string(g, (const unsigned char*)  "ServiceType" , 11);
        yajl_gen_integer(g, (long long)value.getServiceType());
    }
    if (!isSparse || value.hasFolderID()) {
        yajl_gen_string(g, (const unsigned char*)  "FolderID" , 8);
        yajl_gen_integer(g, (long long)value.getFolderID());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::ChannelData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ContentData"

void serializeJson (const ::tcu_usb_main_fi::ContentData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasChannelContentsID()) {
        yajl_gen_string(g, (const unsigned char*)  "ChannelContentsID" , 17);
        yajl_gen_integer(g, (long long)value.getChannelContentsID());
    }
    if (!isSparse || value.hasTitle()) {
        yajl_gen_string(g, (const unsigned char*)  "Title" , 5);
        const char *s = value.getTitle().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTitleForTTS()) {
        yajl_gen_string(g, (const unsigned char*)  "TitleForTTS" , 11);
        const char *s = value.getTitleForTTS().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasDirection()) {
        yajl_gen_string(g, (const unsigned char*)  "Direction" , 9);
        yajl_gen_integer(g, (long long)value.getDirection());
    }
    if (!isSparse || value.hasLAT()) {
        yajl_gen_string(g, (const unsigned char*)  "LAT" , 3);
        yajl_gen_integer(g, (long long)value.getLAT());
    }
    if (!isSparse || value.hasLON()) {
        yajl_gen_string(g, (const unsigned char*)  "LON" , 3);
        yajl_gen_integer(g, (long long)value.getLON());
    }
    if (!isSparse || value.hasLocationAttribute()) {
        yajl_gen_string(g, (const unsigned char*)  "LocationAttribute" , 17);
        yajl_gen_integer(g, (long long)value.getLocationAttribute());
    }
    if (!isSparse || value.hasDestOrWayPointType()) {
        yajl_gen_string(g, (const unsigned char*)  "DestOrWayPointType" , 18);
        yajl_gen_integer(g, (long long)value.getDestOrWayPointType());
    }
    if (!isSparse || value.hasAddress()) {
        yajl_gen_string(g, (const unsigned char*)  "Address" , 7);
        const char *s = value.getAddress().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasPhoneNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "PhoneNumber" , 11);
        const char *s = value.getPhoneNumber().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasPhoneNumberForDisp()) {
        yajl_gen_string(g, (const unsigned char*)  "PhoneNumberForDisp" , 18);
        const char *s = value.getPhoneNumberForDisp().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasText()) {
        yajl_gen_string(g, (const unsigned char*)  "Text" , 4);
        const char *s = value.getText().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTextForTTS()) {
        yajl_gen_string(g, (const unsigned char*)  "TextForTTS" , 10);
        const char *s = value.getTextForTTS().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasIconID()) {
        yajl_gen_string(g, (const unsigned char*)  "IconID" , 6);
        yajl_gen_integer(g, (long long)value.getIconID());
    }
    if (!isSparse || value.hasSoundIDForBeginningOfPlay()) {
        yajl_gen_string(g, (const unsigned char*)  "SoundIDForBeginningOfPlay" , 25);
        yajl_gen_integer(g, (long long)value.getSoundIDForBeginningOfPlay());
    }
    if (!isSparse || value.hasSoundIDForBGM()) {
        yajl_gen_string(g, (const unsigned char*)  "SoundIDForBGM" , 13);
        yajl_gen_integer(g, (long long)value.getSoundIDForBGM());
    }
    if (!isSparse || value.hasActionSWID()) {
        yajl_gen_string(g, (const unsigned char*)  "ActionSWID" , 10);
        yajl_gen_integer(g, (long long)value.getActionSWID());
    }
    if (!isSparse || value.hasParameterOfActionSW()) {
        yajl_gen_string(g, (const unsigned char*)  "ParameterOfActionSW" , 19);
        yajl_gen_integer(g, (long long)value.getParameterOfActionSW());
    }
    if (!isSparse || value.hasFlagOfDispButtonCtrl()) {
        yajl_gen_string(g, (const unsigned char*)  "FlagOfDispButtonCtrl" , 20);
        yajl_gen_integer(g, (long long)value.getFlagOfDispButtonCtrl());
    }
    if (!isSparse || value.hasFlagOfCtrlDuringRunning()) {
        yajl_gen_string(g, (const unsigned char*)  "FlagOfCtrlDuringRunning" , 23);
        yajl_gen_integer(g, (long long)value.getFlagOfCtrlDuringRunning());
    }
    if (!isSparse || value.hasNameOfImageButton()) {
        yajl_gen_string(g, (const unsigned char*)  "NameOfImageButton" , 17);
        const char *s = value.getNameOfImageButton().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasNameOfActionSW()) {
        yajl_gen_string(g, (const unsigned char*)  "NameOfActionSW" , 14);
        const char *s = value.getNameOfActionSW().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasFlagOfExecOfChannelContents()) {
        yajl_gen_string(g, (const unsigned char*)  "FlagOfExecOfChannelContents" , 27);
        yajl_gen_integer(g, (long long)value.getFlagOfExecOfChannelContents());
    }
    if (!isSparse || value.hasFlagOfStoringCtrl()) {
        yajl_gen_string(g, (const unsigned char*)  "FlagOfStoringCtrl" , 17);
        yajl_gen_integer(g, (long long)value.getFlagOfStoringCtrl());
    }
    if (!isSparse || value.hasImageAvailability()) {
        yajl_gen_string(g, (const unsigned char*)  "ImageAvailability" , 17);
        yajl_gen_integer(g, (long long)value.getImageAvailability());
    }
    if (!isSparse || value.hasImagePath()) {
        yajl_gen_string(g, (const unsigned char*)  "ImagePath" , 9);
        const char *s = value.getImagePath().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasChannelID()) {
        yajl_gen_string(g, (const unsigned char*)  "ChannelID" , 9);
        yajl_gen_integer(g, (long long)value.getChannelID());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::ContentData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ChannelDataIVM"

void serializeJson (const ::tcu_usb_main_fi::ChannelDataIVM& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasIndexInternal()) {
        yajl_gen_string(g, (const unsigned char*)  "IndexInternal" , 13);
        yajl_gen_integer(g, (long long)value.getIndexInternal());
    }
    if (!isSparse || value.hasChannelID()) {
        yajl_gen_string(g, (const unsigned char*)  "ChannelID" , 9);
        yajl_gen_integer(g, (long long)value.getChannelID());
    }
    if (!isSparse || value.hasChannelName()) {
        yajl_gen_string(g, (const unsigned char*)  "ChannelName" , 11);
        const char *s = value.getChannelName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSubChannelNum()) {
        yajl_gen_string(g, (const unsigned char*)  "SubChannelNum" , 13);
        yajl_gen_integer(g, (long long)value.getSubChannelNum());
    }
    if (!isSparse || value.hasStoredNumOfChannelContents()) {
        yajl_gen_string(g, (const unsigned char*)  "StoredNumOfChannelContents" , 26);
        yajl_gen_integer(g, (long long)value.getStoredNumOfChannelContents());
    }
    if (!isSparse || value.hasTotalNumOfChannelContents()) {
        yajl_gen_string(g, (const unsigned char*)  "TotalNumOfChannelContents" , 25);
        yajl_gen_integer(g, (long long)value.getTotalNumOfChannelContents());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::ChannelDataIVM& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ContentDataIVM"

void serializeJson (const ::tcu_usb_main_fi::ContentDataIVM& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasChannelContentsID()) {
        yajl_gen_string(g, (const unsigned char*)  "ChannelContentsID" , 17);
        yajl_gen_integer(g, (long long)value.getChannelContentsID());
    }
    if (!isSparse || value.hasIndexInternal()) {
        yajl_gen_string(g, (const unsigned char*)  "IndexInternal" , 13);
        const char *s = value.getIndexInternal().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTitle()) {
        yajl_gen_string(g, (const unsigned char*)  "Title" , 5);
        const char *s = value.getTitle().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTitleForTTS()) {
        yajl_gen_string(g, (const unsigned char*)  "TitleForTTS" , 11);
        const char *s = value.getTitleForTTS().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasDirection()) {
        yajl_gen_string(g, (const unsigned char*)  "Direction" , 9);
        yajl_gen_integer(g, (long long)value.getDirection());
    }
    if (!isSparse || value.hasLAT()) {
        yajl_gen_string(g, (const unsigned char*)  "LAT" , 3);
        yajl_gen_integer(g, (long long)value.getLAT());
    }
    if (!isSparse || value.hasLON()) {
        yajl_gen_string(g, (const unsigned char*)  "LON" , 3);
        yajl_gen_integer(g, (long long)value.getLON());
    }
    if (!isSparse || value.hasLocationAttribute()) {
        yajl_gen_string(g, (const unsigned char*)  "LocationAttribute" , 17);
        yajl_gen_integer(g, (long long)value.getLocationAttribute());
    }
    if (!isSparse || value.hasDestOrWayPointType()) {
        yajl_gen_string(g, (const unsigned char*)  "DestOrWayPointType" , 18);
        yajl_gen_integer(g, (long long)value.getDestOrWayPointType());
    }
    if (!isSparse || value.hasAddress()) {
        yajl_gen_string(g, (const unsigned char*)  "Address" , 7);
        const char *s = value.getAddress().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasPhoneNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "PhoneNumber" , 11);
        const char *s = value.getPhoneNumber().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasPhoneNumberForDisp()) {
        yajl_gen_string(g, (const unsigned char*)  "PhoneNumberForDisp" , 18);
        const char *s = value.getPhoneNumberForDisp().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasText()) {
        yajl_gen_string(g, (const unsigned char*)  "Text" , 4);
        const char *s = value.getText().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTextForTTS()) {
        yajl_gen_string(g, (const unsigned char*)  "TextForTTS" , 10);
        const char *s = value.getTextForTTS().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasIconID()) {
        yajl_gen_string(g, (const unsigned char*)  "IconID" , 6);
        yajl_gen_integer(g, (long long)value.getIconID());
    }
    if (!isSparse || value.hasSoundIDForBeginningOfPlay()) {
        yajl_gen_string(g, (const unsigned char*)  "SoundIDForBeginningOfPlay" , 25);
        yajl_gen_integer(g, (long long)value.getSoundIDForBeginningOfPlay());
    }
    if (!isSparse || value.hasSoundIDForBGM()) {
        yajl_gen_string(g, (const unsigned char*)  "SoundIDForBGM" , 13);
        yajl_gen_integer(g, (long long)value.getSoundIDForBGM());
    }
    if (!isSparse || value.hasActionSWID()) {
        yajl_gen_string(g, (const unsigned char*)  "ActionSWID" , 10);
        yajl_gen_integer(g, (long long)value.getActionSWID());
    }
    if (!isSparse || value.hasParameterOfActionSW()) {
        yajl_gen_string(g, (const unsigned char*)  "ParameterOfActionSW" , 19);
        yajl_gen_integer(g, (long long)value.getParameterOfActionSW());
    }
    if (!isSparse || value.hasFlagOfDispButtonCtrl()) {
        yajl_gen_string(g, (const unsigned char*)  "FlagOfDispButtonCtrl" , 20);
        yajl_gen_integer(g, (long long)value.getFlagOfDispButtonCtrl());
    }
    if (!isSparse || value.hasFlagOfCtrlDuringRunning()) {
        yajl_gen_string(g, (const unsigned char*)  "FlagOfCtrlDuringRunning" , 23);
        yajl_gen_integer(g, (long long)value.getFlagOfCtrlDuringRunning());
    }
    if (!isSparse || value.hasNameOfImageButton()) {
        yajl_gen_string(g, (const unsigned char*)  "NameOfImageButton" , 17);
        const char *s = value.getNameOfImageButton().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasNameOfActionSW()) {
        yajl_gen_string(g, (const unsigned char*)  "NameOfActionSW" , 14);
        const char *s = value.getNameOfActionSW().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasFlagOfExecOfChannelContents()) {
        yajl_gen_string(g, (const unsigned char*)  "FlagOfExecOfChannelContents" , 27);
        yajl_gen_integer(g, (long long)value.getFlagOfExecOfChannelContents());
    }
    if (!isSparse || value.hasFlagOfStoringCtrl()) {
        yajl_gen_string(g, (const unsigned char*)  "FlagOfStoringCtrl" , 17);
        yajl_gen_integer(g, (long long)value.getFlagOfStoringCtrl());
    }
    if (!isSparse || value.hasImageAvailability()) {
        yajl_gen_string(g, (const unsigned char*)  "ImageAvailability" , 17);
        yajl_gen_integer(g, (long long)value.getImageAvailability());
    }
    if (!isSparse || value.hasImagePath()) {
        yajl_gen_string(g, (const unsigned char*)  "ImagePath" , 9);
        const char *s = value.getImagePath().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::ContentDataIVM& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetChannelDataStart"

void serializeJson (const ::tcu_usb_main_fi::GetChannelDataStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasChannel_Info_List()) {
        yajl_gen_string(g, (const unsigned char*)  "Channel_Info_List" , 17);
        yajl_gen_array_open(g);
        const ::std::vector< ::tcu_usb_main_fi_types::T_usb_tcu_Channel_Info >& o1 = value.getChannel_Info_List();
        {
            ::std::vector< ::tcu_usb_main_fi_types::T_usb_tcu_Channel_Info >::const_iterator o0;
            for (o0 = o1.begin(); o0 != o1.end(); ++o0) {
                serializeJson((*o0), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasBBackgroundDownloadType()) {
        yajl_gen_string(g, (const unsigned char*)  "bBackgroundDownloadType" , 23);
        yajl_gen_bool(g, (bool)value.getBBackgroundDownloadType());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::GetChannelDataStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetChannelDataErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::GetChannelDataErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::GetChannelDataErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetChannelDataError"

void serializeJson (const ::tcu_usb_main_fi::GetChannelDataError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::GetChannelDataError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::GetChannelDataError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::GetChannelDataError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetConnectedSearchResultStart"

void serializeJson (const ::tcu_usb_main_fi::GetConnectedSearchResultStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8SizeOfKeyWord()) {
        yajl_gen_string(g, (const unsigned char*)  "u8SizeOfKeyWord" , 15);
        yajl_gen_integer(g, (long long)value.getU8SizeOfKeyWord());
    }
    if (!isSparse || value.hasStrKeyWord()) {
        yajl_gen_string(g, (const unsigned char*)  "strKeyWord" , 10);
        const char *s = value.getStrKeyWord().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::GetConnectedSearchResultStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetConnectedSearchResultErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::GetConnectedSearchResultErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::GetConnectedSearchResultErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetConnectedSearchResultError"

void serializeJson (const ::tcu_usb_main_fi::GetConnectedSearchResultError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::GetConnectedSearchResultError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::GetConnectedSearchResultError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::GetConnectedSearchResultError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetChannelMasterDataStart"

void serializeJson (const ::tcu_usb_main_fi::GetChannelMasterDataStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBBackgroundDownloadType()) {
        yajl_gen_string(g, (const unsigned char*)  "bBackgroundDownloadType" , 23);
        yajl_gen_bool(g, (bool)value.getBBackgroundDownloadType());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::GetChannelMasterDataStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetChannelMasterDataErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::GetChannelMasterDataErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::GetChannelMasterDataErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetChannelMasterDataError"

void serializeJson (const ::tcu_usb_main_fi::GetChannelMasterDataError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::GetChannelMasterDataError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::GetChannelMasterDataError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::GetChannelMasterDataError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SynthesizeSpeakStart"

void serializeJson (const ::tcu_usb_main_fi::SynthesizeSpeakStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTextAndTags()) {
        yajl_gen_string(g, (const unsigned char*)  "TextAndTags" , 11);
        const char *s = value.getTextAndTags().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU16ChannelID()) {
        yajl_gen_string(g, (const unsigned char*)  "u16ChannelID" , 12);
        yajl_gen_integer(g, (long long)value.getU16ChannelID());
    }
    if (!isSparse || value.hasU8ChannelContentsID()) {
        yajl_gen_string(g, (const unsigned char*)  "u8ChannelContentsID" , 19);
        yajl_gen_integer(g, (long long)value.getU8ChannelContentsID());
    }
    if (!isSparse || value.hasBHoldAudioChannel()) {
        yajl_gen_string(g, (const unsigned char*)  "bHoldAudioChannel" , 17);
        yajl_gen_bool(g, (bool)value.getBHoldAudioChannel());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::SynthesizeSpeakStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AbortPromptStart"

void serializeJson (const ::tcu_usb_main_fi::AbortPromptStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBHoldAudioChannel()) {
        yajl_gen_string(g, (const unsigned char*)  "bHoldAudioChannel" , 17);
        yajl_gen_bool(g, (bool)value.getBHoldAudioChannel());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::AbortPromptStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CancelRequestStart"

void serializeJson (const ::tcu_usb_main_fi::CancelRequestStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasECancelRequestType()) {
        yajl_gen_string(g, (const unsigned char*)  "eCancelRequestType" , 18);
        const char* s = ::tcu_usb_main_fi_types::T_e8_CancelRequestType_Name(value.getECancelRequestType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getECancelRequestType());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::CancelRequestStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CancelRequestErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::CancelRequestErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::CancelRequestErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CancelRequestError"

void serializeJson (const ::tcu_usb_main_fi::CancelRequestError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::CancelRequestError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::CancelRequestError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::CancelRequestError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SendGroupADataStart"

void serializeJson (const ::tcu_usb_main_fi::SendGroupADataStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasGroupA_Info()) {
        yajl_gen_string(g, (const unsigned char*)  "GroupA_Info" , 11);
        serializeJson(value.getGroupA_Info(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::SendGroupADataStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SendGroupADataErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::SendGroupADataErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::SendGroupADataErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SendGroupADataError"

void serializeJson (const ::tcu_usb_main_fi::SendGroupADataError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::SendGroupADataError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::SendGroupADataError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::SendGroupADataError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeleteInVehicleMessageStart"

void serializeJson (const ::tcu_usb_main_fi::DeleteInVehicleMessageStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasS64IndexInternal()) {
        yajl_gen_string(g, (const unsigned char*)  "s64IndexInternal" , 16);
        yajl_gen_integer(g, (long long)value.getS64IndexInternal());
    }
    if (!isSparse || value.hasU8ChannelContentsID()) {
        yajl_gen_string(g, (const unsigned char*)  "u8ChannelContentsID" , 19);
        yajl_gen_integer(g, (long long)value.getU8ChannelContentsID());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::DeleteInVehicleMessageStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeleteInVehicleMessageErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::DeleteInVehicleMessageErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::DeleteInVehicleMessageErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeleteInVehicleMessageError"

void serializeJson (const ::tcu_usb_main_fi::DeleteInVehicleMessageError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::DeleteInVehicleMessageError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::DeleteInVehicleMessageError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::DeleteInVehicleMessageError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ResetDatabaseErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::ResetDatabaseErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::ResetDatabaseErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ResetDatabaseError"

void serializeJson (const ::tcu_usb_main_fi::ResetDatabaseError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::ResetDatabaseError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::ResetDatabaseError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::ResetDatabaseError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetServerListErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::GetServerListErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::GetServerListErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetServerListError"

void serializeJson (const ::tcu_usb_main_fi::GetServerListError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::GetServerListError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::GetServerListError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::GetServerListError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SelectServerStart"

void serializeJson (const ::tcu_usb_main_fi::SelectServerStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8ServerId()) {
        yajl_gen_string(g, (const unsigned char*)  "u8ServerId" , 10);
        yajl_gen_integer(g, (long long)value.getU8ServerId());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::SelectServerStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SelectServerErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::SelectServerErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::SelectServerErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SelectServerError"

void serializeJson (const ::tcu_usb_main_fi::SelectServerError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::SelectServerError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::SelectServerError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::SelectServerError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RetryGetChannelDataStart"

void serializeJson (const ::tcu_usb_main_fi::RetryGetChannelDataStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU16ChannelID()) {
        yajl_gen_string(g, (const unsigned char*)  "u16ChannelID" , 12);
        yajl_gen_integer(g, (long long)value.getU16ChannelID());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::RetryGetChannelDataStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RetryGetChannelDataErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::RetryGetChannelDataErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::RetryGetChannelDataErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RetryGetChannelDataError"

void serializeJson (const ::tcu_usb_main_fi::RetryGetChannelDataError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::RetryGetChannelDataError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::RetryGetChannelDataError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::RetryGetChannelDataError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "OverwriteIVMTotalContentsStart"

void serializeJson (const ::tcu_usb_main_fi::OverwriteIVMTotalContentsStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU16ChannelID()) {
        yajl_gen_string(g, (const unsigned char*)  "u16ChannelID" , 12);
        yajl_gen_integer(g, (long long)value.getU16ChannelID());
    }
    if (!isSparse || value.hasS64IndexInternal()) {
        yajl_gen_string(g, (const unsigned char*)  "s64IndexInternal" , 16);
        yajl_gen_integer(g, (long long)value.getS64IndexInternal());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::OverwriteIVMTotalContentsStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "OverwriteIVMTotalContentsErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::OverwriteIVMTotalContentsErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::OverwriteIVMTotalContentsErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "OverwriteIVMTotalContentsError"

void serializeJson (const ::tcu_usb_main_fi::OverwriteIVMTotalContentsError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::OverwriteIVMTotalContentsError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::OverwriteIVMTotalContentsError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::OverwriteIVMTotalContentsError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StoreCSHistoryStart"

void serializeJson (const ::tcu_usb_main_fi::StoreCSHistoryStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStrKeyWord()) {
        yajl_gen_string(g, (const unsigned char*)  "strKeyWord" , 10);
        const char *s = value.getStrKeyWord().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::StoreCSHistoryStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StoreCSHistoryErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::StoreCSHistoryErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::StoreCSHistoryErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StoreCSHistoryError"

void serializeJson (const ::tcu_usb_main_fi::StoreCSHistoryError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::StoreCSHistoryError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::StoreCSHistoryError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::StoreCSHistoryError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetTCUDeviceInfoErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::GetTCUDeviceInfoErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::GetTCUDeviceInfoErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetTCUDeviceInfoError"

void serializeJson (const ::tcu_usb_main_fi::GetTCUDeviceInfoError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::GetTCUDeviceInfoError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::GetTCUDeviceInfoError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::GetTCUDeviceInfoError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetLogLevelStart"

void serializeJson (const ::tcu_usb_main_fi::SetLogLevelStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8LogLevel()) {
        yajl_gen_string(g, (const unsigned char*)  "u8LogLevel" , 10);
        const char* s = ::tcu_usb_main_fi_types::T_e8_tcu_LogLevel_Name(value.getU8LogLevel());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getU8LogLevel());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::SetLogLevelStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetLogLevelErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::SetLogLevelErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::SetLogLevelErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetLogLevelError"

void serializeJson (const ::tcu_usb_main_fi::SetLogLevelError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::SetLogLevelError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::SetLogLevelError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::SetLogLevelError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RestoreFactorySettingsErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::RestoreFactorySettingsErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::RestoreFactorySettingsErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RestoreFactorySettingsError"

void serializeJson (const ::tcu_usb_main_fi::RestoreFactorySettingsError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::RestoreFactorySettingsError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::RestoreFactorySettingsError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::RestoreFactorySettingsError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeleteMessageBoxErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::DeleteMessageBoxErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::DeleteMessageBoxErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeleteMessageBoxError"

void serializeJson (const ::tcu_usb_main_fi::DeleteMessageBoxError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::DeleteMessageBoxError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::DeleteMessageBoxError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::DeleteMessageBoxError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "InitializeFeedListErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::InitializeFeedListErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::InitializeFeedListErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "InitializeFeedListError"

void serializeJson (const ::tcu_usb_main_fi::InitializeFeedListError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::InitializeFeedListError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::InitializeFeedListError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::InitializeFeedListError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetAutoDownloadIntervalStart"

void serializeJson (const ::tcu_usb_main_fi::SetAutoDownloadIntervalStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAutoDownloadInterval()) {
        yajl_gen_string(g, (const unsigned char*)  "AutoDownloadInterval" , 20);
        const char* s = ::tcu_usb_main_fi_types::T_e8_AutoDownloadInterval_Name(value.getAutoDownloadInterval());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getAutoDownloadInterval());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::SetAutoDownloadIntervalStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetAutoDownloadIntervalErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::SetAutoDownloadIntervalErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::SetAutoDownloadIntervalErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetAutoDownloadIntervalError"

void serializeJson (const ::tcu_usb_main_fi::SetAutoDownloadIntervalError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::SetAutoDownloadIntervalError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::SetAutoDownloadIntervalError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::SetAutoDownloadIntervalError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetAutoDownloadIntervalErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::GetAutoDownloadIntervalErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::GetAutoDownloadIntervalErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetAutoDownloadIntervalError"

void serializeJson (const ::tcu_usb_main_fi::GetAutoDownloadIntervalError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::GetAutoDownloadIntervalError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::GetAutoDownloadIntervalError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::GetAutoDownloadIntervalError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetAutoDownloadChannelStart"

void serializeJson (const ::tcu_usb_main_fi::SetAutoDownloadChannelStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasChannel_Info_List()) {
        yajl_gen_string(g, (const unsigned char*)  "Channel_Info_List" , 17);
        yajl_gen_array_open(g);
        const ::std::vector< ::tcu_usb_main_fi_types::T_usb_tcu_Channel_Info >& o3 = value.getChannel_Info_List();
        {
            ::std::vector< ::tcu_usb_main_fi_types::T_usb_tcu_Channel_Info >::const_iterator o2;
            for (o2 = o3.begin(); o2 != o3.end(); ++o2) {
                serializeJson((*o2), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::SetAutoDownloadChannelStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetAutoDownloadChannelErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::SetAutoDownloadChannelErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::SetAutoDownloadChannelErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetAutoDownloadChannelError"

void serializeJson (const ::tcu_usb_main_fi::SetAutoDownloadChannelError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::SetAutoDownloadChannelError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::SetAutoDownloadChannelError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::SetAutoDownloadChannelError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetFavoriteChannelListErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::GetFavoriteChannelListErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::GetFavoriteChannelListErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetFavoriteChannelListError"

void serializeJson (const ::tcu_usb_main_fi::GetFavoriteChannelListError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::GetFavoriteChannelListError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::GetFavoriteChannelListError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::GetFavoriteChannelListError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetFavoriteChannelStart"

void serializeJson (const ::tcu_usb_main_fi::SetFavoriteChannelStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasChannel_Info_List()) {
        yajl_gen_string(g, (const unsigned char*)  "Channel_Info_List" , 17);
        yajl_gen_array_open(g);
        const ::std::vector< ::tcu_usb_main_fi_types::T_usb_tcu_Channel_Info >& o5 = value.getChannel_Info_List();
        {
            ::std::vector< ::tcu_usb_main_fi_types::T_usb_tcu_Channel_Info >::const_iterator o4;
            for (o4 = o5.begin(); o4 != o5.end(); ++o4) {
                serializeJson((*o4), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::SetFavoriteChannelStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetFavoriteChannelErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::SetFavoriteChannelErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::SetFavoriteChannelErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetFavoriteChannelError"

void serializeJson (const ::tcu_usb_main_fi::SetFavoriteChannelError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::SetFavoriteChannelError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::SetFavoriteChannelError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::SetFavoriteChannelError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReadFavoriteFeedsResult"

void serializeJson (const ::tcu_usb_main_fi::ReadFavoriteFeedsResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasFavorite_Feed_List()) {
        yajl_gen_string(g, (const unsigned char*)  "Favorite_Feed_List" , 18);
        yajl_gen_array_open(g);
        const ::std::vector< ::tcu_usb_main_fi_types::T_usb_tcu_Favorite_channel_info >& o7 = value.getFavorite_Feed_List();
        {
            ::std::vector< ::tcu_usb_main_fi_types::T_usb_tcu_Favorite_channel_info >::const_iterator o6;
            for (o6 = o7.begin(); o6 != o7.end(); ++o6) {
                serializeJson((*o6), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::ReadFavoriteFeedsResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReadFavoriteFeedsErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::ReadFavoriteFeedsErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::ReadFavoriteFeedsErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReadFavoriteFeedsError"

void serializeJson (const ::tcu_usb_main_fi::ReadFavoriteFeedsError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::ReadFavoriteFeedsError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::ReadFavoriteFeedsError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::ReadFavoriteFeedsError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SelectFavoriteFeedsStart"

void serializeJson (const ::tcu_usb_main_fi::SelectFavoriteFeedsStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU16ChannelID()) {
        yajl_gen_string(g, (const unsigned char*)  "u16ChannelID" , 12);
        yajl_gen_integer(g, (long long)value.getU16ChannelID());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::SelectFavoriteFeedsStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SelectFavoriteFeedsErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::SelectFavoriteFeedsErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::SelectFavoriteFeedsErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SelectFavoriteFeedsError"

void serializeJson (const ::tcu_usb_main_fi::SelectFavoriteFeedsError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::SelectFavoriteFeedsError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::SelectFavoriteFeedsError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::SelectFavoriteFeedsError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeleteInfoHistoryErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::DeleteInfoHistoryErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::DeleteInfoHistoryErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeleteInfoHistoryError"

void serializeJson (const ::tcu_usb_main_fi::DeleteInfoHistoryError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::DeleteInfoHistoryError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::DeleteInfoHistoryError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::DeleteInfoHistoryError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetVICSTrafficDataStart"

void serializeJson (const ::tcu_usb_main_fi::GetVICSTrafficDataStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasVICSRequestData()) {
        yajl_gen_string(g, (const unsigned char*)  "VICSRequestData" , 15);
        serializeJson(value.getVICSRequestData(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::GetVICSTrafficDataStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetVICSTrafficDataErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::GetVICSTrafficDataErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::GetVICSTrafficDataErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetVICSTrafficDataError"

void serializeJson (const ::tcu_usb_main_fi::GetVICSTrafficDataError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::GetVICSTrafficDataError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::GetVICSTrafficDataError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::GetVICSTrafficDataError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetChargingStationsListStart"

void serializeJson (const ::tcu_usb_main_fi::GetChargingStationsListStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasChargingStationsRequestInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "ChargingStationsRequestInfo" , 27);
        serializeJson(value.getChargingStationsRequestInfo(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::GetChargingStationsListStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetChargingStationsListErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::GetChargingStationsListErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::GetChargingStationsListErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetChargingStationsListError"

void serializeJson (const ::tcu_usb_main_fi::GetChargingStationsListError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::GetChargingStationsListError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::GetChargingStationsListError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::GetChargingStationsListError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetChargingSpotDataStart"

void serializeJson (const ::tcu_usb_main_fi::GetChargingSpotDataStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPOIIDList()) {
        yajl_gen_string(g, (const unsigned char*)  "POIIDList" , 9);
        yajl_gen_array_open(g);
        const ::std::vector< uint32 >& o9 = value.getPOIIDList();
        {
            ::std::vector< uint32 >::const_iterator o8;
            for (o8 = o9.begin(); o8 != o9.end(); ++o8) {
                yajl_gen_integer(g, (long long)(*o8));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::GetChargingSpotDataStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetChargingSpotDataErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::GetChargingSpotDataErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::GetChargingSpotDataErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetChargingSpotDataError"

void serializeJson (const ::tcu_usb_main_fi::GetChargingSpotDataError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::GetChargingSpotDataError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::GetChargingSpotDataError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::GetChargingSpotDataError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetVacancySpotDataStart"

void serializeJson (const ::tcu_usb_main_fi::GetVacancySpotDataStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPOIIDList()) {
        yajl_gen_string(g, (const unsigned char*)  "POIIDList" , 9);
        yajl_gen_array_open(g);
        const ::std::vector< uint32 >& o11 = value.getPOIIDList();
        {
            ::std::vector< uint32 >::const_iterator o10;
            for (o10 = o11.begin(); o10 != o11.end(); ++o10) {
                yajl_gen_integer(g, (long long)(*o10));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::GetVacancySpotDataStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetVacancySpotDataErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::GetVacancySpotDataErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::GetVacancySpotDataErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetVacancySpotDataError"

void serializeJson (const ::tcu_usb_main_fi::GetVacancySpotDataError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::GetVacancySpotDataError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::GetVacancySpotDataError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::GetVacancySpotDataError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetVacancyStationsListStart"

void serializeJson (const ::tcu_usb_main_fi::GetVacancyStationsListStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasVacancyStationsRequestInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "VacancyStationsRequestInfo" , 26);
        serializeJson(value.getVacancyStationsRequestInfo(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::GetVacancyStationsListStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetVacancyStationsListErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::GetVacancyStationsListErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::GetVacancyStationsListErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetVacancyStationsListError"

void serializeJson (const ::tcu_usb_main_fi::GetVacancyStationsListError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::GetVacancyStationsListError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::GetVacancyStationsListError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::GetVacancyStationsListError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SendUserCredentialsStart"

void serializeJson (const ::tcu_usb_main_fi::SendUserCredentialsStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSUserId()) {
        yajl_gen_string(g, (const unsigned char*)  "sUserId" , 7);
        const char *s = value.getSUserId().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSPassword()) {
        yajl_gen_string(g, (const unsigned char*)  "sPassword" , 9);
        const char *s = value.getSPassword().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasBClearData()) {
        yajl_gen_string(g, (const unsigned char*)  "bClearData" , 10);
        yajl_gen_bool(g, (bool)value.getBClearData());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::SendUserCredentialsStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SendUserCredentialsErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::SendUserCredentialsErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::SendUserCredentialsErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SendUserCredentialsError"

void serializeJson (const ::tcu_usb_main_fi::SendUserCredentialsError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::SendUserCredentialsError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::SendUserCredentialsError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::SendUserCredentialsError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UserCredentialStatusStatus"

void serializeJson (const ::tcu_usb_main_fi::UserCredentialStatusStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSDisplayMessage()) {
        yajl_gen_string(g, (const unsigned char*)  "sDisplayMessage" , 15);
        const char *s = value.getSDisplayMessage().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSTTSTextMessage()) {
        yajl_gen_string(g, (const unsigned char*)  "sTTSTextMessage" , 15);
        const char *s = value.getSTTSTextMessage().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasE8AuthenticationResult()) {
        yajl_gen_string(g, (const unsigned char*)  "e8AuthenticationResult" , 22);
        const char* s = ::tcu_usb_main_fi_types::T_e8_tcu_Authentication_Result_Name(value.getE8AuthenticationResult());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8AuthenticationResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::UserCredentialStatusStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UserCredentialStatusErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::UserCredentialStatusErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::UserCredentialStatusErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UserCredentialStatusError"

void serializeJson (const ::tcu_usb_main_fi::UserCredentialStatusError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::UserCredentialStatusError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::UserCredentialStatusError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::UserCredentialStatusError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeleteChannelInformationStart"

void serializeJson (const ::tcu_usb_main_fi::DeleteChannelInformationStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU16ChannelID()) {
        yajl_gen_string(g, (const unsigned char*)  "u16ChannelID" , 12);
        yajl_gen_integer(g, (long long)value.getU16ChannelID());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::DeleteChannelInformationStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeleteChannelInformationErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::DeleteChannelInformationErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::DeleteChannelInformationErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeleteChannelInformationError"

void serializeJson (const ::tcu_usb_main_fi::DeleteChannelInformationError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::DeleteChannelInformationError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::DeleteChannelInformationError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::DeleteChannelInformationError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DownloadPartAuthDataErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::DownloadPartAuthDataErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::DownloadPartAuthDataErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DownloadPartAuthDataError"

void serializeJson (const ::tcu_usb_main_fi::DownloadPartAuthDataError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::DownloadPartAuthDataError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::DownloadPartAuthDataError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::DownloadPartAuthDataError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ValidateUserCredentialsStart"

void serializeJson (const ::tcu_usb_main_fi::ValidateUserCredentialsStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSUserId()) {
        yajl_gen_string(g, (const unsigned char*)  "sUserId" , 7);
        const char *s = value.getSUserId().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSPassword()) {
        yajl_gen_string(g, (const unsigned char*)  "sPassword" , 9);
        const char *s = value.getSPassword().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::ValidateUserCredentialsStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ValidateUserCredentialsResult"

void serializeJson (const ::tcu_usb_main_fi::ValidateUserCredentialsResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "Result" , 6);
        const char* s = ::tcu_usb_main_fi_types::T_e8_UserAuthenticationResultType_Name(value.getResult());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResult());
    }
    if (!isSparse || value.hasToken()) {
        yajl_gen_string(g, (const unsigned char*)  "Token" , 5);
        const char *s = value.getToken().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::ValidateUserCredentialsResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RenewAccessTokenResult"

void serializeJson (const ::tcu_usb_main_fi::RenewAccessTokenResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "Result" , 6);
        const char* s = ::tcu_usb_main_fi_types::T_e8_UserAuthenticationResultType_Name(value.getResult());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResult());
    }
    if (!isSparse || value.hasToken()) {
        yajl_gen_string(g, (const unsigned char*)  "Token" , 5);
        const char *s = value.getToken().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::RenewAccessTokenResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetAccessTokenResult"

void serializeJson (const ::tcu_usb_main_fi::GetAccessTokenResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "Result" , 6);
        const char* s = ::tcu_usb_main_fi_types::T_e8_UserAuthenticationResultType_Name(value.getResult());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResult());
    }
    if (!isSparse || value.hasToken()) {
        yajl_gen_string(g, (const unsigned char*)  "Token" , 5);
        const char *s = value.getToken().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::GetAccessTokenResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NotifyTokenRenewalErrorStatus"

void serializeJson (const ::tcu_usb_main_fi::NotifyTokenRenewalErrorStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasShowCredentialsScreen()) {
        yajl_gen_string(g, (const unsigned char*)  "ShowCredentialsScreen" , 21);
        yajl_gen_bool(g, (bool)value.getShowCredentialsScreen());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::NotifyTokenRenewalErrorStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ValidateUserCredentialsOnTokenRenewalErrorStart"

void serializeJson (const ::tcu_usb_main_fi::ValidateUserCredentialsOnTokenRenewalErrorStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSUserId()) {
        yajl_gen_string(g, (const unsigned char*)  "sUserId" , 7);
        const char *s = value.getSUserId().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSPassword()) {
        yajl_gen_string(g, (const unsigned char*)  "sPassword" , 9);
        const char *s = value.getSPassword().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::ValidateUserCredentialsOnTokenRenewalErrorStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ValidateUserCredentialsOnTokenRenewalErrorResult"

void serializeJson (const ::tcu_usb_main_fi::ValidateUserCredentialsOnTokenRenewalErrorResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "Result" , 6);
        const char* s = ::tcu_usb_main_fi_types::T_e8_UserAuthenticationResultType_Name(value.getResult());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::ValidateUserCredentialsOnTokenRenewalErrorResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CancelUserValidationRenewTokenResult"

void serializeJson (const ::tcu_usb_main_fi::CancelUserValidationRenewTokenResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "Result" , 6);
        const char* s = ::tcu_usb_main_fi_types::T_e8_UserAuthenticationResultType_Name(value.getResult());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::CancelUserValidationRenewTokenResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DecodeIdTokenStart"

void serializeJson (const ::tcu_usb_main_fi::DecodeIdTokenStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasToken()) {
        yajl_gen_string(g, (const unsigned char*)  "Token" , 5);
        const char *s = value.getToken().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::DecodeIdTokenStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DecodeIdTokenResult"

void serializeJson (const ::tcu_usb_main_fi::DecodeIdTokenResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "Result" , 6);
        serializeJson(value.getResult(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::DecodeIdTokenResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ConnectedSearchResultStatus"

void serializeJson (const ::tcu_usb_main_fi::ConnectedSearchResultStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasConnectedSearch()) {
        yajl_gen_string(g, (const unsigned char*)  "ConnectedSearch" , 15);
        serializeJson(value.getConnectedSearch(), g, options);
    }
    if (!isSparse || value.hasServiceType()) {
        yajl_gen_string(g, (const unsigned char*)  "ServiceType" , 11);
        const char* s = ::tcu_usb_main_fi_types::T_e8_ConnectedSearchServiceType_Name(value.getServiceType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getServiceType());
    }
    if (!isSparse || value.hasU8ExecType()) {
        yajl_gen_string(g, (const unsigned char*)  "u8ExecType" , 10);
        const char* s = ::tcu_usb_main_fi_types::T_e8_tcu_ExecType_Name(value.getU8ExecType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getU8ExecType());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::ConnectedSearchResultStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ConnectedSearchResultErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::ConnectedSearchResultErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::ConnectedSearchResultErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ConnectedSearchResultError"

void serializeJson (const ::tcu_usb_main_fi::ConnectedSearchResultError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::ConnectedSearchResultError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::ConnectedSearchResultError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::ConnectedSearchResultError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ChannelMasterDataStatus"

void serializeJson (const ::tcu_usb_main_fi::ChannelMasterDataStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasChannelMasterData()) {
        yajl_gen_string(g, (const unsigned char*)  "ChannelMasterData" , 17);
        serializeJson(value.getChannelMasterData(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::ChannelMasterDataStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TtsAudioStateRequestStatus"

void serializeJson (const ::tcu_usb_main_fi::TtsAudioStateRequestStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAudioActivity()) {
        yajl_gen_string(g, (const unsigned char*)  "AudioActivity" , 13);
        const char* s = ::tcu_usb_main_fi_types::T_e8_tcu_AudioActivity_Name(value.getAudioActivity());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getAudioActivity());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::TtsAudioStateRequestStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DatabaseStatusStatus"

void serializeJson (const ::tcu_usb_main_fi::DatabaseStatusStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDatabaseStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "DatabaseStatus" , 14);
        const char* s = ::tcu_usb_main_fi_types::T_e8_DatabaseStatus_Name(value.getDatabaseStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDatabaseStatus());
    }
    if (!isSparse || value.hasDatabasepath()) {
        yajl_gen_string(g, (const unsigned char*)  "Databasepath" , 12);
        const char *s = value.getDatabasepath().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasDatabaseServiceType()) {
        yajl_gen_string(g, (const unsigned char*)  "DatabaseServiceType" , 19);
        const char* s = ::tcu_usb_main_fi_types::T_e8_DatabaseServiceType_Name(value.getDatabaseServiceType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDatabaseServiceType());
    }
    if (!isSparse || value.hasPopupEnabled()) {
        yajl_gen_string(g, (const unsigned char*)  "PopupEnabled" , 12);
        yajl_gen_bool(g, (bool)value.getPopupEnabled());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::DatabaseStatusStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DatabaseStatusErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::DatabaseStatusErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::DatabaseStatusErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DatabaseStatusError"

void serializeJson (const ::tcu_usb_main_fi::DatabaseStatusError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::DatabaseStatusError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::DatabaseStatusError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::DatabaseStatusError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DataConnectionStatusStatus"

void serializeJson (const ::tcu_usb_main_fi::DataConnectionStatusStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDataConnectionStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "DataConnectionStatus" , 20);
        const char* s = ::tcu_usb_main_fi_types::T_e8_DataConnectionStatus_Name(value.getDataConnectionStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDataConnectionStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::DataConnectionStatusStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DataConnectionStatusErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::DataConnectionStatusErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::DataConnectionStatusErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DataConnectionStatusError"

void serializeJson (const ::tcu_usb_main_fi::DataConnectionStatusError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::DataConnectionStatusError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::DataConnectionStatusError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::DataConnectionStatusError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DataConnectionErrorStatus"

void serializeJson (const ::tcu_usb_main_fi::DataConnectionErrorStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDataConnectionError()) {
        yajl_gen_string(g, (const unsigned char*)  "DataConnectionError" , 19);
        const char* s = ::tcu_usb_main_fi_types::T_e16_DataConnectionError_Name(value.getDataConnectionError());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDataConnectionError());
    }
    if (!isSparse || value.hasServiceType()) {
        yajl_gen_string(g, (const unsigned char*)  "ServiceType" , 11);
        const char* s = ::tcu_usb_main_fi_types::T_e8_ServiceType_Name(value.getServiceType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getServiceType());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::DataConnectionErrorStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DataConnectionErrorErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::DataConnectionErrorErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::DataConnectionErrorErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DataConnectionErrorError"

void serializeJson (const ::tcu_usb_main_fi::DataConnectionErrorError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::DataConnectionErrorError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::DataConnectionErrorError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::DataConnectionErrorError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ServerListStatus"

void serializeJson (const ::tcu_usb_main_fi::ServerListStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasServerInfoList()) {
        yajl_gen_string(g, (const unsigned char*)  "ServerInfoList" , 14);
        yajl_gen_array_open(g);
        const ::std::vector< ::tcu_usb_main_fi_types::T_usb_tcu_Server_Info >& o13 = value.getServerInfoList();
        {
            ::std::vector< ::tcu_usb_main_fi_types::T_usb_tcu_Server_Info >::const_iterator o12;
            for (o12 = o13.begin(); o12 != o13.end(); ++o12) {
                serializeJson((*o12), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasU8ActiveServerId()) {
        yajl_gen_string(g, (const unsigned char*)  "u8ActiveServerId" , 16);
        yajl_gen_integer(g, (long long)value.getU8ActiveServerId());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::ServerListStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ServerListErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::ServerListErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::ServerListErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ServerListError"

void serializeJson (const ::tcu_usb_main_fi::ServerListError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::ServerListError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::ServerListError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::ServerListError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TCUDeviceInfoStatus"

void serializeJson (const ::tcu_usb_main_fi::TCUDeviceInfoStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTCUDeviceInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "TCUDeviceInfo" , 13);
        serializeJson(value.getTCUDeviceInfo(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::TCUDeviceInfoStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TCUDeviceInfoErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::TCUDeviceInfoErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::TCUDeviceInfoErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TCUDeviceInfoError"

void serializeJson (const ::tcu_usb_main_fi::TCUDeviceInfoError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::TCUDeviceInfoError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::TCUDeviceInfoError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::TCUDeviceInfoError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NotifyAutoDownloadIntervalStatus"

void serializeJson (const ::tcu_usb_main_fi::NotifyAutoDownloadIntervalStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAutoDownloadInterval()) {
        yajl_gen_string(g, (const unsigned char*)  "AutoDownloadInterval" , 20);
        const char* s = ::tcu_usb_main_fi_types::T_e8_AutoDownloadInterval_Name(value.getAutoDownloadInterval());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getAutoDownloadInterval());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::NotifyAutoDownloadIntervalStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NotifyAutoDownloadIntervalErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::NotifyAutoDownloadIntervalErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::NotifyAutoDownloadIntervalErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NotifyAutoDownloadIntervalError"

void serializeJson (const ::tcu_usb_main_fi::NotifyAutoDownloadIntervalError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::NotifyAutoDownloadIntervalError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::NotifyAutoDownloadIntervalError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::NotifyAutoDownloadIntervalError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GeneralNotificationMessageStatus"

void serializeJson (const ::tcu_usb_main_fi::GeneralNotificationMessageStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasGeneralNotificationResult()) {
        yajl_gen_string(g, (const unsigned char*)  "GeneralNotificationResult" , 25);
        const char* s = ::tcu_usb_main_fi_types::T_e8_tcu_NotiResult_Name(value.getGeneralNotificationResult());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getGeneralNotificationResult());
    }
    if (!isSparse || value.hasDisplayMessage()) {
        yajl_gen_string(g, (const unsigned char*)  "DisplayMessage" , 14);
        const char *s = value.getDisplayMessage().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTTSTextMessage()) {
        yajl_gen_string(g, (const unsigned char*)  "TTSTextMessage" , 14);
        const char *s = value.getTTSTextMessage().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::GeneralNotificationMessageStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GeneralNotificationMessageErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::GeneralNotificationMessageErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::GeneralNotificationMessageErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GeneralNotificationMessageError"

void serializeJson (const ::tcu_usb_main_fi::GeneralNotificationMessageError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::GeneralNotificationMessageError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::GeneralNotificationMessageError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::GeneralNotificationMessageError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AuthenticationResultDataStatus"

void serializeJson (const ::tcu_usb_main_fi::AuthenticationResultDataStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDisplayMessage()) {
        yajl_gen_string(g, (const unsigned char*)  "DisplayMessage" , 14);
        const char *s = value.getDisplayMessage().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTTSTextMessage()) {
        yajl_gen_string(g, (const unsigned char*)  "TTSTextMessage" , 14);
        const char *s = value.getTTSTextMessage().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::AuthenticationResultDataStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AuthenticationResultDataErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::AuthenticationResultDataErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::AuthenticationResultDataErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AuthenticationResultDataError"

void serializeJson (const ::tcu_usb_main_fi::AuthenticationResultDataError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::AuthenticationResultDataError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::AuthenticationResultDataError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::AuthenticationResultDataError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "VICSTrafficDataStatus"

void serializeJson (const ::tcu_usb_main_fi::VICSTrafficDataStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStrFilePathWithFileName()) {
        yajl_gen_string(g, (const unsigned char*)  "strFilePathWithFileName" , 23);
        const char *s = value.getStrFilePathWithFileName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasVICSResponseData()) {
        yajl_gen_string(g, (const unsigned char*)  "VICSResponseData" , 16);
        yajl_gen_array_open(g);
        const ::std::vector< uint8 >& o15 = value.getVICSResponseData();
        {
            ::std::vector< uint8 >::const_iterator o14;
            for (o14 = o15.begin(); o14 != o15.end(); ++o14) {
                yajl_gen_integer(g, (long long)(*o14));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::VICSTrafficDataStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "VICSTrafficDataErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::VICSTrafficDataErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::VICSTrafficDataErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "VICSTrafficDataError"

void serializeJson (const ::tcu_usb_main_fi::VICSTrafficDataError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::VICSTrafficDataError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::VICSTrafficDataError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::VICSTrafficDataError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ChargingStationsListStatus"

void serializeJson (const ::tcu_usb_main_fi::ChargingStationsListStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasChargingStationsList()) {
        yajl_gen_string(g, (const unsigned char*)  "ChargingStationsList" , 20);
        serializeJson(value.getChargingStationsList(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::ChargingStationsListStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ChargingStationsListErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::ChargingStationsListErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::ChargingStationsListErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ChargingStationsListError"

void serializeJson (const ::tcu_usb_main_fi::ChargingStationsListError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::ChargingStationsListError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::ChargingStationsListError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::ChargingStationsListError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ChargingSpotDataStatus"

void serializeJson (const ::tcu_usb_main_fi::ChargingSpotDataStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasChargingSpotData()) {
        yajl_gen_string(g, (const unsigned char*)  "ChargingSpotData" , 16);
        serializeJson(value.getChargingSpotData(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::ChargingSpotDataStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ChargingSpotDataErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::ChargingSpotDataErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::ChargingSpotDataErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ChargingSpotDataError"

void serializeJson (const ::tcu_usb_main_fi::ChargingSpotDataError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::ChargingSpotDataError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::ChargingSpotDataError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::ChargingSpotDataError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "VacancyStationsListStatus"

void serializeJson (const ::tcu_usb_main_fi::VacancyStationsListStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasVacancyStationsList()) {
        yajl_gen_string(g, (const unsigned char*)  "VacancyStationsList" , 19);
        serializeJson(value.getVacancyStationsList(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::VacancyStationsListStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "VacancyStationsListErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::VacancyStationsListErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::VacancyStationsListErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "VacancyStationsListError"

void serializeJson (const ::tcu_usb_main_fi::VacancyStationsListError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::VacancyStationsListError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::VacancyStationsListError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::VacancyStationsListError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "VacancySpotDataStatus"

void serializeJson (const ::tcu_usb_main_fi::VacancySpotDataStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasVacancySpotData()) {
        yajl_gen_string(g, (const unsigned char*)  "VacancySpotData" , 15);
        serializeJson(value.getVacancySpotData(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::VacancySpotDataStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "VacancySpotDataErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::VacancySpotDataErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::VacancySpotDataErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "VacancySpotDataError"

void serializeJson (const ::tcu_usb_main_fi::VacancySpotDataError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::VacancySpotDataError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::VacancySpotDataError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::VacancySpotDataError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GeneralResponseErrorStatus"

void serializeJson (const ::tcu_usb_main_fi::GeneralResponseErrorStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasGeneralResponseDataError()) {
        yajl_gen_string(g, (const unsigned char*)  "GeneralResponseDataError" , 24);
        yajl_gen_bool(g, (bool)value.getGeneralResponseDataError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::GeneralResponseErrorStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GeneralResponseErrorErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::GeneralResponseErrorErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::GeneralResponseErrorErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GeneralResponseErrorError"

void serializeJson (const ::tcu_usb_main_fi::GeneralResponseErrorError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::GeneralResponseErrorError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::GeneralResponseErrorError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::GeneralResponseErrorError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ResetNCSSettingsErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::ResetNCSSettingsErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::ResetNCSSettingsErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ResetNCSSettingsError"

void serializeJson (const ::tcu_usb_main_fi::ResetNCSSettingsError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::ResetNCSSettingsError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::ResetNCSSettingsError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::ResetNCSSettingsError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetProbeUploadPermitResult"

void serializeJson (const ::tcu_usb_main_fi::GetProbeUploadPermitResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ProbePermitSetting()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ProbePermitSetting" , 20);
        const char* s = ::tcu_usb_main_fi_types::T_e8_TCU_ProbePermitSetting_Name(value.getE8ProbePermitSetting());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ProbePermitSetting());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::GetProbeUploadPermitResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetProbeUploadPermitErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::GetProbeUploadPermitErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::GetProbeUploadPermitErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetProbeUploadPermitError"

void serializeJson (const ::tcu_usb_main_fi::GetProbeUploadPermitError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::GetProbeUploadPermitError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::GetProbeUploadPermitError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::GetProbeUploadPermitError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetProbeUploadPermitStart"

void serializeJson (const ::tcu_usb_main_fi::SetProbeUploadPermitStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ProbePermitSetting()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ProbePermitSetting" , 20);
        const char* s = ::tcu_usb_main_fi_types::T_e8_TCU_ProbePermitSetting_Name(value.getE8ProbePermitSetting());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ProbePermitSetting());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::SetProbeUploadPermitStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetProbeUploadPermitResult"

void serializeJson (const ::tcu_usb_main_fi::SetProbeUploadPermitResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ProbePermitSetting()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ProbePermitSetting" , 20);
        const char* s = ::tcu_usb_main_fi_types::T_e8_TCU_ProbePermitSetting_Name(value.getE8ProbePermitSetting());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ProbePermitSetting());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::SetProbeUploadPermitResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetProbeUploadPermitErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::SetProbeUploadPermitErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::SetProbeUploadPermitErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetProbeUploadPermitError"

void serializeJson (const ::tcu_usb_main_fi::SetProbeUploadPermitError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::SetProbeUploadPermitError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::SetProbeUploadPermitError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::SetProbeUploadPermitError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetProbeInfoDeleteResult"

void serializeJson (const ::tcu_usb_main_fi::SetProbeInfoDeleteResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBStatusFromTCU()) {
        yajl_gen_string(g, (const unsigned char*)  "bStatusFromTCU" , 14);
        yajl_gen_bool(g, (bool)value.getBStatusFromTCU());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::SetProbeInfoDeleteResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetProbeInfoDeleteErrorStructure"

void serializeJson (const ::tcu_usb_main_fi::SetProbeInfoDeleteErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_usb_main_fi::SetProbeInfoDeleteErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetProbeInfoDeleteError"

void serializeJson (const ::tcu_usb_main_fi::SetProbeInfoDeleteError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_usb_main_fi::SetProbeInfoDeleteError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_usb_main_fi::SetProbeInfoDeleteError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_usb_main_fi::SetProbeInfoDeleteError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::FolderData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::ChannelData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::ContentData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::ChannelDataIVM& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::ContentDataIVM& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::GetChannelDataStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::GetChannelDataErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::GetChannelDataError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::GetConnectedSearchResultStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::GetConnectedSearchResultErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::GetConnectedSearchResultError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::GetChannelMasterDataStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::GetChannelMasterDataErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::GetChannelMasterDataError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::SynthesizeSpeakStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::AbortPromptStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::CancelRequestStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::CancelRequestErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::CancelRequestError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::SendGroupADataStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::SendGroupADataErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::SendGroupADataError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::DeleteInVehicleMessageStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::DeleteInVehicleMessageErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::DeleteInVehicleMessageError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::ResetDatabaseErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::ResetDatabaseError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::GetServerListErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::GetServerListError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::SelectServerStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::SelectServerErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::SelectServerError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::RetryGetChannelDataStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::RetryGetChannelDataErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::RetryGetChannelDataError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::OverwriteIVMTotalContentsStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::OverwriteIVMTotalContentsErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::OverwriteIVMTotalContentsError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::StoreCSHistoryStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::StoreCSHistoryErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::StoreCSHistoryError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::GetTCUDeviceInfoErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::GetTCUDeviceInfoError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::SetLogLevelStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::SetLogLevelErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::SetLogLevelError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::RestoreFactorySettingsErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::RestoreFactorySettingsError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::DeleteMessageBoxErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::DeleteMessageBoxError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::InitializeFeedListErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::InitializeFeedListError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::SetAutoDownloadIntervalStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::SetAutoDownloadIntervalErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::SetAutoDownloadIntervalError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::GetAutoDownloadIntervalErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::GetAutoDownloadIntervalError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::SetAutoDownloadChannelStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::SetAutoDownloadChannelErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::SetAutoDownloadChannelError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::GetFavoriteChannelListErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::GetFavoriteChannelListError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::SetFavoriteChannelStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::SetFavoriteChannelErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::SetFavoriteChannelError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::ReadFavoriteFeedsResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::ReadFavoriteFeedsErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::ReadFavoriteFeedsError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::SelectFavoriteFeedsStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::SelectFavoriteFeedsErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::SelectFavoriteFeedsError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::DeleteInfoHistoryErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::DeleteInfoHistoryError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::GetVICSTrafficDataStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::GetVICSTrafficDataErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::GetVICSTrafficDataError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::GetChargingStationsListStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::GetChargingStationsListErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::GetChargingStationsListError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::GetChargingSpotDataStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::GetChargingSpotDataErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::GetChargingSpotDataError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::GetVacancySpotDataStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::GetVacancySpotDataErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::GetVacancySpotDataError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::GetVacancyStationsListStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::GetVacancyStationsListErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::GetVacancyStationsListError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::SendUserCredentialsStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::SendUserCredentialsErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::SendUserCredentialsError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::UserCredentialStatusStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::UserCredentialStatusErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::UserCredentialStatusError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::DeleteChannelInformationStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::DeleteChannelInformationErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::DeleteChannelInformationError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::DownloadPartAuthDataErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::DownloadPartAuthDataError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::ValidateUserCredentialsStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::ValidateUserCredentialsResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::RenewAccessTokenResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::GetAccessTokenResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::NotifyTokenRenewalErrorStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::ValidateUserCredentialsOnTokenRenewalErrorStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::ValidateUserCredentialsOnTokenRenewalErrorResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::CancelUserValidationRenewTokenResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::DecodeIdTokenStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::DecodeIdTokenResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::ConnectedSearchResultStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::ConnectedSearchResultErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::ConnectedSearchResultError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::ChannelMasterDataStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::TtsAudioStateRequestStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::DatabaseStatusStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::DatabaseStatusErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::DatabaseStatusError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::DataConnectionStatusStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::DataConnectionStatusErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::DataConnectionStatusError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::DataConnectionErrorStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::DataConnectionErrorErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::DataConnectionErrorError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::ServerListStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::ServerListErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::ServerListError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::TCUDeviceInfoStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::TCUDeviceInfoErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::TCUDeviceInfoError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::NotifyAutoDownloadIntervalStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::NotifyAutoDownloadIntervalErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::NotifyAutoDownloadIntervalError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::GeneralNotificationMessageStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::GeneralNotificationMessageErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::GeneralNotificationMessageError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::AuthenticationResultDataStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::AuthenticationResultDataErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::AuthenticationResultDataError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::VICSTrafficDataStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::VICSTrafficDataErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::VICSTrafficDataError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::ChargingStationsListStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::ChargingStationsListErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::ChargingStationsListError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::ChargingSpotDataStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::ChargingSpotDataErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::ChargingSpotDataError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::VacancyStationsListStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::VacancyStationsListErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::VacancyStationsListError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::VacancySpotDataStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::VacancySpotDataErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::VacancySpotDataError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::GeneralResponseErrorStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::GeneralResponseErrorErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::GeneralResponseErrorError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::ResetNCSSettingsErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::ResetNCSSettingsError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::GetProbeUploadPermitResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::GetProbeUploadPermitErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::GetProbeUploadPermitError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::SetProbeUploadPermitStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::SetProbeUploadPermitResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::SetProbeUploadPermitErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::SetProbeUploadPermitError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::SetProbeInfoDeleteResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::SetProbeInfoDeleteErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi
using namespace ::asf::stream::json;

namespace tcu_usb_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_usb_main_fi::SetProbeInfoDeleteError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_usb_main_fi

