#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef TCU_USB_MAIN_FI_H
#define TCU_USB_MAIN_FI_H

#include "asf/cca/CcaTypes.h"
#include "asf/cca/CcaTypesConst.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "tcu_usb_main_fi_types.h"
#include "tcu_usb_main_fi_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * CCA Functional Interface 'tcu_usb_main_fi'
 *
 * Fullname: Middleware FC USB TCU Server Functional Interface
 *
 * Version: $Revision:0.1	$
 *
 * Author: Praveen Badsheshi
 *
 * Date: $Date:	Oct 24 2013 10:00:00	$
 *
 * Department:
 *
 * Title: tcu_usb_main_fi
 *
 * <b>Description of 'tcu_usb_main_fi':</b>
 *
 * This is the interface document for FC USB TCU service.
 */

namespace tcu_usb_main_fi {

static const int SERVICE_ID = 171;

static const int FID_GetChannelData = 4;

static const int FID_GetConnectedSearchResult = 5;

static const int FID_GetChannelMasterData = 6;

static const int FID_SynthesizeSpeak = 7;

static const int FID_AbortPrompt = 8;

static const int FID_PausePrompt = 9;

static const int FID_ContinuePrompt = 10;

static const int FID_CancelRequest = 11;

static const int FID_SendGroupAData = 12;

static const int FID_DeleteInVehicleMessage = 13;

static const int FID_ResetDatabase = 14;

static const int FID_GetServerList = 15;

static const int FID_SelectServer = 16;

static const int FID_RetryGetChannelData = 17;

static const int FID_OverwriteIVMTotalContents = 18;

static const int FID_StoreCSHistory = 19;

static const int FID_GetTCUDeviceInfo = 20;

static const int FID_SetLogLevel = 21;

static const int FID_RestoreFactorySettings = 22;

static const int FID_DeleteMessageBox = 23;

static const int FID_InitializeFeedList = 24;

static const int FID_SetAutoDownloadInterval = 25;

static const int FID_GetAutoDownloadInterval = 26;

static const int FID_SetAutoDownloadChannel = 27;

static const int FID_GetFavoriteChannelList = 28;

static const int FID_SetFavoriteChannel = 29;

static const int FID_ReadFavoriteFeeds = 48;

static const int FID_SelectFavoriteFeeds = 49;

static const int FID_DeleteInfoHistory = 30;

static const int FID_GetVICSTrafficData = 35;

static const int FID_GetChargingStationsList = 36;

static const int FID_GetChargingSpotData = 37;

static const int FID_GetVacancySpotData = 38;

static const int FID_GetVacancyStationsList = 39;

static const int FID_SendUserCredentials = 40;

static const int FID_UserCredentialStatus = 274;

static const int FID_DeleteChannelInformation = 47;

static const int FID_DownloadPartAuthData = 41;

static const int FID_ValidateUserCredentials = 42;

static const int FID_RenewAccessToken = 43;

static const int FID_GetAccessToken = 44;

static const int FID_NotifyTokenRenewalError = 45;

static const int FID_ValidateUserCredentialsOnTokenRenewalError = 46;

static const int FID_CancelUserValidationRenewToken = 64;

static const int FID_DecodeIdToken = 65;

static const int FID_ConnectedSearchResult = 256;

static const int FID_ChannelMasterData = 257;

static const int FID_TtsAudioStateRequest = 258;

static const int FID_DatabaseStatus = 259;

static const int FID_DataConnectionStatus = 260;

static const int FID_DataConnectionError = 261;

static const int FID_ServerList = 262;

static const int FID_TCUDeviceInfo = 263;

static const int FID_NotifyAutoDownloadInterval = 265;

static const int FID_GeneralNotificationMessage = 266;

static const int FID_AuthenticationResultData = 267;

static const int FID_VICSTrafficData = 268;

static const int FID_ChargingStationsList = 269;

static const int FID_ChargingSpotData = 270;

static const int FID_VacancyStationsList = 271;

static const int FID_VacancySpotData = 272;

static const int FID_GeneralResponseError = 273;

static const int FID_ResetNCSSettings = 31;

static const int FID_GetProbeUploadPermit = 32;

static const int FID_SetProbeUploadPermit = 33;

static const int FID_SetProbeInfoDelete = 34;


ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 0;

static const int VERSION_PATCH = 2;

// forward declarations
class FolderData;

class ChannelData;

class ContentData;

class ChannelDataIVM;

class ContentDataIVM;

class GetChannelDataStart;

class GetChannelDataErrorStructure;

class GetChannelDataError;

class GetConnectedSearchResultStart;

class GetConnectedSearchResultErrorStructure;

class GetConnectedSearchResultError;

class GetChannelMasterDataStart;

class GetChannelMasterDataErrorStructure;

class GetChannelMasterDataError;

class SynthesizeSpeakStart;

class AbortPromptStart;

class CancelRequestStart;

class CancelRequestErrorStructure;

class CancelRequestError;

class SendGroupADataStart;

class SendGroupADataErrorStructure;

class SendGroupADataError;

class DeleteInVehicleMessageStart;

class DeleteInVehicleMessageErrorStructure;

class DeleteInVehicleMessageError;

class ResetDatabaseErrorStructure;

class ResetDatabaseError;

class GetServerListErrorStructure;

class GetServerListError;

class SelectServerStart;

class SelectServerErrorStructure;

class SelectServerError;

class RetryGetChannelDataStart;

class RetryGetChannelDataErrorStructure;

class RetryGetChannelDataError;

class OverwriteIVMTotalContentsStart;

class OverwriteIVMTotalContentsErrorStructure;

class OverwriteIVMTotalContentsError;

class StoreCSHistoryStart;

class StoreCSHistoryErrorStructure;

class StoreCSHistoryError;

class GetTCUDeviceInfoErrorStructure;

class GetTCUDeviceInfoError;

class SetLogLevelStart;

class SetLogLevelErrorStructure;

class SetLogLevelError;

class RestoreFactorySettingsErrorStructure;

class RestoreFactorySettingsError;

class DeleteMessageBoxErrorStructure;

class DeleteMessageBoxError;

class InitializeFeedListErrorStructure;

class InitializeFeedListError;

class SetAutoDownloadIntervalStart;

class SetAutoDownloadIntervalErrorStructure;

class SetAutoDownloadIntervalError;

class GetAutoDownloadIntervalErrorStructure;

class GetAutoDownloadIntervalError;

class SetAutoDownloadChannelStart;

class SetAutoDownloadChannelErrorStructure;

class SetAutoDownloadChannelError;

class GetFavoriteChannelListErrorStructure;

class GetFavoriteChannelListError;

class SetFavoriteChannelStart;

class SetFavoriteChannelErrorStructure;

class SetFavoriteChannelError;

class ReadFavoriteFeedsResult;

class ReadFavoriteFeedsErrorStructure;

class ReadFavoriteFeedsError;

class SelectFavoriteFeedsStart;

class SelectFavoriteFeedsErrorStructure;

class SelectFavoriteFeedsError;

class DeleteInfoHistoryErrorStructure;

class DeleteInfoHistoryError;

class GetVICSTrafficDataStart;

class GetVICSTrafficDataErrorStructure;

class GetVICSTrafficDataError;

class GetChargingStationsListStart;

class GetChargingStationsListErrorStructure;

class GetChargingStationsListError;

class GetChargingSpotDataStart;

class GetChargingSpotDataErrorStructure;

class GetChargingSpotDataError;

class GetVacancySpotDataStart;

class GetVacancySpotDataErrorStructure;

class GetVacancySpotDataError;

class GetVacancyStationsListStart;

class GetVacancyStationsListErrorStructure;

class GetVacancyStationsListError;

class SendUserCredentialsStart;

class SendUserCredentialsErrorStructure;

class SendUserCredentialsError;

class UserCredentialStatusStatus;

class UserCredentialStatusErrorStructure;

class UserCredentialStatusError;

class DeleteChannelInformationStart;

class DeleteChannelInformationErrorStructure;

class DeleteChannelInformationError;

class DownloadPartAuthDataErrorStructure;

class DownloadPartAuthDataError;

class ValidateUserCredentialsStart;

class ValidateUserCredentialsResult;

class RenewAccessTokenResult;

class GetAccessTokenResult;

class NotifyTokenRenewalErrorStatus;

class ValidateUserCredentialsOnTokenRenewalErrorStart;

class ValidateUserCredentialsOnTokenRenewalErrorResult;

class CancelUserValidationRenewTokenResult;

class DecodeIdTokenStart;

class DecodeIdTokenResult;

class ConnectedSearchResultStatus;

class ConnectedSearchResultErrorStructure;

class ConnectedSearchResultError;

class ChannelMasterDataStatus;

class TtsAudioStateRequestStatus;

class DatabaseStatusStatus;

class DatabaseStatusErrorStructure;

class DatabaseStatusError;

class DataConnectionStatusStatus;

class DataConnectionStatusErrorStructure;

class DataConnectionStatusError;

class DataConnectionErrorStatus;

class DataConnectionErrorErrorStructure;

class DataConnectionErrorError;

class ServerListStatus;

class ServerListErrorStructure;

class ServerListError;

class TCUDeviceInfoStatus;

class TCUDeviceInfoErrorStructure;

class TCUDeviceInfoError;

class NotifyAutoDownloadIntervalStatus;

class NotifyAutoDownloadIntervalErrorStructure;

class NotifyAutoDownloadIntervalError;

class GeneralNotificationMessageStatus;

class GeneralNotificationMessageErrorStructure;

class GeneralNotificationMessageError;

class AuthenticationResultDataStatus;

class AuthenticationResultDataErrorStructure;

class AuthenticationResultDataError;

class VICSTrafficDataStatus;

class VICSTrafficDataErrorStructure;

class VICSTrafficDataError;

class ChargingStationsListStatus;

class ChargingStationsListErrorStructure;

class ChargingStationsListError;

class ChargingSpotDataStatus;

class ChargingSpotDataErrorStructure;

class ChargingSpotDataError;

class VacancyStationsListStatus;

class VacancyStationsListErrorStructure;

class VacancyStationsListError;

class VacancySpotDataStatus;

class VacancySpotDataErrorStructure;

class VacancySpotDataError;

class GeneralResponseErrorStatus;

class GeneralResponseErrorErrorStructure;

class GeneralResponseErrorError;

class ResetNCSSettingsErrorStructure;

class ResetNCSSettingsError;

class GetProbeUploadPermitResult;

class GetProbeUploadPermitErrorStructure;

class GetProbeUploadPermitError;

class SetProbeUploadPermitStart;

class SetProbeUploadPermitResult;

class SetProbeUploadPermitErrorStructure;

class SetProbeUploadPermitError;

class SetProbeInfoDeleteResult;

class SetProbeInfoDeleteErrorStructure;

class SetProbeInfoDeleteError;

// type definitions
/**
 * The result message of the method "GetChannelData"
 * This method is called whenever HMI sends any request to the TCU.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetChannelDataResult;

/**
 * The abort error message of the method "GetChannelData"
 * This method is called whenever HMI sends any request to the TCU.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetChannelDataAbortError;

/**
 * The result message of the method "GetConnectedSearchResult"
 * This method is called whenever any Connected Search is requested from HMI.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetConnectedSearchResultResult;

/**
 * The abort error message of the method "GetConnectedSearchResult"
 * This method is called whenever any Connected Search is requested from HMI.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetConnectedSearchResultAbortError;

/**
 * The result message of the method "GetChannelMasterData"
 * This method is called whenever channel master data is requested by HMI.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetChannelMasterDataResult;

/**
 * The abort error message of the method "GetChannelMasterData"
 * This method is called whenever channel master data is requested by HMI.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetChannelMasterDataAbortError;

/**
 * The abort error message of the method "SynthesizeSpeak"
 * <p>This method will synthesize the text. The data is synthesised via TCU_TTS source.
 * If there is a on going synthesize then the current synthesize will be aborted and then new text will be synthesized.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError SynthesizeSpeakAbortError;

/**
 * The result first message of the method "SynthesizeSpeak"
 * <p>This method will synthesize the text. The data is synthesised via TCU_TTS source.
 * If there is a on going synthesize then the current synthesize will be aborted and then new text will be synthesized.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SynthesizeSpeakResultFirst;

/**
 * The result middle message of the method "SynthesizeSpeak"
 * <p>This method will synthesize the text. The data is synthesised via TCU_TTS source.
 * If there is a on going synthesize then the current synthesize will be aborted and then new text will be synthesized.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SynthesizeSpeakResultMiddle;

/**
 * The result last message of the method "SynthesizeSpeak"
 * <p>This method will synthesize the text. The data is synthesised via TCU_TTS source.
 * If there is a on going synthesize then the current synthesize will be aborted and then new text will be synthesized.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SynthesizeSpeakResultLast;

/**
 * The error message of 'SynthesizeSpeak'
 */
typedef ::asf::cca::CcaTypes::DefaultError SynthesizeSpeakError;

/**
 * The result message of the method "AbortPrompt"
 * <p>This method will abort the synthesize. The job will be aborted and not continued at any time.
 * If Client want the synthesis to be done again, Client has to send SynthesizeSpeak() once again.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AbortPromptResult;

/**
 * The abort error message of the method "AbortPrompt"
 * <p>This method will abort the synthesize. The job will be aborted and not continued at any time.
 * If Client want the synthesis to be done again, Client has to send SynthesizeSpeak() once again.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError AbortPromptAbortError;

/**
 * The error message of 'AbortPrompt'
 */
typedef ::asf::cca::CcaTypes::DefaultError AbortPromptError;

/**
 * The start message of the method "PausePrompt"
 * <p>This Method provides an opportunity for the client to pause the synthesis at a given point.
 * The job will be continued from the same point it has stopped, when the Method "ContinuePrompt" is send by Client.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PausePromptStart;

/**
 * The result message of the method "PausePrompt"
 * <p>This Method provides an opportunity for the client to pause the synthesis at a given point.
 * The job will be continued from the same point it has stopped, when the Method "ContinuePrompt" is send by Client.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PausePromptResult;

/**
 * The abort error message of the method "PausePrompt"
 * <p>This Method provides an opportunity for the client to pause the synthesis at a given point.
 * The job will be continued from the same point it has stopped, when the Method "ContinuePrompt" is send by Client.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError PausePromptAbortError;

/**
 * The error message of 'PausePrompt'
 */
typedef ::asf::cca::CcaTypes::DefaultError PausePromptError;

/**
 * The start message of the method "ContinuePrompt"
 * <p>This Method is used to continue synthesize.
 * "ContinuePrompt" has to be send only after "PausePrompt".</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ContinuePromptStart;

/**
 * The result message of the method "ContinuePrompt"
 * <p>This Method is used to continue synthesize.
 * "ContinuePrompt" has to be send only after "PausePrompt".</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ContinuePromptResult;

/**
 * The abort error message of the method "ContinuePrompt"
 * <p>This Method is used to continue synthesize.
 * "ContinuePrompt" has to be send only after "PausePrompt".</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError ContinuePromptAbortError;

/**
 * The error message of 'ContinuePrompt'
 */
typedef ::asf::cca::CcaTypes::DefaultError ContinuePromptError;

/**
 * The result message of the method "CancelRequest"
 * <p>This Method is called when a user cancels an already placed request.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CancelRequestResult;

/**
 * The abort error message of the method "CancelRequest"
 * <p>This Method is called when a user cancels an already placed request.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError CancelRequestAbortError;

/**
 * The result message of the method "SendGroupAData"
 * <p>This Method is called when GroupA to be sent to the backend.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SendGroupADataResult;

/**
 * The abort error message of the method "SendGroupAData"
 * <p>This Method is called when GroupA to be sent to the backend.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError SendGroupADataAbortError;

/**
 * The result message of the method "DeleteInVehicleMessage"
 * This Method is called by HMI to delete a particular IVM.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DeleteInVehicleMessageResult;

/**
 * The abort error message of the method "DeleteInVehicleMessage"
 * This Method is called by HMI to delete a particular IVM.
 */
typedef ::asf::cca::CcaTypes::DefaultError DeleteInVehicleMessageAbortError;

/**
 * The start message of the method "ResetDatabase"
 * This Method is called by HMI to reset database.
 * Method start to send reset database request to the fc_usb_tcu.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ResetDatabaseStart;

/**
 * The result message of the method "ResetDatabase"
 * This Method is called by HMI to reset database.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ResetDatabaseResult;

/**
 * The abort error message of the method "ResetDatabase"
 * This Method is called by HMI to reset database.
 */
typedef ::asf::cca::CcaTypes::DefaultError ResetDatabaseAbortError;

/**
 * The start message of the method "GetServerList"
 * This Method is called by HMI to get list of Servers supported.
 * Method start to send server list request to the fc_usb_tcu.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetServerListStart;

/**
 * The result message of the method "GetServerList"
 * This Method is called by HMI to get list of Servers supported.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetServerListResult;

/**
 * The abort error message of the method "GetServerList"
 * This Method is called by HMI to get list of Servers supported.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetServerListAbortError;

/**
 * The result message of the method "SelectServer"
 * This Method is called by HMI to select server for use.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SelectServerResult;

/**
 * The abort error message of the method "SelectServer"
 * This Method is called by HMI to select server for use.
 */
typedef ::asf::cca::CcaTypes::DefaultError SelectServerAbortError;

/**
 * The result message of the method "RetryGetChannelData"
 * This Method is called by HMI to retry channel data download for IVM/MIS/MS.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RetryGetChannelDataResult;

/**
 * The abort error message of the method "RetryGetChannelData"
 * This Method is called by HMI to retry channel data download for IVM/MIS/MS.
 */
typedef ::asf::cca::CcaTypes::DefaultError RetryGetChannelDataAbortError;

/**
 * The result message of the method "OverwriteIVMTotalContents"
 * This Method is called by HMI to overwrite the TotalNumOfContents value of a IVM channel with StoredNumOfContents. This method is called when the user doesn't want to download pending contents.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage OverwriteIVMTotalContentsResult;

/**
 * The abort error message of the method "OverwriteIVMTotalContents"
 * This Method is called by HMI to overwrite the TotalNumOfContents value of a IVM channel with StoredNumOfContents. This method is called when the user doesn't want to download pending contents.
 */
typedef ::asf::cca::CcaTypes::DefaultError OverwriteIVMTotalContentsAbortError;

/**
 * The result message of the method "StoreCSHistory"
 * This Method is called by HMI to write CS keyword to DB.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StoreCSHistoryResult;

/**
 * The abort error message of the method "StoreCSHistory"
 * This Method is called by HMI to write CS keyword to DB.
 */
typedef ::asf::cca::CcaTypes::DefaultError StoreCSHistoryAbortError;

/**
 * The start message of the method "GetTCUDeviceInfo"
 * This Method is called by HMI to get info of TCU device.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetTCUDeviceInfoStart;

/**
 * The result message of the method "GetTCUDeviceInfo"
 * This Method is called by HMI to get info of TCU device.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetTCUDeviceInfoResult;

/**
 * The abort error message of the method "GetTCUDeviceInfo"
 * This Method is called by HMI to get info of TCU device.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetTCUDeviceInfoAbortError;

/**
 * The result message of the method "SetLogLevel"
 * This Method is called by HMI to set Log level.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetLogLevelResult;

/**
 * The abort error message of the method "SetLogLevel"
 * This Method is called by HMI to set Log level.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetLogLevelAbortError;

/**
 * The start message of the method "RestoreFactorySettings"
 * This Method is called by HMI to restore factory settings.
 * Method start to send restore factory settings request to the fc_usb_tcu.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RestoreFactorySettingsStart;

/**
 * The result message of the method "RestoreFactorySettings"
 * This Method is called by HMI to restore factory settings.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RestoreFactorySettingsResult;

/**
 * The abort error message of the method "RestoreFactorySettings"
 * This Method is called by HMI to restore factory settings.
 */
typedef ::asf::cca::CcaTypes::DefaultError RestoreFactorySettingsAbortError;

/**
 * The start message of the method "DeleteMessageBox"
 * This Method is called by HMI to delete Message Box table in database.
 * Method start to send Delete Message Box request to the fc_usb_tcu.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DeleteMessageBoxStart;

/**
 * The result message of the method "DeleteMessageBox"
 * This Method is called by HMI to delete Message Box table in database.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DeleteMessageBoxResult;

/**
 * The abort error message of the method "DeleteMessageBox"
 * This Method is called by HMI to delete Message Box table in database.
 */
typedef ::asf::cca::CcaTypes::DefaultError DeleteMessageBoxAbortError;

/**
 * The start message of the method "InitializeFeedList"
 * This Method is called by HMI to Initialize Feed List in database.
 * Method start to send Initialize Feed List request to the fc_usb_tcu.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage InitializeFeedListStart;

/**
 * The result message of the method "InitializeFeedList"
 * This Method is called by HMI to Initialize Feed List in database.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage InitializeFeedListResult;

/**
 * The abort error message of the method "InitializeFeedList"
 * This Method is called by HMI to Initialize Feed List in database.
 */
typedef ::asf::cca::CcaTypes::DefaultError InitializeFeedListAbortError;

/**
 * The result message of the method "SetAutoDownloadInterval"
 * This Method is called by HMI to Set AutoDownload Interval.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetAutoDownloadIntervalResult;

/**
 * The abort error message of the method "SetAutoDownloadInterval"
 * This Method is called by HMI to Set AutoDownload Interval.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetAutoDownloadIntervalAbortError;

/**
 * The start message of the method "GetAutoDownloadInterval"
 * This Method is called by HMI to get AutoDownload Interval.
 * Method start to send AutoDownload Interval request to the fc_usb_tcu.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetAutoDownloadIntervalStart;

/**
 * The result message of the method "GetAutoDownloadInterval"
 * This Method is called by HMI to get AutoDownload Interval.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetAutoDownloadIntervalResult;

/**
 * The abort error message of the method "GetAutoDownloadInterval"
 * This Method is called by HMI to get AutoDownload Interval.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetAutoDownloadIntervalAbortError;

/**
 * The result message of the method "SetAutoDownloadChannel"
 * This Method is called by HMI to Set AutoDownload Channel.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetAutoDownloadChannelResult;

/**
 * The abort error message of the method "SetAutoDownloadChannel"
 * This Method is called by HMI to Set AutoDownload Channel.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetAutoDownloadChannelAbortError;

/**
 * The start message of the method "GetFavoriteChannelList"
 * This Method is called by HMI to download favorite channel list.
 * Method start to send GetFavoriteChannelList request to fc_usb_tcu.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetFavoriteChannelListStart;

/**
 * The result message of the method "GetFavoriteChannelList"
 * This Method is called by HMI to download favorite channel list.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetFavoriteChannelListResult;

/**
 * The abort error message of the method "GetFavoriteChannelList"
 * This Method is called by HMI to download favorite channel list.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetFavoriteChannelListAbortError;

/**
 * The result message of the method "SetFavoriteChannel"
 * This Method is called by HMI to Set favorite Channel.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetFavoriteChannelResult;

/**
 * The abort error message of the method "SetFavoriteChannel"
 * This Method is called by HMI to Set favorite Channel.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetFavoriteChannelAbortError;

/**
 * The start message of the method "ReadFavoriteFeeds"
 * This Method is called by SDS (or any other module) to read favorite feeds that are stored in database.
 * Method start to read favorite feeds in the fc_usb_tcu.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ReadFavoriteFeedsStart;

/**
 * The abort error message of the method "ReadFavoriteFeeds"
 * This Method is called by SDS (or any other module) to read favorite feeds that are stored in database.
 */
typedef ::asf::cca::CcaTypes::DefaultError ReadFavoriteFeedsAbortError;

/**
 * The result message of the method "SelectFavoriteFeeds"
 * This Method is called by SDS (or any other module) to inform the favorite feed selected by user for download.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SelectFavoriteFeedsResult;

/**
 * The abort error message of the method "SelectFavoriteFeeds"
 * This Method is called by SDS (or any other module) to inform the favorite feed selected by user for download.
 */
typedef ::asf::cca::CcaTypes::DefaultError SelectFavoriteFeedsAbortError;

/**
 * The start message of the method "DeleteInfoHistory"
 * This Method is called by HMI to delete Info History table in database.
 * Method start to send Delete Info History request to the fc_usb_tcu.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DeleteInfoHistoryStart;

/**
 * The result message of the method "DeleteInfoHistory"
 * This Method is called by HMI to delete Info History table in database.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DeleteInfoHistoryResult;

/**
 * The abort error message of the method "DeleteInfoHistory"
 * This Method is called by HMI to delete Info History table in database.
 */
typedef ::asf::cca::CcaTypes::DefaultError DeleteInfoHistoryAbortError;

/**
 * The result message of the method "GetVICSTrafficData"
 * This Method is called by HMI to Get the VICS Traffic data.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetVICSTrafficDataResult;

/**
 * The abort error message of the method "GetVICSTrafficData"
 * This Method is called by HMI to Get the VICS Traffic data.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetVICSTrafficDataAbortError;

/**
 * The result message of the method "GetChargingStationsList"
 * This Method is called by HMI to Get Charging Stations List.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetChargingStationsListResult;

/**
 * The abort error message of the method "GetChargingStationsList"
 * This Method is called by HMI to Get Charging Stations List.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetChargingStationsListAbortError;

/**
 * The result message of the method "GetChargingSpotData"
 * This Method is called by HMI to Get Charging Spot Data.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetChargingSpotDataResult;

/**
 * The abort error message of the method "GetChargingSpotData"
 * This Method is called by HMI to Get Charging Spot Data.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetChargingSpotDataAbortError;

/**
 * The result message of the method "GetVacancySpotData"
 * This Method is called by HMI to Get Vacancy Spot Data.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetVacancySpotDataResult;

/**
 * The abort error message of the method "GetVacancySpotData"
 * This Method is called by HMI to Get Vacancy Spot Data.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetVacancySpotDataAbortError;

/**
 * The result message of the method "GetVacancyStationsList"
 * This Method is called by HMI to Get Vacancy Stations List.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetVacancyStationsListResult;

/**
 * The abort error message of the method "GetVacancyStationsList"
 * This Method is called by HMI to Get Vacancy Stations List.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetVacancyStationsListAbortError;

/**
 * The result message of the method "SendUserCredentials"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SendUserCredentialsResult;

/**
 * The abort error message of the method "SendUserCredentials"
 */
typedef ::asf::cca::CcaTypes::DefaultError SendUserCredentialsAbortError;

/**
 * The upreg message of the property "UserCredentialStatus"
 * Property update status of user credentials updated
 */
typedef ::asf::cca::CcaTypes::DefaultMessage UserCredentialStatusUpReg;

/**
 * The relUpReg message of the property "UserCredentialStatus"
 * Property update status of user credentials updated
 */
typedef ::asf::cca::CcaTypes::DefaultMessage UserCredentialStatusRelUpReg;

/**
 * The result message of the method "DeleteChannelInformation"
 * This Method is called by HMI to delete a particular Channel from database completely, everything.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DeleteChannelInformationResult;

/**
 * The abort error message of the method "DeleteChannelInformation"
 * This Method is called by HMI to delete a particular Channel from database completely, everything.
 */
typedef ::asf::cca::CcaTypes::DefaultError DeleteChannelInformationAbortError;

/**
 * The start message of the method "DownloadPartAuthData"
 * This Method is called by some other component to download the Part Authentication Data.
 * Method start to send download part auth data request to the fc_usb_tcu.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DownloadPartAuthDataStart;

/**
 * The result message of the method "DownloadPartAuthData"
 * This Method is called by some other component to download the Part Authentication Data.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DownloadPartAuthDataResult;

/**
 * The abort error message of the method "DownloadPartAuthData"
 * This Method is called by some other component to download the Part Authentication Data.
 */
typedef ::asf::cca::CcaTypes::DefaultError DownloadPartAuthDataAbortError;

/**
 * The abort error message of the method "ValidateUserCredentials"
 * This Method is called by some other component to ValidateUserCredentials
 */
typedef ::asf::cca::CcaTypes::DefaultError ValidateUserCredentialsAbortError;

/**
 * The error message of 'ValidateUserCredentials'
 */
typedef ::asf::cca::CcaTypes::DefaultError ValidateUserCredentialsError;

/**
 * The start message of the method "RenewAccessToken"
 * This Method is called by some other component for renewing token
 * Method start for renewing token
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RenewAccessTokenStart;

/**
 * The abort error message of the method "RenewAccessToken"
 * This Method is called by some other component for renewing token
 */
typedef ::asf::cca::CcaTypes::DefaultError RenewAccessTokenAbortError;

/**
 * The error message of 'RenewAccessToken'
 */
typedef ::asf::cca::CcaTypes::DefaultError RenewAccessTokenError;

/**
 * The start message of the method "GetAccessToken"
 * This Method is called by some other component to GetAccessToken
 * Method start to GetAccessToken
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetAccessTokenStart;

/**
 * The abort error message of the method "GetAccessToken"
 * This Method is called by some other component to GetAccessToken
 */
typedef ::asf::cca::CcaTypes::DefaultError GetAccessTokenAbortError;

/**
 * The error message of 'GetAccessToken'
 */
typedef ::asf::cca::CcaTypes::DefaultError GetAccessTokenError;

/**
 * The upreg message of the property "NotifyTokenRenewalError"
 * This property is sent to HMI to Display User Credentials screen to get the credentials from user and call validation by credentials method.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage NotifyTokenRenewalErrorUpReg;

/**
 * The relUpReg message of the property "NotifyTokenRenewalError"
 * This property is sent to HMI to Display User Credentials screen to get the credentials from user and call validation by credentials method.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage NotifyTokenRenewalErrorRelUpReg;

/**
 * The error message of 'NotifyTokenRenewalError'
 */
typedef ::asf::cca::CcaTypes::DefaultError NotifyTokenRenewalErrorError;

/**
 * The abort error message of the method "ValidateUserCredentialsOnTokenRenewalError"
 * This Method is called by User Auth HMI to ValidateUserCredentials.
 * In case the user cancels, this method should be called with empty strings in parameter.
 * In case the user does not enter credentials and presses ok, this method should not be called.
 */
typedef ::asf::cca::CcaTypes::DefaultError ValidateUserCredentialsOnTokenRenewalErrorAbortError;

/**
 * The error message of 'ValidateUserCredentialsOnTokenRenewalError'
 */
typedef ::asf::cca::CcaTypes::DefaultError ValidateUserCredentialsOnTokenRenewalErrorError;

/**
 * The start message of the method "CancelUserValidationRenewToken"
 * This Method is called by some other component to Cancel an already placed user authentication request.
 * Method to cancel ValidateUserCredentials and RenewAccessToken
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CancelUserValidationRenewTokenStart;

/**
 * The abort error message of the method "CancelUserValidationRenewToken"
 * This Method is called by some other component to Cancel an already placed user authentication request.
 */
typedef ::asf::cca::CcaTypes::DefaultError CancelUserValidationRenewTokenAbortError;

/**
 * The error message of 'CancelUserValidationRenewToken'
 */
typedef ::asf::cca::CcaTypes::DefaultError CancelUserValidationRenewTokenError;

/**
 * The abort error message of the method "DecodeIdToken"
 * This Method is called by some other component to get the decoded Id_token in json format.
 */
typedef ::asf::cca::CcaTypes::DefaultError DecodeIdTokenAbortError;

/**
 * The error message of 'DecodeIdToken'
 */
typedef ::asf::cca::CcaTypes::DefaultError DecodeIdTokenError;

/**
 * The upreg message of the property "ConnectedSearchResult"
 * Property update for connected search results
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ConnectedSearchResultUpReg;

/**
 * The relUpReg message of the property "ConnectedSearchResult"
 * Property update for connected search results
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ConnectedSearchResultRelUpReg;

/**
 * The upreg message of the property "ChannelMasterData"
 * Set Channel Master Data
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ChannelMasterDataUpReg;

/**
 * The relUpReg message of the property "ChannelMasterData"
 * Set Channel Master Data
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ChannelMasterDataRelUpReg;

/**
 * The error message of 'ChannelMasterData'
 */
typedef ::asf::cca::CcaTypes::DefaultError ChannelMasterDataError;

/**
 * The upreg message of the property "TtsAudioStateRequest"
 * Request TtsAudio channel state
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TtsAudioStateRequestUpReg;

/**
 * The relUpReg message of the property "TtsAudioStateRequest"
 * Request TtsAudio channel state
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TtsAudioStateRequestRelUpReg;

/**
 * The error message of 'TtsAudioStateRequest'
 */
typedef ::asf::cca::CcaTypes::DefaultError TtsAudioStateRequestError;

/**
 * The set message of the property "DatabaseStatus"
 * This property gives the information about the availability of USB TCU database.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DatabaseStatusSet;

/**
 * The upreg message of the property "DatabaseStatus"
 * This property gives the information about the availability of USB TCU database.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DatabaseStatusUpReg;

/**
 * The relUpReg message of the property "DatabaseStatus"
 * This property gives the information about the availability of USB TCU database.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DatabaseStatusRelUpReg;

/**
 * The upreg message of the property "DataConnectionStatus"
 * This property gives the information about the data connection to backend status (active or inactive).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DataConnectionStatusUpReg;

/**
 * The relUpReg message of the property "DataConnectionStatus"
 * This property gives the information about the data connection to backend status (active or inactive).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DataConnectionStatusRelUpReg;

/**
 * The upreg message of the property "DataConnectionError"
 * This property gives the information about the data connection error type.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DataConnectionErrorUpReg;

/**
 * The relUpReg message of the property "DataConnectionError"
 * This property gives the information about the data connection error type.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DataConnectionErrorRelUpReg;

/**
 * The upreg message of the property "ServerList"
 * This property gives the information about the server list.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ServerListUpReg;

/**
 * The relUpReg message of the property "ServerList"
 * This property gives the information about the server list.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ServerListRelUpReg;

/**
 * The upreg message of the property "TCUDeviceInfo"
 * This property gives the information about TCU Device.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TCUDeviceInfoUpReg;

/**
 * The relUpReg message of the property "TCUDeviceInfo"
 * This property gives the information about TCU Device.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TCUDeviceInfoRelUpReg;

/**
 * The upreg message of the property "NotifyAutoDownloadInterval"
 * This property gives the information about AutoDownload Interval.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage NotifyAutoDownloadIntervalUpReg;

/**
 * The relUpReg message of the property "NotifyAutoDownloadInterval"
 * This property gives the information about AutoDownload Interval.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage NotifyAutoDownloadIntervalRelUpReg;

/**
 * The upreg message of the property "GeneralNotificationMessage"
 * This property gives the information about the General Notification Message.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GeneralNotificationMessageUpReg;

/**
 * The relUpReg message of the property "GeneralNotificationMessage"
 * This property gives the information about the General Notification Message.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GeneralNotificationMessageRelUpReg;

/**
 * The upreg message of the property "AuthenticationResultData"
 * This property gives the information about the Authentication Result Data.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AuthenticationResultDataUpReg;

/**
 * The relUpReg message of the property "AuthenticationResultData"
 * This property gives the information about the Authentication Result Data.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AuthenticationResultDataRelUpReg;

/**
 * The upreg message of the property "VICSTrafficData"
 * This property gives the information about the VICS Traffic Data.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VICSTrafficDataUpReg;

/**
 * The relUpReg message of the property "VICSTrafficData"
 * This property gives the information about the VICS Traffic Data.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VICSTrafficDataRelUpReg;

/**
 * The upreg message of the property "ChargingStationsList"
 * This property gives information about the charging stations list.
 * This is the response for the methodstart getChargingStationsList
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ChargingStationsListUpReg;

/**
 * The relUpReg message of the property "ChargingStationsList"
 * This property gives information about the charging stations list.
 * This is the response for the methodstart getChargingStationsList
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ChargingStationsListRelUpReg;

/**
 * The upreg message of the property "ChargingSpotData"
 * This property gives information about the charging spot data.
 * This is the response for the methodstart getChargingSpotData
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ChargingSpotDataUpReg;

/**
 * The relUpReg message of the property "ChargingSpotData"
 * This property gives information about the charging spot data.
 * This is the response for the methodstart getChargingSpotData
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ChargingSpotDataRelUpReg;

/**
 * The upreg message of the property "VacancyStationsList"
 * This property gives information about the vacancy stations list.
 * This is the response for the methodstart getVacancyStationsList
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VacancyStationsListUpReg;

/**
 * The relUpReg message of the property "VacancyStationsList"
 * This property gives information about the vacancy stations list.
 * This is the response for the methodstart getVacancyStationsList
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VacancyStationsListRelUpReg;

/**
 * The upreg message of the property "VacancySpotData"
 * This property gives information about the vacancy spot data.
 * This is the response for the methodstart getVacancySpotData
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VacancySpotDataUpReg;

/**
 * The relUpReg message of the property "VacancySpotData"
 * This property gives information about the vacancy spot data.
 * This is the response for the methodstart getVacancySpotData
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VacancySpotDataRelUpReg;

/**
 * The upreg message of the property "GeneralResponseError"
 * This property informs the HMI about error occured in GeneralResponse received.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GeneralResponseErrorUpReg;

/**
 * The relUpReg message of the property "GeneralResponseError"
 * This property informs the HMI about error occured in GeneralResponse received.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GeneralResponseErrorRelUpReg;

/**
 * The start message of the method "ResetNCSSettings"
 * This Method is called by HMI to Reset NCS Settings.
 * Method start to send Reset NCS Settings request to the fc_usb_tcu.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ResetNCSSettingsStart;

/**
 * The result message of the method "ResetNCSSettings"
 * This Method is called by HMI to Reset NCS Settings.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ResetNCSSettingsResult;

/**
 * The abort error message of the method "ResetNCSSettings"
 * This Method is called by HMI to Reset NCS Settings.
 */
typedef ::asf::cca::CcaTypes::DefaultError ResetNCSSettingsAbortError;

/**
 * The start message of the method "GetProbeUploadPermit"
 * This method is called by ITM when the probe upload permit is chnaged from ITM side(MCAN Fct Id:244h).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetProbeUploadPermitStart;

/**
 * The abort error message of the method "GetProbeUploadPermit"
 * This method is called by ITM when the probe upload permit is chnaged from ITM side(MCAN Fct Id:244h).
 */
typedef ::asf::cca::CcaTypes::DefaultError GetProbeUploadPermitAbortError;

/**
 * The abort error message of the method "SetProbeUploadPermit"
 * This method is called by ITM when there is change in Probe Upload permit from ITM side(MCAN Fct Id:244h).
 */
typedef ::asf::cca::CcaTypes::DefaultError SetProbeUploadPermitAbortError;

/**
 * The start message of the method "SetProbeInfoDelete"
 * This method is called by ITM to delete the Probe info(MCAN Fct Id:245h).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetProbeInfoDeleteStart;

/**
 * The abort error message of the method "SetProbeInfoDelete"
 * This method is called by ITM to delete the Probe info(MCAN Fct Id:245h).
 */
typedef ::asf::cca::CcaTypes::DefaultError SetProbeInfoDeleteAbortError;


/**
 * If the meaning of "FolderData" isn't clear, then there should be a description here.
 */
class FolderData {
public:

    /**
     * Default constructor
     */
    inline  FolderData ();

    /**
     * Copy constructor
     */
    inline  FolderData (const FolderData &rhs);

    /**
     * All fields constructor
     */
    inline  FolderData (uint16 FolderID_, const ::std::string& FolderName_);

    /**
     * Destructor
     */
    inline  ~FolderData();

    /**
     * Assignment operator
     */
    inline FolderData& operator = (const FolderData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FolderData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FolderData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FolderData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FolderData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "FolderID"

    static const int kFolderID = 0;

    /**
     * Clears the field "FolderID".
     *
     * The field will be set to its default value. The hasFolderID()
     * method will return false.
     */
    inline void clearFolderID();

    /**
     * Checks whether the field "FolderID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFolderID()). Otherwise it will return false.
     */
    inline bool hasFolderID () const;

    /**
     * Returns the value of the member "FolderID".
     *
     * ID of folder. PRIMARY KEY.
     *
     * @return The value of the field "FolderID"
     */
    inline uint16 getFolderID () const;

    /**
     * Sets the value of the member "FolderID".
     *
     * ID of folder. PRIMARY KEY.
     *
     * @param FolderID The value which will be set
     */
    inline void setFolderID (uint16 FolderID_);

    // API of field "FolderName"

    static const int kFolderName = 1;

    /**
     * Clears the field "FolderName".
     *
     * The field will be set to its default value. The hasFolderName()
     * method will return false.
     */
    inline void clearFolderName();

    /**
     * Checks whether the field "FolderName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFolderName()). Otherwise it will return false.
     */
    inline bool hasFolderName () const;

    /**
     * Returns the value of the member "FolderName".
     *
     * Name of Folder for display
     *
     * @return The value of the field "FolderName"
     */
    inline const ::std::string& getFolderName () const;

    /**
     * Retrieves the value of the field "FolderName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FolderName".
     */
    inline ::std::string& getFolderNameMutable ();

    /**
     * Sets the value of the member "FolderName".
     *
     * Name of Folder for display
     *
     * @param FolderName The value which will be set
     */
    inline void setFolderName (const ::std::string& FolderName_);

    /**
     * Sets the value of the member "FolderName".
     *
     * Name of Folder for display
     *
     * @param FolderName The value which will be set
     */
    inline void setFolderName (const char* FolderName_);

    /**
     * Sets the value of the member "FolderName".
     *
     * Name of Folder for display
     *
     * @param FolderName The value which will be set
     */
    inline void setFolderName (const char* value, size_t size);

    static const FolderData &getDefaultInstance();

private:

    inline void set_has_FolderID ();

    inline void clear_has_FolderID ();

    inline void set_has_FolderName ();

    inline void clear_has_FolderName ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _FolderID;

    ::std::string _FolderName;

};

/**
 * If the meaning of "ChannelData" isn't clear, then there should be a description here.
 */
class ChannelData {
public:

    /**
     * Default constructor
     */
    inline  ChannelData ();

    /**
     * Copy constructor
     */
    inline  ChannelData (const ChannelData &rhs);

    /**
     * All fields constructor
     */
    inline  ChannelData (const ::std::string& ChannelID_, const ::std::string& ChannelName_, uint16 ChannelIconID_, uint8 FlagOfChannelInfo_, uint8 StoredNumOfChannelContents_, uint8 TotalNumOfChannelContents_, uint8 ServiceType_, uint16 FolderID_);

    /**
     * Destructor
     */
    inline  ~ChannelData();

    /**
     * Assignment operator
     */
    inline ChannelData& operator = (const ChannelData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChannelData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChannelData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChannelData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChannelData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ChannelID"

    static const int kChannelID = 0;

    /**
     * Clears the field "ChannelID".
     *
     * The field will be set to its default value. The hasChannelID()
     * method will return false.
     */
    inline void clearChannelID();

    /**
     * Checks whether the field "ChannelID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelID()). Otherwise it will return false.
     */
    inline bool hasChannelID () const;

    /**
     * Returns the value of the member "ChannelID".
     *
     * ID of channel. PRIMARY KEY.
     *
     * @return The value of the field "ChannelID"
     */
    inline const ::std::string& getChannelID () const;

    /**
     * Retrieves the value of the field "ChannelID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ChannelID".
     */
    inline ::std::string& getChannelIDMutable ();

    /**
     * Sets the value of the member "ChannelID".
     *
     * ID of channel. PRIMARY KEY.
     *
     * @param ChannelID The value which will be set
     */
    inline void setChannelID (const ::std::string& ChannelID_);

    /**
     * Sets the value of the member "ChannelID".
     *
     * ID of channel. PRIMARY KEY.
     *
     * @param ChannelID The value which will be set
     */
    inline void setChannelID (const char* ChannelID_);

    /**
     * Sets the value of the member "ChannelID".
     *
     * ID of channel. PRIMARY KEY.
     *
     * @param ChannelID The value which will be set
     */
    inline void setChannelID (const char* value, size_t size);

    // API of field "ChannelName"

    static const int kChannelName = 1;

    /**
     * Clears the field "ChannelName".
     *
     * The field will be set to its default value. The hasChannelName()
     * method will return false.
     */
    inline void clearChannelName();

    /**
     * Checks whether the field "ChannelName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelName()). Otherwise it will return false.
     */
    inline bool hasChannelName () const;

    /**
     * Returns the value of the member "ChannelName".
     *
     * Name of channel for display
     *
     * @return The value of the field "ChannelName"
     */
    inline const ::std::string& getChannelName () const;

    /**
     * Retrieves the value of the field "ChannelName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ChannelName".
     */
    inline ::std::string& getChannelNameMutable ();

    /**
     * Sets the value of the member "ChannelName".
     *
     * Name of channel for display
     *
     * @param ChannelName The value which will be set
     */
    inline void setChannelName (const ::std::string& ChannelName_);

    /**
     * Sets the value of the member "ChannelName".
     *
     * Name of channel for display
     *
     * @param ChannelName The value which will be set
     */
    inline void setChannelName (const char* ChannelName_);

    /**
     * Sets the value of the member "ChannelName".
     *
     * Name of channel for display
     *
     * @param ChannelName The value which will be set
     */
    inline void setChannelName (const char* value, size_t size);

    // API of field "ChannelIconID"

    static const int kChannelIconID = 2;

    /**
     * Clears the field "ChannelIconID".
     *
     * The field will be set to its default value. The hasChannelIconID()
     * method will return false.
     */
    inline void clearChannelIconID();

    /**
     * Checks whether the field "ChannelIconID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelIconID()). Otherwise it will return false.
     */
    inline bool hasChannelIconID () const;

    /**
     * Returns the value of the member "ChannelIconID".
     *
     * ID of icon for displaying channel menu
     *
     * @return The value of the field "ChannelIconID"
     */
    inline uint16 getChannelIconID () const;

    /**
     * Sets the value of the member "ChannelIconID".
     *
     * ID of icon for displaying channel menu
     *
     * @param ChannelIconID The value which will be set
     */
    inline void setChannelIconID (uint16 ChannelIconID_);

    // API of field "FlagOfChannelInfo"

    static const int kFlagOfChannelInfo = 3;

    /**
     * Clears the field "FlagOfChannelInfo".
     *
     * The field will be set to its default value. The hasFlagOfChannelInfo()
     * method will return false.
     */
    inline void clearFlagOfChannelInfo();

    /**
     * Checks whether the field "FlagOfChannelInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFlagOfChannelInfo()). Otherwise it will return false.
     */
    inline bool hasFlagOfChannelInfo () const;

    /**
     * Returns the value of the member "FlagOfChannelInfo".
     *
     * Flag about channel information
     *
     * @return The value of the field "FlagOfChannelInfo"
     */
    inline uint8 getFlagOfChannelInfo () const;

    /**
     * Sets the value of the member "FlagOfChannelInfo".
     *
     * Flag about channel information
     *
     * @param FlagOfChannelInfo The value which will be set
     */
    inline void setFlagOfChannelInfo (uint8 FlagOfChannelInfo_);

    // API of field "StoredNumOfChannelContents"

    static const int kStoredNumOfChannelContents = 4;

    /**
     * Clears the field "StoredNumOfChannelContents".
     *
     * The field will be set to its default value. The hasStoredNumOfChannelContents()
     * method will return false.
     */
    inline void clearStoredNumOfChannelContents();

    /**
     * Checks whether the field "StoredNumOfChannelContents" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStoredNumOfChannelContents()). Otherwise it will return false.
     */
    inline bool hasStoredNumOfChannelContents () const;

    /**
     * Returns the value of the member "StoredNumOfChannelContents".
     *
     * Number of Channel contents are stored.
     *
     * @return The value of the field "StoredNumOfChannelContents"
     */
    inline uint8 getStoredNumOfChannelContents () const;

    /**
     * Sets the value of the member "StoredNumOfChannelContents".
     *
     * Number of Channel contents are stored.
     *
     * @param StoredNumOfChannelContents The value which will be set
     */
    inline void setStoredNumOfChannelContents (uint8 StoredNumOfChannelContents_);

    // API of field "TotalNumOfChannelContents"

    static const int kTotalNumOfChannelContents = 5;

    /**
     * Clears the field "TotalNumOfChannelContents".
     *
     * The field will be set to its default value. The hasTotalNumOfChannelContents()
     * method will return false.
     */
    inline void clearTotalNumOfChannelContents();

    /**
     * Checks whether the field "TotalNumOfChannelContents" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTotalNumOfChannelContents()). Otherwise it will return false.
     */
    inline bool hasTotalNumOfChannelContents () const;

    /**
     * Returns the value of the member "TotalNumOfChannelContents".
     *
     * Total number of Channel contents.
     *
     * @return The value of the field "TotalNumOfChannelContents"
     */
    inline uint8 getTotalNumOfChannelContents () const;

    /**
     * Sets the value of the member "TotalNumOfChannelContents".
     *
     * Total number of Channel contents.
     *
     * @param TotalNumOfChannelContents The value which will be set
     */
    inline void setTotalNumOfChannelContents (uint8 TotalNumOfChannelContents_);

    // API of field "ServiceType"

    static const int kServiceType = 6;

    /**
     * Clears the field "ServiceType".
     *
     * The field will be set to its default value. The hasServiceType()
     * method will return false.
     */
    inline void clearServiceType();

    /**
     * Checks whether the field "ServiceType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setServiceType()). Otherwise it will return false.
     */
    inline bool hasServiceType () const;

    /**
     * Returns the value of the member "ServiceType".
     *
     * Service type of channel data.
     *
     * @return The value of the field "ServiceType"
     */
    inline uint8 getServiceType () const;

    /**
     * Sets the value of the member "ServiceType".
     *
     * Service type of channel data.
     *
     * @param ServiceType The value which will be set
     */
    inline void setServiceType (uint8 ServiceType_);

    // API of field "FolderID"

    static const int kFolderID = 7;

    /**
     * Clears the field "FolderID".
     *
     * The field will be set to its default value. The hasFolderID()
     * method will return false.
     */
    inline void clearFolderID();

    /**
     * Checks whether the field "FolderID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFolderID()). Otherwise it will return false.
     */
    inline bool hasFolderID () const;

    /**
     * Returns the value of the member "FolderID".
     *
     * ID of folder. FOREIGN KEY.
     *
     * @return The value of the field "FolderID"
     */
    inline uint16 getFolderID () const;

    /**
     * Sets the value of the member "FolderID".
     *
     * ID of folder. FOREIGN KEY.
     *
     * @param FolderID The value which will be set
     */
    inline void setFolderID (uint16 FolderID_);

    static const ChannelData &getDefaultInstance();

private:

    inline void set_has_ChannelID ();

    inline void clear_has_ChannelID ();

    inline void set_has_ChannelName ();

    inline void clear_has_ChannelName ();

    inline void set_has_ChannelIconID ();

    inline void clear_has_ChannelIconID ();

    inline void set_has_FlagOfChannelInfo ();

    inline void clear_has_FlagOfChannelInfo ();

    inline void set_has_StoredNumOfChannelContents ();

    inline void clear_has_StoredNumOfChannelContents ();

    inline void set_has_TotalNumOfChannelContents ();

    inline void clear_has_TotalNumOfChannelContents ();

    inline void set_has_ServiceType ();

    inline void clear_has_ServiceType ();

    inline void set_has_FolderID ();

    inline void clear_has_FolderID ();

    uint32 _has_bits_[ (8 + 31) / 32];

    ::std::string _ChannelID;

    ::std::string _ChannelName;

    uint16 _ChannelIconID;

    uint8 _FlagOfChannelInfo;

    uint8 _StoredNumOfChannelContents;

    uint8 _TotalNumOfChannelContents;

    uint8 _ServiceType;

    uint16 _FolderID;

};

/**
 * If the meaning of "ContentData" isn't clear, then there should be a description here.
 */
class ContentData {
public:

    /**
     * Default constructor
     */
    inline  ContentData ();

    /**
     * Copy constructor
     */
    inline  ContentData (const ContentData &rhs);

    /**
     * All fields constructor
     */
    inline  ContentData (uint8 ChannelContentsID_, const ::std::string& Title_, const ::std::string& TitleForTTS_, uint8 Direction_, uint32 LAT_, uint32 LON_, uint8 LocationAttribute_, uint8 DestOrWayPointType_, const ::std::string& Address_, const ::std::string& PhoneNumber_, const ::std::string& PhoneNumberForDisp_, const ::std::string& Text_, const ::std::string& TextForTTS_, uint16 IconID_, uint16 SoundIDForBeginningOfPlay_, uint16 SoundIDForBGM_, uint8 ActionSWID_, uint32 ParameterOfActionSW_, uint8 FlagOfDispButtonCtrl_, uint8 FlagOfCtrlDuringRunning_, const ::std::string& NameOfImageButton_, const ::std::string& NameOfActionSW_, uint8 FlagOfExecOfChannelContents_, uint8 FlagOfStoringCtrl_, uint8 ImageAvailability_, const ::std::string& ImagePath_, uint16 ChannelID_);

    /**
     * Destructor
     */
    inline  ~ContentData();

    /**
     * Assignment operator
     */
    inline ContentData& operator = (const ContentData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ContentData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ContentData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ContentData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ContentData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ChannelContentsID"

    static const int kChannelContentsID = 0;

    /**
     * Clears the field "ChannelContentsID".
     *
     * The field will be set to its default value. The hasChannelContentsID()
     * method will return false.
     */
    inline void clearChannelContentsID();

    /**
     * Checks whether the field "ChannelContentsID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelContentsID()). Otherwise it will return false.
     */
    inline bool hasChannelContentsID () const;

    /**
     * Returns the value of the member "ChannelContentsID".
     *
     * ID of channel contents in channel data. PRIMARY KEY.
     *
     * @return The value of the field "ChannelContentsID"
     */
    inline uint8 getChannelContentsID () const;

    /**
     * Sets the value of the member "ChannelContentsID".
     *
     * ID of channel contents in channel data. PRIMARY KEY.
     *
     * @param ChannelContentsID The value which will be set
     */
    inline void setChannelContentsID (uint8 ChannelContentsID_);

    // API of field "Title"

    static const int kTitle = 1;

    /**
     * Clears the field "Title".
     *
     * The field will be set to its default value. The hasTitle()
     * method will return false.
     */
    inline void clearTitle();

    /**
     * Checks whether the field "Title" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTitle()). Otherwise it will return false.
     */
    inline bool hasTitle () const;

    /**
     * Returns the value of the member "Title".
     *
     * Title of channel contents
     *
     * @return The value of the field "Title"
     */
    inline const ::std::string& getTitle () const;

    /**
     * Retrieves the value of the field "Title" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Title".
     */
    inline ::std::string& getTitleMutable ();

    /**
     * Sets the value of the member "Title".
     *
     * Title of channel contents
     *
     * @param Title The value which will be set
     */
    inline void setTitle (const ::std::string& Title_);

    /**
     * Sets the value of the member "Title".
     *
     * Title of channel contents
     *
     * @param Title The value which will be set
     */
    inline void setTitle (const char* Title_);

    /**
     * Sets the value of the member "Title".
     *
     * Title of channel contents
     *
     * @param Title The value which will be set
     */
    inline void setTitle (const char* value, size_t size);

    // API of field "TitleForTTS"

    static const int kTitleForTTS = 2;

    /**
     * Clears the field "TitleForTTS".
     *
     * The field will be set to its default value. The hasTitleForTTS()
     * method will return false.
     */
    inline void clearTitleForTTS();

    /**
     * Checks whether the field "TitleForTTS" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTitleForTTS()). Otherwise it will return false.
     */
    inline bool hasTitleForTTS () const;

    /**
     * Returns the value of the member "TitleForTTS".
     *
     * Title of channel contents for TTS
     *
     * @return The value of the field "TitleForTTS"
     */
    inline const ::std::string& getTitleForTTS () const;

    /**
     * Retrieves the value of the field "TitleForTTS" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TitleForTTS".
     */
    inline ::std::string& getTitleForTTSMutable ();

    /**
     * Sets the value of the member "TitleForTTS".
     *
     * Title of channel contents for TTS
     *
     * @param TitleForTTS The value which will be set
     */
    inline void setTitleForTTS (const ::std::string& TitleForTTS_);

    /**
     * Sets the value of the member "TitleForTTS".
     *
     * Title of channel contents for TTS
     *
     * @param TitleForTTS The value which will be set
     */
    inline void setTitleForTTS (const char* TitleForTTS_);

    /**
     * Sets the value of the member "TitleForTTS".
     *
     * Title of channel contents for TTS
     *
     * @param TitleForTTS The value which will be set
     */
    inline void setTitleForTTS (const char* value, size_t size);

    // API of field "Direction"

    static const int kDirection = 3;

    /**
     * Clears the field "Direction".
     *
     * The field will be set to its default value. The hasDirection()
     * method will return false.
     */
    inline void clearDirection();

    /**
     * Checks whether the field "Direction" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDirection()). Otherwise it will return false.
     */
    inline bool hasDirection () const;

    /**
     * Returns the value of the member "Direction".
     *
     * TBD
     *
     * @return The value of the field "Direction"
     */
    inline uint8 getDirection () const;

    /**
     * Sets the value of the member "Direction".
     *
     * TBD
     *
     * @param Direction The value which will be set
     */
    inline void setDirection (uint8 Direction_);

    // API of field "LAT"

    static const int kLAT = 4;

    /**
     * Clears the field "LAT".
     *
     * The field will be set to its default value. The hasLAT()
     * method will return false.
     */
    inline void clearLAT();

    /**
     * Checks whether the field "LAT" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLAT()). Otherwise it will return false.
     */
    inline bool hasLAT () const;

    /**
     * Returns the value of the member "LAT".
     *
     * TBD
     *
     * @return The value of the field "LAT"
     */
    inline uint32 getLAT () const;

    /**
     * Sets the value of the member "LAT".
     *
     * TBD
     *
     * @param LAT The value which will be set
     */
    inline void setLAT (uint32 LAT_);

    // API of field "LON"

    static const int kLON = 5;

    /**
     * Clears the field "LON".
     *
     * The field will be set to its default value. The hasLON()
     * method will return false.
     */
    inline void clearLON();

    /**
     * Checks whether the field "LON" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLON()). Otherwise it will return false.
     */
    inline bool hasLON () const;

    /**
     * Returns the value of the member "LON".
     *
     * TBD
     *
     * @return The value of the field "LON"
     */
    inline uint32 getLON () const;

    /**
     * Sets the value of the member "LON".
     *
     * TBD
     *
     * @param LON The value which will be set
     */
    inline void setLON (uint32 LON_);

    // API of field "LocationAttribute"

    static const int kLocationAttribute = 6;

    /**
     * Clears the field "LocationAttribute".
     *
     * The field will be set to its default value. The hasLocationAttribute()
     * method will return false.
     */
    inline void clearLocationAttribute();

    /**
     * Checks whether the field "LocationAttribute" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLocationAttribute()). Otherwise it will return false.
     */
    inline bool hasLocationAttribute () const;

    /**
     * Returns the value of the member "LocationAttribute".
     *
     * Location attribute
     *
     * @return The value of the field "LocationAttribute"
     */
    inline uint8 getLocationAttribute () const;

    /**
     * Sets the value of the member "LocationAttribute".
     *
     * Location attribute
     *
     * @param LocationAttribute The value which will be set
     */
    inline void setLocationAttribute (uint8 LocationAttribute_);

    // API of field "DestOrWayPointType"

    static const int kDestOrWayPointType = 7;

    /**
     * Clears the field "DestOrWayPointType".
     *
     * The field will be set to its default value. The hasDestOrWayPointType()
     * method will return false.
     */
    inline void clearDestOrWayPointType();

    /**
     * Checks whether the field "DestOrWayPointType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestOrWayPointType()). Otherwise it will return false.
     */
    inline bool hasDestOrWayPointType () const;

    /**
     * Returns the value of the member "DestOrWayPointType".
     *
     * Defines the location is destination or way point
     *
     * @return The value of the field "DestOrWayPointType"
     */
    inline uint8 getDestOrWayPointType () const;

    /**
     * Sets the value of the member "DestOrWayPointType".
     *
     * Defines the location is destination or way point
     *
     * @param DestOrWayPointType The value which will be set
     */
    inline void setDestOrWayPointType (uint8 DestOrWayPointType_);

    // API of field "Address"

    static const int kAddress = 8;

    /**
     * Clears the field "Address".
     *
     * The field will be set to its default value. The hasAddress()
     * method will return false.
     */
    inline void clearAddress();

    /**
     * Checks whether the field "Address" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAddress()). Otherwise it will return false.
     */
    inline bool hasAddress () const;

    /**
     * Returns the value of the member "Address".
     *
     * Address for display
     *
     * @return The value of the field "Address"
     */
    inline const ::std::string& getAddress () const;

    /**
     * Retrieves the value of the field "Address" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Address".
     */
    inline ::std::string& getAddressMutable ();

    /**
     * Sets the value of the member "Address".
     *
     * Address for display
     *
     * @param Address The value which will be set
     */
    inline void setAddress (const ::std::string& Address_);

    /**
     * Sets the value of the member "Address".
     *
     * Address for display
     *
     * @param Address The value which will be set
     */
    inline void setAddress (const char* Address_);

    /**
     * Sets the value of the member "Address".
     *
     * Address for display
     *
     * @param Address The value which will be set
     */
    inline void setAddress (const char* value, size_t size);

    // API of field "PhoneNumber"

    static const int kPhoneNumber = 9;

    /**
     * Clears the field "PhoneNumber".
     *
     * The field will be set to its default value. The hasPhoneNumber()
     * method will return false.
     */
    inline void clearPhoneNumber();

    /**
     * Checks whether the field "PhoneNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneNumber()). Otherwise it will return false.
     */
    inline bool hasPhoneNumber () const;

    /**
     * Returns the value of the member "PhoneNumber".
     *
     * Phone number
     *
     * @return The value of the field "PhoneNumber"
     */
    inline const ::std::string& getPhoneNumber () const;

    /**
     * Retrieves the value of the field "PhoneNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PhoneNumber".
     */
    inline ::std::string& getPhoneNumberMutable ();

    /**
     * Sets the value of the member "PhoneNumber".
     *
     * Phone number
     *
     * @param PhoneNumber The value which will be set
     */
    inline void setPhoneNumber (const ::std::string& PhoneNumber_);

    /**
     * Sets the value of the member "PhoneNumber".
     *
     * Phone number
     *
     * @param PhoneNumber The value which will be set
     */
    inline void setPhoneNumber (const char* PhoneNumber_);

    /**
     * Sets the value of the member "PhoneNumber".
     *
     * Phone number
     *
     * @param PhoneNumber The value which will be set
     */
    inline void setPhoneNumber (const char* value, size_t size);

    // API of field "PhoneNumberForDisp"

    static const int kPhoneNumberForDisp = 10;

    /**
     * Clears the field "PhoneNumberForDisp".
     *
     * The field will be set to its default value. The hasPhoneNumberForDisp()
     * method will return false.
     */
    inline void clearPhoneNumberForDisp();

    /**
     * Checks whether the field "PhoneNumberForDisp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneNumberForDisp()). Otherwise it will return false.
     */
    inline bool hasPhoneNumberForDisp () const;

    /**
     * Returns the value of the member "PhoneNumberForDisp".
     *
     * Phone number for display
     *
     * @return The value of the field "PhoneNumberForDisp"
     */
    inline const ::std::string& getPhoneNumberForDisp () const;

    /**
     * Retrieves the value of the field "PhoneNumberForDisp" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PhoneNumberForDisp".
     */
    inline ::std::string& getPhoneNumberForDispMutable ();

    /**
     * Sets the value of the member "PhoneNumberForDisp".
     *
     * Phone number for display
     *
     * @param PhoneNumberForDisp The value which will be set
     */
    inline void setPhoneNumberForDisp (const ::std::string& PhoneNumberForDisp_);

    /**
     * Sets the value of the member "PhoneNumberForDisp".
     *
     * Phone number for display
     *
     * @param PhoneNumberForDisp The value which will be set
     */
    inline void setPhoneNumberForDisp (const char* PhoneNumberForDisp_);

    /**
     * Sets the value of the member "PhoneNumberForDisp".
     *
     * Phone number for display
     *
     * @param PhoneNumberForDisp The value which will be set
     */
    inline void setPhoneNumberForDisp (const char* value, size_t size);

    // API of field "Text"

    static const int kText = 11;

    /**
     * Clears the field "Text".
     *
     * The field will be set to its default value. The hasText()
     * method will return false.
     */
    inline void clearText();

    /**
     * Checks whether the field "Text" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setText()). Otherwise it will return false.
     */
    inline bool hasText () const;

    /**
     * Returns the value of the member "Text".
     *
     * Description of channel for display
     *
     * @return The value of the field "Text"
     */
    inline const ::std::string& getText () const;

    /**
     * Retrieves the value of the field "Text" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Text".
     */
    inline ::std::string& getTextMutable ();

    /**
     * Sets the value of the member "Text".
     *
     * Description of channel for display
     *
     * @param Text The value which will be set
     */
    inline void setText (const ::std::string& Text_);

    /**
     * Sets the value of the member "Text".
     *
     * Description of channel for display
     *
     * @param Text The value which will be set
     */
    inline void setText (const char* Text_);

    /**
     * Sets the value of the member "Text".
     *
     * Description of channel for display
     *
     * @param Text The value which will be set
     */
    inline void setText (const char* value, size_t size);

    // API of field "TextForTTS"

    static const int kTextForTTS = 12;

    /**
     * Clears the field "TextForTTS".
     *
     * The field will be set to its default value. The hasTextForTTS()
     * method will return false.
     */
    inline void clearTextForTTS();

    /**
     * Checks whether the field "TextForTTS" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTextForTTS()). Otherwise it will return false.
     */
    inline bool hasTextForTTS () const;

    /**
     * Returns the value of the member "TextForTTS".
     *
     * Description of this channel for TTS
     *
     * @return The value of the field "TextForTTS"
     */
    inline const ::std::string& getTextForTTS () const;

    /**
     * Retrieves the value of the field "TextForTTS" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TextForTTS".
     */
    inline ::std::string& getTextForTTSMutable ();

    /**
     * Sets the value of the member "TextForTTS".
     *
     * Description of this channel for TTS
     *
     * @param TextForTTS The value which will be set
     */
    inline void setTextForTTS (const ::std::string& TextForTTS_);

    /**
     * Sets the value of the member "TextForTTS".
     *
     * Description of this channel for TTS
     *
     * @param TextForTTS The value which will be set
     */
    inline void setTextForTTS (const char* TextForTTS_);

    /**
     * Sets the value of the member "TextForTTS".
     *
     * Description of this channel for TTS
     *
     * @param TextForTTS The value which will be set
     */
    inline void setTextForTTS (const char* value, size_t size);

    // API of field "IconID"

    static const int kIconID = 13;

    /**
     * Clears the field "IconID".
     *
     * The field will be set to its default value. The hasIconID()
     * method will return false.
     */
    inline void clearIconID();

    /**
     * Checks whether the field "IconID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIconID()). Otherwise it will return false.
     */
    inline bool hasIconID () const;

    /**
     * Returns the value of the member "IconID".
     *
     * ID of icon
     *
     * @return The value of the field "IconID"
     */
    inline uint16 getIconID () const;

    /**
     * Sets the value of the member "IconID".
     *
     * ID of icon
     *
     * @param IconID The value which will be set
     */
    inline void setIconID (uint16 IconID_);

    // API of field "SoundIDForBeginningOfPlay"

    static const int kSoundIDForBeginningOfPlay = 14;

    /**
     * Clears the field "SoundIDForBeginningOfPlay".
     *
     * The field will be set to its default value. The hasSoundIDForBeginningOfPlay()
     * method will return false.
     */
    inline void clearSoundIDForBeginningOfPlay();

    /**
     * Checks whether the field "SoundIDForBeginningOfPlay" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSoundIDForBeginningOfPlay()). Otherwise it will return false.
     */
    inline bool hasSoundIDForBeginningOfPlay () const;

    /**
     * Returns the value of the member "SoundIDForBeginningOfPlay".
     *
     * ID of sound played at the beginning of auto play
     *
     * @return The value of the field "SoundIDForBeginningOfPlay"
     */
    inline uint16 getSoundIDForBeginningOfPlay () const;

    /**
     * Sets the value of the member "SoundIDForBeginningOfPlay".
     *
     * ID of sound played at the beginning of auto play
     *
     * @param SoundIDForBeginningOfPlay The value which will be set
     */
    inline void setSoundIDForBeginningOfPlay (uint16 SoundIDForBeginningOfPlay_);

    // API of field "SoundIDForBGM"

    static const int kSoundIDForBGM = 15;

    /**
     * Clears the field "SoundIDForBGM".
     *
     * The field will be set to its default value. The hasSoundIDForBGM()
     * method will return false.
     */
    inline void clearSoundIDForBGM();

    /**
     * Checks whether the field "SoundIDForBGM" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSoundIDForBGM()). Otherwise it will return false.
     */
    inline bool hasSoundIDForBGM () const;

    /**
     * Returns the value of the member "SoundIDForBGM".
     *
     * ID of sound for BGM played during auto play
     *
     * @return The value of the field "SoundIDForBGM"
     */
    inline uint16 getSoundIDForBGM () const;

    /**
     * Sets the value of the member "SoundIDForBGM".
     *
     * ID of sound for BGM played during auto play
     *
     * @param SoundIDForBGM The value which will be set
     */
    inline void setSoundIDForBGM (uint16 SoundIDForBGM_);

    // API of field "ActionSWID"

    static const int kActionSWID = 16;

    /**
     * Clears the field "ActionSWID".
     *
     * The field will be set to its default value. The hasActionSWID()
     * method will return false.
     */
    inline void clearActionSWID();

    /**
     * Checks whether the field "ActionSWID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActionSWID()). Otherwise it will return false.
     */
    inline bool hasActionSWID () const;

    /**
     * Returns the value of the member "ActionSWID".
     *
     * ID of behavior type for action SW
     *
     * @return The value of the field "ActionSWID"
     */
    inline uint8 getActionSWID () const;

    /**
     * Sets the value of the member "ActionSWID".
     *
     * ID of behavior type for action SW
     *
     * @param ActionSWID The value which will be set
     */
    inline void setActionSWID (uint8 ActionSWID_);

    // API of field "ParameterOfActionSW"

    static const int kParameterOfActionSW = 17;

    /**
     * Clears the field "ParameterOfActionSW".
     *
     * The field will be set to its default value. The hasParameterOfActionSW()
     * method will return false.
     */
    inline void clearParameterOfActionSW();

    /**
     * Checks whether the field "ParameterOfActionSW" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setParameterOfActionSW()). Otherwise it will return false.
     */
    inline bool hasParameterOfActionSW () const;

    /**
     * Returns the value of the member "ParameterOfActionSW".
     *
     * Parameter of action SW
     *
     * @return The value of the field "ParameterOfActionSW"
     */
    inline uint32 getParameterOfActionSW () const;

    /**
     * Sets the value of the member "ParameterOfActionSW".
     *
     * Parameter of action SW
     *
     * @param ParameterOfActionSW The value which will be set
     */
    inline void setParameterOfActionSW (uint32 ParameterOfActionSW_);

    // API of field "FlagOfDispButtonCtrl"

    static const int kFlagOfDispButtonCtrl = 18;

    /**
     * Clears the field "FlagOfDispButtonCtrl".
     *
     * The field will be set to its default value. The hasFlagOfDispButtonCtrl()
     * method will return false.
     */
    inline void clearFlagOfDispButtonCtrl();

    /**
     * Checks whether the field "FlagOfDispButtonCtrl" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFlagOfDispButtonCtrl()). Otherwise it will return false.
     */
    inline bool hasFlagOfDispButtonCtrl () const;

    /**
     * Returns the value of the member "FlagOfDispButtonCtrl".
     *
     * Flag of displaying button
     *
     * @return The value of the field "FlagOfDispButtonCtrl"
     */
    inline uint8 getFlagOfDispButtonCtrl () const;

    /**
     * Sets the value of the member "FlagOfDispButtonCtrl".
     *
     * Flag of displaying button
     *
     * @param FlagOfDispButtonCtrl The value which will be set
     */
    inline void setFlagOfDispButtonCtrl (uint8 FlagOfDispButtonCtrl_);

    // API of field "FlagOfCtrlDuringRunning"

    static const int kFlagOfCtrlDuringRunning = 19;

    /**
     * Clears the field "FlagOfCtrlDuringRunning".
     *
     * The field will be set to its default value. The hasFlagOfCtrlDuringRunning()
     * method will return false.
     */
    inline void clearFlagOfCtrlDuringRunning();

    /**
     * Checks whether the field "FlagOfCtrlDuringRunning" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFlagOfCtrlDuringRunning()). Otherwise it will return false.
     */
    inline bool hasFlagOfCtrlDuringRunning () const;

    /**
     * Returns the value of the member "FlagOfCtrlDuringRunning".
     *
     * Flag of control during vehicle is running
     *
     * @return The value of the field "FlagOfCtrlDuringRunning"
     */
    inline uint8 getFlagOfCtrlDuringRunning () const;

    /**
     * Sets the value of the member "FlagOfCtrlDuringRunning".
     *
     * Flag of control during vehicle is running
     *
     * @param FlagOfCtrlDuringRunning The value which will be set
     */
    inline void setFlagOfCtrlDuringRunning (uint8 FlagOfCtrlDuringRunning_);

    // API of field "NameOfImageButton"

    static const int kNameOfImageButton = 20;

    /**
     * Clears the field "NameOfImageButton".
     *
     * The field will be set to its default value. The hasNameOfImageButton()
     * method will return false.
     */
    inline void clearNameOfImageButton();

    /**
     * Checks whether the field "NameOfImageButton" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNameOfImageButton()). Otherwise it will return false.
     */
    inline bool hasNameOfImageButton () const;

    /**
     * Returns the value of the member "NameOfImageButton".
     *
     * Name of image button
     *
     * @return The value of the field "NameOfImageButton"
     */
    inline const ::std::string& getNameOfImageButton () const;

    /**
     * Retrieves the value of the field "NameOfImageButton" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "NameOfImageButton".
     */
    inline ::std::string& getNameOfImageButtonMutable ();

    /**
     * Sets the value of the member "NameOfImageButton".
     *
     * Name of image button
     *
     * @param NameOfImageButton The value which will be set
     */
    inline void setNameOfImageButton (const ::std::string& NameOfImageButton_);

    /**
     * Sets the value of the member "NameOfImageButton".
     *
     * Name of image button
     *
     * @param NameOfImageButton The value which will be set
     */
    inline void setNameOfImageButton (const char* NameOfImageButton_);

    /**
     * Sets the value of the member "NameOfImageButton".
     *
     * Name of image button
     *
     * @param NameOfImageButton The value which will be set
     */
    inline void setNameOfImageButton (const char* value, size_t size);

    // API of field "NameOfActionSW"

    static const int kNameOfActionSW = 21;

    /**
     * Clears the field "NameOfActionSW".
     *
     * The field will be set to its default value. The hasNameOfActionSW()
     * method will return false.
     */
    inline void clearNameOfActionSW();

    /**
     * Checks whether the field "NameOfActionSW" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNameOfActionSW()). Otherwise it will return false.
     */
    inline bool hasNameOfActionSW () const;

    /**
     * Returns the value of the member "NameOfActionSW".
     *
     * Name of action SW
     *
     * @return The value of the field "NameOfActionSW"
     */
    inline const ::std::string& getNameOfActionSW () const;

    /**
     * Retrieves the value of the field "NameOfActionSW" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "NameOfActionSW".
     */
    inline ::std::string& getNameOfActionSWMutable ();

    /**
     * Sets the value of the member "NameOfActionSW".
     *
     * Name of action SW
     *
     * @param NameOfActionSW The value which will be set
     */
    inline void setNameOfActionSW (const ::std::string& NameOfActionSW_);

    /**
     * Sets the value of the member "NameOfActionSW".
     *
     * Name of action SW
     *
     * @param NameOfActionSW The value which will be set
     */
    inline void setNameOfActionSW (const char* NameOfActionSW_);

    /**
     * Sets the value of the member "NameOfActionSW".
     *
     * Name of action SW
     *
     * @param NameOfActionSW The value which will be set
     */
    inline void setNameOfActionSW (const char* value, size_t size);

    // API of field "FlagOfExecOfChannelContents"

    static const int kFlagOfExecOfChannelContents = 22;

    /**
     * Clears the field "FlagOfExecOfChannelContents".
     *
     * The field will be set to its default value. The hasFlagOfExecOfChannelContents()
     * method will return false.
     */
    inline void clearFlagOfExecOfChannelContents();

    /**
     * Checks whether the field "FlagOfExecOfChannelContents" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFlagOfExecOfChannelContents()). Otherwise it will return false.
     */
    inline bool hasFlagOfExecOfChannelContents () const;

    /**
     * Returns the value of the member "FlagOfExecOfChannelContents".
     *
     * Flag of execution of channel contents
     *
     * @return The value of the field "FlagOfExecOfChannelContents"
     */
    inline uint8 getFlagOfExecOfChannelContents () const;

    /**
     * Sets the value of the member "FlagOfExecOfChannelContents".
     *
     * Flag of execution of channel contents
     *
     * @param FlagOfExecOfChannelContents The value which will be set
     */
    inline void setFlagOfExecOfChannelContents (uint8 FlagOfExecOfChannelContents_);

    // API of field "FlagOfStoringCtrl"

    static const int kFlagOfStoringCtrl = 23;

    /**
     * Clears the field "FlagOfStoringCtrl".
     *
     * The field will be set to its default value. The hasFlagOfStoringCtrl()
     * method will return false.
     */
    inline void clearFlagOfStoringCtrl();

    /**
     * Checks whether the field "FlagOfStoringCtrl" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFlagOfStoringCtrl()). Otherwise it will return false.
     */
    inline bool hasFlagOfStoringCtrl () const;

    /**
     * Returns the value of the member "FlagOfStoringCtrl".
     *
     * Flag of storing channel contents
     *
     * @return The value of the field "FlagOfStoringCtrl"
     */
    inline uint8 getFlagOfStoringCtrl () const;

    /**
     * Sets the value of the member "FlagOfStoringCtrl".
     *
     * Flag of storing channel contents
     *
     * @param FlagOfStoringCtrl The value which will be set
     */
    inline void setFlagOfStoringCtrl (uint8 FlagOfStoringCtrl_);

    // API of field "ImageAvailability"

    static const int kImageAvailability = 24;

    /**
     * Clears the field "ImageAvailability".
     *
     * The field will be set to its default value. The hasImageAvailability()
     * method will return false.
     */
    inline void clearImageAvailability();

    /**
     * Checks whether the field "ImageAvailability" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setImageAvailability()). Otherwise it will return false.
     */
    inline bool hasImageAvailability () const;

    /**
     * Returns the value of the member "ImageAvailability".
     *
     * Image avaiability of channel contents
     *
     * @return The value of the field "ImageAvailability"
     */
    inline uint8 getImageAvailability () const;

    /**
     * Sets the value of the member "ImageAvailability".
     *
     * Image avaiability of channel contents
     *
     * @param ImageAvailability The value which will be set
     */
    inline void setImageAvailability (uint8 ImageAvailability_);

    // API of field "ImagePath"

    static const int kImagePath = 25;

    /**
     * Clears the field "ImagePath".
     *
     * The field will be set to its default value. The hasImagePath()
     * method will return false.
     */
    inline void clearImagePath();

    /**
     * Checks whether the field "ImagePath" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setImagePath()). Otherwise it will return false.
     */
    inline bool hasImagePath () const;

    /**
     * Returns the value of the member "ImagePath".
     *
     * Image for display
     *
     * @return The value of the field "ImagePath"
     */
    inline const ::std::string& getImagePath () const;

    /**
     * Retrieves the value of the field "ImagePath" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ImagePath".
     */
    inline ::std::string& getImagePathMutable ();

    /**
     * Sets the value of the member "ImagePath".
     *
     * Image for display
     *
     * @param ImagePath The value which will be set
     */
    inline void setImagePath (const ::std::string& ImagePath_);

    /**
     * Sets the value of the member "ImagePath".
     *
     * Image for display
     *
     * @param ImagePath The value which will be set
     */
    inline void setImagePath (const char* ImagePath_);

    /**
     * Sets the value of the member "ImagePath".
     *
     * Image for display
     *
     * @param ImagePath The value which will be set
     */
    inline void setImagePath (const char* value, size_t size);

    // API of field "ChannelID"

    static const int kChannelID = 26;

    /**
     * Clears the field "ChannelID".
     *
     * The field will be set to its default value. The hasChannelID()
     * method will return false.
     */
    inline void clearChannelID();

    /**
     * Checks whether the field "ChannelID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelID()). Otherwise it will return false.
     */
    inline bool hasChannelID () const;

    /**
     * Returns the value of the member "ChannelID".
     *
     * ID of channel. PRIMARY KEY and FOREIGN KEY.
     *
     * @return The value of the field "ChannelID"
     */
    inline uint16 getChannelID () const;

    /**
     * Sets the value of the member "ChannelID".
     *
     * ID of channel. PRIMARY KEY and FOREIGN KEY.
     *
     * @param ChannelID The value which will be set
     */
    inline void setChannelID (uint16 ChannelID_);

    static const ContentData &getDefaultInstance();

private:

    inline void set_has_ChannelContentsID ();

    inline void clear_has_ChannelContentsID ();

    inline void set_has_Title ();

    inline void clear_has_Title ();

    inline void set_has_TitleForTTS ();

    inline void clear_has_TitleForTTS ();

    inline void set_has_Direction ();

    inline void clear_has_Direction ();

    inline void set_has_LAT ();

    inline void clear_has_LAT ();

    inline void set_has_LON ();

    inline void clear_has_LON ();

    inline void set_has_LocationAttribute ();

    inline void clear_has_LocationAttribute ();

    inline void set_has_DestOrWayPointType ();

    inline void clear_has_DestOrWayPointType ();

    inline void set_has_Address ();

    inline void clear_has_Address ();

    inline void set_has_PhoneNumber ();

    inline void clear_has_PhoneNumber ();

    inline void set_has_PhoneNumberForDisp ();

    inline void clear_has_PhoneNumberForDisp ();

    inline void set_has_Text ();

    inline void clear_has_Text ();

    inline void set_has_TextForTTS ();

    inline void clear_has_TextForTTS ();

    inline void set_has_IconID ();

    inline void clear_has_IconID ();

    inline void set_has_SoundIDForBeginningOfPlay ();

    inline void clear_has_SoundIDForBeginningOfPlay ();

    inline void set_has_SoundIDForBGM ();

    inline void clear_has_SoundIDForBGM ();

    inline void set_has_ActionSWID ();

    inline void clear_has_ActionSWID ();

    inline void set_has_ParameterOfActionSW ();

    inline void clear_has_ParameterOfActionSW ();

    inline void set_has_FlagOfDispButtonCtrl ();

    inline void clear_has_FlagOfDispButtonCtrl ();

    inline void set_has_FlagOfCtrlDuringRunning ();

    inline void clear_has_FlagOfCtrlDuringRunning ();

    inline void set_has_NameOfImageButton ();

    inline void clear_has_NameOfImageButton ();

    inline void set_has_NameOfActionSW ();

    inline void clear_has_NameOfActionSW ();

    inline void set_has_FlagOfExecOfChannelContents ();

    inline void clear_has_FlagOfExecOfChannelContents ();

    inline void set_has_FlagOfStoringCtrl ();

    inline void clear_has_FlagOfStoringCtrl ();

    inline void set_has_ImageAvailability ();

    inline void clear_has_ImageAvailability ();

    inline void set_has_ImagePath ();

    inline void clear_has_ImagePath ();

    inline void set_has_ChannelID ();

    inline void clear_has_ChannelID ();

    uint32 _has_bits_[ (27 + 31) / 32];

    uint8 _ChannelContentsID;

    ::std::string _Title;

    ::std::string _TitleForTTS;

    uint8 _Direction;

    uint32 _LAT;

    uint32 _LON;

    uint8 _LocationAttribute;

    uint8 _DestOrWayPointType;

    ::std::string _Address;

    ::std::string _PhoneNumber;

    ::std::string _PhoneNumberForDisp;

    ::std::string _Text;

    ::std::string _TextForTTS;

    uint16 _IconID;

    uint16 _SoundIDForBeginningOfPlay;

    uint16 _SoundIDForBGM;

    uint8 _ActionSWID;

    uint32 _ParameterOfActionSW;

    uint8 _FlagOfDispButtonCtrl;

    uint8 _FlagOfCtrlDuringRunning;

    ::std::string _NameOfImageButton;

    ::std::string _NameOfActionSW;

    uint8 _FlagOfExecOfChannelContents;

    uint8 _FlagOfStoringCtrl;

    uint8 _ImageAvailability;

    ::std::string _ImagePath;

    uint16 _ChannelID;

};

/**
 * If the meaning of "ChannelDataIVM" isn't clear, then there should be a description here.
 */
class ChannelDataIVM {
public:

    /**
     * Default constructor
     */
    inline  ChannelDataIVM ();

    /**
     * Copy constructor
     */
    inline  ChannelDataIVM (const ChannelDataIVM &rhs);

    /**
     * All fields constructor
     */
    inline  ChannelDataIVM (uint16 IndexInternal_, uint16 ChannelID_, const ::std::string& ChannelName_, uint16 SubChannelNum_, uint16 StoredNumOfChannelContents_, uint16 TotalNumOfChannelContents_);

    /**
     * Destructor
     */
    inline  ~ChannelDataIVM();

    /**
     * Assignment operator
     */
    inline ChannelDataIVM& operator = (const ChannelDataIVM& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChannelDataIVM& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChannelDataIVM& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChannelDataIVM& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChannelDataIVM& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "IndexInternal"

    static const int kIndexInternal = 0;

    /**
     * Clears the field "IndexInternal".
     *
     * The field will be set to its default value. The hasIndexInternal()
     * method will return false.
     */
    inline void clearIndexInternal();

    /**
     * Checks whether the field "IndexInternal" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIndexInternal()). Otherwise it will return false.
     */
    inline bool hasIndexInternal () const;

    /**
     * Returns the value of the member "IndexInternal".
     *
     * IndexInternal. PRIMARY KEY.
     *
     * @return The value of the field "IndexInternal"
     */
    inline uint16 getIndexInternal () const;

    /**
     * Sets the value of the member "IndexInternal".
     *
     * IndexInternal. PRIMARY KEY.
     *
     * @param IndexInternal The value which will be set
     */
    inline void setIndexInternal (uint16 IndexInternal_);

    // API of field "ChannelID"

    static const int kChannelID = 1;

    /**
     * Clears the field "ChannelID".
     *
     * The field will be set to its default value. The hasChannelID()
     * method will return false.
     */
    inline void clearChannelID();

    /**
     * Checks whether the field "ChannelID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelID()). Otherwise it will return false.
     */
    inline bool hasChannelID () const;

    /**
     * Returns the value of the member "ChannelID".
     *
     * ID of channel data IVM.
     *
     * @return The value of the field "ChannelID"
     */
    inline uint16 getChannelID () const;

    /**
     * Sets the value of the member "ChannelID".
     *
     * ID of channel data IVM.
     *
     * @param ChannelID The value which will be set
     */
    inline void setChannelID (uint16 ChannelID_);

    // API of field "ChannelName"

    static const int kChannelName = 2;

    /**
     * Clears the field "ChannelName".
     *
     * The field will be set to its default value. The hasChannelName()
     * method will return false.
     */
    inline void clearChannelName();

    /**
     * Checks whether the field "ChannelName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelName()). Otherwise it will return false.
     */
    inline bool hasChannelName () const;

    /**
     * Returns the value of the member "ChannelName".
     *
     * Channel Name of channel data IVM
     *
     * @return The value of the field "ChannelName"
     */
    inline const ::std::string& getChannelName () const;

    /**
     * Retrieves the value of the field "ChannelName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ChannelName".
     */
    inline ::std::string& getChannelNameMutable ();

    /**
     * Sets the value of the member "ChannelName".
     *
     * Channel Name of channel data IVM
     *
     * @param ChannelName The value which will be set
     */
    inline void setChannelName (const ::std::string& ChannelName_);

    /**
     * Sets the value of the member "ChannelName".
     *
     * Channel Name of channel data IVM
     *
     * @param ChannelName The value which will be set
     */
    inline void setChannelName (const char* ChannelName_);

    /**
     * Sets the value of the member "ChannelName".
     *
     * Channel Name of channel data IVM
     *
     * @param ChannelName The value which will be set
     */
    inline void setChannelName (const char* value, size_t size);

    // API of field "SubChannelNum"

    static const int kSubChannelNum = 3;

    /**
     * Clears the field "SubChannelNum".
     *
     * The field will be set to its default value. The hasSubChannelNum()
     * method will return false.
     */
    inline void clearSubChannelNum();

    /**
     * Checks whether the field "SubChannelNum" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSubChannelNum()). Otherwise it will return false.
     */
    inline bool hasSubChannelNum () const;

    /**
     * Returns the value of the member "SubChannelNum".
     *
     * Number of sub-channel.
     *
     * @return The value of the field "SubChannelNum"
     */
    inline uint16 getSubChannelNum () const;

    /**
     * Sets the value of the member "SubChannelNum".
     *
     * Number of sub-channel.
     *
     * @param SubChannelNum The value which will be set
     */
    inline void setSubChannelNum (uint16 SubChannelNum_);

    // API of field "StoredNumOfChannelContents"

    static const int kStoredNumOfChannelContents = 4;

    /**
     * Clears the field "StoredNumOfChannelContents".
     *
     * The field will be set to its default value. The hasStoredNumOfChannelContents()
     * method will return false.
     */
    inline void clearStoredNumOfChannelContents();

    /**
     * Checks whether the field "StoredNumOfChannelContents" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStoredNumOfChannelContents()). Otherwise it will return false.
     */
    inline bool hasStoredNumOfChannelContents () const;

    /**
     * Returns the value of the member "StoredNumOfChannelContents".
     *
     * Number of Channel Contents are stored.
     *
     * @return The value of the field "StoredNumOfChannelContents"
     */
    inline uint16 getStoredNumOfChannelContents () const;

    /**
     * Sets the value of the member "StoredNumOfChannelContents".
     *
     * Number of Channel Contents are stored.
     *
     * @param StoredNumOfChannelContents The value which will be set
     */
    inline void setStoredNumOfChannelContents (uint16 StoredNumOfChannelContents_);

    // API of field "TotalNumOfChannelContents"

    static const int kTotalNumOfChannelContents = 5;

    /**
     * Clears the field "TotalNumOfChannelContents".
     *
     * The field will be set to its default value. The hasTotalNumOfChannelContents()
     * method will return false.
     */
    inline void clearTotalNumOfChannelContents();

    /**
     * Checks whether the field "TotalNumOfChannelContents" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTotalNumOfChannelContents()). Otherwise it will return false.
     */
    inline bool hasTotalNumOfChannelContents () const;

    /**
     * Returns the value of the member "TotalNumOfChannelContents".
     *
     * Total number of Channel Contents.
     *
     * @return The value of the field "TotalNumOfChannelContents"
     */
    inline uint16 getTotalNumOfChannelContents () const;

    /**
     * Sets the value of the member "TotalNumOfChannelContents".
     *
     * Total number of Channel Contents.
     *
     * @param TotalNumOfChannelContents The value which will be set
     */
    inline void setTotalNumOfChannelContents (uint16 TotalNumOfChannelContents_);

    static const ChannelDataIVM &getDefaultInstance();

private:

    inline void set_has_IndexInternal ();

    inline void clear_has_IndexInternal ();

    inline void set_has_ChannelID ();

    inline void clear_has_ChannelID ();

    inline void set_has_ChannelName ();

    inline void clear_has_ChannelName ();

    inline void set_has_SubChannelNum ();

    inline void clear_has_SubChannelNum ();

    inline void set_has_StoredNumOfChannelContents ();

    inline void clear_has_StoredNumOfChannelContents ();

    inline void set_has_TotalNumOfChannelContents ();

    inline void clear_has_TotalNumOfChannelContents ();

    uint32 _has_bits_[ (6 + 31) / 32];

    uint16 _IndexInternal;

    uint16 _ChannelID;

    ::std::string _ChannelName;

    uint16 _SubChannelNum;

    uint16 _StoredNumOfChannelContents;

    uint16 _TotalNumOfChannelContents;

};

/**
 * If the meaning of "ContentDataIVM" isn't clear, then there should be a description here.
 */
class ContentDataIVM {
public:

    /**
     * Default constructor
     */
    inline  ContentDataIVM ();

    /**
     * Copy constructor
     */
    inline  ContentDataIVM (const ContentDataIVM &rhs);

    /**
     * All fields constructor
     */
    inline  ContentDataIVM (uint8 ChannelContentsID_, const ::std::string& IndexInternal_, const ::std::string& Title_, const ::std::string& TitleForTTS_, uint8 Direction_, uint32 LAT_, uint32 LON_, uint8 LocationAttribute_, uint8 DestOrWayPointType_, const ::std::string& Address_, const ::std::string& PhoneNumber_, const ::std::string& PhoneNumberForDisp_, const ::std::string& Text_, const ::std::string& TextForTTS_, uint16 IconID_, uint16 SoundIDForBeginningOfPlay_, uint16 SoundIDForBGM_, uint8 ActionSWID_, uint32 ParameterOfActionSW_, uint8 FlagOfDispButtonCtrl_, uint8 FlagOfCtrlDuringRunning_, const ::std::string& NameOfImageButton_, const ::std::string& NameOfActionSW_, uint8 FlagOfExecOfChannelContents_, uint8 FlagOfStoringCtrl_, uint8 ImageAvailability_, const ::std::string& ImagePath_);

    /**
     * Destructor
     */
    inline  ~ContentDataIVM();

    /**
     * Assignment operator
     */
    inline ContentDataIVM& operator = (const ContentDataIVM& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ContentDataIVM& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ContentDataIVM& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ContentDataIVM& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ContentDataIVM& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ChannelContentsID"

    static const int kChannelContentsID = 0;

    /**
     * Clears the field "ChannelContentsID".
     *
     * The field will be set to its default value. The hasChannelContentsID()
     * method will return false.
     */
    inline void clearChannelContentsID();

    /**
     * Checks whether the field "ChannelContentsID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelContentsID()). Otherwise it will return false.
     */
    inline bool hasChannelContentsID () const;

    /**
     * Returns the value of the member "ChannelContentsID".
     *
     * ID of channel contents in channel data. PRIMARY KEY.
     *
     * @return The value of the field "ChannelContentsID"
     */
    inline uint8 getChannelContentsID () const;

    /**
     * Sets the value of the member "ChannelContentsID".
     *
     * ID of channel contents in channel data. PRIMARY KEY.
     *
     * @param ChannelContentsID The value which will be set
     */
    inline void setChannelContentsID (uint8 ChannelContentsID_);

    // API of field "IndexInternal"

    static const int kIndexInternal = 1;

    /**
     * Clears the field "IndexInternal".
     *
     * The field will be set to its default value. The hasIndexInternal()
     * method will return false.
     */
    inline void clearIndexInternal();

    /**
     * Checks whether the field "IndexInternal" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIndexInternal()). Otherwise it will return false.
     */
    inline bool hasIndexInternal () const;

    /**
     * Returns the value of the member "IndexInternal".
     *
     * IndexInternal of channel IVM. FOREIGN KEY and PRIMARY KEY.
     *
     * @return The value of the field "IndexInternal"
     */
    inline const ::std::string& getIndexInternal () const;

    /**
     * Retrieves the value of the field "IndexInternal" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "IndexInternal".
     */
    inline ::std::string& getIndexInternalMutable ();

    /**
     * Sets the value of the member "IndexInternal".
     *
     * IndexInternal of channel IVM. FOREIGN KEY and PRIMARY KEY.
     *
     * @param IndexInternal The value which will be set
     */
    inline void setIndexInternal (const ::std::string& IndexInternal_);

    /**
     * Sets the value of the member "IndexInternal".
     *
     * IndexInternal of channel IVM. FOREIGN KEY and PRIMARY KEY.
     *
     * @param IndexInternal The value which will be set
     */
    inline void setIndexInternal (const char* IndexInternal_);

    /**
     * Sets the value of the member "IndexInternal".
     *
     * IndexInternal of channel IVM. FOREIGN KEY and PRIMARY KEY.
     *
     * @param IndexInternal The value which will be set
     */
    inline void setIndexInternal (const char* value, size_t size);

    // API of field "Title"

    static const int kTitle = 2;

    /**
     * Clears the field "Title".
     *
     * The field will be set to its default value. The hasTitle()
     * method will return false.
     */
    inline void clearTitle();

    /**
     * Checks whether the field "Title" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTitle()). Otherwise it will return false.
     */
    inline bool hasTitle () const;

    /**
     * Returns the value of the member "Title".
     *
     * Title of channel contents
     *
     * @return The value of the field "Title"
     */
    inline const ::std::string& getTitle () const;

    /**
     * Retrieves the value of the field "Title" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Title".
     */
    inline ::std::string& getTitleMutable ();

    /**
     * Sets the value of the member "Title".
     *
     * Title of channel contents
     *
     * @param Title The value which will be set
     */
    inline void setTitle (const ::std::string& Title_);

    /**
     * Sets the value of the member "Title".
     *
     * Title of channel contents
     *
     * @param Title The value which will be set
     */
    inline void setTitle (const char* Title_);

    /**
     * Sets the value of the member "Title".
     *
     * Title of channel contents
     *
     * @param Title The value which will be set
     */
    inline void setTitle (const char* value, size_t size);

    // API of field "TitleForTTS"

    static const int kTitleForTTS = 3;

    /**
     * Clears the field "TitleForTTS".
     *
     * The field will be set to its default value. The hasTitleForTTS()
     * method will return false.
     */
    inline void clearTitleForTTS();

    /**
     * Checks whether the field "TitleForTTS" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTitleForTTS()). Otherwise it will return false.
     */
    inline bool hasTitleForTTS () const;

    /**
     * Returns the value of the member "TitleForTTS".
     *
     * Title of channel contents for TTS
     *
     * @return The value of the field "TitleForTTS"
     */
    inline const ::std::string& getTitleForTTS () const;

    /**
     * Retrieves the value of the field "TitleForTTS" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TitleForTTS".
     */
    inline ::std::string& getTitleForTTSMutable ();

    /**
     * Sets the value of the member "TitleForTTS".
     *
     * Title of channel contents for TTS
     *
     * @param TitleForTTS The value which will be set
     */
    inline void setTitleForTTS (const ::std::string& TitleForTTS_);

    /**
     * Sets the value of the member "TitleForTTS".
     *
     * Title of channel contents for TTS
     *
     * @param TitleForTTS The value which will be set
     */
    inline void setTitleForTTS (const char* TitleForTTS_);

    /**
     * Sets the value of the member "TitleForTTS".
     *
     * Title of channel contents for TTS
     *
     * @param TitleForTTS The value which will be set
     */
    inline void setTitleForTTS (const char* value, size_t size);

    // API of field "Direction"

    static const int kDirection = 4;

    /**
     * Clears the field "Direction".
     *
     * The field will be set to its default value. The hasDirection()
     * method will return false.
     */
    inline void clearDirection();

    /**
     * Checks whether the field "Direction" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDirection()). Otherwise it will return false.
     */
    inline bool hasDirection () const;

    /**
     * Returns the value of the member "Direction".
     *
     * TBD
     *
     * @return The value of the field "Direction"
     */
    inline uint8 getDirection () const;

    /**
     * Sets the value of the member "Direction".
     *
     * TBD
     *
     * @param Direction The value which will be set
     */
    inline void setDirection (uint8 Direction_);

    // API of field "LAT"

    static const int kLAT = 5;

    /**
     * Clears the field "LAT".
     *
     * The field will be set to its default value. The hasLAT()
     * method will return false.
     */
    inline void clearLAT();

    /**
     * Checks whether the field "LAT" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLAT()). Otherwise it will return false.
     */
    inline bool hasLAT () const;

    /**
     * Returns the value of the member "LAT".
     *
     * TBD
     *
     * @return The value of the field "LAT"
     */
    inline uint32 getLAT () const;

    /**
     * Sets the value of the member "LAT".
     *
     * TBD
     *
     * @param LAT The value which will be set
     */
    inline void setLAT (uint32 LAT_);

    // API of field "LON"

    static const int kLON = 6;

    /**
     * Clears the field "LON".
     *
     * The field will be set to its default value. The hasLON()
     * method will return false.
     */
    inline void clearLON();

    /**
     * Checks whether the field "LON" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLON()). Otherwise it will return false.
     */
    inline bool hasLON () const;

    /**
     * Returns the value of the member "LON".
     *
     * TBD
     *
     * @return The value of the field "LON"
     */
    inline uint32 getLON () const;

    /**
     * Sets the value of the member "LON".
     *
     * TBD
     *
     * @param LON The value which will be set
     */
    inline void setLON (uint32 LON_);

    // API of field "LocationAttribute"

    static const int kLocationAttribute = 7;

    /**
     * Clears the field "LocationAttribute".
     *
     * The field will be set to its default value. The hasLocationAttribute()
     * method will return false.
     */
    inline void clearLocationAttribute();

    /**
     * Checks whether the field "LocationAttribute" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLocationAttribute()). Otherwise it will return false.
     */
    inline bool hasLocationAttribute () const;

    /**
     * Returns the value of the member "LocationAttribute".
     *
     * Location attribute
     *
     * @return The value of the field "LocationAttribute"
     */
    inline uint8 getLocationAttribute () const;

    /**
     * Sets the value of the member "LocationAttribute".
     *
     * Location attribute
     *
     * @param LocationAttribute The value which will be set
     */
    inline void setLocationAttribute (uint8 LocationAttribute_);

    // API of field "DestOrWayPointType"

    static const int kDestOrWayPointType = 8;

    /**
     * Clears the field "DestOrWayPointType".
     *
     * The field will be set to its default value. The hasDestOrWayPointType()
     * method will return false.
     */
    inline void clearDestOrWayPointType();

    /**
     * Checks whether the field "DestOrWayPointType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestOrWayPointType()). Otherwise it will return false.
     */
    inline bool hasDestOrWayPointType () const;

    /**
     * Returns the value of the member "DestOrWayPointType".
     *
     * Defines the location is destination or way point
     *
     * @return The value of the field "DestOrWayPointType"
     */
    inline uint8 getDestOrWayPointType () const;

    /**
     * Sets the value of the member "DestOrWayPointType".
     *
     * Defines the location is destination or way point
     *
     * @param DestOrWayPointType The value which will be set
     */
    inline void setDestOrWayPointType (uint8 DestOrWayPointType_);

    // API of field "Address"

    static const int kAddress = 9;

    /**
     * Clears the field "Address".
     *
     * The field will be set to its default value. The hasAddress()
     * method will return false.
     */
    inline void clearAddress();

    /**
     * Checks whether the field "Address" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAddress()). Otherwise it will return false.
     */
    inline bool hasAddress () const;

    /**
     * Returns the value of the member "Address".
     *
     * Address for display
     *
     * @return The value of the field "Address"
     */
    inline const ::std::string& getAddress () const;

    /**
     * Retrieves the value of the field "Address" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Address".
     */
    inline ::std::string& getAddressMutable ();

    /**
     * Sets the value of the member "Address".
     *
     * Address for display
     *
     * @param Address The value which will be set
     */
    inline void setAddress (const ::std::string& Address_);

    /**
     * Sets the value of the member "Address".
     *
     * Address for display
     *
     * @param Address The value which will be set
     */
    inline void setAddress (const char* Address_);

    /**
     * Sets the value of the member "Address".
     *
     * Address for display
     *
     * @param Address The value which will be set
     */
    inline void setAddress (const char* value, size_t size);

    // API of field "PhoneNumber"

    static const int kPhoneNumber = 10;

    /**
     * Clears the field "PhoneNumber".
     *
     * The field will be set to its default value. The hasPhoneNumber()
     * method will return false.
     */
    inline void clearPhoneNumber();

    /**
     * Checks whether the field "PhoneNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneNumber()). Otherwise it will return false.
     */
    inline bool hasPhoneNumber () const;

    /**
     * Returns the value of the member "PhoneNumber".
     *
     * Phone number
     *
     * @return The value of the field "PhoneNumber"
     */
    inline const ::std::string& getPhoneNumber () const;

    /**
     * Retrieves the value of the field "PhoneNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PhoneNumber".
     */
    inline ::std::string& getPhoneNumberMutable ();

    /**
     * Sets the value of the member "PhoneNumber".
     *
     * Phone number
     *
     * @param PhoneNumber The value which will be set
     */
    inline void setPhoneNumber (const ::std::string& PhoneNumber_);

    /**
     * Sets the value of the member "PhoneNumber".
     *
     * Phone number
     *
     * @param PhoneNumber The value which will be set
     */
    inline void setPhoneNumber (const char* PhoneNumber_);

    /**
     * Sets the value of the member "PhoneNumber".
     *
     * Phone number
     *
     * @param PhoneNumber The value which will be set
     */
    inline void setPhoneNumber (const char* value, size_t size);

    // API of field "PhoneNumberForDisp"

    static const int kPhoneNumberForDisp = 11;

    /**
     * Clears the field "PhoneNumberForDisp".
     *
     * The field will be set to its default value. The hasPhoneNumberForDisp()
     * method will return false.
     */
    inline void clearPhoneNumberForDisp();

    /**
     * Checks whether the field "PhoneNumberForDisp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneNumberForDisp()). Otherwise it will return false.
     */
    inline bool hasPhoneNumberForDisp () const;

    /**
     * Returns the value of the member "PhoneNumberForDisp".
     *
     * Phone number for display
     *
     * @return The value of the field "PhoneNumberForDisp"
     */
    inline const ::std::string& getPhoneNumberForDisp () const;

    /**
     * Retrieves the value of the field "PhoneNumberForDisp" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PhoneNumberForDisp".
     */
    inline ::std::string& getPhoneNumberForDispMutable ();

    /**
     * Sets the value of the member "PhoneNumberForDisp".
     *
     * Phone number for display
     *
     * @param PhoneNumberForDisp The value which will be set
     */
    inline void setPhoneNumberForDisp (const ::std::string& PhoneNumberForDisp_);

    /**
     * Sets the value of the member "PhoneNumberForDisp".
     *
     * Phone number for display
     *
     * @param PhoneNumberForDisp The value which will be set
     */
    inline void setPhoneNumberForDisp (const char* PhoneNumberForDisp_);

    /**
     * Sets the value of the member "PhoneNumberForDisp".
     *
     * Phone number for display
     *
     * @param PhoneNumberForDisp The value which will be set
     */
    inline void setPhoneNumberForDisp (const char* value, size_t size);

    // API of field "Text"

    static const int kText = 12;

    /**
     * Clears the field "Text".
     *
     * The field will be set to its default value. The hasText()
     * method will return false.
     */
    inline void clearText();

    /**
     * Checks whether the field "Text" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setText()). Otherwise it will return false.
     */
    inline bool hasText () const;

    /**
     * Returns the value of the member "Text".
     *
     * Description of channel for display
     *
     * @return The value of the field "Text"
     */
    inline const ::std::string& getText () const;

    /**
     * Retrieves the value of the field "Text" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Text".
     */
    inline ::std::string& getTextMutable ();

    /**
     * Sets the value of the member "Text".
     *
     * Description of channel for display
     *
     * @param Text The value which will be set
     */
    inline void setText (const ::std::string& Text_);

    /**
     * Sets the value of the member "Text".
     *
     * Description of channel for display
     *
     * @param Text The value which will be set
     */
    inline void setText (const char* Text_);

    /**
     * Sets the value of the member "Text".
     *
     * Description of channel for display
     *
     * @param Text The value which will be set
     */
    inline void setText (const char* value, size_t size);

    // API of field "TextForTTS"

    static const int kTextForTTS = 13;

    /**
     * Clears the field "TextForTTS".
     *
     * The field will be set to its default value. The hasTextForTTS()
     * method will return false.
     */
    inline void clearTextForTTS();

    /**
     * Checks whether the field "TextForTTS" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTextForTTS()). Otherwise it will return false.
     */
    inline bool hasTextForTTS () const;

    /**
     * Returns the value of the member "TextForTTS".
     *
     * Description of this channel for TTS
     *
     * @return The value of the field "TextForTTS"
     */
    inline const ::std::string& getTextForTTS () const;

    /**
     * Retrieves the value of the field "TextForTTS" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TextForTTS".
     */
    inline ::std::string& getTextForTTSMutable ();

    /**
     * Sets the value of the member "TextForTTS".
     *
     * Description of this channel for TTS
     *
     * @param TextForTTS The value which will be set
     */
    inline void setTextForTTS (const ::std::string& TextForTTS_);

    /**
     * Sets the value of the member "TextForTTS".
     *
     * Description of this channel for TTS
     *
     * @param TextForTTS The value which will be set
     */
    inline void setTextForTTS (const char* TextForTTS_);

    /**
     * Sets the value of the member "TextForTTS".
     *
     * Description of this channel for TTS
     *
     * @param TextForTTS The value which will be set
     */
    inline void setTextForTTS (const char* value, size_t size);

    // API of field "IconID"

    static const int kIconID = 14;

    /**
     * Clears the field "IconID".
     *
     * The field will be set to its default value. The hasIconID()
     * method will return false.
     */
    inline void clearIconID();

    /**
     * Checks whether the field "IconID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIconID()). Otherwise it will return false.
     */
    inline bool hasIconID () const;

    /**
     * Returns the value of the member "IconID".
     *
     * ID of icon
     *
     * @return The value of the field "IconID"
     */
    inline uint16 getIconID () const;

    /**
     * Sets the value of the member "IconID".
     *
     * ID of icon
     *
     * @param IconID The value which will be set
     */
    inline void setIconID (uint16 IconID_);

    // API of field "SoundIDForBeginningOfPlay"

    static const int kSoundIDForBeginningOfPlay = 15;

    /**
     * Clears the field "SoundIDForBeginningOfPlay".
     *
     * The field will be set to its default value. The hasSoundIDForBeginningOfPlay()
     * method will return false.
     */
    inline void clearSoundIDForBeginningOfPlay();

    /**
     * Checks whether the field "SoundIDForBeginningOfPlay" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSoundIDForBeginningOfPlay()). Otherwise it will return false.
     */
    inline bool hasSoundIDForBeginningOfPlay () const;

    /**
     * Returns the value of the member "SoundIDForBeginningOfPlay".
     *
     * ID of sound played at the beginning of auto play
     *
     * @return The value of the field "SoundIDForBeginningOfPlay"
     */
    inline uint16 getSoundIDForBeginningOfPlay () const;

    /**
     * Sets the value of the member "SoundIDForBeginningOfPlay".
     *
     * ID of sound played at the beginning of auto play
     *
     * @param SoundIDForBeginningOfPlay The value which will be set
     */
    inline void setSoundIDForBeginningOfPlay (uint16 SoundIDForBeginningOfPlay_);

    // API of field "SoundIDForBGM"

    static const int kSoundIDForBGM = 16;

    /**
     * Clears the field "SoundIDForBGM".
     *
     * The field will be set to its default value. The hasSoundIDForBGM()
     * method will return false.
     */
    inline void clearSoundIDForBGM();

    /**
     * Checks whether the field "SoundIDForBGM" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSoundIDForBGM()). Otherwise it will return false.
     */
    inline bool hasSoundIDForBGM () const;

    /**
     * Returns the value of the member "SoundIDForBGM".
     *
     * ID of sound for BGM played during auto play
     *
     * @return The value of the field "SoundIDForBGM"
     */
    inline uint16 getSoundIDForBGM () const;

    /**
     * Sets the value of the member "SoundIDForBGM".
     *
     * ID of sound for BGM played during auto play
     *
     * @param SoundIDForBGM The value which will be set
     */
    inline void setSoundIDForBGM (uint16 SoundIDForBGM_);

    // API of field "ActionSWID"

    static const int kActionSWID = 17;

    /**
     * Clears the field "ActionSWID".
     *
     * The field will be set to its default value. The hasActionSWID()
     * method will return false.
     */
    inline void clearActionSWID();

    /**
     * Checks whether the field "ActionSWID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActionSWID()). Otherwise it will return false.
     */
    inline bool hasActionSWID () const;

    /**
     * Returns the value of the member "ActionSWID".
     *
     * ID of behavior type for action SW
     *
     * @return The value of the field "ActionSWID"
     */
    inline uint8 getActionSWID () const;

    /**
     * Sets the value of the member "ActionSWID".
     *
     * ID of behavior type for action SW
     *
     * @param ActionSWID The value which will be set
     */
    inline void setActionSWID (uint8 ActionSWID_);

    // API of field "ParameterOfActionSW"

    static const int kParameterOfActionSW = 18;

    /**
     * Clears the field "ParameterOfActionSW".
     *
     * The field will be set to its default value. The hasParameterOfActionSW()
     * method will return false.
     */
    inline void clearParameterOfActionSW();

    /**
     * Checks whether the field "ParameterOfActionSW" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setParameterOfActionSW()). Otherwise it will return false.
     */
    inline bool hasParameterOfActionSW () const;

    /**
     * Returns the value of the member "ParameterOfActionSW".
     *
     * Parameter of action SW
     *
     * @return The value of the field "ParameterOfActionSW"
     */
    inline uint32 getParameterOfActionSW () const;

    /**
     * Sets the value of the member "ParameterOfActionSW".
     *
     * Parameter of action SW
     *
     * @param ParameterOfActionSW The value which will be set
     */
    inline void setParameterOfActionSW (uint32 ParameterOfActionSW_);

    // API of field "FlagOfDispButtonCtrl"

    static const int kFlagOfDispButtonCtrl = 19;

    /**
     * Clears the field "FlagOfDispButtonCtrl".
     *
     * The field will be set to its default value. The hasFlagOfDispButtonCtrl()
     * method will return false.
     */
    inline void clearFlagOfDispButtonCtrl();

    /**
     * Checks whether the field "FlagOfDispButtonCtrl" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFlagOfDispButtonCtrl()). Otherwise it will return false.
     */
    inline bool hasFlagOfDispButtonCtrl () const;

    /**
     * Returns the value of the member "FlagOfDispButtonCtrl".
     *
     * Flag of displaying button
     *
     * @return The value of the field "FlagOfDispButtonCtrl"
     */
    inline uint8 getFlagOfDispButtonCtrl () const;

    /**
     * Sets the value of the member "FlagOfDispButtonCtrl".
     *
     * Flag of displaying button
     *
     * @param FlagOfDispButtonCtrl The value which will be set
     */
    inline void setFlagOfDispButtonCtrl (uint8 FlagOfDispButtonCtrl_);

    // API of field "FlagOfCtrlDuringRunning"

    static const int kFlagOfCtrlDuringRunning = 20;

    /**
     * Clears the field "FlagOfCtrlDuringRunning".
     *
     * The field will be set to its default value. The hasFlagOfCtrlDuringRunning()
     * method will return false.
     */
    inline void clearFlagOfCtrlDuringRunning();

    /**
     * Checks whether the field "FlagOfCtrlDuringRunning" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFlagOfCtrlDuringRunning()). Otherwise it will return false.
     */
    inline bool hasFlagOfCtrlDuringRunning () const;

    /**
     * Returns the value of the member "FlagOfCtrlDuringRunning".
     *
     * Flag of control during vehicle is running
     *
     * @return The value of the field "FlagOfCtrlDuringRunning"
     */
    inline uint8 getFlagOfCtrlDuringRunning () const;

    /**
     * Sets the value of the member "FlagOfCtrlDuringRunning".
     *
     * Flag of control during vehicle is running
     *
     * @param FlagOfCtrlDuringRunning The value which will be set
     */
    inline void setFlagOfCtrlDuringRunning (uint8 FlagOfCtrlDuringRunning_);

    // API of field "NameOfImageButton"

    static const int kNameOfImageButton = 21;

    /**
     * Clears the field "NameOfImageButton".
     *
     * The field will be set to its default value. The hasNameOfImageButton()
     * method will return false.
     */
    inline void clearNameOfImageButton();

    /**
     * Checks whether the field "NameOfImageButton" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNameOfImageButton()). Otherwise it will return false.
     */
    inline bool hasNameOfImageButton () const;

    /**
     * Returns the value of the member "NameOfImageButton".
     *
     * Name of image button
     *
     * @return The value of the field "NameOfImageButton"
     */
    inline const ::std::string& getNameOfImageButton () const;

    /**
     * Retrieves the value of the field "NameOfImageButton" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "NameOfImageButton".
     */
    inline ::std::string& getNameOfImageButtonMutable ();

    /**
     * Sets the value of the member "NameOfImageButton".
     *
     * Name of image button
     *
     * @param NameOfImageButton The value which will be set
     */
    inline void setNameOfImageButton (const ::std::string& NameOfImageButton_);

    /**
     * Sets the value of the member "NameOfImageButton".
     *
     * Name of image button
     *
     * @param NameOfImageButton The value which will be set
     */
    inline void setNameOfImageButton (const char* NameOfImageButton_);

    /**
     * Sets the value of the member "NameOfImageButton".
     *
     * Name of image button
     *
     * @param NameOfImageButton The value which will be set
     */
    inline void setNameOfImageButton (const char* value, size_t size);

    // API of field "NameOfActionSW"

    static const int kNameOfActionSW = 22;

    /**
     * Clears the field "NameOfActionSW".
     *
     * The field will be set to its default value. The hasNameOfActionSW()
     * method will return false.
     */
    inline void clearNameOfActionSW();

    /**
     * Checks whether the field "NameOfActionSW" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNameOfActionSW()). Otherwise it will return false.
     */
    inline bool hasNameOfActionSW () const;

    /**
     * Returns the value of the member "NameOfActionSW".
     *
     * Name of action SW
     *
     * @return The value of the field "NameOfActionSW"
     */
    inline const ::std::string& getNameOfActionSW () const;

    /**
     * Retrieves the value of the field "NameOfActionSW" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "NameOfActionSW".
     */
    inline ::std::string& getNameOfActionSWMutable ();

    /**
     * Sets the value of the member "NameOfActionSW".
     *
     * Name of action SW
     *
     * @param NameOfActionSW The value which will be set
     */
    inline void setNameOfActionSW (const ::std::string& NameOfActionSW_);

    /**
     * Sets the value of the member "NameOfActionSW".
     *
     * Name of action SW
     *
     * @param NameOfActionSW The value which will be set
     */
    inline void setNameOfActionSW (const char* NameOfActionSW_);

    /**
     * Sets the value of the member "NameOfActionSW".
     *
     * Name of action SW
     *
     * @param NameOfActionSW The value which will be set
     */
    inline void setNameOfActionSW (const char* value, size_t size);

    // API of field "FlagOfExecOfChannelContents"

    static const int kFlagOfExecOfChannelContents = 23;

    /**
     * Clears the field "FlagOfExecOfChannelContents".
     *
     * The field will be set to its default value. The hasFlagOfExecOfChannelContents()
     * method will return false.
     */
    inline void clearFlagOfExecOfChannelContents();

    /**
     * Checks whether the field "FlagOfExecOfChannelContents" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFlagOfExecOfChannelContents()). Otherwise it will return false.
     */
    inline bool hasFlagOfExecOfChannelContents () const;

    /**
     * Returns the value of the member "FlagOfExecOfChannelContents".
     *
     * Flag of execution of channel contents
     *
     * @return The value of the field "FlagOfExecOfChannelContents"
     */
    inline uint8 getFlagOfExecOfChannelContents () const;

    /**
     * Sets the value of the member "FlagOfExecOfChannelContents".
     *
     * Flag of execution of channel contents
     *
     * @param FlagOfExecOfChannelContents The value which will be set
     */
    inline void setFlagOfExecOfChannelContents (uint8 FlagOfExecOfChannelContents_);

    // API of field "FlagOfStoringCtrl"

    static const int kFlagOfStoringCtrl = 24;

    /**
     * Clears the field "FlagOfStoringCtrl".
     *
     * The field will be set to its default value. The hasFlagOfStoringCtrl()
     * method will return false.
     */
    inline void clearFlagOfStoringCtrl();

    /**
     * Checks whether the field "FlagOfStoringCtrl" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFlagOfStoringCtrl()). Otherwise it will return false.
     */
    inline bool hasFlagOfStoringCtrl () const;

    /**
     * Returns the value of the member "FlagOfStoringCtrl".
     *
     * Flag of storing channel contents
     *
     * @return The value of the field "FlagOfStoringCtrl"
     */
    inline uint8 getFlagOfStoringCtrl () const;

    /**
     * Sets the value of the member "FlagOfStoringCtrl".
     *
     * Flag of storing channel contents
     *
     * @param FlagOfStoringCtrl The value which will be set
     */
    inline void setFlagOfStoringCtrl (uint8 FlagOfStoringCtrl_);

    // API of field "ImageAvailability"

    static const int kImageAvailability = 25;

    /**
     * Clears the field "ImageAvailability".
     *
     * The field will be set to its default value. The hasImageAvailability()
     * method will return false.
     */
    inline void clearImageAvailability();

    /**
     * Checks whether the field "ImageAvailability" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setImageAvailability()). Otherwise it will return false.
     */
    inline bool hasImageAvailability () const;

    /**
     * Returns the value of the member "ImageAvailability".
     *
     * Image avaiability of channel contents
     *
     * @return The value of the field "ImageAvailability"
     */
    inline uint8 getImageAvailability () const;

    /**
     * Sets the value of the member "ImageAvailability".
     *
     * Image avaiability of channel contents
     *
     * @param ImageAvailability The value which will be set
     */
    inline void setImageAvailability (uint8 ImageAvailability_);

    // API of field "ImagePath"

    static const int kImagePath = 26;

    /**
     * Clears the field "ImagePath".
     *
     * The field will be set to its default value. The hasImagePath()
     * method will return false.
     */
    inline void clearImagePath();

    /**
     * Checks whether the field "ImagePath" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setImagePath()). Otherwise it will return false.
     */
    inline bool hasImagePath () const;

    /**
     * Returns the value of the member "ImagePath".
     *
     * Image for display
     *
     * @return The value of the field "ImagePath"
     */
    inline const ::std::string& getImagePath () const;

    /**
     * Retrieves the value of the field "ImagePath" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ImagePath".
     */
    inline ::std::string& getImagePathMutable ();

    /**
     * Sets the value of the member "ImagePath".
     *
     * Image for display
     *
     * @param ImagePath The value which will be set
     */
    inline void setImagePath (const ::std::string& ImagePath_);

    /**
     * Sets the value of the member "ImagePath".
     *
     * Image for display
     *
     * @param ImagePath The value which will be set
     */
    inline void setImagePath (const char* ImagePath_);

    /**
     * Sets the value of the member "ImagePath".
     *
     * Image for display
     *
     * @param ImagePath The value which will be set
     */
    inline void setImagePath (const char* value, size_t size);

    static const ContentDataIVM &getDefaultInstance();

private:

    inline void set_has_ChannelContentsID ();

    inline void clear_has_ChannelContentsID ();

    inline void set_has_IndexInternal ();

    inline void clear_has_IndexInternal ();

    inline void set_has_Title ();

    inline void clear_has_Title ();

    inline void set_has_TitleForTTS ();

    inline void clear_has_TitleForTTS ();

    inline void set_has_Direction ();

    inline void clear_has_Direction ();

    inline void set_has_LAT ();

    inline void clear_has_LAT ();

    inline void set_has_LON ();

    inline void clear_has_LON ();

    inline void set_has_LocationAttribute ();

    inline void clear_has_LocationAttribute ();

    inline void set_has_DestOrWayPointType ();

    inline void clear_has_DestOrWayPointType ();

    inline void set_has_Address ();

    inline void clear_has_Address ();

    inline void set_has_PhoneNumber ();

    inline void clear_has_PhoneNumber ();

    inline void set_has_PhoneNumberForDisp ();

    inline void clear_has_PhoneNumberForDisp ();

    inline void set_has_Text ();

    inline void clear_has_Text ();

    inline void set_has_TextForTTS ();

    inline void clear_has_TextForTTS ();

    inline void set_has_IconID ();

    inline void clear_has_IconID ();

    inline void set_has_SoundIDForBeginningOfPlay ();

    inline void clear_has_SoundIDForBeginningOfPlay ();

    inline void set_has_SoundIDForBGM ();

    inline void clear_has_SoundIDForBGM ();

    inline void set_has_ActionSWID ();

    inline void clear_has_ActionSWID ();

    inline void set_has_ParameterOfActionSW ();

    inline void clear_has_ParameterOfActionSW ();

    inline void set_has_FlagOfDispButtonCtrl ();

    inline void clear_has_FlagOfDispButtonCtrl ();

    inline void set_has_FlagOfCtrlDuringRunning ();

    inline void clear_has_FlagOfCtrlDuringRunning ();

    inline void set_has_NameOfImageButton ();

    inline void clear_has_NameOfImageButton ();

    inline void set_has_NameOfActionSW ();

    inline void clear_has_NameOfActionSW ();

    inline void set_has_FlagOfExecOfChannelContents ();

    inline void clear_has_FlagOfExecOfChannelContents ();

    inline void set_has_FlagOfStoringCtrl ();

    inline void clear_has_FlagOfStoringCtrl ();

    inline void set_has_ImageAvailability ();

    inline void clear_has_ImageAvailability ();

    inline void set_has_ImagePath ();

    inline void clear_has_ImagePath ();

    uint32 _has_bits_[ (27 + 31) / 32];

    uint8 _ChannelContentsID;

    ::std::string _IndexInternal;

    ::std::string _Title;

    ::std::string _TitleForTTS;

    uint8 _Direction;

    uint32 _LAT;

    uint32 _LON;

    uint8 _LocationAttribute;

    uint8 _DestOrWayPointType;

    ::std::string _Address;

    ::std::string _PhoneNumber;

    ::std::string _PhoneNumberForDisp;

    ::std::string _Text;

    ::std::string _TextForTTS;

    uint16 _IconID;

    uint16 _SoundIDForBeginningOfPlay;

    uint16 _SoundIDForBGM;

    uint8 _ActionSWID;

    uint32 _ParameterOfActionSW;

    uint8 _FlagOfDispButtonCtrl;

    uint8 _FlagOfCtrlDuringRunning;

    ::std::string _NameOfImageButton;

    ::std::string _NameOfActionSW;

    uint8 _FlagOfExecOfChannelContents;

    uint8 _FlagOfStoringCtrl;

    uint8 _ImageAvailability;

    ::std::string _ImagePath;

};

/**
 * The start message of the method "GetChannelData"
 * This method is called whenever HMI sends any request to the TCU.
 * Method start to inform the fc_usb_tcu about the get channel data request from TCU.
 */
class GetChannelDataStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetChannelDataStart ();

    /**
     * Copy constructor
     */
    inline  GetChannelDataStart (const GetChannelDataStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetChannelDataStart (const ::tcu_usb_main_fi_types::T_usb_tcu_Channel_Info_List& Channel_Info_List_, bool bBackgroundDownloadType_);

    /**
     * Destructor
     */
    inline virtual  ~GetChannelDataStart();

    /**
     * Assignment operator
     */
    inline GetChannelDataStart& operator = (const GetChannelDataStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetChannelDataStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetChannelDataStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetChannelDataStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetChannelDataStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Channel_Info_List"

    static const int kChannel_Info_List = 0;

    /**
     * Clears the field "Channel_Info_List".
     *
     * The field will be set to its default value. The hasChannel_Info_List()
     * method will return false.
     */
    inline void clearChannel_Info_List();

    /**
     * Checks whether the field "Channel_Info_List" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannel_Info_List()). Otherwise it will return false.
     */
    inline bool hasChannel_Info_List () const;

    /**
     * Returns the value of the member "Channel_Info_List".
     *
     * List of Channel ID and Channel Content ID
     *
     * @return The value of the field "Channel_Info_List"
     */
    inline const ::tcu_usb_main_fi_types::T_usb_tcu_Channel_Info_List& getChannel_Info_List () const;

    /**
     * Retrieves the value of the field "Channel_Info_List" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Channel_Info_List".
     */
    inline ::tcu_usb_main_fi_types::T_usb_tcu_Channel_Info_List& getChannel_Info_ListMutable ();

    /**
     * Sets the value of the member "Channel_Info_List".
     *
     * List of Channel ID and Channel Content ID
     *
     * @param Channel_Info_List The value which will be set
     */
    inline void setChannel_Info_List (const ::tcu_usb_main_fi_types::T_usb_tcu_Channel_Info_List& Channel_Info_List_);

    // API of field "bBackgroundDownloadType"

    static const int kBBackgroundDownloadType = 1;

    /**
     * Clears the field "bBackgroundDownloadType".
     *
     * The field will be set to its default value. The hasBBackgroundDownloadType()
     * method will return false.
     */
    inline void clearBBackgroundDownloadType();

    /**
     * Checks whether the field "bBackgroundDownloadType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBBackgroundDownloadType()). Otherwise it will return false.
     */
    inline bool hasBBackgroundDownloadType () const;

    /**
     * Returns the value of the member "bBackgroundDownloadType".
     *
     * Describe this channel data belong to BackgroundDownload type or not.
     *
     * @return The value of the field "bBackgroundDownloadType"
     */
    inline bool getBBackgroundDownloadType () const;

    /**
     * Sets the value of the member "bBackgroundDownloadType".
     *
     * Describe this channel data belong to BackgroundDownload type or not.
     *
     * @param bBackgroundDownloadType The value which will be set
     */
    inline void setBBackgroundDownloadType (bool bBackgroundDownloadType_);

    static const GetChannelDataStart &getDefaultInstance();

private:

    static const ::std::vector< ::tcu_usb_main_fi_types::T_usb_tcu_Channel_Info >& getT_usb_tcu_Channel_InfoList_DefaultInstance ();

    inline void set_has_Channel_Info_List ();

    inline void clear_has_Channel_Info_List ();

    inline void set_has_bBackgroundDownloadType ();

    inline void clear_has_bBackgroundDownloadType ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::tcu_usb_main_fi_types::T_usb_tcu_Channel_Info_List _Channel_Info_List;

    bool _bBackgroundDownloadType;

};

/**
 * The error message of 'GetChannelData'
 * Error Message
 */
class GetChannelDataErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetChannelDataErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetChannelDataErrorStructure (const GetChannelDataErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetChannelDataErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~GetChannelDataErrorStructure();

    /**
     * Assignment operator
     */
    inline GetChannelDataErrorStructure& operator = (const GetChannelDataErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetChannelDataErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetChannelDataErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetChannelDataErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetChannelDataErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const GetChannelDataErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'GetChannelData'
 * Error Message
 */
class GetChannelDataError  : public ::asf::core::Payload {
public:

    enum GetChannelDataErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetChannelDataError ();

   /**
     * Copy constructor
     */
    inline  GetChannelDataError (const GetChannelDataError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetChannelDataError();

    /**
     * Assigns a new value to this object.
     */
    inline GetChannelDataError& operator = (const GetChannelDataError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetChannelDataError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetChannelDataError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetChannelDataError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetChannelDataError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetChannelDataError::GetChannelDataErrorField getField () const;

    inline void setField(GetChannelDataError::GetChannelDataErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetChannelDataErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetChannelDataErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetChannelDataErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetChannelDataErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetChannelDataErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetChannelDataErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetChannelDataErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetChannelDataErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetChannelDataError &getDefaultInstance();

private:

    inline void cloneData (const GetChannelDataError& rhs);

    inline void deleteData ();

    GetChannelDataErrorField __field;

    union {
        GetChannelDataErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "GetConnectedSearchResult"
 * This method is called whenever any Connected Search is requested from HMI.
 * Method start to inform the fc_usb_tcu about the get connected search result request from TCU.
 */
class GetConnectedSearchResultStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetConnectedSearchResultStart ();

    /**
     * Copy constructor
     */
    inline  GetConnectedSearchResultStart (const GetConnectedSearchResultStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetConnectedSearchResultStart (uint8 u8SizeOfKeyWord_, const ::std::string& strKeyWord_);

    /**
     * Destructor
     */
    inline virtual  ~GetConnectedSearchResultStart();

    /**
     * Assignment operator
     */
    inline GetConnectedSearchResultStart& operator = (const GetConnectedSearchResultStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetConnectedSearchResultStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetConnectedSearchResultStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetConnectedSearchResultStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetConnectedSearchResultStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8SizeOfKeyWord"

    static const int kU8SizeOfKeyWord = 0;

    /**
     * Clears the field "u8SizeOfKeyWord".
     *
     * The field will be set to its default value. The hasU8SizeOfKeyWord()
     * method will return false.
     */
    inline void clearU8SizeOfKeyWord();

    /**
     * Checks whether the field "u8SizeOfKeyWord" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SizeOfKeyWord()). Otherwise it will return false.
     */
    inline bool hasU8SizeOfKeyWord () const;

    /**
     * Returns the value of the member "u8SizeOfKeyWord".
     *
     * Size of the keyword to be searched.
     *
     * @return The value of the field "u8SizeOfKeyWord"
     */
    inline uint8 getU8SizeOfKeyWord () const;

    /**
     * Sets the value of the member "u8SizeOfKeyWord".
     *
     * Size of the keyword to be searched.
     *
     * @param u8SizeOfKeyWord The value which will be set
     */
    inline void setU8SizeOfKeyWord (uint8 u8SizeOfKeyWord_);

    // API of field "strKeyWord"

    static const int kStrKeyWord = 1;

    /**
     * Clears the field "strKeyWord".
     *
     * The field will be set to its default value. The hasStrKeyWord()
     * method will return false.
     */
    inline void clearStrKeyWord();

    /**
     * Checks whether the field "strKeyWord" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrKeyWord()). Otherwise it will return false.
     */
    inline bool hasStrKeyWord () const;

    /**
     * Returns the value of the member "strKeyWord".
     *
     * The keyword to be searched.
     *
     * @return The value of the field "strKeyWord"
     */
    inline const ::std::string& getStrKeyWord () const;

    /**
     * Retrieves the value of the field "strKeyWord" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strKeyWord".
     */
    inline ::std::string& getStrKeyWordMutable ();

    /**
     * Sets the value of the member "strKeyWord".
     *
     * The keyword to be searched.
     *
     * @param strKeyWord The value which will be set
     */
    inline void setStrKeyWord (const ::std::string& strKeyWord_);

    /**
     * Sets the value of the member "strKeyWord".
     *
     * The keyword to be searched.
     *
     * @param strKeyWord The value which will be set
     */
    inline void setStrKeyWord (const char* strKeyWord_);

    /**
     * Sets the value of the member "strKeyWord".
     *
     * The keyword to be searched.
     *
     * @param strKeyWord The value which will be set
     */
    inline void setStrKeyWord (const char* value, size_t size);

    static const GetConnectedSearchResultStart &getDefaultInstance();

private:

    inline void set_has_u8SizeOfKeyWord ();

    inline void clear_has_u8SizeOfKeyWord ();

    inline void set_has_strKeyWord ();

    inline void clear_has_strKeyWord ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8SizeOfKeyWord;

    ::std::string _strKeyWord;

};

/**
 * The error message of 'GetConnectedSearchResult'
 * Error Message
 */
class GetConnectedSearchResultErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetConnectedSearchResultErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetConnectedSearchResultErrorStructure (const GetConnectedSearchResultErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetConnectedSearchResultErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~GetConnectedSearchResultErrorStructure();

    /**
     * Assignment operator
     */
    inline GetConnectedSearchResultErrorStructure& operator = (const GetConnectedSearchResultErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetConnectedSearchResultErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetConnectedSearchResultErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetConnectedSearchResultErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetConnectedSearchResultErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const GetConnectedSearchResultErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'GetConnectedSearchResult'
 * Error Message
 */
class GetConnectedSearchResultError  : public ::asf::core::Payload {
public:

    enum GetConnectedSearchResultErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetConnectedSearchResultError ();

   /**
     * Copy constructor
     */
    inline  GetConnectedSearchResultError (const GetConnectedSearchResultError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetConnectedSearchResultError();

    /**
     * Assigns a new value to this object.
     */
    inline GetConnectedSearchResultError& operator = (const GetConnectedSearchResultError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetConnectedSearchResultError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetConnectedSearchResultError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetConnectedSearchResultError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetConnectedSearchResultError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetConnectedSearchResultError::GetConnectedSearchResultErrorField getField () const;

    inline void setField(GetConnectedSearchResultError::GetConnectedSearchResultErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetConnectedSearchResultErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetConnectedSearchResultErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetConnectedSearchResultErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetConnectedSearchResultErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetConnectedSearchResultErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetConnectedSearchResultErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetConnectedSearchResultErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetConnectedSearchResultErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetConnectedSearchResultError &getDefaultInstance();

private:

    inline void cloneData (const GetConnectedSearchResultError& rhs);

    inline void deleteData ();

    GetConnectedSearchResultErrorField __field;

    union {
        GetConnectedSearchResultErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "GetChannelMasterData"
 * This method is called whenever channel master data is requested by HMI.
 * Method start to inform the fc_usb_tcu about the get channel master data request from TCU.
 */
class GetChannelMasterDataStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetChannelMasterDataStart ();

    /**
     * Copy constructor
     */
    inline  GetChannelMasterDataStart (const GetChannelMasterDataStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetChannelMasterDataStart (bool bBackgroundDownloadType_);

    /**
     * Destructor
     */
    inline virtual  ~GetChannelMasterDataStart();

    /**
     * Assignment operator
     */
    inline GetChannelMasterDataStart& operator = (const GetChannelMasterDataStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetChannelMasterDataStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetChannelMasterDataStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetChannelMasterDataStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetChannelMasterDataStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bBackgroundDownloadType"

    static const int kBBackgroundDownloadType = 0;

    /**
     * Clears the field "bBackgroundDownloadType".
     *
     * The field will be set to its default value. The hasBBackgroundDownloadType()
     * method will return false.
     */
    inline void clearBBackgroundDownloadType();

    /**
     * Checks whether the field "bBackgroundDownloadType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBBackgroundDownloadType()). Otherwise it will return false.
     */
    inline bool hasBBackgroundDownloadType () const;

    /**
     * Returns the value of the member "bBackgroundDownloadType".
     *
     * Describe this channel data belong to BackgroundDownload type or not.
     *
     * @return The value of the field "bBackgroundDownloadType"
     */
    inline bool getBBackgroundDownloadType () const;

    /**
     * Sets the value of the member "bBackgroundDownloadType".
     *
     * Describe this channel data belong to BackgroundDownload type or not.
     *
     * @param bBackgroundDownloadType The value which will be set
     */
    inline void setBBackgroundDownloadType (bool bBackgroundDownloadType_);

    static const GetChannelMasterDataStart &getDefaultInstance();

private:

    inline void set_has_bBackgroundDownloadType ();

    inline void clear_has_bBackgroundDownloadType ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bBackgroundDownloadType;

};

/**
 * The error message of 'GetChannelMasterData'
 * Error Message
 */
class GetChannelMasterDataErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetChannelMasterDataErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetChannelMasterDataErrorStructure (const GetChannelMasterDataErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetChannelMasterDataErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~GetChannelMasterDataErrorStructure();

    /**
     * Assignment operator
     */
    inline GetChannelMasterDataErrorStructure& operator = (const GetChannelMasterDataErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetChannelMasterDataErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetChannelMasterDataErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetChannelMasterDataErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetChannelMasterDataErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const GetChannelMasterDataErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'GetChannelMasterData'
 * Error Message
 */
class GetChannelMasterDataError  : public ::asf::core::Payload {
public:

    enum GetChannelMasterDataErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetChannelMasterDataError ();

   /**
     * Copy constructor
     */
    inline  GetChannelMasterDataError (const GetChannelMasterDataError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetChannelMasterDataError();

    /**
     * Assigns a new value to this object.
     */
    inline GetChannelMasterDataError& operator = (const GetChannelMasterDataError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetChannelMasterDataError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetChannelMasterDataError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetChannelMasterDataError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetChannelMasterDataError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetChannelMasterDataError::GetChannelMasterDataErrorField getField () const;

    inline void setField(GetChannelMasterDataError::GetChannelMasterDataErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetChannelMasterDataErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetChannelMasterDataErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetChannelMasterDataErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetChannelMasterDataErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetChannelMasterDataErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetChannelMasterDataErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetChannelMasterDataErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetChannelMasterDataErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetChannelMasterDataError &getDefaultInstance();

private:

    inline void cloneData (const GetChannelMasterDataError& rhs);

    inline void deleteData ();

    GetChannelMasterDataErrorField __field;

    union {
        GetChannelMasterDataErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SynthesizeSpeak"
 * <p>This method will synthesize the text. The data is synthesised via TCU_TTS source.
 * If there is a on going synthesize then the current synthesize will be aborted and then new text will be synthesized.</p>
 */
class SynthesizeSpeakStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SynthesizeSpeakStart ();

    /**
     * Copy constructor
     */
    inline  SynthesizeSpeakStart (const SynthesizeSpeakStart &rhs);

    /**
     * All fields constructor
     */
    inline  SynthesizeSpeakStart (const ::std::string& TextAndTags_, uint16 u16ChannelID_, uint8 u8ChannelContentsID_, bool bHoldAudioChannel_);

    /**
     * Destructor
     */
    inline virtual  ~SynthesizeSpeakStart();

    /**
     * Assignment operator
     */
    inline SynthesizeSpeakStart& operator = (const SynthesizeSpeakStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SynthesizeSpeakStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SynthesizeSpeakStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SynthesizeSpeakStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SynthesizeSpeakStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TextAndTags"

    static const int kTextAndTags = 0;

    /**
     * Clears the field "TextAndTags".
     *
     * The field will be set to its default value. The hasTextAndTags()
     * method will return false.
     */
    inline void clearTextAndTags();

    /**
     * Checks whether the field "TextAndTags" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTextAndTags()). Otherwise it will return false.
     */
    inline bool hasTextAndTags () const;

    /**
     * Returns the value of the member "TextAndTags".
     *
     * <p>The string contains the text to be synthesized. Additionaly,
     * tags can be used within the string to give some extra
     * information. The possible tags for this method are:
     * <p>the tag <rate=>specifies the rate of the synthesis to be used,</p>
     * <p>the tag <vol=> specifies the volume of the synthesis to be used.</p>
     * <p>The tag <ttsdom=> specifies the domain for which tuning files are to be loaded.
     * Possible values are: 0:none, 1:navi, 2:sds</p>
     * <p>Example: <ttsdom=navi></p>
     * <p>The tag <dict> specifies information about the dictionary to be used for the included string.
     * It will look like "<dict destcat=... dest=... countryvoice=... lang=...countrydest=...countrydestname=...>String</dict>".</p>
     * <p>The parameter destcat is used to define, which type of the
     * dest-parameter is (destcat:dest => 1:SelectionCriterionType, 2:SpeechAppDictType, 3:T_e8_Slot, 4:T_e8_SDSDestinationType).</p>
     * <p>Destination contains - as described above - the ID of the
     * dictionary-type according to the definition in the li_fi
     * (SelectionCriterionType), sp_speechdp_fi (SpeechAppDictType) or  respectively.</p>
     * <p>The parameters countrydest and lang must be used according to ISO 3166 ALPHA 3 and ISO 639-1.
     * The whole string will only be parsed for this tag, if the parameter "TextStyle" is set to "Dicts".</p>
     * <p>The parameter countrydestname is used to optionally define the countryname if countrydest is not available.</p></p>
     *
     * @return The value of the field "TextAndTags"
     */
    inline const ::std::string& getTextAndTags () const;

    /**
     * Retrieves the value of the field "TextAndTags" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TextAndTags".
     */
    inline ::std::string& getTextAndTagsMutable ();

    /**
     * Sets the value of the member "TextAndTags".
     *
     * <p>The string contains the text to be synthesized. Additionaly,
     * tags can be used within the string to give some extra
     * information. The possible tags for this method are:
     * <p>the tag <rate=>specifies the rate of the synthesis to be used,</p>
     * <p>the tag <vol=> specifies the volume of the synthesis to be used.</p>
     * <p>The tag <ttsdom=> specifies the domain for which tuning files are to be loaded.
     * Possible values are: 0:none, 1:navi, 2:sds</p>
     * <p>Example: <ttsdom=navi></p>
     * <p>The tag <dict> specifies information about the dictionary to be used for the included string.
     * It will look like "<dict destcat=... dest=... countryvoice=... lang=...countrydest=...countrydestname=...>String</dict>".</p>
     * <p>The parameter destcat is used to define, which type of the
     * dest-parameter is (destcat:dest => 1:SelectionCriterionType, 2:SpeechAppDictType, 3:T_e8_Slot, 4:T_e8_SDSDestinationType).</p>
     * <p>Destination contains - as described above - the ID of the
     * dictionary-type according to the definition in the li_fi
     * (SelectionCriterionType), sp_speechdp_fi (SpeechAppDictType) or  respectively.</p>
     * <p>The parameters countrydest and lang must be used according to ISO 3166 ALPHA 3 and ISO 639-1.
     * The whole string will only be parsed for this tag, if the parameter "TextStyle" is set to "Dicts".</p>
     * <p>The parameter countrydestname is used to optionally define the countryname if countrydest is not available.</p></p>
     *
     * @param TextAndTags The value which will be set
     */
    inline void setTextAndTags (const ::std::string& TextAndTags_);

    /**
     * Sets the value of the member "TextAndTags".
     *
     * <p>The string contains the text to be synthesized. Additionaly,
     * tags can be used within the string to give some extra
     * information. The possible tags for this method are:
     * <p>the tag <rate=>specifies the rate of the synthesis to be used,</p>
     * <p>the tag <vol=> specifies the volume of the synthesis to be used.</p>
     * <p>The tag <ttsdom=> specifies the domain for which tuning files are to be loaded.
     * Possible values are: 0:none, 1:navi, 2:sds</p>
     * <p>Example: <ttsdom=navi></p>
     * <p>The tag <dict> specifies information about the dictionary to be used for the included string.
     * It will look like "<dict destcat=... dest=... countryvoice=... lang=...countrydest=...countrydestname=...>String</dict>".</p>
     * <p>The parameter destcat is used to define, which type of the
     * dest-parameter is (destcat:dest => 1:SelectionCriterionType, 2:SpeechAppDictType, 3:T_e8_Slot, 4:T_e8_SDSDestinationType).</p>
     * <p>Destination contains - as described above - the ID of the
     * dictionary-type according to the definition in the li_fi
     * (SelectionCriterionType), sp_speechdp_fi (SpeechAppDictType) or  respectively.</p>
     * <p>The parameters countrydest and lang must be used according to ISO 3166 ALPHA 3 and ISO 639-1.
     * The whole string will only be parsed for this tag, if the parameter "TextStyle" is set to "Dicts".</p>
     * <p>The parameter countrydestname is used to optionally define the countryname if countrydest is not available.</p></p>
     *
     * @param TextAndTags The value which will be set
     */
    inline void setTextAndTags (const char* TextAndTags_);

    /**
     * Sets the value of the member "TextAndTags".
     *
     * <p>The string contains the text to be synthesized. Additionaly,
     * tags can be used within the string to give some extra
     * information. The possible tags for this method are:
     * <p>the tag <rate=>specifies the rate of the synthesis to be used,</p>
     * <p>the tag <vol=> specifies the volume of the synthesis to be used.</p>
     * <p>The tag <ttsdom=> specifies the domain for which tuning files are to be loaded.
     * Possible values are: 0:none, 1:navi, 2:sds</p>
     * <p>Example: <ttsdom=navi></p>
     * <p>The tag <dict> specifies information about the dictionary to be used for the included string.
     * It will look like "<dict destcat=... dest=... countryvoice=... lang=...countrydest=...countrydestname=...>String</dict>".</p>
     * <p>The parameter destcat is used to define, which type of the
     * dest-parameter is (destcat:dest => 1:SelectionCriterionType, 2:SpeechAppDictType, 3:T_e8_Slot, 4:T_e8_SDSDestinationType).</p>
     * <p>Destination contains - as described above - the ID of the
     * dictionary-type according to the definition in the li_fi
     * (SelectionCriterionType), sp_speechdp_fi (SpeechAppDictType) or  respectively.</p>
     * <p>The parameters countrydest and lang must be used according to ISO 3166 ALPHA 3 and ISO 639-1.
     * The whole string will only be parsed for this tag, if the parameter "TextStyle" is set to "Dicts".</p>
     * <p>The parameter countrydestname is used to optionally define the countryname if countrydest is not available.</p></p>
     *
     * @param TextAndTags The value which will be set
     */
    inline void setTextAndTags (const char* value, size_t size);

    // API of field "u16ChannelID"

    static const int kU16ChannelID = 1;

    /**
     * Clears the field "u16ChannelID".
     *
     * The field will be set to its default value. The hasU16ChannelID()
     * method will return false.
     */
    inline void clearU16ChannelID();

    /**
     * Checks whether the field "u16ChannelID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ChannelID()). Otherwise it will return false.
     */
    inline bool hasU16ChannelID () const;

    /**
     * Returns the value of the member "u16ChannelID".
     *
     * <p>ChannelID to fetch title and text for TTS from database.</p>
     *
     * @return The value of the field "u16ChannelID"
     */
    inline uint16 getU16ChannelID () const;

    /**
     * Sets the value of the member "u16ChannelID".
     *
     * <p>ChannelID to fetch title and text for TTS from database.</p>
     *
     * @param u16ChannelID The value which will be set
     */
    inline void setU16ChannelID (uint16 u16ChannelID_);

    // API of field "u8ChannelContentsID"

    static const int kU8ChannelContentsID = 2;

    /**
     * Clears the field "u8ChannelContentsID".
     *
     * The field will be set to its default value. The hasU8ChannelContentsID()
     * method will return false.
     */
    inline void clearU8ChannelContentsID();

    /**
     * Checks whether the field "u8ChannelContentsID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8ChannelContentsID()). Otherwise it will return false.
     */
    inline bool hasU8ChannelContentsID () const;

    /**
     * Returns the value of the member "u8ChannelContentsID".
     *
     * <p>ChannelContentsID to fetch title and text for TTS from database.</p>
     *
     * @return The value of the field "u8ChannelContentsID"
     */
    inline uint8 getU8ChannelContentsID () const;

    /**
     * Sets the value of the member "u8ChannelContentsID".
     *
     * <p>ChannelContentsID to fetch title and text for TTS from database.</p>
     *
     * @param u8ChannelContentsID The value which will be set
     */
    inline void setU8ChannelContentsID (uint8 u8ChannelContentsID_);

    // API of field "bHoldAudioChannel"

    static const int kBHoldAudioChannel = 3;

    /**
     * Clears the field "bHoldAudioChannel".
     *
     * The field will be set to its default value. The hasBHoldAudioChannel()
     * method will return false.
     */
    inline void clearBHoldAudioChannel();

    /**
     * Checks whether the field "bHoldAudioChannel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBHoldAudioChannel()). Otherwise it will return false.
     */
    inline bool hasBHoldAudioChannel () const;

    /**
     * Returns the value of the member "bHoldAudioChannel".
     *
     * <p>if bHoldAudioChannel == true -> then audio source (TCU_TTS) will NOT be released after the text synthesis is complete.</p>
     * <p>bHoldAudioChannel == false -> then audio source (TCU_TTS) will be released after the text synthesis is complete.</p>
     *
     * @return The value of the field "bHoldAudioChannel"
     */
    inline bool getBHoldAudioChannel () const;

    /**
     * Sets the value of the member "bHoldAudioChannel".
     *
     * <p>if bHoldAudioChannel == true -> then audio source (TCU_TTS) will NOT be released after the text synthesis is complete.</p>
     * <p>bHoldAudioChannel == false -> then audio source (TCU_TTS) will be released after the text synthesis is complete.</p>
     *
     * @param bHoldAudioChannel The value which will be set
     */
    inline void setBHoldAudioChannel (bool bHoldAudioChannel_);

    static const SynthesizeSpeakStart &getDefaultInstance();

private:

    inline void set_has_TextAndTags ();

    inline void clear_has_TextAndTags ();

    inline void set_has_u16ChannelID ();

    inline void clear_has_u16ChannelID ();

    inline void set_has_u8ChannelContentsID ();

    inline void clear_has_u8ChannelContentsID ();

    inline void set_has_bHoldAudioChannel ();

    inline void clear_has_bHoldAudioChannel ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string _TextAndTags;

    uint16 _u16ChannelID;

    uint8 _u8ChannelContentsID;

    bool _bHoldAudioChannel;

};

/**
 * The start message of the method "AbortPrompt"
 * <p>This method will abort the synthesize. The job will be aborted and not continued at any time.
 * If Client want the synthesis to be done again, Client has to send SynthesizeSpeak() once again.</p>
 */
class AbortPromptStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AbortPromptStart ();

    /**
     * Copy constructor
     */
    inline  AbortPromptStart (const AbortPromptStart &rhs);

    /**
     * All fields constructor
     */
    inline  AbortPromptStart (bool bHoldAudioChannel_);

    /**
     * Destructor
     */
    inline virtual  ~AbortPromptStart();

    /**
     * Assignment operator
     */
    inline AbortPromptStart& operator = (const AbortPromptStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AbortPromptStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AbortPromptStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AbortPromptStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AbortPromptStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bHoldAudioChannel"

    static const int kBHoldAudioChannel = 0;

    /**
     * Clears the field "bHoldAudioChannel".
     *
     * The field will be set to its default value. The hasBHoldAudioChannel()
     * method will return false.
     */
    inline void clearBHoldAudioChannel();

    /**
     * Checks whether the field "bHoldAudioChannel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBHoldAudioChannel()). Otherwise it will return false.
     */
    inline bool hasBHoldAudioChannel () const;

    /**
     * Returns the value of the member "bHoldAudioChannel".
     *
     * <p>if bHoldAudioChannel == true -> then audio source (TCU_TTS) will NOT be released after the Abort.</p>
     * <p>bHoldAudioChannel == false -> then audio source (TCU_TTS) will be released after the Abort.</p>
     *
     * @return The value of the field "bHoldAudioChannel"
     */
    inline bool getBHoldAudioChannel () const;

    /**
     * Sets the value of the member "bHoldAudioChannel".
     *
     * <p>if bHoldAudioChannel == true -> then audio source (TCU_TTS) will NOT be released after the Abort.</p>
     * <p>bHoldAudioChannel == false -> then audio source (TCU_TTS) will be released after the Abort.</p>
     *
     * @param bHoldAudioChannel The value which will be set
     */
    inline void setBHoldAudioChannel (bool bHoldAudioChannel_);

    static const AbortPromptStart &getDefaultInstance();

private:

    inline void set_has_bHoldAudioChannel ();

    inline void clear_has_bHoldAudioChannel ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bHoldAudioChannel;

};

/**
 * The start message of the method "CancelRequest"
 * <p>This Method is called when a user cancels an already placed request.</p>
 * Method start to inform the fc_usb_tcu about a cancel request.
 */
class CancelRequestStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CancelRequestStart ();

    /**
     * Copy constructor
     */
    inline  CancelRequestStart (const CancelRequestStart &rhs);

    /**
     * All fields constructor
     */
    inline  CancelRequestStart (::tcu_usb_main_fi_types::T_e8_CancelRequestType eCancelRequestType_);

    /**
     * Destructor
     */
    inline virtual  ~CancelRequestStart();

    /**
     * Assignment operator
     */
    inline CancelRequestStart& operator = (const CancelRequestStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CancelRequestStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CancelRequestStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CancelRequestStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CancelRequestStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "eCancelRequestType"

    static const int kECancelRequestType = 0;

    /**
     * Clears the field "eCancelRequestType".
     *
     * The field will be set to its default value. The hasECancelRequestType()
     * method will return false.
     */
    inline void clearECancelRequestType();

    /**
     * Checks whether the field "eCancelRequestType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setECancelRequestType()). Otherwise it will return false.
     */
    inline bool hasECancelRequestType () const;

    /**
     * Returns the value of the member "eCancelRequestType".
     *
     * Describes the request type
     *
     * @return The value of the field "eCancelRequestType"
     */
    inline ::tcu_usb_main_fi_types::T_e8_CancelRequestType getECancelRequestType () const;

    /**
     * Sets the value of the member "eCancelRequestType".
     *
     * Describes the request type
     *
     * @param eCancelRequestType The value which will be set
     */
    inline void setECancelRequestType (::tcu_usb_main_fi_types::T_e8_CancelRequestType eCancelRequestType_);

    static const CancelRequestStart &getDefaultInstance();

private:

    inline void set_has_eCancelRequestType ();

    inline void clear_has_eCancelRequestType ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_usb_main_fi_types::T_e8_CancelRequestType _eCancelRequestType;

};

/**
 * The error message of 'CancelRequest'
 * Error Message
 */
class CancelRequestErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  CancelRequestErrorStructure ();

    /**
     * Copy constructor
     */
    inline  CancelRequestErrorStructure (const CancelRequestErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  CancelRequestErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~CancelRequestErrorStructure();

    /**
     * Assignment operator
     */
    inline CancelRequestErrorStructure& operator = (const CancelRequestErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CancelRequestErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CancelRequestErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CancelRequestErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CancelRequestErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const CancelRequestErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'CancelRequest'
 * Error Message
 */
class CancelRequestError  : public ::asf::core::Payload {
public:

    enum CancelRequestErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  CancelRequestError ();

   /**
     * Copy constructor
     */
    inline  CancelRequestError (const CancelRequestError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~CancelRequestError();

    /**
     * Assigns a new value to this object.
     */
    inline CancelRequestError& operator = (const CancelRequestError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CancelRequestError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CancelRequestError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CancelRequestError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CancelRequestError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline CancelRequestError::CancelRequestErrorField getField () const;

    inline void setField(CancelRequestError::CancelRequestErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "CancelRequestErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "CancelRequestErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const CancelRequestErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline CancelRequestErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline CancelRequestErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (CancelRequestErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "CancelRequestErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const CancelRequestErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const CancelRequestError &getDefaultInstance();

private:

    inline void cloneData (const CancelRequestError& rhs);

    inline void deleteData ();

    CancelRequestErrorField __field;

    union {
        CancelRequestErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SendGroupAData"
 * <p>This Method is called when GroupA to be sent to the backend.</p>
 * Method start to send GroupA to the fc_usb_tcu.
 */
class SendGroupADataStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendGroupADataStart ();

    /**
     * Copy constructor
     */
    inline  SendGroupADataStart (const SendGroupADataStart &rhs);

    /**
     * All fields constructor
     */
    inline  SendGroupADataStart (const ::tcu_usb_main_fi_types::T_usb_tcu_GroupA_Info& GroupA_Info_);

    /**
     * Destructor
     */
    inline virtual  ~SendGroupADataStart();

    /**
     * Assignment operator
     */
    inline SendGroupADataStart& operator = (const SendGroupADataStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendGroupADataStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendGroupADataStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendGroupADataStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendGroupADataStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "GroupA_Info"

    static const int kGroupA_Info = 0;

    /**
     * Clears the field "GroupA_Info".
     *
     * The field will be set to its default value. The hasGroupA_Info()
     * method will return false.
     */
    inline void clearGroupA_Info();

    /**
     * Checks whether the field "GroupA_Info" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGroupA_Info()). Otherwise it will return false.
     */
    inline bool hasGroupA_Info () const;

    /**
     * Returns the value of the member "GroupA_Info".
     *
     * Describes the GroupA data
     *
     * @return The value of the field "GroupA_Info"
     */
    inline const ::tcu_usb_main_fi_types::T_usb_tcu_GroupA_Info& getGroupA_Info () const;

    /**
     * Retrieves the value of the field "GroupA_Info" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "GroupA_Info".
     */
    inline ::tcu_usb_main_fi_types::T_usb_tcu_GroupA_Info& getGroupA_InfoMutable ();

    /**
     * Sets the value of the member "GroupA_Info".
     *
     * Describes the GroupA data
     *
     * @param GroupA_Info The value which will be set
     */
    inline void setGroupA_Info (const ::tcu_usb_main_fi_types::T_usb_tcu_GroupA_Info& GroupA_Info_);

    static const SendGroupADataStart &getDefaultInstance();

private:

    inline void set_has_GroupA_Info ();

    inline void clear_has_GroupA_Info ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_usb_main_fi_types::T_usb_tcu_GroupA_Info _GroupA_Info;

};

/**
 * The error message of 'SendGroupAData'
 * Error Message
 */
class SendGroupADataErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SendGroupADataErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SendGroupADataErrorStructure (const SendGroupADataErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SendGroupADataErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~SendGroupADataErrorStructure();

    /**
     * Assignment operator
     */
    inline SendGroupADataErrorStructure& operator = (const SendGroupADataErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendGroupADataErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendGroupADataErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendGroupADataErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendGroupADataErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const SendGroupADataErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'SendGroupAData'
 * Error Message
 */
class SendGroupADataError  : public ::asf::core::Payload {
public:

    enum SendGroupADataErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SendGroupADataError ();

   /**
     * Copy constructor
     */
    inline  SendGroupADataError (const SendGroupADataError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SendGroupADataError();

    /**
     * Assigns a new value to this object.
     */
    inline SendGroupADataError& operator = (const SendGroupADataError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendGroupADataError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendGroupADataError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendGroupADataError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendGroupADataError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SendGroupADataError::SendGroupADataErrorField getField () const;

    inline void setField(SendGroupADataError::SendGroupADataErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SendGroupADataErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SendGroupADataErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SendGroupADataErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SendGroupADataErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SendGroupADataErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SendGroupADataErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SendGroupADataErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SendGroupADataErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SendGroupADataError &getDefaultInstance();

private:

    inline void cloneData (const SendGroupADataError& rhs);

    inline void deleteData ();

    SendGroupADataErrorField __field;

    union {
        SendGroupADataErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "DeleteInVehicleMessage"
 * This Method is called by HMI to delete a particular IVM.
 * Method start to send delete request to the fc_usb_tcu.
 */
class DeleteInVehicleMessageStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeleteInVehicleMessageStart ();

    /**
     * Copy constructor
     */
    inline  DeleteInVehicleMessageStart (const DeleteInVehicleMessageStart &rhs);

    /**
     * All fields constructor
     */
    inline  DeleteInVehicleMessageStart (int64 s64IndexInternal_, uint8 u8ChannelContentsID_);

    /**
     * Destructor
     */
    inline virtual  ~DeleteInVehicleMessageStart();

    /**
     * Assignment operator
     */
    inline DeleteInVehicleMessageStart& operator = (const DeleteInVehicleMessageStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeleteInVehicleMessageStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeleteInVehicleMessageStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeleteInVehicleMessageStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeleteInVehicleMessageStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s64IndexInternal"

    static const int kS64IndexInternal = 0;

    /**
     * Clears the field "s64IndexInternal".
     *
     * The field will be set to its default value. The hasS64IndexInternal()
     * method will return false.
     */
    inline void clearS64IndexInternal();

    /**
     * Checks whether the field "s64IndexInternal" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS64IndexInternal()). Otherwise it will return false.
     */
    inline bool hasS64IndexInternal () const;

    /**
     * Returns the value of the member "s64IndexInternal".
     *
     * IndexInternal to delete a particular channel in IVM database.
     *
     * @return The value of the field "s64IndexInternal"
     */
    inline int64 getS64IndexInternal () const;

    /**
     * Sets the value of the member "s64IndexInternal".
     *
     * IndexInternal to delete a particular channel in IVM database.
     *
     * @param s64IndexInternal The value which will be set
     */
    inline void setS64IndexInternal (int64 s64IndexInternal_);

    // API of field "u8ChannelContentsID"

    static const int kU8ChannelContentsID = 1;

    /**
     * Clears the field "u8ChannelContentsID".
     *
     * The field will be set to its default value. The hasU8ChannelContentsID()
     * method will return false.
     */
    inline void clearU8ChannelContentsID();

    /**
     * Checks whether the field "u8ChannelContentsID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8ChannelContentsID()). Otherwise it will return false.
     */
    inline bool hasU8ChannelContentsID () const;

    /**
     * Returns the value of the member "u8ChannelContentsID".
     *
     * ChannelContentsID to delete a particular content of a channel in IVM database.
     *
     * @return The value of the field "u8ChannelContentsID"
     */
    inline uint8 getU8ChannelContentsID () const;

    /**
     * Sets the value of the member "u8ChannelContentsID".
     *
     * ChannelContentsID to delete a particular content of a channel in IVM database.
     *
     * @param u8ChannelContentsID The value which will be set
     */
    inline void setU8ChannelContentsID (uint8 u8ChannelContentsID_);

    static const DeleteInVehicleMessageStart &getDefaultInstance();

private:

    inline void set_has_s64IndexInternal ();

    inline void clear_has_s64IndexInternal ();

    inline void set_has_u8ChannelContentsID ();

    inline void clear_has_u8ChannelContentsID ();

    uint32 _has_bits_[ (2 + 31) / 32];

    int64 _s64IndexInternal;

    uint8 _u8ChannelContentsID;

};

/**
 * The error message of 'DeleteInVehicleMessage'
 * Error Message
 */
class DeleteInVehicleMessageErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DeleteInVehicleMessageErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DeleteInVehicleMessageErrorStructure (const DeleteInVehicleMessageErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DeleteInVehicleMessageErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~DeleteInVehicleMessageErrorStructure();

    /**
     * Assignment operator
     */
    inline DeleteInVehicleMessageErrorStructure& operator = (const DeleteInVehicleMessageErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeleteInVehicleMessageErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeleteInVehicleMessageErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeleteInVehicleMessageErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeleteInVehicleMessageErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const DeleteInVehicleMessageErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'DeleteInVehicleMessage'
 * Error Message
 */
class DeleteInVehicleMessageError  : public ::asf::core::Payload {
public:

    enum DeleteInVehicleMessageErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DeleteInVehicleMessageError ();

   /**
     * Copy constructor
     */
    inline  DeleteInVehicleMessageError (const DeleteInVehicleMessageError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DeleteInVehicleMessageError();

    /**
     * Assigns a new value to this object.
     */
    inline DeleteInVehicleMessageError& operator = (const DeleteInVehicleMessageError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeleteInVehicleMessageError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeleteInVehicleMessageError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeleteInVehicleMessageError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeleteInVehicleMessageError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DeleteInVehicleMessageError::DeleteInVehicleMessageErrorField getField () const;

    inline void setField(DeleteInVehicleMessageError::DeleteInVehicleMessageErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DeleteInVehicleMessageErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DeleteInVehicleMessageErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DeleteInVehicleMessageErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DeleteInVehicleMessageErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DeleteInVehicleMessageErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DeleteInVehicleMessageErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DeleteInVehicleMessageErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DeleteInVehicleMessageErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DeleteInVehicleMessageError &getDefaultInstance();

private:

    inline void cloneData (const DeleteInVehicleMessageError& rhs);

    inline void deleteData ();

    DeleteInVehicleMessageErrorField __field;

    union {
        DeleteInVehicleMessageErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The error message of 'ResetDatabase'
 * Error Message
 */
class ResetDatabaseErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  ResetDatabaseErrorStructure ();

    /**
     * Copy constructor
     */
    inline  ResetDatabaseErrorStructure (const ResetDatabaseErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  ResetDatabaseErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~ResetDatabaseErrorStructure();

    /**
     * Assignment operator
     */
    inline ResetDatabaseErrorStructure& operator = (const ResetDatabaseErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ResetDatabaseErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ResetDatabaseErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ResetDatabaseErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ResetDatabaseErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const ResetDatabaseErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'ResetDatabase'
 * Error Message
 */
class ResetDatabaseError  : public ::asf::core::Payload {
public:

    enum ResetDatabaseErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  ResetDatabaseError ();

   /**
     * Copy constructor
     */
    inline  ResetDatabaseError (const ResetDatabaseError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~ResetDatabaseError();

    /**
     * Assigns a new value to this object.
     */
    inline ResetDatabaseError& operator = (const ResetDatabaseError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ResetDatabaseError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ResetDatabaseError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ResetDatabaseError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ResetDatabaseError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline ResetDatabaseError::ResetDatabaseErrorField getField () const;

    inline void setField(ResetDatabaseError::ResetDatabaseErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "ResetDatabaseErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "ResetDatabaseErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ResetDatabaseErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ResetDatabaseErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline ResetDatabaseErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (ResetDatabaseErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "ResetDatabaseErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const ResetDatabaseErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const ResetDatabaseError &getDefaultInstance();

private:

    inline void cloneData (const ResetDatabaseError& rhs);

    inline void deleteData ();

    ResetDatabaseErrorField __field;

    union {
        ResetDatabaseErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The error message of 'GetServerList'
 * Error Message
 */
class GetServerListErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetServerListErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetServerListErrorStructure (const GetServerListErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetServerListErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~GetServerListErrorStructure();

    /**
     * Assignment operator
     */
    inline GetServerListErrorStructure& operator = (const GetServerListErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetServerListErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetServerListErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetServerListErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetServerListErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const GetServerListErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'GetServerList'
 * Error Message
 */
class GetServerListError  : public ::asf::core::Payload {
public:

    enum GetServerListErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetServerListError ();

   /**
     * Copy constructor
     */
    inline  GetServerListError (const GetServerListError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetServerListError();

    /**
     * Assigns a new value to this object.
     */
    inline GetServerListError& operator = (const GetServerListError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetServerListError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetServerListError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetServerListError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetServerListError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetServerListError::GetServerListErrorField getField () const;

    inline void setField(GetServerListError::GetServerListErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetServerListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetServerListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetServerListErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetServerListErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetServerListErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetServerListErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetServerListErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetServerListErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetServerListError &getDefaultInstance();

private:

    inline void cloneData (const GetServerListError& rhs);

    inline void deleteData ();

    GetServerListErrorField __field;

    union {
        GetServerListErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SelectServer"
 * This Method is called by HMI to select server for use.
 * Method start to send select server request to the fc_usb_tcu.
 */
class SelectServerStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SelectServerStart ();

    /**
     * Copy constructor
     */
    inline  SelectServerStart (const SelectServerStart &rhs);

    /**
     * All fields constructor
     */
    inline  SelectServerStart (uint8 u8ServerId_);

    /**
     * Destructor
     */
    inline virtual  ~SelectServerStart();

    /**
     * Assignment operator
     */
    inline SelectServerStart& operator = (const SelectServerStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SelectServerStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SelectServerStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SelectServerStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SelectServerStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8ServerId"

    static const int kU8ServerId = 0;

    /**
     * Clears the field "u8ServerId".
     *
     * The field will be set to its default value. The hasU8ServerId()
     * method will return false.
     */
    inline void clearU8ServerId();

    /**
     * Checks whether the field "u8ServerId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8ServerId()). Otherwise it will return false.
     */
    inline bool hasU8ServerId () const;

    /**
     * Returns the value of the member "u8ServerId".
     *
     * Selected server ID .
     *
     * @return The value of the field "u8ServerId"
     */
    inline uint8 getU8ServerId () const;

    /**
     * Sets the value of the member "u8ServerId".
     *
     * Selected server ID .
     *
     * @param u8ServerId The value which will be set
     */
    inline void setU8ServerId (uint8 u8ServerId_);

    static const SelectServerStart &getDefaultInstance();

private:

    inline void set_has_u8ServerId ();

    inline void clear_has_u8ServerId ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8ServerId;

};

/**
 * The error message of 'SelectServer'
 * Error Message
 */
class SelectServerErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SelectServerErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SelectServerErrorStructure (const SelectServerErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SelectServerErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~SelectServerErrorStructure();

    /**
     * Assignment operator
     */
    inline SelectServerErrorStructure& operator = (const SelectServerErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SelectServerErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SelectServerErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SelectServerErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SelectServerErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const SelectServerErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'SelectServer'
 * Error Message
 */
class SelectServerError  : public ::asf::core::Payload {
public:

    enum SelectServerErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SelectServerError ();

   /**
     * Copy constructor
     */
    inline  SelectServerError (const SelectServerError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SelectServerError();

    /**
     * Assigns a new value to this object.
     */
    inline SelectServerError& operator = (const SelectServerError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SelectServerError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SelectServerError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SelectServerError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SelectServerError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SelectServerError::SelectServerErrorField getField () const;

    inline void setField(SelectServerError::SelectServerErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SelectServerErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SelectServerErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SelectServerErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SelectServerErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SelectServerErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SelectServerErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SelectServerErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SelectServerErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SelectServerError &getDefaultInstance();

private:

    inline void cloneData (const SelectServerError& rhs);

    inline void deleteData ();

    SelectServerErrorField __field;

    union {
        SelectServerErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "RetryGetChannelData"
 * This Method is called by HMI to retry channel data download for IVM/MIS/MS.
 * Method start to send etry channel data to the fc_usb_tcu.
 */
class RetryGetChannelDataStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RetryGetChannelDataStart ();

    /**
     * Copy constructor
     */
    inline  RetryGetChannelDataStart (const RetryGetChannelDataStart &rhs);

    /**
     * All fields constructor
     */
    inline  RetryGetChannelDataStart (uint16 u16ChannelID_);

    /**
     * Destructor
     */
    inline virtual  ~RetryGetChannelDataStart();

    /**
     * Assignment operator
     */
    inline RetryGetChannelDataStart& operator = (const RetryGetChannelDataStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RetryGetChannelDataStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RetryGetChannelDataStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RetryGetChannelDataStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RetryGetChannelDataStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ChannelID"

    static const int kU16ChannelID = 0;

    /**
     * Clears the field "u16ChannelID".
     *
     * The field will be set to its default value. The hasU16ChannelID()
     * method will return false.
     */
    inline void clearU16ChannelID();

    /**
     * Checks whether the field "u16ChannelID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ChannelID()). Otherwise it will return false.
     */
    inline bool hasU16ChannelID () const;

    /**
     * Returns the value of the member "u16ChannelID".
     *
     * Channel ID.
     *
     * @return The value of the field "u16ChannelID"
     */
    inline uint16 getU16ChannelID () const;

    /**
     * Sets the value of the member "u16ChannelID".
     *
     * Channel ID.
     *
     * @param u16ChannelID The value which will be set
     */
    inline void setU16ChannelID (uint16 u16ChannelID_);

    static const RetryGetChannelDataStart &getDefaultInstance();

private:

    inline void set_has_u16ChannelID ();

    inline void clear_has_u16ChannelID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ChannelID;

};

/**
 * The error message of 'RetryGetChannelData'
 * Error Message
 */
class RetryGetChannelDataErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  RetryGetChannelDataErrorStructure ();

    /**
     * Copy constructor
     */
    inline  RetryGetChannelDataErrorStructure (const RetryGetChannelDataErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  RetryGetChannelDataErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~RetryGetChannelDataErrorStructure();

    /**
     * Assignment operator
     */
    inline RetryGetChannelDataErrorStructure& operator = (const RetryGetChannelDataErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RetryGetChannelDataErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RetryGetChannelDataErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RetryGetChannelDataErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RetryGetChannelDataErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const RetryGetChannelDataErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'RetryGetChannelData'
 * Error Message
 */
class RetryGetChannelDataError  : public ::asf::core::Payload {
public:

    enum RetryGetChannelDataErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  RetryGetChannelDataError ();

   /**
     * Copy constructor
     */
    inline  RetryGetChannelDataError (const RetryGetChannelDataError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~RetryGetChannelDataError();

    /**
     * Assigns a new value to this object.
     */
    inline RetryGetChannelDataError& operator = (const RetryGetChannelDataError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RetryGetChannelDataError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RetryGetChannelDataError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RetryGetChannelDataError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RetryGetChannelDataError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline RetryGetChannelDataError::RetryGetChannelDataErrorField getField () const;

    inline void setField(RetryGetChannelDataError::RetryGetChannelDataErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "RetryGetChannelDataErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "RetryGetChannelDataErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const RetryGetChannelDataErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline RetryGetChannelDataErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline RetryGetChannelDataErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (RetryGetChannelDataErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "RetryGetChannelDataErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const RetryGetChannelDataErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const RetryGetChannelDataError &getDefaultInstance();

private:

    inline void cloneData (const RetryGetChannelDataError& rhs);

    inline void deleteData ();

    RetryGetChannelDataErrorField __field;

    union {
        RetryGetChannelDataErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "OverwriteIVMTotalContents"
 * This Method is called by HMI to overwrite the TotalNumOfContents value of a IVM channel with StoredNumOfContents. This method is called when the user doesn't want to download pending contents.
 * Method start to send overwriting TotalNumOfContents request to the fc_usb_tcu.
 */
class OverwriteIVMTotalContentsStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  OverwriteIVMTotalContentsStart ();

    /**
     * Copy constructor
     */
    inline  OverwriteIVMTotalContentsStart (const OverwriteIVMTotalContentsStart &rhs);

    /**
     * All fields constructor
     */
    inline  OverwriteIVMTotalContentsStart (uint16 u16ChannelID_, int64 s64IndexInternal_);

    /**
     * Destructor
     */
    inline virtual  ~OverwriteIVMTotalContentsStart();

    /**
     * Assignment operator
     */
    inline OverwriteIVMTotalContentsStart& operator = (const OverwriteIVMTotalContentsStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const OverwriteIVMTotalContentsStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const OverwriteIVMTotalContentsStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const OverwriteIVMTotalContentsStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const OverwriteIVMTotalContentsStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ChannelID"

    static const int kU16ChannelID = 0;

    /**
     * Clears the field "u16ChannelID".
     *
     * The field will be set to its default value. The hasU16ChannelID()
     * method will return false.
     */
    inline void clearU16ChannelID();

    /**
     * Checks whether the field "u16ChannelID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ChannelID()). Otherwise it will return false.
     */
    inline bool hasU16ChannelID () const;

    /**
     * Returns the value of the member "u16ChannelID".
     *
     * Channel ID.
     *
     * @return The value of the field "u16ChannelID"
     */
    inline uint16 getU16ChannelID () const;

    /**
     * Sets the value of the member "u16ChannelID".
     *
     * Channel ID.
     *
     * @param u16ChannelID The value which will be set
     */
    inline void setU16ChannelID (uint16 u16ChannelID_);

    // API of field "s64IndexInternal"

    static const int kS64IndexInternal = 1;

    /**
     * Clears the field "s64IndexInternal".
     *
     * The field will be set to its default value. The hasS64IndexInternal()
     * method will return false.
     */
    inline void clearS64IndexInternal();

    /**
     * Checks whether the field "s64IndexInternal" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS64IndexInternal()). Otherwise it will return false.
     */
    inline bool hasS64IndexInternal () const;

    /**
     * Returns the value of the member "s64IndexInternal".
     *
     * IndexInternal to update a particular channel in IVM database.
     *
     * @return The value of the field "s64IndexInternal"
     */
    inline int64 getS64IndexInternal () const;

    /**
     * Sets the value of the member "s64IndexInternal".
     *
     * IndexInternal to update a particular channel in IVM database.
     *
     * @param s64IndexInternal The value which will be set
     */
    inline void setS64IndexInternal (int64 s64IndexInternal_);

    static const OverwriteIVMTotalContentsStart &getDefaultInstance();

private:

    inline void set_has_u16ChannelID ();

    inline void clear_has_u16ChannelID ();

    inline void set_has_s64IndexInternal ();

    inline void clear_has_s64IndexInternal ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _u16ChannelID;

    int64 _s64IndexInternal;

};

/**
 * The error message of 'OverwriteIVMTotalContents'
 * Error Message
 */
class OverwriteIVMTotalContentsErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  OverwriteIVMTotalContentsErrorStructure ();

    /**
     * Copy constructor
     */
    inline  OverwriteIVMTotalContentsErrorStructure (const OverwriteIVMTotalContentsErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  OverwriteIVMTotalContentsErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~OverwriteIVMTotalContentsErrorStructure();

    /**
     * Assignment operator
     */
    inline OverwriteIVMTotalContentsErrorStructure& operator = (const OverwriteIVMTotalContentsErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const OverwriteIVMTotalContentsErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const OverwriteIVMTotalContentsErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const OverwriteIVMTotalContentsErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const OverwriteIVMTotalContentsErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const OverwriteIVMTotalContentsErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'OverwriteIVMTotalContents'
 * Error Message
 */
class OverwriteIVMTotalContentsError  : public ::asf::core::Payload {
public:

    enum OverwriteIVMTotalContentsErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  OverwriteIVMTotalContentsError ();

   /**
     * Copy constructor
     */
    inline  OverwriteIVMTotalContentsError (const OverwriteIVMTotalContentsError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~OverwriteIVMTotalContentsError();

    /**
     * Assigns a new value to this object.
     */
    inline OverwriteIVMTotalContentsError& operator = (const OverwriteIVMTotalContentsError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const OverwriteIVMTotalContentsError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const OverwriteIVMTotalContentsError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const OverwriteIVMTotalContentsError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const OverwriteIVMTotalContentsError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline OverwriteIVMTotalContentsError::OverwriteIVMTotalContentsErrorField getField () const;

    inline void setField(OverwriteIVMTotalContentsError::OverwriteIVMTotalContentsErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "OverwriteIVMTotalContentsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "OverwriteIVMTotalContentsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const OverwriteIVMTotalContentsErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline OverwriteIVMTotalContentsErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline OverwriteIVMTotalContentsErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (OverwriteIVMTotalContentsErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "OverwriteIVMTotalContentsErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const OverwriteIVMTotalContentsErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const OverwriteIVMTotalContentsError &getDefaultInstance();

private:

    inline void cloneData (const OverwriteIVMTotalContentsError& rhs);

    inline void deleteData ();

    OverwriteIVMTotalContentsErrorField __field;

    union {
        OverwriteIVMTotalContentsErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "StoreCSHistory"
 * This Method is called by HMI to write CS keyword to DB.
 * Method start to send writing CS keyword request to the fc_usb_tcu.
 */
class StoreCSHistoryStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StoreCSHistoryStart ();

    /**
     * Copy constructor
     */
    inline  StoreCSHistoryStart (const StoreCSHistoryStart &rhs);

    /**
     * All fields constructor
     */
    inline  StoreCSHistoryStart (const ::std::string& strKeyWord_);

    /**
     * Destructor
     */
    inline virtual  ~StoreCSHistoryStart();

    /**
     * Assignment operator
     */
    inline StoreCSHistoryStart& operator = (const StoreCSHistoryStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StoreCSHistoryStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StoreCSHistoryStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StoreCSHistoryStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StoreCSHistoryStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "strKeyWord"

    static const int kStrKeyWord = 0;

    /**
     * Clears the field "strKeyWord".
     *
     * The field will be set to its default value. The hasStrKeyWord()
     * method will return false.
     */
    inline void clearStrKeyWord();

    /**
     * Checks whether the field "strKeyWord" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrKeyWord()). Otherwise it will return false.
     */
    inline bool hasStrKeyWord () const;

    /**
     * Returns the value of the member "strKeyWord".
     *
     * The searched keyword.
     *
     * @return The value of the field "strKeyWord"
     */
    inline const ::std::string& getStrKeyWord () const;

    /**
     * Retrieves the value of the field "strKeyWord" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strKeyWord".
     */
    inline ::std::string& getStrKeyWordMutable ();

    /**
     * Sets the value of the member "strKeyWord".
     *
     * The searched keyword.
     *
     * @param strKeyWord The value which will be set
     */
    inline void setStrKeyWord (const ::std::string& strKeyWord_);

    /**
     * Sets the value of the member "strKeyWord".
     *
     * The searched keyword.
     *
     * @param strKeyWord The value which will be set
     */
    inline void setStrKeyWord (const char* strKeyWord_);

    /**
     * Sets the value of the member "strKeyWord".
     *
     * The searched keyword.
     *
     * @param strKeyWord The value which will be set
     */
    inline void setStrKeyWord (const char* value, size_t size);

    static const StoreCSHistoryStart &getDefaultInstance();

private:

    inline void set_has_strKeyWord ();

    inline void clear_has_strKeyWord ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _strKeyWord;

};

/**
 * The error message of 'StoreCSHistory'
 * Error Message
 */
class StoreCSHistoryErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  StoreCSHistoryErrorStructure ();

    /**
     * Copy constructor
     */
    inline  StoreCSHistoryErrorStructure (const StoreCSHistoryErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  StoreCSHistoryErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~StoreCSHistoryErrorStructure();

    /**
     * Assignment operator
     */
    inline StoreCSHistoryErrorStructure& operator = (const StoreCSHistoryErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StoreCSHistoryErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StoreCSHistoryErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StoreCSHistoryErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StoreCSHistoryErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const StoreCSHistoryErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'StoreCSHistory'
 * Error Message
 */
class StoreCSHistoryError  : public ::asf::core::Payload {
public:

    enum StoreCSHistoryErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  StoreCSHistoryError ();

   /**
     * Copy constructor
     */
    inline  StoreCSHistoryError (const StoreCSHistoryError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~StoreCSHistoryError();

    /**
     * Assigns a new value to this object.
     */
    inline StoreCSHistoryError& operator = (const StoreCSHistoryError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StoreCSHistoryError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StoreCSHistoryError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StoreCSHistoryError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StoreCSHistoryError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline StoreCSHistoryError::StoreCSHistoryErrorField getField () const;

    inline void setField(StoreCSHistoryError::StoreCSHistoryErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "StoreCSHistoryErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "StoreCSHistoryErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const StoreCSHistoryErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline StoreCSHistoryErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline StoreCSHistoryErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (StoreCSHistoryErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "StoreCSHistoryErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const StoreCSHistoryErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const StoreCSHistoryError &getDefaultInstance();

private:

    inline void cloneData (const StoreCSHistoryError& rhs);

    inline void deleteData ();

    StoreCSHistoryErrorField __field;

    union {
        StoreCSHistoryErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The error message of 'GetTCUDeviceInfo'
 * Error Message
 */
class GetTCUDeviceInfoErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetTCUDeviceInfoErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetTCUDeviceInfoErrorStructure (const GetTCUDeviceInfoErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetTCUDeviceInfoErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~GetTCUDeviceInfoErrorStructure();

    /**
     * Assignment operator
     */
    inline GetTCUDeviceInfoErrorStructure& operator = (const GetTCUDeviceInfoErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetTCUDeviceInfoErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetTCUDeviceInfoErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetTCUDeviceInfoErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetTCUDeviceInfoErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const GetTCUDeviceInfoErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'GetTCUDeviceInfo'
 * Error Message
 */
class GetTCUDeviceInfoError  : public ::asf::core::Payload {
public:

    enum GetTCUDeviceInfoErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetTCUDeviceInfoError ();

   /**
     * Copy constructor
     */
    inline  GetTCUDeviceInfoError (const GetTCUDeviceInfoError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetTCUDeviceInfoError();

    /**
     * Assigns a new value to this object.
     */
    inline GetTCUDeviceInfoError& operator = (const GetTCUDeviceInfoError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetTCUDeviceInfoError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetTCUDeviceInfoError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetTCUDeviceInfoError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetTCUDeviceInfoError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetTCUDeviceInfoError::GetTCUDeviceInfoErrorField getField () const;

    inline void setField(GetTCUDeviceInfoError::GetTCUDeviceInfoErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetTCUDeviceInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetTCUDeviceInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetTCUDeviceInfoErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetTCUDeviceInfoErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetTCUDeviceInfoErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetTCUDeviceInfoErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetTCUDeviceInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetTCUDeviceInfoErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetTCUDeviceInfoError &getDefaultInstance();

private:

    inline void cloneData (const GetTCUDeviceInfoError& rhs);

    inline void deleteData ();

    GetTCUDeviceInfoErrorField __field;

    union {
        GetTCUDeviceInfoErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SetLogLevel"
 * This Method is called by HMI to set Log level.
 */
class SetLogLevelStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetLogLevelStart ();

    /**
     * Copy constructor
     */
    inline  SetLogLevelStart (const SetLogLevelStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetLogLevelStart (::tcu_usb_main_fi_types::T_e8_tcu_LogLevel u8LogLevel_);

    /**
     * Destructor
     */
    inline virtual  ~SetLogLevelStart();

    /**
     * Assignment operator
     */
    inline SetLogLevelStart& operator = (const SetLogLevelStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetLogLevelStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetLogLevelStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetLogLevelStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetLogLevelStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8LogLevel"

    static const int kU8LogLevel = 0;

    /**
     * Clears the field "u8LogLevel".
     *
     * The field will be set to its default value. The hasU8LogLevel()
     * method will return false.
     */
    inline void clearU8LogLevel();

    /**
     * Checks whether the field "u8LogLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8LogLevel()). Otherwise it will return false.
     */
    inline bool hasU8LogLevel () const;

    /**
     * Returns the value of the member "u8LogLevel".
     *
     * Log level.
     *
     * @return The value of the field "u8LogLevel"
     */
    inline ::tcu_usb_main_fi_types::T_e8_tcu_LogLevel getU8LogLevel () const;

    /**
     * Sets the value of the member "u8LogLevel".
     *
     * Log level.
     *
     * @param u8LogLevel The value which will be set
     */
    inline void setU8LogLevel (::tcu_usb_main_fi_types::T_e8_tcu_LogLevel u8LogLevel_);

    static const SetLogLevelStart &getDefaultInstance();

private:

    inline void set_has_u8LogLevel ();

    inline void clear_has_u8LogLevel ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_usb_main_fi_types::T_e8_tcu_LogLevel _u8LogLevel;

};

/**
 * The error message of 'SetLogLevel'
 * Error Message
 */
class SetLogLevelErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetLogLevelErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetLogLevelErrorStructure (const SetLogLevelErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetLogLevelErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~SetLogLevelErrorStructure();

    /**
     * Assignment operator
     */
    inline SetLogLevelErrorStructure& operator = (const SetLogLevelErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetLogLevelErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetLogLevelErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetLogLevelErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetLogLevelErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const SetLogLevelErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'SetLogLevel'
 * Error Message
 */
class SetLogLevelError  : public ::asf::core::Payload {
public:

    enum SetLogLevelErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetLogLevelError ();

   /**
     * Copy constructor
     */
    inline  SetLogLevelError (const SetLogLevelError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetLogLevelError();

    /**
     * Assigns a new value to this object.
     */
    inline SetLogLevelError& operator = (const SetLogLevelError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetLogLevelError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetLogLevelError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetLogLevelError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetLogLevelError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetLogLevelError::SetLogLevelErrorField getField () const;

    inline void setField(SetLogLevelError::SetLogLevelErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetLogLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetLogLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetLogLevelErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetLogLevelErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetLogLevelErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetLogLevelErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetLogLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetLogLevelErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetLogLevelError &getDefaultInstance();

private:

    inline void cloneData (const SetLogLevelError& rhs);

    inline void deleteData ();

    SetLogLevelErrorField __field;

    union {
        SetLogLevelErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The error message of 'RestoreFactorySettings'
 * Error Message
 */
class RestoreFactorySettingsErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  RestoreFactorySettingsErrorStructure ();

    /**
     * Copy constructor
     */
    inline  RestoreFactorySettingsErrorStructure (const RestoreFactorySettingsErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  RestoreFactorySettingsErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~RestoreFactorySettingsErrorStructure();

    /**
     * Assignment operator
     */
    inline RestoreFactorySettingsErrorStructure& operator = (const RestoreFactorySettingsErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RestoreFactorySettingsErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RestoreFactorySettingsErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RestoreFactorySettingsErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RestoreFactorySettingsErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const RestoreFactorySettingsErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'RestoreFactorySettings'
 * Error Message
 */
class RestoreFactorySettingsError  : public ::asf::core::Payload {
public:

    enum RestoreFactorySettingsErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  RestoreFactorySettingsError ();

   /**
     * Copy constructor
     */
    inline  RestoreFactorySettingsError (const RestoreFactorySettingsError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~RestoreFactorySettingsError();

    /**
     * Assigns a new value to this object.
     */
    inline RestoreFactorySettingsError& operator = (const RestoreFactorySettingsError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RestoreFactorySettingsError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RestoreFactorySettingsError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RestoreFactorySettingsError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RestoreFactorySettingsError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline RestoreFactorySettingsError::RestoreFactorySettingsErrorField getField () const;

    inline void setField(RestoreFactorySettingsError::RestoreFactorySettingsErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "RestoreFactorySettingsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "RestoreFactorySettingsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const RestoreFactorySettingsErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline RestoreFactorySettingsErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline RestoreFactorySettingsErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (RestoreFactorySettingsErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "RestoreFactorySettingsErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const RestoreFactorySettingsErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const RestoreFactorySettingsError &getDefaultInstance();

private:

    inline void cloneData (const RestoreFactorySettingsError& rhs);

    inline void deleteData ();

    RestoreFactorySettingsErrorField __field;

    union {
        RestoreFactorySettingsErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The error message of 'DeleteMessageBox'
 * Error Message
 */
class DeleteMessageBoxErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DeleteMessageBoxErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DeleteMessageBoxErrorStructure (const DeleteMessageBoxErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DeleteMessageBoxErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~DeleteMessageBoxErrorStructure();

    /**
     * Assignment operator
     */
    inline DeleteMessageBoxErrorStructure& operator = (const DeleteMessageBoxErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeleteMessageBoxErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeleteMessageBoxErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeleteMessageBoxErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeleteMessageBoxErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const DeleteMessageBoxErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'DeleteMessageBox'
 * Error Message
 */
class DeleteMessageBoxError  : public ::asf::core::Payload {
public:

    enum DeleteMessageBoxErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DeleteMessageBoxError ();

   /**
     * Copy constructor
     */
    inline  DeleteMessageBoxError (const DeleteMessageBoxError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DeleteMessageBoxError();

    /**
     * Assigns a new value to this object.
     */
    inline DeleteMessageBoxError& operator = (const DeleteMessageBoxError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeleteMessageBoxError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeleteMessageBoxError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeleteMessageBoxError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeleteMessageBoxError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DeleteMessageBoxError::DeleteMessageBoxErrorField getField () const;

    inline void setField(DeleteMessageBoxError::DeleteMessageBoxErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DeleteMessageBoxErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DeleteMessageBoxErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DeleteMessageBoxErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DeleteMessageBoxErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DeleteMessageBoxErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DeleteMessageBoxErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DeleteMessageBoxErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DeleteMessageBoxErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DeleteMessageBoxError &getDefaultInstance();

private:

    inline void cloneData (const DeleteMessageBoxError& rhs);

    inline void deleteData ();

    DeleteMessageBoxErrorField __field;

    union {
        DeleteMessageBoxErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The error message of 'InitializeFeedList'
 * Error Message
 */
class InitializeFeedListErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  InitializeFeedListErrorStructure ();

    /**
     * Copy constructor
     */
    inline  InitializeFeedListErrorStructure (const InitializeFeedListErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  InitializeFeedListErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~InitializeFeedListErrorStructure();

    /**
     * Assignment operator
     */
    inline InitializeFeedListErrorStructure& operator = (const InitializeFeedListErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const InitializeFeedListErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const InitializeFeedListErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const InitializeFeedListErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const InitializeFeedListErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const InitializeFeedListErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'InitializeFeedList'
 * Error Message
 */
class InitializeFeedListError  : public ::asf::core::Payload {
public:

    enum InitializeFeedListErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  InitializeFeedListError ();

   /**
     * Copy constructor
     */
    inline  InitializeFeedListError (const InitializeFeedListError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~InitializeFeedListError();

    /**
     * Assigns a new value to this object.
     */
    inline InitializeFeedListError& operator = (const InitializeFeedListError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const InitializeFeedListError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const InitializeFeedListError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const InitializeFeedListError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const InitializeFeedListError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline InitializeFeedListError::InitializeFeedListErrorField getField () const;

    inline void setField(InitializeFeedListError::InitializeFeedListErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "InitializeFeedListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "InitializeFeedListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const InitializeFeedListErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline InitializeFeedListErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline InitializeFeedListErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (InitializeFeedListErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "InitializeFeedListErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const InitializeFeedListErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const InitializeFeedListError &getDefaultInstance();

private:

    inline void cloneData (const InitializeFeedListError& rhs);

    inline void deleteData ();

    InitializeFeedListErrorField __field;

    union {
        InitializeFeedListErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SetAutoDownloadInterval"
 * This Method is called by HMI to Set AutoDownload Interval.
 * Method start to set AutoDownload Interval in the fc_usb_tcu.
 */
class SetAutoDownloadIntervalStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetAutoDownloadIntervalStart ();

    /**
     * Copy constructor
     */
    inline  SetAutoDownloadIntervalStart (const SetAutoDownloadIntervalStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetAutoDownloadIntervalStart (::tcu_usb_main_fi_types::T_e8_AutoDownloadInterval AutoDownloadInterval_);

    /**
     * Destructor
     */
    inline virtual  ~SetAutoDownloadIntervalStart();

    /**
     * Assignment operator
     */
    inline SetAutoDownloadIntervalStart& operator = (const SetAutoDownloadIntervalStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetAutoDownloadIntervalStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetAutoDownloadIntervalStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetAutoDownloadIntervalStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetAutoDownloadIntervalStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AutoDownloadInterval"

    static const int kAutoDownloadInterval = 0;

    /**
     * Clears the field "AutoDownloadInterval".
     *
     * The field will be set to its default value. The hasAutoDownloadInterval()
     * method will return false.
     */
    inline void clearAutoDownloadInterval();

    /**
     * Checks whether the field "AutoDownloadInterval" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAutoDownloadInterval()). Otherwise it will return false.
     */
    inline bool hasAutoDownloadInterval () const;

    /**
     * Returns the value of the member "AutoDownloadInterval".
     *
     * AutoDownload Interval options
     *
     * @return The value of the field "AutoDownloadInterval"
     */
    inline ::tcu_usb_main_fi_types::T_e8_AutoDownloadInterval getAutoDownloadInterval () const;

    /**
     * Sets the value of the member "AutoDownloadInterval".
     *
     * AutoDownload Interval options
     *
     * @param AutoDownloadInterval The value which will be set
     */
    inline void setAutoDownloadInterval (::tcu_usb_main_fi_types::T_e8_AutoDownloadInterval AutoDownloadInterval_);

    static const SetAutoDownloadIntervalStart &getDefaultInstance();

private:

    inline void set_has_AutoDownloadInterval ();

    inline void clear_has_AutoDownloadInterval ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_usb_main_fi_types::T_e8_AutoDownloadInterval _AutoDownloadInterval;

};

/**
 * The error message of 'SetAutoDownloadInterval'
 * Error Message
 */
class SetAutoDownloadIntervalErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetAutoDownloadIntervalErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetAutoDownloadIntervalErrorStructure (const SetAutoDownloadIntervalErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetAutoDownloadIntervalErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~SetAutoDownloadIntervalErrorStructure();

    /**
     * Assignment operator
     */
    inline SetAutoDownloadIntervalErrorStructure& operator = (const SetAutoDownloadIntervalErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetAutoDownloadIntervalErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetAutoDownloadIntervalErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetAutoDownloadIntervalErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetAutoDownloadIntervalErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const SetAutoDownloadIntervalErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'SetAutoDownloadInterval'
 * Error Message
 */
class SetAutoDownloadIntervalError  : public ::asf::core::Payload {
public:

    enum SetAutoDownloadIntervalErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetAutoDownloadIntervalError ();

   /**
     * Copy constructor
     */
    inline  SetAutoDownloadIntervalError (const SetAutoDownloadIntervalError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetAutoDownloadIntervalError();

    /**
     * Assigns a new value to this object.
     */
    inline SetAutoDownloadIntervalError& operator = (const SetAutoDownloadIntervalError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetAutoDownloadIntervalError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetAutoDownloadIntervalError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetAutoDownloadIntervalError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetAutoDownloadIntervalError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetAutoDownloadIntervalError::SetAutoDownloadIntervalErrorField getField () const;

    inline void setField(SetAutoDownloadIntervalError::SetAutoDownloadIntervalErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetAutoDownloadIntervalErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetAutoDownloadIntervalErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetAutoDownloadIntervalErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetAutoDownloadIntervalErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetAutoDownloadIntervalErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetAutoDownloadIntervalErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetAutoDownloadIntervalErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetAutoDownloadIntervalErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetAutoDownloadIntervalError &getDefaultInstance();

private:

    inline void cloneData (const SetAutoDownloadIntervalError& rhs);

    inline void deleteData ();

    SetAutoDownloadIntervalErrorField __field;

    union {
        SetAutoDownloadIntervalErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The error message of 'GetAutoDownloadInterval'
 * Error Message
 */
class GetAutoDownloadIntervalErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetAutoDownloadIntervalErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetAutoDownloadIntervalErrorStructure (const GetAutoDownloadIntervalErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetAutoDownloadIntervalErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~GetAutoDownloadIntervalErrorStructure();

    /**
     * Assignment operator
     */
    inline GetAutoDownloadIntervalErrorStructure& operator = (const GetAutoDownloadIntervalErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetAutoDownloadIntervalErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetAutoDownloadIntervalErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetAutoDownloadIntervalErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetAutoDownloadIntervalErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const GetAutoDownloadIntervalErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'GetAutoDownloadInterval'
 * Error Message
 */
class GetAutoDownloadIntervalError  : public ::asf::core::Payload {
public:

    enum GetAutoDownloadIntervalErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetAutoDownloadIntervalError ();

   /**
     * Copy constructor
     */
    inline  GetAutoDownloadIntervalError (const GetAutoDownloadIntervalError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetAutoDownloadIntervalError();

    /**
     * Assigns a new value to this object.
     */
    inline GetAutoDownloadIntervalError& operator = (const GetAutoDownloadIntervalError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetAutoDownloadIntervalError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetAutoDownloadIntervalError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetAutoDownloadIntervalError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetAutoDownloadIntervalError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetAutoDownloadIntervalError::GetAutoDownloadIntervalErrorField getField () const;

    inline void setField(GetAutoDownloadIntervalError::GetAutoDownloadIntervalErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetAutoDownloadIntervalErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetAutoDownloadIntervalErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetAutoDownloadIntervalErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetAutoDownloadIntervalErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetAutoDownloadIntervalErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetAutoDownloadIntervalErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetAutoDownloadIntervalErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetAutoDownloadIntervalErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetAutoDownloadIntervalError &getDefaultInstance();

private:

    inline void cloneData (const GetAutoDownloadIntervalError& rhs);

    inline void deleteData ();

    GetAutoDownloadIntervalErrorField __field;

    union {
        GetAutoDownloadIntervalErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SetAutoDownloadChannel"
 * This Method is called by HMI to Set AutoDownload Channel.
 * Method start to set AutoDownload Channel in the fc_usb_tcu.
 */
class SetAutoDownloadChannelStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetAutoDownloadChannelStart ();

    /**
     * Copy constructor
     */
    inline  SetAutoDownloadChannelStart (const SetAutoDownloadChannelStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetAutoDownloadChannelStart (const ::tcu_usb_main_fi_types::T_usb_tcu_Channel_Info_List& Channel_Info_List_);

    /**
     * Destructor
     */
    inline virtual  ~SetAutoDownloadChannelStart();

    /**
     * Assignment operator
     */
    inline SetAutoDownloadChannelStart& operator = (const SetAutoDownloadChannelStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetAutoDownloadChannelStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetAutoDownloadChannelStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetAutoDownloadChannelStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetAutoDownloadChannelStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Channel_Info_List"

    static const int kChannel_Info_List = 0;

    /**
     * Clears the field "Channel_Info_List".
     *
     * The field will be set to its default value. The hasChannel_Info_List()
     * method will return false.
     */
    inline void clearChannel_Info_List();

    /**
     * Checks whether the field "Channel_Info_List" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannel_Info_List()). Otherwise it will return false.
     */
    inline bool hasChannel_Info_List () const;

    /**
     * Returns the value of the member "Channel_Info_List".
     *
     * Fill Channel IDs in the list for AutoDownload
     *
     * @return The value of the field "Channel_Info_List"
     */
    inline const ::tcu_usb_main_fi_types::T_usb_tcu_Channel_Info_List& getChannel_Info_List () const;

    /**
     * Retrieves the value of the field "Channel_Info_List" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Channel_Info_List".
     */
    inline ::tcu_usb_main_fi_types::T_usb_tcu_Channel_Info_List& getChannel_Info_ListMutable ();

    /**
     * Sets the value of the member "Channel_Info_List".
     *
     * Fill Channel IDs in the list for AutoDownload
     *
     * @param Channel_Info_List The value which will be set
     */
    inline void setChannel_Info_List (const ::tcu_usb_main_fi_types::T_usb_tcu_Channel_Info_List& Channel_Info_List_);

    static const SetAutoDownloadChannelStart &getDefaultInstance();

private:

    static const ::std::vector< ::tcu_usb_main_fi_types::T_usb_tcu_Channel_Info >& getT_usb_tcu_Channel_InfoList_DefaultInstance ();

    inline void set_has_Channel_Info_List ();

    inline void clear_has_Channel_Info_List ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_usb_main_fi_types::T_usb_tcu_Channel_Info_List _Channel_Info_List;

};

/**
 * The error message of 'SetAutoDownloadChannel'
 * Error Message
 */
class SetAutoDownloadChannelErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetAutoDownloadChannelErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetAutoDownloadChannelErrorStructure (const SetAutoDownloadChannelErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetAutoDownloadChannelErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~SetAutoDownloadChannelErrorStructure();

    /**
     * Assignment operator
     */
    inline SetAutoDownloadChannelErrorStructure& operator = (const SetAutoDownloadChannelErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetAutoDownloadChannelErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetAutoDownloadChannelErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetAutoDownloadChannelErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetAutoDownloadChannelErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const SetAutoDownloadChannelErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'SetAutoDownloadChannel'
 * Error Message
 */
class SetAutoDownloadChannelError  : public ::asf::core::Payload {
public:

    enum SetAutoDownloadChannelErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetAutoDownloadChannelError ();

   /**
     * Copy constructor
     */
    inline  SetAutoDownloadChannelError (const SetAutoDownloadChannelError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetAutoDownloadChannelError();

    /**
     * Assigns a new value to this object.
     */
    inline SetAutoDownloadChannelError& operator = (const SetAutoDownloadChannelError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetAutoDownloadChannelError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetAutoDownloadChannelError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetAutoDownloadChannelError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetAutoDownloadChannelError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetAutoDownloadChannelError::SetAutoDownloadChannelErrorField getField () const;

    inline void setField(SetAutoDownloadChannelError::SetAutoDownloadChannelErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetAutoDownloadChannelErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetAutoDownloadChannelErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetAutoDownloadChannelErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetAutoDownloadChannelErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetAutoDownloadChannelErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetAutoDownloadChannelErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetAutoDownloadChannelErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetAutoDownloadChannelErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetAutoDownloadChannelError &getDefaultInstance();

private:

    inline void cloneData (const SetAutoDownloadChannelError& rhs);

    inline void deleteData ();

    SetAutoDownloadChannelErrorField __field;

    union {
        SetAutoDownloadChannelErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The error message of 'GetFavoriteChannelList'
 * Error Message
 */
class GetFavoriteChannelListErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetFavoriteChannelListErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetFavoriteChannelListErrorStructure (const GetFavoriteChannelListErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetFavoriteChannelListErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~GetFavoriteChannelListErrorStructure();

    /**
     * Assignment operator
     */
    inline GetFavoriteChannelListErrorStructure& operator = (const GetFavoriteChannelListErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetFavoriteChannelListErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetFavoriteChannelListErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetFavoriteChannelListErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetFavoriteChannelListErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const GetFavoriteChannelListErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'GetFavoriteChannelList'
 * Error Message
 */
class GetFavoriteChannelListError  : public ::asf::core::Payload {
public:

    enum GetFavoriteChannelListErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetFavoriteChannelListError ();

   /**
     * Copy constructor
     */
    inline  GetFavoriteChannelListError (const GetFavoriteChannelListError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetFavoriteChannelListError();

    /**
     * Assigns a new value to this object.
     */
    inline GetFavoriteChannelListError& operator = (const GetFavoriteChannelListError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetFavoriteChannelListError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetFavoriteChannelListError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetFavoriteChannelListError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetFavoriteChannelListError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetFavoriteChannelListError::GetFavoriteChannelListErrorField getField () const;

    inline void setField(GetFavoriteChannelListError::GetFavoriteChannelListErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetFavoriteChannelListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetFavoriteChannelListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetFavoriteChannelListErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetFavoriteChannelListErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetFavoriteChannelListErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetFavoriteChannelListErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetFavoriteChannelListErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetFavoriteChannelListErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetFavoriteChannelListError &getDefaultInstance();

private:

    inline void cloneData (const GetFavoriteChannelListError& rhs);

    inline void deleteData ();

    GetFavoriteChannelListErrorField __field;

    union {
        GetFavoriteChannelListErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SetFavoriteChannel"
 * This Method is called by HMI to Set favorite Channel.
 * Method start to set favorite Channel in the fc_usb_tcu.
 */
class SetFavoriteChannelStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetFavoriteChannelStart ();

    /**
     * Copy constructor
     */
    inline  SetFavoriteChannelStart (const SetFavoriteChannelStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetFavoriteChannelStart (const ::tcu_usb_main_fi_types::T_usb_tcu_Channel_Info_List& Channel_Info_List_);

    /**
     * Destructor
     */
    inline virtual  ~SetFavoriteChannelStart();

    /**
     * Assignment operator
     */
    inline SetFavoriteChannelStart& operator = (const SetFavoriteChannelStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetFavoriteChannelStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetFavoriteChannelStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetFavoriteChannelStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetFavoriteChannelStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Channel_Info_List"

    static const int kChannel_Info_List = 0;

    /**
     * Clears the field "Channel_Info_List".
     *
     * The field will be set to its default value. The hasChannel_Info_List()
     * method will return false.
     */
    inline void clearChannel_Info_List();

    /**
     * Checks whether the field "Channel_Info_List" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannel_Info_List()). Otherwise it will return false.
     */
    inline bool hasChannel_Info_List () const;

    /**
     * Returns the value of the member "Channel_Info_List".
     *
     * Fill Channel IDs in the list for favorite
     *
     * @return The value of the field "Channel_Info_List"
     */
    inline const ::tcu_usb_main_fi_types::T_usb_tcu_Channel_Info_List& getChannel_Info_List () const;

    /**
     * Retrieves the value of the field "Channel_Info_List" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Channel_Info_List".
     */
    inline ::tcu_usb_main_fi_types::T_usb_tcu_Channel_Info_List& getChannel_Info_ListMutable ();

    /**
     * Sets the value of the member "Channel_Info_List".
     *
     * Fill Channel IDs in the list for favorite
     *
     * @param Channel_Info_List The value which will be set
     */
    inline void setChannel_Info_List (const ::tcu_usb_main_fi_types::T_usb_tcu_Channel_Info_List& Channel_Info_List_);

    static const SetFavoriteChannelStart &getDefaultInstance();

private:

    static const ::std::vector< ::tcu_usb_main_fi_types::T_usb_tcu_Channel_Info >& getT_usb_tcu_Channel_InfoList_DefaultInstance ();

    inline void set_has_Channel_Info_List ();

    inline void clear_has_Channel_Info_List ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_usb_main_fi_types::T_usb_tcu_Channel_Info_List _Channel_Info_List;

};

/**
 * The error message of 'SetFavoriteChannel'
 * Error Message
 */
class SetFavoriteChannelErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetFavoriteChannelErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetFavoriteChannelErrorStructure (const SetFavoriteChannelErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetFavoriteChannelErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~SetFavoriteChannelErrorStructure();

    /**
     * Assignment operator
     */
    inline SetFavoriteChannelErrorStructure& operator = (const SetFavoriteChannelErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetFavoriteChannelErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetFavoriteChannelErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetFavoriteChannelErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetFavoriteChannelErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const SetFavoriteChannelErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'SetFavoriteChannel'
 * Error Message
 */
class SetFavoriteChannelError  : public ::asf::core::Payload {
public:

    enum SetFavoriteChannelErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetFavoriteChannelError ();

   /**
     * Copy constructor
     */
    inline  SetFavoriteChannelError (const SetFavoriteChannelError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetFavoriteChannelError();

    /**
     * Assigns a new value to this object.
     */
    inline SetFavoriteChannelError& operator = (const SetFavoriteChannelError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetFavoriteChannelError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetFavoriteChannelError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetFavoriteChannelError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetFavoriteChannelError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetFavoriteChannelError::SetFavoriteChannelErrorField getField () const;

    inline void setField(SetFavoriteChannelError::SetFavoriteChannelErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetFavoriteChannelErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetFavoriteChannelErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetFavoriteChannelErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetFavoriteChannelErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetFavoriteChannelErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetFavoriteChannelErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetFavoriteChannelErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetFavoriteChannelErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetFavoriteChannelError &getDefaultInstance();

private:

    inline void cloneData (const SetFavoriteChannelError& rhs);

    inline void deleteData ();

    SetFavoriteChannelErrorField __field;

    union {
        SetFavoriteChannelErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The result message of the method "ReadFavoriteFeeds"
 * This Method is called by SDS (or any other module) to read favorite feeds that are stored in database.
 * Method result to send the favorite feeds to SDS (or any other module).
 */
class ReadFavoriteFeedsResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReadFavoriteFeedsResult ();

    /**
     * Copy constructor
     */
    inline  ReadFavoriteFeedsResult (const ReadFavoriteFeedsResult &rhs);

    /**
     * All fields constructor
     */
    inline  ReadFavoriteFeedsResult (const ::tcu_usb_main_fi_types::T_usb_tcu_Favorite_Feed_List& Favorite_Feed_List_);

    /**
     * Destructor
     */
    inline virtual  ~ReadFavoriteFeedsResult();

    /**
     * Assignment operator
     */
    inline ReadFavoriteFeedsResult& operator = (const ReadFavoriteFeedsResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReadFavoriteFeedsResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReadFavoriteFeedsResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReadFavoriteFeedsResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReadFavoriteFeedsResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Favorite_Feed_List"

    static const int kFavorite_Feed_List = 0;

    /**
     * Clears the field "Favorite_Feed_List".
     *
     * The field will be set to its default value. The hasFavorite_Feed_List()
     * method will return false.
     */
    inline void clearFavorite_Feed_List();

    /**
     * Checks whether the field "Favorite_Feed_List" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFavorite_Feed_List()). Otherwise it will return false.
     */
    inline bool hasFavorite_Feed_List () const;

    /**
     * Returns the value of the member "Favorite_Feed_List".
     *
     * Contains favorite feeds list
     *
     * @return The value of the field "Favorite_Feed_List"
     */
    inline const ::tcu_usb_main_fi_types::T_usb_tcu_Favorite_Feed_List& getFavorite_Feed_List () const;

    /**
     * Retrieves the value of the field "Favorite_Feed_List" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Favorite_Feed_List".
     */
    inline ::tcu_usb_main_fi_types::T_usb_tcu_Favorite_Feed_List& getFavorite_Feed_ListMutable ();

    /**
     * Sets the value of the member "Favorite_Feed_List".
     *
     * Contains favorite feeds list
     *
     * @param Favorite_Feed_List The value which will be set
     */
    inline void setFavorite_Feed_List (const ::tcu_usb_main_fi_types::T_usb_tcu_Favorite_Feed_List& Favorite_Feed_List_);

    static const ReadFavoriteFeedsResult &getDefaultInstance();

private:

    static const ::std::vector< ::tcu_usb_main_fi_types::T_usb_tcu_Favorite_channel_info >& getT_usb_tcu_Favorite_channel_infoList_DefaultInstance ();

    inline void set_has_Favorite_Feed_List ();

    inline void clear_has_Favorite_Feed_List ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_usb_main_fi_types::T_usb_tcu_Favorite_Feed_List _Favorite_Feed_List;

};

/**
 * The error message of 'ReadFavoriteFeeds'
 * Error Message
 */
class ReadFavoriteFeedsErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  ReadFavoriteFeedsErrorStructure ();

    /**
     * Copy constructor
     */
    inline  ReadFavoriteFeedsErrorStructure (const ReadFavoriteFeedsErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  ReadFavoriteFeedsErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~ReadFavoriteFeedsErrorStructure();

    /**
     * Assignment operator
     */
    inline ReadFavoriteFeedsErrorStructure& operator = (const ReadFavoriteFeedsErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReadFavoriteFeedsErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReadFavoriteFeedsErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReadFavoriteFeedsErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReadFavoriteFeedsErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const ReadFavoriteFeedsErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'ReadFavoriteFeeds'
 * Error Message
 */
class ReadFavoriteFeedsError  : public ::asf::core::Payload {
public:

    enum ReadFavoriteFeedsErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  ReadFavoriteFeedsError ();

   /**
     * Copy constructor
     */
    inline  ReadFavoriteFeedsError (const ReadFavoriteFeedsError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~ReadFavoriteFeedsError();

    /**
     * Assigns a new value to this object.
     */
    inline ReadFavoriteFeedsError& operator = (const ReadFavoriteFeedsError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReadFavoriteFeedsError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReadFavoriteFeedsError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReadFavoriteFeedsError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReadFavoriteFeedsError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline ReadFavoriteFeedsError::ReadFavoriteFeedsErrorField getField () const;

    inline void setField(ReadFavoriteFeedsError::ReadFavoriteFeedsErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "ReadFavoriteFeedsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "ReadFavoriteFeedsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ReadFavoriteFeedsErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ReadFavoriteFeedsErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline ReadFavoriteFeedsErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (ReadFavoriteFeedsErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "ReadFavoriteFeedsErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const ReadFavoriteFeedsErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const ReadFavoriteFeedsError &getDefaultInstance();

private:

    inline void cloneData (const ReadFavoriteFeedsError& rhs);

    inline void deleteData ();

    ReadFavoriteFeedsErrorField __field;

    union {
        ReadFavoriteFeedsErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SelectFavoriteFeeds"
 * This Method is called by SDS (or any other module) to inform the favorite feed selected by user for download.
 * Method start to inform the favorite feed selected by user.
 */
class SelectFavoriteFeedsStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SelectFavoriteFeedsStart ();

    /**
     * Copy constructor
     */
    inline  SelectFavoriteFeedsStart (const SelectFavoriteFeedsStart &rhs);

    /**
     * All fields constructor
     */
    inline  SelectFavoriteFeedsStart (uint16 u16ChannelID_);

    /**
     * Destructor
     */
    inline virtual  ~SelectFavoriteFeedsStart();

    /**
     * Assignment operator
     */
    inline SelectFavoriteFeedsStart& operator = (const SelectFavoriteFeedsStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SelectFavoriteFeedsStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SelectFavoriteFeedsStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SelectFavoriteFeedsStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SelectFavoriteFeedsStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ChannelID"

    static const int kU16ChannelID = 0;

    /**
     * Clears the field "u16ChannelID".
     *
     * The field will be set to its default value. The hasU16ChannelID()
     * method will return false.
     */
    inline void clearU16ChannelID();

    /**
     * Checks whether the field "u16ChannelID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ChannelID()). Otherwise it will return false.
     */
    inline bool hasU16ChannelID () const;

    /**
     * Returns the value of the member "u16ChannelID".
     *
     * ChannelID of selected feed.
     *
     * @return The value of the field "u16ChannelID"
     */
    inline uint16 getU16ChannelID () const;

    /**
     * Sets the value of the member "u16ChannelID".
     *
     * ChannelID of selected feed.
     *
     * @param u16ChannelID The value which will be set
     */
    inline void setU16ChannelID (uint16 u16ChannelID_);

    static const SelectFavoriteFeedsStart &getDefaultInstance();

private:

    inline void set_has_u16ChannelID ();

    inline void clear_has_u16ChannelID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ChannelID;

};

/**
 * The error message of 'SelectFavoriteFeeds'
 * Error Message
 */
class SelectFavoriteFeedsErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SelectFavoriteFeedsErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SelectFavoriteFeedsErrorStructure (const SelectFavoriteFeedsErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SelectFavoriteFeedsErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~SelectFavoriteFeedsErrorStructure();

    /**
     * Assignment operator
     */
    inline SelectFavoriteFeedsErrorStructure& operator = (const SelectFavoriteFeedsErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SelectFavoriteFeedsErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SelectFavoriteFeedsErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SelectFavoriteFeedsErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SelectFavoriteFeedsErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const SelectFavoriteFeedsErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'SelectFavoriteFeeds'
 * Error Message
 */
class SelectFavoriteFeedsError  : public ::asf::core::Payload {
public:

    enum SelectFavoriteFeedsErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SelectFavoriteFeedsError ();

   /**
     * Copy constructor
     */
    inline  SelectFavoriteFeedsError (const SelectFavoriteFeedsError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SelectFavoriteFeedsError();

    /**
     * Assigns a new value to this object.
     */
    inline SelectFavoriteFeedsError& operator = (const SelectFavoriteFeedsError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SelectFavoriteFeedsError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SelectFavoriteFeedsError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SelectFavoriteFeedsError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SelectFavoriteFeedsError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SelectFavoriteFeedsError::SelectFavoriteFeedsErrorField getField () const;

    inline void setField(SelectFavoriteFeedsError::SelectFavoriteFeedsErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SelectFavoriteFeedsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SelectFavoriteFeedsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SelectFavoriteFeedsErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SelectFavoriteFeedsErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SelectFavoriteFeedsErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SelectFavoriteFeedsErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SelectFavoriteFeedsErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SelectFavoriteFeedsErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SelectFavoriteFeedsError &getDefaultInstance();

private:

    inline void cloneData (const SelectFavoriteFeedsError& rhs);

    inline void deleteData ();

    SelectFavoriteFeedsErrorField __field;

    union {
        SelectFavoriteFeedsErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The error message of 'DeleteInfoHistory'
 * Error Message
 */
class DeleteInfoHistoryErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DeleteInfoHistoryErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DeleteInfoHistoryErrorStructure (const DeleteInfoHistoryErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DeleteInfoHistoryErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~DeleteInfoHistoryErrorStructure();

    /**
     * Assignment operator
     */
    inline DeleteInfoHistoryErrorStructure& operator = (const DeleteInfoHistoryErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeleteInfoHistoryErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeleteInfoHistoryErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeleteInfoHistoryErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeleteInfoHistoryErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const DeleteInfoHistoryErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'DeleteInfoHistory'
 * Error Message
 */
class DeleteInfoHistoryError  : public ::asf::core::Payload {
public:

    enum DeleteInfoHistoryErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DeleteInfoHistoryError ();

   /**
     * Copy constructor
     */
    inline  DeleteInfoHistoryError (const DeleteInfoHistoryError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DeleteInfoHistoryError();

    /**
     * Assigns a new value to this object.
     */
    inline DeleteInfoHistoryError& operator = (const DeleteInfoHistoryError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeleteInfoHistoryError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeleteInfoHistoryError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeleteInfoHistoryError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeleteInfoHistoryError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DeleteInfoHistoryError::DeleteInfoHistoryErrorField getField () const;

    inline void setField(DeleteInfoHistoryError::DeleteInfoHistoryErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DeleteInfoHistoryErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DeleteInfoHistoryErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DeleteInfoHistoryErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DeleteInfoHistoryErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DeleteInfoHistoryErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DeleteInfoHistoryErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DeleteInfoHistoryErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DeleteInfoHistoryErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DeleteInfoHistoryError &getDefaultInstance();

private:

    inline void cloneData (const DeleteInfoHistoryError& rhs);

    inline void deleteData ();

    DeleteInfoHistoryErrorField __field;

    union {
        DeleteInfoHistoryErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "GetVICSTrafficData"
 * This Method is called by HMI to Get the VICS Traffic data.
 * Method start to send VICS Traffic data request to the fc_usb_tcu.
 */
class GetVICSTrafficDataStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetVICSTrafficDataStart ();

    /**
     * Copy constructor
     */
    inline  GetVICSTrafficDataStart (const GetVICSTrafficDataStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetVICSTrafficDataStart (const ::tcu_usb_main_fi_types::T_tcu_VICS_Request_Data& VICSRequestData_);

    /**
     * Destructor
     */
    inline virtual  ~GetVICSTrafficDataStart();

    /**
     * Assignment operator
     */
    inline GetVICSTrafficDataStart& operator = (const GetVICSTrafficDataStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetVICSTrafficDataStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetVICSTrafficDataStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetVICSTrafficDataStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetVICSTrafficDataStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VICSRequestData"

    static const int kVICSRequestData = 0;

    /**
     * Clears the field "VICSRequestData".
     *
     * The field will be set to its default value. The hasVICSRequestData()
     * method will return false.
     */
    inline void clearVICSRequestData();

    /**
     * Checks whether the field "VICSRequestData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVICSRequestData()). Otherwise it will return false.
     */
    inline bool hasVICSRequestData () const;

    /**
     * Returns the value of the member "VICSRequestData".
     *
     * Json file path along with file name.
     *
     * @return The value of the field "VICSRequestData"
     */
    inline const ::tcu_usb_main_fi_types::T_tcu_VICS_Request_Data& getVICSRequestData () const;

    /**
     * Retrieves the value of the field "VICSRequestData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "VICSRequestData".
     */
    inline ::tcu_usb_main_fi_types::T_tcu_VICS_Request_Data& getVICSRequestDataMutable ();

    /**
     * Sets the value of the member "VICSRequestData".
     *
     * Json file path along with file name.
     *
     * @param VICSRequestData The value which will be set
     */
    inline void setVICSRequestData (const ::tcu_usb_main_fi_types::T_tcu_VICS_Request_Data& VICSRequestData_);

    static const GetVICSTrafficDataStart &getDefaultInstance();

private:

    inline void set_has_VICSRequestData ();

    inline void clear_has_VICSRequestData ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_usb_main_fi_types::T_tcu_VICS_Request_Data _VICSRequestData;

};

/**
 * The error message of 'GetVICSTrafficData'
 * Error Message
 */
class GetVICSTrafficDataErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetVICSTrafficDataErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetVICSTrafficDataErrorStructure (const GetVICSTrafficDataErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetVICSTrafficDataErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~GetVICSTrafficDataErrorStructure();

    /**
     * Assignment operator
     */
    inline GetVICSTrafficDataErrorStructure& operator = (const GetVICSTrafficDataErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetVICSTrafficDataErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetVICSTrafficDataErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetVICSTrafficDataErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetVICSTrafficDataErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const GetVICSTrafficDataErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'GetVICSTrafficData'
 * Error Message
 */
class GetVICSTrafficDataError  : public ::asf::core::Payload {
public:

    enum GetVICSTrafficDataErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetVICSTrafficDataError ();

   /**
     * Copy constructor
     */
    inline  GetVICSTrafficDataError (const GetVICSTrafficDataError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetVICSTrafficDataError();

    /**
     * Assigns a new value to this object.
     */
    inline GetVICSTrafficDataError& operator = (const GetVICSTrafficDataError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetVICSTrafficDataError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetVICSTrafficDataError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetVICSTrafficDataError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetVICSTrafficDataError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetVICSTrafficDataError::GetVICSTrafficDataErrorField getField () const;

    inline void setField(GetVICSTrafficDataError::GetVICSTrafficDataErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetVICSTrafficDataErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetVICSTrafficDataErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetVICSTrafficDataErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetVICSTrafficDataErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetVICSTrafficDataErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetVICSTrafficDataErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetVICSTrafficDataErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetVICSTrafficDataErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetVICSTrafficDataError &getDefaultInstance();

private:

    inline void cloneData (const GetVICSTrafficDataError& rhs);

    inline void deleteData ();

    GetVICSTrafficDataErrorField __field;

    union {
        GetVICSTrafficDataErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "GetChargingStationsList"
 * This Method is called by HMI to Get Charging Stations List.
 * Method start to Get Charging Stations List in the fc_usb_tcu.
 */
class GetChargingStationsListStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetChargingStationsListStart ();

    /**
     * Copy constructor
     */
    inline  GetChargingStationsListStart (const GetChargingStationsListStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetChargingStationsListStart (const ::tcu_usb_main_fi_types::T_usb_tcu_Charging_Stations_Request_Info& ChargingStationsRequestInfo_);

    /**
     * Destructor
     */
    inline virtual  ~GetChargingStationsListStart();

    /**
     * Assignment operator
     */
    inline GetChargingStationsListStart& operator = (const GetChargingStationsListStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetChargingStationsListStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetChargingStationsListStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetChargingStationsListStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetChargingStationsListStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ChargingStationsRequestInfo"

    static const int kChargingStationsRequestInfo = 0;

    /**
     * Clears the field "ChargingStationsRequestInfo".
     *
     * The field will be set to its default value. The hasChargingStationsRequestInfo()
     * method will return false.
     */
    inline void clearChargingStationsRequestInfo();

    /**
     * Checks whether the field "ChargingStationsRequestInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChargingStationsRequestInfo()). Otherwise it will return false.
     */
    inline bool hasChargingStationsRequestInfo () const;

    /**
     * Returns the value of the member "ChargingStationsRequestInfo".
     *
     * Charging Stations Request Info
     *
     * @return The value of the field "ChargingStationsRequestInfo"
     */
    inline const ::tcu_usb_main_fi_types::T_usb_tcu_Charging_Stations_Request_Info& getChargingStationsRequestInfo () const;

    /**
     * Retrieves the value of the field "ChargingStationsRequestInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ChargingStationsRequestInfo".
     */
    inline ::tcu_usb_main_fi_types::T_usb_tcu_Charging_Stations_Request_Info& getChargingStationsRequestInfoMutable ();

    /**
     * Sets the value of the member "ChargingStationsRequestInfo".
     *
     * Charging Stations Request Info
     *
     * @param ChargingStationsRequestInfo The value which will be set
     */
    inline void setChargingStationsRequestInfo (const ::tcu_usb_main_fi_types::T_usb_tcu_Charging_Stations_Request_Info& ChargingStationsRequestInfo_);

    static const GetChargingStationsListStart &getDefaultInstance();

private:

    inline void set_has_ChargingStationsRequestInfo ();

    inline void clear_has_ChargingStationsRequestInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_usb_main_fi_types::T_usb_tcu_Charging_Stations_Request_Info _ChargingStationsRequestInfo;

};

/**
 * The error message of 'GetChargingStationsList'
 * Error Message
 */
class GetChargingStationsListErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetChargingStationsListErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetChargingStationsListErrorStructure (const GetChargingStationsListErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetChargingStationsListErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~GetChargingStationsListErrorStructure();

    /**
     * Assignment operator
     */
    inline GetChargingStationsListErrorStructure& operator = (const GetChargingStationsListErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetChargingStationsListErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetChargingStationsListErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetChargingStationsListErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetChargingStationsListErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const GetChargingStationsListErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'GetChargingStationsList'
 * Error Message
 */
class GetChargingStationsListError  : public ::asf::core::Payload {
public:

    enum GetChargingStationsListErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetChargingStationsListError ();

   /**
     * Copy constructor
     */
    inline  GetChargingStationsListError (const GetChargingStationsListError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetChargingStationsListError();

    /**
     * Assigns a new value to this object.
     */
    inline GetChargingStationsListError& operator = (const GetChargingStationsListError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetChargingStationsListError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetChargingStationsListError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetChargingStationsListError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetChargingStationsListError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetChargingStationsListError::GetChargingStationsListErrorField getField () const;

    inline void setField(GetChargingStationsListError::GetChargingStationsListErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetChargingStationsListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetChargingStationsListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetChargingStationsListErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetChargingStationsListErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetChargingStationsListErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetChargingStationsListErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetChargingStationsListErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetChargingStationsListErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetChargingStationsListError &getDefaultInstance();

private:

    inline void cloneData (const GetChargingStationsListError& rhs);

    inline void deleteData ();

    GetChargingStationsListErrorField __field;

    union {
        GetChargingStationsListErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "GetChargingSpotData"
 * This Method is called by HMI to Get Charging Spot Data.
 * Method start to Get Charging Spot Data in the fc_usb_tcu.
 */
class GetChargingSpotDataStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetChargingSpotDataStart ();

    /**
     * Copy constructor
     */
    inline  GetChargingSpotDataStart (const GetChargingSpotDataStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetChargingSpotDataStart (const ::tcu_usb_main_fi_types::T_usb_tcu_POIID_List& POIIDList_);

    /**
     * Destructor
     */
    inline virtual  ~GetChargingSpotDataStart();

    /**
     * Assignment operator
     */
    inline GetChargingSpotDataStart& operator = (const GetChargingSpotDataStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetChargingSpotDataStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetChargingSpotDataStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetChargingSpotDataStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetChargingSpotDataStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "POIIDList"

    static const int kPOIIDList = 0;

    /**
     * Clears the field "POIIDList".
     *
     * The field will be set to its default value. The hasPOIIDList()
     * method will return false.
     */
    inline void clearPOIIDList();

    /**
     * Checks whether the field "POIIDList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPOIIDList()). Otherwise it will return false.
     */
    inline bool hasPOIIDList () const;

    /**
     * Returns the value of the member "POIIDList".
     *
     * POI ID.
     *
     * @return The value of the field "POIIDList"
     */
    inline const ::tcu_usb_main_fi_types::T_usb_tcu_POIID_List& getPOIIDList () const;

    /**
     * Retrieves the value of the field "POIIDList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "POIIDList".
     */
    inline ::tcu_usb_main_fi_types::T_usb_tcu_POIID_List& getPOIIDListMutable ();

    /**
     * Sets the value of the member "POIIDList".
     *
     * POI ID.
     *
     * @param POIIDList The value which will be set
     */
    inline void setPOIIDList (const ::tcu_usb_main_fi_types::T_usb_tcu_POIID_List& POIIDList_);

    static const GetChargingSpotDataStart &getDefaultInstance();

private:

    static const ::std::vector< uint32 >& getUint32List_DefaultInstance ();

    inline void set_has_POIIDList ();

    inline void clear_has_POIIDList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_usb_main_fi_types::T_usb_tcu_POIID_List _POIIDList;

};

/**
 * The error message of 'GetChargingSpotData'
 * Error Message
 */
class GetChargingSpotDataErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetChargingSpotDataErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetChargingSpotDataErrorStructure (const GetChargingSpotDataErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetChargingSpotDataErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~GetChargingSpotDataErrorStructure();

    /**
     * Assignment operator
     */
    inline GetChargingSpotDataErrorStructure& operator = (const GetChargingSpotDataErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetChargingSpotDataErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetChargingSpotDataErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetChargingSpotDataErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetChargingSpotDataErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const GetChargingSpotDataErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'GetChargingSpotData'
 * Error Message
 */
class GetChargingSpotDataError  : public ::asf::core::Payload {
public:

    enum GetChargingSpotDataErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetChargingSpotDataError ();

   /**
     * Copy constructor
     */
    inline  GetChargingSpotDataError (const GetChargingSpotDataError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetChargingSpotDataError();

    /**
     * Assigns a new value to this object.
     */
    inline GetChargingSpotDataError& operator = (const GetChargingSpotDataError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetChargingSpotDataError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetChargingSpotDataError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetChargingSpotDataError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetChargingSpotDataError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetChargingSpotDataError::GetChargingSpotDataErrorField getField () const;

    inline void setField(GetChargingSpotDataError::GetChargingSpotDataErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetChargingSpotDataErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetChargingSpotDataErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetChargingSpotDataErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetChargingSpotDataErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetChargingSpotDataErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetChargingSpotDataErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetChargingSpotDataErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetChargingSpotDataErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetChargingSpotDataError &getDefaultInstance();

private:

    inline void cloneData (const GetChargingSpotDataError& rhs);

    inline void deleteData ();

    GetChargingSpotDataErrorField __field;

    union {
        GetChargingSpotDataErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "GetVacancySpotData"
 * This Method is called by HMI to Get Vacancy Spot Data.
 * Method start to Get Vacancy Spot Data in the fc_usb_tcu.
 */
class GetVacancySpotDataStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetVacancySpotDataStart ();

    /**
     * Copy constructor
     */
    inline  GetVacancySpotDataStart (const GetVacancySpotDataStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetVacancySpotDataStart (const ::tcu_usb_main_fi_types::T_usb_tcu_POIID_List& POIIDList_);

    /**
     * Destructor
     */
    inline virtual  ~GetVacancySpotDataStart();

    /**
     * Assignment operator
     */
    inline GetVacancySpotDataStart& operator = (const GetVacancySpotDataStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetVacancySpotDataStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetVacancySpotDataStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetVacancySpotDataStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetVacancySpotDataStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "POIIDList"

    static const int kPOIIDList = 0;

    /**
     * Clears the field "POIIDList".
     *
     * The field will be set to its default value. The hasPOIIDList()
     * method will return false.
     */
    inline void clearPOIIDList();

    /**
     * Checks whether the field "POIIDList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPOIIDList()). Otherwise it will return false.
     */
    inline bool hasPOIIDList () const;

    /**
     * Returns the value of the member "POIIDList".
     *
     * POI ID.
     *
     * @return The value of the field "POIIDList"
     */
    inline const ::tcu_usb_main_fi_types::T_usb_tcu_POIID_List& getPOIIDList () const;

    /**
     * Retrieves the value of the field "POIIDList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "POIIDList".
     */
    inline ::tcu_usb_main_fi_types::T_usb_tcu_POIID_List& getPOIIDListMutable ();

    /**
     * Sets the value of the member "POIIDList".
     *
     * POI ID.
     *
     * @param POIIDList The value which will be set
     */
    inline void setPOIIDList (const ::tcu_usb_main_fi_types::T_usb_tcu_POIID_List& POIIDList_);

    static const GetVacancySpotDataStart &getDefaultInstance();

private:

    static const ::std::vector< uint32 >& getUint32List_DefaultInstance ();

    inline void set_has_POIIDList ();

    inline void clear_has_POIIDList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_usb_main_fi_types::T_usb_tcu_POIID_List _POIIDList;

};

/**
 * The error message of 'GetVacancySpotData'
 * Error Message
 */
class GetVacancySpotDataErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetVacancySpotDataErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetVacancySpotDataErrorStructure (const GetVacancySpotDataErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetVacancySpotDataErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~GetVacancySpotDataErrorStructure();

    /**
     * Assignment operator
     */
    inline GetVacancySpotDataErrorStructure& operator = (const GetVacancySpotDataErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetVacancySpotDataErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetVacancySpotDataErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetVacancySpotDataErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetVacancySpotDataErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const GetVacancySpotDataErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'GetVacancySpotData'
 * Error Message
 */
class GetVacancySpotDataError  : public ::asf::core::Payload {
public:

    enum GetVacancySpotDataErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetVacancySpotDataError ();

   /**
     * Copy constructor
     */
    inline  GetVacancySpotDataError (const GetVacancySpotDataError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetVacancySpotDataError();

    /**
     * Assigns a new value to this object.
     */
    inline GetVacancySpotDataError& operator = (const GetVacancySpotDataError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetVacancySpotDataError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetVacancySpotDataError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetVacancySpotDataError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetVacancySpotDataError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetVacancySpotDataError::GetVacancySpotDataErrorField getField () const;

    inline void setField(GetVacancySpotDataError::GetVacancySpotDataErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetVacancySpotDataErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetVacancySpotDataErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetVacancySpotDataErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetVacancySpotDataErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetVacancySpotDataErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetVacancySpotDataErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetVacancySpotDataErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetVacancySpotDataErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetVacancySpotDataError &getDefaultInstance();

private:

    inline void cloneData (const GetVacancySpotDataError& rhs);

    inline void deleteData ();

    GetVacancySpotDataErrorField __field;

    union {
        GetVacancySpotDataErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "GetVacancyStationsList"
 * This Method is called by HMI to Get Vacancy Stations List.
 * Method start to Get Vacancy Stations List in the fc_usb_tcu.
 */
class GetVacancyStationsListStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetVacancyStationsListStart ();

    /**
     * Copy constructor
     */
    inline  GetVacancyStationsListStart (const GetVacancyStationsListStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetVacancyStationsListStart (const ::tcu_usb_main_fi_types::T_usb_tcu_Vacancy_Stations_Request_Info& VacancyStationsRequestInfo_);

    /**
     * Destructor
     */
    inline virtual  ~GetVacancyStationsListStart();

    /**
     * Assignment operator
     */
    inline GetVacancyStationsListStart& operator = (const GetVacancyStationsListStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetVacancyStationsListStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetVacancyStationsListStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetVacancyStationsListStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetVacancyStationsListStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VacancyStationsRequestInfo"

    static const int kVacancyStationsRequestInfo = 0;

    /**
     * Clears the field "VacancyStationsRequestInfo".
     *
     * The field will be set to its default value. The hasVacancyStationsRequestInfo()
     * method will return false.
     */
    inline void clearVacancyStationsRequestInfo();

    /**
     * Checks whether the field "VacancyStationsRequestInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVacancyStationsRequestInfo()). Otherwise it will return false.
     */
    inline bool hasVacancyStationsRequestInfo () const;

    /**
     * Returns the value of the member "VacancyStationsRequestInfo".
     *
     * Vacancy Stations Request Info
     *
     * @return The value of the field "VacancyStationsRequestInfo"
     */
    inline const ::tcu_usb_main_fi_types::T_usb_tcu_Vacancy_Stations_Request_Info& getVacancyStationsRequestInfo () const;

    /**
     * Retrieves the value of the field "VacancyStationsRequestInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "VacancyStationsRequestInfo".
     */
    inline ::tcu_usb_main_fi_types::T_usb_tcu_Vacancy_Stations_Request_Info& getVacancyStationsRequestInfoMutable ();

    /**
     * Sets the value of the member "VacancyStationsRequestInfo".
     *
     * Vacancy Stations Request Info
     *
     * @param VacancyStationsRequestInfo The value which will be set
     */
    inline void setVacancyStationsRequestInfo (const ::tcu_usb_main_fi_types::T_usb_tcu_Vacancy_Stations_Request_Info& VacancyStationsRequestInfo_);

    static const GetVacancyStationsListStart &getDefaultInstance();

private:

    inline void set_has_VacancyStationsRequestInfo ();

    inline void clear_has_VacancyStationsRequestInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_usb_main_fi_types::T_usb_tcu_Vacancy_Stations_Request_Info _VacancyStationsRequestInfo;

};

/**
 * The error message of 'GetVacancyStationsList'
 * Error Message
 */
class GetVacancyStationsListErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetVacancyStationsListErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetVacancyStationsListErrorStructure (const GetVacancyStationsListErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetVacancyStationsListErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~GetVacancyStationsListErrorStructure();

    /**
     * Assignment operator
     */
    inline GetVacancyStationsListErrorStructure& operator = (const GetVacancyStationsListErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetVacancyStationsListErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetVacancyStationsListErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetVacancyStationsListErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetVacancyStationsListErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const GetVacancyStationsListErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'GetVacancyStationsList'
 * Error Message
 */
class GetVacancyStationsListError  : public ::asf::core::Payload {
public:

    enum GetVacancyStationsListErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetVacancyStationsListError ();

   /**
     * Copy constructor
     */
    inline  GetVacancyStationsListError (const GetVacancyStationsListError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetVacancyStationsListError();

    /**
     * Assigns a new value to this object.
     */
    inline GetVacancyStationsListError& operator = (const GetVacancyStationsListError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetVacancyStationsListError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetVacancyStationsListError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetVacancyStationsListError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetVacancyStationsListError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetVacancyStationsListError::GetVacancyStationsListErrorField getField () const;

    inline void setField(GetVacancyStationsListError::GetVacancyStationsListErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetVacancyStationsListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetVacancyStationsListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetVacancyStationsListErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetVacancyStationsListErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetVacancyStationsListErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetVacancyStationsListErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetVacancyStationsListErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetVacancyStationsListErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetVacancyStationsListError &getDefaultInstance();

private:

    inline void cloneData (const GetVacancyStationsListError& rhs);

    inline void deleteData ();

    GetVacancyStationsListErrorField __field;

    union {
        GetVacancyStationsListErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SendUserCredentials"
 */
class SendUserCredentialsStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendUserCredentialsStart ();

    /**
     * Copy constructor
     */
    inline  SendUserCredentialsStart (const SendUserCredentialsStart &rhs);

    /**
     * All fields constructor
     */
    inline  SendUserCredentialsStart (const ::std::string& sUserId_, const ::std::string& sPassword_, bool bClearData_);

    /**
     * Destructor
     */
    inline virtual  ~SendUserCredentialsStart();

    /**
     * Assignment operator
     */
    inline SendUserCredentialsStart& operator = (const SendUserCredentialsStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendUserCredentialsStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendUserCredentialsStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendUserCredentialsStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendUserCredentialsStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sUserId"

    static const int kSUserId = 0;

    /**
     * Clears the field "sUserId".
     *
     * The field will be set to its default value. The hasSUserId()
     * method will return false.
     */
    inline void clearSUserId();

    /**
     * Checks whether the field "sUserId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSUserId()). Otherwise it will return false.
     */
    inline bool hasSUserId () const;

    /**
     * Returns the value of the member "sUserId".
     *
     * If the meaning of "sUserId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sUserId"
     */
    inline const ::std::string& getSUserId () const;

    /**
     * Retrieves the value of the field "sUserId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sUserId".
     */
    inline ::std::string& getSUserIdMutable ();

    /**
     * Sets the value of the member "sUserId".
     *
     * If the meaning of "sUserId" isn't clear, then there should be a description here.
     *
     * @param sUserId The value which will be set
     */
    inline void setSUserId (const ::std::string& sUserId_);

    /**
     * Sets the value of the member "sUserId".
     *
     * If the meaning of "sUserId" isn't clear, then there should be a description here.
     *
     * @param sUserId The value which will be set
     */
    inline void setSUserId (const char* sUserId_);

    /**
     * Sets the value of the member "sUserId".
     *
     * If the meaning of "sUserId" isn't clear, then there should be a description here.
     *
     * @param sUserId The value which will be set
     */
    inline void setSUserId (const char* value, size_t size);

    // API of field "sPassword"

    static const int kSPassword = 1;

    /**
     * Clears the field "sPassword".
     *
     * The field will be set to its default value. The hasSPassword()
     * method will return false.
     */
    inline void clearSPassword();

    /**
     * Checks whether the field "sPassword" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPassword()). Otherwise it will return false.
     */
    inline bool hasSPassword () const;

    /**
     * Returns the value of the member "sPassword".
     *
     * If the meaning of "sPassword" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sPassword"
     */
    inline const ::std::string& getSPassword () const;

    /**
     * Retrieves the value of the field "sPassword" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sPassword".
     */
    inline ::std::string& getSPasswordMutable ();

    /**
     * Sets the value of the member "sPassword".
     *
     * If the meaning of "sPassword" isn't clear, then there should be a description here.
     *
     * @param sPassword The value which will be set
     */
    inline void setSPassword (const ::std::string& sPassword_);

    /**
     * Sets the value of the member "sPassword".
     *
     * If the meaning of "sPassword" isn't clear, then there should be a description here.
     *
     * @param sPassword The value which will be set
     */
    inline void setSPassword (const char* sPassword_);

    /**
     * Sets the value of the member "sPassword".
     *
     * If the meaning of "sPassword" isn't clear, then there should be a description here.
     *
     * @param sPassword The value which will be set
     */
    inline void setSPassword (const char* value, size_t size);

    // API of field "bClearData"

    static const int kBClearData = 2;

    /**
     * Clears the field "bClearData".
     *
     * The field will be set to its default value. The hasBClearData()
     * method will return false.
     */
    inline void clearBClearData();

    /**
     * Checks whether the field "bClearData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBClearData()). Otherwise it will return false.
     */
    inline bool hasBClearData () const;

    /**
     * Returns the value of the member "bClearData".
     *
     * If the meaning of "bClearData" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bClearData"
     */
    inline bool getBClearData () const;

    /**
     * Sets the value of the member "bClearData".
     *
     * If the meaning of "bClearData" isn't clear, then there should be a description here.
     *
     * @param bClearData The value which will be set
     */
    inline void setBClearData (bool bClearData_);

    static const SendUserCredentialsStart &getDefaultInstance();

private:

    inline void set_has_sUserId ();

    inline void clear_has_sUserId ();

    inline void set_has_sPassword ();

    inline void clear_has_sPassword ();

    inline void set_has_bClearData ();

    inline void clear_has_bClearData ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _sUserId;

    ::std::string _sPassword;

    bool _bClearData;

};

/**
 * The error message of 'SendUserCredentials'
 * Error Message
 */
class SendUserCredentialsErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SendUserCredentialsErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SendUserCredentialsErrorStructure (const SendUserCredentialsErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SendUserCredentialsErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~SendUserCredentialsErrorStructure();

    /**
     * Assignment operator
     */
    inline SendUserCredentialsErrorStructure& operator = (const SendUserCredentialsErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendUserCredentialsErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendUserCredentialsErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendUserCredentialsErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendUserCredentialsErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const SendUserCredentialsErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'SendUserCredentials'
 * Error Message
 */
class SendUserCredentialsError  : public ::asf::core::Payload {
public:

    enum SendUserCredentialsErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SendUserCredentialsError ();

   /**
     * Copy constructor
     */
    inline  SendUserCredentialsError (const SendUserCredentialsError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SendUserCredentialsError();

    /**
     * Assigns a new value to this object.
     */
    inline SendUserCredentialsError& operator = (const SendUserCredentialsError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendUserCredentialsError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendUserCredentialsError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendUserCredentialsError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendUserCredentialsError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SendUserCredentialsError::SendUserCredentialsErrorField getField () const;

    inline void setField(SendUserCredentialsError::SendUserCredentialsErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SendUserCredentialsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SendUserCredentialsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SendUserCredentialsErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SendUserCredentialsErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SendUserCredentialsErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SendUserCredentialsErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SendUserCredentialsErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SendUserCredentialsErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SendUserCredentialsError &getDefaultInstance();

private:

    inline void cloneData (const SendUserCredentialsError& rhs);

    inline void deleteData ();

    SendUserCredentialsErrorField __field;

    union {
        SendUserCredentialsErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "UserCredentialStatus"
 * Property update status of user credentials updated
 */
class UserCredentialStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UserCredentialStatusStatus ();

    /**
     * Copy constructor
     */
    inline  UserCredentialStatusStatus (const UserCredentialStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  UserCredentialStatusStatus (const ::std::string& sDisplayMessage_, const ::std::string& sTTSTextMessage_, ::tcu_usb_main_fi_types::T_e8_tcu_Authentication_Result e8AuthenticationResult_);

    /**
     * Destructor
     */
    inline virtual  ~UserCredentialStatusStatus();

    /**
     * Assignment operator
     */
    inline UserCredentialStatusStatus& operator = (const UserCredentialStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UserCredentialStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UserCredentialStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UserCredentialStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UserCredentialStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sDisplayMessage"

    static const int kSDisplayMessage = 0;

    /**
     * Clears the field "sDisplayMessage".
     *
     * The field will be set to its default value. The hasSDisplayMessage()
     * method will return false.
     */
    inline void clearSDisplayMessage();

    /**
     * Checks whether the field "sDisplayMessage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDisplayMessage()). Otherwise it will return false.
     */
    inline bool hasSDisplayMessage () const;

    /**
     * Returns the value of the member "sDisplayMessage".
     *
     *
     *
     * @return The value of the field "sDisplayMessage"
     */
    inline const ::std::string& getSDisplayMessage () const;

    /**
     * Retrieves the value of the field "sDisplayMessage" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDisplayMessage".
     */
    inline ::std::string& getSDisplayMessageMutable ();

    /**
     * Sets the value of the member "sDisplayMessage".
     *
     *
     *
     * @param sDisplayMessage The value which will be set
     */
    inline void setSDisplayMessage (const ::std::string& sDisplayMessage_);

    /**
     * Sets the value of the member "sDisplayMessage".
     *
     *
     *
     * @param sDisplayMessage The value which will be set
     */
    inline void setSDisplayMessage (const char* sDisplayMessage_);

    /**
     * Sets the value of the member "sDisplayMessage".
     *
     *
     *
     * @param sDisplayMessage The value which will be set
     */
    inline void setSDisplayMessage (const char* value, size_t size);

    // API of field "sTTSTextMessage"

    static const int kSTTSTextMessage = 1;

    /**
     * Clears the field "sTTSTextMessage".
     *
     * The field will be set to its default value. The hasSTTSTextMessage()
     * method will return false.
     */
    inline void clearSTTSTextMessage();

    /**
     * Checks whether the field "sTTSTextMessage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSTTSTextMessage()). Otherwise it will return false.
     */
    inline bool hasSTTSTextMessage () const;

    /**
     * Returns the value of the member "sTTSTextMessage".
     *
     *
     *
     * @return The value of the field "sTTSTextMessage"
     */
    inline const ::std::string& getSTTSTextMessage () const;

    /**
     * Retrieves the value of the field "sTTSTextMessage" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sTTSTextMessage".
     */
    inline ::std::string& getSTTSTextMessageMutable ();

    /**
     * Sets the value of the member "sTTSTextMessage".
     *
     *
     *
     * @param sTTSTextMessage The value which will be set
     */
    inline void setSTTSTextMessage (const ::std::string& sTTSTextMessage_);

    /**
     * Sets the value of the member "sTTSTextMessage".
     *
     *
     *
     * @param sTTSTextMessage The value which will be set
     */
    inline void setSTTSTextMessage (const char* sTTSTextMessage_);

    /**
     * Sets the value of the member "sTTSTextMessage".
     *
     *
     *
     * @param sTTSTextMessage The value which will be set
     */
    inline void setSTTSTextMessage (const char* value, size_t size);

    // API of field "e8AuthenticationResult"

    static const int kE8AuthenticationResult = 2;

    /**
     * Clears the field "e8AuthenticationResult".
     *
     * The field will be set to its default value. The hasE8AuthenticationResult()
     * method will return false.
     */
    inline void clearE8AuthenticationResult();

    /**
     * Checks whether the field "e8AuthenticationResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8AuthenticationResult()). Otherwise it will return false.
     */
    inline bool hasE8AuthenticationResult () const;

    /**
     * Returns the value of the member "e8AuthenticationResult".
     *
     *
     *
     * @return The value of the field "e8AuthenticationResult"
     */
    inline ::tcu_usb_main_fi_types::T_e8_tcu_Authentication_Result getE8AuthenticationResult () const;

    /**
     * Sets the value of the member "e8AuthenticationResult".
     *
     *
     *
     * @param e8AuthenticationResult The value which will be set
     */
    inline void setE8AuthenticationResult (::tcu_usb_main_fi_types::T_e8_tcu_Authentication_Result e8AuthenticationResult_);

    static const UserCredentialStatusStatus &getDefaultInstance();

private:

    inline void set_has_sDisplayMessage ();

    inline void clear_has_sDisplayMessage ();

    inline void set_has_sTTSTextMessage ();

    inline void clear_has_sTTSTextMessage ();

    inline void set_has_e8AuthenticationResult ();

    inline void clear_has_e8AuthenticationResult ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _sDisplayMessage;

    ::std::string _sTTSTextMessage;

    ::tcu_usb_main_fi_types::T_e8_tcu_Authentication_Result _e8AuthenticationResult;

};

/**
 * The error message of 'UserCredentialStatus'
 */
class UserCredentialStatusErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  UserCredentialStatusErrorStructure ();

    /**
     * Copy constructor
     */
    inline  UserCredentialStatusErrorStructure (const UserCredentialStatusErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  UserCredentialStatusErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~UserCredentialStatusErrorStructure();

    /**
     * Assignment operator
     */
    inline UserCredentialStatusErrorStructure& operator = (const UserCredentialStatusErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UserCredentialStatusErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UserCredentialStatusErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UserCredentialStatusErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UserCredentialStatusErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const UserCredentialStatusErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'UserCredentialStatus'
 */
class UserCredentialStatusError  : public ::asf::core::Payload {
public:

    enum UserCredentialStatusErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  UserCredentialStatusError ();

   /**
     * Copy constructor
     */
    inline  UserCredentialStatusError (const UserCredentialStatusError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~UserCredentialStatusError();

    /**
     * Assigns a new value to this object.
     */
    inline UserCredentialStatusError& operator = (const UserCredentialStatusError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UserCredentialStatusError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UserCredentialStatusError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UserCredentialStatusError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UserCredentialStatusError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline UserCredentialStatusError::UserCredentialStatusErrorField getField () const;

    inline void setField(UserCredentialStatusError::UserCredentialStatusErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "UserCredentialStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "UserCredentialStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const UserCredentialStatusErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline UserCredentialStatusErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline UserCredentialStatusErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (UserCredentialStatusErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "UserCredentialStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const UserCredentialStatusErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const UserCredentialStatusError &getDefaultInstance();

private:

    inline void cloneData (const UserCredentialStatusError& rhs);

    inline void deleteData ();

    UserCredentialStatusErrorField __field;

    union {
        UserCredentialStatusErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "DeleteChannelInformation"
 * This Method is called by HMI to delete a particular Channel from database completely, everything.
 * Method start to send delete request to the fc_usb_tcu.
 */
class DeleteChannelInformationStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeleteChannelInformationStart ();

    /**
     * Copy constructor
     */
    inline  DeleteChannelInformationStart (const DeleteChannelInformationStart &rhs);

    /**
     * All fields constructor
     */
    inline  DeleteChannelInformationStart (uint16 u16ChannelID_);

    /**
     * Destructor
     */
    inline virtual  ~DeleteChannelInformationStart();

    /**
     * Assignment operator
     */
    inline DeleteChannelInformationStart& operator = (const DeleteChannelInformationStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeleteChannelInformationStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeleteChannelInformationStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeleteChannelInformationStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeleteChannelInformationStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ChannelID"

    static const int kU16ChannelID = 0;

    /**
     * Clears the field "u16ChannelID".
     *
     * The field will be set to its default value. The hasU16ChannelID()
     * method will return false.
     */
    inline void clearU16ChannelID();

    /**
     * Checks whether the field "u16ChannelID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ChannelID()). Otherwise it will return false.
     */
    inline bool hasU16ChannelID () const;

    /**
     * Returns the value of the member "u16ChannelID".
     *
     * ChannelID to be delete from database.
     *
     * @return The value of the field "u16ChannelID"
     */
    inline uint16 getU16ChannelID () const;

    /**
     * Sets the value of the member "u16ChannelID".
     *
     * ChannelID to be delete from database.
     *
     * @param u16ChannelID The value which will be set
     */
    inline void setU16ChannelID (uint16 u16ChannelID_);

    static const DeleteChannelInformationStart &getDefaultInstance();

private:

    inline void set_has_u16ChannelID ();

    inline void clear_has_u16ChannelID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ChannelID;

};

/**
 * The error message of 'DeleteChannelInformation'
 * Error Message
 */
class DeleteChannelInformationErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DeleteChannelInformationErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DeleteChannelInformationErrorStructure (const DeleteChannelInformationErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DeleteChannelInformationErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~DeleteChannelInformationErrorStructure();

    /**
     * Assignment operator
     */
    inline DeleteChannelInformationErrorStructure& operator = (const DeleteChannelInformationErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeleteChannelInformationErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeleteChannelInformationErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeleteChannelInformationErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeleteChannelInformationErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const DeleteChannelInformationErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'DeleteChannelInformation'
 * Error Message
 */
class DeleteChannelInformationError  : public ::asf::core::Payload {
public:

    enum DeleteChannelInformationErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DeleteChannelInformationError ();

   /**
     * Copy constructor
     */
    inline  DeleteChannelInformationError (const DeleteChannelInformationError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DeleteChannelInformationError();

    /**
     * Assigns a new value to this object.
     */
    inline DeleteChannelInformationError& operator = (const DeleteChannelInformationError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeleteChannelInformationError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeleteChannelInformationError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeleteChannelInformationError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeleteChannelInformationError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DeleteChannelInformationError::DeleteChannelInformationErrorField getField () const;

    inline void setField(DeleteChannelInformationError::DeleteChannelInformationErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DeleteChannelInformationErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DeleteChannelInformationErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DeleteChannelInformationErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DeleteChannelInformationErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DeleteChannelInformationErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DeleteChannelInformationErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DeleteChannelInformationErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DeleteChannelInformationErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DeleteChannelInformationError &getDefaultInstance();

private:

    inline void cloneData (const DeleteChannelInformationError& rhs);

    inline void deleteData ();

    DeleteChannelInformationErrorField __field;

    union {
        DeleteChannelInformationErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The error message of 'DownloadPartAuthData'
 * Error Message
 */
class DownloadPartAuthDataErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DownloadPartAuthDataErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DownloadPartAuthDataErrorStructure (const DownloadPartAuthDataErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DownloadPartAuthDataErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~DownloadPartAuthDataErrorStructure();

    /**
     * Assignment operator
     */
    inline DownloadPartAuthDataErrorStructure& operator = (const DownloadPartAuthDataErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DownloadPartAuthDataErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DownloadPartAuthDataErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DownloadPartAuthDataErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DownloadPartAuthDataErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const DownloadPartAuthDataErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'DownloadPartAuthData'
 * Error Message
 */
class DownloadPartAuthDataError  : public ::asf::core::Payload {
public:

    enum DownloadPartAuthDataErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DownloadPartAuthDataError ();

   /**
     * Copy constructor
     */
    inline  DownloadPartAuthDataError (const DownloadPartAuthDataError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DownloadPartAuthDataError();

    /**
     * Assigns a new value to this object.
     */
    inline DownloadPartAuthDataError& operator = (const DownloadPartAuthDataError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DownloadPartAuthDataError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DownloadPartAuthDataError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DownloadPartAuthDataError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DownloadPartAuthDataError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DownloadPartAuthDataError::DownloadPartAuthDataErrorField getField () const;

    inline void setField(DownloadPartAuthDataError::DownloadPartAuthDataErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DownloadPartAuthDataErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DownloadPartAuthDataErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DownloadPartAuthDataErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DownloadPartAuthDataErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DownloadPartAuthDataErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DownloadPartAuthDataErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DownloadPartAuthDataErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DownloadPartAuthDataErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DownloadPartAuthDataError &getDefaultInstance();

private:

    inline void cloneData (const DownloadPartAuthDataError& rhs);

    inline void deleteData ();

    DownloadPartAuthDataErrorField __field;

    union {
        DownloadPartAuthDataErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "ValidateUserCredentials"
 * This Method is called by some other component to ValidateUserCredentials
 * Method start to ValidateUserCredentials
 */
class ValidateUserCredentialsStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ValidateUserCredentialsStart ();

    /**
     * Copy constructor
     */
    inline  ValidateUserCredentialsStart (const ValidateUserCredentialsStart &rhs);

    /**
     * All fields constructor
     */
    inline  ValidateUserCredentialsStart (const ::std::string& sUserId_, const ::std::string& sPassword_);

    /**
     * Destructor
     */
    inline virtual  ~ValidateUserCredentialsStart();

    /**
     * Assignment operator
     */
    inline ValidateUserCredentialsStart& operator = (const ValidateUserCredentialsStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ValidateUserCredentialsStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ValidateUserCredentialsStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ValidateUserCredentialsStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ValidateUserCredentialsStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sUserId"

    static const int kSUserId = 0;

    /**
     * Clears the field "sUserId".
     *
     * The field will be set to its default value. The hasSUserId()
     * method will return false.
     */
    inline void clearSUserId();

    /**
     * Checks whether the field "sUserId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSUserId()). Otherwise it will return false.
     */
    inline bool hasSUserId () const;

    /**
     * Returns the value of the member "sUserId".
     *
     * If the meaning of "sUserId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sUserId"
     */
    inline const ::std::string& getSUserId () const;

    /**
     * Retrieves the value of the field "sUserId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sUserId".
     */
    inline ::std::string& getSUserIdMutable ();

    /**
     * Sets the value of the member "sUserId".
     *
     * If the meaning of "sUserId" isn't clear, then there should be a description here.
     *
     * @param sUserId The value which will be set
     */
    inline void setSUserId (const ::std::string& sUserId_);

    /**
     * Sets the value of the member "sUserId".
     *
     * If the meaning of "sUserId" isn't clear, then there should be a description here.
     *
     * @param sUserId The value which will be set
     */
    inline void setSUserId (const char* sUserId_);

    /**
     * Sets the value of the member "sUserId".
     *
     * If the meaning of "sUserId" isn't clear, then there should be a description here.
     *
     * @param sUserId The value which will be set
     */
    inline void setSUserId (const char* value, size_t size);

    // API of field "sPassword"

    static const int kSPassword = 1;

    /**
     * Clears the field "sPassword".
     *
     * The field will be set to its default value. The hasSPassword()
     * method will return false.
     */
    inline void clearSPassword();

    /**
     * Checks whether the field "sPassword" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPassword()). Otherwise it will return false.
     */
    inline bool hasSPassword () const;

    /**
     * Returns the value of the member "sPassword".
     *
     * If the meaning of "sPassword" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sPassword"
     */
    inline const ::std::string& getSPassword () const;

    /**
     * Retrieves the value of the field "sPassword" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sPassword".
     */
    inline ::std::string& getSPasswordMutable ();

    /**
     * Sets the value of the member "sPassword".
     *
     * If the meaning of "sPassword" isn't clear, then there should be a description here.
     *
     * @param sPassword The value which will be set
     */
    inline void setSPassword (const ::std::string& sPassword_);

    /**
     * Sets the value of the member "sPassword".
     *
     * If the meaning of "sPassword" isn't clear, then there should be a description here.
     *
     * @param sPassword The value which will be set
     */
    inline void setSPassword (const char* sPassword_);

    /**
     * Sets the value of the member "sPassword".
     *
     * If the meaning of "sPassword" isn't clear, then there should be a description here.
     *
     * @param sPassword The value which will be set
     */
    inline void setSPassword (const char* value, size_t size);

    static const ValidateUserCredentialsStart &getDefaultInstance();

private:

    inline void set_has_sUserId ();

    inline void clear_has_sUserId ();

    inline void set_has_sPassword ();

    inline void clear_has_sPassword ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _sUserId;

    ::std::string _sPassword;

};

/**
 * The result message of the method "ValidateUserCredentials"
 * This Method is called by some other component to ValidateUserCredentials
 */
class ValidateUserCredentialsResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ValidateUserCredentialsResult ();

    /**
     * Copy constructor
     */
    inline  ValidateUserCredentialsResult (const ValidateUserCredentialsResult &rhs);

    /**
     * All fields constructor
     */
    inline  ValidateUserCredentialsResult (::tcu_usb_main_fi_types::T_e8_UserAuthenticationResultType Result_, const ::std::string& Token_);

    /**
     * Destructor
     */
    inline virtual  ~ValidateUserCredentialsResult();

    /**
     * Assignment operator
     */
    inline ValidateUserCredentialsResult& operator = (const ValidateUserCredentialsResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ValidateUserCredentialsResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ValidateUserCredentialsResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ValidateUserCredentialsResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ValidateUserCredentialsResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline ::tcu_usb_main_fi_types::T_e8_UserAuthenticationResultType getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (::tcu_usb_main_fi_types::T_e8_UserAuthenticationResultType Result_);

    // API of field "Token"

    static const int kToken = 1;

    /**
     * Clears the field "Token".
     *
     * The field will be set to its default value. The hasToken()
     * method will return false.
     */
    inline void clearToken();

    /**
     * Checks whether the field "Token" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setToken()). Otherwise it will return false.
     */
    inline bool hasToken () const;

    /**
     * Returns the value of the member "Token".
     *
     * If the meaning of "Token" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Token"
     */
    inline const ::std::string& getToken () const;

    /**
     * Retrieves the value of the field "Token" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Token".
     */
    inline ::std::string& getTokenMutable ();

    /**
     * Sets the value of the member "Token".
     *
     * If the meaning of "Token" isn't clear, then there should be a description here.
     *
     * @param Token The value which will be set
     */
    inline void setToken (const ::std::string& Token_);

    /**
     * Sets the value of the member "Token".
     *
     * If the meaning of "Token" isn't clear, then there should be a description here.
     *
     * @param Token The value which will be set
     */
    inline void setToken (const char* Token_);

    /**
     * Sets the value of the member "Token".
     *
     * If the meaning of "Token" isn't clear, then there should be a description here.
     *
     * @param Token The value which will be set
     */
    inline void setToken (const char* value, size_t size);

    static const ValidateUserCredentialsResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    inline void set_has_Token ();

    inline void clear_has_Token ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::tcu_usb_main_fi_types::T_e8_UserAuthenticationResultType _Result;

    ::std::string _Token;

};

/**
 * The result message of the method "RenewAccessToken"
 * This Method is called by some other component for renewing token
 */
class RenewAccessTokenResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RenewAccessTokenResult ();

    /**
     * Copy constructor
     */
    inline  RenewAccessTokenResult (const RenewAccessTokenResult &rhs);

    /**
     * All fields constructor
     */
    inline  RenewAccessTokenResult (::tcu_usb_main_fi_types::T_e8_UserAuthenticationResultType Result_, const ::std::string& Token_);

    /**
     * Destructor
     */
    inline virtual  ~RenewAccessTokenResult();

    /**
     * Assignment operator
     */
    inline RenewAccessTokenResult& operator = (const RenewAccessTokenResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RenewAccessTokenResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RenewAccessTokenResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RenewAccessTokenResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RenewAccessTokenResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline ::tcu_usb_main_fi_types::T_e8_UserAuthenticationResultType getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (::tcu_usb_main_fi_types::T_e8_UserAuthenticationResultType Result_);

    // API of field "Token"

    static const int kToken = 1;

    /**
     * Clears the field "Token".
     *
     * The field will be set to its default value. The hasToken()
     * method will return false.
     */
    inline void clearToken();

    /**
     * Checks whether the field "Token" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setToken()). Otherwise it will return false.
     */
    inline bool hasToken () const;

    /**
     * Returns the value of the member "Token".
     *
     * If the meaning of "Token" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Token"
     */
    inline const ::std::string& getToken () const;

    /**
     * Retrieves the value of the field "Token" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Token".
     */
    inline ::std::string& getTokenMutable ();

    /**
     * Sets the value of the member "Token".
     *
     * If the meaning of "Token" isn't clear, then there should be a description here.
     *
     * @param Token The value which will be set
     */
    inline void setToken (const ::std::string& Token_);

    /**
     * Sets the value of the member "Token".
     *
     * If the meaning of "Token" isn't clear, then there should be a description here.
     *
     * @param Token The value which will be set
     */
    inline void setToken (const char* Token_);

    /**
     * Sets the value of the member "Token".
     *
     * If the meaning of "Token" isn't clear, then there should be a description here.
     *
     * @param Token The value which will be set
     */
    inline void setToken (const char* value, size_t size);

    static const RenewAccessTokenResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    inline void set_has_Token ();

    inline void clear_has_Token ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::tcu_usb_main_fi_types::T_e8_UserAuthenticationResultType _Result;

    ::std::string _Token;

};

/**
 * The result message of the method "GetAccessToken"
 * This Method is called by some other component to GetAccessToken
 */
class GetAccessTokenResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetAccessTokenResult ();

    /**
     * Copy constructor
     */
    inline  GetAccessTokenResult (const GetAccessTokenResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetAccessTokenResult (::tcu_usb_main_fi_types::T_e8_UserAuthenticationResultType Result_, const ::std::string& Token_);

    /**
     * Destructor
     */
    inline virtual  ~GetAccessTokenResult();

    /**
     * Assignment operator
     */
    inline GetAccessTokenResult& operator = (const GetAccessTokenResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetAccessTokenResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetAccessTokenResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetAccessTokenResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetAccessTokenResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline ::tcu_usb_main_fi_types::T_e8_UserAuthenticationResultType getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (::tcu_usb_main_fi_types::T_e8_UserAuthenticationResultType Result_);

    // API of field "Token"

    static const int kToken = 1;

    /**
     * Clears the field "Token".
     *
     * The field will be set to its default value. The hasToken()
     * method will return false.
     */
    inline void clearToken();

    /**
     * Checks whether the field "Token" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setToken()). Otherwise it will return false.
     */
    inline bool hasToken () const;

    /**
     * Returns the value of the member "Token".
     *
     * If the meaning of "Token" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Token"
     */
    inline const ::std::string& getToken () const;

    /**
     * Retrieves the value of the field "Token" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Token".
     */
    inline ::std::string& getTokenMutable ();

    /**
     * Sets the value of the member "Token".
     *
     * If the meaning of "Token" isn't clear, then there should be a description here.
     *
     * @param Token The value which will be set
     */
    inline void setToken (const ::std::string& Token_);

    /**
     * Sets the value of the member "Token".
     *
     * If the meaning of "Token" isn't clear, then there should be a description here.
     *
     * @param Token The value which will be set
     */
    inline void setToken (const char* Token_);

    /**
     * Sets the value of the member "Token".
     *
     * If the meaning of "Token" isn't clear, then there should be a description here.
     *
     * @param Token The value which will be set
     */
    inline void setToken (const char* value, size_t size);

    static const GetAccessTokenResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    inline void set_has_Token ();

    inline void clear_has_Token ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::tcu_usb_main_fi_types::T_e8_UserAuthenticationResultType _Result;

    ::std::string _Token;

};

/**
 * The status message of the property "NotifyTokenRenewalError"
 * This property is sent to HMI to Display User Credentials screen to get the credentials from user and call validation by credentials method.
 * property to NotifyTokenRenewalError and get user credentials for validation.
 */
class NotifyTokenRenewalErrorStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NotifyTokenRenewalErrorStatus ();

    /**
     * Copy constructor
     */
    inline  NotifyTokenRenewalErrorStatus (const NotifyTokenRenewalErrorStatus &rhs);

    /**
     * All fields constructor
     */
    inline  NotifyTokenRenewalErrorStatus (bool ShowCredentialsScreen_);

    /**
     * Destructor
     */
    inline virtual  ~NotifyTokenRenewalErrorStatus();

    /**
     * Assignment operator
     */
    inline NotifyTokenRenewalErrorStatus& operator = (const NotifyTokenRenewalErrorStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NotifyTokenRenewalErrorStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NotifyTokenRenewalErrorStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NotifyTokenRenewalErrorStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NotifyTokenRenewalErrorStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ShowCredentialsScreen"

    static const int kShowCredentialsScreen = 0;

    /**
     * Clears the field "ShowCredentialsScreen".
     *
     * The field will be set to its default value. The hasShowCredentialsScreen()
     * method will return false.
     */
    inline void clearShowCredentialsScreen();

    /**
     * Checks whether the field "ShowCredentialsScreen" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setShowCredentialsScreen()). Otherwise it will return false.
     */
    inline bool hasShowCredentialsScreen () const;

    /**
     * Returns the value of the member "ShowCredentialsScreen".
     *
     * This shall be true if user credentials are needed for CredentialValidation. When the operation is done the
     * update with value False shall be sent.
     *
     * @return The value of the field "ShowCredentialsScreen"
     */
    inline bool getShowCredentialsScreen () const;

    /**
     * Sets the value of the member "ShowCredentialsScreen".
     *
     * This shall be true if user credentials are needed for CredentialValidation. When the operation is done the
     * update with value False shall be sent.
     *
     * @param ShowCredentialsScreen The value which will be set
     */
    inline void setShowCredentialsScreen (bool ShowCredentialsScreen_);

    static const NotifyTokenRenewalErrorStatus &getDefaultInstance();

private:

    inline void set_has_ShowCredentialsScreen ();

    inline void clear_has_ShowCredentialsScreen ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _ShowCredentialsScreen;

};

/**
 * The start message of the method "ValidateUserCredentialsOnTokenRenewalError"
 * This Method is called by User Auth HMI to ValidateUserCredentials.
 * In case the user cancels, this method should be called with empty strings in parameter.
 * In case the user does not enter credentials and presses ok, this method should not be called.
 * Method start to ValidateUserCredentials
 */
class ValidateUserCredentialsOnTokenRenewalErrorStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ValidateUserCredentialsOnTokenRenewalErrorStart ();

    /**
     * Copy constructor
     */
    inline  ValidateUserCredentialsOnTokenRenewalErrorStart (const ValidateUserCredentialsOnTokenRenewalErrorStart &rhs);

    /**
     * All fields constructor
     */
    inline  ValidateUserCredentialsOnTokenRenewalErrorStart (const ::std::string& sUserId_, const ::std::string& sPassword_);

    /**
     * Destructor
     */
    inline virtual  ~ValidateUserCredentialsOnTokenRenewalErrorStart();

    /**
     * Assignment operator
     */
    inline ValidateUserCredentialsOnTokenRenewalErrorStart& operator = (const ValidateUserCredentialsOnTokenRenewalErrorStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ValidateUserCredentialsOnTokenRenewalErrorStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ValidateUserCredentialsOnTokenRenewalErrorStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ValidateUserCredentialsOnTokenRenewalErrorStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ValidateUserCredentialsOnTokenRenewalErrorStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sUserId"

    static const int kSUserId = 0;

    /**
     * Clears the field "sUserId".
     *
     * The field will be set to its default value. The hasSUserId()
     * method will return false.
     */
    inline void clearSUserId();

    /**
     * Checks whether the field "sUserId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSUserId()). Otherwise it will return false.
     */
    inline bool hasSUserId () const;

    /**
     * Returns the value of the member "sUserId".
     *
     * If the meaning of "sUserId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sUserId"
     */
    inline const ::std::string& getSUserId () const;

    /**
     * Retrieves the value of the field "sUserId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sUserId".
     */
    inline ::std::string& getSUserIdMutable ();

    /**
     * Sets the value of the member "sUserId".
     *
     * If the meaning of "sUserId" isn't clear, then there should be a description here.
     *
     * @param sUserId The value which will be set
     */
    inline void setSUserId (const ::std::string& sUserId_);

    /**
     * Sets the value of the member "sUserId".
     *
     * If the meaning of "sUserId" isn't clear, then there should be a description here.
     *
     * @param sUserId The value which will be set
     */
    inline void setSUserId (const char* sUserId_);

    /**
     * Sets the value of the member "sUserId".
     *
     * If the meaning of "sUserId" isn't clear, then there should be a description here.
     *
     * @param sUserId The value which will be set
     */
    inline void setSUserId (const char* value, size_t size);

    // API of field "sPassword"

    static const int kSPassword = 1;

    /**
     * Clears the field "sPassword".
     *
     * The field will be set to its default value. The hasSPassword()
     * method will return false.
     */
    inline void clearSPassword();

    /**
     * Checks whether the field "sPassword" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPassword()). Otherwise it will return false.
     */
    inline bool hasSPassword () const;

    /**
     * Returns the value of the member "sPassword".
     *
     * If the meaning of "sPassword" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sPassword"
     */
    inline const ::std::string& getSPassword () const;

    /**
     * Retrieves the value of the field "sPassword" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sPassword".
     */
    inline ::std::string& getSPasswordMutable ();

    /**
     * Sets the value of the member "sPassword".
     *
     * If the meaning of "sPassword" isn't clear, then there should be a description here.
     *
     * @param sPassword The value which will be set
     */
    inline void setSPassword (const ::std::string& sPassword_);

    /**
     * Sets the value of the member "sPassword".
     *
     * If the meaning of "sPassword" isn't clear, then there should be a description here.
     *
     * @param sPassword The value which will be set
     */
    inline void setSPassword (const char* sPassword_);

    /**
     * Sets the value of the member "sPassword".
     *
     * If the meaning of "sPassword" isn't clear, then there should be a description here.
     *
     * @param sPassword The value which will be set
     */
    inline void setSPassword (const char* value, size_t size);

    static const ValidateUserCredentialsOnTokenRenewalErrorStart &getDefaultInstance();

private:

    inline void set_has_sUserId ();

    inline void clear_has_sUserId ();

    inline void set_has_sPassword ();

    inline void clear_has_sPassword ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _sUserId;

    ::std::string _sPassword;

};

/**
 * The result message of the method "ValidateUserCredentialsOnTokenRenewalError"
 * This Method is called by User Auth HMI to ValidateUserCredentials.
 * In case the user cancels, this method should be called with empty strings in parameter.
 * In case the user does not enter credentials and presses ok, this method should not be called.
 */
class ValidateUserCredentialsOnTokenRenewalErrorResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ValidateUserCredentialsOnTokenRenewalErrorResult ();

    /**
     * Copy constructor
     */
    inline  ValidateUserCredentialsOnTokenRenewalErrorResult (const ValidateUserCredentialsOnTokenRenewalErrorResult &rhs);

    /**
     * All fields constructor
     */
    inline  ValidateUserCredentialsOnTokenRenewalErrorResult (::tcu_usb_main_fi_types::T_e8_UserAuthenticationResultType Result_);

    /**
     * Destructor
     */
    inline virtual  ~ValidateUserCredentialsOnTokenRenewalErrorResult();

    /**
     * Assignment operator
     */
    inline ValidateUserCredentialsOnTokenRenewalErrorResult& operator = (const ValidateUserCredentialsOnTokenRenewalErrorResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ValidateUserCredentialsOnTokenRenewalErrorResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ValidateUserCredentialsOnTokenRenewalErrorResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ValidateUserCredentialsOnTokenRenewalErrorResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ValidateUserCredentialsOnTokenRenewalErrorResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline ::tcu_usb_main_fi_types::T_e8_UserAuthenticationResultType getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (::tcu_usb_main_fi_types::T_e8_UserAuthenticationResultType Result_);

    static const ValidateUserCredentialsOnTokenRenewalErrorResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_usb_main_fi_types::T_e8_UserAuthenticationResultType _Result;

};

/**
 * The result message of the method "CancelUserValidationRenewToken"
 * This Method is called by some other component to Cancel an already placed user authentication request.
 */
class CancelUserValidationRenewTokenResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CancelUserValidationRenewTokenResult ();

    /**
     * Copy constructor
     */
    inline  CancelUserValidationRenewTokenResult (const CancelUserValidationRenewTokenResult &rhs);

    /**
     * All fields constructor
     */
    inline  CancelUserValidationRenewTokenResult (::tcu_usb_main_fi_types::T_e8_UserAuthenticationResultType Result_);

    /**
     * Destructor
     */
    inline virtual  ~CancelUserValidationRenewTokenResult();

    /**
     * Assignment operator
     */
    inline CancelUserValidationRenewTokenResult& operator = (const CancelUserValidationRenewTokenResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CancelUserValidationRenewTokenResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CancelUserValidationRenewTokenResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CancelUserValidationRenewTokenResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CancelUserValidationRenewTokenResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline ::tcu_usb_main_fi_types::T_e8_UserAuthenticationResultType getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (::tcu_usb_main_fi_types::T_e8_UserAuthenticationResultType Result_);

    static const CancelUserValidationRenewTokenResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_usb_main_fi_types::T_e8_UserAuthenticationResultType _Result;

};

/**
 * The start message of the method "DecodeIdToken"
 * This Method is called by some other component to get the decoded Id_token in json format.
 * Method start to get decoded IdToken.
 */
class DecodeIdTokenStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DecodeIdTokenStart ();

    /**
     * Copy constructor
     */
    inline  DecodeIdTokenStart (const DecodeIdTokenStart &rhs);

    /**
     * All fields constructor
     */
    inline  DecodeIdTokenStart (const ::std::string& Token_);

    /**
     * Destructor
     */
    inline virtual  ~DecodeIdTokenStart();

    /**
     * Assignment operator
     */
    inline DecodeIdTokenStart& operator = (const DecodeIdTokenStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DecodeIdTokenStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DecodeIdTokenStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DecodeIdTokenStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DecodeIdTokenStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Token"

    static const int kToken = 0;

    /**
     * Clears the field "Token".
     *
     * The field will be set to its default value. The hasToken()
     * method will return false.
     */
    inline void clearToken();

    /**
     * Checks whether the field "Token" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setToken()). Otherwise it will return false.
     */
    inline bool hasToken () const;

    /**
     * Returns the value of the member "Token".
     *
     * Token that needs to be decoded.
     *
     * @return The value of the field "Token"
     */
    inline const ::std::string& getToken () const;

    /**
     * Retrieves the value of the field "Token" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Token".
     */
    inline ::std::string& getTokenMutable ();

    /**
     * Sets the value of the member "Token".
     *
     * Token that needs to be decoded.
     *
     * @param Token The value which will be set
     */
    inline void setToken (const ::std::string& Token_);

    /**
     * Sets the value of the member "Token".
     *
     * Token that needs to be decoded.
     *
     * @param Token The value which will be set
     */
    inline void setToken (const char* Token_);

    /**
     * Sets the value of the member "Token".
     *
     * Token that needs to be decoded.
     *
     * @param Token The value which will be set
     */
    inline void setToken (const char* value, size_t size);

    static const DecodeIdTokenStart &getDefaultInstance();

private:

    inline void set_has_Token ();

    inline void clear_has_Token ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _Token;

};

/**
 * The result message of the method "DecodeIdToken"
 * This Method is called by some other component to get the decoded Id_token in json format.
 */
class DecodeIdTokenResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DecodeIdTokenResult ();

    /**
     * Copy constructor
     */
    inline  DecodeIdTokenResult (const DecodeIdTokenResult &rhs);

    /**
     * All fields constructor
     */
    inline  DecodeIdTokenResult (const ::tcu_usb_main_fi_types::T_usb_tcu_UserAuthentication_DecodedToken_Info& Result_);

    /**
     * Destructor
     */
    inline virtual  ~DecodeIdTokenResult();

    /**
     * Assignment operator
     */
    inline DecodeIdTokenResult& operator = (const DecodeIdTokenResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DecodeIdTokenResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DecodeIdTokenResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DecodeIdTokenResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DecodeIdTokenResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline const ::tcu_usb_main_fi_types::T_usb_tcu_UserAuthentication_DecodedToken_Info& getResult () const;

    /**
     * Retrieves the value of the field "Result" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Result".
     */
    inline ::tcu_usb_main_fi_types::T_usb_tcu_UserAuthentication_DecodedToken_Info& getResultMutable ();

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (const ::tcu_usb_main_fi_types::T_usb_tcu_UserAuthentication_DecodedToken_Info& Result_);

    static const DecodeIdTokenResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_usb_main_fi_types::T_usb_tcu_UserAuthentication_DecodedToken_Info _Result;

};

/**
 * The status message of the property "ConnectedSearchResult"
 * Property update for connected search results
 */
class ConnectedSearchResultStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConnectedSearchResultStatus ();

    /**
     * Copy constructor
     */
    inline  ConnectedSearchResultStatus (const ConnectedSearchResultStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ConnectedSearchResultStatus (const ::tcu_usb_main_fi_types::T_usb_tcu_connected_search_result& ConnectedSearch_, ::tcu_usb_main_fi_types::T_e8_ConnectedSearchServiceType ServiceType_, ::tcu_usb_main_fi_types::T_e8_tcu_ExecType u8ExecType_);

    /**
     * Destructor
     */
    inline virtual  ~ConnectedSearchResultStatus();

    /**
     * Assignment operator
     */
    inline ConnectedSearchResultStatus& operator = (const ConnectedSearchResultStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConnectedSearchResultStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConnectedSearchResultStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConnectedSearchResultStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConnectedSearchResultStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ConnectedSearch"

    static const int kConnectedSearch = 0;

    /**
     * Clears the field "ConnectedSearch".
     *
     * The field will be set to its default value. The hasConnectedSearch()
     * method will return false.
     */
    inline void clearConnectedSearch();

    /**
     * Checks whether the field "ConnectedSearch" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConnectedSearch()). Otherwise it will return false.
     */
    inline bool hasConnectedSearch () const;

    /**
     * Returns the value of the member "ConnectedSearch".
     *
     *
     *
     * @return The value of the field "ConnectedSearch"
     */
    inline const ::tcu_usb_main_fi_types::T_usb_tcu_connected_search_result& getConnectedSearch () const;

    /**
     * Retrieves the value of the field "ConnectedSearch" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ConnectedSearch".
     */
    inline ::tcu_usb_main_fi_types::T_usb_tcu_connected_search_result& getConnectedSearchMutable ();

    /**
     * Sets the value of the member "ConnectedSearch".
     *
     *
     *
     * @param ConnectedSearch The value which will be set
     */
    inline void setConnectedSearch (const ::tcu_usb_main_fi_types::T_usb_tcu_connected_search_result& ConnectedSearch_);

    // API of field "ServiceType"

    static const int kServiceType = 1;

    /**
     * Clears the field "ServiceType".
     *
     * The field will be set to its default value. The hasServiceType()
     * method will return false.
     */
    inline void clearServiceType();

    /**
     * Checks whether the field "ServiceType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setServiceType()). Otherwise it will return false.
     */
    inline bool hasServiceType () const;

    /**
     * Returns the value of the member "ServiceType".
     *
     * Describes the service type for this property update.
     *
     * @return The value of the field "ServiceType"
     */
    inline ::tcu_usb_main_fi_types::T_e8_ConnectedSearchServiceType getServiceType () const;

    /**
     * Sets the value of the member "ServiceType".
     *
     * Describes the service type for this property update.
     *
     * @param ServiceType The value which will be set
     */
    inline void setServiceType (::tcu_usb_main_fi_types::T_e8_ConnectedSearchServiceType ServiceType_);

    // API of field "u8ExecType"

    static const int kU8ExecType = 2;

    /**
     * Clears the field "u8ExecType".
     *
     * The field will be set to its default value. The hasU8ExecType()
     * method will return false.
     */
    inline void clearU8ExecType();

    /**
     * Checks whether the field "u8ExecType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8ExecType()). Otherwise it will return false.
     */
    inline bool hasU8ExecType () const;

    /**
     * Returns the value of the member "u8ExecType".
     *
     * Describes the exec type for search result. Applicable only for ITG5's IVR. More details ITG5-11495.
     *
     * @return The value of the field "u8ExecType"
     */
    inline ::tcu_usb_main_fi_types::T_e8_tcu_ExecType getU8ExecType () const;

    /**
     * Sets the value of the member "u8ExecType".
     *
     * Describes the exec type for search result. Applicable only for ITG5's IVR. More details ITG5-11495.
     *
     * @param u8ExecType The value which will be set
     */
    inline void setU8ExecType (::tcu_usb_main_fi_types::T_e8_tcu_ExecType u8ExecType_);

    static const ConnectedSearchResultStatus &getDefaultInstance();

private:

    inline void set_has_ConnectedSearch ();

    inline void clear_has_ConnectedSearch ();

    inline void set_has_ServiceType ();

    inline void clear_has_ServiceType ();

    inline void set_has_u8ExecType ();

    inline void clear_has_u8ExecType ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::tcu_usb_main_fi_types::T_usb_tcu_connected_search_result _ConnectedSearch;

    ::tcu_usb_main_fi_types::T_e8_ConnectedSearchServiceType _ServiceType;

    ::tcu_usb_main_fi_types::T_e8_tcu_ExecType _u8ExecType;

};

/**
 * The error message of 'ConnectedSearchResult'
 */
class ConnectedSearchResultErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  ConnectedSearchResultErrorStructure ();

    /**
     * Copy constructor
     */
    inline  ConnectedSearchResultErrorStructure (const ConnectedSearchResultErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  ConnectedSearchResultErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~ConnectedSearchResultErrorStructure();

    /**
     * Assignment operator
     */
    inline ConnectedSearchResultErrorStructure& operator = (const ConnectedSearchResultErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConnectedSearchResultErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConnectedSearchResultErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConnectedSearchResultErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConnectedSearchResultErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const ConnectedSearchResultErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'ConnectedSearchResult'
 */
class ConnectedSearchResultError  : public ::asf::core::Payload {
public:

    enum ConnectedSearchResultErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  ConnectedSearchResultError ();

   /**
     * Copy constructor
     */
    inline  ConnectedSearchResultError (const ConnectedSearchResultError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~ConnectedSearchResultError();

    /**
     * Assigns a new value to this object.
     */
    inline ConnectedSearchResultError& operator = (const ConnectedSearchResultError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConnectedSearchResultError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConnectedSearchResultError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConnectedSearchResultError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConnectedSearchResultError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline ConnectedSearchResultError::ConnectedSearchResultErrorField getField () const;

    inline void setField(ConnectedSearchResultError::ConnectedSearchResultErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "ConnectedSearchResultErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "ConnectedSearchResultErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ConnectedSearchResultErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ConnectedSearchResultErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline ConnectedSearchResultErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (ConnectedSearchResultErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "ConnectedSearchResultErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const ConnectedSearchResultErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const ConnectedSearchResultError &getDefaultInstance();

private:

    inline void cloneData (const ConnectedSearchResultError& rhs);

    inline void deleteData ();

    ConnectedSearchResultErrorField __field;

    union {
        ConnectedSearchResultErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "ChannelMasterData"
 * Set Channel Master Data
 */
class ChannelMasterDataStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ChannelMasterDataStatus ();

    /**
     * Copy constructor
     */
    inline  ChannelMasterDataStatus (const ChannelMasterDataStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ChannelMasterDataStatus (const ::tcu_usb_main_fi_types::T_usb_tcu_channel_master_data& ChannelMasterData_);

    /**
     * Destructor
     */
    inline virtual  ~ChannelMasterDataStatus();

    /**
     * Assignment operator
     */
    inline ChannelMasterDataStatus& operator = (const ChannelMasterDataStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChannelMasterDataStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChannelMasterDataStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChannelMasterDataStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChannelMasterDataStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ChannelMasterData"

    static const int kChannelMasterData = 0;

    /**
     * Clears the field "ChannelMasterData".
     *
     * The field will be set to its default value. The hasChannelMasterData()
     * method will return false.
     */
    inline void clearChannelMasterData();

    /**
     * Checks whether the field "ChannelMasterData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelMasterData()). Otherwise it will return false.
     */
    inline bool hasChannelMasterData () const;

    /**
     * Returns the value of the member "ChannelMasterData".
     *
     * The channel master data information
     *
     * @return The value of the field "ChannelMasterData"
     */
    inline const ::tcu_usb_main_fi_types::T_usb_tcu_channel_master_data& getChannelMasterData () const;

    /**
     * Retrieves the value of the field "ChannelMasterData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ChannelMasterData".
     */
    inline ::tcu_usb_main_fi_types::T_usb_tcu_channel_master_data& getChannelMasterDataMutable ();

    /**
     * Sets the value of the member "ChannelMasterData".
     *
     * The channel master data information
     *
     * @param ChannelMasterData The value which will be set
     */
    inline void setChannelMasterData (const ::tcu_usb_main_fi_types::T_usb_tcu_channel_master_data& ChannelMasterData_);

    static const ChannelMasterDataStatus &getDefaultInstance();

private:

    inline void set_has_ChannelMasterData ();

    inline void clear_has_ChannelMasterData ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_usb_main_fi_types::T_usb_tcu_channel_master_data _ChannelMasterData;

};

/**
 * The status message of the property "TtsAudioStateRequest"
 * Request TtsAudio channel state
 */
class TtsAudioStateRequestStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TtsAudioStateRequestStatus ();

    /**
     * Copy constructor
     */
    inline  TtsAudioStateRequestStatus (const TtsAudioStateRequestStatus &rhs);

    /**
     * All fields constructor
     */
    inline  TtsAudioStateRequestStatus (::tcu_usb_main_fi_types::T_e8_tcu_AudioActivity AudioActivity_);

    /**
     * Destructor
     */
    inline virtual  ~TtsAudioStateRequestStatus();

    /**
     * Assignment operator
     */
    inline TtsAudioStateRequestStatus& operator = (const TtsAudioStateRequestStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TtsAudioStateRequestStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TtsAudioStateRequestStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TtsAudioStateRequestStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TtsAudioStateRequestStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AudioActivity"

    static const int kAudioActivity = 0;

    /**
     * Clears the field "AudioActivity".
     *
     * The field will be set to its default value. The hasAudioActivity()
     * method will return false.
     */
    inline void clearAudioActivity();

    /**
     * Checks whether the field "AudioActivity" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudioActivity()). Otherwise it will return false.
     */
    inline bool hasAudioActivity () const;

    /**
     * Returns the value of the member "AudioActivity".
     *
     * Requested Audio State
     *
     * @return The value of the field "AudioActivity"
     */
    inline ::tcu_usb_main_fi_types::T_e8_tcu_AudioActivity getAudioActivity () const;

    /**
     * Sets the value of the member "AudioActivity".
     *
     * Requested Audio State
     *
     * @param AudioActivity The value which will be set
     */
    inline void setAudioActivity (::tcu_usb_main_fi_types::T_e8_tcu_AudioActivity AudioActivity_);

    static const TtsAudioStateRequestStatus &getDefaultInstance();

private:

    inline void set_has_AudioActivity ();

    inline void clear_has_AudioActivity ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_usb_main_fi_types::T_e8_tcu_AudioActivity _AudioActivity;

};

/**
 * The status message of the property "DatabaseStatus"
 * This property gives the information about the availability of USB TCU database.
 * This property updates the database availablity.
 */
class DatabaseStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DatabaseStatusStatus ();

    /**
     * Copy constructor
     */
    inline  DatabaseStatusStatus (const DatabaseStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DatabaseStatusStatus (::tcu_usb_main_fi_types::T_e8_DatabaseStatus DatabaseStatus_, const ::std::string& Databasepath_, ::tcu_usb_main_fi_types::T_e8_DatabaseServiceType DatabaseServiceType_, bool PopupEnabled_);

    /**
     * Destructor
     */
    inline virtual  ~DatabaseStatusStatus();

    /**
     * Assignment operator
     */
    inline DatabaseStatusStatus& operator = (const DatabaseStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DatabaseStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DatabaseStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DatabaseStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DatabaseStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DatabaseStatus"

    static const int kDatabaseStatus = 0;

    /**
     * Clears the field "DatabaseStatus".
     *
     * The field will be set to its default value. The hasDatabaseStatus()
     * method will return false.
     */
    inline void clearDatabaseStatus();

    /**
     * Checks whether the field "DatabaseStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDatabaseStatus()). Otherwise it will return false.
     */
    inline bool hasDatabaseStatus () const;

    /**
     * Returns the value of the member "DatabaseStatus".
     *
     * Current Database state.
     *
     * @return The value of the field "DatabaseStatus"
     */
    inline ::tcu_usb_main_fi_types::T_e8_DatabaseStatus getDatabaseStatus () const;

    /**
     * Sets the value of the member "DatabaseStatus".
     *
     * Current Database state.
     *
     * @param DatabaseStatus The value which will be set
     */
    inline void setDatabaseStatus (::tcu_usb_main_fi_types::T_e8_DatabaseStatus DatabaseStatus_);

    // API of field "Databasepath"

    static const int kDatabasepath = 1;

    /**
     * Clears the field "Databasepath".
     *
     * The field will be set to its default value. The hasDatabasepath()
     * method will return false.
     */
    inline void clearDatabasepath();

    /**
     * Checks whether the field "Databasepath" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDatabasepath()). Otherwise it will return false.
     */
    inline bool hasDatabasepath () const;

    /**
     * Returns the value of the member "Databasepath".
     *
     * Database path
     *
     * @return The value of the field "Databasepath"
     */
    inline const ::std::string& getDatabasepath () const;

    /**
     * Retrieves the value of the field "Databasepath" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Databasepath".
     */
    inline ::std::string& getDatabasepathMutable ();

    /**
     * Sets the value of the member "Databasepath".
     *
     * Database path
     *
     * @param Databasepath The value which will be set
     */
    inline void setDatabasepath (const ::std::string& Databasepath_);

    /**
     * Sets the value of the member "Databasepath".
     *
     * Database path
     *
     * @param Databasepath The value which will be set
     */
    inline void setDatabasepath (const char* Databasepath_);

    /**
     * Sets the value of the member "Databasepath".
     *
     * Database path
     *
     * @param Databasepath The value which will be set
     */
    inline void setDatabasepath (const char* value, size_t size);

    // API of field "DatabaseServiceType"

    static const int kDatabaseServiceType = 2;

    /**
     * Clears the field "DatabaseServiceType".
     *
     * The field will be set to its default value. The hasDatabaseServiceType()
     * method will return false.
     */
    inline void clearDatabaseServiceType();

    /**
     * Checks whether the field "DatabaseServiceType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDatabaseServiceType()). Otherwise it will return false.
     */
    inline bool hasDatabaseServiceType () const;

    /**
     * Returns the value of the member "DatabaseServiceType".
     *
     * This is an enumeration value describing the service type for the current DB operation.
     *
     * @return The value of the field "DatabaseServiceType"
     */
    inline ::tcu_usb_main_fi_types::T_e8_DatabaseServiceType getDatabaseServiceType () const;

    /**
     * Sets the value of the member "DatabaseServiceType".
     *
     * This is an enumeration value describing the service type for the current DB operation.
     *
     * @param DatabaseServiceType The value which will be set
     */
    inline void setDatabaseServiceType (::tcu_usb_main_fi_types::T_e8_DatabaseServiceType DatabaseServiceType_);

    // API of field "PopupEnabled"

    static const int kPopupEnabled = 3;

    /**
     * Clears the field "PopupEnabled".
     *
     * The field will be set to its default value. The hasPopupEnabled()
     * method will return false.
     */
    inline void clearPopupEnabled();

    /**
     * Checks whether the field "PopupEnabled" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPopupEnabled()). Otherwise it will return false.
     */
    inline bool hasPopupEnabled () const;

    /**
     * Returns the value of the member "PopupEnabled".
     *
     * This shall be true if (Msg==IVM and Download==1st download). In HMI if this is set SMS_Notification
     * popup shall be shown.
     *
     * @return The value of the field "PopupEnabled"
     */
    inline bool getPopupEnabled () const;

    /**
     * Sets the value of the member "PopupEnabled".
     *
     * This shall be true if (Msg==IVM and Download==1st download). In HMI if this is set SMS_Notification
     * popup shall be shown.
     *
     * @param PopupEnabled The value which will be set
     */
    inline void setPopupEnabled (bool PopupEnabled_);

    static const DatabaseStatusStatus &getDefaultInstance();

private:

    inline void set_has_DatabaseStatus ();

    inline void clear_has_DatabaseStatus ();

    inline void set_has_Databasepath ();

    inline void clear_has_Databasepath ();

    inline void set_has_DatabaseServiceType ();

    inline void clear_has_DatabaseServiceType ();

    inline void set_has_PopupEnabled ();

    inline void clear_has_PopupEnabled ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::tcu_usb_main_fi_types::T_e8_DatabaseStatus _DatabaseStatus;

    ::std::string _Databasepath;

    ::tcu_usb_main_fi_types::T_e8_DatabaseServiceType _DatabaseServiceType;

    bool _PopupEnabled;

};

/**
 * The error message of 'DatabaseStatus'
 * Error Message
 */
class DatabaseStatusErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DatabaseStatusErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DatabaseStatusErrorStructure (const DatabaseStatusErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DatabaseStatusErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~DatabaseStatusErrorStructure();

    /**
     * Assignment operator
     */
    inline DatabaseStatusErrorStructure& operator = (const DatabaseStatusErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DatabaseStatusErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DatabaseStatusErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DatabaseStatusErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DatabaseStatusErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const DatabaseStatusErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'DatabaseStatus'
 * Error Message
 */
class DatabaseStatusError  : public ::asf::core::Payload {
public:

    enum DatabaseStatusErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DatabaseStatusError ();

   /**
     * Copy constructor
     */
    inline  DatabaseStatusError (const DatabaseStatusError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DatabaseStatusError();

    /**
     * Assigns a new value to this object.
     */
    inline DatabaseStatusError& operator = (const DatabaseStatusError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DatabaseStatusError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DatabaseStatusError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DatabaseStatusError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DatabaseStatusError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DatabaseStatusError::DatabaseStatusErrorField getField () const;

    inline void setField(DatabaseStatusError::DatabaseStatusErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DatabaseStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DatabaseStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DatabaseStatusErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DatabaseStatusErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DatabaseStatusErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DatabaseStatusErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DatabaseStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DatabaseStatusErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DatabaseStatusError &getDefaultInstance();

private:

    inline void cloneData (const DatabaseStatusError& rhs);

    inline void deleteData ();

    DatabaseStatusErrorField __field;

    union {
        DatabaseStatusErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "DataConnectionStatus"
 * This property gives the information about the data connection to backend status (active or inactive).
 * This property updates the data connection availability.
 */
class DataConnectionStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DataConnectionStatusStatus ();

    /**
     * Copy constructor
     */
    inline  DataConnectionStatusStatus (const DataConnectionStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DataConnectionStatusStatus (::tcu_usb_main_fi_types::T_e8_DataConnectionStatus DataConnectionStatus_);

    /**
     * Destructor
     */
    inline virtual  ~DataConnectionStatusStatus();

    /**
     * Assignment operator
     */
    inline DataConnectionStatusStatus& operator = (const DataConnectionStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DataConnectionStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DataConnectionStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DataConnectionStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DataConnectionStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DataConnectionStatus"

    static const int kDataConnectionStatus = 0;

    /**
     * Clears the field "DataConnectionStatus".
     *
     * The field will be set to its default value. The hasDataConnectionStatus()
     * method will return false.
     */
    inline void clearDataConnectionStatus();

    /**
     * Checks whether the field "DataConnectionStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDataConnectionStatus()). Otherwise it will return false.
     */
    inline bool hasDataConnectionStatus () const;

    /**
     * Returns the value of the member "DataConnectionStatus".
     *
     * Current data connection state.
     *
     * @return The value of the field "DataConnectionStatus"
     */
    inline ::tcu_usb_main_fi_types::T_e8_DataConnectionStatus getDataConnectionStatus () const;

    /**
     * Sets the value of the member "DataConnectionStatus".
     *
     * Current data connection state.
     *
     * @param DataConnectionStatus The value which will be set
     */
    inline void setDataConnectionStatus (::tcu_usb_main_fi_types::T_e8_DataConnectionStatus DataConnectionStatus_);

    static const DataConnectionStatusStatus &getDefaultInstance();

private:

    inline void set_has_DataConnectionStatus ();

    inline void clear_has_DataConnectionStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_usb_main_fi_types::T_e8_DataConnectionStatus _DataConnectionStatus;

};

/**
 * The error message of 'DataConnectionStatus'
 * Error Message
 */
class DataConnectionStatusErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DataConnectionStatusErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DataConnectionStatusErrorStructure (const DataConnectionStatusErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DataConnectionStatusErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~DataConnectionStatusErrorStructure();

    /**
     * Assignment operator
     */
    inline DataConnectionStatusErrorStructure& operator = (const DataConnectionStatusErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DataConnectionStatusErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DataConnectionStatusErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DataConnectionStatusErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DataConnectionStatusErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const DataConnectionStatusErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'DataConnectionStatus'
 * Error Message
 */
class DataConnectionStatusError  : public ::asf::core::Payload {
public:

    enum DataConnectionStatusErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DataConnectionStatusError ();

   /**
     * Copy constructor
     */
    inline  DataConnectionStatusError (const DataConnectionStatusError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DataConnectionStatusError();

    /**
     * Assigns a new value to this object.
     */
    inline DataConnectionStatusError& operator = (const DataConnectionStatusError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DataConnectionStatusError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DataConnectionStatusError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DataConnectionStatusError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DataConnectionStatusError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DataConnectionStatusError::DataConnectionStatusErrorField getField () const;

    inline void setField(DataConnectionStatusError::DataConnectionStatusErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DataConnectionStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DataConnectionStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DataConnectionStatusErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DataConnectionStatusErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DataConnectionStatusErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DataConnectionStatusErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DataConnectionStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DataConnectionStatusErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DataConnectionStatusError &getDefaultInstance();

private:

    inline void cloneData (const DataConnectionStatusError& rhs);

    inline void deleteData ();

    DataConnectionStatusErrorField __field;

    union {
        DataConnectionStatusErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "DataConnectionError"
 * This property gives the information about the data connection error type.
 * This property updates the data connection error type.
 */
class DataConnectionErrorStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DataConnectionErrorStatus ();

    /**
     * Copy constructor
     */
    inline  DataConnectionErrorStatus (const DataConnectionErrorStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DataConnectionErrorStatus (::tcu_usb_main_fi_types::T_e16_DataConnectionError DataConnectionError_, ::tcu_usb_main_fi_types::T_e8_ServiceType ServiceType_);

    /**
     * Destructor
     */
    inline virtual  ~DataConnectionErrorStatus();

    /**
     * Assignment operator
     */
    inline DataConnectionErrorStatus& operator = (const DataConnectionErrorStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DataConnectionErrorStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DataConnectionErrorStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DataConnectionErrorStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DataConnectionErrorStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DataConnectionError"

    static const int kDataConnectionError = 0;

    /**
     * Clears the field "DataConnectionError".
     *
     * The field will be set to its default value. The hasDataConnectionError()
     * method will return false.
     */
    inline void clearDataConnectionError();

    /**
     * Checks whether the field "DataConnectionError" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDataConnectionError()). Otherwise it will return false.
     */
    inline bool hasDataConnectionError () const;

    /**
     * Returns the value of the member "DataConnectionError".
     *
     * Data connection error state.
     *
     * @return The value of the field "DataConnectionError"
     */
    inline ::tcu_usb_main_fi_types::T_e16_DataConnectionError getDataConnectionError () const;

    /**
     * Sets the value of the member "DataConnectionError".
     *
     * Data connection error state.
     *
     * @param DataConnectionError The value which will be set
     */
    inline void setDataConnectionError (::tcu_usb_main_fi_types::T_e16_DataConnectionError DataConnectionError_);

    // API of field "ServiceType"

    static const int kServiceType = 1;

    /**
     * Clears the field "ServiceType".
     *
     * The field will be set to its default value. The hasServiceType()
     * method will return false.
     */
    inline void clearServiceType();

    /**
     * Checks whether the field "ServiceType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setServiceType()). Otherwise it will return false.
     */
    inline bool hasServiceType () const;

    /**
     * Returns the value of the member "ServiceType".
     *
     * Service request in which Data connection error has occurred. Currently this field used to show retry popup in case of error during POI download via operator call. This may be extended to other services as well in the future.
     *
     * @return The value of the field "ServiceType"
     */
    inline ::tcu_usb_main_fi_types::T_e8_ServiceType getServiceType () const;

    /**
     * Sets the value of the member "ServiceType".
     *
     * Service request in which Data connection error has occurred. Currently this field used to show retry popup in case of error during POI download via operator call. This may be extended to other services as well in the future.
     *
     * @param ServiceType The value which will be set
     */
    inline void setServiceType (::tcu_usb_main_fi_types::T_e8_ServiceType ServiceType_);

    static const DataConnectionErrorStatus &getDefaultInstance();

private:

    inline void set_has_DataConnectionError ();

    inline void clear_has_DataConnectionError ();

    inline void set_has_ServiceType ();

    inline void clear_has_ServiceType ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::tcu_usb_main_fi_types::T_e16_DataConnectionError _DataConnectionError;

    ::tcu_usb_main_fi_types::T_e8_ServiceType _ServiceType;

};

/**
 * The error message of 'DataConnectionError'
 * Error Message
 */
class DataConnectionErrorErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DataConnectionErrorErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DataConnectionErrorErrorStructure (const DataConnectionErrorErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DataConnectionErrorErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~DataConnectionErrorErrorStructure();

    /**
     * Assignment operator
     */
    inline DataConnectionErrorErrorStructure& operator = (const DataConnectionErrorErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DataConnectionErrorErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DataConnectionErrorErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DataConnectionErrorErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DataConnectionErrorErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const DataConnectionErrorErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'DataConnectionError'
 * Error Message
 */
class DataConnectionErrorError  : public ::asf::core::Payload {
public:

    enum DataConnectionErrorErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DataConnectionErrorError ();

   /**
     * Copy constructor
     */
    inline  DataConnectionErrorError (const DataConnectionErrorError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DataConnectionErrorError();

    /**
     * Assigns a new value to this object.
     */
    inline DataConnectionErrorError& operator = (const DataConnectionErrorError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DataConnectionErrorError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DataConnectionErrorError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DataConnectionErrorError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DataConnectionErrorError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DataConnectionErrorError::DataConnectionErrorErrorField getField () const;

    inline void setField(DataConnectionErrorError::DataConnectionErrorErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DataConnectionErrorErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DataConnectionErrorErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DataConnectionErrorErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DataConnectionErrorErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DataConnectionErrorErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DataConnectionErrorErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DataConnectionErrorErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DataConnectionErrorErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DataConnectionErrorError &getDefaultInstance();

private:

    inline void cloneData (const DataConnectionErrorError& rhs);

    inline void deleteData ();

    DataConnectionErrorErrorField __field;

    union {
        DataConnectionErrorErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "ServerList"
 * This property gives the information about the server list.
 * This property updates the server list.
 */
class ServerListStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ServerListStatus ();

    /**
     * Copy constructor
     */
    inline  ServerListStatus (const ServerListStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ServerListStatus (const ::tcu_usb_main_fi_types::T_usb_tcu_Server_Info_List& ServerInfoList_, uint8 u8ActiveServerId_);

    /**
     * Destructor
     */
    inline virtual  ~ServerListStatus();

    /**
     * Assignment operator
     */
    inline ServerListStatus& operator = (const ServerListStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ServerListStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ServerListStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ServerListStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ServerListStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ServerInfoList"

    static const int kServerInfoList = 0;

    /**
     * Clears the field "ServerInfoList".
     *
     * The field will be set to its default value. The hasServerInfoList()
     * method will return false.
     */
    inline void clearServerInfoList();

    /**
     * Checks whether the field "ServerInfoList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setServerInfoList()). Otherwise it will return false.
     */
    inline bool hasServerInfoList () const;

    /**
     * Returns the value of the member "ServerInfoList".
     *
     * Contains list of server information
     *
     * @return The value of the field "ServerInfoList"
     */
    inline const ::tcu_usb_main_fi_types::T_usb_tcu_Server_Info_List& getServerInfoList () const;

    /**
     * Retrieves the value of the field "ServerInfoList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ServerInfoList".
     */
    inline ::tcu_usb_main_fi_types::T_usb_tcu_Server_Info_List& getServerInfoListMutable ();

    /**
     * Sets the value of the member "ServerInfoList".
     *
     * Contains list of server information
     *
     * @param ServerInfoList The value which will be set
     */
    inline void setServerInfoList (const ::tcu_usb_main_fi_types::T_usb_tcu_Server_Info_List& ServerInfoList_);

    // API of field "u8ActiveServerId"

    static const int kU8ActiveServerId = 1;

    /**
     * Clears the field "u8ActiveServerId".
     *
     * The field will be set to its default value. The hasU8ActiveServerId()
     * method will return false.
     */
    inline void clearU8ActiveServerId();

    /**
     * Checks whether the field "u8ActiveServerId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8ActiveServerId()). Otherwise it will return false.
     */
    inline bool hasU8ActiveServerId () const;

    /**
     * Returns the value of the member "u8ActiveServerId".
     *
     * Currently active server id.
     *
     * @return The value of the field "u8ActiveServerId"
     */
    inline uint8 getU8ActiveServerId () const;

    /**
     * Sets the value of the member "u8ActiveServerId".
     *
     * Currently active server id.
     *
     * @param u8ActiveServerId The value which will be set
     */
    inline void setU8ActiveServerId (uint8 u8ActiveServerId_);

    static const ServerListStatus &getDefaultInstance();

private:

    static const ::std::vector< ::tcu_usb_main_fi_types::T_usb_tcu_Server_Info >& getT_usb_tcu_Server_InfoList_DefaultInstance ();

    inline void set_has_ServerInfoList ();

    inline void clear_has_ServerInfoList ();

    inline void set_has_u8ActiveServerId ();

    inline void clear_has_u8ActiveServerId ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::tcu_usb_main_fi_types::T_usb_tcu_Server_Info_List _ServerInfoList;

    uint8 _u8ActiveServerId;

};

/**
 * The error message of 'ServerList'
 * Error Message
 */
class ServerListErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  ServerListErrorStructure ();

    /**
     * Copy constructor
     */
    inline  ServerListErrorStructure (const ServerListErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  ServerListErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~ServerListErrorStructure();

    /**
     * Assignment operator
     */
    inline ServerListErrorStructure& operator = (const ServerListErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ServerListErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ServerListErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ServerListErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ServerListErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const ServerListErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'ServerList'
 * Error Message
 */
class ServerListError  : public ::asf::core::Payload {
public:

    enum ServerListErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  ServerListError ();

   /**
     * Copy constructor
     */
    inline  ServerListError (const ServerListError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~ServerListError();

    /**
     * Assigns a new value to this object.
     */
    inline ServerListError& operator = (const ServerListError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ServerListError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ServerListError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ServerListError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ServerListError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline ServerListError::ServerListErrorField getField () const;

    inline void setField(ServerListError::ServerListErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "ServerListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "ServerListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ServerListErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ServerListErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline ServerListErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (ServerListErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "ServerListErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const ServerListErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const ServerListError &getDefaultInstance();

private:

    inline void cloneData (const ServerListError& rhs);

    inline void deleteData ();

    ServerListErrorField __field;

    union {
        ServerListErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "TCUDeviceInfo"
 * This property gives the information about TCU Device.
 * This property updates the server list.
 */
class TCUDeviceInfoStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TCUDeviceInfoStatus ();

    /**
     * Copy constructor
     */
    inline  TCUDeviceInfoStatus (const TCUDeviceInfoStatus &rhs);

    /**
     * All fields constructor
     */
    inline  TCUDeviceInfoStatus (const ::tcu_usb_main_fi_types::T_usb_tcu_TCUDevice_Info& TCUDeviceInfo_);

    /**
     * Destructor
     */
    inline virtual  ~TCUDeviceInfoStatus();

    /**
     * Assignment operator
     */
    inline TCUDeviceInfoStatus& operator = (const TCUDeviceInfoStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TCUDeviceInfoStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TCUDeviceInfoStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TCUDeviceInfoStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TCUDeviceInfoStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TCUDeviceInfo"

    static const int kTCUDeviceInfo = 0;

    /**
     * Clears the field "TCUDeviceInfo".
     *
     * The field will be set to its default value. The hasTCUDeviceInfo()
     * method will return false.
     */
    inline void clearTCUDeviceInfo();

    /**
     * Checks whether the field "TCUDeviceInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTCUDeviceInfo()). Otherwise it will return false.
     */
    inline bool hasTCUDeviceInfo () const;

    /**
     * Returns the value of the member "TCUDeviceInfo".
     *
     * Contains list of Device information
     *
     * @return The value of the field "TCUDeviceInfo"
     */
    inline const ::tcu_usb_main_fi_types::T_usb_tcu_TCUDevice_Info& getTCUDeviceInfo () const;

    /**
     * Retrieves the value of the field "TCUDeviceInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TCUDeviceInfo".
     */
    inline ::tcu_usb_main_fi_types::T_usb_tcu_TCUDevice_Info& getTCUDeviceInfoMutable ();

    /**
     * Sets the value of the member "TCUDeviceInfo".
     *
     * Contains list of Device information
     *
     * @param TCUDeviceInfo The value which will be set
     */
    inline void setTCUDeviceInfo (const ::tcu_usb_main_fi_types::T_usb_tcu_TCUDevice_Info& TCUDeviceInfo_);

    static const TCUDeviceInfoStatus &getDefaultInstance();

private:

    inline void set_has_TCUDeviceInfo ();

    inline void clear_has_TCUDeviceInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_usb_main_fi_types::T_usb_tcu_TCUDevice_Info _TCUDeviceInfo;

};

/**
 * The error message of 'TCUDeviceInfo'
 * Error Message
 */
class TCUDeviceInfoErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  TCUDeviceInfoErrorStructure ();

    /**
     * Copy constructor
     */
    inline  TCUDeviceInfoErrorStructure (const TCUDeviceInfoErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  TCUDeviceInfoErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~TCUDeviceInfoErrorStructure();

    /**
     * Assignment operator
     */
    inline TCUDeviceInfoErrorStructure& operator = (const TCUDeviceInfoErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TCUDeviceInfoErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TCUDeviceInfoErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TCUDeviceInfoErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TCUDeviceInfoErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const TCUDeviceInfoErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'TCUDeviceInfo'
 * Error Message
 */
class TCUDeviceInfoError  : public ::asf::core::Payload {
public:

    enum TCUDeviceInfoErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  TCUDeviceInfoError ();

   /**
     * Copy constructor
     */
    inline  TCUDeviceInfoError (const TCUDeviceInfoError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~TCUDeviceInfoError();

    /**
     * Assigns a new value to this object.
     */
    inline TCUDeviceInfoError& operator = (const TCUDeviceInfoError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TCUDeviceInfoError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TCUDeviceInfoError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TCUDeviceInfoError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TCUDeviceInfoError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline TCUDeviceInfoError::TCUDeviceInfoErrorField getField () const;

    inline void setField(TCUDeviceInfoError::TCUDeviceInfoErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "TCUDeviceInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "TCUDeviceInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const TCUDeviceInfoErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline TCUDeviceInfoErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline TCUDeviceInfoErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (TCUDeviceInfoErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "TCUDeviceInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const TCUDeviceInfoErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const TCUDeviceInfoError &getDefaultInstance();

private:

    inline void cloneData (const TCUDeviceInfoError& rhs);

    inline void deleteData ();

    TCUDeviceInfoErrorField __field;

    union {
        TCUDeviceInfoErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "NotifyAutoDownloadInterval"
 * This property gives the information about AutoDownload Interval.
 * This property notifies AutoDownload Interval.
 */
class NotifyAutoDownloadIntervalStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NotifyAutoDownloadIntervalStatus ();

    /**
     * Copy constructor
     */
    inline  NotifyAutoDownloadIntervalStatus (const NotifyAutoDownloadIntervalStatus &rhs);

    /**
     * All fields constructor
     */
    inline  NotifyAutoDownloadIntervalStatus (::tcu_usb_main_fi_types::T_e8_AutoDownloadInterval AutoDownloadInterval_);

    /**
     * Destructor
     */
    inline virtual  ~NotifyAutoDownloadIntervalStatus();

    /**
     * Assignment operator
     */
    inline NotifyAutoDownloadIntervalStatus& operator = (const NotifyAutoDownloadIntervalStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NotifyAutoDownloadIntervalStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NotifyAutoDownloadIntervalStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NotifyAutoDownloadIntervalStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NotifyAutoDownloadIntervalStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AutoDownloadInterval"

    static const int kAutoDownloadInterval = 0;

    /**
     * Clears the field "AutoDownloadInterval".
     *
     * The field will be set to its default value. The hasAutoDownloadInterval()
     * method will return false.
     */
    inline void clearAutoDownloadInterval();

    /**
     * Checks whether the field "AutoDownloadInterval" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAutoDownloadInterval()). Otherwise it will return false.
     */
    inline bool hasAutoDownloadInterval () const;

    /**
     * Returns the value of the member "AutoDownloadInterval".
     *
     * AutoDownload Interval options
     *
     * @return The value of the field "AutoDownloadInterval"
     */
    inline ::tcu_usb_main_fi_types::T_e8_AutoDownloadInterval getAutoDownloadInterval () const;

    /**
     * Sets the value of the member "AutoDownloadInterval".
     *
     * AutoDownload Interval options
     *
     * @param AutoDownloadInterval The value which will be set
     */
    inline void setAutoDownloadInterval (::tcu_usb_main_fi_types::T_e8_AutoDownloadInterval AutoDownloadInterval_);

    static const NotifyAutoDownloadIntervalStatus &getDefaultInstance();

private:

    inline void set_has_AutoDownloadInterval ();

    inline void clear_has_AutoDownloadInterval ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_usb_main_fi_types::T_e8_AutoDownloadInterval _AutoDownloadInterval;

};

/**
 * The error message of 'NotifyAutoDownloadInterval'
 * Error Message
 */
class NotifyAutoDownloadIntervalErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  NotifyAutoDownloadIntervalErrorStructure ();

    /**
     * Copy constructor
     */
    inline  NotifyAutoDownloadIntervalErrorStructure (const NotifyAutoDownloadIntervalErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  NotifyAutoDownloadIntervalErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~NotifyAutoDownloadIntervalErrorStructure();

    /**
     * Assignment operator
     */
    inline NotifyAutoDownloadIntervalErrorStructure& operator = (const NotifyAutoDownloadIntervalErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NotifyAutoDownloadIntervalErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NotifyAutoDownloadIntervalErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NotifyAutoDownloadIntervalErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NotifyAutoDownloadIntervalErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const NotifyAutoDownloadIntervalErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'NotifyAutoDownloadInterval'
 * Error Message
 */
class NotifyAutoDownloadIntervalError  : public ::asf::core::Payload {
public:

    enum NotifyAutoDownloadIntervalErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  NotifyAutoDownloadIntervalError ();

   /**
     * Copy constructor
     */
    inline  NotifyAutoDownloadIntervalError (const NotifyAutoDownloadIntervalError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~NotifyAutoDownloadIntervalError();

    /**
     * Assigns a new value to this object.
     */
    inline NotifyAutoDownloadIntervalError& operator = (const NotifyAutoDownloadIntervalError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NotifyAutoDownloadIntervalError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NotifyAutoDownloadIntervalError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NotifyAutoDownloadIntervalError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NotifyAutoDownloadIntervalError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline NotifyAutoDownloadIntervalError::NotifyAutoDownloadIntervalErrorField getField () const;

    inline void setField(NotifyAutoDownloadIntervalError::NotifyAutoDownloadIntervalErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "NotifyAutoDownloadIntervalErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "NotifyAutoDownloadIntervalErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const NotifyAutoDownloadIntervalErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline NotifyAutoDownloadIntervalErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline NotifyAutoDownloadIntervalErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (NotifyAutoDownloadIntervalErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "NotifyAutoDownloadIntervalErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const NotifyAutoDownloadIntervalErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const NotifyAutoDownloadIntervalError &getDefaultInstance();

private:

    inline void cloneData (const NotifyAutoDownloadIntervalError& rhs);

    inline void deleteData ();

    NotifyAutoDownloadIntervalErrorField __field;

    union {
        NotifyAutoDownloadIntervalErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "GeneralNotificationMessage"
 * This property gives the information about the General Notification Message.
 * This property updates the data connection error type.
 */
class GeneralNotificationMessageStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GeneralNotificationMessageStatus ();

    /**
     * Copy constructor
     */
    inline  GeneralNotificationMessageStatus (const GeneralNotificationMessageStatus &rhs);

    /**
     * All fields constructor
     */
    inline  GeneralNotificationMessageStatus (::tcu_usb_main_fi_types::T_e8_tcu_NotiResult GeneralNotificationResult_, const ::std::string& DisplayMessage_, const ::std::string& TTSTextMessage_);

    /**
     * Destructor
     */
    inline virtual  ~GeneralNotificationMessageStatus();

    /**
     * Assignment operator
     */
    inline GeneralNotificationMessageStatus& operator = (const GeneralNotificationMessageStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GeneralNotificationMessageStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GeneralNotificationMessageStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GeneralNotificationMessageStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GeneralNotificationMessageStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "GeneralNotificationResult"

    static const int kGeneralNotificationResult = 0;

    /**
     * Clears the field "GeneralNotificationResult".
     *
     * The field will be set to its default value. The hasGeneralNotificationResult()
     * method will return false.
     */
    inline void clearGeneralNotificationResult();

    /**
     * Checks whether the field "GeneralNotificationResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGeneralNotificationResult()). Otherwise it will return false.
     */
    inline bool hasGeneralNotificationResult () const;

    /**
     * Returns the value of the member "GeneralNotificationResult".
     *
     * General Notification Result.
     *
     * @return The value of the field "GeneralNotificationResult"
     */
    inline ::tcu_usb_main_fi_types::T_e8_tcu_NotiResult getGeneralNotificationResult () const;

    /**
     * Sets the value of the member "GeneralNotificationResult".
     *
     * General Notification Result.
     *
     * @param GeneralNotificationResult The value which will be set
     */
    inline void setGeneralNotificationResult (::tcu_usb_main_fi_types::T_e8_tcu_NotiResult GeneralNotificationResult_);

    // API of field "DisplayMessage"

    static const int kDisplayMessage = 1;

    /**
     * Clears the field "DisplayMessage".
     *
     * The field will be set to its default value. The hasDisplayMessage()
     * method will return false.
     */
    inline void clearDisplayMessage();

    /**
     * Checks whether the field "DisplayMessage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDisplayMessage()). Otherwise it will return false.
     */
    inline bool hasDisplayMessage () const;

    /**
     * Returns the value of the member "DisplayMessage".
     *
     * Display Message.
     *
     * @return The value of the field "DisplayMessage"
     */
    inline const ::std::string& getDisplayMessage () const;

    /**
     * Retrieves the value of the field "DisplayMessage" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DisplayMessage".
     */
    inline ::std::string& getDisplayMessageMutable ();

    /**
     * Sets the value of the member "DisplayMessage".
     *
     * Display Message.
     *
     * @param DisplayMessage The value which will be set
     */
    inline void setDisplayMessage (const ::std::string& DisplayMessage_);

    /**
     * Sets the value of the member "DisplayMessage".
     *
     * Display Message.
     *
     * @param DisplayMessage The value which will be set
     */
    inline void setDisplayMessage (const char* DisplayMessage_);

    /**
     * Sets the value of the member "DisplayMessage".
     *
     * Display Message.
     *
     * @param DisplayMessage The value which will be set
     */
    inline void setDisplayMessage (const char* value, size_t size);

    // API of field "TTSTextMessage"

    static const int kTTSTextMessage = 2;

    /**
     * Clears the field "TTSTextMessage".
     *
     * The field will be set to its default value. The hasTTSTextMessage()
     * method will return false.
     */
    inline void clearTTSTextMessage();

    /**
     * Checks whether the field "TTSTextMessage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTTSTextMessage()). Otherwise it will return false.
     */
    inline bool hasTTSTextMessage () const;

    /**
     * Returns the value of the member "TTSTextMessage".
     *
     * TTS Text Message.
     *
     * @return The value of the field "TTSTextMessage"
     */
    inline const ::std::string& getTTSTextMessage () const;

    /**
     * Retrieves the value of the field "TTSTextMessage" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TTSTextMessage".
     */
    inline ::std::string& getTTSTextMessageMutable ();

    /**
     * Sets the value of the member "TTSTextMessage".
     *
     * TTS Text Message.
     *
     * @param TTSTextMessage The value which will be set
     */
    inline void setTTSTextMessage (const ::std::string& TTSTextMessage_);

    /**
     * Sets the value of the member "TTSTextMessage".
     *
     * TTS Text Message.
     *
     * @param TTSTextMessage The value which will be set
     */
    inline void setTTSTextMessage (const char* TTSTextMessage_);

    /**
     * Sets the value of the member "TTSTextMessage".
     *
     * TTS Text Message.
     *
     * @param TTSTextMessage The value which will be set
     */
    inline void setTTSTextMessage (const char* value, size_t size);

    static const GeneralNotificationMessageStatus &getDefaultInstance();

private:

    inline void set_has_GeneralNotificationResult ();

    inline void clear_has_GeneralNotificationResult ();

    inline void set_has_DisplayMessage ();

    inline void clear_has_DisplayMessage ();

    inline void set_has_TTSTextMessage ();

    inline void clear_has_TTSTextMessage ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::tcu_usb_main_fi_types::T_e8_tcu_NotiResult _GeneralNotificationResult;

    ::std::string _DisplayMessage;

    ::std::string _TTSTextMessage;

};

/**
 * The error message of 'GeneralNotificationMessage'
 * Error Message
 */
class GeneralNotificationMessageErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GeneralNotificationMessageErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GeneralNotificationMessageErrorStructure (const GeneralNotificationMessageErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GeneralNotificationMessageErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~GeneralNotificationMessageErrorStructure();

    /**
     * Assignment operator
     */
    inline GeneralNotificationMessageErrorStructure& operator = (const GeneralNotificationMessageErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GeneralNotificationMessageErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GeneralNotificationMessageErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GeneralNotificationMessageErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GeneralNotificationMessageErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const GeneralNotificationMessageErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'GeneralNotificationMessage'
 * Error Message
 */
class GeneralNotificationMessageError  : public ::asf::core::Payload {
public:

    enum GeneralNotificationMessageErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GeneralNotificationMessageError ();

   /**
     * Copy constructor
     */
    inline  GeneralNotificationMessageError (const GeneralNotificationMessageError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GeneralNotificationMessageError();

    /**
     * Assigns a new value to this object.
     */
    inline GeneralNotificationMessageError& operator = (const GeneralNotificationMessageError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GeneralNotificationMessageError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GeneralNotificationMessageError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GeneralNotificationMessageError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GeneralNotificationMessageError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GeneralNotificationMessageError::GeneralNotificationMessageErrorField getField () const;

    inline void setField(GeneralNotificationMessageError::GeneralNotificationMessageErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GeneralNotificationMessageErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GeneralNotificationMessageErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GeneralNotificationMessageErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GeneralNotificationMessageErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GeneralNotificationMessageErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GeneralNotificationMessageErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GeneralNotificationMessageErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GeneralNotificationMessageErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GeneralNotificationMessageError &getDefaultInstance();

private:

    inline void cloneData (const GeneralNotificationMessageError& rhs);

    inline void deleteData ();

    GeneralNotificationMessageErrorField __field;

    union {
        GeneralNotificationMessageErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "AuthenticationResultData"
 * This property gives the information about the Authentication Result Data.
 */
class AuthenticationResultDataStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AuthenticationResultDataStatus ();

    /**
     * Copy constructor
     */
    inline  AuthenticationResultDataStatus (const AuthenticationResultDataStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AuthenticationResultDataStatus (const ::std::string& DisplayMessage_, const ::std::string& TTSTextMessage_);

    /**
     * Destructor
     */
    inline virtual  ~AuthenticationResultDataStatus();

    /**
     * Assignment operator
     */
    inline AuthenticationResultDataStatus& operator = (const AuthenticationResultDataStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AuthenticationResultDataStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AuthenticationResultDataStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AuthenticationResultDataStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AuthenticationResultDataStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DisplayMessage"

    static const int kDisplayMessage = 0;

    /**
     * Clears the field "DisplayMessage".
     *
     * The field will be set to its default value. The hasDisplayMessage()
     * method will return false.
     */
    inline void clearDisplayMessage();

    /**
     * Checks whether the field "DisplayMessage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDisplayMessage()). Otherwise it will return false.
     */
    inline bool hasDisplayMessage () const;

    /**
     * Returns the value of the member "DisplayMessage".
     *
     * Display Message.
     *
     * @return The value of the field "DisplayMessage"
     */
    inline const ::std::string& getDisplayMessage () const;

    /**
     * Retrieves the value of the field "DisplayMessage" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DisplayMessage".
     */
    inline ::std::string& getDisplayMessageMutable ();

    /**
     * Sets the value of the member "DisplayMessage".
     *
     * Display Message.
     *
     * @param DisplayMessage The value which will be set
     */
    inline void setDisplayMessage (const ::std::string& DisplayMessage_);

    /**
     * Sets the value of the member "DisplayMessage".
     *
     * Display Message.
     *
     * @param DisplayMessage The value which will be set
     */
    inline void setDisplayMessage (const char* DisplayMessage_);

    /**
     * Sets the value of the member "DisplayMessage".
     *
     * Display Message.
     *
     * @param DisplayMessage The value which will be set
     */
    inline void setDisplayMessage (const char* value, size_t size);

    // API of field "TTSTextMessage"

    static const int kTTSTextMessage = 1;

    /**
     * Clears the field "TTSTextMessage".
     *
     * The field will be set to its default value. The hasTTSTextMessage()
     * method will return false.
     */
    inline void clearTTSTextMessage();

    /**
     * Checks whether the field "TTSTextMessage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTTSTextMessage()). Otherwise it will return false.
     */
    inline bool hasTTSTextMessage () const;

    /**
     * Returns the value of the member "TTSTextMessage".
     *
     * TTS Text Message.
     *
     * @return The value of the field "TTSTextMessage"
     */
    inline const ::std::string& getTTSTextMessage () const;

    /**
     * Retrieves the value of the field "TTSTextMessage" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TTSTextMessage".
     */
    inline ::std::string& getTTSTextMessageMutable ();

    /**
     * Sets the value of the member "TTSTextMessage".
     *
     * TTS Text Message.
     *
     * @param TTSTextMessage The value which will be set
     */
    inline void setTTSTextMessage (const ::std::string& TTSTextMessage_);

    /**
     * Sets the value of the member "TTSTextMessage".
     *
     * TTS Text Message.
     *
     * @param TTSTextMessage The value which will be set
     */
    inline void setTTSTextMessage (const char* TTSTextMessage_);

    /**
     * Sets the value of the member "TTSTextMessage".
     *
     * TTS Text Message.
     *
     * @param TTSTextMessage The value which will be set
     */
    inline void setTTSTextMessage (const char* value, size_t size);

    static const AuthenticationResultDataStatus &getDefaultInstance();

private:

    inline void set_has_DisplayMessage ();

    inline void clear_has_DisplayMessage ();

    inline void set_has_TTSTextMessage ();

    inline void clear_has_TTSTextMessage ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _DisplayMessage;

    ::std::string _TTSTextMessage;

};

/**
 * The error message of 'AuthenticationResultData'
 * Error Message
 */
class AuthenticationResultDataErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  AuthenticationResultDataErrorStructure ();

    /**
     * Copy constructor
     */
    inline  AuthenticationResultDataErrorStructure (const AuthenticationResultDataErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  AuthenticationResultDataErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~AuthenticationResultDataErrorStructure();

    /**
     * Assignment operator
     */
    inline AuthenticationResultDataErrorStructure& operator = (const AuthenticationResultDataErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AuthenticationResultDataErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AuthenticationResultDataErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AuthenticationResultDataErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AuthenticationResultDataErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const AuthenticationResultDataErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'AuthenticationResultData'
 * Error Message
 */
class AuthenticationResultDataError  : public ::asf::core::Payload {
public:

    enum AuthenticationResultDataErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  AuthenticationResultDataError ();

   /**
     * Copy constructor
     */
    inline  AuthenticationResultDataError (const AuthenticationResultDataError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~AuthenticationResultDataError();

    /**
     * Assigns a new value to this object.
     */
    inline AuthenticationResultDataError& operator = (const AuthenticationResultDataError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AuthenticationResultDataError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AuthenticationResultDataError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AuthenticationResultDataError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AuthenticationResultDataError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline AuthenticationResultDataError::AuthenticationResultDataErrorField getField () const;

    inline void setField(AuthenticationResultDataError::AuthenticationResultDataErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "AuthenticationResultDataErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "AuthenticationResultDataErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const AuthenticationResultDataErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline AuthenticationResultDataErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline AuthenticationResultDataErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (AuthenticationResultDataErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "AuthenticationResultDataErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const AuthenticationResultDataErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const AuthenticationResultDataError &getDefaultInstance();

private:

    inline void cloneData (const AuthenticationResultDataError& rhs);

    inline void deleteData ();

    AuthenticationResultDataErrorField __field;

    union {
        AuthenticationResultDataErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "VICSTrafficData"
 * This property gives the information about the VICS Traffic Data.
 */
class VICSTrafficDataStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VICSTrafficDataStatus ();

    /**
     * Copy constructor
     */
    inline  VICSTrafficDataStatus (const VICSTrafficDataStatus &rhs);

    /**
     * All fields constructor
     */
    inline  VICSTrafficDataStatus (const ::std::string& strFilePathWithFileName_, const ::tcu_usb_main_fi_types::T_e8_tcu_VICS_Response_Data& VICSResponseData_);

    /**
     * Destructor
     */
    inline virtual  ~VICSTrafficDataStatus();

    /**
     * Assignment operator
     */
    inline VICSTrafficDataStatus& operator = (const VICSTrafficDataStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VICSTrafficDataStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VICSTrafficDataStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VICSTrafficDataStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VICSTrafficDataStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "strFilePathWithFileName"

    static const int kStrFilePathWithFileName = 0;

    /**
     * Clears the field "strFilePathWithFileName".
     *
     * The field will be set to its default value. The hasStrFilePathWithFileName()
     * method will return false.
     */
    inline void clearStrFilePathWithFileName();

    /**
     * Checks whether the field "strFilePathWithFileName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrFilePathWithFileName()). Otherwise it will return false.
     */
    inline bool hasStrFilePathWithFileName () const;

    /**
     * Returns the value of the member "strFilePathWithFileName".
     *
     * Json file path along with file name.
     *
     * @return The value of the field "strFilePathWithFileName"
     */
    inline const ::std::string& getStrFilePathWithFileName () const;

    /**
     * Retrieves the value of the field "strFilePathWithFileName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strFilePathWithFileName".
     */
    inline ::std::string& getStrFilePathWithFileNameMutable ();

    /**
     * Sets the value of the member "strFilePathWithFileName".
     *
     * Json file path along with file name.
     *
     * @param strFilePathWithFileName The value which will be set
     */
    inline void setStrFilePathWithFileName (const ::std::string& strFilePathWithFileName_);

    /**
     * Sets the value of the member "strFilePathWithFileName".
     *
     * Json file path along with file name.
     *
     * @param strFilePathWithFileName The value which will be set
     */
    inline void setStrFilePathWithFileName (const char* strFilePathWithFileName_);

    /**
     * Sets the value of the member "strFilePathWithFileName".
     *
     * Json file path along with file name.
     *
     * @param strFilePathWithFileName The value which will be set
     */
    inline void setStrFilePathWithFileName (const char* value, size_t size);

    // API of field "VICSResponseData"

    static const int kVICSResponseData = 1;

    /**
     * Clears the field "VICSResponseData".
     *
     * The field will be set to its default value. The hasVICSResponseData()
     * method will return false.
     */
    inline void clearVICSResponseData();

    /**
     * Checks whether the field "VICSResponseData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVICSResponseData()). Otherwise it will return false.
     */
    inline bool hasVICSResponseData () const;

    /**
     * Returns the value of the member "VICSResponseData".
     *
     * VICSResponseData
     *
     * @return The value of the field "VICSResponseData"
     */
    inline const ::tcu_usb_main_fi_types::T_e8_tcu_VICS_Response_Data& getVICSResponseData () const;

    /**
     * Retrieves the value of the field "VICSResponseData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "VICSResponseData".
     */
    inline ::tcu_usb_main_fi_types::T_e8_tcu_VICS_Response_Data& getVICSResponseDataMutable ();

    /**
     * Sets the value of the member "VICSResponseData".
     *
     * VICSResponseData
     *
     * @param VICSResponseData The value which will be set
     */
    inline void setVICSResponseData (const ::tcu_usb_main_fi_types::T_e8_tcu_VICS_Response_Data& VICSResponseData_);

    static const VICSTrafficDataStatus &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_strFilePathWithFileName ();

    inline void clear_has_strFilePathWithFileName ();

    inline void set_has_VICSResponseData ();

    inline void clear_has_VICSResponseData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _strFilePathWithFileName;

    ::tcu_usb_main_fi_types::T_e8_tcu_VICS_Response_Data _VICSResponseData;

};

/**
 * The error message of 'VICSTrafficData'
 * Error Message
 */
class VICSTrafficDataErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  VICSTrafficDataErrorStructure ();

    /**
     * Copy constructor
     */
    inline  VICSTrafficDataErrorStructure (const VICSTrafficDataErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  VICSTrafficDataErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~VICSTrafficDataErrorStructure();

    /**
     * Assignment operator
     */
    inline VICSTrafficDataErrorStructure& operator = (const VICSTrafficDataErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VICSTrafficDataErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VICSTrafficDataErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VICSTrafficDataErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VICSTrafficDataErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const VICSTrafficDataErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'VICSTrafficData'
 * Error Message
 */
class VICSTrafficDataError  : public ::asf::core::Payload {
public:

    enum VICSTrafficDataErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  VICSTrafficDataError ();

   /**
     * Copy constructor
     */
    inline  VICSTrafficDataError (const VICSTrafficDataError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~VICSTrafficDataError();

    /**
     * Assigns a new value to this object.
     */
    inline VICSTrafficDataError& operator = (const VICSTrafficDataError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VICSTrafficDataError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VICSTrafficDataError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VICSTrafficDataError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VICSTrafficDataError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline VICSTrafficDataError::VICSTrafficDataErrorField getField () const;

    inline void setField(VICSTrafficDataError::VICSTrafficDataErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "VICSTrafficDataErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "VICSTrafficDataErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const VICSTrafficDataErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline VICSTrafficDataErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline VICSTrafficDataErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (VICSTrafficDataErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "VICSTrafficDataErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const VICSTrafficDataErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const VICSTrafficDataError &getDefaultInstance();

private:

    inline void cloneData (const VICSTrafficDataError& rhs);

    inline void deleteData ();

    VICSTrafficDataErrorField __field;

    union {
        VICSTrafficDataErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "ChargingStationsList"
 * This property gives information about the charging stations list.
 * This is the response for the methodstart getChargingStationsList
 */
class ChargingStationsListStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ChargingStationsListStatus ();

    /**
     * Copy constructor
     */
    inline  ChargingStationsListStatus (const ChargingStationsListStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ChargingStationsListStatus (const ::tcu_usb_main_fi_types::T_tcu_response_charging_stations_list_result& ChargingStationsList_);

    /**
     * Destructor
     */
    inline virtual  ~ChargingStationsListStatus();

    /**
     * Assignment operator
     */
    inline ChargingStationsListStatus& operator = (const ChargingStationsListStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChargingStationsListStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChargingStationsListStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChargingStationsListStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChargingStationsListStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ChargingStationsList"

    static const int kChargingStationsList = 0;

    /**
     * Clears the field "ChargingStationsList".
     *
     * The field will be set to its default value. The hasChargingStationsList()
     * method will return false.
     */
    inline void clearChargingStationsList();

    /**
     * Checks whether the field "ChargingStationsList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChargingStationsList()). Otherwise it will return false.
     */
    inline bool hasChargingStationsList () const;

    /**
     * Returns the value of the member "ChargingStationsList".
     *
     *
     *
     * @return The value of the field "ChargingStationsList"
     */
    inline const ::tcu_usb_main_fi_types::T_tcu_response_charging_stations_list_result& getChargingStationsList () const;

    /**
     * Retrieves the value of the field "ChargingStationsList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ChargingStationsList".
     */
    inline ::tcu_usb_main_fi_types::T_tcu_response_charging_stations_list_result& getChargingStationsListMutable ();

    /**
     * Sets the value of the member "ChargingStationsList".
     *
     *
     *
     * @param ChargingStationsList The value which will be set
     */
    inline void setChargingStationsList (const ::tcu_usb_main_fi_types::T_tcu_response_charging_stations_list_result& ChargingStationsList_);

    static const ChargingStationsListStatus &getDefaultInstance();

private:

    inline void set_has_ChargingStationsList ();

    inline void clear_has_ChargingStationsList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_usb_main_fi_types::T_tcu_response_charging_stations_list_result _ChargingStationsList;

};

/**
 * The error message of 'ChargingStationsList'
 * Error Message
 */
class ChargingStationsListErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  ChargingStationsListErrorStructure ();

    /**
     * Copy constructor
     */
    inline  ChargingStationsListErrorStructure (const ChargingStationsListErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  ChargingStationsListErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~ChargingStationsListErrorStructure();

    /**
     * Assignment operator
     */
    inline ChargingStationsListErrorStructure& operator = (const ChargingStationsListErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChargingStationsListErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChargingStationsListErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChargingStationsListErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChargingStationsListErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const ChargingStationsListErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'ChargingStationsList'
 * Error Message
 */
class ChargingStationsListError  : public ::asf::core::Payload {
public:

    enum ChargingStationsListErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  ChargingStationsListError ();

   /**
     * Copy constructor
     */
    inline  ChargingStationsListError (const ChargingStationsListError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~ChargingStationsListError();

    /**
     * Assigns a new value to this object.
     */
    inline ChargingStationsListError& operator = (const ChargingStationsListError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChargingStationsListError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChargingStationsListError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChargingStationsListError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChargingStationsListError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline ChargingStationsListError::ChargingStationsListErrorField getField () const;

    inline void setField(ChargingStationsListError::ChargingStationsListErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "ChargingStationsListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "ChargingStationsListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ChargingStationsListErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ChargingStationsListErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline ChargingStationsListErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (ChargingStationsListErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "ChargingStationsListErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const ChargingStationsListErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const ChargingStationsListError &getDefaultInstance();

private:

    inline void cloneData (const ChargingStationsListError& rhs);

    inline void deleteData ();

    ChargingStationsListErrorField __field;

    union {
        ChargingStationsListErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "ChargingSpotData"
 * This property gives information about the charging spot data.
 * This is the response for the methodstart getChargingSpotData
 */
class ChargingSpotDataStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ChargingSpotDataStatus ();

    /**
     * Copy constructor
     */
    inline  ChargingSpotDataStatus (const ChargingSpotDataStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ChargingSpotDataStatus (const ::tcu_usb_main_fi_types::T_tcu_response_charging_spot_data_result& ChargingSpotData_);

    /**
     * Destructor
     */
    inline virtual  ~ChargingSpotDataStatus();

    /**
     * Assignment operator
     */
    inline ChargingSpotDataStatus& operator = (const ChargingSpotDataStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChargingSpotDataStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChargingSpotDataStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChargingSpotDataStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChargingSpotDataStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ChargingSpotData"

    static const int kChargingSpotData = 0;

    /**
     * Clears the field "ChargingSpotData".
     *
     * The field will be set to its default value. The hasChargingSpotData()
     * method will return false.
     */
    inline void clearChargingSpotData();

    /**
     * Checks whether the field "ChargingSpotData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChargingSpotData()). Otherwise it will return false.
     */
    inline bool hasChargingSpotData () const;

    /**
     * Returns the value of the member "ChargingSpotData".
     *
     *
     *
     * @return The value of the field "ChargingSpotData"
     */
    inline const ::tcu_usb_main_fi_types::T_tcu_response_charging_spot_data_result& getChargingSpotData () const;

    /**
     * Retrieves the value of the field "ChargingSpotData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ChargingSpotData".
     */
    inline ::tcu_usb_main_fi_types::T_tcu_response_charging_spot_data_result& getChargingSpotDataMutable ();

    /**
     * Sets the value of the member "ChargingSpotData".
     *
     *
     *
     * @param ChargingSpotData The value which will be set
     */
    inline void setChargingSpotData (const ::tcu_usb_main_fi_types::T_tcu_response_charging_spot_data_result& ChargingSpotData_);

    static const ChargingSpotDataStatus &getDefaultInstance();

private:

    inline void set_has_ChargingSpotData ();

    inline void clear_has_ChargingSpotData ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_usb_main_fi_types::T_tcu_response_charging_spot_data_result _ChargingSpotData;

};

/**
 * The error message of 'ChargingSpotData'
 * Error Message
 */
class ChargingSpotDataErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  ChargingSpotDataErrorStructure ();

    /**
     * Copy constructor
     */
    inline  ChargingSpotDataErrorStructure (const ChargingSpotDataErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  ChargingSpotDataErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~ChargingSpotDataErrorStructure();

    /**
     * Assignment operator
     */
    inline ChargingSpotDataErrorStructure& operator = (const ChargingSpotDataErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChargingSpotDataErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChargingSpotDataErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChargingSpotDataErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChargingSpotDataErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const ChargingSpotDataErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'ChargingSpotData'
 * Error Message
 */
class ChargingSpotDataError  : public ::asf::core::Payload {
public:

    enum ChargingSpotDataErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  ChargingSpotDataError ();

   /**
     * Copy constructor
     */
    inline  ChargingSpotDataError (const ChargingSpotDataError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~ChargingSpotDataError();

    /**
     * Assigns a new value to this object.
     */
    inline ChargingSpotDataError& operator = (const ChargingSpotDataError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChargingSpotDataError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChargingSpotDataError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChargingSpotDataError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChargingSpotDataError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline ChargingSpotDataError::ChargingSpotDataErrorField getField () const;

    inline void setField(ChargingSpotDataError::ChargingSpotDataErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "ChargingSpotDataErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "ChargingSpotDataErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ChargingSpotDataErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ChargingSpotDataErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline ChargingSpotDataErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (ChargingSpotDataErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "ChargingSpotDataErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const ChargingSpotDataErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const ChargingSpotDataError &getDefaultInstance();

private:

    inline void cloneData (const ChargingSpotDataError& rhs);

    inline void deleteData ();

    ChargingSpotDataErrorField __field;

    union {
        ChargingSpotDataErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "VacancyStationsList"
 * This property gives information about the vacancy stations list.
 * This is the response for the methodstart getVacancyStationsList
 */
class VacancyStationsListStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VacancyStationsListStatus ();

    /**
     * Copy constructor
     */
    inline  VacancyStationsListStatus (const VacancyStationsListStatus &rhs);

    /**
     * All fields constructor
     */
    inline  VacancyStationsListStatus (const ::tcu_usb_main_fi_types::T_tcu_response_vacancy_stations_list_result& VacancyStationsList_);

    /**
     * Destructor
     */
    inline virtual  ~VacancyStationsListStatus();

    /**
     * Assignment operator
     */
    inline VacancyStationsListStatus& operator = (const VacancyStationsListStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VacancyStationsListStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VacancyStationsListStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VacancyStationsListStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VacancyStationsListStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VacancyStationsList"

    static const int kVacancyStationsList = 0;

    /**
     * Clears the field "VacancyStationsList".
     *
     * The field will be set to its default value. The hasVacancyStationsList()
     * method will return false.
     */
    inline void clearVacancyStationsList();

    /**
     * Checks whether the field "VacancyStationsList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVacancyStationsList()). Otherwise it will return false.
     */
    inline bool hasVacancyStationsList () const;

    /**
     * Returns the value of the member "VacancyStationsList".
     *
     * Vacancy Stations List
     *
     * @return The value of the field "VacancyStationsList"
     */
    inline const ::tcu_usb_main_fi_types::T_tcu_response_vacancy_stations_list_result& getVacancyStationsList () const;

    /**
     * Retrieves the value of the field "VacancyStationsList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "VacancyStationsList".
     */
    inline ::tcu_usb_main_fi_types::T_tcu_response_vacancy_stations_list_result& getVacancyStationsListMutable ();

    /**
     * Sets the value of the member "VacancyStationsList".
     *
     * Vacancy Stations List
     *
     * @param VacancyStationsList The value which will be set
     */
    inline void setVacancyStationsList (const ::tcu_usb_main_fi_types::T_tcu_response_vacancy_stations_list_result& VacancyStationsList_);

    static const VacancyStationsListStatus &getDefaultInstance();

private:

    inline void set_has_VacancyStationsList ();

    inline void clear_has_VacancyStationsList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_usb_main_fi_types::T_tcu_response_vacancy_stations_list_result _VacancyStationsList;

};

/**
 * The error message of 'VacancyStationsList'
 * Error Message
 */
class VacancyStationsListErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  VacancyStationsListErrorStructure ();

    /**
     * Copy constructor
     */
    inline  VacancyStationsListErrorStructure (const VacancyStationsListErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  VacancyStationsListErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~VacancyStationsListErrorStructure();

    /**
     * Assignment operator
     */
    inline VacancyStationsListErrorStructure& operator = (const VacancyStationsListErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VacancyStationsListErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VacancyStationsListErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VacancyStationsListErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VacancyStationsListErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const VacancyStationsListErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'VacancyStationsList'
 * Error Message
 */
class VacancyStationsListError  : public ::asf::core::Payload {
public:

    enum VacancyStationsListErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  VacancyStationsListError ();

   /**
     * Copy constructor
     */
    inline  VacancyStationsListError (const VacancyStationsListError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~VacancyStationsListError();

    /**
     * Assigns a new value to this object.
     */
    inline VacancyStationsListError& operator = (const VacancyStationsListError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VacancyStationsListError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VacancyStationsListError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VacancyStationsListError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VacancyStationsListError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline VacancyStationsListError::VacancyStationsListErrorField getField () const;

    inline void setField(VacancyStationsListError::VacancyStationsListErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "VacancyStationsListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "VacancyStationsListErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const VacancyStationsListErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline VacancyStationsListErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline VacancyStationsListErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (VacancyStationsListErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "VacancyStationsListErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const VacancyStationsListErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const VacancyStationsListError &getDefaultInstance();

private:

    inline void cloneData (const VacancyStationsListError& rhs);

    inline void deleteData ();

    VacancyStationsListErrorField __field;

    union {
        VacancyStationsListErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "VacancySpotData"
 * This property gives information about the vacancy spot data.
 * This is the response for the methodstart getVacancySpotData
 */
class VacancySpotDataStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VacancySpotDataStatus ();

    /**
     * Copy constructor
     */
    inline  VacancySpotDataStatus (const VacancySpotDataStatus &rhs);

    /**
     * All fields constructor
     */
    inline  VacancySpotDataStatus (const ::tcu_usb_main_fi_types::T_tcu_response_vacancy_spot_data_result& VacancySpotData_);

    /**
     * Destructor
     */
    inline virtual  ~VacancySpotDataStatus();

    /**
     * Assignment operator
     */
    inline VacancySpotDataStatus& operator = (const VacancySpotDataStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VacancySpotDataStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VacancySpotDataStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VacancySpotDataStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VacancySpotDataStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VacancySpotData"

    static const int kVacancySpotData = 0;

    /**
     * Clears the field "VacancySpotData".
     *
     * The field will be set to its default value. The hasVacancySpotData()
     * method will return false.
     */
    inline void clearVacancySpotData();

    /**
     * Checks whether the field "VacancySpotData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVacancySpotData()). Otherwise it will return false.
     */
    inline bool hasVacancySpotData () const;

    /**
     * Returns the value of the member "VacancySpotData".
     *
     *
     *
     * @return The value of the field "VacancySpotData"
     */
    inline const ::tcu_usb_main_fi_types::T_tcu_response_vacancy_spot_data_result& getVacancySpotData () const;

    /**
     * Retrieves the value of the field "VacancySpotData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "VacancySpotData".
     */
    inline ::tcu_usb_main_fi_types::T_tcu_response_vacancy_spot_data_result& getVacancySpotDataMutable ();

    /**
     * Sets the value of the member "VacancySpotData".
     *
     *
     *
     * @param VacancySpotData The value which will be set
     */
    inline void setVacancySpotData (const ::tcu_usb_main_fi_types::T_tcu_response_vacancy_spot_data_result& VacancySpotData_);

    static const VacancySpotDataStatus &getDefaultInstance();

private:

    inline void set_has_VacancySpotData ();

    inline void clear_has_VacancySpotData ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_usb_main_fi_types::T_tcu_response_vacancy_spot_data_result _VacancySpotData;

};

/**
 * The error message of 'VacancySpotData'
 * Error Message
 */
class VacancySpotDataErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  VacancySpotDataErrorStructure ();

    /**
     * Copy constructor
     */
    inline  VacancySpotDataErrorStructure (const VacancySpotDataErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  VacancySpotDataErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~VacancySpotDataErrorStructure();

    /**
     * Assignment operator
     */
    inline VacancySpotDataErrorStructure& operator = (const VacancySpotDataErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VacancySpotDataErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VacancySpotDataErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VacancySpotDataErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VacancySpotDataErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const VacancySpotDataErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'VacancySpotData'
 * Error Message
 */
class VacancySpotDataError  : public ::asf::core::Payload {
public:

    enum VacancySpotDataErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  VacancySpotDataError ();

   /**
     * Copy constructor
     */
    inline  VacancySpotDataError (const VacancySpotDataError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~VacancySpotDataError();

    /**
     * Assigns a new value to this object.
     */
    inline VacancySpotDataError& operator = (const VacancySpotDataError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VacancySpotDataError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VacancySpotDataError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VacancySpotDataError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VacancySpotDataError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline VacancySpotDataError::VacancySpotDataErrorField getField () const;

    inline void setField(VacancySpotDataError::VacancySpotDataErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "VacancySpotDataErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "VacancySpotDataErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const VacancySpotDataErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline VacancySpotDataErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline VacancySpotDataErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (VacancySpotDataErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "VacancySpotDataErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const VacancySpotDataErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const VacancySpotDataError &getDefaultInstance();

private:

    inline void cloneData (const VacancySpotDataError& rhs);

    inline void deleteData ();

    VacancySpotDataErrorField __field;

    union {
        VacancySpotDataErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "GeneralResponseError"
 * This property informs the HMI about error occured in GeneralResponse received.
 */
class GeneralResponseErrorStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GeneralResponseErrorStatus ();

    /**
     * Copy constructor
     */
    inline  GeneralResponseErrorStatus (const GeneralResponseErrorStatus &rhs);

    /**
     * All fields constructor
     */
    inline  GeneralResponseErrorStatus (bool GeneralResponseDataError_);

    /**
     * Destructor
     */
    inline virtual  ~GeneralResponseErrorStatus();

    /**
     * Assignment operator
     */
    inline GeneralResponseErrorStatus& operator = (const GeneralResponseErrorStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GeneralResponseErrorStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GeneralResponseErrorStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GeneralResponseErrorStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GeneralResponseErrorStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "GeneralResponseDataError"

    static const int kGeneralResponseDataError = 0;

    /**
     * Clears the field "GeneralResponseDataError".
     *
     * The field will be set to its default value. The hasGeneralResponseDataError()
     * method will return false.
     */
    inline void clearGeneralResponseDataError();

    /**
     * Checks whether the field "GeneralResponseDataError" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGeneralResponseDataError()). Otherwise it will return false.
     */
    inline bool hasGeneralResponseDataError () const;

    /**
     * Returns the value of the member "GeneralResponseDataError".
     *
     *
     *
     * @return The value of the field "GeneralResponseDataError"
     */
    inline bool getGeneralResponseDataError () const;

    /**
     * Sets the value of the member "GeneralResponseDataError".
     *
     *
     *
     * @param GeneralResponseDataError The value which will be set
     */
    inline void setGeneralResponseDataError (bool GeneralResponseDataError_);

    static const GeneralResponseErrorStatus &getDefaultInstance();

private:

    inline void set_has_GeneralResponseDataError ();

    inline void clear_has_GeneralResponseDataError ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _GeneralResponseDataError;

};

/**
 * The error message of 'GeneralResponseError'
 * Error Message
 */
class GeneralResponseErrorErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GeneralResponseErrorErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GeneralResponseErrorErrorStructure (const GeneralResponseErrorErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GeneralResponseErrorErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~GeneralResponseErrorErrorStructure();

    /**
     * Assignment operator
     */
    inline GeneralResponseErrorErrorStructure& operator = (const GeneralResponseErrorErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GeneralResponseErrorErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GeneralResponseErrorErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GeneralResponseErrorErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GeneralResponseErrorErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const GeneralResponseErrorErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'GeneralResponseError'
 * Error Message
 */
class GeneralResponseErrorError  : public ::asf::core::Payload {
public:

    enum GeneralResponseErrorErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GeneralResponseErrorError ();

   /**
     * Copy constructor
     */
    inline  GeneralResponseErrorError (const GeneralResponseErrorError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GeneralResponseErrorError();

    /**
     * Assigns a new value to this object.
     */
    inline GeneralResponseErrorError& operator = (const GeneralResponseErrorError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GeneralResponseErrorError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GeneralResponseErrorError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GeneralResponseErrorError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GeneralResponseErrorError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GeneralResponseErrorError::GeneralResponseErrorErrorField getField () const;

    inline void setField(GeneralResponseErrorError::GeneralResponseErrorErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GeneralResponseErrorErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GeneralResponseErrorErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GeneralResponseErrorErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GeneralResponseErrorErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GeneralResponseErrorErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GeneralResponseErrorErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GeneralResponseErrorErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GeneralResponseErrorErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GeneralResponseErrorError &getDefaultInstance();

private:

    inline void cloneData (const GeneralResponseErrorError& rhs);

    inline void deleteData ();

    GeneralResponseErrorErrorField __field;

    union {
        GeneralResponseErrorErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The error message of 'ResetNCSSettings'
 * Error Message
 */
class ResetNCSSettingsErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  ResetNCSSettingsErrorStructure ();

    /**
     * Copy constructor
     */
    inline  ResetNCSSettingsErrorStructure (const ResetNCSSettingsErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  ResetNCSSettingsErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~ResetNCSSettingsErrorStructure();

    /**
     * Assignment operator
     */
    inline ResetNCSSettingsErrorStructure& operator = (const ResetNCSSettingsErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ResetNCSSettingsErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ResetNCSSettingsErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ResetNCSSettingsErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ResetNCSSettingsErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const ResetNCSSettingsErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'ResetNCSSettings'
 * Error Message
 */
class ResetNCSSettingsError  : public ::asf::core::Payload {
public:

    enum ResetNCSSettingsErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  ResetNCSSettingsError ();

   /**
     * Copy constructor
     */
    inline  ResetNCSSettingsError (const ResetNCSSettingsError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~ResetNCSSettingsError();

    /**
     * Assigns a new value to this object.
     */
    inline ResetNCSSettingsError& operator = (const ResetNCSSettingsError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ResetNCSSettingsError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ResetNCSSettingsError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ResetNCSSettingsError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ResetNCSSettingsError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline ResetNCSSettingsError::ResetNCSSettingsErrorField getField () const;

    inline void setField(ResetNCSSettingsError::ResetNCSSettingsErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "ResetNCSSettingsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "ResetNCSSettingsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ResetNCSSettingsErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ResetNCSSettingsErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline ResetNCSSettingsErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (ResetNCSSettingsErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "ResetNCSSettingsErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const ResetNCSSettingsErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const ResetNCSSettingsError &getDefaultInstance();

private:

    inline void cloneData (const ResetNCSSettingsError& rhs);

    inline void deleteData ();

    ResetNCSSettingsErrorField __field;

    union {
        ResetNCSSettingsErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The result message of the method "GetProbeUploadPermit"
 * This method is called by ITM when the probe upload permit is chnaged from ITM side(MCAN Fct Id:244h).
 */
class GetProbeUploadPermitResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetProbeUploadPermitResult ();

    /**
     * Copy constructor
     */
    inline  GetProbeUploadPermitResult (const GetProbeUploadPermitResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetProbeUploadPermitResult (::tcu_usb_main_fi_types::T_e8_TCU_ProbePermitSetting e8ProbePermitSetting_);

    /**
     * Destructor
     */
    inline virtual  ~GetProbeUploadPermitResult();

    /**
     * Assignment operator
     */
    inline GetProbeUploadPermitResult& operator = (const GetProbeUploadPermitResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetProbeUploadPermitResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetProbeUploadPermitResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetProbeUploadPermitResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetProbeUploadPermitResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ProbePermitSetting"

    static const int kE8ProbePermitSetting = 0;

    /**
     * Clears the field "e8ProbePermitSetting".
     *
     * The field will be set to its default value. The hasE8ProbePermitSetting()
     * method will return false.
     */
    inline void clearE8ProbePermitSetting();

    /**
     * Checks whether the field "e8ProbePermitSetting" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ProbePermitSetting()). Otherwise it will return false.
     */
    inline bool hasE8ProbePermitSetting () const;

    /**
     * Returns the value of the member "e8ProbePermitSetting".
     *
     * If the meaning of "e8ProbePermitSetting" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8ProbePermitSetting"
     */
    inline ::tcu_usb_main_fi_types::T_e8_TCU_ProbePermitSetting getE8ProbePermitSetting () const;

    /**
     * Sets the value of the member "e8ProbePermitSetting".
     *
     * If the meaning of "e8ProbePermitSetting" isn't clear, then there should be a description here.
     *
     * @param e8ProbePermitSetting The value which will be set
     */
    inline void setE8ProbePermitSetting (::tcu_usb_main_fi_types::T_e8_TCU_ProbePermitSetting e8ProbePermitSetting_);

    static const GetProbeUploadPermitResult &getDefaultInstance();

private:

    inline void set_has_e8ProbePermitSetting ();

    inline void clear_has_e8ProbePermitSetting ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_usb_main_fi_types::T_e8_TCU_ProbePermitSetting _e8ProbePermitSetting;

};

/**
 * The error message of 'GetProbeUploadPermit'
 * Error Message
 */
class GetProbeUploadPermitErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GetProbeUploadPermitErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GetProbeUploadPermitErrorStructure (const GetProbeUploadPermitErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GetProbeUploadPermitErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~GetProbeUploadPermitErrorStructure();

    /**
     * Assignment operator
     */
    inline GetProbeUploadPermitErrorStructure& operator = (const GetProbeUploadPermitErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetProbeUploadPermitErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetProbeUploadPermitErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetProbeUploadPermitErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetProbeUploadPermitErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const GetProbeUploadPermitErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'GetProbeUploadPermit'
 * Error Message
 */
class GetProbeUploadPermitError  : public ::asf::core::Payload {
public:

    enum GetProbeUploadPermitErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GetProbeUploadPermitError ();

   /**
     * Copy constructor
     */
    inline  GetProbeUploadPermitError (const GetProbeUploadPermitError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GetProbeUploadPermitError();

    /**
     * Assigns a new value to this object.
     */
    inline GetProbeUploadPermitError& operator = (const GetProbeUploadPermitError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetProbeUploadPermitError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetProbeUploadPermitError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetProbeUploadPermitError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetProbeUploadPermitError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GetProbeUploadPermitError::GetProbeUploadPermitErrorField getField () const;

    inline void setField(GetProbeUploadPermitError::GetProbeUploadPermitErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GetProbeUploadPermitErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GetProbeUploadPermitErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GetProbeUploadPermitErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GetProbeUploadPermitErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GetProbeUploadPermitErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GetProbeUploadPermitErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GetProbeUploadPermitErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GetProbeUploadPermitErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GetProbeUploadPermitError &getDefaultInstance();

private:

    inline void cloneData (const GetProbeUploadPermitError& rhs);

    inline void deleteData ();

    GetProbeUploadPermitErrorField __field;

    union {
        GetProbeUploadPermitErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SetProbeUploadPermit"
 * This method is called by ITM when there is change in Probe Upload permit from ITM side(MCAN Fct Id:244h).
 */
class SetProbeUploadPermitStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetProbeUploadPermitStart ();

    /**
     * Copy constructor
     */
    inline  SetProbeUploadPermitStart (const SetProbeUploadPermitStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetProbeUploadPermitStart (::tcu_usb_main_fi_types::T_e8_TCU_ProbePermitSetting e8ProbePermitSetting_);

    /**
     * Destructor
     */
    inline virtual  ~SetProbeUploadPermitStart();

    /**
     * Assignment operator
     */
    inline SetProbeUploadPermitStart& operator = (const SetProbeUploadPermitStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetProbeUploadPermitStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetProbeUploadPermitStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetProbeUploadPermitStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetProbeUploadPermitStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ProbePermitSetting"

    static const int kE8ProbePermitSetting = 0;

    /**
     * Clears the field "e8ProbePermitSetting".
     *
     * The field will be set to its default value. The hasE8ProbePermitSetting()
     * method will return false.
     */
    inline void clearE8ProbePermitSetting();

    /**
     * Checks whether the field "e8ProbePermitSetting" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ProbePermitSetting()). Otherwise it will return false.
     */
    inline bool hasE8ProbePermitSetting () const;

    /**
     * Returns the value of the member "e8ProbePermitSetting".
     *
     * Probe Permit setting.
     *
     * @return The value of the field "e8ProbePermitSetting"
     */
    inline ::tcu_usb_main_fi_types::T_e8_TCU_ProbePermitSetting getE8ProbePermitSetting () const;

    /**
     * Sets the value of the member "e8ProbePermitSetting".
     *
     * Probe Permit setting.
     *
     * @param e8ProbePermitSetting The value which will be set
     */
    inline void setE8ProbePermitSetting (::tcu_usb_main_fi_types::T_e8_TCU_ProbePermitSetting e8ProbePermitSetting_);

    static const SetProbeUploadPermitStart &getDefaultInstance();

private:

    inline void set_has_e8ProbePermitSetting ();

    inline void clear_has_e8ProbePermitSetting ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_usb_main_fi_types::T_e8_TCU_ProbePermitSetting _e8ProbePermitSetting;

};

/**
 * The result message of the method "SetProbeUploadPermit"
 * This method is called by ITM when there is change in Probe Upload permit from ITM side(MCAN Fct Id:244h).
 */
class SetProbeUploadPermitResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetProbeUploadPermitResult ();

    /**
     * Copy constructor
     */
    inline  SetProbeUploadPermitResult (const SetProbeUploadPermitResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetProbeUploadPermitResult (::tcu_usb_main_fi_types::T_e8_TCU_ProbePermitSetting e8ProbePermitSetting_);

    /**
     * Destructor
     */
    inline virtual  ~SetProbeUploadPermitResult();

    /**
     * Assignment operator
     */
    inline SetProbeUploadPermitResult& operator = (const SetProbeUploadPermitResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetProbeUploadPermitResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetProbeUploadPermitResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetProbeUploadPermitResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetProbeUploadPermitResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ProbePermitSetting"

    static const int kE8ProbePermitSetting = 0;

    /**
     * Clears the field "e8ProbePermitSetting".
     *
     * The field will be set to its default value. The hasE8ProbePermitSetting()
     * method will return false.
     */
    inline void clearE8ProbePermitSetting();

    /**
     * Checks whether the field "e8ProbePermitSetting" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ProbePermitSetting()). Otherwise it will return false.
     */
    inline bool hasE8ProbePermitSetting () const;

    /**
     * Returns the value of the member "e8ProbePermitSetting".
     *
     * Probe Permit setting.
     *
     * @return The value of the field "e8ProbePermitSetting"
     */
    inline ::tcu_usb_main_fi_types::T_e8_TCU_ProbePermitSetting getE8ProbePermitSetting () const;

    /**
     * Sets the value of the member "e8ProbePermitSetting".
     *
     * Probe Permit setting.
     *
     * @param e8ProbePermitSetting The value which will be set
     */
    inline void setE8ProbePermitSetting (::tcu_usb_main_fi_types::T_e8_TCU_ProbePermitSetting e8ProbePermitSetting_);

    static const SetProbeUploadPermitResult &getDefaultInstance();

private:

    inline void set_has_e8ProbePermitSetting ();

    inline void clear_has_e8ProbePermitSetting ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::tcu_usb_main_fi_types::T_e8_TCU_ProbePermitSetting _e8ProbePermitSetting;

};

/**
 * The error message of 'SetProbeUploadPermit'
 * Error Message
 */
class SetProbeUploadPermitErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetProbeUploadPermitErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetProbeUploadPermitErrorStructure (const SetProbeUploadPermitErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetProbeUploadPermitErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~SetProbeUploadPermitErrorStructure();

    /**
     * Assignment operator
     */
    inline SetProbeUploadPermitErrorStructure& operator = (const SetProbeUploadPermitErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetProbeUploadPermitErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetProbeUploadPermitErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetProbeUploadPermitErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetProbeUploadPermitErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const SetProbeUploadPermitErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'SetProbeUploadPermit'
 * Error Message
 */
class SetProbeUploadPermitError  : public ::asf::core::Payload {
public:

    enum SetProbeUploadPermitErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetProbeUploadPermitError ();

   /**
     * Copy constructor
     */
    inline  SetProbeUploadPermitError (const SetProbeUploadPermitError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetProbeUploadPermitError();

    /**
     * Assigns a new value to this object.
     */
    inline SetProbeUploadPermitError& operator = (const SetProbeUploadPermitError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetProbeUploadPermitError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetProbeUploadPermitError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetProbeUploadPermitError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetProbeUploadPermitError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetProbeUploadPermitError::SetProbeUploadPermitErrorField getField () const;

    inline void setField(SetProbeUploadPermitError::SetProbeUploadPermitErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetProbeUploadPermitErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetProbeUploadPermitErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetProbeUploadPermitErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetProbeUploadPermitErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetProbeUploadPermitErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetProbeUploadPermitErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetProbeUploadPermitErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetProbeUploadPermitErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetProbeUploadPermitError &getDefaultInstance();

private:

    inline void cloneData (const SetProbeUploadPermitError& rhs);

    inline void deleteData ();

    SetProbeUploadPermitErrorField __field;

    union {
        SetProbeUploadPermitErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The result message of the method "SetProbeInfoDelete"
 * This method is called by ITM to delete the Probe info(MCAN Fct Id:245h).
 */
class SetProbeInfoDeleteResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetProbeInfoDeleteResult ();

    /**
     * Copy constructor
     */
    inline  SetProbeInfoDeleteResult (const SetProbeInfoDeleteResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetProbeInfoDeleteResult (bool bStatusFromTCU_);

    /**
     * Destructor
     */
    inline virtual  ~SetProbeInfoDeleteResult();

    /**
     * Assignment operator
     */
    inline SetProbeInfoDeleteResult& operator = (const SetProbeInfoDeleteResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetProbeInfoDeleteResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetProbeInfoDeleteResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetProbeInfoDeleteResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetProbeInfoDeleteResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bStatusFromTCU"

    static const int kBStatusFromTCU = 0;

    /**
     * Clears the field "bStatusFromTCU".
     *
     * The field will be set to its default value. The hasBStatusFromTCU()
     * method will return false.
     */
    inline void clearBStatusFromTCU();

    /**
     * Checks whether the field "bStatusFromTCU" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBStatusFromTCU()). Otherwise it will return false.
     */
    inline bool hasBStatusFromTCU () const;

    /**
     * Returns the value of the member "bStatusFromTCU".
     *
     * bStatusFromTCU = true indicates status update from TCU. bStatusFromTCU = false update not from TCU
     *
     * @return The value of the field "bStatusFromTCU"
     */
    inline bool getBStatusFromTCU () const;

    /**
     * Sets the value of the member "bStatusFromTCU".
     *
     * bStatusFromTCU = true indicates status update from TCU. bStatusFromTCU = false update not from TCU
     *
     * @param bStatusFromTCU The value which will be set
     */
    inline void setBStatusFromTCU (bool bStatusFromTCU_);

    static const SetProbeInfoDeleteResult &getDefaultInstance();

private:

    inline void set_has_bStatusFromTCU ();

    inline void clear_has_bStatusFromTCU ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bStatusFromTCU;

};

/**
 * The error message of 'SetProbeInfoDelete'
 * Error Message
 */
class SetProbeInfoDeleteErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetProbeInfoDeleteErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetProbeInfoDeleteErrorStructure (const SetProbeInfoDeleteErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetProbeInfoDeleteErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~SetProbeInfoDeleteErrorStructure();

    /**
     * Assignment operator
     */
    inline SetProbeInfoDeleteErrorStructure& operator = (const SetProbeInfoDeleteErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetProbeInfoDeleteErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetProbeInfoDeleteErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetProbeInfoDeleteErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetProbeInfoDeleteErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const SetProbeInfoDeleteErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'SetProbeInfoDelete'
 * Error Message
 */
class SetProbeInfoDeleteError  : public ::asf::core::Payload {
public:

    enum SetProbeInfoDeleteErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetProbeInfoDeleteError ();

   /**
     * Copy constructor
     */
    inline  SetProbeInfoDeleteError (const SetProbeInfoDeleteError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetProbeInfoDeleteError();

    /**
     * Assigns a new value to this object.
     */
    inline SetProbeInfoDeleteError& operator = (const SetProbeInfoDeleteError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetProbeInfoDeleteError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetProbeInfoDeleteError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetProbeInfoDeleteError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetProbeInfoDeleteError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetProbeInfoDeleteError::SetProbeInfoDeleteErrorField getField () const;

    inline void setField(SetProbeInfoDeleteError::SetProbeInfoDeleteErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetProbeInfoDeleteErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetProbeInfoDeleteErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetProbeInfoDeleteErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetProbeInfoDeleteErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetProbeInfoDeleteErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetProbeInfoDeleteErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetProbeInfoDeleteErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetProbeInfoDeleteErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetProbeInfoDeleteError &getDefaultInstance();

private:

    inline void cloneData (const SetProbeInfoDeleteError& rhs);

    inline void deleteData ();

    SetProbeInfoDeleteErrorField __field;

    union {
        SetProbeInfoDeleteErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

inline  FolderData::FolderData ()  :
    _FolderID (0u),
    _FolderName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FolderData::FolderData (const FolderData &rhs)  :
    _FolderID (0u),
    _FolderName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FolderData::FolderData (uint16 FolderID_, const ::std::string& FolderName_)  :
    _FolderID (FolderID_),
    _FolderName (FolderName_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FolderName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FolderData::~FolderData() {
}

inline FolderData& FolderData::operator = (const FolderData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasFolderID()) {
            setFolderID(rhs.getFolderID());
        } else {
            clearFolderID();
        }
        if (rhs.hasFolderName()) {
            setFolderName(rhs.getFolderName());
        } else {
            clearFolderName();
        }
    }
    return *this;
}

inline bool FolderData::operator == (const FolderData& rhs) const {
    return (((!hasFolderID() && !rhs.hasFolderID()) || getFolderID() == rhs.getFolderID()) &&
        ((!hasFolderName() && !rhs.hasFolderName()) || getFolderName() == rhs.getFolderName()));
}

inline bool FolderData::operator != (const FolderData& rhs) const {
    return ! (*this == rhs);
}

inline bool FolderData::operator < (const FolderData& rhs) const {
    if (hasFolderID() || rhs.hasFolderID()) {
        if (getFolderID() < rhs.getFolderID()) return true;
        if (getFolderID() > rhs.getFolderID()) return false;
    }
    if (hasFolderName() || rhs.hasFolderName()) {
        if (getFolderName() < rhs.getFolderName()) return true;
        if (getFolderName() > rhs.getFolderName()) return false;
    }
    return false;
}

inline bool FolderData::operator > (const FolderData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FolderData::clear() {
    clearFolderID();
    clearFolderName();
}

inline void FolderData::clearFolderID() {
    if (hasFolderID()) {
         clear_has_FolderID();
        _FolderID = 0u;
     }
}

inline bool FolderData::hasFolderID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 FolderData::getFolderID () const {
    return _FolderID;
}

inline void FolderData::setFolderID (uint16 FolderID_) {
    set_has_FolderID();
    this->_FolderID = FolderID_;
}

inline void FolderData::clearFolderName() {
    if (hasFolderName()) {
         clear_has_FolderName();
        _FolderName.clear();
     }
}

inline bool FolderData::hasFolderName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& FolderData::getFolderName () const {
    return _FolderName;
}

inline ::std::string& FolderData::getFolderNameMutable () {
    set_has_FolderName();
    return _FolderName;
}

inline void FolderData::setFolderName (const ::std::string& FolderName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FolderName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FolderName();
    this->_FolderName = FolderName_;
}

inline void FolderData::setFolderName (const char* FolderName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FolderName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FolderName();
    this->_FolderName.assign(FolderName_);
}

inline void FolderData::setFolderName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FolderName();
    this->_FolderName.assign(value, size);
}

inline void FolderData::set_has_FolderID () {
    _has_bits_[0] |= 1u << 0;
}

inline void FolderData::clear_has_FolderID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void FolderData::set_has_FolderName () {
    _has_bits_[0] |= 1u << 1;
}

inline void FolderData::clear_has_FolderName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  ChannelData::ChannelData ()  :
    _ChannelID (),
    _ChannelName (),
    _ChannelIconID (0u),
    _FlagOfChannelInfo (0u),
    _StoredNumOfChannelContents (0u),
    _TotalNumOfChannelContents (0u),
    _ServiceType (0u),
    _FolderID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ChannelData::ChannelData (const ChannelData &rhs)  :
    _ChannelID (),
    _ChannelName (),
    _ChannelIconID (0u),
    _FlagOfChannelInfo (0u),
    _StoredNumOfChannelContents (0u),
    _TotalNumOfChannelContents (0u),
    _ServiceType (0u),
    _FolderID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ChannelData::ChannelData (const ::std::string& ChannelID_, const ::std::string& ChannelName_, uint16 ChannelIconID_, uint8 FlagOfChannelInfo_, uint8 StoredNumOfChannelContents_, uint8 TotalNumOfChannelContents_, uint8 ServiceType_, uint16 FolderID_)  :
    _ChannelID (ChannelID_),
    _ChannelName (ChannelName_),
    _ChannelIconID (ChannelIconID_),
    _FlagOfChannelInfo (FlagOfChannelInfo_),
    _StoredNumOfChannelContents (StoredNumOfChannelContents_),
    _TotalNumOfChannelContents (TotalNumOfChannelContents_),
    _ServiceType (ServiceType_),
    _FolderID (FolderID_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ChannelID_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ChannelName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ChannelData::~ChannelData() {
}

inline ChannelData& ChannelData::operator = (const ChannelData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasChannelID()) {
            setChannelID(rhs.getChannelID());
        } else {
            clearChannelID();
        }
        if (rhs.hasChannelName()) {
            setChannelName(rhs.getChannelName());
        } else {
            clearChannelName();
        }
        if (rhs.hasChannelIconID()) {
            setChannelIconID(rhs.getChannelIconID());
        } else {
            clearChannelIconID();
        }
        if (rhs.hasFlagOfChannelInfo()) {
            setFlagOfChannelInfo(rhs.getFlagOfChannelInfo());
        } else {
            clearFlagOfChannelInfo();
        }
        if (rhs.hasStoredNumOfChannelContents()) {
            setStoredNumOfChannelContents(rhs.getStoredNumOfChannelContents());
        } else {
            clearStoredNumOfChannelContents();
        }
        if (rhs.hasTotalNumOfChannelContents()) {
            setTotalNumOfChannelContents(rhs.getTotalNumOfChannelContents());
        } else {
            clearTotalNumOfChannelContents();
        }
        if (rhs.hasServiceType()) {
            setServiceType(rhs.getServiceType());
        } else {
            clearServiceType();
        }
        if (rhs.hasFolderID()) {
            setFolderID(rhs.getFolderID());
        } else {
            clearFolderID();
        }
    }
    return *this;
}

inline bool ChannelData::operator == (const ChannelData& rhs) const {
    return (((!hasChannelID() && !rhs.hasChannelID()) || getChannelID() == rhs.getChannelID()) &&
        ((!hasChannelName() && !rhs.hasChannelName()) || getChannelName() == rhs.getChannelName()) &&
        ((!hasChannelIconID() && !rhs.hasChannelIconID()) || getChannelIconID() == rhs.getChannelIconID()) &&
        ((!hasFlagOfChannelInfo() && !rhs.hasFlagOfChannelInfo()) || getFlagOfChannelInfo() == rhs.getFlagOfChannelInfo()) &&
        ((!hasStoredNumOfChannelContents() && !rhs.hasStoredNumOfChannelContents()) || getStoredNumOfChannelContents() == rhs.getStoredNumOfChannelContents()) &&
        ((!hasTotalNumOfChannelContents() && !rhs.hasTotalNumOfChannelContents()) || getTotalNumOfChannelContents() == rhs.getTotalNumOfChannelContents()) &&
        ((!hasServiceType() && !rhs.hasServiceType()) || getServiceType() == rhs.getServiceType()) &&
        ((!hasFolderID() && !rhs.hasFolderID()) || getFolderID() == rhs.getFolderID()));
}

inline bool ChannelData::operator != (const ChannelData& rhs) const {
    return ! (*this == rhs);
}

inline bool ChannelData::operator < (const ChannelData& rhs) const {
    if (hasChannelID() || rhs.hasChannelID()) {
        if (getChannelID() < rhs.getChannelID()) return true;
        if (getChannelID() > rhs.getChannelID()) return false;
    }
    if (hasChannelName() || rhs.hasChannelName()) {
        if (getChannelName() < rhs.getChannelName()) return true;
        if (getChannelName() > rhs.getChannelName()) return false;
    }
    if (hasChannelIconID() || rhs.hasChannelIconID()) {
        if (getChannelIconID() < rhs.getChannelIconID()) return true;
        if (getChannelIconID() > rhs.getChannelIconID()) return false;
    }
    if (hasFlagOfChannelInfo() || rhs.hasFlagOfChannelInfo()) {
        if (getFlagOfChannelInfo() < rhs.getFlagOfChannelInfo()) return true;
        if (getFlagOfChannelInfo() > rhs.getFlagOfChannelInfo()) return false;
    }
    if (hasStoredNumOfChannelContents() || rhs.hasStoredNumOfChannelContents()) {
        if (getStoredNumOfChannelContents() < rhs.getStoredNumOfChannelContents()) return true;
        if (getStoredNumOfChannelContents() > rhs.getStoredNumOfChannelContents()) return false;
    }
    if (hasTotalNumOfChannelContents() || rhs.hasTotalNumOfChannelContents()) {
        if (getTotalNumOfChannelContents() < rhs.getTotalNumOfChannelContents()) return true;
        if (getTotalNumOfChannelContents() > rhs.getTotalNumOfChannelContents()) return false;
    }
    if (hasServiceType() || rhs.hasServiceType()) {
        if (getServiceType() < rhs.getServiceType()) return true;
        if (getServiceType() > rhs.getServiceType()) return false;
    }
    if (hasFolderID() || rhs.hasFolderID()) {
        if (getFolderID() < rhs.getFolderID()) return true;
        if (getFolderID() > rhs.getFolderID()) return false;
    }
    return false;
}

inline bool ChannelData::operator > (const ChannelData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ChannelData::clear() {
    clearChannelID();
    clearChannelName();
    clearChannelIconID();
    clearFlagOfChannelInfo();
    clearStoredNumOfChannelContents();
    clearTotalNumOfChannelContents();
    clearServiceType();
    clearFolderID();
}

inline void ChannelData::clearChannelID() {
    if (hasChannelID()) {
         clear_has_ChannelID();
        _ChannelID.clear();
     }
}

inline bool ChannelData::hasChannelID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ChannelData::getChannelID () const {
    return _ChannelID;
}

inline ::std::string& ChannelData::getChannelIDMutable () {
    set_has_ChannelID();
    return _ChannelID;
}

inline void ChannelData::setChannelID (const ::std::string& ChannelID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ChannelID_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ChannelID();
    this->_ChannelID = ChannelID_;
}

inline void ChannelData::setChannelID (const char* ChannelID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ChannelID_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ChannelID();
    this->_ChannelID.assign(ChannelID_);
}

inline void ChannelData::setChannelID (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ChannelID();
    this->_ChannelID.assign(value, size);
}

inline void ChannelData::clearChannelName() {
    if (hasChannelName()) {
         clear_has_ChannelName();
        _ChannelName.clear();
     }
}

inline bool ChannelData::hasChannelName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& ChannelData::getChannelName () const {
    return _ChannelName;
}

inline ::std::string& ChannelData::getChannelNameMutable () {
    set_has_ChannelName();
    return _ChannelName;
}

inline void ChannelData::setChannelName (const ::std::string& ChannelName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ChannelName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ChannelName();
    this->_ChannelName = ChannelName_;
}

inline void ChannelData::setChannelName (const char* ChannelName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ChannelName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ChannelName();
    this->_ChannelName.assign(ChannelName_);
}

inline void ChannelData::setChannelName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ChannelName();
    this->_ChannelName.assign(value, size);
}

inline void ChannelData::clearChannelIconID() {
    if (hasChannelIconID()) {
         clear_has_ChannelIconID();
        _ChannelIconID = 0u;
     }
}

inline bool ChannelData::hasChannelIconID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 ChannelData::getChannelIconID () const {
    return _ChannelIconID;
}

inline void ChannelData::setChannelIconID (uint16 ChannelIconID_) {
    set_has_ChannelIconID();
    this->_ChannelIconID = ChannelIconID_;
}

inline void ChannelData::clearFlagOfChannelInfo() {
    if (hasFlagOfChannelInfo()) {
         clear_has_FlagOfChannelInfo();
        _FlagOfChannelInfo = 0u;
     }
}

inline bool ChannelData::hasFlagOfChannelInfo () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 ChannelData::getFlagOfChannelInfo () const {
    return _FlagOfChannelInfo;
}

inline void ChannelData::setFlagOfChannelInfo (uint8 FlagOfChannelInfo_) {
    set_has_FlagOfChannelInfo();
    this->_FlagOfChannelInfo = FlagOfChannelInfo_;
}

inline void ChannelData::clearStoredNumOfChannelContents() {
    if (hasStoredNumOfChannelContents()) {
         clear_has_StoredNumOfChannelContents();
        _StoredNumOfChannelContents = 0u;
     }
}

inline bool ChannelData::hasStoredNumOfChannelContents () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 ChannelData::getStoredNumOfChannelContents () const {
    return _StoredNumOfChannelContents;
}

inline void ChannelData::setStoredNumOfChannelContents (uint8 StoredNumOfChannelContents_) {
    set_has_StoredNumOfChannelContents();
    this->_StoredNumOfChannelContents = StoredNumOfChannelContents_;
}

inline void ChannelData::clearTotalNumOfChannelContents() {
    if (hasTotalNumOfChannelContents()) {
         clear_has_TotalNumOfChannelContents();
        _TotalNumOfChannelContents = 0u;
     }
}

inline bool ChannelData::hasTotalNumOfChannelContents () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint8 ChannelData::getTotalNumOfChannelContents () const {
    return _TotalNumOfChannelContents;
}

inline void ChannelData::setTotalNumOfChannelContents (uint8 TotalNumOfChannelContents_) {
    set_has_TotalNumOfChannelContents();
    this->_TotalNumOfChannelContents = TotalNumOfChannelContents_;
}

inline void ChannelData::clearServiceType() {
    if (hasServiceType()) {
         clear_has_ServiceType();
        _ServiceType = 0u;
     }
}

inline bool ChannelData::hasServiceType () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint8 ChannelData::getServiceType () const {
    return _ServiceType;
}

inline void ChannelData::setServiceType (uint8 ServiceType_) {
    set_has_ServiceType();
    this->_ServiceType = ServiceType_;
}

inline void ChannelData::clearFolderID() {
    if (hasFolderID()) {
         clear_has_FolderID();
        _FolderID = 0u;
     }
}

inline bool ChannelData::hasFolderID () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline uint16 ChannelData::getFolderID () const {
    return _FolderID;
}

inline void ChannelData::setFolderID (uint16 FolderID_) {
    set_has_FolderID();
    this->_FolderID = FolderID_;
}

inline void ChannelData::set_has_ChannelID () {
    _has_bits_[0] |= 1u << 0;
}

inline void ChannelData::clear_has_ChannelID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ChannelData::set_has_ChannelName () {
    _has_bits_[0] |= 1u << 1;
}

inline void ChannelData::clear_has_ChannelName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ChannelData::set_has_ChannelIconID () {
    _has_bits_[0] |= 1u << 2;
}

inline void ChannelData::clear_has_ChannelIconID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void ChannelData::set_has_FlagOfChannelInfo () {
    _has_bits_[0] |= 1u << 3;
}

inline void ChannelData::clear_has_FlagOfChannelInfo () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void ChannelData::set_has_StoredNumOfChannelContents () {
    _has_bits_[0] |= 1u << 4;
}

inline void ChannelData::clear_has_StoredNumOfChannelContents () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void ChannelData::set_has_TotalNumOfChannelContents () {
    _has_bits_[0] |= 1u << 5;
}

inline void ChannelData::clear_has_TotalNumOfChannelContents () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void ChannelData::set_has_ServiceType () {
    _has_bits_[0] |= 1u << 6;
}

inline void ChannelData::clear_has_ServiceType () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void ChannelData::set_has_FolderID () {
    _has_bits_[0] |= 1u << 7;
}

inline void ChannelData::clear_has_FolderID () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline  ContentData::ContentData ()  :
    _ChannelContentsID (0u),
    _Title (),
    _TitleForTTS (),
    _Direction (0u),
    _LAT (0u),
    _LON (0u),
    _LocationAttribute (0u),
    _DestOrWayPointType (0u),
    _Address (),
    _PhoneNumber (),
    _PhoneNumberForDisp (),
    _Text (),
    _TextForTTS (),
    _IconID (0u),
    _SoundIDForBeginningOfPlay (0u),
    _SoundIDForBGM (0u),
    _ActionSWID (0u),
    _ParameterOfActionSW (0u),
    _FlagOfDispButtonCtrl (0u),
    _FlagOfCtrlDuringRunning (0u),
    _NameOfImageButton (),
    _NameOfActionSW (),
    _FlagOfExecOfChannelContents (0u),
    _FlagOfStoringCtrl (0u),
    _ImageAvailability (0u),
    _ImagePath (),
    _ChannelID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ContentData::ContentData (const ContentData &rhs)  :
    _ChannelContentsID (0u),
    _Title (),
    _TitleForTTS (),
    _Direction (0u),
    _LAT (0u),
    _LON (0u),
    _LocationAttribute (0u),
    _DestOrWayPointType (0u),
    _Address (),
    _PhoneNumber (),
    _PhoneNumberForDisp (),
    _Text (),
    _TextForTTS (),
    _IconID (0u),
    _SoundIDForBeginningOfPlay (0u),
    _SoundIDForBGM (0u),
    _ActionSWID (0u),
    _ParameterOfActionSW (0u),
    _FlagOfDispButtonCtrl (0u),
    _FlagOfCtrlDuringRunning (0u),
    _NameOfImageButton (),
    _NameOfActionSW (),
    _FlagOfExecOfChannelContents (0u),
    _FlagOfStoringCtrl (0u),
    _ImageAvailability (0u),
    _ImagePath (),
    _ChannelID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ContentData::ContentData (uint8 ChannelContentsID_, const ::std::string& Title_, const ::std::string& TitleForTTS_, uint8 Direction_, uint32 LAT_, uint32 LON_, uint8 LocationAttribute_, uint8 DestOrWayPointType_, const ::std::string& Address_, const ::std::string& PhoneNumber_, const ::std::string& PhoneNumberForDisp_, const ::std::string& Text_, const ::std::string& TextForTTS_, uint16 IconID_, uint16 SoundIDForBeginningOfPlay_, uint16 SoundIDForBGM_, uint8 ActionSWID_, uint32 ParameterOfActionSW_, uint8 FlagOfDispButtonCtrl_, uint8 FlagOfCtrlDuringRunning_, const ::std::string& NameOfImageButton_, const ::std::string& NameOfActionSW_, uint8 FlagOfExecOfChannelContents_, uint8 FlagOfStoringCtrl_, uint8 ImageAvailability_, const ::std::string& ImagePath_, uint16 ChannelID_)  :
    _ChannelContentsID (ChannelContentsID_),
    _Title (Title_),
    _TitleForTTS (TitleForTTS_),
    _Direction (Direction_),
    _LAT (LAT_),
    _LON (LON_),
    _LocationAttribute (LocationAttribute_),
    _DestOrWayPointType (DestOrWayPointType_),
    _Address (Address_),
    _PhoneNumber (PhoneNumber_),
    _PhoneNumberForDisp (PhoneNumberForDisp_),
    _Text (Text_),
    _TextForTTS (TextForTTS_),
    _IconID (IconID_),
    _SoundIDForBeginningOfPlay (SoundIDForBeginningOfPlay_),
    _SoundIDForBGM (SoundIDForBGM_),
    _ActionSWID (ActionSWID_),
    _ParameterOfActionSW (ParameterOfActionSW_),
    _FlagOfDispButtonCtrl (FlagOfDispButtonCtrl_),
    _FlagOfCtrlDuringRunning (FlagOfCtrlDuringRunning_),
    _NameOfImageButton (NameOfImageButton_),
    _NameOfActionSW (NameOfActionSW_),
    _FlagOfExecOfChannelContents (FlagOfExecOfChannelContents_),
    _FlagOfStoringCtrl (FlagOfStoringCtrl_),
    _ImageAvailability (ImageAvailability_),
    _ImagePath (ImagePath_),
    _ChannelID (ChannelID_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Title_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TitleForTTS_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Address_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (PhoneNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (PhoneNumberForDisp_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Text_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TextForTTS_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (NameOfImageButton_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (NameOfActionSW_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ImagePath_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ContentData::~ContentData() {
}

inline ContentData& ContentData::operator = (const ContentData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasChannelContentsID()) {
            setChannelContentsID(rhs.getChannelContentsID());
        } else {
            clearChannelContentsID();
        }
        if (rhs.hasTitle()) {
            setTitle(rhs.getTitle());
        } else {
            clearTitle();
        }
        if (rhs.hasTitleForTTS()) {
            setTitleForTTS(rhs.getTitleForTTS());
        } else {
            clearTitleForTTS();
        }
        if (rhs.hasDirection()) {
            setDirection(rhs.getDirection());
        } else {
            clearDirection();
        }
        if (rhs.hasLAT()) {
            setLAT(rhs.getLAT());
        } else {
            clearLAT();
        }
        if (rhs.hasLON()) {
            setLON(rhs.getLON());
        } else {
            clearLON();
        }
        if (rhs.hasLocationAttribute()) {
            setLocationAttribute(rhs.getLocationAttribute());
        } else {
            clearLocationAttribute();
        }
        if (rhs.hasDestOrWayPointType()) {
            setDestOrWayPointType(rhs.getDestOrWayPointType());
        } else {
            clearDestOrWayPointType();
        }
        if (rhs.hasAddress()) {
            setAddress(rhs.getAddress());
        } else {
            clearAddress();
        }
        if (rhs.hasPhoneNumber()) {
            setPhoneNumber(rhs.getPhoneNumber());
        } else {
            clearPhoneNumber();
        }
        if (rhs.hasPhoneNumberForDisp()) {
            setPhoneNumberForDisp(rhs.getPhoneNumberForDisp());
        } else {
            clearPhoneNumberForDisp();
        }
        if (rhs.hasText()) {
            setText(rhs.getText());
        } else {
            clearText();
        }
        if (rhs.hasTextForTTS()) {
            setTextForTTS(rhs.getTextForTTS());
        } else {
            clearTextForTTS();
        }
        if (rhs.hasIconID()) {
            setIconID(rhs.getIconID());
        } else {
            clearIconID();
        }
        if (rhs.hasSoundIDForBeginningOfPlay()) {
            setSoundIDForBeginningOfPlay(rhs.getSoundIDForBeginningOfPlay());
        } else {
            clearSoundIDForBeginningOfPlay();
        }
        if (rhs.hasSoundIDForBGM()) {
            setSoundIDForBGM(rhs.getSoundIDForBGM());
        } else {
            clearSoundIDForBGM();
        }
        if (rhs.hasActionSWID()) {
            setActionSWID(rhs.getActionSWID());
        } else {
            clearActionSWID();
        }
        if (rhs.hasParameterOfActionSW()) {
            setParameterOfActionSW(rhs.getParameterOfActionSW());
        } else {
            clearParameterOfActionSW();
        }
        if (rhs.hasFlagOfDispButtonCtrl()) {
            setFlagOfDispButtonCtrl(rhs.getFlagOfDispButtonCtrl());
        } else {
            clearFlagOfDispButtonCtrl();
        }
        if (rhs.hasFlagOfCtrlDuringRunning()) {
            setFlagOfCtrlDuringRunning(rhs.getFlagOfCtrlDuringRunning());
        } else {
            clearFlagOfCtrlDuringRunning();
        }
        if (rhs.hasNameOfImageButton()) {
            setNameOfImageButton(rhs.getNameOfImageButton());
        } else {
            clearNameOfImageButton();
        }
        if (rhs.hasNameOfActionSW()) {
            setNameOfActionSW(rhs.getNameOfActionSW());
        } else {
            clearNameOfActionSW();
        }
        if (rhs.hasFlagOfExecOfChannelContents()) {
            setFlagOfExecOfChannelContents(rhs.getFlagOfExecOfChannelContents());
        } else {
            clearFlagOfExecOfChannelContents();
        }
        if (rhs.hasFlagOfStoringCtrl()) {
            setFlagOfStoringCtrl(rhs.getFlagOfStoringCtrl());
        } else {
            clearFlagOfStoringCtrl();
        }
        if (rhs.hasImageAvailability()) {
            setImageAvailability(rhs.getImageAvailability());
        } else {
            clearImageAvailability();
        }
        if (rhs.hasImagePath()) {
            setImagePath(rhs.getImagePath());
        } else {
            clearImagePath();
        }
        if (rhs.hasChannelID()) {
            setChannelID(rhs.getChannelID());
        } else {
            clearChannelID();
        }
    }
    return *this;
}

inline bool ContentData::operator == (const ContentData& rhs) const {
    return (((!hasChannelContentsID() && !rhs.hasChannelContentsID()) || getChannelContentsID() == rhs.getChannelContentsID()) &&
        ((!hasTitle() && !rhs.hasTitle()) || getTitle() == rhs.getTitle()) &&
        ((!hasTitleForTTS() && !rhs.hasTitleForTTS()) || getTitleForTTS() == rhs.getTitleForTTS()) &&
        ((!hasDirection() && !rhs.hasDirection()) || getDirection() == rhs.getDirection()) &&
        ((!hasLAT() && !rhs.hasLAT()) || getLAT() == rhs.