/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/stream/json.h"
#include "tcu_main_fi_types.h"
#include "tcu_main_fi_typesConst.h"
#include "tcu_main_fi_typesJson.h"
#include "tcu_main_fi_typesJsonPrivate.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

using namespace ::asf::stream::json;


// Json serialization of "T_TCU_VersionInfo"

void serializeJson (const ::tcu_main_fi_types::T_TCU_VersionInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8Upper()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Upper" , 7);
        yajl_gen_integer(g, (long long)value.getU8Upper());
    }
    if (!isSparse || value.hasU8Mid()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Mid" , 5);
        yajl_gen_integer(g, (long long)value.getU8Mid());
    }
    if (!isSparse || value.hasU8Lower()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Lower" , 7);
        yajl_gen_integer(g, (long long)value.getU8Lower());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi_types::T_TCU_VersionInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TCU_Date_Time"

void serializeJson (const ::tcu_main_fi_types::T_TCU_Date_Time& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU16Year()) {
        yajl_gen_string(g, (const unsigned char*)  "u16Year" , 7);
        yajl_gen_integer(g, (long long)value.getU16Year());
    }
    if (!isSparse || value.hasU8Month()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Month" , 7);
        yajl_gen_integer(g, (long long)value.getU8Month());
    }
    if (!isSparse || value.hasU8Day()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Day" , 5);
        yajl_gen_integer(g, (long long)value.getU8Day());
    }
    if (!isSparse || value.hasU8Hour()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Hour" , 6);
        yajl_gen_integer(g, (long long)value.getU8Hour());
    }
    if (!isSparse || value.hasU8Minute()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Minute" , 8);
        yajl_gen_integer(g, (long long)value.getU8Minute());
    }
    if (!isSparse || value.hasU8Second()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Second" , 8);
        yajl_gen_integer(g, (long long)value.getU8Second());
    }
    if (!isSparse || value.hasU8Reserve()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Reserve" , 9);
        yajl_gen_integer(g, (long long)value.getU8Reserve());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi_types::T_TCU_Date_Time& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TCU_Navi_Info"

void serializeJson (const ::tcu_main_fi_types::T_TCU_Navi_Info& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLocationInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "LocationInfo" , 12);
        serializeJson(value.getLocationInfo(), g, options);
    }
    if (!isSparse || value.hasRDateTime()) {
        yajl_gen_string(g, (const unsigned char*)  "rDateTime" , 9);
        serializeJson(value.getRDateTime(), g, options);
    }
    if (!isSparse || value.hasU16VehicleHeading()) {
        yajl_gen_string(g, (const unsigned char*)  "u16VehicleHeading" , 17);
        yajl_gen_integer(g, (long long)value.getU16VehicleHeading());
    }
    if (!isSparse || value.hasU8TimeZone()) {
        yajl_gen_string(g, (const unsigned char*)  "u8TimeZone" , 10);
        yajl_gen_integer(g, (long long)value.getU8TimeZone());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi_types::T_TCU_Navi_Info& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TCU_LocationInfo"

void serializeJson (const ::tcu_main_fi_types::T_TCU_LocationInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8LocationType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8LocationType" , 14);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_LocationType_Name(value.getE8LocationType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8LocationType());
    }
    if (!isSparse || value.hasE8Latitudemode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Latitudemode" , 14);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_LatitudeMode_Name(value.getE8Latitudemode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Latitudemode());
    }
    if (!isSparse || value.hasE8LongitudeMode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8LongitudeMode" , 15);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_LongitudeMode_Name(value.getE8LongitudeMode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8LongitudeMode());
    }
    if (!isSparse || value.hasU8LatitudeDEG()) {
        yajl_gen_string(g, (const unsigned char*)  "u8LatitudeDEG" , 13);
        yajl_gen_integer(g, (long long)value.getU8LatitudeDEG());
    }
    if (!isSparse || value.hasU8LatitudeMIN()) {
        yajl_gen_string(g, (const unsigned char*)  "u8LatitudeMIN" , 13);
        yajl_gen_integer(g, (long long)value.getU8LatitudeMIN());
    }
    if (!isSparse || value.hasU16LatitudeSEC()) {
        yajl_gen_string(g, (const unsigned char*)  "u16LatitudeSEC" , 14);
        yajl_gen_integer(g, (long long)value.getU16LatitudeSEC());
    }
    if (!isSparse || value.hasU8LongitudeDEG()) {
        yajl_gen_string(g, (const unsigned char*)  "u8LongitudeDEG" , 14);
        yajl_gen_integer(g, (long long)value.getU8LongitudeDEG());
    }
    if (!isSparse || value.hasU8LongitudeMIN()) {
        yajl_gen_string(g, (const unsigned char*)  "u8LongitudeMIN" , 14);
        yajl_gen_integer(g, (long long)value.getU8LongitudeMIN());
    }
    if (!isSparse || value.hasU16LongitudeSEC()) {
        yajl_gen_string(g, (const unsigned char*)  "u16LongitudeSEC" , 15);
        yajl_gen_integer(g, (long long)value.getU16LongitudeSEC());
    }
    if (!isSparse || value.hasAltitude()) {
        yajl_gen_string(g, (const unsigned char*)  "Altitude" , 8);
        serializeJson(value.getAltitude(), g, options);
    }
    if (!isSparse || value.hasU8SatelliteNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "u8SatelliteNumber" , 17);
        yajl_gen_integer(g, (long long)value.getU8SatelliteNumber());
    }
    if (!isSparse || value.hasE8Home()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Home" , 6);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Home_Name(value.getE8Home());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Home());
    }
    if (!isSparse || value.hasU8Reserve()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Reserve" , 9);
        yajl_gen_integer(g, (long long)value.getU8Reserve());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi_types::T_TCU_LocationInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TCU_Altitude"

void serializeJson (const ::tcu_main_fi_types::T_TCU_Altitude& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Sign()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Sign" , 6);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Sign_Name(value.getE8Sign());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Sign());
    }
    if (!isSparse || value.hasU16Value()) {
        yajl_gen_string(g, (const unsigned char*)  "u16Value" , 8);
        yajl_gen_integer(g, (long long)value.getU16Value());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi_types::T_TCU_Altitude& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TCU_Score_Info"

void serializeJson (const ::tcu_main_fi_types::T_TCU_Score_Info& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8ECOScore()) {
        yajl_gen_string(g, (const unsigned char*)  "u8ECOScore" , 10);
        yajl_gen_integer(g, (long long)value.getU8ECOScore());
    }
    if (!isSparse || value.hasU8StartScore()) {
        yajl_gen_string(g, (const unsigned char*)  "u8StartScore" , 12);
        yajl_gen_integer(g, (long long)value.getU8StartScore());
    }
    if (!isSparse || value.hasU8CruiseScore()) {
        yajl_gen_string(g, (const unsigned char*)  "u8CruiseScore" , 13);
        yajl_gen_integer(g, (long long)value.getU8CruiseScore());
    }
    if (!isSparse || value.hasU8SlowdownScore()) {
        yajl_gen_string(g, (const unsigned char*)  "u8SlowdownScore" , 15);
        yajl_gen_integer(g, (long long)value.getU8SlowdownScore());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi_types::T_TCU_Score_Info& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TCU_Probe_Vehicle_Info"

void serializeJson (const ::tcu_main_fi_types::T_TCU_Probe_Vehicle_Info& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU16NaviVehicleSpeed()) {
        yajl_gen_string(g, (const unsigned char*)  "u16NaviVehicleSpeed" , 19);
        yajl_gen_integer(g, (long long)value.getU16NaviVehicleSpeed());
    }
    if (!isSparse || value.hasU32NaviDrivingDistance()) {
        yajl_gen_string(g, (const unsigned char*)  "u32NaviDrivingDistance" , 22);
        yajl_gen_integer(g, (long long)value.getU32NaviDrivingDistance());
    }
    if (!isSparse || value.hasNaviRoadClassification()) {
        yajl_gen_string(g, (const unsigned char*)  "NaviRoadClassification" , 22);
        serializeJson(value.getNaviRoadClassification(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi_types::T_TCU_Probe_Vehicle_Info& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TCU_Navi_Road_classification"

void serializeJson (const ::tcu_main_fi_types::T_TCU_Navi_Road_classification& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8TableType()) {
        yajl_gen_string(g, (const unsigned char*)  "u8TableType" , 11);
        yajl_gen_integer(g, (long long)value.getU8TableType());
    }
    if (!isSparse || value.hasU8RoadType()) {
        yajl_gen_string(g, (const unsigned char*)  "u8RoadType" , 10);
        yajl_gen_integer(g, (long long)value.getU8RoadType());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi_types::T_TCU_Navi_Road_classification& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TCU_Maintenance_Info"

void serializeJson (const ::tcu_main_fi_types::T_TCU_Maintenance_Info& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8DistanceUnit()) {
        yajl_gen_string(g, (const unsigned char*)  "e8DistanceUnit" , 14);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Distance_Unit_Name(value.getE8DistanceUnit());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8DistanceUnit());
    }
    if (!isSparse || value.hasRDistanceValue()) {
        yajl_gen_string(g, (const unsigned char*)  "rDistanceValue" , 14);
        serializeJson(value.getRDistanceValue(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi_types::T_TCU_Maintenance_Info& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TCU_Distance_Value"

void serializeJson (const ::tcu_main_fi_types::T_TCU_Distance_Value& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU16OilFilter()) {
        yajl_gen_string(g, (const unsigned char*)  "u16OilFilter" , 12);
        yajl_gen_integer(g, (long long)value.getU16OilFilter());
    }
    if (!isSparse || value.hasU16Oil()) {
        yajl_gen_string(g, (const unsigned char*)  "u16Oil" , 6);
        yajl_gen_integer(g, (long long)value.getU16Oil());
    }
    if (!isSparse || value.hasU16Tire()) {
        yajl_gen_string(g, (const unsigned char*)  "u16Tire" , 7);
        yajl_gen_integer(g, (long long)value.getU16Tire());
    }
    if (!isSparse || value.hasU16User()) {
        yajl_gen_string(g, (const unsigned char*)  "u16User" , 7);
        yajl_gen_integer(g, (long long)value.getU16User());
    }
    if (!isSparse || value.hasU16Battery()) {
        yajl_gen_string(g, (const unsigned char*)  "u16Battery" , 10);
        yajl_gen_integer(g, (long long)value.getU16Battery());
    }
    if (!isSparse || value.hasU16ACFilter()) {
        yajl_gen_string(g, (const unsigned char*)  "u16ACFilter" , 11);
        yajl_gen_integer(g, (long long)value.getU16ACFilter());
    }
    if (!isSparse || value.hasU16Reserve()) {
        yajl_gen_string(g, (const unsigned char*)  "u16Reserve" , 10);
        yajl_gen_integer(g, (long long)value.getU16Reserve());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi_types::T_TCU_Distance_Value& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TCU_Provision_List"

void serializeJson (const ::tcu_main_fi_types::T_TCU_Provision_List& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBOperatorService()) {
        yajl_gen_string(g, (const unsigned char*)  "bOperatorService" , 16);
        yajl_gen_bool(g, (bool)value.getBOperatorService());
    }
    if (!isSparse || value.hasBConnectedSearch()) {
        yajl_gen_string(g, (const unsigned char*)  "bConnectedSearch" , 16);
        yajl_gen_bool(g, (bool)value.getBConnectedSearch());
    }
    if (!isSparse || value.hasBMobileInformation()) {
        yajl_gen_string(g, (const unsigned char*)  "bMobileInformation" , 18);
        yajl_gen_bool(g, (bool)value.getBMobileInformation());
    }
    if (!isSparse || value.hasU16ReserveNissan()) {
        yajl_gen_string(g, (const unsigned char*)  "u16ReserveNissan" , 16);
        yajl_gen_integer(g, (long long)value.getU16ReserveNissan());
    }
    if (!isSparse || value.hasBInternetWidget()) {
        yajl_gen_string(g, (const unsigned char*)  "bInternetWidget" , 15);
        yajl_gen_bool(g, (bool)value.getBInternetWidget());
    }
    if (!isSparse || value.hasBFuelPrice()) {
        yajl_gen_string(g, (const unsigned char*)  "bFuelPrice" , 10);
        yajl_gen_bool(g, (bool)value.getBFuelPrice());
    }
    if (!isSparse || value.hasBLocalSearch()) {
        yajl_gen_string(g, (const unsigned char*)  "bLocalSearch" , 12);
        yajl_gen_bool(g, (bool)value.getBLocalSearch());
    }
    if (!isSparse || value.hasBWebPreTrip()) {
        yajl_gen_string(g, (const unsigned char*)  "bWebPreTrip" , 11);
        yajl_gen_bool(g, (bool)value.getBWebPreTrip());
    }
    if (!isSparse || value.hasBHDTraffic()) {
        yajl_gen_string(g, (const unsigned char*)  "bHDTraffic" , 10);
        yajl_gen_bool(g, (bool)value.getBHDTraffic());
    }
    if (!isSparse || value.hasBSpeedTrap()) {
        yajl_gen_string(g, (const unsigned char*)  "bSpeedTrap" , 10);
        yajl_gen_bool(g, (bool)value.getBSpeedTrap());
    }
    if (!isSparse || value.hasBPreventNav()) {
        yajl_gen_string(g, (const unsigned char*)  "bPreventNav" , 11);
        yajl_gen_bool(g, (bool)value.getBPreventNav());
    }
    if (!isSparse || value.hasBWeather()) {
        yajl_gen_string(g, (const unsigned char*)  "bWeather" , 8);
        yajl_gen_bool(g, (bool)value.getBWeather());
    }
    if (!isSparse || value.hasBLiveServices()) {
        yajl_gen_string(g, (const unsigned char*)  "bLiveServices" , 13);
        yajl_gen_bool(g, (bool)value.getBLiveServices());
    }
    if (!isSparse || value.hasBChargingSpotFinder()) {
        yajl_gen_string(g, (const unsigned char*)  "bChargingSpotFinder" , 19);
        yajl_gen_bool(g, (bool)value.getBChargingSpotFinder());
    }
    if (!isSparse || value.hasBChargingSchedule()) {
        yajl_gen_string(g, (const unsigned char*)  "bChargingSchedule" , 17);
        yajl_gen_bool(g, (bool)value.getBChargingSchedule());
    }
    if (!isSparse || value.hasU16ReserveRenault()) {
        yajl_gen_string(g, (const unsigned char*)  "u16ReserveRenault" , 17);
        yajl_gen_integer(g, (long long)value.getU16ReserveRenault());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi_types::T_TCU_Provision_List& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TCU_ReminderInfo"

void serializeJson (const ::tcu_main_fi_types::T_TCU_ReminderInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Plugin_Mode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Plugin_Mode" , 13);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Mode_Name(value.getE8Plugin_Mode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Plugin_Mode());
    }
    if (!isSparse || value.hasE8Stop_Mode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Stop_Mode" , 11);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Mode_Name(value.getE8Stop_Mode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Stop_Mode());
    }
    if (!isSparse || value.hasU16RemainTime()) {
        yajl_gen_string(g, (const unsigned char*)  "u16RemainTime" , 13);
        yajl_gen_integer(g, (long long)value.getU16RemainTime());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi_types::T_TCU_ReminderInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TCU_GPS_Position"

void serializeJson (const ::tcu_main_fi_types::T_TCU_GPS_Position& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8Reserved()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Reserved" , 10);
        yajl_gen_integer(g, (long long)value.getU8Reserved());
    }
    if (!isSparse || value.hasE8LocationType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8LocationType" , 14);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_LocationType_Name(value.getE8LocationType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8LocationType());
    }
    if (!isSparse || value.hasE8Latitudemode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Latitudemode" , 14);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_LatitudeMode_Name(value.getE8Latitudemode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Latitudemode());
    }
    if (!isSparse || value.hasE8LongitudeMode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8LongitudeMode" , 15);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_LongitudeMode_Name(value.getE8LongitudeMode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8LongitudeMode());
    }
    if (!isSparse || value.hasU8LatitudeDEG()) {
        yajl_gen_string(g, (const unsigned char*)  "u8LatitudeDEG" , 13);
        yajl_gen_integer(g, (long long)value.getU8LatitudeDEG());
    }
    if (!isSparse || value.hasU8LatitudeMIN()) {
        yajl_gen_string(g, (const unsigned char*)  "u8LatitudeMIN" , 13);
        yajl_gen_integer(g, (long long)value.getU8LatitudeMIN());
    }
    if (!isSparse || value.hasU16LatitudeSEC()) {
        yajl_gen_string(g, (const unsigned char*)  "u16LatitudeSEC" , 14);
        yajl_gen_integer(g, (long long)value.getU16LatitudeSEC());
    }
    if (!isSparse || value.hasU8LongitudeDEG()) {
        yajl_gen_string(g, (const unsigned char*)  "u8LongitudeDEG" , 14);
        yajl_gen_integer(g, (long long)value.getU8LongitudeDEG());
    }
    if (!isSparse || value.hasU8LongitudeMIN()) {
        yajl_gen_string(g, (const unsigned char*)  "u8LongitudeMIN" , 14);
        yajl_gen_integer(g, (long long)value.getU8LongitudeMIN());
    }
    if (!isSparse || value.hasU16LongitudeSEC()) {
        yajl_gen_string(g, (const unsigned char*)  "u16LongitudeSEC" , 15);
        yajl_gen_integer(g, (long long)value.getU16LongitudeSEC());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi_types::T_TCU_GPS_Position& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TCU_Time_Stamp"

void serializeJson (const ::tcu_main_fi_types::T_TCU_Time_Stamp& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8Year()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Year" , 6);
        yajl_gen_integer(g, (long long)value.getU8Year());
    }
    if (!isSparse || value.hasU8Month()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Month" , 7);
        yajl_gen_integer(g, (long long)value.getU8Month());
    }
    if (!isSparse || value.hasU8Day()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Day" , 5);
        yajl_gen_integer(g, (long long)value.getU8Day());
    }
    if (!isSparse || value.hasU8Hour()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Hour" , 6);
        yajl_gen_integer(g, (long long)value.getU8Hour());
    }
    if (!isSparse || value.hasU8Minute()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Minute" , 8);
        yajl_gen_integer(g, (long long)value.getU8Minute());
    }
    if (!isSparse || value.hasU8Second()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Second" , 8);
        yajl_gen_integer(g, (long long)value.getU8Second());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi_types::T_TCU_Time_Stamp& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TCU_Opening_Hour"

void serializeJson (const ::tcu_main_fi_types::T_TCU_Opening_Hour& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRSunday()) {
        yajl_gen_string(g, (const unsigned char*)  "rSunday" , 7);
        serializeJson(value.getRSunday(), g, options);
    }
    if (!isSparse || value.hasRMonday()) {
        yajl_gen_string(g, (const unsigned char*)  "rMonday" , 7);
        serializeJson(value.getRMonday(), g, options);
    }
    if (!isSparse || value.hasRTuesday()) {
        yajl_gen_string(g, (const unsigned char*)  "rTuesday" , 8);
        serializeJson(value.getRTuesday(), g, options);
    }
    if (!isSparse || value.hasRWednesday()) {
        yajl_gen_string(g, (const unsigned char*)  "rWednesday" , 10);
        serializeJson(value.getRWednesday(), g, options);
    }
    if (!isSparse || value.hasRThursday()) {
        yajl_gen_string(g, (const unsigned char*)  "rThursday" , 9);
        serializeJson(value.getRThursday(), g, options);
    }
    if (!isSparse || value.hasRFriday()) {
        yajl_gen_string(g, (const unsigned char*)  "rFriday" , 7);
        serializeJson(value.getRFriday(), g, options);
    }
    if (!isSparse || value.hasRSaturday()) {
        yajl_gen_string(g, (const unsigned char*)  "rSaturday" , 9);
        serializeJson(value.getRSaturday(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi_types::T_TCU_Opening_Hour& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TCU_Opening_Hour_Day"

void serializeJson (const ::tcu_main_fi_types::T_TCU_Opening_Hour_Day& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8StartTime_1()) {
        yajl_gen_string(g, (const unsigned char*)  "u8StartTime_1" , 13);
        yajl_gen_integer(g, (long long)value.getU8StartTime_1());
    }
    if (!isSparse || value.hasU8StartTime_2()) {
        yajl_gen_string(g, (const unsigned char*)  "u8StartTime_2" , 13);
        yajl_gen_integer(g, (long long)value.getU8StartTime_2());
    }
    if (!isSparse || value.hasU8EndTime_1()) {
        yajl_gen_string(g, (const unsigned char*)  "u8EndTime_1" , 11);
        yajl_gen_integer(g, (long long)value.getU8EndTime_1());
    }
    if (!isSparse || value.hasU8EndTime_2()) {
        yajl_gen_string(g, (const unsigned char*)  "u8EndTime_2" , 11);
        yajl_gen_integer(g, (long long)value.getU8EndTime_2());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi_types::T_TCU_Opening_Hour_Day& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TCU_Full_Address"

void serializeJson (const ::tcu_main_fi_types::T_TCU_Full_Address& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8Length_of_Text()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Length_of_Text" , 16);
        yajl_gen_integer(g, (long long)value.getU8Length_of_Text());
    }
    if (!isSparse || value.hasSText_Info()) {
        yajl_gen_string(g, (const unsigned char*)  "sText_Info" , 10);
        const char *s = value.getSText_Info().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi_types::T_TCU_Full_Address& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TCU_Charge_Spot_List"

void serializeJson (const ::tcu_main_fi_types::T_TCU_Charge_Spot_List& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8Total_pages_of_lists()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Total_pages_of_lists" , 22);
        yajl_gen_integer(g, (long long)value.getU8Total_pages_of_lists());
    }
    if (!isSparse || value.hasU8Pages_of_list()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Pages_of_list" , 15);
        yajl_gen_integer(g, (long long)value.getU8Pages_of_list());
    }
    if (!isSparse || value.hasU8Station_List_Number()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Station_List_Number" , 21);
        yajl_gen_integer(g, (long long)value.getU8Station_List_Number());
    }
    if (!isSparse || value.hasRSpot_List1()) {
        yajl_gen_string(g, (const unsigned char*)  "rSpot_List1" , 11);
        serializeJson(value.getRSpot_List1(), g, options);
    }
    if (!isSparse || value.hasRSpot_List2()) {
        yajl_gen_string(g, (const unsigned char*)  "rSpot_List2" , 11);
        serializeJson(value.getRSpot_List2(), g, options);
    }
    if (!isSparse || value.hasRSpot_List3()) {
        yajl_gen_string(g, (const unsigned char*)  "rSpot_List3" , 11);
        serializeJson(value.getRSpot_List3(), g, options);
    }
    if (!isSparse || value.hasRSpot_List4()) {
        yajl_gen_string(g, (const unsigned char*)  "rSpot_List4" , 11);
        serializeJson(value.getRSpot_List4(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi_types::T_TCU_Charge_Spot_List& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TCU_Spot_List"

void serializeJson (const ::tcu_main_fi_types::T_TCU_Spot_List& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSCharge_Spot_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "sCharge_Spot_ID" , 15);
        const char *s = value.getSCharge_Spot_ID().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasE8Bookable_Information()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Bookable_Information" , 22);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Bookable_Information_Name(value.getE8Bookable_Information());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Bookable_Information());
    }
    if (!isSparse || value.hasE8Spot_Availability()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Spot_Availability" , 19);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Spot_Availability_Name(value.getE8Spot_Availability());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Spot_Availability());
    }
    if (!isSparse || value.hasRBookable_Free_Text()) {
        yajl_gen_string(g, (const unsigned char*)  "rBookable_Free_Text" , 19);
        serializeJson(value.getRBookable_Free_Text(), g, options);
    }
    if (!isSparse || value.hasU8Total_Number_Receptacles()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Total_Number_Receptacles" , 26);
        yajl_gen_integer(g, (long long)value.getU8Total_Number_Receptacles());
    }
    if (!isSparse || value.hasRReceptacle1()) {
        yajl_gen_string(g, (const unsigned char*)  "rReceptacle1" , 12);
        serializeJson(value.getRReceptacle1(), g, options);
    }
    if (!isSparse || value.hasRReceptacle2()) {
        yajl_gen_string(g, (const unsigned char*)  "rReceptacle2" , 12);
        serializeJson(value.getRReceptacle2(), g, options);
    }
    if (!isSparse || value.hasRReceptacle3()) {
        yajl_gen_string(g, (const unsigned char*)  "rReceptacle3" , 12);
        serializeJson(value.getRReceptacle3(), g, options);
    }
    if (!isSparse || value.hasRReceptacle4()) {
        yajl_gen_string(g, (const unsigned char*)  "rReceptacle4" , 12);
        serializeJson(value.getRReceptacle4(), g, options);
    }
    if (!isSparse || value.hasRReceptacle5()) {
        yajl_gen_string(g, (const unsigned char*)  "rReceptacle5" , 12);
        serializeJson(value.getRReceptacle5(), g, options);
    }
    if (!isSparse || value.hasRReceptacle6()) {
        yajl_gen_string(g, (const unsigned char*)  "rReceptacle6" , 12);
        serializeJson(value.getRReceptacle6(), g, options);
    }
    if (!isSparse || value.hasRReceptacle7()) {
        yajl_gen_string(g, (const unsigned char*)  "rReceptacle7" , 12);
        serializeJson(value.getRReceptacle7(), g, options);
    }
    if (!isSparse || value.hasRReceptacle8()) {
        yajl_gen_string(g, (const unsigned char*)  "rReceptacle8" , 12);
        serializeJson(value.getRReceptacle8(), g, options);
    }
    if (!isSparse || value.hasRReceptacle9()) {
        yajl_gen_string(g, (const unsigned char*)  "rReceptacle9" , 12);
        serializeJson(value.getRReceptacle9(), g, options);
    }
    if (!isSparse || value.hasRReceptacle10()) {
        yajl_gen_string(g, (const unsigned char*)  "rReceptacle10" , 13);
        serializeJson(value.getRReceptacle10(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi_types::T_TCU_Spot_List& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TCU_Bookable_Free_Text"

void serializeJson (const ::tcu_main_fi_types::T_TCU_Bookable_Free_Text& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8Length_of_Text()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Length_of_Text" , 16);
        yajl_gen_integer(g, (long long)value.getU8Length_of_Text());
    }
    if (!isSparse || value.hasSText_Info()) {
        yajl_gen_string(g, (const unsigned char*)  "sText_Info" , 10);
        const char *s = value.getSText_Info().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi_types::T_TCU_Bookable_Free_Text& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TCU_Receptacle"

void serializeJson (const ::tcu_main_fi_types::T_TCU_Receptacle& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Charge_Receptacle_Type()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Charge_Receptacle_Type" , 24);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Charge_Receptacle_Type_Name(value.getE8Charge_Receptacle_Type());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Charge_Receptacle_Type());
    }
    if (!isSparse || value.hasU16Available_Power()) {
        yajl_gen_string(g, (const unsigned char*)  "u16Available_Power" , 18);
        yajl_gen_integer(g, (long long)value.getU16Available_Power());
    }
    if (!isSparse || value.hasE8Charge_Receptacle_Facility()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Charge_Receptacle_Facility" , 28);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Charge_Receptacle_Facility_Name(value.getE8Charge_Receptacle_Facility());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Charge_Receptacle_Facility());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi_types::T_TCU_Receptacle& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TCU_Time"

void serializeJson (const ::tcu_main_fi_types::T_TCU_Time& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8Hour()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Hour" , 6);
        yajl_gen_integer(g, (long long)value.getU8Hour());
    }
    if (!isSparse || value.hasU8Minute()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Minute" , 8);
        yajl_gen_integer(g, (long long)value.getU8Minute());
    }
    if (!isSparse || value.hasU8Seconds()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Seconds" , 9);
        yajl_gen_integer(g, (long long)value.getU8Seconds());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi_types::T_TCU_Time& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TCU_Navigation_Language"

void serializeJson (const ::tcu_main_fi_types::T_TCU_Navigation_Language& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8Reserved()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Reserved" , 10);
        yajl_gen_integer(g, (long long)value.getU8Reserved());
    }
    if (!isSparse || value.hasE8Language_Family_Type()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Language_Family_Type" , 22);
        const char* s = ::tcu_main_fi_types::T_e8_Language_Family_Type_Name(value.getE8Language_Family_Type());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Language_Family_Type());
    }
    if (!isSparse || value.hasE8Language_Type()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Language_Type" , 15);
        const char* s = ::tcu_main_fi_types::T_e8_Language_Type_Name(value.getE8Language_Type());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Language_Type());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi_types::T_TCU_Navigation_Language& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TCU_Charge_Days"

void serializeJson (const ::tcu_main_fi_types::T_TCU_Charge_Days& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDay1()) {
        yajl_gen_string(g, (const unsigned char*)  "Day1" , 4);
        yajl_gen_integer(g, (long long)value.getDay1());
    }
    if (!isSparse || value.hasDay2()) {
        yajl_gen_string(g, (const unsigned char*)  "Day2" , 4);
        yajl_gen_integer(g, (long long)value.getDay2());
    }
    if (!isSparse || value.hasDay3()) {
        yajl_gen_string(g, (const unsigned char*)  "Day3" , 4);
        yajl_gen_integer(g, (long long)value.getDay3());
    }
    if (!isSparse || value.hasDay4()) {
        yajl_gen_string(g, (const unsigned char*)  "Day4" , 4);
        yajl_gen_integer(g, (long long)value.getDay4());
    }
    if (!isSparse || value.hasDay5()) {
        yajl_gen_string(g, (const unsigned char*)  "Day5" , 4);
        yajl_gen_integer(g, (long long)value.getDay5());
    }
    if (!isSparse || value.hasDay6()) {
        yajl_gen_string(g, (const unsigned char*)  "Day6" , 4);
        yajl_gen_integer(g, (long long)value.getDay6());
    }
    if (!isSparse || value.hasDay7()) {
        yajl_gen_string(g, (const unsigned char*)  "Day7" , 4);
        yajl_gen_integer(g, (long long)value.getDay7());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi_types::T_TCU_Charge_Days& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TCU_Spot_Receptacle_Type"

void serializeJson (const ::tcu_main_fi_types::T_TCU_Spot_Receptacle_Type& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRDefault_receptacle_type()) {
        yajl_gen_string(g, (const unsigned char*)  "rDefault_receptacle_type" , 24);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Charge_Receptacle_Type_Name(value.getRDefault_receptacle_type());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getRDefault_receptacle_type());
    }
    if (!isSparse || value.hasRUser_receptacle_type_1()) {
        yajl_gen_string(g, (const unsigned char*)  "rUser_receptacle_type_1" , 23);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Charge_Receptacle_Type_Name(value.getRUser_receptacle_type_1());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getRUser_receptacle_type_1());
    }
    if (!isSparse || value.hasRUser_receptacle_type_2()) {
        yajl_gen_string(g, (const unsigned char*)  "rUser_receptacle_type_2" , 23);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Charge_Receptacle_Type_Name(value.getRUser_receptacle_type_2());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getRUser_receptacle_type_2());
    }
    if (!isSparse || value.hasRUser_receptacle_type_3()) {
        yajl_gen_string(g, (const unsigned char*)  "rUser_receptacle_type_3" , 23);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Charge_Receptacle_Type_Name(value.getRUser_receptacle_type_3());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getRUser_receptacle_type_3());
    }
    if (!isSparse || value.hasU8Reserved1()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Reserved1" , 11);
        yajl_gen_integer(g, (long long)value.getU8Reserved1());
    }
    if (!isSparse || value.hasU8Reserved2()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Reserved2" , 11);
        yajl_gen_integer(g, (long long)value.getU8Reserved2());
    }
    if (!isSparse || value.hasU8Reserved3()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Reserved3" , 11);
        yajl_gen_integer(g, (long long)value.getU8Reserved3());
    }
    if (!isSparse || value.hasU8Reserved4()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Reserved4" , 11);
        yajl_gen_integer(g, (long long)value.getU8Reserved4());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi_types::T_TCU_Spot_Receptacle_Type& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TCU_PIN"

void serializeJson (const ::tcu_main_fi_types::T_TCU_PIN& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRPIN_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "rPIN_ID" , 7);
        serializeJson(value.getRPIN_ID(), g, options);
    }
    if (!isSparse || value.hasRPIN_Password()) {
        yajl_gen_string(g, (const unsigned char*)  "rPIN_Password" , 13);
        serializeJson(value.getRPIN_Password(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi_types::T_TCU_PIN& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PIN_Data"

void serializeJson (const ::tcu_main_fi_types::PIN_Data& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8Length()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Length" , 8);
        yajl_gen_integer(g, (long long)value.getU8Length());
    }
    if (!isSparse || value.hasSText()) {
        yajl_gen_string(g, (const unsigned char*)  "sText" , 5);
        const char *s = value.getSText().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi_types::PIN_Data& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TCU_Wifi_SSID_Name"

void serializeJson (const ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8CharcterSet()) {
        yajl_gen_string(g, (const unsigned char*)  "u8CharcterSet" , 13);
        yajl_gen_integer(g, (long long)value.getU8CharcterSet());
    }
    if (!isSparse || value.hasU8LentghOfText()) {
        yajl_gen_string(g, (const unsigned char*)  "u8LentghOfText" , 14);
        yajl_gen_integer(g, (long long)value.getU8LentghOfText());
    }
    if (!isSparse || value.hasSText()) {
        yajl_gen_string(g, (const unsigned char*)  "sText" , 5);
        const char *s = value.getSText().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TCU_Wifi_PassKey"

void serializeJson (const ::tcu_main_fi_types::T_TCU_Wifi_PassKey& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8CharcterSet()) {
        yajl_gen_string(g, (const unsigned char*)  "u8CharcterSet" , 13);
        yajl_gen_integer(g, (long long)value.getU8CharcterSet());
    }
    if (!isSparse || value.hasU8LentghOfText()) {
        yajl_gen_string(g, (const unsigned char*)  "u8LentghOfText" , 14);
        yajl_gen_integer(g, (long long)value.getU8LentghOfText());
    }
    if (!isSparse || value.hasSText()) {
        yajl_gen_string(g, (const unsigned char*)  "sText" , 5);
        const char *s = value.getSText().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi_types::T_TCU_Wifi_PassKey& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TCU_Time_Slot"

void serializeJson (const ::tcu_main_fi_types::T_TCU_Time_Slot& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRStart_timeStamp()) {
        yajl_gen_string(g, (const unsigned char*)  "rStart_timeStamp" , 16);
        serializeJson(value.getRStart_timeStamp(), g, options);
    }
    if (!isSparse || value.hasRStop_timeStamp()) {
        yajl_gen_string(g, (const unsigned char*)  "rStop_timeStamp" , 15);
        serializeJson(value.getRStop_timeStamp(), g, options);
    }
    if (!isSparse || value.hasE8Cycle()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Cycle" , 7);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Cycle_Name(value.getE8Cycle());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Cycle());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi_types::T_TCU_Time_Slot& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TCU_Coordinates"

void serializeJson (const ::tcu_main_fi_types::T_TCU_Coordinates& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Latitudemode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Latitudemode" , 14);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_LatitudeMode_Name(value.getE8Latitudemode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Latitudemode());
    }
    if (!isSparse || value.hasE8LongitudeMode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8LongitudeMode" , 15);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_LongitudeMode_Name(value.getE8LongitudeMode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8LongitudeMode());
    }
    if (!isSparse || value.hasU8LatitudeDEG()) {
        yajl_gen_string(g, (const unsigned char*)  "u8LatitudeDEG" , 13);
        yajl_gen_integer(g, (long long)value.getU8LatitudeDEG());
    }
    if (!isSparse || value.hasU8LatitudeMIN()) {
        yajl_gen_string(g, (const unsigned char*)  "u8LatitudeMIN" , 13);
        yajl_gen_integer(g, (long long)value.getU8LatitudeMIN());
    }
    if (!isSparse || value.hasU16LatitudeSEC()) {
        yajl_gen_string(g, (const unsigned char*)  "u16LatitudeSEC" , 14);
        yajl_gen_integer(g, (long long)value.getU16LatitudeSEC());
    }
    if (!isSparse || value.hasU8LongitudeDEG()) {
        yajl_gen_string(g, (const unsigned char*)  "u8LongitudeDEG" , 14);
        yajl_gen_integer(g, (long long)value.getU8LongitudeDEG());
    }
    if (!isSparse || value.hasU8LongitudeMIN()) {
        yajl_gen_string(g, (const unsigned char*)  "u8LongitudeMIN" , 14);
        yajl_gen_integer(g, (long long)value.getU8LongitudeMIN());
    }
    if (!isSparse || value.hasU16LongitudeSEC()) {
        yajl_gen_string(g, (const unsigned char*)  "u16LongitudeSEC" , 15);
        yajl_gen_integer(g, (long long)value.getU16LongitudeSEC());
    }
    if (!isSparse || value.hasU8Reserve()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Reserve" , 9);
        yajl_gen_integer(g, (long long)value.getU8Reserve());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi_types::T_TCU_Coordinates& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TCU_Area_Coordinate"

void serializeJson (const ::tcu_main_fi_types::T_TCU_Area_Coordinate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRCoordinates1()) {
        yajl_gen_string(g, (const unsigned char*)  "rCoordinates1" , 13);
        serializeJson(value.getRCoordinates1(), g, options);
    }
    if (!isSparse || value.hasRCoordinates2()) {
        yajl_gen_string(g, (const unsigned char*)  "rCoordinates2" , 13);
        serializeJson(value.getRCoordinates2(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi_types::T_TCU_Area_Coordinate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TCU_Area_Limit_Coordinates"

void serializeJson (const ::tcu_main_fi_types::T_TCU_Area_Limit_Coordinates& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Restriction_Area_Type()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Restriction_Area_Type" , 23);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Restriction_Area_Type_Name(value.getE8Restriction_Area_Type());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Restriction_Area_Type());
    }
    if (!isSparse || value.hasE8Area_Form()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Area_Form" , 11);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Area_Form_Name(value.getE8Area_Form());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Area_Form());
    }
    if (!isSparse || value.hasE8LocationType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8LocationType" , 14);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_LocationType_Name(value.getE8LocationType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8LocationType());
    }
    if (!isSparse || value.hasRArea_Coordinates()) {
        yajl_gen_string(g, (const unsigned char*)  "rArea_Coordinates" , 17);
        serializeJson(value.getRArea_Coordinates(), g, options);
    }
    if (!isSparse || value.hasU16Radius()) {
        yajl_gen_string(g, (const unsigned char*)  "u16Radius" , 9);
        yajl_gen_integer(g, (long long)value.getU16Radius());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi_types::T_TCU_Area_Limit_Coordinates& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TCU_Speed_Limit_Restriction"

void serializeJson (const ::tcu_main_fi_types::T_TCU_Speed_Limit_Restriction& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRLimited_Vehicle_Speed()) {
        yajl_gen_string(g, (const unsigned char*)  "rLimited_Vehicle_Speed" , 22);
        yajl_gen_array_open(g);
        const ::std::vector< uint16 >& o1 = value.getRLimited_Vehicle_Speed();
        {
            ::std::vector< uint16 >::const_iterator o0;
            for (o0 = o1.begin(); o0 != o1.end(); ++o0) {
                yajl_gen_integer(g, (long long)(*o0));
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasRTime_Slot()) {
        yajl_gen_string(g, (const unsigned char*)  "rTime_Slot" , 10);
        yajl_gen_array_open(g);
        const ::std::vector< ::tcu_main_fi_types::T_TCU_Time_Slot >& o3 = value.getRTime_Slot();
        {
            ::std::vector< ::tcu_main_fi_types::T_TCU_Time_Slot >::const_iterator o2;
            for (o2 = o3.begin(); o2 != o3.end(); ++o2) {
                serializeJson((*o2), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi_types::T_TCU_Speed_Limit_Restriction& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TCU_Area_Limit_Restriction"

void serializeJson (const ::tcu_main_fi_types::T_TCU_Area_Limit_Restriction& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRArea_Limit_Coordinates()) {
        yajl_gen_string(g, (const unsigned char*)  "rArea_Limit_Coordinates" , 23);
        yajl_gen_array_open(g);
        const ::std::vector< ::tcu_main_fi_types::T_TCU_Area_Limit_Coordinates >& o5 = value.getRArea_Limit_Coordinates();
        {
            ::std::vector< ::tcu_main_fi_types::T_TCU_Area_Limit_Coordinates >::const_iterator o4;
            for (o4 = o5.begin(); o4 != o5.end(); ++o4) {
                serializeJson((*o4), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasRTime_Slot()) {
        yajl_gen_string(g, (const unsigned char*)  "rTime_Slot" , 10);
        yajl_gen_array_open(g);
        const ::std::vector< ::tcu_main_fi_types::T_TCU_Time_Slot >& o7 = value.getRTime_Slot();
        {
            ::std::vector< ::tcu_main_fi_types::T_TCU_Time_Slot >::const_iterator o6;
            for (o6 = o7.begin(); o6 != o7.end(); ++o6) {
                serializeJson((*o6), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi_types::T_TCU_Area_Limit_Restriction& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

using namespace ::asf::stream::json;

namespace tcu_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi_types::T_TCU_VersionInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi_types
using namespace ::asf::stream::json;

namespace tcu_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi_types::T_TCU_Date_Time& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi_types
using namespace ::asf::stream::json;

namespace tcu_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi_types::T_TCU_Navi_Info& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi_types
using namespace ::asf::stream::json;

namespace tcu_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi_types::T_TCU_LocationInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi_types
using namespace ::asf::stream::json;

namespace tcu_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi_types::T_TCU_Altitude& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi_types
using namespace ::asf::stream::json;

namespace tcu_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi_types::T_TCU_Score_Info& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi_types
using namespace ::asf::stream::json;

namespace tcu_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi_types::T_TCU_Probe_Vehicle_Info& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi_types
using namespace ::asf::stream::json;

namespace tcu_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi_types::T_TCU_Navi_Road_classification& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi_types
using namespace ::asf::stream::json;

namespace tcu_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi_types::T_TCU_Maintenance_Info& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi_types
using namespace ::asf::stream::json;

namespace tcu_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi_types::T_TCU_Distance_Value& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi_types
using namespace ::asf::stream::json;

namespace tcu_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi_types::T_TCU_Provision_List& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi_types
using namespace ::asf::stream::json;

namespace tcu_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi_types::T_TCU_ReminderInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi_types
using namespace ::asf::stream::json;

namespace tcu_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi_types::T_TCU_GPS_Position& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi_types
using namespace ::asf::stream::json;

namespace tcu_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi_types::T_TCU_Time_Stamp& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi_types
using namespace ::asf::stream::json;

namespace tcu_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi_types::T_TCU_Opening_Hour& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi_types
using namespace ::asf::stream::json;

namespace tcu_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi_types::T_TCU_Opening_Hour_Day& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi_types
using namespace ::asf::stream::json;

namespace tcu_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi_types::T_TCU_Full_Address& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi_types
using namespace ::asf::stream::json;

namespace tcu_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi_types::T_TCU_Charge_Spot_List& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi_types
using namespace ::asf::stream::json;

namespace tcu_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi_types::T_TCU_Spot_List& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi_types
using namespace ::asf::stream::json;

namespace tcu_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi_types::T_TCU_Bookable_Free_Text& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi_types
using namespace ::asf::stream::json;

namespace tcu_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi_types::T_TCU_Receptacle& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi_types
using namespace ::asf::stream::json;

namespace tcu_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi_types::T_TCU_Time& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi_types
using namespace ::asf::stream::json;

namespace tcu_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi_types::T_TCU_Navigation_Language& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi_types
using namespace ::asf::stream::json;

namespace tcu_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi_types::T_TCU_Charge_Days& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi_types
using namespace ::asf::stream::json;

namespace tcu_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi_types::T_TCU_Spot_Receptacle_Type& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi_types
using namespace ::asf::stream::json;

namespace tcu_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi_types::T_TCU_PIN& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi_types
using namespace ::asf::stream::json;

namespace tcu_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi_types::PIN_Data& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi_types
using namespace ::asf::stream::json;

namespace tcu_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi_types
using namespace ::asf::stream::json;

namespace tcu_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi_types::T_TCU_Wifi_PassKey& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi_types
using namespace ::asf::stream::json;

namespace tcu_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi_types::T_TCU_Time_Slot& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi_types
using namespace ::asf::stream::json;

namespace tcu_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi_types::T_TCU_Coordinates& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi_types
using namespace ::asf::stream::json;

namespace tcu_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi_types::T_TCU_Area_Coordinate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi_types
using namespace ::asf::stream::json;

namespace tcu_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi_types::T_TCU_Area_Limit_Coordinates& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi_types
using namespace ::asf::stream::json;

namespace tcu_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi_types::T_TCU_Speed_Limit_Restriction& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi_types
using namespace ::asf::stream::json;

namespace tcu_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi_types::T_TCU_Area_Limit_Restriction& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi_types

