/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/stream/json.h"
#include "tcu_main_fi_typesConst.h"
#include <cstddef>
#include <cstdlib>

/**
 * Types tcu_main_fi_types
 */

using namespace ::asf::stream::json;

namespace tcu_main_fi_types {

bool T_e8_TCU_ConfigurationStatus_Parse (const char *str, size_t length, T_e8_TCU_ConfigurationStatus &value)
{
    static stringEntry entries[] = {
        {5,"VALID", 1U},
        {7,"INVALID", 2U},
        {9,"UNDEFINED", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_TCU_ConfigurationStatus_Name (T_e8_TCU_ConfigurationStatus value)
{
    static const char* enumerationLiterals[] = {
        "Undefined",
        "Valid",
        "Invalid",
    };

    if (T_e8_TCU_ConfigurationStatus_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_TCU_ConfigurationStatus_IsValid (T_e8_TCU_ConfigurationStatus value)
{
    switch (value) {
    case T_e8_TCU_ConfigurationStatus__Undefined:
    case T_e8_TCU_ConfigurationStatus__Valid:
    case T_e8_TCU_ConfigurationStatus__Invalid:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_CommunicationStatus_Parse (const char *str, size_t length, T_e8_TCU_CommunicationStatus &value)
{
    static stringEntry entries[] = {
        {15,"COMM_STATUS_OFF", 0U},
        {21,"COMM_STATUS_CONNECTED", 3U},
        {25,"COMM_STATUS_NOT_CONNECTED", 1U},
        {27,"COMM_STATUS_CONNECTION_WAIT", 2U},
        {28,"COMM_STATUS_CONNECTION_ERROR", 4U},
        {39,"COMM_STATUS_CONNECTION_WAIT_AFTER_ERROR", 5U},
    };

    return lookupInStringEntryTable (str, length, entries, 6, (unsigned int&) value);
}

const char* T_e8_TCU_CommunicationStatus_Name (T_e8_TCU_CommunicationStatus value)
{
    static const char* enumerationLiterals[] = {
        "COMM_STATUS_OFF",
        "COMM_STATUS_NOT_CONNECTED",
        "COMM_STATUS_CONNECTION_WAIT",
        "COMM_STATUS_CONNECTED",
        "COMM_STATUS_CONNECTION_ERROR",
        "COMM_STATUS_CONNECTION_WAIT_AFTER_ERROR",
    };

    if (T_e8_TCU_CommunicationStatus_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_TCU_CommunicationStatus_IsValid (T_e8_TCU_CommunicationStatus value)
{
    switch (value) {
    case T_e8_TCU_CommunicationStatus__COMM_STATUS_OFF:
    case T_e8_TCU_CommunicationStatus__COMM_STATUS_NOT_CONNECTED:
    case T_e8_TCU_CommunicationStatus__COMM_STATUS_CONNECTION_WAIT:
    case T_e8_TCU_CommunicationStatus__COMM_STATUS_CONNECTED:
    case T_e8_TCU_CommunicationStatus__COMM_STATUS_CONNECTION_ERROR:
    case T_e8_TCU_CommunicationStatus__COMM_STATUS_CONNECTION_WAIT_AFTER_ERROR:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_ServiceState_Parse (const char *str, size_t length, T_e8_TCU_ServiceState &value)
{
    static stringEntry entries[] = {
        {4,"IDLE", 0U},
        {8,"GOTODATA", 52U},
        {9,"GOTOVOICE", 23U},
        {9,"VOICECALL", 16U},
        {10,"MSDNOTSENT", 67U},
        {12,"OUTOFSERVICE", 24U},
        {13,"DTMF_CLI_STOP", 49U},
        {13,"VOICECALLSTOP", 22U},
        {14,"DTMF_CLI_START", 48U},
        {14,"ENDINFOSENDING", 68U},
        {14,"POIDOWNLOADEND", 54U},
        {14,"VOICECALLRETRY", 21U},
        {17,"DTMF_POSITION_END", 51U},
        {18,"POIDOWNLOADREQUEST", 53U},
        {18,"VOICECALLCONNECTED", 17U},
        {19,"DTMF_POSITION_START", 50U},
        {19,"INITIATEINFOSENDING", 69U},
        {20,"VOICECALLSETUPFAILED", 18U},
        {21,"FINISHUPLOADINGTHEDTC", 66U},
        {21,"STARTVEHICLEDIAGNOSIS", 64U},
        {21,"VOICECALLDISCONNECTED", 19U},
        {22,"FINISHVEHICLEDIAGNOSIS", 65U},
        {29,"VOICECALLABNORMALDISCONNECTED", 20U},
    };

    return lookupInStringEntryTable (str, length, entries, 23, (unsigned int&) value);
}

const char* T_e8_TCU_ServiceState_Name (T_e8_TCU_ServiceState value)
{
    static const char* enumerationLiterals[] = {
        "Idle",
        "VoiceCall",
        "VoiceCallConnected",
        "VoiceCallSetupFailed",
        "VoiceCallDisconnected",
        "VoiceCallAbnormalDisconnected",
        "VoiceCallRetry",
        "VoiceCallStop",
        "GoToVoice",
        "OutOfService",
        "DTMF_CLI_Start",
        "DTMF_CLI_Stop",
        "DTMF_Position_Start",
        "DTMF_Position_End",
        "GoToData",
        "POIDownloadRequest",
        "POIDownloadEnd",
        "StartVehicleDiagnosis",
        "FinishVehicleDiagnosis",
        "FinishUploadingTheDTC",
        "MSDnotSent",
        "EndinfoSending",
        "InitiateinfoSending",
    };

    static unsigned int enumerationValues[] = {
        0U,
        16U,
        17U,
        18U,
        19U,
        20U,
        21U,
        22U,
        23U,
        24U,
        48U,
        49U,
        50U,
        51U,
        52U,
        53U,
        54U,
        64U,
        65U,
        66U,
        67U,
        68U,
        69U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 23, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_TCU_ServiceState_IsValid (T_e8_TCU_ServiceState value)
{
    switch (value) {
    case T_e8_TCU_ServiceState__Idle:
    case T_e8_TCU_ServiceState__VoiceCall:
    case T_e8_TCU_ServiceState__VoiceCallConnected:
    case T_e8_TCU_ServiceState__VoiceCallSetupFailed:
    case T_e8_TCU_ServiceState__VoiceCallDisconnected:
    case T_e8_TCU_ServiceState__VoiceCallAbnormalDisconnected:
    case T_e8_TCU_ServiceState__VoiceCallRetry:
    case T_e8_TCU_ServiceState__VoiceCallStop:
    case T_e8_TCU_ServiceState__GoToVoice:
    case T_e8_TCU_ServiceState__OutOfService:
    case T_e8_TCU_ServiceState__DTMF_CLI_Start:
    case T_e8_TCU_ServiceState__DTMF_CLI_Stop:
    case T_e8_TCU_ServiceState__DTMF_Position_Start:
    case T_e8_TCU_ServiceState__DTMF_Position_End:
    case T_e8_TCU_ServiceState__GoToData:
    case T_e8_TCU_ServiceState__POIDownloadRequest:
    case T_e8_TCU_ServiceState__POIDownloadEnd:
    case T_e8_TCU_ServiceState__StartVehicleDiagnosis:
    case T_e8_TCU_ServiceState__FinishVehicleDiagnosis:
    case T_e8_TCU_ServiceState__FinishUploadingTheDTC:
    case T_e8_TCU_ServiceState__MSDnotSent:
    case T_e8_TCU_ServiceState__EndinfoSending:
    case T_e8_TCU_ServiceState__InitiateinfoSending:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_CurfewWarning_Parse (const char *str, size_t length, T_e8_TCU_CurfewWarning &value)
{
    static stringEntry entries[] = {
        {4,"NONE", 0U},
        {9,"SETTIMEUP", 2U},
        {17,"APPROACHTOSETTIME", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_TCU_CurfewWarning_Name (T_e8_TCU_CurfewWarning value)
{
    static const char* enumerationLiterals[] = {
        "None",
        "ApproachToSetTime",
        "SetTimeUp",
    };

    if (T_e8_TCU_CurfewWarning_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_TCU_CurfewWarning_IsValid (T_e8_TCU_CurfewWarning value)
{
    switch (value) {
    case T_e8_TCU_CurfewWarning__None:
    case T_e8_TCU_CurfewWarning__ApproachToSetTime:
    case T_e8_TCU_CurfewWarning__SetTimeUp:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_ModemStatus_Parse (const char *str, size_t length, T_e8_TCU_ModemStatus &value)
{
    static stringEntry entries[] = {
        {4,"NONE", 0U},
        {10,"MODEMREADY", 1U},
        {12,"MODEMFAILURE", 3U},
        {12,"NOTAVAILABLE", 4U},
        {13,"MODEMNOTREADY", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 5, (unsigned int&) value);
}

const char* T_e8_TCU_ModemStatus_Name (T_e8_TCU_ModemStatus value)
{
    static const char* enumerationLiterals[] = {
        "None",
        "ModemReady",
        "ModemNotReady",
        "ModemFailure",
        "NotAvailable",
    };

    if (T_e8_TCU_ModemStatus_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_TCU_ModemStatus_IsValid (T_e8_TCU_ModemStatus value)
{
    switch (value) {
    case T_e8_TCU_ModemStatus__None:
    case T_e8_TCU_ModemStatus__ModemReady:
    case T_e8_TCU_ModemStatus__ModemNotReady:
    case T_e8_TCU_ModemStatus__ModemFailure:
    case T_e8_TCU_ModemStatus__NotAvailable:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_TCUStatus_Parse (const char *str, size_t length, T_e8_TCU_TCUStatus &value)
{
    static stringEntry entries[] = {
        {4,"NONE", 0U},
        {12,"NOTAVAILABLE", 3U},
        {12,"TCUACTIVATED", 1U},
        {15,"TCUNOTACTIVATED", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_TCU_TCUStatus_Name (T_e8_TCU_TCUStatus value)
{
    static const char* enumerationLiterals[] = {
        "None",
        "TCUActivated",
        "TCUNotActivated",
        "NotAvailable",
    };

    if (T_e8_TCU_TCUStatus_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_TCU_TCUStatus_IsValid (T_e8_TCU_TCUStatus value)
{
    switch (value) {
    case T_e8_TCU_TCUStatus__None:
    case T_e8_TCU_TCUStatus__TCUActivated:
    case T_e8_TCU_TCUStatus__TCUNotActivated:
    case T_e8_TCU_TCUStatus__NotAvailable:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_GSMStatus_Parse (const char *str, size_t length, T_e8_TCU_GSMStatus &value)
{
    static stringEntry entries[] = {
        {4,"NONE", 0U},
        {12,"NOTAVAILABLE", 3U},
        {21,"GSM_WCDMACONNECTIONOK", 1U},
        {24,"GSM_WCDMACONNECTIONNOTOK", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_TCU_GSMStatus_Name (T_e8_TCU_GSMStatus value)
{
    static const char* enumerationLiterals[] = {
        "None",
        "GSM_WCDMAConnectionOk",
        "GSM_WCDMAConnectionNotOk",
        "NotAvailable",
    };

    if (T_e8_TCU_GSMStatus_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_TCU_GSMStatus_IsValid (T_e8_TCU_GSMStatus value)
{
    switch (value) {
    case T_e8_TCU_GSMStatus__None:
    case T_e8_TCU_GSMStatus__GSM_WCDMAConnectionOk:
    case T_e8_TCU_GSMStatus__GSM_WCDMAConnectionNotOk:
    case T_e8_TCU_GSMStatus__NotAvailable:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_WifiStatus_Parse (const char *str, size_t length, T_e8_TCU_WifiStatus &value)
{
    static stringEntry entries[] = {
        {2,"ON", 1U},
        {3,"OFF", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_TCU_WifiStatus_Name (T_e8_TCU_WifiStatus value)
{
    static const char* enumerationLiterals[] = {
        "OFF",
        "ON",
    };

    if (T_e8_TCU_WifiStatus_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_TCU_WifiStatus_IsValid (T_e8_TCU_WifiStatus value)
{
    switch (value) {
    case T_e8_TCU_WifiStatus__OFF:
    case T_e8_TCU_WifiStatus__ON:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_WifiMode_Parse (const char *str, size_t length, T_e8_TCU_WifiMode &value)
{
    static stringEntry entries[] = {
        {7,"UNKONOW", 255U},
        {10,"WIFICLIENT", 1U},
        {15,"WIFIUNAVAILABLE", 0U},
        {17,"WIFIHOTSPOTVIATCU", 4U},
        {20,"WIFIHOTSPOTVIAUSBKEY", 2U},
        {23,"WIFIHOTSPOTVIABLUETOOTH", 3U},
    };

    return lookupInStringEntryTable (str, length, entries, 6, (unsigned int&) value);
}

const char* T_e8_TCU_WifiMode_Name (T_e8_TCU_WifiMode value)
{
    static const char* enumerationLiterals[] = {
        "WifiUnavailable",
        "WifiClient",
        "WifiHotSpotViaUSBKey",
        "WifiHotSpotViaBluetooth",
        "WifiHotSpotViaTCU",
        "Unkonow",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        4U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 6, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_TCU_WifiMode_IsValid (T_e8_TCU_WifiMode value)
{
    switch (value) {
    case T_e8_TCU_WifiMode__WifiUnavailable:
    case T_e8_TCU_WifiMode__WifiClient:
    case T_e8_TCU_WifiMode__WifiHotSpotViaUSBKey:
    case T_e8_TCU_WifiMode__WifiHotSpotViaBluetooth:
    case T_e8_TCU_WifiMode__WifiHotSpotViaTCU:
    case T_e8_TCU_WifiMode__Unkonow:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_WifiHotSpotStatus_Parse (const char *str, size_t length, T_e8_TCU_WifiHotSpotStatus &value)
{
    static stringEntry entries[] = {
        {16,"WIFINOTACTIVATED", 0U},
        {22,"WIFIACTIVATEDAVAILABLE", 1U},
        {25,"WIFIACTIVATEDNOTAVAILABLE", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_TCU_WifiHotSpotStatus_Name (T_e8_TCU_WifiHotSpotStatus value)
{
    static const char* enumerationLiterals[] = {
        "WifiNotActivated",
        "WifiActivatedAvailable",
        "WifiActivatedNotAvailable",
    };

    if (T_e8_TCU_WifiHotSpotStatus_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_TCU_WifiHotSpotStatus_IsValid (T_e8_TCU_WifiHotSpotStatus value)
{
    switch (value) {
    case T_e8_TCU_WifiHotSpotStatus__WifiNotActivated:
    case T_e8_TCU_WifiHotSpotStatus__WifiActivatedAvailable:
    case T_e8_TCU_WifiHotSpotStatus__WifiActivatedNotAvailable:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_WifiClientStatus_Parse (const char *str, size_t length, T_e8_TCU_WifiClientStatus &value)
{
    static stringEntry entries[] = {
        {9,"CONNECTED", 1U},
        {12,"NOTCONNECTED", 0U},
        {14,"SCANINPROGRESS", 2U},
        {20,"CONNECTIONINPROGRESS", 3U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_TCU_WifiClientStatus_Name (T_e8_TCU_WifiClientStatus value)
{
    static const char* enumerationLiterals[] = {
        "NotConnected",
        "Connected",
        "ScanInProgress",
        "ConnectionInProgress",
    };

    if (T_e8_TCU_WifiClientStatus_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_TCU_WifiClientStatus_IsValid (T_e8_TCU_WifiClientStatus value)
{
    switch (value) {
    case T_e8_TCU_WifiClientStatus__NotConnected:
    case T_e8_TCU_WifiClientStatus__Connected:
    case T_e8_TCU_WifiClientStatus__ScanInProgress:
    case T_e8_TCU_WifiClientStatus__ConnectionInProgress:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_GSMDataMode_Parse (const char *str, size_t length, T_e8_TCU_GSMDataMode &value)
{
    static stringEntry entries[] = {
        {2,"2G", 5U},
        {2,"3G", 3U},
        {3,"_4G", 6U},
        {4,"EDGE", 2U},
        {4,"GPRS", 1U},
        {4,"HSPA", 4U},
        {4,"NONE", 0U},
        {8,"_4G_PLUS", 8U},
        {14,"_4G_WITH_VOLTE", 7U},
        {19,"_4G_PLUS_WITH_VOLTE", 9U},
    };

    return lookupInStringEntryTable (str, length, entries, 10, (unsigned int&) value);
}

const char* T_e8_TCU_GSMDataMode_Name (T_e8_TCU_GSMDataMode value)
{
    static const char* enumerationLiterals[] = {
        "None",
        "GPRS",
        "Edge",
        "3G",
        "HSPA",
        "2G",
        "_4G",
        "_4G_WITH_VOLTE",
        "_4G_PLUS",
        "_4G_PLUS_WITH_VOLTE",
    };

    if (T_e8_TCU_GSMDataMode_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_TCU_GSMDataMode_IsValid (T_e8_TCU_GSMDataMode value)
{
    switch (value) {
    case T_e8_TCU_GSMDataMode__None:
    case T_e8_TCU_GSMDataMode__GPRS:
    case T_e8_TCU_GSMDataMode__Edge:
    case T_e8_TCU_GSMDataMode__3G:
    case T_e8_TCU_GSMDataMode__HSPA:
    case T_e8_TCU_GSMDataMode__2G:
    case T_e8_TCU_GSMDataMode___4G:
    case T_e8_TCU_GSMDataMode___4G_WITH_VOLTE:
    case T_e8_TCU_GSMDataMode___4G_PLUS:
    case T_e8_TCU_GSMDataMode___4G_PLUS_WITH_VOLTE:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_Invalid_Parameter_Parse (const char *str, size_t length, T_e8_TCU_Invalid_Parameter &value)
{
    static stringEntry entries[] = {
        {5,"OTHER", 255U},
        {6,"NORMAL", 0U},
        {10,"OUTOFRANGE", 1U},
        {13,"INTERNALERROR", 3U},
        {16,"INVALIDPARAMETER", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 5, (unsigned int&) value);
}

const char* T_e8_TCU_Invalid_Parameter_Name (T_e8_TCU_Invalid_Parameter value)
{
    static const char* enumerationLiterals[] = {
        "Normal",
        "OutOfRange",
        "InvalidParameter",
        "InternalError",
        "Other",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 5, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_TCU_Invalid_Parameter_IsValid (T_e8_TCU_Invalid_Parameter value)
{
    switch (value) {
    case T_e8_TCU_Invalid_Parameter__Normal:
    case T_e8_TCU_Invalid_Parameter__OutOfRange:
    case T_e8_TCU_Invalid_Parameter__InvalidParameter:
    case T_e8_TCU_Invalid_Parameter__InternalError:
    case T_e8_TCU_Invalid_Parameter__Other:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_RoamingStatus_Parse (const char *str, size_t length, T_e8_TCU_RoamingStatus &value)
{
    static stringEntry entries[] = {
        {11,"UNAVAILABLE", 255U},
        {12,"UNREGISTERED", 0U},
        {14,"REGISTEREDHOME", 1U},
        {17,"REGISTEREDROAMING", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_TCU_RoamingStatus_Name (T_e8_TCU_RoamingStatus value)
{
    static const char* enumerationLiterals[] = {
        "Unregistered",
        "RegisteredHome",
        "RegisteredRoaming",
        "UnAvailable",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 4, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_TCU_RoamingStatus_IsValid (T_e8_TCU_RoamingStatus value)
{
    switch (value) {
    case T_e8_TCU_RoamingStatus__UnAvailable:
    case T_e8_TCU_RoamingStatus__Unregistered:
    case T_e8_TCU_RoamingStatus__RegisteredHome:
    case T_e8_TCU_RoamingStatus__RegisteredRoaming:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_PPPConnectionStatus_Parse (const char *str, size_t length, T_e8_TCU_PPPConnectionStatus &value)
{
    static stringEntry entries[] = {
        {9,"CONNECTED", 3U},
        {10,"CONNECTING", 2U},
        {11,"UNAVAILABLE", 255U},
        {12,"DISCONNECTED", 0U},
        {13,"DISCONNECTING", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 5, (unsigned int&) value);
}

const char* T_e8_TCU_PPPConnectionStatus_Name (T_e8_TCU_PPPConnectionStatus value)
{
    static const char* enumerationLiterals[] = {
        "Disconnected",
        "Disconnecting",
        "Connecting",
        "Connected",
        "Unavailable",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 5, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_TCU_PPPConnectionStatus_IsValid (T_e8_TCU_PPPConnectionStatus value)
{
    switch (value) {
    case T_e8_TCU_PPPConnectionStatus__Unavailable:
    case T_e8_TCU_PPPConnectionStatus__Disconnected:
    case T_e8_TCU_PPPConnectionStatus__Disconnecting:
    case T_e8_TCU_PPPConnectionStatus__Connecting:
    case T_e8_TCU_PPPConnectionStatus__Connected:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_InvalidParameter_Parse (const char *str, size_t length, T_e8_TCU_InvalidParameter &value)
{
    static stringEntry entries[] = {
        {4,"NONE", 0U},
        {5,"OTHER", 4U},
        {10,"OUTOFRANGE", 1U},
        {13,"INTERNALERROR", 3U},
        {16,"INVALEDPARAMETER", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 5, (unsigned int&) value);
}

const char* T_e8_TCU_InvalidParameter_Name (T_e8_TCU_InvalidParameter value)
{
    static const char* enumerationLiterals[] = {
        "None",
        "OutOfRange",
        "InvaledParameter",
        "InternalError",
        "Other",
    };

    if (T_e8_TCU_InvalidParameter_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_TCU_InvalidParameter_IsValid (T_e8_TCU_InvalidParameter value)
{
    switch (value) {
    case T_e8_TCU_InvalidParameter__None:
    case T_e8_TCU_InvalidParameter__OutOfRange:
    case T_e8_TCU_InvalidParameter__InvaledParameter:
    case T_e8_TCU_InvalidParameter__InternalError:
    case T_e8_TCU_InvalidParameter__Other:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_PermitSetting_Parse (const char *str, size_t length, T_e8_TCU_PermitSetting &value)
{
    static stringEntry entries[] = {
        {2,"ON", 1U},
        {3,"OFF", 0U},
        {8,"NOACTION", 255U},
        {10,"DISCLAIMER", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_TCU_PermitSetting_Name (T_e8_TCU_PermitSetting value)
{
    static const char* enumerationLiterals[] = {
        "OFF",
        "ON",
        "Disclaimer",
        "NOACTION",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 4, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_TCU_PermitSetting_IsValid (T_e8_TCU_PermitSetting value)
{
    switch (value) {
    case T_e8_TCU_PermitSetting__OFF:
    case T_e8_TCU_PermitSetting__ON:
    case T_e8_TCU_PermitSetting__Disclaimer:
    case T_e8_TCU_PermitSetting__NOACTION:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_APP_Context_Parse (const char *str, size_t length, T_e8_TCU_APP_Context &value)
{
    static stringEntry entries[] = {
        {4,"NONE", 0U},
        {6,"TELEMA", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_TCU_APP_Context_Name (T_e8_TCU_APP_Context value)
{
    static const char* enumerationLiterals[] = {
        "NONE",
        "TELEMA",
    };

    if (T_e8_TCU_APP_Context_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_TCU_APP_Context_IsValid (T_e8_TCU_APP_Context value)
{
    switch (value) {
    case T_e8_TCU_APP_Context__NONE:
    case T_e8_TCU_APP_Context__TELEMA:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_ProbePermitSetting_Parse (const char *str, size_t length, T_e8_TCU_ProbePermitSetting &value)
{
    static stringEntry entries[] = {
        {2,"ON", 1U},
        {3,"OFF", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_TCU_ProbePermitSetting_Name (T_e8_TCU_ProbePermitSetting value)
{
    static const char* enumerationLiterals[] = {
        "OFF",
        "ON",
    };

    if (T_e8_TCU_ProbePermitSetting_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_TCU_ProbePermitSetting_IsValid (T_e8_TCU_ProbePermitSetting value)
{
    switch (value) {
    case T_e8_TCU_ProbePermitSetting__OFF:
    case T_e8_TCU_ProbePermitSetting__ON:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_PopUpFlag_Parse (const char *str, size_t length, T_e8_TCU_PopUpFlag &value)
{
    static stringEntry entries[] = {
        {2,"ON", 1U},
        {3,"OFF", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_TCU_PopUpFlag_Name (T_e8_TCU_PopUpFlag value)
{
    static const char* enumerationLiterals[] = {
        "OFF",
        "ON",
    };

    if (T_e8_TCU_PopUpFlag_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_TCU_PopUpFlag_IsValid (T_e8_TCU_PopUpFlag value)
{
    switch (value) {
    case T_e8_TCU_PopUpFlag__OFF:
    case T_e8_TCU_PopUpFlag__ON:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_OperationRequest_Parse (const char *str, size_t length, T_e8_TCU_OperationRequest &value)
{
    static stringEntry entries[] = {
        {6,"CANCEL", 0U},
        {7,"CONNECT", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_TCU_OperationRequest_Name (T_e8_TCU_OperationRequest value)
{
    static const char* enumerationLiterals[] = {
        "Cancel",
        "Connect",
    };

    if (T_e8_TCU_OperationRequest_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_TCU_OperationRequest_IsValid (T_e8_TCU_OperationRequest value)
{
    switch (value) {
    case T_e8_TCU_OperationRequest__Cancel:
    case T_e8_TCU_OperationRequest__Connect:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_LocationType_Parse (const char *str, size_t length, T_e8_TCU_LocationType &value)
{
    static stringEntry entries[] = {
        {5,"TOKYO", 0U},
        {5,"WGS84", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_TCU_LocationType_Name (T_e8_TCU_LocationType value)
{
    static const char* enumerationLiterals[] = {
        "Tokyo",
        "WGS84",
    };

    if (T_e8_TCU_LocationType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_TCU_LocationType_IsValid (T_e8_TCU_LocationType value)
{
    switch (value) {
    case T_e8_TCU_LocationType__Tokyo:
    case T_e8_TCU_LocationType__WGS84:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_LatitudeMode_Parse (const char *str, size_t length, T_e8_TCU_LatitudeMode &value)
{
    static stringEntry entries[] = {
        {5,"NORTH", 0U},
        {5,"SOUTH", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_TCU_LatitudeMode_Name (T_e8_TCU_LatitudeMode value)
{
    static const char* enumerationLiterals[] = {
        "North",
        "South",
    };

    if (T_e8_TCU_LatitudeMode_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_TCU_LatitudeMode_IsValid (T_e8_TCU_LatitudeMode value)
{
    switch (value) {
    case T_e8_TCU_LatitudeMode__North:
    case T_e8_TCU_LatitudeMode__South:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_LongitudeMode_Parse (const char *str, size_t length, T_e8_TCU_LongitudeMode &value)
{
    static stringEntry entries[] = {
        {4,"EAST", 0U},
        {4,"WEST", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_TCU_LongitudeMode_Name (T_e8_TCU_LongitudeMode value)
{
    static const char* enumerationLiterals[] = {
        "East",
        "West",
    };

    if (T_e8_TCU_LongitudeMode_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_TCU_LongitudeMode_IsValid (T_e8_TCU_LongitudeMode value)
{
    switch (value) {
    case T_e8_TCU_LongitudeMode__East:
    case T_e8_TCU_LongitudeMode__West:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_Sign_Parse (const char *str, size_t length, T_e8_TCU_Sign &value)
{
    static stringEntry entries[] = {
        {4,"PLUS", 1U},
        {5,"MINUS", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_TCU_Sign_Name (T_e8_TCU_Sign value)
{
    static const char* enumerationLiterals[] = {
        "Minus",
        "Plus",
    };

    if (T_e8_TCU_Sign_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_TCU_Sign_IsValid (T_e8_TCU_Sign value)
{
    switch (value) {
    case T_e8_TCU_Sign__Minus:
    case T_e8_TCU_Sign__Plus:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_Home_Parse (const char *str, size_t length, T_e8_TCU_Home &value)
{
    static stringEntry entries[] = {
        {6,"INSIDE", 0U},
        {7,"OUTSIDE", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_TCU_Home_Name (T_e8_TCU_Home value)
{
    static const char* enumerationLiterals[] = {
        "Inside",
        "outside",
    };

    if (T_e8_TCU_Home_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_TCU_Home_IsValid (T_e8_TCU_Home value)
{
    switch (value) {
    case T_e8_TCU_Home__Inside:
    case T_e8_TCU_Home__outside:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_Distance_Unit_Parse (const char *str, size_t length, T_e8_TCU_Distance_Unit &value)
{
    static stringEntry entries[] = {
        {2,"KM", 1U},
        {4,"MILE", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_TCU_Distance_Unit_Name (T_e8_TCU_Distance_Unit value)
{
    static const char* enumerationLiterals[] = {
        "km",
        "mile",
    };

    if (T_e8_TCU_Distance_Unit_IsValid(value))
        return enumerationLiterals[value - 1U];
    else
        return NULL;
}

bool T_e8_TCU_Distance_Unit_IsValid (T_e8_TCU_Distance_Unit value)
{
    switch (value) {
    case T_e8_TCU_Distance_Unit__mile:
    case T_e8_TCU_Distance_Unit__km:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_EcallStateDisplay_Parse (const char *str, size_t length, T_e8_TCU_EcallStateDisplay &value)
{
    static stringEntry entries[] = {
        {5,"NOUSE", 14U},
        {7,"NOTUSED", 1U},
        {16,"NOTHINGTODISPLAY", 0U},
        {18,"DETECTINCOMINGCALL", 13U},
        {22,"ECALLSYSTEMMALFUNCTION", 15U},
        {22,"RECEPTIONOFPSAPMSGSEND", 8U},
        {23,"DETECTMANUALECALLLAUNCH", 4U},
        {26,"DETECTAUTOMATICECALLLAUNCH", 5U},
        {28,"DETECTFAILUREOFCOMMUNICATION", 11U},
        {29,"DETECTMANUALECALLCANCELLATION", 7U},
        {30,"DETECTMANUALECALLLAUNCHFAILURE", 6U},
        {30,"DETECTNORMALENDOFCOMMUNICATION", 12U},
        {31,"DETECTECALLACTIVATIONBYDIAGTOOL", 3U},
        {33,"DETECTECALLDEACTIVATIONBYDIAGTOOL", 2U},
        {44,"VOICECONNECTIONANDMSDSUCCESSFULLYTRANSMITTED", 10U},
        {47,"VOICECONNECTIONANDMSDNOTSUCCESSFULLYTRANSMITTED", 9U},
    };

    return lookupInStringEntryTable (str, length, entries, 16, (unsigned int&) value);
}

const char* T_e8_TCU_EcallStateDisplay_Name (T_e8_TCU_EcallStateDisplay value)
{
    static const char* enumerationLiterals[] = {
        "Nothingtodisplay",
        "NotUsed",
        "DetectECALLDeactivationbyDiagTool",
        "DetectECALLActivationbyDiagTool",
        "DetectManualECALLLaunch",
        "DetectAutomaticECALLLaunch",
        "DetectManualECALLLaunchFailure",
        "DetectManualECALLCancellation",
        "ReceptionofPSAPMSGSEND",
        "VoiceConnectionandMSDnotSuccessfullyTransmitted",
        "VoiceConnectionandMSDSuccessfullyTransmitted",
        "DetectFailureofCommunication",
        "DetectNormalEndofCommunication",
        "DetectIncomingCall",
        "NoUse",
        "EcallSystemMalfunction",
    };

    if (T_e8_TCU_EcallStateDisplay_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_TCU_EcallStateDisplay_IsValid (T_e8_TCU_EcallStateDisplay value)
{
    switch (value) {
    case T_e8_TCU_EcallStateDisplay__Nothingtodisplay:
    case T_e8_TCU_EcallStateDisplay__NotUsed:
    case T_e8_TCU_EcallStateDisplay__DetectECALLDeactivationbyDiagTool:
    case T_e8_TCU_EcallStateDisplay__DetectECALLActivationbyDiagTool:
    case T_e8_TCU_EcallStateDisplay__DetectManualECALLLaunch:
    case T_e8_TCU_EcallStateDisplay__DetectAutomaticECALLLaunch:
    case T_e8_TCU_EcallStateDisplay__DetectManualECALLLaunchFailure:
    case T_e8_TCU_EcallStateDisplay__DetectManualECALLCancellation:
    case T_e8_TCU_EcallStateDisplay__ReceptionofPSAPMSGSEND:
    case T_e8_TCU_EcallStateDisplay__VoiceConnectionandMSDnotSuccessfullyTransmitted:
    case T_e8_TCU_EcallStateDisplay__VoiceConnectionandMSDSuccessfullyTransmitted:
    case T_e8_TCU_EcallStateDisplay__DetectFailureofCommunication:
    case T_e8_TCU_EcallStateDisplay__DetectNormalEndofCommunication:
    case T_e8_TCU_EcallStateDisplay__DetectIncomingCall:
    case T_e8_TCU_EcallStateDisplay__NoUse:
    case T_e8_TCU_EcallStateDisplay__EcallSystemMalfunction:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_Opcode_Parse (const char *str, size_t length, T_e8_TCU_Opcode &value)
{
    static stringEntry entries[] = {
        {6,"STATUS", 1U},
        {10,"INDICATION", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_TCU_Opcode_Name (T_e8_TCU_Opcode value)
{
    static const char* enumerationLiterals[] = {
        "INDICATION",
        "STATUS",
    };

    if (T_e8_TCU_Opcode_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_TCU_Opcode_IsValid (T_e8_TCU_Opcode value)
{
    switch (value) {
    case T_e8_TCU_Opcode__INDICATION:
    case T_e8_TCU_Opcode__STATUS:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_Mode_Parse (const char *str, size_t length, T_e8_TCU_Mode &value)
{
    static stringEntry entries[] = {
        {2,"ON", 1U},
        {3,"OFF", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_TCU_Mode_Name (T_e8_TCU_Mode value)
{
    static const char* enumerationLiterals[] = {
        "OFF",
        "ON",
    };

    if (T_e8_TCU_Mode_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_TCU_Mode_IsValid (T_e8_TCU_Mode value)
{
    switch (value) {
    case T_e8_TCU_Mode__OFF:
    case T_e8_TCU_Mode__ON:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_Service_Type_Parse (const char *str, size_t length, T_e8_TCU_Service_Type &value)
{
    static stringEntry entries[] = {
        {11,"UNAVAILABLE", 255U},
        {22,"EMERGENCYSTATIONFINDER", 1U},
        {23,"COMPATIBLESTATIONFINDER", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_TCU_Service_Type_Name (T_e8_TCU_Service_Type value)
{
    static const char* enumerationLiterals[] = {
        "CompatibleStationFinder",
        "EmergencyStationFinder",
        "Unavailable",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 3, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_TCU_Service_Type_IsValid (T_e8_TCU_Service_Type value)
{
    switch (value) {
    case T_e8_TCU_Service_Type__CompatibleStationFinder:
    case T_e8_TCU_Service_Type__EmergencyStationFinder:
    case T_e8_TCU_Service_Type__Unavailable:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_ePOI_Type_Parse (const char *str, size_t length, T_e8_TCU_ePOI_Type &value)
{
    static stringEntry entries[] = {
        {4,"SPOT", 1U},
        {9,"QUICKDROP", 2U},
        {11,"UNAVAILABLE", 255U},
        {11,"UNSPECIFIED", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_TCU_ePOI_Type_Name (T_e8_TCU_ePOI_Type value)
{
    static const char* enumerationLiterals[] = {
        "Unspecified",
        "Spot",
        "QuickDrop",
        "Unavailable",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 4, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_TCU_ePOI_Type_IsValid (T_e8_TCU_ePOI_Type value)
{
    switch (value) {
    case T_e8_TCU_ePOI_Type__Unspecified:
    case T_e8_TCU_ePOI_Type__Spot:
    case T_e8_TCU_ePOI_Type__QuickDrop:
    case T_e8_TCU_ePOI_Type__Unavailable:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_Finder_Status_Parse (const char *str, size_t length, T_e8_TCU_Finder_Status &value)
{
    static stringEntry entries[] = {
        {9,"NO_SEARCH", 1U},
        {11,"UNAVAILABLE", 255U},
        {13,"STATION_FOUND", 3U},
        {15,"SEARCH_ONG_OING", 2U},
        {16,"GSM_NOTAVAILABLE", 5U},
        {17,"ALL_STATION_FOUND", 4U},
        {17,"NO_STATIONS_FOUND", 7U},
        {22,"FUNCTION_NOT_ACTIVATED", 6U},
    };

    return lookupInStringEntryTable (str, length, entries, 8, (unsigned int&) value);
}

const char* T_e8_TCU_Finder_Status_Name (T_e8_TCU_Finder_Status value)
{
    static const char* enumerationLiterals[] = {
        "No_search",
        "Search_ong_oing",
        "Station_found",
        "All_station_found",
        "GSM_notavailable",
        "Function_not_activated",
        "No_Stations_Found",
        "Unavailable",
    };

    static unsigned int enumerationValues[] = {
        1U,
        2U,
        3U,
        4U,
        5U,
        6U,
        7U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 8, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_TCU_Finder_Status_IsValid (T_e8_TCU_Finder_Status value)
{
    switch (value) {
    case T_e8_TCU_Finder_Status__No_search:
    case T_e8_TCU_Finder_Status__Search_ong_oing:
    case T_e8_TCU_Finder_Status__Station_found:
    case T_e8_TCU_Finder_Status__All_station_found:
    case T_e8_TCU_Finder_Status__GSM_notavailable:
    case T_e8_TCU_Finder_Status__Function_not_activated:
    case T_e8_TCU_Finder_Status__No_Stations_Found:
    case T_e8_TCU_Finder_Status__Unavailable:
        return true;
    default:
        return false;
    }
}

bool T_TCU_Charge_Station_Accessibility_Parse (const char *str, size_t length, T_TCU_Charge_Station_Accessibility &value)
{
    static stringEntry entries[] = {
        {11,"UNAVAILABLE", 255U},
        {11,"UNSPECIFIED", 0U},
        {17,"RESTRICTED_ACCESS", 2U},
        {24,"FREE_PUBLICLY_ACCESSIBLE", 1U},
        {26,"PAYING_PUBLICLY_ACCESSIBLE", 3U},
    };

    return lookupInStringEntryTable (str, length, entries, 5, (unsigned int&) value);
}

const char* T_TCU_Charge_Station_Accessibility_Name (T_TCU_Charge_Station_Accessibility value)
{
    static const char* enumerationLiterals[] = {
        "Unspecified",
        "Free_publicly_accessible",
        "Restricted_access",
        "Paying_publicly_accessible",
        "Unavailable",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 5, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_TCU_Charge_Station_Accessibility_IsValid (T_TCU_Charge_Station_Accessibility value)
{
    switch (value) {
    case T_TCU_Charge_Station_Accessibility__Unspecified:
    case T_TCU_Charge_Station_Accessibility__Free_publicly_accessible:
    case T_TCU_Charge_Station_Accessibility__Restricted_access:
    case T_TCU_Charge_Station_Accessibility__Paying_publicly_accessible:
    case T_TCU_Charge_Station_Accessibility__Unavailable:
        return true;
    default:
        return false;
    }
}

bool T_TCU_Payment_Method_Type_Parse (const char *str, size_t length, T_TCU_Payment_Method_Type &value)
{
    static stringEntry entries[] = {
        {8,"VARIABLE", 9U},
        {10,"NO_PAYMENT", 1U},
        {11,"PAYING_CASH", 2U},
        {11,"UNAVAILABLE", 255U},
        {11,"UNSPECIFIED", 0U},
        {12,"PAYING_COINS", 7U},
        {16,"PAYING_FLAT_FREE", 8U},
        {18,"PAYING_CREDIT_CARD", 3U},
        {25,"PAYING_BANK_OR_DEBIT_CARD", 4U},
        {33,"PAYING_ELECTRONIC_TOLL_COLLECTION", 6U},
        {49,"PAYING_RECHARGING_PAYMENT_CARD_OR_PRE_PAYING_CARD", 5U},
    };

    return lookupInStringEntryTable (str, length, entries, 11, (unsigned int&) value);
}

const char* T_TCU_Payment_Method_Type_Name (T_TCU_Payment_Method_Type value)
{
    static const char* enumerationLiterals[] = {
        "Unspecified",
        "No_payment",
        "Paying_Cash",
        "Paying_Credit_Card",
        "Paying_Bank_or_Debit_Card",
        "Paying_recharging_payment_card_or_pre_paying_card",
        "Paying_Electronic_Toll_collection",
        "Paying_Coins",
        "Paying_flat_free",
        "variable",
        "Unavailable",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        4U,
        5U,
        6U,
        7U,
        8U,
        9U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 11, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_TCU_Payment_Method_Type_IsValid (T_TCU_Payment_Method_Type value)
{
    switch (value) {
    case T_TCU_Payment_Method_Type__Unspecified:
    case T_TCU_Payment_Method_Type__No_payment:
    case T_TCU_Payment_Method_Type__Paying_Cash:
    case T_TCU_Payment_Method_Type__Paying_Credit_Card:
    case T_TCU_Payment_Method_Type__Paying_Bank_or_Debit_Card:
    case T_TCU_Payment_Method_Type__Paying_recharging_payment_card_or_pre_paying_card:
    case T_TCU_Payment_Method_Type__Paying_Electronic_Toll_collection:
    case T_TCU_Payment_Method_Type__Paying_Coins:
    case T_TCU_Payment_Method_Type__Paying_flat_free:
    case T_TCU_Payment_Method_Type__variable:
    case T_TCU_Payment_Method_Type__Unavailable:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_Bookable_Information_Parse (const char *str, size_t length, T_e8_TCU_Bookable_Information &value)
{
    static stringEntry entries[] = {
        {7,"INVALID", 3U},
        {11,"UNSPECIFIED", 0U},
        {17,"FACILITY_BOOKABLE", 2U},
        {21,"FACILITY_NOT_BOOKABLE", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_TCU_Bookable_Information_Name (T_e8_TCU_Bookable_Information value)
{
    static const char* enumerationLiterals[] = {
        "Unspecified",
        "Facility_not_Bookable",
        "Facility_Bookable",
        "Invalid",
    };

    if (T_e8_TCU_Bookable_Information_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_TCU_Bookable_Information_IsValid (T_e8_TCU_Bookable_Information value)
{
    switch (value) {
    case T_e8_TCU_Bookable_Information__Unspecified:
    case T_e8_TCU_Bookable_Information__Facility_not_Bookable:
    case T_e8_TCU_Bookable_Information__Facility_Bookable:
    case T_e8_TCU_Bookable_Information__Invalid:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_Spot_Availability_Parse (const char *str, size_t length, T_e8_TCU_Spot_Availability &value)
{
    static stringEntry entries[] = {
        {7,"INVALID", 3U},
        {11,"UNSPECIFIED", 0U},
        {14,"SPOT_AVAILABLE", 2U},
        {18,"SPOT_NOT_AVAILABLE", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_TCU_Spot_Availability_Name (T_e8_TCU_Spot_Availability value)
{
    static const char* enumerationLiterals[] = {
        "Unspecified",
        "Spot_not_Available",
        "Spot_Available",
        "Invalid",
    };

    if (T_e8_TCU_Spot_Availability_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_TCU_Spot_Availability_IsValid (T_e8_TCU_Spot_Availability value)
{
    switch (value) {
    case T_e8_TCU_Spot_Availability__Unspecified:
    case T_e8_TCU_Spot_Availability__Spot_not_Available:
    case T_e8_TCU_Spot_Availability__Spot_Available:
    case T_e8_TCU_Spot_Availability__Invalid:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_Charge_Receptacle_Type_Parse (const char *str, size_t length, T_e8_TCU_Charge_Receptacle_Type &value)
{
    static stringEntry entries[] = {
        {9,"NEMA_5_20", 7U},
        {9,"SAE_J1772", 25U},
        {11,"UNAVAILABLE", 31U},
        {12,"SMALL_PADDLE", 2U},
        {15,"AVCON_CONNECTOR", 4U},
        {15,"TESLA_CONNECTOR", 5U},
        {20,"CHADEMO_QUICK_CHARGE", 27U},
        {21,"STANDARD_HOUSEHOLD_GB", 19U},
        {22,"LARGE_PADDLE_INDUCTIVE", 3U},
        {24,"STANDARD_HOUSEHOLD_ITALY", 18U},
        {25,"STANDARD_HOUSEHOLD_EUROPE", 21U},
        {26,"IEC_62196_2_TYPE_2_OUTLETS", 8U},
        {26,"STANDARD_HOUSEHOLD_DENMARK", 22U},
        {27,"309_SINGLE_PHASE_INDUSTRIAL", 13U},
        {27,"STANDARD_HOUSEHOLD_COLOMBIA", 26U},
        {30,"STANDARD_HOUSEHOLD_SWIZTERLAND", 20U},
        {32,"CABLE_ATTACHED_WITH_JARI_LEVEL_3", 11U},
        {34,"IEC_62196_2_TYPE_3_OUTLET_16A_MONO", 9U},
        {34,"IEC_62196_2_TYPE_3_OUTLET_32A_MONO", 17U},
        {37,"IEC_62196_2_TYPE_3_OUTLET_32A_TRIPHAS", 10U},
        {48,"CABLE_ATTACHED_WITH_IEC_62196_2_TYPE_1_CONNECTOR", 14U},
        {48,"CABLE_ATTACHED_WITH_IEC_62196_2_TYPE_2_CONNECTOR", 15U},
        {57,"CABLE_ATTACHED_WITH_IEC_62196_2_TYPE_3_CONNECTOR_16A_MONO", 16U},
        {64,"CABLE_ATTACHED_WITH_IEC_62196_2_TYPE_3_INLET_CONNECTOR_32_A_MONO", 23U},
        {68,"CABLE_ATTACHED_WITH_IEC_62196_2_TYPE_3_INLET_CONNECTOR_32_A_TRIPHASE", 24U},
    };

    return lookupInStringEntryTable (str, length, entries, 25, (unsigned int&) value);
}

const char* T_e8_TCU_Charge_Receptacle_Type_Name (T_e8_TCU_Charge_Receptacle_Type value)
{
    static const char* enumerationLiterals[] = {
        "Small_Paddle",
        "Large_Paddle_Inductive",
        "AVCON_Connector",
        "Tesla_Connector",
        "NEMA_5_20",
        "IEC_62196_2_type_2_outlets",
        "IEC_62196_2_type_3_outlet_16A_mono",
        "IEC_62196_2_type_3_outlet_32A_Triphas",
        "Cable_attached_with_Jari_level_3",
        "309_Single_phase_industrial",
        "Cable_attached_with_IEC_62196_2_type_1_connector",
        "Cable_attached_with_IEC_62196_2_type_2_connector",
        "Cable_attached_with_IEC_62196_2_type_3_connector_16A_mono",
        "IEC_62196_2_type_3_outlet_32A_mono",
        "Standard_household_Italy",
        "Standard_household_GB",
        "Standard_household_Swizterland",
        "Standard_household_Europe",
        "Standard_household_Denmark",
        "Cable_attached_with_IEC_62196_2_type_3_inlet_connector_32_A_mono",
        "Cable_attached_with_IEC_62196_2_type_3_inlet_connector_32_A_triphase",
        "SAE_J1772",
        "Standard_household_Colombia",
        "Chademo_quick_charge",
        "Unavailable",
    };

    static unsigned int enumerationValues[] = {
        2U,
        3U,
        4U,
        5U,
        7U,
        8U,
        9U,
        10U,
        11U,
        13U,
        14U,
        15U,
        16U,
        17U,
        18U,
        19U,
        20U,
        21U,
        22U,
        23U,
        24U,
        25U,
        26U,
        27U,
        31U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 25, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_TCU_Charge_Receptacle_Type_IsValid (T_e8_TCU_Charge_Receptacle_Type value)
{
    switch (value) {
    case T_e8_TCU_Charge_Receptacle_Type__Small_Paddle:
    case T_e8_TCU_Charge_Receptacle_Type__Large_Paddle_Inductive:
    case T_e8_TCU_Charge_Receptacle_Type__AVCON_Connector:
    case T_e8_TCU_Charge_Receptacle_Type__Tesla_Connector:
    case T_e8_TCU_Charge_Receptacle_Type__NEMA_5_20:
    case T_e8_TCU_Charge_Receptacle_Type__IEC_62196_2_type_2_outlets:
    case T_e8_TCU_Charge_Receptacle_Type__IEC_62196_2_type_3_outlet_16A_mono:
    case T_e8_TCU_Charge_Receptacle_Type__IEC_62196_2_type_3_outlet_32A_Triphas:
    case T_e8_TCU_Charge_Receptacle_Type__Cable_attached_with_Jari_level_3:
    case T_e8_TCU_Charge_Receptacle_Type__309_Single_phase_industrial:
    case T_e8_TCU_Charge_Receptacle_Type__Cable_attached_with_IEC_62196_2_type_1_connector:
    case T_e8_TCU_Charge_Receptacle_Type__Cable_attached_with_IEC_62196_2_type_2_connector:
    case T_e8_TCU_Charge_Receptacle_Type__Cable_attached_with_IEC_62196_2_type_3_connector_16A_mono:
    case T_e8_TCU_Charge_Receptacle_Type__IEC_62196_2_type_3_outlet_32A_mono:
    case T_e8_TCU_Charge_Receptacle_Type__Standard_household_Italy:
    case T_e8_TCU_Charge_Receptacle_Type__Standard_household_GB:
    case T_e8_TCU_Charge_Receptacle_Type__Standard_household_Swizterland:
    case T_e8_TCU_Charge_Receptacle_Type__Standard_household_Europe:
    case T_e8_TCU_Charge_Receptacle_Type__Standard_household_Denmark:
    case T_e8_TCU_Charge_Receptacle_Type__Cable_attached_with_IEC_62196_2_type_3_inlet_connector_32_A_mono:
    case T_e8_TCU_Charge_Receptacle_Type__Cable_attached_with_IEC_62196_2_type_3_inlet_connector_32_A_triphase:
    case T_e8_TCU_Charge_Receptacle_Type__SAE_J1772:
    case T_e8_TCU_Charge_Receptacle_Type__Standard_household_Colombia:
    case T_e8_TCU_Charge_Receptacle_Type__Chademo_quick_charge:
    case T_e8_TCU_Charge_Receptacle_Type__Unavailable:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_Charge_Receptacle_Facility_Parse (const char *str, size_t length, T_e8_TCU_Charge_Receptacle_Facility &value)
{
    static stringEntry entries[] = {
        {2,"DC", 17U},
        {11,"UNAVAILABLE", 63U},
        {11,"UNSPECIFIED", 62U},
        {16,"BATTERY_EXCHANGE", 7U},
        {19,"100_120V_1_PHASE_8A", 10U},
        {19,"200_240V_1_PHASE_8A", 14U},
        {20,"100_120V_1_PHASE_10A", 11U},
        {20,"100_120V_1_PHASE_12A", 12U},
        {20,"100_120V_1_PHASE_16A", 13U},
        {20,"200_240V_1_PHASE_10A", 0U},
        {20,"200_240V_1_PHASE_12A", 1U},
        {20,"200_240V_1_PHASE_16A", 2U},
        {20,"200_240V_1_PHASE_32A", 3U},
        {20,"200_240V_3_PHASE_16A", 15U},
        {20,"200_240V_3_PHASE_32A", 16U},
        {20,"380_480V_3_PHASE_16A", 4U},
        {21,"RESERVED_1_ULTRA_FAST", 8U},
        {21,"RESERVED_2_ULTRA_FAST", 9U},
        {22,"380_480V_TRI_PHASE_32A", 5U},
        {22,"380_480V_TRI_PHASE_63A", 6U},
    };

    return lookupInStringEntryTable (str, length, entries, 20, (unsigned int&) value);
}

const char* T_e8_TCU_Charge_Receptacle_Facility_Name (T_e8_TCU_Charge_Receptacle_Facility value)
{
    static const char* enumerationLiterals[] = {
        "200_240v_1_Phase_10A",
        "200_240v_1_Phase_12A",
        "200_240v_1_Phase_16A",
        "200_240v_1_Phase_32A",
        "380_480v_3_Phase_16A",
        "380_480v_Tri_Phase_32A",
        "380_480v_Tri_Phase_63A",
        "Battery_exchange",
        "Reserved_1_Ultra_Fast",
        "Reserved_2_Ultra_Fast",
        "100_120v_1_Phase_8A",
        "100_120v_1_Phase_10A",
        "100_120v_1_Phase_12A",
        "100_120v_1_Phase_16A",
        "200_240v_1_Phase_8A",
        "200_240v_3_Phase_16A",
        "200_240v_3_Phase_32A",
        "DC",
        "Unspecified",
        "Unavailable",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        4U,
        5U,
        6U,
        7U,
        8U,
        9U,
        10U,
        11U,
        12U,
        13U,
        14U,
        15U,
        16U,
        17U,
        62U,
        63U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 20, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_TCU_Charge_Receptacle_Facility_IsValid (T_e8_TCU_Charge_Receptacle_Facility value)
{
    switch (value) {
    case T_e8_TCU_Charge_Receptacle_Facility__200_240v_1_Phase_10A:
    case T_e8_TCU_Charge_Receptacle_Facility__200_240v_1_Phase_12A:
    case T_e8_TCU_Charge_Receptacle_Facility__200_240v_1_Phase_16A:
    case T_e8_TCU_Charge_Receptacle_Facility__200_240v_1_Phase_32A:
    case T_e8_TCU_Charge_Receptacle_Facility__380_480v_3_Phase_16A:
    case T_e8_TCU_Charge_Receptacle_Facility__380_480v_Tri_Phase_32A:
    case T_e8_TCU_Charge_Receptacle_Facility__380_480v_Tri_Phase_63A:
    case T_e8_TCU_Charge_Receptacle_Facility__Battery_exchange:
    case T_e8_TCU_Charge_Receptacle_Facility__Reserved_1_Ultra_Fast:
    case T_e8_TCU_Charge_Receptacle_Facility__Reserved_2_Ultra_Fast:
    case T_e8_TCU_Charge_Receptacle_Facility__100_120v_1_Phase_8A:
    case T_e8_TCU_Charge_Receptacle_Facility__100_120v_1_Phase_10A:
    case T_e8_TCU_Charge_Receptacle_Facility__100_120v_1_Phase_12A:
    case T_e8_TCU_Charge_Receptacle_Facility__100_120v_1_Phase_16A:
    case T_e8_TCU_Charge_Receptacle_Facility__200_240v_1_Phase_8A:
    case T_e8_TCU_Charge_Receptacle_Facility__200_240v_3_Phase_16A:
    case T_e8_TCU_Charge_Receptacle_Facility__200_240v_3_Phase_32A:
    case T_e8_TCU_Charge_Receptacle_Facility__DC:
    case T_e8_TCU_Charge_Receptacle_Facility__Unspecified:
    case T_e8_TCU_Charge_Receptacle_Facility__Unavailable:
        return true;
    default:
        return false;
    }
}

bool T_e8_Language_Family_Type_Parse (const char *str, size_t length, T_e8_Language_Family_Type &value)
{
    static stringEntry entries[] = {
        {13,"FAMILY_TYPE_1", 0U},
        {13,"FAMILY_TYPE_2", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_Language_Family_Type_Name (T_e8_Language_Family_Type value)
{
    static const char* enumerationLiterals[] = {
        "Family_type_1",
        "Family_type_2",
    };

    if (T_e8_Language_Family_Type_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_Language_Family_Type_IsValid (T_e8_Language_Family_Type value)
{
    switch (value) {
    case T_e8_Language_Family_Type__Family_type_1:
    case T_e8_Language_Family_Type__Family_type_2:
        return true;
    default:
        return false;
    }
}

bool T_e8_Language_Type_Parse (const char *str, size_t length, T_e8_Language_Type &value)
{
    static stringEntry entries[] = {
        {7,"DEFAULT", 0U},
        {13,"DUTCH_OR_DANE", 9U},
        {15,"ENGLISH_OR_FINN", 2U},
        {15,"FRENCH_OR_SWEDE", 1U},
        {16,"POLISH_OR_SLOVAK", 7U},
        {18,"KOREAN_OR_ESTONIAN", 10U},
        {18,"SPANISH_OR_SLOVENE", 4U},
        {18,"TURKISH_OR_TCHEQUE", 8U},
        {19,"GERMAN_OR_BULGARIAN", 3U},
        {19,"PORTUGUESE_OR_GREEK", 5U},
        {20,"ITALIAN_OR_HUNGARIAN", 6U},
        {22,"LETTONIE_OR_LITHUANIAN", 11U},
    };

    return lookupInStringEntryTable (str, length, entries, 12, (unsigned int&) value);
}

const char* T_e8_Language_Type_Name (T_e8_Language_Type value)
{
    static const char* enumerationLiterals[] = {
        "Default",
        "French_or_Swede",
        "English_or_Finn",
        "German_or_Bulgarian",
        "Spanish_or_Slovene",
        "Portuguese_or_Greek",
        "Italian_or_Hungarian",
        "Polish_or_Slovak",
        "Turkish_or_Tcheque",
        "Dutch_or_Dane",
        "Korean_or_Estonian",
        "Lettonie_or_Lithuanian",
    };

    if (T_e8_Language_Type_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_Language_Type_IsValid (T_e8_Language_Type value)
{
    switch (value) {
    case T_e8_Language_Type__Default:
    case T_e8_Language_Type__French_or_Swede:
    case T_e8_Language_Type__English_or_Finn:
    case T_e8_Language_Type__German_or_Bulgarian:
    case T_e8_Language_Type__Spanish_or_Slovene:
    case T_e8_Language_Type__Portuguese_or_Greek:
    case T_e8_Language_Type__Italian_or_Hungarian:
    case T_e8_Language_Type__Polish_or_Slovak:
    case T_e8_Language_Type__Turkish_or_Tcheque:
    case T_e8_Language_Type__Dutch_or_Dane:
    case T_e8_Language_Type__Korean_or_Estonian:
    case T_e8_Language_Type__Lettonie_or_Lithuanian:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_Booking_Status_Parse (const char *str, size_t length, T_e8_TCU_Booking_Status &value)
{
    static stringEntry entries[] = {
        {11,"UNAVAILABLE", 255U},
        {15,"BOOKING_SUCCESS", 4U},
        {19,"BOOKING_IN_PROGRESS", 5U},
        {21,"BOOKING_REQUEST_ABORT", 2U},
        {31,"BOOKING_FAILED_UNDEFINED_REASON", 3U},
        {62,"BOOKING_FAILED_BECAUSE_OF_UNKNOWN_CUSTOMER_CONTRACT_IDENTIFIER", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 6, (unsigned int&) value);
}

const char* T_e8_TCU_Booking_Status_Name (T_e8_TCU_Booking_Status value)
{
    static const char* enumerationLiterals[] = {
        "Booking_failed_because_of_unknown_Customer_Contract_Identifier",
        "Booking_request_abort",
        "Booking_failed_undefined_reason",
        "Booking_success",
        "Booking_in_progress",
        "Unavailable",
    };

    static unsigned int enumerationValues[] = {
        1U,
        2U,
        3U,
        4U,
        5U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 6, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_TCU_Booking_Status_IsValid (T_e8_TCU_Booking_Status value)
{
    switch (value) {
    case T_e8_TCU_Booking_Status__Booking_failed_because_of_unknown_Customer_Contract_Identifier:
    case T_e8_TCU_Booking_Status__Booking_request_abort:
    case T_e8_TCU_Booking_Status__Booking_failed_undefined_reason:
    case T_e8_TCU_Booking_Status__Booking_success:
    case T_e8_TCU_Booking_Status__Booking_in_progress:
    case T_e8_TCU_Booking_Status__Unavailable:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_Unbooking_Status_Parse (const char *str, size_t length, T_e8_TCU_Unbooking_Status &value)
{
    static stringEntry entries[] = {
        {11,"UNAVAILABLE", 255U},
        {17,"UNBOOKING_SUCCESS", 4U},
        {18,"UNBOOKING_PROGRESS", 5U},
        {23,"UNBOOKING_REQUEST_ABORT", 2U},
        {33,"UNBOOKING_FAILED_UNDEFINED_REASON", 3U},
        {64,"UNBOOKING_FAILED_BECAUSE_OF_UNKNOWN_CUSTOMER_CONTRACT_IDENTIFIER", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 6, (unsigned int&) value);
}

const char* T_e8_TCU_Unbooking_Status_Name (T_e8_TCU_Unbooking_Status value)
{
    static const char* enumerationLiterals[] = {
        "Unbooking_failed_because_of_unknown_Customer_Contract_Identifier",
        "Unbooking_request_abort",
        "Unbooking_failed_undefined_reason",
        "Unbooking_success",
        "Unbooking_progress",
        "Unavailable",
    };

    static unsigned int enumerationValues[] = {
        1U,
        2U,
        3U,
        4U,
        5U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 6, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_TCU_Unbooking_Status_IsValid (T_e8_TCU_Unbooking_Status value)
{
    switch (value) {
    case T_e8_TCU_Unbooking_Status__Unbooking_failed_because_of_unknown_Customer_Contract_Identifier:
    case T_e8_TCU_Unbooking_Status__Unbooking_request_abort:
    case T_e8_TCU_Unbooking_Status__Unbooking_failed_undefined_reason:
    case T_e8_TCU_Unbooking_Status__Unbooking_success:
    case T_e8_TCU_Unbooking_Status__Unbooking_progress:
    case T_e8_TCU_Unbooking_Status__Unavailable:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_Update_Status_Parse (const char *str, size_t length, T_e8_TCU_Update_Status &value)
{
    static stringEntry entries[] = {
        {11,"UNAVAILABLE", 255U},
        {13,"UPDATE_FAILED", 1U},
        {14,"UPDATE_SUCCESS", 4U},
        {18,"UPDATE_IN_PROGRESS", 5U},
        {20,"UPDATE_REQUEST_ABORT", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 5, (unsigned int&) value);
}

const char* T_e8_TCU_Update_Status_Name (T_e8_TCU_Update_Status value)
{
    static const char* enumerationLiterals[] = {
        "Update_failed",
        "Update_request_abort",
        "Update_success",
        "Update_in_Progress",
        "Unavailable",
    };

    static unsigned int enumerationValues[] = {
        1U,
        2U,
        4U,
        5U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 5, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_TCU_Update_Status_IsValid (T_e8_TCU_Update_Status value)
{
    switch (value) {
    case T_e8_TCU_Update_Status__Update_failed:
    case T_e8_TCU_Update_Status__Update_request_abort:
    case T_e8_TCU_Update_Status__Update_success:
    case T_e8_TCU_Update_Status__Update_in_Progress:
    case T_e8_TCU_Update_Status__Unavailable:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_Sch_Activation_State_Parse (const char *str, size_t length, T_e8_TCU_Sch_Activation_State &value)
{
    static stringEntry entries[] = {
        {19,"SCHEDULER_ACTIVATED", 0U},
        {21,"SCHEDULER_DEACTIVATED", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_TCU_Sch_Activation_State_Name (T_e8_TCU_Sch_Activation_State value)
{
    static const char* enumerationLiterals[] = {
        "Scheduler_Activated",
        "Scheduler_Deactivated",
    };

    if (T_e8_TCU_Sch_Activation_State_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_TCU_Sch_Activation_State_IsValid (T_e8_TCU_Sch_Activation_State value)
{
    switch (value) {
    case T_e8_TCU_Sch_Activation_State__Scheduler_Activated:
    case T_e8_TCU_Sch_Activation_State__Scheduler_Deactivated:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_Charge_Blocked_Status_Parse (const char *str, size_t length, T_e8_TCU_Charge_Blocked_Status &value)
{
    static stringEntry entries[] = {
        {11,"UNAVAILABLE", 0U},
        {14,"CHARGE_BLOCKED", 2U},
        {16,"CHARGE_AVAILABLE", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_TCU_Charge_Blocked_Status_Name (T_e8_TCU_Charge_Blocked_Status value)
{
    static const char* enumerationLiterals[] = {
        "Unavailable",
        "Charge_Available",
        "Charge_Blocked",
    };

    if (T_e8_TCU_Charge_Blocked_Status_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_TCU_Charge_Blocked_Status_IsValid (T_e8_TCU_Charge_Blocked_Status value)
{
    switch (value) {
    case T_e8_TCU_Charge_Blocked_Status__Unavailable:
    case T_e8_TCU_Charge_Blocked_Status__Charge_Available:
    case T_e8_TCU_Charge_Blocked_Status__Charge_Blocked:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_Wifi_Security_Mode_Parse (const char *str, size_t length, T_e8_TCU_Wifi_Security_Mode &value)
{
    static stringEntry entries[] = {
        {3,"WEP", 0U},
        {3,"WPA", 2U},
        {4,"WPA2", 3U},
        {6,"PUBLIC", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_TCU_Wifi_Security_Mode_Name (T_e8_TCU_Wifi_Security_Mode value)
{
    static const char* enumerationLiterals[] = {
        "WEP",
        "Public",
        "WPA",
        "WPA2",
    };

    if (T_e8_TCU_Wifi_Security_Mode_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_TCU_Wifi_Security_Mode_IsValid (T_e8_TCU_Wifi_Security_Mode value)
{
    switch (value) {
    case T_e8_TCU_Wifi_Security_Mode__WEP:
    case T_e8_TCU_Wifi_Security_Mode__Public:
    case T_e8_TCU_Wifi_Security_Mode__WPA:
    case T_e8_TCU_Wifi_Security_Mode__WPA2:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_Wifi_Visibility_Parse (const char *str, size_t length, T_e8_TCU_Wifi_Visibility &value)
{
    static stringEntry entries[] = {
        {12,"WIFI_VISIBLE", 0U},
        {16,"WIFI_NOT_VISIBLE", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_TCU_Wifi_Visibility_Name (T_e8_TCU_Wifi_Visibility value)
{
    static const char* enumerationLiterals[] = {
        "Wifi_Visible",
        "Wifi_Not_Visible",
    };

    if (T_e8_TCU_Wifi_Visibility_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_TCU_Wifi_Visibility_IsValid (T_e8_TCU_Wifi_Visibility value)
{
    switch (value) {
    case T_e8_TCU_Wifi_Visibility__Wifi_Visible:
    case T_e8_TCU_Wifi_Visibility__Wifi_Not_Visible:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_Wifi_Status_Parse (const char *str, size_t length, T_e8_TCU_Wifi_Status &value)
{
    static stringEntry entries[] = {
        {2,"ON", 1U},
        {3,"OFF", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_TCU_Wifi_Status_Name (T_e8_TCU_Wifi_Status value)
{
    static const char* enumerationLiterals[] = {
        "OFF",
        "ON",
    };

    if (T_e8_TCU_Wifi_Status_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_TCU_Wifi_Status_IsValid (T_e8_TCU_Wifi_Status value)
{
    switch (value) {
    case T_e8_TCU_Wifi_Status__OFF:
    case T_e8_TCU_Wifi_Status__ON:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_Wifi_Mode_Parse (const char *str, size_t length, T_e8_TCU_Wifi_Mode &value)
{
    static stringEntry entries[] = {
        {11,"WIFI_CLIENT", 1U},
        {16,"WIFI_UNAVAILABLE", 0U},
        {21,"WIFI_HOT_SPOT_VIA_TCU", 4U},
        {25,"WIFI_HOT_SPOT_VIA_USB_KEY", 2U},
        {27,"WIFI_HOT_SPOT_VIA_BLUETOOTH", 3U},
    };

    return lookupInStringEntryTable (str, length, entries, 5, (unsigned int&) value);
}

const char* T_e8_TCU_Wifi_Mode_Name (T_e8_TCU_Wifi_Mode value)
{
    static const char* enumerationLiterals[] = {
        "Wifi_Unavailable",
        "Wifi_Client",
        "Wifi_Hot_Spot_via_USB_Key",
        "Wifi_Hot_Spot_via_Bluetooth",
        "Wifi_Hot_Spot_via_TCU",
    };

    if (T_e8_TCU_Wifi_Mode_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_TCU_Wifi_Mode_IsValid (T_e8_TCU_Wifi_Mode value)
{
    switch (value) {
    case T_e8_TCU_Wifi_Mode__Wifi_Unavailable:
    case T_e8_TCU_Wifi_Mode__Wifi_Client:
    case T_e8_TCU_Wifi_Mode__Wifi_Hot_Spot_via_USB_Key:
    case T_e8_TCU_Wifi_Mode__Wifi_Hot_Spot_via_Bluetooth:
    case T_e8_TCU_Wifi_Mode__Wifi_Hot_Spot_via_TCU:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_Wifi_Connection_Status_Parse (const char *str, size_t length, T_e8_TCU_Wifi_Connection_Status &value)
{
    static stringEntry entries[] = {
        {7,"UNKNOWN", 0U},
        {8,"REJECTED", 2U},
        {8,"TIME_OUT", 3U},
        {9,"CONNECTED", 1U},
        {15,"CONNECTION_LOST", 5U},
        {22,"CONNECTION_IN_PROGRESS", 4U},
    };

    return lookupInStringEntryTable (str, length, entries, 6, (unsigned int&) value);
}

const char* T_e8_TCU_Wifi_Connection_Status_Name (T_e8_TCU_Wifi_Connection_Status value)
{
    static const char* enumerationLiterals[] = {
        "UnKnown",
        "Connected",
        "Rejected",
        "Time_out",
        "Connection_in_progress",
        "Connection_lost",
    };

    if (T_e8_TCU_Wifi_Connection_Status_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_TCU_Wifi_Connection_Status_IsValid (T_e8_TCU_Wifi_Connection_Status value)
{
    switch (value) {
    case T_e8_TCU_Wifi_Connection_Status__UnKnown:
    case T_e8_TCU_Wifi_Connection_Status__Connected:
    case T_e8_TCU_Wifi_Connection_Status__Rejected:
    case T_e8_TCU_Wifi_Connection_Status__Time_out:
    case T_e8_TCU_Wifi_Connection_Status__Connection_in_progress:
    case T_e8_TCU_Wifi_Connection_Status__Connection_lost:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_Wifi_Wifi_Scan_Security_Parse (const char *str, size_t length, T_e8_TCU_Wifi_Wifi_Scan_Security &value)
{
    static stringEntry entries[] = {
        {3,"WEP", 1U},
        {4,"OPEN", 0U},
        {11,"WPA_OR_WPA2", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_TCU_Wifi_Wifi_Scan_Security_Name (T_e8_TCU_Wifi_Wifi_Scan_Security value)
{
    static const char* enumerationLiterals[] = {
        "Open",
        "Wep",
        "WPA_OR_WPA2",
    };

    if (T_e8_TCU_Wifi_Wifi_Scan_Security_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_TCU_Wifi_Wifi_Scan_Security_IsValid (T_e8_TCU_Wifi_Wifi_Scan_Security value)
{
    switch (value) {
    case T_e8_TCU_Wifi_Wifi_Scan_Security__Open:
    case T_e8_TCU_Wifi_Wifi_Scan_Security__Wep:
    case T_e8_TCU_Wifi_Wifi_Scan_Security__WPA_OR_WPA2:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_Wifi_Wifi_Client_Status_Parse (const char *str, size_t length, T_e8_TCU_Wifi_Wifi_Client_Status &value)
{
    static stringEntry entries[] = {
        {9,"CONNECTED", 1U},
        {13,"NOT_CONNECTED", 0U},
        {16,"SCAN_IN_PROGRESS", 2U},
        {22,"CONNECTION_IN_PROGRESS", 3U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_TCU_Wifi_Wifi_Client_Status_Name (T_e8_TCU_Wifi_Wifi_Client_Status value)
{
    static const char* enumerationLiterals[] = {
        "Not_connected",
        "Connected",
        "Scan_in_progress",
        "Connection_in_progress",
    };

    if (T_e8_TCU_Wifi_Wifi_Client_Status_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_TCU_Wifi_Wifi_Client_Status_IsValid (T_e8_TCU_Wifi_Wifi_Client_Status value)
{
    switch (value) {
    case T_e8_TCU_Wifi_Wifi_Client_Status__Not_connected:
    case T_e8_TCU_Wifi_Wifi_Client_Status__Connected:
    case T_e8_TCU_Wifi_Wifi_Client_Status__Scan_in_progress:
    case T_e8_TCU_Wifi_Wifi_Client_Status__Connection_in_progress:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_Audio_SourceActivity_Parse (const char *str, size_t length, T_e8_TCU_Audio_SourceActivity &value)
{
    static stringEntry entries[] = {
        {3,"END", 0U},
        {5,"START", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_TCU_Audio_SourceActivity_Name (T_e8_TCU_Audio_SourceActivity value)
{
    static const char* enumerationLiterals[] = {
        "End",
        "Start",
    };

    if (T_e8_TCU_Audio_SourceActivity_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_TCU_Audio_SourceActivity_IsValid (T_e8_TCU_Audio_SourceActivity value)
{
    switch (value) {
    case T_e8_TCU_Audio_SourceActivity__End:
    case T_e8_TCU_Audio_SourceActivity__Start:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_Cycle_Parse (const char *str, size_t length, T_e8_TCU_Cycle &value)
{
    static stringEntry entries[] = {
        {8,"ALL_TIME", 9U},
        {9,"EVERY_DAY", 0U},
        {12,"EVERY_FRIDAY", 5U},
        {12,"EVERY_MONDAY", 1U},
        {12,"EVERY_SUNDAY", 7U},
        {13,"EVERY_TUESDAY", 2U},
        {14,"EVERY_SATURDAY", 6U},
        {14,"EVERY_THURSDAY", 4U},
        {15,"EVERY_WEDNESDAY", 3U},
        {28,"FROM_START_TIME_TO_STOP_TIME", 8U},
    };

    return lookupInStringEntryTable (str, length, entries, 10, (unsigned int&) value);
}

const char* T_e8_TCU_Cycle_Name (T_e8_TCU_Cycle value)
{
    static const char* enumerationLiterals[] = {
        "Every_Day",
        "Every_Monday",
        "Every_Tuesday",
        "Every_Wednesday",
        "Every_Thursday",
        "Every_Friday",
        "Every_Saturday",
        "Every_Sunday",
        "From_Start_Time_to_Stop_Time",
        "All_Time",
    };

    if (T_e8_TCU_Cycle_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_TCU_Cycle_IsValid (T_e8_TCU_Cycle value)
{
    switch (value) {
    case T_e8_TCU_Cycle__Every_Day:
    case T_e8_TCU_Cycle__Every_Monday:
    case T_e8_TCU_Cycle__Every_Tuesday:
    case T_e8_TCU_Cycle__Every_Wednesday:
    case T_e8_TCU_Cycle__Every_Thursday:
    case T_e8_TCU_Cycle__Every_Friday:
    case T_e8_TCU_Cycle__Every_Saturday:
    case T_e8_TCU_Cycle__Every_Sunday:
    case T_e8_TCU_Cycle__From_Start_Time_to_Stop_Time:
    case T_e8_TCU_Cycle__All_Time:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_Restriction_Area_Type_Parse (const char *str, size_t length, T_e8_TCU_Restriction_Area_Type &value)
{
    static stringEntry entries[] = {
        {9,"EXCLUSION", 1U},
        {9,"INCLUSION", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_TCU_Restriction_Area_Type_Name (T_e8_TCU_Restriction_Area_Type value)
{
    static const char* enumerationLiterals[] = {
        "Exclusion",
        "Inclusion",
    };

    if (T_e8_TCU_Restriction_Area_Type_IsValid(value))
        return enumerationLiterals[value - 1U];
    else
        return NULL;
}

bool T_e8_TCU_Restriction_Area_Type_IsValid (T_e8_TCU_Restriction_Area_Type value)
{
    switch (value) {
    case T_e8_TCU_Restriction_Area_Type__Inclusion:
    case T_e8_TCU_Restriction_Area_Type__Exclusion:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_Area_Form_Parse (const char *str, size_t length, T_e8_TCU_Area_Form &value)
{
    static stringEntry entries[] = {
        {11,"CIRCLE_AREA", 1U},
        {11,"SQUARE_AREA", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_TCU_Area_Form_Name (T_e8_TCU_Area_Form value)
{
    static const char* enumerationLiterals[] = {
        "Circle_Area",
        "Square_Area",
    };

    if (T_e8_TCU_Area_Form_IsValid(value))
        return enumerationLiterals[value - 1U];
    else
        return NULL;
}

bool T_e8_TCU_Area_Form_IsValid (T_e8_TCU_Area_Form value)
{
    switch (value) {
    case T_e8_TCU_Area_Form__Square_Area:
    case T_e8_TCU_Area_Form__Circle_Area:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_Restrictions_State_Parse (const char *str, size_t length, T_e8_TCU_Restrictions_State &value)
{
    static stringEntry entries[] = {
        {12,"RESTRICTIONS", 1U},
        {14,"NO_RESTRICTION", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_TCU_Restrictions_State_Name (T_e8_TCU_Restrictions_State value)
{
    static const char* enumerationLiterals[] = {
        "No_Restriction",
        "Restrictions",
    };

    if (T_e8_TCU_Restrictions_State_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_TCU_Restrictions_State_IsValid (T_e8_TCU_Restrictions_State value)
{
    switch (value) {
    case T_e8_TCU_Restrictions_State__No_Restriction:
    case T_e8_TCU_Restrictions_State__Restrictions:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_Time_Slot_State_Parse (const char *str, size_t length, T_e8_TCU_Time_Slot_State &value)
{
    static stringEntry entries[] = {
        {8,"ALL_TIME", 0U},
        {13,"TIME_SLOT_SET", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_TCU_Time_Slot_State_Name (T_e8_TCU_Time_Slot_State value)
{
    static const char* enumerationLiterals[] = {
        "All_Time",
        "Time_Slot_Set",
    };

    if (T_e8_TCU_Time_Slot_State_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_TCU_Time_Slot_State_IsValid (T_e8_TCU_Time_Slot_State value)
{
    switch (value) {
    case T_e8_TCU_Time_Slot_State__All_Time:
    case T_e8_TCU_Time_Slot_State__Time_Slot_Set:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_ConnectionType_Parse (const char *str, size_t length, T_e8_TCU_ConnectionType &value)
{
    static stringEntry entries[] = {
        {12,"MQTT_CONNECT", 1U},
        {18,"INVALID_CONNECTION", 0U},
        {18,"MQTT_SUBSCRIBE_ALL", 2U},
        {19,"OMA_DM_LOW_PRIORITY", 3U},
        {24,"OMA_DM_LOW_HIGH_PRIORITY", 4U},
    };

    return lookupInStringEntryTable (str, length, entries, 5, (unsigned int&) value);
}

const char* T_e8_TCU_ConnectionType_Name (T_e8_TCU_ConnectionType value)
{
    static const char* enumerationLiterals[] = {
        "Invalid_Connection",
        "MQTT_Connect",
        "MQTT_Subscribe_All",
        "OMA_DM_Low_Priority",
        "OMA_DM_Low_High_Priority",
    };

    if (T_e8_TCU_ConnectionType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_TCU_ConnectionType_IsValid (T_e8_TCU_ConnectionType value)
{
    switch (value) {
    case T_e8_TCU_ConnectionType__Invalid_Connection:
    case T_e8_TCU_ConnectionType__MQTT_Connect:
    case T_e8_TCU_ConnectionType__MQTT_Subscribe_All:
    case T_e8_TCU_ConnectionType__OMA_DM_Low_Priority:
    case T_e8_TCU_ConnectionType__OMA_DM_Low_High_Priority:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_XCALL_Type_Parse (const char *str, size_t length, T_e8_TCU_XCALL_Type &value)
{
    static stringEntry entries[] = {
        {8,"RESERVED", 5U},
        {9,"HELP_CALL", 3U},
        {10,"PANIC_CALL", 4U},
        {14,"BREAKDOWN_CALL", 0U},
        {14,"CONCIERGE_CALL", 2U},
        {30,"BREAKDOWN_WITH_DIAGNOSTIC_CALL", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 6, (unsigned int&) value);
}

const char* T_e8_TCU_XCALL_Type_Name (T_e8_TCU_XCALL_Type value)
{
    static const char* enumerationLiterals[] = {
        "Breakdown_Call",
        "Breakdown_with_diagnostic_Call",
        "Concierge_Call",
        "Help_Call",
        "Panic_Call",
        "Reserved",
    };

    if (T_e8_TCU_XCALL_Type_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_TCU_XCALL_Type_IsValid (T_e8_TCU_XCALL_Type value)
{
    switch (value) {
    case T_e8_TCU_XCALL_Type__Breakdown_Call:
    case T_e8_TCU_XCALL_Type__Breakdown_with_diagnostic_Call:
    case T_e8_TCU_XCALL_Type__Concierge_Call:
    case T_e8_TCU_XCALL_Type__Help_Call:
    case T_e8_TCU_XCALL_Type__Panic_Call:
    case T_e8_TCU_XCALL_Type__Reserved:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_XCALL_Language_Parse (const char *str, size_t length, T_e8_TCU_XCALL_Language &value)
{
    static stringEntry entries[] = {
        {4,"THAI", 51U},
        {5,"CZECH", 8U},
        {5,"DUTCH", 10U},
        {5,"GREEK", 24U},
        {5,"HINDI", 26U},
        {5,"MALAY", 34U},
        {6,"ARABIC", 2U},
        {6,"DANISH", 9U},
        {6,"FRENCH", 21U},
        {6,"GERMAN", 23U},
        {6,"HEBREW", 25U},
        {6,"KOREAN", 31U},
        {6,"POLISH", 38U},
        {7,"FINNISH", 19U},
        {7,"FLEMISH", 20U},
        {7,"ITALIAN", 29U},
        {7,"LATVIAN", 32U},
        {7,"RUSSIAN", 42U},
        {7,"SERBIAN", 43U},
        {7,"SPANISH", 46U},
        {7,"SWEDISH", 49U},
        {7,"TURKISH", 52U},
        {7,"UNKNOWN", 0U},
        {8,"ALBANESE", 1U},
        {8,"CROATIAN", 7U},
        {8,"ESTONIAN", 18U},
        {8,"JAPANESE", 30U},
        {8,"ROMANIAN", 41U},
        {9,"BULGARIAN", 3U},
        {9,"HUNGARIAN", 27U},
        {9,"NORWEGIAN", 35U},
        {9,"SLOVAKIAN", 44U},
        {9,"SLOVENIAN", 45U},
        {9,"TAIWANESE", 50U},
        {9,"UKRAINIAN", 53U},
        {10,"ENGLISH_UK", 12U},
        {10,"ENGLISH_US", 13U},
        {10,"INDONESIAN", 28U},
        {10,"LITHUANIAN", 33U},
        {10,"PORTUGUESE", 39U},
        {10,"VIETNAMESE", 54U},
        {11,"PHILIPPINES", 37U},
        {11,"UNSUPPORTED", 255U},
        {13,"ENGLISH_INDIA", 17U},
        {15,"FRENCH_CANADIAN", 22U},
        {15,"SPANISH_MEXICAN", 48U},
        {16,"ENGLISH_CANADIAN", 16U},
        {18,"ENGLISH_AUSTRALIAN", 11U},
        {18,"ENGLISH_US_FOR_JPN", 14U},
        {18,"ENGLISH_US_FOR_PRC", 15U},
        {20,"PORTUGUESE_BRAZILIAN", 40U},
        {21,"PERSIAN_FARSI_IRANIAN", 36U},
        {22,"SPANISH_LATIN_AMERICAN", 47U},
        {45,"CHINESE_MANDARIN_SIMPLIFIED_CHINESE_CHARACTER", 6U},
        {46,"CHINESE_CANTONESE_SIMPLIFIED_CHINESE_CHARACTER", 4U},
        {47,"CHINESE_CANTONESE_TRADITIONAL_CHINESE_CHARACTER", 5U},
    };

    return lookupInStringEntryTable (str, length, entries, 56, (unsigned int&) value);
}

const char* T_e8_TCU_XCALL_Language_Name (T_e8_TCU_XCALL_Language value)
{
    static const char* enumerationLiterals[] = {
        "Unknown",
        "Albanese",
        "Arabic",
        "Bulgarian",
        "Chinese_Cantonese_Simplified_Chinese_character",
        "Chinese_Cantonese_Traditional_Chinese_character",
        "Chinese_Mandarin_Simplified_Chinese_character",
        "Croatian",
        "Czech",
        "Danish",
        "Dutch",
        "English_Australian",
        "English_UK",
        "English_US",
        "English_US_for_JPN",
        "English_US_for_PRC",
        "English_Canadian",
        "English_India",
        "Estonian",
        "Finnish",
        "Flemish",
        "French",
        "French_Canadian",
        "German",
        "Greek",
        "Hebrew",
        "Hindi",
        "Hungarian",
        "Indonesian",
        "Italian",
        "Japanese",
        "Korean",
        "Latvian",
        "Lithuanian",
        "Malay",
        "Norwegian",
        "Persian_Farsi_Iranian",
        "Philippines",
        "Polish",
        "Portuguese",
        "Portuguese_Brazilian",
        "Romanian",
        "Russian",
        "Serbian",
        "Slovakian",
        "Slovenian",
        "Spanish",
        "Spanish_Latin_American",
        "Spanish_Mexican",
        "Swedish",
        "Taiwanese",
        "Thai",
        "Turkish",
        "Ukrainian",
        "Vietnamese",
        "UnSupported",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        4U,
        5U,
        6U,
        7U,
        8U,
        9U,
        10U,
        11U,
        12U,
        13U,
        14U,
        15U,
        16U,
        17U,
        18U,
        19U,
        20U,
        21U,
        22U,
        23U,
        24U,
        25U,
        26U,
        27U,
        28U,
        29U,
        30U,
        31U,
        32U,
        33U,
        34U,
        35U,
        36U,
        37U,
        38U,
        39U,
        40U,
        41U,
        42U,
        43U,
        44U,
        45U,
        46U,
        47U,
        48U,
        49U,
        50U,
        51U,
        52U,
        53U,
        54U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 56, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_TCU_XCALL_Language_IsValid (T_e8_TCU_XCALL_Language value)
{
    switch (value) {
    case T_e8_TCU_XCALL_Language__UnSupported:
    case T_e8_TCU_XCALL_Language__Vietnamese:
    case T_e8_TCU_XCALL_Language__Ukrainian:
    case T_e8_TCU_XCALL_Language__Turkish:
    case T_e8_TCU_XCALL_Language__Thai:
    case T_e8_TCU_XCALL_Language__Taiwanese:
    case T_e8_TCU_XCALL_Language__Swedish:
    case T_e8_TCU_XCALL_Language__Spanish_Mexican:
    case T_e8_TCU_XCALL_Language__Spanish_Latin_American:
    case T_e8_TCU_XCALL_Language__Spanish:
    case T_e8_TCU_XCALL_Language__Slovenian:
    case T_e8_TCU_XCALL_Language__Slovakian:
    case T_e8_TCU_XCALL_Language__Serbian:
    case T_e8_TCU_XCALL_Language__Russian:
    case T_e8_TCU_XCALL_Language__Romanian:
    case T_e8_TCU_XCALL_Language__Portuguese_Brazilian:
    case T_e8_TCU_XCALL_Language__Portuguese:
    case T_e8_TCU_XCALL_Language__Polish:
    case T_e8_TCU_XCALL_Language__Philippines:
    case T_e8_TCU_XCALL_Language__Persian_Farsi_Iranian:
    case T_e8_TCU_XCALL_Language__Norwegian:
    case T_e8_TCU_XCALL_Language__Malay:
    case T_e8_TCU_XCALL_Language__Lithuanian:
    case T_e8_TCU_XCALL_Language__Latvian:
    case T_e8_TCU_XCALL_Language__Korean:
    case T_e8_TCU_XCALL_Language__Japanese:
    case T_e8_TCU_XCALL_Language__Italian:
    case T_e8_TCU_XCALL_Language__Indonesian:
    case T_e8_TCU_XCALL_Language__Hungarian:
    case T_e8_TCU_XCALL_Language__Hindi:
    case T_e8_TCU_XCALL_Language__Hebrew:
    case T_e8_TCU_XCALL_Language__Greek:
    case T_e8_TCU_XCALL_Language__German:
    case T_e8_TCU_XCALL_Language__French_Canadian:
    case T_e8_TCU_XCALL_Language__French:
    case T_e8_TCU_XCALL_Language__Flemish:
    case T_e8_TCU_XCALL_Language__Finnish:
    case T_e8_TCU_XCALL_Language__Estonian:
    case T_e8_TCU_XCALL_Language__English_India:
    case T_e8_TCU_XCALL_Language__English_Canadian:
    case T_e8_TCU_XCALL_Language__English_US_for_PRC:
    case T_e8_TCU_XCALL_Language__English_US_for_JPN:
    case T_e8_TCU_XCALL_Language__English_US:
    case T_e8_TCU_XCALL_Language__English_UK:
    case T_e8_TCU_XCALL_Language__English_Australian:
    case T_e8_TCU_XCALL_Language__Dutch:
    case T_e8_TCU_XCALL_Language__Danish:
    case T_e8_TCU_XCALL_Language__Czech:
    case T_e8_TCU_XCALL_Language__Croatian:
    case T_e8_TCU_XCALL_Language__Chinese_Mandarin_Simplified_Chinese_character:
    case T_e8_TCU_XCALL_Language__Chinese_Cantonese_Traditional_Chinese_character:
    case T_e8_TCU_XCALL_Language__Chinese_Cantonese_Simplified_Chinese_character:
    case T_e8_TCU_XCALL_Language__Bulgarian:
    case T_e8_TCU_XCALL_Language__Arabic:
    case T_e8_TCU_XCALL_Language__Albanese:
    case T_e8_TCU_XCALL_Language__Unknown:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_Response_Time_Out_Parse (const char *str, size_t length, T_e8_TCU_Response_Time_Out &value)
{
    static stringEntry entries[] = {
        {5,"XCALL", 31U},
        {7,"ID_INFO", 5U},
        {9,"SCH_STATE", 22U},
        {9,"TCU_RESET", 13U},
        {9,"TCU_STATE", 2U},
        {11,"PIN_SETTING", 10U},
        {11,"SCH_ONBOARD", 21U},
        {13,"SHORT_BOOKING", 17U},
        {14,"CHARGE_STATION", 15U},
        {14,"SCH_ACTIVATION", 20U},
        {14,"STATION_FINDER", 14U},
        {15,"SHORT_UNBOOKING", 18U},
        {15,"WIFI_DATA_RESET", 27U},
        {16,"CHARGE_SPOT_LIST", 16U},
        {16,"HARDWARE_VERSION", 1U},
        {16,"SOFTWARE_VERSION", 0U},
        {17,"PROBE_INFO_DELETE", 9U},
        {17,"PROVISION_SERVICE", 3U},
        {18,"TCU_EXTENDED_STATE", 23U},
        {19,"CHARGE_REMINDER_GET", 11U},
        {19,"CHARGE_REMINDER_SET", 12U},
        {19,"RESTRICTION_SETTING", 24U},
        {19,"UPDATE_ENERGY_POINT", 19U},
        {20,"WIFI_CLIENT_SCAN_SET", 28U},
        {20,"WIFI_HOTSPOT_REQUEST", 25U},
        {22,"SERVICE_CALL_OPERATION", 4U},
        {23,"PROBE_UPLOAD_PERMIT_GET", 7U},
        {23,"PROBE_UPLOAD_PERMIT_SET", 8U},
        {23,"WIFI_ACTIVATION_REQUEST", 26U},
        {25,"WIFI_CLIENT_DISCONNECTION", 30U},
        {26,"WIFI_CLIENT_CONNECTION_SET", 29U},
        {29,"DRIVER_INFO_UPLOAD_PERMIT_SET", 6U},
    };

    return lookupInStringEntryTable (str, length, entries, 32, (unsigned int&) value);
}

const char* T_e8_TCU_Response_Time_Out_Name (T_e8_TCU_Response_Time_Out value)
{
    static const char* enumerationLiterals[] = {
        "SOFTWARE_VERSION",
        "HARDWARE_VERSION",
        "TCU_STATE",
        "PROVISION_SERVICE",
        "SERVICE_CALL_OPERATION",
        "ID_INFO",
        "DRIVER_INFO_UPLOAD_PERMIT_SET",
        "PROBE_UPLOAD_PERMIT_GET",
        "PROBE_UPLOAD_PERMIT_SET",
        "PROBE_INFO_DELETE",
        "PIN_SETTING",
        "CHARGE_REMINDER_GET",
        "CHARGE_REMINDER_SET",
        "TCU_RESET",
        "STATION_FINDER",
        "CHARGE_STATION",
        "CHARGE_SPOT_LIST",
        "SHORT_BOOKING",
        "SHORT_UNBOOKING",
        "UPDATE_ENERGY_POINT",
        "SCH_ACTIVATION",
        "SCH_ONBOARD",
        "SCH_STATE",
        "TCU_EXTENDED_STATE",
        "RESTRICTION_SETTING",
        "WIFI_HOTSPOT_REQUEST",
        "WIFI_ACTIVATION_REQUEST",
        "WIFI_DATA_RESET",
        "WIFI_CLIENT_SCAN_SET",
        "WIFI_CLIENT_CONNECTION_SET",
        "WIFI_CLIENT_DISCONNECTION",
        "XCALL",
    };

    if (T_e8_TCU_Response_Time_Out_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_TCU_Response_Time_Out_IsValid (T_e8_TCU_Response_Time_Out value)
{
    switch (value) {
    case T_e8_TCU_Response_Time_Out__SOFTWARE_VERSION:
    case T_e8_TCU_Response_Time_Out__HARDWARE_VERSION:
    case T_e8_TCU_Response_Time_Out__TCU_STATE:
    case T_e8_TCU_Response_Time_Out__PROVISION_SERVICE:
    case T_e8_TCU_Response_Time_Out__SERVICE_CALL_OPERATION:
    case T_e8_TCU_Response_Time_Out__ID_INFO:
    case T_e8_TCU_Response_Time_Out__DRIVER_INFO_UPLOAD_PERMIT_SET:
    case T_e8_TCU_Response_Time_Out__PROBE_UPLOAD_PERMIT_GET:
    case T_e8_TCU_Response_Time_Out__PROBE_UPLOAD_PERMIT_SET:
    case T_e8_TCU_Response_Time_Out__PROBE_INFO_DELETE:
    case T_e8_TCU_Response_Time_Out__PIN_SETTING:
    case T_e8_TCU_Response_Time_Out__CHARGE_REMINDER_GET:
    case T_e8_TCU_Response_Time_Out__CHARGE_REMINDER_SET:
    case T_e8_TCU_Response_Time_Out__TCU_RESET:
    case T_e8_TCU_Response_Time_Out__STATION_FINDER:
    case T_e8_TCU_Response_Time_Out__CHARGE_STATION:
    case T_e8_TCU_Response_Time_Out__CHARGE_SPOT_LIST:
    case T_e8_TCU_Response_Time_Out__SHORT_BOOKING:
    case T_e8_TCU_Response_Time_Out__SHORT_UNBOOKING:
    case T_e8_TCU_Response_Time_Out__UPDATE_ENERGY_POINT:
    case T_e8_TCU_Response_Time_Out__SCH_ACTIVATION:
    case T_e8_TCU_Response_Time_Out__SCH_ONBOARD:
    case T_e8_TCU_Response_Time_Out__SCH_STATE:
    case T_e8_TCU_Response_Time_Out__TCU_EXTENDED_STATE:
    case T_e8_TCU_Response_Time_Out__RESTRICTION_SETTING:
    case T_e8_TCU_Response_Time_Out__WIFI_HOTSPOT_REQUEST:
    case T_e8_TCU_Response_Time_Out__WIFI_ACTIVATION_REQUEST:
    case T_e8_TCU_Response_Time_Out__WIFI_DATA_RESET:
    case T_e8_TCU_Response_Time_Out__WIFI_CLIENT_SCAN_SET:
    case T_e8_TCU_Response_Time_Out__WIFI_CLIENT_CONNECTION_SET:
    case T_e8_TCU_Response_Time_Out__WIFI_CLIENT_DISCONNECTION:
    case T_e8_TCU_Response_Time_Out__XCALL:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_Availability_Parse (const char *str, size_t length, T_e8_TCU_Availability &value)
{
    static stringEntry entries[] = {
        {8,"WITH_TCU", 5U},
        {10,"WITH_ECALL", 1U},
        {11,"WITHOUT_TCU", 0U},
        {13,"INVALID_VALUE", 255U},
        {21,"WITHOUTTCU_OR_WITHTCU", 6U},
        {25,"WITHOUT_TCU_OR_ECALL_ONLY", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 6, (unsigned int&) value);
}

const char* T_e8_TCU_Availability_Name (T_e8_TCU_Availability value)
{
    static const char* enumerationLiterals[] = {
        "WITHOUT_TCU",
        "WITH_ECALL",
        "WITHOUT_TCU_OR_ECALL_ONLY",
        "WITH_TCU",
        "WITHOUTTCU_OR_WITHTCU",
        "INVALID_VALUE",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        5U,
        6U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 6, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_TCU_Availability_IsValid (T_e8_TCU_Availability value)
{
    switch (value) {
    case T_e8_TCU_Availability__WITHOUT_TCU:
    case T_e8_TCU_Availability__WITH_ECALL:
    case T_e8_TCU_Availability__WITHOUT_TCU_OR_ECALL_ONLY:
    case T_e8_TCU_Availability__WITH_TCU:
    case T_e8_TCU_Availability__WITHOUTTCU_OR_WITHTCU:
    case T_e8_TCU_Availability__INVALID_VALUE:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_CallType_Parse (const char *str, size_t length, T_e8_TCU_CallType &value)
{
    static stringEntry entries[] = {
        {5,"ECALL", 2U},
        {5,"XCALL", 3U},
        {7,"INVALID", 255U},
        {7,"UNKNOWN", 0U},
        {8,"ACN_CALL", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 5, (unsigned int&) value);
}

const char* T_e8_TCU_CallType_Name (T_e8_TCU_CallType value)
{
    static const char* enumerationLiterals[] = {
        "UNKNOWN",
        "ACN_CALL",
        "ECALL",
        "XCALL",
        "INVALID",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 5, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_TCU_CallType_IsValid (T_e8_TCU_CallType value)
{
    switch (value) {
    case T_e8_TCU_CallType__UNKNOWN:
    case T_e8_TCU_CallType__ACN_CALL:
    case T_e8_TCU_CallType__ECALL:
    case T_e8_TCU_CallType__XCALL:
    case T_e8_TCU_CallType__INVALID:
        return true;
    default:
        return false;
    }
}

bool T_e8_TCU_PrivacyModes_Parse (const char *str, size_t length, T_e8_TCU_PrivacyModes &value)
{
    static stringEntry entries[] = {
        {7,"UNKNOWN", 255U},
        {25,"PRIVACY_MANAGER_ACTIVATED", 0U},
        {27,"PRIVACY_MANAGER_DEACTIVATED", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_TCU_PrivacyModes_Name (T_e8_TCU_PrivacyModes value)
{
    static const char* enumerationLiterals[] = {
        "PRIVACY_MANAGER_ACTIVATED",
        "PRIVACY_MANAGER_DEACTIVATED",
        "UNKNOWN",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 3, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_TCU_PrivacyModes_IsValid (T_e8_TCU_PrivacyModes value)
{
    switch (value) {
    case T_e8_TCU_PrivacyModes__PRIVACY_MANAGER_ACTIVATED:
    case T_e8_TCU_PrivacyModes__PRIVACY_MANAGER_DEACTIVATED:
    case T_e8_TCU_PrivacyModes__UNKNOWN:
        return true;
    default:
        return false;
    }
}

} // namespace tcu_main_fi_types
