/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/stream/MemoryStream.h"
#include "tcu_main_fi_types.h"
#include "tcu_main_fi_typesCca.h"
#include "tcu_main_fi_typesConst.h"
#include <string>
#include <vector>


void serializeCca(const ::tcu_main_fi_types::T_TCU_VersionInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU8Upper();
    out << in.getU8Mid();
    out << in.getU8Lower();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi_types::T_TCU_VersionInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o0;
    in >> o0;
    out.setU8Upper(o0);
    uint8 o1;
    in >> o1;
    out.setU8Mid(o1);
    uint8 o2;
    in >> o2;
    out.setU8Lower(o2);
}

void serializeCca(const ::tcu_main_fi_types::T_TCU_Date_Time& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU16Year();
    out << in.getU8Month();
    out << in.getU8Day();
    out << in.getU8Hour();
    out << in.getU8Minute();
    out << in.getU8Second();
    out << in.getU8Reserve();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi_types::T_TCU_Date_Time& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o3;
    in >> o3;
    out.setU16Year(o3);
    uint8 o4;
    in >> o4;
    out.setU8Month(o4);
    uint8 o5;
    in >> o5;
    out.setU8Day(o5);
    uint8 o6;
    in >> o6;
    out.setU8Hour(o6);
    uint8 o7;
    in >> o7;
    out.setU8Minute(o7);
    uint8 o8;
    in >> o8;
    out.setU8Second(o8);
    uint8 o9;
    in >> o9;
    out.setU8Reserve(o9);
}

void serializeCca(const ::tcu_main_fi_types::T_TCU_Navi_Info& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getLocationInfo(), out, majorVersion);
    serializeCca(in.getRDateTime(), out, majorVersion);
    out << in.getU16VehicleHeading();
    out << in.getU8TimeZone();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi_types::T_TCU_Navi_Info& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getLocationInfoMutable(), majorVersion);
    deserializeCca(in, out.getRDateTimeMutable(), majorVersion);
    uint16 o10;
    in >> o10;
    out.setU16VehicleHeading(o10);
    uint8 o11;
    in >> o11;
    out.setU8TimeZone(o11);
}

void serializeCca(const ::tcu_main_fi_types::T_TCU_Score_Info& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU8ECOScore();
    out << in.getU8StartScore();
    out << in.getU8CruiseScore();
    out << in.getU8SlowdownScore();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi_types::T_TCU_Score_Info& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o12;
    in >> o12;
    out.setU8ECOScore(o12);
    uint8 o13;
    in >> o13;
    out.setU8StartScore(o13);
    uint8 o14;
    in >> o14;
    out.setU8CruiseScore(o14);
    uint8 o15;
    in >> o15;
    out.setU8SlowdownScore(o15);
}

void serializeCca(const ::tcu_main_fi_types::T_TCU_Probe_Vehicle_Info& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU16NaviVehicleSpeed();
    out << in.getU32NaviDrivingDistance();
    serializeCca(in.getNaviRoadClassification(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi_types::T_TCU_Probe_Vehicle_Info& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o16;
    in >> o16;
    out.setU16NaviVehicleSpeed(o16);
    uint32 o17;
    in >> o17;
    out.setU32NaviDrivingDistance(o17);
    deserializeCca(in, out.getNaviRoadClassificationMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi_types::T_TCU_Maintenance_Info& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8DistanceUnit();
    serializeCca(in.getRDistanceValue(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi_types::T_TCU_Maintenance_Info& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o18;
    in >> o18;
    out.setE8DistanceUnit((::tcu_main_fi_types::T_e8_TCU_Distance_Unit)o18);
    deserializeCca(in, out.getRDistanceValueMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi_types::T_TCU_Distance_Value& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU16OilFilter();
    out << in.getU16Oil();
    out << in.getU16Tire();
    out << in.getU16User();
    out << in.getU16Battery();
    out << in.getU16ACFilter();
    out << in.getU16Reserve();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi_types::T_TCU_Distance_Value& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o19;
    in >> o19;
    out.setU16OilFilter(o19);
    uint16 o20;
    in >> o20;
    out.setU16Oil(o20);
    uint16 o21;
    in >> o21;
    out.setU16Tire(o21);
    uint16 o22;
    in >> o22;
    out.setU16User(o22);
    uint16 o23;
    in >> o23;
    out.setU16Battery(o23);
    uint16 o24;
    in >> o24;
    out.setU16ACFilter(o24);
    uint16 o25;
    in >> o25;
    out.setU16Reserve(o25);
}

void serializeCca(const ::tcu_main_fi_types::T_TCU_Provision_List& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getBOperatorService();
    out << (uint8) in.getBConnectedSearch();
    out << (uint8) in.getBMobileInformation();
    out << in.getU16ReserveNissan();
    out << (uint8) in.getBInternetWidget();
    out << (uint8) in.getBFuelPrice();
    out << (uint8) in.getBLocalSearch();
    out << (uint8) in.getBWebPreTrip();
    out << (uint8) in.getBHDTraffic();
    out << (uint8) in.getBSpeedTrap();
    out << (uint8) in.getBPreventNav();
    out << (uint8) in.getBWeather();
    out << (uint8) in.getBLiveServices();
    out << (uint8) in.getBChargingSpotFinder();
    out << (uint8) in.getBChargingSchedule();
    out << in.getU16ReserveRenault();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi_types::T_TCU_Provision_List& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    bool o26;
    in >> o26;
    out.setBOperatorService(o26);
    bool o27;
    in >> o27;
    out.setBConnectedSearch(o27);
    bool o28;
    in >> o28;
    out.setBMobileInformation(o28);
    uint16 o29;
    in >> o29;
    out.setU16ReserveNissan(o29);
    bool o30;
    in >> o30;
    out.setBInternetWidget(o30);
    bool o31;
    in >> o31;
    out.setBFuelPrice(o31);
    bool o32;
    in >> o32;
    out.setBLocalSearch(o32);
    bool o33;
    in >> o33;
    out.setBWebPreTrip(o33);
    bool o34;
    in >> o34;
    out.setBHDTraffic(o34);
    bool o35;
    in >> o35;
    out.setBSpeedTrap(o35);
    bool o36;
    in >> o36;
    out.setBPreventNav(o36);
    bool o37;
    in >> o37;
    out.setBWeather(o37);
    bool o38;
    in >> o38;
    out.setBLiveServices(o38);
    bool o39;
    in >> o39;
    out.setBChargingSpotFinder(o39);
    bool o40;
    in >> o40;
    out.setBChargingSchedule(o40);
    uint16 o41;
    in >> o41;
    out.setU16ReserveRenault(o41);
}

void serializeCca(const ::tcu_main_fi_types::T_TCU_LocationInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8LocationType();
    out << (uint8) in.getE8Latitudemode();
    out << (uint8) in.getE8LongitudeMode();
    out << in.getU8LatitudeDEG();
    out << in.getU8LatitudeMIN();
    out << in.getU16LatitudeSEC();
    out << in.getU8LongitudeDEG();
    out << in.getU8LongitudeMIN();
    out << in.getU16LongitudeSEC();
    serializeCca(in.getAltitude(), out, majorVersion);
    out << in.getU8SatelliteNumber();
    out << (uint8) in.getE8Home();
    out << in.getU8Reserve();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi_types::T_TCU_LocationInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o42;
    in >> o42;
    out.setE8LocationType((::tcu_main_fi_types::T_e8_TCU_LocationType)o42);
    uint8 o43;
    in >> o43;
    out.setE8Latitudemode((::tcu_main_fi_types::T_e8_TCU_LatitudeMode)o43);
    uint8 o44;
    in >> o44;
    out.setE8LongitudeMode((::tcu_main_fi_types::T_e8_TCU_LongitudeMode)o44);
    uint8 o45;
    in >> o45;
    out.setU8LatitudeDEG(o45);
    uint8 o46;
    in >> o46;
    out.setU8LatitudeMIN(o46);
    uint16 o47;
    in >> o47;
    out.setU16LatitudeSEC(o47);
    uint8 o48;
    in >> o48;
    out.setU8LongitudeDEG(o48);
    uint8 o49;
    in >> o49;
    out.setU8LongitudeMIN(o49);
    uint16 o50;
    in >> o50;
    out.setU16LongitudeSEC(o50);
    deserializeCca(in, out.getAltitudeMutable(), majorVersion);
    uint8 o51;
    in >> o51;
    out.setU8SatelliteNumber(o51);
    uint8 o52;
    in >> o52;
    out.setE8Home((::tcu_main_fi_types::T_e8_TCU_Home)o52);
    uint8 o53;
    in >> o53;
    out.setU8Reserve(o53);
}

void serializeCca(const ::tcu_main_fi_types::T_TCU_Altitude& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8Sign();
    out << in.getU16Value();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi_types::T_TCU_Altitude& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o54;
    in >> o54;
    out.setE8Sign((::tcu_main_fi_types::T_e8_TCU_Sign)o54);
    uint16 o55;
    in >> o55;
    out.setU16Value(o55);
}

void serializeCca(const ::tcu_main_fi_types::T_TCU_Navi_Road_classification& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU8TableType();
    out << in.getU8RoadType();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi_types::T_TCU_Navi_Road_classification& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o56;
    in >> o56;
    out.setU8TableType(o56);
    uint8 o57;
    in >> o57;
    out.setU8RoadType(o57);
}

void serializeCca(const ::tcu_main_fi_types::T_TCU_ReminderInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8Plugin_Mode();
    out << (uint8) in.getE8Stop_Mode();
    out << in.getU16RemainTime();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi_types::T_TCU_ReminderInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o58;
    in >> o58;
    out.setE8Plugin_Mode((::tcu_main_fi_types::T_e8_TCU_Mode)o58);
    uint8 o59;
    in >> o59;
    out.setE8Stop_Mode((::tcu_main_fi_types::T_e8_TCU_Mode)o59);
    uint16 o60;
    in >> o60;
    out.setU16RemainTime(o60);
}

void serializeCca(const ::tcu_main_fi_types::T_TCU_GPS_Position& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU8Reserved();
    out << (uint8) in.getE8LocationType();
    out << (uint8) in.getE8Latitudemode();
    out << (uint8) in.getE8LongitudeMode();
    out << in.getU8LatitudeDEG();
    out << in.getU8LatitudeMIN();
    out << in.getU16LatitudeSEC();
    out << in.getU8LongitudeDEG();
    out << in.getU8LongitudeMIN();
    out << in.getU16LongitudeSEC();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi_types::T_TCU_GPS_Position& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o61;
    in >> o61;
    out.setU8Reserved(o61);
    uint8 o62;
    in >> o62;
    out.setE8LocationType((::tcu_main_fi_types::T_e8_TCU_LocationType)o62);
    uint8 o63;
    in >> o63;
    out.setE8Latitudemode((::tcu_main_fi_types::T_e8_TCU_LatitudeMode)o63);
    uint8 o64;
    in >> o64;
    out.setE8LongitudeMode((::tcu_main_fi_types::T_e8_TCU_LongitudeMode)o64);
    uint8 o65;
    in >> o65;
    out.setU8LatitudeDEG(o65);
    uint8 o66;
    in >> o66;
    out.setU8LatitudeMIN(o66);
    uint16 o67;
    in >> o67;
    out.setU16LatitudeSEC(o67);
    uint8 o68;
    in >> o68;
    out.setU8LongitudeDEG(o68);
    uint8 o69;
    in >> o69;
    out.setU8LongitudeMIN(o69);
    uint16 o70;
    in >> o70;
    out.setU16LongitudeSEC(o70);
}

void serializeCca(const ::tcu_main_fi_types::T_TCU_Time_Stamp& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU8Year();
    out << in.getU8Month();
    out << in.getU8Day();
    out << in.getU8Hour();
    out << in.getU8Minute();
    out << in.getU8Second();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi_types::T_TCU_Time_Stamp& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o71;
    in >> o71;
    out.setU8Year(o71);
    uint8 o72;
    in >> o72;
    out.setU8Month(o72);
    uint8 o73;
    in >> o73;
    out.setU8Day(o73);
    uint8 o74;
    in >> o74;
    out.setU8Hour(o74);
    uint8 o75;
    in >> o75;
    out.setU8Minute(o75);
    uint8 o76;
    in >> o76;
    out.setU8Second(o76);
}

void serializeCca(const ::tcu_main_fi_types::T_TCU_Opening_Hour& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getRSunday(), out, majorVersion);
    serializeCca(in.getRMonday(), out, majorVersion);
    serializeCca(in.getRTuesday(), out, majorVersion);
    serializeCca(in.getRWednesday(), out, majorVersion);
    serializeCca(in.getRThursday(), out, majorVersion);
    serializeCca(in.getRFriday(), out, majorVersion);
    serializeCca(in.getRSaturday(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi_types::T_TCU_Opening_Hour& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getRSundayMutable(), majorVersion);
    deserializeCca(in, out.getRMondayMutable(), majorVersion);
    deserializeCca(in, out.getRTuesdayMutable(), majorVersion);
    deserializeCca(in, out.getRWednesdayMutable(), majorVersion);
    deserializeCca(in, out.getRThursdayMutable(), majorVersion);
    deserializeCca(in, out.getRFridayMutable(), majorVersion);
    deserializeCca(in, out.getRSaturdayMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi_types::T_TCU_Opening_Hour_Day& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU8StartTime_1();
    out << in.getU8StartTime_2();
    out << in.getU8EndTime_1();
    out << in.getU8EndTime_2();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi_types::T_TCU_Opening_Hour_Day& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o77;
    in >> o77;
    out.setU8StartTime_1(o77);
    uint8 o78;
    in >> o78;
    out.setU8StartTime_2(o78);
    uint8 o79;
    in >> o79;
    out.setU8EndTime_1(o79);
    uint8 o80;
    in >> o80;
    out.setU8EndTime_2(o80);
}

void serializeCca(const ::tcu_main_fi_types::T_TCU_Full_Address& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU8Length_of_Text();
    out << in.getSText_Info();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi_types::T_TCU_Full_Address& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o81;
    in >> o81;
    out.setU8Length_of_Text(o81);
    ::std::string o82;
    in >> o82;
    out.setSText_Info(o82);
}

void serializeCca(const ::tcu_main_fi_types::T_TCU_Charge_Spot_List& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU8Total_pages_of_lists();
    out << in.getU8Pages_of_list();
    out << in.getU8Station_List_Number();
    serializeCca(in.getRSpot_List1(), out, majorVersion);
    serializeCca(in.getRSpot_List2(), out, majorVersion);
    serializeCca(in.getRSpot_List3(), out, majorVersion);
    serializeCca(in.getRSpot_List4(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi_types::T_TCU_Charge_Spot_List& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o83;
    in >> o83;
    out.setU8Total_pages_of_lists(o83);
    uint8 o84;
    in >> o84;
    out.setU8Pages_of_list(o84);
    uint8 o85;
    in >> o85;
    out.setU8Station_List_Number(o85);
    deserializeCca(in, out.getRSpot_List1Mutable(), majorVersion);
    deserializeCca(in, out.getRSpot_List2Mutable(), majorVersion);
    deserializeCca(in, out.getRSpot_List3Mutable(), majorVersion);
    deserializeCca(in, out.getRSpot_List4Mutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi_types::T_TCU_Spot_List& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getSCharge_Spot_ID();
    out << (uint8) in.getE8Bookable_Information();
    out << (uint8) in.getE8Spot_Availability();
    serializeCca(in.getRBookable_Free_Text(), out, majorVersion);
    out << in.getU8Total_Number_Receptacles();
    serializeCca(in.getRReceptacle1(), out, majorVersion);
    serializeCca(in.getRReceptacle2(), out, majorVersion);
    serializeCca(in.getRReceptacle3(), out, majorVersion);
    serializeCca(in.getRReceptacle4(), out, majorVersion);
    serializeCca(in.getRReceptacle5(), out, majorVersion);
    serializeCca(in.getRReceptacle6(), out, majorVersion);
    serializeCca(in.getRReceptacle7(), out, majorVersion);
    serializeCca(in.getRReceptacle8(), out, majorVersion);
    serializeCca(in.getRReceptacle9(), out, majorVersion);
    serializeCca(in.getRReceptacle10(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi_types::T_TCU_Spot_List& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o86;
    in >> o86;
    out.setSCharge_Spot_ID(o86);
    uint8 o87;
    in >> o87;
    out.setE8Bookable_Information((::tcu_main_fi_types::T_e8_TCU_Bookable_Information)o87);
    uint8 o88;
    in >> o88;
    out.setE8Spot_Availability((::tcu_main_fi_types::T_e8_TCU_Spot_Availability)o88);
    deserializeCca(in, out.getRBookable_Free_TextMutable(), majorVersion);
    uint8 o89;
    in >> o89;
    out.setU8Total_Number_Receptacles(o89);
    deserializeCca(in, out.getRReceptacle1Mutable(), majorVersion);
    deserializeCca(in, out.getRReceptacle2Mutable(), majorVersion);
    deserializeCca(in, out.getRReceptacle3Mutable(), majorVersion);
    deserializeCca(in, out.getRReceptacle4Mutable(), majorVersion);
    deserializeCca(in, out.getRReceptacle5Mutable(), majorVersion);
    deserializeCca(in, out.getRReceptacle6Mutable(), majorVersion);
    deserializeCca(in, out.getRReceptacle7Mutable(), majorVersion);
    deserializeCca(in, out.getRReceptacle8Mutable(), majorVersion);
    deserializeCca(in, out.getRReceptacle9Mutable(), majorVersion);
    deserializeCca(in, out.getRReceptacle10Mutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi_types::T_TCU_Bookable_Free_Text& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU8Length_of_Text();
    out << in.getSText_Info();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi_types::T_TCU_Bookable_Free_Text& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o90;
    in >> o90;
    out.setU8Length_of_Text(o90);
    ::std::string o91;
    in >> o91;
    out.setSText_Info(o91);
}

void serializeCca(const ::tcu_main_fi_types::T_TCU_Receptacle& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8Charge_Receptacle_Type();
    out << in.getU16Available_Power();
    out << (uint8) in.getE8Charge_Receptacle_Facility();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi_types::T_TCU_Receptacle& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o92;
    in >> o92;
    out.setE8Charge_Receptacle_Type((::tcu_main_fi_types::T_e8_TCU_Charge_Receptacle_Type)o92);
    uint16 o93;
    in >> o93;
    out.setU16Available_Power(o93);
    uint8 o94;
    in >> o94;
    out.setE8Charge_Receptacle_Facility((::tcu_main_fi_types::T_e8_TCU_Charge_Receptacle_Facility)o94);
}

void serializeCca(const ::tcu_main_fi_types::T_TCU_Time& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU8Hour();
    out << in.getU8Minute();
    out << in.getU8Seconds();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi_types::T_TCU_Time& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o95;
    in >> o95;
    out.setU8Hour(o95);
    uint8 o96;
    in >> o96;
    out.setU8Minute(o96);
    uint8 o97;
    in >> o97;
    out.setU8Seconds(o97);
}

void serializeCca(const ::tcu_main_fi_types::T_TCU_Navigation_Language& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU8Reserved();
    out << (uint8) in.getE8Language_Family_Type();
    out << (uint8) in.getE8Language_Type();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi_types::T_TCU_Navigation_Language& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o98;
    in >> o98;
    out.setU8Reserved(o98);
    uint8 o99;
    in >> o99;
    out.setE8Language_Family_Type((::tcu_main_fi_types::T_e8_Language_Family_Type)o99);
    uint8 o100;
    in >> o100;
    out.setE8Language_Type((::tcu_main_fi_types::T_e8_Language_Type)o100);
}

void serializeCca(const ::tcu_main_fi_types::T_TCU_Charge_Days& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDay1();
    out << in.getDay2();
    out << in.getDay3();
    out << in.getDay4();
    out << in.getDay5();
    out << in.getDay6();
    out << in.getDay7();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi_types::T_TCU_Charge_Days& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o101;
    in >> o101;
    out.setDay1(o101);
    uint8 o102;
    in >> o102;
    out.setDay2(o102);
    uint8 o103;
    in >> o103;
    out.setDay3(o103);
    uint8 o104;
    in >> o104;
    out.setDay4(o104);
    uint8 o105;
    in >> o105;
    out.setDay5(o105);
    uint8 o106;
    in >> o106;
    out.setDay6(o106);
    uint8 o107;
    in >> o107;
    out.setDay7(o107);
}

void serializeCca(const ::tcu_main_fi_types::T_TCU_Spot_Receptacle_Type& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getRDefault_receptacle_type();
    out << (uint8) in.getRUser_receptacle_type_1();
    out << (uint8) in.getRUser_receptacle_type_2();
    out << (uint8) in.getRUser_receptacle_type_3();
    out << in.getU8Reserved1();
    out << in.getU8Reserved2();
    out << in.getU8Reserved3();
    out << in.getU8Reserved4();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi_types::T_TCU_Spot_Receptacle_Type& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o108;
    in >> o108;
    out.setRDefault_receptacle_type((::tcu_main_fi_types::T_e8_TCU_Charge_Receptacle_Type)o108);
    uint8 o109;
    in >> o109;
    out.setRUser_receptacle_type_1((::tcu_main_fi_types::T_e8_TCU_Charge_Receptacle_Type)o109);
    uint8 o110;
    in >> o110;
    out.setRUser_receptacle_type_2((::tcu_main_fi_types::T_e8_TCU_Charge_Receptacle_Type)o110);
    uint8 o111;
    in >> o111;
    out.setRUser_receptacle_type_3((::tcu_main_fi_types::T_e8_TCU_Charge_Receptacle_Type)o111);
    uint8 o112;
    in >> o112;
    out.setU8Reserved1(o112);
    uint8 o113;
    in >> o113;
    out.setU8Reserved2(o113);
    uint8 o114;
    in >> o114;
    out.setU8Reserved3(o114);
    uint8 o115;
    in >> o115;
    out.setU8Reserved4(o115);
}

void serializeCca(const ::tcu_main_fi_types::T_TCU_PIN& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getRPIN_ID(), out, majorVersion);
    serializeCca(in.getRPIN_Password(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi_types::T_TCU_PIN& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getRPIN_IDMutable(), majorVersion);
    deserializeCca(in, out.getRPIN_PasswordMutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi_types::PIN_Data& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU8Length();
    out << in.getSText();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi_types::PIN_Data& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o116;
    in >> o116;
    out.setU8Length(o116);
    ::std::string o117;
    in >> o117;
    out.setSText(o117);
}

void serializeCca(const ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU8CharcterSet();
    out << in.getU8LentghOfText();
    out << in.getSText();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi_types::T_TCU_Wifi_SSID_Name& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o118;
    in >> o118;
    out.setU8CharcterSet(o118);
    uint8 o119;
    in >> o119;
    out.setU8LentghOfText(o119);
    ::std::string o120;
    in >> o120;
    out.setSText(o120);
}

void serializeCca(const ::tcu_main_fi_types::T_TCU_Wifi_PassKey& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU8CharcterSet();
    out << in.getU8LentghOfText();
    out << in.getSText();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi_types::T_TCU_Wifi_PassKey& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o121;
    in >> o121;
    out.setU8CharcterSet(o121);
    uint8 o122;
    in >> o122;
    out.setU8LentghOfText(o122);
    ::std::string o123;
    in >> o123;
    out.setSText(o123);
}

void serializeCca(const ::tcu_main_fi_types::T_TCU_Time_Slot& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getRStart_timeStamp(), out, majorVersion);
    serializeCca(in.getRStop_timeStamp(), out, majorVersion);
    out << (uint8) in.getE8Cycle();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi_types::T_TCU_Time_Slot& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getRStart_timeStampMutable(), majorVersion);
    deserializeCca(in, out.getRStop_timeStampMutable(), majorVersion);
    uint8 o124;
    in >> o124;
    out.setE8Cycle((::tcu_main_fi_types::T_e8_TCU_Cycle)o124);
}

void serializeCca(const ::tcu_main_fi_types::T_TCU_Coordinates& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8Latitudemode();
    out << (uint8) in.getE8LongitudeMode();
    out << in.getU8LatitudeDEG();
    out << in.getU8LatitudeMIN();
    out << in.getU16LatitudeSEC();
    out << in.getU8LongitudeDEG();
    out << in.getU8LongitudeMIN();
    out << in.getU16LongitudeSEC();
    out << in.getU8Reserve();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi_types::T_TCU_Coordinates& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o125;
    in >> o125;
    out.setE8Latitudemode((::tcu_main_fi_types::T_e8_TCU_LatitudeMode)o125);
    uint8 o126;
    in >> o126;
    out.setE8LongitudeMode((::tcu_main_fi_types::T_e8_TCU_LongitudeMode)o126);
    uint8 o127;
    in >> o127;
    out.setU8LatitudeDEG(o127);
    uint8 o128;
    in >> o128;
    out.setU8LatitudeMIN(o128);
    uint16 o129;
    in >> o129;
    out.setU16LatitudeSEC(o129);
    uint8 o130;
    in >> o130;
    out.setU8LongitudeDEG(o130);
    uint8 o131;
    in >> o131;
    out.setU8LongitudeMIN(o131);
    uint16 o132;
    in >> o132;
    out.setU16LongitudeSEC(o132);
    uint8 o133;
    in >> o133;
    out.setU8Reserve(o133);
}

void serializeCca(const ::tcu_main_fi_types::T_TCU_Area_Coordinate& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getRCoordinates1(), out, majorVersion);
    serializeCca(in.getRCoordinates2(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi_types::T_TCU_Area_Coordinate& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getRCoordinates1Mutable(), majorVersion);
    deserializeCca(in, out.getRCoordinates2Mutable(), majorVersion);
}

void serializeCca(const ::tcu_main_fi_types::T_TCU_Area_Limit_Coordinates& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8Restriction_Area_Type();
    out << (uint8) in.getE8Area_Form();
    out << (uint8) in.getE8LocationType();
    serializeCca(in.getRArea_Coordinates(), out, majorVersion);
    out << in.getU16Radius();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi_types::T_TCU_Area_Limit_Coordinates& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o134;
    in >> o134;
    out.setE8Restriction_Area_Type((::tcu_main_fi_types::T_e8_TCU_Restriction_Area_Type)o134);
    uint8 o135;
    in >> o135;
    out.setE8Area_Form((::tcu_main_fi_types::T_e8_TCU_Area_Form)o135);
    uint8 o136;
    in >> o136;
    out.setE8LocationType((::tcu_main_fi_types::T_e8_TCU_LocationType)o136);
    deserializeCca(in, out.getRArea_CoordinatesMutable(), majorVersion);
    uint16 o137;
    in >> o137;
    out.setU16Radius(o137);
}

void serializeCca(const ::tcu_main_fi_types::T_TCU_Speed_Limit_Restriction& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    {
        uint32 o138 = static_cast<uint32>(in.getRLimited_Vehicle_Speed().size());
        out << o138;
        ::std::vector< uint16 >::const_iterator o139;
        for (o139 = in.getRLimited_Vehicle_Speed().begin(); o139 != in.getRLimited_Vehicle_Speed().end(); ++o139) {
            out << (*o139);
        }
    }
    {
        uint32 o140 = static_cast<uint32>(in.getRTime_Slot().size());
        out << o140;
        ::std::vector< ::tcu_main_fi_types::T_TCU_Time_Slot >::const_iterator o141;
        for (o141 = in.getRTime_Slot().begin(); o141 != in.getRTime_Slot().end(); ++o141) {
            serializeCca((*o141), out, majorVersion);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi_types::T_TCU_Speed_Limit_Restriction& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    {
        uint32 o142;
        in >> o142;
        out.getRLimited_Vehicle_SpeedMutable().clear ();
        out.getRLimited_Vehicle_SpeedMutable().reserve (o142);
        for (uint32 o143 = 0; o143 < o142; o143++) {
            uint16 o144;
            in >> o144;
            out.getRLimited_Vehicle_SpeedMutable().push_back(o144);
        }
    }
    {
        uint32 o145;
        in >> o145;
        out.getRTime_SlotMutable().clear ();
        out.getRTime_SlotMutable().reserve (o145);
        for (uint32 o146 = 0; o146 < o145; o146++) {
            ::tcu_main_fi_types::T_TCU_Time_Slot o147;
            deserializeCca(in, o147, majorVersion);
            out.getRTime_SlotMutable().push_back (o147);
        }
    }
}

void serializeCca(const ::tcu_main_fi_types::T_TCU_Area_Limit_Restriction& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    {
        uint32 o148 = static_cast<uint32>(in.getRArea_Limit_Coordinates().size());
        out << o148;
        ::std::vector< ::tcu_main_fi_types::T_TCU_Area_Limit_Coordinates >::const_iterator o149;
        for (o149 = in.getRArea_Limit_Coordinates().begin(); o149 != in.getRArea_Limit_Coordinates().end(); ++o149) {
            serializeCca((*o149), out, majorVersion);
        }
    }
    {
        uint32 o150 = static_cast<uint32>(in.getRTime_Slot().size());
        out << o150;
        ::std::vector< ::tcu_main_fi_types::T_TCU_Time_Slot >::const_iterator o151;
        for (o151 = in.getRTime_Slot().begin(); o151 != in.getRTime_Slot().end(); ++o151) {
            serializeCca((*o151), out, majorVersion);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::tcu_main_fi_types::T_TCU_Area_Limit_Restriction& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    {
        uint32 o152;
        in >> o152;
        out.getRArea_Limit_CoordinatesMutable().clear ();
        out.getRArea_Limit_CoordinatesMutable().reserve (o152);
        for (uint32 o153 = 0; o153 < o152; o153++) {
            ::tcu_main_fi_types::T_TCU_Area_Limit_Coordinates o154;
            deserializeCca(in, o154, majorVersion);
            out.getRArea_Limit_CoordinatesMutable().push_back (o154);
        }
    }
    {
        uint32 o155;
        in >> o155;
        out.getRTime_SlotMutable().clear ();
        out.getRTime_SlotMutable().reserve (o155);
        for (uint32 o156 = 0; o156 < o155; o156++) {
            ::tcu_main_fi_types::T_TCU_Time_Slot o157;
            deserializeCca(in, o157, majorVersion);
            out.getRTime_SlotMutable().push_back (o157);
        }
    }
}

