/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/cca/CcaTypesConst.h"
#include "asf/stream/json.h"
#include "tcu_main_fi.h"
#include "tcu_main_fiJson.h"
#include "tcu_main_fiJsonPrivate.h"
#include "tcu_main_fi_types.h"
#include "tcu_main_fi_typesConst.h"
#include "tcu_main_fi_typesJsonPrivate.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

using namespace ::asf::stream::json;


// Json serialization of "ConnectionStatus"

void serializeJson (const ::tcu_main_fi::ConnectionStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBConnected()) {
        yajl_gen_string(g, (const unsigned char*)  "bConnected" , 10);
        yajl_gen_bool(g, (bool)value.getBConnected());
    }
    if (!isSparse || value.hasU8AbsenceState()) {
        yajl_gen_string(g, (const unsigned char*)  "u8AbsenceState" , 14);
        yajl_gen_integer(g, (long long)value.getU8AbsenceState());
    }
    if (!isSparse || value.hasU8MuteState()) {
        yajl_gen_string(g, (const unsigned char*)  "u8MuteState" , 11);
        yajl_gen_integer(g, (long long)value.getU8MuteState());
    }
    if (!isSparse || value.hasE8CommunicationStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "e8CommunicationStatus" , 21);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_CommunicationStatus_Name(value.getE8CommunicationStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8CommunicationStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::ConnectionStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ConfigurationStatus"

void serializeJson (const ::tcu_main_fi::ConfigurationStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ConfigurationStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ConfigurationStatus" , 21);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_ConfigurationStatus_Name(value.getE8ConfigurationStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ConfigurationStatus());
    }
    if (!isSparse || value.hasU8UnitId()) {
        yajl_gen_string(g, (const unsigned char*)  "u8UnitId" , 8);
        yajl_gen_integer(g, (long long)value.getU8UnitId());
    }
    if (!isSparse || value.hasRMessageVersion()) {
        yajl_gen_string(g, (const unsigned char*)  "rMessageVersion" , 15);
        serializeJson(value.getRMessageVersion(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::ConfigurationStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DataTransmissionStatus"

void serializeJson (const ::tcu_main_fi::DataTransmissionStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8MPDTMuteState()) {
        yajl_gen_string(g, (const unsigned char*)  "u8MPDTMuteState" , 15);
        yajl_gen_integer(g, (long long)value.getU8MPDTMuteState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::DataTransmissionStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ECallRequestStatus"

void serializeJson (const ::tcu_main_fi::ECallRequestStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBECallActive()) {
        yajl_gen_string(g, (const unsigned char*)  "bECallActive" , 12);
        yajl_gen_bool(g, (bool)value.getBECallActive());
    }
    if (!isSparse || value.hasBValid()) {
        yajl_gen_string(g, (const unsigned char*)  "bValid" , 6);
        yajl_gen_bool(g, (bool)value.getBValid());
    }
    if (!isSparse || value.hasBIsECallCallBackRequest()) {
        yajl_gen_string(g, (const unsigned char*)  "bIsECallCallBackRequest" , 23);
        yajl_gen_bool(g, (bool)value.getBIsECallCallBackRequest());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::ECallRequestStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ECallServiceStateStatus"

void serializeJson (const ::tcu_main_fi::ECallServiceStateStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ECallServiceState()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ECallServiceState" , 19);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_ServiceState_Name(value.getE8ECallServiceState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ECallServiceState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::ECallServiceStateStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AcceptECallRequestStart"

void serializeJson (const ::tcu_main_fi::AcceptECallRequestStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBECallAccepted()) {
        yajl_gen_string(g, (const unsigned char*)  "bECallAccepted" , 14);
        yajl_gen_bool(g, (bool)value.getBECallAccepted());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::AcceptECallRequestStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ACNRequestStatus"

void serializeJson (const ::tcu_main_fi::ACNRequestStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBACNActive()) {
        yajl_gen_string(g, (const unsigned char*)  "bACNActive" , 10);
        yajl_gen_bool(g, (bool)value.getBACNActive());
    }
    if (!isSparse || value.hasBValid()) {
        yajl_gen_string(g, (const unsigned char*)  "bValid" , 6);
        yajl_gen_bool(g, (bool)value.getBValid());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::ACNRequestStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ACNServiceStateStatus"

void serializeJson (const ::tcu_main_fi::ACNServiceStateStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ACNServiceState()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ACNServiceState" , 17);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_ServiceState_Name(value.getE8ACNServiceState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ACNServiceState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::ACNServiceStateStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CurfewAlertStatus"

void serializeJson (const ::tcu_main_fi::CurfewAlertStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8CurfewAlertWarning()) {
        yajl_gen_string(g, (const unsigned char*)  "e8CurfewAlertWarning" , 20);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_CurfewWarning_Name(value.getE8CurfewAlertWarning());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8CurfewAlertWarning());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::CurfewAlertStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GeoFenceStatus"

void serializeJson (const ::tcu_main_fi::GeoFenceStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBStatusFromTCU()) {
        yajl_gen_string(g, (const unsigned char*)  "bStatusFromTCU" , 14);
        yajl_gen_bool(g, (bool)value.getBStatusFromTCU());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::GeoFenceStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SpeedAlertStatus"

void serializeJson (const ::tcu_main_fi::SpeedAlertStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBStatusFromTCU()) {
        yajl_gen_string(g, (const unsigned char*)  "bStatusFromTCU" , 14);
        yajl_gen_bool(g, (bool)value.getBStatusFromTCU());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::SpeedAlertStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetTCUStateErrorStructure"

void serializeJson (const ::tcu_main_fi::GetTCUStateErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::GetTCUStateErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetTCUStateError"

void serializeJson (const ::tcu_main_fi::GetTCUStateError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_main_fi::GetTCUStateError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_main_fi::GetTCUStateError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_main_fi::GetTCUStateError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TCUStateStatus"

void serializeJson (const ::tcu_main_fi::TCUStateStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ModemStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ModemStatus" , 13);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_ModemStatus_Name(value.getE8ModemStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ModemStatus());
    }
    if (!isSparse || value.hasE8TcuStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "e8TcuStatus" , 11);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_TCUStatus_Name(value.getE8TcuStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8TcuStatus());
    }
    if (!isSparse || value.hasE8GSMStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "e8GSMStatus" , 11);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_GSMStatus_Name(value.getE8GSMStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8GSMStatus());
    }
    if (!isSparse || value.hasU8GSMRSSILevel()) {
        yajl_gen_string(g, (const unsigned char*)  "u8GSMRSSILevel" , 14);
        yajl_gen_integer(g, (long long)value.getU8GSMRSSILevel());
    }
    if (!isSparse || value.hasE8WifiStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "e8WifiStatus" , 12);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_WifiStatus_Name(value.getE8WifiStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8WifiStatus());
    }
    if (!isSparse || value.hasE8WifiMode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8WifiMode" , 10);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_WifiMode_Name(value.getE8WifiMode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8WifiMode());
    }
    if (!isSparse || value.hasE8WifiHotSpotStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "e8WifiHotSpotStatus" , 19);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_WifiHotSpotStatus_Name(value.getE8WifiHotSpotStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8WifiHotSpotStatus());
    }
    if (!isSparse || value.hasE8WifiClientStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "e8WifiClientStatus" , 18);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_WifiClientStatus_Name(value.getE8WifiClientStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8WifiClientStatus());
    }
    if (!isSparse || value.hasE8GSMDataMode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8GSMDataMode" , 13);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_GSMDataMode_Name(value.getE8GSMDataMode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8GSMDataMode());
    }
    if (!isSparse || value.hasU8WifiClientSSID()) {
        yajl_gen_string(g, (const unsigned char*)  "u8WifiClientSSID" , 16);
        yajl_gen_integer(g, (long long)value.getU8WifiClientSSID());
    }
    if (!isSparse || value.hasU8WifiClientPower()) {
        yajl_gen_string(g, (const unsigned char*)  "u8WifiClientPower" , 17);
        yajl_gen_integer(g, (long long)value.getU8WifiClientPower());
    }
    if (!isSparse || value.hasE8Opcode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Opcode" , 8);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Opcode_Name(value.getE8Opcode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Opcode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::TCUStateStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetIDInfoStart"

void serializeJson (const ::tcu_main_fi::GetIDInfoStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasNaviId()) {
        yajl_gen_string(g, (const unsigned char*)  "NaviId" , 6);
        const char *s = value.getNaviId().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasMapVersion()) {
        yajl_gen_string(g, (const unsigned char*)  "MapVersion" , 10);
        const char *s = value.getMapVersion().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::GetIDInfoStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetIDInfoErrorStructure"

void serializeJson (const ::tcu_main_fi::GetIDInfoErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::GetIDInfoErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetIDInfoError"

void serializeJson (const ::tcu_main_fi::GetIDInfoError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_main_fi::GetIDInfoError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_main_fi::GetIDInfoError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_main_fi::GetIDInfoError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IDInfoStatusStatus"

void serializeJson (const ::tcu_main_fi::IDInfoStatusStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8InvalidParameter()) {
        yajl_gen_string(g, (const unsigned char*)  "e8InvalidParameter" , 18);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_InvalidParameter_Name(value.getE8InvalidParameter());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8InvalidParameter());
    }
    if (!isSparse || value.hasSTCUID()) {
        yajl_gen_string(g, (const unsigned char*)  "sTCUID" , 6);
        const char *s = value.getSTCUID().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSICCID()) {
        yajl_gen_string(g, (const unsigned char*)  "sICCID" , 6);
        const char *s = value.getSICCID().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSVIN()) {
        yajl_gen_string(g, (const unsigned char*)  "sVIN" , 4);
        const char *s = value.getSVIN().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::IDInfoStatusStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetDriverInfoUploadPermitStart"

void serializeJson (const ::tcu_main_fi::SetDriverInfoUploadPermitStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8PermitSetting()) {
        yajl_gen_string(g, (const unsigned char*)  "e8PermitSetting" , 15);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_PermitSetting_Name(value.getE8PermitSetting());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8PermitSetting());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::SetDriverInfoUploadPermitStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetDriverInfoUploadPermitErrorStructure"

void serializeJson (const ::tcu_main_fi::SetDriverInfoUploadPermitErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::SetDriverInfoUploadPermitErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetDriverInfoUploadPermitError"

void serializeJson (const ::tcu_main_fi::SetDriverInfoUploadPermitError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_main_fi::SetDriverInfoUploadPermitError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_main_fi::SetDriverInfoUploadPermitError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_main_fi::SetDriverInfoUploadPermitError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DriverInfoUploadPermitStatusStatus"

void serializeJson (const ::tcu_main_fi::DriverInfoUploadPermitStatusStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8InvalidParameter()) {
        yajl_gen_string(g, (const unsigned char*)  "e8InvalidParameter" , 18);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_InvalidParameter_Name(value.getE8InvalidParameter());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8InvalidParameter());
    }
    if (!isSparse || value.hasE8PermitSetting()) {
        yajl_gen_string(g, (const unsigned char*)  "e8PermitSetting" , 15);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_PermitSetting_Name(value.getE8PermitSetting());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8PermitSetting());
    }
    if (!isSparse || value.hasBValid()) {
        yajl_gen_string(g, (const unsigned char*)  "bValid" , 6);
        yajl_gen_bool(g, (bool)value.getBValid());
    }
    if (!isSparse || value.hasE8AppContext()) {
        yajl_gen_string(g, (const unsigned char*)  "e8AppContext" , 12);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_APP_Context_Name(value.getE8AppContext());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8AppContext());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::DriverInfoUploadPermitStatusStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SMSNotificationStatusStatus"

void serializeJson (const ::tcu_main_fi::SMSNotificationStatusStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8PopUpFlag()) {
        yajl_gen_string(g, (const unsigned char*)  "e8PopUpFlag" , 11);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_PopUpFlag_Name(value.getE8PopUpFlag());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8PopUpFlag());
    }
    if (!isSparse || value.hasU8ConnectingPoint()) {
        yajl_gen_string(g, (const unsigned char*)  "u8ConnectingPoint" , 17);
        yajl_gen_integer(g, (long long)value.getU8ConnectingPoint());
    }
    if (!isSparse || value.hasU16InformationChannel()) {
        yajl_gen_string(g, (const unsigned char*)  "u16InformationChannel" , 21);
        yajl_gen_integer(g, (long long)value.getU16InformationChannel());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::SMSNotificationStatusStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetProbeUploadPermitErrorStructure"

void serializeJson (const ::tcu_main_fi::GetProbeUploadPermitErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::GetProbeUploadPermitErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetProbeUploadPermitError"

void serializeJson (const ::tcu_main_fi::GetProbeUploadPermitError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_main_fi::GetProbeUploadPermitError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_main_fi::GetProbeUploadPermitError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_main_fi::GetProbeUploadPermitError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetProbeUploadPermitStart"

void serializeJson (const ::tcu_main_fi::SetProbeUploadPermitStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ProbePermitSetting()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ProbePermitSetting" , 20);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_ProbePermitSetting_Name(value.getE8ProbePermitSetting());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ProbePermitSetting());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::SetProbeUploadPermitStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetProbeUploadPermitErrorStructure"

void serializeJson (const ::tcu_main_fi::SetProbeUploadPermitErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::SetProbeUploadPermitErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetProbeUploadPermitError"

void serializeJson (const ::tcu_main_fi::SetProbeUploadPermitError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_main_fi::SetProbeUploadPermitError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_main_fi::SetProbeUploadPermitError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_main_fi::SetProbeUploadPermitError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ProbeUploadPermitStatusStatus"

void serializeJson (const ::tcu_main_fi::ProbeUploadPermitStatusStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8InvalidParameter()) {
        yajl_gen_string(g, (const unsigned char*)  "e8InvalidParameter" , 18);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_InvalidParameter_Name(value.getE8InvalidParameter());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8InvalidParameter());
    }
    if (!isSparse || value.hasE8ProbePermitSetting()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ProbePermitSetting" , 20);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_ProbePermitSetting_Name(value.getE8ProbePermitSetting());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ProbePermitSetting());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::ProbeUploadPermitStatusStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetProbeInfoDeleteErrorStructure"

void serializeJson (const ::tcu_main_fi::SetProbeInfoDeleteErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::SetProbeInfoDeleteErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetProbeInfoDeleteError"

void serializeJson (const ::tcu_main_fi::SetProbeInfoDeleteError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_main_fi::SetProbeInfoDeleteError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_main_fi::SetProbeInfoDeleteError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_main_fi::SetProbeInfoDeleteError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ProbeInfoDeleteStatusStatus"

void serializeJson (const ::tcu_main_fi::ProbeInfoDeleteStatusStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBStatusFromTCU()) {
        yajl_gen_string(g, (const unsigned char*)  "bStatusFromTCU" , 14);
        yajl_gen_bool(g, (bool)value.getBStatusFromTCU());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::ProbeInfoDeleteStatusStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ServiceCallStateStatus"

void serializeJson (const ::tcu_main_fi::ServiceCallStateStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ServiceState()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ServiceState" , 14);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_ServiceState_Name(value.getE8ServiceState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ServiceState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::ServiceCallStateStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ServiceCallRequestStatus"

void serializeJson (const ::tcu_main_fi::ServiceCallRequestStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBServiceCallActive()) {
        yajl_gen_string(g, (const unsigned char*)  "bServiceCallActive" , 18);
        yajl_gen_bool(g, (bool)value.getBServiceCallActive());
    }
    if (!isSparse || value.hasBValid()) {
        yajl_gen_string(g, (const unsigned char*)  "bValid" , 6);
        yajl_gen_bool(g, (bool)value.getBValid());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::ServiceCallRequestStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetServiceCallOperationStart"

void serializeJson (const ::tcu_main_fi::SetServiceCallOperationStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8OperationRequest()) {
        yajl_gen_string(g, (const unsigned char*)  "e8OperationRequest" , 18);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_OperationRequest_Name(value.getE8OperationRequest());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8OperationRequest());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::SetServiceCallOperationStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetServiceCallOperationErrorStructure"

void serializeJson (const ::tcu_main_fi::SetServiceCallOperationErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::SetServiceCallOperationErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetServiceCallOperationError"

void serializeJson (const ::tcu_main_fi::SetServiceCallOperationError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_main_fi::SetServiceCallOperationError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_main_fi::SetServiceCallOperationError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_main_fi::SetServiceCallOperationError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TcuCallServiceStateStatus"

void serializeJson (const ::tcu_main_fi::TcuCallServiceStateStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ACNCallServiceState()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ACNCallServiceState" , 21);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_ServiceState_Name(value.getE8ACNCallServiceState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ACNCallServiceState());
    }
    if (!isSparse || value.hasE8EmergencyCallServiceState()) {
        yajl_gen_string(g, (const unsigned char*)  "e8EmergencyCallServiceState" , 27);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_ServiceState_Name(value.getE8EmergencyCallServiceState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8EmergencyCallServiceState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::TcuCallServiceStateStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetNaviInfoStart"

void serializeJson (const ::tcu_main_fi::SetNaviInfoStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRNaviData()) {
        yajl_gen_string(g, (const unsigned char*)  "rNaviData" , 9);
        serializeJson(value.getRNaviData(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::SetNaviInfoStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetNaviInfoErrorStructure"

void serializeJson (const ::tcu_main_fi::SetNaviInfoErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::SetNaviInfoErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetNaviInfoError"

void serializeJson (const ::tcu_main_fi::SetNaviInfoError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_main_fi::SetNaviInfoError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_main_fi::SetNaviInfoError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_main_fi::SetNaviInfoError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetTripScoreInfoStart"

void serializeJson (const ::tcu_main_fi::SetTripScoreInfoStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRTripEcoScoreInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "rTripEcoScoreInfo" , 17);
        serializeJson(value.getRTripEcoScoreInfo(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::SetTripScoreInfoStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetTripScoreInfoErrorStructure"

void serializeJson (const ::tcu_main_fi::SetTripScoreInfoErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::SetTripScoreInfoErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetTripScoreInfoError"

void serializeJson (const ::tcu_main_fi::SetTripScoreInfoError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_main_fi::SetTripScoreInfoError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_main_fi::SetTripScoreInfoError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_main_fi::SetTripScoreInfoError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetProbeVehicleInfoStart"

void serializeJson (const ::tcu_main_fi::SetProbeVehicleInfoStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRProbeVehicleInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "rProbeVehicleInfo" , 17);
        serializeJson(value.getRProbeVehicleInfo(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::SetProbeVehicleInfoStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetProbeVehicleInfoErrorStructure"

void serializeJson (const ::tcu_main_fi::SetProbeVehicleInfoErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::SetProbeVehicleInfoErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetProbeVehicleInfoError"

void serializeJson (const ::tcu_main_fi::SetProbeVehicleInfoError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_main_fi::SetProbeVehicleInfoError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_main_fi::SetProbeVehicleInfoError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_main_fi::SetProbeVehicleInfoError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MaintenanceInfoStart"

void serializeJson (const ::tcu_main_fi::MaintenanceInfoStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasMaintenanceInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "MaintenanceInfo" , 15);
        serializeJson(value.getMaintenanceInfo(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::MaintenanceInfoStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MaintenanceInfoErrorStructure"

void serializeJson (const ::tcu_main_fi::MaintenanceInfoErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::MaintenanceInfoErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MaintenanceInfoError"

void serializeJson (const ::tcu_main_fi::MaintenanceInfoError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_main_fi::MaintenanceInfoError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_main_fi::MaintenanceInfoError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_main_fi::MaintenanceInfoError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ProvisionServiceStatus"

void serializeJson (const ::tcu_main_fi::ProvisionServiceStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasProvisionService()) {
        yajl_gen_string(g, (const unsigned char*)  "ProvisionService" , 16);
        serializeJson(value.getProvisionService(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::ProvisionServiceStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "COMEcallStateStatus"

void serializeJson (const ::tcu_main_fi::COMEcallStateStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8EcallStateDisplay()) {
        yajl_gen_string(g, (const unsigned char*)  "e8EcallStateDisplay" , 19);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_EcallStateDisplay_Name(value.getE8EcallStateDisplay());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8EcallStateDisplay());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::COMEcallStateStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "COMEcallStartStatusErrorStructure"

void serializeJson (const ::tcu_main_fi::COMEcallStartStatusErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::COMEcallStartStatusErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "COMEcallStartStatusError"

void serializeJson (const ::tcu_main_fi::COMEcallStartStatusError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_main_fi::COMEcallStartStatusError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_main_fi::COMEcallStartStatusError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_main_fi::COMEcallStartStatusError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetTCUResetErrorStructure"

void serializeJson (const ::tcu_main_fi::SetTCUResetErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::SetTCUResetErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetTCUResetError"

void serializeJson (const ::tcu_main_fi::SetTCUResetError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_main_fi::SetTCUResetError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_main_fi::SetTCUResetError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_main_fi::SetTCUResetError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TCUResetStatusStatus"

void serializeJson (const ::tcu_main_fi::TCUResetStatusStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBStatusFromTCU()) {
        yajl_gen_string(g, (const unsigned char*)  "bStatusFromTCU" , 14);
        yajl_gen_bool(g, (bool)value.getBStatusFromTCU());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::TCUResetStatusStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "EmergencyStateStatus"

void serializeJson (const ::tcu_main_fi::EmergencyStateStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBEmergencyStateFromTCU()) {
        yajl_gen_string(g, (const unsigned char*)  "bEmergencyStateFromTCU" , 22);
        yajl_gen_bool(g, (bool)value.getBEmergencyStateFromTCU());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::EmergencyStateStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TCUResponseTimeOutStatus"

void serializeJson (const ::tcu_main_fi::TCUResponseTimeOutStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8TcuResponseTimeOut()) {
        yajl_gen_string(g, (const unsigned char*)  "u8TcuResponseTimeOut" , 20);
        yajl_gen_integer(g, (long long)value.getU8TcuResponseTimeOut());
    }
    if (!isSparse || value.hasTcuResponseTimeOut()) {
        yajl_gen_string(g, (const unsigned char*)  "TcuResponseTimeOut" , 18);
        yajl_gen_array_open(g);
        const ::std::vector< ::tcu_main_fi_types::T_e8_TCU_Response_Time_Out >& o1 = value.getTcuResponseTimeOut();
        {
            ::std::vector< ::tcu_main_fi_types::T_e8_TCU_Response_Time_Out >::const_iterator o0;
            for (o0 = o1.begin(); o0 != o1.end(); ++o0) {
                const char* s = ::tcu_main_fi_types::T_e8_TCU_Response_Time_Out_Name((*o0));
                if (s != NULL)
                    yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
                else
                    yajl_gen_integer(g, (long long)(*o0));
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasBTcuServiceCallOperationSetTimeOut()) {
        yajl_gen_string(g, (const unsigned char*)  "bTcuServiceCallOperationSetTimeOut" , 34);
        yajl_gen_bool(g, (bool)value.getBTcuServiceCallOperationSetTimeOut());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::TCUResponseTimeOutStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetTCUExtendedStateErrorStructure"

void serializeJson (const ::tcu_main_fi::GetTCUExtendedStateErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::GetTCUExtendedStateErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetTCUExtendedStateError"

void serializeJson (const ::tcu_main_fi::GetTCUExtendedStateError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_main_fi::GetTCUExtendedStateError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_main_fi::GetTCUExtendedStateError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_main_fi::GetTCUExtendedStateError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TCUExtendedStateStatus"

void serializeJson (const ::tcu_main_fi::TCUExtendedStateStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Invalid_Parameter()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Invalid_Parameter" , 19);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter_Name(value.getE8Invalid_Parameter());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Invalid_Parameter());
    }
    if (!isSparse || value.hasSIMEINumber()) {
        yajl_gen_string(g, (const unsigned char*)  "sIMEINumber" , 11);
        const char *s = value.getSIMEINumber().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSICC_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "sICC_ID" , 7);
        const char *s = value.getSICC_ID().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU16MCC()) {
        yajl_gen_string(g, (const unsigned char*)  "u16MCC" , 6);
        yajl_gen_integer(g, (long long)value.getU16MCC());
    }
    if (!isSparse || value.hasU8MNC()) {
        yajl_gen_string(g, (const unsigned char*)  "u8MNC" , 5);
        yajl_gen_integer(g, (long long)value.getU8MNC());
    }
    if (!isSparse || value.hasSMobile_Network_Name()) {
        yajl_gen_string(g, (const unsigned char*)  "sMobile_Network_Name" , 20);
        const char *s = value.getSMobile_Network_Name().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasE8RoamingStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "e8RoamingStatus" , 15);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_RoamingStatus_Name(value.getE8RoamingStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8RoamingStatus());
    }
    if (!isSparse || value.hasE8PPP_Connection_Status()) {
        yajl_gen_string(g, (const unsigned char*)  "e8PPP_Connection_Status" , 23);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_PPPConnectionStatus_Name(value.getE8PPP_Connection_Status());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8PPP_Connection_Status());
    }
    if (!isSparse || value.hasE8Opcode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Opcode" , 8);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Opcode_Name(value.getE8Opcode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Opcode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::TCUExtendedStateStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetPINSettingStart"

void serializeJson (const ::tcu_main_fi::SetPINSettingStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRPIN()) {
        yajl_gen_string(g, (const unsigned char*)  "rPIN" , 4);
        serializeJson(value.getRPIN(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::SetPINSettingStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetPINSettingErrorStructure"

void serializeJson (const ::tcu_main_fi::SetPINSettingErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::SetPINSettingErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetPINSettingError"

void serializeJson (const ::tcu_main_fi::SetPINSettingError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_main_fi::SetPINSettingError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_main_fi::SetPINSettingError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_main_fi::SetPINSettingError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PINSettingStatusStatus"

void serializeJson (const ::tcu_main_fi::PINSettingStatusStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Invalid_Parameter()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Invalid_Parameter" , 19);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter_Name(value.getE8Invalid_Parameter());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Invalid_Parameter());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::PINSettingStatusStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetChargeReminderErrorStructure"

void serializeJson (const ::tcu_main_fi::GetChargeReminderErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::GetChargeReminderErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetChargeReminderError"

void serializeJson (const ::tcu_main_fi::GetChargeReminderError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_main_fi::GetChargeReminderError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_main_fi::GetChargeReminderError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_main_fi::GetChargeReminderError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetChargeReminderStart"

void serializeJson (const ::tcu_main_fi::SetChargeReminderStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRReminderInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "rReminderInfo" , 13);
        serializeJson(value.getRReminderInfo(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::SetChargeReminderStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetChargeReminderErrorStructure"

void serializeJson (const ::tcu_main_fi::SetChargeReminderErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::SetChargeReminderErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetChargeReminderError"

void serializeJson (const ::tcu_main_fi::SetChargeReminderError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_main_fi::SetChargeReminderError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_main_fi::SetChargeReminderError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_main_fi::SetChargeReminderError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ChargeReminderStatusStatus"

void serializeJson (const ::tcu_main_fi::ChargeReminderStatusStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRReminderInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "rReminderInfo" , 13);
        serializeJson(value.getRReminderInfo(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::ChargeReminderStatusStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ChargeRecordDeleteStatus"

void serializeJson (const ::tcu_main_fi::ChargeRecordDeleteStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRReminderInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "rReminderInfo" , 13);
        serializeJson(value.getRReminderInfo(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::ChargeRecordDeleteStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetStationFinderStart"

void serializeJson (const ::tcu_main_fi::GetStationFinderStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ServiceType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ServiceType" , 13);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Service_Type_Name(value.getE8ServiceType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ServiceType());
    }
    if (!isSparse || value.hasSCurrentCountry()) {
        yajl_gen_string(g, (const unsigned char*)  "sCurrentCountry" , 15);
        const char *s = value.getSCurrentCountry().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasRSearch_GPS_Position()) {
        yajl_gen_string(g, (const unsigned char*)  "rSearch_GPS_Position" , 20);
        serializeJson(value.getRSearch_GPS_Position(), g, options);
    }
    if (!isSparse || value.hasE8ePOI_Type()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ePOI_Type" , 11);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_ePOI_Type_Name(value.getE8ePOI_Type());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ePOI_Type());
    }
    if (!isSparse || value.hasRSpot_Receptacle_Type()) {
        yajl_gen_string(g, (const unsigned char*)  "rSpot_Receptacle_Type" , 21);
        serializeJson(value.getRSpot_Receptacle_Type(), g, options);
    }
    if (!isSparse || value.hasU16Vehicle_Autonomy()) {
        yajl_gen_string(g, (const unsigned char*)  "u16Vehicle_Autonomy" , 19);
        yajl_gen_integer(g, (long long)value.getU16Vehicle_Autonomy());
    }
    if (!isSparse || value.hasU32BatteryIdentificationNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "u32BatteryIdentificationNumber" , 30);
        yajl_gen_integer(g, (long long)value.getU32BatteryIdentificationNumber());
    }
    if (!isSparse || value.hasRNavigation_Language()) {
        yajl_gen_string(g, (const unsigned char*)  "rNavigation_Language" , 20);
        serializeJson(value.getRNavigation_Language(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::GetStationFinderStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetStationFinderErrorStructure"

void serializeJson (const ::tcu_main_fi::GetStationFinderErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::GetStationFinderErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetStationFinderError"

void serializeJson (const ::tcu_main_fi::GetStationFinderError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_main_fi::GetStationFinderError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_main_fi::GetStationFinderError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_main_fi::GetStationFinderError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StationFinderStatusStatus"

void serializeJson (const ::tcu_main_fi::StationFinderStatusStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Invalid_Parameter()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Invalid_Parameter" , 19);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter_Name(value.getE8Invalid_Parameter());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Invalid_Parameter());
    }
    if (!isSparse || value.hasE8FinderStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "e8FinderStatus" , 14);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Finder_Status_Name(value.getE8FinderStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8FinderStatus());
    }
    if (!isSparse || value.hasU8Total_Station_Number()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Total_Station_Number" , 22);
        yajl_gen_integer(g, (long long)value.getU8Total_Station_Number());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::StationFinderStatusStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetChargeStationStart"

void serializeJson (const ::tcu_main_fi::GetChargeStationStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8Station_List_Number()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Station_List_Number" , 21);
        yajl_gen_integer(g, (long long)value.getU8Station_List_Number());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::GetChargeStationStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetChargeStationErrorStructure"

void serializeJson (const ::tcu_main_fi::GetChargeStationErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::GetChargeStationErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetChargeStationError"

void serializeJson (const ::tcu_main_fi::GetChargeStationError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_main_fi::GetChargeStationError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_main_fi::GetChargeStationError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_main_fi::GetChargeStationError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ChargeStationStatusStatus"

void serializeJson (const ::tcu_main_fi::ChargeStationStatusStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8Station_List_Number()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Station_List_Number" , 21);
        yajl_gen_integer(g, (long long)value.getU8Station_List_Number());
    }
    if (!isSparse || value.hasSCharge_Station_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "sCharge_Station_ID" , 18);
        const char *s = value.getSCharge_Station_ID().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasREPOI_GPS_Position()) {
        yajl_gen_string(g, (const unsigned char*)  "rEPOI_GPS_Position" , 18);
        serializeJson(value.getREPOI_GPS_Position(), g, options);
    }
    if (!isSparse || value.hasSEnergy_Provider_Name()) {
        yajl_gen_string(g, (const unsigned char*)  "sEnergy_Provider_Name" , 21);
        const char *s = value.getSEnergy_Provider_Name().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSUtility_Aggregator_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "sUtility_Aggregator_ID" , 22);
        const char *s = value.getSUtility_Aggregator_ID().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasRTime_Stamp()) {
        yajl_gen_string(g, (const unsigned char*)  "rTime_Stamp" , 11);
        serializeJson(value.getRTime_Stamp(), g, options);
    }
    if (!isSparse || value.hasSPhone_Number()) {
        yajl_gen_string(g, (const unsigned char*)  "sPhone_Number" , 13);
        const char *s = value.getSPhone_Number().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasROpening_Hour()) {
        yajl_gen_string(g, (const unsigned char*)  "rOpening_Hour" , 13);
        serializeJson(value.getROpening_Hour(), g, options);
    }
    if (!isSparse || value.hasE8Charge_Station_Accessibility()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Charge_Station_Accessibility" , 30);
        const char* s = ::tcu_main_fi_types::T_TCU_Charge_Station_Accessibility_Name(value.getE8Charge_Station_Accessibility());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Charge_Station_Accessibility());
    }
    if (!isSparse || value.hasE8Payment_Method_Type()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Payment_Method_Type" , 21);
        const char* s = ::tcu_main_fi_types::T_TCU_Payment_Method_Type_Name(value.getE8Payment_Method_Type());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Payment_Method_Type());
    }
    if (!isSparse || value.hasU8Spot_Total_Number()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Spot_Total_Number" , 19);
        yajl_gen_integer(g, (long long)value.getU8Spot_Total_Number());
    }
    if (!isSparse || value.hasU8Number_Available_Batteries()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Number_Available_Batteries" , 28);
        yajl_gen_integer(g, (long long)value.getU8Number_Available_Batteries());
    }
    if (!isSparse || value.hasRFull_Address()) {
        yajl_gen_string(g, (const unsigned char*)  "rFull_Address" , 13);
        serializeJson(value.getRFull_Address(), g, options);
    }
    if (!isSparse || value.hasU8Charge_Staion_Ranking()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Charge_Staion_Ranking" , 23);
        yajl_gen_integer(g, (long long)value.getU8Charge_Staion_Ranking());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::ChargeStationStatusStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetChargeSpotListStart"

void serializeJson (const ::tcu_main_fi::GetChargeSpotListStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8Station_List_Number()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Station_List_Number" , 21);
        yajl_gen_integer(g, (long long)value.getU8Station_List_Number());
    }
    if (!isSparse || value.hasU8Pages_Of_List()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Pages_Of_List" , 15);
        yajl_gen_integer(g, (long long)value.getU8Pages_Of_List());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::GetChargeSpotListStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetChargeSpotListErrorStructure"

void serializeJson (const ::tcu_main_fi::GetChargeSpotListErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::GetChargeSpotListErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetChargeSpotListError"

void serializeJson (const ::tcu_main_fi::GetChargeSpotListError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_main_fi::GetChargeSpotListError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_main_fi::GetChargeSpotListError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_main_fi::GetChargeSpotListError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetShortBookingStart"

void serializeJson (const ::tcu_main_fi::GetShortBookingStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSCharge_Station_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "sCharge_Station_ID" , 18);
        const char *s = value.getSCharge_Station_ID().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSCustomer_Contract_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "sCustomer_Contract_ID" , 21);
        const char *s = value.getSCustomer_Contract_ID().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasE8ePOI_Type()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ePOI_Type" , 11);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_ePOI_Type_Name(value.getE8ePOI_Type());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ePOI_Type());
    }
    if (!isSparse || value.hasE8Charge_Receptacle_Type()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Charge_Receptacle_Type" , 24);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Charge_Receptacle_Type_Name(value.getE8Charge_Receptacle_Type());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Charge_Receptacle_Type());
    }
    if (!isSparse || value.hasSUtility_Aggregator_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "sUtility_Aggregator_ID" , 22);
        const char *s = value.getSUtility_Aggregator_ID().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSCurrent_Country()) {
        yajl_gen_string(g, (const unsigned char*)  "sCurrent_Country" , 16);
        const char *s = value.getSCurrent_Country().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSCharge_Spot_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "sCharge_Spot_ID" , 15);
        const char *s = value.getSCharge_Spot_ID().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU32Battery_Identification_Number()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Battery_Identification_Number" , 32);
        yajl_gen_integer(g, (long long)value.getU32Battery_Identification_Number());
    }
    if (!isSparse || value.hasRService_Time_Request()) {
        yajl_gen_string(g, (const unsigned char*)  "rService_Time_Request" , 21);
        serializeJson(value.getRService_Time_Request(), g, options);
    }
    if (!isSparse || value.hasRNavigation_Language()) {
        yajl_gen_string(g, (const unsigned char*)  "rNavigation_Language" , 20);
        serializeJson(value.getRNavigation_Language(), g, options);
    }
    if (!isSparse || value.hasRTime_Stamp()) {
        yajl_gen_string(g, (const unsigned char*)  "rTime_Stamp" , 11);
        serializeJson(value.getRTime_Stamp(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::GetShortBookingStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetShortBookingErrorStructure"

void serializeJson (const ::tcu_main_fi::GetShortBookingErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::GetShortBookingErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetShortBookingError"

void serializeJson (const ::tcu_main_fi::GetShortBookingError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_main_fi::GetShortBookingError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_main_fi::GetShortBookingError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_main_fi::GetShortBookingError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Short_BookingStatusStatus"

void serializeJson (const ::tcu_main_fi::Short_BookingStatusStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8InvalidParameter()) {
        yajl_gen_string(g, (const unsigned char*)  "e8InvalidParameter" , 18);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter_Name(value.getE8InvalidParameter());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8InvalidParameter());
    }
    if (!isSparse || value.hasE8Booking_Status()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Booking_Status" , 16);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Booking_Status_Name(value.getE8Booking_Status());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Booking_Status());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::Short_BookingStatusStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Short_BookingIndicationStatus"

void serializeJson (const ::tcu_main_fi::Short_BookingIndicationStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Booking_Status()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Booking_Status" , 16);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Booking_Status_Name(value.getE8Booking_Status());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Booking_Status());
    }
    if (!isSparse || value.hasSCharge_Station_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "sCharge_Station_ID" , 18);
        const char *s = value.getSCharge_Station_ID().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSCharge_Spot_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "sCharge_Spot_ID" , 15);
        const char *s = value.getSCharge_Spot_ID().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasE8Charge_Receptacle_Type()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Charge_Receptacle_Type" , 24);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Charge_Receptacle_Type_Name(value.getE8Charge_Receptacle_Type());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Charge_Receptacle_Type());
    }
    if (!isSparse || value.hasE8Charge_Receptacle_Facility_Byte()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Charge_Receptacle_Facility_Byte" , 33);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Charge_Receptacle_Facility_Name(value.getE8Charge_Receptacle_Facility_Byte());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Charge_Receptacle_Facility_Byte());
    }
    if (!isSparse || value.hasRMax_Time_To_Arrive()) {
        yajl_gen_string(g, (const unsigned char*)  "rMax_Time_To_Arrive" , 19);
        serializeJson(value.getRMax_Time_To_Arrive(), g, options);
    }
    if (!isSparse || value.hasRMax_Time_To_Unbook()) {
        yajl_gen_string(g, (const unsigned char*)  "rMax_Time_To_Unbook" , 19);
        serializeJson(value.getRMax_Time_To_Unbook(), g, options);
    }
    if (!isSparse || value.hasSBooking_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "sBooking_ID" , 11);
        const char *s = value.getSBooking_ID().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasRBookable_Free_Text()) {
        yajl_gen_string(g, (const unsigned char*)  "rBookable_Free_Text" , 19);
        serializeJson(value.getRBookable_Free_Text(), g, options);
    }
    if (!isSparse || value.hasRTime_Stamp()) {
        yajl_gen_string(g, (const unsigned char*)  "rTime_Stamp" , 11);
        serializeJson(value.getRTime_Stamp(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::Short_BookingIndicationStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetShortUnbookingStart"

void serializeJson (const ::tcu_main_fi::GetShortUnbookingStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSCustomer_Contract_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "sCustomer_Contract_ID" , 21);
        const char *s = value.getSCustomer_Contract_ID().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSUtility_Aggregator_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "sUtility_Aggregator_ID" , 22);
        const char *s = value.getSUtility_Aggregator_ID().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSCurrent_Country()) {
        yajl_gen_string(g, (const unsigned char*)  "sCurrent_Country" , 16);
        const char *s = value.getSCurrent_Country().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSCharge_Spot_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "sCharge_Spot_ID" , 15);
        const char *s = value.getSCharge_Spot_ID().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSCharge_Station_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "sCharge_Station_ID" , 18);
        const char *s = value.getSCharge_Station_ID().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSBooking_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "sBooking_ID" , 11);
        const char *s = value.getSBooking_ID().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::GetShortUnbookingStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetShortUnbookingErrorStructure"

void serializeJson (const ::tcu_main_fi::GetShortUnbookingErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::GetShortUnbookingErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetShortUnbookingError"

void serializeJson (const ::tcu_main_fi::GetShortUnbookingError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_main_fi::GetShortUnbookingError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_main_fi::GetShortUnbookingError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_main_fi::GetShortUnbookingError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Short_UnbookingStatusStatus"

void serializeJson (const ::tcu_main_fi::Short_UnbookingStatusStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8InvalidParameter()) {
        yajl_gen_string(g, (const unsigned char*)  "e8InvalidParameter" , 18);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter_Name(value.getE8InvalidParameter());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8InvalidParameter());
    }
    if (!isSparse || value.hasE8Unbooking_Status()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Unbooking_Status" , 18);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Unbooking_Status_Name(value.getE8Unbooking_Status());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Unbooking_Status());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::Short_UnbookingStatusStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Short_UnbookingIndicationStatus"

void serializeJson (const ::tcu_main_fi::Short_UnbookingIndicationStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSCharge_Station_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "sCharge_Station_ID" , 18);
        const char *s = value.getSCharge_Station_ID().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSCharge_Spot_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "sCharge_Spot_ID" , 15);
        const char *s = value.getSCharge_Spot_ID().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSBooking_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "sBooking_ID" , 11);
        const char *s = value.getSBooking_ID().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasE8Unbooking_Status()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Unbooking_Status" , 18);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Unbooking_Status_Name(value.getE8Unbooking_Status());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Unbooking_Status());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::Short_UnbookingIndicationStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetUpdateEnergyPointStart"

void serializeJson (const ::tcu_main_fi::GetUpdateEnergyPointStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSCurrent_Country()) {
        yajl_gen_string(g, (const unsigned char*)  "sCurrent_Country" , 16);
        const char *s = value.getSCurrent_Country().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasREPOI_GPS_Position()) {
        yajl_gen_string(g, (const unsigned char*)  "rEPOI_GPS_Position" , 18);
        serializeJson(value.getREPOI_GPS_Position(), g, options);
    }
    if (!isSparse || value.hasSCharge_Station_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "sCharge_Station_ID" , 18);
        const char *s = value.getSCharge_Station_ID().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSUtility_Aggregator_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "sUtility_Aggregator_ID" , 22);
        const char *s = value.getSUtility_Aggregator_ID().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU32Battery_Identification_Number()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Battery_Identification_Number" , 32);
        yajl_gen_integer(g, (long long)value.getU32Battery_Identification_Number());
    }
    if (!isSparse || value.hasRNavigation_Language()) {
        yajl_gen_string(g, (const unsigned char*)  "rNavigation_Language" , 20);
        serializeJson(value.getRNavigation_Language(), g, options);
    }
    if (!isSparse || value.hasSBooking_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "sBooking_ID" , 11);
        const char *s = value.getSBooking_ID().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::GetUpdateEnergyPointStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetUpdateEnergyPointErrorStructure"

void serializeJson (const ::tcu_main_fi::GetUpdateEnergyPointErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::GetUpdateEnergyPointErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetUpdateEnergyPointError"

void serializeJson (const ::tcu_main_fi::GetUpdateEnergyPointError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_main_fi::GetUpdateEnergyPointError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_main_fi::GetUpdateEnergyPointError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_main_fi::GetUpdateEnergyPointError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UpdateEnergyPointStatusStatus"

void serializeJson (const ::tcu_main_fi::UpdateEnergyPointStatusStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Invalid_Parameter()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Invalid_Parameter" , 19);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter_Name(value.getE8Invalid_Parameter());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Invalid_Parameter());
    }
    if (!isSparse || value.hasE8Update_Status()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Update_Status" , 15);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Update_Status_Name(value.getE8Update_Status());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Update_Status());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::UpdateEnergyPointStatusStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UpdateEnergyPointIndicationStatus"

void serializeJson (const ::tcu_main_fi::UpdateEnergyPointIndicationStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Update_Status()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Update_Status" , 15);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Update_Status_Name(value.getE8Update_Status());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Update_Status());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::UpdateEnergyPointIndicationStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetSCH_ActivationStart"

void serializeJson (const ::tcu_main_fi::SetSCH_ActivationStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Sch_Activation_State()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Sch_Activation_State" , 22);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Sch_Activation_State_Name(value.getE8Sch_Activation_State());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Sch_Activation_State());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::SetSCH_ActivationStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetSCH_ActivationErrorStructure"

void serializeJson (const ::tcu_main_fi::SetSCH_ActivationErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::SetSCH_ActivationErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetSCH_ActivationError"

void serializeJson (const ::tcu_main_fi::SetSCH_ActivationError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_main_fi::SetSCH_ActivationError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_main_fi::SetSCH_ActivationError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_main_fi::SetSCH_ActivationError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SCH_ActivationStatusStatus"

void serializeJson (const ::tcu_main_fi::SCH_ActivationStatusStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Invalid_Parameter()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Invalid_Parameter" , 19);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter_Name(value.getE8Invalid_Parameter());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Invalid_Parameter());
    }
    if (!isSparse || value.hasE8Sch_Activation_State()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Sch_Activation_State" , 22);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Sch_Activation_State_Name(value.getE8Sch_Activation_State());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Sch_Activation_State());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::SCH_ActivationStatusStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetSCH_Update_ONBOARDStart"

void serializeJson (const ::tcu_main_fi::SetSCH_Update_ONBOARDStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRCharge_Day1_7_Start()) {
        yajl_gen_string(g, (const unsigned char*)  "rCharge_Day1_7_Start" , 20);
        serializeJson(value.getRCharge_Day1_7_Start(), g, options);
    }
    if (!isSparse || value.hasRCharge_Day1_7_End()) {
        yajl_gen_string(g, (const unsigned char*)  "rCharge_Day1_7_End" , 18);
        serializeJson(value.getRCharge_Day1_7_End(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::SetSCH_Update_ONBOARDStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetSCH_Update_ONBOARDErrorStructure"

void serializeJson (const ::tcu_main_fi::SetSCH_Update_ONBOARDErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::SetSCH_Update_ONBOARDErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetSCH_Update_ONBOARDError"

void serializeJson (const ::tcu_main_fi::SetSCH_Update_ONBOARDError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_main_fi::SetSCH_Update_ONBOARDError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_main_fi::SetSCH_Update_ONBOARDError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_main_fi::SetSCH_Update_ONBOARDError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SCH_Update_ONBOARDStatusStatus"

void serializeJson (const ::tcu_main_fi::SCH_Update_ONBOARDStatusStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Invalid_Parameter()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Invalid_Parameter" , 19);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter_Name(value.getE8Invalid_Parameter());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Invalid_Parameter());
    }
    if (!isSparse || value.hasRCharge_Day1_7_Start()) {
        yajl_gen_string(g, (const unsigned char*)  "rCharge_Day1_7_Start" , 20);
        serializeJson(value.getRCharge_Day1_7_Start(), g, options);
    }
    if (!isSparse || value.hasRCharge_Day1_7_End()) {
        yajl_gen_string(g, (const unsigned char*)  "rCharge_Day1_7_End" , 18);
        serializeJson(value.getRCharge_Day1_7_End(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::SCH_Update_ONBOARDStatusStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Charge_BlockedIndicationStatus"

void serializeJson (const ::tcu_main_fi::Charge_BlockedIndicationStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Charge_Blocked_Status()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Charge_Blocked_Status" , 23);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Charge_Blocked_Status_Name(value.getE8Charge_Blocked_Status());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Charge_Blocked_Status());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::Charge_BlockedIndicationStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetSCH_StateErrorStructure"

void serializeJson (const ::tcu_main_fi::GetSCH_StateErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::GetSCH_StateErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetSCH_StateError"

void serializeJson (const ::tcu_main_fi::GetSCH_StateError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_main_fi::GetSCH_StateError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_main_fi::GetSCH_StateError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_main_fi::GetSCH_StateError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SCH_StateStatusStatus"

void serializeJson (const ::tcu_main_fi::SCH_StateStatusStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Invalid_Parameter()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Invalid_Parameter" , 19);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter_Name(value.getE8Invalid_Parameter());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Invalid_Parameter());
    }
    if (!isSparse || value.hasE8Sch_Activation_State()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Sch_Activation_State" , 22);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Sch_Activation_State_Name(value.getE8Sch_Activation_State());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Sch_Activation_State());
    }
    if (!isSparse || value.hasRCharge_Day1_7_Start()) {
        yajl_gen_string(g, (const unsigned char*)  "rCharge_Day1_7_Start" , 20);
        serializeJson(value.getRCharge_Day1_7_Start(), g, options);
    }
    if (!isSparse || value.hasRCharge_Day1_7_End()) {
        yajl_gen_string(g, (const unsigned char*)  "rCharge_Day1_7_End" , 18);
        serializeJson(value.getRCharge_Day1_7_End(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::SCH_StateStatusStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SCH_StateIndicationStatus"

void serializeJson (const ::tcu_main_fi::SCH_StateIndicationStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Sch_Activation_State()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Sch_Activation_State" , 22);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Sch_Activation_State_Name(value.getE8Sch_Activation_State());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Sch_Activation_State());
    }
    if (!isSparse || value.hasRCharge_Day1_7_Start()) {
        yajl_gen_string(g, (const unsigned char*)  "rCharge_Day1_7_Start" , 20);
        serializeJson(value.getRCharge_Day1_7_Start(), g, options);
    }
    if (!isSparse || value.hasRCharge_Day1_7_End()) {
        yajl_gen_string(g, (const unsigned char*)  "rCharge_Day1_7_End" , 18);
        serializeJson(value.getRCharge_Day1_7_End(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::SCH_StateIndicationStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StationFinderIndicationStatus"

void serializeJson (const ::tcu_main_fi::StationFinderIndicationStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8FinderStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "e8FinderStatus" , 14);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Finder_Status_Name(value.getE8FinderStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8FinderStatus());
    }
    if (!isSparse || value.hasU8Total_Station_Number()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Total_Station_Number" , 22);
        yajl_gen_integer(g, (long long)value.getU8Total_Station_Number());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::StationFinderIndicationStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ChargeSpotListStatusStatus"

void serializeJson (const ::tcu_main_fi::ChargeSpotListStatusStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8InvalidParameter()) {
        yajl_gen_string(g, (const unsigned char*)  "e8InvalidParameter" , 18);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter_Name(value.getE8InvalidParameter());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8InvalidParameter());
    }
    if (!isSparse || value.hasRChargeSpotList()) {
        yajl_gen_string(g, (const unsigned char*)  "rChargeSpotList" , 15);
        serializeJson(value.getRChargeSpotList(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::ChargeSpotListStatusStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetWifiHotSpotRequestStart"

void serializeJson (const ::tcu_main_fi::SetWifiHotSpotRequestStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRWifi_SSID_Name()) {
        yajl_gen_string(g, (const unsigned char*)  "rWifi_SSID_Name" , 15);
        serializeJson(value.getRWifi_SSID_Name(), g, options);
    }
    if (!isSparse || value.hasRWifi_PassKey()) {
        yajl_gen_string(g, (const unsigned char*)  "rWifi_PassKey" , 13);
        serializeJson(value.getRWifi_PassKey(), g, options);
    }
    if (!isSparse || value.hasE8Wifi_Security_Mode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Wifi_Security_Mode" , 20);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Wifi_Security_Mode_Name(value.getE8Wifi_Security_Mode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Wifi_Security_Mode());
    }
    if (!isSparse || value.hasU8Wifi_Channel_Number()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Wifi_Channel_Number" , 21);
        yajl_gen_integer(g, (long long)value.getU8Wifi_Channel_Number());
    }
    if (!isSparse || value.hasE8Wifi_Visibility()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Wifi_Visibility" , 17);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Wifi_Visibility_Name(value.getE8Wifi_Visibility());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Wifi_Visibility());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::SetWifiHotSpotRequestStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetWifiHotSpotRequestErrorStructure"

void serializeJson (const ::tcu_main_fi::SetWifiHotSpotRequestErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::SetWifiHotSpotRequestErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetWifiHotSpotRequestError"

void serializeJson (const ::tcu_main_fi::SetWifiHotSpotRequestError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_main_fi::SetWifiHotSpotRequestError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_main_fi::SetWifiHotSpotRequestError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_main_fi::SetWifiHotSpotRequestError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "WifiHotSpotRequestIndicationStatus"

void serializeJson (const ::tcu_main_fi::WifiHotSpotRequestIndicationStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRWifi_SSID_Name()) {
        yajl_gen_string(g, (const unsigned char*)  "rWifi_SSID_Name" , 15);
        serializeJson(value.getRWifi_SSID_Name(), g, options);
    }
    if (!isSparse || value.hasRWifi_PassKey()) {
        yajl_gen_string(g, (const unsigned char*)  "rWifi_PassKey" , 13);
        serializeJson(value.getRWifi_PassKey(), g, options);
    }
    if (!isSparse || value.hasE8Wifi_Security_Mode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Wifi_Security_Mode" , 20);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Wifi_Security_Mode_Name(value.getE8Wifi_Security_Mode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Wifi_Security_Mode());
    }
    if (!isSparse || value.hasU8Wifi_Channel_Number()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Wifi_Channel_Number" , 21);
        yajl_gen_integer(g, (long long)value.getU8Wifi_Channel_Number());
    }
    if (!isSparse || value.hasE8Wifi_Visibility()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Wifi_Visibility" , 17);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Wifi_Visibility_Name(value.getE8Wifi_Visibility());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Wifi_Visibility());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::WifiHotSpotRequestIndicationStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "WifiHotSpotRequestStatus"

void serializeJson (const ::tcu_main_fi::WifiHotSpotRequestStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Invalid_Parameter()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Invalid_Parameter" , 19);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter_Name(value.getE8Invalid_Parameter());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Invalid_Parameter());
    }
    if (!isSparse || value.hasRWifi_SSID_Name()) {
        yajl_gen_string(g, (const unsigned char*)  "rWifi_SSID_Name" , 15);
        serializeJson(value.getRWifi_SSID_Name(), g, options);
    }
    if (!isSparse || value.hasRWifi_PassKey()) {
        yajl_gen_string(g, (const unsigned char*)  "rWifi_PassKey" , 13);
        serializeJson(value.getRWifi_PassKey(), g, options);
    }
    if (!isSparse || value.hasE8Wifi_Security_Mode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Wifi_Security_Mode" , 20);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Wifi_Security_Mode_Name(value.getE8Wifi_Security_Mode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Wifi_Security_Mode());
    }
    if (!isSparse || value.hasU8Wifi_Channel_Number()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Wifi_Channel_Number" , 21);
        yajl_gen_integer(g, (long long)value.getU8Wifi_Channel_Number());
    }
    if (!isSparse || value.hasE8Wifi_Visibility()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Wifi_Visibility" , 17);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Wifi_Visibility_Name(value.getE8Wifi_Visibility());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Wifi_Visibility());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::WifiHotSpotRequestStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetWifiActivationRequestStart"

void serializeJson (const ::tcu_main_fi::SetWifiActivationRequestStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Wifi_Status()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Wifi_Status" , 13);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Wifi_Status_Name(value.getE8Wifi_Status());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Wifi_Status());
    }
    if (!isSparse || value.hasE8Wifi_Mode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Wifi_Mode" , 11);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Wifi_Mode_Name(value.getE8Wifi_Mode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Wifi_Mode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::SetWifiActivationRequestStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetWifiActivationRequestErrorStructure"

void serializeJson (const ::tcu_main_fi::SetWifiActivationRequestErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::SetWifiActivationRequestErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetWifiActivationRequestError"

void serializeJson (const ::tcu_main_fi::SetWifiActivationRequestError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_main_fi::SetWifiActivationRequestError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_main_fi::SetWifiActivationRequestError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_main_fi::SetWifiActivationRequestError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "WifiActivationRequestStatus"

void serializeJson (const ::tcu_main_fi::WifiActivationRequestStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Invalid_Parameter()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Invalid_Parameter" , 19);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter_Name(value.getE8Invalid_Parameter());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Invalid_Parameter());
    }
    if (!isSparse || value.hasE8Wifi_Status()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Wifi_Status" , 13);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Wifi_Status_Name(value.getE8Wifi_Status());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Wifi_Status());
    }
    if (!isSparse || value.hasE8Wifi_Mode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Wifi_Mode" , 11);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Wifi_Mode_Name(value.getE8Wifi_Mode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Wifi_Mode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::WifiActivationRequestStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetWifiDataResetErrorStructure"

void serializeJson (const ::tcu_main_fi::SetWifiDataResetErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::SetWifiDataResetErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetWifiDataResetError"

void serializeJson (const ::tcu_main_fi::SetWifiDataResetError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_main_fi::SetWifiDataResetError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_main_fi::SetWifiDataResetError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_main_fi::SetWifiDataResetError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "WifiDataResetStatus"

void serializeJson (const ::tcu_main_fi::WifiDataResetStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRWifi_SSID_Name()) {
        yajl_gen_string(g, (const unsigned char*)  "rWifi_SSID_Name" , 15);
        serializeJson(value.getRWifi_SSID_Name(), g, options);
    }
    if (!isSparse || value.hasRWifi_PassKey()) {
        yajl_gen_string(g, (const unsigned char*)  "rWifi_PassKey" , 13);
        serializeJson(value.getRWifi_PassKey(), g, options);
    }
    if (!isSparse || value.hasE8Wifi_Security_Mode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Wifi_Security_Mode" , 20);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Wifi_Security_Mode_Name(value.getE8Wifi_Security_Mode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Wifi_Security_Mode());
    }
    if (!isSparse || value.hasU8Wifi_Channel_Number()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Wifi_Channel_Number" , 21);
        yajl_gen_integer(g, (long long)value.getU8Wifi_Channel_Number());
    }
    if (!isSparse || value.hasE8Wifi_Visibility()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Wifi_Visibility" , 17);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Wifi_Visibility_Name(value.getE8Wifi_Visibility());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Wifi_Visibility());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::WifiDataResetStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetWifiClientScanErrorStructure"

void serializeJson (const ::tcu_main_fi::SetWifiClientScanErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::SetWifiClientScanErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetWifiClientScanError"

void serializeJson (const ::tcu_main_fi::SetWifiClientScanError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_main_fi::SetWifiClientScanError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_main_fi::SetWifiClientScanError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_main_fi::SetWifiClientScanError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetWifiClientConnectionStart"

void serializeJson (const ::tcu_main_fi::SetWifiClientConnectionStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRWifi_Scan_SSID_Name()) {
        yajl_gen_string(g, (const unsigned char*)  "rWifi_Scan_SSID_Name" , 20);
        serializeJson(value.getRWifi_Scan_SSID_Name(), g, options);
    }
    if (!isSparse || value.hasRWifi_PassKey()) {
        yajl_gen_string(g, (const unsigned char*)  "rWifi_PassKey" , 13);
        serializeJson(value.getRWifi_PassKey(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::SetWifiClientConnectionStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetWifiClientConnectionErrorStructure"

void serializeJson (const ::tcu_main_fi::SetWifiClientConnectionErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::SetWifiClientConnectionErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetWifiClientConnectionError"

void serializeJson (const ::tcu_main_fi::SetWifiClientConnectionError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_main_fi::SetWifiClientConnectionError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_main_fi::SetWifiClientConnectionError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_main_fi::SetWifiClientConnectionError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "WifiClientConnectionStatus"

void serializeJson (const ::tcu_main_fi::WifiClientConnectionStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Invalid_Parameter()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Invalid_Parameter" , 19);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter_Name(value.getE8Invalid_Parameter());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Invalid_Parameter());
    }
    if (!isSparse || value.hasRWifi_Scan_SSID_Name()) {
        yajl_gen_string(g, (const unsigned char*)  "rWifi_Scan_SSID_Name" , 20);
        serializeJson(value.getRWifi_Scan_SSID_Name(), g, options);
    }
    if (!isSparse || value.hasE8Wifi_Connection_Status()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Wifi_Connection_Status" , 24);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Wifi_Connection_Status_Name(value.getE8Wifi_Connection_Status());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Wifi_Connection_Status());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::WifiClientConnectionStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "WifiClientConnectionIndicationStatus"

void serializeJson (const ::tcu_main_fi::WifiClientConnectionIndicationStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRWifi_Scan_SSID_Name()) {
        yajl_gen_string(g, (const unsigned char*)  "rWifi_Scan_SSID_Name" , 20);
        serializeJson(value.getRWifi_Scan_SSID_Name(), g, options);
    }
    if (!isSparse || value.hasE8Wifi_Connection_Status()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Wifi_Connection_Status" , 24);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Wifi_Connection_Status_Name(value.getE8Wifi_Connection_Status());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Wifi_Connection_Status());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::WifiClientConnectionIndicationStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetWifiClientDisconnectionErrorStructure"

void serializeJson (const ::tcu_main_fi::SetWifiClientDisconnectionErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::SetWifiClientDisconnectionErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetWifiClientDisconnectionError"

void serializeJson (const ::tcu_main_fi::SetWifiClientDisconnectionError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_main_fi::SetWifiClientDisconnectionError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_main_fi::SetWifiClientDisconnectionError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_main_fi::SetWifiClientDisconnectionError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "WifiClientScanResultIndicationStatus"

void serializeJson (const ::tcu_main_fi::WifiClientScanResultIndicationStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRWifi_Scan_SSID_Name()) {
        yajl_gen_string(g, (const unsigned char*)  "rWifi_Scan_SSID_Name" , 20);
        serializeJson(value.getRWifi_Scan_SSID_Name(), g, options);
    }
    if (!isSparse || value.hasU8Wifi_Scan_Power()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Wifi_Scan_Power" , 17);
        yajl_gen_integer(g, (long long)value.getU8Wifi_Scan_Power());
    }
    if (!isSparse || value.hasE8Wifi_Scan_Security()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Wifi_Scan_Security" , 20);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Wifi_Wifi_Scan_Security_Name(value.getE8Wifi_Scan_Security());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Wifi_Scan_Security());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::WifiClientScanResultIndicationStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetWifiConnectedDevicesRequestErrorStructure"

void serializeJson (const ::tcu_main_fi::GetWifiConnectedDevicesRequestErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::GetWifiConnectedDevicesRequestErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetWifiConnectedDevicesRequestError"

void serializeJson (const ::tcu_main_fi::GetWifiConnectedDevicesRequestError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_main_fi::GetWifiConnectedDevicesRequestError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_main_fi::GetWifiConnectedDevicesRequestError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_main_fi::GetWifiConnectedDevicesRequestError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "WifiConnectedDevicesRequestStatus"

void serializeJson (const ::tcu_main_fi::WifiConnectedDevicesRequestStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8Wifi_Connected_Devices()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Wifi_Connected_Devices" , 24);
        yajl_gen_integer(g, (long long)value.getU8Wifi_Connected_Devices());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::WifiConnectedDevicesRequestStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetWifiClientStateErrorStructure"

void serializeJson (const ::tcu_main_fi::GetWifiClientStateErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::GetWifiClientStateErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetWifiClientStateError"

void serializeJson (const ::tcu_main_fi::GetWifiClientStateError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_main_fi::GetWifiClientStateError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_main_fi::GetWifiClientStateError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_main_fi::GetWifiClientStateError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "WifiClientStateStatus"

void serializeJson (const ::tcu_main_fi::WifiClientStateStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Wifi_Client_Status()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Wifi_Client_Status" , 20);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Wifi_Wifi_Client_Status_Name(value.getE8Wifi_Client_Status());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Wifi_Client_Status());
    }
    if (!isSparse || value.hasRWifi_SSID()) {
        yajl_gen_string(g, (const unsigned char*)  "rWifi_SSID" , 10);
        serializeJson(value.getRWifi_SSID(), g, options);
    }
    if (!isSparse || value.hasU8Wifi_Client_Power()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Wifi_Client_Power" , 19);
        yajl_gen_integer(g, (long long)value.getU8Wifi_Client_Power());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::WifiClientStateStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "WifiClientStateIndicationStatus"

void serializeJson (const ::tcu_main_fi::WifiClientStateIndicationStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Wifi_Client_Status()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Wifi_Client_Status" , 20);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Wifi_Wifi_Client_Status_Name(value.getE8Wifi_Client_Status());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Wifi_Client_Status());
    }
    if (!isSparse || value.hasRWifi_SSID()) {
        yajl_gen_string(g, (const unsigned char*)  "rWifi_SSID" , 10);
        serializeJson(value.getRWifi_SSID(), g, options);
    }
    if (!isSparse || value.hasU8Wifi_Client_Power()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Wifi_Client_Power" , 19);
        yajl_gen_integer(g, (long long)value.getU8Wifi_Client_Power());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::WifiClientStateIndicationStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DTMEcallStart"

void serializeJson (const ::tcu_main_fi::DTMEcallStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8SourceActivity()) {
        yajl_gen_string(g, (const unsigned char*)  "e8SourceActivity" , 16);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Audio_SourceActivity_Name(value.getE8SourceActivity());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8SourceActivity());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::DTMEcallStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DTMEcallErrorStructure"

void serializeJson (const ::tcu_main_fi::DTMEcallErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::DTMEcallErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DTMEcallError"

void serializeJson (const ::tcu_main_fi::DTMEcallError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_main_fi::DTMEcallError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_main_fi::DTMEcallError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_main_fi::DTMEcallError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "HardwareVersionStatus"

void serializeJson (const ::tcu_main_fi::HardwareVersionStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRHardwareVersion()) {
        yajl_gen_string(g, (const unsigned char*)  "rHardwareVersion" , 16);
        serializeJson(value.getRHardwareVersion(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::HardwareVersionStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SoftwareVersionStatus"

void serializeJson (const ::tcu_main_fi::SoftwareVersionStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRSoftwareVersion()) {
        yajl_gen_string(g, (const unsigned char*)  "rSoftwareVersion" , 16);
        serializeJson(value.getRSoftwareVersion(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::SoftwareVersionStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Push_POIStatus"

void serializeJson (const ::tcu_main_fi::Push_POIStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBValid()) {
        yajl_gen_string(g, (const unsigned char*)  "bValid" , 6);
        yajl_gen_bool(g, (bool)value.getBValid());
    }
    if (!isSparse || value.hasU32POI_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "u32POI_ID" , 9);
        yajl_gen_integer(g, (long long)value.getU32POI_ID());
    }
    if (!isSparse || value.hasRPOI_GPS_Position()) {
        yajl_gen_string(g, (const unsigned char*)  "rPOI_GPS_Position" , 17);
        serializeJson(value.getRPOI_GPS_Position(), g, options);
    }
    if (!isSparse || value.hasSPOI_Name()) {
        yajl_gen_string(g, (const unsigned char*)  "sPOI_Name" , 9);
        const char *s = value.getSPOI_Name().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::Push_POIStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetPush_POIStatusStart"

void serializeJson (const ::tcu_main_fi::SetPush_POIStatusStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8InvalidParmeter()) {
        yajl_gen_string(g, (const unsigned char*)  "e8InvalidParmeter" , 17);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_InvalidParameter_Name(value.getE8InvalidParmeter());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8InvalidParmeter());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::SetPush_POIStatusStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Time_LimitStatus"

void serializeJson (const ::tcu_main_fi::Time_LimitStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBValid()) {
        yajl_gen_string(g, (const unsigned char*)  "bValid" , 6);
        yajl_gen_bool(g, (bool)value.getBValid());
    }
    if (!isSparse || value.hasRTime_Slot()) {
        yajl_gen_string(g, (const unsigned char*)  "rTime_Slot" , 10);
        serializeJson(value.getRTime_Slot(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::Time_LimitStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Speed_LimitStatus"

void serializeJson (const ::tcu_main_fi::Speed_LimitStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBValid()) {
        yajl_gen_string(g, (const unsigned char*)  "bValid" , 6);
        yajl_gen_bool(g, (bool)value.getBValid());
    }
    if (!isSparse || value.hasU16Limited_Vehicle_Speed()) {
        yajl_gen_string(g, (const unsigned char*)  "u16Limited_Vehicle_Speed" , 24);
        yajl_gen_integer(g, (long long)value.getU16Limited_Vehicle_Speed());
    }
    if (!isSparse || value.hasRTime_Slot()) {
        yajl_gen_string(g, (const unsigned char*)  "rTime_Slot" , 10);
        serializeJson(value.getRTime_Slot(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::Speed_LimitStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Area_LimitStatus"

void serializeJson (const ::tcu_main_fi::Area_LimitStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBValid()) {
        yajl_gen_string(g, (const unsigned char*)  "bValid" , 6);
        yajl_gen_bool(g, (bool)value.getBValid());
    }
    if (!isSparse || value.hasRArea_Limit_Coordinates()) {
        yajl_gen_string(g, (const unsigned char*)  "rArea_Limit_Coordinates" , 23);
        serializeJson(value.getRArea_Limit_Coordinates(), g, options);
    }
    if (!isSparse || value.hasRTime_Slot()) {
        yajl_gen_string(g, (const unsigned char*)  "rTime_Slot" , 10);
        serializeJson(value.getRTime_Slot(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::Area_LimitStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Geofencing_ActivationStatus"

void serializeJson (const ::tcu_main_fi::Geofencing_ActivationStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBValid()) {
        yajl_gen_string(g, (const unsigned char*)  "bValid" , 6);
        yajl_gen_bool(g, (bool)value.getBValid());
    }
    if (!isSparse || value.hasU8Geofencing_Activation_State()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Geofencing_Activation_State" , 29);
        yajl_gen_integer(g, (long long)value.getU8Geofencing_Activation_State());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::Geofencing_ActivationStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetGeofencing_ActivationStatusStart"

void serializeJson (const ::tcu_main_fi::SetGeofencing_ActivationStatusStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8InvalidParmeter()) {
        yajl_gen_string(g, (const unsigned char*)  "e8InvalidParmeter" , 17);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_InvalidParameter_Name(value.getE8InvalidParmeter());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8InvalidParmeter());
    }
    if (!isSparse || value.hasU8Geofencing_Activation_State()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Geofencing_Activation_State" , 29);
        yajl_gen_integer(g, (long long)value.getU8Geofencing_Activation_State());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::SetGeofencing_ActivationStatusStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetRestriction_SettingsErrorStructure"

void serializeJson (const ::tcu_main_fi::GetRestriction_SettingsErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::GetRestriction_SettingsErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetRestriction_SettingsError"

void serializeJson (const ::tcu_main_fi::GetRestriction_SettingsError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_main_fi::GetRestriction_SettingsError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_main_fi::GetRestriction_SettingsError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_main_fi::GetRestriction_SettingsError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Restriction_SettingsStatus"

void serializeJson (const ::tcu_main_fi::Restriction_SettingsStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBValid()) {
        yajl_gen_string(g, (const unsigned char*)  "bValid" , 6);
        yajl_gen_bool(g, (bool)value.getBValid());
    }
    if (!isSparse || value.hasRTime_Limit_Restriction()) {
        yajl_gen_string(g, (const unsigned char*)  "rTime_Limit_Restriction" , 23);
        yajl_gen_array_open(g);
        const ::std::vector< ::tcu_main_fi_types::T_TCU_Time_Slot >& o3 = value.getRTime_Limit_Restriction();
        {
            ::std::vector< ::tcu_main_fi_types::T_TCU_Time_Slot >::const_iterator o2;
            for (o2 = o3.begin(); o2 != o3.end(); ++o2) {
                serializeJson((*o2), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasRSpeed_Limit_Restriction()) {
        yajl_gen_string(g, (const unsigned char*)  "rSpeed_Limit_Restriction" , 24);
        serializeJson(value.getRSpeed_Limit_Restriction(), g, options);
    }
    if (!isSparse || value.hasRArea_Limit_Restriction()) {
        yajl_gen_string(g, (const unsigned char*)  "rArea_Limit_Restriction" , 23);
        serializeJson(value.getRArea_Limit_Restriction(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::Restriction_SettingsStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Connection_Setup_StatusStatus"

void serializeJson (const ::tcu_main_fi::Connection_Setup_StatusStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ConnectionType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ConnectionType" , 16);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_ConnectionType_Name(value.getE8ConnectionType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ConnectionType());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::Connection_Setup_StatusStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "XCallStartStart"

void serializeJson (const ::tcu_main_fi::XCallStartStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8XCallType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8XCallType" , 11);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_XCALL_Type_Name(value.getE8XCallType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8XCallType());
    }
    if (!isSparse || value.hasE8XCallLanguage()) {
        yajl_gen_string(g, (const unsigned char*)  "e8XCallLanguage" , 15);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_XCALL_Language_Name(value.getE8XCallLanguage());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8XCallLanguage());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::XCallStartStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "XCallStartErrorStructure"

void serializeJson (const ::tcu_main_fi::XCallStartErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasError()) {
        yajl_gen_string(g, (const unsigned char*)  "Error" , 5);
        yajl_gen_integer(g, (long long)value.getError());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::XCallStartErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "XCallStartError"

void serializeJson (const ::tcu_main_fi::XCallStartError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::tcu_main_fi::XCallStartError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::tcu_main_fi::XCallStartError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::tcu_main_fi::XCallStartError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "XCallStatusStatus"

void serializeJson (const ::tcu_main_fi::XCallStatusStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8InvalidParameter()) {
        yajl_gen_string(g, (const unsigned char*)  "e8InvalidParameter" , 18);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter_Name(value.getE8InvalidParameter());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8InvalidParameter());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::XCallStatusStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "XCallStateStatus"

void serializeJson (const ::tcu_main_fi::XCallStateStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8XCallState()) {
        yajl_gen_string(g, (const unsigned char*)  "e8XCallState" , 12);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_ServiceState_Name(value.getE8XCallState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8XCallState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::XCallStateStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CallDuartionStatus"

void serializeJson (const ::tcu_main_fi::CallDuartionStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBIsValid()) {
        yajl_gen_string(g, (const unsigned char*)  "bIsValid" , 8);
        yajl_gen_bool(g, (bool)value.getBIsValid());
    }
    if (!isSparse || value.hasRCallType()) {
        yajl_gen_string(g, (const unsigned char*)  "rCallType" , 9);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_CallType_Name(value.getRCallType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getRCallType());
    }
    if (!isSparse || value.hasRCallDuartion()) {
        yajl_gen_string(g, (const unsigned char*)  "rCallDuartion" , 13);
        serializeJson(value.getRCallDuartion(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::CallDuartionStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PrivacyModeActivationStatus"

void serializeJson (const ::tcu_main_fi::PrivacyModeActivationStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBIsValid()) {
        yajl_gen_string(g, (const unsigned char*)  "bIsValid" , 8);
        yajl_gen_bool(g, (bool)value.getBIsValid());
    }
    if (!isSparse || value.hasE8InvalidParameter()) {
        yajl_gen_string(g, (const unsigned char*)  "e8InvalidParameter" , 18);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Invalid_Parameter_Name(value.getE8InvalidParameter());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8InvalidParameter());
    }
    if (!isSparse || value.hasE8PrivacyMode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8PrivacyMode" , 13);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_PrivacyModes_Name(value.getE8PrivacyMode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8PrivacyMode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::PrivacyModeActivationStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetPrivicyModeStart"

void serializeJson (const ::tcu_main_fi::SetPrivicyModeStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8PrivacyMode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8PrivacyMode" , 13);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_PrivacyModes_Name(value.getE8PrivacyMode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8PrivacyMode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::SetPrivicyModeStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetTCUConfigurationStatusResult"

void serializeJson (const ::tcu_main_fi::GetTCUConfigurationStatusResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRTCU_CurrentAvailabilityConfiguration()) {
        yajl_gen_string(g, (const unsigned char*)  "rTCU_CurrentAvailabilityConfiguration" , 37);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Availability_Name(value.getRTCU_CurrentAvailabilityConfiguration());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getRTCU_CurrentAvailabilityConfiguration());
    }
    if (!isSparse || value.hasBAutoConfigured()) {
        yajl_gen_string(g, (const unsigned char*)  "bAutoConfigured" , 15);
        yajl_gen_bool(g, (bool)value.getBAutoConfigured());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::GetTCUConfigurationStatusResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TCUConfigurationStatusStatus"

void serializeJson (const ::tcu_main_fi::TCUConfigurationStatusStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRTCU_CurrentAvailabilityConfiguration()) {
        yajl_gen_string(g, (const unsigned char*)  "rTCU_CurrentAvailabilityConfiguration" , 37);
        const char* s = ::tcu_main_fi_types::T_e8_TCU_Availability_Name(value.getRTCU_CurrentAvailabilityConfiguration());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getRTCU_CurrentAvailabilityConfiguration());
    }
    if (!isSparse || value.hasBAutoConfigured()) {
        yajl_gen_string(g, (const unsigned char*)  "bAutoConfigured" , 15);
        yajl_gen_bool(g, (bool)value.getBAutoConfigured());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::tcu_main_fi::TCUConfigurationStatusStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::ConnectionStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::ConfigurationStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::DataTransmissionStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::ECallRequestStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::ECallServiceStateStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::AcceptECallRequestStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::ACNRequestStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::ACNServiceStateStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::CurfewAlertStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::GeoFenceStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SpeedAlertStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::GetTCUStateErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::GetTCUStateError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::TCUStateStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::GetIDInfoStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::GetIDInfoErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::GetIDInfoError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::IDInfoStatusStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetDriverInfoUploadPermitStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetDriverInfoUploadPermitErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetDriverInfoUploadPermitError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::DriverInfoUploadPermitStatusStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SMSNotificationStatusStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::GetProbeUploadPermitErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::GetProbeUploadPermitError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetProbeUploadPermitStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetProbeUploadPermitErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetProbeUploadPermitError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::ProbeUploadPermitStatusStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetProbeInfoDeleteErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetProbeInfoDeleteError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::ProbeInfoDeleteStatusStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::ServiceCallStateStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::ServiceCallRequestStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetServiceCallOperationStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetServiceCallOperationErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetServiceCallOperationError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::TcuCallServiceStateStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetNaviInfoStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetNaviInfoErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetNaviInfoError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetTripScoreInfoStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetTripScoreInfoErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetTripScoreInfoError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetProbeVehicleInfoStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetProbeVehicleInfoErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetProbeVehicleInfoError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::MaintenanceInfoStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::MaintenanceInfoErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::MaintenanceInfoError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::ProvisionServiceStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::COMEcallStateStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::COMEcallStartStatusErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::COMEcallStartStatusError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetTCUResetErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetTCUResetError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::TCUResetStatusStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::EmergencyStateStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::TCUResponseTimeOutStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::GetTCUExtendedStateErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::GetTCUExtendedStateError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::TCUExtendedStateStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetPINSettingStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetPINSettingErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetPINSettingError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::PINSettingStatusStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::GetChargeReminderErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::GetChargeReminderError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetChargeReminderStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetChargeReminderErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetChargeReminderError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::ChargeReminderStatusStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::ChargeRecordDeleteStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::GetStationFinderStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::GetStationFinderErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::GetStationFinderError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::StationFinderStatusStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::GetChargeStationStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::GetChargeStationErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::GetChargeStationError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::ChargeStationStatusStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::GetChargeSpotListStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::GetChargeSpotListErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::GetChargeSpotListError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::GetShortBookingStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::GetShortBookingErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::GetShortBookingError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::Short_BookingStatusStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::Short_BookingIndicationStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::GetShortUnbookingStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::GetShortUnbookingErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::GetShortUnbookingError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::Short_UnbookingStatusStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::Short_UnbookingIndicationStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::GetUpdateEnergyPointStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::GetUpdateEnergyPointErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::GetUpdateEnergyPointError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::UpdateEnergyPointStatusStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::UpdateEnergyPointIndicationStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetSCH_ActivationStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetSCH_ActivationErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetSCH_ActivationError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SCH_ActivationStatusStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetSCH_Update_ONBOARDStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetSCH_Update_ONBOARDErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetSCH_Update_ONBOARDError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SCH_Update_ONBOARDStatusStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::Charge_BlockedIndicationStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::GetSCH_StateErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::GetSCH_StateError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SCH_StateStatusStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SCH_StateIndicationStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::StationFinderIndicationStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::ChargeSpotListStatusStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetWifiHotSpotRequestStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetWifiHotSpotRequestErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetWifiHotSpotRequestError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::WifiHotSpotRequestIndicationStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::WifiHotSpotRequestStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetWifiActivationRequestStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetWifiActivationRequestErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetWifiActivationRequestError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::WifiActivationRequestStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetWifiDataResetErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetWifiDataResetError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::WifiDataResetStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetWifiClientScanErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetWifiClientScanError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetWifiClientConnectionStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetWifiClientConnectionErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetWifiClientConnectionError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::WifiClientConnectionStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::WifiClientConnectionIndicationStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetWifiClientDisconnectionErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetWifiClientDisconnectionError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::WifiClientScanResultIndicationStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::GetWifiConnectedDevicesRequestErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::GetWifiConnectedDevicesRequestError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::WifiConnectedDevicesRequestStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::GetWifiClientStateErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::GetWifiClientStateError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::WifiClientStateStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::WifiClientStateIndicationStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::DTMEcallStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::DTMEcallErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::DTMEcallError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::HardwareVersionStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SoftwareVersionStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::Push_POIStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetPush_POIStatusStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::Time_LimitStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::Speed_LimitStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::Area_LimitStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::Geofencing_ActivationStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetGeofencing_ActivationStatusStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::GetRestriction_SettingsErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::GetRestriction_SettingsError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::Restriction_SettingsStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::Connection_Setup_StatusStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::XCallStartStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::XCallStartErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::XCallStartError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::XCallStatusStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::XCallStateStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::CallDuartionStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::PrivacyModeActivationStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::SetPrivicyModeStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::GetTCUConfigurationStatusResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi
using namespace ::asf::stream::json;

namespace tcu_main_fi {

std::ostream& operator<<(std::ostream& o, const ::tcu_main_fi::TCUConfigurationStatusStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace tcu_main_fi

