/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_FREEDESKTOP_SYSTEMD1_UNITSTUB_H
#define ORG_FREEDESKTOP_SYSTEMD1_UNITSTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "org/freedesktop/systemd1/Unit.h"
#include <string>
#include <vector>

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

class UnitStubDelegate;

class UnitStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the UnitStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    UnitStub (const std::string& portName);

    /**
     * Create an instance of the UnitStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    UnitStub (const std::string& portName, const std::string& objectPath);

    virtual ~UnitStub();

    // property 'Id'

    /**
     * The method onIdGet() is called by ASF when a client invokes the read
     * method for the property 'Id'. The onIdGet() method returns by default
     * the current property value to the caller. In case this default behavior
     * doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'Id'</b>:
     *
     * Id contains the primary name of the unit
     */
    virtual void onIdGet(const ::boost::shared_ptr< IdGet >& payload);

    /**
     * Sends back the update to a previous onIdGet().
     *
     * <b>Documentation of 'Id'</b>:
     *
     * Id contains the primary name of the unit
     *
     * @param act Identifies a previous invocation of onIdGet(). If the act is
     * not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendIdGetUpdate(const ::std::string& id, act_t act = 0);

    /**
     * Set the value of the property 'Id' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Id'</b>:
     *
     * Id contains the primary name of the unit
     */
    void setId(const ::std::string& id);

    /**
     * Returns the current value of the property 'Id'.
     *
     * <b>Documentation of 'Id'</b>:
     *
     * Id contains the primary name of the unit
     */
    const ::std::string& getId() const;

    /**
     * Returns the current value of the property 'Id' as a mutable reference.
     * If you change the content of the returned object you have to send
     * updates to registered clients by yourself with the help of the
     * sendIdUpdate() method.
     *
     * <b>Documentation of 'Id'</b>:
     *
     * Id contains the primary name of the unit
     */
    ::std::string& getIdMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendIdUpdate().
     *
     * <b>Documentation of 'Id'</b>:
     *
     * Id contains the primary name of the unit
     */
    void sendIdUpdate();

    // property 'Names'

    /**
     * The method onNamesGet() is called by ASF when a client invokes the read
     * method for the property 'Names'. The onNamesGet() method returns by
     * default the current property value to the caller. In case this default
     * behavior doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'Names'</b>:
     *
     * Names contains all names of the unit, including the primary name that is also exposed in Id.
     */
    virtual void onNamesGet(const ::boost::shared_ptr< NamesGet >& payload);

    /**
     * Sends back the update to a previous onNamesGet().
     *
     * <b>Documentation of 'Names'</b>:
     *
     * Names contains all names of the unit, including the primary name that is also exposed in Id.
     *
     * @param act Identifies a previous invocation of onNamesGet(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendNamesGetUpdate(const ::std::vector< ::std::string >& names, act_t act = 0);

    /**
     * Set the value of the property 'Names' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Names'</b>:
     *
     * Names contains all names of the unit, including the primary name that is also exposed in Id.
     */
    void setNames(const ::std::vector< ::std::string >& names);

    /**
     * Returns the current value of the property 'Names'.
     *
     * <b>Documentation of 'Names'</b>:
     *
     * Names contains all names of the unit, including the primary name that is also exposed in Id.
     */
    const ::std::vector< ::std::string >& getNames() const;

    /**
     * Returns the current value of the property 'Names' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendNamesUpdate() method.
     *
     * <b>Documentation of 'Names'</b>:
     *
     * Names contains all names of the unit, including the primary name that is also exposed in Id.
     */
    ::std::vector< ::std::string >& getNamesMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendNamesUpdate().
     *
     * <b>Documentation of 'Names'</b>:
     *
     * Names contains all names of the unit, including the primary name that is also exposed in Id.
     */
    void sendNamesUpdate();

    // property 'Following'

    /**
     * The method onFollowingGet() is called by ASF when a client invokes the
     * read method for the property 'Following'. The onFollowingGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Following'</b>:
     *
     * Following either contains the empty string or contains the name of another unit that this
     * 		unit follows in state. This is used for some device units which reflect the unit state machine of another
     * 		unit, and which other unit this is might possibly change.
     */
    virtual void onFollowingGet(const ::boost::shared_ptr< FollowingGet >& payload);

    /**
     * Sends back the update to a previous onFollowingGet().
     *
     * <b>Documentation of 'Following'</b>:
     *
     * Following either contains the empty string or contains the name of another unit that this
     * 		unit follows in state. This is used for some device units which reflect the unit state machine of another
     * 		unit, and which other unit this is might possibly change.
     *
     * @param act Identifies a previous invocation of onFollowingGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendFollowingGetUpdate(const ::std::string& following, act_t act = 0);

    /**
     * Set the value of the property 'Following' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'Following'</b>:
     *
     * Following either contains the empty string or contains the name of another unit that this
     * 		unit follows in state. This is used for some device units which reflect the unit state machine of another
     * 		unit, and which other unit this is might possibly change.
     */
    void setFollowing(const ::std::string& following);

    /**
     * Returns the current value of the property 'Following'.
     *
     * <b>Documentation of 'Following'</b>:
     *
     * Following either contains the empty string or contains the name of another unit that this
     * 		unit follows in state. This is used for some device units which reflect the unit state machine of another
     * 		unit, and which other unit this is might possibly change.
     */
    const ::std::string& getFollowing() const;

    /**
     * Returns the current value of the property 'Following' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendFollowingUpdate() method.
     *
     * <b>Documentation of 'Following'</b>:
     *
     * Following either contains the empty string or contains the name of another unit that this
     * 		unit follows in state. This is used for some device units which reflect the unit state machine of another
     * 		unit, and which other unit this is might possibly change.
     */
    ::std::string& getFollowingMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendFollowingUpdate().
     *
     * <b>Documentation of 'Following'</b>:
     *
     * Following either contains the empty string or contains the name of another unit that this
     * 		unit follows in state. This is used for some device units which reflect the unit state machine of another
     * 		unit, and which other unit this is might possibly change.
     */
    void sendFollowingUpdate();

    // property 'Requires'

    /**
     * The method onRequiresGet() is called by ASF when a client invokes the
     * read method for the property 'Requires'. The onRequiresGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Requires'</b>:
     *
     * Requires contain arrays which encode the dependencies and their inverse dependencies
     * 		(where this applies), as configured in the unit file or determined automatically.
     */
    virtual void onRequiresGet(const ::boost::shared_ptr< RequiresGet >& payload);

    /**
     * Sends back the update to a previous onRequiresGet().
     *
     * <b>Documentation of 'Requires'</b>:
     *
     * Requires contain arrays which encode the dependencies and their inverse dependencies
     * 		(where this applies), as configured in the unit file or determined automatically.
     *
     * @param act Identifies a previous invocation of onRequiresGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendRequiresGetUpdate(const ::std::vector< ::std::string >& requires, act_t act = 0);

    /**
     * Set the value of the property 'Requires' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Requires'</b>:
     *
     * Requires contain arrays which encode the dependencies and their inverse dependencies
     * 		(where this applies), as configured in the unit file or determined automatically.
     */
    void setRequires(const ::std::vector< ::std::string >& requires);

    /**
     * Returns the current value of the property 'Requires'.
     *
     * <b>Documentation of 'Requires'</b>:
     *
     * Requires contain arrays which encode the dependencies and their inverse dependencies
     * 		(where this applies), as configured in the unit file or determined automatically.
     */
    const ::std::vector< ::std::string >& getRequires() const;

    /**
     * Returns the current value of the property 'Requires' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendRequiresUpdate() method.
     *
     * <b>Documentation of 'Requires'</b>:
     *
     * Requires contain arrays which encode the dependencies and their inverse dependencies
     * 		(where this applies), as configured in the unit file or determined automatically.
     */
    ::std::vector< ::std::string >& getRequiresMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendRequiresUpdate().
     *
     * <b>Documentation of 'Requires'</b>:
     *
     * Requires contain arrays which encode the dependencies and their inverse dependencies
     * 		(where this applies), as configured in the unit file or determined automatically.
     */
    void sendRequiresUpdate();

    // property 'RequiresOverridable'

    /**
     * The method onRequiresOverridableGet() is called by ASF when a client
     * invokes the read method for the property 'RequiresOverridable'. The
     * onRequiresOverridableGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'RequiresOverridable'</b>:
     *
     * RequiresOverridable
     */
    virtual void onRequiresOverridableGet(const ::boost::shared_ptr< RequiresOverridableGet >& payload);

    /**
     * Sends back the update to a previous onRequiresOverridableGet().
     *
     * <b>Documentation of 'RequiresOverridable'</b>:
     *
     * RequiresOverridable
     *
     * @param act Identifies a previous invocation of
     * onRequiresOverridableGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRequiresOverridableGetUpdate(const ::std::vector< ::std::string >& requiresOverridable, act_t act = 0);

    /**
     * Set the value of the property 'RequiresOverridable' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'RequiresOverridable'</b>:
     *
     * RequiresOverridable
     */
    void setRequiresOverridable(const ::std::vector< ::std::string >& requiresOverridable);

    /**
     * Returns the current value of the property 'RequiresOverridable'.
     *
     * <b>Documentation of 'RequiresOverridable'</b>:
     *
     * RequiresOverridable
     */
    const ::std::vector< ::std::string >& getRequiresOverridable() const;

    /**
     * Returns the current value of the property 'RequiresOverridable' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendRequiresOverridableUpdate() method.
     *
     * <b>Documentation of 'RequiresOverridable'</b>:
     *
     * RequiresOverridable
     */
    ::std::vector< ::std::string >& getRequiresOverridableMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendRequiresOverridableUpdate().
     *
     * <b>Documentation of 'RequiresOverridable'</b>:
     *
     * RequiresOverridable
     */
    void sendRequiresOverridableUpdate();

    // property 'Requisite'

    /**
     * The method onRequisiteGet() is called by ASF when a client invokes the
     * read method for the property 'Requisite'. The onRequisiteGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Requisite'</b>:
     *
     * Requisite
     */
    virtual void onRequisiteGet(const ::boost::shared_ptr< RequisiteGet >& payload);

    /**
     * Sends back the update to a previous onRequisiteGet().
     *
     * <b>Documentation of 'Requisite'</b>:
     *
     * Requisite
     *
     * @param act Identifies a previous invocation of onRequisiteGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendRequisiteGetUpdate(const ::std::vector< ::std::string >& requisite, act_t act = 0);

    /**
     * Set the value of the property 'Requisite' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'Requisite'</b>:
     *
     * Requisite
     */
    void setRequisite(const ::std::vector< ::std::string >& requisite);

    /**
     * Returns the current value of the property 'Requisite'.
     *
     * <b>Documentation of 'Requisite'</b>:
     *
     * Requisite
     */
    const ::std::vector< ::std::string >& getRequisite() const;

    /**
     * Returns the current value of the property 'Requisite' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendRequisiteUpdate() method.
     *
     * <b>Documentation of 'Requisite'</b>:
     *
     * Requisite
     */
    ::std::vector< ::std::string >& getRequisiteMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendRequisiteUpdate().
     *
     * <b>Documentation of 'Requisite'</b>:
     *
     * Requisite
     */
    void sendRequisiteUpdate();

    // property 'RequisiteOverridable'

    /**
     * The method onRequisiteOverridableGet() is called by ASF when a client
     * invokes the read method for the property 'RequisiteOverridable'. The
     * onRequisiteOverridableGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'RequisiteOverridable'</b>:
     *
     * RequisiteOverridable
     */
    virtual void onRequisiteOverridableGet(const ::boost::shared_ptr< RequisiteOverridableGet >& payload);

    /**
     * Sends back the update to a previous onRequisiteOverridableGet().
     *
     * <b>Documentation of 'RequisiteOverridable'</b>:
     *
     * RequisiteOverridable
     *
     * @param act Identifies a previous invocation of
     * onRequisiteOverridableGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRequisiteOverridableGetUpdate(const ::std::vector< ::std::string >& requisiteOverridable, act_t act = 0);

    /**
     * Set the value of the property 'RequisiteOverridable' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'RequisiteOverridable'</b>:
     *
     * RequisiteOverridable
     */
    void setRequisiteOverridable(const ::std::vector< ::std::string >& requisiteOverridable);

    /**
     * Returns the current value of the property 'RequisiteOverridable'.
     *
     * <b>Documentation of 'RequisiteOverridable'</b>:
     *
     * RequisiteOverridable
     */
    const ::std::vector< ::std::string >& getRequisiteOverridable() const;

    /**
     * Returns the current value of the property 'RequisiteOverridable' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendRequisiteOverridableUpdate() method.
     *
     * <b>Documentation of 'RequisiteOverridable'</b>:
     *
     * RequisiteOverridable
     */
    ::std::vector< ::std::string >& getRequisiteOverridableMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendRequisiteOverridableUpdate().
     *
     * <b>Documentation of 'RequisiteOverridable'</b>:
     *
     * RequisiteOverridable
     */
    void sendRequisiteOverridableUpdate();

    // property 'Wants'

    /**
     * The method onWantsGet() is called by ASF when a client invokes the read
     * method for the property 'Wants'. The onWantsGet() method returns by
     * default the current property value to the caller. In case this default
     * behavior doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'Wants'</b>:
     *
     * Wants
     */
    virtual void onWantsGet(const ::boost::shared_ptr< WantsGet >& payload);

    /**
     * Sends back the update to a previous onWantsGet().
     *
     * <b>Documentation of 'Wants'</b>:
     *
     * Wants
     *
     * @param act Identifies a previous invocation of onWantsGet(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendWantsGetUpdate(const ::std::vector< ::std::string >& wants, act_t act = 0);

    /**
     * Set the value of the property 'Wants' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Wants'</b>:
     *
     * Wants
     */
    void setWants(const ::std::vector< ::std::string >& wants);

    /**
     * Returns the current value of the property 'Wants'.
     *
     * <b>Documentation of 'Wants'</b>:
     *
     * Wants
     */
    const ::std::vector< ::std::string >& getWants() const;

    /**
     * Returns the current value of the property 'Wants' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendWantsUpdate() method.
     *
     * <b>Documentation of 'Wants'</b>:
     *
     * Wants
     */
    ::std::vector< ::std::string >& getWantsMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendWantsUpdate().
     *
     * <b>Documentation of 'Wants'</b>:
     *
     * Wants
     */
    void sendWantsUpdate();

    // property 'BindsTo'

    /**
     * The method onBindsToGet() is called by ASF when a client invokes the
     * read method for the property 'BindsTo'. The onBindsToGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'BindsTo'</b>:
     *
     * BindsTo
     */
    virtual void onBindsToGet(const ::boost::shared_ptr< BindsToGet >& payload);

    /**
     * Sends back the update to a previous onBindsToGet().
     *
     * <b>Documentation of 'BindsTo'</b>:
     *
     * BindsTo
     *
     * @param act Identifies a previous invocation of onBindsToGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendBindsToGetUpdate(const ::std::vector< ::std::string >& bindsTo, act_t act = 0);

    /**
     * Set the value of the property 'BindsTo' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'BindsTo'</b>:
     *
     * BindsTo
     */
    void setBindsTo(const ::std::vector< ::std::string >& bindsTo);

    /**
     * Returns the current value of the property 'BindsTo'.
     *
     * <b>Documentation of 'BindsTo'</b>:
     *
     * BindsTo
     */
    const ::std::vector< ::std::string >& getBindsTo() const;

    /**
     * Returns the current value of the property 'BindsTo' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendBindsToUpdate() method.
     *
     * <b>Documentation of 'BindsTo'</b>:
     *
     * BindsTo
     */
    ::std::vector< ::std::string >& getBindsToMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendBindsToUpdate().
     *
     * <b>Documentation of 'BindsTo'</b>:
     *
     * BindsTo
     */
    void sendBindsToUpdate();

    // property 'PartOf'

    /**
     * The method onPartOfGet() is called by ASF when a client invokes the
     * read method for the property 'PartOf'. The onPartOfGet() method returns
     * by default the current property value to the caller. In case this
     * default behavior doesn't match your needs feel free to override this
     * method.
     *
     * <b>Documentation of 'PartOf'</b>:
     *
     * PartOf
     */
    virtual void onPartOfGet(const ::boost::shared_ptr< PartOfGet >& payload);

    /**
     * Sends back the update to a previous onPartOfGet().
     *
     * <b>Documentation of 'PartOf'</b>:
     *
     * PartOf
     *
     * @param act Identifies a previous invocation of onPartOfGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendPartOfGetUpdate(const ::std::vector< ::std::string >& partOf, act_t act = 0);

    /**
     * Set the value of the property 'PartOf' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'PartOf'</b>:
     *
     * PartOf
     */
    void setPartOf(const ::std::vector< ::std::string >& partOf);

    /**
     * Returns the current value of the property 'PartOf'.
     *
     * <b>Documentation of 'PartOf'</b>:
     *
     * PartOf
     */
    const ::std::vector< ::std::string >& getPartOf() const;

    /**
     * Returns the current value of the property 'PartOf' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendPartOfUpdate() method.
     *
     * <b>Documentation of 'PartOf'</b>:
     *
     * PartOf
     */
    ::std::vector< ::std::string >& getPartOfMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendPartOfUpdate().
     *
     * <b>Documentation of 'PartOf'</b>:
     *
     * PartOf
     */
    void sendPartOfUpdate();

    // property 'RequiredBy'

    /**
     * The method onRequiredByGet() is called by ASF when a client invokes the
     * read method for the property 'RequiredBy'. The onRequiredByGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'RequiredBy'</b>:
     *
     * RequiredBy
     */
    virtual void onRequiredByGet(const ::boost::shared_ptr< RequiredByGet >& payload);

    /**
     * Sends back the update to a previous onRequiredByGet().
     *
     * <b>Documentation of 'RequiredBy'</b>:
     *
     * RequiredBy
     *
     * @param act Identifies a previous invocation of onRequiredByGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendRequiredByGetUpdate(const ::std::vector< ::std::string >& requiredBy, act_t act = 0);

    /**
     * Set the value of the property 'RequiredBy' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'RequiredBy'</b>:
     *
     * RequiredBy
     */
    void setRequiredBy(const ::std::vector< ::std::string >& requiredBy);

    /**
     * Returns the current value of the property 'RequiredBy'.
     *
     * <b>Documentation of 'RequiredBy'</b>:
     *
     * RequiredBy
     */
    const ::std::vector< ::std::string >& getRequiredBy() const;

    /**
     * Returns the current value of the property 'RequiredBy' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendRequiredByUpdate() method.
     *
     * <b>Documentation of 'RequiredBy'</b>:
     *
     * RequiredBy
     */
    ::std::vector< ::std::string >& getRequiredByMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendRequiredByUpdate().
     *
     * <b>Documentation of 'RequiredBy'</b>:
     *
     * RequiredBy
     */
    void sendRequiredByUpdate();

    // property 'RequiredByOverridable'

    /**
     * The method onRequiredByOverridableGet() is called by ASF when a client
     * invokes the read method for the property 'RequiredByOverridable'. The
     * onRequiredByOverridableGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'RequiredByOverridable'</b>:
     *
     * RequiredByOverridable
     */
    virtual void onRequiredByOverridableGet(const ::boost::shared_ptr< RequiredByOverridableGet >& payload);

    /**
     * Sends back the update to a previous onRequiredByOverridableGet().
     *
     * <b>Documentation of 'RequiredByOverridable'</b>:
     *
     * RequiredByOverridable
     *
     * @param act Identifies a previous invocation of
     * onRequiredByOverridableGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRequiredByOverridableGetUpdate(const ::std::vector< ::std::string >& requiredByOverridable, act_t act = 0);

    /**
     * Set the value of the property 'RequiredByOverridable' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'RequiredByOverridable'</b>:
     *
     * RequiredByOverridable
     */
    void setRequiredByOverridable(const ::std::vector< ::std::string >& requiredByOverridable);

    /**
     * Returns the current value of the property 'RequiredByOverridable'.
     *
     * <b>Documentation of 'RequiredByOverridable'</b>:
     *
     * RequiredByOverridable
     */
    const ::std::vector< ::std::string >& getRequiredByOverridable() const;

    /**
     * Returns the current value of the property 'RequiredByOverridable' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendRequiredByOverridableUpdate() method.
     *
     * <b>Documentation of 'RequiredByOverridable'</b>:
     *
     * RequiredByOverridable
     */
    ::std::vector< ::std::string >& getRequiredByOverridableMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendRequiredByOverridableUpdate().
     *
     * <b>Documentation of 'RequiredByOverridable'</b>:
     *
     * RequiredByOverridable
     */
    void sendRequiredByOverridableUpdate();

    // property 'RequisiteOf'

    /**
     * The method onRequisiteOfGet() is called by ASF when a client invokes
     * the read method for the property 'RequisiteOf'. The onRequisiteOfGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'RequisiteOf'</b>:
     *
     * RequisiteOf
     */
    virtual void onRequisiteOfGet(const ::boost::shared_ptr< RequisiteOfGet >& payload);

    /**
     * Sends back the update to a previous onRequisiteOfGet().
     *
     * <b>Documentation of 'RequisiteOf'</b>:
     *
     * RequisiteOf
     *
     * @param act Identifies a previous invocation of onRequisiteOfGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendRequisiteOfGetUpdate(const ::std::vector< ::std::string >& requisiteOf, act_t act = 0);

    /**
     * Set the value of the property 'RequisiteOf' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'RequisiteOf'</b>:
     *
     * RequisiteOf
     */
    void setRequisiteOf(const ::std::vector< ::std::string >& requisiteOf);

    /**
     * Returns the current value of the property 'RequisiteOf'.
     *
     * <b>Documentation of 'RequisiteOf'</b>:
     *
     * RequisiteOf
     */
    const ::std::vector< ::std::string >& getRequisiteOf() const;

    /**
     * Returns the current value of the property 'RequisiteOf' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendRequisiteOfUpdate() method.
     *
     * <b>Documentation of 'RequisiteOf'</b>:
     *
     * RequisiteOf
     */
    ::std::vector< ::std::string >& getRequisiteOfMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendRequisiteOfUpdate().
     *
     * <b>Documentation of 'RequisiteOf'</b>:
     *
     * RequisiteOf
     */
    void sendRequisiteOfUpdate();

    // property 'RequisiteOfOverridable'

    /**
     * The method onRequisiteOfOverridableGet() is called by ASF when a client
     * invokes the read method for the property 'RequisiteOfOverridable'. The
     * onRequisiteOfOverridableGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'RequisiteOfOverridable'</b>:
     *
     * RequisiteOfOverridable
     */
    virtual void onRequisiteOfOverridableGet(const ::boost::shared_ptr< RequisiteOfOverridableGet >& payload);

    /**
     * Sends back the update to a previous onRequisiteOfOverridableGet().
     *
     * <b>Documentation of 'RequisiteOfOverridable'</b>:
     *
     * RequisiteOfOverridable
     *
     * @param act Identifies a previous invocation of
     * onRequisiteOfOverridableGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRequisiteOfOverridableGetUpdate(const ::std::vector< ::std::string >& requisiteOfOverridable, act_t act = 0);

    /**
     * Set the value of the property 'RequisiteOfOverridable' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'RequisiteOfOverridable'</b>:
     *
     * RequisiteOfOverridable
     */
    void setRequisiteOfOverridable(const ::std::vector< ::std::string >& requisiteOfOverridable);

    /**
     * Returns the current value of the property 'RequisiteOfOverridable'.
     *
     * <b>Documentation of 'RequisiteOfOverridable'</b>:
     *
     * RequisiteOfOverridable
     */
    const ::std::vector< ::std::string >& getRequisiteOfOverridable() const;

    /**
     * Returns the current value of the property 'RequisiteOfOverridable' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendRequisiteOfOverridableUpdate() method.
     *
     * <b>Documentation of 'RequisiteOfOverridable'</b>:
     *
     * RequisiteOfOverridable
     */
    ::std::vector< ::std::string >& getRequisiteOfOverridableMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendRequisiteOfOverridableUpdate().
     *
     * <b>Documentation of 'RequisiteOfOverridable'</b>:
     *
     * RequisiteOfOverridable
     */
    void sendRequisiteOfOverridableUpdate();

    // property 'WantedBy'

    /**
     * The method onWantedByGet() is called by ASF when a client invokes the
     * read method for the property 'WantedBy'. The onWantedByGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'WantedBy'</b>:
     *
     * WantedBy
     */
    virtual void onWantedByGet(const ::boost::shared_ptr< WantedByGet >& payload);

    /**
     * Sends back the update to a previous onWantedByGet().
     *
     * <b>Documentation of 'WantedBy'</b>:
     *
     * WantedBy
     *
     * @param act Identifies a previous invocation of onWantedByGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendWantedByGetUpdate(const ::std::vector< ::std::string >& wantedBy, act_t act = 0);

    /**
     * Set the value of the property 'WantedBy' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'WantedBy'</b>:
     *
     * WantedBy
     */
    void setWantedBy(const ::std::vector< ::std::string >& wantedBy);

    /**
     * Returns the current value of the property 'WantedBy'.
     *
     * <b>Documentation of 'WantedBy'</b>:
     *
     * WantedBy
     */
    const ::std::vector< ::std::string >& getWantedBy() const;

    /**
     * Returns the current value of the property 'WantedBy' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendWantedByUpdate() method.
     *
     * <b>Documentation of 'WantedBy'</b>:
     *
     * WantedBy
     */
    ::std::vector< ::std::string >& getWantedByMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendWantedByUpdate().
     *
     * <b>Documentation of 'WantedBy'</b>:
     *
     * WantedBy
     */
    void sendWantedByUpdate();

    // property 'BoundBy'

    /**
     * The method onBoundByGet() is called by ASF when a client invokes the
     * read method for the property 'BoundBy'. The onBoundByGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'BoundBy'</b>:
     *
     * BoundBy
     */
    virtual void onBoundByGet(const ::boost::shared_ptr< BoundByGet >& payload);

    /**
     * Sends back the update to a previous onBoundByGet().
     *
     * <b>Documentation of 'BoundBy'</b>:
     *
     * BoundBy
     *
     * @param act Identifies a previous invocation of onBoundByGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendBoundByGetUpdate(const ::std::vector< ::std::string >& boundBy, act_t act = 0);

    /**
     * Set the value of the property 'BoundBy' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'BoundBy'</b>:
     *
     * BoundBy
     */
    void setBoundBy(const ::std::vector< ::std::string >& boundBy);

    /**
     * Returns the current value of the property 'BoundBy'.
     *
     * <b>Documentation of 'BoundBy'</b>:
     *
     * BoundBy
     */
    const ::std::vector< ::std::string >& getBoundBy() const;

    /**
     * Returns the current value of the property 'BoundBy' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendBoundByUpdate() method.
     *
     * <b>Documentation of 'BoundBy'</b>:
     *
     * BoundBy
     */
    ::std::vector< ::std::string >& getBoundByMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendBoundByUpdate().
     *
     * <b>Documentation of 'BoundBy'</b>:
     *
     * BoundBy
     */
    void sendBoundByUpdate();

    // property 'ConsistsOf'

    /**
     * The method onConsistsOfGet() is called by ASF when a client invokes the
     * read method for the property 'ConsistsOf'. The onConsistsOfGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'ConsistsOf'</b>:
     *
     * ConsistsOf
     */
    virtual void onConsistsOfGet(const ::boost::shared_ptr< ConsistsOfGet >& payload);

    /**
     * Sends back the update to a previous onConsistsOfGet().
     *
     * <b>Documentation of 'ConsistsOf'</b>:
     *
     * ConsistsOf
     *
     * @param act Identifies a previous invocation of onConsistsOfGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendConsistsOfGetUpdate(const ::std::vector< ::std::string >& consistsOf, act_t act = 0);

    /**
     * Set the value of the property 'ConsistsOf' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'ConsistsOf'</b>:
     *
     * ConsistsOf
     */
    void setConsistsOf(const ::std::vector< ::std::string >& consistsOf);

    /**
     * Returns the current value of the property 'ConsistsOf'.
     *
     * <b>Documentation of 'ConsistsOf'</b>:
     *
     * ConsistsOf
     */
    const ::std::vector< ::std::string >& getConsistsOf() const;

    /**
     * Returns the current value of the property 'ConsistsOf' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendConsistsOfUpdate() method.
     *
     * <b>Documentation of 'ConsistsOf'</b>:
     *
     * ConsistsOf
     */
    ::std::vector< ::std::string >& getConsistsOfMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendConsistsOfUpdate().
     *
     * <b>Documentation of 'ConsistsOf'</b>:
     *
     * ConsistsOf
     */
    void sendConsistsOfUpdate();

    // property 'Conflicts'

    /**
     * The method onConflictsGet() is called by ASF when a client invokes the
     * read method for the property 'Conflicts'. The onConflictsGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Conflicts'</b>:
     *
     * Conflicts
     */
    virtual void onConflictsGet(const ::boost::shared_ptr< ConflictsGet >& payload);

    /**
     * Sends back the update to a previous onConflictsGet().
     *
     * <b>Documentation of 'Conflicts'</b>:
     *
     * Conflicts
     *
     * @param act Identifies a previous invocation of onConflictsGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendConflictsGetUpdate(const ::std::vector< ::std::string >& conflicts, act_t act = 0);

    /**
     * Set the value of the property 'Conflicts' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'Conflicts'</b>:
     *
     * Conflicts
     */
    void setConflicts(const ::std::vector< ::std::string >& conflicts);

    /**
     * Returns the current value of the property 'Conflicts'.
     *
     * <b>Documentation of 'Conflicts'</b>:
     *
     * Conflicts
     */
    const ::std::vector< ::std::string >& getConflicts() const;

    /**
     * Returns the current value of the property 'Conflicts' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendConflictsUpdate() method.
     *
     * <b>Documentation of 'Conflicts'</b>:
     *
     * Conflicts
     */
    ::std::vector< ::std::string >& getConflictsMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendConflictsUpdate().
     *
     * <b>Documentation of 'Conflicts'</b>:
     *
     * Conflicts
     */
    void sendConflictsUpdate();

    // property 'ConflictedBy'

    /**
     * The method onConflictedByGet() is called by ASF when a client invokes
     * the read method for the property 'ConflictedBy'. The
     * onConflictedByGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'ConflictedBy'</b>:
     *
     * ConflictedBy
     */
    virtual void onConflictedByGet(const ::boost::shared_ptr< ConflictedByGet >& payload);

    /**
     * Sends back the update to a previous onConflictedByGet().
     *
     * <b>Documentation of 'ConflictedBy'</b>:
     *
     * ConflictedBy
     *
     * @param act Identifies a previous invocation of onConflictedByGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendConflictedByGetUpdate(const ::std::vector< ::std::string >& conflictedBy, act_t act = 0);

    /**
     * Set the value of the property 'ConflictedBy' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'ConflictedBy'</b>:
     *
     * ConflictedBy
     */
    void setConflictedBy(const ::std::vector< ::std::string >& conflictedBy);

    /**
     * Returns the current value of the property 'ConflictedBy'.
     *
     * <b>Documentation of 'ConflictedBy'</b>:
     *
     * ConflictedBy
     */
    const ::std::vector< ::std::string >& getConflictedBy() const;

    /**
     * Returns the current value of the property 'ConflictedBy' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendConflictedByUpdate() method.
     *
     * <b>Documentation of 'ConflictedBy'</b>:
     *
     * ConflictedBy
     */
    ::std::vector< ::std::string >& getConflictedByMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendConflictedByUpdate().
     *
     * <b>Documentation of 'ConflictedBy'</b>:
     *
     * ConflictedBy
     */
    void sendConflictedByUpdate();

    // property 'Before'

    /**
     * The method onBeforeGet() is called by ASF when a client invokes the
     * read method for the property 'Before'. The onBeforeGet() method returns
     * by default the current property value to the caller. In case this
     * default behavior doesn't match your needs feel free to override this
     * method.
     *
     * <b>Documentation of 'Before'</b>:
     *
     * Before
     */
    virtual void onBeforeGet(const ::boost::shared_ptr< BeforeGet >& payload);

    /**
     * Sends back the update to a previous onBeforeGet().
     *
     * <b>Documentation of 'Before'</b>:
     *
     * Before
     *
     * @param act Identifies a previous invocation of onBeforeGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendBeforeGetUpdate(const ::std::vector< ::std::string >& before, act_t act = 0);

    /**
     * Set the value of the property 'Before' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Before'</b>:
     *
     * Before
     */
    void setBefore(const ::std::vector< ::std::string >& before);

    /**
     * Returns the current value of the property 'Before'.
     *
     * <b>Documentation of 'Before'</b>:
     *
     * Before
     */
    const ::std::vector< ::std::string >& getBefore() const;

    /**
     * Returns the current value of the property 'Before' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendBeforeUpdate() method.
     *
     * <b>Documentation of 'Before'</b>:
     *
     * Before
     */
    ::std::vector< ::std::string >& getBeforeMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendBeforeUpdate().
     *
     * <b>Documentation of 'Before'</b>:
     *
     * Before
     */
    void sendBeforeUpdate();

    // property 'After'

    /**
     * The method onAfterGet() is called by ASF when a client invokes the read
     * method for the property 'After'. The onAfterGet() method returns by
     * default the current property value to the caller. In case this default
     * behavior doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'After'</b>:
     *
     * After
     */
    virtual void onAfterGet(const ::boost::shared_ptr< AfterGet >& payload);

    /**
     * Sends back the update to a previous onAfterGet().
     *
     * <b>Documentation of 'After'</b>:
     *
     * After
     *
     * @param act Identifies a previous invocation of onAfterGet(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendAfterGetUpdate(const ::std::vector< ::std::string >& after, act_t act = 0);

    /**
     * Set the value of the property 'After' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'After'</b>:
     *
     * After
     */
    void setAfter(const ::std::vector< ::std::string >& after);

    /**
     * Returns the current value of the property 'After'.
     *
     * <b>Documentation of 'After'</b>:
     *
     * After
     */
    const ::std::vector< ::std::string >& getAfter() const;

    /**
     * Returns the current value of the property 'After' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendAfterUpdate() method.
     *
     * <b>Documentation of 'After'</b>:
     *
     * After
     */
    ::std::vector< ::std::string >& getAfterMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendAfterUpdate().
     *
     * <b>Documentation of 'After'</b>:
     *
     * After
     */
    void sendAfterUpdate();

    // property 'OnFailure'

    /**
     * The method onOnFailureGet() is called by ASF when a client invokes the
     * read method for the property 'OnFailure'. The onOnFailureGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'OnFailure'</b>:
     *
     * OnFailure
     */
    virtual void onOnFailureGet(const ::boost::shared_ptr< OnFailureGet >& payload);

    /**
     * Sends back the update to a previous onOnFailureGet().
     *
     * <b>Documentation of 'OnFailure'</b>:
     *
     * OnFailure
     *
     * @param act Identifies a previous invocation of onOnFailureGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendOnFailureGetUpdate(const ::std::vector< ::std::string >& onFailure, act_t act = 0);

    /**
     * Set the value of the property 'OnFailure' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'OnFailure'</b>:
     *
     * OnFailure
     */
    void setOnFailure(const ::std::vector< ::std::string >& onFailure);

    /**
     * Returns the current value of the property 'OnFailure'.
     *
     * <b>Documentation of 'OnFailure'</b>:
     *
     * OnFailure
     */
    const ::std::vector< ::std::string >& getOnFailure() const;

    /**
     * Returns the current value of the property 'OnFailure' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendOnFailureUpdate() method.
     *
     * <b>Documentation of 'OnFailure'</b>:
     *
     * OnFailure
     */
    ::std::vector< ::std::string >& getOnFailureMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendOnFailureUpdate().
     *
     * <b>Documentation of 'OnFailure'</b>:
     *
     * OnFailure
     */
    void sendOnFailureUpdate();

    // property 'Triggers'

    /**
     * The method onTriggersGet() is called by ASF when a client invokes the
     * read method for the property 'Triggers'. The onTriggersGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Triggers'</b>:
     *
     * Triggers
     */
    virtual void onTriggersGet(const ::boost::shared_ptr< TriggersGet >& payload);

    /**
     * Sends back the update to a previous onTriggersGet().
     *
     * <b>Documentation of 'Triggers'</b>:
     *
     * Triggers
     *
     * @param act Identifies a previous invocation of onTriggersGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendTriggersGetUpdate(const ::std::vector< ::std::string >& triggers, act_t act = 0);

    /**
     * Set the value of the property 'Triggers' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Triggers'</b>:
     *
     * Triggers
     */
    void setTriggers(const ::std::vector< ::std::string >& triggers);

    /**
     * Returns the current value of the property 'Triggers'.
     *
     * <b>Documentation of 'Triggers'</b>:
     *
     * Triggers
     */
    const ::std::vector< ::std::string >& getTriggers() const;

    /**
     * Returns the current value of the property 'Triggers' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendTriggersUpdate() method.
     *
     * <b>Documentation of 'Triggers'</b>:
     *
     * Triggers
     */
    ::std::vector< ::std::string >& getTriggersMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendTriggersUpdate().
     *
     * <b>Documentation of 'Triggers'</b>:
     *
     * Triggers
     */
    void sendTriggersUpdate();

    // property 'TriggeredBy'

    /**
     * The method onTriggeredByGet() is called by ASF when a client invokes
     * the read method for the property 'TriggeredBy'. The onTriggeredByGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'TriggeredBy'</b>:
     *
     * TriggeredBy
     */
    virtual void onTriggeredByGet(const ::boost::shared_ptr< TriggeredByGet >& payload);

    /**
     * Sends back the update to a previous onTriggeredByGet().
     *
     * <b>Documentation of 'TriggeredBy'</b>:
     *
     * TriggeredBy
     *
     * @param act Identifies a previous invocation of onTriggeredByGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendTriggeredByGetUpdate(const ::std::vector< ::std::string >& triggeredBy, act_t act = 0);

    /**
     * Set the value of the property 'TriggeredBy' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'TriggeredBy'</b>:
     *
     * TriggeredBy
     */
    void setTriggeredBy(const ::std::vector< ::std::string >& triggeredBy);

    /**
     * Returns the current value of the property 'TriggeredBy'.
     *
     * <b>Documentation of 'TriggeredBy'</b>:
     *
     * TriggeredBy
     */
    const ::std::vector< ::std::string >& getTriggeredBy() const;

    /**
     * Returns the current value of the property 'TriggeredBy' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendTriggeredByUpdate() method.
     *
     * <b>Documentation of 'TriggeredBy'</b>:
     *
     * TriggeredBy
     */
    ::std::vector< ::std::string >& getTriggeredByMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendTriggeredByUpdate().
     *
     * <b>Documentation of 'TriggeredBy'</b>:
     *
     * TriggeredBy
     */
    void sendTriggeredByUpdate();

    // property 'PropagatesReloadTo'

    /**
     * The method onPropagatesReloadToGet() is called by ASF when a client
     * invokes the read method for the property 'PropagatesReloadTo'. The
     * onPropagatesReloadToGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'PropagatesReloadTo'</b>:
     *
     * PropagatesReloadTo
     */
    virtual void onPropagatesReloadToGet(const ::boost::shared_ptr< PropagatesReloadToGet >& payload);

    /**
     * Sends back the update to a previous onPropagatesReloadToGet().
     *
     * <b>Documentation of 'PropagatesReloadTo'</b>:
     *
     * PropagatesReloadTo
     *
     * @param act Identifies a previous invocation of
     * onPropagatesReloadToGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendPropagatesReloadToGetUpdate(const ::std::vector< ::std::string >& propagatesReloadTo, act_t act = 0);

    /**
     * Set the value of the property 'PropagatesReloadTo' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'PropagatesReloadTo'</b>:
     *
     * PropagatesReloadTo
     */
    void setPropagatesReloadTo(const ::std::vector< ::std::string >& propagatesReloadTo);

    /**
     * Returns the current value of the property 'PropagatesReloadTo'.
     *
     * <b>Documentation of 'PropagatesReloadTo'</b>:
     *
     * PropagatesReloadTo
     */
    const ::std::vector< ::std::string >& getPropagatesReloadTo() const;

    /**
     * Returns the current value of the property 'PropagatesReloadTo' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendPropagatesReloadToUpdate() method.
     *
     * <b>Documentation of 'PropagatesReloadTo'</b>:
     *
     * PropagatesReloadTo
     */
    ::std::vector< ::std::string >& getPropagatesReloadToMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendPropagatesReloadToUpdate().
     *
     * <b>Documentation of 'PropagatesReloadTo'</b>:
     *
     * PropagatesReloadTo
     */
    void sendPropagatesReloadToUpdate();

    // property 'ReloadPropagatedFrom'

    /**
     * The method onReloadPropagatedFromGet() is called by ASF when a client
     * invokes the read method for the property 'ReloadPropagatedFrom'. The
     * onReloadPropagatedFromGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'ReloadPropagatedFrom'</b>:
     *
     * ReloadPropagatedFrom
     */
    virtual void onReloadPropagatedFromGet(const ::boost::shared_ptr< ReloadPropagatedFromGet >& payload);

    /**
     * Sends back the update to a previous onReloadPropagatedFromGet().
     *
     * <b>Documentation of 'ReloadPropagatedFrom'</b>:
     *
     * ReloadPropagatedFrom
     *
     * @param act Identifies a previous invocation of
     * onReloadPropagatedFromGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendReloadPropagatedFromGetUpdate(const ::std::vector< ::std::string >& reloadPropagatedFrom, act_t act = 0);

    /**
     * Set the value of the property 'ReloadPropagatedFrom' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'ReloadPropagatedFrom'</b>:
     *
     * ReloadPropagatedFrom
     */
    void setReloadPropagatedFrom(const ::std::vector< ::std::string >& reloadPropagatedFrom);

    /**
     * Returns the current value of the property 'ReloadPropagatedFrom'.
     *
     * <b>Documentation of 'ReloadPropagatedFrom'</b>:
     *
     * ReloadPropagatedFrom
     */
    const ::std::vector< ::std::string >& getReloadPropagatedFrom() const;

    /**
     * Returns the current value of the property 'ReloadPropagatedFrom' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendReloadPropagatedFromUpdate() method.
     *
     * <b>Documentation of 'ReloadPropagatedFrom'</b>:
     *
     * ReloadPropagatedFrom
     */
    ::std::vector< ::std::string >& getReloadPropagatedFromMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendReloadPropagatedFromUpdate().
     *
     * <b>Documentation of 'ReloadPropagatedFrom'</b>:
     *
     * ReloadPropagatedFrom
     */
    void sendReloadPropagatedFromUpdate();

    // property 'JoinsNamespaceOf'

    /**
     * The method onJoinsNamespaceOfGet() is called by ASF when a client
     * invokes the read method for the property 'JoinsNamespaceOf'. The
     * onJoinsNamespaceOfGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'JoinsNamespaceOf'</b>:
     *
     * JoinsNamespaceOf
     */
    virtual void onJoinsNamespaceOfGet(const ::boost::shared_ptr< JoinsNamespaceOfGet >& payload);

    /**
     * Sends back the update to a previous onJoinsNamespaceOfGet().
     *
     * <b>Documentation of 'JoinsNamespaceOf'</b>:
     *
     * JoinsNamespaceOf
     *
     * @param act Identifies a previous invocation of onJoinsNamespaceOfGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendJoinsNamespaceOfGetUpdate(const ::std::vector< ::std::string >& joinsNamespaceOf, act_t act = 0);

    /**
     * Set the value of the property 'JoinsNamespaceOf' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'JoinsNamespaceOf'</b>:
     *
     * JoinsNamespaceOf
     */
    void setJoinsNamespaceOf(const ::std::vector< ::std::string >& joinsNamespaceOf);

    /**
     * Returns the current value of the property 'JoinsNamespaceOf'.
     *
     * <b>Documentation of 'JoinsNamespaceOf'</b>:
     *
     * JoinsNamespaceOf
     */
    const ::std::vector< ::std::string >& getJoinsNamespaceOf() const;

    /**
     * Returns the current value of the property 'JoinsNamespaceOf' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendJoinsNamespaceOfUpdate() method.
     *
     * <b>Documentation of 'JoinsNamespaceOf'</b>:
     *
     * JoinsNamespaceOf
     */
    ::std::vector< ::std::string >& getJoinsNamespaceOfMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendJoinsNamespaceOfUpdate().
     *
     * <b>Documentation of 'JoinsNamespaceOf'</b>:
     *
     * JoinsNamespaceOf
     */
    void sendJoinsNamespaceOfUpdate();

    // property 'RequiresMountsFor'

    /**
     * The method onRequiresMountsForGet() is called by ASF when a client
     * invokes the read method for the property 'RequiresMountsFor'. The
     * onRequiresMountsForGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'RequiresMountsFor'</b>:
     *
     * RequiresMountsFor
     */
    virtual void onRequiresMountsForGet(const ::boost::shared_ptr< RequiresMountsForGet >& payload);

    /**
     * Sends back the update to a previous onRequiresMountsForGet().
     *
     * <b>Documentation of 'RequiresMountsFor'</b>:
     *
     * RequiresMountsFor
     *
     * @param act Identifies a previous invocation of
     * onRequiresMountsForGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRequiresMountsForGetUpdate(const ::std::vector< ::std::string >& requiresMountsFor, act_t act = 0);

    /**
     * Set the value of the property 'RequiresMountsFor' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'RequiresMountsFor'</b>:
     *
     * RequiresMountsFor
     */
    void setRequiresMountsFor(const ::std::vector< ::std::string >& requiresMountsFor);

    /**
     * Returns the current value of the property 'RequiresMountsFor'.
     *
     * <b>Documentation of 'RequiresMountsFor'</b>:
     *
     * RequiresMountsFor
     */
    const ::std::vector< ::std::string >& getRequiresMountsFor() const;

    /**
     * Returns the current value of the property 'RequiresMountsFor' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendRequiresMountsForUpdate() method.
     *
     * <b>Documentation of 'RequiresMountsFor'</b>:
     *
     * RequiresMountsFor
     */
    ::std::vector< ::std::string >& getRequiresMountsForMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendRequiresMountsForUpdate().
     *
     * <b>Documentation of 'RequiresMountsFor'</b>:
     *
     * RequiresMountsFor
     */
    void sendRequiresMountsForUpdate();

    // property 'Documentation'

    /**
     * The method onDocumentationGet() is called by ASF when a client invokes
     * the read method for the property 'Documentation'. The
     * onDocumentationGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'Documentation'</b>:
     *
     * Documentation
     */
    virtual void onDocumentationGet(const ::boost::shared_ptr< DocumentationGet >& payload);

    /**
     * Sends back the update to a previous onDocumentationGet().
     *
     * <b>Documentation of 'Documentation'</b>:
     *
     * Documentation
     *
     * @param act Identifies a previous invocation of onDocumentationGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendDocumentationGetUpdate(const ::std::vector< ::std::string >& documentation, act_t act = 0);

    /**
     * Set the value of the property 'Documentation' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'Documentation'</b>:
     *
     * Documentation
     */
    void setDocumentation(const ::std::vector< ::std::string >& documentation);

    /**
     * Returns the current value of the property 'Documentation'.
     *
     * <b>Documentation of 'Documentation'</b>:
     *
     * Documentation
     */
    const ::std::vector< ::std::string >& getDocumentation() const;

    /**
     * Returns the current value of the property 'Documentation' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendDocumentationUpdate() method.
     *
     * <b>Documentation of 'Documentation'</b>:
     *
     * Documentation
     */
    ::std::vector< ::std::string >& getDocumentationMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendDocumentationUpdate().
     *
     * <b>Documentation of 'Documentation'</b>:
     *
     * Documentation
     */
    void sendDocumentationUpdate();

    // property 'Description'

    /**
     * The method onDescriptionGet() is called by ASF when a client invokes
     * the read method for the property 'Description'. The onDescriptionGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'Description'</b>:
     *
     * Description contains the human readable description string for the unit.
     */
    virtual void onDescriptionGet(const ::boost::shared_ptr< DescriptionGet >& payload);

    /**
     * Sends back the update to a previous onDescriptionGet().
     *
     * <b>Documentation of 'Description'</b>:
     *
     * Description contains the human readable description string for the unit.
     *
     * @param act Identifies a previous invocation of onDescriptionGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendDescriptionGetUpdate(const ::std::string& description, act_t act = 0);

    /**
     * Set the value of the property 'Description' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'Description'</b>:
     *
     * Description contains the human readable description string for the unit.
     */
    void setDescription(const ::std::string& description);

    /**
     * Returns the current value of the property 'Description'.
     *
     * <b>Documentation of 'Description'</b>:
     *
     * Description contains the human readable description string for the unit.
     */
    const ::std::string& getDescription() const;

    /**
     * Returns the current value of the property 'Description' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendDescriptionUpdate() method.
     *
     * <b>Documentation of 'Description'</b>:
     *
     * Description contains the human readable description string for the unit.
     */
    ::std::string& getDescriptionMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendDescriptionUpdate().
     *
     * <b>Documentation of 'Description'</b>:
     *
     * Description contains the human readable description string for the unit.
     */
    void sendDescriptionUpdate();

    // property 'LoadState'

    /**
     * The method onLoadStateGet() is called by ASF when a client invokes the
     * read method for the property 'LoadState'. The onLoadStateGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'LoadState'</b>:
     *
     * LoadState contains a state value that reflects whether the configuration file of this unit has been loaded.
     * 		The following states are currently defined: loaded, error, masked. loaded indicates that the configuration was successfully loaded.
     * 		error indicates that the configuration failed to load, the LoadError field (see below) contains information about the cause of this failure.
     * 		masked indicates that the unit is currently masked out (i.e. symlinked to /dev/null or suchlike). Note that the LoadState is fully orthogonal
     * 		to the ActiveState (see below) as units without valid loaded configuration might be active (because configuration might have been reloaded at
     * 		a time where a unit was already active).
     */
    virtual void onLoadStateGet(const ::boost::shared_ptr< LoadStateGet >& payload);

    /**
     * Sends back the update to a previous onLoadStateGet().
     *
     * <b>Documentation of 'LoadState'</b>:
     *
     * LoadState contains a state value that reflects whether the configuration file of this unit has been loaded.
     * 		The following states are currently defined: loaded, error, masked. loaded indicates that the configuration was successfully loaded.
     * 		error indicates that the configuration failed to load, the LoadError field (see below) contains information about the cause of this failure.
     * 		masked indicates that the unit is currently masked out (i.e. symlinked to /dev/null or suchlike). Note that the LoadState is fully orthogonal
     * 		to the ActiveState (see below) as units without valid loaded configuration might be active (because configuration might have been reloaded at
     * 		a time where a unit was already active).
     *
     * @param act Identifies a previous invocation of onLoadStateGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendLoadStateGetUpdate(const ::std::string& loadState, act_t act = 0);

    /**
     * Set the value of the property 'LoadState' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'LoadState'</b>:
     *
     * LoadState contains a state value that reflects whether the configuration file of this unit has been loaded.
     * 		The following states are currently defined: loaded, error, masked. loaded indicates that the configuration was successfully loaded.
     * 		error indicates that the configuration failed to load, the LoadError field (see below) contains information about the cause of this failure.
     * 		masked indicates that the unit is currently masked out (i.e. symlinked to /dev/null or suchlike). Note that the LoadState is fully orthogonal
     * 		to the ActiveState (see below) as units without valid loaded configuration might be active (because configuration might have been reloaded at
     * 		a time where a unit was already active).
     */
    void setLoadState(const ::std::string& loadState);

    /**
     * Returns the current value of the property 'LoadState'.
     *
     * <b>Documentation of 'LoadState'</b>:
     *
     * LoadState contains a state value that reflects whether the configuration file of this unit has been loaded.
     * 		The following states are currently defined: loaded, error, masked. loaded indicates that the configuration was successfully loaded.
     * 		error indicates that the configuration failed to load, the LoadError field (see below) contains information about the cause of this failure.
     * 		masked indicates that the unit is currently masked out (i.e. symlinked to /dev/null or suchlike). Note that the LoadState is fully orthogonal
     * 		to the ActiveState (see below) as units without valid loaded configuration might be active (because configuration might have been reloaded at
     * 		a time where a unit was already active).
     */
    const ::std::string& getLoadState() const;

    /**
     * Returns the current value of the property 'LoadState' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendLoadStateUpdate() method.
     *
     * <b>Documentation of 'LoadState'</b>:
     *
     * LoadState contains a state value that reflects whether the configuration file of this unit has been loaded.
     * 		The following states are currently defined: loaded, error, masked. loaded indicates that the configuration was successfully loaded.
     * 		error indicates that the configuration failed to load, the LoadError field (see below) contains information about the cause of this failure.
     * 		masked indicates that the unit is currently masked out (i.e. symlinked to /dev/null or suchlike). Note that the LoadState is fully orthogonal
     * 		to the ActiveState (see below) as units without valid loaded configuration might be active (because configuration might have been reloaded at
     * 		a time where a unit was already active).
     */
    ::std::string& getLoadStateMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendLoadStateUpdate().
     *
     * <b>Documentation of 'LoadState'</b>:
     *
     * LoadState contains a state value that reflects whether the configuration file of this unit has been loaded.
     * 		The following states are currently defined: loaded, error, masked. loaded indicates that the configuration was successfully loaded.
     * 		error indicates that the configuration failed to load, the LoadError field (see below) contains information about the cause of this failure.
     * 		masked indicates that the unit is currently masked out (i.e. symlinked to /dev/null or suchlike). Note that the LoadState is fully orthogonal
     * 		to the ActiveState (see below) as units without valid loaded configuration might be active (because configuration might have been reloaded at
     * 		a time where a unit was already active).
     */
    void sendLoadStateUpdate();

    // property 'ActiveState'

    /**
     * The method onActiveStateGet() is called by ASF when a client invokes
     * the read method for the property 'ActiveState'. The onActiveStateGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'ActiveState'</b>:
     *
     * ActiveState contains a state value that reflects whether the unit is currently active or not.
     * 		The following states are currently defined: active, reloading, inactive, failed, activating, deactivating. active indicates
     * 		that unit is active (obviously...). reloading indicates that the unit is active and currently reloading its configuration.
     * 		inactive indicates that it is inactive and the previous run was successful or no previous run has taken place yet.
     * 		failed indicates that it is inactive and the previous run was not successful.
     * 		activating indicates that the unit has previously been inactive but is currently in the process of entering an active state.
     * 		 Conversely deactivating indicates that the unit is currently in the process of deactivation
     */
    virtual void onActiveStateGet(const ::boost::shared_ptr< ActiveStateGet >& payload);

    /**
     * Sends back the update to a previous onActiveStateGet().
     *
     * <b>Documentation of 'ActiveState'</b>:
     *
     * ActiveState contains a state value that reflects whether the unit is currently active or not.
     * 		The following states are currently defined: active, reloading, inactive, failed, activating, deactivating. active indicates
     * 		that unit is active (obviously...). reloading indicates that the unit is active and currently reloading its configuration.
     * 		inactive indicates that it is inactive and the previous run was successful or no previous run has taken place yet.
     * 		failed indicates that it is inactive and the previous run was not successful.
     * 		activating indicates that the unit has previously been inactive but is currently in the process of entering an active state.
     * 		 Conversely deactivating indicates that the unit is currently in the process of deactivation
     *
     * @param act Identifies a previous invocation of onActiveStateGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendActiveStateGetUpdate(const ::std::string& activeState, act_t act = 0);

    /**
     * Set the value of the property 'ActiveState' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'ActiveState'</b>:
     *
     * ActiveState contains a state value that reflects whether the unit is currently active or not.
     * 		The following states are currently defined: active, reloading, inactive, failed, activating, deactivating. active indicates
     * 		that unit is active (obviously...). reloading indicates that the unit is active and currently reloading its configuration.
     * 		inactive indicates that it is inactive and the previous run was successful or no previous run has taken place yet.
     * 		failed indicates that it is inactive and the previous run was not successful.
     * 		activating indicates that the unit has previously been inactive but is currently in the process of entering an active state.
     * 		 Conversely deactivating indicates that the unit is currently in the process of deactivation
     */
    void setActiveState(const ::std::string& activeState);

    /**
     * Returns the current value of the property 'ActiveState'.
     *
     * <b>Documentation of 'ActiveState'</b>:
     *
     * ActiveState contains a state value that reflects whether the unit is currently active or not.
     * 		The following states are currently defined: active, reloading, inactive, failed, activating, deactivating. active indicates
     * 		that unit is active (obviously...). reloading indicates that the unit is active and currently reloading its configuration.
     * 		inactive indicates that it is inactive and the previous run was successful or no previous run has taken place yet.
     * 		failed indicates that it is inactive and the previous run was not successful.
     * 		activating indicates that the unit has previously been inactive but is currently in the process of entering an active state.
     * 		 Conversely deactivating indicates that the unit is currently in the process of deactivation
     */
    const ::std::string& getActiveState() const;

    /**
     * Returns the current value of the property 'ActiveState' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendActiveStateUpdate() method.
     *
     * <b>Documentation of 'ActiveState'</b>:
     *
     * ActiveState contains a state value that reflects whether the unit is currently active or not.
     * 		The following states are currently defined: active, reloading, inactive, failed, activating, deactivating. active indicates
     * 		that unit is active (obviously...). reloading indicates that the unit is active and currently reloading its configuration.
     * 		inactive indicates that it is inactive and the previous run was successful or no previous run has taken place yet.
     * 		failed indicates that it is inactive and the previous run was not successful.
     * 		activating indicates that the unit has previously been inactive but is currently in the process of entering an active state.
     * 		 Conversely deactivating indicates that the unit is currently in the process of deactivation
     */
    ::std::string& getActiveStateMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendActiveStateUpdate().
     *
     * <b>Documentation of 'ActiveState'</b>:
     *
     * ActiveState contains a state value that reflects whether the unit is currently active or not.
     * 		The following states are currently defined: active, reloading, inactive, failed, activating, deactivating. active indicates
     * 		that unit is active (obviously...). reloading indicates that the unit is active and currently reloading its configuration.
     * 		inactive indicates that it is inactive and the previous run was successful or no previous run has taken place yet.
     * 		failed indicates that it is inactive and the previous run was not successful.
     * 		activating indicates that the unit has previously been inactive but is currently in the process of entering an active state.
     * 		 Conversely deactivating indicates that the unit is currently in the process of deactivation
     */
    void sendActiveStateUpdate();

    // property 'SubState'

    /**
     * The method onSubStateGet() is called by ASF when a client invokes the
     * read method for the property 'SubState'. The onSubStateGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'SubState'</b>:
     *
     * SubState encodes states of the same state machine that ActiveState covers, but knows more fine-grained states
     * 		that are unit-type-specific. Where ActiveState only covers six high-level states, SubState covers possibly many more low-level
     * 		unit-type-specific states that are mapped to the six high-level states. Note that multiple low-level states might map to the same
     * 		high-level state, but not vice versa. Not all high-level states have low-level counterparts on all unit types. At this point the
     * 		low-level states are not documented here, and are more likely to be extended later on than the common high-level states explained above.
     */
    virtual void onSubStateGet(const ::boost::shared_ptr< SubStateGet >& payload);

    /**
     * Sends back the update to a previous onSubStateGet().
     *
     * <b>Documentation of 'SubState'</b>:
     *
     * SubState encodes states of the same state machine that ActiveState covers, but knows more fine-grained states
     * 		that are unit-type-specific. Where ActiveState only covers six high-level states, SubState covers possibly many more low-level
     * 		unit-type-specific states that are mapped to the six high-level states. Note that multiple low-level states might map to the same
     * 		high-level state, but not vice versa. Not all high-level states have low-level counterparts on all unit types. At this point the
     * 		low-level states are not documented here, and are more likely to be extended later on than the common high-level states explained above.
     *
     * @param act Identifies a previous invocation of onSubStateGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendSubStateGetUpdate(const ::std::string& subState, act_t act = 0);

    /**
     * Set the value of the property 'SubState' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'SubState'</b>:
     *
     * SubState encodes states of the same state machine that ActiveState covers, but knows more fine-grained states
     * 		that are unit-type-specific. Where ActiveState only covers six high-level states, SubState covers possibly many more low-level
     * 		unit-type-specific states that are mapped to the six high-level states. Note that multiple low-level states might map to the same
     * 		high-level state, but not vice versa. Not all high-level states have low-level counterparts on all unit types. At this point the
     * 		low-level states are not documented here, and are more likely to be extended later on than the common high-level states explained above.
     */
    void setSubState(const ::std::string& subState);

    /**
     * Returns the current value of the property 'SubState'.
     *
     * <b>Documentation of 'SubState'</b>:
     *
     * SubState encodes states of the same state machine that ActiveState covers, but knows more fine-grained states
     * 		that are unit-type-specific. Where ActiveState only covers six high-level states, SubState covers possibly many more low-level
     * 		unit-type-specific states that are mapped to the six high-level states. Note that multiple low-level states might map to the same
     * 		high-level state, but not vice versa. Not all high-level states have low-level counterparts on all unit types. At this point the
     * 		low-level states are not documented here, and are more likely to be extended later on than the common high-level states explained above.
     */
    const ::std::string& getSubState() const;

    /**
     * Returns the current value of the property 'SubState' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendSubStateUpdate() method.
     *
     * <b>Documentation of 'SubState'</b>:
     *
     * SubState encodes states of the same state machine that ActiveState covers, but knows more fine-grained states
     * 		that are unit-type-specific. Where ActiveState only covers six high-level states, SubState covers possibly many more low-level
     * 		unit-type-specific states that are mapped to the six high-level states. Note that multiple low-level states might map to the same
     * 		high-level state, but not vice versa. Not all high-level states have low-level counterparts on all unit types. At this point the
     * 		low-level states are not documented here, and are more likely to be extended later on than the common high-level states explained above.
     */
    ::std::string& getSubStateMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSubStateUpdate().
     *
     * <b>Documentation of 'SubState'</b>:
     *
     * SubState encodes states of the same state machine that ActiveState covers, but knows more fine-grained states
     * 		that are unit-type-specific. Where ActiveState only covers six high-level states, SubState covers possibly many more low-level
     * 		unit-type-specific states that are mapped to the six high-level states. Note that multiple low-level states might map to the same
     * 		high-level state, but not vice versa. Not all high-level states have low-level counterparts on all unit types. At this point the
     * 		low-level states are not documented here, and are more likely to be extended later on than the common high-level states explained above.
     */
    void sendSubStateUpdate();

    // property 'FragmentPath'

    /**
     * The method onFragmentPathGet() is called by ASF when a client invokes
     * the read method for the property 'FragmentPath'. The
     * onFragmentPathGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'FragmentPath'</b>:
     *
     * FragmentPath contains the unit file path this unit was read from, if there is any (if not this contains the empty string).
     */
    virtual void onFragmentPathGet(const ::boost::shared_ptr< FragmentPathGet >& payload);

    /**
     * Sends back the update to a previous onFragmentPathGet().
     *
     * <b>Documentation of 'FragmentPath'</b>:
     *
     * FragmentPath contains the unit file path this unit was read from, if there is any (if not this contains the empty string).
     *
     * @param act Identifies a previous invocation of onFragmentPathGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendFragmentPathGetUpdate(const ::std::string& fragmentPath, act_t act = 0);

    /**
     * Set the value of the property 'FragmentPath' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'FragmentPath'</b>:
     *
     * FragmentPath contains the unit file path this unit was read from, if there is any (if not this contains the empty string).
     */
    void setFragmentPath(const ::std::string& fragmentPath);

    /**
     * Returns the current value of the property 'FragmentPath'.
     *
     * <b>Documentation of 'FragmentPath'</b>:
     *
     * FragmentPath contains the unit file path this unit was read from, if there is any (if not this contains the empty string).
     */
    const ::std::string& getFragmentPath() const;

    /**
     * Returns the current value of the property 'FragmentPath' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendFragmentPathUpdate() method.
     *
     * <b>Documentation of 'FragmentPath'</b>:
     *
     * FragmentPath contains the unit file path this unit was read from, if there is any (if not this contains the empty string).
     */
    ::std::string& getFragmentPathMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendFragmentPathUpdate().
     *
     * <b>Documentation of 'FragmentPath'</b>:
     *
     * FragmentPath contains the unit file path this unit was read from, if there is any (if not this contains the empty string).
     */
    void sendFragmentPathUpdate();

    // property 'SourcePath'

    /**
     * The method onSourcePathGet() is called by ASF when a client invokes the
     * read method for the property 'SourcePath'. The onSourcePathGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'SourcePath'</b>:
     *
     * SourcePath  contains the path to a configuration file this unit is automatically generated from in case it is not a native
     * 		unit (in which case it contains the empty string). For example, all mount units generated from /etc/fstab have this field set to this value.
     */
    virtual void onSourcePathGet(const ::boost::shared_ptr< SourcePathGet >& payload);

    /**
     * Sends back the update to a previous onSourcePathGet().
     *
     * <b>Documentation of 'SourcePath'</b>:
     *
     * SourcePath  contains the path to a configuration file this unit is automatically generated from in case it is not a native
     * 		unit (in which case it contains the empty string). For example, all mount units generated from /etc/fstab have this field set to this value.
     *
     * @param act Identifies a previous invocation of onSourcePathGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSourcePathGetUpdate(const ::std::string& sourcePath, act_t act = 0);

    /**
     * Set the value of the property 'SourcePath' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'SourcePath'</b>:
     *
     * SourcePath  contains the path to a configuration file this unit is automatically generated from in case it is not a native
     * 		unit (in which case it contains the empty string). For example, all mount units generated from /etc/fstab have this field set to this value.
     */
    void setSourcePath(const ::std::string& sourcePath);

    /**
     * Returns the current value of the property 'SourcePath'.
     *
     * <b>Documentation of 'SourcePath'</b>:
     *
     * SourcePath  contains the path to a configuration file this unit is automatically generated from in case it is not a native
     * 		unit (in which case it contains the empty string). For example, all mount units generated from /etc/fstab have this field set to this value.
     */
    const ::std::string& getSourcePath() const;

    /**
     * Returns the current value of the property 'SourcePath' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendSourcePathUpdate() method.
     *
     * <b>Documentation of 'SourcePath'</b>:
     *
     * SourcePath  contains the path to a configuration file this unit is automatically generated from in case it is not a native
     * 		unit (in which case it contains the empty string). For example, all mount units generated from /etc/fstab have this field set to this value.
     */
    ::std::string& getSourcePathMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSourcePathUpdate().
     *
     * <b>Documentation of 'SourcePath'</b>:
     *
     * SourcePath  contains the path to a configuration file this unit is automatically generated from in case it is not a native
     * 		unit (in which case it contains the empty string). For example, all mount units generated from /etc/fstab have this field set to this value.
     */
    void sendSourcePathUpdate();

    // property 'DropInPaths'

    /**
     * The method onDropInPathsGet() is called by ASF when a client invokes
     * the read method for the property 'DropInPaths'. The onDropInPathsGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'DropInPaths'</b>:
     *
     * DropInPaths
     */
    virtual void onDropInPathsGet(const ::boost::shared_ptr< DropInPathsGet >& payload);

    /**
     * Sends back the update to a previous onDropInPathsGet().
     *
     * <b>Documentation of 'DropInPaths'</b>:
     *
     * DropInPaths
     *
     * @param act Identifies a previous invocation of onDropInPathsGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendDropInPathsGetUpdate(const ::std::vector< ::std::string >& dropInPaths, act_t act = 0);

    /**
     * Set the value of the property 'DropInPaths' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'DropInPaths'</b>:
     *
     * DropInPaths
     */
    void setDropInPaths(const ::std::vector< ::std::string >& dropInPaths);

    /**
     * Returns the current value of the property 'DropInPaths'.
     *
     * <b>Documentation of 'DropInPaths'</b>:
     *
     * DropInPaths
     */
    const ::std::vector< ::std::string >& getDropInPaths() const;

    /**
     * Returns the current value of the property 'DropInPaths' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendDropInPathsUpdate() method.
     *
     * <b>Documentation of 'DropInPaths'</b>:
     *
     * DropInPaths
     */
    ::std::vector< ::std::string >& getDropInPathsMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendDropInPathsUpdate().
     *
     * <b>Documentation of 'DropInPaths'</b>:
     *
     * DropInPaths
     */
    void sendDropInPathsUpdate();

    // property 'UnitFileState'

    /**
     * The method onUnitFileStateGet() is called by ASF when a client invokes
     * the read method for the property 'UnitFileState'. The
     * onUnitFileStateGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'UnitFileState'</b>:
     *
     * UnitFileState encodes the install state of the unit file of FragmentPath. It currently knows the following states: enabled,
     * 		enabled-runtime, linked, linked-runtime, masked, masked-runtime, static, disabled, invalid. enabled indicates that a unit file is permanently enabled.
     * 		enable-runtime indicates the unit file is only temporarily enabled, and will no longer be enabled after a reboot (that means, it is enabled via /run symlinks,
     * 		rather than /etc). linked indicates that a unit is linked into /etc permanently, linked indicates that a unit is linked into /run temporarily (until the next reboot).
     * 		masked indicates that the unit file is masked permanently, masked-runtime indicates that it is only temporarily masked in /run, until the next reboot.
     * 		static indicates that the unit is statically enabled, i.e. always enabled and doesn't need to be enabled explicitly. invalid indicates that it could not be
     * 		determined whether the unit file is enabled.
     */
    virtual void onUnitFileStateGet(const ::boost::shared_ptr< UnitFileStateGet >& payload);

    /**
     * Sends back the update to a previous onUnitFileStateGet().
     *
     * <b>Documentation of 'UnitFileState'</b>:
     *
     * UnitFileState encodes the install state of the unit file of FragmentPath. It currently knows the following states: enabled,
     * 		enabled-runtime, linked, linked-runtime, masked, masked-runtime, static, disabled, invalid. enabled indicates that a unit file is permanently enabled.
     * 		enable-runtime indicates the unit file is only temporarily enabled, and will no longer be enabled after a reboot (that means, it is enabled via /run symlinks,
     * 		rather than /etc). linked indicates that a unit is linked into /etc permanently, linked indicates that a unit is linked into /run temporarily (until the next reboot).
     * 		masked indicates that the unit file is masked permanently, masked-runtime indicates that it is only temporarily masked in /run, until the next reboot.
     * 		static indicates that the unit is statically enabled, i.e. always enabled and doesn't need to be enabled explicitly. invalid indicates that it could not be
     * 		determined whether the unit file is enabled.
     *
     * @param act Identifies a previous invocation of onUnitFileStateGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendUnitFileStateGetUpdate(const ::std::string& unitFileState, act_t act = 0);

    /**
     * Set the value of the property 'UnitFileState' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'UnitFileState'</b>:
     *
     * UnitFileState encodes the install state of the unit file of FragmentPath. It currently knows the following states: enabled,
     * 		enabled-runtime, linked, linked-runtime, masked, masked-runtime, static, disabled, invalid. enabled indicates that a unit file is permanently enabled.
     * 		enable-runtime indicates the unit file is only temporarily enabled, and will no longer be enabled after a reboot (that means, it is enabled via /run symlinks,
     * 		rather than /etc). linked indicates that a unit is linked into /etc permanently, linked indicates that a unit is linked into /run temporarily (until the next reboot).
     * 		masked indicates that the unit file is masked permanently, masked-runtime indicates that it is only temporarily masked in /run, until the next reboot.
     * 		static indicates that the unit is statically enabled, i.e. always enabled and doesn't need to be enabled explicitly. invalid indicates that it could not be
     * 		determined whether the unit file is enabled.
     */
    void setUnitFileState(const ::std::string& unitFileState);

    /**
     * Returns the current value of the property 'UnitFileState'.
     *
     * <b>Documentation of 'UnitFileState'</b>:
     *
     * UnitFileState encodes the install state of the unit file of FragmentPath. It currently knows the following states: enabled,
     * 		enabled-runtime, linked, linked-runtime, masked, masked-runtime, static, disabled, invalid. enabled indicates that a unit file is permanently enabled.
     * 		enable-runtime indicates the unit file is only temporarily enabled, and will no longer be enabled after a reboot (that means, it is enabled via /run symlinks,
     * 		rather than /etc). linked indicates that a unit is linked into /etc permanently, linked indicates that a unit is linked into /run temporarily (until the next reboot).
     * 		masked indicates that the unit file is masked permanently, masked-runtime indicates that it is only temporarily masked in /run, until the next reboot.
     * 		static indicates that the unit is statically enabled, i.e. always enabled and doesn't need to be enabled explicitly. invalid indicates that it could not be
     * 		determined whether the unit file is enabled.
     */
    const ::std::string& getUnitFileState() const;

    /**
     * Returns the current value of the property 'UnitFileState' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendUnitFileStateUpdate() method.
     *
     * <b>Documentation of 'UnitFileState'</b>:
     *
     * UnitFileState encodes the install state of the unit file of FragmentPath. It currently knows the following states: enabled,
     * 		enabled-runtime, linked, linked-runtime, masked, masked-runtime, static, disabled, invalid. enabled indicates that a unit file is permanently enabled.
     * 		enable-runtime indicates the unit file is only temporarily enabled, and will no longer be enabled after a reboot (that means, it is enabled via /run symlinks,
     * 		rather than /etc). linked indicates that a unit is linked into /etc permanently, linked indicates that a unit is linked into /run temporarily (until the next reboot).
     * 		masked indicates that the unit file is masked permanently, masked-runtime indicates that it is only temporarily masked in /run, until the next reboot.
     * 		static indicates that the unit is statically enabled, i.e. always enabled and doesn't need to be enabled explicitly. invalid indicates that it could not be
     * 		determined whether the unit file is enabled.
     */
    ::std::string& getUnitFileStateMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendUnitFileStateUpdate().
     *
     * <b>Documentation of 'UnitFileState'</b>:
     *
     * UnitFileState encodes the install state of the unit file of FragmentPath. It currently knows the following states: enabled,
     * 		enabled-runtime, linked, linked-runtime, masked, masked-runtime, static, disabled, invalid. enabled indicates that a unit file is permanently enabled.
     * 		enable-runtime indicates the unit file is only temporarily enabled, and will no longer be enabled after a reboot (that means, it is enabled via /run symlinks,
     * 		rather than /etc). linked indicates that a unit is linked into /etc permanently, linked indicates that a unit is linked into /run temporarily (until the next reboot).
     * 		masked indicates that the unit file is masked permanently, masked-runtime indicates that it is only temporarily masked in /run, until the next reboot.
     * 		static indicates that the unit is statically enabled, i.e. always enabled and doesn't need to be enabled explicitly. invalid indicates that it could not be
     * 		determined whether the unit file is enabled.
     */
    void sendUnitFileStateUpdate();

    // property 'UnitFilePreset'

    /**
     * The method onUnitFilePresetGet() is called by ASF when a client invokes
     * the read method for the property 'UnitFilePreset'. The
     * onUnitFilePresetGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'UnitFilePreset'</b>:
     *
     * UnitFilePreset
     */
    virtual void onUnitFilePresetGet(const ::boost::shared_ptr< UnitFilePresetGet >& payload);

    /**
     * Sends back the update to a previous onUnitFilePresetGet().
     *
     * <b>Documentation of 'UnitFilePreset'</b>:
     *
     * UnitFilePreset
     *
     * @param act Identifies a previous invocation of onUnitFilePresetGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendUnitFilePresetGetUpdate(const ::std::string& unitFilePreset, act_t act = 0);

    /**
     * Set the value of the property 'UnitFilePreset' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'UnitFilePreset'</b>:
     *
     * UnitFilePreset
     */
    void setUnitFilePreset(const ::std::string& unitFilePreset);

    /**
     * Returns the current value of the property 'UnitFilePreset'.
     *
     * <b>Documentation of 'UnitFilePreset'</b>:
     *
     * UnitFilePreset
     */
    const ::std::string& getUnitFilePreset() const;

    /**
     * Returns the current value of the property 'UnitFilePreset' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendUnitFilePresetUpdate() method.
     *
     * <b>Documentation of 'UnitFilePreset'</b>:
     *
     * UnitFilePreset
     */
    ::std::string& getUnitFilePresetMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendUnitFilePresetUpdate().
     *
     * <b>Documentation of 'UnitFilePreset'</b>:
     *
     * UnitFilePreset
     */
    void sendUnitFilePresetUpdate();

    // property 'InactiveExitTimestamp'

    /**
     * The method onInactiveExitTimestampGet() is called by ASF when a client
     * invokes the read method for the property 'InactiveExitTimestamp'. The
     * onInactiveExitTimestampGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'InactiveExitTimestamp'</b>:
     *
     * InactiveExitTimestamp contain CLOCK_REALTIME and CLOCK_MONOTONIC 64bit usec timestamps of the last time a unit left the inactive state, entered
     * 		the active state, exited the active state, or entered an inactive state. These are the points in time where the unit transitioned inactive/failed → activating,
     * 		activating → active, active → deactivating, and finally deactivating → inactive/failed. The fields are 0 in case such a transition has not been recording on this boot yet.
     */
    virtual void onInactiveExitTimestampGet(const ::boost::shared_ptr< InactiveExitTimestampGet >& payload);

    /**
     * Sends back the update to a previous onInactiveExitTimestampGet().
     *
     * <b>Documentation of 'InactiveExitTimestamp'</b>:
     *
     * InactiveExitTimestamp contain CLOCK_REALTIME and CLOCK_MONOTONIC 64bit usec timestamps of the last time a unit left the inactive state, entered
     * 		the active state, exited the active state, or entered an inactive state. These are the points in time where the unit transitioned inactive/failed → activating,
     * 		activating → active, active → deactivating, and finally deactivating → inactive/failed. The fields are 0 in case such a transition has not been recording on this boot yet.
     *
     * @param act Identifies a previous invocation of
     * onInactiveExitTimestampGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendInactiveExitTimestampGetUpdate(uint64 inactiveExitTimestamp, act_t act = 0);

    /**
     * Set the value of the property 'InactiveExitTimestamp' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'InactiveExitTimestamp'</b>:
     *
     * InactiveExitTimestamp contain CLOCK_REALTIME and CLOCK_MONOTONIC 64bit usec timestamps of the last time a unit left the inactive state, entered
     * 		the active state, exited the active state, or entered an inactive state. These are the points in time where the unit transitioned inactive/failed → activating,
     * 		activating → active, active → deactivating, and finally deactivating → inactive/failed. The fields are 0 in case such a transition has not been recording on this boot yet.
     */
    void setInactiveExitTimestamp(uint64 inactiveExitTimestamp);

    /**
     * Returns the current value of the property 'InactiveExitTimestamp'.
     *
     * <b>Documentation of 'InactiveExitTimestamp'</b>:
     *
     * InactiveExitTimestamp contain CLOCK_REALTIME and CLOCK_MONOTONIC 64bit usec timestamps of the last time a unit left the inactive state, entered
     * 		the active state, exited the active state, or entered an inactive state. These are the points in time where the unit transitioned inactive/failed → activating,
     * 		activating → active, active → deactivating, and finally deactivating → inactive/failed. The fields are 0 in case such a transition has not been recording on this boot yet.
     */
    uint64 getInactiveExitTimestamp() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendInactiveExitTimestampUpdate().
     *
     * <b>Documentation of 'InactiveExitTimestamp'</b>:
     *
     * InactiveExitTimestamp contain CLOCK_REALTIME and CLOCK_MONOTONIC 64bit usec timestamps of the last time a unit left the inactive state, entered
     * 		the active state, exited the active state, or entered an inactive state. These are the points in time where the unit transitioned inactive/failed → activating,
     * 		activating → active, active → deactivating, and finally deactivating → inactive/failed. The fields are 0 in case such a transition has not been recording on this boot yet.
     */
    void sendInactiveExitTimestampUpdate();

    // property 'InactiveExitTimestampMonotonic'

    /**
     * The method onInactiveExitTimestampMonotonicGet() is called by ASF when
     * a client invokes the read method for the property
     * 'InactiveExitTimestampMonotonic'. The
     * onInactiveExitTimestampMonotonicGet() method returns by default the
     * current property value to the caller. In case this default behavior
     * doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'InactiveExitTimestampMonotonic'</b>:
     *
     * InactiveExitTimestampMonotonic
     */
    virtual void onInactiveExitTimestampMonotonicGet(const ::boost::shared_ptr< InactiveExitTimestampMonotonicGet >& payload);

    /**
     * Sends back the update to a previous
     * onInactiveExitTimestampMonotonicGet().
     *
     * <b>Documentation of 'InactiveExitTimestampMonotonic'</b>:
     *
     * InactiveExitTimestampMonotonic
     *
     * @param act Identifies a previous invocation of
     * onInactiveExitTimestampMonotonicGet(). If the act is not specified,
     * i.e. the most recent invocation will be answered. In case multiple
     * replies are pending an act must be specified. An assertion will be
     * thrown if no or multiple method invocation could be found.
     */
    void sendInactiveExitTimestampMonotonicGetUpdate(uint64 inactiveExitTimestampMonotonic, act_t act = 0);

    /**
     * Set the value of the property 'InactiveExitTimestampMonotonic' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'InactiveExitTimestampMonotonic'</b>:
     *
     * InactiveExitTimestampMonotonic
     */
    void setInactiveExitTimestampMonotonic(uint64 inactiveExitTimestampMonotonic);

    /**
     * Returns the current value of the property 'InactiveExitTimestampMonotonic'.
     *
     * <b>Documentation of 'InactiveExitTimestampMonotonic'</b>:
     *
     * InactiveExitTimestampMonotonic
     */
    uint64 getInactiveExitTimestampMonotonic() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendInactiveExitTimestampMonotonicUpdate().
     *
     * <b>Documentation of 'InactiveExitTimestampMonotonic'</b>:
     *
     * InactiveExitTimestampMonotonic
     */
    void sendInactiveExitTimestampMonotonicUpdate();

    // property 'ActiveEnterTimestamp'

    /**
     * The method onActiveEnterTimestampGet() is called by ASF when a client
     * invokes the read method for the property 'ActiveEnterTimestamp'. The
     * onActiveEnterTimestampGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'ActiveEnterTimestamp'</b>:
     *
     * ActiveEnterTimestamp
     */
    virtual void onActiveEnterTimestampGet(const ::boost::shared_ptr< ActiveEnterTimestampGet >& payload);

    /**
     * Sends back the update to a previous onActiveEnterTimestampGet().
     *
     * <b>Documentation of 'ActiveEnterTimestamp'</b>:
     *
     * ActiveEnterTimestamp
     *
     * @param act Identifies a previous invocation of
     * onActiveEnterTimestampGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendActiveEnterTimestampGetUpdate(uint64 activeEnterTimestamp, act_t act = 0);

    /**
     * Set the value of the property 'ActiveEnterTimestamp' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'ActiveEnterTimestamp'</b>:
     *
     * ActiveEnterTimestamp
     */
    void setActiveEnterTimestamp(uint64 activeEnterTimestamp);

    /**
     * Returns the current value of the property 'ActiveEnterTimestamp'.
     *
     * <b>Documentation of 'ActiveEnterTimestamp'</b>:
     *
     * ActiveEnterTimestamp
     */
    uint64 getActiveEnterTimestamp() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendActiveEnterTimestampUpdate().
     *
     * <b>Documentation of 'ActiveEnterTimestamp'</b>:
     *
     * ActiveEnterTimestamp
     */
    void sendActiveEnterTimestampUpdate();

    // property 'ActiveEnterTimestampMonotonic'

    /**
     * The method onActiveEnterTimestampMonotonicGet() is called by ASF when a
     * client invokes the read method for the property
     * 'ActiveEnterTimestampMonotonic'. The
     * onActiveEnterTimestampMonotonicGet() method returns by default the
     * current property value to the caller. In case this default behavior
     * doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'ActiveEnterTimestampMonotonic'</b>:
     *
     * ActiveEnterTimestampMonotonic
     */
    virtual void onActiveEnterTimestampMonotonicGet(const ::boost::shared_ptr< ActiveEnterTimestampMonotonicGet >& payload);

    /**
     * Sends back the update to a previous
     * onActiveEnterTimestampMonotonicGet().
     *
     * <b>Documentation of 'ActiveEnterTimestampMonotonic'</b>:
     *
     * ActiveEnterTimestampMonotonic
     *
     * @param act Identifies a previous invocation of
     * onActiveEnterTimestampMonotonicGet(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendActiveEnterTimestampMonotonicGetUpdate(uint64 activeEnterTimestampMonotonic, act_t act = 0);

    /**
     * Set the value of the property 'ActiveEnterTimestampMonotonic' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'ActiveEnterTimestampMonotonic'</b>:
     *
     * ActiveEnterTimestampMonotonic
     */
    void setActiveEnterTimestampMonotonic(uint64 activeEnterTimestampMonotonic);

    /**
     * Returns the current value of the property 'ActiveEnterTimestampMonotonic'.
     *
     * <b>Documentation of 'ActiveEnterTimestampMonotonic'</b>:
     *
     * ActiveEnterTimestampMonotonic
     */
    uint64 getActiveEnterTimestampMonotonic() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendActiveEnterTimestampMonotonicUpdate().
     *
     * <b>Documentation of 'ActiveEnterTimestampMonotonic'</b>:
     *
     * ActiveEnterTimestampMonotonic
     */
    void sendActiveEnterTimestampMonotonicUpdate();

    // property 'ActiveExitTimestamp'

    /**
     * The method onActiveExitTimestampGet() is called by ASF when a client
     * invokes the read method for the property 'ActiveExitTimestamp'. The
     * onActiveExitTimestampGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'ActiveExitTimestamp'</b>:
     *
     * ActiveExitTimestamp
     */
    virtual void onActiveExitTimestampGet(const ::boost::shared_ptr< ActiveExitTimestampGet >& payload);

    /**
     * Sends back the update to a previous onActiveExitTimestampGet().
     *
     * <b>Documentation of 'ActiveExitTimestamp'</b>:
     *
     * ActiveExitTimestamp
     *
     * @param act Identifies a previous invocation of
     * onActiveExitTimestampGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendActiveExitTimestampGetUpdate(uint64 activeExitTimestamp, act_t act = 0);

    /**
     * Set the value of the property 'ActiveExitTimestamp' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'ActiveExitTimestamp'</b>:
     *
     * ActiveExitTimestamp
     */
    void setActiveExitTimestamp(uint64 activeExitTimestamp);

    /**
     * Returns the current value of the property 'ActiveExitTimestamp'.
     *
     * <b>Documentation of 'ActiveExitTimestamp'</b>:
     *
     * ActiveExitTimestamp
     */
    uint64 getActiveExitTimestamp() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendActiveExitTimestampUpdate().
     *
     * <b>Documentation of 'ActiveExitTimestamp'</b>:
     *
     * ActiveExitTimestamp
     */
    void sendActiveExitTimestampUpdate();

    // property 'ActiveExitTimestampMonotonic'

    /**
     * The method onActiveExitTimestampMonotonicGet() is called by ASF when a
     * client invokes the read method for the property
     * 'ActiveExitTimestampMonotonic'. The onActiveExitTimestampMonotonicGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'ActiveExitTimestampMonotonic'</b>:
     *
     * ActiveExitTimestampMonotonic
     */
    virtual void onActiveExitTimestampMonotonicGet(const ::boost::shared_ptr< ActiveExitTimestampMonotonicGet >& payload);

    /**
     * Sends back the update to a previous
     * onActiveExitTimestampMonotonicGet().
     *
     * <b>Documentation of 'ActiveExitTimestampMonotonic'</b>:
     *
     * ActiveExitTimestampMonotonic
     *
     * @param act Identifies a previous invocation of
     * onActiveExitTimestampMonotonicGet(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendActiveExitTimestampMonotonicGetUpdate(uint64 activeExitTimestampMonotonic, act_t act = 0);

    /**
     * Set the value of the property 'ActiveExitTimestampMonotonic' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'ActiveExitTimestampMonotonic'</b>:
     *
     * ActiveExitTimestampMonotonic
     */
    void setActiveExitTimestampMonotonic(uint64 activeExitTimestampMonotonic);

    /**
     * Returns the current value of the property 'ActiveExitTimestampMonotonic'.
     *
     * <b>Documentation of 'ActiveExitTimestampMonotonic'</b>:
     *
     * ActiveExitTimestampMonotonic
     */
    uint64 getActiveExitTimestampMonotonic() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendActiveExitTimestampMonotonicUpdate().
     *
     * <b>Documentation of 'ActiveExitTimestampMonotonic'</b>:
     *
     * ActiveExitTimestampMonotonic
     */
    void sendActiveExitTimestampMonotonicUpdate();

    // property 'InactiveEnterTimestamp'

    /**
     * The method onInactiveEnterTimestampGet() is called by ASF when a client
     * invokes the read method for the property 'InactiveEnterTimestamp'. The
     * onInactiveEnterTimestampGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'InactiveEnterTimestamp'</b>:
     *
     * InactiveEnterTimestamp
     */
    virtual void onInactiveEnterTimestampGet(const ::boost::shared_ptr< InactiveEnterTimestampGet >& payload);

    /**
     * Sends back the update to a previous onInactiveEnterTimestampGet().
     *
     * <b>Documentation of 'InactiveEnterTimestamp'</b>:
     *
     * InactiveEnterTimestamp
     *
     * @param act Identifies a previous invocation of
     * onInactiveEnterTimestampGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendInactiveEnterTimestampGetUpdate(uint64 inactiveEnterTimestamp, act_t act = 0);

    /**
     * Set the value of the property 'InactiveEnterTimestamp' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'InactiveEnterTimestamp'</b>:
     *
     * InactiveEnterTimestamp
     */
    void setInactiveEnterTimestamp(uint64 inactiveEnterTimestamp);

    /**
     * Returns the current value of the property 'InactiveEnterTimestamp'.
     *
     * <b>Documentation of 'InactiveEnterTimestamp'</b>:
     *
     * InactiveEnterTimestamp
     */
    uint64 getInactiveEnterTimestamp() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendInactiveEnterTimestampUpdate().
     *
     * <b>Documentation of 'InactiveEnterTimestamp'</b>:
     *
     * InactiveEnterTimestamp
     */
    void sendInactiveEnterTimestampUpdate();

    // property 'InactiveEnterTimestampMonotonic'

    /**
     * The method onInactiveEnterTimestampMonotonicGet() is called by ASF when
     * a client invokes the read method for the property
     * 'InactiveEnterTimestampMonotonic'. The
     * onInactiveEnterTimestampMonotonicGet() method returns by default the
     * current property value to the caller. In case this default behavior
     * doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'InactiveEnterTimestampMonotonic'</b>:
     *
     * InactiveEnterTimestampMonotonic
     */
    virtual void onInactiveEnterTimestampMonotonicGet(const ::boost::shared_ptr< InactiveEnterTimestampMonotonicGet >& payload);

    /**
     * Sends back the update to a previous
     * onInactiveEnterTimestampMonotonicGet().
     *
     * <b>Documentation of 'InactiveEnterTimestampMonotonic'</b>:
     *
     * InactiveEnterTimestampMonotonic
     *
     * @param act Identifies a previous invocation of
     * onInactiveEnterTimestampMonotonicGet(). If the act is not specified,
     * i.e. the most recent invocation will be answered. In case multiple
     * replies are pending an act must be specified. An assertion will be
     * thrown if no or multiple method invocation could be found.
     */
    void sendInactiveEnterTimestampMonotonicGetUpdate(uint64 inactiveEnterTimestampMonotonic, act_t act = 0);

    /**
     * Set the value of the property 'InactiveEnterTimestampMonotonic' and
     * send updates to registered clients. No updates will be sent if the
     * property value does not change.
     *
     * <b>Documentation of 'InactiveEnterTimestampMonotonic'</b>:
     *
     * InactiveEnterTimestampMonotonic
     */
    void setInactiveEnterTimestampMonotonic(uint64 inactiveEnterTimestampMonotonic);

    /**
     * Returns the current value of the property 'InactiveEnterTimestampMonotonic'.
     *
     * <b>Documentation of 'InactiveEnterTimestampMonotonic'</b>:
     *
     * InactiveEnterTimestampMonotonic
     */
    uint64 getInactiveEnterTimestampMonotonic() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendInactiveEnterTimestampMonotonicUpdate().
     *
     * <b>Documentation of 'InactiveEnterTimestampMonotonic'</b>:
     *
     * InactiveEnterTimestampMonotonic
     */
    void sendInactiveEnterTimestampMonotonicUpdate();

    // property 'CanStart'

    /**
     * The method onCanStartGet() is called by ASF when a client invokes the
     * read method for the property 'CanStart'. The onCanStartGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'CanStart'</b>:
     *
     * CanStart encodes as booleans whether the unit supports the start operation. Even if a unit supports such an operation
     * 		the client might not necessary have the right privileges to execute them.
     */
    virtual void onCanStartGet(const ::boost::shared_ptr< CanStartGet >& payload);

    /**
     * Sends back the update to a previous onCanStartGet().
     *
     * <b>Documentation of 'CanStart'</b>:
     *
     * CanStart encodes as booleans whether the unit supports the start operation. Even if a unit supports such an operation
     * 		the client might not necessary have the right privileges to execute them.
     *
     * @param act Identifies a previous invocation of onCanStartGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendCanStartGetUpdate(bool canStart, act_t act = 0);

    /**
     * Set the value of the property 'CanStart' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'CanStart'</b>:
     *
     * CanStart encodes as booleans whether the unit supports the start operation. Even if a unit supports such an operation
     * 		the client might not necessary have the right privileges to execute them.
     */
    void setCanStart(bool canStart);

    /**
     * Returns the current value of the property 'CanStart'.
     *
     * <b>Documentation of 'CanStart'</b>:
     *
     * CanStart encodes as booleans whether the unit supports the start operation. Even if a unit supports such an operation
     * 		the client might not necessary have the right privileges to execute them.
     */
    bool getCanStart() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendCanStartUpdate().
     *
     * <b>Documentation of 'CanStart'</b>:
     *
     * CanStart encodes as booleans whether the unit supports the start operation. Even if a unit supports such an operation
     * 		the client might not necessary have the right privileges to execute them.
     */
    void sendCanStartUpdate();

    // property 'CanStop'

    /**
     * The method onCanStopGet() is called by ASF when a client invokes the
     * read method for the property 'CanStop'. The onCanStopGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'CanStop'</b>:
     *
     * CanStop encodes as booleans whether the unit supports the stop operation. Even if a unit supports such an operation
     * 		the client might not necessary have the right privileges to execute them.
     */
    virtual void onCanStopGet(const ::boost::shared_ptr< CanStopGet >& payload);

    /**
     * Sends back the update to a previous onCanStopGet().
     *
     * <b>Documentation of 'CanStop'</b>:
     *
     * CanStop encodes as booleans whether the unit supports the stop operation. Even if a unit supports such an operation
     * 		the client might not necessary have the right privileges to execute them.
     *
     * @param act Identifies a previous invocation of onCanStopGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendCanStopGetUpdate(bool canStop, act_t act = 0);

    /**
     * Set the value of the property 'CanStop' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'CanStop'</b>:
     *
     * CanStop encodes as booleans whether the unit supports the stop operation. Even if a unit supports such an operation
     * 		the client might not necessary have the right privileges to execute them.
     */
    void setCanStop(bool canStop);

    /**
     * Returns the current value of the property 'CanStop'.
     *
     * <b>Documentation of 'CanStop'</b>:
     *
     * CanStop encodes as booleans whether the unit supports the stop operation. Even if a unit supports such an operation
     * 		the client might not necessary have the right privileges to execute them.
     */
    bool getCanStop() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendCanStopUpdate().
     *
     * <b>Documentation of 'CanStop'</b>:
     *
     * CanStop encodes as booleans whether the unit supports the stop operation. Even if a unit supports such an operation
     * 		the client might not necessary have the right privileges to execute them.
     */
    void sendCanStopUpdate();

    // property 'CanReload'

    /**
     * The method onCanReloadGet() is called by ASF when a client invokes the
     * read method for the property 'CanReload'. The onCanReloadGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'CanReload'</b>:
     *
     * CanReload encodes as booleans whether the unit supports the reload operation. Even if a unit supports such an operation
     * 		the client might not necessary have the right privileges to execute them.
     */
    virtual void onCanReloadGet(const ::boost::shared_ptr< CanReloadGet >& payload);

    /**
     * Sends back the update to a previous onCanReloadGet().
     *
     * <b>Documentation of 'CanReload'</b>:
     *
     * CanReload encodes as booleans whether the unit supports the reload operation. Even if a unit supports such an operation
     * 		the client might not necessary have the right privileges to execute them.
     *
     * @param act Identifies a previous invocation of onCanReloadGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendCanReloadGetUpdate(bool canReload, act_t act = 0);

    /**
     * Set the value of the property 'CanReload' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'CanReload'</b>:
     *
     * CanReload encodes as booleans whether the unit supports the reload operation. Even if a unit supports such an operation
     * 		the client might not necessary have the right privileges to execute them.
     */
    void setCanReload(bool canReload);

    /**
     * Returns the current value of the property 'CanReload'.
     *
     * <b>Documentation of 'CanReload'</b>:
     *
     * CanReload encodes as booleans whether the unit supports the reload operation. Even if a unit supports such an operation
     * 		the client might not necessary have the right privileges to execute them.
     */
    bool getCanReload() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendCanReloadUpdate().
     *
     * <b>Documentation of 'CanReload'</b>:
     *
     * CanReload encodes as booleans whether the unit supports the reload operation. Even if a unit supports such an operation
     * 		the client might not necessary have the right privileges to execute them.
     */
    void sendCanReloadUpdate();

    // property 'CanIsolate'

    /**
     * The method onCanIsolateGet() is called by ASF when a client invokes the
     * read method for the property 'CanIsolate'. The onCanIsolateGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'CanIsolate'</b>:
     *
     * CanIsolate encodes as boolean whether the unit may be started in isolation mode.
     */
    virtual void onCanIsolateGet(const ::boost::shared_ptr< CanIsolateGet >& payload);

    /**
     * Sends back the update to a previous onCanIsolateGet().
     *
     * <b>Documentation of 'CanIsolate'</b>:
     *
     * CanIsolate encodes as boolean whether the unit may be started in isolation mode.
     *
     * @param act Identifies a previous invocation of onCanIsolateGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendCanIsolateGetUpdate(bool canIsolate, act_t act = 0);

    /**
     * Set the value of the property 'CanIsolate' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'CanIsolate'</b>:
     *
     * CanIsolate encodes as boolean whether the unit may be started in isolation mode.
     */
    void setCanIsolate(bool canIsolate);

    /**
     * Returns the current value of the property 'CanIsolate'.
     *
     * <b>Documentation of 'CanIsolate'</b>:
     *
     * CanIsolate encodes as boolean whether the unit may be started in isolation mode.
     */
    bool getCanIsolate() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendCanIsolateUpdate().
     *
     * <b>Documentation of 'CanIsolate'</b>:
     *
     * CanIsolate encodes as boolean whether the unit may be started in isolation mode.
     */
    void sendCanIsolateUpdate();

    // property 'Job'

    /**
     * The method onJobGet() is called by ASF when a client invokes the read
     * method for the property 'Job'. The onJobGet() method returns by default
     * the current property value to the caller. In case this default behavior
     * doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'Job'</b>:
     *
     * Job encodes the job ID and job object path of the job currently scheduled or executed for this unit, if there is any.
     * 		If no job is scheduled or executed the job id field will be 0.
     */
    virtual void onJobGet(const ::boost::shared_ptr< JobGet >& payload);

    /**
     * Sends back the update to a previous onJobGet().
     *
     * <b>Documentation of 'Job'</b>:
     *
     * Job encodes the job ID and job object path of the job currently scheduled or executed for this unit, if there is any.
     * 		If no job is scheduled or executed the job id field will be 0.
     *
     * @param act Identifies a previous invocation of onJobGet(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendJobGetUpdate(const job& job, act_t act = 0);

    /**
     * Set the value of the property 'Job' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Job'</b>:
     *
     * Job encodes the job ID and job object path of the job currently scheduled or executed for this unit, if there is any.
     * 		If no job is scheduled or executed the job id field will be 0.
     */
    void setJob(const job& job);

    /**
     * Returns the current value of the property 'Job'.
     *
     * <b>Documentation of 'Job'</b>:
     *
     * Job encodes the job ID and job object path of the job currently scheduled or executed for this unit, if there is any.
     * 		If no job is scheduled or executed the job id field will be 0.
     */
    const job& getJob() const;

    /**
     * Returns the current value of the property 'Job' as a mutable reference.
     * If you change the content of the returned object you have to send
     * updates to registered clients by yourself with the help of the
     * sendJobUpdate() method.
     *
     * <b>Documentation of 'Job'</b>:
     *
     * Job encodes the job ID and job object path of the job currently scheduled or executed for this unit, if there is any.
     * 		If no job is scheduled or executed the job id field will be 0.
     */
    job& getJobMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendJobUpdate().
     *
     * <b>Documentation of 'Job'</b>:
     *
     * Job encodes the job ID and job object path of the job currently scheduled or executed for this unit, if there is any.
     * 		If no job is scheduled or executed the job id field will be 0.
     */
    void sendJobUpdate();

    // property 'StopWhenUnneeded'

    /**
     * The method onStopWhenUnneededGet() is called by ASF when a client
     * invokes the read method for the property 'StopWhenUnneeded'. The
     * onStopWhenUnneededGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'StopWhenUnneeded'</b>:
     *
     * StopWhenUnneeded map directly to the corresponding configuration booleans in the unit file.
     */
    virtual void onStopWhenUnneededGet(const ::boost::shared_ptr< StopWhenUnneededGet >& payload);

    /**
     * Sends back the update to a previous onStopWhenUnneededGet().
     *
     * <b>Documentation of 'StopWhenUnneeded'</b>:
     *
     * StopWhenUnneeded map directly to the corresponding configuration booleans in the unit file.
     *
     * @param act Identifies a previous invocation of onStopWhenUnneededGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendStopWhenUnneededGetUpdate(bool stopWhenUnneeded, act_t act = 0);

    /**
     * Set the value of the property 'StopWhenUnneeded' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'StopWhenUnneeded'</b>:
     *
     * StopWhenUnneeded map directly to the corresponding configuration booleans in the unit file.
     */
    void setStopWhenUnneeded(bool stopWhenUnneeded);

    /**
     * Returns the current value of the property 'StopWhenUnneeded'.
     *
     * <b>Documentation of 'StopWhenUnneeded'</b>:
     *
     * StopWhenUnneeded map directly to the corresponding configuration booleans in the unit file.
     */
    bool getStopWhenUnneeded() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendStopWhenUnneededUpdate().
     *
     * <b>Documentation of 'StopWhenUnneeded'</b>:
     *
     * StopWhenUnneeded map directly to the corresponding configuration booleans in the unit file.
     */
    void sendStopWhenUnneededUpdate();

    // property 'RefuseManualStart'

    /**
     * The method onRefuseManualStartGet() is called by ASF when a client
     * invokes the read method for the property 'RefuseManualStart'. The
     * onRefuseManualStartGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'RefuseManualStart'</b>:
     *
     * RefuseManualStart map directly to the corresponding configuration booleans in the unit file.
     */
    virtual void onRefuseManualStartGet(const ::boost::shared_ptr< RefuseManualStartGet >& payload);

    /**
     * Sends back the update to a previous onRefuseManualStartGet().
     *
     * <b>Documentation of 'RefuseManualStart'</b>:
     *
     * RefuseManualStart map directly to the corresponding configuration booleans in the unit file.
     *
     * @param act Identifies a previous invocation of
     * onRefuseManualStartGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRefuseManualStartGetUpdate(bool refuseManualStart, act_t act = 0);

    /**
     * Set the value of the property 'RefuseManualStart' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'RefuseManualStart'</b>:
     *
     * RefuseManualStart map directly to the corresponding configuration booleans in the unit file.
     */
    void setRefuseManualStart(bool refuseManualStart);

    /**
     * Returns the current value of the property 'RefuseManualStart'.
     *
     * <b>Documentation of 'RefuseManualStart'</b>:
     *
     * RefuseManualStart map directly to the corresponding configuration booleans in the unit file.
     */
    bool getRefuseManualStart() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendRefuseManualStartUpdate().
     *
     * <b>Documentation of 'RefuseManualStart'</b>:
     *
     * RefuseManualStart map directly to the corresponding configuration booleans in the unit file.
     */
    void sendRefuseManualStartUpdate();

    // property 'RefuseManualStop'

    /**
     * The method onRefuseManualStopGet() is called by ASF when a client
     * invokes the read method for the property 'RefuseManualStop'. The
     * onRefuseManualStopGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'RefuseManualStop'</b>:
     *
     * RefuseManualStop map directly to the corresponding configuration booleans in the unit file.
     */
    virtual void onRefuseManualStopGet(const ::boost::shared_ptr< RefuseManualStopGet >& payload);

    /**
     * Sends back the update to a previous onRefuseManualStopGet().
     *
     * <b>Documentation of 'RefuseManualStop'</b>:
     *
     * RefuseManualStop map directly to the corresponding configuration booleans in the unit file.
     *
     * @param act Identifies a previous invocation of onRefuseManualStopGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendRefuseManualStopGetUpdate(bool refuseManualStop, act_t act = 0);

    /**
     * Set the value of the property 'RefuseManualStop' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'RefuseManualStop'</b>:
     *
     * RefuseManualStop map directly to the corresponding configuration booleans in the unit file.
     */
    void setRefuseManualStop(bool refuseManualStop);

    /**
     * Returns the current value of the property 'RefuseManualStop'.
     *
     * <b>Documentation of 'RefuseManualStop'</b>:
     *
     * RefuseManualStop map directly to the corresponding configuration booleans in the unit file.
     */
    bool getRefuseManualStop() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendRefuseManualStopUpdate().
     *
     * <b>Documentation of 'RefuseManualStop'</b>:
     *
     * RefuseManualStop map directly to the corresponding configuration booleans in the unit file.
     */
    void sendRefuseManualStopUpdate();

    // property 'AllowIsolate'

    /**
     * The method onAllowIsolateGet() is called by ASF when a client invokes
     * the read method for the property 'AllowIsolate'. The
     * onAllowIsolateGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'AllowIsolate'</b>:
     *
     * AllowIsolate map directly to the corresponding configuration booleans in the unit file.
     */
    virtual void onAllowIsolateGet(const ::boost::shared_ptr< AllowIsolateGet >& payload);

    /**
     * Sends back the update to a previous onAllowIsolateGet().
     *
     * <b>Documentation of 'AllowIsolate'</b>:
     *
     * AllowIsolate map directly to the corresponding configuration booleans in the unit file.
     *
     * @param act Identifies a previous invocation of onAllowIsolateGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendAllowIsolateGetUpdate(bool allowIsolate, act_t act = 0);

    /**
     * Set the value of the property 'AllowIsolate' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'AllowIsolate'</b>:
     *
     * AllowIsolate map directly to the corresponding configuration booleans in the unit file.
     */
    void setAllowIsolate(bool allowIsolate);

    /**
     * Returns the current value of the property 'AllowIsolate'.
     *
     * <b>Documentation of 'AllowIsolate'</b>:
     *
     * AllowIsolate map directly to the corresponding configuration booleans in the unit file.
     */
    bool getAllowIsolate() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendAllowIsolateUpdate().
     *
     * <b>Documentation of 'AllowIsolate'</b>:
     *
     * AllowIsolate map directly to the corresponding configuration booleans in the unit file.
     */
    void sendAllowIsolateUpdate();

    // property 'DefaultDependencies'

    /**
     * The method onDefaultDependenciesGet() is called by ASF when a client
     * invokes the read method for the property 'DefaultDependencies'. The
     * onDefaultDependenciesGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'DefaultDependencies'</b>:
     *
     * DefaultDependencies map directly to the corresponding configuration booleans in the unit file.
     */
    virtual void onDefaultDependenciesGet(const ::boost::shared_ptr< DefaultDependenciesGet >& payload);

    /**
     * Sends back the update to a previous onDefaultDependenciesGet().
     *
     * <b>Documentation of 'DefaultDependencies'</b>:
     *
     * DefaultDependencies map directly to the corresponding configuration booleans in the unit file.
     *
     * @param act Identifies a previous invocation of
     * onDefaultDependenciesGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendDefaultDependenciesGetUpdate(bool defaultDependencies, act_t act = 0);

    /**
     * Set the value of the property 'DefaultDependencies' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'DefaultDependencies'</b>:
     *
     * DefaultDependencies map directly to the corresponding configuration booleans in the unit file.
     */
    void setDefaultDependencies(bool defaultDependencies);

    /**
     * Returns the current value of the property 'DefaultDependencies'.
     *
     * <b>Documentation of 'DefaultDependencies'</b>:
     *
     * DefaultDependencies map directly to the corresponding configuration booleans in the unit file.
     */
    bool getDefaultDependencies() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendDefaultDependenciesUpdate().
     *
     * <b>Documentation of 'DefaultDependencies'</b>:
     *
     * DefaultDependencies map directly to the corresponding configuration booleans in the unit file.
     */
    void sendDefaultDependenciesUpdate();

    // property 'OnFailureJobMode'

    /**
     * The method onOnFailureJobModeGet() is called by ASF when a client
     * invokes the read method for the property 'OnFailureJobMode'. The
     * onOnFailureJobModeGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'OnFailureJobMode'</b>:
     *
     * OnFailureJobMode
     */
    virtual void onOnFailureJobModeGet(const ::boost::shared_ptr< OnFailureJobModeGet >& payload);

    /**
     * Sends back the update to a previous onOnFailureJobModeGet().
     *
     * <b>Documentation of 'OnFailureJobMode'</b>:
     *
     * OnFailureJobMode
     *
     * @param act Identifies a previous invocation of onOnFailureJobModeGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendOnFailureJobModeGetUpdate(const ::std::string& onFailureJobMode, act_t act = 0);

    /**
     * Set the value of the property 'OnFailureJobMode' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'OnFailureJobMode'</b>:
     *
     * OnFailureJobMode
     */
    void setOnFailureJobMode(const ::std::string& onFailureJobMode);

    /**
     * Returns the current value of the property 'OnFailureJobMode'.
     *
     * <b>Documentation of 'OnFailureJobMode'</b>:
     *
     * OnFailureJobMode
     */
    const ::std::string& getOnFailureJobMode() const;

    /**
     * Returns the current value of the property 'OnFailureJobMode' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendOnFailureJobModeUpdate() method.
     *
     * <b>Documentation of 'OnFailureJobMode'</b>:
     *
     * OnFailureJobMode
     */
    ::std::string& getOnFailureJobModeMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendOnFailureJobModeUpdate().
     *
     * <b>Documentation of 'OnFailureJobMode'</b>:
     *
     * OnFailureJobMode
     */
    void sendOnFailureJobModeUpdate();

    // property 'IgnoreOnIsolate'

    /**
     * The method onIgnoreOnIsolateGet() is called by ASF when a client
     * invokes the read method for the property 'IgnoreOnIsolate'. The
     * onIgnoreOnIsolateGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'IgnoreOnIsolate'</b>:
     *
     * IgnoreOnIsolate map directly to the corresponding configuration booleans in the unit file.
     */
    virtual void onIgnoreOnIsolateGet(const ::boost::shared_ptr< IgnoreOnIsolateGet >& payload);

    /**
     * Sends back the update to a previous onIgnoreOnIsolateGet().
     *
     * <b>Documentation of 'IgnoreOnIsolate'</b>:
     *
     * IgnoreOnIsolate map directly to the corresponding configuration booleans in the unit file.
     *
     * @param act Identifies a previous invocation of onIgnoreOnIsolateGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendIgnoreOnIsolateGetUpdate(bool ignoreOnIsolate, act_t act = 0);

    /**
     * Set the value of the property 'IgnoreOnIsolate' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'IgnoreOnIsolate'</b>:
     *
     * IgnoreOnIsolate map directly to the corresponding configuration booleans in the unit file.
     */
    void setIgnoreOnIsolate(bool ignoreOnIsolate);

    /**
     * Returns the current value of the property 'IgnoreOnIsolate'.
     *
     * <b>Documentation of 'IgnoreOnIsolate'</b>:
     *
     * IgnoreOnIsolate map directly to the corresponding configuration booleans in the unit file.
     */
    bool getIgnoreOnIsolate() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendIgnoreOnIsolateUpdate().
     *
     * <b>Documentation of 'IgnoreOnIsolate'</b>:
     *
     * IgnoreOnIsolate map directly to the corresponding configuration booleans in the unit file.
     */
    void sendIgnoreOnIsolateUpdate();

    // property 'IgnoreOnSnapshot'

    /**
     * The method onIgnoreOnSnapshotGet() is called by ASF when a client
     * invokes the read method for the property 'IgnoreOnSnapshot'. The
     * onIgnoreOnSnapshotGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'IgnoreOnSnapshot'</b>:
     *
     * IgnoreOnSnapshot map directly to the corresponding configuration booleans in the unit file.
     */
    virtual void onIgnoreOnSnapshotGet(const ::boost::shared_ptr< IgnoreOnSnapshotGet >& payload);

    /**
     * Sends back the update to a previous onIgnoreOnSnapshotGet().
     *
     * <b>Documentation of 'IgnoreOnSnapshot'</b>:
     *
     * IgnoreOnSnapshot map directly to the corresponding configuration booleans in the unit file.
     *
     * @param act Identifies a previous invocation of onIgnoreOnSnapshotGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendIgnoreOnSnapshotGetUpdate(bool ignoreOnSnapshot, act_t act = 0);

    /**
     * Set the value of the property 'IgnoreOnSnapshot' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'IgnoreOnSnapshot'</b>:
     *
     * IgnoreOnSnapshot map directly to the corresponding configuration booleans in the unit file.
     */
    void setIgnoreOnSnapshot(bool ignoreOnSnapshot);

    /**
     * Returns the current value of the property 'IgnoreOnSnapshot'.
     *
     * <b>Documentation of 'IgnoreOnSnapshot'</b>:
     *
     * IgnoreOnSnapshot map directly to the corresponding configuration booleans in the unit file.
     */
    bool getIgnoreOnSnapshot() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendIgnoreOnSnapshotUpdate().
     *
     * <b>Documentation of 'IgnoreOnSnapshot'</b>:
     *
     * IgnoreOnSnapshot map directly to the corresponding configuration booleans in the unit file.
     */
    void sendIgnoreOnSnapshotUpdate();

    // property 'NeedDaemonReload'

    /**
     * The method onNeedDaemonReloadGet() is called by ASF when a client
     * invokes the read method for the property 'NeedDaemonReload'. The
     * onNeedDaemonReloadGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'NeedDaemonReload'</b>:
     *
     * NeedDaemonReload is a boolean that indicates whether the configuration file this unit is loaded from (i.e. FragmentPath or SourcePath)
     * 		has changed since the configuration was read and hence whether a configuration reload is recommended.
     */
    virtual void onNeedDaemonReloadGet(const ::boost::shared_ptr< NeedDaemonReloadGet >& payload);

    /**
     * Sends back the update to a previous onNeedDaemonReloadGet().
     *
     * <b>Documentation of 'NeedDaemonReload'</b>:
     *
     * NeedDaemonReload is a boolean that indicates whether the configuration file this unit is loaded from (i.e. FragmentPath or SourcePath)
     * 		has changed since the configuration was read and hence whether a configuration reload is recommended.
     *
     * @param act Identifies a previous invocation of onNeedDaemonReloadGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendNeedDaemonReloadGetUpdate(bool needDaemonReload, act_t act = 0);

    /**
     * Set the value of the property 'NeedDaemonReload' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'NeedDaemonReload'</b>:
     *
     * NeedDaemonReload is a boolean that indicates whether the configuration file this unit is loaded from (i.e. FragmentPath or SourcePath)
     * 		has changed since the configuration was read and hence whether a configuration reload is recommended.
     */
    void setNeedDaemonReload(bool needDaemonReload);

    /**
     * Returns the current value of the property 'NeedDaemonReload'.
     *
     * <b>Documentation of 'NeedDaemonReload'</b>:
     *
     * NeedDaemonReload is a boolean that indicates whether the configuration file this unit is loaded from (i.e. FragmentPath or SourcePath)
     * 		has changed since the configuration was read and hence whether a configuration reload is recommended.
     */
    bool getNeedDaemonReload() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendNeedDaemonReloadUpdate().
     *
     * <b>Documentation of 'NeedDaemonReload'</b>:
     *
     * NeedDaemonReload is a boolean that indicates whether the configuration file this unit is loaded from (i.e. FragmentPath or SourcePath)
     * 		has changed since the configuration was read and hence whether a configuration reload is recommended.
     */
    void sendNeedDaemonReloadUpdate();

    // property 'JobTimeoutUSec'

    /**
     * The method onJobTimeoutUSecGet() is called by ASF when a client invokes
     * the read method for the property 'JobTimeoutUSec'. The
     * onJobTimeoutUSecGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'JobTimeoutUSec'</b>:
     *
     * JobTimeoutUSec maps directly to the corresponding configuration setting in the unit file.
     */
    virtual void onJobTimeoutUSecGet(const ::boost::shared_ptr< JobTimeoutUSecGet >& payload);

    /**
     * Sends back the update to a previous onJobTimeoutUSecGet().
     *
     * <b>Documentation of 'JobTimeoutUSec'</b>:
     *
     * JobTimeoutUSec maps directly to the corresponding configuration setting in the unit file.
     *
     * @param act Identifies a previous invocation of onJobTimeoutUSecGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendJobTimeoutUSecGetUpdate(uint64 jobTimeoutUSec, act_t act = 0);

    /**
     * Set the value of the property 'JobTimeoutUSec' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'JobTimeoutUSec'</b>:
     *
     * JobTimeoutUSec maps directly to the corresponding configuration setting in the unit file.
     */
    void setJobTimeoutUSec(uint64 jobTimeoutUSec);

    /**
     * Returns the current value of the property 'JobTimeoutUSec'.
     *
     * <b>Documentation of 'JobTimeoutUSec'</b>:
     *
     * JobTimeoutUSec maps directly to the corresponding configuration setting in the unit file.
     */
    uint64 getJobTimeoutUSec() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendJobTimeoutUSecUpdate().
     *
     * <b>Documentation of 'JobTimeoutUSec'</b>:
     *
     * JobTimeoutUSec maps directly to the corresponding configuration setting in the unit file.
     */
    void sendJobTimeoutUSecUpdate();

    // property 'JobTimeoutAction'

    /**
     * The method onJobTimeoutActionGet() is called by ASF when a client
     * invokes the read method for the property 'JobTimeoutAction'. The
     * onJobTimeoutActionGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'JobTimeoutAction'</b>:
     *
     * JobTimeoutAction
     */
    virtual void onJobTimeoutActionGet(const ::boost::shared_ptr< JobTimeoutActionGet >& payload);

    /**
     * Sends back the update to a previous onJobTimeoutActionGet().
     *
     * <b>Documentation of 'JobTimeoutAction'</b>:
     *
     * JobTimeoutAction
     *
     * @param act Identifies a previous invocation of onJobTimeoutActionGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendJobTimeoutActionGetUpdate(const ::std::string& jobTimeoutAction, act_t act = 0);

    /**
     * Set the value of the property 'JobTimeoutAction' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'JobTimeoutAction'</b>:
     *
     * JobTimeoutAction
     */
    void setJobTimeoutAction(const ::std::string& jobTimeoutAction);

    /**
     * Returns the current value of the property 'JobTimeoutAction'.
     *
     * <b>Documentation of 'JobTimeoutAction'</b>:
     *
     * JobTimeoutAction
     */
    const ::std::string& getJobTimeoutAction() const;

    /**
     * Returns the current value of the property 'JobTimeoutAction' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendJobTimeoutActionUpdate() method.
     *
     * <b>Documentation of 'JobTimeoutAction'</b>:
     *
     * JobTimeoutAction
     */
    ::std::string& getJobTimeoutActionMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendJobTimeoutActionUpdate().
     *
     * <b>Documentation of 'JobTimeoutAction'</b>:
     *
     * JobTimeoutAction
     */
    void sendJobTimeoutActionUpdate();

    // property 'JobTimeoutRebootArgument'

    /**
     * The method onJobTimeoutRebootArgumentGet() is called by ASF when a
     * client invokes the read method for the property
     * 'JobTimeoutRebootArgument'. The onJobTimeoutRebootArgumentGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'JobTimeoutRebootArgument'</b>:
     *
     * JobTimeoutRebootArgument
     */
    virtual void onJobTimeoutRebootArgumentGet(const ::boost::shared_ptr< JobTimeoutRebootArgumentGet >& payload);

    /**
     * Sends back the update to a previous onJobTimeoutRebootArgumentGet().
     *
     * <b>Documentation of 'JobTimeoutRebootArgument'</b>:
     *
     * JobTimeoutRebootArgument
     *
     * @param act Identifies a previous invocation of
     * onJobTimeoutRebootArgumentGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendJobTimeoutRebootArgumentGetUpdate(const ::std::string& jobTimeoutRebootArgument, act_t act = 0);

    /**
     * Set the value of the property 'JobTimeoutRebootArgument' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'JobTimeoutRebootArgument'</b>:
     *
     * JobTimeoutRebootArgument
     */
    void setJobTimeoutRebootArgument(const ::std::string& jobTimeoutRebootArgument);

    /**
     * Returns the current value of the property 'JobTimeoutRebootArgument'.
     *
     * <b>Documentation of 'JobTimeoutRebootArgument'</b>:
     *
     * JobTimeoutRebootArgument
     */
    const ::std::string& getJobTimeoutRebootArgument() const;

    /**
     * Returns the current value of the property 'JobTimeoutRebootArgument' as
     * a mutable reference. If you change the content of the returned object
     * you have to send updates to registered clients by yourself with the
     * help of the sendJobTimeoutRebootArgumentUpdate() method.
     *
     * <b>Documentation of 'JobTimeoutRebootArgument'</b>:
     *
     * JobTimeoutRebootArgument
     */
    ::std::string& getJobTimeoutRebootArgumentMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendJobTimeoutRebootArgumentUpdate().
     *
     * <b>Documentation of 'JobTimeoutRebootArgument'</b>:
     *
     * JobTimeoutRebootArgument
     */
    void sendJobTimeoutRebootArgumentUpdate();

    // property 'ConditionResult'

    /**
     * The method onConditionResultGet() is called by ASF when a client
     * invokes the read method for the property 'ConditionResult'. The
     * onConditionResultGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'ConditionResult'</b>:
     *
     * ConditionResult contains the condition result of the last time the configured
     * 		conditions of this unit were checked.
     */
    virtual void onConditionResultGet(const ::boost::shared_ptr< ConditionResultGet >& payload);

    /**
     * Sends back the update to a previous onConditionResultGet().
     *
     * <b>Documentation of 'ConditionResult'</b>:
     *
     * ConditionResult contains the condition result of the last time the configured
     * 		conditions of this unit were checked.
     *
     * @param act Identifies a previous invocation of onConditionResultGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendConditionResultGetUpdate(bool conditionResult, act_t act = 0);

    /**
     * Set the value of the property 'ConditionResult' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'ConditionResult'</b>:
     *
     * ConditionResult contains the condition result of the last time the configured
     * 		conditions of this unit were checked.
     */
    void setConditionResult(bool conditionResult);

    /**
     * Returns the current value of the property 'ConditionResult'.
     *
     * <b>Documentation of 'ConditionResult'</b>:
     *
     * ConditionResult contains the condition result of the last time the configured
     * 		conditions of this unit were checked.
     */
    bool getConditionResult() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendConditionResultUpdate().
     *
     * <b>Documentation of 'ConditionResult'</b>:
     *
     * ConditionResult contains the condition result of the last time the configured
     * 		conditions of this unit were checked.
     */
    void sendConditionResultUpdate();

    // property 'AssertResult'

    /**
     * The method onAssertResultGet() is called by ASF when a client invokes
     * the read method for the property 'AssertResult'. The
     * onAssertResultGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'AssertResult'</b>:
     *
     * AssertResult
     */
    virtual void onAssertResultGet(const ::boost::shared_ptr< AssertResultGet >& payload);

    /**
     * Sends back the update to a previous onAssertResultGet().
     *
     * <b>Documentation of 'AssertResult'</b>:
     *
     * AssertResult
     *
     * @param act Identifies a previous invocation of onAssertResultGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendAssertResultGetUpdate(bool assertResult, act_t act = 0);

    /**
     * Set the value of the property 'AssertResult' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'AssertResult'</b>:
     *
     * AssertResult
     */
    void setAssertResult(bool assertResult);

    /**
     * Returns the current value of the property 'AssertResult'.
     *
     * <b>Documentation of 'AssertResult'</b>:
     *
     * AssertResult
     */
    bool getAssertResult() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendAssertResultUpdate().
     *
     * <b>Documentation of 'AssertResult'</b>:
     *
     * AssertResult
     */
    void sendAssertResultUpdate();

    // property 'ConditionTimestamp'

    /**
     * The method onConditionTimestampGet() is called by ASF when a client
     * invokes the read method for the property 'ConditionTimestamp'. The
     * onConditionTimestampGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'ConditionTimestamp'</b>:
     *
     * ConditionTimestamp contain the CLOCK_REALTIME/CLOCK_MONOTONIC usec timestamps of the last time the configured conditions of the unit have been checked,
     * 		or 0 if they have never been checked. Conditions are checked when a unit is requested to start.
     */
    virtual void onConditionTimestampGet(const ::boost::shared_ptr< ConditionTimestampGet >& payload);

    /**
     * Sends back the update to a previous onConditionTimestampGet().
     *
     * <b>Documentation of 'ConditionTimestamp'</b>:
     *
     * ConditionTimestamp contain the CLOCK_REALTIME/CLOCK_MONOTONIC usec timestamps of the last time the configured conditions of the unit have been checked,
     * 		or 0 if they have never been checked. Conditions are checked when a unit is requested to start.
     *
     * @param act Identifies a previous invocation of
     * onConditionTimestampGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendConditionTimestampGetUpdate(uint64 conditionTimestamp, act_t act = 0);

    /**
     * Set the value of the property 'ConditionTimestamp' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'ConditionTimestamp'</b>:
     *
     * ConditionTimestamp contain the CLOCK_REALTIME/CLOCK_MONOTONIC usec timestamps of the last time the configured conditions of the unit have been checked,
     * 		or 0 if they have never been checked. Conditions are checked when a unit is requested to start.
     */
    void setConditionTimestamp(uint64 conditionTimestamp);

    /**
     * Returns the current value of the property 'ConditionTimestamp'.
     *
     * <b>Documentation of 'ConditionTimestamp'</b>:
     *
     * ConditionTimestamp contain the CLOCK_REALTIME/CLOCK_MONOTONIC usec timestamps of the last time the configured conditions of the unit have been checked,
     * 		or 0 if they have never been checked. Conditions are checked when a unit is requested to start.
     */
    uint64 getConditionTimestamp() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendConditionTimestampUpdate().
     *
     * <b>Documentation of 'ConditionTimestamp'</b>:
     *
     * ConditionTimestamp contain the CLOCK_REALTIME/CLOCK_MONOTONIC usec timestamps of the last time the configured conditions of the unit have been checked,
     * 		or 0 if they have never been checked. Conditions are checked when a unit is requested to start.
     */
    void sendConditionTimestampUpdate();

    // property 'ConditionTimestampMonotonic'

    /**
     * The method onConditionTimestampMonotonicGet() is called by ASF when a
     * client invokes the read method for the property
     * 'ConditionTimestampMonotonic'. The onConditionTimestampMonotonicGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'ConditionTimestampMonotonic'</b>:
     *
     * ConditionTimestampMonotonic contain the CLOCK_REALTIME/CLOCK_MONOTONIC usec timestamps of the last time the configured conditions of the unit have been checked,
     * 		or 0 if they have never been checked. Conditions are checked when a unit is requested to start.
     */
    virtual void onConditionTimestampMonotonicGet(const ::boost::shared_ptr< ConditionTimestampMonotonicGet >& payload);

    /**
     * Sends back the update to a previous onConditionTimestampMonotonicGet().
     *
     * <b>Documentation of 'ConditionTimestampMonotonic'</b>:
     *
     * ConditionTimestampMonotonic contain the CLOCK_REALTIME/CLOCK_MONOTONIC usec timestamps of the last time the configured conditions of the unit have been checked,
     * 		or 0 if they have never been checked. Conditions are checked when a unit is requested to start.
     *
     * @param act Identifies a previous invocation of
     * onConditionTimestampMonotonicGet(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendConditionTimestampMonotonicGetUpdate(uint64 conditionTimestampMonotonic, act_t act = 0);

    /**
     * Set the value of the property 'ConditionTimestampMonotonic' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'ConditionTimestampMonotonic'</b>:
     *
     * ConditionTimestampMonotonic contain the CLOCK_REALTIME/CLOCK_MONOTONIC usec timestamps of the last time the configured conditions of the unit have been checked,
     * 		or 0 if they have never been checked. Conditions are checked when a unit is requested to start.
     */
    void setConditionTimestampMonotonic(uint64 conditionTimestampMonotonic);

    /**
     * Returns the current value of the property 'ConditionTimestampMonotonic'.
     *
     * <b>Documentation of 'ConditionTimestampMonotonic'</b>:
     *
     * ConditionTimestampMonotonic contain the CLOCK_REALTIME/CLOCK_MONOTONIC usec timestamps of the last time the configured conditions of the unit have been checked,
     * 		or 0 if they have never been checked. Conditions are checked when a unit is requested to start.
     */
    uint64 getConditionTimestampMonotonic() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendConditionTimestampMonotonicUpdate().
     *
     * <b>Documentation of 'ConditionTimestampMonotonic'</b>:
     *
     * ConditionTimestampMonotonic contain the CLOCK_REALTIME/CLOCK_MONOTONIC usec timestamps of the last time the configured conditions of the unit have been checked,
     * 		or 0 if they have never been checked. Conditions are checked when a unit is requested to start.
     */
    void sendConditionTimestampMonotonicUpdate();

    // property 'AssertTimestamp'

    /**
     * The method onAssertTimestampGet() is called by ASF when a client
     * invokes the read method for the property 'AssertTimestamp'. The
     * onAssertTimestampGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'AssertTimestamp'</b>:
     *
     * AssertTimestamp
     */
    virtual void onAssertTimestampGet(const ::boost::shared_ptr< AssertTimestampGet >& payload);

    /**
     * Sends back the update to a previous onAssertTimestampGet().
     *
     * <b>Documentation of 'AssertTimestamp'</b>:
     *
     * AssertTimestamp
     *
     * @param act Identifies a previous invocation of onAssertTimestampGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendAssertTimestampGetUpdate(uint64 assertTimestamp, act_t act = 0);

    /**
     * Set the value of the property 'AssertTimestamp' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'AssertTimestamp'</b>:
     *
     * AssertTimestamp
     */
    void setAssertTimestamp(uint64 assertTimestamp);

    /**
     * Returns the current value of the property 'AssertTimestamp'.
     *
     * <b>Documentation of 'AssertTimestamp'</b>:
     *
     * AssertTimestamp
     */
    uint64 getAssertTimestamp() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendAssertTimestampUpdate().
     *
     * <b>Documentation of 'AssertTimestamp'</b>:
     *
     * AssertTimestamp
     */
    void sendAssertTimestampUpdate();

    // property 'AssertTimestampMonotonic'

    /**
     * The method onAssertTimestampMonotonicGet() is called by ASF when a
     * client invokes the read method for the property
     * 'AssertTimestampMonotonic'. The onAssertTimestampMonotonicGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'AssertTimestampMonotonic'</b>:
     *
     * AssertTimestampMonotonic
     */
    virtual void onAssertTimestampMonotonicGet(const ::boost::shared_ptr< AssertTimestampMonotonicGet >& payload);

    /**
     * Sends back the update to a previous onAssertTimestampMonotonicGet().
     *
     * <b>Documentation of 'AssertTimestampMonotonic'</b>:
     *
     * AssertTimestampMonotonic
     *
     * @param act Identifies a previous invocation of
     * onAssertTimestampMonotonicGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendAssertTimestampMonotonicGetUpdate(uint64 assertTimestampMonotonic, act_t act = 0);

    /**
     * Set the value of the property 'AssertTimestampMonotonic' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'AssertTimestampMonotonic'</b>:
     *
     * AssertTimestampMonotonic
     */
    void setAssertTimestampMonotonic(uint64 assertTimestampMonotonic);

    /**
     * Returns the current value of the property 'AssertTimestampMonotonic'.
     *
     * <b>Documentation of 'AssertTimestampMonotonic'</b>:
     *
     * AssertTimestampMonotonic
     */
    uint64 getAssertTimestampMonotonic() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendAssertTimestampMonotonicUpdate().
     *
     * <b>Documentation of 'AssertTimestampMonotonic'</b>:
     *
     * AssertTimestampMonotonic
     */
    void sendAssertTimestampMonotonicUpdate();

    // property 'Conditions'

    /**
     * The method onConditionsGet() is called by ASF when a client invokes the
     * read method for the property 'Conditions'. The onConditionsGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Conditions'</b>:
     *
     * Conditions contains all configured conditions of the unit. For each condition five fields are given: condition type (e.g. ConditionPathExists),
     * 		whether the condition is a trigger condition, whether the condition is reversed, the right hand side of the condtion (e.g. the path in case of ConditionPathExists),
     * 		and the status. The status can be 0, in which case the condition hasn't been checked yet, a positive value, in which case the condition passed, or a negative value,
     * 		in which case the condition failed. Currently only 0, +1, and -1 are used, but additional values may be used in the future, retaining the meaning of zero/positive/negative values.
     */
    virtual void onConditionsGet(const ::boost::shared_ptr< ConditionsGet >& payload);

    /**
     * Sends back the update to a previous onConditionsGet().
     *
     * <b>Documentation of 'Conditions'</b>:
     *
     * Conditions contains all configured conditions of the unit. For each condition five fields are given: condition type (e.g. ConditionPathExists),
     * 		whether the condition is a trigger condition, whether the condition is reversed, the right hand side of the condtion (e.g. the path in case of ConditionPathExists),
     * 		and the status. The status can be 0, in which case the condition hasn't been checked yet, a positive value, in which case the condition passed, or a negative value,
     * 		in which case the condition failed. Currently only 0, +1, and -1 are used, but additional values may be used in the future, retaining the meaning of zero/positive/negative values.
     *
     * @param act Identifies a previous invocation of onConditionsGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendConditionsGetUpdate(const ::std::vector< condition >& conditions, act_t act = 0);

    /**
     * Set the value of the property 'Conditions' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'Conditions'</b>:
     *
     * Conditions contains all configured conditions of the unit. For each condition five fields are given: condition type (e.g. ConditionPathExists),
     * 		whether the condition is a trigger condition, whether the condition is reversed, the right hand side of the condtion (e.g. the path in case of ConditionPathExists),
     * 		and the status. The status can be 0, in which case the condition hasn't been checked yet, a positive value, in which case the condition passed, or a negative value,
     * 		in which case the condition failed. Currently only 0, +1, and -1 are used, but additional values may be used in the future, retaining the meaning of zero/positive/negative values.
     */
    void setConditions(const ::std::vector< condition >& conditions);

    /**
     * Returns the current value of the property 'Conditions'.
     *
     * <b>Documentation of 'Conditions'</b>:
     *
     * Conditions contains all configured conditions of the unit. For each condition five fields are given: condition type (e.g. ConditionPathExists),
     * 		whether the condition is a trigger condition, whether the condition is reversed, the right hand side of the condtion (e.g. the path in case of ConditionPathExists),
     * 		and the status. The status can be 0, in which case the condition hasn't been checked yet, a positive value, in which case the condition passed, or a negative value,
     * 		in which case the condition failed. Currently only 0, +1, and -1 are used, but additional values may be used in the future, retaining the meaning of zero/positive/negative values.
     */
    const ::std::vector< condition >& getConditions() const;

    /**
     * Returns the current value of the property 'Conditions' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendConditionsUpdate() method.
     *
     * <b>Documentation of 'Conditions'</b>:
     *
     * Conditions contains all configured conditions of the unit. For each condition five fields are given: condition type (e.g. ConditionPathExists),
     * 		whether the condition is a trigger condition, whether the condition is reversed, the right hand side of the condtion (e.g. the path in case of ConditionPathExists),
     * 		and the status. The status can be 0, in which case the condition hasn't been checked yet, a positive value, in which case the condition passed, or a negative value,
     * 		in which case the condition failed. Currently only 0, +1, and -1 are used, but additional values may be used in the future, retaining the meaning of zero/positive/negative values.
     */
    ::std::vector< condition >& getConditionsMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendConditionsUpdate().
     *
     * <b>Documentation of 'Conditions'</b>:
     *
     * Conditions contains all configured conditions of the unit. For each condition five fields are given: condition type (e.g. ConditionPathExists),
     * 		whether the condition is a trigger condition, whether the condition is reversed, the right hand side of the condtion (e.g. the path in case of ConditionPathExists),
     * 		and the status. The status can be 0, in which case the condition hasn't been checked yet, a positive value, in which case the condition passed, or a negative value,
     * 		in which case the condition failed. Currently only 0, +1, and -1 are used, but additional values may be used in the future, retaining the meaning of zero/positive/negative values.
     */
    void sendConditionsUpdate();

    // property 'Asserts'

    /**
     * The method onAssertsGet() is called by ASF when a client invokes the
     * read method for the property 'Asserts'. The onAssertsGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Asserts'</b>:
     *
     * Asserts
     */
    virtual void onAssertsGet(const ::boost::shared_ptr< AssertsGet >& payload);

    /**
     * Sends back the update to a previous onAssertsGet().
     *
     * <b>Documentation of 'Asserts'</b>:
     *
     * Asserts
     *
     * @param act Identifies a previous invocation of onAssertsGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendAssertsGetUpdate(const ::std::vector< condition >& asserts, act_t act = 0);

    /**
     * Set the value of the property 'Asserts' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Asserts'</b>:
     *
     * Asserts
     */
    void setAsserts(const ::std::vector< condition >& asserts);

    /**
     * Returns the current value of the property 'Asserts'.
     *
     * <b>Documentation of 'Asserts'</b>:
     *
     * Asserts
     */
    const ::std::vector< condition >& getAsserts() const;

    /**
     * Returns the current value of the property 'Asserts' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendAssertsUpdate() method.
     *
     * <b>Documentation of 'Asserts'</b>:
     *
     * Asserts
     */
    ::std::vector< condition >& getAssertsMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendAssertsUpdate().
     *
     * <b>Documentation of 'Asserts'</b>:
     *
     * Asserts
     */
    void sendAssertsUpdate();

    // property 'LoadError'

    /**
     * The method onLoadErrorGet() is called by ASF when a client invokes the
     * read method for the property 'LoadError'. The onLoadErrorGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'LoadError'</b>:
     *
     * LoadError contains a pair of strings. If the unit failed to load (as encoded in LoadState, see above),
     * 		then this will include a D-Bus error pair consisting of the error ID and an explanatory human readable string of what happened.
     * 		If it succeeded to load this will be a pair of empty strings.
     */
    virtual void onLoadErrorGet(const ::boost::shared_ptr< LoadErrorGet >& payload);

    /**
     * Sends back the update to a previous onLoadErrorGet().
     *
     * <b>Documentation of 'LoadError'</b>:
     *
     * LoadError contains a pair of strings. If the unit failed to load (as encoded in LoadState, see above),
     * 		then this will include a D-Bus error pair consisting of the error ID and an explanatory human readable string of what happened.
     * 		If it succeeded to load this will be a pair of empty strings.
     *
     * @param act Identifies a previous invocation of onLoadErrorGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendLoadErrorGetUpdate(const loadError& loadError, act_t act = 0);

    /**
     * Set the value of the property 'LoadError' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'LoadError'</b>:
     *
     * LoadError contains a pair of strings. If the unit failed to load (as encoded in LoadState, see above),
     * 		then this will include a D-Bus error pair consisting of the error ID and an explanatory human readable string of what happened.
     * 		If it succeeded to load this will be a pair of empty strings.
     */
    void setLoadError(const loadError& loadError);

    /**
     * Returns the current value of the property 'LoadError'.
     *
     * <b>Documentation of 'LoadError'</b>:
     *
     * LoadError contains a pair of strings. If the unit failed to load (as encoded in LoadState, see above),
     * 		then this will include a D-Bus error pair consisting of the error ID and an explanatory human readable string of what happened.
     * 		If it succeeded to load this will be a pair of empty strings.
     */
    const loadError& getLoadError() const;

    /**
     * Returns the current value of the property 'LoadError' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendLoadErrorUpdate() method.
     *
     * <b>Documentation of 'LoadError'</b>:
     *
     * LoadError contains a pair of strings. If the unit failed to load (as encoded in LoadState, see above),
     * 		then this will include a D-Bus error pair consisting of the error ID and an explanatory human readable string of what happened.
     * 		If it succeeded to load this will be a pair of empty strings.
     */
    loadError& getLoadErrorMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendLoadErrorUpdate().
     *
     * <b>Documentation of 'LoadError'</b>:
     *
     * LoadError contains a pair of strings. If the unit failed to load (as encoded in LoadState, see above),
     * 		then this will include a D-Bus error pair consisting of the error ID and an explanatory human readable string of what happened.
     * 		If it succeeded to load this will be a pair of empty strings.
     */
    void sendLoadErrorUpdate();

    // property 'Transient'

    /**
     * The method onTransientGet() is called by ASF when a client invokes the
     * read method for the property 'Transient'. The onTransientGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Transient'</b>:
     *
     * Transient contains a boolean that indicates whether the unit was created as transient unit
     * 		(i.e. via CreateTransientUnit() on the manager object).
     */
    virtual void onTransientGet(const ::boost::shared_ptr< TransientGet >& payload);

    /**
     * Sends back the update to a previous onTransientGet().
     *
     * <b>Documentation of 'Transient'</b>:
     *
     * Transient contains a boolean that indicates whether the unit was created as transient unit
     * 		(i.e. via CreateTransientUnit() on the manager object).
     *
     * @param act Identifies a previous invocation of onTransientGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendTransientGetUpdate(bool transient, act_t act = 0);

    /**
     * Set the value of the property 'Transient' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'Transient'</b>:
     *
     * Transient contains a boolean that indicates whether the unit was created as transient unit
     * 		(i.e. via CreateTransientUnit() on the manager object).
     */
    void setTransient(bool transient);

    /**
     * Returns the current value of the property 'Transient'.
     *
     * <b>Documentation of 'Transient'</b>:
     *
     * Transient contains a boolean that indicates whether the unit was created as transient unit
     * 		(i.e. via CreateTransientUnit() on the manager object).
     */
    bool getTransient() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendTransientUpdate().
     *
     * <b>Documentation of 'Transient'</b>:
     *
     * Transient contains a boolean that indicates whether the unit was created as transient unit
     * 		(i.e. via CreateTransientUnit() on the manager object).
     */
    void sendTransientUpdate();

    // method 'Start'

    /**
     * The method onStart() is called by ASF when a client invokes the method
     * 'Start'. A subclass has to implement this method and send back a
     * response to the client either with the sendStart() or sendStartError()
     * method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'Start'</b>:
     *
     * Start(), Stop(), Reload(), Restart(), TryRestart(), ReloadOrRestart(), ReloadOrTryRestart(),
     * 		Kill(), ResetFailed() and SetProperties() implement the same operation as the respective method calls on the Manager
     * 		object (see above), however operate on the unit object and hence do not take a unit name parameter. Invoking the methods
     * 		directly on the Manager object has the advantage of not requiring a GetUnit() call to get the unit object for a specific
     * 		unit name. Calling the methods on the Manager object is hence a round trip optimization.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onStartRequest (const ::boost::shared_ptr< StartRequest >& request) = 0;

    /**
     * The method sendStartResponse() sends a response of a previous method
     * invocation of 'Start' back to the client.
     *
     * <b>Documentation of 'Start'</b>:
     *
     * Start(), Stop(), Reload(), Restart(), TryRestart(), ReloadOrRestart(), ReloadOrTryRestart(),
     * 		Kill(), ResetFailed() and SetProperties() implement the same operation as the respective method calls on the Manager
     * 		object (see above), however operate on the unit object and hence do not take a unit name parameter. Invoking the methods
     * 		directly on the Manager object has the advantage of not requiring a GetUnit() call to get the unit object for a specific
     * 		unit name. Calling the methods on the Manager object is hence a round trip optimization.
     *
     * @param job If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onStart(). If the act is not specified, i.e. the most recent invocation
     * will be answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendStartResponse (const ::std::string& job, act_t act = 0);

    /**
     * The method sendStartError() sends an error response of a previous
     * method invocation of 'Start' back to the client.
     *
     * <b>Documentation of 'Start'</b>:
     *
     * Start(), Stop(), Reload(), Restart(), TryRestart(), ReloadOrRestart(), ReloadOrTryRestart(),
     * 		Kill(), ResetFailed() and SetProperties() implement the same operation as the respective method calls on the Manager
     * 		object (see above), however operate on the unit object and hence do not take a unit name parameter. Invoking the methods
     * 		directly on the Manager object has the advantage of not requiring a GetUnit() call to get the unit object for a specific
     * 		unit name. Calling the methods on the Manager object is hence a round trip optimization.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onStart(). If the act is
     * not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendStartError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'Stop'

    /**
     * The method onStop() is called by ASF when a client invokes the method
     * 'Stop'. A subclass has to implement this method and send back a
     * response to the client either with the sendStop() or sendStopError()
     * method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'Stop'</b>:
     *
     * Stop.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onStopRequest (const ::boost::shared_ptr< StopRequest >& request) = 0;

    /**
     * The method sendStopResponse() sends a response of a previous method
     * invocation of 'Stop' back to the client.
     *
     * <b>Documentation of 'Stop'</b>:
     *
     * Stop.
     *
     * @param job If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onStop(). If the act is not specified, i.e. the most recent invocation
     * will be answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendStopResponse (const ::std::string& job, act_t act = 0);

    /**
     * The method sendStopError() sends an error response of a previous method
     * invocation of 'Stop' back to the client.
     *
     * <b>Documentation of 'Stop'</b>:
     *
     * Stop.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onStop(). If the act is
     * not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendStopError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'Reload'

    /**
     * The method onReload() is called by ASF when a client invokes the method
     * 'Reload'. A subclass has to implement this method and send back a
     * response to the client either with the sendReload() or
     * sendReloadError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'Reload'</b>:
     *
     * Reload.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onReloadRequest (const ::boost::shared_ptr< ReloadRequest >& request) = 0;

    /**
     * The method sendReloadResponse() sends a response of a previous method
     * invocation of 'Reload' back to the client.
     *
     * <b>Documentation of 'Reload'</b>:
     *
     * Reload.
     *
     * @param job If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onReload(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendReloadResponse (const ::std::string& job, act_t act = 0);

    /**
     * The method sendReloadError() sends an error response of a previous
     * method invocation of 'Reload' back to the client.
     *
     * <b>Documentation of 'Reload'</b>:
     *
     * Reload.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onReload(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendReloadError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'Restart'

    /**
     * The method onRestart() is called by ASF when a client invokes the
     * method 'Restart'. A subclass has to implement this method and send back
     * a response to the client either with the sendRestart() or
     * sendRestartError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'Restart'</b>:
     *
     * Restart.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRestartRequest (const ::boost::shared_ptr< RestartRequest >& request) = 0;

    /**
     * The method sendRestartResponse() sends a response of a previous method
     * invocation of 'Restart' back to the client.
     *
     * <b>Documentation of 'Restart'</b>:
     *
     * Restart.
     *
     * @param job If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onRestart(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendRestartResponse (const ::std::string& job, act_t act = 0);

    /**
     * The method sendRestartError() sends an error response of a previous
     * method invocation of 'Restart' back to the client.
     *
     * <b>Documentation of 'Restart'</b>:
     *
     * Restart.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onRestart(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendRestartError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'TryRestart'

    /**
     * The method onTryRestart() is called by ASF when a client invokes the
     * method 'TryRestart'. A subclass has to implement this method and send
     * back a response to the client either with the sendTryRestart() or
     * sendTryRestartError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'TryRestart'</b>:
     *
     * TryRestart.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onTryRestartRequest (const ::boost::shared_ptr< TryRestartRequest >& request) = 0;

    /**
     * The method sendTryRestartResponse() sends a response of a previous
     * method invocation of 'TryRestart' back to the client.
     *
     * <b>Documentation of 'TryRestart'</b>:
     *
     * TryRestart.
     *
     * @param job If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onTryRestart(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendTryRestartResponse (const ::std::string& job, act_t act = 0);

    /**
     * The method sendTryRestartError() sends an error response of a previous
     * method invocation of 'TryRestart' back to the client.
     *
     * <b>Documentation of 'TryRestart'</b>:
     *
     * TryRestart.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onTryRestart(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendTryRestartError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ReloadOrRestart'

    /**
     * The method onReloadOrRestart() is called by ASF when a client invokes
     * the method 'ReloadOrRestart'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendReloadOrRestart() or sendReloadOrRestartError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'ReloadOrRestart'</b>:
     *
     * ReloadOrRestart.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onReloadOrRestartRequest (const ::boost::shared_ptr< ReloadOrRestartRequest >& request) = 0;

    /**
     * The method sendReloadOrRestartResponse() sends a response of a previous
     * method invocation of 'ReloadOrRestart' back to the client.
     *
     * <b>Documentation of 'ReloadOrRestart'</b>:
     *
     * ReloadOrRestart.
     *
     * @param job If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onReloadOrRestart(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendReloadOrRestartResponse (const ::std::string& job, act_t act = 0);

    /**
     * The method sendReloadOrRestartError() sends an error response of a
     * previous method invocation of 'ReloadOrRestart' back to the client.
     *
     * <b>Documentation of 'ReloadOrRestart'</b>:
     *
     * ReloadOrRestart.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onReloadOrRestart(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendReloadOrRestartError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ReloadOrTryRestart'

    /**
     * The method onReloadOrTryRestart() is called by ASF when a client
     * invokes the method 'ReloadOrTryRestart'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendReloadOrTryRestart() or sendReloadOrTryRestartError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'ReloadOrTryRestart'</b>:
     *
     * ReloadOrTryRestart.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onReloadOrTryRestartRequest (const ::boost::shared_ptr< ReloadOrTryRestartRequest >& request) = 0;

    /**
     * The method sendReloadOrTryRestartResponse() sends a response of a
     * previous method invocation of 'ReloadOrTryRestart' back to the client.
     *
     * <b>Documentation of 'ReloadOrTryRestart'</b>:
     *
     * ReloadOrTryRestart.
     *
     * @param job If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onReloadOrTryRestart(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendReloadOrTryRestartResponse (const ::std::string& job, act_t act = 0);

    /**
     * The method sendReloadOrTryRestartError() sends an error response of a
     * previous method invocation of 'ReloadOrTryRestart' back to the client.
     *
     * <b>Documentation of 'ReloadOrTryRestart'</b>:
     *
     * ReloadOrTryRestart.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onReloadOrTryRestart().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendReloadOrTryRestartError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'Kill'

    /**
     * The method onKill() is called by ASF when a client invokes the method
     * 'Kill'. A subclass has to implement this method and send back a
     * response to the client either with the sendKill() or sendKillError()
     * method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'Kill'</b>:
     *
     * Kill.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onKillRequest (const ::boost::shared_ptr< KillRequest >& request) = 0;

    /**
     * The method sendKillResponse() sends a response of a previous method
     * invocation of 'Kill' back to the client.
     *
     * <b>Documentation of 'Kill'</b>:
     *
     * Kill.
     *
     * @param job If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onKill(). If the act is not specified, i.e. the most recent invocation
     * will be answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendKillResponse (const ::std::string& job, act_t act = 0);

    /**
     * The method sendKillError() sends an error response of a previous method
     * invocation of 'Kill' back to the client.
     *
     * <b>Documentation of 'Kill'</b>:
     *
     * Kill.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onKill(). If the act is
     * not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendKillError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ResetFailed'

    /**
     * The method onResetFailed() is called by ASF when a client invokes the
     * method 'ResetFailed'. A subclass has to implement this method and send
     * back a response to the client either with the sendResetFailed() or
     * sendResetFailedError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'ResetFailed'</b>:
     *
     * ResetFailed.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onResetFailedRequest (const ::boost::shared_ptr< ResetFailedRequest >& request) = 0;

    /**
     * The method sendResetFailedResponse() sends a response of a previous
     * method invocation of 'ResetFailed' back to the client.
     *
     * <b>Documentation of 'ResetFailed'</b>:
     *
     * ResetFailed.
     *
     * @param act The parameter act identifies a previous invocation of
     * onResetFailed(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendResetFailedResponse (act_t act = 0);

    /**
     * The method sendResetFailedError() sends an error response of a previous
     * method invocation of 'ResetFailed' back to the client.
     *
     * <b>Documentation of 'ResetFailed'</b>:
     *
     * ResetFailed.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onResetFailed(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendResetFailedError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'SetProperties'

    /**
     * The method onSetProperties() is called by ASF when a client invokes the
     * method 'SetProperties'. A subclass has to implement this method and
     * send back a response to the client either with the sendSetProperties()
     * or sendSetPropertiesError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'SetProperties'</b>:
     *
     * SetProperties.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetPropertiesRequest (const ::boost::shared_ptr< SetPropertiesRequest >& request) = 0;

    /**
     * The method sendSetPropertiesResponse() sends a response of a previous
     * method invocation of 'SetProperties' back to the client.
     *
     * <b>Documentation of 'SetProperties'</b>:
     *
     * SetProperties.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetProperties(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendSetPropertiesResponse (act_t act = 0);

    /**
     * The method sendSetPropertiesError() sends an error response of a
     * previous method invocation of 'SetProperties' back to the client.
     *
     * <b>Documentation of 'SetProperties'</b>:
     *
     * SetProperties.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSetProperties(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSetPropertiesError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    IdUpdate _IdProperty;

    NamesUpdate _NamesProperty;

    FollowingUpdate _FollowingProperty;

    RequiresUpdate _RequiresProperty;

    RequiresOverridableUpdate _RequiresOverridableProperty;

    RequisiteUpdate _RequisiteProperty;

    RequisiteOverridableUpdate _RequisiteOverridableProperty;

    WantsUpdate _WantsProperty;

    BindsToUpdate _BindsToProperty;

    PartOfUpdate _PartOfProperty;

    RequiredByUpdate _RequiredByProperty;

    RequiredByOverridableUpdate _RequiredByOverridableProperty;

    RequisiteOfUpdate _RequisiteOfProperty;

    RequisiteOfOverridableUpdate _RequisiteOfOverridableProperty;

    WantedByUpdate _WantedByProperty;

    BoundByUpdate _BoundByProperty;

    ConsistsOfUpdate _ConsistsOfProperty;

    ConflictsUpdate _ConflictsProperty;

    ConflictedByUpdate _ConflictedByProperty;

    BeforeUpdate _BeforeProperty;

    AfterUpdate _AfterProperty;

    OnFailureUpdate _OnFailureProperty;

    TriggersUpdate _TriggersProperty;

    TriggeredByUpdate _TriggeredByProperty;

    PropagatesReloadToUpdate _PropagatesReloadToProperty;

    ReloadPropagatedFromUpdate _ReloadPropagatedFromProperty;

    JoinsNamespaceOfUpdate _JoinsNamespaceOfProperty;

    RequiresMountsForUpdate _RequiresMountsForProperty;

    DocumentationUpdate _DocumentationProperty;

    DescriptionUpdate _DescriptionProperty;

    LoadStateUpdate _LoadStateProperty;

    ActiveStateUpdate _ActiveStateProperty;

    SubStateUpdate _SubStateProperty;

    FragmentPathUpdate _FragmentPathProperty;

    SourcePathUpdate _SourcePathProperty;

    DropInPathsUpdate _DropInPathsProperty;

    UnitFileStateUpdate _UnitFileStateProperty;

    UnitFilePresetUpdate _UnitFilePresetProperty;

    InactiveExitTimestampUpdate _InactiveExitTimestampProperty;

    InactiveExitTimestampMonotonicUpdate _InactiveExitTimestampMonotonicProperty;

    ActiveEnterTimestampUpdate _ActiveEnterTimestampProperty;

    ActiveEnterTimestampMonotonicUpdate _ActiveEnterTimestampMonotonicProperty;

    ActiveExitTimestampUpdate _ActiveExitTimestampProperty;

    ActiveExitTimestampMonotonicUpdate _ActiveExitTimestampMonotonicProperty;

    InactiveEnterTimestampUpdate _InactiveEnterTimestampProperty;

    InactiveEnterTimestampMonotonicUpdate _InactiveEnterTimestampMonotonicProperty;

    CanStartUpdate _CanStartProperty;

    CanStopUpdate _CanStopProperty;

    CanReloadUpdate _CanReloadProperty;

    CanIsolateUpdate _CanIsolateProperty;

    JobUpdate _JobProperty;

    StopWhenUnneededUpdate _StopWhenUnneededProperty;

    RefuseManualStartUpdate _RefuseManualStartProperty;

    RefuseManualStopUpdate _RefuseManualStopProperty;

    AllowIsolateUpdate _AllowIsolateProperty;

    DefaultDependenciesUpdate _DefaultDependenciesProperty;

    OnFailureJobModeUpdate _OnFailureJobModeProperty;

    IgnoreOnIsolateUpdate _IgnoreOnIsolateProperty;

    IgnoreOnSnapshotUpdate _IgnoreOnSnapshotProperty;

    NeedDaemonReloadUpdate _NeedDaemonReloadProperty;

    JobTimeoutUSecUpdate _JobTimeoutUSecProperty;

    JobTimeoutActionUpdate _JobTimeoutActionProperty;

    JobTimeoutRebootArgumentUpdate _JobTimeoutRebootArgumentProperty;

    ConditionResultUpdate _ConditionResultProperty;

    AssertResultUpdate _AssertResultProperty;

    ConditionTimestampUpdate _ConditionTimestampProperty;

    ConditionTimestampMonotonicUpdate _ConditionTimestampMonotonicProperty;

    AssertTimestampUpdate _AssertTimestampProperty;

    AssertTimestampMonotonicUpdate _AssertTimestampMonotonicProperty;

    ConditionsUpdate _ConditionsProperty;

    AssertsUpdate _AssertsProperty;

    LoadErrorUpdate _LoadErrorProperty;

    TransientUpdate _TransientProperty;

    friend class UnitStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org

#endif // ORG_FREEDESKTOP_SYSTEMD1_UNITSTUB_H
