/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/freedesktop/systemd1/Unit.h"
#include "org/freedesktop/systemd1/UnitDBus.h"
#include "org/freedesktop/systemd1/UnitJson.h"
#include "org/freedesktop/systemd1/UnitStub.h"
#include <string>
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

DEFINE_CLASS_LOGGER("/org/freedesktop/systemd1/org/freedesktop/systemd1/Unit", UnitStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 4, "Kill", 7 },
    { 4, "Stop", 1 },
    { 5, "Start", 0 },
    { 6, "Reload", 2 },
    { 7, "Restart", 3 },
    { 10, "TryRestart", 4 },
    { 11, "ResetFailed", 8 },
    { 13, "SetProperties", 9 },
    { 15, "ReloadOrRestart", 5 },
    { 18, "ReloadOrTryRestart", 6 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 2, "Id", 0 },
    { 3, "Job", 50 },
    { 5, "After", 20 },
    { 5, "Names", 1 },
    { 5, "Wants", 7 },
    { 6, "Before", 19 },
    { 6, "PartOf", 9 },
    { 7, "Asserts", 70 },
    { 7, "BindsTo", 8 },
    { 7, "BoundBy", 15 },
    { 7, "CanStop", 47 },
    { 8, "CanStart", 46 },
    { 8, "Requires", 3 },
    { 8, "SubState", 32 },
    { 8, "Triggers", 22 },
    { 8, "WantedBy", 14 },
    { 9, "CanReload", 48 },
    { 9, "Conflicts", 17 },
    { 9, "Following", 2 },
    { 9, "LoadError", 71 },
    { 9, "LoadState", 30 },
    { 9, "OnFailure", 21 },
    { 9, "Requisite", 5 },
    { 9, "Transient", 72 },
    { 10, "CanIsolate", 49 },
    { 10, "Conditions", 69 },
    { 10, "ConsistsOf", 16 },
    { 10, "RequiredBy", 10 },
    { 10, "SourcePath", 34 },
    { 11, "ActiveState", 31 },
    { 11, "Description", 29 },
    { 11, "DropInPaths", 35 },
    { 11, "RequisiteOf", 12 },
    { 11, "TriggeredBy", 23 },
    { 12, "AllowIsolate", 54 },
    { 12, "AssertResult", 64 },
    { 12, "ConflictedBy", 18 },
    { 12, "FragmentPath", 33 },
    { 13, "Documentation", 28 },
    { 13, "UnitFileState", 36 },
    { 14, "JobTimeoutUSec", 60 },
    { 14, "UnitFilePreset", 37 },
    { 15, "AssertTimestamp", 67 },
    { 15, "ConditionResult", 63 },
    { 15, "IgnoreOnIsolate", 57 },
    { 16, "IgnoreOnSnapshot", 58 },
    { 16, "JobTimeoutAction", 61 },
    { 16, "JoinsNamespaceOf", 26 },
    { 16, "NeedDaemonReload", 59 },
    { 16, "OnFailureJobMode", 56 },
    { 16, "RefuseManualStop", 53 },
    { 16, "StopWhenUnneeded", 51 },
    { 17, "RefuseManualStart", 52 },
    { 17, "RequiresMountsFor", 27 },
    { 18, "ConditionTimestamp", 65 },
    { 18, "PropagatesReloadTo", 24 },
    { 19, "ActiveExitTimestamp", 42 },
    { 19, "DefaultDependencies", 55 },
    { 19, "RequiresOverridable", 4 },
    { 20, "ActiveEnterTimestamp", 40 },
    { 20, "ReloadPropagatedFrom", 25 },
    { 20, "RequisiteOverridable", 6 },
    { 21, "InactiveExitTimestamp", 38 },
    { 21, "RequiredByOverridable", 11 },
    { 22, "InactiveEnterTimestamp", 44 },
    { 22, "RequisiteOfOverridable", 13 },
    { 24, "AssertTimestampMonotonic", 68 },
    { 24, "JobTimeoutRebootArgument", 62 },
    { 27, "ConditionTimestampMonotonic", 66 },
    { 28, "ActiveExitTimestampMonotonic", 43 },
    { 29, "ActiveEnterTimestampMonotonic", 41 },
    { 30, "InactiveExitTimestampMonotonic", 39 },
    { 31, "InactiveEnterTimestampMonotonic", 45 },
};

class UnitStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    UnitStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    UnitStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    UnitStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.freedesktop.systemd1.Unit"),
          _logger(logger) {}

    virtual ~UnitStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void UnitStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 10, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'Start'

            LOG_DEBUG_STUB("process method '%s'", "Start");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Start", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< StartRequest > payload = ::boost::static_pointer_cast<StartRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<UnitStub*>(getStub())->onStartRequest(payload);
            return;
        }
        case 1: {

            // method 'Stop'

            LOG_DEBUG_STUB("process method '%s'", "Stop");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StopRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Stop", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< StopRequest > payload = ::boost::static_pointer_cast<StopRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<UnitStub*>(getStub())->onStopRequest(payload);
            return;
        }
        case 2: {

            // method 'Reload'

            LOG_DEBUG_STUB("process method '%s'", "Reload");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReloadRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Reload", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ReloadRequest > payload = ::boost::static_pointer_cast<ReloadRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<UnitStub*>(getStub())->onReloadRequest(payload);
            return;
        }
        case 3: {

            // method 'Restart'

            LOG_DEBUG_STUB("process method '%s'", "Restart");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RestartRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Restart", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RestartRequest > payload = ::boost::static_pointer_cast<RestartRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<UnitStub*>(getStub())->onRestartRequest(payload);
            return;
        }
        case 4: {

            // method 'TryRestart'

            LOG_DEBUG_STUB("process method '%s'", "TryRestart");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TryRestartRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "TryRestart", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< TryRestartRequest > payload = ::boost::static_pointer_cast<TryRestartRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<UnitStub*>(getStub())->onTryRestartRequest(payload);
            return;
        }
        case 5: {

            // method 'ReloadOrRestart'

            LOG_DEBUG_STUB("process method '%s'", "ReloadOrRestart");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReloadOrRestartRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ReloadOrRestart", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ReloadOrRestartRequest > payload = ::boost::static_pointer_cast<ReloadOrRestartRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<UnitStub*>(getStub())->onReloadOrRestartRequest(payload);
            return;
        }
        case 6: {

            // method 'ReloadOrTryRestart'

            LOG_DEBUG_STUB("process method '%s'", "ReloadOrTryRestart");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReloadOrTryRestartRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ReloadOrTryRestart", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ReloadOrTryRestartRequest > payload = ::boost::static_pointer_cast<ReloadOrTryRestartRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<UnitStub*>(getStub())->onReloadOrTryRestartRequest(payload);
            return;
        }
        case 7: {

            // method 'Kill'

            LOG_DEBUG_STUB("process method '%s'", "Kill");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), KillRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Kill", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< KillRequest > payload = ::boost::static_pointer_cast<KillRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<UnitStub*>(getStub())->onKillRequest(payload);
            return;
        }
        case 8: {

            // method 'ResetFailed'

            LOG_DEBUG_STUB("process method '%s'", "ResetFailed");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ResetFailedRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ResetFailed", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ResetFailedRequest > payload = ::boost::static_pointer_cast<ResetFailedRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<UnitStub*>(getStub())->onResetFailedRequest(payload);
            return;
        }
        case 9: {

            // method 'SetProperties'

            LOG_DEBUG_STUB("process method '%s'", "SetProperties");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetPropertiesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetProperties", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetPropertiesRequest > payload = ::boost::static_pointer_cast<SetPropertiesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<UnitStub*>(getStub())->onSetPropertiesRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* UnitStubDelegate::introspect() const {
    return     "<interface name=\"org.freedesktop.systemd1.Unit\">\n"
            "    <property access=\"read\" name=\"Id\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"Names\" type=\"as\"/>\n"
            "    <property access=\"read\" name=\"Following\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"Requires\" type=\"as\"/>\n"
            "    <property access=\"read\" name=\"RequiresOverridable\" type=\"as\"/>\n"
            "    <property access=\"read\" name=\"Requisite\" type=\"as\"/>\n"
            "    <property access=\"read\" name=\"RequisiteOverridable\" type=\"as\"/>\n"
            "    <property access=\"read\" name=\"Wants\" type=\"as\"/>\n"
            "    <property access=\"read\" name=\"BindsTo\" type=\"as\"/>\n"
            "    <property access=\"read\" name=\"PartOf\" type=\"as\"/>\n"
            "    <property access=\"read\" name=\"RequiredBy\" type=\"as\"/>\n"
            "    <property access=\"read\" name=\"RequiredByOverridable\" type=\"as\"/>\n"
            "    <property access=\"read\" name=\"RequisiteOf\" type=\"as\"/>\n"
            "    <property access=\"read\" name=\"RequisiteOfOverridable\" type=\"as\"/>\n"
            "    <property access=\"read\" name=\"WantedBy\" type=\"as\"/>\n"
            "    <property access=\"read\" name=\"BoundBy\" type=\"as\"/>\n"
            "    <property access=\"read\" name=\"ConsistsOf\" type=\"as\"/>\n"
            "    <property access=\"read\" name=\"Conflicts\" type=\"as\"/>\n"
            "    <property access=\"read\" name=\"ConflictedBy\" type=\"as\"/>\n"
            "    <property access=\"read\" name=\"Before\" type=\"as\"/>\n"
            "    <property access=\"read\" name=\"After\" type=\"as\"/>\n"
            "    <property access=\"read\" name=\"OnFailure\" type=\"as\"/>\n"
            "    <property access=\"read\" name=\"Triggers\" type=\"as\"/>\n"
            "    <property access=\"read\" name=\"TriggeredBy\" type=\"as\"/>\n"
            "    <property access=\"read\" name=\"PropagatesReloadTo\" type=\"as\"/>\n"
            "    <property access=\"read\" name=\"ReloadPropagatedFrom\" type=\"as\"/>\n"
            "    <property access=\"read\" name=\"JoinsNamespaceOf\" type=\"as\"/>\n"
            "    <property access=\"read\" name=\"RequiresMountsFor\" type=\"as\"/>\n"
            "    <property access=\"read\" name=\"Documentation\" type=\"as\"/>\n"
            "    <property access=\"read\" name=\"Description\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"LoadState\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"ActiveState\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"SubState\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"FragmentPath\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"SourcePath\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"DropInPaths\" type=\"as\"/>\n"
            "    <property access=\"read\" name=\"UnitFileState\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"UnitFilePreset\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"InactiveExitTimestamp\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"InactiveExitTimestampMonotonic\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"ActiveEnterTimestamp\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"ActiveEnterTimestampMonotonic\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"ActiveExitTimestamp\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"ActiveExitTimestampMonotonic\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"InactiveEnterTimestamp\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"InactiveEnterTimestampMonotonic\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"CanStart\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"CanStop\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"CanReload\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"CanIsolate\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"Job\" type=\"(us)\"/>\n"
            "    <property access=\"read\" name=\"StopWhenUnneeded\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"RefuseManualStart\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"RefuseManualStop\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"AllowIsolate\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"DefaultDependencies\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"OnFailureJobMode\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"IgnoreOnIsolate\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"IgnoreOnSnapshot\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"NeedDaemonReload\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"JobTimeoutUSec\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"JobTimeoutAction\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"JobTimeoutRebootArgument\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"ConditionResult\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"AssertResult\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"ConditionTimestamp\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"ConditionTimestampMonotonic\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"AssertTimestamp\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"AssertTimestampMonotonic\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"Conditions\" type=\"a(sbbsi)\"/>\n"
            "    <property access=\"read\" name=\"Asserts\" type=\"a(sbbsi)\"/>\n"
            "    <property access=\"read\" name=\"LoadError\" type=\"(ss)\"/>\n"
            "    <property access=\"read\" name=\"Transient\" type=\"b\"/>\n"
            "    <method name=\"Start\">\n"
            "      <doc>\n"
            "        <line>Start = Start(), Stop(), Reload(), Restart(), TryRestart(), ReloadOrRestart(), ReloadOrTryRestart(),</line>\n"
            "        <line>Kill(), ResetFailed() and SetProperties() implement the same operation as the respective method calls on the Manager</line>\n"
            "        <line>object (see above), however operate on the unit object and hence do not take a unit name parameter. Invoking the methods</line>\n"
            "        <line>directly on the Manager object has the advantage of not requiring a GetUnit() call to get the unit object for a specific</line>\n"
            "        <line>unit name. Calling the methods on the Manager object is hence a round trip optimization.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"mode\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>mode = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"job\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>job (of type ObjectPath) = Description missing</line>\n"
            "          <line>lineComment to be defined</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"Stop\">\n"
            "      <doc>\n"
            "        <line>Stop = Stop.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"mode\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>mode = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"job\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>job (of type ObjectPath) = Description missing</line>\n"
            "          <line>lineComment to be defined</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"Reload\">\n"
            "      <doc>\n"
            "        <line>Reload = Reload.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"mode\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>mode = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"job\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>job (of type ObjectPath) = Description missing</line>\n"
            "          <line>lineComment to be defined</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"Restart\">\n"
            "      <doc>\n"
            "        <line>Restart = Restart.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"mode\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>mode = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"job\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>job (of type ObjectPath) = Description missing</line>\n"
            "          <line>lineComment to be defined</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"TryRestart\">\n"
            "      <doc>\n"
            "        <line>TryRestart = TryRestart.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"mode\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>mode = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"job\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>job (of type ObjectPath) = Description missing</line>\n"
            "          <line>lineComment to be defined</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ReloadOrRestart\">\n"
            "      <doc>\n"
            "        <line>ReloadOrRestart = ReloadOrRestart.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"mode\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>mode = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"job\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>job (of type ObjectPath) = Description missing</line>\n"
            "          <line>lineComment to be defined</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ReloadOrTryRestart\">\n"
            "      <doc>\n"
            "        <line>ReloadOrTryRestart = ReloadOrTryRestart.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"mode\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>mode = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"job\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>job (of type ObjectPath) = Description missing</line>\n"
            "          <line>lineComment to be defined</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"Kill\">\n"
            "      <doc>\n"
            "        <line>Kill = Kill.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"mode\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>mode = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"job\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>job (of type ObjectPath) = Description missing</line>\n"
            "          <line>lineComment to be defined</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ResetFailed\">\n"
            "      <doc>\n"
            "        <line>ResetFailed = ResetFailed.</line>\n"
            "      </doc>\n"
            "    </method>\n"
            "    <method name=\"SetProperties\">\n"
            "      <doc>\n"
            "        <line>SetProperties = SetProperties.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"runtime\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>runtime = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"properties\" type=\"a(ss)\">\n"
            "        <doc>\n"
            "          <line>properties (of type property) = Description missing</line>\n"
            "          <line>property struct[name, value] = Property info struct</line>\n"
            "          <line>0: property.name ('s') = Description missing</line>\n"
            "          <line>1: property.value ('s') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "</interface>\n";
}

void UnitStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<UnitStub*>(getStub()))->onGetAll (properties);
}

void UnitStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 73, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "Id");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "Names");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "Following");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "Requires");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "RequiresOverridable");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 5: {
            LOG_DEBUG_STUB("process property '%s'", "Requisite");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 6: {
            LOG_DEBUG_STUB("process property '%s'", "RequisiteOverridable");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 7: {
            LOG_DEBUG_STUB("process property '%s'", "Wants");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 8: {
            LOG_DEBUG_STUB("process property '%s'", "BindsTo");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 9: {
            LOG_DEBUG_STUB("process property '%s'", "PartOf");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 10: {
            LOG_DEBUG_STUB("process property '%s'", "RequiredBy");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 11: {
            LOG_DEBUG_STUB("process property '%s'", "RequiredByOverridable");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 12: {
            LOG_DEBUG_STUB("process property '%s'", "RequisiteOf");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 13: {
            LOG_DEBUG_STUB("process property '%s'", "RequisiteOfOverridable");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 14: {
            LOG_DEBUG_STUB("process property '%s'", "WantedBy");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 15: {
            LOG_DEBUG_STUB("process property '%s'", "BoundBy");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 16: {
            LOG_DEBUG_STUB("process property '%s'", "ConsistsOf");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 17: {
            LOG_DEBUG_STUB("process property '%s'", "Conflicts");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 18: {
            LOG_DEBUG_STUB("process property '%s'", "ConflictedBy");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 19: {
            LOG_DEBUG_STUB("process property '%s'", "Before");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 20: {
            LOG_DEBUG_STUB("process property '%s'", "After");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 21: {
            LOG_DEBUG_STUB("process property '%s'", "OnFailure");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 22: {
            LOG_DEBUG_STUB("process property '%s'", "Triggers");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 23: {
            LOG_DEBUG_STUB("process property '%s'", "TriggeredBy");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 24: {
            LOG_DEBUG_STUB("process property '%s'", "PropagatesReloadTo");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 25: {
            LOG_DEBUG_STUB("process property '%s'", "ReloadPropagatedFrom");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 26: {
            LOG_DEBUG_STUB("process property '%s'", "JoinsNamespaceOf");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 27: {
            LOG_DEBUG_STUB("process property '%s'", "RequiresMountsFor");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 28: {
            LOG_DEBUG_STUB("process property '%s'", "Documentation");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 29: {
            LOG_DEBUG_STUB("process property '%s'", "Description");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 30: {
            LOG_DEBUG_STUB("process property '%s'", "LoadState");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 31: {
            LOG_DEBUG_STUB("process property '%s'", "ActiveState");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 32: {
            LOG_DEBUG_STUB("process property '%s'", "SubState");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 33: {
            LOG_DEBUG_STUB("process property '%s'", "FragmentPath");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 34: {
            LOG_DEBUG_STUB("process property '%s'", "SourcePath");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 35: {
            LOG_DEBUG_STUB("process property '%s'", "DropInPaths");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 36: {
            LOG_DEBUG_STUB("process property '%s'", "UnitFileState");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 37: {
            LOG_DEBUG_STUB("process property '%s'", "UnitFilePreset");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 38: {
            LOG_DEBUG_STUB("process property '%s'", "InactiveExitTimestamp");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 39: {
            LOG_DEBUG_STUB("process property '%s'", "InactiveExitTimestampMonotonic");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 40: {
            LOG_DEBUG_STUB("process property '%s'", "ActiveEnterTimestamp");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 41: {
            LOG_DEBUG_STUB("process property '%s'", "ActiveEnterTimestampMonotonic");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 42: {
            LOG_DEBUG_STUB("process property '%s'", "ActiveExitTimestamp");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 43: {
            LOG_DEBUG_STUB("process property '%s'", "ActiveExitTimestampMonotonic");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 44: {
            LOG_DEBUG_STUB("process property '%s'", "InactiveEnterTimestamp");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 45: {
            LOG_DEBUG_STUB("process property '%s'", "InactiveEnterTimestampMonotonic");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 46: {
            LOG_DEBUG_STUB("process property '%s'", "CanStart");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 47: {
            LOG_DEBUG_STUB("process property '%s'", "CanStop");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 48: {
            LOG_DEBUG_STUB("process property '%s'", "CanReload");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 49: {
            LOG_DEBUG_STUB("process property '%s'", "CanIsolate");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 50: {
            LOG_DEBUG_STUB("process property '%s'", "Job");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 51: {
            LOG_DEBUG_STUB("process property '%s'", "StopWhenUnneeded");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 52: {
            LOG_DEBUG_STUB("process property '%s'", "RefuseManualStart");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 53: {
            LOG_DEBUG_STUB("process property '%s'", "RefuseManualStop");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 54: {
            LOG_DEBUG_STUB("process property '%s'", "AllowIsolate");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 55: {
            LOG_DEBUG_STUB("process property '%s'", "DefaultDependencies");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 56: {
            LOG_DEBUG_STUB("process property '%s'", "OnFailureJobMode");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 57: {
            LOG_DEBUG_STUB("process property '%s'", "IgnoreOnIsolate");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 58: {
            LOG_DEBUG_STUB("process property '%s'", "IgnoreOnSnapshot");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 59: {
            LOG_DEBUG_STUB("process property '%s'", "NeedDaemonReload");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 60: {
            LOG_DEBUG_STUB("process property '%s'", "JobTimeoutUSec");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 61: {
            LOG_DEBUG_STUB("process property '%s'", "JobTimeoutAction");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 62: {
            LOG_DEBUG_STUB("process property '%s'", "JobTimeoutRebootArgument");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 63: {
            LOG_DEBUG_STUB("process property '%s'", "ConditionResult");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 64: {
            LOG_DEBUG_STUB("process property '%s'", "AssertResult");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 65: {
            LOG_DEBUG_STUB("process property '%s'", "ConditionTimestamp");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 66: {
            LOG_DEBUG_STUB("process property '%s'", "ConditionTimestampMonotonic");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 67: {
            LOG_DEBUG_STUB("process property '%s'", "AssertTimestamp");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 68: {
            LOG_DEBUG_STUB("process property '%s'", "AssertTimestampMonotonic");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 69: {
            LOG_DEBUG_STUB("process property '%s'", "Conditions");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 70: {
            LOG_DEBUG_STUB("process property '%s'", "Asserts");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 71: {
            LOG_DEBUG_STUB("process property '%s'", "LoadError");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 72: {
            LOG_DEBUG_STUB("process property '%s'", "Transient");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void UnitStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 73, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "Id");
            ::boost::shared_ptr< IdGet > payload(new IdGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onIdGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "Names");
            ::boost::shared_ptr< NamesGet > payload(new NamesGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onNamesGet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "Following");
            ::boost::shared_ptr< FollowingGet > payload(new FollowingGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onFollowingGet (payload);
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "Requires");
            ::boost::shared_ptr< RequiresGet > payload(new RequiresGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onRequiresGet (payload);
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "RequiresOverridable");
            ::boost::shared_ptr< RequiresOverridableGet > payload(new RequiresOverridableGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onRequiresOverridableGet (payload);
            return;
        }
        case 5: {
            LOG_DEBUG_STUB("process property '%s'", "Requisite");
            ::boost::shared_ptr< RequisiteGet > payload(new RequisiteGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onRequisiteGet (payload);
            return;
        }
        case 6: {
            LOG_DEBUG_STUB("process property '%s'", "RequisiteOverridable");
            ::boost::shared_ptr< RequisiteOverridableGet > payload(new RequisiteOverridableGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onRequisiteOverridableGet (payload);
            return;
        }
        case 7: {
            LOG_DEBUG_STUB("process property '%s'", "Wants");
            ::boost::shared_ptr< WantsGet > payload(new WantsGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onWantsGet (payload);
            return;
        }
        case 8: {
            LOG_DEBUG_STUB("process property '%s'", "BindsTo");
            ::boost::shared_ptr< BindsToGet > payload(new BindsToGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onBindsToGet (payload);
            return;
        }
        case 9: {
            LOG_DEBUG_STUB("process property '%s'", "PartOf");
            ::boost::shared_ptr< PartOfGet > payload(new PartOfGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onPartOfGet (payload);
            return;
        }
        case 10: {
            LOG_DEBUG_STUB("process property '%s'", "RequiredBy");
            ::boost::shared_ptr< RequiredByGet > payload(new RequiredByGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onRequiredByGet (payload);
            return;
        }
        case 11: {
            LOG_DEBUG_STUB("process property '%s'", "RequiredByOverridable");
            ::boost::shared_ptr< RequiredByOverridableGet > payload(new RequiredByOverridableGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onRequiredByOverridableGet (payload);
            return;
        }
        case 12: {
            LOG_DEBUG_STUB("process property '%s'", "RequisiteOf");
            ::boost::shared_ptr< RequisiteOfGet > payload(new RequisiteOfGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onRequisiteOfGet (payload);
            return;
        }
        case 13: {
            LOG_DEBUG_STUB("process property '%s'", "RequisiteOfOverridable");
            ::boost::shared_ptr< RequisiteOfOverridableGet > payload(new RequisiteOfOverridableGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onRequisiteOfOverridableGet (payload);
            return;
        }
        case 14: {
            LOG_DEBUG_STUB("process property '%s'", "WantedBy");
            ::boost::shared_ptr< WantedByGet > payload(new WantedByGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onWantedByGet (payload);
            return;
        }
        case 15: {
            LOG_DEBUG_STUB("process property '%s'", "BoundBy");
            ::boost::shared_ptr< BoundByGet > payload(new BoundByGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onBoundByGet (payload);
            return;
        }
        case 16: {
            LOG_DEBUG_STUB("process property '%s'", "ConsistsOf");
            ::boost::shared_ptr< ConsistsOfGet > payload(new ConsistsOfGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onConsistsOfGet (payload);
            return;
        }
        case 17: {
            LOG_DEBUG_STUB("process property '%s'", "Conflicts");
            ::boost::shared_ptr< ConflictsGet > payload(new ConflictsGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onConflictsGet (payload);
            return;
        }
        case 18: {
            LOG_DEBUG_STUB("process property '%s'", "ConflictedBy");
            ::boost::shared_ptr< ConflictedByGet > payload(new ConflictedByGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onConflictedByGet (payload);
            return;
        }
        case 19: {
            LOG_DEBUG_STUB("process property '%s'", "Before");
            ::boost::shared_ptr< BeforeGet > payload(new BeforeGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onBeforeGet (payload);
            return;
        }
        case 20: {
            LOG_DEBUG_STUB("process property '%s'", "After");
            ::boost::shared_ptr< AfterGet > payload(new AfterGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onAfterGet (payload);
            return;
        }
        case 21: {
            LOG_DEBUG_STUB("process property '%s'", "OnFailure");
            ::boost::shared_ptr< OnFailureGet > payload(new OnFailureGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onOnFailureGet (payload);
            return;
        }
        case 22: {
            LOG_DEBUG_STUB("process property '%s'", "Triggers");
            ::boost::shared_ptr< TriggersGet > payload(new TriggersGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onTriggersGet (payload);
            return;
        }
        case 23: {
            LOG_DEBUG_STUB("process property '%s'", "TriggeredBy");
            ::boost::shared_ptr< TriggeredByGet > payload(new TriggeredByGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onTriggeredByGet (payload);
            return;
        }
        case 24: {
            LOG_DEBUG_STUB("process property '%s'", "PropagatesReloadTo");
            ::boost::shared_ptr< PropagatesReloadToGet > payload(new PropagatesReloadToGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onPropagatesReloadToGet (payload);
            return;
        }
        case 25: {
            LOG_DEBUG_STUB("process property '%s'", "ReloadPropagatedFrom");
            ::boost::shared_ptr< ReloadPropagatedFromGet > payload(new ReloadPropagatedFromGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onReloadPropagatedFromGet (payload);
            return;
        }
        case 26: {
            LOG_DEBUG_STUB("process property '%s'", "JoinsNamespaceOf");
            ::boost::shared_ptr< JoinsNamespaceOfGet > payload(new JoinsNamespaceOfGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onJoinsNamespaceOfGet (payload);
            return;
        }
        case 27: {
            LOG_DEBUG_STUB("process property '%s'", "RequiresMountsFor");
            ::boost::shared_ptr< RequiresMountsForGet > payload(new RequiresMountsForGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onRequiresMountsForGet (payload);
            return;
        }
        case 28: {
            LOG_DEBUG_STUB("process property '%s'", "Documentation");
            ::boost::shared_ptr< DocumentationGet > payload(new DocumentationGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onDocumentationGet (payload);
            return;
        }
        case 29: {
            LOG_DEBUG_STUB("process property '%s'", "Description");
            ::boost::shared_ptr< DescriptionGet > payload(new DescriptionGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onDescriptionGet (payload);
            return;
        }
        case 30: {
            LOG_DEBUG_STUB("process property '%s'", "LoadState");
            ::boost::shared_ptr< LoadStateGet > payload(new LoadStateGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onLoadStateGet (payload);
            return;
        }
        case 31: {
            LOG_DEBUG_STUB("process property '%s'", "ActiveState");
            ::boost::shared_ptr< ActiveStateGet > payload(new ActiveStateGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onActiveStateGet (payload);
            return;
        }
        case 32: {
            LOG_DEBUG_STUB("process property '%s'", "SubState");
            ::boost::shared_ptr< SubStateGet > payload(new SubStateGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onSubStateGet (payload);
            return;
        }
        case 33: {
            LOG_DEBUG_STUB("process property '%s'", "FragmentPath");
            ::boost::shared_ptr< FragmentPathGet > payload(new FragmentPathGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onFragmentPathGet (payload);
            return;
        }
        case 34: {
            LOG_DEBUG_STUB("process property '%s'", "SourcePath");
            ::boost::shared_ptr< SourcePathGet > payload(new SourcePathGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onSourcePathGet (payload);
            return;
        }
        case 35: {
            LOG_DEBUG_STUB("process property '%s'", "DropInPaths");
            ::boost::shared_ptr< DropInPathsGet > payload(new DropInPathsGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onDropInPathsGet (payload);
            return;
        }
        case 36: {
            LOG_DEBUG_STUB("process property '%s'", "UnitFileState");
            ::boost::shared_ptr< UnitFileStateGet > payload(new UnitFileStateGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onUnitFileStateGet (payload);
            return;
        }
        case 37: {
            LOG_DEBUG_STUB("process property '%s'", "UnitFilePreset");
            ::boost::shared_ptr< UnitFilePresetGet > payload(new UnitFilePresetGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onUnitFilePresetGet (payload);
            return;
        }
        case 38: {
            LOG_DEBUG_STUB("process property '%s'", "InactiveExitTimestamp");
            ::boost::shared_ptr< InactiveExitTimestampGet > payload(new InactiveExitTimestampGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onInactiveExitTimestampGet (payload);
            return;
        }
        case 39: {
            LOG_DEBUG_STUB("process property '%s'", "InactiveExitTimestampMonotonic");
            ::boost::shared_ptr< InactiveExitTimestampMonotonicGet > payload(new InactiveExitTimestampMonotonicGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onInactiveExitTimestampMonotonicGet (payload);
            return;
        }
        case 40: {
            LOG_DEBUG_STUB("process property '%s'", "ActiveEnterTimestamp");
            ::boost::shared_ptr< ActiveEnterTimestampGet > payload(new ActiveEnterTimestampGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onActiveEnterTimestampGet (payload);
            return;
        }
        case 41: {
            LOG_DEBUG_STUB("process property '%s'", "ActiveEnterTimestampMonotonic");
            ::boost::shared_ptr< ActiveEnterTimestampMonotonicGet > payload(new ActiveEnterTimestampMonotonicGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onActiveEnterTimestampMonotonicGet (payload);
            return;
        }
        case 42: {
            LOG_DEBUG_STUB("process property '%s'", "ActiveExitTimestamp");
            ::boost::shared_ptr< ActiveExitTimestampGet > payload(new ActiveExitTimestampGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onActiveExitTimestampGet (payload);
            return;
        }
        case 43: {
            LOG_DEBUG_STUB("process property '%s'", "ActiveExitTimestampMonotonic");
            ::boost::shared_ptr< ActiveExitTimestampMonotonicGet > payload(new ActiveExitTimestampMonotonicGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onActiveExitTimestampMonotonicGet (payload);
            return;
        }
        case 44: {
            LOG_DEBUG_STUB("process property '%s'", "InactiveEnterTimestamp");
            ::boost::shared_ptr< InactiveEnterTimestampGet > payload(new InactiveEnterTimestampGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onInactiveEnterTimestampGet (payload);
            return;
        }
        case 45: {
            LOG_DEBUG_STUB("process property '%s'", "InactiveEnterTimestampMonotonic");
            ::boost::shared_ptr< InactiveEnterTimestampMonotonicGet > payload(new InactiveEnterTimestampMonotonicGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onInactiveEnterTimestampMonotonicGet (payload);
            return;
        }
        case 46: {
            LOG_DEBUG_STUB("process property '%s'", "CanStart");
            ::boost::shared_ptr< CanStartGet > payload(new CanStartGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onCanStartGet (payload);
            return;
        }
        case 47: {
            LOG_DEBUG_STUB("process property '%s'", "CanStop");
            ::boost::shared_ptr< CanStopGet > payload(new CanStopGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onCanStopGet (payload);
            return;
        }
        case 48: {
            LOG_DEBUG_STUB("process property '%s'", "CanReload");
            ::boost::shared_ptr< CanReloadGet > payload(new CanReloadGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onCanReloadGet (payload);
            return;
        }
        case 49: {
            LOG_DEBUG_STUB("process property '%s'", "CanIsolate");
            ::boost::shared_ptr< CanIsolateGet > payload(new CanIsolateGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onCanIsolateGet (payload);
            return;
        }
        case 50: {
            LOG_DEBUG_STUB("process property '%s'", "Job");
            ::boost::shared_ptr< JobGet > payload(new JobGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onJobGet (payload);
            return;
        }
        case 51: {
            LOG_DEBUG_STUB("process property '%s'", "StopWhenUnneeded");
            ::boost::shared_ptr< StopWhenUnneededGet > payload(new StopWhenUnneededGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onStopWhenUnneededGet (payload);
            return;
        }
        case 52: {
            LOG_DEBUG_STUB("process property '%s'", "RefuseManualStart");
            ::boost::shared_ptr< RefuseManualStartGet > payload(new RefuseManualStartGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onRefuseManualStartGet (payload);
            return;
        }
        case 53: {
            LOG_DEBUG_STUB("process property '%s'", "RefuseManualStop");
            ::boost::shared_ptr< RefuseManualStopGet > payload(new RefuseManualStopGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onRefuseManualStopGet (payload);
            return;
        }
        case 54: {
            LOG_DEBUG_STUB("process property '%s'", "AllowIsolate");
            ::boost::shared_ptr< AllowIsolateGet > payload(new AllowIsolateGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onAllowIsolateGet (payload);
            return;
        }
        case 55: {
            LOG_DEBUG_STUB("process property '%s'", "DefaultDependencies");
            ::boost::shared_ptr< DefaultDependenciesGet > payload(new DefaultDependenciesGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onDefaultDependenciesGet (payload);
            return;
        }
        case 56: {
            LOG_DEBUG_STUB("process property '%s'", "OnFailureJobMode");
            ::boost::shared_ptr< OnFailureJobModeGet > payload(new OnFailureJobModeGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onOnFailureJobModeGet (payload);
            return;
        }
        case 57: {
            LOG_DEBUG_STUB("process property '%s'", "IgnoreOnIsolate");
            ::boost::shared_ptr< IgnoreOnIsolateGet > payload(new IgnoreOnIsolateGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onIgnoreOnIsolateGet (payload);
            return;
        }
        case 58: {
            LOG_DEBUG_STUB("process property '%s'", "IgnoreOnSnapshot");
            ::boost::shared_ptr< IgnoreOnSnapshotGet > payload(new IgnoreOnSnapshotGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onIgnoreOnSnapshotGet (payload);
            return;
        }
        case 59: {
            LOG_DEBUG_STUB("process property '%s'", "NeedDaemonReload");
            ::boost::shared_ptr< NeedDaemonReloadGet > payload(new NeedDaemonReloadGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onNeedDaemonReloadGet (payload);
            return;
        }
        case 60: {
            LOG_DEBUG_STUB("process property '%s'", "JobTimeoutUSec");
            ::boost::shared_ptr< JobTimeoutUSecGet > payload(new JobTimeoutUSecGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onJobTimeoutUSecGet (payload);
            return;
        }
        case 61: {
            LOG_DEBUG_STUB("process property '%s'", "JobTimeoutAction");
            ::boost::shared_ptr< JobTimeoutActionGet > payload(new JobTimeoutActionGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onJobTimeoutActionGet (payload);
            return;
        }
        case 62: {
            LOG_DEBUG_STUB("process property '%s'", "JobTimeoutRebootArgument");
            ::boost::shared_ptr< JobTimeoutRebootArgumentGet > payload(new JobTimeoutRebootArgumentGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onJobTimeoutRebootArgumentGet (payload);
            return;
        }
        case 63: {
            LOG_DEBUG_STUB("process property '%s'", "ConditionResult");
            ::boost::shared_ptr< ConditionResultGet > payload(new ConditionResultGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onConditionResultGet (payload);
            return;
        }
        case 64: {
            LOG_DEBUG_STUB("process property '%s'", "AssertResult");
            ::boost::shared_ptr< AssertResultGet > payload(new AssertResultGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onAssertResultGet (payload);
            return;
        }
        case 65: {
            LOG_DEBUG_STUB("process property '%s'", "ConditionTimestamp");
            ::boost::shared_ptr< ConditionTimestampGet > payload(new ConditionTimestampGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onConditionTimestampGet (payload);
            return;
        }
        case 66: {
            LOG_DEBUG_STUB("process property '%s'", "ConditionTimestampMonotonic");
            ::boost::shared_ptr< ConditionTimestampMonotonicGet > payload(new ConditionTimestampMonotonicGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onConditionTimestampMonotonicGet (payload);
            return;
        }
        case 67: {
            LOG_DEBUG_STUB("process property '%s'", "AssertTimestamp");
            ::boost::shared_ptr< AssertTimestampGet > payload(new AssertTimestampGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onAssertTimestampGet (payload);
            return;
        }
        case 68: {
            LOG_DEBUG_STUB("process property '%s'", "AssertTimestampMonotonic");
            ::boost::shared_ptr< AssertTimestampMonotonicGet > payload(new AssertTimestampMonotonicGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onAssertTimestampMonotonicGet (payload);
            return;
        }
        case 69: {
            LOG_DEBUG_STUB("process property '%s'", "Conditions");
            ::boost::shared_ptr< ConditionsGet > payload(new ConditionsGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onConditionsGet (payload);
            return;
        }
        case 70: {
            LOG_DEBUG_STUB("process property '%s'", "Asserts");
            ::boost::shared_ptr< AssertsGet > payload(new AssertsGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onAssertsGet (payload);
            return;
        }
        case 71: {
            LOG_DEBUG_STUB("process property '%s'", "LoadError");
            ::boost::shared_ptr< LoadErrorGet > payload(new LoadErrorGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onLoadErrorGet (payload);
            return;
        }
        case 72: {
            LOG_DEBUG_STUB("process property '%s'", "Transient");
            ::boost::shared_ptr< TransientGet > payload(new TransientGet());
            payload->setAct(act);
            static_cast<UnitStub*>(getStub())->onTransientGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

UnitStub::UnitStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new UnitStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

UnitStub::UnitStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new UnitStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

UnitStub::~UnitStub() {
    delete _stubDelegate;
}

void UnitStub::sendIdUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        IdUpdate payload(_IdProperty);

        LOG_INFO ("-> send%s", "IdUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Id", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "IdUpdate");
    }
}

void UnitStub::onIdGet(const ::boost::shared_ptr< IdGet >& id) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "IdGet", id->getAct());
    sendIdGetUpdate(_IdProperty.getId(), id->getAct());
}

void UnitStub::sendIdGetUpdate(const ::std::string& id, act_t act) {
    ::asf::dbus::DBusVariant variant;
    IdGet payload(id);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "IdGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setId(const ::std::string& id) {
    if(id!=_IdProperty.getId()) {
        _IdProperty.setId(id);
        sendIdUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& UnitStub::getId() const {
    return _IdProperty.getId();
}

::std::string& UnitStub::getIdMutable() {
    return _IdProperty.getIdMutable();
}

void UnitStub::sendNamesUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        NamesUpdate payload(_NamesProperty);

        LOG_INFO ("-> send%s", "NamesUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Names", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "NamesUpdate");
    }
}

void UnitStub::onNamesGet(const ::boost::shared_ptr< NamesGet >& names) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "NamesGet", names->getAct());
    sendNamesGetUpdate(_NamesProperty.getNames(), names->getAct());
}

void UnitStub::sendNamesGetUpdate(const ::std::vector< ::std::string >& names, act_t act) {
    ::asf::dbus::DBusVariant variant;
    NamesGet payload(names);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "NamesGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setNames(const ::std::vector< ::std::string >& names) {
    if(names!=_NamesProperty.getNames()) {
        _NamesProperty.setNames(names);
        sendNamesUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::string >& UnitStub::getNames() const {
    return _NamesProperty.getNames();
}

::std::vector< ::std::string >& UnitStub::getNamesMutable() {
    return _NamesProperty.getNamesMutable();
}

void UnitStub::sendFollowingUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        FollowingUpdate payload(_FollowingProperty);

        LOG_INFO ("-> send%s", "FollowingUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Following", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "FollowingUpdate");
    }
}

void UnitStub::onFollowingGet(const ::boost::shared_ptr< FollowingGet >& following) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "FollowingGet", following->getAct());
    sendFollowingGetUpdate(_FollowingProperty.getFollowing(), following->getAct());
}

void UnitStub::sendFollowingGetUpdate(const ::std::string& following, act_t act) {
    ::asf::dbus::DBusVariant variant;
    FollowingGet payload(following);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "FollowingGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setFollowing(const ::std::string& following) {
    if(following!=_FollowingProperty.getFollowing()) {
        _FollowingProperty.setFollowing(following);
        sendFollowingUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& UnitStub::getFollowing() const {
    return _FollowingProperty.getFollowing();
}

::std::string& UnitStub::getFollowingMutable() {
    return _FollowingProperty.getFollowingMutable();
}

void UnitStub::sendRequiresUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        RequiresUpdate payload(_RequiresProperty);

        LOG_INFO ("-> send%s", "RequiresUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Requires", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "RequiresUpdate");
    }
}

void UnitStub::onRequiresGet(const ::boost::shared_ptr< RequiresGet >& requires) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "RequiresGet", requires->getAct());
    sendRequiresGetUpdate(_RequiresProperty.getRequires(), requires->getAct());
}

void UnitStub::sendRequiresGetUpdate(const ::std::vector< ::std::string >& requires, act_t act) {
    ::asf::dbus::DBusVariant variant;
    RequiresGet payload(requires);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "RequiresGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setRequires(const ::std::vector< ::std::string >& requires) {
    if(requires!=_RequiresProperty.getRequires()) {
        _RequiresProperty.setRequires(requires);
        sendRequiresUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::string >& UnitStub::getRequires() const {
    return _RequiresProperty.getRequires();
}

::std::vector< ::std::string >& UnitStub::getRequiresMutable() {
    return _RequiresProperty.getRequiresMutable();
}

void UnitStub::sendRequiresOverridableUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        RequiresOverridableUpdate payload(_RequiresOverridableProperty);

        LOG_INFO ("-> send%s", "RequiresOverridableUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("RequiresOverridable", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "RequiresOverridableUpdate");
    }
}

void UnitStub::onRequiresOverridableGet(const ::boost::shared_ptr< RequiresOverridableGet >& requiresOverridable) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "RequiresOverridableGet", requiresOverridable->getAct());
    sendRequiresOverridableGetUpdate(_RequiresOverridableProperty.getRequiresOverridable(), requiresOverridable->getAct());
}

void UnitStub::sendRequiresOverridableGetUpdate(const ::std::vector< ::std::string >& requiresOverridable, act_t act) {
    ::asf::dbus::DBusVariant variant;
    RequiresOverridableGet payload(requiresOverridable);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "RequiresOverridableGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setRequiresOverridable(const ::std::vector< ::std::string >& requiresOverridable) {
    if(requiresOverridable!=_RequiresOverridableProperty.getRequiresOverridable()) {
        _RequiresOverridableProperty.setRequiresOverridable(requiresOverridable);
        sendRequiresOverridableUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::string >& UnitStub::getRequiresOverridable() const {
    return _RequiresOverridableProperty.getRequiresOverridable();
}

::std::vector< ::std::string >& UnitStub::getRequiresOverridableMutable() {
    return _RequiresOverridableProperty.getRequiresOverridableMutable();
}

void UnitStub::sendRequisiteUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        RequisiteUpdate payload(_RequisiteProperty);

        LOG_INFO ("-> send%s", "RequisiteUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Requisite", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "RequisiteUpdate");
    }
}

void UnitStub::onRequisiteGet(const ::boost::shared_ptr< RequisiteGet >& requisite) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "RequisiteGet", requisite->getAct());
    sendRequisiteGetUpdate(_RequisiteProperty.getRequisite(), requisite->getAct());
}

void UnitStub::sendRequisiteGetUpdate(const ::std::vector< ::std::string >& requisite, act_t act) {
    ::asf::dbus::DBusVariant variant;
    RequisiteGet payload(requisite);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "RequisiteGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setRequisite(const ::std::vector< ::std::string >& requisite) {
    if(requisite!=_RequisiteProperty.getRequisite()) {
        _RequisiteProperty.setRequisite(requisite);
        sendRequisiteUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::string >& UnitStub::getRequisite() const {
    return _RequisiteProperty.getRequisite();
}

::std::vector< ::std::string >& UnitStub::getRequisiteMutable() {
    return _RequisiteProperty.getRequisiteMutable();
}

void UnitStub::sendRequisiteOverridableUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        RequisiteOverridableUpdate payload(_RequisiteOverridableProperty);

        LOG_INFO ("-> send%s", "RequisiteOverridableUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("RequisiteOverridable", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "RequisiteOverridableUpdate");
    }
}

void UnitStub::onRequisiteOverridableGet(const ::boost::shared_ptr< RequisiteOverridableGet >& requisiteOverridable) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "RequisiteOverridableGet", requisiteOverridable->getAct());
    sendRequisiteOverridableGetUpdate(_RequisiteOverridableProperty.getRequisiteOverridable(), requisiteOverridable->getAct());
}

void UnitStub::sendRequisiteOverridableGetUpdate(const ::std::vector< ::std::string >& requisiteOverridable, act_t act) {
    ::asf::dbus::DBusVariant variant;
    RequisiteOverridableGet payload(requisiteOverridable);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "RequisiteOverridableGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setRequisiteOverridable(const ::std::vector< ::std::string >& requisiteOverridable) {
    if(requisiteOverridable!=_RequisiteOverridableProperty.getRequisiteOverridable()) {
        _RequisiteOverridableProperty.setRequisiteOverridable(requisiteOverridable);
        sendRequisiteOverridableUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::string >& UnitStub::getRequisiteOverridable() const {
    return _RequisiteOverridableProperty.getRequisiteOverridable();
}

::std::vector< ::std::string >& UnitStub::getRequisiteOverridableMutable() {
    return _RequisiteOverridableProperty.getRequisiteOverridableMutable();
}

void UnitStub::sendWantsUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        WantsUpdate payload(_WantsProperty);

        LOG_INFO ("-> send%s", "WantsUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Wants", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "WantsUpdate");
    }
}

void UnitStub::onWantsGet(const ::boost::shared_ptr< WantsGet >& wants) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "WantsGet", wants->getAct());
    sendWantsGetUpdate(_WantsProperty.getWants(), wants->getAct());
}

void UnitStub::sendWantsGetUpdate(const ::std::vector< ::std::string >& wants, act_t act) {
    ::asf::dbus::DBusVariant variant;
    WantsGet payload(wants);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "WantsGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setWants(const ::std::vector< ::std::string >& wants) {
    if(wants!=_WantsProperty.getWants()) {
        _WantsProperty.setWants(wants);
        sendWantsUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::string >& UnitStub::getWants() const {
    return _WantsProperty.getWants();
}

::std::vector< ::std::string >& UnitStub::getWantsMutable() {
    return _WantsProperty.getWantsMutable();
}

void UnitStub::sendBindsToUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        BindsToUpdate payload(_BindsToProperty);

        LOG_INFO ("-> send%s", "BindsToUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("BindsTo", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "BindsToUpdate");
    }
}

void UnitStub::onBindsToGet(const ::boost::shared_ptr< BindsToGet >& bindsTo) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "BindsToGet", bindsTo->getAct());
    sendBindsToGetUpdate(_BindsToProperty.getBindsTo(), bindsTo->getAct());
}

void UnitStub::sendBindsToGetUpdate(const ::std::vector< ::std::string >& bindsTo, act_t act) {
    ::asf::dbus::DBusVariant variant;
    BindsToGet payload(bindsTo);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "BindsToGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setBindsTo(const ::std::vector< ::std::string >& bindsTo) {
    if(bindsTo!=_BindsToProperty.getBindsTo()) {
        _BindsToProperty.setBindsTo(bindsTo);
        sendBindsToUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::string >& UnitStub::getBindsTo() const {
    return _BindsToProperty.getBindsTo();
}

::std::vector< ::std::string >& UnitStub::getBindsToMutable() {
    return _BindsToProperty.getBindsToMutable();
}

void UnitStub::sendPartOfUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        PartOfUpdate payload(_PartOfProperty);

        LOG_INFO ("-> send%s", "PartOfUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("PartOf", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "PartOfUpdate");
    }
}

void UnitStub::onPartOfGet(const ::boost::shared_ptr< PartOfGet >& partOf) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "PartOfGet", partOf->getAct());
    sendPartOfGetUpdate(_PartOfProperty.getPartOf(), partOf->getAct());
}

void UnitStub::sendPartOfGetUpdate(const ::std::vector< ::std::string >& partOf, act_t act) {
    ::asf::dbus::DBusVariant variant;
    PartOfGet payload(partOf);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "PartOfGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setPartOf(const ::std::vector< ::std::string >& partOf) {
    if(partOf!=_PartOfProperty.getPartOf()) {
        _PartOfProperty.setPartOf(partOf);
        sendPartOfUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::string >& UnitStub::getPartOf() const {
    return _PartOfProperty.getPartOf();
}

::std::vector< ::std::string >& UnitStub::getPartOfMutable() {
    return _PartOfProperty.getPartOfMutable();
}

void UnitStub::sendRequiredByUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        RequiredByUpdate payload(_RequiredByProperty);

        LOG_INFO ("-> send%s", "RequiredByUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("RequiredBy", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "RequiredByUpdate");
    }
}

void UnitStub::onRequiredByGet(const ::boost::shared_ptr< RequiredByGet >& requiredBy) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "RequiredByGet", requiredBy->getAct());
    sendRequiredByGetUpdate(_RequiredByProperty.getRequiredBy(), requiredBy->getAct());
}

void UnitStub::sendRequiredByGetUpdate(const ::std::vector< ::std::string >& requiredBy, act_t act) {
    ::asf::dbus::DBusVariant variant;
    RequiredByGet payload(requiredBy);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "RequiredByGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setRequiredBy(const ::std::vector< ::std::string >& requiredBy) {
    if(requiredBy!=_RequiredByProperty.getRequiredBy()) {
        _RequiredByProperty.setRequiredBy(requiredBy);
        sendRequiredByUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::string >& UnitStub::getRequiredBy() const {
    return _RequiredByProperty.getRequiredBy();
}

::std::vector< ::std::string >& UnitStub::getRequiredByMutable() {
    return _RequiredByProperty.getRequiredByMutable();
}

void UnitStub::sendRequiredByOverridableUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        RequiredByOverridableUpdate payload(_RequiredByOverridableProperty);

        LOG_INFO ("-> send%s", "RequiredByOverridableUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("RequiredByOverridable", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "RequiredByOverridableUpdate");
    }
}

void UnitStub::onRequiredByOverridableGet(const ::boost::shared_ptr< RequiredByOverridableGet >& requiredByOverridable) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "RequiredByOverridableGet", requiredByOverridable->getAct());
    sendRequiredByOverridableGetUpdate(_RequiredByOverridableProperty.getRequiredByOverridable(), requiredByOverridable->getAct());
}

void UnitStub::sendRequiredByOverridableGetUpdate(const ::std::vector< ::std::string >& requiredByOverridable, act_t act) {
    ::asf::dbus::DBusVariant variant;
    RequiredByOverridableGet payload(requiredByOverridable);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "RequiredByOverridableGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setRequiredByOverridable(const ::std::vector< ::std::string >& requiredByOverridable) {
    if(requiredByOverridable!=_RequiredByOverridableProperty.getRequiredByOverridable()) {
        _RequiredByOverridableProperty.setRequiredByOverridable(requiredByOverridable);
        sendRequiredByOverridableUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::string >& UnitStub::getRequiredByOverridable() const {
    return _RequiredByOverridableProperty.getRequiredByOverridable();
}

::std::vector< ::std::string >& UnitStub::getRequiredByOverridableMutable() {
    return _RequiredByOverridableProperty.getRequiredByOverridableMutable();
}

void UnitStub::sendRequisiteOfUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        RequisiteOfUpdate payload(_RequisiteOfProperty);

        LOG_INFO ("-> send%s", "RequisiteOfUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("RequisiteOf", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "RequisiteOfUpdate");
    }
}

void UnitStub::onRequisiteOfGet(const ::boost::shared_ptr< RequisiteOfGet >& requisiteOf) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "RequisiteOfGet", requisiteOf->getAct());
    sendRequisiteOfGetUpdate(_RequisiteOfProperty.getRequisiteOf(), requisiteOf->getAct());
}

void UnitStub::sendRequisiteOfGetUpdate(const ::std::vector< ::std::string >& requisiteOf, act_t act) {
    ::asf::dbus::DBusVariant variant;
    RequisiteOfGet payload(requisiteOf);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "RequisiteOfGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setRequisiteOf(const ::std::vector< ::std::string >& requisiteOf) {
    if(requisiteOf!=_RequisiteOfProperty.getRequisiteOf()) {
        _RequisiteOfProperty.setRequisiteOf(requisiteOf);
        sendRequisiteOfUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::string >& UnitStub::getRequisiteOf() const {
    return _RequisiteOfProperty.getRequisiteOf();
}

::std::vector< ::std::string >& UnitStub::getRequisiteOfMutable() {
    return _RequisiteOfProperty.getRequisiteOfMutable();
}

void UnitStub::sendRequisiteOfOverridableUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        RequisiteOfOverridableUpdate payload(_RequisiteOfOverridableProperty);

        LOG_INFO ("-> send%s", "RequisiteOfOverridableUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("RequisiteOfOverridable", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "RequisiteOfOverridableUpdate");
    }
}

void UnitStub::onRequisiteOfOverridableGet(const ::boost::shared_ptr< RequisiteOfOverridableGet >& requisiteOfOverridable) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "RequisiteOfOverridableGet", requisiteOfOverridable->getAct());
    sendRequisiteOfOverridableGetUpdate(_RequisiteOfOverridableProperty.getRequisiteOfOverridable(), requisiteOfOverridable->getAct());
}

void UnitStub::sendRequisiteOfOverridableGetUpdate(const ::std::vector< ::std::string >& requisiteOfOverridable, act_t act) {
    ::asf::dbus::DBusVariant variant;
    RequisiteOfOverridableGet payload(requisiteOfOverridable);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "RequisiteOfOverridableGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setRequisiteOfOverridable(const ::std::vector< ::std::string >& requisiteOfOverridable) {
    if(requisiteOfOverridable!=_RequisiteOfOverridableProperty.getRequisiteOfOverridable()) {
        _RequisiteOfOverridableProperty.setRequisiteOfOverridable(requisiteOfOverridable);
        sendRequisiteOfOverridableUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::string >& UnitStub::getRequisiteOfOverridable() const {
    return _RequisiteOfOverridableProperty.getRequisiteOfOverridable();
}

::std::vector< ::std::string >& UnitStub::getRequisiteOfOverridableMutable() {
    return _RequisiteOfOverridableProperty.getRequisiteOfOverridableMutable();
}

void UnitStub::sendWantedByUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        WantedByUpdate payload(_WantedByProperty);

        LOG_INFO ("-> send%s", "WantedByUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("WantedBy", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "WantedByUpdate");
    }
}

void UnitStub::onWantedByGet(const ::boost::shared_ptr< WantedByGet >& wantedBy) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "WantedByGet", wantedBy->getAct());
    sendWantedByGetUpdate(_WantedByProperty.getWantedBy(), wantedBy->getAct());
}

void UnitStub::sendWantedByGetUpdate(const ::std::vector< ::std::string >& wantedBy, act_t act) {
    ::asf::dbus::DBusVariant variant;
    WantedByGet payload(wantedBy);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "WantedByGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setWantedBy(const ::std::vector< ::std::string >& wantedBy) {
    if(wantedBy!=_WantedByProperty.getWantedBy()) {
        _WantedByProperty.setWantedBy(wantedBy);
        sendWantedByUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::string >& UnitStub::getWantedBy() const {
    return _WantedByProperty.getWantedBy();
}

::std::vector< ::std::string >& UnitStub::getWantedByMutable() {
    return _WantedByProperty.getWantedByMutable();
}

void UnitStub::sendBoundByUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        BoundByUpdate payload(_BoundByProperty);

        LOG_INFO ("-> send%s", "BoundByUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("BoundBy", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "BoundByUpdate");
    }
}

void UnitStub::onBoundByGet(const ::boost::shared_ptr< BoundByGet >& boundBy) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "BoundByGet", boundBy->getAct());
    sendBoundByGetUpdate(_BoundByProperty.getBoundBy(), boundBy->getAct());
}

void UnitStub::sendBoundByGetUpdate(const ::std::vector< ::std::string >& boundBy, act_t act) {
    ::asf::dbus::DBusVariant variant;
    BoundByGet payload(boundBy);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "BoundByGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setBoundBy(const ::std::vector< ::std::string >& boundBy) {
    if(boundBy!=_BoundByProperty.getBoundBy()) {
        _BoundByProperty.setBoundBy(boundBy);
        sendBoundByUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::string >& UnitStub::getBoundBy() const {
    return _BoundByProperty.getBoundBy();
}

::std::vector< ::std::string >& UnitStub::getBoundByMutable() {
    return _BoundByProperty.getBoundByMutable();
}

void UnitStub::sendConsistsOfUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ConsistsOfUpdate payload(_ConsistsOfProperty);

        LOG_INFO ("-> send%s", "ConsistsOfUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ConsistsOf", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ConsistsOfUpdate");
    }
}

void UnitStub::onConsistsOfGet(const ::boost::shared_ptr< ConsistsOfGet >& consistsOf) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ConsistsOfGet", consistsOf->getAct());
    sendConsistsOfGetUpdate(_ConsistsOfProperty.getConsistsOf(), consistsOf->getAct());
}

void UnitStub::sendConsistsOfGetUpdate(const ::std::vector< ::std::string >& consistsOf, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ConsistsOfGet payload(consistsOf);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ConsistsOfGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setConsistsOf(const ::std::vector< ::std::string >& consistsOf) {
    if(consistsOf!=_ConsistsOfProperty.getConsistsOf()) {
        _ConsistsOfProperty.setConsistsOf(consistsOf);
        sendConsistsOfUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::string >& UnitStub::getConsistsOf() const {
    return _ConsistsOfProperty.getConsistsOf();
}

::std::vector< ::std::string >& UnitStub::getConsistsOfMutable() {
    return _ConsistsOfProperty.getConsistsOfMutable();
}

void UnitStub::sendConflictsUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ConflictsUpdate payload(_ConflictsProperty);

        LOG_INFO ("-> send%s", "ConflictsUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Conflicts", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ConflictsUpdate");
    }
}

void UnitStub::onConflictsGet(const ::boost::shared_ptr< ConflictsGet >& conflicts) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ConflictsGet", conflicts->getAct());
    sendConflictsGetUpdate(_ConflictsProperty.getConflicts(), conflicts->getAct());
}

void UnitStub::sendConflictsGetUpdate(const ::std::vector< ::std::string >& conflicts, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ConflictsGet payload(conflicts);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ConflictsGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setConflicts(const ::std::vector< ::std::string >& conflicts) {
    if(conflicts!=_ConflictsProperty.getConflicts()) {
        _ConflictsProperty.setConflicts(conflicts);
        sendConflictsUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::string >& UnitStub::getConflicts() const {
    return _ConflictsProperty.getConflicts();
}

::std::vector< ::std::string >& UnitStub::getConflictsMutable() {
    return _ConflictsProperty.getConflictsMutable();
}

void UnitStub::sendConflictedByUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ConflictedByUpdate payload(_ConflictedByProperty);

        LOG_INFO ("-> send%s", "ConflictedByUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ConflictedBy", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ConflictedByUpdate");
    }
}

void UnitStub::onConflictedByGet(const ::boost::shared_ptr< ConflictedByGet >& conflictedBy) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ConflictedByGet", conflictedBy->getAct());
    sendConflictedByGetUpdate(_ConflictedByProperty.getConflictedBy(), conflictedBy->getAct());
}

void UnitStub::sendConflictedByGetUpdate(const ::std::vector< ::std::string >& conflictedBy, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ConflictedByGet payload(conflictedBy);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ConflictedByGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setConflictedBy(const ::std::vector< ::std::string >& conflictedBy) {
    if(conflictedBy!=_ConflictedByProperty.getConflictedBy()) {
        _ConflictedByProperty.setConflictedBy(conflictedBy);
        sendConflictedByUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::string >& UnitStub::getConflictedBy() const {
    return _ConflictedByProperty.getConflictedBy();
}

::std::vector< ::std::string >& UnitStub::getConflictedByMutable() {
    return _ConflictedByProperty.getConflictedByMutable();
}

void UnitStub::sendBeforeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        BeforeUpdate payload(_BeforeProperty);

        LOG_INFO ("-> send%s", "BeforeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Before", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "BeforeUpdate");
    }
}

void UnitStub::onBeforeGet(const ::boost::shared_ptr< BeforeGet >& before) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "BeforeGet", before->getAct());
    sendBeforeGetUpdate(_BeforeProperty.getBefore(), before->getAct());
}

void UnitStub::sendBeforeGetUpdate(const ::std::vector< ::std::string >& before, act_t act) {
    ::asf::dbus::DBusVariant variant;
    BeforeGet payload(before);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "BeforeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setBefore(const ::std::vector< ::std::string >& before) {
    if(before!=_BeforeProperty.getBefore()) {
        _BeforeProperty.setBefore(before);
        sendBeforeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::string >& UnitStub::getBefore() const {
    return _BeforeProperty.getBefore();
}

::std::vector< ::std::string >& UnitStub::getBeforeMutable() {
    return _BeforeProperty.getBeforeMutable();
}

void UnitStub::sendAfterUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        AfterUpdate payload(_AfterProperty);

        LOG_INFO ("-> send%s", "AfterUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("After", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "AfterUpdate");
    }
}

void UnitStub::onAfterGet(const ::boost::shared_ptr< AfterGet >& after) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AfterGet", after->getAct());
    sendAfterGetUpdate(_AfterProperty.getAfter(), after->getAct());
}

void UnitStub::sendAfterGetUpdate(const ::std::vector< ::std::string >& after, act_t act) {
    ::asf::dbus::DBusVariant variant;
    AfterGet payload(after);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AfterGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setAfter(const ::std::vector< ::std::string >& after) {
    if(after!=_AfterProperty.getAfter()) {
        _AfterProperty.setAfter(after);
        sendAfterUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::string >& UnitStub::getAfter() const {
    return _AfterProperty.getAfter();
}

::std::vector< ::std::string >& UnitStub::getAfterMutable() {
    return _AfterProperty.getAfterMutable();
}

void UnitStub::sendOnFailureUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        OnFailureUpdate payload(_OnFailureProperty);

        LOG_INFO ("-> send%s", "OnFailureUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("OnFailure", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "OnFailureUpdate");
    }
}

void UnitStub::onOnFailureGet(const ::boost::shared_ptr< OnFailureGet >& onFailure) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "OnFailureGet", onFailure->getAct());
    sendOnFailureGetUpdate(_OnFailureProperty.getOnFailure(), onFailure->getAct());
}

void UnitStub::sendOnFailureGetUpdate(const ::std::vector< ::std::string >& onFailure, act_t act) {
    ::asf::dbus::DBusVariant variant;
    OnFailureGet payload(onFailure);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "OnFailureGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setOnFailure(const ::std::vector< ::std::string >& onFailure) {
    if(onFailure!=_OnFailureProperty.getOnFailure()) {
        _OnFailureProperty.setOnFailure(onFailure);
        sendOnFailureUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::string >& UnitStub::getOnFailure() const {
    return _OnFailureProperty.getOnFailure();
}

::std::vector< ::std::string >& UnitStub::getOnFailureMutable() {
    return _OnFailureProperty.getOnFailureMutable();
}

void UnitStub::sendTriggersUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        TriggersUpdate payload(_TriggersProperty);

        LOG_INFO ("-> send%s", "TriggersUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Triggers", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "TriggersUpdate");
    }
}

void UnitStub::onTriggersGet(const ::boost::shared_ptr< TriggersGet >& triggers) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "TriggersGet", triggers->getAct());
    sendTriggersGetUpdate(_TriggersProperty.getTriggers(), triggers->getAct());
}

void UnitStub::sendTriggersGetUpdate(const ::std::vector< ::std::string >& triggers, act_t act) {
    ::asf::dbus::DBusVariant variant;
    TriggersGet payload(triggers);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "TriggersGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setTriggers(const ::std::vector< ::std::string >& triggers) {
    if(triggers!=_TriggersProperty.getTriggers()) {
        _TriggersProperty.setTriggers(triggers);
        sendTriggersUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::string >& UnitStub::getTriggers() const {
    return _TriggersProperty.getTriggers();
}

::std::vector< ::std::string >& UnitStub::getTriggersMutable() {
    return _TriggersProperty.getTriggersMutable();
}

void UnitStub::sendTriggeredByUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        TriggeredByUpdate payload(_TriggeredByProperty);

        LOG_INFO ("-> send%s", "TriggeredByUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("TriggeredBy", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "TriggeredByUpdate");
    }
}

void UnitStub::onTriggeredByGet(const ::boost::shared_ptr< TriggeredByGet >& triggeredBy) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "TriggeredByGet", triggeredBy->getAct());
    sendTriggeredByGetUpdate(_TriggeredByProperty.getTriggeredBy(), triggeredBy->getAct());
}

void UnitStub::sendTriggeredByGetUpdate(const ::std::vector< ::std::string >& triggeredBy, act_t act) {
    ::asf::dbus::DBusVariant variant;
    TriggeredByGet payload(triggeredBy);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "TriggeredByGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setTriggeredBy(const ::std::vector< ::std::string >& triggeredBy) {
    if(triggeredBy!=_TriggeredByProperty.getTriggeredBy()) {
        _TriggeredByProperty.setTriggeredBy(triggeredBy);
        sendTriggeredByUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::string >& UnitStub::getTriggeredBy() const {
    return _TriggeredByProperty.getTriggeredBy();
}

::std::vector< ::std::string >& UnitStub::getTriggeredByMutable() {
    return _TriggeredByProperty.getTriggeredByMutable();
}

void UnitStub::sendPropagatesReloadToUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        PropagatesReloadToUpdate payload(_PropagatesReloadToProperty);

        LOG_INFO ("-> send%s", "PropagatesReloadToUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("PropagatesReloadTo", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "PropagatesReloadToUpdate");
    }
}

void UnitStub::onPropagatesReloadToGet(const ::boost::shared_ptr< PropagatesReloadToGet >& propagatesReloadTo) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "PropagatesReloadToGet", propagatesReloadTo->getAct());
    sendPropagatesReloadToGetUpdate(_PropagatesReloadToProperty.getPropagatesReloadTo(), propagatesReloadTo->getAct());
}

void UnitStub::sendPropagatesReloadToGetUpdate(const ::std::vector< ::std::string >& propagatesReloadTo, act_t act) {
    ::asf::dbus::DBusVariant variant;
    PropagatesReloadToGet payload(propagatesReloadTo);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "PropagatesReloadToGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setPropagatesReloadTo(const ::std::vector< ::std::string >& propagatesReloadTo) {
    if(propagatesReloadTo!=_PropagatesReloadToProperty.getPropagatesReloadTo()) {
        _PropagatesReloadToProperty.setPropagatesReloadTo(propagatesReloadTo);
        sendPropagatesReloadToUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::string >& UnitStub::getPropagatesReloadTo() const {
    return _PropagatesReloadToProperty.getPropagatesReloadTo();
}

::std::vector< ::std::string >& UnitStub::getPropagatesReloadToMutable() {
    return _PropagatesReloadToProperty.getPropagatesReloadToMutable();
}

void UnitStub::sendReloadPropagatedFromUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ReloadPropagatedFromUpdate payload(_ReloadPropagatedFromProperty);

        LOG_INFO ("-> send%s", "ReloadPropagatedFromUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ReloadPropagatedFrom", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ReloadPropagatedFromUpdate");
    }
}

void UnitStub::onReloadPropagatedFromGet(const ::boost::shared_ptr< ReloadPropagatedFromGet >& reloadPropagatedFrom) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ReloadPropagatedFromGet", reloadPropagatedFrom->getAct());
    sendReloadPropagatedFromGetUpdate(_ReloadPropagatedFromProperty.getReloadPropagatedFrom(), reloadPropagatedFrom->getAct());
}

void UnitStub::sendReloadPropagatedFromGetUpdate(const ::std::vector< ::std::string >& reloadPropagatedFrom, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ReloadPropagatedFromGet payload(reloadPropagatedFrom);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ReloadPropagatedFromGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setReloadPropagatedFrom(const ::std::vector< ::std::string >& reloadPropagatedFrom) {
    if(reloadPropagatedFrom!=_ReloadPropagatedFromProperty.getReloadPropagatedFrom()) {
        _ReloadPropagatedFromProperty.setReloadPropagatedFrom(reloadPropagatedFrom);
        sendReloadPropagatedFromUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::string >& UnitStub::getReloadPropagatedFrom() const {
    return _ReloadPropagatedFromProperty.getReloadPropagatedFrom();
}

::std::vector< ::std::string >& UnitStub::getReloadPropagatedFromMutable() {
    return _ReloadPropagatedFromProperty.getReloadPropagatedFromMutable();
}

void UnitStub::sendJoinsNamespaceOfUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        JoinsNamespaceOfUpdate payload(_JoinsNamespaceOfProperty);

        LOG_INFO ("-> send%s", "JoinsNamespaceOfUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("JoinsNamespaceOf", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "JoinsNamespaceOfUpdate");
    }
}

void UnitStub::onJoinsNamespaceOfGet(const ::boost::shared_ptr< JoinsNamespaceOfGet >& joinsNamespaceOf) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "JoinsNamespaceOfGet", joinsNamespaceOf->getAct());
    sendJoinsNamespaceOfGetUpdate(_JoinsNamespaceOfProperty.getJoinsNamespaceOf(), joinsNamespaceOf->getAct());
}

void UnitStub::sendJoinsNamespaceOfGetUpdate(const ::std::vector< ::std::string >& joinsNamespaceOf, act_t act) {
    ::asf::dbus::DBusVariant variant;
    JoinsNamespaceOfGet payload(joinsNamespaceOf);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "JoinsNamespaceOfGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setJoinsNamespaceOf(const ::std::vector< ::std::string >& joinsNamespaceOf) {
    if(joinsNamespaceOf!=_JoinsNamespaceOfProperty.getJoinsNamespaceOf()) {
        _JoinsNamespaceOfProperty.setJoinsNamespaceOf(joinsNamespaceOf);
        sendJoinsNamespaceOfUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::string >& UnitStub::getJoinsNamespaceOf() const {
    return _JoinsNamespaceOfProperty.getJoinsNamespaceOf();
}

::std::vector< ::std::string >& UnitStub::getJoinsNamespaceOfMutable() {
    return _JoinsNamespaceOfProperty.getJoinsNamespaceOfMutable();
}

void UnitStub::sendRequiresMountsForUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        RequiresMountsForUpdate payload(_RequiresMountsForProperty);

        LOG_INFO ("-> send%s", "RequiresMountsForUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("RequiresMountsFor", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "RequiresMountsForUpdate");
    }
}

void UnitStub::onRequiresMountsForGet(const ::boost::shared_ptr< RequiresMountsForGet >& requiresMountsFor) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "RequiresMountsForGet", requiresMountsFor->getAct());
    sendRequiresMountsForGetUpdate(_RequiresMountsForProperty.getRequiresMountsFor(), requiresMountsFor->getAct());
}

void UnitStub::sendRequiresMountsForGetUpdate(const ::std::vector< ::std::string >& requiresMountsFor, act_t act) {
    ::asf::dbus::DBusVariant variant;
    RequiresMountsForGet payload(requiresMountsFor);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "RequiresMountsForGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setRequiresMountsFor(const ::std::vector< ::std::string >& requiresMountsFor) {
    if(requiresMountsFor!=_RequiresMountsForProperty.getRequiresMountsFor()) {
        _RequiresMountsForProperty.setRequiresMountsFor(requiresMountsFor);
        sendRequiresMountsForUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::string >& UnitStub::getRequiresMountsFor() const {
    return _RequiresMountsForProperty.getRequiresMountsFor();
}

::std::vector< ::std::string >& UnitStub::getRequiresMountsForMutable() {
    return _RequiresMountsForProperty.getRequiresMountsForMutable();
}

void UnitStub::sendDocumentationUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        DocumentationUpdate payload(_DocumentationProperty);

        LOG_INFO ("-> send%s", "DocumentationUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Documentation", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "DocumentationUpdate");
    }
}

void UnitStub::onDocumentationGet(const ::boost::shared_ptr< DocumentationGet >& documentation) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DocumentationGet", documentation->getAct());
    sendDocumentationGetUpdate(_DocumentationProperty.getDocumentation(), documentation->getAct());
}

void UnitStub::sendDocumentationGetUpdate(const ::std::vector< ::std::string >& documentation, act_t act) {
    ::asf::dbus::DBusVariant variant;
    DocumentationGet payload(documentation);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DocumentationGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setDocumentation(const ::std::vector< ::std::string >& documentation) {
    if(documentation!=_DocumentationProperty.getDocumentation()) {
        _DocumentationProperty.setDocumentation(documentation);
        sendDocumentationUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::string >& UnitStub::getDocumentation() const {
    return _DocumentationProperty.getDocumentation();
}

::std::vector< ::std::string >& UnitStub::getDocumentationMutable() {
    return _DocumentationProperty.getDocumentationMutable();
}

void UnitStub::sendDescriptionUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        DescriptionUpdate payload(_DescriptionProperty);

        LOG_INFO ("-> send%s", "DescriptionUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Description", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "DescriptionUpdate");
    }
}

void UnitStub::onDescriptionGet(const ::boost::shared_ptr< DescriptionGet >& description) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DescriptionGet", description->getAct());
    sendDescriptionGetUpdate(_DescriptionProperty.getDescription(), description->getAct());
}

void UnitStub::sendDescriptionGetUpdate(const ::std::string& description, act_t act) {
    ::asf::dbus::DBusVariant variant;
    DescriptionGet payload(description);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DescriptionGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setDescription(const ::std::string& description) {
    if(description!=_DescriptionProperty.getDescription()) {
        _DescriptionProperty.setDescription(description);
        sendDescriptionUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& UnitStub::getDescription() const {
    return _DescriptionProperty.getDescription();
}

::std::string& UnitStub::getDescriptionMutable() {
    return _DescriptionProperty.getDescriptionMutable();
}

void UnitStub::sendLoadStateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        LoadStateUpdate payload(_LoadStateProperty);

        LOG_INFO ("-> send%s", "LoadStateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("LoadState", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "LoadStateUpdate");
    }
}

void UnitStub::onLoadStateGet(const ::boost::shared_ptr< LoadStateGet >& loadState) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "LoadStateGet", loadState->getAct());
    sendLoadStateGetUpdate(_LoadStateProperty.getLoadState(), loadState->getAct());
}

void UnitStub::sendLoadStateGetUpdate(const ::std::string& loadState, act_t act) {
    ::asf::dbus::DBusVariant variant;
    LoadStateGet payload(loadState);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "LoadStateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setLoadState(const ::std::string& loadState) {
    if(loadState!=_LoadStateProperty.getLoadState()) {
        _LoadStateProperty.setLoadState(loadState);
        sendLoadStateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& UnitStub::getLoadState() const {
    return _LoadStateProperty.getLoadState();
}

::std::string& UnitStub::getLoadStateMutable() {
    return _LoadStateProperty.getLoadStateMutable();
}

void UnitStub::sendActiveStateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ActiveStateUpdate payload(_ActiveStateProperty);

        LOG_INFO ("-> send%s", "ActiveStateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ActiveState", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ActiveStateUpdate");
    }
}

void UnitStub::onActiveStateGet(const ::boost::shared_ptr< ActiveStateGet >& activeState) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ActiveStateGet", activeState->getAct());
    sendActiveStateGetUpdate(_ActiveStateProperty.getActiveState(), activeState->getAct());
}

void UnitStub::sendActiveStateGetUpdate(const ::std::string& activeState, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ActiveStateGet payload(activeState);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ActiveStateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setActiveState(const ::std::string& activeState) {
    if(activeState!=_ActiveStateProperty.getActiveState()) {
        _ActiveStateProperty.setActiveState(activeState);
        sendActiveStateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& UnitStub::getActiveState() const {
    return _ActiveStateProperty.getActiveState();
}

::std::string& UnitStub::getActiveStateMutable() {
    return _ActiveStateProperty.getActiveStateMutable();
}

void UnitStub::sendSubStateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SubStateUpdate payload(_SubStateProperty);

        LOG_INFO ("-> send%s", "SubStateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("SubState", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SubStateUpdate");
    }
}

void UnitStub::onSubStateGet(const ::boost::shared_ptr< SubStateGet >& subState) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SubStateGet", subState->getAct());
    sendSubStateGetUpdate(_SubStateProperty.getSubState(), subState->getAct());
}

void UnitStub::sendSubStateGetUpdate(const ::std::string& subState, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SubStateGet payload(subState);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SubStateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setSubState(const ::std::string& subState) {
    if(subState!=_SubStateProperty.getSubState()) {
        _SubStateProperty.setSubState(subState);
        sendSubStateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& UnitStub::getSubState() const {
    return _SubStateProperty.getSubState();
}

::std::string& UnitStub::getSubStateMutable() {
    return _SubStateProperty.getSubStateMutable();
}

void UnitStub::sendFragmentPathUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        FragmentPathUpdate payload(_FragmentPathProperty);

        LOG_INFO ("-> send%s", "FragmentPathUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("FragmentPath", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "FragmentPathUpdate");
    }
}

void UnitStub::onFragmentPathGet(const ::boost::shared_ptr< FragmentPathGet >& fragmentPath) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "FragmentPathGet", fragmentPath->getAct());
    sendFragmentPathGetUpdate(_FragmentPathProperty.getFragmentPath(), fragmentPath->getAct());
}

void UnitStub::sendFragmentPathGetUpdate(const ::std::string& fragmentPath, act_t act) {
    ::asf::dbus::DBusVariant variant;
    FragmentPathGet payload(fragmentPath);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "FragmentPathGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setFragmentPath(const ::std::string& fragmentPath) {
    if(fragmentPath!=_FragmentPathProperty.getFragmentPath()) {
        _FragmentPathProperty.setFragmentPath(fragmentPath);
        sendFragmentPathUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& UnitStub::getFragmentPath() const {
    return _FragmentPathProperty.getFragmentPath();
}

::std::string& UnitStub::getFragmentPathMutable() {
    return _FragmentPathProperty.getFragmentPathMutable();
}

void UnitStub::sendSourcePathUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SourcePathUpdate payload(_SourcePathProperty);

        LOG_INFO ("-> send%s", "SourcePathUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("SourcePath", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SourcePathUpdate");
    }
}

void UnitStub::onSourcePathGet(const ::boost::shared_ptr< SourcePathGet >& sourcePath) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SourcePathGet", sourcePath->getAct());
    sendSourcePathGetUpdate(_SourcePathProperty.getSourcePath(), sourcePath->getAct());
}

void UnitStub::sendSourcePathGetUpdate(const ::std::string& sourcePath, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SourcePathGet payload(sourcePath);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SourcePathGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setSourcePath(const ::std::string& sourcePath) {
    if(sourcePath!=_SourcePathProperty.getSourcePath()) {
        _SourcePathProperty.setSourcePath(sourcePath);
        sendSourcePathUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& UnitStub::getSourcePath() const {
    return _SourcePathProperty.getSourcePath();
}

::std::string& UnitStub::getSourcePathMutable() {
    return _SourcePathProperty.getSourcePathMutable();
}

void UnitStub::sendDropInPathsUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        DropInPathsUpdate payload(_DropInPathsProperty);

        LOG_INFO ("-> send%s", "DropInPathsUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("DropInPaths", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "DropInPathsUpdate");
    }
}

void UnitStub::onDropInPathsGet(const ::boost::shared_ptr< DropInPathsGet >& dropInPaths) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DropInPathsGet", dropInPaths->getAct());
    sendDropInPathsGetUpdate(_DropInPathsProperty.getDropInPaths(), dropInPaths->getAct());
}

void UnitStub::sendDropInPathsGetUpdate(const ::std::vector< ::std::string >& dropInPaths, act_t act) {
    ::asf::dbus::DBusVariant variant;
    DropInPathsGet payload(dropInPaths);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DropInPathsGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setDropInPaths(const ::std::vector< ::std::string >& dropInPaths) {
    if(dropInPaths!=_DropInPathsProperty.getDropInPaths()) {
        _DropInPathsProperty.setDropInPaths(dropInPaths);
        sendDropInPathsUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::string >& UnitStub::getDropInPaths() const {
    return _DropInPathsProperty.getDropInPaths();
}

::std::vector< ::std::string >& UnitStub::getDropInPathsMutable() {
    return _DropInPathsProperty.getDropInPathsMutable();
}

void UnitStub::sendUnitFileStateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        UnitFileStateUpdate payload(_UnitFileStateProperty);

        LOG_INFO ("-> send%s", "UnitFileStateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("UnitFileState", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "UnitFileStateUpdate");
    }
}

void UnitStub::onUnitFileStateGet(const ::boost::shared_ptr< UnitFileStateGet >& unitFileState) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "UnitFileStateGet", unitFileState->getAct());
    sendUnitFileStateGetUpdate(_UnitFileStateProperty.getUnitFileState(), unitFileState->getAct());
}

void UnitStub::sendUnitFileStateGetUpdate(const ::std::string& unitFileState, act_t act) {
    ::asf::dbus::DBusVariant variant;
    UnitFileStateGet payload(unitFileState);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "UnitFileStateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setUnitFileState(const ::std::string& unitFileState) {
    if(unitFileState!=_UnitFileStateProperty.getUnitFileState()) {
        _UnitFileStateProperty.setUnitFileState(unitFileState);
        sendUnitFileStateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& UnitStub::getUnitFileState() const {
    return _UnitFileStateProperty.getUnitFileState();
}

::std::string& UnitStub::getUnitFileStateMutable() {
    return _UnitFileStateProperty.getUnitFileStateMutable();
}

void UnitStub::sendUnitFilePresetUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        UnitFilePresetUpdate payload(_UnitFilePresetProperty);

        LOG_INFO ("-> send%s", "UnitFilePresetUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("UnitFilePreset", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "UnitFilePresetUpdate");
    }
}

void UnitStub::onUnitFilePresetGet(const ::boost::shared_ptr< UnitFilePresetGet >& unitFilePreset) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "UnitFilePresetGet", unitFilePreset->getAct());
    sendUnitFilePresetGetUpdate(_UnitFilePresetProperty.getUnitFilePreset(), unitFilePreset->getAct());
}

void UnitStub::sendUnitFilePresetGetUpdate(const ::std::string& unitFilePreset, act_t act) {
    ::asf::dbus::DBusVariant variant;
    UnitFilePresetGet payload(unitFilePreset);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "UnitFilePresetGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setUnitFilePreset(const ::std::string& unitFilePreset) {
    if(unitFilePreset!=_UnitFilePresetProperty.getUnitFilePreset()) {
        _UnitFilePresetProperty.setUnitFilePreset(unitFilePreset);
        sendUnitFilePresetUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& UnitStub::getUnitFilePreset() const {
    return _UnitFilePresetProperty.getUnitFilePreset();
}

::std::string& UnitStub::getUnitFilePresetMutable() {
    return _UnitFilePresetProperty.getUnitFilePresetMutable();
}

void UnitStub::sendInactiveExitTimestampUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        InactiveExitTimestampUpdate payload(_InactiveExitTimestampProperty);

        LOG_INFO ("-> send%s", "InactiveExitTimestampUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("InactiveExitTimestamp", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "InactiveExitTimestampUpdate");
    }
}

void UnitStub::onInactiveExitTimestampGet(const ::boost::shared_ptr< InactiveExitTimestampGet >& inactiveExitTimestamp) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "InactiveExitTimestampGet", inactiveExitTimestamp->getAct());
    sendInactiveExitTimestampGetUpdate(_InactiveExitTimestampProperty.getInactiveExitTimestamp(), inactiveExitTimestamp->getAct());
}

void UnitStub::sendInactiveExitTimestampGetUpdate(uint64 inactiveExitTimestamp, act_t act) {
    ::asf::dbus::DBusVariant variant;
    InactiveExitTimestampGet payload(inactiveExitTimestamp);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "InactiveExitTimestampGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setInactiveExitTimestamp(uint64 inactiveExitTimestamp) {
    if(inactiveExitTimestamp!=_InactiveExitTimestampProperty.getInactiveExitTimestamp()) {
        _InactiveExitTimestampProperty.setInactiveExitTimestamp(inactiveExitTimestamp);
        sendInactiveExitTimestampUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 UnitStub::getInactiveExitTimestamp() const {
    return _InactiveExitTimestampProperty.getInactiveExitTimestamp();
}

void UnitStub::sendInactiveExitTimestampMonotonicUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        InactiveExitTimestampMonotonicUpdate payload(_InactiveExitTimestampMonotonicProperty);

        LOG_INFO ("-> send%s", "InactiveExitTimestampMonotonicUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("InactiveExitTimestampMonotonic", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "InactiveExitTimestampMonotonicUpdate");
    }
}

void UnitStub::onInactiveExitTimestampMonotonicGet(const ::boost::shared_ptr< InactiveExitTimestampMonotonicGet >& inactiveExitTimestampMonotonic) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "InactiveExitTimestampMonotonicGet", inactiveExitTimestampMonotonic->getAct());
    sendInactiveExitTimestampMonotonicGetUpdate(_InactiveExitTimestampMonotonicProperty.getInactiveExitTimestampMonotonic(), inactiveExitTimestampMonotonic->getAct());
}

void UnitStub::sendInactiveExitTimestampMonotonicGetUpdate(uint64 inactiveExitTimestampMonotonic, act_t act) {
    ::asf::dbus::DBusVariant variant;
    InactiveExitTimestampMonotonicGet payload(inactiveExitTimestampMonotonic);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "InactiveExitTimestampMonotonicGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setInactiveExitTimestampMonotonic(uint64 inactiveExitTimestampMonotonic) {
    if(inactiveExitTimestampMonotonic!=_InactiveExitTimestampMonotonicProperty.getInactiveExitTimestampMonotonic()) {
        _InactiveExitTimestampMonotonicProperty.setInactiveExitTimestampMonotonic(inactiveExitTimestampMonotonic);
        sendInactiveExitTimestampMonotonicUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 UnitStub::getInactiveExitTimestampMonotonic() const {
    return _InactiveExitTimestampMonotonicProperty.getInactiveExitTimestampMonotonic();
}

void UnitStub::sendActiveEnterTimestampUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ActiveEnterTimestampUpdate payload(_ActiveEnterTimestampProperty);

        LOG_INFO ("-> send%s", "ActiveEnterTimestampUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ActiveEnterTimestamp", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ActiveEnterTimestampUpdate");
    }
}

void UnitStub::onActiveEnterTimestampGet(const ::boost::shared_ptr< ActiveEnterTimestampGet >& activeEnterTimestamp) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ActiveEnterTimestampGet", activeEnterTimestamp->getAct());
    sendActiveEnterTimestampGetUpdate(_ActiveEnterTimestampProperty.getActiveEnterTimestamp(), activeEnterTimestamp->getAct());
}

void UnitStub::sendActiveEnterTimestampGetUpdate(uint64 activeEnterTimestamp, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ActiveEnterTimestampGet payload(activeEnterTimestamp);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ActiveEnterTimestampGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setActiveEnterTimestamp(uint64 activeEnterTimestamp) {
    if(activeEnterTimestamp!=_ActiveEnterTimestampProperty.getActiveEnterTimestamp()) {
        _ActiveEnterTimestampProperty.setActiveEnterTimestamp(activeEnterTimestamp);
        sendActiveEnterTimestampUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 UnitStub::getActiveEnterTimestamp() const {
    return _ActiveEnterTimestampProperty.getActiveEnterTimestamp();
}

void UnitStub::sendActiveEnterTimestampMonotonicUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ActiveEnterTimestampMonotonicUpdate payload(_ActiveEnterTimestampMonotonicProperty);

        LOG_INFO ("-> send%s", "ActiveEnterTimestampMonotonicUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ActiveEnterTimestampMonotonic", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ActiveEnterTimestampMonotonicUpdate");
    }
}

void UnitStub::onActiveEnterTimestampMonotonicGet(const ::boost::shared_ptr< ActiveEnterTimestampMonotonicGet >& activeEnterTimestampMonotonic) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ActiveEnterTimestampMonotonicGet", activeEnterTimestampMonotonic->getAct());
    sendActiveEnterTimestampMonotonicGetUpdate(_ActiveEnterTimestampMonotonicProperty.getActiveEnterTimestampMonotonic(), activeEnterTimestampMonotonic->getAct());
}

void UnitStub::sendActiveEnterTimestampMonotonicGetUpdate(uint64 activeEnterTimestampMonotonic, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ActiveEnterTimestampMonotonicGet payload(activeEnterTimestampMonotonic);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ActiveEnterTimestampMonotonicGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setActiveEnterTimestampMonotonic(uint64 activeEnterTimestampMonotonic) {
    if(activeEnterTimestampMonotonic!=_ActiveEnterTimestampMonotonicProperty.getActiveEnterTimestampMonotonic()) {
        _ActiveEnterTimestampMonotonicProperty.setActiveEnterTimestampMonotonic(activeEnterTimestampMonotonic);
        sendActiveEnterTimestampMonotonicUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 UnitStub::getActiveEnterTimestampMonotonic() const {
    return _ActiveEnterTimestampMonotonicProperty.getActiveEnterTimestampMonotonic();
}

void UnitStub::sendActiveExitTimestampUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ActiveExitTimestampUpdate payload(_ActiveExitTimestampProperty);

        LOG_INFO ("-> send%s", "ActiveExitTimestampUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ActiveExitTimestamp", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ActiveExitTimestampUpdate");
    }
}

void UnitStub::onActiveExitTimestampGet(const ::boost::shared_ptr< ActiveExitTimestampGet >& activeExitTimestamp) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ActiveExitTimestampGet", activeExitTimestamp->getAct());
    sendActiveExitTimestampGetUpdate(_ActiveExitTimestampProperty.getActiveExitTimestamp(), activeExitTimestamp->getAct());
}

void UnitStub::sendActiveExitTimestampGetUpdate(uint64 activeExitTimestamp, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ActiveExitTimestampGet payload(activeExitTimestamp);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ActiveExitTimestampGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setActiveExitTimestamp(uint64 activeExitTimestamp) {
    if(activeExitTimestamp!=_ActiveExitTimestampProperty.getActiveExitTimestamp()) {
        _ActiveExitTimestampProperty.setActiveExitTimestamp(activeExitTimestamp);
        sendActiveExitTimestampUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 UnitStub::getActiveExitTimestamp() const {
    return _ActiveExitTimestampProperty.getActiveExitTimestamp();
}

void UnitStub::sendActiveExitTimestampMonotonicUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ActiveExitTimestampMonotonicUpdate payload(_ActiveExitTimestampMonotonicProperty);

        LOG_INFO ("-> send%s", "ActiveExitTimestampMonotonicUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ActiveExitTimestampMonotonic", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ActiveExitTimestampMonotonicUpdate");
    }
}

void UnitStub::onActiveExitTimestampMonotonicGet(const ::boost::shared_ptr< ActiveExitTimestampMonotonicGet >& activeExitTimestampMonotonic) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ActiveExitTimestampMonotonicGet", activeExitTimestampMonotonic->getAct());
    sendActiveExitTimestampMonotonicGetUpdate(_ActiveExitTimestampMonotonicProperty.getActiveExitTimestampMonotonic(), activeExitTimestampMonotonic->getAct());
}

void UnitStub::sendActiveExitTimestampMonotonicGetUpdate(uint64 activeExitTimestampMonotonic, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ActiveExitTimestampMonotonicGet payload(activeExitTimestampMonotonic);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ActiveExitTimestampMonotonicGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setActiveExitTimestampMonotonic(uint64 activeExitTimestampMonotonic) {
    if(activeExitTimestampMonotonic!=_ActiveExitTimestampMonotonicProperty.getActiveExitTimestampMonotonic()) {
        _ActiveExitTimestampMonotonicProperty.setActiveExitTimestampMonotonic(activeExitTimestampMonotonic);
        sendActiveExitTimestampMonotonicUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 UnitStub::getActiveExitTimestampMonotonic() const {
    return _ActiveExitTimestampMonotonicProperty.getActiveExitTimestampMonotonic();
}

void UnitStub::sendInactiveEnterTimestampUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        InactiveEnterTimestampUpdate payload(_InactiveEnterTimestampProperty);

        LOG_INFO ("-> send%s", "InactiveEnterTimestampUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("InactiveEnterTimestamp", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "InactiveEnterTimestampUpdate");
    }
}

void UnitStub::onInactiveEnterTimestampGet(const ::boost::shared_ptr< InactiveEnterTimestampGet >& inactiveEnterTimestamp) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "InactiveEnterTimestampGet", inactiveEnterTimestamp->getAct());
    sendInactiveEnterTimestampGetUpdate(_InactiveEnterTimestampProperty.getInactiveEnterTimestamp(), inactiveEnterTimestamp->getAct());
}

void UnitStub::sendInactiveEnterTimestampGetUpdate(uint64 inactiveEnterTimestamp, act_t act) {
    ::asf::dbus::DBusVariant variant;
    InactiveEnterTimestampGet payload(inactiveEnterTimestamp);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "InactiveEnterTimestampGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setInactiveEnterTimestamp(uint64 inactiveEnterTimestamp) {
    if(inactiveEnterTimestamp!=_InactiveEnterTimestampProperty.getInactiveEnterTimestamp()) {
        _InactiveEnterTimestampProperty.setInactiveEnterTimestamp(inactiveEnterTimestamp);
        sendInactiveEnterTimestampUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 UnitStub::getInactiveEnterTimestamp() const {
    return _InactiveEnterTimestampProperty.getInactiveEnterTimestamp();
}

void UnitStub::sendInactiveEnterTimestampMonotonicUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        InactiveEnterTimestampMonotonicUpdate payload(_InactiveEnterTimestampMonotonicProperty);

        LOG_INFO ("-> send%s", "InactiveEnterTimestampMonotonicUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("InactiveEnterTimestampMonotonic", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "InactiveEnterTimestampMonotonicUpdate");
    }
}

void UnitStub::onInactiveEnterTimestampMonotonicGet(const ::boost::shared_ptr< InactiveEnterTimestampMonotonicGet >& inactiveEnterTimestampMonotonic) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "InactiveEnterTimestampMonotonicGet", inactiveEnterTimestampMonotonic->getAct());
    sendInactiveEnterTimestampMonotonicGetUpdate(_InactiveEnterTimestampMonotonicProperty.getInactiveEnterTimestampMonotonic(), inactiveEnterTimestampMonotonic->getAct());
}

void UnitStub::sendInactiveEnterTimestampMonotonicGetUpdate(uint64 inactiveEnterTimestampMonotonic, act_t act) {
    ::asf::dbus::DBusVariant variant;
    InactiveEnterTimestampMonotonicGet payload(inactiveEnterTimestampMonotonic);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "InactiveEnterTimestampMonotonicGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setInactiveEnterTimestampMonotonic(uint64 inactiveEnterTimestampMonotonic) {
    if(inactiveEnterTimestampMonotonic!=_InactiveEnterTimestampMonotonicProperty.getInactiveEnterTimestampMonotonic()) {
        _InactiveEnterTimestampMonotonicProperty.setInactiveEnterTimestampMonotonic(inactiveEnterTimestampMonotonic);
        sendInactiveEnterTimestampMonotonicUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 UnitStub::getInactiveEnterTimestampMonotonic() const {
    return _InactiveEnterTimestampMonotonicProperty.getInactiveEnterTimestampMonotonic();
}

void UnitStub::sendCanStartUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        CanStartUpdate payload(_CanStartProperty);

        LOG_INFO ("-> send%s", "CanStartUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("CanStart", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "CanStartUpdate");
    }
}

void UnitStub::onCanStartGet(const ::boost::shared_ptr< CanStartGet >& canStart) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "CanStartGet", canStart->getAct());
    sendCanStartGetUpdate(_CanStartProperty.getCanStart(), canStart->getAct());
}

void UnitStub::sendCanStartGetUpdate(bool canStart, act_t act) {
    ::asf::dbus::DBusVariant variant;
    CanStartGet payload(canStart);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "CanStartGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setCanStart(bool canStart) {
    if(canStart!=_CanStartProperty.getCanStart()) {
        _CanStartProperty.setCanStart(canStart);
        sendCanStartUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool UnitStub::getCanStart() const {
    return _CanStartProperty.getCanStart();
}

void UnitStub::sendCanStopUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        CanStopUpdate payload(_CanStopProperty);

        LOG_INFO ("-> send%s", "CanStopUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("CanStop", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "CanStopUpdate");
    }
}

void UnitStub::onCanStopGet(const ::boost::shared_ptr< CanStopGet >& canStop) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "CanStopGet", canStop->getAct());
    sendCanStopGetUpdate(_CanStopProperty.getCanStop(), canStop->getAct());
}

void UnitStub::sendCanStopGetUpdate(bool canStop, act_t act) {
    ::asf::dbus::DBusVariant variant;
    CanStopGet payload(canStop);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "CanStopGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setCanStop(bool canStop) {
    if(canStop!=_CanStopProperty.getCanStop()) {
        _CanStopProperty.setCanStop(canStop);
        sendCanStopUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool UnitStub::getCanStop() const {
    return _CanStopProperty.getCanStop();
}

void UnitStub::sendCanReloadUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        CanReloadUpdate payload(_CanReloadProperty);

        LOG_INFO ("-> send%s", "CanReloadUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("CanReload", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "CanReloadUpdate");
    }
}

void UnitStub::onCanReloadGet(const ::boost::shared_ptr< CanReloadGet >& canReload) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "CanReloadGet", canReload->getAct());
    sendCanReloadGetUpdate(_CanReloadProperty.getCanReload(), canReload->getAct());
}

void UnitStub::sendCanReloadGetUpdate(bool canReload, act_t act) {
    ::asf::dbus::DBusVariant variant;
    CanReloadGet payload(canReload);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "CanReloadGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setCanReload(bool canReload) {
    if(canReload!=_CanReloadProperty.getCanReload()) {
        _CanReloadProperty.setCanReload(canReload);
        sendCanReloadUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool UnitStub::getCanReload() const {
    return _CanReloadProperty.getCanReload();
}

void UnitStub::sendCanIsolateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        CanIsolateUpdate payload(_CanIsolateProperty);

        LOG_INFO ("-> send%s", "CanIsolateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("CanIsolate", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "CanIsolateUpdate");
    }
}

void UnitStub::onCanIsolateGet(const ::boost::shared_ptr< CanIsolateGet >& canIsolate) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "CanIsolateGet", canIsolate->getAct());
    sendCanIsolateGetUpdate(_CanIsolateProperty.getCanIsolate(), canIsolate->getAct());
}

void UnitStub::sendCanIsolateGetUpdate(bool canIsolate, act_t act) {
    ::asf::dbus::DBusVariant variant;
    CanIsolateGet payload(canIsolate);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "CanIsolateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setCanIsolate(bool canIsolate) {
    if(canIsolate!=_CanIsolateProperty.getCanIsolate()) {
        _CanIsolateProperty.setCanIsolate(canIsolate);
        sendCanIsolateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool UnitStub::getCanIsolate() const {
    return _CanIsolateProperty.getCanIsolate();
}

void UnitStub::sendJobUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        JobUpdate payload(_JobProperty);

        LOG_INFO ("-> send%s", "JobUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Job", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "JobUpdate");
    }
}

void UnitStub::onJobGet(const ::boost::shared_ptr< JobGet >& job) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "JobGet", job->getAct());
    sendJobGetUpdate(_JobProperty.getJob(), job->getAct());
}

void UnitStub::sendJobGetUpdate(const job& job, act_t act) {
    ::asf::dbus::DBusVariant variant;
    JobGet payload(job);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "JobGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setJob(const job& job) {
    if(job!=_JobProperty.getJob()) {
        _JobProperty.setJob(job);
        sendJobUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const job& UnitStub::getJob() const {
    return _JobProperty.getJob();
}

job& UnitStub::getJobMutable() {
    return _JobProperty.getJobMutable();
}

void UnitStub::sendStopWhenUnneededUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        StopWhenUnneededUpdate payload(_StopWhenUnneededProperty);

        LOG_INFO ("-> send%s", "StopWhenUnneededUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("StopWhenUnneeded", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "StopWhenUnneededUpdate");
    }
}

void UnitStub::onStopWhenUnneededGet(const ::boost::shared_ptr< StopWhenUnneededGet >& stopWhenUnneeded) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "StopWhenUnneededGet", stopWhenUnneeded->getAct());
    sendStopWhenUnneededGetUpdate(_StopWhenUnneededProperty.getStopWhenUnneeded(), stopWhenUnneeded->getAct());
}

void UnitStub::sendStopWhenUnneededGetUpdate(bool stopWhenUnneeded, act_t act) {
    ::asf::dbus::DBusVariant variant;
    StopWhenUnneededGet payload(stopWhenUnneeded);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "StopWhenUnneededGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setStopWhenUnneeded(bool stopWhenUnneeded) {
    if(stopWhenUnneeded!=_StopWhenUnneededProperty.getStopWhenUnneeded()) {
        _StopWhenUnneededProperty.setStopWhenUnneeded(stopWhenUnneeded);
        sendStopWhenUnneededUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool UnitStub::getStopWhenUnneeded() const {
    return _StopWhenUnneededProperty.getStopWhenUnneeded();
}

void UnitStub::sendRefuseManualStartUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        RefuseManualStartUpdate payload(_RefuseManualStartProperty);

        LOG_INFO ("-> send%s", "RefuseManualStartUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("RefuseManualStart", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "RefuseManualStartUpdate");
    }
}

void UnitStub::onRefuseManualStartGet(const ::boost::shared_ptr< RefuseManualStartGet >& refuseManualStart) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "RefuseManualStartGet", refuseManualStart->getAct());
    sendRefuseManualStartGetUpdate(_RefuseManualStartProperty.getRefuseManualStart(), refuseManualStart->getAct());
}

void UnitStub::sendRefuseManualStartGetUpdate(bool refuseManualStart, act_t act) {
    ::asf::dbus::DBusVariant variant;
    RefuseManualStartGet payload(refuseManualStart);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "RefuseManualStartGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setRefuseManualStart(bool refuseManualStart) {
    if(refuseManualStart!=_RefuseManualStartProperty.getRefuseManualStart()) {
        _RefuseManualStartProperty.setRefuseManualStart(refuseManualStart);
        sendRefuseManualStartUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool UnitStub::getRefuseManualStart() const {
    return _RefuseManualStartProperty.getRefuseManualStart();
}

void UnitStub::sendRefuseManualStopUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        RefuseManualStopUpdate payload(_RefuseManualStopProperty);

        LOG_INFO ("-> send%s", "RefuseManualStopUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("RefuseManualStop", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "RefuseManualStopUpdate");
    }
}

void UnitStub::onRefuseManualStopGet(const ::boost::shared_ptr< RefuseManualStopGet >& refuseManualStop) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "RefuseManualStopGet", refuseManualStop->getAct());
    sendRefuseManualStopGetUpdate(_RefuseManualStopProperty.getRefuseManualStop(), refuseManualStop->getAct());
}

void UnitStub::sendRefuseManualStopGetUpdate(bool refuseManualStop, act_t act) {
    ::asf::dbus::DBusVariant variant;
    RefuseManualStopGet payload(refuseManualStop);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "RefuseManualStopGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setRefuseManualStop(bool refuseManualStop) {
    if(refuseManualStop!=_RefuseManualStopProperty.getRefuseManualStop()) {
        _RefuseManualStopProperty.setRefuseManualStop(refuseManualStop);
        sendRefuseManualStopUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool UnitStub::getRefuseManualStop() const {
    return _RefuseManualStopProperty.getRefuseManualStop();
}

void UnitStub::sendAllowIsolateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        AllowIsolateUpdate payload(_AllowIsolateProperty);

        LOG_INFO ("-> send%s", "AllowIsolateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("AllowIsolate", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "AllowIsolateUpdate");
    }
}

void UnitStub::onAllowIsolateGet(const ::boost::shared_ptr< AllowIsolateGet >& allowIsolate) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AllowIsolateGet", allowIsolate->getAct());
    sendAllowIsolateGetUpdate(_AllowIsolateProperty.getAllowIsolate(), allowIsolate->getAct());
}

void UnitStub::sendAllowIsolateGetUpdate(bool allowIsolate, act_t act) {
    ::asf::dbus::DBusVariant variant;
    AllowIsolateGet payload(allowIsolate);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AllowIsolateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setAllowIsolate(bool allowIsolate) {
    if(allowIsolate!=_AllowIsolateProperty.getAllowIsolate()) {
        _AllowIsolateProperty.setAllowIsolate(allowIsolate);
        sendAllowIsolateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool UnitStub::getAllowIsolate() const {
    return _AllowIsolateProperty.getAllowIsolate();
}

void UnitStub::sendDefaultDependenciesUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        DefaultDependenciesUpdate payload(_DefaultDependenciesProperty);

        LOG_INFO ("-> send%s", "DefaultDependenciesUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("DefaultDependencies", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "DefaultDependenciesUpdate");
    }
}

void UnitStub::onDefaultDependenciesGet(const ::boost::shared_ptr< DefaultDependenciesGet >& defaultDependencies) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DefaultDependenciesGet", defaultDependencies->getAct());
    sendDefaultDependenciesGetUpdate(_DefaultDependenciesProperty.getDefaultDependencies(), defaultDependencies->getAct());
}

void UnitStub::sendDefaultDependenciesGetUpdate(bool defaultDependencies, act_t act) {
    ::asf::dbus::DBusVariant variant;
    DefaultDependenciesGet payload(defaultDependencies);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DefaultDependenciesGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setDefaultDependencies(bool defaultDependencies) {
    if(defaultDependencies!=_DefaultDependenciesProperty.getDefaultDependencies()) {
        _DefaultDependenciesProperty.setDefaultDependencies(defaultDependencies);
        sendDefaultDependenciesUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool UnitStub::getDefaultDependencies() const {
    return _DefaultDependenciesProperty.getDefaultDependencies();
}

void UnitStub::sendOnFailureJobModeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        OnFailureJobModeUpdate payload(_OnFailureJobModeProperty);

        LOG_INFO ("-> send%s", "OnFailureJobModeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("OnFailureJobMode", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "OnFailureJobModeUpdate");
    }
}

void UnitStub::onOnFailureJobModeGet(const ::boost::shared_ptr< OnFailureJobModeGet >& onFailureJobMode) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "OnFailureJobModeGet", onFailureJobMode->getAct());
    sendOnFailureJobModeGetUpdate(_OnFailureJobModeProperty.getOnFailureJobMode(), onFailureJobMode->getAct());
}

void UnitStub::sendOnFailureJobModeGetUpdate(const ::std::string& onFailureJobMode, act_t act) {
    ::asf::dbus::DBusVariant variant;
    OnFailureJobModeGet payload(onFailureJobMode);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "OnFailureJobModeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setOnFailureJobMode(const ::std::string& onFailureJobMode) {
    if(onFailureJobMode!=_OnFailureJobModeProperty.getOnFailureJobMode()) {
        _OnFailureJobModeProperty.setOnFailureJobMode(onFailureJobMode);
        sendOnFailureJobModeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& UnitStub::getOnFailureJobMode() const {
    return _OnFailureJobModeProperty.getOnFailureJobMode();
}

::std::string& UnitStub::getOnFailureJobModeMutable() {
    return _OnFailureJobModeProperty.getOnFailureJobModeMutable();
}

void UnitStub::sendIgnoreOnIsolateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        IgnoreOnIsolateUpdate payload(_IgnoreOnIsolateProperty);

        LOG_INFO ("-> send%s", "IgnoreOnIsolateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("IgnoreOnIsolate", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "IgnoreOnIsolateUpdate");
    }
}

void UnitStub::onIgnoreOnIsolateGet(const ::boost::shared_ptr< IgnoreOnIsolateGet >& ignoreOnIsolate) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "IgnoreOnIsolateGet", ignoreOnIsolate->getAct());
    sendIgnoreOnIsolateGetUpdate(_IgnoreOnIsolateProperty.getIgnoreOnIsolate(), ignoreOnIsolate->getAct());
}

void UnitStub::sendIgnoreOnIsolateGetUpdate(bool ignoreOnIsolate, act_t act) {
    ::asf::dbus::DBusVariant variant;
    IgnoreOnIsolateGet payload(ignoreOnIsolate);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "IgnoreOnIsolateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setIgnoreOnIsolate(bool ignoreOnIsolate) {
    if(ignoreOnIsolate!=_IgnoreOnIsolateProperty.getIgnoreOnIsolate()) {
        _IgnoreOnIsolateProperty.setIgnoreOnIsolate(ignoreOnIsolate);
        sendIgnoreOnIsolateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool UnitStub::getIgnoreOnIsolate() const {
    return _IgnoreOnIsolateProperty.getIgnoreOnIsolate();
}

void UnitStub::sendIgnoreOnSnapshotUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        IgnoreOnSnapshotUpdate payload(_IgnoreOnSnapshotProperty);

        LOG_INFO ("-> send%s", "IgnoreOnSnapshotUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("IgnoreOnSnapshot", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "IgnoreOnSnapshotUpdate");
    }
}

void UnitStub::onIgnoreOnSnapshotGet(const ::boost::shared_ptr< IgnoreOnSnapshotGet >& ignoreOnSnapshot) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "IgnoreOnSnapshotGet", ignoreOnSnapshot->getAct());
    sendIgnoreOnSnapshotGetUpdate(_IgnoreOnSnapshotProperty.getIgnoreOnSnapshot(), ignoreOnSnapshot->getAct());
}

void UnitStub::sendIgnoreOnSnapshotGetUpdate(bool ignoreOnSnapshot, act_t act) {
    ::asf::dbus::DBusVariant variant;
    IgnoreOnSnapshotGet payload(ignoreOnSnapshot);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "IgnoreOnSnapshotGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setIgnoreOnSnapshot(bool ignoreOnSnapshot) {
    if(ignoreOnSnapshot!=_IgnoreOnSnapshotProperty.getIgnoreOnSnapshot()) {
        _IgnoreOnSnapshotProperty.setIgnoreOnSnapshot(ignoreOnSnapshot);
        sendIgnoreOnSnapshotUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool UnitStub::getIgnoreOnSnapshot() const {
    return _IgnoreOnSnapshotProperty.getIgnoreOnSnapshot();
}

void UnitStub::sendNeedDaemonReloadUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        NeedDaemonReloadUpdate payload(_NeedDaemonReloadProperty);

        LOG_INFO ("-> send%s", "NeedDaemonReloadUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("NeedDaemonReload", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "NeedDaemonReloadUpdate");
    }
}

void UnitStub::onNeedDaemonReloadGet(const ::boost::shared_ptr< NeedDaemonReloadGet >& needDaemonReload) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "NeedDaemonReloadGet", needDaemonReload->getAct());
    sendNeedDaemonReloadGetUpdate(_NeedDaemonReloadProperty.getNeedDaemonReload(), needDaemonReload->getAct());
}

void UnitStub::sendNeedDaemonReloadGetUpdate(bool needDaemonReload, act_t act) {
    ::asf::dbus::DBusVariant variant;
    NeedDaemonReloadGet payload(needDaemonReload);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "NeedDaemonReloadGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setNeedDaemonReload(bool needDaemonReload) {
    if(needDaemonReload!=_NeedDaemonReloadProperty.getNeedDaemonReload()) {
        _NeedDaemonReloadProperty.setNeedDaemonReload(needDaemonReload);
        sendNeedDaemonReloadUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool UnitStub::getNeedDaemonReload() const {
    return _NeedDaemonReloadProperty.getNeedDaemonReload();
}

void UnitStub::sendJobTimeoutUSecUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        JobTimeoutUSecUpdate payload(_JobTimeoutUSecProperty);

        LOG_INFO ("-> send%s", "JobTimeoutUSecUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("JobTimeoutUSec", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "JobTimeoutUSecUpdate");
    }
}

void UnitStub::onJobTimeoutUSecGet(const ::boost::shared_ptr< JobTimeoutUSecGet >& jobTimeoutUSec) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "JobTimeoutUSecGet", jobTimeoutUSec->getAct());
    sendJobTimeoutUSecGetUpdate(_JobTimeoutUSecProperty.getJobTimeoutUSec(), jobTimeoutUSec->getAct());
}

void UnitStub::sendJobTimeoutUSecGetUpdate(uint64 jobTimeoutUSec, act_t act) {
    ::asf::dbus::DBusVariant variant;
    JobTimeoutUSecGet payload(jobTimeoutUSec);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "JobTimeoutUSecGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setJobTimeoutUSec(uint64 jobTimeoutUSec) {
    if(jobTimeoutUSec!=_JobTimeoutUSecProperty.getJobTimeoutUSec()) {
        _JobTimeoutUSecProperty.setJobTimeoutUSec(jobTimeoutUSec);
        sendJobTimeoutUSecUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 UnitStub::getJobTimeoutUSec() const {
    return _JobTimeoutUSecProperty.getJobTimeoutUSec();
}

void UnitStub::sendJobTimeoutActionUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        JobTimeoutActionUpdate payload(_JobTimeoutActionProperty);

        LOG_INFO ("-> send%s", "JobTimeoutActionUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("JobTimeoutAction", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "JobTimeoutActionUpdate");
    }
}

void UnitStub::onJobTimeoutActionGet(const ::boost::shared_ptr< JobTimeoutActionGet >& jobTimeoutAction) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "JobTimeoutActionGet", jobTimeoutAction->getAct());
    sendJobTimeoutActionGetUpdate(_JobTimeoutActionProperty.getJobTimeoutAction(), jobTimeoutAction->getAct());
}

void UnitStub::sendJobTimeoutActionGetUpdate(const ::std::string& jobTimeoutAction, act_t act) {
    ::asf::dbus::DBusVariant variant;
    JobTimeoutActionGet payload(jobTimeoutAction);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "JobTimeoutActionGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setJobTimeoutAction(const ::std::string& jobTimeoutAction) {
    if(jobTimeoutAction!=_JobTimeoutActionProperty.getJobTimeoutAction()) {
        _JobTimeoutActionProperty.setJobTimeoutAction(jobTimeoutAction);
        sendJobTimeoutActionUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& UnitStub::getJobTimeoutAction() const {
    return _JobTimeoutActionProperty.getJobTimeoutAction();
}

::std::string& UnitStub::getJobTimeoutActionMutable() {
    return _JobTimeoutActionProperty.getJobTimeoutActionMutable();
}

void UnitStub::sendJobTimeoutRebootArgumentUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        JobTimeoutRebootArgumentUpdate payload(_JobTimeoutRebootArgumentProperty);

        LOG_INFO ("-> send%s", "JobTimeoutRebootArgumentUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("JobTimeoutRebootArgument", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "JobTimeoutRebootArgumentUpdate");
    }
}

void UnitStub::onJobTimeoutRebootArgumentGet(const ::boost::shared_ptr< JobTimeoutRebootArgumentGet >& jobTimeoutRebootArgument) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "JobTimeoutRebootArgumentGet", jobTimeoutRebootArgument->getAct());
    sendJobTimeoutRebootArgumentGetUpdate(_JobTimeoutRebootArgumentProperty.getJobTimeoutRebootArgument(), jobTimeoutRebootArgument->getAct());
}

void UnitStub::sendJobTimeoutRebootArgumentGetUpdate(const ::std::string& jobTimeoutRebootArgument, act_t act) {
    ::asf::dbus::DBusVariant variant;
    JobTimeoutRebootArgumentGet payload(jobTimeoutRebootArgument);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "JobTimeoutRebootArgumentGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setJobTimeoutRebootArgument(const ::std::string& jobTimeoutRebootArgument) {
    if(jobTimeoutRebootArgument!=_JobTimeoutRebootArgumentProperty.getJobTimeoutRebootArgument()) {
        _JobTimeoutRebootArgumentProperty.setJobTimeoutRebootArgument(jobTimeoutRebootArgument);
        sendJobTimeoutRebootArgumentUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& UnitStub::getJobTimeoutRebootArgument() const {
    return _JobTimeoutRebootArgumentProperty.getJobTimeoutRebootArgument();
}

::std::string& UnitStub::getJobTimeoutRebootArgumentMutable() {
    return _JobTimeoutRebootArgumentProperty.getJobTimeoutRebootArgumentMutable();
}

void UnitStub::sendConditionResultUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ConditionResultUpdate payload(_ConditionResultProperty);

        LOG_INFO ("-> send%s", "ConditionResultUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ConditionResult", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ConditionResultUpdate");
    }
}

void UnitStub::onConditionResultGet(const ::boost::shared_ptr< ConditionResultGet >& conditionResult) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ConditionResultGet", conditionResult->getAct());
    sendConditionResultGetUpdate(_ConditionResultProperty.getConditionResult(), conditionResult->getAct());
}

void UnitStub::sendConditionResultGetUpdate(bool conditionResult, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ConditionResultGet payload(conditionResult);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ConditionResultGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setConditionResult(bool conditionResult) {
    if(conditionResult!=_ConditionResultProperty.getConditionResult()) {
        _ConditionResultProperty.setConditionResult(conditionResult);
        sendConditionResultUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool UnitStub::getConditionResult() const {
    return _ConditionResultProperty.getConditionResult();
}

void UnitStub::sendAssertResultUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        AssertResultUpdate payload(_AssertResultProperty);

        LOG_INFO ("-> send%s", "AssertResultUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("AssertResult", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "AssertResultUpdate");
    }
}

void UnitStub::onAssertResultGet(const ::boost::shared_ptr< AssertResultGet >& assertResult) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AssertResultGet", assertResult->getAct());
    sendAssertResultGetUpdate(_AssertResultProperty.getAssertResult(), assertResult->getAct());
}

void UnitStub::sendAssertResultGetUpdate(bool assertResult, act_t act) {
    ::asf::dbus::DBusVariant variant;
    AssertResultGet payload(assertResult);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AssertResultGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setAssertResult(bool assertResult) {
    if(assertResult!=_AssertResultProperty.getAssertResult()) {
        _AssertResultProperty.setAssertResult(assertResult);
        sendAssertResultUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool UnitStub::getAssertResult() const {
    return _AssertResultProperty.getAssertResult();
}

void UnitStub::sendConditionTimestampUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ConditionTimestampUpdate payload(_ConditionTimestampProperty);

        LOG_INFO ("-> send%s", "ConditionTimestampUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ConditionTimestamp", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ConditionTimestampUpdate");
    }
}

void UnitStub::onConditionTimestampGet(const ::boost::shared_ptr< ConditionTimestampGet >& conditionTimestamp) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ConditionTimestampGet", conditionTimestamp->getAct());
    sendConditionTimestampGetUpdate(_ConditionTimestampProperty.getConditionTimestamp(), conditionTimestamp->getAct());
}

void UnitStub::sendConditionTimestampGetUpdate(uint64 conditionTimestamp, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ConditionTimestampGet payload(conditionTimestamp);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ConditionTimestampGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setConditionTimestamp(uint64 conditionTimestamp) {
    if(conditionTimestamp!=_ConditionTimestampProperty.getConditionTimestamp()) {
        _ConditionTimestampProperty.setConditionTimestamp(conditionTimestamp);
        sendConditionTimestampUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 UnitStub::getConditionTimestamp() const {
    return _ConditionTimestampProperty.getConditionTimestamp();
}

void UnitStub::sendConditionTimestampMonotonicUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ConditionTimestampMonotonicUpdate payload(_ConditionTimestampMonotonicProperty);

        LOG_INFO ("-> send%s", "ConditionTimestampMonotonicUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ConditionTimestampMonotonic", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ConditionTimestampMonotonicUpdate");
    }
}

void UnitStub::onConditionTimestampMonotonicGet(const ::boost::shared_ptr< ConditionTimestampMonotonicGet >& conditionTimestampMonotonic) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ConditionTimestampMonotonicGet", conditionTimestampMonotonic->getAct());
    sendConditionTimestampMonotonicGetUpdate(_ConditionTimestampMonotonicProperty.getConditionTimestampMonotonic(), conditionTimestampMonotonic->getAct());
}

void UnitStub::sendConditionTimestampMonotonicGetUpdate(uint64 conditionTimestampMonotonic, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ConditionTimestampMonotonicGet payload(conditionTimestampMonotonic);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ConditionTimestampMonotonicGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setConditionTimestampMonotonic(uint64 conditionTimestampMonotonic) {
    if(conditionTimestampMonotonic!=_ConditionTimestampMonotonicProperty.getConditionTimestampMonotonic()) {
        _ConditionTimestampMonotonicProperty.setConditionTimestampMonotonic(conditionTimestampMonotonic);
        sendConditionTimestampMonotonicUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 UnitStub::getConditionTimestampMonotonic() const {
    return _ConditionTimestampMonotonicProperty.getConditionTimestampMonotonic();
}

void UnitStub::sendAssertTimestampUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        AssertTimestampUpdate payload(_AssertTimestampProperty);

        LOG_INFO ("-> send%s", "AssertTimestampUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("AssertTimestamp", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "AssertTimestampUpdate");
    }
}

void UnitStub::onAssertTimestampGet(const ::boost::shared_ptr< AssertTimestampGet >& assertTimestamp) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AssertTimestampGet", assertTimestamp->getAct());
    sendAssertTimestampGetUpdate(_AssertTimestampProperty.getAssertTimestamp(), assertTimestamp->getAct());
}

void UnitStub::sendAssertTimestampGetUpdate(uint64 assertTimestamp, act_t act) {
    ::asf::dbus::DBusVariant variant;
    AssertTimestampGet payload(assertTimestamp);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AssertTimestampGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setAssertTimestamp(uint64 assertTimestamp) {
    if(assertTimestamp!=_AssertTimestampProperty.getAssertTimestamp()) {
        _AssertTimestampProperty.setAssertTimestamp(assertTimestamp);
        sendAssertTimestampUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 UnitStub::getAssertTimestamp() const {
    return _AssertTimestampProperty.getAssertTimestamp();
}

void UnitStub::sendAssertTimestampMonotonicUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        AssertTimestampMonotonicUpdate payload(_AssertTimestampMonotonicProperty);

        LOG_INFO ("-> send%s", "AssertTimestampMonotonicUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("AssertTimestampMonotonic", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "AssertTimestampMonotonicUpdate");
    }
}

void UnitStub::onAssertTimestampMonotonicGet(const ::boost::shared_ptr< AssertTimestampMonotonicGet >& assertTimestampMonotonic) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AssertTimestampMonotonicGet", assertTimestampMonotonic->getAct());
    sendAssertTimestampMonotonicGetUpdate(_AssertTimestampMonotonicProperty.getAssertTimestampMonotonic(), assertTimestampMonotonic->getAct());
}

void UnitStub::sendAssertTimestampMonotonicGetUpdate(uint64 assertTimestampMonotonic, act_t act) {
    ::asf::dbus::DBusVariant variant;
    AssertTimestampMonotonicGet payload(assertTimestampMonotonic);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AssertTimestampMonotonicGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setAssertTimestampMonotonic(uint64 assertTimestampMonotonic) {
    if(assertTimestampMonotonic!=_AssertTimestampMonotonicProperty.getAssertTimestampMonotonic()) {
        _AssertTimestampMonotonicProperty.setAssertTimestampMonotonic(assertTimestampMonotonic);
        sendAssertTimestampMonotonicUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 UnitStub::getAssertTimestampMonotonic() const {
    return _AssertTimestampMonotonicProperty.getAssertTimestampMonotonic();
}

void UnitStub::sendConditionsUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ConditionsUpdate payload(_ConditionsProperty);

        LOG_INFO ("-> send%s", "ConditionsUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Conditions", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ConditionsUpdate");
    }
}

void UnitStub::onConditionsGet(const ::boost::shared_ptr< ConditionsGet >& conditions) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ConditionsGet", conditions->getAct());
    sendConditionsGetUpdate(_ConditionsProperty.getConditions(), conditions->getAct());
}

void UnitStub::sendConditionsGetUpdate(const ::std::vector< condition >& conditions, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ConditionsGet payload(conditions);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ConditionsGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setConditions(const ::std::vector< condition >& conditions) {
    if(conditions!=_ConditionsProperty.getConditions()) {
        _ConditionsProperty.setConditions(conditions);
        sendConditionsUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< condition >& UnitStub::getConditions() const {
    return _ConditionsProperty.getConditions();
}

::std::vector< condition >& UnitStub::getConditionsMutable() {
    return _ConditionsProperty.getConditionsMutable();
}

void UnitStub::sendAssertsUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        AssertsUpdate payload(_AssertsProperty);

        LOG_INFO ("-> send%s", "AssertsUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Asserts", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "AssertsUpdate");
    }
}

void UnitStub::onAssertsGet(const ::boost::shared_ptr< AssertsGet >& asserts) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AssertsGet", asserts->getAct());
    sendAssertsGetUpdate(_AssertsProperty.getAsserts(), asserts->getAct());
}

void UnitStub::sendAssertsGetUpdate(const ::std::vector< condition >& asserts, act_t act) {
    ::asf::dbus::DBusVariant variant;
    AssertsGet payload(asserts);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AssertsGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setAsserts(const ::std::vector< condition >& asserts) {
    if(asserts!=_AssertsProperty.getAsserts()) {
        _AssertsProperty.setAsserts(asserts);
        sendAssertsUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< condition >& UnitStub::getAsserts() const {
    return _AssertsProperty.getAsserts();
}

::std::vector< condition >& UnitStub::getAssertsMutable() {
    return _AssertsProperty.getAssertsMutable();
}

void UnitStub::sendLoadErrorUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        LoadErrorUpdate payload(_LoadErrorProperty);

        LOG_INFO ("-> send%s", "LoadErrorUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("LoadError", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "LoadErrorUpdate");
    }
}

void UnitStub::onLoadErrorGet(const ::boost::shared_ptr< LoadErrorGet >& loadError) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "LoadErrorGet", loadError->getAct());
    sendLoadErrorGetUpdate(_LoadErrorProperty.getLoadError(), loadError->getAct());
}

void UnitStub::sendLoadErrorGetUpdate(const loadError& loadError, act_t act) {
    ::asf::dbus::DBusVariant variant;
    LoadErrorGet payload(loadError);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "LoadErrorGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setLoadError(const loadError& loadError) {
    if(loadError!=_LoadErrorProperty.getLoadError()) {
        _LoadErrorProperty.setLoadError(loadError);
        sendLoadErrorUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const loadError& UnitStub::getLoadError() const {
    return _LoadErrorProperty.getLoadError();
}

loadError& UnitStub::getLoadErrorMutable() {
    return _LoadErrorProperty.getLoadErrorMutable();
}

void UnitStub::sendTransientUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        TransientUpdate payload(_TransientProperty);

        LOG_INFO ("-> send%s", "TransientUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Transient", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Unit", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "TransientUpdate");
    }
}

void UnitStub::onTransientGet(const ::boost::shared_ptr< TransientGet >& transient) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "TransientGet", transient->getAct());
    sendTransientGetUpdate(_TransientProperty.getTransient(), transient->getAct());
}

void UnitStub::sendTransientGetUpdate(bool transient, act_t act) {
    ::asf::dbus::DBusVariant variant;
    TransientGet payload(transient);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "TransientGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void UnitStub::setTransient(bool transient) {
    if(transient!=_TransientProperty.getTransient()) {
        _TransientProperty.setTransient(transient);
        sendTransientUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool UnitStub::getTransient() const {
    return _TransientProperty.getTransient();
}

void  UnitStub::sendStartResponse (const ::std::string& job, act_t act) {
    StartResponse* payload = new StartResponse(job);
    DBUS_MESSAGE_REPLY(dbusMessage, "Start", StartResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Start", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  UnitStub::sendStartError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    StartError* payload = new StartError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Start", StartError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Start", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  UnitStub::sendStopResponse (const ::std::string& job, act_t act) {
    StopResponse* payload = new StopResponse(job);
    DBUS_MESSAGE_REPLY(dbusMessage, "Stop", StopResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Stop", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  UnitStub::sendStopError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    StopError* payload = new StopError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Stop", StopError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Stop", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  UnitStub::sendReloadResponse (const ::std::string& job, act_t act) {
    ReloadResponse* payload = new ReloadResponse(job);
    DBUS_MESSAGE_REPLY(dbusMessage, "Reload", ReloadResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Reload", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  UnitStub::sendReloadError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ReloadError* payload = new ReloadError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Reload", ReloadError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Reload", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  UnitStub::sendRestartResponse (const ::std::string& job, act_t act) {
    RestartResponse* payload = new RestartResponse(job);
    DBUS_MESSAGE_REPLY(dbusMessage, "Restart", RestartResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Restart", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  UnitStub::sendRestartError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RestartError* payload = new RestartError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Restart", RestartError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Restart", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  UnitStub::sendTryRestartResponse (const ::std::string& job, act_t act) {
    TryRestartResponse* payload = new TryRestartResponse(job);
    DBUS_MESSAGE_REPLY(dbusMessage, "TryRestart", TryRestartResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "TryRestart", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  UnitStub::sendTryRestartError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    TryRestartError* payload = new TryRestartError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "TryRestart", TryRestartError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "TryRestart", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  UnitStub::sendReloadOrRestartResponse (const ::std::string& job, act_t act) {
    ReloadOrRestartResponse* payload = new ReloadOrRestartResponse(job);
    DBUS_MESSAGE_REPLY(dbusMessage, "ReloadOrRestart", ReloadOrRestartResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ReloadOrRestart", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  UnitStub::sendReloadOrRestartError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ReloadOrRestartError* payload = new ReloadOrRestartError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ReloadOrRestart", ReloadOrRestartError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ReloadOrRestart", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  UnitStub::sendReloadOrTryRestartResponse (const ::std::string& job, act_t act) {
    ReloadOrTryRestartResponse* payload = new ReloadOrTryRestartResponse(job);
    DBUS_MESSAGE_REPLY(dbusMessage, "ReloadOrTryRestart", ReloadOrTryRestartResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ReloadOrTryRestart", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  UnitStub::sendReloadOrTryRestartError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ReloadOrTryRestartError* payload = new ReloadOrTryRestartError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ReloadOrTryRestart", ReloadOrTryRestartError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ReloadOrTryRestart", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  UnitStub::sendKillResponse (const ::std::string& job, act_t act) {
    KillResponse* payload = new KillResponse(job);
    DBUS_MESSAGE_REPLY(dbusMessage, "Kill", KillResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Kill", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  UnitStub::sendKillError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    KillError* payload = new KillError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Kill", KillError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Kill", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  UnitStub::sendResetFailedResponse (act_t act) {
    ResetFailedResponse* payload = new ResetFailedResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "ResetFailed", ResetFailedResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ResetFailed", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  UnitStub::sendResetFailedError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ResetFailedError* payload = new ResetFailedError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ResetFailed", ResetFailedError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ResetFailed", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  UnitStub::sendSetPropertiesResponse (act_t act) {
    SetPropertiesResponse* payload = new SetPropertiesResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "SetProperties", SetPropertiesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetProperties", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  UnitStub::sendSetPropertiesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetPropertiesError* payload = new SetPropertiesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SetProperties", SetPropertiesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetProperties", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void UnitStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'Id'
    {
        ::asf::dbus::DBusVariant variant;
        IdGet payload(_IdProperty.getId());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Id", variant));
    }

    //property 'Names'
    {
        ::asf::dbus::DBusVariant variant;
        NamesGet payload(_NamesProperty.getNames());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Names", variant));
    }

    //property 'Following'
    {
        ::asf::dbus::DBusVariant variant;
        FollowingGet payload(_FollowingProperty.getFollowing());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Following", variant));
    }

    //property 'Requires'
    {
        ::asf::dbus::DBusVariant variant;
        RequiresGet payload(_RequiresProperty.getRequires());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Requires", variant));
    }

    //property 'RequiresOverridable'
    {
        ::asf::dbus::DBusVariant variant;
        RequiresOverridableGet payload(_RequiresOverridableProperty.getRequiresOverridable());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("RequiresOverridable", variant));
    }

    //property 'Requisite'
    {
        ::asf::dbus::DBusVariant variant;
        RequisiteGet payload(_RequisiteProperty.getRequisite());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Requisite", variant));
    }

    //property 'RequisiteOverridable'
    {
        ::asf::dbus::DBusVariant variant;
        RequisiteOverridableGet payload(_RequisiteOverridableProperty.getRequisiteOverridable());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("RequisiteOverridable", variant));
    }

    //property 'Wants'
    {
        ::asf::dbus::DBusVariant variant;
        WantsGet payload(_WantsProperty.getWants());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Wants", variant));
    }

    //property 'BindsTo'
    {
        ::asf::dbus::DBusVariant variant;
        BindsToGet payload(_BindsToProperty.getBindsTo());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("BindsTo", variant));
    }

    //property 'PartOf'
    {
        ::asf::dbus::DBusVariant variant;
        PartOfGet payload(_PartOfProperty.getPartOf());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("PartOf", variant));
    }

    //property 'RequiredBy'
    {
        ::asf::dbus::DBusVariant variant;
        RequiredByGet payload(_RequiredByProperty.getRequiredBy());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("RequiredBy", variant));
    }

    //property 'RequiredByOverridable'
    {
        ::asf::dbus::DBusVariant variant;
        RequiredByOverridableGet payload(_RequiredByOverridableProperty.getRequiredByOverridable());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("RequiredByOverridable", variant));
    }

    //property 'RequisiteOf'
    {
        ::asf::dbus::DBusVariant variant;
        RequisiteOfGet payload(_RequisiteOfProperty.getRequisiteOf());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("RequisiteOf", variant));
    }

    //property 'RequisiteOfOverridable'
    {
        ::asf::dbus::DBusVariant variant;
        RequisiteOfOverridableGet payload(_RequisiteOfOverridableProperty.getRequisiteOfOverridable());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("RequisiteOfOverridable", variant));
    }

    //property 'WantedBy'
    {
        ::asf::dbus::DBusVariant variant;
        WantedByGet payload(_WantedByProperty.getWantedBy());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("WantedBy", variant));
    }

    //property 'BoundBy'
    {
        ::asf::dbus::DBusVariant variant;
        BoundByGet payload(_BoundByProperty.getBoundBy());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("BoundBy", variant));
    }

    //property 'ConsistsOf'
    {
        ::asf::dbus::DBusVariant variant;
        ConsistsOfGet payload(_ConsistsOfProperty.getConsistsOf());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ConsistsOf", variant));
    }

    //property 'Conflicts'
    {
        ::asf::dbus::DBusVariant variant;
        ConflictsGet payload(_ConflictsProperty.getConflicts());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Conflicts", variant));
    }

    //property 'ConflictedBy'
    {
        ::asf::dbus::DBusVariant variant;
        ConflictedByGet payload(_ConflictedByProperty.getConflictedBy());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ConflictedBy", variant));
    }

    //property 'Before'
    {
        ::asf::dbus::DBusVariant variant;
        BeforeGet payload(_BeforeProperty.getBefore());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Before", variant));
    }

    //property 'After'
    {
        ::asf::dbus::DBusVariant variant;
        AfterGet payload(_AfterProperty.getAfter());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("After", variant));
    }

    //property 'OnFailure'
    {
        ::asf::dbus::DBusVariant variant;
        OnFailureGet payload(_OnFailureProperty.getOnFailure());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("OnFailure", variant));
    }

    //property 'Triggers'
    {
        ::asf::dbus::DBusVariant variant;
        TriggersGet payload(_TriggersProperty.getTriggers());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Triggers", variant));
    }

    //property 'TriggeredBy'
    {
        ::asf::dbus::DBusVariant variant;
        TriggeredByGet payload(_TriggeredByProperty.getTriggeredBy());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("TriggeredBy", variant));
    }

    //property 'PropagatesReloadTo'
    {
        ::asf::dbus::DBusVariant variant;
        PropagatesReloadToGet payload(_PropagatesReloadToProperty.getPropagatesReloadTo());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("PropagatesReloadTo", variant));
    }

    //property 'ReloadPropagatedFrom'
    {
        ::asf::dbus::DBusVariant variant;
        ReloadPropagatedFromGet payload(_ReloadPropagatedFromProperty.getReloadPropagatedFrom());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ReloadPropagatedFrom", variant));
    }

    //property 'JoinsNamespaceOf'
    {
        ::asf::dbus::DBusVariant variant;
        JoinsNamespaceOfGet payload(_JoinsNamespaceOfProperty.getJoinsNamespaceOf());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("JoinsNamespaceOf", variant));
    }

    //property 'RequiresMountsFor'
    {
        ::asf::dbus::DBusVariant variant;
        RequiresMountsForGet payload(_RequiresMountsForProperty.getRequiresMountsFor());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("RequiresMountsFor", variant));
    }

    //property 'Documentation'
    {
        ::asf::dbus::DBusVariant variant;
        DocumentationGet payload(_DocumentationProperty.getDocumentation());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Documentation", variant));
    }

    //property 'Description'
    {
        ::asf::dbus::DBusVariant variant;
        DescriptionGet payload(_DescriptionProperty.getDescription());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Description", variant));
    }

    //property 'LoadState'
    {
        ::asf::dbus::DBusVariant variant;
        LoadStateGet payload(_LoadStateProperty.getLoadState());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("LoadState", variant));
    }

    //property 'ActiveState'
    {
        ::asf::dbus::DBusVariant variant;
        ActiveStateGet payload(_ActiveStateProperty.getActiveState());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ActiveState", variant));
    }

    //property 'SubState'
    {
        ::asf::dbus::DBusVariant variant;
        SubStateGet payload(_SubStateProperty.getSubState());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("SubState", variant));
    }

    //property 'FragmentPath'
    {
        ::asf::dbus::DBusVariant variant;
        FragmentPathGet payload(_FragmentPathProperty.getFragmentPath());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("FragmentPath", variant));
    }

    //property 'SourcePath'
    {
        ::asf::dbus::DBusVariant variant;
        SourcePathGet payload(_SourcePathProperty.getSourcePath());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("SourcePath", variant));
    }

    //property 'DropInPaths'
    {
        ::asf::dbus::DBusVariant variant;
        DropInPathsGet payload(_DropInPathsProperty.getDropInPaths());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("DropInPaths", variant));
    }

    //property 'UnitFileState'
    {
        ::asf::dbus::DBusVariant variant;
        UnitFileStateGet payload(_UnitFileStateProperty.getUnitFileState());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("UnitFileState", variant));
    }

    //property 'UnitFilePreset'
    {
        ::asf::dbus::DBusVariant variant;
        UnitFilePresetGet payload(_UnitFilePresetProperty.getUnitFilePreset());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("UnitFilePreset", variant));
    }

    //property 'InactiveExitTimestamp'
    {
        ::asf::dbus::DBusVariant variant;
        InactiveExitTimestampGet payload(_InactiveExitTimestampProperty.getInactiveExitTimestamp());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("InactiveExitTimestamp", variant));
    }

    //property 'InactiveExitTimestampMonotonic'
    {
        ::asf::dbus::DBusVariant variant;
        InactiveExitTimestampMonotonicGet payload(_InactiveExitTimestampMonotonicProperty.getInactiveExitTimestampMonotonic());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("InactiveExitTimestampMonotonic", variant));
    }

    //property 'ActiveEnterTimestamp'
    {
        ::asf::dbus::DBusVariant variant;
        ActiveEnterTimestampGet payload(_ActiveEnterTimestampProperty.getActiveEnterTimestamp());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ActiveEnterTimestamp", variant));
    }

    //property 'ActiveEnterTimestampMonotonic'
    {
        ::asf::dbus::DBusVariant variant;
        ActiveEnterTimestampMonotonicGet payload(_ActiveEnterTimestampMonotonicProperty.getActiveEnterTimestampMonotonic());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ActiveEnterTimestampMonotonic", variant));
    }

    //property 'ActiveExitTimestamp'
    {
        ::asf::dbus::DBusVariant variant;
        ActiveExitTimestampGet payload(_ActiveExitTimestampProperty.getActiveExitTimestamp());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ActiveExitTimestamp", variant));
    }

    //property 'ActiveExitTimestampMonotonic'
    {
        ::asf::dbus::DBusVariant variant;
        ActiveExitTimestampMonotonicGet payload(_ActiveExitTimestampMonotonicProperty.getActiveExitTimestampMonotonic());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ActiveExitTimestampMonotonic", variant));
    }

    //property 'InactiveEnterTimestamp'
    {
        ::asf::dbus::DBusVariant variant;
        InactiveEnterTimestampGet payload(_InactiveEnterTimestampProperty.getInactiveEnterTimestamp());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("InactiveEnterTimestamp", variant));
    }

    //property 'InactiveEnterTimestampMonotonic'
    {
        ::asf::dbus::DBusVariant variant;
        InactiveEnterTimestampMonotonicGet payload(_InactiveEnterTimestampMonotonicProperty.getInactiveEnterTimestampMonotonic());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("InactiveEnterTimestampMonotonic", variant));
    }

    //property 'CanStart'
    {
        ::asf::dbus::DBusVariant variant;
        CanStartGet payload(_CanStartProperty.getCanStart());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("CanStart", variant));
    }

    //property 'CanStop'
    {
        ::asf::dbus::DBusVariant variant;
        CanStopGet payload(_CanStopProperty.getCanStop());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("CanStop", variant));
    }

    //property 'CanReload'
    {
        ::asf::dbus::DBusVariant variant;
        CanReloadGet payload(_CanReloadProperty.getCanReload());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("CanReload", variant));
    }

    //property 'CanIsolate'
    {
        ::asf::dbus::DBusVariant variant;
        CanIsolateGet payload(_CanIsolateProperty.getCanIsolate());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("CanIsolate", variant));
    }

    //property 'Job'
    {
        ::asf::dbus::DBusVariant variant;
        JobGet payload(_JobProperty.getJob());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Job", variant));
    }

    //property 'StopWhenUnneeded'
    {
        ::asf::dbus::DBusVariant variant;
        StopWhenUnneededGet payload(_StopWhenUnneededProperty.getStopWhenUnneeded());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("StopWhenUnneeded", variant));
    }

    //property 'RefuseManualStart'
    {
        ::asf::dbus::DBusVariant variant;
        RefuseManualStartGet payload(_RefuseManualStartProperty.getRefuseManualStart());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("RefuseManualStart", variant));
    }

    //property 'RefuseManualStop'
    {
        ::asf::dbus::DBusVariant variant;
        RefuseManualStopGet payload(_RefuseManualStopProperty.getRefuseManualStop());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("RefuseManualStop", variant));
    }

    //property 'AllowIsolate'
    {
        ::asf::dbus::DBusVariant variant;
        AllowIsolateGet payload(_AllowIsolateProperty.getAllowIsolate());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("AllowIsolate", variant));
    }

    //property 'DefaultDependencies'
    {
        ::asf::dbus::DBusVariant variant;
        DefaultDependenciesGet payload(_DefaultDependenciesProperty.getDefaultDependencies());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("DefaultDependencies", variant));
    }

    //property 'OnFailureJobMode'
    {
        ::asf::dbus::DBusVariant variant;
        OnFailureJobModeGet payload(_OnFailureJobModeProperty.getOnFailureJobMode());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("OnFailureJobMode", variant));
    }

    //property 'IgnoreOnIsolate'
    {
        ::asf::dbus::DBusVariant variant;
        IgnoreOnIsolateGet payload(_IgnoreOnIsolateProperty.getIgnoreOnIsolate());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("IgnoreOnIsolate", variant));
    }

    //property 'IgnoreOnSnapshot'
    {
        ::asf::dbus::DBusVariant variant;
        IgnoreOnSnapshotGet payload(_IgnoreOnSnapshotProperty.getIgnoreOnSnapshot());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("IgnoreOnSnapshot", variant));
    }

    //property 'NeedDaemonReload'
    {
        ::asf::dbus::DBusVariant variant;
        NeedDaemonReloadGet payload(_NeedDaemonReloadProperty.getNeedDaemonReload());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("NeedDaemonReload", variant));
    }

    //property 'JobTimeoutUSec'
    {
        ::asf::dbus::DBusVariant variant;
        JobTimeoutUSecGet payload(_JobTimeoutUSecProperty.getJobTimeoutUSec());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("JobTimeoutUSec", variant));
    }

    //property 'JobTimeoutAction'
    {
        ::asf::dbus::DBusVariant variant;
        JobTimeoutActionGet payload(_JobTimeoutActionProperty.getJobTimeoutAction());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("JobTimeoutAction", variant));
    }

    //property 'JobTimeoutRebootArgument'
    {
        ::asf::dbus::DBusVariant variant;
        JobTimeoutRebootArgumentGet payload(_JobTimeoutRebootArgumentProperty.getJobTimeoutRebootArgument());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("JobTimeoutRebootArgument", variant));
    }

    //property 'ConditionResult'
    {
        ::asf::dbus::DBusVariant variant;
        ConditionResultGet payload(_ConditionResultProperty.getConditionResult());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ConditionResult", variant));
    }

    //property 'AssertResult'
    {
        ::asf::dbus::DBusVariant variant;
        AssertResultGet payload(_AssertResultProperty.getAssertResult());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("AssertResult", variant));
    }

    //property 'ConditionTimestamp'
    {
        ::asf::dbus::DBusVariant variant;
        ConditionTimestampGet payload(_ConditionTimestampProperty.getConditionTimestamp());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ConditionTimestamp", variant));
    }

    //property 'ConditionTimestampMonotonic'
    {
        ::asf::dbus::DBusVariant variant;
        ConditionTimestampMonotonicGet payload(_ConditionTimestampMonotonicProperty.getConditionTimestampMonotonic());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ConditionTimestampMonotonic", variant));
    }

    //property 'AssertTimestamp'
    {
        ::asf::dbus::DBusVariant variant;
        AssertTimestampGet payload(_AssertTimestampProperty.getAssertTimestamp());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("AssertTimestamp", variant));
    }

    //property 'AssertTimestampMonotonic'
    {
        ::asf::dbus::DBusVariant variant;
        AssertTimestampMonotonicGet payload(_AssertTimestampMonotonicProperty.getAssertTimestampMonotonic());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("AssertTimestampMonotonic", variant));
    }

    //property 'Conditions'
    {
        ::asf::dbus::DBusVariant variant;
        ConditionsGet payload(_ConditionsProperty.getConditions());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Conditions", variant));
    }

    //property 'Asserts'
    {
        ::asf::dbus::DBusVariant variant;
        AssertsGet payload(_AssertsProperty.getAsserts());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Asserts", variant));
    }

    //property 'LoadError'
    {
        ::asf::dbus::DBusVariant variant;
        LoadErrorGet payload(_LoadErrorProperty.getLoadError());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("LoadError", variant));
    }

    //property 'Transient'
    {
        ::asf::dbus::DBusVariant variant;
        TransientGet payload(_TransientProperty.getTransient());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Transient", variant));
    }
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
