/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/freedesktop/systemd1/Unit.h"
#include "org/freedesktop/systemd1/UnitDBus.h"
#include "org/freedesktop/systemd1/UnitJson.h"
#include "org/freedesktop/systemd1/UnitProxy.h"
#include <string>
#include <vector>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Unit {

DEFINE_CLASS_LOGGER("/org/freedesktop/systemd1/org/freedesktop/systemd1/Unit", UnitProxy);

class UnitProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    UnitProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< UnitProxy >& proxyShared = ::boost::static_pointer_cast< UnitProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_Id:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), IdError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Id", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<IdError> payload = ::boost::static_pointer_cast<IdError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((IdCallbackIF*) _callback)->onIdError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), IdUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Id", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<IdUpdate> payload = ::boost::static_pointer_cast<IdUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((IdCallbackIF*) _callback)->onIdUpdate(proxyShared, payload);
                        proxyShared->_id = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Names:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NamesError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Names", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NamesError> payload = ::boost::static_pointer_cast<NamesError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((NamesCallbackIF*) _callback)->onNamesError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NamesUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Names", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NamesUpdate> payload = ::boost::static_pointer_cast<NamesUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((NamesCallbackIF*) _callback)->onNamesUpdate(proxyShared, payload);
                        proxyShared->_names = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Following:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FollowingError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Following", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FollowingError> payload = ::boost::static_pointer_cast<FollowingError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((FollowingCallbackIF*) _callback)->onFollowingError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FollowingUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Following", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FollowingUpdate> payload = ::boost::static_pointer_cast<FollowingUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((FollowingCallbackIF*) _callback)->onFollowingUpdate(proxyShared, payload);
                        proxyShared->_following = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Requires:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequiresError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Requires", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequiresError> payload = ::boost::static_pointer_cast<RequiresError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((RequiresCallbackIF*) _callback)->onRequiresError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequiresUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Requires", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequiresUpdate> payload = ::boost::static_pointer_cast<RequiresUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((RequiresCallbackIF*) _callback)->onRequiresUpdate(proxyShared, payload);
                        proxyShared->_requires = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_RequiresOverridable:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequiresOverridableError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RequiresOverridable", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequiresOverridableError> payload = ::boost::static_pointer_cast<RequiresOverridableError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((RequiresOverridableCallbackIF*) _callback)->onRequiresOverridableError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequiresOverridableUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RequiresOverridable", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequiresOverridableUpdate> payload = ::boost::static_pointer_cast<RequiresOverridableUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((RequiresOverridableCallbackIF*) _callback)->onRequiresOverridableUpdate(proxyShared, payload);
                        proxyShared->_requiresOverridable = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Requisite:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequisiteError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Requisite", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequisiteError> payload = ::boost::static_pointer_cast<RequisiteError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((RequisiteCallbackIF*) _callback)->onRequisiteError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequisiteUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Requisite", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequisiteUpdate> payload = ::boost::static_pointer_cast<RequisiteUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((RequisiteCallbackIF*) _callback)->onRequisiteUpdate(proxyShared, payload);
                        proxyShared->_requisite = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_RequisiteOverridable:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequisiteOverridableError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RequisiteOverridable", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequisiteOverridableError> payload = ::boost::static_pointer_cast<RequisiteOverridableError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((RequisiteOverridableCallbackIF*) _callback)->onRequisiteOverridableError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequisiteOverridableUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RequisiteOverridable", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequisiteOverridableUpdate> payload = ::boost::static_pointer_cast<RequisiteOverridableUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((RequisiteOverridableCallbackIF*) _callback)->onRequisiteOverridableUpdate(proxyShared, payload);
                        proxyShared->_requisiteOverridable = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Wants:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), WantsError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Wants", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<WantsError> payload = ::boost::static_pointer_cast<WantsError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((WantsCallbackIF*) _callback)->onWantsError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), WantsUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Wants", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<WantsUpdate> payload = ::boost::static_pointer_cast<WantsUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((WantsCallbackIF*) _callback)->onWantsUpdate(proxyShared, payload);
                        proxyShared->_wants = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_BindsTo:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BindsToError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BindsTo", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BindsToError> payload = ::boost::static_pointer_cast<BindsToError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((BindsToCallbackIF*) _callback)->onBindsToError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BindsToUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BindsTo", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BindsToUpdate> payload = ::boost::static_pointer_cast<BindsToUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((BindsToCallbackIF*) _callback)->onBindsToUpdate(proxyShared, payload);
                        proxyShared->_bindsTo = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_PartOf:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PartOfError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PartOf", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PartOfError> payload = ::boost::static_pointer_cast<PartOfError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((PartOfCallbackIF*) _callback)->onPartOfError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PartOfUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PartOf", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PartOfUpdate> payload = ::boost::static_pointer_cast<PartOfUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((PartOfCallbackIF*) _callback)->onPartOfUpdate(proxyShared, payload);
                        proxyShared->_partOf = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_RequiredBy:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequiredByError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RequiredBy", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequiredByError> payload = ::boost::static_pointer_cast<RequiredByError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((RequiredByCallbackIF*) _callback)->onRequiredByError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequiredByUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RequiredBy", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequiredByUpdate> payload = ::boost::static_pointer_cast<RequiredByUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((RequiredByCallbackIF*) _callback)->onRequiredByUpdate(proxyShared, payload);
                        proxyShared->_requiredBy = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_RequiredByOverridable:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequiredByOverridableError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RequiredByOverridable", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequiredByOverridableError> payload = ::boost::static_pointer_cast<RequiredByOverridableError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((RequiredByOverridableCallbackIF*) _callback)->onRequiredByOverridableError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequiredByOverridableUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RequiredByOverridable", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequiredByOverridableUpdate> payload = ::boost::static_pointer_cast<RequiredByOverridableUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((RequiredByOverridableCallbackIF*) _callback)->onRequiredByOverridableUpdate(proxyShared, payload);
                        proxyShared->_requiredByOverridable = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_RequisiteOf:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequisiteOfError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RequisiteOf", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequisiteOfError> payload = ::boost::static_pointer_cast<RequisiteOfError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((RequisiteOfCallbackIF*) _callback)->onRequisiteOfError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequisiteOfUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RequisiteOf", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequisiteOfUpdate> payload = ::boost::static_pointer_cast<RequisiteOfUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((RequisiteOfCallbackIF*) _callback)->onRequisiteOfUpdate(proxyShared, payload);
                        proxyShared->_requisiteOf = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_RequisiteOfOverridable:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequisiteOfOverridableError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RequisiteOfOverridable", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequisiteOfOverridableError> payload = ::boost::static_pointer_cast<RequisiteOfOverridableError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((RequisiteOfOverridableCallbackIF*) _callback)->onRequisiteOfOverridableError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequisiteOfOverridableUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RequisiteOfOverridable", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequisiteOfOverridableUpdate> payload = ::boost::static_pointer_cast<RequisiteOfOverridableUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((RequisiteOfOverridableCallbackIF*) _callback)->onRequisiteOfOverridableUpdate(proxyShared, payload);
                        proxyShared->_requisiteOfOverridable = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_WantedBy:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), WantedByError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "WantedBy", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<WantedByError> payload = ::boost::static_pointer_cast<WantedByError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((WantedByCallbackIF*) _callback)->onWantedByError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), WantedByUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "WantedBy", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<WantedByUpdate> payload = ::boost::static_pointer_cast<WantedByUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((WantedByCallbackIF*) _callback)->onWantedByUpdate(proxyShared, payload);
                        proxyShared->_wantedBy = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_BoundBy:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BoundByError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BoundBy", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BoundByError> payload = ::boost::static_pointer_cast<BoundByError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((BoundByCallbackIF*) _callback)->onBoundByError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BoundByUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BoundBy", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BoundByUpdate> payload = ::boost::static_pointer_cast<BoundByUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((BoundByCallbackIF*) _callback)->onBoundByUpdate(proxyShared, payload);
                        proxyShared->_boundBy = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ConsistsOf:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ConsistsOfError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ConsistsOf", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ConsistsOfError> payload = ::boost::static_pointer_cast<ConsistsOfError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ConsistsOfCallbackIF*) _callback)->onConsistsOfError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ConsistsOfUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ConsistsOf", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ConsistsOfUpdate> payload = ::boost::static_pointer_cast<ConsistsOfUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ConsistsOfCallbackIF*) _callback)->onConsistsOfUpdate(proxyShared, payload);
                        proxyShared->_consistsOf = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Conflicts:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ConflictsError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Conflicts", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ConflictsError> payload = ::boost::static_pointer_cast<ConflictsError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ConflictsCallbackIF*) _callback)->onConflictsError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ConflictsUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Conflicts", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ConflictsUpdate> payload = ::boost::static_pointer_cast<ConflictsUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ConflictsCallbackIF*) _callback)->onConflictsUpdate(proxyShared, payload);
                        proxyShared->_conflicts = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ConflictedBy:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ConflictedByError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ConflictedBy", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ConflictedByError> payload = ::boost::static_pointer_cast<ConflictedByError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ConflictedByCallbackIF*) _callback)->onConflictedByError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ConflictedByUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ConflictedBy", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ConflictedByUpdate> payload = ::boost::static_pointer_cast<ConflictedByUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ConflictedByCallbackIF*) _callback)->onConflictedByUpdate(proxyShared, payload);
                        proxyShared->_conflictedBy = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Before:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BeforeError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Before", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BeforeError> payload = ::boost::static_pointer_cast<BeforeError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((BeforeCallbackIF*) _callback)->onBeforeError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BeforeUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Before", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BeforeUpdate> payload = ::boost::static_pointer_cast<BeforeUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((BeforeCallbackIF*) _callback)->onBeforeUpdate(proxyShared, payload);
                        proxyShared->_before = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_After:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AfterError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "After", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AfterError> payload = ::boost::static_pointer_cast<AfterError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((AfterCallbackIF*) _callback)->onAfterError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AfterUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "After", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AfterUpdate> payload = ::boost::static_pointer_cast<AfterUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((AfterCallbackIF*) _callback)->onAfterUpdate(proxyShared, payload);
                        proxyShared->_after = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_OnFailure:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), OnFailureError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "OnFailure", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<OnFailureError> payload = ::boost::static_pointer_cast<OnFailureError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((OnFailureCallbackIF*) _callback)->onOnFailureError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), OnFailureUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "OnFailure", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<OnFailureUpdate> payload = ::boost::static_pointer_cast<OnFailureUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((OnFailureCallbackIF*) _callback)->onOnFailureUpdate(proxyShared, payload);
                        proxyShared->_onFailure = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Triggers:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TriggersError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Triggers", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TriggersError> payload = ::boost::static_pointer_cast<TriggersError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((TriggersCallbackIF*) _callback)->onTriggersError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TriggersUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Triggers", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TriggersUpdate> payload = ::boost::static_pointer_cast<TriggersUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((TriggersCallbackIF*) _callback)->onTriggersUpdate(proxyShared, payload);
                        proxyShared->_triggers = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_TriggeredBy:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TriggeredByError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "TriggeredBy", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TriggeredByError> payload = ::boost::static_pointer_cast<TriggeredByError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((TriggeredByCallbackIF*) _callback)->onTriggeredByError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TriggeredByUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "TriggeredBy", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TriggeredByUpdate> payload = ::boost::static_pointer_cast<TriggeredByUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((TriggeredByCallbackIF*) _callback)->onTriggeredByUpdate(proxyShared, payload);
                        proxyShared->_triggeredBy = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_PropagatesReloadTo:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PropagatesReloadToError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PropagatesReloadTo", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PropagatesReloadToError> payload = ::boost::static_pointer_cast<PropagatesReloadToError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((PropagatesReloadToCallbackIF*) _callback)->onPropagatesReloadToError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PropagatesReloadToUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PropagatesReloadTo", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PropagatesReloadToUpdate> payload = ::boost::static_pointer_cast<PropagatesReloadToUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((PropagatesReloadToCallbackIF*) _callback)->onPropagatesReloadToUpdate(proxyShared, payload);
                        proxyShared->_propagatesReloadTo = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ReloadPropagatedFrom:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReloadPropagatedFromError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ReloadPropagatedFrom", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReloadPropagatedFromError> payload = ::boost::static_pointer_cast<ReloadPropagatedFromError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ReloadPropagatedFromCallbackIF*) _callback)->onReloadPropagatedFromError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReloadPropagatedFromUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ReloadPropagatedFrom", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReloadPropagatedFromUpdate> payload = ::boost::static_pointer_cast<ReloadPropagatedFromUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ReloadPropagatedFromCallbackIF*) _callback)->onReloadPropagatedFromUpdate(proxyShared, payload);
                        proxyShared->_reloadPropagatedFrom = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_JoinsNamespaceOf:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), JoinsNamespaceOfError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "JoinsNamespaceOf", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<JoinsNamespaceOfError> payload = ::boost::static_pointer_cast<JoinsNamespaceOfError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((JoinsNamespaceOfCallbackIF*) _callback)->onJoinsNamespaceOfError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), JoinsNamespaceOfUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "JoinsNamespaceOf", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<JoinsNamespaceOfUpdate> payload = ::boost::static_pointer_cast<JoinsNamespaceOfUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((JoinsNamespaceOfCallbackIF*) _callback)->onJoinsNamespaceOfUpdate(proxyShared, payload);
                        proxyShared->_joinsNamespaceOf = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_RequiresMountsFor:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequiresMountsForError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RequiresMountsFor", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequiresMountsForError> payload = ::boost::static_pointer_cast<RequiresMountsForError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((RequiresMountsForCallbackIF*) _callback)->onRequiresMountsForError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequiresMountsForUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RequiresMountsFor", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequiresMountsForUpdate> payload = ::boost::static_pointer_cast<RequiresMountsForUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((RequiresMountsForCallbackIF*) _callback)->onRequiresMountsForUpdate(proxyShared, payload);
                        proxyShared->_requiresMountsFor = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Documentation:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DocumentationError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Documentation", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DocumentationError> payload = ::boost::static_pointer_cast<DocumentationError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((DocumentationCallbackIF*) _callback)->onDocumentationError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DocumentationUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Documentation", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DocumentationUpdate> payload = ::boost::static_pointer_cast<DocumentationUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((DocumentationCallbackIF*) _callback)->onDocumentationUpdate(proxyShared, payload);
                        proxyShared->_documentation = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Description:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DescriptionError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Description", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DescriptionError> payload = ::boost::static_pointer_cast<DescriptionError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((DescriptionCallbackIF*) _callback)->onDescriptionError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DescriptionUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Description", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DescriptionUpdate> payload = ::boost::static_pointer_cast<DescriptionUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((DescriptionCallbackIF*) _callback)->onDescriptionUpdate(proxyShared, payload);
                        proxyShared->_description = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_LoadState:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LoadStateError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LoadState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LoadStateError> payload = ::boost::static_pointer_cast<LoadStateError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((LoadStateCallbackIF*) _callback)->onLoadStateError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LoadStateUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LoadState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LoadStateUpdate> payload = ::boost::static_pointer_cast<LoadStateUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((LoadStateCallbackIF*) _callback)->onLoadStateUpdate(proxyShared, payload);
                        proxyShared->_loadState = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ActiveState:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ActiveStateError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ActiveState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ActiveStateError> payload = ::boost::static_pointer_cast<ActiveStateError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ActiveStateCallbackIF*) _callback)->onActiveStateError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ActiveStateUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ActiveState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ActiveStateUpdate> payload = ::boost::static_pointer_cast<ActiveStateUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ActiveStateCallbackIF*) _callback)->onActiveStateUpdate(proxyShared, payload);
                        proxyShared->_activeState = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_SubState:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SubStateError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SubState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SubStateError> payload = ::boost::static_pointer_cast<SubStateError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SubStateCallbackIF*) _callback)->onSubStateError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SubStateUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SubState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SubStateUpdate> payload = ::boost::static_pointer_cast<SubStateUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SubStateCallbackIF*) _callback)->onSubStateUpdate(proxyShared, payload);
                        proxyShared->_subState = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_FragmentPath:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FragmentPathError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "FragmentPath", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FragmentPathError> payload = ::boost::static_pointer_cast<FragmentPathError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((FragmentPathCallbackIF*) _callback)->onFragmentPathError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FragmentPathUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "FragmentPath", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FragmentPathUpdate> payload = ::boost::static_pointer_cast<FragmentPathUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((FragmentPathCallbackIF*) _callback)->onFragmentPathUpdate(proxyShared, payload);
                        proxyShared->_fragmentPath = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_SourcePath:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SourcePathError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SourcePath", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SourcePathError> payload = ::boost::static_pointer_cast<SourcePathError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SourcePathCallbackIF*) _callback)->onSourcePathError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SourcePathUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SourcePath", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SourcePathUpdate> payload = ::boost::static_pointer_cast<SourcePathUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SourcePathCallbackIF*) _callback)->onSourcePathUpdate(proxyShared, payload);
                        proxyShared->_sourcePath = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_DropInPaths:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DropInPathsError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DropInPaths", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DropInPathsError> payload = ::boost::static_pointer_cast<DropInPathsError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((DropInPathsCallbackIF*) _callback)->onDropInPathsError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DropInPathsUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DropInPaths", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DropInPathsUpdate> payload = ::boost::static_pointer_cast<DropInPathsUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((DropInPathsCallbackIF*) _callback)->onDropInPathsUpdate(proxyShared, payload);
                        proxyShared->_dropInPaths = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_UnitFileState:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UnitFileStateError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "UnitFileState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UnitFileStateError> payload = ::boost::static_pointer_cast<UnitFileStateError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((UnitFileStateCallbackIF*) _callback)->onUnitFileStateError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UnitFileStateUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "UnitFileState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UnitFileStateUpdate> payload = ::boost::static_pointer_cast<UnitFileStateUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((UnitFileStateCallbackIF*) _callback)->onUnitFileStateUpdate(proxyShared, payload);
                        proxyShared->_unitFileState = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_UnitFilePreset:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UnitFilePresetError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "UnitFilePreset", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UnitFilePresetError> payload = ::boost::static_pointer_cast<UnitFilePresetError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((UnitFilePresetCallbackIF*) _callback)->onUnitFilePresetError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UnitFilePresetUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "UnitFilePreset", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UnitFilePresetUpdate> payload = ::boost::static_pointer_cast<UnitFilePresetUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((UnitFilePresetCallbackIF*) _callback)->onUnitFilePresetUpdate(proxyShared, payload);
                        proxyShared->_unitFilePreset = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_InactiveExitTimestamp:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), InactiveExitTimestampError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "InactiveExitTimestamp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<InactiveExitTimestampError> payload = ::boost::static_pointer_cast<InactiveExitTimestampError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((InactiveExitTimestampCallbackIF*) _callback)->onInactiveExitTimestampError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), InactiveExitTimestampUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "InactiveExitTimestamp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<InactiveExitTimestampUpdate> payload = ::boost::static_pointer_cast<InactiveExitTimestampUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((InactiveExitTimestampCallbackIF*) _callback)->onInactiveExitTimestampUpdate(proxyShared, payload);
                        proxyShared->_inactiveExitTimestamp = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_InactiveExitTimestampMonotonic:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), InactiveExitTimestampMonotonicError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "InactiveExitTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<InactiveExitTimestampMonotonicError> payload = ::boost::static_pointer_cast<InactiveExitTimestampMonotonicError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((InactiveExitTimestampMonotonicCallbackIF*) _callback)->onInactiveExitTimestampMonotonicError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), InactiveExitTimestampMonotonicUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "InactiveExitTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<InactiveExitTimestampMonotonicUpdate> payload = ::boost::static_pointer_cast<InactiveExitTimestampMonotonicUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((InactiveExitTimestampMonotonicCallbackIF*) _callback)->onInactiveExitTimestampMonotonicUpdate(proxyShared, payload);
                        proxyShared->_inactiveExitTimestampMonotonic = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ActiveEnterTimestamp:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ActiveEnterTimestampError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ActiveEnterTimestamp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ActiveEnterTimestampError> payload = ::boost::static_pointer_cast<ActiveEnterTimestampError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ActiveEnterTimestampCallbackIF*) _callback)->onActiveEnterTimestampError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ActiveEnterTimestampUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ActiveEnterTimestamp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ActiveEnterTimestampUpdate> payload = ::boost::static_pointer_cast<ActiveEnterTimestampUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ActiveEnterTimestampCallbackIF*) _callback)->onActiveEnterTimestampUpdate(proxyShared, payload);
                        proxyShared->_activeEnterTimestamp = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ActiveEnterTimestampMonotonic:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ActiveEnterTimestampMonotonicError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ActiveEnterTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ActiveEnterTimestampMonotonicError> payload = ::boost::static_pointer_cast<ActiveEnterTimestampMonotonicError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ActiveEnterTimestampMonotonicCallbackIF*) _callback)->onActiveEnterTimestampMonotonicError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ActiveEnterTimestampMonotonicUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ActiveEnterTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ActiveEnterTimestampMonotonicUpdate> payload = ::boost::static_pointer_cast<ActiveEnterTimestampMonotonicUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ActiveEnterTimestampMonotonicCallbackIF*) _callback)->onActiveEnterTimestampMonotonicUpdate(proxyShared, payload);
                        proxyShared->_activeEnterTimestampMonotonic = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ActiveExitTimestamp:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ActiveExitTimestampError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ActiveExitTimestamp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ActiveExitTimestampError> payload = ::boost::static_pointer_cast<ActiveExitTimestampError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ActiveExitTimestampCallbackIF*) _callback)->onActiveExitTimestampError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ActiveExitTimestampUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ActiveExitTimestamp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ActiveExitTimestampUpdate> payload = ::boost::static_pointer_cast<ActiveExitTimestampUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ActiveExitTimestampCallbackIF*) _callback)->onActiveExitTimestampUpdate(proxyShared, payload);
                        proxyShared->_activeExitTimestamp = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ActiveExitTimestampMonotonic:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ActiveExitTimestampMonotonicError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ActiveExitTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ActiveExitTimestampMonotonicError> payload = ::boost::static_pointer_cast<ActiveExitTimestampMonotonicError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ActiveExitTimestampMonotonicCallbackIF*) _callback)->onActiveExitTimestampMonotonicError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ActiveExitTimestampMonotonicUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ActiveExitTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ActiveExitTimestampMonotonicUpdate> payload = ::boost::static_pointer_cast<ActiveExitTimestampMonotonicUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ActiveExitTimestampMonotonicCallbackIF*) _callback)->onActiveExitTimestampMonotonicUpdate(proxyShared, payload);
                        proxyShared->_activeExitTimestampMonotonic = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_InactiveEnterTimestamp:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), InactiveEnterTimestampError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "InactiveEnterTimestamp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<InactiveEnterTimestampError> payload = ::boost::static_pointer_cast<InactiveEnterTimestampError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((InactiveEnterTimestampCallbackIF*) _callback)->onInactiveEnterTimestampError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), InactiveEnterTimestampUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "InactiveEnterTimestamp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<InactiveEnterTimestampUpdate> payload = ::boost::static_pointer_cast<InactiveEnterTimestampUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((InactiveEnterTimestampCallbackIF*) _callback)->onInactiveEnterTimestampUpdate(proxyShared, payload);
                        proxyShared->_inactiveEnterTimestamp = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_InactiveEnterTimestampMonotonic:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), InactiveEnterTimestampMonotonicError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "InactiveEnterTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<InactiveEnterTimestampMonotonicError> payload = ::boost::static_pointer_cast<InactiveEnterTimestampMonotonicError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((InactiveEnterTimestampMonotonicCallbackIF*) _callback)->onInactiveEnterTimestampMonotonicError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), InactiveEnterTimestampMonotonicUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "InactiveEnterTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<InactiveEnterTimestampMonotonicUpdate> payload = ::boost::static_pointer_cast<InactiveEnterTimestampMonotonicUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((InactiveEnterTimestampMonotonicCallbackIF*) _callback)->onInactiveEnterTimestampMonotonicUpdate(proxyShared, payload);
                        proxyShared->_inactiveEnterTimestampMonotonic = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_CanStart:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CanStartError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CanStart", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CanStartError> payload = ::boost::static_pointer_cast<CanStartError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((CanStartCallbackIF*) _callback)->onCanStartError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CanStartUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CanStart", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CanStartUpdate> payload = ::boost::static_pointer_cast<CanStartUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((CanStartCallbackIF*) _callback)->onCanStartUpdate(proxyShared, payload);
                        proxyShared->_canStart = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_CanStop:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CanStopError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CanStop", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CanStopError> payload = ::boost::static_pointer_cast<CanStopError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((CanStopCallbackIF*) _callback)->onCanStopError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CanStopUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CanStop", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CanStopUpdate> payload = ::boost::static_pointer_cast<CanStopUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((CanStopCallbackIF*) _callback)->onCanStopUpdate(proxyShared, payload);
                        proxyShared->_canStop = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_CanReload:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CanReloadError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CanReload", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CanReloadError> payload = ::boost::static_pointer_cast<CanReloadError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((CanReloadCallbackIF*) _callback)->onCanReloadError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CanReloadUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CanReload", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CanReloadUpdate> payload = ::boost::static_pointer_cast<CanReloadUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((CanReloadCallbackIF*) _callback)->onCanReloadUpdate(proxyShared, payload);
                        proxyShared->_canReload = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_CanIsolate:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CanIsolateError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CanIsolate", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CanIsolateError> payload = ::boost::static_pointer_cast<CanIsolateError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((CanIsolateCallbackIF*) _callback)->onCanIsolateError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CanIsolateUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CanIsolate", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CanIsolateUpdate> payload = ::boost::static_pointer_cast<CanIsolateUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((CanIsolateCallbackIF*) _callback)->onCanIsolateUpdate(proxyShared, payload);
                        proxyShared->_canIsolate = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Job:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), JobError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Job", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<JobError> payload = ::boost::static_pointer_cast<JobError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((JobCallbackIF*) _callback)->onJobError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), JobUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Job", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<JobUpdate> payload = ::boost::static_pointer_cast<JobUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((JobCallbackIF*) _callback)->onJobUpdate(proxyShared, payload);
                        proxyShared->_job = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_StopWhenUnneeded:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StopWhenUnneededError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "StopWhenUnneeded", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StopWhenUnneededError> payload = ::boost::static_pointer_cast<StopWhenUnneededError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((StopWhenUnneededCallbackIF*) _callback)->onStopWhenUnneededError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StopWhenUnneededUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "StopWhenUnneeded", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StopWhenUnneededUpdate> payload = ::boost::static_pointer_cast<StopWhenUnneededUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((StopWhenUnneededCallbackIF*) _callback)->onStopWhenUnneededUpdate(proxyShared, payload);
                        proxyShared->_stopWhenUnneeded = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_RefuseManualStart:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RefuseManualStartError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RefuseManualStart", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RefuseManualStartError> payload = ::boost::static_pointer_cast<RefuseManualStartError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((RefuseManualStartCallbackIF*) _callback)->onRefuseManualStartError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RefuseManualStartUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RefuseManualStart", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RefuseManualStartUpdate> payload = ::boost::static_pointer_cast<RefuseManualStartUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((RefuseManualStartCallbackIF*) _callback)->onRefuseManualStartUpdate(proxyShared, payload);
                        proxyShared->_refuseManualStart = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_RefuseManualStop:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RefuseManualStopError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RefuseManualStop", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RefuseManualStopError> payload = ::boost::static_pointer_cast<RefuseManualStopError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((RefuseManualStopCallbackIF*) _callback)->onRefuseManualStopError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RefuseManualStopUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RefuseManualStop", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RefuseManualStopUpdate> payload = ::boost::static_pointer_cast<RefuseManualStopUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((RefuseManualStopCallbackIF*) _callback)->onRefuseManualStopUpdate(proxyShared, payload);
                        proxyShared->_refuseManualStop = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_AllowIsolate:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AllowIsolateError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AllowIsolate", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AllowIsolateError> payload = ::boost::static_pointer_cast<AllowIsolateError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((AllowIsolateCallbackIF*) _callback)->onAllowIsolateError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AllowIsolateUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AllowIsolate", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AllowIsolateUpdate> payload = ::boost::static_pointer_cast<AllowIsolateUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((AllowIsolateCallbackIF*) _callback)->onAllowIsolateUpdate(proxyShared, payload);
                        proxyShared->_allowIsolate = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_DefaultDependencies:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DefaultDependenciesError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DefaultDependencies", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DefaultDependenciesError> payload = ::boost::static_pointer_cast<DefaultDependenciesError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((DefaultDependenciesCallbackIF*) _callback)->onDefaultDependenciesError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DefaultDependenciesUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DefaultDependencies", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DefaultDependenciesUpdate> payload = ::boost::static_pointer_cast<DefaultDependenciesUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((DefaultDependenciesCallbackIF*) _callback)->onDefaultDependenciesUpdate(proxyShared, payload);
                        proxyShared->_defaultDependencies = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_OnFailureJobMode:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), OnFailureJobModeError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "OnFailureJobMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<OnFailureJobModeError> payload = ::boost::static_pointer_cast<OnFailureJobModeError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((OnFailureJobModeCallbackIF*) _callback)->onOnFailureJobModeError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), OnFailureJobModeUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "OnFailureJobMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<OnFailureJobModeUpdate> payload = ::boost::static_pointer_cast<OnFailureJobModeUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((OnFailureJobModeCallbackIF*) _callback)->onOnFailureJobModeUpdate(proxyShared, payload);
                        proxyShared->_onFailureJobMode = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_IgnoreOnIsolate:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), IgnoreOnIsolateError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "IgnoreOnIsolate", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<IgnoreOnIsolateError> payload = ::boost::static_pointer_cast<IgnoreOnIsolateError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((IgnoreOnIsolateCallbackIF*) _callback)->onIgnoreOnIsolateError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), IgnoreOnIsolateUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "IgnoreOnIsolate", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<IgnoreOnIsolateUpdate> payload = ::boost::static_pointer_cast<IgnoreOnIsolateUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((IgnoreOnIsolateCallbackIF*) _callback)->onIgnoreOnIsolateUpdate(proxyShared, payload);
                        proxyShared->_ignoreOnIsolate = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_IgnoreOnSnapshot:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), IgnoreOnSnapshotError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "IgnoreOnSnapshot", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<IgnoreOnSnapshotError> payload = ::boost::static_pointer_cast<IgnoreOnSnapshotError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((IgnoreOnSnapshotCallbackIF*) _callback)->onIgnoreOnSnapshotError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), IgnoreOnSnapshotUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "IgnoreOnSnapshot", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<IgnoreOnSnapshotUpdate> payload = ::boost::static_pointer_cast<IgnoreOnSnapshotUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((IgnoreOnSnapshotCallbackIF*) _callback)->onIgnoreOnSnapshotUpdate(proxyShared, payload);
                        proxyShared->_ignoreOnSnapshot = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_NeedDaemonReload:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NeedDaemonReloadError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NeedDaemonReload", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NeedDaemonReloadError> payload = ::boost::static_pointer_cast<NeedDaemonReloadError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((NeedDaemonReloadCallbackIF*) _callback)->onNeedDaemonReloadError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NeedDaemonReloadUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NeedDaemonReload", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NeedDaemonReloadUpdate> payload = ::boost::static_pointer_cast<NeedDaemonReloadUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((NeedDaemonReloadCallbackIF*) _callback)->onNeedDaemonReloadUpdate(proxyShared, payload);
                        proxyShared->_needDaemonReload = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_JobTimeoutUSec:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), JobTimeoutUSecError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "JobTimeoutUSec", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<JobTimeoutUSecError> payload = ::boost::static_pointer_cast<JobTimeoutUSecError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((JobTimeoutUSecCallbackIF*) _callback)->onJobTimeoutUSecError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), JobTimeoutUSecUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "JobTimeoutUSec", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<JobTimeoutUSecUpdate> payload = ::boost::static_pointer_cast<JobTimeoutUSecUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((JobTimeoutUSecCallbackIF*) _callback)->onJobTimeoutUSecUpdate(proxyShared, payload);
                        proxyShared->_jobTimeoutUSec = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_JobTimeoutAction:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), JobTimeoutActionError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "JobTimeoutAction", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<JobTimeoutActionError> payload = ::boost::static_pointer_cast<JobTimeoutActionError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((JobTimeoutActionCallbackIF*) _callback)->onJobTimeoutActionError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), JobTimeoutActionUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "JobTimeoutAction", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<JobTimeoutActionUpdate> payload = ::boost::static_pointer_cast<JobTimeoutActionUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((JobTimeoutActionCallbackIF*) _callback)->onJobTimeoutActionUpdate(proxyShared, payload);
                        proxyShared->_jobTimeoutAction = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_JobTimeoutRebootArgument:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), JobTimeoutRebootArgumentError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "JobTimeoutRebootArgument", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<JobTimeoutRebootArgumentError> payload = ::boost::static_pointer_cast<JobTimeoutRebootArgumentError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((JobTimeoutRebootArgumentCallbackIF*) _callback)->onJobTimeoutRebootArgumentError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), JobTimeoutRebootArgumentUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "JobTimeoutRebootArgument", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<JobTimeoutRebootArgumentUpdate> payload = ::boost::static_pointer_cast<JobTimeoutRebootArgumentUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((JobTimeoutRebootArgumentCallbackIF*) _callback)->onJobTimeoutRebootArgumentUpdate(proxyShared, payload);
                        proxyShared->_jobTimeoutRebootArgument = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ConditionResult:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ConditionResultError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ConditionResult", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ConditionResultError> payload = ::boost::static_pointer_cast<ConditionResultError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ConditionResultCallbackIF*) _callback)->onConditionResultError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ConditionResultUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ConditionResult", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ConditionResultUpdate> payload = ::boost::static_pointer_cast<ConditionResultUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ConditionResultCallbackIF*) _callback)->onConditionResultUpdate(proxyShared, payload);
                        proxyShared->_conditionResult = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_AssertResult:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AssertResultError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AssertResult", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AssertResultError> payload = ::boost::static_pointer_cast<AssertResultError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((AssertResultCallbackIF*) _callback)->onAssertResultError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AssertResultUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AssertResult", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AssertResultUpdate> payload = ::boost::static_pointer_cast<AssertResultUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((AssertResultCallbackIF*) _callback)->onAssertResultUpdate(proxyShared, payload);
                        proxyShared->_assertResult = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ConditionTimestamp:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ConditionTimestampError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ConditionTimestamp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ConditionTimestampError> payload = ::boost::static_pointer_cast<ConditionTimestampError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ConditionTimestampCallbackIF*) _callback)->onConditionTimestampError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ConditionTimestampUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ConditionTimestamp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ConditionTimestampUpdate> payload = ::boost::static_pointer_cast<ConditionTimestampUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ConditionTimestampCallbackIF*) _callback)->onConditionTimestampUpdate(proxyShared, payload);
                        proxyShared->_conditionTimestamp = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ConditionTimestampMonotonic:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ConditionTimestampMonotonicError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ConditionTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ConditionTimestampMonotonicError> payload = ::boost::static_pointer_cast<ConditionTimestampMonotonicError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ConditionTimestampMonotonicCallbackIF*) _callback)->onConditionTimestampMonotonicError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ConditionTimestampMonotonicUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ConditionTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ConditionTimestampMonotonicUpdate> payload = ::boost::static_pointer_cast<ConditionTimestampMonotonicUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ConditionTimestampMonotonicCallbackIF*) _callback)->onConditionTimestampMonotonicUpdate(proxyShared, payload);
                        proxyShared->_conditionTimestampMonotonic = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_AssertTimestamp:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AssertTimestampError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AssertTimestamp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AssertTimestampError> payload = ::boost::static_pointer_cast<AssertTimestampError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((AssertTimestampCallbackIF*) _callback)->onAssertTimestampError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AssertTimestampUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AssertTimestamp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AssertTimestampUpdate> payload = ::boost::static_pointer_cast<AssertTimestampUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((AssertTimestampCallbackIF*) _callback)->onAssertTimestampUpdate(proxyShared, payload);
                        proxyShared->_assertTimestamp = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_AssertTimestampMonotonic:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AssertTimestampMonotonicError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AssertTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AssertTimestampMonotonicError> payload = ::boost::static_pointer_cast<AssertTimestampMonotonicError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((AssertTimestampMonotonicCallbackIF*) _callback)->onAssertTimestampMonotonicError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AssertTimestampMonotonicUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AssertTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AssertTimestampMonotonicUpdate> payload = ::boost::static_pointer_cast<AssertTimestampMonotonicUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((AssertTimestampMonotonicCallbackIF*) _callback)->onAssertTimestampMonotonicUpdate(proxyShared, payload);
                        proxyShared->_assertTimestampMonotonic = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Conditions:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ConditionsError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Conditions", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ConditionsError> payload = ::boost::static_pointer_cast<ConditionsError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ConditionsCallbackIF*) _callback)->onConditionsError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ConditionsUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Conditions", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ConditionsUpdate> payload = ::boost::static_pointer_cast<ConditionsUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ConditionsCallbackIF*) _callback)->onConditionsUpdate(proxyShared, payload);
                        proxyShared->_conditions = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Asserts:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AssertsError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Asserts", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AssertsError> payload = ::boost::static_pointer_cast<AssertsError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((AssertsCallbackIF*) _callback)->onAssertsError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AssertsUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Asserts", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AssertsUpdate> payload = ::boost::static_pointer_cast<AssertsUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((AssertsCallbackIF*) _callback)->onAssertsUpdate(proxyShared, payload);
                        proxyShared->_asserts = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_LoadError:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LoadErrorError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LoadError", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LoadErrorError> payload = ::boost::static_pointer_cast<LoadErrorError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((LoadErrorCallbackIF*) _callback)->onLoadErrorError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LoadErrorUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LoadError", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LoadErrorUpdate> payload = ::boost::static_pointer_cast<LoadErrorUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((LoadErrorCallbackIF*) _callback)->onLoadErrorUpdate(proxyShared, payload);
                        proxyShared->_loadError = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Transient:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TransientError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Transient", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TransientError> payload = ::boost::static_pointer_cast<TransientError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((TransientCallbackIF*) _callback)->onTransientError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TransientUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Transient", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TransientUpdate> payload = ::boost::static_pointer_cast<TransientUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((TransientCallbackIF*) _callback)->onTransientUpdate(proxyShared, payload);
                        proxyShared->_transient = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Start:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), StartError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Start", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartError> payload = ::boost::static_pointer_cast<StartError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StartCallbackIF*) _callback)->onStartError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Start", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartResponse> payload = ::boost::static_pointer_cast<StartResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StartCallbackIF*) _callback)->onStartResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_Stop:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), StopError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Stop", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StopError> payload = ::boost::static_pointer_cast<StopError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StopCallbackIF*) _callback)->onStopError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StopResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Stop", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StopResponse> payload = ::boost::static_pointer_cast<StopResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StopCallbackIF*) _callback)->onStopResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_Reload:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ReloadError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Reload", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReloadError> payload = ::boost::static_pointer_cast<ReloadError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReloadCallbackIF*) _callback)->onReloadError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReloadResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Reload", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReloadResponse> payload = ::boost::static_pointer_cast<ReloadResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReloadCallbackIF*) _callback)->onReloadResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_Restart:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RestartError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Restart", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RestartError> payload = ::boost::static_pointer_cast<RestartError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RestartCallbackIF*) _callback)->onRestartError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RestartResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Restart", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RestartResponse> payload = ::boost::static_pointer_cast<RestartResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RestartCallbackIF*) _callback)->onRestartResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_TryRestart:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), TryRestartError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "TryRestart", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TryRestartError> payload = ::boost::static_pointer_cast<TryRestartError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((TryRestartCallbackIF*) _callback)->onTryRestartError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TryRestartResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "TryRestart", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TryRestartResponse> payload = ::boost::static_pointer_cast<TryRestartResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((TryRestartCallbackIF*) _callback)->onTryRestartResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ReloadOrRestart:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ReloadOrRestartError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReloadOrRestart", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReloadOrRestartError> payload = ::boost::static_pointer_cast<ReloadOrRestartError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReloadOrRestartCallbackIF*) _callback)->onReloadOrRestartError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReloadOrRestartResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReloadOrRestart", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReloadOrRestartResponse> payload = ::boost::static_pointer_cast<ReloadOrRestartResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReloadOrRestartCallbackIF*) _callback)->onReloadOrRestartResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ReloadOrTryRestart:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ReloadOrTryRestartError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReloadOrTryRestart", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReloadOrTryRestartError> payload = ::boost::static_pointer_cast<ReloadOrTryRestartError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReloadOrTryRestartCallbackIF*) _callback)->onReloadOrTryRestartError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReloadOrTryRestartResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReloadOrTryRestart", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReloadOrTryRestartResponse> payload = ::boost::static_pointer_cast<ReloadOrTryRestartResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReloadOrTryRestartCallbackIF*) _callback)->onReloadOrTryRestartResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_Kill:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), KillError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Kill", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<KillError> payload = ::boost::static_pointer_cast<KillError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((KillCallbackIF*) _callback)->onKillError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), KillResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Kill", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<KillResponse> payload = ::boost::static_pointer_cast<KillResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((KillCallbackIF*) _callback)->onKillResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ResetFailed:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ResetFailedError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ResetFailed", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ResetFailedError> payload = ::boost::static_pointer_cast<ResetFailedError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ResetFailedCallbackIF*) _callback)->onResetFailedError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ResetFailedResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ResetFailed", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ResetFailedResponse> payload = ::boost::static_pointer_cast<ResetFailedResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ResetFailedCallbackIF*) _callback)->onResetFailedResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_SetProperties:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetPropertiesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetProperties", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetPropertiesError> payload = ::boost::static_pointer_cast<SetPropertiesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetPropertiesCallbackIF*) _callback)->onSetPropertiesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetPropertiesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetProperties", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetPropertiesResponse> payload = ::boost::static_pointer_cast<SetPropertiesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetPropertiesCallbackIF*) _callback)->onSetPropertiesResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_Id: {
                ::boost::shared_ptr< IdError > payload = ::boost::shared_ptr< IdError >
                (new IdError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Id", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((IdCallbackIF*) _callback)->onIdError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Names: {
                ::boost::shared_ptr< NamesError > payload = ::boost::shared_ptr< NamesError >
                (new NamesError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Names", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((NamesCallbackIF*) _callback)->onNamesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Following: {
                ::boost::shared_ptr< FollowingError > payload = ::boost::shared_ptr< FollowingError >
                (new FollowingError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Following", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((FollowingCallbackIF*) _callback)->onFollowingError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Requires: {
                ::boost::shared_ptr< RequiresError > payload = ::boost::shared_ptr< RequiresError >
                (new RequiresError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Requires", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RequiresCallbackIF*) _callback)->onRequiresError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RequiresOverridable: {
                ::boost::shared_ptr< RequiresOverridableError > payload = ::boost::shared_ptr< RequiresOverridableError >
                (new RequiresOverridableError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RequiresOverridable", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RequiresOverridableCallbackIF*) _callback)->onRequiresOverridableError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Requisite: {
                ::boost::shared_ptr< RequisiteError > payload = ::boost::shared_ptr< RequisiteError >
                (new RequisiteError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Requisite", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RequisiteCallbackIF*) _callback)->onRequisiteError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RequisiteOverridable: {
                ::boost::shared_ptr< RequisiteOverridableError > payload = ::boost::shared_ptr< RequisiteOverridableError >
                (new RequisiteOverridableError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RequisiteOverridable", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RequisiteOverridableCallbackIF*) _callback)->onRequisiteOverridableError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Wants: {
                ::boost::shared_ptr< WantsError > payload = ::boost::shared_ptr< WantsError >
                (new WantsError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Wants", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((WantsCallbackIF*) _callback)->onWantsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BindsTo: {
                ::boost::shared_ptr< BindsToError > payload = ::boost::shared_ptr< BindsToError >
                (new BindsToError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BindsTo", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BindsToCallbackIF*) _callback)->onBindsToError (proxyShared,payload);
                return true;
            }
            break;
            case ID_PartOf: {
                ::boost::shared_ptr< PartOfError > payload = ::boost::shared_ptr< PartOfError >
                (new PartOfError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PartOf", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PartOfCallbackIF*) _callback)->onPartOfError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RequiredBy: {
                ::boost::shared_ptr< RequiredByError > payload = ::boost::shared_ptr< RequiredByError >
                (new RequiredByError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RequiredBy", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RequiredByCallbackIF*) _callback)->onRequiredByError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RequiredByOverridable: {
                ::boost::shared_ptr< RequiredByOverridableError > payload = ::boost::shared_ptr< RequiredByOverridableError >
                (new RequiredByOverridableError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RequiredByOverridable", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RequiredByOverridableCallbackIF*) _callback)->onRequiredByOverridableError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RequisiteOf: {
                ::boost::shared_ptr< RequisiteOfError > payload = ::boost::shared_ptr< RequisiteOfError >
                (new RequisiteOfError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RequisiteOf", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RequisiteOfCallbackIF*) _callback)->onRequisiteOfError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RequisiteOfOverridable: {
                ::boost::shared_ptr< RequisiteOfOverridableError > payload = ::boost::shared_ptr< RequisiteOfOverridableError >
                (new RequisiteOfOverridableError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RequisiteOfOverridable", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RequisiteOfOverridableCallbackIF*) _callback)->onRequisiteOfOverridableError (proxyShared,payload);
                return true;
            }
            break;
            case ID_WantedBy: {
                ::boost::shared_ptr< WantedByError > payload = ::boost::shared_ptr< WantedByError >
                (new WantedByError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "WantedBy", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((WantedByCallbackIF*) _callback)->onWantedByError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BoundBy: {
                ::boost::shared_ptr< BoundByError > payload = ::boost::shared_ptr< BoundByError >
                (new BoundByError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BoundBy", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BoundByCallbackIF*) _callback)->onBoundByError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ConsistsOf: {
                ::boost::shared_ptr< ConsistsOfError > payload = ::boost::shared_ptr< ConsistsOfError >
                (new ConsistsOfError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ConsistsOf", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ConsistsOfCallbackIF*) _callback)->onConsistsOfError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Conflicts: {
                ::boost::shared_ptr< ConflictsError > payload = ::boost::shared_ptr< ConflictsError >
                (new ConflictsError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Conflicts", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ConflictsCallbackIF*) _callback)->onConflictsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ConflictedBy: {
                ::boost::shared_ptr< ConflictedByError > payload = ::boost::shared_ptr< ConflictedByError >
                (new ConflictedByError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ConflictedBy", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ConflictedByCallbackIF*) _callback)->onConflictedByError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Before: {
                ::boost::shared_ptr< BeforeError > payload = ::boost::shared_ptr< BeforeError >
                (new BeforeError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Before", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BeforeCallbackIF*) _callback)->onBeforeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_After: {
                ::boost::shared_ptr< AfterError > payload = ::boost::shared_ptr< AfterError >
                (new AfterError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "After", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AfterCallbackIF*) _callback)->onAfterError (proxyShared,payload);
                return true;
            }
            break;
            case ID_OnFailure: {
                ::boost::shared_ptr< OnFailureError > payload = ::boost::shared_ptr< OnFailureError >
                (new OnFailureError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "OnFailure", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((OnFailureCallbackIF*) _callback)->onOnFailureError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Triggers: {
                ::boost::shared_ptr< TriggersError > payload = ::boost::shared_ptr< TriggersError >
                (new TriggersError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Triggers", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((TriggersCallbackIF*) _callback)->onTriggersError (proxyShared,payload);
                return true;
            }
            break;
            case ID_TriggeredBy: {
                ::boost::shared_ptr< TriggeredByError > payload = ::boost::shared_ptr< TriggeredByError >
                (new TriggeredByError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "TriggeredBy", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((TriggeredByCallbackIF*) _callback)->onTriggeredByError (proxyShared,payload);
                return true;
            }
            break;
            case ID_PropagatesReloadTo: {
                ::boost::shared_ptr< PropagatesReloadToError > payload = ::boost::shared_ptr< PropagatesReloadToError >
                (new PropagatesReloadToError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PropagatesReloadTo", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PropagatesReloadToCallbackIF*) _callback)->onPropagatesReloadToError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ReloadPropagatedFrom: {
                ::boost::shared_ptr< ReloadPropagatedFromError > payload = ::boost::shared_ptr< ReloadPropagatedFromError >
                (new ReloadPropagatedFromError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ReloadPropagatedFrom", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReloadPropagatedFromCallbackIF*) _callback)->onReloadPropagatedFromError (proxyShared,payload);
                return true;
            }
            break;
            case ID_JoinsNamespaceOf: {
                ::boost::shared_ptr< JoinsNamespaceOfError > payload = ::boost::shared_ptr< JoinsNamespaceOfError >
                (new JoinsNamespaceOfError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "JoinsNamespaceOf", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((JoinsNamespaceOfCallbackIF*) _callback)->onJoinsNamespaceOfError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RequiresMountsFor: {
                ::boost::shared_ptr< RequiresMountsForError > payload = ::boost::shared_ptr< RequiresMountsForError >
                (new RequiresMountsForError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RequiresMountsFor", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RequiresMountsForCallbackIF*) _callback)->onRequiresMountsForError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Documentation: {
                ::boost::shared_ptr< DocumentationError > payload = ::boost::shared_ptr< DocumentationError >
                (new DocumentationError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Documentation", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DocumentationCallbackIF*) _callback)->onDocumentationError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Description: {
                ::boost::shared_ptr< DescriptionError > payload = ::boost::shared_ptr< DescriptionError >
                (new DescriptionError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Description", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DescriptionCallbackIF*) _callback)->onDescriptionError (proxyShared,payload);
                return true;
            }
            break;
            case ID_LoadState: {
                ::boost::shared_ptr< LoadStateError > payload = ::boost::shared_ptr< LoadStateError >
                (new LoadStateError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "LoadState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((LoadStateCallbackIF*) _callback)->onLoadStateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ActiveState: {
                ::boost::shared_ptr< ActiveStateError > payload = ::boost::shared_ptr< ActiveStateError >
                (new ActiveStateError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ActiveState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ActiveStateCallbackIF*) _callback)->onActiveStateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SubState: {
                ::boost::shared_ptr< SubStateError > payload = ::boost::shared_ptr< SubStateError >
                (new SubStateError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SubState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SubStateCallbackIF*) _callback)->onSubStateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_FragmentPath: {
                ::boost::shared_ptr< FragmentPathError > payload = ::boost::shared_ptr< FragmentPathError >
                (new FragmentPathError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "FragmentPath", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((FragmentPathCallbackIF*) _callback)->onFragmentPathError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SourcePath: {
                ::boost::shared_ptr< SourcePathError > payload = ::boost::shared_ptr< SourcePathError >
                (new SourcePathError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SourcePath", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SourcePathCallbackIF*) _callback)->onSourcePathError (proxyShared,payload);
                return true;
            }
            break;
            case ID_DropInPaths: {
                ::boost::shared_ptr< DropInPathsError > payload = ::boost::shared_ptr< DropInPathsError >
                (new DropInPathsError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DropInPaths", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DropInPathsCallbackIF*) _callback)->onDropInPathsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_UnitFileState: {
                ::boost::shared_ptr< UnitFileStateError > payload = ::boost::shared_ptr< UnitFileStateError >
                (new UnitFileStateError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UnitFileState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UnitFileStateCallbackIF*) _callback)->onUnitFileStateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_UnitFilePreset: {
                ::boost::shared_ptr< UnitFilePresetError > payload = ::boost::shared_ptr< UnitFilePresetError >
                (new UnitFilePresetError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UnitFilePreset", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UnitFilePresetCallbackIF*) _callback)->onUnitFilePresetError (proxyShared,payload);
                return true;
            }
            break;
            case ID_InactiveExitTimestamp: {
                ::boost::shared_ptr< InactiveExitTimestampError > payload = ::boost::shared_ptr< InactiveExitTimestampError >
                (new InactiveExitTimestampError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "InactiveExitTimestamp", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((InactiveExitTimestampCallbackIF*) _callback)->onInactiveExitTimestampError (proxyShared,payload);
                return true;
            }
            break;
            case ID_InactiveExitTimestampMonotonic: {
                ::boost::shared_ptr< InactiveExitTimestampMonotonicError > payload = ::boost::shared_ptr< InactiveExitTimestampMonotonicError >
                (new InactiveExitTimestampMonotonicError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "InactiveExitTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((InactiveExitTimestampMonotonicCallbackIF*) _callback)->onInactiveExitTimestampMonotonicError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ActiveEnterTimestamp: {
                ::boost::shared_ptr< ActiveEnterTimestampError > payload = ::boost::shared_ptr< ActiveEnterTimestampError >
                (new ActiveEnterTimestampError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ActiveEnterTimestamp", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ActiveEnterTimestampCallbackIF*) _callback)->onActiveEnterTimestampError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ActiveEnterTimestampMonotonic: {
                ::boost::shared_ptr< ActiveEnterTimestampMonotonicError > payload = ::boost::shared_ptr< ActiveEnterTimestampMonotonicError >
                (new ActiveEnterTimestampMonotonicError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ActiveEnterTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ActiveEnterTimestampMonotonicCallbackIF*) _callback)->onActiveEnterTimestampMonotonicError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ActiveExitTimestamp: {
                ::boost::shared_ptr< ActiveExitTimestampError > payload = ::boost::shared_ptr< ActiveExitTimestampError >
                (new ActiveExitTimestampError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ActiveExitTimestamp", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ActiveExitTimestampCallbackIF*) _callback)->onActiveExitTimestampError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ActiveExitTimestampMonotonic: {
                ::boost::shared_ptr< ActiveExitTimestampMonotonicError > payload = ::boost::shared_ptr< ActiveExitTimestampMonotonicError >
                (new ActiveExitTimestampMonotonicError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ActiveExitTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ActiveExitTimestampMonotonicCallbackIF*) _callback)->onActiveExitTimestampMonotonicError (proxyShared,payload);
                return true;
            }
            break;
            case ID_InactiveEnterTimestamp: {
                ::boost::shared_ptr< InactiveEnterTimestampError > payload = ::boost::shared_ptr< InactiveEnterTimestampError >
                (new InactiveEnterTimestampError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "InactiveEnterTimestamp", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((InactiveEnterTimestampCallbackIF*) _callback)->onInactiveEnterTimestampError (proxyShared,payload);
                return true;
            }
            break;
            case ID_InactiveEnterTimestampMonotonic: {
                ::boost::shared_ptr< InactiveEnterTimestampMonotonicError > payload = ::boost::shared_ptr< InactiveEnterTimestampMonotonicError >
                (new InactiveEnterTimestampMonotonicError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "InactiveEnterTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((InactiveEnterTimestampMonotonicCallbackIF*) _callback)->onInactiveEnterTimestampMonotonicError (proxyShared,payload);
                return true;
            }
            break;
            case ID_CanStart: {
                ::boost::shared_ptr< CanStartError > payload = ::boost::shared_ptr< CanStartError >
                (new CanStartError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CanStart", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CanStartCallbackIF*) _callback)->onCanStartError (proxyShared,payload);
                return true;
            }
            break;
            case ID_CanStop: {
                ::boost::shared_ptr< CanStopError > payload = ::boost::shared_ptr< CanStopError >
                (new CanStopError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CanStop", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CanStopCallbackIF*) _callback)->onCanStopError (proxyShared,payload);
                return true;
            }
            break;
            case ID_CanReload: {
                ::boost::shared_ptr< CanReloadError > payload = ::boost::shared_ptr< CanReloadError >
                (new CanReloadError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CanReload", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CanReloadCallbackIF*) _callback)->onCanReloadError (proxyShared,payload);
                return true;
            }
            break;
            case ID_CanIsolate: {
                ::boost::shared_ptr< CanIsolateError > payload = ::boost::shared_ptr< CanIsolateError >
                (new CanIsolateError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CanIsolate", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CanIsolateCallbackIF*) _callback)->onCanIsolateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Job: {
                ::boost::shared_ptr< JobError > payload = ::boost::shared_ptr< JobError >
                (new JobError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Job", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((JobCallbackIF*) _callback)->onJobError (proxyShared,payload);
                return true;
            }
            break;
            case ID_StopWhenUnneeded: {
                ::boost::shared_ptr< StopWhenUnneededError > payload = ::boost::shared_ptr< StopWhenUnneededError >
                (new StopWhenUnneededError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "StopWhenUnneeded", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StopWhenUnneededCallbackIF*) _callback)->onStopWhenUnneededError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RefuseManualStart: {
                ::boost::shared_ptr< RefuseManualStartError > payload = ::boost::shared_ptr< RefuseManualStartError >
                (new RefuseManualStartError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RefuseManualStart", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RefuseManualStartCallbackIF*) _callback)->onRefuseManualStartError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RefuseManualStop: {
                ::boost::shared_ptr< RefuseManualStopError > payload = ::boost::shared_ptr< RefuseManualStopError >
                (new RefuseManualStopError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RefuseManualStop", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RefuseManualStopCallbackIF*) _callback)->onRefuseManualStopError (proxyShared,payload);
                return true;
            }
            break;
            case ID_AllowIsolate: {
                ::boost::shared_ptr< AllowIsolateError > payload = ::boost::shared_ptr< AllowIsolateError >
                (new AllowIsolateError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AllowIsolate", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AllowIsolateCallbackIF*) _callback)->onAllowIsolateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_DefaultDependencies: {
                ::boost::shared_ptr< DefaultDependenciesError > payload = ::boost::shared_ptr< DefaultDependenciesError >
                (new DefaultDependenciesError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DefaultDependencies", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DefaultDependenciesCallbackIF*) _callback)->onDefaultDependenciesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_OnFailureJobMode: {
                ::boost::shared_ptr< OnFailureJobModeError > payload = ::boost::shared_ptr< OnFailureJobModeError >
                (new OnFailureJobModeError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "OnFailureJobMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((OnFailureJobModeCallbackIF*) _callback)->onOnFailureJobModeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_IgnoreOnIsolate: {
                ::boost::shared_ptr< IgnoreOnIsolateError > payload = ::boost::shared_ptr< IgnoreOnIsolateError >
                (new IgnoreOnIsolateError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "IgnoreOnIsolate", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((IgnoreOnIsolateCallbackIF*) _callback)->onIgnoreOnIsolateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_IgnoreOnSnapshot: {
                ::boost::shared_ptr< IgnoreOnSnapshotError > payload = ::boost::shared_ptr< IgnoreOnSnapshotError >
                (new IgnoreOnSnapshotError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "IgnoreOnSnapshot", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((IgnoreOnSnapshotCallbackIF*) _callback)->onIgnoreOnSnapshotError (proxyShared,payload);
                return true;
            }
            break;
            case ID_NeedDaemonReload: {
                ::boost::shared_ptr< NeedDaemonReloadError > payload = ::boost::shared_ptr< NeedDaemonReloadError >
                (new NeedDaemonReloadError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "NeedDaemonReload", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((NeedDaemonReloadCallbackIF*) _callback)->onNeedDaemonReloadError (proxyShared,payload);
                return true;
            }
            break;
            case ID_JobTimeoutUSec: {
                ::boost::shared_ptr< JobTimeoutUSecError > payload = ::boost::shared_ptr< JobTimeoutUSecError >
                (new JobTimeoutUSecError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "JobTimeoutUSec", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((JobTimeoutUSecCallbackIF*) _callback)->onJobTimeoutUSecError (proxyShared,payload);
                return true;
            }
            break;
            case ID_JobTimeoutAction: {
                ::boost::shared_ptr< JobTimeoutActionError > payload = ::boost::shared_ptr< JobTimeoutActionError >
                (new JobTimeoutActionError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "JobTimeoutAction", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((JobTimeoutActionCallbackIF*) _callback)->onJobTimeoutActionError (proxyShared,payload);
                return true;
            }
            break;
            case ID_JobTimeoutRebootArgument: {
                ::boost::shared_ptr< JobTimeoutRebootArgumentError > payload = ::boost::shared_ptr< JobTimeoutRebootArgumentError >
                (new JobTimeoutRebootArgumentError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "JobTimeoutRebootArgument", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((JobTimeoutRebootArgumentCallbackIF*) _callback)->onJobTimeoutRebootArgumentError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ConditionResult: {
                ::boost::shared_ptr< ConditionResultError > payload = ::boost::shared_ptr< ConditionResultError >
                (new ConditionResultError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ConditionResult", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ConditionResultCallbackIF*) _callback)->onConditionResultError (proxyShared,payload);
                return true;
            }
            break;
            case ID_AssertResult: {
                ::boost::shared_ptr< AssertResultError > payload = ::boost::shared_ptr< AssertResultError >
                (new AssertResultError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AssertResult", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AssertResultCallbackIF*) _callback)->onAssertResultError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ConditionTimestamp: {
                ::boost::shared_ptr< ConditionTimestampError > payload = ::boost::shared_ptr< ConditionTimestampError >
                (new ConditionTimestampError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ConditionTimestamp", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ConditionTimestampCallbackIF*) _callback)->onConditionTimestampError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ConditionTimestampMonotonic: {
                ::boost::shared_ptr< ConditionTimestampMonotonicError > payload = ::boost::shared_ptr< ConditionTimestampMonotonicError >
                (new ConditionTimestampMonotonicError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ConditionTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ConditionTimestampMonotonicCallbackIF*) _callback)->onConditionTimestampMonotonicError (proxyShared,payload);
                return true;
            }
            break;
            case ID_AssertTimestamp: {
                ::boost::shared_ptr< AssertTimestampError > payload = ::boost::shared_ptr< AssertTimestampError >
                (new AssertTimestampError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AssertTimestamp", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AssertTimestampCallbackIF*) _callback)->onAssertTimestampError (proxyShared,payload);
                return true;
            }
            break;
            case ID_AssertTimestampMonotonic: {
                ::boost::shared_ptr< AssertTimestampMonotonicError > payload = ::boost::shared_ptr< AssertTimestampMonotonicError >
                (new AssertTimestampMonotonicError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AssertTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AssertTimestampMonotonicCallbackIF*) _callback)->onAssertTimestampMonotonicError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Conditions: {
                ::boost::shared_ptr< ConditionsError > payload = ::boost::shared_ptr< ConditionsError >
                (new ConditionsError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Conditions", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ConditionsCallbackIF*) _callback)->onConditionsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Asserts: {
                ::boost::shared_ptr< AssertsError > payload = ::boost::shared_ptr< AssertsError >
                (new AssertsError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Asserts", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AssertsCallbackIF*) _callback)->onAssertsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_LoadError: {
                ::boost::shared_ptr< LoadErrorError > payload = ::boost::shared_ptr< LoadErrorError >
                (new LoadErrorError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "LoadError", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((LoadErrorCallbackIF*) _callback)->onLoadErrorError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Transient: {
                ::boost::shared_ptr< TransientError > payload = ::boost::shared_ptr< TransientError >
                (new TransientError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Transient", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((TransientCallbackIF*) _callback)->onTransientError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Start: {
                ::boost::shared_ptr< StartError > payload = ::boost::shared_ptr< StartError >
                (new StartError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Start", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StartCallbackIF*) _callback)->onStartError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Stop: {
                ::boost::shared_ptr< StopError > payload = ::boost::shared_ptr< StopError >
                (new StopError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Stop", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StopCallbackIF*) _callback)->onStopError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Reload: {
                ::boost::shared_ptr< ReloadError > payload = ::boost::shared_ptr< ReloadError >
                (new ReloadError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Reload", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReloadCallbackIF*) _callback)->onReloadError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Restart: {
                ::boost::shared_ptr< RestartError > payload = ::boost::shared_ptr< RestartError >
                (new RestartError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Restart", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RestartCallbackIF*) _callback)->onRestartError (proxyShared,payload);
                return true;
            }
            break;
            case ID_TryRestart: {
                ::boost::shared_ptr< TryRestartError > payload = ::boost::shared_ptr< TryRestartError >
                (new TryRestartError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "TryRestart", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((TryRestartCallbackIF*) _callback)->onTryRestartError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ReloadOrRestart: {
                ::boost::shared_ptr< ReloadOrRestartError > payload = ::boost::shared_ptr< ReloadOrRestartError >
                (new ReloadOrRestartError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ReloadOrRestart", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReloadOrRestartCallbackIF*) _callback)->onReloadOrRestartError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ReloadOrTryRestart: {
                ::boost::shared_ptr< ReloadOrTryRestartError > payload = ::boost::shared_ptr< ReloadOrTryRestartError >
                (new ReloadOrTryRestartError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ReloadOrTryRestart", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReloadOrTryRestartCallbackIF*) _callback)->onReloadOrTryRestartError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Kill: {
                ::boost::shared_ptr< KillError > payload = ::boost::shared_ptr< KillError >
                (new KillError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Kill", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((KillCallbackIF*) _callback)->onKillError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ResetFailed: {
                ::boost::shared_ptr< ResetFailedError > payload = ::boost::shared_ptr< ResetFailedError >
                (new ResetFailedError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ResetFailed", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ResetFailedCallbackIF*) _callback)->onResetFailedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SetProperties: {
                ::boost::shared_ptr< SetPropertiesError > payload = ::boost::shared_ptr< SetPropertiesError >
                (new SetPropertiesError(DBUS_ERROR_NO_SERVER, "The DBus service Unit is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetProperties", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<UnitProxy> proxyShared = ::boost::static_pointer_cast<UnitProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetPropertiesCallbackIF*) _callback)->onSetPropertiesError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& UnitProxyCallback::_logger (UnitProxy::_logger);

UnitProxy::UnitProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.freedesktop.systemd1.Unit", serviceAvailable, _logger) {
}

UnitProxy::~UnitProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< UnitProxy > UnitProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<UnitProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< UnitProxy > proxyNew(new UnitProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t UnitProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    UnitProxyCallback* callback = new UnitProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t UnitProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    UnitProxyCallback* callback = new UnitProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void UnitProxy::clearAllProperties ()
{
    _id = ::asf::core::nullable< IdUpdate >();
    _names = ::asf::core::nullable< NamesUpdate >();
    _following = ::asf::core::nullable< FollowingUpdate >();
    _requires = ::asf::core::nullable< RequiresUpdate >();
    _requiresOverridable = ::asf::core::nullable< RequiresOverridableUpdate >();
    _requisite = ::asf::core::nullable< RequisiteUpdate >();
    _requisiteOverridable = ::asf::core::nullable< RequisiteOverridableUpdate >();
    _wants = ::asf::core::nullable< WantsUpdate >();
    _bindsTo = ::asf::core::nullable< BindsToUpdate >();
    _partOf = ::asf::core::nullable< PartOfUpdate >();
    _requiredBy = ::asf::core::nullable< RequiredByUpdate >();
    _requiredByOverridable = ::asf::core::nullable< RequiredByOverridableUpdate >();
    _requisiteOf = ::asf::core::nullable< RequisiteOfUpdate >();
    _requisiteOfOverridable = ::asf::core::nullable< RequisiteOfOverridableUpdate >();
    _wantedBy = ::asf::core::nullable< WantedByUpdate >();
    _boundBy = ::asf::core::nullable< BoundByUpdate >();
    _consistsOf = ::asf::core::nullable< ConsistsOfUpdate >();
    _conflicts = ::asf::core::nullable< ConflictsUpdate >();
    _conflictedBy = ::asf::core::nullable< ConflictedByUpdate >();
    _before = ::asf::core::nullable< BeforeUpdate >();
    _after = ::asf::core::nullable< AfterUpdate >();
    _onFailure = ::asf::core::nullable< OnFailureUpdate >();
    _triggers = ::asf::core::nullable< TriggersUpdate >();
    _triggeredBy = ::asf::core::nullable< TriggeredByUpdate >();
    _propagatesReloadTo = ::asf::core::nullable< PropagatesReloadToUpdate >();
    _reloadPropagatedFrom = ::asf::core::nullable< ReloadPropagatedFromUpdate >();
    _joinsNamespaceOf = ::asf::core::nullable< JoinsNamespaceOfUpdate >();
    _requiresMountsFor = ::asf::core::nullable< RequiresMountsForUpdate >();
    _documentation = ::asf::core::nullable< DocumentationUpdate >();
    _description = ::asf::core::nullable< DescriptionUpdate >();
    _loadState = ::asf::core::nullable< LoadStateUpdate >();
    _activeState = ::asf::core::nullable< ActiveStateUpdate >();
    _subState = ::asf::core::nullable< SubStateUpdate >();
    _fragmentPath = ::asf::core::nullable< FragmentPathUpdate >();
    _sourcePath = ::asf::core::nullable< SourcePathUpdate >();
    _dropInPaths = ::asf::core::nullable< DropInPathsUpdate >();
    _unitFileState = ::asf::core::nullable< UnitFileStateUpdate >();
    _unitFilePreset = ::asf::core::nullable< UnitFilePresetUpdate >();
    _inactiveExitTimestamp = ::asf::core::nullable< InactiveExitTimestampUpdate >();
    _inactiveExitTimestampMonotonic = ::asf::core::nullable< InactiveExitTimestampMonotonicUpdate >();
    _activeEnterTimestamp = ::asf::core::nullable< ActiveEnterTimestampUpdate >();
    _activeEnterTimestampMonotonic = ::asf::core::nullable< ActiveEnterTimestampMonotonicUpdate >();
    _activeExitTimestamp = ::asf::core::nullable< ActiveExitTimestampUpdate >();
    _activeExitTimestampMonotonic = ::asf::core::nullable< ActiveExitTimestampMonotonicUpdate >();
    _inactiveEnterTimestamp = ::asf::core::nullable< InactiveEnterTimestampUpdate >();
    _inactiveEnterTimestampMonotonic = ::asf::core::nullable< InactiveEnterTimestampMonotonicUpdate >();
    _canStart = ::asf::core::nullable< CanStartUpdate >();
    _canStop = ::asf::core::nullable< CanStopUpdate >();
    _canReload = ::asf::core::nullable< CanReloadUpdate >();
    _canIsolate = ::asf::core::nullable< CanIsolateUpdate >();
    _job = ::asf::core::nullable< JobUpdate >();
    _stopWhenUnneeded = ::asf::core::nullable< StopWhenUnneededUpdate >();
    _refuseManualStart = ::asf::core::nullable< RefuseManualStartUpdate >();
    _refuseManualStop = ::asf::core::nullable< RefuseManualStopUpdate >();
    _allowIsolate = ::asf::core::nullable< AllowIsolateUpdate >();
    _defaultDependencies = ::asf::core::nullable< DefaultDependenciesUpdate >();
    _onFailureJobMode = ::asf::core::nullable< OnFailureJobModeUpdate >();
    _ignoreOnIsolate = ::asf::core::nullable< IgnoreOnIsolateUpdate >();
    _ignoreOnSnapshot = ::asf::core::nullable< IgnoreOnSnapshotUpdate >();
    _needDaemonReload = ::asf::core::nullable< NeedDaemonReloadUpdate >();
    _jobTimeoutUSec = ::asf::core::nullable< JobTimeoutUSecUpdate >();
    _jobTimeoutAction = ::asf::core::nullable< JobTimeoutActionUpdate >();
    _jobTimeoutRebootArgument = ::asf::core::nullable< JobTimeoutRebootArgumentUpdate >();
    _conditionResult = ::asf::core::nullable< ConditionResultUpdate >();
    _assertResult = ::asf::core::nullable< AssertResultUpdate >();
    _conditionTimestamp = ::asf::core::nullable< ConditionTimestampUpdate >();
    _conditionTimestampMonotonic = ::asf::core::nullable< ConditionTimestampMonotonicUpdate >();
    _assertTimestamp = ::asf::core::nullable< AssertTimestampUpdate >();
    _assertTimestampMonotonic = ::asf::core::nullable< AssertTimestampMonotonicUpdate >();
    _conditions = ::asf::core::nullable< ConditionsUpdate >();
    _asserts = ::asf::core::nullable< AssertsUpdate >();
    _loadError = ::asf::core::nullable< LoadErrorUpdate >();
    _transient = ::asf::core::nullable< TransientUpdate >();
}

void UnitProxy::sendDeregisterAll () const
{
    sendIdDeregisterAll();
    sendNamesDeregisterAll();
    sendFollowingDeregisterAll();
    sendRequiresDeregisterAll();
    sendRequiresOverridableDeregisterAll();
    sendRequisiteDeregisterAll();
    sendRequisiteOverridableDeregisterAll();
    sendWantsDeregisterAll();
    sendBindsToDeregisterAll();
    sendPartOfDeregisterAll();
    sendRequiredByDeregisterAll();
    sendRequiredByOverridableDeregisterAll();
    sendRequisiteOfDeregisterAll();
    sendRequisiteOfOverridableDeregisterAll();
    sendWantedByDeregisterAll();
    sendBoundByDeregisterAll();
    sendConsistsOfDeregisterAll();
    sendConflictsDeregisterAll();
    sendConflictedByDeregisterAll();
    sendBeforeDeregisterAll();
    sendAfterDeregisterAll();
    sendOnFailureDeregisterAll();
    sendTriggersDeregisterAll();
    sendTriggeredByDeregisterAll();
    sendPropagatesReloadToDeregisterAll();
    sendReloadPropagatedFromDeregisterAll();
    sendJoinsNamespaceOfDeregisterAll();
    sendRequiresMountsForDeregisterAll();
    sendDocumentationDeregisterAll();
    sendDescriptionDeregisterAll();
    sendLoadStateDeregisterAll();
    sendActiveStateDeregisterAll();
    sendSubStateDeregisterAll();
    sendFragmentPathDeregisterAll();
    sendSourcePathDeregisterAll();
    sendDropInPathsDeregisterAll();
    sendUnitFileStateDeregisterAll();
    sendUnitFilePresetDeregisterAll();
    sendInactiveExitTimestampDeregisterAll();
    sendInactiveExitTimestampMonotonicDeregisterAll();
    sendActiveEnterTimestampDeregisterAll();
    sendActiveEnterTimestampMonotonicDeregisterAll();
    sendActiveExitTimestampDeregisterAll();
    sendActiveExitTimestampMonotonicDeregisterAll();
    sendInactiveEnterTimestampDeregisterAll();
    sendInactiveEnterTimestampMonotonicDeregisterAll();
    sendCanStartDeregisterAll();
    sendCanStopDeregisterAll();
    sendCanReloadDeregisterAll();
    sendCanIsolateDeregisterAll();
    sendJobDeregisterAll();
    sendStopWhenUnneededDeregisterAll();
    sendRefuseManualStartDeregisterAll();
    sendRefuseManualStopDeregisterAll();
    sendAllowIsolateDeregisterAll();
    sendDefaultDependenciesDeregisterAll();
    sendOnFailureJobModeDeregisterAll();
    sendIgnoreOnIsolateDeregisterAll();
    sendIgnoreOnSnapshotDeregisterAll();
    sendNeedDaemonReloadDeregisterAll();
    sendJobTimeoutUSecDeregisterAll();
    sendJobTimeoutActionDeregisterAll();
    sendJobTimeoutRebootArgumentDeregisterAll();
    sendConditionResultDeregisterAll();
    sendAssertResultDeregisterAll();
    sendConditionTimestampDeregisterAll();
    sendConditionTimestampMonotonicDeregisterAll();
    sendAssertTimestampDeregisterAll();
    sendAssertTimestampMonotonicDeregisterAll();
    sendConditionsDeregisterAll();
    sendAssertsDeregisterAll();
    sendLoadErrorDeregisterAll();
    sendTransientDeregisterAll();
}

act_t UnitProxy::sendIdRegister(IdCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Id, "Id", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Id", &cb, act);
    return act;
}

bool UnitProxy::sendIdDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Id", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Id", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendIdGet(IdCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_Id, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Id", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Id", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& UnitProxy::getId() const {
    return _id.get().getId();
}

bool UnitProxy::hasId() const {
    return _id.hasValue();
}

void UnitProxy::sendIdDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Id");
    _dbusProxyDelegate->deregisterSignalCallback("Id", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendNamesRegister(NamesCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Names, "Names", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Names", &cb, act);
    return act;
}

bool UnitProxy::sendNamesDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Names", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Names", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendNamesGet(NamesCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_Names, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Names", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Names", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::std::string >& UnitProxy::getNames() const {
    return _names.get().getNames();
}

bool UnitProxy::hasNames() const {
    return _names.hasValue();
}

void UnitProxy::sendNamesDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Names");
    _dbusProxyDelegate->deregisterSignalCallback("Names", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendFollowingRegister(FollowingCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Following, "Following", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Following", &cb, act);
    return act;
}

bool UnitProxy::sendFollowingDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Following", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Following", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendFollowingGet(FollowingCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_Following, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Following", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Following", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& UnitProxy::getFollowing() const {
    return _following.get().getFollowing();
}

bool UnitProxy::hasFollowing() const {
    return _following.hasValue();
}

void UnitProxy::sendFollowingDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Following");
    _dbusProxyDelegate->deregisterSignalCallback("Following", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendRequiresRegister(RequiresCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Requires, "Requires", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Requires", &cb, act);
    return act;
}

bool UnitProxy::sendRequiresDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Requires", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Requires", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendRequiresGet(RequiresCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_Requires, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Requires", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Requires", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::std::string >& UnitProxy::getRequires() const {
    return _requires.get().getRequires();
}

bool UnitProxy::hasRequires() const {
    return _requires.hasValue();
}

void UnitProxy::sendRequiresDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Requires");
    _dbusProxyDelegate->deregisterSignalCallback("Requires", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendRequiresOverridableRegister(RequiresOverridableCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_RequiresOverridable, "RequiresOverridable", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "RequiresOverridable", &cb, act);
    return act;
}

bool UnitProxy::sendRequiresOverridableDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("RequiresOverridable", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "RequiresOverridable", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendRequiresOverridableGet(RequiresOverridableCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_RequiresOverridable, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "RequiresOverridable", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("RequiresOverridable", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::std::string >& UnitProxy::getRequiresOverridable() const {
    return _requiresOverridable.get().getRequiresOverridable();
}

bool UnitProxy::hasRequiresOverridable() const {
    return _requiresOverridable.hasValue();
}

void UnitProxy::sendRequiresOverridableDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "RequiresOverridable");
    _dbusProxyDelegate->deregisterSignalCallback("RequiresOverridable", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendRequisiteRegister(RequisiteCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Requisite, "Requisite", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Requisite", &cb, act);
    return act;
}

bool UnitProxy::sendRequisiteDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Requisite", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Requisite", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendRequisiteGet(RequisiteCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_Requisite, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Requisite", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Requisite", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::std::string >& UnitProxy::getRequisite() const {
    return _requisite.get().getRequisite();
}

bool UnitProxy::hasRequisite() const {
    return _requisite.hasValue();
}

void UnitProxy::sendRequisiteDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Requisite");
    _dbusProxyDelegate->deregisterSignalCallback("Requisite", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendRequisiteOverridableRegister(RequisiteOverridableCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_RequisiteOverridable, "RequisiteOverridable", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "RequisiteOverridable", &cb, act);
    return act;
}

bool UnitProxy::sendRequisiteOverridableDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("RequisiteOverridable", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "RequisiteOverridable", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendRequisiteOverridableGet(RequisiteOverridableCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_RequisiteOverridable, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "RequisiteOverridable", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("RequisiteOverridable", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::std::string >& UnitProxy::getRequisiteOverridable() const {
    return _requisiteOverridable.get().getRequisiteOverridable();
}

bool UnitProxy::hasRequisiteOverridable() const {
    return _requisiteOverridable.hasValue();
}

void UnitProxy::sendRequisiteOverridableDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "RequisiteOverridable");
    _dbusProxyDelegate->deregisterSignalCallback("RequisiteOverridable", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendWantsRegister(WantsCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Wants, "Wants", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Wants", &cb, act);
    return act;
}

bool UnitProxy::sendWantsDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Wants", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Wants", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendWantsGet(WantsCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_Wants, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Wants", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Wants", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::std::string >& UnitProxy::getWants() const {
    return _wants.get().getWants();
}

bool UnitProxy::hasWants() const {
    return _wants.hasValue();
}

void UnitProxy::sendWantsDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Wants");
    _dbusProxyDelegate->deregisterSignalCallback("Wants", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendBindsToRegister(BindsToCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_BindsTo, "BindsTo", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BindsTo", &cb, act);
    return act;
}

bool UnitProxy::sendBindsToDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("BindsTo", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BindsTo", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendBindsToGet(BindsToCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_BindsTo, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "BindsTo", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("BindsTo", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::std::string >& UnitProxy::getBindsTo() const {
    return _bindsTo.get().getBindsTo();
}

bool UnitProxy::hasBindsTo() const {
    return _bindsTo.hasValue();
}

void UnitProxy::sendBindsToDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BindsTo");
    _dbusProxyDelegate->deregisterSignalCallback("BindsTo", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendPartOfRegister(PartOfCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_PartOf, "PartOf", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "PartOf", &cb, act);
    return act;
}

bool UnitProxy::sendPartOfDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("PartOf", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "PartOf", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendPartOfGet(PartOfCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_PartOf, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "PartOf", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("PartOf", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::std::string >& UnitProxy::getPartOf() const {
    return _partOf.get().getPartOf();
}

bool UnitProxy::hasPartOf() const {
    return _partOf.hasValue();
}

void UnitProxy::sendPartOfDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "PartOf");
    _dbusProxyDelegate->deregisterSignalCallback("PartOf", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendRequiredByRegister(RequiredByCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_RequiredBy, "RequiredBy", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "RequiredBy", &cb, act);
    return act;
}

bool UnitProxy::sendRequiredByDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("RequiredBy", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "RequiredBy", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendRequiredByGet(RequiredByCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_RequiredBy, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "RequiredBy", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("RequiredBy", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::std::string >& UnitProxy::getRequiredBy() const {
    return _requiredBy.get().getRequiredBy();
}

bool UnitProxy::hasRequiredBy() const {
    return _requiredBy.hasValue();
}

void UnitProxy::sendRequiredByDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "RequiredBy");
    _dbusProxyDelegate->deregisterSignalCallback("RequiredBy", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendRequiredByOverridableRegister(RequiredByOverridableCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_RequiredByOverridable, "RequiredByOverridable", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "RequiredByOverridable", &cb, act);
    return act;
}

bool UnitProxy::sendRequiredByOverridableDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("RequiredByOverridable", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "RequiredByOverridable", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendRequiredByOverridableGet(RequiredByOverridableCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_RequiredByOverridable, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "RequiredByOverridable", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("RequiredByOverridable", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::std::string >& UnitProxy::getRequiredByOverridable() const {
    return _requiredByOverridable.get().getRequiredByOverridable();
}

bool UnitProxy::hasRequiredByOverridable() const {
    return _requiredByOverridable.hasValue();
}

void UnitProxy::sendRequiredByOverridableDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "RequiredByOverridable");
    _dbusProxyDelegate->deregisterSignalCallback("RequiredByOverridable", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendRequisiteOfRegister(RequisiteOfCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_RequisiteOf, "RequisiteOf", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "RequisiteOf", &cb, act);
    return act;
}

bool UnitProxy::sendRequisiteOfDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("RequisiteOf", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "RequisiteOf", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendRequisiteOfGet(RequisiteOfCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_RequisiteOf, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "RequisiteOf", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("RequisiteOf", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::std::string >& UnitProxy::getRequisiteOf() const {
    return _requisiteOf.get().getRequisiteOf();
}

bool UnitProxy::hasRequisiteOf() const {
    return _requisiteOf.hasValue();
}

void UnitProxy::sendRequisiteOfDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "RequisiteOf");
    _dbusProxyDelegate->deregisterSignalCallback("RequisiteOf", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendRequisiteOfOverridableRegister(RequisiteOfOverridableCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_RequisiteOfOverridable, "RequisiteOfOverridable", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "RequisiteOfOverridable", &cb, act);
    return act;
}

bool UnitProxy::sendRequisiteOfOverridableDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("RequisiteOfOverridable", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "RequisiteOfOverridable", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendRequisiteOfOverridableGet(RequisiteOfOverridableCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_RequisiteOfOverridable, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "RequisiteOfOverridable", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("RequisiteOfOverridable", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::std::string >& UnitProxy::getRequisiteOfOverridable() const {
    return _requisiteOfOverridable.get().getRequisiteOfOverridable();
}

bool UnitProxy::hasRequisiteOfOverridable() const {
    return _requisiteOfOverridable.hasValue();
}

void UnitProxy::sendRequisiteOfOverridableDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "RequisiteOfOverridable");
    _dbusProxyDelegate->deregisterSignalCallback("RequisiteOfOverridable", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendWantedByRegister(WantedByCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_WantedBy, "WantedBy", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "WantedBy", &cb, act);
    return act;
}

bool UnitProxy::sendWantedByDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("WantedBy", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "WantedBy", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendWantedByGet(WantedByCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_WantedBy, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "WantedBy", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("WantedBy", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::std::string >& UnitProxy::getWantedBy() const {
    return _wantedBy.get().getWantedBy();
}

bool UnitProxy::hasWantedBy() const {
    return _wantedBy.hasValue();
}

void UnitProxy::sendWantedByDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "WantedBy");
    _dbusProxyDelegate->deregisterSignalCallback("WantedBy", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendBoundByRegister(BoundByCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_BoundBy, "BoundBy", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BoundBy", &cb, act);
    return act;
}

bool UnitProxy::sendBoundByDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("BoundBy", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BoundBy", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendBoundByGet(BoundByCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_BoundBy, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "BoundBy", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("BoundBy", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::std::string >& UnitProxy::getBoundBy() const {
    return _boundBy.get().getBoundBy();
}

bool UnitProxy::hasBoundBy() const {
    return _boundBy.hasValue();
}

void UnitProxy::sendBoundByDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BoundBy");
    _dbusProxyDelegate->deregisterSignalCallback("BoundBy", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendConsistsOfRegister(ConsistsOfCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ConsistsOf, "ConsistsOf", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ConsistsOf", &cb, act);
    return act;
}

bool UnitProxy::sendConsistsOfDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ConsistsOf", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ConsistsOf", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendConsistsOfGet(ConsistsOfCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_ConsistsOf, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ConsistsOf", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ConsistsOf", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::std::string >& UnitProxy::getConsistsOf() const {
    return _consistsOf.get().getConsistsOf();
}

bool UnitProxy::hasConsistsOf() const {
    return _consistsOf.hasValue();
}

void UnitProxy::sendConsistsOfDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ConsistsOf");
    _dbusProxyDelegate->deregisterSignalCallback("ConsistsOf", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendConflictsRegister(ConflictsCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Conflicts, "Conflicts", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Conflicts", &cb, act);
    return act;
}

bool UnitProxy::sendConflictsDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Conflicts", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Conflicts", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendConflictsGet(ConflictsCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_Conflicts, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Conflicts", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Conflicts", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::std::string >& UnitProxy::getConflicts() const {
    return _conflicts.get().getConflicts();
}

bool UnitProxy::hasConflicts() const {
    return _conflicts.hasValue();
}

void UnitProxy::sendConflictsDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Conflicts");
    _dbusProxyDelegate->deregisterSignalCallback("Conflicts", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendConflictedByRegister(ConflictedByCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ConflictedBy, "ConflictedBy", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ConflictedBy", &cb, act);
    return act;
}

bool UnitProxy::sendConflictedByDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ConflictedBy", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ConflictedBy", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendConflictedByGet(ConflictedByCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_ConflictedBy, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ConflictedBy", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ConflictedBy", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::std::string >& UnitProxy::getConflictedBy() const {
    return _conflictedBy.get().getConflictedBy();
}

bool UnitProxy::hasConflictedBy() const {
    return _conflictedBy.hasValue();
}

void UnitProxy::sendConflictedByDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ConflictedBy");
    _dbusProxyDelegate->deregisterSignalCallback("ConflictedBy", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendBeforeRegister(BeforeCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Before, "Before", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Before", &cb, act);
    return act;
}

bool UnitProxy::sendBeforeDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Before", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Before", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendBeforeGet(BeforeCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_Before, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Before", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Before", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::std::string >& UnitProxy::getBefore() const {
    return _before.get().getBefore();
}

bool UnitProxy::hasBefore() const {
    return _before.hasValue();
}

void UnitProxy::sendBeforeDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Before");
    _dbusProxyDelegate->deregisterSignalCallback("Before", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendAfterRegister(AfterCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_After, "After", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "After", &cb, act);
    return act;
}

bool UnitProxy::sendAfterDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("After", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "After", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendAfterGet(AfterCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_After, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "After", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("After", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::std::string >& UnitProxy::getAfter() const {
    return _after.get().getAfter();
}

bool UnitProxy::hasAfter() const {
    return _after.hasValue();
}

void UnitProxy::sendAfterDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "After");
    _dbusProxyDelegate->deregisterSignalCallback("After", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendOnFailureRegister(OnFailureCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_OnFailure, "OnFailure", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "OnFailure", &cb, act);
    return act;
}

bool UnitProxy::sendOnFailureDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("OnFailure", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "OnFailure", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendOnFailureGet(OnFailureCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_OnFailure, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "OnFailure", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("OnFailure", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::std::string >& UnitProxy::getOnFailure() const {
    return _onFailure.get().getOnFailure();
}

bool UnitProxy::hasOnFailure() const {
    return _onFailure.hasValue();
}

void UnitProxy::sendOnFailureDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "OnFailure");
    _dbusProxyDelegate->deregisterSignalCallback("OnFailure", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendTriggersRegister(TriggersCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Triggers, "Triggers", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Triggers", &cb, act);
    return act;
}

bool UnitProxy::sendTriggersDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Triggers", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Triggers", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendTriggersGet(TriggersCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_Triggers, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Triggers", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Triggers", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::std::string >& UnitProxy::getTriggers() const {
    return _triggers.get().getTriggers();
}

bool UnitProxy::hasTriggers() const {
    return _triggers.hasValue();
}

void UnitProxy::sendTriggersDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Triggers");
    _dbusProxyDelegate->deregisterSignalCallback("Triggers", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendTriggeredByRegister(TriggeredByCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_TriggeredBy, "TriggeredBy", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "TriggeredBy", &cb, act);
    return act;
}

bool UnitProxy::sendTriggeredByDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("TriggeredBy", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "TriggeredBy", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendTriggeredByGet(TriggeredByCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_TriggeredBy, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "TriggeredBy", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("TriggeredBy", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::std::string >& UnitProxy::getTriggeredBy() const {
    return _triggeredBy.get().getTriggeredBy();
}

bool UnitProxy::hasTriggeredBy() const {
    return _triggeredBy.hasValue();
}

void UnitProxy::sendTriggeredByDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "TriggeredBy");
    _dbusProxyDelegate->deregisterSignalCallback("TriggeredBy", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendPropagatesReloadToRegister(PropagatesReloadToCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_PropagatesReloadTo, "PropagatesReloadTo", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "PropagatesReloadTo", &cb, act);
    return act;
}

bool UnitProxy::sendPropagatesReloadToDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("PropagatesReloadTo", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "PropagatesReloadTo", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendPropagatesReloadToGet(PropagatesReloadToCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_PropagatesReloadTo, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "PropagatesReloadTo", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("PropagatesReloadTo", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::std::string >& UnitProxy::getPropagatesReloadTo() const {
    return _propagatesReloadTo.get().getPropagatesReloadTo();
}

bool UnitProxy::hasPropagatesReloadTo() const {
    return _propagatesReloadTo.hasValue();
}

void UnitProxy::sendPropagatesReloadToDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "PropagatesReloadTo");
    _dbusProxyDelegate->deregisterSignalCallback("PropagatesReloadTo", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendReloadPropagatedFromRegister(ReloadPropagatedFromCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ReloadPropagatedFrom, "ReloadPropagatedFrom", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ReloadPropagatedFrom", &cb, act);
    return act;
}

bool UnitProxy::sendReloadPropagatedFromDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ReloadPropagatedFrom", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ReloadPropagatedFrom", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendReloadPropagatedFromGet(ReloadPropagatedFromCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_ReloadPropagatedFrom, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ReloadPropagatedFrom", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ReloadPropagatedFrom", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::std::string >& UnitProxy::getReloadPropagatedFrom() const {
    return _reloadPropagatedFrom.get().getReloadPropagatedFrom();
}

bool UnitProxy::hasReloadPropagatedFrom() const {
    return _reloadPropagatedFrom.hasValue();
}

void UnitProxy::sendReloadPropagatedFromDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ReloadPropagatedFrom");
    _dbusProxyDelegate->deregisterSignalCallback("ReloadPropagatedFrom", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendJoinsNamespaceOfRegister(JoinsNamespaceOfCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_JoinsNamespaceOf, "JoinsNamespaceOf", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "JoinsNamespaceOf", &cb, act);
    return act;
}

bool UnitProxy::sendJoinsNamespaceOfDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("JoinsNamespaceOf", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "JoinsNamespaceOf", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendJoinsNamespaceOfGet(JoinsNamespaceOfCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_JoinsNamespaceOf, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "JoinsNamespaceOf", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("JoinsNamespaceOf", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::std::string >& UnitProxy::getJoinsNamespaceOf() const {
    return _joinsNamespaceOf.get().getJoinsNamespaceOf();
}

bool UnitProxy::hasJoinsNamespaceOf() const {
    return _joinsNamespaceOf.hasValue();
}

void UnitProxy::sendJoinsNamespaceOfDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "JoinsNamespaceOf");
    _dbusProxyDelegate->deregisterSignalCallback("JoinsNamespaceOf", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendRequiresMountsForRegister(RequiresMountsForCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_RequiresMountsFor, "RequiresMountsFor", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "RequiresMountsFor", &cb, act);
    return act;
}

bool UnitProxy::sendRequiresMountsForDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("RequiresMountsFor", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "RequiresMountsFor", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendRequiresMountsForGet(RequiresMountsForCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_RequiresMountsFor, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "RequiresMountsFor", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("RequiresMountsFor", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::std::string >& UnitProxy::getRequiresMountsFor() const {
    return _requiresMountsFor.get().getRequiresMountsFor();
}

bool UnitProxy::hasRequiresMountsFor() const {
    return _requiresMountsFor.hasValue();
}

void UnitProxy::sendRequiresMountsForDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "RequiresMountsFor");
    _dbusProxyDelegate->deregisterSignalCallback("RequiresMountsFor", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendDocumentationRegister(DocumentationCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Documentation, "Documentation", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Documentation", &cb, act);
    return act;
}

bool UnitProxy::sendDocumentationDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Documentation", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Documentation", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendDocumentationGet(DocumentationCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_Documentation, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Documentation", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Documentation", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::std::string >& UnitProxy::getDocumentation() const {
    return _documentation.get().getDocumentation();
}

bool UnitProxy::hasDocumentation() const {
    return _documentation.hasValue();
}

void UnitProxy::sendDocumentationDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Documentation");
    _dbusProxyDelegate->deregisterSignalCallback("Documentation", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendDescriptionRegister(DescriptionCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Description, "Description", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Description", &cb, act);
    return act;
}

bool UnitProxy::sendDescriptionDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Description", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Description", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendDescriptionGet(DescriptionCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_Description, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Description", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Description", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& UnitProxy::getDescription() const {
    return _description.get().getDescription();
}

bool UnitProxy::hasDescription() const {
    return _description.hasValue();
}

void UnitProxy::sendDescriptionDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Description");
    _dbusProxyDelegate->deregisterSignalCallback("Description", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendLoadStateRegister(LoadStateCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_LoadState, "LoadState", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "LoadState", &cb, act);
    return act;
}

bool UnitProxy::sendLoadStateDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("LoadState", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "LoadState", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendLoadStateGet(LoadStateCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_LoadState, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "LoadState", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("LoadState", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& UnitProxy::getLoadState() const {
    return _loadState.get().getLoadState();
}

bool UnitProxy::hasLoadState() const {
    return _loadState.hasValue();
}

void UnitProxy::sendLoadStateDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "LoadState");
    _dbusProxyDelegate->deregisterSignalCallback("LoadState", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendActiveStateRegister(ActiveStateCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ActiveState, "ActiveState", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ActiveState", &cb, act);
    return act;
}

bool UnitProxy::sendActiveStateDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ActiveState", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ActiveState", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendActiveStateGet(ActiveStateCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_ActiveState, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ActiveState", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ActiveState", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& UnitProxy::getActiveState() const {
    return _activeState.get().getActiveState();
}

bool UnitProxy::hasActiveState() const {
    return _activeState.hasValue();
}

void UnitProxy::sendActiveStateDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ActiveState");
    _dbusProxyDelegate->deregisterSignalCallback("ActiveState", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendSubStateRegister(SubStateCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_SubState, "SubState", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SubState", &cb, act);
    return act;
}

bool UnitProxy::sendSubStateDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SubState", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SubState", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendSubStateGet(SubStateCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_SubState, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "SubState", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("SubState", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& UnitProxy::getSubState() const {
    return _subState.get().getSubState();
}

bool UnitProxy::hasSubState() const {
    return _subState.hasValue();
}

void UnitProxy::sendSubStateDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SubState");
    _dbusProxyDelegate->deregisterSignalCallback("SubState", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendFragmentPathRegister(FragmentPathCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_FragmentPath, "FragmentPath", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "FragmentPath", &cb, act);
    return act;
}

bool UnitProxy::sendFragmentPathDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("FragmentPath", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "FragmentPath", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendFragmentPathGet(FragmentPathCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_FragmentPath, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "FragmentPath", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("FragmentPath", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& UnitProxy::getFragmentPath() const {
    return _fragmentPath.get().getFragmentPath();
}

bool UnitProxy::hasFragmentPath() const {
    return _fragmentPath.hasValue();
}

void UnitProxy::sendFragmentPathDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "FragmentPath");
    _dbusProxyDelegate->deregisterSignalCallback("FragmentPath", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendSourcePathRegister(SourcePathCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_SourcePath, "SourcePath", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SourcePath", &cb, act);
    return act;
}

bool UnitProxy::sendSourcePathDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SourcePath", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SourcePath", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendSourcePathGet(SourcePathCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_SourcePath, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "SourcePath", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("SourcePath", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& UnitProxy::getSourcePath() const {
    return _sourcePath.get().getSourcePath();
}

bool UnitProxy::hasSourcePath() const {
    return _sourcePath.hasValue();
}

void UnitProxy::sendSourcePathDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SourcePath");
    _dbusProxyDelegate->deregisterSignalCallback("SourcePath", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendDropInPathsRegister(DropInPathsCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_DropInPaths, "DropInPaths", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "DropInPaths", &cb, act);
    return act;
}

bool UnitProxy::sendDropInPathsDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("DropInPaths", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "DropInPaths", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendDropInPathsGet(DropInPathsCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_DropInPaths, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "DropInPaths", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("DropInPaths", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::std::string >& UnitProxy::getDropInPaths() const {
    return _dropInPaths.get().getDropInPaths();
}

bool UnitProxy::hasDropInPaths() const {
    return _dropInPaths.hasValue();
}

void UnitProxy::sendDropInPathsDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "DropInPaths");
    _dbusProxyDelegate->deregisterSignalCallback("DropInPaths", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendUnitFileStateRegister(UnitFileStateCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_UnitFileState, "UnitFileState", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "UnitFileState", &cb, act);
    return act;
}

bool UnitProxy::sendUnitFileStateDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("UnitFileState", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "UnitFileState", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendUnitFileStateGet(UnitFileStateCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_UnitFileState, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "UnitFileState", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("UnitFileState", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& UnitProxy::getUnitFileState() const {
    return _unitFileState.get().getUnitFileState();
}

bool UnitProxy::hasUnitFileState() const {
    return _unitFileState.hasValue();
}

void UnitProxy::sendUnitFileStateDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "UnitFileState");
    _dbusProxyDelegate->deregisterSignalCallback("UnitFileState", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendUnitFilePresetRegister(UnitFilePresetCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_UnitFilePreset, "UnitFilePreset", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "UnitFilePreset", &cb, act);
    return act;
}

bool UnitProxy::sendUnitFilePresetDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("UnitFilePreset", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "UnitFilePreset", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendUnitFilePresetGet(UnitFilePresetCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_UnitFilePreset, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "UnitFilePreset", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("UnitFilePreset", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& UnitProxy::getUnitFilePreset() const {
    return _unitFilePreset.get().getUnitFilePreset();
}

bool UnitProxy::hasUnitFilePreset() const {
    return _unitFilePreset.hasValue();
}

void UnitProxy::sendUnitFilePresetDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "UnitFilePreset");
    _dbusProxyDelegate->deregisterSignalCallback("UnitFilePreset", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendInactiveExitTimestampRegister(InactiveExitTimestampCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_InactiveExitTimestamp, "InactiveExitTimestamp", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "InactiveExitTimestamp", &cb, act);
    return act;
}

bool UnitProxy::sendInactiveExitTimestampDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("InactiveExitTimestamp", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "InactiveExitTimestamp", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendInactiveExitTimestampGet(InactiveExitTimestampCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_InactiveExitTimestamp, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "InactiveExitTimestamp", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("InactiveExitTimestamp", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 UnitProxy::getInactiveExitTimestamp() const {
    return _inactiveExitTimestamp.get().getInactiveExitTimestamp();
}

bool UnitProxy::hasInactiveExitTimestamp() const {
    return _inactiveExitTimestamp.hasValue();
}

void UnitProxy::sendInactiveExitTimestampDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "InactiveExitTimestamp");
    _dbusProxyDelegate->deregisterSignalCallback("InactiveExitTimestamp", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendInactiveExitTimestampMonotonicRegister(InactiveExitTimestampMonotonicCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_InactiveExitTimestampMonotonic, "InactiveExitTimestampMonotonic", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "InactiveExitTimestampMonotonic", &cb, act);
    return act;
}

bool UnitProxy::sendInactiveExitTimestampMonotonicDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("InactiveExitTimestampMonotonic", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "InactiveExitTimestampMonotonic", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendInactiveExitTimestampMonotonicGet(InactiveExitTimestampMonotonicCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_InactiveExitTimestampMonotonic, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "InactiveExitTimestampMonotonic", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("InactiveExitTimestampMonotonic", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 UnitProxy::getInactiveExitTimestampMonotonic() const {
    return _inactiveExitTimestampMonotonic.get().getInactiveExitTimestampMonotonic();
}

bool UnitProxy::hasInactiveExitTimestampMonotonic() const {
    return _inactiveExitTimestampMonotonic.hasValue();
}

void UnitProxy::sendInactiveExitTimestampMonotonicDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "InactiveExitTimestampMonotonic");
    _dbusProxyDelegate->deregisterSignalCallback("InactiveExitTimestampMonotonic", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendActiveEnterTimestampRegister(ActiveEnterTimestampCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ActiveEnterTimestamp, "ActiveEnterTimestamp", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ActiveEnterTimestamp", &cb, act);
    return act;
}

bool UnitProxy::sendActiveEnterTimestampDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ActiveEnterTimestamp", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ActiveEnterTimestamp", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendActiveEnterTimestampGet(ActiveEnterTimestampCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_ActiveEnterTimestamp, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ActiveEnterTimestamp", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ActiveEnterTimestamp", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 UnitProxy::getActiveEnterTimestamp() const {
    return _activeEnterTimestamp.get().getActiveEnterTimestamp();
}

bool UnitProxy::hasActiveEnterTimestamp() const {
    return _activeEnterTimestamp.hasValue();
}

void UnitProxy::sendActiveEnterTimestampDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ActiveEnterTimestamp");
    _dbusProxyDelegate->deregisterSignalCallback("ActiveEnterTimestamp", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendActiveEnterTimestampMonotonicRegister(ActiveEnterTimestampMonotonicCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ActiveEnterTimestampMonotonic, "ActiveEnterTimestampMonotonic", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ActiveEnterTimestampMonotonic", &cb, act);
    return act;
}

bool UnitProxy::sendActiveEnterTimestampMonotonicDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ActiveEnterTimestampMonotonic", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ActiveEnterTimestampMonotonic", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendActiveEnterTimestampMonotonicGet(ActiveEnterTimestampMonotonicCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_ActiveEnterTimestampMonotonic, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ActiveEnterTimestampMonotonic", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ActiveEnterTimestampMonotonic", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 UnitProxy::getActiveEnterTimestampMonotonic() const {
    return _activeEnterTimestampMonotonic.get().getActiveEnterTimestampMonotonic();
}

bool UnitProxy::hasActiveEnterTimestampMonotonic() const {
    return _activeEnterTimestampMonotonic.hasValue();
}

void UnitProxy::sendActiveEnterTimestampMonotonicDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ActiveEnterTimestampMonotonic");
    _dbusProxyDelegate->deregisterSignalCallback("ActiveEnterTimestampMonotonic", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendActiveExitTimestampRegister(ActiveExitTimestampCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ActiveExitTimestamp, "ActiveExitTimestamp", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ActiveExitTimestamp", &cb, act);
    return act;
}

bool UnitProxy::sendActiveExitTimestampDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ActiveExitTimestamp", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ActiveExitTimestamp", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendActiveExitTimestampGet(ActiveExitTimestampCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_ActiveExitTimestamp, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ActiveExitTimestamp", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ActiveExitTimestamp", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 UnitProxy::getActiveExitTimestamp() const {
    return _activeExitTimestamp.get().getActiveExitTimestamp();
}

bool UnitProxy::hasActiveExitTimestamp() const {
    return _activeExitTimestamp.hasValue();
}

void UnitProxy::sendActiveExitTimestampDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ActiveExitTimestamp");
    _dbusProxyDelegate->deregisterSignalCallback("ActiveExitTimestamp", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendActiveExitTimestampMonotonicRegister(ActiveExitTimestampMonotonicCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ActiveExitTimestampMonotonic, "ActiveExitTimestampMonotonic", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ActiveExitTimestampMonotonic", &cb, act);
    return act;
}

bool UnitProxy::sendActiveExitTimestampMonotonicDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ActiveExitTimestampMonotonic", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ActiveExitTimestampMonotonic", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendActiveExitTimestampMonotonicGet(ActiveExitTimestampMonotonicCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_ActiveExitTimestampMonotonic, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ActiveExitTimestampMonotonic", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ActiveExitTimestampMonotonic", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 UnitProxy::getActiveExitTimestampMonotonic() const {
    return _activeExitTimestampMonotonic.get().getActiveExitTimestampMonotonic();
}

bool UnitProxy::hasActiveExitTimestampMonotonic() const {
    return _activeExitTimestampMonotonic.hasValue();
}

void UnitProxy::sendActiveExitTimestampMonotonicDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ActiveExitTimestampMonotonic");
    _dbusProxyDelegate->deregisterSignalCallback("ActiveExitTimestampMonotonic", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendInactiveEnterTimestampRegister(InactiveEnterTimestampCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_InactiveEnterTimestamp, "InactiveEnterTimestamp", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "InactiveEnterTimestamp", &cb, act);
    return act;
}

bool UnitProxy::sendInactiveEnterTimestampDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("InactiveEnterTimestamp", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "InactiveEnterTimestamp", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendInactiveEnterTimestampGet(InactiveEnterTimestampCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_InactiveEnterTimestamp, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "InactiveEnterTimestamp", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("InactiveEnterTimestamp", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 UnitProxy::getInactiveEnterTimestamp() const {
    return _inactiveEnterTimestamp.get().getInactiveEnterTimestamp();
}

bool UnitProxy::hasInactiveEnterTimestamp() const {
    return _inactiveEnterTimestamp.hasValue();
}

void UnitProxy::sendInactiveEnterTimestampDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "InactiveEnterTimestamp");
    _dbusProxyDelegate->deregisterSignalCallback("InactiveEnterTimestamp", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendInactiveEnterTimestampMonotonicRegister(InactiveEnterTimestampMonotonicCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_InactiveEnterTimestampMonotonic, "InactiveEnterTimestampMonotonic", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "InactiveEnterTimestampMonotonic", &cb, act);
    return act;
}

bool UnitProxy::sendInactiveEnterTimestampMonotonicDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("InactiveEnterTimestampMonotonic", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "InactiveEnterTimestampMonotonic", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendInactiveEnterTimestampMonotonicGet(InactiveEnterTimestampMonotonicCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_InactiveEnterTimestampMonotonic, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "InactiveEnterTimestampMonotonic", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("InactiveEnterTimestampMonotonic", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 UnitProxy::getInactiveEnterTimestampMonotonic() const {
    return _inactiveEnterTimestampMonotonic.get().getInactiveEnterTimestampMonotonic();
}

bool UnitProxy::hasInactiveEnterTimestampMonotonic() const {
    return _inactiveEnterTimestampMonotonic.hasValue();
}

void UnitProxy::sendInactiveEnterTimestampMonotonicDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "InactiveEnterTimestampMonotonic");
    _dbusProxyDelegate->deregisterSignalCallback("InactiveEnterTimestampMonotonic", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendCanStartRegister(CanStartCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_CanStart, "CanStart", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "CanStart", &cb, act);
    return act;
}

bool UnitProxy::sendCanStartDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("CanStart", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "CanStart", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendCanStartGet(CanStartCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_CanStart, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "CanStart", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("CanStart", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool UnitProxy::getCanStart() const {
    return _canStart.get().getCanStart();
}

bool UnitProxy::hasCanStart() const {
    return _canStart.hasValue();
}

void UnitProxy::sendCanStartDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "CanStart");
    _dbusProxyDelegate->deregisterSignalCallback("CanStart", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendCanStopRegister(CanStopCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_CanStop, "CanStop", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "CanStop", &cb, act);
    return act;
}

bool UnitProxy::sendCanStopDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("CanStop", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "CanStop", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendCanStopGet(CanStopCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_CanStop, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "CanStop", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("CanStop", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool UnitProxy::getCanStop() const {
    return _canStop.get().getCanStop();
}

bool UnitProxy::hasCanStop() const {
    return _canStop.hasValue();
}

void UnitProxy::sendCanStopDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "CanStop");
    _dbusProxyDelegate->deregisterSignalCallback("CanStop", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendCanReloadRegister(CanReloadCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_CanReload, "CanReload", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "CanReload", &cb, act);
    return act;
}

bool UnitProxy::sendCanReloadDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("CanReload", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "CanReload", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendCanReloadGet(CanReloadCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_CanReload, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "CanReload", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("CanReload", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool UnitProxy::getCanReload() const {
    return _canReload.get().getCanReload();
}

bool UnitProxy::hasCanReload() const {
    return _canReload.hasValue();
}

void UnitProxy::sendCanReloadDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "CanReload");
    _dbusProxyDelegate->deregisterSignalCallback("CanReload", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendCanIsolateRegister(CanIsolateCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_CanIsolate, "CanIsolate", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "CanIsolate", &cb, act);
    return act;
}

bool UnitProxy::sendCanIsolateDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("CanIsolate", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "CanIsolate", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendCanIsolateGet(CanIsolateCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_CanIsolate, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "CanIsolate", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("CanIsolate", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool UnitProxy::getCanIsolate() const {
    return _canIsolate.get().getCanIsolate();
}

bool UnitProxy::hasCanIsolate() const {
    return _canIsolate.hasValue();
}

void UnitProxy::sendCanIsolateDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "CanIsolate");
    _dbusProxyDelegate->deregisterSignalCallback("CanIsolate", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendJobRegister(JobCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Job, "Job", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Job", &cb, act);
    return act;
}

bool UnitProxy::sendJobDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Job", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Job", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendJobGet(JobCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_Job, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Job", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Job", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const job& UnitProxy::getJob() const {
    return _job.get().getJob();
}

bool UnitProxy::hasJob() const {
    return _job.hasValue();
}

void UnitProxy::sendJobDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Job");
    _dbusProxyDelegate->deregisterSignalCallback("Job", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendStopWhenUnneededRegister(StopWhenUnneededCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_StopWhenUnneeded, "StopWhenUnneeded", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "StopWhenUnneeded", &cb, act);
    return act;
}

bool UnitProxy::sendStopWhenUnneededDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("StopWhenUnneeded", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "StopWhenUnneeded", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendStopWhenUnneededGet(StopWhenUnneededCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_StopWhenUnneeded, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "StopWhenUnneeded", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("StopWhenUnneeded", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool UnitProxy::getStopWhenUnneeded() const {
    return _stopWhenUnneeded.get().getStopWhenUnneeded();
}

bool UnitProxy::hasStopWhenUnneeded() const {
    return _stopWhenUnneeded.hasValue();
}

void UnitProxy::sendStopWhenUnneededDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "StopWhenUnneeded");
    _dbusProxyDelegate->deregisterSignalCallback("StopWhenUnneeded", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendRefuseManualStartRegister(RefuseManualStartCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_RefuseManualStart, "RefuseManualStart", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "RefuseManualStart", &cb, act);
    return act;
}

bool UnitProxy::sendRefuseManualStartDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("RefuseManualStart", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "RefuseManualStart", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendRefuseManualStartGet(RefuseManualStartCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_RefuseManualStart, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "RefuseManualStart", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("RefuseManualStart", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool UnitProxy::getRefuseManualStart() const {
    return _refuseManualStart.get().getRefuseManualStart();
}

bool UnitProxy::hasRefuseManualStart() const {
    return _refuseManualStart.hasValue();
}

void UnitProxy::sendRefuseManualStartDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "RefuseManualStart");
    _dbusProxyDelegate->deregisterSignalCallback("RefuseManualStart", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendRefuseManualStopRegister(RefuseManualStopCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_RefuseManualStop, "RefuseManualStop", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "RefuseManualStop", &cb, act);
    return act;
}

bool UnitProxy::sendRefuseManualStopDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("RefuseManualStop", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "RefuseManualStop", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendRefuseManualStopGet(RefuseManualStopCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_RefuseManualStop, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "RefuseManualStop", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("RefuseManualStop", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool UnitProxy::getRefuseManualStop() const {
    return _refuseManualStop.get().getRefuseManualStop();
}

bool UnitProxy::hasRefuseManualStop() const {
    return _refuseManualStop.hasValue();
}

void UnitProxy::sendRefuseManualStopDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "RefuseManualStop");
    _dbusProxyDelegate->deregisterSignalCallback("RefuseManualStop", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendAllowIsolateRegister(AllowIsolateCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_AllowIsolate, "AllowIsolate", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "AllowIsolate", &cb, act);
    return act;
}

bool UnitProxy::sendAllowIsolateDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("AllowIsolate", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "AllowIsolate", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendAllowIsolateGet(AllowIsolateCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_AllowIsolate, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "AllowIsolate", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("AllowIsolate", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool UnitProxy::getAllowIsolate() const {
    return _allowIsolate.get().getAllowIsolate();
}

bool UnitProxy::hasAllowIsolate() const {
    return _allowIsolate.hasValue();
}

void UnitProxy::sendAllowIsolateDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "AllowIsolate");
    _dbusProxyDelegate->deregisterSignalCallback("AllowIsolate", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendDefaultDependenciesRegister(DefaultDependenciesCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_DefaultDependencies, "DefaultDependencies", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "DefaultDependencies", &cb, act);
    return act;
}

bool UnitProxy::sendDefaultDependenciesDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("DefaultDependencies", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "DefaultDependencies", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendDefaultDependenciesGet(DefaultDependenciesCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_DefaultDependencies, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "DefaultDependencies", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("DefaultDependencies", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool UnitProxy::getDefaultDependencies() const {
    return _defaultDependencies.get().getDefaultDependencies();
}

bool UnitProxy::hasDefaultDependencies() const {
    return _defaultDependencies.hasValue();
}

void UnitProxy::sendDefaultDependenciesDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "DefaultDependencies");
    _dbusProxyDelegate->deregisterSignalCallback("DefaultDependencies", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendOnFailureJobModeRegister(OnFailureJobModeCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_OnFailureJobMode, "OnFailureJobMode", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "OnFailureJobMode", &cb, act);
    return act;
}

bool UnitProxy::sendOnFailureJobModeDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("OnFailureJobMode", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "OnFailureJobMode", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendOnFailureJobModeGet(OnFailureJobModeCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_OnFailureJobMode, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "OnFailureJobMode", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("OnFailureJobMode", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& UnitProxy::getOnFailureJobMode() const {
    return _onFailureJobMode.get().getOnFailureJobMode();
}

bool UnitProxy::hasOnFailureJobMode() const {
    return _onFailureJobMode.hasValue();
}

void UnitProxy::sendOnFailureJobModeDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "OnFailureJobMode");
    _dbusProxyDelegate->deregisterSignalCallback("OnFailureJobMode", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendIgnoreOnIsolateRegister(IgnoreOnIsolateCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_IgnoreOnIsolate, "IgnoreOnIsolate", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "IgnoreOnIsolate", &cb, act);
    return act;
}

bool UnitProxy::sendIgnoreOnIsolateDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("IgnoreOnIsolate", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "IgnoreOnIsolate", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendIgnoreOnIsolateGet(IgnoreOnIsolateCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_IgnoreOnIsolate, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "IgnoreOnIsolate", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("IgnoreOnIsolate", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool UnitProxy::getIgnoreOnIsolate() const {
    return _ignoreOnIsolate.get().getIgnoreOnIsolate();
}

bool UnitProxy::hasIgnoreOnIsolate() const {
    return _ignoreOnIsolate.hasValue();
}

void UnitProxy::sendIgnoreOnIsolateDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "IgnoreOnIsolate");
    _dbusProxyDelegate->deregisterSignalCallback("IgnoreOnIsolate", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendIgnoreOnSnapshotRegister(IgnoreOnSnapshotCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_IgnoreOnSnapshot, "IgnoreOnSnapshot", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "IgnoreOnSnapshot", &cb, act);
    return act;
}

bool UnitProxy::sendIgnoreOnSnapshotDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("IgnoreOnSnapshot", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "IgnoreOnSnapshot", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendIgnoreOnSnapshotGet(IgnoreOnSnapshotCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_IgnoreOnSnapshot, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "IgnoreOnSnapshot", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("IgnoreOnSnapshot", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool UnitProxy::getIgnoreOnSnapshot() const {
    return _ignoreOnSnapshot.get().getIgnoreOnSnapshot();
}

bool UnitProxy::hasIgnoreOnSnapshot() const {
    return _ignoreOnSnapshot.hasValue();
}

void UnitProxy::sendIgnoreOnSnapshotDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "IgnoreOnSnapshot");
    _dbusProxyDelegate->deregisterSignalCallback("IgnoreOnSnapshot", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendNeedDaemonReloadRegister(NeedDaemonReloadCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_NeedDaemonReload, "NeedDaemonReload", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "NeedDaemonReload", &cb, act);
    return act;
}

bool UnitProxy::sendNeedDaemonReloadDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("NeedDaemonReload", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "NeedDaemonReload", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendNeedDaemonReloadGet(NeedDaemonReloadCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_NeedDaemonReload, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "NeedDaemonReload", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("NeedDaemonReload", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool UnitProxy::getNeedDaemonReload() const {
    return _needDaemonReload.get().getNeedDaemonReload();
}

bool UnitProxy::hasNeedDaemonReload() const {
    return _needDaemonReload.hasValue();
}

void UnitProxy::sendNeedDaemonReloadDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "NeedDaemonReload");
    _dbusProxyDelegate->deregisterSignalCallback("NeedDaemonReload", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendJobTimeoutUSecRegister(JobTimeoutUSecCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_JobTimeoutUSec, "JobTimeoutUSec", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "JobTimeoutUSec", &cb, act);
    return act;
}

bool UnitProxy::sendJobTimeoutUSecDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("JobTimeoutUSec", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "JobTimeoutUSec", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendJobTimeoutUSecGet(JobTimeoutUSecCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_JobTimeoutUSec, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "JobTimeoutUSec", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("JobTimeoutUSec", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 UnitProxy::getJobTimeoutUSec() const {
    return _jobTimeoutUSec.get().getJobTimeoutUSec();
}

bool UnitProxy::hasJobTimeoutUSec() const {
    return _jobTimeoutUSec.hasValue();
}

void UnitProxy::sendJobTimeoutUSecDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "JobTimeoutUSec");
    _dbusProxyDelegate->deregisterSignalCallback("JobTimeoutUSec", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendJobTimeoutActionRegister(JobTimeoutActionCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_JobTimeoutAction, "JobTimeoutAction", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "JobTimeoutAction", &cb, act);
    return act;
}

bool UnitProxy::sendJobTimeoutActionDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("JobTimeoutAction", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "JobTimeoutAction", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendJobTimeoutActionGet(JobTimeoutActionCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_JobTimeoutAction, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "JobTimeoutAction", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("JobTimeoutAction", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& UnitProxy::getJobTimeoutAction() const {
    return _jobTimeoutAction.get().getJobTimeoutAction();
}

bool UnitProxy::hasJobTimeoutAction() const {
    return _jobTimeoutAction.hasValue();
}

void UnitProxy::sendJobTimeoutActionDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "JobTimeoutAction");
    _dbusProxyDelegate->deregisterSignalCallback("JobTimeoutAction", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendJobTimeoutRebootArgumentRegister(JobTimeoutRebootArgumentCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_JobTimeoutRebootArgument, "JobTimeoutRebootArgument", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "JobTimeoutRebootArgument", &cb, act);
    return act;
}

bool UnitProxy::sendJobTimeoutRebootArgumentDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("JobTimeoutRebootArgument", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "JobTimeoutRebootArgument", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendJobTimeoutRebootArgumentGet(JobTimeoutRebootArgumentCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_JobTimeoutRebootArgument, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "JobTimeoutRebootArgument", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("JobTimeoutRebootArgument", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& UnitProxy::getJobTimeoutRebootArgument() const {
    return _jobTimeoutRebootArgument.get().getJobTimeoutRebootArgument();
}

bool UnitProxy::hasJobTimeoutRebootArgument() const {
    return _jobTimeoutRebootArgument.hasValue();
}

void UnitProxy::sendJobTimeoutRebootArgumentDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "JobTimeoutRebootArgument");
    _dbusProxyDelegate->deregisterSignalCallback("JobTimeoutRebootArgument", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendConditionResultRegister(ConditionResultCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ConditionResult, "ConditionResult", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ConditionResult", &cb, act);
    return act;
}

bool UnitProxy::sendConditionResultDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ConditionResult", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ConditionResult", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendConditionResultGet(ConditionResultCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_ConditionResult, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ConditionResult", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ConditionResult", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool UnitProxy::getConditionResult() const {
    return _conditionResult.get().getConditionResult();
}

bool UnitProxy::hasConditionResult() const {
    return _conditionResult.hasValue();
}

void UnitProxy::sendConditionResultDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ConditionResult");
    _dbusProxyDelegate->deregisterSignalCallback("ConditionResult", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendAssertResultRegister(AssertResultCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_AssertResult, "AssertResult", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "AssertResult", &cb, act);
    return act;
}

bool UnitProxy::sendAssertResultDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("AssertResult", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "AssertResult", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendAssertResultGet(AssertResultCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_AssertResult, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "AssertResult", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("AssertResult", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool UnitProxy::getAssertResult() const {
    return _assertResult.get().getAssertResult();
}

bool UnitProxy::hasAssertResult() const {
    return _assertResult.hasValue();
}

void UnitProxy::sendAssertResultDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "AssertResult");
    _dbusProxyDelegate->deregisterSignalCallback("AssertResult", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendConditionTimestampRegister(ConditionTimestampCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ConditionTimestamp, "ConditionTimestamp", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ConditionTimestamp", &cb, act);
    return act;
}

bool UnitProxy::sendConditionTimestampDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ConditionTimestamp", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ConditionTimestamp", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendConditionTimestampGet(ConditionTimestampCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_ConditionTimestamp, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ConditionTimestamp", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ConditionTimestamp", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 UnitProxy::getConditionTimestamp() const {
    return _conditionTimestamp.get().getConditionTimestamp();
}

bool UnitProxy::hasConditionTimestamp() const {
    return _conditionTimestamp.hasValue();
}

void UnitProxy::sendConditionTimestampDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ConditionTimestamp");
    _dbusProxyDelegate->deregisterSignalCallback("ConditionTimestamp", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendConditionTimestampMonotonicRegister(ConditionTimestampMonotonicCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ConditionTimestampMonotonic, "ConditionTimestampMonotonic", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ConditionTimestampMonotonic", &cb, act);
    return act;
}

bool UnitProxy::sendConditionTimestampMonotonicDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ConditionTimestampMonotonic", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ConditionTimestampMonotonic", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendConditionTimestampMonotonicGet(ConditionTimestampMonotonicCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_ConditionTimestampMonotonic, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ConditionTimestampMonotonic", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ConditionTimestampMonotonic", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 UnitProxy::getConditionTimestampMonotonic() const {
    return _conditionTimestampMonotonic.get().getConditionTimestampMonotonic();
}

bool UnitProxy::hasConditionTimestampMonotonic() const {
    return _conditionTimestampMonotonic.hasValue();
}

void UnitProxy::sendConditionTimestampMonotonicDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ConditionTimestampMonotonic");
    _dbusProxyDelegate->deregisterSignalCallback("ConditionTimestampMonotonic", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendAssertTimestampRegister(AssertTimestampCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_AssertTimestamp, "AssertTimestamp", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "AssertTimestamp", &cb, act);
    return act;
}

bool UnitProxy::sendAssertTimestampDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("AssertTimestamp", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "AssertTimestamp", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendAssertTimestampGet(AssertTimestampCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_AssertTimestamp, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "AssertTimestamp", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("AssertTimestamp", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 UnitProxy::getAssertTimestamp() const {
    return _assertTimestamp.get().getAssertTimestamp();
}

bool UnitProxy::hasAssertTimestamp() const {
    return _assertTimestamp.hasValue();
}

void UnitProxy::sendAssertTimestampDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "AssertTimestamp");
    _dbusProxyDelegate->deregisterSignalCallback("AssertTimestamp", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendAssertTimestampMonotonicRegister(AssertTimestampMonotonicCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_AssertTimestampMonotonic, "AssertTimestampMonotonic", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "AssertTimestampMonotonic", &cb, act);
    return act;
}

bool UnitProxy::sendAssertTimestampMonotonicDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("AssertTimestampMonotonic", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "AssertTimestampMonotonic", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendAssertTimestampMonotonicGet(AssertTimestampMonotonicCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_AssertTimestampMonotonic, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "AssertTimestampMonotonic", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("AssertTimestampMonotonic", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 UnitProxy::getAssertTimestampMonotonic() const {
    return _assertTimestampMonotonic.get().getAssertTimestampMonotonic();
}

bool UnitProxy::hasAssertTimestampMonotonic() const {
    return _assertTimestampMonotonic.hasValue();
}

void UnitProxy::sendAssertTimestampMonotonicDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "AssertTimestampMonotonic");
    _dbusProxyDelegate->deregisterSignalCallback("AssertTimestampMonotonic", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendConditionsRegister(ConditionsCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Conditions, "Conditions", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Conditions", &cb, act);
    return act;
}

bool UnitProxy::sendConditionsDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Conditions", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Conditions", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendConditionsGet(ConditionsCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_Conditions, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Conditions", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Conditions", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< condition >& UnitProxy::getConditions() const {
    return _conditions.get().getConditions();
}

bool UnitProxy::hasConditions() const {
    return _conditions.hasValue();
}

void UnitProxy::sendConditionsDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Conditions");
    _dbusProxyDelegate->deregisterSignalCallback("Conditions", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendAssertsRegister(AssertsCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Asserts, "Asserts", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Asserts", &cb, act);
    return act;
}

bool UnitProxy::sendAssertsDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Asserts", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Asserts", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendAssertsGet(AssertsCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_Asserts, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Asserts", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Asserts", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< condition >& UnitProxy::getAsserts() const {
    return _asserts.get().getAsserts();
}

bool UnitProxy::hasAsserts() const {
    return _asserts.hasValue();
}

void UnitProxy::sendAssertsDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Asserts");
    _dbusProxyDelegate->deregisterSignalCallback("Asserts", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendLoadErrorRegister(LoadErrorCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_LoadError, "LoadError", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "LoadError", &cb, act);
    return act;
}

bool UnitProxy::sendLoadErrorDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("LoadError", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "LoadError", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendLoadErrorGet(LoadErrorCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_LoadError, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "LoadError", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("LoadError", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const loadError& UnitProxy::getLoadError() const {
    return _loadError.get().getLoadError();
}

bool UnitProxy::hasLoadError() const {
    return _loadError.hasValue();
}

void UnitProxy::sendLoadErrorDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "LoadError");
    _dbusProxyDelegate->deregisterSignalCallback("LoadError", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendTransientRegister(TransientCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Transient, "Transient", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Transient", &cb, act);
    return act;
}

bool UnitProxy::sendTransientDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Transient", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Transient", act, static_cast<int>(rv));
    return rv;
}

act_t UnitProxy::sendTransientGet(TransientCallbackIF& cb) {
    UnitProxyCallback* callback = new UnitProxyCallback(ID_Transient, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Transient", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Transient", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool UnitProxy::getTransient() const {
    return _transient.get().getTransient();
}

bool UnitProxy::hasTransient() const {
    return _transient.hasValue();
}

void UnitProxy::sendTransientDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Transient");
    _dbusProxyDelegate->deregisterSignalCallback("Transient", 0, _dbusDaemonProxy.get(), true);
}

act_t UnitProxy::sendStartRequest(StartCallbackIF& cb, const ::std::string& mode) const {
    StartRequest* payload = new StartRequest();
    CHECK_ALLOCATION(payload);
    payload->setMode(mode);
    DBUS_MESSAGE_CALL(dbusMessage, "Start", StartRequest, payload, true)
    act_t act = addMethodCallback(ID_Start, dbusMessage.getUniqueSerial(), "Start", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Start", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t UnitProxy::sendStopRequest(StopCallbackIF& cb, const ::std::string& mode) const {
    StopRequest* payload = new StopRequest();
    CHECK_ALLOCATION(payload);
    payload->setMode(mode);
    DBUS_MESSAGE_CALL(dbusMessage, "Stop", StopRequest, payload, true)
    act_t act = addMethodCallback(ID_Stop, dbusMessage.getUniqueSerial(), "Stop", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Stop", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t UnitProxy::sendReloadRequest(ReloadCallbackIF& cb, const ::std::string& mode) const {
    ReloadRequest* payload = new ReloadRequest();
    CHECK_ALLOCATION(payload);
    payload->setMode(mode);
    DBUS_MESSAGE_CALL(dbusMessage, "Reload", ReloadRequest, payload, true)
    act_t act = addMethodCallback(ID_Reload, dbusMessage.getUniqueSerial(), "Reload", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Reload", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t UnitProxy::sendRestartRequest(RestartCallbackIF& cb, const ::std::string& mode) const {
    RestartRequest* payload = new RestartRequest();
    CHECK_ALLOCATION(payload);
    payload->setMode(mode);
    DBUS_MESSAGE_CALL(dbusMessage, "Restart", RestartRequest, payload, true)
    act_t act = addMethodCallback(ID_Restart, dbusMessage.getUniqueSerial(), "Restart", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Restart", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t UnitProxy::sendTryRestartRequest(TryRestartCallbackIF& cb, const ::std::string& mode) const {
    TryRestartRequest* payload = new TryRestartRequest();
    CHECK_ALLOCATION(payload);
    payload->setMode(mode);
    DBUS_MESSAGE_CALL(dbusMessage, "TryRestart", TryRestartRequest, payload, true)
    act_t act = addMethodCallback(ID_TryRestart, dbusMessage.getUniqueSerial(), "TryRestart", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "TryRestart", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t UnitProxy::sendReloadOrRestartRequest(ReloadOrRestartCallbackIF& cb, const ::std::string& mode) const {
    ReloadOrRestartRequest* payload = new ReloadOrRestartRequest();
    CHECK_ALLOCATION(payload);
    payload->setMode(mode);
    DBUS_MESSAGE_CALL(dbusMessage, "ReloadOrRestart", ReloadOrRestartRequest, payload, true)
    act_t act = addMethodCallback(ID_ReloadOrRestart, dbusMessage.getUniqueSerial(), "ReloadOrRestart", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ReloadOrRestart", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t UnitProxy::sendReloadOrTryRestartRequest(ReloadOrTryRestartCallbackIF& cb, const ::std::string& mode) const {
    ReloadOrTryRestartRequest* payload = new ReloadOrTryRestartRequest();
    CHECK_ALLOCATION(payload);
    payload->setMode(mode);
    DBUS_MESSAGE_CALL(dbusMessage, "ReloadOrTryRestart", ReloadOrTryRestartRequest, payload, true)
    act_t act = addMethodCallback(ID_ReloadOrTryRestart, dbusMessage.getUniqueSerial(), "ReloadOrTryRestart", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ReloadOrTryRestart", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t UnitProxy::sendKillRequest(KillCallbackIF& cb, const ::std::string& mode) const {
    KillRequest* payload = new KillRequest();
    CHECK_ALLOCATION(payload);
    payload->setMode(mode);
    DBUS_MESSAGE_CALL(dbusMessage, "Kill", KillRequest, payload, true)
    act_t act = addMethodCallback(ID_Kill, dbusMessage.getUniqueSerial(), "Kill", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Kill", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t UnitProxy::sendResetFailedRequest(ResetFailedCallbackIF& cb) const {
    ResetFailedRequest* payload = new ResetFailedRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "ResetFailed", ResetFailedRequest, payload, true)
    act_t act = addMethodCallback(ID_ResetFailed, dbusMessage.getUniqueSerial(), "ResetFailed", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ResetFailed", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t UnitProxy::sendSetPropertiesRequest(SetPropertiesCallbackIF& cb, bool runtime, const ::std::vector< property >& properties) const {
    SetPropertiesRequest* payload = new SetPropertiesRequest();
    CHECK_ALLOCATION(payload);
    payload->setRuntime(runtime);
    payload->setProperties(properties);
    DBUS_MESSAGE_CALL(dbusMessage, "SetProperties", SetPropertiesRequest, payload, true)
    act_t act = addMethodCallback(ID_SetProperties, dbusMessage.getUniqueSerial(), "SetProperties", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetProperties", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace Unit
} // namespace systemd1
} // namespace freedesktop
} // namespace org
