/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/dbus/DBusAssert.h"
#include "org/freedesktop/systemd1/Unit.h"
#include "org/freedesktop/systemd1/UnitDBus.h"
#include <dbus/dbus.h>
#include <string>
#include <vector>

static ::asf::core::Logger& _logger =  ::asf::core::Logger::_systemLogger;


// D-Bus serialize and deserialize functions of job

void serializeDBus (const ::org::freedesktop::systemd1::Unit::job& in, DBusMessageIter* out) {
    {
        DBusMessageIter o0Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o0Struct));
        uint32 o1 = in.getJobId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_UINT32, &o1));
        const char* o2 = in.getPath().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_STRING, &o2));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o0Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::job& out) {
    {
        DBusMessageIter o3;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o3);
                {
                    uint32 jobIdValue;
                    uint32 &jobIdTmpValue = jobIdValue;
                    dbus_message_iter_get_basic(&o3, &jobIdTmpValue);
                    out.setJobId(jobIdValue);
                }

                if (dbus_message_iter_has_next(&o3)) {
                    dbus_message_iter_next(&o3);
                } else {
                    return true;
                }

                {
                    ::std::string pathValue;
                    ::std::string &pathTmpValue = pathValue;
                    {
                        char* o4 = 0;
                        dbus_message_iter_get_basic(&o3, &o4);
                        pathTmpValue.assign (o4);
                    }
                    out.setPath(pathValue);
                }

                if (dbus_message_iter_has_next(&o3)) {
                    dbus_message_iter_next(&o3);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of condition

void serializeDBus (const ::org::freedesktop::systemd1::Unit::condition& in, DBusMessageIter* out) {
    {
        DBusMessageIter o5Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o5Struct));
        const char* o6 = in.getType().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o5Struct, DBUS_TYPE_STRING, &o6));
        dbus_bool_t o7 = in.getTriggerCondition() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o5Struct, DBUS_TYPE_BOOLEAN, &o7));
        dbus_bool_t o8 = in.getReverseCondition() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o5Struct, DBUS_TYPE_BOOLEAN, &o8));
        const char* o9 = in.getPath().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o5Struct, DBUS_TYPE_STRING, &o9));
        int32 o10 = in.getStatus();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o5Struct, DBUS_TYPE_INT32, &o10));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o5Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::condition& out) {
    {
        DBusMessageIter o11;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o11);
                {
                    ::std::string typeValue;
                    ::std::string &typeTmpValue = typeValue;
                    {
                        char* o12 = 0;
                        dbus_message_iter_get_basic(&o11, &o12);
                        typeTmpValue.assign (o12);
                    }
                    out.setType(typeValue);
                }

                if (dbus_message_iter_has_next(&o11)) {
                    dbus_message_iter_next(&o11);
                } else {
                    return true;
                }

                {
                    bool triggerConditionValue;
                    bool &triggerConditionTmpValue = triggerConditionValue;
                    {
                        dbus_bool_t o13;
                        dbus_message_iter_get_basic(&o11, &o13);
                        triggerConditionTmpValue = o13 ? true : false;
                    }
                    out.setTriggerCondition(triggerConditionValue);
                }

                if (dbus_message_iter_has_next(&o11)) {
                    dbus_message_iter_next(&o11);
                } else {
                    return true;
                }

                {
                    bool reverseConditionValue;
                    bool &reverseConditionTmpValue = reverseConditionValue;
                    {
                        dbus_bool_t o14;
                        dbus_message_iter_get_basic(&o11, &o14);
                        reverseConditionTmpValue = o14 ? true : false;
                    }
                    out.setReverseCondition(reverseConditionValue);
                }

                if (dbus_message_iter_has_next(&o11)) {
                    dbus_message_iter_next(&o11);
                } else {
                    return true;
                }

                {
                    ::std::string pathValue;
                    ::std::string &pathTmpValue = pathValue;
                    {
                        char* o15 = 0;
                        dbus_message_iter_get_basic(&o11, &o15);
                        pathTmpValue.assign (o15);
                    }
                    out.setPath(pathValue);
                }

                if (dbus_message_iter_has_next(&o11)) {
                    dbus_message_iter_next(&o11);
                } else {
                    return true;
                }

                {
                    int32 statusValue;
                    int32 &statusTmpValue = statusValue;
                    dbus_message_iter_get_basic(&o11, &statusTmpValue);
                    out.setStatus(statusValue);
                }

                if (dbus_message_iter_has_next(&o11)) {
                    dbus_message_iter_next(&o11);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of loadError

void serializeDBus (const ::org::freedesktop::systemd1::Unit::loadError& in, DBusMessageIter* out) {
    {
        DBusMessageIter o16Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o16Struct));
        const char* o17 = in.getErrorId().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o16Struct, DBUS_TYPE_STRING, &o17));
        const char* o18 = in.getErrorName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o16Struct, DBUS_TYPE_STRING, &o18));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o16Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::loadError& out) {
    {
        DBusMessageIter o19;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o19);
                {
                    ::std::string errorIdValue;
                    ::std::string &errorIdTmpValue = errorIdValue;
                    {
                        char* o20 = 0;
                        dbus_message_iter_get_basic(&o19, &o20);
                        errorIdTmpValue.assign (o20);
                    }
                    out.setErrorId(errorIdValue);
                }

                if (dbus_message_iter_has_next(&o19)) {
                    dbus_message_iter_next(&o19);
                } else {
                    return true;
                }

                {
                    ::std::string errorNameValue;
                    ::std::string &errorNameTmpValue = errorNameValue;
                    {
                        char* o21 = 0;
                        dbus_message_iter_get_basic(&o19, &o21);
                        errorNameTmpValue.assign (o21);
                    }
                    out.setErrorName(errorNameValue);
                }

                if (dbus_message_iter_has_next(&o19)) {
                    dbus_message_iter_next(&o19);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of property

void serializeDBus (const ::org::freedesktop::systemd1::Unit::property& in, DBusMessageIter* out) {
    {
        DBusMessageIter o22Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o22Struct));
        const char* o23 = in.getName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o22Struct, DBUS_TYPE_STRING, &o23));
        const char* o24 = in.getValue().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o22Struct, DBUS_TYPE_STRING, &o24));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o22Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::property& out) {
    {
        DBusMessageIter o25;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o25);
                {
                    ::std::string nameValue;
                    ::std::string &nameTmpValue = nameValue;
                    {
                        char* o26 = 0;
                        dbus_message_iter_get_basic(&o25, &o26);
                        nameTmpValue.assign (o26);
                    }
                    out.setName(nameValue);
                }

                if (dbus_message_iter_has_next(&o25)) {
                    dbus_message_iter_next(&o25);
                } else {
                    return true;
                }

                {
                    ::std::string valueValue;
                    ::std::string &valueTmpValue = valueValue;
                    {
                        char* o27 = 0;
                        dbus_message_iter_get_basic(&o25, &o27);
                        valueTmpValue.assign (o27);
                    }
                    out.setValue(valueValue);
                }

                if (dbus_message_iter_has_next(&o25)) {
                    dbus_message_iter_next(&o25);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of StartRequest

void serializeDBus (const ::org::freedesktop::systemd1::Unit::StartRequest& in, DBusMessageIter* out) {
    const char* o28 = in.getMode().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o28));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::StartRequest& out) {
    {
        ::std::string modeValue;
        ::std::string &modeTmpValue = modeValue;
        {
            char* o29 = 0;
            dbus_message_iter_get_basic(in, &o29);
            modeTmpValue.assign (o29);
        }
        out.setMode(modeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of StartResponse

void serializeDBus (const ::org::freedesktop::systemd1::Unit::StartResponse& in, DBusMessageIter* out) {
    const char* o30 = in.getJob().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o30));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::StartResponse& out) {
    {
        ::std::string jobValue;
        ::std::string &jobTmpValue = jobValue;
        {
            char* o31 = 0;
            dbus_message_iter_get_basic(in, &o31);
            jobTmpValue.assign (o31);
        }
        out.setJob(jobValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of StopRequest

void serializeDBus (const ::org::freedesktop::systemd1::Unit::StopRequest& in, DBusMessageIter* out) {
    const char* o32 = in.getMode().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o32));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::StopRequest& out) {
    {
        ::std::string modeValue;
        ::std::string &modeTmpValue = modeValue;
        {
            char* o33 = 0;
            dbus_message_iter_get_basic(in, &o33);
            modeTmpValue.assign (o33);
        }
        out.setMode(modeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of StopResponse

void serializeDBus (const ::org::freedesktop::systemd1::Unit::StopResponse& in, DBusMessageIter* out) {
    const char* o34 = in.getJob().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o34));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::StopResponse& out) {
    {
        ::std::string jobValue;
        ::std::string &jobTmpValue = jobValue;
        {
            char* o35 = 0;
            dbus_message_iter_get_basic(in, &o35);
            jobTmpValue.assign (o35);
        }
        out.setJob(jobValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ReloadRequest

void serializeDBus (const ::org::freedesktop::systemd1::Unit::ReloadRequest& in, DBusMessageIter* out) {
    const char* o36 = in.getMode().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o36));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::ReloadRequest& out) {
    {
        ::std::string modeValue;
        ::std::string &modeTmpValue = modeValue;
        {
            char* o37 = 0;
            dbus_message_iter_get_basic(in, &o37);
            modeTmpValue.assign (o37);
        }
        out.setMode(modeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ReloadResponse

void serializeDBus (const ::org::freedesktop::systemd1::Unit::ReloadResponse& in, DBusMessageIter* out) {
    const char* o38 = in.getJob().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o38));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::ReloadResponse& out) {
    {
        ::std::string jobValue;
        ::std::string &jobTmpValue = jobValue;
        {
            char* o39 = 0;
            dbus_message_iter_get_basic(in, &o39);
            jobTmpValue.assign (o39);
        }
        out.setJob(jobValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RestartRequest

void serializeDBus (const ::org::freedesktop::systemd1::Unit::RestartRequest& in, DBusMessageIter* out) {
    const char* o40 = in.getMode().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o40));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::RestartRequest& out) {
    {
        ::std::string modeValue;
        ::std::string &modeTmpValue = modeValue;
        {
            char* o41 = 0;
            dbus_message_iter_get_basic(in, &o41);
            modeTmpValue.assign (o41);
        }
        out.setMode(modeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RestartResponse

void serializeDBus (const ::org::freedesktop::systemd1::Unit::RestartResponse& in, DBusMessageIter* out) {
    const char* o42 = in.getJob().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o42));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::RestartResponse& out) {
    {
        ::std::string jobValue;
        ::std::string &jobTmpValue = jobValue;
        {
            char* o43 = 0;
            dbus_message_iter_get_basic(in, &o43);
            jobTmpValue.assign (o43);
        }
        out.setJob(jobValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of TryRestartRequest

void serializeDBus (const ::org::freedesktop::systemd1::Unit::TryRestartRequest& in, DBusMessageIter* out) {
    const char* o44 = in.getMode().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o44));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::TryRestartRequest& out) {
    {
        ::std::string modeValue;
        ::std::string &modeTmpValue = modeValue;
        {
            char* o45 = 0;
            dbus_message_iter_get_basic(in, &o45);
            modeTmpValue.assign (o45);
        }
        out.setMode(modeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of TryRestartResponse

void serializeDBus (const ::org::freedesktop::systemd1::Unit::TryRestartResponse& in, DBusMessageIter* out) {
    const char* o46 = in.getJob().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o46));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::TryRestartResponse& out) {
    {
        ::std::string jobValue;
        ::std::string &jobTmpValue = jobValue;
        {
            char* o47 = 0;
            dbus_message_iter_get_basic(in, &o47);
            jobTmpValue.assign (o47);
        }
        out.setJob(jobValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ReloadOrRestartRequest

void serializeDBus (const ::org::freedesktop::systemd1::Unit::ReloadOrRestartRequest& in, DBusMessageIter* out) {
    const char* o48 = in.getMode().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o48));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::ReloadOrRestartRequest& out) {
    {
        ::std::string modeValue;
        ::std::string &modeTmpValue = modeValue;
        {
            char* o49 = 0;
            dbus_message_iter_get_basic(in, &o49);
            modeTmpValue.assign (o49);
        }
        out.setMode(modeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ReloadOrRestartResponse

void serializeDBus (const ::org::freedesktop::systemd1::Unit::ReloadOrRestartResponse& in, DBusMessageIter* out) {
    const char* o50 = in.getJob().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o50));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::ReloadOrRestartResponse& out) {
    {
        ::std::string jobValue;
        ::std::string &jobTmpValue = jobValue;
        {
            char* o51 = 0;
            dbus_message_iter_get_basic(in, &o51);
            jobTmpValue.assign (o51);
        }
        out.setJob(jobValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ReloadOrTryRestartRequest

void serializeDBus (const ::org::freedesktop::systemd1::Unit::ReloadOrTryRestartRequest& in, DBusMessageIter* out) {
    const char* o52 = in.getMode().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o52));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::ReloadOrTryRestartRequest& out) {
    {
        ::std::string modeValue;
        ::std::string &modeTmpValue = modeValue;
        {
            char* o53 = 0;
            dbus_message_iter_get_basic(in, &o53);
            modeTmpValue.assign (o53);
        }
        out.setMode(modeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ReloadOrTryRestartResponse

void serializeDBus (const ::org::freedesktop::systemd1::Unit::ReloadOrTryRestartResponse& in, DBusMessageIter* out) {
    const char* o54 = in.getJob().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o54));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::ReloadOrTryRestartResponse& out) {
    {
        ::std::string jobValue;
        ::std::string &jobTmpValue = jobValue;
        {
            char* o55 = 0;
            dbus_message_iter_get_basic(in, &o55);
            jobTmpValue.assign (o55);
        }
        out.setJob(jobValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of KillRequest

void serializeDBus (const ::org::freedesktop::systemd1::Unit::KillRequest& in, DBusMessageIter* out) {
    const char* o56 = in.getMode().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o56));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::KillRequest& out) {
    {
        ::std::string modeValue;
        ::std::string &modeTmpValue = modeValue;
        {
            char* o57 = 0;
            dbus_message_iter_get_basic(in, &o57);
            modeTmpValue.assign (o57);
        }
        out.setMode(modeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of KillResponse

void serializeDBus (const ::org::freedesktop::systemd1::Unit::KillResponse& in, DBusMessageIter* out) {
    const char* o58 = in.getJob().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o58));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::KillResponse& out) {
    {
        ::std::string jobValue;
        ::std::string &jobTmpValue = jobValue;
        {
            char* o59 = 0;
            dbus_message_iter_get_basic(in, &o59);
            jobTmpValue.assign (o59);
        }
        out.setJob(jobValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetPropertiesRequest

void serializeDBus (const ::org::freedesktop::systemd1::Unit::SetPropertiesRequest& in, DBusMessageIter* out) {
    dbus_bool_t o60 = in.getRuntime() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o60));
    DBusMessageIter o61ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(ss)", &o61ArrayIter));
    const ::std::vector< ::org::freedesktop::systemd1::Unit::property >* o62 = &in.getProperties();
    ::std::vector< ::org::freedesktop::systemd1::Unit::property >::const_iterator o63 = o62->end();
    for (::std::vector< ::org::freedesktop::systemd1::Unit::property >::const_iterator o64 = o62->begin(); o64 != o63; ++o64) {
        serializeDBus((*o64), &o61ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o61ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::SetPropertiesRequest& out) {
    {
        bool runtimeValue;
        bool &runtimeTmpValue = runtimeValue;
        {
            dbus_bool_t o65;
            dbus_message_iter_get_basic(in, &o65);
            runtimeTmpValue = o65 ? true : false;
        }
        out.setRuntime(runtimeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< ::org::freedesktop::systemd1::Unit::property > propertiesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o66ArrayIter;
            dbus_message_iter_recurse (in, &o66ArrayIter);

            if(dbus_message_iter_get_arg_type(&o66ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::freedesktop::systemd1::Unit::property o67;
                    if (!deserializeDBus(&o66ArrayIter, o67)) {
                        return false;
                    }
                    propertiesValue.push_back(o67);
                } while (dbus_message_iter_next(&o66ArrayIter));
            }
        }
        out.setProperties(propertiesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of IdUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::IdUpdate& in, DBusMessageIter* out) {
    const char* o68 = in.getId().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o68));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::IdUpdate& out) {
    {
        ::std::string IdValue;
        ::std::string &IdTmpValue = IdValue;
        {
            char* o69 = 0;
            dbus_message_iter_get_basic(in, &o69);
            IdTmpValue.assign (o69);
        }
        out.setId(IdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of IdRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::IdRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::IdRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of NamesUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::NamesUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o70ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o70ArrayIter));
    const ::std::vector< ::std::string >* o71 = &in.getNames();
    ::std::vector< ::std::string >::const_iterator o72 = o71->end();
    for (::std::vector< ::std::string >::const_iterator o73 = o71->begin(); o73 != o72; ++o73) {
        const char* o74 = (*o73).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o70ArrayIter, DBUS_TYPE_STRING, &o74));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o70ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::NamesUpdate& out) {
    {
        ::std::vector< ::std::string > NamesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o75ArrayIter;
            dbus_message_iter_recurse (in, &o75ArrayIter);

            if(dbus_message_iter_get_arg_type(&o75ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o76;
                    {
                        char* o77 = 0;
                        dbus_message_iter_get_basic(&o75ArrayIter, &o77);
                        o76.assign (o77);
                    }
                    NamesValue.push_back(o76);
                } while (dbus_message_iter_next(&o75ArrayIter));
            }
        }
        out.setNames(NamesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of NamesRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::NamesRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::NamesRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of FollowingUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::FollowingUpdate& in, DBusMessageIter* out) {
    const char* o78 = in.getFollowing().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o78));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::FollowingUpdate& out) {
    {
        ::std::string FollowingValue;
        ::std::string &FollowingTmpValue = FollowingValue;
        {
            char* o79 = 0;
            dbus_message_iter_get_basic(in, &o79);
            FollowingTmpValue.assign (o79);
        }
        out.setFollowing(FollowingValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of FollowingRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::FollowingRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::FollowingRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of RequiresUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::RequiresUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o80ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o80ArrayIter));
    const ::std::vector< ::std::string >* o81 = &in.getRequires();
    ::std::vector< ::std::string >::const_iterator o82 = o81->end();
    for (::std::vector< ::std::string >::const_iterator o83 = o81->begin(); o83 != o82; ++o83) {
        const char* o84 = (*o83).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o80ArrayIter, DBUS_TYPE_STRING, &o84));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o80ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::RequiresUpdate& out) {
    {
        ::std::vector< ::std::string > RequiresValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o85ArrayIter;
            dbus_message_iter_recurse (in, &o85ArrayIter);

            if(dbus_message_iter_get_arg_type(&o85ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o86;
                    {
                        char* o87 = 0;
                        dbus_message_iter_get_basic(&o85ArrayIter, &o87);
                        o86.assign (o87);
                    }
                    RequiresValue.push_back(o86);
                } while (dbus_message_iter_next(&o85ArrayIter));
            }
        }
        out.setRequires(RequiresValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RequiresRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::RequiresRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::RequiresRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of RequiresOverridableUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::RequiresOverridableUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o88ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o88ArrayIter));
    const ::std::vector< ::std::string >* o89 = &in.getRequiresOverridable();
    ::std::vector< ::std::string >::const_iterator o90 = o89->end();
    for (::std::vector< ::std::string >::const_iterator o91 = o89->begin(); o91 != o90; ++o91) {
        const char* o92 = (*o91).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o88ArrayIter, DBUS_TYPE_STRING, &o92));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o88ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::RequiresOverridableUpdate& out) {
    {
        ::std::vector< ::std::string > RequiresOverridableValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o93ArrayIter;
            dbus_message_iter_recurse (in, &o93ArrayIter);

            if(dbus_message_iter_get_arg_type(&o93ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o94;
                    {
                        char* o95 = 0;
                        dbus_message_iter_get_basic(&o93ArrayIter, &o95);
                        o94.assign (o95);
                    }
                    RequiresOverridableValue.push_back(o94);
                } while (dbus_message_iter_next(&o93ArrayIter));
            }
        }
        out.setRequiresOverridable(RequiresOverridableValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RequiresOverridableRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::RequiresOverridableRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::RequiresOverridableRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of RequisiteUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::RequisiteUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o96ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o96ArrayIter));
    const ::std::vector< ::std::string >* o97 = &in.getRequisite();
    ::std::vector< ::std::string >::const_iterator o98 = o97->end();
    for (::std::vector< ::std::string >::const_iterator o99 = o97->begin(); o99 != o98; ++o99) {
        const char* o100 = (*o99).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o96ArrayIter, DBUS_TYPE_STRING, &o100));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o96ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::RequisiteUpdate& out) {
    {
        ::std::vector< ::std::string > RequisiteValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o101ArrayIter;
            dbus_message_iter_recurse (in, &o101ArrayIter);

            if(dbus_message_iter_get_arg_type(&o101ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o102;
                    {
                        char* o103 = 0;
                        dbus_message_iter_get_basic(&o101ArrayIter, &o103);
                        o102.assign (o103);
                    }
                    RequisiteValue.push_back(o102);
                } while (dbus_message_iter_next(&o101ArrayIter));
            }
        }
        out.setRequisite(RequisiteValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RequisiteRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::RequisiteRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::RequisiteRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of RequisiteOverridableUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::RequisiteOverridableUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o104ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o104ArrayIter));
    const ::std::vector< ::std::string >* o105 = &in.getRequisiteOverridable();
    ::std::vector< ::std::string >::const_iterator o106 = o105->end();
    for (::std::vector< ::std::string >::const_iterator o107 = o105->begin(); o107 != o106; ++o107) {
        const char* o108 = (*o107).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o104ArrayIter, DBUS_TYPE_STRING, &o108));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o104ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::RequisiteOverridableUpdate& out) {
    {
        ::std::vector< ::std::string > RequisiteOverridableValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o109ArrayIter;
            dbus_message_iter_recurse (in, &o109ArrayIter);

            if(dbus_message_iter_get_arg_type(&o109ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o110;
                    {
                        char* o111 = 0;
                        dbus_message_iter_get_basic(&o109ArrayIter, &o111);
                        o110.assign (o111);
                    }
                    RequisiteOverridableValue.push_back(o110);
                } while (dbus_message_iter_next(&o109ArrayIter));
            }
        }
        out.setRequisiteOverridable(RequisiteOverridableValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RequisiteOverridableRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::RequisiteOverridableRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::RequisiteOverridableRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of WantsUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::WantsUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o112ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o112ArrayIter));
    const ::std::vector< ::std::string >* o113 = &in.getWants();
    ::std::vector< ::std::string >::const_iterator o114 = o113->end();
    for (::std::vector< ::std::string >::const_iterator o115 = o113->begin(); o115 != o114; ++o115) {
        const char* o116 = (*o115).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o112ArrayIter, DBUS_TYPE_STRING, &o116));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o112ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::WantsUpdate& out) {
    {
        ::std::vector< ::std::string > WantsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o117ArrayIter;
            dbus_message_iter_recurse (in, &o117ArrayIter);

            if(dbus_message_iter_get_arg_type(&o117ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o118;
                    {
                        char* o119 = 0;
                        dbus_message_iter_get_basic(&o117ArrayIter, &o119);
                        o118.assign (o119);
                    }
                    WantsValue.push_back(o118);
                } while (dbus_message_iter_next(&o117ArrayIter));
            }
        }
        out.setWants(WantsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of WantsRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::WantsRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::WantsRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of BindsToUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::BindsToUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o120ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o120ArrayIter));
    const ::std::vector< ::std::string >* o121 = &in.getBindsTo();
    ::std::vector< ::std::string >::const_iterator o122 = o121->end();
    for (::std::vector< ::std::string >::const_iterator o123 = o121->begin(); o123 != o122; ++o123) {
        const char* o124 = (*o123).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o120ArrayIter, DBUS_TYPE_STRING, &o124));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o120ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::BindsToUpdate& out) {
    {
        ::std::vector< ::std::string > BindsToValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o125ArrayIter;
            dbus_message_iter_recurse (in, &o125ArrayIter);

            if(dbus_message_iter_get_arg_type(&o125ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o126;
                    {
                        char* o127 = 0;
                        dbus_message_iter_get_basic(&o125ArrayIter, &o127);
                        o126.assign (o127);
                    }
                    BindsToValue.push_back(o126);
                } while (dbus_message_iter_next(&o125ArrayIter));
            }
        }
        out.setBindsTo(BindsToValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of BindsToRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::BindsToRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::BindsToRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of PartOfUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::PartOfUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o128ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o128ArrayIter));
    const ::std::vector< ::std::string >* o129 = &in.getPartOf();
    ::std::vector< ::std::string >::const_iterator o130 = o129->end();
    for (::std::vector< ::std::string >::const_iterator o131 = o129->begin(); o131 != o130; ++o131) {
        const char* o132 = (*o131).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o128ArrayIter, DBUS_TYPE_STRING, &o132));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o128ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::PartOfUpdate& out) {
    {
        ::std::vector< ::std::string > PartOfValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o133ArrayIter;
            dbus_message_iter_recurse (in, &o133ArrayIter);

            if(dbus_message_iter_get_arg_type(&o133ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o134;
                    {
                        char* o135 = 0;
                        dbus_message_iter_get_basic(&o133ArrayIter, &o135);
                        o134.assign (o135);
                    }
                    PartOfValue.push_back(o134);
                } while (dbus_message_iter_next(&o133ArrayIter));
            }
        }
        out.setPartOf(PartOfValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of PartOfRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::PartOfRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::PartOfRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of RequiredByUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::RequiredByUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o136ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o136ArrayIter));
    const ::std::vector< ::std::string >* o137 = &in.getRequiredBy();
    ::std::vector< ::std::string >::const_iterator o138 = o137->end();
    for (::std::vector< ::std::string >::const_iterator o139 = o137->begin(); o139 != o138; ++o139) {
        const char* o140 = (*o139).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o136ArrayIter, DBUS_TYPE_STRING, &o140));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o136ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::RequiredByUpdate& out) {
    {
        ::std::vector< ::std::string > RequiredByValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o141ArrayIter;
            dbus_message_iter_recurse (in, &o141ArrayIter);

            if(dbus_message_iter_get_arg_type(&o141ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o142;
                    {
                        char* o143 = 0;
                        dbus_message_iter_get_basic(&o141ArrayIter, &o143);
                        o142.assign (o143);
                    }
                    RequiredByValue.push_back(o142);
                } while (dbus_message_iter_next(&o141ArrayIter));
            }
        }
        out.setRequiredBy(RequiredByValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RequiredByRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::RequiredByRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::RequiredByRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of RequiredByOverridableUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::RequiredByOverridableUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o144ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o144ArrayIter));
    const ::std::vector< ::std::string >* o145 = &in.getRequiredByOverridable();
    ::std::vector< ::std::string >::const_iterator o146 = o145->end();
    for (::std::vector< ::std::string >::const_iterator o147 = o145->begin(); o147 != o146; ++o147) {
        const char* o148 = (*o147).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o144ArrayIter, DBUS_TYPE_STRING, &o148));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o144ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::RequiredByOverridableUpdate& out) {
    {
        ::std::vector< ::std::string > RequiredByOverridableValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o149ArrayIter;
            dbus_message_iter_recurse (in, &o149ArrayIter);

            if(dbus_message_iter_get_arg_type(&o149ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o150;
                    {
                        char* o151 = 0;
                        dbus_message_iter_get_basic(&o149ArrayIter, &o151);
                        o150.assign (o151);
                    }
                    RequiredByOverridableValue.push_back(o150);
                } while (dbus_message_iter_next(&o149ArrayIter));
            }
        }
        out.setRequiredByOverridable(RequiredByOverridableValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RequiredByOverridableRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::RequiredByOverridableRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::RequiredByOverridableRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of RequisiteOfUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::RequisiteOfUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o152ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o152ArrayIter));
    const ::std::vector< ::std::string >* o153 = &in.getRequisiteOf();
    ::std::vector< ::std::string >::const_iterator o154 = o153->end();
    for (::std::vector< ::std::string >::const_iterator o155 = o153->begin(); o155 != o154; ++o155) {
        const char* o156 = (*o155).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o152ArrayIter, DBUS_TYPE_STRING, &o156));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o152ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::RequisiteOfUpdate& out) {
    {
        ::std::vector< ::std::string > RequisiteOfValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o157ArrayIter;
            dbus_message_iter_recurse (in, &o157ArrayIter);

            if(dbus_message_iter_get_arg_type(&o157ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o158;
                    {
                        char* o159 = 0;
                        dbus_message_iter_get_basic(&o157ArrayIter, &o159);
                        o158.assign (o159);
                    }
                    RequisiteOfValue.push_back(o158);
                } while (dbus_message_iter_next(&o157ArrayIter));
            }
        }
        out.setRequisiteOf(RequisiteOfValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RequisiteOfRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::RequisiteOfRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::RequisiteOfRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of RequisiteOfOverridableUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::RequisiteOfOverridableUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o160ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o160ArrayIter));
    const ::std::vector< ::std::string >* o161 = &in.getRequisiteOfOverridable();
    ::std::vector< ::std::string >::const_iterator o162 = o161->end();
    for (::std::vector< ::std::string >::const_iterator o163 = o161->begin(); o163 != o162; ++o163) {
        const char* o164 = (*o163).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o160ArrayIter, DBUS_TYPE_STRING, &o164));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o160ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::RequisiteOfOverridableUpdate& out) {
    {
        ::std::vector< ::std::string > RequisiteOfOverridableValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o165ArrayIter;
            dbus_message_iter_recurse (in, &o165ArrayIter);

            if(dbus_message_iter_get_arg_type(&o165ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o166;
                    {
                        char* o167 = 0;
                        dbus_message_iter_get_basic(&o165ArrayIter, &o167);
                        o166.assign (o167);
                    }
                    RequisiteOfOverridableValue.push_back(o166);
                } while (dbus_message_iter_next(&o165ArrayIter));
            }
        }
        out.setRequisiteOfOverridable(RequisiteOfOverridableValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RequisiteOfOverridableRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::RequisiteOfOverridableRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::RequisiteOfOverridableRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of WantedByUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::WantedByUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o168ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o168ArrayIter));
    const ::std::vector< ::std::string >* o169 = &in.getWantedBy();
    ::std::vector< ::std::string >::const_iterator o170 = o169->end();
    for (::std::vector< ::std::string >::const_iterator o171 = o169->begin(); o171 != o170; ++o171) {
        const char* o172 = (*o171).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o168ArrayIter, DBUS_TYPE_STRING, &o172));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o168ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::WantedByUpdate& out) {
    {
        ::std::vector< ::std::string > WantedByValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o173ArrayIter;
            dbus_message_iter_recurse (in, &o173ArrayIter);

            if(dbus_message_iter_get_arg_type(&o173ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o174;
                    {
                        char* o175 = 0;
                        dbus_message_iter_get_basic(&o173ArrayIter, &o175);
                        o174.assign (o175);
                    }
                    WantedByValue.push_back(o174);
                } while (dbus_message_iter_next(&o173ArrayIter));
            }
        }
        out.setWantedBy(WantedByValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of WantedByRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::WantedByRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::WantedByRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of BoundByUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::BoundByUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o176ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o176ArrayIter));
    const ::std::vector< ::std::string >* o177 = &in.getBoundBy();
    ::std::vector< ::std::string >::const_iterator o178 = o177->end();
    for (::std::vector< ::std::string >::const_iterator o179 = o177->begin(); o179 != o178; ++o179) {
        const char* o180 = (*o179).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o176ArrayIter, DBUS_TYPE_STRING, &o180));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o176ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::BoundByUpdate& out) {
    {
        ::std::vector< ::std::string > BoundByValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o181ArrayIter;
            dbus_message_iter_recurse (in, &o181ArrayIter);

            if(dbus_message_iter_get_arg_type(&o181ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o182;
                    {
                        char* o183 = 0;
                        dbus_message_iter_get_basic(&o181ArrayIter, &o183);
                        o182.assign (o183);
                    }
                    BoundByValue.push_back(o182);
                } while (dbus_message_iter_next(&o181ArrayIter));
            }
        }
        out.setBoundBy(BoundByValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of BoundByRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::BoundByRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::BoundByRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ConsistsOfUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::ConsistsOfUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o184ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o184ArrayIter));
    const ::std::vector< ::std::string >* o185 = &in.getConsistsOf();
    ::std::vector< ::std::string >::const_iterator o186 = o185->end();
    for (::std::vector< ::std::string >::const_iterator o187 = o185->begin(); o187 != o186; ++o187) {
        const char* o188 = (*o187).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o184ArrayIter, DBUS_TYPE_STRING, &o188));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o184ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::ConsistsOfUpdate& out) {
    {
        ::std::vector< ::std::string > ConsistsOfValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o189ArrayIter;
            dbus_message_iter_recurse (in, &o189ArrayIter);

            if(dbus_message_iter_get_arg_type(&o189ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o190;
                    {
                        char* o191 = 0;
                        dbus_message_iter_get_basic(&o189ArrayIter, &o191);
                        o190.assign (o191);
                    }
                    ConsistsOfValue.push_back(o190);
                } while (dbus_message_iter_next(&o189ArrayIter));
            }
        }
        out.setConsistsOf(ConsistsOfValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ConsistsOfRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::ConsistsOfRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::ConsistsOfRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ConflictsUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::ConflictsUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o192ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o192ArrayIter));
    const ::std::vector< ::std::string >* o193 = &in.getConflicts();
    ::std::vector< ::std::string >::const_iterator o194 = o193->end();
    for (::std::vector< ::std::string >::const_iterator o195 = o193->begin(); o195 != o194; ++o195) {
        const char* o196 = (*o195).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o192ArrayIter, DBUS_TYPE_STRING, &o196));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o192ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::ConflictsUpdate& out) {
    {
        ::std::vector< ::std::string > ConflictsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o197ArrayIter;
            dbus_message_iter_recurse (in, &o197ArrayIter);

            if(dbus_message_iter_get_arg_type(&o197ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o198;
                    {
                        char* o199 = 0;
                        dbus_message_iter_get_basic(&o197ArrayIter, &o199);
                        o198.assign (o199);
                    }
                    ConflictsValue.push_back(o198);
                } while (dbus_message_iter_next(&o197ArrayIter));
            }
        }
        out.setConflicts(ConflictsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ConflictsRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::ConflictsRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::ConflictsRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ConflictedByUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::ConflictedByUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o200ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o200ArrayIter));
    const ::std::vector< ::std::string >* o201 = &in.getConflictedBy();
    ::std::vector< ::std::string >::const_iterator o202 = o201->end();
    for (::std::vector< ::std::string >::const_iterator o203 = o201->begin(); o203 != o202; ++o203) {
        const char* o204 = (*o203).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o200ArrayIter, DBUS_TYPE_STRING, &o204));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o200ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::ConflictedByUpdate& out) {
    {
        ::std::vector< ::std::string > ConflictedByValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o205ArrayIter;
            dbus_message_iter_recurse (in, &o205ArrayIter);

            if(dbus_message_iter_get_arg_type(&o205ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o206;
                    {
                        char* o207 = 0;
                        dbus_message_iter_get_basic(&o205ArrayIter, &o207);
                        o206.assign (o207);
                    }
                    ConflictedByValue.push_back(o206);
                } while (dbus_message_iter_next(&o205ArrayIter));
            }
        }
        out.setConflictedBy(ConflictedByValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ConflictedByRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::ConflictedByRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::ConflictedByRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of BeforeUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::BeforeUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o208ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o208ArrayIter));
    const ::std::vector< ::std::string >* o209 = &in.getBefore();
    ::std::vector< ::std::string >::const_iterator o210 = o209->end();
    for (::std::vector< ::std::string >::const_iterator o211 = o209->begin(); o211 != o210; ++o211) {
        const char* o212 = (*o211).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o208ArrayIter, DBUS_TYPE_STRING, &o212));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o208ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::BeforeUpdate& out) {
    {
        ::std::vector< ::std::string > BeforeValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o213ArrayIter;
            dbus_message_iter_recurse (in, &o213ArrayIter);

            if(dbus_message_iter_get_arg_type(&o213ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o214;
                    {
                        char* o215 = 0;
                        dbus_message_iter_get_basic(&o213ArrayIter, &o215);
                        o214.assign (o215);
                    }
                    BeforeValue.push_back(o214);
                } while (dbus_message_iter_next(&o213ArrayIter));
            }
        }
        out.setBefore(BeforeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of BeforeRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::BeforeRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::BeforeRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of AfterUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::AfterUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o216ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o216ArrayIter));
    const ::std::vector< ::std::string >* o217 = &in.getAfter();
    ::std::vector< ::std::string >::const_iterator o218 = o217->end();
    for (::std::vector< ::std::string >::const_iterator o219 = o217->begin(); o219 != o218; ++o219) {
        const char* o220 = (*o219).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o216ArrayIter, DBUS_TYPE_STRING, &o220));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o216ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::AfterUpdate& out) {
    {
        ::std::vector< ::std::string > AfterValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o221ArrayIter;
            dbus_message_iter_recurse (in, &o221ArrayIter);

            if(dbus_message_iter_get_arg_type(&o221ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o222;
                    {
                        char* o223 = 0;
                        dbus_message_iter_get_basic(&o221ArrayIter, &o223);
                        o222.assign (o223);
                    }
                    AfterValue.push_back(o222);
                } while (dbus_message_iter_next(&o221ArrayIter));
            }
        }
        out.setAfter(AfterValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AfterRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::AfterRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::AfterRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of OnFailureUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::OnFailureUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o224ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o224ArrayIter));
    const ::std::vector< ::std::string >* o225 = &in.getOnFailure();
    ::std::vector< ::std::string >::const_iterator o226 = o225->end();
    for (::std::vector< ::std::string >::const_iterator o227 = o225->begin(); o227 != o226; ++o227) {
        const char* o228 = (*o227).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o224ArrayIter, DBUS_TYPE_STRING, &o228));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o224ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::OnFailureUpdate& out) {
    {
        ::std::vector< ::std::string > OnFailureValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o229ArrayIter;
            dbus_message_iter_recurse (in, &o229ArrayIter);

            if(dbus_message_iter_get_arg_type(&o229ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o230;
                    {
                        char* o231 = 0;
                        dbus_message_iter_get_basic(&o229ArrayIter, &o231);
                        o230.assign (o231);
                    }
                    OnFailureValue.push_back(o230);
                } while (dbus_message_iter_next(&o229ArrayIter));
            }
        }
        out.setOnFailure(OnFailureValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of OnFailureRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::OnFailureRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::OnFailureRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of TriggersUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::TriggersUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o232ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o232ArrayIter));
    const ::std::vector< ::std::string >* o233 = &in.getTriggers();
    ::std::vector< ::std::string >::const_iterator o234 = o233->end();
    for (::std::vector< ::std::string >::const_iterator o235 = o233->begin(); o235 != o234; ++o235) {
        const char* o236 = (*o235).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o232ArrayIter, DBUS_TYPE_STRING, &o236));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o232ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::TriggersUpdate& out) {
    {
        ::std::vector< ::std::string > TriggersValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o237ArrayIter;
            dbus_message_iter_recurse (in, &o237ArrayIter);

            if(dbus_message_iter_get_arg_type(&o237ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o238;
                    {
                        char* o239 = 0;
                        dbus_message_iter_get_basic(&o237ArrayIter, &o239);
                        o238.assign (o239);
                    }
                    TriggersValue.push_back(o238);
                } while (dbus_message_iter_next(&o237ArrayIter));
            }
        }
        out.setTriggers(TriggersValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of TriggersRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::TriggersRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::TriggersRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of TriggeredByUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::TriggeredByUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o240ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o240ArrayIter));
    const ::std::vector< ::std::string >* o241 = &in.getTriggeredBy();
    ::std::vector< ::std::string >::const_iterator o242 = o241->end();
    for (::std::vector< ::std::string >::const_iterator o243 = o241->begin(); o243 != o242; ++o243) {
        const char* o244 = (*o243).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o240ArrayIter, DBUS_TYPE_STRING, &o244));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o240ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::TriggeredByUpdate& out) {
    {
        ::std::vector< ::std::string > TriggeredByValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o245ArrayIter;
            dbus_message_iter_recurse (in, &o245ArrayIter);

            if(dbus_message_iter_get_arg_type(&o245ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o246;
                    {
                        char* o247 = 0;
                        dbus_message_iter_get_basic(&o245ArrayIter, &o247);
                        o246.assign (o247);
                    }
                    TriggeredByValue.push_back(o246);
                } while (dbus_message_iter_next(&o245ArrayIter));
            }
        }
        out.setTriggeredBy(TriggeredByValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of TriggeredByRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::TriggeredByRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::TriggeredByRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of PropagatesReloadToUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::PropagatesReloadToUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o248ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o248ArrayIter));
    const ::std::vector< ::std::string >* o249 = &in.getPropagatesReloadTo();
    ::std::vector< ::std::string >::const_iterator o250 = o249->end();
    for (::std::vector< ::std::string >::const_iterator o251 = o249->begin(); o251 != o250; ++o251) {
        const char* o252 = (*o251).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o248ArrayIter, DBUS_TYPE_STRING, &o252));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o248ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::PropagatesReloadToUpdate& out) {
    {
        ::std::vector< ::std::string > PropagatesReloadToValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o253ArrayIter;
            dbus_message_iter_recurse (in, &o253ArrayIter);

            if(dbus_message_iter_get_arg_type(&o253ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o254;
                    {
                        char* o255 = 0;
                        dbus_message_iter_get_basic(&o253ArrayIter, &o255);
                        o254.assign (o255);
                    }
                    PropagatesReloadToValue.push_back(o254);
                } while (dbus_message_iter_next(&o253ArrayIter));
            }
        }
        out.setPropagatesReloadTo(PropagatesReloadToValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of PropagatesReloadToRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::PropagatesReloadToRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::PropagatesReloadToRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ReloadPropagatedFromUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::ReloadPropagatedFromUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o256ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o256ArrayIter));
    const ::std::vector< ::std::string >* o257 = &in.getReloadPropagatedFrom();
    ::std::vector< ::std::string >::const_iterator o258 = o257->end();
    for (::std::vector< ::std::string >::const_iterator o259 = o257->begin(); o259 != o258; ++o259) {
        const char* o260 = (*o259).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o256ArrayIter, DBUS_TYPE_STRING, &o260));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o256ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::ReloadPropagatedFromUpdate& out) {
    {
        ::std::vector< ::std::string > ReloadPropagatedFromValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o261ArrayIter;
            dbus_message_iter_recurse (in, &o261ArrayIter);

            if(dbus_message_iter_get_arg_type(&o261ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o262;
                    {
                        char* o263 = 0;
                        dbus_message_iter_get_basic(&o261ArrayIter, &o263);
                        o262.assign (o263);
                    }
                    ReloadPropagatedFromValue.push_back(o262);
                } while (dbus_message_iter_next(&o261ArrayIter));
            }
        }
        out.setReloadPropagatedFrom(ReloadPropagatedFromValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ReloadPropagatedFromRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::ReloadPropagatedFromRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::ReloadPropagatedFromRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of JoinsNamespaceOfUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::JoinsNamespaceOfUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o264ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o264ArrayIter));
    const ::std::vector< ::std::string >* o265 = &in.getJoinsNamespaceOf();
    ::std::vector< ::std::string >::const_iterator o266 = o265->end();
    for (::std::vector< ::std::string >::const_iterator o267 = o265->begin(); o267 != o266; ++o267) {
        const char* o268 = (*o267).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o264ArrayIter, DBUS_TYPE_STRING, &o268));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o264ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::JoinsNamespaceOfUpdate& out) {
    {
        ::std::vector< ::std::string > JoinsNamespaceOfValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o269ArrayIter;
            dbus_message_iter_recurse (in, &o269ArrayIter);

            if(dbus_message_iter_get_arg_type(&o269ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o270;
                    {
                        char* o271 = 0;
                        dbus_message_iter_get_basic(&o269ArrayIter, &o271);
                        o270.assign (o271);
                    }
                    JoinsNamespaceOfValue.push_back(o270);
                } while (dbus_message_iter_next(&o269ArrayIter));
            }
        }
        out.setJoinsNamespaceOf(JoinsNamespaceOfValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of JoinsNamespaceOfRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::JoinsNamespaceOfRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::JoinsNamespaceOfRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of RequiresMountsForUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::RequiresMountsForUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o272ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o272ArrayIter));
    const ::std::vector< ::std::string >* o273 = &in.getRequiresMountsFor();
    ::std::vector< ::std::string >::const_iterator o274 = o273->end();
    for (::std::vector< ::std::string >::const_iterator o275 = o273->begin(); o275 != o274; ++o275) {
        const char* o276 = (*o275).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o272ArrayIter, DBUS_TYPE_STRING, &o276));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o272ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::RequiresMountsForUpdate& out) {
    {
        ::std::vector< ::std::string > RequiresMountsForValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o277ArrayIter;
            dbus_message_iter_recurse (in, &o277ArrayIter);

            if(dbus_message_iter_get_arg_type(&o277ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o278;
                    {
                        char* o279 = 0;
                        dbus_message_iter_get_basic(&o277ArrayIter, &o279);
                        o278.assign (o279);
                    }
                    RequiresMountsForValue.push_back(o278);
                } while (dbus_message_iter_next(&o277ArrayIter));
            }
        }
        out.setRequiresMountsFor(RequiresMountsForValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RequiresMountsForRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::RequiresMountsForRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::RequiresMountsForRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of DocumentationUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::DocumentationUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o280ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o280ArrayIter));
    const ::std::vector< ::std::string >* o281 = &in.getDocumentation();
    ::std::vector< ::std::string >::const_iterator o282 = o281->end();
    for (::std::vector< ::std::string >::const_iterator o283 = o281->begin(); o283 != o282; ++o283) {
        const char* o284 = (*o283).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o280ArrayIter, DBUS_TYPE_STRING, &o284));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o280ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::DocumentationUpdate& out) {
    {
        ::std::vector< ::std::string > DocumentationValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o285ArrayIter;
            dbus_message_iter_recurse (in, &o285ArrayIter);

            if(dbus_message_iter_get_arg_type(&o285ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o286;
                    {
                        char* o287 = 0;
                        dbus_message_iter_get_basic(&o285ArrayIter, &o287);
                        o286.assign (o287);
                    }
                    DocumentationValue.push_back(o286);
                } while (dbus_message_iter_next(&o285ArrayIter));
            }
        }
        out.setDocumentation(DocumentationValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DocumentationRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::DocumentationRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::DocumentationRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of DescriptionUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::DescriptionUpdate& in, DBusMessageIter* out) {
    const char* o288 = in.getDescription().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o288));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::DescriptionUpdate& out) {
    {
        ::std::string DescriptionValue;
        ::std::string &DescriptionTmpValue = DescriptionValue;
        {
            char* o289 = 0;
            dbus_message_iter_get_basic(in, &o289);
            DescriptionTmpValue.assign (o289);
        }
        out.setDescription(DescriptionValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DescriptionRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::DescriptionRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::DescriptionRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of LoadStateUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::LoadStateUpdate& in, DBusMessageIter* out) {
    const char* o290 = in.getLoadState().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o290));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::LoadStateUpdate& out) {
    {
        ::std::string LoadStateValue;
        ::std::string &LoadStateTmpValue = LoadStateValue;
        {
            char* o291 = 0;
            dbus_message_iter_get_basic(in, &o291);
            LoadStateTmpValue.assign (o291);
        }
        out.setLoadState(LoadStateValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of LoadStateRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::LoadStateRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::LoadStateRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ActiveStateUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::ActiveStateUpdate& in, DBusMessageIter* out) {
    const char* o292 = in.getActiveState().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o292));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::ActiveStateUpdate& out) {
    {
        ::std::string ActiveStateValue;
        ::std::string &ActiveStateTmpValue = ActiveStateValue;
        {
            char* o293 = 0;
            dbus_message_iter_get_basic(in, &o293);
            ActiveStateTmpValue.assign (o293);
        }
        out.setActiveState(ActiveStateValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ActiveStateRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::ActiveStateRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::ActiveStateRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of SubStateUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::SubStateUpdate& in, DBusMessageIter* out) {
    const char* o294 = in.getSubState().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o294));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::SubStateUpdate& out) {
    {
        ::std::string SubStateValue;
        ::std::string &SubStateTmpValue = SubStateValue;
        {
            char* o295 = 0;
            dbus_message_iter_get_basic(in, &o295);
            SubStateTmpValue.assign (o295);
        }
        out.setSubState(SubStateValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SubStateRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::SubStateRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::SubStateRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of FragmentPathUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::FragmentPathUpdate& in, DBusMessageIter* out) {
    const char* o296 = in.getFragmentPath().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o296));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::FragmentPathUpdate& out) {
    {
        ::std::string FragmentPathValue;
        ::std::string &FragmentPathTmpValue = FragmentPathValue;
        {
            char* o297 = 0;
            dbus_message_iter_get_basic(in, &o297);
            FragmentPathTmpValue.assign (o297);
        }
        out.setFragmentPath(FragmentPathValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of FragmentPathRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::FragmentPathRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::FragmentPathRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of SourcePathUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::SourcePathUpdate& in, DBusMessageIter* out) {
    const char* o298 = in.getSourcePath().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o298));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::SourcePathUpdate& out) {
    {
        ::std::string SourcePathValue;
        ::std::string &SourcePathTmpValue = SourcePathValue;
        {
            char* o299 = 0;
            dbus_message_iter_get_basic(in, &o299);
            SourcePathTmpValue.assign (o299);
        }
        out.setSourcePath(SourcePathValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SourcePathRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::SourcePathRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::SourcePathRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of DropInPathsUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::DropInPathsUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o300ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o300ArrayIter));
    const ::std::vector< ::std::string >* o301 = &in.getDropInPaths();
    ::std::vector< ::std::string >::const_iterator o302 = o301->end();
    for (::std::vector< ::std::string >::const_iterator o303 = o301->begin(); o303 != o302; ++o303) {
        const char* o304 = (*o303).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o300ArrayIter, DBUS_TYPE_STRING, &o304));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o300ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::DropInPathsUpdate& out) {
    {
        ::std::vector< ::std::string > DropInPathsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o305ArrayIter;
            dbus_message_iter_recurse (in, &o305ArrayIter);

            if(dbus_message_iter_get_arg_type(&o305ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o306;
                    {
                        char* o307 = 0;
                        dbus_message_iter_get_basic(&o305ArrayIter, &o307);
                        o306.assign (o307);
                    }
                    DropInPathsValue.push_back(o306);
                } while (dbus_message_iter_next(&o305ArrayIter));
            }
        }
        out.setDropInPaths(DropInPathsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DropInPathsRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::DropInPathsRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::DropInPathsRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of UnitFileStateUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::UnitFileStateUpdate& in, DBusMessageIter* out) {
    const char* o308 = in.getUnitFileState().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o308));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::UnitFileStateUpdate& out) {
    {
        ::std::string UnitFileStateValue;
        ::std::string &UnitFileStateTmpValue = UnitFileStateValue;
        {
            char* o309 = 0;
            dbus_message_iter_get_basic(in, &o309);
            UnitFileStateTmpValue.assign (o309);
        }
        out.setUnitFileState(UnitFileStateValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of UnitFileStateRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::UnitFileStateRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::UnitFileStateRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of UnitFilePresetUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::UnitFilePresetUpdate& in, DBusMessageIter* out) {
    const char* o310 = in.getUnitFilePreset().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o310));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::UnitFilePresetUpdate& out) {
    {
        ::std::string UnitFilePresetValue;
        ::std::string &UnitFilePresetTmpValue = UnitFilePresetValue;
        {
            char* o311 = 0;
            dbus_message_iter_get_basic(in, &o311);
            UnitFilePresetTmpValue.assign (o311);
        }
        out.setUnitFilePreset(UnitFilePresetValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of UnitFilePresetRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::UnitFilePresetRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::UnitFilePresetRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of InactiveExitTimestampUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::InactiveExitTimestampUpdate& in, DBusMessageIter* out) {
    uint64 o312 = in.getInactiveExitTimestamp();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o312));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::InactiveExitTimestampUpdate& out) {
    {
        uint64 InactiveExitTimestampValue;
        uint64 &InactiveExitTimestampTmpValue = InactiveExitTimestampValue;
        dbus_message_iter_get_basic(in, &InactiveExitTimestampTmpValue);
        out.setInactiveExitTimestamp(InactiveExitTimestampValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of InactiveExitTimestampRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::InactiveExitTimestampRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::InactiveExitTimestampRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of InactiveExitTimestampMonotonicUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::InactiveExitTimestampMonotonicUpdate& in, DBusMessageIter* out) {
    uint64 o313 = in.getInactiveExitTimestampMonotonic();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o313));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::InactiveExitTimestampMonotonicUpdate& out) {
    {
        uint64 InactiveExitTimestampMonotonicValue;
        uint64 &InactiveExitTimestampMonotonicTmpValue = InactiveExitTimestampMonotonicValue;
        dbus_message_iter_get_basic(in, &InactiveExitTimestampMonotonicTmpValue);
        out.setInactiveExitTimestampMonotonic(InactiveExitTimestampMonotonicValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of InactiveExitTimestampMonotonicRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::InactiveExitTimestampMonotonicRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::InactiveExitTimestampMonotonicRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ActiveEnterTimestampUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::ActiveEnterTimestampUpdate& in, DBusMessageIter* out) {
    uint64 o314 = in.getActiveEnterTimestamp();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o314));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::ActiveEnterTimestampUpdate& out) {
    {
        uint64 ActiveEnterTimestampValue;
        uint64 &ActiveEnterTimestampTmpValue = ActiveEnterTimestampValue;
        dbus_message_iter_get_basic(in, &ActiveEnterTimestampTmpValue);
        out.setActiveEnterTimestamp(ActiveEnterTimestampValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ActiveEnterTimestampRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::ActiveEnterTimestampRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::ActiveEnterTimestampRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ActiveEnterTimestampMonotonicUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::ActiveEnterTimestampMonotonicUpdate& in, DBusMessageIter* out) {
    uint64 o315 = in.getActiveEnterTimestampMonotonic();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o315));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::ActiveEnterTimestampMonotonicUpdate& out) {
    {
        uint64 ActiveEnterTimestampMonotonicValue;
        uint64 &ActiveEnterTimestampMonotonicTmpValue = ActiveEnterTimestampMonotonicValue;
        dbus_message_iter_get_basic(in, &ActiveEnterTimestampMonotonicTmpValue);
        out.setActiveEnterTimestampMonotonic(ActiveEnterTimestampMonotonicValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ActiveEnterTimestampMonotonicRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::ActiveEnterTimestampMonotonicRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::ActiveEnterTimestampMonotonicRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ActiveExitTimestampUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::ActiveExitTimestampUpdate& in, DBusMessageIter* out) {
    uint64 o316 = in.getActiveExitTimestamp();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o316));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::ActiveExitTimestampUpdate& out) {
    {
        uint64 ActiveExitTimestampValue;
        uint64 &ActiveExitTimestampTmpValue = ActiveExitTimestampValue;
        dbus_message_iter_get_basic(in, &ActiveExitTimestampTmpValue);
        out.setActiveExitTimestamp(ActiveExitTimestampValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ActiveExitTimestampRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::ActiveExitTimestampRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::ActiveExitTimestampRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ActiveExitTimestampMonotonicUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::ActiveExitTimestampMonotonicUpdate& in, DBusMessageIter* out) {
    uint64 o317 = in.getActiveExitTimestampMonotonic();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o317));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::ActiveExitTimestampMonotonicUpdate& out) {
    {
        uint64 ActiveExitTimestampMonotonicValue;
        uint64 &ActiveExitTimestampMonotonicTmpValue = ActiveExitTimestampMonotonicValue;
        dbus_message_iter_get_basic(in, &ActiveExitTimestampMonotonicTmpValue);
        out.setActiveExitTimestampMonotonic(ActiveExitTimestampMonotonicValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ActiveExitTimestampMonotonicRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::ActiveExitTimestampMonotonicRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::ActiveExitTimestampMonotonicRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of InactiveEnterTimestampUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::InactiveEnterTimestampUpdate& in, DBusMessageIter* out) {
    uint64 o318 = in.getInactiveEnterTimestamp();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o318));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::InactiveEnterTimestampUpdate& out) {
    {
        uint64 InactiveEnterTimestampValue;
        uint64 &InactiveEnterTimestampTmpValue = InactiveEnterTimestampValue;
        dbus_message_iter_get_basic(in, &InactiveEnterTimestampTmpValue);
        out.setInactiveEnterTimestamp(InactiveEnterTimestampValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of InactiveEnterTimestampRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::InactiveEnterTimestampRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::InactiveEnterTimestampRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of InactiveEnterTimestampMonotonicUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::InactiveEnterTimestampMonotonicUpdate& in, DBusMessageIter* out) {
    uint64 o319 = in.getInactiveEnterTimestampMonotonic();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o319));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::InactiveEnterTimestampMonotonicUpdate& out) {
    {
        uint64 InactiveEnterTimestampMonotonicValue;
        uint64 &InactiveEnterTimestampMonotonicTmpValue = InactiveEnterTimestampMonotonicValue;
        dbus_message_iter_get_basic(in, &InactiveEnterTimestampMonotonicTmpValue);
        out.setInactiveEnterTimestampMonotonic(InactiveEnterTimestampMonotonicValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of InactiveEnterTimestampMonotonicRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::InactiveEnterTimestampMonotonicRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::InactiveEnterTimestampMonotonicRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of CanStartUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::CanStartUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o320 = in.getCanStart() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o320));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::CanStartUpdate& out) {
    {
        bool CanStartValue;
        bool &CanStartTmpValue = CanStartValue;
        {
            dbus_bool_t o321;
            dbus_message_iter_get_basic(in, &o321);
            CanStartTmpValue = o321 ? true : false;
        }
        out.setCanStart(CanStartValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of CanStartRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::CanStartRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::CanStartRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of CanStopUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::CanStopUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o322 = in.getCanStop() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o322));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::CanStopUpdate& out) {
    {
        bool CanStopValue;
        bool &CanStopTmpValue = CanStopValue;
        {
            dbus_bool_t o323;
            dbus_message_iter_get_basic(in, &o323);
            CanStopTmpValue = o323 ? true : false;
        }
        out.setCanStop(CanStopValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of CanStopRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::CanStopRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::CanStopRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of CanReloadUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::CanReloadUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o324 = in.getCanReload() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o324));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::CanReloadUpdate& out) {
    {
        bool CanReloadValue;
        bool &CanReloadTmpValue = CanReloadValue;
        {
            dbus_bool_t o325;
            dbus_message_iter_get_basic(in, &o325);
            CanReloadTmpValue = o325 ? true : false;
        }
        out.setCanReload(CanReloadValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of CanReloadRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::CanReloadRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::CanReloadRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of CanIsolateUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::CanIsolateUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o326 = in.getCanIsolate() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o326));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::CanIsolateUpdate& out) {
    {
        bool CanIsolateValue;
        bool &CanIsolateTmpValue = CanIsolateValue;
        {
            dbus_bool_t o327;
            dbus_message_iter_get_basic(in, &o327);
            CanIsolateTmpValue = o327 ? true : false;
        }
        out.setCanIsolate(CanIsolateValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of CanIsolateRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::CanIsolateRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::CanIsolateRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of JobUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::JobUpdate& in, DBusMessageIter* out) {
    serializeDBus(in.getJob(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::JobUpdate& out) {
    {
        ::org::freedesktop::systemd1::Unit::job JobValue;
        if (!deserializeDBus(in, JobValue)) {
            return false;
        }
        out.setJob(JobValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of JobRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::JobRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::JobRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of StopWhenUnneededUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::StopWhenUnneededUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o328 = in.getStopWhenUnneeded() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o328));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::StopWhenUnneededUpdate& out) {
    {
        bool StopWhenUnneededValue;
        bool &StopWhenUnneededTmpValue = StopWhenUnneededValue;
        {
            dbus_bool_t o329;
            dbus_message_iter_get_basic(in, &o329);
            StopWhenUnneededTmpValue = o329 ? true : false;
        }
        out.setStopWhenUnneeded(StopWhenUnneededValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of StopWhenUnneededRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::StopWhenUnneededRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::StopWhenUnneededRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of RefuseManualStartUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::RefuseManualStartUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o330 = in.getRefuseManualStart() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o330));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::RefuseManualStartUpdate& out) {
    {
        bool RefuseManualStartValue;
        bool &RefuseManualStartTmpValue = RefuseManualStartValue;
        {
            dbus_bool_t o331;
            dbus_message_iter_get_basic(in, &o331);
            RefuseManualStartTmpValue = o331 ? true : false;
        }
        out.setRefuseManualStart(RefuseManualStartValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RefuseManualStartRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::RefuseManualStartRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::RefuseManualStartRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of RefuseManualStopUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::RefuseManualStopUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o332 = in.getRefuseManualStop() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o332));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::RefuseManualStopUpdate& out) {
    {
        bool RefuseManualStopValue;
        bool &RefuseManualStopTmpValue = RefuseManualStopValue;
        {
            dbus_bool_t o333;
            dbus_message_iter_get_basic(in, &o333);
            RefuseManualStopTmpValue = o333 ? true : false;
        }
        out.setRefuseManualStop(RefuseManualStopValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RefuseManualStopRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::RefuseManualStopRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::RefuseManualStopRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of AllowIsolateUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::AllowIsolateUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o334 = in.getAllowIsolate() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o334));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::AllowIsolateUpdate& out) {
    {
        bool AllowIsolateValue;
        bool &AllowIsolateTmpValue = AllowIsolateValue;
        {
            dbus_bool_t o335;
            dbus_message_iter_get_basic(in, &o335);
            AllowIsolateTmpValue = o335 ? true : false;
        }
        out.setAllowIsolate(AllowIsolateValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AllowIsolateRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::AllowIsolateRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::AllowIsolateRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of DefaultDependenciesUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::DefaultDependenciesUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o336 = in.getDefaultDependencies() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o336));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::DefaultDependenciesUpdate& out) {
    {
        bool DefaultDependenciesValue;
        bool &DefaultDependenciesTmpValue = DefaultDependenciesValue;
        {
            dbus_bool_t o337;
            dbus_message_iter_get_basic(in, &o337);
            DefaultDependenciesTmpValue = o337 ? true : false;
        }
        out.setDefaultDependencies(DefaultDependenciesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DefaultDependenciesRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::DefaultDependenciesRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::DefaultDependenciesRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of OnFailureJobModeUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::OnFailureJobModeUpdate& in, DBusMessageIter* out) {
    const char* o338 = in.getOnFailureJobMode().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o338));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::OnFailureJobModeUpdate& out) {
    {
        ::std::string OnFailureJobModeValue;
        ::std::string &OnFailureJobModeTmpValue = OnFailureJobModeValue;
        {
            char* o339 = 0;
            dbus_message_iter_get_basic(in, &o339);
            OnFailureJobModeTmpValue.assign (o339);
        }
        out.setOnFailureJobMode(OnFailureJobModeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of OnFailureJobModeRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::OnFailureJobModeRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::OnFailureJobModeRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of IgnoreOnIsolateUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::IgnoreOnIsolateUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o340 = in.getIgnoreOnIsolate() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o340));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::IgnoreOnIsolateUpdate& out) {
    {
        bool IgnoreOnIsolateValue;
        bool &IgnoreOnIsolateTmpValue = IgnoreOnIsolateValue;
        {
            dbus_bool_t o341;
            dbus_message_iter_get_basic(in, &o341);
            IgnoreOnIsolateTmpValue = o341 ? true : false;
        }
        out.setIgnoreOnIsolate(IgnoreOnIsolateValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of IgnoreOnIsolateRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::IgnoreOnIsolateRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::IgnoreOnIsolateRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of IgnoreOnSnapshotUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::IgnoreOnSnapshotUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o342 = in.getIgnoreOnSnapshot() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o342));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::IgnoreOnSnapshotUpdate& out) {
    {
        bool IgnoreOnSnapshotValue;
        bool &IgnoreOnSnapshotTmpValue = IgnoreOnSnapshotValue;
        {
            dbus_bool_t o343;
            dbus_message_iter_get_basic(in, &o343);
            IgnoreOnSnapshotTmpValue = o343 ? true : false;
        }
        out.setIgnoreOnSnapshot(IgnoreOnSnapshotValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of IgnoreOnSnapshotRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::IgnoreOnSnapshotRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::IgnoreOnSnapshotRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of NeedDaemonReloadUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::NeedDaemonReloadUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o344 = in.getNeedDaemonReload() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o344));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::NeedDaemonReloadUpdate& out) {
    {
        bool NeedDaemonReloadValue;
        bool &NeedDaemonReloadTmpValue = NeedDaemonReloadValue;
        {
            dbus_bool_t o345;
            dbus_message_iter_get_basic(in, &o345);
            NeedDaemonReloadTmpValue = o345 ? true : false;
        }
        out.setNeedDaemonReload(NeedDaemonReloadValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of NeedDaemonReloadRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::NeedDaemonReloadRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::NeedDaemonReloadRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of JobTimeoutUSecUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::JobTimeoutUSecUpdate& in, DBusMessageIter* out) {
    uint64 o346 = in.getJobTimeoutUSec();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o346));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::JobTimeoutUSecUpdate& out) {
    {
        uint64 JobTimeoutUSecValue;
        uint64 &JobTimeoutUSecTmpValue = JobTimeoutUSecValue;
        dbus_message_iter_get_basic(in, &JobTimeoutUSecTmpValue);
        out.setJobTimeoutUSec(JobTimeoutUSecValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of JobTimeoutUSecRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::JobTimeoutUSecRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::JobTimeoutUSecRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of JobTimeoutActionUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::JobTimeoutActionUpdate& in, DBusMessageIter* out) {
    const char* o347 = in.getJobTimeoutAction().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o347));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::JobTimeoutActionUpdate& out) {
    {
        ::std::string JobTimeoutActionValue;
        ::std::string &JobTimeoutActionTmpValue = JobTimeoutActionValue;
        {
            char* o348 = 0;
            dbus_message_iter_get_basic(in, &o348);
            JobTimeoutActionTmpValue.assign (o348);
        }
        out.setJobTimeoutAction(JobTimeoutActionValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of JobTimeoutActionRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::JobTimeoutActionRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::JobTimeoutActionRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of JobTimeoutRebootArgumentUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::JobTimeoutRebootArgumentUpdate& in, DBusMessageIter* out) {
    const char* o349 = in.getJobTimeoutRebootArgument().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o349));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::JobTimeoutRebootArgumentUpdate& out) {
    {
        ::std::string JobTimeoutRebootArgumentValue;
        ::std::string &JobTimeoutRebootArgumentTmpValue = JobTimeoutRebootArgumentValue;
        {
            char* o350 = 0;
            dbus_message_iter_get_basic(in, &o350);
            JobTimeoutRebootArgumentTmpValue.assign (o350);
        }
        out.setJobTimeoutRebootArgument(JobTimeoutRebootArgumentValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of JobTimeoutRebootArgumentRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::JobTimeoutRebootArgumentRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::JobTimeoutRebootArgumentRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ConditionResultUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::ConditionResultUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o351 = in.getConditionResult() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o351));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::ConditionResultUpdate& out) {
    {
        bool ConditionResultValue;
        bool &ConditionResultTmpValue = ConditionResultValue;
        {
            dbus_bool_t o352;
            dbus_message_iter_get_basic(in, &o352);
            ConditionResultTmpValue = o352 ? true : false;
        }
        out.setConditionResult(ConditionResultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ConditionResultRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::ConditionResultRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::ConditionResultRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of AssertResultUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::AssertResultUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o353 = in.getAssertResult() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o353));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::AssertResultUpdate& out) {
    {
        bool AssertResultValue;
        bool &AssertResultTmpValue = AssertResultValue;
        {
            dbus_bool_t o354;
            dbus_message_iter_get_basic(in, &o354);
            AssertResultTmpValue = o354 ? true : false;
        }
        out.setAssertResult(AssertResultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AssertResultRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::AssertResultRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::AssertResultRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ConditionTimestampUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::ConditionTimestampUpdate& in, DBusMessageIter* out) {
    uint64 o355 = in.getConditionTimestamp();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o355));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::ConditionTimestampUpdate& out) {
    {
        uint64 ConditionTimestampValue;
        uint64 &ConditionTimestampTmpValue = ConditionTimestampValue;
        dbus_message_iter_get_basic(in, &ConditionTimestampTmpValue);
        out.setConditionTimestamp(ConditionTimestampValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ConditionTimestampRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::ConditionTimestampRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::ConditionTimestampRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ConditionTimestampMonotonicUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::ConditionTimestampMonotonicUpdate& in, DBusMessageIter* out) {
    uint64 o356 = in.getConditionTimestampMonotonic();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o356));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::ConditionTimestampMonotonicUpdate& out) {
    {
        uint64 ConditionTimestampMonotonicValue;
        uint64 &ConditionTimestampMonotonicTmpValue = ConditionTimestampMonotonicValue;
        dbus_message_iter_get_basic(in, &ConditionTimestampMonotonicTmpValue);
        out.setConditionTimestampMonotonic(ConditionTimestampMonotonicValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ConditionTimestampMonotonicRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::ConditionTimestampMonotonicRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::ConditionTimestampMonotonicRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of AssertTimestampUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::AssertTimestampUpdate& in, DBusMessageIter* out) {
    uint64 o357 = in.getAssertTimestamp();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o357));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::AssertTimestampUpdate& out) {
    {
        uint64 AssertTimestampValue;
        uint64 &AssertTimestampTmpValue = AssertTimestampValue;
        dbus_message_iter_get_basic(in, &AssertTimestampTmpValue);
        out.setAssertTimestamp(AssertTimestampValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AssertTimestampRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::AssertTimestampRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::AssertTimestampRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of AssertTimestampMonotonicUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::AssertTimestampMonotonicUpdate& in, DBusMessageIter* out) {
    uint64 o358 = in.getAssertTimestampMonotonic();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT64, &o358));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::AssertTimestampMonotonicUpdate& out) {
    {
        uint64 AssertTimestampMonotonicValue;
        uint64 &AssertTimestampMonotonicTmpValue = AssertTimestampMonotonicValue;
        dbus_message_iter_get_basic(in, &AssertTimestampMonotonicTmpValue);
        out.setAssertTimestampMonotonic(AssertTimestampMonotonicValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AssertTimestampMonotonicRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::AssertTimestampMonotonicRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::AssertTimestampMonotonicRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ConditionsUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::ConditionsUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o359ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(sbbsi)", &o359ArrayIter));
    const ::std::vector< ::org::freedesktop::systemd1::Unit::condition >* o360 = &in.getConditions();
    ::std::vector< ::org::freedesktop::systemd1::Unit::condition >::const_iterator o361 = o360->end();
    for (::std::vector< ::org::freedesktop::systemd1::Unit::condition >::const_iterator o362 = o360->begin(); o362 != o361; ++o362) {
        serializeDBus((*o362), &o359ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o359ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::ConditionsUpdate& out) {
    {
        ::std::vector< ::org::freedesktop::systemd1::Unit::condition > ConditionsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o363ArrayIter;
            dbus_message_iter_recurse (in, &o363ArrayIter);

            if(dbus_message_iter_get_arg_type(&o363ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::freedesktop::systemd1::Unit::condition o364;
                    if (!deserializeDBus(&o363ArrayIter, o364)) {
                        return false;
                    }
                    ConditionsValue.push_back(o364);
                } while (dbus_message_iter_next(&o363ArrayIter));
            }
        }
        out.setConditions(ConditionsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ConditionsRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::ConditionsRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::ConditionsRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of AssertsUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::AssertsUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o365ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(sbbsi)", &o365ArrayIter));
    const ::std::vector< ::org::freedesktop::systemd1::Unit::condition >* o366 = &in.getAsserts();
    ::std::vector< ::org::freedesktop::systemd1::Unit::condition >::const_iterator o367 = o366->end();
    for (::std::vector< ::org::freedesktop::systemd1::Unit::condition >::const_iterator o368 = o366->begin(); o368 != o367; ++o368) {
        serializeDBus((*o368), &o365ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o365ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::AssertsUpdate& out) {
    {
        ::std::vector< ::org::freedesktop::systemd1::Unit::condition > AssertsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o369ArrayIter;
            dbus_message_iter_recurse (in, &o369ArrayIter);

            if(dbus_message_iter_get_arg_type(&o369ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::freedesktop::systemd1::Unit::condition o370;
                    if (!deserializeDBus(&o369ArrayIter, o370)) {
                        return false;
                    }
                    AssertsValue.push_back(o370);
                } while (dbus_message_iter_next(&o369ArrayIter));
            }
        }
        out.setAsserts(AssertsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AssertsRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::AssertsRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::AssertsRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of LoadErrorUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::LoadErrorUpdate& in, DBusMessageIter* out) {
    serializeDBus(in.getLoadError(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::LoadErrorUpdate& out) {
    {
        ::org::freedesktop::systemd1::Unit::loadError LoadErrorValue;
        if (!deserializeDBus(in, LoadErrorValue)) {
            return false;
        }
        out.setLoadError(LoadErrorValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of LoadErrorRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::LoadErrorRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::LoadErrorRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of TransientUpdate

void serializeDBus (const ::org::freedesktop::systemd1::Unit::TransientUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o371 = in.getTransient() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o371));
}

bool deserializeDBus (DBusMessageIter* in, ::org::freedesktop::systemd1::Unit::TransientUpdate& out) {
    {
        bool TransientValue;
        bool &TransientTmpValue = TransientValue;
        {
            dbus_bool_t o372;
            dbus_message_iter_get_basic(in, &o372);
            TransientTmpValue = o372 ? true : false;
        }
        out.setTransient(TransientValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of TransientRegister

void serializeDBus (const ::org::freedesktop::systemd1::Unit::TransientRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::freedesktop::systemd1::Unit::TransientRegister& /*out*/) {
    return true;
}

