/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/freedesktop/systemd1/Service.h"
#include "org/freedesktop/systemd1/ServiceDBus.h"
#include "org/freedesktop/systemd1/ServiceJson.h"
#include "org/freedesktop/systemd1/ServiceStub.h"
#include <string>
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

DEFINE_CLASS_LOGGER("/org/freedesktop/systemd1/org/freedesktop/systemd1/Service", ServiceStub);


static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 4, "Nice", 80 },
    { 4, "Type", 0 },
    { 4, "User", 101 },
    { 5, "Group", 102 },
    { 5, "Slice", 39 },
    { 5, "UMask", 60 },
    { 6, "Result", 25 },
    { 7, "BusName", 21 },
    { 7, "LimitAS", 68 },
    { 7, "MainPID", 19 },
    { 7, "PAMName", 104 },
    { 7, "PIDFile", 2 },
    { 7, "Restart", 1 },
    { 7, "TTYPath", 91 },
    { 8, "Delegate", 43 },
    { 8, "ExecStop", 37 },
    { 8, "KillMode", 129 },
    { 8, "LimitCPU", 61 },
    { 8, "LimitRSS", 66 },
    { 8, "TTYReset", 92 },
    { 8, "UtmpMode", 116 },
    { 9, "CPUShares", 45 },
    { 9, "ExecStart", 34 },
    { 9, "LimitCORE", 65 },
    { 9, "LimitDATA", 63 },
    { 9, "LimitNICE", 74 },
    { 10, "ControlPID", 20 },
    { 10, "ExecReload", 36 },
    { 10, "KillSignal", 130 },
    { 10, "LimitFSIZE", 62 },
    { 10, "LimitLOCKS", 71 },
    { 10, "LimitNPROC", 69 },
    { 10, "LimitSTACK", 64 },
    { 10, "MountFlags", 108 },
    { 10, "PrivateTmp", 109 },
    { 10, "SecureBits", 99 },
    { 10, "SendSIGHUP", 132 },
    { 10, "StatusText", 23 },
    { 10, "TTYVHangup", 93 },
    { 11, "CPUAffinity", 84 },
    { 11, "DeviceAllow", 57 },
    { 11, "Environment", 58 },
    { 11, "ExecMainPID", 30 },
    { 11, "LimitNOFILE", 67 },
    { 11, "LimitRTPRIO", 75 },
    { 11, "LimitRTTIME", 76 },
    { 11, "MemoryLimit", 55 },
    { 11, "NonBlocking", 87 },
    { 11, "Personality", 125 },
    { 11, "ProtectHome", 112 },
    { 11, "RestartUSec", 4 },
    { 11, "SendSIGKILL", 131 },
    { 11, "StatusErrno", 24 },
    { 12, "CPUUsageNSec", 42 },
    { 12, "Capabilities", 98 },
    { 12, "ControlGroup", 40 },
    { 12, "DevicePolicy", 56 },
    { 12, "ExecMainCode", 31 },
    { 12, "ExecStartPre", 33 },
    { 12, "ExecStopPost", 38 },
    { 12, "GuessMainPID", 18 },
    { 12, "IOScheduling", 81 },
    { 12, "LimitMEMLOCK", 70 },
    { 12, "NotifyAccess", 3 },
    { 12, "WatchdogUSec", 7 },
    { 13, "BlockIOWeight", 49 },
    { 13, "CPUAccounting", 44 },
    { 13, "ExecStartPost", 35 },
    { 13, "FailureAction", 14 },
    { 13, "IgnoreSIGPIPE", 120 },
    { 13, "LimitMSGQUEUE", 73 },
    { 13, "MemoryCurrent", 41 },
    { 13, "ProtectSystem", 113 },
    { 13, "RootDirectory", 78 },
    { 13, "StandardError", 90 },
    { 13, "StandardInput", 88 },
    { 14, "ExecMainStatus", 32 },
    { 14, "OOMScoreAdjust", 79 },
    { 14, "PrivateDevices", 111 },
    { 14, "PrivateNetwork", 110 },
    { 14, "RebootArgument", 13 },
    { 14, "SELinuxContext", 117 },
    { 14, "StandardOutput", 89 },
    { 14, "SyslogPriority", 95 },
    { 14, "TimerSlackNSec", 85 },
    { 14, "UtmpIdentifier", 115 },
    { 15, "AppArmorProfile", 118 },
    { 15, "LimitSIGPENDING", 72 },
    { 15, "NoNewPrivileges", 121 },
    { 15, "RemainAfterExit", 17 },
    { 15, "StartLimitBurst", 11 },
    { 15, "TimeoutStopUSec", 6 },
    { 16, "EnvironmentFiles", 59 },
    { 16, "MemoryAccounting", 54 },
    { 16, "RuntimeDirectory", 128 },
    { 16, "SameProcessGroup", 114 },
    { 16, "StartLimitAction", 12 },
    { 16, "StartupCPUShares", 46 },
    { 16, "SyslogIdentifier", 96 },
    { 16, "SystemCallFilter", 122 },
    { 16, "TTYVTDisallocate", 94 },
    { 16, "TimeoutStartUSec", 5 },
    { 16, "WorkingDirectory", 77 },
    { 17, "BlockIOAccounting", 48 },
    { 17, "SmackProcessLabel", 119 },
    { 17, "SyslogLevelPrefix", 97 },
    { 17, "WatchdogTimestamp", 8 },
    { 18, "CPUQuotaPerSecUSec", 47 },
    { 18, "StartLimitInterval", 10 },
    { 19, "BlockIODeviceWeight", 51 },
    { 19, "CPUSchedulingPolicy", 82 },
    { 19, "ReadOnlyDirectories", 106 },
    { 19, "SupplementaryGroups", 103 },
    { 20, "BlockIOReadBandwidth", 52 },
    { 20, "PermissionsStartOnly", 15 },
    { 20, "ReadWriteDirectories", 105 },
    { 20, "RuntimeDirectoryMode", 127 },
    { 20, "StartupBlockIOWeight", 50 },
    { 21, "BlockIOWriteBandwidth", 53 },
    { 21, "CPUSchedulingPriority", 83 },
    { 21, "CapabilityBoundingSet", 100 },
    { 21, "ExecMainExitTimestamp", 28 },
    { 21, "SystemCallErrorNumber", 124 },
    { 22, "ExecMainStartTimestamp", 26 },
    { 22, "FileDescriptorStoreMax", 22 },
    { 22, "RootDirectoryStartOnly", 16 },
    { 23, "InaccessibleDirectories", 107 },
    { 23, "RestrictAddressFamilies", 126 },
    { 23, "SystemCallArchitectures", 123 },
    { 24, "CPUSchedulingResetOnFork", 86 },
    { 26, "WatchdogTimestampMonotonic", 9 },
    { 30, "ExecMainExitTimestampMonotonic", 29 },
    { 31, "ExecMainStartTimestampMonotonic", 27 },
};

class ServiceStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    ServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    ServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    ServiceStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.freedesktop.systemd1.Service"),
          _logger(logger) {}

    virtual ~ServiceStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void ServiceStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* ServiceStubDelegate::introspect() const {
    return     "<interface name=\"org.freedesktop.systemd1.Service\">\n"
            "    <property access=\"read\" name=\"Type\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"Restart\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"PIDFile\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"NotifyAccess\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"RestartUSec\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"TimeoutStartUSec\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"TimeoutStopUSec\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"WatchdogUSec\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"WatchdogTimestamp\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"WatchdogTimestampMonotonic\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"StartLimitInterval\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"StartLimitBurst\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"StartLimitAction\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"RebootArgument\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"FailureAction\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"PermissionsStartOnly\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"RootDirectoryStartOnly\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"RemainAfterExit\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"GuessMainPID\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"MainPID\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"ControlPID\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"BusName\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"FileDescriptorStoreMax\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"StatusText\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"StatusErrno\" type=\"i\"/>\n"
            "    <property access=\"read\" name=\"Result\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"ExecMainStartTimestamp\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"ExecMainStartTimestampMonotonic\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"ExecMainExitTimestamp\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"ExecMainExitTimestampMonotonic\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"ExecMainPID\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"ExecMainCode\" type=\"i\"/>\n"
            "    <property access=\"read\" name=\"ExecMainStatus\" type=\"i\"/>\n"
            "    <property access=\"read\" name=\"ExecStartPre\" type=\"a(sasbttttuii)\"/>\n"
            "    <property access=\"read\" name=\"ExecStart\" type=\"a(sasbttttuii)\"/>\n"
            "    <property access=\"read\" name=\"ExecStartPost\" type=\"a(sasbttttuii)\"/>\n"
            "    <property access=\"read\" name=\"ExecReload\" type=\"a(sasbttttuii)\"/>\n"
            "    <property access=\"read\" name=\"ExecStop\" type=\"a(sasbttttuii)\"/>\n"
            "    <property access=\"read\" name=\"ExecStopPost\" type=\"a(sasbttttuii)\"/>\n"
            "    <property access=\"read\" name=\"Slice\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"ControlGroup\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"MemoryCurrent\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"CPUUsageNSec\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"Delegate\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"CPUAccounting\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"CPUShares\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"StartupCPUShares\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"CPUQuotaPerSecUSec\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"BlockIOAccounting\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"BlockIOWeight\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"StartupBlockIOWeight\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"BlockIODeviceWeight\" type=\"a(st)\"/>\n"
            "    <property access=\"read\" name=\"BlockIOReadBandwidth\" type=\"a(st)\"/>\n"
            "    <property access=\"read\" name=\"BlockIOWriteBandwidth\" type=\"a(st)\"/>\n"
            "    <property access=\"read\" name=\"MemoryAccounting\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"MemoryLimit\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"DevicePolicy\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"DeviceAllow\" type=\"a(ss)\"/>\n"
            "    <property access=\"read\" name=\"Environment\" type=\"as\"/>\n"
            "    <property access=\"read\" name=\"EnvironmentFiles\" type=\"a(sb)\"/>\n"
            "    <property access=\"read\" name=\"UMask\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"LimitCPU\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"LimitFSIZE\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"LimitDATA\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"LimitSTACK\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"LimitCORE\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"LimitRSS\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"LimitNOFILE\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"LimitAS\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"LimitNPROC\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"LimitMEMLOCK\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"LimitLOCKS\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"LimitSIGPENDING\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"LimitMSGQUEUE\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"LimitNICE\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"LimitRTPRIO\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"LimitRTTIME\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"WorkingDirectory\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"RootDirectory\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"OOMScoreAdjust\" type=\"i\"/>\n"
            "    <property access=\"read\" name=\"Nice\" type=\"i\"/>\n"
            "    <property access=\"read\" name=\"IOScheduling\" type=\"i\"/>\n"
            "    <property access=\"read\" name=\"CPUSchedulingPolicy\" type=\"i\"/>\n"
            "    <property access=\"read\" name=\"CPUSchedulingPriority\" type=\"i\"/>\n"
            "    <property access=\"read\" name=\"CPUAffinity\" type=\"as\"/>\n"
            "    <property access=\"read\" name=\"TimerSlackNSec\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"CPUSchedulingResetOnFork\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"NonBlocking\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"StandardInput\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"StandardOutput\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"StandardError\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"TTYPath\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"TTYReset\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"TTYVHangup\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"TTYVTDisallocate\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"SyslogPriority\" type=\"i\"/>\n"
            "    <property access=\"read\" name=\"SyslogIdentifier\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"SyslogLevelPrefix\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"Capabilities\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"SecureBits\" type=\"i\"/>\n"
            "    <property access=\"read\" name=\"CapabilityBoundingSet\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"User\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"Group\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"SupplementaryGroups\" type=\"as\"/>\n"
            "    <property access=\"read\" name=\"PAMName\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"ReadWriteDirectories\" type=\"as\"/>\n"
            "    <property access=\"read\" name=\"ReadOnlyDirectories\" type=\"as\"/>\n"
            "    <property access=\"read\" name=\"InaccessibleDirectories\" type=\"as\"/>\n"
            "    <property access=\"read\" name=\"MountFlags\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"PrivateTmp\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"PrivateNetwork\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"PrivateDevices\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"ProtectHome\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"ProtectSystem\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"SameProcessGroup\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"UtmpIdentifier\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"UtmpMode\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"SELinuxContext\" type=\"(bs)\"/>\n"
            "    <property access=\"read\" name=\"AppArmorProfile\" type=\"(bs)\"/>\n"
            "    <property access=\"read\" name=\"SmackProcessLabel\" type=\"(bs)\"/>\n"
            "    <property access=\"read\" name=\"IgnoreSIGPIPE\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"NoNewPrivileges\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"SystemCallFilter\" type=\"(bas)\"/>\n"
            "    <property access=\"read\" name=\"SystemCallArchitectures\" type=\"as\"/>\n"
            "    <property access=\"read\" name=\"SystemCallErrorNumber\" type=\"i\"/>\n"
            "    <property access=\"read\" name=\"Personality\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"RestrictAddressFamilies\" type=\"(bas)\"/>\n"
            "    <property access=\"read\" name=\"RuntimeDirectoryMode\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"RuntimeDirectory\" type=\"as\"/>\n"
            "    <property access=\"read\" name=\"KillMode\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"KillSignal\" type=\"i\"/>\n"
            "    <property access=\"read\" name=\"SendSIGKILL\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"SendSIGHUP\" type=\"b\"/>\n"
            "</interface>\n";
}

void ServiceStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<ServiceStub*>(getStub()))->onGetAll (properties);
}

void ServiceStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 133, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "Type");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "Restart");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "PIDFile");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "NotifyAccess");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "RestartUSec");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 5: {
            LOG_DEBUG_STUB("process property '%s'", "TimeoutStartUSec");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 6: {
            LOG_DEBUG_STUB("process property '%s'", "TimeoutStopUSec");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 7: {
            LOG_DEBUG_STUB("process property '%s'", "WatchdogUSec");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 8: {
            LOG_DEBUG_STUB("process property '%s'", "WatchdogTimestamp");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 9: {
            LOG_DEBUG_STUB("process property '%s'", "WatchdogTimestampMonotonic");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 10: {
            LOG_DEBUG_STUB("process property '%s'", "StartLimitInterval");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 11: {
            LOG_DEBUG_STUB("process property '%s'", "StartLimitBurst");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 12: {
            LOG_DEBUG_STUB("process property '%s'", "StartLimitAction");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 13: {
            LOG_DEBUG_STUB("process property '%s'", "RebootArgument");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 14: {
            LOG_DEBUG_STUB("process property '%s'", "FailureAction");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 15: {
            LOG_DEBUG_STUB("process property '%s'", "PermissionsStartOnly");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 16: {
            LOG_DEBUG_STUB("process property '%s'", "RootDirectoryStartOnly");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 17: {
            LOG_DEBUG_STUB("process property '%s'", "RemainAfterExit");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 18: {
            LOG_DEBUG_STUB("process property '%s'", "GuessMainPID");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 19: {
            LOG_DEBUG_STUB("process property '%s'", "MainPID");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 20: {
            LOG_DEBUG_STUB("process property '%s'", "ControlPID");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 21: {
            LOG_DEBUG_STUB("process property '%s'", "BusName");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 22: {
            LOG_DEBUG_STUB("process property '%s'", "FileDescriptorStoreMax");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 23: {
            LOG_DEBUG_STUB("process property '%s'", "StatusText");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 24: {
            LOG_DEBUG_STUB("process property '%s'", "StatusErrno");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 25: {
            LOG_DEBUG_STUB("process property '%s'", "Result");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 26: {
            LOG_DEBUG_STUB("process property '%s'", "ExecMainStartTimestamp");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 27: {
            LOG_DEBUG_STUB("process property '%s'", "ExecMainStartTimestampMonotonic");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 28: {
            LOG_DEBUG_STUB("process property '%s'", "ExecMainExitTimestamp");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 29: {
            LOG_DEBUG_STUB("process property '%s'", "ExecMainExitTimestampMonotonic");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 30: {
            LOG_DEBUG_STUB("process property '%s'", "ExecMainPID");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 31: {
            LOG_DEBUG_STUB("process property '%s'", "ExecMainCode");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 32: {
            LOG_DEBUG_STUB("process property '%s'", "ExecMainStatus");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 33: {
            LOG_DEBUG_STUB("process property '%s'", "ExecStartPre");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 34: {
            LOG_DEBUG_STUB("process property '%s'", "ExecStart");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 35: {
            LOG_DEBUG_STUB("process property '%s'", "ExecStartPost");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 36: {
            LOG_DEBUG_STUB("process property '%s'", "ExecReload");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 37: {
            LOG_DEBUG_STUB("process property '%s'", "ExecStop");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 38: {
            LOG_DEBUG_STUB("process property '%s'", "ExecStopPost");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 39: {
            LOG_DEBUG_STUB("process property '%s'", "Slice");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 40: {
            LOG_DEBUG_STUB("process property '%s'", "ControlGroup");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 41: {
            LOG_DEBUG_STUB("process property '%s'", "MemoryCurrent");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 42: {
            LOG_DEBUG_STUB("process property '%s'", "CPUUsageNSec");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 43: {
            LOG_DEBUG_STUB("process property '%s'", "Delegate");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 44: {
            LOG_DEBUG_STUB("process property '%s'", "CPUAccounting");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 45: {
            LOG_DEBUG_STUB("process property '%s'", "CPUShares");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 46: {
            LOG_DEBUG_STUB("process property '%s'", "StartupCPUShares");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 47: {
            LOG_DEBUG_STUB("process property '%s'", "CPUQuotaPerSecUSec");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 48: {
            LOG_DEBUG_STUB("process property '%s'", "BlockIOAccounting");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 49: {
            LOG_DEBUG_STUB("process property '%s'", "BlockIOWeight");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 50: {
            LOG_DEBUG_STUB("process property '%s'", "StartupBlockIOWeight");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 51: {
            LOG_DEBUG_STUB("process property '%s'", "BlockIODeviceWeight");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 52: {
            LOG_DEBUG_STUB("process property '%s'", "BlockIOReadBandwidth");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 53: {
            LOG_DEBUG_STUB("process property '%s'", "BlockIOWriteBandwidth");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 54: {
            LOG_DEBUG_STUB("process property '%s'", "MemoryAccounting");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 55: {
            LOG_DEBUG_STUB("process property '%s'", "MemoryLimit");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 56: {
            LOG_DEBUG_STUB("process property '%s'", "DevicePolicy");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 57: {
            LOG_DEBUG_STUB("process property '%s'", "DeviceAllow");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 58: {
            LOG_DEBUG_STUB("process property '%s'", "Environment");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 59: {
            LOG_DEBUG_STUB("process property '%s'", "EnvironmentFiles");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 60: {
            LOG_DEBUG_STUB("process property '%s'", "UMask");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 61: {
            LOG_DEBUG_STUB("process property '%s'", "LimitCPU");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 62: {
            LOG_DEBUG_STUB("process property '%s'", "LimitFSIZE");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 63: {
            LOG_DEBUG_STUB("process property '%s'", "LimitDATA");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 64: {
            LOG_DEBUG_STUB("process property '%s'", "LimitSTACK");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 65: {
            LOG_DEBUG_STUB("process property '%s'", "LimitCORE");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 66: {
            LOG_DEBUG_STUB("process property '%s'", "LimitRSS");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 67: {
            LOG_DEBUG_STUB("process property '%s'", "LimitNOFILE");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 68: {
            LOG_DEBUG_STUB("process property '%s'", "LimitAS");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 69: {
            LOG_DEBUG_STUB("process property '%s'", "LimitNPROC");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 70: {
            LOG_DEBUG_STUB("process property '%s'", "LimitMEMLOCK");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 71: {
            LOG_DEBUG_STUB("process property '%s'", "LimitLOCKS");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 72: {
            LOG_DEBUG_STUB("process property '%s'", "LimitSIGPENDING");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 73: {
            LOG_DEBUG_STUB("process property '%s'", "LimitMSGQUEUE");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 74: {
            LOG_DEBUG_STUB("process property '%s'", "LimitNICE");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 75: {
            LOG_DEBUG_STUB("process property '%s'", "LimitRTPRIO");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 76: {
            LOG_DEBUG_STUB("process property '%s'", "LimitRTTIME");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 77: {
            LOG_DEBUG_STUB("process property '%s'", "WorkingDirectory");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 78: {
            LOG_DEBUG_STUB("process property '%s'", "RootDirectory");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 79: {
            LOG_DEBUG_STUB("process property '%s'", "OOMScoreAdjust");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 80: {
            LOG_DEBUG_STUB("process property '%s'", "Nice");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 81: {
            LOG_DEBUG_STUB("process property '%s'", "IOScheduling");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 82: {
            LOG_DEBUG_STUB("process property '%s'", "CPUSchedulingPolicy");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 83: {
            LOG_DEBUG_STUB("process property '%s'", "CPUSchedulingPriority");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 84: {
            LOG_DEBUG_STUB("process property '%s'", "CPUAffinity");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 85: {
            LOG_DEBUG_STUB("process property '%s'", "TimerSlackNSec");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 86: {
            LOG_DEBUG_STUB("process property '%s'", "CPUSchedulingResetOnFork");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 87: {
            LOG_DEBUG_STUB("process property '%s'", "NonBlocking");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 88: {
            LOG_DEBUG_STUB("process property '%s'", "StandardInput");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 89: {
            LOG_DEBUG_STUB("process property '%s'", "StandardOutput");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 90: {
            LOG_DEBUG_STUB("process property '%s'", "StandardError");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 91: {
            LOG_DEBUG_STUB("process property '%s'", "TTYPath");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 92: {
            LOG_DEBUG_STUB("process property '%s'", "TTYReset");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 93: {
            LOG_DEBUG_STUB("process property '%s'", "TTYVHangup");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 94: {
            LOG_DEBUG_STUB("process property '%s'", "TTYVTDisallocate");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 95: {
            LOG_DEBUG_STUB("process property '%s'", "SyslogPriority");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 96: {
            LOG_DEBUG_STUB("process property '%s'", "SyslogIdentifier");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 97: {
            LOG_DEBUG_STUB("process property '%s'", "SyslogLevelPrefix");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 98: {
            LOG_DEBUG_STUB("process property '%s'", "Capabilities");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 99: {
            LOG_DEBUG_STUB("process property '%s'", "SecureBits");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 100: {
            LOG_DEBUG_STUB("process property '%s'", "CapabilityBoundingSet");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 101: {
            LOG_DEBUG_STUB("process property '%s'", "User");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 102: {
            LOG_DEBUG_STUB("process property '%s'", "Group");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 103: {
            LOG_DEBUG_STUB("process property '%s'", "SupplementaryGroups");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 104: {
            LOG_DEBUG_STUB("process property '%s'", "PAMName");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 105: {
            LOG_DEBUG_STUB("process property '%s'", "ReadWriteDirectories");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 106: {
            LOG_DEBUG_STUB("process property '%s'", "ReadOnlyDirectories");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 107: {
            LOG_DEBUG_STUB("process property '%s'", "InaccessibleDirectories");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 108: {
            LOG_DEBUG_STUB("process property '%s'", "MountFlags");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 109: {
            LOG_DEBUG_STUB("process property '%s'", "PrivateTmp");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 110: {
            LOG_DEBUG_STUB("process property '%s'", "PrivateNetwork");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 111: {
            LOG_DEBUG_STUB("process property '%s'", "PrivateDevices");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 112: {
            LOG_DEBUG_STUB("process property '%s'", "ProtectHome");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 113: {
            LOG_DEBUG_STUB("process property '%s'", "ProtectSystem");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 114: {
            LOG_DEBUG_STUB("process property '%s'", "SameProcessGroup");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 115: {
            LOG_DEBUG_STUB("process property '%s'", "UtmpIdentifier");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 116: {
            LOG_DEBUG_STUB("process property '%s'", "UtmpMode");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 117: {
            LOG_DEBUG_STUB("process property '%s'", "SELinuxContext");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 118: {
            LOG_DEBUG_STUB("process property '%s'", "AppArmorProfile");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 119: {
            LOG_DEBUG_STUB("process property '%s'", "SmackProcessLabel");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 120: {
            LOG_DEBUG_STUB("process property '%s'", "IgnoreSIGPIPE");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 121: {
            LOG_DEBUG_STUB("process property '%s'", "NoNewPrivileges");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 122: {
            LOG_DEBUG_STUB("process property '%s'", "SystemCallFilter");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 123: {
            LOG_DEBUG_STUB("process property '%s'", "SystemCallArchitectures");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 124: {
            LOG_DEBUG_STUB("process property '%s'", "SystemCallErrorNumber");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 125: {
            LOG_DEBUG_STUB("process property '%s'", "Personality");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 126: {
            LOG_DEBUG_STUB("process property '%s'", "RestrictAddressFamilies");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 127: {
            LOG_DEBUG_STUB("process property '%s'", "RuntimeDirectoryMode");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 128: {
            LOG_DEBUG_STUB("process property '%s'", "RuntimeDirectory");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 129: {
            LOG_DEBUG_STUB("process property '%s'", "KillMode");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 130: {
            LOG_DEBUG_STUB("process property '%s'", "KillSignal");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 131: {
            LOG_DEBUG_STUB("process property '%s'", "SendSIGKILL");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 132: {
            LOG_DEBUG_STUB("process property '%s'", "SendSIGHUP");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void ServiceStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 133, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "Type");
            ::boost::shared_ptr< TypeGet > payload(new TypeGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onTypeGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "Restart");
            ::boost::shared_ptr< RestartGet > payload(new RestartGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onRestartGet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "PIDFile");
            ::boost::shared_ptr< PIDFileGet > payload(new PIDFileGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onPIDFileGet (payload);
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "NotifyAccess");
            ::boost::shared_ptr< NotifyAccessGet > payload(new NotifyAccessGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onNotifyAccessGet (payload);
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "RestartUSec");
            ::boost::shared_ptr< RestartUSecGet > payload(new RestartUSecGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onRestartUSecGet (payload);
            return;
        }
        case 5: {
            LOG_DEBUG_STUB("process property '%s'", "TimeoutStartUSec");
            ::boost::shared_ptr< TimeoutStartUSecGet > payload(new TimeoutStartUSecGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onTimeoutStartUSecGet (payload);
            return;
        }
        case 6: {
            LOG_DEBUG_STUB("process property '%s'", "TimeoutStopUSec");
            ::boost::shared_ptr< TimeoutStopUSecGet > payload(new TimeoutStopUSecGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onTimeoutStopUSecGet (payload);
            return;
        }
        case 7: {
            LOG_DEBUG_STUB("process property '%s'", "WatchdogUSec");
            ::boost::shared_ptr< WatchdogUSecGet > payload(new WatchdogUSecGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onWatchdogUSecGet (payload);
            return;
        }
        case 8: {
            LOG_DEBUG_STUB("process property '%s'", "WatchdogTimestamp");
            ::boost::shared_ptr< WatchdogTimestampGet > payload(new WatchdogTimestampGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onWatchdogTimestampGet (payload);
            return;
        }
        case 9: {
            LOG_DEBUG_STUB("process property '%s'", "WatchdogTimestampMonotonic");
            ::boost::shared_ptr< WatchdogTimestampMonotonicGet > payload(new WatchdogTimestampMonotonicGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onWatchdogTimestampMonotonicGet (payload);
            return;
        }
        case 10: {
            LOG_DEBUG_STUB("process property '%s'", "StartLimitInterval");
            ::boost::shared_ptr< StartLimitIntervalGet > payload(new StartLimitIntervalGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onStartLimitIntervalGet (payload);
            return;
        }
        case 11: {
            LOG_DEBUG_STUB("process property '%s'", "StartLimitBurst");
            ::boost::shared_ptr< StartLimitBurstGet > payload(new StartLimitBurstGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onStartLimitBurstGet (payload);
            return;
        }
        case 12: {
            LOG_DEBUG_STUB("process property '%s'", "StartLimitAction");
            ::boost::shared_ptr< StartLimitActionGet > payload(new StartLimitActionGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onStartLimitActionGet (payload);
            return;
        }
        case 13: {
            LOG_DEBUG_STUB("process property '%s'", "RebootArgument");
            ::boost::shared_ptr< RebootArgumentGet > payload(new RebootArgumentGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onRebootArgumentGet (payload);
            return;
        }
        case 14: {
            LOG_DEBUG_STUB("process property '%s'", "FailureAction");
            ::boost::shared_ptr< FailureActionGet > payload(new FailureActionGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onFailureActionGet (payload);
            return;
        }
        case 15: {
            LOG_DEBUG_STUB("process property '%s'", "PermissionsStartOnly");
            ::boost::shared_ptr< PermissionsStartOnlyGet > payload(new PermissionsStartOnlyGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onPermissionsStartOnlyGet (payload);
            return;
        }
        case 16: {
            LOG_DEBUG_STUB("process property '%s'", "RootDirectoryStartOnly");
            ::boost::shared_ptr< RootDirectoryStartOnlyGet > payload(new RootDirectoryStartOnlyGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onRootDirectoryStartOnlyGet (payload);
            return;
        }
        case 17: {
            LOG_DEBUG_STUB("process property '%s'", "RemainAfterExit");
            ::boost::shared_ptr< RemainAfterExitGet > payload(new RemainAfterExitGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onRemainAfterExitGet (payload);
            return;
        }
        case 18: {
            LOG_DEBUG_STUB("process property '%s'", "GuessMainPID");
            ::boost::shared_ptr< GuessMainPIDGet > payload(new GuessMainPIDGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onGuessMainPIDGet (payload);
            return;
        }
        case 19: {
            LOG_DEBUG_STUB("process property '%s'", "MainPID");
            ::boost::shared_ptr< MainPIDGet > payload(new MainPIDGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onMainPIDGet (payload);
            return;
        }
        case 20: {
            LOG_DEBUG_STUB("process property '%s'", "ControlPID");
            ::boost::shared_ptr< ControlPIDGet > payload(new ControlPIDGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onControlPIDGet (payload);
            return;
        }
        case 21: {
            LOG_DEBUG_STUB("process property '%s'", "BusName");
            ::boost::shared_ptr< BusNameGet > payload(new BusNameGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onBusNameGet (payload);
            return;
        }
        case 22: {
            LOG_DEBUG_STUB("process property '%s'", "FileDescriptorStoreMax");
            ::boost::shared_ptr< FileDescriptorStoreMaxGet > payload(new FileDescriptorStoreMaxGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onFileDescriptorStoreMaxGet (payload);
            return;
        }
        case 23: {
            LOG_DEBUG_STUB("process property '%s'", "StatusText");
            ::boost::shared_ptr< StatusTextGet > payload(new StatusTextGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onStatusTextGet (payload);
            return;
        }
        case 24: {
            LOG_DEBUG_STUB("process property '%s'", "StatusErrno");
            ::boost::shared_ptr< StatusErrnoGet > payload(new StatusErrnoGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onStatusErrnoGet (payload);
            return;
        }
        case 25: {
            LOG_DEBUG_STUB("process property '%s'", "Result");
            ::boost::shared_ptr< ResultGet > payload(new ResultGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onResultGet (payload);
            return;
        }
        case 26: {
            LOG_DEBUG_STUB("process property '%s'", "ExecMainStartTimestamp");
            ::boost::shared_ptr< ExecMainStartTimestampGet > payload(new ExecMainStartTimestampGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onExecMainStartTimestampGet (payload);
            return;
        }
        case 27: {
            LOG_DEBUG_STUB("process property '%s'", "ExecMainStartTimestampMonotonic");
            ::boost::shared_ptr< ExecMainStartTimestampMonotonicGet > payload(new ExecMainStartTimestampMonotonicGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onExecMainStartTimestampMonotonicGet (payload);
            return;
        }
        case 28: {
            LOG_DEBUG_STUB("process property '%s'", "ExecMainExitTimestamp");
            ::boost::shared_ptr< ExecMainExitTimestampGet > payload(new ExecMainExitTimestampGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onExecMainExitTimestampGet (payload);
            return;
        }
        case 29: {
            LOG_DEBUG_STUB("process property '%s'", "ExecMainExitTimestampMonotonic");
            ::boost::shared_ptr< ExecMainExitTimestampMonotonicGet > payload(new ExecMainExitTimestampMonotonicGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onExecMainExitTimestampMonotonicGet (payload);
            return;
        }
        case 30: {
            LOG_DEBUG_STUB("process property '%s'", "ExecMainPID");
            ::boost::shared_ptr< ExecMainPIDGet > payload(new ExecMainPIDGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onExecMainPIDGet (payload);
            return;
        }
        case 31: {
            LOG_DEBUG_STUB("process property '%s'", "ExecMainCode");
            ::boost::shared_ptr< ExecMainCodeGet > payload(new ExecMainCodeGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onExecMainCodeGet (payload);
            return;
        }
        case 32: {
            LOG_DEBUG_STUB("process property '%s'", "ExecMainStatus");
            ::boost::shared_ptr< ExecMainStatusGet > payload(new ExecMainStatusGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onExecMainStatusGet (payload);
            return;
        }
        case 33: {
            LOG_DEBUG_STUB("process property '%s'", "ExecStartPre");
            ::boost::shared_ptr< ExecStartPreGet > payload(new ExecStartPreGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onExecStartPreGet (payload);
            return;
        }
        case 34: {
            LOG_DEBUG_STUB("process property '%s'", "ExecStart");
            ::boost::shared_ptr< ExecStartGet > payload(new ExecStartGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onExecStartGet (payload);
            return;
        }
        case 35: {
            LOG_DEBUG_STUB("process property '%s'", "ExecStartPost");
            ::boost::shared_ptr< ExecStartPostGet > payload(new ExecStartPostGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onExecStartPostGet (payload);
            return;
        }
        case 36: {
            LOG_DEBUG_STUB("process property '%s'", "ExecReload");
            ::boost::shared_ptr< ExecReloadGet > payload(new ExecReloadGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onExecReloadGet (payload);
            return;
        }
        case 37: {
            LOG_DEBUG_STUB("process property '%s'", "ExecStop");
            ::boost::shared_ptr< ExecStopGet > payload(new ExecStopGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onExecStopGet (payload);
            return;
        }
        case 38: {
            LOG_DEBUG_STUB("process property '%s'", "ExecStopPost");
            ::boost::shared_ptr< ExecStopPostGet > payload(new ExecStopPostGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onExecStopPostGet (payload);
            return;
        }
        case 39: {
            LOG_DEBUG_STUB("process property '%s'", "Slice");
            ::boost::shared_ptr< SliceGet > payload(new SliceGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onSliceGet (payload);
            return;
        }
        case 40: {
            LOG_DEBUG_STUB("process property '%s'", "ControlGroup");
            ::boost::shared_ptr< ControlGroupGet > payload(new ControlGroupGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onControlGroupGet (payload);
            return;
        }
        case 41: {
            LOG_DEBUG_STUB("process property '%s'", "MemoryCurrent");
            ::boost::shared_ptr< MemoryCurrentGet > payload(new MemoryCurrentGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onMemoryCurrentGet (payload);
            return;
        }
        case 42: {
            LOG_DEBUG_STUB("process property '%s'", "CPUUsageNSec");
            ::boost::shared_ptr< CPUUsageNSecGet > payload(new CPUUsageNSecGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onCPUUsageNSecGet (payload);
            return;
        }
        case 43: {
            LOG_DEBUG_STUB("process property '%s'", "Delegate");
            ::boost::shared_ptr< DelegateGet > payload(new DelegateGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onDelegateGet (payload);
            return;
        }
        case 44: {
            LOG_DEBUG_STUB("process property '%s'", "CPUAccounting");
            ::boost::shared_ptr< CPUAccountingGet > payload(new CPUAccountingGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onCPUAccountingGet (payload);
            return;
        }
        case 45: {
            LOG_DEBUG_STUB("process property '%s'", "CPUShares");
            ::boost::shared_ptr< CPUSharesGet > payload(new CPUSharesGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onCPUSharesGet (payload);
            return;
        }
        case 46: {
            LOG_DEBUG_STUB("process property '%s'", "StartupCPUShares");
            ::boost::shared_ptr< StartupCPUSharesGet > payload(new StartupCPUSharesGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onStartupCPUSharesGet (payload);
            return;
        }
        case 47: {
            LOG_DEBUG_STUB("process property '%s'", "CPUQuotaPerSecUSec");
            ::boost::shared_ptr< CPUQuotaPerSecUSecGet > payload(new CPUQuotaPerSecUSecGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onCPUQuotaPerSecUSecGet (payload);
            return;
        }
        case 48: {
            LOG_DEBUG_STUB("process property '%s'", "BlockIOAccounting");
            ::boost::shared_ptr< BlockIOAccountingGet > payload(new BlockIOAccountingGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onBlockIOAccountingGet (payload);
            return;
        }
        case 49: {
            LOG_DEBUG_STUB("process property '%s'", "BlockIOWeight");
            ::boost::shared_ptr< BlockIOWeightGet > payload(new BlockIOWeightGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onBlockIOWeightGet (payload);
            return;
        }
        case 50: {
            LOG_DEBUG_STUB("process property '%s'", "StartupBlockIOWeight");
            ::boost::shared_ptr< StartupBlockIOWeightGet > payload(new StartupBlockIOWeightGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onStartupBlockIOWeightGet (payload);
            return;
        }
        case 51: {
            LOG_DEBUG_STUB("process property '%s'", "BlockIODeviceWeight");
            ::boost::shared_ptr< BlockIODeviceWeightGet > payload(new BlockIODeviceWeightGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onBlockIODeviceWeightGet (payload);
            return;
        }
        case 52: {
            LOG_DEBUG_STUB("process property '%s'", "BlockIOReadBandwidth");
            ::boost::shared_ptr< BlockIOReadBandwidthGet > payload(new BlockIOReadBandwidthGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onBlockIOReadBandwidthGet (payload);
            return;
        }
        case 53: {
            LOG_DEBUG_STUB("process property '%s'", "BlockIOWriteBandwidth");
            ::boost::shared_ptr< BlockIOWriteBandwidthGet > payload(new BlockIOWriteBandwidthGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onBlockIOWriteBandwidthGet (payload);
            return;
        }
        case 54: {
            LOG_DEBUG_STUB("process property '%s'", "MemoryAccounting");
            ::boost::shared_ptr< MemoryAccountingGet > payload(new MemoryAccountingGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onMemoryAccountingGet (payload);
            return;
        }
        case 55: {
            LOG_DEBUG_STUB("process property '%s'", "MemoryLimit");
            ::boost::shared_ptr< MemoryLimitGet > payload(new MemoryLimitGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onMemoryLimitGet (payload);
            return;
        }
        case 56: {
            LOG_DEBUG_STUB("process property '%s'", "DevicePolicy");
            ::boost::shared_ptr< DevicePolicyGet > payload(new DevicePolicyGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onDevicePolicyGet (payload);
            return;
        }
        case 57: {
            LOG_DEBUG_STUB("process property '%s'", "DeviceAllow");
            ::boost::shared_ptr< DeviceAllowGet > payload(new DeviceAllowGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onDeviceAllowGet (payload);
            return;
        }
        case 58: {
            LOG_DEBUG_STUB("process property '%s'", "Environment");
            ::boost::shared_ptr< EnvironmentGet > payload(new EnvironmentGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onEnvironmentGet (payload);
            return;
        }
        case 59: {
            LOG_DEBUG_STUB("process property '%s'", "EnvironmentFiles");
            ::boost::shared_ptr< EnvironmentFilesGet > payload(new EnvironmentFilesGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onEnvironmentFilesGet (payload);
            return;
        }
        case 60: {
            LOG_DEBUG_STUB("process property '%s'", "UMask");
            ::boost::shared_ptr< UMaskGet > payload(new UMaskGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onUMaskGet (payload);
            return;
        }
        case 61: {
            LOG_DEBUG_STUB("process property '%s'", "LimitCPU");
            ::boost::shared_ptr< LimitCPUGet > payload(new LimitCPUGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onLimitCPUGet (payload);
            return;
        }
        case 62: {
            LOG_DEBUG_STUB("process property '%s'", "LimitFSIZE");
            ::boost::shared_ptr< LimitFSIZEGet > payload(new LimitFSIZEGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onLimitFSIZEGet (payload);
            return;
        }
        case 63: {
            LOG_DEBUG_STUB("process property '%s'", "LimitDATA");
            ::boost::shared_ptr< LimitDATAGet > payload(new LimitDATAGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onLimitDATAGet (payload);
            return;
        }
        case 64: {
            LOG_DEBUG_STUB("process property '%s'", "LimitSTACK");
            ::boost::shared_ptr< LimitSTACKGet > payload(new LimitSTACKGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onLimitSTACKGet (payload);
            return;
        }
        case 65: {
            LOG_DEBUG_STUB("process property '%s'", "LimitCORE");
            ::boost::shared_ptr< LimitCOREGet > payload(new LimitCOREGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onLimitCOREGet (payload);
            return;
        }
        case 66: {
            LOG_DEBUG_STUB("process property '%s'", "LimitRSS");
            ::boost::shared_ptr< LimitRSSGet > payload(new LimitRSSGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onLimitRSSGet (payload);
            return;
        }
        case 67: {
            LOG_DEBUG_STUB("process property '%s'", "LimitNOFILE");
            ::boost::shared_ptr< LimitNOFILEGet > payload(new LimitNOFILEGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onLimitNOFILEGet (payload);
            return;
        }
        case 68: {
            LOG_DEBUG_STUB("process property '%s'", "LimitAS");
            ::boost::shared_ptr< LimitASGet > payload(new LimitASGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onLimitASGet (payload);
            return;
        }
        case 69: {
            LOG_DEBUG_STUB("process property '%s'", "LimitNPROC");
            ::boost::shared_ptr< LimitNPROCGet > payload(new LimitNPROCGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onLimitNPROCGet (payload);
            return;
        }
        case 70: {
            LOG_DEBUG_STUB("process property '%s'", "LimitMEMLOCK");
            ::boost::shared_ptr< LimitMEMLOCKGet > payload(new LimitMEMLOCKGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onLimitMEMLOCKGet (payload);
            return;
        }
        case 71: {
            LOG_DEBUG_STUB("process property '%s'", "LimitLOCKS");
            ::boost::shared_ptr< LimitLOCKSGet > payload(new LimitLOCKSGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onLimitLOCKSGet (payload);
            return;
        }
        case 72: {
            LOG_DEBUG_STUB("process property '%s'", "LimitSIGPENDING");
            ::boost::shared_ptr< LimitSIGPENDINGGet > payload(new LimitSIGPENDINGGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onLimitSIGPENDINGGet (payload);
            return;
        }
        case 73: {
            LOG_DEBUG_STUB("process property '%s'", "LimitMSGQUEUE");
            ::boost::shared_ptr< LimitMSGQUEUEGet > payload(new LimitMSGQUEUEGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onLimitMSGQUEUEGet (payload);
            return;
        }
        case 74: {
            LOG_DEBUG_STUB("process property '%s'", "LimitNICE");
            ::boost::shared_ptr< LimitNICEGet > payload(new LimitNICEGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onLimitNICEGet (payload);
            return;
        }
        case 75: {
            LOG_DEBUG_STUB("process property '%s'", "LimitRTPRIO");
            ::boost::shared_ptr< LimitRTPRIOGet > payload(new LimitRTPRIOGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onLimitRTPRIOGet (payload);
            return;
        }
        case 76: {
            LOG_DEBUG_STUB("process property '%s'", "LimitRTTIME");
            ::boost::shared_ptr< LimitRTTIMEGet > payload(new LimitRTTIMEGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onLimitRTTIMEGet (payload);
            return;
        }
        case 77: {
            LOG_DEBUG_STUB("process property '%s'", "WorkingDirectory");
            ::boost::shared_ptr< WorkingDirectoryGet > payload(new WorkingDirectoryGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onWorkingDirectoryGet (payload);
            return;
        }
        case 78: {
            LOG_DEBUG_STUB("process property '%s'", "RootDirectory");
            ::boost::shared_ptr< RootDirectoryGet > payload(new RootDirectoryGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onRootDirectoryGet (payload);
            return;
        }
        case 79: {
            LOG_DEBUG_STUB("process property '%s'", "OOMScoreAdjust");
            ::boost::shared_ptr< OOMScoreAdjustGet > payload(new OOMScoreAdjustGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onOOMScoreAdjustGet (payload);
            return;
        }
        case 80: {
            LOG_DEBUG_STUB("process property '%s'", "Nice");
            ::boost::shared_ptr< NiceGet > payload(new NiceGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onNiceGet (payload);
            return;
        }
        case 81: {
            LOG_DEBUG_STUB("process property '%s'", "IOScheduling");
            ::boost::shared_ptr< IOSchedulingGet > payload(new IOSchedulingGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onIOSchedulingGet (payload);
            return;
        }
        case 82: {
            LOG_DEBUG_STUB("process property '%s'", "CPUSchedulingPolicy");
            ::boost::shared_ptr< CPUSchedulingPolicyGet > payload(new CPUSchedulingPolicyGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onCPUSchedulingPolicyGet (payload);
            return;
        }
        case 83: {
            LOG_DEBUG_STUB("process property '%s'", "CPUSchedulingPriority");
            ::boost::shared_ptr< CPUSchedulingPriorityGet > payload(new CPUSchedulingPriorityGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onCPUSchedulingPriorityGet (payload);
            return;
        }
        case 84: {
            LOG_DEBUG_STUB("process property '%s'", "CPUAffinity");
            ::boost::shared_ptr< CPUAffinityGet > payload(new CPUAffinityGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onCPUAffinityGet (payload);
            return;
        }
        case 85: {
            LOG_DEBUG_STUB("process property '%s'", "TimerSlackNSec");
            ::boost::shared_ptr< TimerSlackNSecGet > payload(new TimerSlackNSecGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onTimerSlackNSecGet (payload);
            return;
        }
        case 86: {
            LOG_DEBUG_STUB("process property '%s'", "CPUSchedulingResetOnFork");
            ::boost::shared_ptr< CPUSchedulingResetOnForkGet > payload(new CPUSchedulingResetOnForkGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onCPUSchedulingResetOnForkGet (payload);
            return;
        }
        case 87: {
            LOG_DEBUG_STUB("process property '%s'", "NonBlocking");
            ::boost::shared_ptr< NonBlockingGet > payload(new NonBlockingGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onNonBlockingGet (payload);
            return;
        }
        case 88: {
            LOG_DEBUG_STUB("process property '%s'", "StandardInput");
            ::boost::shared_ptr< StandardInputGet > payload(new StandardInputGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onStandardInputGet (payload);
            return;
        }
        case 89: {
            LOG_DEBUG_STUB("process property '%s'", "StandardOutput");
            ::boost::shared_ptr< StandardOutputGet > payload(new StandardOutputGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onStandardOutputGet (payload);
            return;
        }
        case 90: {
            LOG_DEBUG_STUB("process property '%s'", "StandardError");
            ::boost::shared_ptr< StandardErrorGet > payload(new StandardErrorGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onStandardErrorGet (payload);
            return;
        }
        case 91: {
            LOG_DEBUG_STUB("process property '%s'", "TTYPath");
            ::boost::shared_ptr< TTYPathGet > payload(new TTYPathGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onTTYPathGet (payload);
            return;
        }
        case 92: {
            LOG_DEBUG_STUB("process property '%s'", "TTYReset");
            ::boost::shared_ptr< TTYResetGet > payload(new TTYResetGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onTTYResetGet (payload);
            return;
        }
        case 93: {
            LOG_DEBUG_STUB("process property '%s'", "TTYVHangup");
            ::boost::shared_ptr< TTYVHangupGet > payload(new TTYVHangupGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onTTYVHangupGet (payload);
            return;
        }
        case 94: {
            LOG_DEBUG_STUB("process property '%s'", "TTYVTDisallocate");
            ::boost::shared_ptr< TTYVTDisallocateGet > payload(new TTYVTDisallocateGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onTTYVTDisallocateGet (payload);
            return;
        }
        case 95: {
            LOG_DEBUG_STUB("process property '%s'", "SyslogPriority");
            ::boost::shared_ptr< SyslogPriorityGet > payload(new SyslogPriorityGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onSyslogPriorityGet (payload);
            return;
        }
        case 96: {
            LOG_DEBUG_STUB("process property '%s'", "SyslogIdentifier");
            ::boost::shared_ptr< SyslogIdentifierGet > payload(new SyslogIdentifierGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onSyslogIdentifierGet (payload);
            return;
        }
        case 97: {
            LOG_DEBUG_STUB("process property '%s'", "SyslogLevelPrefix");
            ::boost::shared_ptr< SyslogLevelPrefixGet > payload(new SyslogLevelPrefixGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onSyslogLevelPrefixGet (payload);
            return;
        }
        case 98: {
            LOG_DEBUG_STUB("process property '%s'", "Capabilities");
            ::boost::shared_ptr< CapabilitiesGet > payload(new CapabilitiesGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onCapabilitiesGet (payload);
            return;
        }
        case 99: {
            LOG_DEBUG_STUB("process property '%s'", "SecureBits");
            ::boost::shared_ptr< SecureBitsGet > payload(new SecureBitsGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onSecureBitsGet (payload);
            return;
        }
        case 100: {
            LOG_DEBUG_STUB("process property '%s'", "CapabilityBoundingSet");
            ::boost::shared_ptr< CapabilityBoundingSetGet > payload(new CapabilityBoundingSetGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onCapabilityBoundingSetGet (payload);
            return;
        }
        case 101: {
            LOG_DEBUG_STUB("process property '%s'", "User");
            ::boost::shared_ptr< UserGet > payload(new UserGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onUserGet (payload);
            return;
        }
        case 102: {
            LOG_DEBUG_STUB("process property '%s'", "Group");
            ::boost::shared_ptr< GroupGet > payload(new GroupGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onGroupGet (payload);
            return;
        }
        case 103: {
            LOG_DEBUG_STUB("process property '%s'", "SupplementaryGroups");
            ::boost::shared_ptr< SupplementaryGroupsGet > payload(new SupplementaryGroupsGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onSupplementaryGroupsGet (payload);
            return;
        }
        case 104: {
            LOG_DEBUG_STUB("process property '%s'", "PAMName");
            ::boost::shared_ptr< PAMNameGet > payload(new PAMNameGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onPAMNameGet (payload);
            return;
        }
        case 105: {
            LOG_DEBUG_STUB("process property '%s'", "ReadWriteDirectories");
            ::boost::shared_ptr< ReadWriteDirectoriesGet > payload(new ReadWriteDirectoriesGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onReadWriteDirectoriesGet (payload);
            return;
        }
        case 106: {
            LOG_DEBUG_STUB("process property '%s'", "ReadOnlyDirectories");
            ::boost::shared_ptr< ReadOnlyDirectoriesGet > payload(new ReadOnlyDirectoriesGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onReadOnlyDirectoriesGet (payload);
            return;
        }
        case 107: {
            LOG_DEBUG_STUB("process property '%s'", "InaccessibleDirectories");
            ::boost::shared_ptr< InaccessibleDirectoriesGet > payload(new InaccessibleDirectoriesGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onInaccessibleDirectoriesGet (payload);
            return;
        }
        case 108: {
            LOG_DEBUG_STUB("process property '%s'", "MountFlags");
            ::boost::shared_ptr< MountFlagsGet > payload(new MountFlagsGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onMountFlagsGet (payload);
            return;
        }
        case 109: {
            LOG_DEBUG_STUB("process property '%s'", "PrivateTmp");
            ::boost::shared_ptr< PrivateTmpGet > payload(new PrivateTmpGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onPrivateTmpGet (payload);
            return;
        }
        case 110: {
            LOG_DEBUG_STUB("process property '%s'", "PrivateNetwork");
            ::boost::shared_ptr< PrivateNetworkGet > payload(new PrivateNetworkGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onPrivateNetworkGet (payload);
            return;
        }
        case 111: {
            LOG_DEBUG_STUB("process property '%s'", "PrivateDevices");
            ::boost::shared_ptr< PrivateDevicesGet > payload(new PrivateDevicesGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onPrivateDevicesGet (payload);
            return;
        }
        case 112: {
            LOG_DEBUG_STUB("process property '%s'", "ProtectHome");
            ::boost::shared_ptr< ProtectHomeGet > payload(new ProtectHomeGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onProtectHomeGet (payload);
            return;
        }
        case 113: {
            LOG_DEBUG_STUB("process property '%s'", "ProtectSystem");
            ::boost::shared_ptr< ProtectSystemGet > payload(new ProtectSystemGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onProtectSystemGet (payload);
            return;
        }
        case 114: {
            LOG_DEBUG_STUB("process property '%s'", "SameProcessGroup");
            ::boost::shared_ptr< SameProcessGroupGet > payload(new SameProcessGroupGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onSameProcessGroupGet (payload);
            return;
        }
        case 115: {
            LOG_DEBUG_STUB("process property '%s'", "UtmpIdentifier");
            ::boost::shared_ptr< UtmpIdentifierGet > payload(new UtmpIdentifierGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onUtmpIdentifierGet (payload);
            return;
        }
        case 116: {
            LOG_DEBUG_STUB("process property '%s'", "UtmpMode");
            ::boost::shared_ptr< UtmpModeGet > payload(new UtmpModeGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onUtmpModeGet (payload);
            return;
        }
        case 117: {
            LOG_DEBUG_STUB("process property '%s'", "SELinuxContext");
            ::boost::shared_ptr< SELinuxContextGet > payload(new SELinuxContextGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onSELinuxContextGet (payload);
            return;
        }
        case 118: {
            LOG_DEBUG_STUB("process property '%s'", "AppArmorProfile");
            ::boost::shared_ptr< AppArmorProfileGet > payload(new AppArmorProfileGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onAppArmorProfileGet (payload);
            return;
        }
        case 119: {
            LOG_DEBUG_STUB("process property '%s'", "SmackProcessLabel");
            ::boost::shared_ptr< SmackProcessLabelGet > payload(new SmackProcessLabelGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onSmackProcessLabelGet (payload);
            return;
        }
        case 120: {
            LOG_DEBUG_STUB("process property '%s'", "IgnoreSIGPIPE");
            ::boost::shared_ptr< IgnoreSIGPIPEGet > payload(new IgnoreSIGPIPEGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onIgnoreSIGPIPEGet (payload);
            return;
        }
        case 121: {
            LOG_DEBUG_STUB("process property '%s'", "NoNewPrivileges");
            ::boost::shared_ptr< NoNewPrivilegesGet > payload(new NoNewPrivilegesGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onNoNewPrivilegesGet (payload);
            return;
        }
        case 122: {
            LOG_DEBUG_STUB("process property '%s'", "SystemCallFilter");
            ::boost::shared_ptr< SystemCallFilterGet > payload(new SystemCallFilterGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onSystemCallFilterGet (payload);
            return;
        }
        case 123: {
            LOG_DEBUG_STUB("process property '%s'", "SystemCallArchitectures");
            ::boost::shared_ptr< SystemCallArchitecturesGet > payload(new SystemCallArchitecturesGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onSystemCallArchitecturesGet (payload);
            return;
        }
        case 124: {
            LOG_DEBUG_STUB("process property '%s'", "SystemCallErrorNumber");
            ::boost::shared_ptr< SystemCallErrorNumberGet > payload(new SystemCallErrorNumberGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onSystemCallErrorNumberGet (payload);
            return;
        }
        case 125: {
            LOG_DEBUG_STUB("process property '%s'", "Personality");
            ::boost::shared_ptr< PersonalityGet > payload(new PersonalityGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onPersonalityGet (payload);
            return;
        }
        case 126: {
            LOG_DEBUG_STUB("process property '%s'", "RestrictAddressFamilies");
            ::boost::shared_ptr< RestrictAddressFamiliesGet > payload(new RestrictAddressFamiliesGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onRestrictAddressFamiliesGet (payload);
            return;
        }
        case 127: {
            LOG_DEBUG_STUB("process property '%s'", "RuntimeDirectoryMode");
            ::boost::shared_ptr< RuntimeDirectoryModeGet > payload(new RuntimeDirectoryModeGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onRuntimeDirectoryModeGet (payload);
            return;
        }
        case 128: {
            LOG_DEBUG_STUB("process property '%s'", "RuntimeDirectory");
            ::boost::shared_ptr< RuntimeDirectoryGet > payload(new RuntimeDirectoryGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onRuntimeDirectoryGet (payload);
            return;
        }
        case 129: {
            LOG_DEBUG_STUB("process property '%s'", "KillMode");
            ::boost::shared_ptr< KillModeGet > payload(new KillModeGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onKillModeGet (payload);
            return;
        }
        case 130: {
            LOG_DEBUG_STUB("process property '%s'", "KillSignal");
            ::boost::shared_ptr< KillSignalGet > payload(new KillSignalGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onKillSignalGet (payload);
            return;
        }
        case 131: {
            LOG_DEBUG_STUB("process property '%s'", "SendSIGKILL");
            ::boost::shared_ptr< SendSIGKILLGet > payload(new SendSIGKILLGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onSendSIGKILLGet (payload);
            return;
        }
        case 132: {
            LOG_DEBUG_STUB("process property '%s'", "SendSIGHUP");
            ::boost::shared_ptr< SendSIGHUPGet > payload(new SendSIGHUPGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onSendSIGHUPGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

ServiceStub::ServiceStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new ServiceStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

ServiceStub::ServiceStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new ServiceStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

ServiceStub::~ServiceStub() {
    delete _stubDelegate;
}

void ServiceStub::sendTypeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        TypeUpdate payload(_TypeProperty);

        LOG_INFO ("-> send%s", "TypeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Type", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "TypeUpdate");
    }
}

void ServiceStub::onTypeGet(const ::boost::shared_ptr< TypeGet >& type) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "TypeGet", type->getAct());
    sendTypeGetUpdate(_TypeProperty.getType(), type->getAct());
}

void ServiceStub::sendTypeGetUpdate(const ::std::string& type, act_t act) {
    ::asf::dbus::DBusVariant variant;
    TypeGet payload(type);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "TypeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setType(const ::std::string& type) {
    if(type!=_TypeProperty.getType()) {
        _TypeProperty.setType(type);
        sendTypeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& ServiceStub::getType() const {
    return _TypeProperty.getType();
}

::std::string& ServiceStub::getTypeMutable() {
    return _TypeProperty.getTypeMutable();
}

void ServiceStub::sendRestartUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        RestartUpdate payload(_RestartProperty);

        LOG_INFO ("-> send%s", "RestartUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Restart", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "RestartUpdate");
    }
}

void ServiceStub::onRestartGet(const ::boost::shared_ptr< RestartGet >& restart) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "RestartGet", restart->getAct());
    sendRestartGetUpdate(_RestartProperty.getRestart(), restart->getAct());
}

void ServiceStub::sendRestartGetUpdate(const ::std::string& restart, act_t act) {
    ::asf::dbus::DBusVariant variant;
    RestartGet payload(restart);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "RestartGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setRestart(const ::std::string& restart) {
    if(restart!=_RestartProperty.getRestart()) {
        _RestartProperty.setRestart(restart);
        sendRestartUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& ServiceStub::getRestart() const {
    return _RestartProperty.getRestart();
}

::std::string& ServiceStub::getRestartMutable() {
    return _RestartProperty.getRestartMutable();
}

void ServiceStub::sendPIDFileUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        PIDFileUpdate payload(_PIDFileProperty);

        LOG_INFO ("-> send%s", "PIDFileUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("PIDFile", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "PIDFileUpdate");
    }
}

void ServiceStub::onPIDFileGet(const ::boost::shared_ptr< PIDFileGet >& pIDFile) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "PIDFileGet", pIDFile->getAct());
    sendPIDFileGetUpdate(_PIDFileProperty.getPIDFile(), pIDFile->getAct());
}

void ServiceStub::sendPIDFileGetUpdate(const ::std::string& pIDFile, act_t act) {
    ::asf::dbus::DBusVariant variant;
    PIDFileGet payload(pIDFile);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "PIDFileGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setPIDFile(const ::std::string& pIDFile) {
    if(pIDFile!=_PIDFileProperty.getPIDFile()) {
        _PIDFileProperty.setPIDFile(pIDFile);
        sendPIDFileUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& ServiceStub::getPIDFile() const {
    return _PIDFileProperty.getPIDFile();
}

::std::string& ServiceStub::getPIDFileMutable() {
    return _PIDFileProperty.getPIDFileMutable();
}

void ServiceStub::sendNotifyAccessUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        NotifyAccessUpdate payload(_NotifyAccessProperty);

        LOG_INFO ("-> send%s", "NotifyAccessUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("NotifyAccess", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "NotifyAccessUpdate");
    }
}

void ServiceStub::onNotifyAccessGet(const ::boost::shared_ptr< NotifyAccessGet >& notifyAccess) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "NotifyAccessGet", notifyAccess->getAct());
    sendNotifyAccessGetUpdate(_NotifyAccessProperty.getNotifyAccess(), notifyAccess->getAct());
}

void ServiceStub::sendNotifyAccessGetUpdate(const ::std::string& notifyAccess, act_t act) {
    ::asf::dbus::DBusVariant variant;
    NotifyAccessGet payload(notifyAccess);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "NotifyAccessGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setNotifyAccess(const ::std::string& notifyAccess) {
    if(notifyAccess!=_NotifyAccessProperty.getNotifyAccess()) {
        _NotifyAccessProperty.setNotifyAccess(notifyAccess);
        sendNotifyAccessUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& ServiceStub::getNotifyAccess() const {
    return _NotifyAccessProperty.getNotifyAccess();
}

::std::string& ServiceStub::getNotifyAccessMutable() {
    return _NotifyAccessProperty.getNotifyAccessMutable();
}

void ServiceStub::sendRestartUSecUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        RestartUSecUpdate payload(_RestartUSecProperty);

        LOG_INFO ("-> send%s", "RestartUSecUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("RestartUSec", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "RestartUSecUpdate");
    }
}

void ServiceStub::onRestartUSecGet(const ::boost::shared_ptr< RestartUSecGet >& restartUSec) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "RestartUSecGet", restartUSec->getAct());
    sendRestartUSecGetUpdate(_RestartUSecProperty.getRestartUSec(), restartUSec->getAct());
}

void ServiceStub::sendRestartUSecGetUpdate(uint64 restartUSec, act_t act) {
    ::asf::dbus::DBusVariant variant;
    RestartUSecGet payload(restartUSec);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "RestartUSecGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setRestartUSec(uint64 restartUSec) {
    if(restartUSec!=_RestartUSecProperty.getRestartUSec()) {
        _RestartUSecProperty.setRestartUSec(restartUSec);
        sendRestartUSecUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ServiceStub::getRestartUSec() const {
    return _RestartUSecProperty.getRestartUSec();
}

void ServiceStub::sendTimeoutStartUSecUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        TimeoutStartUSecUpdate payload(_TimeoutStartUSecProperty);

        LOG_INFO ("-> send%s", "TimeoutStartUSecUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("TimeoutStartUSec", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "TimeoutStartUSecUpdate");
    }
}

void ServiceStub::onTimeoutStartUSecGet(const ::boost::shared_ptr< TimeoutStartUSecGet >& timeoutStartUSec) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "TimeoutStartUSecGet", timeoutStartUSec->getAct());
    sendTimeoutStartUSecGetUpdate(_TimeoutStartUSecProperty.getTimeoutStartUSec(), timeoutStartUSec->getAct());
}

void ServiceStub::sendTimeoutStartUSecGetUpdate(uint64 timeoutStartUSec, act_t act) {
    ::asf::dbus::DBusVariant variant;
    TimeoutStartUSecGet payload(timeoutStartUSec);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "TimeoutStartUSecGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setTimeoutStartUSec(uint64 timeoutStartUSec) {
    if(timeoutStartUSec!=_TimeoutStartUSecProperty.getTimeoutStartUSec()) {
        _TimeoutStartUSecProperty.setTimeoutStartUSec(timeoutStartUSec);
        sendTimeoutStartUSecUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ServiceStub::getTimeoutStartUSec() const {
    return _TimeoutStartUSecProperty.getTimeoutStartUSec();
}

void ServiceStub::sendTimeoutStopUSecUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        TimeoutStopUSecUpdate payload(_TimeoutStopUSecProperty);

        LOG_INFO ("-> send%s", "TimeoutStopUSecUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("TimeoutStopUSec", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "TimeoutStopUSecUpdate");
    }
}

void ServiceStub::onTimeoutStopUSecGet(const ::boost::shared_ptr< TimeoutStopUSecGet >& timeoutStopUSec) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "TimeoutStopUSecGet", timeoutStopUSec->getAct());
    sendTimeoutStopUSecGetUpdate(_TimeoutStopUSecProperty.getTimeoutStopUSec(), timeoutStopUSec->getAct());
}

void ServiceStub::sendTimeoutStopUSecGetUpdate(uint64 timeoutStopUSec, act_t act) {
    ::asf::dbus::DBusVariant variant;
    TimeoutStopUSecGet payload(timeoutStopUSec);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "TimeoutStopUSecGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setTimeoutStopUSec(uint64 timeoutStopUSec) {
    if(timeoutStopUSec!=_TimeoutStopUSecProperty.getTimeoutStopUSec()) {
        _TimeoutStopUSecProperty.setTimeoutStopUSec(timeoutStopUSec);
        sendTimeoutStopUSecUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ServiceStub::getTimeoutStopUSec() const {
    return _TimeoutStopUSecProperty.getTimeoutStopUSec();
}

void ServiceStub::sendWatchdogUSecUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        WatchdogUSecUpdate payload(_WatchdogUSecProperty);

        LOG_INFO ("-> send%s", "WatchdogUSecUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("WatchdogUSec", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "WatchdogUSecUpdate");
    }
}

void ServiceStub::onWatchdogUSecGet(const ::boost::shared_ptr< WatchdogUSecGet >& watchdogUSec) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "WatchdogUSecGet", watchdogUSec->getAct());
    sendWatchdogUSecGetUpdate(_WatchdogUSecProperty.getWatchdogUSec(), watchdogUSec->getAct());
}

void ServiceStub::sendWatchdogUSecGetUpdate(uint64 watchdogUSec, act_t act) {
    ::asf::dbus::DBusVariant variant;
    WatchdogUSecGet payload(watchdogUSec);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "WatchdogUSecGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setWatchdogUSec(uint64 watchdogUSec) {
    if(watchdogUSec!=_WatchdogUSecProperty.getWatchdogUSec()) {
        _WatchdogUSecProperty.setWatchdogUSec(watchdogUSec);
        sendWatchdogUSecUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ServiceStub::getWatchdogUSec() const {
    return _WatchdogUSecProperty.getWatchdogUSec();
}

void ServiceStub::sendWatchdogTimestampUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        WatchdogTimestampUpdate payload(_WatchdogTimestampProperty);

        LOG_INFO ("-> send%s", "WatchdogTimestampUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("WatchdogTimestamp", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "WatchdogTimestampUpdate");
    }
}

void ServiceStub::onWatchdogTimestampGet(const ::boost::shared_ptr< WatchdogTimestampGet >& watchdogTimestamp) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "WatchdogTimestampGet", watchdogTimestamp->getAct());
    sendWatchdogTimestampGetUpdate(_WatchdogTimestampProperty.getWatchdogTimestamp(), watchdogTimestamp->getAct());
}

void ServiceStub::sendWatchdogTimestampGetUpdate(uint64 watchdogTimestamp, act_t act) {
    ::asf::dbus::DBusVariant variant;
    WatchdogTimestampGet payload(watchdogTimestamp);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "WatchdogTimestampGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setWatchdogTimestamp(uint64 watchdogTimestamp) {
    if(watchdogTimestamp!=_WatchdogTimestampProperty.getWatchdogTimestamp()) {
        _WatchdogTimestampProperty.setWatchdogTimestamp(watchdogTimestamp);
        sendWatchdogTimestampUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ServiceStub::getWatchdogTimestamp() const {
    return _WatchdogTimestampProperty.getWatchdogTimestamp();
}

void ServiceStub::sendWatchdogTimestampMonotonicUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        WatchdogTimestampMonotonicUpdate payload(_WatchdogTimestampMonotonicProperty);

        LOG_INFO ("-> send%s", "WatchdogTimestampMonotonicUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("WatchdogTimestampMonotonic", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "WatchdogTimestampMonotonicUpdate");
    }
}

void ServiceStub::onWatchdogTimestampMonotonicGet(const ::boost::shared_ptr< WatchdogTimestampMonotonicGet >& watchdogTimestampMonotonic) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "WatchdogTimestampMonotonicGet", watchdogTimestampMonotonic->getAct());
    sendWatchdogTimestampMonotonicGetUpdate(_WatchdogTimestampMonotonicProperty.getWatchdogTimestampMonotonic(), watchdogTimestampMonotonic->getAct());
}

void ServiceStub::sendWatchdogTimestampMonotonicGetUpdate(uint64 watchdogTimestampMonotonic, act_t act) {
    ::asf::dbus::DBusVariant variant;
    WatchdogTimestampMonotonicGet payload(watchdogTimestampMonotonic);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "WatchdogTimestampMonotonicGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setWatchdogTimestampMonotonic(uint64 watchdogTimestampMonotonic) {
    if(watchdogTimestampMonotonic!=_WatchdogTimestampMonotonicProperty.getWatchdogTimestampMonotonic()) {
        _WatchdogTimestampMonotonicProperty.setWatchdogTimestampMonotonic(watchdogTimestampMonotonic);
        sendWatchdogTimestampMonotonicUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ServiceStub::getWatchdogTimestampMonotonic() const {
    return _WatchdogTimestampMonotonicProperty.getWatchdogTimestampMonotonic();
}

void ServiceStub::sendStartLimitIntervalUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        StartLimitIntervalUpdate payload(_StartLimitIntervalProperty);

        LOG_INFO ("-> send%s", "StartLimitIntervalUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("StartLimitInterval", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "StartLimitIntervalUpdate");
    }
}

void ServiceStub::onStartLimitIntervalGet(const ::boost::shared_ptr< StartLimitIntervalGet >& startLimitInterval) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "StartLimitIntervalGet", startLimitInterval->getAct());
    sendStartLimitIntervalGetUpdate(_StartLimitIntervalProperty.getStartLimitInterval(), startLimitInterval->getAct());
}

void ServiceStub::sendStartLimitIntervalGetUpdate(uint64 startLimitInterval, act_t act) {
    ::asf::dbus::DBusVariant variant;
    StartLimitIntervalGet payload(startLimitInterval);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "StartLimitIntervalGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setStartLimitInterval(uint64 startLimitInterval) {
    if(startLimitInterval!=_StartLimitIntervalProperty.getStartLimitInterval()) {
        _StartLimitIntervalProperty.setStartLimitInterval(startLimitInterval);
        sendStartLimitIntervalUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ServiceStub::getStartLimitInterval() const {
    return _StartLimitIntervalProperty.getStartLimitInterval();
}

void ServiceStub::sendStartLimitBurstUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        StartLimitBurstUpdate payload(_StartLimitBurstProperty);

        LOG_INFO ("-> send%s", "StartLimitBurstUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("StartLimitBurst", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "StartLimitBurstUpdate");
    }
}

void ServiceStub::onStartLimitBurstGet(const ::boost::shared_ptr< StartLimitBurstGet >& startLimitBurst) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "StartLimitBurstGet", startLimitBurst->getAct());
    sendStartLimitBurstGetUpdate(_StartLimitBurstProperty.getStartLimitBurst(), startLimitBurst->getAct());
}

void ServiceStub::sendStartLimitBurstGetUpdate(uint32 startLimitBurst, act_t act) {
    ::asf::dbus::DBusVariant variant;
    StartLimitBurstGet payload(startLimitBurst);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "StartLimitBurstGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setStartLimitBurst(uint32 startLimitBurst) {
    if(startLimitBurst!=_StartLimitBurstProperty.getStartLimitBurst()) {
        _StartLimitBurstProperty.setStartLimitBurst(startLimitBurst);
        sendStartLimitBurstUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint32 ServiceStub::getStartLimitBurst() const {
    return _StartLimitBurstProperty.getStartLimitBurst();
}

void ServiceStub::sendStartLimitActionUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        StartLimitActionUpdate payload(_StartLimitActionProperty);

        LOG_INFO ("-> send%s", "StartLimitActionUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("StartLimitAction", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "StartLimitActionUpdate");
    }
}

void ServiceStub::onStartLimitActionGet(const ::boost::shared_ptr< StartLimitActionGet >& startLimitAction) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "StartLimitActionGet", startLimitAction->getAct());
    sendStartLimitActionGetUpdate(_StartLimitActionProperty.getStartLimitAction(), startLimitAction->getAct());
}

void ServiceStub::sendStartLimitActionGetUpdate(const ::std::string& startLimitAction, act_t act) {
    ::asf::dbus::DBusVariant variant;
    StartLimitActionGet payload(startLimitAction);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "StartLimitActionGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setStartLimitAction(const ::std::string& startLimitAction) {
    if(startLimitAction!=_StartLimitActionProperty.getStartLimitAction()) {
        _StartLimitActionProperty.setStartLimitAction(startLimitAction);
        sendStartLimitActionUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& ServiceStub::getStartLimitAction() const {
    return _StartLimitActionProperty.getStartLimitAction();
}

::std::string& ServiceStub::getStartLimitActionMutable() {
    return _StartLimitActionProperty.getStartLimitActionMutable();
}

void ServiceStub::sendRebootArgumentUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        RebootArgumentUpdate payload(_RebootArgumentProperty);

        LOG_INFO ("-> send%s", "RebootArgumentUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("RebootArgument", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "RebootArgumentUpdate");
    }
}

void ServiceStub::onRebootArgumentGet(const ::boost::shared_ptr< RebootArgumentGet >& rebootArgument) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "RebootArgumentGet", rebootArgument->getAct());
    sendRebootArgumentGetUpdate(_RebootArgumentProperty.getRebootArgument(), rebootArgument->getAct());
}

void ServiceStub::sendRebootArgumentGetUpdate(const ::std::string& rebootArgument, act_t act) {
    ::asf::dbus::DBusVariant variant;
    RebootArgumentGet payload(rebootArgument);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "RebootArgumentGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setRebootArgument(const ::std::string& rebootArgument) {
    if(rebootArgument!=_RebootArgumentProperty.getRebootArgument()) {
        _RebootArgumentProperty.setRebootArgument(rebootArgument);
        sendRebootArgumentUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& ServiceStub::getRebootArgument() const {
    return _RebootArgumentProperty.getRebootArgument();
}

::std::string& ServiceStub::getRebootArgumentMutable() {
    return _RebootArgumentProperty.getRebootArgumentMutable();
}

void ServiceStub::sendFailureActionUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        FailureActionUpdate payload(_FailureActionProperty);

        LOG_INFO ("-> send%s", "FailureActionUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("FailureAction", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "FailureActionUpdate");
    }
}

void ServiceStub::onFailureActionGet(const ::boost::shared_ptr< FailureActionGet >& failureAction) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "FailureActionGet", failureAction->getAct());
    sendFailureActionGetUpdate(_FailureActionProperty.getFailureAction(), failureAction->getAct());
}

void ServiceStub::sendFailureActionGetUpdate(const ::std::string& failureAction, act_t act) {
    ::asf::dbus::DBusVariant variant;
    FailureActionGet payload(failureAction);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "FailureActionGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setFailureAction(const ::std::string& failureAction) {
    if(failureAction!=_FailureActionProperty.getFailureAction()) {
        _FailureActionProperty.setFailureAction(failureAction);
        sendFailureActionUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& ServiceStub::getFailureAction() const {
    return _FailureActionProperty.getFailureAction();
}

::std::string& ServiceStub::getFailureActionMutable() {
    return _FailureActionProperty.getFailureActionMutable();
}

void ServiceStub::sendPermissionsStartOnlyUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        PermissionsStartOnlyUpdate payload(_PermissionsStartOnlyProperty);

        LOG_INFO ("-> send%s", "PermissionsStartOnlyUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("PermissionsStartOnly", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "PermissionsStartOnlyUpdate");
    }
}

void ServiceStub::onPermissionsStartOnlyGet(const ::boost::shared_ptr< PermissionsStartOnlyGet >& permissionsStartOnly) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "PermissionsStartOnlyGet", permissionsStartOnly->getAct());
    sendPermissionsStartOnlyGetUpdate(_PermissionsStartOnlyProperty.getPermissionsStartOnly(), permissionsStartOnly->getAct());
}

void ServiceStub::sendPermissionsStartOnlyGetUpdate(bool permissionsStartOnly, act_t act) {
    ::asf::dbus::DBusVariant variant;
    PermissionsStartOnlyGet payload(permissionsStartOnly);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "PermissionsStartOnlyGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setPermissionsStartOnly(bool permissionsStartOnly) {
    if(permissionsStartOnly!=_PermissionsStartOnlyProperty.getPermissionsStartOnly()) {
        _PermissionsStartOnlyProperty.setPermissionsStartOnly(permissionsStartOnly);
        sendPermissionsStartOnlyUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool ServiceStub::getPermissionsStartOnly() const {
    return _PermissionsStartOnlyProperty.getPermissionsStartOnly();
}

void ServiceStub::sendRootDirectoryStartOnlyUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        RootDirectoryStartOnlyUpdate payload(_RootDirectoryStartOnlyProperty);

        LOG_INFO ("-> send%s", "RootDirectoryStartOnlyUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("RootDirectoryStartOnly", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "RootDirectoryStartOnlyUpdate");
    }
}

void ServiceStub::onRootDirectoryStartOnlyGet(const ::boost::shared_ptr< RootDirectoryStartOnlyGet >& rootDirectoryStartOnly) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "RootDirectoryStartOnlyGet", rootDirectoryStartOnly->getAct());
    sendRootDirectoryStartOnlyGetUpdate(_RootDirectoryStartOnlyProperty.getRootDirectoryStartOnly(), rootDirectoryStartOnly->getAct());
}

void ServiceStub::sendRootDirectoryStartOnlyGetUpdate(bool rootDirectoryStartOnly, act_t act) {
    ::asf::dbus::DBusVariant variant;
    RootDirectoryStartOnlyGet payload(rootDirectoryStartOnly);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "RootDirectoryStartOnlyGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setRootDirectoryStartOnly(bool rootDirectoryStartOnly) {
    if(rootDirectoryStartOnly!=_RootDirectoryStartOnlyProperty.getRootDirectoryStartOnly()) {
        _RootDirectoryStartOnlyProperty.setRootDirectoryStartOnly(rootDirectoryStartOnly);
        sendRootDirectoryStartOnlyUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool ServiceStub::getRootDirectoryStartOnly() const {
    return _RootDirectoryStartOnlyProperty.getRootDirectoryStartOnly();
}

void ServiceStub::sendRemainAfterExitUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        RemainAfterExitUpdate payload(_RemainAfterExitProperty);

        LOG_INFO ("-> send%s", "RemainAfterExitUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("RemainAfterExit", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "RemainAfterExitUpdate");
    }
}

void ServiceStub::onRemainAfterExitGet(const ::boost::shared_ptr< RemainAfterExitGet >& remainAfterExit) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "RemainAfterExitGet", remainAfterExit->getAct());
    sendRemainAfterExitGetUpdate(_RemainAfterExitProperty.getRemainAfterExit(), remainAfterExit->getAct());
}

void ServiceStub::sendRemainAfterExitGetUpdate(bool remainAfterExit, act_t act) {
    ::asf::dbus::DBusVariant variant;
    RemainAfterExitGet payload(remainAfterExit);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "RemainAfterExitGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setRemainAfterExit(bool remainAfterExit) {
    if(remainAfterExit!=_RemainAfterExitProperty.getRemainAfterExit()) {
        _RemainAfterExitProperty.setRemainAfterExit(remainAfterExit);
        sendRemainAfterExitUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool ServiceStub::getRemainAfterExit() const {
    return _RemainAfterExitProperty.getRemainAfterExit();
}

void ServiceStub::sendGuessMainPIDUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        GuessMainPIDUpdate payload(_GuessMainPIDProperty);

        LOG_INFO ("-> send%s", "GuessMainPIDUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("GuessMainPID", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "GuessMainPIDUpdate");
    }
}

void ServiceStub::onGuessMainPIDGet(const ::boost::shared_ptr< GuessMainPIDGet >& guessMainPID) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "GuessMainPIDGet", guessMainPID->getAct());
    sendGuessMainPIDGetUpdate(_GuessMainPIDProperty.getGuessMainPID(), guessMainPID->getAct());
}

void ServiceStub::sendGuessMainPIDGetUpdate(bool guessMainPID, act_t act) {
    ::asf::dbus::DBusVariant variant;
    GuessMainPIDGet payload(guessMainPID);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "GuessMainPIDGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setGuessMainPID(bool guessMainPID) {
    if(guessMainPID!=_GuessMainPIDProperty.getGuessMainPID()) {
        _GuessMainPIDProperty.setGuessMainPID(guessMainPID);
        sendGuessMainPIDUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool ServiceStub::getGuessMainPID() const {
    return _GuessMainPIDProperty.getGuessMainPID();
}

void ServiceStub::sendMainPIDUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        MainPIDUpdate payload(_MainPIDProperty);

        LOG_INFO ("-> send%s", "MainPIDUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("MainPID", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "MainPIDUpdate");
    }
}

void ServiceStub::onMainPIDGet(const ::boost::shared_ptr< MainPIDGet >& mainPID) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "MainPIDGet", mainPID->getAct());
    sendMainPIDGetUpdate(_MainPIDProperty.getMainPID(), mainPID->getAct());
}

void ServiceStub::sendMainPIDGetUpdate(uint32 mainPID, act_t act) {
    ::asf::dbus::DBusVariant variant;
    MainPIDGet payload(mainPID);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "MainPIDGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setMainPID(uint32 mainPID) {
    if(mainPID!=_MainPIDProperty.getMainPID()) {
        _MainPIDProperty.setMainPID(mainPID);
        sendMainPIDUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint32 ServiceStub::getMainPID() const {
    return _MainPIDProperty.getMainPID();
}

void ServiceStub::sendControlPIDUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ControlPIDUpdate payload(_ControlPIDProperty);

        LOG_INFO ("-> send%s", "ControlPIDUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ControlPID", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ControlPIDUpdate");
    }
}

void ServiceStub::onControlPIDGet(const ::boost::shared_ptr< ControlPIDGet >& controlPID) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ControlPIDGet", controlPID->getAct());
    sendControlPIDGetUpdate(_ControlPIDProperty.getControlPID(), controlPID->getAct());
}

void ServiceStub::sendControlPIDGetUpdate(uint32 controlPID, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ControlPIDGet payload(controlPID);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ControlPIDGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setControlPID(uint32 controlPID) {
    if(controlPID!=_ControlPIDProperty.getControlPID()) {
        _ControlPIDProperty.setControlPID(controlPID);
        sendControlPIDUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint32 ServiceStub::getControlPID() const {
    return _ControlPIDProperty.getControlPID();
}

void ServiceStub::sendBusNameUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        BusNameUpdate payload(_BusNameProperty);

        LOG_INFO ("-> send%s", "BusNameUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("BusName", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "BusNameUpdate");
    }
}

void ServiceStub::onBusNameGet(const ::boost::shared_ptr< BusNameGet >& busName) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "BusNameGet", busName->getAct());
    sendBusNameGetUpdate(_BusNameProperty.getBusName(), busName->getAct());
}

void ServiceStub::sendBusNameGetUpdate(const ::std::string& busName, act_t act) {
    ::asf::dbus::DBusVariant variant;
    BusNameGet payload(busName);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "BusNameGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setBusName(const ::std::string& busName) {
    if(busName!=_BusNameProperty.getBusName()) {
        _BusNameProperty.setBusName(busName);
        sendBusNameUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& ServiceStub::getBusName() const {
    return _BusNameProperty.getBusName();
}

::std::string& ServiceStub::getBusNameMutable() {
    return _BusNameProperty.getBusNameMutable();
}

void ServiceStub::sendFileDescriptorStoreMaxUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        FileDescriptorStoreMaxUpdate payload(_FileDescriptorStoreMaxProperty);

        LOG_INFO ("-> send%s", "FileDescriptorStoreMaxUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("FileDescriptorStoreMax", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "FileDescriptorStoreMaxUpdate");
    }
}

void ServiceStub::onFileDescriptorStoreMaxGet(const ::boost::shared_ptr< FileDescriptorStoreMaxGet >& fileDescriptorStoreMax) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "FileDescriptorStoreMaxGet", fileDescriptorStoreMax->getAct());
    sendFileDescriptorStoreMaxGetUpdate(_FileDescriptorStoreMaxProperty.getFileDescriptorStoreMax(), fileDescriptorStoreMax->getAct());
}

void ServiceStub::sendFileDescriptorStoreMaxGetUpdate(uint32 fileDescriptorStoreMax, act_t act) {
    ::asf::dbus::DBusVariant variant;
    FileDescriptorStoreMaxGet payload(fileDescriptorStoreMax);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "FileDescriptorStoreMaxGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setFileDescriptorStoreMax(uint32 fileDescriptorStoreMax) {
    if(fileDescriptorStoreMax!=_FileDescriptorStoreMaxProperty.getFileDescriptorStoreMax()) {
        _FileDescriptorStoreMaxProperty.setFileDescriptorStoreMax(fileDescriptorStoreMax);
        sendFileDescriptorStoreMaxUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint32 ServiceStub::getFileDescriptorStoreMax() const {
    return _FileDescriptorStoreMaxProperty.getFileDescriptorStoreMax();
}

void ServiceStub::sendStatusTextUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        StatusTextUpdate payload(_StatusTextProperty);

        LOG_INFO ("-> send%s", "StatusTextUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("StatusText", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "StatusTextUpdate");
    }
}

void ServiceStub::onStatusTextGet(const ::boost::shared_ptr< StatusTextGet >& statusText) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "StatusTextGet", statusText->getAct());
    sendStatusTextGetUpdate(_StatusTextProperty.getStatusText(), statusText->getAct());
}

void ServiceStub::sendStatusTextGetUpdate(const ::std::string& statusText, act_t act) {
    ::asf::dbus::DBusVariant variant;
    StatusTextGet payload(statusText);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "StatusTextGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setStatusText(const ::std::string& statusText) {
    if(statusText!=_StatusTextProperty.getStatusText()) {
        _StatusTextProperty.setStatusText(statusText);
        sendStatusTextUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& ServiceStub::getStatusText() const {
    return _StatusTextProperty.getStatusText();
}

::std::string& ServiceStub::getStatusTextMutable() {
    return _StatusTextProperty.getStatusTextMutable();
}

void ServiceStub::sendStatusErrnoUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        StatusErrnoUpdate payload(_StatusErrnoProperty);

        LOG_INFO ("-> send%s", "StatusErrnoUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("StatusErrno", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "StatusErrnoUpdate");
    }
}

void ServiceStub::onStatusErrnoGet(const ::boost::shared_ptr< StatusErrnoGet >& statusErrno) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "StatusErrnoGet", statusErrno->getAct());
    sendStatusErrnoGetUpdate(_StatusErrnoProperty.getStatusErrno(), statusErrno->getAct());
}

void ServiceStub::sendStatusErrnoGetUpdate(int32 statusErrno, act_t act) {
    ::asf::dbus::DBusVariant variant;
    StatusErrnoGet payload(statusErrno);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "StatusErrnoGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setStatusErrno(int32 statusErrno) {
    if(statusErrno!=_StatusErrnoProperty.getStatusErrno()) {
        _StatusErrnoProperty.setStatusErrno(statusErrno);
        sendStatusErrnoUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

int32 ServiceStub::getStatusErrno() const {
    return _StatusErrnoProperty.getStatusErrno();
}

void ServiceStub::sendResultUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ResultUpdate payload(_ResultProperty);

        LOG_INFO ("-> send%s", "ResultUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Result", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ResultUpdate");
    }
}

void ServiceStub::onResultGet(const ::boost::shared_ptr< ResultGet >& result) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ResultGet", result->getAct());
    sendResultGetUpdate(_ResultProperty.getResult(), result->getAct());
}

void ServiceStub::sendResultGetUpdate(const ::std::string& result, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ResultGet payload(result);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ResultGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setResult(const ::std::string& result) {
    if(result!=_ResultProperty.getResult()) {
        _ResultProperty.setResult(result);
        sendResultUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& ServiceStub::getResult() const {
    return _ResultProperty.getResult();
}

::std::string& ServiceStub::getResultMutable() {
    return _ResultProperty.getResultMutable();
}

void ServiceStub::sendExecMainStartTimestampUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ExecMainStartTimestampUpdate payload(_ExecMainStartTimestampProperty);

        LOG_INFO ("-> send%s", "ExecMainStartTimestampUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ExecMainStartTimestamp", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ExecMainStartTimestampUpdate");
    }
}

void ServiceStub::onExecMainStartTimestampGet(const ::boost::shared_ptr< ExecMainStartTimestampGet >& execMainStartTimestamp) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ExecMainStartTimestampGet", execMainStartTimestamp->getAct());
    sendExecMainStartTimestampGetUpdate(_ExecMainStartTimestampProperty.getExecMainStartTimestamp(), execMainStartTimestamp->getAct());
}

void ServiceStub::sendExecMainStartTimestampGetUpdate(uint64 execMainStartTimestamp, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ExecMainStartTimestampGet payload(execMainStartTimestamp);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ExecMainStartTimestampGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setExecMainStartTimestamp(uint64 execMainStartTimestamp) {
    if(execMainStartTimestamp!=_ExecMainStartTimestampProperty.getExecMainStartTimestamp()) {
        _ExecMainStartTimestampProperty.setExecMainStartTimestamp(execMainStartTimestamp);
        sendExecMainStartTimestampUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ServiceStub::getExecMainStartTimestamp() const {
    return _ExecMainStartTimestampProperty.getExecMainStartTimestamp();
}

void ServiceStub::sendExecMainStartTimestampMonotonicUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ExecMainStartTimestampMonotonicUpdate payload(_ExecMainStartTimestampMonotonicProperty);

        LOG_INFO ("-> send%s", "ExecMainStartTimestampMonotonicUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ExecMainStartTimestampMonotonic", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ExecMainStartTimestampMonotonicUpdate");
    }
}

void ServiceStub::onExecMainStartTimestampMonotonicGet(const ::boost::shared_ptr< ExecMainStartTimestampMonotonicGet >& execMainStartTimestampMonotonic) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ExecMainStartTimestampMonotonicGet", execMainStartTimestampMonotonic->getAct());
    sendExecMainStartTimestampMonotonicGetUpdate(_ExecMainStartTimestampMonotonicProperty.getExecMainStartTimestampMonotonic(), execMainStartTimestampMonotonic->getAct());
}

void ServiceStub::sendExecMainStartTimestampMonotonicGetUpdate(uint64 execMainStartTimestampMonotonic, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ExecMainStartTimestampMonotonicGet payload(execMainStartTimestampMonotonic);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ExecMainStartTimestampMonotonicGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setExecMainStartTimestampMonotonic(uint64 execMainStartTimestampMonotonic) {
    if(execMainStartTimestampMonotonic!=_ExecMainStartTimestampMonotonicProperty.getExecMainStartTimestampMonotonic()) {
        _ExecMainStartTimestampMonotonicProperty.setExecMainStartTimestampMonotonic(execMainStartTimestampMonotonic);
        sendExecMainStartTimestampMonotonicUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ServiceStub::getExecMainStartTimestampMonotonic() const {
    return _ExecMainStartTimestampMonotonicProperty.getExecMainStartTimestampMonotonic();
}

void ServiceStub::sendExecMainExitTimestampUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ExecMainExitTimestampUpdate payload(_ExecMainExitTimestampProperty);

        LOG_INFO ("-> send%s", "ExecMainExitTimestampUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ExecMainExitTimestamp", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ExecMainExitTimestampUpdate");
    }
}

void ServiceStub::onExecMainExitTimestampGet(const ::boost::shared_ptr< ExecMainExitTimestampGet >& execMainExitTimestamp) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ExecMainExitTimestampGet", execMainExitTimestamp->getAct());
    sendExecMainExitTimestampGetUpdate(_ExecMainExitTimestampProperty.getExecMainExitTimestamp(), execMainExitTimestamp->getAct());
}

void ServiceStub::sendExecMainExitTimestampGetUpdate(uint64 execMainExitTimestamp, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ExecMainExitTimestampGet payload(execMainExitTimestamp);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ExecMainExitTimestampGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setExecMainExitTimestamp(uint64 execMainExitTimestamp) {
    if(execMainExitTimestamp!=_ExecMainExitTimestampProperty.getExecMainExitTimestamp()) {
        _ExecMainExitTimestampProperty.setExecMainExitTimestamp(execMainExitTimestamp);
        sendExecMainExitTimestampUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ServiceStub::getExecMainExitTimestamp() const {
    return _ExecMainExitTimestampProperty.getExecMainExitTimestamp();
}

void ServiceStub::sendExecMainExitTimestampMonotonicUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ExecMainExitTimestampMonotonicUpdate payload(_ExecMainExitTimestampMonotonicProperty);

        LOG_INFO ("-> send%s", "ExecMainExitTimestampMonotonicUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ExecMainExitTimestampMonotonic", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ExecMainExitTimestampMonotonicUpdate");
    }
}

void ServiceStub::onExecMainExitTimestampMonotonicGet(const ::boost::shared_ptr< ExecMainExitTimestampMonotonicGet >& execMainExitTimestampMonotonic) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ExecMainExitTimestampMonotonicGet", execMainExitTimestampMonotonic->getAct());
    sendExecMainExitTimestampMonotonicGetUpdate(_ExecMainExitTimestampMonotonicProperty.getExecMainExitTimestampMonotonic(), execMainExitTimestampMonotonic->getAct());
}

void ServiceStub::sendExecMainExitTimestampMonotonicGetUpdate(uint64 execMainExitTimestampMonotonic, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ExecMainExitTimestampMonotonicGet payload(execMainExitTimestampMonotonic);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ExecMainExitTimestampMonotonicGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setExecMainExitTimestampMonotonic(uint64 execMainExitTimestampMonotonic) {
    if(execMainExitTimestampMonotonic!=_ExecMainExitTimestampMonotonicProperty.getExecMainExitTimestampMonotonic()) {
        _ExecMainExitTimestampMonotonicProperty.setExecMainExitTimestampMonotonic(execMainExitTimestampMonotonic);
        sendExecMainExitTimestampMonotonicUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ServiceStub::getExecMainExitTimestampMonotonic() const {
    return _ExecMainExitTimestampMonotonicProperty.getExecMainExitTimestampMonotonic();
}

void ServiceStub::sendExecMainPIDUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ExecMainPIDUpdate payload(_ExecMainPIDProperty);

        LOG_INFO ("-> send%s", "ExecMainPIDUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ExecMainPID", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ExecMainPIDUpdate");
    }
}

void ServiceStub::onExecMainPIDGet(const ::boost::shared_ptr< ExecMainPIDGet >& execMainPID) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ExecMainPIDGet", execMainPID->getAct());
    sendExecMainPIDGetUpdate(_ExecMainPIDProperty.getExecMainPID(), execMainPID->getAct());
}

void ServiceStub::sendExecMainPIDGetUpdate(uint32 execMainPID, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ExecMainPIDGet payload(execMainPID);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ExecMainPIDGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setExecMainPID(uint32 execMainPID) {
    if(execMainPID!=_ExecMainPIDProperty.getExecMainPID()) {
        _ExecMainPIDProperty.setExecMainPID(execMainPID);
        sendExecMainPIDUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint32 ServiceStub::getExecMainPID() const {
    return _ExecMainPIDProperty.getExecMainPID();
}

void ServiceStub::sendExecMainCodeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ExecMainCodeUpdate payload(_ExecMainCodeProperty);

        LOG_INFO ("-> send%s", "ExecMainCodeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ExecMainCode", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ExecMainCodeUpdate");
    }
}

void ServiceStub::onExecMainCodeGet(const ::boost::shared_ptr< ExecMainCodeGet >& execMainCode) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ExecMainCodeGet", execMainCode->getAct());
    sendExecMainCodeGetUpdate(_ExecMainCodeProperty.getExecMainCode(), execMainCode->getAct());
}

void ServiceStub::sendExecMainCodeGetUpdate(int32 execMainCode, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ExecMainCodeGet payload(execMainCode);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ExecMainCodeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setExecMainCode(int32 execMainCode) {
    if(execMainCode!=_ExecMainCodeProperty.getExecMainCode()) {
        _ExecMainCodeProperty.setExecMainCode(execMainCode);
        sendExecMainCodeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

int32 ServiceStub::getExecMainCode() const {
    return _ExecMainCodeProperty.getExecMainCode();
}

void ServiceStub::sendExecMainStatusUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ExecMainStatusUpdate payload(_ExecMainStatusProperty);

        LOG_INFO ("-> send%s", "ExecMainStatusUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ExecMainStatus", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ExecMainStatusUpdate");
    }
}

void ServiceStub::onExecMainStatusGet(const ::boost::shared_ptr< ExecMainStatusGet >& execMainStatus) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ExecMainStatusGet", execMainStatus->getAct());
    sendExecMainStatusGetUpdate(_ExecMainStatusProperty.getExecMainStatus(), execMainStatus->getAct());
}

void ServiceStub::sendExecMainStatusGetUpdate(int32 execMainStatus, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ExecMainStatusGet payload(execMainStatus);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ExecMainStatusGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setExecMainStatus(int32 execMainStatus) {
    if(execMainStatus!=_ExecMainStatusProperty.getExecMainStatus()) {
        _ExecMainStatusProperty.setExecMainStatus(execMainStatus);
        sendExecMainStatusUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

int32 ServiceStub::getExecMainStatus() const {
    return _ExecMainStatusProperty.getExecMainStatus();
}

void ServiceStub::sendExecStartPreUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ExecStartPreUpdate payload(_ExecStartPreProperty);

        LOG_INFO ("-> send%s", "ExecStartPreUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ExecStartPre", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ExecStartPreUpdate");
    }
}

void ServiceStub::onExecStartPreGet(const ::boost::shared_ptr< ExecStartPreGet >& execStartPre) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ExecStartPreGet", execStartPre->getAct());
    sendExecStartPreGetUpdate(_ExecStartPreProperty.getExecStartPre(), execStartPre->getAct());
}

void ServiceStub::sendExecStartPreGetUpdate(const ::std::vector< execData >& execStartPre, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ExecStartPreGet payload(execStartPre);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ExecStartPreGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setExecStartPre(const ::std::vector< execData >& execStartPre) {
    if(execStartPre!=_ExecStartPreProperty.getExecStartPre()) {
        _ExecStartPreProperty.setExecStartPre(execStartPre);
        sendExecStartPreUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< execData >& ServiceStub::getExecStartPre() const {
    return _ExecStartPreProperty.getExecStartPre();
}

::std::vector< execData >& ServiceStub::getExecStartPreMutable() {
    return _ExecStartPreProperty.getExecStartPreMutable();
}

void ServiceStub::sendExecStartUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ExecStartUpdate payload(_ExecStartProperty);

        LOG_INFO ("-> send%s", "ExecStartUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ExecStart", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ExecStartUpdate");
    }
}

void ServiceStub::onExecStartGet(const ::boost::shared_ptr< ExecStartGet >& execStart) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ExecStartGet", execStart->getAct());
    sendExecStartGetUpdate(_ExecStartProperty.getExecStart(), execStart->getAct());
}

void ServiceStub::sendExecStartGetUpdate(const ::std::vector< execData >& execStart, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ExecStartGet payload(execStart);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ExecStartGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setExecStart(const ::std::vector< execData >& execStart) {
    if(execStart!=_ExecStartProperty.getExecStart()) {
        _ExecStartProperty.setExecStart(execStart);
        sendExecStartUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< execData >& ServiceStub::getExecStart() const {
    return _ExecStartProperty.getExecStart();
}

::std::vector< execData >& ServiceStub::getExecStartMutable() {
    return _ExecStartProperty.getExecStartMutable();
}

void ServiceStub::sendExecStartPostUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ExecStartPostUpdate payload(_ExecStartPostProperty);

        LOG_INFO ("-> send%s", "ExecStartPostUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ExecStartPost", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ExecStartPostUpdate");
    }
}

void ServiceStub::onExecStartPostGet(const ::boost::shared_ptr< ExecStartPostGet >& execStartPost) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ExecStartPostGet", execStartPost->getAct());
    sendExecStartPostGetUpdate(_ExecStartPostProperty.getExecStartPost(), execStartPost->getAct());
}

void ServiceStub::sendExecStartPostGetUpdate(const ::std::vector< execData >& execStartPost, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ExecStartPostGet payload(execStartPost);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ExecStartPostGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setExecStartPost(const ::std::vector< execData >& execStartPost) {
    if(execStartPost!=_ExecStartPostProperty.getExecStartPost()) {
        _ExecStartPostProperty.setExecStartPost(execStartPost);
        sendExecStartPostUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< execData >& ServiceStub::getExecStartPost() const {
    return _ExecStartPostProperty.getExecStartPost();
}

::std::vector< execData >& ServiceStub::getExecStartPostMutable() {
    return _ExecStartPostProperty.getExecStartPostMutable();
}

void ServiceStub::sendExecReloadUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ExecReloadUpdate payload(_ExecReloadProperty);

        LOG_INFO ("-> send%s", "ExecReloadUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ExecReload", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ExecReloadUpdate");
    }
}

void ServiceStub::onExecReloadGet(const ::boost::shared_ptr< ExecReloadGet >& execReload) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ExecReloadGet", execReload->getAct());
    sendExecReloadGetUpdate(_ExecReloadProperty.getExecReload(), execReload->getAct());
}

void ServiceStub::sendExecReloadGetUpdate(const ::std::vector< execData >& execReload, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ExecReloadGet payload(execReload);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ExecReloadGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setExecReload(const ::std::vector< execData >& execReload) {
    if(execReload!=_ExecReloadProperty.getExecReload()) {
        _ExecReloadProperty.setExecReload(execReload);
        sendExecReloadUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< execData >& ServiceStub::getExecReload() const {
    return _ExecReloadProperty.getExecReload();
}

::std::vector< execData >& ServiceStub::getExecReloadMutable() {
    return _ExecReloadProperty.getExecReloadMutable();
}

void ServiceStub::sendExecStopUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ExecStopUpdate payload(_ExecStopProperty);

        LOG_INFO ("-> send%s", "ExecStopUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ExecStop", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ExecStopUpdate");
    }
}

void ServiceStub::onExecStopGet(const ::boost::shared_ptr< ExecStopGet >& execStop) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ExecStopGet", execStop->getAct());
    sendExecStopGetUpdate(_ExecStopProperty.getExecStop(), execStop->getAct());
}

void ServiceStub::sendExecStopGetUpdate(const ::std::vector< execData >& execStop, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ExecStopGet payload(execStop);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ExecStopGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setExecStop(const ::std::vector< execData >& execStop) {
    if(execStop!=_ExecStopProperty.getExecStop()) {
        _ExecStopProperty.setExecStop(execStop);
        sendExecStopUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< execData >& ServiceStub::getExecStop() const {
    return _ExecStopProperty.getExecStop();
}

::std::vector< execData >& ServiceStub::getExecStopMutable() {
    return _ExecStopProperty.getExecStopMutable();
}

void ServiceStub::sendExecStopPostUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ExecStopPostUpdate payload(_ExecStopPostProperty);

        LOG_INFO ("-> send%s", "ExecStopPostUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ExecStopPost", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ExecStopPostUpdate");
    }
}

void ServiceStub::onExecStopPostGet(const ::boost::shared_ptr< ExecStopPostGet >& execStopPost) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ExecStopPostGet", execStopPost->getAct());
    sendExecStopPostGetUpdate(_ExecStopPostProperty.getExecStopPost(), execStopPost->getAct());
}

void ServiceStub::sendExecStopPostGetUpdate(const ::std::vector< execData >& execStopPost, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ExecStopPostGet payload(execStopPost);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ExecStopPostGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setExecStopPost(const ::std::vector< execData >& execStopPost) {
    if(execStopPost!=_ExecStopPostProperty.getExecStopPost()) {
        _ExecStopPostProperty.setExecStopPost(execStopPost);
        sendExecStopPostUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< execData >& ServiceStub::getExecStopPost() const {
    return _ExecStopPostProperty.getExecStopPost();
}

::std::vector< execData >& ServiceStub::getExecStopPostMutable() {
    return _ExecStopPostProperty.getExecStopPostMutable();
}

void ServiceStub::sendSliceUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SliceUpdate payload(_SliceProperty);

        LOG_INFO ("-> send%s", "SliceUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Slice", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SliceUpdate");
    }
}

void ServiceStub::onSliceGet(const ::boost::shared_ptr< SliceGet >& slice) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SliceGet", slice->getAct());
    sendSliceGetUpdate(_SliceProperty.getSlice(), slice->getAct());
}

void ServiceStub::sendSliceGetUpdate(const ::std::string& slice, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SliceGet payload(slice);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SliceGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setSlice(const ::std::string& slice) {
    if(slice!=_SliceProperty.getSlice()) {
        _SliceProperty.setSlice(slice);
        sendSliceUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& ServiceStub::getSlice() const {
    return _SliceProperty.getSlice();
}

::std::string& ServiceStub::getSliceMutable() {
    return _SliceProperty.getSliceMutable();
}

void ServiceStub::sendControlGroupUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ControlGroupUpdate payload(_ControlGroupProperty);

        LOG_INFO ("-> send%s", "ControlGroupUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ControlGroup", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ControlGroupUpdate");
    }
}

void ServiceStub::onControlGroupGet(const ::boost::shared_ptr< ControlGroupGet >& controlGroup) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ControlGroupGet", controlGroup->getAct());
    sendControlGroupGetUpdate(_ControlGroupProperty.getControlGroup(), controlGroup->getAct());
}

void ServiceStub::sendControlGroupGetUpdate(const ::std::string& controlGroup, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ControlGroupGet payload(controlGroup);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ControlGroupGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setControlGroup(const ::std::string& controlGroup) {
    if(controlGroup!=_ControlGroupProperty.getControlGroup()) {
        _ControlGroupProperty.setControlGroup(controlGroup);
        sendControlGroupUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& ServiceStub::getControlGroup() const {
    return _ControlGroupProperty.getControlGroup();
}

::std::string& ServiceStub::getControlGroupMutable() {
    return _ControlGroupProperty.getControlGroupMutable();
}

void ServiceStub::sendMemoryCurrentUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        MemoryCurrentUpdate payload(_MemoryCurrentProperty);

        LOG_INFO ("-> send%s", "MemoryCurrentUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("MemoryCurrent", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "MemoryCurrentUpdate");
    }
}

void ServiceStub::onMemoryCurrentGet(const ::boost::shared_ptr< MemoryCurrentGet >& memoryCurrent) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "MemoryCurrentGet", memoryCurrent->getAct());
    sendMemoryCurrentGetUpdate(_MemoryCurrentProperty.getMemoryCurrent(), memoryCurrent->getAct());
}

void ServiceStub::sendMemoryCurrentGetUpdate(uint64 memoryCurrent, act_t act) {
    ::asf::dbus::DBusVariant variant;
    MemoryCurrentGet payload(memoryCurrent);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "MemoryCurrentGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setMemoryCurrent(uint64 memoryCurrent) {
    if(memoryCurrent!=_MemoryCurrentProperty.getMemoryCurrent()) {
        _MemoryCurrentProperty.setMemoryCurrent(memoryCurrent);
        sendMemoryCurrentUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ServiceStub::getMemoryCurrent() const {
    return _MemoryCurrentProperty.getMemoryCurrent();
}

void ServiceStub::sendCPUUsageNSecUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        CPUUsageNSecUpdate payload(_CPUUsageNSecProperty);

        LOG_INFO ("-> send%s", "CPUUsageNSecUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("CPUUsageNSec", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "CPUUsageNSecUpdate");
    }
}

void ServiceStub::onCPUUsageNSecGet(const ::boost::shared_ptr< CPUUsageNSecGet >& cPUUsageNSec) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "CPUUsageNSecGet", cPUUsageNSec->getAct());
    sendCPUUsageNSecGetUpdate(_CPUUsageNSecProperty.getCPUUsageNSec(), cPUUsageNSec->getAct());
}

void ServiceStub::sendCPUUsageNSecGetUpdate(uint64 cPUUsageNSec, act_t act) {
    ::asf::dbus::DBusVariant variant;
    CPUUsageNSecGet payload(cPUUsageNSec);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "CPUUsageNSecGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setCPUUsageNSec(uint64 cPUUsageNSec) {
    if(cPUUsageNSec!=_CPUUsageNSecProperty.getCPUUsageNSec()) {
        _CPUUsageNSecProperty.setCPUUsageNSec(cPUUsageNSec);
        sendCPUUsageNSecUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ServiceStub::getCPUUsageNSec() const {
    return _CPUUsageNSecProperty.getCPUUsageNSec();
}

void ServiceStub::sendDelegateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        DelegateUpdate payload(_DelegateProperty);

        LOG_INFO ("-> send%s", "DelegateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Delegate", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "DelegateUpdate");
    }
}

void ServiceStub::onDelegateGet(const ::boost::shared_ptr< DelegateGet >& delegate) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DelegateGet", delegate->getAct());
    sendDelegateGetUpdate(_DelegateProperty.getDelegate(), delegate->getAct());
}

void ServiceStub::sendDelegateGetUpdate(bool delegate, act_t act) {
    ::asf::dbus::DBusVariant variant;
    DelegateGet payload(delegate);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DelegateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setDelegate(bool delegate) {
    if(delegate!=_DelegateProperty.getDelegate()) {
        _DelegateProperty.setDelegate(delegate);
        sendDelegateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool ServiceStub::getDelegate() const {
    return _DelegateProperty.getDelegate();
}

void ServiceStub::sendCPUAccountingUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        CPUAccountingUpdate payload(_CPUAccountingProperty);

        LOG_INFO ("-> send%s", "CPUAccountingUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("CPUAccounting", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "CPUAccountingUpdate");
    }
}

void ServiceStub::onCPUAccountingGet(const ::boost::shared_ptr< CPUAccountingGet >& cPUAccounting) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "CPUAccountingGet", cPUAccounting->getAct());
    sendCPUAccountingGetUpdate(_CPUAccountingProperty.getCPUAccounting(), cPUAccounting->getAct());
}

void ServiceStub::sendCPUAccountingGetUpdate(bool cPUAccounting, act_t act) {
    ::asf::dbus::DBusVariant variant;
    CPUAccountingGet payload(cPUAccounting);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "CPUAccountingGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setCPUAccounting(bool cPUAccounting) {
    if(cPUAccounting!=_CPUAccountingProperty.getCPUAccounting()) {
        _CPUAccountingProperty.setCPUAccounting(cPUAccounting);
        sendCPUAccountingUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool ServiceStub::getCPUAccounting() const {
    return _CPUAccountingProperty.getCPUAccounting();
}

void ServiceStub::sendCPUSharesUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        CPUSharesUpdate payload(_CPUSharesProperty);

        LOG_INFO ("-> send%s", "CPUSharesUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("CPUShares", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "CPUSharesUpdate");
    }
}

void ServiceStub::onCPUSharesGet(const ::boost::shared_ptr< CPUSharesGet >& cPUShares) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "CPUSharesGet", cPUShares->getAct());
    sendCPUSharesGetUpdate(_CPUSharesProperty.getCPUShares(), cPUShares->getAct());
}

void ServiceStub::sendCPUSharesGetUpdate(uint64 cPUShares, act_t act) {
    ::asf::dbus::DBusVariant variant;
    CPUSharesGet payload(cPUShares);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "CPUSharesGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setCPUShares(uint64 cPUShares) {
    if(cPUShares!=_CPUSharesProperty.getCPUShares()) {
        _CPUSharesProperty.setCPUShares(cPUShares);
        sendCPUSharesUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ServiceStub::getCPUShares() const {
    return _CPUSharesProperty.getCPUShares();
}

void ServiceStub::sendStartupCPUSharesUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        StartupCPUSharesUpdate payload(_StartupCPUSharesProperty);

        LOG_INFO ("-> send%s", "StartupCPUSharesUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("StartupCPUShares", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "StartupCPUSharesUpdate");
    }
}

void ServiceStub::onStartupCPUSharesGet(const ::boost::shared_ptr< StartupCPUSharesGet >& startupCPUShares) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "StartupCPUSharesGet", startupCPUShares->getAct());
    sendStartupCPUSharesGetUpdate(_StartupCPUSharesProperty.getStartupCPUShares(), startupCPUShares->getAct());
}

void ServiceStub::sendStartupCPUSharesGetUpdate(uint64 startupCPUShares, act_t act) {
    ::asf::dbus::DBusVariant variant;
    StartupCPUSharesGet payload(startupCPUShares);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "StartupCPUSharesGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setStartupCPUShares(uint64 startupCPUShares) {
    if(startupCPUShares!=_StartupCPUSharesProperty.getStartupCPUShares()) {
        _StartupCPUSharesProperty.setStartupCPUShares(startupCPUShares);
        sendStartupCPUSharesUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ServiceStub::getStartupCPUShares() const {
    return _StartupCPUSharesProperty.getStartupCPUShares();
}

void ServiceStub::sendCPUQuotaPerSecUSecUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        CPUQuotaPerSecUSecUpdate payload(_CPUQuotaPerSecUSecProperty);

        LOG_INFO ("-> send%s", "CPUQuotaPerSecUSecUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("CPUQuotaPerSecUSec", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "CPUQuotaPerSecUSecUpdate");
    }
}

void ServiceStub::onCPUQuotaPerSecUSecGet(const ::boost::shared_ptr< CPUQuotaPerSecUSecGet >& cPUQuotaPerSecUSec) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "CPUQuotaPerSecUSecGet", cPUQuotaPerSecUSec->getAct());
    sendCPUQuotaPerSecUSecGetUpdate(_CPUQuotaPerSecUSecProperty.getCPUQuotaPerSecUSec(), cPUQuotaPerSecUSec->getAct());
}

void ServiceStub::sendCPUQuotaPerSecUSecGetUpdate(uint64 cPUQuotaPerSecUSec, act_t act) {
    ::asf::dbus::DBusVariant variant;
    CPUQuotaPerSecUSecGet payload(cPUQuotaPerSecUSec);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "CPUQuotaPerSecUSecGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setCPUQuotaPerSecUSec(uint64 cPUQuotaPerSecUSec) {
    if(cPUQuotaPerSecUSec!=_CPUQuotaPerSecUSecProperty.getCPUQuotaPerSecUSec()) {
        _CPUQuotaPerSecUSecProperty.setCPUQuotaPerSecUSec(cPUQuotaPerSecUSec);
        sendCPUQuotaPerSecUSecUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ServiceStub::getCPUQuotaPerSecUSec() const {
    return _CPUQuotaPerSecUSecProperty.getCPUQuotaPerSecUSec();
}

void ServiceStub::sendBlockIOAccountingUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        BlockIOAccountingUpdate payload(_BlockIOAccountingProperty);

        LOG_INFO ("-> send%s", "BlockIOAccountingUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("BlockIOAccounting", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "BlockIOAccountingUpdate");
    }
}

void ServiceStub::onBlockIOAccountingGet(const ::boost::shared_ptr< BlockIOAccountingGet >& blockIOAccounting) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "BlockIOAccountingGet", blockIOAccounting->getAct());
    sendBlockIOAccountingGetUpdate(_BlockIOAccountingProperty.getBlockIOAccounting(), blockIOAccounting->getAct());
}

void ServiceStub::sendBlockIOAccountingGetUpdate(bool blockIOAccounting, act_t act) {
    ::asf::dbus::DBusVariant variant;
    BlockIOAccountingGet payload(blockIOAccounting);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "BlockIOAccountingGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setBlockIOAccounting(bool blockIOAccounting) {
    if(blockIOAccounting!=_BlockIOAccountingProperty.getBlockIOAccounting()) {
        _BlockIOAccountingProperty.setBlockIOAccounting(blockIOAccounting);
        sendBlockIOAccountingUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool ServiceStub::getBlockIOAccounting() const {
    return _BlockIOAccountingProperty.getBlockIOAccounting();
}

void ServiceStub::sendBlockIOWeightUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        BlockIOWeightUpdate payload(_BlockIOWeightProperty);

        LOG_INFO ("-> send%s", "BlockIOWeightUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("BlockIOWeight", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "BlockIOWeightUpdate");
    }
}

void ServiceStub::onBlockIOWeightGet(const ::boost::shared_ptr< BlockIOWeightGet >& blockIOWeight) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "BlockIOWeightGet", blockIOWeight->getAct());
    sendBlockIOWeightGetUpdate(_BlockIOWeightProperty.getBlockIOWeight(), blockIOWeight->getAct());
}

void ServiceStub::sendBlockIOWeightGetUpdate(uint64 blockIOWeight, act_t act) {
    ::asf::dbus::DBusVariant variant;
    BlockIOWeightGet payload(blockIOWeight);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "BlockIOWeightGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setBlockIOWeight(uint64 blockIOWeight) {
    if(blockIOWeight!=_BlockIOWeightProperty.getBlockIOWeight()) {
        _BlockIOWeightProperty.setBlockIOWeight(blockIOWeight);
        sendBlockIOWeightUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ServiceStub::getBlockIOWeight() const {
    return _BlockIOWeightProperty.getBlockIOWeight();
}

void ServiceStub::sendStartupBlockIOWeightUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        StartupBlockIOWeightUpdate payload(_StartupBlockIOWeightProperty);

        LOG_INFO ("-> send%s", "StartupBlockIOWeightUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("StartupBlockIOWeight", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "StartupBlockIOWeightUpdate");
    }
}

void ServiceStub::onStartupBlockIOWeightGet(const ::boost::shared_ptr< StartupBlockIOWeightGet >& startupBlockIOWeight) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "StartupBlockIOWeightGet", startupBlockIOWeight->getAct());
    sendStartupBlockIOWeightGetUpdate(_StartupBlockIOWeightProperty.getStartupBlockIOWeight(), startupBlockIOWeight->getAct());
}

void ServiceStub::sendStartupBlockIOWeightGetUpdate(uint64 startupBlockIOWeight, act_t act) {
    ::asf::dbus::DBusVariant variant;
    StartupBlockIOWeightGet payload(startupBlockIOWeight);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "StartupBlockIOWeightGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setStartupBlockIOWeight(uint64 startupBlockIOWeight) {
    if(startupBlockIOWeight!=_StartupBlockIOWeightProperty.getStartupBlockIOWeight()) {
        _StartupBlockIOWeightProperty.setStartupBlockIOWeight(startupBlockIOWeight);
        sendStartupBlockIOWeightUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ServiceStub::getStartupBlockIOWeight() const {
    return _StartupBlockIOWeightProperty.getStartupBlockIOWeight();
}

void ServiceStub::sendBlockIODeviceWeightUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        BlockIODeviceWeightUpdate payload(_BlockIODeviceWeightProperty);

        LOG_INFO ("-> send%s", "BlockIODeviceWeightUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("BlockIODeviceWeight", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "BlockIODeviceWeightUpdate");
    }
}

void ServiceStub::onBlockIODeviceWeightGet(const ::boost::shared_ptr< BlockIODeviceWeightGet >& blockIODeviceWeight) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "BlockIODeviceWeightGet", blockIODeviceWeight->getAct());
    sendBlockIODeviceWeightGetUpdate(_BlockIODeviceWeightProperty.getBlockIODeviceWeight(), blockIODeviceWeight->getAct());
}

void ServiceStub::sendBlockIODeviceWeightGetUpdate(const ::std::vector< blockIOData >& blockIODeviceWeight, act_t act) {
    ::asf::dbus::DBusVariant variant;
    BlockIODeviceWeightGet payload(blockIODeviceWeight);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "BlockIODeviceWeightGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setBlockIODeviceWeight(const ::std::vector< blockIOData >& blockIODeviceWeight) {
    if(blockIODeviceWeight!=_BlockIODeviceWeightProperty.getBlockIODeviceWeight()) {
        _BlockIODeviceWeightProperty.setBlockIODeviceWeight(blockIODeviceWeight);
        sendBlockIODeviceWeightUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< blockIOData >& ServiceStub::getBlockIODeviceWeight() const {
    return _BlockIODeviceWeightProperty.getBlockIODeviceWeight();
}

::std::vector< blockIOData >& ServiceStub::getBlockIODeviceWeightMutable() {
    return _BlockIODeviceWeightProperty.getBlockIODeviceWeightMutable();
}

void ServiceStub::sendBlockIOReadBandwidthUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        BlockIOReadBandwidthUpdate payload(_BlockIOReadBandwidthProperty);

        LOG_INFO ("-> send%s", "BlockIOReadBandwidthUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("BlockIOReadBandwidth", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "BlockIOReadBandwidthUpdate");
    }
}

void ServiceStub::onBlockIOReadBandwidthGet(const ::boost::shared_ptr< BlockIOReadBandwidthGet >& blockIOReadBandwidth) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "BlockIOReadBandwidthGet", blockIOReadBandwidth->getAct());
    sendBlockIOReadBandwidthGetUpdate(_BlockIOReadBandwidthProperty.getBlockIOReadBandwidth(), blockIOReadBandwidth->getAct());
}

void ServiceStub::sendBlockIOReadBandwidthGetUpdate(const ::std::vector< blockIOData >& blockIOReadBandwidth, act_t act) {
    ::asf::dbus::DBusVariant variant;
    BlockIOReadBandwidthGet payload(blockIOReadBandwidth);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "BlockIOReadBandwidthGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setBlockIOReadBandwidth(const ::std::vector< blockIOData >& blockIOReadBandwidth) {
    if(blockIOReadBandwidth!=_BlockIOReadBandwidthProperty.getBlockIOReadBandwidth()) {
        _BlockIOReadBandwidthProperty.setBlockIOReadBandwidth(blockIOReadBandwidth);
        sendBlockIOReadBandwidthUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< blockIOData >& ServiceStub::getBlockIOReadBandwidth() const {
    return _BlockIOReadBandwidthProperty.getBlockIOReadBandwidth();
}

::std::vector< blockIOData >& ServiceStub::getBlockIOReadBandwidthMutable() {
    return _BlockIOReadBandwidthProperty.getBlockIOReadBandwidthMutable();
}

void ServiceStub::sendBlockIOWriteBandwidthUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        BlockIOWriteBandwidthUpdate payload(_BlockIOWriteBandwidthProperty);

        LOG_INFO ("-> send%s", "BlockIOWriteBandwidthUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("BlockIOWriteBandwidth", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "BlockIOWriteBandwidthUpdate");
    }
}

void ServiceStub::onBlockIOWriteBandwidthGet(const ::boost::shared_ptr< BlockIOWriteBandwidthGet >& blockIOWriteBandwidth) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "BlockIOWriteBandwidthGet", blockIOWriteBandwidth->getAct());
    sendBlockIOWriteBandwidthGetUpdate(_BlockIOWriteBandwidthProperty.getBlockIOWriteBandwidth(), blockIOWriteBandwidth->getAct());
}

void ServiceStub::sendBlockIOWriteBandwidthGetUpdate(const ::std::vector< blockIOData >& blockIOWriteBandwidth, act_t act) {
    ::asf::dbus::DBusVariant variant;
    BlockIOWriteBandwidthGet payload(blockIOWriteBandwidth);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "BlockIOWriteBandwidthGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setBlockIOWriteBandwidth(const ::std::vector< blockIOData >& blockIOWriteBandwidth) {
    if(blockIOWriteBandwidth!=_BlockIOWriteBandwidthProperty.getBlockIOWriteBandwidth()) {
        _BlockIOWriteBandwidthProperty.setBlockIOWriteBandwidth(blockIOWriteBandwidth);
        sendBlockIOWriteBandwidthUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< blockIOData >& ServiceStub::getBlockIOWriteBandwidth() const {
    return _BlockIOWriteBandwidthProperty.getBlockIOWriteBandwidth();
}

::std::vector< blockIOData >& ServiceStub::getBlockIOWriteBandwidthMutable() {
    return _BlockIOWriteBandwidthProperty.getBlockIOWriteBandwidthMutable();
}

void ServiceStub::sendMemoryAccountingUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        MemoryAccountingUpdate payload(_MemoryAccountingProperty);

        LOG_INFO ("-> send%s", "MemoryAccountingUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("MemoryAccounting", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "MemoryAccountingUpdate");
    }
}

void ServiceStub::onMemoryAccountingGet(const ::boost::shared_ptr< MemoryAccountingGet >& memoryAccounting) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "MemoryAccountingGet", memoryAccounting->getAct());
    sendMemoryAccountingGetUpdate(_MemoryAccountingProperty.getMemoryAccounting(), memoryAccounting->getAct());
}

void ServiceStub::sendMemoryAccountingGetUpdate(bool memoryAccounting, act_t act) {
    ::asf::dbus::DBusVariant variant;
    MemoryAccountingGet payload(memoryAccounting);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "MemoryAccountingGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setMemoryAccounting(bool memoryAccounting) {
    if(memoryAccounting!=_MemoryAccountingProperty.getMemoryAccounting()) {
        _MemoryAccountingProperty.setMemoryAccounting(memoryAccounting);
        sendMemoryAccountingUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool ServiceStub::getMemoryAccounting() const {
    return _MemoryAccountingProperty.getMemoryAccounting();
}

void ServiceStub::sendMemoryLimitUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        MemoryLimitUpdate payload(_MemoryLimitProperty);

        LOG_INFO ("-> send%s", "MemoryLimitUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("MemoryLimit", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "MemoryLimitUpdate");
    }
}

void ServiceStub::onMemoryLimitGet(const ::boost::shared_ptr< MemoryLimitGet >& memoryLimit) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "MemoryLimitGet", memoryLimit->getAct());
    sendMemoryLimitGetUpdate(_MemoryLimitProperty.getMemoryLimit(), memoryLimit->getAct());
}

void ServiceStub::sendMemoryLimitGetUpdate(uint64 memoryLimit, act_t act) {
    ::asf::dbus::DBusVariant variant;
    MemoryLimitGet payload(memoryLimit);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "MemoryLimitGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setMemoryLimit(uint64 memoryLimit) {
    if(memoryLimit!=_MemoryLimitProperty.getMemoryLimit()) {
        _MemoryLimitProperty.setMemoryLimit(memoryLimit);
        sendMemoryLimitUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ServiceStub::getMemoryLimit() const {
    return _MemoryLimitProperty.getMemoryLimit();
}

void ServiceStub::sendDevicePolicyUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        DevicePolicyUpdate payload(_DevicePolicyProperty);

        LOG_INFO ("-> send%s", "DevicePolicyUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("DevicePolicy", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "DevicePolicyUpdate");
    }
}

void ServiceStub::onDevicePolicyGet(const ::boost::shared_ptr< DevicePolicyGet >& devicePolicy) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DevicePolicyGet", devicePolicy->getAct());
    sendDevicePolicyGetUpdate(_DevicePolicyProperty.getDevicePolicy(), devicePolicy->getAct());
}

void ServiceStub::sendDevicePolicyGetUpdate(const ::std::string& devicePolicy, act_t act) {
    ::asf::dbus::DBusVariant variant;
    DevicePolicyGet payload(devicePolicy);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DevicePolicyGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setDevicePolicy(const ::std::string& devicePolicy) {
    if(devicePolicy!=_DevicePolicyProperty.getDevicePolicy()) {
        _DevicePolicyProperty.setDevicePolicy(devicePolicy);
        sendDevicePolicyUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& ServiceStub::getDevicePolicy() const {
    return _DevicePolicyProperty.getDevicePolicy();
}

::std::string& ServiceStub::getDevicePolicyMutable() {
    return _DevicePolicyProperty.getDevicePolicyMutable();
}

void ServiceStub::sendDeviceAllowUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        DeviceAllowUpdate payload(_DeviceAllowProperty);

        LOG_INFO ("-> send%s", "DeviceAllowUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("DeviceAllow", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "DeviceAllowUpdate");
    }
}

void ServiceStub::onDeviceAllowGet(const ::boost::shared_ptr< DeviceAllowGet >& deviceAllow) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DeviceAllowGet", deviceAllow->getAct());
    sendDeviceAllowGetUpdate(_DeviceAllowProperty.getDeviceAllow(), deviceAllow->getAct());
}

void ServiceStub::sendDeviceAllowGetUpdate(const ::std::vector< deviceNode >& deviceAllow, act_t act) {
    ::asf::dbus::DBusVariant variant;
    DeviceAllowGet payload(deviceAllow);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DeviceAllowGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setDeviceAllow(const ::std::vector< deviceNode >& deviceAllow) {
    if(deviceAllow!=_DeviceAllowProperty.getDeviceAllow()) {
        _DeviceAllowProperty.setDeviceAllow(deviceAllow);
        sendDeviceAllowUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< deviceNode >& ServiceStub::getDeviceAllow() const {
    return _DeviceAllowProperty.getDeviceAllow();
}

::std::vector< deviceNode >& ServiceStub::getDeviceAllowMutable() {
    return _DeviceAllowProperty.getDeviceAllowMutable();
}

void ServiceStub::sendEnvironmentUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        EnvironmentUpdate payload(_EnvironmentProperty);

        LOG_INFO ("-> send%s", "EnvironmentUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Environment", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "EnvironmentUpdate");
    }
}

void ServiceStub::onEnvironmentGet(const ::boost::shared_ptr< EnvironmentGet >& environment) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "EnvironmentGet", environment->getAct());
    sendEnvironmentGetUpdate(_EnvironmentProperty.getEnvironment(), environment->getAct());
}

void ServiceStub::sendEnvironmentGetUpdate(const ::std::vector< ::std::string >& environment, act_t act) {
    ::asf::dbus::DBusVariant variant;
    EnvironmentGet payload(environment);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "EnvironmentGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setEnvironment(const ::std::vector< ::std::string >& environment) {
    if(environment!=_EnvironmentProperty.getEnvironment()) {
        _EnvironmentProperty.setEnvironment(environment);
        sendEnvironmentUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::string >& ServiceStub::getEnvironment() const {
    return _EnvironmentProperty.getEnvironment();
}

::std::vector< ::std::string >& ServiceStub::getEnvironmentMutable() {
    return _EnvironmentProperty.getEnvironmentMutable();
}

void ServiceStub::sendEnvironmentFilesUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        EnvironmentFilesUpdate payload(_EnvironmentFilesProperty);

        LOG_INFO ("-> send%s", "EnvironmentFilesUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("EnvironmentFiles", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "EnvironmentFilesUpdate");
    }
}

void ServiceStub::onEnvironmentFilesGet(const ::boost::shared_ptr< EnvironmentFilesGet >& environmentFiles) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "EnvironmentFilesGet", environmentFiles->getAct());
    sendEnvironmentFilesGetUpdate(_EnvironmentFilesProperty.getEnvironmentFiles(), environmentFiles->getAct());
}

void ServiceStub::sendEnvironmentFilesGetUpdate(const ::std::vector< EnvironmentFile >& environmentFiles, act_t act) {
    ::asf::dbus::DBusVariant variant;
    EnvironmentFilesGet payload(environmentFiles);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "EnvironmentFilesGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setEnvironmentFiles(const ::std::vector< EnvironmentFile >& environmentFiles) {
    if(environmentFiles!=_EnvironmentFilesProperty.getEnvironmentFiles()) {
        _EnvironmentFilesProperty.setEnvironmentFiles(environmentFiles);
        sendEnvironmentFilesUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< EnvironmentFile >& ServiceStub::getEnvironmentFiles() const {
    return _EnvironmentFilesProperty.getEnvironmentFiles();
}

::std::vector< EnvironmentFile >& ServiceStub::getEnvironmentFilesMutable() {
    return _EnvironmentFilesProperty.getEnvironmentFilesMutable();
}

void ServiceStub::sendUMaskUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        UMaskUpdate payload(_UMaskProperty);

        LOG_INFO ("-> send%s", "UMaskUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("UMask", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "UMaskUpdate");
    }
}

void ServiceStub::onUMaskGet(const ::boost::shared_ptr< UMaskGet >& uMask) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "UMaskGet", uMask->getAct());
    sendUMaskGetUpdate(_UMaskProperty.getUMask(), uMask->getAct());
}

void ServiceStub::sendUMaskGetUpdate(uint32 uMask, act_t act) {
    ::asf::dbus::DBusVariant variant;
    UMaskGet payload(uMask);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "UMaskGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setUMask(uint32 uMask) {
    if(uMask!=_UMaskProperty.getUMask()) {
        _UMaskProperty.setUMask(uMask);
        sendUMaskUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint32 ServiceStub::getUMask() const {
    return _UMaskProperty.getUMask();
}

void ServiceStub::sendLimitCPUUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        LimitCPUUpdate payload(_LimitCPUProperty);

        LOG_INFO ("-> send%s", "LimitCPUUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("LimitCPU", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "LimitCPUUpdate");
    }
}

void ServiceStub::onLimitCPUGet(const ::boost::shared_ptr< LimitCPUGet >& limitCPU) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "LimitCPUGet", limitCPU->getAct());
    sendLimitCPUGetUpdate(_LimitCPUProperty.getLimitCPU(), limitCPU->getAct());
}

void ServiceStub::sendLimitCPUGetUpdate(uint64 limitCPU, act_t act) {
    ::asf::dbus::DBusVariant variant;
    LimitCPUGet payload(limitCPU);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "LimitCPUGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setLimitCPU(uint64 limitCPU) {
    if(limitCPU!=_LimitCPUProperty.getLimitCPU()) {
        _LimitCPUProperty.setLimitCPU(limitCPU);
        sendLimitCPUUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ServiceStub::getLimitCPU() const {
    return _LimitCPUProperty.getLimitCPU();
}

void ServiceStub::sendLimitFSIZEUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        LimitFSIZEUpdate payload(_LimitFSIZEProperty);

        LOG_INFO ("-> send%s", "LimitFSIZEUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("LimitFSIZE", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "LimitFSIZEUpdate");
    }
}

void ServiceStub::onLimitFSIZEGet(const ::boost::shared_ptr< LimitFSIZEGet >& limitFSIZE) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "LimitFSIZEGet", limitFSIZE->getAct());
    sendLimitFSIZEGetUpdate(_LimitFSIZEProperty.getLimitFSIZE(), limitFSIZE->getAct());
}

void ServiceStub::sendLimitFSIZEGetUpdate(uint64 limitFSIZE, act_t act) {
    ::asf::dbus::DBusVariant variant;
    LimitFSIZEGet payload(limitFSIZE);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "LimitFSIZEGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setLimitFSIZE(uint64 limitFSIZE) {
    if(limitFSIZE!=_LimitFSIZEProperty.getLimitFSIZE()) {
        _LimitFSIZEProperty.setLimitFSIZE(limitFSIZE);
        sendLimitFSIZEUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ServiceStub::getLimitFSIZE() const {
    return _LimitFSIZEProperty.getLimitFSIZE();
}

void ServiceStub::sendLimitDATAUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        LimitDATAUpdate payload(_LimitDATAProperty);

        LOG_INFO ("-> send%s", "LimitDATAUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("LimitDATA", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "LimitDATAUpdate");
    }
}

void ServiceStub::onLimitDATAGet(const ::boost::shared_ptr< LimitDATAGet >& limitDATA) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "LimitDATAGet", limitDATA->getAct());
    sendLimitDATAGetUpdate(_LimitDATAProperty.getLimitDATA(), limitDATA->getAct());
}

void ServiceStub::sendLimitDATAGetUpdate(uint64 limitDATA, act_t act) {
    ::asf::dbus::DBusVariant variant;
    LimitDATAGet payload(limitDATA);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "LimitDATAGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setLimitDATA(uint64 limitDATA) {
    if(limitDATA!=_LimitDATAProperty.getLimitDATA()) {
        _LimitDATAProperty.setLimitDATA(limitDATA);
        sendLimitDATAUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ServiceStub::getLimitDATA() const {
    return _LimitDATAProperty.getLimitDATA();
}

void ServiceStub::sendLimitSTACKUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        LimitSTACKUpdate payload(_LimitSTACKProperty);

        LOG_INFO ("-> send%s", "LimitSTACKUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("LimitSTACK", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "LimitSTACKUpdate");
    }
}

void ServiceStub::onLimitSTACKGet(const ::boost::shared_ptr< LimitSTACKGet >& limitSTACK) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "LimitSTACKGet", limitSTACK->getAct());
    sendLimitSTACKGetUpdate(_LimitSTACKProperty.getLimitSTACK(), limitSTACK->getAct());
}

void ServiceStub::sendLimitSTACKGetUpdate(uint64 limitSTACK, act_t act) {
    ::asf::dbus::DBusVariant variant;
    LimitSTACKGet payload(limitSTACK);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "LimitSTACKGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setLimitSTACK(uint64 limitSTACK) {
    if(limitSTACK!=_LimitSTACKProperty.getLimitSTACK()) {
        _LimitSTACKProperty.setLimitSTACK(limitSTACK);
        sendLimitSTACKUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ServiceStub::getLimitSTACK() const {
    return _LimitSTACKProperty.getLimitSTACK();
}

void ServiceStub::sendLimitCOREUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        LimitCOREUpdate payload(_LimitCOREProperty);

        LOG_INFO ("-> send%s", "LimitCOREUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("LimitCORE", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "LimitCOREUpdate");
    }
}

void ServiceStub::onLimitCOREGet(const ::boost::shared_ptr< LimitCOREGet >& limitCORE) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "LimitCOREGet", limitCORE->getAct());
    sendLimitCOREGetUpdate(_LimitCOREProperty.getLimitCORE(), limitCORE->getAct());
}

void ServiceStub::sendLimitCOREGetUpdate(uint64 limitCORE, act_t act) {
    ::asf::dbus::DBusVariant variant;
    LimitCOREGet payload(limitCORE);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "LimitCOREGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setLimitCORE(uint64 limitCORE) {
    if(limitCORE!=_LimitCOREProperty.getLimitCORE()) {
        _LimitCOREProperty.setLimitCORE(limitCORE);
        sendLimitCOREUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ServiceStub::getLimitCORE() const {
    return _LimitCOREProperty.getLimitCORE();
}

void ServiceStub::sendLimitRSSUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        LimitRSSUpdate payload(_LimitRSSProperty);

        LOG_INFO ("-> send%s", "LimitRSSUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("LimitRSS", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "LimitRSSUpdate");
    }
}

void ServiceStub::onLimitRSSGet(const ::boost::shared_ptr< LimitRSSGet >& limitRSS) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "LimitRSSGet", limitRSS->getAct());
    sendLimitRSSGetUpdate(_LimitRSSProperty.getLimitRSS(), limitRSS->getAct());
}

void ServiceStub::sendLimitRSSGetUpdate(uint64 limitRSS, act_t act) {
    ::asf::dbus::DBusVariant variant;
    LimitRSSGet payload(limitRSS);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "LimitRSSGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setLimitRSS(uint64 limitRSS) {
    if(limitRSS!=_LimitRSSProperty.getLimitRSS()) {
        _LimitRSSProperty.setLimitRSS(limitRSS);
        sendLimitRSSUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ServiceStub::getLimitRSS() const {
    return _LimitRSSProperty.getLimitRSS();
}

void ServiceStub::sendLimitNOFILEUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        LimitNOFILEUpdate payload(_LimitNOFILEProperty);

        LOG_INFO ("-> send%s", "LimitNOFILEUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("LimitNOFILE", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "LimitNOFILEUpdate");
    }
}

void ServiceStub::onLimitNOFILEGet(const ::boost::shared_ptr< LimitNOFILEGet >& limitNOFILE) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "LimitNOFILEGet", limitNOFILE->getAct());
    sendLimitNOFILEGetUpdate(_LimitNOFILEProperty.getLimitNOFILE(), limitNOFILE->getAct());
}

void ServiceStub::sendLimitNOFILEGetUpdate(uint64 limitNOFILE, act_t act) {
    ::asf::dbus::DBusVariant variant;
    LimitNOFILEGet payload(limitNOFILE);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "LimitNOFILEGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setLimitNOFILE(uint64 limitNOFILE) {
    if(limitNOFILE!=_LimitNOFILEProperty.getLimitNOFILE()) {
        _LimitNOFILEProperty.setLimitNOFILE(limitNOFILE);
        sendLimitNOFILEUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ServiceStub::getLimitNOFILE() const {
    return _LimitNOFILEProperty.getLimitNOFILE();
}

void ServiceStub::sendLimitASUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        LimitASUpdate payload(_LimitASProperty);

        LOG_INFO ("-> send%s", "LimitASUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("LimitAS", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "LimitASUpdate");
    }
}

void ServiceStub::onLimitASGet(const ::boost::shared_ptr< LimitASGet >& limitAS) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "LimitASGet", limitAS->getAct());
    sendLimitASGetUpdate(_LimitASProperty.getLimitAS(), limitAS->getAct());
}

void ServiceStub::sendLimitASGetUpdate(uint64 limitAS, act_t act) {
    ::asf::dbus::DBusVariant variant;
    LimitASGet payload(limitAS);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "LimitASGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setLimitAS(uint64 limitAS) {
    if(limitAS!=_LimitASProperty.getLimitAS()) {
        _LimitASProperty.setLimitAS(limitAS);
        sendLimitASUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ServiceStub::getLimitAS() const {
    return _LimitASProperty.getLimitAS();
}

void ServiceStub::sendLimitNPROCUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        LimitNPROCUpdate payload(_LimitNPROCProperty);

        LOG_INFO ("-> send%s", "LimitNPROCUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("LimitNPROC", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "LimitNPROCUpdate");
    }
}

void ServiceStub::onLimitNPROCGet(const ::boost::shared_ptr< LimitNPROCGet >& limitNPROC) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "LimitNPROCGet", limitNPROC->getAct());
    sendLimitNPROCGetUpdate(_LimitNPROCProperty.getLimitNPROC(), limitNPROC->getAct());
}

void ServiceStub::sendLimitNPROCGetUpdate(uint64 limitNPROC, act_t act) {
    ::asf::dbus::DBusVariant variant;
    LimitNPROCGet payload(limitNPROC);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "LimitNPROCGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setLimitNPROC(uint64 limitNPROC) {
    if(limitNPROC!=_LimitNPROCProperty.getLimitNPROC()) {
        _LimitNPROCProperty.setLimitNPROC(limitNPROC);
        sendLimitNPROCUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ServiceStub::getLimitNPROC() const {
    return _LimitNPROCProperty.getLimitNPROC();
}

void ServiceStub::sendLimitMEMLOCKUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        LimitMEMLOCKUpdate payload(_LimitMEMLOCKProperty);

        LOG_INFO ("-> send%s", "LimitMEMLOCKUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("LimitMEMLOCK", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "LimitMEMLOCKUpdate");
    }
}

void ServiceStub::onLimitMEMLOCKGet(const ::boost::shared_ptr< LimitMEMLOCKGet >& limitMEMLOCK) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "LimitMEMLOCKGet", limitMEMLOCK->getAct());
    sendLimitMEMLOCKGetUpdate(_LimitMEMLOCKProperty.getLimitMEMLOCK(), limitMEMLOCK->getAct());
}

void ServiceStub::sendLimitMEMLOCKGetUpdate(uint64 limitMEMLOCK, act_t act) {
    ::asf::dbus::DBusVariant variant;
    LimitMEMLOCKGet payload(limitMEMLOCK);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "LimitMEMLOCKGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setLimitMEMLOCK(uint64 limitMEMLOCK) {
    if(limitMEMLOCK!=_LimitMEMLOCKProperty.getLimitMEMLOCK()) {
        _LimitMEMLOCKProperty.setLimitMEMLOCK(limitMEMLOCK);
        sendLimitMEMLOCKUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ServiceStub::getLimitMEMLOCK() const {
    return _LimitMEMLOCKProperty.getLimitMEMLOCK();
}

void ServiceStub::sendLimitLOCKSUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        LimitLOCKSUpdate payload(_LimitLOCKSProperty);

        LOG_INFO ("-> send%s", "LimitLOCKSUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("LimitLOCKS", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "LimitLOCKSUpdate");
    }
}

void ServiceStub::onLimitLOCKSGet(const ::boost::shared_ptr< LimitLOCKSGet >& limitLOCKS) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "LimitLOCKSGet", limitLOCKS->getAct());
    sendLimitLOCKSGetUpdate(_LimitLOCKSProperty.getLimitLOCKS(), limitLOCKS->getAct());
}

void ServiceStub::sendLimitLOCKSGetUpdate(uint64 limitLOCKS, act_t act) {
    ::asf::dbus::DBusVariant variant;
    LimitLOCKSGet payload(limitLOCKS);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "LimitLOCKSGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setLimitLOCKS(uint64 limitLOCKS) {
    if(limitLOCKS!=_LimitLOCKSProperty.getLimitLOCKS()) {
        _LimitLOCKSProperty.setLimitLOCKS(limitLOCKS);
        sendLimitLOCKSUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ServiceStub::getLimitLOCKS() const {
    return _LimitLOCKSProperty.getLimitLOCKS();
}

void ServiceStub::sendLimitSIGPENDINGUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        LimitSIGPENDINGUpdate payload(_LimitSIGPENDINGProperty);

        LOG_INFO ("-> send%s", "LimitSIGPENDINGUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("LimitSIGPENDING", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "LimitSIGPENDINGUpdate");
    }
}

void ServiceStub::onLimitSIGPENDINGGet(const ::boost::shared_ptr< LimitSIGPENDINGGet >& limitSIGPENDING) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "LimitSIGPENDINGGet", limitSIGPENDING->getAct());
    sendLimitSIGPENDINGGetUpdate(_LimitSIGPENDINGProperty.getLimitSIGPENDING(), limitSIGPENDING->getAct());
}

void ServiceStub::sendLimitSIGPENDINGGetUpdate(uint64 limitSIGPENDING, act_t act) {
    ::asf::dbus::DBusVariant variant;
    LimitSIGPENDINGGet payload(limitSIGPENDING);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "LimitSIGPENDINGGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setLimitSIGPENDING(uint64 limitSIGPENDING) {
    if(limitSIGPENDING!=_LimitSIGPENDINGProperty.getLimitSIGPENDING()) {
        _LimitSIGPENDINGProperty.setLimitSIGPENDING(limitSIGPENDING);
        sendLimitSIGPENDINGUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ServiceStub::getLimitSIGPENDING() const {
    return _LimitSIGPENDINGProperty.getLimitSIGPENDING();
}

void ServiceStub::sendLimitMSGQUEUEUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        LimitMSGQUEUEUpdate payload(_LimitMSGQUEUEProperty);

        LOG_INFO ("-> send%s", "LimitMSGQUEUEUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("LimitMSGQUEUE", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "LimitMSGQUEUEUpdate");
    }
}

void ServiceStub::onLimitMSGQUEUEGet(const ::boost::shared_ptr< LimitMSGQUEUEGet >& limitMSGQUEUE) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "LimitMSGQUEUEGet", limitMSGQUEUE->getAct());
    sendLimitMSGQUEUEGetUpdate(_LimitMSGQUEUEProperty.getLimitMSGQUEUE(), limitMSGQUEUE->getAct());
}

void ServiceStub::sendLimitMSGQUEUEGetUpdate(uint64 limitMSGQUEUE, act_t act) {
    ::asf::dbus::DBusVariant variant;
    LimitMSGQUEUEGet payload(limitMSGQUEUE);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "LimitMSGQUEUEGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setLimitMSGQUEUE(uint64 limitMSGQUEUE) {
    if(limitMSGQUEUE!=_LimitMSGQUEUEProperty.getLimitMSGQUEUE()) {
        _LimitMSGQUEUEProperty.setLimitMSGQUEUE(limitMSGQUEUE);
        sendLimitMSGQUEUEUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ServiceStub::getLimitMSGQUEUE() const {
    return _LimitMSGQUEUEProperty.getLimitMSGQUEUE();
}

void ServiceStub::sendLimitNICEUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        LimitNICEUpdate payload(_LimitNICEProperty);

        LOG_INFO ("-> send%s", "LimitNICEUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("LimitNICE", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "LimitNICEUpdate");
    }
}

void ServiceStub::onLimitNICEGet(const ::boost::shared_ptr< LimitNICEGet >& limitNICE) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "LimitNICEGet", limitNICE->getAct());
    sendLimitNICEGetUpdate(_LimitNICEProperty.getLimitNICE(), limitNICE->getAct());
}

void ServiceStub::sendLimitNICEGetUpdate(uint64 limitNICE, act_t act) {
    ::asf::dbus::DBusVariant variant;
    LimitNICEGet payload(limitNICE);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "LimitNICEGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setLimitNICE(uint64 limitNICE) {
    if(limitNICE!=_LimitNICEProperty.getLimitNICE()) {
        _LimitNICEProperty.setLimitNICE(limitNICE);
        sendLimitNICEUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ServiceStub::getLimitNICE() const {
    return _LimitNICEProperty.getLimitNICE();
}

void ServiceStub::sendLimitRTPRIOUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        LimitRTPRIOUpdate payload(_LimitRTPRIOProperty);

        LOG_INFO ("-> send%s", "LimitRTPRIOUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("LimitRTPRIO", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "LimitRTPRIOUpdate");
    }
}

void ServiceStub::onLimitRTPRIOGet(const ::boost::shared_ptr< LimitRTPRIOGet >& limitRTPRIO) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "LimitRTPRIOGet", limitRTPRIO->getAct());
    sendLimitRTPRIOGetUpdate(_LimitRTPRIOProperty.getLimitRTPRIO(), limitRTPRIO->getAct());
}

void ServiceStub::sendLimitRTPRIOGetUpdate(uint64 limitRTPRIO, act_t act) {
    ::asf::dbus::DBusVariant variant;
    LimitRTPRIOGet payload(limitRTPRIO);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "LimitRTPRIOGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setLimitRTPRIO(uint64 limitRTPRIO) {
    if(limitRTPRIO!=_LimitRTPRIOProperty.getLimitRTPRIO()) {
        _LimitRTPRIOProperty.setLimitRTPRIO(limitRTPRIO);
        sendLimitRTPRIOUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ServiceStub::getLimitRTPRIO() const {
    return _LimitRTPRIOProperty.getLimitRTPRIO();
}

void ServiceStub::sendLimitRTTIMEUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        LimitRTTIMEUpdate payload(_LimitRTTIMEProperty);

        LOG_INFO ("-> send%s", "LimitRTTIMEUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("LimitRTTIME", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "LimitRTTIMEUpdate");
    }
}

void ServiceStub::onLimitRTTIMEGet(const ::boost::shared_ptr< LimitRTTIMEGet >& limitRTTIME) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "LimitRTTIMEGet", limitRTTIME->getAct());
    sendLimitRTTIMEGetUpdate(_LimitRTTIMEProperty.getLimitRTTIME(), limitRTTIME->getAct());
}

void ServiceStub::sendLimitRTTIMEGetUpdate(uint64 limitRTTIME, act_t act) {
    ::asf::dbus::DBusVariant variant;
    LimitRTTIMEGet payload(limitRTTIME);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "LimitRTTIMEGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setLimitRTTIME(uint64 limitRTTIME) {
    if(limitRTTIME!=_LimitRTTIMEProperty.getLimitRTTIME()) {
        _LimitRTTIMEProperty.setLimitRTTIME(limitRTTIME);
        sendLimitRTTIMEUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ServiceStub::getLimitRTTIME() const {
    return _LimitRTTIMEProperty.getLimitRTTIME();
}

void ServiceStub::sendWorkingDirectoryUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        WorkingDirectoryUpdate payload(_WorkingDirectoryProperty);

        LOG_INFO ("-> send%s", "WorkingDirectoryUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("WorkingDirectory", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "WorkingDirectoryUpdate");
    }
}

void ServiceStub::onWorkingDirectoryGet(const ::boost::shared_ptr< WorkingDirectoryGet >& workingDirectory) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "WorkingDirectoryGet", workingDirectory->getAct());
    sendWorkingDirectoryGetUpdate(_WorkingDirectoryProperty.getWorkingDirectory(), workingDirectory->getAct());
}

void ServiceStub::sendWorkingDirectoryGetUpdate(const ::std::string& workingDirectory, act_t act) {
    ::asf::dbus::DBusVariant variant;
    WorkingDirectoryGet payload(workingDirectory);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "WorkingDirectoryGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setWorkingDirectory(const ::std::string& workingDirectory) {
    if(workingDirectory!=_WorkingDirectoryProperty.getWorkingDirectory()) {
        _WorkingDirectoryProperty.setWorkingDirectory(workingDirectory);
        sendWorkingDirectoryUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& ServiceStub::getWorkingDirectory() const {
    return _WorkingDirectoryProperty.getWorkingDirectory();
}

::std::string& ServiceStub::getWorkingDirectoryMutable() {
    return _WorkingDirectoryProperty.getWorkingDirectoryMutable();
}

void ServiceStub::sendRootDirectoryUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        RootDirectoryUpdate payload(_RootDirectoryProperty);

        LOG_INFO ("-> send%s", "RootDirectoryUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("RootDirectory", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "RootDirectoryUpdate");
    }
}

void ServiceStub::onRootDirectoryGet(const ::boost::shared_ptr< RootDirectoryGet >& rootDirectory) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "RootDirectoryGet", rootDirectory->getAct());
    sendRootDirectoryGetUpdate(_RootDirectoryProperty.getRootDirectory(), rootDirectory->getAct());
}

void ServiceStub::sendRootDirectoryGetUpdate(const ::std::string& rootDirectory, act_t act) {
    ::asf::dbus::DBusVariant variant;
    RootDirectoryGet payload(rootDirectory);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "RootDirectoryGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setRootDirectory(const ::std::string& rootDirectory) {
    if(rootDirectory!=_RootDirectoryProperty.getRootDirectory()) {
        _RootDirectoryProperty.setRootDirectory(rootDirectory);
        sendRootDirectoryUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& ServiceStub::getRootDirectory() const {
    return _RootDirectoryProperty.getRootDirectory();
}

::std::string& ServiceStub::getRootDirectoryMutable() {
    return _RootDirectoryProperty.getRootDirectoryMutable();
}

void ServiceStub::sendOOMScoreAdjustUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        OOMScoreAdjustUpdate payload(_OOMScoreAdjustProperty);

        LOG_INFO ("-> send%s", "OOMScoreAdjustUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("OOMScoreAdjust", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "OOMScoreAdjustUpdate");
    }
}

void ServiceStub::onOOMScoreAdjustGet(const ::boost::shared_ptr< OOMScoreAdjustGet >& oOMScoreAdjust) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "OOMScoreAdjustGet", oOMScoreAdjust->getAct());
    sendOOMScoreAdjustGetUpdate(_OOMScoreAdjustProperty.getOOMScoreAdjust(), oOMScoreAdjust->getAct());
}

void ServiceStub::sendOOMScoreAdjustGetUpdate(int32 oOMScoreAdjust, act_t act) {
    ::asf::dbus::DBusVariant variant;
    OOMScoreAdjustGet payload(oOMScoreAdjust);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "OOMScoreAdjustGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setOOMScoreAdjust(int32 oOMScoreAdjust) {
    if(oOMScoreAdjust!=_OOMScoreAdjustProperty.getOOMScoreAdjust()) {
        _OOMScoreAdjustProperty.setOOMScoreAdjust(oOMScoreAdjust);
        sendOOMScoreAdjustUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

int32 ServiceStub::getOOMScoreAdjust() const {
    return _OOMScoreAdjustProperty.getOOMScoreAdjust();
}

void ServiceStub::sendNiceUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        NiceUpdate payload(_NiceProperty);

        LOG_INFO ("-> send%s", "NiceUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Nice", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "NiceUpdate");
    }
}

void ServiceStub::onNiceGet(const ::boost::shared_ptr< NiceGet >& nice) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "NiceGet", nice->getAct());
    sendNiceGetUpdate(_NiceProperty.getNice(), nice->getAct());
}

void ServiceStub::sendNiceGetUpdate(int32 nice, act_t act) {
    ::asf::dbus::DBusVariant variant;
    NiceGet payload(nice);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "NiceGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setNice(int32 nice) {
    if(nice!=_NiceProperty.getNice()) {
        _NiceProperty.setNice(nice);
        sendNiceUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

int32 ServiceStub::getNice() const {
    return _NiceProperty.getNice();
}

void ServiceStub::sendIOSchedulingUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        IOSchedulingUpdate payload(_IOSchedulingProperty);

        LOG_INFO ("-> send%s", "IOSchedulingUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("IOScheduling", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "IOSchedulingUpdate");
    }
}

void ServiceStub::onIOSchedulingGet(const ::boost::shared_ptr< IOSchedulingGet >& iOScheduling) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "IOSchedulingGet", iOScheduling->getAct());
    sendIOSchedulingGetUpdate(_IOSchedulingProperty.getIOScheduling(), iOScheduling->getAct());
}

void ServiceStub::sendIOSchedulingGetUpdate(int32 iOScheduling, act_t act) {
    ::asf::dbus::DBusVariant variant;
    IOSchedulingGet payload(iOScheduling);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "IOSchedulingGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setIOScheduling(int32 iOScheduling) {
    if(iOScheduling!=_IOSchedulingProperty.getIOScheduling()) {
        _IOSchedulingProperty.setIOScheduling(iOScheduling);
        sendIOSchedulingUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

int32 ServiceStub::getIOScheduling() const {
    return _IOSchedulingProperty.getIOScheduling();
}

void ServiceStub::sendCPUSchedulingPolicyUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        CPUSchedulingPolicyUpdate payload(_CPUSchedulingPolicyProperty);

        LOG_INFO ("-> send%s", "CPUSchedulingPolicyUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("CPUSchedulingPolicy", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "CPUSchedulingPolicyUpdate");
    }
}

void ServiceStub::onCPUSchedulingPolicyGet(const ::boost::shared_ptr< CPUSchedulingPolicyGet >& cPUSchedulingPolicy) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "CPUSchedulingPolicyGet", cPUSchedulingPolicy->getAct());
    sendCPUSchedulingPolicyGetUpdate(_CPUSchedulingPolicyProperty.getCPUSchedulingPolicy(), cPUSchedulingPolicy->getAct());
}

void ServiceStub::sendCPUSchedulingPolicyGetUpdate(int32 cPUSchedulingPolicy, act_t act) {
    ::asf::dbus::DBusVariant variant;
    CPUSchedulingPolicyGet payload(cPUSchedulingPolicy);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "CPUSchedulingPolicyGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setCPUSchedulingPolicy(int32 cPUSchedulingPolicy) {
    if(cPUSchedulingPolicy!=_CPUSchedulingPolicyProperty.getCPUSchedulingPolicy()) {
        _CPUSchedulingPolicyProperty.setCPUSchedulingPolicy(cPUSchedulingPolicy);
        sendCPUSchedulingPolicyUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

int32 ServiceStub::getCPUSchedulingPolicy() const {
    return _CPUSchedulingPolicyProperty.getCPUSchedulingPolicy();
}

void ServiceStub::sendCPUSchedulingPriorityUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        CPUSchedulingPriorityUpdate payload(_CPUSchedulingPriorityProperty);

        LOG_INFO ("-> send%s", "CPUSchedulingPriorityUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("CPUSchedulingPriority", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "CPUSchedulingPriorityUpdate");
    }
}

void ServiceStub::onCPUSchedulingPriorityGet(const ::boost::shared_ptr< CPUSchedulingPriorityGet >& cPUSchedulingPriority) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "CPUSchedulingPriorityGet", cPUSchedulingPriority->getAct());
    sendCPUSchedulingPriorityGetUpdate(_CPUSchedulingPriorityProperty.getCPUSchedulingPriority(), cPUSchedulingPriority->getAct());
}

void ServiceStub::sendCPUSchedulingPriorityGetUpdate(int32 cPUSchedulingPriority, act_t act) {
    ::asf::dbus::DBusVariant variant;
    CPUSchedulingPriorityGet payload(cPUSchedulingPriority);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "CPUSchedulingPriorityGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setCPUSchedulingPriority(int32 cPUSchedulingPriority) {
    if(cPUSchedulingPriority!=_CPUSchedulingPriorityProperty.getCPUSchedulingPriority()) {
        _CPUSchedulingPriorityProperty.setCPUSchedulingPriority(cPUSchedulingPriority);
        sendCPUSchedulingPriorityUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

int32 ServiceStub::getCPUSchedulingPriority() const {
    return _CPUSchedulingPriorityProperty.getCPUSchedulingPriority();
}

void ServiceStub::sendCPUAffinityUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        CPUAffinityUpdate payload(_CPUAffinityProperty);

        LOG_INFO ("-> send%s", "CPUAffinityUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("CPUAffinity", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "CPUAffinityUpdate");
    }
}

void ServiceStub::onCPUAffinityGet(const ::boost::shared_ptr< CPUAffinityGet >& cPUAffinity) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "CPUAffinityGet", cPUAffinity->getAct());
    sendCPUAffinityGetUpdate(_CPUAffinityProperty.getCPUAffinity(), cPUAffinity->getAct());
}

void ServiceStub::sendCPUAffinityGetUpdate(const ::std::vector< ::std::string >& cPUAffinity, act_t act) {
    ::asf::dbus::DBusVariant variant;
    CPUAffinityGet payload(cPUAffinity);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "CPUAffinityGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setCPUAffinity(const ::std::vector< ::std::string >& cPUAffinity) {
    if(cPUAffinity!=_CPUAffinityProperty.getCPUAffinity()) {
        _CPUAffinityProperty.setCPUAffinity(cPUAffinity);
        sendCPUAffinityUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::string >& ServiceStub::getCPUAffinity() const {
    return _CPUAffinityProperty.getCPUAffinity();
}

::std::vector< ::std::string >& ServiceStub::getCPUAffinityMutable() {
    return _CPUAffinityProperty.getCPUAffinityMutable();
}

void ServiceStub::sendTimerSlackNSecUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        TimerSlackNSecUpdate payload(_TimerSlackNSecProperty);

        LOG_INFO ("-> send%s", "TimerSlackNSecUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("TimerSlackNSec", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "TimerSlackNSecUpdate");
    }
}

void ServiceStub::onTimerSlackNSecGet(const ::boost::shared_ptr< TimerSlackNSecGet >& timerSlackNSec) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "TimerSlackNSecGet", timerSlackNSec->getAct());
    sendTimerSlackNSecGetUpdate(_TimerSlackNSecProperty.getTimerSlackNSec(), timerSlackNSec->getAct());
}

void ServiceStub::sendTimerSlackNSecGetUpdate(uint64 timerSlackNSec, act_t act) {
    ::asf::dbus::DBusVariant variant;
    TimerSlackNSecGet payload(timerSlackNSec);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "TimerSlackNSecGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setTimerSlackNSec(uint64 timerSlackNSec) {
    if(timerSlackNSec!=_TimerSlackNSecProperty.getTimerSlackNSec()) {
        _TimerSlackNSecProperty.setTimerSlackNSec(timerSlackNSec);
        sendTimerSlackNSecUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ServiceStub::getTimerSlackNSec() const {
    return _TimerSlackNSecProperty.getTimerSlackNSec();
}

void ServiceStub::sendCPUSchedulingResetOnForkUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        CPUSchedulingResetOnForkUpdate payload(_CPUSchedulingResetOnForkProperty);

        LOG_INFO ("-> send%s", "CPUSchedulingResetOnForkUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("CPUSchedulingResetOnFork", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "CPUSchedulingResetOnForkUpdate");
    }
}

void ServiceStub::onCPUSchedulingResetOnForkGet(const ::boost::shared_ptr< CPUSchedulingResetOnForkGet >& cPUSchedulingResetOnFork) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "CPUSchedulingResetOnForkGet", cPUSchedulingResetOnFork->getAct());
    sendCPUSchedulingResetOnForkGetUpdate(_CPUSchedulingResetOnForkProperty.getCPUSchedulingResetOnFork(), cPUSchedulingResetOnFork->getAct());
}

void ServiceStub::sendCPUSchedulingResetOnForkGetUpdate(bool cPUSchedulingResetOnFork, act_t act) {
    ::asf::dbus::DBusVariant variant;
    CPUSchedulingResetOnForkGet payload(cPUSchedulingResetOnFork);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "CPUSchedulingResetOnForkGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setCPUSchedulingResetOnFork(bool cPUSchedulingResetOnFork) {
    if(cPUSchedulingResetOnFork!=_CPUSchedulingResetOnForkProperty.getCPUSchedulingResetOnFork()) {
        _CPUSchedulingResetOnForkProperty.setCPUSchedulingResetOnFork(cPUSchedulingResetOnFork);
        sendCPUSchedulingResetOnForkUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool ServiceStub::getCPUSchedulingResetOnFork() const {
    return _CPUSchedulingResetOnForkProperty.getCPUSchedulingResetOnFork();
}

void ServiceStub::sendNonBlockingUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        NonBlockingUpdate payload(_NonBlockingProperty);

        LOG_INFO ("-> send%s", "NonBlockingUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("NonBlocking", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "NonBlockingUpdate");
    }
}

void ServiceStub::onNonBlockingGet(const ::boost::shared_ptr< NonBlockingGet >& nonBlocking) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "NonBlockingGet", nonBlocking->getAct());
    sendNonBlockingGetUpdate(_NonBlockingProperty.getNonBlocking(), nonBlocking->getAct());
}

void ServiceStub::sendNonBlockingGetUpdate(bool nonBlocking, act_t act) {
    ::asf::dbus::DBusVariant variant;
    NonBlockingGet payload(nonBlocking);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "NonBlockingGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setNonBlocking(bool nonBlocking) {
    if(nonBlocking!=_NonBlockingProperty.getNonBlocking()) {
        _NonBlockingProperty.setNonBlocking(nonBlocking);
        sendNonBlockingUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool ServiceStub::getNonBlocking() const {
    return _NonBlockingProperty.getNonBlocking();
}

void ServiceStub::sendStandardInputUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        StandardInputUpdate payload(_StandardInputProperty);

        LOG_INFO ("-> send%s", "StandardInputUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("StandardInput", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "StandardInputUpdate");
    }
}

void ServiceStub::onStandardInputGet(const ::boost::shared_ptr< StandardInputGet >& standardInput) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "StandardInputGet", standardInput->getAct());
    sendStandardInputGetUpdate(_StandardInputProperty.getStandardInput(), standardInput->getAct());
}

void ServiceStub::sendStandardInputGetUpdate(const ::std::string& standardInput, act_t act) {
    ::asf::dbus::DBusVariant variant;
    StandardInputGet payload(standardInput);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "StandardInputGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setStandardInput(const ::std::string& standardInput) {
    if(standardInput!=_StandardInputProperty.getStandardInput()) {
        _StandardInputProperty.setStandardInput(standardInput);
        sendStandardInputUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& ServiceStub::getStandardInput() const {
    return _StandardInputProperty.getStandardInput();
}

::std::string& ServiceStub::getStandardInputMutable() {
    return _StandardInputProperty.getStandardInputMutable();
}

void ServiceStub::sendStandardOutputUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        StandardOutputUpdate payload(_StandardOutputProperty);

        LOG_INFO ("-> send%s", "StandardOutputUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("StandardOutput", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "StandardOutputUpdate");
    }
}

void ServiceStub::onStandardOutputGet(const ::boost::shared_ptr< StandardOutputGet >& standardOutput) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "StandardOutputGet", standardOutput->getAct());
    sendStandardOutputGetUpdate(_StandardOutputProperty.getStandardOutput(), standardOutput->getAct());
}

void ServiceStub::sendStandardOutputGetUpdate(const ::std::string& standardOutput, act_t act) {
    ::asf::dbus::DBusVariant variant;
    StandardOutputGet payload(standardOutput);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "StandardOutputGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setStandardOutput(const ::std::string& standardOutput) {
    if(standardOutput!=_StandardOutputProperty.getStandardOutput()) {
        _StandardOutputProperty.setStandardOutput(standardOutput);
        sendStandardOutputUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& ServiceStub::getStandardOutput() const {
    return _StandardOutputProperty.getStandardOutput();
}

::std::string& ServiceStub::getStandardOutputMutable() {
    return _StandardOutputProperty.getStandardOutputMutable();
}

void ServiceStub::sendStandardErrorUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        StandardErrorUpdate payload(_StandardErrorProperty);

        LOG_INFO ("-> send%s", "StandardErrorUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("StandardError", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "StandardErrorUpdate");
    }
}

void ServiceStub::onStandardErrorGet(const ::boost::shared_ptr< StandardErrorGet >& standardError) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "StandardErrorGet", standardError->getAct());
    sendStandardErrorGetUpdate(_StandardErrorProperty.getStandardError(), standardError->getAct());
}

void ServiceStub::sendStandardErrorGetUpdate(const ::std::string& standardError, act_t act) {
    ::asf::dbus::DBusVariant variant;
    StandardErrorGet payload(standardError);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "StandardErrorGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setStandardError(const ::std::string& standardError) {
    if(standardError!=_StandardErrorProperty.getStandardError()) {
        _StandardErrorProperty.setStandardError(standardError);
        sendStandardErrorUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& ServiceStub::getStandardError() const {
    return _StandardErrorProperty.getStandardError();
}

::std::string& ServiceStub::getStandardErrorMutable() {
    return _StandardErrorProperty.getStandardErrorMutable();
}

void ServiceStub::sendTTYPathUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        TTYPathUpdate payload(_TTYPathProperty);

        LOG_INFO ("-> send%s", "TTYPathUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("TTYPath", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "TTYPathUpdate");
    }
}

void ServiceStub::onTTYPathGet(const ::boost::shared_ptr< TTYPathGet >& tTYPath) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "TTYPathGet", tTYPath->getAct());
    sendTTYPathGetUpdate(_TTYPathProperty.getTTYPath(), tTYPath->getAct());
}

void ServiceStub::sendTTYPathGetUpdate(bool tTYPath, act_t act) {
    ::asf::dbus::DBusVariant variant;
    TTYPathGet payload(tTYPath);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "TTYPathGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setTTYPath(bool tTYPath) {
    if(tTYPath!=_TTYPathProperty.getTTYPath()) {
        _TTYPathProperty.setTTYPath(tTYPath);
        sendTTYPathUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool ServiceStub::getTTYPath() const {
    return _TTYPathProperty.getTTYPath();
}

void ServiceStub::sendTTYResetUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        TTYResetUpdate payload(_TTYResetProperty);

        LOG_INFO ("-> send%s", "TTYResetUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("TTYReset", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "TTYResetUpdate");
    }
}

void ServiceStub::onTTYResetGet(const ::boost::shared_ptr< TTYResetGet >& tTYReset) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "TTYResetGet", tTYReset->getAct());
    sendTTYResetGetUpdate(_TTYResetProperty.getTTYReset(), tTYReset->getAct());
}

void ServiceStub::sendTTYResetGetUpdate(bool tTYReset, act_t act) {
    ::asf::dbus::DBusVariant variant;
    TTYResetGet payload(tTYReset);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "TTYResetGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setTTYReset(bool tTYReset) {
    if(tTYReset!=_TTYResetProperty.getTTYReset()) {
        _TTYResetProperty.setTTYReset(tTYReset);
        sendTTYResetUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool ServiceStub::getTTYReset() const {
    return _TTYResetProperty.getTTYReset();
}

void ServiceStub::sendTTYVHangupUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        TTYVHangupUpdate payload(_TTYVHangupProperty);

        LOG_INFO ("-> send%s", "TTYVHangupUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("TTYVHangup", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "TTYVHangupUpdate");
    }
}

void ServiceStub::onTTYVHangupGet(const ::boost::shared_ptr< TTYVHangupGet >& tTYVHangup) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "TTYVHangupGet", tTYVHangup->getAct());
    sendTTYVHangupGetUpdate(_TTYVHangupProperty.getTTYVHangup(), tTYVHangup->getAct());
}

void ServiceStub::sendTTYVHangupGetUpdate(bool tTYVHangup, act_t act) {
    ::asf::dbus::DBusVariant variant;
    TTYVHangupGet payload(tTYVHangup);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "TTYVHangupGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setTTYVHangup(bool tTYVHangup) {
    if(tTYVHangup!=_TTYVHangupProperty.getTTYVHangup()) {
        _TTYVHangupProperty.setTTYVHangup(tTYVHangup);
        sendTTYVHangupUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool ServiceStub::getTTYVHangup() const {
    return _TTYVHangupProperty.getTTYVHangup();
}

void ServiceStub::sendTTYVTDisallocateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        TTYVTDisallocateUpdate payload(_TTYVTDisallocateProperty);

        LOG_INFO ("-> send%s", "TTYVTDisallocateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("TTYVTDisallocate", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "TTYVTDisallocateUpdate");
    }
}

void ServiceStub::onTTYVTDisallocateGet(const ::boost::shared_ptr< TTYVTDisallocateGet >& tTYVTDisallocate) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "TTYVTDisallocateGet", tTYVTDisallocate->getAct());
    sendTTYVTDisallocateGetUpdate(_TTYVTDisallocateProperty.getTTYVTDisallocate(), tTYVTDisallocate->getAct());
}

void ServiceStub::sendTTYVTDisallocateGetUpdate(bool tTYVTDisallocate, act_t act) {
    ::asf::dbus::DBusVariant variant;
    TTYVTDisallocateGet payload(tTYVTDisallocate);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "TTYVTDisallocateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setTTYVTDisallocate(bool tTYVTDisallocate) {
    if(tTYVTDisallocate!=_TTYVTDisallocateProperty.getTTYVTDisallocate()) {
        _TTYVTDisallocateProperty.setTTYVTDisallocate(tTYVTDisallocate);
        sendTTYVTDisallocateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool ServiceStub::getTTYVTDisallocate() const {
    return _TTYVTDisallocateProperty.getTTYVTDisallocate();
}

void ServiceStub::sendSyslogPriorityUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SyslogPriorityUpdate payload(_SyslogPriorityProperty);

        LOG_INFO ("-> send%s", "SyslogPriorityUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("SyslogPriority", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SyslogPriorityUpdate");
    }
}

void ServiceStub::onSyslogPriorityGet(const ::boost::shared_ptr< SyslogPriorityGet >& syslogPriority) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SyslogPriorityGet", syslogPriority->getAct());
    sendSyslogPriorityGetUpdate(_SyslogPriorityProperty.getSyslogPriority(), syslogPriority->getAct());
}

void ServiceStub::sendSyslogPriorityGetUpdate(int32 syslogPriority, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SyslogPriorityGet payload(syslogPriority);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SyslogPriorityGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setSyslogPriority(int32 syslogPriority) {
    if(syslogPriority!=_SyslogPriorityProperty.getSyslogPriority()) {
        _SyslogPriorityProperty.setSyslogPriority(syslogPriority);
        sendSyslogPriorityUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

int32 ServiceStub::getSyslogPriority() const {
    return _SyslogPriorityProperty.getSyslogPriority();
}

void ServiceStub::sendSyslogIdentifierUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SyslogIdentifierUpdate payload(_SyslogIdentifierProperty);

        LOG_INFO ("-> send%s", "SyslogIdentifierUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("SyslogIdentifier", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SyslogIdentifierUpdate");
    }
}

void ServiceStub::onSyslogIdentifierGet(const ::boost::shared_ptr< SyslogIdentifierGet >& syslogIdentifier) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SyslogIdentifierGet", syslogIdentifier->getAct());
    sendSyslogIdentifierGetUpdate(_SyslogIdentifierProperty.getSyslogIdentifier(), syslogIdentifier->getAct());
}

void ServiceStub::sendSyslogIdentifierGetUpdate(const ::std::string& syslogIdentifier, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SyslogIdentifierGet payload(syslogIdentifier);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SyslogIdentifierGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setSyslogIdentifier(const ::std::string& syslogIdentifier) {
    if(syslogIdentifier!=_SyslogIdentifierProperty.getSyslogIdentifier()) {
        _SyslogIdentifierProperty.setSyslogIdentifier(syslogIdentifier);
        sendSyslogIdentifierUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& ServiceStub::getSyslogIdentifier() const {
    return _SyslogIdentifierProperty.getSyslogIdentifier();
}

::std::string& ServiceStub::getSyslogIdentifierMutable() {
    return _SyslogIdentifierProperty.getSyslogIdentifierMutable();
}

void ServiceStub::sendSyslogLevelPrefixUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SyslogLevelPrefixUpdate payload(_SyslogLevelPrefixProperty);

        LOG_INFO ("-> send%s", "SyslogLevelPrefixUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("SyslogLevelPrefix", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SyslogLevelPrefixUpdate");
    }
}

void ServiceStub::onSyslogLevelPrefixGet(const ::boost::shared_ptr< SyslogLevelPrefixGet >& syslogLevelPrefix) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SyslogLevelPrefixGet", syslogLevelPrefix->getAct());
    sendSyslogLevelPrefixGetUpdate(_SyslogLevelPrefixProperty.getSyslogLevelPrefix(), syslogLevelPrefix->getAct());
}

void ServiceStub::sendSyslogLevelPrefixGetUpdate(bool syslogLevelPrefix, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SyslogLevelPrefixGet payload(syslogLevelPrefix);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SyslogLevelPrefixGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setSyslogLevelPrefix(bool syslogLevelPrefix) {
    if(syslogLevelPrefix!=_SyslogLevelPrefixProperty.getSyslogLevelPrefix()) {
        _SyslogLevelPrefixProperty.setSyslogLevelPrefix(syslogLevelPrefix);
        sendSyslogLevelPrefixUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool ServiceStub::getSyslogLevelPrefix() const {
    return _SyslogLevelPrefixProperty.getSyslogLevelPrefix();
}

void ServiceStub::sendCapabilitiesUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        CapabilitiesUpdate payload(_CapabilitiesProperty);

        LOG_INFO ("-> send%s", "CapabilitiesUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Capabilities", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "CapabilitiesUpdate");
    }
}

void ServiceStub::onCapabilitiesGet(const ::boost::shared_ptr< CapabilitiesGet >& capabilities) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "CapabilitiesGet", capabilities->getAct());
    sendCapabilitiesGetUpdate(_CapabilitiesProperty.getCapabilities(), capabilities->getAct());
}

void ServiceStub::sendCapabilitiesGetUpdate(const ::std::string& capabilities, act_t act) {
    ::asf::dbus::DBusVariant variant;
    CapabilitiesGet payload(capabilities);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "CapabilitiesGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setCapabilities(const ::std::string& capabilities) {
    if(capabilities!=_CapabilitiesProperty.getCapabilities()) {
        _CapabilitiesProperty.setCapabilities(capabilities);
        sendCapabilitiesUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& ServiceStub::getCapabilities() const {
    return _CapabilitiesProperty.getCapabilities();
}

::std::string& ServiceStub::getCapabilitiesMutable() {
    return _CapabilitiesProperty.getCapabilitiesMutable();
}

void ServiceStub::sendSecureBitsUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SecureBitsUpdate payload(_SecureBitsProperty);

        LOG_INFO ("-> send%s", "SecureBitsUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("SecureBits", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SecureBitsUpdate");
    }
}

void ServiceStub::onSecureBitsGet(const ::boost::shared_ptr< SecureBitsGet >& secureBits) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SecureBitsGet", secureBits->getAct());
    sendSecureBitsGetUpdate(_SecureBitsProperty.getSecureBits(), secureBits->getAct());
}

void ServiceStub::sendSecureBitsGetUpdate(int32 secureBits, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SecureBitsGet payload(secureBits);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SecureBitsGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setSecureBits(int32 secureBits) {
    if(secureBits!=_SecureBitsProperty.getSecureBits()) {
        _SecureBitsProperty.setSecureBits(secureBits);
        sendSecureBitsUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

int32 ServiceStub::getSecureBits() const {
    return _SecureBitsProperty.getSecureBits();
}

void ServiceStub::sendCapabilityBoundingSetUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        CapabilityBoundingSetUpdate payload(_CapabilityBoundingSetProperty);

        LOG_INFO ("-> send%s", "CapabilityBoundingSetUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("CapabilityBoundingSet", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "CapabilityBoundingSetUpdate");
    }
}

void ServiceStub::onCapabilityBoundingSetGet(const ::boost::shared_ptr< CapabilityBoundingSetGet >& capabilityBoundingSet) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "CapabilityBoundingSetGet", capabilityBoundingSet->getAct());
    sendCapabilityBoundingSetGetUpdate(_CapabilityBoundingSetProperty.getCapabilityBoundingSet(), capabilityBoundingSet->getAct());
}

void ServiceStub::sendCapabilityBoundingSetGetUpdate(uint64 capabilityBoundingSet, act_t act) {
    ::asf::dbus::DBusVariant variant;
    CapabilityBoundingSetGet payload(capabilityBoundingSet);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "CapabilityBoundingSetGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setCapabilityBoundingSet(uint64 capabilityBoundingSet) {
    if(capabilityBoundingSet!=_CapabilityBoundingSetProperty.getCapabilityBoundingSet()) {
        _CapabilityBoundingSetProperty.setCapabilityBoundingSet(capabilityBoundingSet);
        sendCapabilityBoundingSetUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ServiceStub::getCapabilityBoundingSet() const {
    return _CapabilityBoundingSetProperty.getCapabilityBoundingSet();
}

void ServiceStub::sendUserUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        UserUpdate payload(_UserProperty);

        LOG_INFO ("-> send%s", "UserUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("User", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "UserUpdate");
    }
}

void ServiceStub::onUserGet(const ::boost::shared_ptr< UserGet >& user) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "UserGet", user->getAct());
    sendUserGetUpdate(_UserProperty.getUser(), user->getAct());
}

void ServiceStub::sendUserGetUpdate(const ::std::string& user, act_t act) {
    ::asf::dbus::DBusVariant variant;
    UserGet payload(user);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "UserGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setUser(const ::std::string& user) {
    if(user!=_UserProperty.getUser()) {
        _UserProperty.setUser(user);
        sendUserUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& ServiceStub::getUser() const {
    return _UserProperty.getUser();
}

::std::string& ServiceStub::getUserMutable() {
    return _UserProperty.getUserMutable();
}

void ServiceStub::sendGroupUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        GroupUpdate payload(_GroupProperty);

        LOG_INFO ("-> send%s", "GroupUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Group", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "GroupUpdate");
    }
}

void ServiceStub::onGroupGet(const ::boost::shared_ptr< GroupGet >& group) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "GroupGet", group->getAct());
    sendGroupGetUpdate(_GroupProperty.getGroup(), group->getAct());
}

void ServiceStub::sendGroupGetUpdate(const ::std::string& group, act_t act) {
    ::asf::dbus::DBusVariant variant;
    GroupGet payload(group);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "GroupGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setGroup(const ::std::string& group) {
    if(group!=_GroupProperty.getGroup()) {
        _GroupProperty.setGroup(group);
        sendGroupUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& ServiceStub::getGroup() const {
    return _GroupProperty.getGroup();
}

::std::string& ServiceStub::getGroupMutable() {
    return _GroupProperty.getGroupMutable();
}

void ServiceStub::sendSupplementaryGroupsUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SupplementaryGroupsUpdate payload(_SupplementaryGroupsProperty);

        LOG_INFO ("-> send%s", "SupplementaryGroupsUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("SupplementaryGroups", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SupplementaryGroupsUpdate");
    }
}

void ServiceStub::onSupplementaryGroupsGet(const ::boost::shared_ptr< SupplementaryGroupsGet >& supplementaryGroups) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SupplementaryGroupsGet", supplementaryGroups->getAct());
    sendSupplementaryGroupsGetUpdate(_SupplementaryGroupsProperty.getSupplementaryGroups(), supplementaryGroups->getAct());
}

void ServiceStub::sendSupplementaryGroupsGetUpdate(const ::std::vector< ::std::string >& supplementaryGroups, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SupplementaryGroupsGet payload(supplementaryGroups);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SupplementaryGroupsGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setSupplementaryGroups(const ::std::vector< ::std::string >& supplementaryGroups) {
    if(supplementaryGroups!=_SupplementaryGroupsProperty.getSupplementaryGroups()) {
        _SupplementaryGroupsProperty.setSupplementaryGroups(supplementaryGroups);
        sendSupplementaryGroupsUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::string >& ServiceStub::getSupplementaryGroups() const {
    return _SupplementaryGroupsProperty.getSupplementaryGroups();
}

::std::vector< ::std::string >& ServiceStub::getSupplementaryGroupsMutable() {
    return _SupplementaryGroupsProperty.getSupplementaryGroupsMutable();
}

void ServiceStub::sendPAMNameUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        PAMNameUpdate payload(_PAMNameProperty);

        LOG_INFO ("-> send%s", "PAMNameUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("PAMName", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "PAMNameUpdate");
    }
}

void ServiceStub::onPAMNameGet(const ::boost::shared_ptr< PAMNameGet >& pAMName) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "PAMNameGet", pAMName->getAct());
    sendPAMNameGetUpdate(_PAMNameProperty.getPAMName(), pAMName->getAct());
}

void ServiceStub::sendPAMNameGetUpdate(const ::std::string& pAMName, act_t act) {
    ::asf::dbus::DBusVariant variant;
    PAMNameGet payload(pAMName);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "PAMNameGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setPAMName(const ::std::string& pAMName) {
    if(pAMName!=_PAMNameProperty.getPAMName()) {
        _PAMNameProperty.setPAMName(pAMName);
        sendPAMNameUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& ServiceStub::getPAMName() const {
    return _PAMNameProperty.getPAMName();
}

::std::string& ServiceStub::getPAMNameMutable() {
    return _PAMNameProperty.getPAMNameMutable();
}

void ServiceStub::sendReadWriteDirectoriesUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ReadWriteDirectoriesUpdate payload(_ReadWriteDirectoriesProperty);

        LOG_INFO ("-> send%s", "ReadWriteDirectoriesUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ReadWriteDirectories", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ReadWriteDirectoriesUpdate");
    }
}

void ServiceStub::onReadWriteDirectoriesGet(const ::boost::shared_ptr< ReadWriteDirectoriesGet >& readWriteDirectories) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ReadWriteDirectoriesGet", readWriteDirectories->getAct());
    sendReadWriteDirectoriesGetUpdate(_ReadWriteDirectoriesProperty.getReadWriteDirectories(), readWriteDirectories->getAct());
}

void ServiceStub::sendReadWriteDirectoriesGetUpdate(const ::std::vector< ::std::string >& readWriteDirectories, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ReadWriteDirectoriesGet payload(readWriteDirectories);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ReadWriteDirectoriesGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setReadWriteDirectories(const ::std::vector< ::std::string >& readWriteDirectories) {
    if(readWriteDirectories!=_ReadWriteDirectoriesProperty.getReadWriteDirectories()) {
        _ReadWriteDirectoriesProperty.setReadWriteDirectories(readWriteDirectories);
        sendReadWriteDirectoriesUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::string >& ServiceStub::getReadWriteDirectories() const {
    return _ReadWriteDirectoriesProperty.getReadWriteDirectories();
}

::std::vector< ::std::string >& ServiceStub::getReadWriteDirectoriesMutable() {
    return _ReadWriteDirectoriesProperty.getReadWriteDirectoriesMutable();
}

void ServiceStub::sendReadOnlyDirectoriesUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ReadOnlyDirectoriesUpdate payload(_ReadOnlyDirectoriesProperty);

        LOG_INFO ("-> send%s", "ReadOnlyDirectoriesUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ReadOnlyDirectories", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ReadOnlyDirectoriesUpdate");
    }
}

void ServiceStub::onReadOnlyDirectoriesGet(const ::boost::shared_ptr< ReadOnlyDirectoriesGet >& readOnlyDirectories) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ReadOnlyDirectoriesGet", readOnlyDirectories->getAct());
    sendReadOnlyDirectoriesGetUpdate(_ReadOnlyDirectoriesProperty.getReadOnlyDirectories(), readOnlyDirectories->getAct());
}

void ServiceStub::sendReadOnlyDirectoriesGetUpdate(const ::std::vector< ::std::string >& readOnlyDirectories, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ReadOnlyDirectoriesGet payload(readOnlyDirectories);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ReadOnlyDirectoriesGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setReadOnlyDirectories(const ::std::vector< ::std::string >& readOnlyDirectories) {
    if(readOnlyDirectories!=_ReadOnlyDirectoriesProperty.getReadOnlyDirectories()) {
        _ReadOnlyDirectoriesProperty.setReadOnlyDirectories(readOnlyDirectories);
        sendReadOnlyDirectoriesUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::string >& ServiceStub::getReadOnlyDirectories() const {
    return _ReadOnlyDirectoriesProperty.getReadOnlyDirectories();
}

::std::vector< ::std::string >& ServiceStub::getReadOnlyDirectoriesMutable() {
    return _ReadOnlyDirectoriesProperty.getReadOnlyDirectoriesMutable();
}

void ServiceStub::sendInaccessibleDirectoriesUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        InaccessibleDirectoriesUpdate payload(_InaccessibleDirectoriesProperty);

        LOG_INFO ("-> send%s", "InaccessibleDirectoriesUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("InaccessibleDirectories", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "InaccessibleDirectoriesUpdate");
    }
}

void ServiceStub::onInaccessibleDirectoriesGet(const ::boost::shared_ptr< InaccessibleDirectoriesGet >& inaccessibleDirectories) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "InaccessibleDirectoriesGet", inaccessibleDirectories->getAct());
    sendInaccessibleDirectoriesGetUpdate(_InaccessibleDirectoriesProperty.getInaccessibleDirectories(), inaccessibleDirectories->getAct());
}

void ServiceStub::sendInaccessibleDirectoriesGetUpdate(const ::std::vector< ::std::string >& inaccessibleDirectories, act_t act) {
    ::asf::dbus::DBusVariant variant;
    InaccessibleDirectoriesGet payload(inaccessibleDirectories);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "InaccessibleDirectoriesGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setInaccessibleDirectories(const ::std::vector< ::std::string >& inaccessibleDirectories) {
    if(inaccessibleDirectories!=_InaccessibleDirectoriesProperty.getInaccessibleDirectories()) {
        _InaccessibleDirectoriesProperty.setInaccessibleDirectories(inaccessibleDirectories);
        sendInaccessibleDirectoriesUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::string >& ServiceStub::getInaccessibleDirectories() const {
    return _InaccessibleDirectoriesProperty.getInaccessibleDirectories();
}

::std::vector< ::std::string >& ServiceStub::getInaccessibleDirectoriesMutable() {
    return _InaccessibleDirectoriesProperty.getInaccessibleDirectoriesMutable();
}

void ServiceStub::sendMountFlagsUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        MountFlagsUpdate payload(_MountFlagsProperty);

        LOG_INFO ("-> send%s", "MountFlagsUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("MountFlags", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "MountFlagsUpdate");
    }
}

void ServiceStub::onMountFlagsGet(const ::boost::shared_ptr< MountFlagsGet >& mountFlags) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "MountFlagsGet", mountFlags->getAct());
    sendMountFlagsGetUpdate(_MountFlagsProperty.getMountFlags(), mountFlags->getAct());
}

void ServiceStub::sendMountFlagsGetUpdate(uint64 mountFlags, act_t act) {
    ::asf::dbus::DBusVariant variant;
    MountFlagsGet payload(mountFlags);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "MountFlagsGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setMountFlags(uint64 mountFlags) {
    if(mountFlags!=_MountFlagsProperty.getMountFlags()) {
        _MountFlagsProperty.setMountFlags(mountFlags);
        sendMountFlagsUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ServiceStub::getMountFlags() const {
    return _MountFlagsProperty.getMountFlags();
}

void ServiceStub::sendPrivateTmpUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        PrivateTmpUpdate payload(_PrivateTmpProperty);

        LOG_INFO ("-> send%s", "PrivateTmpUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("PrivateTmp", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "PrivateTmpUpdate");
    }
}

void ServiceStub::onPrivateTmpGet(const ::boost::shared_ptr< PrivateTmpGet >& privateTmp) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "PrivateTmpGet", privateTmp->getAct());
    sendPrivateTmpGetUpdate(_PrivateTmpProperty.getPrivateTmp(), privateTmp->getAct());
}

void ServiceStub::sendPrivateTmpGetUpdate(bool privateTmp, act_t act) {
    ::asf::dbus::DBusVariant variant;
    PrivateTmpGet payload(privateTmp);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "PrivateTmpGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setPrivateTmp(bool privateTmp) {
    if(privateTmp!=_PrivateTmpProperty.getPrivateTmp()) {
        _PrivateTmpProperty.setPrivateTmp(privateTmp);
        sendPrivateTmpUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool ServiceStub::getPrivateTmp() const {
    return _PrivateTmpProperty.getPrivateTmp();
}

void ServiceStub::sendPrivateNetworkUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        PrivateNetworkUpdate payload(_PrivateNetworkProperty);

        LOG_INFO ("-> send%s", "PrivateNetworkUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("PrivateNetwork", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "PrivateNetworkUpdate");
    }
}

void ServiceStub::onPrivateNetworkGet(const ::boost::shared_ptr< PrivateNetworkGet >& privateNetwork) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "PrivateNetworkGet", privateNetwork->getAct());
    sendPrivateNetworkGetUpdate(_PrivateNetworkProperty.getPrivateNetwork(), privateNetwork->getAct());
}

void ServiceStub::sendPrivateNetworkGetUpdate(bool privateNetwork, act_t act) {
    ::asf::dbus::DBusVariant variant;
    PrivateNetworkGet payload(privateNetwork);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "PrivateNetworkGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setPrivateNetwork(bool privateNetwork) {
    if(privateNetwork!=_PrivateNetworkProperty.getPrivateNetwork()) {
        _PrivateNetworkProperty.setPrivateNetwork(privateNetwork);
        sendPrivateNetworkUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool ServiceStub::getPrivateNetwork() const {
    return _PrivateNetworkProperty.getPrivateNetwork();
}

void ServiceStub::sendPrivateDevicesUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        PrivateDevicesUpdate payload(_PrivateDevicesProperty);

        LOG_INFO ("-> send%s", "PrivateDevicesUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("PrivateDevices", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "PrivateDevicesUpdate");
    }
}

void ServiceStub::onPrivateDevicesGet(const ::boost::shared_ptr< PrivateDevicesGet >& privateDevices) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "PrivateDevicesGet", privateDevices->getAct());
    sendPrivateDevicesGetUpdate(_PrivateDevicesProperty.getPrivateDevices(), privateDevices->getAct());
}

void ServiceStub::sendPrivateDevicesGetUpdate(bool privateDevices, act_t act) {
    ::asf::dbus::DBusVariant variant;
    PrivateDevicesGet payload(privateDevices);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "PrivateDevicesGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setPrivateDevices(bool privateDevices) {
    if(privateDevices!=_PrivateDevicesProperty.getPrivateDevices()) {
        _PrivateDevicesProperty.setPrivateDevices(privateDevices);
        sendPrivateDevicesUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool ServiceStub::getPrivateDevices() const {
    return _PrivateDevicesProperty.getPrivateDevices();
}

void ServiceStub::sendProtectHomeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ProtectHomeUpdate payload(_ProtectHomeProperty);

        LOG_INFO ("-> send%s", "ProtectHomeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ProtectHome", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ProtectHomeUpdate");
    }
}

void ServiceStub::onProtectHomeGet(const ::boost::shared_ptr< ProtectHomeGet >& protectHome) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ProtectHomeGet", protectHome->getAct());
    sendProtectHomeGetUpdate(_ProtectHomeProperty.getProtectHome(), protectHome->getAct());
}

void ServiceStub::sendProtectHomeGetUpdate(const ::std::string& protectHome, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ProtectHomeGet payload(protectHome);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ProtectHomeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setProtectHome(const ::std::string& protectHome) {
    if(protectHome!=_ProtectHomeProperty.getProtectHome()) {
        _ProtectHomeProperty.setProtectHome(protectHome);
        sendProtectHomeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& ServiceStub::getProtectHome() const {
    return _ProtectHomeProperty.getProtectHome();
}

::std::string& ServiceStub::getProtectHomeMutable() {
    return _ProtectHomeProperty.getProtectHomeMutable();
}

void ServiceStub::sendProtectSystemUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ProtectSystemUpdate payload(_ProtectSystemProperty);

        LOG_INFO ("-> send%s", "ProtectSystemUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ProtectSystem", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ProtectSystemUpdate");
    }
}

void ServiceStub::onProtectSystemGet(const ::boost::shared_ptr< ProtectSystemGet >& protectSystem) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ProtectSystemGet", protectSystem->getAct());
    sendProtectSystemGetUpdate(_ProtectSystemProperty.getProtectSystem(), protectSystem->getAct());
}

void ServiceStub::sendProtectSystemGetUpdate(const ::std::string& protectSystem, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ProtectSystemGet payload(protectSystem);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ProtectSystemGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setProtectSystem(const ::std::string& protectSystem) {
    if(protectSystem!=_ProtectSystemProperty.getProtectSystem()) {
        _ProtectSystemProperty.setProtectSystem(protectSystem);
        sendProtectSystemUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& ServiceStub::getProtectSystem() const {
    return _ProtectSystemProperty.getProtectSystem();
}

::std::string& ServiceStub::getProtectSystemMutable() {
    return _ProtectSystemProperty.getProtectSystemMutable();
}

void ServiceStub::sendSameProcessGroupUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SameProcessGroupUpdate payload(_SameProcessGroupProperty);

        LOG_INFO ("-> send%s", "SameProcessGroupUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("SameProcessGroup", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SameProcessGroupUpdate");
    }
}

void ServiceStub::onSameProcessGroupGet(const ::boost::shared_ptr< SameProcessGroupGet >& sameProcessGroup) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SameProcessGroupGet", sameProcessGroup->getAct());
    sendSameProcessGroupGetUpdate(_SameProcessGroupProperty.getSameProcessGroup(), sameProcessGroup->getAct());
}

void ServiceStub::sendSameProcessGroupGetUpdate(bool sameProcessGroup, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SameProcessGroupGet payload(sameProcessGroup);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SameProcessGroupGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setSameProcessGroup(bool sameProcessGroup) {
    if(sameProcessGroup!=_SameProcessGroupProperty.getSameProcessGroup()) {
        _SameProcessGroupProperty.setSameProcessGroup(sameProcessGroup);
        sendSameProcessGroupUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool ServiceStub::getSameProcessGroup() const {
    return _SameProcessGroupProperty.getSameProcessGroup();
}

void ServiceStub::sendUtmpIdentifierUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        UtmpIdentifierUpdate payload(_UtmpIdentifierProperty);

        LOG_INFO ("-> send%s", "UtmpIdentifierUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("UtmpIdentifier", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "UtmpIdentifierUpdate");
    }
}

void ServiceStub::onUtmpIdentifierGet(const ::boost::shared_ptr< UtmpIdentifierGet >& utmpIdentifier) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "UtmpIdentifierGet", utmpIdentifier->getAct());
    sendUtmpIdentifierGetUpdate(_UtmpIdentifierProperty.getUtmpIdentifier(), utmpIdentifier->getAct());
}

void ServiceStub::sendUtmpIdentifierGetUpdate(const ::std::string& utmpIdentifier, act_t act) {
    ::asf::dbus::DBusVariant variant;
    UtmpIdentifierGet payload(utmpIdentifier);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "UtmpIdentifierGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setUtmpIdentifier(const ::std::string& utmpIdentifier) {
    if(utmpIdentifier!=_UtmpIdentifierProperty.getUtmpIdentifier()) {
        _UtmpIdentifierProperty.setUtmpIdentifier(utmpIdentifier);
        sendUtmpIdentifierUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& ServiceStub::getUtmpIdentifier() const {
    return _UtmpIdentifierProperty.getUtmpIdentifier();
}

::std::string& ServiceStub::getUtmpIdentifierMutable() {
    return _UtmpIdentifierProperty.getUtmpIdentifierMutable();
}

void ServiceStub::sendUtmpModeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        UtmpModeUpdate payload(_UtmpModeProperty);

        LOG_INFO ("-> send%s", "UtmpModeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("UtmpMode", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "UtmpModeUpdate");
    }
}

void ServiceStub::onUtmpModeGet(const ::boost::shared_ptr< UtmpModeGet >& utmpMode) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "UtmpModeGet", utmpMode->getAct());
    sendUtmpModeGetUpdate(_UtmpModeProperty.getUtmpMode(), utmpMode->getAct());
}

void ServiceStub::sendUtmpModeGetUpdate(const ::std::string& utmpMode, act_t act) {
    ::asf::dbus::DBusVariant variant;
    UtmpModeGet payload(utmpMode);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "UtmpModeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setUtmpMode(const ::std::string& utmpMode) {
    if(utmpMode!=_UtmpModeProperty.getUtmpMode()) {
        _UtmpModeProperty.setUtmpMode(utmpMode);
        sendUtmpModeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& ServiceStub::getUtmpMode() const {
    return _UtmpModeProperty.getUtmpMode();
}

::std::string& ServiceStub::getUtmpModeMutable() {
    return _UtmpModeProperty.getUtmpModeMutable();
}

void ServiceStub::sendSELinuxContextUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SELinuxContextUpdate payload(_SELinuxContextProperty);

        LOG_INFO ("-> send%s", "SELinuxContextUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("SELinuxContext", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SELinuxContextUpdate");
    }
}

void ServiceStub::onSELinuxContextGet(const ::boost::shared_ptr< SELinuxContextGet >& sELinuxContext) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SELinuxContextGet", sELinuxContext->getAct());
    sendSELinuxContextGetUpdate(_SELinuxContextProperty.getSELinuxContext(), sELinuxContext->getAct());
}

void ServiceStub::sendSELinuxContextGetUpdate(const securityContext& sELinuxContext, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SELinuxContextGet payload(sELinuxContext);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SELinuxContextGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setSELinuxContext(const securityContext& sELinuxContext) {
    if(sELinuxContext!=_SELinuxContextProperty.getSELinuxContext()) {
        _SELinuxContextProperty.setSELinuxContext(sELinuxContext);
        sendSELinuxContextUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const securityContext& ServiceStub::getSELinuxContext() const {
    return _SELinuxContextProperty.getSELinuxContext();
}

securityContext& ServiceStub::getSELinuxContextMutable() {
    return _SELinuxContextProperty.getSELinuxContextMutable();
}

void ServiceStub::sendAppArmorProfileUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        AppArmorProfileUpdate payload(_AppArmorProfileProperty);

        LOG_INFO ("-> send%s", "AppArmorProfileUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("AppArmorProfile", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "AppArmorProfileUpdate");
    }
}

void ServiceStub::onAppArmorProfileGet(const ::boost::shared_ptr< AppArmorProfileGet >& appArmorProfile) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AppArmorProfileGet", appArmorProfile->getAct());
    sendAppArmorProfileGetUpdate(_AppArmorProfileProperty.getAppArmorProfile(), appArmorProfile->getAct());
}

void ServiceStub::sendAppArmorProfileGetUpdate(const ArmorProfile& appArmorProfile, act_t act) {
    ::asf::dbus::DBusVariant variant;
    AppArmorProfileGet payload(appArmorProfile);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AppArmorProfileGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setAppArmorProfile(const ArmorProfile& appArmorProfile) {
    if(appArmorProfile!=_AppArmorProfileProperty.getAppArmorProfile()) {
        _AppArmorProfileProperty.setAppArmorProfile(appArmorProfile);
        sendAppArmorProfileUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ArmorProfile& ServiceStub::getAppArmorProfile() const {
    return _AppArmorProfileProperty.getAppArmorProfile();
}

ArmorProfile& ServiceStub::getAppArmorProfileMutable() {
    return _AppArmorProfileProperty.getAppArmorProfileMutable();
}

void ServiceStub::sendSmackProcessLabelUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SmackProcessLabelUpdate payload(_SmackProcessLabelProperty);

        LOG_INFO ("-> send%s", "SmackProcessLabelUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("SmackProcessLabel", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SmackProcessLabelUpdate");
    }
}

void ServiceStub::onSmackProcessLabelGet(const ::boost::shared_ptr< SmackProcessLabelGet >& smackProcessLabel) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SmackProcessLabelGet", smackProcessLabel->getAct());
    sendSmackProcessLabelGetUpdate(_SmackProcessLabelProperty.getSmackProcessLabel(), smackProcessLabel->getAct());
}

void ServiceStub::sendSmackProcessLabelGetUpdate(const ProcessLabel& smackProcessLabel, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SmackProcessLabelGet payload(smackProcessLabel);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SmackProcessLabelGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setSmackProcessLabel(const ProcessLabel& smackProcessLabel) {
    if(smackProcessLabel!=_SmackProcessLabelProperty.getSmackProcessLabel()) {
        _SmackProcessLabelProperty.setSmackProcessLabel(smackProcessLabel);
        sendSmackProcessLabelUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ProcessLabel& ServiceStub::getSmackProcessLabel() const {
    return _SmackProcessLabelProperty.getSmackProcessLabel();
}

ProcessLabel& ServiceStub::getSmackProcessLabelMutable() {
    return _SmackProcessLabelProperty.getSmackProcessLabelMutable();
}

void ServiceStub::sendIgnoreSIGPIPEUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        IgnoreSIGPIPEUpdate payload(_IgnoreSIGPIPEProperty);

        LOG_INFO ("-> send%s", "IgnoreSIGPIPEUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("IgnoreSIGPIPE", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "IgnoreSIGPIPEUpdate");
    }
}

void ServiceStub::onIgnoreSIGPIPEGet(const ::boost::shared_ptr< IgnoreSIGPIPEGet >& ignoreSIGPIPE) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "IgnoreSIGPIPEGet", ignoreSIGPIPE->getAct());
    sendIgnoreSIGPIPEGetUpdate(_IgnoreSIGPIPEProperty.getIgnoreSIGPIPE(), ignoreSIGPIPE->getAct());
}

void ServiceStub::sendIgnoreSIGPIPEGetUpdate(bool ignoreSIGPIPE, act_t act) {
    ::asf::dbus::DBusVariant variant;
    IgnoreSIGPIPEGet payload(ignoreSIGPIPE);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "IgnoreSIGPIPEGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setIgnoreSIGPIPE(bool ignoreSIGPIPE) {
    if(ignoreSIGPIPE!=_IgnoreSIGPIPEProperty.getIgnoreSIGPIPE()) {
        _IgnoreSIGPIPEProperty.setIgnoreSIGPIPE(ignoreSIGPIPE);
        sendIgnoreSIGPIPEUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool ServiceStub::getIgnoreSIGPIPE() const {
    return _IgnoreSIGPIPEProperty.getIgnoreSIGPIPE();
}

void ServiceStub::sendNoNewPrivilegesUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        NoNewPrivilegesUpdate payload(_NoNewPrivilegesProperty);

        LOG_INFO ("-> send%s", "NoNewPrivilegesUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("NoNewPrivileges", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "NoNewPrivilegesUpdate");
    }
}

void ServiceStub::onNoNewPrivilegesGet(const ::boost::shared_ptr< NoNewPrivilegesGet >& noNewPrivileges) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "NoNewPrivilegesGet", noNewPrivileges->getAct());
    sendNoNewPrivilegesGetUpdate(_NoNewPrivilegesProperty.getNoNewPrivileges(), noNewPrivileges->getAct());
}

void ServiceStub::sendNoNewPrivilegesGetUpdate(bool noNewPrivileges, act_t act) {
    ::asf::dbus::DBusVariant variant;
    NoNewPrivilegesGet payload(noNewPrivileges);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "NoNewPrivilegesGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setNoNewPrivileges(bool noNewPrivileges) {
    if(noNewPrivileges!=_NoNewPrivilegesProperty.getNoNewPrivileges()) {
        _NoNewPrivilegesProperty.setNoNewPrivileges(noNewPrivileges);
        sendNoNewPrivilegesUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool ServiceStub::getNoNewPrivileges() const {
    return _NoNewPrivilegesProperty.getNoNewPrivileges();
}

void ServiceStub::sendSystemCallFilterUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SystemCallFilterUpdate payload(_SystemCallFilterProperty);

        LOG_INFO ("-> send%s", "SystemCallFilterUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("SystemCallFilter", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SystemCallFilterUpdate");
    }
}

void ServiceStub::onSystemCallFilterGet(const ::boost::shared_ptr< SystemCallFilterGet >& systemCallFilter) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SystemCallFilterGet", systemCallFilter->getAct());
    sendSystemCallFilterGetUpdate(_SystemCallFilterProperty.getSystemCallFilter(), systemCallFilter->getAct());
}

void ServiceStub::sendSystemCallFilterGetUpdate(const systemCallFilter& systemCallFilter, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SystemCallFilterGet payload(systemCallFilter);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SystemCallFilterGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setSystemCallFilter(const systemCallFilter& systemCallFilter) {
    if(systemCallFilter!=_SystemCallFilterProperty.getSystemCallFilter()) {
        _SystemCallFilterProperty.setSystemCallFilter(systemCallFilter);
        sendSystemCallFilterUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const systemCallFilter& ServiceStub::getSystemCallFilter() const {
    return _SystemCallFilterProperty.getSystemCallFilter();
}

systemCallFilter& ServiceStub::getSystemCallFilterMutable() {
    return _SystemCallFilterProperty.getSystemCallFilterMutable();
}

void ServiceStub::sendSystemCallArchitecturesUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SystemCallArchitecturesUpdate payload(_SystemCallArchitecturesProperty);

        LOG_INFO ("-> send%s", "SystemCallArchitecturesUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("SystemCallArchitectures", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SystemCallArchitecturesUpdate");
    }
}

void ServiceStub::onSystemCallArchitecturesGet(const ::boost::shared_ptr< SystemCallArchitecturesGet >& systemCallArchitectures) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SystemCallArchitecturesGet", systemCallArchitectures->getAct());
    sendSystemCallArchitecturesGetUpdate(_SystemCallArchitecturesProperty.getSystemCallArchitectures(), systemCallArchitectures->getAct());
}

void ServiceStub::sendSystemCallArchitecturesGetUpdate(const ::std::vector< ::std::string >& systemCallArchitectures, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SystemCallArchitecturesGet payload(systemCallArchitectures);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SystemCallArchitecturesGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setSystemCallArchitectures(const ::std::vector< ::std::string >& systemCallArchitectures) {
    if(systemCallArchitectures!=_SystemCallArchitecturesProperty.getSystemCallArchitectures()) {
        _SystemCallArchitecturesProperty.setSystemCallArchitectures(systemCallArchitectures);
        sendSystemCallArchitecturesUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::string >& ServiceStub::getSystemCallArchitectures() const {
    return _SystemCallArchitecturesProperty.getSystemCallArchitectures();
}

::std::vector< ::std::string >& ServiceStub::getSystemCallArchitecturesMutable() {
    return _SystemCallArchitecturesProperty.getSystemCallArchitecturesMutable();
}

void ServiceStub::sendSystemCallErrorNumberUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SystemCallErrorNumberUpdate payload(_SystemCallErrorNumberProperty);

        LOG_INFO ("-> send%s", "SystemCallErrorNumberUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("SystemCallErrorNumber", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SystemCallErrorNumberUpdate");
    }
}

void ServiceStub::onSystemCallErrorNumberGet(const ::boost::shared_ptr< SystemCallErrorNumberGet >& systemCallErrorNumber) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SystemCallErrorNumberGet", systemCallErrorNumber->getAct());
    sendSystemCallErrorNumberGetUpdate(_SystemCallErrorNumberProperty.getSystemCallErrorNumber(), systemCallErrorNumber->getAct());
}

void ServiceStub::sendSystemCallErrorNumberGetUpdate(int32 systemCallErrorNumber, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SystemCallErrorNumberGet payload(systemCallErrorNumber);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SystemCallErrorNumberGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setSystemCallErrorNumber(int32 systemCallErrorNumber) {
    if(systemCallErrorNumber!=_SystemCallErrorNumberProperty.getSystemCallErrorNumber()) {
        _SystemCallErrorNumberProperty.setSystemCallErrorNumber(systemCallErrorNumber);
        sendSystemCallErrorNumberUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

int32 ServiceStub::getSystemCallErrorNumber() const {
    return _SystemCallErrorNumberProperty.getSystemCallErrorNumber();
}

void ServiceStub::sendPersonalityUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        PersonalityUpdate payload(_PersonalityProperty);

        LOG_INFO ("-> send%s", "PersonalityUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Personality", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "PersonalityUpdate");
    }
}

void ServiceStub::onPersonalityGet(const ::boost::shared_ptr< PersonalityGet >& personality) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "PersonalityGet", personality->getAct());
    sendPersonalityGetUpdate(_PersonalityProperty.getPersonality(), personality->getAct());
}

void ServiceStub::sendPersonalityGetUpdate(const ::std::string& personality, act_t act) {
    ::asf::dbus::DBusVariant variant;
    PersonalityGet payload(personality);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "PersonalityGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setPersonality(const ::std::string& personality) {
    if(personality!=_PersonalityProperty.getPersonality()) {
        _PersonalityProperty.setPersonality(personality);
        sendPersonalityUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& ServiceStub::getPersonality() const {
    return _PersonalityProperty.getPersonality();
}

::std::string& ServiceStub::getPersonalityMutable() {
    return _PersonalityProperty.getPersonalityMutable();
}

void ServiceStub::sendRestrictAddressFamiliesUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        RestrictAddressFamiliesUpdate payload(_RestrictAddressFamiliesProperty);

        LOG_INFO ("-> send%s", "RestrictAddressFamiliesUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("RestrictAddressFamilies", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "RestrictAddressFamiliesUpdate");
    }
}

void ServiceStub::onRestrictAddressFamiliesGet(const ::boost::shared_ptr< RestrictAddressFamiliesGet >& restrictAddressFamilies) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "RestrictAddressFamiliesGet", restrictAddressFamilies->getAct());
    sendRestrictAddressFamiliesGetUpdate(_RestrictAddressFamiliesProperty.getRestrictAddressFamilies(), restrictAddressFamilies->getAct());
}

void ServiceStub::sendRestrictAddressFamiliesGetUpdate(const AddressFamily& restrictAddressFamilies, act_t act) {
    ::asf::dbus::DBusVariant variant;
    RestrictAddressFamiliesGet payload(restrictAddressFamilies);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "RestrictAddressFamiliesGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setRestrictAddressFamilies(const AddressFamily& restrictAddressFamilies) {
    if(restrictAddressFamilies!=_RestrictAddressFamiliesProperty.getRestrictAddressFamilies()) {
        _RestrictAddressFamiliesProperty.setRestrictAddressFamilies(restrictAddressFamilies);
        sendRestrictAddressFamiliesUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const AddressFamily& ServiceStub::getRestrictAddressFamilies() const {
    return _RestrictAddressFamiliesProperty.getRestrictAddressFamilies();
}

AddressFamily& ServiceStub::getRestrictAddressFamiliesMutable() {
    return _RestrictAddressFamiliesProperty.getRestrictAddressFamiliesMutable();
}

void ServiceStub::sendRuntimeDirectoryModeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        RuntimeDirectoryModeUpdate payload(_RuntimeDirectoryModeProperty);

        LOG_INFO ("-> send%s", "RuntimeDirectoryModeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("RuntimeDirectoryMode", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "RuntimeDirectoryModeUpdate");
    }
}

void ServiceStub::onRuntimeDirectoryModeGet(const ::boost::shared_ptr< RuntimeDirectoryModeGet >& runtimeDirectoryMode) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "RuntimeDirectoryModeGet", runtimeDirectoryMode->getAct());
    sendRuntimeDirectoryModeGetUpdate(_RuntimeDirectoryModeProperty.getRuntimeDirectoryMode(), runtimeDirectoryMode->getAct());
}

void ServiceStub::sendRuntimeDirectoryModeGetUpdate(uint32 runtimeDirectoryMode, act_t act) {
    ::asf::dbus::DBusVariant variant;
    RuntimeDirectoryModeGet payload(runtimeDirectoryMode);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "RuntimeDirectoryModeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setRuntimeDirectoryMode(uint32 runtimeDirectoryMode) {
    if(runtimeDirectoryMode!=_RuntimeDirectoryModeProperty.getRuntimeDirectoryMode()) {
        _RuntimeDirectoryModeProperty.setRuntimeDirectoryMode(runtimeDirectoryMode);
        sendRuntimeDirectoryModeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint32 ServiceStub::getRuntimeDirectoryMode() const {
    return _RuntimeDirectoryModeProperty.getRuntimeDirectoryMode();
}

void ServiceStub::sendRuntimeDirectoryUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        RuntimeDirectoryUpdate payload(_RuntimeDirectoryProperty);

        LOG_INFO ("-> send%s", "RuntimeDirectoryUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("RuntimeDirectory", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "RuntimeDirectoryUpdate");
    }
}

void ServiceStub::onRuntimeDirectoryGet(const ::boost::shared_ptr< RuntimeDirectoryGet >& runtimeDirectory) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "RuntimeDirectoryGet", runtimeDirectory->getAct());
    sendRuntimeDirectoryGetUpdate(_RuntimeDirectoryProperty.getRuntimeDirectory(), runtimeDirectory->getAct());
}

void ServiceStub::sendRuntimeDirectoryGetUpdate(const ::std::vector< ::std::string >& runtimeDirectory, act_t act) {
    ::asf::dbus::DBusVariant variant;
    RuntimeDirectoryGet payload(runtimeDirectory);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "RuntimeDirectoryGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setRuntimeDirectory(const ::std::vector< ::std::string >& runtimeDirectory) {
    if(runtimeDirectory!=_RuntimeDirectoryProperty.getRuntimeDirectory()) {
        _RuntimeDirectoryProperty.setRuntimeDirectory(runtimeDirectory);
        sendRuntimeDirectoryUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::string >& ServiceStub::getRuntimeDirectory() const {
    return _RuntimeDirectoryProperty.getRuntimeDirectory();
}

::std::vector< ::std::string >& ServiceStub::getRuntimeDirectoryMutable() {
    return _RuntimeDirectoryProperty.getRuntimeDirectoryMutable();
}

void ServiceStub::sendKillModeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        KillModeUpdate payload(_KillModeProperty);

        LOG_INFO ("-> send%s", "KillModeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("KillMode", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "KillModeUpdate");
    }
}

void ServiceStub::onKillModeGet(const ::boost::shared_ptr< KillModeGet >& killMode) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "KillModeGet", killMode->getAct());
    sendKillModeGetUpdate(_KillModeProperty.getKillMode(), killMode->getAct());
}

void ServiceStub::sendKillModeGetUpdate(const ::std::string& killMode, act_t act) {
    ::asf::dbus::DBusVariant variant;
    KillModeGet payload(killMode);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "KillModeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setKillMode(const ::std::string& killMode) {
    if(killMode!=_KillModeProperty.getKillMode()) {
        _KillModeProperty.setKillMode(killMode);
        sendKillModeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& ServiceStub::getKillMode() const {
    return _KillModeProperty.getKillMode();
}

::std::string& ServiceStub::getKillModeMutable() {
    return _KillModeProperty.getKillModeMutable();
}

void ServiceStub::sendKillSignalUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        KillSignalUpdate payload(_KillSignalProperty);

        LOG_INFO ("-> send%s", "KillSignalUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("KillSignal", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "KillSignalUpdate");
    }
}

void ServiceStub::onKillSignalGet(const ::boost::shared_ptr< KillSignalGet >& killSignal) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "KillSignalGet", killSignal->getAct());
    sendKillSignalGetUpdate(_KillSignalProperty.getKillSignal(), killSignal->getAct());
}

void ServiceStub::sendKillSignalGetUpdate(int32 killSignal, act_t act) {
    ::asf::dbus::DBusVariant variant;
    KillSignalGet payload(killSignal);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "KillSignalGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setKillSignal(int32 killSignal) {
    if(killSignal!=_KillSignalProperty.getKillSignal()) {
        _KillSignalProperty.setKillSignal(killSignal);
        sendKillSignalUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

int32 ServiceStub::getKillSignal() const {
    return _KillSignalProperty.getKillSignal();
}

void ServiceStub::sendSendSIGKILLUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SendSIGKILLUpdate payload(_SendSIGKILLProperty);

        LOG_INFO ("-> send%s", "SendSIGKILLUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("SendSIGKILL", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SendSIGKILLUpdate");
    }
}

void ServiceStub::onSendSIGKILLGet(const ::boost::shared_ptr< SendSIGKILLGet >& sendSIGKILL) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SendSIGKILLGet", sendSIGKILL->getAct());
    sendSendSIGKILLGetUpdate(_SendSIGKILLProperty.getSendSIGKILL(), sendSIGKILL->getAct());
}

void ServiceStub::sendSendSIGKILLGetUpdate(bool sendSIGKILL, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SendSIGKILLGet payload(sendSIGKILL);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SendSIGKILLGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setSendSIGKILL(bool sendSIGKILL) {
    if(sendSIGKILL!=_SendSIGKILLProperty.getSendSIGKILL()) {
        _SendSIGKILLProperty.setSendSIGKILL(sendSIGKILL);
        sendSendSIGKILLUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool ServiceStub::getSendSIGKILL() const {
    return _SendSIGKILLProperty.getSendSIGKILL();
}

void ServiceStub::sendSendSIGHUPUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SendSIGHUPUpdate payload(_SendSIGHUPProperty);

        LOG_INFO ("-> send%s", "SendSIGHUPUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("SendSIGHUP", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SendSIGHUPUpdate");
    }
}

void ServiceStub::onSendSIGHUPGet(const ::boost::shared_ptr< SendSIGHUPGet >& sendSIGHUP) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SendSIGHUPGet", sendSIGHUP->getAct());
    sendSendSIGHUPGetUpdate(_SendSIGHUPProperty.getSendSIGHUP(), sendSIGHUP->getAct());
}

void ServiceStub::sendSendSIGHUPGetUpdate(bool sendSIGHUP, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SendSIGHUPGet payload(sendSIGHUP);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SendSIGHUPGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setSendSIGHUP(bool sendSIGHUP) {
    if(sendSIGHUP!=_SendSIGHUPProperty.getSendSIGHUP()) {
        _SendSIGHUPProperty.setSendSIGHUP(sendSIGHUP);
        sendSendSIGHUPUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool ServiceStub::getSendSIGHUP() const {
    return _SendSIGHUPProperty.getSendSIGHUP();
}

void ServiceStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'Type'
    {
        ::asf::dbus::DBusVariant variant;
        TypeGet payload(_TypeProperty.getType());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Type", variant));
    }

    //property 'Restart'
    {
        ::asf::dbus::DBusVariant variant;
        RestartGet payload(_RestartProperty.getRestart());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Restart", variant));
    }

    //property 'PIDFile'
    {
        ::asf::dbus::DBusVariant variant;
        PIDFileGet payload(_PIDFileProperty.getPIDFile());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("PIDFile", variant));
    }

    //property 'NotifyAccess'
    {
        ::asf::dbus::DBusVariant variant;
        NotifyAccessGet payload(_NotifyAccessProperty.getNotifyAccess());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("NotifyAccess", variant));
    }

    //property 'RestartUSec'
    {
        ::asf::dbus::DBusVariant variant;
        RestartUSecGet payload(_RestartUSecProperty.getRestartUSec());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("RestartUSec", variant));
    }

    //property 'TimeoutStartUSec'
    {
        ::asf::dbus::DBusVariant variant;
        TimeoutStartUSecGet payload(_TimeoutStartUSecProperty.getTimeoutStartUSec());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("TimeoutStartUSec", variant));
    }

    //property 'TimeoutStopUSec'
    {
        ::asf::dbus::DBusVariant variant;
        TimeoutStopUSecGet payload(_TimeoutStopUSecProperty.getTimeoutStopUSec());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("TimeoutStopUSec", variant));
    }

    //property 'WatchdogUSec'
    {
        ::asf::dbus::DBusVariant variant;
        WatchdogUSecGet payload(_WatchdogUSecProperty.getWatchdogUSec());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("WatchdogUSec", variant));
    }

    //property 'WatchdogTimestamp'
    {
        ::asf::dbus::DBusVariant variant;
        WatchdogTimestampGet payload(_WatchdogTimestampProperty.getWatchdogTimestamp());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("WatchdogTimestamp", variant));
    }

    //property 'WatchdogTimestampMonotonic'
    {
        ::asf::dbus::DBusVariant variant;
        WatchdogTimestampMonotonicGet payload(_WatchdogTimestampMonotonicProperty.getWatchdogTimestampMonotonic());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("WatchdogTimestampMonotonic", variant));
    }

    //property 'StartLimitInterval'
    {
        ::asf::dbus::DBusVariant variant;
        StartLimitIntervalGet payload(_StartLimitIntervalProperty.getStartLimitInterval());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("StartLimitInterval", variant));
    }

    //property 'StartLimitBurst'
    {
        ::asf::dbus::DBusVariant variant;
        StartLimitBurstGet payload(_StartLimitBurstProperty.getStartLimitBurst());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("StartLimitBurst", variant));
    }

    //property 'StartLimitAction'
    {
        ::asf::dbus::DBusVariant variant;
        StartLimitActionGet payload(_StartLimitActionProperty.getStartLimitAction());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("StartLimitAction", variant));
    }

    //property 'RebootArgument'
    {
        ::asf::dbus::DBusVariant variant;
        RebootArgumentGet payload(_RebootArgumentProperty.getRebootArgument());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("RebootArgument", variant));
    }

    //property 'FailureAction'
    {
        ::asf::dbus::DBusVariant variant;
        FailureActionGet payload(_FailureActionProperty.getFailureAction());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("FailureAction", variant));
    }

    //property 'PermissionsStartOnly'
    {
        ::asf::dbus::DBusVariant variant;
        PermissionsStartOnlyGet payload(_PermissionsStartOnlyProperty.getPermissionsStartOnly());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("PermissionsStartOnly", variant));
    }

    //property 'RootDirectoryStartOnly'
    {
        ::asf::dbus::DBusVariant variant;
        RootDirectoryStartOnlyGet payload(_RootDirectoryStartOnlyProperty.getRootDirectoryStartOnly());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("RootDirectoryStartOnly", variant));
    }

    //property 'RemainAfterExit'
    {
        ::asf::dbus::DBusVariant variant;
        RemainAfterExitGet payload(_RemainAfterExitProperty.getRemainAfterExit());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("RemainAfterExit", variant));
    }

    //property 'GuessMainPID'
    {
        ::asf::dbus::DBusVariant variant;
        GuessMainPIDGet payload(_GuessMainPIDProperty.getGuessMainPID());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("GuessMainPID", variant));
    }

    //property 'MainPID'
    {
        ::asf::dbus::DBusVariant variant;
        MainPIDGet payload(_MainPIDProperty.getMainPID());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("MainPID", variant));
    }

    //property 'ControlPID'
    {
        ::asf::dbus::DBusVariant variant;
        ControlPIDGet payload(_ControlPIDProperty.getControlPID());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ControlPID", variant));
    }

    //property 'BusName'
    {
        ::asf::dbus::DBusVariant variant;
        BusNameGet payload(_BusNameProperty.getBusName());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("BusName", variant));
    }

    //property 'FileDescriptorStoreMax'
    {
        ::asf::dbus::DBusVariant variant;
        FileDescriptorStoreMaxGet payload(_FileDescriptorStoreMaxProperty.getFileDescriptorStoreMax());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("FileDescriptorStoreMax", variant));
    }

    //property 'StatusText'
    {
        ::asf::dbus::DBusVariant variant;
        StatusTextGet payload(_StatusTextProperty.getStatusText());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("StatusText", variant));
    }

    //property 'StatusErrno'
    {
        ::asf::dbus::DBusVariant variant;
        StatusErrnoGet payload(_StatusErrnoProperty.getStatusErrno());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("StatusErrno", variant));
    }

    //property 'Result'
    {
        ::asf::dbus::DBusVariant variant;
        ResultGet payload(_ResultProperty.getResult());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Result", variant));
    }

    //property 'ExecMainStartTimestamp'
    {
        ::asf::dbus::DBusVariant variant;
        ExecMainStartTimestampGet payload(_ExecMainStartTimestampProperty.getExecMainStartTimestamp());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ExecMainStartTimestamp", variant));
    }

    //property 'ExecMainStartTimestampMonotonic'
    {
        ::asf::dbus::DBusVariant variant;
        ExecMainStartTimestampMonotonicGet payload(_ExecMainStartTimestampMonotonicProperty.getExecMainStartTimestampMonotonic());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ExecMainStartTimestampMonotonic", variant));
    }

    //property 'ExecMainExitTimestamp'
    {
        ::asf::dbus::DBusVariant variant;
        ExecMainExitTimestampGet payload(_ExecMainExitTimestampProperty.getExecMainExitTimestamp());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ExecMainExitTimestamp", variant));
    }

    //property 'ExecMainExitTimestampMonotonic'
    {
        ::asf::dbus::DBusVariant variant;
        ExecMainExitTimestampMonotonicGet payload(_ExecMainExitTimestampMonotonicProperty.getExecMainExitTimestampMonotonic());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ExecMainExitTimestampMonotonic", variant));
    }

    //property 'ExecMainPID'
    {
        ::asf::dbus::DBusVariant variant;
        ExecMainPIDGet payload(_ExecMainPIDProperty.getExecMainPID());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ExecMainPID", variant));
    }

    //property 'ExecMainCode'
    {
        ::asf::dbus::DBusVariant variant;
        ExecMainCodeGet payload(_ExecMainCodeProperty.getExecMainCode());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ExecMainCode", variant));
    }

    //property 'ExecMainStatus'
    {
        ::asf::dbus::DBusVariant variant;
        ExecMainStatusGet payload(_ExecMainStatusProperty.getExecMainStatus());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ExecMainStatus", variant));
    }

    //property 'ExecStartPre'
    {
        ::asf::dbus::DBusVariant variant;
        ExecStartPreGet payload(_ExecStartPreProperty.getExecStartPre());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ExecStartPre", variant));
    }

    //property 'ExecStart'
    {
        ::asf::dbus::DBusVariant variant;
        ExecStartGet payload(_ExecStartProperty.getExecStart());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ExecStart", variant));
    }

    //property 'ExecStartPost'
    {
        ::asf::dbus::DBusVariant variant;
        ExecStartPostGet payload(_ExecStartPostProperty.getExecStartPost());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ExecStartPost", variant));
    }

    //property 'ExecReload'
    {
        ::asf::dbus::DBusVariant variant;
        ExecReloadGet payload(_ExecReloadProperty.getExecReload());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ExecReload", variant));
    }

    //property 'ExecStop'
    {
        ::asf::dbus::DBusVariant variant;
        ExecStopGet payload(_ExecStopProperty.getExecStop());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ExecStop", variant));
    }

    //property 'ExecStopPost'
    {
        ::asf::dbus::DBusVariant variant;
        ExecStopPostGet payload(_ExecStopPostProperty.getExecStopPost());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ExecStopPost", variant));
    }

    //property 'Slice'
    {
        ::asf::dbus::DBusVariant variant;
        SliceGet payload(_SliceProperty.getSlice());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Slice", variant));
    }

    //property 'ControlGroup'
    {
        ::asf::dbus::DBusVariant variant;
        ControlGroupGet payload(_ControlGroupProperty.getControlGroup());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ControlGroup", variant));
    }

    //property 'MemoryCurrent'
    {
        ::asf::dbus::DBusVariant variant;
        MemoryCurrentGet payload(_MemoryCurrentProperty.getMemoryCurrent());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("MemoryCurrent", variant));
    }

    //property 'CPUUsageNSec'
    {
        ::asf::dbus::DBusVariant variant;
        CPUUsageNSecGet payload(_CPUUsageNSecProperty.getCPUUsageNSec());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("CPUUsageNSec", variant));
    }

    //property 'Delegate'
    {
        ::asf::dbus::DBusVariant variant;
        DelegateGet payload(_DelegateProperty.getDelegate());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Delegate", variant));
    }

    //property 'CPUAccounting'
    {
        ::asf::dbus::DBusVariant variant;
        CPUAccountingGet payload(_CPUAccountingProperty.getCPUAccounting());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("CPUAccounting", variant));
    }

    //property 'CPUShares'
    {
        ::asf::dbus::DBusVariant variant;
        CPUSharesGet payload(_CPUSharesProperty.getCPUShares());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("CPUShares", variant));
    }

    //property 'StartupCPUShares'
    {
        ::asf::dbus::DBusVariant variant;
        StartupCPUSharesGet payload(_StartupCPUSharesProperty.getStartupCPUShares());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("StartupCPUShares", variant));
    }

    //property 'CPUQuotaPerSecUSec'
    {
        ::asf::dbus::DBusVariant variant;
        CPUQuotaPerSecUSecGet payload(_CPUQuotaPerSecUSecProperty.getCPUQuotaPerSecUSec());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("CPUQuotaPerSecUSec", variant));
    }

    //property 'BlockIOAccounting'
    {
        ::asf::dbus::DBusVariant variant;
        BlockIOAccountingGet payload(_BlockIOAccountingProperty.getBlockIOAccounting());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("BlockIOAccounting", variant));
    }

    //property 'BlockIOWeight'
    {
        ::asf::dbus::DBusVariant variant;
        BlockIOWeightGet payload(_BlockIOWeightProperty.getBlockIOWeight());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("BlockIOWeight", variant));
    }

    //property 'StartupBlockIOWeight'
    {
        ::asf::dbus::DBusVariant variant;
        StartupBlockIOWeightGet payload(_StartupBlockIOWeightProperty.getStartupBlockIOWeight());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("StartupBlockIOWeight", variant));
    }

    //property 'BlockIODeviceWeight'
    {
        ::asf::dbus::DBusVariant variant;
        BlockIODeviceWeightGet payload(_BlockIODeviceWeightProperty.getBlockIODeviceWeight());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("BlockIODeviceWeight", variant));
    }

    //property 'BlockIOReadBandwidth'
    {
        ::asf::dbus::DBusVariant variant;
        BlockIOReadBandwidthGet payload(_BlockIOReadBandwidthProperty.getBlockIOReadBandwidth());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("BlockIOReadBandwidth", variant));
    }

    //property 'BlockIOWriteBandwidth'
    {
        ::asf::dbus::DBusVariant variant;
        BlockIOWriteBandwidthGet payload(_BlockIOWriteBandwidthProperty.getBlockIOWriteBandwidth());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("BlockIOWriteBandwidth", variant));
    }

    //property 'MemoryAccounting'
    {
        ::asf::dbus::DBusVariant variant;
        MemoryAccountingGet payload(_MemoryAccountingProperty.getMemoryAccounting());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("MemoryAccounting", variant));
    }

    //property 'MemoryLimit'
    {
        ::asf::dbus::DBusVariant variant;
        MemoryLimitGet payload(_MemoryLimitProperty.getMemoryLimit());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("MemoryLimit", variant));
    }

    //property 'DevicePolicy'
    {
        ::asf::dbus::DBusVariant variant;
        DevicePolicyGet payload(_DevicePolicyProperty.getDevicePolicy());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("DevicePolicy", variant));
    }

    //property 'DeviceAllow'
    {
        ::asf::dbus::DBusVariant variant;
        DeviceAllowGet payload(_DeviceAllowProperty.getDeviceAllow());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("DeviceAllow", variant));
    }

    //property 'Environment'
    {
        ::asf::dbus::DBusVariant variant;
        EnvironmentGet payload(_EnvironmentProperty.getEnvironment());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Environment", variant));
    }

    //property 'EnvironmentFiles'
    {
        ::asf::dbus::DBusVariant variant;
        EnvironmentFilesGet payload(_EnvironmentFilesProperty.getEnvironmentFiles());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("EnvironmentFiles", variant));
    }

    //property 'UMask'
    {
        ::asf::dbus::DBusVariant variant;
        UMaskGet payload(_UMaskProperty.getUMask());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("UMask", variant));
    }

    //property 'LimitCPU'
    {
        ::asf::dbus::DBusVariant variant;
        LimitCPUGet payload(_LimitCPUProperty.getLimitCPU());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("LimitCPU", variant));
    }

    //property 'LimitFSIZE'
    {
        ::asf::dbus::DBusVariant variant;
        LimitFSIZEGet payload(_LimitFSIZEProperty.getLimitFSIZE());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("LimitFSIZE", variant));
    }

    //property 'LimitDATA'
    {
        ::asf::dbus::DBusVariant variant;
        LimitDATAGet payload(_LimitDATAProperty.getLimitDATA());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("LimitDATA", variant));
    }

    //property 'LimitSTACK'
    {
        ::asf::dbus::DBusVariant variant;
        LimitSTACKGet payload(_LimitSTACKProperty.getLimitSTACK());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("LimitSTACK", variant));
    }

    //property 'LimitCORE'
    {
        ::asf::dbus::DBusVariant variant;
        LimitCOREGet payload(_LimitCOREProperty.getLimitCORE());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("LimitCORE", variant));
    }

    //property 'LimitRSS'
    {
        ::asf::dbus::DBusVariant variant;
        LimitRSSGet payload(_LimitRSSProperty.getLimitRSS());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("LimitRSS", variant));
    }

    //property 'LimitNOFILE'
    {
        ::asf::dbus::DBusVariant variant;
        LimitNOFILEGet payload(_LimitNOFILEProperty.getLimitNOFILE());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("LimitNOFILE", variant));
    }

    //property 'LimitAS'
    {
        ::asf::dbus::DBusVariant variant;
        LimitASGet payload(_LimitASProperty.getLimitAS());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("LimitAS", variant));
    }

    //property 'LimitNPROC'
    {
        ::asf::dbus::DBusVariant variant;
        LimitNPROCGet payload(_LimitNPROCProperty.getLimitNPROC());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("LimitNPROC", variant));
    }

    //property 'LimitMEMLOCK'
    {
        ::asf::dbus::DBusVariant variant;
        LimitMEMLOCKGet payload(_LimitMEMLOCKProperty.getLimitMEMLOCK());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("LimitMEMLOCK", variant));
    }

    //property 'LimitLOCKS'
    {
        ::asf::dbus::DBusVariant variant;
        LimitLOCKSGet payload(_LimitLOCKSProperty.getLimitLOCKS());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("LimitLOCKS", variant));
    }

    //property 'LimitSIGPENDING'
    {
        ::asf::dbus::DBusVariant variant;
        LimitSIGPENDINGGet payload(_LimitSIGPENDINGProperty.getLimitSIGPENDING());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("LimitSIGPENDING", variant));
    }

    //property 'LimitMSGQUEUE'
    {
        ::asf::dbus::DBusVariant variant;
        LimitMSGQUEUEGet payload(_LimitMSGQUEUEProperty.getLimitMSGQUEUE());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("LimitMSGQUEUE", variant));
    }

    //property 'LimitNICE'
    {
        ::asf::dbus::DBusVariant variant;
        LimitNICEGet payload(_LimitNICEProperty.getLimitNICE());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("LimitNICE", variant));
    }

    //property 'LimitRTPRIO'
    {
        ::asf::dbus::DBusVariant variant;
        LimitRTPRIOGet payload(_LimitRTPRIOProperty.getLimitRTPRIO());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("LimitRTPRIO", variant));
    }

    //property 'LimitRTTIME'
    {
        ::asf::dbus::DBusVariant variant;
        LimitRTTIMEGet payload(_LimitRTTIMEProperty.getLimitRTTIME());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("LimitRTTIME", variant));
    }

    //property 'WorkingDirectory'
    {
        ::asf::dbus::DBusVariant variant;
        WorkingDirectoryGet payload(_WorkingDirectoryProperty.getWorkingDirectory());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("WorkingDirectory", variant));
    }

    //property 'RootDirectory'
    {
        ::asf::dbus::DBusVariant variant;
        RootDirectoryGet payload(_RootDirectoryProperty.getRootDirectory());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("RootDirectory", variant));
    }

    //property 'OOMScoreAdjust'
    {
        ::asf::dbus::DBusVariant variant;
        OOMScoreAdjustGet payload(_OOMScoreAdjustProperty.getOOMScoreAdjust());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("OOMScoreAdjust", variant));
    }

    //property 'Nice'
    {
        ::asf::dbus::DBusVariant variant;
        NiceGet payload(_NiceProperty.getNice());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Nice", variant));
    }

    //property 'IOScheduling'
    {
        ::asf::dbus::DBusVariant variant;
        IOSchedulingGet payload(_IOSchedulingProperty.getIOScheduling());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("IOScheduling", variant));
    }

    //property 'CPUSchedulingPolicy'
    {
        ::asf::dbus::DBusVariant variant;
        CPUSchedulingPolicyGet payload(_CPUSchedulingPolicyProperty.getCPUSchedulingPolicy());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("CPUSchedulingPolicy", variant));
    }

    //property 'CPUSchedulingPriority'
    {
        ::asf::dbus::DBusVariant variant;
        CPUSchedulingPriorityGet payload(_CPUSchedulingPriorityProperty.getCPUSchedulingPriority());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("CPUSchedulingPriority", variant));
    }

    //property 'CPUAffinity'
    {
        ::asf::dbus::DBusVariant variant;
        CPUAffinityGet payload(_CPUAffinityProperty.getCPUAffinity());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("CPUAffinity", variant));
    }

    //property 'TimerSlackNSec'
    {
        ::asf::dbus::DBusVariant variant;
        TimerSlackNSecGet payload(_TimerSlackNSecProperty.getTimerSlackNSec());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("TimerSlackNSec", variant));
    }

    //property 'CPUSchedulingResetOnFork'
    {
        ::asf::dbus::DBusVariant variant;
        CPUSchedulingResetOnForkGet payload(_CPUSchedulingResetOnForkProperty.getCPUSchedulingResetOnFork());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("CPUSchedulingResetOnFork", variant));
    }

    //property 'NonBlocking'
    {
        ::asf::dbus::DBusVariant variant;
        NonBlockingGet payload(_NonBlockingProperty.getNonBlocking());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("NonBlocking", variant));
    }

    //property 'StandardInput'
    {
        ::asf::dbus::DBusVariant variant;
        StandardInputGet payload(_StandardInputProperty.getStandardInput());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("StandardInput", variant));
    }

    //property 'StandardOutput'
    {
        ::asf::dbus::DBusVariant variant;
        StandardOutputGet payload(_StandardOutputProperty.getStandardOutput());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("StandardOutput", variant));
    }

    //property 'StandardError'
    {
        ::asf::dbus::DBusVariant variant;
        StandardErrorGet payload(_StandardErrorProperty.getStandardError());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("StandardError", variant));
    }

    //property 'TTYPath'
    {
        ::asf::dbus::DBusVariant variant;
        TTYPathGet payload(_TTYPathProperty.getTTYPath());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("TTYPath", variant));
    }

    //property 'TTYReset'
    {
        ::asf::dbus::DBusVariant variant;
        TTYResetGet payload(_TTYResetProperty.getTTYReset());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("TTYReset", variant));
    }

    //property 'TTYVHangup'
    {
        ::asf::dbus::DBusVariant variant;
        TTYVHangupGet payload(_TTYVHangupProperty.getTTYVHangup());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("TTYVHangup", variant));
    }

    //property 'TTYVTDisallocate'
    {
        ::asf::dbus::DBusVariant variant;
        TTYVTDisallocateGet payload(_TTYVTDisallocateProperty.getTTYVTDisallocate());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("TTYVTDisallocate", variant));
    }

    //property 'SyslogPriority'
    {
        ::asf::dbus::DBusVariant variant;
        SyslogPriorityGet payload(_SyslogPriorityProperty.getSyslogPriority());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("SyslogPriority", variant));
    }

    //property 'SyslogIdentifier'
    {
        ::asf::dbus::DBusVariant variant;
        SyslogIdentifierGet payload(_SyslogIdentifierProperty.getSyslogIdentifier());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("SyslogIdentifier", variant));
    }

    //property 'SyslogLevelPrefix'
    {
        ::asf::dbus::DBusVariant variant;
        SyslogLevelPrefixGet payload(_SyslogLevelPrefixProperty.getSyslogLevelPrefix());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("SyslogLevelPrefix", variant));
    }

    //property 'Capabilities'
    {
        ::asf::dbus::DBusVariant variant;
        CapabilitiesGet payload(_CapabilitiesProperty.getCapabilities());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Capabilities", variant));
    }

    //property 'SecureBits'
    {
        ::asf::dbus::DBusVariant variant;
        SecureBitsGet payload(_SecureBitsProperty.getSecureBits());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("SecureBits", variant));
    }

    //property 'CapabilityBoundingSet'
    {
        ::asf::dbus::DBusVariant variant;
        CapabilityBoundingSetGet payload(_CapabilityBoundingSetProperty.getCapabilityBoundingSet());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("CapabilityBoundingSet", variant));
    }

    //property 'User'
    {
        ::asf::dbus::DBusVariant variant;
        UserGet payload(_UserProperty.getUser());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("User", variant));
    }

    //property 'Group'
    {
        ::asf::dbus::DBusVariant variant;
        GroupGet payload(_GroupProperty.getGroup());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Group", variant));
    }

    //property 'SupplementaryGroups'
    {
        ::asf::dbus::DBusVariant variant;
        SupplementaryGroupsGet payload(_SupplementaryGroupsProperty.getSupplementaryGroups());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("SupplementaryGroups", variant));
    }

    //property 'PAMName'
    {
        ::asf::dbus::DBusVariant variant;
        PAMNameGet payload(_PAMNameProperty.getPAMName());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("PAMName", variant));
    }

    //property 'ReadWriteDirectories'
    {
        ::asf::dbus::DBusVariant variant;
        ReadWriteDirectoriesGet payload(_ReadWriteDirectoriesProperty.getReadWriteDirectories());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ReadWriteDirectories", variant));
    }

    //property 'ReadOnlyDirectories'
    {
        ::asf::dbus::DBusVariant variant;
        ReadOnlyDirectoriesGet payload(_ReadOnlyDirectoriesProperty.getReadOnlyDirectories());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ReadOnlyDirectories", variant));
    }

    //property 'InaccessibleDirectories'
    {
        ::asf::dbus::DBusVariant variant;
        InaccessibleDirectoriesGet payload(_InaccessibleDirectoriesProperty.getInaccessibleDirectories());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("InaccessibleDirectories", variant));
    }

    //property 'MountFlags'
    {
        ::asf::dbus::DBusVariant variant;
        MountFlagsGet payload(_MountFlagsProperty.getMountFlags());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("MountFlags", variant));
    }

    //property 'PrivateTmp'
    {
        ::asf::dbus::DBusVariant variant;
        PrivateTmpGet payload(_PrivateTmpProperty.getPrivateTmp());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("PrivateTmp", variant));
    }

    //property 'PrivateNetwork'
    {
        ::asf::dbus::DBusVariant variant;
        PrivateNetworkGet payload(_PrivateNetworkProperty.getPrivateNetwork());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("PrivateNetwork", variant));
    }

    //property 'PrivateDevices'
    {
        ::asf::dbus::DBusVariant variant;
        PrivateDevicesGet payload(_PrivateDevicesProperty.getPrivateDevices());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("PrivateDevices", variant));
    }

    //property 'ProtectHome'
    {
        ::asf::dbus::DBusVariant variant;
        ProtectHomeGet payload(_ProtectHomeProperty.getProtectHome());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ProtectHome", variant));
    }

    //property 'ProtectSystem'
    {
        ::asf::dbus::DBusVariant variant;
        ProtectSystemGet payload(_ProtectSystemProperty.getProtectSystem());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ProtectSystem", variant));
    }

    //property 'SameProcessGroup'
    {
        ::asf::dbus::DBusVariant variant;
        SameProcessGroupGet payload(_SameProcessGroupProperty.getSameProcessGroup());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("SameProcessGroup", variant));
    }

    //property 'UtmpIdentifier'
    {
        ::asf::dbus::DBusVariant variant;
        UtmpIdentifierGet payload(_UtmpIdentifierProperty.getUtmpIdentifier());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("UtmpIdentifier", variant));
    }

    //property 'UtmpMode'
    {
        ::asf::dbus::DBusVariant variant;
        UtmpModeGet payload(_UtmpModeProperty.getUtmpMode());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("UtmpMode", variant));
    }

    //property 'SELinuxContext'
    {
        ::asf::dbus::DBusVariant variant;
        SELinuxContextGet payload(_SELinuxContextProperty.getSELinuxContext());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("SELinuxContext", variant));
    }

    //property 'AppArmorProfile'
    {
        ::asf::dbus::DBusVariant variant;
        AppArmorProfileGet payload(_AppArmorProfileProperty.getAppArmorProfile());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("AppArmorProfile", variant));
    }

    //property 'SmackProcessLabel'
    {
        ::asf::dbus::DBusVariant variant;
        SmackProcessLabelGet payload(_SmackProcessLabelProperty.getSmackProcessLabel());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("SmackProcessLabel", variant));
    }

    //property 'IgnoreSIGPIPE'
    {
        ::asf::dbus::DBusVariant variant;
        IgnoreSIGPIPEGet payload(_IgnoreSIGPIPEProperty.getIgnoreSIGPIPE());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("IgnoreSIGPIPE", variant));
    }

    //property 'NoNewPrivileges'
    {
        ::asf::dbus::DBusVariant variant;
        NoNewPrivilegesGet payload(_NoNewPrivilegesProperty.getNoNewPrivileges());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("NoNewPrivileges", variant));
    }

    //property 'SystemCallFilter'
    {
        ::asf::dbus::DBusVariant variant;
        SystemCallFilterGet payload(_SystemCallFilterProperty.getSystemCallFilter());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("SystemCallFilter", variant));
    }

    //property 'SystemCallArchitectures'
    {
        ::asf::dbus::DBusVariant variant;
        SystemCallArchitecturesGet payload(_SystemCallArchitecturesProperty.getSystemCallArchitectures());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("SystemCallArchitectures", variant));
    }

    //property 'SystemCallErrorNumber'
    {
        ::asf::dbus::DBusVariant variant;
        SystemCallErrorNumberGet payload(_SystemCallErrorNumberProperty.getSystemCallErrorNumber());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("SystemCallErrorNumber", variant));
    }

    //property 'Personality'
    {
        ::asf::dbus::DBusVariant variant;
        PersonalityGet payload(_PersonalityProperty.getPersonality());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Personality", variant));
    }

    //property 'RestrictAddressFamilies'
    {
        ::asf::dbus::DBusVariant variant;
        RestrictAddressFamiliesGet payload(_RestrictAddressFamiliesProperty.getRestrictAddressFamilies());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("RestrictAddressFamilies", variant));
    }

    //property 'RuntimeDirectoryMode'
    {
        ::asf::dbus::DBusVariant variant;
        RuntimeDirectoryModeGet payload(_RuntimeDirectoryModeProperty.getRuntimeDirectoryMode());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("RuntimeDirectoryMode", variant));
    }

    //property 'RuntimeDirectory'
    {
        ::asf::dbus::DBusVariant variant;
        RuntimeDirectoryGet payload(_RuntimeDirectoryProperty.getRuntimeDirectory());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("RuntimeDirectory", variant));
    }

    //property 'KillMode'
    {
        ::asf::dbus::DBusVariant variant;
        KillModeGet payload(_KillModeProperty.getKillMode());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("KillMode", variant));
    }

    //property 'KillSignal'
    {
        ::asf::dbus::DBusVariant variant;
        KillSignalGet payload(_KillSignalProperty.getKillSignal());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("KillSignal", variant));
    }

    //property 'SendSIGKILL'
    {
        ::asf::dbus::DBusVariant variant;
        SendSIGKILLGet payload(_SendSIGKILLProperty.getSendSIGKILL());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("SendSIGKILL", variant));
    }

    //property 'SendSIGHUP'
    {
        ::asf::dbus::DBusVariant variant;
        SendSIGHUPGet payload(_SendSIGHUPProperty.getSendSIGHUP());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("SendSIGHUP", variant));
    }
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
