/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "boost/shared_ptr.hpp"
#include "org/freedesktop/systemd1/Service.h"
#include "org/freedesktop/systemd1/ServiceDBus.h"
#include "org/freedesktop/systemd1/ServiceJson.h"
#include "org/freedesktop/systemd1/ServiceProxy.h"
#include <string>
#include <vector>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Service {

DEFINE_CLASS_LOGGER("/org/freedesktop/systemd1/org/freedesktop/systemd1/Service", ServiceProxy);

class ServiceProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    ServiceProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< ServiceProxy >& proxyShared = ::boost::static_pointer_cast< ServiceProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_Type:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TypeError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Type", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TypeError> payload = ::boost::static_pointer_cast<TypeError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((TypeCallbackIF*) _callback)->onTypeError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TypeUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Type", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TypeUpdate> payload = ::boost::static_pointer_cast<TypeUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((TypeCallbackIF*) _callback)->onTypeUpdate(proxyShared, payload);
                        proxyShared->_type = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Restart:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RestartError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Restart", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RestartError> payload = ::boost::static_pointer_cast<RestartError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((RestartCallbackIF*) _callback)->onRestartError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RestartUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Restart", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RestartUpdate> payload = ::boost::static_pointer_cast<RestartUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((RestartCallbackIF*) _callback)->onRestartUpdate(proxyShared, payload);
                        proxyShared->_restart = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_PIDFile:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PIDFileError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PIDFile", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PIDFileError> payload = ::boost::static_pointer_cast<PIDFileError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((PIDFileCallbackIF*) _callback)->onPIDFileError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PIDFileUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PIDFile", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PIDFileUpdate> payload = ::boost::static_pointer_cast<PIDFileUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((PIDFileCallbackIF*) _callback)->onPIDFileUpdate(proxyShared, payload);
                        proxyShared->_pIDFile = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_NotifyAccess:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NotifyAccessError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NotifyAccess", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NotifyAccessError> payload = ::boost::static_pointer_cast<NotifyAccessError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((NotifyAccessCallbackIF*) _callback)->onNotifyAccessError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NotifyAccessUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NotifyAccess", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NotifyAccessUpdate> payload = ::boost::static_pointer_cast<NotifyAccessUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((NotifyAccessCallbackIF*) _callback)->onNotifyAccessUpdate(proxyShared, payload);
                        proxyShared->_notifyAccess = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_RestartUSec:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RestartUSecError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RestartUSec", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RestartUSecError> payload = ::boost::static_pointer_cast<RestartUSecError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((RestartUSecCallbackIF*) _callback)->onRestartUSecError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RestartUSecUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RestartUSec", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RestartUSecUpdate> payload = ::boost::static_pointer_cast<RestartUSecUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((RestartUSecCallbackIF*) _callback)->onRestartUSecUpdate(proxyShared, payload);
                        proxyShared->_restartUSec = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_TimeoutStartUSec:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TimeoutStartUSecError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "TimeoutStartUSec", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TimeoutStartUSecError> payload = ::boost::static_pointer_cast<TimeoutStartUSecError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((TimeoutStartUSecCallbackIF*) _callback)->onTimeoutStartUSecError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TimeoutStartUSecUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "TimeoutStartUSec", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TimeoutStartUSecUpdate> payload = ::boost::static_pointer_cast<TimeoutStartUSecUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((TimeoutStartUSecCallbackIF*) _callback)->onTimeoutStartUSecUpdate(proxyShared, payload);
                        proxyShared->_timeoutStartUSec = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_TimeoutStopUSec:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TimeoutStopUSecError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "TimeoutStopUSec", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TimeoutStopUSecError> payload = ::boost::static_pointer_cast<TimeoutStopUSecError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((TimeoutStopUSecCallbackIF*) _callback)->onTimeoutStopUSecError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TimeoutStopUSecUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "TimeoutStopUSec", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TimeoutStopUSecUpdate> payload = ::boost::static_pointer_cast<TimeoutStopUSecUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((TimeoutStopUSecCallbackIF*) _callback)->onTimeoutStopUSecUpdate(proxyShared, payload);
                        proxyShared->_timeoutStopUSec = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_WatchdogUSec:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), WatchdogUSecError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "WatchdogUSec", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<WatchdogUSecError> payload = ::boost::static_pointer_cast<WatchdogUSecError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((WatchdogUSecCallbackIF*) _callback)->onWatchdogUSecError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), WatchdogUSecUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "WatchdogUSec", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<WatchdogUSecUpdate> payload = ::boost::static_pointer_cast<WatchdogUSecUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((WatchdogUSecCallbackIF*) _callback)->onWatchdogUSecUpdate(proxyShared, payload);
                        proxyShared->_watchdogUSec = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_WatchdogTimestamp:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), WatchdogTimestampError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "WatchdogTimestamp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<WatchdogTimestampError> payload = ::boost::static_pointer_cast<WatchdogTimestampError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((WatchdogTimestampCallbackIF*) _callback)->onWatchdogTimestampError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), WatchdogTimestampUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "WatchdogTimestamp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<WatchdogTimestampUpdate> payload = ::boost::static_pointer_cast<WatchdogTimestampUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((WatchdogTimestampCallbackIF*) _callback)->onWatchdogTimestampUpdate(proxyShared, payload);
                        proxyShared->_watchdogTimestamp = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_WatchdogTimestampMonotonic:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), WatchdogTimestampMonotonicError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "WatchdogTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<WatchdogTimestampMonotonicError> payload = ::boost::static_pointer_cast<WatchdogTimestampMonotonicError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((WatchdogTimestampMonotonicCallbackIF*) _callback)->onWatchdogTimestampMonotonicError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), WatchdogTimestampMonotonicUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "WatchdogTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<WatchdogTimestampMonotonicUpdate> payload = ::boost::static_pointer_cast<WatchdogTimestampMonotonicUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((WatchdogTimestampMonotonicCallbackIF*) _callback)->onWatchdogTimestampMonotonicUpdate(proxyShared, payload);
                        proxyShared->_watchdogTimestampMonotonic = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_StartLimitInterval:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartLimitIntervalError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "StartLimitInterval", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartLimitIntervalError> payload = ::boost::static_pointer_cast<StartLimitIntervalError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((StartLimitIntervalCallbackIF*) _callback)->onStartLimitIntervalError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartLimitIntervalUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "StartLimitInterval", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartLimitIntervalUpdate> payload = ::boost::static_pointer_cast<StartLimitIntervalUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((StartLimitIntervalCallbackIF*) _callback)->onStartLimitIntervalUpdate(proxyShared, payload);
                        proxyShared->_startLimitInterval = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_StartLimitBurst:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartLimitBurstError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "StartLimitBurst", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartLimitBurstError> payload = ::boost::static_pointer_cast<StartLimitBurstError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((StartLimitBurstCallbackIF*) _callback)->onStartLimitBurstError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartLimitBurstUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "StartLimitBurst", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartLimitBurstUpdate> payload = ::boost::static_pointer_cast<StartLimitBurstUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((StartLimitBurstCallbackIF*) _callback)->onStartLimitBurstUpdate(proxyShared, payload);
                        proxyShared->_startLimitBurst = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_StartLimitAction:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartLimitActionError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "StartLimitAction", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartLimitActionError> payload = ::boost::static_pointer_cast<StartLimitActionError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((StartLimitActionCallbackIF*) _callback)->onStartLimitActionError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartLimitActionUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "StartLimitAction", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartLimitActionUpdate> payload = ::boost::static_pointer_cast<StartLimitActionUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((StartLimitActionCallbackIF*) _callback)->onStartLimitActionUpdate(proxyShared, payload);
                        proxyShared->_startLimitAction = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_RebootArgument:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RebootArgumentError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RebootArgument", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RebootArgumentError> payload = ::boost::static_pointer_cast<RebootArgumentError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((RebootArgumentCallbackIF*) _callback)->onRebootArgumentError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RebootArgumentUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RebootArgument", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RebootArgumentUpdate> payload = ::boost::static_pointer_cast<RebootArgumentUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((RebootArgumentCallbackIF*) _callback)->onRebootArgumentUpdate(proxyShared, payload);
                        proxyShared->_rebootArgument = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_FailureAction:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FailureActionError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "FailureAction", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FailureActionError> payload = ::boost::static_pointer_cast<FailureActionError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((FailureActionCallbackIF*) _callback)->onFailureActionError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FailureActionUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "FailureAction", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FailureActionUpdate> payload = ::boost::static_pointer_cast<FailureActionUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((FailureActionCallbackIF*) _callback)->onFailureActionUpdate(proxyShared, payload);
                        proxyShared->_failureAction = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_PermissionsStartOnly:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PermissionsStartOnlyError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PermissionsStartOnly", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PermissionsStartOnlyError> payload = ::boost::static_pointer_cast<PermissionsStartOnlyError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((PermissionsStartOnlyCallbackIF*) _callback)->onPermissionsStartOnlyError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PermissionsStartOnlyUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PermissionsStartOnly", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PermissionsStartOnlyUpdate> payload = ::boost::static_pointer_cast<PermissionsStartOnlyUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((PermissionsStartOnlyCallbackIF*) _callback)->onPermissionsStartOnlyUpdate(proxyShared, payload);
                        proxyShared->_permissionsStartOnly = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_RootDirectoryStartOnly:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RootDirectoryStartOnlyError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RootDirectoryStartOnly", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RootDirectoryStartOnlyError> payload = ::boost::static_pointer_cast<RootDirectoryStartOnlyError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((RootDirectoryStartOnlyCallbackIF*) _callback)->onRootDirectoryStartOnlyError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RootDirectoryStartOnlyUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RootDirectoryStartOnly", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RootDirectoryStartOnlyUpdate> payload = ::boost::static_pointer_cast<RootDirectoryStartOnlyUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((RootDirectoryStartOnlyCallbackIF*) _callback)->onRootDirectoryStartOnlyUpdate(proxyShared, payload);
                        proxyShared->_rootDirectoryStartOnly = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_RemainAfterExit:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RemainAfterExitError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RemainAfterExit", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RemainAfterExitError> payload = ::boost::static_pointer_cast<RemainAfterExitError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((RemainAfterExitCallbackIF*) _callback)->onRemainAfterExitError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RemainAfterExitUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RemainAfterExit", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RemainAfterExitUpdate> payload = ::boost::static_pointer_cast<RemainAfterExitUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((RemainAfterExitCallbackIF*) _callback)->onRemainAfterExitUpdate(proxyShared, payload);
                        proxyShared->_remainAfterExit = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_GuessMainPID:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GuessMainPIDError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "GuessMainPID", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GuessMainPIDError> payload = ::boost::static_pointer_cast<GuessMainPIDError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((GuessMainPIDCallbackIF*) _callback)->onGuessMainPIDError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GuessMainPIDUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "GuessMainPID", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GuessMainPIDUpdate> payload = ::boost::static_pointer_cast<GuessMainPIDUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((GuessMainPIDCallbackIF*) _callback)->onGuessMainPIDUpdate(proxyShared, payload);
                        proxyShared->_guessMainPID = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_MainPID:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MainPIDError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "MainPID", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MainPIDError> payload = ::boost::static_pointer_cast<MainPIDError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((MainPIDCallbackIF*) _callback)->onMainPIDError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MainPIDUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "MainPID", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MainPIDUpdate> payload = ::boost::static_pointer_cast<MainPIDUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((MainPIDCallbackIF*) _callback)->onMainPIDUpdate(proxyShared, payload);
                        proxyShared->_mainPID = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ControlPID:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ControlPIDError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ControlPID", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ControlPIDError> payload = ::boost::static_pointer_cast<ControlPIDError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ControlPIDCallbackIF*) _callback)->onControlPIDError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ControlPIDUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ControlPID", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ControlPIDUpdate> payload = ::boost::static_pointer_cast<ControlPIDUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ControlPIDCallbackIF*) _callback)->onControlPIDUpdate(proxyShared, payload);
                        proxyShared->_controlPID = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_BusName:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BusNameError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BusName", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BusNameError> payload = ::boost::static_pointer_cast<BusNameError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((BusNameCallbackIF*) _callback)->onBusNameError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BusNameUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BusName", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BusNameUpdate> payload = ::boost::static_pointer_cast<BusNameUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((BusNameCallbackIF*) _callback)->onBusNameUpdate(proxyShared, payload);
                        proxyShared->_busName = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_FileDescriptorStoreMax:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FileDescriptorStoreMaxError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "FileDescriptorStoreMax", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FileDescriptorStoreMaxError> payload = ::boost::static_pointer_cast<FileDescriptorStoreMaxError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((FileDescriptorStoreMaxCallbackIF*) _callback)->onFileDescriptorStoreMaxError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FileDescriptorStoreMaxUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "FileDescriptorStoreMax", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FileDescriptorStoreMaxUpdate> payload = ::boost::static_pointer_cast<FileDescriptorStoreMaxUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((FileDescriptorStoreMaxCallbackIF*) _callback)->onFileDescriptorStoreMaxUpdate(proxyShared, payload);
                        proxyShared->_fileDescriptorStoreMax = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_StatusText:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StatusTextError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "StatusText", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StatusTextError> payload = ::boost::static_pointer_cast<StatusTextError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((StatusTextCallbackIF*) _callback)->onStatusTextError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StatusTextUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "StatusText", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StatusTextUpdate> payload = ::boost::static_pointer_cast<StatusTextUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((StatusTextCallbackIF*) _callback)->onStatusTextUpdate(proxyShared, payload);
                        proxyShared->_statusText = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_StatusErrno:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StatusErrnoError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "StatusErrno", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StatusErrnoError> payload = ::boost::static_pointer_cast<StatusErrnoError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((StatusErrnoCallbackIF*) _callback)->onStatusErrnoError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StatusErrnoUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "StatusErrno", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StatusErrnoUpdate> payload = ::boost::static_pointer_cast<StatusErrnoUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((StatusErrnoCallbackIF*) _callback)->onStatusErrnoUpdate(proxyShared, payload);
                        proxyShared->_statusErrno = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Result:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ResultError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Result", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ResultError> payload = ::boost::static_pointer_cast<ResultError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ResultCallbackIF*) _callback)->onResultError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ResultUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Result", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ResultUpdate> payload = ::boost::static_pointer_cast<ResultUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ResultCallbackIF*) _callback)->onResultUpdate(proxyShared, payload);
                        proxyShared->_result = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ExecMainStartTimestamp:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ExecMainStartTimestampError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ExecMainStartTimestamp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ExecMainStartTimestampError> payload = ::boost::static_pointer_cast<ExecMainStartTimestampError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ExecMainStartTimestampCallbackIF*) _callback)->onExecMainStartTimestampError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ExecMainStartTimestampUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ExecMainStartTimestamp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ExecMainStartTimestampUpdate> payload = ::boost::static_pointer_cast<ExecMainStartTimestampUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ExecMainStartTimestampCallbackIF*) _callback)->onExecMainStartTimestampUpdate(proxyShared, payload);
                        proxyShared->_execMainStartTimestamp = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ExecMainStartTimestampMonotonic:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ExecMainStartTimestampMonotonicError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ExecMainStartTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ExecMainStartTimestampMonotonicError> payload = ::boost::static_pointer_cast<ExecMainStartTimestampMonotonicError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ExecMainStartTimestampMonotonicCallbackIF*) _callback)->onExecMainStartTimestampMonotonicError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ExecMainStartTimestampMonotonicUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ExecMainStartTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ExecMainStartTimestampMonotonicUpdate> payload = ::boost::static_pointer_cast<ExecMainStartTimestampMonotonicUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ExecMainStartTimestampMonotonicCallbackIF*) _callback)->onExecMainStartTimestampMonotonicUpdate(proxyShared, payload);
                        proxyShared->_execMainStartTimestampMonotonic = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ExecMainExitTimestamp:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ExecMainExitTimestampError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ExecMainExitTimestamp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ExecMainExitTimestampError> payload = ::boost::static_pointer_cast<ExecMainExitTimestampError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ExecMainExitTimestampCallbackIF*) _callback)->onExecMainExitTimestampError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ExecMainExitTimestampUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ExecMainExitTimestamp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ExecMainExitTimestampUpdate> payload = ::boost::static_pointer_cast<ExecMainExitTimestampUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ExecMainExitTimestampCallbackIF*) _callback)->onExecMainExitTimestampUpdate(proxyShared, payload);
                        proxyShared->_execMainExitTimestamp = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ExecMainExitTimestampMonotonic:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ExecMainExitTimestampMonotonicError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ExecMainExitTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ExecMainExitTimestampMonotonicError> payload = ::boost::static_pointer_cast<ExecMainExitTimestampMonotonicError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ExecMainExitTimestampMonotonicCallbackIF*) _callback)->onExecMainExitTimestampMonotonicError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ExecMainExitTimestampMonotonicUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ExecMainExitTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ExecMainExitTimestampMonotonicUpdate> payload = ::boost::static_pointer_cast<ExecMainExitTimestampMonotonicUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ExecMainExitTimestampMonotonicCallbackIF*) _callback)->onExecMainExitTimestampMonotonicUpdate(proxyShared, payload);
                        proxyShared->_execMainExitTimestampMonotonic = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ExecMainPID:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ExecMainPIDError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ExecMainPID", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ExecMainPIDError> payload = ::boost::static_pointer_cast<ExecMainPIDError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ExecMainPIDCallbackIF*) _callback)->onExecMainPIDError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ExecMainPIDUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ExecMainPID", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ExecMainPIDUpdate> payload = ::boost::static_pointer_cast<ExecMainPIDUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ExecMainPIDCallbackIF*) _callback)->onExecMainPIDUpdate(proxyShared, payload);
                        proxyShared->_execMainPID = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ExecMainCode:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ExecMainCodeError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ExecMainCode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ExecMainCodeError> payload = ::boost::static_pointer_cast<ExecMainCodeError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ExecMainCodeCallbackIF*) _callback)->onExecMainCodeError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ExecMainCodeUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ExecMainCode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ExecMainCodeUpdate> payload = ::boost::static_pointer_cast<ExecMainCodeUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ExecMainCodeCallbackIF*) _callback)->onExecMainCodeUpdate(proxyShared, payload);
                        proxyShared->_execMainCode = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ExecMainStatus:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ExecMainStatusError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ExecMainStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ExecMainStatusError> payload = ::boost::static_pointer_cast<ExecMainStatusError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ExecMainStatusCallbackIF*) _callback)->onExecMainStatusError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ExecMainStatusUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ExecMainStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ExecMainStatusUpdate> payload = ::boost::static_pointer_cast<ExecMainStatusUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ExecMainStatusCallbackIF*) _callback)->onExecMainStatusUpdate(proxyShared, payload);
                        proxyShared->_execMainStatus = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ExecStartPre:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ExecStartPreError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ExecStartPre", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ExecStartPreError> payload = ::boost::static_pointer_cast<ExecStartPreError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ExecStartPreCallbackIF*) _callback)->onExecStartPreError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ExecStartPreUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ExecStartPre", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ExecStartPreUpdate> payload = ::boost::static_pointer_cast<ExecStartPreUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ExecStartPreCallbackIF*) _callback)->onExecStartPreUpdate(proxyShared, payload);
                        proxyShared->_execStartPre = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ExecStart:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ExecStartError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ExecStart", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ExecStartError> payload = ::boost::static_pointer_cast<ExecStartError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ExecStartCallbackIF*) _callback)->onExecStartError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ExecStartUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ExecStart", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ExecStartUpdate> payload = ::boost::static_pointer_cast<ExecStartUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ExecStartCallbackIF*) _callback)->onExecStartUpdate(proxyShared, payload);
                        proxyShared->_execStart = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ExecStartPost:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ExecStartPostError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ExecStartPost", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ExecStartPostError> payload = ::boost::static_pointer_cast<ExecStartPostError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ExecStartPostCallbackIF*) _callback)->onExecStartPostError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ExecStartPostUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ExecStartPost", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ExecStartPostUpdate> payload = ::boost::static_pointer_cast<ExecStartPostUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ExecStartPostCallbackIF*) _callback)->onExecStartPostUpdate(proxyShared, payload);
                        proxyShared->_execStartPost = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ExecReload:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ExecReloadError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ExecReload", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ExecReloadError> payload = ::boost::static_pointer_cast<ExecReloadError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ExecReloadCallbackIF*) _callback)->onExecReloadError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ExecReloadUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ExecReload", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ExecReloadUpdate> payload = ::boost::static_pointer_cast<ExecReloadUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ExecReloadCallbackIF*) _callback)->onExecReloadUpdate(proxyShared, payload);
                        proxyShared->_execReload = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ExecStop:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ExecStopError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ExecStop", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ExecStopError> payload = ::boost::static_pointer_cast<ExecStopError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ExecStopCallbackIF*) _callback)->onExecStopError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ExecStopUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ExecStop", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ExecStopUpdate> payload = ::boost::static_pointer_cast<ExecStopUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ExecStopCallbackIF*) _callback)->onExecStopUpdate(proxyShared, payload);
                        proxyShared->_execStop = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ExecStopPost:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ExecStopPostError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ExecStopPost", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ExecStopPostError> payload = ::boost::static_pointer_cast<ExecStopPostError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ExecStopPostCallbackIF*) _callback)->onExecStopPostError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ExecStopPostUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ExecStopPost", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ExecStopPostUpdate> payload = ::boost::static_pointer_cast<ExecStopPostUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ExecStopPostCallbackIF*) _callback)->onExecStopPostUpdate(proxyShared, payload);
                        proxyShared->_execStopPost = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Slice:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SliceError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Slice", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SliceError> payload = ::boost::static_pointer_cast<SliceError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SliceCallbackIF*) _callback)->onSliceError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SliceUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Slice", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SliceUpdate> payload = ::boost::static_pointer_cast<SliceUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SliceCallbackIF*) _callback)->onSliceUpdate(proxyShared, payload);
                        proxyShared->_slice = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ControlGroup:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ControlGroupError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ControlGroup", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ControlGroupError> payload = ::boost::static_pointer_cast<ControlGroupError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ControlGroupCallbackIF*) _callback)->onControlGroupError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ControlGroupUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ControlGroup", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ControlGroupUpdate> payload = ::boost::static_pointer_cast<ControlGroupUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ControlGroupCallbackIF*) _callback)->onControlGroupUpdate(proxyShared, payload);
                        proxyShared->_controlGroup = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_MemoryCurrent:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MemoryCurrentError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "MemoryCurrent", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MemoryCurrentError> payload = ::boost::static_pointer_cast<MemoryCurrentError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((MemoryCurrentCallbackIF*) _callback)->onMemoryCurrentError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MemoryCurrentUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "MemoryCurrent", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MemoryCurrentUpdate> payload = ::boost::static_pointer_cast<MemoryCurrentUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((MemoryCurrentCallbackIF*) _callback)->onMemoryCurrentUpdate(proxyShared, payload);
                        proxyShared->_memoryCurrent = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_CPUUsageNSec:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CPUUsageNSecError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CPUUsageNSec", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CPUUsageNSecError> payload = ::boost::static_pointer_cast<CPUUsageNSecError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((CPUUsageNSecCallbackIF*) _callback)->onCPUUsageNSecError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CPUUsageNSecUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CPUUsageNSec", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CPUUsageNSecUpdate> payload = ::boost::static_pointer_cast<CPUUsageNSecUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((CPUUsageNSecCallbackIF*) _callback)->onCPUUsageNSecUpdate(proxyShared, payload);
                        proxyShared->_cPUUsageNSec = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Delegate:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DelegateError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Delegate", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DelegateError> payload = ::boost::static_pointer_cast<DelegateError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((DelegateCallbackIF*) _callback)->onDelegateError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DelegateUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Delegate", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DelegateUpdate> payload = ::boost::static_pointer_cast<DelegateUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((DelegateCallbackIF*) _callback)->onDelegateUpdate(proxyShared, payload);
                        proxyShared->_delegate = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_CPUAccounting:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CPUAccountingError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CPUAccounting", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CPUAccountingError> payload = ::boost::static_pointer_cast<CPUAccountingError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((CPUAccountingCallbackIF*) _callback)->onCPUAccountingError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CPUAccountingUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CPUAccounting", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CPUAccountingUpdate> payload = ::boost::static_pointer_cast<CPUAccountingUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((CPUAccountingCallbackIF*) _callback)->onCPUAccountingUpdate(proxyShared, payload);
                        proxyShared->_cPUAccounting = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_CPUShares:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CPUSharesError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CPUShares", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CPUSharesError> payload = ::boost::static_pointer_cast<CPUSharesError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((CPUSharesCallbackIF*) _callback)->onCPUSharesError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CPUSharesUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CPUShares", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CPUSharesUpdate> payload = ::boost::static_pointer_cast<CPUSharesUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((CPUSharesCallbackIF*) _callback)->onCPUSharesUpdate(proxyShared, payload);
                        proxyShared->_cPUShares = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_StartupCPUShares:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartupCPUSharesError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "StartupCPUShares", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartupCPUSharesError> payload = ::boost::static_pointer_cast<StartupCPUSharesError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((StartupCPUSharesCallbackIF*) _callback)->onStartupCPUSharesError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartupCPUSharesUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "StartupCPUShares", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartupCPUSharesUpdate> payload = ::boost::static_pointer_cast<StartupCPUSharesUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((StartupCPUSharesCallbackIF*) _callback)->onStartupCPUSharesUpdate(proxyShared, payload);
                        proxyShared->_startupCPUShares = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_CPUQuotaPerSecUSec:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CPUQuotaPerSecUSecError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CPUQuotaPerSecUSec", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CPUQuotaPerSecUSecError> payload = ::boost::static_pointer_cast<CPUQuotaPerSecUSecError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((CPUQuotaPerSecUSecCallbackIF*) _callback)->onCPUQuotaPerSecUSecError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CPUQuotaPerSecUSecUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CPUQuotaPerSecUSec", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CPUQuotaPerSecUSecUpdate> payload = ::boost::static_pointer_cast<CPUQuotaPerSecUSecUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((CPUQuotaPerSecUSecCallbackIF*) _callback)->onCPUQuotaPerSecUSecUpdate(proxyShared, payload);
                        proxyShared->_cPUQuotaPerSecUSec = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_BlockIOAccounting:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BlockIOAccountingError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BlockIOAccounting", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BlockIOAccountingError> payload = ::boost::static_pointer_cast<BlockIOAccountingError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((BlockIOAccountingCallbackIF*) _callback)->onBlockIOAccountingError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BlockIOAccountingUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BlockIOAccounting", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BlockIOAccountingUpdate> payload = ::boost::static_pointer_cast<BlockIOAccountingUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((BlockIOAccountingCallbackIF*) _callback)->onBlockIOAccountingUpdate(proxyShared, payload);
                        proxyShared->_blockIOAccounting = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_BlockIOWeight:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BlockIOWeightError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BlockIOWeight", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BlockIOWeightError> payload = ::boost::static_pointer_cast<BlockIOWeightError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((BlockIOWeightCallbackIF*) _callback)->onBlockIOWeightError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BlockIOWeightUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BlockIOWeight", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BlockIOWeightUpdate> payload = ::boost::static_pointer_cast<BlockIOWeightUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((BlockIOWeightCallbackIF*) _callback)->onBlockIOWeightUpdate(proxyShared, payload);
                        proxyShared->_blockIOWeight = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_StartupBlockIOWeight:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartupBlockIOWeightError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "StartupBlockIOWeight", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartupBlockIOWeightError> payload = ::boost::static_pointer_cast<StartupBlockIOWeightError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((StartupBlockIOWeightCallbackIF*) _callback)->onStartupBlockIOWeightError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartupBlockIOWeightUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "StartupBlockIOWeight", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartupBlockIOWeightUpdate> payload = ::boost::static_pointer_cast<StartupBlockIOWeightUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((StartupBlockIOWeightCallbackIF*) _callback)->onStartupBlockIOWeightUpdate(proxyShared, payload);
                        proxyShared->_startupBlockIOWeight = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_BlockIODeviceWeight:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BlockIODeviceWeightError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BlockIODeviceWeight", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BlockIODeviceWeightError> payload = ::boost::static_pointer_cast<BlockIODeviceWeightError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((BlockIODeviceWeightCallbackIF*) _callback)->onBlockIODeviceWeightError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BlockIODeviceWeightUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BlockIODeviceWeight", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BlockIODeviceWeightUpdate> payload = ::boost::static_pointer_cast<BlockIODeviceWeightUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((BlockIODeviceWeightCallbackIF*) _callback)->onBlockIODeviceWeightUpdate(proxyShared, payload);
                        proxyShared->_blockIODeviceWeight = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_BlockIOReadBandwidth:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BlockIOReadBandwidthError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BlockIOReadBandwidth", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BlockIOReadBandwidthError> payload = ::boost::static_pointer_cast<BlockIOReadBandwidthError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((BlockIOReadBandwidthCallbackIF*) _callback)->onBlockIOReadBandwidthError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BlockIOReadBandwidthUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BlockIOReadBandwidth", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BlockIOReadBandwidthUpdate> payload = ::boost::static_pointer_cast<BlockIOReadBandwidthUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((BlockIOReadBandwidthCallbackIF*) _callback)->onBlockIOReadBandwidthUpdate(proxyShared, payload);
                        proxyShared->_blockIOReadBandwidth = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_BlockIOWriteBandwidth:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BlockIOWriteBandwidthError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BlockIOWriteBandwidth", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BlockIOWriteBandwidthError> payload = ::boost::static_pointer_cast<BlockIOWriteBandwidthError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((BlockIOWriteBandwidthCallbackIF*) _callback)->onBlockIOWriteBandwidthError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BlockIOWriteBandwidthUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BlockIOWriteBandwidth", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BlockIOWriteBandwidthUpdate> payload = ::boost::static_pointer_cast<BlockIOWriteBandwidthUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((BlockIOWriteBandwidthCallbackIF*) _callback)->onBlockIOWriteBandwidthUpdate(proxyShared, payload);
                        proxyShared->_blockIOWriteBandwidth = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_MemoryAccounting:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MemoryAccountingError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "MemoryAccounting", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MemoryAccountingError> payload = ::boost::static_pointer_cast<MemoryAccountingError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((MemoryAccountingCallbackIF*) _callback)->onMemoryAccountingError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MemoryAccountingUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "MemoryAccounting", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MemoryAccountingUpdate> payload = ::boost::static_pointer_cast<MemoryAccountingUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((MemoryAccountingCallbackIF*) _callback)->onMemoryAccountingUpdate(proxyShared, payload);
                        proxyShared->_memoryAccounting = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_MemoryLimit:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MemoryLimitError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "MemoryLimit", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MemoryLimitError> payload = ::boost::static_pointer_cast<MemoryLimitError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((MemoryLimitCallbackIF*) _callback)->onMemoryLimitError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MemoryLimitUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "MemoryLimit", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MemoryLimitUpdate> payload = ::boost::static_pointer_cast<MemoryLimitUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((MemoryLimitCallbackIF*) _callback)->onMemoryLimitUpdate(proxyShared, payload);
                        proxyShared->_memoryLimit = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_DevicePolicy:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DevicePolicyError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DevicePolicy", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DevicePolicyError> payload = ::boost::static_pointer_cast<DevicePolicyError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((DevicePolicyCallbackIF*) _callback)->onDevicePolicyError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DevicePolicyUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DevicePolicy", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DevicePolicyUpdate> payload = ::boost::static_pointer_cast<DevicePolicyUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((DevicePolicyCallbackIF*) _callback)->onDevicePolicyUpdate(proxyShared, payload);
                        proxyShared->_devicePolicy = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_DeviceAllow:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DeviceAllowError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DeviceAllow", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DeviceAllowError> payload = ::boost::static_pointer_cast<DeviceAllowError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((DeviceAllowCallbackIF*) _callback)->onDeviceAllowError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DeviceAllowUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DeviceAllow", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DeviceAllowUpdate> payload = ::boost::static_pointer_cast<DeviceAllowUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((DeviceAllowCallbackIF*) _callback)->onDeviceAllowUpdate(proxyShared, payload);
                        proxyShared->_deviceAllow = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Environment:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EnvironmentError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Environment", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EnvironmentError> payload = ::boost::static_pointer_cast<EnvironmentError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((EnvironmentCallbackIF*) _callback)->onEnvironmentError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EnvironmentUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Environment", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EnvironmentUpdate> payload = ::boost::static_pointer_cast<EnvironmentUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((EnvironmentCallbackIF*) _callback)->onEnvironmentUpdate(proxyShared, payload);
                        proxyShared->_environment = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_EnvironmentFiles:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EnvironmentFilesError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "EnvironmentFiles", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EnvironmentFilesError> payload = ::boost::static_pointer_cast<EnvironmentFilesError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((EnvironmentFilesCallbackIF*) _callback)->onEnvironmentFilesError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EnvironmentFilesUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "EnvironmentFiles", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EnvironmentFilesUpdate> payload = ::boost::static_pointer_cast<EnvironmentFilesUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((EnvironmentFilesCallbackIF*) _callback)->onEnvironmentFilesUpdate(proxyShared, payload);
                        proxyShared->_environmentFiles = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_UMask:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UMaskError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "UMask", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UMaskError> payload = ::boost::static_pointer_cast<UMaskError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((UMaskCallbackIF*) _callback)->onUMaskError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UMaskUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "UMask", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UMaskUpdate> payload = ::boost::static_pointer_cast<UMaskUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((UMaskCallbackIF*) _callback)->onUMaskUpdate(proxyShared, payload);
                        proxyShared->_uMask = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_LimitCPU:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LimitCPUError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LimitCPU", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LimitCPUError> payload = ::boost::static_pointer_cast<LimitCPUError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((LimitCPUCallbackIF*) _callback)->onLimitCPUError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LimitCPUUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LimitCPU", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LimitCPUUpdate> payload = ::boost::static_pointer_cast<LimitCPUUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((LimitCPUCallbackIF*) _callback)->onLimitCPUUpdate(proxyShared, payload);
                        proxyShared->_limitCPU = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_LimitFSIZE:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LimitFSIZEError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LimitFSIZE", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LimitFSIZEError> payload = ::boost::static_pointer_cast<LimitFSIZEError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((LimitFSIZECallbackIF*) _callback)->onLimitFSIZEError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LimitFSIZEUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LimitFSIZE", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LimitFSIZEUpdate> payload = ::boost::static_pointer_cast<LimitFSIZEUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((LimitFSIZECallbackIF*) _callback)->onLimitFSIZEUpdate(proxyShared, payload);
                        proxyShared->_limitFSIZE = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_LimitDATA:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LimitDATAError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LimitDATA", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LimitDATAError> payload = ::boost::static_pointer_cast<LimitDATAError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((LimitDATACallbackIF*) _callback)->onLimitDATAError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LimitDATAUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LimitDATA", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LimitDATAUpdate> payload = ::boost::static_pointer_cast<LimitDATAUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((LimitDATACallbackIF*) _callback)->onLimitDATAUpdate(proxyShared, payload);
                        proxyShared->_limitDATA = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_LimitSTACK:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LimitSTACKError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LimitSTACK", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LimitSTACKError> payload = ::boost::static_pointer_cast<LimitSTACKError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((LimitSTACKCallbackIF*) _callback)->onLimitSTACKError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LimitSTACKUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LimitSTACK", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LimitSTACKUpdate> payload = ::boost::static_pointer_cast<LimitSTACKUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((LimitSTACKCallbackIF*) _callback)->onLimitSTACKUpdate(proxyShared, payload);
                        proxyShared->_limitSTACK = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_LimitCORE:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LimitCOREError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LimitCORE", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LimitCOREError> payload = ::boost::static_pointer_cast<LimitCOREError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((LimitCORECallbackIF*) _callback)->onLimitCOREError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LimitCOREUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LimitCORE", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LimitCOREUpdate> payload = ::boost::static_pointer_cast<LimitCOREUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((LimitCORECallbackIF*) _callback)->onLimitCOREUpdate(proxyShared, payload);
                        proxyShared->_limitCORE = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_LimitRSS:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LimitRSSError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LimitRSS", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LimitRSSError> payload = ::boost::static_pointer_cast<LimitRSSError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((LimitRSSCallbackIF*) _callback)->onLimitRSSError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LimitRSSUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LimitRSS", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LimitRSSUpdate> payload = ::boost::static_pointer_cast<LimitRSSUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((LimitRSSCallbackIF*) _callback)->onLimitRSSUpdate(proxyShared, payload);
                        proxyShared->_limitRSS = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_LimitNOFILE:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LimitNOFILEError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LimitNOFILE", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LimitNOFILEError> payload = ::boost::static_pointer_cast<LimitNOFILEError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((LimitNOFILECallbackIF*) _callback)->onLimitNOFILEError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LimitNOFILEUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LimitNOFILE", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LimitNOFILEUpdate> payload = ::boost::static_pointer_cast<LimitNOFILEUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((LimitNOFILECallbackIF*) _callback)->onLimitNOFILEUpdate(proxyShared, payload);
                        proxyShared->_limitNOFILE = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_LimitAS:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LimitASError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LimitAS", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LimitASError> payload = ::boost::static_pointer_cast<LimitASError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((LimitASCallbackIF*) _callback)->onLimitASError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LimitASUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LimitAS", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LimitASUpdate> payload = ::boost::static_pointer_cast<LimitASUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((LimitASCallbackIF*) _callback)->onLimitASUpdate(proxyShared, payload);
                        proxyShared->_limitAS = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_LimitNPROC:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LimitNPROCError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LimitNPROC", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LimitNPROCError> payload = ::boost::static_pointer_cast<LimitNPROCError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((LimitNPROCCallbackIF*) _callback)->onLimitNPROCError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LimitNPROCUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LimitNPROC", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LimitNPROCUpdate> payload = ::boost::static_pointer_cast<LimitNPROCUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((LimitNPROCCallbackIF*) _callback)->onLimitNPROCUpdate(proxyShared, payload);
                        proxyShared->_limitNPROC = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_LimitMEMLOCK:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LimitMEMLOCKError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LimitMEMLOCK", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LimitMEMLOCKError> payload = ::boost::static_pointer_cast<LimitMEMLOCKError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((LimitMEMLOCKCallbackIF*) _callback)->onLimitMEMLOCKError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LimitMEMLOCKUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LimitMEMLOCK", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LimitMEMLOCKUpdate> payload = ::boost::static_pointer_cast<LimitMEMLOCKUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((LimitMEMLOCKCallbackIF*) _callback)->onLimitMEMLOCKUpdate(proxyShared, payload);
                        proxyShared->_limitMEMLOCK = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_LimitLOCKS:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LimitLOCKSError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LimitLOCKS", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LimitLOCKSError> payload = ::boost::static_pointer_cast<LimitLOCKSError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((LimitLOCKSCallbackIF*) _callback)->onLimitLOCKSError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LimitLOCKSUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LimitLOCKS", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LimitLOCKSUpdate> payload = ::boost::static_pointer_cast<LimitLOCKSUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((LimitLOCKSCallbackIF*) _callback)->onLimitLOCKSUpdate(proxyShared, payload);
                        proxyShared->_limitLOCKS = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_LimitSIGPENDING:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LimitSIGPENDINGError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LimitSIGPENDING", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LimitSIGPENDINGError> payload = ::boost::static_pointer_cast<LimitSIGPENDINGError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((LimitSIGPENDINGCallbackIF*) _callback)->onLimitSIGPENDINGError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LimitSIGPENDINGUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LimitSIGPENDING", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LimitSIGPENDINGUpdate> payload = ::boost::static_pointer_cast<LimitSIGPENDINGUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((LimitSIGPENDINGCallbackIF*) _callback)->onLimitSIGPENDINGUpdate(proxyShared, payload);
                        proxyShared->_limitSIGPENDING = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_LimitMSGQUEUE:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LimitMSGQUEUEError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LimitMSGQUEUE", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LimitMSGQUEUEError> payload = ::boost::static_pointer_cast<LimitMSGQUEUEError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((LimitMSGQUEUECallbackIF*) _callback)->onLimitMSGQUEUEError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LimitMSGQUEUEUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LimitMSGQUEUE", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LimitMSGQUEUEUpdate> payload = ::boost::static_pointer_cast<LimitMSGQUEUEUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((LimitMSGQUEUECallbackIF*) _callback)->onLimitMSGQUEUEUpdate(proxyShared, payload);
                        proxyShared->_limitMSGQUEUE = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_LimitNICE:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LimitNICEError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LimitNICE", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LimitNICEError> payload = ::boost::static_pointer_cast<LimitNICEError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((LimitNICECallbackIF*) _callback)->onLimitNICEError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LimitNICEUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LimitNICE", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LimitNICEUpdate> payload = ::boost::static_pointer_cast<LimitNICEUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((LimitNICECallbackIF*) _callback)->onLimitNICEUpdate(proxyShared, payload);
                        proxyShared->_limitNICE = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_LimitRTPRIO:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LimitRTPRIOError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LimitRTPRIO", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LimitRTPRIOError> payload = ::boost::static_pointer_cast<LimitRTPRIOError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((LimitRTPRIOCallbackIF*) _callback)->onLimitRTPRIOError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LimitRTPRIOUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LimitRTPRIO", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LimitRTPRIOUpdate> payload = ::boost::static_pointer_cast<LimitRTPRIOUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((LimitRTPRIOCallbackIF*) _callback)->onLimitRTPRIOUpdate(proxyShared, payload);
                        proxyShared->_limitRTPRIO = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_LimitRTTIME:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LimitRTTIMEError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LimitRTTIME", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LimitRTTIMEError> payload = ::boost::static_pointer_cast<LimitRTTIMEError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((LimitRTTIMECallbackIF*) _callback)->onLimitRTTIMEError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LimitRTTIMEUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LimitRTTIME", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LimitRTTIMEUpdate> payload = ::boost::static_pointer_cast<LimitRTTIMEUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((LimitRTTIMECallbackIF*) _callback)->onLimitRTTIMEUpdate(proxyShared, payload);
                        proxyShared->_limitRTTIME = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_WorkingDirectory:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), WorkingDirectoryError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "WorkingDirectory", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<WorkingDirectoryError> payload = ::boost::static_pointer_cast<WorkingDirectoryError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((WorkingDirectoryCallbackIF*) _callback)->onWorkingDirectoryError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), WorkingDirectoryUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "WorkingDirectory", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<WorkingDirectoryUpdate> payload = ::boost::static_pointer_cast<WorkingDirectoryUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((WorkingDirectoryCallbackIF*) _callback)->onWorkingDirectoryUpdate(proxyShared, payload);
                        proxyShared->_workingDirectory = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_RootDirectory:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RootDirectoryError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RootDirectory", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RootDirectoryError> payload = ::boost::static_pointer_cast<RootDirectoryError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((RootDirectoryCallbackIF*) _callback)->onRootDirectoryError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RootDirectoryUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RootDirectory", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RootDirectoryUpdate> payload = ::boost::static_pointer_cast<RootDirectoryUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((RootDirectoryCallbackIF*) _callback)->onRootDirectoryUpdate(proxyShared, payload);
                        proxyShared->_rootDirectory = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_OOMScoreAdjust:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), OOMScoreAdjustError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "OOMScoreAdjust", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<OOMScoreAdjustError> payload = ::boost::static_pointer_cast<OOMScoreAdjustError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((OOMScoreAdjustCallbackIF*) _callback)->onOOMScoreAdjustError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), OOMScoreAdjustUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "OOMScoreAdjust", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<OOMScoreAdjustUpdate> payload = ::boost::static_pointer_cast<OOMScoreAdjustUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((OOMScoreAdjustCallbackIF*) _callback)->onOOMScoreAdjustUpdate(proxyShared, payload);
                        proxyShared->_oOMScoreAdjust = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Nice:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NiceError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Nice", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NiceError> payload = ::boost::static_pointer_cast<NiceError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((NiceCallbackIF*) _callback)->onNiceError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NiceUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Nice", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NiceUpdate> payload = ::boost::static_pointer_cast<NiceUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((NiceCallbackIF*) _callback)->onNiceUpdate(proxyShared, payload);
                        proxyShared->_nice = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_IOScheduling:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), IOSchedulingError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "IOScheduling", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<IOSchedulingError> payload = ::boost::static_pointer_cast<IOSchedulingError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((IOSchedulingCallbackIF*) _callback)->onIOSchedulingError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), IOSchedulingUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "IOScheduling", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<IOSchedulingUpdate> payload = ::boost::static_pointer_cast<IOSchedulingUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((IOSchedulingCallbackIF*) _callback)->onIOSchedulingUpdate(proxyShared, payload);
                        proxyShared->_iOScheduling = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_CPUSchedulingPolicy:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CPUSchedulingPolicyError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CPUSchedulingPolicy", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CPUSchedulingPolicyError> payload = ::boost::static_pointer_cast<CPUSchedulingPolicyError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((CPUSchedulingPolicyCallbackIF*) _callback)->onCPUSchedulingPolicyError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CPUSchedulingPolicyUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CPUSchedulingPolicy", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CPUSchedulingPolicyUpdate> payload = ::boost::static_pointer_cast<CPUSchedulingPolicyUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((CPUSchedulingPolicyCallbackIF*) _callback)->onCPUSchedulingPolicyUpdate(proxyShared, payload);
                        proxyShared->_cPUSchedulingPolicy = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_CPUSchedulingPriority:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CPUSchedulingPriorityError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CPUSchedulingPriority", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CPUSchedulingPriorityError> payload = ::boost::static_pointer_cast<CPUSchedulingPriorityError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((CPUSchedulingPriorityCallbackIF*) _callback)->onCPUSchedulingPriorityError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CPUSchedulingPriorityUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CPUSchedulingPriority", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CPUSchedulingPriorityUpdate> payload = ::boost::static_pointer_cast<CPUSchedulingPriorityUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((CPUSchedulingPriorityCallbackIF*) _callback)->onCPUSchedulingPriorityUpdate(proxyShared, payload);
                        proxyShared->_cPUSchedulingPriority = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_CPUAffinity:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CPUAffinityError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CPUAffinity", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CPUAffinityError> payload = ::boost::static_pointer_cast<CPUAffinityError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((CPUAffinityCallbackIF*) _callback)->onCPUAffinityError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CPUAffinityUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CPUAffinity", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CPUAffinityUpdate> payload = ::boost::static_pointer_cast<CPUAffinityUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((CPUAffinityCallbackIF*) _callback)->onCPUAffinityUpdate(proxyShared, payload);
                        proxyShared->_cPUAffinity = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_TimerSlackNSec:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TimerSlackNSecError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "TimerSlackNSec", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TimerSlackNSecError> payload = ::boost::static_pointer_cast<TimerSlackNSecError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((TimerSlackNSecCallbackIF*) _callback)->onTimerSlackNSecError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TimerSlackNSecUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "TimerSlackNSec", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TimerSlackNSecUpdate> payload = ::boost::static_pointer_cast<TimerSlackNSecUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((TimerSlackNSecCallbackIF*) _callback)->onTimerSlackNSecUpdate(proxyShared, payload);
                        proxyShared->_timerSlackNSec = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_CPUSchedulingResetOnFork:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CPUSchedulingResetOnForkError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CPUSchedulingResetOnFork", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CPUSchedulingResetOnForkError> payload = ::boost::static_pointer_cast<CPUSchedulingResetOnForkError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((CPUSchedulingResetOnForkCallbackIF*) _callback)->onCPUSchedulingResetOnForkError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CPUSchedulingResetOnForkUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CPUSchedulingResetOnFork", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CPUSchedulingResetOnForkUpdate> payload = ::boost::static_pointer_cast<CPUSchedulingResetOnForkUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((CPUSchedulingResetOnForkCallbackIF*) _callback)->onCPUSchedulingResetOnForkUpdate(proxyShared, payload);
                        proxyShared->_cPUSchedulingResetOnFork = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_NonBlocking:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NonBlockingError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NonBlocking", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NonBlockingError> payload = ::boost::static_pointer_cast<NonBlockingError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((NonBlockingCallbackIF*) _callback)->onNonBlockingError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NonBlockingUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NonBlocking", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NonBlockingUpdate> payload = ::boost::static_pointer_cast<NonBlockingUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((NonBlockingCallbackIF*) _callback)->onNonBlockingUpdate(proxyShared, payload);
                        proxyShared->_nonBlocking = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_StandardInput:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StandardInputError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "StandardInput", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StandardInputError> payload = ::boost::static_pointer_cast<StandardInputError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((StandardInputCallbackIF*) _callback)->onStandardInputError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StandardInputUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "StandardInput", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StandardInputUpdate> payload = ::boost::static_pointer_cast<StandardInputUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((StandardInputCallbackIF*) _callback)->onStandardInputUpdate(proxyShared, payload);
                        proxyShared->_standardInput = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_StandardOutput:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StandardOutputError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "StandardOutput", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StandardOutputError> payload = ::boost::static_pointer_cast<StandardOutputError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((StandardOutputCallbackIF*) _callback)->onStandardOutputError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StandardOutputUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "StandardOutput", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StandardOutputUpdate> payload = ::boost::static_pointer_cast<StandardOutputUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((StandardOutputCallbackIF*) _callback)->onStandardOutputUpdate(proxyShared, payload);
                        proxyShared->_standardOutput = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_StandardError:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StandardErrorError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "StandardError", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StandardErrorError> payload = ::boost::static_pointer_cast<StandardErrorError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((StandardErrorCallbackIF*) _callback)->onStandardErrorError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StandardErrorUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "StandardError", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StandardErrorUpdate> payload = ::boost::static_pointer_cast<StandardErrorUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((StandardErrorCallbackIF*) _callback)->onStandardErrorUpdate(proxyShared, payload);
                        proxyShared->_standardError = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_TTYPath:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TTYPathError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "TTYPath", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TTYPathError> payload = ::boost::static_pointer_cast<TTYPathError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((TTYPathCallbackIF*) _callback)->onTTYPathError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TTYPathUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "TTYPath", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TTYPathUpdate> payload = ::boost::static_pointer_cast<TTYPathUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((TTYPathCallbackIF*) _callback)->onTTYPathUpdate(proxyShared, payload);
                        proxyShared->_tTYPath = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_TTYReset:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TTYResetError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "TTYReset", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TTYResetError> payload = ::boost::static_pointer_cast<TTYResetError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((TTYResetCallbackIF*) _callback)->onTTYResetError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TTYResetUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "TTYReset", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TTYResetUpdate> payload = ::boost::static_pointer_cast<TTYResetUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((TTYResetCallbackIF*) _callback)->onTTYResetUpdate(proxyShared, payload);
                        proxyShared->_tTYReset = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_TTYVHangup:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TTYVHangupError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "TTYVHangup", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TTYVHangupError> payload = ::boost::static_pointer_cast<TTYVHangupError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((TTYVHangupCallbackIF*) _callback)->onTTYVHangupError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TTYVHangupUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "TTYVHangup", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TTYVHangupUpdate> payload = ::boost::static_pointer_cast<TTYVHangupUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((TTYVHangupCallbackIF*) _callback)->onTTYVHangupUpdate(proxyShared, payload);
                        proxyShared->_tTYVHangup = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_TTYVTDisallocate:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TTYVTDisallocateError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "TTYVTDisallocate", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TTYVTDisallocateError> payload = ::boost::static_pointer_cast<TTYVTDisallocateError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((TTYVTDisallocateCallbackIF*) _callback)->onTTYVTDisallocateError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TTYVTDisallocateUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "TTYVTDisallocate", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TTYVTDisallocateUpdate> payload = ::boost::static_pointer_cast<TTYVTDisallocateUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((TTYVTDisallocateCallbackIF*) _callback)->onTTYVTDisallocateUpdate(proxyShared, payload);
                        proxyShared->_tTYVTDisallocate = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_SyslogPriority:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SyslogPriorityError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SyslogPriority", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SyslogPriorityError> payload = ::boost::static_pointer_cast<SyslogPriorityError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SyslogPriorityCallbackIF*) _callback)->onSyslogPriorityError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SyslogPriorityUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SyslogPriority", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SyslogPriorityUpdate> payload = ::boost::static_pointer_cast<SyslogPriorityUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SyslogPriorityCallbackIF*) _callback)->onSyslogPriorityUpdate(proxyShared, payload);
                        proxyShared->_syslogPriority = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_SyslogIdentifier:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SyslogIdentifierError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SyslogIdentifier", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SyslogIdentifierError> payload = ::boost::static_pointer_cast<SyslogIdentifierError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SyslogIdentifierCallbackIF*) _callback)->onSyslogIdentifierError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SyslogIdentifierUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SyslogIdentifier", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SyslogIdentifierUpdate> payload = ::boost::static_pointer_cast<SyslogIdentifierUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SyslogIdentifierCallbackIF*) _callback)->onSyslogIdentifierUpdate(proxyShared, payload);
                        proxyShared->_syslogIdentifier = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_SyslogLevelPrefix:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SyslogLevelPrefixError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SyslogLevelPrefix", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SyslogLevelPrefixError> payload = ::boost::static_pointer_cast<SyslogLevelPrefixError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SyslogLevelPrefixCallbackIF*) _callback)->onSyslogLevelPrefixError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SyslogLevelPrefixUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SyslogLevelPrefix", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SyslogLevelPrefixUpdate> payload = ::boost::static_pointer_cast<SyslogLevelPrefixUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SyslogLevelPrefixCallbackIF*) _callback)->onSyslogLevelPrefixUpdate(proxyShared, payload);
                        proxyShared->_syslogLevelPrefix = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Capabilities:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CapabilitiesError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Capabilities", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CapabilitiesError> payload = ::boost::static_pointer_cast<CapabilitiesError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((CapabilitiesCallbackIF*) _callback)->onCapabilitiesError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CapabilitiesUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Capabilities", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CapabilitiesUpdate> payload = ::boost::static_pointer_cast<CapabilitiesUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((CapabilitiesCallbackIF*) _callback)->onCapabilitiesUpdate(proxyShared, payload);
                        proxyShared->_capabilities = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_SecureBits:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SecureBitsError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SecureBits", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SecureBitsError> payload = ::boost::static_pointer_cast<SecureBitsError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SecureBitsCallbackIF*) _callback)->onSecureBitsError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SecureBitsUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SecureBits", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SecureBitsUpdate> payload = ::boost::static_pointer_cast<SecureBitsUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SecureBitsCallbackIF*) _callback)->onSecureBitsUpdate(proxyShared, payload);
                        proxyShared->_secureBits = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_CapabilityBoundingSet:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CapabilityBoundingSetError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CapabilityBoundingSet", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CapabilityBoundingSetError> payload = ::boost::static_pointer_cast<CapabilityBoundingSetError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((CapabilityBoundingSetCallbackIF*) _callback)->onCapabilityBoundingSetError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CapabilityBoundingSetUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CapabilityBoundingSet", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CapabilityBoundingSetUpdate> payload = ::boost::static_pointer_cast<CapabilityBoundingSetUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((CapabilityBoundingSetCallbackIF*) _callback)->onCapabilityBoundingSetUpdate(proxyShared, payload);
                        proxyShared->_capabilityBoundingSet = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_User:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UserError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "User", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UserError> payload = ::boost::static_pointer_cast<UserError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((UserCallbackIF*) _callback)->onUserError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UserUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "User", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UserUpdate> payload = ::boost::static_pointer_cast<UserUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((UserCallbackIF*) _callback)->onUserUpdate(proxyShared, payload);
                        proxyShared->_user = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Group:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GroupError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Group", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GroupError> payload = ::boost::static_pointer_cast<GroupError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((GroupCallbackIF*) _callback)->onGroupError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GroupUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Group", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GroupUpdate> payload = ::boost::static_pointer_cast<GroupUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((GroupCallbackIF*) _callback)->onGroupUpdate(proxyShared, payload);
                        proxyShared->_group = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_SupplementaryGroups:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SupplementaryGroupsError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SupplementaryGroups", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SupplementaryGroupsError> payload = ::boost::static_pointer_cast<SupplementaryGroupsError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SupplementaryGroupsCallbackIF*) _callback)->onSupplementaryGroupsError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SupplementaryGroupsUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SupplementaryGroups", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SupplementaryGroupsUpdate> payload = ::boost::static_pointer_cast<SupplementaryGroupsUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SupplementaryGroupsCallbackIF*) _callback)->onSupplementaryGroupsUpdate(proxyShared, payload);
                        proxyShared->_supplementaryGroups = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_PAMName:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PAMNameError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PAMName", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PAMNameError> payload = ::boost::static_pointer_cast<PAMNameError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((PAMNameCallbackIF*) _callback)->onPAMNameError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PAMNameUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PAMName", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PAMNameUpdate> payload = ::boost::static_pointer_cast<PAMNameUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((PAMNameCallbackIF*) _callback)->onPAMNameUpdate(proxyShared, payload);
                        proxyShared->_pAMName = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ReadWriteDirectories:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReadWriteDirectoriesError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ReadWriteDirectories", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReadWriteDirectoriesError> payload = ::boost::static_pointer_cast<ReadWriteDirectoriesError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ReadWriteDirectoriesCallbackIF*) _callback)->onReadWriteDirectoriesError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReadWriteDirectoriesUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ReadWriteDirectories", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReadWriteDirectoriesUpdate> payload = ::boost::static_pointer_cast<ReadWriteDirectoriesUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ReadWriteDirectoriesCallbackIF*) _callback)->onReadWriteDirectoriesUpdate(proxyShared, payload);
                        proxyShared->_readWriteDirectories = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ReadOnlyDirectories:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReadOnlyDirectoriesError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ReadOnlyDirectories", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReadOnlyDirectoriesError> payload = ::boost::static_pointer_cast<ReadOnlyDirectoriesError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ReadOnlyDirectoriesCallbackIF*) _callback)->onReadOnlyDirectoriesError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReadOnlyDirectoriesUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ReadOnlyDirectories", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReadOnlyDirectoriesUpdate> payload = ::boost::static_pointer_cast<ReadOnlyDirectoriesUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ReadOnlyDirectoriesCallbackIF*) _callback)->onReadOnlyDirectoriesUpdate(proxyShared, payload);
                        proxyShared->_readOnlyDirectories = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_InaccessibleDirectories:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), InaccessibleDirectoriesError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "InaccessibleDirectories", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<InaccessibleDirectoriesError> payload = ::boost::static_pointer_cast<InaccessibleDirectoriesError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((InaccessibleDirectoriesCallbackIF*) _callback)->onInaccessibleDirectoriesError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), InaccessibleDirectoriesUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "InaccessibleDirectories", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<InaccessibleDirectoriesUpdate> payload = ::boost::static_pointer_cast<InaccessibleDirectoriesUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((InaccessibleDirectoriesCallbackIF*) _callback)->onInaccessibleDirectoriesUpdate(proxyShared, payload);
                        proxyShared->_inaccessibleDirectories = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_MountFlags:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MountFlagsError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "MountFlags", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MountFlagsError> payload = ::boost::static_pointer_cast<MountFlagsError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((MountFlagsCallbackIF*) _callback)->onMountFlagsError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MountFlagsUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "MountFlags", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MountFlagsUpdate> payload = ::boost::static_pointer_cast<MountFlagsUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((MountFlagsCallbackIF*) _callback)->onMountFlagsUpdate(proxyShared, payload);
                        proxyShared->_mountFlags = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_PrivateTmp:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PrivateTmpError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PrivateTmp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PrivateTmpError> payload = ::boost::static_pointer_cast<PrivateTmpError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((PrivateTmpCallbackIF*) _callback)->onPrivateTmpError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PrivateTmpUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PrivateTmp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PrivateTmpUpdate> payload = ::boost::static_pointer_cast<PrivateTmpUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((PrivateTmpCallbackIF*) _callback)->onPrivateTmpUpdate(proxyShared, payload);
                        proxyShared->_privateTmp = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_PrivateNetwork:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PrivateNetworkError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PrivateNetwork", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PrivateNetworkError> payload = ::boost::static_pointer_cast<PrivateNetworkError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((PrivateNetworkCallbackIF*) _callback)->onPrivateNetworkError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PrivateNetworkUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PrivateNetwork", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PrivateNetworkUpdate> payload = ::boost::static_pointer_cast<PrivateNetworkUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((PrivateNetworkCallbackIF*) _callback)->onPrivateNetworkUpdate(proxyShared, payload);
                        proxyShared->_privateNetwork = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_PrivateDevices:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PrivateDevicesError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PrivateDevices", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PrivateDevicesError> payload = ::boost::static_pointer_cast<PrivateDevicesError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((PrivateDevicesCallbackIF*) _callback)->onPrivateDevicesError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PrivateDevicesUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PrivateDevices", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PrivateDevicesUpdate> payload = ::boost::static_pointer_cast<PrivateDevicesUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((PrivateDevicesCallbackIF*) _callback)->onPrivateDevicesUpdate(proxyShared, payload);
                        proxyShared->_privateDevices = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ProtectHome:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ProtectHomeError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ProtectHome", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ProtectHomeError> payload = ::boost::static_pointer_cast<ProtectHomeError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ProtectHomeCallbackIF*) _callback)->onProtectHomeError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ProtectHomeUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ProtectHome", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ProtectHomeUpdate> payload = ::boost::static_pointer_cast<ProtectHomeUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ProtectHomeCallbackIF*) _callback)->onProtectHomeUpdate(proxyShared, payload);
                        proxyShared->_protectHome = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ProtectSystem:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ProtectSystemError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ProtectSystem", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ProtectSystemError> payload = ::boost::static_pointer_cast<ProtectSystemError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ProtectSystemCallbackIF*) _callback)->onProtectSystemError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ProtectSystemUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ProtectSystem", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ProtectSystemUpdate> payload = ::boost::static_pointer_cast<ProtectSystemUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ProtectSystemCallbackIF*) _callback)->onProtectSystemUpdate(proxyShared, payload);
                        proxyShared->_protectSystem = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_SameProcessGroup:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SameProcessGroupError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SameProcessGroup", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SameProcessGroupError> payload = ::boost::static_pointer_cast<SameProcessGroupError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SameProcessGroupCallbackIF*) _callback)->onSameProcessGroupError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SameProcessGroupUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SameProcessGroup", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SameProcessGroupUpdate> payload = ::boost::static_pointer_cast<SameProcessGroupUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SameProcessGroupCallbackIF*) _callback)->onSameProcessGroupUpdate(proxyShared, payload);
                        proxyShared->_sameProcessGroup = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_UtmpIdentifier:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UtmpIdentifierError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "UtmpIdentifier", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UtmpIdentifierError> payload = ::boost::static_pointer_cast<UtmpIdentifierError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((UtmpIdentifierCallbackIF*) _callback)->onUtmpIdentifierError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UtmpIdentifierUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "UtmpIdentifier", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UtmpIdentifierUpdate> payload = ::boost::static_pointer_cast<UtmpIdentifierUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((UtmpIdentifierCallbackIF*) _callback)->onUtmpIdentifierUpdate(proxyShared, payload);
                        proxyShared->_utmpIdentifier = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_UtmpMode:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UtmpModeError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "UtmpMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UtmpModeError> payload = ::boost::static_pointer_cast<UtmpModeError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((UtmpModeCallbackIF*) _callback)->onUtmpModeError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UtmpModeUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "UtmpMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UtmpModeUpdate> payload = ::boost::static_pointer_cast<UtmpModeUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((UtmpModeCallbackIF*) _callback)->onUtmpModeUpdate(proxyShared, payload);
                        proxyShared->_utmpMode = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_SELinuxContext:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SELinuxContextError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SELinuxContext", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SELinuxContextError> payload = ::boost::static_pointer_cast<SELinuxContextError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SELinuxContextCallbackIF*) _callback)->onSELinuxContextError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SELinuxContextUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SELinuxContext", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SELinuxContextUpdate> payload = ::boost::static_pointer_cast<SELinuxContextUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SELinuxContextCallbackIF*) _callback)->onSELinuxContextUpdate(proxyShared, payload);
                        proxyShared->_sELinuxContext = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_AppArmorProfile:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AppArmorProfileError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AppArmorProfile", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AppArmorProfileError> payload = ::boost::static_pointer_cast<AppArmorProfileError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((AppArmorProfileCallbackIF*) _callback)->onAppArmorProfileError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AppArmorProfileUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AppArmorProfile", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AppArmorProfileUpdate> payload = ::boost::static_pointer_cast<AppArmorProfileUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((AppArmorProfileCallbackIF*) _callback)->onAppArmorProfileUpdate(proxyShared, payload);
                        proxyShared->_appArmorProfile = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_SmackProcessLabel:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SmackProcessLabelError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SmackProcessLabel", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SmackProcessLabelError> payload = ::boost::static_pointer_cast<SmackProcessLabelError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SmackProcessLabelCallbackIF*) _callback)->onSmackProcessLabelError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SmackProcessLabelUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SmackProcessLabel", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SmackProcessLabelUpdate> payload = ::boost::static_pointer_cast<SmackProcessLabelUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SmackProcessLabelCallbackIF*) _callback)->onSmackProcessLabelUpdate(proxyShared, payload);
                        proxyShared->_smackProcessLabel = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_IgnoreSIGPIPE:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), IgnoreSIGPIPEError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "IgnoreSIGPIPE", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<IgnoreSIGPIPEError> payload = ::boost::static_pointer_cast<IgnoreSIGPIPEError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((IgnoreSIGPIPECallbackIF*) _callback)->onIgnoreSIGPIPEError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), IgnoreSIGPIPEUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "IgnoreSIGPIPE", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<IgnoreSIGPIPEUpdate> payload = ::boost::static_pointer_cast<IgnoreSIGPIPEUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((IgnoreSIGPIPECallbackIF*) _callback)->onIgnoreSIGPIPEUpdate(proxyShared, payload);
                        proxyShared->_ignoreSIGPIPE = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_NoNewPrivileges:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NoNewPrivilegesError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NoNewPrivileges", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NoNewPrivilegesError> payload = ::boost::static_pointer_cast<NoNewPrivilegesError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((NoNewPrivilegesCallbackIF*) _callback)->onNoNewPrivilegesError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NoNewPrivilegesUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NoNewPrivileges", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NoNewPrivilegesUpdate> payload = ::boost::static_pointer_cast<NoNewPrivilegesUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((NoNewPrivilegesCallbackIF*) _callback)->onNoNewPrivilegesUpdate(proxyShared, payload);
                        proxyShared->_noNewPrivileges = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_SystemCallFilter:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SystemCallFilterError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SystemCallFilter", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SystemCallFilterError> payload = ::boost::static_pointer_cast<SystemCallFilterError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SystemCallFilterCallbackIF*) _callback)->onSystemCallFilterError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SystemCallFilterUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SystemCallFilter", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SystemCallFilterUpdate> payload = ::boost::static_pointer_cast<SystemCallFilterUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SystemCallFilterCallbackIF*) _callback)->onSystemCallFilterUpdate(proxyShared, payload);
                        proxyShared->_systemCallFilter = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_SystemCallArchitectures:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SystemCallArchitecturesError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SystemCallArchitectures", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SystemCallArchitecturesError> payload = ::boost::static_pointer_cast<SystemCallArchitecturesError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SystemCallArchitecturesCallbackIF*) _callback)->onSystemCallArchitecturesError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SystemCallArchitecturesUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SystemCallArchitectures", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SystemCallArchitecturesUpdate> payload = ::boost::static_pointer_cast<SystemCallArchitecturesUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SystemCallArchitecturesCallbackIF*) _callback)->onSystemCallArchitecturesUpdate(proxyShared, payload);
                        proxyShared->_systemCallArchitectures = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_SystemCallErrorNumber:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SystemCallErrorNumberError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SystemCallErrorNumber", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SystemCallErrorNumberError> payload = ::boost::static_pointer_cast<SystemCallErrorNumberError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SystemCallErrorNumberCallbackIF*) _callback)->onSystemCallErrorNumberError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SystemCallErrorNumberUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SystemCallErrorNumber", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SystemCallErrorNumberUpdate> payload = ::boost::static_pointer_cast<SystemCallErrorNumberUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SystemCallErrorNumberCallbackIF*) _callback)->onSystemCallErrorNumberUpdate(proxyShared, payload);
                        proxyShared->_systemCallErrorNumber = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Personality:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PersonalityError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Personality", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PersonalityError> payload = ::boost::static_pointer_cast<PersonalityError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((PersonalityCallbackIF*) _callback)->onPersonalityError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PersonalityUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Personality", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PersonalityUpdate> payload = ::boost::static_pointer_cast<PersonalityUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((PersonalityCallbackIF*) _callback)->onPersonalityUpdate(proxyShared, payload);
                        proxyShared->_personality = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_RestrictAddressFamilies:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RestrictAddressFamiliesError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RestrictAddressFamilies", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RestrictAddressFamiliesError> payload = ::boost::static_pointer_cast<RestrictAddressFamiliesError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((RestrictAddressFamiliesCallbackIF*) _callback)->onRestrictAddressFamiliesError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RestrictAddressFamiliesUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RestrictAddressFamilies", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RestrictAddressFamiliesUpdate> payload = ::boost::static_pointer_cast<RestrictAddressFamiliesUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((RestrictAddressFamiliesCallbackIF*) _callback)->onRestrictAddressFamiliesUpdate(proxyShared, payload);
                        proxyShared->_restrictAddressFamilies = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_RuntimeDirectoryMode:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RuntimeDirectoryModeError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RuntimeDirectoryMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RuntimeDirectoryModeError> payload = ::boost::static_pointer_cast<RuntimeDirectoryModeError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((RuntimeDirectoryModeCallbackIF*) _callback)->onRuntimeDirectoryModeError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RuntimeDirectoryModeUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RuntimeDirectoryMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RuntimeDirectoryModeUpdate> payload = ::boost::static_pointer_cast<RuntimeDirectoryModeUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((RuntimeDirectoryModeCallbackIF*) _callback)->onRuntimeDirectoryModeUpdate(proxyShared, payload);
                        proxyShared->_runtimeDirectoryMode = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_RuntimeDirectory:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RuntimeDirectoryError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RuntimeDirectory", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RuntimeDirectoryError> payload = ::boost::static_pointer_cast<RuntimeDirectoryError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((RuntimeDirectoryCallbackIF*) _callback)->onRuntimeDirectoryError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RuntimeDirectoryUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RuntimeDirectory", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RuntimeDirectoryUpdate> payload = ::boost::static_pointer_cast<RuntimeDirectoryUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((RuntimeDirectoryCallbackIF*) _callback)->onRuntimeDirectoryUpdate(proxyShared, payload);
                        proxyShared->_runtimeDirectory = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_KillMode:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), KillModeError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "KillMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<KillModeError> payload = ::boost::static_pointer_cast<KillModeError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((KillModeCallbackIF*) _callback)->onKillModeError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), KillModeUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "KillMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<KillModeUpdate> payload = ::boost::static_pointer_cast<KillModeUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((KillModeCallbackIF*) _callback)->onKillModeUpdate(proxyShared, payload);
                        proxyShared->_killMode = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_KillSignal:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), KillSignalError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "KillSignal", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<KillSignalError> payload = ::boost::static_pointer_cast<KillSignalError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((KillSignalCallbackIF*) _callback)->onKillSignalError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), KillSignalUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "KillSignal", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<KillSignalUpdate> payload = ::boost::static_pointer_cast<KillSignalUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((KillSignalCallbackIF*) _callback)->onKillSignalUpdate(proxyShared, payload);
                        proxyShared->_killSignal = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_SendSIGKILL:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SendSIGKILLError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SendSIGKILL", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SendSIGKILLError> payload = ::boost::static_pointer_cast<SendSIGKILLError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SendSIGKILLCallbackIF*) _callback)->onSendSIGKILLError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SendSIGKILLUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SendSIGKILL", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SendSIGKILLUpdate> payload = ::boost::static_pointer_cast<SendSIGKILLUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SendSIGKILLCallbackIF*) _callback)->onSendSIGKILLUpdate(proxyShared, payload);
                        proxyShared->_sendSIGKILL = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_SendSIGHUP:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SendSIGHUPError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SendSIGHUP", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SendSIGHUPError> payload = ::boost::static_pointer_cast<SendSIGHUPError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SendSIGHUPCallbackIF*) _callback)->onSendSIGHUPError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SendSIGHUPUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SendSIGHUP", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SendSIGHUPUpdate> payload = ::boost::static_pointer_cast<SendSIGHUPUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SendSIGHUPCallbackIF*) _callback)->onSendSIGHUPUpdate(proxyShared, payload);
                        proxyShared->_sendSIGHUP = *payload.get();
                        return true;
                    }
                }
                break;
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_Type: {
                ::boost::shared_ptr< TypeError > payload = ::boost::shared_ptr< TypeError >
                (new TypeError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Type", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((TypeCallbackIF*) _callback)->onTypeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Restart: {
                ::boost::shared_ptr< RestartError > payload = ::boost::shared_ptr< RestartError >
                (new RestartError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Restart", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RestartCallbackIF*) _callback)->onRestartError (proxyShared,payload);
                return true;
            }
            break;
            case ID_PIDFile: {
                ::boost::shared_ptr< PIDFileError > payload = ::boost::shared_ptr< PIDFileError >
                (new PIDFileError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PIDFile", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PIDFileCallbackIF*) _callback)->onPIDFileError (proxyShared,payload);
                return true;
            }
            break;
            case ID_NotifyAccess: {
                ::boost::shared_ptr< NotifyAccessError > payload = ::boost::shared_ptr< NotifyAccessError >
                (new NotifyAccessError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "NotifyAccess", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((NotifyAccessCallbackIF*) _callback)->onNotifyAccessError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RestartUSec: {
                ::boost::shared_ptr< RestartUSecError > payload = ::boost::shared_ptr< RestartUSecError >
                (new RestartUSecError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RestartUSec", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RestartUSecCallbackIF*) _callback)->onRestartUSecError (proxyShared,payload);
                return true;
            }
            break;
            case ID_TimeoutStartUSec: {
                ::boost::shared_ptr< TimeoutStartUSecError > payload = ::boost::shared_ptr< TimeoutStartUSecError >
                (new TimeoutStartUSecError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "TimeoutStartUSec", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((TimeoutStartUSecCallbackIF*) _callback)->onTimeoutStartUSecError (proxyShared,payload);
                return true;
            }
            break;
            case ID_TimeoutStopUSec: {
                ::boost::shared_ptr< TimeoutStopUSecError > payload = ::boost::shared_ptr< TimeoutStopUSecError >
                (new TimeoutStopUSecError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "TimeoutStopUSec", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((TimeoutStopUSecCallbackIF*) _callback)->onTimeoutStopUSecError (proxyShared,payload);
                return true;
            }
            break;
            case ID_WatchdogUSec: {
                ::boost::shared_ptr< WatchdogUSecError > payload = ::boost::shared_ptr< WatchdogUSecError >
                (new WatchdogUSecError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "WatchdogUSec", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((WatchdogUSecCallbackIF*) _callback)->onWatchdogUSecError (proxyShared,payload);
                return true;
            }
            break;
            case ID_WatchdogTimestamp: {
                ::boost::shared_ptr< WatchdogTimestampError > payload = ::boost::shared_ptr< WatchdogTimestampError >
                (new WatchdogTimestampError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "WatchdogTimestamp", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((WatchdogTimestampCallbackIF*) _callback)->onWatchdogTimestampError (proxyShared,payload);
                return true;
            }
            break;
            case ID_WatchdogTimestampMonotonic: {
                ::boost::shared_ptr< WatchdogTimestampMonotonicError > payload = ::boost::shared_ptr< WatchdogTimestampMonotonicError >
                (new WatchdogTimestampMonotonicError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "WatchdogTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((WatchdogTimestampMonotonicCallbackIF*) _callback)->onWatchdogTimestampMonotonicError (proxyShared,payload);
                return true;
            }
            break;
            case ID_StartLimitInterval: {
                ::boost::shared_ptr< StartLimitIntervalError > payload = ::boost::shared_ptr< StartLimitIntervalError >
                (new StartLimitIntervalError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "StartLimitInterval", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StartLimitIntervalCallbackIF*) _callback)->onStartLimitIntervalError (proxyShared,payload);
                return true;
            }
            break;
            case ID_StartLimitBurst: {
                ::boost::shared_ptr< StartLimitBurstError > payload = ::boost::shared_ptr< StartLimitBurstError >
                (new StartLimitBurstError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "StartLimitBurst", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StartLimitBurstCallbackIF*) _callback)->onStartLimitBurstError (proxyShared,payload);
                return true;
            }
            break;
            case ID_StartLimitAction: {
                ::boost::shared_ptr< StartLimitActionError > payload = ::boost::shared_ptr< StartLimitActionError >
                (new StartLimitActionError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "StartLimitAction", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StartLimitActionCallbackIF*) _callback)->onStartLimitActionError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RebootArgument: {
                ::boost::shared_ptr< RebootArgumentError > payload = ::boost::shared_ptr< RebootArgumentError >
                (new RebootArgumentError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RebootArgument", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RebootArgumentCallbackIF*) _callback)->onRebootArgumentError (proxyShared,payload);
                return true;
            }
            break;
            case ID_FailureAction: {
                ::boost::shared_ptr< FailureActionError > payload = ::boost::shared_ptr< FailureActionError >
                (new FailureActionError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "FailureAction", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((FailureActionCallbackIF*) _callback)->onFailureActionError (proxyShared,payload);
                return true;
            }
            break;
            case ID_PermissionsStartOnly: {
                ::boost::shared_ptr< PermissionsStartOnlyError > payload = ::boost::shared_ptr< PermissionsStartOnlyError >
                (new PermissionsStartOnlyError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PermissionsStartOnly", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PermissionsStartOnlyCallbackIF*) _callback)->onPermissionsStartOnlyError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RootDirectoryStartOnly: {
                ::boost::shared_ptr< RootDirectoryStartOnlyError > payload = ::boost::shared_ptr< RootDirectoryStartOnlyError >
                (new RootDirectoryStartOnlyError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RootDirectoryStartOnly", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RootDirectoryStartOnlyCallbackIF*) _callback)->onRootDirectoryStartOnlyError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RemainAfterExit: {
                ::boost::shared_ptr< RemainAfterExitError > payload = ::boost::shared_ptr< RemainAfterExitError >
                (new RemainAfterExitError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RemainAfterExit", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RemainAfterExitCallbackIF*) _callback)->onRemainAfterExitError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GuessMainPID: {
                ::boost::shared_ptr< GuessMainPIDError > payload = ::boost::shared_ptr< GuessMainPIDError >
                (new GuessMainPIDError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GuessMainPID", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GuessMainPIDCallbackIF*) _callback)->onGuessMainPIDError (proxyShared,payload);
                return true;
            }
            break;
            case ID_MainPID: {
                ::boost::shared_ptr< MainPIDError > payload = ::boost::shared_ptr< MainPIDError >
                (new MainPIDError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "MainPID", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((MainPIDCallbackIF*) _callback)->onMainPIDError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ControlPID: {
                ::boost::shared_ptr< ControlPIDError > payload = ::boost::shared_ptr< ControlPIDError >
                (new ControlPIDError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ControlPID", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ControlPIDCallbackIF*) _callback)->onControlPIDError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BusName: {
                ::boost::shared_ptr< BusNameError > payload = ::boost::shared_ptr< BusNameError >
                (new BusNameError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BusName", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BusNameCallbackIF*) _callback)->onBusNameError (proxyShared,payload);
                return true;
            }
            break;
            case ID_FileDescriptorStoreMax: {
                ::boost::shared_ptr< FileDescriptorStoreMaxError > payload = ::boost::shared_ptr< FileDescriptorStoreMaxError >
                (new FileDescriptorStoreMaxError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "FileDescriptorStoreMax", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((FileDescriptorStoreMaxCallbackIF*) _callback)->onFileDescriptorStoreMaxError (proxyShared,payload);
                return true;
            }
            break;
            case ID_StatusText: {
                ::boost::shared_ptr< StatusTextError > payload = ::boost::shared_ptr< StatusTextError >
                (new StatusTextError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "StatusText", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StatusTextCallbackIF*) _callback)->onStatusTextError (proxyShared,payload);
                return true;
            }
            break;
            case ID_StatusErrno: {
                ::boost::shared_ptr< StatusErrnoError > payload = ::boost::shared_ptr< StatusErrnoError >
                (new StatusErrnoError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "StatusErrno", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StatusErrnoCallbackIF*) _callback)->onStatusErrnoError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Result: {
                ::boost::shared_ptr< ResultError > payload = ::boost::shared_ptr< ResultError >
                (new ResultError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Result", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ResultCallbackIF*) _callback)->onResultError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ExecMainStartTimestamp: {
                ::boost::shared_ptr< ExecMainStartTimestampError > payload = ::boost::shared_ptr< ExecMainStartTimestampError >
                (new ExecMainStartTimestampError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ExecMainStartTimestamp", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ExecMainStartTimestampCallbackIF*) _callback)->onExecMainStartTimestampError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ExecMainStartTimestampMonotonic: {
                ::boost::shared_ptr< ExecMainStartTimestampMonotonicError > payload = ::boost::shared_ptr< ExecMainStartTimestampMonotonicError >
                (new ExecMainStartTimestampMonotonicError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ExecMainStartTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ExecMainStartTimestampMonotonicCallbackIF*) _callback)->onExecMainStartTimestampMonotonicError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ExecMainExitTimestamp: {
                ::boost::shared_ptr< ExecMainExitTimestampError > payload = ::boost::shared_ptr< ExecMainExitTimestampError >
                (new ExecMainExitTimestampError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ExecMainExitTimestamp", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ExecMainExitTimestampCallbackIF*) _callback)->onExecMainExitTimestampError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ExecMainExitTimestampMonotonic: {
                ::boost::shared_ptr< ExecMainExitTimestampMonotonicError > payload = ::boost::shared_ptr< ExecMainExitTimestampMonotonicError >
                (new ExecMainExitTimestampMonotonicError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ExecMainExitTimestampMonotonic", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ExecMainExitTimestampMonotonicCallbackIF*) _callback)->onExecMainExitTimestampMonotonicError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ExecMainPID: {
                ::boost::shared_ptr< ExecMainPIDError > payload = ::boost::shared_ptr< ExecMainPIDError >
                (new ExecMainPIDError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ExecMainPID", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ExecMainPIDCallbackIF*) _callback)->onExecMainPIDError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ExecMainCode: {
                ::boost::shared_ptr< ExecMainCodeError > payload = ::boost::shared_ptr< ExecMainCodeError >
                (new ExecMainCodeError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ExecMainCode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ExecMainCodeCallbackIF*) _callback)->onExecMainCodeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ExecMainStatus: {
                ::boost::shared_ptr< ExecMainStatusError > payload = ::boost::shared_ptr< ExecMainStatusError >
                (new ExecMainStatusError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ExecMainStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ExecMainStatusCallbackIF*) _callback)->onExecMainStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ExecStartPre: {
                ::boost::shared_ptr< ExecStartPreError > payload = ::boost::shared_ptr< ExecStartPreError >
                (new ExecStartPreError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ExecStartPre", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ExecStartPreCallbackIF*) _callback)->onExecStartPreError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ExecStart: {
                ::boost::shared_ptr< ExecStartError > payload = ::boost::shared_ptr< ExecStartError >
                (new ExecStartError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ExecStart", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ExecStartCallbackIF*) _callback)->onExecStartError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ExecStartPost: {
                ::boost::shared_ptr< ExecStartPostError > payload = ::boost::shared_ptr< ExecStartPostError >
                (new ExecStartPostError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ExecStartPost", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ExecStartPostCallbackIF*) _callback)->onExecStartPostError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ExecReload: {
                ::boost::shared_ptr< ExecReloadError > payload = ::boost::shared_ptr< ExecReloadError >
                (new ExecReloadError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ExecReload", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ExecReloadCallbackIF*) _callback)->onExecReloadError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ExecStop: {
                ::boost::shared_ptr< ExecStopError > payload = ::boost::shared_ptr< ExecStopError >
                (new ExecStopError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ExecStop", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ExecStopCallbackIF*) _callback)->onExecStopError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ExecStopPost: {
                ::boost::shared_ptr< ExecStopPostError > payload = ::boost::shared_ptr< ExecStopPostError >
                (new ExecStopPostError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ExecStopPost", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ExecStopPostCallbackIF*) _callback)->onExecStopPostError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Slice: {
                ::boost::shared_ptr< SliceError > payload = ::boost::shared_ptr< SliceError >
                (new SliceError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Slice", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SliceCallbackIF*) _callback)->onSliceError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ControlGroup: {
                ::boost::shared_ptr< ControlGroupError > payload = ::boost::shared_ptr< ControlGroupError >
                (new ControlGroupError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ControlGroup", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ControlGroupCallbackIF*) _callback)->onControlGroupError (proxyShared,payload);
                return true;
            }
            break;
            case ID_MemoryCurrent: {
                ::boost::shared_ptr< MemoryCurrentError > payload = ::boost::shared_ptr< MemoryCurrentError >
                (new MemoryCurrentError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "MemoryCurrent", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((MemoryCurrentCallbackIF*) _callback)->onMemoryCurrentError (proxyShared,payload);
                return true;
            }
            break;
            case ID_CPUUsageNSec: {
                ::boost::shared_ptr< CPUUsageNSecError > payload = ::boost::shared_ptr< CPUUsageNSecError >
                (new CPUUsageNSecError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CPUUsageNSec", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CPUUsageNSecCallbackIF*) _callback)->onCPUUsageNSecError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Delegate: {
                ::boost::shared_ptr< DelegateError > payload = ::boost::shared_ptr< DelegateError >
                (new DelegateError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Delegate", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DelegateCallbackIF*) _callback)->onDelegateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_CPUAccounting: {
                ::boost::shared_ptr< CPUAccountingError > payload = ::boost::shared_ptr< CPUAccountingError >
                (new CPUAccountingError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CPUAccounting", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CPUAccountingCallbackIF*) _callback)->onCPUAccountingError (proxyShared,payload);
                return true;
            }
            break;
            case ID_CPUShares: {
                ::boost::shared_ptr< CPUSharesError > payload = ::boost::shared_ptr< CPUSharesError >
                (new CPUSharesError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CPUShares", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CPUSharesCallbackIF*) _callback)->onCPUSharesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_StartupCPUShares: {
                ::boost::shared_ptr< StartupCPUSharesError > payload = ::boost::shared_ptr< StartupCPUSharesError >
                (new StartupCPUSharesError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "StartupCPUShares", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StartupCPUSharesCallbackIF*) _callback)->onStartupCPUSharesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_CPUQuotaPerSecUSec: {
                ::boost::shared_ptr< CPUQuotaPerSecUSecError > payload = ::boost::shared_ptr< CPUQuotaPerSecUSecError >
                (new CPUQuotaPerSecUSecError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CPUQuotaPerSecUSec", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CPUQuotaPerSecUSecCallbackIF*) _callback)->onCPUQuotaPerSecUSecError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BlockIOAccounting: {
                ::boost::shared_ptr< BlockIOAccountingError > payload = ::boost::shared_ptr< BlockIOAccountingError >
                (new BlockIOAccountingError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BlockIOAccounting", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BlockIOAccountingCallbackIF*) _callback)->onBlockIOAccountingError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BlockIOWeight: {
                ::boost::shared_ptr< BlockIOWeightError > payload = ::boost::shared_ptr< BlockIOWeightError >
                (new BlockIOWeightError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BlockIOWeight", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BlockIOWeightCallbackIF*) _callback)->onBlockIOWeightError (proxyShared,payload);
                return true;
            }
            break;
            case ID_StartupBlockIOWeight: {
                ::boost::shared_ptr< StartupBlockIOWeightError > payload = ::boost::shared_ptr< StartupBlockIOWeightError >
                (new StartupBlockIOWeightError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "StartupBlockIOWeight", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StartupBlockIOWeightCallbackIF*) _callback)->onStartupBlockIOWeightError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BlockIODeviceWeight: {
                ::boost::shared_ptr< BlockIODeviceWeightError > payload = ::boost::shared_ptr< BlockIODeviceWeightError >
                (new BlockIODeviceWeightError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BlockIODeviceWeight", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BlockIODeviceWeightCallbackIF*) _callback)->onBlockIODeviceWeightError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BlockIOReadBandwidth: {
                ::boost::shared_ptr< BlockIOReadBandwidthError > payload = ::boost::shared_ptr< BlockIOReadBandwidthError >
                (new BlockIOReadBandwidthError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BlockIOReadBandwidth", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BlockIOReadBandwidthCallbackIF*) _callback)->onBlockIOReadBandwidthError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BlockIOWriteBandwidth: {
                ::boost::shared_ptr< BlockIOWriteBandwidthError > payload = ::boost::shared_ptr< BlockIOWriteBandwidthError >
                (new BlockIOWriteBandwidthError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BlockIOWriteBandwidth", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BlockIOWriteBandwidthCallbackIF*) _callback)->onBlockIOWriteBandwidthError (proxyShared,payload);
                return true;
            }
            break;
            case ID_MemoryAccounting: {
                ::boost::shared_ptr< MemoryAccountingError > payload = ::boost::shared_ptr< MemoryAccountingError >
                (new MemoryAccountingError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "MemoryAccounting", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((MemoryAccountingCallbackIF*) _callback)->onMemoryAccountingError (proxyShared,payload);
                return true;
            }
            break;
            case ID_MemoryLimit: {
                ::boost::shared_ptr< MemoryLimitError > payload = ::boost::shared_ptr< MemoryLimitError >
                (new MemoryLimitError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "MemoryLimit", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((MemoryLimitCallbackIF*) _callback)->onMemoryLimitError (proxyShared,payload);
                return true;
            }
            break;
            case ID_DevicePolicy: {
                ::boost::shared_ptr< DevicePolicyError > payload = ::boost::shared_ptr< DevicePolicyError >
                (new DevicePolicyError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DevicePolicy", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DevicePolicyCallbackIF*) _callback)->onDevicePolicyError (proxyShared,payload);
                return true;
            }
            break;
            case ID_DeviceAllow: {
                ::boost::shared_ptr< DeviceAllowError > payload = ::boost::shared_ptr< DeviceAllowError >
                (new DeviceAllowError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DeviceAllow", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DeviceAllowCallbackIF*) _callback)->onDeviceAllowError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Environment: {
                ::boost::shared_ptr< EnvironmentError > payload = ::boost::shared_ptr< EnvironmentError >
                (new EnvironmentError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Environment", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EnvironmentCallbackIF*) _callback)->onEnvironmentError (proxyShared,payload);
                return true;
            }
            break;
            case ID_EnvironmentFiles: {
                ::boost::shared_ptr< EnvironmentFilesError > payload = ::boost::shared_ptr< EnvironmentFilesError >
                (new EnvironmentFilesError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EnvironmentFiles", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EnvironmentFilesCallbackIF*) _callback)->onEnvironmentFilesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_UMask: {
                ::boost::shared_ptr< UMaskError > payload = ::boost::shared_ptr< UMaskError >
                (new UMaskError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UMask", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UMaskCallbackIF*) _callback)->onUMaskError (proxyShared,payload);
                return true;
            }
            break;
            case ID_LimitCPU: {
                ::boost::shared_ptr< LimitCPUError > payload = ::boost::shared_ptr< LimitCPUError >
                (new LimitCPUError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "LimitCPU", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((LimitCPUCallbackIF*) _callback)->onLimitCPUError (proxyShared,payload);
                return true;
            }
            break;
            case ID_LimitFSIZE: {
                ::boost::shared_ptr< LimitFSIZEError > payload = ::boost::shared_ptr< LimitFSIZEError >
                (new LimitFSIZEError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "LimitFSIZE", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((LimitFSIZECallbackIF*) _callback)->onLimitFSIZEError (proxyShared,payload);
                return true;
            }
            break;
            case ID_LimitDATA: {
                ::boost::shared_ptr< LimitDATAError > payload = ::boost::shared_ptr< LimitDATAError >
                (new LimitDATAError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "LimitDATA", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((LimitDATACallbackIF*) _callback)->onLimitDATAError (proxyShared,payload);
                return true;
            }
            break;
            case ID_LimitSTACK: {
                ::boost::shared_ptr< LimitSTACKError > payload = ::boost::shared_ptr< LimitSTACKError >
                (new LimitSTACKError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "LimitSTACK", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((LimitSTACKCallbackIF*) _callback)->onLimitSTACKError (proxyShared,payload);
                return true;
            }
            break;
            case ID_LimitCORE: {
                ::boost::shared_ptr< LimitCOREError > payload = ::boost::shared_ptr< LimitCOREError >
                (new LimitCOREError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "LimitCORE", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((LimitCORECallbackIF*) _callback)->onLimitCOREError (proxyShared,payload);
                return true;
            }
            break;
            case ID_LimitRSS: {
                ::boost::shared_ptr< LimitRSSError > payload = ::boost::shared_ptr< LimitRSSError >
                (new LimitRSSError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "LimitRSS", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((LimitRSSCallbackIF*) _callback)->onLimitRSSError (proxyShared,payload);
                return true;
            }
            break;
            case ID_LimitNOFILE: {
                ::boost::shared_ptr< LimitNOFILEError > payload = ::boost::shared_ptr< LimitNOFILEError >
                (new LimitNOFILEError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "LimitNOFILE", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((LimitNOFILECallbackIF*) _callback)->onLimitNOFILEError (proxyShared,payload);
                return true;
            }
            break;
            case ID_LimitAS: {
                ::boost::shared_ptr< LimitASError > payload = ::boost::shared_ptr< LimitASError >
                (new LimitASError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "LimitAS", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((LimitASCallbackIF*) _callback)->onLimitASError (proxyShared,payload);
                return true;
            }
            break;
            case ID_LimitNPROC: {
                ::boost::shared_ptr< LimitNPROCError > payload = ::boost::shared_ptr< LimitNPROCError >
                (new LimitNPROCError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "LimitNPROC", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((LimitNPROCCallbackIF*) _callback)->onLimitNPROCError (proxyShared,payload);
                return true;
            }
            break;
            case ID_LimitMEMLOCK: {
                ::boost::shared_ptr< LimitMEMLOCKError > payload = ::boost::shared_ptr< LimitMEMLOCKError >
                (new LimitMEMLOCKError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "LimitMEMLOCK", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((LimitMEMLOCKCallbackIF*) _callback)->onLimitMEMLOCKError (proxyShared,payload);
                return true;
            }
            break;
            case ID_LimitLOCKS: {
                ::boost::shared_ptr< LimitLOCKSError > payload = ::boost::shared_ptr< LimitLOCKSError >
                (new LimitLOCKSError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "LimitLOCKS", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((LimitLOCKSCallbackIF*) _callback)->onLimitLOCKSError (proxyShared,payload);
                return true;
            }
            break;
            case ID_LimitSIGPENDING: {
                ::boost::shared_ptr< LimitSIGPENDINGError > payload = ::boost::shared_ptr< LimitSIGPENDINGError >
                (new LimitSIGPENDINGError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "LimitSIGPENDING", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((LimitSIGPENDINGCallbackIF*) _callback)->onLimitSIGPENDINGError (proxyShared,payload);
                return true;
            }
            break;
            case ID_LimitMSGQUEUE: {
                ::boost::shared_ptr< LimitMSGQUEUEError > payload = ::boost::shared_ptr< LimitMSGQUEUEError >
                (new LimitMSGQUEUEError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "LimitMSGQUEUE", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((LimitMSGQUEUECallbackIF*) _callback)->onLimitMSGQUEUEError (proxyShared,payload);
                return true;
            }
            break;
            case ID_LimitNICE: {
                ::boost::shared_ptr< LimitNICEError > payload = ::boost::shared_ptr< LimitNICEError >
                (new LimitNICEError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "LimitNICE", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((LimitNICECallbackIF*) _callback)->onLimitNICEError (proxyShared,payload);
                return true;
            }
            break;
            case ID_LimitRTPRIO: {
                ::boost::shared_ptr< LimitRTPRIOError > payload = ::boost::shared_ptr< LimitRTPRIOError >
                (new LimitRTPRIOError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "LimitRTPRIO", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((LimitRTPRIOCallbackIF*) _callback)->onLimitRTPRIOError (proxyShared,payload);
                return true;
            }
            break;
            case ID_LimitRTTIME: {
                ::boost::shared_ptr< LimitRTTIMEError > payload = ::boost::shared_ptr< LimitRTTIMEError >
                (new LimitRTTIMEError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "LimitRTTIME", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((LimitRTTIMECallbackIF*) _callback)->onLimitRTTIMEError (proxyShared,payload);
                return true;
            }
            break;
            case ID_WorkingDirectory: {
                ::boost::shared_ptr< WorkingDirectoryError > payload = ::boost::shared_ptr< WorkingDirectoryError >
                (new WorkingDirectoryError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "WorkingDirectory", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((WorkingDirectoryCallbackIF*) _callback)->onWorkingDirectoryError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RootDirectory: {
                ::boost::shared_ptr< RootDirectoryError > payload = ::boost::shared_ptr< RootDirectoryError >
                (new RootDirectoryError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RootDirectory", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RootDirectoryCallbackIF*) _callback)->onRootDirectoryError (proxyShared,payload);
                return true;
            }
            break;
            case ID_OOMScoreAdjust: {
                ::boost::shared_ptr< OOMScoreAdjustError > payload = ::boost::shared_ptr< OOMScoreAdjustError >
                (new OOMScoreAdjustError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "OOMScoreAdjust", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((OOMScoreAdjustCallbackIF*) _callback)->onOOMScoreAdjustError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Nice: {
                ::boost::shared_ptr< NiceError > payload = ::boost::shared_ptr< NiceError >
                (new NiceError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Nice", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((NiceCallbackIF*) _callback)->onNiceError (proxyShared,payload);
                return true;
            }
            break;
            case ID_IOScheduling: {
                ::boost::shared_ptr< IOSchedulingError > payload = ::boost::shared_ptr< IOSchedulingError >
                (new IOSchedulingError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "IOScheduling", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((IOSchedulingCallbackIF*) _callback)->onIOSchedulingError (proxyShared,payload);
                return true;
            }
            break;
            case ID_CPUSchedulingPolicy: {
                ::boost::shared_ptr< CPUSchedulingPolicyError > payload = ::boost::shared_ptr< CPUSchedulingPolicyError >
                (new CPUSchedulingPolicyError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CPUSchedulingPolicy", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CPUSchedulingPolicyCallbackIF*) _callback)->onCPUSchedulingPolicyError (proxyShared,payload);
                return true;
            }
            break;
            case ID_CPUSchedulingPriority: {
                ::boost::shared_ptr< CPUSchedulingPriorityError > payload = ::boost::shared_ptr< CPUSchedulingPriorityError >
                (new CPUSchedulingPriorityError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CPUSchedulingPriority", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CPUSchedulingPriorityCallbackIF*) _callback)->onCPUSchedulingPriorityError (proxyShared,payload);
                return true;
            }
            break;
            case ID_CPUAffinity: {
                ::boost::shared_ptr< CPUAffinityError > payload = ::boost::shared_ptr< CPUAffinityError >
                (new CPUAffinityError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CPUAffinity", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CPUAffinityCallbackIF*) _callback)->onCPUAffinityError (proxyShared,payload);
                return true;
            }
            break;
            case ID_TimerSlackNSec: {
                ::boost::shared_ptr< TimerSlackNSecError > payload = ::boost::shared_ptr< TimerSlackNSecError >
                (new TimerSlackNSecError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "TimerSlackNSec", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((TimerSlackNSecCallbackIF*) _callback)->onTimerSlackNSecError (proxyShared,payload);
                return true;
            }
            break;
            case ID_CPUSchedulingResetOnFork: {
                ::boost::shared_ptr< CPUSchedulingResetOnForkError > payload = ::boost::shared_ptr< CPUSchedulingResetOnForkError >
                (new CPUSchedulingResetOnForkError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CPUSchedulingResetOnFork", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CPUSchedulingResetOnForkCallbackIF*) _callback)->onCPUSchedulingResetOnForkError (proxyShared,payload);
                return true;
            }
            break;
            case ID_NonBlocking: {
                ::boost::shared_ptr< NonBlockingError > payload = ::boost::shared_ptr< NonBlockingError >
                (new NonBlockingError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "NonBlocking", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((NonBlockingCallbackIF*) _callback)->onNonBlockingError (proxyShared,payload);
                return true;
            }
            break;
            case ID_StandardInput: {
                ::boost::shared_ptr< StandardInputError > payload = ::boost::shared_ptr< StandardInputError >
                (new StandardInputError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "StandardInput", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StandardInputCallbackIF*) _callback)->onStandardInputError (proxyShared,payload);
                return true;
            }
            break;
            case ID_StandardOutput: {
                ::boost::shared_ptr< StandardOutputError > payload = ::boost::shared_ptr< StandardOutputError >
                (new StandardOutputError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "StandardOutput", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StandardOutputCallbackIF*) _callback)->onStandardOutputError (proxyShared,payload);
                return true;
            }
            break;
            case ID_StandardError: {
                ::boost::shared_ptr< StandardErrorError > payload = ::boost::shared_ptr< StandardErrorError >
                (new StandardErrorError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "StandardError", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StandardErrorCallbackIF*) _callback)->onStandardErrorError (proxyShared,payload);
                return true;
            }
            break;
            case ID_TTYPath: {
                ::boost::shared_ptr< TTYPathError > payload = ::boost::shared_ptr< TTYPathError >
                (new TTYPathError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "TTYPath", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((TTYPathCallbackIF*) _callback)->onTTYPathError (proxyShared,payload);
                return true;
            }
            break;
            case ID_TTYReset: {
                ::boost::shared_ptr< TTYResetError > payload = ::boost::shared_ptr< TTYResetError >
                (new TTYResetError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "TTYReset", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((TTYResetCallbackIF*) _callback)->onTTYResetError (proxyShared,payload);
                return true;
            }
            break;
            case ID_TTYVHangup: {
                ::boost::shared_ptr< TTYVHangupError > payload = ::boost::shared_ptr< TTYVHangupError >
                (new TTYVHangupError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "TTYVHangup", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((TTYVHangupCallbackIF*) _callback)->onTTYVHangupError (proxyShared,payload);
                return true;
            }
            break;
            case ID_TTYVTDisallocate: {
                ::boost::shared_ptr< TTYVTDisallocateError > payload = ::boost::shared_ptr< TTYVTDisallocateError >
                (new TTYVTDisallocateError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "TTYVTDisallocate", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((TTYVTDisallocateCallbackIF*) _callback)->onTTYVTDisallocateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SyslogPriority: {
                ::boost::shared_ptr< SyslogPriorityError > payload = ::boost::shared_ptr< SyslogPriorityError >
                (new SyslogPriorityError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SyslogPriority", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SyslogPriorityCallbackIF*) _callback)->onSyslogPriorityError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SyslogIdentifier: {
                ::boost::shared_ptr< SyslogIdentifierError > payload = ::boost::shared_ptr< SyslogIdentifierError >
                (new SyslogIdentifierError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SyslogIdentifier", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SyslogIdentifierCallbackIF*) _callback)->onSyslogIdentifierError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SyslogLevelPrefix: {
                ::boost::shared_ptr< SyslogLevelPrefixError > payload = ::boost::shared_ptr< SyslogLevelPrefixError >
                (new SyslogLevelPrefixError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SyslogLevelPrefix", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SyslogLevelPrefixCallbackIF*) _callback)->onSyslogLevelPrefixError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Capabilities: {
                ::boost::shared_ptr< CapabilitiesError > payload = ::boost::shared_ptr< CapabilitiesError >
                (new CapabilitiesError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Capabilities", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CapabilitiesCallbackIF*) _callback)->onCapabilitiesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SecureBits: {
                ::boost::shared_ptr< SecureBitsError > payload = ::boost::shared_ptr< SecureBitsError >
                (new SecureBitsError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SecureBits", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SecureBitsCallbackIF*) _callback)->onSecureBitsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_CapabilityBoundingSet: {
                ::boost::shared_ptr< CapabilityBoundingSetError > payload = ::boost::shared_ptr< CapabilityBoundingSetError >
                (new CapabilityBoundingSetError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CapabilityBoundingSet", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CapabilityBoundingSetCallbackIF*) _callback)->onCapabilityBoundingSetError (proxyShared,payload);
                return true;
            }
            break;
            case ID_User: {
                ::boost::shared_ptr< UserError > payload = ::boost::shared_ptr< UserError >
                (new UserError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "User", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UserCallbackIF*) _callback)->onUserError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Group: {
                ::boost::shared_ptr< GroupError > payload = ::boost::shared_ptr< GroupError >
                (new GroupError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Group", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GroupCallbackIF*) _callback)->onGroupError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SupplementaryGroups: {
                ::boost::shared_ptr< SupplementaryGroupsError > payload = ::boost::shared_ptr< SupplementaryGroupsError >
                (new SupplementaryGroupsError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SupplementaryGroups", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SupplementaryGroupsCallbackIF*) _callback)->onSupplementaryGroupsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_PAMName: {
                ::boost::shared_ptr< PAMNameError > payload = ::boost::shared_ptr< PAMNameError >
                (new PAMNameError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PAMName", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PAMNameCallbackIF*) _callback)->onPAMNameError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ReadWriteDirectories: {
                ::boost::shared_ptr< ReadWriteDirectoriesError > payload = ::boost::shared_ptr< ReadWriteDirectoriesError >
                (new ReadWriteDirectoriesError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ReadWriteDirectories", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReadWriteDirectoriesCallbackIF*) _callback)->onReadWriteDirectoriesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ReadOnlyDirectories: {
                ::boost::shared_ptr< ReadOnlyDirectoriesError > payload = ::boost::shared_ptr< ReadOnlyDirectoriesError >
                (new ReadOnlyDirectoriesError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ReadOnlyDirectories", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReadOnlyDirectoriesCallbackIF*) _callback)->onReadOnlyDirectoriesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_InaccessibleDirectories: {
                ::boost::shared_ptr< InaccessibleDirectoriesError > payload = ::boost::shared_ptr< InaccessibleDirectoriesError >
                (new InaccessibleDirectoriesError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "InaccessibleDirectories", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((InaccessibleDirectoriesCallbackIF*) _callback)->onInaccessibleDirectoriesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_MountFlags: {
                ::boost::shared_ptr< MountFlagsError > payload = ::boost::shared_ptr< MountFlagsError >
                (new MountFlagsError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "MountFlags", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((MountFlagsCallbackIF*) _callback)->onMountFlagsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_PrivateTmp: {
                ::boost::shared_ptr< PrivateTmpError > payload = ::boost::shared_ptr< PrivateTmpError >
                (new PrivateTmpError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PrivateTmp", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PrivateTmpCallbackIF*) _callback)->onPrivateTmpError (proxyShared,payload);
                return true;
            }
            break;
            case ID_PrivateNetwork: {
                ::boost::shared_ptr< PrivateNetworkError > payload = ::boost::shared_ptr< PrivateNetworkError >
                (new PrivateNetworkError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PrivateNetwork", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PrivateNetworkCallbackIF*) _callback)->onPrivateNetworkError (proxyShared,payload);
                return true;
            }
            break;
            case ID_PrivateDevices: {
                ::boost::shared_ptr< PrivateDevicesError > payload = ::boost::shared_ptr< PrivateDevicesError >
                (new PrivateDevicesError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PrivateDevices", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PrivateDevicesCallbackIF*) _callback)->onPrivateDevicesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ProtectHome: {
                ::boost::shared_ptr< ProtectHomeError > payload = ::boost::shared_ptr< ProtectHomeError >
                (new ProtectHomeError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ProtectHome", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ProtectHomeCallbackIF*) _callback)->onProtectHomeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ProtectSystem: {
                ::boost::shared_ptr< ProtectSystemError > payload = ::boost::shared_ptr< ProtectSystemError >
                (new ProtectSystemError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ProtectSystem", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ProtectSystemCallbackIF*) _callback)->onProtectSystemError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SameProcessGroup: {
                ::boost::shared_ptr< SameProcessGroupError > payload = ::boost::shared_ptr< SameProcessGroupError >
                (new SameProcessGroupError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SameProcessGroup", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SameProcessGroupCallbackIF*) _callback)->onSameProcessGroupError (proxyShared,payload);
                return true;
            }
            break;
            case ID_UtmpIdentifier: {
                ::boost::shared_ptr< UtmpIdentifierError > payload = ::boost::shared_ptr< UtmpIdentifierError >
                (new UtmpIdentifierError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UtmpIdentifier", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UtmpIdentifierCallbackIF*) _callback)->onUtmpIdentifierError (proxyShared,payload);
                return true;
            }
            break;
            case ID_UtmpMode: {
                ::boost::shared_ptr< UtmpModeError > payload = ::boost::shared_ptr< UtmpModeError >
                (new UtmpModeError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UtmpMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UtmpModeCallbackIF*) _callback)->onUtmpModeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SELinuxContext: {
                ::boost::shared_ptr< SELinuxContextError > payload = ::boost::shared_ptr< SELinuxContextError >
                (new SELinuxContextError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SELinuxContext", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SELinuxContextCallbackIF*) _callback)->onSELinuxContextError (proxyShared,payload);
                return true;
            }
            break;
            case ID_AppArmorProfile: {
                ::boost::shared_ptr< AppArmorProfileError > payload = ::boost::shared_ptr< AppArmorProfileError >
                (new AppArmorProfileError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AppArmorProfile", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AppArmorProfileCallbackIF*) _callback)->onAppArmorProfileError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SmackProcessLabel: {
                ::boost::shared_ptr< SmackProcessLabelError > payload = ::boost::shared_ptr< SmackProcessLabelError >
                (new SmackProcessLabelError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SmackProcessLabel", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SmackProcessLabelCallbackIF*) _callback)->onSmackProcessLabelError (proxyShared,payload);
                return true;
            }
            break;
            case ID_IgnoreSIGPIPE: {
                ::boost::shared_ptr< IgnoreSIGPIPEError > payload = ::boost::shared_ptr< IgnoreSIGPIPEError >
                (new IgnoreSIGPIPEError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "IgnoreSIGPIPE", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((IgnoreSIGPIPECallbackIF*) _callback)->onIgnoreSIGPIPEError (proxyShared,payload);
                return true;
            }
            break;
            case ID_NoNewPrivileges: {
                ::boost::shared_ptr< NoNewPrivilegesError > payload = ::boost::shared_ptr< NoNewPrivilegesError >
                (new NoNewPrivilegesError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "NoNewPrivileges", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((NoNewPrivilegesCallbackIF*) _callback)->onNoNewPrivilegesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SystemCallFilter: {
                ::boost::shared_ptr< SystemCallFilterError > payload = ::boost::shared_ptr< SystemCallFilterError >
                (new SystemCallFilterError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SystemCallFilter", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SystemCallFilterCallbackIF*) _callback)->onSystemCallFilterError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SystemCallArchitectures: {
                ::boost::shared_ptr< SystemCallArchitecturesError > payload = ::boost::shared_ptr< SystemCallArchitecturesError >
                (new SystemCallArchitecturesError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SystemCallArchitectures", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SystemCallArchitecturesCallbackIF*) _callback)->onSystemCallArchitecturesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SystemCallErrorNumber: {
                ::boost::shared_ptr< SystemCallErrorNumberError > payload = ::boost::shared_ptr< SystemCallErrorNumberError >
                (new SystemCallErrorNumberError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SystemCallErrorNumber", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SystemCallErrorNumberCallbackIF*) _callback)->onSystemCallErrorNumberError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Personality: {
                ::boost::shared_ptr< PersonalityError > payload = ::boost::shared_ptr< PersonalityError >
                (new PersonalityError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Personality", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PersonalityCallbackIF*) _callback)->onPersonalityError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RestrictAddressFamilies: {
                ::boost::shared_ptr< RestrictAddressFamiliesError > payload = ::boost::shared_ptr< RestrictAddressFamiliesError >
                (new RestrictAddressFamiliesError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RestrictAddressFamilies", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RestrictAddressFamiliesCallbackIF*) _callback)->onRestrictAddressFamiliesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RuntimeDirectoryMode: {
                ::boost::shared_ptr< RuntimeDirectoryModeError > payload = ::boost::shared_ptr< RuntimeDirectoryModeError >
                (new RuntimeDirectoryModeError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RuntimeDirectoryMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RuntimeDirectoryModeCallbackIF*) _callback)->onRuntimeDirectoryModeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RuntimeDirectory: {
                ::boost::shared_ptr< RuntimeDirectoryError > payload = ::boost::shared_ptr< RuntimeDirectoryError >
                (new RuntimeDirectoryError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RuntimeDirectory", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RuntimeDirectoryCallbackIF*) _callback)->onRuntimeDirectoryError (proxyShared,payload);
                return true;
            }
            break;
            case ID_KillMode: {
                ::boost::shared_ptr< KillModeError > payload = ::boost::shared_ptr< KillModeError >
                (new KillModeError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "KillMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((KillModeCallbackIF*) _callback)->onKillModeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_KillSignal: {
                ::boost::shared_ptr< KillSignalError > payload = ::boost::shared_ptr< KillSignalError >
                (new KillSignalError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "KillSignal", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((KillSignalCallbackIF*) _callback)->onKillSignalError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SendSIGKILL: {
                ::boost::shared_ptr< SendSIGKILLError > payload = ::boost::shared_ptr< SendSIGKILLError >
                (new SendSIGKILLError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SendSIGKILL", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SendSIGKILLCallbackIF*) _callback)->onSendSIGKILLError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SendSIGHUP: {
                ::boost::shared_ptr< SendSIGHUPError > payload = ::boost::shared_ptr< SendSIGHUPError >
                (new SendSIGHUPError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SendSIGHUP", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SendSIGHUPCallbackIF*) _callback)->onSendSIGHUPError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& ServiceProxyCallback::_logger (ServiceProxy::_logger);

ServiceProxy::ServiceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.freedesktop.systemd1.Service", serviceAvailable, _logger) {
}

ServiceProxy::~ServiceProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< ServiceProxy > ServiceProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<ServiceProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< ServiceProxy > proxyNew(new ServiceProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t ServiceProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    ServiceProxyCallback* callback = new ServiceProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t ServiceProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    ServiceProxyCallback* callback = new ServiceProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void ServiceProxy::clearAllProperties ()
{
    _type = ::asf::core::nullable< TypeUpdate >();
    _restart = ::asf::core::nullable< RestartUpdate >();
    _pIDFile = ::asf::core::nullable< PIDFileUpdate >();
    _notifyAccess = ::asf::core::nullable< NotifyAccessUpdate >();
    _restartUSec = ::asf::core::nullable< RestartUSecUpdate >();
    _timeoutStartUSec = ::asf::core::nullable< TimeoutStartUSecUpdate >();
    _timeoutStopUSec = ::asf::core::nullable< TimeoutStopUSecUpdate >();
    _watchdogUSec = ::asf::core::nullable< WatchdogUSecUpdate >();
    _watchdogTimestamp = ::asf::core::nullable< WatchdogTimestampUpdate >();
    _watchdogTimestampMonotonic = ::asf::core::nullable< WatchdogTimestampMonotonicUpdate >();
    _startLimitInterval = ::asf::core::nullable< StartLimitIntervalUpdate >();
    _startLimitBurst = ::asf::core::nullable< StartLimitBurstUpdate >();
    _startLimitAction = ::asf::core::nullable< StartLimitActionUpdate >();
    _rebootArgument = ::asf::core::nullable< RebootArgumentUpdate >();
    _failureAction = ::asf::core::nullable< FailureActionUpdate >();
    _permissionsStartOnly = ::asf::core::nullable< PermissionsStartOnlyUpdate >();
    _rootDirectoryStartOnly = ::asf::core::nullable< RootDirectoryStartOnlyUpdate >();
    _remainAfterExit = ::asf::core::nullable< RemainAfterExitUpdate >();
    _guessMainPID = ::asf::core::nullable< GuessMainPIDUpdate >();
    _mainPID = ::asf::core::nullable< MainPIDUpdate >();
    _controlPID = ::asf::core::nullable< ControlPIDUpdate >();
    _busName = ::asf::core::nullable< BusNameUpdate >();
    _fileDescriptorStoreMax = ::asf::core::nullable< FileDescriptorStoreMaxUpdate >();
    _statusText = ::asf::core::nullable< StatusTextUpdate >();
    _statusErrno = ::asf::core::nullable< StatusErrnoUpdate >();
    _result = ::asf::core::nullable< ResultUpdate >();
    _execMainStartTimestamp = ::asf::core::nullable< ExecMainStartTimestampUpdate >();
    _execMainStartTimestampMonotonic = ::asf::core::nullable< ExecMainStartTimestampMonotonicUpdate >();
    _execMainExitTimestamp = ::asf::core::nullable< ExecMainExitTimestampUpdate >();
    _execMainExitTimestampMonotonic = ::asf::core::nullable< ExecMainExitTimestampMonotonicUpdate >();
    _execMainPID = ::asf::core::nullable< ExecMainPIDUpdate >();
    _execMainCode = ::asf::core::nullable< ExecMainCodeUpdate >();
    _execMainStatus = ::asf::core::nullable< ExecMainStatusUpdate >();
    _execStartPre = ::asf::core::nullable< ExecStartPreUpdate >();
    _execStart = ::asf::core::nullable< ExecStartUpdate >();
    _execStartPost = ::asf::core::nullable< ExecStartPostUpdate >();
    _execReload = ::asf::core::nullable< ExecReloadUpdate >();
    _execStop = ::asf::core::nullable< ExecStopUpdate >();
    _execStopPost = ::asf::core::nullable< ExecStopPostUpdate >();
    _slice = ::asf::core::nullable< SliceUpdate >();
    _controlGroup = ::asf::core::nullable< ControlGroupUpdate >();
    _memoryCurrent = ::asf::core::nullable< MemoryCurrentUpdate >();
    _cPUUsageNSec = ::asf::core::nullable< CPUUsageNSecUpdate >();
    _delegate = ::asf::core::nullable< DelegateUpdate >();
    _cPUAccounting = ::asf::core::nullable< CPUAccountingUpdate >();
    _cPUShares = ::asf::core::nullable< CPUSharesUpdate >();
    _startupCPUShares = ::asf::core::nullable< StartupCPUSharesUpdate >();
    _cPUQuotaPerSecUSec = ::asf::core::nullable< CPUQuotaPerSecUSecUpdate >();
    _blockIOAccounting = ::asf::core::nullable< BlockIOAccountingUpdate >();
    _blockIOWeight = ::asf::core::nullable< BlockIOWeightUpdate >();
    _startupBlockIOWeight = ::asf::core::nullable< StartupBlockIOWeightUpdate >();
    _blockIODeviceWeight = ::asf::core::nullable< BlockIODeviceWeightUpdate >();
    _blockIOReadBandwidth = ::asf::core::nullable< BlockIOReadBandwidthUpdate >();
    _blockIOWriteBandwidth = ::asf::core::nullable< BlockIOWriteBandwidthUpdate >();
    _memoryAccounting = ::asf::core::nullable< MemoryAccountingUpdate >();
    _memoryLimit = ::asf::core::nullable< MemoryLimitUpdate >();
    _devicePolicy = ::asf::core::nullable< DevicePolicyUpdate >();
    _deviceAllow = ::asf::core::nullable< DeviceAllowUpdate >();
    _environment = ::asf::core::nullable< EnvironmentUpdate >();
    _environmentFiles = ::asf::core::nullable< EnvironmentFilesUpdate >();
    _uMask = ::asf::core::nullable< UMaskUpdate >();
    _limitCPU = ::asf::core::nullable< LimitCPUUpdate >();
    _limitFSIZE = ::asf::core::nullable< LimitFSIZEUpdate >();
    _limitDATA = ::asf::core::nullable< LimitDATAUpdate >();
    _limitSTACK = ::asf::core::nullable< LimitSTACKUpdate >();
    _limitCORE = ::asf::core::nullable< LimitCOREUpdate >();
    _limitRSS = ::asf::core::nullable< LimitRSSUpdate >();
    _limitNOFILE = ::asf::core::nullable< LimitNOFILEUpdate >();
    _limitAS = ::asf::core::nullable< LimitASUpdate >();
    _limitNPROC = ::asf::core::nullable< LimitNPROCUpdate >();
    _limitMEMLOCK = ::asf::core::nullable< LimitMEMLOCKUpdate >();
    _limitLOCKS = ::asf::core::nullable< LimitLOCKSUpdate >();
    _limitSIGPENDING = ::asf::core::nullable< LimitSIGPENDINGUpdate >();
    _limitMSGQUEUE = ::asf::core::nullable< LimitMSGQUEUEUpdate >();
    _limitNICE = ::asf::core::nullable< LimitNICEUpdate >();
    _limitRTPRIO = ::asf::core::nullable< LimitRTPRIOUpdate >();
    _limitRTTIME = ::asf::core::nullable< LimitRTTIMEUpdate >();
    _workingDirectory = ::asf::core::nullable< WorkingDirectoryUpdate >();
    _rootDirectory = ::asf::core::nullable< RootDirectoryUpdate >();
    _oOMScoreAdjust = ::asf::core::nullable< OOMScoreAdjustUpdate >();
    _nice = ::asf::core::nullable< NiceUpdate >();
    _iOScheduling = ::asf::core::nullable< IOSchedulingUpdate >();
    _cPUSchedulingPolicy = ::asf::core::nullable< CPUSchedulingPolicyUpdate >();
    _cPUSchedulingPriority = ::asf::core::nullable< CPUSchedulingPriorityUpdate >();
    _cPUAffinity = ::asf::core::nullable< CPUAffinityUpdate >();
    _timerSlackNSec = ::asf::core::nullable< TimerSlackNSecUpdate >();
    _cPUSchedulingResetOnFork = ::asf::core::nullable< CPUSchedulingResetOnForkUpdate >();
    _nonBlocking = ::asf::core::nullable< NonBlockingUpdate >();
    _standardInput = ::asf::core::nullable< StandardInputUpdate >();
    _standardOutput = ::asf::core::nullable< StandardOutputUpdate >();
    _standardError = ::asf::core::nullable< StandardErrorUpdate >();
    _tTYPath = ::asf::core::nullable< TTYPathUpdate >();
    _tTYReset = ::asf::core::nullable< TTYResetUpdate >();
    _tTYVHangup = ::asf::core::nullable< TTYVHangupUpdate >();
    _tTYVTDisallocate = ::asf::core::nullable< TTYVTDisallocateUpdate >();
    _syslogPriority = ::asf::core::nullable< SyslogPriorityUpdate >();
    _syslogIdentifier = ::asf::core::nullable< SyslogIdentifierUpdate >();
    _syslogLevelPrefix = ::asf::core::nullable< SyslogLevelPrefixUpdate >();
    _capabilities = ::asf::core::nullable< CapabilitiesUpdate >();
    _secureBits = ::asf::core::nullable< SecureBitsUpdate >();
    _capabilityBoundingSet = ::asf::core::nullable< CapabilityBoundingSetUpdate >();
    _user = ::asf::core::nullable< UserUpdate >();
    _group = ::asf::core::nullable< GroupUpdate >();
    _supplementaryGroups = ::asf::core::nullable< SupplementaryGroupsUpdate >();
    _pAMName = ::asf::core::nullable< PAMNameUpdate >();
    _readWriteDirectories = ::asf::core::nullable< ReadWriteDirectoriesUpdate >();
    _readOnlyDirectories = ::asf::core::nullable< ReadOnlyDirectoriesUpdate >();
    _inaccessibleDirectories = ::asf::core::nullable< InaccessibleDirectoriesUpdate >();
    _mountFlags = ::asf::core::nullable< MountFlagsUpdate >();
    _privateTmp = ::asf::core::nullable< PrivateTmpUpdate >();
    _privateNetwork = ::asf::core::nullable< PrivateNetworkUpdate >();
    _privateDevices = ::asf::core::nullable< PrivateDevicesUpdate >();
    _protectHome = ::asf::core::nullable< ProtectHomeUpdate >();
    _protectSystem = ::asf::core::nullable< ProtectSystemUpdate >();
    _sameProcessGroup = ::asf::core::nullable< SameProcessGroupUpdate >();
    _utmpIdentifier = ::asf::core::nullable< UtmpIdentifierUpdate >();
    _utmpMode = ::asf::core::nullable< UtmpModeUpdate >();
    _sELinuxContext = ::asf::core::nullable< SELinuxContextUpdate >();
    _appArmorProfile = ::asf::core::nullable< AppArmorProfileUpdate >();
    _smackProcessLabel = ::asf::core::nullable< SmackProcessLabelUpdate >();
    _ignoreSIGPIPE = ::asf::core::nullable< IgnoreSIGPIPEUpdate >();
    _noNewPrivileges = ::asf::core::nullable< NoNewPrivilegesUpdate >();
    _systemCallFilter = ::asf::core::nullable< SystemCallFilterUpdate >();
    _systemCallArchitectures = ::asf::core::nullable< SystemCallArchitecturesUpdate >();
    _systemCallErrorNumber = ::asf::core::nullable< SystemCallErrorNumberUpdate >();
    _personality = ::asf::core::nullable< PersonalityUpdate >();
    _restrictAddressFamilies = ::asf::core::nullable< RestrictAddressFamiliesUpdate >();
    _runtimeDirectoryMode = ::asf::core::nullable< RuntimeDirectoryModeUpdate >();
    _runtimeDirectory = ::asf::core::nullable< RuntimeDirectoryUpdate >();
    _killMode = ::asf::core::nullable< KillModeUpdate >();
    _killSignal = ::asf::core::nullable< KillSignalUpdate >();
    _sendSIGKILL = ::asf::core::nullable< SendSIGKILLUpdate >();
    _sendSIGHUP = ::asf::core::nullable< SendSIGHUPUpdate >();
}

void ServiceProxy::sendDeregisterAll () const
{
    sendTypeDeregisterAll();
    sendRestartDeregisterAll();
    sendPIDFileDeregisterAll();
    sendNotifyAccessDeregisterAll();
    sendRestartUSecDeregisterAll();
    sendTimeoutStartUSecDeregisterAll();
    sendTimeoutStopUSecDeregisterAll();
    sendWatchdogUSecDeregisterAll();
    sendWatchdogTimestampDeregisterAll();
    sendWatchdogTimestampMonotonicDeregisterAll();
    sendStartLimitIntervalDeregisterAll();
    sendStartLimitBurstDeregisterAll();
    sendStartLimitActionDeregisterAll();
    sendRebootArgumentDeregisterAll();
    sendFailureActionDeregisterAll();
    sendPermissionsStartOnlyDeregisterAll();
    sendRootDirectoryStartOnlyDeregisterAll();
    sendRemainAfterExitDeregisterAll();
    sendGuessMainPIDDeregisterAll();
    sendMainPIDDeregisterAll();
    sendControlPIDDeregisterAll();
    sendBusNameDeregisterAll();
    sendFileDescriptorStoreMaxDeregisterAll();
    sendStatusTextDeregisterAll();
    sendStatusErrnoDeregisterAll();
    sendResultDeregisterAll();
    sendExecMainStartTimestampDeregisterAll();
    sendExecMainStartTimestampMonotonicDeregisterAll();
    sendExecMainExitTimestampDeregisterAll();
    sendExecMainExitTimestampMonotonicDeregisterAll();
    sendExecMainPIDDeregisterAll();
    sendExecMainCodeDeregisterAll();
    sendExecMainStatusDeregisterAll();
    sendExecStartPreDeregisterAll();
    sendExecStartDeregisterAll();
    sendExecStartPostDeregisterAll();
    sendExecReloadDeregisterAll();
    sendExecStopDeregisterAll();
    sendExecStopPostDeregisterAll();
    sendSliceDeregisterAll();
    sendControlGroupDeregisterAll();
    sendMemoryCurrentDeregisterAll();
    sendCPUUsageNSecDeregisterAll();
    sendDelegateDeregisterAll();
    sendCPUAccountingDeregisterAll();
    sendCPUSharesDeregisterAll();
    sendStartupCPUSharesDeregisterAll();
    sendCPUQuotaPerSecUSecDeregisterAll();
    sendBlockIOAccountingDeregisterAll();
    sendBlockIOWeightDeregisterAll();
    sendStartupBlockIOWeightDeregisterAll();
    sendBlockIODeviceWeightDeregisterAll();
    sendBlockIOReadBandwidthDeregisterAll();
    sendBlockIOWriteBandwidthDeregisterAll();
    sendMemoryAccountingDeregisterAll();
    sendMemoryLimitDeregisterAll();
    sendDevicePolicyDeregisterAll();
    sendDeviceAllowDeregisterAll();
    sendEnvironmentDeregisterAll();
    sendEnvironmentFilesDeregisterAll();
    sendUMaskDeregisterAll();
    sendLimitCPUDeregisterAll();
    sendLimitFSIZEDeregisterAll();
    sendLimitDATADeregisterAll();
    sendLimitSTACKDeregisterAll();
    sendLimitCOREDeregisterAll();
    sendLimitRSSDeregisterAll();
    sendLimitNOFILEDeregisterAll();
    sendLimitASDeregisterAll();
    sendLimitNPROCDeregisterAll();
    sendLimitMEMLOCKDeregisterAll();
    sendLimitLOCKSDeregisterAll();
    sendLimitSIGPENDINGDeregisterAll();
    sendLimitMSGQUEUEDeregisterAll();
    sendLimitNICEDeregisterAll();
    sendLimitRTPRIODeregisterAll();
    sendLimitRTTIMEDeregisterAll();
    sendWorkingDirectoryDeregisterAll();
    sendRootDirectoryDeregisterAll();
    sendOOMScoreAdjustDeregisterAll();
    sendNiceDeregisterAll();
    sendIOSchedulingDeregisterAll();
    sendCPUSchedulingPolicyDeregisterAll();
    sendCPUSchedulingPriorityDeregisterAll();
    sendCPUAffinityDeregisterAll();
    sendTimerSlackNSecDeregisterAll();
    sendCPUSchedulingResetOnForkDeregisterAll();
    sendNonBlockingDeregisterAll();
    sendStandardInputDeregisterAll();
    sendStandardOutputDeregisterAll();
    sendStandardErrorDeregisterAll();
    sendTTYPathDeregisterAll();
    sendTTYResetDeregisterAll();
    sendTTYVHangupDeregisterAll();
    sendTTYVTDisallocateDeregisterAll();
    sendSyslogPriorityDeregisterAll();
    sendSyslogIdentifierDeregisterAll();
    sendSyslogLevelPrefixDeregisterAll();
    sendCapabilitiesDeregisterAll();
    sendSecureBitsDeregisterAll();
    sendCapabilityBoundingSetDeregisterAll();
    sendUserDeregisterAll();
    sendGroupDeregisterAll();
    sendSupplementaryGroupsDeregisterAll();
    sendPAMNameDeregisterAll();
    sendReadWriteDirectoriesDeregisterAll();
    sendReadOnlyDirectoriesDeregisterAll();
    sendInaccessibleDirectoriesDeregisterAll();
    sendMountFlagsDeregisterAll();
    sendPrivateTmpDeregisterAll();
    sendPrivateNetworkDeregisterAll();
    sendPrivateDevicesDeregisterAll();
    sendProtectHomeDeregisterAll();
    sendProtectSystemDeregisterAll();
    sendSameProcessGroupDeregisterAll();
    sendUtmpIdentifierDeregisterAll();
    sendUtmpModeDeregisterAll();
    sendSELinuxContextDeregisterAll();
    sendAppArmorProfileDeregisterAll();
    sendSmackProcessLabelDeregisterAll();
    sendIgnoreSIGPIPEDeregisterAll();
    sendNoNewPrivilegesDeregisterAll();
    sendSystemCallFilterDeregisterAll();
    sendSystemCallArchitecturesDeregisterAll();
    sendSystemCallErrorNumberDeregisterAll();
    sendPersonalityDeregisterAll();
    sendRestrictAddressFamiliesDeregisterAll();
    sendRuntimeDirectoryModeDeregisterAll();
    sendRuntimeDirectoryDeregisterAll();
    sendKillModeDeregisterAll();
    sendKillSignalDeregisterAll();
    sendSendSIGKILLDeregisterAll();
    sendSendSIGHUPDeregisterAll();
}

act_t ServiceProxy::sendTypeRegister(TypeCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Type, "Type", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Type", &cb, act);
    return act;
}

bool ServiceProxy::sendTypeDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Type", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Type", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendTypeGet(TypeCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_Type, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Type", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Type", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& ServiceProxy::getType() const {
    return _type.get().getType();
}

bool ServiceProxy::hasType() const {
    return _type.hasValue();
}

void ServiceProxy::sendTypeDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Type");
    _dbusProxyDelegate->deregisterSignalCallback("Type", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendRestartRegister(RestartCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Restart, "Restart", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Restart", &cb, act);
    return act;
}

bool ServiceProxy::sendRestartDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Restart", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Restart", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendRestartGet(RestartCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_Restart, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Restart", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Restart", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& ServiceProxy::getRestart() const {
    return _restart.get().getRestart();
}

bool ServiceProxy::hasRestart() const {
    return _restart.hasValue();
}

void ServiceProxy::sendRestartDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Restart");
    _dbusProxyDelegate->deregisterSignalCallback("Restart", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendPIDFileRegister(PIDFileCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_PIDFile, "PIDFile", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "PIDFile", &cb, act);
    return act;
}

bool ServiceProxy::sendPIDFileDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("PIDFile", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "PIDFile", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendPIDFileGet(PIDFileCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_PIDFile, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "PIDFile", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("PIDFile", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& ServiceProxy::getPIDFile() const {
    return _pIDFile.get().getPIDFile();
}

bool ServiceProxy::hasPIDFile() const {
    return _pIDFile.hasValue();
}

void ServiceProxy::sendPIDFileDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "PIDFile");
    _dbusProxyDelegate->deregisterSignalCallback("PIDFile", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendNotifyAccessRegister(NotifyAccessCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_NotifyAccess, "NotifyAccess", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "NotifyAccess", &cb, act);
    return act;
}

bool ServiceProxy::sendNotifyAccessDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("NotifyAccess", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "NotifyAccess", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendNotifyAccessGet(NotifyAccessCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_NotifyAccess, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "NotifyAccess", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("NotifyAccess", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& ServiceProxy::getNotifyAccess() const {
    return _notifyAccess.get().getNotifyAccess();
}

bool ServiceProxy::hasNotifyAccess() const {
    return _notifyAccess.hasValue();
}

void ServiceProxy::sendNotifyAccessDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "NotifyAccess");
    _dbusProxyDelegate->deregisterSignalCallback("NotifyAccess", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendRestartUSecRegister(RestartUSecCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_RestartUSec, "RestartUSec", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "RestartUSec", &cb, act);
    return act;
}

bool ServiceProxy::sendRestartUSecDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("RestartUSec", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "RestartUSec", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendRestartUSecGet(RestartUSecCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_RestartUSec, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "RestartUSec", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("RestartUSec", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ServiceProxy::getRestartUSec() const {
    return _restartUSec.get().getRestartUSec();
}

bool ServiceProxy::hasRestartUSec() const {
    return _restartUSec.hasValue();
}

void ServiceProxy::sendRestartUSecDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "RestartUSec");
    _dbusProxyDelegate->deregisterSignalCallback("RestartUSec", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendTimeoutStartUSecRegister(TimeoutStartUSecCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_TimeoutStartUSec, "TimeoutStartUSec", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "TimeoutStartUSec", &cb, act);
    return act;
}

bool ServiceProxy::sendTimeoutStartUSecDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("TimeoutStartUSec", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "TimeoutStartUSec", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendTimeoutStartUSecGet(TimeoutStartUSecCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_TimeoutStartUSec, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "TimeoutStartUSec", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("TimeoutStartUSec", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ServiceProxy::getTimeoutStartUSec() const {
    return _timeoutStartUSec.get().getTimeoutStartUSec();
}

bool ServiceProxy::hasTimeoutStartUSec() const {
    return _timeoutStartUSec.hasValue();
}

void ServiceProxy::sendTimeoutStartUSecDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "TimeoutStartUSec");
    _dbusProxyDelegate->deregisterSignalCallback("TimeoutStartUSec", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendTimeoutStopUSecRegister(TimeoutStopUSecCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_TimeoutStopUSec, "TimeoutStopUSec", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "TimeoutStopUSec", &cb, act);
    return act;
}

bool ServiceProxy::sendTimeoutStopUSecDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("TimeoutStopUSec", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "TimeoutStopUSec", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendTimeoutStopUSecGet(TimeoutStopUSecCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_TimeoutStopUSec, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "TimeoutStopUSec", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("TimeoutStopUSec", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ServiceProxy::getTimeoutStopUSec() const {
    return _timeoutStopUSec.get().getTimeoutStopUSec();
}

bool ServiceProxy::hasTimeoutStopUSec() const {
    return _timeoutStopUSec.hasValue();
}

void ServiceProxy::sendTimeoutStopUSecDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "TimeoutStopUSec");
    _dbusProxyDelegate->deregisterSignalCallback("TimeoutStopUSec", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendWatchdogUSecRegister(WatchdogUSecCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_WatchdogUSec, "WatchdogUSec", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "WatchdogUSec", &cb, act);
    return act;
}

bool ServiceProxy::sendWatchdogUSecDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("WatchdogUSec", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "WatchdogUSec", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendWatchdogUSecGet(WatchdogUSecCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_WatchdogUSec, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "WatchdogUSec", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("WatchdogUSec", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ServiceProxy::getWatchdogUSec() const {
    return _watchdogUSec.get().getWatchdogUSec();
}

bool ServiceProxy::hasWatchdogUSec() const {
    return _watchdogUSec.hasValue();
}

void ServiceProxy::sendWatchdogUSecDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "WatchdogUSec");
    _dbusProxyDelegate->deregisterSignalCallback("WatchdogUSec", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendWatchdogTimestampRegister(WatchdogTimestampCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_WatchdogTimestamp, "WatchdogTimestamp", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "WatchdogTimestamp", &cb, act);
    return act;
}

bool ServiceProxy::sendWatchdogTimestampDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("WatchdogTimestamp", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "WatchdogTimestamp", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendWatchdogTimestampGet(WatchdogTimestampCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_WatchdogTimestamp, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "WatchdogTimestamp", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("WatchdogTimestamp", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ServiceProxy::getWatchdogTimestamp() const {
    return _watchdogTimestamp.get().getWatchdogTimestamp();
}

bool ServiceProxy::hasWatchdogTimestamp() const {
    return _watchdogTimestamp.hasValue();
}

void ServiceProxy::sendWatchdogTimestampDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "WatchdogTimestamp");
    _dbusProxyDelegate->deregisterSignalCallback("WatchdogTimestamp", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendWatchdogTimestampMonotonicRegister(WatchdogTimestampMonotonicCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_WatchdogTimestampMonotonic, "WatchdogTimestampMonotonic", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "WatchdogTimestampMonotonic", &cb, act);
    return act;
}

bool ServiceProxy::sendWatchdogTimestampMonotonicDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("WatchdogTimestampMonotonic", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "WatchdogTimestampMonotonic", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendWatchdogTimestampMonotonicGet(WatchdogTimestampMonotonicCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_WatchdogTimestampMonotonic, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "WatchdogTimestampMonotonic", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("WatchdogTimestampMonotonic", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ServiceProxy::getWatchdogTimestampMonotonic() const {
    return _watchdogTimestampMonotonic.get().getWatchdogTimestampMonotonic();
}

bool ServiceProxy::hasWatchdogTimestampMonotonic() const {
    return _watchdogTimestampMonotonic.hasValue();
}

void ServiceProxy::sendWatchdogTimestampMonotonicDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "WatchdogTimestampMonotonic");
    _dbusProxyDelegate->deregisterSignalCallback("WatchdogTimestampMonotonic", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendStartLimitIntervalRegister(StartLimitIntervalCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_StartLimitInterval, "StartLimitInterval", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "StartLimitInterval", &cb, act);
    return act;
}

bool ServiceProxy::sendStartLimitIntervalDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("StartLimitInterval", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "StartLimitInterval", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendStartLimitIntervalGet(StartLimitIntervalCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_StartLimitInterval, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "StartLimitInterval", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("StartLimitInterval", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ServiceProxy::getStartLimitInterval() const {
    return _startLimitInterval.get().getStartLimitInterval();
}

bool ServiceProxy::hasStartLimitInterval() const {
    return _startLimitInterval.hasValue();
}

void ServiceProxy::sendStartLimitIntervalDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "StartLimitInterval");
    _dbusProxyDelegate->deregisterSignalCallback("StartLimitInterval", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendStartLimitBurstRegister(StartLimitBurstCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_StartLimitBurst, "StartLimitBurst", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "StartLimitBurst", &cb, act);
    return act;
}

bool ServiceProxy::sendStartLimitBurstDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("StartLimitBurst", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "StartLimitBurst", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendStartLimitBurstGet(StartLimitBurstCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_StartLimitBurst, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "StartLimitBurst", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("StartLimitBurst", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint32 ServiceProxy::getStartLimitBurst() const {
    return _startLimitBurst.get().getStartLimitBurst();
}

bool ServiceProxy::hasStartLimitBurst() const {
    return _startLimitBurst.hasValue();
}

void ServiceProxy::sendStartLimitBurstDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "StartLimitBurst");
    _dbusProxyDelegate->deregisterSignalCallback("StartLimitBurst", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendStartLimitActionRegister(StartLimitActionCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_StartLimitAction, "StartLimitAction", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "StartLimitAction", &cb, act);
    return act;
}

bool ServiceProxy::sendStartLimitActionDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("StartLimitAction", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "StartLimitAction", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendStartLimitActionGet(StartLimitActionCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_StartLimitAction, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "StartLimitAction", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("StartLimitAction", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& ServiceProxy::getStartLimitAction() const {
    return _startLimitAction.get().getStartLimitAction();
}

bool ServiceProxy::hasStartLimitAction() const {
    return _startLimitAction.hasValue();
}

void ServiceProxy::sendStartLimitActionDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "StartLimitAction");
    _dbusProxyDelegate->deregisterSignalCallback("StartLimitAction", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendRebootArgumentRegister(RebootArgumentCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_RebootArgument, "RebootArgument", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "RebootArgument", &cb, act);
    return act;
}

bool ServiceProxy::sendRebootArgumentDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("RebootArgument", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "RebootArgument", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendRebootArgumentGet(RebootArgumentCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_RebootArgument, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "RebootArgument", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("RebootArgument", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& ServiceProxy::getRebootArgument() const {
    return _rebootArgument.get().getRebootArgument();
}

bool ServiceProxy::hasRebootArgument() const {
    return _rebootArgument.hasValue();
}

void ServiceProxy::sendRebootArgumentDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "RebootArgument");
    _dbusProxyDelegate->deregisterSignalCallback("RebootArgument", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendFailureActionRegister(FailureActionCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_FailureAction, "FailureAction", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "FailureAction", &cb, act);
    return act;
}

bool ServiceProxy::sendFailureActionDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("FailureAction", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "FailureAction", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendFailureActionGet(FailureActionCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_FailureAction, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "FailureAction", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("FailureAction", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& ServiceProxy::getFailureAction() const {
    return _failureAction.get().getFailureAction();
}

bool ServiceProxy::hasFailureAction() const {
    return _failureAction.hasValue();
}

void ServiceProxy::sendFailureActionDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "FailureAction");
    _dbusProxyDelegate->deregisterSignalCallback("FailureAction", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendPermissionsStartOnlyRegister(PermissionsStartOnlyCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_PermissionsStartOnly, "PermissionsStartOnly", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "PermissionsStartOnly", &cb, act);
    return act;
}

bool ServiceProxy::sendPermissionsStartOnlyDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("PermissionsStartOnly", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "PermissionsStartOnly", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendPermissionsStartOnlyGet(PermissionsStartOnlyCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_PermissionsStartOnly, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "PermissionsStartOnly", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("PermissionsStartOnly", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool ServiceProxy::getPermissionsStartOnly() const {
    return _permissionsStartOnly.get().getPermissionsStartOnly();
}

bool ServiceProxy::hasPermissionsStartOnly() const {
    return _permissionsStartOnly.hasValue();
}

void ServiceProxy::sendPermissionsStartOnlyDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "PermissionsStartOnly");
    _dbusProxyDelegate->deregisterSignalCallback("PermissionsStartOnly", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendRootDirectoryStartOnlyRegister(RootDirectoryStartOnlyCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_RootDirectoryStartOnly, "RootDirectoryStartOnly", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "RootDirectoryStartOnly", &cb, act);
    return act;
}

bool ServiceProxy::sendRootDirectoryStartOnlyDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("RootDirectoryStartOnly", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "RootDirectoryStartOnly", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendRootDirectoryStartOnlyGet(RootDirectoryStartOnlyCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_RootDirectoryStartOnly, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "RootDirectoryStartOnly", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("RootDirectoryStartOnly", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool ServiceProxy::getRootDirectoryStartOnly() const {
    return _rootDirectoryStartOnly.get().getRootDirectoryStartOnly();
}

bool ServiceProxy::hasRootDirectoryStartOnly() const {
    return _rootDirectoryStartOnly.hasValue();
}

void ServiceProxy::sendRootDirectoryStartOnlyDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "RootDirectoryStartOnly");
    _dbusProxyDelegate->deregisterSignalCallback("RootDirectoryStartOnly", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendRemainAfterExitRegister(RemainAfterExitCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_RemainAfterExit, "RemainAfterExit", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "RemainAfterExit", &cb, act);
    return act;
}

bool ServiceProxy::sendRemainAfterExitDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("RemainAfterExit", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "RemainAfterExit", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendRemainAfterExitGet(RemainAfterExitCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_RemainAfterExit, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "RemainAfterExit", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("RemainAfterExit", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool ServiceProxy::getRemainAfterExit() const {
    return _remainAfterExit.get().getRemainAfterExit();
}

bool ServiceProxy::hasRemainAfterExit() const {
    return _remainAfterExit.hasValue();
}

void ServiceProxy::sendRemainAfterExitDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "RemainAfterExit");
    _dbusProxyDelegate->deregisterSignalCallback("RemainAfterExit", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendGuessMainPIDRegister(GuessMainPIDCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_GuessMainPID, "GuessMainPID", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "GuessMainPID", &cb, act);
    return act;
}

bool ServiceProxy::sendGuessMainPIDDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("GuessMainPID", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "GuessMainPID", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendGuessMainPIDGet(GuessMainPIDCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_GuessMainPID, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "GuessMainPID", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("GuessMainPID", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool ServiceProxy::getGuessMainPID() const {
    return _guessMainPID.get().getGuessMainPID();
}

bool ServiceProxy::hasGuessMainPID() const {
    return _guessMainPID.hasValue();
}

void ServiceProxy::sendGuessMainPIDDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "GuessMainPID");
    _dbusProxyDelegate->deregisterSignalCallback("GuessMainPID", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendMainPIDRegister(MainPIDCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_MainPID, "MainPID", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "MainPID", &cb, act);
    return act;
}

bool ServiceProxy::sendMainPIDDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("MainPID", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "MainPID", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendMainPIDGet(MainPIDCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_MainPID, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "MainPID", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("MainPID", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint32 ServiceProxy::getMainPID() const {
    return _mainPID.get().getMainPID();
}

bool ServiceProxy::hasMainPID() const {
    return _mainPID.hasValue();
}

void ServiceProxy::sendMainPIDDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "MainPID");
    _dbusProxyDelegate->deregisterSignalCallback("MainPID", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendControlPIDRegister(ControlPIDCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ControlPID, "ControlPID", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ControlPID", &cb, act);
    return act;
}

bool ServiceProxy::sendControlPIDDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ControlPID", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ControlPID", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendControlPIDGet(ControlPIDCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_ControlPID, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ControlPID", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ControlPID", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint32 ServiceProxy::getControlPID() const {
    return _controlPID.get().getControlPID();
}

bool ServiceProxy::hasControlPID() const {
    return _controlPID.hasValue();
}

void ServiceProxy::sendControlPIDDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ControlPID");
    _dbusProxyDelegate->deregisterSignalCallback("ControlPID", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendBusNameRegister(BusNameCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_BusName, "BusName", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BusName", &cb, act);
    return act;
}

bool ServiceProxy::sendBusNameDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("BusName", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BusName", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendBusNameGet(BusNameCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_BusName, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "BusName", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("BusName", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& ServiceProxy::getBusName() const {
    return _busName.get().getBusName();
}

bool ServiceProxy::hasBusName() const {
    return _busName.hasValue();
}

void ServiceProxy::sendBusNameDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BusName");
    _dbusProxyDelegate->deregisterSignalCallback("BusName", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendFileDescriptorStoreMaxRegister(FileDescriptorStoreMaxCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_FileDescriptorStoreMax, "FileDescriptorStoreMax", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "FileDescriptorStoreMax", &cb, act);
    return act;
}

bool ServiceProxy::sendFileDescriptorStoreMaxDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("FileDescriptorStoreMax", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "FileDescriptorStoreMax", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendFileDescriptorStoreMaxGet(FileDescriptorStoreMaxCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_FileDescriptorStoreMax, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "FileDescriptorStoreMax", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("FileDescriptorStoreMax", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint32 ServiceProxy::getFileDescriptorStoreMax() const {
    return _fileDescriptorStoreMax.get().getFileDescriptorStoreMax();
}

bool ServiceProxy::hasFileDescriptorStoreMax() const {
    return _fileDescriptorStoreMax.hasValue();
}

void ServiceProxy::sendFileDescriptorStoreMaxDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "FileDescriptorStoreMax");
    _dbusProxyDelegate->deregisterSignalCallback("FileDescriptorStoreMax", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendStatusTextRegister(StatusTextCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_StatusText, "StatusText", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "StatusText", &cb, act);
    return act;
}

bool ServiceProxy::sendStatusTextDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("StatusText", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "StatusText", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendStatusTextGet(StatusTextCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_StatusText, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "StatusText", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("StatusText", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& ServiceProxy::getStatusText() const {
    return _statusText.get().getStatusText();
}

bool ServiceProxy::hasStatusText() const {
    return _statusText.hasValue();
}

void ServiceProxy::sendStatusTextDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "StatusText");
    _dbusProxyDelegate->deregisterSignalCallback("StatusText", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendStatusErrnoRegister(StatusErrnoCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_StatusErrno, "StatusErrno", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "StatusErrno", &cb, act);
    return act;
}

bool ServiceProxy::sendStatusErrnoDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("StatusErrno", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "StatusErrno", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendStatusErrnoGet(StatusErrnoCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_StatusErrno, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "StatusErrno", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("StatusErrno", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


int32 ServiceProxy::getStatusErrno() const {
    return _statusErrno.get().getStatusErrno();
}

bool ServiceProxy::hasStatusErrno() const {
    return _statusErrno.hasValue();
}

void ServiceProxy::sendStatusErrnoDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "StatusErrno");
    _dbusProxyDelegate->deregisterSignalCallback("StatusErrno", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendResultRegister(ResultCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Result, "Result", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Result", &cb, act);
    return act;
}

bool ServiceProxy::sendResultDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Result", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Result", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendResultGet(ResultCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_Result, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Result", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Result", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& ServiceProxy::getResult() const {
    return _result.get().getResult();
}

bool ServiceProxy::hasResult() const {
    return _result.hasValue();
}

void ServiceProxy::sendResultDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Result");
    _dbusProxyDelegate->deregisterSignalCallback("Result", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendExecMainStartTimestampRegister(ExecMainStartTimestampCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ExecMainStartTimestamp, "ExecMainStartTimestamp", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ExecMainStartTimestamp", &cb, act);
    return act;
}

bool ServiceProxy::sendExecMainStartTimestampDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ExecMainStartTimestamp", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ExecMainStartTimestamp", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendExecMainStartTimestampGet(ExecMainStartTimestampCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_ExecMainStartTimestamp, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ExecMainStartTimestamp", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ExecMainStartTimestamp", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ServiceProxy::getExecMainStartTimestamp() const {
    return _execMainStartTimestamp.get().getExecMainStartTimestamp();
}

bool ServiceProxy::hasExecMainStartTimestamp() const {
    return _execMainStartTimestamp.hasValue();
}

void ServiceProxy::sendExecMainStartTimestampDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ExecMainStartTimestamp");
    _dbusProxyDelegate->deregisterSignalCallback("ExecMainStartTimestamp", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendExecMainStartTimestampMonotonicRegister(ExecMainStartTimestampMonotonicCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ExecMainStartTimestampMonotonic, "ExecMainStartTimestampMonotonic", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ExecMainStartTimestampMonotonic", &cb, act);
    return act;
}

bool ServiceProxy::sendExecMainStartTimestampMonotonicDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ExecMainStartTimestampMonotonic", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ExecMainStartTimestampMonotonic", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendExecMainStartTimestampMonotonicGet(ExecMainStartTimestampMonotonicCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_ExecMainStartTimestampMonotonic, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ExecMainStartTimestampMonotonic", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ExecMainStartTimestampMonotonic", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ServiceProxy::getExecMainStartTimestampMonotonic() const {
    return _execMainStartTimestampMonotonic.get().getExecMainStartTimestampMonotonic();
}

bool ServiceProxy::hasExecMainStartTimestampMonotonic() const {
    return _execMainStartTimestampMonotonic.hasValue();
}

void ServiceProxy::sendExecMainStartTimestampMonotonicDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ExecMainStartTimestampMonotonic");
    _dbusProxyDelegate->deregisterSignalCallback("ExecMainStartTimestampMonotonic", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendExecMainExitTimestampRegister(ExecMainExitTimestampCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ExecMainExitTimestamp, "ExecMainExitTimestamp", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ExecMainExitTimestamp", &cb, act);
    return act;
}

bool ServiceProxy::sendExecMainExitTimestampDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ExecMainExitTimestamp", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ExecMainExitTimestamp", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendExecMainExitTimestampGet(ExecMainExitTimestampCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_ExecMainExitTimestamp, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ExecMainExitTimestamp", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ExecMainExitTimestamp", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ServiceProxy::getExecMainExitTimestamp() const {
    return _execMainExitTimestamp.get().getExecMainExitTimestamp();
}

bool ServiceProxy::hasExecMainExitTimestamp() const {
    return _execMainExitTimestamp.hasValue();
}

void ServiceProxy::sendExecMainExitTimestampDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ExecMainExitTimestamp");
    _dbusProxyDelegate->deregisterSignalCallback("ExecMainExitTimestamp", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendExecMainExitTimestampMonotonicRegister(ExecMainExitTimestampMonotonicCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ExecMainExitTimestampMonotonic, "ExecMainExitTimestampMonotonic", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ExecMainExitTimestampMonotonic", &cb, act);
    return act;
}

bool ServiceProxy::sendExecMainExitTimestampMonotonicDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ExecMainExitTimestampMonotonic", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ExecMainExitTimestampMonotonic", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendExecMainExitTimestampMonotonicGet(ExecMainExitTimestampMonotonicCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_ExecMainExitTimestampMonotonic, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ExecMainExitTimestampMonotonic", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ExecMainExitTimestampMonotonic", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ServiceProxy::getExecMainExitTimestampMonotonic() const {
    return _execMainExitTimestampMonotonic.get().getExecMainExitTimestampMonotonic();
}

bool ServiceProxy::hasExecMainExitTimestampMonotonic() const {
    return _execMainExitTimestampMonotonic.hasValue();
}

void ServiceProxy::sendExecMainExitTimestampMonotonicDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ExecMainExitTimestampMonotonic");
    _dbusProxyDelegate->deregisterSignalCallback("ExecMainExitTimestampMonotonic", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendExecMainPIDRegister(ExecMainPIDCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ExecMainPID, "ExecMainPID", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ExecMainPID", &cb, act);
    return act;
}

bool ServiceProxy::sendExecMainPIDDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ExecMainPID", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ExecMainPID", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendExecMainPIDGet(ExecMainPIDCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_ExecMainPID, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ExecMainPID", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ExecMainPID", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint32 ServiceProxy::getExecMainPID() const {
    return _execMainPID.get().getExecMainPID();
}

bool ServiceProxy::hasExecMainPID() const {
    return _execMainPID.hasValue();
}

void ServiceProxy::sendExecMainPIDDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ExecMainPID");
    _dbusProxyDelegate->deregisterSignalCallback("ExecMainPID", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendExecMainCodeRegister(ExecMainCodeCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ExecMainCode, "ExecMainCode", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ExecMainCode", &cb, act);
    return act;
}

bool ServiceProxy::sendExecMainCodeDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ExecMainCode", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ExecMainCode", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendExecMainCodeGet(ExecMainCodeCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_ExecMainCode, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ExecMainCode", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ExecMainCode", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


int32 ServiceProxy::getExecMainCode() const {
    return _execMainCode.get().getExecMainCode();
}

bool ServiceProxy::hasExecMainCode() const {
    return _execMainCode.hasValue();
}

void ServiceProxy::sendExecMainCodeDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ExecMainCode");
    _dbusProxyDelegate->deregisterSignalCallback("ExecMainCode", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendExecMainStatusRegister(ExecMainStatusCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ExecMainStatus, "ExecMainStatus", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ExecMainStatus", &cb, act);
    return act;
}

bool ServiceProxy::sendExecMainStatusDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ExecMainStatus", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ExecMainStatus", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendExecMainStatusGet(ExecMainStatusCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_ExecMainStatus, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ExecMainStatus", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ExecMainStatus", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


int32 ServiceProxy::getExecMainStatus() const {
    return _execMainStatus.get().getExecMainStatus();
}

bool ServiceProxy::hasExecMainStatus() const {
    return _execMainStatus.hasValue();
}

void ServiceProxy::sendExecMainStatusDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ExecMainStatus");
    _dbusProxyDelegate->deregisterSignalCallback("ExecMainStatus", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendExecStartPreRegister(ExecStartPreCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ExecStartPre, "ExecStartPre", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ExecStartPre", &cb, act);
    return act;
}

bool ServiceProxy::sendExecStartPreDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ExecStartPre", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ExecStartPre", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendExecStartPreGet(ExecStartPreCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_ExecStartPre, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ExecStartPre", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ExecStartPre", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< execData >& ServiceProxy::getExecStartPre() const {
    return _execStartPre.get().getExecStartPre();
}

bool ServiceProxy::hasExecStartPre() const {
    return _execStartPre.hasValue();
}

void ServiceProxy::sendExecStartPreDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ExecStartPre");
    _dbusProxyDelegate->deregisterSignalCallback("ExecStartPre", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendExecStartRegister(ExecStartCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ExecStart, "ExecStart", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ExecStart", &cb, act);
    return act;
}

bool ServiceProxy::sendExecStartDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ExecStart", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ExecStart", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendExecStartGet(ExecStartCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_ExecStart, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ExecStart", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ExecStart", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< execData >& ServiceProxy::getExecStart() const {
    return _execStart.get().getExecStart();
}

bool ServiceProxy::hasExecStart() const {
    return _execStart.hasValue();
}

void ServiceProxy::sendExecStartDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ExecStart");
    _dbusProxyDelegate->deregisterSignalCallback("ExecStart", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendExecStartPostRegister(ExecStartPostCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ExecStartPost, "ExecStartPost", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ExecStartPost", &cb, act);
    return act;
}

bool ServiceProxy::sendExecStartPostDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ExecStartPost", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ExecStartPost", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendExecStartPostGet(ExecStartPostCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_ExecStartPost, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ExecStartPost", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ExecStartPost", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< execData >& ServiceProxy::getExecStartPost() const {
    return _execStartPost.get().getExecStartPost();
}

bool ServiceProxy::hasExecStartPost() const {
    return _execStartPost.hasValue();
}

void ServiceProxy::sendExecStartPostDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ExecStartPost");
    _dbusProxyDelegate->deregisterSignalCallback("ExecStartPost", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendExecReloadRegister(ExecReloadCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ExecReload, "ExecReload", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ExecReload", &cb, act);
    return act;
}

bool ServiceProxy::sendExecReloadDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ExecReload", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ExecReload", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendExecReloadGet(ExecReloadCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_ExecReload, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ExecReload", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ExecReload", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< execData >& ServiceProxy::getExecReload() const {
    return _execReload.get().getExecReload();
}

bool ServiceProxy::hasExecReload() const {
    return _execReload.hasValue();
}

void ServiceProxy::sendExecReloadDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ExecReload");
    _dbusProxyDelegate->deregisterSignalCallback("ExecReload", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendExecStopRegister(ExecStopCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ExecStop, "ExecStop", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ExecStop", &cb, act);
    return act;
}

bool ServiceProxy::sendExecStopDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ExecStop", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ExecStop", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendExecStopGet(ExecStopCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_ExecStop, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ExecStop", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ExecStop", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< execData >& ServiceProxy::getExecStop() const {
    return _execStop.get().getExecStop();
}

bool ServiceProxy::hasExecStop() const {
    return _execStop.hasValue();
}

void ServiceProxy::sendExecStopDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ExecStop");
    _dbusProxyDelegate->deregisterSignalCallback("ExecStop", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendExecStopPostRegister(ExecStopPostCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ExecStopPost, "ExecStopPost", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ExecStopPost", &cb, act);
    return act;
}

bool ServiceProxy::sendExecStopPostDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ExecStopPost", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ExecStopPost", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendExecStopPostGet(ExecStopPostCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_ExecStopPost, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ExecStopPost", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ExecStopPost", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< execData >& ServiceProxy::getExecStopPost() const {
    return _execStopPost.get().getExecStopPost();
}

bool ServiceProxy::hasExecStopPost() const {
    return _execStopPost.hasValue();
}

void ServiceProxy::sendExecStopPostDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ExecStopPost");
    _dbusProxyDelegate->deregisterSignalCallback("ExecStopPost", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendSliceRegister(SliceCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Slice, "Slice", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Slice", &cb, act);
    return act;
}

bool ServiceProxy::sendSliceDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Slice", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Slice", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendSliceGet(SliceCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_Slice, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Slice", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Slice", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& ServiceProxy::getSlice() const {
    return _slice.get().getSlice();
}

bool ServiceProxy::hasSlice() const {
    return _slice.hasValue();
}

void ServiceProxy::sendSliceDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Slice");
    _dbusProxyDelegate->deregisterSignalCallback("Slice", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendControlGroupRegister(ControlGroupCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ControlGroup, "ControlGroup", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ControlGroup", &cb, act);
    return act;
}

bool ServiceProxy::sendControlGroupDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ControlGroup", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ControlGroup", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendControlGroupGet(ControlGroupCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_ControlGroup, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ControlGroup", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ControlGroup", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& ServiceProxy::getControlGroup() const {
    return _controlGroup.get().getControlGroup();
}

bool ServiceProxy::hasControlGroup() const {
    return _controlGroup.hasValue();
}

void ServiceProxy::sendControlGroupDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ControlGroup");
    _dbusProxyDelegate->deregisterSignalCallback("ControlGroup", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendMemoryCurrentRegister(MemoryCurrentCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_MemoryCurrent, "MemoryCurrent", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "MemoryCurrent", &cb, act);
    return act;
}

bool ServiceProxy::sendMemoryCurrentDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("MemoryCurrent", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "MemoryCurrent", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendMemoryCurrentGet(MemoryCurrentCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_MemoryCurrent, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "MemoryCurrent", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("MemoryCurrent", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ServiceProxy::getMemoryCurrent() const {
    return _memoryCurrent.get().getMemoryCurrent();
}

bool ServiceProxy::hasMemoryCurrent() const {
    return _memoryCurrent.hasValue();
}

void ServiceProxy::sendMemoryCurrentDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "MemoryCurrent");
    _dbusProxyDelegate->deregisterSignalCallback("MemoryCurrent", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendCPUUsageNSecRegister(CPUUsageNSecCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_CPUUsageNSec, "CPUUsageNSec", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "CPUUsageNSec", &cb, act);
    return act;
}

bool ServiceProxy::sendCPUUsageNSecDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("CPUUsageNSec", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "CPUUsageNSec", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendCPUUsageNSecGet(CPUUsageNSecCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_CPUUsageNSec, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "CPUUsageNSec", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("CPUUsageNSec", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ServiceProxy::getCPUUsageNSec() const {
    return _cPUUsageNSec.get().getCPUUsageNSec();
}

bool ServiceProxy::hasCPUUsageNSec() const {
    return _cPUUsageNSec.hasValue();
}

void ServiceProxy::sendCPUUsageNSecDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "CPUUsageNSec");
    _dbusProxyDelegate->deregisterSignalCallback("CPUUsageNSec", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendDelegateRegister(DelegateCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Delegate, "Delegate", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Delegate", &cb, act);
    return act;
}

bool ServiceProxy::sendDelegateDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Delegate", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Delegate", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendDelegateGet(DelegateCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_Delegate, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Delegate", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Delegate", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool ServiceProxy::getDelegate() const {
    return _delegate.get().getDelegate();
}

bool ServiceProxy::hasDelegate() const {
    return _delegate.hasValue();
}

void ServiceProxy::sendDelegateDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Delegate");
    _dbusProxyDelegate->deregisterSignalCallback("Delegate", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendCPUAccountingRegister(CPUAccountingCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_CPUAccounting, "CPUAccounting", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "CPUAccounting", &cb, act);
    return act;
}

bool ServiceProxy::sendCPUAccountingDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("CPUAccounting", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "CPUAccounting", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendCPUAccountingGet(CPUAccountingCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_CPUAccounting, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "CPUAccounting", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("CPUAccounting", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool ServiceProxy::getCPUAccounting() const {
    return _cPUAccounting.get().getCPUAccounting();
}

bool ServiceProxy::hasCPUAccounting() const {
    return _cPUAccounting.hasValue();
}

void ServiceProxy::sendCPUAccountingDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "CPUAccounting");
    _dbusProxyDelegate->deregisterSignalCallback("CPUAccounting", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendCPUSharesRegister(CPUSharesCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_CPUShares, "CPUShares", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "CPUShares", &cb, act);
    return act;
}

bool ServiceProxy::sendCPUSharesDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("CPUShares", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "CPUShares", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendCPUSharesGet(CPUSharesCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_CPUShares, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "CPUShares", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("CPUShares", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ServiceProxy::getCPUShares() const {
    return _cPUShares.get().getCPUShares();
}

bool ServiceProxy::hasCPUShares() const {
    return _cPUShares.hasValue();
}

void ServiceProxy::sendCPUSharesDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "CPUShares");
    _dbusProxyDelegate->deregisterSignalCallback("CPUShares", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendStartupCPUSharesRegister(StartupCPUSharesCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_StartupCPUShares, "StartupCPUShares", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "StartupCPUShares", &cb, act);
    return act;
}

bool ServiceProxy::sendStartupCPUSharesDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("StartupCPUShares", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "StartupCPUShares", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendStartupCPUSharesGet(StartupCPUSharesCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_StartupCPUShares, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "StartupCPUShares", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("StartupCPUShares", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ServiceProxy::getStartupCPUShares() const {
    return _startupCPUShares.get().getStartupCPUShares();
}

bool ServiceProxy::hasStartupCPUShares() const {
    return _startupCPUShares.hasValue();
}

void ServiceProxy::sendStartupCPUSharesDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "StartupCPUShares");
    _dbusProxyDelegate->deregisterSignalCallback("StartupCPUShares", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendCPUQuotaPerSecUSecRegister(CPUQuotaPerSecUSecCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_CPUQuotaPerSecUSec, "CPUQuotaPerSecUSec", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "CPUQuotaPerSecUSec", &cb, act);
    return act;
}

bool ServiceProxy::sendCPUQuotaPerSecUSecDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("CPUQuotaPerSecUSec", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "CPUQuotaPerSecUSec", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendCPUQuotaPerSecUSecGet(CPUQuotaPerSecUSecCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_CPUQuotaPerSecUSec, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "CPUQuotaPerSecUSec", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("CPUQuotaPerSecUSec", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ServiceProxy::getCPUQuotaPerSecUSec() const {
    return _cPUQuotaPerSecUSec.get().getCPUQuotaPerSecUSec();
}

bool ServiceProxy::hasCPUQuotaPerSecUSec() const {
    return _cPUQuotaPerSecUSec.hasValue();
}

void ServiceProxy::sendCPUQuotaPerSecUSecDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "CPUQuotaPerSecUSec");
    _dbusProxyDelegate->deregisterSignalCallback("CPUQuotaPerSecUSec", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendBlockIOAccountingRegister(BlockIOAccountingCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_BlockIOAccounting, "BlockIOAccounting", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BlockIOAccounting", &cb, act);
    return act;
}

bool ServiceProxy::sendBlockIOAccountingDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("BlockIOAccounting", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BlockIOAccounting", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendBlockIOAccountingGet(BlockIOAccountingCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_BlockIOAccounting, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "BlockIOAccounting", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("BlockIOAccounting", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool ServiceProxy::getBlockIOAccounting() const {
    return _blockIOAccounting.get().getBlockIOAccounting();
}

bool ServiceProxy::hasBlockIOAccounting() const {
    return _blockIOAccounting.hasValue();
}

void ServiceProxy::sendBlockIOAccountingDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BlockIOAccounting");
    _dbusProxyDelegate->deregisterSignalCallback("BlockIOAccounting", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendBlockIOWeightRegister(BlockIOWeightCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_BlockIOWeight, "BlockIOWeight", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BlockIOWeight", &cb, act);
    return act;
}

bool ServiceProxy::sendBlockIOWeightDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("BlockIOWeight", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BlockIOWeight", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendBlockIOWeightGet(BlockIOWeightCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_BlockIOWeight, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "BlockIOWeight", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("BlockIOWeight", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ServiceProxy::getBlockIOWeight() const {
    return _blockIOWeight.get().getBlockIOWeight();
}

bool ServiceProxy::hasBlockIOWeight() const {
    return _blockIOWeight.hasValue();
}

void ServiceProxy::sendBlockIOWeightDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BlockIOWeight");
    _dbusProxyDelegate->deregisterSignalCallback("BlockIOWeight", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendStartupBlockIOWeightRegister(StartupBlockIOWeightCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_StartupBlockIOWeight, "StartupBlockIOWeight", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "StartupBlockIOWeight", &cb, act);
    return act;
}

bool ServiceProxy::sendStartupBlockIOWeightDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("StartupBlockIOWeight", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "StartupBlockIOWeight", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendStartupBlockIOWeightGet(StartupBlockIOWeightCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_StartupBlockIOWeight, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "StartupBlockIOWeight", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("StartupBlockIOWeight", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ServiceProxy::getStartupBlockIOWeight() const {
    return _startupBlockIOWeight.get().getStartupBlockIOWeight();
}

bool ServiceProxy::hasStartupBlockIOWeight() const {
    return _startupBlockIOWeight.hasValue();
}

void ServiceProxy::sendStartupBlockIOWeightDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "StartupBlockIOWeight");
    _dbusProxyDelegate->deregisterSignalCallback("StartupBlockIOWeight", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendBlockIODeviceWeightRegister(BlockIODeviceWeightCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_BlockIODeviceWeight, "BlockIODeviceWeight", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BlockIODeviceWeight", &cb, act);
    return act;
}

bool ServiceProxy::sendBlockIODeviceWeightDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("BlockIODeviceWeight", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BlockIODeviceWeight", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendBlockIODeviceWeightGet(BlockIODeviceWeightCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_BlockIODeviceWeight, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "BlockIODeviceWeight", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("BlockIODeviceWeight", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< blockIOData >& ServiceProxy::getBlockIODeviceWeight() const {
    return _blockIODeviceWeight.get().getBlockIODeviceWeight();
}

bool ServiceProxy::hasBlockIODeviceWeight() const {
    return _blockIODeviceWeight.hasValue();
}

void ServiceProxy::sendBlockIODeviceWeightDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BlockIODeviceWeight");
    _dbusProxyDelegate->deregisterSignalCallback("BlockIODeviceWeight", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendBlockIOReadBandwidthRegister(BlockIOReadBandwidthCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_BlockIOReadBandwidth, "BlockIOReadBandwidth", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BlockIOReadBandwidth", &cb, act);
    return act;
}

bool ServiceProxy::sendBlockIOReadBandwidthDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("BlockIOReadBandwidth", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BlockIOReadBandwidth", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendBlockIOReadBandwidthGet(BlockIOReadBandwidthCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_BlockIOReadBandwidth, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "BlockIOReadBandwidth", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("BlockIOReadBandwidth", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< blockIOData >& ServiceProxy::getBlockIOReadBandwidth() const {
    return _blockIOReadBandwidth.get().getBlockIOReadBandwidth();
}

bool ServiceProxy::hasBlockIOReadBandwidth() const {
    return _blockIOReadBandwidth.hasValue();
}

void ServiceProxy::sendBlockIOReadBandwidthDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BlockIOReadBandwidth");
    _dbusProxyDelegate->deregisterSignalCallback("BlockIOReadBandwidth", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendBlockIOWriteBandwidthRegister(BlockIOWriteBandwidthCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_BlockIOWriteBandwidth, "BlockIOWriteBandwidth", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BlockIOWriteBandwidth", &cb, act);
    return act;
}

bool ServiceProxy::sendBlockIOWriteBandwidthDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("BlockIOWriteBandwidth", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BlockIOWriteBandwidth", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendBlockIOWriteBandwidthGet(BlockIOWriteBandwidthCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_BlockIOWriteBandwidth, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "BlockIOWriteBandwidth", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("BlockIOWriteBandwidth", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< blockIOData >& ServiceProxy::getBlockIOWriteBandwidth() const {
    return _blockIOWriteBandwidth.get().getBlockIOWriteBandwidth();
}

bool ServiceProxy::hasBlockIOWriteBandwidth() const {
    return _blockIOWriteBandwidth.hasValue();
}

void ServiceProxy::sendBlockIOWriteBandwidthDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BlockIOWriteBandwidth");
    _dbusProxyDelegate->deregisterSignalCallback("BlockIOWriteBandwidth", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendMemoryAccountingRegister(MemoryAccountingCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_MemoryAccounting, "MemoryAccounting", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "MemoryAccounting", &cb, act);
    return act;
}

bool ServiceProxy::sendMemoryAccountingDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("MemoryAccounting", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "MemoryAccounting", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendMemoryAccountingGet(MemoryAccountingCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_MemoryAccounting, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "MemoryAccounting", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("MemoryAccounting", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool ServiceProxy::getMemoryAccounting() const {
    return _memoryAccounting.get().getMemoryAccounting();
}

bool ServiceProxy::hasMemoryAccounting() const {
    return _memoryAccounting.hasValue();
}

void ServiceProxy::sendMemoryAccountingDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "MemoryAccounting");
    _dbusProxyDelegate->deregisterSignalCallback("MemoryAccounting", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendMemoryLimitRegister(MemoryLimitCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_MemoryLimit, "MemoryLimit", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "MemoryLimit", &cb, act);
    return act;
}

bool ServiceProxy::sendMemoryLimitDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("MemoryLimit", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "MemoryLimit", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendMemoryLimitGet(MemoryLimitCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_MemoryLimit, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "MemoryLimit", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("MemoryLimit", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ServiceProxy::getMemoryLimit() const {
    return _memoryLimit.get().getMemoryLimit();
}

bool ServiceProxy::hasMemoryLimit() const {
    return _memoryLimit.hasValue();
}

void ServiceProxy::sendMemoryLimitDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "MemoryLimit");
    _dbusProxyDelegate->deregisterSignalCallback("MemoryLimit", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendDevicePolicyRegister(DevicePolicyCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_DevicePolicy, "DevicePolicy", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "DevicePolicy", &cb, act);
    return act;
}

bool ServiceProxy::sendDevicePolicyDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("DevicePolicy", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "DevicePolicy", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendDevicePolicyGet(DevicePolicyCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_DevicePolicy, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "DevicePolicy", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("DevicePolicy", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& ServiceProxy::getDevicePolicy() const {
    return _devicePolicy.get().getDevicePolicy();
}

bool ServiceProxy::hasDevicePolicy() const {
    return _devicePolicy.hasValue();
}

void ServiceProxy::sendDevicePolicyDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "DevicePolicy");
    _dbusProxyDelegate->deregisterSignalCallback("DevicePolicy", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendDeviceAllowRegister(DeviceAllowCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_DeviceAllow, "DeviceAllow", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "DeviceAllow", &cb, act);
    return act;
}

bool ServiceProxy::sendDeviceAllowDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("DeviceAllow", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "DeviceAllow", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendDeviceAllowGet(DeviceAllowCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_DeviceAllow, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "DeviceAllow", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("DeviceAllow", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< deviceNode >& ServiceProxy::getDeviceAllow() const {
    return _deviceAllow.get().getDeviceAllow();
}

bool ServiceProxy::hasDeviceAllow() const {
    return _deviceAllow.hasValue();
}

void ServiceProxy::sendDeviceAllowDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "DeviceAllow");
    _dbusProxyDelegate->deregisterSignalCallback("DeviceAllow", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendEnvironmentRegister(EnvironmentCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Environment, "Environment", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Environment", &cb, act);
    return act;
}

bool ServiceProxy::sendEnvironmentDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Environment", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Environment", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendEnvironmentGet(EnvironmentCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_Environment, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Environment", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Environment", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::std::string >& ServiceProxy::getEnvironment() const {
    return _environment.get().getEnvironment();
}

bool ServiceProxy::hasEnvironment() const {
    return _environment.hasValue();
}

void ServiceProxy::sendEnvironmentDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Environment");
    _dbusProxyDelegate->deregisterSignalCallback("Environment", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendEnvironmentFilesRegister(EnvironmentFilesCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_EnvironmentFiles, "EnvironmentFiles", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "EnvironmentFiles", &cb, act);
    return act;
}

bool ServiceProxy::sendEnvironmentFilesDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("EnvironmentFiles", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "EnvironmentFiles", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendEnvironmentFilesGet(EnvironmentFilesCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_EnvironmentFiles, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "EnvironmentFiles", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("EnvironmentFiles", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< EnvironmentFile >& ServiceProxy::getEnvironmentFiles() const {
    return _environmentFiles.get().getEnvironmentFiles();
}

bool ServiceProxy::hasEnvironmentFiles() const {
    return _environmentFiles.hasValue();
}

void ServiceProxy::sendEnvironmentFilesDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "EnvironmentFiles");
    _dbusProxyDelegate->deregisterSignalCallback("EnvironmentFiles", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendUMaskRegister(UMaskCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_UMask, "UMask", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "UMask", &cb, act);
    return act;
}

bool ServiceProxy::sendUMaskDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("UMask", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "UMask", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendUMaskGet(UMaskCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_UMask, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "UMask", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("UMask", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint32 ServiceProxy::getUMask() const {
    return _uMask.get().getUMask();
}

bool ServiceProxy::hasUMask() const {
    return _uMask.hasValue();
}

void ServiceProxy::sendUMaskDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "UMask");
    _dbusProxyDelegate->deregisterSignalCallback("UMask", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendLimitCPURegister(LimitCPUCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_LimitCPU, "LimitCPU", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "LimitCPU", &cb, act);
    return act;
}

bool ServiceProxy::sendLimitCPUDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("LimitCPU", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "LimitCPU", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendLimitCPUGet(LimitCPUCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_LimitCPU, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "LimitCPU", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("LimitCPU", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ServiceProxy::getLimitCPU() const {
    return _limitCPU.get().getLimitCPU();
}

bool ServiceProxy::hasLimitCPU() const {
    return _limitCPU.hasValue();
}

void ServiceProxy::sendLimitCPUDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "LimitCPU");
    _dbusProxyDelegate->deregisterSignalCallback("LimitCPU", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendLimitFSIZERegister(LimitFSIZECallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_LimitFSIZE, "LimitFSIZE", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "LimitFSIZE", &cb, act);
    return act;
}

bool ServiceProxy::sendLimitFSIZEDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("LimitFSIZE", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "LimitFSIZE", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendLimitFSIZEGet(LimitFSIZECallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_LimitFSIZE, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "LimitFSIZE", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("LimitFSIZE", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ServiceProxy::getLimitFSIZE() const {
    return _limitFSIZE.get().getLimitFSIZE();
}

bool ServiceProxy::hasLimitFSIZE() const {
    return _limitFSIZE.hasValue();
}

void ServiceProxy::sendLimitFSIZEDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "LimitFSIZE");
    _dbusProxyDelegate->deregisterSignalCallback("LimitFSIZE", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendLimitDATARegister(LimitDATACallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_LimitDATA, "LimitDATA", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "LimitDATA", &cb, act);
    return act;
}

bool ServiceProxy::sendLimitDATADeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("LimitDATA", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "LimitDATA", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendLimitDATAGet(LimitDATACallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_LimitDATA, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "LimitDATA", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("LimitDATA", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ServiceProxy::getLimitDATA() const {
    return _limitDATA.get().getLimitDATA();
}

bool ServiceProxy::hasLimitDATA() const {
    return _limitDATA.hasValue();
}

void ServiceProxy::sendLimitDATADeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "LimitDATA");
    _dbusProxyDelegate->deregisterSignalCallback("LimitDATA", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendLimitSTACKRegister(LimitSTACKCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_LimitSTACK, "LimitSTACK", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "LimitSTACK", &cb, act);
    return act;
}

bool ServiceProxy::sendLimitSTACKDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("LimitSTACK", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "LimitSTACK", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendLimitSTACKGet(LimitSTACKCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_LimitSTACK, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "LimitSTACK", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("LimitSTACK", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ServiceProxy::getLimitSTACK() const {
    return _limitSTACK.get().getLimitSTACK();
}

bool ServiceProxy::hasLimitSTACK() const {
    return _limitSTACK.hasValue();
}

void ServiceProxy::sendLimitSTACKDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "LimitSTACK");
    _dbusProxyDelegate->deregisterSignalCallback("LimitSTACK", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendLimitCORERegister(LimitCORECallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_LimitCORE, "LimitCORE", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "LimitCORE", &cb, act);
    return act;
}

bool ServiceProxy::sendLimitCOREDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("LimitCORE", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "LimitCORE", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendLimitCOREGet(LimitCORECallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_LimitCORE, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "LimitCORE", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("LimitCORE", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ServiceProxy::getLimitCORE() const {
    return _limitCORE.get().getLimitCORE();
}

bool ServiceProxy::hasLimitCORE() const {
    return _limitCORE.hasValue();
}

void ServiceProxy::sendLimitCOREDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "LimitCORE");
    _dbusProxyDelegate->deregisterSignalCallback("LimitCORE", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendLimitRSSRegister(LimitRSSCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_LimitRSS, "LimitRSS", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "LimitRSS", &cb, act);
    return act;
}

bool ServiceProxy::sendLimitRSSDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("LimitRSS", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "LimitRSS", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendLimitRSSGet(LimitRSSCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_LimitRSS, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "LimitRSS", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("LimitRSS", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ServiceProxy::getLimitRSS() const {
    return _limitRSS.get().getLimitRSS();
}

bool ServiceProxy::hasLimitRSS() const {
    return _limitRSS.hasValue();
}

void ServiceProxy::sendLimitRSSDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "LimitRSS");
    _dbusProxyDelegate->deregisterSignalCallback("LimitRSS", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendLimitNOFILERegister(LimitNOFILECallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_LimitNOFILE, "LimitNOFILE", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "LimitNOFILE", &cb, act);
    return act;
}

bool ServiceProxy::sendLimitNOFILEDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("LimitNOFILE", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "LimitNOFILE", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendLimitNOFILEGet(LimitNOFILECallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_LimitNOFILE, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "LimitNOFILE", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("LimitNOFILE", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ServiceProxy::getLimitNOFILE() const {
    return _limitNOFILE.get().getLimitNOFILE();
}

bool ServiceProxy::hasLimitNOFILE() const {
    return _limitNOFILE.hasValue();
}

void ServiceProxy::sendLimitNOFILEDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "LimitNOFILE");
    _dbusProxyDelegate->deregisterSignalCallback("LimitNOFILE", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendLimitASRegister(LimitASCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_LimitAS, "LimitAS", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "LimitAS", &cb, act);
    return act;
}

bool ServiceProxy::sendLimitASDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("LimitAS", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "LimitAS", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendLimitASGet(LimitASCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_LimitAS, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "LimitAS", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("LimitAS", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ServiceProxy::getLimitAS() const {
    return _limitAS.get().getLimitAS();
}

bool ServiceProxy::hasLimitAS() const {
    return _limitAS.hasValue();
}

void ServiceProxy::sendLimitASDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "LimitAS");
    _dbusProxyDelegate->deregisterSignalCallback("LimitAS", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendLimitNPROCRegister(LimitNPROCCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_LimitNPROC, "LimitNPROC", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "LimitNPROC", &cb, act);
    return act;
}

bool ServiceProxy::sendLimitNPROCDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("LimitNPROC", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "LimitNPROC", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendLimitNPROCGet(LimitNPROCCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_LimitNPROC, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "LimitNPROC", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("LimitNPROC", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ServiceProxy::getLimitNPROC() const {
    return _limitNPROC.get().getLimitNPROC();
}

bool ServiceProxy::hasLimitNPROC() const {
    return _limitNPROC.hasValue();
}

void ServiceProxy::sendLimitNPROCDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "LimitNPROC");
    _dbusProxyDelegate->deregisterSignalCallback("LimitNPROC", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendLimitMEMLOCKRegister(LimitMEMLOCKCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_LimitMEMLOCK, "LimitMEMLOCK", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "LimitMEMLOCK", &cb, act);
    return act;
}

bool ServiceProxy::sendLimitMEMLOCKDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("LimitMEMLOCK", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "LimitMEMLOCK", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendLimitMEMLOCKGet(LimitMEMLOCKCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_LimitMEMLOCK, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "LimitMEMLOCK", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("LimitMEMLOCK", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ServiceProxy::getLimitMEMLOCK() const {
    return _limitMEMLOCK.get().getLimitMEMLOCK();
}

bool ServiceProxy::hasLimitMEMLOCK() const {
    return _limitMEMLOCK.hasValue();
}

void ServiceProxy::sendLimitMEMLOCKDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "LimitMEMLOCK");
    _dbusProxyDelegate->deregisterSignalCallback("LimitMEMLOCK", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendLimitLOCKSRegister(LimitLOCKSCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_LimitLOCKS, "LimitLOCKS", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "LimitLOCKS", &cb, act);
    return act;
}

bool ServiceProxy::sendLimitLOCKSDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("LimitLOCKS", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "LimitLOCKS", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendLimitLOCKSGet(LimitLOCKSCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_LimitLOCKS, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "LimitLOCKS", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("LimitLOCKS", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ServiceProxy::getLimitLOCKS() const {
    return _limitLOCKS.get().getLimitLOCKS();
}

bool ServiceProxy::hasLimitLOCKS() const {
    return _limitLOCKS.hasValue();
}

void ServiceProxy::sendLimitLOCKSDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "LimitLOCKS");
    _dbusProxyDelegate->deregisterSignalCallback("LimitLOCKS", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendLimitSIGPENDINGRegister(LimitSIGPENDINGCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_LimitSIGPENDING, "LimitSIGPENDING", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "LimitSIGPENDING", &cb, act);
    return act;
}

bool ServiceProxy::sendLimitSIGPENDINGDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("LimitSIGPENDING", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "LimitSIGPENDING", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendLimitSIGPENDINGGet(LimitSIGPENDINGCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_LimitSIGPENDING, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "LimitSIGPENDING", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("LimitSIGPENDING", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ServiceProxy::getLimitSIGPENDING() const {
    return _limitSIGPENDING.get().getLimitSIGPENDING();
}

bool ServiceProxy::hasLimitSIGPENDING() const {
    return _limitSIGPENDING.hasValue();
}

void ServiceProxy::sendLimitSIGPENDINGDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "LimitSIGPENDING");
    _dbusProxyDelegate->deregisterSignalCallback("LimitSIGPENDING", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendLimitMSGQUEUERegister(LimitMSGQUEUECallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_LimitMSGQUEUE, "LimitMSGQUEUE", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "LimitMSGQUEUE", &cb, act);
    return act;
}

bool ServiceProxy::sendLimitMSGQUEUEDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("LimitMSGQUEUE", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "LimitMSGQUEUE", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendLimitMSGQUEUEGet(LimitMSGQUEUECallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_LimitMSGQUEUE, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "LimitMSGQUEUE", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("LimitMSGQUEUE", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ServiceProxy::getLimitMSGQUEUE() const {
    return _limitMSGQUEUE.get().getLimitMSGQUEUE();
}

bool ServiceProxy::hasLimitMSGQUEUE() const {
    return _limitMSGQUEUE.hasValue();
}

void ServiceProxy::sendLimitMSGQUEUEDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "LimitMSGQUEUE");
    _dbusProxyDelegate->deregisterSignalCallback("LimitMSGQUEUE", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendLimitNICERegister(LimitNICECallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_LimitNICE, "LimitNICE", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "LimitNICE", &cb, act);
    return act;
}

bool ServiceProxy::sendLimitNICEDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("LimitNICE", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "LimitNICE", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendLimitNICEGet(LimitNICECallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_LimitNICE, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "LimitNICE", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("LimitNICE", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ServiceProxy::getLimitNICE() const {
    return _limitNICE.get().getLimitNICE();
}

bool ServiceProxy::hasLimitNICE() const {
    return _limitNICE.hasValue();
}

void ServiceProxy::sendLimitNICEDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "LimitNICE");
    _dbusProxyDelegate->deregisterSignalCallback("LimitNICE", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendLimitRTPRIORegister(LimitRTPRIOCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_LimitRTPRIO, "LimitRTPRIO", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "LimitRTPRIO", &cb, act);
    return act;
}

bool ServiceProxy::sendLimitRTPRIODeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("LimitRTPRIO", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "LimitRTPRIO", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendLimitRTPRIOGet(LimitRTPRIOCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_LimitRTPRIO, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "LimitRTPRIO", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("LimitRTPRIO", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ServiceProxy::getLimitRTPRIO() const {
    return _limitRTPRIO.get().getLimitRTPRIO();
}

bool ServiceProxy::hasLimitRTPRIO() const {
    return _limitRTPRIO.hasValue();
}

void ServiceProxy::sendLimitRTPRIODeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "LimitRTPRIO");
    _dbusProxyDelegate->deregisterSignalCallback("LimitRTPRIO", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendLimitRTTIMERegister(LimitRTTIMECallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_LimitRTTIME, "LimitRTTIME", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "LimitRTTIME", &cb, act);
    return act;
}

bool ServiceProxy::sendLimitRTTIMEDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("LimitRTTIME", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "LimitRTTIME", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendLimitRTTIMEGet(LimitRTTIMECallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_LimitRTTIME, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "LimitRTTIME", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("LimitRTTIME", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ServiceProxy::getLimitRTTIME() const {
    return _limitRTTIME.get().getLimitRTTIME();
}

bool ServiceProxy::hasLimitRTTIME() const {
    return _limitRTTIME.hasValue();
}

void ServiceProxy::sendLimitRTTIMEDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "LimitRTTIME");
    _dbusProxyDelegate->deregisterSignalCallback("LimitRTTIME", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendWorkingDirectoryRegister(WorkingDirectoryCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_WorkingDirectory, "WorkingDirectory", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "WorkingDirectory", &cb, act);
    return act;
}

bool ServiceProxy::sendWorkingDirectoryDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("WorkingDirectory", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "WorkingDirectory", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendWorkingDirectoryGet(WorkingDirectoryCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_WorkingDirectory, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "WorkingDirectory", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("WorkingDirectory", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& ServiceProxy::getWorkingDirectory() const {
    return _workingDirectory.get().getWorkingDirectory();
}

bool ServiceProxy::hasWorkingDirectory() const {
    return _workingDirectory.hasValue();
}

void ServiceProxy::sendWorkingDirectoryDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "WorkingDirectory");
    _dbusProxyDelegate->deregisterSignalCallback("WorkingDirectory", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendRootDirectoryRegister(RootDirectoryCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_RootDirectory, "RootDirectory", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "RootDirectory", &cb, act);
    return act;
}

bool ServiceProxy::sendRootDirectoryDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("RootDirectory", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "RootDirectory", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendRootDirectoryGet(RootDirectoryCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_RootDirectory, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "RootDirectory", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("RootDirectory", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& ServiceProxy::getRootDirectory() const {
    return _rootDirectory.get().getRootDirectory();
}

bool ServiceProxy::hasRootDirectory() const {
    return _rootDirectory.hasValue();
}

void ServiceProxy::sendRootDirectoryDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "RootDirectory");
    _dbusProxyDelegate->deregisterSignalCallback("RootDirectory", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendOOMScoreAdjustRegister(OOMScoreAdjustCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_OOMScoreAdjust, "OOMScoreAdjust", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "OOMScoreAdjust", &cb, act);
    return act;
}

bool ServiceProxy::sendOOMScoreAdjustDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("OOMScoreAdjust", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "OOMScoreAdjust", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendOOMScoreAdjustGet(OOMScoreAdjustCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_OOMScoreAdjust, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "OOMScoreAdjust", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("OOMScoreAdjust", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


int32 ServiceProxy::getOOMScoreAdjust() const {
    return _oOMScoreAdjust.get().getOOMScoreAdjust();
}

bool ServiceProxy::hasOOMScoreAdjust() const {
    return _oOMScoreAdjust.hasValue();
}

void ServiceProxy::sendOOMScoreAdjustDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "OOMScoreAdjust");
    _dbusProxyDelegate->deregisterSignalCallback("OOMScoreAdjust", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendNiceRegister(NiceCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Nice, "Nice", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Nice", &cb, act);
    return act;
}

bool ServiceProxy::sendNiceDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Nice", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Nice", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendNiceGet(NiceCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_Nice, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Nice", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Nice", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


int32 ServiceProxy::getNice() const {
    return _nice.get().getNice();
}

bool ServiceProxy::hasNice() const {
    return _nice.hasValue();
}

void ServiceProxy::sendNiceDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Nice");
    _dbusProxyDelegate->deregisterSignalCallback("Nice", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendIOSchedulingRegister(IOSchedulingCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_IOScheduling, "IOScheduling", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "IOScheduling", &cb, act);
    return act;
}

bool ServiceProxy::sendIOSchedulingDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("IOScheduling", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "IOScheduling", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendIOSchedulingGet(IOSchedulingCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_IOScheduling, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "IOScheduling", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("IOScheduling", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


int32 ServiceProxy::getIOScheduling() const {
    return _iOScheduling.get().getIOScheduling();
}

bool ServiceProxy::hasIOScheduling() const {
    return _iOScheduling.hasValue();
}

void ServiceProxy::sendIOSchedulingDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "IOScheduling");
    _dbusProxyDelegate->deregisterSignalCallback("IOScheduling", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendCPUSchedulingPolicyRegister(CPUSchedulingPolicyCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_CPUSchedulingPolicy, "CPUSchedulingPolicy", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "CPUSchedulingPolicy", &cb, act);
    return act;
}

bool ServiceProxy::sendCPUSchedulingPolicyDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("CPUSchedulingPolicy", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "CPUSchedulingPolicy", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendCPUSchedulingPolicyGet(CPUSchedulingPolicyCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_CPUSchedulingPolicy, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "CPUSchedulingPolicy", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("CPUSchedulingPolicy", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


int32 ServiceProxy::getCPUSchedulingPolicy() const {
    return _cPUSchedulingPolicy.get().getCPUSchedulingPolicy();
}

bool ServiceProxy::hasCPUSchedulingPolicy() const {
    return _cPUSchedulingPolicy.hasValue();
}

void ServiceProxy::sendCPUSchedulingPolicyDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "CPUSchedulingPolicy");
    _dbusProxyDelegate->deregisterSignalCallback("CPUSchedulingPolicy", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendCPUSchedulingPriorityRegister(CPUSchedulingPriorityCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_CPUSchedulingPriority, "CPUSchedulingPriority", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "CPUSchedulingPriority", &cb, act);
    return act;
}

bool ServiceProxy::sendCPUSchedulingPriorityDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("CPUSchedulingPriority", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "CPUSchedulingPriority", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendCPUSchedulingPriorityGet(CPUSchedulingPriorityCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_CPUSchedulingPriority, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "CPUSchedulingPriority", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("CPUSchedulingPriority", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


int32 ServiceProxy::getCPUSchedulingPriority() const {
    return _cPUSchedulingPriority.get().getCPUSchedulingPriority();
}

bool ServiceProxy::hasCPUSchedulingPriority() const {
    return _cPUSchedulingPriority.hasValue();
}

void ServiceProxy::sendCPUSchedulingPriorityDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "CPUSchedulingPriority");
    _dbusProxyDelegate->deregisterSignalCallback("CPUSchedulingPriority", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendCPUAffinityRegister(CPUAffinityCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_CPUAffinity, "CPUAffinity", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "CPUAffinity", &cb, act);
    return act;
}

bool ServiceProxy::sendCPUAffinityDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("CPUAffinity", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "CPUAffinity", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendCPUAffinityGet(CPUAffinityCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_CPUAffinity, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "CPUAffinity", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("CPUAffinity", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::std::string >& ServiceProxy::getCPUAffinity() const {
    return _cPUAffinity.get().getCPUAffinity();
}

bool ServiceProxy::hasCPUAffinity() const {
    return _cPUAffinity.hasValue();
}

void ServiceProxy::sendCPUAffinityDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "CPUAffinity");
    _dbusProxyDelegate->deregisterSignalCallback("CPUAffinity", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendTimerSlackNSecRegister(TimerSlackNSecCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_TimerSlackNSec, "TimerSlackNSec", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "TimerSlackNSec", &cb, act);
    return act;
}

bool ServiceProxy::sendTimerSlackNSecDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("TimerSlackNSec", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "TimerSlackNSec", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendTimerSlackNSecGet(TimerSlackNSecCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_TimerSlackNSec, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "TimerSlackNSec", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("TimerSlackNSec", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ServiceProxy::getTimerSlackNSec() const {
    return _timerSlackNSec.get().getTimerSlackNSec();
}

bool ServiceProxy::hasTimerSlackNSec() const {
    return _timerSlackNSec.hasValue();
}

void ServiceProxy::sendTimerSlackNSecDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "TimerSlackNSec");
    _dbusProxyDelegate->deregisterSignalCallback("TimerSlackNSec", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendCPUSchedulingResetOnForkRegister(CPUSchedulingResetOnForkCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_CPUSchedulingResetOnFork, "CPUSchedulingResetOnFork", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "CPUSchedulingResetOnFork", &cb, act);
    return act;
}

bool ServiceProxy::sendCPUSchedulingResetOnForkDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("CPUSchedulingResetOnFork", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "CPUSchedulingResetOnFork", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendCPUSchedulingResetOnForkGet(CPUSchedulingResetOnForkCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_CPUSchedulingResetOnFork, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "CPUSchedulingResetOnFork", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("CPUSchedulingResetOnFork", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool ServiceProxy::getCPUSchedulingResetOnFork() const {
    return _cPUSchedulingResetOnFork.get().getCPUSchedulingResetOnFork();
}

bool ServiceProxy::hasCPUSchedulingResetOnFork() const {
    return _cPUSchedulingResetOnFork.hasValue();
}

void ServiceProxy::sendCPUSchedulingResetOnForkDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "CPUSchedulingResetOnFork");
    _dbusProxyDelegate->deregisterSignalCallback("CPUSchedulingResetOnFork", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendNonBlockingRegister(NonBlockingCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_NonBlocking, "NonBlocking", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "NonBlocking", &cb, act);
    return act;
}

bool ServiceProxy::sendNonBlockingDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("NonBlocking", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "NonBlocking", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendNonBlockingGet(NonBlockingCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_NonBlocking, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "NonBlocking", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("NonBlocking", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool ServiceProxy::getNonBlocking() const {
    return _nonBlocking.get().getNonBlocking();
}

bool ServiceProxy::hasNonBlocking() const {
    return _nonBlocking.hasValue();
}

void ServiceProxy::sendNonBlockingDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "NonBlocking");
    _dbusProxyDelegate->deregisterSignalCallback("NonBlocking", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendStandardInputRegister(StandardInputCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_StandardInput, "StandardInput", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "StandardInput", &cb, act);
    return act;
}

bool ServiceProxy::sendStandardInputDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("StandardInput", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "StandardInput", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendStandardInputGet(StandardInputCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_StandardInput, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "StandardInput", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("StandardInput", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& ServiceProxy::getStandardInput() const {
    return _standardInput.get().getStandardInput();
}

bool ServiceProxy::hasStandardInput() const {
    return _standardInput.hasValue();
}

void ServiceProxy::sendStandardInputDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "StandardInput");
    _dbusProxyDelegate->deregisterSignalCallback("StandardInput", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendStandardOutputRegister(StandardOutputCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_StandardOutput, "StandardOutput", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "StandardOutput", &cb, act);
    return act;
}

bool ServiceProxy::sendStandardOutputDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("StandardOutput", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "StandardOutput", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendStandardOutputGet(StandardOutputCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_StandardOutput, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "StandardOutput", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("StandardOutput", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& ServiceProxy::getStandardOutput() const {
    return _standardOutput.get().getStandardOutput();
}

bool ServiceProxy::hasStandardOutput() const {
    return _standardOutput.hasValue();
}

void ServiceProxy::sendStandardOutputDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "StandardOutput");
    _dbusProxyDelegate->deregisterSignalCallback("StandardOutput", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendStandardErrorRegister(StandardErrorCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_StandardError, "StandardError", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "StandardError", &cb, act);
    return act;
}

bool ServiceProxy::sendStandardErrorDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("StandardError", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "StandardError", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendStandardErrorGet(StandardErrorCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_StandardError, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "StandardError", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("StandardError", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& ServiceProxy::getStandardError() const {
    return _standardError.get().getStandardError();
}

bool ServiceProxy::hasStandardError() const {
    return _standardError.hasValue();
}

void ServiceProxy::sendStandardErrorDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "StandardError");
    _dbusProxyDelegate->deregisterSignalCallback("StandardError", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendTTYPathRegister(TTYPathCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_TTYPath, "TTYPath", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "TTYPath", &cb, act);
    return act;
}

bool ServiceProxy::sendTTYPathDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("TTYPath", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "TTYPath", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendTTYPathGet(TTYPathCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_TTYPath, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "TTYPath", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("TTYPath", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool ServiceProxy::getTTYPath() const {
    return _tTYPath.get().getTTYPath();
}

bool ServiceProxy::hasTTYPath() const {
    return _tTYPath.hasValue();
}

void ServiceProxy::sendTTYPathDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "TTYPath");
    _dbusProxyDelegate->deregisterSignalCallback("TTYPath", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendTTYResetRegister(TTYResetCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_TTYReset, "TTYReset", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "TTYReset", &cb, act);
    return act;
}

bool ServiceProxy::sendTTYResetDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("TTYReset", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "TTYReset", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendTTYResetGet(TTYResetCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_TTYReset, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "TTYReset", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("TTYReset", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool ServiceProxy::getTTYReset() const {
    return _tTYReset.get().getTTYReset();
}

bool ServiceProxy::hasTTYReset() const {
    return _tTYReset.hasValue();
}

void ServiceProxy::sendTTYResetDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "TTYReset");
    _dbusProxyDelegate->deregisterSignalCallback("TTYReset", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendTTYVHangupRegister(TTYVHangupCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_TTYVHangup, "TTYVHangup", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "TTYVHangup", &cb, act);
    return act;
}

bool ServiceProxy::sendTTYVHangupDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("TTYVHangup", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "TTYVHangup", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendTTYVHangupGet(TTYVHangupCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_TTYVHangup, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "TTYVHangup", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("TTYVHangup", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool ServiceProxy::getTTYVHangup() const {
    return _tTYVHangup.get().getTTYVHangup();
}

bool ServiceProxy::hasTTYVHangup() const {
    return _tTYVHangup.hasValue();
}

void ServiceProxy::sendTTYVHangupDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "TTYVHangup");
    _dbusProxyDelegate->deregisterSignalCallback("TTYVHangup", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendTTYVTDisallocateRegister(TTYVTDisallocateCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_TTYVTDisallocate, "TTYVTDisallocate", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "TTYVTDisallocate", &cb, act);
    return act;
}

bool ServiceProxy::sendTTYVTDisallocateDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("TTYVTDisallocate", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "TTYVTDisallocate", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendTTYVTDisallocateGet(TTYVTDisallocateCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_TTYVTDisallocate, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "TTYVTDisallocate", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("TTYVTDisallocate", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool ServiceProxy::getTTYVTDisallocate() const {
    return _tTYVTDisallocate.get().getTTYVTDisallocate();
}

bool ServiceProxy::hasTTYVTDisallocate() const {
    return _tTYVTDisallocate.hasValue();
}

void ServiceProxy::sendTTYVTDisallocateDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "TTYVTDisallocate");
    _dbusProxyDelegate->deregisterSignalCallback("TTYVTDisallocate", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendSyslogPriorityRegister(SyslogPriorityCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_SyslogPriority, "SyslogPriority", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SyslogPriority", &cb, act);
    return act;
}

bool ServiceProxy::sendSyslogPriorityDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SyslogPriority", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SyslogPriority", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendSyslogPriorityGet(SyslogPriorityCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_SyslogPriority, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "SyslogPriority", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("SyslogPriority", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


int32 ServiceProxy::getSyslogPriority() const {
    return _syslogPriority.get().getSyslogPriority();
}

bool ServiceProxy::hasSyslogPriority() const {
    return _syslogPriority.hasValue();
}

void ServiceProxy::sendSyslogPriorityDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SyslogPriority");
    _dbusProxyDelegate->deregisterSignalCallback("SyslogPriority", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendSyslogIdentifierRegister(SyslogIdentifierCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_SyslogIdentifier, "SyslogIdentifier", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SyslogIdentifier", &cb, act);
    return act;
}

bool ServiceProxy::sendSyslogIdentifierDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SyslogIdentifier", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SyslogIdentifier", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendSyslogIdentifierGet(SyslogIdentifierCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_SyslogIdentifier, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "SyslogIdentifier", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("SyslogIdentifier", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& ServiceProxy::getSyslogIdentifier() const {
    return _syslogIdentifier.get().getSyslogIdentifier();
}

bool ServiceProxy::hasSyslogIdentifier() const {
    return _syslogIdentifier.hasValue();
}

void ServiceProxy::sendSyslogIdentifierDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SyslogIdentifier");
    _dbusProxyDelegate->deregisterSignalCallback("SyslogIdentifier", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendSyslogLevelPrefixRegister(SyslogLevelPrefixCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_SyslogLevelPrefix, "SyslogLevelPrefix", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SyslogLevelPrefix", &cb, act);
    return act;
}

bool ServiceProxy::sendSyslogLevelPrefixDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SyslogLevelPrefix", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SyslogLevelPrefix", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendSyslogLevelPrefixGet(SyslogLevelPrefixCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_SyslogLevelPrefix, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "SyslogLevelPrefix", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("SyslogLevelPrefix", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool ServiceProxy::getSyslogLevelPrefix() const {
    return _syslogLevelPrefix.get().getSyslogLevelPrefix();
}

bool ServiceProxy::hasSyslogLevelPrefix() const {
    return _syslogLevelPrefix.hasValue();
}

void ServiceProxy::sendSyslogLevelPrefixDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SyslogLevelPrefix");
    _dbusProxyDelegate->deregisterSignalCallback("SyslogLevelPrefix", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendCapabilitiesRegister(CapabilitiesCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Capabilities, "Capabilities", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Capabilities", &cb, act);
    return act;
}

bool ServiceProxy::sendCapabilitiesDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Capabilities", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Capabilities", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendCapabilitiesGet(CapabilitiesCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_Capabilities, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Capabilities", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Capabilities", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& ServiceProxy::getCapabilities() const {
    return _capabilities.get().getCapabilities();
}

bool ServiceProxy::hasCapabilities() const {
    return _capabilities.hasValue();
}

void ServiceProxy::sendCapabilitiesDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Capabilities");
    _dbusProxyDelegate->deregisterSignalCallback("Capabilities", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendSecureBitsRegister(SecureBitsCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_SecureBits, "SecureBits", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SecureBits", &cb, act);
    return act;
}

bool ServiceProxy::sendSecureBitsDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SecureBits", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SecureBits", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendSecureBitsGet(SecureBitsCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_SecureBits, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "SecureBits", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("SecureBits", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


int32 ServiceProxy::getSecureBits() const {
    return _secureBits.get().getSecureBits();
}

bool ServiceProxy::hasSecureBits() const {
    return _secureBits.hasValue();
}

void ServiceProxy::sendSecureBitsDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SecureBits");
    _dbusProxyDelegate->deregisterSignalCallback("SecureBits", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendCapabilityBoundingSetRegister(CapabilityBoundingSetCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_CapabilityBoundingSet, "CapabilityBoundingSet", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "CapabilityBoundingSet", &cb, act);
    return act;
}

bool ServiceProxy::sendCapabilityBoundingSetDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("CapabilityBoundingSet", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "CapabilityBoundingSet", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendCapabilityBoundingSetGet(CapabilityBoundingSetCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_CapabilityBoundingSet, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "CapabilityBoundingSet", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("CapabilityBoundingSet", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ServiceProxy::getCapabilityBoundingSet() const {
    return _capabilityBoundingSet.get().getCapabilityBoundingSet();
}

bool ServiceProxy::hasCapabilityBoundingSet() const {
    return _capabilityBoundingSet.hasValue();
}

void ServiceProxy::sendCapabilityBoundingSetDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "CapabilityBoundingSet");
    _dbusProxyDelegate->deregisterSignalCallback("CapabilityBoundingSet", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendUserRegister(UserCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_User, "User", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "User", &cb, act);
    return act;
}

bool ServiceProxy::sendUserDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("User", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "User", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendUserGet(UserCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_User, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "User", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("User", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& ServiceProxy::getUser() const {
    return _user.get().getUser();
}

bool ServiceProxy::hasUser() const {
    return _user.hasValue();
}

void ServiceProxy::sendUserDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "User");
    _dbusProxyDelegate->deregisterSignalCallback("User", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendGroupRegister(GroupCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Group, "Group", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Group", &cb, act);
    return act;
}

bool ServiceProxy::sendGroupDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Group", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Group", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendGroupGet(GroupCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_Group, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Group", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Group", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& ServiceProxy::getGroup() const {
    return _group.get().getGroup();
}

bool ServiceProxy::hasGroup() const {
    return _group.hasValue();
}

void ServiceProxy::sendGroupDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Group");
    _dbusProxyDelegate->deregisterSignalCallback("Group", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendSupplementaryGroupsRegister(SupplementaryGroupsCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_SupplementaryGroups, "SupplementaryGroups", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SupplementaryGroups", &cb, act);
    return act;
}

bool ServiceProxy::sendSupplementaryGroupsDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SupplementaryGroups", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SupplementaryGroups", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendSupplementaryGroupsGet(SupplementaryGroupsCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_SupplementaryGroups, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "SupplementaryGroups", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("SupplementaryGroups", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::std::string >& ServiceProxy::getSupplementaryGroups() const {
    return _supplementaryGroups.get().getSupplementaryGroups();
}

bool ServiceProxy::hasSupplementaryGroups() const {
    return _supplementaryGroups.hasValue();
}

void ServiceProxy::sendSupplementaryGroupsDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SupplementaryGroups");
    _dbusProxyDelegate->deregisterSignalCallback("SupplementaryGroups", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendPAMNameRegister(PAMNameCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_PAMName, "PAMName", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "PAMName", &cb, act);
    return act;
}

bool ServiceProxy::sendPAMNameDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("PAMName", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "PAMName", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendPAMNameGet(PAMNameCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_PAMName, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "PAMName", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("PAMName", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& ServiceProxy::getPAMName() const {
    return _pAMName.get().getPAMName();
}

bool ServiceProxy::hasPAMName() const {
    return _pAMName.hasValue();
}

void ServiceProxy::sendPAMNameDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "PAMName");
    _dbusProxyDelegate->deregisterSignalCallback("PAMName", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendReadWriteDirectoriesRegister(ReadWriteDirectoriesCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ReadWriteDirectories, "ReadWriteDirectories", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ReadWriteDirectories", &cb, act);
    return act;
}

bool ServiceProxy::sendReadWriteDirectoriesDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ReadWriteDirectories", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ReadWriteDirectories", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendReadWriteDirectoriesGet(ReadWriteDirectoriesCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_ReadWriteDirectories, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ReadWriteDirectories", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ReadWriteDirectories", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::std::string >& ServiceProxy::getReadWriteDirectories() const {
    return _readWriteDirectories.get().getReadWriteDirectories();
}

bool ServiceProxy::hasReadWriteDirectories() const {
    return _readWriteDirectories.hasValue();
}

void ServiceProxy::sendReadWriteDirectoriesDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ReadWriteDirectories");
    _dbusProxyDelegate->deregisterSignalCallback("ReadWriteDirectories", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendReadOnlyDirectoriesRegister(ReadOnlyDirectoriesCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ReadOnlyDirectories, "ReadOnlyDirectories", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ReadOnlyDirectories", &cb, act);
    return act;
}

bool ServiceProxy::sendReadOnlyDirectoriesDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ReadOnlyDirectories", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ReadOnlyDirectories", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendReadOnlyDirectoriesGet(ReadOnlyDirectoriesCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_ReadOnlyDirectories, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ReadOnlyDirectories", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ReadOnlyDirectories", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::std::string >& ServiceProxy::getReadOnlyDirectories() const {
    return _readOnlyDirectories.get().getReadOnlyDirectories();
}

bool ServiceProxy::hasReadOnlyDirectories() const {
    return _readOnlyDirectories.hasValue();
}

void ServiceProxy::sendReadOnlyDirectoriesDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ReadOnlyDirectories");
    _dbusProxyDelegate->deregisterSignalCallback("ReadOnlyDirectories", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendInaccessibleDirectoriesRegister(InaccessibleDirectoriesCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_InaccessibleDirectories, "InaccessibleDirectories", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "InaccessibleDirectories", &cb, act);
    return act;
}

bool ServiceProxy::sendInaccessibleDirectoriesDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("InaccessibleDirectories", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "InaccessibleDirectories", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendInaccessibleDirectoriesGet(InaccessibleDirectoriesCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_InaccessibleDirectories, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "InaccessibleDirectories", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("InaccessibleDirectories", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::std::string >& ServiceProxy::getInaccessibleDirectories() const {
    return _inaccessibleDirectories.get().getInaccessibleDirectories();
}

bool ServiceProxy::hasInaccessibleDirectories() const {
    return _inaccessibleDirectories.hasValue();
}

void ServiceProxy::sendInaccessibleDirectoriesDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "InaccessibleDirectories");
    _dbusProxyDelegate->deregisterSignalCallback("InaccessibleDirectories", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendMountFlagsRegister(MountFlagsCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_MountFlags, "MountFlags", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "MountFlags", &cb, act);
    return act;
}

bool ServiceProxy::sendMountFlagsDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("MountFlags", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "MountFlags", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendMountFlagsGet(MountFlagsCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_MountFlags, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "MountFlags", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("MountFlags", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 ServiceProxy::getMountFlags() const {
    return _mountFlags.get().getMountFlags();
}

bool ServiceProxy::hasMountFlags() const {
    return _mountFlags.hasValue();
}

void ServiceProxy::sendMountFlagsDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "MountFlags");
    _dbusProxyDelegate->deregisterSignalCallback("MountFlags", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendPrivateTmpRegister(PrivateTmpCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_PrivateTmp, "PrivateTmp", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "PrivateTmp", &cb, act);
    return act;
}

bool ServiceProxy::sendPrivateTmpDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("PrivateTmp", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "PrivateTmp", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendPrivateTmpGet(PrivateTmpCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_PrivateTmp, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "PrivateTmp", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("PrivateTmp", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool ServiceProxy::getPrivateTmp() const {
    return _privateTmp.get().getPrivateTmp();
}

bool ServiceProxy::hasPrivateTmp() const {
    return _privateTmp.hasValue();
}

void ServiceProxy::sendPrivateTmpDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "PrivateTmp");
    _dbusProxyDelegate->deregisterSignalCallback("PrivateTmp", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendPrivateNetworkRegister(PrivateNetworkCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_PrivateNetwork, "PrivateNetwork", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "PrivateNetwork", &cb, act);
    return act;
}

bool ServiceProxy::sendPrivateNetworkDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("PrivateNetwork", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "PrivateNetwork", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendPrivateNetworkGet(PrivateNetworkCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_PrivateNetwork, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "PrivateNetwork", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("PrivateNetwork", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool ServiceProxy::getPrivateNetwork() const {
    return _privateNetwork.get().getPrivateNetwork();
}

bool ServiceProxy::hasPrivateNetwork() const {
    return _privateNetwork.hasValue();
}

void ServiceProxy::sendPrivateNetworkDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "PrivateNetwork");
    _dbusProxyDelegate->deregisterSignalCallback("PrivateNetwork", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendPrivateDevicesRegister(PrivateDevicesCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_PrivateDevices, "PrivateDevices", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "PrivateDevices", &cb, act);
    return act;
}

bool ServiceProxy::sendPrivateDevicesDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("PrivateDevices", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "PrivateDevices", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendPrivateDevicesGet(PrivateDevicesCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_PrivateDevices, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "PrivateDevices", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("PrivateDevices", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool ServiceProxy::getPrivateDevices() const {
    return _privateDevices.get().getPrivateDevices();
}

bool ServiceProxy::hasPrivateDevices() const {
    return _privateDevices.hasValue();
}

void ServiceProxy::sendPrivateDevicesDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "PrivateDevices");
    _dbusProxyDelegate->deregisterSignalCallback("PrivateDevices", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendProtectHomeRegister(ProtectHomeCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ProtectHome, "ProtectHome", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ProtectHome", &cb, act);
    return act;
}

bool ServiceProxy::sendProtectHomeDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ProtectHome", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ProtectHome", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendProtectHomeGet(ProtectHomeCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_ProtectHome, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ProtectHome", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ProtectHome", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& ServiceProxy::getProtectHome() const {
    return _protectHome.get().getProtectHome();
}

bool ServiceProxy::hasProtectHome() const {
    return _protectHome.hasValue();
}

void ServiceProxy::sendProtectHomeDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ProtectHome");
    _dbusProxyDelegate->deregisterSignalCallback("ProtectHome", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendProtectSystemRegister(ProtectSystemCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ProtectSystem, "ProtectSystem", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ProtectSystem", &cb, act);
    return act;
}

bool ServiceProxy::sendProtectSystemDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ProtectSystem", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ProtectSystem", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendProtectSystemGet(ProtectSystemCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_ProtectSystem, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ProtectSystem", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ProtectSystem", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& ServiceProxy::getProtectSystem() const {
    return _protectSystem.get().getProtectSystem();
}

bool ServiceProxy::hasProtectSystem() const {
    return _protectSystem.hasValue();
}

void ServiceProxy::sendProtectSystemDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ProtectSystem");
    _dbusProxyDelegate->deregisterSignalCallback("ProtectSystem", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendSameProcessGroupRegister(SameProcessGroupCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_SameProcessGroup, "SameProcessGroup", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SameProcessGroup", &cb, act);
    return act;
}

bool ServiceProxy::sendSameProcessGroupDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SameProcessGroup", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SameProcessGroup", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendSameProcessGroupGet(SameProcessGroupCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_SameProcessGroup, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "SameProcessGroup", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("SameProcessGroup", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool ServiceProxy::getSameProcessGroup() const {
    return _sameProcessGroup.get().getSameProcessGroup();
}

bool ServiceProxy::hasSameProcessGroup() const {
    return _sameProcessGroup.hasValue();
}

void ServiceProxy::sendSameProcessGroupDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SameProcessGroup");
    _dbusProxyDelegate->deregisterSignalCallback("SameProcessGroup", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendUtmpIdentifierRegister(UtmpIdentifierCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_UtmpIdentifier, "UtmpIdentifier", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "UtmpIdentifier", &cb, act);
    return act;
}

bool ServiceProxy::sendUtmpIdentifierDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("UtmpIdentifier", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "UtmpIdentifier", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendUtmpIdentifierGet(UtmpIdentifierCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_UtmpIdentifier, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "UtmpIdentifier", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("UtmpIdentifier", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& ServiceProxy::getUtmpIdentifier() const {
    return _utmpIdentifier.get().getUtmpIdentifier();
}

bool ServiceProxy::hasUtmpIdentifier() const {
    return _utmpIdentifier.hasValue();
}

void ServiceProxy::sendUtmpIdentifierDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "UtmpIdentifier");
    _dbusProxyDelegate->deregisterSignalCallback("UtmpIdentifier", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendUtmpModeRegister(UtmpModeCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_UtmpMode, "UtmpMode", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "UtmpMode", &cb, act);
    return act;
}

bool ServiceProxy::sendUtmpModeDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("UtmpMode", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "UtmpMode", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendUtmpModeGet(UtmpModeCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_UtmpMode, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "UtmpMode", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("UtmpMode", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& ServiceProxy::getUtmpMode() const {
    return _utmpMode.get().getUtmpMode();
}

bool ServiceProxy::hasUtmpMode() const {
    return _utmpMode.hasValue();
}

void ServiceProxy::sendUtmpModeDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "UtmpMode");
    _dbusProxyDelegate->deregisterSignalCallback("UtmpMode", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendSELinuxContextRegister(SELinuxContextCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_SELinuxContext, "SELinuxContext", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SELinuxContext", &cb, act);
    return act;
}

bool ServiceProxy::sendSELinuxContextDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SELinuxContext", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SELinuxContext", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendSELinuxContextGet(SELinuxContextCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_SELinuxContext, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "SELinuxContext", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("SELinuxContext", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const securityContext& ServiceProxy::getSELinuxContext() const {
    return _sELinuxContext.get().getSELinuxContext();
}

bool ServiceProxy::hasSELinuxContext() const {
    return _sELinuxContext.hasValue();
}

void ServiceProxy::sendSELinuxContextDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SELinuxContext");
    _dbusProxyDelegate->deregisterSignalCallback("SELinuxContext", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendAppArmorProfileRegister(AppArmorProfileCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_AppArmorProfile, "AppArmorProfile", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "AppArmorProfile", &cb, act);
    return act;
}

bool ServiceProxy::sendAppArmorProfileDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("AppArmorProfile", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "AppArmorProfile", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendAppArmorProfileGet(AppArmorProfileCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_AppArmorProfile, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "AppArmorProfile", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("AppArmorProfile", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ArmorProfile& ServiceProxy::getAppArmorProfile() const {
    return _appArmorProfile.get().getAppArmorProfile();
}

bool ServiceProxy::hasAppArmorProfile() const {
    return _appArmorProfile.hasValue();
}

void ServiceProxy::sendAppArmorProfileDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "AppArmorProfile");
    _dbusProxyDelegate->deregisterSignalCallback("AppArmorProfile", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendSmackProcessLabelRegister(SmackProcessLabelCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_SmackProcessLabel, "SmackProcessLabel", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SmackProcessLabel", &cb, act);
    return act;
}

bool ServiceProxy::sendSmackProcessLabelDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SmackProcessLabel", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SmackProcessLabel", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendSmackProcessLabelGet(SmackProcessLabelCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_SmackProcessLabel, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "SmackProcessLabel", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("SmackProcessLabel", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ProcessLabel& ServiceProxy::getSmackProcessLabel() const {
    return _smackProcessLabel.get().getSmackProcessLabel();
}

bool ServiceProxy::hasSmackProcessLabel() const {
    return _smackProcessLabel.hasValue();
}

void ServiceProxy::sendSmackProcessLabelDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SmackProcessLabel");
    _dbusProxyDelegate->deregisterSignalCallback("SmackProcessLabel", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendIgnoreSIGPIPERegister(IgnoreSIGPIPECallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_IgnoreSIGPIPE, "IgnoreSIGPIPE", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "IgnoreSIGPIPE", &cb, act);
    return act;
}

bool ServiceProxy::sendIgnoreSIGPIPEDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("IgnoreSIGPIPE", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "IgnoreSIGPIPE", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendIgnoreSIGPIPEGet(IgnoreSIGPIPECallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_IgnoreSIGPIPE, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "IgnoreSIGPIPE", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("IgnoreSIGPIPE", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool ServiceProxy::getIgnoreSIGPIPE() const {
    return _ignoreSIGPIPE.get().getIgnoreSIGPIPE();
}

bool ServiceProxy::hasIgnoreSIGPIPE() const {
    return _ignoreSIGPIPE.hasValue();
}

void ServiceProxy::sendIgnoreSIGPIPEDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "IgnoreSIGPIPE");
    _dbusProxyDelegate->deregisterSignalCallback("IgnoreSIGPIPE", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendNoNewPrivilegesRegister(NoNewPrivilegesCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_NoNewPrivileges, "NoNewPrivileges", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "NoNewPrivileges", &cb, act);
    return act;
}

bool ServiceProxy::sendNoNewPrivilegesDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("NoNewPrivileges", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "NoNewPrivileges", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendNoNewPrivilegesGet(NoNewPrivilegesCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_NoNewPrivileges, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "NoNewPrivileges", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("NoNewPrivileges", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool ServiceProxy::getNoNewPrivileges() const {
    return _noNewPrivileges.get().getNoNewPrivileges();
}

bool ServiceProxy::hasNoNewPrivileges() const {
    return _noNewPrivileges.hasValue();
}

void ServiceProxy::sendNoNewPrivilegesDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "NoNewPrivileges");
    _dbusProxyDelegate->deregisterSignalCallback("NoNewPrivileges", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendSystemCallFilterRegister(SystemCallFilterCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_SystemCallFilter, "SystemCallFilter", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SystemCallFilter", &cb, act);
    return act;
}

bool ServiceProxy::sendSystemCallFilterDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SystemCallFilter", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SystemCallFilter", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendSystemCallFilterGet(SystemCallFilterCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_SystemCallFilter, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "SystemCallFilter", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("SystemCallFilter", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const systemCallFilter& ServiceProxy::getSystemCallFilter() const {
    return _systemCallFilter.get().getSystemCallFilter();
}

bool ServiceProxy::hasSystemCallFilter() const {
    return _systemCallFilter.hasValue();
}

void ServiceProxy::sendSystemCallFilterDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SystemCallFilter");
    _dbusProxyDelegate->deregisterSignalCallback("SystemCallFilter", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendSystemCallArchitecturesRegister(SystemCallArchitecturesCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_SystemCallArchitectures, "SystemCallArchitectures", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SystemCallArchitectures", &cb, act);
    return act;
}

bool ServiceProxy::sendSystemCallArchitecturesDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SystemCallArchitectures", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SystemCallArchitectures", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendSystemCallArchitecturesGet(SystemCallArchitecturesCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_SystemCallArchitectures, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "SystemCallArchitectures", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("SystemCallArchitectures", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::std::string >& ServiceProxy::getSystemCallArchitectures() const {
    return _systemCallArchitectures.get().getSystemCallArchitectures();
}

bool ServiceProxy::hasSystemCallArchitectures() const {
    return _systemCallArchitectures.hasValue();
}

void ServiceProxy::sendSystemCallArchitecturesDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SystemCallArchitectures");
    _dbusProxyDelegate->deregisterSignalCallback("SystemCallArchitectures", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendSystemCallErrorNumberRegister(SystemCallErrorNumberCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_SystemCallErrorNumber, "SystemCallErrorNumber", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SystemCallErrorNumber", &cb, act);
    return act;
}

bool ServiceProxy::sendSystemCallErrorNumberDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SystemCallErrorNumber", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SystemCallErrorNumber", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendSystemCallErrorNumberGet(SystemCallErrorNumberCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_SystemCallErrorNumber, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "SystemCallErrorNumber", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("SystemCallErrorNumber", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


int32 ServiceProxy::getSystemCallErrorNumber() const {
    return _systemCallErrorNumber.get().getSystemCallErrorNumber();
}

bool ServiceProxy::hasSystemCallErrorNumber() const {
    return _systemCallErrorNumber.hasValue();
}

void ServiceProxy::sendSystemCallErrorNumberDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SystemCallErrorNumber");
    _dbusProxyDelegate->deregisterSignalCallback("SystemCallErrorNumber", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendPersonalityRegister(PersonalityCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Personality, "Personality", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Personality", &cb, act);
    return act;
}

bool ServiceProxy::sendPersonalityDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Personality", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Personality", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendPersonalityGet(PersonalityCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_Personality, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Personality", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Personality", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& ServiceProxy::getPersonality() const {
    return _personality.get().getPersonality();
}

bool ServiceProxy::hasPersonality() const {
    return _personality.hasValue();
}

void ServiceProxy::sendPersonalityDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Personality");
    _dbusProxyDelegate->deregisterSignalCallback("Personality", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendRestrictAddressFamiliesRegister(RestrictAddressFamiliesCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_RestrictAddressFamilies, "RestrictAddressFamilies", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "RestrictAddressFamilies", &cb, act);
    return act;
}

bool ServiceProxy::sendRestrictAddressFamiliesDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("RestrictAddressFamilies", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "RestrictAddressFamilies", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendRestrictAddressFamiliesGet(RestrictAddressFamiliesCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_RestrictAddressFamilies, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "RestrictAddressFamilies", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("RestrictAddressFamilies", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const AddressFamily& ServiceProxy::getRestrictAddressFamilies() const {
    return _restrictAddressFamilies.get().getRestrictAddressFamilies();
}

bool ServiceProxy::hasRestrictAddressFamilies() const {
    return _restrictAddressFamilies.hasValue();
}

void ServiceProxy::sendRestrictAddressFamiliesDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "RestrictAddressFamilies");
    _dbusProxyDelegate->deregisterSignalCallback("RestrictAddressFamilies", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendRuntimeDirectoryModeRegister(RuntimeDirectoryModeCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_RuntimeDirectoryMode, "RuntimeDirectoryMode", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "RuntimeDirectoryMode", &cb, act);
    return act;
}

bool ServiceProxy::sendRuntimeDirectoryModeDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("RuntimeDirectoryMode", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "RuntimeDirectoryMode", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendRuntimeDirectoryModeGet(RuntimeDirectoryModeCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_RuntimeDirectoryMode, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "RuntimeDirectoryMode", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("RuntimeDirectoryMode", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint32 ServiceProxy::getRuntimeDirectoryMode() const {
    return _runtimeDirectoryMode.get().getRuntimeDirectoryMode();
}

bool ServiceProxy::hasRuntimeDirectoryMode() const {
    return _runtimeDirectoryMode.hasValue();
}

void ServiceProxy::sendRuntimeDirectoryModeDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "RuntimeDirectoryMode");
    _dbusProxyDelegate->deregisterSignalCallback("RuntimeDirectoryMode", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendRuntimeDirectoryRegister(RuntimeDirectoryCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_RuntimeDirectory, "RuntimeDirectory", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "RuntimeDirectory", &cb, act);
    return act;
}

bool ServiceProxy::sendRuntimeDirectoryDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("RuntimeDirectory", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "RuntimeDirectory", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendRuntimeDirectoryGet(RuntimeDirectoryCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_RuntimeDirectory, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "RuntimeDirectory", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("RuntimeDirectory", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::std::string >& ServiceProxy::getRuntimeDirectory() const {
    return _runtimeDirectory.get().getRuntimeDirectory();
}

bool ServiceProxy::hasRuntimeDirectory() const {
    return _runtimeDirectory.hasValue();
}

void ServiceProxy::sendRuntimeDirectoryDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "RuntimeDirectory");
    _dbusProxyDelegate->deregisterSignalCallback("RuntimeDirectory", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendKillModeRegister(KillModeCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_KillMode, "KillMode", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "KillMode", &cb, act);
    return act;
}

bool ServiceProxy::sendKillModeDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("KillMode", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "KillMode", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendKillModeGet(KillModeCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_KillMode, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "KillMode", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("KillMode", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& ServiceProxy::getKillMode() const {
    return _killMode.get().getKillMode();
}

bool ServiceProxy::hasKillMode() const {
    return _killMode.hasValue();
}

void ServiceProxy::sendKillModeDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "KillMode");
    _dbusProxyDelegate->deregisterSignalCallback("KillMode", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendKillSignalRegister(KillSignalCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_KillSignal, "KillSignal", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "KillSignal", &cb, act);
    return act;
}

bool ServiceProxy::sendKillSignalDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("KillSignal", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "KillSignal", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendKillSignalGet(KillSignalCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_KillSignal, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "KillSignal", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("KillSignal", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


int32 ServiceProxy::getKillSignal() const {
    return _killSignal.get().getKillSignal();
}

bool ServiceProxy::hasKillSignal() const {
    return _killSignal.hasValue();
}

void ServiceProxy::sendKillSignalDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "KillSignal");
    _dbusProxyDelegate->deregisterSignalCallback("KillSignal", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendSendSIGKILLRegister(SendSIGKILLCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_SendSIGKILL, "SendSIGKILL", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SendSIGKILL", &cb, act);
    return act;
}

bool ServiceProxy::sendSendSIGKILLDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SendSIGKILL", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SendSIGKILL", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendSendSIGKILLGet(SendSIGKILLCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_SendSIGKILL, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "SendSIGKILL", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("SendSIGKILL", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool ServiceProxy::getSendSIGKILL() const {
    return _sendSIGKILL.get().getSendSIGKILL();
}

bool ServiceProxy::hasSendSIGKILL() const {
    return _sendSIGKILL.hasValue();
}

void ServiceProxy::sendSendSIGKILLDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SendSIGKILL");
    _dbusProxyDelegate->deregisterSignalCallback("SendSIGKILL", 0, _dbusDaemonProxy.get(), true);
}

act_t ServiceProxy::sendSendSIGHUPRegister(SendSIGHUPCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_SendSIGHUP, "SendSIGHUP", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SendSIGHUP", &cb, act);
    return act;
}

bool ServiceProxy::sendSendSIGHUPDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SendSIGHUP", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SendSIGHUP", act, static_cast<int>(rv));
    return rv;
}

act_t ServiceProxy::sendSendSIGHUPGet(SendSIGHUPCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_SendSIGHUP, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "SendSIGHUP", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("SendSIGHUP", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool ServiceProxy::getSendSIGHUP() const {
    return _sendSIGHUP.get().getSendSIGHUP();
}

bool ServiceProxy::hasSendSIGHUP() const {
    return _sendSIGHUP.hasValue();
}

void ServiceProxy::sendSendSIGHUPDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SendSIGHUP");
    _dbusProxyDelegate->deregisterSignalCallback("SendSIGHUP", 0, _dbusDaemonProxy.get(), true);
}

} // namespace Service
} // namespace systemd1
} // namespace freedesktop
} // namespace org
