/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_FREEDESKTOP_SYSTEMD1_MANAGERSTUB_H
#define ORG_FREEDESKTOP_SYSTEMD1_MANAGERSTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "org/freedesktop/systemd1/Manager.h"
#include <string>
#include <vector>

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

class ManagerStubDelegate;

class ManagerStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the ManagerStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    ManagerStub (const std::string& portName);

    /**
     * Create an instance of the ManagerStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    ManagerStub (const std::string& portName, const std::string& objectPath);

    virtual ~ManagerStub();

    // signal 'UnitNew'

    /**
     * Raise the signal 'UnitNew' and send an update message to registered
     * clients.
     *
     * <b>Documentation of 'UnitNew'</b>:
     *
     * This signal is sent out each time a new unit is loaded.
     * 	    Note that this has little to do with whether a unit is available on disk or not,
     * 	    and simply reflects the units that are currently loaded into memory.
     * 	    The signals take two parameters: the primary unit name and the object path.
     *
     * @param id If the meaning of "id" isn't clear, then there should be a description here.
     *
     * @param unit If the meaning of "unit" isn't clear, then there should be a description here.
     */
    void sendUnitNewSignal(const ::std::string& id, const ::std::string& unit);

    // signal 'UnitRemoved'

    /**
     * Raise the signal 'UnitRemoved' and send an update message to registered
     * clients.
     *
     * <b>Documentation of 'UnitRemoved'</b>:
     *
     * UnitRemoved()
     *
     * @param id If the meaning of "id" isn't clear, then there should be a description here.
     *
     * @param unit If the meaning of "unit" isn't clear, then there should be a description here.
     */
    void sendUnitRemovedSignal(const ::std::string& id, const ::std::string& unit);

    // signal 'JobNew'

    /**
     * Raise the signal 'JobNew' and send an update message to registered
     * clients.
     *
     * <b>Documentation of 'JobNew'</b>:
     *
     * JobNew() and JobRemoved() are sent out each time a new job is queued or dequeued. Both signals take the numeric job ID, the bus path
     * 		and the primary unit name for this job as argument. JobRemoved() also includes a result string, being one of done, canceled, timeout, failed, dependency,
     * 		skipped. done indicates successful execution of a job. canceled indicates that a job has been canceled (via CancelJob() above) before it finished execution
     * 		(this doesn't necessarily mean though that the job operation is actually cancelled too, see above). timeout indicates that the job timeout was reached.
     * 		failed indicates that the job failed. dependency indicates that a job this job has been depending on failed and the job hence has been removed too.
     * 		skipped indicates that a job was skipped because it didn't apply to the units current state.
     *
     * @param id If the meaning of "id" isn't clear, then there should be a description here.
     *
     * @param job If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param unit If the meaning of "unit" isn't clear, then there should be a description here.
     */
    void sendJobNewSignal(uint32 id, const ::std::string& job, const ::std::string& unit);

    // signal 'JobRemoved'

    /**
     * Raise the signal 'JobRemoved' and send an update message to registered
     * clients.
     *
     * <b>Documentation of 'JobRemoved'</b>:
     *
     * JobRemoved()
     *
     * @param id If the meaning of "id" isn't clear, then there should be a description here.
     *
     * @param job If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param unit If the meaning of "unit" isn't clear, then there should be a description here.
     *
     * @param result If the meaning of "result" isn't clear, then there should be a description here.
     */
    void sendJobRemovedSignal(uint32 id, const ::std::string& job, const ::std::string& unit, const ::std::string& result);

    // signal 'StartupFinished'

    /**
     * Raise the signal 'StartupFinished' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'StartupFinished'</b>:
     *
     * StartupFinished() is sent out when startup finished. It carries six usec timespan values each indicating how much boot time has been spent
     * 		in the firmware (if known), in the boot loader (if known), in the kernel initialization phase, in the initrd (if known),
     * 		in userspace and in total. These values may also be calculated from the FirmwareTimestampMonotonic, LoaderTimestampMonotonic,
     * 		InitRDTimestampMonotonic, UserspaceTimestampMonotonic, FinishTimestampMonotonic properties (see below).
     *
     * @param firmware If the meaning of "firmware" isn't clear, then there should be a description here.
     *
     * @param loader If the meaning of "loader" isn't clear, then there should be a description here.
     *
     * @param kernel If the meaning of "kernel" isn't clear, then there should be a description here.
     *
     * @param initrd If the meaning of "initrd" isn't clear, then there should be a description here.
     *
     * @param userspace If the meaning of "userspace" isn't clear, then there should be a description here.
     *
     * @param total If the meaning of "total" isn't clear, then there should be a description here.
     */
    void sendStartupFinishedSignal(uint64 firmware, uint64 loader, uint64 kernel, uint64 initrd, uint64 userspace, uint64 total);

    // signal 'UnitFilesChanged'

    /**
     * Raise the signal 'UnitFilesChanged' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'UnitFilesChanged'</b>:
     *
     * UnitFilesChanged() is sent out each time the list of enabled or masked unit files on disk have changed.
     */
    void sendUnitFilesChangedSignal();

    // signal 'Reloading'

    /**
     * Raise the signal 'Reloading' and send an update message to registered
     * clients.
     *
     * <b>Documentation of 'Reloading'</b>:
     *
     * Reloading() is sent out immediately before a daemon reload is done (with the boolean parameter set to True)
     * 		and after a daemon reload is completed (with the boolean parameter set to False). This may be used by UIs to optimize UI updates.
     *
     * @param active If the meaning of "active" isn't clear, then there should be a description here.
     */
    void sendReloadingSignal(bool active);

    // property 'Version'

    /**
     * The method onVersionGet() is called by ASF when a client invokes the
     * read method for the property 'Version'. The onVersionGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Version'</b>:
     *
     * This encodes encodes the version string of the running
     * 	    systemd instance.
     */
    virtual void onVersionGet(const ::boost::shared_ptr< VersionGet >& payload);

    /**
     * Sends back the update to a previous onVersionGet().
     *
     * <b>Documentation of 'Version'</b>:
     *
     * This encodes encodes the version string of the running
     * 	    systemd instance.
     *
     * @param act Identifies a previous invocation of onVersionGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendVersionGetUpdate(const ::std::string& version, act_t act = 0);

    /**
     * Set the value of the property 'Version' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Version'</b>:
     *
     * This encodes encodes the version string of the running
     * 	    systemd instance.
     */
    void setVersion(const ::std::string& version);

    /**
     * Returns the current value of the property 'Version'.
     *
     * <b>Documentation of 'Version'</b>:
     *
     * This encodes encodes the version string of the running
     * 	    systemd instance.
     */
    const ::std::string& getVersion() const;

    /**
     * Returns the current value of the property 'Version' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendVersionUpdate() method.
     *
     * <b>Documentation of 'Version'</b>:
     *
     * This encodes encodes the version string of the running
     * 	    systemd instance.
     */
    ::std::string& getVersionMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendVersionUpdate().
     *
     * <b>Documentation of 'Version'</b>:
     *
     * This encodes encodes the version string of the running
     * 	    systemd instance.
     */
    void sendVersionUpdate();

    // property 'Features'

    /**
     * The method onFeaturesGet() is called by ASF when a client invokes the
     * read method for the property 'Features'. The onFeaturesGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Features'</b>:
     *
     * Features encodes the features that have been enabled resp. disabled for this build. Enabled options are prefixed with +, disabled options with
     */
    virtual void onFeaturesGet(const ::boost::shared_ptr< FeaturesGet >& payload);

    /**
     * Sends back the update to a previous onFeaturesGet().
     *
     * <b>Documentation of 'Features'</b>:
     *
     * Features encodes the features that have been enabled resp. disabled for this build. Enabled options are prefixed with +, disabled options with
     *
     * @param act Identifies a previous invocation of onFeaturesGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendFeaturesGetUpdate(const ::std::string& features, act_t act = 0);

    /**
     * Set the value of the property 'Features' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Features'</b>:
     *
     * Features encodes the features that have been enabled resp. disabled for this build. Enabled options are prefixed with +, disabled options with
     */
    void setFeatures(const ::std::string& features);

    /**
     * Returns the current value of the property 'Features'.
     *
     * <b>Documentation of 'Features'</b>:
     *
     * Features encodes the features that have been enabled resp. disabled for this build. Enabled options are prefixed with +, disabled options with
     */
    const ::std::string& getFeatures() const;

    /**
     * Returns the current value of the property 'Features' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendFeaturesUpdate() method.
     *
     * <b>Documentation of 'Features'</b>:
     *
     * Features encodes the features that have been enabled resp. disabled for this build. Enabled options are prefixed with +, disabled options with
     */
    ::std::string& getFeaturesMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendFeaturesUpdate().
     *
     * <b>Documentation of 'Features'</b>:
     *
     * Features encodes the features that have been enabled resp. disabled for this build. Enabled options are prefixed with +, disabled options with
     */
    void sendFeaturesUpdate();

    // property 'Virtualization'

    /**
     * The method onVirtualizationGet() is called by ASF when a client invokes
     * the read method for the property 'Virtualization'. The
     * onVirtualizationGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'Virtualization'</b>:
     *
     * Virtualization contains a short ID string describing the virtualization technology the system runs in. On bare-metal hardware
     * 		this is the empty string, otherwise an identifier such as "kvm", "vmware" and so on. For a full list of IDs see systemd-detect-virt(1). Note that
     * 		only the "innermost" virtualization technology is exported here. This detects both full-machine virtualizations (VMs) and shared-kernel virtualization (containers).
     */
    virtual void onVirtualizationGet(const ::boost::shared_ptr< VirtualizationGet >& payload);

    /**
     * Sends back the update to a previous onVirtualizationGet().
     *
     * <b>Documentation of 'Virtualization'</b>:
     *
     * Virtualization contains a short ID string describing the virtualization technology the system runs in. On bare-metal hardware
     * 		this is the empty string, otherwise an identifier such as "kvm", "vmware" and so on. For a full list of IDs see systemd-detect-virt(1). Note that
     * 		only the "innermost" virtualization technology is exported here. This detects both full-machine virtualizations (VMs) and shared-kernel virtualization (containers).
     *
     * @param act Identifies a previous invocation of onVirtualizationGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendVirtualizationGetUpdate(const ::std::string& virtualization, act_t act = 0);

    /**
     * Set the value of the property 'Virtualization' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'Virtualization'</b>:
     *
     * Virtualization contains a short ID string describing the virtualization technology the system runs in. On bare-metal hardware
     * 		this is the empty string, otherwise an identifier such as "kvm", "vmware" and so on. For a full list of IDs see systemd-detect-virt(1). Note that
     * 		only the "innermost" virtualization technology is exported here. This detects both full-machine virtualizations (VMs) and shared-kernel virtualization (containers).
     */
    void setVirtualization(const ::std::string& virtualization);

    /**
     * Returns the current value of the property 'Virtualization'.
     *
     * <b>Documentation of 'Virtualization'</b>:
     *
     * Virtualization contains a short ID string describing the virtualization technology the system runs in. On bare-metal hardware
     * 		this is the empty string, otherwise an identifier such as "kvm", "vmware" and so on. For a full list of IDs see systemd-detect-virt(1). Note that
     * 		only the "innermost" virtualization technology is exported here. This detects both full-machine virtualizations (VMs) and shared-kernel virtualization (containers).
     */
    const ::std::string& getVirtualization() const;

    /**
     * Returns the current value of the property 'Virtualization' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendVirtualizationUpdate() method.
     *
     * <b>Documentation of 'Virtualization'</b>:
     *
     * Virtualization contains a short ID string describing the virtualization technology the system runs in. On bare-metal hardware
     * 		this is the empty string, otherwise an identifier such as "kvm", "vmware" and so on. For a full list of IDs see systemd-detect-virt(1). Note that
     * 		only the "innermost" virtualization technology is exported here. This detects both full-machine virtualizations (VMs) and shared-kernel virtualization (containers).
     */
    ::std::string& getVirtualizationMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendVirtualizationUpdate().
     *
     * <b>Documentation of 'Virtualization'</b>:
     *
     * Virtualization contains a short ID string describing the virtualization technology the system runs in. On bare-metal hardware
     * 		this is the empty string, otherwise an identifier such as "kvm", "vmware" and so on. For a full list of IDs see systemd-detect-virt(1). Note that
     * 		only the "innermost" virtualization technology is exported here. This detects both full-machine virtualizations (VMs) and shared-kernel virtualization (containers).
     */
    void sendVirtualizationUpdate();

    // property 'Architecture'

    /**
     * The method onArchitectureGet() is called by ASF when a client invokes
     * the read method for the property 'Architecture'. The
     * onArchitectureGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'Architecture'</b>:
     *
     * Architecture contains a short ID string describing the architecture the systemd instance is running on.
     * 		This follows the same vocabulary as ConditionArchitectures=.
     */
    virtual void onArchitectureGet(const ::boost::shared_ptr< ArchitectureGet >& payload);

    /**
     * Sends back the update to a previous onArchitectureGet().
     *
     * <b>Documentation of 'Architecture'</b>:
     *
     * Architecture contains a short ID string describing the architecture the systemd instance is running on.
     * 		This follows the same vocabulary as ConditionArchitectures=.
     *
     * @param act Identifies a previous invocation of onArchitectureGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendArchitectureGetUpdate(const ::std::string& architecture, act_t act = 0);

    /**
     * Set the value of the property 'Architecture' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'Architecture'</b>:
     *
     * Architecture contains a short ID string describing the architecture the systemd instance is running on.
     * 		This follows the same vocabulary as ConditionArchitectures=.
     */
    void setArchitecture(const ::std::string& architecture);

    /**
     * Returns the current value of the property 'Architecture'.
     *
     * <b>Documentation of 'Architecture'</b>:
     *
     * Architecture contains a short ID string describing the architecture the systemd instance is running on.
     * 		This follows the same vocabulary as ConditionArchitectures=.
     */
    const ::std::string& getArchitecture() const;

    /**
     * Returns the current value of the property 'Architecture' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendArchitectureUpdate() method.
     *
     * <b>Documentation of 'Architecture'</b>:
     *
     * Architecture contains a short ID string describing the architecture the systemd instance is running on.
     * 		This follows the same vocabulary as ConditionArchitectures=.
     */
    ::std::string& getArchitectureMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendArchitectureUpdate().
     *
     * <b>Documentation of 'Architecture'</b>:
     *
     * Architecture contains a short ID string describing the architecture the systemd instance is running on.
     * 		This follows the same vocabulary as ConditionArchitectures=.
     */
    void sendArchitectureUpdate();

    // property 'Tainted'

    /**
     * The method onTaintedGet() is called by ASF when a client invokes the
     * read method for the property 'Tainted'. The onTaintedGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Tainted'</b>:
     *
     * Tainted encodes a couple of taint flags, as colon separated list.
     * 		When systemd detects it is run on a system with certain problems it will set an appropriate taint flag
     */
    virtual void onTaintedGet(const ::boost::shared_ptr< TaintedGet >& payload);

    /**
     * Sends back the update to a previous onTaintedGet().
     *
     * <b>Documentation of 'Tainted'</b>:
     *
     * Tainted encodes a couple of taint flags, as colon separated list.
     * 		When systemd detects it is run on a system with certain problems it will set an appropriate taint flag
     *
     * @param act Identifies a previous invocation of onTaintedGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendTaintedGetUpdate(const ::std::string& tainted, act_t act = 0);

    /**
     * Set the value of the property 'Tainted' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Tainted'</b>:
     *
     * Tainted encodes a couple of taint flags, as colon separated list.
     * 		When systemd detects it is run on a system with certain problems it will set an appropriate taint flag
     */
    void setTainted(const ::std::string& tainted);

    /**
     * Returns the current value of the property 'Tainted'.
     *
     * <b>Documentation of 'Tainted'</b>:
     *
     * Tainted encodes a couple of taint flags, as colon separated list.
     * 		When systemd detects it is run on a system with certain problems it will set an appropriate taint flag
     */
    const ::std::string& getTainted() const;

    /**
     * Returns the current value of the property 'Tainted' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendTaintedUpdate() method.
     *
     * <b>Documentation of 'Tainted'</b>:
     *
     * Tainted encodes a couple of taint flags, as colon separated list.
     * 		When systemd detects it is run on a system with certain problems it will set an appropriate taint flag
     */
    ::std::string& getTaintedMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendTaintedUpdate().
     *
     * <b>Documentation of 'Tainted'</b>:
     *
     * Tainted encodes a couple of taint flags, as colon separated list.
     * 		When systemd detects it is run on a system with certain problems it will set an appropriate taint flag
     */
    void sendTaintedUpdate();

    // property 'FirmwareTimestamp'

    /**
     * The method onFirmwareTimestampGet() is called by ASF when a client
     * invokes the read method for the property 'FirmwareTimestamp'. The
     * onFirmwareTimestampGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'FirmwareTimestamp'</b>:
     *
     * FirmwareTimestamp, FirmwareTimestampMonotonic, LoaderTimestamp, LoaderTimestampMonotonic, KernelTimestamp, KernelTimestampMonotonic, InitRDTimestamp,
     * 	InitRDTimestampMonotonic, UserspaceTimestamp, UserspaceTimestampMonotonic, FinishTimestamp, FinishTimestampMonotonic encode CLOCK_REALTIME resp.
     * 	CLOCK_MONOTONIC usec timestamps taken when the firmware first began execution, when the boot loader first began execution, when the kernel first began execution,
     * 	when the initrd first began execution, when the main systemd instance began execution and finally, when all queued startup jobs finished execution.
     * 	These values are useful for determining boot-time performance. Note that as monotonic time begins with the kernel startup the KernelTimestampMonotonic
     * 	timestamp will always be 0, and FirmwareTimestampMonotonic and LoaderTimestampMonotonic are to be read as negative values. Also, not all fields are available,
     * 	depending on the used firmware, boot loader or initrd implementation. In these cases the resp. pairs of timestamps are both 0, indicating that no data is available.
     */
    virtual void onFirmwareTimestampGet(const ::boost::shared_ptr< FirmwareTimestampGet >& payload);

    /**
     * Sends back the update to a previous onFirmwareTimestampGet().
     *
     * <b>Documentation of 'FirmwareTimestamp'</b>:
     *
     * FirmwareTimestamp, FirmwareTimestampMonotonic, LoaderTimestamp, LoaderTimestampMonotonic, KernelTimestamp, KernelTimestampMonotonic, InitRDTimestamp,
     * 	InitRDTimestampMonotonic, UserspaceTimestamp, UserspaceTimestampMonotonic, FinishTimestamp, FinishTimestampMonotonic encode CLOCK_REALTIME resp.
     * 	CLOCK_MONOTONIC usec timestamps taken when the firmware first began execution, when the boot loader first began execution, when the kernel first began execution,
     * 	when the initrd first began execution, when the main systemd instance began execution and finally, when all queued startup jobs finished execution.
     * 	These values are useful for determining boot-time performance. Note that as monotonic time begins with the kernel startup the KernelTimestampMonotonic
     * 	timestamp will always be 0, and FirmwareTimestampMonotonic and LoaderTimestampMonotonic are to be read as negative values. Also, not all fields are available,
     * 	depending on the used firmware, boot loader or initrd implementation. In these cases the resp. pairs of timestamps are both 0, indicating that no data is available.
     *
     * @param act Identifies a previous invocation of
     * onFirmwareTimestampGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendFirmwareTimestampGetUpdate(uint64 firmwareTimestamp, act_t act = 0);

    /**
     * Set the value of the property 'FirmwareTimestamp' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'FirmwareTimestamp'</b>:
     *
     * FirmwareTimestamp, FirmwareTimestampMonotonic, LoaderTimestamp, LoaderTimestampMonotonic, KernelTimestamp, KernelTimestampMonotonic, InitRDTimestamp,
     * 	InitRDTimestampMonotonic, UserspaceTimestamp, UserspaceTimestampMonotonic, FinishTimestamp, FinishTimestampMonotonic encode CLOCK_REALTIME resp.
     * 	CLOCK_MONOTONIC usec timestamps taken when the firmware first began execution, when the boot loader first began execution, when the kernel first began execution,
     * 	when the initrd first began execution, when the main systemd instance began execution and finally, when all queued startup jobs finished execution.
     * 	These values are useful for determining boot-time performance. Note that as monotonic time begins with the kernel startup the KernelTimestampMonotonic
     * 	timestamp will always be 0, and FirmwareTimestampMonotonic and LoaderTimestampMonotonic are to be read as negative values. Also, not all fields are available,
     * 	depending on the used firmware, boot loader or initrd implementation. In these cases the resp. pairs of timestamps are both 0, indicating that no data is available.
     */
    void setFirmwareTimestamp(uint64 firmwareTimestamp);

    /**
     * Returns the current value of the property 'FirmwareTimestamp'.
     *
     * <b>Documentation of 'FirmwareTimestamp'</b>:
     *
     * FirmwareTimestamp, FirmwareTimestampMonotonic, LoaderTimestamp, LoaderTimestampMonotonic, KernelTimestamp, KernelTimestampMonotonic, InitRDTimestamp,
     * 	InitRDTimestampMonotonic, UserspaceTimestamp, UserspaceTimestampMonotonic, FinishTimestamp, FinishTimestampMonotonic encode CLOCK_REALTIME resp.
     * 	CLOCK_MONOTONIC usec timestamps taken when the firmware first began execution, when the boot loader first began execution, when the kernel first began execution,
     * 	when the initrd first began execution, when the main systemd instance began execution and finally, when all queued startup jobs finished execution.
     * 	These values are useful for determining boot-time performance. Note that as monotonic time begins with the kernel startup the KernelTimestampMonotonic
     * 	timestamp will always be 0, and FirmwareTimestampMonotonic and LoaderTimestampMonotonic are to be read as negative values. Also, not all fields are available,
     * 	depending on the used firmware, boot loader or initrd implementation. In these cases the resp. pairs of timestamps are both 0, indicating that no data is available.
     */
    uint64 getFirmwareTimestamp() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendFirmwareTimestampUpdate().
     *
     * <b>Documentation of 'FirmwareTimestamp'</b>:
     *
     * FirmwareTimestamp, FirmwareTimestampMonotonic, LoaderTimestamp, LoaderTimestampMonotonic, KernelTimestamp, KernelTimestampMonotonic, InitRDTimestamp,
     * 	InitRDTimestampMonotonic, UserspaceTimestamp, UserspaceTimestampMonotonic, FinishTimestamp, FinishTimestampMonotonic encode CLOCK_REALTIME resp.
     * 	CLOCK_MONOTONIC usec timestamps taken when the firmware first began execution, when the boot loader first began execution, when the kernel first began execution,
     * 	when the initrd first began execution, when the main systemd instance began execution and finally, when all queued startup jobs finished execution.
     * 	These values are useful for determining boot-time performance. Note that as monotonic time begins with the kernel startup the KernelTimestampMonotonic
     * 	timestamp will always be 0, and FirmwareTimestampMonotonic and LoaderTimestampMonotonic are to be read as negative values. Also, not all fields are available,
     * 	depending on the used firmware, boot loader or initrd implementation. In these cases the resp. pairs of timestamps are both 0, indicating that no data is available.
     */
    void sendFirmwareTimestampUpdate();

    // property 'FirmwareTimestampMonotonic'

    /**
     * The method onFirmwareTimestampMonotonicGet() is called by ASF when a
     * client invokes the read method for the property
     * 'FirmwareTimestampMonotonic'. The onFirmwareTimestampMonotonicGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'FirmwareTimestampMonotonic'</b>:
     *
     * FirmwareTimestampMonotonic
     */
    virtual void onFirmwareTimestampMonotonicGet(const ::boost::shared_ptr< FirmwareTimestampMonotonicGet >& payload);

    /**
     * Sends back the update to a previous onFirmwareTimestampMonotonicGet().
     *
     * <b>Documentation of 'FirmwareTimestampMonotonic'</b>:
     *
     * FirmwareTimestampMonotonic
     *
     * @param act Identifies a previous invocation of
     * onFirmwareTimestampMonotonicGet(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendFirmwareTimestampMonotonicGetUpdate(uint64 firmwareTimestampMonotonic, act_t act = 0);

    /**
     * Set the value of the property 'FirmwareTimestampMonotonic' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'FirmwareTimestampMonotonic'</b>:
     *
     * FirmwareTimestampMonotonic
     */
    void setFirmwareTimestampMonotonic(uint64 firmwareTimestampMonotonic);

    /**
     * Returns the current value of the property 'FirmwareTimestampMonotonic'.
     *
     * <b>Documentation of 'FirmwareTimestampMonotonic'</b>:
     *
     * FirmwareTimestampMonotonic
     */
    uint64 getFirmwareTimestampMonotonic() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendFirmwareTimestampMonotonicUpdate().
     *
     * <b>Documentation of 'FirmwareTimestampMonotonic'</b>:
     *
     * FirmwareTimestampMonotonic
     */
    void sendFirmwareTimestampMonotonicUpdate();

    // property 'LoaderTimestamp'

    /**
     * The method onLoaderTimestampGet() is called by ASF when a client
     * invokes the read method for the property 'LoaderTimestamp'. The
     * onLoaderTimestampGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'LoaderTimestamp'</b>:
     *
     * LoaderTimestamp
     */
    virtual void onLoaderTimestampGet(const ::boost::shared_ptr< LoaderTimestampGet >& payload);

    /**
     * Sends back the update to a previous onLoaderTimestampGet().
     *
     * <b>Documentation of 'LoaderTimestamp'</b>:
     *
     * LoaderTimestamp
     *
     * @param act Identifies a previous invocation of onLoaderTimestampGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendLoaderTimestampGetUpdate(uint64 loaderTimestamp, act_t act = 0);

    /**
     * Set the value of the property 'LoaderTimestamp' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'LoaderTimestamp'</b>:
     *
     * LoaderTimestamp
     */
    void setLoaderTimestamp(uint64 loaderTimestamp);

    /**
     * Returns the current value of the property 'LoaderTimestamp'.
     *
     * <b>Documentation of 'LoaderTimestamp'</b>:
     *
     * LoaderTimestamp
     */
    uint64 getLoaderTimestamp() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendLoaderTimestampUpdate().
     *
     * <b>Documentation of 'LoaderTimestamp'</b>:
     *
     * LoaderTimestamp
     */
    void sendLoaderTimestampUpdate();

    // property 'LoaderTimestampMonotonic'

    /**
     * The method onLoaderTimestampMonotonicGet() is called by ASF when a
     * client invokes the read method for the property
     * 'LoaderTimestampMonotonic'. The onLoaderTimestampMonotonicGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'LoaderTimestampMonotonic'</b>:
     *
     * LoaderTimestampMonotonic
     */
    virtual void onLoaderTimestampMonotonicGet(const ::boost::shared_ptr< LoaderTimestampMonotonicGet >& payload);

    /**
     * Sends back the update to a previous onLoaderTimestampMonotonicGet().
     *
     * <b>Documentation of 'LoaderTimestampMonotonic'</b>:
     *
     * LoaderTimestampMonotonic
     *
     * @param act Identifies a previous invocation of
     * onLoaderTimestampMonotonicGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendLoaderTimestampMonotonicGetUpdate(uint64 loaderTimestampMonotonic, act_t act = 0);

    /**
     * Set the value of the property 'LoaderTimestampMonotonic' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'LoaderTimestampMonotonic'</b>:
     *
     * LoaderTimestampMonotonic
     */
    void setLoaderTimestampMonotonic(uint64 loaderTimestampMonotonic);

    /**
     * Returns the current value of the property 'LoaderTimestampMonotonic'.
     *
     * <b>Documentation of 'LoaderTimestampMonotonic'</b>:
     *
     * LoaderTimestampMonotonic
     */
    uint64 getLoaderTimestampMonotonic() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendLoaderTimestampMonotonicUpdate().
     *
     * <b>Documentation of 'LoaderTimestampMonotonic'</b>:
     *
     * LoaderTimestampMonotonic
     */
    void sendLoaderTimestampMonotonicUpdate();

    // property 'KernelTimestamp'

    /**
     * The method onKernelTimestampGet() is called by ASF when a client
     * invokes the read method for the property 'KernelTimestamp'. The
     * onKernelTimestampGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'KernelTimestamp'</b>:
     *
     * KernelTimestamp
     */
    virtual void onKernelTimestampGet(const ::boost::shared_ptr< KernelTimestampGet >& payload);

    /**
     * Sends back the update to a previous onKernelTimestampGet().
     *
     * <b>Documentation of 'KernelTimestamp'</b>:
     *
     * KernelTimestamp
     *
     * @param act Identifies a previous invocation of onKernelTimestampGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendKernelTimestampGetUpdate(uint64 kernelTimestamp, act_t act = 0);

    /**
     * Set the value of the property 'KernelTimestamp' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'KernelTimestamp'</b>:
     *
     * KernelTimestamp
     */
    void setKernelTimestamp(uint64 kernelTimestamp);

    /**
     * Returns the current value of the property 'KernelTimestamp'.
     *
     * <b>Documentation of 'KernelTimestamp'</b>:
     *
     * KernelTimestamp
     */
    uint64 getKernelTimestamp() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendKernelTimestampUpdate().
     *
     * <b>Documentation of 'KernelTimestamp'</b>:
     *
     * KernelTimestamp
     */
    void sendKernelTimestampUpdate();

    // property 'KernelTimestampMonotonic'

    /**
     * The method onKernelTimestampMonotonicGet() is called by ASF when a
     * client invokes the read method for the property
     * 'KernelTimestampMonotonic'. The onKernelTimestampMonotonicGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'KernelTimestampMonotonic'</b>:
     *
     * KernelTimestampMonotonic
     */
    virtual void onKernelTimestampMonotonicGet(const ::boost::shared_ptr< KernelTimestampMonotonicGet >& payload);

    /**
     * Sends back the update to a previous onKernelTimestampMonotonicGet().
     *
     * <b>Documentation of 'KernelTimestampMonotonic'</b>:
     *
     * KernelTimestampMonotonic
     *
     * @param act Identifies a previous invocation of
     * onKernelTimestampMonotonicGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendKernelTimestampMonotonicGetUpdate(uint64 kernelTimestampMonotonic, act_t act = 0);

    /**
     * Set the value of the property 'KernelTimestampMonotonic' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'KernelTimestampMonotonic'</b>:
     *
     * KernelTimestampMonotonic
     */
    void setKernelTimestampMonotonic(uint64 kernelTimestampMonotonic);

    /**
     * Returns the current value of the property 'KernelTimestampMonotonic'.
     *
     * <b>Documentation of 'KernelTimestampMonotonic'</b>:
     *
     * KernelTimestampMonotonic
     */
    uint64 getKernelTimestampMonotonic() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendKernelTimestampMonotonicUpdate().
     *
     * <b>Documentation of 'KernelTimestampMonotonic'</b>:
     *
     * KernelTimestampMonotonic
     */
    void sendKernelTimestampMonotonicUpdate();

    // property 'InitRDTimestamp'

    /**
     * The method onInitRDTimestampGet() is called by ASF when a client
     * invokes the read method for the property 'InitRDTimestamp'. The
     * onInitRDTimestampGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'InitRDTimestamp'</b>:
     *
     * InitRDTimestamp
     */
    virtual void onInitRDTimestampGet(const ::boost::shared_ptr< InitRDTimestampGet >& payload);

    /**
     * Sends back the update to a previous onInitRDTimestampGet().
     *
     * <b>Documentation of 'InitRDTimestamp'</b>:
     *
     * InitRDTimestamp
     *
     * @param act Identifies a previous invocation of onInitRDTimestampGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendInitRDTimestampGetUpdate(uint64 initRDTimestamp, act_t act = 0);

    /**
     * Set the value of the property 'InitRDTimestamp' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'InitRDTimestamp'</b>:
     *
     * InitRDTimestamp
     */
    void setInitRDTimestamp(uint64 initRDTimestamp);

    /**
     * Returns the current value of the property 'InitRDTimestamp'.
     *
     * <b>Documentation of 'InitRDTimestamp'</b>:
     *
     * InitRDTimestamp
     */
    uint64 getInitRDTimestamp() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendInitRDTimestampUpdate().
     *
     * <b>Documentation of 'InitRDTimestamp'</b>:
     *
     * InitRDTimestamp
     */
    void sendInitRDTimestampUpdate();

    // property 'InitRDTimestampMonotonic'

    /**
     * The method onInitRDTimestampMonotonicGet() is called by ASF when a
     * client invokes the read method for the property
     * 'InitRDTimestampMonotonic'. The onInitRDTimestampMonotonicGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'InitRDTimestampMonotonic'</b>:
     *
     * InitRDTimestampMonotonic
     */
    virtual void onInitRDTimestampMonotonicGet(const ::boost::shared_ptr< InitRDTimestampMonotonicGet >& payload);

    /**
     * Sends back the update to a previous onInitRDTimestampMonotonicGet().
     *
     * <b>Documentation of 'InitRDTimestampMonotonic'</b>:
     *
     * InitRDTimestampMonotonic
     *
     * @param act Identifies a previous invocation of
     * onInitRDTimestampMonotonicGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendInitRDTimestampMonotonicGetUpdate(uint64 initRDTimestampMonotonic, act_t act = 0);

    /**
     * Set the value of the property 'InitRDTimestampMonotonic' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'InitRDTimestampMonotonic'</b>:
     *
     * InitRDTimestampMonotonic
     */
    void setInitRDTimestampMonotonic(uint64 initRDTimestampMonotonic);

    /**
     * Returns the current value of the property 'InitRDTimestampMonotonic'.
     *
     * <b>Documentation of 'InitRDTimestampMonotonic'</b>:
     *
     * InitRDTimestampMonotonic
     */
    uint64 getInitRDTimestampMonotonic() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendInitRDTimestampMonotonicUpdate().
     *
     * <b>Documentation of 'InitRDTimestampMonotonic'</b>:
     *
     * InitRDTimestampMonotonic
     */
    void sendInitRDTimestampMonotonicUpdate();

    // property 'UserspaceTimestamp'

    /**
     * The method onUserspaceTimestampGet() is called by ASF when a client
     * invokes the read method for the property 'UserspaceTimestamp'. The
     * onUserspaceTimestampGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'UserspaceTimestamp'</b>:
     *
     * UserspaceTimestamp
     */
    virtual void onUserspaceTimestampGet(const ::boost::shared_ptr< UserspaceTimestampGet >& payload);

    /**
     * Sends back the update to a previous onUserspaceTimestampGet().
     *
     * <b>Documentation of 'UserspaceTimestamp'</b>:
     *
     * UserspaceTimestamp
     *
     * @param act Identifies a previous invocation of
     * onUserspaceTimestampGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendUserspaceTimestampGetUpdate(uint64 userspaceTimestamp, act_t act = 0);

    /**
     * Set the value of the property 'UserspaceTimestamp' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'UserspaceTimestamp'</b>:
     *
     * UserspaceTimestamp
     */
    void setUserspaceTimestamp(uint64 userspaceTimestamp);

    /**
     * Returns the current value of the property 'UserspaceTimestamp'.
     *
     * <b>Documentation of 'UserspaceTimestamp'</b>:
     *
     * UserspaceTimestamp
     */
    uint64 getUserspaceTimestamp() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendUserspaceTimestampUpdate().
     *
     * <b>Documentation of 'UserspaceTimestamp'</b>:
     *
     * UserspaceTimestamp
     */
    void sendUserspaceTimestampUpdate();

    // property 'UserspaceTimestampMonotonic'

    /**
     * The method onUserspaceTimestampMonotonicGet() is called by ASF when a
     * client invokes the read method for the property
     * 'UserspaceTimestampMonotonic'. The onUserspaceTimestampMonotonicGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'UserspaceTimestampMonotonic'</b>:
     *
     * UserspaceTimestampMonotonic
     */
    virtual void onUserspaceTimestampMonotonicGet(const ::boost::shared_ptr< UserspaceTimestampMonotonicGet >& payload);

    /**
     * Sends back the update to a previous onUserspaceTimestampMonotonicGet().
     *
     * <b>Documentation of 'UserspaceTimestampMonotonic'</b>:
     *
     * UserspaceTimestampMonotonic
     *
     * @param act Identifies a previous invocation of
     * onUserspaceTimestampMonotonicGet(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendUserspaceTimestampMonotonicGetUpdate(uint64 userspaceTimestampMonotonic, act_t act = 0);

    /**
     * Set the value of the property 'UserspaceTimestampMonotonic' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'UserspaceTimestampMonotonic'</b>:
     *
     * UserspaceTimestampMonotonic
     */
    void setUserspaceTimestampMonotonic(uint64 userspaceTimestampMonotonic);

    /**
     * Returns the current value of the property 'UserspaceTimestampMonotonic'.
     *
     * <b>Documentation of 'UserspaceTimestampMonotonic'</b>:
     *
     * UserspaceTimestampMonotonic
     */
    uint64 getUserspaceTimestampMonotonic() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendUserspaceTimestampMonotonicUpdate().
     *
     * <b>Documentation of 'UserspaceTimestampMonotonic'</b>:
     *
     * UserspaceTimestampMonotonic
     */
    void sendUserspaceTimestampMonotonicUpdate();

    // property 'FinishTimestamp'

    /**
     * The method onFinishTimestampGet() is called by ASF when a client
     * invokes the read method for the property 'FinishTimestamp'. The
     * onFinishTimestampGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'FinishTimestamp'</b>:
     *
     * FinishTimestamp
     */
    virtual void onFinishTimestampGet(const ::boost::shared_ptr< FinishTimestampGet >& payload);

    /**
     * Sends back the update to a previous onFinishTimestampGet().
     *
     * <b>Documentation of 'FinishTimestamp'</b>:
     *
     * FinishTimestamp
     *
     * @param act Identifies a previous invocation of onFinishTimestampGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendFinishTimestampGetUpdate(uint64 finishTimestamp, act_t act = 0);

    /**
     * Set the value of the property 'FinishTimestamp' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'FinishTimestamp'</b>:
     *
     * FinishTimestamp
     */
    void setFinishTimestamp(uint64 finishTimestamp);

    /**
     * Returns the current value of the property 'FinishTimestamp'.
     *
     * <b>Documentation of 'FinishTimestamp'</b>:
     *
     * FinishTimestamp
     */
    uint64 getFinishTimestamp() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendFinishTimestampUpdate().
     *
     * <b>Documentation of 'FinishTimestamp'</b>:
     *
     * FinishTimestamp
     */
    void sendFinishTimestampUpdate();

    // property 'FinishTimestampMonotonic'

    /**
     * The method onFinishTimestampMonotonicGet() is called by ASF when a
     * client invokes the read method for the property
     * 'FinishTimestampMonotonic'. The onFinishTimestampMonotonicGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'FinishTimestampMonotonic'</b>:
     *
     * FinishTimestampMonotonic
     */
    virtual void onFinishTimestampMonotonicGet(const ::boost::shared_ptr< FinishTimestampMonotonicGet >& payload);

    /**
     * Sends back the update to a previous onFinishTimestampMonotonicGet().
     *
     * <b>Documentation of 'FinishTimestampMonotonic'</b>:
     *
     * FinishTimestampMonotonic
     *
     * @param act Identifies a previous invocation of
     * onFinishTimestampMonotonicGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendFinishTimestampMonotonicGetUpdate(uint64 finishTimestampMonotonic, act_t act = 0);

    /**
     * Set the value of the property 'FinishTimestampMonotonic' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'FinishTimestampMonotonic'</b>:
     *
     * FinishTimestampMonotonic
     */
    void setFinishTimestampMonotonic(uint64 finishTimestampMonotonic);

    /**
     * Returns the current value of the property 'FinishTimestampMonotonic'.
     *
     * <b>Documentation of 'FinishTimestampMonotonic'</b>:
     *
     * FinishTimestampMonotonic
     */
    uint64 getFinishTimestampMonotonic() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendFinishTimestampMonotonicUpdate().
     *
     * <b>Documentation of 'FinishTimestampMonotonic'</b>:
     *
     * FinishTimestampMonotonic
     */
    void sendFinishTimestampMonotonicUpdate();

    // property 'SecurityStartTimestamp'

    /**
     * The method onSecurityStartTimestampGet() is called by ASF when a client
     * invokes the read method for the property 'SecurityStartTimestamp'. The
     * onSecurityStartTimestampGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'SecurityStartTimestamp'</b>:
     *
     * SecurityStartTimestamp
     */
    virtual void onSecurityStartTimestampGet(const ::boost::shared_ptr< SecurityStartTimestampGet >& payload);

    /**
     * Sends back the update to a previous onSecurityStartTimestampGet().
     *
     * <b>Documentation of 'SecurityStartTimestamp'</b>:
     *
     * SecurityStartTimestamp
     *
     * @param act Identifies a previous invocation of
     * onSecurityStartTimestampGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSecurityStartTimestampGetUpdate(uint64 securityStartTimestamp, act_t act = 0);

    /**
     * Set the value of the property 'SecurityStartTimestamp' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'SecurityStartTimestamp'</b>:
     *
     * SecurityStartTimestamp
     */
    void setSecurityStartTimestamp(uint64 securityStartTimestamp);

    /**
     * Returns the current value of the property 'SecurityStartTimestamp'.
     *
     * <b>Documentation of 'SecurityStartTimestamp'</b>:
     *
     * SecurityStartTimestamp
     */
    uint64 getSecurityStartTimestamp() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSecurityStartTimestampUpdate().
     *
     * <b>Documentation of 'SecurityStartTimestamp'</b>:
     *
     * SecurityStartTimestamp
     */
    void sendSecurityStartTimestampUpdate();

    // property 'SecurityStartTimestampMonotonic'

    /**
     * The method onSecurityStartTimestampMonotonicGet() is called by ASF when
     * a client invokes the read method for the property
     * 'SecurityStartTimestampMonotonic'. The
     * onSecurityStartTimestampMonotonicGet() method returns by default the
     * current property value to the caller. In case this default behavior
     * doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'SecurityStartTimestampMonotonic'</b>:
     *
     * SecurityStartTimestampMonotonic
     */
    virtual void onSecurityStartTimestampMonotonicGet(const ::boost::shared_ptr< SecurityStartTimestampMonotonicGet >& payload);

    /**
     * Sends back the update to a previous
     * onSecurityStartTimestampMonotonicGet().
     *
     * <b>Documentation of 'SecurityStartTimestampMonotonic'</b>:
     *
     * SecurityStartTimestampMonotonic
     *
     * @param act Identifies a previous invocation of
     * onSecurityStartTimestampMonotonicGet(). If the act is not specified,
     * i.e. the most recent invocation will be answered. In case multiple
     * replies are pending an act must be specified. An assertion will be
     * thrown if no or multiple method invocation could be found.
     */
    void sendSecurityStartTimestampMonotonicGetUpdate(uint64 securityStartTimestampMonotonic, act_t act = 0);

    /**
     * Set the value of the property 'SecurityStartTimestampMonotonic' and
     * send updates to registered clients. No updates will be sent if the
     * property value does not change.
     *
     * <b>Documentation of 'SecurityStartTimestampMonotonic'</b>:
     *
     * SecurityStartTimestampMonotonic
     */
    void setSecurityStartTimestampMonotonic(uint64 securityStartTimestampMonotonic);

    /**
     * Returns the current value of the property 'SecurityStartTimestampMonotonic'.
     *
     * <b>Documentation of 'SecurityStartTimestampMonotonic'</b>:
     *
     * SecurityStartTimestampMonotonic
     */
    uint64 getSecurityStartTimestampMonotonic() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSecurityStartTimestampMonotonicUpdate().
     *
     * <b>Documentation of 'SecurityStartTimestampMonotonic'</b>:
     *
     * SecurityStartTimestampMonotonic
     */
    void sendSecurityStartTimestampMonotonicUpdate();

    // property 'SecurityFinishTimestamp'

    /**
     * The method onSecurityFinishTimestampGet() is called by ASF when a
     * client invokes the read method for the property
     * 'SecurityFinishTimestamp'. The onSecurityFinishTimestampGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'SecurityFinishTimestamp'</b>:
     *
     * SecurityFinishTimestamp
     */
    virtual void onSecurityFinishTimestampGet(const ::boost::shared_ptr< SecurityFinishTimestampGet >& payload);

    /**
     * Sends back the update to a previous onSecurityFinishTimestampGet().
     *
     * <b>Documentation of 'SecurityFinishTimestamp'</b>:
     *
     * SecurityFinishTimestamp
     *
     * @param act Identifies a previous invocation of
     * onSecurityFinishTimestampGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSecurityFinishTimestampGetUpdate(uint64 securityFinishTimestamp, act_t act = 0);

    /**
     * Set the value of the property 'SecurityFinishTimestamp' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'SecurityFinishTimestamp'</b>:
     *
     * SecurityFinishTimestamp
     */
    void setSecurityFinishTimestamp(uint64 securityFinishTimestamp);

    /**
     * Returns the current value of the property 'SecurityFinishTimestamp'.
     *
     * <b>Documentation of 'SecurityFinishTimestamp'</b>:
     *
     * SecurityFinishTimestamp
     */
    uint64 getSecurityFinishTimestamp() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSecurityFinishTimestampUpdate().
     *
     * <b>Documentation of 'SecurityFinishTimestamp'</b>:
     *
     * SecurityFinishTimestamp
     */
    void sendSecurityFinishTimestampUpdate();

    // property 'SecurityFinishTimestampMonotonic'

    /**
     * The method onSecurityFinishTimestampMonotonicGet() is called by ASF
     * when a client invokes the read method for the property
     * 'SecurityFinishTimestampMonotonic'. The
     * onSecurityFinishTimestampMonotonicGet() method returns by default the
     * current property value to the caller. In case this default behavior
     * doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'SecurityFinishTimestampMonotonic'</b>:
     *
     * SecurityFinishTimestampMonotonic
     */
    virtual void onSecurityFinishTimestampMonotonicGet(const ::boost::shared_ptr< SecurityFinishTimestampMonotonicGet >& payload);

    /**
     * Sends back the update to a previous
     * onSecurityFinishTimestampMonotonicGet().
     *
     * <b>Documentation of 'SecurityFinishTimestampMonotonic'</b>:
     *
     * SecurityFinishTimestampMonotonic
     *
     * @param act Identifies a previous invocation of
     * onSecurityFinishTimestampMonotonicGet(). If the act is not specified,
     * i.e. the most recent invocation will be answered. In case multiple
     * replies are pending an act must be specified. An assertion will be
     * thrown if no or multiple method invocation could be found.
     */
    void sendSecurityFinishTimestampMonotonicGetUpdate(uint64 securityFinishTimestampMonotonic, act_t act = 0);

    /**
     * Set the value of the property 'SecurityFinishTimestampMonotonic' and
     * send updates to registered clients. No updates will be sent if the
     * property value does not change.
     *
     * <b>Documentation of 'SecurityFinishTimestampMonotonic'</b>:
     *
     * SecurityFinishTimestampMonotonic
     */
    void setSecurityFinishTimestampMonotonic(uint64 securityFinishTimestampMonotonic);

    /**
     * Returns the current value of the property 'SecurityFinishTimestampMonotonic'.
     *
     * <b>Documentation of 'SecurityFinishTimestampMonotonic'</b>:
     *
     * SecurityFinishTimestampMonotonic
     */
    uint64 getSecurityFinishTimestampMonotonic() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSecurityFinishTimestampMonotonicUpdate().
     *
     * <b>Documentation of 'SecurityFinishTimestampMonotonic'</b>:
     *
     * SecurityFinishTimestampMonotonic
     */
    void sendSecurityFinishTimestampMonotonicUpdate();

    // property 'GeneratorsStartTimestamp'

    /**
     * The method onGeneratorsStartTimestampGet() is called by ASF when a
     * client invokes the read method for the property
     * 'GeneratorsStartTimestamp'. The onGeneratorsStartTimestampGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'GeneratorsStartTimestamp'</b>:
     *
     * GeneratorsStartTimestamp
     */
    virtual void onGeneratorsStartTimestampGet(const ::boost::shared_ptr< GeneratorsStartTimestampGet >& payload);

    /**
     * Sends back the update to a previous onGeneratorsStartTimestampGet().
     *
     * <b>Documentation of 'GeneratorsStartTimestamp'</b>:
     *
     * GeneratorsStartTimestamp
     *
     * @param act Identifies a previous invocation of
     * onGeneratorsStartTimestampGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendGeneratorsStartTimestampGetUpdate(uint64 generatorsStartTimestamp, act_t act = 0);

    /**
     * Set the value of the property 'GeneratorsStartTimestamp' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'GeneratorsStartTimestamp'</b>:
     *
     * GeneratorsStartTimestamp
     */
    void setGeneratorsStartTimestamp(uint64 generatorsStartTimestamp);

    /**
     * Returns the current value of the property 'GeneratorsStartTimestamp'.
     *
     * <b>Documentation of 'GeneratorsStartTimestamp'</b>:
     *
     * GeneratorsStartTimestamp
     */
    uint64 getGeneratorsStartTimestamp() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendGeneratorsStartTimestampUpdate().
     *
     * <b>Documentation of 'GeneratorsStartTimestamp'</b>:
     *
     * GeneratorsStartTimestamp
     */
    void sendGeneratorsStartTimestampUpdate();

    // property 'GeneratorsStartTimestampMonotonic'

    /**
     * The method onGeneratorsStartTimestampMonotonicGet() is called by ASF
     * when a client invokes the read method for the property
     * 'GeneratorsStartTimestampMonotonic'. The
     * onGeneratorsStartTimestampMonotonicGet() method returns by default the
     * current property value to the caller. In case this default behavior
     * doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'GeneratorsStartTimestampMonotonic'</b>:
     *
     * GeneratorsStartTimestampMonotonic
     */
    virtual void onGeneratorsStartTimestampMonotonicGet(const ::boost::shared_ptr< GeneratorsStartTimestampMonotonicGet >& payload);

    /**
     * Sends back the update to a previous
     * onGeneratorsStartTimestampMonotonicGet().
     *
     * <b>Documentation of 'GeneratorsStartTimestampMonotonic'</b>:
     *
     * GeneratorsStartTimestampMonotonic
     *
     * @param act Identifies a previous invocation of
     * onGeneratorsStartTimestampMonotonicGet(). If the act is not specified,
     * i.e. the most recent invocation will be answered. In case multiple
     * replies are pending an act must be specified. An assertion will be
     * thrown if no or multiple method invocation could be found.
     */
    void sendGeneratorsStartTimestampMonotonicGetUpdate(uint64 generatorsStartTimestampMonotonic, act_t act = 0);

    /**
     * Set the value of the property 'GeneratorsStartTimestampMonotonic' and
     * send updates to registered clients. No updates will be sent if the
     * property value does not change.
     *
     * <b>Documentation of 'GeneratorsStartTimestampMonotonic'</b>:
     *
     * GeneratorsStartTimestampMonotonic
     */
    void setGeneratorsStartTimestampMonotonic(uint64 generatorsStartTimestampMonotonic);

    /**
     * Returns the current value of the property 'GeneratorsStartTimestampMonotonic'.
     *
     * <b>Documentation of 'GeneratorsStartTimestampMonotonic'</b>:
     *
     * GeneratorsStartTimestampMonotonic
     */
    uint64 getGeneratorsStartTimestampMonotonic() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendGeneratorsStartTimestampMonotonicUpdate().
     *
     * <b>Documentation of 'GeneratorsStartTimestampMonotonic'</b>:
     *
     * GeneratorsStartTimestampMonotonic
     */
    void sendGeneratorsStartTimestampMonotonicUpdate();

    // property 'GeneratorsFinishTimestamp'

    /**
     * The method onGeneratorsFinishTimestampGet() is called by ASF when a
     * client invokes the read method for the property
     * 'GeneratorsFinishTimestamp'. The onGeneratorsFinishTimestampGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'GeneratorsFinishTimestamp'</b>:
     *
     * GeneratorsFinishTimestamp
     */
    virtual void onGeneratorsFinishTimestampGet(const ::boost::shared_ptr< GeneratorsFinishTimestampGet >& payload);

    /**
     * Sends back the update to a previous onGeneratorsFinishTimestampGet().
     *
     * <b>Documentation of 'GeneratorsFinishTimestamp'</b>:
     *
     * GeneratorsFinishTimestamp
     *
     * @param act Identifies a previous invocation of
     * onGeneratorsFinishTimestampGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendGeneratorsFinishTimestampGetUpdate(uint64 generatorsFinishTimestamp, act_t act = 0);

    /**
     * Set the value of the property 'GeneratorsFinishTimestamp' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'GeneratorsFinishTimestamp'</b>:
     *
     * GeneratorsFinishTimestamp
     */
    void setGeneratorsFinishTimestamp(uint64 generatorsFinishTimestamp);

    /**
     * Returns the current value of the property 'GeneratorsFinishTimestamp'.
     *
     * <b>Documentation of 'GeneratorsFinishTimestamp'</b>:
     *
     * GeneratorsFinishTimestamp
     */
    uint64 getGeneratorsFinishTimestamp() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendGeneratorsFinishTimestampUpdate().
     *
     * <b>Documentation of 'GeneratorsFinishTimestamp'</b>:
     *
     * GeneratorsFinishTimestamp
     */
    void sendGeneratorsFinishTimestampUpdate();

    // property 'GeneratorsFinishTimestampMonotonic'

    /**
     * The method onGeneratorsFinishTimestampMonotonicGet() is called by ASF
     * when a client invokes the read method for the property
     * 'GeneratorsFinishTimestampMonotonic'. The
     * onGeneratorsFinishTimestampMonotonicGet() method returns by default the
     * current property value to the caller. In case this default behavior
     * doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'GeneratorsFinishTimestampMonotonic'</b>:
     *
     * GeneratorsFinishTimestampMonotonic
     */
    virtual void onGeneratorsFinishTimestampMonotonicGet(const ::boost::shared_ptr< GeneratorsFinishTimestampMonotonicGet >& payload);

    /**
     * Sends back the update to a previous
     * onGeneratorsFinishTimestampMonotonicGet().
     *
     * <b>Documentation of 'GeneratorsFinishTimestampMonotonic'</b>:
     *
     * GeneratorsFinishTimestampMonotonic
     *
     * @param act Identifies a previous invocation of
     * onGeneratorsFinishTimestampMonotonicGet(). If the act is not specified,
     * i.e. the most recent invocation will be answered. In case multiple
     * replies are pending an act must be specified. An assertion will be
     * thrown if no or multiple method invocation could be found.
     */
    void sendGeneratorsFinishTimestampMonotonicGetUpdate(uint64 generatorsFinishTimestampMonotonic, act_t act = 0);

    /**
     * Set the value of the property 'GeneratorsFinishTimestampMonotonic' and
     * send updates to registered clients. No updates will be sent if the
     * property value does not change.
     *
     * <b>Documentation of 'GeneratorsFinishTimestampMonotonic'</b>:
     *
     * GeneratorsFinishTimestampMonotonic
     */
    void setGeneratorsFinishTimestampMonotonic(uint64 generatorsFinishTimestampMonotonic);

    /**
     * Returns the current value of the property 'GeneratorsFinishTimestampMonotonic'.
     *
     * <b>Documentation of 'GeneratorsFinishTimestampMonotonic'</b>:
     *
     * GeneratorsFinishTimestampMonotonic
     */
    uint64 getGeneratorsFinishTimestampMonotonic() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendGeneratorsFinishTimestampMonotonicUpdate().
     *
     * <b>Documentation of 'GeneratorsFinishTimestampMonotonic'</b>:
     *
     * GeneratorsFinishTimestampMonotonic
     */
    void sendGeneratorsFinishTimestampMonotonicUpdate();

    // property 'UnitsLoadStartTimestamp'

    /**
     * The method onUnitsLoadStartTimestampGet() is called by ASF when a
     * client invokes the read method for the property
     * 'UnitsLoadStartTimestamp'. The onUnitsLoadStartTimestampGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'UnitsLoadStartTimestamp'</b>:
     *
     * UnitsLoadStartTimestamp
     */
    virtual void onUnitsLoadStartTimestampGet(const ::boost::shared_ptr< UnitsLoadStartTimestampGet >& payload);

    /**
     * Sends back the update to a previous onUnitsLoadStartTimestampGet().
     *
     * <b>Documentation of 'UnitsLoadStartTimestamp'</b>:
     *
     * UnitsLoadStartTimestamp
     *
     * @param act Identifies a previous invocation of
     * onUnitsLoadStartTimestampGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendUnitsLoadStartTimestampGetUpdate(uint64 unitsLoadStartTimestamp, act_t act = 0);

    /**
     * Set the value of the property 'UnitsLoadStartTimestamp' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'UnitsLoadStartTimestamp'</b>:
     *
     * UnitsLoadStartTimestamp
     */
    void setUnitsLoadStartTimestamp(uint64 unitsLoadStartTimestamp);

    /**
     * Returns the current value of the property 'UnitsLoadStartTimestamp'.
     *
     * <b>Documentation of 'UnitsLoadStartTimestamp'</b>:
     *
     * UnitsLoadStartTimestamp
     */
    uint64 getUnitsLoadStartTimestamp() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendUnitsLoadStartTimestampUpdate().
     *
     * <b>Documentation of 'UnitsLoadStartTimestamp'</b>:
     *
     * UnitsLoadStartTimestamp
     */
    void sendUnitsLoadStartTimestampUpdate();

    // property 'UnitsLoadStartTimestampMonotonic'

    /**
     * The method onUnitsLoadStartTimestampMonotonicGet() is called by ASF
     * when a client invokes the read method for the property
     * 'UnitsLoadStartTimestampMonotonic'. The
     * onUnitsLoadStartTimestampMonotonicGet() method returns by default the
     * current property value to the caller. In case this default behavior
     * doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'UnitsLoadStartTimestampMonotonic'</b>:
     *
     * UnitsLoadStartTimestampMonotonic
     */
    virtual void onUnitsLoadStartTimestampMonotonicGet(const ::boost::shared_ptr< UnitsLoadStartTimestampMonotonicGet >& payload);

    /**
     * Sends back the update to a previous
     * onUnitsLoadStartTimestampMonotonicGet().
     *
     * <b>Documentation of 'UnitsLoadStartTimestampMonotonic'</b>:
     *
     * UnitsLoadStartTimestampMonotonic
     *
     * @param act Identifies a previous invocation of
     * onUnitsLoadStartTimestampMonotonicGet(). If the act is not specified,
     * i.e. the most recent invocation will be answered. In case multiple
     * replies are pending an act must be specified. An assertion will be
     * thrown if no or multiple method invocation could be found.
     */
    void sendUnitsLoadStartTimestampMonotonicGetUpdate(uint64 unitsLoadStartTimestampMonotonic, act_t act = 0);

    /**
     * Set the value of the property 'UnitsLoadStartTimestampMonotonic' and
     * send updates to registered clients. No updates will be sent if the
     * property value does not change.
     *
     * <b>Documentation of 'UnitsLoadStartTimestampMonotonic'</b>:
     *
     * UnitsLoadStartTimestampMonotonic
     */
    void setUnitsLoadStartTimestampMonotonic(uint64 unitsLoadStartTimestampMonotonic);

    /**
     * Returns the current value of the property 'UnitsLoadStartTimestampMonotonic'.
     *
     * <b>Documentation of 'UnitsLoadStartTimestampMonotonic'</b>:
     *
     * UnitsLoadStartTimestampMonotonic
     */
    uint64 getUnitsLoadStartTimestampMonotonic() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendUnitsLoadStartTimestampMonotonicUpdate().
     *
     * <b>Documentation of 'UnitsLoadStartTimestampMonotonic'</b>:
     *
     * UnitsLoadStartTimestampMonotonic
     */
    void sendUnitsLoadStartTimestampMonotonicUpdate();

    // property 'UnitsLoadFinishTimestamp'

    /**
     * The method onUnitsLoadFinishTimestampGet() is called by ASF when a
     * client invokes the read method for the property
     * 'UnitsLoadFinishTimestamp'. The onUnitsLoadFinishTimestampGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'UnitsLoadFinishTimestamp'</b>:
     *
     * UnitsLoadFinishTimestamp
     */
    virtual void onUnitsLoadFinishTimestampGet(const ::boost::shared_ptr< UnitsLoadFinishTimestampGet >& payload);

    /**
     * Sends back the update to a previous onUnitsLoadFinishTimestampGet().
     *
     * <b>Documentation of 'UnitsLoadFinishTimestamp'</b>:
     *
     * UnitsLoadFinishTimestamp
     *
     * @param act Identifies a previous invocation of
     * onUnitsLoadFinishTimestampGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendUnitsLoadFinishTimestampGetUpdate(uint64 unitsLoadFinishTimestamp, act_t act = 0);

    /**
     * Set the value of the property 'UnitsLoadFinishTimestamp' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'UnitsLoadFinishTimestamp'</b>:
     *
     * UnitsLoadFinishTimestamp
     */
    void setUnitsLoadFinishTimestamp(uint64 unitsLoadFinishTimestamp);

    /**
     * Returns the current value of the property 'UnitsLoadFinishTimestamp'.
     *
     * <b>Documentation of 'UnitsLoadFinishTimestamp'</b>:
     *
     * UnitsLoadFinishTimestamp
     */
    uint64 getUnitsLoadFinishTimestamp() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendUnitsLoadFinishTimestampUpdate().
     *
     * <b>Documentation of 'UnitsLoadFinishTimestamp'</b>:
     *
     * UnitsLoadFinishTimestamp
     */
    void sendUnitsLoadFinishTimestampUpdate();

    // property 'UnitsLoadFinishTimestampMonotonic'

    /**
     * The method onUnitsLoadFinishTimestampMonotonicGet() is called by ASF
     * when a client invokes the read method for the property
     * 'UnitsLoadFinishTimestampMonotonic'. The
     * onUnitsLoadFinishTimestampMonotonicGet() method returns by default the
     * current property value to the caller. In case this default behavior
     * doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'UnitsLoadFinishTimestampMonotonic'</b>:
     *
     * UnitsLoadFinishTimestampMonotonic
     */
    virtual void onUnitsLoadFinishTimestampMonotonicGet(const ::boost::shared_ptr< UnitsLoadFinishTimestampMonotonicGet >& payload);

    /**
     * Sends back the update to a previous
     * onUnitsLoadFinishTimestampMonotonicGet().
     *
     * <b>Documentation of 'UnitsLoadFinishTimestampMonotonic'</b>:
     *
     * UnitsLoadFinishTimestampMonotonic
     *
     * @param act Identifies a previous invocation of
     * onUnitsLoadFinishTimestampMonotonicGet(). If the act is not specified,
     * i.e. the most recent invocation will be answered. In case multiple
     * replies are pending an act must be specified. An assertion will be
     * thrown if no or multiple method invocation could be found.
     */
    void sendUnitsLoadFinishTimestampMonotonicGetUpdate(uint64 unitsLoadFinishTimestampMonotonic, act_t act = 0);

    /**
     * Set the value of the property 'UnitsLoadFinishTimestampMonotonic' and
     * send updates to registered clients. No updates will be sent if the
     * property value does not change.
     *
     * <b>Documentation of 'UnitsLoadFinishTimestampMonotonic'</b>:
     *
     * UnitsLoadFinishTimestampMonotonic
     */
    void setUnitsLoadFinishTimestampMonotonic(uint64 unitsLoadFinishTimestampMonotonic);

    /**
     * Returns the current value of the property 'UnitsLoadFinishTimestampMonotonic'.
     *
     * <b>Documentation of 'UnitsLoadFinishTimestampMonotonic'</b>:
     *
     * UnitsLoadFinishTimestampMonotonic
     */
    uint64 getUnitsLoadFinishTimestampMonotonic() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendUnitsLoadFinishTimestampMonotonicUpdate().
     *
     * <b>Documentation of 'UnitsLoadFinishTimestampMonotonic'</b>:
     *
     * UnitsLoadFinishTimestampMonotonic
     */
    void sendUnitsLoadFinishTimestampMonotonicUpdate();

    // property 'LogLevel'

    /**
     * The method onLogLevelGet() is called by ASF when a client invokes the
     * read method for the property 'LogLevel'. The onLogLevelGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'LogLevel'</b>:
     *
     * LogLevel
     */
    virtual void onLogLevelGet(const ::boost::shared_ptr< LogLevelGet >& payload);

    /**
     * Sends back the update to a previous onLogLevelGet().
     *
     * <b>Documentation of 'LogLevel'</b>:
     *
     * LogLevel
     *
     * @param act Identifies a previous invocation of onLogLevelGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendLogLevelGetUpdate(const ::std::string& logLevel, act_t act = 0);

    /**
     * The method onLogLevelSet() is called by ASF when a client invokes the
     * write method for the property 'LogLevel'. The onLogLevelSet() method
     * set property value to the given parameter LogLevel by default. If this
     * default behavior doesn't match your needs feel free to override this
     * method.
     *
     * <b>Documentation of 'LogLevel'</b>:
     *
     * LogLevel
     */
    virtual void onLogLevelSet(const ::boost::shared_ptr< LogLevelSet >& payload);

    /**
     * Sends back the update to a previous onLogLevelSet().
     *
     * <b>Documentation of 'LogLevel'</b>:
     *
     * LogLevel
     *
     * @param act Identifies a previous invocation of onLogLevelSet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendLogLevelSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'LogLevel' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'LogLevel'</b>:
     *
     * LogLevel
     */
    void setLogLevel(const ::std::string& logLevel);

    /**
     * Returns the current value of the property 'LogLevel'.
     *
     * <b>Documentation of 'LogLevel'</b>:
     *
     * LogLevel
     */
    const ::std::string& getLogLevel() const;

    /**
     * Returns the current value of the property 'LogLevel' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendLogLevelUpdate() method.
     *
     * <b>Documentation of 'LogLevel'</b>:
     *
     * LogLevel
     */
    ::std::string& getLogLevelMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendLogLevelUpdate().
     *
     * <b>Documentation of 'LogLevel'</b>:
     *
     * LogLevel
     */
    void sendLogLevelUpdate();

    // property 'LogTarget'

    /**
     * The method onLogTargetGet() is called by ASF when a client invokes the
     * read method for the property 'LogTarget'. The onLogTargetGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'LogTarget'</b>:
     *
     * LogTarget
     */
    virtual void onLogTargetGet(const ::boost::shared_ptr< LogTargetGet >& payload);

    /**
     * Sends back the update to a previous onLogTargetGet().
     *
     * <b>Documentation of 'LogTarget'</b>:
     *
     * LogTarget
     *
     * @param act Identifies a previous invocation of onLogTargetGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendLogTargetGetUpdate(const ::std::string& logTarget, act_t act = 0);

    /**
     * The method onLogTargetSet() is called by ASF when a client invokes the
     * write method for the property 'LogTarget'. The onLogTargetSet() method
     * set property value to the given parameter LogTarget by default. If this
     * default behavior doesn't match your needs feel free to override this
     * method.
     *
     * <b>Documentation of 'LogTarget'</b>:
     *
     * LogTarget
     */
    virtual void onLogTargetSet(const ::boost::shared_ptr< LogTargetSet >& payload);

    /**
     * Sends back the update to a previous onLogTargetSet().
     *
     * <b>Documentation of 'LogTarget'</b>:
     *
     * LogTarget
     *
     * @param act Identifies a previous invocation of onLogTargetSet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendLogTargetSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'LogTarget' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'LogTarget'</b>:
     *
     * LogTarget
     */
    void setLogTarget(const ::std::string& logTarget);

    /**
     * Returns the current value of the property 'LogTarget'.
     *
     * <b>Documentation of 'LogTarget'</b>:
     *
     * LogTarget
     */
    const ::std::string& getLogTarget() const;

    /**
     * Returns the current value of the property 'LogTarget' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendLogTargetUpdate() method.
     *
     * <b>Documentation of 'LogTarget'</b>:
     *
     * LogTarget
     */
    ::std::string& getLogTargetMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendLogTargetUpdate().
     *
     * <b>Documentation of 'LogTarget'</b>:
     *
     * LogTarget
     */
    void sendLogTargetUpdate();

    // property 'NNames'

    /**
     * The method onNNamesGet() is called by ASF when a client invokes the
     * read method for the property 'NNames'. The onNNamesGet() method returns
     * by default the current property value to the caller. In case this
     * default behavior doesn't match your needs feel free to override this
     * method.
     *
     * <b>Documentation of 'NNames'</b>:
     *
     * NNames encodes how many unit names are currently known. This only includes names of units that are currently
     * 		loaded and can be more than actually loaded units since units may have more than one name.
     */
    virtual void onNNamesGet(const ::boost::shared_ptr< NNamesGet >& payload);

    /**
     * Sends back the update to a previous onNNamesGet().
     *
     * <b>Documentation of 'NNames'</b>:
     *
     * NNames encodes how many unit names are currently known. This only includes names of units that are currently
     * 		loaded and can be more than actually loaded units since units may have more than one name.
     *
     * @param act Identifies a previous invocation of onNNamesGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendNNamesGetUpdate(uint32 nNames, act_t act = 0);

    /**
     * Set the value of the property 'NNames' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'NNames'</b>:
     *
     * NNames encodes how many unit names are currently known. This only includes names of units that are currently
     * 		loaded and can be more than actually loaded units since units may have more than one name.
     */
    void setNNames(uint32 nNames);

    /**
     * Returns the current value of the property 'NNames'.
     *
     * <b>Documentation of 'NNames'</b>:
     *
     * NNames encodes how many unit names are currently known. This only includes names of units that are currently
     * 		loaded and can be more than actually loaded units since units may have more than one name.
     */
    uint32 getNNames() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendNNamesUpdate().
     *
     * <b>Documentation of 'NNames'</b>:
     *
     * NNames encodes how many unit names are currently known. This only includes names of units that are currently
     * 		loaded and can be more than actually loaded units since units may have more than one name.
     */
    void sendNNamesUpdate();

    // property 'NFailedUnits'

    /**
     * The method onNFailedUnitsGet() is called by ASF when a client invokes
     * the read method for the property 'NFailedUnits'. The
     * onNFailedUnitsGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'NFailedUnits'</b>:
     *
     * NFailedUnits.
     */
    virtual void onNFailedUnitsGet(const ::boost::shared_ptr< NFailedUnitsGet >& payload);

    /**
     * Sends back the update to a previous onNFailedUnitsGet().
     *
     * <b>Documentation of 'NFailedUnits'</b>:
     *
     * NFailedUnits.
     *
     * @param act Identifies a previous invocation of onNFailedUnitsGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendNFailedUnitsGetUpdate(uint32 nFailedUnits, act_t act = 0);

    /**
     * Set the value of the property 'NFailedUnits' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'NFailedUnits'</b>:
     *
     * NFailedUnits.
     */
    void setNFailedUnits(uint32 nFailedUnits);

    /**
     * Returns the current value of the property 'NFailedUnits'.
     *
     * <b>Documentation of 'NFailedUnits'</b>:
     *
     * NFailedUnits.
     */
    uint32 getNFailedUnits() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendNFailedUnitsUpdate().
     *
     * <b>Documentation of 'NFailedUnits'</b>:
     *
     * NFailedUnits.
     */
    void sendNFailedUnitsUpdate();

    // property 'NJobs'

    /**
     * The method onNJobsGet() is called by ASF when a client invokes the read
     * method for the property 'NJobs'. The onNJobsGet() method returns by
     * default the current property value to the caller. In case this default
     * behavior doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'NJobs'</b>:
     *
     * NJobs encodes how many jobs are currently queued.
     */
    virtual void onNJobsGet(const ::boost::shared_ptr< NJobsGet >& payload);

    /**
     * Sends back the update to a previous onNJobsGet().
     *
     * <b>Documentation of 'NJobs'</b>:
     *
     * NJobs encodes how many jobs are currently queued.
     *
     * @param act Identifies a previous invocation of onNJobsGet(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendNJobsGetUpdate(uint32 nJobs, act_t act = 0);

    /**
     * Set the value of the property 'NJobs' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'NJobs'</b>:
     *
     * NJobs encodes how many jobs are currently queued.
     */
    void setNJobs(uint32 nJobs);

    /**
     * Returns the current value of the property 'NJobs'.
     *
     * <b>Documentation of 'NJobs'</b>:
     *
     * NJobs encodes how many jobs are currently queued.
     */
    uint32 getNJobs() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendNJobsUpdate().
     *
     * <b>Documentation of 'NJobs'</b>:
     *
     * NJobs encodes how many jobs are currently queued.
     */
    void sendNJobsUpdate();

    // property 'NInstalledJobs'

    /**
     * The method onNInstalledJobsGet() is called by ASF when a client invokes
     * the read method for the property 'NInstalledJobs'. The
     * onNInstalledJobsGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'NInstalledJobs'</b>:
     *
     * NInstalledJobs encodes how many jobs have ever been queued in total.
     */
    virtual void onNInstalledJobsGet(const ::boost::shared_ptr< NInstalledJobsGet >& payload);

    /**
     * Sends back the update to a previous onNInstalledJobsGet().
     *
     * <b>Documentation of 'NInstalledJobs'</b>:
     *
     * NInstalledJobs encodes how many jobs have ever been queued in total.
     *
     * @param act Identifies a previous invocation of onNInstalledJobsGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendNInstalledJobsGetUpdate(uint32 nInstalledJobs, act_t act = 0);

    /**
     * Set the value of the property 'NInstalledJobs' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'NInstalledJobs'</b>:
     *
     * NInstalledJobs encodes how many jobs have ever been queued in total.
     */
    void setNInstalledJobs(uint32 nInstalledJobs);

    /**
     * Returns the current value of the property 'NInstalledJobs'.
     *
     * <b>Documentation of 'NInstalledJobs'</b>:
     *
     * NInstalledJobs encodes how many jobs have ever been queued in total.
     */
    uint32 getNInstalledJobs() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendNInstalledJobsUpdate().
     *
     * <b>Documentation of 'NInstalledJobs'</b>:
     *
     * NInstalledJobs encodes how many jobs have ever been queued in total.
     */
    void sendNInstalledJobsUpdate();

    // property 'NFailedJobs'

    /**
     * The method onNFailedJobsGet() is called by ASF when a client invokes
     * the read method for the property 'NFailedJobs'. The onNFailedJobsGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'NFailedJobs'</b>:
     *
     * NFailedJobs encodes how many jobs have ever failed in total.
     */
    virtual void onNFailedJobsGet(const ::boost::shared_ptr< NFailedJobsGet >& payload);

    /**
     * Sends back the update to a previous onNFailedJobsGet().
     *
     * <b>Documentation of 'NFailedJobs'</b>:
     *
     * NFailedJobs encodes how many jobs have ever failed in total.
     *
     * @param act Identifies a previous invocation of onNFailedJobsGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendNFailedJobsGetUpdate(uint32 nFailedJobs, act_t act = 0);

    /**
     * Set the value of the property 'NFailedJobs' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'NFailedJobs'</b>:
     *
     * NFailedJobs encodes how many jobs have ever failed in total.
     */
    void setNFailedJobs(uint32 nFailedJobs);

    /**
     * Returns the current value of the property 'NFailedJobs'.
     *
     * <b>Documentation of 'NFailedJobs'</b>:
     *
     * NFailedJobs encodes how many jobs have ever failed in total.
     */
    uint32 getNFailedJobs() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendNFailedJobsUpdate().
     *
     * <b>Documentation of 'NFailedJobs'</b>:
     *
     * NFailedJobs encodes how many jobs have ever failed in total.
     */
    void sendNFailedJobsUpdate();

    // property 'Progress'

    /**
     * The method onProgressGet() is called by ASF when a client invokes the
     * read method for the property 'Progress'. The onProgressGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Progress'</b>:
     *
     * Progress encodes boot progress as floating point value between 0.0 and 1.0.
     * 		This value begins at 0.0 at early-boot and ends at 1.0 when boot is finished and is based on the number of executed and queued jobs.
     * 		After startup this field is always 1.0 indicating a finished boot.
     */
    virtual void onProgressGet(const ::boost::shared_ptr< ProgressGet >& payload);

    /**
     * Sends back the update to a previous onProgressGet().
     *
     * <b>Documentation of 'Progress'</b>:
     *
     * Progress encodes boot progress as floating point value between 0.0 and 1.0.
     * 		This value begins at 0.0 at early-boot and ends at 1.0 when boot is finished and is based on the number of executed and queued jobs.
     * 		After startup this field is always 1.0 indicating a finished boot.
     *
     * @param act Identifies a previous invocation of onProgressGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendProgressGetUpdate(double progress, act_t act = 0);

    /**
     * Set the value of the property 'Progress' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Progress'</b>:
     *
     * Progress encodes boot progress as floating point value between 0.0 and 1.0.
     * 		This value begins at 0.0 at early-boot and ends at 1.0 when boot is finished and is based on the number of executed and queued jobs.
     * 		After startup this field is always 1.0 indicating a finished boot.
     */
    void setProgress(double progress);

    /**
     * Returns the current value of the property 'Progress'.
     *
     * <b>Documentation of 'Progress'</b>:
     *
     * Progress encodes boot progress as floating point value between 0.0 and 1.0.
     * 		This value begins at 0.0 at early-boot and ends at 1.0 when boot is finished and is based on the number of executed and queued jobs.
     * 		After startup this field is always 1.0 indicating a finished boot.
     */
    double getProgress() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendProgressUpdate().
     *
     * <b>Documentation of 'Progress'</b>:
     *
     * Progress encodes boot progress as floating point value between 0.0 and 1.0.
     * 		This value begins at 0.0 at early-boot and ends at 1.0 when boot is finished and is based on the number of executed and queued jobs.
     * 		After startup this field is always 1.0 indicating a finished boot.
     */
    void sendProgressUpdate();

    // property 'Environment'

    /**
     * The method onEnvironmentGet() is called by ASF when a client invokes
     * the read method for the property 'Environment'. The onEnvironmentGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'Environment'</b>:
     *
     * Environment encodes the environment block passed to all executed services. It may be altered with bus calls such as SetEnvironment
     */
    virtual void onEnvironmentGet(const ::boost::shared_ptr< EnvironmentGet >& payload);

    /**
     * Sends back the update to a previous onEnvironmentGet().
     *
     * <b>Documentation of 'Environment'</b>:
     *
     * Environment encodes the environment block passed to all executed services. It may be altered with bus calls such as SetEnvironment
     *
     * @param act Identifies a previous invocation of onEnvironmentGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendEnvironmentGetUpdate(const ::std::vector< ::std::string >& environment, act_t act = 0);

    /**
     * Set the value of the property 'Environment' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'Environment'</b>:
     *
     * Environment encodes the environment block passed to all executed services. It may be altered with bus calls such as SetEnvironment
     */
    void setEnvironment(const ::std::vector< ::std::string >& environment);

    /**
     * Returns the current value of the property 'Environment'.
     *
     * <b>Documentation of 'Environment'</b>:
     *
     * Environment encodes the environment block passed to all executed services. It may be altered with bus calls such as SetEnvironment
     */
    const ::std::vector< ::std::string >& getEnvironment() const;

    /**
     * Returns the current value of the property 'Environment' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendEnvironmentUpdate() method.
     *
     * <b>Documentation of 'Environment'</b>:
     *
     * Environment encodes the environment block passed to all executed services. It may be altered with bus calls such as SetEnvironment
     */
    ::std::vector< ::std::string >& getEnvironmentMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendEnvironmentUpdate().
     *
     * <b>Documentation of 'Environment'</b>:
     *
     * Environment encodes the environment block passed to all executed services. It may be altered with bus calls such as SetEnvironment
     */
    void sendEnvironmentUpdate();

    // property 'ConfirmSpawn'

    /**
     * The method onConfirmSpawnGet() is called by ASF when a client invokes
     * the read method for the property 'ConfirmSpawn'. The
     * onConfirmSpawnGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'ConfirmSpawn'</b>:
     *
     * ConfirmSpawn
     */
    virtual void onConfirmSpawnGet(const ::boost::shared_ptr< ConfirmSpawnGet >& payload);

    /**
     * Sends back the update to a previous onConfirmSpawnGet().
     *
     * <b>Documentation of 'ConfirmSpawn'</b>:
     *
     * ConfirmSpawn
     *
     * @param act Identifies a previous invocation of onConfirmSpawnGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendConfirmSpawnGetUpdate(bool confirmSpawn, act_t act = 0);

    /**
     * Set the value of the property 'ConfirmSpawn' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'ConfirmSpawn'</b>:
     *
     * ConfirmSpawn
     */
    void setConfirmSpawn(bool confirmSpawn);

    /**
     * Returns the current value of the property 'ConfirmSpawn'.
     *
     * <b>Documentation of 'ConfirmSpawn'</b>:
     *
     * ConfirmSpawn
     */
    bool getConfirmSpawn() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendConfirmSpawnUpdate().
     *
     * <b>Documentation of 'ConfirmSpawn'</b>:
     *
     * ConfirmSpawn
     */
    void sendConfirmSpawnUpdate();

    // property 'ShowStatus'

    /**
     * The method onShowStatusGet() is called by ASF when a client invokes the
     * read method for the property 'ShowStatus'. The onShowStatusGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'ShowStatus'</b>:
     *
     * ShowStatus
     */
    virtual void onShowStatusGet(const ::boost::shared_ptr< ShowStatusGet >& payload);

    /**
     * Sends back the update to a previous onShowStatusGet().
     *
     * <b>Documentation of 'ShowStatus'</b>:
     *
     * ShowStatus
     *
     * @param act Identifies a previous invocation of onShowStatusGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendShowStatusGetUpdate(bool showStatus, act_t act = 0);

    /**
     * Set the value of the property 'ShowStatus' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'ShowStatus'</b>:
     *
     * ShowStatus
     */
    void setShowStatus(bool showStatus);

    /**
     * Returns the current value of the property 'ShowStatus'.
     *
     * <b>Documentation of 'ShowStatus'</b>:
     *
     * ShowStatus
     */
    bool getShowStatus() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendShowStatusUpdate().
     *
     * <b>Documentation of 'ShowStatus'</b>:
     *
     * ShowStatus
     */
    void sendShowStatusUpdate();

    // property 'UnitPath'

    /**
     * The method onUnitPathGet() is called by ASF when a client invokes the
     * read method for the property 'UnitPath'. The onUnitPathGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'UnitPath'</b>:
     *
     * UnitPath encodes the currently active unit file search path. It is an array of strings, each being one file system path
     */
    virtual void onUnitPathGet(const ::boost::shared_ptr< UnitPathGet >& payload);

    /**
     * Sends back the update to a previous onUnitPathGet().
     *
     * <b>Documentation of 'UnitPath'</b>:
     *
     * UnitPath encodes the currently active unit file search path. It is an array of strings, each being one file system path
     *
     * @param act Identifies a previous invocation of onUnitPathGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendUnitPathGetUpdate(const ::std::vector< ::std::string >& unitPath, act_t act = 0);

    /**
     * Set the value of the property 'UnitPath' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'UnitPath'</b>:
     *
     * UnitPath encodes the currently active unit file search path. It is an array of strings, each being one file system path
     */
    void setUnitPath(const ::std::vector< ::std::string >& unitPath);

    /**
     * Returns the current value of the property 'UnitPath'.
     *
     * <b>Documentation of 'UnitPath'</b>:
     *
     * UnitPath encodes the currently active unit file search path. It is an array of strings, each being one file system path
     */
    const ::std::vector< ::std::string >& getUnitPath() const;

    /**
     * Returns the current value of the property 'UnitPath' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendUnitPathUpdate() method.
     *
     * <b>Documentation of 'UnitPath'</b>:
     *
     * UnitPath encodes the currently active unit file search path. It is an array of strings, each being one file system path
     */
    ::std::vector< ::std::string >& getUnitPathMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendUnitPathUpdate().
     *
     * <b>Documentation of 'UnitPath'</b>:
     *
     * UnitPath encodes the currently active unit file search path. It is an array of strings, each being one file system path
     */
    void sendUnitPathUpdate();

    // property 'DefaultStandardOutput'

    /**
     * The method onDefaultStandardOutputGet() is called by ASF when a client
     * invokes the read method for the property 'DefaultStandardOutput'. The
     * onDefaultStandardOutputGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'DefaultStandardOutput'</b>:
     *
     * DefaultStandardOutput
     */
    virtual void onDefaultStandardOutputGet(const ::boost::shared_ptr< DefaultStandardOutputGet >& payload);

    /**
     * Sends back the update to a previous onDefaultStandardOutputGet().
     *
     * <b>Documentation of 'DefaultStandardOutput'</b>:
     *
     * DefaultStandardOutput
     *
     * @param act Identifies a previous invocation of
     * onDefaultStandardOutputGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendDefaultStandardOutputGetUpdate(const ::std::string& defaultStandardOutput, act_t act = 0);

    /**
     * Set the value of the property 'DefaultStandardOutput' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'DefaultStandardOutput'</b>:
     *
     * DefaultStandardOutput
     */
    void setDefaultStandardOutput(const ::std::string& defaultStandardOutput);

    /**
     * Returns the current value of the property 'DefaultStandardOutput'.
     *
     * <b>Documentation of 'DefaultStandardOutput'</b>:
     *
     * DefaultStandardOutput
     */
    const ::std::string& getDefaultStandardOutput() const;

    /**
     * Returns the current value of the property 'DefaultStandardOutput' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendDefaultStandardOutputUpdate() method.
     *
     * <b>Documentation of 'DefaultStandardOutput'</b>:
     *
     * DefaultStandardOutput
     */
    ::std::string& getDefaultStandardOutputMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendDefaultStandardOutputUpdate().
     *
     * <b>Documentation of 'DefaultStandardOutput'</b>:
     *
     * DefaultStandardOutput
     */
    void sendDefaultStandardOutputUpdate();

    // property 'DefaultStandardError'

    /**
     * The method onDefaultStandardErrorGet() is called by ASF when a client
     * invokes the read method for the property 'DefaultStandardError'. The
     * onDefaultStandardErrorGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'DefaultStandardError'</b>:
     *
     * DefaultStandardError
     */
    virtual void onDefaultStandardErrorGet(const ::boost::shared_ptr< DefaultStandardErrorGet >& payload);

    /**
     * Sends back the update to a previous onDefaultStandardErrorGet().
     *
     * <b>Documentation of 'DefaultStandardError'</b>:
     *
     * DefaultStandardError
     *
     * @param act Identifies a previous invocation of
     * onDefaultStandardErrorGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendDefaultStandardErrorGetUpdate(const ::std::string& defaultStandardError, act_t act = 0);

    /**
     * Set the value of the property 'DefaultStandardError' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'DefaultStandardError'</b>:
     *
     * DefaultStandardError
     */
    void setDefaultStandardError(const ::std::string& defaultStandardError);

    /**
     * Returns the current value of the property 'DefaultStandardError'.
     *
     * <b>Documentation of 'DefaultStandardError'</b>:
     *
     * DefaultStandardError
     */
    const ::std::string& getDefaultStandardError() const;

    /**
     * Returns the current value of the property 'DefaultStandardError' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendDefaultStandardErrorUpdate() method.
     *
     * <b>Documentation of 'DefaultStandardError'</b>:
     *
     * DefaultStandardError
     */
    ::std::string& getDefaultStandardErrorMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendDefaultStandardErrorUpdate().
     *
     * <b>Documentation of 'DefaultStandardError'</b>:
     *
     * DefaultStandardError
     */
    void sendDefaultStandardErrorUpdate();

    // property 'RuntimeWatchdogUSec'

    /**
     * The method onRuntimeWatchdogUSecGet() is called by ASF when a client
     * invokes the read method for the property 'RuntimeWatchdogUSec'. The
     * onRuntimeWatchdogUSecGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'RuntimeWatchdogUSec'</b>:
     *
     * RuntimeWatchdogUSec
     */
    virtual void onRuntimeWatchdogUSecGet(const ::boost::shared_ptr< RuntimeWatchdogUSecGet >& payload);

    /**
     * Sends back the update to a previous onRuntimeWatchdogUSecGet().
     *
     * <b>Documentation of 'RuntimeWatchdogUSec'</b>:
     *
     * RuntimeWatchdogUSec
     *
     * @param act Identifies a previous invocation of
     * onRuntimeWatchdogUSecGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRuntimeWatchdogUSecGetUpdate(uint64 runtimeWatchdogUSec, act_t act = 0);

    /**
     * The method onRuntimeWatchdogUSecSet() is called by ASF when a client
     * invokes the write method for the property 'RuntimeWatchdogUSec'. The
     * onRuntimeWatchdogUSecSet() method set property value to the given
     * parameter RuntimeWatchdogUSec by default. If this default behavior
     * doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'RuntimeWatchdogUSec'</b>:
     *
     * RuntimeWatchdogUSec
     */
    virtual void onRuntimeWatchdogUSecSet(const ::boost::shared_ptr< RuntimeWatchdogUSecSet >& payload);

    /**
     * Sends back the update to a previous onRuntimeWatchdogUSecSet().
     *
     * <b>Documentation of 'RuntimeWatchdogUSec'</b>:
     *
     * RuntimeWatchdogUSec
     *
     * @param act Identifies a previous invocation of
     * onRuntimeWatchdogUSecSet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRuntimeWatchdogUSecSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'RuntimeWatchdogUSec' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'RuntimeWatchdogUSec'</b>:
     *
     * RuntimeWatchdogUSec
     */
    void setRuntimeWatchdogUSec(uint64 runtimeWatchdogUSec);

    /**
     * Returns the current value of the property 'RuntimeWatchdogUSec'.
     *
     * <b>Documentation of 'RuntimeWatchdogUSec'</b>:
     *
     * RuntimeWatchdogUSec
     */
    uint64 getRuntimeWatchdogUSec() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendRuntimeWatchdogUSecUpdate().
     *
     * <b>Documentation of 'RuntimeWatchdogUSec'</b>:
     *
     * RuntimeWatchdogUSec
     */
    void sendRuntimeWatchdogUSecUpdate();

    // property 'ShutdownWatchdogUSec'

    /**
     * The method onShutdownWatchdogUSecGet() is called by ASF when a client
     * invokes the read method for the property 'ShutdownWatchdogUSec'. The
     * onShutdownWatchdogUSecGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'ShutdownWatchdogUSec'</b>:
     *
     * ShutdownWatchdogUSec
     */
    virtual void onShutdownWatchdogUSecGet(const ::boost::shared_ptr< ShutdownWatchdogUSecGet >& payload);

    /**
     * Sends back the update to a previous onShutdownWatchdogUSecGet().
     *
     * <b>Documentation of 'ShutdownWatchdogUSec'</b>:
     *
     * ShutdownWatchdogUSec
     *
     * @param act Identifies a previous invocation of
     * onShutdownWatchdogUSecGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendShutdownWatchdogUSecGetUpdate(uint64 shutdownWatchdogUSec, act_t act = 0);

    /**
     * The method onShutdownWatchdogUSecSet() is called by ASF when a client
     * invokes the write method for the property 'ShutdownWatchdogUSec'. The
     * onShutdownWatchdogUSecSet() method set property value to the given
     * parameter ShutdownWatchdogUSec by default. If this default behavior
     * doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'ShutdownWatchdogUSec'</b>:
     *
     * ShutdownWatchdogUSec
     */
    virtual void onShutdownWatchdogUSecSet(const ::boost::shared_ptr< ShutdownWatchdogUSecSet >& payload);

    /**
     * Sends back the update to a previous onShutdownWatchdogUSecSet().
     *
     * <b>Documentation of 'ShutdownWatchdogUSec'</b>:
     *
     * ShutdownWatchdogUSec
     *
     * @param act Identifies a previous invocation of
     * onShutdownWatchdogUSecSet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendShutdownWatchdogUSecSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'ShutdownWatchdogUSec' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'ShutdownWatchdogUSec'</b>:
     *
     * ShutdownWatchdogUSec
     */
    void setShutdownWatchdogUSec(uint64 shutdownWatchdogUSec);

    /**
     * Returns the current value of the property 'ShutdownWatchdogUSec'.
     *
     * <b>Documentation of 'ShutdownWatchdogUSec'</b>:
     *
     * ShutdownWatchdogUSec
     */
    uint64 getShutdownWatchdogUSec() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendShutdownWatchdogUSecUpdate().
     *
     * <b>Documentation of 'ShutdownWatchdogUSec'</b>:
     *
     * ShutdownWatchdogUSec
     */
    void sendShutdownWatchdogUSecUpdate();

    // property 'ControlGroup'

    /**
     * The method onControlGroupGet() is called by ASF when a client invokes
     * the read method for the property 'ControlGroup'. The
     * onControlGroupGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'ControlGroup'</b>:
     *
     * ControlGroup
     */
    virtual void onControlGroupGet(const ::boost::shared_ptr< ControlGroupGet >& payload);

    /**
     * Sends back the update to a previous onControlGroupGet().
     *
     * <b>Documentation of 'ControlGroup'</b>:
     *
     * ControlGroup
     *
     * @param act Identifies a previous invocation of onControlGroupGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendControlGroupGetUpdate(const ::std::string& controlGroup, act_t act = 0);

    /**
     * The method onControlGroupSet() is called by ASF when a client invokes
     * the write method for the property 'ControlGroup'. The
     * onControlGroupSet() method set property value to the given parameter
     * ControlGroup by default. If this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'ControlGroup'</b>:
     *
     * ControlGroup
     */
    virtual void onControlGroupSet(const ::boost::shared_ptr< ControlGroupSet >& payload);

    /**
     * Sends back the update to a previous onControlGroupSet().
     *
     * <b>Documentation of 'ControlGroup'</b>:
     *
     * ControlGroup
     *
     * @param act Identifies a previous invocation of onControlGroupSet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendControlGroupSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'ControlGroup' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'ControlGroup'</b>:
     *
     * ControlGroup
     */
    void setControlGroup(const ::std::string& controlGroup);

    /**
     * Returns the current value of the property 'ControlGroup'.
     *
     * <b>Documentation of 'ControlGroup'</b>:
     *
     * ControlGroup
     */
    const ::std::string& getControlGroup() const;

    /**
     * Returns the current value of the property 'ControlGroup' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendControlGroupUpdate() method.
     *
     * <b>Documentation of 'ControlGroup'</b>:
     *
     * ControlGroup
     */
    ::std::string& getControlGroupMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendControlGroupUpdate().
     *
     * <b>Documentation of 'ControlGroup'</b>:
     *
     * ControlGroup
     */
    void sendControlGroupUpdate();

    // property 'SystemState'

    /**
     * The method onSystemStateGet() is called by ASF when a client invokes
     * the read method for the property 'SystemState'. The onSystemStateGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'SystemState'</b>:
     *
     * SystemState
     */
    virtual void onSystemStateGet(const ::boost::shared_ptr< SystemStateGet >& payload);

    /**
     * Sends back the update to a previous onSystemStateGet().
     *
     * <b>Documentation of 'SystemState'</b>:
     *
     * SystemState
     *
     * @param act Identifies a previous invocation of onSystemStateGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSystemStateGetUpdate(const ::std::string& systemState, act_t act = 0);

    /**
     * The method onSystemStateSet() is called by ASF when a client invokes
     * the write method for the property 'SystemState'. The onSystemStateSet()
     * method set property value to the given parameter SystemState by
     * default. If this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'SystemState'</b>:
     *
     * SystemState
     */
    virtual void onSystemStateSet(const ::boost::shared_ptr< SystemStateSet >& payload);

    /**
     * Sends back the update to a previous onSystemStateSet().
     *
     * <b>Documentation of 'SystemState'</b>:
     *
     * SystemState
     *
     * @param act Identifies a previous invocation of onSystemStateSet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSystemStateSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'SystemState' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'SystemState'</b>:
     *
     * SystemState
     */
    void setSystemState(const ::std::string& systemState);

    /**
     * Returns the current value of the property 'SystemState'.
     *
     * <b>Documentation of 'SystemState'</b>:
     *
     * SystemState
     */
    const ::std::string& getSystemState() const;

    /**
     * Returns the current value of the property 'SystemState' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendSystemStateUpdate() method.
     *
     * <b>Documentation of 'SystemState'</b>:
     *
     * SystemState
     */
    ::std::string& getSystemStateMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSystemStateUpdate().
     *
     * <b>Documentation of 'SystemState'</b>:
     *
     * SystemState
     */
    void sendSystemStateUpdate();

    // method 'GetUnit'

    /**
     * The method onGetUnit() is called by ASF when a client invokes the
     * method 'GetUnit'. A subclass has to implement this method and send back
     * a response to the client either with the sendGetUnit() or
     * sendGetUnitError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'GetUnit'</b>:
     *
     * GetUnit() may be used to get the unit object path
     * 	    for a unit name. It takes the unit name and returns the object path.
     * 	    If a unit has not been loaded yet by this name this call will fail.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetUnitRequest (const ::boost::shared_ptr< GetUnitRequest >& request) = 0;

    /**
     * The method sendGetUnitResponse() sends a response of a previous method
     * invocation of 'GetUnit' back to the client.
     *
     * <b>Documentation of 'GetUnit'</b>:
     *
     * GetUnit() may be used to get the unit object path
     * 	    for a unit name. It takes the unit name and returns the object path.
     * 	    If a unit has not been loaded yet by this name this call will fail.
     *
     * @param unit If the meaning of "unit" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetUnit(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendGetUnitResponse (const ::std::string& unit, act_t act = 0);

    /**
     * The method sendGetUnitError() sends an error response of a previous
     * method invocation of 'GetUnit' back to the client.
     *
     * <b>Documentation of 'GetUnit'</b>:
     *
     * GetUnit() may be used to get the unit object path
     * 	    for a unit name. It takes the unit name and returns the object path.
     * 	    If a unit has not been loaded yet by this name this call will fail.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetUnit(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendGetUnitError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'GetUnitByPID'

    /**
     * The method onGetUnitByPID() is called by ASF when a client invokes the
     * method 'GetUnitByPID'. A subclass has to implement this method and send
     * back a response to the client either with the sendGetUnitByPID() or
     * sendGetUnitByPIDError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'GetUnitByPID'</b>:
     *
     * GetUnitByPID() may be used to get the unit object path of the unit a process ID belongs to.
     * 	    Takes a Unix PID and returns the object path. The PID must refer to an existing process of the system.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetUnitByPIDRequest (const ::boost::shared_ptr< GetUnitByPIDRequest >& request) = 0;

    /**
     * The method sendGetUnitByPIDResponse() sends a response of a previous
     * method invocation of 'GetUnitByPID' back to the client.
     *
     * <b>Documentation of 'GetUnitByPID'</b>:
     *
     * GetUnitByPID() may be used to get the unit object path of the unit a process ID belongs to.
     * 	    Takes a Unix PID and returns the object path. The PID must refer to an existing process of the system.
     *
     * @param unit If the meaning of "unit" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetUnitByPID(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendGetUnitByPIDResponse (const ::std::string& unit, act_t act = 0);

    /**
     * The method sendGetUnitByPIDError() sends an error response of a
     * previous method invocation of 'GetUnitByPID' back to the client.
     *
     * <b>Documentation of 'GetUnitByPID'</b>:
     *
     * GetUnitByPID() may be used to get the unit object path of the unit a process ID belongs to.
     * 	    Takes a Unix PID and returns the object path. The PID must refer to an existing process of the system.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetUnitByPID(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendGetUnitByPIDError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'LoadUnit'

    /**
     * The method onLoadUnit() is called by ASF when a client invokes the
     * method 'LoadUnit'. A subclass has to implement this method and send
     * back a response to the client either with the sendLoadUnit() or
     * sendLoadUnitError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'LoadUnit'</b>:
     *
     * LoadUnit() is similar to GetUnit() but will load the unit from disk if possible
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onLoadUnitRequest (const ::boost::shared_ptr< LoadUnitRequest >& request) = 0;

    /**
     * The method sendLoadUnitResponse() sends a response of a previous method
     * invocation of 'LoadUnit' back to the client.
     *
     * <b>Documentation of 'LoadUnit'</b>:
     *
     * LoadUnit() is similar to GetUnit() but will load the unit from disk if possible
     *
     * @param unit If the meaning of "unit" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onLoadUnit(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendLoadUnitResponse (const ::std::string& unit, act_t act = 0);

    /**
     * The method sendLoadUnitError() sends an error response of a previous
     * method invocation of 'LoadUnit' back to the client.
     *
     * <b>Documentation of 'LoadUnit'</b>:
     *
     * LoadUnit() is similar to GetUnit() but will load the unit from disk if possible
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onLoadUnit(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendLoadUnitError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'StartUnit'

    /**
     * The method onStartUnit() is called by ASF when a client invokes the
     * method 'StartUnit'. A subclass has to implement this method and send
     * back a response to the client either with the sendStartUnit() or
     * sendStartUnitError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'StartUnit'</b>:
     *
     * StartUnit() enqeues a start job, and possibly depending jobs. Takes the unit to activate, plus a mode string.
     *     	The mode needs to be one of replace, fail, isolate, ignore-dependencies, ignore-requirements.
     *     	If "replace" the call will start the unit and its dependencies, possibly replacing already queued jobs that conflict with this.
     *     	If "fail" the call will start the unit and its dependencies, but will fail if this would change an already queued job.
     *     	If "isolate" the call will start the unit in question and terminate all units that aren't dependencies of it.
     *      	If "ignore-dependencies" it will start a unit but ignore all its dependencies.
     *     	If "ignore-requirements" it will start a unit but only ignore the requirement dependencies.
     *     	It is not recommended to make use of the latter two options. Returns the newly created job object.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onStartUnitRequest (const ::boost::shared_ptr< StartUnitRequest >& request) = 0;

    /**
     * The method sendStartUnitResponse() sends a response of a previous
     * method invocation of 'StartUnit' back to the client.
     *
     * <b>Documentation of 'StartUnit'</b>:
     *
     * StartUnit() enqeues a start job, and possibly depending jobs. Takes the unit to activate, plus a mode string.
     *     	The mode needs to be one of replace, fail, isolate, ignore-dependencies, ignore-requirements.
     *     	If "replace" the call will start the unit and its dependencies, possibly replacing already queued jobs that conflict with this.
     *     	If "fail" the call will start the unit and its dependencies, but will fail if this would change an already queued job.
     *     	If "isolate" the call will start the unit in question and terminate all units that aren't dependencies of it.
     *      	If "ignore-dependencies" it will start a unit but ignore all its dependencies.
     *     	If "ignore-requirements" it will start a unit but only ignore the requirement dependencies.
     *     	It is not recommended to make use of the latter two options. Returns the newly created job object.
     *
     * @param job If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onStartUnit(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendStartUnitResponse (const ::std::string& job, act_t act = 0);

    /**
     * The method sendStartUnitError() sends an error response of a previous
     * method invocation of 'StartUnit' back to the client.
     *
     * <b>Documentation of 'StartUnit'</b>:
     *
     * StartUnit() enqeues a start job, and possibly depending jobs. Takes the unit to activate, plus a mode string.
     *     	The mode needs to be one of replace, fail, isolate, ignore-dependencies, ignore-requirements.
     *     	If "replace" the call will start the unit and its dependencies, possibly replacing already queued jobs that conflict with this.
     *     	If "fail" the call will start the unit and its dependencies, but will fail if this would change an already queued job.
     *     	If "isolate" the call will start the unit in question and terminate all units that aren't dependencies of it.
     *      	If "ignore-dependencies" it will start a unit but ignore all its dependencies.
     *     	If "ignore-requirements" it will start a unit but only ignore the requirement dependencies.
     *     	It is not recommended to make use of the latter two options. Returns the newly created job object.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onStartUnit(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendStartUnitError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'StartUnitReplace'

    /**
     * The method onStartUnitReplace() is called by ASF when a client invokes
     * the method 'StartUnitReplace'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendStartUnitReplace() or sendStartUnitReplaceError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'StartUnitReplace'</b>:
     *
     * StartUnitReplace() is similar to StartUnit() but replaces a job that is queued for one unit by a job for another.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onStartUnitReplaceRequest (const ::boost::shared_ptr< StartUnitReplaceRequest >& request) = 0;

    /**
     * The method sendStartUnitReplaceResponse() sends a response of a
     * previous method invocation of 'StartUnitReplace' back to the client.
     *
     * <b>Documentation of 'StartUnitReplace'</b>:
     *
     * StartUnitReplace() is similar to StartUnit() but replaces a job that is queued for one unit by a job for another.
     *
     * @param job If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onStartUnitReplace(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendStartUnitReplaceResponse (const ::std::string& job, act_t act = 0);

    /**
     * The method sendStartUnitReplaceError() sends an error response of a
     * previous method invocation of 'StartUnitReplace' back to the client.
     *
     * <b>Documentation of 'StartUnitReplace'</b>:
     *
     * StartUnitReplace() is similar to StartUnit() but replaces a job that is queued for one unit by a job for another.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onStartUnitReplace(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendStartUnitReplaceError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'StopUnit'

    /**
     * The method onStopUnit() is called by ASF when a client invokes the
     * method 'StopUnit'. A subclass has to implement this method and send
     * back a response to the client either with the sendStopUnit() or
     * sendStopUnitError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'StopUnit'</b>:
     *
     * StopUnit() is similar to StartUnit() but stops the specified unit rather than starting it. Note that "isolate" mode is invalid for this call
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onStopUnitRequest (const ::boost::shared_ptr< StopUnitRequest >& request) = 0;

    /**
     * The method sendStopUnitResponse() sends a response of a previous method
     * invocation of 'StopUnit' back to the client.
     *
     * <b>Documentation of 'StopUnit'</b>:
     *
     * StopUnit() is similar to StartUnit() but stops the specified unit rather than starting it. Note that "isolate" mode is invalid for this call
     *
     * @param job If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onStopUnit(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendStopUnitResponse (const ::std::string& job, act_t act = 0);

    /**
     * The method sendStopUnitError() sends an error response of a previous
     * method invocation of 'StopUnit' back to the client.
     *
     * <b>Documentation of 'StopUnit'</b>:
     *
     * StopUnit() is similar to StartUnit() but stops the specified unit rather than starting it. Note that "isolate" mode is invalid for this call
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onStopUnit(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendStopUnitError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ReloadUnit'

    /**
     * The method onReloadUnit() is called by ASF when a client invokes the
     * method 'ReloadUnit'. A subclass has to implement this method and send
     * back a response to the client either with the sendReloadUnit() or
     * sendReloadUnitError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'ReloadUnit'</b>:
     *
     * ReloadUnit(), RestartUnit(), TryRestartUnit(), ReloadOrRestartUnit(), ReloadOrTryRestartUnit() may be used to restart and/or reload a unit,
     *     	and takes similar arguments as StartUnit(). Reloading is done only if the unit is already running and fails otherwise.
     *     	If a service is restarted that isn't running it will be started, unless the "Try" flavor is used in which case a service that isn't running is not affected by the restart.
     *     	The "ReloadOrRestart" flavors attempt a reload if the unit supports it and use a restart otherwise.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onReloadUnitRequest (const ::boost::shared_ptr< ReloadUnitRequest >& request) = 0;

    /**
     * The method sendReloadUnitResponse() sends a response of a previous
     * method invocation of 'ReloadUnit' back to the client.
     *
     * <b>Documentation of 'ReloadUnit'</b>:
     *
     * ReloadUnit(), RestartUnit(), TryRestartUnit(), ReloadOrRestartUnit(), ReloadOrTryRestartUnit() may be used to restart and/or reload a unit,
     *     	and takes similar arguments as StartUnit(). Reloading is done only if the unit is already running and fails otherwise.
     *     	If a service is restarted that isn't running it will be started, unless the "Try" flavor is used in which case a service that isn't running is not affected by the restart.
     *     	The "ReloadOrRestart" flavors attempt a reload if the unit supports it and use a restart otherwise.
     *
     * @param job If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onReloadUnit(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendReloadUnitResponse (const ::std::string& job, act_t act = 0);

    /**
     * The method sendReloadUnitError() sends an error response of a previous
     * method invocation of 'ReloadUnit' back to the client.
     *
     * <b>Documentation of 'ReloadUnit'</b>:
     *
     * ReloadUnit(), RestartUnit(), TryRestartUnit(), ReloadOrRestartUnit(), ReloadOrTryRestartUnit() may be used to restart and/or reload a unit,
     *     	and takes similar arguments as StartUnit(). Reloading is done only if the unit is already running and fails otherwise.
     *     	If a service is restarted that isn't running it will be started, unless the "Try" flavor is used in which case a service that isn't running is not affected by the restart.
     *     	The "ReloadOrRestart" flavors attempt a reload if the unit supports it and use a restart otherwise.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onReloadUnit(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendReloadUnitError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'RestartUnit'

    /**
     * The method onRestartUnit() is called by ASF when a client invokes the
     * method 'RestartUnit'. A subclass has to implement this method and send
     * back a response to the client either with the sendRestartUnit() or
     * sendRestartUnitError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'RestartUnit'</b>:
     *
     * RestartUnit()
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRestartUnitRequest (const ::boost::shared_ptr< RestartUnitRequest >& request) = 0;

    /**
     * The method sendRestartUnitResponse() sends a response of a previous
     * method invocation of 'RestartUnit' back to the client.
     *
     * <b>Documentation of 'RestartUnit'</b>:
     *
     * RestartUnit()
     *
     * @param job If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onRestartUnit(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendRestartUnitResponse (const ::std::string& job, act_t act = 0);

    /**
     * The method sendRestartUnitError() sends an error response of a previous
     * method invocation of 'RestartUnit' back to the client.
     *
     * <b>Documentation of 'RestartUnit'</b>:
     *
     * RestartUnit()
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onRestartUnit(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendRestartUnitError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'TryRestartUnit'

    /**
     * The method onTryRestartUnit() is called by ASF when a client invokes
     * the method 'TryRestartUnit'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendTryRestartUnit() or sendTryRestartUnitError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'TryRestartUnit'</b>:
     *
     * TryRestartUnit()
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onTryRestartUnitRequest (const ::boost::shared_ptr< TryRestartUnitRequest >& request) = 0;

    /**
     * The method sendTryRestartUnitResponse() sends a response of a previous
     * method invocation of 'TryRestartUnit' back to the client.
     *
     * <b>Documentation of 'TryRestartUnit'</b>:
     *
     * TryRestartUnit()
     *
     * @param job If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onTryRestartUnit(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendTryRestartUnitResponse (const ::std::string& job, act_t act = 0);

    /**
     * The method sendTryRestartUnitError() sends an error response of a
     * previous method invocation of 'TryRestartUnit' back to the client.
     *
     * <b>Documentation of 'TryRestartUnit'</b>:
     *
     * TryRestartUnit()
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onTryRestartUnit(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendTryRestartUnitError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ReloadOrRestartUnit'

    /**
     * The method onReloadOrRestartUnit() is called by ASF when a client
     * invokes the method 'ReloadOrRestartUnit'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendReloadOrRestartUnit() or sendReloadOrRestartUnitError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'ReloadOrRestartUnit'</b>:
     *
     * ReloadOrRestartUnit()
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onReloadOrRestartUnitRequest (const ::boost::shared_ptr< ReloadOrRestartUnitRequest >& request) = 0;

    /**
     * The method sendReloadOrRestartUnitResponse() sends a response of a
     * previous method invocation of 'ReloadOrRestartUnit' back to the client.
     *
     * <b>Documentation of 'ReloadOrRestartUnit'</b>:
     *
     * ReloadOrRestartUnit()
     *
     * @param job If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onReloadOrRestartUnit(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendReloadOrRestartUnitResponse (const ::std::string& job, act_t act = 0);

    /**
     * The method sendReloadOrRestartUnitError() sends an error response of a
     * previous method invocation of 'ReloadOrRestartUnit' back to the client.
     *
     * <b>Documentation of 'ReloadOrRestartUnit'</b>:
     *
     * ReloadOrRestartUnit()
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onReloadOrRestartUnit().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendReloadOrRestartUnitError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ReloadOrTryRestartUnit'

    /**
     * The method onReloadOrTryRestartUnit() is called by ASF when a client
     * invokes the method 'ReloadOrTryRestartUnit'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendReloadOrTryRestartUnit() or
     * sendReloadOrTryRestartUnitError() method. Do not invoke this method on
     * your own.
     *
     * <b>Documentation of 'ReloadOrTryRestartUnit'</b>:
     *
     * ReloadOrTryRestartUnit()
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onReloadOrTryRestartUnitRequest (const ::boost::shared_ptr< ReloadOrTryRestartUnitRequest >& request) = 0;

    /**
     * The method sendReloadOrTryRestartUnitResponse() sends a response of a
     * previous method invocation of 'ReloadOrTryRestartUnit' back to the
     * client.
     *
     * <b>Documentation of 'ReloadOrTryRestartUnit'</b>:
     *
     * ReloadOrTryRestartUnit()
     *
     * @param job If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onReloadOrTryRestartUnit(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendReloadOrTryRestartUnitResponse (const ::std::string& job, act_t act = 0);

    /**
     * The method sendReloadOrTryRestartUnitError() sends an error response of
     * a previous method invocation of 'ReloadOrTryRestartUnit' back to the
     * client.
     *
     * <b>Documentation of 'ReloadOrTryRestartUnit'</b>:
     *
     * ReloadOrTryRestartUnit()
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onReloadOrTryRestartUnit(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendReloadOrTryRestartUnitError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'KillUnit'

    /**
     * The method onKillUnit() is called by ASF when a client invokes the
     * method 'KillUnit'. A subclass has to implement this method and send
     * back a response to the client either with the sendKillUnit() or
     * sendKillUnitError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'KillUnit'</b>:
     *
     * KillUnit() may be used to kill (i.e. send a signal to) all processes of a unit.
     * 		Takes the unit name, an enum who and a UNIX signal number to send. The who enum is one of "main", "control" or "all".
     * 	 	If "main", only the main process of a unit is killed. If "control" only the control process of the unit is killed, if "all" all processes are killed.
     * 	 	A "control" process is for example a process that is configured via ExecStop= and is spawned in parallel to the main daemon process, in order to shut it down
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onKillUnitRequest (const ::boost::shared_ptr< KillUnitRequest >& request) = 0;

    /**
     * The method sendKillUnitResponse() sends a response of a previous method
     * invocation of 'KillUnit' back to the client.
     *
     * <b>Documentation of 'KillUnit'</b>:
     *
     * KillUnit() may be used to kill (i.e. send a signal to) all processes of a unit.
     * 		Takes the unit name, an enum who and a UNIX signal number to send. The who enum is one of "main", "control" or "all".
     * 	 	If "main", only the main process of a unit is killed. If "control" only the control process of the unit is killed, if "all" all processes are killed.
     * 	 	A "control" process is for example a process that is configured via ExecStop= and is spawned in parallel to the main daemon process, in order to shut it down
     *
     * @param act The parameter act identifies a previous invocation of
     * onKillUnit(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendKillUnitResponse (act_t act = 0);

    /**
     * The method sendKillUnitError() sends an error response of a previous
     * method invocation of 'KillUnit' back to the client.
     *
     * <b>Documentation of 'KillUnit'</b>:
     *
     * KillUnit() may be used to kill (i.e. send a signal to) all processes of a unit.
     * 		Takes the unit name, an enum who and a UNIX signal number to send. The who enum is one of "main", "control" or "all".
     * 	 	If "main", only the main process of a unit is killed. If "control" only the control process of the unit is killed, if "all" all processes are killed.
     * 	 	A "control" process is for example a process that is configured via ExecStop= and is spawned in parallel to the main daemon process, in order to shut it down
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onKillUnit(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendKillUnitError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ResetFailedUnit'

    /**
     * The method onResetFailedUnit() is called by ASF when a client invokes
     * the method 'ResetFailedUnit'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendResetFailedUnit() or sendResetFailedUnitError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'ResetFailedUnit'</b>:
     *
     * ResetFailedUnit
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onResetFailedUnitRequest (const ::boost::shared_ptr< ResetFailedUnitRequest >& request) = 0;

    /**
     * The method sendResetFailedUnitResponse() sends a response of a previous
     * method invocation of 'ResetFailedUnit' back to the client.
     *
     * <b>Documentation of 'ResetFailedUnit'</b>:
     *
     * ResetFailedUnit
     *
     * @param act The parameter act identifies a previous invocation of
     * onResetFailedUnit(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendResetFailedUnitResponse (act_t act = 0);

    /**
     * The method sendResetFailedUnitError() sends an error response of a
     * previous method invocation of 'ResetFailedUnit' back to the client.
     *
     * <b>Documentation of 'ResetFailedUnit'</b>:
     *
     * ResetFailedUnit
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onResetFailedUnit(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendResetFailedUnitError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'SetUnitProperties'

    /**
     * The method onSetUnitProperties() is called by ASF when a client invokes
     * the method 'SetUnitProperties'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendSetUnitProperties() or sendSetUnitPropertiesError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'SetUnitProperties'</b>:
     *
     * SetUnitProperties
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetUnitPropertiesRequest (const ::boost::shared_ptr< SetUnitPropertiesRequest >& request) = 0;

    /**
     * The method sendSetUnitPropertiesResponse() sends a response of a
     * previous method invocation of 'SetUnitProperties' back to the client.
     *
     * <b>Documentation of 'SetUnitProperties'</b>:
     *
     * SetUnitProperties
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetUnitProperties(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSetUnitPropertiesResponse (act_t act = 0);

    /**
     * The method sendSetUnitPropertiesError() sends an error response of a
     * previous method invocation of 'SetUnitProperties' back to the client.
     *
     * <b>Documentation of 'SetUnitProperties'</b>:
     *
     * SetUnitProperties
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSetUnitProperties().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSetUnitPropertiesError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'StartTransientUnit'

    /**
     * The method onStartTransientUnit() is called by ASF when a client
     * invokes the method 'StartTransientUnit'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendStartTransientUnit() or sendStartTransientUnitError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'StartTransientUnit'</b>:
     *
     * StartTransientUnit
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onStartTransientUnitRequest (const ::boost::shared_ptr< StartTransientUnitRequest >& request) = 0;

    /**
     * The method sendStartTransientUnitResponse() sends a response of a
     * previous method invocation of 'StartTransientUnit' back to the client.
     *
     * <b>Documentation of 'StartTransientUnit'</b>:
     *
     * StartTransientUnit
     *
     * @param job If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onStartTransientUnit(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendStartTransientUnitResponse (const ::std::string& job, act_t act = 0);

    /**
     * The method sendStartTransientUnitError() sends an error response of a
     * previous method invocation of 'StartTransientUnit' back to the client.
     *
     * <b>Documentation of 'StartTransientUnit'</b>:
     *
     * StartTransientUnit
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onStartTransientUnit().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendStartTransientUnitError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'GetJob'

    /**
     * The method onGetJob() is called by ASF when a client invokes the method
     * 'GetJob'. A subclass has to implement this method and send back a
     * response to the client either with the sendGetJob() or
     * sendGetJobError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'GetJob'</b>:
     *
     * GetJob() returns the job object path for a specific job, identified by its id.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetJobRequest (const ::boost::shared_ptr< GetJobRequest >& request) = 0;

    /**
     * The method sendGetJobResponse() sends a response of a previous method
     * invocation of 'GetJob' back to the client.
     *
     * <b>Documentation of 'GetJob'</b>:
     *
     * GetJob() returns the job object path for a specific job, identified by its id.
     *
     * @param job If the meaning of "job" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetJob(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendGetJobResponse (const ::std::string& job, act_t act = 0);

    /**
     * The method sendGetJobError() sends an error response of a previous
     * method invocation of 'GetJob' back to the client.
     *
     * <b>Documentation of 'GetJob'</b>:
     *
     * GetJob() returns the job object path for a specific job, identified by its id.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetJob(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendGetJobError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'CancelJob'

    /**
     * The method onCancelJob() is called by ASF when a client invokes the
     * method 'CancelJob'. A subclass has to implement this method and send
     * back a response to the client either with the sendCancelJob() or
     * sendCancelJobError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'CancelJob'</b>:
     *
     * CancelJob() cancels a specific job identified by its numer ID. This operation is also available
     * 		in the Cancel() method of Job objects (see below), and exists primarily to reduce the necessary round trips to
     * 		execute this operation. Note that this will not have any effect on jobs whose execution has already begun.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onCancelJobRequest (const ::boost::shared_ptr< CancelJobRequest >& request) = 0;

    /**
     * The method sendCancelJobResponse() sends a response of a previous
     * method invocation of 'CancelJob' back to the client.
     *
     * <b>Documentation of 'CancelJob'</b>:
     *
     * CancelJob() cancels a specific job identified by its numer ID. This operation is also available
     * 		in the Cancel() method of Job objects (see below), and exists primarily to reduce the necessary round trips to
     * 		execute this operation. Note that this will not have any effect on jobs whose execution has already begun.
     *
     * @param act The parameter act identifies a previous invocation of
     * onCancelJob(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendCancelJobResponse (act_t act = 0);

    /**
     * The method sendCancelJobError() sends an error response of a previous
     * method invocation of 'CancelJob' back to the client.
     *
     * <b>Documentation of 'CancelJob'</b>:
     *
     * CancelJob() cancels a specific job identified by its numer ID. This operation is also available
     * 		in the Cancel() method of Job objects (see below), and exists primarily to reduce the necessary round trips to
     * 		execute this operation. Note that this will not have any effect on jobs whose execution has already begun.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onCancelJob(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendCancelJobError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ClearJobs'

    /**
     * The method onClearJobs() is called by ASF when a client invokes the
     * method 'ClearJobs'. A subclass has to implement this method and send
     * back a response to the client either with the sendClearJobs() or
     * sendClearJobsError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'ClearJobs'</b>:
     *
     * ClearJobs() flushes the job queue, removing all jobs that are still queued.
     * 		Note that this does not have any effect on jobs whose execution has already begun,
     * 		it only flushes jobs that are queued and have not yet begun execution.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onClearJobsRequest (const ::boost::shared_ptr< ClearJobsRequest >& request) = 0;

    /**
     * The method sendClearJobsResponse() sends a response of a previous
     * method invocation of 'ClearJobs' back to the client.
     *
     * <b>Documentation of 'ClearJobs'</b>:
     *
     * ClearJobs() flushes the job queue, removing all jobs that are still queued.
     * 		Note that this does not have any effect on jobs whose execution has already begun,
     * 		it only flushes jobs that are queued and have not yet begun execution.
     *
     * @param act The parameter act identifies a previous invocation of
     * onClearJobs(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendClearJobsResponse (act_t act = 0);

    /**
     * The method sendClearJobsError() sends an error response of a previous
     * method invocation of 'ClearJobs' back to the client.
     *
     * <b>Documentation of 'ClearJobs'</b>:
     *
     * ClearJobs() flushes the job queue, removing all jobs that are still queued.
     * 		Note that this does not have any effect on jobs whose execution has already begun,
     * 		it only flushes jobs that are queued and have not yet begun execution.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onClearJobs(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendClearJobsError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ResetFailed'

    /**
     * The method onResetFailed() is called by ASF when a client invokes the
     * method 'ResetFailed'. A subclass has to implement this method and send
     * back a response to the client either with the sendResetFailed() or
     * sendResetFailedError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'ResetFailed'</b>:
     *
     * ResetFailed() resets the "failed" state of all units.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onResetFailedRequest (const ::boost::shared_ptr< ResetFailedRequest >& request) = 0;

    /**
     * The method sendResetFailedResponse() sends a response of a previous
     * method invocation of 'ResetFailed' back to the client.
     *
     * <b>Documentation of 'ResetFailed'</b>:
     *
     * ResetFailed() resets the "failed" state of all units.
     *
     * @param act The parameter act identifies a previous invocation of
     * onResetFailed(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendResetFailedResponse (act_t act = 0);

    /**
     * The method sendResetFailedError() sends an error response of a previous
     * method invocation of 'ResetFailed' back to the client.
     *
     * <b>Documentation of 'ResetFailed'</b>:
     *
     * ResetFailed() resets the "failed" state of all units.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onResetFailed(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendResetFailedError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ListUnits'

    /**
     * The method onListUnits() is called by ASF when a client invokes the
     * method 'ListUnits'. A subclass has to implement this method and send
     * back a response to the client either with the sendListUnits() or
     * sendListUnitsError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'ListUnits'</b>:
     *
     * ListUnits() returns an array with all currently loaded units. Note that units may be known by multiple names at the same name,
     * 		and hence there might be more unit names loaded than actual units behind them. The array consists of structures with the following elements:
     *
     *     	The primary unit name as string
     *     	The human readable description string
     *     	The load state (i.e. whether the unit file has been loaded successfully)
     *     	The active state (i.e. whether the unit is currently started or not)
     *     	The sub state (a more fine-grained version of the active state that is specific to the unit type, which the active state is not)
     *     	A unit that is being followed in its state by this unit, if there is any, otherwise the empty string.
     *     	The unit object path
     *     	If there is a job queued for the job unit the numeric job id, 0 otherwise
     *     	The job type as string
     *     	The job object path
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onListUnitsRequest (const ::boost::shared_ptr< ListUnitsRequest >& request) = 0;

    /**
     * The method sendListUnitsResponse() sends a response of a previous
     * method invocation of 'ListUnits' back to the client.
     *
     * <b>Documentation of 'ListUnits'</b>:
     *
     * ListUnits() returns an array with all currently loaded units. Note that units may be known by multiple names at the same name,
     * 		and hence there might be more unit names loaded than actual units behind them. The array consists of structures with the following elements:
     *
     *     	The primary unit name as string
     *     	The human readable description string
     *     	The load state (i.e. whether the unit file has been loaded successfully)
     *     	The active state (i.e. whether the unit is currently started or not)
     *     	The sub state (a more fine-grained version of the active state that is specific to the unit type, which the active state is not)
     *     	A unit that is being followed in its state by this unit, if there is any, otherwise the empty string.
     *     	The unit object path
     *     	If there is a job queued for the job unit the numeric job id, 0 otherwise
     *     	The job type as string
     *     	The job object path
     *
     * @param units If the meaning of "units" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onListUnits(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendListUnitsResponse (const ::std::vector< units >& units, act_t act = 0);

    /**
     * The method sendListUnitsError() sends an error response of a previous
     * method invocation of 'ListUnits' back to the client.
     *
     * <b>Documentation of 'ListUnits'</b>:
     *
     * ListUnits() returns an array with all currently loaded units. Note that units may be known by multiple names at the same name,
     * 		and hence there might be more unit names loaded than actual units behind them. The array consists of structures with the following elements:
     *
     *     	The primary unit name as string
     *     	The human readable description string
     *     	The load state (i.e. whether the unit file has been loaded successfully)
     *     	The active state (i.e. whether the unit is currently started or not)
     *     	The sub state (a more fine-grained version of the active state that is specific to the unit type, which the active state is not)
     *     	A unit that is being followed in its state by this unit, if there is any, otherwise the empty string.
     *     	The unit object path
     *     	If there is a job queued for the job unit the numeric job id, 0 otherwise
     *     	The job type as string
     *     	The job object path
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onListUnits(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendListUnitsError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ListUnitsFiltered'

    /**
     * The method onListUnitsFiltered() is called by ASF when a client invokes
     * the method 'ListUnitsFiltered'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendListUnitsFiltered() or sendListUnitsFilteredError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'ListUnitsFiltered'</b>:
     *
     * ListUnitsFiltered
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onListUnitsFilteredRequest (const ::boost::shared_ptr< ListUnitsFilteredRequest >& request) = 0;

    /**
     * The method sendListUnitsFilteredResponse() sends a response of a
     * previous method invocation of 'ListUnitsFiltered' back to the client.
     *
     * <b>Documentation of 'ListUnitsFiltered'</b>:
     *
     * ListUnitsFiltered
     *
     * @param units If the meaning of "units" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onListUnitsFiltered(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendListUnitsFilteredResponse (const ::std::vector< units >& units, act_t act = 0);

    /**
     * The method sendListUnitsFilteredError() sends an error response of a
     * previous method invocation of 'ListUnitsFiltered' back to the client.
     *
     * <b>Documentation of 'ListUnitsFiltered'</b>:
     *
     * ListUnitsFiltered
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onListUnitsFiltered().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendListUnitsFilteredError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ListJobs'

    /**
     * The method onListJobs() is called by ASF when a client invokes the
     * method 'ListJobs'. A subclass has to implement this method and send
     * back a response to the client either with the sendListJobs() or
     * sendListJobsError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'ListJobs'</b>:
     *
     * ListJobs() returns an array with all currently queued jobs. Returns an array consisting of structures with the following elements:
     *
     *    		 The numeric job id
     *     	The primary unit name for this job
     *     	The job type as string
     *     	The job state as string
     *     	The job object path
     *     	The unit object path
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onListJobsRequest (const ::boost::shared_ptr< ListJobsRequest >& request) = 0;

    /**
     * The method sendListJobsResponse() sends a response of a previous method
     * invocation of 'ListJobs' back to the client.
     *
     * <b>Documentation of 'ListJobs'</b>:
     *
     * ListJobs() returns an array with all currently queued jobs. Returns an array consisting of structures with the following elements:
     *
     *    		 The numeric job id
     *     	The primary unit name for this job
     *     	The job type as string
     *     	The job state as string
     *     	The job object path
     *     	The unit object path
     *
     * @param jobs If the meaning of "jobs" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onListJobs(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendListJobsResponse (const ::std::vector< jobs >& jobs, act_t act = 0);

    /**
     * The method sendListJobsError() sends an error response of a previous
     * method invocation of 'ListJobs' back to the client.
     *
     * <b>Documentation of 'ListJobs'</b>:
     *
     * ListJobs() returns an array with all currently queued jobs. Returns an array consisting of structures with the following elements:
     *
     *    		 The numeric job id
     *     	The primary unit name for this job
     *     	The job type as string
     *     	The job state as string
     *     	The job object path
     *     	The unit object path
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onListJobs(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendListJobsError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'Subscribe'

    /**
     * The method onSubscribe() is called by ASF when a client invokes the
     * method 'Subscribe'. A subclass has to implement this method and send
     * back a response to the client either with the sendSubscribe() or
     * sendSubscribeError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'Subscribe'</b>:
     *
     * Subscribe() enables most bus signals to be sent out.
     * 		Clients which are interested in signals need to call this function. Signals are only sent out if at least one client invoked this function.
     * 		Unsubscribe() undoes the signal subscription that Subscribe() implements. It is not necessary to invoke Unsubscribe() as clients are tracked.
     * 		Signals are no longer sent out as soon as all clients which previously asked for Subscribe() either closed the bus connection or invoked Unsubscribe().
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSubscribeRequest (const ::boost::shared_ptr< SubscribeRequest >& request) = 0;

    /**
     * The method sendSubscribeResponse() sends a response of a previous
     * method invocation of 'Subscribe' back to the client.
     *
     * <b>Documentation of 'Subscribe'</b>:
     *
     * Subscribe() enables most bus signals to be sent out.
     * 		Clients which are interested in signals need to call this function. Signals are only sent out if at least one client invoked this function.
     * 		Unsubscribe() undoes the signal subscription that Subscribe() implements. It is not necessary to invoke Unsubscribe() as clients are tracked.
     * 		Signals are no longer sent out as soon as all clients which previously asked for Subscribe() either closed the bus connection or invoked Unsubscribe().
     *
     * @param act The parameter act identifies a previous invocation of
     * onSubscribe(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendSubscribeResponse (act_t act = 0);

    /**
     * The method sendSubscribeError() sends an error response of a previous
     * method invocation of 'Subscribe' back to the client.
     *
     * <b>Documentation of 'Subscribe'</b>:
     *
     * Subscribe() enables most bus signals to be sent out.
     * 		Clients which are interested in signals need to call this function. Signals are only sent out if at least one client invoked this function.
     * 		Unsubscribe() undoes the signal subscription that Subscribe() implements. It is not necessary to invoke Unsubscribe() as clients are tracked.
     * 		Signals are no longer sent out as soon as all clients which previously asked for Subscribe() either closed the bus connection or invoked Unsubscribe().
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSubscribe(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendSubscribeError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'Unsubscribe'

    /**
     * The method onUnsubscribe() is called by ASF when a client invokes the
     * method 'Unsubscribe'. A subclass has to implement this method and send
     * back a response to the client either with the sendUnsubscribe() or
     * sendUnsubscribeError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'Unsubscribe'</b>:
     *
     * Unsubscribe
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onUnsubscribeRequest (const ::boost::shared_ptr< UnsubscribeRequest >& request) = 0;

    /**
     * The method sendUnsubscribeResponse() sends a response of a previous
     * method invocation of 'Unsubscribe' back to the client.
     *
     * <b>Documentation of 'Unsubscribe'</b>:
     *
     * Unsubscribe
     *
     * @param act The parameter act identifies a previous invocation of
     * onUnsubscribe(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendUnsubscribeResponse (act_t act = 0);

    /**
     * The method sendUnsubscribeError() sends an error response of a previous
     * method invocation of 'Unsubscribe' back to the client.
     *
     * <b>Documentation of 'Unsubscribe'</b>:
     *
     * Unsubscribe
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onUnsubscribe(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendUnsubscribeError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'Dump'

    /**
     * The method onDump() is called by ASF when a client invokes the method
     * 'Dump'. A subclass has to implement this method and send back a
     * response to the client either with the sendDump() or sendDumpError()
     * method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'Dump'</b>:
     *
     * Dump
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onDumpRequest (const ::boost::shared_ptr< DumpRequest >& request) = 0;

    /**
     * The method sendDumpResponse() sends a response of a previous method
     * invocation of 'Dump' back to the client.
     *
     * <b>Documentation of 'Dump'</b>:
     *
     * Dump
     *
     * @param dump If the meaning of "dump" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onDump(). If the act is not specified, i.e. the most recent invocation
     * will be answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendDumpResponse (const ::std::string& dump, act_t act = 0);

    /**
     * The method sendDumpError() sends an error response of a previous method
     * invocation of 'Dump' back to the client.
     *
     * <b>Documentation of 'Dump'</b>:
     *
     * Dump
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onDump(). If the act is
     * not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendDumpError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'CreateSnapshot'

    /**
     * The method onCreateSnapshot() is called by ASF when a client invokes
     * the method 'CreateSnapshot'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendCreateSnapshot() or sendCreateSnapshotError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'CreateSnapshot'</b>:
     *
     * CreateSnapshot() creates a snapshot unit for the current system state, and stores it under the specified name.
     * 		It will return the unit object path to the new snapshot. If the cleanup boolean is true the snapshot will be removed automatically
     * 		when it has been activated, otherwise it remains and can be activated multiple times. Snapshots are not persistent
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onCreateSnapshotRequest (const ::boost::shared_ptr< CreateSnapshotRequest >& request) = 0;

    /**
     * The method sendCreateSnapshotResponse() sends a response of a previous
     * method invocation of 'CreateSnapshot' back to the client.
     *
     * <b>Documentation of 'CreateSnapshot'</b>:
     *
     * CreateSnapshot() creates a snapshot unit for the current system state, and stores it under the specified name.
     * 		It will return the unit object path to the new snapshot. If the cleanup boolean is true the snapshot will be removed automatically
     * 		when it has been activated, otherwise it remains and can be activated multiple times. Snapshots are not persistent
     *
     * @param unit If the meaning of "unit" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onCreateSnapshot(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendCreateSnapshotResponse (const ::std::string& unit, act_t act = 0);

    /**
     * The method sendCreateSnapshotError() sends an error response of a
     * previous method invocation of 'CreateSnapshot' back to the client.
     *
     * <b>Documentation of 'CreateSnapshot'</b>:
     *
     * CreateSnapshot() creates a snapshot unit for the current system state, and stores it under the specified name.
     * 		It will return the unit object path to the new snapshot. If the cleanup boolean is true the snapshot will be removed automatically
     * 		when it has been activated, otherwise it remains and can be activated multiple times. Snapshots are not persistent
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onCreateSnapshot(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendCreateSnapshotError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'RemoveSnapshot'

    /**
     * The method onRemoveSnapshot() is called by ASF when a client invokes
     * the method 'RemoveSnapshot'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendRemoveSnapshot() or sendRemoveSnapshotError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'RemoveSnapshot'</b>:
     *
     * RemoveSnapshot() removes a snapshot. This call is also available in the Remove() method of
     * 		Snapshot objects (see below), and exists primarily to reduce the number of required roundtrips for this call.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRemoveSnapshotRequest (const ::boost::shared_ptr< RemoveSnapshotRequest >& request) = 0;

    /**
     * The method sendRemoveSnapshotResponse() sends a response of a previous
     * method invocation of 'RemoveSnapshot' back to the client.
     *
     * <b>Documentation of 'RemoveSnapshot'</b>:
     *
     * RemoveSnapshot() removes a snapshot. This call is also available in the Remove() method of
     * 		Snapshot objects (see below), and exists primarily to reduce the number of required roundtrips for this call.
     *
     * @param act The parameter act identifies a previous invocation of
     * onRemoveSnapshot(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendRemoveSnapshotResponse (act_t act = 0);

    /**
     * The method sendRemoveSnapshotError() sends an error response of a
     * previous method invocation of 'RemoveSnapshot' back to the client.
     *
     * <b>Documentation of 'RemoveSnapshot'</b>:
     *
     * RemoveSnapshot() removes a snapshot. This call is also available in the Remove() method of
     * 		Snapshot objects (see below), and exists primarily to reduce the number of required roundtrips for this call.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onRemoveSnapshot(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendRemoveSnapshotError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'Reload'

    /**
     * The method onReload() is called by ASF when a client invokes the method
     * 'Reload'. A subclass has to implement this method and send back a
     * response to the client either with the sendReload() or
     * sendReloadError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'Reload'</b>:
     *
     * Reload() may be invoked to reload all unit files.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onReloadRequest (const ::boost::shared_ptr< ReloadRequest >& request) = 0;

    /**
     * The method sendReloadResponse() sends a response of a previous method
     * invocation of 'Reload' back to the client.
     *
     * <b>Documentation of 'Reload'</b>:
     *
     * Reload() may be invoked to reload all unit files.
     *
     * @param act The parameter act identifies a previous invocation of
     * onReload(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendReloadResponse (act_t act = 0);

    /**
     * The method sendReloadError() sends an error response of a previous
     * method invocation of 'Reload' back to the client.
     *
     * <b>Documentation of 'Reload'</b>:
     *
     * Reload() may be invoked to reload all unit files.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onReload(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendReloadError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'Reexecute'

    /**
     * The method onReexecute() is called by ASF when a client invokes the
     * method 'Reexecute'. A subclass has to implement this method and send
     * back a response to the client either with the sendReexecute() or
     * sendReexecuteError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'Reexecute'</b>:
     *
     * Reexecute() may be invoked to reexecute the main manager process.
     * 		It will serialize its state, reexecute, and deserizalize the state again. This is useful for upgrades and is a more comprehensive version of Reload().
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onReexecuteRequest (const ::boost::shared_ptr< ReexecuteRequest >& request) = 0;

    /**
     * The method sendReexecuteResponse() sends a response of a previous
     * method invocation of 'Reexecute' back to the client.
     *
     * <b>Documentation of 'Reexecute'</b>:
     *
     * Reexecute() may be invoked to reexecute the main manager process.
     * 		It will serialize its state, reexecute, and deserizalize the state again. This is useful for upgrades and is a more comprehensive version of Reload().
     *
     * @param act The parameter act identifies a previous invocation of
     * onReexecute(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendReexecuteResponse (act_t act = 0);

    /**
     * The method sendReexecuteError() sends an error response of a previous
     * method invocation of 'Reexecute' back to the client.
     *
     * <b>Documentation of 'Reexecute'</b>:
     *
     * Reexecute() may be invoked to reexecute the main manager process.
     * 		It will serialize its state, reexecute, and deserizalize the state again. This is useful for upgrades and is a more comprehensive version of Reload().
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onReexecute(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendReexecuteError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'Exit'

    /**
     * The method onExit() is called by ASF when a client invokes the method
     * 'Exit'. A subclass has to implement this method and send back a
     * response to the client either with the sendExit() or sendExitError()
     * method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'Exit'</b>:
     *
     * Exit() may be invoked to ask the manager to exit. This is not available for the system manager and is useful only for user session managers.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onExitRequest (const ::boost::shared_ptr< ExitRequest >& request) = 0;

    /**
     * The method sendExitResponse() sends a response of a previous method
     * invocation of 'Exit' back to the client.
     *
     * <b>Documentation of 'Exit'</b>:
     *
     * Exit() may be invoked to ask the manager to exit. This is not available for the system manager and is useful only for user session managers.
     *
     * @param act The parameter act identifies a previous invocation of
     * onExit(). If the act is not specified, i.e. the most recent invocation
     * will be answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendExitResponse (act_t act = 0);

    /**
     * The method sendExitError() sends an error response of a previous method
     * invocation of 'Exit' back to the client.
     *
     * <b>Documentation of 'Exit'</b>:
     *
     * Exit() may be invoked to ask the manager to exit. This is not available for the system manager and is useful only for user session managers.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onExit(). If the act is
     * not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendExitError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'Reboot'

    /**
     * The method onReboot() is called by ASF when a client invokes the method
     * 'Reboot'. A subclass has to implement this method and send back a
     * response to the client either with the sendReboot() or
     * sendRebootError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'Reboot'</b>:
     *
     * Reboot(), PowerOff(), Halt(), KExec() may be used to ask for immediate reboot, powering down, halt or kexec based reboot of the system.
     * 		Note that this does not shut down any services and immediately transitions into the reboot process.
     * 		These functions are normally only called as last step of shutdown, and should not be called directly.
     * 		To shut down the machine it is a much better choice generally to invoke Reboot() and PoweOff() on the logind manager object. See On logind for more information.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRebootRequest (const ::boost::shared_ptr< RebootRequest >& request) = 0;

    /**
     * The method sendRebootResponse() sends a response of a previous method
     * invocation of 'Reboot' back to the client.
     *
     * <b>Documentation of 'Reboot'</b>:
     *
     * Reboot(), PowerOff(), Halt(), KExec() may be used to ask for immediate reboot, powering down, halt or kexec based reboot of the system.
     * 		Note that this does not shut down any services and immediately transitions into the reboot process.
     * 		These functions are normally only called as last step of shutdown, and should not be called directly.
     * 		To shut down the machine it is a much better choice generally to invoke Reboot() and PoweOff() on the logind manager object. See On logind for more information.
     *
     * @param act The parameter act identifies a previous invocation of
     * onReboot(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendRebootResponse (act_t act = 0);

    /**
     * The method sendRebootError() sends an error response of a previous
     * method invocation of 'Reboot' back to the client.
     *
     * <b>Documentation of 'Reboot'</b>:
     *
     * Reboot(), PowerOff(), Halt(), KExec() may be used to ask for immediate reboot, powering down, halt or kexec based reboot of the system.
     * 		Note that this does not shut down any services and immediately transitions into the reboot process.
     * 		These functions are normally only called as last step of shutdown, and should not be called directly.
     * 		To shut down the machine it is a much better choice generally to invoke Reboot() and PoweOff() on the logind manager object. See On logind for more information.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onReboot(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendRebootError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'PowerOff'

    /**
     * The method onPowerOff() is called by ASF when a client invokes the
     * method 'PowerOff'. A subclass has to implement this method and send
     * back a response to the client either with the sendPowerOff() or
     * sendPowerOffError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'PowerOff'</b>:
     *
     * PowerOff()
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onPowerOffRequest (const ::boost::shared_ptr< PowerOffRequest >& request) = 0;

    /**
     * The method sendPowerOffResponse() sends a response of a previous method
     * invocation of 'PowerOff' back to the client.
     *
     * <b>Documentation of 'PowerOff'</b>:
     *
     * PowerOff()
     *
     * @param act The parameter act identifies a previous invocation of
     * onPowerOff(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendPowerOffResponse (act_t act = 0);

    /**
     * The method sendPowerOffError() sends an error response of a previous
     * method invocation of 'PowerOff' back to the client.
     *
     * <b>Documentation of 'PowerOff'</b>:
     *
     * PowerOff()
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onPowerOff(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendPowerOffError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'Halt'

    /**
     * The method onHalt() is called by ASF when a client invokes the method
     * 'Halt'. A subclass has to implement this method and send back a
     * response to the client either with the sendHalt() or sendHaltError()
     * method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'Halt'</b>:
     *
     * Halt()
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onHaltRequest (const ::boost::shared_ptr< HaltRequest >& request) = 0;

    /**
     * The method sendHaltResponse() sends a response of a previous method
     * invocation of 'Halt' back to the client.
     *
     * <b>Documentation of 'Halt'</b>:
     *
     * Halt()
     *
     * @param act The parameter act identifies a previous invocation of
     * onHalt(). If the act is not specified, i.e. the most recent invocation
     * will be answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendHaltResponse (act_t act = 0);

    /**
     * The method sendHaltError() sends an error response of a previous method
     * invocation of 'Halt' back to the client.
     *
     * <b>Documentation of 'Halt'</b>:
     *
     * Halt()
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onHalt(). If the act is
     * not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendHaltError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'KExec'

    /**
     * The method onKExec() is called by ASF when a client invokes the method
     * 'KExec'. A subclass has to implement this method and send back a
     * response to the client either with the sendKExec() or sendKExecError()
     * method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'KExec'</b>:
     *
     * KExec()
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onKExecRequest (const ::boost::shared_ptr< KExecRequest >& request) = 0;

    /**
     * The method sendKExecResponse() sends a response of a previous method
     * invocation of 'KExec' back to the client.
     *
     * <b>Documentation of 'KExec'</b>:
     *
     * KExec()
     *
     * @param act The parameter act identifies a previous invocation of
     * onKExec(). If the act is not specified, i.e. the most recent invocation
     * will be answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendKExecResponse (act_t act = 0);

    /**
     * The method sendKExecError() sends an error response of a previous
     * method invocation of 'KExec' back to the client.
     *
     * <b>Documentation of 'KExec'</b>:
     *
     * KExec()
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onKExec(). If the act is
     * not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendKExecError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'SwitchRoot'

    /**
     * The method onSwitchRoot() is called by ASF when a client invokes the
     * method 'SwitchRoot'. A subclass has to implement this method and send
     * back a response to the client either with the sendSwitchRoot() or
     * sendSwitchRootError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'SwitchRoot'</b>:
     *
     * SwitchRoot() may be used to transition to a new root directory. This is intended to be used by initial RAM disks.
     *  		The call takes two arguments: the new root directory (which needs to be specified), plus an init binary path (which may be left empty,
     *  		in which case it is automatically searched for).
     *  		The state of the system manager will be serialized before the transition.
     *  		After the transition the manager binary on the main system is invoked and replaces the old PID 1. All state will then be deserialized.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSwitchRootRequest (const ::boost::shared_ptr< SwitchRootRequest >& request) = 0;

    /**
     * The method sendSwitchRootResponse() sends a response of a previous
     * method invocation of 'SwitchRoot' back to the client.
     *
     * <b>Documentation of 'SwitchRoot'</b>:
     *
     * SwitchRoot() may be used to transition to a new root directory. This is intended to be used by initial RAM disks.
     *  		The call takes two arguments: the new root directory (which needs to be specified), plus an init binary path (which may be left empty,
     *  		in which case it is automatically searched for).
     *  		The state of the system manager will be serialized before the transition.
     *  		After the transition the manager binary on the main system is invoked and replaces the old PID 1. All state will then be deserialized.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSwitchRoot(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendSwitchRootResponse (act_t act = 0);

    /**
     * The method sendSwitchRootError() sends an error response of a previous
     * method invocation of 'SwitchRoot' back to the client.
     *
     * <b>Documentation of 'SwitchRoot'</b>:
     *
     * SwitchRoot() may be used to transition to a new root directory. This is intended to be used by initial RAM disks.
     *  		The call takes two arguments: the new root directory (which needs to be specified), plus an init binary path (which may be left empty,
     *  		in which case it is automatically searched for).
     *  		The state of the system manager will be serialized before the transition.
     *  		After the transition the manager binary on the main system is invoked and replaces the old PID 1. All state will then be deserialized.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSwitchRoot(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendSwitchRootError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'SetEnvironment'

    /**
     * The method onSetEnvironment() is called by ASF when a client invokes
     * the method 'SetEnvironment'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendSetEnvironment() or sendSetEnvironmentError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'SetEnvironment'</b>:
     *
     * SetEnvironment() may be used to alter the environment block that is passed to all spawned processes.
     * 	    Takes a string array with environment variable assignments. Settings passed will override previously set variables
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetEnvironmentRequest (const ::boost::shared_ptr< SetEnvironmentRequest >& request) = 0;

    /**
     * The method sendSetEnvironmentResponse() sends a response of a previous
     * method invocation of 'SetEnvironment' back to the client.
     *
     * <b>Documentation of 'SetEnvironment'</b>:
     *
     * SetEnvironment() may be used to alter the environment block that is passed to all spawned processes.
     * 	    Takes a string array with environment variable assignments. Settings passed will override previously set variables
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetEnvironment(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendSetEnvironmentResponse (act_t act = 0);

    /**
     * The method sendSetEnvironmentError() sends an error response of a
     * previous method invocation of 'SetEnvironment' back to the client.
     *
     * <b>Documentation of 'SetEnvironment'</b>:
     *
     * SetEnvironment() may be used to alter the environment block that is passed to all spawned processes.
     * 	    Takes a string array with environment variable assignments. Settings passed will override previously set variables
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSetEnvironment(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSetEnvironmentError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'UnsetEnvironment'

    /**
     * The method onUnsetEnvironment() is called by ASF when a client invokes
     * the method 'UnsetEnvironment'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendUnsetEnvironment() or sendUnsetEnvironmentError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'UnsetEnvironment'</b>:
     *
     * UnsetEnvironment() may be used to unset environment variables. Takes a string array with environment variable names.
     * 		All variables specified will be unset (if they have been set previously) and no longer be passed to all spawned processes.
     * 		This call has no effect for variables that were previously not set, but will not fail in that case.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onUnsetEnvironmentRequest (const ::boost::shared_ptr< UnsetEnvironmentRequest >& request) = 0;

    /**
     * The method sendUnsetEnvironmentResponse() sends a response of a
     * previous method invocation of 'UnsetEnvironment' back to the client.
     *
     * <b>Documentation of 'UnsetEnvironment'</b>:
     *
     * UnsetEnvironment() may be used to unset environment variables. Takes a string array with environment variable names.
     * 		All variables specified will be unset (if they have been set previously) and no longer be passed to all spawned processes.
     * 		This call has no effect for variables that were previously not set, but will not fail in that case.
     *
     * @param act The parameter act identifies a previous invocation of
     * onUnsetEnvironment(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendUnsetEnvironmentResponse (act_t act = 0);

    /**
     * The method sendUnsetEnvironmentError() sends an error response of a
     * previous method invocation of 'UnsetEnvironment' back to the client.
     *
     * <b>Documentation of 'UnsetEnvironment'</b>:
     *
     * UnsetEnvironment() may be used to unset environment variables. Takes a string array with environment variable names.
     * 		All variables specified will be unset (if they have been set previously) and no longer be passed to all spawned processes.
     * 		This call has no effect for variables that were previously not set, but will not fail in that case.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onUnsetEnvironment(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendUnsetEnvironmentError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'UnsetAndSetEnvironment'

    /**
     * The method onUnsetAndSetEnvironment() is called by ASF when a client
     * invokes the method 'UnsetAndSetEnvironment'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendUnsetAndSetEnvironment() or
     * sendUnsetAndSetEnvironmentError() method. Do not invoke this method on
     * your own.
     *
     * <b>Documentation of 'UnsetAndSetEnvironment'</b>:
     *
     * UnsetAndSetEnvironment() is a combination of UnsetEnvironment() and SetEnvironment().
     * 		It takes two lists. The first one is a list of variables to unset, the second one of assignments to set.
     * 		If a variable is listed in both the variable is set after this call, i.e. the set list overrides the unset list.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onUnsetAndSetEnvironmentRequest (const ::boost::shared_ptr< UnsetAndSetEnvironmentRequest >& request) = 0;

    /**
     * The method sendUnsetAndSetEnvironmentResponse() sends a response of a
     * previous method invocation of 'UnsetAndSetEnvironment' back to the
     * client.
     *
     * <b>Documentation of 'UnsetAndSetEnvironment'</b>:
     *
     * UnsetAndSetEnvironment() is a combination of UnsetEnvironment() and SetEnvironment().
     * 		It takes two lists. The first one is a list of variables to unset, the second one of assignments to set.
     * 		If a variable is listed in both the variable is set after this call, i.e. the set list overrides the unset list.
     *
     * @param act The parameter act identifies a previous invocation of
     * onUnsetAndSetEnvironment(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendUnsetAndSetEnvironmentResponse (act_t act = 0);

    /**
     * The method sendUnsetAndSetEnvironmentError() sends an error response of
     * a previous method invocation of 'UnsetAndSetEnvironment' back to the
     * client.
     *
     * <b>Documentation of 'UnsetAndSetEnvironment'</b>:
     *
     * UnsetAndSetEnvironment() is a combination of UnsetEnvironment() and SetEnvironment().
     * 		It takes two lists. The first one is a list of variables to unset, the second one of assignments to set.
     * 		If a variable is listed in both the variable is set after this call, i.e. the set list overrides the unset list.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onUnsetAndSetEnvironment(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendUnsetAndSetEnvironmentError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ListUnitFiles'

    /**
     * The method onListUnitFiles() is called by ASF when a client invokes the
     * method 'ListUnitFiles'. A subclass has to implement this method and
     * send back a response to the client either with the sendListUnitFiles()
     * or sendListUnitFilesError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'ListUnitFiles'</b>:
     *
     * ListUnitFiles() returns an array of unit names plus their enablement status.
     * 		Note that ListUnit() returns a list of units currently loaded into memory, while ListUnitFiles()
     * 		returns a list of unit files that could be found on disk. Note that while most units are read directly from a unit file with the same name
     * 		some units are not backed by files, and some files (templates) cannot directly be loaded as units but need to be instantiated.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onListUnitFilesRequest (const ::boost::shared_ptr< ListUnitFilesRequest >& request) = 0;

    /**
     * The method sendListUnitFilesResponse() sends a response of a previous
     * method invocation of 'ListUnitFiles' back to the client.
     *
     * <b>Documentation of 'ListUnitFiles'</b>:
     *
     * ListUnitFiles() returns an array of unit names plus their enablement status.
     * 		Note that ListUnit() returns a list of units currently loaded into memory, while ListUnitFiles()
     * 		returns a list of unit files that could be found on disk. Note that while most units are read directly from a unit file with the same name
     * 		some units are not backed by files, and some files (templates) cannot directly be loaded as units but need to be instantiated.
     *
     * @param files If the meaning of "files" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onListUnitFiles(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendListUnitFilesResponse (const ::std::vector< files >& files, act_t act = 0);

    /**
     * The method sendListUnitFilesError() sends an error response of a
     * previous method invocation of 'ListUnitFiles' back to the client.
     *
     * <b>Documentation of 'ListUnitFiles'</b>:
     *
     * ListUnitFiles() returns an array of unit names plus their enablement status.
     * 		Note that ListUnit() returns a list of units currently loaded into memory, while ListUnitFiles()
     * 		returns a list of unit files that could be found on disk. Note that while most units are read directly from a unit file with the same name
     * 		some units are not backed by files, and some files (templates) cannot directly be loaded as units but need to be instantiated.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onListUnitFiles(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendListUnitFilesError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'GetUnitFileState'

    /**
     * The method onGetUnitFileState() is called by ASF when a client invokes
     * the method 'GetUnitFileState'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendGetUnitFileState() or sendGetUnitFileStateError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'GetUnitFileState'</b>:
     *
     * GetUnitFileState() returns the current enablement status of specific unit file.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetUnitFileStateRequest (const ::boost::shared_ptr< GetUnitFileStateRequest >& request) = 0;

    /**
     * The method sendGetUnitFileStateResponse() sends a response of a
     * previous method invocation of 'GetUnitFileState' back to the client.
     *
     * <b>Documentation of 'GetUnitFileState'</b>:
     *
     * GetUnitFileState() returns the current enablement status of specific unit file.
     *
     * @param state If the meaning of "state" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetUnitFileState(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendGetUnitFileStateResponse (const ::std::string& state, act_t act = 0);

    /**
     * The method sendGetUnitFileStateError() sends an error response of a
     * previous method invocation of 'GetUnitFileState' back to the client.
     *
     * <b>Documentation of 'GetUnitFileState'</b>:
     *
     * GetUnitFileState() returns the current enablement status of specific unit file.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetUnitFileState(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendGetUnitFileStateError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'EnableUnitFiles'

    /**
     * The method onEnableUnitFiles() is called by ASF when a client invokes
     * the method 'EnableUnitFiles'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendEnableUnitFiles() or sendEnableUnitFilesError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'EnableUnitFiles'</b>:
     *
     * EnableUnitFiles() may be used to enable one or more units in the system (by creating symlinks to them in /etc or /run).
     * 		It takes a list of unit files to enable (either just file names or full absolute paths if the unit files are residing outside the usual unit search paths),
     * 		and two booleans: the first controls whether the unit shall be enabled for runtime only (true, /run), or persistently (false, /etc).
     * 		The second one controls whether symlinks pointing to other units shall be replaced if necessary. This call returns one boolean and an array with the changes made.
     * 		The boolean signals whether the unit files contained any enablement information (i.e. an [Install]) section.
     * 		The changes list consists of structures with three strings: the type of the change (one of symlink or unlink),
     * 		the file name of the symlink and the destination of the symlink. Note that most of the following calls return a changes list in the same format.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onEnableUnitFilesRequest (const ::boost::shared_ptr< EnableUnitFilesRequest >& request) = 0;

    /**
     * The method sendEnableUnitFilesResponse() sends a response of a previous
     * method invocation of 'EnableUnitFiles' back to the client.
     *
     * <b>Documentation of 'EnableUnitFiles'</b>:
     *
     * EnableUnitFiles() may be used to enable one or more units in the system (by creating symlinks to them in /etc or /run).
     * 		It takes a list of unit files to enable (either just file names or full absolute paths if the unit files are residing outside the usual unit search paths),
     * 		and two booleans: the first controls whether the unit shall be enabled for runtime only (true, /run), or persistently (false, /etc).
     * 		The second one controls whether symlinks pointing to other units shall be replaced if necessary. This call returns one boolean and an array with the changes made.
     * 		The boolean signals whether the unit files contained any enablement information (i.e. an [Install]) section.
     * 		The changes list consists of structures with three strings: the type of the change (one of symlink or unlink),
     * 		the file name of the symlink and the destination of the symlink. Note that most of the following calls return a changes list in the same format.
     *
     * @param carries_install_info If the meaning of "carries_install_info" isn't clear, then there should be a description here.
     *
     * @param changes If the meaning of "changes" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onEnableUnitFiles(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendEnableUnitFilesResponse (bool carries_install_info, const ::std::vector< changes >& changes, act_t act = 0);

    /**
     * The method sendEnableUnitFilesError() sends an error response of a
     * previous method invocation of 'EnableUnitFiles' back to the client.
     *
     * <b>Documentation of 'EnableUnitFiles'</b>:
     *
     * EnableUnitFiles() may be used to enable one or more units in the system (by creating symlinks to them in /etc or /run).
     * 		It takes a list of unit files to enable (either just file names or full absolute paths if the unit files are residing outside the usual unit search paths),
     * 		and two booleans: the first controls whether the unit shall be enabled for runtime only (true, /run), or persistently (false, /etc).
     * 		The second one controls whether symlinks pointing to other units shall be replaced if necessary. This call returns one boolean and an array with the changes made.
     * 		The boolean signals whether the unit files contained any enablement information (i.e. an [Install]) section.
     * 		The changes list consists of structures with three strings: the type of the change (one of symlink or unlink),
     * 		the file name of the symlink and the destination of the symlink. Note that most of the following calls return a changes list in the same format.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onEnableUnitFiles(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendEnableUnitFilesError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'DisableUnitFiles'

    /**
     * The method onDisableUnitFiles() is called by ASF when a client invokes
     * the method 'DisableUnitFiles'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendDisableUnitFiles() or sendDisableUnitFilesError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'DisableUnitFiles'</b>:
     *
     * DisableUnitFiles() disables one or more units in the system, i.e. removes all symlinks to them in /etc and /run
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onDisableUnitFilesRequest (const ::boost::shared_ptr< DisableUnitFilesRequest >& request) = 0;

    /**
     * The method sendDisableUnitFilesResponse() sends a response of a
     * previous method invocation of 'DisableUnitFiles' back to the client.
     *
     * <b>Documentation of 'DisableUnitFiles'</b>:
     *
     * DisableUnitFiles() disables one or more units in the system, i.e. removes all symlinks to them in /etc and /run
     *
     * @param changes If the meaning of "changes" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onDisableUnitFiles(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendDisableUnitFilesResponse (const ::std::vector< changes >& changes, act_t act = 0);

    /**
     * The method sendDisableUnitFilesError() sends an error response of a
     * previous method invocation of 'DisableUnitFiles' back to the client.
     *
     * <b>Documentation of 'DisableUnitFiles'</b>:
     *
     * DisableUnitFiles() disables one or more units in the system, i.e. removes all symlinks to them in /etc and /run
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onDisableUnitFiles(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendDisableUnitFilesError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ReenableUnitFiles'

    /**
     * The method onReenableUnitFiles() is called by ASF when a client invokes
     * the method 'ReenableUnitFiles'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendReenableUnitFiles() or sendReenableUnitFilesError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'ReenableUnitFiles'</b>:
     *
     * ReenableUnitFiles() applies the changes to one or more units that would result from disabling and enabling the
     * 		unit quickly one after the other in an atomic fashion.
     * 		This is useful to apply updated [Install] information contained in unit files.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onReenableUnitFilesRequest (const ::boost::shared_ptr< ReenableUnitFilesRequest >& request) = 0;

    /**
     * The method sendReenableUnitFilesResponse() sends a response of a
     * previous method invocation of 'ReenableUnitFiles' back to the client.
     *
     * <b>Documentation of 'ReenableUnitFiles'</b>:
     *
     * ReenableUnitFiles() applies the changes to one or more units that would result from disabling and enabling the
     * 		unit quickly one after the other in an atomic fashion.
     * 		This is useful to apply updated [Install] information contained in unit files.
     *
     * @param carries_install_info If the meaning of "carries_install_info" isn't clear, then there should be a description here.
     *
     * @param changes If the meaning of "changes" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onReenableUnitFiles(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendReenableUnitFilesResponse (bool carries_install_info, const ::std::vector< changes >& changes, act_t act = 0);

    /**
     * The method sendReenableUnitFilesError() sends an error response of a
     * previous method invocation of 'ReenableUnitFiles' back to the client.
     *
     * <b>Documentation of 'ReenableUnitFiles'</b>:
     *
     * ReenableUnitFiles() applies the changes to one or more units that would result from disabling and enabling the
     * 		unit quickly one after the other in an atomic fashion.
     * 		This is useful to apply updated [Install] information contained in unit files.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onReenableUnitFiles().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendReenableUnitFilesError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'LinkUnitFiles'

    /**
     * The method onLinkUnitFiles() is called by ASF when a client invokes the
     * method 'LinkUnitFiles'. A subclass has to implement this method and
     * send back a response to the client either with the sendLinkUnitFiles()
     * or sendLinkUnitFilesError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'LinkUnitFiles'</b>:
     *
     * LinkUnitFiles() links unit files (that are located outside of the usual unit search paths) into the unit search path.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onLinkUnitFilesRequest (const ::boost::shared_ptr< LinkUnitFilesRequest >& request) = 0;

    /**
     * The method sendLinkUnitFilesResponse() sends a response of a previous
     * method invocation of 'LinkUnitFiles' back to the client.
     *
     * <b>Documentation of 'LinkUnitFiles'</b>:
     *
     * LinkUnitFiles() links unit files (that are located outside of the usual unit search paths) into the unit search path.
     *
     * @param changes If the meaning of "changes" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onLinkUnitFiles(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendLinkUnitFilesResponse (const ::std::vector< changes >& changes, act_t act = 0);

    /**
     * The method sendLinkUnitFilesError() sends an error response of a
     * previous method invocation of 'LinkUnitFiles' back to the client.
     *
     * <b>Documentation of 'LinkUnitFiles'</b>:
     *
     * LinkUnitFiles() links unit files (that are located outside of the usual unit search paths) into the unit search path.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onLinkUnitFiles(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendLinkUnitFilesError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'PresetUnitFiles'

    /**
     * The method onPresetUnitFiles() is called by ASF when a client invokes
     * the method 'PresetUnitFiles'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendPresetUnitFiles() or sendPresetUnitFilesError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'PresetUnitFiles'</b>:
     *
     * PresetUnitFiles() enables/disables one or more units file according to the preset policy.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onPresetUnitFilesRequest (const ::boost::shared_ptr< PresetUnitFilesRequest >& request) = 0;

    /**
     * The method sendPresetUnitFilesResponse() sends a response of a previous
     * method invocation of 'PresetUnitFiles' back to the client.
     *
     * <b>Documentation of 'PresetUnitFiles'</b>:
     *
     * PresetUnitFiles() enables/disables one or more units file according to the preset policy.
     *
     * @param carries_install_info If the meaning of "carries_install_info" isn't clear, then there should be a description here.
     *
     * @param changes If the meaning of "changes" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onPresetUnitFiles(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendPresetUnitFilesResponse (bool carries_install_info, const ::std::vector< changes >& changes, act_t act = 0);

    /**
     * The method sendPresetUnitFilesError() sends an error response of a
     * previous method invocation of 'PresetUnitFiles' back to the client.
     *
     * <b>Documentation of 'PresetUnitFiles'</b>:
     *
     * PresetUnitFiles() enables/disables one or more units file according to the preset policy.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onPresetUnitFiles(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendPresetUnitFilesError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'PresetUnitFilesWithMode'

    /**
     * The method onPresetUnitFilesWithMode() is called by ASF when a client
     * invokes the method 'PresetUnitFilesWithMode'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendPresetUnitFilesWithMode() or
     * sendPresetUnitFilesWithModeError() method. Do not invoke this method on
     * your own.
     *
     * <b>Documentation of 'PresetUnitFilesWithMode'</b>:
     *
     * PresetUnitFilesWithMode() enables/disables one or more units file according to the preset policy for a given mode.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onPresetUnitFilesWithModeRequest (const ::boost::shared_ptr< PresetUnitFilesWithModeRequest >& request) = 0;

    /**
     * The method sendPresetUnitFilesWithModeResponse() sends a response of a
     * previous method invocation of 'PresetUnitFilesWithMode' back to the
     * client.
     *
     * <b>Documentation of 'PresetUnitFilesWithMode'</b>:
     *
     * PresetUnitFilesWithMode() enables/disables one or more units file according to the preset policy for a given mode.
     *
     * @param carries_install_info If the meaning of "carries_install_info" isn't clear, then there should be a description here.
     *
     * @param changes If the meaning of "changes" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onPresetUnitFilesWithMode(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendPresetUnitFilesWithModeResponse (bool carries_install_info, const ::std::vector< changes >& changes, act_t act = 0);

    /**
     * The method sendPresetUnitFilesWithModeError() sends an error response
     * of a previous method invocation of 'PresetUnitFilesWithMode' back to
     * the client.
     *
     * <b>Documentation of 'PresetUnitFilesWithMode'</b>:
     *
     * PresetUnitFilesWithMode() enables/disables one or more units file according to the preset policy for a given mode.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onPresetUnitFilesWithMode(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendPresetUnitFilesWithModeError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'MaskUnitFiles'

    /**
     * The method onMaskUnitFiles() is called by ASF when a client invokes the
     * method 'MaskUnitFiles'. A subclass has to implement this method and
     * send back a response to the client either with the sendMaskUnitFiles()
     * or sendMaskUnitFilesError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'MaskUnitFiles'</b>:
     *
     * MaskUnitFiles() masks unit files, and UnmaskUnitFiles() unmasks them again.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onMaskUnitFilesRequest (const ::boost::shared_ptr< MaskUnitFilesRequest >& request) = 0;

    /**
     * The method sendMaskUnitFilesResponse() sends a response of a previous
     * method invocation of 'MaskUnitFiles' back to the client.
     *
     * <b>Documentation of 'MaskUnitFiles'</b>:
     *
     * MaskUnitFiles() masks unit files, and UnmaskUnitFiles() unmasks them again.
     *
     * @param changes If the meaning of "changes" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onMaskUnitFiles(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendMaskUnitFilesResponse (const ::std::vector< changes >& changes, act_t act = 0);

    /**
     * The method sendMaskUnitFilesError() sends an error response of a
     * previous method invocation of 'MaskUnitFiles' back to the client.
     *
     * <b>Documentation of 'MaskUnitFiles'</b>:
     *
     * MaskUnitFiles() masks unit files, and UnmaskUnitFiles() unmasks them again.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onMaskUnitFiles(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendMaskUnitFilesError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'UnmaskUnitFiles'

    /**
     * The method onUnmaskUnitFiles() is called by ASF when a client invokes
     * the method 'UnmaskUnitFiles'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendUnmaskUnitFiles() or sendUnmaskUnitFilesError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'UnmaskUnitFiles'</b>:
     *
     * UnmaskUnitFiles()
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onUnmaskUnitFilesRequest (const ::boost::shared_ptr< UnmaskUnitFilesRequest >& request) = 0;

    /**
     * The method sendUnmaskUnitFilesResponse() sends a response of a previous
     * method invocation of 'UnmaskUnitFiles' back to the client.
     *
     * <b>Documentation of 'UnmaskUnitFiles'</b>:
     *
     * UnmaskUnitFiles()
     *
     * @param changes If the meaning of "changes" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onUnmaskUnitFiles(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendUnmaskUnitFilesResponse (const ::std::vector< changes >& changes, act_t act = 0);

    /**
     * The method sendUnmaskUnitFilesError() sends an error response of a
     * previous method invocation of 'UnmaskUnitFiles' back to the client.
     *
     * <b>Documentation of 'UnmaskUnitFiles'</b>:
     *
     * UnmaskUnitFiles()
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onUnmaskUnitFiles(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendUnmaskUnitFilesError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'SetDefaultTarget'

    /**
     * The method onSetDefaultTarget() is called by ASF when a client invokes
     * the method 'SetDefaultTarget'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendSetDefaultTarget() or sendSetDefaultTargetError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'SetDefaultTarget'</b>:
     *
     * SetDefaultTarget() changes the default.target link.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetDefaultTargetRequest (const ::boost::shared_ptr< SetDefaultTargetRequest >& request) = 0;

    /**
     * The method sendSetDefaultTargetResponse() sends a response of a
     * previous method invocation of 'SetDefaultTarget' back to the client.
     *
     * <b>Documentation of 'SetDefaultTarget'</b>:
     *
     * SetDefaultTarget() changes the default.target link.
     *
     * @param changes If the meaning of "changes" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetDefaultTarget(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendSetDefaultTargetResponse (const ::std::vector< changes >& changes, act_t act = 0);

    /**
     * The method sendSetDefaultTargetError() sends an error response of a
     * previous method invocation of 'SetDefaultTarget' back to the client.
     *
     * <b>Documentation of 'SetDefaultTarget'</b>:
     *
     * SetDefaultTarget() changes the default.target link.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSetDefaultTarget(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSetDefaultTargetError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'GetDefaultTarget'

    /**
     * The method onGetDefaultTarget() is called by ASF when a client invokes
     * the method 'GetDefaultTarget'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendGetDefaultTarget() or sendGetDefaultTargetError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'GetDefaultTarget'</b>:
     *
     * GetDefaultTarget()  retrieves the name of the unit to which default.target is aliased.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetDefaultTargetRequest (const ::boost::shared_ptr< GetDefaultTargetRequest >& request) = 0;

    /**
     * The method sendGetDefaultTargetResponse() sends a response of a
     * previous method invocation of 'GetDefaultTarget' back to the client.
     *
     * <b>Documentation of 'GetDefaultTarget'</b>:
     *
     * GetDefaultTarget()  retrieves the name of the unit to which default.target is aliased.
     *
     * @param targetName If the meaning of "targetName" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetDefaultTarget(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendGetDefaultTargetResponse (const ::std::string& targetName, act_t act = 0);

    /**
     * The method sendGetDefaultTargetError() sends an error response of a
     * previous method invocation of 'GetDefaultTarget' back to the client.
     *
     * <b>Documentation of 'GetDefaultTarget'</b>:
     *
     * GetDefaultTarget()  retrieves the name of the unit to which default.target is aliased.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetDefaultTarget(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendGetDefaultTargetError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'PresetAllUnitFiles'

    /**
     * The method onPresetAllUnitFiles() is called by ASF when a client
     * invokes the method 'PresetAllUnitFiles'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendPresetAllUnitFiles() or sendPresetAllUnitFilesError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'PresetAllUnitFiles'</b>:
     *
     * PresetAllUnitFiles() enables/disables one or more units file according to the preset policy.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onPresetAllUnitFilesRequest (const ::boost::shared_ptr< PresetAllUnitFilesRequest >& request) = 0;

    /**
     * The method sendPresetAllUnitFilesResponse() sends a response of a
     * previous method invocation of 'PresetAllUnitFiles' back to the client.
     *
     * <b>Documentation of 'PresetAllUnitFiles'</b>:
     *
     * PresetAllUnitFiles() enables/disables one or more units file according to the preset policy.
     *
     * @param changes If the meaning of "changes" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onPresetAllUnitFiles(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendPresetAllUnitFilesResponse (const ::std::vector< changes >& changes, act_t act = 0);

    /**
     * The method sendPresetAllUnitFilesError() sends an error response of a
     * previous method invocation of 'PresetAllUnitFiles' back to the client.
     *
     * <b>Documentation of 'PresetAllUnitFiles'</b>:
     *
     * PresetAllUnitFiles() enables/disables one or more units file according to the preset policy.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onPresetAllUnitFiles().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendPresetAllUnitFilesError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'AddDependencyUnitFiles'

    /**
     * The method onAddDependencyUnitFiles() is called by ASF when a client
     * invokes the method 'AddDependencyUnitFiles'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendAddDependencyUnitFiles() or
     * sendAddDependencyUnitFilesError() method. Do not invoke this method on
     * your own.
     *
     * <b>Documentation of 'AddDependencyUnitFiles'</b>:
     *
     * AddDependencyUnitFiles()
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onAddDependencyUnitFilesRequest (const ::boost::shared_ptr< AddDependencyUnitFilesRequest >& request) = 0;

    /**
     * The method sendAddDependencyUnitFilesResponse() sends a response of a
     * previous method invocation of 'AddDependencyUnitFiles' back to the
     * client.
     *
     * <b>Documentation of 'AddDependencyUnitFiles'</b>:
     *
     * AddDependencyUnitFiles()
     *
     * @param changes If the meaning of "changes" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onAddDependencyUnitFiles(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendAddDependencyUnitFilesResponse (const ::std::vector< changes >& changes, act_t act = 0);

    /**
     * The method sendAddDependencyUnitFilesError() sends an error response of
     * a previous method invocation of 'AddDependencyUnitFiles' back to the
     * client.
     *
     * <b>Documentation of 'AddDependencyUnitFiles'</b>:
     *
     * AddDependencyUnitFiles()
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onAddDependencyUnitFiles(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendAddDependencyUnitFilesError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    VersionUpdate _VersionProperty;

    FeaturesUpdate _FeaturesProperty;

    VirtualizationUpdate _VirtualizationProperty;

    ArchitectureUpdate _ArchitectureProperty;

    TaintedUpdate _TaintedProperty;

    FirmwareTimestampUpdate _FirmwareTimestampProperty;

    FirmwareTimestampMonotonicUpdate _FirmwareTimestampMonotonicProperty;

    LoaderTimestampUpdate _LoaderTimestampProperty;

    LoaderTimestampMonotonicUpdate _LoaderTimestampMonotonicProperty;

    KernelTimestampUpdate _KernelTimestampProperty;

    KernelTimestampMonotonicUpdate _KernelTimestampMonotonicProperty;

    InitRDTimestampUpdate _InitRDTimestampProperty;

    InitRDTimestampMonotonicUpdate _InitRDTimestampMonotonicProperty;

    UserspaceTimestampUpdate _UserspaceTimestampProperty;

    UserspaceTimestampMonotonicUpdate _UserspaceTimestampMonotonicProperty;

    FinishTimestampUpdate _FinishTimestampProperty;

    FinishTimestampMonotonicUpdate _FinishTimestampMonotonicProperty;

    SecurityStartTimestampUpdate _SecurityStartTimestampProperty;

    SecurityStartTimestampMonotonicUpdate _SecurityStartTimestampMonotonicProperty;

    SecurityFinishTimestampUpdate _SecurityFinishTimestampProperty;

    SecurityFinishTimestampMonotonicUpdate _SecurityFinishTimestampMonotonicProperty;

    GeneratorsStartTimestampUpdate _GeneratorsStartTimestampProperty;

    GeneratorsStartTimestampMonotonicUpdate _GeneratorsStartTimestampMonotonicProperty;

    GeneratorsFinishTimestampUpdate _GeneratorsFinishTimestampProperty;

    GeneratorsFinishTimestampMonotonicUpdate _GeneratorsFinishTimestampMonotonicProperty;

    UnitsLoadStartTimestampUpdate _UnitsLoadStartTimestampProperty;

    UnitsLoadStartTimestampMonotonicUpdate _UnitsLoadStartTimestampMonotonicProperty;

    UnitsLoadFinishTimestampUpdate _UnitsLoadFinishTimestampProperty;

    UnitsLoadFinishTimestampMonotonicUpdate _UnitsLoadFinishTimestampMonotonicProperty;

    LogLevelUpdate _LogLevelProperty;

    LogTargetUpdate _LogTargetProperty;

    NNamesUpdate _NNamesProperty;

    NFailedUnitsUpdate _NFailedUnitsProperty;

    NJobsUpdate _NJobsProperty;

    NInstalledJobsUpdate _NInstalledJobsProperty;

    NFailedJobsUpdate _NFailedJobsProperty;

    ProgressUpdate _ProgressProperty;

    EnvironmentUpdate _EnvironmentProperty;

    ConfirmSpawnUpdate _ConfirmSpawnProperty;

    ShowStatusUpdate _ShowStatusProperty;

    UnitPathUpdate _UnitPathProperty;

    DefaultStandardOutputUpdate _DefaultStandardOutputProperty;

    DefaultStandardErrorUpdate _DefaultStandardErrorProperty;

    RuntimeWatchdogUSecUpdate _RuntimeWatchdogUSecProperty;

    ShutdownWatchdogUSecUpdate _ShutdownWatchdogUSecProperty;

    ControlGroupUpdate _ControlGroupProperty;

    SystemStateUpdate _SystemStateProperty;

    friend class ManagerStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org

#endif // ORG_FREEDESKTOP_SYSTEMD1_MANAGERSTUB_H
