/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/freedesktop/systemd1/Manager.h"
#include "org/freedesktop/systemd1/ManagerDBus.h"
#include "org/freedesktop/systemd1/ManagerJson.h"
#include "org/freedesktop/systemd1/ManagerStub.h"
#include <string>
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace freedesktop {
namespace systemd1 {
namespace Manager {

DEFINE_CLASS_LOGGER("/org/freedesktop/systemd1/org/freedesktop/systemd1/Manager", ManagerStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 4, "Dump", 24 },
    { 4, "Exit", 29 },
    { 4, "Halt", 32 },
    { 5, "KExec", 33 },
    { 6, "GetJob", 15 },
    { 6, "Reboot", 30 },
    { 6, "Reload", 27 },
    { 7, "GetUnit", 0 },
    { 8, "KillUnit", 11 },
    { 8, "ListJobs", 21 },
    { 8, "LoadUnit", 2 },
    { 8, "PowerOff", 31 },
    { 8, "StopUnit", 5 },
    { 9, "CancelJob", 16 },
    { 9, "ClearJobs", 17 },
    { 9, "ListUnits", 19 },
    { 9, "Reexecute", 28 },
    { 9, "StartUnit", 3 },
    { 9, "Subscribe", 22 },
    { 10, "ReloadUnit", 6 },
    { 10, "SwitchRoot", 34 },
    { 11, "ResetFailed", 18 },
    { 11, "RestartUnit", 7 },
    { 11, "Unsubscribe", 23 },
    { 12, "GetUnitByPID", 1 },
    { 13, "LinkUnitFiles", 43 },
    { 13, "ListUnitFiles", 38 },
    { 13, "MaskUnitFiles", 46 },
    { 14, "CreateSnapshot", 25 },
    { 14, "RemoveSnapshot", 26 },
    { 14, "SetEnvironment", 35 },
    { 14, "TryRestartUnit", 8 },
    { 15, "EnableUnitFiles", 40 },
    { 15, "PresetUnitFiles", 44 },
    { 15, "ResetFailedUnit", 12 },
    { 15, "UnmaskUnitFiles", 47 },
    { 16, "DisableUnitFiles", 41 },
    { 16, "GetDefaultTarget", 49 },
    { 16, "GetUnitFileState", 39 },
    { 16, "SetDefaultTarget", 48 },
    { 16, "StartUnitReplace", 4 },
    { 16, "UnsetEnvironment", 36 },
    { 17, "ListUnitsFiltered", 20 },
    { 17, "ReenableUnitFiles", 42 },
    { 17, "SetUnitProperties", 13 },
    { 18, "PresetAllUnitFiles", 50 },
    { 18, "StartTransientUnit", 14 },
    { 19, "ReloadOrRestartUnit", 9 },
    { 22, "AddDependencyUnitFiles", 51 },
    { 22, "ReloadOrTryRestartUnit", 10 },
    { 22, "UnsetAndSetEnvironment", 37 },
    { 23, "PresetUnitFilesWithMode", 45 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 5, "NJobs", 33 },
    { 6, "NNames", 31 },
    { 7, "Tainted", 4 },
    { 7, "Version", 0 },
    { 8, "Features", 1 },
    { 8, "LogLevel", 29 },
    { 8, "Progress", 36 },
    { 8, "UnitPath", 40 },
    { 9, "LogTarget", 30 },
    { 10, "ShowStatus", 39 },
    { 11, "Environment", 37 },
    { 11, "NFailedJobs", 35 },
    { 11, "SystemState", 46 },
    { 12, "Architecture", 3 },
    { 12, "ConfirmSpawn", 38 },
    { 12, "ControlGroup", 45 },
    { 12, "NFailedUnits", 32 },
    { 14, "NInstalledJobs", 34 },
    { 14, "Virtualization", 2 },
    { 15, "FinishTimestamp", 15 },
    { 15, "InitRDTimestamp", 11 },
    { 15, "KernelTimestamp", 9 },
    { 15, "LoaderTimestamp", 7 },
    { 17, "FirmwareTimestamp", 5 },
    { 18, "UserspaceTimestamp", 13 },
    { 19, "RuntimeWatchdogUSec", 43 },
    { 20, "DefaultStandardError", 42 },
    { 20, "ShutdownWatchdogUSec", 44 },
    { 21, "DefaultStandardOutput", 41 },
    { 22, "SecurityStartTimestamp", 17 },
    { 23, "SecurityFinishTimestamp", 19 },
    { 23, "UnitsLoadStartTimestamp", 25 },
    { 24, "FinishTimestampMonotonic", 16 },
    { 24, "GeneratorsStartTimestamp", 21 },
    { 24, "InitRDTimestampMonotonic", 12 },
    { 24, "KernelTimestampMonotonic", 10 },
    { 24, "LoaderTimestampMonotonic", 8 },
    { 24, "UnitsLoadFinishTimestamp", 27 },
    { 25, "GeneratorsFinishTimestamp", 23 },
    { 26, "FirmwareTimestampMonotonic", 6 },
    { 27, "UserspaceTimestampMonotonic", 14 },
    { 31, "SecurityStartTimestampMonotonic", 18 },
    { 32, "SecurityFinishTimestampMonotonic", 20 },
    { 32, "UnitsLoadStartTimestampMonotonic", 26 },
    { 33, "GeneratorsStartTimestampMonotonic", 22 },
    { 33, "UnitsLoadFinishTimestampMonotonic", 28 },
    { 34, "GeneratorsFinishTimestampMonotonic", 24 },
};

class ManagerStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    ManagerStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    ManagerStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    ManagerStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.freedesktop.systemd1.Manager"),
          _logger(logger) {}

    virtual ~ManagerStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void ManagerStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 52, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'GetUnit'

            LOG_DEBUG_STUB("process method '%s'", "GetUnit");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetUnitRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetUnit", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetUnitRequest > payload = ::boost::static_pointer_cast<GetUnitRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onGetUnitRequest(payload);
            return;
        }
        case 1: {

            // method 'GetUnitByPID'

            LOG_DEBUG_STUB("process method '%s'", "GetUnitByPID");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetUnitByPIDRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetUnitByPID", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetUnitByPIDRequest > payload = ::boost::static_pointer_cast<GetUnitByPIDRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onGetUnitByPIDRequest(payload);
            return;
        }
        case 2: {

            // method 'LoadUnit'

            LOG_DEBUG_STUB("process method '%s'", "LoadUnit");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LoadUnitRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "LoadUnit", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< LoadUnitRequest > payload = ::boost::static_pointer_cast<LoadUnitRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onLoadUnitRequest(payload);
            return;
        }
        case 3: {

            // method 'StartUnit'

            LOG_DEBUG_STUB("process method '%s'", "StartUnit");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartUnitRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "StartUnit", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< StartUnitRequest > payload = ::boost::static_pointer_cast<StartUnitRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onStartUnitRequest(payload);
            return;
        }
        case 4: {

            // method 'StartUnitReplace'

            LOG_DEBUG_STUB("process method '%s'", "StartUnitReplace");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartUnitReplaceRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "StartUnitReplace", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< StartUnitReplaceRequest > payload = ::boost::static_pointer_cast<StartUnitReplaceRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onStartUnitReplaceRequest(payload);
            return;
        }
        case 5: {

            // method 'StopUnit'

            LOG_DEBUG_STUB("process method '%s'", "StopUnit");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StopUnitRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "StopUnit", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< StopUnitRequest > payload = ::boost::static_pointer_cast<StopUnitRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onStopUnitRequest(payload);
            return;
        }
        case 6: {

            // method 'ReloadUnit'

            LOG_DEBUG_STUB("process method '%s'", "ReloadUnit");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReloadUnitRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ReloadUnit", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ReloadUnitRequest > payload = ::boost::static_pointer_cast<ReloadUnitRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onReloadUnitRequest(payload);
            return;
        }
        case 7: {

            // method 'RestartUnit'

            LOG_DEBUG_STUB("process method '%s'", "RestartUnit");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RestartUnitRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RestartUnit", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RestartUnitRequest > payload = ::boost::static_pointer_cast<RestartUnitRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onRestartUnitRequest(payload);
            return;
        }
        case 8: {

            // method 'TryRestartUnit'

            LOG_DEBUG_STUB("process method '%s'", "TryRestartUnit");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TryRestartUnitRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "TryRestartUnit", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< TryRestartUnitRequest > payload = ::boost::static_pointer_cast<TryRestartUnitRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onTryRestartUnitRequest(payload);
            return;
        }
        case 9: {

            // method 'ReloadOrRestartUnit'

            LOG_DEBUG_STUB("process method '%s'", "ReloadOrRestartUnit");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReloadOrRestartUnitRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ReloadOrRestartUnit", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ReloadOrRestartUnitRequest > payload = ::boost::static_pointer_cast<ReloadOrRestartUnitRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onReloadOrRestartUnitRequest(payload);
            return;
        }
        case 10: {

            // method 'ReloadOrTryRestartUnit'

            LOG_DEBUG_STUB("process method '%s'", "ReloadOrTryRestartUnit");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReloadOrTryRestartUnitRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ReloadOrTryRestartUnit", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ReloadOrTryRestartUnitRequest > payload = ::boost::static_pointer_cast<ReloadOrTryRestartUnitRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onReloadOrTryRestartUnitRequest(payload);
            return;
        }
        case 11: {

            // method 'KillUnit'

            LOG_DEBUG_STUB("process method '%s'", "KillUnit");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), KillUnitRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "KillUnit", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< KillUnitRequest > payload = ::boost::static_pointer_cast<KillUnitRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onKillUnitRequest(payload);
            return;
        }
        case 12: {

            // method 'ResetFailedUnit'

            LOG_DEBUG_STUB("process method '%s'", "ResetFailedUnit");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ResetFailedUnitRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ResetFailedUnit", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ResetFailedUnitRequest > payload = ::boost::static_pointer_cast<ResetFailedUnitRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onResetFailedUnitRequest(payload);
            return;
        }
        case 13: {

            // method 'SetUnitProperties'

            LOG_DEBUG_STUB("process method '%s'", "SetUnitProperties");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetUnitPropertiesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetUnitProperties", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetUnitPropertiesRequest > payload = ::boost::static_pointer_cast<SetUnitPropertiesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onSetUnitPropertiesRequest(payload);
            return;
        }
        case 14: {

            // method 'StartTransientUnit'

            LOG_DEBUG_STUB("process method '%s'", "StartTransientUnit");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartTransientUnitRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "StartTransientUnit", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< StartTransientUnitRequest > payload = ::boost::static_pointer_cast<StartTransientUnitRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onStartTransientUnitRequest(payload);
            return;
        }
        case 15: {

            // method 'GetJob'

            LOG_DEBUG_STUB("process method '%s'", "GetJob");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetJobRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetJob", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetJobRequest > payload = ::boost::static_pointer_cast<GetJobRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onGetJobRequest(payload);
            return;
        }
        case 16: {

            // method 'CancelJob'

            LOG_DEBUG_STUB("process method '%s'", "CancelJob");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CancelJobRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "CancelJob", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< CancelJobRequest > payload = ::boost::static_pointer_cast<CancelJobRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onCancelJobRequest(payload);
            return;
        }
        case 17: {

            // method 'ClearJobs'

            LOG_DEBUG_STUB("process method '%s'", "ClearJobs");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ClearJobsRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ClearJobs", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ClearJobsRequest > payload = ::boost::static_pointer_cast<ClearJobsRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onClearJobsRequest(payload);
            return;
        }
        case 18: {

            // method 'ResetFailed'

            LOG_DEBUG_STUB("process method '%s'", "ResetFailed");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ResetFailedRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ResetFailed", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ResetFailedRequest > payload = ::boost::static_pointer_cast<ResetFailedRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onResetFailedRequest(payload);
            return;
        }
        case 19: {

            // method 'ListUnits'

            LOG_DEBUG_STUB("process method '%s'", "ListUnits");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ListUnitsRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ListUnits", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ListUnitsRequest > payload = ::boost::static_pointer_cast<ListUnitsRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onListUnitsRequest(payload);
            return;
        }
        case 20: {

            // method 'ListUnitsFiltered'

            LOG_DEBUG_STUB("process method '%s'", "ListUnitsFiltered");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ListUnitsFilteredRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ListUnitsFiltered", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ListUnitsFilteredRequest > payload = ::boost::static_pointer_cast<ListUnitsFilteredRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onListUnitsFilteredRequest(payload);
            return;
        }
        case 21: {

            // method 'ListJobs'

            LOG_DEBUG_STUB("process method '%s'", "ListJobs");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ListJobsRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ListJobs", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ListJobsRequest > payload = ::boost::static_pointer_cast<ListJobsRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onListJobsRequest(payload);
            return;
        }
        case 22: {

            // method 'Subscribe'

            LOG_DEBUG_STUB("process method '%s'", "Subscribe");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SubscribeRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Subscribe", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SubscribeRequest > payload = ::boost::static_pointer_cast<SubscribeRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onSubscribeRequest(payload);
            return;
        }
        case 23: {

            // method 'Unsubscribe'

            LOG_DEBUG_STUB("process method '%s'", "Unsubscribe");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UnsubscribeRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Unsubscribe", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< UnsubscribeRequest > payload = ::boost::static_pointer_cast<UnsubscribeRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onUnsubscribeRequest(payload);
            return;
        }
        case 24: {

            // method 'Dump'

            LOG_DEBUG_STUB("process method '%s'", "Dump");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DumpRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Dump", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< DumpRequest > payload = ::boost::static_pointer_cast<DumpRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onDumpRequest(payload);
            return;
        }
        case 25: {

            // method 'CreateSnapshot'

            LOG_DEBUG_STUB("process method '%s'", "CreateSnapshot");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CreateSnapshotRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "CreateSnapshot", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< CreateSnapshotRequest > payload = ::boost::static_pointer_cast<CreateSnapshotRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onCreateSnapshotRequest(payload);
            return;
        }
        case 26: {

            // method 'RemoveSnapshot'

            LOG_DEBUG_STUB("process method '%s'", "RemoveSnapshot");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RemoveSnapshotRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RemoveSnapshot", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RemoveSnapshotRequest > payload = ::boost::static_pointer_cast<RemoveSnapshotRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onRemoveSnapshotRequest(payload);
            return;
        }
        case 27: {

            // method 'Reload'

            LOG_DEBUG_STUB("process method '%s'", "Reload");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReloadRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Reload", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ReloadRequest > payload = ::boost::static_pointer_cast<ReloadRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onReloadRequest(payload);
            return;
        }
        case 28: {

            // method 'Reexecute'

            LOG_DEBUG_STUB("process method '%s'", "Reexecute");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReexecuteRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Reexecute", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ReexecuteRequest > payload = ::boost::static_pointer_cast<ReexecuteRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onReexecuteRequest(payload);
            return;
        }
        case 29: {

            // method 'Exit'

            LOG_DEBUG_STUB("process method '%s'", "Exit");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ExitRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Exit", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ExitRequest > payload = ::boost::static_pointer_cast<ExitRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onExitRequest(payload);
            return;
        }
        case 30: {

            // method 'Reboot'

            LOG_DEBUG_STUB("process method '%s'", "Reboot");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RebootRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Reboot", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RebootRequest > payload = ::boost::static_pointer_cast<RebootRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onRebootRequest(payload);
            return;
        }
        case 31: {

            // method 'PowerOff'

            LOG_DEBUG_STUB("process method '%s'", "PowerOff");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PowerOffRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "PowerOff", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< PowerOffRequest > payload = ::boost::static_pointer_cast<PowerOffRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onPowerOffRequest(payload);
            return;
        }
        case 32: {

            // method 'Halt'

            LOG_DEBUG_STUB("process method '%s'", "Halt");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), HaltRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Halt", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< HaltRequest > payload = ::boost::static_pointer_cast<HaltRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onHaltRequest(payload);
            return;
        }
        case 33: {

            // method 'KExec'

            LOG_DEBUG_STUB("process method '%s'", "KExec");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), KExecRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "KExec", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< KExecRequest > payload = ::boost::static_pointer_cast<KExecRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onKExecRequest(payload);
            return;
        }
        case 34: {

            // method 'SwitchRoot'

            LOG_DEBUG_STUB("process method '%s'", "SwitchRoot");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SwitchRootRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SwitchRoot", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SwitchRootRequest > payload = ::boost::static_pointer_cast<SwitchRootRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onSwitchRootRequest(payload);
            return;
        }
        case 35: {

            // method 'SetEnvironment'

            LOG_DEBUG_STUB("process method '%s'", "SetEnvironment");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetEnvironmentRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetEnvironment", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetEnvironmentRequest > payload = ::boost::static_pointer_cast<SetEnvironmentRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onSetEnvironmentRequest(payload);
            return;
        }
        case 36: {

            // method 'UnsetEnvironment'

            LOG_DEBUG_STUB("process method '%s'", "UnsetEnvironment");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UnsetEnvironmentRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "UnsetEnvironment", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< UnsetEnvironmentRequest > payload = ::boost::static_pointer_cast<UnsetEnvironmentRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onUnsetEnvironmentRequest(payload);
            return;
        }
        case 37: {

            // method 'UnsetAndSetEnvironment'

            LOG_DEBUG_STUB("process method '%s'", "UnsetAndSetEnvironment");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UnsetAndSetEnvironmentRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "UnsetAndSetEnvironment", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< UnsetAndSetEnvironmentRequest > payload = ::boost::static_pointer_cast<UnsetAndSetEnvironmentRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onUnsetAndSetEnvironmentRequest(payload);
            return;
        }
        case 38: {

            // method 'ListUnitFiles'

            LOG_DEBUG_STUB("process method '%s'", "ListUnitFiles");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ListUnitFilesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ListUnitFiles", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ListUnitFilesRequest > payload = ::boost::static_pointer_cast<ListUnitFilesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onListUnitFilesRequest(payload);
            return;
        }
        case 39: {

            // method 'GetUnitFileState'

            LOG_DEBUG_STUB("process method '%s'", "GetUnitFileState");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetUnitFileStateRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetUnitFileState", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetUnitFileStateRequest > payload = ::boost::static_pointer_cast<GetUnitFileStateRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onGetUnitFileStateRequest(payload);
            return;
        }
        case 40: {

            // method 'EnableUnitFiles'

            LOG_DEBUG_STUB("process method '%s'", "EnableUnitFiles");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EnableUnitFilesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "EnableUnitFiles", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< EnableUnitFilesRequest > payload = ::boost::static_pointer_cast<EnableUnitFilesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onEnableUnitFilesRequest(payload);
            return;
        }
        case 41: {

            // method 'DisableUnitFiles'

            LOG_DEBUG_STUB("process method '%s'", "DisableUnitFiles");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DisableUnitFilesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "DisableUnitFiles", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< DisableUnitFilesRequest > payload = ::boost::static_pointer_cast<DisableUnitFilesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onDisableUnitFilesRequest(payload);
            return;
        }
        case 42: {

            // method 'ReenableUnitFiles'

            LOG_DEBUG_STUB("process method '%s'", "ReenableUnitFiles");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReenableUnitFilesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ReenableUnitFiles", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ReenableUnitFilesRequest > payload = ::boost::static_pointer_cast<ReenableUnitFilesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onReenableUnitFilesRequest(payload);
            return;
        }
        case 43: {

            // method 'LinkUnitFiles'

            LOG_DEBUG_STUB("process method '%s'", "LinkUnitFiles");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LinkUnitFilesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "LinkUnitFiles", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< LinkUnitFilesRequest > payload = ::boost::static_pointer_cast<LinkUnitFilesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onLinkUnitFilesRequest(payload);
            return;
        }
        case 44: {

            // method 'PresetUnitFiles'

            LOG_DEBUG_STUB("process method '%s'", "PresetUnitFiles");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PresetUnitFilesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "PresetUnitFiles", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< PresetUnitFilesRequest > payload = ::boost::static_pointer_cast<PresetUnitFilesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onPresetUnitFilesRequest(payload);
            return;
        }
        case 45: {

            // method 'PresetUnitFilesWithMode'

            LOG_DEBUG_STUB("process method '%s'", "PresetUnitFilesWithMode");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PresetUnitFilesWithModeRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "PresetUnitFilesWithMode", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< PresetUnitFilesWithModeRequest > payload = ::boost::static_pointer_cast<PresetUnitFilesWithModeRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onPresetUnitFilesWithModeRequest(payload);
            return;
        }
        case 46: {

            // method 'MaskUnitFiles'

            LOG_DEBUG_STUB("process method '%s'", "MaskUnitFiles");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MaskUnitFilesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "MaskUnitFiles", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< MaskUnitFilesRequest > payload = ::boost::static_pointer_cast<MaskUnitFilesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onMaskUnitFilesRequest(payload);
            return;
        }
        case 47: {

            // method 'UnmaskUnitFiles'

            LOG_DEBUG_STUB("process method '%s'", "UnmaskUnitFiles");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UnmaskUnitFilesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "UnmaskUnitFiles", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< UnmaskUnitFilesRequest > payload = ::boost::static_pointer_cast<UnmaskUnitFilesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onUnmaskUnitFilesRequest(payload);
            return;
        }
        case 48: {

            // method 'SetDefaultTarget'

            LOG_DEBUG_STUB("process method '%s'", "SetDefaultTarget");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetDefaultTargetRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetDefaultTarget", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetDefaultTargetRequest > payload = ::boost::static_pointer_cast<SetDefaultTargetRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onSetDefaultTargetRequest(payload);
            return;
        }
        case 49: {

            // method 'GetDefaultTarget'

            LOG_DEBUG_STUB("process method '%s'", "GetDefaultTarget");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetDefaultTargetRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetDefaultTarget", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetDefaultTargetRequest > payload = ::boost::static_pointer_cast<GetDefaultTargetRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onGetDefaultTargetRequest(payload);
            return;
        }
        case 50: {

            // method 'PresetAllUnitFiles'

            LOG_DEBUG_STUB("process method '%s'", "PresetAllUnitFiles");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PresetAllUnitFilesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "PresetAllUnitFiles", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< PresetAllUnitFilesRequest > payload = ::boost::static_pointer_cast<PresetAllUnitFilesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onPresetAllUnitFilesRequest(payload);
            return;
        }
        case 51: {

            // method 'AddDependencyUnitFiles'

            LOG_DEBUG_STUB("process method '%s'", "AddDependencyUnitFiles");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AddDependencyUnitFilesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "AddDependencyUnitFiles", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< AddDependencyUnitFilesRequest > payload = ::boost::static_pointer_cast<AddDependencyUnitFilesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onAddDependencyUnitFilesRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* ManagerStubDelegate::introspect() const {
    return     "<interface name=\"org.freedesktop.systemd1.Manager\">\n"
            "    <property access=\"read\" name=\"Version\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"Features\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"Virtualization\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"Architecture\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"Tainted\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"FirmwareTimestamp\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"FirmwareTimestampMonotonic\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"LoaderTimestamp\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"LoaderTimestampMonotonic\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"KernelTimestamp\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"KernelTimestampMonotonic\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"InitRDTimestamp\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"InitRDTimestampMonotonic\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"UserspaceTimestamp\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"UserspaceTimestampMonotonic\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"FinishTimestamp\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"FinishTimestampMonotonic\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"SecurityStartTimestamp\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"SecurityStartTimestampMonotonic\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"SecurityFinishTimestamp\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"SecurityFinishTimestampMonotonic\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"GeneratorsStartTimestamp\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"GeneratorsStartTimestampMonotonic\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"GeneratorsFinishTimestamp\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"GeneratorsFinishTimestampMonotonic\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"UnitsLoadStartTimestamp\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"UnitsLoadStartTimestampMonotonic\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"UnitsLoadFinishTimestamp\" type=\"t\"/>\n"
            "    <property access=\"read\" name=\"UnitsLoadFinishTimestampMonotonic\" type=\"t\"/>\n"
            "    <property access=\"readwrite\" name=\"LogLevel\" type=\"s\"/>\n"
            "    <property access=\"readwrite\" name=\"LogTarget\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"NNames\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"NFailedUnits\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"NJobs\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"NInstalledJobs\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"NFailedJobs\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"Progress\" type=\"d\"/>\n"
            "    <property access=\"read\" name=\"Environment\" type=\"as\"/>\n"
            "    <property access=\"read\" name=\"ConfirmSpawn\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"ShowStatus\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"UnitPath\" type=\"as\"/>\n"
            "    <property access=\"read\" name=\"DefaultStandardOutput\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"DefaultStandardError\" type=\"s\"/>\n"
            "    <property access=\"readwrite\" name=\"RuntimeWatchdogUSec\" type=\"t\"/>\n"
            "    <property access=\"readwrite\" name=\"ShutdownWatchdogUSec\" type=\"t\"/>\n"
            "    <property access=\"readwrite\" name=\"ControlGroup\" type=\"s\"/>\n"
            "    <property access=\"readwrite\" name=\"SystemState\" type=\"s\"/>\n"
            "    <method name=\"GetUnit\">\n"
            "      <doc>\n"
            "        <line>GetUnit = GetUnit() may be used to get the unit object path</line>\n"
            "        <line>for a unit name. It takes the unit name and returns the object path.</line>\n"
            "        <line>If a unit has not been loaded yet by this name this call will fail.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"name\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>name = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"unit\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>unit (of type ObjectPath) = Description missing</line>\n"
            "          <line>lineComment to be defined</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"GetUnitByPID\">\n"
            "      <doc>\n"
            "        <line>GetUnitByPID = GetUnitByPID() may be used to get the unit object path of the unit a process ID belongs to.</line>\n"
            "        <line>Takes a Unix PID and returns the object path. The PID must refer to an existing process of the system.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"pid\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>pid = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"unit\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>unit (of type ObjectPath) = Description missing</line>\n"
            "          <line>lineComment to be defined</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"LoadUnit\">\n"
            "      <doc>\n"
            "        <line>LoadUnit = LoadUnit() is similar to GetUnit() but will load the unit from disk if possible</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"name\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>name = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"unit\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>unit (of type ObjectPath) = Description missing</line>\n"
            "          <line>lineComment to be defined</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"StartUnit\">\n"
            "      <doc>\n"
            "        <line>StartUnit = StartUnit() enqeues a start job, and possibly depending jobs. Takes the unit to activate, plus a mode string.</line>\n"
            "        <line>The mode needs to be one of replace, fail, isolate, ignore-dependencies, ignore-requirements.</line>\n"
            "        <line>If &quot;replace&quot; the call will start the unit and its dependencies, possibly replacing already queued jobs that conflict with this.</line>\n"
            "        <line>If &quot;fail&quot; the call will start the unit and its dependencies, but will fail if this would change an already queued job.</line>\n"
            "        <line>If &quot;isolate&quot; the call will start the unit in question and terminate all units that aren't dependencies of it.</line>\n"
            "        <line>If &quot;ignore-dependencies&quot; it will start a unit but ignore all its dependencies.</line>\n"
            "        <line>If &quot;ignore-requirements&quot; it will start a unit but only ignore the requirement dependencies.</line>\n"
            "        <line>It is not recommended to make use of the latter two options. Returns the newly created job object.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"name\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>name = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"mode\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>mode = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"job\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>job (of type ObjectPath) = Description missing</line>\n"
            "          <line>lineComment to be defined</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"StartUnitReplace\">\n"
            "      <doc>\n"
            "        <line>StartUnitReplace = StartUnitReplace() is similar to StartUnit() but replaces a job that is queued for one unit by a job for another.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"old_unit\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>old_unit = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"new_unit\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>new_unit = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"mode\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>mode = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"job\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>job (of type ObjectPath) = Description missing</line>\n"
            "          <line>lineComment to be defined</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"StopUnit\">\n"
            "      <doc>\n"
            "        <line>StopUnit = StopUnit() is similar to StartUnit() but stops the specified unit rather than starting it. Note that &quot;isolate&quot; mode is invalid for this call</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"name\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>name = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"mode\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>mode = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"job\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>job (of type ObjectPath) = Description missing</line>\n"
            "          <line>lineComment to be defined</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ReloadUnit\">\n"
            "      <doc>\n"
            "        <line>ReloadUnit = ReloadUnit(), RestartUnit(), TryRestartUnit(), ReloadOrRestartUnit(), ReloadOrTryRestartUnit() may be used to restart and/or reload a unit,</line>\n"
            "        <line>and takes similar arguments as StartUnit(). Reloading is done only if the unit is already running and fails otherwise.</line>\n"
            "        <line>If a service is restarted that isn't running it will be started, unless the &quot;Try&quot; flavor is used in which case a service that isn't running is not affected by the restart.</line>\n"
            "        <line>The &quot;ReloadOrRestart&quot; flavors attempt a reload if the unit supports it and use a restart otherwise.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"name\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>name = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"mode\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>mode = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"job\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>job (of type ObjectPath) = Description missing</line>\n"
            "          <line>lineComment to be defined</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"RestartUnit\">\n"
            "      <doc>\n"
            "        <line>RestartUnit = RestartUnit()</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"name\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>name = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"mode\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>mode = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"job\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>job (of type ObjectPath) = Description missing</line>\n"
            "          <line>lineComment to be defined</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"TryRestartUnit\">\n"
            "      <doc>\n"
            "        <line>TryRestartUnit = TryRestartUnit()</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"name\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>name = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"mode\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>mode = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"job\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>job (of type ObjectPath) = Description missing</line>\n"
            "          <line>lineComment to be defined</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ReloadOrRestartUnit\">\n"
            "      <doc>\n"
            "        <line>ReloadOrRestartUnit = ReloadOrRestartUnit()</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"name\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>name = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"mode\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>mode = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"job\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>job (of type ObjectPath) = Description missing</line>\n"
            "          <line>lineComment to be defined</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ReloadOrTryRestartUnit\">\n"
            "      <doc>\n"
            "        <line>ReloadOrTryRestartUnit = ReloadOrTryRestartUnit()</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"name\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>name = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"mode\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>mode = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"job\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>job (of type ObjectPath) = Description missing</line>\n"
            "          <line>lineComment to be defined</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"KillUnit\">\n"
            "      <doc>\n"
            "        <line>KillUnit = KillUnit() may be used to kill (i.e. send a signal to) all processes of a unit.</line>\n"
            "        <line>Takes the unit name, an enum who and a UNIX signal number to send. The who enum is one of &quot;main&quot;, &quot;control&quot; or &quot;all&quot;.</line>\n"
            "        <line>If &quot;main&quot;, only the main process of a unit is killed. If &quot;control&quot; only the control process of the unit is killed, if &quot;all&quot; all processes are killed.</line>\n"
            "        <line>A &quot;control&quot; process is for example a process that is configured via ExecStop= and is spawned in parallel to the main daemon process, in order to shut it down</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"name\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>name = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"who\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>who = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"signal\" type=\"i\">\n"
            "        <doc>\n"
            "          <line>signal = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ResetFailedUnit\">\n"
            "      <doc>\n"
            "        <line>ResetFailedUnit = ResetFailedUnit</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"name\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>name = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"SetUnitProperties\">\n"
            "      <doc>\n"
            "        <line>SetUnitProperties = SetUnitProperties</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"name\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>name = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"runtime\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>runtime = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"properties\" type=\"a(ss)\">\n"
            "        <doc>\n"
            "          <line>properties (of type property) = Description missing</line>\n"
            "          <line>property struct[name, value] = Property info struct</line>\n"
            "          <line>0: property.name ('s') = change type, one of 'symlink' or 'unlink'</line>\n"
            "          <line>1: property.value ('s') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"StartTransientUnit\">\n"
            "      <doc>\n"
            "        <line>StartTransientUnit = StartTransientUnit</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"name\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>name = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"mode\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>mode = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"properties\" type=\"a(ss)\">\n"
            "        <doc>\n"
            "          <line>properties (of type property) = Description missing</line>\n"
            "          <line>property struct[name, value] = Property info struct</line>\n"
            "          <line>0: property.name ('s') = change type, one of 'symlink' or 'unlink'</line>\n"
            "          <line>1: property.value ('s') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"transientunitdata\" type=\"a(sa(ss))\">\n"
            "        <doc>\n"
            "          <line>transientunitdata (of type transientunitdata) = Description missing</line>\n"
            "          <line>transientunitdata struct[name, transientproperties] = transientunitdata info struct</line>\n"
            "          <line>0: transientunitdata.name ('s') = change type, one of 'symlink' or 'unlink'</line>\n"
            "          <line>1: transientunitdata.transientproperties ('?') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"job\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>job (of type ObjectPath) = Description missing</line>\n"
            "          <line>lineComment to be defined</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"GetJob\">\n"
            "      <doc>\n"
            "        <line>GetJob = GetJob() returns the job object path for a specific job, identified by its id.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"id\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>id = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"job\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>job (of type ObjectPath) = Description missing</line>\n"
            "          <line>lineComment to be defined</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"CancelJob\">\n"
            "      <doc>\n"
            "        <line>CancelJob = CancelJob() cancels a specific job identified by its numer ID. This operation is also available</line>\n"
            "        <line>in the Cancel() method of Job objects (see below), and exists primarily to reduce the necessary round trips to</line>\n"
            "        <line>execute this operation. Note that this will not have any effect on jobs whose execution has already begun.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"id\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>id = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ClearJobs\">\n"
            "      <doc>\n"
            "        <line>ClearJobs = ClearJobs() flushes the job queue, removing all jobs that are still queued.</line>\n"
            "        <line>Note that this does not have any effect on jobs whose execution has already begun,</line>\n"
            "        <line>it only flushes jobs that are queued and have not yet begun execution.</line>\n"
            "      </doc>\n"
            "    </method>\n"
            "    <method name=\"ResetFailed\">\n"
            "      <doc>\n"
            "        <line>ResetFailed = ResetFailed() resets the &quot;failed&quot; state of all units.</line>\n"
            "      </doc>\n"
            "    </method>\n"
            "    <method name=\"ListUnits\">\n"
            "      <doc>\n"
            "        <line>ListUnits = ListUnits() returns an array with all currently loaded units. Note that units may be known by multiple names at the same name,</line>\n"
            "        <line>and hence there might be more unit names loaded than actual units behind them. The array consists of structures with the following elements:</line>\n"
            "        <line></line>\n"
            "        <line>The primary unit name as string</line>\n"
            "        <line>The human readable description string</line>\n"
            "        <line>The load state (i.e. whether the unit file has been loaded successfully)</line>\n"
            "        <line>The active state (i.e. whether the unit is currently started or not)</line>\n"
            "        <line>The sub state (a more fine-grained version of the active state that is specific to the unit type, which the active state is not)</line>\n"
            "        <line>A unit that is being followed in its state by this unit, if there is any, otherwise the empty string.</line>\n"
            "        <line>The unit object path</line>\n"
            "        <line>If there is a job queued for the job unit the numeric job id, 0 otherwise</line>\n"
            "        <line>The job type as string</line>\n"
            "        <line>The job object path</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"units\" type=\"a(sssssssuss)\">\n"
            "        <doc>\n"
            "          <line>units (of type units) = Description missing</line>\n"
            "          <line>units struct[name, description, loadState, activeState, subState, follower, path, jobId, jobType, jobPath] = Unit info structure</line>\n"
            "          <line>0: units.name ('s') = Description missing</line>\n"
            "          <line>1: units.description ('s') = Description missing</line>\n"
            "          <line>2: units.loadState ('s') = Description missing</line>\n"
            "          <line>3: units.activeState ('s') = Description missing</line>\n"
            "          <line>4: units.subState ('s') = Description missing</line>\n"
            "          <line>5: units.follower ('s') = Description missing</line>\n"
            "          <line>6: units.path ('?') = Description missing</line>\n"
            "          <line>7: units.jobId ('u') = Description missing</line>\n"
            "          <line>8: units.jobType ('s') = Description missing</line>\n"
            "          <line>9: units.jobPath ('?') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ListUnitsFiltered\">\n"
            "      <doc>\n"
            "        <line>ListUnitsFiltered = ListUnitsFiltered</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"unitList\" type=\"as\">\n"
            "        <doc>\n"
            "          <line>unitList = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"units\" type=\"a(sssssssuss)\">\n"
            "        <doc>\n"
            "          <line>units (of type units) = Description missing</line>\n"
            "          <line>units struct[name, description, loadState, activeState, subState, follower, path, jobId, jobType, jobPath] = Unit info structure</line>\n"
            "          <line>0: units.name ('s') = Description missing</line>\n"
            "          <line>1: units.description ('s') = Description missing</line>\n"
            "          <line>2: units.loadState ('s') = Description missing</line>\n"
            "          <line>3: units.activeState ('s') = Description missing</line>\n"
            "          <line>4: units.subState ('s') = Description missing</line>\n"
            "          <line>5: units.follower ('s') = Description missing</line>\n"
            "          <line>6: units.path ('?') = Description missing</line>\n"
            "          <line>7: units.jobId ('u') = Description missing</line>\n"
            "          <line>8: units.jobType ('s') = Description missing</line>\n"
            "          <line>9: units.jobPath ('?') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ListJobs\">\n"
            "      <doc>\n"
            "        <line>ListJobs = ListJobs() returns an array with all currently queued jobs. Returns an array consisting of structures with the following elements:</line>\n"
            "        <line></line>\n"
            "        <line>The numeric job id</line>\n"
            "        <line>The primary unit name for this job</line>\n"
            "        <line>The job type as string</line>\n"
            "        <line>The job state as string</line>\n"
            "        <line>The job object path</line>\n"
            "        <line>The unit object path</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"jobs\" type=\"a(usssss)\">\n"
            "        <doc>\n"
            "          <line>jobs (of type jobs) = Description missing</line>\n"
            "          <line>jobs struct[jobId, primaryUnit, type, state, path, unitPath] = Job info structure</line>\n"
            "          <line>0: jobs.jobId ('u') = Description missing</line>\n"
            "          <line>1: jobs.primaryUnit ('s') = Description missing</line>\n"
            "          <line>2: jobs.type ('s') = Description missing</line>\n"
            "          <line>3: jobs.state ('s') = Description missing</line>\n"
            "          <line>4: jobs.path ('?') = Description missing</line>\n"
            "          <line>5: jobs.unitPath ('?') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"Subscribe\">\n"
            "      <doc>\n"
            "        <line>Subscribe = Subscribe() enables most bus signals to be sent out.</line>\n"
            "        <line>Clients which are interested in signals need to call this function. Signals are only sent out if at least one client invoked this function.</line>\n"
            "        <line>Unsubscribe() undoes the signal subscription that Subscribe() implements. It is not necessary to invoke Unsubscribe() as clients are tracked.</line>\n"
            "        <line>Signals are no longer sent out as soon as all clients which previously asked for Subscribe() either closed the bus connection or invoked Unsubscribe().</line>\n"
            "      </doc>\n"
            "    </method>\n"
            "    <method name=\"Unsubscribe\">\n"
            "      <doc>\n"
            "        <line>Unsubscribe = Unsubscribe</line>\n"
            "      </doc>\n"
            "    </method>\n"
            "    <method name=\"Dump\">\n"
            "      <doc>\n"
            "        <line>Dump = Dump</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"dump\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>dump = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"CreateSnapshot\">\n"
            "      <doc>\n"
            "        <line>CreateSnapshot = CreateSnapshot() creates a snapshot unit for the current system state, and stores it under the specified name.</line>\n"
            "        <line>It will return the unit object path to the new snapshot. If the cleanup boolean is true the snapshot will be removed automatically</line>\n"
            "        <line>when it has been activated, otherwise it remains and can be activated multiple times. Snapshots are not persistent</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"name\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>name = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"cleanup\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>cleanup = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"unit\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>unit (of type ObjectPath) = Description missing</line>\n"
            "          <line>lineComment to be defined</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"RemoveSnapshot\">\n"
            "      <doc>\n"
            "        <line>RemoveSnapshot = RemoveSnapshot() removes a snapshot. This call is also available in the Remove() method of</line>\n"
            "        <line>Snapshot objects (see below), and exists primarily to reduce the number of required roundtrips for this call.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"name\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>name = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"Reload\">\n"
            "      <doc>\n"
            "        <line>Reload = Reload() may be invoked to reload all unit files.</line>\n"
            "      </doc>\n"
            "    </method>\n"
            "    <method name=\"Reexecute\">\n"
            "      <doc>\n"
            "        <line>Reexecute = Reexecute() may be invoked to reexecute the main manager process.</line>\n"
            "        <line>It will serialize its state, reexecute, and deserizalize the state again. This is useful for upgrades and is a more comprehensive version of Reload().</line>\n"
            "      </doc>\n"
            "    </method>\n"
            "    <method name=\"Exit\">\n"
            "      <doc>\n"
            "        <line>Exit = Exit() may be invoked to ask the manager to exit. This is not available for the system manager and is useful only for user session managers.</line>\n"
            "      </doc>\n"
            "    </method>\n"
            "    <method name=\"Reboot\">\n"
            "      <doc>\n"
            "        <line>Reboot = Reboot(), PowerOff(), Halt(), KExec() may be used to ask for immediate reboot, powering down, halt or kexec based reboot of the system.</line>\n"
            "        <line>Note that this does not shut down any services and immediately transitions into the reboot process.</line>\n"
            "        <line>These functions are normally only called as last step of shutdown, and should not be called directly.</line>\n"
            "        <line>To shut down the machine it is a much better choice generally to invoke Reboot() and PoweOff() on the logind manager object. See On logind for more information.</line>\n"
            "      </doc>\n"
            "    </method>\n"
            "    <method name=\"PowerOff\">\n"
            "      <doc>\n"
            "        <line>PowerOff = PowerOff()</line>\n"
            "      </doc>\n"
            "    </method>\n"
            "    <method name=\"Halt\">\n"
            "      <doc>\n"
            "        <line>Halt = Halt()</line>\n"
            "      </doc>\n"
            "    </method>\n"
            "    <method name=\"KExec\">\n"
            "      <doc>\n"
            "        <line>KExec = KExec()</line>\n"
            "      </doc>\n"
            "    </method>\n"
            "    <method name=\"SwitchRoot\">\n"
            "      <doc>\n"
            "        <line>SwitchRoot = SwitchRoot() may be used to transition to a new root directory. This is intended to be used by initial RAM disks.</line>\n"
            "        <line>The call takes two arguments: the new root directory (which needs to be specified), plus an init binary path (which may be left empty,</line>\n"
            "        <line>in which case it is automatically searched for).</line>\n"
            "        <line>The state of the system manager will be serialized before the transition.</line>\n"
            "        <line>After the transition the manager binary on the main system is invoked and replaces the old PID 1. All state will then be deserialized.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"new_root\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>new_root = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"init\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>init = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"SetEnvironment\">\n"
            "      <doc>\n"
            "        <line>SetEnvironment = SetEnvironment() may be used to alter the environment block that is passed to all spawned processes.</line>\n"
            "        <line>Takes a string array with environment variable assignments. Settings passed will override previously set variables</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"names\" type=\"as\">\n"
            "        <doc>\n"
            "          <line>names = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"UnsetEnvironment\">\n"
            "      <doc>\n"
            "        <line>UnsetEnvironment = UnsetEnvironment() may be used to unset environment variables. Takes a string array with environment variable names.</line>\n"
            "        <line>All variables specified will be unset (if they have been set previously) and no longer be passed to all spawned processes.</line>\n"
            "        <line>This call has no effect for variables that were previously not set, but will not fail in that case.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"names\" type=\"as\">\n"
            "        <doc>\n"
            "          <line>names = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"UnsetAndSetEnvironment\">\n"
            "      <doc>\n"
            "        <line>UnsetAndSetEnvironment = UnsetAndSetEnvironment() is a combination of UnsetEnvironment() and SetEnvironment().</line>\n"
            "        <line>It takes two lists. The first one is a list of variables to unset, the second one of assignments to set.</line>\n"
            "        <line>If a variable is listed in both the variable is set after this call, i.e. the set list overrides the unset list.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"unset\" type=\"as\">\n"
            "        <doc>\n"
            "          <line>unset = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"set\" type=\"as\">\n"
            "        <doc>\n"
            "          <line>set = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ListUnitFiles\">\n"
            "      <doc>\n"
            "        <line>ListUnitFiles = ListUnitFiles() returns an array of unit names plus their enablement status.</line>\n"
            "        <line>Note that ListUnit() returns a list of units currently loaded into memory, while ListUnitFiles()</line>\n"
            "        <line>returns a list of unit files that could be found on disk. Note that while most units are read directly from a unit file with the same name</line>\n"
            "        <line>some units are not backed by files, and some files (templates) cannot directly be loaded as units but need to be instantiated.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"files\" type=\"a(ss)\">\n"
            "        <doc>\n"
            "          <line>files (of type files) = Description missing</line>\n"
            "          <line>files struct[unitName, enablement] = struct generated for DBus argument ListUnitFiles_changes</line>\n"
            "          <line>0: files.unitName ('s') = Description missing</line>\n"
            "          <line>1: files.enablement ('s') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"GetUnitFileState\">\n"
            "      <doc>\n"
            "        <line>GetUnitFileState = GetUnitFileState() returns the current enablement status of specific unit file.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"file\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>file = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"state\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>state = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"EnableUnitFiles\">\n"
            "      <doc>\n"
            "        <line>EnableUnitFiles = EnableUnitFiles() may be used to enable one or more units in the system (by creating symlinks to them in /etc or /run).</line>\n"
            "        <line>It takes a list of unit files to enable (either just file names or full absolute paths if the unit files are residing outside the usual unit search paths),</line>\n"
            "        <line>and two booleans: the first controls whether the unit shall be enabled for runtime only (true, /run), or persistently (false, /etc).</line>\n"
            "        <line>The second one controls whether symlinks pointing to other units shall be replaced if necessary. This call returns one boolean and an array with the changes made.</line>\n"
            "        <line>The boolean signals whether the unit files contained any enablement information (i.e. an [Install]) section.</line>\n"
            "        <line>The changes list consists of structures with three strings: the type of the change (one of symlink or unlink),</line>\n"
            "        <line>the file name of the symlink and the destination of the symlink. Note that most of the following calls return a changes list in the same format.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"files\" type=\"as\">\n"
            "        <doc>\n"
            "          <line>files (of type FileList) = Description missing</line>\n"
            "          <line>FileList = array[STRING]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"runtime\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>runtime = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"force\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>force = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"carries_install_info\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>carries_install_info = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"changes\" type=\"a(sss)\">\n"
            "        <doc>\n"
            "          <line>changes (of type changes) = Description missing</line>\n"
            "          <line>changes struct[type, filename, destination] = Change info struct</line>\n"
            "          <line>0: changes.type ('s') = change type, one of 'symlink' or 'unlink'</line>\n"
            "          <line>1: changes.filename ('s') = Description missing</line>\n"
            "          <line>2: changes.destination ('s') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"DisableUnitFiles\">\n"
            "      <doc>\n"
            "        <line>DisableUnitFiles = DisableUnitFiles() disables one or more units in the system, i.e. removes all symlinks to them in /etc and /run</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"files\" type=\"as\">\n"
            "        <doc>\n"
            "          <line>files (of type FileList) = Description missing</line>\n"
            "          <line>FileList = array[STRING]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"runtime\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>runtime = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"changes\" type=\"a(sss)\">\n"
            "        <doc>\n"
            "          <line>changes (of type changes) = Description missing</line>\n"
            "          <line>changes struct[type, filename, destination] = Change info struct</line>\n"
            "          <line>0: changes.type ('s') = change type, one of 'symlink' or 'unlink'</line>\n"
            "          <line>1: changes.filename ('s') = Description missing</line>\n"
            "          <line>2: changes.destination ('s') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ReenableUnitFiles\">\n"
            "      <doc>\n"
            "        <line>ReenableUnitFiles = ReenableUnitFiles() applies the changes to one or more units that would result from disabling and enabling the</line>\n"
            "        <line>unit quickly one after the other in an atomic fashion.</line>\n"
            "        <line>This is useful to apply updated [Install] information contained in unit files.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"files\" type=\"as\">\n"
            "        <doc>\n"
            "          <line>files (of type FileList) = Description missing</line>\n"
            "          <line>FileList = array[STRING]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"runtime\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>runtime = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"force\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>force = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"carries_install_info\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>carries_install_info = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"changes\" type=\"a(sss)\">\n"
            "        <doc>\n"
            "          <line>changes (of type changes) = Description missing</line>\n"
            "          <line>changes struct[type, filename, destination] = Change info struct</line>\n"
            "          <line>0: changes.type ('s') = change type, one of 'symlink' or 'unlink'</line>\n"
            "          <line>1: changes.filename ('s') = Description missing</line>\n"
            "          <line>2: changes.destination ('s') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"LinkUnitFiles\">\n"
            "      <doc>\n"
            "        <line>LinkUnitFiles = LinkUnitFiles() links unit files (that are located outside of the usual unit search paths) into the unit search path.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"files\" type=\"as\">\n"
            "        <doc>\n"
            "          <line>files (of type FileList) = Description missing</line>\n"
            "          <line>FileList = array[STRING]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"runtime\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>runtime = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"force\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>force = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"changes\" type=\"a(sss)\">\n"
            "        <doc>\n"
            "          <line>changes (of type changes) = Description missing</line>\n"
            "          <line>changes struct[type, filename, destination] = Change info struct</line>\n"
            "          <line>0: changes.type ('s') = change type, one of 'symlink' or 'unlink'</line>\n"
            "          <line>1: changes.filename ('s') = Description missing</line>\n"
            "          <line>2: changes.destination ('s') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"PresetUnitFiles\">\n"
            "      <doc>\n"
            "        <line>PresetUnitFiles = PresetUnitFiles() enables/disables one or more units file according to the preset policy.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"files\" type=\"as\">\n"
            "        <doc>\n"
            "          <line>files (of type FileList) = Description missing</line>\n"
            "          <line>FileList = array[STRING]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"runtime\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>runtime = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"force\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>force = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"carries_install_info\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>carries_install_info = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"changes\" type=\"a(sss)\">\n"
            "        <doc>\n"
            "          <line>changes (of type changes) = Description missing</line>\n"
            "          <line>changes struct[type, filename, destination] = Change info struct</line>\n"
            "          <line>0: changes.type ('s') = change type, one of 'symlink' or 'unlink'</line>\n"
            "          <line>1: changes.filename ('s') = Description missing</line>\n"
            "          <line>2: changes.destination ('s') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"PresetUnitFilesWithMode\">\n"
            "      <doc>\n"
            "        <line>PresetUnitFilesWithMode = PresetUnitFilesWithMode() enables/disables one or more units file according to the preset policy for a given mode.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"files\" type=\"as\">\n"
            "        <doc>\n"
            "          <line>files (of type FileList) = Description missing</line>\n"
            "          <line>FileList = array[STRING]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"mode\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>mode = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"runtime\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>runtime = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"force\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>force = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"carries_install_info\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>carries_install_info = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"changes\" type=\"a(sss)\">\n"
            "        <doc>\n"
            "          <line>changes (of type changes) = Description missing</line>\n"
            "          <line>changes struct[type, filename, destination] = Change info struct</line>\n"
            "          <line>0: changes.type ('s') = change type, one of 'symlink' or 'unlink'</line>\n"
            "          <line>1: changes.filename ('s') = Description missing</line>\n"
            "          <line>2: changes.destination ('s') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"MaskUnitFiles\">\n"
            "      <doc>\n"
            "        <line>MaskUnitFiles = MaskUnitFiles() masks unit files, and UnmaskUnitFiles() unmasks them again.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"files\" type=\"as\">\n"
            "        <doc>\n"
            "          <line>files (of type FileList) = Description missing</line>\n"
            "          <line>FileList = array[STRING]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"runtime\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>runtime = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"force\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>force = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"changes\" type=\"a(sss)\">\n"
            "        <doc>\n"
            "          <line>changes (of type changes) = Description missing</line>\n"
            "          <line>changes struct[type, filename, destination] = Change info struct</line>\n"
            "          <line>0: changes.type ('s') = change type, one of 'symlink' or 'unlink'</line>\n"
            "          <line>1: changes.filename ('s') = Description missing</line>\n"
            "          <line>2: changes.destination ('s') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"UnmaskUnitFiles\">\n"
            "      <doc>\n"
            "        <line>UnmaskUnitFiles = UnmaskUnitFiles()</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"files\" type=\"as\">\n"
            "        <doc>\n"
            "          <line>files (of type FileList) = Description missing</line>\n"
            "          <line>FileList = array[STRING]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"runtime\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>runtime = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"changes\" type=\"a(sss)\">\n"
            "        <doc>\n"
            "          <line>changes (of type changes) = Description missing</line>\n"
            "          <line>changes struct[type, filename, destination] = Change info struct</line>\n"
            "          <line>0: changes.type ('s') = change type, one of 'symlink' or 'unlink'</line>\n"
            "          <line>1: changes.filename ('s') = Description missing</line>\n"
            "          <line>2: changes.destination ('s') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"SetDefaultTarget\">\n"
            "      <doc>\n"
            "        <line>SetDefaultTarget = SetDefaultTarget() changes the default.target link.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"arg_0\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>arg_0 = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"arg_1\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>arg_1 = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"changes\" type=\"a(sss)\">\n"
            "        <doc>\n"
            "          <line>changes (of type changes) = Description missing</line>\n"
            "          <line>changes struct[type, filename, destination] = Change info struct</line>\n"
            "          <line>0: changes.type ('s') = change type, one of 'symlink' or 'unlink'</line>\n"
            "          <line>1: changes.filename ('s') = Description missing</line>\n"
            "          <line>2: changes.destination ('s') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"GetDefaultTarget\">\n"
            "      <doc>\n"
            "        <line>GetDefaultTarget = GetDefaultTarget()  retrieves the name of the unit to which default.target is aliased.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"targetName\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>targetName = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"PresetAllUnitFiles\">\n"
            "      <doc>\n"
            "        <line>PresetAllUnitFiles = PresetAllUnitFiles() enables/disables one or more units file according to the preset policy.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"name\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>name = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"runtime\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>runtime = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"force\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>force = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"changes\" type=\"a(sss)\">\n"
            "        <doc>\n"
            "          <line>changes (of type changes) = Description missing</line>\n"
            "          <line>changes struct[type, filename, destination] = Change info struct</line>\n"
            "          <line>0: changes.type ('s') = change type, one of 'symlink' or 'unlink'</line>\n"
            "          <line>1: changes.filename ('s') = Description missing</line>\n"
            "          <line>2: changes.destination ('s') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"AddDependencyUnitFiles\">\n"
            "      <doc>\n"
            "        <line>AddDependencyUnitFiles = AddDependencyUnitFiles()</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"files\" type=\"as\">\n"
            "        <doc>\n"
            "          <line>files (of type FileList) = Description missing</line>\n"
            "          <line>FileList = array[STRING]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"arg_1\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>arg_1 = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"arg_2\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>arg_2 = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"runtime\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>runtime = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"force\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>force = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"changes\" type=\"a(sss)\">\n"
            "        <doc>\n"
            "          <line>changes (of type changes) = Description missing</line>\n"
            "          <line>changes struct[type, filename, destination] = Change info struct</line>\n"
            "          <line>0: changes.type ('s') = change type, one of 'symlink' or 'unlink'</line>\n"
            "          <line>1: changes.filename ('s') = Description missing</line>\n"
            "          <line>2: changes.destination ('s') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <signal name=\"UnitNew\">\n"
            "      <doc>\n"
            "        <line>UnitNew = This signal is sent out each time a new unit is loaded.</line>\n"
            "        <line>Note that this has little to do with whether a unit is available on disk or not,</line>\n"
            "        <line>and simply reflects the units that are currently loaded into memory.</line>\n"
            "        <line>The signals take two parameters: the primary unit name and the object path.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"id\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>id = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"unit\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>unit (of type ObjectPath) = Description missing</line>\n"
            "          <line>lineComment to be defined</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"UnitRemoved\">\n"
            "      <doc>\n"
            "        <line>UnitRemoved = UnitRemoved()</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"id\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>id = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"unit\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>unit (of type ObjectPath) = Description missing</line>\n"
            "          <line>lineComment to be defined</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"JobNew\">\n"
            "      <doc>\n"
            "        <line>JobNew = JobNew() and JobRemoved() are sent out each time a new job is queued or dequeued. Both signals take the numeric job ID, the bus path</line>\n"
            "        <line>and the primary unit name for this job as argument. JobRemoved() also includes a result string, being one of done, canceled, timeout, failed, dependency,</line>\n"
            "        <line>skipped. done indicates successful execution of a job. canceled indicates that a job has been canceled (via CancelJob() above) before it finished execution</line>\n"
            "        <line>(this doesn't necessarily mean though that the job operation is actually cancelled too, see above). timeout indicates that the job timeout was reached.</line>\n"
            "        <line>failed indicates that the job failed. dependency indicates that a job this job has been depending on failed and the job hence has been removed too.</line>\n"
            "        <line>skipped indicates that a job was skipped because it didn't apply to the units current state.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"id\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>id = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"job\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>job (of type ObjectPath) = Description missing</line>\n"
            "          <line>lineComment to be defined</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"unit\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>unit = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"JobRemoved\">\n"
            "      <doc>\n"
            "        <line>JobRemoved = JobRemoved()</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"id\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>id = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"job\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>job (of type ObjectPath) = Description missing</line>\n"
            "          <line>lineComment to be defined</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"unit\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>unit = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"result\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>result = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"StartupFinished\">\n"
            "      <doc>\n"
            "        <line>StartupFinished = StartupFinished() is sent out when startup finished. It carries six usec timespan values each indicating how much boot time has been spent</line>\n"
            "        <line>in the firmware (if known), in the boot loader (if known), in the kernel initialization phase, in the initrd (if known),</line>\n"
            "        <line>in userspace and in total. These values may also be calculated from the FirmwareTimestampMonotonic, LoaderTimestampMonotonic,</line>\n"
            "        <line>InitRDTimestampMonotonic, UserspaceTimestampMonotonic, FinishTimestampMonotonic properties (see below).</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"firmware\" type=\"t\">\n"
            "        <doc>\n"
            "          <line>firmware = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"loader\" type=\"t\">\n"
            "        <doc>\n"
            "          <line>loader = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"kernel\" type=\"t\">\n"
            "        <doc>\n"
            "          <line>kernel = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"initrd\" type=\"t\">\n"
            "        <doc>\n"
            "          <line>initrd = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"userspace\" type=\"t\">\n"
            "        <doc>\n"
            "          <line>userspace = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"total\" type=\"t\">\n"
            "        <doc>\n"
            "          <line>total = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"UnitFilesChanged\">\n"
            "      <doc>\n"
            "        <line>UnitFilesChanged = UnitFilesChanged() is sent out each time the list of enabled or masked unit files on disk have changed.</line>\n"
            "      </doc>\n"
            "    </signal>\n"
            "    <signal name=\"Reloading\">\n"
            "      <doc>\n"
            "        <line>Reloading = Reloading() is sent out immediately before a daemon reload is done (with the boolean parameter set to True)</line>\n"
            "        <line>and after a daemon reload is completed (with the boolean parameter set to False). This may be used by UIs to optimize UI updates.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"active\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>active = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "</interface>\n";
}

void ManagerStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<ManagerStub*>(getStub()))->onGetAll (properties);
}

void ManagerStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 47, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "Version");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "Features");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "Virtualization");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "Architecture");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "Tainted");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 5: {
            LOG_DEBUG_STUB("process property '%s'", "FirmwareTimestamp");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 6: {
            LOG_DEBUG_STUB("process property '%s'", "FirmwareTimestampMonotonic");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 7: {
            LOG_DEBUG_STUB("process property '%s'", "LoaderTimestamp");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 8: {
            LOG_DEBUG_STUB("process property '%s'", "LoaderTimestampMonotonic");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 9: {
            LOG_DEBUG_STUB("process property '%s'", "KernelTimestamp");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 10: {
            LOG_DEBUG_STUB("process property '%s'", "KernelTimestampMonotonic");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 11: {
            LOG_DEBUG_STUB("process property '%s'", "InitRDTimestamp");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 12: {
            LOG_DEBUG_STUB("process property '%s'", "InitRDTimestampMonotonic");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 13: {
            LOG_DEBUG_STUB("process property '%s'", "UserspaceTimestamp");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 14: {
            LOG_DEBUG_STUB("process property '%s'", "UserspaceTimestampMonotonic");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 15: {
            LOG_DEBUG_STUB("process property '%s'", "FinishTimestamp");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 16: {
            LOG_DEBUG_STUB("process property '%s'", "FinishTimestampMonotonic");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 17: {
            LOG_DEBUG_STUB("process property '%s'", "SecurityStartTimestamp");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 18: {
            LOG_DEBUG_STUB("process property '%s'", "SecurityStartTimestampMonotonic");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 19: {
            LOG_DEBUG_STUB("process property '%s'", "SecurityFinishTimestamp");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 20: {
            LOG_DEBUG_STUB("process property '%s'", "SecurityFinishTimestampMonotonic");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 21: {
            LOG_DEBUG_STUB("process property '%s'", "GeneratorsStartTimestamp");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 22: {
            LOG_DEBUG_STUB("process property '%s'", "GeneratorsStartTimestampMonotonic");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 23: {
            LOG_DEBUG_STUB("process property '%s'", "GeneratorsFinishTimestamp");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 24: {
            LOG_DEBUG_STUB("process property '%s'", "GeneratorsFinishTimestampMonotonic");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 25: {
            LOG_DEBUG_STUB("process property '%s'", "UnitsLoadStartTimestamp");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 26: {
            LOG_DEBUG_STUB("process property '%s'", "UnitsLoadStartTimestampMonotonic");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 27: {
            LOG_DEBUG_STUB("process property '%s'", "UnitsLoadFinishTimestamp");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 28: {
            LOG_DEBUG_STUB("process property '%s'", "UnitsLoadFinishTimestampMonotonic");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 29: {
            LOG_DEBUG_STUB("process property '%s'", "LogLevel");
            ::boost::shared_ptr< LogLevelSet > payload(new LogLevelSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<ManagerStub*>(getStub())->onLogLevelSet (payload);
            return;
        }
        case 30: {
            LOG_DEBUG_STUB("process property '%s'", "LogTarget");
            ::boost::shared_ptr< LogTargetSet > payload(new LogTargetSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<ManagerStub*>(getStub())->onLogTargetSet (payload);
            return;
        }
        case 31: {
            LOG_DEBUG_STUB("process property '%s'", "NNames");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 32: {
            LOG_DEBUG_STUB("process property '%s'", "NFailedUnits");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 33: {
            LOG_DEBUG_STUB("process property '%s'", "NJobs");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 34: {
            LOG_DEBUG_STUB("process property '%s'", "NInstalledJobs");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 35: {
            LOG_DEBUG_STUB("process property '%s'", "NFailedJobs");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 36: {
            LOG_DEBUG_STUB("process property '%s'", "Progress");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 37: {
            LOG_DEBUG_STUB("process property '%s'", "Environment");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 38: {
            LOG_DEBUG_STUB("process property '%s'", "ConfirmSpawn");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 39: {
            LOG_DEBUG_STUB("process property '%s'", "ShowStatus");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 40: {
            LOG_DEBUG_STUB("process property '%s'", "UnitPath");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 41: {
            LOG_DEBUG_STUB("process property '%s'", "DefaultStandardOutput");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 42: {
            LOG_DEBUG_STUB("process property '%s'", "DefaultStandardError");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 43: {
            LOG_DEBUG_STUB("process property '%s'", "RuntimeWatchdogUSec");
            ::boost::shared_ptr< RuntimeWatchdogUSecSet > payload(new RuntimeWatchdogUSecSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<ManagerStub*>(getStub())->onRuntimeWatchdogUSecSet (payload);
            return;
        }
        case 44: {
            LOG_DEBUG_STUB("process property '%s'", "ShutdownWatchdogUSec");
            ::boost::shared_ptr< ShutdownWatchdogUSecSet > payload(new ShutdownWatchdogUSecSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<ManagerStub*>(getStub())->onShutdownWatchdogUSecSet (payload);
            return;
        }
        case 45: {
            LOG_DEBUG_STUB("process property '%s'", "ControlGroup");
            ::boost::shared_ptr< ControlGroupSet > payload(new ControlGroupSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<ManagerStub*>(getStub())->onControlGroupSet (payload);
            return;
        }
        case 46: {
            LOG_DEBUG_STUB("process property '%s'", "SystemState");
            ::boost::shared_ptr< SystemStateSet > payload(new SystemStateSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<ManagerStub*>(getStub())->onSystemStateSet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void ManagerStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 47, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "Version");
            ::boost::shared_ptr< VersionGet > payload(new VersionGet());
            payload->setAct(act);
            static_cast<ManagerStub*>(getStub())->onVersionGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "Features");
            ::boost::shared_ptr< FeaturesGet > payload(new FeaturesGet());
            payload->setAct(act);
            static_cast<ManagerStub*>(getStub())->onFeaturesGet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "Virtualization");
            ::boost::shared_ptr< VirtualizationGet > payload(new VirtualizationGet());
            payload->setAct(act);
            static_cast<ManagerStub*>(getStub())->onVirtualizationGet (payload);
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "Architecture");
            ::boost::shared_ptr< ArchitectureGet > payload(new ArchitectureGet());
            payload->setAct(act);
            static_cast<ManagerStub*>(getStub())->onArchitectureGet (payload);
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "Tainted");
            ::boost::shared_ptr< TaintedGet > payload(new TaintedGet());
            payload->setAct(act);
            static_cast<ManagerStub*>(getStub())->onTaintedGet (payload);
            return;
        }
        case 5: {
            LOG_DEBUG_STUB("process property '%s'", "FirmwareTimestamp");
            ::boost::shared_ptr< FirmwareTimestampGet > payload(new FirmwareTimestampGet());
            payload->setAct(act);
            static_cast<ManagerStub*>(getStub())->onFirmwareTimestampGet (payload);
            return;
        }
        case 6: {
            LOG_DEBUG_STUB("process property '%s'", "FirmwareTimestampMonotonic");
            ::boost::shared_ptr< FirmwareTimestampMonotonicGet > payload(new FirmwareTimestampMonotonicGet());
            payload->setAct(act);
            static_cast<ManagerStub*>(getStub())->onFirmwareTimestampMonotonicGet (payload);
            return;
        }
        case 7: {
            LOG_DEBUG_STUB("process property '%s'", "LoaderTimestamp");
            ::boost::shared_ptr< LoaderTimestampGet > payload(new LoaderTimestampGet());
            payload->setAct(act);
            static_cast<ManagerStub*>(getStub())->onLoaderTimestampGet (payload);
            return;
        }
        case 8: {
            LOG_DEBUG_STUB("process property '%s'", "LoaderTimestampMonotonic");
            ::boost::shared_ptr< LoaderTimestampMonotonicGet > payload(new LoaderTimestampMonotonicGet());
            payload->setAct(act);
            static_cast<ManagerStub*>(getStub())->onLoaderTimestampMonotonicGet (payload);
            return;
        }
        case 9: {
            LOG_DEBUG_STUB("process property '%s'", "KernelTimestamp");
            ::boost::shared_ptr< KernelTimestampGet > payload(new KernelTimestampGet());
            payload->setAct(act);
            static_cast<ManagerStub*>(getStub())->onKernelTimestampGet (payload);
            return;
        }
        case 10: {
            LOG_DEBUG_STUB("process property '%s'", "KernelTimestampMonotonic");
            ::boost::shared_ptr< KernelTimestampMonotonicGet > payload(new KernelTimestampMonotonicGet());
            payload->setAct(act);
            static_cast<ManagerStub*>(getStub())->onKernelTimestampMonotonicGet (payload);
            return;
        }
        case 11: {
            LOG_DEBUG_STUB("process property '%s'", "InitRDTimestamp");
            ::boost::shared_ptr< InitRDTimestampGet > payload(new InitRDTimestampGet());
            payload->setAct(act);
            static_cast<ManagerStub*>(getStub())->onInitRDTimestampGet (payload);
            return;
        }
        case 12: {
            LOG_DEBUG_STUB("process property '%s'", "InitRDTimestampMonotonic");
            ::boost::shared_ptr< InitRDTimestampMonotonicGet > payload(new InitRDTimestampMonotonicGet());
            payload->setAct(act);
            static_cast<ManagerStub*>(getStub())->onInitRDTimestampMonotonicGet (payload);
            return;
        }
        case 13: {
            LOG_DEBUG_STUB("process property '%s'", "UserspaceTimestamp");
            ::boost::shared_ptr< UserspaceTimestampGet > payload(new UserspaceTimestampGet());
            payload->setAct(act);
            static_cast<ManagerStub*>(getStub())->onUserspaceTimestampGet (payload);
            return;
        }
        case 14: {
            LOG_DEBUG_STUB("process property '%s'", "UserspaceTimestampMonotonic");
            ::boost::shared_ptr< UserspaceTimestampMonotonicGet > payload(new UserspaceTimestampMonotonicGet());
            payload->setAct(act);
            static_cast<ManagerStub*>(getStub())->onUserspaceTimestampMonotonicGet (payload);
            return;
        }
        case 15: {
            LOG_DEBUG_STUB("process property '%s'", "FinishTimestamp");
            ::boost::shared_ptr< FinishTimestampGet > payload(new FinishTimestampGet());
            payload->setAct(act);
            static_cast<ManagerStub*>(getStub())->onFinishTimestampGet (payload);
            return;
        }
        case 16: {
            LOG_DEBUG_STUB("process property '%s'", "FinishTimestampMonotonic");
            ::boost::shared_ptr< FinishTimestampMonotonicGet > payload(new FinishTimestampMonotonicGet());
            payload->setAct(act);
            static_cast<ManagerStub*>(getStub())->onFinishTimestampMonotonicGet (payload);
            return;
        }
        case 17: {
            LOG_DEBUG_STUB("process property '%s'", "SecurityStartTimestamp");
            ::boost::shared_ptr< SecurityStartTimestampGet > payload(new SecurityStartTimestampGet());
            payload->setAct(act);
            static_cast<ManagerStub*>(getStub())->onSecurityStartTimestampGet (payload);
            return;
        }
        case 18: {
            LOG_DEBUG_STUB("process property '%s'", "SecurityStartTimestampMonotonic");
            ::boost::shared_ptr< SecurityStartTimestampMonotonicGet > payload(new SecurityStartTimestampMonotonicGet());
            payload->setAct(act);
            static_cast<ManagerStub*>(getStub())->onSecurityStartTimestampMonotonicGet (payload);
            return;
        }
        case 19: {
            LOG_DEBUG_STUB("process property '%s'", "SecurityFinishTimestamp");
            ::boost::shared_ptr< SecurityFinishTimestampGet > payload(new SecurityFinishTimestampGet());
            payload->setAct(act);
            static_cast<ManagerStub*>(getStub())->onSecurityFinishTimestampGet (payload);
            return;
        }
        case 20: {
            LOG_DEBUG_STUB("process property '%s'", "SecurityFinishTimestampMonotonic");
            ::boost::shared_ptr< SecurityFinishTimestampMonotonicGet > payload(new SecurityFinishTimestampMonotonicGet());
            payload->setAct(act);
            static_cast<ManagerStub*>(getStub())->onSecurityFinishTimestampMonotonicGet (payload);
            return;
        }
        case 21: {
            LOG_DEBUG_STUB("process property '%s'", "GeneratorsStartTimestamp");
            ::boost::shared_ptr< GeneratorsStartTimestampGet > payload(new GeneratorsStartTimestampGet());
            payload->setAct(act);
            static_cast<ManagerStub*>(getStub())->onGeneratorsStartTimestampGet (payload);
            return;
        }
        case 22: {
            LOG_DEBUG_STUB("process property '%s'", "GeneratorsStartTimestampMonotonic");
            ::boost::shared_ptr< GeneratorsStartTimestampMonotonicGet > payload(new GeneratorsStartTimestampMonotonicGet());
            payload->setAct(act);
            static_cast<ManagerStub*>(getStub())->onGeneratorsStartTimestampMonotonicGet (payload);
            return;
        }
        case 23: {
            LOG_DEBUG_STUB("process property '%s'", "GeneratorsFinishTimestamp");
            ::boost::shared_ptr< GeneratorsFinishTimestampGet > payload(new GeneratorsFinishTimestampGet());
            payload->setAct(act);
            static_cast<ManagerStub*>(getStub())->onGeneratorsFinishTimestampGet (payload);
            return;
        }
        case 24: {
            LOG_DEBUG_STUB("process property '%s'", "GeneratorsFinishTimestampMonotonic");
            ::boost::shared_ptr< GeneratorsFinishTimestampMonotonicGet > payload(new GeneratorsFinishTimestampMonotonicGet());
            payload->setAct(act);
            static_cast<ManagerStub*>(getStub())->onGeneratorsFinishTimestampMonotonicGet (payload);
            return;
        }
        case 25: {
            LOG_DEBUG_STUB("process property '%s'", "UnitsLoadStartTimestamp");
            ::boost::shared_ptr< UnitsLoadStartTimestampGet > payload(new UnitsLoadStartTimestampGet());
            payload->setAct(act);
            static_cast<ManagerStub*>(getStub())->onUnitsLoadStartTimestampGet (payload);
            return;
        }
        case 26: {
            LOG_DEBUG_STUB("process property '%s'", "UnitsLoadStartTimestampMonotonic");
            ::boost::shared_ptr< UnitsLoadStartTimestampMonotonicGet > payload(new UnitsLoadStartTimestampMonotonicGet());
            payload->setAct(act);
            static_cast<ManagerStub*>(getStub())->onUnitsLoadStartTimestampMonotonicGet (payload);
            return;
        }
        case 27: {
            LOG_DEBUG_STUB("process property '%s'", "UnitsLoadFinishTimestamp");
            ::boost::shared_ptr< UnitsLoadFinishTimestampGet > payload(new UnitsLoadFinishTimestampGet());
            payload->setAct(act);
            static_cast<ManagerStub*>(getStub())->onUnitsLoadFinishTimestampGet (payload);
            return;
        }
        case 28: {
            LOG_DEBUG_STUB("process property '%s'", "UnitsLoadFinishTimestampMonotonic");
            ::boost::shared_ptr< UnitsLoadFinishTimestampMonotonicGet > payload(new UnitsLoadFinishTimestampMonotonicGet());
            payload->setAct(act);
            static_cast<ManagerStub*>(getStub())->onUnitsLoadFinishTimestampMonotonicGet (payload);
            return;
        }
        case 29: {
            LOG_DEBUG_STUB("process property '%s'", "LogLevel");
            ::boost::shared_ptr< LogLevelGet > payload(new LogLevelGet());
            payload->setAct(act);
            static_cast<ManagerStub*>(getStub())->onLogLevelGet (payload);
            return;
        }
        case 30: {
            LOG_DEBUG_STUB("process property '%s'", "LogTarget");
            ::boost::shared_ptr< LogTargetGet > payload(new LogTargetGet());
            payload->setAct(act);
            static_cast<ManagerStub*>(getStub())->onLogTargetGet (payload);
            return;
        }
        case 31: {
            LOG_DEBUG_STUB("process property '%s'", "NNames");
            ::boost::shared_ptr< NNamesGet > payload(new NNamesGet());
            payload->setAct(act);
            static_cast<ManagerStub*>(getStub())->onNNamesGet (payload);
            return;
        }
        case 32: {
            LOG_DEBUG_STUB("process property '%s'", "NFailedUnits");
            ::boost::shared_ptr< NFailedUnitsGet > payload(new NFailedUnitsGet());
            payload->setAct(act);
            static_cast<ManagerStub*>(getStub())->onNFailedUnitsGet (payload);
            return;
        }
        case 33: {
            LOG_DEBUG_STUB("process property '%s'", "NJobs");
            ::boost::shared_ptr< NJobsGet > payload(new NJobsGet());
            payload->setAct(act);
            static_cast<ManagerStub*>(getStub())->onNJobsGet (payload);
            return;
        }
        case 34: {
            LOG_DEBUG_STUB("process property '%s'", "NInstalledJobs");
            ::boost::shared_ptr< NInstalledJobsGet > payload(new NInstalledJobsGet());
            payload->setAct(act);
            static_cast<ManagerStub*>(getStub())->onNInstalledJobsGet (payload);
            return;
        }
        case 35: {
            LOG_DEBUG_STUB("process property '%s'", "NFailedJobs");
            ::boost::shared_ptr< NFailedJobsGet > payload(new NFailedJobsGet());
            payload->setAct(act);
            static_cast<ManagerStub*>(getStub())->onNFailedJobsGet (payload);
            return;
        }
        case 36: {
            LOG_DEBUG_STUB("process property '%s'", "Progress");
            ::boost::shared_ptr< ProgressGet > payload(new ProgressGet());
            payload->setAct(act);
            static_cast<ManagerStub*>(getStub())->onProgressGet (payload);
            return;
        }
        case 37: {
            LOG_DEBUG_STUB("process property '%s'", "Environment");
            ::boost::shared_ptr< EnvironmentGet > payload(new EnvironmentGet());
            payload->setAct(act);
            static_cast<ManagerStub*>(getStub())->onEnvironmentGet (payload);
            return;
        }
        case 38: {
            LOG_DEBUG_STUB("process property '%s'", "ConfirmSpawn");
            ::boost::shared_ptr< ConfirmSpawnGet > payload(new ConfirmSpawnGet());
            payload->setAct(act);
            static_cast<ManagerStub*>(getStub())->onConfirmSpawnGet (payload);
            return;
        }
        case 39: {
            LOG_DEBUG_STUB("process property '%s'", "ShowStatus");
            ::boost::shared_ptr< ShowStatusGet > payload(new ShowStatusGet());
            payload->setAct(act);
            static_cast<ManagerStub*>(getStub())->onShowStatusGet (payload);
            return;
        }
        case 40: {
            LOG_DEBUG_STUB("process property '%s'", "UnitPath");
            ::boost::shared_ptr< UnitPathGet > payload(new UnitPathGet());
            payload->setAct(act);
            static_cast<ManagerStub*>(getStub())->onUnitPathGet (payload);
            return;
        }
        case 41: {
            LOG_DEBUG_STUB("process property '%s'", "DefaultStandardOutput");
            ::boost::shared_ptr< DefaultStandardOutputGet > payload(new DefaultStandardOutputGet());
            payload->setAct(act);
            static_cast<ManagerStub*>(getStub())->onDefaultStandardOutputGet (payload);
            return;
        }
        case 42: {
            LOG_DEBUG_STUB("process property '%s'", "DefaultStandardError");
            ::boost::shared_ptr< DefaultStandardErrorGet > payload(new DefaultStandardErrorGet());
            payload->setAct(act);
            static_cast<ManagerStub*>(getStub())->onDefaultStandardErrorGet (payload);
            return;
        }
        case 43: {
            LOG_DEBUG_STUB("process property '%s'", "RuntimeWatchdogUSec");
            ::boost::shared_ptr< RuntimeWatchdogUSecGet > payload(new RuntimeWatchdogUSecGet());
            payload->setAct(act);
            static_cast<ManagerStub*>(getStub())->onRuntimeWatchdogUSecGet (payload);
            return;
        }
        case 44: {
            LOG_DEBUG_STUB("process property '%s'", "ShutdownWatchdogUSec");
            ::boost::shared_ptr< ShutdownWatchdogUSecGet > payload(new ShutdownWatchdogUSecGet());
            payload->setAct(act);
            static_cast<ManagerStub*>(getStub())->onShutdownWatchdogUSecGet (payload);
            return;
        }
        case 45: {
            LOG_DEBUG_STUB("process property '%s'", "ControlGroup");
            ::boost::shared_ptr< ControlGroupGet > payload(new ControlGroupGet());
            payload->setAct(act);
            static_cast<ManagerStub*>(getStub())->onControlGroupGet (payload);
            return;
        }
        case 46: {
            LOG_DEBUG_STUB("process property '%s'", "SystemState");
            ::boost::shared_ptr< SystemStateGet > payload(new SystemStateGet());
            payload->setAct(act);
            static_cast<ManagerStub*>(getStub())->onSystemStateGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

ManagerStub::ManagerStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new ManagerStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

ManagerStub::ManagerStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new ManagerStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

ManagerStub::~ManagerStub() {
    delete _stubDelegate;
}

void ManagerStub::sendUnitNewSignal(const ::std::string& id, const ::std::string& unit) {
    if (_stubDelegate->isConnected()) {
        UnitNewSignal* payload = new UnitNewSignal(id, unit);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "UnitNew", UnitNewSignal, payload)
        LOG_INFO ("-> send%sSignal", "UnitNew");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "UnitNew");
    }
}

void ManagerStub::sendUnitRemovedSignal(const ::std::string& id, const ::std::string& unit) {
    if (_stubDelegate->isConnected()) {
        UnitRemovedSignal* payload = new UnitRemovedSignal(id, unit);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "UnitRemoved", UnitRemovedSignal, payload)
        LOG_INFO ("-> send%sSignal", "UnitRemoved");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "UnitRemoved");
    }
}

void ManagerStub::sendJobNewSignal(uint32 id, const ::std::string& job, const ::std::string& unit) {
    if (_stubDelegate->isConnected()) {
        JobNewSignal* payload = new JobNewSignal(id, job, unit);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "JobNew", JobNewSignal, payload)
        LOG_INFO ("-> send%sSignal", "JobNew");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "JobNew");
    }
}

void ManagerStub::sendJobRemovedSignal(uint32 id, const ::std::string& job, const ::std::string& unit, const ::std::string& result) {
    if (_stubDelegate->isConnected()) {
        JobRemovedSignal* payload = new JobRemovedSignal(id, job, unit, result);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "JobRemoved", JobRemovedSignal, payload)
        LOG_INFO ("-> send%sSignal", "JobRemoved");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "JobRemoved");
    }
}

void ManagerStub::sendStartupFinishedSignal(uint64 firmware, uint64 loader, uint64 kernel, uint64 initrd, uint64 userspace, uint64 total) {
    if (_stubDelegate->isConnected()) {
        StartupFinishedSignal* payload = new StartupFinishedSignal(firmware, loader, kernel, initrd, userspace, total);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "StartupFinished", StartupFinishedSignal, payload)
        LOG_INFO ("-> send%sSignal", "StartupFinished");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "StartupFinished");
    }
}

void ManagerStub::sendUnitFilesChangedSignal() {
    if (_stubDelegate->isConnected()) {
        UnitFilesChangedSignal* payload = new UnitFilesChangedSignal;
        DBUS_MESSAGE_SIGNAL(dbusMessage, "UnitFilesChanged", UnitFilesChangedSignal, payload)
        LOG_INFO ("-> send%sSignal", "UnitFilesChanged");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "UnitFilesChanged");
    }
}

void ManagerStub::sendReloadingSignal(bool active) {
    if (_stubDelegate->isConnected()) {
        ReloadingSignal* payload = new ReloadingSignal(active);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "Reloading", ReloadingSignal, payload)
        LOG_INFO ("-> send%sSignal", "Reloading");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "Reloading");
    }
}

void ManagerStub::sendVersionUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        VersionUpdate payload(_VersionProperty);

        LOG_INFO ("-> send%s", "VersionUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Version", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Manager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "VersionUpdate");
    }
}

void ManagerStub::onVersionGet(const ::boost::shared_ptr< VersionGet >& version) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "VersionGet", version->getAct());
    sendVersionGetUpdate(_VersionProperty.getVersion(), version->getAct());
}

void ManagerStub::sendVersionGetUpdate(const ::std::string& version, act_t act) {
    ::asf::dbus::DBusVariant variant;
    VersionGet payload(version);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "VersionGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ManagerStub::setVersion(const ::std::string& version) {
    if(version!=_VersionProperty.getVersion()) {
        _VersionProperty.setVersion(version);
        sendVersionUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& ManagerStub::getVersion() const {
    return _VersionProperty.getVersion();
}

::std::string& ManagerStub::getVersionMutable() {
    return _VersionProperty.getVersionMutable();
}

void ManagerStub::sendFeaturesUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        FeaturesUpdate payload(_FeaturesProperty);

        LOG_INFO ("-> send%s", "FeaturesUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Features", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Manager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "FeaturesUpdate");
    }
}

void ManagerStub::onFeaturesGet(const ::boost::shared_ptr< FeaturesGet >& features) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "FeaturesGet", features->getAct());
    sendFeaturesGetUpdate(_FeaturesProperty.getFeatures(), features->getAct());
}

void ManagerStub::sendFeaturesGetUpdate(const ::std::string& features, act_t act) {
    ::asf::dbus::DBusVariant variant;
    FeaturesGet payload(features);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "FeaturesGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ManagerStub::setFeatures(const ::std::string& features) {
    if(features!=_FeaturesProperty.getFeatures()) {
        _FeaturesProperty.setFeatures(features);
        sendFeaturesUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& ManagerStub::getFeatures() const {
    return _FeaturesProperty.getFeatures();
}

::std::string& ManagerStub::getFeaturesMutable() {
    return _FeaturesProperty.getFeaturesMutable();
}

void ManagerStub::sendVirtualizationUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        VirtualizationUpdate payload(_VirtualizationProperty);

        LOG_INFO ("-> send%s", "VirtualizationUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Virtualization", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Manager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "VirtualizationUpdate");
    }
}

void ManagerStub::onVirtualizationGet(const ::boost::shared_ptr< VirtualizationGet >& virtualization) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "VirtualizationGet", virtualization->getAct());
    sendVirtualizationGetUpdate(_VirtualizationProperty.getVirtualization(), virtualization->getAct());
}

void ManagerStub::sendVirtualizationGetUpdate(const ::std::string& virtualization, act_t act) {
    ::asf::dbus::DBusVariant variant;
    VirtualizationGet payload(virtualization);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "VirtualizationGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ManagerStub::setVirtualization(const ::std::string& virtualization) {
    if(virtualization!=_VirtualizationProperty.getVirtualization()) {
        _VirtualizationProperty.setVirtualization(virtualization);
        sendVirtualizationUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& ManagerStub::getVirtualization() const {
    return _VirtualizationProperty.getVirtualization();
}

::std::string& ManagerStub::getVirtualizationMutable() {
    return _VirtualizationProperty.getVirtualizationMutable();
}

void ManagerStub::sendArchitectureUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ArchitectureUpdate payload(_ArchitectureProperty);

        LOG_INFO ("-> send%s", "ArchitectureUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Architecture", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Manager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ArchitectureUpdate");
    }
}

void ManagerStub::onArchitectureGet(const ::boost::shared_ptr< ArchitectureGet >& architecture) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ArchitectureGet", architecture->getAct());
    sendArchitectureGetUpdate(_ArchitectureProperty.getArchitecture(), architecture->getAct());
}

void ManagerStub::sendArchitectureGetUpdate(const ::std::string& architecture, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ArchitectureGet payload(architecture);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ArchitectureGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ManagerStub::setArchitecture(const ::std::string& architecture) {
    if(architecture!=_ArchitectureProperty.getArchitecture()) {
        _ArchitectureProperty.setArchitecture(architecture);
        sendArchitectureUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& ManagerStub::getArchitecture() const {
    return _ArchitectureProperty.getArchitecture();
}

::std::string& ManagerStub::getArchitectureMutable() {
    return _ArchitectureProperty.getArchitectureMutable();
}

void ManagerStub::sendTaintedUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        TaintedUpdate payload(_TaintedProperty);

        LOG_INFO ("-> send%s", "TaintedUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Tainted", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Manager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "TaintedUpdate");
    }
}

void ManagerStub::onTaintedGet(const ::boost::shared_ptr< TaintedGet >& tainted) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "TaintedGet", tainted->getAct());
    sendTaintedGetUpdate(_TaintedProperty.getTainted(), tainted->getAct());
}

void ManagerStub::sendTaintedGetUpdate(const ::std::string& tainted, act_t act) {
    ::asf::dbus::DBusVariant variant;
    TaintedGet payload(tainted);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "TaintedGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ManagerStub::setTainted(const ::std::string& tainted) {
    if(tainted!=_TaintedProperty.getTainted()) {
        _TaintedProperty.setTainted(tainted);
        sendTaintedUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& ManagerStub::getTainted() const {
    return _TaintedProperty.getTainted();
}

::std::string& ManagerStub::getTaintedMutable() {
    return _TaintedProperty.getTaintedMutable();
}

void ManagerStub::sendFirmwareTimestampUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        FirmwareTimestampUpdate payload(_FirmwareTimestampProperty);

        LOG_INFO ("-> send%s", "FirmwareTimestampUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("FirmwareTimestamp", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Manager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "FirmwareTimestampUpdate");
    }
}

void ManagerStub::onFirmwareTimestampGet(const ::boost::shared_ptr< FirmwareTimestampGet >& firmwareTimestamp) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "FirmwareTimestampGet", firmwareTimestamp->getAct());
    sendFirmwareTimestampGetUpdate(_FirmwareTimestampProperty.getFirmwareTimestamp(), firmwareTimestamp->getAct());
}

void ManagerStub::sendFirmwareTimestampGetUpdate(uint64 firmwareTimestamp, act_t act) {
    ::asf::dbus::DBusVariant variant;
    FirmwareTimestampGet payload(firmwareTimestamp);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "FirmwareTimestampGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ManagerStub::setFirmwareTimestamp(uint64 firmwareTimestamp) {
    if(firmwareTimestamp!=_FirmwareTimestampProperty.getFirmwareTimestamp()) {
        _FirmwareTimestampProperty.setFirmwareTimestamp(firmwareTimestamp);
        sendFirmwareTimestampUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ManagerStub::getFirmwareTimestamp() const {
    return _FirmwareTimestampProperty.getFirmwareTimestamp();
}

void ManagerStub::sendFirmwareTimestampMonotonicUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        FirmwareTimestampMonotonicUpdate payload(_FirmwareTimestampMonotonicProperty);

        LOG_INFO ("-> send%s", "FirmwareTimestampMonotonicUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("FirmwareTimestampMonotonic", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Manager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "FirmwareTimestampMonotonicUpdate");
    }
}

void ManagerStub::onFirmwareTimestampMonotonicGet(const ::boost::shared_ptr< FirmwareTimestampMonotonicGet >& firmwareTimestampMonotonic) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "FirmwareTimestampMonotonicGet", firmwareTimestampMonotonic->getAct());
    sendFirmwareTimestampMonotonicGetUpdate(_FirmwareTimestampMonotonicProperty.getFirmwareTimestampMonotonic(), firmwareTimestampMonotonic->getAct());
}

void ManagerStub::sendFirmwareTimestampMonotonicGetUpdate(uint64 firmwareTimestampMonotonic, act_t act) {
    ::asf::dbus::DBusVariant variant;
    FirmwareTimestampMonotonicGet payload(firmwareTimestampMonotonic);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "FirmwareTimestampMonotonicGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ManagerStub::setFirmwareTimestampMonotonic(uint64 firmwareTimestampMonotonic) {
    if(firmwareTimestampMonotonic!=_FirmwareTimestampMonotonicProperty.getFirmwareTimestampMonotonic()) {
        _FirmwareTimestampMonotonicProperty.setFirmwareTimestampMonotonic(firmwareTimestampMonotonic);
        sendFirmwareTimestampMonotonicUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ManagerStub::getFirmwareTimestampMonotonic() const {
    return _FirmwareTimestampMonotonicProperty.getFirmwareTimestampMonotonic();
}

void ManagerStub::sendLoaderTimestampUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        LoaderTimestampUpdate payload(_LoaderTimestampProperty);

        LOG_INFO ("-> send%s", "LoaderTimestampUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("LoaderTimestamp", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Manager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "LoaderTimestampUpdate");
    }
}

void ManagerStub::onLoaderTimestampGet(const ::boost::shared_ptr< LoaderTimestampGet >& loaderTimestamp) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "LoaderTimestampGet", loaderTimestamp->getAct());
    sendLoaderTimestampGetUpdate(_LoaderTimestampProperty.getLoaderTimestamp(), loaderTimestamp->getAct());
}

void ManagerStub::sendLoaderTimestampGetUpdate(uint64 loaderTimestamp, act_t act) {
    ::asf::dbus::DBusVariant variant;
    LoaderTimestampGet payload(loaderTimestamp);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "LoaderTimestampGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ManagerStub::setLoaderTimestamp(uint64 loaderTimestamp) {
    if(loaderTimestamp!=_LoaderTimestampProperty.getLoaderTimestamp()) {
        _LoaderTimestampProperty.setLoaderTimestamp(loaderTimestamp);
        sendLoaderTimestampUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ManagerStub::getLoaderTimestamp() const {
    return _LoaderTimestampProperty.getLoaderTimestamp();
}

void ManagerStub::sendLoaderTimestampMonotonicUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        LoaderTimestampMonotonicUpdate payload(_LoaderTimestampMonotonicProperty);

        LOG_INFO ("-> send%s", "LoaderTimestampMonotonicUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("LoaderTimestampMonotonic", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Manager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "LoaderTimestampMonotonicUpdate");
    }
}

void ManagerStub::onLoaderTimestampMonotonicGet(const ::boost::shared_ptr< LoaderTimestampMonotonicGet >& loaderTimestampMonotonic) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "LoaderTimestampMonotonicGet", loaderTimestampMonotonic->getAct());
    sendLoaderTimestampMonotonicGetUpdate(_LoaderTimestampMonotonicProperty.getLoaderTimestampMonotonic(), loaderTimestampMonotonic->getAct());
}

void ManagerStub::sendLoaderTimestampMonotonicGetUpdate(uint64 loaderTimestampMonotonic, act_t act) {
    ::asf::dbus::DBusVariant variant;
    LoaderTimestampMonotonicGet payload(loaderTimestampMonotonic);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "LoaderTimestampMonotonicGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ManagerStub::setLoaderTimestampMonotonic(uint64 loaderTimestampMonotonic) {
    if(loaderTimestampMonotonic!=_LoaderTimestampMonotonicProperty.getLoaderTimestampMonotonic()) {
        _LoaderTimestampMonotonicProperty.setLoaderTimestampMonotonic(loaderTimestampMonotonic);
        sendLoaderTimestampMonotonicUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ManagerStub::getLoaderTimestampMonotonic() const {
    return _LoaderTimestampMonotonicProperty.getLoaderTimestampMonotonic();
}

void ManagerStub::sendKernelTimestampUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        KernelTimestampUpdate payload(_KernelTimestampProperty);

        LOG_INFO ("-> send%s", "KernelTimestampUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("KernelTimestamp", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Manager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "KernelTimestampUpdate");
    }
}

void ManagerStub::onKernelTimestampGet(const ::boost::shared_ptr< KernelTimestampGet >& kernelTimestamp) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "KernelTimestampGet", kernelTimestamp->getAct());
    sendKernelTimestampGetUpdate(_KernelTimestampProperty.getKernelTimestamp(), kernelTimestamp->getAct());
}

void ManagerStub::sendKernelTimestampGetUpdate(uint64 kernelTimestamp, act_t act) {
    ::asf::dbus::DBusVariant variant;
    KernelTimestampGet payload(kernelTimestamp);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "KernelTimestampGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ManagerStub::setKernelTimestamp(uint64 kernelTimestamp) {
    if(kernelTimestamp!=_KernelTimestampProperty.getKernelTimestamp()) {
        _KernelTimestampProperty.setKernelTimestamp(kernelTimestamp);
        sendKernelTimestampUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ManagerStub::getKernelTimestamp() const {
    return _KernelTimestampProperty.getKernelTimestamp();
}

void ManagerStub::sendKernelTimestampMonotonicUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        KernelTimestampMonotonicUpdate payload(_KernelTimestampMonotonicProperty);

        LOG_INFO ("-> send%s", "KernelTimestampMonotonicUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("KernelTimestampMonotonic", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Manager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "KernelTimestampMonotonicUpdate");
    }
}

void ManagerStub::onKernelTimestampMonotonicGet(const ::boost::shared_ptr< KernelTimestampMonotonicGet >& kernelTimestampMonotonic) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "KernelTimestampMonotonicGet", kernelTimestampMonotonic->getAct());
    sendKernelTimestampMonotonicGetUpdate(_KernelTimestampMonotonicProperty.getKernelTimestampMonotonic(), kernelTimestampMonotonic->getAct());
}

void ManagerStub::sendKernelTimestampMonotonicGetUpdate(uint64 kernelTimestampMonotonic, act_t act) {
    ::asf::dbus::DBusVariant variant;
    KernelTimestampMonotonicGet payload(kernelTimestampMonotonic);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "KernelTimestampMonotonicGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ManagerStub::setKernelTimestampMonotonic(uint64 kernelTimestampMonotonic) {
    if(kernelTimestampMonotonic!=_KernelTimestampMonotonicProperty.getKernelTimestampMonotonic()) {
        _KernelTimestampMonotonicProperty.setKernelTimestampMonotonic(kernelTimestampMonotonic);
        sendKernelTimestampMonotonicUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ManagerStub::getKernelTimestampMonotonic() const {
    return _KernelTimestampMonotonicProperty.getKernelTimestampMonotonic();
}

void ManagerStub::sendInitRDTimestampUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        InitRDTimestampUpdate payload(_InitRDTimestampProperty);

        LOG_INFO ("-> send%s", "InitRDTimestampUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("InitRDTimestamp", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Manager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "InitRDTimestampUpdate");
    }
}

void ManagerStub::onInitRDTimestampGet(const ::boost::shared_ptr< InitRDTimestampGet >& initRDTimestamp) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "InitRDTimestampGet", initRDTimestamp->getAct());
    sendInitRDTimestampGetUpdate(_InitRDTimestampProperty.getInitRDTimestamp(), initRDTimestamp->getAct());
}

void ManagerStub::sendInitRDTimestampGetUpdate(uint64 initRDTimestamp, act_t act) {
    ::asf::dbus::DBusVariant variant;
    InitRDTimestampGet payload(initRDTimestamp);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "InitRDTimestampGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ManagerStub::setInitRDTimestamp(uint64 initRDTimestamp) {
    if(initRDTimestamp!=_InitRDTimestampProperty.getInitRDTimestamp()) {
        _InitRDTimestampProperty.setInitRDTimestamp(initRDTimestamp);
        sendInitRDTimestampUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ManagerStub::getInitRDTimestamp() const {
    return _InitRDTimestampProperty.getInitRDTimestamp();
}

void ManagerStub::sendInitRDTimestampMonotonicUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        InitRDTimestampMonotonicUpdate payload(_InitRDTimestampMonotonicProperty);

        LOG_INFO ("-> send%s", "InitRDTimestampMonotonicUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("InitRDTimestampMonotonic", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Manager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "InitRDTimestampMonotonicUpdate");
    }
}

void ManagerStub::onInitRDTimestampMonotonicGet(const ::boost::shared_ptr< InitRDTimestampMonotonicGet >& initRDTimestampMonotonic) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "InitRDTimestampMonotonicGet", initRDTimestampMonotonic->getAct());
    sendInitRDTimestampMonotonicGetUpdate(_InitRDTimestampMonotonicProperty.getInitRDTimestampMonotonic(), initRDTimestampMonotonic->getAct());
}

void ManagerStub::sendInitRDTimestampMonotonicGetUpdate(uint64 initRDTimestampMonotonic, act_t act) {
    ::asf::dbus::DBusVariant variant;
    InitRDTimestampMonotonicGet payload(initRDTimestampMonotonic);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "InitRDTimestampMonotonicGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ManagerStub::setInitRDTimestampMonotonic(uint64 initRDTimestampMonotonic) {
    if(initRDTimestampMonotonic!=_InitRDTimestampMonotonicProperty.getInitRDTimestampMonotonic()) {
        _InitRDTimestampMonotonicProperty.setInitRDTimestampMonotonic(initRDTimestampMonotonic);
        sendInitRDTimestampMonotonicUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ManagerStub::getInitRDTimestampMonotonic() const {
    return _InitRDTimestampMonotonicProperty.getInitRDTimestampMonotonic();
}

void ManagerStub::sendUserspaceTimestampUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        UserspaceTimestampUpdate payload(_UserspaceTimestampProperty);

        LOG_INFO ("-> send%s", "UserspaceTimestampUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("UserspaceTimestamp", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Manager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "UserspaceTimestampUpdate");
    }
}

void ManagerStub::onUserspaceTimestampGet(const ::boost::shared_ptr< UserspaceTimestampGet >& userspaceTimestamp) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "UserspaceTimestampGet", userspaceTimestamp->getAct());
    sendUserspaceTimestampGetUpdate(_UserspaceTimestampProperty.getUserspaceTimestamp(), userspaceTimestamp->getAct());
}

void ManagerStub::sendUserspaceTimestampGetUpdate(uint64 userspaceTimestamp, act_t act) {
    ::asf::dbus::DBusVariant variant;
    UserspaceTimestampGet payload(userspaceTimestamp);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "UserspaceTimestampGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ManagerStub::setUserspaceTimestamp(uint64 userspaceTimestamp) {
    if(userspaceTimestamp!=_UserspaceTimestampProperty.getUserspaceTimestamp()) {
        _UserspaceTimestampProperty.setUserspaceTimestamp(userspaceTimestamp);
        sendUserspaceTimestampUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ManagerStub::getUserspaceTimestamp() const {
    return _UserspaceTimestampProperty.getUserspaceTimestamp();
}

void ManagerStub::sendUserspaceTimestampMonotonicUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        UserspaceTimestampMonotonicUpdate payload(_UserspaceTimestampMonotonicProperty);

        LOG_INFO ("-> send%s", "UserspaceTimestampMonotonicUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("UserspaceTimestampMonotonic", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Manager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "UserspaceTimestampMonotonicUpdate");
    }
}

void ManagerStub::onUserspaceTimestampMonotonicGet(const ::boost::shared_ptr< UserspaceTimestampMonotonicGet >& userspaceTimestampMonotonic) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "UserspaceTimestampMonotonicGet", userspaceTimestampMonotonic->getAct());
    sendUserspaceTimestampMonotonicGetUpdate(_UserspaceTimestampMonotonicProperty.getUserspaceTimestampMonotonic(), userspaceTimestampMonotonic->getAct());
}

void ManagerStub::sendUserspaceTimestampMonotonicGetUpdate(uint64 userspaceTimestampMonotonic, act_t act) {
    ::asf::dbus::DBusVariant variant;
    UserspaceTimestampMonotonicGet payload(userspaceTimestampMonotonic);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "UserspaceTimestampMonotonicGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ManagerStub::setUserspaceTimestampMonotonic(uint64 userspaceTimestampMonotonic) {
    if(userspaceTimestampMonotonic!=_UserspaceTimestampMonotonicProperty.getUserspaceTimestampMonotonic()) {
        _UserspaceTimestampMonotonicProperty.setUserspaceTimestampMonotonic(userspaceTimestampMonotonic);
        sendUserspaceTimestampMonotonicUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ManagerStub::getUserspaceTimestampMonotonic() const {
    return _UserspaceTimestampMonotonicProperty.getUserspaceTimestampMonotonic();
}

void ManagerStub::sendFinishTimestampUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        FinishTimestampUpdate payload(_FinishTimestampProperty);

        LOG_INFO ("-> send%s", "FinishTimestampUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("FinishTimestamp", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Manager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "FinishTimestampUpdate");
    }
}

void ManagerStub::onFinishTimestampGet(const ::boost::shared_ptr< FinishTimestampGet >& finishTimestamp) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "FinishTimestampGet", finishTimestamp->getAct());
    sendFinishTimestampGetUpdate(_FinishTimestampProperty.getFinishTimestamp(), finishTimestamp->getAct());
}

void ManagerStub::sendFinishTimestampGetUpdate(uint64 finishTimestamp, act_t act) {
    ::asf::dbus::DBusVariant variant;
    FinishTimestampGet payload(finishTimestamp);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "FinishTimestampGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ManagerStub::setFinishTimestamp(uint64 finishTimestamp) {
    if(finishTimestamp!=_FinishTimestampProperty.getFinishTimestamp()) {
        _FinishTimestampProperty.setFinishTimestamp(finishTimestamp);
        sendFinishTimestampUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ManagerStub::getFinishTimestamp() const {
    return _FinishTimestampProperty.getFinishTimestamp();
}

void ManagerStub::sendFinishTimestampMonotonicUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        FinishTimestampMonotonicUpdate payload(_FinishTimestampMonotonicProperty);

        LOG_INFO ("-> send%s", "FinishTimestampMonotonicUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("FinishTimestampMonotonic", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Manager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "FinishTimestampMonotonicUpdate");
    }
}

void ManagerStub::onFinishTimestampMonotonicGet(const ::boost::shared_ptr< FinishTimestampMonotonicGet >& finishTimestampMonotonic) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "FinishTimestampMonotonicGet", finishTimestampMonotonic->getAct());
    sendFinishTimestampMonotonicGetUpdate(_FinishTimestampMonotonicProperty.getFinishTimestampMonotonic(), finishTimestampMonotonic->getAct());
}

void ManagerStub::sendFinishTimestampMonotonicGetUpdate(uint64 finishTimestampMonotonic, act_t act) {
    ::asf::dbus::DBusVariant variant;
    FinishTimestampMonotonicGet payload(finishTimestampMonotonic);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "FinishTimestampMonotonicGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ManagerStub::setFinishTimestampMonotonic(uint64 finishTimestampMonotonic) {
    if(finishTimestampMonotonic!=_FinishTimestampMonotonicProperty.getFinishTimestampMonotonic()) {
        _FinishTimestampMonotonicProperty.setFinishTimestampMonotonic(finishTimestampMonotonic);
        sendFinishTimestampMonotonicUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ManagerStub::getFinishTimestampMonotonic() const {
    return _FinishTimestampMonotonicProperty.getFinishTimestampMonotonic();
}

void ManagerStub::sendSecurityStartTimestampUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SecurityStartTimestampUpdate payload(_SecurityStartTimestampProperty);

        LOG_INFO ("-> send%s", "SecurityStartTimestampUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("SecurityStartTimestamp", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Manager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SecurityStartTimestampUpdate");
    }
}

void ManagerStub::onSecurityStartTimestampGet(const ::boost::shared_ptr< SecurityStartTimestampGet >& securityStartTimestamp) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SecurityStartTimestampGet", securityStartTimestamp->getAct());
    sendSecurityStartTimestampGetUpdate(_SecurityStartTimestampProperty.getSecurityStartTimestamp(), securityStartTimestamp->getAct());
}

void ManagerStub::sendSecurityStartTimestampGetUpdate(uint64 securityStartTimestamp, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SecurityStartTimestampGet payload(securityStartTimestamp);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SecurityStartTimestampGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ManagerStub::setSecurityStartTimestamp(uint64 securityStartTimestamp) {
    if(securityStartTimestamp!=_SecurityStartTimestampProperty.getSecurityStartTimestamp()) {
        _SecurityStartTimestampProperty.setSecurityStartTimestamp(securityStartTimestamp);
        sendSecurityStartTimestampUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ManagerStub::getSecurityStartTimestamp() const {
    return _SecurityStartTimestampProperty.getSecurityStartTimestamp();
}

void ManagerStub::sendSecurityStartTimestampMonotonicUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SecurityStartTimestampMonotonicUpdate payload(_SecurityStartTimestampMonotonicProperty);

        LOG_INFO ("-> send%s", "SecurityStartTimestampMonotonicUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("SecurityStartTimestampMonotonic", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Manager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SecurityStartTimestampMonotonicUpdate");
    }
}

void ManagerStub::onSecurityStartTimestampMonotonicGet(const ::boost::shared_ptr< SecurityStartTimestampMonotonicGet >& securityStartTimestampMonotonic) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SecurityStartTimestampMonotonicGet", securityStartTimestampMonotonic->getAct());
    sendSecurityStartTimestampMonotonicGetUpdate(_SecurityStartTimestampMonotonicProperty.getSecurityStartTimestampMonotonic(), securityStartTimestampMonotonic->getAct());
}

void ManagerStub::sendSecurityStartTimestampMonotonicGetUpdate(uint64 securityStartTimestampMonotonic, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SecurityStartTimestampMonotonicGet payload(securityStartTimestampMonotonic);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SecurityStartTimestampMonotonicGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ManagerStub::setSecurityStartTimestampMonotonic(uint64 securityStartTimestampMonotonic) {
    if(securityStartTimestampMonotonic!=_SecurityStartTimestampMonotonicProperty.getSecurityStartTimestampMonotonic()) {
        _SecurityStartTimestampMonotonicProperty.setSecurityStartTimestampMonotonic(securityStartTimestampMonotonic);
        sendSecurityStartTimestampMonotonicUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ManagerStub::getSecurityStartTimestampMonotonic() const {
    return _SecurityStartTimestampMonotonicProperty.getSecurityStartTimestampMonotonic();
}

void ManagerStub::sendSecurityFinishTimestampUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SecurityFinishTimestampUpdate payload(_SecurityFinishTimestampProperty);

        LOG_INFO ("-> send%s", "SecurityFinishTimestampUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("SecurityFinishTimestamp", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Manager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SecurityFinishTimestampUpdate");
    }
}

void ManagerStub::onSecurityFinishTimestampGet(const ::boost::shared_ptr< SecurityFinishTimestampGet >& securityFinishTimestamp) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SecurityFinishTimestampGet", securityFinishTimestamp->getAct());
    sendSecurityFinishTimestampGetUpdate(_SecurityFinishTimestampProperty.getSecurityFinishTimestamp(), securityFinishTimestamp->getAct());
}

void ManagerStub::sendSecurityFinishTimestampGetUpdate(uint64 securityFinishTimestamp, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SecurityFinishTimestampGet payload(securityFinishTimestamp);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SecurityFinishTimestampGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ManagerStub::setSecurityFinishTimestamp(uint64 securityFinishTimestamp) {
    if(securityFinishTimestamp!=_SecurityFinishTimestampProperty.getSecurityFinishTimestamp()) {
        _SecurityFinishTimestampProperty.setSecurityFinishTimestamp(securityFinishTimestamp);
        sendSecurityFinishTimestampUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ManagerStub::getSecurityFinishTimestamp() const {
    return _SecurityFinishTimestampProperty.getSecurityFinishTimestamp();
}

void ManagerStub::sendSecurityFinishTimestampMonotonicUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SecurityFinishTimestampMonotonicUpdate payload(_SecurityFinishTimestampMonotonicProperty);

        LOG_INFO ("-> send%s", "SecurityFinishTimestampMonotonicUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("SecurityFinishTimestampMonotonic", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Manager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SecurityFinishTimestampMonotonicUpdate");
    }
}

void ManagerStub::onSecurityFinishTimestampMonotonicGet(const ::boost::shared_ptr< SecurityFinishTimestampMonotonicGet >& securityFinishTimestampMonotonic) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SecurityFinishTimestampMonotonicGet", securityFinishTimestampMonotonic->getAct());
    sendSecurityFinishTimestampMonotonicGetUpdate(_SecurityFinishTimestampMonotonicProperty.getSecurityFinishTimestampMonotonic(), securityFinishTimestampMonotonic->getAct());
}

void ManagerStub::sendSecurityFinishTimestampMonotonicGetUpdate(uint64 securityFinishTimestampMonotonic, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SecurityFinishTimestampMonotonicGet payload(securityFinishTimestampMonotonic);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SecurityFinishTimestampMonotonicGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ManagerStub::setSecurityFinishTimestampMonotonic(uint64 securityFinishTimestampMonotonic) {
    if(securityFinishTimestampMonotonic!=_SecurityFinishTimestampMonotonicProperty.getSecurityFinishTimestampMonotonic()) {
        _SecurityFinishTimestampMonotonicProperty.setSecurityFinishTimestampMonotonic(securityFinishTimestampMonotonic);
        sendSecurityFinishTimestampMonotonicUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ManagerStub::getSecurityFinishTimestampMonotonic() const {
    return _SecurityFinishTimestampMonotonicProperty.getSecurityFinishTimestampMonotonic();
}

void ManagerStub::sendGeneratorsStartTimestampUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        GeneratorsStartTimestampUpdate payload(_GeneratorsStartTimestampProperty);

        LOG_INFO ("-> send%s", "GeneratorsStartTimestampUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("GeneratorsStartTimestamp", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Manager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "GeneratorsStartTimestampUpdate");
    }
}

void ManagerStub::onGeneratorsStartTimestampGet(const ::boost::shared_ptr< GeneratorsStartTimestampGet >& generatorsStartTimestamp) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "GeneratorsStartTimestampGet", generatorsStartTimestamp->getAct());
    sendGeneratorsStartTimestampGetUpdate(_GeneratorsStartTimestampProperty.getGeneratorsStartTimestamp(), generatorsStartTimestamp->getAct());
}

void ManagerStub::sendGeneratorsStartTimestampGetUpdate(uint64 generatorsStartTimestamp, act_t act) {
    ::asf::dbus::DBusVariant variant;
    GeneratorsStartTimestampGet payload(generatorsStartTimestamp);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "GeneratorsStartTimestampGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ManagerStub::setGeneratorsStartTimestamp(uint64 generatorsStartTimestamp) {
    if(generatorsStartTimestamp!=_GeneratorsStartTimestampProperty.getGeneratorsStartTimestamp()) {
        _GeneratorsStartTimestampProperty.setGeneratorsStartTimestamp(generatorsStartTimestamp);
        sendGeneratorsStartTimestampUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ManagerStub::getGeneratorsStartTimestamp() const {
    return _GeneratorsStartTimestampProperty.getGeneratorsStartTimestamp();
}

void ManagerStub::sendGeneratorsStartTimestampMonotonicUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        GeneratorsStartTimestampMonotonicUpdate payload(_GeneratorsStartTimestampMonotonicProperty);

        LOG_INFO ("-> send%s", "GeneratorsStartTimestampMonotonicUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("GeneratorsStartTimestampMonotonic", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Manager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "GeneratorsStartTimestampMonotonicUpdate");
    }
}

void ManagerStub::onGeneratorsStartTimestampMonotonicGet(const ::boost::shared_ptr< GeneratorsStartTimestampMonotonicGet >& generatorsStartTimestampMonotonic) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "GeneratorsStartTimestampMonotonicGet", generatorsStartTimestampMonotonic->getAct());
    sendGeneratorsStartTimestampMonotonicGetUpdate(_GeneratorsStartTimestampMonotonicProperty.getGeneratorsStartTimestampMonotonic(), generatorsStartTimestampMonotonic->getAct());
}

void ManagerStub::sendGeneratorsStartTimestampMonotonicGetUpdate(uint64 generatorsStartTimestampMonotonic, act_t act) {
    ::asf::dbus::DBusVariant variant;
    GeneratorsStartTimestampMonotonicGet payload(generatorsStartTimestampMonotonic);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "GeneratorsStartTimestampMonotonicGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ManagerStub::setGeneratorsStartTimestampMonotonic(uint64 generatorsStartTimestampMonotonic) {
    if(generatorsStartTimestampMonotonic!=_GeneratorsStartTimestampMonotonicProperty.getGeneratorsStartTimestampMonotonic()) {
        _GeneratorsStartTimestampMonotonicProperty.setGeneratorsStartTimestampMonotonic(generatorsStartTimestampMonotonic);
        sendGeneratorsStartTimestampMonotonicUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ManagerStub::getGeneratorsStartTimestampMonotonic() const {
    return _GeneratorsStartTimestampMonotonicProperty.getGeneratorsStartTimestampMonotonic();
}

void ManagerStub::sendGeneratorsFinishTimestampUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        GeneratorsFinishTimestampUpdate payload(_GeneratorsFinishTimestampProperty);

        LOG_INFO ("-> send%s", "GeneratorsFinishTimestampUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("GeneratorsFinishTimestamp", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Manager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "GeneratorsFinishTimestampUpdate");
    }
}

void ManagerStub::onGeneratorsFinishTimestampGet(const ::boost::shared_ptr< GeneratorsFinishTimestampGet >& generatorsFinishTimestamp) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "GeneratorsFinishTimestampGet", generatorsFinishTimestamp->getAct());
    sendGeneratorsFinishTimestampGetUpdate(_GeneratorsFinishTimestampProperty.getGeneratorsFinishTimestamp(), generatorsFinishTimestamp->getAct());
}

void ManagerStub::sendGeneratorsFinishTimestampGetUpdate(uint64 generatorsFinishTimestamp, act_t act) {
    ::asf::dbus::DBusVariant variant;
    GeneratorsFinishTimestampGet payload(generatorsFinishTimestamp);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "GeneratorsFinishTimestampGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ManagerStub::setGeneratorsFinishTimestamp(uint64 generatorsFinishTimestamp) {
    if(generatorsFinishTimestamp!=_GeneratorsFinishTimestampProperty.getGeneratorsFinishTimestamp()) {
        _GeneratorsFinishTimestampProperty.setGeneratorsFinishTimestamp(generatorsFinishTimestamp);
        sendGeneratorsFinishTimestampUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ManagerStub::getGeneratorsFinishTimestamp() const {
    return _GeneratorsFinishTimestampProperty.getGeneratorsFinishTimestamp();
}

void ManagerStub::sendGeneratorsFinishTimestampMonotonicUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        GeneratorsFinishTimestampMonotonicUpdate payload(_GeneratorsFinishTimestampMonotonicProperty);

        LOG_INFO ("-> send%s", "GeneratorsFinishTimestampMonotonicUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("GeneratorsFinishTimestampMonotonic", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Manager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "GeneratorsFinishTimestampMonotonicUpdate");
    }
}

void ManagerStub::onGeneratorsFinishTimestampMonotonicGet(const ::boost::shared_ptr< GeneratorsFinishTimestampMonotonicGet >& generatorsFinishTimestampMonotonic) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "GeneratorsFinishTimestampMonotonicGet", generatorsFinishTimestampMonotonic->getAct());
    sendGeneratorsFinishTimestampMonotonicGetUpdate(_GeneratorsFinishTimestampMonotonicProperty.getGeneratorsFinishTimestampMonotonic(), generatorsFinishTimestampMonotonic->getAct());
}

void ManagerStub::sendGeneratorsFinishTimestampMonotonicGetUpdate(uint64 generatorsFinishTimestampMonotonic, act_t act) {
    ::asf::dbus::DBusVariant variant;
    GeneratorsFinishTimestampMonotonicGet payload(generatorsFinishTimestampMonotonic);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "GeneratorsFinishTimestampMonotonicGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ManagerStub::setGeneratorsFinishTimestampMonotonic(uint64 generatorsFinishTimestampMonotonic) {
    if(generatorsFinishTimestampMonotonic!=_GeneratorsFinishTimestampMonotonicProperty.getGeneratorsFinishTimestampMonotonic()) {
        _GeneratorsFinishTimestampMonotonicProperty.setGeneratorsFinishTimestampMonotonic(generatorsFinishTimestampMonotonic);
        sendGeneratorsFinishTimestampMonotonicUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ManagerStub::getGeneratorsFinishTimestampMonotonic() const {
    return _GeneratorsFinishTimestampMonotonicProperty.getGeneratorsFinishTimestampMonotonic();
}

void ManagerStub::sendUnitsLoadStartTimestampUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        UnitsLoadStartTimestampUpdate payload(_UnitsLoadStartTimestampProperty);

        LOG_INFO ("-> send%s", "UnitsLoadStartTimestampUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("UnitsLoadStartTimestamp", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Manager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "UnitsLoadStartTimestampUpdate");
    }
}

void ManagerStub::onUnitsLoadStartTimestampGet(const ::boost::shared_ptr< UnitsLoadStartTimestampGet >& unitsLoadStartTimestamp) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "UnitsLoadStartTimestampGet", unitsLoadStartTimestamp->getAct());
    sendUnitsLoadStartTimestampGetUpdate(_UnitsLoadStartTimestampProperty.getUnitsLoadStartTimestamp(), unitsLoadStartTimestamp->getAct());
}

void ManagerStub::sendUnitsLoadStartTimestampGetUpdate(uint64 unitsLoadStartTimestamp, act_t act) {
    ::asf::dbus::DBusVariant variant;
    UnitsLoadStartTimestampGet payload(unitsLoadStartTimestamp);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "UnitsLoadStartTimestampGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ManagerStub::setUnitsLoadStartTimestamp(uint64 unitsLoadStartTimestamp) {
    if(unitsLoadStartTimestamp!=_UnitsLoadStartTimestampProperty.getUnitsLoadStartTimestamp()) {
        _UnitsLoadStartTimestampProperty.setUnitsLoadStartTimestamp(unitsLoadStartTimestamp);
        sendUnitsLoadStartTimestampUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ManagerStub::getUnitsLoadStartTimestamp() const {
    return _UnitsLoadStartTimestampProperty.getUnitsLoadStartTimestamp();
}

void ManagerStub::sendUnitsLoadStartTimestampMonotonicUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        UnitsLoadStartTimestampMonotonicUpdate payload(_UnitsLoadStartTimestampMonotonicProperty);

        LOG_INFO ("-> send%s", "UnitsLoadStartTimestampMonotonicUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("UnitsLoadStartTimestampMonotonic", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Manager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "UnitsLoadStartTimestampMonotonicUpdate");
    }
}

void ManagerStub::onUnitsLoadStartTimestampMonotonicGet(const ::boost::shared_ptr< UnitsLoadStartTimestampMonotonicGet >& unitsLoadStartTimestampMonotonic) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "UnitsLoadStartTimestampMonotonicGet", unitsLoadStartTimestampMonotonic->getAct());
    sendUnitsLoadStartTimestampMonotonicGetUpdate(_UnitsLoadStartTimestampMonotonicProperty.getUnitsLoadStartTimestampMonotonic(), unitsLoadStartTimestampMonotonic->getAct());
}

void ManagerStub::sendUnitsLoadStartTimestampMonotonicGetUpdate(uint64 unitsLoadStartTimestampMonotonic, act_t act) {
    ::asf::dbus::DBusVariant variant;
    UnitsLoadStartTimestampMonotonicGet payload(unitsLoadStartTimestampMonotonic);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "UnitsLoadStartTimestampMonotonicGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ManagerStub::setUnitsLoadStartTimestampMonotonic(uint64 unitsLoadStartTimestampMonotonic) {
    if(unitsLoadStartTimestampMonotonic!=_UnitsLoadStartTimestampMonotonicProperty.getUnitsLoadStartTimestampMonotonic()) {
        _UnitsLoadStartTimestampMonotonicProperty.setUnitsLoadStartTimestampMonotonic(unitsLoadStartTimestampMonotonic);
        sendUnitsLoadStartTimestampMonotonicUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ManagerStub::getUnitsLoadStartTimestampMonotonic() const {
    return _UnitsLoadStartTimestampMonotonicProperty.getUnitsLoadStartTimestampMonotonic();
}

void ManagerStub::sendUnitsLoadFinishTimestampUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        UnitsLoadFinishTimestampUpdate payload(_UnitsLoadFinishTimestampProperty);

        LOG_INFO ("-> send%s", "UnitsLoadFinishTimestampUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("UnitsLoadFinishTimestamp", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Manager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "UnitsLoadFinishTimestampUpdate");
    }
}

void ManagerStub::onUnitsLoadFinishTimestampGet(const ::boost::shared_ptr< UnitsLoadFinishTimestampGet >& unitsLoadFinishTimestamp) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "UnitsLoadFinishTimestampGet", unitsLoadFinishTimestamp->getAct());
    sendUnitsLoadFinishTimestampGetUpdate(_UnitsLoadFinishTimestampProperty.getUnitsLoadFinishTimestamp(), unitsLoadFinishTimestamp->getAct());
}

void ManagerStub::sendUnitsLoadFinishTimestampGetUpdate(uint64 unitsLoadFinishTimestamp, act_t act) {
    ::asf::dbus::DBusVariant variant;
    UnitsLoadFinishTimestampGet payload(unitsLoadFinishTimestamp);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "UnitsLoadFinishTimestampGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ManagerStub::setUnitsLoadFinishTimestamp(uint64 unitsLoadFinishTimestamp) {
    if(unitsLoadFinishTimestamp!=_UnitsLoadFinishTimestampProperty.getUnitsLoadFinishTimestamp()) {
        _UnitsLoadFinishTimestampProperty.setUnitsLoadFinishTimestamp(unitsLoadFinishTimestamp);
        sendUnitsLoadFinishTimestampUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ManagerStub::getUnitsLoadFinishTimestamp() const {
    return _UnitsLoadFinishTimestampProperty.getUnitsLoadFinishTimestamp();
}

void ManagerStub::sendUnitsLoadFinishTimestampMonotonicUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        UnitsLoadFinishTimestampMonotonicUpdate payload(_UnitsLoadFinishTimestampMonotonicProperty);

        LOG_INFO ("-> send%s", "UnitsLoadFinishTimestampMonotonicUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("UnitsLoadFinishTimestampMonotonic", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Manager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "UnitsLoadFinishTimestampMonotonicUpdate");
    }
}

void ManagerStub::onUnitsLoadFinishTimestampMonotonicGet(const ::boost::shared_ptr< UnitsLoadFinishTimestampMonotonicGet >& unitsLoadFinishTimestampMonotonic) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "UnitsLoadFinishTimestampMonotonicGet", unitsLoadFinishTimestampMonotonic->getAct());
    sendUnitsLoadFinishTimestampMonotonicGetUpdate(_UnitsLoadFinishTimestampMonotonicProperty.getUnitsLoadFinishTimestampMonotonic(), unitsLoadFinishTimestampMonotonic->getAct());
}

void ManagerStub::sendUnitsLoadFinishTimestampMonotonicGetUpdate(uint64 unitsLoadFinishTimestampMonotonic, act_t act) {
    ::asf::dbus::DBusVariant variant;
    UnitsLoadFinishTimestampMonotonicGet payload(unitsLoadFinishTimestampMonotonic);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "UnitsLoadFinishTimestampMonotonicGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ManagerStub::setUnitsLoadFinishTimestampMonotonic(uint64 unitsLoadFinishTimestampMonotonic) {
    if(unitsLoadFinishTimestampMonotonic!=_UnitsLoadFinishTimestampMonotonicProperty.getUnitsLoadFinishTimestampMonotonic()) {
        _UnitsLoadFinishTimestampMonotonicProperty.setUnitsLoadFinishTimestampMonotonic(unitsLoadFinishTimestampMonotonic);
        sendUnitsLoadFinishTimestampMonotonicUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ManagerStub::getUnitsLoadFinishTimestampMonotonic() const {
    return _UnitsLoadFinishTimestampMonotonicProperty.getUnitsLoadFinishTimestampMonotonic();
}

void ManagerStub::sendLogLevelUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        LogLevelUpdate payload(_LogLevelProperty);

        LOG_INFO ("-> send%s", "LogLevelUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("LogLevel", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Manager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "LogLevelUpdate");
    }
}

void ManagerStub::onLogLevelGet(const ::boost::shared_ptr< LogLevelGet >& logLevel) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "LogLevelGet", logLevel->getAct());
    sendLogLevelGetUpdate(_LogLevelProperty.getLogLevel(), logLevel->getAct());
}

void ManagerStub::sendLogLevelGetUpdate(const ::std::string& logLevel, act_t act) {
    ::asf::dbus::DBusVariant variant;
    LogLevelGet payload(logLevel);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "LogLevelGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ManagerStub::onLogLevelSet(const ::boost::shared_ptr< LogLevelSet >& logLevel) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "LogLevelSet", logLevel->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*logLevel, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setLogLevel (logLevel->getLogLevel());
    sendLogLevelSetUpdate(logLevel->getAct());
}

void ManagerStub::sendLogLevelSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "LogLevelSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void ManagerStub::setLogLevel(const ::std::string& logLevel) {
    if(logLevel!=_LogLevelProperty.getLogLevel()) {
        _LogLevelProperty.setLogLevel(logLevel);
        sendLogLevelUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& ManagerStub::getLogLevel() const {
    return _LogLevelProperty.getLogLevel();
}

::std::string& ManagerStub::getLogLevelMutable() {
    return _LogLevelProperty.getLogLevelMutable();
}

void ManagerStub::sendLogTargetUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        LogTargetUpdate payload(_LogTargetProperty);

        LOG_INFO ("-> send%s", "LogTargetUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("LogTarget", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Manager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "LogTargetUpdate");
    }
}

void ManagerStub::onLogTargetGet(const ::boost::shared_ptr< LogTargetGet >& logTarget) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "LogTargetGet", logTarget->getAct());
    sendLogTargetGetUpdate(_LogTargetProperty.getLogTarget(), logTarget->getAct());
}

void ManagerStub::sendLogTargetGetUpdate(const ::std::string& logTarget, act_t act) {
    ::asf::dbus::DBusVariant variant;
    LogTargetGet payload(logTarget);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "LogTargetGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ManagerStub::onLogTargetSet(const ::boost::shared_ptr< LogTargetSet >& logTarget) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "LogTargetSet", logTarget->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*logTarget, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setLogTarget (logTarget->getLogTarget());
    sendLogTargetSetUpdate(logTarget->getAct());
}

void ManagerStub::sendLogTargetSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "LogTargetSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void ManagerStub::setLogTarget(const ::std::string& logTarget) {
    if(logTarget!=_LogTargetProperty.getLogTarget()) {
        _LogTargetProperty.setLogTarget(logTarget);
        sendLogTargetUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& ManagerStub::getLogTarget() const {
    return _LogTargetProperty.getLogTarget();
}

::std::string& ManagerStub::getLogTargetMutable() {
    return _LogTargetProperty.getLogTargetMutable();
}

void ManagerStub::sendNNamesUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        NNamesUpdate payload(_NNamesProperty);

        LOG_INFO ("-> send%s", "NNamesUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("NNames", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Manager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "NNamesUpdate");
    }
}

void ManagerStub::onNNamesGet(const ::boost::shared_ptr< NNamesGet >& nNames) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "NNamesGet", nNames->getAct());
    sendNNamesGetUpdate(_NNamesProperty.getNNames(), nNames->getAct());
}

void ManagerStub::sendNNamesGetUpdate(uint32 nNames, act_t act) {
    ::asf::dbus::DBusVariant variant;
    NNamesGet payload(nNames);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "NNamesGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ManagerStub::setNNames(uint32 nNames) {
    if(nNames!=_NNamesProperty.getNNames()) {
        _NNamesProperty.setNNames(nNames);
        sendNNamesUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint32 ManagerStub::getNNames() const {
    return _NNamesProperty.getNNames();
}

void ManagerStub::sendNFailedUnitsUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        NFailedUnitsUpdate payload(_NFailedUnitsProperty);

        LOG_INFO ("-> send%s", "NFailedUnitsUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("NFailedUnits", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Manager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "NFailedUnitsUpdate");
    }
}

void ManagerStub::onNFailedUnitsGet(const ::boost::shared_ptr< NFailedUnitsGet >& nFailedUnits) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "NFailedUnitsGet", nFailedUnits->getAct());
    sendNFailedUnitsGetUpdate(_NFailedUnitsProperty.getNFailedUnits(), nFailedUnits->getAct());
}

void ManagerStub::sendNFailedUnitsGetUpdate(uint32 nFailedUnits, act_t act) {
    ::asf::dbus::DBusVariant variant;
    NFailedUnitsGet payload(nFailedUnits);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "NFailedUnitsGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ManagerStub::setNFailedUnits(uint32 nFailedUnits) {
    if(nFailedUnits!=_NFailedUnitsProperty.getNFailedUnits()) {
        _NFailedUnitsProperty.setNFailedUnits(nFailedUnits);
        sendNFailedUnitsUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint32 ManagerStub::getNFailedUnits() const {
    return _NFailedUnitsProperty.getNFailedUnits();
}

void ManagerStub::sendNJobsUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        NJobsUpdate payload(_NJobsProperty);

        LOG_INFO ("-> send%s", "NJobsUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("NJobs", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Manager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "NJobsUpdate");
    }
}

void ManagerStub::onNJobsGet(const ::boost::shared_ptr< NJobsGet >& nJobs) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "NJobsGet", nJobs->getAct());
    sendNJobsGetUpdate(_NJobsProperty.getNJobs(), nJobs->getAct());
}

void ManagerStub::sendNJobsGetUpdate(uint32 nJobs, act_t act) {
    ::asf::dbus::DBusVariant variant;
    NJobsGet payload(nJobs);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "NJobsGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ManagerStub::setNJobs(uint32 nJobs) {
    if(nJobs!=_NJobsProperty.getNJobs()) {
        _NJobsProperty.setNJobs(nJobs);
        sendNJobsUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint32 ManagerStub::getNJobs() const {
    return _NJobsProperty.getNJobs();
}

void ManagerStub::sendNInstalledJobsUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        NInstalledJobsUpdate payload(_NInstalledJobsProperty);

        LOG_INFO ("-> send%s", "NInstalledJobsUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("NInstalledJobs", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Manager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "NInstalledJobsUpdate");
    }
}

void ManagerStub::onNInstalledJobsGet(const ::boost::shared_ptr< NInstalledJobsGet >& nInstalledJobs) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "NInstalledJobsGet", nInstalledJobs->getAct());
    sendNInstalledJobsGetUpdate(_NInstalledJobsProperty.getNInstalledJobs(), nInstalledJobs->getAct());
}

void ManagerStub::sendNInstalledJobsGetUpdate(uint32 nInstalledJobs, act_t act) {
    ::asf::dbus::DBusVariant variant;
    NInstalledJobsGet payload(nInstalledJobs);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "NInstalledJobsGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ManagerStub::setNInstalledJobs(uint32 nInstalledJobs) {
    if(nInstalledJobs!=_NInstalledJobsProperty.getNInstalledJobs()) {
        _NInstalledJobsProperty.setNInstalledJobs(nInstalledJobs);
        sendNInstalledJobsUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint32 ManagerStub::getNInstalledJobs() const {
    return _NInstalledJobsProperty.getNInstalledJobs();
}

void ManagerStub::sendNFailedJobsUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        NFailedJobsUpdate payload(_NFailedJobsProperty);

        LOG_INFO ("-> send%s", "NFailedJobsUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("NFailedJobs", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Manager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "NFailedJobsUpdate");
    }
}

void ManagerStub::onNFailedJobsGet(const ::boost::shared_ptr< NFailedJobsGet >& nFailedJobs) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "NFailedJobsGet", nFailedJobs->getAct());
    sendNFailedJobsGetUpdate(_NFailedJobsProperty.getNFailedJobs(), nFailedJobs->getAct());
}

void ManagerStub::sendNFailedJobsGetUpdate(uint32 nFailedJobs, act_t act) {
    ::asf::dbus::DBusVariant variant;
    NFailedJobsGet payload(nFailedJobs);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "NFailedJobsGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ManagerStub::setNFailedJobs(uint32 nFailedJobs) {
    if(nFailedJobs!=_NFailedJobsProperty.getNFailedJobs()) {
        _NFailedJobsProperty.setNFailedJobs(nFailedJobs);
        sendNFailedJobsUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint32 ManagerStub::getNFailedJobs() const {
    return _NFailedJobsProperty.getNFailedJobs();
}

void ManagerStub::sendProgressUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ProgressUpdate payload(_ProgressProperty);

        LOG_INFO ("-> send%s", "ProgressUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Progress", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Manager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ProgressUpdate");
    }
}

void ManagerStub::onProgressGet(const ::boost::shared_ptr< ProgressGet >& progress) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ProgressGet", progress->getAct());
    sendProgressGetUpdate(_ProgressProperty.getProgress(), progress->getAct());
}

void ManagerStub::sendProgressGetUpdate(double progress, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ProgressGet payload(progress);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ProgressGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ManagerStub::setProgress(double progress) {
    if(progress!=_ProgressProperty.getProgress()) {
        _ProgressProperty.setProgress(progress);
        sendProgressUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

double ManagerStub::getProgress() const {
    return _ProgressProperty.getProgress();
}

void ManagerStub::sendEnvironmentUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        EnvironmentUpdate payload(_EnvironmentProperty);

        LOG_INFO ("-> send%s", "EnvironmentUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Environment", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Manager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "EnvironmentUpdate");
    }
}

void ManagerStub::onEnvironmentGet(const ::boost::shared_ptr< EnvironmentGet >& environment) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "EnvironmentGet", environment->getAct());
    sendEnvironmentGetUpdate(_EnvironmentProperty.getEnvironment(), environment->getAct());
}

void ManagerStub::sendEnvironmentGetUpdate(const ::std::vector< ::std::string >& environment, act_t act) {
    ::asf::dbus::DBusVariant variant;
    EnvironmentGet payload(environment);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "EnvironmentGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ManagerStub::setEnvironment(const ::std::vector< ::std::string >& environment) {
    if(environment!=_EnvironmentProperty.getEnvironment()) {
        _EnvironmentProperty.setEnvironment(environment);
        sendEnvironmentUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::string >& ManagerStub::getEnvironment() const {
    return _EnvironmentProperty.getEnvironment();
}

::std::vector< ::std::string >& ManagerStub::getEnvironmentMutable() {
    return _EnvironmentProperty.getEnvironmentMutable();
}

void ManagerStub::sendConfirmSpawnUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ConfirmSpawnUpdate payload(_ConfirmSpawnProperty);

        LOG_INFO ("-> send%s", "ConfirmSpawnUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ConfirmSpawn", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Manager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ConfirmSpawnUpdate");
    }
}

void ManagerStub::onConfirmSpawnGet(const ::boost::shared_ptr< ConfirmSpawnGet >& confirmSpawn) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ConfirmSpawnGet", confirmSpawn->getAct());
    sendConfirmSpawnGetUpdate(_ConfirmSpawnProperty.getConfirmSpawn(), confirmSpawn->getAct());
}

void ManagerStub::sendConfirmSpawnGetUpdate(bool confirmSpawn, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ConfirmSpawnGet payload(confirmSpawn);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ConfirmSpawnGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ManagerStub::setConfirmSpawn(bool confirmSpawn) {
    if(confirmSpawn!=_ConfirmSpawnProperty.getConfirmSpawn()) {
        _ConfirmSpawnProperty.setConfirmSpawn(confirmSpawn);
        sendConfirmSpawnUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool ManagerStub::getConfirmSpawn() const {
    return _ConfirmSpawnProperty.getConfirmSpawn();
}

void ManagerStub::sendShowStatusUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ShowStatusUpdate payload(_ShowStatusProperty);

        LOG_INFO ("-> send%s", "ShowStatusUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ShowStatus", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Manager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ShowStatusUpdate");
    }
}

void ManagerStub::onShowStatusGet(const ::boost::shared_ptr< ShowStatusGet >& showStatus) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ShowStatusGet", showStatus->getAct());
    sendShowStatusGetUpdate(_ShowStatusProperty.getShowStatus(), showStatus->getAct());
}

void ManagerStub::sendShowStatusGetUpdate(bool showStatus, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ShowStatusGet payload(showStatus);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ShowStatusGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ManagerStub::setShowStatus(bool showStatus) {
    if(showStatus!=_ShowStatusProperty.getShowStatus()) {
        _ShowStatusProperty.setShowStatus(showStatus);
        sendShowStatusUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool ManagerStub::getShowStatus() const {
    return _ShowStatusProperty.getShowStatus();
}

void ManagerStub::sendUnitPathUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        UnitPathUpdate payload(_UnitPathProperty);

        LOG_INFO ("-> send%s", "UnitPathUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("UnitPath", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Manager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "UnitPathUpdate");
    }
}

void ManagerStub::onUnitPathGet(const ::boost::shared_ptr< UnitPathGet >& unitPath) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "UnitPathGet", unitPath->getAct());
    sendUnitPathGetUpdate(_UnitPathProperty.getUnitPath(), unitPath->getAct());
}

void ManagerStub::sendUnitPathGetUpdate(const ::std::vector< ::std::string >& unitPath, act_t act) {
    ::asf::dbus::DBusVariant variant;
    UnitPathGet payload(unitPath);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "UnitPathGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ManagerStub::setUnitPath(const ::std::vector< ::std::string >& unitPath) {
    if(unitPath!=_UnitPathProperty.getUnitPath()) {
        _UnitPathProperty.setUnitPath(unitPath);
        sendUnitPathUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::string >& ManagerStub::getUnitPath() const {
    return _UnitPathProperty.getUnitPath();
}

::std::vector< ::std::string >& ManagerStub::getUnitPathMutable() {
    return _UnitPathProperty.getUnitPathMutable();
}

void ManagerStub::sendDefaultStandardOutputUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        DefaultStandardOutputUpdate payload(_DefaultStandardOutputProperty);

        LOG_INFO ("-> send%s", "DefaultStandardOutputUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("DefaultStandardOutput", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Manager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "DefaultStandardOutputUpdate");
    }
}

void ManagerStub::onDefaultStandardOutputGet(const ::boost::shared_ptr< DefaultStandardOutputGet >& defaultStandardOutput) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DefaultStandardOutputGet", defaultStandardOutput->getAct());
    sendDefaultStandardOutputGetUpdate(_DefaultStandardOutputProperty.getDefaultStandardOutput(), defaultStandardOutput->getAct());
}

void ManagerStub::sendDefaultStandardOutputGetUpdate(const ::std::string& defaultStandardOutput, act_t act) {
    ::asf::dbus::DBusVariant variant;
    DefaultStandardOutputGet payload(defaultStandardOutput);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DefaultStandardOutputGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ManagerStub::setDefaultStandardOutput(const ::std::string& defaultStandardOutput) {
    if(defaultStandardOutput!=_DefaultStandardOutputProperty.getDefaultStandardOutput()) {
        _DefaultStandardOutputProperty.setDefaultStandardOutput(defaultStandardOutput);
        sendDefaultStandardOutputUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& ManagerStub::getDefaultStandardOutput() const {
    return _DefaultStandardOutputProperty.getDefaultStandardOutput();
}

::std::string& ManagerStub::getDefaultStandardOutputMutable() {
    return _DefaultStandardOutputProperty.getDefaultStandardOutputMutable();
}

void ManagerStub::sendDefaultStandardErrorUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        DefaultStandardErrorUpdate payload(_DefaultStandardErrorProperty);

        LOG_INFO ("-> send%s", "DefaultStandardErrorUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("DefaultStandardError", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Manager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "DefaultStandardErrorUpdate");
    }
}

void ManagerStub::onDefaultStandardErrorGet(const ::boost::shared_ptr< DefaultStandardErrorGet >& defaultStandardError) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DefaultStandardErrorGet", defaultStandardError->getAct());
    sendDefaultStandardErrorGetUpdate(_DefaultStandardErrorProperty.getDefaultStandardError(), defaultStandardError->getAct());
}

void ManagerStub::sendDefaultStandardErrorGetUpdate(const ::std::string& defaultStandardError, act_t act) {
    ::asf::dbus::DBusVariant variant;
    DefaultStandardErrorGet payload(defaultStandardError);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DefaultStandardErrorGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ManagerStub::setDefaultStandardError(const ::std::string& defaultStandardError) {
    if(defaultStandardError!=_DefaultStandardErrorProperty.getDefaultStandardError()) {
        _DefaultStandardErrorProperty.setDefaultStandardError(defaultStandardError);
        sendDefaultStandardErrorUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& ManagerStub::getDefaultStandardError() const {
    return _DefaultStandardErrorProperty.getDefaultStandardError();
}

::std::string& ManagerStub::getDefaultStandardErrorMutable() {
    return _DefaultStandardErrorProperty.getDefaultStandardErrorMutable();
}

void ManagerStub::sendRuntimeWatchdogUSecUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        RuntimeWatchdogUSecUpdate payload(_RuntimeWatchdogUSecProperty);

        LOG_INFO ("-> send%s", "RuntimeWatchdogUSecUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("RuntimeWatchdogUSec", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Manager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "RuntimeWatchdogUSecUpdate");
    }
}

void ManagerStub::onRuntimeWatchdogUSecGet(const ::boost::shared_ptr< RuntimeWatchdogUSecGet >& runtimeWatchdogUSec) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "RuntimeWatchdogUSecGet", runtimeWatchdogUSec->getAct());
    sendRuntimeWatchdogUSecGetUpdate(_RuntimeWatchdogUSecProperty.getRuntimeWatchdogUSec(), runtimeWatchdogUSec->getAct());
}

void ManagerStub::sendRuntimeWatchdogUSecGetUpdate(uint64 runtimeWatchdogUSec, act_t act) {
    ::asf::dbus::DBusVariant variant;
    RuntimeWatchdogUSecGet payload(runtimeWatchdogUSec);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "RuntimeWatchdogUSecGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ManagerStub::onRuntimeWatchdogUSecSet(const ::boost::shared_ptr< RuntimeWatchdogUSecSet >& runtimeWatchdogUSec) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "RuntimeWatchdogUSecSet", runtimeWatchdogUSec->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*runtimeWatchdogUSec, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setRuntimeWatchdogUSec (runtimeWatchdogUSec->getRuntimeWatchdogUSec());
    sendRuntimeWatchdogUSecSetUpdate(runtimeWatchdogUSec->getAct());
}

void ManagerStub::sendRuntimeWatchdogUSecSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "RuntimeWatchdogUSecSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void ManagerStub::setRuntimeWatchdogUSec(uint64 runtimeWatchdogUSec) {
    if(runtimeWatchdogUSec!=_RuntimeWatchdogUSecProperty.getRuntimeWatchdogUSec()) {
        _RuntimeWatchdogUSecProperty.setRuntimeWatchdogUSec(runtimeWatchdogUSec);
        sendRuntimeWatchdogUSecUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ManagerStub::getRuntimeWatchdogUSec() const {
    return _RuntimeWatchdogUSecProperty.getRuntimeWatchdogUSec();
}

void ManagerStub::sendShutdownWatchdogUSecUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ShutdownWatchdogUSecUpdate payload(_ShutdownWatchdogUSecProperty);

        LOG_INFO ("-> send%s", "ShutdownWatchdogUSecUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ShutdownWatchdogUSec", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Manager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ShutdownWatchdogUSecUpdate");
    }
}

void ManagerStub::onShutdownWatchdogUSecGet(const ::boost::shared_ptr< ShutdownWatchdogUSecGet >& shutdownWatchdogUSec) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ShutdownWatchdogUSecGet", shutdownWatchdogUSec->getAct());
    sendShutdownWatchdogUSecGetUpdate(_ShutdownWatchdogUSecProperty.getShutdownWatchdogUSec(), shutdownWatchdogUSec->getAct());
}

void ManagerStub::sendShutdownWatchdogUSecGetUpdate(uint64 shutdownWatchdogUSec, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ShutdownWatchdogUSecGet payload(shutdownWatchdogUSec);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ShutdownWatchdogUSecGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ManagerStub::onShutdownWatchdogUSecSet(const ::boost::shared_ptr< ShutdownWatchdogUSecSet >& shutdownWatchdogUSec) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ShutdownWatchdogUSecSet", shutdownWatchdogUSec->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*shutdownWatchdogUSec, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setShutdownWatchdogUSec (shutdownWatchdogUSec->getShutdownWatchdogUSec());
    sendShutdownWatchdogUSecSetUpdate(shutdownWatchdogUSec->getAct());
}

void ManagerStub::sendShutdownWatchdogUSecSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ShutdownWatchdogUSecSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void ManagerStub::setShutdownWatchdogUSec(uint64 shutdownWatchdogUSec) {
    if(shutdownWatchdogUSec!=_ShutdownWatchdogUSecProperty.getShutdownWatchdogUSec()) {
        _ShutdownWatchdogUSecProperty.setShutdownWatchdogUSec(shutdownWatchdogUSec);
        sendShutdownWatchdogUSecUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 ManagerStub::getShutdownWatchdogUSec() const {
    return _ShutdownWatchdogUSecProperty.getShutdownWatchdogUSec();
}

void ManagerStub::sendControlGroupUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ControlGroupUpdate payload(_ControlGroupProperty);

        LOG_INFO ("-> send%s", "ControlGroupUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ControlGroup", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Manager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ControlGroupUpdate");
    }
}

void ManagerStub::onControlGroupGet(const ::boost::shared_ptr< ControlGroupGet >& controlGroup) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ControlGroupGet", controlGroup->getAct());
    sendControlGroupGetUpdate(_ControlGroupProperty.getControlGroup(), controlGroup->getAct());
}

void ManagerStub::sendControlGroupGetUpdate(const ::std::string& controlGroup, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ControlGroupGet payload(controlGroup);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ControlGroupGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ManagerStub::onControlGroupSet(const ::boost::shared_ptr< ControlGroupSet >& controlGroup) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ControlGroupSet", controlGroup->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*controlGroup, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setControlGroup (controlGroup->getControlGroup());
    sendControlGroupSetUpdate(controlGroup->getAct());
}

void ManagerStub::sendControlGroupSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ControlGroupSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void ManagerStub::setControlGroup(const ::std::string& controlGroup) {
    if(controlGroup!=_ControlGroupProperty.getControlGroup()) {
        _ControlGroupProperty.setControlGroup(controlGroup);
        sendControlGroupUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& ManagerStub::getControlGroup() const {
    return _ControlGroupProperty.getControlGroup();
}

::std::string& ManagerStub::getControlGroupMutable() {
    return _ControlGroupProperty.getControlGroupMutable();
}

void ManagerStub::sendSystemStateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SystemStateUpdate payload(_SystemStateProperty);

        LOG_INFO ("-> send%s", "SystemStateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("SystemState", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.freedesktop.systemd1.Manager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SystemStateUpdate");
    }
}

void ManagerStub::onSystemStateGet(const ::boost::shared_ptr< SystemStateGet >& systemState) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SystemStateGet", systemState->getAct());
    sendSystemStateGetUpdate(_SystemStateProperty.getSystemState(), systemState->getAct());
}

void ManagerStub::sendSystemStateGetUpdate(const ::std::string& systemState, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SystemStateGet payload(systemState);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SystemStateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ManagerStub::onSystemStateSet(const ::boost::shared_ptr< SystemStateSet >& systemState) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SystemStateSet", systemState->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*systemState, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setSystemState (systemState->getSystemState());
    sendSystemStateSetUpdate(systemState->getAct());
}

void ManagerStub::sendSystemStateSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SystemStateSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void ManagerStub::setSystemState(const ::std::string& systemState) {
    if(systemState!=_SystemStateProperty.getSystemState()) {
        _SystemStateProperty.setSystemState(systemState);
        sendSystemStateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& ManagerStub::getSystemState() const {
    return _SystemStateProperty.getSystemState();
}

::std::string& ManagerStub::getSystemStateMutable() {
    return _SystemStateProperty.getSystemStateMutable();
}

void  ManagerStub::sendGetUnitResponse (const ::std::string& unit, act_t act) {
    GetUnitResponse* payload = new GetUnitResponse(unit);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetUnit", GetUnitResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetUnit", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendGetUnitError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetUnitError* payload = new GetUnitError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetUnit", GetUnitError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetUnit", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendGetUnitByPIDResponse (const ::std::string& unit, act_t act) {
    GetUnitByPIDResponse* payload = new GetUnitByPIDResponse(unit);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetUnitByPID", GetUnitByPIDResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetUnitByPID", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendGetUnitByPIDError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetUnitByPIDError* payload = new GetUnitByPIDError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetUnitByPID", GetUnitByPIDError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetUnitByPID", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendLoadUnitResponse (const ::std::string& unit, act_t act) {
    LoadUnitResponse* payload = new LoadUnitResponse(unit);
    DBUS_MESSAGE_REPLY(dbusMessage, "LoadUnit", LoadUnitResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "LoadUnit", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendLoadUnitError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    LoadUnitError* payload = new LoadUnitError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "LoadUnit", LoadUnitError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "LoadUnit", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendStartUnitResponse (const ::std::string& job, act_t act) {
    StartUnitResponse* payload = new StartUnitResponse(job);
    DBUS_MESSAGE_REPLY(dbusMessage, "StartUnit", StartUnitResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "StartUnit", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendStartUnitError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    StartUnitError* payload = new StartUnitError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "StartUnit", StartUnitError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "StartUnit", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendStartUnitReplaceResponse (const ::std::string& job, act_t act) {
    StartUnitReplaceResponse* payload = new StartUnitReplaceResponse(job);
    DBUS_MESSAGE_REPLY(dbusMessage, "StartUnitReplace", StartUnitReplaceResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "StartUnitReplace", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendStartUnitReplaceError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    StartUnitReplaceError* payload = new StartUnitReplaceError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "StartUnitReplace", StartUnitReplaceError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "StartUnitReplace", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendStopUnitResponse (const ::std::string& job, act_t act) {
    StopUnitResponse* payload = new StopUnitResponse(job);
    DBUS_MESSAGE_REPLY(dbusMessage, "StopUnit", StopUnitResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "StopUnit", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendStopUnitError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    StopUnitError* payload = new StopUnitError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "StopUnit", StopUnitError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "StopUnit", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendReloadUnitResponse (const ::std::string& job, act_t act) {
    ReloadUnitResponse* payload = new ReloadUnitResponse(job);
    DBUS_MESSAGE_REPLY(dbusMessage, "ReloadUnit", ReloadUnitResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ReloadUnit", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendReloadUnitError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ReloadUnitError* payload = new ReloadUnitError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ReloadUnit", ReloadUnitError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ReloadUnit", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendRestartUnitResponse (const ::std::string& job, act_t act) {
    RestartUnitResponse* payload = new RestartUnitResponse(job);
    DBUS_MESSAGE_REPLY(dbusMessage, "RestartUnit", RestartUnitResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RestartUnit", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendRestartUnitError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RestartUnitError* payload = new RestartUnitError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "RestartUnit", RestartUnitError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RestartUnit", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendTryRestartUnitResponse (const ::std::string& job, act_t act) {
    TryRestartUnitResponse* payload = new TryRestartUnitResponse(job);
    DBUS_MESSAGE_REPLY(dbusMessage, "TryRestartUnit", TryRestartUnitResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "TryRestartUnit", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendTryRestartUnitError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    TryRestartUnitError* payload = new TryRestartUnitError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "TryRestartUnit", TryRestartUnitError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "TryRestartUnit", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendReloadOrRestartUnitResponse (const ::std::string& job, act_t act) {
    ReloadOrRestartUnitResponse* payload = new ReloadOrRestartUnitResponse(job);
    DBUS_MESSAGE_REPLY(dbusMessage, "ReloadOrRestartUnit", ReloadOrRestartUnitResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ReloadOrRestartUnit", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendReloadOrRestartUnitError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ReloadOrRestartUnitError* payload = new ReloadOrRestartUnitError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ReloadOrRestartUnit", ReloadOrRestartUnitError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ReloadOrRestartUnit", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendReloadOrTryRestartUnitResponse (const ::std::string& job, act_t act) {
    ReloadOrTryRestartUnitResponse* payload = new ReloadOrTryRestartUnitResponse(job);
    DBUS_MESSAGE_REPLY(dbusMessage, "ReloadOrTryRestartUnit", ReloadOrTryRestartUnitResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ReloadOrTryRestartUnit", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendReloadOrTryRestartUnitError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ReloadOrTryRestartUnitError* payload = new ReloadOrTryRestartUnitError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ReloadOrTryRestartUnit", ReloadOrTryRestartUnitError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ReloadOrTryRestartUnit", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendKillUnitResponse (act_t act) {
    KillUnitResponse* payload = new KillUnitResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "KillUnit", KillUnitResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "KillUnit", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendKillUnitError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    KillUnitError* payload = new KillUnitError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "KillUnit", KillUnitError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "KillUnit", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendResetFailedUnitResponse (act_t act) {
    ResetFailedUnitResponse* payload = new ResetFailedUnitResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "ResetFailedUnit", ResetFailedUnitResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ResetFailedUnit", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendResetFailedUnitError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ResetFailedUnitError* payload = new ResetFailedUnitError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ResetFailedUnit", ResetFailedUnitError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ResetFailedUnit", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendSetUnitPropertiesResponse (act_t act) {
    SetUnitPropertiesResponse* payload = new SetUnitPropertiesResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "SetUnitProperties", SetUnitPropertiesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetUnitProperties", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendSetUnitPropertiesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetUnitPropertiesError* payload = new SetUnitPropertiesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SetUnitProperties", SetUnitPropertiesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetUnitProperties", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendStartTransientUnitResponse (const ::std::string& job, act_t act) {
    StartTransientUnitResponse* payload = new StartTransientUnitResponse(job);
    DBUS_MESSAGE_REPLY(dbusMessage, "StartTransientUnit", StartTransientUnitResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "StartTransientUnit", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendStartTransientUnitError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    StartTransientUnitError* payload = new StartTransientUnitError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "StartTransientUnit", StartTransientUnitError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "StartTransientUnit", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendGetJobResponse (const ::std::string& job, act_t act) {
    GetJobResponse* payload = new GetJobResponse(job);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetJob", GetJobResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetJob", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendGetJobError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetJobError* payload = new GetJobError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetJob", GetJobError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetJob", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendCancelJobResponse (act_t act) {
    CancelJobResponse* payload = new CancelJobResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "CancelJob", CancelJobResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "CancelJob", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendCancelJobError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    CancelJobError* payload = new CancelJobError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "CancelJob", CancelJobError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "CancelJob", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendClearJobsResponse (act_t act) {
    ClearJobsResponse* payload = new ClearJobsResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "ClearJobs", ClearJobsResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ClearJobs", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendClearJobsError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ClearJobsError* payload = new ClearJobsError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ClearJobs", ClearJobsError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ClearJobs", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendResetFailedResponse (act_t act) {
    ResetFailedResponse* payload = new ResetFailedResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "ResetFailed", ResetFailedResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ResetFailed", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendResetFailedError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ResetFailedError* payload = new ResetFailedError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ResetFailed", ResetFailedError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ResetFailed", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendListUnitsResponse (const ::std::vector< units >& units, act_t act) {
    ListUnitsResponse* payload = new ListUnitsResponse(units);
    DBUS_MESSAGE_REPLY(dbusMessage, "ListUnits", ListUnitsResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ListUnits", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendListUnitsError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ListUnitsError* payload = new ListUnitsError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ListUnits", ListUnitsError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ListUnits", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendListUnitsFilteredResponse (const ::std::vector< units >& units, act_t act) {
    ListUnitsFilteredResponse* payload = new ListUnitsFilteredResponse(units);
    DBUS_MESSAGE_REPLY(dbusMessage, "ListUnitsFiltered", ListUnitsFilteredResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ListUnitsFiltered", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendListUnitsFilteredError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ListUnitsFilteredError* payload = new ListUnitsFilteredError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ListUnitsFiltered", ListUnitsFilteredError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ListUnitsFiltered", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendListJobsResponse (const ::std::vector< jobs >& jobs, act_t act) {
    ListJobsResponse* payload = new ListJobsResponse(jobs);
    DBUS_MESSAGE_REPLY(dbusMessage, "ListJobs", ListJobsResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ListJobs", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendListJobsError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ListJobsError* payload = new ListJobsError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ListJobs", ListJobsError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ListJobs", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendSubscribeResponse (act_t act) {
    SubscribeResponse* payload = new SubscribeResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "Subscribe", SubscribeResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Subscribe", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendSubscribeError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SubscribeError* payload = new SubscribeError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Subscribe", SubscribeError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Subscribe", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendUnsubscribeResponse (act_t act) {
    UnsubscribeResponse* payload = new UnsubscribeResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "Unsubscribe", UnsubscribeResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Unsubscribe", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendUnsubscribeError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    UnsubscribeError* payload = new UnsubscribeError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Unsubscribe", UnsubscribeError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Unsubscribe", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendDumpResponse (const ::std::string& dump, act_t act) {
    DumpResponse* payload = new DumpResponse(dump);
    DBUS_MESSAGE_REPLY(dbusMessage, "Dump", DumpResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Dump", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendDumpError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    DumpError* payload = new DumpError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Dump", DumpError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Dump", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendCreateSnapshotResponse (const ::std::string& unit, act_t act) {
    CreateSnapshotResponse* payload = new CreateSnapshotResponse(unit);
    DBUS_MESSAGE_REPLY(dbusMessage, "CreateSnapshot", CreateSnapshotResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "CreateSnapshot", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendCreateSnapshotError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    CreateSnapshotError* payload = new CreateSnapshotError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "CreateSnapshot", CreateSnapshotError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "CreateSnapshot", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendRemoveSnapshotResponse (act_t act) {
    RemoveSnapshotResponse* payload = new RemoveSnapshotResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "RemoveSnapshot", RemoveSnapshotResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RemoveSnapshot", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendRemoveSnapshotError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RemoveSnapshotError* payload = new RemoveSnapshotError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "RemoveSnapshot", RemoveSnapshotError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RemoveSnapshot", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendReloadResponse (act_t act) {
    ReloadResponse* payload = new ReloadResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "Reload", ReloadResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Reload", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendReloadError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ReloadError* payload = new ReloadError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Reload", ReloadError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Reload", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendReexecuteResponse (act_t act) {
    ReexecuteResponse* payload = new ReexecuteResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "Reexecute", ReexecuteResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Reexecute", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendReexecuteError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ReexecuteError* payload = new ReexecuteError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Reexecute", ReexecuteError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Reexecute", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendExitResponse (act_t act) {
    ExitResponse* payload = new ExitResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "Exit", ExitResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Exit", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendExitError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ExitError* payload = new ExitError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Exit", ExitError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Exit", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendRebootResponse (act_t act) {
    RebootResponse* payload = new RebootResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "Reboot", RebootResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Reboot", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendRebootError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RebootError* payload = new RebootError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Reboot", RebootError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Reboot", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendPowerOffResponse (act_t act) {
    PowerOffResponse* payload = new PowerOffResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "PowerOff", PowerOffResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "PowerOff", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendPowerOffError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    PowerOffError* payload = new PowerOffError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "PowerOff", PowerOffError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "PowerOff", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendHaltResponse (act_t act) {
    HaltResponse* payload = new HaltResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "Halt", HaltResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Halt", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendHaltError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    HaltError* payload = new HaltError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Halt", HaltError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Halt", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendKExecResponse (act_t act) {
    KExecResponse* payload = new KExecResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "KExec", KExecResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "KExec", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendKExecError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    KExecError* payload = new KExecError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "KExec", KExecError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "KExec", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendSwitchRootResponse (act_t act) {
    SwitchRootResponse* payload = new SwitchRootResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "SwitchRoot", SwitchRootResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SwitchRoot", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendSwitchRootError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SwitchRootError* payload = new SwitchRootError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SwitchRoot", SwitchRootError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SwitchRoot", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendSetEnvironmentResponse (act_t act) {
    SetEnvironmentResponse* payload = new SetEnvironmentResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "SetEnvironment", SetEnvironmentResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetEnvironment", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendSetEnvironmentError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetEnvironmentError* payload = new SetEnvironmentError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SetEnvironment", SetEnvironmentError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetEnvironment", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendUnsetEnvironmentResponse (act_t act) {
    UnsetEnvironmentResponse* payload = new UnsetEnvironmentResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "UnsetEnvironment", UnsetEnvironmentResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "UnsetEnvironment", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendUnsetEnvironmentError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    UnsetEnvironmentError* payload = new UnsetEnvironmentError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "UnsetEnvironment", UnsetEnvironmentError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "UnsetEnvironment", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendUnsetAndSetEnvironmentResponse (act_t act) {
    UnsetAndSetEnvironmentResponse* payload = new UnsetAndSetEnvironmentResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "UnsetAndSetEnvironment", UnsetAndSetEnvironmentResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "UnsetAndSetEnvironment", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendUnsetAndSetEnvironmentError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    UnsetAndSetEnvironmentError* payload = new UnsetAndSetEnvironmentError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "UnsetAndSetEnvironment", UnsetAndSetEnvironmentError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "UnsetAndSetEnvironment", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendListUnitFilesResponse (const ::std::vector< files >& files, act_t act) {
    ListUnitFilesResponse* payload = new ListUnitFilesResponse(files);
    DBUS_MESSAGE_REPLY(dbusMessage, "ListUnitFiles", ListUnitFilesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ListUnitFiles", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendListUnitFilesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ListUnitFilesError* payload = new ListUnitFilesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ListUnitFiles", ListUnitFilesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ListUnitFiles", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendGetUnitFileStateResponse (const ::std::string& state, act_t act) {
    GetUnitFileStateResponse* payload = new GetUnitFileStateResponse(state);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetUnitFileState", GetUnitFileStateResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetUnitFileState", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendGetUnitFileStateError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetUnitFileStateError* payload = new GetUnitFileStateError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetUnitFileState", GetUnitFileStateError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetUnitFileState", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendEnableUnitFilesResponse (bool carries_install_info, const ::std::vector< changes >& changes, act_t act) {
    EnableUnitFilesResponse* payload = new EnableUnitFilesResponse(carries_install_info, changes);
    DBUS_MESSAGE_REPLY(dbusMessage, "EnableUnitFiles", EnableUnitFilesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "EnableUnitFiles", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendEnableUnitFilesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    EnableUnitFilesError* payload = new EnableUnitFilesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "EnableUnitFiles", EnableUnitFilesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "EnableUnitFiles", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendDisableUnitFilesResponse (const ::std::vector< changes >& changes, act_t act) {
    DisableUnitFilesResponse* payload = new DisableUnitFilesResponse(changes);
    DBUS_MESSAGE_REPLY(dbusMessage, "DisableUnitFiles", DisableUnitFilesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "DisableUnitFiles", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendDisableUnitFilesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    DisableUnitFilesError* payload = new DisableUnitFilesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "DisableUnitFiles", DisableUnitFilesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "DisableUnitFiles", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendReenableUnitFilesResponse (bool carries_install_info, const ::std::vector< changes >& changes, act_t act) {
    ReenableUnitFilesResponse* payload = new ReenableUnitFilesResponse(carries_install_info, changes);
    DBUS_MESSAGE_REPLY(dbusMessage, "ReenableUnitFiles", ReenableUnitFilesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ReenableUnitFiles", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendReenableUnitFilesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ReenableUnitFilesError* payload = new ReenableUnitFilesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ReenableUnitFiles", ReenableUnitFilesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ReenableUnitFiles", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendLinkUnitFilesResponse (const ::std::vector< changes >& changes, act_t act) {
    LinkUnitFilesResponse* payload = new LinkUnitFilesResponse(changes);
    DBUS_MESSAGE_REPLY(dbusMessage, "LinkUnitFiles", LinkUnitFilesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "LinkUnitFiles", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendLinkUnitFilesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    LinkUnitFilesError* payload = new LinkUnitFilesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "LinkUnitFiles", LinkUnitFilesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "LinkUnitFiles", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendPresetUnitFilesResponse (bool carries_install_info, const ::std::vector< changes >& changes, act_t act) {
    PresetUnitFilesResponse* payload = new PresetUnitFilesResponse(carries_install_info, changes);
    DBUS_MESSAGE_REPLY(dbusMessage, "PresetUnitFiles", PresetUnitFilesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "PresetUnitFiles", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendPresetUnitFilesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    PresetUnitFilesError* payload = new PresetUnitFilesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "PresetUnitFiles", PresetUnitFilesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "PresetUnitFiles", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendPresetUnitFilesWithModeResponse (bool carries_install_info, const ::std::vector< changes >& changes, act_t act) {
    PresetUnitFilesWithModeResponse* payload = new PresetUnitFilesWithModeResponse(carries_install_info, changes);
    DBUS_MESSAGE_REPLY(dbusMessage, "PresetUnitFilesWithMode", PresetUnitFilesWithModeResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "PresetUnitFilesWithMode", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendPresetUnitFilesWithModeError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    PresetUnitFilesWithModeError* payload = new PresetUnitFilesWithModeError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "PresetUnitFilesWithMode", PresetUnitFilesWithModeError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "PresetUnitFilesWithMode", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendMaskUnitFilesResponse (const ::std::vector< changes >& changes, act_t act) {
    MaskUnitFilesResponse* payload = new MaskUnitFilesResponse(changes);
    DBUS_MESSAGE_REPLY(dbusMessage, "MaskUnitFiles", MaskUnitFilesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "MaskUnitFiles", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendMaskUnitFilesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    MaskUnitFilesError* payload = new MaskUnitFilesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "MaskUnitFiles", MaskUnitFilesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "MaskUnitFiles", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendUnmaskUnitFilesResponse (const ::std::vector< changes >& changes, act_t act) {
    UnmaskUnitFilesResponse* payload = new UnmaskUnitFilesResponse(changes);
    DBUS_MESSAGE_REPLY(dbusMessage, "UnmaskUnitFiles", UnmaskUnitFilesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "UnmaskUnitFiles", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendUnmaskUnitFilesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    UnmaskUnitFilesError* payload = new UnmaskUnitFilesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "UnmaskUnitFiles", UnmaskUnitFilesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "UnmaskUnitFiles", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendSetDefaultTargetResponse (const ::std::vector< changes >& changes, act_t act) {
    SetDefaultTargetResponse* payload = new SetDefaultTargetResponse(changes);
    DBUS_MESSAGE_REPLY(dbusMessage, "SetDefaultTarget", SetDefaultTargetResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetDefaultTarget", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendSetDefaultTargetError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetDefaultTargetError* payload = new SetDefaultTargetError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SetDefaultTarget", SetDefaultTargetError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetDefaultTarget", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendGetDefaultTargetResponse (const ::std::string& targetName, act_t act) {
    GetDefaultTargetResponse* payload = new GetDefaultTargetResponse(targetName);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetDefaultTarget", GetDefaultTargetResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetDefaultTarget", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendGetDefaultTargetError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetDefaultTargetError* payload = new GetDefaultTargetError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetDefaultTarget", GetDefaultTargetError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetDefaultTarget", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendPresetAllUnitFilesResponse (const ::std::vector< changes >& changes, act_t act) {
    PresetAllUnitFilesResponse* payload = new PresetAllUnitFilesResponse(changes);
    DBUS_MESSAGE_REPLY(dbusMessage, "PresetAllUnitFiles", PresetAllUnitFilesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "PresetAllUnitFiles", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendPresetAllUnitFilesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    PresetAllUnitFilesError* payload = new PresetAllUnitFilesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "PresetAllUnitFiles", PresetAllUnitFilesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "PresetAllUnitFiles", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendAddDependencyUnitFilesResponse (const ::std::vector< changes >& changes, act_t act) {
    AddDependencyUnitFilesResponse* payload = new AddDependencyUnitFilesResponse(changes);
    DBUS_MESSAGE_REPLY(dbusMessage, "AddDependencyUnitFiles", AddDependencyUnitFilesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "AddDependencyUnitFiles", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendAddDependencyUnitFilesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    AddDependencyUnitFilesError* payload = new AddDependencyUnitFilesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "AddDependencyUnitFiles", AddDependencyUnitFilesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "AddDependencyUnitFiles", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void ManagerStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'Version'
    {
        ::asf::dbus::DBusVariant variant;
        VersionGet payload(_VersionProperty.getVersion());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Version", variant));
    }

    //property 'Features'
    {
        ::asf::dbus::DBusVariant variant;
        FeaturesGet payload(_FeaturesProperty.getFeatures());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Features", variant));
    }

    //property 'Virtualization'
    {
        ::asf::dbus::DBusVariant variant;
        VirtualizationGet payload(_VirtualizationProperty.getVirtualization());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Virtualization", variant));
    }

    //property 'Architecture'
    {
        ::asf::dbus::DBusVariant variant;
        ArchitectureGet payload(_ArchitectureProperty.getArchitecture());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Architecture", variant));
    }

    //property 'Tainted'
    {
        ::asf::dbus::DBusVariant variant;
        TaintedGet payload(_TaintedProperty.getTainted());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Tainted", variant));
    }

    //property 'FirmwareTimestamp'
    {
        ::asf::dbus::DBusVariant variant;
        FirmwareTimestampGet payload(_FirmwareTimestampProperty.getFirmwareTimestamp());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("FirmwareTimestamp", variant));
    }

    //property 'FirmwareTimestampMonotonic'
    {
        ::asf::dbus::DBusVariant variant;
        FirmwareTimestampMonotonicGet payload(_FirmwareTimestampMonotonicProperty.getFirmwareTimestampMonotonic());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("FirmwareTimestampMonotonic", variant));
    }

    //property 'LoaderTimestamp'
    {
        ::asf::dbus::DBusVariant variant;
        LoaderTimestampGet payload(_LoaderTimestampProperty.getLoaderTimestamp());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("LoaderTimestamp", variant));
    }

    //property 'LoaderTimestampMonotonic'
    {
        ::asf::dbus::DBusVariant variant;
        LoaderTimestampMonotonicGet payload(_LoaderTimestampMonotonicProperty.getLoaderTimestampMonotonic());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("LoaderTimestampMonotonic", variant));
    }

    //property 'KernelTimestamp'
    {
        ::asf::dbus::DBusVariant variant;
        KernelTimestampGet payload(_KernelTimestampProperty.getKernelTimestamp());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("KernelTimestamp", variant));
    }

    //property 'KernelTimestampMonotonic'
    {
        ::asf::dbus::DBusVariant variant;
        KernelTimestampMonotonicGet payload(_KernelTimestampMonotonicProperty.getKernelTimestampMonotonic());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("KernelTimestampMonotonic", variant));
    }

    //property 'InitRDTimestamp'
    {
        ::asf::dbus::DBusVariant variant;
        InitRDTimestampGet payload(_InitRDTimestampProperty.getInitRDTimestamp());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("InitRDTimestamp", variant));
    }

    //property 'InitRDTimestampMonotonic'
    {
        ::asf::dbus::DBusVariant variant;
        InitRDTimestampMonotonicGet payload(_InitRDTimestampMonotonicProperty.getInitRDTimestampMonotonic());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("InitRDTimestampMonotonic", variant));
    }

    //property 'UserspaceTimestamp'
    {
        ::asf::dbus::DBusVariant variant;
        UserspaceTimestampGet payload(_UserspaceTimestampProperty.getUserspaceTimestamp());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("UserspaceTimestamp", variant));
    }

    //property 'UserspaceTimestampMonotonic'
    {
        ::asf::dbus::DBusVariant variant;
        UserspaceTimestampMonotonicGet payload(_UserspaceTimestampMonotonicProperty.getUserspaceTimestampMonotonic());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("UserspaceTimestampMonotonic", variant));
    }

    //property 'FinishTimestamp'
    {
        ::asf::dbus::DBusVariant variant;
        FinishTimestampGet payload(_FinishTimestampProperty.getFinishTimestamp());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("FinishTimestamp", variant));
    }

    //property 'FinishTimestampMonotonic'
    {
        ::asf::dbus::DBusVariant variant;
        FinishTimestampMonotonicGet payload(_FinishTimestampMonotonicProperty.getFinishTimestampMonotonic());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("FinishTimestampMonotonic", variant));
    }

    //property 'SecurityStartTimestamp'
    {
        ::asf::dbus::DBusVariant variant;
        SecurityStartTimestampGet payload(_SecurityStartTimestampProperty.getSecurityStartTimestamp());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("SecurityStartTimestamp", variant));
    }

    //property 'SecurityStartTimestampMonotonic'
    {
        ::asf::dbus::DBusVariant variant;
        SecurityStartTimestampMonotonicGet payload(_SecurityStartTimestampMonotonicProperty.getSecurityStartTimestampMonotonic());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("SecurityStartTimestampMonotonic", variant));
    }

    //property 'SecurityFinishTimestamp'
    {
        ::asf::dbus::DBusVariant variant;
        SecurityFinishTimestampGet payload(_SecurityFinishTimestampProperty.getSecurityFinishTimestamp());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("SecurityFinishTimestamp", variant));
    }

    //property 'SecurityFinishTimestampMonotonic'
    {
        ::asf::dbus::DBusVariant variant;
        SecurityFinishTimestampMonotonicGet payload(_SecurityFinishTimestampMonotonicProperty.getSecurityFinishTimestampMonotonic());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("SecurityFinishTimestampMonotonic", variant));
    }

    //property 'GeneratorsStartTimestamp'
    {
        ::asf::dbus::DBusVariant variant;
        GeneratorsStartTimestampGet payload(_GeneratorsStartTimestampProperty.getGeneratorsStartTimestamp());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("GeneratorsStartTimestamp", variant));
    }

    //property 'GeneratorsStartTimestampMonotonic'
    {
        ::asf::dbus::DBusVariant variant;
        GeneratorsStartTimestampMonotonicGet payload(_GeneratorsStartTimestampMonotonicProperty.getGeneratorsStartTimestampMonotonic());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("GeneratorsStartTimestampMonotonic", variant));
    }

    //property 'GeneratorsFinishTimestamp'
    {
        ::asf::dbus::DBusVariant variant;
        GeneratorsFinishTimestampGet payload(_GeneratorsFinishTimestampProperty.getGeneratorsFinishTimestamp());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("GeneratorsFinishTimestamp", variant));
    }

    //property 'GeneratorsFinishTimestampMonotonic'
    {
        ::asf::dbus::DBusVariant variant;
        GeneratorsFinishTimestampMonotonicGet payload(_GeneratorsFinishTimestampMonotonicProperty.getGeneratorsFinishTimestampMonotonic());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("GeneratorsFinishTimestampMonotonic", variant));
    }

    //property 'UnitsLoadStartTimestamp'
    {
        ::asf::dbus::DBusVariant variant;
        UnitsLoadStartTimestampGet payload(_UnitsLoadStartTimestampProperty.getUnitsLoadStartTimestamp());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("UnitsLoadStartTimestamp", variant));
    }

    //property 'UnitsLoadStartTimestampMonotonic'
    {
        ::asf::dbus::DBusVariant variant;
        UnitsLoadStartTimestampMonotonicGet payload(_UnitsLoadStartTimestampMonotonicProperty.getUnitsLoadStartTimestampMonotonic());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("UnitsLoadStartTimestampMonotonic", variant));
    }

    //property 'UnitsLoadFinishTimestamp'
    {
        ::asf::dbus::DBusVariant variant;
        UnitsLoadFinishTimestampGet payload(_UnitsLoadFinishTimestampProperty.getUnitsLoadFinishTimestamp());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("UnitsLoadFinishTimestamp", variant));
    }

    //property 'UnitsLoadFinishTimestampMonotonic'
    {
        ::asf::dbus::DBusVariant variant;
        UnitsLoadFinishTimestampMonotonicGet payload(_UnitsLoadFinishTimestampMonotonicProperty.getUnitsLoadFinishTimestampMonotonic());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("UnitsLoadFinishTimestampMonotonic", variant));
    }

    //property 'LogLevel'
    {
        ::asf::dbus::DBusVariant variant;
        LogLevelGet payload(_LogLevelProperty.getLogLevel());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("LogLevel", variant));
    }

    //property 'LogTarget'
    {
        ::asf::dbus::DBusVariant variant;
        LogTargetGet payload(_LogTargetProperty.getLogTarget());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("LogTarget", variant));
    }

    //property 'NNames'
    {
        ::asf::dbus::DBusVariant variant;
        NNamesGet payload(_NNamesProperty.getNNames());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("NNames", variant));
    }

    //property 'NFailedUnits'
    {
        ::asf::dbus::DBusVariant variant;
        NFailedUnitsGet payload(_NFailedUnitsProperty.getNFailedUnits());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("NFailedUnits", variant));
    }

    //property 'NJobs'
    {
        ::asf::dbus::DBusVariant variant;
        NJobsGet payload(_NJobsProperty.getNJobs());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("NJobs", variant));
    }

    //property 'NInstalledJobs'
    {
        ::asf::dbus::DBusVariant variant;
        NInstalledJobsGet payload(_NInstalledJobsProperty.getNInstalledJobs());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("NInstalledJobs", variant));
    }

    //property 'NFailedJobs'
    {
        ::asf::dbus::DBusVariant variant;
        NFailedJobsGet payload(_NFailedJobsProperty.getNFailedJobs());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("NFailedJobs", variant));
    }

    //property 'Progress'
    {
        ::asf::dbus::DBusVariant variant;
        ProgressGet payload(_ProgressProperty.getProgress());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Progress", variant));
    }

    //property 'Environment'
    {
        ::asf::dbus::DBusVariant variant;
        EnvironmentGet payload(_EnvironmentProperty.getEnvironment());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Environment", variant));
    }

    //property 'ConfirmSpawn'
    {
        ::asf::dbus::DBusVariant variant;
        ConfirmSpawnGet payload(_ConfirmSpawnProperty.getConfirmSpawn());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ConfirmSpawn", variant));
    }

    //property 'ShowStatus'
    {
        ::asf::dbus::DBusVariant variant;
        ShowStatusGet payload(_ShowStatusProperty.getShowStatus());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ShowStatus", variant));
    }

    //property 'UnitPath'
    {
        ::asf::dbus::DBusVariant variant;
        UnitPathGet payload(_UnitPathProperty.getUnitPath());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("UnitPath", variant));
    }

    //property 'DefaultStandardOutput'
    {
        ::asf::dbus::DBusVariant variant;
        DefaultStandardOutputGet payload(_DefaultStandardOutputProperty.getDefaultStandardOutput());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("DefaultStandardOutput", variant));
    }

    //property 'DefaultStandardError'
    {
        ::asf::dbus::DBusVariant variant;
        DefaultStandardErrorGet payload(_DefaultStandardErrorProperty.getDefaultStandardError());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("DefaultStandardError", variant));
    }

    //property 'RuntimeWatchdogUSec'
    {
        ::asf::dbus::DBusVariant variant;
        RuntimeWatchdogUSecGet payload(_RuntimeWatchdogUSecProperty.getRuntimeWatchdogUSec());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("RuntimeWatchdogUSec", variant));
    }

    //property 'ShutdownWatchdogUSec'
    {
        ::asf::dbus::DBusVariant variant;
        ShutdownWatchdogUSecGet payload(_ShutdownWatchdogUSecProperty.getShutdownWatchdogUSec());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ShutdownWatchdogUSec", variant));
    }

    //property 'ControlGroup'
    {
        ::asf::dbus::DBusVariant variant;
        ControlGroupGet payload(_ControlGroupProperty.getControlGroup());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ControlGroup", variant));
    }

    //property 'SystemState'
    {
        ::asf::dbus::DBusVariant variant;
        SystemStateGet payload(_SystemStateProperty.getSystemState());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("SystemState", variant));
    }
}

} // namespace Manager
} // namespace systemd1
} // namespace freedesktop
} // namespace org
